import glob
import setuptools

with open("ReadMe.md", "r") as f:
    long_description = f.read()

with open("requirements.txt", "r", encoding="UTF-16") as f:
    required = f.readlines()

setuptools.setup(
    name="LSystemRenderer",
    version="0.0.8",
    author="A-Bak",
    author_email="adam.bak.work@gmail.com",
    description="Display images generated by L-Systems.",
    long_description=long_description,
    long_description_content_type="text/markdown",
    keywords="l-system generative-art image-generation grammar renderer",
    url="https://github.com/A-Bak/l-system",
    packages=setuptools.find_packages(),
    data_files=[("conf", glob.glob("conf/*/*.*"))],
    python_requires=">=3.6",
    install_requires=required,
    classifiers=[
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
    ],
    entry_points={
        "console_scripts": [
            "lsystem-gui=scripts.gui:main",
        ],
    },
)
