# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['positions_backtester']

package_data = \
{'': ['*']}

install_requires = \
['pandas>=1.4.0,<2.0.0']

setup_kwargs = {
    'name': 'positions-backtester',
    'version': '0.1.2',
    'description': 'Package to backtest trading strategies (dataframe with positions) with execution costs modeling',
    'long_description': '=====================\npositions_backtester\n=====================\n\n.. image:: https://img.shields.io/github/last-commit/stas-prokopiev/positions_backtester\n   :target: https://img.shields.io/github/last-commit/stas-prokopiev/positions_backtester\n   :alt: GitHub last commit\n\n.. image:: https://img.shields.io/github/license/stas-prokopiev/positions_backtester\n    :target: https://github.com/stas-prokopiev/positions_backtester/blob/master/LICENSE.txt\n    :alt: GitHub license<space><space>\n\n.. image:: https://img.shields.io/pypi/v/positions_backtester\n   :target: https://img.shields.io/pypi/v/positions_backtester\n   :alt: PyPI\n\n.. image:: https://img.shields.io/pypi/pyversions/positions_backtester\n   :target: https://img.shields.io/pypi/pyversions/positions_backtester\n   :alt: PyPI - Python Version\n\n\n.. contents:: **Table of Contents**\n\nShort Overview.\n=========================\npositions_backtester is a python package (**py>=3.7**) to backtest trading strategies (dataframe with positions) with execution costs modeling\n\n| This package is trying to solve problem of slow trading with fast data.\n| Let\'s say that you want to update your trading position once in a hour, day, week, ...\n| But you have data with much higher resolution - minutes, seconds, miliseconds\n| Then you can give the wanted positions dataframe with the tick with which you want to trade\n| And higher resolution will be used to calculate approximate execution prices\n| Which will be just mean price over execution time period\n\nInstallation via pip:\n======================\n\n.. code-block:: bash\n\n    pip install positions_backtester\n\nHow to use it\n===========================\n\nCreate Backtester\n----------------------\n\n.. code-block:: python\n\n    from positions_backtester import Backtester\n\n    backtester = Backtester(float_percent_const_trading_fees=0.01,)\n\nHow to backtest your dataframe with positions\n-----------------------------------------------\n\n.. code-block:: python\n\n    from positions_backtester import Backtester\n\n    df_backtest_res = backtester.backtest(\n        df_positions_short,\n        df_prices_full,\n        is_to_neutralize=True,\n        td_trading_delay=None,\n        td_execution_duration=None,\n    )\n\nArguments:\n\n#. **df_positions_short**:\n    | pd.DataFrame\n    | Positions we want to take with the frequency with which we want to change our positions\n#. **df_prices_full**:\n    | pd.DataFrame\n    | Prices of assets in higher resolution\n    | Higher resolution needed for better execution evaluation\n#. **is_to_neutralize=True,**:\n    | Flag if to have long-short equal positions\n#. **td_trading_delay=None**:\n    | datetime.timedelta\n    | Delay needed to calculate the wanted positions\n#. **td_execution_duration**:\n    | datetime.timedelta\n    | How long should the execution take\n    | Execution price will be the mean price over execution time period\n\n\nInputs:\n-----------------------------------------------\n\ndf_positions_short\n^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\n\n..\n    raw:: html\n\n    <embed>\n        <table border="1" class="dataframe">\n        <thead>\n            <tr style="text-align: right;">\n            <th></th>\n            <th>asset_1</th>\n            <th>asset_2</th>\n            <th>asset_3</th>\n            </tr>\n            <tr>\n            <th>Close datetime</th>\n            <th></th>\n            <th></th>\n            <th></th>\n            </tr>\n        </thead>\n        <tbody>\n            <tr>\n            <th>2021-07-06 22:00:00+00:00</th>\n            <td>0.285602</td>\n            <td>NaN</td>\n            <td>NaN</td>\n            </tr>\n            <tr>\n            <th>2021-07-06 23:00:00+00:00</th>\n            <td>0.296204</td>\n            <td>NaN</td>\n            <td>NaN</td>\n            </tr>\n            <tr>\n            <th>2021-07-07 00:00:00+00:00</th>\n            <td>0.294426</td>\n            <td>NaN</td>\n            <td>NaN</td>\n            </tr>\n        </tbody>\n        </table>\n    </embed>\n\n\ndf_prices_full\n^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\n\n..\n    raw:: html\n\n    <embed>\n        <table border="1" class="dataframe">\n        <thead>\n            <tr style="text-align: right;">\n            <th></th>\n            <th>asset_1</th>\n            <th>asset_2</th>\n            <th>asset_3</th>\n            </tr>\n            <tr>\n            <th>Close datetime</th>\n            <th></th>\n            <th></th>\n            <th></th>\n            </tr>\n        </thead>\n        <tbody>\n            <tr>\n            <th>2021-07-06 23:57:59+00:00</th>\n            <td>317.86</td>\n            <td>57.00</td>\n            <td>15.488</td>\n            </tr>\n            <tr>\n            <th>2021-07-06 23:58:59+00:00</th>\n            <td>317.11</td>\n            <td>57.04</td>\n            <td>15.480</td>\n            </tr>\n            <tr>\n            <th>2021-07-06 23:59:59+00:00</th>\n            <td>316.49</td>\n            <td>57.01</td>\n            <td>15.459</td>\n            </tr>\n        </tbody>\n        </table>\n    </embed>\n\n\nOutput: df_backtest_res\n-----------------------------------------------\n\n..\n    raw:: html\n\n    <embed>\n        <table border="1" class="dataframe">\n        <thead>\n            <tr style="text-align: right;">\n            <th></th>\n            <th>PNL_before_costs</th>\n            <th>execution_fee_pnl</th>\n            <th>trading_volume</th>\n            <th>const_trading_fee_pnl</th>\n            <th>PNL_after_costs</th>\n            <th>PNL_half_costs</th>\n            <th>booksize</th>\n            </tr>\n            <tr>\n            <th>Close datetime</th>\n            <th></th>\n            <th></th>\n            <th></th>\n            <th></th>\n            <th></th>\n            <th></th>\n            </tr>\n        </thead>\n        <tbody>\n            <tr>\n            <th>2021-07-06 20:00:00+00:00</th>\n            <td>-0.002108</td>\n            <td>-0.004361</td>\n            <td>0.034720</td>\n            <td>0.000003</td>\n            <td>0.002250</td>\n            <td>0.000071</td>\n            <td>1.0</td>\n            </tr>\n            <tr>\n            <th>2021-07-06 21:00:00+00:00</th>\n            <td>-0.005282</td>\n            <td>-0.000222</td>\n            <td>0.053568</td>\n            <td>0.000005</td>\n            <td>-0.005065</td>\n            <td>-0.005174</td>\n            <td>1.0</td>\n            </tr>\n            <tr>\n            <th>2021-07-06 22:00:00+00:00</th>\n            <td>0.000466</td>\n            <td>0.002673</td>\n            <td>0.044552</td>\n            <td>0.000004</td>\n            <td>-0.002212</td>\n            <td>-0.000873</td>\n            <td>1.0</td>\n            </tr>\n            <tr>\n            <th>2021-07-06 23:00:00+00:00</th>\n            <td>-0.000614</td>\n            <td>-0.003834</td>\n            <td>0.072116</td>\n            <td>0.000007</td>\n            <td>0.003212</td>\n            <td>0.001299</td>\n            <td>1.0</td>\n            </tr>\n            <tr>\n            <th>2021-07-07 00:00:00+00:00</th>\n            <td>0.000000</td>\n            <td>0.000000</td>\n            <td>0.032531</td>\n            <td>0.000003</td>\n            <td>-0.000003</td>\n            <td>-0.000002</td>\n            <td>1.0</td>\n            </tr>\n        </tbody>\n        </table>\n    </embed>\n\n\nFormulas\n===========================\n\n| PNL_before_costs = (previous_position) * (price_change_%)\n| trading_volume = abs(new_wanted_position - previous_position)\n| const_trading_fee_pnl = trading_volume * broker_commision\n| execution_fee_pnl = (new_wanted_position - previous_position) * (execution_price - current_price)\n| PNL_after_costs = PNL_before_costs - (const_trading_fee_pnl + execution_fee_pnl)\n| PNL_half_costs = PNL_before_costs - (const_trading_fee_pnl + execution_fee_pnl) / 2.0\n\nLinks\n=====\n\n    * `PYPI <https://pypi.org/project/positions_backtester/>`_\n    * `GitHub <https://github.com/stas-prokopiev/positions_backtester>`_\n\nProject local Links\n===================\n\n    * `CHANGELOG <https://github.com/stas-prokopiev/positions_backtester/blob/master/CHANGELOG.rst>`_.\n    * `CONTRIBUTING <https://github.com/stas-prokopiev/positions_backtester/blob/master/CONTRIBUTING.rst>`_.\n\nContacts\n========\n\n    * Email: stas.prokopiev@gmail.com\n    * `vk.com <https://vk.com/stas.prokopyev>`_\n    * `Facebook <https://www.facebook.com/profile.php?id=100009380530321>`_\n\nLicense\n=======\n\nThis project is licensed under the MIT License.',
    'author': 'stanislav',
    'author_email': 'stas.prokopiev@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/stas-prokopiev/positions_backtester',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
