TITLE Mod file for component: Component(id=testcell type=IF_cond_alpha)

COMMENT

    This NEURON file has been generated by org.neuroml.export (see https://github.com/NeuroML/org.neuroml.export)
         org.neuroml.export  v1.8.0
         org.neuroml.model   v1.8.0
         jLEMS               v0.10.5

ENDCOMMENT

NEURON {
    POINT_PROCESS testcell
    
    
    NONSPECIFIC_CURRENT i                    : To ensure v of section follows v_I
    RANGE e_rev_E                           : parameter
    RANGE e_rev_I                           : parameter
    RANGE tau_refrac                        : parameter
    RANGE v_thresh                          : parameter
    RANGE tau_m                             : parameter
    RANGE v_rest                            : parameter
    RANGE v_reset                           : parameter
    RANGE cm                                : parameter
    RANGE i_offset                          : parameter
    RANGE tau_syn_E                         : parameter
    RANGE tau_syn_I                         : parameter
    RANGE v_init                            : parameter
    RANGE MSEC                              : parameter
    RANGE MVOLT                             : parameter
    RANGE NFARAD                            : parameter
    
    RANGE iSyn                              : exposure
    
    RANGE copy_v                           : copy of v on section
    
}

UNITS {
    
    (nA) = (nanoamp)
    (uA) = (microamp)
    (mA) = (milliamp)
    (A) = (amp)
    (mV) = (millivolt)
    (mS) = (millisiemens)
    (uS) = (microsiemens)
    (molar) = (1/liter)
    (kHz) = (kilohertz)
    (mM) = (millimolar)
    (um) = (micrometer)
    (umol) = (micromole)
    (S) = (siemens)
    
}

PARAMETER {
    
    e_rev_E = 0 
    e_rev_I = -70 
    tau_refrac = 5 
    v_thresh = -50 
    tau_m = 20 
    v_rest = -65 
    v_reset = -65 
    cm = 1 
    i_offset = 0.1 
    tau_syn_E = 0.3 
    tau_syn_I = 0.5 
    v_init = -65 
    MSEC = 1 (ms)
    MVOLT = 1 (mV)
    NFARAD = 0.001 (microfarads)
}

ASSIGNED {
    regime_refractory (1)
    regime_integrating (1)
    v (mV)
    i (mA/cm2)
    
    copy_v (mV)
    
    v_I (nA) 
    lastSpikeTime (ms)                    : Not a state variable as far as Neuron's concerned...
    
    iSyn (nA)                              : derived variable
    
    rate_v (mV/ms)
    
}

STATE {
    
}

INITIAL {
    rates()
    rates() ? To ensure correct initialisation.
    
    regime_refractory = 0
    
    regime_integrating = 1
    
    net_send(0, 1) : go to NET_RECEIVE block, flag 1, for initial state
    
}

BREAKPOINT {
    
    rates()
    
    copy_v = v
    i = v_I * cm
}

NET_RECEIVE(flag) {
    
    if (flag == 1) { : Setting watch condition for regime_refractory
        WATCH (t >  lastSpikeTime  + (  tau_refrac  *  MSEC  )) 5002
    }
    
    if (regime_refractory == 1 && flag == 5002) { : Setting actions for regime_refractory
    
            : State assignments
    
            : Change regime flags
            regime_refractory = 0
            regime_integrating = 1
    
            : OnEntry to Regime: integrating (initial = true)
    }
    
    if (flag == 1) { : Setting watch condition for regime_integrating
        WATCH (v >  v_thresh  *  MVOLT) 5003
    }
    
    if (regime_integrating == 1 && flag == 5003) { : Setting actions for regime_integrating
    
            : State assignments
    
            : Change regime flags
            regime_integrating = 0
            regime_refractory = 1
    
            : OnEntry to Regime: refractory (initial = false)
    
            lastSpikeTime = t
    
            v = v_reset  *  MVOLT
    }
    if (flag == 1) { : Set initial states
    
        v = v_init  *  MVOLT
    }
    
}

PROCEDURE rates() {
    
    ? DerivedVariable is based on path: synapses[*]/i, on: Component(id=testcell type=IF_cond_alpha), from synapses; null
    iSyn = 0 ? Was: synapses[*]_i but insertion of currents from external attachments not yet supported ? path based, prefix = 
    
    rate_v = 0 + regime_refractory * (10000000 * (v_reset * MVOLT - v)) + regime_integrating * ((  MVOLT   * (((  i_offset  ) /   cm  ) +  ((  v_rest   - (v /   MVOLT  )) /   tau_m  )) /   MSEC  ) + (  iSyn   / (  cm   *   NFARAD  ))) ? Note units of all quantities used here need to be consistent!
    
    v_I = -1 * rate_v
     
    
}

