TITLE Mod file for component: Component(id=poissonFiringSyn100Hz type=poissonFiringSynapse)

COMMENT

    This NEURON file has been generated by org.neuroml.export (see https://github.com/NeuroML/org.neuroml.export)
         org.neuroml.export  v1.8.0
         org.neuroml.model   v1.8.0
         jLEMS               v0.10.5

ENDCOMMENT

NEURON {
    POINT_PROCESS poissonFiringSyn100Hz
    ELECTRODE_CURRENT i
    RANGE weight                            : property
    RANGE averageRate                       : parameter
    RANGE averageIsi                        : parameter
    RANGE SMALL_TIME                        : parameter
    
    RANGE i                                 : exposure
    RANGE synInput_tauRise                  : parameter
    RANGE synInput_tauDecay                 : parameter
    RANGE synInput_peakTime                 : parameter
    RANGE synInput_waveformFactor           : parameter
    RANGE synInput_gbase                    : parameter
    RANGE synInput_erev                     : parameter
    
    RANGE synInput_g                        : exposure
    
    RANGE synInput_i                        : exposure
    RANGE iSyn                              : derived variable
    : Based on netstim.mod
    THREADSAFE : only true if every instance has its own distinct Random
    POINTER donotuse
}

UNITS {
    
    (nA) = (nanoamp)
    (uA) = (microamp)
    (mA) = (milliamp)
    (A) = (amp)
    (mV) = (millivolt)
    (mS) = (millisiemens)
    (uS) = (microsiemens)
    (molar) = (1/liter)
    (kHz) = (kilohertz)
    (mM) = (millimolar)
    (um) = (micrometer)
    (umol) = (micromole)
    (S) = (siemens)
    
}

PARAMETER {
    
    weight = 1
    averageRate = 0.1 (kHz)
    averageIsi = 10 (ms)
    SMALL_TIME = 1.0E-9 (ms)
    synInput_tauRise = 1 (ms)
    synInput_tauDecay = 5 (ms)
    synInput_peakTime = 2.0117974 (ms)
    synInput_waveformFactor = 1.8691859 
    synInput_gbase = 0.008 (uS)
    synInput_erev = 20 (mV)
}

ASSIGNED {
    v (mV)
    isi (ms)                    : Not a state variable as far as Neuron's concerned...
    
    synInput_g (uS)                        : derived variable
    
    synInput_i (nA)                        : derived variable
    
    iSyn (nA)                              : derived variable
    
    i (nA)                                 : derived variable
    rate_tsince (ms/ms)
    rate_tnextUsed (ms/ms)
    rate_tnextIdeal (ms/ms)
    rate_synInput_A (/ms)
    rate_synInput_B (/ms)
    donotuse
}

STATE {
    tsince (ms) 
    tnextIdeal (ms) 
    tnextUsed (ms) 
    synInput_A  
    synInput_B  
    
}

INITIAL {
    rates()
    rates() ? To ensure correct initialisation.
    
    tsince = 0
    
    isi = -  averageIsi  * log(random_float(1))
    
    tnextIdeal = isi
    
    tnextUsed = isi
    
    net_send(0, 1) : go to NET_RECEIVE block, flag 1, for initial state
    
    synInput_A = 0
    
    synInput_B = 0
    
}

BREAKPOINT {
    
    SOLVE states METHOD cnexp
    
    
}

NET_RECEIVE(flag) {
    
    LOCAL weight
    
    
    if (flag == 1) { : Setting watch for top level OnCondition...
        WATCH (t >  tnextUsed) 1000
    }
    if (flag == 1000) {
    
        tsince = 0
    
        isi = -  averageIsi  * log(1 - random_float(1))
    
        tnextIdeal = (  tnextIdeal  +  isi  )
    
        tnextUsed = tnextIdeal  *H( (  tnextIdeal  -t)/t ) + (t+  SMALL_TIME  )*H( (t-  tnextIdeal  )/t )
    
        : Child: Component(id=synInput type=expTwoSynapse)
    
        : This child is a synapse; defining weight
        weight = 1
    
        : paramMappings are: {poissonFiringSyn100Hz={tsince=tsince, tnextIdeal=tnextIdeal, tnextUsed=tnextUsed, isi=isi, weight=weight, averageRate=averageRate, averageIsi=averageIsi, SMALL_TIME=SMALL_TIME, i=i, iSyn=iSyn}, synInput={A=synInput_A, B=synInput_B, tauRise=synInput_tauRise, tauDecay=synInput_tauDecay, peakTime=synInput_peakTime, waveformFactor=synInput_w...
        : state_discontinuity(synInput_A, synInput_A  + (weight *  synInput_waveformFactor ))
        synInput_A = synInput_A  + (weight *  synInput_waveformFactor )
    
        : paramMappings are: {poissonFiringSyn100Hz={tsince=tsince, tnextIdeal=tnextIdeal, tnextUsed=tnextUsed, isi=isi, weight=weight, averageRate=averageRate, averageIsi=averageIsi, SMALL_TIME=SMALL_TIME, i=i, iSyn=iSyn}, synInput={A=synInput_A, B=synInput_B, tauRise=synInput_tauRise, tauDecay=synInput_tauDecay, peakTime=synInput_peakTime, waveformFactor=synInput_w...
        : state_discontinuity(synInput_B, synInput_B  + (weight *  synInput_waveformFactor ))
        synInput_B = synInput_B  + (weight *  synInput_waveformFactor )
    
        net_event(t)
        WATCH (t >  tnextUsed) 1000
    
    }
    
}

DERIVATIVE states {
    rates()
    tsince' = rate_tsince 
    tnextUsed' = rate_tnextUsed 
    tnextIdeal' = rate_tnextIdeal 
    synInput_A' = rate_synInput_A 
    synInput_B' = rate_synInput_B 
    
}

PROCEDURE rates() {
    
    synInput_g = synInput_gbase  * ( synInput_B  -  synInput_A ) ? evaluable
    synInput_i = synInput_g  * ( synInput_erev  - v) ? evaluable
    ? DerivedVariable is based on path: synapse/i, on: Component(id=poissonFiringSyn100Hz type=poissonFiringSynapse), from synapse; Component(id=synInput type=expTwoSynapse)
    iSyn = synInput_i ? path based, prefix = 
    
    i = weight  *  iSyn ? evaluable
    rate_tsince = 1 ? Note units of all quantities used here need to be consistent!
    rate_tnextUsed = 0 ? Note units of all quantities used here need to be consistent!
    rate_tnextIdeal = 0 ? Note units of all quantities used here need to be consistent!
    
     
    rate_synInput_A = - synInput_A  /  synInput_tauRise ? Note units of all quantities used here need to be consistent!
    rate_synInput_B = - synInput_B  /  synInput_tauDecay ? Note units of all quantities used here need to be consistent!
    
     
    
}


: Returns a float between 0 and max; implementation of random() as used in LEMS
FUNCTION random_float(max) {
    
    : This is not ideal, getting an exponential dist random number and then turning back to uniform
    : However this is the easiest what to ensure mod files with random methods fit into NEURON's
    : internal framework for managing internal number generation.
    random_float = exp(-1*erand())*max
    
}

:****************************************************
: Methods copied from netstim.mod in NEURON source

 
PROCEDURE seed(x) {
	set_seed(x)
}

VERBATIM
double nrn_random_pick(void* r);
void* nrn_random_arg(int argpos);
ENDVERBATIM


FUNCTION erand() {
VERBATIM
	if (_p_donotuse) {
		/*
		:Supports separate independent but reproducible streams for
		: each instance. However, the corresponding hoc Random
		: distribution MUST be set to Random.negexp(1)
		*/
		_lerand = nrn_random_pick(_p_donotuse);
	}else{
		/* only can be used in main thread */
		if (_nt != nrn_threads) {
           hoc_execerror("multithread random in NetStim"," only via hoc Random");
		}
ENDVERBATIM
		: the old standby. Cannot use if reproducible parallel sim
		: independent of nhost or which host this instance is on
		: is desired, since each instance on this cpu draws from
		: the same stream
		erand = exprand(1)
VERBATIM
	}
ENDVERBATIM
}

PROCEDURE noiseFromRandom() {
VERBATIM
 {
	void** pv = (void**)(&_p_donotuse);
	if (ifarg(1)) {
		*pv = nrn_random_arg(1);
	}else{
		*pv = (void*)0;
	}
 }
ENDVERBATIM
}

: End of methods copied from netstim.mod in NEURON source
:****************************************************


: The Heaviside step function
FUNCTION H(x) {
    
    if (x < 0) { H = 0 }
    else if (x > 0) { H = 1 }
    else { H = 0.5 }
    
}

