"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validatePrincipal = void 0;
function validatePrincipal(principal) {
    if (!principal.principalId.match(/^([0-9a-f]{10}-|)[A-Fa-f0-9]{8}-[A-Fa-f0-9]{4}-[A-Fa-f0-9]{4}-[A-Fa-f0-9]{4}-[A-Fa-f0-9]{12}$/)) {
        throw new Error(`PrincipalId must be a valid GUID: ${principal.principalId}`);
    }
}
exports.validatePrincipal = validatePrincipal;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicHJpbmNpcGFsLWNvbW1vbi5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy9wcml2YXRlL3ByaW5jaXBhbC1jb21tb24udHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBRUEsU0FBZ0IsaUJBQWlCLENBQUMsU0FBNEI7SUFDNUQsSUFBSSxDQUFDLFNBQVMsQ0FBQyxXQUFXLENBQUMsS0FBSyxDQUFDLCtGQUErRixDQUFDLEVBQUU7UUFDakksTUFBTSxJQUFJLEtBQUssQ0FBQyxxQ0FBcUMsU0FBUyxDQUFDLFdBQVcsRUFBRSxDQUFDLENBQUM7S0FDL0U7QUFDSCxDQUFDO0FBSkQsOENBSUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBQcmluY2lwYWxQcm9wZXJ0eSB9IGZyb20gJy4uL3ByaW5jaXBhbCc7XG5cbmV4cG9ydCBmdW5jdGlvbiB2YWxpZGF0ZVByaW5jaXBhbChwcmluY2lwYWw6IFByaW5jaXBhbFByb3BlcnR5KTogdm9pZCB7XG4gIGlmICghcHJpbmNpcGFsLnByaW5jaXBhbElkLm1hdGNoKC9eKFswLTlhLWZdezEwfS18KVtBLUZhLWYwLTldezh9LVtBLUZhLWYwLTldezR9LVtBLUZhLWYwLTldezR9LVtBLUZhLWYwLTldezR9LVtBLUZhLWYwLTldezEyfSQvKSkge1xuICAgIHRocm93IG5ldyBFcnJvcihgUHJpbmNpcGFsSWQgbXVzdCBiZSBhIHZhbGlkIEdVSUQ6ICR7cHJpbmNpcGFsLnByaW5jaXBhbElkfWApO1xuICB9XG59Il19