import numpy as np

# data taken from McGPU files (Badal A, Badano A. Accelerating Monte Carlo simulations of photon transport in a voxelized geometry using a massively parallel graphics processing unit. Med Phys. 2009 Nov;36(11):4878–80. )

#[MEAN FREE PATHS (cm)]
#[Energy (eV) 	| Rayleigh 	| Compton 	| Photoelectric 	| TOTAL (+pair prod) (cm) | Rayleigh: max cumul prob F^2]

skin_ICRP110_MFP = np.array([
	[5.0000000000E+03, 1.7916350857E+00, 7.3907857888E+00, 2.3803389916E-02, 2.3416858793E-02, 3.4424440895E-01],
	[5.0050000000E+03, 1.7936835198E+00, 7.3870557655E+00, 2.3875306928E-02, 2.3486769634E-02, 3.4450158248E-01],
	[5.0100000000E+03, 1.7957322471E+00, 7.3833313463E+00, 2.3947368880E-02, 2.3556816896E-02, 3.4475847212E-01],
	[5.0150000000E+03, 1.7977812672E+00, 7.3796125172E+00, 2.4019575921E-02, 2.3627000697E-02, 3.4501507860E-01],
	[5.0200000000E+03, 1.7998305801E+00, 7.3758992642E+00, 2.4091928195E-02, 2.3697321154E-02, 3.4527140262E-01],
	[5.0250000000E+03, 1.8018801853E+00, 7.3721915735E+00, 2.4164425849E-02, 2.3767778386E-02, 3.4552744489E-01],
	[5.0300000000E+03, 1.8039300827E+00, 7.3684894312E+00, 2.4237069030E-02, 2.3838372509E-02, 3.4578320614E-01],
	[5.0350000000E+03, 1.8059802721E+00, 7.3647928235E+00, 2.4309857883E-02, 2.3909103643E-02, 3.4603868705E-01],
	[5.0400000000E+03, 1.8080307531E+00, 7.3611017367E+00, 2.4382792556E-02, 2.3979971904E-02, 3.4629388834E-01],
	[5.0450000000E+03, 1.8100815255E+00, 7.3574161569E+00, 2.4455873195E-02, 2.4050977410E-02, 3.4654881070E-01],
	[5.0500000000E+03, 1.8121325891E+00, 7.3537360706E+00, 2.4529099945E-02, 2.4122120278E-02, 3.4680345484E-01],
	[5.0550000000E+03, 1.8141839436E+00, 7.3500614642E+00, 2.4602472954E-02, 2.4193400627E-02, 3.4705782144E-01],
	[5.0600000000E+03, 1.8162355888E+00, 7.3463923241E+00, 2.4675992367E-02, 2.4264818573E-02, 3.4731191121E-01],
	[5.0650000000E+03, 1.8182875245E+00, 7.3427286367E+00, 2.4749658331E-02, 2.4336374234E-02, 3.4756572483E-01],
	[5.0700000000E+03, 1.8203397503E+00, 7.3390703886E+00, 2.4823470993E-02, 2.4408067726E-02, 3.4781926298E-01],
	[5.0750000000E+03, 1.8223922661E+00, 7.3354175663E+00, 2.4897430499E-02, 2.4479899168E-02, 3.4807252637E-01],
	[5.0800000000E+03, 1.8244450715E+00, 7.3317701565E+00, 2.4971536994E-02, 2.4551868676E-02, 3.4832551565E-01],
	[5.0850000000E+03, 1.8265110227E+00, 7.3281814752E+00, 2.5045790626E-02, 2.4623979305E-02, 3.4857823153E-01],
	[5.0900000000E+03, 1.8285785280E+00, 7.3246032462E+00, 2.5120191540E-02, 2.4696228548E-02, 3.4883067466E-01],
	[5.0950000000E+03, 1.8306463403E+00, 7.3210302751E+00, 2.5194739884E-02, 2.4768616238E-02, 3.4908284574E-01],
	[5.1000000000E+03, 1.8327144592E+00, 7.3174625489E+00, 2.5269435803E-02, 2.4841142492E-02, 3.4933474542E-01],
	[5.1050000000E+03, 1.8347828845E+00, 7.3139000549E+00, 2.5344279444E-02, 2.4913807426E-02, 3.4958637439E-01],
	[5.1100000000E+03, 1.8368516160E+00, 7.3103427802E+00, 2.5419270953E-02, 2.4986611157E-02, 3.4983773330E-01],
	[5.1150000000E+03, 1.8389206533E+00, 7.3067907122E+00, 2.5494410477E-02, 2.5059553802E-02, 3.5008882283E-01],
	[5.1200000000E+03, 1.8409899962E+00, 7.3032438381E+00, 2.5569698161E-02, 2.5132635478E-02, 3.5033964362E-01],
	[5.1250000000E+03, 1.8430596445E+00, 7.2997021452E+00, 2.5645134153E-02, 2.5205856302E-02, 3.5059019636E-01],
	[5.1300000000E+03, 1.8451295980E+00, 7.2961656210E+00, 2.5720718598E-02, 2.5279216389E-02, 3.5084048169E-01],
	[5.1350000000E+03, 1.8471998563E+00, 7.2926342529E+00, 2.5796451643E-02, 2.5352715856E-02, 3.5109050026E-01],
	[5.1400000000E+03, 1.8492704192E+00, 7.2891080283E+00, 2.5872333434E-02, 2.5426354821E-02, 3.5134025273E-01],
	[5.1450000000E+03, 1.8513412865E+00, 7.2855869348E+00, 2.5948364118E-02, 2.5500133398E-02, 3.5158973975E-01],
	[5.1500000000E+03, 1.8534124579E+00, 7.2820709599E+00, 2.6024543841E-02, 2.5574051705E-02, 3.5183896198E-01],
	[5.1550000000E+03, 1.8554839331E+00, 7.2785600913E+00, 2.6100872749E-02, 2.5648109857E-02, 3.5208792004E-01],
	[5.1600000000E+03, 1.8575557120E+00, 7.2750543165E+00, 2.6177350989E-02, 2.5722307971E-02, 3.5233661459E-01],
	[5.1650000000E+03, 1.8596353796E+00, 7.2715849301E+00, 2.6253978706E-02, 2.5796648016E-02, 3.5258504627E-01],
	[5.1700000000E+03, 1.8617214734E+00, 7.2681457443E+00, 2.6330756048E-02, 2.5871129771E-02, 3.5283321571E-01],
	[5.1750000000E+03, 1.8638078874E+00, 7.2647115072E+00, 2.6407683161E-02, 2.5945751866E-02, 3.5308112356E-01],
	[5.1800000000E+03, 1.8658946214E+00, 7.2612822070E+00, 2.6484760191E-02, 2.6020514417E-02, 3.5332877044E-01],
	[5.1850000000E+03, 1.8679816751E+00, 7.2578578318E+00, 2.6561987284E-02, 2.6095417539E-02, 3.5357615700E-01],
	[5.1900000000E+03, 1.8700690482E+00, 7.2544383698E+00, 2.6639364587E-02, 2.6170461349E-02, 3.5382328384E-01],
	[5.1950000000E+03, 1.8721567405E+00, 7.2510238092E+00, 2.6716892246E-02, 2.6245645962E-02, 3.5407015162E-01],
	[5.2000000000E+03, 1.8742447517E+00, 7.2476141383E+00, 2.6794570407E-02, 2.6320971495E-02, 3.5431676094E-01],
	[5.2050000000E+03, 1.8763330815E+00, 7.2442093454E+00, 2.6872399217E-02, 2.6396438062E-02, 3.5456311243E-01],
	[5.2100000000E+03, 1.8784217298E+00, 7.2408094187E+00, 2.6950378822E-02, 2.6472045779E-02, 3.5480920672E-01],
	[5.2150000000E+03, 1.8805106961E+00, 7.2374143469E+00, 2.7028509369E-02, 2.6547794762E-02, 3.5505504442E-01],
	[5.2200000000E+03, 1.8825999804E+00, 7.2340241181E+00, 2.7106791004E-02, 2.6623685126E-02, 3.5530062614E-01],
	[5.2250000000E+03, 1.8846895823E+00, 7.2306387209E+00, 2.7185223872E-02, 2.6699716986E-02, 3.5554595250E-01],
	[5.2300000000E+03, 1.8867795016E+00, 7.2272581439E+00, 2.7263808122E-02, 2.6775890458E-02, 3.5579102412E-01],
	[5.2350000000E+03, 1.8888697380E+00, 7.2238823755E+00, 2.7342543898E-02, 2.6852205657E-02, 3.5603584159E-01],
	[5.2400000000E+03, 1.8909602913E+00, 7.2205114043E+00, 2.7421431347E-02, 2.6928662698E-02, 3.5628040554E-01],
	[5.2450000000E+03, 1.8930511612E+00, 7.2171452189E+00, 2.7500470616E-02, 2.7005261695E-02, 3.5652471655E-01],
	[5.2500000000E+03, 1.8951547474E+00, 7.2138347149E+00, 2.7579661851E-02, 2.7082006015E-02, 3.5676877525E-01],
	[5.2550000000E+03, 1.8972595578E+00, 7.2105325366E+00, 2.7659005198E-02, 2.7158892785E-02, 3.5701258222E-01],
	[5.2600000000E+03, 1.8993647008E+00, 7.2072350081E+00, 2.7738500804E-02, 2.7235921887E-02, 3.5725613807E-01],
	[5.2650000000E+03, 1.9014701761E+00, 7.2039421186E+00, 2.7818148815E-02, 2.7313093438E-02, 3.5749944339E-01],
	[5.2700000000E+03, 1.9035759835E+00, 7.2006538570E+00, 2.7897949377E-02, 2.7390407550E-02, 3.5774249878E-01],
	[5.2750000000E+03, 1.9056821227E+00, 7.1973702126E+00, 2.7977902636E-02, 2.7467864341E-02, 3.5798530482E-01],
	[5.2800000000E+03, 1.9077885935E+00, 7.1940911744E+00, 2.8058008740E-02, 2.7545463923E-02, 3.5822786212E-01],
	[5.2850000000E+03, 1.9098953956E+00, 7.1908167317E+00, 2.8138267834E-02, 2.7623206412E-02, 3.5847017126E-01],
	[5.2900000000E+03, 1.9120025287E+00, 7.1875468737E+00, 2.8218680065E-02, 2.7701091922E-02, 3.5871223282E-01],
	[5.2950000000E+03, 1.9141099925E+00, 7.1842815896E+00, 2.8299245579E-02, 2.7779120568E-02, 3.5895404739E-01],
	[5.3000000000E+03, 1.9162177869E+00, 7.1810208687E+00, 2.8379964522E-02, 2.7857292463E-02, 3.5919561555E-01],
	[5.3050000000E+03, 1.9183259115E+00, 7.1777647004E+00, 2.8460837041E-02, 2.7935607723E-02, 3.5943693788E-01],
	[5.3100000000E+03, 1.9204343661E+00, 7.1745130740E+00, 2.8541863282E-02, 2.8014066462E-02, 3.5967801497E-01],
	[5.3150000000E+03, 1.9225431504E+00, 7.1712659789E+00, 2.8623043392E-02, 2.8092668794E-02, 3.5991884737E-01],
	[5.3200000000E+03, 1.9246522642E+00, 7.1680234045E+00, 2.8704377516E-02, 2.8171414832E-02, 3.6015943568E-01],
	[5.3250000000E+03, 1.9267617072E+00, 7.1647853403E+00, 2.8785865802E-02, 2.8250304691E-02, 3.6039978050E-01],
	[5.3300000000E+03, 1.9288720503E+00, 7.1615541152E+00, 2.8867508395E-02, 2.8329338645E-02, 3.6063988256E-01],
	[5.3350000000E+03, 1.9309950370E+00, 7.1583777332E+00, 2.8949305441E-02, 2.8408520108E-02, 3.6087974252E-01],
	[5.3400000000E+03, 1.9331183683E+00, 7.1552057337E+00, 2.9031257088E-02, 2.8487845765E-02, 3.6111936103E-01],
	[5.3450000000E+03, 1.9352420439E+00, 7.1520381064E+00, 2.9113363482E-02, 2.8567315730E-02, 3.6135873873E-01],
	[5.3500000000E+03, 1.9373660636E+00, 7.1488748413E+00, 2.9195624768E-02, 2.8646930116E-02, 3.6159787627E-01],
	[5.3550000000E+03, 1.9394904272E+00, 7.1457159282E+00, 2.9278041094E-02, 2.8726689039E-02, 3.6183677429E-01],
	[5.3600000000E+03, 1.9416151342E+00, 7.1425613571E+00, 2.9360612605E-02, 2.8806592611E-02, 3.6207543342E-01],
	[5.3650000000E+03, 1.9437401846E+00, 7.1394111180E+00, 2.9443339449E-02, 2.8886640946E-02, 3.6231385430E-01],
	[5.3700000000E+03, 1.9458655779E+00, 7.1362652010E+00, 2.9526221770E-02, 2.8966834157E-02, 3.6255203757E-01],
	[5.3750000000E+03, 1.9479913140E+00, 7.1331235960E+00, 2.9609259716E-02, 2.9047172359E-02, 3.6278998386E-01],
	[5.3800000000E+03, 1.9501173926E+00, 7.1299862932E+00, 2.9692453433E-02, 2.9127655663E-02, 3.6302769379E-01],
	[5.3850000000E+03, 1.9522438134E+00, 7.1268532827E+00, 2.9775803067E-02, 2.9208284185E-02, 3.6326516800E-01],
	[5.3900000000E+03, 1.9543705762E+00, 7.1237245546E+00, 2.9859308765E-02, 2.9289058036E-02, 3.6350240710E-01],
	[5.3950000000E+03, 1.9564976806E+00, 7.1206000992E+00, 2.9942970673E-02, 2.9369977330E-02, 3.6373941172E-01],
	[5.4000000000E+03, 1.9586251265E+00, 7.1174799065E+00, 3.0026788938E-02, 2.9451042180E-02, 3.6397618248E-01],
	[5.4050000000E+03, 1.9607529136E+00, 7.1143639670E+00, 3.0110763705E-02, 2.9532252700E-02, 3.6421272000E-01],
	[5.4100000000E+03, 1.9628810416E+00, 7.1112522708E+00, 3.0194895121E-02, 2.9613609001E-02, 3.6444902488E-01],
	[5.4150000000E+03, 1.9650095102E+00, 7.1081448083E+00, 3.0279183332E-02, 2.9695111197E-02, 3.6468509775E-01],
	[5.4200000000E+03, 1.9671493474E+00, 7.1050865607E+00, 3.0363628485E-02, 2.9776762718E-02, 3.6492093921E-01],
	[5.4250000000E+03, 1.9692909877E+00, 7.1020383504E+00, 3.0448230727E-02, 2.9858560825E-02, 3.6515654987E-01],
	[5.4300000000E+03, 1.9714329835E+00, 7.0989942541E+00, 3.0532990202E-02, 2.9940505198E-02, 3.6539193034E-01],
	[5.4350000000E+03, 1.9735753344E+00, 7.0959542625E+00, 3.0617907059E-02, 3.0022595948E-02, 3.6562708121E-01],
	[5.4400000000E+03, 1.9757180402E+00, 7.0929183663E+00, 3.0702981442E-02, 3.0104833190E-02, 3.6586200310E-01],
	[5.4450000000E+03, 1.9778611007E+00, 7.0898865563E+00, 3.0788213500E-02, 3.0187217035E-02, 3.6609669660E-01],
	[5.4500000000E+03, 1.9800045155E+00, 7.0868588231E+00, 3.0873603376E-02, 3.0269747596E-02, 3.6633116231E-01],
	[5.4550000000E+03, 1.9821482844E+00, 7.0838351577E+00, 3.0959151219E-02, 3.0352424985E-02, 3.6656540082E-01],
	[5.4600000000E+03, 1.9842924071E+00, 7.0808155507E+00, 3.1044857175E-02, 3.0435249314E-02, 3.6679941272E-01],
	[5.4650000000E+03, 1.9864368834E+00, 7.0777999931E+00, 3.1130721389E-02, 3.0518220697E-02, 3.6703319861E-01],
	[5.4700000000E+03, 1.9885817130E+00, 7.0747884756E+00, 3.1216744009E-02, 3.0601339244E-02, 3.6726675907E-01],
	[5.4750000000E+03, 1.9907268957E+00, 7.0717809893E+00, 3.1302925180E-02, 3.0684605069E-02, 3.6750009469E-01],
	[5.4800000000E+03, 1.9928724311E+00, 7.0687775250E+00, 3.1389612910E-02, 3.0768352511E-02, 3.6773320605E-01],
	[5.4850000000E+03, 1.9950183190E+00, 7.0657780738E+00, 3.1476741793E-02, 3.0852518622E-02, 3.6796609374E-01],
	[5.4900000000E+03, 1.9971645591E+00, 7.0627826265E+00, 3.1564032581E-02, 3.0936835050E-02, 3.6819875833E-01],
	[5.4950000000E+03, 1.9993111513E+00, 7.0597911742E+00, 3.1651485427E-02, 3.1021301911E-02, 3.6843120041E-01],
	[5.5000000000E+03, 2.0014580951E+00, 7.0568037079E+00, 3.1739100483E-02, 3.1105919321E-02, 3.6866342054E-01],
	[5.5050000000E+03, 2.0036107859E+00, 7.0538422114E+00, 3.1826877901E-02, 3.1190689135E-02, 3.6889541930E-01],
	[5.5100000000E+03, 2.0057705075E+00, 7.0509118043E+00, 3.1914817834E-02, 3.1275611904E-02, 3.6912719726E-01],
	[5.5150000000E+03, 2.0079305950E+00, 7.0479852710E+00, 3.2002920434E-02, 3.1360685604E-02, 3.6935875500E-01],
	[5.5200000000E+03, 2.0100910482E+00, 7.0450626027E+00, 3.2091185853E-02, 3.1445910354E-02, 3.6959009307E-01],
	[5.5250000000E+03, 2.0122518667E+00, 7.0421437909E+00, 3.2179614245E-02, 3.1531286269E-02, 3.6982121205E-01],
	[5.5300000000E+03, 2.0144130503E+00, 7.0392288270E+00, 3.2268205760E-02, 3.1616813466E-02, 3.7005211250E-01],
	[5.5350000000E+03, 2.0165745988E+00, 7.0363177024E+00, 3.2356960551E-02, 3.1702492060E-02, 3.7028279497E-01],
	[5.5400000000E+03, 2.0187365117E+00, 7.0334104087E+00, 3.2445878772E-02, 3.1788322168E-02, 3.7051326004E-01],
	[5.5450000000E+03, 2.0208987890E+00, 7.0305069374E+00, 3.2534960573E-02, 3.1874303907E-02, 3.7074350824E-01],
	[5.5500000000E+03, 2.0230614303E+00, 7.0276072799E+00, 3.2624206108E-02, 3.1960437392E-02, 3.7097354015E-01],
	[5.5550000000E+03, 2.0252244353E+00, 7.0247114279E+00, 3.2713615529E-02, 3.2046722738E-02, 3.7120335631E-01],
	[5.5600000000E+03, 2.0273878038E+00, 7.0218193729E+00, 3.2803188988E-02, 3.2133160063E-02, 3.7143295728E-01],
	[5.5650000000E+03, 2.0295515356E+00, 7.0189311065E+00, 3.2892926637E-02, 3.2219749481E-02, 3.7166234359E-01],
	[5.5700000000E+03, 2.0317156303E+00, 7.0160466205E+00, 3.2982828630E-02, 3.2306491109E-02, 3.7189151582E-01],
	[5.5750000000E+03, 2.0338800876E+00, 7.0131659064E+00, 3.3072895118E-02, 3.2393385062E-02, 3.7212047448E-01],
	[5.5800000000E+03, 2.0360449075E+00, 7.0102889559E+00, 3.3163126253E-02, 3.2480431455E-02, 3.7234922014E-01],
	[5.5850000000E+03, 2.0382100894E+00, 7.0074157608E+00, 3.3253522189E-02, 3.2567630405E-02, 3.7257775333E-01],
	[5.5900000000E+03, 2.0403756333E+00, 7.0045463128E+00, 3.3344083077E-02, 3.2654982026E-02, 3.7280607460E-01],
	[5.5950000000E+03, 2.0425500458E+00, 7.0017152559E+00, 3.3434809070E-02, 3.2742489377E-02, 3.7303418447E-01],
	[5.6000000000E+03, 2.0447279814E+00, 6.9989006878E+00, 3.3525700320E-02, 3.2830150750E-02, 3.7326208349E-01],
	[5.6050000000E+03, 2.0469062925E+00, 6.9960897614E+00, 3.3616756979E-02, 3.2917965174E-02, 3.7348977220E-01],
	[5.6100000000E+03, 2.0490849787E+00, 6.9932824689E+00, 3.3707979201E-02, 3.3005932765E-02, 3.7371725111E-01],
	[5.6150000000E+03, 2.0512640399E+00, 6.9904788023E+00, 3.3799367137E-02, 3.3094053637E-02, 3.7394452077E-01],
	[5.6200000000E+03, 2.0534434758E+00, 6.9876787537E+00, 3.3890920939E-02, 3.3182327906E-02, 3.7417158170E-01],
	[5.6250000000E+03, 2.0556232860E+00, 6.9848823151E+00, 3.3982640761E-02, 3.3270755687E-02, 3.7439843443E-01],
	[5.6300000000E+03, 2.0578034704E+00, 6.9820894789E+00, 3.4074526755E-02, 3.3359337095E-02, 3.7462507948E-01],
	[5.6350000000E+03, 2.0599840286E+00, 6.9793002370E+00, 3.4166579072E-02, 3.3448072245E-02, 3.7485151738E-01],
	[5.6400000000E+03, 2.0621649604E+00, 6.9765145818E+00, 3.4258797866E-02, 3.3536961250E-02, 3.7507774865E-01],
	[5.6450000000E+03, 2.0643462655E+00, 6.9737325053E+00, 3.4351183289E-02, 3.3626004227E-02, 3.7530377381E-01],
	[5.6500000000E+03, 2.0665279437E+00, 6.9709540000E+00, 3.4443735493E-02, 3.3715201290E-02, 3.7552959345E-01],
	[5.6550000000E+03, 2.0687099946E+00, 6.9681790579E+00, 3.4536454631E-02, 3.3804552553E-02, 3.7575520818E-01],
	[5.6600000000E+03, 2.0708924181E+00, 6.9654076715E+00, 3.4629340854E-02, 3.3894058130E-02, 3.7598061857E-01],
	[5.6650000000E+03, 2.0730752138E+00, 6.9626398330E+00, 3.4722394317E-02, 3.3983718137E-02, 3.7620582518E-01],
	[5.6700000000E+03, 2.0752583816E+00, 6.9598755347E+00, 3.4815615170E-02, 3.4073532686E-02, 3.7643082856E-01],
	[5.6750000000E+03, 2.0774419210E+00, 6.9571147691E+00, 3.4909003566E-02, 3.4163501894E-02, 3.7665562929E-01],
	[5.6800000000E+03, 2.0796258319E+00, 6.9543575284E+00, 3.5002559659E-02, 3.4253625872E-02, 3.7688022792E-01],
	[5.6850000000E+03, 2.0818182911E+00, 6.9516371498E+00, 3.5096283599E-02, 3.4343907776E-02, 3.7710462501E-01],
	[5.6900000000E+03, 2.0840142008E+00, 6.9489327243E+00, 3.5190175540E-02, 3.4434345850E-02, 3.7732882111E-01],
	[5.6950000000E+03, 2.0862104950E+00, 6.9462317250E+00, 3.5284235635E-02, 3.4524939072E-02, 3.7755281677E-01],
	[5.7000000000E+03, 2.0884071732E+00, 6.9435341445E+00, 3.5378464034E-02, 3.4615687557E-02, 3.7777661254E-01],
	[5.7050000000E+03, 2.0906042354E+00, 6.9408399755E+00, 3.5472860892E-02, 3.4706591418E-02, 3.7800020898E-01],
	[5.7100000000E+03, 2.0928016812E+00, 6.9381492107E+00, 3.5567426361E-02, 3.4797650769E-02, 3.7822360663E-01],
	[5.7150000000E+03, 2.0949995103E+00, 6.9354618428E+00, 3.5662160592E-02, 3.4888865725E-02, 3.7844680603E-01],
	[5.7200000000E+03, 2.0971977225E+00, 6.9327778645E+00, 3.5757063738E-02, 3.4980236397E-02, 3.7866980772E-01],
	[5.7250000000E+03, 2.0993963175E+00, 6.9300972687E+00, 3.5852135953E-02, 3.5071762901E-02, 3.7889261225E-01],
	[5.7300000000E+03, 2.1015952951E+00, 6.9274200481E+00, 3.5947377387E-02, 3.5163445350E-02, 3.7911522015E-01],
	[5.7350000000E+03, 2.1037946550E+00, 6.9247461956E+00, 3.6042799596E-02, 3.5255294765E-02, 3.7933763197E-01],
	[5.7400000000E+03, 2.1059943968E+00, 6.9220757039E+00, 3.6138404380E-02, 3.5347312835E-02, 3.7955984823E-01],
	[5.7450000000E+03, 2.1081945204E+00, 6.9194085659E+00, 3.6234178967E-02, 3.5439487304E-02, 3.7978186947E-01],
	[5.7500000000E+03, 2.1103950255E+00, 6.9167447746E+00, 3.6330123508E-02, 3.5531818286E-02, 3.8000369622E-01],
	[5.7550000000E+03, 2.1125959118E+00, 6.9140843227E+00, 3.6426238156E-02, 3.5624305894E-02, 3.8022532901E-01],
	[5.7600000000E+03, 2.1147971790E+00, 6.9114272032E+00, 3.6522523064E-02, 3.5716950242E-02, 3.8044676836E-01],
	[5.7650000000E+03, 2.1169988269E+00, 6.9087734090E+00, 3.6618978384E-02, 3.5809751441E-02, 3.8066801481E-01],
	[5.7700000000E+03, 2.1192008553E+00, 6.9061229332E+00, 3.6715604271E-02, 3.5902709607E-02, 3.8088906887E-01],
	[5.7750000000E+03, 2.1214079720E+00, 6.9034950248E+00, 3.6812400876E-02, 3.5995826730E-02, 3.8110993106E-01],
	[5.7800000000E+03, 2.1236215996E+00, 6.9008954056E+00, 3.6909368352E-02, 3.6089103513E-02, 3.8133060191E-01],
	[5.7850000000E+03, 2.1258356199E+00, 6.8982990119E+00, 3.7006506852E-02, 3.6182537636E-02, 3.8155108194E-01],
	[5.7900000000E+03, 2.1280500328E+00, 6.8957058369E+00, 3.7103816528E-02, 3.6276129212E-02, 3.8177137166E-01],
	[5.7950000000E+03, 2.1302648379E+00, 6.8931158739E+00, 3.7201297535E-02, 3.6369878354E-02, 3.8199147158E-01],
	[5.8000000000E+03, 2.1324800350E+00, 6.8905291160E+00, 3.7298950024E-02, 3.6463785174E-02, 3.8221138222E-01],
	[5.8050000000E+03, 2.1346956238E+00, 6.8879455566E+00, 3.7396774148E-02, 3.6557849786E-02, 3.8243110409E-01],
	[5.8100000000E+03, 2.1369116041E+00, 6.8853651890E+00, 3.7494770060E-02, 3.6652072301E-02, 3.8265063770E-01],
	[5.8150000000E+03, 2.1391279755E+00, 6.8827880065E+00, 3.7592937913E-02, 3.6746452833E-02, 3.8286998355E-01],
	[5.8200000000E+03, 2.1413447378E+00, 6.8802140024E+00, 3.7691277859E-02, 3.6840991493E-02, 3.8308914215E-01],
	[5.8250000000E+03, 2.1435618907E+00, 6.8776431700E+00, 3.7789790052E-02, 3.6935688395E-02, 3.8330811400E-01],
	[5.8300000000E+03, 2.1457794341E+00, 6.8750755028E+00, 3.7888474645E-02, 3.7030543650E-02, 3.8352689962E-01],
	[5.8350000000E+03, 2.1479973675E+00, 6.8725109942E+00, 3.7987331789E-02, 3.7125557371E-02, 3.8374549949E-01],
	[5.8400000000E+03, 2.1502156908E+00, 6.8699496375E+00, 3.8086361639E-02, 3.7220729670E-02, 3.8396391411E-01],
	[5.8450000000E+03, 2.1524344036E+00, 6.8673914262E+00, 3.8185564346E-02, 3.7316060658E-02, 3.8418214399E-01],
	[5.8500000000E+03, 2.1546535058E+00, 6.8648363537E+00, 3.8284940064E-02, 3.7411550449E-02, 3.8440018961E-01],
	[5.8550000000E+03, 2.1568729970E+00, 6.8622844135E+00, 3.8384488946E-02, 3.7507199152E-02, 3.8461805148E-01],
	[5.8600000000E+03, 2.1590928770E+00, 6.8597355992E+00, 3.8484211144E-02, 3.7603006882E-02, 3.8483573008E-01],
	[5.8650000000E+03, 2.1613131455E+00, 6.8571899041E+00, 3.8584106811E-02, 3.7698973748E-02, 3.8505322591E-01],
	[5.8700000000E+03, 2.1635426345E+00, 6.8546835740E+00, 3.8684176100E-02, 3.7795103660E-02, 3.8527053945E-01],
	[5.8750000000E+03, 2.1657741084E+00, 6.8521867948E+00, 3.8784419164E-02, 3.7891393648E-02, 3.8548767118E-01],
	[5.8800000000E+03, 2.1680059826E+00, 6.8496930478E+00, 3.8884836156E-02, 3.7987843144E-02, 3.8570462160E-01],
	[5.8850000000E+03, 2.1702382568E+00, 6.8472023269E+00, 3.8985427228E-02, 3.8084452260E-02, 3.8592139120E-01],
	[5.8900000000E+03, 2.1724709307E+00, 6.8447146257E+00, 3.9086192534E-02, 3.8181221106E-02, 3.8613798044E-01],
	[5.8950000000E+03, 2.1747040042E+00, 6.8422299382E+00, 3.9187132226E-02, 3.8278149795E-02, 3.8635438981E-01],
	[5.9000000000E+03, 2.1769374768E+00, 6.8397482580E+00, 3.9288246458E-02, 3.8375238438E-02, 3.8657061979E-01],
	[5.9050000000E+03, 2.1791713484E+00, 6.8372695790E+00, 3.9389535381E-02, 3.8472487146E-02, 3.8678667087E-01],
	[5.9100000000E+03, 2.1814056187E+00, 6.8347938950E+00, 3.9490999150E-02, 3.8569896030E-02, 3.8700254350E-01],
	[5.9150000000E+03, 2.1836402873E+00, 6.8323211999E+00, 3.9592637916E-02, 3.8667465201E-02, 3.8721823817E-01],
	[5.9200000000E+03, 2.1858753542E+00, 6.8298514876E+00, 3.9694451833E-02, 3.8765194770E-02, 3.8743375535E-01],
	[5.9250000000E+03, 2.1881108189E+00, 6.8273847518E+00, 3.9796441054E-02, 3.8863084848E-02, 3.8764909552E-01],
	[5.9300000000E+03, 2.1903466812E+00, 6.8249209867E+00, 3.9898605731E-02, 3.8961135546E-02, 3.8786425913E-01],
	[5.9350000000E+03, 2.1925829408E+00, 6.8224601860E+00, 4.0000946017E-02, 3.9059346974E-02, 3.8807924666E-01],
	[5.9400000000E+03, 2.1948195976E+00, 6.8200023436E+00, 4.0103462066E-02, 3.9157719243E-02, 3.8829405858E-01],
	[5.9450000000E+03, 2.1970566511E+00, 6.8175474537E+00, 4.0206154030E-02, 3.9256252464E-02, 3.8850869535E-01],
	[5.9500000000E+03, 2.1992941013E+00, 6.8150955101E+00, 4.0309022062E-02, 3.9354946746E-02, 3.8872315743E-01],
	[5.9550000000E+03, 2.2015319477E+00, 6.8126465068E+00, 4.0412066315E-02, 3.9453802201E-02, 3.8893744521E-01],
	[5.9600000000E+03, 2.2037701901E+00, 6.8102004378E+00, 4.0515286942E-02, 3.9552818939E-02, 3.8915155913E-01],
	[5.9650000000E+03, 2.2060184492E+00, 6.8077969983E+00, 4.0618684095E-02, 3.9652001524E-02, 3.8936549969E-01],
	[5.9700000000E+03, 2.2082674990E+00, 6.8053980010E+00, 4.0722257929E-02, 3.9751345826E-02, 3.8957926737E-01],
	[5.9750000000E+03, 2.2105169559E+00, 6.8030018564E+00, 4.0826008595E-02, 3.9850851779E-02, 3.8979286267E-01],
	[5.9800000000E+03, 2.2127668199E+00, 6.8006085586E+00, 4.0929936246E-02, 3.9950519491E-02, 3.9000628609E-01],
	[5.9850000000E+03, 2.2150170905E+00, 6.7982181021E+00, 4.1034041036E-02, 4.0050349074E-02, 3.9021953811E-01],
	[5.9900000000E+03, 2.2172677674E+00, 6.7958304809E+00, 4.1138323117E-02, 4.0150340637E-02, 3.9043261922E-01],
	[5.9950000000E+03, 2.2195188506E+00, 6.7934456895E+00, 4.1242782643E-02, 4.0250494289E-02, 3.9064552992E-01],
	[6.0000000000E+03, 2.2217703396E+00, 6.7910637220E+00, 4.1347419766E-02, 4.0350810142E-02, 3.9085827068E-01],
	[6.0050000000E+03, 2.2240222342E+00, 6.7886845728E+00, 4.1452756246E-02, 4.0451785024E-02, 3.9107084199E-01],
	[6.0100000000E+03, 2.2262745341E+00, 6.7863082362E+00, 4.1558272857E-02, 4.0552924358E-02, 3.9128324434E-01],
	[6.0150000000E+03, 2.2285272392E+00, 6.7839347066E+00, 4.1663969756E-02, 4.0654228255E-02, 3.9149547819E-01],
	[6.0200000000E+03, 2.2307803490E+00, 6.7815639782E+00, 4.1769847102E-02, 4.0755696830E-02, 3.9170754404E-01],
	[6.0250000000E+03, 2.2330338634E+00, 6.7791960456E+00, 4.1875905050E-02, 4.0857330195E-02, 3.9191944236E-01],
	[6.0300000000E+03, 2.2352877821E+00, 6.7768309030E+00, 4.1982143758E-02, 4.0959128461E-02, 3.9213117362E-01],
	[6.0350000000E+03, 2.2375421048E+00, 6.7744685448E+00, 4.2088563384E-02, 4.1061091743E-02, 3.9234273831E-01],
	[6.0400000000E+03, 2.2397968312E+00, 6.7721089656E+00, 4.2195164084E-02, 4.1163220151E-02, 3.9255413688E-01],
	[6.0450000000E+03, 2.2420519612E+00, 6.7697521597E+00, 4.2301946016E-02, 4.1265513799E-02, 3.9276536982E-01],
	[6.0500000000E+03, 2.2443074944E+00, 6.7673981215E+00, 4.2408909336E-02, 4.1367972799E-02, 3.9297643758E-01],
	[6.0550000000E+03, 2.2465634305E+00, 6.7650468456E+00, 4.2516054204E-02, 4.1470597263E-02, 3.9318734065E-01],
	[6.0600000000E+03, 2.2488272017E+00, 6.7627290306E+00, 4.2623380774E-02, 4.1573391002E-02, 3.9339807949E-01],
	[6.0650000000E+03, 2.2510935871E+00, 6.7604230087E+00, 4.2730889205E-02, 4.1676351560E-02, 3.9360865456E-01],
	[6.0700000000E+03, 2.2533603861E+00, 6.7581196725E+00, 4.2838579655E-02, 4.1779477955E-02, 3.9381906632E-01],
	[6.0750000000E+03, 2.2556275984E+00, 6.7558190166E+00, 4.2946452279E-02, 4.1882770301E-02, 3.9402931523E-01],
	[6.0800000000E+03, 2.2578952238E+00, 6.7535210357E+00, 4.3054507236E-02, 4.1986228708E-02, 3.9423940177E-01],
	[6.0850000000E+03, 2.2601632620E+00, 6.7512257246E+00, 4.3162744683E-02, 4.2089853288E-02, 3.9444932637E-01],
	[6.0900000000E+03, 2.2624317128E+00, 6.7489330778E+00, 4.3271164777E-02, 4.2193644154E-02, 3.9465908952E-01],
	[6.0950000000E+03, 2.2647005758E+00, 6.7466430902E+00, 4.3379767675E-02, 4.2297601417E-02, 3.9486869164E-01],
	[6.1000000000E+03, 2.2669698509E+00, 6.7443557564E+00, 4.3488553535E-02, 4.2401725188E-02, 3.9507813321E-01],
	[6.1050000000E+03, 2.2692395378E+00, 6.7420710713E+00, 4.3597522513E-02, 4.2506015579E-02, 3.9528741468E-01],
	[6.1100000000E+03, 2.2715096362E+00, 6.7397890295E+00, 4.3706674768E-02, 4.2610472701E-02, 3.9549653649E-01],
	[6.1150000000E+03, 2.2737801458E+00, 6.7375096259E+00, 4.3816010456E-02, 4.2715096666E-02, 3.9570549910E-01],
	[6.1200000000E+03, 2.2760510663E+00, 6.7352328553E+00, 4.3925529735E-02, 4.2819887585E-02, 3.9591430295E-01],
	[6.1250000000E+03, 2.2783223976E+00, 6.7329587125E+00, 4.4035232762E-02, 4.2924845568E-02, 3.9612294850E-01],
	[6.1300000000E+03, 2.2805941394E+00, 6.7306871923E+00, 4.4145119695E-02, 4.3029970727E-02, 3.9633143618E-01],
	[6.1350000000E+03, 2.2828662913E+00, 6.7284182896E+00, 4.4255190690E-02, 4.3135263173E-02, 3.9653976644E-01],
	[6.1400000000E+03, 2.2851388532E+00, 6.7261519991E+00, 4.4365445905E-02, 4.3240723016E-02, 3.9674793973E-01],
	[6.1450000000E+03, 2.2874118248E+00, 6.7238883158E+00, 4.4475885498E-02, 4.3346350368E-02, 3.9695595648E-01],
	[6.1500000000E+03, 2.2896852057E+00, 6.7216272346E+00, 4.4586509625E-02, 4.3452145338E-02, 3.9716381713E-01],
	[6.1550000000E+03, 2.2919615280E+00, 6.7193791867E+00, 4.4697318444E-02, 4.3558109391E-02, 3.9737152213E-01],
	[6.1600000000E+03, 2.2942450317E+00, 6.7171615791E+00, 4.4808312113E-02, 4.3664244924E-02, 3.9757907191E-01],
	[6.1650000000E+03, 2.2965289549E+00, 6.7149465018E+00, 4.4919490788E-02, 4.3770548446E-02, 3.9778646691E-01],
	[6.1700000000E+03, 2.2988132974E+00, 6.7127339498E+00, 4.5030854627E-02, 4.3877020068E-02, 3.9799370755E-01],
	[6.1750000000E+03, 2.3010980590E+00, 6.7105239182E+00, 4.5142403788E-02, 4.3983659900E-02, 3.9820079428E-01],
	[6.1800000000E+03, 2.3033832393E+00, 6.7083164022E+00, 4.5254138428E-02, 4.4090468053E-02, 3.9840772752E-01],
	[6.1850000000E+03, 2.3056688382E+00, 6.7061113967E+00, 4.5366058703E-02, 4.4197444636E-02, 3.9861450771E-01],
	[6.1900000000E+03, 2.3079548553E+00, 6.7039088969E+00, 4.5478164773E-02, 4.4304589760E-02, 3.9882113527E-01],
	[6.1950000000E+03, 2.3102412904E+00, 6.7017088980E+00, 4.5590456793E-02, 4.4411903534E-02, 3.9902761063E-01],
	[6.2000000000E+03, 2.3125281433E+00, 6.6995113951E+00, 4.5702934921E-02, 4.4519386069E-02, 3.9923393422E-01],
	[6.2050000000E+03, 2.3148154136E+00, 6.6973163834E+00, 4.5815599315E-02, 4.4627037475E-02, 3.9944010647E-01],
	[6.2100000000E+03, 2.3171031011E+00, 6.6951238580E+00, 4.5928450132E-02, 4.4734857861E-02, 3.9964612779E-01],
	[6.2150000000E+03, 2.3193912056E+00, 6.6929338141E+00, 4.6041487530E-02, 4.4842847337E-02, 3.9985199860E-01],
	[6.2200000000E+03, 2.3216797267E+00, 6.6907462469E+00, 4.6154711666E-02, 4.4951006012E-02, 4.0005771934E-01],
	[6.2250000000E+03, 2.3239686643E+00, 6.6885611517E+00, 4.6268122696E-02, 4.5059333996E-02, 4.0026329042E-01],
	[6.2300000000E+03, 2.3262580181E+00, 6.6863785236E+00, 4.6381720780E-02, 4.5167831399E-02, 4.0046871225E-01],
	[6.2350000000E+03, 2.3285477878E+00, 6.6841983579E+00, 4.6495506073E-02, 4.5276498329E-02, 4.0067398526E-01],
	[6.2400000000E+03, 2.3308379731E+00, 6.6820206498E+00, 4.6609478734E-02, 4.5385334896E-02, 4.0087910986E-01],
	[6.2450000000E+03, 2.3331285739E+00, 6.6798453947E+00, 4.6723638920E-02, 4.5494341209E-02, 4.0108408646E-01],
	[6.2500000000E+03, 2.3354195897E+00, 6.6776725877E+00, 4.6837986789E-02, 4.5603517378E-02, 4.0128891548E-01],
	[6.2550000000E+03, 2.3377151380E+00, 6.6755191595E+00, 4.6952522497E-02, 4.5712865878E-02, 4.0149359733E-01],
	[6.2600000000E+03, 2.3400159556E+00, 6.6733880677E+00, 4.7067246203E-02, 4.5822387269E-02, 4.0169813242E-01],
	[6.2650000000E+03, 2.3423171980E+00, 6.6712593569E+00, 4.7182158063E-02, 4.5932078881E-02, 4.0190252117E-01],
	[6.2700000000E+03, 2.3446188650E+00, 6.6691330226E+00, 4.7297258235E-02, 4.6041940823E-02, 4.0210676397E-01],
	[6.2750000000E+03, 2.3469209563E+00, 6.6670090601E+00, 4.7412546877E-02, 4.6151973204E-02, 4.0231086124E-01],
	[6.2800000000E+03, 2.3492234716E+00, 6.6648874649E+00, 4.7528024146E-02, 4.6262176133E-02, 4.0251481338E-01],
	[6.2850000000E+03, 2.3515264106E+00, 6.6627682326E+00, 4.7643690199E-02, 4.6372549718E-02, 4.0271862080E-01],
	[6.2900000000E+03, 2.3538297732E+00, 6.6606513586E+00, 4.7759545195E-02, 4.6483094068E-02, 4.0292228389E-01],
	[6.2950000000E+03, 2.3561335590E+00, 6.6585368385E+00, 4.7875589290E-02, 4.6593809290E-02, 4.0312580307E-01],
	[6.3000000000E+03, 2.3584377678E+00, 6.6564246676E+00, 4.7991822642E-02, 4.6704695494E-02, 4.0332917874E-01],
	[6.3050000000E+03, 2.3607423994E+00, 6.6543148417E+00, 4.8108245408E-02, 4.6815752788E-02, 4.0353241128E-01],
	[6.3100000000E+03, 2.3630474534E+00, 6.6522073562E+00, 4.8224857747E-02, 4.6926981279E-02, 4.0373550111E-01],
	[6.3150000000E+03, 2.3653529297E+00, 6.6501022066E+00, 4.8341659815E-02, 4.7038381076E-02, 4.0393844862E-01],
	[6.3200000000E+03, 2.3676588279E+00, 6.6479993885E+00, 4.8458651769E-02, 4.7149952286E-02, 4.0414125421E-01],
	[6.3250000000E+03, 2.3699651478E+00, 6.6458988976E+00, 4.8575833768E-02, 4.7261695018E-02, 4.0434391826E-01],
	[6.3300000000E+03, 2.3722718892E+00, 6.6438007294E+00, 4.8693205970E-02, 4.7373609379E-02, 4.0454644118E-01],
	[6.3350000000E+03, 2.3745790518E+00, 6.6417048794E+00, 4.8810768530E-02, 4.7485695477E-02, 4.0474882336E-01],
	[6.3400000000E+03, 2.3768866353E+00, 6.6396113434E+00, 4.8928521608E-02, 4.7597953419E-02, 4.0495106519E-01],
	[6.3450000000E+03, 2.3791946394E+00, 6.6375201168E+00, 4.9046465360E-02, 4.7710383313E-02, 4.0515316706E-01],
	[6.3500000000E+03, 2.3815030640E+00, 6.6354311955E+00, 4.9164599944E-02, 4.7822985267E-02, 4.0535512936E-01],
	[6.3550000000E+03, 2.3838147328E+00, 6.6333561877E+00, 4.9282925518E-02, 4.7935761135E-02, 4.0555695248E-01],
	[6.3600000000E+03, 2.3861326321E+00, 6.6313073108E+00, 4.9401442238E-02, 4.8048712896E-02, 4.0575863681E-01],
	[6.3650000000E+03, 2.3884509610E+00, 6.6292606762E+00, 4.9520150264E-02, 4.8161837080E-02, 4.0596018272E-01],
	[6.3700000000E+03, 2.3907697192E+00, 6.6272162796E+00, 4.9639049751E-02, 4.8275133792E-02, 4.0616159062E-01],
	[6.3750000000E+03, 2.3930889066E+00, 6.6251741167E+00, 4.9758140859E-02, 4.8388603139E-02, 4.0636286087E-01],
	[6.3800000000E+03, 2.3954085228E+00, 6.6231341835E+00, 4.9877423743E-02, 4.8502245229E-02, 4.0656399387E-01],
	[6.3850000000E+03, 2.3977285676E+00, 6.6210964758E+00, 4.9996898563E-02, 4.8616060169E-02, 4.0676498999E-01],
	[6.3900000000E+03, 2.4000490407E+00, 6.6190609893E+00, 5.0116565475E-02, 4.8730048065E-02, 4.0696584962E-01],
	[6.3950000000E+03, 2.4023699419E+00, 6.6170277199E+00, 5.0236424637E-02, 4.8844209024E-02, 4.0716657313E-01],
	[6.4000000000E+03, 2.4046912709E+00, 6.6149966635E+00, 5.0356476207E-02, 4.8958543153E-02, 4.0736716091E-01],
	[6.4050000000E+03, 2.4070130275E+00, 6.6129678159E+00, 5.0476720341E-02, 4.9073050558E-02, 4.0756761333E-01],
	[6.4100000000E+03, 2.4093352114E+00, 6.6109411730E+00, 5.0597157199E-02, 4.9187731346E-02, 4.0776793077E-01],
	[6.4150000000E+03, 2.4116578223E+00, 6.6089167307E+00, 5.0717786937E-02, 4.9302585623E-02, 4.0796811360E-01],
	[6.4200000000E+03, 2.4139808600E+00, 6.6068944849E+00, 5.0838609713E-02, 4.9417613495E-02, 4.0816816220E-01],
	[6.4250000000E+03, 2.4163043243E+00, 6.6048744316E+00, 5.0959625684E-02, 4.9532815068E-02, 4.0836807694E-01],
	[6.4300000000E+03, 2.4186282149E+00, 6.6028565665E+00, 5.1080835008E-02, 4.9648190449E-02, 4.0856785819E-01],
	[6.4350000000E+03, 2.4209525315E+00, 6.6008408857E+00, 5.1202237844E-02, 4.9763739743E-02, 4.0876750633E-01],
	[6.4400000000E+03, 2.4232772739E+00, 6.5988273851E+00, 5.1323834347E-02, 4.9879463056E-02, 4.0896702172E-01],
	[6.4450000000E+03, 2.4256024419E+00, 6.5968160607E+00, 5.1445624677E-02, 4.9995360495E-02, 4.0916640473E-01],
	[6.4500000000E+03, 2.4279280351E+00, 6.5948069083E+00, 5.1567608990E-02, 5.0111432164E-02, 4.0936565573E-01],
	[6.4550000000E+03, 2.4302540534E+00, 6.5927999241E+00, 5.1689787444E-02, 5.0227678169E-02, 4.0956477510E-01],
	[6.4600000000E+03, 2.4325877209E+00, 6.5908248293E+00, 5.1812160198E-02, 5.0344103445E-02, 4.0976376318E-01],
	[6.4650000000E+03, 2.4349228899E+00, 6.5888562453E+00, 5.1934727408E-02, 5.0460704020E-02, 4.0996262036E-01],
	[6.4700000000E+03, 2.4372584927E+00, 6.5868897706E+00, 5.2057489232E-02, 5.0577479290E-02, 4.1016134699E-01],
	[6.4750000000E+03, 2.4395945289E+00, 6.5849254012E+00, 5.2180445828E-02, 5.0694429359E-02, 4.1035994344E-01],
	[6.4800000000E+03, 2.4419309984E+00, 6.5829631332E+00, 5.2303597353E-02, 5.0811554333E-02, 4.1055841006E-01],
	[6.4850000000E+03, 2.4442679008E+00, 6.5810029628E+00, 5.2426950255E-02, 5.0928860252E-02, 4.1075674723E-01],
	[6.4900000000E+03, 2.4466052360E+00, 6.5790448861E+00, 5.2550499523E-02, 5.1046342342E-02, 4.1095495529E-01],
	[6.4950000000E+03, 2.4489430036E+00, 6.5770888993E+00, 5.2674244223E-02, 5.1163999680E-02, 4.1115303461E-01],
	[6.5000000000E+03, 2.4512812035E+00, 6.5751349985E+00, 5.2798184514E-02, 5.1281832370E-02, 4.1135098555E-01],
	[6.5050000000E+03, 2.4536198353E+00, 6.5731831800E+00, 5.2922320553E-02, 5.1399840516E-02, 4.1154880847E-01],
	[6.5100000000E+03, 2.4559588989E+00, 6.5712334398E+00, 5.3046652497E-02, 5.1518024225E-02, 4.1174650371E-01],
	[6.5150000000E+03, 2.4582983939E+00, 6.5692857742E+00, 5.3171180506E-02, 5.1636383599E-02, 4.1194407164E-01],
	[6.5200000000E+03, 2.4606383201E+00, 6.5673401794E+00, 5.3295904735E-02, 5.1754918745E-02, 4.1214151264E-01],
	[6.5250000000E+03, 2.4629786773E+00, 6.5653966517E+00, 5.3420825344E-02, 5.1873629766E-02, 4.1233882725E-01],
	[6.5300000000E+03, 2.4653194651E+00, 6.5634551871E+00, 5.3545942489E-02, 5.1992516766E-02, 4.1253601587E-01],
	[6.5350000000E+03, 2.4676606835E+00, 6.5615157820E+00, 5.3671256330E-02, 5.2111579851E-02, 4.1273307884E-01],
	[6.5400000000E+03, 2.4700023320E+00, 6.5595784326E+00, 5.3796767022E-02, 5.2230819124E-02, 4.1293001654E-01],
	[6.5450000000E+03, 2.4723444105E+00, 6.5576431352E+00, 5.3922474725E-02, 5.2350234689E-02, 4.1312682930E-01],
	[6.5500000000E+03, 2.4746869187E+00, 6.5557098860E+00, 5.4048379595E-02, 5.2469826651E-02, 4.1332351749E-01],
	[6.5550000000E+03, 2.4770298564E+00, 6.5537786813E+00, 5.4174481791E-02, 5.2589595112E-02, 4.1352008146E-01],
	[6.5600000000E+03, 2.4793739052E+00, 6.5518523341E+00, 5.4300781471E-02, 5.2709540668E-02, 4.1371652156E-01],
	[6.5650000000E+03, 2.4817256548E+00, 6.5499580195E+00, 5.4427278792E-02, 5.2829668182E-02, 4.1391283814E-01],
	[6.5700000000E+03, 2.4840778420E+00, 6.5480656942E+00, 5.4553973912E-02, 5.2949972549E-02, 4.1410903155E-01],
	[6.5750000000E+03, 2.4864304668E+00, 6.5461753545E+00, 5.4680866989E-02, 5.3070453874E-02, 4.1430510214E-01],
	[6.5800000000E+03, 2.4887835287E+00, 6.5442869969E+00, 5.4807958180E-02, 5.3191112260E-02, 4.1450105025E-01],
	[6.5850000000E+03, 2.4911370276E+00, 6.5424006178E+00, 5.4935247644E-02, 5.3311947810E-02, 4.1469687625E-01],
	[6.5900000000E+03, 2.4934909632E+00, 6.5405162136E+00, 5.5062735538E-02, 5.3432960627E-02, 4.1489258046E-01],
	[6.5950000000E+03, 2.4958453353E+00, 6.5386337807E+00, 5.5190422020E-02, 5.3554150816E-02, 4.1508816323E-01],
	[6.6000000000E+03, 2.4982001435E+00, 6.5367533157E+00, 5.5318307249E-02, 5.3675518479E-02, 4.1528362492E-01],
	[6.6050000000E+03, 2.5005553877E+00, 6.5348748149E+00, 5.5446391380E-02, 5.3797063719E-02, 4.1547896586E-01],
	[6.6100000000E+03, 2.5029110675E+00, 6.5329982748E+00, 5.5574674574E-02, 5.3918786640E-02, 4.1567418639E-01],
	[6.6150000000E+03, 2.5052671829E+00, 6.5311236919E+00, 5.5703156987E-02, 5.4040687344E-02, 4.1586928686E-01],
	[6.6200000000E+03, 2.5076237334E+00, 6.5292510626E+00, 5.5831838777E-02, 5.4162765934E-02, 4.1606426761E-01],
	[6.6250000000E+03, 2.5099807189E+00, 6.5273803835E+00, 5.5960720102E-02, 5.4285022513E-02, 4.1625912897E-01],
	[6.6300000000E+03, 2.5123381391E+00, 6.5255116511E+00, 5.6089801120E-02, 5.4407457183E-02, 4.1645387129E-01],
	[6.6350000000E+03, 2.5146959937E+00, 6.5236448618E+00, 5.6219081989E-02, 5.4530070047E-02, 4.1664849490E-01],
	[6.6400000000E+03, 2.5170542825E+00, 6.5217800123E+00, 5.6348562866E-02, 5.4652861207E-02, 4.1684300013E-01],
	[6.6450000000E+03, 2.5194130053E+00, 6.5199170989E+00, 5.6478243910E-02, 5.4775830766E-02, 4.1703738733E-01],
	[6.6500000000E+03, 2.5217721619E+00, 6.5180561183E+00, 5.6608125279E-02, 5.4898978826E-02, 4.1723165683E-01],
	[6.6550000000E+03, 2.5241317519E+00, 6.5161970669E+00, 5.6738207129E-02, 5.5022305489E-02, 4.1742580897E-01],
	[6.6600000000E+03, 2.5264917751E+00, 6.5143399415E+00, 5.6868489620E-02, 5.5145810857E-02, 4.1761984407E-01],
	[6.6650000000E+03, 2.5288522313E+00, 6.5124847384E+00, 5.6998972909E-02, 5.5269495032E-02, 4.1781376247E-01],
	[6.6700000000E+03, 2.5312204699E+00, 6.5106619331E+00, 5.7129657153E-02, 5.5393363842E-02, 4.1800756449E-01],
	[6.6750000000E+03, 2.5335894101E+00, 6.5088420836E+00, 5.7260542512E-02, 5.5517411908E-02, 4.1820125048E-01],
	[6.6800000000E+03, 2.5359587910E+00, 6.5070241048E+00, 5.7391629141E-02, 5.5641639129E-02, 4.1839482076E-01],
	[6.6850000000E+03, 2.5383286124E+00, 6.5052079935E+00, 5.7522917201E-02, 5.5766045608E-02, 4.1858827566E-01],
	[6.6900000000E+03, 2.5406988741E+00, 6.5033937464E+00, 5.7654406848E-02, 5.5890631445E-02, 4.1878161550E-01],
	[6.6950000000E+03, 2.5430695758E+00, 6.5015813601E+00, 5.7786098240E-02, 5.6015396742E-02, 4.1897484062E-01],
	[6.7000000000E+03, 2.5454407173E+00, 6.4997708313E+00, 5.7917991536E-02, 5.6140341602E-02, 4.1916795133E-01],
	[6.7050000000E+03, 2.5478122982E+00, 6.4979621568E+00, 5.8050086893E-02, 5.6265466124E-02, 4.1936094797E-01],
	[6.7100000000E+03, 2.5501843184E+00, 6.4961553333E+00, 5.8182384469E-02, 5.6390770411E-02, 4.1955383086E-01],
	[6.7150000000E+03, 2.5525567777E+00, 6.4943503575E+00, 5.8314884422E-02, 5.6516254563E-02, 4.1974660033E-01],
	[6.7200000000E+03, 2.5549296757E+00, 6.4925472261E+00, 5.8447586910E-02, 5.6641918681E-02, 4.1993925669E-01],
	[6.7250000000E+03, 2.5573030123E+00, 6.4907459359E+00, 5.8580492091E-02, 5.6767762867E-02, 4.2013180026E-01],
	[6.7300000000E+03, 2.5596767871E+00, 6.4889464837E+00, 5.8713600122E-02, 5.6893787220E-02, 4.2032423138E-01],
	[6.7350000000E+03, 2.5620510000E+00, 6.4871488662E+00, 5.8846911163E-02, 5.7019991843E-02, 4.2051655035E-01],
	[6.7400000000E+03, 2.5644256507E+00, 6.4853530801E+00, 5.8980425370E-02, 5.7146376835E-02, 4.2070875750E-01],
	[6.7450000000E+03, 2.5668007389E+00, 6.4835591223E+00, 5.9114142902E-02, 5.7272942297E-02, 4.2090085315E-01],
	[6.7500000000E+03, 2.5691762645E+00, 6.4817669896E+00, 5.9248063917E-02, 5.7399688330E-02, 4.2109283762E-01],
	[6.7550000000E+03, 2.5715522271E+00, 6.4799766786E+00, 5.9382188572E-02, 5.7526615033E-02, 4.2128471121E-01],
	[6.7600000000E+03, 2.5739286265E+00, 6.4781881863E+00, 5.9516517026E-02, 5.7653722507E-02, 4.2147647426E-01],
	[6.7650000000E+03, 2.5763054625E+00, 6.4764015095E+00, 5.9651049436E-02, 5.7781010853E-02, 4.2166812707E-01],
	[6.7700000000E+03, 2.5786827349E+00, 6.4746166449E+00, 5.9785785961E-02, 5.7908480169E-02, 4.2185966995E-01],
	[6.7750000000E+03, 2.5810641167E+00, 6.4728489398E+00, 5.9920726758E-02, 5.8036133648E-02, 4.2205110323E-01],
	[6.7800000000E+03, 2.5834495308E+00, 6.4710980148E+00, 6.0055871986E-02, 5.8163971352E-02, 4.2224242722E-01],
	[6.7850000000E+03, 2.5858353886E+00, 6.4693488537E+00, 6.0191221802E-02, 5.8291990370E-02, 4.2243364222E-01],
	[6.7900000000E+03, 2.5882216898E+00, 6.4676014533E+00, 6.0326776365E-02, 5.8420190803E-02, 4.2262474855E-01],
	[6.7950000000E+03, 2.5906084342E+00, 6.4658558107E+00, 6.0462535832E-02, 5.8548572750E-02, 4.2281574652E-01],
	[6.8000000000E+03, 2.5929956214E+00, 6.4641119228E+00, 6.0598500362E-02, 5.8677136311E-02, 4.2300663644E-01],
	[6.8050000000E+03, 2.5953832514E+00, 6.4623697865E+00, 6.0734670112E-02, 5.8805881585E-02, 4.2319741862E-01],
	[6.8100000000E+03, 2.5977713237E+00, 6.4606293987E+00, 6.0871045241E-02, 5.8934808671E-02, 4.2338809337E-01],
	[6.8150000000E+03, 2.6001598383E+00, 6.4588907565E+00, 6.1007625906E-02, 5.9063917669E-02, 4.2357866100E-01],
	[6.8200000000E+03, 2.6025487948E+00, 6.4571538568E+00, 6.1144412266E-02, 5.9193208679E-02, 4.2376912180E-01],
	[6.8250000000E+03, 2.6049381930E+00, 6.4554186966E+00, 6.1281404478E-02, 5.9322681798E-02, 4.2395947610E-01],
	[6.8300000000E+03, 2.6073280327E+00, 6.4536852729E+00, 6.1418602701E-02, 5.9452337127E-02, 4.2414972418E-01],
	[6.8350000000E+03, 2.6097183136E+00, 6.4519535826E+00, 6.1556007092E-02, 5.9582174764E-02, 4.2433986637E-01],
	[6.8400000000E+03, 2.6121090354E+00, 6.4502236228E+00, 6.1693617810E-02, 5.9712194807E-02, 4.2452990296E-01],
	[6.8450000000E+03, 2.6145001980E+00, 6.4484953905E+00, 6.1831435013E-02, 5.9842397357E-02, 4.2471983426E-01],
	[6.8500000000E+03, 2.6168918011E+00, 6.4467688827E+00, 6.1969458859E-02, 5.9972782510E-02, 4.2490966056E-01],
	[6.8550000000E+03, 2.6192838445E+00, 6.4450440963E+00, 6.2107689505E-02, 6.0103350366E-02, 4.2509938218E-01],
	[6.8600000000E+03, 2.6216763279E+00, 6.4433210285E+00, 6.2246127110E-02, 6.0234101022E-02, 4.2528899940E-01],
	[6.8650000000E+03, 2.6240692510E+00, 6.4415996763E+00, 6.2384771832E-02, 6.0365034578E-02, 4.2547851254E-01],
	[6.8700000000E+03, 2.6264626137E+00, 6.4398800368E+00, 6.2523623829E-02, 6.0496151132E-02, 4.2566792189E-01],
	[6.8750000000E+03, 2.6288564157E+00, 6.4381621068E+00, 6.2662683259E-02, 6.0627450780E-02, 4.2585722775E-01],
	[6.8800000000E+03, 2.6312506567E+00, 6.4364458837E+00, 6.2801950280E-02, 6.0758933623E-02, 4.2604643042E-01],
	[6.8850000000E+03, 2.6336501802E+00, 6.4347517932E+00, 6.2941425050E-02, 6.0890604174E-02, 4.2623553020E-01],
	[6.8900000000E+03, 2.6360522225E+00, 6.4330681194E+00, 6.3081107728E-02, 6.1022460045E-02, 4.2642452738E-01],
	[6.8950000000E+03, 2.6384547107E+00, 6.4313861070E+00, 6.3220998470E-02, 6.1154499448E-02, 4.2661342225E-01],
	[6.9000000000E+03, 2.6408576446E+00, 6.4297057532E+00, 6.3361097437E-02, 6.1286722480E-02, 4.2680221513E-01],
	[6.9050000000E+03, 2.6432610239E+00, 6.4280270552E+00, 6.3501404785E-02, 6.1419129238E-02, 4.2699090629E-01],
	[6.9100000000E+03, 2.6456648484E+00, 6.4263500101E+00, 6.3641920672E-02, 6.1551719822E-02, 4.2717949603E-01],
	[6.9150000000E+03, 2.6480691179E+00, 6.4246746151E+00, 6.3782645257E-02, 6.1684494327E-02, 4.2736798466E-01],
	[6.9200000000E+03, 2.6504738321E+00, 6.4230008674E+00, 6.3923578698E-02, 6.1817452852E-02, 4.2755637245E-01],
	[6.9250000000E+03, 2.6528789907E+00, 6.4213287642E+00, 6.4064721153E-02, 6.1950595493E-02, 4.2774465970E-01],
	[6.9300000000E+03, 2.6552845936E+00, 6.4196583027E+00, 6.4206072780E-02, 6.2083922347E-02, 4.2793284671E-01],
	[6.9350000000E+03, 2.6576906405E+00, 6.4179894801E+00, 6.4347633737E-02, 6.2217433513E-02, 4.2812093376E-01],
	[6.9400000000E+03, 2.6600971312E+00, 6.4163222936E+00, 6.4489404183E-02, 6.2351129086E-02, 4.2830892115E-01],
	[6.9450000000E+03, 2.6625040654E+00, 6.4146567404E+00, 6.4631384275E-02, 6.2485009163E-02, 4.2849680915E-01],
	[6.9500000000E+03, 2.6649114428E+00, 6.4129928178E+00, 6.4773574171E-02, 6.2619073842E-02, 4.2868459808E-01],
	[6.9550000000E+03, 2.6673192633E+00, 6.4113305229E+00, 6.4915974031E-02, 6.2753323218E-02, 4.2887228820E-01],
	[6.9600000000E+03, 2.6697275266E+00, 6.4096698531E+00, 6.5058584011E-02, 6.2887757389E-02, 4.2905987980E-01],
	[6.9650000000E+03, 2.6721362325E+00, 6.4080108055E+00, 6.5201404270E-02, 6.3022376450E-02, 4.2924737319E-01],
	[6.9700000000E+03, 2.6745453807E+00, 6.4063533775E+00, 6.5344434966E-02, 6.3157180498E-02, 4.2943476863E-01],
	[6.9750000000E+03, 2.6769549711E+00, 6.4046975662E+00, 6.5487676258E-02, 6.3292169629E-02, 4.2962206642E-01],
	[6.9800000000E+03, 2.6793650032E+00, 6.4030433690E+00, 6.5631128303E-02, 6.3427343939E-02, 4.2980926684E-01],
	[6.9850000000E+03, 2.6817754771E+00, 6.4013907831E+00, 6.5774791259E-02, 6.3562703525E-02, 4.2999637018E-01],
	[6.9900000000E+03, 2.6841863923E+00, 6.3997398058E+00, 6.5918665286E-02, 6.3698248481E-02, 4.3018337671E-01],
	[6.9950000000E+03, 2.6866013277E+00, 6.3981056790E+00, 6.6062750540E-02, 6.3833982443E-02, 4.3037028673E-01],
	[7.0000000000E+03, 2.6890197139E+00, 6.3964859255E+00, 6.6207047181E-02, 6.3969904971E-02, 4.3055710051E-01],
	[7.0050000000E+03, 2.6914385479E+00, 6.3948677382E+00, 6.6352959300E-02, 6.4107323719E-02, 4.3074381834E-01],
	[7.0100000000E+03, 2.6938578295E+00, 6.3932511144E+00, 6.6499088304E-02, 6.4244932812E-02, 4.3093044049E-01],
	[7.0150000000E+03, 2.6962775585E+00, 6.3916360516E+00, 6.6645434360E-02, 6.4382732353E-02, 4.3111696725E-01],
	[7.0200000000E+03, 2.6986977345E+00, 6.3900225471E+00, 6.6791997633E-02, 6.4520722444E-02, 4.3130339890E-01],
	[7.0250000000E+03, 2.7011183575E+00, 6.3884105982E+00, 6.6938778291E-02, 6.4658903185E-02, 4.3148973572E-01],
	[7.0300000000E+03, 2.7035394270E+00, 6.3868002024E+00, 6.7085776501E-02, 6.4797274678E-02, 4.3167597798E-01],
	[7.0350000000E+03, 2.7059609430E+00, 6.3851913571E+00, 6.7232992430E-02, 6.4935837024E-02, 4.3186212597E-01],
	[7.0400000000E+03, 2.7083829051E+00, 6.3835840598E+00, 6.7380426244E-02, 6.5074590324E-02, 4.3204817996E-01],
	[7.0450000000E+03, 2.7108053131E+00, 6.3819783077E+00, 6.7528078110E-02, 6.5213534679E-02, 4.3223414027E-01],
	[7.0500000000E+03, 2.7132281669E+00, 6.3803740983E+00, 6.7675948195E-02, 6.5352670189E-02, 4.3242000720E-01],
	[7.0550000000E+03, 2.7156514661E+00, 6.3787714291E+00, 6.7824036666E-02, 6.5491996956E-02, 4.3260578101E-01],
	[7.0600000000E+03, 2.7180752105E+00, 6.3771702974E+00, 6.7972343689E-02, 6.5631515080E-02, 4.3279146196E-01],
	[7.0650000000E+03, 2.7204993999E+00, 6.3755707008E+00, 6.8120869433E-02, 6.5771224661E-02, 4.3297705030E-01],
	[7.0700000000E+03, 2.7229240341E+00, 6.3739726367E+00, 6.8269614062E-02, 6.5911125800E-02, 4.3316254629E-01],
	[7.0750000000E+03, 2.7253491128E+00, 6.3723761024E+00, 6.8418577746E-02, 6.6051218597E-02, 4.3334795018E-01],
	[7.0800000000E+03, 2.7277746358E+00, 6.3707810955E+00, 6.8567760649E-02, 6.6191503153E-02, 4.3353326223E-01],
	[7.0850000000E+03, 2.7302006028E+00, 6.3691876135E+00, 6.8717162940E-02, 6.6331979566E-02, 4.3371848269E-01],
	[7.0900000000E+03, 2.7326270137E+00, 6.3675956537E+00, 6.8866784784E-02, 6.6472647938E-02, 4.3390361182E-01],
	[7.0950000000E+03, 2.7350538682E+00, 6.3660052137E+00, 6.9016626350E-02, 6.6613508368E-02, 4.3408864987E-01],
	[7.1000000000E+03, 2.7374811660E+00, 6.3644162910E+00, 6.9166687804E-02, 6.6754560955E-02, 4.3427359709E-01],
	[7.1050000000E+03, 2.7399090993E+00, 6.3628297021E+00, 6.9316969312E-02, 6.6895806005E-02, 4.3445845373E-01],
	[7.1100000000E+03, 2.7423436127E+00, 6.3612707294E+00, 6.9467471043E-02, 6.7037249979E-02, 4.3464322004E-01],
	[7.1150000000E+03, 2.7447785755E+00, 6.3597132343E+00, 6.9618193162E-02, 6.7178886457E-02, 4.3482789628E-01],
	[7.1200000000E+03, 2.7472139875E+00, 6.3581572143E+00, 6.9769135837E-02, 6.7320715538E-02, 4.3501248270E-01],
	[7.1250000000E+03, 2.7496498486E+00, 6.3566026668E+00, 6.9920299234E-02, 6.7462737321E-02, 4.3519697954E-01],
	[7.1300000000E+03, 2.7520861583E+00, 6.3550495896E+00, 7.0071683521E-02, 6.7604951905E-02, 4.3538138706E-01],
	[7.1350000000E+03, 2.7545229166E+00, 6.3534979802E+00, 7.0223288865E-02, 6.7747359390E-02, 4.3556570549E-01],
	[7.1400000000E+03, 2.7569601231E+00, 6.3519478362E+00, 7.0375115433E-02, 6.7889959875E-02, 4.3574993510E-01],
	[7.1450000000E+03, 2.7593977777E+00, 6.3503991551E+00, 7.0527163391E-02, 6.8032753458E-02, 4.3593407613E-01],
	[7.1500000000E+03, 2.7618358801E+00, 6.3488519346E+00, 7.0679432907E-02, 6.8175740238E-02, 4.3611812882E-01],
	[7.1550000000E+03, 2.7642744301E+00, 6.3473061722E+00, 7.0831924148E-02, 6.8318920315E-02, 4.3630209342E-01],
	[7.1600000000E+03, 2.7667134275E+00, 6.3457618657E+00, 7.0984637280E-02, 6.8462293786E-02, 4.3648597018E-01],
	[7.1650000000E+03, 2.7691528720E+00, 6.3442190125E+00, 7.1137572471E-02, 6.8605860750E-02, 4.3666975934E-01],
	[7.1700000000E+03, 2.7715927634E+00, 6.3426776103E+00, 7.1290729888E-02, 6.8749621305E-02, 4.3685346116E-01],
	[7.1750000000E+03, 2.7740331014E+00, 6.3411376568E+00, 7.1444109698E-02, 6.8893575551E-02, 4.3703707586E-01],
	[7.1800000000E+03, 2.7764738859E+00, 6.3395991495E+00, 7.1597712068E-02, 6.9037723584E-02, 4.3722060370E-01],
	[7.1850000000E+03, 2.7789151166E+00, 6.3380620861E+00, 7.1751537164E-02, 6.9182065503E-02, 4.3740404492E-01],
	[7.1900000000E+03, 2.7813567933E+00, 6.3365264643E+00, 7.1905585155E-02, 6.9326601405E-02, 4.3758739976E-01],
	[7.1950000000E+03, 2.7837989157E+00, 6.3349922816E+00, 7.2059856207E-02, 6.9471331390E-02, 4.3777066847E-01],
	[7.2000000000E+03, 2.7862414837E+00, 6.3334595358E+00, 7.2214350487E-02, 6.9616255553E-02, 4.3795385129E-01],
	[7.2050000000E+03, 2.7886844969E+00, 6.3319282245E+00, 7.2369068162E-02, 6.9761373993E-02, 4.3813694845E-01],
	[7.2100000000E+03, 2.7911279552E+00, 6.3303983453E+00, 7.2524009400E-02, 6.9906686808E-02, 4.3831996020E-01],
	[7.2150000000E+03, 2.7935718583E+00, 6.3288698960E+00, 7.2679174367E-02, 7.0052194094E-02, 4.3850288679E-01],
	[7.2200000000E+03, 2.7960171490E+00, 6.3273468757E+00, 7.2834563231E-02, 7.0197897036E-02, 4.3868572844E-01],
	[7.2250000000E+03, 2.7984680385E+00, 6.3258471232E+00, 7.2990176159E-02, 7.0343800609E-02, 4.3886848540E-01],
	[7.2300000000E+03, 2.8009193786E+00, 6.3243487633E+00, 7.3146013318E-02, 7.0489898994E-02, 4.3905115791E-01],
	[7.2350000000E+03, 2.8033711691E+00, 6.3228517938E+00, 7.3302074875E-02, 7.0636192287E-02, 4.3923374621E-01],
	[7.2400000000E+03, 2.8058234097E+00, 6.3213562124E+00, 7.3458360997E-02, 7.0782680586E-02, 4.3941625054E-01],
	[7.2450000000E+03, 2.8082761003E+00, 6.3198620169E+00, 7.3614871851E-02, 7.0929363987E-02, 4.3959867112E-01],
	[7.2500000000E+03, 2.8107292405E+00, 6.3183692051E+00, 7.3771607605E-02, 7.1076242588E-02, 4.3978100821E-01],
	[7.2550000000E+03, 2.8131828302E+00, 6.3168777747E+00, 7.3928568426E-02, 7.1223316484E-02, 4.3996326203E-01],
	[7.2600000000E+03, 2.8156368691E+00, 6.3153877235E+00, 7.4085754481E-02, 7.1370585773E-02, 4.4014543282E-01],
	[7.2650000000E+03, 2.8180913571E+00, 6.3138990493E+00, 7.4243165937E-02, 7.1518050551E-02, 4.4032752082E-01],
	[7.2700000000E+03, 2.8205462938E+00, 6.3124117498E+00, 7.4400802961E-02, 7.1665710914E-02, 4.4050952626E-01],
	[7.2750000000E+03, 2.8230016791E+00, 6.3109258229E+00, 7.4558665721E-02, 7.1813566958E-02, 4.4069144939E-01],
	[7.2800000000E+03, 2.8254575127E+00, 6.3094412663E+00, 7.4716754384E-02, 7.1961618780E-02, 4.4087329042E-01],
	[7.2850000000E+03, 2.8279137944E+00, 6.3079580778E+00, 7.4875069116E-02, 7.2109866475E-02, 4.4105504960E-01],
	[7.2900000000E+03, 2.8303705240E+00, 6.3064762552E+00, 7.5033610086E-02, 7.2258310140E-02, 4.4123672716E-01],
	[7.2950000000E+03, 2.8328277012E+00, 6.3049957964E+00, 7.5192377460E-02, 7.2406949869E-02, 4.4141832333E-01],
	[7.3000000000E+03, 2.8352853258E+00, 6.3035166991E+00, 7.5351371406E-02, 7.2555785759E-02, 4.4159983835E-01],
	[7.3050000000E+03, 2.8377433977E+00, 6.3020389612E+00, 7.5510592091E-02, 7.2704817906E-02, 4.4178127244E-01],
	[7.3100000000E+03, 2.8402019165E+00, 6.3005625805E+00, 7.5670039683E-02, 7.2854046404E-02, 4.4196262585E-01],
	[7.3150000000E+03, 2.8426608821E+00, 6.2990875547E+00, 7.5829714347E-02, 7.3003471348E-02, 4.4214389879E-01],
	[7.3200000000E+03, 2.8451202942E+00, 6.2976138818E+00, 7.5989616253E-02, 7.3153092835E-02, 4.4232509150E-01],
	[7.3250000000E+03, 2.8475801525E+00, 6.2961415596E+00, 7.6149745567E-02, 7.3302910959E-02, 4.4250620421E-01],
	[7.3300000000E+03, 2.8500404570E+00, 6.2946705859E+00, 7.6310102456E-02, 7.3452925815E-02, 4.4268723716E-01],
	[7.3350000000E+03, 2.8525012073E+00, 6.2932009586E+00, 7.6470687088E-02, 7.3603137498E-02, 4.4286819056E-01],
	[7.3400000000E+03, 2.8549677418E+00, 6.2917552726E+00, 7.6631499630E-02, 7.3753552771E-02, 4.4304906465E-01],
	[7.3450000000E+03, 2.8574352504E+00, 6.2903131151E+00, 7.6792540249E-02, 7.3904165760E-02, 4.4322985966E-01],
	[7.3500000000E+03, 2.8599032104E+00, 6.2888722691E+00, 7.6953809113E-02, 7.4054975910E-02, 4.4341057582E-01],
	[7.3550000000E+03, 2.8623716214E+00, 6.2874327327E+00, 7.7115306389E-02, 7.4205983315E-02, 4.4359121335E-01],
	[7.3600000000E+03, 2.8648404833E+00, 6.2859945038E+00, 7.7277032244E-02, 7.4357188069E-02, 4.4377177248E-01],
	[7.3650000000E+03, 2.8673097958E+00, 6.2845575802E+00, 7.7438986846E-02, 7.4508590267E-02, 4.4395225343E-01],
	[7.3700000000E+03, 2.8697795588E+00, 6.2831219600E+00, 7.7601170363E-02, 7.4660190004E-02, 4.4413265644E-01],
	[7.3750000000E+03, 2.8722497719E+00, 6.2816876410E+00, 7.7763582960E-02, 7.4811987373E-02, 4.4431298173E-01],
	[7.3800000000E+03, 2.8747204350E+00, 6.2802546211E+00, 7.7926224807E-02, 7.4963982468E-02, 4.4449322953E-01],
	[7.3850000000E+03, 2.8771915478E+00, 6.2788228984E+00, 7.8089096069E-02, 7.5116175383E-02, 4.4467340005E-01],
	[7.3900000000E+03, 2.8796631101E+00, 6.2773924708E+00, 7.8252196915E-02, 7.5268566213E-02, 4.4485349354E-01],
	[7.3950000000E+03, 2.8821351218E+00, 6.2759633363E+00, 7.8415527513E-02, 7.5421155050E-02, 4.4503351020E-01],
	[7.4000000000E+03, 2.8846075825E+00, 6.2745354927E+00, 7.8579088028E-02, 7.5573941988E-02, 4.4521345026E-01],
	[7.4050000000E+03, 2.8870804921E+00, 6.2731089380E+00, 7.8742878630E-02, 7.5726927120E-02, 4.4539331395E-01],
	[7.4100000000E+03, 2.8895538503E+00, 6.2716836703E+00, 7.8906899485E-02, 7.5880110541E-02, 4.4557310150E-01],
	[7.4150000000E+03, 2.8920276569E+00, 6.2702596875E+00, 7.9071150760E-02, 7.6033492342E-02, 4.4575281311E-01],
	[7.4200000000E+03, 2.8945019117E+00, 6.2688369875E+00, 7.9235632624E-02, 7.6187072618E-02, 4.4593244902E-01],
	[7.4250000000E+03, 2.8969766144E+00, 6.2674155684E+00, 7.9400345243E-02, 7.6340851460E-02, 4.4611200945E-01],
	[7.4300000000E+03, 2.8994517649E+00, 6.2659954282E+00, 7.9565288785E-02, 7.6494828963E-02, 4.4629149462E-01],
	[7.4350000000E+03, 2.9019273630E+00, 6.2645765647E+00, 7.9730463418E-02, 7.6649005218E-02, 4.4647090475E-01],
	[7.4400000000E+03, 2.9044034083E+00, 6.2631589761E+00, 7.9895869309E-02, 7.6803380319E-02, 4.4665024006E-01],
	[7.4450000000E+03, 2.9068799007E+00, 6.2617426603E+00, 8.0061506625E-02, 7.6957954357E-02, 4.4682950077E-01],
	[7.4500000000E+03, 2.9093568400E+00, 6.2603276153E+00, 8.0227375534E-02, 7.7112727425E-02, 4.4700868710E-01],
	[7.4550000000E+03, 2.9118358716E+00, 6.2589208082E+00, 8.0393476204E-02, 7.7267701837E-02, 4.4718779928E-01],
	[7.4600000000E+03, 2.9143193308E+00, 6.2575320956E+00, 8.0559808802E-02, 7.7422880864E-02, 4.4736683751E-01],
	[7.4650000000E+03, 2.9168032421E+00, 6.2561446213E+00, 8.0726373495E-02, 7.7578259248E-02, 4.4754580203E-01],
	[7.4700000000E+03, 2.9192876052E+00, 6.2547583833E+00, 8.0893170451E-02, 7.7733837082E-02, 4.4772469304E-01],
	[7.4750000000E+03, 2.9217724198E+00, 6.2533733798E+00, 8.1060199837E-02, 7.7889614457E-02, 4.4790351077E-01],
	[7.4800000000E+03, 2.9242576858E+00, 6.2519896087E+00, 8.1227461822E-02, 7.8045591466E-02, 4.4808225543E-01],
	[7.4850000000E+03, 2.9267434029E+00, 6.2506070682E+00, 8.1394956572E-02, 7.8201768200E-02, 4.4826092725E-01],
	[7.4900000000E+03, 2.9292295710E+00, 6.2492257564E+00, 8.1562684255E-02, 7.8358144751E-02, 4.4843952643E-01],
	[7.4950000000E+03, 2.9317161897E+00, 6.2478456713E+00, 8.1730645039E-02, 7.8514721211E-02, 4.4861805320E-01],
	[7.5000000000E+03, 2.9342032589E+00, 6.2464668111E+00, 8.1898839091E-02, 7.8671497670E-02, 4.4879650777E-01],
	[7.5050000000E+03, 2.9366907784E+00, 6.2450891737E+00, 8.2067266579E-02, 7.8828474220E-02, 4.4897489035E-01],
	[7.5100000000E+03, 2.9391787479E+00, 6.2437127575E+00, 8.2235927671E-02, 7.8985650953E-02, 4.4915320117E-01],
	[7.5150000000E+03, 2.9416671672E+00, 6.2423375603E+00, 8.2404822533E-02, 7.9143027958E-02, 4.4933144044E-01],
	[7.5200000000E+03, 2.9441560362E+00, 6.2409635805E+00, 8.2573951334E-02, 7.9300605328E-02, 4.4950960837E-01],
	[7.5250000000E+03, 2.9466453545E+00, 6.2395908159E+00, 8.2743314241E-02, 7.9458383154E-02, 4.4968770518E-01],
	[7.5300000000E+03, 2.9491351220E+00, 6.2382192649E+00, 8.2912911422E-02, 7.9616361524E-02, 4.4986573108E-01],
	[7.5350000000E+03, 2.9516253384E+00, 6.2368489255E+00, 8.3082743044E-02, 7.9774540531E-02, 4.5004368628E-01],
	[7.5400000000E+03, 2.9541160036E+00, 6.2354797958E+00, 8.3252809276E-02, 7.9932920265E-02, 4.5022157097E-01],
	[7.5450000000E+03, 2.9566071173E+00, 6.2341118740E+00, 8.3423110284E-02, 8.0091500816E-02, 4.5039938532E-01],
	[7.5500000000E+03, 2.9590986793E+00, 6.2327451582E+00, 8.3593646236E-02, 8.0250282275E-02, 4.5057712953E-01],
	[7.5550000000E+03, 2.9615906894E+00, 6.2313796465E+00, 8.3764417301E-02, 8.0409264730E-02, 4.5075480379E-01],
	[7.5600000000E+03, 2.9640831473E+00, 6.2300153371E+00, 8.3935423645E-02, 8.0568448274E-02, 4.5093240827E-01],
	[7.5650000000E+03, 2.9665760529E+00, 6.2286522281E+00, 8.4106665436E-02, 8.0727832994E-02, 4.5110994316E-01],
	[7.5700000000E+03, 2.9690694059E+00, 6.2272903178E+00, 8.4278142843E-02, 8.0887418982E-02, 4.5128740865E-01],
	[7.5750000000E+03, 2.9715647909E+00, 6.2259363262E+00, 8.4449856032E-02, 8.1047208644E-02, 4.5146480493E-01],
	[7.5800000000E+03, 2.9740644265E+00, 6.2245996333E+00, 8.4621805171E-02, 8.1207205345E-02, 4.5164213217E-01],
	[7.5850000000E+03, 2.9765645145E+00, 6.2232641085E+00, 8.4793990428E-02, 8.1367403633E-02, 4.5181939056E-01],
	[7.5900000000E+03, 2.9790650545E+00, 6.2219297500E+00, 8.4966411971E-02, 8.1527803598E-02, 4.5199658028E-01],
	[7.5950000000E+03, 2.9815660464E+00, 6.2205965561E+00, 8.5139069968E-02, 8.1688405330E-02, 4.5217370152E-01],
	[7.6000000000E+03, 2.9840674898E+00, 6.2192645249E+00, 8.5311964585E-02, 8.1849208918E-02, 4.5235075447E-01],
	[7.6050000000E+03, 2.9865693848E+00, 6.2179336548E+00, 8.5485095992E-02, 8.2010214451E-02, 4.5252773929E-01],
	[7.6100000000E+03, 2.9890717309E+00, 6.2166039439E+00, 8.5658464355E-02, 8.2171422017E-02, 4.5270465618E-01],
	[7.6150000000E+03, 2.9915745280E+00, 6.2152753904E+00, 8.5832069843E-02, 8.2332831707E-02, 4.5288150532E-01],
	[7.6200000000E+03, 2.9940777759E+00, 6.2139479926E+00, 8.6005912622E-02, 8.2494443608E-02, 4.5305828688E-01],
	[7.6250000000E+03, 2.9965814743E+00, 6.2126217488E+00, 8.6179992862E-02, 8.2656257809E-02, 4.5323500106E-01],
	[7.6300000000E+03, 2.9990856231E+00, 6.2112966571E+00, 8.6354310729E-02, 8.2818274398E-02, 4.5341164803E-01],
	[7.6350000000E+03, 3.0015902220E+00, 6.2099727158E+00, 8.6528866392E-02, 8.2980493465E-02, 4.5358822797E-01],
	[7.6400000000E+03, 3.0040952709E+00, 6.2086499232E+00, 8.6703660018E-02, 8.3142915097E-02, 4.5376474106E-01],
	[7.6450000000E+03, 3.0066007694E+00, 6.2073282775E+00, 8.6878691774E-02, 8.3305539383E-02, 4.5394118749E-01],
	[7.6500000000E+03, 3.0091067174E+00, 6.2060077769E+00, 8.7053961830E-02, 8.3468366410E-02, 4.5411756743E-01],
	[7.6550000000E+03, 3.0116131147E+00, 6.2046884198E+00, 8.7229470352E-02, 8.3631396267E-02, 4.5429388107E-01],
	[7.6600000000E+03, 3.0141199611E+00, 6.2033702044E+00, 8.7405217508E-02, 8.3794629041E-02, 4.5447012858E-01],
	[7.6650000000E+03, 3.0166272563E+00, 6.2020531290E+00, 8.7581203467E-02, 8.3958064820E-02, 4.5464631014E-01],
	[7.6700000000E+03, 3.0191350002E+00, 6.2007371917E+00, 8.7757428396E-02, 8.4121703691E-02, 4.5482242594E-01],
	[7.6750000000E+03, 3.0216431924E+00, 6.1994223910E+00, 8.7933892462E-02, 8.4285545743E-02, 4.5499847614E-01],
	[7.6800000000E+03, 3.0241518329E+00, 6.1981087251E+00, 8.8110595834E-02, 8.4449591061E-02, 4.5517446093E-01],
	[7.6850000000E+03, 3.0266609214E+00, 6.1967961922E+00, 8.8287538680E-02, 8.4613839734E-02, 4.5535038049E-01],
	[7.6900000000E+03, 3.0291704577E+00, 6.1954847907E+00, 8.8464721167E-02, 8.4778291849E-02, 4.5552623500E-01],
	[7.6950000000E+03, 3.0316804416E+00, 6.1941745188E+00, 8.8642143464E-02, 8.4942947492E-02, 4.5570202463E-01],
	[7.7000000000E+03, 3.0341955537E+00, 6.1928852904E+00, 8.8819805737E-02, 8.5107814194E-02, 4.5587774956E-01],
	[7.7050000000E+03, 3.0367115833E+00, 6.1915991455E+00, 8.8997708156E-02, 8.5272885389E-02, 4.5605340996E-01],
	[7.7100000000E+03, 3.0392280649E+00, 6.1903141017E+00, 8.9175850887E-02, 8.5438160426E-02, 4.5622900602E-01],
	[7.7150000000E+03, 3.0417449985E+00, 6.1890301575E+00, 8.9354234099E-02, 8.5603639392E-02, 4.5640453791E-01],
	[7.7200000000E+03, 3.0442623838E+00, 6.1877473112E+00, 8.9532857960E-02, 8.5769322373E-02, 4.5658000580E-01],
	[7.7250000000E+03, 3.0467802206E+00, 6.1864655611E+00, 8.9711722638E-02, 8.5935209455E-02, 4.5675540988E-01],
	[7.7300000000E+03, 3.0492985086E+00, 6.1851849056E+00, 8.9890828300E-02, 8.6101300726E-02, 4.5693075031E-01],
	[7.7350000000E+03, 3.0518172478E+00, 6.1839053431E+00, 9.0070175114E-02, 8.6267596270E-02, 4.5710602728E-01],
	[7.7400000000E+03, 3.0543364378E+00, 6.1826268718E+00, 9.0249763249E-02, 8.6434096175E-02, 4.5728124096E-01],
	[7.7450000000E+03, 3.0568560784E+00, 6.1813494903E+00, 9.0429592872E-02, 8.6600800526E-02, 4.5745639153E-01],
	[7.7500000000E+03, 3.0593761695E+00, 6.1800731968E+00, 9.0609664151E-02, 8.6767709408E-02, 4.5763147915E-01],
	[7.7550000000E+03, 3.0618967108E+00, 6.1787979897E+00, 9.0789977255E-02, 8.6934822909E-02, 4.5780650400E-01],
	[7.7600000000E+03, 3.0644177021E+00, 6.1775238674E+00, 9.0970532350E-02, 8.7102141112E-02, 4.5798146627E-01],
	[7.7650000000E+03, 3.0669391432E+00, 6.1762508282E+00, 9.1151329606E-02, 8.7269664104E-02, 4.5815636611E-01],
	[7.7700000000E+03, 3.0694610339E+00, 6.1749788707E+00, 9.1332369190E-02, 8.7437391970E-02, 4.5833120371E-01],
	[7.7750000000E+03, 3.0719833741E+00, 6.1737079930E+00, 9.1513651270E-02, 8.7605324795E-02, 4.5850597924E-01],
	[7.7800000000E+03, 3.0745061634E+00, 6.1724381937E+00, 9.1695176014E-02, 8.7773462665E-02, 4.5868069287E-01],
	[7.7850000000E+03, 3.0770294016E+00, 6.1711694711E+00, 9.1876943590E-02, 8.7941805663E-02, 4.5885534477E-01],
	[7.7900000000E+03, 3.0795530887E+00, 6.1699018237E+00, 9.2058954166E-02, 8.8110353875E-02, 4.5902993512E-01],
	[7.7950000000E+03, 3.0820772242E+00, 6.1686352497E+00, 9.2241207910E-02, 8.8279107387E-02, 4.5920446410E-01],
	[7.8000000000E+03, 3.0846018082E+00, 6.1673697477E+00, 9.2423704990E-02, 8.8448066281E-02, 4.5937893186E-01],
	[7.8050000000E+03, 3.0871268402E+00, 6.1661053160E+00, 9.2606445575E-02, 8.8617230643E-02, 4.5955333859E-01],
	[7.8100000000E+03, 3.0896523202E+00, 6.1648419531E+00, 9.2789429831E-02, 8.8786600557E-02, 4.5972768445E-01],
	[7.8150000000E+03, 3.0921782480E+00, 6.1635796573E+00, 9.2972657928E-02, 8.8956176108E-02, 4.5990196963E-01],
	[7.8200000000E+03, 3.0947052719E+00, 6.1623212054E+00, 9.3156130033E-02, 8.9125958498E-02, 4.6007619428E-01],
	[7.8250000000E+03, 3.0972369992E+00, 6.1610820222E+00, 9.3339846314E-02, 8.9295954061E-02, 4.6025035858E-01],
	[7.8300000000E+03, 3.0997691784E+00, 6.1598438796E+00, 9.3523806939E-02, 8.9466155567E-02, 4.6042446270E-01],
	[7.8350000000E+03, 3.1023018094E+00, 6.1586067760E+00, 9.3708012077E-02, 8.9636563100E-02, 4.6059850682E-01],
	[7.8400000000E+03, 3.1048348920E+00, 6.1573707097E+00, 9.3892461896E-02, 8.9807176743E-02, 4.6077249109E-01],
	[7.8450000000E+03, 3.1073684260E+00, 6.1561356794E+00, 9.4077156563E-02, 8.9977996580E-02, 4.6094641570E-01],
	[7.8500000000E+03, 3.1099024111E+00, 6.1549016835E+00, 9.4262096247E-02, 9.0149022694E-02, 4.6112028081E-01],
	[7.8550000000E+03, 3.1124368471E+00, 6.1536687204E+00, 9.4447281115E-02, 9.0320255170E-02, 4.6129408659E-01],
	[7.8600000000E+03, 3.1149717339E+00, 6.1524367886E+00, 9.4632711337E-02, 9.0491694089E-02, 4.6146783321E-01],
	[7.8650000000E+03, 3.1175070712E+00, 6.1512058867E+00, 9.4818387079E-02, 9.0663339536E-02, 4.6164152084E-01],
	[7.8700000000E+03, 3.1200428588E+00, 6.1499760131E+00, 9.5004308511E-02, 9.0835191594E-02, 4.6181514965E-01],
	[7.8750000000E+03, 3.1225790965E+00, 6.1487471662E+00, 9.5190475800E-02, 9.1007250345E-02, 4.6198871981E-01],
	[7.8800000000E+03, 3.1251157841E+00, 6.1475193446E+00, 9.5376889114E-02, 9.1179515873E-02, 4.6216223148E-01],
	[7.8850000000E+03, 3.1276529215E+00, 6.1462925468E+00, 9.5563548622E-02, 9.1351988259E-02, 4.6233568484E-01],
	[7.8900000000E+03, 3.1301905083E+00, 6.1450667713E+00, 9.5750454492E-02, 9.1524667587E-02, 4.6250908005E-01],
	[7.8950000000E+03, 3.1327285445E+00, 6.1438420165E+00, 9.5937606891E-02, 9.1697553939E-02, 4.6268241728E-01],
	[7.9000000000E+03, 3.1352670297E+00, 6.1426182811E+00, 9.6125005988E-02, 9.1870647397E-02, 4.6285569670E-01],
	[7.9050000000E+03, 3.1378059638E+00, 6.1413955634E+00, 9.6312651952E-02, 9.2043948043E-02, 4.6302891848E-01],
	[7.9100000000E+03, 3.1403453466E+00, 6.1401738620E+00, 9.6500544950E-02, 9.2217455960E-02, 4.6320208278E-01],
	[7.9150000000E+03, 3.1428851778E+00, 6.1389531754E+00, 9.6688685150E-02, 9.2391171230E-02, 4.6337518976E-01],
	[7.9200000000E+03, 3.1454254574E+00, 6.1377335021E+00, 9.6877072721E-02, 9.2565093933E-02, 4.6354823961E-01],
	[7.9250000000E+03, 3.1479661850E+00, 6.1365148407E+00, 9.7065707832E-02, 9.2739224152E-02, 4.6372123247E-01],
	[7.9300000000E+03, 3.1505073604E+00, 6.1352971896E+00, 9.7254590649E-02, 9.2913561969E-02, 4.6389416853E-01],
	[7.9350000000E+03, 3.1530489835E+00, 6.1340805475E+00, 9.7443721342E-02, 9.3088107465E-02, 4.6406704794E-01],
	[7.9400000000E+03, 3.1555910541E+00, 6.1328649127E+00, 9.7633100078E-02, 9.3262860721E-02, 4.6423987088E-01],
	[7.9450000000E+03, 3.1581335719E+00, 6.1316502840E+00, 9.7822727026E-02, 9.3437821818E-02, 4.6441263750E-01],
	[7.9500000000E+03, 3.1606809959E+00, 6.1304558873E+00, 9.8012602355E-02, 9.3612999232E-02, 4.6458534797E-01],
	[7.9550000000E+03, 3.1632290755E+00, 6.1292633545E+00, 9.8202726231E-02, 9.3788385089E-02, 4.6475800246E-01],
	[7.9600000000E+03, 3.1657776064E+00, 6.1280718029E+00, 9.8393098824E-02, 9.3963979086E-02, 4.6493060114E-01],
	[7.9650000000E+03, 3.1683265882E+00, 6.1268812309E+00, 9.8583720302E-02, 9.4139781303E-02, 4.6510314416E-01],
	[7.9700000000E+03, 3.1708760209E+00, 6.1256916371E+00, 9.8774590833E-02, 9.4315791822E-02, 4.6527563170E-01],
	[7.9750000000E+03, 3.1734259041E+00, 6.1245030201E+00, 9.8965710586E-02, 9.4492010723E-02, 4.6544806391E-01],
	[7.9800000000E+03, 3.1759762378E+00, 6.1233153786E+00, 9.9157079728E-02, 9.4668438087E-02, 4.6562044097E-01],
	[7.9850000000E+03, 3.1785270217E+00, 6.1221287110E+00, 9.9348698428E-02, 9.4845073993E-02, 4.6579276303E-01],
	[7.9900000000E+03, 3.1810782556E+00, 6.1209430160E+00, 9.9540566855E-02, 9.5021918523E-02, 4.6596503023E-01],
	[7.9950000000E+03, 3.1836299393E+00, 6.1197582922E+00, 9.9732685175E-02, 9.5198971756E-02, 4.6613724270E-01],
	[8.0000000000E+03, 3.1861820726E+00, 6.1185745381E+00, 9.9925053559E-02, 9.5376233773E-02, 4.6630940059E-01],
	[8.0050000000E+03, 3.1887346553E+00, 6.1173917525E+00, 1.0011865303E-01, 9.5554598119E-02, 4.6648150402E-01],
	[8.0100000000E+03, 3.1912876871E+00, 6.1162099338E+00, 1.0031250607E-01, 9.5733174061E-02, 4.6665355314E-01],
	[8.0150000000E+03, 3.1938411680E+00, 6.1150290807E+00, 1.0050661287E-01, 9.5911961681E-02, 4.6682554808E-01],
	[8.0200000000E+03, 3.1963950977E+00, 6.1138491918E+00, 1.0070097358E-01, 9.6090961060E-02, 4.6699748896E-01],
	[8.0250000000E+03, 3.1989494759E+00, 6.1126702657E+00, 1.0089558839E-01, 9.6270172282E-02, 4.6716937594E-01],
	[8.0300000000E+03, 3.2015043026E+00, 6.1114923010E+00, 1.0109045746E-01, 9.6449595428E-02, 4.6734120913E-01],
	[8.0350000000E+03, 3.2040595774E+00, 6.1103152964E+00, 1.0128558098E-01, 9.6629230580E-02, 4.6751298868E-01],
	[8.0400000000E+03, 3.2066153002E+00, 6.1091392504E+00, 1.0148095911E-01, 9.6809077820E-02, 4.6768471472E-01],
	[8.0450000000E+03, 3.2091714708E+00, 6.1079641617E+00, 1.0167659202E-01, 9.6989137230E-02, 4.6785638739E-01],
	[8.0500000000E+03, 3.2117280890E+00, 6.1067900289E+00, 1.0187247989E-01, 9.7169408890E-02, 4.6802800681E-01],
	[8.0550000000E+03, 3.2142851546E+00, 6.1056168507E+00, 1.0206862290E-01, 9.7349892882E-02, 4.6819957313E-01],
	[8.0600000000E+03, 3.2168426674E+00, 6.1044446257E+00, 1.0226502120E-01, 9.7530589287E-02, 4.6837108647E-01],
	[8.0650000000E+03, 3.2194006272E+00, 6.1032733524E+00, 1.0246167499E-01, 9.7711498187E-02, 4.6854254698E-01],
	[8.0700000000E+03, 3.2219590338E+00, 6.1021030296E+00, 1.0265858443E-01, 9.7892619663E-02, 4.6871395477E-01],
	[8.0750000000E+03, 3.2245195677E+00, 6.1009408760E+00, 1.0285574969E-01, 9.8073957215E-02, 4.6888530999E-01],
	[8.0800000000E+03, 3.2270833553E+00, 6.0997917035E+00, 1.0305317095E-01, 9.8255513250E-02, 4.6905661277E-01],
	[8.0850000000E+03, 3.2296475935E+00, 6.0986434581E+00, 1.0325084838E-01, 9.8437282161E-02, 4.6922786324E-01],
	[8.0900000000E+03, 3.2322122820E+00, 6.0974961386E+00, 1.0344878215E-01, 9.8619264027E-02, 4.6939906154E-01],
	[8.0950000000E+03, 3.2347774207E+00, 6.0963497436E+00, 1.0364697244E-01, 9.8801458929E-02, 4.6957020779E-01],
	[8.1000000000E+03, 3.2373430093E+00, 6.0952042718E+00, 1.0384541942E-01, 9.8983866947E-02, 4.6974130213E-01],
	[8.1050000000E+03, 3.2399090477E+00, 6.0940597219E+00, 1.0404412326E-01, 9.9166488162E-02, 4.6991234470E-01],
	[8.1100000000E+03, 3.2424755356E+00, 6.0929160926E+00, 1.0424308414E-01, 9.9349322654E-02, 4.7008333562E-01],
	[8.1150000000E+03, 3.2450424728E+00, 6.0917733826E+00, 1.0444230223E-01, 9.9532370502E-02, 4.7025427502E-01],
	[8.1200000000E+03, 3.2476098592E+00, 6.0906315905E+00, 1.0464177770E-01, 9.9715631787E-02, 4.7042516304E-01],
	[8.1250000000E+03, 3.2501776946E+00, 6.0894907151E+00, 1.0484151072E-01, 9.9899106588E-02, 4.7059599982E-01],
	[8.1300000000E+03, 3.2527459787E+00, 6.0883507551E+00, 1.0504150147E-01, 1.0008279498E-01, 4.7076678547E-01],
	[8.1350000000E+03, 3.2553147114E+00, 6.0872117091E+00, 1.0524175013E-01, 1.0026669706E-01, 4.7093752014E-01],
	[8.1400000000E+03, 3.2578838924E+00, 6.0860735759E+00, 1.0544225686E-01, 1.0045081288E-01, 4.7110820395E-01],
	[8.1450000000E+03, 3.2604535216E+00, 6.0849363542E+00, 1.0564302183E-01, 1.0063514254E-01, 4.7127883704E-01],
	[8.1500000000E+03, 3.2630235987E+00, 6.0838000427E+00, 1.0584404523E-01, 1.0081968612E-01, 4.7144941953E-01],
	[8.1550000000E+03, 3.2655941237E+00, 6.0826646401E+00, 1.0604532722E-01, 1.0100444368E-01, 4.7161995156E-01],
	[8.1600000000E+03, 3.2681650962E+00, 6.0815301452E+00, 1.0624686798E-01, 1.0118941532E-01, 4.7179043326E-01],
	[8.1650000000E+03, 3.2707365160E+00, 6.0803965566E+00, 1.0644866769E-01, 1.0137460110E-01, 4.7196086475E-01],
	[8.1700000000E+03, 3.2733083831E+00, 6.0792638730E+00, 1.0665072650E-01, 1.0156000112E-01, 4.7213124618E-01],
	[8.1750000000E+03, 3.2758806971E+00, 6.0781320933E+00, 1.0685304461E-01, 1.0174561544E-01, 4.7230157766E-01],
	[8.1800000000E+03, 3.2784534579E+00, 6.0770012160E+00, 1.0705562217E-01, 1.0193144414E-01, 4.7247185934E-01],
	[8.1850000000E+03, 3.2810266653E+00, 6.0758712400E+00, 1.0725845937E-01, 1.0211748730E-01, 4.7264209133E-01],
	[8.1900000000E+03, 3.2836003191E+00, 6.0747421640E+00, 1.0746155637E-01, 1.0230374501E-01, 4.7281227378E-01],
	[8.1950000000E+03, 3.2861744191E+00, 6.0736139867E+00, 1.0766491336E-01, 1.0249021734E-01, 4.7298240680E-01],
	[8.2000000000E+03, 3.2887489652E+00, 6.0724867069E+00, 1.0786853050E-01, 1.0267690436E-01, 4.7315249053E-01],
	[8.2050000000E+03, 3.2913256208E+00, 6.0713673607E+00, 1.0807240796E-01, 1.0286380980E-01, 4.7332252510E-01],
	[8.2100000000E+03, 3.2939054226E+00, 6.0702603074E+00, 1.0827654593E-01, 1.0305093604E-01, 4.7349251064E-01],
	[8.2150000000E+03, 3.2964856740E+00, 6.0691541298E+00, 1.0848094457E-01, 1.0323827727E-01, 4.7366244727E-01],
	[8.2200000000E+03, 3.2990663748E+00, 6.0680488266E+00, 1.0868560406E-01, 1.0342583356E-01, 4.7383233513E-01],
	[8.2250000000E+03, 3.3016475248E+00, 6.0669443967E+00, 1.0889052457E-01, 1.0361360500E-01, 4.7400217435E-01],
	[8.2300000000E+03, 3.3042291239E+00, 6.0658408388E+00, 1.0909570627E-01, 1.0380159166E-01, 4.7417196505E-01],
	[8.2350000000E+03, 3.3068111717E+00, 6.0647381517E+00, 1.0930114934E-01, 1.0398979361E-01, 4.7434170736E-01],
	[8.2400000000E+03, 3.3093936681E+00, 6.0636363341E+00, 1.0950685395E-01, 1.0417821094E-01, 4.7451140142E-01],
	[8.2450000000E+03, 3.3119766130E+00, 6.0625353850E+00, 1.0971282027E-01, 1.0436684371E-01, 4.7468104734E-01],
	[8.2500000000E+03, 3.3145600061E+00, 6.0614353030E+00, 1.0991904848E-01, 1.0455569201E-01, 4.7485064526E-01],
	[8.2550000000E+03, 3.3171438473E+00, 6.0603360869E+00, 1.1012553875E-01, 1.0474475592E-01, 4.7502019531E-01],
	[8.2600000000E+03, 3.3197281363E+00, 6.0592377356E+00, 1.1033229126E-01, 1.0493403551E-01, 4.7518969762E-01],
	[8.2650000000E+03, 3.3223128729E+00, 6.0581402478E+00, 1.1053930617E-01, 1.0512353085E-01, 4.7535915230E-01],
	[8.2700000000E+03, 3.3248980570E+00, 6.0570436224E+00, 1.1074658366E-01, 1.0531324202E-01, 4.7552855950E-01],
	[8.2750000000E+03, 3.3274836884E+00, 6.0559478581E+00, 1.1095412391E-01, 1.0550316910E-01, 4.7569791934E-01],
	[8.2800000000E+03, 3.3300697668E+00, 6.0548529537E+00, 1.1116192709E-01, 1.0569331217E-01, 4.7586723194E-01],
	[8.2850000000E+03, 3.3326562921E+00, 6.0537589081E+00, 1.1136999336E-01, 1.0588367129E-01, 4.7603649743E-01],
	[8.2900000000E+03, 3.3352432641E+00, 6.0526657201E+00, 1.1157832292E-01, 1.0607424655E-01, 4.7620571594E-01],
	[8.2950000000E+03, 3.3378306826E+00, 6.0515733884E+00, 1.1178691592E-01, 1.0626503802E-01, 4.7637488761E-01],
	[8.3000000000E+03, 3.3404185474E+00, 6.0504819119E+00, 1.1199577254E-01, 1.0645604578E-01, 4.7654401255E-01],
	[8.3050000000E+03, 3.3430068582E+00, 6.0493912895E+00, 1.1220489295E-01, 1.0664726989E-01, 4.7671309088E-01],
	[8.3100000000E+03, 3.3455956151E+00, 6.0483015198E+00, 1.1241427734E-01, 1.0683871044E-01, 4.7688212275E-01],
	[8.3150000000E+03, 3.3481848176E+00, 6.0472126018E+00, 1.1262392586E-01, 1.0703036750E-01, 4.7705110828E-01],
	[8.3200000000E+03, 3.3507744657E+00, 6.0461245342E+00, 1.1283383871E-01, 1.0722224115E-01, 4.7722004758E-01],
	[8.3250000000E+03, 3.3533645591E+00, 6.0450373160E+00, 1.1304401604E-01, 1.0741433146E-01, 4.7738894080E-01],
	[8.3300000000E+03, 3.3559550976E+00, 6.0439509458E+00, 1.1325445803E-01, 1.0760663850E-01, 4.7755778805E-01],
	[8.3350000000E+03, 3.3585460812E+00, 6.0428654226E+00, 1.1346516486E-01, 1.0779916234E-01, 4.7772658946E-01],
	[8.3400000000E+03, 3.3611416209E+00, 6.0417978624E+00, 1.1367613670E-01, 1.0799191279E-01, 4.7789534516E-01],
	[8.3450000000E+03, 3.3637377374E+00, 6.0407316641E+00, 1.1388737372E-01, 1.0818488055E-01, 4.7806405528E-01],
	[8.3500000000E+03, 3.3663343022E+00, 6.0396662925E+00, 1.1409887610E-01, 1.0837806541E-01, 4.7823271993E-01],
	[8.3550000000E+03, 3.3689313153E+00, 6.0386017463E+00, 1.1431064401E-01, 1.0857146743E-01, 4.7840133925E-01],
	[8.3600000000E+03, 3.3715287764E+00, 6.0375380245E+00, 1.1452267763E-01, 1.0876508669E-01, 4.7856991337E-01],
	[8.3650000000E+03, 3.3741266853E+00, 6.0364751259E+00, 1.1473497712E-01, 1.0895892327E-01, 4.7873844239E-01],
	[8.3700000000E+03, 3.3767250418E+00, 6.0354130493E+00, 1.1494754266E-01, 1.0915297723E-01, 4.7890692647E-01],
	[8.3750000000E+03, 3.3793238457E+00, 6.0343517938E+00, 1.1516037443E-01, 1.0934724865E-01, 4.7907536570E-01],
	[8.3800000000E+03, 3.3819230969E+00, 6.0332913581E+00, 1.1537347259E-01, 1.0954173760E-01, 4.7924376024E-01],
	[8.3850000000E+03, 3.3845227952E+00, 6.0322317410E+00, 1.1558683733E-01, 1.0973644416E-01, 4.7941211019E-01],
	[8.3900000000E+03, 3.3871229403E+00, 6.0311729416E+00, 1.1580046881E-01, 1.0993136841E-01, 4.7958041568E-01],
	[8.3950000000E+03, 3.3897235321E+00, 6.0301149587E+00, 1.1601436722E-01, 1.1012651040E-01, 4.7974867685E-01],
	[8.4000000000E+03, 3.3923245704E+00, 6.0290577911E+00, 1.1622853271E-01, 1.1032187022E-01, 4.7991689381E-01],
	[8.4050000000E+03, 3.3949260550E+00, 6.0280014378E+00, 1.1644296547E-01, 1.1051744794E-01, 4.8008506668E-01],
	[8.4100000000E+03, 3.3975279857E+00, 6.0269458976E+00, 1.1665766568E-01, 1.1071324363E-01, 4.8025319560E-01],
	[8.4150000000E+03, 3.4001303623E+00, 6.0258911695E+00, 1.1687263349E-01, 1.1090925736E-01, 4.8042128068E-01],
	[8.4200000000E+03, 3.4027331846E+00, 6.0248372523E+00, 1.1708786909E-01, 1.1110548921E-01, 4.8058932204E-01],
	[8.4250000000E+03, 3.4053364525E+00, 6.0237841449E+00, 1.1730337266E-01, 1.1130193924E-01, 4.8075731976E-01],
	[8.4300000000E+03, 3.4079401657E+00, 6.0227318462E+00, 1.1751914436E-01, 1.1149860753E-01, 4.8092527394E-01],
	[8.4350000000E+03, 3.4105443242E+00, 6.0216803551E+00, 1.1773518436E-01, 1.1169549416E-01, 4.8109318468E-01],
	[8.4400000000E+03, 3.4131489275E+00, 6.0206296706E+00, 1.1795149285E-01, 1.1189259919E-01, 4.8126105207E-01],
	[8.4450000000E+03, 3.4157539757E+00, 6.0195797915E+00, 1.1816807000E-01, 1.1208992269E-01, 4.8142887622E-01],
	[8.4500000000E+03, 3.4183594685E+00, 6.0185307167E+00, 1.1838491598E-01, 1.1228746474E-01, 4.8159665722E-01],
	[8.4550000000E+03, 3.4209654057E+00, 6.0174824451E+00, 1.1860203096E-01, 1.1248522540E-01, 4.8176439518E-01],
	[8.4600000000E+03, 3.4235717871E+00, 6.0164349757E+00, 1.1881941511E-01, 1.1268320475E-01, 4.8193209018E-01],
	[8.4650000000E+03, 3.4261786126E+00, 6.0153883074E+00, 1.1903706862E-01, 1.1288140286E-01, 4.8209974233E-01],
	[8.4700000000E+03, 3.4287864284E+00, 6.0143446829E+00, 1.1925499165E-01, 1.1307982119E-01, 4.8226735173E-01],
	[8.4750000000E+03, 3.4313982575E+00, 6.0133164968E+00, 1.1947318438E-01, 1.1327846752E-01, 4.8243491846E-01],
	[8.4800000000E+03, 3.4340105339E+00, 6.0122890928E+00, 1.1969164699E-01, 1.1347733287E-01, 4.8260244264E-01],
	[8.4850000000E+03, 3.4366232575E+00, 6.0112624698E+00, 1.1991037964E-01, 1.1367641733E-01, 4.8276992435E-01],
	[8.4900000000E+03, 3.4392364279E+00, 6.0102366267E+00, 1.2012947150E-01, 1.1387580094E-01, 4.8293736370E-01],
	[8.4950000000E+03, 3.4418500452E+00, 6.0092115624E+00, 1.2034883935E-01, 1.1407540879E-01, 4.8310476078E-01],
	[8.5000000000E+03, 3.4444641090E+00, 6.0081872760E+00, 1.2056847808E-01, 1.1427523622E-01, 4.8327211569E-01],
	[8.5050000000E+03, 3.4470786192E+00, 6.0071637664E+00, 1.2078838787E-01, 1.1447528329E-01, 4.8343942852E-01],
	[8.5100000000E+03, 3.4496935755E+00, 6.0061410325E+00, 1.2100856890E-01, 1.1467555008E-01, 4.8360669938E-01],
	[8.5150000000E+03, 3.4523089779E+00, 6.0051190733E+00, 1.2122902134E-01, 1.1487603666E-01, 4.8377392835E-01],
	[8.5200000000E+03, 3.4549248261E+00, 6.0040978878E+00, 1.2144974535E-01, 1.1507674309E-01, 4.8394111555E-01],
	[8.5250000000E+03, 3.4575411200E+00, 6.0030774749E+00, 1.2167074113E-01, 1.1527766946E-01, 4.8410826106E-01],
	[8.5300000000E+03, 3.4601578593E+00, 6.0020578336E+00, 1.2189200884E-01, 1.1547881582E-01, 4.8427536498E-01],
	[8.5350000000E+03, 3.4627750439E+00, 6.0010389627E+00, 1.2211354866E-01, 1.1568018225E-01, 4.8444242741E-01],
	[8.5400000000E+03, 3.4653926735E+00, 6.0000208615E+00, 1.2233536076E-01, 1.1588176881E-01, 4.8460944844E-01],
	[8.5450000000E+03, 3.4680107481E+00, 5.9990035286E+00, 1.2255744531E-01, 1.1608357558E-01, 4.8477642817E-01],
	[8.5500000000E+03, 3.4706292673E+00, 5.9979869633E+00, 1.2277980249E-01, 1.1628560262E-01, 4.8494336670E-01],
	[8.5550000000E+03, 3.4732482311E+00, 5.9969711643E+00, 1.2300243248E-01, 1.1648785001E-01, 4.8511026413E-01],
	[8.5600000000E+03, 3.4758676392E+00, 5.9959561308E+00, 1.2322533545E-01, 1.1669031781E-01, 4.8527712054E-01],
	[8.5650000000E+03, 3.4784874915E+00, 5.9949418616E+00, 1.2344851156E-01, 1.1689300609E-01, 4.8544393605E-01],
	[8.5700000000E+03, 3.4811077878E+00, 5.9939283558E+00, 1.2367196101E-01, 1.1709591492E-01, 4.8561071073E-01],
	[8.5750000000E+03, 3.4837285278E+00, 5.9929156123E+00, 1.2389568396E-01, 1.1729904437E-01, 4.8577744470E-01],
	[8.5800000000E+03, 3.4863497115E+00, 5.9919036301E+00, 1.2411968059E-01, 1.1750239451E-01, 4.8594413804E-01],
	[8.5850000000E+03, 3.4889713386E+00, 5.9908924082E+00, 1.2434395106E-01, 1.1770596540E-01, 4.8611079085E-01],
	[8.5900000000E+03, 3.4915934089E+00, 5.9898819456E+00, 1.2456849556E-01, 1.1790975711E-01, 4.8627740323E-01],
	[8.5950000000E+03, 3.4942159223E+00, 5.9888722413E+00, 1.2479331427E-01, 1.1811376971E-01, 4.8644397528E-01],
	[8.6000000000E+03, 3.4968388785E+00, 5.9878632942E+00, 1.2501840734E-01, 1.1831800328E-01, 4.8661050708E-01],
	[8.6050000000E+03, 3.4994622775E+00, 5.9868551034E+00, 1.2524377497E-01, 1.1852245787E-01, 4.8677699874E-01],
	[8.6100000000E+03, 3.5020895659E+00, 5.9858616163E+00, 1.2546941732E-01, 1.1872714300E-01, 4.8694345035E-01],
	[8.6150000000E+03, 3.5047178432E+00, 5.9848710675E+00, 1.2569533456E-01, 1.1893205084E-01, 4.8710986201E-01],
	[8.6200000000E+03, 3.5073465663E+00, 5.9838812572E+00, 1.2592152688E-01, 1.1913717997E-01, 4.8727623381E-01],
	[8.6250000000E+03, 3.5099757350E+00, 5.9828921845E+00, 1.2614799445E-01, 1.1934253047E-01, 4.8744256585E-01],
	[8.6300000000E+03, 3.5126053492E+00, 5.9819038483E+00, 1.2637473744E-01, 1.1954810239E-01, 4.8760885823E-01],
	[8.6350000000E+03, 3.5152354086E+00, 5.9809162476E+00, 1.2660175602E-01, 1.1975389580E-01, 4.8777511103E-01],
	[8.6400000000E+03, 3.5178659131E+00, 5.9799293816E+00, 1.2682905038E-01, 1.1995991078E-01, 4.8794132436E-01],
	[8.6450000000E+03, 3.5204968626E+00, 5.9789432492E+00, 1.2705662068E-01, 1.2016614738E-01, 4.8810749830E-01],
	[8.6500000000E+03, 3.5231282567E+00, 5.9779578495E+00, 1.2728446710E-01, 1.2037260568E-01, 4.8827363297E-01],
	[8.6550000000E+03, 3.5257600953E+00, 5.9769731815E+00, 1.2751258982E-01, 1.2057928574E-01, 4.8843972844E-01],
	[8.6600000000E+03, 3.5283923783E+00, 5.9759892442E+00, 1.2774098901E-01, 1.2078618763E-01, 4.8860578482E-01],
	[8.6650000000E+03, 3.5310251055E+00, 5.9750060366E+00, 1.2796966484E-01, 1.2099331141E-01, 4.8877180220E-01],
	[8.6700000000E+03, 3.5336582767E+00, 5.9740235579E+00, 1.2819861748E-01, 1.2120065715E-01, 4.8893778068E-01],
	[8.6750000000E+03, 3.5362918916E+00, 5.9730418070E+00, 1.2842784713E-01, 1.2140822491E-01, 4.8910372035E-01],
	[8.6800000000E+03, 3.5389259502E+00, 5.9720607830E+00, 1.2865735394E-01, 1.2161601476E-01, 4.8926962130E-01],
	[8.6850000000E+03, 3.5415604523E+00, 5.9710804849E+00, 1.2888713809E-01, 1.2182402677E-01, 4.8943548363E-01],
	[8.6900000000E+03, 3.5441953976E+00, 5.9701009118E+00, 1.2911719976E-01, 1.2203226101E-01, 4.8960130744E-01],
	[8.6950000000E+03, 3.5468307859E+00, 5.9691220627E+00, 1.2934753912E-01, 1.2224071753E-01, 4.8976709282E-01],
	[8.7000000000E+03, 3.5494666172E+00, 5.9681439367E+00, 1.2957815635E-01, 1.2244939640E-01, 4.8993283987E-01],
	[8.7050000000E+03, 3.5521028912E+00, 5.9671665329E+00, 1.2980905161E-01, 1.2265829769E-01, 4.9009854867E-01],
	[8.7100000000E+03, 3.5547396078E+00, 5.9661898501E+00, 1.3004022510E-01, 1.2286742146E-01, 4.9026421933E-01],
	[8.7150000000E+03, 3.5573767667E+00, 5.9652138877E+00, 1.3027167698E-01, 1.2307676778E-01, 4.9042985194E-01],
	[8.7200000000E+03, 3.5600143678E+00, 5.9642386445E+00, 1.3050340742E-01, 1.2328633671E-01, 4.9059544659E-01],
	[8.7250000000E+03, 3.5626524109E+00, 5.9632641196E+00, 1.3073541660E-01, 1.2349612831E-01, 4.9076100338E-01],
	[8.7300000000E+03, 3.5652908958E+00, 5.9622903122E+00, 1.3096770469E-01, 1.2370614266E-01, 4.9092652241E-01],
	[8.7350000000E+03, 3.5679298224E+00, 5.9613172212E+00, 1.3120027188E-01, 1.2391637981E-01, 4.9109200376E-01],
	[8.7400000000E+03, 3.5705691904E+00, 5.9603448457E+00, 1.3143311833E-01, 1.2412683983E-01, 4.9125744752E-01],
	[8.7450000000E+03, 3.5732096020E+00, 5.9593755917E+00, 1.3166624422E-01, 1.2433752456E-01, 4.9142285381E-01],
	[8.7500000000E+03, 3.5758537170E+00, 5.9584200717E+00, 1.3189964972E-01, 1.2454844194E-01, 4.9158822270E-01],
	[8.7550000000E+03, 3.5784982763E+00, 5.9574652506E+00, 1.3213333501E-01, 1.2475958245E-01, 4.9175355430E-01],
	[8.7600000000E+03, 3.5811432800E+00, 5.9565111275E+00, 1.3236730027E-01, 1.2497094614E-01, 4.9191884869E-01],
	[8.7650000000E+03, 3.5837887277E+00, 5.9555577015E+00, 1.3260154566E-01, 1.2518253309E-01, 4.9208410598E-01],
	[8.7700000000E+03, 3.5864346193E+00, 5.9546049718E+00, 1.3283607136E-01, 1.2539434336E-01, 4.9224932625E-01],
	[8.7750000000E+03, 3.5890809546E+00, 5.9536529373E+00, 1.3307087756E-01, 1.2560637700E-01, 4.9241450960E-01],
	[8.7800000000E+03, 3.5917277335E+00, 5.9527015973E+00, 1.3330596442E-01, 1.2581863409E-01, 4.9257965612E-01],
	[8.7850000000E+03, 3.5943749557E+00, 5.9517509507E+00, 1.3354133211E-01, 1.2603111469E-01, 4.9274476591E-01],
	[8.7900000000E+03, 3.5970226211E+00, 5.9508009968E+00, 1.3377698082E-01, 1.2624381885E-01, 4.9290983906E-01],
	[8.7950000000E+03, 3.5996707295E+00, 5.9498517345E+00, 1.3401291071E-01, 1.2645674665E-01, 4.9307487567E-01],
	[8.8000000000E+03, 3.6023192807E+00, 5.9489031630E+00, 1.3424912197E-01, 1.2666989813E-01, 4.9323987582E-01],
	[8.8050000000E+03, 3.6049682746E+00, 5.9479552815E+00, 1.3448561476E-01, 1.2688327338E-01, 4.9340483962E-01],
	[8.8100000000E+03, 3.6076177109E+00, 5.9470080890E+00, 1.3472238926E-01, 1.2709687244E-01, 4.9356976715E-01],
	[8.8150000000E+03, 3.6102675896E+00, 5.9460615846E+00, 1.3495944565E-01, 1.2731069539E-01, 4.9373465850E-01],
	[8.8200000000E+03, 3.6129179103E+00, 5.9451157674E+00, 1.3519678411E-01, 1.2752474227E-01, 4.9389951378E-01],
	[8.8250000000E+03, 3.6155686730E+00, 5.9441706365E+00, 1.3543440479E-01, 1.2773901316E-01, 4.9406433308E-01],
	[8.8300000000E+03, 3.6182198775E+00, 5.9432261912E+00, 1.3567230789E-01, 1.2795350812E-01, 4.9422911647E-01],
	[8.8350000000E+03, 3.6208715236E+00, 5.9422824304E+00, 1.3591049358E-01, 1.2816822720E-01, 4.9439386401E-01],
	[8.8400000000E+03, 3.6235236110E+00, 5.9413393533E+00, 1.3614896203E-01, 1.2838317048E-01, 4.9455857578E-01],
	[8.8450000000E+03, 3.6261761397E+00, 5.9403969590E+00, 1.3638771341E-01, 1.2859833800E-01, 4.9472325184E-01],
	[8.8500000000E+03, 3.6288291095E+00, 5.9394552466E+00, 1.3662674791E-01, 1.2881372983E-01, 4.9488789227E-01],
	[8.8550000000E+03, 3.6314825201E+00, 5.9385142153E+00, 1.3686606569E-01, 1.2902934604E-01, 4.9505249713E-01],
	[8.8600000000E+03, 3.6341363714E+00, 5.9375738641E+00, 1.3710566693E-01, 1.2924518668E-01, 4.9521706651E-01],
	[8.8650000000E+03, 3.6367906633E+00, 5.9366341923E+00, 1.3734555181E-01, 1.2946125181E-01, 4.9538160046E-01],
	[8.8700000000E+03, 3.6394453955E+00, 5.9356951989E+00, 1.3758572050E-01, 1.2967754150E-01, 4.9554609905E-01],
	[8.8750000000E+03, 3.6421005679E+00, 5.9347568830E+00, 1.3782617317E-01, 1.2989405580E-01, 4.9571056237E-01],
	[8.8800000000E+03, 3.6447561804E+00, 5.9338192438E+00, 1.3806691001E-01, 1.3011079478E-01, 4.9587499047E-01],
	[8.8850000000E+03, 3.6474122398E+00, 5.9328823088E+00, 1.3830793118E-01, 1.3032775851E-01, 4.9603938343E-01],
	[8.8900000000E+03, 3.6500724682E+00, 5.9319607573E+00, 1.3854923686E-01, 1.3054495893E-01, 4.9620374131E-01],
	[8.8950000000E+03, 3.6527331395E+00, 5.9310398671E+00, 1.3879082723E-01, 1.3076238428E-01, 4.9636806420E-01],
	[8.9000000000E+03, 3.6553942534E+00, 5.9301196371E+00, 1.3903270246E-01, 1.3098003461E-01, 4.9653235215E-01],
	[8.9050000000E+03, 3.6580558098E+00, 5.9292000667E+00, 1.3927486273E-01, 1.3119790998E-01, 4.9669660525E-01],
	[8.9100000000E+03, 3.6607178085E+00, 5.9282811549E+00, 1.3951730820E-01, 1.3141601045E-01, 4.9686082355E-01],
	[8.9150000000E+03, 3.6633802493E+00, 5.9273629009E+00, 1.3976003906E-01, 1.3163433608E-01, 4.9702500713E-01],
	[8.9200000000E+03, 3.6660431321E+00, 5.9264453039E+00, 1.4000305549E-01, 1.3185288693E-01, 4.9718915606E-01],
	[8.9250000000E+03, 3.6687064566E+00, 5.9255283631E+00, 1.4024635765E-01, 1.3207166306E-01, 4.9735327041E-01],
	[8.9300000000E+03, 3.6713702228E+00, 5.9246120775E+00, 1.4048994572E-01, 1.3229066454E-01, 4.9751735024E-01],
	[8.9350000000E+03, 3.6740344303E+00, 5.9236964464E+00, 1.4073381988E-01, 1.3250989140E-01, 4.9768139564E-01],
	[8.9400000000E+03, 3.6766990791E+00, 5.9227814689E+00, 1.4097798030E-01, 1.3272934373E-01, 4.9784540666E-01],
	[8.9450000000E+03, 3.6793641690E+00, 5.9218671443E+00, 1.4122242715E-01, 1.3294902157E-01, 4.9800938339E-01],
	[8.9500000000E+03, 3.6820296998E+00, 5.9209534716E+00, 1.4146716062E-01, 1.3316892498E-01, 4.9817332588E-01],
	[8.9550000000E+03, 3.6846956713E+00, 5.9200404500E+00, 1.4171218087E-01, 1.3338905402E-01, 4.9833723421E-01],
	[8.9600000000E+03, 3.6873620834E+00, 5.9191280788E+00, 1.4195748809E-01, 1.3360940876E-01, 4.9850110845E-01],
	[8.9650000000E+03, 3.6900289358E+00, 5.9182163570E+00, 1.4220308244E-01, 1.3382998924E-01, 4.9866494866E-01],
	[8.9700000000E+03, 3.6926962285E+00, 5.9173052839E+00, 1.4244896411E-01, 1.3405079552E-01, 4.9882875493E-01],
	[8.9750000000E+03, 3.6953639612E+00, 5.9163948586E+00, 1.4269513326E-01, 1.3427182767E-01, 4.9899252731E-01],
	[8.9800000000E+03, 3.6980321338E+00, 5.9154850804E+00, 1.4294159008E-01, 1.3449308574E-01, 4.9915626588E-01],
	[8.9850000000E+03, 3.7007007460E+00, 5.9145759483E+00, 1.4318833473E-01, 1.3471456979E-01, 4.9931997071E-01],
	[8.9900000000E+03, 3.7033697978E+00, 5.9136674617E+00, 1.4343536739E-01, 1.3493627987E-01, 4.9948364186E-01],
	[8.9950000000E+03, 3.7060392890E+00, 5.9127596196E+00, 1.4368268825E-01, 1.3515821605E-01, 4.9964727941E-01],
	[9.0000000000E+03, 3.7087092193E+00, 5.9118524212E+00, 1.4393029746E-01, 1.3538037837E-01, 4.9981088343E-01],
	[9.0050000000E+03, 3.7113795886E+00, 5.9109458658E+00, 1.4417962274E-01, 1.3560402966E-01, 4.9997445398E-01],
	[9.0100000000E+03, 3.7140503967E+00, 5.9100399525E+00, 1.4442924087E-01, 1.3582791046E-01, 5.0013799114E-01],
	[9.0150000000E+03, 3.7167216435E+00, 5.9091346806E+00, 1.4467915201E-01, 1.3605202084E-01, 5.0030149497E-01],
	[9.0200000000E+03, 3.7193933288E+00, 5.9082300491E+00, 1.4492935637E-01, 1.3627636084E-01, 5.0046496555E-01],
	[9.0250000000E+03, 3.7220654524E+00, 5.9073260573E+00, 1.4517985411E-01, 1.3650093054E-01, 5.0062840294E-01],
	[9.0300000000E+03, 3.7247394476E+00, 5.9064282672E+00, 1.4543064541E-01, 1.3672573489E-01, 5.0079180722E-01],
	[9.0350000000E+03, 3.7274160815E+00, 5.9055396387E+00, 1.4568173046E-01, 1.3695077664E-01, 5.0095517845E-01],
	[9.0400000000E+03, 3.7300931564E+00, 5.9046516354E+00, 1.4593310945E-01, 1.3717604832E-01, 5.0111851671E-01],
	[9.0450000000E+03, 3.7327706721E+00, 5.9037642566E+00, 1.4618478254E-01, 1.3740154999E-01, 5.0128182205E-01],
	[9.0500000000E+03, 3.7354486285E+00, 5.9028775014E+00, 1.4643674992E-01, 1.3762728172E-01, 5.0144509456E-01],
	[9.0550000000E+03, 3.7381270254E+00, 5.9019913690E+00, 1.4668901177E-01, 1.3785324356E-01, 5.0160833430E-01],
	[9.0600000000E+03, 3.7408058626E+00, 5.9011058588E+00, 1.4694156827E-01, 1.3807943556E-01, 5.0177154134E-01],
	[9.0650000000E+03, 3.7434851400E+00, 5.9002209698E+00, 1.4719441960E-01, 1.3830585779E-01, 5.0193471575E-01],
	[9.0700000000E+03, 3.7461648574E+00, 5.8993367014E+00, 1.4744756594E-01, 1.3853251031E-01, 5.0209785760E-01],
	[9.0750000000E+03, 3.7488450146E+00, 5.8984530527E+00, 1.4770100748E-01, 1.3875939317E-01, 5.0226096696E-01],
	[9.0800000000E+03, 3.7515256114E+00, 5.8975700230E+00, 1.4795474439E-01, 1.3898650642E-01, 5.0242404390E-01],
	[9.0850000000E+03, 3.7542066477E+00, 5.8966876115E+00, 1.4820877686E-01, 1.3921385013E-01, 5.0258708848E-01],
	[9.0900000000E+03, 3.7568881233E+00, 5.8958058175E+00, 1.4846310506E-01, 1.3944142436E-01, 5.0275010079E-01],
	[9.0950000000E+03, 3.7595700380E+00, 5.8949246401E+00, 1.4871772918E-01, 1.3966922916E-01, 5.0291308088E-01],
	[9.1000000000E+03, 3.7622523917E+00, 5.8940440785E+00, 1.4897264939E-01, 1.3989726458E-01, 5.0307602882E-01],
	[9.1050000000E+03, 3.7649351842E+00, 5.8931641321E+00, 1.4922786589E-01, 1.4012553069E-01, 5.0323894469E-01],
	[9.1100000000E+03, 3.7676184153E+00, 5.8922848001E+00, 1.4948337884E-01, 1.4035402753E-01, 5.0340182855E-01],
	[9.1150000000E+03, 3.7703020849E+00, 5.8914060816E+00, 1.4973918843E-01, 1.4058275518E-01, 5.0356468048E-01],
	[9.1200000000E+03, 3.7729861928E+00, 5.8905279760E+00, 1.4999529484E-01, 1.4081171367E-01, 5.0372750054E-01],
	[9.1250000000E+03, 3.7756707388E+00, 5.8896504824E+00, 1.5025169825E-01, 1.4104090308E-01, 5.0389028880E-01],
	[9.1300000000E+03, 3.7783557227E+00, 5.8887736001E+00, 1.5050839884E-01, 1.4127032345E-01, 5.0405304534E-01],
	[9.1350000000E+03, 3.7810411444E+00, 5.8878973283E+00, 1.5076539680E-01, 1.4149997483E-01, 5.0421577021E-01],
	[9.1400000000E+03, 3.7837270037E+00, 5.8870216664E+00, 1.5102269230E-01, 1.4172985730E-01, 5.0437846349E-01],
	[9.1450000000E+03, 3.7864133005E+00, 5.8861466134E+00, 1.5128028553E-01, 1.4195997090E-01, 5.0454112525E-01],
	[9.1500000000E+03, 3.7891000346E+00, 5.8852721687E+00, 1.5153817666E-01, 1.4219031568E-01, 5.0470375556E-01],
	[9.1550000000E+03, 3.7917872058E+00, 5.8843983315E+00, 1.5179636587E-01, 1.4242089170E-01, 5.0486635448E-01],
	[9.1600000000E+03, 3.7944748139E+00, 5.8835251011E+00, 1.5205485336E-01, 1.4265169903E-01, 5.0502892209E-01],
	[9.1650000000E+03, 3.7971628587E+00, 5.8826524767E+00, 1.5231363929E-01, 1.4288273770E-01, 5.0519145846E-01],
	[9.1700000000E+03, 3.7998513402E+00, 5.8817804575E+00, 1.5257272385E-01, 1.4311400778E-01, 5.0535396364E-01],
	[9.1750000000E+03, 3.8025414297E+00, 5.8809134632E+00, 1.5283210722E-01, 1.4334551361E-01, 5.0551643772E-01],
	[9.1800000000E+03, 3.8052343699E+00, 5.8800561674E+00, 1.5309178958E-01, 1.4357725984E-01, 5.0567888077E-01],
	[9.1850000000E+03, 3.8079277493E+00, 5.8791994633E+00, 1.5335177112E-01, 1.4380923771E-01, 5.0584129284E-01],
	[9.1900000000E+03, 3.8106215678E+00, 5.8783433501E+00, 1.5361205200E-01, 1.4404144728E-01, 5.0600367401E-01],
	[9.1950000000E+03, 3.8133158252E+00, 5.8774878271E+00, 1.5387263243E-01, 1.4427388860E-01, 5.0616602435E-01],
	[9.2000000000E+03, 3.8160105212E+00, 5.8766328937E+00, 1.5413351256E-01, 1.4450656172E-01, 5.0632834393E-01],
	[9.2050000000E+03, 3.8187056559E+00, 5.8757785490E+00, 1.5439469259E-01, 1.4473946670E-01, 5.0649063282E-01],
	[9.2100000000E+03, 3.8214012289E+00, 5.8749247923E+00, 1.5465617270E-01, 1.4497260360E-01, 5.0665289108E-01],
	[9.2150000000E+03, 3.8240972402E+00, 5.8740716230E+00, 1.5491795307E-01, 1.4520597246E-01, 5.0681511879E-01],
	[9.2200000000E+03, 3.8267936895E+00, 5.8732190402E+00, 1.5518003388E-01, 1.4543957334E-01, 5.0697731600E-01],
	[9.2250000000E+03, 3.8294905767E+00, 5.8723670434E+00, 1.5544241530E-01, 1.4567340629E-01, 5.0713948277E-01],
	[9.2300000000E+03, 3.8321879016E+00, 5.8715156317E+00, 1.5570509753E-01, 1.4590747137E-01, 5.0730161913E-01],
	[9.2350000000E+03, 3.8348856641E+00, 5.8706648044E+00, 1.5596808074E-01, 1.4614176862E-01, 5.0746372515E-01],
	[9.2400000000E+03, 3.8375838639E+00, 5.8698145609E+00, 1.5623136511E-01, 1.4637629811E-01, 5.0762580086E-01],
	[9.2450000000E+03, 3.8402825010E+00, 5.8689649003E+00, 1.5649495083E-01, 1.4661105988E-01, 5.0778784632E-01],
	[9.2500000000E+03, 3.8429815752E+00, 5.8681158221E+00, 1.5675883807E-01, 1.4684605398E-01, 5.0794986158E-01],
	[9.2550000000E+03, 3.8456810862E+00, 5.8672673254E+00, 1.5702302702E-01, 1.4708128048E-01, 5.0811184669E-01],
	[9.2600000000E+03, 3.8483810340E+00, 5.8664194096E+00, 1.5728751786E-01, 1.4731673941E-01, 5.0827380169E-01],
	[9.2650000000E+03, 3.8510814183E+00, 5.8655720739E+00, 1.5755231076E-01, 1.4755243084E-01, 5.0843572663E-01],
	[9.2700000000E+03, 3.8537822391E+00, 5.8647253177E+00, 1.5781740592E-01, 1.4778835481E-01, 5.0859762157E-01],
	[9.2750000000E+03, 3.8564834960E+00, 5.8638791402E+00, 1.5808280351E-01, 1.4802451137E-01, 5.0875948655E-01],
	[9.2800000000E+03, 3.8591851891E+00, 5.8630335408E+00, 1.5834850371E-01, 1.4826090059E-01, 5.0892132163E-01],
	[9.2850000000E+03, 3.8618873180E+00, 5.8621885186E+00, 1.5861450670E-01, 1.4849752250E-01, 5.0908312685E-01],
	[9.2900000000E+03, 3.8645898827E+00, 5.8613440731E+00, 1.5888081267E-01, 1.4873437716E-01, 5.0924490226E-01],
	[9.2950000000E+03, 3.8672928830E+00, 5.8605002035E+00, 1.5914742179E-01, 1.4897146462E-01, 5.0940664791E-01],
	[9.3000000000E+03, 3.8699963186E+00, 5.8596569091E+00, 1.5941433425E-01, 1.4920878494E-01, 5.0956836386E-01],
	[9.3050000000E+03, 3.8727001895E+00, 5.8588141892E+00, 1.5968155023E-01, 1.4944633816E-01, 5.0973005014E-01],
	[9.3100000000E+03, 3.8754044955E+00, 5.8579720432E+00, 1.5994906991E-01, 1.4968412433E-01, 5.0989170682E-01],
	[9.3150000000E+03, 3.8781092364E+00, 5.8571304702E+00, 1.6021689346E-01, 1.4992214350E-01, 5.1005333393E-01],
	[9.3200000000E+03, 3.8808144121E+00, 5.8562894697E+00, 1.6048502109E-01, 1.5016039573E-01, 5.1021493153E-01],
	[9.3250000000E+03, 3.8835228263E+00, 5.8554593043E+00, 1.6075345295E-01, 1.5039889204E-01, 5.1037649967E-01],
	[9.3300000000E+03, 3.8862324179E+00, 5.8546324100E+00, 1.6102218924E-01, 1.5063762447E-01, 5.1053803839E-01],
	[9.3350000000E+03, 3.8889424467E+00, 5.8538060753E+00, 1.6129123013E-01, 1.5087659018E-01, 5.1069954776E-01],
	[9.3400000000E+03, 3.8916529127E+00, 5.8529802996E+00, 1.6156057581E-01, 1.5111578922E-01, 5.1086102780E-01],
	[9.3450000000E+03, 3.8943638157E+00, 5.8521550823E+00, 1.6183022646E-01, 1.5135522164E-01, 5.1102247859E-01],
	[9.3500000000E+03, 3.8970751555E+00, 5.8513304226E+00, 1.6210018226E-01, 1.5159488748E-01, 5.1118390016E-01],
	[9.3550000000E+03, 3.8997869319E+00, 5.8505063199E+00, 1.6237044339E-01, 1.5183478681E-01, 5.1134529256E-01],
	[9.3600000000E+03, 3.9024991449E+00, 5.8496827736E+00, 1.6264101003E-01, 1.5207491966E-01, 5.1150665585E-01],
	[9.3650000000E+03, 3.9052117941E+00, 5.8488597828E+00, 1.6291188237E-01, 1.5231528609E-01, 5.1166799006E-01],
	[9.3700000000E+03, 3.9079248795E+00, 5.8480373471E+00, 1.6318306058E-01, 1.5255588615E-01, 5.1182929527E-01],
	[9.3750000000E+03, 3.9106384010E+00, 5.8472154657E+00, 1.6345454484E-01, 1.5279671988E-01, 5.1199057150E-01],
	[9.3800000000E+03, 3.9133523582E+00, 5.8463941379E+00, 1.6372633535E-01, 1.5303778733E-01, 5.1215181882E-01],
	[9.3850000000E+03, 3.9160667512E+00, 5.8455733630E+00, 1.6399843227E-01, 1.5327908856E-01, 5.1231303726E-01],
	[9.3900000000E+03, 3.9187815796E+00, 5.8447531405E+00, 1.6427083580E-01, 1.5352062360E-01, 5.1247422689E-01],
	[9.3950000000E+03, 3.9214968434E+00, 5.8439334696E+00, 1.6454354610E-01, 1.5376239252E-01, 5.1263538775E-01],
	[9.4000000000E+03, 3.9242125424E+00, 5.8431143497E+00, 1.6481656337E-01, 1.5400439535E-01, 5.1279651988E-01],
	[9.4050000000E+03, 3.9269286764E+00, 5.8422957800E+00, 1.6508988778E-01, 1.5424663214E-01, 5.1295762334E-01],
	[9.4100000000E+03, 3.9296452453E+00, 5.8414777601E+00, 1.6536351952E-01, 1.5448910295E-01, 5.1311869819E-01],
	[9.4150000000E+03, 3.9323622489E+00, 5.8406602891E+00, 1.6563745877E-01, 1.5473180781E-01, 5.1327974446E-01],
	[9.4200000000E+03, 3.9350796871E+00, 5.8398433664E+00, 1.6591170570E-01, 1.5497474678E-01, 5.1344076220E-01],
	[9.4250000000E+03, 3.9377975596E+00, 5.8390269914E+00, 1.6618626051E-01, 1.5521791991E-01, 5.1360175148E-01],
	[9.4300000000E+03, 3.9405158663E+00, 5.8382111634E+00, 1.6646112337E-01, 1.5546132724E-01, 5.1376271232E-01],
	[9.4350000000E+03, 3.9432346071E+00, 5.8373958818E+00, 1.6673629446E-01, 1.5570496882E-01, 5.1392364480E-01],
	[9.4400000000E+03, 3.9459537818E+00, 5.8365811458E+00, 1.6701177396E-01, 1.5594884469E-01, 5.1408454895E-01],
	[9.4450000000E+03, 3.9486733903E+00, 5.8357669549E+00, 1.6728756206E-01, 1.5619295490E-01, 5.1424542482E-01],
	[9.4500000000E+03, 3.9513934323E+00, 5.8349533084E+00, 1.6756365894E-01, 1.5643729950E-01, 5.1440627247E-01],
	[9.4550000000E+03, 3.9541139077E+00, 5.8341402057E+00, 1.6784006478E-01, 1.5668187854E-01, 5.1456709194E-01],
	[9.4600000000E+03, 3.9568348164E+00, 5.8333276460E+00, 1.6811677976E-01, 1.5692669205E-01, 5.1472788328E-01],
	[9.4650000000E+03, 3.9595561582E+00, 5.8325156287E+00, 1.6839380406E-01, 1.5717174009E-01, 5.1488864654E-01],
	[9.4700000000E+03, 3.9622779329E+00, 5.8317041533E+00, 1.6867113787E-01, 1.5741702271E-01, 5.1504938178E-01],
	[9.4750000000E+03, 3.9650028727E+00, 5.8309029238E+00, 1.6894878136E-01, 1.5766255136E-01, 5.1521008904E-01],
	[9.4800000000E+03, 3.9677290187E+00, 5.8301049643E+00, 1.6922673471E-01, 1.5790831796E-01, 5.1537076836E-01],
	[9.4850000000E+03, 3.9704556001E+00, 5.8293075348E+00, 1.6950499812E-01, 1.5815431935E-01, 5.1553141981E-01],
	[9.4900000000E+03, 3.9731826168E+00, 5.8285106344E+00, 1.6978361211E-01, 1.5840059070E-01, 5.1569204343E-01],
	[9.4950000000E+03, 3.9759100686E+00, 5.8277142627E+00, 1.7006255996E-01, 1.5864711732E-01, 5.1585263927E-01],
	[9.5000000000E+03, 3.9786379553E+00, 5.8269184190E+00, 1.7034181861E-01, 1.5889387902E-01, 5.1601320737E-01],
	[9.5050000000E+03, 3.9813662769E+00, 5.8261231026E+00, 1.7062138822E-01, 1.5914087584E-01, 5.1617374780E-01],
	[9.5100000000E+03, 3.9840950330E+00, 5.8253283129E+00, 1.7090126899E-01, 1.5938810783E-01, 5.1633426059E-01],
	[9.5150000000E+03, 3.9868242236E+00, 5.8245340494E+00, 1.7118146109E-01, 1.5963557502E-01, 5.1649474579E-01],
	[9.5200000000E+03, 3.9895538485E+00, 5.8237403113E+00, 1.7146196471E-01, 1.5988327747E-01, 5.1665520347E-01],
	[9.5250000000E+03, 3.9922839076E+00, 5.8229470980E+00, 1.7174278003E-01, 1.6013121522E-01, 5.1681563366E-01],
	[9.5300000000E+03, 3.9950144006E+00, 5.8221544090E+00, 1.7202390723E-01, 1.6037938831E-01, 5.1697603642E-01],
	[9.5350000000E+03, 3.9977453275E+00, 5.8213622436E+00, 1.7230534650E-01, 1.6062779679E-01, 5.1713641179E-01],
	[9.5400000000E+03, 4.0004766881E+00, 5.8205706012E+00, 1.7258709801E-01, 1.6087644070E-01, 5.1729675983E-01],
	[9.5450000000E+03, 4.0032084821E+00, 5.8197794811E+00, 1.7286916194E-01, 1.6112532009E-01, 5.1745708058E-01],
	[9.5500000000E+03, 4.0059407095E+00, 5.8189888828E+00, 1.7315153849E-01, 1.6137443499E-01, 5.1761737409E-01],
	[9.5550000000E+03, 4.0086733701E+00, 5.8181988057E+00, 1.7343422782E-01, 1.6162378546E-01, 5.1777764042E-01],
	[9.5600000000E+03, 4.0114064638E+00, 5.8174092490E+00, 1.7371723013E-01, 1.6187337154E-01, 5.1793787961E-01],
	[9.5650000000E+03, 4.0141399903E+00, 5.8166202123E+00, 1.7400054560E-01, 1.6212319326E-01, 5.1809809172E-01],
	[9.5700000000E+03, 4.0168739496E+00, 5.8158316948E+00, 1.7428417440E-01, 1.6237325068E-01, 5.1825827678E-01],
	[9.5750000000E+03, 4.0196083414E+00, 5.8150436961E+00, 1.7456811672E-01, 1.6262354383E-01, 5.1841843486E-01],
	[9.5800000000E+03, 4.0223431656E+00, 5.8142562153E+00, 1.7485237274E-01, 1.6287407276E-01, 5.1857856600E-01],
	[9.5850000000E+03, 4.0250784221E+00, 5.8134692521E+00, 1.7513694264E-01, 1.6312483752E-01, 5.1873867025E-01],
	[9.5900000000E+03, 4.0278141106E+00, 5.8126828057E+00, 1.7542182661E-01, 1.6337583813E-01, 5.1889874766E-01],
	[9.5950000000E+03, 4.0305502311E+00, 5.8118968755E+00, 1.7570702483E-01, 1.6362707465E-01, 5.1905879828E-01],
	[9.6000000000E+03, 4.0332867834E+00, 5.8111114609E+00, 1.7599253747E-01, 1.6387854712E-01, 5.1921882214E-01],
	[9.6050000000E+03, 4.0360237673E+00, 5.8103265614E+00, 1.7627836473E-01, 1.6413025558E-01, 5.1937881927E-01],
	[9.6100000000E+03, 4.0387611826E+00, 5.8095421763E+00, 1.7656450678E-01, 1.6438220007E-01, 5.1953878971E-01],
	[9.6150000000E+03, 4.0414990293E+00, 5.8087583050E+00, 1.7685096381E-01, 1.6463438063E-01, 5.1969873348E-01],
	[9.6200000000E+03, 4.0442373071E+00, 5.8079749469E+00, 1.7713773599E-01, 1.6488679731E-01, 5.1985865062E-01],
	[9.6250000000E+03, 4.0469770043E+00, 5.8071955088E+00, 1.7742482352E-01, 1.6513945454E-01, 5.2001854117E-01],
	[9.6300000000E+03, 4.0497196071E+00, 5.8064251019E+00, 1.7771222656E-01, 1.6539235904E-01, 5.2017840515E-01],
	[9.6350000000E+03, 4.0524626435E+00, 5.8056551970E+00, 1.7799994532E-01, 1.6564549985E-01, 5.2033824260E-01],
	[9.6400000000E+03, 4.0552061132E+00, 5.8048857936E+00, 1.7828797995E-01, 1.6589887703E-01, 5.2049805356E-01],
	[9.6450000000E+03, 4.0579500162E+00, 5.8041168910E+00, 1.7857633066E-01, 1.6615249060E-01, 5.2065783805E-01],
	[9.6500000000E+03, 4.0606943524E+00, 5.8033484886E+00, 1.7886499762E-01, 1.6640634062E-01, 5.2081759611E-01],
	[9.6550000000E+03, 4.0634391214E+00, 5.8025805860E+00, 1.7915398101E-01, 1.6666042713E-01, 5.2097732778E-01],
	[9.6600000000E+03, 4.0661843233E+00, 5.8018131824E+00, 1.7944328101E-01, 1.6691475015E-01, 5.2113703308E-01],
	[9.6650000000E+03, 4.0689299578E+00, 5.8010462774E+00, 1.7973289782E-01, 1.6716930974E-01, 5.2129671206E-01],
	[9.6700000000E+03, 4.0716760248E+00, 5.8002798703E+00, 1.8002283160E-01, 1.6742410593E-01, 5.2145636474E-01],
	[9.6750000000E+03, 4.0744225241E+00, 5.7995139606E+00, 1.8031308254E-01, 1.6767913877E-01, 5.2161599115E-01],
	[9.6800000000E+03, 4.0771694555E+00, 5.7987485476E+00, 1.8060365083E-01, 1.6793440829E-01, 5.2177559134E-01],
	[9.6850000000E+03, 4.0799168190E+00, 5.7979836308E+00, 1.8089453665E-01, 1.6818991454E-01, 5.2193516533E-01],
	[9.6900000000E+03, 4.0826646144E+00, 5.7972192096E+00, 1.8118574017E-01, 1.6844565755E-01, 5.2209471315E-01],
	[9.6950000000E+03, 4.0854128414E+00, 5.7964552835E+00, 1.8147726159E-01, 1.6870163736E-01, 5.2225423485E-01],
	[9.7000000000E+03, 4.0881615000E+00, 5.7956918519E+00, 1.8176910107E-01, 1.6895785401E-01, 5.2241373045E-01],
	[9.7050000000E+03, 4.0909105900E+00, 5.7949289141E+00, 1.8206125882E-01, 1.6921430754E-01, 5.2257320000E-01],
	[9.7100000000E+03, 4.0936601112E+00, 5.7941664697E+00, 1.8235373500E-01, 1.6947099799E-01, 5.2273264351E-01],
	[9.7150000000E+03, 4.0964100635E+00, 5.7934045180E+00, 1.8264652980E-01, 1.6972792540E-01, 5.2289206103E-01],
	[9.7200000000E+03, 4.0991604468E+00, 5.7926430585E+00, 1.8293964341E-01, 1.6998508980E-01, 5.2305145258E-01],
	[9.7250000000E+03, 4.1019112608E+00, 5.7918820905E+00, 1.8323307599E-01, 1.7024249125E-01, 5.2321081821E-01],
	[9.7300000000E+03, 4.1046625054E+00, 5.7911216136E+00, 1.8352682775E-01, 1.7050012976E-01, 5.2337015795E-01],
	[9.7350000000E+03, 4.1074141805E+00, 5.7903616272E+00, 1.8382089886E-01, 1.7075800538E-01, 5.2352947183E-01],
	[9.7400000000E+03, 4.1101662860E+00, 5.7896021307E+00, 1.8411528950E-01, 1.7101611816E-01, 5.2368875988E-01],
	[9.7450000000E+03, 4.1129188216E+00, 5.7888431235E+00, 1.8440999985E-01, 1.7127446812E-01, 5.2384802213E-01],
	[9.7500000000E+03, 4.1156717872E+00, 5.7880846051E+00, 1.8470503010E-01, 1.7153305531E-01, 5.2400725863E-01],
	[9.7550000000E+03, 4.1184251826E+00, 5.7873265748E+00, 1.8500038043E-01, 1.7179187975E-01, 5.2416646940E-01],
	[9.7600000000E+03, 4.1211790077E+00, 5.7865690322E+00, 1.8529605102E-01, 1.7205094150E-01, 5.2432565448E-01],
	[9.7650000000E+03, 4.1239332624E+00, 5.7858119767E+00, 1.8559204205E-01, 1.7231024058E-01, 5.2448481391E-01],
	[9.7700000000E+03, 4.1266879465E+00, 5.7850554076E+00, 1.8588835371E-01, 1.7256977704E-01, 5.2464394770E-01],
	[9.7750000000E+03, 4.1294430599E+00, 5.7842993245E+00, 1.8618498618E-01, 1.7282955091E-01, 5.2480305591E-01],
	[9.7800000000E+03, 4.1321996291E+00, 5.7835471607E+00, 1.8648193964E-01, 1.7308956710E-01, 5.2496213856E-01],
	[9.7850000000E+03, 4.1349590220E+00, 5.7828034777E+00, 1.8677921427E-01, 1.7334983219E-01, 5.2512119569E-01],
	[9.7900000000E+03, 4.1377188464E+00, 5.7820602702E+00, 1.8707681026E-01, 1.7361033489E-01, 5.2528022733E-01],
	[9.7950000000E+03, 4.1404791023E+00, 5.7813175377E+00, 1.8737472779E-01, 1.7387107523E-01, 5.2543923352E-01],
	[9.8000000000E+03, 4.1432397894E+00, 5.7805752795E+00, 1.8767296704E-01, 1.7413205324E-01, 5.2559821428E-01],
	[9.8050000000E+03, 4.1460009077E+00, 5.7798334951E+00, 1.8797152820E-01, 1.7439326897E-01, 5.2575716966E-01],
	[9.8100000000E+03, 4.1487624570E+00, 5.7790921840E+00, 1.8827041144E-01, 1.7465472244E-01, 5.2591609968E-01],
	[9.8150000000E+03, 4.1515244372E+00, 5.7783513457E+00, 1.8856961695E-01, 1.7491641370E-01, 5.2607500438E-01],
	[9.8200000000E+03, 4.1542868480E+00, 5.7776109795E+00, 1.8886914491E-01, 1.7517834278E-01, 5.2623388380E-01],
	[9.8250000000E+03, 4.1570496893E+00, 5.7768710851E+00, 1.8916899550E-01, 1.7544050971E-01, 5.2639273796E-01],
	[9.8300000000E+03, 4.1598129610E+00, 5.7761316617E+00, 1.8946916891E-01, 1.7570291453E-01, 5.2655156691E-01],
	[9.8350000000E+03, 4.1625766630E+00, 5.7753927089E+00, 1.8976966532E-01, 1.7596555728E-01, 5.2671037068E-01],
	[9.8400000000E+03, 4.1653407950E+00, 5.7746542262E+00, 1.9007048491E-01, 1.7622843799E-01, 5.2686914929E-01],
	[9.8450000000E+03, 4.1681053570E+00, 5.7739162130E+00, 1.9037162786E-01, 1.7649155670E-01, 5.2702790279E-01],
	[9.8500000000E+03, 4.1708703487E+00, 5.7731786687E+00, 1.9067309436E-01, 1.7675491343E-01, 5.2718663121E-01],
	[9.8550000000E+03, 4.1736357700E+00, 5.7724415929E+00, 1.9097488459E-01, 1.7701850823E-01, 5.2734533458E-01],
	[9.8600000000E+03, 4.1764016208E+00, 5.7717049850E+00, 1.9127699873E-01, 1.7728234112E-01, 5.2750401293E-01],
	[9.8650000000E+03, 4.1791679010E+00, 5.7709688444E+00, 1.9157943697E-01, 1.7754641215E-01, 5.2766266631E-01],
	[9.8700000000E+03, 4.1819346103E+00, 5.7702331707E+00, 1.9188219948E-01, 1.7781072135E-01, 5.2782129474E-01],
	[9.8750000000E+03, 4.1847017486E+00, 5.7694979633E+00, 1.9218528645E-01, 1.7807526874E-01, 5.2797989826E-01],
	[9.8800000000E+03, 4.1874693157E+00, 5.7687632216E+00, 1.9248869807E-01, 1.7834005437E-01, 5.2813847690E-01],
	[9.8850000000E+03, 4.1902373116E+00, 5.7680289452E+00, 1.9279243450E-01, 1.7860507827E-01, 5.2829703070E-01],
	[9.8900000000E+03, 4.1930057361E+00, 5.7672951335E+00, 1.9309649595E-01, 1.7887034047E-01, 5.2845555969E-01],
	[9.8950000000E+03, 4.1957745890E+00, 5.7665617860E+00, 1.9340088259E-01, 1.7913584100E-01, 5.2861406390E-01],
	[9.9000000000E+03, 4.1985438701E+00, 5.7658289021E+00, 1.9370559460E-01, 1.7940157990E-01, 5.2877254337E-01],
	[9.9050000000E+03, 4.2013135793E+00, 5.7650964813E+00, 1.9401063216E-01, 1.7966755720E-01, 5.2893099814E-01],
	[9.9100000000E+03, 4.2040837166E+00, 5.7643645231E+00, 1.9431599547E-01, 1.7993377293E-01, 5.2908942824E-01],
	[9.9150000000E+03, 4.2068542816E+00, 5.7636330271E+00, 1.9462168469E-01, 1.8020022713E-01, 5.2924783370E-01],
	[9.9200000000E+03, 4.2096252743E+00, 5.7629019925E+00, 1.9492770002E-01, 1.8046691982E-01, 5.2940621455E-01],
	[9.9250000000E+03, 4.2123966945E+00, 5.7621714190E+00, 1.9523404163E-01, 1.8073385105E-01, 5.2956457083E-01],
	[9.9300000000E+03, 4.2151685420E+00, 5.7614413060E+00, 1.9554070972E-01, 1.8100102083E-01, 5.2972290258E-01],
	[9.9350000000E+03, 4.2179408168E+00, 5.7607116529E+00, 1.9584770445E-01, 1.8126842921E-01, 5.2988120983E-01],
	[9.9400000000E+03, 4.2207162819E+00, 5.7599914022E+00, 1.9615502602E-01, 1.8153609021E-01, 5.3003949261E-01],
	[9.9450000000E+03, 4.2234927988E+00, 5.7592736171E+00, 1.9646267461E-01, 1.8180399309E-01, 5.3019775096E-01],
	[9.9500000000E+03, 4.2262697452E+00, 5.7585562822E+00, 1.9677065040E-01, 1.8207213475E-01, 5.3035598491E-01],
	[9.9550000000E+03, 4.2290471210E+00, 5.7578393970E+00, 1.9707895357E-01, 1.8234051522E-01, 5.3051419450E-01],
	[9.9600000000E+03, 4.2318249260E+00, 5.7571229609E+00, 1.9738758431E-01, 1.8260913453E-01, 5.3067237982E-01],
	[9.9650000000E+03, 4.2346031600E+00, 5.7564069735E+00, 1.9769654279E-01, 1.8287799270E-01, 5.3083054102E-01],
	[9.9700000000E+03, 4.2373818230E+00, 5.7556914342E+00, 1.9800582921E-01, 1.8314708978E-01, 5.3098867810E-01],
	[9.9750000000E+03, 4.2401609147E+00, 5.7549763425E+00, 1.9831544374E-01, 1.8341642579E-01, 5.3114679108E-01],
	[9.9800000000E+03, 4.2429404351E+00, 5.7542616979E+00, 1.9862538657E-01, 1.8368600075E-01, 5.3130487998E-01],
	[9.9850000000E+03, 4.2457203839E+00, 5.7535475000E+00, 1.9893565788E-01, 1.8395581472E-01, 5.3146294482E-01],
	[9.9900000000E+03, 4.2485007611E+00, 5.7528337482E+00, 1.9924625785E-01, 1.8422586770E-01, 5.3162098560E-01],
	[9.9950000000E+03, 4.2512815664E+00, 5.7521204420E+00, 1.9955718666E-01, 1.8449615973E-01, 5.3177900234E-01],
	[1.0000000000E+04, 4.2540627998E+00, 5.7514075810E+00, 1.9986844451E-01, 1.8476669085E-01, 5.3193699507E-01],
	[1.0005000000E+04, 4.2568444610E+00, 5.7506951646E+00, 2.0018143055E-01, 1.8503865642E-01, 5.3209496378E-01],
	[1.0010000000E+04, 4.2596265500E+00, 5.7499831922E+00, 2.0049474968E-01, 1.8531086384E-01, 5.3225290851E-01],
	[1.0015000000E+04, 4.2624090666E+00, 5.7492716635E+00, 2.0080840208E-01, 1.8558331314E-01, 5.3241082925E-01],
	[1.0020000000E+04, 4.2651920105E+00, 5.7485605780E+00, 2.0112238795E-01, 1.8585600435E-01, 5.3256872604E-01],
	[1.0025000000E+04, 4.2679753818E+00, 5.7478499350E+00, 2.0143670746E-01, 1.8612893750E-01, 5.3272659888E-01],
	[1.0030000000E+04, 4.2707591802E+00, 5.7471397342E+00, 2.0175136081E-01, 1.8640211262E-01, 5.3288444778E-01],
	[1.0035000000E+04, 4.2735434056E+00, 5.7464299751E+00, 2.0206634818E-01, 1.8667552975E-01, 5.3304227277E-01],
	[1.0040000000E+04, 4.2763280579E+00, 5.7457206570E+00, 2.0238166977E-01, 1.8694918891E-01, 5.3320007386E-01],
	[1.0045000000E+04, 4.2791131368E+00, 5.7450117797E+00, 2.0269732575E-01, 1.8722309013E-01, 5.3335785107E-01],
	[1.0050000000E+04, 4.2818986423E+00, 5.7443033424E+00, 2.0301331631E-01, 1.8749723344E-01, 5.3351560440E-01],
	[1.0055000000E+04, 4.2846845743E+00, 5.7435953449E+00, 2.0332964165E-01, 1.8777161888E-01, 5.3367333388E-01],
	[1.0060000000E+04, 4.2874709324E+00, 5.7428877865E+00, 2.0364630195E-01, 1.8804624647E-01, 5.3383103952E-01],
	[1.0065000000E+04, 4.2902577167E+00, 5.7421806668E+00, 2.0396329740E-01, 1.8832111624E-01, 5.3398872133E-01],
	[1.0070000000E+04, 4.2930449269E+00, 5.7414739853E+00, 2.0428062819E-01, 1.8859622822E-01, 5.3414637934E-01],
	[1.0075000000E+04, 4.2958325630E+00, 5.7407677414E+00, 2.0459829449E-01, 1.8887158244E-01, 5.3430401355E-01],
	[1.0080000000E+04, 4.2986206247E+00, 5.7400619348E+00, 2.0491629651E-01, 1.8914717893E-01, 5.3446162398E-01],
	[1.0085000000E+04, 4.3014091120E+00, 5.7393565650E+00, 2.0523463442E-01, 1.8942301772E-01, 5.3461921066E-01],
	[1.0090000000E+04, 4.3041980246E+00, 5.7386516313E+00, 2.0555330842E-01, 1.8969909884E-01, 5.3477677358E-01],
	[1.0095000000E+04, 4.3069873625E+00, 5.7379471335E+00, 2.0587231870E-01, 1.8997542231E-01, 5.3493431277E-01],
	[1.0100000000E+04, 4.3097799820E+00, 5.7372517908E+00, 2.0619166543E-01, 1.9025200332E-01, 5.3509182825E-01],
	[1.0105000000E+04, 4.3125736340E+00, 5.7365587227E+00, 2.0651134881E-01, 1.9052883004E-01, 5.3524932003E-01],
	[1.0110000000E+04, 4.3153677136E+00, 5.7358660811E+00, 2.0683136903E-01, 1.9080589929E-01, 5.3540678813E-01],
	[1.0115000000E+04, 4.3181622206E+00, 5.7351738656E+00, 2.0715172627E-01, 1.9108321110E-01, 5.3556423255E-01],
	[1.0120000000E+04, 4.3209571549E+00, 5.7344820756E+00, 2.0747242072E-01, 1.9136076549E-01, 5.3572165333E-01],
	[1.0125000000E+04, 4.3237525163E+00, 5.7337907107E+00, 2.0779345257E-01, 1.9163856250E-01, 5.3587905046E-01],
	[1.0130000000E+04, 4.3265483046E+00, 5.7330997704E+00, 2.0811482200E-01, 1.9191660216E-01, 5.3603642398E-01],
	[1.0135000000E+04, 4.3293445199E+00, 5.7324092543E+00, 2.0843652921E-01, 1.9219488448E-01, 5.3619377389E-01],
	[1.0140000000E+04, 4.3321411618E+00, 5.7317191618E+00, 2.0875857438E-01, 1.9247340951E-01, 5.3635110021E-01],
	[1.0145000000E+04, 4.3349382302E+00, 5.7310294926E+00, 2.0908095770E-01, 1.9275217725E-01, 5.3650840295E-01],
	[1.0150000000E+04, 4.3377357251E+00, 5.7303402461E+00, 2.0940367936E-01, 1.9303118775E-01, 5.3666568214E-01],
	[1.0155000000E+04, 4.3405336462E+00, 5.7296514219E+00, 2.0972673954E-01, 1.9331044103E-01, 5.3682293779E-01],
	[1.0160000000E+04, 4.3433319934E+00, 5.7289630195E+00, 2.1005013843E-01, 1.9358993711E-01, 5.3698016991E-01],
	[1.0165000000E+04, 4.3461307666E+00, 5.7282750384E+00, 2.1037387622E-01, 1.9386967603E-01, 5.3713737852E-01],
	[1.0170000000E+04, 4.3489299656E+00, 5.7275874783E+00, 2.1069795309E-01, 1.9414965780E-01, 5.3729456363E-01],
	[1.0175000000E+04, 4.3517295903E+00, 5.7269003385E+00, 2.1102236925E-01, 1.9442988245E-01, 5.3745172527E-01],
	[1.0180000000E+04, 4.3545296406E+00, 5.7262136187E+00, 2.1134712486E-01, 1.9471035002E-01, 5.3760886345E-01],
	[1.0185000000E+04, 4.3573301162E+00, 5.7255273184E+00, 2.1167222013E-01, 1.9499106052E-01, 5.3776597818E-01],
	[1.0190000000E+04, 4.3601310170E+00, 5.7248414371E+00, 2.1199765523E-01, 1.9527201398E-01, 5.3792306949E-01],
	[1.0195000000E+04, 4.3629323430E+00, 5.7241559744E+00, 2.1232343036E-01, 1.9555321042E-01, 5.3808013738E-01],
	[1.0200000000E+04, 4.3657340939E+00, 5.7234709298E+00, 2.1264954570E-01, 1.9583464988E-01, 5.3823718187E-01],
	[1.0205000000E+04, 4.3685362696E+00, 5.7227863029E+00, 2.1297600144E-01, 1.9611633238E-01, 5.3839420298E-01],
	[1.0210000000E+04, 4.3713388700E+00, 5.7221020931E+00, 2.1330279778E-01, 1.9639825793E-01, 5.3855120073E-01],
	[1.0215000000E+04, 4.3741418949E+00, 5.7214183000E+00, 2.1362993489E-01, 1.9668042657E-01, 5.3870817512E-01],
	[1.0220000000E+04, 4.3769453442E+00, 5.7207349233E+00, 2.1395741296E-01, 1.9696283833E-01, 5.3886512619E-01],
	[1.0225000000E+04, 4.3797492177E+00, 5.7200519623E+00, 2.1428523219E-01, 1.9724549321E-01, 5.3902205394E-01],
	[1.0230000000E+04, 4.3825535153E+00, 5.7193694167E+00, 2.1461339275E-01, 1.9752839126E-01, 5.3917895839E-01],
	[1.0235000000E+04, 4.3853582369E+00, 5.7186872860E+00, 2.1494189485E-01, 1.9781153249E-01, 5.3933583956E-01],
	[1.0240000000E+04, 4.3881633823E+00, 5.7180055698E+00, 2.1527073866E-01, 1.9809491692E-01, 5.3949269746E-01],
	[1.0245000000E+04, 4.3909689513E+00, 5.7173242675E+00, 2.1559992438E-01, 1.9837854459E-01, 5.3964953212E-01],
	[1.0250000000E+04, 4.3937749439E+00, 5.7166433788E+00, 2.1592945218E-01, 1.9866241551E-01, 5.3980634353E-01],
	[1.0255000000E+04, 4.3965813598E+00, 5.7159629032E+00, 2.1625932227E-01, 1.9894652971E-01, 5.3996313173E-01],
	[1.0260000000E+04, 4.3993893560E+00, 5.7152861108E+00, 2.1658953482E-01, 1.9923089356E-01, 5.4011989674E-01],
	[1.0265000000E+04, 4.4022002442E+00, 5.7146166993E+00, 2.1692009003E-01, 1.9951551433E-01, 5.4027663855E-01],
	[1.0270000000E+04, 4.4050115583E+00, 5.7139476921E+00, 2.1725098809E-01, 1.9980037854E-01, 5.4043335720E-01],
	[1.0275000000E+04, 4.4078232980E+00, 5.7132790889E+00, 2.1758222917E-01, 2.0008548622E-01, 5.4059005270E-01],
	[1.0280000000E+04, 4.4106354632E+00, 5.7126108891E+00, 2.1791381347E-01, 2.0037083739E-01, 5.4074672507E-01],
	[1.0285000000E+04, 4.4134480539E+00, 5.7119430923E+00, 2.1824574118E-01, 2.0065643207E-01, 5.4090337431E-01],
	[1.0290000000E+04, 4.4162610697E+00, 5.7112756981E+00, 2.1857801249E-01, 2.0094227029E-01, 5.4106000046E-01],
	[1.0295000000E+04, 4.4190745107E+00, 5.7106087061E+00, 2.1891062758E-01, 2.0122835206E-01, 5.4121660352E-01],
	[1.0300000000E+04, 4.4218883766E+00, 5.7099421157E+00, 2.1924358663E-01, 2.0151467742E-01, 5.4137318352E-01],
	[1.0305000000E+04, 4.4247026673E+00, 5.7092759266E+00, 2.1957688985E-01, 2.0180124637E-01, 5.4152974046E-01],
	[1.0310000000E+04, 4.4275173828E+00, 5.7086101383E+00, 2.1991053742E-01, 2.0208805895E-01, 5.4168627437E-01],
	[1.0315000000E+04, 4.4303325227E+00, 5.7079447504E+00, 2.2024452952E-01, 2.0237511517E-01, 5.4184278527E-01],
	[1.0320000000E+04, 4.4331480870E+00, 5.7072797625E+00, 2.2057886634E-01, 2.0266241506E-01, 5.4199927316E-01],
	[1.0325000000E+04, 4.4359640756E+00, 5.7066151741E+00, 2.2091354807E-01, 2.0294995864E-01, 5.4215573807E-01],
	[1.0330000000E+04, 4.4387804883E+00, 5.7059509848E+00, 2.2124857491E-01, 2.0323774592E-01, 5.4231218001E-01],
	[1.0335000000E+04, 4.4415973249E+00, 5.7052871941E+00, 2.2158394703E-01, 2.0352577694E-01, 5.4246859901E-01],
	[1.0340000000E+04, 4.4444145854E+00, 5.7046238017E+00, 2.2191966462E-01, 2.0381405170E-01, 5.4262499507E-01],
	[1.0345000000E+04, 4.4472322696E+00, 5.7039608070E+00, 2.2225572788E-01, 2.0410257024E-01, 5.4278136822E-01],
	[1.0350000000E+04, 4.4500503772E+00, 5.7032982097E+00, 2.2259213699E-01, 2.0439133257E-01, 5.4293771847E-01],
	[1.0355000000E+04, 4.4528689083E+00, 5.7026360094E+00, 2.2292889214E-01, 2.0468033870E-01, 5.4309404584E-01],
	[1.0360000000E+04, 4.4556878627E+00, 5.7019742055E+00, 2.2326599352E-01, 2.0496958867E-01, 5.4325035034E-01],
	[1.0365000000E+04, 4.4585072402E+00, 5.7013127978E+00, 2.2360344131E-01, 2.0525908249E-01, 5.4340663200E-01],
	[1.0370000000E+04, 4.4613270406E+00, 5.7006517856E+00, 2.2394123571E-01, 2.0554882019E-01, 5.4356289083E-01],
	[1.0375000000E+04, 4.4641472639E+00, 5.6999911687E+00, 2.2427937690E-01, 2.0583880177E-01, 5.4371912684E-01],
	[1.0380000000E+04, 4.4669679099E+00, 5.6993309466E+00, 2.2461786507E-01, 2.0612902726E-01, 5.4387534006E-01],
	[1.0385000000E+04, 4.4697889784E+00, 5.6986711189E+00, 2.2495670040E-01, 2.0641949668E-01, 5.4403153050E-01],
	[1.0390000000E+04, 4.4726104694E+00, 5.6980116851E+00, 2.2529588310E-01, 2.0671021006E-01, 5.4418769818E-01],
	[1.0395000000E+04, 4.4754323826E+00, 5.6973526448E+00, 2.2563541334E-01, 2.0700116739E-01, 5.4434384311E-01],
	[1.0400000000E+04, 4.4782547179E+00, 5.6966939976E+00, 2.2597529131E-01, 2.0729236872E-01, 5.4449996532E-01],
	[1.0405000000E+04, 4.4810774753E+00, 5.6960357431E+00, 2.2631551720E-01, 2.0758381405E-01, 5.4465606482E-01],
	[1.0410000000E+04, 4.4839006545E+00, 5.6953778808E+00, 2.2665609120E-01, 2.0787550340E-01, 5.4481214162E-01],
	[1.0415000000E+04, 4.4867242555E+00, 5.6947204103E+00, 2.2699701350E-01, 2.0816743679E-01, 5.4496819575E-01],
	[1.0420000000E+04, 4.4895482780E+00, 5.6940633313E+00, 2.2733828428E-01, 2.0845961424E-01, 5.4512422723E-01],
	[1.0425000000E+04, 4.4923738213E+00, 5.6934095229E+00, 2.2767990374E-01, 2.0875204201E-01, 5.4528023606E-01],
	[1.0430000000E+04, 4.4952024795E+00, 5.6927631512E+00, 2.2802187206E-01, 2.0904472924E-01, 5.4543622228E-01],
	[1.0435000000E+04, 4.4980315619E+00, 5.6921171626E+00, 2.2836418943E-01, 2.0933766068E-01, 5.4559218588E-01],
	[1.0440000000E+04, 4.5008610683E+00, 5.6914715568E+00, 2.2870685604E-01, 2.0963083636E-01, 5.4574812690E-01],
	[1.0445000000E+04, 4.5036909984E+00, 5.6908263332E+00, 2.2904987208E-01, 2.0992425628E-01, 5.4590404535E-01],
	[1.0450000000E+04, 4.5065213523E+00, 5.6901814915E+00, 2.2939323773E-01, 2.1021792047E-01, 5.4605994125E-01],
	[1.0455000000E+04, 4.5093521297E+00, 5.6895370313E+00, 2.2973695319E-01, 2.1051182895E-01, 5.4621581461E-01],
	[1.0460000000E+04, 4.5121833305E+00, 5.6888929522E+00, 2.3008101864E-01, 2.1080598173E-01, 5.4637166545E-01],
	[1.0465000000E+04, 4.5150149546E+00, 5.6882492538E+00, 2.3042543426E-01, 2.1110037883E-01, 5.4652749380E-01],
	[1.0470000000E+04, 4.5178470019E+00, 5.6876059356E+00, 2.3077020026E-01, 2.1139502027E-01, 5.4668329966E-01],
	[1.0475000000E+04, 4.5206794721E+00, 5.6869629972E+00, 2.3111531682E-01, 2.1168990605E-01, 5.4683908306E-01],
	[1.0480000000E+04, 4.5235123652E+00, 5.6863204383E+00, 2.3146078411E-01, 2.1198503621E-01, 5.4699484401E-01],
	[1.0485000000E+04, 4.5263456810E+00, 5.6856782584E+00, 2.3180660235E-01, 2.1228041075E-01, 5.4715058253E-01],
	[1.0490000000E+04, 4.5291794194E+00, 5.6850364572E+00, 2.3215277170E-01, 2.1257602969E-01, 5.4730629864E-01],
	[1.0495000000E+04, 4.5320135803E+00, 5.6843950342E+00, 2.3249929237E-01, 2.1287189305E-01, 5.4746199236E-01],
	[1.0500000000E+04, 4.5348481634E+00, 5.6837539890E+00, 2.3284616453E-01, 2.1316800083E-01, 5.4761766370E-01],
	[1.0505000000E+04, 4.5376831687E+00, 5.6831133213E+00, 2.3319338839E-01, 2.1346435307E-01, 5.4777331269E-01],
	[1.0510000000E+04, 4.5405185961E+00, 5.6824730306E+00, 2.3354096411E-01, 2.1376094976E-01, 5.4792893933E-01],
	[1.0515000000E+04, 4.5433544453E+00, 5.6818331165E+00, 2.3388889191E-01, 2.1405779094E-01, 5.4808454365E-01],
	[1.0520000000E+04, 4.5461907163E+00, 5.6811935786E+00, 2.3423717195E-01, 2.1435487660E-01, 5.4824012567E-01],
	[1.0525000000E+04, 4.5490274089E+00, 5.6805544166E+00, 2.3458580444E-01, 2.1465220678E-01, 5.4839568540E-01],
	[1.0530000000E+04, 4.5518645229E+00, 5.6799156300E+00, 2.3493478955E-01, 2.1494978147E-01, 5.4855122286E-01],
	[1.0535000000E+04, 4.5547020583E+00, 5.6792772184E+00, 2.3528412749E-01, 2.1524760070E-01, 5.4870673807E-01],
	[1.0540000000E+04, 4.5575400150E+00, 5.6786391814E+00, 2.3563381843E-01, 2.1554566448E-01, 5.4886223105E-01],
	[1.0545000000E+04, 4.5603783926E+00, 5.6780015187E+00, 2.3598386256E-01, 2.1584397283E-01, 5.4901770181E-01],
	[1.0550000000E+04, 4.5632171912E+00, 5.6773642298E+00, 2.3633426008E-01, 2.1614252575E-01, 5.4917315038E-01],
	[1.0555000000E+04, 4.5660564106E+00, 5.6767273144E+00, 2.3668501117E-01, 2.1644132327E-01, 5.4932857677E-01],
	[1.0560000000E+04, 4.5688960507E+00, 5.6760907719E+00, 2.3703611602E-01, 2.1674036539E-01, 5.4948398100E-01],
	[1.0565000000E+04, 4.5717361112E+00, 5.6754546022E+00, 2.3738757483E-01, 2.1703965213E-01, 5.4963936308E-01],
	[1.0570000000E+04, 4.5745765921E+00, 5.6748188047E+00, 2.3773938777E-01, 2.1733918350E-01, 5.4979472304E-01],
	[1.0575000000E+04, 4.5774174933E+00, 5.6741833790E+00, 2.3809155503E-01, 2.1763895951E-01, 5.4995006090E-01],
	[1.0580000000E+04, 4.5802588146E+00, 5.6735483248E+00, 2.3844407681E-01, 2.1793898019E-01, 5.5010537667E-01],
	[1.0585000000E+04, 4.5831005559E+00, 5.6729136417E+00, 2.3879695330E-01, 2.1823924553E-01, 5.5026067037E-01],
	[1.0590000000E+04, 4.5859427170E+00, 5.6722793293E+00, 2.3915018467E-01, 2.1853975556E-01, 5.5041594201E-01],
	[1.0595000000E+04, 4.5887881849E+00, 5.6716524029E+00, 2.3950377113E-01, 2.1884052729E-01, 5.5057119162E-01],
	[1.0600000000E+04, 4.5916351485E+00, 5.6710284488E+00, 2.3985771285E-01, 2.1914155015E-01, 5.5072641922E-01],
	[1.0605000000E+04, 4.5944825344E+00, 5.6704048575E+00, 2.4021201004E-01, 2.1944281784E-01, 5.5088162482E-01],
	[1.0610000000E+04, 4.5973303427E+00, 5.6697816286E+00, 2.4056666287E-01, 2.1974433037E-01, 5.5103680845E-01],
	[1.0615000000E+04, 4.6001785732E+00, 5.6691587619E+00, 2.4092167154E-01, 2.2004608776E-01, 5.5119197011E-01],
	[1.0620000000E+04, 4.6030272258E+00, 5.6685362568E+00, 2.4127703623E-01, 2.2034809001E-01, 5.5134710983E-01],
	[1.0625000000E+04, 4.6058763003E+00, 5.6679141131E+00, 2.4163275713E-01, 2.2065033713E-01, 5.5150222763E-01],
	[1.0630000000E+04, 4.6087257965E+00, 5.6672923303E+00, 2.4198883443E-01, 2.2095282914E-01, 5.5165732352E-01],
	[1.0635000000E+04, 4.6115757144E+00, 5.6666709080E+00, 2.4234526833E-01, 2.2125556606E-01, 5.5181239753E-01],
	[1.0640000000E+04, 4.6144260539E+00, 5.6660498459E+00, 2.4270205900E-01, 2.2155854788E-01, 5.5196744967E-01],
	[1.0645000000E+04, 4.6172768146E+00, 5.6654291437E+00, 2.4305920664E-01, 2.2186177462E-01, 5.5212247995E-01],
	[1.0650000000E+04, 4.6201279967E+00, 5.6648088009E+00, 2.4341671144E-01, 2.2216524630E-01, 5.5227748834E-01],
	[1.0655000000E+04, 4.6229795998E+00, 5.6641888171E+00, 2.4377457358E-01, 2.2246896292E-01, 5.5243247481E-01],
	[1.0660000000E+04, 4.6258316239E+00, 5.6635691920E+00, 2.4413279325E-01, 2.2277292449E-01, 5.5258743937E-01],
	[1.0665000000E+04, 4.6286840689E+00, 5.6629499252E+00, 2.4449137065E-01, 2.2307713103E-01, 5.5274238202E-01],
	[1.0670000000E+04, 4.6315369345E+00, 5.6623310163E+00, 2.4485030596E-01, 2.2338158253E-01, 5.5289730275E-01],
	[1.0675000000E+04, 4.6343902207E+00, 5.6617124649E+00, 2.4520959937E-01, 2.2368627903E-01, 5.5305220157E-01],
	[1.0680000000E+04, 4.6372439273E+00, 5.6610942708E+00, 2.4556925107E-01, 2.2399122051E-01, 5.5320707847E-01],
	[1.0685000000E+04, 4.6400980543E+00, 5.6604764334E+00, 2.4592926124E-01, 2.2429640700E-01, 5.5336193345E-01],
	[1.0690000000E+04, 4.6429526013E+00, 5.6598589525E+00, 2.4628963008E-01, 2.2460183850E-01, 5.5351676652E-01],
	[1.0695000000E+04, 4.6458075685E+00, 5.6592418276E+00, 2.4665035778E-01, 2.2490751502E-01, 5.5367157767E-01],
	[1.0700000000E+04, 4.6486629555E+00, 5.6586250584E+00, 2.4701144452E-01, 2.2521343657E-01, 5.5382636691E-01],
	[1.0705000000E+04, 4.6515187622E+00, 5.6580086445E+00, 2.4737289049E-01, 2.2551960315E-01, 5.5398113423E-01],
	[1.0710000000E+04, 4.6543749886E+00, 5.6573925856E+00, 2.4773469589E-01, 2.2582601479E-01, 5.5413587963E-01],
	[1.0715000000E+04, 4.6572316344E+00, 5.6567768812E+00, 2.4809686090E-01, 2.2613267148E-01, 5.5429060311E-01],
	[1.0720000000E+04, 4.6600886997E+00, 5.6561615311E+00, 2.4845938570E-01, 2.2643957324E-01, 5.5444530468E-01],
	[1.0725000000E+04, 4.6629461841E+00, 5.6555465347E+00, 2.4882227049E-01, 2.2674672007E-01, 5.5459998433E-01],
	[1.0730000000E+04, 4.6658040876E+00, 5.6549318919E+00, 2.4918551547E-01, 2.2705411198E-01, 5.5475464206E-01],
	[1.0735000000E+04, 4.6686624101E+00, 5.6543176021E+00, 2.4954912080E-01, 2.2736174898E-01, 5.5490927787E-01],
	[1.0740000000E+04, 4.6715211513E+00, 5.6537036651E+00, 2.4991308669E-01, 2.2766963107E-01, 5.5506389177E-01],
	[1.0745000000E+04, 4.6743803113E+00, 5.6530900804E+00, 2.5027741333E-01, 2.2797775827E-01, 5.5521848375E-01],
	[1.0750000000E+04, 4.6772398898E+00, 5.6524768478E+00, 2.5064210090E-01, 2.2828613058E-01, 5.5537305381E-01],
	[1.0755000000E+04, 4.6800998867E+00, 5.6518639667E+00, 2.5100714959E-01, 2.2859474800E-01, 5.5552760195E-01],
	[1.0760000000E+04, 4.6829603020E+00, 5.6512514370E+00, 2.5137255959E-01, 2.2890361055E-01, 5.5568212818E-01],
	[1.0765000000E+04, 4.6858237283E+00, 5.6506451134E+00, 2.5173833109E-01, 2.2921273408E-01, 5.5583663248E-01],
	[1.0770000000E+04, 4.6886891131E+00, 5.6500426078E+00, 2.5210446428E-01, 2.2952211222E-01, 5.5599111488E-01],
	[1.0775000000E+04, 4.6915549189E+00, 5.6494404461E+00, 2.5247095935E-01, 2.2983173563E-01, 5.5614557535E-01],
	[1.0780000000E+04, 4.6944211456E+00, 5.6488386278E+00, 2.5283781649E-01, 2.3014160431E-01, 5.5630001391E-01],
	[1.0785000000E+04, 4.6972877931E+00, 5.6482371527E+00, 2.5320503588E-01, 2.3045171826E-01, 5.5645443055E-01],
	[1.0790000000E+04, 4.7001548611E+00, 5.6476360204E+00, 2.5357261771E-01, 2.3076207749E-01, 5.5660882528E-01],
	[1.0795000000E+04, 4.7030223496E+00, 5.6470352305E+00, 2.5394056218E-01, 2.3107268201E-01, 5.5676319809E-01],
	[1.0800000000E+04, 4.7058902585E+00, 5.6464347827E+00, 2.5430886947E-01, 2.3138353181E-01, 5.5691754898E-01],
	[1.0805000000E+04, 4.7087585876E+00, 5.6458346766E+00, 2.5467753978E-01, 2.3169462692E-01, 5.5707187796E-01],
	[1.0810000000E+04, 4.7116273367E+00, 5.6452349119E+00, 2.5504657328E-01, 2.3200596733E-01, 5.5722618503E-01],
	[1.0815000000E+04, 4.7144965058E+00, 5.6446354882E+00, 2.5541597018E-01, 2.3231755305E-01, 5.5738047019E-01],
	[1.0820000000E+04, 4.7173660947E+00, 5.6440364052E+00, 2.5578573065E-01, 2.3262938408E-01, 5.5753473343E-01],
	[1.0825000000E+04, 4.7202361033E+00, 5.6434376624E+00, 2.5615585490E-01, 2.3294146043E-01, 5.5768897476E-01],
	[1.0830000000E+04, 4.7231065315E+00, 5.6428392597E+00, 2.5652634310E-01, 2.3325378210E-01, 5.5784319417E-01],
	[1.0835000000E+04, 4.7259773791E+00, 5.6422411965E+00, 2.5689719544E-01, 2.3356634910E-01, 5.5799739168E-01],
	[1.0840000000E+04, 4.7288486459E+00, 5.6416434727E+00, 2.5726841212E-01, 2.3387916144E-01, 5.5815156727E-01],
	[1.0845000000E+04, 4.7317203319E+00, 5.6410460877E+00, 2.5763999333E-01, 2.3419221911E-01, 5.5830572096E-01],
	[1.0850000000E+04, 4.7345924369E+00, 5.6404490413E+00, 2.5801193925E-01, 2.3450552212E-01, 5.5845985274E-01],
	[1.0855000000E+04, 4.7374649608E+00, 5.6398523331E+00, 2.5838425008E-01, 2.3481907048E-01, 5.5861396261E-01],
	[1.0860000000E+04, 4.7403379035E+00, 5.6392559628E+00, 2.5875692599E-01, 2.3513286419E-01, 5.5876805057E-01],
	[1.0865000000E+04, 4.7432112648E+00, 5.6386599301E+00, 2.5912996719E-01, 2.3544690325E-01, 5.5892211662E-01],
	[1.0870000000E+04, 4.7460850445E+00, 5.6380642345E+00, 2.5950337386E-01, 2.3576118767E-01, 5.5907616078E-01],
	[1.0875000000E+04, 4.7489592427E+00, 5.6374688757E+00, 2.5987714618E-01, 2.3607571744E-01, 5.5923018302E-01],
	[1.0880000000E+04, 4.7518338590E+00, 5.6368738535E+00, 2.6025128436E-01, 2.3639049258E-01, 5.5938418336E-01],
	[1.0885000000E+04, 4.7547088935E+00, 5.6362791673E+00, 2.6062578858E-01, 2.3670551309E-01, 5.5953816180E-01],
	[1.0890000000E+04, 4.7575843459E+00, 5.6356848170E+00, 2.6100065902E-01, 2.3702077896E-01, 5.5969211834E-01],
	[1.0895000000E+04, 4.7604602162E+00, 5.6350908022E+00, 2.6137589588E-01, 2.3733629020E-01, 5.5984605298E-01],
	[1.0900000000E+04, 4.7633365041E+00, 5.6344971224E+00, 2.6175149934E-01, 2.3765204682E-01, 5.5999996572E-01],
	[1.0905000000E+04, 4.7662132097E+00, 5.6339037774E+00, 2.6212746960E-01, 2.3796804881E-01, 5.6015385656E-01],
	[1.0910000000E+04, 4.7690903327E+00, 5.6333107669E+00, 2.6250380684E-01, 2.3828429618E-01, 5.6030772550E-01],
	[1.0915000000E+04, 4.7719678730E+00, 5.6327180904E+00, 2.6288051126E-01, 2.3860078893E-01, 5.6046157255E-01],
	[1.0920000000E+04, 4.7748458304E+00, 5.6321257477E+00, 2.6325758304E-01, 2.3891752706E-01, 5.6061539770E-01],
	[1.0925000000E+04, 4.7777242050E+00, 5.6315337384E+00, 2.6363502238E-01, 2.3923451058E-01, 5.6076920096E-01],
	[1.0930000000E+04, 4.7806029964E+00, 5.6309420622E+00, 2.6401282945E-01, 2.3955173948E-01, 5.6092298233E-01],
	[1.0935000000E+04, 4.7834822046E+00, 5.6303507186E+00, 2.6439100446E-01, 2.3986921376E-01, 5.6107674181E-01],
	[1.0940000000E+04, 4.7863660362E+00, 5.6297685426E+00, 2.6476954758E-01, 2.4018696011E-01, 5.6123047939E-01],
	[1.0945000000E+04, 4.7892503844E+00, 5.6291868966E+00, 2.6514845902E-01, 2.4050495258E-01, 5.6138419509E-01],
	[1.0950000000E+04, 4.7921351523E+00, 5.6286055762E+00, 2.6552773895E-01, 2.4082319056E-01, 5.6153788891E-01],
	[1.0955000000E+04, 4.7950203397E+00, 5.6280245812E+00, 2.6590738758E-01, 2.4114167405E-01, 5.6169156083E-01],
	[1.0960000000E+04, 4.7979059464E+00, 5.6274439112E+00, 2.6628740508E-01, 2.4146040305E-01, 5.6184521088E-01],
	[1.0965000000E+04, 4.8007919724E+00, 5.6268635660E+00, 2.6666779164E-01, 2.4177937757E-01, 5.6199883904E-01],
	[1.0970000000E+04, 4.8036784174E+00, 5.6262835451E+00, 2.6704854747E-01, 2.4209859760E-01, 5.6215244532E-01],
	[1.0975000000E+04, 4.8065652814E+00, 5.6257038483E+00, 2.6742967274E-01, 2.4241806315E-01, 5.6230602972E-01],
	[1.0980000000E+04, 4.8094525642E+00, 5.6251244752E+00, 2.6781116764E-01, 2.4273777421E-01, 5.6245959225E-01],
	[1.0985000000E+04, 4.8123402657E+00, 5.6245454256E+00, 2.6819303237E-01, 2.4305773078E-01, 5.6261313290E-01],
	[1.0990000000E+04, 4.8152283859E+00, 5.6239666989E+00, 2.6857526712E-01, 2.4337793286E-01, 5.6276665167E-01],
	[1.0995000000E+04, 4.8181169244E+00, 5.6233882951E+00, 2.6895787206E-01, 2.4369838046E-01, 5.6292014858E-01],
	[1.1000000000E+04, 4.8210058813E+00, 5.6228102136E+00, 2.6934084740E-01, 2.4401907357E-01, 5.6307362361E-01],
	[1.1005000000E+04, 4.8238952563E+00, 5.6222324543E+00, 2.6972419333E-01, 2.4434001219E-01, 5.6322707677E-01],
	[1.1010000000E+04, 4.8267850494E+00, 5.6216550167E+00, 2.7010791002E-01, 2.4466119632E-01, 5.6338050807E-01],
	[1.1015000000E+04, 4.8296752604E+00, 5.6210779005E+00, 2.7049199768E-01, 2.4498262595E-01, 5.6353391750E-01],
	[1.1020000000E+04, 4.8325658892E+00, 5.6205011055E+00, 2.7087645649E-01, 2.4530430110E-01, 5.6368730507E-01],
	[1.1025000000E+04, 4.8354569357E+00, 5.6199246312E+00, 2.7126128664E-01, 2.4562622175E-01, 5.6384067078E-01],
	[1.1030000000E+04, 4.8383483997E+00, 5.6193484774E+00, 2.7164648831E-01, 2.4594838790E-01, 5.6399401463E-01],
	[1.1035000000E+04, 4.8412402811E+00, 5.6187726438E+00, 2.7203206171E-01, 2.4627079956E-01, 5.6414733662E-01],
	[1.1040000000E+04, 4.8441325798E+00, 5.6181971300E+00, 2.7241800702E-01, 2.4659345671E-01, 5.6430063675E-01],
	[1.1045000000E+04, 4.8470252956E+00, 5.6176219357E+00, 2.7280432442E-01, 2.4691635936E-01, 5.6445391504E-01],
	[1.1050000000E+04, 4.8499184285E+00, 5.6170470605E+00, 2.7319101412E-01, 2.4723950751E-01, 5.6460717147E-01],
	[1.1055000000E+04, 4.8528119782E+00, 5.6164725042E+00, 2.7357807629E-01, 2.4756290115E-01, 5.6476040605E-01],
	[1.1060000000E+04, 4.8557059448E+00, 5.6158982665E+00, 2.7396551112E-01, 2.4788654028E-01, 5.6491361878E-01],
	[1.1065000000E+04, 4.8586003279E+00, 5.6153243469E+00, 2.7435331882E-01, 2.4821042490E-01, 5.6506680967E-01],
	[1.1070000000E+04, 4.8614951276E+00, 5.6147507453E+00, 2.7474149956E-01, 2.4853455500E-01, 5.6521997872E-01],
	[1.1075000000E+04, 4.8643903436E+00, 5.6141774612E+00, 2.7513005354E-01, 2.4885893058E-01, 5.6537312592E-01],
	[1.1080000000E+04, 4.8672859759E+00, 5.6136044944E+00, 2.7551898094E-01, 2.4918355163E-01, 5.6552625129E-01],
	[1.1085000000E+04, 4.8701820243E+00, 5.6130318445E+00, 2.7590828196E-01, 2.4950841816E-01, 5.6567935482E-01],
	[1.1090000000E+04, 4.8730784887E+00, 5.6124595112E+00, 2.7629795678E-01, 2.4983353016E-01, 5.6583243652E-01],
	[1.1095000000E+04, 4.8759753690E+00, 5.6118874943E+00, 2.7668800560E-01, 2.5015888763E-01, 5.6598549638E-01],
	[1.1100000000E+04, 4.8788726650E+00, 5.6113157933E+00, 2.7707842860E-01, 2.5048449055E-01, 5.6613853442E-01],
	[1.1105000000E+04, 4.8817703766E+00, 5.6107444080E+00, 2.7746922598E-01, 2.5081033893E-01, 5.6629155063E-01],
	[1.1110000000E+04, 4.8846685037E+00, 5.6101733380E+00, 2.7786039792E-01, 2.5113643277E-01, 5.6644454501E-01],
	[1.1115000000E+04, 4.8875704909E+00, 5.6096093226E+00, 2.7825194461E-01, 2.5146279471E-01, 5.6659751758E-01],
	[1.1120000000E+04, 4.8904739289E+00, 5.6090476372E+00, 2.7864386625E-01, 2.5178940900E-01, 5.6675046832E-01],
	[1.1125000000E+04, 4.8933777852E+00, 5.6084862605E+00, 2.7903616302E-01, 2.5211626886E-01, 5.6690339725E-01],
	[1.1130000000E+04, 4.8962820599E+00, 5.6079251922E+00, 2.7942883511E-01, 2.5244337428E-01, 5.6705630436E-01],
	[1.1135000000E+04, 4.8991867527E+00, 5.6073644320E+00, 2.7982188272E-01, 2.5277072526E-01, 5.6720918966E-01],
	[1.1140000000E+04, 4.9020918635E+00, 5.6068039796E+00, 2.8021530602E-01, 2.5309832179E-01, 5.6736205315E-01],
	[1.1145000000E+04, 4.9049973922E+00, 5.6062438346E+00, 2.8060910522E-01, 2.5342616387E-01, 5.6751489484E-01],
	[1.1150000000E+04, 4.9079033386E+00, 5.6056839968E+00, 2.8100328050E-01, 2.5375425149E-01, 5.6766771472E-01],
	[1.1155000000E+04, 4.9108097027E+00, 5.6051244659E+00, 2.8139783205E-01, 2.5408258464E-01, 5.6782051280E-01],
	[1.1160000000E+04, 4.9137164844E+00, 5.6045652415E+00, 2.8179276006E-01, 2.5441116333E-01, 5.6797328908E-01],
	[1.1165000000E+04, 4.9166236833E+00, 5.6040063234E+00, 2.8218806472E-01, 2.5473998753E-01, 5.6812604357E-01],
	[1.1170000000E+04, 4.9195312996E+00, 5.6034477112E+00, 2.8258374622E-01, 2.5506905726E-01, 5.6827877626E-01],
	[1.1175000000E+04, 4.9224393330E+00, 5.6028894046E+00, 2.8297980475E-01, 2.5539837249E-01, 5.6843148717E-01],
	[1.1180000000E+04, 4.9253477833E+00, 5.6023314034E+00, 2.8337624050E-01, 2.5572793323E-01, 5.6858417628E-01],
	[1.1185000000E+04, 4.9282566506E+00, 5.6017737072E+00, 2.8377550827E-01, 2.5605973801E-01, 5.6873684361E-01],
	[1.1190000000E+04, 4.9311659346E+00, 5.6012163158E+00, 2.8417531630E-01, 2.5639191981E-01, 5.6888948916E-01],
	[1.1195000000E+04, 4.9340756352E+00, 5.6006592288E+00, 2.8457550830E-01, 2.5672435117E-01, 5.6904211294E-01],
	[1.1200000000E+04, 4.9369857523E+00, 5.6001024459E+00, 2.8497608447E-01, 2.5705703209E-01, 5.6919471493E-01],
	[1.1205000000E+04, 4.9398962858E+00, 5.5995459668E+00, 2.8537704499E-01, 2.5738996256E-01, 5.6934729515E-01],
	[1.1210000000E+04, 4.9428072355E+00, 5.5989897912E+00, 2.8577839008E-01, 2.5772314258E-01, 5.6949985361E-01],
	[1.1215000000E+04, 4.9457186013E+00, 5.5984339189E+00, 2.8618011991E-01, 2.5805657214E-01, 5.6965239029E-01],
	[1.1220000000E+04, 4.9486303832E+00, 5.5978783495E+00, 2.8658223470E-01, 2.5839025123E-01, 5.6980490522E-01],
	[1.1225000000E+04, 4.9515425808E+00, 5.5973230827E+00, 2.8698473464E-01, 2.5872417985E-01, 5.6995739838E-01],
	[1.1230000000E+04, 4.9544551943E+00, 5.5967681182E+00, 2.8738761992E-01, 2.5905835799E-01, 5.7010986978E-01],
	[1.1235000000E+04, 4.9573682233E+00, 5.5962134558E+00, 2.8779089074E-01, 2.5939278564E-01, 5.7026231944E-01],
	[1.1240000000E+04, 4.9602816678E+00, 5.5956590950E+00, 2.8819454729E-01, 2.5972746279E-01, 5.7041474734E-01],
	[1.1245000000E+04, 4.9631955277E+00, 5.5951050357E+00, 2.8859858978E-01, 2.6006238944E-01, 5.7056715349E-01],
	[1.1250000000E+04, 4.9661098028E+00, 5.5945512776E+00, 2.8900301841E-01, 2.6039756558E-01, 5.7071953789E-01],
	[1.1255000000E+04, 4.9690244931E+00, 5.5939978202E+00, 2.8940783336E-01, 2.6073299120E-01, 5.7087190056E-01],
	[1.1260000000E+04, 4.9719395983E+00, 5.5934446634E+00, 2.8981303483E-01, 2.6106866630E-01, 5.7102424149E-01],
	[1.1265000000E+04, 4.9748551183E+00, 5.5928918068E+00, 2.9021862302E-01, 2.6140459086E-01, 5.7117656068E-01],
	[1.1270000000E+04, 4.9777710532E+00, 5.5923392502E+00, 2.9062459813E-01, 2.6174076488E-01, 5.7132885814E-01],
	[1.1275000000E+04, 4.9806874026E+00, 5.5917869932E+00, 2.9103096035E-01, 2.6207718835E-01, 5.7148113388E-01],
	[1.1280000000E+04, 4.9836041665E+00, 5.5912350356E+00, 2.9143770989E-01, 2.6241386125E-01, 5.7163338789E-01],
	[1.1285000000E+04, 4.9865213447E+00, 5.5906833770E+00, 2.9184484693E-01, 2.6275078359E-01, 5.7178562018E-01],
	[1.1290000000E+04, 4.9894389372E+00, 5.5901320172E+00, 2.9225237168E-01, 2.6308795535E-01, 5.7193783075E-01],
	[1.1295000000E+04, 4.9923615717E+00, 5.5895893964E+00, 2.9266028432E-01, 2.6342540815E-01, 5.7209001956E-01],
	[1.1300000000E+04, 4.9952846493E+00, 5.5890471153E+00, 2.9306858507E-01, 2.6376311067E-01, 5.7224218661E-01],
	[1.1305000000E+04, 4.9982081440E+00, 5.5885051266E+00, 2.9347727411E-01, 2.6410106271E-01, 5.7239433187E-01],
	[1.1310000000E+04, 5.0011320560E+00, 5.5879634301E+00, 2.9388635164E-01, 2.6443926428E-01, 5.7254645534E-01],
	[1.1315000000E+04, 5.0040563849E+00, 5.5874220255E+00, 2.9429581785E-01, 2.6477771537E-01, 5.7269855701E-01],
	[1.1320000000E+04, 5.0069811306E+00, 5.5868809125E+00, 2.9470567296E-01, 2.6511641595E-01, 5.7285063686E-01],
	[1.1325000000E+04, 5.0099062932E+00, 5.5863400909E+00, 2.9511591714E-01, 2.6545536603E-01, 5.7300269489E-01],
	[1.1330000000E+04, 5.0128318723E+00, 5.5857995603E+00, 2.9552655060E-01, 2.6579456558E-01, 5.7315473110E-01],
	[1.1335000000E+04, 5.0157578679E+00, 5.5852593204E+00, 2.9593757354E-01, 2.6613401461E-01, 5.7330674546E-01],
	[1.1340000000E+04, 5.0186842799E+00, 5.5847193710E+00, 2.9634898615E-01, 2.6647371310E-01, 5.7345873797E-01],
	[1.1345000000E+04, 5.0216111082E+00, 5.5841797118E+00, 2.9676078863E-01, 2.6681366104E-01, 5.7361070862E-01],
	[1.1350000000E+04, 5.0245383526E+00, 5.5836403425E+00, 2.9717298117E-01, 2.6715385841E-01, 5.7376265740E-01],
	[1.1355000000E+04, 5.0274660129E+00, 5.5831012628E+00, 2.9758556398E-01, 2.6749430522E-01, 5.7391458430E-01],
	[1.1360000000E+04, 5.0303940892E+00, 5.5825624725E+00, 2.9799853725E-01, 2.6783500144E-01, 5.7406648932E-01],
	[1.1365000000E+04, 5.0333225812E+00, 5.5820239712E+00, 2.9841190117E-01, 2.6817594707E-01, 5.7421837243E-01],
	[1.1370000000E+04, 5.0362514888E+00, 5.5814857586E+00, 2.9882565595E-01, 2.6851714209E-01, 5.7437023365E-01],
	[1.1375000000E+04, 5.0391808119E+00, 5.5809478346E+00, 2.9923980177E-01, 2.6885858649E-01, 5.7452207294E-01],
	[1.1380000000E+04, 5.0421105504E+00, 5.5804101988E+00, 2.9965433885E-01, 2.6920028026E-01, 5.7467389031E-01],
	[1.1385000000E+04, 5.0450407042E+00, 5.5798728509E+00, 3.0006926737E-01, 2.6954222339E-01, 5.7482568575E-01],
	[1.1390000000E+04, 5.0479712731E+00, 5.5793357906E+00, 3.0048458753E-01, 2.6988441586E-01, 5.7497745924E-01],
	[1.1395000000E+04, 5.0509022570E+00, 5.5787990177E+00, 3.0090029953E-01, 2.7022685766E-01, 5.7512921078E-01],
	[1.1400000000E+04, 5.0538336558E+00, 5.5782625319E+00, 3.0131640356E-01, 2.7056954879E-01, 5.7528094036E-01],
	[1.1405000000E+04, 5.0567654693E+00, 5.5777263329E+00, 3.0173289983E-01, 2.7091248922E-01, 5.7543264797E-01],
	[1.1410000000E+04, 5.0596976975E+00, 5.5771904204E+00, 3.0214978852E-01, 2.7125567895E-01, 5.7558433360E-01],
	[1.1415000000E+04, 5.0626303402E+00, 5.5766547942E+00, 3.0256706984E-01, 2.7159911795E-01, 5.7573599724E-01],
	[1.1420000000E+04, 5.0655633973E+00, 5.5761194539E+00, 3.0298474399E-01, 2.7194280622E-01, 5.7588763888E-01],
	[1.1425000000E+04, 5.0684968687E+00, 5.5755843994E+00, 3.0340281116E-01, 2.7228674375E-01, 5.7603925852E-01],
	[1.1430000000E+04, 5.0714307542E+00, 5.5750496302E+00, 3.0382127154E-01, 2.7263093051E-01, 5.7619085614E-01],
	[1.1435000000E+04, 5.0743650537E+00, 5.5745151462E+00, 3.0424012534E-01, 2.7297536650E-01, 5.7634243174E-01],
	[1.1440000000E+04, 5.0772997671E+00, 5.5739809470E+00, 3.0465937275E-01, 2.7332005170E-01, 5.7649398531E-01],
	[1.1445000000E+04, 5.0802348943E+00, 5.5734470325E+00, 3.0507901397E-01, 2.7366498610E-01, 5.7664551683E-01],
	[1.1450000000E+04, 5.0831704352E+00, 5.5729134022E+00, 3.0549904919E-01, 2.7401016968E-01, 5.7679702631E-01],
	[1.1455000000E+04, 5.0861063896E+00, 5.5723800560E+00, 3.0591947862E-01, 2.7435560243E-01, 5.7694851373E-01],
	[1.1460000000E+04, 5.0890427574E+00, 5.5718469936E+00, 3.0634030245E-01, 2.7470128433E-01, 5.7709997907E-01],
	[1.1465000000E+04, 5.0919795385E+00, 5.5713142146E+00, 3.0676152088E-01, 2.7504721537E-01, 5.7725142235E-01],
	[1.1470000000E+04, 5.0949167328E+00, 5.5707817188E+00, 3.0718313410E-01, 2.7539339553E-01, 5.7740284354E-01],
	[1.1475000000E+04, 5.0978574494E+00, 5.5702547997E+00, 3.0760514231E-01, 2.7573984687E-01, 5.7755424263E-01],
	[1.1480000000E+04, 5.1008003032E+00, 5.5697310895E+00, 3.0802754571E-01, 2.7608655963E-01, 5.7770561963E-01],
	[1.1485000000E+04, 5.1037435732E+00, 5.5692076567E+00, 3.0845034450E-01, 2.7643352162E-01, 5.7785697452E-01],
	[1.1490000000E+04, 5.1066872594E+00, 5.5686845008E+00, 3.0887353887E-01, 2.7678073281E-01, 5.7800830728E-01],
	[1.1495000000E+04, 5.1096313616E+00, 5.5681616216E+00, 3.0929712902E-01, 2.7712819319E-01, 5.7815961792E-01],
	[1.1500000000E+04, 5.1125758797E+00, 5.5676390189E+00, 3.0972111515E-01, 2.7747590275E-01, 5.7831090643E-01],
	[1.1505000000E+04, 5.1155208135E+00, 5.5671166924E+00, 3.1014549746E-01, 2.7782386146E-01, 5.7846217279E-01],
	[1.1510000000E+04, 5.1184661631E+00, 5.5665946418E+00, 3.1057027613E-01, 2.7817206931E-01, 5.7861341700E-01],
	[1.1515000000E+04, 5.1214119281E+00, 5.5660728669E+00, 3.1099545138E-01, 2.7852052629E-01, 5.7876463906E-01],
	[1.1520000000E+04, 5.1243581086E+00, 5.5655513673E+00, 3.1142102340E-01, 2.7886923238E-01, 5.7891583894E-01],
	[1.1525000000E+04, 5.1273047044E+00, 5.5650301429E+00, 3.1184699237E-01, 2.7921818755E-01, 5.7906701665E-01],
	[1.1530000000E+04, 5.1302517153E+00, 5.5645091933E+00, 3.1227335851E-01, 2.7956739181E-01, 5.7921817217E-01],
	[1.1535000000E+04, 5.1331991413E+00, 5.5639885184E+00, 3.1270012201E-01, 2.7991684511E-01, 5.7936930550E-01],
	[1.1540000000E+04, 5.1361469822E+00, 5.5634681177E+00, 3.1312728307E-01, 2.8026654746E-01, 5.7952041664E-01],
	[1.1545000000E+04, 5.1390952379E+00, 5.5629479911E+00, 3.1355484188E-01, 2.8061649883E-01, 5.7967150556E-01],
	[1.1550000000E+04, 5.1420439083E+00, 5.5624281384E+00, 3.1398279864E-01, 2.8096669920E-01, 5.7982257226E-01],
	[1.1555000000E+04, 5.1449929933E+00, 5.5619085592E+00, 3.1441115355E-01, 2.8131714856E-01, 5.7997361675E-01],
	[1.1560000000E+04, 5.1479424927E+00, 5.5613892532E+00, 3.1483990680E-01, 2.8166784689E-01, 5.8012463900E-01],
	[1.1565000000E+04, 5.1508924064E+00, 5.5608702203E+00, 3.1526905860E-01, 2.8201879417E-01, 5.8027563901E-01],
	[1.1570000000E+04, 5.1538427343E+00, 5.5603514602E+00, 3.1569860914E-01, 2.8236999038E-01, 5.8042661677E-01],
	[1.1575000000E+04, 5.1567934763E+00, 5.5598329725E+00, 3.1612855861E-01, 2.8272143550E-01, 5.8057757228E-01],
	[1.1580000000E+04, 5.1597446323E+00, 5.5593147571E+00, 3.1655890723E-01, 2.8307312951E-01, 5.8072850552E-01],
	[1.1585000000E+04, 5.1626962021E+00, 5.5587968136E+00, 3.1698965517E-01, 2.8342507240E-01, 5.8087941649E-01],
	[1.1590000000E+04, 5.1656481856E+00, 5.5582791419E+00, 3.1742080265E-01, 2.8377726415E-01, 5.8103030518E-01],
	[1.1595000000E+04, 5.1686005827E+00, 5.5577617416E+00, 3.1785234985E-01, 2.8412970473E-01, 5.8118117159E-01],
	[1.1600000000E+04, 5.1715533933E+00, 5.5572446125E+00, 3.1828429698E-01, 2.8448239413E-01, 5.8133201570E-01],
	[1.1605000000E+04, 5.1745066172E+00, 5.5567277544E+00, 3.1871664423E-01, 2.8483533232E-01, 5.8148283751E-01],
	[1.1610000000E+04, 5.1774602544E+00, 5.5562111669E+00, 3.1914939180E-01, 2.8518851929E-01, 5.8163363701E-01],
	[1.1615000000E+04, 5.1804143047E+00, 5.5556948499E+00, 3.1958253989E-01, 2.8554195502E-01, 5.8178441420E-01],
	[1.1620000000E+04, 5.1833687680E+00, 5.5551788030E+00, 3.2001608869E-01, 2.8589563949E-01, 5.8193516906E-01],
	[1.1625000000E+04, 5.1863236441E+00, 5.5546630261E+00, 3.2045003841E-01, 2.8624957267E-01, 5.8208590158E-01],
	[1.1630000000E+04, 5.1892789330E+00, 5.5541475187E+00, 3.2088438924E-01, 2.8660375455E-01, 5.8223661177E-01],
	[1.1635000000E+04, 5.1922346346E+00, 5.5536322808E+00, 3.2131914137E-01, 2.8695818510E-01, 5.8238729961E-01],
	[1.1640000000E+04, 5.1951907486E+00, 5.5531173120E+00, 3.2175429501E-01, 2.8731286430E-01, 5.8253796510E-01],
	[1.1645000000E+04, 5.1981472751E+00, 5.5526026121E+00, 3.2218985036E-01, 2.8766779214E-01, 5.8268860822E-01],
	[1.1650000000E+04, 5.2011042138E+00, 5.5520881808E+00, 3.2262580760E-01, 2.8802296859E-01, 5.8283922898E-01],
	[1.1655000000E+04, 5.2040615647E+00, 5.5515740179E+00, 3.2306216695E-01, 2.8837839363E-01, 5.8298982736E-01],
	[1.1660000000E+04, 5.2070228732E+00, 5.5510657612E+00, 3.2349892859E-01, 2.8873409339E-01, 5.8314040335E-01],
	[1.1665000000E+04, 5.2099860614E+00, 5.5505600976E+00, 3.2393609272E-01, 2.8909005264E-01, 5.8329095696E-01],
	[1.1670000000E+04, 5.2129496650E+00, 5.5500546966E+00, 3.2437365954E-01, 2.8944626056E-01, 5.8344148817E-01],
	[1.1675000000E+04, 5.2159136838E+00, 5.5495495582E+00, 3.2481162926E-01, 2.8980271714E-01, 5.8359199697E-01],
	[1.1680000000E+04, 5.2188781177E+00, 5.5490446820E+00, 3.2525000206E-01, 2.9015942235E-01, 5.8374248336E-01],
	[1.1685000000E+04, 5.2218429666E+00, 5.5485400677E+00, 3.2568877814E-01, 2.9051637617E-01, 5.8389294733E-01],
	[1.1690000000E+04, 5.2248082304E+00, 5.5480357152E+00, 3.2612795771E-01, 2.9087357859E-01, 5.8404338888E-01],
	[1.1695000000E+04, 5.2277739089E+00, 5.5475316242E+00, 3.2656754095E-01, 2.9123102956E-01, 5.8419380799E-01],
	[1.1700000000E+04, 5.2307400020E+00, 5.5470277944E+00, 3.2700752808E-01, 2.9158872909E-01, 5.8434420466E-01],
	[1.1705000000E+04, 5.2337065096E+00, 5.5465242256E+00, 3.2744791928E-01, 2.9194667713E-01, 5.8449457889E-01],
	[1.1710000000E+04, 5.2366734317E+00, 5.5460209176E+00, 3.2788871475E-01, 2.9230487367E-01, 5.8464493066E-01],
	[1.1715000000E+04, 5.2396407680E+00, 5.5455178701E+00, 3.2832991469E-01, 2.9266331868E-01, 5.8479525997E-01],
	[1.1720000000E+04, 5.2426085184E+00, 5.5450150828E+00, 3.2877151930E-01, 2.9302201214E-01, 5.8494556681E-01],
	[1.1725000000E+04, 5.2455766829E+00, 5.5445125555E+00, 3.2921352878E-01, 2.9338095403E-01, 5.8509585118E-01],
	[1.1730000000E+04, 5.2485452613E+00, 5.5440102880E+00, 3.2965594332E-01, 2.9374014433E-01, 5.8524611306E-01],
	[1.1735000000E+04, 5.2515142535E+00, 5.5435082801E+00, 3.3009876312E-01, 2.9409958300E-01, 5.8539635246E-01],
	[1.1740000000E+04, 5.2544836594E+00, 5.5430065314E+00, 3.3054198838E-01, 2.9445927003E-01, 5.8554656936E-01],
	[1.1745000000E+04, 5.2574534788E+00, 5.5425050417E+00, 3.3098561930E-01, 2.9481920538E-01, 5.8569676376E-01],
	[1.1750000000E+04, 5.2604237117E+00, 5.5420038108E+00, 3.3142965608E-01, 2.9517938905E-01, 5.8584693566E-01],
	[1.1755000000E+04, 5.2633943579E+00, 5.5415028385E+00, 3.3187409891E-01, 2.9553982099E-01, 5.8599708503E-01],
	[1.1760000000E+04, 5.2663654173E+00, 5.5410021244E+00, 3.3231894798E-01, 2.9590050119E-01, 5.8614721189E-01],
	[1.1765000000E+04, 5.2693368898E+00, 5.5405016684E+00, 3.3276420351E-01, 2.9626142963E-01, 5.8629731622E-01],
	[1.1770000000E+04, 5.2723087753E+00, 5.5400014703E+00, 3.3320986569E-01, 2.9662260626E-01, 5.8644739801E-01],
	[1.1775000000E+04, 5.2752810736E+00, 5.5395015297E+00, 3.3365593470E-01, 2.9698403108E-01, 5.8659745727E-01],
	[1.1780000000E+04, 5.2782537846E+00, 5.5390018464E+00, 3.3410241077E-01, 2.9734570405E-01, 5.8674749397E-01],
	[1.1785000000E+04, 5.2812269082E+00, 5.5385024202E+00, 3.3454929407E-01, 2.9770762516E-01, 5.8689750812E-01],
	[1.1790000000E+04, 5.2842004444E+00, 5.5380032509E+00, 3.3499658481E-01, 2.9806979436E-01, 5.8704749971E-01],
	[1.1795000000E+04, 5.2871743929E+00, 5.5375043382E+00, 3.3544428318E-01, 2.9843221164E-01, 5.8719746874E-01],
	[1.1800000000E+04, 5.2901487537E+00, 5.5370056818E+00, 3.3589238940E-01, 2.9879487697E-01, 5.8734741519E-01],
	[1.1805000000E+04, 5.2931235266E+00, 5.5365072816E+00, 3.3634090364E-01, 2.9915779033E-01, 5.8749733906E-01],
	[1.1810000000E+04, 5.2960987116E+00, 5.5360091373E+00, 3.3678982611E-01, 2.9952095168E-01, 5.8764724035E-01],
	[1.1815000000E+04, 5.2990743084E+00, 5.5355112486E+00, 3.3723915701E-01, 2.9988436101E-01, 5.8779711904E-01],
	[1.1820000000E+04, 5.3020503170E+00, 5.5350136153E+00, 3.3768889654E-01, 3.0024801828E-01, 5.8794697513E-01],
	[1.1825000000E+04, 5.3050267374E+00, 5.5345162372E+00, 3.3813904489E-01, 3.0061192346E-01, 5.8809680863E-01],
	[1.1830000000E+04, 5.3080035692E+00, 5.5340191140E+00, 3.3858960227E-01, 3.0097607653E-01, 5.8824661951E-01],
	[1.1835000000E+04, 5.3109808125E+00, 5.5335222455E+00, 3.3904056886E-01, 3.0134047746E-01, 5.8839640777E-01],
	[1.1840000000E+04, 5.3139584672E+00, 5.5330256314E+00, 3.3949194487E-01, 3.0170512623E-01, 5.8854617341E-01],
	[1.1845000000E+04, 5.3169374519E+00, 5.5325306381E+00, 3.3994373050E-01, 3.0207002984E-01, 5.8869591642E-01],
	[1.1850000000E+04, 5.3199211218E+00, 5.5320422487E+00, 3.4039592594E-01, 3.0243521405E-01, 5.8884563680E-01],
	[1.1855000000E+04, 5.3229052064E+00, 5.5315541085E+00, 3.4084853140E-01, 3.0280064617E-01, 5.8899533454E-01],
	[1.1860000000E+04, 5.3258897054E+00, 5.5310662172E+00, 3.4130154706E-01, 3.0316632617E-01, 5.8914500963E-01],
	[1.1865000000E+04, 5.3288746188E+00, 5.5305785745E+00, 3.4175497314E-01, 3.0353225403E-01, 5.8929466206E-01],
	[1.1870000000E+04, 5.3318599464E+00, 5.5300911803E+00, 3.4220880982E-01, 3.0389842971E-01, 5.8944429184E-01],
	[1.1875000000E+04, 5.3348456882E+00, 5.5296040342E+00, 3.4266305731E-01, 3.0426485319E-01, 5.8959389896E-01],
	[1.1880000000E+04, 5.3378318439E+00, 5.5291171361E+00, 3.4311771580E-01, 3.0463152443E-01, 5.8974348340E-01],
	[1.1885000000E+04, 5.3408184136E+00, 5.5286304857E+00, 3.4357278549E-01, 3.0499844341E-01, 5.8989304517E-01],
	[1.1890000000E+04, 5.3438053970E+00, 5.5281440828E+00, 3.4402826658E-01, 3.0536561011E-01, 5.9004258425E-01],
	[1.1895000000E+04, 5.3467927942E+00, 5.5276579271E+00, 3.4448415926E-01, 3.0573302448E-01, 5.9019210065E-01],
	[1.1900000000E+04, 5.3497806048E+00, 5.5271720186E+00, 3.4494046375E-01, 3.0610068651E-01, 5.9034159435E-01],
	[1.1905000000E+04, 5.3527688289E+00, 5.5266863568E+00, 3.4539718023E-01, 3.0646859615E-01, 5.9049106534E-01],
	[1.1910000000E+04, 5.3557574663E+00, 5.5262009416E+00, 3.4585430889E-01, 3.0683675339E-01, 5.9064051358E-01],
	[1.1915000000E+04, 5.3587465169E+00, 5.5257157727E+00, 3.4631184995E-01, 3.0720515818E-01, 5.9078993906E-01],
	[1.1920000000E+04, 5.3617359806E+00, 5.5252308500E+00, 3.4676980360E-01, 3.0757381051E-01, 5.9093934177E-01],
	[1.1925000000E+04, 5.3647258573E+00, 5.5247461731E+00, 3.4722817004E-01, 3.0794271034E-01, 5.9108872169E-01],
	[1.1930000000E+04, 5.3677161468E+00, 5.5242617420E+00, 3.4768694946E-01, 3.0831185764E-01, 5.9123807880E-01],
	[1.1935000000E+04, 5.3707068490E+00, 5.5237775562E+00, 3.4814614206E-01, 3.0868125237E-01, 5.9138741309E-01],
	[1.1940000000E+04, 5.3736979638E+00, 5.5232936157E+00, 3.4860574805E-01, 3.0905089452E-01, 5.9153672456E-01],
	[1.1945000000E+04, 5.3766894912E+00, 5.5228099201E+00, 3.4906576761E-01, 3.0942078404E-01, 5.9168601317E-01],
	[1.1950000000E+04, 5.3796814309E+00, 5.5223264694E+00, 3.4952620095E-01, 3.0979092091E-01, 5.9183527892E-01],
	[1.1955000000E+04, 5.3826737829E+00, 5.5218432631E+00, 3.4998704827E-01, 3.1016130509E-01, 5.9198452179E-01],
	[1.1960000000E+04, 5.3856665471E+00, 5.5213603012E+00, 3.5044830977E-01, 3.1053193655E-01, 5.9213374177E-01],
	[1.1965000000E+04, 5.3886597233E+00, 5.5208775833E+00, 3.5090998564E-01, 3.1090281527E-01, 5.9228293884E-01],
	[1.1970000000E+04, 5.3916533114E+00, 5.5203951093E+00, 3.5137207607E-01, 3.1127394120E-01, 5.9243211299E-01],
	[1.1975000000E+04, 5.3946473113E+00, 5.5199128789E+00, 3.5183458128E-01, 3.1164531432E-01, 5.9258126420E-01],
	[1.1980000000E+04, 5.3976417230E+00, 5.5194308919E+00, 3.5229750146E-01, 3.1201693459E-01, 5.9273039246E-01],
	[1.1985000000E+04, 5.4006365461E+00, 5.5189491481E+00, 3.5276083681E-01, 3.1238880198E-01, 5.9287949775E-01],
	[1.1990000000E+04, 5.4036317808E+00, 5.5184676473E+00, 3.5322458751E-01, 3.1276091646E-01, 5.9302858007E-01],
	[1.1995000000E+04, 5.4066274268E+00, 5.5179863892E+00, 3.5368875379E-01, 3.1313327800E-01, 5.9317763939E-01],
	[1.2000000000E+04, 5.4096234840E+00, 5.5175053736E+00, 3.5415333582E-01, 3.1350588656E-01, 5.9332667570E-01],
	[1.2005000000E+04, 5.4126199524E+00, 5.5170246003E+00, 3.5461833382E-01, 3.1387874211E-01, 5.9347568898E-01],
	[1.2010000000E+04, 5.4156168317E+00, 5.5165440690E+00, 3.5508374797E-01, 3.1425184462E-01, 5.9362467923E-01],
	[1.2015000000E+04, 5.4186141220E+00, 5.5160637796E+00, 3.5554957848E-01, 3.1462519405E-01, 5.9377364643E-01],
	[1.2020000000E+04, 5.4216118230E+00, 5.5155837318E+00, 3.5601582554E-01, 3.1499879036E-01, 5.9392259056E-01],
	[1.2025000000E+04, 5.4246099347E+00, 5.5151039255E+00, 3.5648248936E-01, 3.1537263354E-01, 5.9407151161E-01],
	[1.2030000000E+04, 5.4276084569E+00, 5.5146243602E+00, 3.5694957014E-01, 3.1574672353E-01, 5.9422040957E-01],
	[1.2035000000E+04, 5.4306076163E+00, 5.5141453515E+00, 3.5741706806E-01, 3.1612106211E-01, 5.9436928441E-01],
	[1.2040000000E+04, 5.4336123352E+00, 5.5136737427E+00, 3.5788498333E-01, 3.1649568851E-01, 5.9451813614E-01],
	[1.2045000000E+04, 5.4366174680E+00, 5.5132023701E+00, 3.5835331615E-01, 3.1687056180E-01, 5.9466696472E-01],
	[1.2050000000E+04, 5.4396230147E+00, 5.5127312334E+00, 3.5882206672E-01, 3.1724568194E-01, 5.9481577016E-01],
	[1.2055000000E+04, 5.4426289750E+00, 5.5122603324E+00, 3.5929123524E-01, 3.1762104889E-01, 5.9496455243E-01],
	[1.2060000000E+04, 5.4456353489E+00, 5.5117896669E+00, 3.5976082189E-01, 3.1799666263E-01, 5.9511331152E-01],
	[1.2065000000E+04, 5.4486421362E+00, 5.5113192366E+00, 3.6023082689E-01, 3.1837252312E-01, 5.9526204742E-01],
	[1.2070000000E+04, 5.4516493369E+00, 5.5108490414E+00, 3.6070125043E-01, 3.1874863032E-01, 5.9541076011E-01],
	[1.2075000000E+04, 5.4546569508E+00, 5.5103790809E+00, 3.6117209271E-01, 3.1912498419E-01, 5.9555944958E-01],
	[1.2080000000E+04, 5.4576649778E+00, 5.5099093551E+00, 3.6164335393E-01, 3.1950158471E-01, 5.9570811581E-01],
	[1.2085000000E+04, 5.4606734178E+00, 5.5094398637E+00, 3.6211503428E-01, 3.1987843183E-01, 5.9585675880E-01],
	[1.2090000000E+04, 5.4636822706E+00, 5.5089706065E+00, 3.6258713397E-01, 3.2025552552E-01, 5.9600537853E-01],
	[1.2095000000E+04, 5.4666915362E+00, 5.5085015833E+00, 3.6305965319E-01, 3.2063286574E-01, 5.9615397497E-01],
	[1.2100000000E+04, 5.4697012145E+00, 5.5080327938E+00, 3.6353259215E-01, 3.2101045247E-01, 5.9630254813E-01],
	[1.2105000000E+04, 5.4727113053E+00, 5.5075642379E+00, 3.6400595104E-01, 3.2138828565E-01, 5.9645109799E-01],
	[1.2110000000E+04, 5.4757218086E+00, 5.5070959153E+00, 3.6447973005E-01, 3.2176636525E-01, 5.9659962453E-01],
	[1.2115000000E+04, 5.4787327241E+00, 5.5066278258E+00, 3.6495392940E-01, 3.2214469125E-01, 5.9674812774E-01],
	[1.2120000000E+04, 5.4817440518E+00, 5.5061599692E+00, 3.6542854927E-01, 3.2252326359E-01, 5.9689660761E-01],
	[1.2125000000E+04, 5.4847557916E+00, 5.5056923453E+00, 3.6590358987E-01, 3.2290208225E-01, 5.9704506412E-01],
	[1.2130000000E+04, 5.4877679434E+00, 5.5052249539E+00, 3.6637905139E-01, 3.2328114718E-01, 5.9719349725E-01],
	[1.2135000000E+04, 5.4907805070E+00, 5.5047577948E+00, 3.6685493404E-01, 3.2366045835E-01, 5.9734190701E-01],
	[1.2140000000E+04, 5.4937934824E+00, 5.5042908677E+00, 3.6733123801E-01, 3.2404001572E-01, 5.9749029336E-01],
	[1.2145000000E+04, 5.4968068694E+00, 5.5038241725E+00, 3.6780796350E-01, 3.2441981926E-01, 5.9763865631E-01],
	[1.2150000000E+04, 5.4998206679E+00, 5.5033577089E+00, 3.6828511071E-01, 3.2479986892E-01, 5.9778699583E-01],
	[1.2155000000E+04, 5.5028348778E+00, 5.5028914768E+00, 3.6876267983E-01, 3.2518016466E-01, 5.9793531191E-01],
	[1.2160000000E+04, 5.5058494990E+00, 5.5024254759E+00, 3.6924067108E-01, 3.2556070646E-01, 5.9808360455E-01],
	[1.2165000000E+04, 5.5088645314E+00, 5.5019597060E+00, 3.6971908464E-01, 3.2594149426E-01, 5.9823187372E-01],
	[1.2170000000E+04, 5.5118799748E+00, 5.5014941669E+00, 3.7019792071E-01, 3.2632252804E-01, 5.9838011941E-01],
	[1.2175000000E+04, 5.5148958292E+00, 5.5010288583E+00, 3.7067717950E-01, 3.2670380774E-01, 5.9852834161E-01],
	[1.2180000000E+04, 5.5179120944E+00, 5.5005637802E+00, 3.7115686120E-01, 3.2708533334E-01, 5.9867654031E-01],
	[1.2185000000E+04, 5.5209287703E+00, 5.5000989322E+00, 3.7163696602E-01, 3.2746710480E-01, 5.9882471549E-01],
	[1.2190000000E+04, 5.5239458568E+00, 5.4996343143E+00, 3.7211749414E-01, 3.2784912207E-01, 5.9897286714E-01],
	[1.2195000000E+04, 5.5269633539E+00, 5.4991699260E+00, 3.7259844577E-01, 3.2823138511E-01, 5.9912099525E-01],
	[1.2200000000E+04, 5.5299812613E+00, 5.4987057673E+00, 3.7307982111E-01, 3.2861389389E-01, 5.9926909980E-01],
	[1.2205000000E+04, 5.5329995790E+00, 5.4982418380E+00, 3.7356162035E-01, 3.2899664836E-01, 5.9941718079E-01],
	[1.2210000000E+04, 5.5360183068E+00, 5.4977781378E+00, 3.7404384371E-01, 3.2937964849E-01, 5.9956523819E-01],
	[1.2215000000E+04, 5.5390374447E+00, 5.4973146665E+00, 3.7452649136E-01, 3.2976289423E-01, 5.9971327200E-01],
	[1.2220000000E+04, 5.5420569926E+00, 5.4968514240E+00, 3.7500956352E-01, 3.3014638555E-01, 5.9986128220E-01],
	[1.2225000000E+04, 5.5450769502E+00, 5.4963884099E+00, 3.7549306038E-01, 3.3053012240E-01, 6.0000926879E-01],
	[1.2230000000E+04, 5.5480989492E+00, 5.4959277491E+00, 3.7597698215E-01, 3.3091411825E-01, 6.0015723174E-01],
	[1.2235000000E+04, 5.5511252885E+00, 5.4954724297E+00, 3.7646132901E-01, 3.3129839219E-01, 6.0030517104E-01],
	[1.2240000000E+04, 5.5541520412E+00, 5.4950173340E+00, 3.7694610117E-01, 3.3168291171E-01, 6.0045308669E-01],
	[1.2245000000E+04, 5.5571792070E+00, 5.4945624619E+00, 3.7743129883E-01, 3.3206767679E-01, 6.0060097867E-01],
	[1.2250000000E+04, 5.5602067859E+00, 5.4941078131E+00, 3.7791692219E-01, 3.3245268737E-01, 6.0074884696E-01],
	[1.2255000000E+04, 5.5632347776E+00, 5.4936533874E+00, 3.7840297144E-01, 3.3283794342E-01, 6.0089669156E-01],
	[1.2260000000E+04, 5.5662631823E+00, 5.4931991847E+00, 3.7888944679E-01, 3.3322344489E-01, 6.0104451245E-01],
	[1.2265000000E+04, 5.5692919996E+00, 5.4927452047E+00, 3.7937634844E-01, 3.3360919174E-01, 6.0119230962E-01],
	[1.2270000000E+04, 5.5723212295E+00, 5.4922914472E+00, 3.7986367657E-01, 3.3399518393E-01, 6.0134008305E-01],
	[1.2275000000E+04, 5.5753508719E+00, 5.4918379121E+00, 3.8035143140E-01, 3.3438142142E-01, 6.0148783274E-01],
	[1.2280000000E+04, 5.5783809267E+00, 5.4913845990E+00, 3.8083961312E-01, 3.3476790417E-01, 6.0163555867E-01],
	[1.2285000000E+04, 5.5814113938E+00, 5.4909315080E+00, 3.8132822193E-01, 3.3515463212E-01, 6.0178326083E-01],
	[1.2290000000E+04, 5.5844422730E+00, 5.4904786386E+00, 3.8181725803E-01, 3.3554160525E-01, 6.0193093921E-01],
	[1.2295000000E+04, 5.5874735642E+00, 5.4900259908E+00, 3.8230672162E-01, 3.3592882351E-01, 6.0207859379E-01],
	[1.2300000000E+04, 5.5905052674E+00, 5.4895735643E+00, 3.8279661289E-01, 3.3631628685E-01, 6.0222622457E-01],
	[1.2305000000E+04, 5.5935373824E+00, 5.4891213590E+00, 3.8328693206E-01, 3.3670399524E-01, 6.0237383152E-01],
	[1.2310000000E+04, 5.5965699091E+00, 5.4886693746E+00, 3.8377767930E-01, 3.3709194862E-01, 6.0252141465E-01],
	[1.2315000000E+04, 5.5996028474E+00, 5.4882176109E+00, 3.8426885484E-01, 3.3748014696E-01, 6.0266897392E-01],
	[1.2320000000E+04, 5.6026361972E+00, 5.4877660678E+00, 3.8476045885E-01, 3.3786859021E-01, 6.0281650935E-01],
	[1.2325000000E+04, 5.6056699583E+00, 5.4873147450E+00, 3.8525249155E-01, 3.3825727833E-01, 6.0296402090E-01],
	[1.2330000000E+04, 5.6087041307E+00, 5.4868636424E+00, 3.8574495314E-01, 3.3864621127E-01, 6.0311150857E-01],
	[1.2335000000E+04, 5.6117387143E+00, 5.4864127597E+00, 3.8623784380E-01, 3.3903538899E-01, 6.0325897235E-01],
	[1.2340000000E+04, 5.6147737089E+00, 5.4859620968E+00, 3.8673116375E-01, 3.3942481144E-01, 6.0340641223E-01],
	[1.2345000000E+04, 5.6178091144E+00, 5.4855116534E+00, 3.8722491317E-01, 3.3981447859E-01, 6.0355382819E-01],
	[1.2350000000E+04, 5.6208449308E+00, 5.4850614294E+00, 3.8771909228E-01, 3.4020439039E-01, 6.0370122022E-01],
	[1.2355000000E+04, 5.6238811578E+00, 5.4846114246E+00, 3.8821370126E-01, 3.4059454678E-01, 6.0384858831E-01],
	[1.2360000000E+04, 5.6269177955E+00, 5.4841616388E+00, 3.8870874032E-01, 3.4098494773E-01, 6.0399593245E-01],
	[1.2365000000E+04, 5.6299548436E+00, 5.4837120717E+00, 3.8920420966E-01, 3.4137559320E-01, 6.0414325262E-01],
	[1.2370000000E+04, 5.6329923021E+00, 5.4832627232E+00, 3.8970010947E-01, 3.4176648313E-01, 6.0429054882E-01],
	[1.2375000000E+04, 5.6360301709E+00, 5.4828135932E+00, 3.9019643996E-01, 3.4215761748E-01, 6.0443782103E-01],
	[1.2380000000E+04, 5.6390684498E+00, 5.4823646813E+00, 3.9069320132E-01, 3.4254899620E-01, 6.0458506924E-01],
	[1.2385000000E+04, 5.6421071388E+00, 5.4819159874E+00, 3.9119039376E-01, 3.4294061925E-01, 6.0473229344E-01],
	[1.2390000000E+04, 5.6451462377E+00, 5.4814675113E+00, 3.9168801747E-01, 3.4333248659E-01, 6.0487949362E-01],
	[1.2395000000E+04, 5.6481857464E+00, 5.4810192528E+00, 3.9218607265E-01, 3.4372459816E-01, 6.0502666976E-01],
	[1.2400000000E+04, 5.6512256649E+00, 5.4805712118E+00, 3.9268455951E-01, 3.4411695392E-01, 6.0517382185E-01],
	[1.2405000000E+04, 5.6542659929E+00, 5.4801233879E+00, 3.9318347823E-01, 3.4450955383E-01, 6.0532094989E-01],
	[1.2410000000E+04, 5.6573067305E+00, 5.4796757812E+00, 3.9368282903E-01, 3.4490239783E-01, 6.0546805386E-01],
	[1.2415000000E+04, 5.6603478774E+00, 5.4792283912E+00, 3.9418261210E-01, 3.4529548588E-01, 6.0561513375E-01],
	[1.2420000000E+04, 5.6633894336E+00, 5.4787812179E+00, 3.9468282763E-01, 3.4568881794E-01, 6.0576218954E-01],
	[1.2425000000E+04, 5.6664313989E+00, 5.4783342611E+00, 3.9518347584E-01, 3.4608239395E-01, 6.0590922124E-01],
	[1.2430000000E+04, 5.6694790752E+00, 5.4778939807E+00, 3.9568455691E-01, 3.4647625951E-01, 6.0605622881E-01],
	[1.2435000000E+04, 5.6725276196E+00, 5.4774544675E+00, 3.9618607105E-01, 3.4687037303E-01, 6.0620321226E-01],
	[1.2440000000E+04, 5.6755765767E+00, 5.4770151662E+00, 3.9668801846E-01, 3.4726473056E-01, 6.0635017158E-01],
	[1.2445000000E+04, 5.6786259463E+00, 5.4765760766E+00, 3.9719039933E-01, 3.4765933203E-01, 6.0649710674E-01],
	[1.2450000000E+04, 5.6816757285E+00, 5.4761371986E+00, 3.9769321387E-01, 3.4805417741E-01, 6.0664401774E-01],
	[1.2455000000E+04, 5.6847259230E+00, 5.4756985320E+00, 3.9819646228E-01, 3.4844926665E-01, 6.0679090457E-01],
	[1.2460000000E+04, 5.6877765298E+00, 5.4752600765E+00, 3.9870014474E-01, 3.4884459970E-01, 6.0693776722E-01],
	[1.2465000000E+04, 5.6908275487E+00, 5.4748218321E+00, 3.9920426148E-01, 3.4924017650E-01, 6.0708460567E-01],
	[1.2470000000E+04, 5.6938789797E+00, 5.4743837984E+00, 3.9970881267E-01, 3.4963599702E-01, 6.0723141992E-01],
	[1.2475000000E+04, 5.6969308226E+00, 5.4739459754E+00, 4.0021379853E-01, 3.5003206120E-01, 6.0737820995E-01],
	[1.2480000000E+04, 5.6999830773E+00, 5.4735083628E+00, 4.0071921925E-01, 3.5042836900E-01, 6.0752497575E-01],
	[1.2485000000E+04, 5.7030357438E+00, 5.4730709605E+00, 4.0122507504E-01, 3.5082492036E-01, 6.0767171743E-01],
	[1.2490000000E+04, 5.7060888218E+00, 5.4726337682E+00, 4.0173136608E-01, 3.5122171524E-01, 6.0781843512E-01],
	[1.2495000000E+04, 5.7091423114E+00, 5.4721967859E+00, 4.0223809259E-01, 3.5161875358E-01, 6.0796512880E-01],
	[1.2500000000E+04, 5.7121962123E+00, 5.4717600132E+00, 4.0274525476E-01, 3.5201603534E-01, 6.0811179845E-01],
	[1.2505000000E+04, 5.7152505246E+00, 5.4713234500E+00, 4.0325380096E-01, 3.5241428464E-01, 6.0825844406E-01],
	[1.2510000000E+04, 5.7183052480E+00, 5.4708870962E+00, 4.0376278528E-01, 3.5281277844E-01, 6.0840506561E-01],
	[1.2515000000E+04, 5.7213603824E+00, 5.4704509515E+00, 4.0427220789E-01, 3.5321151669E-01, 6.0855166308E-01],
	[1.2520000000E+04, 5.7244159278E+00, 5.4700150158E+00, 4.0478206902E-01, 3.5361049934E-01, 6.0869823646E-01],
	[1.2525000000E+04, 5.7274718841E+00, 5.4695792889E+00, 4.0529236885E-01, 3.5400972633E-01, 6.0884478572E-01],
	[1.2530000000E+04, 5.7305282511E+00, 5.4691437705E+00, 4.0580310759E-01, 3.5440919763E-01, 6.0899131086E-01],
	[1.2535000000E+04, 5.7335850287E+00, 5.4687084606E+00, 4.0631428545E-01, 3.5480891317E-01, 6.0913781185E-01],
	[1.2540000000E+04, 5.7366422168E+00, 5.4682733589E+00, 4.0682590262E-01, 3.5520887291E-01, 6.0928428868E-01],
	[1.2545000000E+04, 5.7396998153E+00, 5.4678384653E+00, 4.0733795931E-01, 3.5560907679E-01, 6.0943074133E-01],
	[1.2550000000E+04, 5.7427578242E+00, 5.4674037795E+00, 4.0785045571E-01, 3.5600952478E-01, 6.0957716979E-01],
	[1.2555000000E+04, 5.7458162432E+00, 5.4669693014E+00, 4.0836339203E-01, 3.5641021680E-01, 6.0972357403E-01],
	[1.2560000000E+04, 5.7488750723E+00, 5.4665350308E+00, 4.0887676847E-01, 3.5681115282E-01, 6.0986995405E-01],
	[1.2565000000E+04, 5.7519343114E+00, 5.4661009675E+00, 4.0939058524E-01, 3.5721233277E-01, 6.1001630982E-01],
	[1.2570000000E+04, 5.7549939603E+00, 5.4656671114E+00, 4.0990484253E-01, 3.5761375662E-01, 6.1016264133E-01],
	[1.2575000000E+04, 5.7580540190E+00, 5.4652334622E+00, 4.1041954054E-01, 3.5801542430E-01, 6.1030894857E-01],
	[1.2580000000E+04, 5.7611144874E+00, 5.4648000198E+00, 4.1093467949E-01, 3.5841733577E-01, 6.1045523151E-01],
	[1.2585000000E+04, 5.7641753653E+00, 5.4643667840E+00, 4.1145025956E-01, 3.5881949097E-01, 6.1060149013E-01],
	[1.2590000000E+04, 5.7672366526E+00, 5.4639337546E+00, 4.1196628096E-01, 3.5922188985E-01, 6.1074772444E-01],
	[1.2595000000E+04, 5.7702983493E+00, 5.4635009314E+00, 4.1248274390E-01, 3.5962453236E-01, 6.1089393439E-01],
	[1.2600000000E+04, 5.7733604551E+00, 5.4630683143E+00, 4.1299964857E-01, 3.6002741845E-01, 6.1104011999E-01],
	[1.2605000000E+04, 5.7764229701E+00, 5.4626359031E+00, 4.1351699518E-01, 3.6043054805E-01, 6.1118628121E-01],
	[1.2610000000E+04, 5.7794858941E+00, 5.4622036975E+00, 4.1403478393E-01, 3.6083392112E-01, 6.1133241804E-01],
	[1.2615000000E+04, 5.7825492270E+00, 5.4617716975E+00, 4.1455301501E-01, 3.6123753761E-01, 6.1147853046E-01],
	[1.2620000000E+04, 5.7856129687E+00, 5.4613399028E+00, 4.1507168865E-01, 3.6164139746E-01, 6.1162461846E-01],
	[1.2625000000E+04, 5.7886771190E+00, 5.4609083133E+00, 4.1559080502E-01, 3.6204550062E-01, 6.1177068201E-01],
	[1.2630000000E+04, 5.7917472322E+00, 5.4604831975E+00, 4.1611036434E-01, 3.6244989640E-01, 6.1191672111E-01],
	[1.2635000000E+04, 5.7948182769E+00, 5.4600588689E+00, 4.1663036681E-01, 3.6285454019E-01, 6.1206273574E-01],
	[1.2640000000E+04, 5.7978897340E+00, 5.4596347411E+00, 4.1715081263E-01, 3.6325942732E-01, 6.1220872587E-01],
	[1.2645000000E+04, 5.8009616034E+00, 5.4592108140E+00, 4.1767170200E-01, 3.6366455774E-01, 6.1235469151E-01],
	[1.2650000000E+04, 5.8040338850E+00, 5.4587870874E+00, 4.1819303512E-01, 3.6406993140E-01, 6.1250063262E-01],
	[1.2655000000E+04, 5.8071065786E+00, 5.4583635611E+00, 4.1871481220E-01, 3.6447554825E-01, 6.1264654919E-01],
	[1.2660000000E+04, 5.8101796842E+00, 5.4579402349E+00, 4.1923703344E-01, 3.6488140822E-01, 6.1279244121E-01],
	[1.2665000000E+04, 5.8132532016E+00, 5.4575171087E+00, 4.1975969904E-01, 3.6528751126E-01, 6.1293830867E-01],
	[1.2670000000E+04, 5.8163271308E+00, 5.4570941823E+00, 4.2028280920E-01, 3.6569385733E-01, 6.1308415153E-01],
	[1.2675000000E+04, 5.8194014716E+00, 5.4566714555E+00, 4.2080636412E-01, 3.6610044636E-01, 6.1322996980E-01],
	[1.2680000000E+04, 5.8224762240E+00, 5.4562489282E+00, 4.2133036401E-01, 3.6650727829E-01, 6.1337576346E-01],
	[1.2685000000E+04, 5.8255513877E+00, 5.4558266001E+00, 4.2185480906E-01, 3.6691435308E-01, 6.1352153248E-01],
	[1.2690000000E+04, 5.8286269628E+00, 5.4554044712E+00, 4.2237969949E-01, 3.6732167067E-01, 6.1366727685E-01],
	[1.2695000000E+04, 5.8317029491E+00, 5.4549825411E+00, 4.2290503548E-01, 3.6772923099E-01, 6.1381299656E-01],
	[1.2700000000E+04, 5.8347793464E+00, 5.4545608099E+00, 4.2343081726E-01, 3.6813703401E-01, 6.1395869159E-01],
	[1.2705000000E+04, 5.8378561548E+00, 5.4541392772E+00, 4.2395704500E-01, 3.6854507965E-01, 6.1410436193E-01],
	[1.2710000000E+04, 5.8409333740E+00, 5.4537179430E+00, 4.2448371893E-01, 3.6895336787E-01, 6.1425000756E-01],
	[1.2715000000E+04, 5.8440110041E+00, 5.4532968070E+00, 4.2501083923E-01, 3.6936189860E-01, 6.1439562847E-01],
	[1.2720000000E+04, 5.8470890448E+00, 5.4528758690E+00, 4.2553840612E-01, 3.6977067179E-01, 6.1454122463E-01],
	[1.2725000000E+04, 5.8501674960E+00, 5.4524551290E+00, 4.2606641979E-01, 3.7017968739E-01, 6.1468679604E-01],
	[1.2730000000E+04, 5.8532463577E+00, 5.4520345867E+00, 4.2659488045E-01, 3.7058894533E-01, 6.1483234268E-01],
	[1.2735000000E+04, 5.8563256298E+00, 5.4516142420E+00, 4.2712378829E-01, 3.7099844557E-01, 6.1497786453E-01],
	[1.2740000000E+04, 5.8594053121E+00, 5.4511940946E+00, 4.2765314353E-01, 3.7140818803E-01, 6.1512336157E-01],
	[1.2745000000E+04, 5.8624854046E+00, 5.4507741445E+00, 4.2818294636E-01, 3.7181817267E-01, 6.1526883380E-01],
	[1.2750000000E+04, 5.8655659071E+00, 5.4503543914E+00, 4.2871319698E-01, 3.7222839943E-01, 6.1541428120E-01],
	[1.2755000000E+04, 5.8686468195E+00, 5.4499348352E+00, 4.2924389560E-01, 3.7263886825E-01, 6.1555970375E-01],
	[1.2760000000E+04, 5.8717281417E+00, 5.4495154758E+00, 4.2977504242E-01, 3.7304957907E-01, 6.1570510144E-01],
	[1.2765000000E+04, 5.8748098736E+00, 5.4490963128E+00, 4.3030663764E-01, 3.7346053183E-01, 6.1585047425E-01],
	[1.2770000000E+04, 5.8778920152E+00, 5.4486773463E+00, 4.3083868147E-01, 3.7387172647E-01, 6.1599582217E-01],
	[1.2775000000E+04, 5.8809745663E+00, 5.4482585759E+00, 4.3137117410E-01, 3.7428316295E-01, 6.1614114518E-01],
	[1.2780000000E+04, 5.8840575267E+00, 5.4478400016E+00, 4.3190411574E-01, 3.7469484119E-01, 6.1628644327E-01],
	[1.2785000000E+04, 5.8871408964E+00, 5.4474216232E+00, 4.3243750659E-01, 3.7510676114E-01, 6.1643171641E-01],
	[1.2790000000E+04, 5.8902246754E+00, 5.4470034404E+00, 4.3297134685E-01, 3.7551892273E-01, 6.1657696461E-01],
	[1.2795000000E+04, 5.8933088634E+00, 5.4465854532E+00, 4.3350563673E-01, 3.7593132592E-01, 6.1672218783E-01],
	[1.2800000000E+04, 5.8963934603E+00, 5.4461676614E+00, 4.3404037642E-01, 3.7634397065E-01, 6.1686738608E-01],
	[1.2805000000E+04, 5.8994784662E+00, 5.4457500647E+00, 4.3457556614E-01, 3.7675685684E-01, 6.1701255932E-01],
	[1.2810000000E+04, 5.9025638808E+00, 5.4453326631E+00, 4.3511120607E-01, 3.7716998444E-01, 6.1715770756E-01],
	[1.2815000000E+04, 5.9056497041E+00, 5.4449154563E+00, 4.3564729643E-01, 3.7758335340E-01, 6.1730283076E-01],
	[1.2820000000E+04, 5.9087359359E+00, 5.4444984443E+00, 4.3618383742E-01, 3.7799696365E-01, 6.1744792893E-01],
	[1.2825000000E+04, 5.9118225761E+00, 5.4440816267E+00, 4.3672082923E-01, 3.7841081513E-01, 6.1759300203E-01],
	[1.2830000000E+04, 5.9149113352E+00, 5.4436667836E+00, 4.3725827208E-01, 3.7882492342E-01, 6.1773805007E-01],
	[1.2835000000E+04, 5.9180052719E+00, 5.4432570928E+00, 4.3779616616E-01, 3.7923931653E-01, 6.1788307302E-01],
	[1.2840000000E+04, 5.9210996209E+00, 5.4428475923E+00, 4.3833451168E-01, 3.7965395091E-01, 6.1802807087E-01],
	[1.2845000000E+04, 5.9241943823E+00, 5.4424382821E+00, 4.3887330883E-01, 3.8006882649E-01, 6.1817304360E-01],
	[1.2850000000E+04, 5.9272895558E+00, 5.4420291620E+00, 4.3941255782E-01, 3.8048394321E-01, 6.1831799120E-01],
	[1.2855000000E+04, 5.9303851413E+00, 5.4416202317E+00, 4.3995225886E-01, 3.8089930101E-01, 6.1846291366E-01],
	[1.2860000000E+04, 5.9334811389E+00, 5.4412114912E+00, 4.4049241214E-01, 3.8131489983E-01, 6.1860781096E-01],
	[1.2865000000E+04, 5.9365775482E+00, 5.4408029403E+00, 4.4103301788E-01, 3.8173073962E-01, 6.1875268308E-01],
	[1.2870000000E+04, 5.9396743693E+00, 5.4403945788E+00, 4.4157407626E-01, 3.8214682030E-01, 6.1889753002E-01],
	[1.2875000000E+04, 5.9427716020E+00, 5.4399864065E+00, 4.4211558749E-01, 3.8256314182E-01, 6.1904235176E-01],
	[1.2880000000E+04, 5.9458692463E+00, 5.4395784233E+00, 4.4265755178E-01, 3.8297970411E-01, 6.1918714828E-01],
	[1.2885000000E+04, 5.9489673020E+00, 5.4391706290E+00, 4.4319996933E-01, 3.8339650712E-01, 6.1933191956E-01],
	[1.2890000000E+04, 5.9520657690E+00, 5.4387630235E+00, 4.4374284033E-01, 3.8381355078E-01, 6.1947666561E-01],
	[1.2895000000E+04, 5.9551646472E+00, 5.4383556066E+00, 4.4428616500E-01, 3.8423083503E-01, 6.1962138639E-01],
	[1.2900000000E+04, 5.9582639366E+00, 5.4379483782E+00, 4.4482994354E-01, 3.8464835981E-01, 6.1976608190E-01],
	[1.2905000000E+04, 5.9613636369E+00, 5.4375413380E+00, 4.4537417614E-01, 3.8506612505E-01, 6.1991075212E-01],
	[1.2910000000E+04, 5.9644637482E+00, 5.4371344860E+00, 4.4591886302E-01, 3.8548413069E-01, 6.2005539704E-01],
	[1.2915000000E+04, 5.9675642702E+00, 5.4367278219E+00, 4.4646400436E-01, 3.8590237667E-01, 6.2020001664E-01],
	[1.2920000000E+04, 5.9706652029E+00, 5.4363213457E+00, 4.4700960038E-01, 3.8632086293E-01, 6.2034461092E-01],
	[1.2925000000E+04, 5.9737665462E+00, 5.4359150571E+00, 4.4755565128E-01, 3.8673958939E-01, 6.2048917985E-01],
	[1.2930000000E+04, 5.9768683000E+00, 5.4355089559E+00, 4.4810215726E-01, 3.8715855601E-01, 6.2063372342E-01],
	[1.2935000000E+04, 5.9799704642E+00, 5.4351030421E+00, 4.4864911852E-01, 3.8757776272E-01, 6.2077824161E-01],
	[1.2940000000E+04, 5.9830730387E+00, 5.4346973155E+00, 4.4919653527E-01, 3.8799720944E-01, 6.2092273443E-01],
	[1.2945000000E+04, 5.9861760233E+00, 5.4342917759E+00, 4.4974440771E-01, 3.8841689613E-01, 6.2106720184E-01],
	[1.2950000000E+04, 5.9892794180E+00, 5.4338864231E+00, 4.5029273604E-01, 3.8883682271E-01, 6.2121164384E-01],
	[1.2955000000E+04, 5.9923832226E+00, 5.4334812571E+00, 4.5084152046E-01, 3.8925698912E-01, 6.2135606041E-01],
	[1.2960000000E+04, 5.9954874371E+00, 5.4330762775E+00, 4.5139076118E-01, 3.8967739529E-01, 6.2150045153E-01],
	[1.2965000000E+04, 5.9985920614E+00, 5.4326714844E+00, 4.5194045839E-01, 3.9009804117E-01, 6.2164481721E-01],
	[1.2970000000E+04, 6.0016970953E+00, 5.4322668775E+00, 4.5249061231E-01, 3.9051892668E-01, 6.2178915741E-01],
	[1.2975000000E+04, 6.0048025388E+00, 5.4318624566E+00, 4.5304122313E-01, 3.9094005176E-01, 6.2193347213E-01],
	[1.2980000000E+04, 6.0079083916E+00, 5.4314582216E+00, 4.5359229106E-01, 3.9136141635E-01, 6.2207776135E-01],
	[1.2985000000E+04, 6.0110146539E+00, 5.4310541724E+00, 4.5414381630E-01, 3.9178302038E-01, 6.2222202507E-01],
	[1.2990000000E+04, 6.0141213253E+00, 5.4306503088E+00, 4.5469579905E-01, 3.9220486378E-01, 6.2236626326E-01],
	[1.2995000000E+04, 6.0172284059E+00, 5.4302466306E+00, 4.5524823952E-01, 3.9262694650E-01, 6.2251047591E-01],
	[1.3000000000E+04, 6.0203358956E+00, 5.4298431377E+00, 4.5580113790E-01, 3.9304926846E-01, 6.2265466301E-01],
	[1.3005000000E+04, 6.0234437941E+00, 5.4294398300E+00, 4.5635449441E-01, 3.9347182960E-01, 6.2279882455E-01],
	[1.3010000000E+04, 6.0265521015E+00, 5.4290367072E+00, 4.5690830924E-01, 3.9389462985E-01, 6.2294296050E-01],
	[1.3015000000E+04, 6.0296608175E+00, 5.4286337692E+00, 4.5746258259E-01, 3.9431766914E-01, 6.2308707087E-01],
	[1.3020000000E+04, 6.0327699422E+00, 5.4282310158E+00, 4.5801731467E-01, 3.9474094742E-01, 6.2323115563E-01],
	[1.3025000000E+04, 6.0358794754E+00, 5.4278284470E+00, 4.5857250569E-01, 3.9516446461E-01, 6.2337521478E-01],
	[1.3030000000E+04, 6.0389894170E+00, 5.4274260625E+00, 4.5912815584E-01, 3.9558822064E-01, 6.2351924829E-01],
	[1.3035000000E+04, 6.0420997670E+00, 5.4270238622E+00, 4.5968426532E-01, 3.9601221546E-01, 6.2366325615E-01],
	[1.3040000000E+04, 6.0452171343E+00, 5.4266282026E+00, 4.6024083435E-01, 3.9643651133E-01, 6.2380723839E-01],
	[1.3045000000E+04, 6.0483351950E+00, 5.4262329936E+00, 4.6079786312E-01, 3.9686104873E-01, 6.2395119499E-01],
	[1.3050000000E+04, 6.0514536682E+00, 5.4258379649E+00, 4.6135535183E-01, 3.9728582493E-01, 6.2409512595E-01],
	[1.3055000000E+04, 6.0545725537E+00, 5.4254431163E+00, 4.6191330070E-01, 3.9771083987E-01, 6.2423903125E-01],
	[1.3060000000E+04, 6.0576918515E+00, 5.4250484475E+00, 4.6247170991E-01, 3.9813609348E-01, 6.2438291086E-01],
	[1.3065000000E+04, 6.0608115615E+00, 5.4246539586E+00, 4.6303057968E-01, 3.9856158569E-01, 6.2452676475E-01],
	[1.3070000000E+04, 6.0639316834E+00, 5.4242596492E+00, 4.6358991021E-01, 3.9898731644E-01, 6.2467059292E-01],
	[1.3075000000E+04, 6.0670522173E+00, 5.4238655193E+00, 4.6414970170E-01, 3.9941328567E-01, 6.2481439533E-01],
	[1.3080000000E+04, 6.0701731631E+00, 5.4234715687E+00, 4.6470995435E-01, 3.9983949329E-01, 6.2495817198E-01],
	[1.3085000000E+04, 6.0732945205E+00, 5.4230777973E+00, 4.6527066837E-01, 4.0026593924E-01, 6.2510192282E-01],
	[1.3090000000E+04, 6.0764162896E+00, 5.4226842049E+00, 4.6583184395E-01, 4.0069262346E-01, 6.2524564786E-01],
	[1.3095000000E+04, 6.0795384702E+00, 5.4222907913E+00, 4.6639348131E-01, 4.0111954587E-01, 6.2538934706E-01],
	[1.3100000000E+04, 6.0826610622E+00, 5.4218975565E+00, 4.6695558064E-01, 4.0154670641E-01, 6.2553302040E-01],
	[1.3105000000E+04, 6.0857840656E+00, 5.4215045002E+00, 4.6751814215E-01, 4.0197410501E-01, 6.2567666787E-01],
	[1.3110000000E+04, 6.0889074801E+00, 5.4211116223E+00, 4.6808116604E-01, 4.0240174160E-01, 6.2582028944E-01],
	[1.3115000000E+04, 6.0920313058E+00, 5.4207189227E+00, 4.6864465252E-01, 4.0282961611E-01, 6.2596388509E-01],
	[1.3120000000E+04, 6.0951555425E+00, 5.4203264012E+00, 4.6920860178E-01, 4.0325772847E-01, 6.2610745480E-01],
	[1.3125000000E+04, 6.0982801900E+00, 5.4199340577E+00, 4.6977301403E-01, 4.0368607861E-01, 6.2625099855E-01],
	[1.3130000000E+04, 6.1014052484E+00, 5.4195418920E+00, 4.7033788948E-01, 4.0411466646E-01, 6.2639451632E-01],
	[1.3135000000E+04, 6.1045307175E+00, 5.4191499040E+00, 4.7090322832E-01, 4.0454349195E-01, 6.2653800809E-01],
	[1.3140000000E+04, 6.1076565972E+00, 5.4187580935E+00, 4.7146903076E-01, 4.0497255502E-01, 6.2668147384E-01],
	[1.3145000000E+04, 6.1107828873E+00, 5.4183664603E+00, 4.7203529700E-01, 4.0540185558E-01, 6.2682491354E-01],
	[1.3150000000E+04, 6.1139095879E+00, 5.4179750044E+00, 4.7260202725E-01, 4.0583139358E-01, 6.2696832719E-01],
	[1.3155000000E+04, 6.1170366988E+00, 5.4175837256E+00, 4.7316922171E-01, 4.0626116894E-01, 6.2711171475E-01],
	[1.3160000000E+04, 6.1201642198E+00, 5.4171926237E+00, 4.7373688057E-01, 4.0669118158E-01, 6.2725507621E-01],
	[1.3165000000E+04, 6.1232921509E+00, 5.4168016986E+00, 4.7430500406E-01, 4.0712143145E-01, 6.2739841154E-01],
	[1.3170000000E+04, 6.1264204921E+00, 5.4164109501E+00, 4.7487359235E-01, 4.0755191847E-01, 6.2754172073E-01],
	[1.3175000000E+04, 6.1295492431E+00, 5.4160203781E+00, 4.7544264567E-01, 4.0798264256E-01, 6.2768500376E-01],
	[1.3180000000E+04, 6.1326784038E+00, 5.4156299825E+00, 4.7601216422E-01, 4.0841360366E-01, 6.2782826061E-01],
	[1.3185000000E+04, 6.1358079743E+00, 5.4152397631E+00, 4.7658214819E-01, 4.0884480169E-01, 6.2797149124E-01],
	[1.3190000000E+04, 6.1389379544E+00, 5.4148497197E+00, 4.7715259779E-01, 4.0927623658E-01, 6.2811469566E-01],
	[1.3195000000E+04, 6.1420683439E+00, 5.4144598522E+00, 4.7772351322E-01, 4.0970790827E-01, 6.2825787383E-01],
	[1.3200000000E+04, 6.1451991428E+00, 5.4140701605E+00, 4.7829489470E-01, 4.1013981667E-01, 6.2840102573E-01],
	[1.3205000000E+04, 6.1483303509E+00, 5.4136806444E+00, 4.7886674241E-01, 4.1057196172E-01, 6.2854415135E-01],
	[1.3210000000E+04, 6.1514619683E+00, 5.4132913037E+00, 4.7943905656E-01, 4.1100434334E-01, 6.2868725067E-01],
	[1.3215000000E+04, 6.1545939947E+00, 5.4129021384E+00, 4.8001183736E-01, 4.1143696147E-01, 6.2883032366E-01],
	[1.3220000000E+04, 6.1577264300E+00, 5.4125131483E+00, 4.8058508501E-01, 4.1186981602E-01, 6.2897337031E-01],
	[1.3225000000E+04, 6.1608592743E+00, 5.4121243331E+00, 4.8115879971E-01, 4.1230290693E-01, 6.2911639059E-01],
	[1.3230000000E+04, 6.1639925273E+00, 5.4117356929E+00, 4.8173298167E-01, 4.1273623413E-01, 6.2925938449E-01],
	[1.3235000000E+04, 6.1671261889E+00, 5.4113472274E+00, 4.8230763109E-01, 4.1316979753E-01, 6.2940235199E-01],
	[1.3240000000E+04, 6.1702602592E+00, 5.4109589366E+00, 4.8288274816E-01, 4.1360359707E-01, 6.2954529306E-01],
	[1.3245000000E+04, 6.1733947379E+00, 5.4105708201E+00, 4.8345833311E-01, 4.1403763267E-01, 6.2968820769E-01],
	[1.3250000000E+04, 6.1765368540E+00, 5.4101893257E+00, 4.8403438612E-01, 4.1447197466E-01, 6.2983109585E-01],
	[1.3255000000E+04, 6.1796794603E+00, 5.4098080711E+00, 4.8461090741E-01, 4.1490655356E-01, 6.2997395754E-01],
	[1.3260000000E+04, 6.1828224795E+00, 5.4094269871E+00, 4.8518789717E-01, 4.1534136854E-01, 6.3011679272E-01],
	[1.3265000000E+04, 6.1859659115E+00, 5.4090460736E+00, 4.8576535561E-01, 4.1577641953E-01, 6.3025960138E-01],
	[1.3270000000E+04, 6.1891097560E+00, 5.4086653305E+00, 4.8634328294E-01, 4.1621170647E-01, 6.3040238350E-01],
	[1.3275000000E+04, 6.1922540131E+00, 5.4082847576E+00, 4.8692167935E-01, 4.1664722926E-01, 6.3054513905E-01],
	[1.3280000000E+04, 6.1953986826E+00, 5.4079043548E+00, 4.8750054505E-01, 4.1708298785E-01, 6.3068786803E-01],
	[1.3285000000E+04, 6.1985437644E+00, 5.4075241219E+00, 4.8807988024E-01, 4.1751898215E-01, 6.3083057041E-01],
	[1.3290000000E+04, 6.2016892584E+00, 5.4071440588E+00, 4.8865968512E-01, 4.1795521210E-01, 6.3097324617E-01],
	[1.3295000000E+04, 6.2048351646E+00, 5.4067641654E+00, 4.8923995991E-01, 4.1839167761E-01, 6.3111589529E-01],
	[1.3300000000E+04, 6.2079814828E+00, 5.4063844415E+00, 4.8982070480E-01, 4.1882837861E-01, 6.3125851776E-01],
	[1.3305000000E+04, 6.2111282128E+00, 5.4060048869E+00, 4.9040191999E-01, 4.1926531503E-01, 6.3140111354E-01],
	[1.3310000000E+04, 6.2142753547E+00, 5.4056255016E+00, 4.9098360570E-01, 4.1970248678E-01, 6.3154368264E-01],
	[1.3315000000E+04, 6.2174229084E+00, 5.4052462855E+00, 4.9156576212E-01, 4.2013989381E-01, 6.3168622501E-01],
	[1.3320000000E+04, 6.2205708736E+00, 5.4048672382E+00, 4.9214838945E-01, 4.2057753602E-01, 6.3182874066E-01],
	[1.3325000000E+04, 6.2237192503E+00, 5.4044883598E+00, 4.9273148790E-01, 4.2101541335E-01, 6.3197122955E-01],
	[1.3330000000E+04, 6.2268680385E+00, 5.4041096501E+00, 4.9331505768E-01, 4.2145352572E-01, 6.3211369166E-01],
	[1.3335000000E+04, 6.2300172380E+00, 5.4037311089E+00, 4.9389909898E-01, 4.2189187305E-01, 6.3225612699E-01],
	[1.3340000000E+04, 6.2331668486E+00, 5.4033527362E+00, 4.9448361202E-01, 4.2233045527E-01, 6.3239853551E-01],
	[1.3345000000E+04, 6.2363168704E+00, 5.4029745317E+00, 4.9506859698E-01, 4.2276927230E-01, 6.3254091720E-01],
	[1.3350000000E+04, 6.2394673032E+00, 5.4025964953E+00, 4.9565405409E-01, 4.2320832406E-01, 6.3268327204E-01],
	[1.3355000000E+04, 6.2426181469E+00, 5.4022186270E+00, 4.9623998354E-01, 4.2364761048E-01, 6.3282560001E-01],
	[1.3360000000E+04, 6.2457694015E+00, 5.4018409265E+00, 4.9682638553E-01, 4.2408713148E-01, 6.3296790110E-01],
	[1.3365000000E+04, 6.2489210667E+00, 5.4014633937E+00, 4.9741326026E-01, 4.2452688698E-01, 6.3311017528E-01],
	[1.3370000000E+04, 6.2520731425E+00, 5.4010860285E+00, 4.9800060795E-01, 4.2496687691E-01, 6.3325242254E-01],
	[1.3375000000E+04, 6.2552256289E+00, 5.4007088308E+00, 4.9858842880E-01, 4.2540710119E-01, 6.3339464286E-01],
	[1.3380000000E+04, 6.2583785256E+00, 5.4003318003E+00, 4.9917672300E-01, 4.2584755974E-01, 6.3353683622E-01],
	[1.3385000000E+04, 6.2615318327E+00, 5.3999549371E+00, 4.9976549077E-01, 4.2628825249E-01, 6.3367900260E-01],
	[1.3390000000E+04, 6.2646855500E+00, 5.3995782408E+00, 5.0035473230E-01, 4.2672917935E-01, 6.3382114199E-01],
	[1.3395000000E+04, 6.2678396774E+00, 5.3992017115E+00, 5.0094444780E-01, 4.2717034024E-01, 6.3396325435E-01],
	[1.3400000000E+04, 6.2709942148E+00, 5.3988253489E+00, 5.0153463748E-01, 4.2761173510E-01, 6.3410533968E-01],
	[1.3405000000E+04, 6.2741491621E+00, 5.3984491530E+00, 5.0212530153E-01, 4.2805336384E-01, 6.3424739796E-01],
	[1.3410000000E+04, 6.2773045192E+00, 5.3980731236E+00, 5.0271644016E-01, 4.2849522638E-01, 6.3438942917E-01],
	[1.3415000000E+04, 6.2804602860E+00, 5.3976972605E+00, 5.0330805358E-01, 4.2893732265E-01, 6.3453143329E-01],
	[1.3420000000E+04, 6.2836164625E+00, 5.3973215636E+00, 5.0390014198E-01, 4.2937965256E-01, 6.3467341030E-01],
	[1.3425000000E+04, 6.2867730484E+00, 5.3969460328E+00, 5.0449270558E-01, 4.2982221604E-01, 6.3481536018E-01],
	[1.3430000000E+04, 6.2899300438E+00, 5.3965706680E+00, 5.0508574457E-01, 4.3026501301E-01, 6.3495728292E-01],
	[1.3435000000E+04, 6.2930874485E+00, 5.3961954690E+00, 5.0567925916E-01, 4.3070804339E-01, 6.3509917849E-01],
	[1.3440000000E+04, 6.2962452624E+00, 5.3958204357E+00, 5.0627324955E-01, 4.3115130709E-01, 6.3524104689E-01],
	[1.3445000000E+04, 6.2994034854E+00, 5.3954455679E+00, 5.0686771595E-01, 4.3159480405E-01, 6.3538288808E-01],
	[1.3450000000E+04, 6.3025621174E+00, 5.3950708655E+00, 5.0746265856E-01, 4.3203853417E-01, 6.3552470206E-01],
	[1.3455000000E+04, 6.3057211583E+00, 5.3946963284E+00, 5.0805807758E-01, 4.3248249739E-01, 6.3566648880E-01],
	[1.3460000000E+04, 6.3088832654E+00, 5.3943241610E+00, 5.0865397322E-01, 4.3292672033E-01, 6.3580824829E-01],
	[1.3465000000E+04, 6.3120508529E+00, 5.3939563616E+00, 5.0925034569E-01, 4.3337122732E-01, 6.3594998051E-01],
	[1.3470000000E+04, 6.3152188539E+00, 5.3935887238E+00, 5.0984719517E-01, 4.3381596743E-01, 6.3609168543E-01],
	[1.3475000000E+04, 6.3183872684E+00, 5.3932212475E+00, 5.1044452189E-01, 4.3426094056E-01, 6.3623336305E-01],
	[1.3480000000E+04, 6.3215560961E+00, 5.3928539326E+00, 5.1104232604E-01, 4.3470614664E-01, 6.3637501335E-01],
	[1.3485000000E+04, 6.3247253370E+00, 5.3924867788E+00, 5.1164060782E-01, 4.3515158559E-01, 6.3651663630E-01],
	[1.3490000000E+04, 6.3278949911E+00, 5.3921197862E+00, 5.1223936745E-01, 4.3559725733E-01, 6.3665823189E-01],
	[1.3495000000E+04, 6.3310650581E+00, 5.3917529545E+00, 5.1283860512E-01, 4.3604316177E-01, 6.3679980010E-01],
	[1.3500000000E+04, 6.3342355380E+00, 5.3913862836E+00, 5.1343832104E-01, 4.3648929884E-01, 6.3694134091E-01],
	[1.3505000000E+04, 6.3374064307E+00, 5.3910197735E+00, 5.1403851541E-01, 4.3693566846E-01, 6.3708285431E-01],
	[1.3510000000E+04, 6.3405777362E+00, 5.3906534239E+00, 5.1463918843E-01, 4.3738227053E-01, 6.3722434028E-01],
	[1.3515000000E+04, 6.3437494542E+00, 5.3902872347E+00, 5.1524034032E-01, 4.3782910500E-01, 6.3736579880E-01],
	[1.3520000000E+04, 6.3469215847E+00, 5.3899212059E+00, 5.1584197127E-01, 4.3827617176E-01, 6.3750722985E-01],
	[1.3525000000E+04, 6.3500941277E+00, 5.3895553373E+00, 5.1644408148E-01, 4.3872347074E-01, 6.3764863341E-01],
	[1.3530000000E+04, 6.3532670829E+00, 5.3891896287E+00, 5.1704667117E-01, 4.3917100186E-01, 6.3779000948E-01],
	[1.3535000000E+04, 6.3564404504E+00, 5.3888240800E+00, 5.1764974054E-01, 4.3961876503E-01, 6.3793135802E-01],
	[1.3540000000E+04, 6.3596142300E+00, 5.3884586911E+00, 5.1825328978E-01, 4.4006676018E-01, 6.3807267903E-01],
	[1.3545000000E+04, 6.3627884215E+00, 5.3880934619E+00, 5.1885731911E-01, 4.4051498722E-01, 6.3821397248E-01],
	[1.3550000000E+04, 6.3659630250E+00, 5.3877283922E+00, 5.1946182872E-01, 4.4096344607E-01, 6.3835523836E-01],
	[1.3555000000E+04, 6.3691380403E+00, 5.3873634820E+00, 5.2006681882E-01, 4.4141213664E-01, 6.3849647665E-01],
	[1.3560000000E+04, 6.3723134673E+00, 5.3869987310E+00, 5.2067228962E-01, 4.4186105885E-01, 6.3863768733E-01],
	[1.3565000000E+04, 6.3754893060E+00, 5.3866341392E+00, 5.2127824132E-01, 4.4231021263E-01, 6.3877887039E-01],
	[1.3570000000E+04, 6.3786655561E+00, 5.3862697063E+00, 5.2188467413E-01, 4.4275959788E-01, 6.3892002580E-01],
	[1.3575000000E+04, 6.3818422177E+00, 5.3859054324E+00, 5.2249158824E-01, 4.4320921453E-01, 6.3906115356E-01],
	[1.3580000000E+04, 6.3850192906E+00, 5.3855413173E+00, 5.2309898386E-01, 4.4365906248E-01, 6.3920225365E-01],
	[1.3585000000E+04, 6.3881967747E+00, 5.3851773608E+00, 5.2370686119E-01, 4.4410914167E-01, 6.3934332604E-01],
	[1.3590000000E+04, 6.3913746699E+00, 5.3848135628E+00, 5.2431522045E-01, 4.4455945199E-01, 6.3948437072E-01],
	[1.3595000000E+04, 6.3945529762E+00, 5.3844499232E+00, 5.2492406183E-01, 4.4500999338E-01, 6.3962538767E-01],
	[1.3600000000E+04, 6.3977316934E+00, 5.3840864418E+00, 5.2553338553E-01, 4.4546076573E-01, 6.3976637688E-01],
	[1.3605000000E+04, 6.4009108214E+00, 5.3837231186E+00, 5.2614319177E-01, 4.4591176898E-01, 6.3990733833E-01],
	[1.3610000000E+04, 6.4040903601E+00, 5.3833599534E+00, 5.2675348074E-01, 4.4636300304E-01, 6.4004827200E-01],
	[1.3615000000E+04, 6.4072703095E+00, 5.3829969461E+00, 5.2736425266E-01, 4.4681446782E-01, 6.4018917788E-01],
	[1.3620000000E+04, 6.4104506694E+00, 5.3826340965E+00, 5.2797550771E-01, 4.4726616323E-01, 6.4033005594E-01],
	[1.3625000000E+04, 6.4136314398E+00, 5.3822714046E+00, 5.2858724612E-01, 4.4771808919E-01, 6.4047090618E-01],
	[1.3630000000E+04, 6.4168126205E+00, 5.3819088701E+00, 5.2919946808E-01, 4.4817024563E-01, 6.4061172857E-01],
	[1.3635000000E+04, 6.4199942114E+00, 5.3815464930E+00, 5.2981217379E-01, 4.4862263244E-01, 6.4075252310E-01],
	[1.3640000000E+04, 6.4231762125E+00, 5.3811842732E+00, 5.3042536346E-01, 4.4907524955E-01, 6.4089328975E-01],
	[1.3645000000E+04, 6.4263586237E+00, 5.3808222105E+00, 5.3103903730E-01, 4.4952809687E-01, 6.4103402850E-01],
	[1.3650000000E+04, 6.4295414448E+00, 5.3804603048E+00, 5.3165319551E-01, 4.4998117432E-01, 6.4117473934E-01],
	[1.3655000000E+04, 6.4327246757E+00, 5.3800985559E+00, 5.3226783829E-01, 4.5043448181E-01, 6.4131542226E-01],
	[1.3660000000E+04, 6.4359083164E+00, 5.3797369638E+00, 5.3288296584E-01, 4.5088801925E-01, 6.4145607722E-01],
	[1.3665000000E+04, 6.4390923668E+00, 5.3793755283E+00, 5.3349857838E-01, 4.5134178655E-01, 6.4159670423E-01],
	[1.3670000000E+04, 6.4422768267E+00, 5.3790142493E+00, 5.3411467611E-01, 4.5179578364E-01, 6.4173730326E-01],
	[1.3675000000E+04, 6.4454617935E+00, 5.3786532020E+00, 5.3473125922E-01, 4.5225001144E-01, 6.4187787429E-01],
	[1.3680000000E+04, 6.4486552255E+00, 5.3782985384E+00, 5.3534832793E-01, 4.5270455266E-01, 6.4201841731E-01],
	[1.3685000000E+04, 6.4518490719E+00, 5.3779440276E+00, 5.3596588243E-01, 4.5315932369E-01, 6.4215893231E-01],
	[1.3690000000E+04, 6.4550433326E+00, 5.3775896698E+00, 5.3658392294E-01, 4.5361432443E-01, 6.4229941926E-01],
	[1.3695000000E+04, 6.4582380074E+00, 5.3772354647E+00, 5.3720392982E-01, 4.5407061228E-01, 6.4243987814E-01],
	[1.3700000000E+04, 6.4614330963E+00, 5.3768814122E+00, 5.3782684335E-01, 4.5452885765E-01, 6.4258030896E-01],
	[1.3705000000E+04, 6.4646285992E+00, 5.3765275121E+00, 5.3845025109E-01, 4.5498733623E-01, 6.4272071168E-01],
	[1.3710000000E+04, 6.4678245159E+00, 5.3761737645E+00, 5.3907415327E-01, 4.5544604794E-01, 6.4286108629E-01],
	[1.3715000000E+04, 6.4710208464E+00, 5.3758201691E+00, 5.3969855010E-01, 4.5590499268E-01, 6.4300143277E-01],
	[1.3720000000E+04, 6.4742175905E+00, 5.3754667258E+00, 5.4032344178E-01, 4.5636417037E-01, 6.4314175112E-01],
	[1.3725000000E+04, 6.4774147483E+00, 5.3751134346E+00, 5.4094882852E-01, 4.5682358093E-01, 6.4328204130E-01],
	[1.3730000000E+04, 6.4806123195E+00, 5.3747602952E+00, 5.4157471054E-01, 4.5728322425E-01, 6.4342230331E-01],
	[1.3735000000E+04, 6.4838103041E+00, 5.3744073076E+00, 5.4220108804E-01, 4.5774310027E-01, 6.4356253714E-01],
	[1.3740000000E+04, 6.4870087020E+00, 5.3740544716E+00, 5.4282796125E-01, 4.5820320887E-01, 6.4370274275E-01],
	[1.3745000000E+04, 6.4902075131E+00, 5.3737017872E+00, 5.4345533036E-01, 4.5866354999E-01, 6.4384292015E-01],
	[1.3750000000E+04, 6.4934067372E+00, 5.3733492542E+00, 5.4408319560E-01, 4.5912412352E-01, 6.4398306930E-01],
	[1.3755000000E+04, 6.4966063744E+00, 5.3729968724E+00, 5.4471155716E-01, 4.5958492938E-01, 6.4412319021E-01],
	[1.3760000000E+04, 6.4998064244E+00, 5.3726446418E+00, 5.4534041527E-01, 4.6004596748E-01, 6.4426328284E-01],
	[1.3765000000E+04, 6.5030068873E+00, 5.3722925623E+00, 5.4596977014E-01, 4.6050723773E-01, 6.4440334719E-01],
	[1.3770000000E+04, 6.5062077629E+00, 5.3719406337E+00, 5.4659962197E-01, 4.6096874004E-01, 6.4454338324E-01],
	[1.3775000000E+04, 6.5094090510E+00, 5.3715888559E+00, 5.4722997098E-01, 4.6143047432E-01, 6.4468339097E-01],
	[1.3780000000E+04, 6.5126107517E+00, 5.3712372288E+00, 5.4786081738E-01, 4.6189244048E-01, 6.4482337036E-01],
	[1.3785000000E+04, 6.5158128648E+00, 5.3708857522E+00, 5.4849216138E-01, 4.6235463843E-01, 6.4496332141E-01],
	[1.3790000000E+04, 6.5190153902E+00, 5.3705344261E+00, 5.4912400319E-01, 4.6281706808E-01, 6.4510324410E-01],
	[1.3795000000E+04, 6.5222183278E+00, 5.3701832504E+00, 5.4975634302E-01, 4.6327972934E-01, 6.4524313840E-01],
	[1.3800000000E+04, 6.5254216776E+00, 5.3698322248E+00, 5.5038918109E-01, 4.6374262213E-01, 6.4538300431E-01],
	[1.3805000000E+04, 6.5286254393E+00, 5.3694813494E+00, 5.5102251760E-01, 4.6420574634E-01, 6.4552284181E-01],
	[1.3810000000E+04, 6.5318296130E+00, 5.3691306239E+00, 5.5165635276E-01, 4.6466910188E-01, 6.4566265088E-01],
	[1.3815000000E+04, 6.5350341986E+00, 5.3687800482E+00, 5.5229068680E-01, 4.6513268868E-01, 6.4580243151E-01],
	[1.3820000000E+04, 6.5382391959E+00, 5.3684296223E+00, 5.5292551992E-01, 4.6559650663E-01, 6.4594218369E-01],
	[1.3825000000E+04, 6.5414446048E+00, 5.3680793461E+00, 5.5356085232E-01, 4.6606055564E-01, 6.4608190739E-01],
	[1.3830000000E+04, 6.5446504253E+00, 5.3677292193E+00, 5.5419668423E-01, 4.6652483563E-01, 6.4622160260E-01],
	[1.3835000000E+04, 6.5478566572E+00, 5.3673792419E+00, 5.5483301586E-01, 4.6698934650E-01, 6.4636126931E-01],
	[1.3840000000E+04, 6.5510633005E+00, 5.3670294138E+00, 5.5546984741E-01, 4.6745408816E-01, 6.4650090750E-01],
	[1.3845000000E+04, 6.5542703550E+00, 5.3666797348E+00, 5.5610717909E-01, 4.6791906051E-01, 6.4664051716E-01],
	[1.3850000000E+04, 6.5574778207E+00, 5.3663302048E+00, 5.5674501112E-01, 4.6838426347E-01, 6.4678009827E-01],
	[1.3855000000E+04, 6.5606856975E+00, 5.3659808238E+00, 5.5738334372E-01, 4.6884969694E-01, 6.4691965081E-01],
	[1.3860000000E+04, 6.5638939853E+00, 5.3656315916E+00, 5.5802217708E-01, 4.6931536083E-01, 6.4705917477E-01],
	[1.3865000000E+04, 6.5671026839E+00, 5.3652825080E+00, 5.5866151143E-01, 4.6978125505E-01, 6.4719867014E-01],
	[1.3870000000E+04, 6.5703117933E+00, 5.3649335730E+00, 5.5930134697E-01, 4.7024737951E-01, 6.4733813690E-01],
	[1.3875000000E+04, 6.5735213134E+00, 5.3645847865E+00, 5.5994168392E-01, 4.7071373410E-01, 6.4747757503E-01],
	[1.3880000000E+04, 6.5767312441E+00, 5.3642361483E+00, 5.6058252248E-01, 4.7118031875E-01, 6.4761698452E-01],
	[1.3885000000E+04, 6.5799415852E+00, 5.3638876583E+00, 5.6122386288E-01, 4.7164713335E-01, 6.4775636536E-01],
	[1.3890000000E+04, 6.5831523368E+00, 5.3635393164E+00, 5.6186570531E-01, 4.7211417781E-01, 6.4789571753E-01],
	[1.3895000000E+04, 6.5863634987E+00, 5.3631911224E+00, 5.6250805000E-01, 4.7258145204E-01, 6.4803504101E-01],
	[1.3900000000E+04, 6.5895835034E+00, 5.3628491659E+00, 5.6315089715E-01, 4.7304904679E-01, 6.4817433579E-01],
	[1.3905000000E+04, 6.5928040749E+00, 5.3625074634E+00, 5.6379424697E-01, 4.7351687304E-01, 6.4831360186E-01],
	[1.3910000000E+04, 6.5960250617E+00, 5.3621659056E+00, 5.6443809969E-01, 4.7398492907E-01, 6.4845283920E-01],
	[1.3915000000E+04, 6.5992464638E+00, 5.3618244922E+00, 5.6508245550E-01, 4.7445321479E-01, 6.4859204780E-01],
	[1.3920000000E+04, 6.6024682809E+00, 5.3614832233E+00, 5.6572731462E-01, 4.7492173010E-01, 6.4873122763E-01],
	[1.3925000000E+04, 6.6056905131E+00, 5.3611420985E+00, 5.6637267726E-01, 4.7539047492E-01, 6.4887037869E-01],
	[1.3930000000E+04, 6.6089131601E+00, 5.3608011180E+00, 5.6701854364E-01, 4.7585944914E-01, 6.4900950096E-01],
	[1.3935000000E+04, 6.6121362220E+00, 5.3604602815E+00, 5.6766491396E-01, 4.7632865268E-01, 6.4914859443E-01],
	[1.3940000000E+04, 6.6153596987E+00, 5.3601195889E+00, 5.6831178844E-01, 4.7679808543E-01, 6.4928765908E-01],
	[1.3945000000E+04, 6.6185835900E+00, 5.3597790402E+00, 5.6895916729E-01, 4.7726774731E-01, 6.4942669490E-01],
	[1.3950000000E+04, 6.6218078958E+00, 5.3594386351E+00, 5.6960705072E-01, 4.7773763821E-01, 6.4956570187E-01],
	[1.3955000000E+04, 6.6250326161E+00, 5.3590983737E+00, 5.7025543894E-01, 4.7820775805E-01, 6.4970467998E-01],
	[1.3960000000E+04, 6.6282577507E+00, 5.3587582557E+00, 5.7090433216E-01, 4.7867810673E-01, 6.4984362922E-01],
	[1.3965000000E+04, 6.6314832996E+00, 5.3584182811E+00, 5.7155373060E-01, 4.7914868415E-01, 6.4998254956E-01],
	[1.3970000000E+04, 6.6347092627E+00, 5.3580784498E+00, 5.7220363447E-01, 4.7961949022E-01, 6.5012144100E-01],
	[1.3975000000E+04, 6.6379356398E+00, 5.3577387616E+00, 5.7285404398E-01, 4.8009052484E-01, 6.5026030352E-01],
	[1.3980000000E+04, 6.6411624309E+00, 5.3573992164E+00, 5.7350495934E-01, 4.8056178792E-01, 6.5039913710E-01],
	[1.3985000000E+04, 6.6443896359E+00, 5.3570598142E+00, 5.7415638076E-01, 4.8103327936E-01, 6.5053794174E-01],
	[1.3990000000E+04, 6.6476172546E+00, 5.3567205548E+00, 5.7480830846E-01, 4.8150499906E-01, 6.5067671741E-01],
	[1.3995000000E+04, 6.6508452871E+00, 5.3563814380E+00, 5.7546074264E-01, 4.8197694693E-01, 6.5081546411E-01],
	[1.4000000000E+04, 6.6540737331E+00, 5.3560424639E+00, 5.7611368352E-01, 4.8244912287E-01, 6.5095418182E-01],
	[1.4005000000E+04, 6.6573025926E+00, 5.3557036323E+00, 5.7676713131E-01, 4.8292152679E-01, 6.5109287052E-01],
	[1.4010000000E+04, 6.6605318656E+00, 5.3553649430E+00, 5.7742108623E-01, 4.8339415858E-01, 6.5123153020E-01],
	[1.4015000000E+04, 6.6637615518E+00, 5.3550263960E+00, 5.7807554848E-01, 4.8386701816E-01, 6.5137016085E-01],
	[1.4020000000E+04, 6.6669916513E+00, 5.3546879911E+00, 5.7873051827E-01, 4.8434010542E-01, 6.5150876245E-01],
	[1.4025000000E+04, 6.6702221639E+00, 5.3543497283E+00, 5.7938599582E-01, 4.8481342027E-01, 6.5164733499E-01],
	[1.4030000000E+04, 6.6734530895E+00, 5.3540116074E+00, 5.8004198135E-01, 4.8528696261E-01, 6.5178587846E-01],
	[1.4035000000E+04, 6.6766844280E+00, 5.3536736283E+00, 5.8069847505E-01, 4.8576073234E-01, 6.5192439283E-01],
	[1.4040000000E+04, 6.6799161794E+00, 5.3533357910E+00, 5.8135547715E-01, 4.8623472936E-01, 6.5206287810E-01],
	[1.4045000000E+04, 6.6831483435E+00, 5.3529980952E+00, 5.8201298785E-01, 4.8670895359E-01, 6.5220133426E-01],
	[1.4050000000E+04, 6.6863809203E+00, 5.3526605409E+00, 5.8267100737E-01, 4.8718340491E-01, 6.5233976128E-01],
	[1.4055000000E+04, 6.6896139096E+00, 5.3523231280E+00, 5.8332953592E-01, 4.8765808324E-01, 6.5247815915E-01],
	[1.4060000000E+04, 6.6928473114E+00, 5.3519858564E+00, 5.8398857372E-01, 4.8813298846E-01, 6.5261652787E-01],
	[1.4065000000E+04, 6.6960811256E+00, 5.3516487259E+00, 5.8464812096E-01, 4.8860812049E-01, 6.5275486742E-01],
	[1.4070000000E+04, 6.6993153520E+00, 5.3513117365E+00, 5.8530817788E-01, 4.8908347923E-01, 6.5289317777E-01],
	[1.4075000000E+04, 6.7025499906E+00, 5.3509748880E+00, 5.8596874467E-01, 4.8955906458E-01, 6.5303145893E-01],
	[1.4080000000E+04, 6.7057850413E+00, 5.3506381804E+00, 5.8662982155E-01, 4.9003487643E-01, 6.5316971087E-01],
	[1.4085000000E+04, 6.7090205040E+00, 5.3503016134E+00, 5.8729140873E-01, 4.9051091469E-01, 6.5330793357E-01],
	[1.4090000000E+04, 6.7122563785E+00, 5.3499651871E+00, 5.8795350642E-01, 4.9098717927E-01, 6.5344612697E-01],
	[1.4095000000E+04, 6.7154926649E+00, 5.3496289013E+00, 5.8861611485E-01, 4.9146367005E-01, 6.5358429106E-01],
	[1.4100000000E+04, 6.7187293630E+00, 5.3492927559E+00, 5.8927923421E-01, 4.9194038695E-01, 6.5372242582E-01],
	[1.4105000000E+04, 6.7219664727E+00, 5.3489567508E+00, 5.8994286472E-01, 4.9241732985E-01, 6.5386053124E-01],
	[1.4110000000E+04, 6.7252039939E+00, 5.3486208859E+00, 5.9060700659E-01, 4.9289449867E-01, 6.5399860729E-01],
	[1.4115000000E+04, 6.7284419266E+00, 5.3482851610E+00, 5.9127166004E-01, 4.9337189330E-01, 6.5413665395E-01],
	[1.4120000000E+04, 6.7316824706E+00, 5.3479510638E+00, 5.9193682527E-01, 4.9384953817E-01, 6.5427467120E-01],
	[1.4125000000E+04, 6.7349302473E+00, 5.3476217150E+00, 5.9260250251E-01, 4.9432748486E-01, 6.5441265903E-01],
	[1.4130000000E+04, 6.7381784407E+00, 5.3472925030E+00, 5.9326869195E-01, 4.9480565737E-01, 6.5455061741E-01],
	[1.4135000000E+04, 6.7414270505E+00, 5.3469634278E+00, 5.9393539382E-01, 4.9528405560E-01, 6.5468854633E-01],
	[1.4140000000E+04, 6.7446760769E+00, 5.3466344891E+00, 5.9460260832E-01, 4.9576267946E-01, 6.5482644577E-01],
	[1.4145000000E+04, 6.7479255196E+00, 5.3463056870E+00, 5.9527033568E-01, 4.9624152885E-01, 6.5496431570E-01],
	[1.4150000000E+04, 6.7511753785E+00, 5.3459770213E+00, 5.9593857609E-01, 4.9672060365E-01, 6.5510215611E-01],
	[1.4155000000E+04, 6.7544256537E+00, 5.3456484919E+00, 5.9660732977E-01, 4.9719990378E-01, 6.5523996698E-01],
	[1.4160000000E+04, 6.7576763449E+00, 5.3453200987E+00, 5.9727659694E-01, 4.9767942914E-01, 6.5537774829E-01],
	[1.4165000000E+04, 6.7609274521E+00, 5.3449918416E+00, 5.9794637780E-01, 4.9815917961E-01, 6.5551550001E-01],
	[1.4170000000E+04, 6.7641789752E+00, 5.3446637206E+00, 5.9861667258E-01, 4.9863915511E-01, 6.5565322215E-01],
	[1.4175000000E+04, 6.7674309141E+00, 5.3443357354E+00, 5.9928748147E-01, 4.9911935552E-01, 6.5579091466E-01],
	[1.4180000000E+04, 6.7706832687E+00, 5.3440078859E+00, 5.9995880470E-01, 4.9959978076E-01, 6.5592857754E-01],
	[1.4185000000E+04, 6.7739360389E+00, 5.3436801722E+00, 6.0063064248E-01, 5.0008043071E-01, 6.5606621076E-01],
	[1.4190000000E+04, 6.7771892246E+00, 5.3433525941E+00, 6.0130299501E-01, 5.0056130527E-01, 6.5620381431E-01],
	[1.4195000000E+04, 6.7804428258E+00, 5.3430251514E+00, 6.0197586251E-01, 5.0104240434E-01, 6.5634138816E-01],
	[1.4200000000E+04, 6.7836968422E+00, 5.3426978441E+00, 6.0264924520E-01, 5.0152372783E-01, 6.5647893231E-01],
	[1.4205000000E+04, 6.7869512740E+00, 5.3423706721E+00, 6.0332314328E-01, 5.0200527563E-01, 6.5661644672E-01],
	[1.4210000000E+04, 6.7902061208E+00, 5.3420436352E+00, 6.0399755697E-01, 5.0248704763E-01, 6.5675393139E-01],
	[1.4215000000E+04, 6.7934613828E+00, 5.3417167334E+00, 6.0467248648E-01, 5.0296904373E-01, 6.5689138629E-01],
	[1.4220000000E+04, 6.7967170596E+00, 5.3413899666E+00, 6.0534793202E-01, 5.0345126384E-01, 6.5702881140E-01],
	[1.4225000000E+04, 6.7999731514E+00, 5.3410633346E+00, 6.0602389381E-01, 5.0393370784E-01, 6.5716620671E-01],
	[1.4230000000E+04, 6.8032296579E+00, 5.3407368373E+00, 6.0670037206E-01, 5.0441637564E-01, 6.5730357219E-01],
	[1.4235000000E+04, 6.8064865791E+00, 5.3404104748E+00, 6.0737736697E-01, 5.0489926713E-01, 6.5744090783E-01],
	[1.4240000000E+04, 6.8097439149E+00, 5.3400842467E+00, 6.0805487877E-01, 5.0538238221E-01, 6.5757821362E-01],
	[1.4245000000E+04, 6.8130016652E+00, 5.3397581531E+00, 6.0873290766E-01, 5.0586572078E-01, 6.5771548952E-01],
	[1.4250000000E+04, 6.8162598298E+00, 5.3394321939E+00, 6.0941145386E-01, 5.0634928272E-01, 6.5785273553E-01],
	[1.4255000000E+04, 6.8195184088E+00, 5.3391063688E+00, 6.1009051757E-01, 5.0683306795E-01, 6.5798995162E-01],
	[1.4260000000E+04, 6.8227774020E+00, 5.3387806780E+00, 6.1077009902E-01, 5.0731707635E-01, 6.5812713778E-01],
	[1.4265000000E+04, 6.8260368094E+00, 5.3384551211E+00, 6.1145019842E-01, 5.0780130782E-01, 6.5826429398E-01],
	[1.4270000000E+04, 6.8292966307E+00, 5.3381296982E+00, 6.1213081597E-01, 5.0828576226E-01, 6.5840142022E-01],
	[1.4275000000E+04, 6.8325568660E+00, 5.3378044091E+00, 6.1281195189E-01, 5.0877043956E-01, 6.5853851647E-01],
	[1.4280000000E+04, 6.8358175152E+00, 5.3374792538E+00, 6.1349360640E-01, 5.0925533962E-01, 6.5867558271E-01],
	[1.4285000000E+04, 6.8390785781E+00, 5.3371542320E+00, 6.1417577970E-01, 5.0974046233E-01, 6.5881261893E-01],
	[1.4290000000E+04, 6.8423400546E+00, 5.3368293438E+00, 6.1485847200E-01, 5.1022580759E-01, 6.5894962510E-01],
	[1.4295000000E+04, 6.8456019448E+00, 5.3365045891E+00, 6.1554168353E-01, 5.1071137530E-01, 6.5908660122E-01],
	[1.4300000000E+04, 6.8488642484E+00, 5.3361799676E+00, 6.1622541449E-01, 5.1119716534E-01, 6.5922354725E-01],
	[1.4305000000E+04, 6.8521269654E+00, 5.3358554794E+00, 6.1690966509E-01, 5.1168317762E-01, 6.5936046319E-01],
	[1.4310000000E+04, 6.8553900957E+00, 5.3355311242E+00, 6.1759443555E-01, 5.1216941202E-01, 6.5949734902E-01],
	[1.4315000000E+04, 6.8586536391E+00, 5.3352069021E+00, 6.1827972609E-01, 5.1265586845E-01, 6.5963420471E-01],
	[1.4320000000E+04, 6.8619175957E+00, 5.3348828130E+00, 6.1896553690E-01, 5.1314254679E-01, 6.5977103025E-01],
	[1.4325000000E+04, 6.8651819653E+00, 5.3345588566E+00, 6.1965186821E-01, 5.1362944695E-01, 6.5990782563E-01],
	[1.4330000000E+04, 6.8684467479E+00, 5.3342350329E+00, 6.2033872023E-01, 5.1411656881E-01, 6.6004459082E-01],
	[1.4335000000E+04, 6.8717119432E+00, 5.3339113419E+00, 6.2102609317E-01, 5.1460391227E-01, 6.6018132581E-01],
	[1.4340000000E+04, 6.8749775513E+00, 5.3335877834E+00, 6.2171398725E-01, 5.1509147722E-01, 6.6031803057E-01],
	[1.4345000000E+04, 6.8782435721E+00, 5.3332643573E+00, 6.2240240267E-01, 5.1557926356E-01, 6.6045470510E-01],
	[1.4350000000E+04, 6.8815174354E+00, 5.3329457734E+00, 6.2309133965E-01, 5.1606735708E-01, 6.6059134937E-01],
	[1.4355000000E+04, 6.8847937470E+00, 5.3326286066E+00, 6.2378079840E-01, 5.1655569554E-01, 6.6072796337E-01],
	[1.4360000000E+04, 6.8880704768E+00, 5.3323115691E+00, 6.2447077914E-01, 5.1704425540E-01, 6.6086454708E-01],
	[1.4365000000E+04, 6.8913476245E+00, 5.3319946608E+00, 6.2516128207E-01, 5.1753303655E-01, 6.6100110048E-01],
	[1.4370000000E+04, 6.8946251902E+00, 5.3316778816E+00, 6.2585230742E-01, 5.1802203889E-01, 6.6113762355E-01],
	[1.4375000000E+04, 6.8979031736E+00, 5.3313612314E+00, 6.2654385539E-01, 5.1851126231E-01, 6.6127411628E-01],
	[1.4380000000E+04, 6.9011815747E+00, 5.3310447101E+00, 6.2723592619E-01, 5.1900070670E-01, 6.6141057865E-01],
	[1.4385000000E+04, 6.9044603935E+00, 5.3307283177E+00, 6.2792852004E-01, 5.1949037195E-01, 6.6154701064E-01],
	[1.4390000000E+04, 6.9077396297E+00, 5.3304120540E+00, 6.2862163716E-01, 5.1998025797E-01, 6.6168341223E-01],
	[1.4395000000E+04, 6.9110192834E+00, 5.3300959189E+00, 6.2931527775E-01, 5.2047036464E-01, 6.6181978341E-01],
	[1.4400000000E+04, 6.9142993544E+00, 5.3297799123E+00, 6.3000944202E-01, 5.2096069185E-01, 6.6195612416E-01],
	[1.4405000000E+04, 6.9175798427E+00, 5.3294640342E+00, 6.3070413020E-01, 5.2145123950E-01, 6.6209243447E-01],
	[1.4410000000E+04, 6.9208607481E+00, 5.3291482844E+00, 6.3139934249E-01, 5.2194200748E-01, 6.6222871431E-01],
	[1.4415000000E+04, 6.9241420706E+00, 5.3288326628E+00, 6.3209507910E-01, 5.2243299567E-01, 6.6236496367E-01],
	[1.4420000000E+04, 6.9274238100E+00, 5.3285171694E+00, 6.3279134026E-01, 5.2292420399E-01, 6.6250118253E-01],
	[1.4425000000E+04, 6.9307059663E+00, 5.3282018040E+00, 6.3348812616E-01, 5.2341563230E-01, 6.6263737088E-01],
	[1.4430000000E+04, 6.9339885394E+00, 5.3278865666E+00, 6.3418543703E-01, 5.2390728051E-01, 6.6277352869E-01],
	[1.4435000000E+04, 6.9372715292E+00, 5.3275714570E+00, 6.3488327308E-01, 5.2439914851E-01, 6.6290965596E-01],
	[1.4440000000E+04, 6.9405549356E+00, 5.3272564752E+00, 6.3558163451E-01, 5.2489123619E-01, 6.6304575265E-01],
	[1.4445000000E+04, 6.9438387586E+00, 5.3269416210E+00, 6.3628052155E-01, 5.2538354344E-01, 6.6318181877E-01],
	[1.4450000000E+04, 6.9471229979E+00, 5.3266268944E+00, 6.3697993441E-01, 5.2587607015E-01, 6.6331785429E-01],
	[1.4455000000E+04, 6.9504076535E+00, 5.3263122953E+00, 6.3767987329E-01, 5.2636881622E-01, 6.6345385918E-01],
	[1.4460000000E+04, 6.9536927254E+00, 5.3259978235E+00, 6.3838033842E-01, 5.2686178152E-01, 6.6358983345E-01],
	[1.4465000000E+04, 6.9569782135E+00, 5.3256834790E+00, 6.3908133001E-01, 5.2735496596E-01, 6.6372577707E-01],
	[1.4470000000E+04, 6.9602641176E+00, 5.3253692617E+00, 6.3978284826E-01, 5.2784836943E-01, 6.6386169002E-01],
	[1.4475000000E+04, 6.9635504376E+00, 5.3250551715E+00, 6.4048489339E-01, 5.2834199181E-01, 6.6399757228E-01],
	[1.4480000000E+04, 6.9668371735E+00, 5.3247412083E+00, 6.4118746562E-01, 5.2883583300E-01, 6.6413342385E-01],
	[1.4485000000E+04, 6.9701243253E+00, 5.3244273720E+00, 6.4189056515E-01, 5.2932989288E-01, 6.6426924470E-01],
	[1.4490000000E+04, 6.9734118926E+00, 5.3241136624E+00, 6.4259419221E-01, 5.2982417134E-01, 6.6440503481E-01],
	[1.4495000000E+04, 6.9766998756E+00, 5.3238000796E+00, 6.4329834700E-01, 5.3031866828E-01, 6.6454079418E-01],
	[1.4500000000E+04, 6.9799882742E+00, 5.3234866234E+00, 6.4400302973E-01, 5.3081338359E-01, 6.6467652278E-01],
	[1.4505000000E+04, 6.9832770881E+00, 5.3231732937E+00, 6.4470824062E-01, 5.3130831715E-01, 6.6481222060E-01],
	[1.4510000000E+04, 6.9865663173E+00, 5.3228600904E+00, 6.4541397989E-01, 5.3180346885E-01, 6.6494788762E-01],
	[1.4515000000E+04, 6.9898559618E+00, 5.3225470135E+00, 6.4612024775E-01, 5.3229883859E-01, 6.6508352382E-01],
	[1.4520000000E+04, 6.9931460214E+00, 5.3222340628E+00, 6.4682704440E-01, 5.3279442625E-01, 6.6521912920E-01],
	[1.4525000000E+04, 6.9964364961E+00, 5.3219212382E+00, 6.4753437006E-01, 5.3329023172E-01, 6.6535470372E-01],
	[1.4530000000E+04, 6.9997273858E+00, 5.3216085397E+00, 6.4824222495E-01, 5.3378625489E-01, 6.6549024738E-01],
	[1.4535000000E+04, 7.0030186903E+00, 5.3212959671E+00, 6.4895060928E-01, 5.3428249564E-01, 6.6562576016E-01],
	[1.4540000000E+04, 7.0063104096E+00, 5.3209835203E+00, 6.4965952326E-01, 5.3477895388E-01, 6.6576124205E-01],
	[1.4545000000E+04, 7.0096025436E+00, 5.3206711994E+00, 6.5036896711E-01, 5.3527562948E-01, 6.6589669302E-01],
	[1.4550000000E+04, 7.0128950922E+00, 5.3203590041E+00, 6.5107894103E-01, 5.3577252233E-01, 6.6603211307E-01],
	[1.4555000000E+04, 7.0161880553E+00, 5.3200469344E+00, 6.5178944525E-01, 5.3626963232E-01, 6.6616750217E-01],
	[1.4560000000E+04, 7.0194814329E+00, 5.3197349901E+00, 6.5250047996E-01, 5.3676695935E-01, 6.6630286031E-01],
	[1.4565000000E+04, 7.0227752247E+00, 5.3194231713E+00, 6.5321204540E-01, 5.3726450329E-01, 6.6643818747E-01],
	[1.4570000000E+04, 7.0260694308E+00, 5.3191114777E+00, 6.5392414177E-01, 5.3776226403E-01, 6.6657348364E-01],
	[1.4575000000E+04, 7.0293640511E+00, 5.3187999093E+00, 6.5463676928E-01, 5.3826024147E-01, 6.6670874881E-01],
	[1.4580000000E+04, 7.0326649790E+00, 5.3184919756E+00, 6.5534992815E-01, 5.3875850609E-01, 6.6684398294E-01],
	[1.4585000000E+04, 7.0359703390E+00, 5.3181865547E+00, 6.5606361859E-01, 5.3925703554E-01, 6.6697918604E-01],
	[1.4590000000E+04, 7.0392761188E+00, 5.3178812560E+00, 6.5677784082E-01, 5.3975578169E-01, 6.6711435809E-01],
	[1.4595000000E+04, 7.0425823183E+00, 5.3175760794E+00, 6.5749259504E-01, 5.4025474443E-01, 6.6724949906E-01],
	[1.4600000000E+04, 7.0458889373E+00, 5.3172710248E+00, 6.5820788148E-01, 5.4075392366E-01, 6.6738460894E-01],
	[1.4605000000E+04, 7.0491959759E+00, 5.3169660922E+00, 6.5892370033E-01, 5.4125331925E-01, 6.6751968773E-01],
	[1.4610000000E+04, 7.0525034339E+00, 5.3166612815E+00, 6.5964005183E-01, 5.4175293109E-01, 6.6765473539E-01],
	[1.4615000000E+04, 7.0558113113E+00, 5.3163565925E+00, 6.6035693618E-01, 5.4225275908E-01, 6.6778975192E-01],
	[1.4620000000E+04, 7.0591196078E+00, 5.3160520252E+00, 6.6107435359E-01, 5.4275280310E-01, 6.6792473730E-01],
	[1.4625000000E+04, 7.0624283236E+00, 5.3157475795E+00, 6.6179230428E-01, 5.4325306303E-01, 6.6805969152E-01],
	[1.4630000000E+04, 7.0657374583E+00, 5.3154432552E+00, 6.6251078846E-01, 5.4375353877E-01, 6.6819461455E-01],
	[1.4635000000E+04, 7.0690470121E+00, 5.3151390524E+00, 6.6322980634E-01, 5.4425423019E-01, 6.6832950639E-01],
	[1.4640000000E+04, 7.0723569847E+00, 5.3148349709E+00, 6.6394935814E-01, 5.4475513718E-01, 6.6846436702E-01],
	[1.4645000000E+04, 7.0756673761E+00, 5.3145310106E+00, 6.6466944407E-01, 5.4525625964E-01, 6.6859919642E-01],
	[1.4650000000E+04, 7.0789781862E+00, 5.3142271714E+00, 6.6539006435E-01, 5.4575759744E-01, 6.6873399458E-01],
	[1.4655000000E+04, 7.0822894150E+00, 5.3139234533E+00, 6.6611121919E-01, 5.4625915048E-01, 6.6886876148E-01],
	[1.4660000000E+04, 7.0856010622E+00, 5.3136198561E+00, 6.6683290880E-01, 5.4676091863E-01, 6.6900349711E-01],
	[1.4665000000E+04, 7.0889131279E+00, 5.3133163798E+00, 6.6755513339E-01, 5.4726290178E-01, 6.6913820145E-01],
	[1.4670000000E+04, 7.0922256119E+00, 5.3130130243E+00, 6.6827789318E-01, 5.4776509983E-01, 6.6927287449E-01],
	[1.4675000000E+04, 7.0955385141E+00, 5.3127097894E+00, 6.6900118839E-01, 5.4826751265E-01, 6.6940751621E-01],
	[1.4680000000E+04, 7.0988518345E+00, 5.3124066752E+00, 6.6972501922E-01, 5.4877014012E-01, 6.6954212660E-01],
	[1.4685000000E+04, 7.1021655730E+00, 5.3121036814E+00, 6.7044938589E-01, 5.4927298214E-01, 6.6967670563E-01],
	[1.4690000000E+04, 7.1054797295E+00, 5.3118008081E+00, 6.7117428861E-01, 5.4977603859E-01, 6.6981125331E-01],
	[1.4695000000E+04, 7.1087943038E+00, 5.3114980551E+00, 6.7189972760E-01, 5.5027930935E-01, 6.6994576961E-01],
	[1.4700000000E+04, 7.1121092960E+00, 5.3111954224E+00, 6.7262570307E-01, 5.5078279431E-01, 6.7008025451E-01],
	[1.4705000000E+04, 7.1154247058E+00, 5.3108929098E+00, 6.7335221523E-01, 5.5128649336E-01, 6.7021470800E-01],
	[1.4710000000E+04, 7.1187405333E+00, 5.3105905173E+00, 6.7407926430E-01, 5.5179040637E-01, 6.7034913008E-01],
	[1.4715000000E+04, 7.1220567783E+00, 5.3102882447E+00, 6.7480685049E-01, 5.5229453323E-01, 6.7048352071E-01],
	[1.4720000000E+04, 7.1253734408E+00, 5.3099860921E+00, 6.7553497402E-01, 5.5279887382E-01, 6.7061787989E-01],
	[1.4725000000E+04, 7.1286905206E+00, 5.3096840592E+00, 6.7626363509E-01, 5.5330342804E-01, 6.7075220760E-01],
	[1.4730000000E+04, 7.1320080177E+00, 5.3093821460E+00, 6.7699283392E-01, 5.5380819575E-01, 6.7088650383E-01],
	[1.4735000000E+04, 7.1353259319E+00, 5.3090803525E+00, 6.7772257073E-01, 5.5431317685E-01, 6.7102076856E-01],
	[1.4740000000E+04, 7.1386442633E+00, 5.3087786785E+00, 6.7845284573E-01, 5.5481837123E-01, 6.7115500179E-01],
	[1.4745000000E+04, 7.1419630116E+00, 5.3084771240E+00, 6.7918365913E-01, 5.5532377875E-01, 6.7128920348E-01],
	[1.4750000000E+04, 7.1452821768E+00, 5.3081756888E+00, 6.7991501115E-01, 5.5582939931E-01, 6.7142337363E-01],
	[1.4755000000E+04, 7.1486017589E+00, 5.3078743729E+00, 6.8064690200E-01, 5.5633523279E-01, 6.7155751223E-01],
	[1.4760000000E+04, 7.1519217577E+00, 5.3075731761E+00, 6.8137933189E-01, 5.5684127907E-01, 6.7169161926E-01],
	[1.4765000000E+04, 7.1552421731E+00, 5.3072720985E+00, 6.8211230104E-01, 5.5734753804E-01, 6.7182569470E-01],
	[1.4770000000E+04, 7.1585630051E+00, 5.3069711399E+00, 6.8284580966E-01, 5.5785400957E-01, 6.7195973855E-01],
	[1.4775000000E+04, 7.1618842535E+00, 5.3066703002E+00, 6.8357985796E-01, 5.5836069355E-01, 6.7209375078E-01],
	[1.4780000000E+04, 7.1652059184E+00, 5.3063695793E+00, 6.8431444616E-01, 5.5886758987E-01, 6.7222773138E-01],
	[1.4785000000E+04, 7.1685279995E+00, 5.3060689772E+00, 6.8504957448E-01, 5.5937469840E-01, 6.7236168034E-01],
	[1.4790000000E+04, 7.1718504968E+00, 5.3057684937E+00, 6.8578524312E-01, 5.5988201902E-01, 6.7249559764E-01],
	[1.4795000000E+04, 7.1751734102E+00, 5.3054681289E+00, 6.8652145231E-01, 5.6038955163E-01, 6.7262948327E-01],
	[1.4800000000E+04, 7.1784967396E+00, 5.3051678825E+00, 6.8725820224E-01, 5.6089729609E-01, 6.7276333722E-01],
	[1.4805000000E+04, 7.1818204850E+00, 5.3048677545E+00, 6.8799549315E-01, 5.6140525230E-01, 6.7289715946E-01],
	[1.4810000000E+04, 7.1851446462E+00, 5.3045677448E+00, 6.8873332523E-01, 5.6191342013E-01, 6.7303095000E-01],
	[1.4815000000E+04, 7.1884760691E+00, 5.3042716883E+00, 6.8947169871E-01, 5.6242188448E-01, 6.7316470880E-01],
	[1.4820000000E+04, 7.1918114263E+00, 5.3039777160E+00, 6.9021061380E-01, 5.6293060417E-01, 6.7329843587E-01],
	[1.4825000000E+04, 7.1951472053E+00, 5.3036838592E+00, 6.9095007071E-01, 5.6343953550E-01, 6.7343213117E-01],
	[1.4830000000E+04, 7.1984834058E+00, 5.3033901178E+00, 6.9169006966E-01, 5.6394867834E-01, 6.7356579471E-01],
	[1.4835000000E+04, 7.2018200278E+00, 5.3030964917E+00, 6.9243061086E-01, 5.6445803259E-01, 6.7369942647E-01],
	[1.4840000000E+04, 7.2051570712E+00, 5.3028029807E+00, 6.9317169453E-01, 5.6496759812E-01, 6.7383302642E-01],
	[1.4845000000E+04, 7.2084945359E+00, 5.3025095848E+00, 6.9391332087E-01, 5.6547737481E-01, 6.7396659456E-01],
	[1.4850000000E+04, 7.2118324219E+00, 5.3022163040E+00, 6.9465549011E-01, 5.6598736255E-01, 6.7410013088E-01],
	[1.4855000000E+04, 7.2151707290E+00, 5.3019231381E+00, 6.9539820245E-01, 5.6649756122E-01, 6.7423363536E-01],
	[1.4860000000E+04, 7.2185094572E+00, 5.3016300871E+00, 6.9614145812E-01, 5.6700797069E-01, 6.7436710798E-01],
	[1.4865000000E+04, 7.2218486063E+00, 5.3013371509E+00, 6.9688525732E-01, 5.6751859084E-01, 6.7450054874E-01],
	[1.4870000000E+04, 7.2251881764E+00, 5.3010443293E+00, 6.9762960026E-01, 5.6802942157E-01, 6.7463395762E-01],
	[1.4875000000E+04, 7.2285281672E+00, 5.3007516224E+00, 6.9837448717E-01, 5.6854046274E-01, 6.7476733460E-01],
	[1.4880000000E+04, 7.2318685787E+00, 5.3004590300E+00, 6.9911991826E-01, 5.6905171424E-01, 6.7490067967E-01],
	[1.4885000000E+04, 7.2352094108E+00, 5.3001665520E+00, 6.9986589373E-01, 5.6956317595E-01, 6.7503399282E-01],
	[1.4890000000E+04, 7.2385506635E+00, 5.2998741884E+00, 7.0061241381E-01, 5.7007484775E-01, 6.7516727404E-01],
	[1.4895000000E+04, 7.2418923366E+00, 5.2995819391E+00, 7.0135947871E-01, 5.7058672951E-01, 6.7530052330E-01],
	[1.4900000000E+04, 7.2452344300E+00, 5.2992898039E+00, 7.0210708864E-01, 5.7109882112E-01, 6.7543374060E-01],
	[1.4905000000E+04, 7.2485769438E+00, 5.2989977829E+00, 7.0285524382E-01, 5.7161112246E-01, 6.7556692593E-01],
	[1.4910000000E+04, 7.2519198776E+00, 5.2987058759E+00, 7.0360394446E-01, 5.7212363340E-01, 6.7570007926E-01],
	[1.4915000000E+04, 7.2552632316E+00, 5.2984140829E+00, 7.0435319077E-01, 5.7263635384E-01, 6.7583320060E-01],
	[1.4920000000E+04, 7.2586070056E+00, 5.2981224037E+00, 7.0510298297E-01, 5.7314928363E-01, 6.7596628991E-01],
	[1.4925000000E+04, 7.2619511995E+00, 5.2978308383E+00, 7.0585332128E-01, 5.7366242267E-01, 6.7609934720E-01],
	[1.4930000000E+04, 7.2652958132E+00, 5.2975393866E+00, 7.0660420590E-01, 5.7417577083E-01, 6.7623237244E-01],
	[1.4935000000E+04, 7.2686408466E+00, 5.2972480485E+00, 7.0735563705E-01, 5.7468932799E-01, 6.7636536562E-01],
	[1.4940000000E+04, 7.2719862997E+00, 5.2969568239E+00, 7.0810761495E-01, 5.7520309404E-01, 6.7649832674E-01],
	[1.4945000000E+04, 7.2753321723E+00, 5.2966657128E+00, 7.0886013981E-01, 5.7571706884E-01, 6.7663125577E-01],
	[1.4950000000E+04, 7.2786784644E+00, 5.2963747151E+00, 7.0961321184E-01, 5.7623125228E-01, 6.7676415271E-01],
	[1.4955000000E+04, 7.2820251759E+00, 5.2960838306E+00, 7.1036683126E-01, 5.7674564423E-01, 6.7689701753E-01],
	[1.4960000000E+04, 7.2853723067E+00, 5.2957930594E+00, 7.1112099828E-01, 5.7726024458E-01, 6.7702985024E-01],
	[1.4965000000E+04, 7.2887198567E+00, 5.2955024012E+00, 7.1187571312E-01, 5.7777505319E-01, 6.7716265080E-01],
	[1.4970000000E+04, 7.2920678258E+00, 5.2952118561E+00, 7.1263097599E-01, 5.7829006996E-01, 6.7729541922E-01],
	[1.4975000000E+04, 7.2954162139E+00, 5.2949214240E+00, 7.1338678710E-01, 5.7880529475E-01, 6.7742815548E-01],
	[1.4980000000E+04, 7.2987650210E+00, 5.2946311048E+00, 7.1414314667E-01, 5.7932072745E-01, 6.7756085956E-01],
	[1.4985000000E+04, 7.3021142470E+00, 5.2943408983E+00, 7.1490005491E-01, 5.7983636793E-01, 6.7769353145E-01],
	[1.4990000000E+04, 7.3054638917E+00, 5.2940508046E+00, 7.1565751204E-01, 5.8035221607E-01, 6.7782617114E-01],
	[1.4995000000E+04, 7.3088139551E+00, 5.2937608235E+00, 7.1641551828E-01, 5.8086827174E-01, 6.7795877862E-01],
	[1.5000000000E+04, 7.3121644371E+00, 5.2934709549E+00, 7.1717407383E-01, 5.8138453483E-01, 6.7809135387E-01],
	[1.5005000000E+04, 7.3155153375E+00, 5.2931811988E+00, 7.1793538798E-01, 5.8190245645E-01, 6.7822389688E-01],
	[1.5010000000E+04, 7.3188666565E+00, 5.2928915551E+00, 7.1869725587E-01, 5.8242058687E-01, 6.7835640764E-01],
	[1.5015000000E+04, 7.3222183937E+00, 5.2926020238E+00, 7.1945967770E-01, 5.8293892596E-01, 6.7848888614E-01],
	[1.5020000000E+04, 7.3255705492E+00, 5.2923126046E+00, 7.2022265370E-01, 5.8345747360E-01, 6.7862133235E-01],
	[1.5025000000E+04, 7.3289231229E+00, 5.2920232976E+00, 7.2098618409E-01, 5.8397622966E-01, 6.7875374628E-01],
	[1.5030000000E+04, 7.3322761146E+00, 5.2917341027E+00, 7.2175026907E-01, 5.8449519402E-01, 6.7888612790E-01],
	[1.5035000000E+04, 7.3356295243E+00, 5.2914450197E+00, 7.2251490888E-01, 5.8501436656E-01, 6.7901847721E-01],
	[1.5040000000E+04, 7.3389833519E+00, 5.2911560487E+00, 7.2328010372E-01, 5.8553374715E-01, 6.7915079419E-01],
	[1.5045000000E+04, 7.3423375974E+00, 5.2908671894E+00, 7.2404585381E-01, 5.8605333566E-01, 6.7928307883E-01],
	[1.5050000000E+04, 7.3456922605E+00, 5.2905784420E+00, 7.2481215938E-01, 5.8657313197E-01, 6.7941533111E-01],
	[1.5055000000E+04, 7.3490578517E+00, 5.2902953544E+00, 7.2557902063E-01, 5.8709327136E-01, 6.7954755103E-01],
	[1.5060000000E+04, 7.3524241783E+00, 5.2900125404E+00, 7.2634643780E-01, 5.8761362270E-01, 6.7967973855E-01],
	[1.5065000000E+04, 7.3557909286E+00, 5.2897298354E+00, 7.2711441109E-01, 5.8813418186E-01, 6.7981189365E-01],
	[1.5070000000E+04, 7.3591581026E+00, 5.2894472393E+00, 7.2788294072E-01, 5.8865494872E-01, 6.7994401631E-01],
	[1.5075000000E+04, 7.3625257003E+00, 5.2891647521E+00, 7.2865202691E-01, 5.8917592314E-01, 6.8007610653E-01],
	[1.5080000000E+04, 7.3658937214E+00, 5.2888823736E+00, 7.2942166988E-01, 5.8969710500E-01, 6.8020816428E-01],
	[1.5085000000E+04, 7.3692621659E+00, 5.2886001038E+00, 7.3019186985E-01, 5.9021849418E-01, 6.8034018955E-01],
	[1.5090000000E+04, 7.3726310338E+00, 5.2883179426E+00, 7.3096262703E-01, 5.9074009056E-01, 6.8047218233E-01],
	[1.5095000000E+04, 7.3760003249E+00, 5.2880358899E+00, 7.3173394165E-01, 5.9126189399E-01, 6.8060414259E-01],
	[1.5100000000E+04, 7.3793700391E+00, 5.2877539456E+00, 7.3250581391E-01, 5.9178390437E-01, 6.8073607032E-01],
	[1.5105000000E+04, 7.3827401765E+00, 5.2874721098E+00, 7.3327824404E-01, 5.9230612157E-01, 6.8086796550E-01],
	[1.5110000000E+04, 7.3861107368E+00, 5.2871903822E+00, 7.3405123226E-01, 5.9282854545E-01, 6.8099982812E-01],
	[1.5115000000E+04, 7.3894817200E+00, 5.2869087628E+00, 7.3482477878E-01, 5.9335117590E-01, 6.8113165817E-01],
	[1.5120000000E+04, 7.3928531260E+00, 5.2866272516E+00, 7.3559888382E-01, 5.9387401278E-01, 6.8126345562E-01],
	[1.5125000000E+04, 7.3962249548E+00, 5.2863458484E+00, 7.3637354761E-01, 5.9439705597E-01, 6.8139522045E-01],
	[1.5130000000E+04, 7.3995972061E+00, 5.2860645532E+00, 7.3714877035E-01, 5.9492030534E-01, 6.8152695267E-01],
	[1.5135000000E+04, 7.4029698801E+00, 5.2857833660E+00, 7.3792455226E-01, 5.9544376078E-01, 6.8165865224E-01],
	[1.5140000000E+04, 7.4063429764E+00, 5.2855022865E+00, 7.3870089357E-01, 5.9596742214E-01, 6.8179031916E-01],
	[1.5145000000E+04, 7.4097164952E+00, 5.2852213148E+00, 7.3947779449E-01, 5.9649128931E-01, 6.8192195340E-01],
	[1.5150000000E+04, 7.4130904363E+00, 5.2849404508E+00, 7.4025525524E-01, 5.9701536215E-01, 6.8205355495E-01],
	[1.5155000000E+04, 7.4164647995E+00, 5.2846596943E+00, 7.4103327604E-01, 5.9753964054E-01, 6.8218512380E-01],
	[1.5160000000E+04, 7.4198395849E+00, 5.2843790454E+00, 7.4181185710E-01, 5.9806412436E-01, 6.8231665993E-01],
	[1.5165000000E+04, 7.4232147923E+00, 5.2840985040E+00, 7.4259099865E-01, 5.9858881347E-01, 6.8244816332E-01],
	[1.5170000000E+04, 7.4265904216E+00, 5.2838180699E+00, 7.4337070090E-01, 5.9911370774E-01, 6.8257963396E-01],
	[1.5175000000E+04, 7.4299664728E+00, 5.2835377431E+00, 7.4415096407E-01, 5.9963880706E-01, 6.8271107184E-01],
	[1.5180000000E+04, 7.4333429458E+00, 5.2832575235E+00, 7.4493178837E-01, 6.0016411129E-01, 6.8284247693E-01],
	[1.5185000000E+04, 7.4367198404E+00, 5.2829774110E+00, 7.4571317403E-01, 6.0068962030E-01, 6.8297384922E-01],
	[1.5190000000E+04, 7.4400971567E+00, 5.2826974056E+00, 7.4649512127E-01, 6.0121533397E-01, 6.8310518871E-01],
	[1.5195000000E+04, 7.4434748944E+00, 5.2824175072E+00, 7.4727763029E-01, 6.0174125217E-01, 6.8323649536E-01],
	[1.5200000000E+04, 7.4468530536E+00, 5.2821377157E+00, 7.4806070133E-01, 6.0226737477E-01, 6.8336776917E-01],
	[1.5205000000E+04, 7.4502316342E+00, 5.2818580310E+00, 7.4884433459E-01, 6.0279370164E-01, 6.8349901012E-01],
	[1.5210000000E+04, 7.4536106359E+00, 5.2815784531E+00, 7.4962853031E-01, 6.0332023265E-01, 6.8363021820E-01],
	[1.5215000000E+04, 7.4569900589E+00, 5.2812989819E+00, 7.5041328868E-01, 6.0384696768E-01, 6.8376139338E-01],
	[1.5220000000E+04, 7.4603699029E+00, 5.2810196173E+00, 7.5119860994E-01, 6.0437390659E-01, 6.8389253566E-01],
	[1.5225000000E+04, 7.4637501679E+00, 5.2807403592E+00, 7.5198449430E-01, 6.0490104926E-01, 6.8402364503E-01],
	[1.5230000000E+04, 7.4671308539E+00, 5.2804612076E+00, 7.5277094198E-01, 6.0542839556E-01, 6.8415472145E-01],
	[1.5235000000E+04, 7.4705119606E+00, 5.2801821623E+00, 7.5355795319E-01, 6.0595594535E-01, 6.8428576493E-01],
	[1.5240000000E+04, 7.4738934881E+00, 5.2799032234E+00, 7.5434552817E-01, 6.0648369852E-01, 6.8441677544E-01],
	[1.5245000000E+04, 7.4772754363E+00, 5.2796243906E+00, 7.5513366711E-01, 6.0701165492E-01, 6.8454775297E-01],
	[1.5250000000E+04, 7.4806578050E+00, 5.2793456641E+00, 7.5592237025E-01, 6.0753981444E-01, 6.8467869751E-01],
	[1.5255000000E+04, 7.4840405942E+00, 5.2790670436E+00, 7.5671163779E-01, 6.0806817694E-01, 6.8480960904E-01],
	[1.5260000000E+04, 7.4874238037E+00, 5.2787885291E+00, 7.5750146997E-01, 6.0859674229E-01, 6.8494048754E-01],
	[1.5265000000E+04, 7.4908074336E+00, 5.2785101206E+00, 7.5829186699E-01, 6.0912551036E-01, 6.8507133301E-01],
	[1.5270000000E+04, 7.4941914838E+00, 5.2782318178E+00, 7.5908282908E-01, 6.0965448102E-01, 6.8520214542E-01],
	[1.5275000000E+04, 7.4975759540E+00, 5.2779536209E+00, 7.5987435645E-01, 6.1018365414E-01, 6.8533292476E-01],
	[1.5280000000E+04, 7.5009608443E+00, 5.2776755297E+00, 7.6066644932E-01, 6.1071302960E-01, 6.8546367101E-01],
	[1.5285000000E+04, 7.5043461546E+00, 5.2773975441E+00, 7.6145910792E-01, 6.1124260725E-01, 6.8559438417E-01],
	[1.5290000000E+04, 7.5077318848E+00, 5.2771196641E+00, 7.6225233245E-01, 6.1177238698E-01, 6.8572506422E-01],
	[1.5295000000E+04, 7.5111238389E+00, 5.2768447844E+00, 7.6304612314E-01, 6.1230244619E-01, 6.8585571114E-01],
	[1.5300000000E+04, 7.5145217090E+00, 5.2765727472E+00, 7.6384048020E-01, 6.1283278090E-01, 6.8598632491E-01],
	[1.5305000000E+04, 7.5179200052E+00, 5.2763008129E+00, 7.6463540386E-01, 6.1336331770E-01, 6.8611690553E-01],
	[1.5310000000E+04, 7.5213187276E+00, 5.2760289815E+00, 7.6543089432E-01, 6.1389405646E-01, 6.8624745298E-01],
	[1.5315000000E+04, 7.5247178758E+00, 5.2757572528E+00, 7.6622695182E-01, 6.1442499705E-01, 6.8637796724E-01],
	[1.5320000000E+04, 7.5281174500E+00, 5.2754856268E+00, 7.6702357657E-01, 6.1495613934E-01, 6.8650844830E-01],
	[1.5325000000E+04, 7.5315174499E+00, 5.2752141034E+00, 7.6782076878E-01, 6.1548748321E-01, 6.8663889615E-01],
	[1.5330000000E+04, 7.5349178756E+00, 5.2749426826E+00, 7.6861852868E-01, 6.1601902851E-01, 6.8676931077E-01],
	[1.5335000000E+04, 7.5383187268E+00, 5.2746713642E+00, 7.6941685649E-01, 6.1655077512E-01, 6.8689969215E-01],
	[1.5340000000E+04, 7.5417200037E+00, 5.2744001482E+00, 7.7021575242E-01, 6.1708272290E-01, 6.8703004027E-01],
	[1.5345000000E+04, 7.5451217059E+00, 5.2741290346E+00, 7.7101521668E-01, 6.1761487173E-01, 6.8716035512E-01],
	[1.5350000000E+04, 7.5485238335E+00, 5.2738580232E+00, 7.7181524951E-01, 6.1814722148E-01, 6.8729063668E-01],
	[1.5355000000E+04, 7.5519263864E+00, 5.2735871139E+00, 7.7261585112E-01, 6.1867977201E-01, 6.8742088494E-01],
	[1.5360000000E+04, 7.5553293645E+00, 5.2733163068E+00, 7.7341702172E-01, 6.1921252319E-01, 6.8755109989E-01],
	[1.5365000000E+04, 7.5587327678E+00, 5.2730456018E+00, 7.7421876154E-01, 6.1974547488E-01, 6.8768128151E-01],
	[1.5370000000E+04, 7.5621365960E+00, 5.2727749987E+00, 7.7502107079E-01, 6.2027862697E-01, 6.8781142979E-01],
	[1.5375000000E+04, 7.5655408492E+00, 5.2725044975E+00, 7.7582394969E-01, 6.2081197931E-01, 6.8794154471E-01],
	[1.5380000000E+04, 7.5689455272E+00, 5.2722340981E+00, 7.7662739846E-01, 6.2134553177E-01, 6.8807162627E-01],
	[1.5385000000E+04, 7.5723506300E+00, 5.2719638004E+00, 7.7743141732E-01, 6.2187928423E-01, 6.8820167444E-01],
	[1.5390000000E+04, 7.5757561575E+00, 5.2716936045E+00, 7.7823600650E-01, 6.2241323654E-01, 6.8833168921E-01],
	[1.5395000000E+04, 7.5791621095E+00, 5.2714235102E+00, 7.7904116619E-01, 6.2294738858E-01, 6.8846167057E-01],
	[1.5400000000E+04, 7.5825684861E+00, 5.2711535174E+00, 7.7984689664E-01, 6.2348174021E-01, 6.8859161850E-01],
	[1.5405000000E+04, 7.5859752871E+00, 5.2708836260E+00, 7.8065319804E-01, 6.2401629131E-01, 6.8872153300E-01],
	[1.5410000000E+04, 7.5893825125E+00, 5.2706138361E+00, 7.8146007063E-01, 6.2455104173E-01, 6.8885141404E-01],
	[1.5415000000E+04, 7.5927901621E+00, 5.2703441475E+00, 7.8226751462E-01, 6.2508599134E-01, 6.8898126162E-01],
	[1.5420000000E+04, 7.5961982359E+00, 5.2700745601E+00, 7.8307553023E-01, 6.2562114002E-01, 6.8911107572E-01],
	[1.5425000000E+04, 7.5996067338E+00, 5.2698050740E+00, 7.8388411768E-01, 6.2615648763E-01, 6.8924085632E-01],
	[1.5430000000E+04, 7.6030156557E+00, 5.2695356889E+00, 7.8469327718E-01, 6.2669203403E-01, 6.8937060342E-01],
	[1.5435000000E+04, 7.6064250015E+00, 5.2692664049E+00, 7.8550300896E-01, 6.2722777909E-01, 6.8950031699E-01],
	[1.5440000000E+04, 7.6098347712E+00, 5.2689972218E+00, 7.8631331324E-01, 6.2776372269E-01, 6.8962999703E-01],
	[1.5445000000E+04, 7.6132449645E+00, 5.2687281397E+00, 7.8712419023E-01, 6.2829986467E-01, 6.8975964353E-01],
	[1.5450000000E+04, 7.6166555816E+00, 5.2684591584E+00, 7.8793564015E-01, 6.2883620492E-01, 6.8988925646E-01],
	[1.5455000000E+04, 7.6200666223E+00, 5.2681902778E+00, 7.8874766322E-01, 6.2937274329E-01, 6.9001883581E-01],
	[1.5460000000E+04, 7.6234780864E+00, 5.2679214980E+00, 7.8956025966E-01, 6.2990947966E-01, 6.9014838158E-01],
	[1.5465000000E+04, 7.6268899739E+00, 5.2676528187E+00, 7.9037342969E-01, 6.3044641389E-01, 6.9027789375E-01],
	[1.5470000000E+04, 7.6303022848E+00, 5.2673842400E+00, 7.9118717353E-01, 6.3098354584E-01, 6.9040737230E-01],
	[1.5475000000E+04, 7.6337150190E+00, 5.2671157618E+00, 7.9200149139E-01, 6.3152087538E-01, 6.9053681723E-01],
	[1.5480000000E+04, 7.6371281762E+00, 5.2668473840E+00, 7.9281638350E-01, 6.3205840237E-01, 6.9066622851E-01],
	[1.5485000000E+04, 7.6405417566E+00, 5.2665791066E+00, 7.9363185007E-01, 6.3259612669E-01, 6.9079560614E-01],
	[1.5490000000E+04, 7.6439557599E+00, 5.2663109294E+00, 7.9444789132E-01, 6.3313404819E-01, 6.9092495011E-01],
	[1.5495000000E+04, 7.6473701862E+00, 5.2660428524E+00, 7.9526450748E-01, 6.3367216675E-01, 6.9105426039E-01],
	[1.5500000000E+04, 7.6507850353E+00, 5.2657748755E+00, 7.9608169875E-01, 6.3421048222E-01, 6.9118353698E-01],
	[1.5505000000E+04, 7.6542003071E+00, 5.2655069987E+00, 7.9689946537E-01, 6.3474899447E-01, 6.9131277986E-01],
	[1.5510000000E+04, 7.6576160016E+00, 5.2652392219E+00, 7.9771780754E-01, 6.3528770337E-01, 6.9144198902E-01],
	[1.5515000000E+04, 7.6610321186E+00, 5.2649715450E+00, 7.9853672549E-01, 6.3582660878E-01, 6.9157116446E-01],
	[1.5520000000E+04, 7.6644486582E+00, 5.2647039680E+00, 7.9935621943E-01, 6.3636571056E-01, 6.9170030614E-01],
	[1.5525000000E+04, 7.6678656201E+00, 5.2644364907E+00, 8.0017628959E-01, 6.3690500859E-01, 6.9182941407E-01],
	[1.5530000000E+04, 7.6712830044E+00, 5.2641691132E+00, 8.0099693618E-01, 6.3744450272E-01, 6.9195848822E-01],
	[1.5535000000E+04, 7.6747008109E+00, 5.2639018353E+00, 8.0181815943E-01, 6.3798419281E-01, 6.9208752860E-01],
	[1.5540000000E+04, 7.6781222944E+00, 5.2636361928E+00, 8.0263995955E-01, 6.3852412385E-01, 6.9221653517E-01],
	[1.5545000000E+04, 7.6815527263E+00, 5.2633746695E+00, 8.0346233675E-01, 6.3906436898E-01, 6.9234550794E-01],
	[1.5550000000E+04, 7.6849835868E+00, 5.2631132433E+00, 8.0428529127E-01, 6.3960481010E-01, 6.9247444688E-01],
	[1.5555000000E+04, 7.6884148760E+00, 5.2628519142E+00, 8.0510882332E-01, 6.4014544709E-01, 6.9260335199E-01],
	[1.5560000000E+04, 7.6918465937E+00, 5.2625906820E+00, 8.0593293311E-01, 6.4068627980E-01, 6.9273222325E-01],
	[1.5565000000E+04, 7.6952787399E+00, 5.2623295466E+00, 8.0675762087E-01, 6.4122730809E-01, 6.9286106065E-01],
	[1.5570000000E+04, 7.6987113144E+00, 5.2620685082E+00, 8.0758288681E-01, 6.4176853184E-01, 6.9298986418E-01],
	[1.5575000000E+04, 7.7021443172E+00, 5.2618075664E+00, 8.0840873116E-01, 6.4230995091E-01, 6.9311863383E-01],
	[1.5580000000E+04, 7.7055777482E+00, 5.2615467214E+00, 8.0923515414E-01, 6.4285156515E-01, 6.9324736957E-01],
	[1.5585000000E+04, 7.7090116073E+00, 5.2612859730E+00, 8.1006215595E-01, 6.4339337444E-01, 6.9337607141E-01],
	[1.5590000000E+04, 7.7124458945E+00, 5.2610253211E+00, 8.1088973683E-01, 6.4393537864E-01, 6.9350473932E-01],
	[1.5595000000E+04, 7.7158806096E+00, 5.2607647657E+00, 8.1171789699E-01, 6.4447757761E-01, 6.9363337330E-01],
	[1.5600000000E+04, 7.7193157525E+00, 5.2605043068E+00, 8.1254663665E-01, 6.4501997121E-01, 6.9376197334E-01],
	[1.5605000000E+04, 7.7227513232E+00, 5.2602439442E+00, 8.1337595603E-01, 6.4556255931E-01, 6.9389053941E-01],
	[1.5610000000E+04, 7.7261873216E+00, 5.2599836779E+00, 8.1420585534E-01, 6.4610534177E-01, 6.9401907151E-01],
	[1.5615000000E+04, 7.7296237476E+00, 5.2597235078E+00, 8.1503633482E-01, 6.4664831845E-01, 6.9414756963E-01],
	[1.5620000000E+04, 7.7330606011E+00, 5.2594634338E+00, 8.1586739467E-01, 6.4719148922E-01, 6.9427603375E-01],
	[1.5625000000E+04, 7.7364978821E+00, 5.2592034560E+00, 8.1669903512E-01, 6.4773485394E-01, 6.9440446387E-01],
	[1.5630000000E+04, 7.7399355904E+00, 5.2589435742E+00, 8.1753125638E-01, 6.4827841247E-01, 6.9453285996E-01],
	[1.5635000000E+04, 7.7433737260E+00, 5.2586837883E+00, 8.1836405867E-01, 6.4882216467E-01, 6.9466122202E-01],
	[1.5640000000E+04, 7.7468122888E+00, 5.2584240984E+00, 8.1919744222E-01, 6.4936611041E-01, 6.9478955004E-01],
	[1.5645000000E+04, 7.7502512787E+00, 5.2581645042E+00, 8.2003140725E-01, 6.4991024955E-01, 6.9491784400E-01],
	[1.5650000000E+04, 7.7536906956E+00, 5.2579050059E+00, 8.2086595396E-01, 6.5045458195E-01, 6.9504610389E-01],
	[1.5655000000E+04, 7.7571305395E+00, 5.2576456032E+00, 8.2170108259E-01, 6.5099910747E-01, 6.9517432970E-01],
	[1.5660000000E+04, 7.7605708102E+00, 5.2573862961E+00, 8.2253679334E-01, 6.5154382597E-01, 6.9530252142E-01],
	[1.5665000000E+04, 7.7640115077E+00, 5.2571270846E+00, 8.2337308645E-01, 6.5208873732E-01, 6.9543067904E-01],
	[1.5670000000E+04, 7.7674526318E+00, 5.2568679686E+00, 8.2420996212E-01, 6.5263384138E-01, 6.9555880253E-01],
	[1.5675000000E+04, 7.7708941826E+00, 5.2566089481E+00, 8.2504742058E-01, 6.5317913801E-01, 6.9568689191E-01],
	[1.5680000000E+04, 7.7743361599E+00, 5.2563500229E+00, 8.2588546205E-01, 6.5372462707E-01, 6.9581494714E-01],
	[1.5685000000E+04, 7.7777785636E+00, 5.2560911930E+00, 8.2672408675E-01, 6.5427030843E-01, 6.9594296822E-01],
	[1.5690000000E+04, 7.7812213937E+00, 5.2558324583E+00, 8.2756329489E-01, 6.5481618194E-01, 6.9607095514E-01],
	[1.5695000000E+04, 7.7846646500E+00, 5.2555738188E+00, 8.2840308670E-01, 6.5536224746E-01, 6.9619890788E-01],
	[1.5700000000E+04, 7.7881083326E+00, 5.2553152744E+00, 8.2924346240E-01, 6.5590850486E-01, 6.9632682644E-01],
	[1.5705000000E+04, 7.7915524412E+00, 5.2550568251E+00, 8.3008442219E-01, 6.5645495399E-01, 6.9645471079E-01],
	[1.5710000000E+04, 7.7949969759E+00, 5.2547984707E+00, 8.3092596632E-01, 6.5700159472E-01, 6.9658256094E-01],
	[1.5715000000E+04, 7.7984419365E+00, 5.2545402112E+00, 8.3176809498E-01, 6.5754842691E-01, 6.9671037687E-01],
	[1.5720000000E+04, 7.8018873230E+00, 5.2542820466E+00, 8.3261080841E-01, 6.5809545042E-01, 6.9683815857E-01],
	[1.5725000000E+04, 7.8053331352E+00, 5.2540239768E+00, 8.3345410682E-01, 6.5864266511E-01, 6.9696590602E-01],
	[1.5730000000E+04, 7.8087793732E+00, 5.2537660016E+00, 8.3429799043E-01, 6.5919007084E-01, 6.9709361922E-01],
	[1.5735000000E+04, 7.8122260367E+00, 5.2535081211E+00, 8.3514245946E-01, 6.5973766747E-01, 6.9722129815E-01],
	[1.5740000000E+04, 7.8156731258E+00, 5.2532503352E+00, 8.3598751413E-01, 6.6028545486E-01, 6.9734894280E-01],
	[1.5745000000E+04, 7.8191206403E+00, 5.2529926438E+00, 8.3683315466E-01, 6.6083343287E-01, 6.9747655317E-01],
	[1.5750000000E+04, 7.8225685802E+00, 5.2527350469E+00, 8.3767938127E-01, 6.6138160136E-01, 6.9760412923E-01],
	[1.5755000000E+04, 7.8260169453E+00, 5.2524775444E+00, 8.3852619418E-01, 6.6192996019E-01, 6.9773167098E-01],
	[1.5760000000E+04, 7.8294657357E+00, 5.2522201362E+00, 8.3937359361E-01, 6.6247850922E-01, 6.9785917841E-01],
	[1.5765000000E+04, 7.8329149511E+00, 5.2519628222E+00, 8.4022157977E-01, 6.6302724831E-01, 6.9798665150E-01],
	[1.5770000000E+04, 7.8363645916E+00, 5.2517056025E+00, 8.4107015289E-01, 6.6357617732E-01, 6.9811409025E-01],
	[1.5775000000E+04, 7.8398146571E+00, 5.2514484768E+00, 8.4191931319E-01, 6.6412529611E-01, 6.9824149465E-01],
	[1.5780000000E+04, 7.8432651474E+00, 5.2511914453E+00, 8.4276906089E-01, 6.6467460454E-01, 6.9836886467E-01],
	[1.5785000000E+04, 7.8467160625E+00, 5.2509345077E+00, 8.4361939620E-01, 6.6522410246E-01, 6.9849620032E-01],
	[1.5790000000E+04, 7.8501704227E+00, 5.2506790139E+00, 8.4447031935E-01, 6.6577383316E-01, 6.9862350158E-01],
	[1.5795000000E+04, 7.8536344568E+00, 5.2504277440E+00, 8.4532183055E-01, 6.6632388629E-01, 6.9875076843E-01],
	[1.5800000000E+04, 7.8570989223E+00, 5.2501765656E+00, 8.4617393002E-01, 6.6687412895E-01, 6.9887800088E-01],
	[1.5805000000E+04, 7.8605638192E+00, 5.2499254788E+00, 8.4702661799E-01, 6.6742456099E-01, 6.9900519890E-01],
	[1.5810000000E+04, 7.8640291474E+00, 5.2496744833E+00, 8.4787989468E-01, 6.6797518229E-01, 6.9913236249E-01],
	[1.5815000000E+04, 7.8674949068E+00, 5.2494235792E+00, 8.4873376030E-01, 6.6852599270E-01, 6.9925949164E-01],
	[1.5820000000E+04, 7.8709610973E+00, 5.2491727664E+00, 8.4958821507E-01, 6.6907699208E-01, 6.9938658633E-01],
	[1.5825000000E+04, 7.8744277189E+00, 5.2489220448E+00, 8.5044325921E-01, 6.6962818028E-01, 6.9951364656E-01],
	[1.5830000000E+04, 7.8778947714E+00, 5.2486714144E+00, 8.5129889295E-01, 6.7017955717E-01, 6.9964067231E-01],
	[1.5835000000E+04, 7.8813622548E+00, 5.2484208752E+00, 8.5215511650E-01, 6.7073112261E-01, 6.9976766358E-01],
	[1.5840000000E+04, 7.8848301690E+00, 5.2481704269E+00, 8.5301193008E-01, 6.7128287644E-01, 6.9989462034E-01],
	[1.5845000000E+04, 7.8882985140E+00, 5.2479200697E+00, 8.5386933391E-01, 6.7183481855E-01, 7.0002154260E-01],
	[1.5850000000E+04, 7.8917672895E+00, 5.2476698034E+00, 8.5472732821E-01, 6.7238694877E-01, 7.0014843034E-01],
	[1.5855000000E+04, 7.8952364956E+00, 5.2474196279E+00, 8.5558591321E-01, 6.7293926697E-01, 7.0027528355E-01],
	[1.5860000000E+04, 7.8987061322E+00, 5.2471695433E+00, 8.5644508911E-01, 6.7349177300E-01, 7.0040210222E-01],
	[1.5865000000E+04, 7.9021761991E+00, 5.2469195494E+00, 8.5730485615E-01, 6.7404446673E-01, 7.0052888634E-01],
	[1.5870000000E+04, 7.9056466964E+00, 5.2466696462E+00, 8.5816521453E-01, 6.7459734801E-01, 7.0065563590E-01],
	[1.5875000000E+04, 7.9091176238E+00, 5.2464198336E+00, 8.5902616449E-01, 6.7515041671E-01, 7.0078235089E-01],
	[1.5880000000E+04, 7.9125889814E+00, 5.2461701115E+00, 8.5988770624E-01, 6.7570367267E-01, 7.0090903130E-01],
	[1.5885000000E+04, 7.9160607691E+00, 5.2459204800E+00, 8.6074983999E-01, 6.7625711576E-01, 7.0103567712E-01],
	[1.5890000000E+04, 7.9195329867E+00, 5.2456709389E+00, 8.6161256598E-01, 6.7681074583E-01, 7.0116228833E-01],
	[1.5895000000E+04, 7.9230056342E+00, 5.2454214881E+00, 8.6247588441E-01, 6.7736456274E-01, 7.0128886493E-01],
	[1.5900000000E+04, 7.9264787116E+00, 5.2451721277E+00, 8.6333979552E-01, 6.7791856635E-01, 7.0141540691E-01],
	[1.5905000000E+04, 7.9299522186E+00, 5.2449228575E+00, 8.6420429951E-01, 6.7847275651E-01, 7.0154191426E-01],
	[1.5910000000E+04, 7.9334261553E+00, 5.2446736775E+00, 8.6506939661E-01, 6.7902713309E-01, 7.0166838697E-01],
	[1.5915000000E+04, 7.9369005216E+00, 5.2444245877E+00, 8.6593508704E-01, 6.7958169593E-01, 7.0179482502E-01],
	[1.5920000000E+04, 7.9403753173E+00, 5.2441755879E+00, 8.6680137102E-01, 6.8013644491E-01, 7.0192122840E-01],
	[1.5925000000E+04, 7.9438505425E+00, 5.2439266781E+00, 8.6766824877E-01, 6.8069137986E-01, 7.0204759712E-01],
	[1.5930000000E+04, 7.9473261969E+00, 5.2436778583E+00, 8.6853572051E-01, 6.8124650066E-01, 7.0217393115E-01],
	[1.5935000000E+04, 7.9508022806E+00, 5.2434291283E+00, 8.6940378645E-01, 6.8180180715E-01, 7.0230023049E-01],
	[1.5940000000E+04, 7.9542787935E+00, 5.2431804882E+00, 8.7027244683E-01, 6.8235729919E-01, 7.0242649512E-01],
	[1.5945000000E+04, 7.9577557354E+00, 5.2429319379E+00, 8.7114170185E-01, 6.8291297664E-01, 7.0255272504E-01],
	[1.5950000000E+04, 7.9612331063E+00, 5.2426834772E+00, 8.7201155174E-01, 6.8346883936E-01, 7.0267892024E-01],
	[1.5955000000E+04, 7.9647109061E+00, 5.2424351062E+00, 8.7288199672E-01, 6.8402488720E-01, 7.0280508071E-01],
	[1.5960000000E+04, 7.9681891348E+00, 5.2421868248E+00, 8.7375303700E-01, 6.8458112002E-01, 7.0293120643E-01],
	[1.5965000000E+04, 7.9716677922E+00, 5.2419386329E+00, 8.7462467282E-01, 6.8513753767E-01, 7.0305729740E-01],
	[1.5970000000E+04, 7.9751468782E+00, 5.2416905304E+00, 8.7549690438E-01, 6.8569414001E-01, 7.0318335361E-01],
	[1.5975000000E+04, 7.9786263929E+00, 5.2414425174E+00, 8.7636973192E-01, 6.8625092690E-01, 7.0330937502E-01],
	[1.5980000000E+04, 7.9821063360E+00, 5.2411945937E+00, 8.7724315564E-01, 6.8680789818E-01, 7.0343536165E-01],
	[1.5985000000E+04, 7.9855867076E+00, 5.2409467593E+00, 8.7811717576E-01, 6.8736505372E-01, 7.0356131346E-01],
	[1.5990000000E+04, 7.9890675075E+00, 5.2406990141E+00, 8.7899179252E-01, 6.8792239338E-01, 7.0368723045E-01],
	[1.5995000000E+04, 7.9925487357E+00, 5.2404513581E+00, 8.7986700613E-01, 6.8847991700E-01, 7.0381311260E-01],
	[1.6000000000E+04, 7.9960303920E+00, 5.2402037912E+00, 8.8074281680E-01, 6.8903762445E-01, 7.0393895991E-01],
	[1.6005000000E+04, 7.9995124764E+00, 5.2399563133E+00, 8.8161922476E-01, 6.8959551557E-01, 7.0406477236E-01],
	[1.6010000000E+04, 8.0029949889E+00, 5.2397089244E+00, 8.8249623024E-01, 6.9015359022E-01, 7.0419054993E-01],
	[1.6015000000E+04, 8.0064779293E+00, 5.2394616244E+00, 8.8337383344E-01, 6.9071184827E-01, 7.0431629262E-01],
	[1.6020000000E+04, 8.0099612975E+00, 5.2392144133E+00, 8.8425203459E-01, 6.9127028955E-01, 7.0444200042E-01],
	[1.6025000000E+04, 8.0134450935E+00, 5.2389672910E+00, 8.8513083390E-01, 6.9182891393E-01, 7.0456767331E-01],
	[1.6030000000E+04, 8.0169293172E+00, 5.2387202574E+00, 8.8601023161E-01, 6.9238772127E-01, 7.0469331127E-01],
	[1.6035000000E+04, 8.0204139685E+00, 5.2384733126E+00, 8.8689022793E-01, 6.9294671141E-01, 7.0481891431E-01],
	[1.6040000000E+04, 8.0238990473E+00, 5.2382264563E+00, 8.8777082308E-01, 6.9350588421E-01, 7.0494448239E-01],
	[1.6045000000E+04, 8.0273897949E+00, 5.2379819092E+00, 8.8865201728E-01, 6.9406531770E-01, 7.0507001552E-01],
	[1.6050000000E+04, 8.0308884947E+00, 5.2377406349E+00, 8.8953381074E-01, 6.9462504605E-01, 7.0519551368E-01],
	[1.6055000000E+04, 8.0343876289E+00, 5.2374994468E+00, 8.9041620370E-01, 6.9518495710E-01, 7.0532097686E-01],
	[1.6060000000E+04, 8.0378871975E+00, 5.2372583450E+00, 8.9129919637E-01, 6.9574505072E-01, 7.0544640505E-01],
	[1.6065000000E+04, 8.0413872003E+00, 5.2370173293E+00, 8.9218278897E-01, 6.9630532674E-01, 7.0557179822E-01],
	[1.6070000000E+04, 8.0448876372E+00, 5.2367763996E+00, 8.9306698172E-01, 6.9686578504E-01, 7.0569715639E-01],
	[1.6075000000E+04, 8.0483885083E+00, 5.2365355561E+00, 8.9395177484E-01, 6.9742642546E-01, 7.0582247952E-01],
	[1.6080000000E+04, 8.0518898133E+00, 5.2362947985E+00, 8.9483716855E-01, 6.9798724785E-01, 7.0594776761E-01],
	[1.6085000000E+04, 8.0553915523E+00, 5.2360541268E+00, 8.9572316308E-01, 6.9854825208E-01, 7.0607302065E-01],
	[1.6090000000E+04, 8.0588937251E+00, 5.2358135409E+00, 8.9660975864E-01, 6.9910943799E-01, 7.0619823862E-01],
	[1.6095000000E+04, 8.0623963317E+00, 5.2355730409E+00, 8.9749695545E-01, 6.9967080544E-01, 7.0632342152E-01],
	[1.6100000000E+04, 8.0658993719E+00, 5.2353326266E+00, 8.9838475373E-01, 7.0023235428E-01, 7.0644856933E-01],
	[1.6105000000E+04, 8.0694028458E+00, 5.2350922980E+00, 8.9927315370E-01, 7.0079408437E-01, 7.0657368204E-01],
	[1.6110000000E+04, 8.0729067531E+00, 5.2348520550E+00, 9.0016215559E-01, 7.0135599556E-01, 7.0669875964E-01],
	[1.6115000000E+04, 8.0764110940E+00, 5.2346118976E+00, 9.0105175962E-01, 7.0191808770E-01, 7.0682380211E-01],
	[1.6120000000E+04, 8.0799158681E+00, 5.2343718257E+00, 9.0194196599E-01, 7.0248036065E-01, 7.0694880945E-01],
	[1.6125000000E+04, 8.0834210756E+00, 5.2341318392E+00, 9.0283277495E-01, 7.0304281426E-01, 7.0707378164E-01],
	[1.6130000000E+04, 8.0869267162E+00, 5.2338919382E+00, 9.0372418669E-01, 7.0360544839E-01, 7.0719871868E-01],
	[1.6135000000E+04, 8.0904327900E+00, 5.2336521225E+00, 9.0461620146E-01, 7.0416826288E-01, 7.0732362055E-01],
	[1.6140000000E+04, 8.0939392967E+00, 5.2334123921E+00, 9.0550881945E-01, 7.0473125759E-01, 7.0744848724E-01],
	[1.6145000000E+04, 8.0974462365E+00, 5.2331727469E+00, 9.0640204091E-01, 7.0529443237E-01, 7.0757331873E-01],
	[1.6150000000E+04, 8.1009536091E+00, 5.2329331869E+00, 9.0729586604E-01, 7.0585778708E-01, 7.0769811502E-01],
	[1.6155000000E+04, 8.1044614145E+00, 5.2326937120E+00, 9.0819029507E-01, 7.0642132157E-01, 7.0782287610E-01],
	[1.6160000000E+04, 8.1079696526E+00, 5.2324543222E+00, 9.0908532821E-01, 7.0698503569E-01, 7.0794760195E-01],
	[1.6165000000E+04, 8.1114783233E+00, 5.2322150174E+00, 9.0998096570E-01, 7.0754892930E-01, 7.0807229257E-01],
	[1.6170000000E+04, 8.1149874266E+00, 5.2319757975E+00, 9.1087720774E-01, 7.0811300224E-01, 7.0819694793E-01],
	[1.6175000000E+04, 8.1184969624E+00, 5.2317366625E+00, 9.1177405456E-01, 7.0867725437E-01, 7.0832156804E-01],
	[1.6180000000E+04, 8.1220069306E+00, 5.2314976124E+00, 9.1267150638E-01, 7.0924168554E-01, 7.0844615288E-01],
	[1.6185000000E+04, 8.1255173310E+00, 5.2312586470E+00, 9.1356956342E-01, 7.0980629560E-01, 7.0857070244E-01],
	[1.6190000000E+04, 8.1290281637E+00, 5.2310197664E+00, 9.1446822591E-01, 7.1037108441E-01, 7.0869521670E-01],
	[1.6195000000E+04, 8.1325394285E+00, 5.2307809704E+00, 9.1536749405E-01, 7.1093605181E-01, 7.0881969566E-01],
	[1.6200000000E+04, 8.1360511254E+00, 5.2305422590E+00, 9.1626736807E-01, 7.1150119767E-01, 7.0894413931E-01],
	[1.6205000000E+04, 8.1395632543E+00, 5.2303036322E+00, 9.1716784820E-01, 7.1206652183E-01, 7.0906854763E-01],
	[1.6210000000E+04, 8.1430758151E+00, 5.2300650899E+00, 9.1806893465E-01, 7.1263202414E-01, 7.0919292061E-01],
	[1.6215000000E+04, 8.1465888078E+00, 5.2298266320E+00, 9.1897062765E-01, 7.1319770445E-01, 7.0931725825E-01],
	[1.6220000000E+04, 8.1501022321E+00, 5.2295882585E+00, 9.1987292740E-01, 7.1376356262E-01, 7.0944156053E-01],
	[1.6225000000E+04, 8.1536160882E+00, 5.2293499693E+00, 9.2077583415E-01, 7.1432959850E-01, 7.0956582744E-01],
	[1.6230000000E+04, 8.1571303758E+00, 5.2291117644E+00, 9.2167934810E-01, 7.1489581193E-01, 7.0969005897E-01],
	[1.6235000000E+04, 8.1606450950E+00, 5.2288736438E+00, 9.2258346947E-01, 7.1546220278E-01, 7.0981425511E-01],
	[1.6240000000E+04, 8.1641602455E+00, 5.2286356072E+00, 9.2348819849E-01, 7.1602877089E-01, 7.0993841585E-01],
	[1.6245000000E+04, 8.1676758274E+00, 5.2283976548E+00, 9.2439353538E-01, 7.1659551611E-01, 7.1006254118E-01],
	[1.6250000000E+04, 8.1711918406E+00, 5.2281597865E+00, 9.2529948036E-01, 7.1716243829E-01, 7.1018663109E-01],
	[1.6255000000E+04, 8.1747082850E+00, 5.2279220021E+00, 9.2620603364E-01, 7.1772953729E-01, 7.1031068557E-01],
	[1.6260000000E+04, 8.1782251604E+00, 5.2276843017E+00, 9.2711319546E-01, 7.1829681295E-01, 7.1043470460E-01],
	[1.6265000000E+04, 8.1817424669E+00, 5.2274466852E+00, 9.2802096602E-01, 7.1886426513E-01, 7.1055868818E-01],
	[1.6270000000E+04, 8.1852602044E+00, 5.2272091525E+00, 9.2892934556E-01, 7.1943189368E-01, 7.1068263629E-01],
	[1.6275000000E+04, 8.1887783727E+00, 5.2269717036E+00, 9.2983833428E-01, 7.1999969844E-01, 7.1080654894E-01],
	[1.6280000000E+04, 8.1922969718E+00, 5.2267343384E+00, 9.3074793242E-01, 7.2056767927E-01, 7.1093042609E-01],
	[1.6285000000E+04, 8.1958160016E+00, 5.2264970568E+00, 9.3165814020E-01, 7.2113583602E-01, 7.1105426775E-01],
	[1.6290000000E+04, 8.1993354621E+00, 5.2262598589E+00, 9.3256895782E-01, 7.2170416854E-01, 7.1117807391E-01],
	[1.6295000000E+04, 8.2028553531E+00, 5.2260227445E+00, 9.3348038553E-01, 7.2227267667E-01, 7.1130184455E-01],
	[1.6300000000E+04, 8.2063756746E+00, 5.2257857136E+00, 9.3439242352E-01, 7.2284136027E-01, 7.1142557966E-01],
	[1.6305000000E+04, 8.2099064650E+00, 5.2255528019E+00, 9.3530507204E-01, 7.2341037448E-01, 7.1154927924E-01],
	[1.6310000000E+04, 8.2134409181E+00, 5.2253212686E+00, 9.3621833129E-01, 7.2397961420E-01, 7.1167294327E-01],
	[1.6315000000E+04, 8.2169758087E+00, 5.2250898165E+00, 9.3713220149E-01, 7.2454902944E-01, 7.1179657175E-01],
	[1.6320000000E+04, 8.2205111368E+00, 5.2248584456E+00, 9.3804668288E-01, 7.2511862005E-01, 7.1192016465E-01],
	[1.6325000000E+04, 8.2240469023E+00, 5.2246271558E+00, 9.3896177567E-01, 7.2568838588E-01, 7.1204372199E-01],
	[1.6330000000E+04, 8.2275831051E+00, 5.2243959471E+00, 9.3987748008E-01, 7.2625832679E-01, 7.1216724373E-01],
	[1.6335000000E+04, 8.2311197452E+00, 5.2241648194E+00, 9.4079379633E-01, 7.2682844262E-01, 7.1229072988E-01],
	[1.6340000000E+04, 8.2346568224E+00, 5.2239337726E+00, 9.4171072464E-01, 7.2739873322E-01, 7.1241418043E-01],
	[1.6345000000E+04, 8.2381943367E+00, 5.2237028067E+00, 9.4262826523E-01, 7.2796919844E-01, 7.1253759535E-01],
	[1.6350000000E+04, 8.2417322881E+00, 5.2234719217E+00, 9.4354641833E-01, 7.2853983814E-01, 7.1266097465E-01],
	[1.6355000000E+04, 8.2452706763E+00, 5.2232411175E+00, 9.4446518415E-01, 7.2911065216E-01, 7.1278431832E-01],
	[1.6360000000E+04, 8.2488095014E+00, 5.2230103940E+00, 9.4538456292E-01, 7.2968164035E-01, 7.1290762633E-01],
	[1.6365000000E+04, 8.2523487633E+00, 5.2227797512E+00, 9.4630455486E-01, 7.3025280256E-01, 7.1303089870E-01],
	[1.6370000000E+04, 8.2558884618E+00, 5.2225491891E+00, 9.4722516018E-01, 7.3082413864E-01, 7.1315413539E-01],
	[1.6375000000E+04, 8.2594285969E+00, 5.2223187075E+00, 9.4814637912E-01, 7.3139564844E-01, 7.1327733642E-01],
	[1.6380000000E+04, 8.2629691686E+00, 5.2220883065E+00, 9.4906821188E-01, 7.3196733181E-01, 7.1340050175E-01],
	[1.6385000000E+04, 8.2665101767E+00, 5.2218579859E+00, 9.4999065870E-01, 7.3253918859E-01, 7.1352363140E-01],
	[1.6390000000E+04, 8.2700516212E+00, 5.2216277458E+00, 9.5091371978E-01, 7.3311121865E-01, 7.1364672534E-01],
	[1.6395000000E+04, 8.2735935020E+00, 5.2213975860E+00, 9.5183739536E-01, 7.3368342182E-01, 7.1376978356E-01],
	[1.6400000000E+04, 8.2771358190E+00, 5.2211675066E+00, 9.5276168565E-01, 7.3425579795E-01, 7.1389280606E-01],
	[1.6405000000E+04, 8.2806785721E+00, 5.2209375074E+00, 9.5368659088E-01, 7.3482834690E-01, 7.1401579283E-01],
	[1.6410000000E+04, 8.2842217613E+00, 5.2207075885E+00, 9.5461211127E-01, 7.3540106851E-01, 7.1413874386E-01],
	[1.6415000000E+04, 8.2877653864E+00, 5.2204777497E+00, 9.5553824703E-01, 7.3597396263E-01, 7.1426165914E-01],
	[1.6420000000E+04, 8.2913094475E+00, 5.2202479910E+00, 9.5646499839E-01, 7.3654702911E-01, 7.1438453865E-01],
	[1.6425000000E+04, 8.2948539443E+00, 5.2200183124E+00, 9.5739236556E-01, 7.3712026779E-01, 7.1450738240E-01],
	[1.6430000000E+04, 8.2983988769E+00, 5.2197887138E+00, 9.5832034878E-01, 7.3769367854E-01, 7.1463019037E-01],
	[1.6435000000E+04, 8.3019442451E+00, 5.2195591952E+00, 9.5924894826E-01, 7.3826726118E-01, 7.1475296254E-01],
	[1.6440000000E+04, 8.3054900490E+00, 5.2193297564E+00, 9.6017816423E-01, 7.3884101558E-01, 7.1487569892E-01],
	[1.6445000000E+04, 8.3090362883E+00, 5.2191003975E+00, 9.6110799689E-01, 7.3941494158E-01, 7.1499839950E-01],
	[1.6450000000E+04, 8.3125829630E+00, 5.2188711184E+00, 9.6203844649E-01, 7.3998903903E-01, 7.1512106425E-01],
	[1.6455000000E+04, 8.3161300731E+00, 5.2186419191E+00, 9.6296951322E-01, 7.4056330778E-01, 7.1524369318E-01],
	[1.6460000000E+04, 8.3196776184E+00, 5.2184127994E+00, 9.6390119733E-01, 7.4113774766E-01, 7.1536628628E-01],
	[1.6465000000E+04, 8.3232255989E+00, 5.2181837594E+00, 9.6483349902E-01, 7.4171235854E-01, 7.1548884353E-01],
	[1.6470000000E+04, 8.3267740145E+00, 5.2179547990E+00, 9.6576641853E-01, 7.4228714027E-01, 7.1561136493E-01],
	[1.6475000000E+04, 8.3303228651E+00, 5.2177259181E+00, 9.6669995606E-01, 7.4286209267E-01, 7.1573385047E-01],
	[1.6480000000E+04, 8.3338721507E+00, 5.2174971168E+00, 9.6763411185E-01, 7.4343721562E-01, 7.1585630014E-01],
	[1.6485000000E+04, 8.3374218712E+00, 5.2172683948E+00, 9.6856888611E-01, 7.4401250894E-01, 7.1597871392E-01],
	[1.6490000000E+04, 8.3409720264E+00, 5.2170397522E+00, 9.6950427906E-01, 7.4458797249E-01, 7.1610109182E-01],
	[1.6495000000E+04, 8.3445226164E+00, 5.2168111890E+00, 9.7044029093E-01, 7.4516360612E-01, 7.1622343382E-01],
	[1.6500000000E+04, 8.3480736409E+00, 5.2165827050E+00, 9.7137692194E-01, 7.4573940968E-01, 7.1634573992E-01],
	[1.6505000000E+04, 8.3516251001E+00, 5.2163543003E+00, 9.7231417231E-01, 7.4631538300E-01, 7.1646801010E-01],
	[1.6510000000E+04, 8.3551769937E+00, 5.2161259748E+00, 9.7325204225E-01, 7.4689152594E-01, 7.1659024436E-01],
	[1.6515000000E+04, 8.3587293217E+00, 5.2158977283E+00, 9.7419053200E-01, 7.4746783835E-01, 7.1671244268E-01],
	[1.6520000000E+04, 8.3622820840E+00, 5.2156695610E+00, 9.7512964177E-01, 7.4804432007E-01, 7.1683460507E-01],
	[1.6525000000E+04, 8.3658352805E+00, 5.2154414727E+00, 9.7606937178E-01, 7.4862097095E-01, 7.1695673150E-01],
	[1.6530000000E+04, 8.3693889112E+00, 5.2152134633E+00, 9.7700972225E-01, 7.4919779083E-01, 7.1707882197E-01],
	[1.6535000000E+04, 8.3729429760E+00, 5.2149855329E+00, 9.7795069342E-01, 7.4977477956E-01, 7.1720087648E-01],
	[1.6540000000E+04, 8.3764974748E+00, 5.2147576813E+00, 9.7889228549E-01, 7.5035193699E-01, 7.1732289502E-01],
	[1.6545000000E+04, 8.3800524075E+00, 5.2145299086E+00, 9.7983449869E-01, 7.5092926297E-01, 7.1744487756E-01],
	[1.6550000000E+04, 8.3836077741E+00, 5.2143022146E+00, 9.8077733324E-01, 7.5150675733E-01, 7.1756682412E-01],
	[1.6555000000E+04, 8.3871635745E+00, 5.2140745994E+00, 9.8172078936E-01, 7.5208441994E-01, 7.1768873468E-01],
	[1.6560000000E+04, 8.3907198085E+00, 5.2138470628E+00, 9.8266486728E-01, 7.5266225062E-01, 7.1781060922E-01],
	[1.6565000000E+04, 8.3942802128E+00, 5.2136210322E+00, 9.8360956721E-01, 7.5324030912E-01, 7.1793244775E-01],
	[1.6570000000E+04, 8.3978510905E+00, 5.2133989123E+00, 9.8455488937E-01, 7.5381869654E-01, 7.1805425025E-01],
	[1.6575000000E+04, 8.4014224092E+00, 5.2131768689E+00, 9.8550083400E-01, 7.5439725211E-01, 7.1817601672E-01],
	[1.6580000000E+04, 8.4049941688E+00, 5.2129549019E+00, 9.8644740130E-01, 7.5497597568E-01, 7.1829774714E-01],
	[1.6585000000E+04, 8.4085663693E+00, 5.2127330113E+00, 9.8739459150E-01, 7.5555486709E-01, 7.1841944152E-01],
	[1.6590000000E+04, 8.4121390105E+00, 5.2125111970E+00, 9.8834240483E-01, 7.5613392618E-01, 7.1854109983E-01],
	[1.6595000000E+04, 8.4157120924E+00, 5.2122894590E+00, 9.8929084150E-01, 7.5671315281E-01, 7.1866272208E-01],
	[1.6600000000E+04, 8.4192856149E+00, 5.2120677972E+00, 9.9023990173E-01, 7.5729254681E-01, 7.1878430825E-01],
	[1.6605000000E+04, 8.4228595779E+00, 5.2118462116E+00, 9.9118958575E-01, 7.5787210804E-01, 7.1890585834E-01],
	[1.6610000000E+04, 8.4264339813E+00, 5.2116247021E+00, 9.9213989378E-01, 7.5845183634E-01, 7.1902737234E-01],
	[1.6615000000E+04, 8.4300088251E+00, 5.2114032688E+00, 9.9309082604E-01, 7.5903173156E-01, 7.1914885023E-01],
	[1.6620000000E+04, 8.4335841092E+00, 5.2111819114E+00, 9.9404238274E-01, 7.5961179354E-01, 7.1927029202E-01],
	[1.6625000000E+04, 8.4371598336E+00, 5.2109606300E+00, 9.9499456413E-01, 7.6019202213E-01, 7.1939169770E-01],
	[1.6630000000E+04, 8.4407359980E+00, 5.2107394245E+00, 9.9594737040E-01, 7.6077241717E-01, 7.1951306724E-01],
	[1.6635000000E+04, 8.4443126025E+00, 5.2105182950E+00, 9.9690080179E-01, 7.6135297851E-01, 7.1963440066E-01],
	[1.6640000000E+04, 8.4478896470E+00, 5.2102972412E+00, 9.9785485852E-01, 7.6193370600E-01, 7.1975569794E-01],
	[1.6645000000E+04, 8.4514671313E+00, 5.2100762633E+00, 9.9880954081E-01, 7.6251459947E-01, 7.1987695907E-01],
	[1.6650000000E+04, 8.4550450555E+00, 5.2098553611E+00, 9.9976484888E-01, 7.6309565878E-01, 7.1999818405E-01],
	[1.6655000000E+04, 8.4586234194E+00, 5.2096345346E+00, 1.0007207829E+00, 7.6367688378E-01, 7.2011937286E-01],
	[1.6660000000E+04, 8.4622022230E+00, 5.2094137837E+00, 1.0016773432E+00, 7.6425827429E-01, 7.2024052550E-01],
	[1.6665000000E+04, 8.4657814662E+00, 5.2091931084E+00, 1.0026345300E+00, 7.6483983018E-01, 7.2036164197E-01],
	[1.6670000000E+04, 8.4693611489E+00, 5.2089725087E+00, 1.0035923434E+00, 7.6542155128E-01, 7.2048272225E-01],
	[1.6675000000E+04, 8.4729412710E+00, 5.2087519844E+00, 1.0045507837E+00, 7.6600343745E-01, 7.2060376633E-01],
	[1.6680000000E+04, 8.4765218324E+00, 5.2085315356E+00, 1.0055098511E+00, 7.6658548851E-01, 7.2072477422E-01],
	[1.6685000000E+04, 8.4801028332E+00, 5.2083111622E+00, 1.0064695458E+00, 7.6716770433E-01, 7.2084574589E-01],
	[1.6690000000E+04, 8.4836842731E+00, 5.2080908641E+00, 1.0074298681E+00, 7.6775008474E-01, 7.2096668135E-01],
	[1.6695000000E+04, 8.4872661521E+00, 5.2078706414E+00, 1.0083908182E+00, 7.6833262960E-01, 7.2108758058E-01],
	[1.6700000000E+04, 8.4908484702E+00, 5.2076504939E+00, 1.0093523962E+00, 7.6891533873E-01, 7.2120844359E-01],
	[1.6705000000E+04, 8.4944312272E+00, 5.2074304216E+00, 1.0103146025E+00, 7.6949821199E-01, 7.2132927035E-01],
	[1.6710000000E+04, 8.4980144231E+00, 5.2072104244E+00, 1.0112774373E+00, 7.7008124923E-01, 7.2145006087E-01],
	[1.6715000000E+04, 8.5015980579E+00, 5.2069905024E+00, 1.0122409006E+00, 7.7066445028E-01, 7.2157081513E-01],
	[1.6720000000E+04, 8.5051821313E+00, 5.2067706554E+00, 1.0132049929E+00, 7.7124781499E-01, 7.2169153314E-01],
	[1.6725000000E+04, 8.5087666434E+00, 5.2065508835E+00, 1.0141697143E+00, 7.7183134321E-01, 7.2181221487E-01],
	[1.6730000000E+04, 8.5123515941E+00, 5.2063311865E+00, 1.0151350650E+00, 7.7241503478E-01, 7.2193286033E-01],
	[1.6735000000E+04, 8.5159369833E+00, 5.2061115644E+00, 1.0161010453E+00, 7.7299888953E-01, 7.2205346951E-01],
	[1.6740000000E+04, 8.5195228109E+00, 5.2058920172E+00, 1.0170676553E+00, 7.7358290733E-01, 7.2217404240E-01],
	[1.6745000000E+04, 8.5231090768E+00, 5.2056725448E+00, 1.0180348953E+00, 7.7416708800E-01, 7.2229457899E-01],
	[1.6750000000E+04, 8.5266957810E+00, 5.2054531471E+00, 1.0190027655E+00, 7.7475143140E-01, 7.2241507927E-01],
	[1.6755000000E+04, 8.5302829234E+00, 5.2052338242E+00, 1.0199712662E+00, 7.7533593737E-01, 7.2253554325E-01],
	[1.6760000000E+04, 8.5338705039E+00, 5.2050145760E+00, 1.0209403976E+00, 7.7592060575E-01, 7.2265597090E-01],
	[1.6765000000E+04, 8.5374585224E+00, 5.2047954024E+00, 1.0219101598E+00, 7.7650543639E-01, 7.2277636223E-01],
	[1.6770000000E+04, 8.5410469789E+00, 5.2045763034E+00, 1.0228805531E+00, 7.7709042912E-01, 7.2289671723E-01],
	[1.6775000000E+04, 8.5446358733E+00, 5.2043572789E+00, 1.0238515777E+00, 7.7767558379E-01, 7.2301703589E-01],
	[1.6780000000E+04, 8.5482252055E+00, 5.2041383290E+00, 1.0248232339E+00, 7.7826090025E-01, 7.2313731820E-01],
	[1.6785000000E+04, 8.5518149754E+00, 5.2039194534E+00, 1.0257955219E+00, 7.7884637834E-01, 7.2325756416E-01],
	[1.6790000000E+04, 8.5554051829E+00, 5.2037006522E+00, 1.0267684418E+00, 7.7943201789E-01, 7.2337777375E-01],
	[1.6795000000E+04, 8.5589958280E+00, 5.2034819254E+00, 1.0277419940E+00, 7.8001781877E-01, 7.2349794698E-01],
	[1.6800000000E+04, 8.5625869106E+00, 5.2032632729E+00, 1.0287161786E+00, 7.8060378080E-01, 7.2361808384E-01],
	[1.6805000000E+04, 8.5661784306E+00, 5.2030446946E+00, 1.0296909958E+00, 7.8118990382E-01, 7.2373818432E-01],
	[1.6810000000E+04, 8.5697703880E+00, 5.2028261906E+00, 1.0306664460E+00, 7.8177618770E-01, 7.2385824840E-01],
	[1.6815000000E+04, 8.5733627826E+00, 5.2026077607E+00, 1.0316425292E+00, 7.8236263225E-01, 7.2397827610E-01],
	[1.6820000000E+04, 8.5769556144E+00, 5.2023894049E+00, 1.0326192457E+00, 7.8294923734E-01, 7.2409826739E-01],
	[1.6825000000E+04, 8.5805488833E+00, 5.2021711231E+00, 1.0335965958E+00, 7.8353600280E-01, 7.2421822228E-01],
	[1.6830000000E+04, 8.5841425892E+00, 5.2019529154E+00, 1.0345745797E+00, 7.8412292847E-01, 7.2433814075E-01],
	[1.6835000000E+04, 8.5877501783E+00, 5.2017396640E+00, 1.0355531975E+00, 7.8471023758E-01, 7.2445802279E-01],
	[1.6840000000E+04, 8.5913590563E+00, 5.2015267912E+00, 1.0365324496E+00, 7.8529772114E-01, 7.2457786840E-01],
	[1.6845000000E+04, 8.5949683788E+00, 5.2013139904E+00, 1.0375123361E+00, 7.8588536500E-01, 7.2469767757E-01],
	[1.6850000000E+04, 8.5985781458E+00, 5.2011012614E+00, 1.0384928573E+00, 7.8647316900E-01, 7.2481745028E-01],
	[1.6855000000E+04, 8.6021883572E+00, 5.2008886042E+00, 1.0394740133E+00, 7.8706113297E-01, 7.2493718653E-01],
	[1.6860000000E+04, 8.6057990129E+00, 5.2006760188E+00, 1.0404558044E+00, 7.8764925675E-01, 7.2505688631E-01],
	[1.6865000000E+04, 8.6094101128E+00, 5.2004635051E+00, 1.0414382309E+00, 7.8823754021E-01, 7.2517654961E-01],
	[1.6870000000E+04, 8.6130216569E+00, 5.2002510631E+00, 1.0424212928E+00, 7.8882598316E-01, 7.2529617642E-01],
	[1.6875000000E+04, 8.6166336450E+00, 5.2000386928E+00, 1.0434049906E+00, 7.8941458547E-01, 7.2541576673E-01],
	[1.6880000000E+04, 8.6202460772E+00, 5.1998263940E+00, 1.0443893243E+00, 7.9000334696E-01, 7.2553532054E-01],
	[1.6885000000E+04, 8.6238589533E+00, 5.1996141667E+00, 1.0453742943E+00, 7.9059226748E-01, 7.2565483784E-01],
	[1.6890000000E+04, 8.6274722732E+00, 5.1994020109E+00, 1.0463599007E+00, 7.9118134688E-01, 7.2577431861E-01],
	[1.6895000000E+04, 8.6310860369E+00, 5.1991899266E+00, 1.0473461437E+00, 7.9177058500E-01, 7.2589376286E-01],
	[1.6900000000E+04, 8.6347002443E+00, 5.1989779137E+00, 1.0483330236E+00, 7.9235998167E-01, 7.2601317056E-01],
	[1.6905000000E+04, 8.6383148954E+00, 5.1987659722E+00, 1.0493205406E+00, 7.9294953674E-01, 7.2613254172E-01],
	[1.6910000000E+04, 8.6419299899E+00, 5.1985541019E+00, 1.0503086950E+00, 7.9353925006E-01, 7.2625187632E-01],
	[1.6915000000E+04, 8.6455455280E+00, 5.1983423029E+00, 1.0512974868E+00, 7.9412912146E-01, 7.2637117435E-01],
	[1.6920000000E+04, 8.6491615094E+00, 5.1981305752E+00, 1.0522869165E+00, 7.9471915078E-01, 7.2649043581E-01],
	[1.6925000000E+04, 8.6527779341E+00, 5.1979189186E+00, 1.0532769841E+00, 7.9530933787E-01, 7.2660966069E-01],
	[1.6930000000E+04, 8.6563948021E+00, 5.1977073332E+00, 1.0542676900E+00, 7.9589968257E-01, 7.2672884899E-01],
	[1.6935000000E+04, 8.6600121132E+00, 5.1974958188E+00, 1.0552590342E+00, 7.9649018473E-01, 7.2684800068E-01],
	[1.6940000000E+04, 8.6636298674E+00, 5.1972843755E+00, 1.0562510171E+00, 7.9708084417E-01, 7.2696711577E-01],
	[1.6945000000E+04, 8.6672480646E+00, 5.1970730032E+00, 1.0572436389E+00, 7.9767166075E-01, 7.2708619424E-01],
	[1.6950000000E+04, 8.6708667048E+00, 5.1968617018E+00, 1.0582368998E+00, 7.9826263431E-01, 7.2720523610E-01],
	[1.6955000000E+04, 8.6744857878E+00, 5.1966504714E+00, 1.0592308001E+00, 7.9885376468E-01, 7.2732424132E-01],
	[1.6960000000E+04, 8.6781053135E+00, 5.1964393118E+00, 1.0602253398E+00, 7.9944505171E-01, 7.2744320990E-01],
	[1.6965000000E+04, 8.6817252820E+00, 5.1962282230E+00, 1.0612205194E+00, 8.0003649523E-01, 7.2756214184E-01],
	[1.6970000000E+04, 8.6853456931E+00, 5.1960172051E+00, 1.0622163389E+00, 8.0062809510E-01, 7.2768103713E-01],
	[1.6975000000E+04, 8.6889665467E+00, 5.1958062578E+00, 1.0632127986E+00, 8.0121985115E-01, 7.2779989575E-01],
	[1.6980000000E+04, 8.6925878429E+00, 5.1955953812E+00, 1.0642098988E+00, 8.0181176322E-01, 7.2791871770E-01],
	[1.6985000000E+04, 8.6962095814E+00, 5.1953845753E+00, 1.0652076396E+00, 8.0240383116E-01, 7.2803750297E-01],
	[1.6990000000E+04, 8.6998317622E+00, 5.1951738400E+00, 1.0662060213E+00, 8.0299605479E-01, 7.2815625156E-01],
	[1.6995000000E+04, 8.7034543852E+00, 5.1949631752E+00, 1.0672050441E+00, 8.0358843398E-01, 7.2827496346E-01],
	[1.7000000000E+04, 8.7070774505E+00, 5.1947525809E+00, 1.0682047082E+00, 8.0418096855E-01, 7.2839363866E-01],
	[1.7005000000E+04, 8.7107009578E+00, 5.1945420571E+00, 1.0692050138E+00, 8.0477365834E-01, 7.2851227714E-01],
	[1.7010000000E+04, 8.7143249071E+00, 5.1943316037E+00, 1.0702059613E+00, 8.0536650320E-01, 7.2863087891E-01],
	[1.7015000000E+04, 8.7179492984E+00, 5.1941212207E+00, 1.0712075507E+00, 8.0595950297E-01, 7.2874944396E-01],
	[1.7020000000E+04, 8.7215741316E+00, 5.1939109080E+00, 1.0722097823E+00, 8.0655265749E-01, 7.2886797227E-01],
	[1.7025000000E+04, 8.7251994065E+00, 5.1937006656E+00, 1.0732126564E+00, 8.0714596659E-01, 7.2898646384E-01],
	[1.7030000000E+04, 8.7288251231E+00, 5.1934904934E+00, 1.0742161731E+00, 8.0773943012E-01, 7.2910491867E-01],
	[1.7035000000E+04, 8.7324512814E+00, 5.1932803915E+00, 1.0752203327E+00, 8.0833304792E-01, 7.2922333675E-01],
	[1.7040000000E+04, 8.7360778812E+00, 5.1930703597E+00, 1.0762251354E+00, 8.0892681983E-01, 7.2934171806E-01],
	[1.7045000000E+04, 8.7397049225E+00, 5.1928603980E+00, 1.0772305814E+00, 8.0952074569E-01, 7.2946006260E-01],
	[1.7050000000E+04, 8.7433324052E+00, 5.1926505064E+00, 1.0782366710E+00, 8.1011482534E-01, 7.2957837036E-01],
	[1.7055000000E+04, 8.7469603293E+00, 5.1924406848E+00, 1.0792434044E+00, 8.1070905862E-01, 7.2969664135E-01],
	[1.7060000000E+04, 8.7505886946E+00, 5.1922309331E+00, 1.0802507817E+00, 8.1130344536E-01, 7.2981487554E-01],
	[1.7065000000E+04, 8.7542175010E+00, 5.1920212514E+00, 1.0812588033E+00, 8.1189798542E-01, 7.2993307293E-01],
	[1.7070000000E+04, 8.7578467486E+00, 5.1918116396E+00, 1.0822674693E+00, 8.1249267862E-01, 7.3005123351E-01],
	[1.7075000000E+04, 8.7614764372E+00, 5.1916020977E+00, 1.0832767799E+00, 8.1308752481E-01, 7.3016935729E-01],
	[1.7080000000E+04, 8.7651065668E+00, 5.1913926255E+00, 1.0842867354E+00, 8.1368252383E-01, 7.3028744424E-01],
	[1.7085000000E+04, 8.7687371372E+00, 5.1911832232E+00, 1.0852973361E+00, 8.1427767552E-01, 7.3040549436E-01],
	[1.7090000000E+04, 8.7723681485E+00, 5.1909738905E+00, 1.0863085820E+00, 8.1487297971E-01, 7.3052350765E-01],
	[1.7095000000E+04, 8.7759996004E+00, 5.1907646275E+00, 1.0873204736E+00, 8.1546843625E-01, 7.3064148410E-01],
	[1.7100000000E+04, 8.7796314931E+00, 5.1905554341E+00, 1.0883330109E+00, 8.1606404498E-01, 7.3075942370E-01],
	[1.7105000000E+04, 8.7832749654E+00, 5.1903501597E+00, 1.0893461941E+00, 8.1665999733E-01, 7.3087732644E-01],
	[1.7110000000E+04, 8.7869225599E+00, 5.1901462230E+00, 1.0903600236E+00, 8.1725616525E-01, 7.3099519232E-01],
	[1.7115000000E+04, 8.7905706028E+00, 5.1899423538E+00, 1.0913744996E+00, 8.1785248544E-01, 7.3111302133E-01],
	[1.7120000000E+04, 8.7942190940E+00, 5.1897385523E+00, 1.0923896222E+00, 8.1844895776E-01, 7.3123081347E-01],
	[1.7125000000E+04, 8.7978680334E+00, 5.1895348182E+00, 1.0934053917E+00, 8.1904558203E-01, 7.3134856872E-01],
	[1.7130000000E+04, 8.8015174209E+00, 5.1893311517E+00, 1.0944218083E+00, 8.1964235810E-01, 7.3146628708E-01],
	[1.7135000000E+04, 8.8051672565E+00, 5.1891275525E+00, 1.0954388722E+00, 8.2023928581E-01, 7.3158396854E-01],
	[1.7140000000E+04, 8.8088175402E+00, 5.1889240208E+00, 1.0964565837E+00, 8.2083636499E-01, 7.3170161310E-01],
	[1.7145000000E+04, 8.8124682717E+00, 5.1887205564E+00, 1.0974749430E+00, 8.2143359548E-01, 7.3181922074E-01],
	[1.7150000000E+04, 8.8161194511E+00, 5.1885171592E+00, 1.0984939503E+00, 8.2203097713E-01, 7.3193679147E-01],
	[1.7155000000E+04, 8.8197710782E+00, 5.1883138294E+00, 1.0995136058E+00, 8.2262850978E-01, 7.3205432528E-01],
	[1.7160000000E+04, 8.8234231530E+00, 5.1881105668E+00, 1.1005339097E+00, 8.2322619325E-01, 7.3217182216E-01],
	[1.7165000000E+04, 8.8270756755E+00, 5.1879073713E+00, 1.1015548623E+00, 8.2382402740E-01, 7.3228928209E-01],
	[1.7170000000E+04, 8.8307286455E+00, 5.1877042430E+00, 1.1025764638E+00, 8.2442201206E-01, 7.3240670509E-01],
	[1.7175000000E+04, 8.8343820629E+00, 5.1875011818E+00, 1.1035987144E+00, 8.2502014707E-01, 7.3252409113E-01],
	[1.7180000000E+04, 8.8380359277E+00, 5.1872981876E+00, 1.1046216144E+00, 8.2561843227E-01, 7.3264144021E-01],
	[1.7185000000E+04, 8.8416902399E+00, 5.1870952604E+00, 1.1056451639E+00, 8.2621686750E-01, 7.3275875234E-01],
	[1.7190000000E+04, 8.8453449993E+00, 5.1868924002E+00, 1.1066693632E+00, 8.2681545260E-01, 7.3287602749E-01],
	[1.7195000000E+04, 8.8490002058E+00, 5.1866896069E+00, 1.1076942125E+00, 8.2741418740E-01, 7.3299326566E-01],
	[1.7200000000E+04, 8.8526558594E+00, 5.1864868806E+00, 1.1087197120E+00, 8.2801307174E-01, 7.3311046686E-01],
	[1.7205000000E+04, 8.8563119601E+00, 5.1862842210E+00, 1.1097458620E+00, 8.2861210547E-01, 7.3322763106E-01],
	[1.7210000000E+04, 8.8599685076E+00, 5.1860816283E+00, 1.1107726627E+00, 8.2921128842E-01, 7.3334475827E-01],
	[1.7215000000E+04, 8.8636255021E+00, 5.1858791023E+00, 1.1118001142E+00, 8.2981062043E-01, 7.3346184847E-01],
	[1.7220000000E+04, 8.8672829433E+00, 5.1856766430E+00, 1.1128282169E+00, 8.3041010134E-01, 7.3357890167E-01],
	[1.7225000000E+04, 8.8709408312E+00, 5.1854742505E+00, 1.1138569709E+00, 8.3100973098E-01, 7.3369591785E-01],
	[1.7230000000E+04, 8.8745991658E+00, 5.1852719245E+00, 1.1148863765E+00, 8.3160950920E-01, 7.3381289702E-01],
	[1.7235000000E+04, 8.8782579469E+00, 5.1850696652E+00, 1.1159164339E+00, 8.3220943584E-01, 7.3392983915E-01],
	[1.7240000000E+04, 8.8819171745E+00, 5.1848674724E+00, 1.1169471433E+00, 8.3280951072E-01, 7.3404674426E-01],
	[1.7245000000E+04, 8.8855768486E+00, 5.1846653461E+00, 1.1179785049E+00, 8.3340973370E-01, 7.3416361232E-01],
	[1.7250000000E+04, 8.8892369689E+00, 5.1844632863E+00, 1.1190105190E+00, 8.3401010461E-01, 7.3428044334E-01],
	[1.7255000000E+04, 8.8928975355E+00, 5.1842612929E+00, 1.1200431857E+00, 8.3461062328E-01, 7.3439723731E-01],
	[1.7260000000E+04, 8.8965585483E+00, 5.1840593659E+00, 1.1210765054E+00, 8.3521128956E-01, 7.3451399422E-01],
	[1.7265000000E+04, 8.9002200072E+00, 5.1838575053E+00, 1.1221104782E+00, 8.3581210327E-01, 7.3463071407E-01],
	[1.7270000000E+04, 8.9038819122E+00, 5.1836557110E+00, 1.1231451043E+00, 8.3641306427E-01, 7.3474739685E-01],
	[1.7275000000E+04, 8.9075442631E+00, 5.1834539829E+00, 1.1241803840E+00, 8.3701417239E-01, 7.3486404256E-01],
	[1.7280000000E+04, 8.9112070599E+00, 5.1832523210E+00, 1.1252163175E+00, 8.3761542747E-01, 7.3498065118E-01],
	[1.7285000000E+04, 8.9148703025E+00, 5.1830507254E+00, 1.1262529051E+00, 8.3821682933E-01, 7.3509722272E-01],
	[1.7290000000E+04, 8.9185339908E+00, 5.1828491959E+00, 1.1272901468E+00, 8.3881837783E-01, 7.3521375717E-01],
	[1.7295000000E+04, 8.9221981248E+00, 5.1826477325E+00, 1.1283280431E+00, 8.3942007280E-01, 7.3533025452E-01],
	[1.7300000000E+04, 8.9258627044E+00, 5.1824463351E+00, 1.1293665940E+00, 8.4002191407E-01, 7.3544671476E-01],
	[1.7305000000E+04, 8.9295277295E+00, 5.1822450038E+00, 1.1304057998E+00, 8.4062390149E-01, 7.3556313790E-01],
	[1.7310000000E+04, 8.9331932000E+00, 5.1820437385E+00, 1.1314456608E+00, 8.4122603489E-01, 7.3567952392E-01],
	[1.7315000000E+04, 8.9368591159E+00, 5.1818425391E+00, 1.1324861771E+00, 8.4182831411E-01, 7.3579587282E-01],
	[1.7320000000E+04, 8.9405254771E+00, 5.1816414056E+00, 1.1335273490E+00, 8.4243073899E-01, 7.3591218460E-01],
	[1.7325000000E+04, 8.9441922835E+00, 5.1814403379E+00, 1.1345691768E+00, 8.4303330935E-01, 7.3602845924E-01],
	[1.7330000000E+04, 8.9478595350E+00, 5.1812393361E+00, 1.1356116605E+00, 8.4363602505E-01, 7.3614469674E-01],
	[1.7335000000E+04, 8.9515272316E+00, 5.1810384001E+00, 1.1366548005E+00, 8.4423888592E-01, 7.3626089711E-01],
	[1.7340000000E+04, 8.9551953732E+00, 5.1808375298E+00, 1.1376985970E+00, 8.4484189179E-01, 7.3637706032E-01],
	[1.7345000000E+04, 8.9588639597E+00, 5.1806367252E+00, 1.1387430501E+00, 8.4544504251E-01, 7.3649318638E-01],
	[1.7350000000E+04, 8.9625329911E+00, 5.1804359862E+00, 1.1397881602E+00, 8.4604833790E-01, 7.3660927528E-01],
	[1.7355000000E+04, 8.9662024672E+00, 5.1802353129E+00, 1.1408339274E+00, 8.4665177781E-01, 7.3672532702E-01],
	[1.7360000000E+04, 8.9698723880E+00, 5.1800347051E+00, 1.1418803520E+00, 8.4725536207E-01, 7.3684134159E-01],
	[1.7365000000E+04, 8.9735427535E+00, 5.1798341629E+00, 1.1429274342E+00, 8.4785909052E-01, 7.3695731898E-01],
	[1.7370000000E+04, 8.9772135634E+00, 5.1796336862E+00, 1.1439751742E+00, 8.4846296300E-01, 7.3707325920E-01],
	[1.7375000000E+04, 8.9808848179E+00, 5.1794332749E+00, 1.1450235722E+00, 8.4906697934E-01, 7.3718916222E-01],
	[1.7380000000E+04, 8.9845671111E+00, 5.1792364169E+00, 1.1460726285E+00, 8.4967132801E-01, 7.3730502806E-01],
	[1.7385000000E+04, 8.9882546020E+00, 5.1790411853E+00, 1.1471223433E+00, 8.5027590522E-01, 7.3742085670E-01],
	[1.7390000000E+04, 8.9919425453E+00, 5.1788460172E+00, 1.1481727168E+00, 8.5088062640E-01, 7.3753664814E-01],
	[1.7395000000E+04, 8.9956309409E+00, 5.1786509126E+00, 1.1492237492E+00, 8.5148549138E-01, 7.3765240237E-01],
	[1.7400000000E+04, 8.9993197887E+00, 5.1784558714E+00, 1.1502754408E+00, 8.5209050001E-01, 7.3776811940E-01],
	[1.7405000000E+04, 9.0030090887E+00, 5.1782608935E+00, 1.1513277917E+00, 8.5269565213E-01, 7.3788379920E-01],
	[1.7410000000E+04, 9.0066988409E+00, 5.1780659790E+00, 1.1523808022E+00, 8.5330094756E-01, 7.3799944179E-01],
	[1.7415000000E+04, 9.0103890450E+00, 5.1778711279E+00, 1.1534344726E+00, 8.5390638614E-01, 7.3811504715E-01],
	[1.7420000000E+04, 9.0140797011E+00, 5.1776763399E+00, 1.1544888030E+00, 8.5451196772E-01, 7.3823061527E-01],
	[1.7425000000E+04, 9.0177708091E+00, 5.1774816152E+00, 1.1555437937E+00, 8.5511769213E-01, 7.3834614616E-01],
	[1.7430000000E+04, 9.0214623689E+00, 5.1772869537E+00, 1.1565994449E+00, 8.5572355920E-01, 7.3846163981E-01],
	[1.7435000000E+04, 9.0251543805E+00, 5.1770923554E+00, 1.1576557567E+00, 8.5632956877E-01, 7.3857709622E-01],
	[1.7440000000E+04, 9.0288468436E+00, 5.1768978201E+00, 1.1587127296E+00, 8.5693572068E-01, 7.3869251537E-01],
	[1.7445000000E+04, 9.0325397584E+00, 5.1767033480E+00, 1.1597703636E+00, 8.5754201477E-01, 7.3880789727E-01],
	[1.7450000000E+04, 9.0362331247E+00, 5.1765089388E+00, 1.1608286589E+00, 8.5814845087E-01, 7.3892324191E-01],
	[1.7455000000E+04, 9.0399269424E+00, 5.1763145927E+00, 1.1618876159E+00, 8.5875502882E-01, 7.3903854928E-01],
	[1.7460000000E+04, 9.0436212114E+00, 5.1761203095E+00, 1.1629472347E+00, 8.5936174845E-01, 7.3915381939E-01],
	[1.7465000000E+04, 9.0473159318E+00, 5.1759260892E+00, 1.1640075156E+00, 8.5996860960E-01, 7.3926905222E-01],
	[1.7470000000E+04, 9.0510111033E+00, 5.1757319318E+00, 1.1650684588E+00, 8.6057561211E-01, 7.3938424777E-01],
	[1.7475000000E+04, 9.0547067260E+00, 5.1755378372E+00, 1.1661300644E+00, 8.6118275581E-01, 7.3949940603E-01],
	[1.7480000000E+04, 9.0584027998E+00, 5.1753438055E+00, 1.1671923328E+00, 8.6179004054E-01, 7.3961452701E-01],
	[1.7485000000E+04, 9.0620993245E+00, 5.1751498365E+00, 1.1682552642E+00, 8.6239746613E-01, 7.3972961070E-01],
	[1.7490000000E+04, 9.0657963002E+00, 5.1749559302E+00, 1.1693188587E+00, 8.6300503243E-01, 7.3984465709E-01],
	[1.7495000000E+04, 9.0694937267E+00, 5.1747620867E+00, 1.1703831166E+00, 8.6361273927E-01, 7.3995966617E-01],
	[1.7500000000E+04, 9.0731916039E+00, 5.1745683057E+00, 1.1714480381E+00, 8.6422058647E-01, 7.4007463796E-01],
	[1.7505000000E+04, 9.0768899319E+00, 5.1743745874E+00, 1.1725221626E+00, 8.6483321940E-01, 7.4018957243E-01],
	[1.7510000000E+04, 9.0805887105E+00, 5.1741809317E+00, 1.1735969643E+00, 8.6544599569E-01, 7.4030446958E-01],
	[1.7515000000E+04, 9.0842879396E+00, 5.1739873385E+00, 1.1746724434E+00, 8.6605891517E-01, 7.4041932942E-01],
	[1.7520000000E+04, 9.0879876192E+00, 5.1737938078E+00, 1.1757486003E+00, 8.6667197768E-01, 7.4053415193E-01],
	[1.7525000000E+04, 9.0916877492E+00, 5.1736003395E+00, 1.1768254351E+00, 8.6728518306E-01, 7.4064893712E-01],
	[1.7530000000E+04, 9.0953883295E+00, 5.1734069337E+00, 1.1779029480E+00, 8.6789853112E-01, 7.4076368497E-01],
	[1.7535000000E+04, 9.0990893600E+00, 5.1732135903E+00, 1.1789811394E+00, 8.6851202171E-01, 7.4087839549E-01],
	[1.7540000000E+04, 9.1027908408E+00, 5.1730203092E+00, 1.1800600094E+00, 8.6912565466E-01, 7.4099306866E-01],
	[1.7545000000E+04, 9.1064927716E+00, 5.1728270904E+00, 1.1811395583E+00, 8.6973942979E-01, 7.4110770450E-01],
	[1.7550000000E+04, 9.1101951525E+00, 5.1726339339E+00, 1.1822197863E+00, 8.7035334695E-01, 7.4122230298E-01],
	[1.7555000000E+04, 9.1138979833E+00, 5.1724408396E+00, 1.1833006937E+00, 8.7096740596E-01, 7.4133686411E-01],
	[1.7560000000E+04, 9.1176012640E+00, 5.1722478075E+00, 1.1843822806E+00, 8.7158160665E-01, 7.4145138788E-01],
	[1.7565000000E+04, 9.1213049946E+00, 5.1720548375E+00, 1.1854645473E+00, 8.7219594886E-01, 7.4156587430E-01],
	[1.7570000000E+04, 9.1250091748E+00, 5.1718619297E+00, 1.1865474940E+00, 8.7281043242E-01, 7.4168032334E-01],
	[1.7575000000E+04, 9.1287138047E+00, 5.1716690840E+00, 1.1876311211E+00, 8.7342505716E-01, 7.4179473502E-01],
	[1.7580000000E+04, 9.1324188842E+00, 5.1714763003E+00, 1.1887154286E+00, 8.7403982291E-01, 7.4190910933E-01],
	[1.7585000000E+04, 9.1361244133E+00, 5.1712835786E+00, 1.1898004169E+00, 8.7465472951E-01, 7.4202344625E-01],
	[1.7590000000E+04, 9.1398303917E+00, 5.1710909189E+00, 1.1908860861E+00, 8.7526977678E-01, 7.4213774580E-01],
	[1.7595000000E+04, 9.1435368196E+00, 5.1708983211E+00, 1.1919724366E+00, 8.7588496456E-01, 7.4225200797E-01],
	[1.7600000000E+04, 9.1472436967E+00, 5.1707057852E+00, 1.1930594684E+00, 8.7650029267E-01, 7.4236623274E-01],
	[1.7605000000E+04, 9.1509510231E+00, 5.1705133112E+00, 1.1941471820E+00, 8.7711576096E-01, 7.4248042012E-01],
	[1.7610000000E+04, 9.1546587986E+00, 5.1703208990E+00, 1.1952355774E+00, 8.7773136924E-01, 7.4259457011E-01],
	[1.7615000000E+04, 9.1583670231E+00, 5.1701285485E+00, 1.1963246550E+00, 8.7834711736E-01, 7.4270868269E-01],
	[1.7620000000E+04, 9.1620756967E+00, 5.1699362598E+00, 1.1974144150E+00, 8.7896300515E-01, 7.4282275788E-01],
	[1.7625000000E+04, 9.1657848192E+00, 5.1697440328E+00, 1.1985048576E+00, 8.7957903242E-01, 7.4293679565E-01],
	[1.7630000000E+04, 9.1694943906E+00, 5.1695518675E+00, 1.1995959830E+00, 8.8019519903E-01, 7.4305079602E-01],
	[1.7635000000E+04, 9.1732044107E+00, 5.1693597638E+00, 1.2006877914E+00, 8.8081150479E-01, 7.4316475897E-01],
	[1.7640000000E+04, 9.1769148796E+00, 5.1691677217E+00, 1.2017802832E+00, 8.8142794954E-01, 7.4327868450E-01],
	[1.7645000000E+04, 9.1806257971E+00, 5.1689757412E+00, 1.2028734585E+00, 8.8204453311E-01, 7.4339257261E-01],
	[1.7650000000E+04, 9.1843371632E+00, 5.1687838222E+00, 1.2039673176E+00, 8.8266125533E-01, 7.4350642330E-01],
	[1.7655000000E+04, 9.1880489777E+00, 5.1685919646E+00, 1.2050618607E+00, 8.8327811604E-01, 7.4362023662E-01],
	[1.7660000000E+04, 9.1917729748E+00, 5.1684038710E+00, 1.2061570880E+00, 8.8389533185E-01, 7.4373401264E-01],
	[1.7665000000E+04, 9.1955014895E+00, 5.1682171190E+00, 1.2072529998E+00, 8.8451276139E-01, 7.4384775133E-01],
	[1.7670000000E+04, 9.1992304607E+00, 5.1680304265E+00, 1.2083495963E+00, 8.8513032954E-01, 7.4396145271E-01],
	[1.7675000000E+04, 9.2029598885E+00, 5.1678437937E+00, 1.2094468778E+00, 8.8574803611E-01, 7.4407511676E-01],
	[1.7680000000E+04, 9.2066897727E+00, 5.1676572203E+00, 1.2105448444E+00, 8.8636588095E-01, 7.4418874348E-01],
	[1.7685000000E+04, 9.2104201132E+00, 5.1674707064E+00, 1.2116434964E+00, 8.8698386389E-01, 7.4430233286E-01],
	[1.7690000000E+04, 9.2141509101E+00, 5.1672842520E+00, 1.2127428340E+00, 8.8760198475E-01, 7.4441588490E-01],
	[1.7695000000E+04, 9.2178821632E+00, 5.1670978570E+00, 1.2138428576E+00, 8.8822024336E-01, 7.4452939960E-01],
	[1.7700000000E+04, 9.2216138724E+00, 5.1669115214E+00, 1.2149435672E+00, 8.8883863956E-01, 7.4464287695E-01],
	[1.7705000000E+04, 9.2253460377E+00, 5.1667252451E+00, 1.2160449632E+00, 8.8945717318E-01, 7.4475631694E-01],
	[1.7710000000E+04, 9.2290786590E+00, 5.1665390281E+00, 1.2171470457E+00, 8.9007584405E-01, 7.4486971957E-01],
	[1.7715000000E+04, 9.2328117362E+00, 5.1663528704E+00, 1.2182498150E+00, 8.9069465200E-01, 7.4498308484E-01],
	[1.7720000000E+04, 9.2365452693E+00, 5.1661667720E+00, 1.2193532714E+00, 8.9131359686E-01, 7.4509641274E-01],
	[1.7725000000E+04, 9.2402792582E+00, 5.1659807327E+00, 1.2204574151E+00, 8.9193267847E-01, 7.4520970326E-01],
	[1.7730000000E+04, 9.2440137028E+00, 5.1657947527E+00, 1.2215622462E+00, 8.9255189664E-01, 7.4532295641E-01],
	[1.7735000000E+04, 9.2477486030E+00, 5.1656088317E+00, 1.2226677651E+00, 8.9317125122E-01, 7.4543617218E-01],
	[1.7740000000E+04, 9.2514839588E+00, 5.1654229699E+00, 1.2237739720E+00, 8.9379074204E-01, 7.4554935055E-01],
	[1.7745000000E+04, 9.2552197700E+00, 5.1652371671E+00, 1.2248808671E+00, 8.9441036892E-01, 7.4566249154E-01],
	[1.7750000000E+04, 9.2589560367E+00, 5.1650514233E+00, 1.2259884506E+00, 8.9503013169E-01, 7.4577559513E-01],
	[1.7755000000E+04, 9.2626927588E+00, 5.1648657386E+00, 1.2270967228E+00, 8.9565003019E-01, 7.4588866132E-01],
	[1.7760000000E+04, 9.2664299361E+00, 5.1646801128E+00, 1.2282056839E+00, 8.9627006425E-01, 7.4600169011E-01],
	[1.7765000000E+04, 9.2701675686E+00, 5.1644945459E+00, 1.2293153341E+00, 8.9689023369E-01, 7.4611468148E-01],
	[1.7770000000E+04, 9.2739056562E+00, 5.1643090379E+00, 1.2304256737E+00, 8.9751053836E-01, 7.4622763545E-01],
	[1.7775000000E+04, 9.2776441989E+00, 5.1641235887E+00, 1.2315367029E+00, 8.9813097807E-01, 7.4634055199E-01],
	[1.7780000000E+04, 9.2813831966E+00, 5.1639381984E+00, 1.2326484220E+00, 8.9875155266E-01, 7.4645343111E-01],
	[1.7785000000E+04, 9.2851226492E+00, 5.1637528668E+00, 1.2337608311E+00, 8.9937226195E-01, 7.4656627281E-01],
	[1.7790000000E+04, 9.2888625566E+00, 5.1635675940E+00, 1.2348739306E+00, 8.9999310579E-01, 7.4667907708E-01],
	[1.7795000000E+04, 9.2926029188E+00, 5.1633823799E+00, 1.2359877206E+00, 9.0061408400E-01, 7.4679184391E-01],
	[1.7800000000E+04, 9.2963437357E+00, 5.1631972245E+00, 1.2371022013E+00, 9.0123519641E-01, 7.4690457330E-01],
	[1.7805000000E+04, 9.3000850072E+00, 5.1630121277E+00, 1.2382173731E+00, 9.0185644284E-01, 7.4701726525E-01],
	[1.7810000000E+04, 9.3038267333E+00, 5.1628270895E+00, 1.2393332362E+00, 9.0247782314E-01, 7.4712991976E-01],
	[1.7815000000E+04, 9.3075689138E+00, 5.1626421099E+00, 1.2404497907E+00, 9.0309933712E-01, 7.4724253681E-01],
	[1.7820000000E+04, 9.3113115487E+00, 5.1624571888E+00, 1.2415670369E+00, 9.0372098463E-01, 7.4735511641E-01],
	[1.7825000000E+04, 9.3150546380E+00, 5.1622723262E+00, 1.2426849750E+00, 9.0434276548E-01, 7.4746765855E-01],
	[1.7830000000E+04, 9.3187981815E+00, 5.1620875221E+00, 1.2438036054E+00, 9.0496467952E-01, 7.4758016323E-01],
	[1.7835000000E+04, 9.3225421792E+00, 5.1619027764E+00, 1.2449229281E+00, 9.0558672657E-01, 7.4769263044E-01],
	[1.7840000000E+04, 9.3262866310E+00, 5.1617180891E+00, 1.2460429435E+00, 9.0620890645E-01, 7.4780506018E-01],
	[1.7845000000E+04, 9.3300315368E+00, 5.1615334602E+00, 1.2471636518E+00, 9.0683121900E-01, 7.4791745244E-01],
	[1.7850000000E+04, 9.3337768967E+00, 5.1613488896E+00, 1.2482850532E+00, 9.0745366406E-01, 7.4802980723E-01],
	[1.7855000000E+04, 9.3375227104E+00, 5.1611643773E+00, 1.2494071479E+00, 9.0807624144E-01, 7.4814212453E-01],
	[1.7860000000E+04, 9.3412689779E+00, 5.1609799232E+00, 1.2505299363E+00, 9.0869895098E-01, 7.4825440435E-01],
	[1.7865000000E+04, 9.3450156992E+00, 5.1607955274E+00, 1.2516534184E+00, 9.0932179251E-01, 7.4836664669E-01],
	[1.7870000000E+04, 9.3487628742E+00, 5.1606111897E+00, 1.2527775946E+00, 9.0994476586E-01, 7.4847885152E-01],
	[1.7875000000E+04, 9.3525105028E+00, 5.1604269102E+00, 1.2539024651E+00, 9.1056787085E-01, 7.4859101886E-01],
	[1.7880000000E+04, 9.3562585849E+00, 5.1602426888E+00, 1.2550280301E+00, 9.1119110733E-01, 7.4870314870E-01],
	[1.7885000000E+04, 9.3600071205E+00, 5.1600585255E+00, 1.2561542898E+00, 9.1181447510E-01, 7.4881524104E-01],
	[1.7890000000E+04, 9.3637561095E+00, 5.1598744203E+00, 1.2572812446E+00, 9.1243797402E-01, 7.4892729587E-01],
	[1.7895000000E+04, 9.3675055518E+00, 5.1596903730E+00, 1.2584088945E+00, 9.1306160390E-01, 7.4903931319E-01],
	[1.7900000000E+04, 9.3712554473E+00, 5.1595063838E+00, 1.2595372400E+00, 9.1368536457E-01, 7.4915129299E-01],
	[1.7905000000E+04, 9.3750057961E+00, 5.1593224524E+00, 1.2606662811E+00, 9.1430925587E-01, 7.4926323528E-01],
	[1.7910000000E+04, 9.3787565979E+00, 5.1591385790E+00, 1.2617960181E+00, 9.1493327762E-01, 7.4937514004E-01],
	[1.7915000000E+04, 9.3825078528E+00, 5.1589547635E+00, 1.2629264513E+00, 9.1555742966E-01, 7.4948700728E-01],
	[1.7920000000E+04, 9.3862595606E+00, 5.1587710058E+00, 1.2640575808E+00, 9.1618171180E-01, 7.4959883700E-01],
	[1.7925000000E+04, 9.3900117213E+00, 5.1585873059E+00, 1.2651894070E+00, 9.1680612389E-01, 7.4971062918E-01],
	[1.7930000000E+04, 9.3937643348E+00, 5.1584036638E+00, 1.2663219301E+00, 9.1743066575E-01, 7.4982238382E-01],
	[1.7935000000E+04, 9.3975174011E+00, 5.1582200794E+00, 1.2674551502E+00, 9.1805533721E-01, 7.4993410093E-01],
	[1.7940000000E+04, 9.4012709201E+00, 5.1580365528E+00, 1.2685890677E+00, 9.1868013809E-01, 7.5004578050E-01],
	[1.7945000000E+04, 9.4050393716E+00, 5.1578574844E+00, 1.2697236828E+00, 9.1930534638E-01, 7.5015742252E-01],
	[1.7950000000E+04, 9.4088099930E+00, 5.1576789915E+00, 1.2708589956E+00, 9.1993071720E-01, 7.5026902699E-01],
	[1.7955000000E+04, 9.4125810753E+00, 5.1575005545E+00, 1.2719950064E+00, 9.2055621758E-01, 7.5038059391E-01],
	[1.7960000000E+04, 9.4163526184E+00, 5.1573221734E+00, 1.2731317156E+00, 9.2118184735E-01, 7.5049212328E-01],
	[1.7965000000E+04, 9.4201246223E+00, 5.1571438481E+00, 1.2742691232E+00, 9.2180760634E-01, 7.5060361509E-01],
	[1.7970000000E+04, 9.4238970869E+00, 5.1569655785E+00, 1.2754072296E+00, 9.2243349439E-01, 7.5071506935E-01],
	[1.7975000000E+04, 9.4276700120E+00, 5.1567873647E+00, 1.2765460349E+00, 9.2305951131E-01, 7.5082648603E-01],
	[1.7980000000E+04, 9.4314433978E+00, 5.1566092067E+00, 1.2776855394E+00, 9.2368565694E-01, 7.5093786516E-01],
	[1.7985000000E+04, 9.4352172439E+00, 5.1564311043E+00, 1.2788257434E+00, 9.2431193111E-01, 7.5104920671E-01],
	[1.7990000000E+04, 9.4389915505E+00, 5.1562530576E+00, 1.2799666470E+00, 9.2493833365E-01, 7.5116051069E-01],
	[1.7995000000E+04, 9.4427663174E+00, 5.1560750665E+00, 1.2811082505E+00, 9.2556486439E-01, 7.5127177710E-01],
	[1.8000000000E+04, 9.4465415446E+00, 5.1558971310E+00, 1.2822505542E+00, 9.2619152315E-01, 7.5138300592E-01],
	[1.8005000000E+04, 9.4503172319E+00, 5.1557192511E+00, 1.2833935582E+00, 9.2681830977E-01, 7.5149419717E-01],
	[1.8010000000E+04, 9.4540933794E+00, 5.1555414267E+00, 1.2845372629E+00, 9.2744522407E-01, 7.5160535083E-01],
	[1.8015000000E+04, 9.4578699869E+00, 5.1553636577E+00, 1.2856816683E+00, 9.2807226589E-01, 7.5171646691E-01],
	[1.8020000000E+04, 9.4616470543E+00, 5.1551859443E+00, 1.2868267749E+00, 9.2869943505E-01, 7.5182754540E-01],
	[1.8025000000E+04, 9.4654245817E+00, 5.1550082862E+00, 1.2879725828E+00, 9.2932673138E-01, 7.5193858629E-01],
	[1.8030000000E+04, 9.4692025689E+00, 5.1548306836E+00, 1.2891190922E+00, 9.2995415471E-01, 7.5204958959E-01],
	[1.8035000000E+04, 9.4729810158E+00, 5.1546531363E+00, 1.2902663034E+00, 9.3058170486E-01, 7.5216055530E-01],
	[1.8040000000E+04, 9.4767599224E+00, 5.1544756444E+00, 1.2914142166E+00, 9.3120938168E-01, 7.5227148340E-01],
	[1.8045000000E+04, 9.4805392886E+00, 5.1542982077E+00, 1.2925628320E+00, 9.3183718498E-01, 7.5238237390E-01],
	[1.8050000000E+04, 9.4843191144E+00, 5.1541208263E+00, 1.2937121499E+00, 9.3246511460E-01, 7.5249322680E-01],
	[1.8055000000E+04, 9.4880993996E+00, 5.1539435001E+00, 1.2948621706E+00, 9.3309317037E-01, 7.5260404209E-01],
	[1.8060000000E+04, 9.4918801442E+00, 5.1537662292E+00, 1.2960128942E+00, 9.3372135210E-01, 7.5271481976E-01],
	[1.8065000000E+04, 9.4956613482E+00, 5.1535890134E+00, 1.2971643209E+00, 9.3434965964E-01, 7.5282555983E-01],
	[1.8070000000E+04, 9.4994430114E+00, 5.1534118527E+00, 1.2983164511E+00, 9.3497809281E-01, 7.5293626228E-01],
	[1.8075000000E+04, 9.5032251337E+00, 5.1532347472E+00, 1.2994692850E+00, 9.3560665144E-01, 7.5304692711E-01],
	[1.8080000000E+04, 9.5070077152E+00, 5.1530576967E+00, 1.3006228227E+00, 9.3623533535E-01, 7.5315755432E-01],
	[1.8085000000E+04, 9.5107907557E+00, 5.1528807012E+00, 1.3017770646E+00, 9.3686414438E-01, 7.5326814391E-01],
	[1.8090000000E+04, 9.5145742552E+00, 5.1527037608E+00, 1.3029320108E+00, 9.3749307836E-01, 7.5337869588E-01],
	[1.8095000000E+04, 9.5183582136E+00, 5.1525268753E+00, 1.3040876616E+00, 9.3812213711E-01, 7.5348921021E-01],
	[1.8100000000E+04, 9.5221426308E+00, 5.1523500447E+00, 1.3052440172E+00, 9.3875132046E-01, 7.5359968692E-01],
	[1.8105000000E+04, 9.5259275068E+00, 5.1521732691E+00, 1.3064010779E+00, 9.3938062824E-01, 7.5371012600E-01],
	[1.8110000000E+04, 9.5297128414E+00, 5.1519965483E+00, 1.3075588439E+00, 9.4001006028E-01, 7.5382052744E-01],
	[1.8115000000E+04, 9.5334986347E+00, 5.1518198824E+00, 1.3087173154E+00, 9.4063961641E-01, 7.5393089125E-01],
	[1.8120000000E+04, 9.5372848865E+00, 5.1516432713E+00, 1.3098764927E+00, 9.4126929645E-01, 7.5404121741E-01],
	[1.8125000000E+04, 9.5410715968E+00, 5.1514667150E+00, 1.3110363759E+00, 9.4189910024E-01, 7.5415150594E-01],
	[1.8130000000E+04, 9.5448587654E+00, 5.1512902134E+00, 1.3121969654E+00, 9.4252902760E-01, 7.5426175682E-01],
	[1.8135000000E+04, 9.5486463924E+00, 5.1511137666E+00, 1.3133582614E+00, 9.4315907835E-01, 7.5437197006E-01],
	[1.8140000000E+04, 9.5524344777E+00, 5.1509373744E+00, 1.3145202641E+00, 9.4378925234E-01, 7.5448214566E-01],
	[1.8145000000E+04, 9.5562230211E+00, 5.1507610369E+00, 1.3156829737E+00, 9.4441954938E-01, 7.5459228360E-01],
	[1.8150000000E+04, 9.5600120227E+00, 5.1505847539E+00, 1.3168463905E+00, 9.4504996931E-01, 7.5470238390E-01],
	[1.8155000000E+04, 9.5638014823E+00, 5.1504085256E+00, 1.3180105147E+00, 9.4568051195E-01, 7.5481244654E-01],
	[1.8160000000E+04, 9.5675913998E+00, 5.1502323519E+00, 1.3191753465E+00, 9.4631117713E-01, 7.5492247152E-01],
	[1.8165000000E+04, 9.5713817753E+00, 5.1500562326E+00, 1.3203408862E+00, 9.4694196468E-01, 7.5503245885E-01],
	[1.8170000000E+04, 9.5751726086E+00, 5.1498801679E+00, 1.3215071340E+00, 9.4757287442E-01, 7.5514240852E-01],
	[1.8175000000E+04, 9.5789638997E+00, 5.1497041576E+00, 1.3226740902E+00, 9.4820390619E-01, 7.5525232053E-01],
	[1.8180000000E+04, 9.5827556484E+00, 5.1495282017E+00, 1.3238417549E+00, 9.4883505982E-01, 7.5536219488E-01],
	[1.8185000000E+04, 9.5865478548E+00, 5.1493523002E+00, 1.3250101285E+00, 9.4946633512E-01, 7.5547203157E-01],
	[1.8190000000E+04, 9.5903405187E+00, 5.1491764531E+00, 1.3261792111E+00, 9.5009773193E-01, 7.5558183058E-01],
	[1.8195000000E+04, 9.5941336401E+00, 5.1490006603E+00, 1.3273490030E+00, 9.5072925008E-01, 7.5569159193E-01],
	[1.8200000000E+04, 9.5979272189E+00, 5.1488249219E+00, 1.3285195044E+00, 9.5136088940E-01, 7.5580131562E-01],
	[1.8205000000E+04, 9.6017212550E+00, 5.1486492377E+00, 1.3296907156E+00, 9.5199264970E-01, 7.5591100163E-01],
	[1.8210000000E+04, 9.6055157485E+00, 5.1484736077E+00, 1.3308626367E+00, 9.5262453083E-01, 7.5602064997E-01],
	[1.8215000000E+04, 9.6093106991E+00, 5.1482980319E+00, 1.3320352681E+00, 9.5325653260E-01, 7.5613026063E-01],
	[1.8220000000E+04, 9.6131061068E+00, 5.1481225103E+00, 1.3332086099E+00, 9.5388865485E-01, 7.5623983362E-01],
	[1.8225000000E+04, 9.6169019716E+00, 5.1479470429E+00, 1.3343826624E+00, 9.5452089740E-01, 7.5634936893E-01],
	[1.8230000000E+04, 9.6207004624E+00, 5.1477722650E+00, 1.3355574259E+00, 9.5515330334E-01, 7.5645886656E-01],
	[1.8235000000E+04, 9.6245138286E+00, 5.1476017626E+00, 1.3367329005E+00, 9.5578611705E-01, 7.5656832651E-01],
	[1.8240000000E+04, 9.6283276602E+00, 5.1474313126E+00, 1.3379090865E+00, 9.5641905121E-01, 7.5667774878E-01],
	[1.8245000000E+04, 9.6321419571E+00, 5.1472609149E+00, 1.3390859841E+00, 9.5705210566E-01, 7.5678713337E-01],
	[1.8250000000E+04, 9.6359567193E+00, 5.1470905696E+00, 1.3402635936E+00, 9.5768528022E-01, 7.5689648027E-01],
	[1.8255000000E+04, 9.6397719467E+00, 5.1469202766E+00, 1.3414419153E+00, 9.5831857472E-01, 7.5700578948E-01],
	[1.8260000000E+04, 9.6435876392E+00, 5.1467500358E+00, 1.3426209492E+00, 9.5895198898E-01, 7.5711506101E-01],
	[1.8265000000E+04, 9.6474037968E+00, 5.1465798473E+00, 1.3438006957E+00, 9.5958552283E-01, 7.5722429485E-01],
	[1.8270000000E+04, 9.6512204194E+00, 5.1464097110E+00, 1.3449811550E+00, 9.6021917611E-01, 7.5733349099E-01],
	[1.8275000000E+04, 9.6550375069E+00, 5.1462396269E+00, 1.3461623274E+00, 9.6085294864E-01, 7.5744264945E-01],
	[1.8280000000E+04, 9.6588550592E+00, 5.1460695949E+00, 1.3473442131E+00, 9.6148684024E-01, 7.5755177021E-01],
	[1.8285000000E+04, 9.6626730763E+00, 5.1458996150E+00, 1.3485268122E+00, 9.6212085076E-01, 7.5766085328E-01],
	[1.8290000000E+04, 9.6664915582E+00, 5.1457296872E+00, 1.3497101251E+00, 9.6275498000E-01, 7.5776989866E-01],
	[1.8295000000E+04, 9.6703105046E+00, 5.1455598115E+00, 1.3508941520E+00, 9.6338922781E-01, 7.5787890634E-01],
	[1.8300000000E+04, 9.6741299156E+00, 5.1453899878E+00, 1.3520788931E+00, 9.6402359400E-01, 7.5798787631E-01],
	[1.8305000000E+04, 9.6779497912E+00, 5.1452202161E+00, 1.3532643487E+00, 9.6465807842E-01, 7.5809680860E-01],
	[1.8310000000E+04, 9.6817701311E+00, 5.1450504964E+00, 1.3544505189E+00, 9.6529268087E-01, 7.5820570318E-01],
	[1.8315000000E+04, 9.6855909354E+00, 5.1448808286E+00, 1.3556374041E+00, 9.6592740121E-01, 7.5831456006E-01],
	[1.8320000000E+04, 9.6894122040E+00, 5.1447112127E+00, 1.3568250044E+00, 9.6656223924E-01, 7.5842337924E-01],
	[1.8325000000E+04, 9.6932339367E+00, 5.1445416487E+00, 1.3580133201E+00, 9.6719719480E-01, 7.5853216071E-01],
	[1.8330000000E+04, 9.6970561337E+00, 5.1443721365E+00, 1.3592023514E+00, 9.6783226771E-01, 7.5864090448E-01],
	[1.8335000000E+04, 9.7008787947E+00, 5.1442026762E+00, 1.3603920986E+00, 9.6846745781E-01, 7.5874961055E-01],
	[1.8340000000E+04, 9.7047019197E+00, 5.1440332676E+00, 1.3615825619E+00, 9.6910276492E-01, 7.5885827891E-01],
	[1.8345000000E+04, 9.7085255086E+00, 5.1438639108E+00, 1.3627737416E+00, 9.6973818886E-01, 7.5896690956E-01],
	[1.8350000000E+04, 9.7123495614E+00, 5.1436946057E+00, 1.3639656378E+00, 9.7037372948E-01, 7.5907550251E-01],
	[1.8355000000E+04, 9.7161740780E+00, 5.1435253523E+00, 1.3651582508E+00, 9.7100938658E-01, 7.5918405775E-01],
	[1.8360000000E+04, 9.7199990583E+00, 5.1433561506E+00, 1.3663515808E+00, 9.7164516001E-01, 7.5929257527E-01],
	[1.8365000000E+04, 9.7238245023E+00, 5.1431870005E+00, 1.3675456281E+00, 9.7228104959E-01, 7.5940105509E-01],
	[1.8370000000E+04, 9.7276504098E+00, 5.1430179020E+00, 1.3687403930E+00, 9.7291705514E-01, 7.5950949720E-01],
	[1.8375000000E+04, 9.7314767808E+00, 5.1428488551E+00, 1.3699358755E+00, 9.7355317649E-01, 7.5961790159E-01],
	[1.8380000000E+04, 9.7353036153E+00, 5.1426798598E+00, 1.3711320761E+00, 9.7418941348E-01, 7.5972626828E-01],
	[1.8385000000E+04, 9.7391309132E+00, 5.1425109159E+00, 1.3723289949E+00, 9.7482576592E-01, 7.5983459725E-01],
	[1.8390000000E+04, 9.7429586744E+00, 5.1423420236E+00, 1.3735266321E+00, 9.7546223365E-01, 7.5994288850E-01],
	[1.8395000000E+04, 9.7467868987E+00, 5.1421731827E+00, 1.3747249880E+00, 9.7609881650E-01, 7.6005114205E-01],
	[1.8400000000E+04, 9.7506155863E+00, 5.1420043932E+00, 1.3759240628E+00, 9.7673551428E-01, 7.6015935787E-01],
	[1.8405000000E+04, 9.7544447369E+00, 5.1418356551E+00, 1.3771238568E+00, 9.7737232683E-01, 7.6026753598E-01],
	[1.8410000000E+04, 9.7582743506E+00, 5.1416669684E+00, 1.3783243701E+00, 9.7800925397E-01, 7.6037567638E-01],
	[1.8415000000E+04, 9.7621044272E+00, 5.1414983331E+00, 1.3795256031E+00, 9.7864629554E-01, 7.6048377906E-01],
	[1.8420000000E+04, 9.7659349667E+00, 5.1413297490E+00, 1.3807275560E+00, 9.7928345136E-01, 7.6059184402E-01],
	[1.8425000000E+04, 9.7697659691E+00, 5.1411612163E+00, 1.3819302289E+00, 9.7992072125E-01, 7.6069987126E-01],
	[1.8430000000E+04, 9.7735974341E+00, 5.1409927347E+00, 1.3831336222E+00, 9.8055810505E-01, 7.6080786079E-01],
	[1.8435000000E+04, 9.7774293618E+00, 5.1408243044E+00, 1.3843377361E+00, 9.8119560258E-01, 7.6091581260E-01],
	[1.8440000000E+04, 9.7812617522E+00, 5.1406559253E+00, 1.3855425707E+00, 9.8183321366E-01, 7.6102372661E-01],
	[1.8445000000E+04, 9.7850946050E+00, 5.1404875974E+00, 1.3867481264E+00, 9.8247093813E-01, 7.6113160276E-01],
	[1.8450000000E+04, 9.7889279204E+00, 5.1403193206E+00, 1.3879544034E+00, 9.8310877582E-01, 7.6123944106E-01],
	[1.8455000000E+04, 9.7927616981E+00, 5.1401510949E+00, 1.3891614019E+00, 9.8374672654E-01, 7.6134724151E-01],
	[1.8460000000E+04, 9.7965959381E+00, 5.1399829202E+00, 1.3903691221E+00, 9.8438479013E-01, 7.6145500411E-01],
	[1.8465000000E+04, 9.8004306405E+00, 5.1398147967E+00, 1.3915775643E+00, 9.8502296641E-01, 7.6156272886E-01],
	[1.8470000000E+04, 9.8042658049E+00, 5.1396467241E+00, 1.3927867287E+00, 9.8566125521E-01, 7.6167041576E-01],
	[1.8475000000E+04, 9.8081014316E+00, 5.1394787025E+00, 1.3939966156E+00, 9.8629965636E-01, 7.6177806482E-01],
	[1.8480000000E+04, 9.8119375202E+00, 5.1393107319E+00, 1.3952072251E+00, 9.8693816969E-01, 7.6188567604E-01],
	[1.8485000000E+04, 9.8157740708E+00, 5.1391428122E+00, 1.3964185576E+00, 9.8757679501E-01, 7.6199324942E-01],
	[1.8490000000E+04, 9.8196110834E+00, 5.1389749434E+00, 1.3976306132E+00, 9.8821553217E-01, 7.6210078495E-01],
	[1.8495000000E+04, 9.8234485578E+00, 5.1388071255E+00, 1.3988433923E+00, 9.8885438098E-01, 7.6220828265E-01],
	[1.8500000000E+04, 9.8272864939E+00, 5.1386393584E+00, 1.4000568949E+00, 9.8949334127E-01, 7.6231574251E-01],
	[1.8505000000E+04, 9.8311248918E+00, 5.1384716421E+00, 1.4012711215E+00, 9.9013241287E-01, 7.6242316454E-01],
	[1.8510000000E+04, 9.8349637513E+00, 5.1383039766E+00, 1.4024860721E+00, 9.9077159561E-01, 7.6253054874E-01],
	[1.8515000000E+04, 9.8388030723E+00, 5.1381363618E+00, 1.4037017470E+00, 9.9141088931E-01, 7.6263789511E-01],
	[1.8520000000E+04, 9.8426428548E+00, 5.1379687978E+00, 1.4049181466E+00, 9.9205029380E-01, 7.6274520364E-01],
	[1.8525000000E+04, 9.8464905268E+00, 5.1378033815E+00, 1.4061352709E+00, 9.9268996268E-01, 7.6285247435E-01],
	[1.8530000000E+04, 9.8503482254E+00, 5.1376407132E+00, 1.4073531203E+00, 9.9332994040E-01, 7.6295970724E-01],
	[1.8535000000E+04, 9.8542063939E+00, 5.1374780939E+00, 1.4085716950E+00, 9.9397002909E-01, 7.6306690231E-01],
	[1.8540000000E+04, 9.8580650324E+00, 5.1373155237E+00, 1.4097909951E+00, 9.9461022855E-01, 7.6317405955E-01],
	[1.8545000000E+04, 9.8619241407E+00, 5.1371530025E+00, 1.4110110210E+00, 9.9525053863E-01, 7.6328117898E-01],
	[1.8550000000E+04, 9.8657837188E+00, 5.1369905302E+00, 1.4122317730E+00, 9.9589095916E-01, 7.6338826059E-01],
	[1.8555000000E+04, 9.8696437666E+00, 5.1368281068E+00, 1.4134532511E+00, 9.9653148994E-01, 7.6349530438E-01],
	[1.8560000000E+04, 9.8735042841E+00, 5.1366657323E+00, 1.4146754557E+00, 9.9717213083E-01, 7.6360231037E-01],
	[1.8565000000E+04, 9.8773652711E+00, 5.1365034067E+00, 1.4158983869E+00, 9.9781288163E-01, 7.6370927854E-01],
	[1.8570000000E+04, 9.8812267276E+00, 5.1363411299E+00, 1.4171220452E+00, 9.9845374219E-01, 7.6381620891E-01],
	[1.8575000000E+04, 9.8850886535E+00, 5.1361789019E+00, 1.4183464305E+00, 9.9909471232E-01, 7.6392310147E-01],
	[1.8580000000E+04, 9.8889510488E+00, 5.1360167228E+00, 1.4195715433E+00, 9.9973579186E-01, 7.6402995623E-01],
	[1.8585000000E+04, 9.8928139133E+00, 5.1358545923E+00, 1.4207973837E+00, 1.0003769806E+00, 7.6413677318E-01],
	[1.8590000000E+04, 9.8966772471E+00, 5.1356925107E+00, 1.4220239520E+00, 1.0010182784E+00, 7.6424355234E-01],
	[1.8595000000E+04, 9.9005410500E+00, 5.1355304777E+00, 1.4232512484E+00, 1.0016596852E+00, 7.6435029370E-01],
	[1.8600000000E+04, 9.9044053220E+00, 5.1353684933E+00, 1.4244792731E+00, 1.0023012006E+00, 7.6445699727E-01],
	[1.8605000000E+04, 9.9082700630E+00, 5.1352065577E+00, 1.4257080264E+00, 1.0029428245E+00, 7.6456366304E-01],
	[1.8610000000E+04, 9.9121352730E+00, 5.1350446706E+00, 1.4269375085E+00, 1.0035845569E+00, 7.6467029102E-01],
	[1.8615000000E+04, 9.9160009518E+00, 5.1348828322E+00, 1.4281677197E+00, 1.0042263974E+00, 7.6477688122E-01],
	[1.8620000000E+04, 9.9198670994E+00, 5.1347210423E+00, 1.4293986601E+00, 1.0048683459E+00, 7.6488343363E-01],
	[1.8625000000E+04, 9.9237337158E+00, 5.1345593009E+00, 1.4306303301E+00, 1.0055104023E+00, 7.6498994826E-01],
	[1.8630000000E+04, 9.9276008008E+00, 5.1343976080E+00, 1.4318627298E+00, 1.0061525663E+00, 7.6509642511E-01],
	[1.8635000000E+04, 9.9314683545E+00, 5.1342359637E+00, 1.4330958596E+00, 1.0067948379E+00, 7.6520286418E-01],
	[1.8640000000E+04, 9.9353363766E+00, 5.1340743677E+00, 1.4343297195E+00, 1.0074372168E+00, 7.6530926547E-01],
	[1.8645000000E+04, 9.9392048672E+00, 5.1339128202E+00, 1.4355643099E+00, 1.0080797028E+00, 7.6541562900E-01],
	[1.8650000000E+04, 9.9430738262E+00, 5.1337513211E+00, 1.4367996311E+00, 1.0087222958E+00, 7.6552195475E-01],
	[1.8655000000E+04, 9.9469432535E+00, 5.1335898704E+00, 1.4380356831E+00, 1.0093649957E+00, 7.6562824273E-01],
	[1.8660000000E+04, 9.9508131491E+00, 5.1334284680E+00, 1.4392724664E+00, 1.0100078021E+00, 7.6573449295E-01],
	[1.8665000000E+04, 9.9546835128E+00, 5.1332671139E+00, 1.4405099810E+00, 1.0106507151E+00, 7.6584070540E-01],
	[1.8670000000E+04, 9.9585543447E+00, 5.1331058081E+00, 1.4417482273E+00, 1.0112937343E+00, 7.6594688010E-01],
	[1.8675000000E+04, 9.9624256446E+00, 5.1329445506E+00, 1.4429872055E+00, 1.0119368596E+00, 7.6605301704E-01],
	[1.8680000000E+04, 9.9662974124E+00, 5.1327833413E+00, 1.4442269158E+00, 1.0125800909E+00, 7.6615911622E-01],
	[1.8685000000E+04, 9.9701696482E+00, 5.1326221802E+00, 1.4454673584E+00, 1.0132234279E+00, 7.6626517765E-01],
	[1.8690000000E+04, 9.9740423518E+00, 5.1324610673E+00, 1.4467085336E+00, 1.0138668706E+00, 7.6637120133E-01],
	[1.8695000000E+04, 9.9779155232E+00, 5.1323000025E+00, 1.4479504417E+00, 1.0145104186E+00, 7.6647718726E-01],
	[1.8700000000E+04, 9.9817891623E+00, 5.1321389859E+00, 1.4491930828E+00, 1.0151540719E+00, 7.6658313545E-01],
	[1.8705000000E+04, 9.9856632690E+00, 5.1319780173E+00, 1.4504364572E+00, 1.0157978303E+00, 7.6668904589E-01],
	[1.8710000000E+04, 9.9895378433E+00, 5.1318170969E+00, 1.4516806046E+00, 1.0164417129E+00, 7.6679491860E-01],
	[1.8715000000E+04, 9.9934128851E+00, 5.1316562244E+00, 1.4529255623E+00, 1.0170857378E+00, 7.6690075357E-01],
	[1.8720000000E+04, 9.9972883943E+00, 5.1314954000E+00, 1.4541712543E+00, 1.0177298673E+00, 7.6700655081E-01],
	[1.8725000000E+04, 1.0001164371E+01, 5.1313346236E+00, 1.4554176806E+00, 1.0183741012E+00, 7.6711231032E-01],
	[1.8730000000E+04, 1.0005040815E+01, 5.1311738951E+00, 1.4566648416E+00, 1.0190184393E+00, 7.6721803210E-01],
	[1.8735000000E+04, 1.0008917726E+01, 5.1310132146E+00, 1.4579127376E+00, 1.0196628815E+00, 7.6732371615E-01],
	[1.8740000000E+04, 1.0012795104E+01, 5.1308525820E+00, 1.4591613686E+00, 1.0203074276E+00, 7.6742936249E-01],
	[1.8745000000E+04, 1.0016672949E+01, 5.1306919972E+00, 1.4604107350E+00, 1.0209520774E+00, 7.6753497110E-01],
	[1.8750000000E+04, 1.0020551262E+01, 5.1305314603E+00, 1.4616608370E+00, 1.0215968308E+00, 7.6764054200E-01],
	[1.8755000000E+04, 1.0024430041E+01, 5.1303709712E+00, 1.4629116748E+00, 1.0222416876E+00, 7.6774607518E-01],
	[1.8760000000E+04, 1.0028309287E+01, 5.1302105300E+00, 1.4641632487E+00, 1.0228866475E+00, 7.6785157066E-01],
	[1.8765000000E+04, 1.0032189000E+01, 5.1300501365E+00, 1.4654155590E+00, 1.0235317105E+00, 7.6795702842E-01],
	[1.8770000000E+04, 1.0036069180E+01, 5.1298897907E+00, 1.4666686057E+00, 1.0241768764E+00, 7.6806244848E-01],
	[1.8775000000E+04, 1.0039949826E+01, 5.1297294927E+00, 1.4679223893E+00, 1.0248221449E+00, 7.6816783084E-01],
	[1.8780000000E+04, 1.0043830939E+01, 5.1295692423E+00, 1.4691769099E+00, 1.0254675160E+00, 7.6827317551E-01],
	[1.8785000000E+04, 1.0047712519E+01, 5.1294090396E+00, 1.4704321677E+00, 1.0261129894E+00, 7.6837848247E-01],
	[1.8790000000E+04, 1.0051594565E+01, 5.1292488846E+00, 1.4716881630E+00, 1.0267585650E+00, 7.6848375175E-01],
	[1.8795000000E+04, 1.0055477077E+01, 5.1290887771E+00, 1.4729448961E+00, 1.0274042425E+00, 7.6858898333E-01],
	[1.8800000000E+04, 1.0059360056E+01, 5.1289287173E+00, 1.4742023671E+00, 1.0280500219E+00, 7.6869417723E-01],
	[1.8805000000E+04, 1.0063243501E+01, 5.1287687050E+00, 1.4754605763E+00, 1.0286959029E+00, 7.6879933345E-01],
	[1.8810000000E+04, 1.0067127412E+01, 5.1286087402E+00, 1.4767195240E+00, 1.0293418854E+00, 7.6890445199E-01],
	[1.8815000000E+04, 1.0071011789E+01, 5.1284488229E+00, 1.4779792103E+00, 1.0299879692E+00, 7.6900953285E-01],
	[1.8820000000E+04, 1.0074896633E+01, 5.1282889532E+00, 1.4792396356E+00, 1.0306341541E+00, 7.6911457604E-01],
	[1.8825000000E+04, 1.0078795841E+01, 5.1281329127E+00, 1.4805007999E+00, 1.0312807384E+00, 7.6921958155E-01],
	[1.8830000000E+04, 1.0082699023E+01, 5.1279778706E+00, 1.4817627037E+00, 1.0319274993E+00, 7.6932454940E-01],
	[1.8835000000E+04, 1.0086602679E+01, 5.1278228743E+00, 1.4830253471E+00, 1.0325743615E+00, 7.6942947959E-01],
	[1.8840000000E+04, 1.0090506810E+01, 5.1276679239E+00, 1.4842887304E+00, 1.0332213248E+00, 7.6953437212E-01],
	[1.8845000000E+04, 1.0094411415E+01, 5.1275130192E+00, 1.4855528537E+00, 1.0338683891E+00, 7.6963922698E-01],
	[1.8850000000E+04, 1.0098316495E+01, 5.1273581603E+00, 1.4868177174E+00, 1.0345155542E+00, 7.6974404420E-01],
	[1.8855000000E+04, 1.0102222050E+01, 5.1272033472E+00, 1.4880833216E+00, 1.0351628200E+00, 7.6984882377E-01],
	[1.8860000000E+04, 1.0106128078E+01, 5.1270485798E+00, 1.4893496667E+00, 1.0358101861E+00, 7.6995356568E-01],
	[1.8865000000E+04, 1.0110034581E+01, 5.1268938580E+00, 1.4906167528E+00, 1.0364576526E+00, 7.7005826996E-01],
	[1.8870000000E+04, 1.0113941558E+01, 5.1267391820E+00, 1.4918845801E+00, 1.0371052191E+00, 7.7016293659E-01],
	[1.8875000000E+04, 1.0117849010E+01, 5.1265845516E+00, 1.4931531490E+00, 1.0377528856E+00, 7.7026756559E-01],
	[1.8880000000E+04, 1.0121756935E+01, 5.1264299668E+00, 1.4944224597E+00, 1.0384006518E+00, 7.7037215695E-01],
	[1.8885000000E+04, 1.0125665334E+01, 5.1262754276E+00, 1.4956925123E+00, 1.0390485176E+00, 7.7047671069E-01],
	[1.8890000000E+04, 1.0129574208E+01, 5.1261209339E+00, 1.4969633071E+00, 1.0396964828E+00, 7.7058122679E-01],
	[1.8895000000E+04, 1.0133483555E+01, 5.1259664858E+00, 1.4982348444E+00, 1.0403445473E+00, 7.7068570528E-01],
	[1.8900000000E+04, 1.0137393376E+01, 5.1258120833E+00, 1.4995071244E+00, 1.0409927108E+00, 7.7079014614E-01],
	[1.8905000000E+04, 1.0141303670E+01, 5.1256577262E+00, 1.5007801473E+00, 1.0416409732E+00, 7.7089454939E-01],
	[1.8910000000E+04, 1.0145214439E+01, 5.1255034146E+00, 1.5020539134E+00, 1.0422893343E+00, 7.7099891503E-01],
	[1.8915000000E+04, 1.0149125681E+01, 5.1253491484E+00, 1.5033284229E+00, 1.0429377940E+00, 7.7110324305E-01],
	[1.8920000000E+04, 1.0153037396E+01, 5.1251949276E+00, 1.5046036761E+00, 1.0435863520E+00, 7.7120753348E-01],
	[1.8925000000E+04, 1.0156949585E+01, 5.1250407522E+00, 1.5058796731E+00, 1.0442350082E+00, 7.7131178630E-01],
	[1.8930000000E+04, 1.0160862247E+01, 5.1248866222E+00, 1.5071564143E+00, 1.0448837625E+00, 7.7141600152E-01],
	[1.8935000000E+04, 1.0164775383E+01, 5.1247325376E+00, 1.5084338998E+00, 1.0455326146E+00, 7.7152017915E-01],
	[1.8940000000E+04, 1.0168688992E+01, 5.1245784982E+00, 1.5097121299E+00, 1.0461815643E+00, 7.7162431919E-01],
	[1.8945000000E+04, 1.0172603074E+01, 5.1244245041E+00, 1.5109911048E+00, 1.0468306116E+00, 7.7172842164E-01],
	[1.8950000000E+04, 1.0176517629E+01, 5.1242705553E+00, 1.5122708248E+00, 1.0474797562E+00, 7.7183248650E-01],
	[1.8955000000E+04, 1.0180432657E+01, 5.1241166517E+00, 1.5135512901E+00, 1.0481289980E+00, 7.7193651379E-01],
	[1.8960000000E+04, 1.0184348159E+01, 5.1239627934E+00, 1.5148325009E+00, 1.0487783367E+00, 7.7204050350E-01],
	[1.8965000000E+04, 1.0188264133E+01, 5.1238089802E+00, 1.5161144575E+00, 1.0494277723E+00, 7.7214445564E-01],
	[1.8970000000E+04, 1.0192180580E+01, 5.1236552122E+00, 1.5173971601E+00, 1.0500773045E+00, 7.7224837022E-01],
	[1.8975000000E+04, 1.0196097499E+01, 5.1235014893E+00, 1.5186806090E+00, 1.0507269331E+00, 7.7235224722E-01],
	[1.8980000000E+04, 1.0200014892E+01, 5.1233478116E+00, 1.5199648043E+00, 1.0513766581E+00, 7.7245608667E-01],
	[1.8985000000E+04, 1.0203932757E+01, 5.1231941789E+00, 1.5212497464E+00, 1.0520264791E+00, 7.7255988856E-01],
	[1.8990000000E+04, 1.0207851095E+01, 5.1230405913E+00, 1.5225354354E+00, 1.0526763961E+00, 7.7266365290E-01],
	[1.8995000000E+04, 1.0211769905E+01, 5.1228870487E+00, 1.5238218716E+00, 1.0533264089E+00, 7.7276737968E-01],
	[1.9000000000E+04, 1.0215689188E+01, 5.1227335511E+00, 1.5251090553E+00, 1.0539765173E+00, 7.7287106893E-01],
	[1.9005000000E+04, 1.0219608943E+01, 5.1225800986E+00, 1.5263969866E+00, 1.0546267211E+00, 7.7297472063E-01],
	[1.9010000000E+04, 1.0223529170E+01, 5.1224266909E+00, 1.5276856658E+00, 1.0552770201E+00, 7.7307833479E-01],
	[1.9015000000E+04, 1.0227449869E+01, 5.1222733283E+00, 1.5289750932E+00, 1.0559274143E+00, 7.7318191142E-01],
	[1.9020000000E+04, 1.0231371041E+01, 5.1221200105E+00, 1.5302652690E+00, 1.0565779033E+00, 7.7328545052E-01],
	[1.9025000000E+04, 1.0235292685E+01, 5.1219667376E+00, 1.5315561933E+00, 1.0572284870E+00, 7.7338895210E-01],
	[1.9030000000E+04, 1.0239214801E+01, 5.1218135096E+00, 1.5328478666E+00, 1.0578791654E+00, 7.7349241615E-01],
	[1.9035000000E+04, 1.0243137389E+01, 5.1216603264E+00, 1.5341402889E+00, 1.0585299381E+00, 7.7359584269E-01],
	[1.9040000000E+04, 1.0247060448E+01, 5.1215071880E+00, 1.5354334606E+00, 1.0591808050E+00, 7.7369923172E-01],
	[1.9045000000E+04, 1.0250983980E+01, 5.1213540944E+00, 1.5367273818E+00, 1.0598317659E+00, 7.7380258323E-01],
	[1.9050000000E+04, 1.0254907983E+01, 5.1212010456E+00, 1.5380220528E+00, 1.0604828207E+00, 7.7390589724E-01],
	[1.9055000000E+04, 1.0258832458E+01, 5.1210480415E+00, 1.5393174739E+00, 1.0611339692E+00, 7.7400917375E-01],
	[1.9060000000E+04, 1.0262757405E+01, 5.1208950821E+00, 1.5406136452E+00, 1.0617852113E+00, 7.7411241276E-01],
	[1.9065000000E+04, 1.0266682823E+01, 5.1207421674E+00, 1.5419105671E+00, 1.0624365466E+00, 7.7421561428E-01],
	[1.9070000000E+04, 1.0270608713E+01, 5.1205892974E+00, 1.5432082397E+00, 1.0630879752E+00, 7.7431877831E-01],
	[1.9075000000E+04, 1.0274535074E+01, 5.1204364720E+00, 1.5445066633E+00, 1.0637394967E+00, 7.7442190486E-01],
	[1.9080000000E+04, 1.0278461907E+01, 5.1202836912E+00, 1.5458058381E+00, 1.0643911111E+00, 7.7452499392E-01],
	[1.9085000000E+04, 1.0282389211E+01, 5.1201309550E+00, 1.5471057644E+00, 1.0650428181E+00, 7.7462804551E-01],
	[1.9090000000E+04, 1.0286316986E+01, 5.1199782634E+00, 1.5484064423E+00, 1.0656946176E+00, 7.7473105963E-01],
	[1.9095000000E+04, 1.0290245232E+01, 5.1198256163E+00, 1.5497078723E+00, 1.0663465093E+00, 7.7483403628E-01],
	[1.9100000000E+04, 1.0294173949E+01, 5.1196730138E+00, 1.5510100544E+00, 1.0669984933E+00, 7.7493697547E-01],
	[1.9105000000E+04, 1.0298103138E+01, 5.1195204557E+00, 1.5523129889E+00, 1.0676505691E+00, 7.7503987720E-01],
	[1.9110000000E+04, 1.0302032797E+01, 5.1193679421E+00, 1.5536166760E+00, 1.0683027368E+00, 7.7514274147E-01],
	[1.9115000000E+04, 1.0305962927E+01, 5.1192154729E+00, 1.5549211161E+00, 1.0689549961E+00, 7.7524556829E-01],
	[1.9120000000E+04, 1.0309893529E+01, 5.1190630481E+00, 1.5562263092E+00, 1.0696073468E+00, 7.7534835767E-01],
	[1.9125000000E+04, 1.0313828169E+01, 5.1189116043E+00, 1.5575322558E+00, 1.0702598681E+00, 7.7545110961E-01],
	[1.9130000000E+04, 1.0317777529E+01, 5.1187639418E+00, 1.5588389559E+00, 1.0709127978E+00, 7.7555382410E-01],
	[1.9135000000E+04, 1.0321727369E+01, 5.1186163223E+00, 1.5601464099E+00, 1.0715658191E+00, 7.7565650117E-01],
	[1.9140000000E+04, 1.0325677688E+01, 5.1184687455E+00, 1.5614546179E+00, 1.0722189319E+00, 7.7575914081E-01],
	[1.9145000000E+04, 1.0329628487E+01, 5.1183212116E+00, 1.5627635802E+00, 1.0728721360E+00, 7.7586174302E-01],
	[1.9150000000E+04, 1.0333579766E+01, 5.1181737204E+00, 1.5640732971E+00, 1.0735254312E+00, 7.7596430781E-01],
	[1.9155000000E+04, 1.0337531523E+01, 5.1180262720E+00, 1.5653837688E+00, 1.0741788173E+00, 7.7606683519E-01],
	[1.9160000000E+04, 1.0341483760E+01, 5.1178788663E+00, 1.5666949955E+00, 1.0748322943E+00, 7.7616932516E-01],
	[1.9165000000E+04, 1.0345436476E+01, 5.1177315033E+00, 1.5680069774E+00, 1.0754858618E+00, 7.7627177772E-01],
	[1.9170000000E+04, 1.0349389671E+01, 5.1175841830E+00, 1.5693197149E+00, 1.0761395198E+00, 7.7637419288E-01],
	[1.9175000000E+04, 1.0353343345E+01, 5.1174369054E+00, 1.5706332081E+00, 1.0767932680E+00, 7.7647657065E-01],
	[1.9180000000E+04, 1.0357297498E+01, 5.1172896704E+00, 1.5719474572E+00, 1.0774471064E+00, 7.7657891102E-01],
	[1.9185000000E+04, 1.0361252130E+01, 5.1171424780E+00, 1.5732624626E+00, 1.0781010346E+00, 7.7668121400E-01],
	[1.9190000000E+04, 1.0365207241E+01, 5.1169953282E+00, 1.5745782244E+00, 1.0787550527E+00, 7.7678347959E-01],
	[1.9195000000E+04, 1.0369162831E+01, 5.1168482210E+00, 1.5758947429E+00, 1.0794091602E+00, 7.7688570774E-01],
	[1.9200000000E+04, 1.0373118899E+01, 5.1167011563E+00, 1.5772120183E+00, 1.0800633572E+00, 7.7698789843E-01],
	[1.9205000000E+04, 1.0377075446E+01, 5.1165541341E+00, 1.5785300509E+00, 1.0807176434E+00, 7.7709005167E-01],
	[1.9210000000E+04, 1.0381032472E+01, 5.1164071544E+00, 1.5798488409E+00, 1.0813720187E+00, 7.7719216745E-01],
	[1.9215000000E+04, 1.0384989976E+01, 5.1162602172E+00, 1.5811683885E+00, 1.0820264828E+00, 7.7729424578E-01],
	[1.9220000000E+04, 1.0388947958E+01, 5.1161133224E+00, 1.5824886940E+00, 1.0826810357E+00, 7.7739628666E-01],
	[1.9225000000E+04, 1.0392906419E+01, 5.1159664701E+00, 1.5838097576E+00, 1.0833356771E+00, 7.7749829009E-01],
	[1.9230000000E+04, 1.0396865359E+01, 5.1158196602E+00, 1.5851315795E+00, 1.0839904068E+00, 7.7760025606E-01],
	[1.9235000000E+04, 1.0400824776E+01, 5.1156728926E+00, 1.5864541600E+00, 1.0846452247E+00, 7.7770218458E-01],
	[1.9240000000E+04, 1.0404784672E+01, 5.1155261674E+00, 1.5877774993E+00, 1.0853001307E+00, 7.7780407564E-01],
	[1.9245000000E+04, 1.0408745045E+01, 5.1153794845E+00, 1.5891015977E+00, 1.0859551245E+00, 7.7790592925E-01],
	[1.9250000000E+04, 1.0412705897E+01, 5.1152328440E+00, 1.5904264554E+00, 1.0866102060E+00, 7.7800774541E-01],
	[1.9255000000E+04, 1.0416667227E+01, 5.1150862457E+00, 1.5917520726E+00, 1.0872653749E+00, 7.7810952412E-01],
	[1.9260000000E+04, 1.0420629035E+01, 5.1149396897E+00, 1.5930784496E+00, 1.0879206312E+00, 7.7821126537E-01],
	[1.9265000000E+04, 1.0424591320E+01, 5.1147931759E+00, 1.5944055866E+00, 1.0885759747E+00, 7.7831296917E-01],
	[1.9270000000E+04, 1.0428554084E+01, 5.1146467044E+00, 1.5957334839E+00, 1.0892314051E+00, 7.7841463552E-01],
	[1.9275000000E+04, 1.0432517325E+01, 5.1145002750E+00, 1.5970621416E+00, 1.0898869224E+00, 7.7851626442E-01],
	[1.9280000000E+04, 1.0436481044E+01, 5.1143538878E+00, 1.5983915601E+00, 1.0905425262E+00, 7.7861785586E-01],
	[1.9285000000E+04, 1.0440445240E+01, 5.1142075428E+00, 1.5997217395E+00, 1.0911982166E+00, 7.7871940985E-01],
	[1.9290000000E+04, 1.0444409914E+01, 5.1140612398E+00, 1.6010526801E+00, 1.0918539932E+00, 7.7882092639E-01],
	[1.9295000000E+04, 1.0448375065E+01, 5.1139149790E+00, 1.6023843821E+00, 1.0925098559E+00, 7.7892240548E-01],
	[1.9300000000E+04, 1.0452340694E+01, 5.1137687603E+00, 1.6037168459E+00, 1.0931658046E+00, 7.7902384712E-01],
	[1.9305000000E+04, 1.0456306800E+01, 5.1136225836E+00, 1.6050500715E+00, 1.0938218391E+00, 7.7912525131E-01],
	[1.9310000000E+04, 1.0460273383E+01, 5.1134764489E+00, 1.6063840593E+00, 1.0944779591E+00, 7.7922661806E-01],
	[1.9315000000E+04, 1.0464240443E+01, 5.1133303563E+00, 1.6077188094E+00, 1.0951341646E+00, 7.7932794735E-01],
	[1.9320000000E+04, 1.0468207981E+01, 5.1131843056E+00, 1.6090543222E+00, 1.0957904554E+00, 7.7942923919E-01],
	[1.9325000000E+04, 1.0472175996E+01, 5.1130382969E+00, 1.6103905979E+00, 1.0964468312E+00, 7.7953049358E-01],
	[1.9330000000E+04, 1.0476144487E+01, 5.1128923301E+00, 1.6117276366E+00, 1.0971032919E+00, 7.7963171053E-01],
	[1.9335000000E+04, 1.0480113456E+01, 5.1127464053E+00, 1.6130654387E+00, 1.0977598374E+00, 7.7973289003E-01],
	[1.9340000000E+04, 1.0484082901E+01, 5.1126005223E+00, 1.6144040043E+00, 1.0984164674E+00, 7.7983403209E-01],
	[1.9345000000E+04, 1.0488052823E+01, 5.1124546812E+00, 1.6157433338E+00, 1.0990731818E+00, 7.7993513670E-01],
	[1.9350000000E+04, 1.0492023222E+01, 5.1123088820E+00, 1.6170834273E+00, 1.0997299804E+00, 7.8003620386E-01],
	[1.9355000000E+04, 1.0495994098E+01, 5.1121631246E+00, 1.6184242851E+00, 1.1003868631E+00, 7.8013723358E-01],
	[1.9360000000E+04, 1.0499965450E+01, 5.1120174090E+00, 1.6197659075E+00, 1.1010438296E+00, 7.8023822586E-01],
	[1.9365000000E+04, 1.0503937278E+01, 5.1118717352E+00, 1.6211082946E+00, 1.1017008799E+00, 7.8033918069E-01],
	[1.9370000000E+04, 1.0507909583E+01, 5.1117261031E+00, 1.6224514467E+00, 1.1023580136E+00, 7.8044009808E-01],
	[1.9375000000E+04, 1.0511882365E+01, 5.1115805128E+00, 1.6237953640E+00, 1.1030152308E+00, 7.8054097803E-01],
	[1.9380000000E+04, 1.0515855623E+01, 5.1114349642E+00, 1.6251400468E+00, 1.1036725311E+00, 7.8064182054E-01],
	[1.9385000000E+04, 1.0519829357E+01, 5.1112894572E+00, 1.6264854953E+00, 1.1043299144E+00, 7.8074262561E-01],
	[1.9390000000E+04, 1.0523803567E+01, 5.1111439920E+00, 1.6278317098E+00, 1.1049873805E+00, 7.8084339324E-01],
	[1.9395000000E+04, 1.0527778253E+01, 5.1109985684E+00, 1.6291786905E+00, 1.1056449294E+00, 7.8094412343E-01],
	[1.9400000000E+04, 1.0531753416E+01, 5.1108531864E+00, 1.6305264376E+00, 1.1063025607E+00, 7.8104481619E-01],
	[1.9405000000E+04, 1.0535729054E+01, 5.1107078460E+00, 1.6318749513E+00, 1.1069602743E+00, 7.8114547151E-01],
	[1.9410000000E+04, 1.0539705169E+01, 5.1105625471E+00, 1.6332242320E+00, 1.1076180700E+00, 7.8124608940E-01],
	[1.9415000000E+04, 1.0543681759E+01, 5.1104172899E+00, 1.6345742798E+00, 1.1082759478E+00, 7.8134666985E-01],
	[1.9420000000E+04, 1.0547658825E+01, 5.1102720741E+00, 1.6359250950E+00, 1.1089339073E+00, 7.8144721287E-01],
	[1.9425000000E+04, 1.0551636367E+01, 5.1101268999E+00, 1.6372766778E+00, 1.1095919485E+00, 7.8154771845E-01],
	[1.9430000000E+04, 1.0555614384E+01, 5.1099817672E+00, 1.6386290285E+00, 1.1102500711E+00, 7.8164818661E-01],
	[1.9435000000E+04, 1.0559604300E+01, 5.1098395661E+00, 1.6399821472E+00, 1.1109085381E+00, 7.8174861734E-01],
	[1.9440000000E+04, 1.0563601514E+01, 5.1096991300E+00, 1.6413360343E+00, 1.1115672437E+00, 7.8184901064E-01],
	[1.9445000000E+04, 1.0567599212E+01, 5.1095587339E+00, 1.6426906900E+00, 1.1122260310E+00, 7.8194936651E-01],
	[1.9450000000E+04, 1.0571597395E+01, 5.1094183777E+00, 1.6440461145E+00, 1.1128848998E+00, 7.8204968495E-01],
	[1.9455000000E+04, 1.0575596063E+01, 5.1092780615E+00, 1.6454023080E+00, 1.1135438499E+00, 7.8214996597E-01],
	[1.9460000000E+04, 1.0579595215E+01, 5.1091377851E+00, 1.6467592708E+00, 1.1142028812E+00, 7.8225020957E-01],
	[1.9465000000E+04, 1.0583594851E+01, 5.1089975487E+00, 1.6481170031E+00, 1.1148619935E+00, 7.8235041574E-01],
	[1.9470000000E+04, 1.0587594971E+01, 5.1088573521E+00, 1.6494755052E+00, 1.1155211867E+00, 7.8245058450E-01],
	[1.9475000000E+04, 1.0591595576E+01, 5.1087171954E+00, 1.6508347773E+00, 1.1161804605E+00, 7.8255071583E-01],
	[1.9480000000E+04, 1.0595596664E+01, 5.1085770785E+00, 1.6521948196E+00, 1.1168398147E+00, 7.8265080975E-01],
	[1.9485000000E+04, 1.0599598237E+01, 5.1084370014E+00, 1.6535556324E+00, 1.1174992493E+00, 7.8275086625E-01],
	[1.9490000000E+04, 1.0603600294E+01, 5.1082969641E+00, 1.6549172159E+00, 1.1181587641E+00, 7.8285088533E-01],
	[1.9495000000E+04, 1.0607602834E+01, 5.1081569665E+00, 1.6562795704E+00, 1.1188183587E+00, 7.8295086700E-01],
	[1.9500000000E+04, 1.0611605859E+01, 5.1080170087E+00, 1.6576426960E+00, 1.1194780332E+00, 7.8305081126E-01],
	[1.9505000000E+04, 1.0615609367E+01, 5.1078770905E+00, 1.6590065931E+00, 1.1201377873E+00, 7.8315071810E-01],
	[1.9510000000E+04, 1.0619613359E+01, 5.1077372121E+00, 1.6603712619E+00, 1.1207976209E+00, 7.8325058754E-01],
	[1.9515000000E+04, 1.0623617834E+01, 5.1075973734E+00, 1.6617367025E+00, 1.1214575337E+00, 7.8335041957E-01],
	[1.9520000000E+04, 1.0627622793E+01, 5.1074575743E+00, 1.6631029153E+00, 1.1221175257E+00, 7.8345021419E-01],
	[1.9525000000E+04, 1.0631628236E+01, 5.1073178148E+00, 1.6644699005E+00, 1.1227775965E+00, 7.8354997140E-01],
	[1.9530000000E+04, 1.0635634162E+01, 5.1071780949E+00, 1.6658376583E+00, 1.1234377462E+00, 7.8364969122E-01],
	[1.9535000000E+04, 1.0639640571E+01, 5.1070384147E+00, 1.6672061889E+00, 1.1240979744E+00, 7.8374937363E-01],
	[1.9540000000E+04, 1.0643647464E+01, 5.1068987739E+00, 1.6685754927E+00, 1.1247582810E+00, 7.8384901864E-01],
	[1.9545000000E+04, 1.0647654840E+01, 5.1067591728E+00, 1.6699455697E+00, 1.1254186659E+00, 7.8394862625E-01],
	[1.9550000000E+04, 1.0651662699E+01, 5.1066196111E+00, 1.6713164204E+00, 1.1260791289E+00, 7.8404819647E-01],
	[1.9555000000E+04, 1.0655671041E+01, 5.1064800890E+00, 1.6726880449E+00, 1.1267396698E+00, 7.8414772929E-01],
	[1.9560000000E+04, 1.0659679866E+01, 5.1063406063E+00, 1.6740604434E+00, 1.1274002884E+00, 7.8424722472E-01],
	[1.9565000000E+04, 1.0663689175E+01, 5.1062011631E+00, 1.6754336162E+00, 1.1280609845E+00, 7.8434668276E-01],
	[1.9570000000E+04, 1.0667698966E+01, 5.1060617594E+00, 1.6768075635E+00, 1.1287217581E+00, 7.8444610341E-01],
	[1.9575000000E+04, 1.0671709240E+01, 5.1059223950E+00, 1.6781822856E+00, 1.1293826088E+00, 7.8454548667E-01],
	[1.9580000000E+04, 1.0675719997E+01, 5.1057830701E+00, 1.6795577827E+00, 1.1300435366E+00, 7.8464483254E-01],
	[1.9585000000E+04, 1.0679731236E+01, 5.1056437845E+00, 1.6809340550E+00, 1.1307045413E+00, 7.8474414103E-01],
	[1.9590000000E+04, 1.0683742958E+01, 5.1055045383E+00, 1.6823111028E+00, 1.1313656227E+00, 7.8484341214E-01],
	[1.9595000000E+04, 1.0687755163E+01, 5.1053653314E+00, 1.6836889263E+00, 1.1320267806E+00, 7.8494264587E-01],
	[1.9600000000E+04, 1.0691767850E+01, 5.1052261638E+00, 1.6850675258E+00, 1.1326880149E+00, 7.8504184222E-01],
	[1.9605000000E+04, 1.0695781020E+01, 5.1050870355E+00, 1.6864469015E+00, 1.1333493253E+00, 7.8514100120E-01],
	[1.9610000000E+04, 1.0699794672E+01, 5.1049479465E+00, 1.6878270536E+00, 1.1340107118E+00, 7.8524012280E-01],
	[1.9615000000E+04, 1.0703808807E+01, 5.1048088967E+00, 1.6892079824E+00, 1.1346721741E+00, 7.8533920703E-01],
	[1.9620000000E+04, 1.0707823424E+01, 5.1046698862E+00, 1.6905896881E+00, 1.1353337121E+00, 7.8543825389E-01],
	[1.9625000000E+04, 1.0711838523E+01, 5.1045309148E+00, 1.6919721709E+00, 1.1359953256E+00, 7.8553726338E-01],
	[1.9630000000E+04, 1.0715854104E+01, 5.1043919826E+00, 1.6933554311E+00, 1.1366570144E+00, 7.8563623550E-01],
	[1.9635000000E+04, 1.0719870167E+01, 5.1042530896E+00, 1.6947394690E+00, 1.1373187783E+00, 7.8573517027E-01],
	[1.9640000000E+04, 1.0723886712E+01, 5.1041142358E+00, 1.6961242847E+00, 1.1379806173E+00, 7.8583406767E-01],
	[1.9645000000E+04, 1.0727903739E+01, 5.1039754211E+00, 1.6975098785E+00, 1.1386425311E+00, 7.8593292771E-01],
	[1.9650000000E+04, 1.0731921248E+01, 5.1038366454E+00, 1.6988962507E+00, 1.1393045195E+00, 7.8603175039E-01],
	[1.9655000000E+04, 1.0735939239E+01, 5.1036979089E+00, 1.7002834014E+00, 1.1399665823E+00, 7.8613053572E-01],
	[1.9660000000E+04, 1.0739957712E+01, 5.1035592114E+00, 1.7016713309E+00, 1.1406287195E+00, 7.8622928370E-01],
	[1.9665000000E+04, 1.0743976666E+01, 5.1034205529E+00, 1.7030600396E+00, 1.1412909308E+00, 7.8632799433E-01],
	[1.9670000000E+04, 1.0747996102E+01, 5.1032819335E+00, 1.7044495275E+00, 1.1419532161E+00, 7.8642666761E-01],
	[1.9675000000E+04, 1.0752016019E+01, 5.1031433530E+00, 1.7058397949E+00, 1.1426155751E+00, 7.8652530354E-01],
	[1.9680000000E+04, 1.0756036418E+01, 5.1030048115E+00, 1.7072308421E+00, 1.1432780077E+00, 7.8662390213E-01],
	[1.9685000000E+04, 1.0760057298E+01, 5.1028663090E+00, 1.7086226693E+00, 1.1439405138E+00, 7.8672246338E-01],
	[1.9690000000E+04, 1.0764078660E+01, 5.1027278454E+00, 1.7100152768E+00, 1.1446030932E+00, 7.8682098729E-01],
	[1.9695000000E+04, 1.0768100503E+01, 5.1025894208E+00, 1.7114086647E+00, 1.1452657457E+00, 7.8691947387E-01],
	[1.9700000000E+04, 1.0772122827E+01, 5.1024510350E+00, 1.7128028334E+00, 1.1459284710E+00, 7.8701792311E-01],
	[1.9705000000E+04, 1.0776145632E+01, 5.1023126881E+00, 1.7141977831E+00, 1.1465912692E+00, 7.8711633502E-01],
	[1.9710000000E+04, 1.0780168919E+01, 5.1021743800E+00, 1.7155935139E+00, 1.1472541399E+00, 7.8721470960E-01],
	[1.9715000000E+04, 1.0784192686E+01, 5.1020361108E+00, 1.7169900262E+00, 1.1479170830E+00, 7.8731304686E-01],
	[1.9720000000E+04, 1.0788216935E+01, 5.1018978803E+00, 1.7183873202E+00, 1.1485800984E+00, 7.8741134680E-01],
	[1.9725000000E+04, 1.0792241664E+01, 5.1017596887E+00, 1.7197853961E+00, 1.1492431859E+00, 7.8750960941E-01],
	[1.9730000000E+04, 1.0796266875E+01, 5.1016215358E+00, 1.7211842541E+00, 1.1499063452E+00, 7.8760783470E-01],
	[1.9735000000E+04, 1.0800292566E+01, 5.1014834217E+00, 1.7225838946E+00, 1.1505695763E+00, 7.8770602268E-01],
	[1.9740000000E+04, 1.0804318737E+01, 5.1013453463E+00, 1.7239843177E+00, 1.1512328789E+00, 7.8780417335E-01],
	[1.9745000000E+04, 1.0808346527E+01, 5.1012075874E+00, 1.7253855237E+00, 1.1518962800E+00, 7.8790228671E-01],
	[1.9750000000E+04, 1.0812392331E+01, 5.1010741456E+00, 1.7267875127E+00, 1.1525601701E+00, 7.8800036276E-01],
	[1.9755000000E+04, 1.0816438625E+01, 5.1009407410E+00, 1.7281902852E+00, 1.1532241319E+00, 7.8809840150E-01],
	[1.9760000000E+04, 1.0820485409E+01, 5.1008073738E+00, 1.7295938412E+00, 1.1538881653E+00, 7.8819640294E-01],
	[1.9765000000E+04, 1.0824532682E+01, 5.1006740437E+00, 1.7309981810E+00, 1.1545522703E+00, 7.8829436708E-01],
	[1.9770000000E+04, 1.0828580444E+01, 5.1005407509E+00, 1.7324033050E+00, 1.1552164465E+00, 7.8839229393E-01],
	[1.9775000000E+04, 1.0832628696E+01, 5.1004074952E+00, 1.7338092132E+00, 1.1558806938E+00, 7.8849018348E-01],
	[1.9780000000E+04, 1.0836677438E+01, 5.1002742767E+00, 1.7352159060E+00, 1.1565450121E+00, 7.8858803575E-01],
	[1.9785000000E+04, 1.0840726669E+01, 5.1001410954E+00, 1.7366233835E+00, 1.1572094012E+00, 7.8868585072E-01],
	[1.9790000000E+04, 1.0844776389E+01, 5.1000079512E+00, 1.7380316461E+00, 1.1578738609E+00, 7.8878362841E-01],
	[1.9795000000E+04, 1.0848826598E+01, 5.0998748441E+00, 1.7394406940E+00, 1.1585383911E+00, 7.8888136882E-01],
	[1.9800000000E+04, 1.0852877296E+01, 5.0997417741E+00, 1.7408505273E+00, 1.1592029915E+00, 7.8897907195E-01],
	[1.9805000000E+04, 1.0856928484E+01, 5.0996087411E+00, 1.7422611464E+00, 1.1598676620E+00, 7.8907673780E-01],
	[1.9810000000E+04, 1.0860980161E+01, 5.0994757453E+00, 1.7436725515E+00, 1.1605324025E+00, 7.8917436638E-01],
	[1.9815000000E+04, 1.0865032326E+01, 5.0993427864E+00, 1.7450847428E+00, 1.1611972127E+00, 7.8927195768E-01],
	[1.9820000000E+04, 1.0869084981E+01, 5.0992098646E+00, 1.7464977205E+00, 1.1618620925E+00, 7.8936951173E-01],
	[1.9825000000E+04, 1.0873138124E+01, 5.0990769797E+00, 1.7479114850E+00, 1.1625270417E+00, 7.8946702850E-01],
	[1.9830000000E+04, 1.0877191756E+01, 5.0989441318E+00, 1.7493260364E+00, 1.1631920602E+00, 7.8956450802E-01],
	[1.9835000000E+04, 1.0881245877E+01, 5.0988113209E+00, 1.7507413749E+00, 1.1638571478E+00, 7.8966195028E-01],
	[1.9840000000E+04, 1.0885300486E+01, 5.0986785469E+00, 1.7521575009E+00, 1.1645223042E+00, 7.8975935528E-01],
	[1.9845000000E+04, 1.0889355584E+01, 5.0985458098E+00, 1.7535744145E+00, 1.1651875294E+00, 7.8985672303E-01],
	[1.9850000000E+04, 1.0893411170E+01, 5.0984131096E+00, 1.7549921160E+00, 1.1658528232E+00, 7.8995405354E-01],
	[1.9855000000E+04, 1.0897467245E+01, 5.0982804463E+00, 1.7564106057E+00, 1.1665181854E+00, 7.9005134680E-01],
	[1.9860000000E+04, 1.0901523809E+01, 5.0981478199E+00, 1.7578298837E+00, 1.1671836158E+00, 7.9014860281E-01],
	[1.9865000000E+04, 1.0905580860E+01, 5.0980152302E+00, 1.7592499503E+00, 1.1678491143E+00, 7.9024582159E-01],
	[1.9870000000E+04, 1.0909638400E+01, 5.0978826774E+00, 1.7606708058E+00, 1.1685146806E+00, 7.9034300313E-01],
	[1.9875000000E+04, 1.0913696428E+01, 5.0977501614E+00, 1.7620924504E+00, 1.1691803147E+00, 7.9044014744E-01],
	[1.9880000000E+04, 1.0917754944E+01, 5.0976176822E+00, 1.7635148843E+00, 1.1698460163E+00, 7.9053725452E-01],
	[1.9885000000E+04, 1.0921813948E+01, 5.0974852397E+00, 1.7649381077E+00, 1.1705117853E+00, 7.9063432438E-01],
	[1.9890000000E+04, 1.0925873441E+01, 5.0973528339E+00, 1.7663621210E+00, 1.1711776214E+00, 7.9073135701E-01],
	[1.9895000000E+04, 1.0929933421E+01, 5.0972204649E+00, 1.7677869243E+00, 1.1718435247E+00, 7.9082835243E-01],
	[1.9900000000E+04, 1.0933993889E+01, 5.0970881326E+00, 1.7692125179E+00, 1.1725094948E+00, 7.9092531063E-01],
	[1.9905000000E+04, 1.0938054845E+01, 5.0969558370E+00, 1.7706389020E+00, 1.1731755316E+00, 7.9102223161E-01],
	[1.9910000000E+04, 1.0942116288E+01, 5.0968235780E+00, 1.7720660768E+00, 1.1738416349E+00, 7.9111911539E-01],
	[1.9915000000E+04, 1.0946178220E+01, 5.0966913556E+00, 1.7734940427E+00, 1.1745078045E+00, 7.9121596196E-01],
	[1.9920000000E+04, 1.0950240638E+01, 5.0965591699E+00, 1.7749227998E+00, 1.1751740404E+00, 7.9131277133E-01],
	[1.9925000000E+04, 1.0954303545E+01, 5.0964270208E+00, 1.7763523484E+00, 1.1758403423E+00, 7.9140954350E-01],
	[1.9930000000E+04, 1.0958366939E+01, 5.0962949082E+00, 1.7777826887E+00, 1.1765067100E+00, 7.9150627847E-01],
	[1.9935000000E+04, 1.0962430820E+01, 5.0961628323E+00, 1.7792138210E+00, 1.1771731434E+00, 7.9160297624E-01],
	[1.9940000000E+04, 1.0966495189E+01, 5.0960307928E+00, 1.7806457454E+00, 1.1778396423E+00, 7.9169963682E-01],
	[1.9945000000E+04, 1.0970560045E+01, 5.0958987899E+00, 1.7820784623E+00, 1.1785062065E+00, 7.9179626021E-01],
	[1.9950000000E+04, 1.0974625388E+01, 5.0957668235E+00, 1.7835119719E+00, 1.1791728359E+00, 7.9189284640E-01],
	[1.9955000000E+04, 1.0978691218E+01, 5.0956348936E+00, 1.7849462744E+00, 1.1798395303E+00, 7.9198939541E-01],
	[1.9960000000E+04, 1.0982757536E+01, 5.0955030002E+00, 1.7863813700E+00, 1.1805062895E+00, 7.9208590723E-01],
	[1.9965000000E+04, 1.0986824340E+01, 5.0953711432E+00, 1.7878172591E+00, 1.1811731134E+00, 7.9218238187E-01],
	[1.9970000000E+04, 1.0990891632E+01, 5.0952393226E+00, 1.7892539417E+00, 1.1818400018E+00, 7.9227881933E-01],
	[1.9975000000E+04, 1.0994959410E+01, 5.0951075384E+00, 1.7906914183E+00, 1.1825069545E+00, 7.9237521961E-01],
	[1.9980000000E+04, 1.0999027675E+01, 5.0949757906E+00, 1.7921296889E+00, 1.1831739713E+00, 7.9247158271E-01],
	[1.9985000000E+04, 1.1003096427E+01, 5.0948440792E+00, 1.7935687539E+00, 1.1838410521E+00, 7.9256790864E-01],
	[1.9990000000E+04, 1.1007165666E+01, 5.0947124042E+00, 1.7950086135E+00, 1.1845081967E+00, 7.9266419740E-01],
	[1.9995000000E+04, 1.1011235392E+01, 5.0945807655E+00, 1.7964492679E+00, 1.1851754049E+00, 7.9276044899E-01],
	[2.0000000000E+04, 1.1015305604E+01, 5.0944491631E+00, 1.7978907174E+00, 1.1858426767E+00, 7.9285666341E-01],
	[2.0005000000E+04, 1.1019376302E+01, 5.0943175970E+00, 1.7993350088E+00, 1.1865109016E+00, 7.9295284067E-01],
	[2.0010000000E+04, 1.1023447487E+01, 5.0941860671E+00, 1.8007800985E+00, 1.1871791900E+00, 7.9304898077E-01],
	[2.0015000000E+04, 1.1027519159E+01, 5.0940545736E+00, 1.8022259870E+00, 1.1878475418E+00, 7.9314508370E-01],
	[2.0020000000E+04, 1.1031591316E+01, 5.0939231162E+00, 1.8036726743E+00, 1.1885159568E+00, 7.9324114949E-01],
	[2.0025000000E+04, 1.1035663960E+01, 5.0937916951E+00, 1.8051201607E+00, 1.1891844348E+00, 7.9333717812E-01],
	[2.0030000000E+04, 1.1039737091E+01, 5.0936603102E+00, 1.8065684465E+00, 1.1898529756E+00, 7.9343316959E-01],
	[2.0035000000E+04, 1.1043810707E+01, 5.0935289615E+00, 1.8080175319E+00, 1.1905215791E+00, 7.9352912392E-01],
	[2.0040000000E+04, 1.1047884809E+01, 5.0933976489E+00, 1.8094674172E+00, 1.1911902450E+00, 7.9362504111E-01],
	[2.0045000000E+04, 1.1051959398E+01, 5.0932663724E+00, 1.8109181025E+00, 1.1918589733E+00, 7.9372092115E-01],
	[2.0050000000E+04, 1.1056034472E+01, 5.0931351321E+00, 1.8123695882E+00, 1.1925277638E+00, 7.9381676405E-01],
	[2.0055000000E+04, 1.1060110033E+01, 5.0930039279E+00, 1.8138218744E+00, 1.1931966162E+00, 7.9391256982E-01],
	[2.0060000000E+04, 1.1064186079E+01, 5.0928727598E+00, 1.8152749615E+00, 1.1938655305E+00, 7.9400833845E-01],
	[2.0065000000E+04, 1.1068271909E+01, 5.0927438240E+00, 1.8167288496E+00, 1.1945347355E+00, 7.9410406995E-01],
	[2.0070000000E+04, 1.1072367971E+01, 5.0926172237E+00, 1.8181835390E+00, 1.1952042426E+00, 7.9419976432E-01],
	[2.0075000000E+04, 1.1076464528E+01, 5.0924906581E+00, 1.8196390299E+00, 1.1958738118E+00, 7.9429542156E-01],
	[2.0080000000E+04, 1.1080561580E+01, 5.0923641272E+00, 1.8210953227E+00, 1.1965434429E+00, 7.9439104168E-01],
	[2.0085000000E+04, 1.1084659126E+01, 5.0922376309E+00, 1.8225524174E+00, 1.1972131357E+00, 7.9448662469E-01],
	[2.0090000000E+04, 1.1088757168E+01, 5.0921111692E+00, 1.8240103144E+00, 1.1978828901E+00, 7.9458217057E-01],
	[2.0095000000E+04, 1.1092855704E+01, 5.0919847421E+00, 1.8254690139E+00, 1.1985527060E+00, 7.9467767934E-01],
	[2.0100000000E+04, 1.1096954735E+01, 5.0918583497E+00, 1.8269285162E+00, 1.1992225830E+00, 7.9477315100E-01],
	[2.0105000000E+04, 1.1101054260E+01, 5.0917319918E+00, 1.8283888214E+00, 1.1998925212E+00, 7.9486858555E-01],
	[2.0110000000E+04, 1.1105154280E+01, 5.0916056684E+00, 1.8298499299E+00, 1.2005625202E+00, 7.9496398299E-01],
	[2.0115000000E+04, 1.1109254794E+01, 5.0914793796E+00, 1.8313118418E+00, 1.2012325800E+00, 7.9505934334E-01],
	[2.0120000000E+04, 1.1113355803E+01, 5.0913531253E+00, 1.8327745575E+00, 1.2019027004E+00, 7.9515466658E-01],
	[2.0125000000E+04, 1.1117457306E+01, 5.0912269056E+00, 1.8342380771E+00, 1.2025728811E+00, 7.9524995273E-01],
	[2.0130000000E+04, 1.1121559303E+01, 5.0911007203E+00, 1.8357024009E+00, 1.2032431221E+00, 7.9534520179E-01],
	[2.0135000000E+04, 1.1125661795E+01, 5.0909745694E+00, 1.8371675291E+00, 1.2039134231E+00, 7.9544041375E-01],
	[2.0140000000E+04, 1.1129764781E+01, 5.0908484530E+00, 1.8386334621E+00, 1.2045837840E+00, 7.9553558863E-01],
	[2.0145000000E+04, 1.1133868260E+01, 5.0907223711E+00, 1.8401001999E+00, 1.2052542046E+00, 7.9563072643E-01],
	[2.0150000000E+04, 1.1137972234E+01, 5.0905963235E+00, 1.8415677429E+00, 1.2059246848E+00, 7.9572582715E-01],
	[2.0155000000E+04, 1.1142076702E+01, 5.0904703104E+00, 1.8430360913E+00, 1.2065952243E+00, 7.9582089079E-01],
	[2.0160000000E+04, 1.1146181663E+01, 5.0903443316E+00, 1.8445052453E+00, 1.2072658231E+00, 7.9591591736E-01],
	[2.0165000000E+04, 1.1150287119E+01, 5.0902183872E+00, 1.8459752053E+00, 1.2079364809E+00, 7.9601090685E-01],
	[2.0170000000E+04, 1.1154393068E+01, 5.0900924771E+00, 1.8474459713E+00, 1.2086071976E+00, 7.9610585928E-01],
	[2.0175000000E+04, 1.1158499510E+01, 5.0899666013E+00, 1.8489175438E+00, 1.2092779729E+00, 7.9620077465E-01],
	[2.0180000000E+04, 1.1162606447E+01, 5.0898407599E+00, 1.8503899228E+00, 1.2099488069E+00, 7.9629565295E-01],
	[2.0185000000E+04, 1.1166713877E+01, 5.0897149527E+00, 1.8518631087E+00, 1.2106196991E+00, 7.9639049420E-01],
	[2.0190000000E+04, 1.1170821800E+01, 5.0895891798E+00, 1.8533371017E+00, 1.2112906496E+00, 7.9648529840E-01],
	[2.0195000000E+04, 1.1174930217E+01, 5.0894634412E+00, 1.8548119020E+00, 1.2119616581E+00, 7.9658006555E-01],
	[2.0200000000E+04, 1.1179039128E+01, 5.0893377368E+00, 1.8562875099E+00, 1.2126327244E+00, 7.9667479565E-01],
	[2.0205000000E+04, 1.1183148531E+01, 5.0892120665E+00, 1.8577639256E+00, 1.2133038485E+00, 7.9676948871E-01],
	[2.0210000000E+04, 1.1187258428E+01, 5.0890864305E+00, 1.8592411494E+00, 1.2139750301E+00, 7.9686414472E-01],
	[2.0215000000E+04, 1.1191368818E+01, 5.0889608287E+00, 1.8607191815E+00, 1.2146462690E+00, 7.9695876371E-01],
	[2.0220000000E+04, 1.1195479701E+01, 5.0888352610E+00, 1.8621980221E+00, 1.2153175651E+00, 7.9705334566E-01],
	[2.0225000000E+04, 1.1199591078E+01, 5.0887097275E+00, 1.8636776716E+00, 1.2159889182E+00, 7.9714789058E-01],
	[2.0230000000E+04, 1.1203702947E+01, 5.0885842281E+00, 1.8651581300E+00, 1.2166603281E+00, 7.9724239848E-01],
	[2.0235000000E+04, 1.1207815309E+01, 5.0884587628E+00, 1.8666393977E+00, 1.2173317948E+00, 7.9733686935E-01],
	[2.0240000000E+04, 1.1211928164E+01, 5.0883333316E+00, 1.8681214750E+00, 1.2180033179E+00, 7.9743130321E-01],
	[2.0245000000E+04, 1.1216041512E+01, 5.0882079345E+00, 1.8696043619E+00, 1.2186748974E+00, 7.9752570005E-01],
	[2.0250000000E+04, 1.1220155353E+01, 5.0880825714E+00, 1.8710880589E+00, 1.2193465331E+00, 7.9762005988E-01],
	[2.0255000000E+04, 1.1224269686E+01, 5.0879572424E+00, 1.8725725662E+00, 1.2200182247E+00, 7.9771438271E-01],
	[2.0260000000E+04, 1.1228384512E+01, 5.0878319474E+00, 1.8740578839E+00, 1.2206899722E+00, 7.9780866853E-01],
	[2.0265000000E+04, 1.1232499830E+01, 5.0877066864E+00, 1.8755440123E+00, 1.2213617754E+00, 7.9790291736E-01],
	[2.0270000000E+04, 1.1236615641E+01, 5.0875814594E+00, 1.8770309517E+00, 1.2220336340E+00, 7.9799712919E-01],
	[2.0275000000E+04, 1.1240731945E+01, 5.0874562663E+00, 1.8785187023E+00, 1.2227055480E+00, 7.9809130402E-01],
	[2.0280000000E+04, 1.1244848740E+01, 5.0873311072E+00, 1.8800072643E+00, 1.2233775172E+00, 7.9818544187E-01],
	[2.0285000000E+04, 1.1248966028E+01, 5.0872059820E+00, 1.8814966380E+00, 1.2240495413E+00, 7.9827954274E-01],
	[2.0290000000E+04, 1.1253083809E+01, 5.0870808908E+00, 1.8829868237E+00, 1.2247216203E+00, 7.9837360663E-01],
	[2.0295000000E+04, 1.1257202081E+01, 5.0869558334E+00, 1.8844778215E+00, 1.2253937539E+00, 7.9846763354E-01],
	[2.0300000000E+04, 1.1261320846E+01, 5.0868308099E+00, 1.8859696318E+00, 1.2260659420E+00, 7.9856162347E-01],
	[2.0305000000E+04, 1.1265440103E+01, 5.0867058203E+00, 1.8874622547E+00, 1.2267381844E+00, 7.9865557644E-01],
	[2.0310000000E+04, 1.1269559851E+01, 5.0865808645E+00, 1.8889556905E+00, 1.2274104810E+00, 7.9874949245E-01],
	[2.0315000000E+04, 1.1273680092E+01, 5.0864559426E+00, 1.8904499395E+00, 1.2280828316E+00, 7.9884337149E-01],
	[2.0320000000E+04, 1.1277800825E+01, 5.0863310544E+00, 1.8919450018E+00, 1.2287552359E+00, 7.9893721358E-01],
	[2.0325000000E+04, 1.1281922049E+01, 5.0862062001E+00, 1.8934408778E+00, 1.2294276940E+00, 7.9903101872E-01],
	[2.0330000000E+04, 1.1286043765E+01, 5.0860813795E+00, 1.8949375676E+00, 1.2301002055E+00, 7.9912478691E-01],
	[2.0335000000E+04, 1.1290165973E+01, 5.0859565927E+00, 1.8964350715E+00, 1.2307727703E+00, 7.9921851815E-01],
	[2.0340000000E+04, 1.1294288672E+01, 5.0858318396E+00, 1.8979333898E+00, 1.2314453882E+00, 7.9931221245E-01],
	[2.0345000000E+04, 1.1298411863E+01, 5.0857071202E+00, 1.8994325227E+00, 1.2321180592E+00, 7.9940586982E-01],
	[2.0350000000E+04, 1.1302535546E+01, 5.0855824346E+00, 1.9009324705E+00, 1.2327907829E+00, 7.9949949026E-01],
	[2.0355000000E+04, 1.1306659719E+01, 5.0854577826E+00, 1.9024332333E+00, 1.2334635593E+00, 7.9959307377E-01],
	[2.0360000000E+04, 1.1310784385E+01, 5.0853331643E+00, 1.9039348114E+00, 1.2341363881E+00, 7.9968662036E-01],
	[2.0365000000E+04, 1.1314909541E+01, 5.0852085796E+00, 1.9054372051E+00, 1.2348092693E+00, 7.9978013002E-01],
	[2.0370000000E+04, 1.1319035189E+01, 5.0850840286E+00, 1.9069404146E+00, 1.2354822026E+00, 7.9987360277E-01],
	[2.0375000000E+04, 1.1323161328E+01, 5.0849595112E+00, 1.9084444401E+00, 1.2361551878E+00, 7.9996703862E-01],
	[2.0380000000E+04, 1.1327287958E+01, 5.0848350275E+00, 1.9099492819E+00, 1.2368282249E+00, 8.0006043755E-01],
	[2.0385000000E+04, 1.1331415080E+01, 5.0847105772E+00, 1.9114549403E+00, 1.2375013136E+00, 8.0015379958E-01],
	[2.0390000000E+04, 1.1335559878E+01, 5.0845901159E+00, 1.9129614154E+00, 1.2381748933E+00, 8.0024712472E-01],
	[2.0395000000E+04, 1.1339707248E+01, 5.0844701636E+00, 1.9144687076E+00, 1.2388485781E+00, 8.0034041296E-01],
	[2.0400000000E+04, 1.1343855119E+01, 5.0843502435E+00, 1.9159768170E+00, 1.2395223148E+00, 8.0043366432E-01],
	[2.0405000000E+04, 1.1348003489E+01, 5.0842303557E+00, 1.9174857439E+00, 1.2401961033E+00, 8.0052687879E-01],
	[2.0410000000E+04, 1.1352152360E+01, 5.0841105001E+00, 1.9189954886E+00, 1.2408699434E+00, 8.0062005637E-01],
	[2.0415000000E+04, 1.1356301730E+01, 5.0839906766E+00, 1.9205060512E+00, 1.2415438349E+00, 8.0071319709E-01],
	[2.0420000000E+04, 1.1360451601E+01, 5.0838708853E+00, 1.9220174321E+00, 1.2422177777E+00, 8.0080630093E-01],
	[2.0425000000E+04, 1.1364601971E+01, 5.0837511262E+00, 1.9235296314E+00, 1.2428917715E+00, 8.0089936790E-01],
	[2.0430000000E+04, 1.1368752841E+01, 5.0836313991E+00, 1.9250426495E+00, 1.2435658163E+00, 8.0099239802E-01],
	[2.0435000000E+04, 1.1372904211E+01, 5.0835117043E+00, 1.9265564865E+00, 1.2442399118E+00, 8.0108539127E-01],
	[2.0440000000E+04, 1.1377056081E+01, 5.0833920415E+00, 1.9280711427E+00, 1.2449140579E+00, 8.0117834767E-01],
	[2.0445000000E+04, 1.1381208451E+01, 5.0832724107E+00, 1.9295866183E+00, 1.2455882545E+00, 8.0127126723E-01],
	[2.0450000000E+04, 1.1385361320E+01, 5.0831528121E+00, 1.9311029136E+00, 1.2462625013E+00, 8.0136414994E-01],
	[2.0455000000E+04, 1.1389514688E+01, 5.0830332455E+00, 1.9326200289E+00, 1.2469367982E+00, 8.0145699580E-01],
	[2.0460000000E+04, 1.1393668556E+01, 5.0829137110E+00, 1.9341379643E+00, 1.2476111450E+00, 8.0154980484E-01],
	[2.0465000000E+04, 1.1397822924E+01, 5.0827942084E+00, 1.9356567201E+00, 1.2482855415E+00, 8.0164257704E-01],
	[2.0470000000E+04, 1.1401977790E+01, 5.0826747379E+00, 1.9371762966E+00, 1.2489599877E+00, 8.0173531242E-01],
	[2.0475000000E+04, 1.1406133156E+01, 5.0825552993E+00, 1.9386966940E+00, 1.2496344833E+00, 8.0182801098E-01],
	[2.0480000000E+04, 1.1410289022E+01, 5.0824358927E+00, 1.9402179125E+00, 1.2503090281E+00, 8.0192067272E-01],
	[2.0485000000E+04, 1.1414445386E+01, 5.0823165181E+00, 1.9417399523E+00, 1.2509836220E+00, 8.0201329765E-01],
	[2.0490000000E+04, 1.1418602249E+01, 5.0821971754E+00, 1.9432628138E+00, 1.2516582649E+00, 8.0210588578E-01],
	[2.0495000000E+04, 1.1422759612E+01, 5.0820778646E+00, 1.9447864972E+00, 1.2523329565E+00, 8.0219843710E-01],
	[2.0500000000E+04, 1.1426917474E+01, 5.0819585858E+00, 1.9463110027E+00, 1.2530076967E+00, 8.0229095163E-01],
	[2.0505000000E+04, 1.1431075834E+01, 5.0818393388E+00, 1.9478363305E+00, 1.2536824853E+00, 8.0238342936E-01],
	[2.0510000000E+04, 1.1435234693E+01, 5.0817201237E+00, 1.9493624809E+00, 1.2543573222E+00, 8.0247587031E-01],
	[2.0515000000E+04, 1.1439394051E+01, 5.0816009404E+00, 1.9508894542E+00, 1.2550322072E+00, 8.0256827447E-01],
	[2.0520000000E+04, 1.1443553908E+01, 5.0814817890E+00, 1.9524172505E+00, 1.2557071401E+00, 8.0266064185E-01],
	[2.0525000000E+04, 1.1447714264E+01, 5.0813626694E+00, 1.9539458701E+00, 1.2563821208E+00, 8.0275297247E-01],
	[2.0530000000E+04, 1.1451875118E+01, 5.0812435816E+00, 1.9554753133E+00, 1.2570571490E+00, 8.0284526631E-01],
	[2.0535000000E+04, 1.1456036470E+01, 5.0811245256E+00, 1.9570055803E+00, 1.2577322247E+00, 8.0293752339E-01],
	[2.0540000000E+04, 1.1460198321E+01, 5.0810055014E+00, 1.9585366714E+00, 1.2584073476E+00, 8.0302974372E-01],
	[2.0545000000E+04, 1.1464360671E+01, 5.0808865089E+00, 1.9600685867E+00, 1.2590825177E+00, 8.0312192729E-01],
	[2.0550000000E+04, 1.1468523519E+01, 5.0807675482E+00, 1.9616013266E+00, 1.2597577346E+00, 8.0321407411E-01],
	[2.0555000000E+04, 1.1472686865E+01, 5.0806486192E+00, 1.9631348912E+00, 1.2604329983E+00, 8.0330618419E-01],
	[2.0560000000E+04, 1.1476850709E+01, 5.0805297219E+00, 1.9646692809E+00, 1.2611083087E+00, 8.0339825754E-01],
	[2.0565000000E+04, 1.1481015052E+01, 5.0804108563E+00, 1.9662044958E+00, 1.2617836654E+00, 8.0349029415E-01],
	[2.0570000000E+04, 1.1485179892E+01, 5.0802920224E+00, 1.9677405362E+00, 1.2624590684E+00, 8.0358229403E-01],
	[2.0575000000E+04, 1.1489345231E+01, 5.0801732201E+00, 1.9692774024E+00, 1.2631345175E+00, 8.0367425719E-01],
	[2.0580000000E+04, 1.1493511068E+01, 5.0800544495E+00, 1.9708150946E+00, 1.2638100126E+00, 8.0376618363E-01],
	[2.0585000000E+04, 1.1497677402E+01, 5.0799357105E+00, 1.9723536129E+00, 1.2644855534E+00, 8.0385807336E-01],
	[2.0590000000E+04, 1.1501844235E+01, 5.0798170031E+00, 1.9738929578E+00, 1.2651611398E+00, 8.0394992638E-01],
	[2.0595000000E+04, 1.1506011565E+01, 5.0796983273E+00, 1.9754331294E+00, 1.2658367717E+00, 8.0404174270E-01],
	[2.0600000000E+04, 1.1510179393E+01, 5.0795796831E+00, 1.9769741279E+00, 1.2665124488E+00, 8.0413352233E-01],
	[2.0605000000E+04, 1.1514347719E+01, 5.0794610705E+00, 1.9785159536E+00, 1.2671881710E+00, 8.0422526526E-01],
	[2.0610000000E+04, 1.1518516542E+01, 5.0793424894E+00, 1.9800586068E+00, 1.2678639382E+00, 8.0431697151E-01],
	[2.0615000000E+04, 1.1522685863E+01, 5.0792239398E+00, 1.9816020877E+00, 1.2685397501E+00, 8.0440864101E-01],
	[2.0620000000E+04, 1.1526855681E+01, 5.0791054218E+00, 1.9831463965E+00, 1.2692156066E+00, 8.0450027371E-01],
	[2.0625000000E+04, 1.1531025997E+01, 5.0789869352E+00, 1.9846915334E+00, 1.2698915076E+00, 8.0459186961E-01],
	[2.0630000000E+04, 1.1535196810E+01, 5.0788684802E+00, 1.9862374988E+00, 1.2705674529E+00, 8.0468342871E-01],
	[2.0635000000E+04, 1.1539368121E+01, 5.0787500566E+00, 1.9877842929E+00, 1.2712434423E+00, 8.0477495103E-01],
	[2.0640000000E+04, 1.1543539928E+01, 5.0786316644E+00, 1.9893319158E+00, 1.2719194756E+00, 8.0486643658E-01],
	[2.0645000000E+04, 1.1547712233E+01, 5.0785133037E+00, 1.9908803679E+00, 1.2725955527E+00, 8.0495788536E-01],
	[2.0650000000E+04, 1.1551885035E+01, 5.0783949744E+00, 1.9924296493E+00, 1.2732716734E+00, 8.0504929740E-01],
	[2.0655000000E+04, 1.1556058334E+01, 5.0782766765E+00, 1.9939797604E+00, 1.2739478375E+00, 8.0514067269E-01],
	[2.0660000000E+04, 1.1560232131E+01, 5.0781584100E+00, 1.9955307014E+00, 1.2746240450E+00, 8.0523201125E-01],
	[2.0665000000E+04, 1.1564406424E+01, 5.0780401749E+00, 1.9970824725E+00, 1.2753002956E+00, 8.0532331308E-01],
	[2.0670000000E+04, 1.1568581214E+01, 5.0779219711E+00, 1.9986350739E+00, 1.2759765891E+00, 8.0541457821E-01],
	[2.0675000000E+04, 1.1572756500E+01, 5.0778037987E+00, 2.0001885060E+00, 1.2766529254E+00, 8.0550580663E-01],
	[2.0680000000E+04, 1.1576932284E+01, 5.0776856576E+00, 2.0017427689E+00, 1.2773293043E+00, 8.0559699836E-01],
	[2.0685000000E+04, 1.1581108564E+01, 5.0775675478E+00, 2.0032978628E+00, 1.2780057257E+00, 8.0568815341E-01],
	[2.0690000000E+04, 1.1585285341E+01, 5.0774494693E+00, 2.0048537881E+00, 1.2786821894E+00, 8.0577927178E-01],
	[2.0695000000E+04, 1.1589462614E+01, 5.0773314221E+00, 2.0064105450E+00, 1.2793586952E+00, 8.0587035349E-01],
	[2.0700000000E+04, 1.1593640384E+01, 5.0772134061E+00, 2.0079681337E+00, 1.2800352430E+00, 8.0596139855E-01],
	[2.0705000000E+04, 1.1597818651E+01, 5.0770954214E+00, 2.0095265545E+00, 1.2807118326E+00, 8.0605240697E-01],
	[2.0710000000E+04, 1.1601997413E+01, 5.0769774679E+00, 2.0110858075E+00, 1.2813884638E+00, 8.0614337876E-01],
	[2.0715000000E+04, 1.1606181664E+01, 5.0768606663E+00, 2.0126458931E+00, 1.2820652689E+00, 8.0623431392E-01],
	[2.0720000000E+04, 1.1610380882E+01, 5.0767471429E+00, 2.0142068115E+00, 1.2827424994E+00, 8.0632521247E-01],
	[2.0725000000E+04, 1.1614580605E+01, 5.0766336493E+00, 2.0157685629E+00, 1.2834197719E+00, 8.0641607442E-01],
	[2.0730000000E+04, 1.1618780834E+01, 5.0765201857E+00, 2.0173311476E+00, 1.2840970861E+00, 8.0650689978E-01],
	[2.0735000000E+04, 1.1622981569E+01, 5.0764067520E+00, 2.0188945658E+00, 1.2847744420E+00, 8.0659768856E-01],
	[2.0740000000E+04, 1.1627182808E+01, 5.0762933481E+00, 2.0204588177E+00, 1.2854518393E+00, 8.0668844076E-01],
	[2.0745000000E+04, 1.1631384553E+01, 5.0761799742E+00, 2.0220239037E+00, 1.2861292779E+00, 8.0677915641E-01],
	[2.0750000000E+04, 1.1635586804E+01, 5.0760666301E+00, 2.0235898239E+00, 1.2868067576E+00, 8.0686983550E-01],
	[2.0755000000E+04, 1.1639789559E+01, 5.0759533158E+00, 2.0251565786E+00, 1.2874842783E+00, 8.0696047805E-01],
	[2.0760000000E+04, 1.1643992820E+01, 5.0758400313E+00, 2.0267241681E+00, 1.2881618398E+00, 8.0705108407E-01],
	[2.0765000000E+04, 1.1648196586E+01, 5.0757267767E+00, 2.0282925925E+00, 1.2888394419E+00, 8.0714165357E-01],
	[2.0770000000E+04, 1.1652400856E+01, 5.0756135518E+00, 2.0298618521E+00, 1.2895170845E+00, 8.0723218656E-01],
	[2.0775000000E+04, 1.1656605632E+01, 5.0755003567E+00, 2.0314319472E+00, 1.2901947674E+00, 8.0732268305E-01],
	[2.0780000000E+04, 1.1660810912E+01, 5.0753871914E+00, 2.0330028780E+00, 1.2908724905E+00, 8.0741314305E-01],
	[2.0785000000E+04, 1.1665016698E+01, 5.0752740559E+00, 2.0345746447E+00, 1.2915502535E+00, 8.0750356657E-01],
	[2.0790000000E+04, 1.1669222988E+01, 5.0751609500E+00, 2.0361472476E+00, 1.2922280564E+00, 8.0759395362E-01],
	[2.0795000000E+04, 1.1673429783E+01, 5.0750478739E+00, 2.0377206870E+00, 1.2929058989E+00, 8.0768430421E-01],
	[2.0800000000E+04, 1.1677637082E+01, 5.0749348275E+00, 2.0392949630E+00, 1.2935837809E+00, 8.0777461835E-01],
	[2.0805000000E+04, 1.1681844886E+01, 5.0748218108E+00, 2.0408700760E+00, 1.2942617022E+00, 8.0786489606E-01],
	[2.0810000000E+04, 1.1686053195E+01, 5.0747088237E+00, 2.0424460261E+00, 1.2949396627E+00, 8.0795513733E-01],
	[2.0815000000E+04, 1.1690262008E+01, 5.0745958664E+00, 2.0440228137E+00, 1.2956176621E+00, 8.0804534218E-01],
	[2.0820000000E+04, 1.1694471325E+01, 5.0744829386E+00, 2.0456004389E+00, 1.2962957004E+00, 8.0813551063E-01],
	[2.0825000000E+04, 1.1698681147E+01, 5.0743700405E+00, 2.0471789019E+00, 1.2969737774E+00, 8.0822564268E-01],
	[2.0830000000E+04, 1.1702891473E+01, 5.0742571720E+00, 2.0487582032E+00, 1.2976518929E+00, 8.0831573834E-01],
	[2.0835000000E+04, 1.1707102304E+01, 5.0741443331E+00, 2.0503383427E+00, 1.2983300468E+00, 8.0840579762E-01],
	[2.0840000000E+04, 1.1711313638E+01, 5.0740315238E+00, 2.0519193210E+00, 1.2990082388E+00, 8.0849582054E-01],
	[2.0845000000E+04, 1.1715525477E+01, 5.0739187440E+00, 2.0535011381E+00, 1.2996864688E+00, 8.0858580710E-01],
	[2.0850000000E+04, 1.1719737819E+01, 5.0738059938E+00, 2.0550837942E+00, 1.3003647367E+00, 8.0867575731E-01],
	[2.0855000000E+04, 1.1723950666E+01, 5.0736932732E+00, 2.0566672898E+00, 1.3010430423E+00, 8.0876567119E-01],
	[2.0860000000E+04, 1.1728164017E+01, 5.0735805820E+00, 2.0582516249E+00, 1.3017213854E+00, 8.0885554874E-01],
	[2.0865000000E+04, 1.1732377871E+01, 5.0734679204E+00, 2.0598367999E+00, 1.3023997659E+00, 8.0894538997E-01],
	[2.0870000000E+04, 1.1736592229E+01, 5.0733552883E+00, 2.0614228150E+00, 1.3030781836E+00, 8.0903519490E-01],
	[2.0875000000E+04, 1.1740807091E+01, 5.0732426856E+00, 2.0630096704E+00, 1.3037566383E+00, 8.0912496354E-01],
	[2.0880000000E+04, 1.1745022457E+01, 5.0731301125E+00, 2.0645973664E+00, 1.3044351299E+00, 8.0921469589E-01],
	[2.0885000000E+04, 1.1749238326E+01, 5.0730175687E+00, 2.0661859032E+00, 1.3051136582E+00, 8.0930439196E-01],
	[2.0890000000E+04, 1.1753454699E+01, 5.0729050545E+00, 2.0677752810E+00, 1.3057922231E+00, 8.0939405178E-01],
	[2.0895000000E+04, 1.1757671575E+01, 5.0727925696E+00, 2.0693655001E+00, 1.3064708243E+00, 8.0948367534E-01],
	[2.0900000000E+04, 1.1761888954E+01, 5.0726801141E+00, 2.0709565608E+00, 1.3071494618E+00, 8.0957326265E-01],
	[2.0905000000E+04, 1.1766106838E+01, 5.0725676881E+00, 2.0725484633E+00, 1.3078281353E+00, 8.0966281374E-01],
	[2.0910000000E+04, 1.1770325224E+01, 5.0724552914E+00, 2.0741412078E+00, 1.3085068448E+00, 8.0975232860E-01],
	[2.0915000000E+04, 1.1774544114E+01, 5.0723429240E+00, 2.0757347946E+00, 1.3091855900E+00, 8.0984180725E-01],
	[2.0920000000E+04, 1.1778763506E+01, 5.0722305860E+00, 2.0773292239E+00, 1.3098643707E+00, 8.0993124970E-01],
	[2.0925000000E+04, 1.1782983402E+01, 5.0721182774E+00, 2.0789244959E+00, 1.3105431869E+00, 8.1002065595E-01],
	[2.0930000000E+04, 1.1787203801E+01, 5.0720059981E+00, 2.0805206110E+00, 1.3112220383E+00, 8.1011002603E-01],
	[2.0935000000E+04, 1.1791424703E+01, 5.0718937480E+00, 2.0821175693E+00, 1.3119009248E+00, 8.1019935994E-01],
	[2.0940000000E+04, 1.1795646108E+01, 5.0717815273E+00, 2.0837153711E+00, 1.3125798462E+00, 8.1028865768E-01],
	[2.0945000000E+04, 1.1799868016E+01, 5.0716693358E+00, 2.0853140166E+00, 1.3132588024E+00, 8.1037791928E-01],
	[2.0950000000E+04, 1.1804090427E+01, 5.0715571736E+00, 2.0869135062E+00, 1.3139377932E+00, 8.1046714474E-01],
	[2.0955000000E+04, 1.1808313341E+01, 5.0714450407E+00, 2.0885138399E+00, 1.3146168185E+00, 8.1055633407E-01],
	[2.0960000000E+04, 1.1812536757E+01, 5.0713329370E+00, 2.0901150181E+00, 1.3152958780E+00, 8.1064548729E-01],
	[2.0965000000E+04, 1.1816760676E+01, 5.0712208624E+00, 2.0917170410E+00, 1.3159749716E+00, 8.1073460439E-01],
	[2.0970000000E+04, 1.1820985097E+01, 5.0711088171E+00, 2.0933199089E+00, 1.3166540992E+00, 8.1082368540E-01],
	[2.0975000000E+04, 1.1825210021E+01, 5.0709968010E+00, 2.0949236220E+00, 1.3173332606E+00, 8.1091273033E-01],
	[2.0980000000E+04, 1.1829435447E+01, 5.0708848141E+00, 2.0965281805E+00, 1.3180124556E+00, 8.1100173917E-01],
	[2.0985000000E+04, 1.1833661376E+01, 5.0707728563E+00, 2.0981335847E+00, 1.3186916840E+00, 8.1109071196E-01],
	[2.0990000000E+04, 1.1837887808E+01, 5.0706609276E+00, 2.0997398348E+00, 1.3193709458E+00, 8.1117964868E-01],
	[2.0995000000E+04, 1.1842114741E+01, 5.0705490281E+00, 2.1013469311E+00, 1.3200502407E+00, 8.1126854937E-01],
	[2.1000000000E+04, 1.1846342177E+01, 5.0704371577E+00, 2.1029548738E+00, 1.3207295686E+00, 8.1135741402E-01],
	[2.1005000000E+04, 1.1850570115E+01, 5.0703253164E+00, 2.1045636632E+00, 1.3214089293E+00, 8.1144624264E-01],
	[2.1010000000E+04, 1.1854798555E+01, 5.0702135042E+00, 2.1061732995E+00, 1.3220883227E+00, 8.1153503526E-01],
	[2.1015000000E+04, 1.1859027497E+01, 5.0701017210E+00, 2.1077837829E+00, 1.3227677486E+00, 8.1162379187E-01],
	[2.1020000000E+04, 1.1863256941E+01, 5.0699899669E+00, 2.1093951137E+00, 1.3234472068E+00, 8.1171251249E-01],
	[2.1025000000E+04, 1.1867486887E+01, 5.0698782419E+00, 2.1110072922E+00, 1.3241266972E+00, 8.1180119713E-01],
	[2.1030000000E+04, 1.1871717335E+01, 5.0697665459E+00, 2.1126203185E+00, 1.3248062195E+00, 8.1188984580E-01],
	[2.1035000000E+04, 1.1875948285E+01, 5.0696548789E+00, 2.1142341929E+00, 1.3254857738E+00, 8.1197845851E-01],
	[2.1040000000E+04, 1.1880179736E+01, 5.0695432409E+00, 2.1158489158E+00, 1.3261653597E+00, 8.1206703527E-01],
	[2.1045000000E+04, 1.1884411689E+01, 5.0694316318E+00, 2.1174644872E+00, 1.3268449772E+00, 8.1215557610E-01],
	[2.1050000000E+04, 1.1888655235E+01, 5.0693224801E+00, 2.1190809075E+00, 1.3275249308E+00, 8.1224408099E-01],
	[2.1055000000E+04, 1.1892907862E+01, 5.0692152333E+00, 2.1206981768E+00, 1.3282051519E+00, 8.1233254997E-01],
	[2.1060000000E+04, 1.1897161000E+01, 5.0691080143E+00, 2.1223162955E+00, 1.3288854048E+00, 8.1242098304E-01],
	[2.1065000000E+04, 1.1901414649E+01, 5.0690008230E+00, 2.1239352638E+00, 1.3295656895E+00, 8.1250938022E-01],
	[2.1070000000E+04, 1.1905668809E+01, 5.0688936595E+00, 2.1255550820E+00, 1.3302460057E+00, 8.1259774151E-01],
	[2.1075000000E+04, 1.1909923479E+01, 5.0687865236E+00, 2.1271757502E+00, 1.3309263533E+00, 8.1268606692E-01],
	[2.1080000000E+04, 1.1914178660E+01, 5.0686794154E+00, 2.1287972687E+00, 1.3316067320E+00, 8.1277435648E-01],
	[2.1085000000E+04, 1.1918434352E+01, 5.0685723348E+00, 2.1304196378E+00, 1.3322871419E+00, 8.1286261017E-01],
	[2.1090000000E+04, 1.1922690554E+01, 5.0684652819E+00, 2.1320428576E+00, 1.3329675826E+00, 8.1295082803E-01],
	[2.1095000000E+04, 1.1926947266E+01, 5.0683582567E+00, 2.1336669286E+00, 1.3336480541E+00, 8.1303901005E-01],
	[2.1100000000E+04, 1.1931204489E+01, 5.0682512591E+00, 2.1352918508E+00, 1.3343285562E+00, 8.1312715626E-01],
	[2.1105000000E+04, 1.1935462223E+01, 5.0681442890E+00, 2.1369176246E+00, 1.3350090886E+00, 8.1321526665E-01],
	[2.1110000000E+04, 1.1939720466E+01, 5.0680373466E+00, 2.1385442501E+00, 1.3356896513E+00, 8.1330334124E-01],
	[2.1115000000E+04, 1.1943979220E+01, 5.0679304318E+00, 2.1401717277E+00, 1.3363702442E+00, 8.1339138004E-01],
	[2.1120000000E+04, 1.1948238484E+01, 5.0678235445E+00, 2.1418000575E+00, 1.3370508669E+00, 8.1347938307E-01],
	[2.1125000000E+04, 1.1952498258E+01, 5.0677166848E+00, 2.1434292398E+00, 1.3377315194E+00, 8.1356735033E-01],
	[2.1130000000E+04, 1.1956758542E+01, 5.0676098526E+00, 2.1450592749E+00, 1.3384122016E+00, 8.1365528183E-01],
	[2.1135000000E+04, 1.1961019336E+01, 5.0675030480E+00, 2.1466901630E+00, 1.3390929132E+00, 8.1374317758E-01],
	[2.1140000000E+04, 1.1965280640E+01, 5.0673962708E+00, 2.1483219044E+00, 1.3397736541E+00, 8.1383103760E-01],
	[2.1145000000E+04, 1.1969542454E+01, 5.0672895212E+00, 2.1499544992E+00, 1.3404544241E+00, 8.1391886189E-01],
	[2.1150000000E+04, 1.1973804778E+01, 5.0671827991E+00, 2.1515879478E+00, 1.3411352231E+00, 8.1400665047E-01],
	[2.1155000000E+04, 1.1978067611E+01, 5.0670761044E+00, 2.1532222503E+00, 1.3418160509E+00, 8.1409440335E-01],
	[2.1160000000E+04, 1.1982330955E+01, 5.0669694372E+00, 2.1548574071E+00, 1.3424969073E+00, 8.1418212053E-01],
	[2.1165000000E+04, 1.1986594807E+01, 5.0668627974E+00, 2.1564934183E+00, 1.3431777923E+00, 8.1426980203E-01],
	[2.1170000000E+04, 1.1990859170E+01, 5.0667561851E+00, 2.1581302842E+00, 1.3438587056E+00, 8.1435744786E-01],
	[2.1175000000E+04, 1.1995124041E+01, 5.0666496002E+00, 2.1597680051E+00, 1.3445396470E+00, 8.1444505803E-01],
	[2.1180000000E+04, 1.1999389423E+01, 5.0665430427E+00, 2.1614065812E+00, 1.3452206165E+00, 8.1453263255E-01],
	[2.1185000000E+04, 1.2003655313E+01, 5.0664365126E+00, 2.1630460127E+00, 1.3459016139E+00, 8.1462017144E-01],
	[2.1190000000E+04, 1.2007921713E+01, 5.0663300098E+00, 2.1646862999E+00, 1.3465826389E+00, 8.1470767469E-01],
	[2.1195000000E+04, 1.2012188622E+01, 5.0662235344E+00, 2.1663274431E+00, 1.3472636915E+00, 8.1479514233E-01],
	[2.1200000000E+04, 1.2016456041E+01, 5.0661170864E+00, 2.1679694424E+00, 1.3479447714E+00, 8.1488257436E-01],
	[2.1205000000E+04, 1.2020723968E+01, 5.0660106658E+00, 2.1696122981E+00, 1.3486258786E+00, 8.1496997080E-01],
	[2.1210000000E+04, 1.2024992405E+01, 5.0659042724E+00, 2.1712560105E+00, 1.3493070128E+00, 8.1505733165E-01],
	[2.1215000000E+04, 1.2029261351E+01, 5.0657979064E+00, 2.1729005798E+00, 1.3499881739E+00, 8.1514465693E-01],
	[2.1220000000E+04, 1.2033530806E+01, 5.0656915676E+00, 2.1745460062E+00, 1.3506693617E+00, 8.1523194664E-01],
	[2.1225000000E+04, 1.2037800769E+01, 5.0655852562E+00, 2.1761922901E+00, 1.3513505762E+00, 8.1531920080E-01],
	[2.1230000000E+04, 1.2042071242E+01, 5.0654789720E+00, 2.1778394315E+00, 1.3520318170E+00, 8.1540641943E-01],
	[2.1235000000E+04, 1.2046342223E+01, 5.0653727150E+00, 2.1794874309E+00, 1.3527130842E+00, 8.1549360252E-01],
	[2.1240000000E+04, 1.2050613713E+01, 5.0652664854E+00, 2.1811362884E+00, 1.3533943774E+00, 8.1558075009E-01],
	[2.1245000000E+04, 1.2054885711E+01, 5.0651602829E+00, 2.1827860042E+00, 1.3540756965E+00, 8.1566786216E-01],
	[2.1250000000E+04, 1.2059158219E+01, 5.0650541077E+00, 2.1844365787E+00, 1.3547570415E+00, 8.1575493872E-01],
	[2.1255000000E+04, 1.2063431234E+01, 5.0649479596E+00, 2.1860880120E+00, 1.3554384121E+00, 8.1584197980E-01],
	[2.1260000000E+04, 1.2067704759E+01, 5.0648418388E+00, 2.1877403045E+00, 1.3561198081E+00, 8.1592898541E-01],
	[2.1265000000E+04, 1.2071978791E+01, 5.0647357451E+00, 2.1893934563E+00, 1.3568012295E+00, 8.1601595554E-01],
	[2.1270000000E+04, 1.2076253333E+01, 5.0646296786E+00, 2.1910474676E+00, 1.3574826760E+00, 8.1610289023E-01],
	[2.1275000000E+04, 1.2080528382E+01, 5.0645236393E+00, 2.1927023389E+00, 1.3581641475E+00, 8.1618978947E-01],
	[2.1280000000E+04, 1.2084803940E+01, 5.0644176271E+00, 2.1943580702E+00, 1.3588456438E+00, 8.1627665328E-01],
	[2.1285000000E+04, 1.2089080006E+01, 5.0643116420E+00, 2.1960146618E+00, 1.3595271648E+00, 8.1636348167E-01],
	[2.1290000000E+04, 1.2093356580E+01, 5.0642056840E+00, 2.1976721140E+00, 1.3602087103E+00, 8.1645027463E-01],
	[2.1295000000E+04, 1.2097633662E+01, 5.0640997531E+00, 2.1993304270E+00, 1.3608902802E+00, 8.1653703213E-01],
	[2.1300000000E+04, 1.2101911252E+01, 5.0639938493E+00, 2.2009896010E+00, 1.3615718743E+00, 8.1662375418E-01],
	[2.1305000000E+04, 1.2106189350E+01, 5.0638879726E+00, 2.2026496364E+00, 1.3622534924E+00, 8.1671044076E-01],
	[2.1310000000E+04, 1.2110467956E+01, 5.0637821230E+00, 2.2043105333E+00, 1.3629351344E+00, 8.1679709190E-01],
	[2.1315000000E+04, 1.2114747070E+01, 5.0636763003E+00, 2.2059722920E+00, 1.3636168001E+00, 8.1688370760E-01],
	[2.1320000000E+04, 1.2119026691E+01, 5.0635705048E+00, 2.2076349128E+00, 1.3642984894E+00, 8.1697028785E-01],
	[2.1325000000E+04, 1.2123306821E+01, 5.0634647362E+00, 2.2092983958E+00, 1.3649802021E+00, 8.1705683267E-01],
	[2.1330000000E+04, 1.2127587458E+01, 5.0633589946E+00, 2.2109627414E+00, 1.3656619381E+00, 8.1714334206E-01],
	[2.1335000000E+04, 1.2131868602E+01, 5.0632532800E+00, 2.2126279497E+00, 1.3663436971E+00, 8.1722981602E-01],
	[2.1340000000E+04, 1.2136150255E+01, 5.0631475924E+00, 2.2142940210E+00, 1.3670254791E+00, 8.1731625456E-01],
	[2.1345000000E+04, 1.2140432414E+01, 5.0630419318E+00, 2.2159609556E+00, 1.3677072839E+00, 8.1740265768E-01],
	[2.1350000000E+04, 1.2144715082E+01, 5.0629362981E+00, 2.2176287537E+00, 1.3683891112E+00, 8.1748902539E-01],
	[2.1355000000E+04, 1.2148998256E+01, 5.0628306914E+00, 2.2192974156E+00, 1.3690709611E+00, 8.1757535769E-01],
	[2.1360000000E+04, 1.2153281938E+01, 5.0627251116E+00, 2.2209669414E+00, 1.3697528332E+00, 8.1766165459E-01],
	[2.1365000000E+04, 1.2157566127E+01, 5.0626195587E+00, 2.2226373315E+00, 1.3704347275E+00, 8.1774791609E-01],
	[2.1370000000E+04, 1.2161850823E+01, 5.0625140327E+00, 2.2243085861E+00, 1.3711166438E+00, 8.1783414220E-01],
	[2.1375000000E+04, 1.2166136027E+01, 5.0624085336E+00, 2.2259807053E+00, 1.3717985819E+00, 8.1792033292E-01],
	[2.1380000000E+04, 1.2170421737E+01, 5.0623030613E+00, 2.2276536896E+00, 1.3724805416E+00, 8.1800648826E-01],
	[2.1385000000E+04, 1.2174707955E+01, 5.0621976159E+00, 2.2293275391E+00, 1.3731625229E+00, 8.1809260822E-01],
	[2.1390000000E+04, 1.2179010536E+01, 5.0620955829E+00, 2.2310022540E+00, 1.3738449767E+00, 8.1817869281E-01],
	[2.1395000000E+04, 1.2183317650E+01, 5.0619944336E+00, 2.2326778347E+00, 1.3745275668E+00, 8.1826474203E-01],
	[2.1400000000E+04, 1.2187625281E+01, 5.0618933098E+00, 2.2343542812E+00, 1.3752101787E+00, 8.1835075589E-01],
	[2.1405000000E+04, 1.2191933428E+01, 5.0617922118E+00, 2.2360315940E+00, 1.3758928123E+00, 8.1843673438E-01],
	[2.1410000000E+04, 1.2196242090E+01, 5.0616911393E+00, 2.2377097732E+00, 1.3765754675E+00, 8.1852267753E-01],
	[2.1415000000E+04, 1.2200551269E+01, 5.0615900925E+00, 2.2393888192E+00, 1.3772581441E+00, 8.1860858532E-01],
	[2.1420000000E+04, 1.2204860964E+01, 5.0614890713E+00, 2.2410687320E+00, 1.3779408419E+00, 8.1869445778E-01],
	[2.1425000000E+04, 1.2209171175E+01, 5.0613880757E+00, 2.2427495120E+00, 1.3786235608E+00, 8.1878029489E-01],
	[2.1430000000E+04, 1.2213481902E+01, 5.0612871057E+00, 2.2444311594E+00, 1.3793063006E+00, 8.1886609668E-01],
	[2.1435000000E+04, 1.2217793144E+01, 5.0611861612E+00, 2.2461136745E+00, 1.3799890612E+00, 8.1895186313E-01],
	[2.1440000000E+04, 1.2222104903E+01, 5.0610852423E+00, 2.2477970575E+00, 1.3806718425E+00, 8.1903759426E-01],
	[2.1445000000E+04, 1.2226417177E+01, 5.0609843489E+00, 2.2494813086E+00, 1.3813546441E+00, 8.1912329008E-01],
	[2.1450000000E+04, 1.2230729966E+01, 5.0608834811E+00, 2.2511664282E+00, 1.3820374661E+00, 8.1920895058E-01],
	[2.1455000000E+04, 1.2235043272E+01, 5.0607826388E+00, 2.2528524164E+00, 1.3827203083E+00, 8.1929457577E-01],
	[2.1460000000E+04, 1.2239357092E+01, 5.0606818220E+00, 2.2545392734E+00, 1.3834031704E+00, 8.1938016567E-01],
	[2.1465000000E+04, 1.2243671429E+01, 5.0605810306E+00, 2.2562269996E+00, 1.3840860523E+00, 8.1946572026E-01],
	[2.1470000000E+04, 1.2247986280E+01, 5.0604802648E+00, 2.2579155952E+00, 1.3847689540E+00, 8.1955123957E-01],
	[2.1475000000E+04, 1.2252301647E+01, 5.0603795245E+00, 2.2596050604E+00, 1.3854518751E+00, 8.1963672359E-01],
	[2.1480000000E+04, 1.2256617529E+01, 5.0602788095E+00, 2.2612953955E+00, 1.3861348157E+00, 8.1972217232E-01],
	[2.1485000000E+04, 1.2260933927E+01, 5.0601781201E+00, 2.2629866006E+00, 1.3868177754E+00, 8.1980758579E-01],
	[2.1490000000E+04, 1.2265250840E+01, 5.0600774561E+00, 2.2646786762E+00, 1.3875007542E+00, 8.1989296398E-01],
	[2.1495000000E+04, 1.2269568267E+01, 5.0599768175E+00, 2.2663716223E+00, 1.3881837519E+00, 8.1997830691E-01],
	[2.1500000000E+04, 1.2273886210E+01, 5.0598762043E+00, 2.2680654393E+00, 1.3888667683E+00, 8.2006361458E-01],
	[2.1505000000E+04, 1.2278204668E+01, 5.0597756165E+00, 2.2697601273E+00, 1.3895498033E+00, 8.2014888699E-01],
	[2.1510000000E+04, 1.2282523641E+01, 5.0596750540E+00, 2.2714556867E+00, 1.3902328567E+00, 8.2023412416E-01],
	[2.1515000000E+04, 1.2286843128E+01, 5.0595745170E+00, 2.2731521177E+00, 1.3909159285E+00, 8.2031932608E-01],
	[2.1520000000E+04, 1.2291163131E+01, 5.0594740053E+00, 2.2748494205E+00, 1.3915990183E+00, 8.2040449277E-01],
	[2.1525000000E+04, 1.2295483648E+01, 5.0593735189E+00, 2.2765475954E+00, 1.3922821261E+00, 8.2048962422E-01],
	[2.1530000000E+04, 1.2299804680E+01, 5.0592730579E+00, 2.2782466426E+00, 1.3929652517E+00, 8.2057472045E-01],
	[2.1535000000E+04, 1.2304126227E+01, 5.0591726222E+00, 2.2799465623E+00, 1.3936483950E+00, 8.2065978146E-01],
	[2.1540000000E+04, 1.2308448288E+01, 5.0590722119E+00, 2.2816473548E+00, 1.3943315557E+00, 8.2074480725E-01],
	[2.1545000000E+04, 1.2312770864E+01, 5.0589718268E+00, 2.2833490204E+00, 1.3950147338E+00, 8.2082979783E-01],
	[2.1550000000E+04, 1.2317093954E+01, 5.0588714670E+00, 2.2850515593E+00, 1.3956979291E+00, 8.2091475320E-01],
	[2.1555000000E+04, 1.2321417558E+01, 5.0587711325E+00, 2.2867549718E+00, 1.3963811414E+00, 8.2099967338E-01],
	[2.1560000000E+04, 1.2325741677E+01, 5.0586708232E+00, 2.2884592580E+00, 1.3970643706E+00, 8.2108455837E-01],
	[2.1565000000E+04, 1.2330066310E+01, 5.0585705392E+00, 2.2901644182E+00, 1.3977476165E+00, 8.2116940817E-01],
	[2.1570000000E+04, 1.2334391458E+01, 5.0584702804E+00, 2.2918704527E+00, 1.3984308790E+00, 8.2125422278E-01],
	[2.1575000000E+04, 1.2338717120E+01, 5.0583700469E+00, 2.2935773618E+00, 1.3991141579E+00, 8.2133900222E-01],
	[2.1580000000E+04, 1.2343043295E+01, 5.0582698385E+00, 2.2952851456E+00, 1.3997974531E+00, 8.2142374649E-01],
	[2.1585000000E+04, 1.2347369985E+01, 5.0581696554E+00, 2.2969938044E+00, 1.4004807643E+00, 8.2150845560E-01],
	[2.1590000000E+04, 1.2351697189E+01, 5.0580694974E+00, 2.2987033384E+00, 1.4011640915E+00, 8.2159312955E-01],
	[2.1595000000E+04, 1.2356024907E+01, 5.0579693646E+00, 2.3004137480E+00, 1.4018474345E+00, 8.2167776834E-01],
	[2.1600000000E+04, 1.2360353139E+01, 5.0578692570E+00, 2.3021250333E+00, 1.4025307931E+00, 8.2176237199E-01],
	[2.1605000000E+04, 1.2364681884E+01, 5.0577691746E+00, 2.3038371946E+00, 1.4032141672E+00, 8.2184694049E-01],
	[2.1610000000E+04, 1.2369011144E+01, 5.0576691172E+00, 2.3055502321E+00, 1.4038975567E+00, 8.2193147386E-01],
	[2.1615000000E+04, 1.2373340917E+01, 5.0575690850E+00, 2.3072641461E+00, 1.4045809613E+00, 8.2201597210E-01],
	[2.1620000000E+04, 1.2377671203E+01, 5.0574690780E+00, 2.3089789369E+00, 1.4052643809E+00, 8.2210043522E-01],
	[2.1625000000E+04, 1.2382002004E+01, 5.0573690960E+00, 2.3106946046E+00, 1.4059478154E+00, 8.2218486321E-01],
	[2.1630000000E+04, 1.2386333317E+01, 5.0572691391E+00, 2.3124111495E+00, 1.4066312646E+00, 8.2226925610E-01],
	[2.1635000000E+04, 1.2390665145E+01, 5.0571692073E+00, 2.3141285719E+00, 1.4073147284E+00, 8.2235361388E-01],
	[2.1640000000E+04, 1.2394997486E+01, 5.0570693005E+00, 2.3158468720E+00, 1.4079982066E+00, 8.2243793656E-01],
	[2.1645000000E+04, 1.2399330340E+01, 5.0569694188E+00, 2.3175660500E+00, 1.4086816990E+00, 8.2252222414E-01],
	[2.1650000000E+04, 1.2403663707E+01, 5.0568695622E+00, 2.3192861062E+00, 1.4093652055E+00, 8.2260647664E-01],
	[2.1655000000E+04, 1.2407997588E+01, 5.0567697306E+00, 2.3210070409E+00, 1.4100487260E+00, 8.2269069406E-01],
	[2.1660000000E+04, 1.2412331982E+01, 5.0566699239E+00, 2.3227288543E+00, 1.4107322602E+00, 8.2277487639E-01],
	[2.1665000000E+04, 1.2416666889E+01, 5.0565701424E+00, 2.3244515466E+00, 1.4114158081E+00, 8.2285902366E-01],
	[2.1670000000E+04, 1.2421002309E+01, 5.0564703857E+00, 2.3261751181E+00, 1.4120993694E+00, 8.2294313587E-01],
	[2.1675000000E+04, 1.2425338242E+01, 5.0563706541E+00, 2.3278995690E+00, 1.4127829441E+00, 8.2302721301E-01],
	[2.1680000000E+04, 1.2429674688E+01, 5.0562709475E+00, 2.3296248995E+00, 1.4134665320E+00, 8.2311125511E-01],
	[2.1685000000E+04, 1.2434011647E+01, 5.0561712658E+00, 2.3313511100E+00, 1.4141501328E+00, 8.2319526216E-01],
	[2.1690000000E+04, 1.2438349119E+01, 5.0560716090E+00, 2.3330782006E+00, 1.4148337466E+00, 8.2327923416E-01],
	[2.1695000000E+04, 1.2442687104E+01, 5.0559719772E+00, 2.3348061717E+00, 1.4155173730E+00, 8.2336317114E-01],
	[2.1700000000E+04, 1.2447025601E+01, 5.0558723703E+00, 2.3365350234E+00, 1.4162010120E+00, 8.2344707309E-01],
	[2.1705000000E+04, 1.2451364611E+01, 5.0557727883E+00, 2.3382647559E+00, 1.4168846634E+00, 8.2353094001E-01],
	[2.1710000000E+04, 1.2455704134E+01, 5.0556732313E+00, 2.3399953697E+00, 1.4175683271E+00, 8.2361477193E-01],
	[2.1715000000E+04, 1.2460044169E+01, 5.0555736991E+00, 2.3417268648E+00, 1.4182520028E+00, 8.2369856883E-01],
	[2.1720000000E+04, 1.2464384717E+01, 5.0554741917E+00, 2.3434592415E+00, 1.4189356905E+00, 8.2378233073E-01],
	[2.1725000000E+04, 1.2468725777E+01, 5.0553747093E+00, 2.3451925001E+00, 1.4196193900E+00, 8.2386605763E-01],
	[2.1730000000E+04, 1.2473067350E+01, 5.0552752517E+00, 2.3469266409E+00, 1.4203031011E+00, 8.2394974955E-01],
	[2.1735000000E+04, 1.2477428333E+01, 5.0551797535E+00, 2.3486616640E+00, 1.4209873797E+00, 8.2403340648E-01],
	[2.1740000000E+04, 1.2481791029E+01, 5.0550845271E+00, 2.3503975697E+00, 1.4216717055E+00, 8.2411702843E-01],
	[2.1745000000E+04, 1.2486154246E+01, 5.0549893243E+00, 2.3521343583E+00, 1.4223560433E+00, 8.2420061541E-01],
	[2.1750000000E+04, 1.2490517985E+01, 5.0548941453E+00, 2.3538720299E+00, 1.4230403930E+00, 8.2428416743E-01],
	[2.1755000000E+04, 1.2494882245E+01, 5.0547989899E+00, 2.3556105850E+00, 1.4237247544E+00, 8.2436768449E-01],
	[2.1760000000E+04, 1.2499247027E+01, 5.0547038581E+00, 2.3573500236E+00, 1.4244091273E+00, 8.2445116660E-01],
	[2.1765000000E+04, 1.2503612331E+01, 5.0546087501E+00, 2.3590903460E+00, 1.4250935117E+00, 8.2453461376E-01],
	[2.1770000000E+04, 1.2507978155E+01, 5.0545136656E+00, 2.3608315526E+00, 1.4257779072E+00, 8.2461802598E-01],
	[2.1775000000E+04, 1.2512344501E+01, 5.0544186048E+00, 2.3625736434E+00, 1.4264623139E+00, 8.2470140328E-01],
	[2.1780000000E+04, 1.2516711368E+01, 5.0543235676E+00, 2.3643166189E+00, 1.4271467316E+00, 8.2478474564E-01],
	[2.1785000000E+04, 1.2521078756E+01, 5.0542285540E+00, 2.3660604792E+00, 1.4278311600E+00, 8.2486805308E-01],
	[2.1790000000E+04, 1.2525446665E+01, 5.0541335640E+00, 2.3678052245E+00, 1.4285155991E+00, 8.2495132562E-01],
	[2.1795000000E+04, 1.2529815096E+01, 5.0540385975E+00, 2.3695508552E+00, 1.4292000486E+00, 8.2503456324E-01],
	[2.1800000000E+04, 1.2534184047E+01, 5.0539436546E+00, 2.3712973714E+00, 1.4298845085E+00, 8.2511776597E-01],
	[2.1805000000E+04, 1.2538553519E+01, 5.0538487353E+00, 2.3730447734E+00, 1.4305689786E+00, 8.2520093380E-01],
	[2.1810000000E+04, 1.2542923512E+01, 5.0537538395E+00, 2.3747930614E+00, 1.4312534587E+00, 8.2528406674E-01],
	[2.1815000000E+04, 1.2547294026E+01, 5.0536589673E+00, 2.3765422358E+00, 1.4319379487E+00, 8.2536716481E-01],
	[2.1820000000E+04, 1.2551665061E+01, 5.0535641186E+00, 2.3782922967E+00, 1.4326224484E+00, 8.2545022800E-01],
	[2.1825000000E+04, 1.2556036616E+01, 5.0534692934E+00, 2.3800432444E+00, 1.4333069577E+00, 8.2553325632E-01],
	[2.1830000000E+04, 1.2560408692E+01, 5.0533744917E+00, 2.3817950791E+00, 1.4339914765E+00, 8.2561624979E-01],
	[2.1835000000E+04, 1.2564781289E+01, 5.0532797135E+00, 2.3835478011E+00, 1.4346760045E+00, 8.2569920839E-01],
	[2.1840000000E+04, 1.2569154406E+01, 5.0531849587E+00, 2.3853014106E+00, 1.4353605416E+00, 8.2578213216E-01],
	[2.1845000000E+04, 1.2573528044E+01, 5.0530902275E+00, 2.3870559079E+00, 1.4360450877E+00, 8.2586502108E-01],
	[2.1850000000E+04, 1.2577902202E+01, 5.0529955197E+00, 2.3888112932E+00, 1.4367296427E+00, 8.2594787517E-01],
	[2.1855000000E+04, 1.2582276880E+01, 5.0529008353E+00, 2.3905675668E+00, 1.4374142063E+00, 8.2603069443E-01],
	[2.1860000000E+04, 1.2586652078E+01, 5.0528061743E+00, 2.3923247288E+00, 1.4380987784E+00, 8.2611347887E-01],
	[2.1865000000E+04, 1.2591027797E+01, 5.0527115368E+00, 2.3940827796E+00, 1.4387833589E+00, 8.2619622850E-01],
	[2.1870000000E+04, 1.2595404036E+01, 5.0526169227E+00, 2.3958417195E+00, 1.4394679476E+00, 8.2627894332E-01],
	[2.1875000000E+04, 1.2599780795E+01, 5.0525223320E+00, 2.3976015485E+00, 1.4401525444E+00, 8.2636162334E-01],
	[2.1880000000E+04, 1.2604158075E+01, 5.0524277647E+00, 2.3993622671E+00, 1.4408371491E+00, 8.2644426857E-01],
	[2.1885000000E+04, 1.2608535874E+01, 5.0523332208E+00, 2.4011238753E+00, 1.4415217616E+00, 8.2652687901E-01],
	[2.1890000000E+04, 1.2612914193E+01, 5.0522387002E+00, 2.4028863736E+00, 1.4422063816E+00, 8.2660945467E-01],
	[2.1895000000E+04, 1.2617293032E+01, 5.0521442030E+00, 2.4046497621E+00, 1.4428910092E+00, 8.2669199556E-01],
	[2.1900000000E+04, 1.2621672391E+01, 5.0520497291E+00, 2.4064140411E+00, 1.4435756440E+00, 8.2677450169E-01],
	[2.1905000000E+04, 1.2626052270E+01, 5.0519552786E+00, 2.4081792107E+00, 1.4442602860E+00, 8.2685697305E-01],
	[2.1910000000E+04, 1.2630432668E+01, 5.0518608513E+00, 2.4099452714E+00, 1.4449449351E+00, 8.2693940967E-01],
	[2.1915000000E+04, 1.2634813586E+01, 5.0517664474E+00, 2.4117122232E+00, 1.4456295910E+00, 8.2702181154E-01],
	[2.1920000000E+04, 1.2639195024E+01, 5.0516720668E+00, 2.4134800665E+00, 1.4463142536E+00, 8.2710417867E-01],
	[2.1925000000E+04, 1.2643576981E+01, 5.0515777095E+00, 2.4152488016E+00, 1.4469989227E+00, 8.2718651107E-01],
	[2.1930000000E+04, 1.2647959458E+01, 5.0514833755E+00, 2.4170184285E+00, 1.4476835983E+00, 8.2726880875E-01],
	[2.1935000000E+04, 1.2652342454E+01, 5.0513890647E+00, 2.4187889477E+00, 1.4483682801E+00, 8.2735107171E-01],
	[2.1940000000E+04, 1.2656725969E+01, 5.0512947772E+00, 2.4205603592E+00, 1.4490529681E+00, 8.2743329996E-01],
	[2.1945000000E+04, 1.2661110004E+01, 5.0512005129E+00, 2.4223326635E+00, 1.4497376620E+00, 8.2751549351E-01],
	[2.1950000000E+04, 1.2665494558E+01, 5.0511062718E+00, 2.4241058607E+00, 1.4504223617E+00, 8.2759765236E-01],
	[2.1955000000E+04, 1.2669879632E+01, 5.0510120540E+00, 2.4258799511E+00, 1.4511070671E+00, 8.2767977652E-01],
	[2.1960000000E+04, 1.2674265224E+01, 5.0509178594E+00, 2.4276549349E+00, 1.4517917779E+00, 8.2776186600E-01],
	[2.1965000000E+04, 1.2678651336E+01, 5.0508236880E+00, 2.4294308124E+00, 1.4524764942E+00, 8.2784392081E-01],
	[2.1970000000E+04, 1.2683037966E+01, 5.0507295398E+00, 2.4312075838E+00, 1.4531612156E+00, 8.2792594095E-01],
	[2.1975000000E+04, 1.2687425116E+01, 5.0506354148E+00, 2.4329852493E+00, 1.4538459422E+00, 8.2800792643E-01],
	[2.1980000000E+04, 1.2691812785E+01, 5.0505413129E+00, 2.4347638093E+00, 1.4545306736E+00, 8.2808987726E-01],
	[2.1985000000E+04, 1.2696200972E+01, 5.0504472342E+00, 2.4365432639E+00, 1.4552154098E+00, 8.2817179344E-01],
	[2.1990000000E+04, 1.2700589678E+01, 5.0503531786E+00, 2.4383236134E+00, 1.4559001506E+00, 8.2825367498E-01],
	[2.1995000000E+04, 1.2704978903E+01, 5.0502591462E+00, 2.4401048580E+00, 1.4565848958E+00, 8.2833552189E-01],
	[2.2000000000E+04, 1.2709368647E+01, 5.0501651368E+00, 2.4418869981E+00, 1.4572696454E+00, 8.2841733418E-01],
	[2.2005000000E+04, 1.2713758909E+01, 5.0500711506E+00, 2.4436700337E+00, 1.4579543992E+00, 8.2849911185E-01],
	[2.2010000000E+04, 1.2718149690E+01, 5.0499771875E+00, 2.4454539653E+00, 1.4586391569E+00, 8.2858085491E-01],
	[2.2015000000E+04, 1.2722540990E+01, 5.0498832475E+00, 2.4472387930E+00, 1.4593239185E+00, 8.2866256337E-01],
	[2.2020000000E+04, 1.2726932808E+01, 5.0497893306E+00, 2.4490245170E+00, 1.4600086839E+00, 8.2874423723E-01],
	[2.2025000000E+04, 1.2731325144E+01, 5.0496954368E+00, 2.4508111377E+00, 1.4606934528E+00, 8.2882587651E-01],
	[2.2030000000E+04, 1.2735717999E+01, 5.0496015660E+00, 2.4525986553E+00, 1.4613782251E+00, 8.2890748120E-01],
	[2.2035000000E+04, 1.2740111372E+01, 5.0495077182E+00, 2.4543870699E+00, 1.4620630007E+00, 8.2898905132E-01],
	[2.2040000000E+04, 1.2744505263E+01, 5.0494138935E+00, 2.4561763819E+00, 1.4627477795E+00, 8.2907058688E-01],
	[2.2045000000E+04, 1.2748899672E+01, 5.0493200918E+00, 2.4579665916E+00, 1.4634325612E+00, 8.2915208788E-01],
	[2.2050000000E+04, 1.2753294600E+01, 5.0492263131E+00, 2.4597576991E+00, 1.4641173457E+00, 8.2923355432E-01],
	[2.2055000000E+04, 1.2757690045E+01, 5.0491325574E+00, 2.4615497046E+00, 1.4648021329E+00, 8.2931498622E-01],
	[2.2060000000E+04, 1.2762086009E+01, 5.0490388248E+00, 2.4633426085E+00, 1.4654869226E+00, 8.2939638359E-01],
	[2.2065000000E+04, 1.2766482491E+01, 5.0489451151E+00, 2.4651364110E+00, 1.4661717147E+00, 8.2947774643E-01],
	[2.2070000000E+04, 1.2770879490E+01, 5.0488514283E+00, 2.4669311124E+00, 1.4668565090E+00, 8.2955907475E-01],
	[2.2075000000E+04, 1.2775277008E+01, 5.0487577646E+00, 2.4687267128E+00, 1.4675413054E+00, 8.2964036855E-01],
	[2.2080000000E+04, 1.2779675043E+01, 5.0486641238E+00, 2.4705232126E+00, 1.4682261038E+00, 8.2972162784E-01],
	[2.2085000000E+04, 1.2784093398E+01, 5.0485745260E+00, 2.4723206119E+00, 1.4689115057E+00, 8.2980285264E-01],
	[2.2090000000E+04, 1.2788512786E+01, 5.0484850530E+00, 2.4741189111E+00, 1.4695969254E+00, 8.2988404295E-01],
	[2.2095000000E+04, 1.2792932701E+01, 5.0483956018E+00, 2.4759181103E+00, 1.4702823475E+00, 8.2996519877E-01],
	[2.2100000000E+04, 1.2797353143E+01, 5.0483061724E+00, 2.4777182098E+00, 1.4709677718E+00, 8.3004632011E-01],
	[2.2105000000E+04, 1.2801774112E+01, 5.0482167648E+00, 2.4795192099E+00, 1.4716531981E+00, 8.3012740699E-01],
	[2.2110000000E+04, 1.2806195608E+01, 5.0481273790E+00, 2.4813211108E+00, 1.4723386262E+00, 8.3020845941E-01],
	[2.2115000000E+04, 1.2810617631E+01, 5.0480380150E+00, 2.4831239127E+00, 1.4730240561E+00, 8.3028947737E-01],
	[2.2120000000E+04, 1.2815040180E+01, 5.0479486728E+00, 2.4849276160E+00, 1.4737094876E+00, 8.3037046089E-01],
	[2.2125000000E+04, 1.2819463257E+01, 5.0478593524E+00, 2.4867322208E+00, 1.4743949206E+00, 8.3045140997E-01],
	[2.2130000000E+04, 1.2823886859E+01, 5.0477700538E+00, 2.4885377274E+00, 1.4750803548E+00, 8.3053232461E-01],
	[2.2135000000E+04, 1.2828310989E+01, 5.0476807768E+00, 2.4903441360E+00, 1.4757657902E+00, 8.3061320484E-01],
	[2.2140000000E+04, 1.2832735645E+01, 5.0475915217E+00, 2.4921514469E+00, 1.4764512266E+00, 8.3069405065E-01],
	[2.2145000000E+04, 1.2837160827E+01, 5.0475022882E+00, 2.4939596603E+00, 1.4771366639E+00, 8.3077486205E-01],
	[2.2150000000E+04, 1.2841586536E+01, 5.0474130765E+00, 2.4957687765E+00, 1.4778221018E+00, 8.3085563905E-01],
	[2.2155000000E+04, 1.2846012771E+01, 5.0473238865E+00, 2.4975787958E+00, 1.4785075404E+00, 8.3093638166E-01],
	[2.2160000000E+04, 1.2850439533E+01, 5.0472347182E+00, 2.4993897183E+00, 1.4791929793E+00, 8.3101708989E-01],
	[2.2165000000E+04, 1.2854866821E+01, 5.0471455716E+00, 2.5012015443E+00, 1.4798784185E+00, 8.3109776373E-01],
	[2.2170000000E+04, 1.2859294635E+01, 5.0470564467E+00, 2.5030142741E+00, 1.4805638578E+00, 8.3117840321E-01],
	[2.2175000000E+04, 1.2863722975E+01, 5.0469673435E+00, 2.5048279079E+00, 1.4812492971E+00, 8.3125900833E-01],
	[2.2180000000E+04, 1.2868151841E+01, 5.0468782619E+00, 2.5066424459E+00, 1.4819347362E+00, 8.3133957910E-01],
	[2.2185000000E+04, 1.2872581233E+01, 5.0467892019E+00, 2.5084578884E+00, 1.4826201750E+00, 8.3142011552E-01],
	[2.2190000000E+04, 1.2877011151E+01, 5.0467001636E+00, 2.5102742357E+00, 1.4833056133E+00, 8.3150061760E-01],
	[2.2195000000E+04, 1.2881441595E+01, 5.0466111470E+00, 2.5120914880E+00, 1.4839910510E+00, 8.3158108535E-01],
	[2.2200000000E+04, 1.2885872565E+01, 5.0465221519E+00, 2.5139096456E+00, 1.4846764880E+00, 8.3166151878E-01],
	[2.2205000000E+04, 1.2890304061E+01, 5.0464331785E+00, 2.5157287086E+00, 1.4853619240E+00, 8.3174191790E-01],
	[2.2210000000E+04, 1.2894736083E+01, 5.0463442266E+00, 2.5175486773E+00, 1.4860473590E+00, 8.3182228271E-01],
	[2.2215000000E+04, 1.2899168630E+01, 5.0462552964E+00, 2.5193695521E+00, 1.4867327928E+00, 8.3190261322E-01],
	[2.2220000000E+04, 1.2903601703E+01, 5.0461663877E+00, 2.5211913330E+00, 1.4874182253E+00, 8.3198290944E-01],
	[2.2225000000E+04, 1.2908035301E+01, 5.0460775006E+00, 2.5230140205E+00, 1.4881036562E+00, 8.3206317138E-01],
	[2.2230000000E+04, 1.2912469425E+01, 5.0459886351E+00, 2.5248376146E+00, 1.4887890856E+00, 8.3214339904E-01],
	[2.2235000000E+04, 1.2916904074E+01, 5.0458997911E+00, 2.5266621157E+00, 1.4894745131E+00, 8.3222359244E-01],
	[2.2240000000E+04, 1.2921339249E+01, 5.0458109686E+00, 2.5284875241E+00, 1.4901599387E+00, 8.3230375157E-01],
	[2.2245000000E+04, 1.2925774949E+01, 5.0457221677E+00, 2.5303138399E+00, 1.4908453623E+00, 8.3238387646E-01],
	[2.2250000000E+04, 1.2930211175E+01, 5.0456333883E+00, 2.5321410633E+00, 1.4915307836E+00, 8.3246396711E-01],
	[2.2255000000E+04, 1.2934647925E+01, 5.0455446304E+00, 2.5339691948E+00, 1.4922162025E+00, 8.3254402352E-01],
	[2.2260000000E+04, 1.2939085201E+01, 5.0454558941E+00, 2.5357982345E+00, 1.4929016190E+00, 8.3262404570E-01],
	[2.2265000000E+04, 1.2943523002E+01, 5.0453671792E+00, 2.5376281825E+00, 1.4935870328E+00, 8.3270403366E-01],
	[2.2270000000E+04, 1.2947961328E+01, 5.0452784857E+00, 2.5394590393E+00, 1.4942724437E+00, 8.3278398742E-01],
	[2.2275000000E+04, 1.2952400179E+01, 5.0451898138E+00, 2.5412908051E+00, 1.4949578518E+00, 8.3286390697E-01],
	[2.2280000000E+04, 1.2956839555E+01, 5.0451011633E+00, 2.5431234800E+00, 1.4956432567E+00, 8.3294379233E-01],
	[2.2285000000E+04, 1.2961279456E+01, 5.0450125343E+00, 2.5449570643E+00, 1.4963286584E+00, 8.3302364350E-01],
	[2.2290000000E+04, 1.2965719882E+01, 5.0449239267E+00, 2.5467915584E+00, 1.4970140567E+00, 8.3310346049E-01],
	[2.2295000000E+04, 1.2970160833E+01, 5.0448353405E+00, 2.5486269623E+00, 1.4976994515E+00, 8.3318324332E-01],
	[2.2300000000E+04, 1.2974602308E+01, 5.0447467757E+00, 2.5504632764E+00, 1.4983848426E+00, 8.3326299198E-01],
	[2.2305000000E+04, 1.2979044308E+01, 5.0446582324E+00, 2.5523005010E+00, 1.4990702299E+00, 8.3334270649E-01],
	[2.2310000000E+04, 1.2983486833E+01, 5.0445697105E+00, 2.5541386362E+00, 1.4997556133E+00, 8.3342238685E-01],
	[2.2315000000E+04, 1.2987929882E+01, 5.0444812099E+00, 2.5559776823E+00, 1.5004409925E+00, 8.3350203307E-01],
	[2.2320000000E+04, 1.2992373456E+01, 5.0443927307E+00, 2.5578176396E+00, 1.5011263675E+00, 8.3358164517E-01],
	[2.2325000000E+04, 1.2996817554E+01, 5.0443042729E+00, 2.5596585083E+00, 1.5018117381E+00, 8.3366122314E-01],
	[2.2330000000E+04, 1.3001262176E+01, 5.0442158365E+00, 2.5615002887E+00, 1.5024971041E+00, 8.3374076701E-01],
	[2.2335000000E+04, 1.3005707323E+01, 5.0441274214E+00, 2.5633429809E+00, 1.5031824655E+00, 8.3382027676E-01],
	[2.2340000000E+04, 1.3010152995E+01, 5.0440390276E+00, 2.5651865853E+00, 1.5038678220E+00, 8.3389975243E-01],
	[2.2345000000E+04, 1.3014599190E+01, 5.0439506552E+00, 2.5670311021E+00, 1.5045531735E+00, 8.3397919400E-01],
	[2.2350000000E+04, 1.3019045910E+01, 5.0438623041E+00, 2.5688765315E+00, 1.5052385199E+00, 8.3405860149E-01],
	[2.2355000000E+04, 1.3023493154E+01, 5.0437739743E+00, 2.5707228738E+00, 1.5059238611E+00, 8.3413797492E-01],
	[2.2360000000E+04, 1.3027940921E+01, 5.0436856658E+00, 2.5725701293E+00, 1.5066091969E+00, 8.3421731428E-01],
	[2.2365000000E+04, 1.3032389213E+01, 5.0435973786E+00, 2.5744288163E+00, 1.5072981327E+00, 8.3429661958E-01],
	[2.2370000000E+04, 1.3036838029E+01, 5.0435091127E+00, 2.5762901430E+00, 1.5079876503E+00, 8.3437589084E-01],
	[2.2375000000E+04, 1.3041287369E+01, 5.0434208681E+00, 2.5781523985E+00, 1.5086771628E+00, 8.3445512806E-01],
	[2.2380000000E+04, 1.3045737233E+01, 5.0433326447E+00, 2.5800155829E+00, 1.5093666700E+00, 8.3453433126E-01],
	[2.2385000000E+04, 1.3050187620E+01, 5.0432444425E+00, 2.5818796966E+00, 1.5100561717E+00, 8.3461350043E-01],
	[2.2390000000E+04, 1.3054638531E+01, 5.0431562616E+00, 2.5837447398E+00, 1.5107456677E+00, 8.3469263559E-01],
	[2.2395000000E+04, 1.3059089966E+01, 5.0430681020E+00, 2.5856107127E+00, 1.5114351580E+00, 8.3477173674E-01],
	[2.2400000000E+04, 1.3063541924E+01, 5.0429799635E+00, 2.5874776156E+00, 1.5121246423E+00, 8.3485080390E-01],
	[2.2405000000E+04, 1.3067994406E+01, 5.0428918463E+00, 2.5893454488E+00, 1.5128141206E+00, 8.3492983707E-01],
	[2.2410000000E+04, 1.3072447412E+01, 5.0428037503E+00, 2.5912142125E+00, 1.5135035926E+00, 8.3500883626E-01],
	[2.2415000000E+04, 1.3076900941E+01, 5.0427156754E+00, 2.5930839070E+00, 1.5141930583E+00, 8.3508780148E-01],
	[2.2420000000E+04, 1.3081354993E+01, 5.0426276218E+00, 2.5949545325E+00, 1.5148825175E+00, 8.3516673274E-01],
	[2.2425000000E+04, 1.3085809569E+01, 5.0425395893E+00, 2.5968260893E+00, 1.5155719701E+00, 8.3524563004E-01],
	[2.2430000000E+04, 1.3090264668E+01, 5.0424515779E+00, 2.5986985776E+00, 1.5162614158E+00, 8.3532449340E-01],
	[2.2435000000E+04, 1.3094720290E+01, 5.0423635878E+00, 2.6005719978E+00, 1.5169508546E+00, 8.3540332283E-01],
	[2.2440000000E+04, 1.3099194566E+01, 5.0422792080E+00, 2.6024463499E+00, 1.5176408548E+00, 8.3548211832E-01],
	[2.2445000000E+04, 1.3103671775E+01, 5.0421953235E+00, 2.6043216344E+00, 1.5183309238E+00, 8.3556087990E-01],
	[2.2450000000E+04, 1.3108149516E+01, 5.0421114592E+00, 2.6061978514E+00, 1.5190209864E+00, 8.3563960756E-01],
	[2.2455000000E+04, 1.3112627789E+01, 5.0420276149E+00, 2.6080750013E+00, 1.5197110422E+00, 8.3571830133E-01],
	[2.2460000000E+04, 1.3117106595E+01, 5.0419437906E+00, 2.6099530842E+00, 1.5204010912E+00, 8.3579696120E-01],
	[2.2465000000E+04, 1.3121585933E+01, 5.0418599865E+00, 2.6118321004E+00, 1.5210911333E+00, 8.3587558718E-01],
	[2.2470000000E+04, 1.3126065804E+01, 5.0417762023E+00, 2.6137120502E+00, 1.5217811682E+00, 8.3595417929E-01],
	[2.2475000000E+04, 1.3130546206E+01, 5.0416924382E+00, 2.6155929339E+00, 1.5224711959E+00, 8.3603273753E-01],
	[2.2480000000E+04, 1.3135027141E+01, 5.0416086942E+00, 2.6174747517E+00, 1.5231612161E+00, 8.3611126191E-01],
	[2.2485000000E+04, 1.3139508608E+01, 5.0415249701E+00, 2.6193575038E+00, 1.5238512289E+00, 8.3618975244E-01],
	[2.2490000000E+04, 1.3143990607E+01, 5.0414412661E+00, 2.6212411905E+00, 1.5245412339E+00, 8.3626820913E-01],
	[2.2495000000E+04, 1.3148473138E+01, 5.0413575820E+00, 2.6231258120E+00, 1.5252312311E+00, 8.3634663198E-01],
	[2.2500000000E+04, 1.3152956201E+01, 5.0412739179E+00, 2.6250113687E+00, 1.5259212203E+00, 8.3642502101E-01],
	[2.2505000000E+04, 1.3157439796E+01, 5.0411902738E+00, 2.6268978608E+00, 1.5266112014E+00, 8.3650337623E-01],
	[2.2510000000E+04, 1.3161923923E+01, 5.0411066497E+00, 2.6287852884E+00, 1.5273011742E+00, 8.3658169763E-01],
	[2.2515000000E+04, 1.3166408581E+01, 5.0410230456E+00, 2.6306736520E+00, 1.5279911385E+00, 8.3665998524E-01],
	[2.2520000000E+04, 1.3170893771E+01, 5.0409394613E+00, 2.6325629517E+00, 1.5286810944E+00, 8.3673823906E-01],
	[2.2525000000E+04, 1.3175379493E+01, 5.0408558971E+00, 2.6344531878E+00, 1.5293710415E+00, 8.3681645910E-01],
	[2.2530000000E+04, 1.3179865747E+01, 5.0407723527E+00, 2.6363443605E+00, 1.5300609797E+00, 8.3689464537E-01],
	[2.2535000000E+04, 1.3184352532E+01, 5.0406888283E+00, 2.6382364701E+00, 1.5307509090E+00, 8.3697279787E-01],
	[2.2540000000E+04, 1.3188839849E+01, 5.0406053238E+00, 2.6401295169E+00, 1.5314408291E+00, 8.3705091662E-01],
	[2.2545000000E+04, 1.3193327697E+01, 5.0405218392E+00, 2.6420235011E+00, 1.5321307400E+00, 8.3712900162E-01],
	[2.2550000000E+04, 1.3197816076E+01, 5.0404383745E+00, 2.6439184230E+00, 1.5328206414E+00, 8.3720705289E-01],
	[2.2555000000E+04, 1.3202304987E+01, 5.0403549297E+00, 2.6458142828E+00, 1.5335105332E+00, 8.3728507042E-01],
	[2.2560000000E+04, 1.3206794429E+01, 5.0402715047E+00, 2.6477110808E+00, 1.5342004153E+00, 8.3736305424E-01],
	[2.2565000000E+04, 1.3211284402E+01, 5.0401880997E+00, 2.6496088173E+00, 1.5348902876E+00, 8.3744100435E-01],
	[2.2570000000E+04, 1.3215774907E+01, 5.0401047145E+00, 2.6515074924E+00, 1.5355801498E+00, 8.3751892076E-01],
	[2.2575000000E+04, 1.3220265942E+01, 5.0400213491E+00, 2.6534071065E+00, 1.5362700020E+00, 8.3759680347E-01],
	[2.2580000000E+04, 1.3224757509E+01, 5.0399380036E+00, 2.6553076597E+00, 1.5369598438E+00, 8.3767465250E-01],
	[2.2585000000E+04, 1.3229249607E+01, 5.0398546779E+00, 2.6572091525E+00, 1.5376496752E+00, 8.3775246785E-01],
	[2.2590000000E+04, 1.3233742236E+01, 5.0397713720E+00, 2.6591115849E+00, 1.5383394960E+00, 8.3783024954E-01],
	[2.2595000000E+04, 1.3238235395E+01, 5.0396880859E+00, 2.6610149574E+00, 1.5390293060E+00, 8.3790799755E-01],
	[2.2600000000E+04, 1.3242729086E+01, 5.0396048197E+00, 2.6629192700E+00, 1.5397191052E+00, 8.3798571191E-01],
	[2.2605000000E+04, 1.3247223307E+01, 5.0395215732E+00, 2.6648245232E+00, 1.5404088935E+00, 8.3806339262E-01],
	[2.2610000000E+04, 1.3251718059E+01, 5.0394383466E+00, 2.6667307170E+00, 1.5410986705E+00, 8.3814103969E-01],
	[2.2615000000E+04, 1.3256213342E+01, 5.0393551397E+00, 2.6686378519E+00, 1.5417884363E+00, 8.3821865312E-01],
	[2.2620000000E+04, 1.3260709155E+01, 5.0392719525E+00, 2.6705459281E+00, 1.5424781906E+00, 8.3829623292E-01],
	[2.2625000000E+04, 1.3265205499E+01, 5.0391887852E+00, 2.6724549457E+00, 1.5431679333E+00, 8.3837377910E-01],
	[2.2630000000E+04, 1.3269702373E+01, 5.0391056375E+00, 2.6743649051E+00, 1.5438576643E+00, 8.3845129167E-01],
	[2.2635000000E+04, 1.3274199778E+01, 5.0390225097E+00, 2.6762758065E+00, 1.5445473835E+00, 8.3852877063E-01],
	[2.2640000000E+04, 1.3278697714E+01, 5.0389394015E+00, 2.6781876502E+00, 1.5452370906E+00, 8.3860621598E-01],
	[2.2645000000E+04, 1.3283196179E+01, 5.0388563131E+00, 2.6801004365E+00, 1.5459267856E+00, 8.3868362774E-01],
	[2.2650000000E+04, 1.3287695175E+01, 5.0387732444E+00, 2.6820141655E+00, 1.5466164683E+00, 8.3876100592E-01],
	[2.2655000000E+04, 1.3292194701E+01, 5.0386901954E+00, 2.6839288375E+00, 1.5473061385E+00, 8.3883835052E-01],
	[2.2660000000E+04, 1.3296694758E+01, 5.0386071661E+00, 2.6858444529E+00, 1.5479957962E+00, 8.3891566154E-01],
	[2.2665000000E+04, 1.3301195344E+01, 5.0385241564E+00, 2.6877610118E+00, 1.5486854411E+00, 8.3899293900E-01],
	[2.2670000000E+04, 1.3305696461E+01, 5.0384411665E+00, 2.6896785146E+00, 1.5493750732E+00, 8.3907018290E-01],
	[2.2675000000E+04, 1.3310198108E+01, 5.0383581962E+00, 2.6915969614E+00, 1.5500646923E+00, 8.3914739325E-01],
	[2.2680000000E+04, 1.3314700284E+01, 5.0382752456E+00, 2.6935163525E+00, 1.5507542982E+00, 8.3922457006E-01],
	[2.2685000000E+04, 1.3319202991E+01, 5.0381923146E+00, 2.6954366882E+00, 1.5514438909E+00, 8.3930171333E-01],
	[2.2690000000E+04, 1.3323706227E+01, 5.0381094033E+00, 2.6973579687E+00, 1.5521334701E+00, 8.3937882307E-01],
	[2.2695000000E+04, 1.3328209994E+01, 5.0380265116E+00, 2.6992801943E+00, 1.5528230357E+00, 8.3945589929E-01],
	[2.2700000000E+04, 1.3332714290E+01, 5.0379436395E+00, 2.7012033653E+00, 1.5535125876E+00, 8.3953294200E-01],
	[2.2705000000E+04, 1.3337219116E+01, 5.0378607871E+00, 2.7031274819E+00, 1.5542021256E+00, 8.3960995119E-01],
	[2.2710000000E+04, 1.3341724471E+01, 5.0377779542E+00, 2.7050525443E+00, 1.5548916497E+00, 8.3968692689E-01],
	[2.2715000000E+04, 1.3346230356E+01, 5.0376951410E+00, 2.7069785529E+00, 1.5555811596E+00, 8.3976386910E-01],
	[2.2720000000E+04, 1.3350736770E+01, 5.0376123473E+00, 2.7089055078E+00, 1.5562706552E+00, 8.3984077782E-01],
	[2.2725000000E+04, 1.3355243714E+01, 5.0375295732E+00, 2.7108334094E+00, 1.5569601364E+00, 8.3991765306E-01],
	[2.2730000000E+04, 1.3359751188E+01, 5.0374468187E+00, 2.7127622578E+00, 1.5576496030E+00, 8.3999449484E-01],
	[2.2735000000E+04, 1.3364259191E+01, 5.0373640837E+00, 2.7146920534E+00, 1.5583390549E+00, 8.4007130315E-01],
	[2.2740000000E+04, 1.3368767723E+01, 5.0372813683E+00, 2.7166227964E+00, 1.5590284920E+00, 8.4014807800E-01],
	[2.2745000000E+04, 1.3373276784E+01, 5.0371986725E+00, 2.7185544870E+00, 1.5597179141E+00, 8.4022481941E-01],
	[2.2750000000E+04, 1.3377786375E+01, 5.0371159961E+00, 2.7204871256E+00, 1.5604073210E+00, 8.4030152738E-01],
	[2.2755000000E+04, 1.3382296495E+01, 5.0370333393E+00, 2.7224207123E+00, 1.5610967127E+00, 8.4037820191E-01],
	[2.2760000000E+04, 1.3386807144E+01, 5.0369507020E+00, 2.7243552474E+00, 1.5617860890E+00, 8.4045484302E-01],
	[2.2765000000E+04, 1.3391318322E+01, 5.0368680842E+00, 2.7262907312E+00, 1.5624754497E+00, 8.4053145071E-01],
	[2.2770000000E+04, 1.3395830029E+01, 5.0367854860E+00, 2.7282271640E+00, 1.5631647947E+00, 8.4060802499E-01],
	[2.2775000000E+04, 1.3400342265E+01, 5.0367029072E+00, 2.7301645459E+00, 1.5638541239E+00, 8.4068456586E-01],
	[2.2780000000E+04, 1.3404855030E+01, 5.0366203479E+00, 2.7321028773E+00, 1.5645434371E+00, 8.4076107334E-01],
	[2.2785000000E+04, 1.3409368323E+01, 5.0365378080E+00, 2.7340421584E+00, 1.5652327342E+00, 8.4083754744E-01],
	[2.2790000000E+04, 1.3413882146E+01, 5.0364552876E+00, 2.7359823894E+00, 1.5659220150E+00, 8.4091398815E-01],
	[2.2795000000E+04, 1.3418396497E+01, 5.0363727867E+00, 2.7379235707E+00, 1.5666112794E+00, 8.4099039549E-01],
	[2.2800000000E+04, 1.3422924799E+01, 5.0362928962E+00, 2.7398657024E+00, 1.5673009612E+00, 8.4106676946E-01],
	[2.2805000000E+04, 1.3427460973E+01, 5.0362144403E+00, 2.7418087849E+00, 1.5679908642E+00, 8.4114311008E-01],
	[2.2810000000E+04, 1.3431997685E+01, 5.0361360029E+00, 2.7437528183E+00, 1.5686807512E+00, 8.4121941735E-01],
	[2.2815000000E+04, 1.3436534935E+01, 5.0360575839E+00, 2.7456978030E+00, 1.5693706221E+00, 8.4129569127E-01],
	[2.2820000000E+04, 1.3441072723E+01, 5.0359791833E+00, 2.7476437392E+00, 1.5700604768E+00, 8.4137193186E-01],
	[2.2825000000E+04, 1.3445611048E+01, 5.0359008010E+00, 2.7495906271E+00, 1.5707503151E+00, 8.4144813913E-01],
	[2.2830000000E+04, 1.3450149912E+01, 5.0358224372E+00, 2.7515384671E+00, 1.5714401368E+00, 8.4152431307E-01],
	[2.2835000000E+04, 1.3454689313E+01, 5.0357440918E+00, 2.7534872593E+00, 1.5721299420E+00, 8.4160045371E-01],
	[2.2840000000E+04, 1.3459229252E+01, 5.0356657647E+00, 2.7554370040E+00, 1.5728197303E+00, 8.4167656104E-01],
	[2.2845000000E+04, 1.3463769728E+01, 5.0355874560E+00, 2.7573877015E+00, 1.5735095016E+00, 8.4175263507E-01],
	[2.2850000000E+04, 1.3468310743E+01, 5.0355091656E+00, 2.7593393521E+00, 1.5741992559E+00, 8.4182867582E-01],
	[2.2855000000E+04, 1.3472852294E+01, 5.0354308936E+00, 2.7612919559E+00, 1.5748889930E+00, 8.4190468329E-01],
	[2.2860000000E+04, 1.3477394383E+01, 5.0353526399E+00, 2.7632455133E+00, 1.5755787127E+00, 8.4198065748E-01],
	[2.2865000000E+04, 1.3481937010E+01, 5.0352744046E+00, 2.7652000245E+00, 1.5762684149E+00, 8.4205659841E-01],
	[2.2870000000E+04, 1.3486480174E+01, 5.0351961875E+00, 2.7671554898E+00, 1.5769580994E+00, 8.4213250608E-01],
	[2.2875000000E+04, 1.3491023875E+01, 5.0351179888E+00, 2.7691119094E+00, 1.5776477662E+00, 8.4220838051E-01],
	[2.2880000000E+04, 1.3495568114E+01, 5.0350398084E+00, 2.7710692835E+00, 1.5783374151E+00, 8.4228422169E-01],
	[2.2885000000E+04, 1.3500112889E+01, 5.0349616463E+00, 2.7730276125E+00, 1.5790270459E+00, 8.4236002964E-01],
	[2.2890000000E+04, 1.3504658202E+01, 5.0348835025E+00, 2.7749868966E+00, 1.5797166586E+00, 8.4243580436E-01],
	[2.2895000000E+04, 1.3509204052E+01, 5.0348053769E+00, 2.7769471360E+00, 1.5804062529E+00, 8.4251154587E-01],
	[2.2900000000E+04, 1.3513750439E+01, 5.0347272697E+00, 2.7789083311E+00, 1.5810958287E+00, 8.4258725417E-01],
	[2.2905000000E+04, 1.3518297363E+01, 5.0346491807E+00, 2.7808704819E+00, 1.5817853859E+00, 8.4266292926E-01],
	[2.2910000000E+04, 1.3522844824E+01, 5.0345711099E+00, 2.7828335889E+00, 1.5824749244E+00, 8.4273857117E-01],
	[2.2915000000E+04, 1.3527392822E+01, 5.0344930574E+00, 2.7847976523E+00, 1.5831644440E+00, 8.4281417988E-01],
	[2.2920000000E+04, 1.3531941356E+01, 5.0344150231E+00, 2.7867626723E+00, 1.5838539446E+00, 8.4288975542E-01],
	[2.2925000000E+04, 1.3536490428E+01, 5.0343370071E+00, 2.7887286492E+00, 1.5845434260E+00, 8.4296529779E-01],
	[2.2930000000E+04, 1.3541040036E+01, 5.0342590093E+00, 2.7906955832E+00, 1.5852328881E+00, 8.4304080700E-01],
	[2.2935000000E+04, 1.3545590181E+01, 5.0341810297E+00, 2.7926634746E+00, 1.5859223307E+00, 8.4311628306E-01],
	[2.2940000000E+04, 1.3550140862E+01, 5.0341030683E+00, 2.7946323237E+00, 1.5866117538E+00, 8.4319172597E-01],
	[2.2945000000E+04, 1.3554692080E+01, 5.0340251251E+00, 2.7966021307E+00, 1.5873011572E+00, 8.4326713574E-01],
	[2.2950000000E+04, 1.3559243834E+01, 5.0339472001E+00, 2.7985728959E+00, 1.5879905407E+00, 8.4334251238E-01],
	[2.2955000000E+04, 1.3563796125E+01, 5.0338692932E+00, 2.8005446194E+00, 1.5886799043E+00, 8.4341785590E-01],
	[2.2960000000E+04, 1.3568348953E+01, 5.0337914046E+00, 2.8025173017E+00, 1.5893692477E+00, 8.4349316631E-01],
	[2.2965000000E+04, 1.3572902316E+01, 5.0337135341E+00, 2.8044909429E+00, 1.5900585708E+00, 8.4356844362E-01],
	[2.2970000000E+04, 1.3577456216E+01, 5.0336356818E+00, 2.8064655433E+00, 1.5907478736E+00, 8.4364368782E-01],
	[2.2975000000E+04, 1.3582010652E+01, 5.0335578476E+00, 2.8084411031E+00, 1.5914371558E+00, 8.4371889894E-01],
	[2.2980000000E+04, 1.3586565625E+01, 5.0334800315E+00, 2.8104176227E+00, 1.5921264173E+00, 8.4379407698E-01],
	[2.2985000000E+04, 1.3591121133E+01, 5.0334022336E+00, 2.8123951022E+00, 1.5928156580E+00, 8.4386922194E-01],
	[2.2990000000E+04, 1.3595677178E+01, 5.0333244538E+00, 2.8143735420E+00, 1.5935048778E+00, 8.4394433384E-01],
	[2.2995000000E+04, 1.3600233758E+01, 5.0332466922E+00, 2.8163529422E+00, 1.5941940765E+00, 8.4401941269E-01],
	[2.3000000000E+04, 1.3604790875E+01, 5.0331689486E+00, 2.8183333032E+00, 1.5948832539E+00, 8.4409445849E-01],
	[2.3005000000E+04, 1.3609348527E+01, 5.0330912231E+00, 2.8203146251E+00, 1.5955724100E+00, 8.4416947125E-01],
	[2.3010000000E+04, 1.3613906715E+01, 5.0330135157E+00, 2.8222969083E+00, 1.5962615446E+00, 8.4424445097E-01],
	[2.3015000000E+04, 1.3618465439E+01, 5.0329358265E+00, 2.8242801530E+00, 1.5969506576E+00, 8.4431939768E-01],
	[2.3020000000E+04, 1.3623024699E+01, 5.0328581552E+00, 2.8262643595E+00, 1.5976397488E+00, 8.4439431137E-01],
	[2.3025000000E+04, 1.3627584495E+01, 5.0327805021E+00, 2.8282495280E+00, 1.5983288180E+00, 8.4446919205E-01],
	[2.3030000000E+04, 1.3632144826E+01, 5.0327028670E+00, 2.8302356587E+00, 1.5990178653E+00, 8.4454403973E-01],
	[2.3035000000E+04, 1.3636705693E+01, 5.0326252500E+00, 2.8322227521E+00, 1.5997068903E+00, 8.4461885443E-01],
	[2.3040000000E+04, 1.3641267095E+01, 5.0325476510E+00, 2.8342108081E+00, 1.6003958930E+00, 8.4469363614E-01],
	[2.3045000000E+04, 1.3645829033E+01, 5.0324700700E+00, 2.8361998273E+00, 1.6010848733E+00, 8.4476838488E-01],
	[2.3050000000E+04, 1.3650391506E+01, 5.0323925071E+00, 2.8381898097E+00, 1.6017738310E+00, 8.4484310066E-01],
	[2.3055000000E+04, 1.3654954515E+01, 5.0323149621E+00, 2.8401807557E+00, 1.6024627659E+00, 8.4491778348E-01],
	[2.3060000000E+04, 1.3659518059E+01, 5.0322374352E+00, 2.8421726656E+00, 1.6031516780E+00, 8.4499243335E-01],
	[2.3065000000E+04, 1.3664082138E+01, 5.0321599263E+00, 2.8441655395E+00, 1.6038405671E+00, 8.4506705028E-01],
	[2.3070000000E+04, 1.3668646753E+01, 5.0320824354E+00, 2.8461593777E+00, 1.6045294331E+00, 8.4514163428E-01],
	[2.3075000000E+04, 1.3673211902E+01, 5.0320049625E+00, 2.8481541805E+00, 1.6052182758E+00, 8.4521618536E-01],
	[2.3080000000E+04, 1.3677777587E+01, 5.0319275075E+00, 2.8501499482E+00, 1.6059070951E+00, 8.4529070353E-01],
	[2.3085000000E+04, 1.3682343807E+01, 5.0318500705E+00, 2.8521466810E+00, 1.6065958908E+00, 8.4536518879E-01],
	[2.3090000000E+04, 1.3686910562E+01, 5.0317726515E+00, 2.8541443791E+00, 1.6072846629E+00, 8.4543964115E-01],
	[2.3095000000E+04, 1.3691477851E+01, 5.0316952505E+00, 2.8561430429E+00, 1.6079734111E+00, 8.4551406062E-01],
	[2.3100000000E+04, 1.3696045676E+01, 5.0316178673E+00, 2.8581426725E+00, 1.6086621354E+00, 8.4558844721E-01],
	[2.3105000000E+04, 1.3700614036E+01, 5.0315405022E+00, 2.8601432683E+00, 1.6093508356E+00, 8.4566280093E-01],
	[2.3110000000E+04, 1.3705182930E+01, 5.0314631549E+00, 2.8621448305E+00, 1.6100395116E+00, 8.4573712179E-01],
	[2.3115000000E+04, 1.3709752359E+01, 5.0313858256E+00, 2.8641473593E+00, 1.6107281633E+00, 8.4581140979E-01],
	[2.3120000000E+04, 1.3714322323E+01, 5.0313085142E+00, 2.8661508550E+00, 1.6114167904E+00, 8.4588566495E-01],
	[2.3125000000E+04, 1.3718892821E+01, 5.0312312206E+00, 2.8681553178E+00, 1.6121053930E+00, 8.4595988727E-01],
	[2.3130000000E+04, 1.3723463854E+01, 5.0311539450E+00, 2.8701607481E+00, 1.6127939707E+00, 8.4603407676E-01],
	[2.3135000000E+04, 1.3728035421E+01, 5.0310766873E+00, 2.8721671461E+00, 1.6134825236E+00, 8.4610823343E-01],
	[2.3140000000E+04, 1.3732607523E+01, 5.0309994475E+00, 2.8741745120E+00, 1.6141710514E+00, 8.4618235729E-01],
	[2.3145000000E+04, 1.3737180160E+01, 5.0309222255E+00, 2.8761828461E+00, 1.6148595541E+00, 8.4625644834E-01],
	[2.3150000000E+04, 1.3741753331E+01, 5.0308450214E+00, 2.8781921486E+00, 1.6155480315E+00, 8.4633050660E-01],
	[2.3155000000E+04, 1.3746327036E+01, 5.0307678351E+00, 2.8802024198E+00, 1.6162364835E+00, 8.4640453208E-01],
	[2.3160000000E+04, 1.3750901275E+01, 5.0306906667E+00, 2.8822136600E+00, 1.6169249099E+00, 8.4647852478E-01],
	[2.3165000000E+04, 1.3755481237E+01, 5.0306144929E+00, 2.8842258694E+00, 1.6176134833E+00, 8.4655248471E-01],
	[2.3170000000E+04, 1.3760077539E+01, 5.0305413102E+00, 2.8862390483E+00, 1.6183025574E+00, 8.4662641187E-01],
	[2.3175000000E+04, 1.3764674385E+01, 5.0304681444E+00, 2.8882531970E+00, 1.6189916064E+00, 8.4670030629E-01],
	[2.3180000000E+04, 1.3769271774E+01, 5.0303949954E+00, 2.8902683156E+00, 1.6196806302E+00, 8.4677416797E-01],
	[2.3185000000E+04, 1.3773869707E+01, 5.0303218633E+00, 2.8922844044E+00, 1.6203696286E+00, 8.4684799691E-01],
	[2.3190000000E+04, 1.3778468183E+01, 5.0302487480E+00, 2.8943014638E+00, 1.6210586014E+00, 8.4692179313E-01],
	[2.3195000000E+04, 1.3783067202E+01, 5.0301756496E+00, 2.8963194939E+00, 1.6217475487E+00, 8.4699555663E-01],
	[2.3200000000E+04, 1.3787666765E+01, 5.0301025679E+00, 2.8983384951E+00, 1.6224364701E+00, 8.4706928743E-01],
	[2.3205000000E+04, 1.3792266871E+01, 5.0300295031E+00, 2.9003584675E+00, 1.6231253656E+00, 8.4714298552E-01],
	[2.3210000000E+04, 1.3796867520E+01, 5.0299564551E+00, 2.9023794115E+00, 1.6238142351E+00, 8.4721665093E-01],
	[2.3215000000E+04, 1.3801468712E+01, 5.0298834239E+00, 2.9044013272E+00, 1.6245030784E+00, 8.4729028365E-01],
	[2.3220000000E+04, 1.3806070447E+01, 5.0298104094E+00, 2.9064242150E+00, 1.6251918954E+00, 8.4736388370E-01],
	[2.3225000000E+04, 1.3810672726E+01, 5.0297374117E+00, 2.9084480751E+00, 1.6258806859E+00, 8.4743745109E-01],
	[2.3230000000E+04, 1.3815275547E+01, 5.0296644309E+00, 2.9104729078E+00, 1.6265694499E+00, 8.4751098583E-01],
	[2.3235000000E+04, 1.3819878911E+01, 5.0295914667E+00, 2.9124987133E+00, 1.6272581871E+00, 8.4758448792E-01],
	[2.3240000000E+04, 1.3824482819E+01, 5.0295185194E+00, 2.9145254919E+00, 1.6279468975E+00, 8.4765795737E-01],
	[2.3245000000E+04, 1.3829087269E+01, 5.0294455887E+00, 2.9165532438E+00, 1.6286355809E+00, 8.4773139420E-01],
	[2.3250000000E+04, 1.3833692261E+01, 5.0293726749E+00, 2.9185819693E+00, 1.6293242372E+00, 8.4780479840E-01],
	[2.3255000000E+04, 1.3838297797E+01, 5.0292997777E+00, 2.9206116687E+00, 1.6300128663E+00, 8.4787817000E-01],
	[2.3260000000E+04, 1.3842903875E+01, 5.0292268973E+00, 2.9226423421E+00, 1.6307014680E+00, 8.4795150899E-01],
	[2.3265000000E+04, 1.3847510496E+01, 5.0291540336E+00, 2.9246739900E+00, 1.6313900421E+00, 8.4802481540E-01],
	[2.3270000000E+04, 1.3852117659E+01, 5.0290811866E+00, 2.9267066124E+00, 1.6320785886E+00, 8.4809808922E-01],
	[2.3275000000E+04, 1.3856725365E+01, 5.0290083564E+00, 2.9287402098E+00, 1.6327671074E+00, 8.4817133046E-01],
	[2.3280000000E+04, 1.3861333613E+01, 5.0289355428E+00, 2.9307747822E+00, 1.6334555982E+00, 8.4824453914E-01],
	[2.3285000000E+04, 1.3865942404E+01, 5.0288627459E+00, 2.9328103301E+00, 1.6341440610E+00, 8.4831771526E-01],
	[2.3290000000E+04, 1.3870551737E+01, 5.0287899657E+00, 2.9348468536E+00, 1.6348324956E+00, 8.4839085884E-01],
	[2.3295000000E+04, 1.3875161613E+01, 5.0287172022E+00, 2.9368843531E+00, 1.6355209019E+00, 8.4846396988E-01],
	[2.3300000000E+04, 1.3879772030E+01, 5.0286444553E+00, 2.9389228287E+00, 1.6362092798E+00, 8.4853704839E-01],
	[2.3305000000E+04, 1.3884382990E+01, 5.0285717251E+00, 2.9409622807E+00, 1.6368976291E+00, 8.4861009438E-01],
	[2.3310000000E+04, 1.3888994492E+01, 5.0284990116E+00, 2.9430027094E+00, 1.6375859497E+00, 8.4868310786E-01],
	[2.3315000000E+04, 1.3893606536E+01, 5.0284263147E+00, 2.9450441151E+00, 1.6382742415E+00, 8.4875608883E-01],
	[2.3320000000E+04, 1.3898219122E+01, 5.0283536344E+00, 2.9470864980E+00, 1.6389625043E+00, 8.4882903731E-01],
	[2.3325000000E+04, 1.3902832250E+01, 5.0282809708E+00, 2.9491298583E+00, 1.6396507380E+00, 8.4890195331E-01],
	[2.3330000000E+04, 1.3907445920E+01, 5.0282083238E+00, 2.9511741963E+00, 1.6403389425E+00, 8.4897483684E-01],
	[2.3335000000E+04, 1.3912060132E+01, 5.0281356934E+00, 2.9532195123E+00, 1.6410271176E+00, 8.4904768789E-01],
	[2.3340000000E+04, 1.3916674886E+01, 5.0280630797E+00, 2.9552658066E+00, 1.6417152633E+00, 8.4912050650E-01],
	[2.3345000000E+04, 1.3921290182E+01, 5.0279904825E+00, 2.9573130793E+00, 1.6424033793E+00, 8.4919329265E-01],
	[2.3350000000E+04, 1.3925906019E+01, 5.0279179019E+00, 2.9593613308E+00, 1.6430914655E+00, 8.4926604637E-01],
	[2.3355000000E+04, 1.3930522398E+01, 5.0278453379E+00, 2.9614105612E+00, 1.6437795219E+00, 8.4933876765E-01],
	[2.3360000000E+04, 1.3935139318E+01, 5.0277727905E+00, 2.9634607710E+00, 1.6444675483E+00, 8.4941145652E-01],
	[2.3365000000E+04, 1.3939756780E+01, 5.0277002597E+00, 2.9655119602E+00, 1.6451555445E+00, 8.4948411298E-01],
	[2.3370000000E+04, 1.3944374784E+01, 5.0276277454E+00, 2.9675641293E+00, 1.6458435104E+00, 8.4955673703E-01],
	[2.3375000000E+04, 1.3948993329E+01, 5.0275552477E+00, 2.9696172783E+00, 1.6465314460E+00, 8.4962932869E-01],
	[2.3380000000E+04, 1.3953612415E+01, 5.0274827666E+00, 2.9716714077E+00, 1.6472193509E+00, 8.4970188797E-01],
	[2.3385000000E+04, 1.3958232043E+01, 5.0274103019E+00, 2.9737265176E+00, 1.6479072253E+00, 8.4977441487E-01],
	[2.3390000000E+04, 1.3962852212E+01, 5.0273378539E+00, 2.9757826083E+00, 1.6485950688E+00, 8.4984690941E-01],
	[2.3395000000E+04, 1.3967472923E+01, 5.0272654223E+00, 2.9778396801E+00, 1.6492828814E+00, 8.4991937160E-01],
	[2.3400000000E+04, 1.3972094174E+01, 5.0271930073E+00, 2.9798977332E+00, 1.6499706629E+00, 8.4999180144E-01],
	[2.3405000000E+04, 1.3976715967E+01, 5.0271206088E+00, 2.9819567679E+00, 1.6506584132E+00, 8.5006419894E-01],
	[2.3410000000E+04, 1.3981338301E+01, 5.0270482268E+00, 2.9840167844E+00, 1.6513461323E+00, 8.5013656411E-01],
	[2.3415000000E+04, 1.3985961176E+01, 5.0269758613E+00, 2.9860777831E+00, 1.6520338198E+00, 8.5020889697E-01],
	[2.3420000000E+04, 1.3990584592E+01, 5.0269035123E+00, 2.9881397641E+00, 1.6527214758E+00, 8.5028119751E-01],
	[2.3425000000E+04, 1.3995208548E+01, 5.0268311797E+00, 2.9902027276E+00, 1.6534091001E+00, 8.5035346576E-01],
	[2.3430000000E+04, 1.3999833046E+01, 5.0267588637E+00, 2.9922666741E+00, 1.6540966925E+00, 8.5042570172E-01],
	[2.3435000000E+04, 1.4004458085E+01, 5.0266865641E+00, 2.9943316037E+00, 1.6547842530E+00, 8.5049790539E-01],
	[2.3440000000E+04, 1.4009083664E+01, 5.0266142810E+00, 2.9963975167E+00, 1.6554717814E+00, 8.5057007680E-01],
	[2.3445000000E+04, 1.4013709784E+01, 5.0265420143E+00, 2.9984644133E+00, 1.6561592775E+00, 8.5064221594E-01],
	[2.3450000000E+04, 1.4018336445E+01, 5.0264697641E+00, 3.0005322938E+00, 1.6568467413E+00, 8.5071432282E-01],
	[2.3455000000E+04, 1.4022963646E+01, 5.0263975303E+00, 3.0026011585E+00, 1.6575341725E+00, 8.5078639747E-01],
	[2.3460000000E+04, 1.4027591388E+01, 5.0263253130E+00, 3.0046710076E+00, 1.6582215712E+00, 8.5085843988E-01],
	[2.3465000000E+04, 1.4032219670E+01, 5.0262531121E+00, 3.0067418414E+00, 1.6589089371E+00, 8.5093045007E-01],
	[2.3470000000E+04, 1.4036848493E+01, 5.0261809276E+00, 3.0088136602E+00, 1.6595962702E+00, 8.5100242804E-01],
	[2.3475000000E+04, 1.4041477856E+01, 5.0261087595E+00, 3.0108864641E+00, 1.6602835702E+00, 8.5107437380E-01],
	[2.3480000000E+04, 1.4046107760E+01, 5.0260366079E+00, 3.0129602534E+00, 1.6609708371E+00, 8.5114628737E-01],
	[2.3485000000E+04, 1.4050738204E+01, 5.0259644726E+00, 3.0150350285E+00, 1.6616580707E+00, 8.5121816875E-01],
	[2.3490000000E+04, 1.4055369188E+01, 5.0258923537E+00, 3.0171107895E+00, 1.6623452710E+00, 8.5129001795E-01],
	[2.3495000000E+04, 1.4060000713E+01, 5.0258202512E+00, 3.0191875368E+00, 1.6630324377E+00, 8.5136183499E-01],
	[2.3500000000E+04, 1.4064632777E+01, 5.0257481651E+00, 3.0212652706E+00, 1.6637195707E+00, 8.5143361987E-01],
	[2.3505000000E+04, 1.4069265382E+01, 5.0256760953E+00, 3.0233439910E+00, 1.6644066700E+00, 8.5150537259E-01],
	[2.3510000000E+04, 1.4073898527E+01, 5.0256040419E+00, 3.0254236985E+00, 1.6650937354E+00, 8.5157709318E-01],
	[2.3515000000E+04, 1.4078532212E+01, 5.0255320049E+00, 3.0275043933E+00, 1.6657807667E+00, 8.5164878164E-01],
	[2.3520000000E+04, 1.4083166436E+01, 5.0254599842E+00, 3.0295860755E+00, 1.6664677639E+00, 8.5172043798E-01],
	[2.3525000000E+04, 1.4087801201E+01, 5.0253879799E+00, 3.0316687456E+00, 1.6671547268E+00, 8.5179206221E-01],
	[2.3530000000E+04, 1.4092436506E+01, 5.0253159919E+00, 3.0337524037E+00, 1.6678416553E+00, 8.5186365433E-01],
	[2.3535000000E+04, 1.4097072350E+01, 5.0252440202E+00, 3.0358370500E+00, 1.6685285492E+00, 8.5193521437E-01],
	[2.3540000000E+04, 1.4101722876E+01, 5.0251746596E+00, 3.0379226849E+00, 1.6692158929E+00, 8.5200674232E-01],
	[2.3545000000E+04, 1.4106381035E+01, 5.0251066147E+00, 3.0400093086E+00, 1.6699034452E+00, 8.5207823820E-01],
	[2.3550000000E+04, 1.4111039744E+01, 5.0250385852E+00, 3.0420969214E+00, 1.6705909635E+00, 8.5214970201E-01],
	[2.3555000000E+04, 1.4115699002E+01, 5.0249705710E+00, 3.0441855235E+00, 1.6712784475E+00, 8.5222113378E-01],
	[2.3560000000E+04, 1.4120358808E+01, 5.0249025722E+00, 3.0462751152E+00, 1.6719658973E+00, 8.5229253350E-01],
	[2.3565000000E+04, 1.4125019164E+01, 5.0248345887E+00, 3.0483656967E+00, 1.6726533125E+00, 8.5236390118E-01],
	[2.3570000000E+04, 1.4129680069E+01, 5.0247666206E+00, 3.0504572683E+00, 1.6733406932E+00, 8.5243523684E-01],
	[2.3575000000E+04, 1.4134341522E+01, 5.0246986678E+00, 3.0525498303E+00, 1.6740280392E+00, 8.5250654049E-01],
	[2.3580000000E+04, 1.4139003524E+01, 5.0246307303E+00, 3.0546433829E+00, 1.6747153503E+00, 8.5257781213E-01],
	[2.3585000000E+04, 1.4143666075E+01, 5.0245628082E+00, 3.0567379264E+00, 1.6754026265E+00, 8.5264905177E-01],
	[2.3590000000E+04, 1.4148329175E+01, 5.0244949013E+00, 3.0588334609E+00, 1.6760898676E+00, 8.5272025943E-01],
	[2.3595000000E+04, 1.4152992823E+01, 5.0244270098E+00, 3.0609299869E+00, 1.6767770735E+00, 8.5279143511E-01],
	[2.3600000000E+04, 1.4157657020E+01, 5.0243591336E+00, 3.0630275046E+00, 1.6774642440E+00, 8.5286257883E-01],
	[2.3605000000E+04, 1.4162321766E+01, 5.0242912727E+00, 3.0651260141E+00, 1.6781513790E+00, 8.5293369059E-01],
	[2.3610000000E+04, 1.4166987060E+01, 5.0242234271E+00, 3.0672255158E+00, 1.6788384784E+00, 8.5300477040E-01],
	[2.3615000000E+04, 1.4171652902E+01, 5.0241555967E+00, 3.0693260099E+00, 1.6795255421E+00, 8.5307581827E-01],
	[2.3620000000E+04, 1.4176319293E+01, 5.0240877816E+00, 3.0714274967E+00, 1.6802125700E+00, 8.5314683422E-01],
	[2.3625000000E+04, 1.4180986232E+01, 5.0240199818E+00, 3.0735299765E+00, 1.6808995619E+00, 8.5321781825E-01],
	[2.3630000000E+04, 1.4185653720E+01, 5.0239521973E+00, 3.0756334494E+00, 1.6815865176E+00, 8.5328877037E-01],
	[2.3635000000E+04, 1.4190321756E+01, 5.0238844280E+00, 3.0777379158E+00, 1.6822734372E+00, 8.5335969060E-01],
	[2.3640000000E+04, 1.4194990340E+01, 5.0238166740E+00, 3.0798433759E+00, 1.6829603203E+00, 8.5343057893E-01],
	[2.3645000000E+04, 1.4199659472E+01, 5.0237489352E+00, 3.0819498300E+00, 1.6836471670E+00, 8.5350143539E-01],
	[2.3650000000E+04, 1.4204329152E+01, 5.0236812116E+00, 3.0840572783E+00, 1.6843339771E+00, 8.5357225998E-01],
	[2.3655000000E+04, 1.4208999380E+01, 5.0236135033E+00, 3.0861657211E+00, 1.6850207504E+00, 8.5364305270E-01],
	[2.3660000000E+04, 1.4213670156E+01, 5.0235458102E+00, 3.0882751587E+00, 1.6857074869E+00, 8.5371381358E-01],
	[2.3665000000E+04, 1.4218341480E+01, 5.0234781323E+00, 3.0903855912E+00, 1.6863941864E+00, 8.5378454262E-01],
	[2.3670000000E+04, 1.4223013352E+01, 5.0234104696E+00, 3.0924970190E+00, 1.6870808488E+00, 8.5385523983E-01],
	[2.3675000000E+04, 1.4227685772E+01, 5.0233428221E+00, 3.0946094424E+00, 1.6877674739E+00, 8.5392590522E-01],
	[2.3680000000E+04, 1.4232358740E+01, 5.0232751898E+00, 3.0967228615E+00, 1.6884540617E+00, 8.5399653880E-01],
	[2.3685000000E+04, 1.4237032255E+01, 5.0232075727E+00, 3.0988372767E+00, 1.6891406119E+00, 8.5406714059E-01],
	[2.3690000000E+04, 1.4241706318E+01, 5.0231399708E+00, 3.1009526882E+00, 1.6898271246E+00, 8.5413771058E-01],
	[2.3695000000E+04, 1.4246380928E+01, 5.0230723841E+00, 3.1030690962E+00, 1.6905135995E+00, 8.5420824879E-01],
	[2.3700000000E+04, 1.4251056087E+01, 5.0230048125E+00, 3.1051865010E+00, 1.6912000365E+00, 8.5427875523E-01],
	[2.3705000000E+04, 1.4255731792E+01, 5.0229372561E+00, 3.1073049030E+00, 1.6918864356E+00, 8.5434922991E-01],
	[2.3710000000E+04, 1.4260408045E+01, 5.0228697148E+00, 3.1094243022E+00, 1.6925727965E+00, 8.5441967284E-01],
	[2.3715000000E+04, 1.4265084846E+01, 5.0228021887E+00, 3.1115446991E+00, 1.6932591192E+00, 8.5449008403E-01],
	[2.3720000000E+04, 1.4269762194E+01, 5.0227346778E+00, 3.1136660938E+00, 1.6939454035E+00, 8.5456046349E-01],
	[2.3725000000E+04, 1.4274440089E+01, 5.0226671820E+00, 3.1157884866E+00, 1.6946316493E+00, 8.5463081122E-01],
	[2.3730000000E+04, 1.4279118532E+01, 5.0225997013E+00, 3.1179118778E+00, 1.6953178565E+00, 8.5470112725E-01],
	[2.3735000000E+04, 1.4283797522E+01, 5.0225322357E+00, 3.1200362676E+00, 1.6960040250E+00, 8.5477141158E-01],
	[2.3740000000E+04, 1.4288477058E+01, 5.0224647853E+00, 3.1221616563E+00, 1.6966901546E+00, 8.5484166421E-01],
	[2.3745000000E+04, 1.4293157142E+01, 5.0223973499E+00, 3.1242880441E+00, 1.6973762452E+00, 8.5491188517E-01],
	[2.3750000000E+04, 1.4297837773E+01, 5.0223299297E+00, 3.1264154313E+00, 1.6980622967E+00, 8.5498207445E-01],
	[2.3755000000E+04, 1.4302518952E+01, 5.0222625245E+00, 3.1285438182E+00, 1.6987483089E+00, 8.5505223208E-01],
	[2.3760000000E+04, 1.4307200677E+01, 5.0221951345E+00, 3.1306732051E+00, 1.6994342818E+00, 8.5512235805E-01],
	[2.3765000000E+04, 1.4311882949E+01, 5.0221277595E+00, 3.1328035921E+00, 1.7001202152E+00, 8.5519245239E-01],
	[2.3770000000E+04, 1.4316565767E+01, 5.0220603996E+00, 3.1349349795E+00, 1.7008061090E+00, 8.5526251509E-01],
	[2.3775000000E+04, 1.4321249133E+01, 5.0219930548E+00, 3.1370673676E+00, 1.7014919630E+00, 8.5533254617E-01],
	[2.3780000000E+04, 1.4325933045E+01, 5.0219257251E+00, 3.1392007567E+00, 1.7021777772E+00, 8.5540254564E-01],
	[2.3785000000E+04, 1.4330617504E+01, 5.0218584104E+00, 3.1413351470E+00, 1.7028635514E+00, 8.5547251351E-01],
	[2.3790000000E+04, 1.4335302510E+01, 5.0217911107E+00, 3.1434705388E+00, 1.7035492855E+00, 8.5554244979E-01],
	[2.3795000000E+04, 1.4339988062E+01, 5.0217238261E+00, 3.1456069323E+00, 1.7042349793E+00, 8.5561235449E-01],
	[2.3800000000E+04, 1.4344674161E+01, 5.0216565566E+00, 3.1477443278E+00, 1.7049206328E+00, 8.5568222762E-01],
	[2.3805000000E+04, 1.4349360806E+01, 5.0215893020E+00, 3.1498827256E+00, 1.7056062458E+00, 8.5575206919E-01],
	[2.3810000000E+04, 1.4354047998E+01, 5.0215220625E+00, 3.1520221259E+00, 1.7062918183E+00, 8.5582187921E-01],
	[2.3815000000E+04, 1.4358735736E+01, 5.0214548381E+00, 3.1541625289E+00, 1.7069773500E+00, 8.5589165768E-01],
	[2.3820000000E+04, 1.4363424021E+01, 5.0213876286E+00, 3.1563039349E+00, 1.7076628408E+00, 8.5596140461E-01],
	[2.3825000000E+04, 1.4368112852E+01, 5.0213204341E+00, 3.1584463443E+00, 1.7083482907E+00, 8.5603112002E-01],
	[2.3830000000E+04, 1.4372802229E+01, 5.0212532546E+00, 3.1605897572E+00, 1.7090336995E+00, 8.5610080390E-01],
	[2.3835000000E+04, 1.4377492152E+01, 5.0211860902E+00, 3.1627341739E+00, 1.7097190670E+00, 8.5617045627E-01],
	[2.3840000000E+04, 1.4382182621E+01, 5.0211189407E+00, 3.1648795946E+00, 1.7104043933E+00, 8.5624007714E-01],
	[2.3845000000E+04, 1.4386873637E+01, 5.0210518062E+00, 3.1670260197E+00, 1.7110896780E+00, 8.5630966652E-01],
	[2.3850000000E+04, 1.4391565198E+01, 5.0209846866E+00, 3.1691734493E+00, 1.7117749212E+00, 8.5637922441E-01],
	[2.3855000000E+04, 1.4396257306E+01, 5.0209175821E+00, 3.1713218838E+00, 1.7124601226E+00, 8.5644875082E-01],
	[2.3860000000E+04, 1.4400949959E+01, 5.0208504924E+00, 3.1734713234E+00, 1.7131452823E+00, 8.5651824576E-01],
	[2.3865000000E+04, 1.4405643158E+01, 5.0207834178E+00, 3.1756217684E+00, 1.7138304000E+00, 8.5658770924E-01],
	[2.3870000000E+04, 1.4410336903E+01, 5.0207163581E+00, 3.1777732189E+00, 1.7145154756E+00, 8.5665714127E-01],
	[2.3875000000E+04, 1.4415031194E+01, 5.0206493133E+00, 3.1799256754E+00, 1.7152005090E+00, 8.5672654186E-01],
	[2.3880000000E+04, 1.4419726031E+01, 5.0205822835E+00, 3.1820791379E+00, 1.7158855001E+00, 8.5679591101E-01],
	[2.3885000000E+04, 1.4424421413E+01, 5.0205152686E+00, 3.1842336069E+00, 1.7165704487E+00, 8.5686524874E-01],
	[2.3890000000E+04, 1.4429117341E+01, 5.0204482686E+00, 3.1863890825E+00, 1.7172553548E+00, 8.5693455504E-01],
	[2.3895000000E+04, 1.4433813815E+01, 5.0203812835E+00, 3.1885455650E+00, 1.7179402182E+00, 8.5700382994E-01],
	[2.3900000000E+04, 1.4438510834E+01, 5.0203143133E+00, 3.1907030547E+00, 1.7186250388E+00, 8.5707307344E-01],
	[2.3905000000E+04, 1.4443208398E+01, 5.0202473581E+00, 3.1928615518E+00, 1.7193098164E+00, 8.5714228554E-01],
	[2.3910000000E+04, 1.4447906508E+01, 5.0201804177E+00, 3.1950210567E+00, 1.7199945510E+00, 8.5721146627E-01],
	[2.3915000000E+04, 1.4452605163E+01, 5.0201134922E+00, 3.1971815694E+00, 1.7206792424E+00, 8.5728061561E-01],
	[2.3920000000E+04, 1.4457323356E+01, 5.0200499785E+00, 3.1993430904E+00, 1.7213645592E+00, 8.5734973359E-01],
	[2.3925000000E+04, 1.4462044583E+01, 5.0199869222E+00, 3.2015056198E+00, 1.7220499207E+00, 8.5741882022E-01],
	[2.3930000000E+04, 1.4466766364E+01, 5.0199238799E+00, 3.2036691580E+00, 1.7227352394E+00, 8.5748787549E-01],
	[2.3935000000E+04, 1.4471488699E+01, 5.0198608515E+00, 3.2058337051E+00, 1.7234205154E+00, 8.5755689943E-01],
	[2.3940000000E+04, 1.4476211590E+01, 5.0197978370E+00, 3.2079992615E+00, 1.7241057485E+00, 8.5762589203E-01],
	[2.3945000000E+04, 1.4480935034E+01, 5.0197348366E+00, 3.2101658274E+00, 1.7247909385E+00, 8.5769485331E-01],
	[2.3950000000E+04, 1.4485659034E+01, 5.0196718500E+00, 3.2123334030E+00, 1.7254760853E+00, 8.5776378328E-01],
	[2.3955000000E+04, 1.4490383588E+01, 5.0196088774E+00, 3.2145019887E+00, 1.7261611889E+00, 8.5783268194E-01],
	[2.3960000000E+04, 1.4495108696E+01, 5.0195459188E+00, 3.2166715846E+00, 1.7268462490E+00, 8.5790154931E-01],
	[2.3965000000E+04, 1.4499834359E+01, 5.0194829740E+00, 3.2188421911E+00, 1.7275312657E+00, 8.5797038539E-01],
	[2.3970000000E+04, 1.4504560576E+01, 5.0194200432E+00, 3.2210138084E+00, 1.7282162387E+00, 8.5803919019E-01],
	[2.3975000000E+04, 1.4509287347E+01, 5.0193571263E+00, 3.2231864368E+00, 1.7289011679E+00, 8.5810796372E-01],
	[2.3980000000E+04, 1.4514014672E+01, 5.0192942233E+00, 3.2253600764E+00, 1.7295860532E+00, 8.5817670599E-01],
	[2.3985000000E+04, 1.4518742552E+01, 5.0192313342E+00, 3.2275347277E+00, 1.7302708946E+00, 8.5824541701E-01],
	[2.3990000000E+04, 1.4523470986E+01, 5.0191684590E+00, 3.2297103907E+00, 1.7309556918E+00, 8.5831409678E-01],
	[2.3995000000E+04, 1.4528199974E+01, 5.0191055977E+00, 3.2318870659E+00, 1.7316404447E+00, 8.5838274532E-01],
	[2.4000000000E+04, 1.4532929515E+01, 5.0190427503E+00, 3.2340647534E+00, 1.7323251533E+00, 8.5845136264E-01],
	[2.4005000000E+04, 1.4537659611E+01, 5.0189799167E+00, 3.2362434535E+00, 1.7330098174E+00, 8.5851994873E-01],
	[2.4010000000E+04, 1.4542390261E+01, 5.0189170971E+00, 3.2384231666E+00, 1.7336944369E+00, 8.5858850362E-01],
	[2.4015000000E+04, 1.4547121464E+01, 5.0188542913E+00, 3.2406038927E+00, 1.7343790117E+00, 8.5865702731E-01],
	[2.4020000000E+04, 1.4551853222E+01, 5.0187914993E+00, 3.2427856322E+00, 1.7350635416E+00, 8.5872551981E-01],
	[2.4025000000E+04, 1.4556585533E+01, 5.0187287212E+00, 3.2449683854E+00, 1.7357480266E+00, 8.5879398113E-01],
	[2.4030000000E+04, 1.4561318398E+01, 5.0186659570E+00, 3.2471521525E+00, 1.7364324664E+00, 8.5886241128E-01],
	[2.4035000000E+04, 1.4566051816E+01, 5.0186032066E+00, 3.2493369337E+00, 1.7371168611E+00, 8.5893081026E-01],
	[2.4040000000E+04, 1.4570785788E+01, 5.0185404700E+00, 3.2515227294E+00, 1.7378012104E+00, 8.5899917809E-01],
	[2.4045000000E+04, 1.4575520314E+01, 5.0184777473E+00, 3.2537095398E+00, 1.7384855143E+00, 8.5906751478E-01],
	[2.4050000000E+04, 1.4580255393E+01, 5.0184150384E+00, 3.2558973651E+00, 1.7391697727E+00, 8.5913582032E-01],
	[2.4055000000E+04, 1.4584991026E+01, 5.0183523433E+00, 3.2580862057E+00, 1.7398539853E+00, 8.5920409474E-01],
	[2.4060000000E+04, 1.4589727212E+01, 5.0182896621E+00, 3.2602760617E+00, 1.7405381522E+00, 8.5927233805E-01],
	[2.4065000000E+04, 1.4594463952E+01, 5.0182269946E+00, 3.2624669334E+00, 1.7412222731E+00, 8.5934055024E-01],
	[2.4070000000E+04, 1.4599201244E+01, 5.0181643409E+00, 3.2646588211E+00, 1.7419063480E+00, 8.5940873133E-01],
	[2.4075000000E+04, 1.4603939090E+01, 5.0181017011E+00, 3.2668517251E+00, 1.7425903767E+00, 8.5947688134E-01],
	[2.4080000000E+04, 1.4608677490E+01, 5.0180390750E+00, 3.2690456455E+00, 1.7432743592E+00, 8.5954500026E-01],
	[2.4085000000E+04, 1.4613416442E+01, 5.0179764627E+00, 3.2712405827E+00, 1.7439582953E+00, 8.5961308810E-01],
	[2.4090000000E+04, 1.4618155947E+01, 5.0179138642E+00, 3.2734365370E+00, 1.7446421848E+00, 8.5968114488E-01],
	[2.4095000000E+04, 1.4622896006E+01, 5.0178512794E+00, 3.2756335085E+00, 1.7453260278E+00, 8.5974917061E-01],
	[2.4100000000E+04, 1.4627636618E+01, 5.0177887085E+00, 3.2778314976E+00, 1.7460098239E+00, 8.5981716530E-01],
	[2.4105000000E+04, 1.4632377782E+01, 5.0177261512E+00, 3.2800305045E+00, 1.7466935732E+00, 8.5988512894E-01],
	[2.4110000000E+04, 1.4637119499E+01, 5.0176636078E+00, 3.2822305294E+00, 1.7473772756E+00, 8.5995306156E-01],
	[2.4115000000E+04, 1.4641861770E+01, 5.0176010781E+00, 3.2844315727E+00, 1.7480609308E+00, 8.6002096316E-01],
	[2.4120000000E+04, 1.4646604593E+01, 5.0175385621E+00, 3.2866336345E+00, 1.7487445388E+00, 8.6008883375E-01],
	[2.4125000000E+04, 1.4651347969E+01, 5.0174760599E+00, 3.2888367152E+00, 1.7494280994E+00, 8.6015667334E-01],
	[2.4130000000E+04, 1.4656091897E+01, 5.0174135714E+00, 3.2910408150E+00, 1.7501116126E+00, 8.6022448194E-01],
	[2.4135000000E+04, 1.4660836378E+01, 5.0173510966E+00, 3.2932459341E+00, 1.7507950782E+00, 8.6029225956E-01],
	[2.4140000000E+04, 1.4665581412E+01, 5.0172886355E+00, 3.2954520729E+00, 1.7514784962E+00, 8.6036000620E-01],
	[2.4145000000E+04, 1.4670326999E+01, 5.0172261882E+00, 3.2976592315E+00, 1.7521618663E+00, 8.6042772189E-01],
	[2.4150000000E+04, 1.4675073138E+01, 5.0171637545E+00, 3.2998674103E+00, 1.7528451885E+00, 8.6049540662E-01],
	[2.4155000000E+04, 1.4679819829E+01, 5.0171013346E+00, 3.3020766095E+00, 1.7535284626E+00, 8.6056306040E-01],
	[2.4160000000E+04, 1.4684567073E+01, 5.0170389283E+00, 3.3042868293E+00, 1.7542116886E+00, 8.6063068325E-01],
	[2.4165000000E+04, 1.4689314869E+01, 5.0169765358E+00, 3.3064980701E+00, 1.7548948663E+00, 8.6069827517E-01],
	[2.4170000000E+04, 1.4694063217E+01, 5.0169141569E+00, 3.3087103320E+00, 1.7555779956E+00, 8.6076583618E-01],
	[2.4175000000E+04, 1.4698812118E+01, 5.0168517917E+00, 3.3109236154E+00, 1.7562610764E+00, 8.6083336627E-01],
	[2.4180000000E+04, 1.4703561571E+01, 5.0167894402E+00, 3.3131379205E+00, 1.7569441086E+00, 8.6090086547E-01],
	[2.4185000000E+04, 1.4708311576E+01, 5.0167271024E+00, 3.3153532475E+00, 1.7576270920E+00, 8.6096833378E-01],
	[2.4190000000E+04, 1.4713062133E+01, 5.0166647782E+00, 3.3175695967E+00, 1.7583100265E+00, 8.6103577121E-01],
	[2.4195000000E+04, 1.4717813242E+01, 5.0166024676E+00, 3.3197869685E+00, 1.7589929121E+00, 8.6110317777E-01],
	[2.4200000000E+04, 1.4722564903E+01, 5.0165401708E+00, 3.3220053629E+00, 1.7596757486E+00, 8.6117055347E-01],
	[2.4205000000E+04, 1.4727317116E+01, 5.0164778875E+00, 3.3242247804E+00, 1.7603585358E+00, 8.6123789832E-01],
	[2.4210000000E+04, 1.4732069881E+01, 5.0164156179E+00, 3.3264452211E+00, 1.7610412738E+00, 8.6130521232E-01],
	[2.4215000000E+04, 1.4736823198E+01, 5.0163533619E+00, 3.3286666853E+00, 1.7617239623E+00, 8.6137249549E-01],
	[2.4220000000E+04, 1.4741577067E+01, 5.0162911196E+00, 3.3308891733E+00, 1.7624066012E+00, 8.6143974784E-01],
	[2.4225000000E+04, 1.4746331487E+01, 5.0162288909E+00, 3.3331126853E+00, 1.7630891904E+00, 8.6150696938E-01],
	[2.4230000000E+04, 1.4751086460E+01, 5.0161666757E+00, 3.3353372217E+00, 1.7637717299E+00, 8.6157416010E-01],
	[2.4235000000E+04, 1.4755841984E+01, 5.0161044742E+00, 3.3375627826E+00, 1.7644542194E+00, 8.6164132004E-01],
	[2.4240000000E+04, 1.4760598059E+01, 5.0160422863E+00, 3.3397893683E+00, 1.7651366589E+00, 8.6170844918E-01],
	[2.4245000000E+04, 1.4765354686E+01, 5.0159801120E+00, 3.3420169790E+00, 1.7658190483E+00, 8.6177554755E-01],
	[2.4250000000E+04, 1.4770111864E+01, 5.0159179513E+00, 3.3442456151E+00, 1.7665013874E+00, 8.6184261516E-01],
	[2.4255000000E+04, 1.4774869594E+01, 5.0158558042E+00, 3.3464752769E+00, 1.7671836761E+00, 8.6190965200E-01],
	[2.4260000000E+04, 1.4779627876E+01, 5.0157936706E+00, 3.3487059644E+00, 1.7678659143E+00, 8.6197665810E-01],
	[2.4265000000E+04, 1.4784386709E+01, 5.0157315507E+00, 3.3509376781E+00, 1.7685481020E+00, 8.6204363346E-01],
	[2.4270000000E+04, 1.4789146093E+01, 5.0156694443E+00, 3.3531704182E+00, 1.7692302389E+00, 8.6211057809E-01],
	[2.4275000000E+04, 1.4793906028E+01, 5.0156073514E+00, 3.3554041848E+00, 1.7699123250E+00, 8.6217749200E-01],
	[2.4280000000E+04, 1.4798666514E+01, 5.0155452721E+00, 3.3576389784E+00, 1.7705943601E+00, 8.6224437520E-01],
	[2.4285000000E+04, 1.4803427552E+01, 5.0154832064E+00, 3.3598747992E+00, 1.7712763442E+00, 8.6231122770E-01],
	[2.4290000000E+04, 1.4808189141E+01, 5.0154211542E+00, 3.3621116473E+00, 1.7719582771E+00, 8.6237804951E-01],
	[2.4295000000E+04, 1.4812951281E+01, 5.0153591155E+00, 3.3643495231E+00, 1.7726401587E+00, 8.6244484063E-01],
	[2.4300000000E+04, 1.4817713972E+01, 5.0152970904E+00, 3.3665884269E+00, 1.7733219888E+00, 8.6251160108E-01],
	[2.4305000000E+04, 1.4822496389E+01, 5.0152384220E+00, 3.3688283589E+00, 1.7740044605E+00, 8.6257833088E-01],
	[2.4310000000E+04, 1.4827281910E+01, 5.0151802098E+00, 3.3710693193E+00, 1.7746869732E+00, 8.6264503001E-01],
	[2.4315000000E+04, 1.4832067991E+01, 5.0151220102E+00, 3.3733113084E+00, 1.7753694350E+00, 8.6271169851E-01],
	[2.4320000000E+04, 1.4836854632E+01, 5.0150638232E+00, 3.3755543265E+00, 1.7760518458E+00, 8.6277833637E-01],
	[2.4325000000E+04, 1.4841641834E+01, 5.0150056489E+00, 3.3777983739E+00, 1.7767342055E+00, 8.6284494361E-01],
	[2.4330000000E+04, 1.4846429596E+01, 5.0149474872E+00, 3.3800434507E+00, 1.7774165139E+00, 8.6291152023E-01],
	[2.4335000000E+04, 1.4851217918E+01, 5.0148893381E+00, 3.3822895573E+00, 1.7780987710E+00, 8.6297806625E-01],
	[2.4340000000E+04, 1.4856006800E+01, 5.0148312017E+00, 3.3845366939E+00, 1.7787809766E+00, 8.6304458167E-01],
	[2.4345000000E+04, 1.4860796242E+01, 5.0147730778E+00, 3.3867848608E+00, 1.7794631306E+00, 8.6311106651E-01],
	[2.4350000000E+04, 1.4865586245E+01, 5.0147149666E+00, 3.3890340582E+00, 1.7801452329E+00, 8.6317752077E-01],
	[2.4355000000E+04, 1.4870376807E+01, 5.0146568680E+00, 3.3912842864E+00, 1.7808272834E+00, 8.6324394446E-01],
	[2.4360000000E+04, 1.4875167929E+01, 5.0145987819E+00, 3.3935355457E+00, 1.7815092820E+00, 8.6331033760E-01],
	[2.4365000000E+04, 1.4879959611E+01, 5.0145407085E+00, 3.3957878363E+00, 1.7821912286E+00, 8.6337670019E-01],
	[2.4370000000E+04, 1.4884751853E+01, 5.0144826477E+00, 3.3980411584E+00, 1.7828731230E+00, 8.6344303224E-01],
	[2.4375000000E+04, 1.4889544655E+01, 5.0144245994E+00, 3.4002955124E+00, 1.7835549651E+00, 8.6350933377E-01],
	[2.4380000000E+04, 1.4894338017E+01, 5.0143665637E+00, 3.4025508985E+00, 1.7842367549E+00, 8.6357560477E-01],
	[2.4385000000E+04, 1.4899131938E+01, 5.0143085406E+00, 3.4048073170E+00, 1.7849184922E+00, 8.6364184527E-01],
	[2.4390000000E+04, 1.4903926419E+01, 5.0142505301E+00, 3.4070647681E+00, 1.7856001768E+00, 8.6370805527E-01],
	[2.4395000000E+04, 1.4908721459E+01, 5.0141925321E+00, 3.4093232520E+00, 1.7862818088E+00, 8.6377423479E-01],
	[2.4400000000E+04, 1.4913517059E+01, 5.0141345467E+00, 3.4115827691E+00, 1.7869633879E+00, 8.6384038382E-01],
	[2.4405000000E+04, 1.4918313219E+01, 5.0140765738E+00, 3.4138433196E+00, 1.7876449141E+00, 8.6390650238E-01],
	[2.4410000000E+04, 1.4923109938E+01, 5.0140186135E+00, 3.4161049037E+00, 1.7883263872E+00, 8.6397259049E-01],
	[2.4415000000E+04, 1.4927907216E+01, 5.0139606657E+00, 3.4183675218E+00, 1.7890078071E+00, 8.6403864814E-01],
	[2.4420000000E+04, 1.4932705054E+01, 5.0139027305E+00, 3.4206311741E+00, 1.7896891738E+00, 8.6410467536E-01],
	[2.4425000000E+04, 1.4937503451E+01, 5.0138448077E+00, 3.4228958608E+00, 1.7903704870E+00, 8.6417067214E-01],
	[2.4430000000E+04, 1.4942302407E+01, 5.0137868976E+00, 3.4251615821E+00, 1.7910517468E+00, 8.6423663851E-01],
	[2.4435000000E+04, 1.4947101922E+01, 5.0137289999E+00, 3.4274283385E+00, 1.7917329529E+00, 8.6430257446E-01],
	[2.4440000000E+04, 1.4951901997E+01, 5.0136711147E+00, 3.4296961301E+00, 1.7924141054E+00, 8.6436848002E-01],
	[2.4445000000E+04, 1.4956702631E+01, 5.0136132421E+00, 3.4319649571E+00, 1.7930952039E+00, 8.6443435518E-01],
	[2.4450000000E+04, 1.4961503823E+01, 5.0135553819E+00, 3.4342348199E+00, 1.7937762485E+00, 8.6450019996E-01],
	[2.4455000000E+04, 1.4966305575E+01, 5.0134975343E+00, 3.4365057187E+00, 1.7944572391E+00, 8.6456601438E-01],
	[2.4460000000E+04, 1.4971107886E+01, 5.0134396991E+00, 3.4387776538E+00, 1.7951381754E+00, 8.6463179843E-01],
	[2.4465000000E+04, 1.4975910755E+01, 5.0133818765E+00, 3.4410506253E+00, 1.7958190575E+00, 8.6469755212E-01],
	[2.4470000000E+04, 1.4980714184E+01, 5.0133240663E+00, 3.4433246337E+00, 1.7964998852E+00, 8.6476327548E-01],
	[2.4475000000E+04, 1.4985518171E+01, 5.0132662686E+00, 3.4455996791E+00, 1.7971806583E+00, 8.6482896851E-01],
	[2.4480000000E+04, 1.4990322717E+01, 5.0132084833E+00, 3.4478757618E+00, 1.7978613768E+00, 8.6489463121E-01],
	[2.4485000000E+04, 1.4995127822E+01, 5.0131507106E+00, 3.4501528821E+00, 1.7985420406E+00, 8.6496026361E-01],
	[2.4490000000E+04, 1.4999933485E+01, 5.0130929503E+00, 3.4524310402E+00, 1.7992226495E+00, 8.6502586570E-01],
	[2.4495000000E+04, 1.5004739707E+01, 5.0130352024E+00, 3.4547102364E+00, 1.7999032035E+00, 8.6509143750E-01],
	[2.4500000000E+04, 1.5009546487E+01, 5.0129774670E+00, 3.4569904709E+00, 1.8005837024E+00, 8.6515697901E-01],
	[2.4505000000E+04, 1.5014353826E+01, 5.0129197441E+00, 3.4592717441E+00, 1.8012641461E+00, 8.6522249026E-01],
	[2.4510000000E+04, 1.5019161724E+01, 5.0128620336E+00, 3.4615540561E+00, 1.8019445345E+00, 8.6528797124E-01],
	[2.4515000000E+04, 1.5023970180E+01, 5.0128043355E+00, 3.4638374072E+00, 1.8026248675E+00, 8.6535342198E-01],
	[2.4520000000E+04, 1.5028779194E+01, 5.0127466499E+00, 3.4661217977E+00, 1.8033051450E+00, 8.6541884247E-01],
	[2.4525000000E+04, 1.5033588767E+01, 5.0126889767E+00, 3.4684072279E+00, 1.8039853669E+00, 8.6548423272E-01],
	[2.4530000000E+04, 1.5038398898E+01, 5.0126313159E+00, 3.4706936980E+00, 1.8046655330E+00, 8.6554959276E-01],
	[2.4535000000E+04, 1.5043209587E+01, 5.0125736675E+00, 3.4729812083E+00, 1.8053456433E+00, 8.6561492258E-01],
	[2.4540000000E+04, 1.5048020834E+01, 5.0125160315E+00, 3.4752697590E+00, 1.8060256976E+00, 8.6568022221E-01],
	[2.4545000000E+04, 1.5052832639E+01, 5.0124584079E+00, 3.4775593503E+00, 1.8067056958E+00, 8.6574549164E-01],
	[2.4550000000E+04, 1.5057645003E+01, 5.0124007968E+00, 3.4798499827E+00, 1.8073856379E+00, 8.6581073088E-01],
	[2.4555000000E+04, 1.5062457924E+01, 5.0123431980E+00, 3.4821416562E+00, 1.8080655236E+00, 8.6587593996E-01],
	[2.4560000000E+04, 1.5067271403E+01, 5.0122856116E+00, 3.4844343712E+00, 1.8087453530E+00, 8.6594111887E-01],
	[2.4565000000E+04, 1.5072085441E+01, 5.0122280376E+00, 3.4867281280E+00, 1.8094251259E+00, 8.6600626764E-01],
	[2.4570000000E+04, 1.5076900036E+01, 5.0121704760E+00, 3.4890229267E+00, 1.8101048421E+00, 8.6607138626E-01],
	[2.4575000000E+04, 1.5081715189E+01, 5.0121129268E+00, 3.4913187677E+00, 1.8107845016E+00, 8.6613647475E-01],
	[2.4580000000E+04, 1.5086530900E+01, 5.0120553899E+00, 3.4936156513E+00, 1.8114641042E+00, 8.6620153311E-01],
	[2.4585000000E+04, 1.5091347168E+01, 5.0119978654E+00, 3.4959135776E+00, 1.8121436500E+00, 8.6626656137E-01],
	[2.4590000000E+04, 1.5096163994E+01, 5.0119403532E+00, 3.4982125469E+00, 1.8128231386E+00, 8.6633155952E-01],
	[2.4595000000E+04, 1.5100981378E+01, 5.0118828534E+00, 3.5005125595E+00, 1.8135025701E+00, 8.6639652759E-01],
	[2.4600000000E+04, 1.5105799319E+01, 5.0118253659E+00, 3.5028136157E+00, 1.8141819443E+00, 8.6646146557E-01],
	[2.4605000000E+04, 1.5110617818E+01, 5.0117678908E+00, 3.5051157157E+00, 1.8148612611E+00, 8.6652637348E-01],
	[2.4610000000E+04, 1.5115436875E+01, 5.0117104280E+00, 3.5074188598E+00, 1.8155405204E+00, 8.6659125133E-01],
	[2.4615000000E+04, 1.5120256489E+01, 5.0116529776E+00, 3.5097230483E+00, 1.8162197221E+00, 8.6665609913E-01],
	[2.4620000000E+04, 1.5125076660E+01, 5.0115955395E+00, 3.5120282813E+00, 1.8168988661E+00, 8.6672091689E-01],
	[2.4625000000E+04, 1.5129897388E+01, 5.0115381137E+00, 3.5143345592E+00, 1.8175779522E+00, 8.6678570462E-01],
	[2.4630000000E+04, 1.5134718674E+01, 5.0114807002E+00, 3.5166418822E+00, 1.8182569804E+00, 8.6685046233E-01],
	[2.4635000000E+04, 1.5139540517E+01, 5.0114232990E+00, 3.5189502506E+00, 1.8189359506E+00, 8.6691519003E-01],
	[2.4640000000E+04, 1.5144362918E+01, 5.0113659102E+00, 3.5212596647E+00, 1.8196148626E+00, 8.6697988773E-01],
	[2.4645000000E+04, 1.5149185875E+01, 5.0113085336E+00, 3.5235701247E+00, 1.8202937164E+00, 8.6704455544E-01],
	[2.4650000000E+04, 1.5154009389E+01, 5.0112511694E+00, 3.5258816308E+00, 1.8209725118E+00, 8.6710919317E-01],
	[2.4655000000E+04, 1.5158833461E+01, 5.0111938174E+00, 3.5281941834E+00, 1.8216512487E+00, 8.6717380093E-01],
	[2.4660000000E+04, 1.5163658090E+01, 5.0111364777E+00, 3.5305077826E+00, 1.8223299270E+00, 8.6723837873E-01],
	[2.4665000000E+04, 1.5168483275E+01, 5.0110791503E+00, 3.5328224288E+00, 1.8230085466E+00, 8.6730292658E-01],
	[2.4670000000E+04, 1.5173309017E+01, 5.0110218352E+00, 3.5351381222E+00, 1.8236871075E+00, 8.6736744449E-01],
	[2.4675000000E+04, 1.5178135317E+01, 5.0109645323E+00, 3.5374548631E+00, 1.8243656094E+00, 8.6743193248E-01],
	[2.4680000000E+04, 1.5182962173E+01, 5.0109072417E+00, 3.5397726517E+00, 1.8250440523E+00, 8.6749639055E-01],
	[2.4685000000E+04, 1.5187789585E+01, 5.0108499634E+00, 3.5420914883E+00, 1.8257224360E+00, 8.6756081871E-01],
	[2.4690000000E+04, 1.5192617555E+01, 5.0107926973E+00, 3.5444113732E+00, 1.8264007606E+00, 8.6762521697E-01],
	[2.4695000000E+04, 1.5197460178E+01, 5.0107378393E+00, 3.5467323066E+00, 1.8270795480E+00, 8.6768958535E-01],
	[2.4700000000E+04, 1.5202311238E+01, 5.0106843311E+00, 3.5490542887E+00, 1.8277585685E+00, 8.6775392384E-01],
	[2.4705000000E+04, 1.5207162865E+01, 5.0106308342E+00, 3.5513773199E+00, 1.8284375302E+00, 8.6781823248E-01],
	[2.4710000000E+04, 1.5212015057E+01, 5.0105773488E+00, 3.5537014004E+00, 1.8291164331E+00, 8.6788251125E-01],
	[2.4715000000E+04, 1.5216867816E+01, 5.0105238747E+00, 3.5560265305E+00, 1.8297952771E+00, 8.6794676018E-01],
	[2.4720000000E+04, 1.5221721141E+01, 5.0104704121E+00, 3.5583527104E+00, 1.8304740621E+00, 8.6801097927E-01],
	[2.4725000000E+04, 1.5226575031E+01, 5.0104169608E+00, 3.5606799403E+00, 1.8311527879E+00, 8.6807516854E-01],
	[2.4730000000E+04, 1.5231429488E+01, 5.0103635209E+00, 3.5630082206E+00, 1.8318314545E+00, 8.6813932800E-01],
	[2.4735000000E+04, 1.5236284510E+01, 5.0103100923E+00, 3.5653375515E+00, 1.8325100617E+00, 8.6820345764E-01],
	[2.4740000000E+04, 1.5241140098E+01, 5.0102566752E+00, 3.5676679333E+00, 1.8331886095E+00, 8.6826755750E-01],
	[2.4745000000E+04, 1.5245996251E+01, 5.0102032694E+00, 3.5699993662E+00, 1.8338670977E+00, 8.6833162757E-01],
	[2.4750000000E+04, 1.5250852971E+01, 5.0101498749E+00, 3.5723318505E+00, 1.8345455263E+00, 8.6839566787E-01],
	[2.4755000000E+04, 1.5255710256E+01, 5.0100964918E+00, 3.5746653864E+00, 1.8352238951E+00, 8.6845967840E-01],
	[2.4760000000E+04, 1.5260568106E+01, 5.0100431201E+00, 3.5769999743E+00, 1.8359022039E+00, 8.6852365918E-01],
	[2.4765000000E+04, 1.5265426522E+01, 5.0099897597E+00, 3.5793356143E+00, 1.8365804528E+00, 8.6858761022E-01],
	[2.4770000000E+04, 1.5270285504E+01, 5.0099364107E+00, 3.5816723068E+00, 1.8372586416E+00, 8.6865153152E-01],
	[2.4775000000E+04, 1.5275145051E+01, 5.0098830730E+00, 3.5840100519E+00, 1.8379367702E+00, 8.6871542311E-01],
	[2.4780000000E+04, 1.5280005163E+01, 5.0098297466E+00, 3.5863488500E+00, 1.8386148385E+00, 8.6877928498E-01],
	[2.4785000000E+04, 1.5284865841E+01, 5.0097764315E+00, 3.5886887013E+00, 1.8392928464E+00, 8.6884311715E-01],
	[2.4790000000E+04, 1.5289727084E+01, 5.0097231278E+00, 3.5910296061E+00, 1.8399707937E+00, 8.6890691963E-01],
	[2.4795000000E+04, 1.5294588892E+01, 5.0096698354E+00, 3.5933715646E+00, 1.8406486804E+00, 8.6897069243E-01],
	[2.4800000000E+04, 1.5299451265E+01, 5.0096165543E+00, 3.5957145772E+00, 1.8413265064E+00, 8.6903443556E-01],
	[2.4805000000E+04, 1.5304314204E+01, 5.0095632845E+00, 3.5980586440E+00, 1.8420042715E+00, 8.6909814904E-01],
	[2.4810000000E+04, 1.5309177707E+01, 5.0095100260E+00, 3.6004037653E+00, 1.8426819757E+00, 8.6916183286E-01],
	[2.4815000000E+04, 1.5314041776E+01, 5.0094567788E+00, 3.6027499414E+00, 1.8433596188E+00, 8.6922548705E-01],
	[2.4820000000E+04, 1.5318906409E+01, 5.0094035429E+00, 3.6050971725E+00, 1.8440372008E+00, 8.6928911160E-01],
	[2.4825000000E+04, 1.5323771608E+01, 5.0093503183E+00, 3.6074454589E+00, 1.8447147215E+00, 8.6935270654E-01],
	[2.4830000000E+04, 1.5328637371E+01, 5.0092971049E+00, 3.6097948010E+00, 1.8453921809E+00, 8.6941627188E-01],
	[2.4835000000E+04, 1.5333503700E+01, 5.0092439029E+00, 3.6121451988E+00, 1.8460695787E+00, 8.6947980761E-01],
	[2.4840000000E+04, 1.5338370593E+01, 5.0091907121E+00, 3.6144966527E+00, 1.8467469150E+00, 8.6954331377E-01],
	[2.4845000000E+04, 1.5343238051E+01, 5.0091375326E+00, 3.6168491630E+00, 1.8474241896E+00, 8.6960679034E-01],
	[2.4850000000E+04, 1.5348106073E+01, 5.0090843644E+00, 3.6192027299E+00, 1.8481014025E+00, 8.6967023735E-01],
	[2.4855000000E+04, 1.5352974660E+01, 5.0090312074E+00, 3.6215573537E+00, 1.8487785534E+00, 8.6973365481E-01],
	[2.4860000000E+04, 1.5357843812E+01, 5.0089780617E+00, 3.6239130346E+00, 1.8494556423E+00, 8.6979704273E-01],
	[2.4865000000E+04, 1.5362713528E+01, 5.0089249272E+00, 3.6262697729E+00, 1.8501326691E+00, 8.6986040111E-01],
	[2.4870000000E+04, 1.5367583809E+01, 5.0088718040E+00, 3.6286275688E+00, 1.8508096337E+00, 8.6992372996E-01],
	[2.4875000000E+04, 1.5372454654E+01, 5.0088186920E+00, 3.6309864227E+00, 1.8514865360E+00, 8.6998702931E-01],
	[2.4880000000E+04, 1.5377326064E+01, 5.0087655912E+00, 3.6333463348E+00, 1.8521633759E+00, 8.7005029915E-01],
	[2.4885000000E+04, 1.5382198038E+01, 5.0087125017E+00, 3.6357073053E+00, 1.8528401533E+00, 8.7011353951E-01],
	[2.4890000000E+04, 1.5387070577E+01, 5.0086594234E+00, 3.6380693345E+00, 1.8535168680E+00, 8.7017675038E-01],
	[2.4895000000E+04, 1.5391943679E+01, 5.0086063564E+00, 3.6404324227E+00, 1.8541935200E+00, 8.7023993178E-01],
	[2.4900000000E+04, 1.5396817346E+01, 5.0085533005E+00, 3.6427965700E+00, 1.8548701091E+00, 8.7030308373E-01],
	[2.4905000000E+04, 1.5401691577E+01, 5.0085002559E+00, 3.6451617769E+00, 1.8555466354E+00, 8.7036620622E-01],
	[2.4910000000E+04, 1.5406566372E+01, 5.0084472225E+00, 3.6475280436E+00, 1.8562230985E+00, 8.7042929928E-01],
	[2.4915000000E+04, 1.5411441732E+01, 5.0083942003E+00, 3.6498953702E+00, 1.8568994986E+00, 8.7049236291E-01],
	[2.4920000000E+04, 1.5416317655E+01, 5.0083411893E+00, 3.6522637571E+00, 1.8575758353E+00, 8.7055539712E-01],
	[2.4925000000E+04, 1.5421194142E+01, 5.0082881895E+00, 3.6546332046E+00, 1.8582521087E+00, 8.7061840193E-01],
	[2.4930000000E+04, 1.5426071193E+01, 5.0082352008E+00, 3.6570037128E+00, 1.8589283187E+00, 8.7068137734E-01],
	[2.4935000000E+04, 1.5430948808E+01, 5.0081822234E+00, 3.6593752821E+00, 1.8596044651E+00, 8.7074432336E-01],
	[2.4940000000E+04, 1.5435826987E+01, 5.0081292572E+00, 3.6617479128E+00, 1.8602805478E+00, 8.7080724001E-01],
	[2.4945000000E+04, 1.5440705730E+01, 5.0080763021E+00, 3.6641216050E+00, 1.8609565668E+00, 8.7087012730E-01],
	[2.4950000000E+04, 1.5445585036E+01, 5.0080233582E+00, 3.6664963590E+00, 1.8616325219E+00, 8.7093298524E-01],
	[2.4955000000E+04, 1.5450464906E+01, 5.0079704255E+00, 3.6688721752E+00, 1.8623084130E+00, 8.7099581383E-01],
	[2.4960000000E+04, 1.5455345340E+01, 5.0079175039E+00, 3.6712490537E+00, 1.8629842400E+00, 8.7105861309E-01],
	[2.4965000000E+04, 1.5460226337E+01, 5.0078645935E+00, 3.6736269948E+00, 1.8636600029E+00, 8.7112138305E-01],
	[2.4970000000E+04, 1.5465107898E+01, 5.0078116942E+00, 3.6760059989E+00, 1.8643357014E+00, 8.7118412377E-01],
	[2.4975000000E+04, 1.5469990023E+01, 5.0077588061E+00, 3.6783860660E+00, 1.8650113356E+00, 8.7124683525E-01],
	[2.4980000000E+04, 1.5474872711E+01, 5.0077059292E+00, 3.6807671966E+00, 1.8656869053E+00, 8.7130951750E-01],
	[2.4985000000E+04, 1.5479755962E+01, 5.0076530633E+00, 3.6831493909E+00, 1.8663624104E+00, 8.7137217054E-01],
	[2.4990000000E+04, 1.5484639777E+01, 5.0076002087E+00, 3.6855326491E+00, 1.8670378508E+00, 8.7143479436E-01],
	[2.4995000000E+04, 1.5489524154E+01, 5.0075473651E+00, 3.6879169715E+00, 1.8677132264E+00, 8.7149738899E-01],
	[2.5000000000E+04, 1.5494409096E+01, 5.0074945327E+00, 3.6903023584E+00, 1.8683885371E+00, 8.7155995442E-01],
	[2.5005000000E+04, 1.5499294600E+01, 5.0074417114E+00, 3.6926944921E+00, 1.8690652385E+00, 8.7162249068E-01],
	[2.5010000000E+04, 1.5504180668E+01, 5.0073889012E+00, 3.6950876971E+00, 1.8697418747E+00, 8.7168499776E-01],
	[2.5015000000E+04, 1.5509067298E+01, 5.0073361021E+00, 3.6974819738E+00, 1.8704184457E+00, 8.7174747569E-01],
	[2.5020000000E+04, 1.5513954492E+01, 5.0072833142E+00, 3.6998773222E+00, 1.8710949514E+00, 8.7180992446E-01],
	[2.5025000000E+04, 1.5518842249E+01, 5.0072305373E+00, 3.7022737428E+00, 1.8717713916E+00, 8.7187234410E-01],
	[2.5030000000E+04, 1.5523730569E+01, 5.0071777716E+00, 3.7046712357E+00, 1.8724477662E+00, 8.7193473460E-01],
	[2.5035000000E+04, 1.5528619451E+01, 5.0071250169E+00, 3.7070698013E+00, 1.8731240752E+00, 8.7199709598E-01],
	[2.5040000000E+04, 1.5533508897E+01, 5.0070722733E+00, 3.7094694398E+00, 1.8738003184E+00, 8.7205942825E-01],
	[2.5045000000E+04, 1.5538398905E+01, 5.0070195408E+00, 3.7118701514E+00, 1.8744764957E+00, 8.7212173141E-01],
	[2.5050000000E+04, 1.5543289476E+01, 5.0069668194E+00, 3.7142719365E+00, 1.8751526071E+00, 8.7218400548E-01],
	[2.5055000000E+04, 1.5548180610E+01, 5.0069141091E+00, 3.7166747953E+00, 1.8758286524E+00, 8.7224625047E-01],
	[2.5060000000E+04, 1.5553072307E+01, 5.0068614099E+00, 3.7190787281E+00, 1.8765046315E+00, 8.7230846639E-01],
	[2.5065000000E+04, 1.5557964566E+01, 5.0068087217E+00, 3.7214837350E+00, 1.8771805444E+00, 8.7237065324E-01],
	[2.5070000000E+04, 1.5562857388E+01, 5.0067560446E+00, 3.7238898165E+00, 1.8778563908E+00, 8.7243281104E-01],
	[2.5075000000E+04, 1.5567750773E+01, 5.0067033785E+00, 3.7262969727E+00, 1.8785321708E+00, 8.7249493979E-01],
	[2.5080000000E+04, 1.5572644719E+01, 5.0066507235E+00, 3.7287052040E+00, 1.8792078842E+00, 8.7255703951E-01],
	[2.5085000000E+04, 1.5577539229E+01, 5.0065980795E+00, 3.7311145105E+00, 1.8798835310E+00, 8.7261911021E-01],
	[2.5090000000E+04, 1.5582437415E+01, 5.0065459645E+00, 3.7335248926E+00, 1.8805592293E+00, 8.7268115189E-01],
	[2.5095000000E+04, 1.5587355174E+01, 5.0064970204E+00, 3.7359363505E+00, 1.8812355840E+00, 8.7274316456E-01],
	[2.5100000000E+04, 1.5592273506E+01, 5.0064480865E+00, 3.7383488845E+00, 1.8819118726E+00, 8.7280514824E-01],
	[2.5105000000E+04, 1.5597192409E+01, 5.0063991629E+00, 3.7407624949E+00, 1.8825880949E+00, 8.7286710294E-01],
	[2.5110000000E+04, 1.5602111884E+01, 5.0063502495E+00, 3.7431771819E+00, 1.8832642508E+00, 8.7292902866E-01],
	[2.5115000000E+04, 1.5607031930E+01, 5.0063013463E+00, 3.7455929457E+00, 1.8839403404E+00, 8.7299092541E-01],
	[2.5120000000E+04, 1.5611952549E+01, 5.0062524534E+00, 3.7480097867E+00, 1.8846163633E+00, 8.7305279321E-01],
	[2.5125000000E+04, 1.5616873739E+01, 5.0062035706E+00, 3.7504277051E+00, 1.8852923197E+00, 8.7311463206E-01],
	[2.5130000000E+04, 1.5621795500E+01, 5.0061546981E+00, 3.7528467012E+00, 1.8859682093E+00, 8.7317644198E-01],
	[2.5135000000E+04, 1.5626717833E+01, 5.0061058357E+00, 3.7552667753E+00, 1.8866440320E+00, 8.7323822297E-01],
	[2.5140000000E+04, 1.5631640737E+01, 5.0060569836E+00, 3.7576879275E+00, 1.8873197878E+00, 8.7329997504E-01],
	[2.5145000000E+04, 1.5636564213E+01, 5.0060081416E+00, 3.7601101582E+00, 1.8879954766E+00, 8.7336169821E-01],
	[2.5150000000E+04, 1.5641488260E+01, 5.0059593098E+00, 3.7625334677E+00, 1.8886710982E+00, 8.7342339248E-01],
	[2.5155000000E+04, 1.5646412879E+01, 5.0059104882E+00, 3.7649578561E+00, 1.8893466525E+00, 8.7348505786E-01],
	[2.5160000000E+04, 1.5651338068E+01, 5.0058616768E+00, 3.7673833239E+00, 1.8900221395E+00, 8.7354669436E-01],
	[2.5165000000E+04, 1.5656263829E+01, 5.0058128755E+00, 3.7698098711E+00, 1.8906975591E+00, 8.7360830200E-01],
	[2.5170000000E+04, 1.5661190161E+01, 5.0057640845E+00, 3.7722374982E+00, 1.8913729111E+00, 8.7366988078E-01],
	[2.5175000000E+04, 1.5666117065E+01, 5.0057153036E+00, 3.7746662053E+00, 1.8920481954E+00, 8.7373143072E-01],
	[2.5180000000E+04, 1.5671044539E+01, 5.0056665328E+00, 3.7770959928E+00, 1.8927234120E+00, 8.7379295182E-01],
	[2.5185000000E+04, 1.5675972584E+01, 5.0056177722E+00, 3.7795268609E+00, 1.8933985608E+00, 8.7385444409E-01],
	[2.5190000000E+04, 1.5680901200E+01, 5.0055690218E+00, 3.7819588098E+00, 1.8940736416E+00, 8.7391590754E-01],
	[2.5195000000E+04, 1.5685830388E+01, 5.0055202815E+00, 3.7843918398E+00, 1.8947486543E+00, 8.7397734218E-01],
	[2.5200000000E+04, 1.5690760146E+01, 5.0054715514E+00, 3.7868259513E+00, 1.8954235990E+00, 8.7403874803E-01],
	[2.5205000000E+04, 1.5695690475E+01, 5.0054228314E+00, 3.7892611444E+00, 1.8960984753E+00, 8.7410012509E-01],
	[2.5210000000E+04, 1.5700621375E+01, 5.0053741216E+00, 3.7916974194E+00, 1.8967732833E+00, 8.7416147338E-01],
	[2.5215000000E+04, 1.5705552845E+01, 5.0053254218E+00, 3.7941347766E+00, 1.8974480229E+00, 8.7422279289E-01],
	[2.5220000000E+04, 1.5710484886E+01, 5.0052767322E+00, 3.7965732163E+00, 1.8981226939E+00, 8.7428408365E-01],
	[2.5225000000E+04, 1.5715417498E+01, 5.0052280528E+00, 3.7990127387E+00, 1.8987972963E+00, 8.7434534566E-01],
	[2.5230000000E+04, 1.5720350680E+01, 5.0051793834E+00, 3.8014533441E+00, 1.8994718299E+00, 8.7440657893E-01],
	[2.5235000000E+04, 1.5725284433E+01, 5.0051307242E+00, 3.8038950328E+00, 1.9001462947E+00, 8.7446778348E-01],
	[2.5240000000E+04, 1.5730218757E+01, 5.0050820751E+00, 3.8063378049E+00, 1.9008206905E+00, 8.7452895931E-01],
	[2.5245000000E+04, 1.5735153651E+01, 5.0050334361E+00, 3.8087816609E+00, 1.9014950173E+00, 8.7459010643E-01],
	[2.5250000000E+04, 1.5740089115E+01, 5.0049848072E+00, 3.8112266009E+00, 1.9021692749E+00, 8.7465122485E-01],
	[2.5255000000E+04, 1.5745025150E+01, 5.0049361884E+00, 3.8136726252E+00, 1.9028434633E+00, 8.7471231459E-01],
	[2.5260000000E+04, 1.5749961755E+01, 5.0048875797E+00, 3.8161197341E+00, 1.9035175824E+00, 8.7477337565E-01],
	[2.5265000000E+04, 1.5754898930E+01, 5.0048389811E+00, 3.8185679278E+00, 1.9041916320E+00, 8.7483440804E-01],
	[2.5270000000E+04, 1.5759836676E+01, 5.0047903926E+00, 3.8210172067E+00, 1.9048656121E+00, 8.7489541177E-01],
	[2.5275000000E+04, 1.5764774992E+01, 5.0047418141E+00, 3.8234675709E+00, 1.9055395226E+00, 8.7495638686E-01],
	[2.5280000000E+04, 1.5769713878E+01, 5.0046932458E+00, 3.8259190208E+00, 1.9062133633E+00, 8.7501733331E-01],
	[2.5285000000E+04, 1.5774653334E+01, 5.0046446875E+00, 3.8283715566E+00, 1.9068871342E+00, 8.7507825114E-01],
	[2.5290000000E+04, 1.5779593360E+01, 5.0045961393E+00, 3.8308251785E+00, 1.9075608352E+00, 8.7513914034E-01],
	[2.5295000000E+04, 1.5784533956E+01, 5.0045476012E+00, 3.8332798869E+00, 1.9082344661E+00, 8.7520000094E-01],
	[2.5300000000E+04, 1.5789475122E+01, 5.0044990731E+00, 3.8357356820E+00, 1.9089080269E+00, 8.7526083295E-01],
	[2.5305000000E+04, 1.5794416857E+01, 5.0044505551E+00, 3.8381925641E+00, 1.9095815175E+00, 8.7532163637E-01],
	[2.5310000000E+04, 1.5799359163E+01, 5.0044020471E+00, 3.8406505334E+00, 1.9102549378E+00, 8.7538241121E-01],
	[2.5315000000E+04, 1.5804302039E+01, 5.0043535492E+00, 3.8431095903E+00, 1.9109282876E+00, 8.7544315748E-01],
	[2.5320000000E+04, 1.5809245484E+01, 5.0043050613E+00, 3.8455697349E+00, 1.9116015670E+00, 8.7550387520E-01],
	[2.5325000000E+04, 1.5814189499E+01, 5.0042565835E+00, 3.8480309675E+00, 1.9122747757E+00, 8.7556456438E-01],
	[2.5330000000E+04, 1.5819134083E+01, 5.0042081158E+00, 3.8504932884E+00, 1.9129479137E+00, 8.7562522502E-01],
	[2.5335000000E+04, 1.5824079238E+01, 5.0041596580E+00, 3.8529566979E+00, 1.9136209809E+00, 8.7568585713E-01],
	[2.5340000000E+04, 1.5829024962E+01, 5.0041112103E+00, 3.8554211963E+00, 1.9142939772E+00, 8.7574646073E-01],
	[2.5345000000E+04, 1.5833971255E+01, 5.0040627726E+00, 3.8578867837E+00, 1.9149669025E+00, 8.7580703582E-01],
	[2.5350000000E+04, 1.5838918118E+01, 5.0040143450E+00, 3.8603534605E+00, 1.9156397567E+00, 8.7586758242E-01],
	[2.5355000000E+04, 1.5843865550E+01, 5.0039659273E+00, 3.8628212270E+00, 1.9163125397E+00, 8.7592810053E-01],
	[2.5360000000E+04, 1.5848813552E+01, 5.0039175197E+00, 3.8652900833E+00, 1.9169852514E+00, 8.7598859017E-01],
	[2.5365000000E+04, 1.5853762122E+01, 5.0038691221E+00, 3.8677600298E+00, 1.9176578917E+00, 8.7604905135E-01],
	[2.5370000000E+04, 1.5858711263E+01, 5.0038207345E+00, 3.8702310667E+00, 1.9183304605E+00, 8.7610948407E-01],
	[2.5375000000E+04, 1.5863660972E+01, 5.0037723569E+00, 3.8727031943E+00, 1.9190029578E+00, 8.7616988835E-01],
	[2.5380000000E+04, 1.5868611251E+01, 5.0037239893E+00, 3.8751764129E+00, 1.9196753833E+00, 8.7623026419E-01],
	[2.5385000000E+04, 1.5873562099E+01, 5.0036756317E+00, 3.8776507227E+00, 1.9203477371E+00, 8.7629061161E-01],
	[2.5390000000E+04, 1.5878513516E+01, 5.0036272841E+00, 3.8801261240E+00, 1.9210200190E+00, 8.7635093062E-01],
	[2.5395000000E+04, 1.5883465502E+01, 5.0035789464E+00, 3.8826026171E+00, 1.9216922290E+00, 8.7641122122E-01],
	[2.5400000000E+04, 1.5888418057E+01, 5.0035306188E+00, 3.8850802022E+00, 1.9223643669E+00, 8.7647148343E-01],
	[2.5405000000E+04, 1.5893371181E+01, 5.0034823011E+00, 3.8875588796E+00, 1.9230364326E+00, 8.7653171726E-01],
	[2.5410000000E+04, 1.5898324874E+01, 5.0034339934E+00, 3.8900386495E+00, 1.9237084261E+00, 8.7659192272E-01],
	[2.5415000000E+04, 1.5903279135E+01, 5.0033856957E+00, 3.8925195123E+00, 1.9243803472E+00, 8.7665209982E-01],
	[2.5420000000E+04, 1.5908233966E+01, 5.0033374080E+00, 3.8950014681E+00, 1.9250521958E+00, 8.7671224856E-01],
	[2.5425000000E+04, 1.5913189365E+01, 5.0032891302E+00, 3.8974845173E+00, 1.9257239719E+00, 8.7677236897E-01],
	[2.5430000000E+04, 1.5918145333E+01, 5.0032408623E+00, 3.8999686602E+00, 1.9263956754E+00, 8.7683246104E-01],
	[2.5435000000E+04, 1.5923101870E+01, 5.0031926045E+00, 3.9024538969E+00, 1.9270673062E+00, 8.7689252479E-01],
	[2.5440000000E+04, 1.5928058975E+01, 5.0031443565E+00, 3.9049402278E+00, 1.9277388641E+00, 8.7695256023E-01],
	[2.5445000000E+04, 1.5933016649E+01, 5.0030961186E+00, 3.9074276531E+00, 1.9284103491E+00, 8.7701256738E-01],
	[2.5450000000E+04, 1.5937974892E+01, 5.0030478905E+00, 3.9099161730E+00, 1.9290817610E+00, 8.7707254623E-01],
	[2.5455000000E+04, 1.5942933703E+01, 5.0029996724E+00, 3.9124057880E+00, 1.9297530999E+00, 8.7713249680E-01],
	[2.5460000000E+04, 1.5947893082E+01, 5.0029514643E+00, 3.9148964981E+00, 1.9304243655E+00, 8.7719241911E-01],
	[2.5465000000E+04, 1.5952853030E+01, 5.0029032660E+00, 3.9173883038E+00, 1.9310955578E+00, 8.7725231315E-01],
	[2.5470000000E+04, 1.5957813547E+01, 5.0028550777E+00, 3.9198812052E+00, 1.9317666767E+00, 8.7731217895E-01],
	[2.5475000000E+04, 1.5962774631E+01, 5.0028068994E+00, 3.9223752026E+00, 1.9324377222E+00, 8.7737201651E-01],
	[2.5480000000E+04, 1.5967736284E+01, 5.0027587309E+00, 3.9248702962E+00, 1.9331086940E+00, 8.7743182585E-01],
	[2.5485000000E+04, 1.5972698505E+01, 5.0027105723E+00, 3.9273664865E+00, 1.9337795922E+00, 8.7749160696E-01],
	[2.5490000000E+04, 1.5977661294E+01, 5.0026624237E+00, 3.9298637735E+00, 1.9344504165E+00, 8.7755135987E-01],
	[2.5495000000E+04, 1.5982632593E+01, 5.0026155865E+00, 3.9323621577E+00, 1.9351214782E+00, 8.7761108459E-01],
	[2.5500000000E+04, 1.5987618581E+01, 5.0025710718E+00, 3.9348616392E+00, 1.9357930195E+00, 8.7767078111E-01],
	[2.5505000000E+04, 1.5992605145E+01, 5.0025265662E+00, 3.9373622183E+00, 1.9364644875E+00, 8.7773044946E-01],
	[2.5510000000E+04, 1.5997592287E+01, 5.0024820697E+00, 3.9398638952E+00, 1.9371358823E+00, 8.7779008965E-01],
	[2.5515000000E+04, 1.6002580007E+01, 5.0024375824E+00, 3.9423666704E+00, 1.9378072036E+00, 8.7784970168E-01],
	[2.5520000000E+04, 1.6007568304E+01, 5.0023931041E+00, 3.9448705439E+00, 1.9384784514E+00, 8.7790928557E-01],
	[2.5525000000E+04, 1.6012557178E+01, 5.0023486350E+00, 3.9473755161E+00, 1.9391496256E+00, 8.7796884133E-01],
	[2.5530000000E+04, 1.6017546629E+01, 5.0023041750E+00, 3.9498815873E+00, 1.9398207261E+00, 8.7802836896E-01],
	[2.5535000000E+04, 1.6022536657E+01, 5.0022597240E+00, 3.9523887577E+00, 1.9404917528E+00, 8.7808786848E-01],
	[2.5540000000E+04, 1.6027527263E+01, 5.0022152822E+00, 3.9548970276E+00, 1.9411627057E+00, 8.7814733989E-01],
	[2.5545000000E+04, 1.6032518445E+01, 5.0021708495E+00, 3.9574063972E+00, 1.9418335845E+00, 8.7820678322E-01],
	[2.5550000000E+04, 1.6037510205E+01, 5.0021264258E+00, 3.9599168668E+00, 1.9425043893E+00, 8.7826619846E-01],
	[2.5555000000E+04, 1.6042502541E+01, 5.0020820113E+00, 3.9624284367E+00, 1.9431751199E+00, 8.7832558563E-01],
	[2.5560000000E+04, 1.6047495455E+01, 5.0020376058E+00, 3.9649411071E+00, 1.9438457763E+00, 8.7838494474E-01],
	[2.5565000000E+04, 1.6052488945E+01, 5.0019932094E+00, 3.9674548784E+00, 1.9445163583E+00, 8.7844427580E-01],
	[2.5570000000E+04, 1.6057483012E+01, 5.0019488221E+00, 3.9699697507E+00, 1.9451868659E+00, 8.7850357883E-01],
	[2.5575000000E+04, 1.6062477656E+01, 5.0019044438E+00, 3.9724857244E+00, 1.9458572989E+00, 8.7856285382E-01],
	[2.5580000000E+04, 1.6067472877E+01, 5.0018600746E+00, 3.9750027997E+00, 1.9465276573E+00, 8.7862210079E-01],
	[2.5585000000E+04, 1.6072468674E+01, 5.0018157145E+00, 3.9775209768E+00, 1.9471979410E+00, 8.7868131976E-01],
	[2.5590000000E+04, 1.6077465048E+01, 5.0017713635E+00, 3.9800402561E+00, 1.9478681499E+00, 8.7874051072E-01],
	[2.5595000000E+04, 1.6082461999E+01, 5.0017270215E+00, 3.9825606379E+00, 1.9485382838E+00, 8.7879967371E-01],
	[2.5600000000E+04, 1.6087459526E+01, 5.0016826885E+00, 3.9850821223E+00, 1.9492083428E+00, 8.7885880871E-01],
	[2.5605000000E+04, 1.6092457630E+01, 5.0016383647E+00, 3.9876047096E+00, 1.9498783266E+00, 8.7891791575E-01],
	[2.5610000000E+04, 1.6097456310E+01, 5.0015940498E+00, 3.9901284001E+00, 1.9505482353E+00, 8.7897699483E-01],
	[2.5615000000E+04, 1.6102455567E+01, 5.0015497440E+00, 3.9926531942E+00, 1.9512180687E+00, 8.7903604597E-01],
	[2.5620000000E+04, 1.6107455400E+01, 5.0015054473E+00, 3.9951790919E+00, 1.9518878267E+00, 8.7909506917E-01],
	[2.5625000000E+04, 1.6112455809E+01, 5.0014611595E+00, 3.9977060937E+00, 1.9525575093E+00, 8.7915406445E-01],
	[2.5630000000E+04, 1.6117456795E+01, 5.0014168809E+00, 4.0002341998E+00, 1.9532271163E+00, 8.7921303182E-01],
	[2.5635000000E+04, 1.6122458357E+01, 5.0013726112E+00, 4.0027634104E+00, 1.9538966476E+00, 8.7927197128E-01],
	[2.5640000000E+04, 1.6127460495E+01, 5.0013283506E+00, 4.0052937258E+00, 1.9545661032E+00, 8.7933088285E-01],
	[2.5645000000E+04, 1.6132463209E+01, 5.0012840989E+00, 4.0078251462E+00, 1.9552354830E+00, 8.7938976654E-01],
	[2.5650000000E+04, 1.6137466499E+01, 5.0012398563E+00, 4.0103576721E+00, 1.9559047869E+00, 8.7944862236E-01],
	[2.5655000000E+04, 1.6142470366E+01, 5.0011956228E+00, 4.0128913035E+00, 1.9565740147E+00, 8.7950745032E-01],
	[2.5660000000E+04, 1.6147474808E+01, 5.0011513982E+00, 4.0154260408E+00, 1.9572431665E+00, 8.7956625042E-01],
	[2.5665000000E+04, 1.6152479826E+01, 5.0011071826E+00, 4.0179618842E+00, 1.9579122420E+00, 8.7962502269E-01],
	[2.5670000000E+04, 1.6157485420E+01, 5.0010629761E+00, 4.0204988341E+00, 1.9585812413E+00, 8.7968376713E-01],
	[2.5675000000E+04, 1.6162491590E+01, 5.0010187785E+00, 4.0230368906E+00, 1.9592501641E+00, 8.7974248376E-01],
	[2.5680000000E+04, 1.6167498336E+01, 5.0009745900E+00, 4.0255760541E+00, 1.9599190105E+00, 8.7980117257E-01],
	[2.5685000000E+04, 1.6172505658E+01, 5.0009304104E+00, 4.0281163248E+00, 1.9605877804E+00, 8.7985983359E-01],
	[2.5690000000E+04, 1.6177513555E+01, 5.0008862398E+00, 4.0306577030E+00, 1.9612564735E+00, 8.7991846682E-01],
	[2.5695000000E+04, 1.6182522028E+01, 5.0008420782E+00, 4.0332001889E+00, 1.9619250900E+00, 8.7997707227E-01],
	[2.5700000000E+04, 1.6187531077E+01, 5.0007979256E+00, 4.0357437828E+00, 1.9625936296E+00, 8.8003564997E-01],
	[2.5705000000E+04, 1.6192540701E+01, 5.0007537820E+00, 4.0382884850E+00, 1.9632620922E+00, 8.8009419990E-01],
	[2.5710000000E+04, 1.6197550901E+01, 5.0007096473E+00, 4.0408342957E+00, 1.9639304779E+00, 8.8015272209E-01],
	[2.5715000000E+04, 1.6202561677E+01, 5.0006655217E+00, 4.0433812152E+00, 1.9645987864E+00, 8.8021121655E-01],
	[2.5720000000E+04, 1.6207573028E+01, 5.0006214049E+00, 4.0459292439E+00, 1.9652670178E+00, 8.8026968329E-01],
	[2.5725000000E+04, 1.6212584954E+01, 5.0005772972E+00, 4.0484783818E+00, 1.9659351718E+00, 8.8032812232E-01],
	[2.5730000000E+04, 1.6217597455E+01, 5.0005331984E+00, 4.0510286294E+00, 1.9666032485E+00, 8.8038653364E-01],
	[2.5735000000E+04, 1.6222610532E+01, 5.0004891086E+00, 4.0535799869E+00, 1.9672712477E+00, 8.8044491728E-01],
	[2.5740000000E+04, 1.6227624184E+01, 5.0004450277E+00, 4.0561324544E+00, 1.9679391694E+00, 8.8050327323E-01],
	[2.5745000000E+04, 1.6232638412E+01, 5.0004009558E+00, 4.0586860325E+00, 1.9686070134E+00, 8.8056160152E-01],
	[2.5750000000E+04, 1.6237653214E+01, 5.0003568928E+00, 4.0612407211E+00, 1.9692747796E+00, 8.8061990214E-01],
	[2.5755000000E+04, 1.6242668592E+01, 5.0003128387E+00, 4.0637965208E+00, 1.9699424681E+00, 8.8067817512E-01],
	[2.5760000000E+04, 1.6247684545E+01, 5.0002687936E+00, 4.0663534316E+00, 1.9706100786E+00, 8.8073642046E-01],
	[2.5765000000E+04, 1.6252701073E+01, 5.0002247575E+00, 4.0689114539E+00, 1.9712776110E+00, 8.8079463818E-01],
	[2.5770000000E+04, 1.6257718176E+01, 5.0001807303E+00, 4.0714705880E+00, 1.9719450654E+00, 8.8085282828E-01],
	[2.5775000000E+04, 1.6262735853E+01, 5.0001367120E+00, 4.0740308341E+00, 1.9726124416E+00, 8.8091099078E-01],
	[2.5780000000E+04, 1.6267754106E+01, 5.0000927026E+00, 4.0765921924E+00, 1.9732797396E+00, 8.8096912568E-01],
	[2.5785000000E+04, 1.6272772934E+01, 5.0000487021E+00, 4.0791546633E+00, 1.9739469591E+00, 8.8102723299E-01],
	[2.5790000000E+04, 1.6277792336E+01, 5.0000047106E+00, 4.0817182470E+00, 1.9746141002E+00, 8.8108531274E-01],
	[2.5795000000E+04, 1.6282812313E+01, 4.9999607280E+00, 4.0842829438E+00, 1.9752811628E+00, 8.8114336492E-01],
	[2.5800000000E+04, 1.6287832865E+01, 4.9999167543E+00, 4.0868487540E+00, 1.9759481467E+00, 8.8120138955E-01],
	[2.5805000000E+04, 1.6292853992E+01, 4.9998727895E+00, 4.0894156777E+00, 1.9766150519E+00, 8.8125938665E-01],
	[2.5810000000E+04, 1.6297875693E+01, 4.9998288336E+00, 4.0919837154E+00, 1.9772818783E+00, 8.8131735621E-01],
	[2.5815000000E+04, 1.6302897969E+01, 4.9997848866E+00, 4.0945528671E+00, 1.9779486258E+00, 8.8137529825E-01],
	[2.5820000000E+04, 1.6307920819E+01, 4.9997409485E+00, 4.0971231333E+00, 1.9786152942E+00, 8.8143321279E-01],
	[2.5825000000E+04, 1.6312944244E+01, 4.9996970193E+00, 4.0996945142E+00, 1.9792818837E+00, 8.8149109982E-01],
	[2.5830000000E+04, 1.6317968243E+01, 4.9996530990E+00, 4.1022670100E+00, 1.9799483939E+00, 8.8154895937E-01],
	[2.5835000000E+04, 1.6322992817E+01, 4.9996091875E+00, 4.1048406211E+00, 1.9806148249E+00, 8.8160679145E-01],
	[2.5840000000E+04, 1.6328017965E+01, 4.9995652850E+00, 4.1074153476E+00, 1.9812811765E+00, 8.8166459606E-01],
	[2.5845000000E+04, 1.6333043687E+01, 4.9995213913E+00, 4.1099911899E+00, 1.9819474487E+00, 8.8172237321E-01],
	[2.5850000000E+04, 1.6338069984E+01, 4.9994775065E+00, 4.1125681482E+00, 1.9826136414E+00, 8.8178012292E-01],
	[2.5855000000E+04, 1.6343096855E+01, 4.9994336306E+00, 4.1151462228E+00, 1.9832797545E+00, 8.8183784520E-01],
	[2.5860000000E+04, 1.6348124300E+01, 4.9993897636E+00, 4.1177254139E+00, 1.9839457878E+00, 8.8189554006E-01],
	[2.5865000000E+04, 1.6353152319E+01, 4.9993459054E+00, 4.1203057219E+00, 1.9846117414E+00, 8.8195320750E-01],
	[2.5870000000E+04, 1.6358180912E+01, 4.9993020561E+00, 4.1228871469E+00, 1.9852776151E+00, 8.8201084755E-01],
	[2.5875000000E+04, 1.6363210079E+01, 4.9992582156E+00, 4.1254696893E+00, 1.9859434089E+00, 8.8206846020E-01],
	[2.5880000000E+04, 1.6368239821E+01, 4.9992143840E+00, 4.1280533494E+00, 1.9866091226E+00, 8.8212604548E-01],
	[2.5885000000E+04, 1.6373270136E+01, 4.9991705613E+00, 4.1306381273E+00, 1.9872747561E+00, 8.8218360338E-01],
	[2.5890000000E+04, 1.6378301025E+01, 4.9991267474E+00, 4.1332240233E+00, 1.9879403094E+00, 8.8224113394E-01],
	[2.5895000000E+04, 1.6383332488E+01, 4.9990829423E+00, 4.1358110378E+00, 1.9886057825E+00, 8.8229863714E-01],
	[2.5900000000E+04, 1.6388364525E+01, 4.9990391461E+00, 4.1383991710E+00, 1.9892711751E+00, 8.8235611301E-01],
	[2.5905000000E+04, 1.6393403260E+01, 4.9989963492E+00, 4.1409884231E+00, 1.9899367344E+00, 8.8241356155E-01],
	[2.5910000000E+04, 1.6398458411E+01, 4.9989561216E+00, 4.1435787945E+00, 1.9906028528E+00, 8.8247098278E-01],
	[2.5915000000E+04, 1.6403514145E+01, 4.9989159020E+00, 4.1461702853E+00, 1.9912688914E+00, 8.8252837671E-01],
	[2.5920000000E+04, 1.6408570462E+01, 4.9988756905E+00, 4.1487628959E+00, 1.9919348501E+00, 8.8258574335E-01],
	[2.5925000000E+04, 1.6413627362E+01, 4.9988354871E+00, 4.1513566265E+00, 1.9926007287E+00, 8.8264308270E-01],
	[2.5930000000E+04, 1.6418684844E+01, 4.9987952918E+00, 4.1539514775E+00, 1.9932665273E+00, 8.8270039478E-01],
	[2.5935000000E+04, 1.6423742910E+01, 4.9987551046E+00, 4.1565474490E+00, 1.9939322456E+00, 8.8275767961E-01],
	[2.5940000000E+04, 1.6428801558E+01, 4.9987149254E+00, 4.1591445413E+00, 1.9945978837E+00, 8.8281493718E-01],
	[2.5945000000E+04, 1.6433860788E+01, 4.9986747543E+00, 4.1617427547E+00, 1.9952634414E+00, 8.8287216752E-01],
	[2.5950000000E+04, 1.6438920602E+01, 4.9986345912E+00, 4.1643420894E+00, 1.9959289187E+00, 8.8292937063E-01],
	[2.5955000000E+04, 1.6443980998E+01, 4.9985944362E+00, 4.1669425458E+00, 1.9965943155E+00, 8.8298654652E-01],
	[2.5960000000E+04, 1.6449041976E+01, 4.9985542893E+00, 4.1695441241E+00, 1.9972596316E+00, 8.8304369521E-01],
	[2.5965000000E+04, 1.6454103537E+01, 4.9985141504E+00, 4.1721468246E+00, 1.9979248671E+00, 8.8310081670E-01],
	[2.5970000000E+04, 1.6459165680E+01, 4.9984740196E+00, 4.1747506475E+00, 1.9985900217E+00, 8.8315791102E-01],
	[2.5975000000E+04, 1.6464228406E+01, 4.9984338968E+00, 4.1773555931E+00, 1.9992550955E+00, 8.8321497815E-01],
	[2.5980000000E+04, 1.6469291714E+01, 4.9983937821E+00, 4.1799616617E+00, 1.9999200883E+00, 8.8327201813E-01],
	[2.5985000000E+04, 1.6474355605E+01, 4.9983536754E+00, 4.1825688535E+00, 2.0005850001E+00, 8.8332903096E-01],
	[2.5990000000E+04, 1.6479420078E+01, 4.9983135767E+00, 4.1851771688E+00, 2.0012498307E+00, 8.8338601664E-01],
	[2.5995000000E+04, 1.6484485133E+01, 4.9982734861E+00, 4.1877866078E+00, 2.0019145801E+00, 8.8344297520E-01],
	[2.6000000000E+04, 1.6489550770E+01, 4.9982334035E+00, 4.1903971709E+00, 2.0025792482E+00, 8.8349990664E-01],
	[2.6005000000E+04, 1.6494616989E+01, 4.9981933290E+00, 4.1930088584E+00, 2.0032438349E+00, 8.8355681097E-01],
	[2.6010000000E+04, 1.6499683791E+01, 4.9981532624E+00, 4.1956216703E+00, 2.0039083401E+00, 8.8361368820E-01],
	[2.6015000000E+04, 1.6504751174E+01, 4.9981132039E+00, 4.1982356072E+00, 2.0045727638E+00, 8.8367053835E-01],
	[2.6020000000E+04, 1.6509819140E+01, 4.9980731534E+00, 4.2008506691E+00, 2.0052371058E+00, 8.8372736143E-01],
	[2.6025000000E+04, 1.6514887687E+01, 4.9980331109E+00, 4.2034668564E+00, 2.0059013661E+00, 8.8378415744E-01],
	[2.6030000000E+04, 1.6519956816E+01, 4.9979930765E+00, 4.2060841693E+00, 2.0065655446E+00, 8.8384092640E-01],
	[2.6035000000E+04, 1.6525026528E+01, 4.9979530500E+00, 4.2087026082E+00, 2.0072296412E+00, 8.8389766832E-01],
	[2.6040000000E+04, 1.6530096821E+01, 4.9979130316E+00, 4.2113221732E+00, 2.0078936558E+00, 8.8395438321E-01],
	[2.6045000000E+04, 1.6535167696E+01, 4.9978730211E+00, 4.2139428647E+00, 2.0085575883E+00, 8.8401107107E-01],
	[2.6050000000E+04, 1.6540239152E+01, 4.9978330187E+00, 4.2165646829E+00, 2.0092214387E+00, 8.8406773193E-01],
	[2.6055000000E+04, 1.6545311190E+01, 4.9977930243E+00, 4.2191876281E+00, 2.0098852068E+00, 8.8412436580E-01],
	[2.6060000000E+04, 1.6550383810E+01, 4.9977530378E+00, 4.2218117005E+00, 2.0105488926E+00, 8.8418097267E-01],
	[2.6065000000E+04, 1.6555457012E+01, 4.9977130593E+00, 4.2244369004E+00, 2.0112124959E+00, 8.8423755257E-01],
	[2.6070000000E+04, 1.6560530795E+01, 4.9976730889E+00, 4.2270632282E+00, 2.0118760168E+00, 8.8429410550E-01],
	[2.6075000000E+04, 1.6565605160E+01, 4.9976331264E+00, 4.2296906839E+00, 2.0125394551E+00, 8.8435063147E-01],
	[2.6080000000E+04, 1.6570680106E+01, 4.9975931719E+00, 4.2323192680E+00, 2.0132028107E+00, 8.8440713048E-01],
	[2.6085000000E+04, 1.6575755633E+01, 4.9975532254E+00, 4.2349489807E+00, 2.0138660836E+00, 8.8446360252E-01],
	[2.6090000000E+04, 1.6580831742E+01, 4.9975132868E+00, 4.2375798222E+00, 2.0145292737E+00, 8.8452004763E-01],
	[2.6095000000E+04, 1.6585908432E+01, 4.9974733562E+00, 4.2402117929E+00, 2.0151923808E+00, 8.8457646579E-01],
	[2.6100000000E+04, 1.6590985704E+01, 4.9974334336E+00, 4.2428448929E+00, 2.0158554050E+00, 8.8463285702E-01],
	[2.6105000000E+04, 1.6596063556E+01, 4.9973935190E+00, 4.2454791226E+00, 2.0165183460E+00, 8.8468922134E-01],
	[2.6110000000E+04, 1.6601141990E+01, 4.9973536123E+00, 4.2481144822E+00, 2.0171812039E+00, 8.8474555874E-01],
	[2.6115000000E+04, 1.6606221005E+01, 4.9973137136E+00, 4.2507509720E+00, 2.0178439785E+00, 8.8480186925E-01],
	[2.6120000000E+04, 1.6611300601E+01, 4.9972738228E+00, 4.2533885923E+00, 2.0185066698E+00, 8.8485815287E-01],
	[2.6125000000E+04, 1.6616380779E+01, 4.9972339400E+00, 4.2560273433E+00, 2.0191692777E+00, 8.8491440960E-01],
	[2.6130000000E+04, 1.6621461537E+01, 4.9971940651E+00, 4.2586672253E+00, 2.0198318021E+00, 8.8497063947E-01],
	[2.6135000000E+04, 1.6626542876E+01, 4.9971541982E+00, 4.2613082386E+00, 2.0204942428E+00, 8.8502684247E-01],
	[2.6140000000E+04, 1.6631624796E+01, 4.9971143393E+00, 4.2639503834E+00, 2.0211566000E+00, 8.8508301862E-01],
	[2.6145000000E+04, 1.6636707297E+01, 4.9970744882E+00, 4.2665936599E+00, 2.0218188733E+00, 8.8513916792E-01],
	[2.6150000000E+04, 1.6641790379E+01, 4.9970346451E+00, 4.2692380686E+00, 2.0224810629E+00, 8.8519529040E-01],
	[2.6155000000E+04, 1.6646874042E+01, 4.9969948100E+00, 4.2718836096E+00, 2.0231431685E+00, 8.8525138605E-01],
	[2.6160000000E+04, 1.6651958285E+01, 4.9969549828E+00, 4.2745302832E+00, 2.0238051901E+00, 8.8530745488E-01],
	[2.6165000000E+04, 1.6657043109E+01, 4.9969151635E+00, 4.2771780897E+00, 2.0244671276E+00, 8.8536349692E-01],
	[2.6170000000E+04, 1.6662128514E+01, 4.9968753521E+00, 4.2798270293E+00, 2.0251289809E+00, 8.8541951215E-01],
	[2.6175000000E+04, 1.6667214499E+01, 4.9968355487E+00, 4.2824771023E+00, 2.0257907501E+00, 8.8547550060E-01],
	[2.6180000000E+04, 1.6672301065E+01, 4.9967957531E+00, 4.2851283090E+00, 2.0264524348E+00, 8.8553146228E-01],
	[2.6185000000E+04, 1.6677388212E+01, 4.9967559655E+00, 4.2877806496E+00, 2.0271140352E+00, 8.8558739719E-01],
	[2.6190000000E+04, 1.6682475939E+01, 4.9967161858E+00, 4.2904341244E+00, 2.0277755510E+00, 8.8564330534E-01],
	[2.6195000000E+04, 1.6687564246E+01, 4.9966764141E+00, 4.2930887338E+00, 2.0284369823E+00, 8.8569918674E-01],
	[2.6200000000E+04, 1.6692653134E+01, 4.9966366502E+00, 4.2957444778E+00, 2.0290983289E+00, 8.8575504141E-01],
	[2.6205000000E+04, 1.6697742602E+01, 4.9965968942E+00, 4.2984013569E+00, 2.0297595908E+00, 8.8581086935E-01],
	[2.6210000000E+04, 1.6702832650E+01, 4.9965571461E+00, 4.3010593713E+00, 2.0304207679E+00, 8.8586667057E-01],
	[2.6215000000E+04, 1.6707923279E+01, 4.9965174060E+00, 4.3037185212E+00, 2.0310818600E+00, 8.8592244509E-01],
	[2.6220000000E+04, 1.6713014488E+01, 4.9964776737E+00, 4.3063788069E+00, 2.0317428671E+00, 8.8597819290E-01],
	[2.6225000000E+04, 1.6718106277E+01, 4.9964379493E+00, 4.3090402287E+00, 2.0324037892E+00, 8.8603391403E-01],
	[2.6230000000E+04, 1.6723198646E+01, 4.9963982328E+00, 4.3117027869E+00, 2.0330646262E+00, 8.8608960847E-01],
	[2.6235000000E+04, 1.6728291596E+01, 4.9963585242E+00, 4.3143664817E+00, 2.0337253778E+00, 8.8614527625E-01],
	[2.6240000000E+04, 1.6733385125E+01, 4.9963188234E+00, 4.3170313134E+00, 2.0343860442E+00, 8.8620091736E-01],
	[2.6245000000E+04, 1.6738479234E+01, 4.9962791306E+00, 4.3196972822E+00, 2.0350466252E+00, 8.8625653183E-01],
	[2.6250000000E+04, 1.6743573924E+01, 4.9962394456E+00, 4.3223643885E+00, 2.0357071207E+00, 8.8631211965E-01],
	[2.6255000000E+04, 1.6748669193E+01, 4.9961997685E+00, 4.3250326324E+00, 2.0363675306E+00, 8.8636768084E-01],
	[2.6260000000E+04, 1.6753765042E+01, 4.9961600993E+00, 4.3277020144E+00, 2.0370278549E+00, 8.8642321542E-01],
	[2.6265000000E+04, 1.6758861471E+01, 4.9961204379E+00, 4.3303725345E+00, 2.0376880935E+00, 8.8647872338E-01],
	[2.6270000000E+04, 1.6763958479E+01, 4.9960807844E+00, 4.3330441932E+00, 2.0383482462E+00, 8.8653420473E-01],
	[2.6275000000E+04, 1.6769056068E+01, 4.9960411388E+00, 4.3357169906E+00, 2.0390083131E+00, 8.8658965950E-01],
	[2.6280000000E+04, 1.6774154236E+01, 4.9960015010E+00, 4.3383909270E+00, 2.0396682940E+00, 8.8664508768E-01],
	[2.6285000000E+04, 1.6779252983E+01, 4.9959618711E+00, 4.3410660028E+00, 2.0403281889E+00, 8.8670048929E-01],
	[2.6290000000E+04, 1.6784352310E+01, 4.9959222490E+00, 4.3437422181E+00, 2.0409879976E+00, 8.8675586434E-01],
	[2.6295000000E+04, 1.6789452217E+01, 4.9958826348E+00, 4.3464195733E+00, 2.0416477202E+00, 8.8681121283E-01],
	[2.6300000000E+04, 1.6794552703E+01, 4.9958430284E+00, 4.3490980686E+00, 2.0423073564E+00, 8.8686653479E-01],
	[2.6305000000E+04, 1.6799653769E+01, 4.9958034299E+00, 4.3517777042E+00, 2.0429669063E+00, 8.8692183020E-01],
	[2.6310000000E+04, 1.6804755414E+01, 4.9957638392E+00, 4.3544584805E+00, 2.0436263697E+00, 8.8697709909E-01],
	[2.6315000000E+04, 1.6809857639E+01, 4.9957242563E+00, 4.3571403978E+00, 2.0442857466E+00, 8.8703234147E-01],
	[2.6320000000E+04, 1.6814960443E+01, 4.9956846813E+00, 4.3598234562E+00, 2.0449450369E+00, 8.8708755735E-01],
	[2.6325000000E+04, 1.6820082990E+01, 4.9956481719E+00, 4.3625076560E+00, 2.0456050367E+00, 8.8714274673E-01],
	[2.6330000000E+04, 1.6825208829E+01, 4.9956121010E+00, 4.3651929976E+00, 2.0462650627E+00, 8.8719790962E-01],
	[2.6335000000E+04, 1.6830335256E+01, 4.9955760373E+00, 4.3678794811E+00, 2.0469250028E+00, 8.8725304604E-01],
	[2.6340000000E+04, 1.6835462271E+01, 4.9955399807E+00, 4.3705671069E+00, 2.0475848567E+00, 8.8730815600E-01],
	[2.6345000000E+04, 1.6840589875E+01, 4.9955039311E+00, 4.3732558752E+00, 2.0482446244E+00, 8.8736323949E-01],
	[2.6350000000E+04, 1.6845718067E+01, 4.9954678887E+00, 4.3759457863E+00, 2.0489043058E+00, 8.8741829655E-01],
	[2.6355000000E+04, 1.6850846847E+01, 4.9954318533E+00, 4.3786368405E+00, 2.0495639009E+00, 8.8747332717E-01],
	[2.6360000000E+04, 1.6855976215E+01, 4.9953958251E+00, 4.3813290380E+00, 2.0502234095E+00, 8.8752833136E-01],
	[2.6365000000E+04, 1.6861106171E+01, 4.9953598040E+00, 4.3840223791E+00, 2.0508828317E+00, 8.8758330913E-01],
	[2.6370000000E+04, 1.6866236715E+01, 4.9953237899E+00, 4.3867168641E+00, 2.0515421672E+00, 8.8763826050E-01],
	[2.6375000000E+04, 1.6871367847E+01, 4.9952877829E+00, 4.3894124932E+00, 2.0522014160E+00, 8.8769318548E-01],
	[2.6380000000E+04, 1.6876499567E+01, 4.9952517830E+00, 4.3921092667E+00, 2.0528605781E+00, 8.8774808406E-01],
	[2.6385000000E+04, 1.6881631875E+01, 4.9952157902E+00, 4.3948071848E+00, 2.0535196534E+00, 8.8780295627E-01],
	[2.6390000000E+04, 1.6886764771E+01, 4.9951798045E+00, 4.3975062479E+00, 2.0541786418E+00, 8.8785780212E-01],
	[2.6395000000E+04, 1.6891898255E+01, 4.9951438259E+00, 4.4002064562E+00, 2.0548375431E+00, 8.8791262160E-01],
	[2.6400000000E+04, 1.6897032326E+01, 4.9951078543E+00, 4.4029078100E+00, 2.0554963574E+00, 8.8796741474E-01],
	[2.6405000000E+04, 1.6902166985E+01, 4.9950718898E+00, 4.4056103095E+00, 2.0561550846E+00, 8.8802218155E-01],
	[2.6410000000E+04, 1.6907302232E+01, 4.9950359324E+00, 4.4083139551E+00, 2.0568137245E+00, 8.8807692202E-01],
	[2.6415000000E+04, 1.6912438067E+01, 4.9949999820E+00, 4.4110187469E+00, 2.0574722771E+00, 8.8813163618E-01],
	[2.6420000000E+04, 1.6917574489E+01, 4.9949640387E+00, 4.4137246852E+00, 2.0581307423E+00, 8.8818632403E-01],
	[2.6425000000E+04, 1.6922711498E+01, 4.9949281024E+00, 4.4164317704E+00, 2.0587891201E+00, 8.8824098559E-01],
	[2.6430000000E+04, 1.6927849096E+01, 4.9948921733E+00, 4.4191400027E+00, 2.0594474103E+00, 8.8829562085E-01],
	[2.6435000000E+04, 1.6932987280E+01, 4.9948562511E+00, 4.4218493823E+00, 2.0601056129E+00, 8.8835022984E-01],
	[2.6440000000E+04, 1.6938126052E+01, 4.9948203360E+00, 4.4245599095E+00, 2.0607637278E+00, 8.8840481256E-01],
	[2.6445000000E+04, 1.6943265411E+01, 4.9947844280E+00, 4.4272715847E+00, 2.0614217549E+00, 8.8845936902E-01],
	[2.6450000000E+04, 1.6948405358E+01, 4.9947485270E+00, 4.4299844080E+00, 2.0620796942E+00, 8.8851389924E-01],
	[2.6455000000E+04, 1.6953545892E+01, 4.9947126331E+00, 4.4326983797E+00, 2.0627375455E+00, 8.8856840322E-01],
	[2.6460000000E+04, 1.6958687013E+01, 4.9946767462E+00, 4.4354135001E+00, 2.0633953089E+00, 8.8862288097E-01],
	[2.6465000000E+04, 1.6963828722E+01, 4.9946408663E+00, 4.4381297695E+00, 2.0640529841E+00, 8.8867733250E-01],
	[2.6470000000E+04, 1.6968971017E+01, 4.9946049935E+00, 4.4408471881E+00, 2.0647105712E+00, 8.8873175783E-01],
	[2.6475000000E+04, 1.6974113900E+01, 4.9945691277E+00, 4.4435657562E+00, 2.0653680700E+00, 8.8878615695E-01],
	[2.6480000000E+04, 1.6979257369E+01, 4.9945332689E+00, 4.4462854741E+00, 2.0660254805E+00, 8.8884052989E-01],
	[2.6485000000E+04, 1.6984401426E+01, 4.9944974172E+00, 4.4490063420E+00, 2.0666828027E+00, 8.8889487665E-01],
	[2.6490000000E+04, 1.6989546070E+01, 4.9944615725E+00, 4.4517283603E+00, 2.0673400363E+00, 8.8894919725E-01],
	[2.6495000000E+04, 1.6994691300E+01, 4.9944257348E+00, 4.4544515291E+00, 2.0679971814E+00, 8.8900349168E-01],
	[2.6500000000E+04, 1.6999837118E+01, 4.9943899041E+00, 4.4571758488E+00, 2.0686542379E+00, 8.8905775997E-01],
	[2.6505000000E+04, 1.7004983522E+01, 4.9943540805E+00, 4.4599013195E+00, 2.0693112056E+00, 8.8911200212E-01],
	[2.6510000000E+04, 1.7010130513E+01, 4.9943182639E+00, 4.4626279417E+00, 2.0699680846E+00, 8.8916621814E-01],
	[2.6515000000E+04, 1.7015278091E+01, 4.9942824542E+00, 4.4653557155E+00, 2.0706248747E+00, 8.8922040805E-01],
	[2.6520000000E+04, 1.7020426256E+01, 4.9942466516E+00, 4.4680846412E+00, 2.0712815759E+00, 8.8927457184E-01],
	[2.6525000000E+04, 1.7025575007E+01, 4.9942108560E+00, 4.4708147192E+00, 2.0719381880E+00, 8.8932870954E-01],
	[2.6530000000E+04, 1.7030724345E+01, 4.9941750674E+00, 4.4735459495E+00, 2.0725947111E+00, 8.8938282116E-01],
	[2.6535000000E+04, 1.7035874270E+01, 4.9941392858E+00, 4.4762783326E+00, 2.0732511450E+00, 8.8943690669E-01],
	[2.6540000000E+04, 1.7041024781E+01, 4.9941035112E+00, 4.4790118687E+00, 2.0739074896E+00, 8.8949096616E-01],
	[2.6545000000E+04, 1.7046175878E+01, 4.9940677436E+00, 4.4817465581E+00, 2.0745637450E+00, 8.8954499957E-01],
	[2.6550000000E+04, 1.7051327562E+01, 4.9940319830E+00, 4.4844824010E+00, 2.0752199109E+00, 8.8959900693E-01],
	[2.6555000000E+04, 1.7056479832E+01, 4.9939962293E+00, 4.4872193977E+00, 2.0758759874E+00, 8.8965298825E-01],
	[2.6560000000E+04, 1.7061632689E+01, 4.9939604827E+00, 4.4899575485E+00, 2.0765319743E+00, 8.8970694355E-01],
	[2.6565000000E+04, 1.7066786132E+01, 4.9939247430E+00, 4.4926968536E+00, 2.0771878716E+00, 8.8976087283E-01],
	[2.6570000000E+04, 1.7071940162E+01, 4.9938890103E+00, 4.4954373133E+00, 2.0778436792E+00, 8.8981477610E-01],
	[2.6575000000E+04, 1.7077094777E+01, 4.9938532846E+00, 4.4981789279E+00, 2.0784993970E+00, 8.8986865338E-01],
	[2.6580000000E+04, 1.7082249979E+01, 4.9938175659E+00, 4.5009216977E+00, 2.0791550249E+00, 8.8992250467E-01],
	[2.6585000000E+04, 1.7087405767E+01, 4.9937818542E+00, 4.5036656228E+00, 2.0798105630E+00, 8.8997632998E-01],
	[2.6590000000E+04, 1.7092562141E+01, 4.9937461494E+00, 4.5064107037E+00, 2.0804660110E+00, 8.9003012933E-01],
	[2.6595000000E+04, 1.7097719101E+01, 4.9937104516E+00, 4.5091569404E+00, 2.0811213689E+00, 8.9008390272E-01],
	[2.6600000000E+04, 1.7102876647E+01, 4.9936747608E+00, 4.5119043335E+00, 2.0817766367E+00, 8.9013765016E-01],
	[2.6605000000E+04, 1.7108034779E+01, 4.9936390769E+00, 4.5146528830E+00, 2.0824318143E+00, 8.9019137167E-01],
	[2.6610000000E+04, 1.7113193497E+01, 4.9936034000E+00, 4.5174025892E+00, 2.0830869015E+00, 8.9024506725E-01],
	[2.6615000000E+04, 1.7118352800E+01, 4.9935677300E+00, 4.5201534525E+00, 2.0837418984E+00, 8.9029873691E-01],
	[2.6620000000E+04, 1.7123512690E+01, 4.9935320670E+00, 4.5229054731E+00, 2.0843968048E+00, 8.9035238067E-01],
	[2.6625000000E+04, 1.7128673166E+01, 4.9934964109E+00, 4.5256586513E+00, 2.0850516207E+00, 8.9040599853E-01],
	[2.6630000000E+04, 1.7133834227E+01, 4.9934607618E+00, 4.5284129873E+00, 2.0857063460E+00, 8.9045959051E-01],
	[2.6635000000E+04, 1.7138995874E+01, 4.9934251197E+00, 4.5311684814E+00, 2.0863609806E+00, 8.9051315661E-01],
	[2.6640000000E+04, 1.7144158106E+01, 4.9933894845E+00, 4.5339251339E+00, 2.0870155245E+00, 8.9056669685E-01],
	[2.6645000000E+04, 1.7149320924E+01, 4.9933538562E+00, 4.5366829450E+00, 2.0876699775E+00, 8.9062021123E-01],
	[2.6650000000E+04, 1.7154484328E+01, 4.9933182349E+00, 4.5394419150E+00, 2.0883243396E+00, 8.9067369977E-01],
	[2.6655000000E+04, 1.7159648318E+01, 4.9932826205E+00, 4.5422020442E+00, 2.0889786107E+00, 8.9072716247E-01],
	[2.6660000000E+04, 1.7164812892E+01, 4.9932470130E+00, 4.5449633329E+00, 2.0896327908E+00, 8.9078059935E-01],
	[2.6665000000E+04, 1.7169978053E+01, 4.9932114125E+00, 4.5477257813E+00, 2.0902868797E+00, 8.9083401041E-01],
	[2.6670000000E+04, 1.7175143798E+01, 4.9931758189E+00, 4.5504893896E+00, 2.0909408775E+00, 8.9088739567E-01],
	[2.6675000000E+04, 1.7180310129E+01, 4.9931402322E+00, 4.5532541582E+00, 2.0915947839E+00, 8.9094075514E-01],
	[2.6680000000E+04, 1.7185477045E+01, 4.9931046525E+00, 4.5560200874E+00, 2.0922485991E+00, 8.9099408882E-01],
	[2.6685000000E+04, 1.7190644547E+01, 4.9930690796E+00, 4.5587871773E+00, 2.0929023228E+00, 8.9104739673E-01],
	[2.6690000000E+04, 1.7195812634E+01, 4.9930335137E+00, 4.5615554283E+00, 2.0935559549E+00, 8.9110067888E-01],
	[2.6695000000E+04, 1.7200981306E+01, 4.9929979547E+00, 4.5643248407E+00, 2.0942094956E+00, 8.9115393527E-01],
	[2.6700000000E+04, 1.7206150563E+01, 4.9929624027E+00, 4.5670954146E+00, 2.0948629445E+00, 8.9120716592E-01],
	[2.6705000000E+04, 1.7211320405E+01, 4.9929268575E+00, 4.5698671504E+00, 2.0955163018E+00, 8.9126037084E-01],
	[2.6710000000E+04, 1.7216490833E+01, 4.9928913192E+00, 4.5726400484E+00, 2.0961695673E+00, 8.9131355003E-01],
	[2.6715000000E+04, 1.7221661845E+01, 4.9928557879E+00, 4.5754141088E+00, 2.0968227408E+00, 8.9136670351E-01],
	[2.6720000000E+04, 1.7226833442E+01, 4.9928202634E+00, 4.5781893318E+00, 2.0974758225E+00, 8.9141983130E-01],
	[2.6725000000E+04, 1.7232005624E+01, 4.9927847458E+00, 4.5809657178E+00, 2.0981288121E+00, 8.9147293338E-01],
	[2.6730000000E+04, 1.7237178391E+01, 4.9927492352E+00, 4.5837432670E+00, 2.0987817097E+00, 8.9152600979E-01],
	[2.6735000000E+04, 1.7242351743E+01, 4.9927137314E+00, 4.5865219797E+00, 2.0994345151E+00, 8.9157906053E-01],
	[2.6740000000E+04, 1.7247525680E+01, 4.9926782345E+00, 4.5893018562E+00, 2.1000872282E+00, 8.9163208561E-01],
	[2.6745000000E+04, 1.7252703056E+01, 4.9926431942E+00, 4.5920828966E+00, 2.1007399710E+00, 8.9168508503E-01],
	[2.6750000000E+04, 1.7257899935E+01, 4.9926111394E+00, 4.5948651014E+00, 2.1013934297E+00, 8.9173805882E-01],
	[2.6755000000E+04, 1.7263097407E+01, 4.9925790909E+00, 4.5976484708E+00, 2.1020467967E+00, 8.9179100697E-01],
	[2.6760000000E+04, 1.7268295473E+01, 4.9925470485E+00, 4.6004330049E+00, 2.1027000720E+00, 8.9184392951E-01],
	[2.6765000000E+04, 1.7273494132E+01, 4.9925150124E+00, 4.6032187042E+00, 2.1033532555E+00, 8.9189682643E-01],
	[2.6770000000E+04, 1.7278693385E+01, 4.9924829824E+00, 4.6060055688E+00, 2.1040063472E+00, 8.9194969776E-01],
	[2.6775000000E+04, 1.7283893231E+01, 4.9924509586E+00, 4.6087935991E+00, 2.1046593468E+00, 8.9200254350E-01],
	[2.6780000000E+04, 1.7289093671E+01, 4.9924189410E+00, 4.6115827953E+00, 2.1053122545E+00, 8.9205536366E-01],
	[2.6785000000E+04, 1.7294294705E+01, 4.9923869296E+00, 4.6143731577E+00, 2.1059650701E+00, 8.9210815825E-01],
	[2.6790000000E+04, 1.7299496331E+01, 4.9923549244E+00, 4.6171646865E+00, 2.1066177935E+00, 8.9216092728E-01],
	[2.6795000000E+04, 1.7304698551E+01, 4.9923229253E+00, 4.6199573821E+00, 2.1072704246E+00, 8.9221367077E-01],
	[2.6800000000E+04, 1.7309901365E+01, 4.9922909324E+00, 4.6227512446E+00, 2.1079229635E+00, 8.9226638871E-01],
	[2.6805000000E+04, 1.7315104771E+01, 4.9922589457E+00, 4.6255462744E+00, 2.1085754100E+00, 8.9231908114E-01],
	[2.6810000000E+04, 1.7320308771E+01, 4.9922269652E+00, 4.6283424717E+00, 2.1092277640E+00, 8.9237174804E-01],
	[2.6815000000E+04, 1.7325513364E+01, 4.9921949908E+00, 4.6311398368E+00, 2.1098800255E+00, 8.9242438944E-01],
	[2.6820000000E+04, 1.7330718550E+01, 4.9921630226E+00, 4.6339383700E+00, 2.1105321944E+00, 8.9247700534E-01],
	[2.6825000000E+04, 1.7335924330E+01, 4.9921310605E+00, 4.6367380715E+00, 2.1111842706E+00, 8.9252959576E-01],
	[2.6830000000E+04, 1.7341130702E+01, 4.9920991047E+00, 4.6395389417E+00, 2.1118362541E+00, 8.9258216070E-01],
	[2.6835000000E+04, 1.7346337667E+01, 4.9920671549E+00, 4.6423409806E+00, 2.1124881448E+00, 8.9263470017E-01],
	[2.6840000000E+04, 1.7351545225E+01, 4.9920352114E+00, 4.6451441888E+00, 2.1131399426E+00, 8.9268721420E-01],
	[2.6845000000E+04, 1.7356753376E+01, 4.9920032740E+00, 4.6479485663E+00, 2.1137916474E+00, 8.9273970277E-01],
	[2.6850000000E+04, 1.7361962120E+01, 4.9919713427E+00, 4.6507541136E+00, 2.1144432592E+00, 8.9279216592E-01],
	[2.6855000000E+04, 1.7367171457E+01, 4.9919394176E+00, 4.6535608307E+00, 2.1150947780E+00, 8.9284460364E-01],
	[2.6860000000E+04, 1.7372381386E+01, 4.9919074986E+00, 4.6563687182E+00, 2.1157462035E+00, 8.9289701594E-01],
	[2.6865000000E+04, 1.7377591909E+01, 4.9918755858E+00, 4.6591777760E+00, 2.1163975358E+00, 8.9294940285E-01],
	[2.6870000000E+04, 1.7382803024E+01, 4.9918436792E+00, 4.6619880047E+00, 2.1170487748E+00, 8.9300176436E-01],
	[2.6875000000E+04, 1.7388014731E+01, 4.9918117786E+00, 4.6647994044E+00, 2.1176999204E+00, 8.9305410049E-01],
	[2.6880000000E+04, 1.7393227032E+01, 4.9917798842E+00, 4.6676119754E+00, 2.1183509726E+00, 8.9310641125E-01],
	[2.6885000000E+04, 1.7398439924E+01, 4.9917479960E+00, 4.6704257179E+00, 2.1190019312E+00, 8.9315869664E-01],
	[2.6890000000E+04, 1.7403653410E+01, 4.9917161139E+00, 4.6732406323E+00, 2.1196527963E+00, 8.9321095669E-01],
	[2.6895000000E+04, 1.7408867487E+01, 4.9916842379E+00, 4.6760567188E+00, 2.1203035677E+00, 8.9326319140E-01],
	[2.6900000000E+04, 1.7414082158E+01, 4.9916523680E+00, 4.6788739777E+00, 2.1209542453E+00, 8.9331540077E-01],
	[2.6905000000E+04, 1.7419297420E+01, 4.9916205043E+00, 4.6816924092E+00, 2.1216048291E+00, 8.9336758483E-01],
	[2.6910000000E+04, 1.7424513275E+01, 4.9915886466E+00, 4.6845120137E+00, 2.1222553191E+00, 8.9341974357E-01],
	[2.6915000000E+04, 1.7429729723E+01, 4.9915567952E+00, 4.6873327913E+00, 2.1229057151E+00, 8.9347187702E-01],
	[2.6920000000E+04, 1.7434946762E+01, 4.9915249498E+00, 4.6901547424E+00, 2.1235560171E+00, 8.9352398518E-01],
	[2.6925000000E+04, 1.7440164394E+01, 4.9914931105E+00, 4.6929778672E+00, 2.1242062250E+00, 8.9357606806E-01],
	[2.6930000000E+04, 1.7445382618E+01, 4.9914612774E+00, 4.6958021661E+00, 2.1248563388E+00, 8.9362812567E-01],
	[2.6935000000E+04, 1.7450601434E+01, 4.9914294504E+00, 4.6986276391E+00, 2.1255063583E+00, 8.9368015803E-01],
	[2.6940000000E+04, 1.7455820842E+01, 4.9913976295E+00, 4.7014542867E+00, 2.1261562835E+00, 8.9373216514E-01],
	[2.6945000000E+04, 1.7461040842E+01, 4.9913658146E+00, 4.7042821092E+00, 2.1268061144E+00, 8.9378414701E-01],
	[2.6950000000E+04, 1.7466261435E+01, 4.9913340059E+00, 4.7071111067E+00, 2.1274558508E+00, 8.9383610366E-01],
	[2.6955000000E+04, 1.7471482619E+01, 4.9913022033E+00, 4.7099412795E+00, 2.1281054927E+00, 8.9388803509E-01],
	[2.6960000000E+04, 1.7476704395E+01, 4.9912704068E+00, 4.7127726280E+00, 2.1287550401E+00, 8.9393994132E-01],
	[2.6965000000E+04, 1.7481926763E+01, 4.9912386165E+00, 4.7156051523E+00, 2.1294044928E+00, 8.9399182235E-01],
	[2.6970000000E+04, 1.7487149723E+01, 4.9912068321E+00, 4.7184388528E+00, 2.1300538508E+00, 8.9404367820E-01],
	[2.6975000000E+04, 1.7492373274E+01, 4.9911750539E+00, 4.7212737297E+00, 2.1307031140E+00, 8.9409550888E-01],
	[2.6980000000E+04, 1.7497597418E+01, 4.9911432818E+00, 4.7241097833E+00, 2.1313522823E+00, 8.9414731439E-01],
	[2.6985000000E+04, 1.7502822153E+01, 4.9911115158E+00, 4.7269470139E+00, 2.1320013557E+00, 8.9419909475E-01],
	[2.6990000000E+04, 1.7508047480E+01, 4.9910797559E+00, 4.7297854217E+00, 2.1326503342E+00, 8.9425084996E-01],
	[2.6995000000E+04, 1.7513273398E+01, 4.9910480020E+00, 4.7326250070E+00, 2.1332992175E+00, 8.9430258005E-01],
	[2.7000000000E+04, 1.7518499908E+01, 4.9910162542E+00, 4.7354657701E+00, 2.1339480058E+00, 8.9435428501E-01],
	[2.7005000000E+04, 1.7523727009E+01, 4.9909845126E+00, 4.7383077112E+00, 2.1345966988E+00, 8.9440596487E-01],
	[2.7010000000E+04, 1.7528954702E+01, 4.9909527769E+00, 4.7411508306E+00, 2.1352452966E+00, 8.9445761962E-01],
	[2.7015000000E+04, 1.7534182987E+01, 4.9909210474E+00, 4.7439951287E+00, 2.1358937991E+00, 8.9450924928E-01],
	[2.7020000000E+04, 1.7539411863E+01, 4.9908893239E+00, 4.7468406055E+00, 2.1365422061E+00, 8.9456085387E-01],
	[2.7025000000E+04, 1.7544641330E+01, 4.9908576066E+00, 4.7496872615E+00, 2.1371905177E+00, 8.9461243338E-01],
	[2.7030000000E+04, 1.7549871388E+01, 4.9908258952E+00, 4.7525350969E+00, 2.1378387337E+00, 8.9466398784E-01],
	[2.7035000000E+04, 1.7555102038E+01, 4.9907941900E+00, 4.7553841120E+00, 2.1384868541E+00, 8.9471551725E-01],
	[2.7040000000E+04, 1.7560333279E+01, 4.9907624908E+00, 4.7582343070E+00, 2.1391348789E+00, 8.9476702162E-01],
	[2.7045000000E+04, 1.7565565112E+01, 4.9907307977E+00, 4.7610856821E+00, 2.1397828079E+00, 8.9481850096E-01],
	[2.7050000000E+04, 1.7570797535E+01, 4.9906991106E+00, 4.7639382378E+00, 2.1404306411E+00, 8.9486995529E-01],
	[2.7055000000E+04, 1.7576030550E+01, 4.9906674296E+00, 4.7667919742E+00, 2.1410783784E+00, 8.9492138461E-01],
	[2.7060000000E+04, 1.7581264155E+01, 4.9906357546E+00, 4.7696468916E+00, 2.1417260197E+00, 8.9497278894E-01],
	[2.7065000000E+04, 1.7586498352E+01, 4.9906040857E+00, 4.7725029903E+00, 2.1423735651E+00, 8.9502416828E-01],
	[2.7070000000E+04, 1.7591733139E+01, 4.9905724229E+00, 4.7753602705E+00, 2.1430210143E+00, 8.9507552265E-01],
	[2.7075000000E+04, 1.7596968518E+01, 4.9905407661E+00, 4.7782187326E+00, 2.1436683674E+00, 8.9512685205E-01],
	[2.7080000000E+04, 1.7602204488E+01, 4.9905091153E+00, 4.7810783768E+00, 2.1443156243E+00, 8.9517815651E-01],
	[2.7085000000E+04, 1.7607441048E+01, 4.9904774706E+00, 4.7839392033E+00, 2.1449627849E+00, 8.9522943601E-01],
	[2.7090000000E+04, 1.7612678199E+01, 4.9904458320E+00, 4.7868012124E+00, 2.1456098492E+00, 8.9528069059E-01],
	[2.7095000000E+04, 1.7617915941E+01, 4.9904141993E+00, 4.7896644045E+00, 2.1462568170E+00, 8.9533192025E-01],
	[2.7100000000E+04, 1.7623154274E+01, 4.9903825727E+00, 4.7925287797E+00, 2.1469036883E+00, 8.9538312499E-01],
	[2.7105000000E+04, 1.7628393197E+01, 4.9903509522E+00, 4.7953943384E+00, 2.1475504631E+00, 8.9543430483E-01],
	[2.7110000000E+04, 1.7633632711E+01, 4.9903193377E+00, 4.7982610808E+00, 2.1481971412E+00, 8.9548545979E-01],
	[2.7115000000E+04, 1.7638872816E+01, 4.9902877292E+00, 4.8011290072E+00, 2.1488437227E+00, 8.9553658986E-01],
	[2.7120000000E+04, 1.7644113511E+01, 4.9902561267E+00, 4.8039981178E+00, 2.1494902074E+00, 8.9558769506E-01],
	[2.7125000000E+04, 1.7649354796E+01, 4.9902245303E+00, 4.8068684129E+00, 2.1501365953E+00, 8.9563877541E-01],
	[2.7130000000E+04, 1.7654596673E+01, 4.9901929398E+00, 4.8097398929E+00, 2.1507828863E+00, 8.9568983091E-01],
	[2.7135000000E+04, 1.7659839139E+01, 4.9901613554E+00, 4.8126125579E+00, 2.1514290803E+00, 8.9574086157E-01],
	[2.7140000000E+04, 1.7665082196E+01, 4.9901297771E+00, 4.8154864082E+00, 2.1520751773E+00, 8.9579186741E-01],
	[2.7145000000E+04, 1.7670325843E+01, 4.9900982047E+00, 4.8183614441E+00, 2.1527211772E+00, 8.9584284842E-01],
	[2.7150000000E+04, 1.7675570081E+01, 4.9900666384E+00, 4.8212376659E+00, 2.1533670800E+00, 8.9589380463E-01],
	[2.7155000000E+04, 1.7680814909E+01, 4.9900350780E+00, 4.8241150739E+00, 2.1540128855E+00, 8.9594473604E-01],
	[2.7160000000E+04, 1.7686060327E+01, 4.9900035237E+00, 4.8269936683E+00, 2.1546585938E+00, 8.9599564266E-01],
	[2.7165000000E+04, 1.7691306335E+01, 4.9899719754E+00, 4.8298734493E+00, 2.1553042046E+00, 8.9604652450E-01],
	[2.7170000000E+04, 1.7696552934E+01, 4.9899404331E+00, 4.8327544173E+00, 2.1559497181E+00, 8.9609738157E-01],
	[2.7175000000E+04, 1.7701800591E+01, 4.9899089697E+00, 4.8356365726E+00, 2.1565951547E+00, 8.9614821388E-01],
	[2.7180000000E+04, 1.7707070042E+01, 4.9898808084E+00, 4.8385199153E+00, 2.1572414244E+00, 8.9619902143E-01],
	[2.7185000000E+04, 1.7712340092E+01, 4.9898526524E+00, 4.8414044458E+00, 2.1578875974E+00, 8.9624980425E-01],
	[2.7190000000E+04, 1.7717610741E+01, 4.9898245017E+00, 4.8442901643E+00, 2.1585336734E+00, 8.9630056233E-01],
	[2.7195000000E+04, 1.7722881989E+01, 4.9897963564E+00, 4.8471770711E+00, 2.1591796525E+00, 8.9635129569E-01],
	[2.7200000000E+04, 1.7728153835E+01, 4.9897682165E+00, 4.8500651666E+00, 2.1598255345E+00, 8.9640200433E-01],
	[2.7205000000E+04, 1.7733426280E+01, 4.9897400818E+00, 4.8529544508E+00, 2.1604713194E+00, 8.9645268827E-01],
	[2.7210000000E+04, 1.7738699324E+01, 4.9897119525E+00, 4.8558449242E+00, 2.1611170072E+00, 8.9650334752E-01],
	[2.7215000000E+04, 1.7743972966E+01, 4.9896838285E+00, 4.8587365870E+00, 2.1617625977E+00, 8.9655398208E-01],
	[2.7220000000E+04, 1.7749247207E+01, 4.9896557099E+00, 4.8616294394E+00, 2.1624080910E+00, 8.9660459197E-01],
	[2.7225000000E+04, 1.7754522047E+01, 4.9896275965E+00, 4.8645234817E+00, 2.1630534868E+00, 8.9665517719E-01],
	[2.7230000000E+04, 1.7759797485E+01, 4.9895994885E+00, 4.8674187143E+00, 2.1636987853E+00, 8.9670573775E-01],
	[2.7235000000E+04, 1.7765073522E+01, 4.9895713858E+00, 4.8703151373E+00, 2.1643439862E+00, 8.9675627367E-01],
	[2.7240000000E+04, 1.7770350157E+01, 4.9895432884E+00, 4.8732127511E+00, 2.1649890896E+00, 8.9680678495E-01],
	[2.7245000000E+04, 1.7775627390E+01, 4.9895151964E+00, 4.8761115558E+00, 2.1656340953E+00, 8.9685727160E-01],
	[2.7250000000E+04, 1.7780905222E+01, 4.9894871096E+00, 4.8790115519E+00, 2.1662790034E+00, 8.9690773364E-01],
	[2.7255000000E+04, 1.7786183652E+01, 4.9894590282E+00, 4.8819127395E+00, 2.1669238137E+00, 8.9695817106E-01],
	[2.7260000000E+04, 1.7791462681E+01, 4.9894309521E+00, 4.8848151189E+00, 2.1675685262E+00, 8.9700858389E-01],
	[2.7265000000E+04, 1.7796742307E+01, 4.9894028812E+00, 4.8877186904E+00, 2.1682131408E+00, 8.9705897213E-01],
	[2.7270000000E+04, 1.7802022532E+01, 4.9893748157E+00, 4.8906234543E+00, 2.1688576575E+00, 8.9710933578E-01],
	[2.7275000000E+04, 1.7807303355E+01, 4.9893467555E+00, 4.8935294108E+00, 2.1695020761E+00, 8.9715967487E-01],
	[2.7280000000E+04, 1.7812584776E+01, 4.9893187006E+00, 4.8964365602E+00, 2.1701463967E+00, 8.9720998940E-01],
	[2.7285000000E+04, 1.7817866795E+01, 4.9892906510E+00, 4.8993449028E+00, 2.1707906191E+00, 8.9726027938E-01],
	[2.7290000000E+04, 1.7823149412E+01, 4.9892626066E+00, 4.9022544388E+00, 2.1714347434E+00, 8.9731054481E-01],
	[2.7295000000E+04, 1.7828432628E+01, 4.9892345676E+00, 4.9051651686E+00, 2.1720787693E+00, 8.9736078571E-01],
	[2.7300000000E+04, 1.7833716441E+01, 4.9892065339E+00, 4.9080770923E+00, 2.1727226969E+00, 8.9741100210E-01],
	[2.7305000000E+04, 1.7839000852E+01, 4.9891785055E+00, 4.9109902103E+00, 2.1733665262E+00, 8.9746119397E-01],
	[2.7310000000E+04, 1.7844285860E+01, 4.9891504823E+00, 4.9139045228E+00, 2.1740102569E+00, 8.9751136133E-01],
	[2.7315000000E+04, 1.7849571467E+01, 4.9891224644E+00, 4.9168200301E+00, 2.1746538892E+00, 8.9756150421E-01],
	[2.7320000000E+04, 1.7854857671E+01, 4.9890944519E+00, 4.9197367325E+00, 2.1752974228E+00, 8.9761162260E-01],
	[2.7325000000E+04, 1.7860144473E+01, 4.9890664446E+00, 4.9226546302E+00, 2.1759408578E+00, 8.9766171651E-01],
	[2.7330000000E+04, 1.7865431873E+01, 4.9890384426E+00, 4.9255737235E+00, 2.1765841941E+00, 8.9771178597E-01],
	[2.7335000000E+04, 1.7870719870E+01, 4.9890104458E+00, 4.9284940127E+00, 2.1772274316E+00, 8.9776183096E-01],
	[2.7340000000E+04, 1.7876008465E+01, 4.9889824544E+00, 4.9314154981E+00, 2.1778705702E+00, 8.9781185152E-01],
	[2.7345000000E+04, 1.7881297658E+01, 4.9889544682E+00, 4.9343381799E+00, 2.1785136099E+00, 8.9786184764E-01],
	[2.7350000000E+04, 1.7886587448E+01, 4.9889264873E+00, 4.9372620583E+00, 2.1791565507E+00, 8.9791181933E-01],
	[2.7355000000E+04, 1.7891877836E+01, 4.9888985117E+00, 4.9401871338E+00, 2.1797993925E+00, 8.9796176661E-01],
	[2.7360000000E+04, 1.7897168821E+01, 4.9888705413E+00, 4.9431134064E+00, 2.1804421351E+00, 8.9801168948E-01],
	[2.7365000000E+04, 1.7902460403E+01, 4.9888425762E+00, 4.9460408766E+00, 2.1810847786E+00, 8.9806158795E-01],
	[2.7370000000E+04, 1.7907752583E+01, 4.9888146164E+00, 4.9489695445E+00, 2.1817273228E+00, 8.9811146204E-01],
	[2.7375000000E+04, 1.7913045360E+01, 4.9887866618E+00, 4.9518994105E+00, 2.1823697678E+00, 8.9816131175E-01],
	[2.7380000000E+04, 1.7918338734E+01, 4.9887587125E+00, 4.9548304748E+00, 2.1830121134E+00, 8.9821113710E-01],
	[2.7385000000E+04, 1.7923632705E+01, 4.9887307685E+00, 4.9577627377E+00, 2.1836543596E+00, 8.9826093808E-01],
	[2.7390000000E+04, 1.7928927274E+01, 4.9887028297E+00, 4.9606966632E+00, 2.1842965963E+00, 8.9831071472E-01],
	[2.7395000000E+04, 1.7934222440E+01, 4.9886748962E+00, 4.9636319192E+00, 2.1849387587E+00, 8.9836046702E-01],
	[2.7400000000E+04, 1.7939518203E+01, 4.9886469679E+00, 4.9665683752E+00, 2.1855808216E+00, 8.9841019500E-01],
	[2.7405000000E+04, 1.7944814563E+01, 4.9886190449E+00, 4.9695060315E+00, 2.1862227847E+00, 8.9845989865E-01],
	[2.7410000000E+04, 1.7950111520E+01, 4.9885911271E+00, 4.9724448884E+00, 2.1868646482E+00, 8.9850957800E-01],
	[2.7415000000E+04, 1.7955409074E+01, 4.9885632146E+00, 4.9753849461E+00, 2.1875064118E+00, 8.9855923304E-01],
	[2.7420000000E+04, 1.7960707225E+01, 4.9885353073E+00, 4.9783262049E+00, 2.1881480755E+00, 8.9860886380E-01],
	[2.7425000000E+04, 1.7966005972E+01, 4.9885074053E+00, 4.9812686651E+00, 2.1887896394E+00, 8.9865847028E-01],
	[2.7430000000E+04, 1.7971305317E+01, 4.9884795085E+00, 4.9842123270E+00, 2.1894311032E+00, 8.9870805249E-01],
	[2.7435000000E+04, 1.7976605258E+01, 4.9884516169E+00, 4.9871571908E+00, 2.1900724670E+00, 8.9875761043E-01],
	[2.7440000000E+04, 1.7981905797E+01, 4.9884237306E+00, 4.9901032568E+00, 2.1907137307E+00, 8.9880714413E-01],
	[2.7445000000E+04, 1.7987206932E+01, 4.9883958495E+00, 4.9930505253E+00, 2.1913548942E+00, 8.9885665359E-01],
	[2.7450000000E+04, 1.7992508663E+01, 4.9883679737E+00, 4.9959989965E+00, 2.1919959575E+00, 8.9890613882E-01],
	[2.7455000000E+04, 1.7997810991E+01, 4.9883401031E+00, 4.9989486707E+00, 2.1926369204E+00, 8.9895559982E-01],
	[2.7460000000E+04, 1.8003113916E+01, 4.9883122377E+00, 5.0018995482E+00, 2.1932777830E+00, 8.9900503662E-01],
	[2.7465000000E+04, 1.8008417438E+01, 4.9882843776E+00, 5.0048516292E+00, 2.1939185452E+00, 8.9905444921E-01],
	[2.7470000000E+04, 1.8013721556E+01, 4.9882565227E+00, 5.0078049141E+00, 2.1945592069E+00, 8.9910383761E-01],
	[2.7475000000E+04, 1.8019026270E+01, 4.9882286730E+00, 5.0107594031E+00, 2.1951997681E+00, 8.9915320183E-01],
	[2.7480000000E+04, 1.8024331581E+01, 4.9882008285E+00, 5.0137150964E+00, 2.1958402287E+00, 8.9920254188E-01],
	[2.7485000000E+04, 1.8029637488E+01, 4.9881729892E+00, 5.0166719944E+00, 2.1964805886E+00, 8.9925185777E-01],
	[2.7490000000E+04, 1.8034943991E+01, 4.9881451552E+00, 5.0196300972E+00, 2.1971208477E+00, 8.9930114950E-01],
	[2.7495000000E+04, 1.8040251091E+01, 4.9881173264E+00, 5.0225894053E+00, 2.1977610061E+00, 8.9935041709E-01],
	[2.7500000000E+04, 1.8045558787E+01, 4.9880895028E+00, 5.0255499188E+00, 2.1984010636E+00, 8.9939966055E-01],
	[2.7505000000E+04, 1.8050867080E+01, 4.9880616844E+00, 5.0285116381E+00, 2.1990410203E+00, 8.9944887989E-01],
	[2.7510000000E+04, 1.8056175968E+01, 4.9880338712E+00, 5.0314745633E+00, 2.1996808759E+00, 8.9949807511E-01],
	[2.7515000000E+04, 1.8061485453E+01, 4.9880060633E+00, 5.0344386948E+00, 2.2003206305E+00, 8.9954724623E-01],
	[2.7520000000E+04, 1.8066795534E+01, 4.9879782605E+00, 5.0374040328E+00, 2.2009602840E+00, 8.9959639326E-01],
	[2.7525000000E+04, 1.8072106211E+01, 4.9879504630E+00, 5.0403705777E+00, 2.2015998364E+00, 8.9964551620E-01],
	[2.7530000000E+04, 1.8077417484E+01, 4.9879226706E+00, 5.0433383296E+00, 2.2022392876E+00, 8.9969461507E-01],
	[2.7535000000E+04, 1.8082729352E+01, 4.9878948835E+00, 5.0463072889E+00, 2.2028786375E+00, 8.9974368988E-01],
	[2.7540000000E+04, 1.8088041817E+01, 4.9878671015E+00, 5.0492774558E+00, 2.2035178860E+00, 8.9979274063E-01],
	[2.7545000000E+04, 1.8093354878E+01, 4.9878393248E+00, 5.0522488306E+00, 2.2041570332E+00, 8.9984176734E-01],
	[2.7550000000E+04, 1.8098668534E+01, 4.9878115533E+00, 5.0552214136E+00, 2.2047960789E+00, 8.9989077001E-01],
	[2.7555000000E+04, 1.8103982787E+01, 4.9877837869E+00, 5.0581952050E+00, 2.2054350231E+00, 8.9993974866E-01],
	[2.7560000000E+04, 1.8109297635E+01, 4.9877560257E+00, 5.0611702051E+00, 2.2060738657E+00, 8.9998870330E-01],
	[2.7565000000E+04, 1.8114613079E+01, 4.9877282698E+00, 5.0641464142E+00, 2.2067126067E+00, 9.0003763393E-01],
	[2.7570000000E+04, 1.8119929118E+01, 4.9877005190E+00, 5.0671238325E+00, 2.2073512459E+00, 9.0008654056E-01],
	[2.7575000000E+04, 1.8125245753E+01, 4.9876727734E+00, 5.0701024604E+00, 2.2079897835E+00, 9.0013542322E-01],
	[2.7580000000E+04, 1.8130562984E+01, 4.9876450330E+00, 5.0730822980E+00, 2.2086282192E+00, 9.0018428189E-01],
	[2.7585000000E+04, 1.8135880810E+01, 4.9876172977E+00, 5.0760633458E+00, 2.2092665530E+00, 9.0023311661E-01],
	[2.7590000000E+04, 1.8141199232E+01, 4.9875895677E+00, 5.0790456038E+00, 2.2099047850E+00, 9.0028192736E-01],
	[2.7595000000E+04, 1.8146518250E+01, 4.9875618428E+00, 5.0820290725E+00, 2.2105429149E+00, 9.0033071417E-01],
	[2.7600000000E+04, 1.8151837862E+01, 4.9875341231E+00, 5.0850137521E+00, 2.2111809427E+00, 9.0037947705E-01],
	[2.7605000000E+04, 1.8157158071E+01, 4.9875064086E+00, 5.0879996428E+00, 2.2118188685E+00, 9.0042821600E-01],
	[2.7610000000E+04, 1.8162478874E+01, 4.9874786993E+00, 5.0909867449E+00, 2.2124566921E+00, 9.0047693104E-01],
	[2.7615000000E+04, 1.8167811616E+01, 4.9874527363E+00, 5.0939750588E+00, 2.2130949246E+00, 9.0052562217E-01],
	[2.7620000000E+04, 1.8173155186E+01, 4.9874283477E+00, 5.0969645846E+00, 2.2137335162E+00, 9.0057428940E-01],
	[2.7625000000E+04, 1.8178499361E+01, 4.9874039637E+00, 5.0999553226E+00, 2.2143720063E+00, 9.0062293275E-01],
	[2.7630000000E+04, 1.8183844139E+01, 4.9873795842E+00, 5.1029472732E+00, 2.2150103947E+00, 9.0067155223E-01],
	[2.7635000000E+04, 1.8189189522E+01, 4.9873552092E+00, 5.1059404365E+00, 2.2156486814E+00, 9.0072014784E-01],
	[2.7640000000E+04, 1.8194535508E+01, 4.9873308388E+00, 5.1089348129E+00, 2.2162868664E+00, 9.0076871959E-01],
	[2.7645000000E+04, 1.8199882098E+01, 4.9873064729E+00, 5.1119304026E+00, 2.2169249495E+00, 9.0081726749E-01],
	[2.7650000000E+04, 1.8205229291E+01, 4.9872821115E+00, 5.1149272059E+00, 2.2175629307E+00, 9.0086579157E-01],
	[2.7655000000E+04, 1.8210577089E+01, 4.9872577547E+00, 5.1179252231E+00, 2.2182008101E+00, 9.0091429181E-01],
	[2.7660000000E+04, 1.8215925490E+01, 4.9872334023E+00, 5.1209244544E+00, 2.2188385874E+00, 9.0096276824E-01],
	[2.7665000000E+04, 1.8221274495E+01, 4.9872090545E+00, 5.1239249001E+00, 2.2194762626E+00, 9.0101122086E-01],
	[2.7670000000E+04, 1.8226624104E+01, 4.9871847112E+00, 5.1269265606E+00, 2.2201138358E+00, 9.0105964969E-01],
	[2.7675000000E+04, 1.8231974316E+01, 4.9871603725E+00, 5.1299294359E+00, 2.2207513068E+00, 9.0110805473E-01],
	[2.7680000000E+04, 1.8237325131E+01, 4.9871360382E+00, 5.1329335265E+00, 2.2213886755E+00, 9.0115643599E-01],
	[2.7685000000E+04, 1.8242676550E+01, 4.9871117085E+00, 5.1359388326E+00, 2.2220259420E+00, 9.0120479349E-01],
	[2.7690000000E+04, 1.8248028573E+01, 4.9870873832E+00, 5.1389453545E+00, 2.2226631061E+00, 9.0125312723E-01],
	[2.7695000000E+04, 1.8253381199E+01, 4.9870630625E+00, 5.1419530924E+00, 2.2233001679E+00, 9.0130143723E-01],
	[2.7700000000E+04, 1.8258734428E+01, 4.9870387463E+00, 5.1449620467E+00, 2.2239371271E+00, 9.0134972349E-01],
	[2.7705000000E+04, 1.8264088261E+01, 4.9870144346E+00, 5.1479722175E+00, 2.2245739839E+00, 9.0139798602E-01],
	[2.7710000000E+04, 1.8269442697E+01, 4.9869901274E+00, 5.1509836052E+00, 2.2252107380E+00, 9.0144622484E-01],
	[2.7715000000E+04, 1.8274797736E+01, 4.9869658247E+00, 5.1539962100E+00, 2.2258473895E+00, 9.0149443995E-01],
	[2.7720000000E+04, 1.8280153379E+01, 4.9869415265E+00, 5.1570100322E+00, 2.2264839384E+00, 9.0154263136E-01],
	[2.7725000000E+04, 1.8285509624E+01, 4.9869172328E+00, 5.1600250721E+00, 2.2271203845E+00, 9.0159079909E-01],
	[2.7730000000E+04, 1.8290866473E+01, 4.9868929436E+00, 5.1630413299E+00, 2.2277567278E+00, 9.0163894314E-01],
	[2.7735000000E+04, 1.8296223925E+01, 4.9868686589E+00, 5.1660588060E+00, 2.2283929682E+00, 9.0168706353E-01],
	[2.7740000000E+04, 1.8301581980E+01, 4.9868443787E+00, 5.1690775005E+00, 2.2290291057E+00, 9.0173516026E-01],
	[2.7745000000E+04, 1.8306940638E+01, 4.9868201030E+00, 5.1720974138E+00, 2.2296651402E+00, 9.0178323334E-01],
	[2.7750000000E+04, 1.8312299899E+01, 4.9867958318E+00, 5.1751185462E+00, 2.2303010717E+00, 9.0183128279E-01],
	[2.7755000000E+04, 1.8317659762E+01, 4.9867715651E+00, 5.1781408978E+00, 2.2309369001E+00, 9.0187930861E-01],
	[2.7760000000E+04, 1.8323020229E+01, 4.9867473029E+00, 5.1811644690E+00, 2.2315726253E+00, 9.0192731082E-01],
	[2.7765000000E+04, 1.8328381299E+01, 4.9867230451E+00, 5.1841892601E+00, 2.2322082473E+00, 9.0197528942E-01],
	[2.7770000000E+04, 1.8333742971E+01, 4.9866987919E+00, 5.1872152713E+00, 2.2328437661E+00, 9.0202324442E-01],
	[2.7775000000E+04, 1.8339105246E+01, 4.9866745431E+00, 5.1902425029E+00, 2.2334791815E+00, 9.0207117584E-01],
	[2.7780000000E+04, 1.8344468124E+01, 4.9866502988E+00, 5.1932709551E+00, 2.2341144936E+00, 9.0211908368E-01],
	[2.7785000000E+04, 1.8349831604E+01, 4.9866260590E+00, 5.1963006283E+00, 2.2347497022E+00, 9.0216696795E-01],
	[2.7790000000E+04, 1.8355195687E+01, 4.9866018237E+00, 5.1993315227E+00, 2.2353848074E+00, 9.0221482867E-01],
	[2.7795000000E+04, 1.8360560373E+01, 4.9865775928E+00, 5.2023636386E+00, 2.2360198090E+00, 9.0226266584E-01],
	[2.7800000000E+04, 1.8365925661E+01, 4.9865533664E+00, 5.2053969762E+00, 2.2366547070E+00, 9.0231047948E-01],
	[2.7805000000E+04, 1.8371291552E+01, 4.9865291445E+00, 5.2084315359E+00, 2.2372895013E+00, 9.0235826959E-01],
	[2.7810000000E+04, 1.8376658045E+01, 4.9865049271E+00, 5.2114673178E+00, 2.2379241919E+00, 9.0240603619E-01],
	[2.7815000000E+04, 1.8382025141E+01, 4.9864807141E+00, 5.2145043224E+00, 2.2385587788E+00, 9.0245377928E-01],
	[2.7820000000E+04, 1.8387392839E+01, 4.9864565056E+00, 5.2175425497E+00, 2.2391932618E+00, 9.0250149887E-01],
	[2.7825000000E+04, 1.8392761140E+01, 4.9864323016E+00, 5.2205820002E+00, 2.2398276409E+00, 9.0254919498E-01],
	[2.7830000000E+04, 1.8398130043E+01, 4.9864081021E+00, 5.2236226741E+00, 2.2404619161E+00, 9.0259686761E-01],
	[2.7835000000E+04, 1.8403499548E+01, 4.9863839070E+00, 5.2266645716E+00, 2.2410960873E+00, 9.0264451678E-01],
	[2.7840000000E+04, 1.8408869655E+01, 4.9863597163E+00, 5.2297076931E+00, 2.2417301545E+00, 9.0269214250E-01],
	[2.7845000000E+04, 1.8414240364E+01, 4.9863355302E+00, 5.2327520387E+00, 2.2423641175E+00, 9.0273974476E-01],
	[2.7850000000E+04, 1.8419611676E+01, 4.9863113485E+00, 5.2357976088E+00, 2.2429979764E+00, 9.0278732360E-01],
	[2.7855000000E+04, 1.8424983590E+01, 4.9862871712E+00, 5.2388444037E+00, 2.2436317310E+00, 9.0283487900E-01],
	[2.7860000000E+04, 1.8430356106E+01, 4.9862629984E+00, 5.2418924236E+00, 2.2442653814E+00, 9.0288241100E-01],
	[2.7865000000E+04, 1.8435729224E+01, 4.9862388301E+00, 5.2449416688E+00, 2.2448989274E+00, 9.0292991958E-01],
	[2.7870000000E+04, 1.8441102943E+01, 4.9862146662E+00, 5.2479921395E+00, 2.2455323691E+00, 9.0297740478E-01],
	[2.7875000000E+04, 1.8446477265E+01, 4.9861905068E+00, 5.2510438361E+00, 2.2461657063E+00, 9.0302486658E-01],
	[2.7880000000E+04, 1.8451852189E+01, 4.9861663518E+00, 5.2540967588E+00, 2.2467989391E+00, 9.0307230502E-01],
	[2.7885000000E+04, 1.8457227714E+01, 4.9861422013E+00, 5.2571509079E+00, 2.2474320672E+00, 9.0311972009E-01],
	[2.7890000000E+04, 1.8462603842E+01, 4.9861180552E+00, 5.2602062836E+00, 2.2480650908E+00, 9.0316711180E-01],
	[2.7895000000E+04, 1.8467980571E+01, 4.9860939136E+00, 5.2632628863E+00, 2.2486980097E+00, 9.0321448017E-01],
	[2.7900000000E+04, 1.8473357902E+01, 4.9860697764E+00, 5.2663207161E+00, 2.2493308239E+00, 9.0326182521E-01],
	[2.7905000000E+04, 1.8478735835E+01, 4.9860456436E+00, 5.2693797734E+00, 2.2499635333E+00, 9.0330914692E-01],
	[2.7910000000E+04, 1.8484114369E+01, 4.9860215153E+00, 5.2724400585E+00, 2.2505961379E+00, 9.0335644532E-01],
	[2.7915000000E+04, 1.8489493505E+01, 4.9859973914E+00, 5.2755015715E+00, 2.2512286377E+00, 9.0340372041E-01],
	[2.7920000000E+04, 1.8494873242E+01, 4.9859732720E+00, 5.2785643129E+00, 2.2518610324E+00, 9.0345097221E-01],
	[2.7925000000E+04, 1.8500253581E+01, 4.9859491570E+00, 5.2816282828E+00, 2.2524933222E+00, 9.0349820073E-01],
	[2.7930000000E+04, 1.8505634522E+01, 4.9859250464E+00, 5.2846934816E+00, 2.2531255070E+00, 9.0354540598E-01],
	[2.7935000000E+04, 1.8511016064E+01, 4.9859009403E+00, 5.2877599094E+00, 2.2537575867E+00, 9.0359258796E-01],
	[2.7940000000E+04, 1.8516398208E+01, 4.9858768386E+00, 5.2908275666E+00, 2.2543895612E+00, 9.0363974668E-01],
	[2.7945000000E+04, 1.8521780952E+01, 4.9858527413E+00, 5.2938964535E+00, 2.2550214305E+00, 9.0368688217E-01],
	[2.7950000000E+04, 1.8527164299E+01, 4.9858286485E+00, 5.2969665703E+00, 2.2556531945E+00, 9.0373399442E-01],
	[2.7955000000E+04, 1.8532548246E+01, 4.9858045600E+00, 5.3000379172E+00, 2.2562848532E+00, 9.0378108345E-01],
	[2.7960000000E+04, 1.8537932795E+01, 4.9857804760E+00, 5.3031104947E+00, 2.2569164066E+00, 9.0382814926E-01],
	[2.7965000000E+04, 1.8543317945E+01, 4.9857563965E+00, 5.3061843029E+00, 2.2575478545E+00, 9.0387519188E-01],
	[2.7970000000E+04, 1.8548703696E+01, 4.9857323213E+00, 5.3092593420E+00, 2.2581791970E+00, 9.0392221130E-01],
	[2.7975000000E+04, 1.8554090048E+01, 4.9857082506E+00, 5.3123356125E+00, 2.2588104339E+00, 9.0396920753E-01],
	[2.7980000000E+04, 1.8559477002E+01, 4.9856841843E+00, 5.3154131145E+00, 2.2594415653E+00, 9.0401618060E-01],
	[2.7985000000E+04, 1.8564864556E+01, 4.9856601224E+00, 5.3184918484E+00, 2.2600725910E+00, 9.0406313051E-01],
	[2.7990000000E+04, 1.8570252711E+01, 4.9856360649E+00, 5.3215718143E+00, 2.2607035110E+00, 9.0411005726E-01],
	[2.7995000000E+04, 1.8575641468E+01, 4.9856120118E+00, 5.3246530126E+00, 2.2613343253E+00, 9.0415696087E-01],
	[2.8000000000E+04, 1.8581030825E+01, 4.9855879632E+00, 5.3277354436E+00, 2.2619650338E+00, 9.0420384135E-01],
	[2.8005000000E+04, 1.8586420784E+01, 4.9855639189E+00, 5.3308191075E+00, 2.2625956364E+00, 9.0425069871E-01],
	[2.8010000000E+04, 1.8591811343E+01, 4.9855398791E+00, 5.3339040046E+00, 2.2632261332E+00, 9.0429753296E-01],
	[2.8015000000E+04, 1.8597202503E+01, 4.9855158436E+00, 5.3369901351E+00, 2.2638565240E+00, 9.0434434410E-01],
	[2.8020000000E+04, 1.8602594263E+01, 4.9854918126E+00, 5.3400774993E+00, 2.2644868087E+00, 9.0439113216E-01],
	[2.8025000000E+04, 1.8607986625E+01, 4.9854677860E+00, 5.3431660976E+00, 2.2651169874E+00, 9.0443789713E-01],
	[2.8030000000E+04, 1.8613379587E+01, 4.9854437638E+00, 5.3462559302E+00, 2.2657470600E+00, 9.0448463904E-01],
	[2.8035000000E+04, 1.8618773150E+01, 4.9854197459E+00, 5.3493469973E+00, 2.2663770265E+00, 9.0453135788E-01],
	[2.8040000000E+04, 1.8624167313E+01, 4.9853957325E+00, 5.3524392992E+00, 2.2670068867E+00, 9.0457805368E-01],
	[2.8045000000E+04, 1.8629562077E+01, 4.9853717235E+00, 5.3555328362E+00, 2.2676366406E+00, 9.0462472643E-01],
	[2.8050000000E+04, 1.8634957442E+01, 4.9853477188E+00, 5.3586276086E+00, 2.2682662882E+00, 9.0467137616E-01],
	[2.8055000000E+04, 1.8640353407E+01, 4.9853237186E+00, 5.3617236166E+00, 2.2688958294E+00, 9.0471800286E-01],
	[2.8060000000E+04, 1.8645763316E+01, 4.9853017453E+00, 5.3648208606E+00, 2.2695258811E+00, 9.0476460656E-01],
	[2.8065000000E+04, 1.8651181956E+01, 4.9852810072E+00, 5.3679193407E+00, 2.2701562024E+00, 9.0481118726E-01],
	[2.8070000000E+04, 1.8656601206E+01, 4.9852602729E+00, 5.3710190573E+00, 2.2707864179E+00, 9.0485774496E-01],
	[2.8075000000E+04, 1.8662021064E+01, 4.9852395424E+00, 5.3741200106E+00, 2.2714165276E+00, 9.0490427969E-01],
	[2.8080000000E+04, 1.8667441532E+01, 4.9852188156E+00, 5.3772222010E+00, 2.2720465314E+00, 9.0495079145E-01],
	[2.8085000000E+04, 1.8672862608E+01, 4.9851980927E+00, 5.3803256286E+00, 2.2726764293E+00, 9.0499728025E-01],
	[2.8090000000E+04, 1.8678284293E+01, 4.9851773735E+00, 5.3834302937E+00, 2.2733062211E+00, 9.0504374611E-01],
	[2.8095000000E+04, 1.8683706587E+01, 4.9851566580E+00, 5.3865361967E+00, 2.2739359070E+00, 9.0509018902E-01],
	[2.8100000000E+04, 1.8689129490E+01, 4.9851359464E+00, 5.3896433378E+00, 2.2745654867E+00, 9.0513660901E-01],
	[2.8105000000E+04, 1.8694553001E+01, 4.9851152385E+00, 5.3927517172E+00, 2.2751949602E+00, 9.0518300608E-01],
	[2.8110000000E+04, 1.8699977121E+01, 4.9850945344E+00, 5.3958613353E+00, 2.2758243276E+00, 9.0522938025E-01],
	[2.8115000000E+04, 1.8705401850E+01, 4.9850738341E+00, 5.3989721923E+00, 2.2764535886E+00, 9.0527573151E-01],
	[2.8120000000E+04, 1.8710827187E+01, 4.9850531375E+00, 5.4020842885E+00, 2.2770827434E+00, 9.0532205989E-01],
	[2.8125000000E+04, 1.8716253133E+01, 4.9850324447E+00, 5.4051976242E+00, 2.2777117918E+00, 9.0536836540E-01],
	[2.8130000000E+04, 1.8721679688E+01, 4.9850117557E+00, 5.4083121995E+00, 2.2783407339E+00, 9.0541464803E-01],
	[2.8135000000E+04, 1.8727106851E+01, 4.9849910704E+00, 5.4114280149E+00, 2.2789695694E+00, 9.0546090781E-01],
	[2.8140000000E+04, 1.8732534622E+01, 4.9849703889E+00, 5.4145450706E+00, 2.2795982984E+00, 9.0550714474E-01],
	[2.8145000000E+04, 1.8737963002E+01, 4.9849497112E+00, 5.4176633668E+00, 2.2802269209E+00, 9.0555335884E-01],
	[2.8150000000E+04, 1.8743391990E+01, 4.9849290372E+00, 5.4207829038E+00, 2.2808554367E+00, 9.0559955012E-01],
	[2.8155000000E+04, 1.8748821586E+01, 4.9849083669E+00, 5.4239036820E+00, 2.2814838459E+00, 9.0564571857E-01],
	[2.8160000000E+04, 1.8754251791E+01, 4.9848877004E+00, 5.4270257015E+00, 2.2821121484E+00, 9.0569186422E-01],
	[2.8165000000E+04, 1.8759682604E+01, 4.9848670377E+00, 5.4301489626E+00, 2.2827403441E+00, 9.0573798708E-01],
	[2.8170000000E+04, 1.8765114025E+01, 4.9848463787E+00, 5.4332734657E+00, 2.2833684329E+00, 9.0578408715E-01],
	[2.8175000000E+04, 1.8770546055E+01, 4.9848257235E+00, 5.4363992109E+00, 2.2839964149E+00, 9.0583016444E-01],
	[2.8180000000E+04, 1.8775978692E+01, 4.9848050721E+00, 5.4395261987E+00, 2.2846242900E+00, 9.0587621897E-01],
	[2.8185000000E+04, 1.8781411938E+01, 4.9847844243E+00, 5.4426544291E+00, 2.2852520581E+00, 9.0592225073E-01],
	[2.8190000000E+04, 1.8786845791E+01, 4.9847637804E+00, 5.4457839025E+00, 2.2858797191E+00, 9.0596825975E-01],
	[2.8195000000E+04, 1.8792280253E+01, 4.9847431401E+00, 5.4489146193E+00, 2.2865072731E+00, 9.0601424603E-01],
	[2.8200000000E+04, 1.8797715322E+01, 4.9847225037E+00, 5.4520465796E+00, 2.2871347200E+00, 9.0606020957E-01],
	[2.8205000000E+04, 1.8803151000E+01, 4.9847018709E+00, 5.4551797837E+00, 2.2877620597E+00, 9.0610615040E-01],
	[2.8210000000E+04, 1.8808587285E+01, 4.9846812419E+00, 5.4583142319E+00, 2.2883892922E+00, 9.0615206851E-01],
	[2.8215000000E+04, 1.8814024178E+01, 4.9846606167E+00, 5.4614499245E+00, 2.2890164174E+00, 9.0619796392E-01],
	[2.8220000000E+04, 1.8819461679E+01, 4.9846399952E+00, 5.4645868617E+00, 2.2896434352E+00, 9.0624383663E-01],
	[2.8225000000E+04, 1.8824899788E+01, 4.9846193774E+00, 5.4677250438E+00, 2.2902703457E+00, 9.0628968666E-01],
	[2.8230000000E+04, 1.8830338505E+01, 4.9845987634E+00, 5.4708644711E+00, 2.2908971488E+00, 9.0633551402E-01],
	[2.8235000000E+04, 1.8835777829E+01, 4.9845781531E+00, 5.4740051439E+00, 2.2915238443E+00, 9.0638131871E-01],
	[2.8240000000E+04, 1.8841217761E+01, 4.9845575465E+00, 5.4771470625E+00, 2.2921504324E+00, 9.0642710074E-01],
	[2.8245000000E+04, 1.8846658300E+01, 4.9845369437E+00, 5.4802902270E+00, 2.2927769129E+00, 9.0647286013E-01],
	[2.8250000000E+04, 1.8852099447E+01, 4.9845163446E+00, 5.4834346378E+00, 2.2934032857E+00, 9.0651859688E-01],
	[2.8255000000E+04, 1.8857541202E+01, 4.9844957492E+00, 5.4865802952E+00, 2.2940295509E+00, 9.0656431100E-01],
	[2.8260000000E+04, 1.8862983564E+01, 4.9844751576E+00, 5.4897271994E+00, 2.2946557084E+00, 9.0661000251E-01],
	[2.8265000000E+04, 1.8868426533E+01, 4.9844545697E+00, 5.4928753507E+00, 2.2952817580E+00, 9.0665567140E-01],
	[2.8270000000E+04, 1.8873870110E+01, 4.9844339855E+00, 5.4960247494E+00, 2.2959076999E+00, 9.0670131769E-01],
	[2.8275000000E+04, 1.8879314294E+01, 4.9844134050E+00, 5.4991753957E+00, 2.2965335339E+00, 9.0674694139E-01],
	[2.8280000000E+04, 1.8884759086E+01, 4.9843928283E+00, 5.5023272900E+00, 2.2971592599E+00, 9.0679254251E-01],
	[2.8285000000E+04, 1.8890204485E+01, 4.9843722553E+00, 5.5054804324E+00, 2.2977848780E+00, 9.0683812106E-01],
	[2.8290000000E+04, 1.8895650491E+01, 4.9843516860E+00, 5.5086348233E+00, 2.2984103880E+00, 9.0688367705E-01],
	[2.8295000000E+04, 1.8901097104E+01, 4.9843311204E+00, 5.5117904630E+00, 2.2990357900E+00, 9.0692921048E-01],
	[2.8300000000E+04, 1.8906544324E+01, 4.9843105585E+00, 5.5149473517E+00, 2.2996610839E+00, 9.0697472137E-01],
	[2.8305000000E+04, 1.8911992152E+01, 4.9842900004E+00, 5.5181054896E+00, 2.3002862696E+00, 9.0702020972E-01],
	[2.8310000000E+04, 1.8917440587E+01, 4.9842694460E+00, 5.5212648771E+00, 2.3009113471E+00, 9.0706567555E-01],
	[2.8315000000E+04, 1.8922889628E+01, 4.9842488953E+00, 5.5244255145E+00, 2.3015363163E+00, 9.0711111886E-01],
	[2.8320000000E+04, 1.8928339277E+01, 4.9842283483E+00, 5.5275874019E+00, 2.3021611772E+00, 9.0715653966E-01],
	[2.8325000000E+04, 1.8933789533E+01, 4.9842078050E+00, 5.5307505398E+00, 2.3027859297E+00, 9.0720193797E-01],
	[2.8330000000E+04, 1.8939240396E+01, 4.9841872654E+00, 5.5339149282E+00, 2.3034105738E+00, 9.0724731379E-01],
	[2.8335000000E+04, 1.8944691865E+01, 4.9841667296E+00, 5.5370805676E+00, 2.3040351095E+00, 9.0729266713E-01],
	[2.8340000000E+04, 1.8950143942E+01, 4.9841461974E+00, 5.5402474583E+00, 2.3046595367E+00, 9.0733799801E-01],
	[2.8345000000E+04, 1.8955596625E+01, 4.9841256690E+00, 5.5434156003E+00, 2.3052838552E+00, 9.0738330642E-01],
	[2.8350000000E+04, 1.8961049915E+01, 4.9841051442E+00, 5.5465849942E+00, 2.3059080652E+00, 9.0742859238E-01],
	[2.8355000000E+04, 1.8966503811E+01, 4.9840846232E+00, 5.5497556400E+00, 2.3065321666E+00, 9.0747385591E-01],
	[2.8360000000E+04, 1.8971958315E+01, 4.9840641059E+00, 5.5529275382E+00, 2.3071561592E+00, 9.0751909700E-01],
	[2.8365000000E+04, 1.8977413425E+01, 4.9840435922E+00, 5.5561006889E+00, 2.3077800431E+00, 9.0756431567E-01],
	[2.8370000000E+04, 1.8982869142E+01, 4.9840230823E+00, 5.5592750924E+00, 2.3084038182E+00, 9.0760951192E-01],
	[2.8375000000E+04, 1.8988325465E+01, 4.9840025761E+00, 5.5624507491E+00, 2.3090274844E+00, 9.0765468578E-01],
	[2.8380000000E+04, 1.8993782395E+01, 4.9839820735E+00, 5.5656276591E+00, 2.3096510417E+00, 9.0769983724E-01],
	[2.8385000000E+04, 1.8999239931E+01, 4.9839615747E+00, 5.5688058228E+00, 2.3102744901E+00, 9.0774496631E-01],
	[2.8390000000E+04, 1.9004698074E+01, 4.9839410796E+00, 5.5719852404E+00, 2.3108978296E+00, 9.0779007301E-01],
	[2.8395000000E+04, 1.9010156823E+01, 4.9839205881E+00, 5.5751659123E+00, 2.3115210599E+00, 9.0783515735E-01],
	[2.8400000000E+04, 1.9015616178E+01, 4.9839001004E+00, 5.5783478386E+00, 2.3121441812E+00, 9.0788021933E-01],
	[2.8405000000E+04, 1.9021076140E+01, 4.9838796163E+00, 5.5815310197E+00, 2.3127671934E+00, 9.0792525897E-01],
	[2.8410000000E+04, 1.9026536709E+01, 4.9838591359E+00, 5.5847154558E+00, 2.3133900964E+00, 9.0797027626E-01],
	[2.8415000000E+04, 1.9031997883E+01, 4.9838386592E+00, 5.5879011472E+00, 2.3140128901E+00, 9.0801527123E-01],
	[2.8420000000E+04, 1.9037459664E+01, 4.9838181862E+00, 5.5910880941E+00, 2.3146355746E+00, 9.0806024388E-01],
	[2.8425000000E+04, 1.9042922051E+01, 4.9837977169E+00, 5.5942762970E+00, 2.3152581497E+00, 9.0810519423E-01],
	[2.8430000000E+04, 1.9048385044E+01, 4.9837772513E+00, 5.5974657559E+00, 2.3158806155E+00, 9.0815012227E-01],
	[2.8435000000E+04, 1.9053848643E+01, 4.9837567893E+00, 5.6006564712E+00, 2.3165029719E+00, 9.0819502803E-01],
	[2.8440000000E+04, 1.9059312848E+01, 4.9837363311E+00, 5.6038484432E+00, 2.3171252188E+00, 9.0823991150E-01],
	[2.8445000000E+04, 1.9064777659E+01, 4.9837158765E+00, 5.6070416722E+00, 2.3177473562E+00, 9.0828477271E-01],
	[2.8450000000E+04, 1.9070243076E+01, 4.9836954256E+00, 5.6102361583E+00, 2.3183693841E+00, 9.0832961165E-01],
	[2.8455000000E+04, 1.9075709099E+01, 4.9836749783E+00, 5.6134319020E+00, 2.3189913023E+00, 9.0837442834E-01],
	[2.8460000000E+04, 1.9081175728E+01, 4.9836545348E+00, 5.6166289034E+00, 2.3196131109E+00, 9.0841922279E-01],
	[2.8465000000E+04, 1.9086642963E+01, 4.9836340949E+00, 5.6198271628E+00, 2.3202348098E+00, 9.0846399501E-01],
	[2.8470000000E+04, 1.9092110804E+01, 4.9836136587E+00, 5.6230266805E+00, 2.3208563989E+00, 9.0850874500E-01],
	[2.8475000000E+04, 1.9097579250E+01, 4.9835932262E+00, 5.6262274569E+00, 2.3214778783E+00, 9.0855347278E-01],
	[2.8480000000E+04, 1.9103048303E+01, 4.9835727973E+00, 5.6294294920E+00, 2.3220992478E+00, 9.0859817836E-01],
	[2.8485000000E+04, 1.9108517961E+01, 4.9835523721E+00, 5.6326327863E+00, 2.3227205075E+00, 9.0864286174E-01],
	[2.8490000000E+04, 1.9113988224E+01, 4.9835319506E+00, 5.6358373401E+00, 2.3233416572E+00, 9.0868752293E-01],
	[2.8495000000E+04, 1.9119459094E+01, 4.9835115327E+00, 5.6390431534E+00, 2.3239626970E+00, 9.0873216195E-01],
	[2.8500000000E+04, 1.9124930568E+01, 4.9834911185E+00, 5.6422502268E+00, 2.3245836267E+00, 9.0877677881E-01],
	[2.8505000000E+04, 1.9130402649E+01, 4.9834707080E+00, 5.6454585603E+00, 2.3252044464E+00, 9.0882137351E-01],
	[2.8510000000E+04, 1.9135881444E+01, 4.9834512158E+00, 5.6486681544E+00, 2.3258254454E+00, 9.0886594606E-01],
	[2.8515000000E+04, 1.9141376103E+01, 4.9834340104E+00, 5.6518790092E+00, 2.3264470574E+00, 9.0891049647E-01],
	[2.8520000000E+04, 1.9146871376E+01, 4.9834168080E+00, 5.6550911251E+00, 2.3270685600E+00, 9.0895502475E-01],
	[2.8525000000E+04, 1.9152367262E+01, 4.9833996086E+00, 5.6583045023E+00, 2.3276899530E+00, 9.0899953092E-01],
	[2.8530000000E+04, 1.9157863762E+01, 4.9833824124E+00, 5.6615191410E+00, 2.3283112365E+00, 9.0904401498E-01],
	[2.8535000000E+04, 1.9163360877E+01, 4.9833652192E+00, 5.6647350417E+00, 2.3289324103E+00, 9.0908847694E-01],
	[2.8540000000E+04, 1.9168858605E+01, 4.9833480291E+00, 5.6679522045E+00, 2.3295534745E+00, 9.0913291681E-01],
	[2.8545000000E+04, 1.9174356946E+01, 4.9833308421E+00, 5.6711706297E+00, 2.3301744290E+00, 9.0917733459E-01],
	[2.8550000000E+04, 1.9179855902E+01, 4.9833136581E+00, 5.6743903175E+00, 2.3307952738E+00, 9.0922173031E-01],
	[2.8555000000E+04, 1.9185355471E+01, 4.9832964772E+00, 5.6776112684E+00, 2.3314160087E+00, 9.0926610397E-01],
	[2.8560000000E+04, 1.9190855653E+01, 4.9832792994E+00, 5.6808334824E+00, 2.3320366338E+00, 9.0931045557E-01],
	[2.8565000000E+04, 1.9196356449E+01, 4.9832621246E+00, 5.6840569600E+00, 2.3326571490E+00, 9.0935478513E-01],
	[2.8570000000E+04, 1.9201857859E+01, 4.9832449529E+00, 5.6872817014E+00, 2.3332775543E+00, 9.0939909266E-01],
	[2.8575000000E+04, 1.9207359882E+01, 4.9832277843E+00, 5.6905077068E+00, 2.3338978496E+00, 9.0944337817E-01],
	[2.8580000000E+04, 1.9212862519E+01, 4.9832106187E+00, 5.6937349766E+00, 2.3345180349E+00, 9.0948764167E-01],
	[2.8585000000E+04, 1.9218365769E+01, 4.9831934562E+00, 5.6969635109E+00, 2.3351381101E+00, 9.0953188316E-01],
	[2.8590000000E+04, 1.9223869633E+01, 4.9831762968E+00, 5.7001933101E+00, 2.3357580753E+00, 9.0957610265E-01],
	[2.8595000000E+04, 1.9229374110E+01, 4.9831591404E+00, 5.7034243745E+00, 2.3363779302E+00, 9.0962030016E-01],
	[2.8600000000E+04, 1.9234879200E+01, 4.9831419870E+00, 5.7066567043E+00, 2.3369976750E+00, 9.0966447570E-01],
	[2.8605000000E+04, 1.9240384903E+01, 4.9831248368E+00, 5.7098902998E+00, 2.3376173095E+00, 9.0970862927E-01],
	[2.8610000000E+04, 1.9245891220E+01, 4.9831076896E+00, 5.7131251613E+00, 2.3382368337E+00, 9.0975276088E-01],
	[2.8615000000E+04, 1.9251398150E+01, 4.9830905454E+00, 5.7163612890E+00, 2.3388562476E+00, 9.0979687055E-01],
	[2.8620000000E+04, 1.9256905693E+01, 4.9830734043E+00, 5.7195986832E+00, 2.3394755511E+00, 9.0984095828E-01],
	[2.8625000000E+04, 1.9262413849E+01, 4.9830562662E+00, 5.7228373442E+00, 2.3400947441E+00, 9.0988502408E-01],
	[2.8630000000E+04, 1.9267922618E+01, 4.9830391312E+00, 5.7260772723E+00, 2.3407138267E+00, 9.0992906797E-01],
	[2.8635000000E+04, 1.9273432001E+01, 4.9830219993E+00, 5.7293184678E+00, 2.3413327988E+00, 9.0997308995E-01],
	[2.8640000000E+04, 1.9278941996E+01, 4.9830048704E+00, 5.7325609308E+00, 2.3419516604E+00, 9.1001709003E-01],
	[2.8645000000E+04, 1.9284452604E+01, 4.9829877445E+00, 5.7358046618E+00, 2.3425704113E+00, 9.1006106822E-01],
	[2.8650000000E+04, 1.9289963825E+01, 4.9829706217E+00, 5.7390496609E+00, 2.3431890516E+00, 9.1010502453E-01],
	[2.8655000000E+04, 1.9295475659E+01, 4.9829535020E+00, 5.7422959284E+00, 2.3438075812E+00, 9.1014895897E-01],
	[2.8660000000E+04, 1.9300988106E+01, 4.9829363853E+00, 5.7455434647E+00, 2.3444260000E+00, 9.1019287155E-01],
	[2.8665000000E+04, 1.9306501166E+01, 4.9829192716E+00, 5.7487922699E+00, 2.3450443081E+00, 9.1023676229E-01],
	[2.8670000000E+04, 1.9312014838E+01, 4.9829021610E+00, 5.7520423444E+00, 2.3456625054E+00, 9.1028063118E-01],
	[2.8675000000E+04, 1.9317529123E+01, 4.9828850534E+00, 5.7552936884E+00, 2.3462805918E+00, 9.1032447824E-01],
	[2.8680000000E+04, 1.9323044021E+01, 4.9828679489E+00, 5.7585463023E+00, 2.3468985672E+00, 9.1036830348E-01],
	[2.8685000000E+04, 1.9328559532E+01, 4.9828508474E+00, 5.7618001862E+00, 2.3475164318E+00, 9.1041210690E-01],
	[2.8690000000E+04, 1.9334075655E+01, 4.9828337489E+00, 5.7650553404E+00, 2.3481341853E+00, 9.1045588853E-01],
	[2.8695000000E+04, 1.9339592390E+01, 4.9828166535E+00, 5.7683117653E+00, 2.3487518278E+00, 9.1049964836E-01],
	[2.8700000000E+04, 1.9345109739E+01, 4.9827995611E+00, 5.7715694612E+00, 2.3493693592E+00, 9.1054338641E-01],
	[2.8705000000E+04, 1.9350627699E+01, 4.9827824718E+00, 5.7748284281E+00, 2.3499867795E+00, 9.1058710268E-01],
	[2.8710000000E+04, 1.9356146272E+01, 4.9827653855E+00, 5.7780886666E+00, 2.3506040886E+00, 9.1063079719E-01],
	[2.8715000000E+04, 1.9361665458E+01, 4.9827483022E+00, 5.7813501767E+00, 2.3512212865E+00, 9.1067446995E-01],
	[2.8720000000E+04, 1.9367185256E+01, 4.9827312220E+00, 5.7846129589E+00, 2.3518383732E+00, 9.1071812096E-01],
	[2.8725000000E+04, 1.9372705666E+01, 4.9827141447E+00, 5.7878770133E+00, 2.3524553485E+00, 9.1076175024E-01],
	[2.8730000000E+04, 1.9378226689E+01, 4.9826970706E+00, 5.7911423403E+00, 2.3530722125E+00, 9.1080535779E-01],
	[2.8735000000E+04, 1.9383748324E+01, 4.9826799994E+00, 5.7944089401E+00, 2.3536889651E+00, 9.1084894363E-01],
	[2.8740000000E+04, 1.9389270571E+01, 4.9826629313E+00, 5.7976768130E+00, 2.3543056063E+00, 9.1089250776E-01],
	[2.8745000000E+04, 1.9394793430E+01, 4.9826458662E+00, 5.8009459593E+00, 2.3549221360E+00, 9.1093605019E-01],
	[2.8750000000E+04, 1.9400316901E+01, 4.9826288041E+00, 5.8042163792E+00, 2.3555385542E+00, 9.1097957094E-01],
	[2.8755000000E+04, 1.9405840985E+01, 4.9826117451E+00, 5.8074880730E+00, 2.3561548609E+00, 9.1102307001E-01],
	[2.8760000000E+04, 1.9411365680E+01, 4.9825946891E+00, 5.8107610410E+00, 2.3567710559E+00, 9.1106654741E-01],
	[2.8765000000E+04, 1.9416890988E+01, 4.9825776361E+00, 5.8140352835E+00, 2.3573871393E+00, 9.1111000316E-01],
	[2.8770000000E+04, 1.9422416908E+01, 4.9825605861E+00, 5.8173108008E+00, 2.3580031111E+00, 9.1115343726E-01],
	[2.8775000000E+04, 1.9427943439E+01, 4.9825435391E+00, 5.8205875930E+00, 2.3586189711E+00, 9.1119684972E-01],
	[2.8780000000E+04, 1.9433470583E+01, 4.9825264952E+00, 5.8238656605E+00, 2.3592347193E+00, 9.1124024055E-01],
	[2.8785000000E+04, 1.9438998338E+01, 4.9825094543E+00, 5.8271450036E+00, 2.3598503557E+00, 9.1128360976E-01],
	[2.8790000000E+04, 1.9444526705E+01, 4.9824924164E+00, 5.8304256226E+00, 2.3604658803E+00, 9.1132695736E-01],
	[2.8795000000E+04, 1.9450055684E+01, 4.9824753815E+00, 5.8337075176E+00, 2.3610812929E+00, 9.1137028336E-01],
	[2.8800000000E+04, 1.9455585275E+01, 4.9824583497E+00, 5.8369906891E+00, 2.3616965937E+00, 9.1141358777E-01],
	[2.8805000000E+04, 1.9461115477E+01, 4.9824413208E+00, 5.8402751372E+00, 2.3623117824E+00, 9.1145687061E-01],
	[2.8810000000E+04, 1.9466646291E+01, 4.9824242950E+00, 5.8435608622E+00, 2.3629268592E+00, 9.1150013187E-01],
	[2.8815000000E+04, 1.9472177717E+01, 4.9824072722E+00, 5.8468478645E+00, 2.3635418238E+00, 9.1154337157E-01],
	[2.8820000000E+04, 1.9477709755E+01, 4.9823902524E+00, 5.8501361442E+00, 2.3641566764E+00, 9.1158658972E-01],
	[2.8825000000E+04, 1.9483242403E+01, 4.9823732356E+00, 5.8534257017E+00, 2.3647714168E+00, 9.1162978633E-01],
	[2.8830000000E+04, 1.9488775664E+01, 4.9823562218E+00, 5.8567165372E+00, 2.3653860451E+00, 9.1167296140E-01],
	[2.8835000000E+04, 1.9494309536E+01, 4.9823392110E+00, 5.8600086510E+00, 2.3660005611E+00, 9.1171611495E-01],
	[2.8840000000E+04, 1.9499844019E+01, 4.9823222032E+00, 5.8633020434E+00, 2.3666149648E+00, 9.1175924699E-01],
	[2.8845000000E+04, 1.9505379114E+01, 4.9823051985E+00, 5.8665967147E+00, 2.3672292562E+00, 9.1180235753E-01],
	[2.8850000000E+04, 1.9510914820E+01, 4.9822881967E+00, 5.8698926651E+00, 2.3678434353E+00, 9.1184544658E-01],
	[2.8855000000E+04, 1.9516451138E+01, 4.9822711979E+00, 5.8731898949E+00, 2.3684575020E+00, 9.1188851414E-01],
	[2.8860000000E+04, 1.9521988067E+01, 4.9822542022E+00, 5.8764884044E+00, 2.3690714562E+00, 9.1193156022E-01],
	[2.8865000000E+04, 1.9527525607E+01, 4.9822372094E+00, 5.8797881938E+00, 2.3696852980E+00, 9.1197458485E-01],
	[2.8870000000E+04, 1.9533063758E+01, 4.9822202197E+00, 5.8830892635E+00, 2.3702990272E+00, 9.1201758802E-01],
	[2.8875000000E+04, 1.9538602521E+01, 4.9822032329E+00, 5.8863916136E+00, 2.3709126439E+00, 9.1206056974E-01],
	[2.8880000000E+04, 1.9544141894E+01, 4.9821862492E+00, 5.8896952446E+00, 2.3715261480E+00, 9.1210353003E-01],
	[2.8885000000E+04, 1.9549681879E+01, 4.9821692684E+00, 5.8930001566E+00, 2.3721395394E+00, 9.1214646889E-01],
	[2.8890000000E+04, 1.9555222475E+01, 4.9821522907E+00, 5.8963063499E+00, 2.3727528182E+00, 9.1218938634E-01],
	[2.8895000000E+04, 1.9560763682E+01, 4.9821353159E+00, 5.8996138248E+00, 2.3733659842E+00, 9.1223228238E-01],
	[2.8900000000E+04, 1.9566305500E+01, 4.9821183442E+00, 5.9029225816E+00, 2.3739790375E+00, 9.1227515703E-01],
	[2.8905000000E+04, 1.9571847928E+01, 4.9821013754E+00, 5.9062326206E+00, 2.3745919780E+00, 9.1231801029E-01],
	[2.8910000000E+04, 1.9577390968E+01, 4.9820844096E+00, 5.9095439419E+00, 2.3752048056E+00, 9.1236084217E-01],
	[2.8915000000E+04, 1.9582934619E+01, 4.9820674468E+00, 5.9128565460E+00, 2.3758175203E+00, 9.1240365269E-01],
	[2.8920000000E+04, 1.9588478880E+01, 4.9820504870E+00, 5.9161704330E+00, 2.3764301222E+00, 9.1244644184E-01],
	[2.8925000000E+04, 1.9594023752E+01, 4.9820335302E+00, 5.9194856033E+00, 2.3770426110E+00, 9.1248920965E-01],
	[2.8930000000E+04, 1.9599569235E+01, 4.9820165764E+00, 5.9228020571E+00, 2.3776549869E+00, 9.1253195613E-01],
	[2.8935000000E+04, 1.9605115329E+01, 4.9819996256E+00, 5.9261197947E+00, 2.3782672497E+00, 9.1257468127E-01],
	[2.8940000000E+04, 1.9610662033E+01, 4.9819826777E+00, 5.9294388164E+00, 2.3788793994E+00, 9.1261738510E-01],
	[2.8945000000E+04, 1.9616209348E+01, 4.9819657329E+00, 5.9327591224E+00, 2.3794914360E+00, 9.1266006761E-01],
	[2.8950000000E+04, 1.9621757274E+01, 4.9819487910E+00, 5.9360807131E+00, 2.3801033594E+00, 9.1270272883E-01],
	[2.8955000000E+04, 1.9627305810E+01, 4.9819318521E+00, 5.9394035886E+00, 2.3807151696E+00, 9.1274536876E-01],
	[2.8960000000E+04, 1.9632854957E+01, 4.9819149162E+00, 5.9427277493E+00, 2.3813268666E+00, 9.1278798741E-01],
	[2.8965000000E+04, 1.9638404714E+01, 4.9818979833E+00, 5.9460531955E+00, 2.3819384503E+00, 9.1283058479E-01],
	[2.8970000000E+04, 1.9643965629E+01, 4.9818826130E+00, 5.9493799274E+00, 2.3825504326E+00, 9.1287316091E-01],
	[2.8975000000E+04, 1.9649537869E+01, 4.9818688289E+00, 5.9527079452E+00, 2.3831628217E+00, 9.1291571578E-01],
	[2.8980000000E+04, 1.9655110728E+01, 4.9818550472E+00, 5.9560372494E+00, 2.3837750982E+00, 9.1295824941E-01],
	[2.8985000000E+04, 1.9660684206E+01, 4.9818412680E+00, 5.9593678400E+00, 2.3843872619E+00, 9.1300076180E-01],
	[2.8990000000E+04, 1.9666258303E+01, 4.9818274912E+00, 5.9626997175E+00, 2.3849993128E+00, 9.1304325298E-01],
	[2.8995000000E+04, 1.9671833018E+01, 4.9818137168E+00, 5.9660328821E+00, 2.3856112510E+00, 9.1308572294E-01],
	[2.9000000000E+04, 1.9677408352E+01, 4.9817999448E+00, 5.9693673341E+00, 2.3862230763E+00, 9.1312817171E-01],
	[2.9005000000E+04, 1.9682984304E+01, 4.9817861752E+00, 5.9727030737E+00, 2.3868347887E+00, 9.1317059928E-01],
	[2.9010000000E+04, 1.9688560875E+01, 4.9817724080E+00, 5.9760401012E+00, 2.3874463881E+00, 9.1321300567E-01],
	[2.9015000000E+04, 1.9694138064E+01, 4.9817586432E+00, 5.9793784169E+00, 2.3880578746E+00, 9.1325539088E-01],
	[2.9020000000E+04, 1.9699715872E+01, 4.9817448809E+00, 5.9827180211E+00, 2.3886692481E+00, 9.1329775494E-01],
	[2.9025000000E+04, 1.9705294298E+01, 4.9817311209E+00, 5.9860589140E+00, 2.3892805085E+00, 9.1334009784E-01],
	[2.9030000000E+04, 1.9710873343E+01, 4.9817173634E+00, 5.9894010959E+00, 2.3898916559E+00, 9.1338241960E-01],
	[2.9035000000E+04, 1.9716453006E+01, 4.9817036083E+00, 5.9927445672E+00, 2.3905026901E+00, 9.1342472022E-01],
	[2.9040000000E+04, 1.9722033287E+01, 4.9816898555E+00, 5.9960893279E+00, 2.3911136111E+00, 9.1346699972E-01],
	[2.9045000000E+04, 1.9727614186E+01, 4.9816761052E+00, 5.9994353786E+00, 2.3917244190E+00, 9.1350925811E-01],
	[2.9050000000E+04, 1.9733195704E+01, 4.9816623573E+00, 6.0027827193E+00, 2.3923351136E+00, 9.1355149539E-01],
	[2.9055000000E+04, 1.9738777840E+01, 4.9816486118E+00, 6.0061313505E+00, 2.3929456949E+00, 9.1359371158E-01],
	[2.9060000000E+04, 1.9744360594E+01, 4.9816348687E+00, 6.0094812723E+00, 2.3935561629E+00, 9.1363590668E-01],
	[2.9065000000E+04, 1.9749943966E+01, 4.9816211280E+00, 6.0128324850E+00, 2.3941665176E+00, 9.1367808071E-01],
	[2.9070000000E+04, 1.9755527956E+01, 4.9816073897E+00, 6.0161849889E+00, 2.3947767588E+00, 9.1372023367E-01],
	[2.9075000000E+04, 1.9761112564E+01, 4.9815936538E+00, 6.0195387844E+00, 2.3953868866E+00, 9.1376236558E-01],
	[2.9080000000E+04, 1.9766697790E+01, 4.9815799203E+00, 6.0228938716E+00, 2.3959969009E+00, 9.1380447644E-01],
	[2.9085000000E+04, 1.9772283634E+01, 4.9815661892E+00, 6.0262502509E+00, 2.3966068018E+00, 9.1384656627E-01],
	[2.9090000000E+04, 1.9777870096E+01, 4.9815524605E+00, 6.0296079224E+00, 2.3972165890E+00, 9.1388863507E-01],
	[2.9095000000E+04, 1.9783457176E+01, 4.9815387341E+00, 6.0329668866E+00, 2.3978262627E+00, 9.1393068285E-01],
	[2.9100000000E+04, 1.9789044874E+01, 4.9815250102E+00, 6.0363271436E+00, 2.3984358228E+00, 9.1397270962E-01],
	[2.9105000000E+04, 1.9794633189E+01, 4.9815112887E+00, 6.0396886937E+00, 2.3990452692E+00, 9.1401471540E-01],
	[2.9110000000E+04, 1.9800222122E+01, 4.9814975696E+00, 6.0430515373E+00, 2.3996546018E+00, 9.1405670020E-01],
	[2.9115000000E+04, 1.9805811673E+01, 4.9814838529E+00, 6.0464156746E+00, 2.4002638208E+00, 9.1409866401E-01],
	[2.9120000000E+04, 1.9811401842E+01, 4.9814701385E+00, 6.0497811058E+00, 2.4008729259E+00, 9.1414060686E-01],
	[2.9125000000E+04, 1.9816992628E+01, 4.9814564266E+00, 6.0531478313E+00, 2.4014819173E+00, 9.1418252875E-01],
	[2.9130000000E+04, 1.9822584032E+01, 4.9814427170E+00, 6.0565158512E+00, 2.4020907948E+00, 9.1422442969E-01],
	[2.9135000000E+04, 1.9828176053E+01, 4.9814290099E+00, 6.0598851660E+00, 2.4026995584E+00, 9.1426630969E-01],
	[2.9140000000E+04, 1.9833768692E+01, 4.9814153051E+00, 6.0632557759E+00, 2.4033082081E+00, 9.1430816877E-01],
	[2.9145000000E+04, 1.9839361949E+01, 4.9814016027E+00, 6.0666276810E+00, 2.4039167438E+00, 9.1435000692E-01],
	[2.9150000000E+04, 1.9844955823E+01, 4.9813879027E+00, 6.0700008818E+00, 2.4045251655E+00, 9.1439182417E-01],
	[2.9155000000E+04, 1.9850550314E+01, 4.9813742051E+00, 6.0733753785E+00, 2.4051334731E+00, 9.1443362052E-01],
	[2.9160000000E+04, 1.9856145423E+01, 4.9813605099E+00, 6.0767511713E+00, 2.4057416667E+00, 9.1447539597E-01],
	[2.9165000000E+04, 1.9861741149E+01, 4.9813468171E+00, 6.0801282606E+00, 2.4063497462E+00, 9.1451715055E-01],
	[2.9170000000E+04, 1.9867337492E+01, 4.9813331266E+00, 6.0835066466E+00, 2.4069577115E+00, 9.1455888425E-01],
	[2.9175000000E+04, 1.9872934453E+01, 4.9813194386E+00, 6.0868863296E+00, 2.4075655626E+00, 9.1460059708E-01],
	[2.9180000000E+04, 1.9878532031E+01, 4.9813057529E+00, 6.0902673099E+00, 2.4081732995E+00, 9.1464228907E-01],
	[2.9185000000E+04, 1.9884130226E+01, 4.9812920696E+00, 6.0936495876E+00, 2.4087809221E+00, 9.1468396020E-01],
	[2.9190000000E+04, 1.9889729038E+01, 4.9812783887E+00, 6.0970331633E+00, 2.4093884304E+00, 9.1472561050E-01],
	[2.9195000000E+04, 1.9895328467E+01, 4.9812647101E+00, 6.1004180370E+00, 2.4099958244E+00, 9.1476723996E-01],
	[2.9200000000E+04, 1.9900928514E+01, 4.9812510340E+00, 6.1038042090E+00, 2.4106031040E+00, 9.1480884861E-01],
	[2.9205000000E+04, 1.9906529177E+01, 4.9812373602E+00, 6.1071916797E+00, 2.4112102692E+00, 9.1485043645E-01],
	[2.9210000000E+04, 1.9912130458E+01, 4.9812236888E+00, 6.1105804493E+00, 2.4118173199E+00, 9.1489200349E-01],
	[2.9215000000E+04, 1.9917732355E+01, 4.9812100198E+00, 6.1139705182E+00, 2.4124242562E+00, 9.1493354973E-01],
	[2.9220000000E+04, 1.9923334869E+01, 4.9811963531E+00, 6.1173618864E+00, 2.4130310780E+00, 9.1497507519E-01],
	[2.9225000000E+04, 1.9928938001E+01, 4.9811826889E+00, 6.1207545545E+00, 2.4136377851E+00, 9.1501657988E-01],
	[2.9230000000E+04, 1.9934541749E+01, 4.9811690270E+00, 6.1241485225E+00, 2.4142443777E+00, 9.1505806380E-01],
	[2.9235000000E+04, 1.9940146114E+01, 4.9811553675E+00, 6.1275437908E+00, 2.4148508557E+00, 9.1509952696E-01],
	[2.9240000000E+04, 1.9945751095E+01, 4.9811417103E+00, 6.1309403597E+00, 2.4154572190E+00, 9.1514096937E-01],
	[2.9245000000E+04, 1.9951356694E+01, 4.9811280555E+00, 6.1343382295E+00, 2.4160634676E+00, 9.1518239105E-01],
	[2.9250000000E+04, 1.9956962909E+01, 4.9811144031E+00, 6.1377374003E+00, 2.4166696014E+00, 9.1522379200E-01],
	[2.9255000000E+04, 1.9962569741E+01, 4.9811007531E+00, 6.1411378726E+00, 2.4172756205E+00, 9.1526517222E-01],
	[2.9260000000E+04, 1.9968177189E+01, 4.9810871054E+00, 6.1445396465E+00, 2.4178815247E+00, 9.1530653174E-01],
	[2.9265000000E+04, 1.9973785254E+01, 4.9810734602E+00, 6.1479427224E+00, 2.4184873142E+00, 9.1534787055E-01],
	[2.9270000000E+04, 1.9979393936E+01, 4.9810598172E+00, 6.1513471005E+00, 2.4190929887E+00, 9.1538918866E-01],
	[2.9275000000E+04, 1.9985003234E+01, 4.9810461767E+00, 6.1547527810E+00, 2.4196985483E+00, 9.1543048610E-01],
	[2.9280000000E+04, 1.9990613148E+01, 4.9810325385E+00, 6.1581597644E+00, 2.4203039930E+00, 9.1547176285E-01],
	[2.9285000000E+04, 1.9996223679E+01, 4.9810189027E+00, 6.1615680508E+00, 2.4209093226E+00, 9.1551301894E-01],
	[2.9290000000E+04, 2.0001834827E+01, 4.9810052692E+00, 6.1649776405E+00, 2.4215145373E+00, 9.1555425438E-01],
	[2.9295000000E+04, 2.0007446590E+01, 4.9809916381E+00, 6.1683885338E+00, 2.4221196369E+00, 9.1559546916E-01],
	[2.9300000000E+04, 2.0013058970E+01, 4.9809780094E+00, 6.1718007310E+00, 2.4227246213E+00, 9.1563666330E-01],
	[2.9305000000E+04, 2.0018671967E+01, 4.9809643830E+00, 6.1752142323E+00, 2.4233294907E+00, 9.1567783682E-01],
	[2.9310000000E+04, 2.0024285579E+01, 4.9809507590E+00, 6.1786290381E+00, 2.4239342449E+00, 9.1571898971E-01],
	[2.9315000000E+04, 2.0029899808E+01, 4.9809371374E+00, 6.1820451486E+00, 2.4245388839E+00, 9.1576012199E-01],
	[2.9320000000E+04, 2.0035514653E+01, 4.9809235181E+00, 6.1854625640E+00, 2.4251434076E+00, 9.1580123366E-01],
	[2.9325000000E+04, 2.0041130114E+01, 4.9809099012E+00, 6.1888812847E+00, 2.4257478161E+00, 9.1584232475E-01],
	[2.9330000000E+04, 2.0046746192E+01, 4.9808962866E+00, 6.1923013109E+00, 2.4263521092E+00, 9.1588339524E-01],
	[2.9335000000E+04, 2.0052362885E+01, 4.9808826744E+00, 6.1957226429E+00, 2.4269562871E+00, 9.1592444516E-01],
	[2.9340000000E+04, 2.0057980194E+01, 4.9808690645E+00, 6.1991452809E+00, 2.4275603495E+00, 9.1596547451E-01],
	[2.9345000000E+04, 2.0063598119E+01, 4.9808554571E+00, 6.2025692254E+00, 2.4281642965E+00, 9.1600648331E-01],
	[2.9350000000E+04, 2.0069216661E+01, 4.9808418519E+00, 6.2059944764E+00, 2.4287681281E+00, 9.1604747155E-01],
	[2.9355000000E+04, 2.0074835818E+01, 4.9808282491E+00, 6.2094210344E+00, 2.4293718442E+00, 9.1608843925E-01],
	[2.9360000000E+04, 2.0080455591E+01, 4.9808146487E+00, 6.2128488995E+00, 2.4299754448E+00, 9.1612938643E-01],
	[2.9365000000E+04, 2.0086075980E+01, 4.9808010506E+00, 6.2162780721E+00, 2.4305789299E+00, 9.1617031308E-01],
	[2.9370000000E+04, 2.0091696985E+01, 4.9807874549E+00, 6.2197085524E+00, 2.4311822993E+00, 9.1621121921E-01],
	[2.9375000000E+04, 2.0097318605E+01, 4.9807738615E+00, 6.2231403407E+00, 2.4317855531E+00, 9.1625210485E-01],
	[2.9380000000E+04, 2.0102940841E+01, 4.9807602705E+00, 6.2265734373E+00, 2.4323886913E+00, 9.1629296998E-01],
	[2.9385000000E+04, 2.0108563693E+01, 4.9807466818E+00, 6.2300078425E+00, 2.4329917138E+00, 9.1633381464E-01],
	[2.9390000000E+04, 2.0114187161E+01, 4.9807330955E+00, 6.2334435564E+00, 2.4335946206E+00, 9.1637463881E-01],
	[2.9395000000E+04, 2.0119811244E+01, 4.9807195115E+00, 6.2368805795E+00, 2.4341974116E+00, 9.1641544252E-01],
	[2.9400000000E+04, 2.0125435943E+01, 4.9807059299E+00, 6.2403189120E+00, 2.4348000868E+00, 9.1645622577E-01],
	[2.9405000000E+04, 2.0131061257E+01, 4.9806923506E+00, 6.2437585541E+00, 2.4354026462E+00, 9.1649698857E-01],
	[2.9410000000E+04, 2.0136687187E+01, 4.9806787737E+00, 6.2471995062E+00, 2.4360050897E+00, 9.1653773093E-01],
	[2.9415000000E+04, 2.0142313732E+01, 4.9806651991E+00, 6.2506417685E+00, 2.4366074173E+00, 9.1657845285E-01],
	[2.9420000000E+04, 2.0147940893E+01, 4.9806516269E+00, 6.2540853412E+00, 2.4372096290E+00, 9.1661915436E-01],
	[2.9425000000E+04, 2.0153568669E+01, 4.9806380570E+00, 6.2575302247E+00, 2.4378117248E+00, 9.1665983545E-01],
	[2.9430000000E+04, 2.0159197060E+01, 4.9806244894E+00, 6.2609764193E+00, 2.4384137045E+00, 9.1670049614E-01],
	[2.9435000000E+04, 2.0164830902E+01, 4.9806116307E+00, 6.2644239251E+00, 2.4390158084E+00, 9.1674113643E-01],
	[2.9440000000E+04, 2.0170481675E+01, 4.9806011572E+00, 6.2678727426E+00, 2.4396186068E+00, 9.1678175634E-01],
	[2.9445000000E+04, 2.0176133072E+01, 4.9805906856E+00, 6.2713228719E+00, 2.4402212898E+00, 9.1682235587E-01],
	[2.9450000000E+04, 2.0181785092E+01, 4.9805802158E+00, 6.2747743133E+00, 2.4408238573E+00, 9.1686293503E-01],
	[2.9455000000E+04, 2.0187437735E+01, 4.9805697477E+00, 6.2782270672E+00, 2.4414263094E+00, 9.1690349383E-01],
	[2.9460000000E+04, 2.0193091002E+01, 4.9805592815E+00, 6.2816811338E+00, 2.4420286460E+00, 9.1694403228E-01],
	[2.9465000000E+04, 2.0198744893E+01, 4.9805488171E+00, 6.2851365133E+00, 2.4426308670E+00, 9.1698455040E-01],
	[2.9470000000E+04, 2.0204399406E+01, 4.9805383544E+00, 6.2885932060E+00, 2.4432329725E+00, 9.1702504818E-01],
	[2.9475000000E+04, 2.0210054543E+01, 4.9805278936E+00, 6.2920512123E+00, 2.4438349623E+00, 9.1706552564E-01],
	[2.9480000000E+04, 2.0215710303E+01, 4.9805174345E+00, 6.2955105324E+00, 2.4444368365E+00, 9.1710598278E-01],
	[2.9485000000E+04, 2.0221366686E+01, 4.9805069773E+00, 6.2989711665E+00, 2.4450385951E+00, 9.1714641962E-01],
	[2.9490000000E+04, 2.0227023692E+01, 4.9804965218E+00, 6.3024331150E+00, 2.4456402379E+00, 9.1718683617E-01],
	[2.9495000000E+04, 2.0232681322E+01, 4.9804860682E+00, 6.3058963781E+00, 2.4462417650E+00, 9.1722723243E-01],
	[2.9500000000E+04, 2.0238339574E+01, 4.9804756163E+00, 6.3093609561E+00, 2.4468431763E+00, 9.1726760842E-01],
	[2.9505000000E+04, 2.0243998450E+01, 4.9804651662E+00, 6.3128268493E+00, 2.4474444718E+00, 9.1730796413E-01],
	[2.9510000000E+04, 2.0249657948E+01, 4.9804547179E+00, 6.3162940579E+00, 2.4480456515E+00, 9.1734829959E-01],
	[2.9515000000E+04, 2.0255318070E+01, 4.9804442714E+00, 6.3197625823E+00, 2.4486467153E+00, 9.1738861480E-01],
	[2.9520000000E+04, 2.0260978814E+01, 4.9804338267E+00, 6.3232324226E+00, 2.4492476631E+00, 9.1742890977E-01],
	[2.9525000000E+04, 2.0266640181E+01, 4.9804233838E+00, 6.3267035793E+00, 2.4498484951E+00, 9.1746918450E-01],
	[2.9530000000E+04, 2.0272302171E+01, 4.9804129427E+00, 6.3301760524E+00, 2.4504492111E+00, 9.1750943902E-01],
	[2.9535000000E+04, 2.0277964784E+01, 4.9804025034E+00, 6.3336498424E+00, 2.4510498111E+00, 9.1754967332E-01],
	[2.9540000000E+04, 2.0283628020E+01, 4.9803920658E+00, 6.3371249495E+00, 2.4516502950E+00, 9.1758988742E-01],
	[2.9545000000E+04, 2.0289291879E+01, 4.9803816301E+00, 6.3406013740E+00, 2.4522506629E+00, 9.1763008132E-01],
	[2.9550000000E+04, 2.0294956360E+01, 4.9803711961E+00, 6.3440791162E+00, 2.4528509146E+00, 9.1767025504E-01],
	[2.9555000000E+04, 2.0300621464E+01, 4.9803607639E+00, 6.3475581763E+00, 2.4534510503E+00, 9.1771040858E-01],
	[2.9560000000E+04, 2.0306287190E+01, 4.9803503335E+00, 6.3510385545E+00, 2.4540510698E+00, 9.1775054196E-01],
	[2.9565000000E+04, 2.0311953539E+01, 4.9803399049E+00, 6.3545202513E+00, 2.4546509730E+00, 9.1779065518E-01],
	[2.9570000000E+04, 2.0317620511E+01, 4.9803294781E+00, 6.3580032668E+00, 2.4552507601E+00, 9.1783074824E-01],
	[2.9575000000E+04, 2.0323288105E+01, 4.9803190531E+00, 6.3614876014E+00, 2.4558504309E+00, 9.1787082117E-01],
	[2.9580000000E+04, 2.0328956321E+01, 4.9803086298E+00, 6.3649732553E+00, 2.4564499854E+00, 9.1791087397E-01],
	[2.9585000000E+04, 2.0334625160E+01, 4.9802982084E+00, 6.3684602287E+00, 2.4570494235E+00, 9.1795090665E-01],
	[2.9590000000E+04, 2.0340294622E+01, 4.9802877887E+00, 6.3719485220E+00, 2.4576487453E+00, 9.1799091921E-01],
	[2.9595000000E+04, 2.0345964706E+01, 4.9802773708E+00, 6.3754381355E+00, 2.4582479508E+00, 9.1803091167E-01],
	[2.9600000000E+04, 2.0351635412E+01, 4.9802669547E+00, 6.3789290694E+00, 2.4588470397E+00, 9.1807088404E-01],
	[2.9605000000E+04, 2.0357306740E+01, 4.9802565403E+00, 6.3824213239E+00, 2.4594460123E+00, 9.1811083632E-01],
	[2.9610000000E+04, 2.0362978691E+01, 4.9802461278E+00, 6.3859148995E+00, 2.4600448684E+00, 9.1815076853E-01],
	[2.9615000000E+04, 2.0368651264E+01, 4.9802357170E+00, 6.3894097963E+00, 2.4606436079E+00, 9.1819068067E-01],
	[2.9620000000E+04, 2.0374324459E+01, 4.9802253080E+00, 6.3929060146E+00, 2.4612422309E+00, 9.1823057275E-01],
	[2.9625000000E+04, 2.0379998276E+01, 4.9802149008E+00, 6.3964035546E+00, 2.4618407373E+00, 9.1827044479E-01],
	[2.9630000000E+04, 2.0385672716E+01, 4.9802044953E+00, 6.3999024168E+00, 2.4624391271E+00, 9.1831029678E-01],
	[2.9635000000E+04, 2.0391347777E+01, 4.9801940917E+00, 6.4034026013E+00, 2.4630374003E+00, 9.1835012875E-01],
	[2.9640000000E+04, 2.0397023461E+01, 4.9801836898E+00, 6.4069041085E+00, 2.4636355568E+00, 9.1838994069E-01],
	[2.9645000000E+04, 2.0402699766E+01, 4.9801732897E+00, 6.4104069385E+00, 2.4642335966E+00, 9.1842973263E-01],
	[2.9650000000E+04, 2.0408376694E+01, 4.9801628913E+00, 6.4139110917E+00, 2.4648315196E+00, 9.1846950456E-01],
	[2.9655000000E+04, 2.0414054243E+01, 4.9801524948E+00, 6.4174165684E+00, 2.4654293259E+00, 9.1850925649E-01],
	[2.9660000000E+04, 2.0419732414E+01, 4.9801421000E+00, 6.4209233688E+00, 2.4660270154E+00, 9.1854898845E-01],
	[2.9665000000E+04, 2.0425411207E+01, 4.9801317070E+00, 6.4244314932E+00, 2.4666245880E+00, 9.1858870043E-01],
	[2.9670000000E+04, 2.0431090622E+01, 4.9801213157E+00, 6.4279409419E+00, 2.4672220438E+00, 9.1862839244E-01],
	[2.9675000000E+04, 2.0436770659E+01, 4.9801109263E+00, 6.4314517151E+00, 2.4678193827E+00, 9.1866806450E-01],
	[2.9680000000E+04, 2.0442451318E+01, 4.9801005386E+00, 6.4349638132E+00, 2.4684166047E+00, 9.1870771661E-01],
	[2.9685000000E+04, 2.0448132598E+01, 4.9800901527E+00, 6.4384772364E+00, 2.4690137097E+00, 9.1874734878E-01],
	[2.9690000000E+04, 2.0453814500E+01, 4.9800797685E+00, 6.4419919850E+00, 2.4696106978E+00, 9.1878696103E-01],
	[2.9695000000E+04, 2.0459497023E+01, 4.9800693861E+00, 6.4455080592E+00, 2.4702075688E+00, 9.1882655335E-01],
	[2.9700000000E+04, 2.0465180168E+01, 4.9800590055E+00, 6.4490254594E+00, 2.4708043228E+00, 9.1886612576E-01],
	[2.9705000000E+04, 2.0470863935E+01, 4.9800486267E+00, 6.4525441858E+00, 2.4714009598E+00, 9.1890567827E-01],
	[2.9710000000E+04, 2.0476548323E+01, 4.9800382496E+00, 6.4560642387E+00, 2.4719974796E+00, 9.1894521089E-01],
	[2.9715000000E+04, 2.0482233333E+01, 4.9800278743E+00, 6.4595856183E+00, 2.4725938822E+00, 9.1898472363E-01],
	[2.9720000000E+04, 2.0487918964E+01, 4.9800175007E+00, 6.4631083250E+00, 2.4731901678E+00, 9.1902421649E-01],
	[2.9725000000E+04, 2.0493605216E+01, 4.9800071290E+00, 6.4666323590E+00, 2.4737863361E+00, 9.1906368949E-01],
	[2.9730000000E+04, 2.0499292090E+01, 4.9799967590E+00, 6.4701577206E+00, 2.4743823872E+00, 9.1910314263E-01],
	[2.9735000000E+04, 2.0504979586E+01, 4.9799863907E+00, 6.4736844101E+00, 2.4749783210E+00, 9.1914257593E-01],
	[2.9740000000E+04, 2.0510667702E+01, 4.9799760242E+00, 6.4772124277E+00, 2.4755741376E+00, 9.1918198939E-01],
	[2.9745000000E+04, 2.0516356440E+01, 4.9799656595E+00, 6.4807417738E+00, 2.4761698368E+00, 9.1922138302E-01],
	[2.9750000000E+04, 2.0522045799E+01, 4.9799552966E+00, 6.4842724486E+00, 2.4767654187E+00, 9.1926075684E-01],
	[2.9755000000E+04, 2.0527735779E+01, 4.9799449354E+00, 6.4878044523E+00, 2.4773608832E+00, 9.1930011084E-01],
	[2.9760000000E+04, 2.0533426381E+01, 4.9799345760E+00, 6.4913377853E+00, 2.4779562303E+00, 9.1933944505E-01],
	[2.9765000000E+04, 2.0539117603E+01, 4.9799242183E+00, 6.4948724478E+00, 2.4785514600E+00, 9.1937875946E-01],
	[2.9770000000E+04, 2.0544809447E+01, 4.9799138624E+00, 6.4984084402E+00, 2.4791465722E+00, 9.1941805409E-01],
	[2.9775000000E+04, 2.0550501912E+01, 4.9799035083E+00, 6.5019457626E+00, 2.4797415669E+00, 9.1945732895E-01],
	[2.9780000000E+04, 2.0556194997E+01, 4.9798931559E+00, 6.5054844154E+00, 2.4803364441E+00, 9.1949658405E-01],
	[2.9785000000E+04, 2.0561888704E+01, 4.9798828053E+00, 6.5090243988E+00, 2.4809312037E+00, 9.1953581939E-01],
	[2.9790000000E+04, 2.0567583032E+01, 4.9798724564E+00, 6.5125657131E+00, 2.4815258458E+00, 9.1957503498E-01],
	[2.9795000000E+04, 2.0573277980E+01, 4.9798621093E+00, 6.5161083586E+00, 2.4821203702E+00, 9.1961423084E-01],
	[2.9800000000E+04, 2.0578973549E+01, 4.9798517640E+00, 6.5196523356E+00, 2.4827147770E+00, 9.1965340698E-01],
	[2.9805000000E+04, 2.0584669740E+01, 4.9798414204E+00, 6.5231976443E+00, 2.4833090662E+00, 9.1969256340E-01],
	[2.9810000000E+04, 2.0590366551E+01, 4.9798310786E+00, 6.5267442851E+00, 2.4839032376E+00, 9.1973170011E-01],
	[2.9815000000E+04, 2.0596063982E+01, 4.9798207385E+00, 6.5302922581E+00, 2.4844972913E+00, 9.1977081712E-01],
	[2.9820000000E+04, 2.0601762035E+01, 4.9798104002E+00, 6.5338415637E+00, 2.4850912272E+00, 9.1980991444E-01],
	[2.9825000000E+04, 2.0607460708E+01, 4.9798000636E+00, 6.5373922022E+00, 2.4856850454E+00, 9.1984899208E-01],
	[2.9830000000E+04, 2.0613160002E+01, 4.9797897288E+00, 6.5409441738E+00, 2.4862787457E+00, 9.1988805005E-01],
	[2.9835000000E+04, 2.0618859916E+01, 4.9797793957E+00, 6.5444974788E+00, 2.4868723282E+00, 9.1992708835E-01],
	[2.9840000000E+04, 2.0624560451E+01, 4.9797690644E+00, 6.5480521175E+00, 2.4874657929E+00, 9.1996610701E-01],
	[2.9845000000E+04, 2.0630261607E+01, 4.9797587349E+00, 6.5516080901E+00, 2.4880591396E+00, 9.2000510602E-01],
	[2.9850000000E+04, 2.0635963383E+01, 4.9797484071E+00, 6.5551653970E+00, 2.4886523684E+00, 9.2004408540E-01],
	[2.9855000000E+04, 2.0641665779E+01, 4.9797380810E+00, 6.5587240383E+00, 2.4892454792E+00, 9.2008304515E-01],
	[2.9860000000E+04, 2.0647368796E+01, 4.9797277567E+00, 6.5622840145E+00, 2.4898384720E+00, 9.2012198528E-01],
	[2.9865000000E+04, 2.0653072433E+01, 4.9797174342E+00, 6.5658453257E+00, 2.4904313469E+00, 9.2016090581E-01],
	[2.9870000000E+04, 2.0658776691E+01, 4.9797071134E+00, 6.5694079723E+00, 2.4910241037E+00, 9.2019980675E-01],
	[2.9875000000E+04, 2.0664481569E+01, 4.9796967943E+00, 6.5729719544E+00, 2.4916167424E+00, 9.2023868809E-01],
	[2.9880000000E+04, 2.0670187067E+01, 4.9796864770E+00, 6.5765372725E+00, 2.4922092630E+00, 9.2027754985E-01],
	[2.9885000000E+04, 2.0675893186E+01, 4.9796761615E+00, 6.5801039267E+00, 2.4928016654E+00, 9.2031639205E-01],
	[2.9890000000E+04, 2.0681599925E+01, 4.9796658477E+00, 6.5836719174E+00, 2.4933939498E+00, 9.2035521468E-01],
	[2.9895000000E+04, 2.0687307284E+01, 4.9796555356E+00, 6.5872412448E+00, 2.4939861159E+00, 9.2039401777E-01],
	[2.9900000000E+04, 2.0693015263E+01, 4.9796452253E+00, 6.5908119092E+00, 2.4945781638E+00, 9.2043280131E-01],
	[2.9905000000E+04, 2.0698723862E+01, 4.9796349167E+00, 6.5943839109E+00, 2.4951700935E+00, 9.2047156532E-01],
	[2.9910000000E+04, 2.0704442746E+01, 4.9796260055E+00, 6.5979572501E+00, 2.4957623959E+00, 9.2051030980E-01],
	[2.9915000000E+04, 2.0710173619E+01, 4.9796187363E+00, 6.6015319272E+00, 2.4963551577E+00, 9.2054903477E-01],
	[2.9920000000E+04, 2.0715905120E+01, 4.9796114683E+00, 6.6051079423E+00, 2.4969478019E+00, 9.2058774024E-01],
	[2.9925000000E+04, 2.0721637249E+01, 4.9796042015E+00, 6.6086852959E+00, 2.4975403284E+00, 9.2062642621E-01],
	[2.9930000000E+04, 2.0727370006E+01, 4.9795969359E+00, 6.6122639881E+00, 2.4981327371E+00, 9.2066509269E-01],
	[2.9935000000E+04, 2.0733103391E+01, 4.9795896716E+00, 6.6158440192E+00, 2.4987250282E+00, 9.2070373970E-01],
	[2.9940000000E+04, 2.0738837404E+01, 4.9795824085E+00, 6.6194253895E+00, 2.4993172014E+00, 9.2074236724E-01],
	[2.9945000000E+04, 2.0744572045E+01, 4.9795751466E+00, 6.6230080994E+00, 2.4999092569E+00, 9.2078097531E-01],
	[2.9950000000E+04, 2.0750307314E+01, 4.9795678860E+00, 6.6265921490E+00, 2.5005011945E+00, 9.2081956394E-01],
	[2.9955000000E+04, 2.0756043210E+01, 4.9795606265E+00, 6.6301775386E+00, 2.5010930143E+00, 9.2085813313E-01],
	[2.9960000000E+04, 2.0761779735E+01, 4.9795533683E+00, 6.6337642686E+00, 2.5016847162E+00, 9.2089668289E-01],
	[2.9965000000E+04, 2.0767516887E+01, 4.9795461113E+00, 6.6373523392E+00, 2.5022763002E+00, 9.2093521323E-01],
	[2.9970000000E+04, 2.0773254667E+01, 4.9795388555E+00, 6.6409417506E+00, 2.5028677663E+00, 9.2097372415E-01],
	[2.9975000000E+04, 2.0778993075E+01, 4.9795316010E+00, 6.6445325032E+00, 2.5034591144E+00, 9.2101221567E-01],
	[2.9980000000E+04, 2.0784732110E+01, 4.9795243477E+00, 6.6481245972E+00, 2.5040503445E+00, 9.2105068779E-01],
	[2.9985000000E+04, 2.0790471773E+01, 4.9795170955E+00, 6.6517180329E+00, 2.5046414566E+00, 9.2108914054E-01],
	[2.9990000000E+04, 2.0796212063E+01, 4.9795098447E+00, 6.6553128106E+00, 2.5052324507E+00, 9.2112757390E-01],
	[2.9995000000E+04, 2.0801952981E+01, 4.9795025950E+00, 6.6589089306E+00, 2.5058233267E+00, 9.2116598790E-01],
	[3.0000000000E+04, 2.0807694527E+01, 4.9794953465E+00, 6.6625063931E+00, 2.5064140846E+00, 9.2120438254E-01],
	[3.0005000000E+04, 2.0813436700E+01, 4.9794880993E+00, 6.6661266625E+00, 2.5070077602E+00, 9.2124275783E-01],
	[3.0010000000E+04, 2.0819179500E+01, 4.9794808533E+00, 6.6697482947E+00, 2.5076013167E+00, 9.2128111379E-01],
	[3.0015000000E+04, 2.0824922928E+01, 4.9794736085E+00, 6.6733712899E+00, 2.5081947541E+00, 9.2131945041E-01],
	[3.0020000000E+04, 2.0830666984E+01, 4.9794663649E+00, 6.6769956484E+00, 2.5087880724E+00, 9.2135776772E-01],
	[3.0025000000E+04, 2.0836411666E+01, 4.9794591225E+00, 6.6806213705E+00, 2.5093812715E+00, 9.2139606571E-01],
	[3.0030000000E+04, 2.0842156976E+01, 4.9794518814E+00, 6.6842484565E+00, 2.5099743514E+00, 9.2143434440E-01],
	[3.0035000000E+04, 2.0847902913E+01, 4.9794446415E+00, 6.6878769066E+00, 2.5105673121E+00, 9.2147260380E-01],
	[3.0040000000E+04, 2.0853649478E+01, 4.9794374027E+00, 6.6915067212E+00, 2.5111601536E+00, 9.2151084392E-01],
	[3.0045000000E+04, 2.0859396669E+01, 4.9794301652E+00, 6.6951379005E+00, 2.5117528758E+00, 9.2154906476E-01],
	[3.0050000000E+04, 2.0865144488E+01, 4.9794229290E+00, 6.6987704448E+00, 2.5123454786E+00, 9.2158726634E-01],
	[3.0055000000E+04, 2.0870892934E+01, 4.9794156939E+00, 6.7024043545E+00, 2.5129379622E+00, 9.2162544866E-01],
	[3.0060000000E+04, 2.0876642007E+01, 4.9794084600E+00, 6.7060396297E+00, 2.5135303264E+00, 9.2166361174E-01],
	[3.0065000000E+04, 2.0882391707E+01, 4.9794012274E+00, 6.7096762708E+00, 2.5141225712E+00, 9.2170175558E-01],
	[3.0070000000E+04, 2.0888142034E+01, 4.9793939960E+00, 6.7133142781E+00, 2.5147146966E+00, 9.2173988019E-01],
	[3.0075000000E+04, 2.0893892988E+01, 4.9793867657E+00, 6.7169536518E+00, 2.5153067025E+00, 9.2177798558E-01],
	[3.0080000000E+04, 2.0899644569E+01, 4.9793795367E+00, 6.7205943922E+00, 2.5158985890E+00, 9.2181607176E-01],
	[3.0085000000E+04, 2.0905396777E+01, 4.9793723089E+00, 6.7242364997E+00, 2.5164903560E+00, 9.2185413875E-01],
	[3.0090000000E+04, 2.0911149612E+01, 4.9793650824E+00, 6.7278799744E+00, 2.5170820035E+00, 9.2189218654E-01],
	[3.0095000000E+04, 2.0916903074E+01, 4.9793578570E+00, 6.7315248168E+00, 2.5176735315E+00, 9.2193021515E-01],
	[3.0100000000E+04, 2.0922657162E+01, 4.9793506328E+00, 6.7351710270E+00, 2.5182649399E+00, 9.2196822459E-01],
	[3.0105000000E+04, 2.0928411877E+01, 4.9793434099E+00, 6.7388186054E+00, 2.5188562286E+00, 9.2200621487E-01],
	[3.0110000000E+04, 2.0934167219E+01, 4.9793361881E+00, 6.7424675523E+00, 2.5194473978E+00, 9.2204418601E-01],
	[3.0115000000E+04, 2.0939923188E+01, 4.9793289676E+00, 6.7461178678E+00, 2.5200384473E+00, 9.2208213805E-01],
	[3.0120000000E+04, 2.0945679783E+01, 4.9793217483E+00, 6.7497695524E+00, 2.5206293771E+00, 9.2212007098E-01],
	[3.0125000000E+04, 2.0951437005E+01, 4.9793145302E+00, 6.7534226063E+00, 2.5212201873E+00, 9.2215798481E-01],
	[3.0130000000E+04, 2.0957194853E+01, 4.9793073133E+00, 6.7570770298E+00, 2.5218108777E+00, 9.2219587955E-01],
	[3.0135000000E+04, 2.0962953328E+01, 4.9793000976E+00, 6.7607328231E+00, 2.5224014483E+00, 9.2223375522E-01],
	[3.0140000000E+04, 2.0968712430E+01, 4.9792928831E+00, 6.7643899866E+00, 2.5229918992E+00, 9.2227161181E-01],
	[3.0145000000E+04, 2.0974472158E+01, 4.9792856698E+00, 6.7680485206E+00, 2.5235822302E+00, 9.2230944933E-01],
	[3.0150000000E+04, 2.0980232512E+01, 4.9792784577E+00, 6.7717084253E+00, 2.5241724415E+00, 9.2234726780E-01],
	[3.0155000000E+04, 2.0985993493E+01, 4.9792712469E+00, 6.7753697010E+00, 2.5247625328E+00, 9.2238506722E-01],
	[3.0160000000E+04, 2.0991755100E+01, 4.9792640372E+00, 6.7790323480E+00, 2.5253525043E+00, 9.2242284760E-01],
	[3.0165000000E+04, 2.0997517334E+01, 4.9792568288E+00, 6.7826963665E+00, 2.5259423559E+00, 9.2246060895E-01],
	[3.0170000000E+04, 2.1003280194E+01, 4.9792496215E+00, 6.7863617570E+00, 2.5265320875E+00, 9.2249835128E-01],
	[3.0175000000E+04, 2.1009043680E+01, 4.9792424155E+00, 6.7900285196E+00, 2.5271216992E+00, 9.2253607459E-01],
	[3.0180000000E+04, 2.1014807792E+01, 4.9792352106E+00, 6.7936966547E+00, 2.5277111909E+00, 9.2257377889E-01],
	[3.0185000000E+04, 2.1020572531E+01, 4.9792280070E+00, 6.7973661625E+00, 2.5283005625E+00, 9.2261146419E-01],
	[3.0190000000E+04, 2.1026337895E+01, 4.9792208046E+00, 6.8010370433E+00, 2.5288898142E+00, 9.2264913050E-01],
	[3.0195000000E+04, 2.1032103886E+01, 4.9792136033E+00, 6.8047092974E+00, 2.5294789457E+00, 9.2268677783E-01],
	[3.0200000000E+04, 2.1037870503E+01, 4.9792064033E+00, 6.8083829252E+00, 2.5300679572E+00, 9.2272440618E-01],
	[3.0205000000E+04, 2.1043637746E+01, 4.9791992045E+00, 6.8120579267E+00, 2.5306568486E+00, 9.2276201557E-01],
	[3.0210000000E+04, 2.1049405615E+01, 4.9791920068E+00, 6.8157343025E+00, 2.5312456198E+00, 9.2279960599E-01],
	[3.0215000000E+04, 2.1055174110E+01, 4.9791848104E+00, 6.8194120527E+00, 2.5318342708E+00, 9.2283717747E-01],
	[3.0220000000E+04, 2.1060943231E+01, 4.9791776152E+00, 6.8230911776E+00, 2.5324228017E+00, 9.2287473000E-01],
	[3.0225000000E+04, 2.1066712978E+01, 4.9791704212E+00, 6.8267716775E+00, 2.5330112123E+00, 9.2291226360E-01],
	[3.0230000000E+04, 2.1072483350E+01, 4.9791632284E+00, 6.8304535528E+00, 2.5335995027E+00, 9.2294977827E-01],
	[3.0235000000E+04, 2.1078254349E+01, 4.9791560367E+00, 6.8341368036E+00, 2.5341876729E+00, 9.2298727403E-01],
	[3.0240000000E+04, 2.1084025973E+01, 4.9791488463E+00, 6.8378214303E+00, 2.5347757227E+00, 9.2302475087E-01],
	[3.0245000000E+04, 2.1089798223E+01, 4.9791416571E+00, 6.8415074332E+00, 2.5353636523E+00, 9.2306220881E-01],
	[3.0250000000E+04, 2.1095571099E+01, 4.9791344691E+00, 6.8451948125E+00, 2.5359514615E+00, 9.2309964786E-01],
	[3.0255000000E+04, 2.1101344600E+01, 4.9791272823E+00, 6.8488835686E+00, 2.5365391503E+00, 9.2313706803E-01],
	[3.0260000000E+04, 2.1107118727E+01, 4.9791200966E+00, 6.8525737016E+00, 2.5371267187E+00, 9.2317446931E-01],
	[3.0265000000E+04, 2.1112893480E+01, 4.9791129122E+00, 6.8562652120E+00, 2.5377141667E+00, 9.2321185173E-01],
	[3.0270000000E+04, 2.1118668858E+01, 4.9791057290E+00, 6.8599581000E+00, 2.5383014943E+00, 9.2324921529E-01],
	[3.0275000000E+04, 2.1124444862E+01, 4.9790985469E+00, 6.8636523658E+00, 2.5388887014E+00, 9.2328655999E-01],
	[3.0280000000E+04, 2.1130221492E+01, 4.9790913661E+00, 6.8673480098E+00, 2.5394757881E+00, 9.2332388585E-01],
	[3.0285000000E+04, 2.1135998747E+01, 4.9790841865E+00, 6.8710450323E+00, 2.5400627542E+00, 9.2336119288E-01],
	[3.0290000000E+04, 2.1141776627E+01, 4.9790770080E+00, 6.8747434335E+00, 2.5406495998E+00, 9.2339848107E-01],
	[3.0295000000E+04, 2.1147555133E+01, 4.9790698308E+00, 6.8784432137E+00, 2.5412363248E+00, 9.2343575045E-01],
	[3.0300000000E+04, 2.1153334264E+01, 4.9790626547E+00, 6.8821443732E+00, 2.5418229292E+00, 9.2347300102E-01],
	[3.0305000000E+04, 2.1159114020E+01, 4.9790554799E+00, 6.8858469123E+00, 2.5424094130E+00, 9.2351023278E-01],
	[3.0310000000E+04, 2.1164894402E+01, 4.9790483062E+00, 6.8895508313E+00, 2.5429957762E+00, 9.2354744574E-01],
	[3.0315000000E+04, 2.1170675409E+01, 4.9790411337E+00, 6.8932561305E+00, 2.5435820187E+00, 9.2358463992E-01],
	[3.0320000000E+04, 2.1176457041E+01, 4.9790339624E+00, 6.8969628101E+00, 2.5441681406E+00, 9.2362181532E-01],
	[3.0325000000E+04, 2.1182239299E+01, 4.9790267923E+00, 6.9006708704E+00, 2.5447541417E+00, 9.2365897195E-01],
	[3.0330000000E+04, 2.1188022181E+01, 4.9790196234E+00, 6.9043803118E+00, 2.5453400221E+00, 9.2369610982E-01],
	[3.0335000000E+04, 2.1193805689E+01, 4.9790124557E+00, 6.9080911345E+00, 2.5459257818E+00, 9.2373322893E-01],
	[3.0340000000E+04, 2.1199589822E+01, 4.9790052892E+00, 6.9118033388E+00, 2.5465114206E+00, 9.2377032930E-01],
	[3.0345000000E+04, 2.1205374580E+01, 4.9789981239E+00, 6.9155169249E+00, 2.5470969387E+00, 9.2380741093E-01],
	[3.0350000000E+04, 2.1211159962E+01, 4.9789909598E+00, 6.9192318933E+00, 2.5476823360E+00, 9.2384447383E-01],
	[3.0355000000E+04, 2.1216945970E+01, 4.9789837968E+00, 6.9229482440E+00, 2.5482676124E+00, 9.2388151801E-01],
	[3.0360000000E+04, 2.1222732603E+01, 4.9789766351E+00, 6.9266659776E+00, 2.5488527679E+00, 9.2391854348E-01],
	[3.0365000000E+04, 2.1228519861E+01, 4.9789694745E+00, 6.9303850941E+00, 2.5494378025E+00, 9.2395555024E-01],
	[3.0370000000E+04, 2.1234307743E+01, 4.9789623152E+00, 6.9341055940E+00, 2.5500227162E+00, 9.2399253831E-01],
	[3.0375000000E+04, 2.1240096251E+01, 4.9789551570E+00, 6.9378274775E+00, 2.5506075090E+00, 9.2402950769E-01],
	[3.0380000000E+04, 2.1245885383E+01, 4.9789480000E+00, 6.9415507448E+00, 2.5511921808E+00, 9.2406645838E-01],
	[3.0385000000E+04, 2.1251675140E+01, 4.9789408442E+00, 6.9452753963E+00, 2.5517767316E+00, 9.2410339041E-01],
	[3.0390000000E+04, 2.1257468961E+01, 4.9789341808E+00, 6.9490014323E+00, 2.5523613401E+00, 9.2414030377E-01],
	[3.0395000000E+04, 2.1263280818E+01, 4.9789300042E+00, 6.9527288530E+00, 2.5529467322E+00, 9.2417719848E-01],
	[3.0400000000E+04, 2.1269093308E+01, 4.9789258283E+00, 6.9564576588E+00, 2.5535320038E+00, 9.2421407454E-01],
	[3.0405000000E+04, 2.1274906430E+01, 4.9789216531E+00, 6.9601878499E+00, 2.5541171550E+00, 9.2425093196E-01],
	[3.0410000000E+04, 2.1280720184E+01, 4.9789174785E+00, 6.9639194266E+00, 2.5547021857E+00, 9.2428777076E-01],
	[3.0415000000E+04, 2.1286534571E+01, 4.9789133047E+00, 6.9676523891E+00, 2.5552870960E+00, 9.2432459093E-01],
	[3.0420000000E+04, 2.1292349591E+01, 4.9789091316E+00, 6.9713867379E+00, 2.5558718858E+00, 9.2436139248E-01],
	[3.0425000000E+04, 2.1298165243E+01, 4.9789049591E+00, 6.9751224731E+00, 2.5564565550E+00, 9.2439817543E-01],
	[3.0430000000E+04, 2.1303981528E+01, 4.9789007873E+00, 6.9788595950E+00, 2.5570411037E+00, 9.2443493979E-01],
	[3.0435000000E+04, 2.1309798444E+01, 4.9788966163E+00, 6.9825981040E+00, 2.5576255319E+00, 9.2447168555E-01],
	[3.0440000000E+04, 2.1315615993E+01, 4.9788924459E+00, 6.9863380003E+00, 2.5582098394E+00, 9.2450841274E-01],
	[3.0445000000E+04, 2.1321434175E+01, 4.9788882762E+00, 6.9900792843E+00, 2.5587940263E+00, 9.2454512135E-01],
	[3.0450000000E+04, 2.1327252989E+01, 4.9788841072E+00, 6.9938219561E+00, 2.5593780926E+00, 9.2458181139E-01],
	[3.0455000000E+04, 2.1333072435E+01, 4.9788799389E+00, 6.9975660161E+00, 2.5599620383E+00, 9.2461848288E-01],
	[3.0460000000E+04, 2.1338892513E+01, 4.9788757712E+00, 7.0013114645E+00, 2.5605458632E+00, 9.2465513583E-01],
	[3.0465000000E+04, 2.1344713223E+01, 4.9788716043E+00, 7.0050583018E+00, 2.5611295675E+00, 9.2469177023E-01],
	[3.0470000000E+04, 2.1350534565E+01, 4.9788674380E+00, 7.0088065280E+00, 2.5617131510E+00, 9.2472838611E-01],
	[3.0475000000E+04, 2.1356356540E+01, 4.9788632724E+00, 7.0125561436E+00, 2.5622966138E+00, 9.2476498346E-01],
	[3.0480000000E+04, 2.1362179146E+01, 4.9788591076E+00, 7.0163071488E+00, 2.5628799558E+00, 9.2480156229E-01],
	[3.0485000000E+04, 2.1368002385E+01, 4.9788549434E+00, 7.0200595439E+00, 2.5634631770E+00, 9.2483812263E-01],
	[3.0490000000E+04, 2.1373826255E+01, 4.9788507798E+00, 7.0238133292E+00, 2.5640462774E+00, 9.2487466446E-01],
	[3.0495000000E+04, 2.1379650758E+01, 4.9788466170E+00, 7.0275685050E+00, 2.5646292569E+00, 9.2491118780E-01],
	[3.0500000000E+04, 2.1385475892E+01, 4.9788424549E+00, 7.0313250715E+00, 2.5652121156E+00, 9.2494769266E-01],
	[3.0505000000E+04, 2.1391301658E+01, 4.9788382934E+00, 7.0350830290E+00, 2.5657948534E+00, 9.2498417905E-01],
	[3.0510000000E+04, 2.1397128056E+01, 4.9788341326E+00, 7.0388423779E+00, 2.5663774703E+00, 9.2502064698E-01],
	[3.0515000000E+04, 2.1402955086E+01, 4.9788299726E+00, 7.0426031185E+00, 2.5669599663E+00, 9.2505709645E-01],
	[3.0520000000E+04, 2.1408782748E+01, 4.9788258132E+00, 7.0463652509E+00, 2.5675423413E+00, 9.2509352747E-01],
	[3.0525000000E+04, 2.1414611041E+01, 4.9788216544E+00, 7.0501287755E+00, 2.5681245954E+00, 9.2512994005E-01],
	[3.0530000000E+04, 2.1420439966E+01, 4.9788174964E+00, 7.0538936926E+00, 2.5687067285E+00, 9.2516633420E-01],
	[3.0535000000E+04, 2.1426269523E+01, 4.9788133391E+00, 7.0576600025E+00, 2.5692887405E+00, 9.2520270993E-01],
	[3.0540000000E+04, 2.1432099711E+01, 4.9788091824E+00, 7.0614277054E+00, 2.5698706315E+00, 9.2523906724E-01],
	[3.0545000000E+04, 2.1437930531E+01, 4.9788050264E+00, 7.0651968016E+00, 2.5704524015E+00, 9.2527540614E-01],
	[3.0550000000E+04, 2.1443761983E+01, 4.9788008711E+00, 7.0689672915E+00, 2.5710340504E+00, 9.2531172665E-01],
	[3.0555000000E+04, 2.1449594066E+01, 4.9787967165E+00, 7.0727391753E+00, 2.5716155782E+00, 9.2534802877E-01],
	[3.0560000000E+04, 2.1455426780E+01, 4.9787925626E+00, 7.0765124533E+00, 2.5721969848E+00, 9.2538431251E-01],
	[3.0565000000E+04, 2.1461260126E+01, 4.9787884094E+00, 7.0802871257E+00, 2.5727782703E+00, 9.2542057787E-01],
	[3.0570000000E+04, 2.1467094104E+01, 4.9787842568E+00, 7.0840631930E+00, 2.5733594347E+00, 9.2545682487E-01],
	[3.0575000000E+04, 2.1472928713E+01, 4.9787801049E+00, 7.0878406553E+00, 2.5739404778E+00, 9.2549305352E-01],
	[3.0580000000E+04, 2.1478763953E+01, 4.9787759537E+00, 7.0916195129E+00, 2.5745213998E+00, 9.2552926381E-01],
	[3.0585000000E+04, 2.1484599824E+01, 4.9787718032E+00, 7.0953997662E+00, 2.5751022005E+00, 9.2556545577E-01],
	[3.0590000000E+04, 2.1490436327E+01, 4.9787676534E+00, 7.0991814154E+00, 2.5756828800E+00, 9.2560162939E-01],
	[3.0595000000E+04, 2.1496273461E+01, 4.9787635042E+00, 7.1029644608E+00, 2.5762634382E+00, 9.2563778469E-01],
	[3.0600000000E+04, 2.1502111226E+01, 4.9787593558E+00, 7.1067489027E+00, 2.5768438751E+00, 9.2567392168E-01],
	[3.0605000000E+04, 2.1507949622E+01, 4.9787552080E+00, 7.1105347414E+00, 2.5774241907E+00, 9.2571004036E-01],
	[3.0610000000E+04, 2.1513788650E+01, 4.9787510609E+00, 7.1143219771E+00, 2.5780043850E+00, 9.2574614075E-01],
	[3.0615000000E+04, 2.1519628308E+01, 4.9787469144E+00, 7.1181106102E+00, 2.5785844579E+00, 9.2578222284E-01],
	[3.0620000000E+04, 2.1525468598E+01, 4.9787427687E+00, 7.1219006410E+00, 2.5791644094E+00, 9.2581828665E-01],
	[3.0625000000E+04, 2.1531309519E+01, 4.9787386236E+00, 7.1256920696E+00, 2.5797442396E+00, 9.2585433219E-01],
	[3.0630000000E+04, 2.1537151070E+01, 4.9787344793E+00, 7.1294848965E+00, 2.5803239483E+00, 9.2589035947E-01],
	[3.0635000000E+04, 2.1542993253E+01, 4.9787303355E+00, 7.1332791219E+00, 2.5809035356E+00, 9.2592636849E-01],
	[3.0640000000E+04, 2.1548836067E+01, 4.9787261925E+00, 7.1370747460E+00, 2.5814830014E+00, 9.2596235926E-01],
	[3.0645000000E+04, 2.1554679511E+01, 4.9787220502E+00, 7.1408717693E+00, 2.5820623457E+00, 9.2599833179E-01],
	[3.0650000000E+04, 2.1560523587E+01, 4.9787179085E+00, 7.1446701919E+00, 2.5826415686E+00, 9.2603428609E-01],
	[3.0655000000E+04, 2.1566368293E+01, 4.9787137675E+00, 7.1484700141E+00, 2.5832206699E+00, 9.2607022217E-01],
	[3.0660000000E+04, 2.1572213630E+01, 4.9787096272E+00, 7.1522712363E+00, 2.5837996497E+00, 9.2610614004E-01],
	[3.0665000000E+04, 2.1578059597E+01, 4.9787054876E+00, 7.1560738587E+00, 2.5843785079E+00, 9.2614203969E-01],
	[3.0670000000E+04, 2.1583906196E+01, 4.9787013486E+00, 7.1598778816E+00, 2.5849572446E+00, 9.2617792116E-01],
	[3.0675000000E+04, 2.1589753425E+01, 4.9786972104E+00, 7.1636833053E+00, 2.5855358596E+00, 9.2621378443E-01],
	[3.0680000000E+04, 2.1595601285E+01, 4.9786930728E+00, 7.1674901301E+00, 2.5861143530E+00, 9.2624962952E-01],
	[3.0685000000E+04, 2.1601449775E+01, 4.9786889358E+00, 7.1712983563E+00, 2.5866927248E+00, 9.2628545644E-01],
	[3.0690000000E+04, 2.1607298896E+01, 4.9786847996E+00, 7.1751079841E+00, 2.5872709749E+00, 9.2632126519E-01],
	[3.0695000000E+04, 2.1613148648E+01, 4.9786806640E+00, 7.1789190138E+00, 2.5878491034E+00, 9.2635705579E-01],
	[3.0700000000E+04, 2.1618999030E+01, 4.9786765292E+00, 7.1827314458E+00, 2.5884271101E+00, 9.2639282825E-01],
	[3.0705000000E+04, 2.1624850042E+01, 4.9786723949E+00, 7.1865452803E+00, 2.5890049951E+00, 9.2642858256E-01],
	[3.0710000000E+04, 2.1630701685E+01, 4.9786682614E+00, 7.1903605176E+00, 2.5895827584E+00, 9.2646431874E-01],
	[3.0715000000E+04, 2.1636553958E+01, 4.9786641286E+00, 7.1941771580E+00, 2.5901603999E+00, 9.2650003680E-01],
	[3.0720000000E+04, 2.1642406862E+01, 4.9786599964E+00, 7.1979952018E+00, 2.5907379196E+00, 9.2653573675E-01],
	[3.0725000000E+04, 2.1648260396E+01, 4.9786558649E+00, 7.2018146493E+00, 2.5913153176E+00, 9.2657141859E-01],
	[3.0730000000E+04, 2.1654114561E+01, 4.9786517340E+00, 7.2056355007E+00, 2.5918925937E+00, 9.2660708234E-01],
	[3.0735000000E+04, 2.1659969355E+01, 4.9786476039E+00, 7.2094577563E+00, 2.5924697480E+00, 9.2664272800E-01],
	[3.0740000000E+04, 2.1665824780E+01, 4.9786434744E+00, 7.2132814165E+00, 2.5930467804E+00, 9.2667835557E-01],
	[3.0745000000E+04, 2.1671680835E+01, 4.9786393456E+00, 7.2171064814E+00, 2.5936236909E+00, 9.2671396508E-01],
	[3.0750000000E+04, 2.1677537521E+01, 4.9786352175E+00, 7.2209329515E+00, 2.5942004796E+00, 9.2674955652E-01],
	[3.0755000000E+04, 2.1683394836E+01, 4.9786310900E+00, 7.2247608270E+00, 2.5947771463E+00, 9.2678512991E-01],
	[3.0760000000E+04, 2.1689252781E+01, 4.9786269633E+00, 7.2285901081E+00, 2.5953536911E+00, 9.2682068525E-01],
	[3.0765000000E+04, 2.1695111357E+01, 4.9786228372E+00, 7.2324207952E+00, 2.5959301139E+00, 9.2685622255E-01],
	[3.0770000000E+04, 2.1700970563E+01, 4.9786187117E+00, 7.2362528886E+00, 2.5965064148E+00, 9.2689174182E-01],
	[3.0775000000E+04, 2.1706830398E+01, 4.9786145870E+00, 7.2400863885E+00, 2.5970825936E+00, 9.2692724308E-01],
	[3.0780000000E+04, 2.1712690864E+01, 4.9786104629E+00, 7.2439212952E+00, 2.5976586505E+00, 9.2696272631E-01],
	[3.0785000000E+04, 2.1718551959E+01, 4.9786063395E+00, 7.2477576090E+00, 2.5982345853E+00, 9.2699819155E-01],
	[3.0790000000E+04, 2.1724413684E+01, 4.9786022167E+00, 7.2515953303E+00, 2.5988103981E+00, 9.2703363879E-01],
	[3.0795000000E+04, 2.1730276040E+01, 4.9785980947E+00, 7.2554344592E+00, 2.5993860888E+00, 9.2706906804E-01],
	[3.0800000000E+04, 2.1736139025E+01, 4.9785939733E+00, 7.2592749961E+00, 2.5999616574E+00, 9.2710447931E-01],
	[3.0805000000E+04, 2.1742002639E+01, 4.9785898526E+00, 7.2631169412E+00, 2.6005371039E+00, 9.2713987261E-01],
	[3.0810000000E+04, 2.1747866884E+01, 4.9785857325E+00, 7.2669602949E+00, 2.6011124283E+00, 9.2717524795E-01],
	[3.0815000000E+04, 2.1753731758E+01, 4.9785816131E+00, 7.2708050574E+00, 2.6016876305E+00, 9.2721060533E-01],
	[3.0820000000E+04, 2.1759597262E+01, 4.9785774944E+00, 7.2746512291E+00, 2.6022627106E+00, 9.2724594477E-01],
	[3.0825000000E+04, 2.1765463396E+01, 4.9785733764E+00, 7.2784988101E+00, 2.6028376685E+00, 9.2728126627E-01],
	[3.0830000000E+04, 2.1771330159E+01, 4.9785692590E+00, 7.2823478009E+00, 2.6034125042E+00, 9.2731656984E-01],
	[3.0835000000E+04, 2.1777197552E+01, 4.9785651424E+00, 7.2861982016E+00, 2.6039872176E+00, 9.2735185550E-01],
	[3.0840000000E+04, 2.1783065574E+01, 4.9785610263E+00, 7.2900500127E+00, 2.6045618089E+00, 9.2738712324E-01],
	[3.0845000000E+04, 2.1788934226E+01, 4.9785569110E+00, 7.2939032342E+00, 2.6051362779E+00, 9.2742237307E-01],
	[3.0850000000E+04, 2.1794803507E+01, 4.9785527963E+00, 7.2977578666E+00, 2.6057106246E+00, 9.2745760501E-01],
	[3.0855000000E+04, 2.1800673418E+01, 4.9785486823E+00, 7.3016139102E+00, 2.6062848490E+00, 9.2749281907E-01],
	[3.0860000000E+04, 2.1806543958E+01, 4.9785445690E+00, 7.3054713652E+00, 2.6068589511E+00, 9.2752801525E-01],
	[3.0865000000E+04, 2.1812415127E+01, 4.9785404563E+00, 7.3093302319E+00, 2.6074329309E+00, 9.2756319355E-01],
	[3.0870000000E+04, 2.1818286926E+01, 4.9785363443E+00, 7.3131905105E+00, 2.6080067883E+00, 9.2759835400E-01],
	[3.0875000000E+04, 2.1824159354E+01, 4.9785322330E+00, 7.3170522015E+00, 2.6085805233E+00, 9.2763349659E-01],
	[3.0880000000E+04, 2.1830039018E+01, 4.9785290559E+00, 7.3209153050E+00, 2.6091544868E+00, 9.2766862134E-01],
	[3.0885000000E+04, 2.1835933345E+01, 4.9785278618E+00, 7.3247798214E+00, 2.6097290733E+00, 9.2770372825E-01],
	[3.0890000000E+04, 2.1841828309E+01, 4.9785266680E+00, 7.3286457509E+00, 2.6103035380E+00, 9.2773881734E-01],
	[3.0895000000E+04, 2.1847723911E+01, 4.9785254743E+00, 7.3325130939E+00, 2.6108778808E+00, 9.2777388860E-01],
	[3.0900000000E+04, 2.1853620149E+01, 4.9785242809E+00, 7.3363818506E+00, 2.6114521019E+00, 9.2780894206E-01],
	[3.0905000000E+04, 2.1859517024E+01, 4.9785230876E+00, 7.3402520213E+00, 2.6120262011E+00, 9.2784397771E-01],
	[3.0910000000E+04, 2.1865414536E+01, 4.9785218945E+00, 7.3441236063E+00, 2.6126001784E+00, 9.2787899557E-01],
	[3.0915000000E+04, 2.1871312684E+01, 4.9785207016E+00, 7.3479966058E+00, 2.6131740339E+00, 9.2791399564E-01],
	[3.0920000000E+04, 2.1877211470E+01, 4.9785195089E+00, 7.3518710203E+00, 2.6137477674E+00, 9.2794897794E-01],
	[3.0925000000E+04, 2.1883110892E+01, 4.9785183164E+00, 7.3557468499E+00, 2.6143213791E+00, 9.2798394247E-01],
	[3.0930000000E+04, 2.1889010951E+01, 4.9785171241E+00, 7.3596240949E+00, 2.6148948688E+00, 9.2801888924E-01],
	[3.0935000000E+04, 2.1894911647E+01, 4.9785159320E+00, 7.3635027557E+00, 2.6154682366E+00, 9.2805381825E-01],
	[3.0940000000E+04, 2.1900812979E+01, 4.9785147401E+00, 7.3673828325E+00, 2.6160414824E+00, 9.2808872952E-01],
	[3.0945000000E+04, 2.1906714948E+01, 4.9785135484E+00, 7.3712643256E+00, 2.6166146062E+00, 9.2812362306E-01],
	[3.0950000000E+04, 2.1912617553E+01, 4.9785123568E+00, 7.3751472353E+00, 2.6171876080E+00, 9.2815849887E-01],
	[3.0955000000E+04, 2.1918520795E+01, 4.9785111655E+00, 7.3790315619E+00, 2.6177604878E+00, 9.2819335697E-01],
	[3.0960000000E+04, 2.1924424674E+01, 4.9785099744E+00, 7.3829173057E+00, 2.6183332455E+00, 9.2822819735E-01],
	[3.0965000000E+04, 2.1930329189E+01, 4.9785087834E+00, 7.3868044669E+00, 2.6189058812E+00, 9.2826302003E-01],
	[3.0970000000E+04, 2.1936234340E+01, 4.9785075926E+00, 7.3906930459E+00, 2.6194783949E+00, 9.2829782502E-01],
	[3.0975000000E+04, 2.1942140128E+01, 4.9785064021E+00, 7.3945830429E+00, 2.6200507864E+00, 9.2833261233E-01],
	[3.0980000000E+04, 2.1948046552E+01, 4.9785052117E+00, 7.3984744582E+00, 2.6206230558E+00, 9.2836738196E-01],
	[3.0985000000E+04, 2.1953953612E+01, 4.9785040215E+00, 7.4023672921E+00, 2.6211952031E+00, 9.2840213392E-01],
	[3.0990000000E+04, 2.1959861309E+01, 4.9785028315E+00, 7.4062615449E+00, 2.6217672283E+00, 9.2843686823E-01],
	[3.0995000000E+04, 2.1965769642E+01, 4.9785016417E+00, 7.4101572169E+00, 2.6223391313E+00, 9.2847158488E-01],
	[3.1000000000E+04, 2.1971678611E+01, 4.9785004521E+00, 7.4140543084E+00, 2.6229109121E+00, 9.2850628389E-01],
	[3.1005000000E+04, 2.1977588217E+01, 4.9784992627E+00, 7.4179528197E+00, 2.6234825708E+00, 9.2854096527E-01],
	[3.1010000000E+04, 2.1983498458E+01, 4.9784980735E+00, 7.4218527510E+00, 2.6240541072E+00, 9.2857562903E-01],
	[3.1015000000E+04, 2.1989409336E+01, 4.9784968844E+00, 7.4257541026E+00, 2.6246255214E+00, 9.2861027516E-01],
	[3.1020000000E+04, 2.1995320850E+01, 4.9784956956E+00, 7.4296568748E+00, 2.6251968134E+00, 9.2864490369E-01],
	[3.1025000000E+04, 2.2001233000E+01, 4.9784945069E+00, 7.4335610680E+00, 2.6257679831E+00, 9.2867951462E-01],
	[3.1030000000E+04, 2.2007145785E+01, 4.9784933185E+00, 7.4374666824E+00, 2.6263390306E+00, 9.2871410796E-01],
	[3.1035000000E+04, 2.2013059207E+01, 4.9784921302E+00, 7.4413737182E+00, 2.6269099557E+00, 9.2874868371E-01],
	[3.1040000000E+04, 2.2018973265E+01, 4.9784909421E+00, 7.4452821758E+00, 2.6274807585E+00, 9.2878324189E-01],
	[3.1045000000E+04, 2.2024887959E+01, 4.9784897543E+00, 7.4491920555E+00, 2.6280514391E+00, 9.2881778251E-01],
	[3.1050000000E+04, 2.2030803289E+01, 4.9784885666E+00, 7.4531033576E+00, 2.6286219972E+00, 9.2885230557E-01],
	[3.1055000000E+04, 2.2036719254E+01, 4.9784873791E+00, 7.4570160822E+00, 2.6291924330E+00, 9.2888681108E-01],
	[3.1060000000E+04, 2.2042635855E+01, 4.9784861918E+00, 7.4609302298E+00, 2.6297627465E+00, 9.2892129904E-01],
	[3.1065000000E+04, 2.2048553092E+01, 4.9784850046E+00, 7.4648458006E+00, 2.6303329375E+00, 9.2895576948E-01],
	[3.1070000000E+04, 2.2054470965E+01, 4.9784838177E+00, 7.4687627949E+00, 2.6309030062E+00, 9.2899022239E-01],
	[3.1075000000E+04, 2.2060389474E+01, 4.9784826310E+00, 7.4726812131E+00, 2.6314729524E+00, 9.2902465779E-01],
	[3.1080000000E+04, 2.2066308618E+01, 4.9784814444E+00, 7.4766010552E+00, 2.6320427762E+00, 9.2905907568E-01],
	[3.1085000000E+04, 2.2072228398E+01, 4.9784802581E+00, 7.4805223218E+00, 2.6326124775E+00, 9.2909347608E-01],
	[3.1090000000E+04, 2.2078148813E+01, 4.9784790719E+00, 7.4844450130E+00, 2.6331820564E+00, 9.2912785898E-01],
	[3.1095000000E+04, 2.2084069864E+01, 4.9784778860E+00, 7.4883691291E+00, 2.6337515128E+00, 9.2916222440E-01],
	[3.1100000000E+04, 2.2089991551E+01, 4.9784767002E+00, 7.4922946705E+00, 2.6343208466E+00, 9.2919657235E-01],
	[3.1105000000E+04, 2.2095913873E+01, 4.9784755146E+00, 7.4962216374E+00, 2.6348900580E+00, 9.2923090284E-01],
	[3.1110000000E+04, 2.2101836831E+01, 4.9784743292E+00, 7.5001500301E+00, 2.6354591468E+00, 9.2926521586E-01],
	[3.1115000000E+04, 2.2107760424E+01, 4.9784731440E+00, 7.5040798489E+00, 2.6360281131E+00, 9.2929951145E-01],
	[3.1120000000E+04, 2.2113684652E+01, 4.9784719590E+00, 7.5080110940E+00, 2.6365969568E+00, 9.2933378959E-01],
	[3.1125000000E+04, 2.2119609516E+01, 4.9784707742E+00, 7.5119437659E+00, 2.6371656779E+00, 9.2936805030E-01],
	[3.1130000000E+04, 2.2125535015E+01, 4.9784695895E+00, 7.5158778647E+00, 2.6377342764E+00, 9.2940229359E-01],
	[3.1135000000E+04, 2.2131461150E+01, 4.9784684051E+00, 7.5198133907E+00, 2.6383027524E+00, 9.2943651947E-01],
	[3.1140000000E+04, 2.2137387920E+01, 4.9784672208E+00, 7.5237503443E+00, 2.6388711057E+00, 9.2947072794E-01],
	[3.1145000000E+04, 2.2143315325E+01, 4.9784660368E+00, 7.5276887257E+00, 2.6394393363E+00, 9.2950491902E-01],
	[3.1150000000E+04, 2.2149243365E+01, 4.9784648529E+00, 7.5316285352E+00, 2.6400074443E+00, 9.2953909270E-01],
	[3.1155000000E+04, 2.2155172040E+01, 4.9784636692E+00, 7.5355697731E+00, 2.6405754296E+00, 9.2957324901E-01],
	[3.1160000000E+04, 2.2161101351E+01, 4.9784624857E+00, 7.5395124396E+00, 2.6411432922E+00, 9.2960738794E-01],
	[3.1165000000E+04, 2.2167031296E+01, 4.9784613024E+00, 7.5434565352E+00, 2.6417110322E+00, 9.2964150952E-01],
	[3.1170000000E+04, 2.2172961877E+01, 4.9784601193E+00, 7.5474020600E+00, 2.6422786494E+00, 9.2967561374E-01],
	[3.1175000000E+04, 2.2178893093E+01, 4.9784589364E+00, 7.5513490144E+00, 2.6428461438E+00, 9.2970970061E-01],
	[3.1180000000E+04, 2.2184824944E+01, 4.9784577537E+00, 7.5552973986E+00, 2.6434135155E+00, 9.2974377015E-01],
	[3.1185000000E+04, 2.2190757429E+01, 4.9784565711E+00, 7.5592472129E+00, 2.6439807645E+00, 9.2977782235E-01],
	[3.1190000000E+04, 2.2196690550E+01, 4.9784553888E+00, 7.5631984577E+00, 2.6445478907E+00, 9.2981185724E-01],
	[3.1195000000E+04, 2.2202624305E+01, 4.9784542066E+00, 7.5671511331E+00, 2.6451148941E+00, 9.2984587481E-01],
	[3.1200000000E+04, 2.2208558696E+01, 4.9784530246E+00, 7.5711052396E+00, 2.6456817746E+00, 9.2987987508E-01],
	[3.1205000000E+04, 2.2214493721E+01, 4.9784518429E+00, 7.5750607773E+00, 2.6462485324E+00, 9.2991385806E-01],
	[3.1210000000E+04, 2.2220429381E+01, 4.9784506613E+00, 7.5790177466E+00, 2.6468151673E+00, 9.2994782375E-01],
	[3.1215000000E+04, 2.2226365676E+01, 4.9784494799E+00, 7.5829761477E+00, 2.6473816793E+00, 9.2998177216E-01],
	[3.1220000000E+04, 2.2232302605E+01, 4.9784482987E+00, 7.5869359810E+00, 2.6479480685E+00, 9.3001570330E-01],
	[3.1225000000E+04, 2.2238240170E+01, 4.9784471176E+00, 7.5908972467E+00, 2.6485143348E+00, 9.3004961718E-01],
	[3.1230000000E+04, 2.2244178369E+01, 4.9784459368E+00, 7.5948599452E+00, 2.6490804782E+00, 9.3008351381E-01],
	[3.1235000000E+04, 2.2250117202E+01, 4.9784447562E+00, 7.5988240766E+00, 2.6496464987E+00, 9.3011739319E-01],
	[3.1240000000E+04, 2.2256056670E+01, 4.9784435757E+00, 7.6027896413E+00, 2.6502123963E+00, 9.3015125534E-01],
	[3.1245000000E+04, 2.2261996773E+01, 4.9784423954E+00, 7.6067566397E+00, 2.6507781709E+00, 9.3018510026E-01],
	[3.1250000000E+04, 2.2267937510E+01, 4.9784412154E+00, 7.6107250719E+00, 2.6513438226E+00, 9.3021892796E-01],
	[3.1255000000E+04, 2.2273878882E+01, 4.9784400355E+00, 7.6146949382E+00, 2.6519093513E+00, 9.3025273846E-01],
	[3.1260000000E+04, 2.2279820888E+01, 4.9784388558E+00, 7.6186662390E+00, 2.6524747570E+00, 9.3028653175E-01],
	[3.1265000000E+04, 2.2285763529E+01, 4.9784376763E+00, 7.6226389746E+00, 2.6530400397E+00, 9.3032030784E-01],
	[3.1270000000E+04, 2.2291706804E+01, 4.9784364969E+00, 7.6266131452E+00, 2.6536051994E+00, 9.3035406675E-01],
	[3.1275000000E+04, 2.2297650713E+01, 4.9784353178E+00, 7.6305887511E+00, 2.6541702361E+00, 9.3038780849E-01],
	[3.1280000000E+04, 2.2303595257E+01, 4.9784341389E+00, 7.6345657926E+00, 2.6547351497E+00, 9.3042153305E-01],
	[3.1285000000E+04, 2.2309540435E+01, 4.9784329601E+00, 7.6385442699E+00, 2.6552999403E+00, 9.3045524046E-01],
	[3.1290000000E+04, 2.2315486247E+01, 4.9784317815E+00, 7.6425241835E+00, 2.6558646078E+00, 9.3048893072E-01],
	[3.1295000000E+04, 2.2321432694E+01, 4.9784306032E+00, 7.6465055335E+00, 2.6564291523E+00, 9.3052260383E-01],
	[3.1300000000E+04, 2.2327379774E+01, 4.9784294250E+00, 7.6504883203E+00, 2.6569935736E+00, 9.3055625981E-01],
	[3.1305000000E+04, 2.2333327489E+01, 4.9784282470E+00, 7.6544725442E+00, 2.6575578718E+00, 9.3058989866E-01],
	[3.1310000000E+04, 2.2339275838E+01, 4.9784270692E+00, 7.6584582053E+00, 2.6581220469E+00, 9.3062352040E-01],
	[3.1315000000E+04, 2.2345224821E+01, 4.9784258915E+00, 7.6624453041E+00, 2.6586860989E+00, 9.3065712503E-01],
	[3.1320000000E+04, 2.2351174438E+01, 4.9784247141E+00, 7.6664338408E+00, 2.6592500277E+00, 9.3069071256E-01],
	[3.1325000000E+04, 2.2357124690E+01, 4.9784235368E+00, 7.6704238157E+00, 2.6598138334E+00, 9.3072428299E-01],
	[3.1330000000E+04, 2.2363075575E+01, 4.9784223598E+00, 7.6744152291E+00, 2.6603775159E+00, 9.3075783634E-01],
	[3.1335000000E+04, 2.2369027094E+01, 4.9784211829E+00, 7.6784080813E+00, 2.6609410751E+00, 9.3079137262E-01],
	[3.1340000000E+04, 2.2374979247E+01, 4.9784200062E+00, 7.6824023725E+00, 2.6615045112E+00, 9.3082489183E-01],
	[3.1345000000E+04, 2.2380932034E+01, 4.9784188297E+00, 7.6863981031E+00, 2.6620678241E+00, 9.3085839399E-01],
	[3.1350000000E+04, 2.2386885454E+01, 4.9784176534E+00, 7.6903952733E+00, 2.6626310137E+00, 9.3089187909E-01],
	[3.1355000000E+04, 2.2392839509E+01, 4.9784164773E+00, 7.6943938835E+00, 2.6631940801E+00, 9.3092534715E-01],
	[3.1360000000E+04, 2.2398794197E+01, 4.9784153014E+00, 7.6983939338E+00, 2.6637570232E+00, 9.3095879818E-01],
	[3.1365000000E+04, 2.2404749519E+01, 4.9784141256E+00, 7.7023954247E+00, 2.6643198430E+00, 9.3099223219E-01],
	[3.1370000000E+04, 2.2410705475E+01, 4.9784129501E+00, 7.7063983564E+00, 2.6648825396E+00, 9.3102564918E-01],
	[3.1375000000E+04, 2.2416662065E+01, 4.9784117747E+00, 7.7104027291E+00, 2.6654451129E+00, 9.3105904916E-01],
	[3.1380000000E+04, 2.2422637670E+01, 4.9784131708E+00, 7.7144085433E+00, 2.6660085600E+00, 9.3109243215E-01],
	[3.1385000000E+04, 2.2428615955E+01, 4.9784148520E+00, 7.7184157991E+00, 2.6665719951E+00, 9.3112579814E-01],
	[3.1390000000E+04, 2.2434594883E+01, 4.9784165329E+00, 7.7224244968E+00, 2.6671353075E+00, 9.3115914716E-01],
	[3.1395000000E+04, 2.2440574451E+01, 4.9784182136E+00, 7.7264346368E+00, 2.6676984972E+00, 9.3119247919E-01],
	[3.1400000000E+04, 2.2446554660E+01, 4.9784198940E+00, 7.7304462193E+00, 2.6682615640E+00, 9.3122579427E-01],
	[3.1405000000E+04, 2.2452535511E+01, 4.9784215741E+00, 7.7344592446E+00, 2.6688245081E+00, 9.3125909239E-01],
	[3.1410000000E+04, 2.2458517002E+01, 4.9784232540E+00, 7.7384737131E+00, 2.6693873295E+00, 9.3129237356E-01],
	[3.1415000000E+04, 2.2464499135E+01, 4.9784249336E+00, 7.7424896249E+00, 2.6699500280E+00, 9.3132563779E-01],
	[3.1420000000E+04, 2.2470481909E+01, 4.9784266129E+00, 7.7465069804E+00, 2.6705126037E+00, 9.3135888509E-01],
	[3.1425000000E+04, 2.2476465323E+01, 4.9784282920E+00, 7.7505257799E+00, 2.6710750566E+00, 9.3139211547E-01],
	[3.1430000000E+04, 2.2482449379E+01, 4.9784299708E+00, 7.7545460236E+00, 2.6716373866E+00, 9.3142532893E-01],
	[3.1435000000E+04, 2.2488434075E+01, 4.9784316494E+00, 7.7585677119E+00, 2.6721995939E+00, 9.3145852549E-01],
	[3.1440000000E+04, 2.2494419413E+01, 4.9784333276E+00, 7.7625908450E+00, 2.6727616782E+00, 9.3149170515E-01],
	[3.1445000000E+04, 2.2500405391E+01, 4.9784350056E+00, 7.7666154233E+00, 2.6733236397E+00, 9.3152486792E-01],
	[3.1450000000E+04, 2.2506392010E+01, 4.9784366834E+00, 7.7706414469E+00, 2.6738854782E+00, 9.3155801382E-01],
	[3.1455000000E+04, 2.2512379270E+01, 4.9784383608E+00, 7.7746689163E+00, 2.6744471939E+00, 9.3159114284E-01],
	[3.1460000000E+04, 2.2518367170E+01, 4.9784400381E+00, 7.7786978316E+00, 2.6750087867E+00, 9.3162425499E-01],
	[3.1465000000E+04, 2.2524355711E+01, 4.9784417150E+00, 7.7827281933E+00, 2.6755702565E+00, 9.3165735030E-01],
	[3.1470000000E+04, 2.2530344893E+01, 4.9784433917E+00, 7.7867600015E+00, 2.6761316035E+00, 9.3169042875E-01],
	[3.1475000000E+04, 2.2536334716E+01, 4.9784450681E+00, 7.7907932566E+00, 2.6766928274E+00, 9.3172349037E-01],
	[3.1480000000E+04, 2.2542325179E+01, 4.9784467442E+00, 7.7948279588E+00, 2.6772539284E+00, 9.3175653516E-01],
	[3.1485000000E+04, 2.2548316283E+01, 4.9784484201E+00, 7.7988641084E+00, 2.6778149064E+00, 9.3178956313E-01],
	[3.1490000000E+04, 2.2554308027E+01, 4.9784500957E+00, 7.8029017058E+00, 2.6783757615E+00, 9.3182257428E-01],
	[3.1495000000E+04, 2.2560300411E+01, 4.9784517711E+00, 7.8069407512E+00, 2.6789364935E+00, 9.3185556864E-01],
	[3.1500000000E+04, 2.2566293437E+01, 4.9784534462E+00, 7.8109812449E+00, 2.6794971026E+00, 9.3188854619E-01],
	[3.1505000000E+04, 2.2572287102E+01, 4.9784551210E+00, 7.8150231872E+00, 2.6800575886E+00, 9.3192150696E-01],
	[3.1510000000E+04, 2.2578281408E+01, 4.9784567955E+00, 7.8190665783E+00, 2.6806179515E+00, 9.3195445095E-01],
	[3.1515000000E+04, 2.2584276355E+01, 4.9784584698E+00, 7.8231114187E+00, 2.6811781915E+00, 9.3198737817E-01],
	[3.1520000000E+04, 2.2590271941E+01, 4.9784601438E+00, 7.8271577085E+00, 2.6817383083E+00, 9.3202028863E-01],
	[3.1525000000E+04, 2.2596268169E+01, 4.9784618176E+00, 7.8312054480E+00, 2.6822983021E+00, 9.3205318233E-01],
	[3.1530000000E+04, 2.2602265036E+01, 4.9784634911E+00, 7.8352546376E+00, 2.6828581728E+00, 9.3208605929E-01],
	[3.1535000000E+04, 2.2608262543E+01, 4.9784651643E+00, 7.8393052775E+00, 2.6834179205E+00, 9.3211891952E-01],
	[3.1540000000E+04, 2.2614260691E+01, 4.9784668373E+00, 7.8433573680E+00, 2.6839775450E+00, 9.3215176301E-01],
	[3.1545000000E+04, 2.2620259479E+01, 4.9784685100E+00, 7.8474109094E+00, 2.6845370464E+00, 9.3218458979E-01],
	[3.1550000000E+04, 2.2626258907E+01, 4.9784701824E+00, 7.8514659020E+00, 2.6850964246E+00, 9.3221739985E-01],
	[3.1555000000E+04, 2.2632258975E+01, 4.9784718546E+00, 7.8555223461E+00, 2.6856556798E+00, 9.3225019322E-01],
	[3.1560000000E+04, 2.2638259684E+01, 4.9784735265E+00, 7.8595802420E+00, 2.6862148117E+00, 9.3228296988E-01],
	[3.1565000000E+04, 2.2644261032E+01, 4.9784751981E+00, 7.8636395899E+00, 2.6867738205E+00, 9.3231572987E-01],
	[3.1570000000E+04, 2.2650263020E+01, 4.9784768695E+00, 7.8677003902E+00, 2.6873327062E+00, 9.3234847317E-01],
	[3.1575000000E+04, 2.2656265649E+01, 4.9784785406E+00, 7.8717626431E+00, 2.6878914686E+00, 9.3238119981E-01],
	[3.1580000000E+04, 2.2662268917E+01, 4.9784802114E+00, 7.8758263490E+00, 2.6884501079E+00, 9.3241390978E-01],
	[3.1585000000E+04, 2.2668272825E+01, 4.9784818820E+00, 7.8798915080E+00, 2.6890086239E+00, 9.3244660311E-01],
	[3.1590000000E+04, 2.2674277373E+01, 4.9784835524E+00, 7.8839581206E+00, 2.6895670167E+00, 9.3247927979E-01],
	[3.1595000000E+04, 2.2680282561E+01, 4.9784852224E+00, 7.8880261869E+00, 2.6901252863E+00, 9.3251193983E-01],
	[3.1600000000E+04, 2.2686288388E+01, 4.9784868922E+00, 7.8920957073E+00, 2.6906834327E+00, 9.3254458325E-01],
	[3.1605000000E+04, 2.2692294856E+01, 4.9784885617E+00, 7.8961666822E+00, 2.6912414557E+00, 9.3257721005E-01],
	[3.1610000000E+04, 2.2698301963E+01, 4.9784902310E+00, 7.9002391116E+00, 2.6917993556E+00, 9.3260982025E-01],
	[3.1615000000E+04, 2.2704309710E+01, 4.9784919000E+00, 7.9043129960E+00, 2.6923571321E+00, 9.3264241384E-01],
	[3.1620000000E+04, 2.2710318096E+01, 4.9784935687E+00, 7.9083883357E+00, 2.6929147854E+00, 9.3267499083E-01],
	[3.1625000000E+04, 2.2716327123E+01, 4.9784952372E+00, 7.9124651309E+00, 2.6934723153E+00, 9.3270755125E-01],
	[3.1630000000E+04, 2.2722336788E+01, 4.9784969054E+00, 7.9165433819E+00, 2.6940297220E+00, 9.3274009508E-01],
	[3.1635000000E+04, 2.2728347094E+01, 4.9784985734E+00, 7.9206230890E+00, 2.6945870053E+00, 9.3277262235E-01],
	[3.1640000000E+04, 2.2734358039E+01, 4.9785002411E+00, 7.9247042525E+00, 2.6951441653E+00, 9.3280513306E-01],
	[3.1645000000E+04, 2.2740369623E+01, 4.9785019085E+00, 7.9287868727E+00, 2.6957012020E+00, 9.3283762722E-01],
	[3.1650000000E+04, 2.2746381847E+01, 4.9785035756E+00, 7.9328709499E+00, 2.6962581153E+00, 9.3287010484E-01],
	[3.1655000000E+04, 2.2752394710E+01, 4.9785052425E+00, 7.9369564843E+00, 2.6968149052E+00, 9.3290256592E-01],
	[3.1660000000E+04, 2.2758408213E+01, 4.9785069092E+00, 7.9410434763E+00, 2.6973715718E+00, 9.3293501048E-01],
	[3.1665000000E+04, 2.2764422355E+01, 4.9785085755E+00, 7.9451319261E+00, 2.6979281150E+00, 9.3296743852E-01],
	[3.1670000000E+04, 2.2770437137E+01, 4.9785102416E+00, 7.9492218341E+00, 2.6984845348E+00, 9.3299985006E-01],
	[3.1675000000E+04, 2.2776452558E+01, 4.9785119075E+00, 7.9533132005E+00, 2.6990408311E+00, 9.3303224509E-01],
	[3.1680000000E+04, 2.2782468618E+01, 4.9785135731E+00, 7.9574060256E+00, 2.6995970041E+00, 9.3306462363E-01],
	[3.1685000000E+04, 2.2788485317E+01, 4.9785152384E+00, 7.9615003096E+00, 2.7001530537E+00, 9.3309698569E-01],
	[3.1690000000E+04, 2.2794502656E+01, 4.9785169035E+00, 7.9655960530E+00, 2.7007089798E+00, 9.3312933127E-01],
	[3.1695000000E+04, 2.2800520633E+01, 4.9785185683E+00, 7.9696932560E+00, 2.7012647824E+00, 9.3316166039E-01],
	[3.1700000000E+04, 2.2806539250E+01, 4.9785202328E+00, 7.9737919188E+00, 2.7018204616E+00, 9.3319397305E-01],
	[3.1705000000E+04, 2.2812558506E+01, 4.9785218971E+00, 7.9778920418E+00, 2.7023760174E+00, 9.3322626926E-01],
	[3.1710000000E+04, 2.2818578401E+01, 4.9785235611E+00, 7.9819936252E+00, 2.7029314496E+00, 9.3325854903E-01],
	[3.1715000000E+04, 2.2824598935E+01, 4.9785252248E+00, 7.9860966694E+00, 2.7034867584E+00, 9.3329081236E-01],
	[3.1720000000E+04, 2.2830620109E+01, 4.9785268883E+00, 7.9902011746E+00, 2.7040419437E+00, 9.3332305928E-01],
	[3.1725000000E+04, 2.2836641921E+01, 4.9785285515E+00, 7.9943071411E+00, 2.7045970054E+00, 9.3335528977E-01],
	[3.1730000000E+04, 2.2842664372E+01, 4.9785302145E+00, 7.9984145692E+00, 2.7051519437E+00, 9.3338750386E-01],
	[3.1735000000E+04, 2.2848687462E+01, 4.9785318772E+00, 8.0025234592E+00, 2.7057067584E+00, 9.3341970155E-01],
	[3.1740000000E+04, 2.2854711191E+01, 4.9785335397E+00, 8.0066338114E+00, 2.7062614496E+00, 9.3345188285E-01],
	[3.1745000000E+04, 2.2860735558E+01, 4.9785352018E+00, 8.0107456260E+00, 2.7068160172E+00, 9.3348404777E-01],
	[3.1750000000E+04, 2.2866760565E+01, 4.9785368638E+00, 8.0148589035E+00, 2.7073704613E+00, 9.3351619631E-01],
	[3.1755000000E+04, 2.2872786210E+01, 4.9785385254E+00, 8.0189736439E+00, 2.7079247818E+00, 9.3354832849E-01],
	[3.1760000000E+04, 2.2878812494E+01, 4.9785401868E+00, 8.0230898477E+00, 2.7084789787E+00, 9.3358044431E-01],
	[3.1765000000E+04, 2.2884839417E+01, 4.9785418480E+00, 8.0272075152E+00, 2.7090330521E+00, 9.3361254379E-01],
	[3.1770000000E+04, 2.2890866979E+01, 4.9785435088E+00, 8.0313266465E+00, 2.7095870018E+00, 9.3364462692E-01],
	[3.1775000000E+04, 2.2896895179E+01, 4.9785451694E+00, 8.0354472421E+00, 2.7101408280E+00, 9.3367669372E-01],
	[3.1780000000E+04, 2.2902924018E+01, 4.9785468298E+00, 8.0395693022E+00, 2.7106945305E+00, 9.3370874420E-01],
	[3.1785000000E+04, 2.2908953495E+01, 4.9785484899E+00, 8.0436928270E+00, 2.7112481094E+00, 9.3374077837E-01],
	[3.1790000000E+04, 2.2914983611E+01, 4.9785501497E+00, 8.0478178170E+00, 2.7118015647E+00, 9.3377279622E-01],
	[3.1795000000E+04, 2.2921014365E+01, 4.9785518093E+00, 8.0519442723E+00, 2.7123548963E+00, 9.3380479778E-01],
	[3.1800000000E+04, 2.2927045758E+01, 4.9785534686E+00, 8.0560721932E+00, 2.7129081043E+00, 9.3383678305E-01],
	[3.1805000000E+04, 2.2933077790E+01, 4.9785551277E+00, 8.0602015801E+00, 2.7134611886E+00, 9.3386875204E-01],
	[3.1810000000E+04, 2.2939110459E+01, 4.9785567864E+00, 8.0643324333E+00, 2.7140141493E+00, 9.3390070476E-01],
	[3.1815000000E+04, 2.2945143768E+01, 4.9785584450E+00, 8.0684647529E+00, 2.7145669862E+00, 9.3393264121E-01],
	[3.1820000000E+04, 2.2951177714E+01, 4.9785601033E+00, 8.0725985394E+00, 2.7151196995E+00, 9.3396456141E-01],
	[3.1825000000E+04, 2.2957212299E+01, 4.9785617613E+00, 8.0767337930E+00, 2.7156722891E+00, 9.3399646536E-01],
	[3.1830000000E+04, 2.2963247522E+01, 4.9785634190E+00, 8.0808705140E+00, 2.7162247549E+00, 9.3402835307E-01],
	[3.1835000000E+04, 2.2969283384E+01, 4.9785650765E+00, 8.0850087027E+00, 2.7167770971E+00, 9.3406022454E-01],
	[3.1840000000E+04, 2.2975319883E+01, 4.9785667337E+00, 8.0891483593E+00, 2.7173293155E+00, 9.3409207980E-01],
	[3.1845000000E+04, 2.2981357021E+01, 4.9785683907E+00, 8.0932894842E+00, 2.7178814102E+00, 9.3412391884E-01],
	[3.1850000000E+04, 2.2987394797E+01, 4.9785700474E+00, 8.0974320777E+00, 2.7184333812E+00, 9.3415574168E-01],
	[3.1855000000E+04, 2.2993433212E+01, 4.9785717039E+00, 8.1015761400E+00, 2.7189852284E+00, 9.3418754832E-01],
	[3.1860000000E+04, 2.2999472264E+01, 4.9785733601E+00, 8.1057216714E+00, 2.7195369518E+00, 9.3421933877E-01],
	[3.1865000000E+04, 2.3005511954E+01, 4.9785750160E+00, 8.1098686723E+00, 2.7200885515E+00, 9.3425111304E-01],
	[3.1870000000E+04, 2.3011552282E+01, 4.9785766717E+00, 8.1140171428E+00, 2.7206400274E+00, 9.3428287114E-01],
	[3.1875000000E+04, 2.3017593249E+01, 4.9785783271E+00, 8.1181670834E+00, 2.7211913795E+00, 9.3431461308E-01],
	[3.1880000000E+04, 2.3023634853E+01, 4.9785799822E+00, 8.1223184943E+00, 2.7217426078E+00, 9.3434633886E-01],
	[3.1885000000E+04, 2.3029694862E+01, 4.9785840985E+00, 8.1264713757E+00, 2.7222946965E+00, 9.3437804849E-01],
	[3.1890000000E+04, 2.3035757950E+01, 4.9785885511E+00, 8.1306257280E+00, 2.7228467967E+00, 9.3440974198E-01],
	[3.1895000000E+04, 2.3041821683E+01, 4.9785930031E+00, 8.1347815515E+00, 2.7233987737E+00, 9.3444141935E-01],
	[3.1900000000E+04, 2.3047886062E+01, 4.9785974545E+00, 8.1389388464E+00, 2.7239506275E+00, 9.3447308059E-01],
	[3.1905000000E+04, 2.3053951085E+01, 4.9786019051E+00, 8.1430976131E+00, 2.7245023579E+00, 9.3450472572E-01],
	[3.1910000000E+04, 2.3060016754E+01, 4.9786063550E+00, 8.1472578518E+00, 2.7250539652E+00, 9.3453635475E-01],
	[3.1915000000E+04, 2.3066083069E+01, 4.9786108042E+00, 8.1514195628E+00, 2.7256054491E+00, 9.3456796768E-01],
	[3.1920000000E+04, 2.3072150028E+01, 4.9786152527E+00, 8.1555827464E+00, 2.7261568098E+00, 9.3459956452E-01],
	[3.1925000000E+04, 2.3078217632E+01, 4.9786197006E+00, 8.1597474030E+00, 2.7267080471E+00, 9.3463114528E-01],
	[3.1930000000E+04, 2.3084285882E+01, 4.9786241477E+00, 8.1639135327E+00, 2.7272591612E+00, 9.3466270997E-01],
	[3.1935000000E+04, 2.3090354776E+01, 4.9786285942E+00, 8.1680811359E+00, 2.7278101520E+00, 9.3469425859E-01],
	[3.1940000000E+04, 2.3096424316E+01, 4.9786330399E+00, 8.1722502129E+00, 2.7283610194E+00, 9.3472579116E-01],
	[3.1945000000E+04, 2.3102494500E+01, 4.9786374850E+00, 8.1764207639E+00, 2.7289117636E+00, 9.3475730767E-01],
	[3.1950000000E+04, 2.3108565330E+01, 4.9786419294E+00, 8.1805927893E+00, 2.7294623844E+00, 9.3478880815E-01],
	[3.1955000000E+04, 2.3114636804E+01, 4.9786463731E+00, 8.1847662893E+00, 2.7300128818E+00, 9.3482029258E-01],
	[3.1960000000E+04, 2.3120708924E+01, 4.9786508161E+00, 8.1889412642E+00, 2.7305632559E+00, 9.3485176099E-01],
	[3.1965000000E+04, 2.3126781688E+01, 4.9786552584E+00, 8.1931177144E+00, 2.7311135067E+00, 9.3488321337E-01],
	[3.1970000000E+04, 2.3132855097E+01, 4.9786597000E+00, 8.1972956401E+00, 2.7316636341E+00, 9.3491464974E-01],
	[3.1975000000E+04, 2.3138929151E+01, 4.9786641409E+00, 8.2014750415E+00, 2.7322136381E+00, 9.3494607011E-01],
	[3.1980000000E+04, 2.3145003849E+01, 4.9786685812E+00, 8.2056559191E+00, 2.7327635187E+00, 9.3497747447E-01],
	[3.1985000000E+04, 2.3151079193E+01, 4.9786730207E+00, 8.2098382730E+00, 2.7333132760E+00, 9.3500886284E-01],
	[3.1990000000E+04, 2.3157155181E+01, 4.9786774596E+00, 8.2140221037E+00, 2.7338629098E+00, 9.3504023522E-01],
	[3.1995000000E+04, 2.3163231814E+01, 4.9786818977E+00, 8.2182074112E+00, 2.7344124203E+00, 9.3507159163E-01],
	[3.2000000000E+04, 2.3169309091E+01, 4.9786863352E+00, 8.2223941961E+00, 2.7349618073E+00, 9.3510293207E-01],
	[3.2005000000E+04, 2.3175387013E+01, 4.9786907720E+00, 8.2265824584E+00, 2.7355110710E+00, 9.3513425654E-01],
	[3.2010000000E+04, 2.3181465579E+01, 4.9786952081E+00, 8.2307721986E+00, 2.7360602112E+00, 9.3516556505E-01],
	[3.2015000000E+04, 2.3187544790E+01, 4.9786996435E+00, 8.2349634169E+00, 2.7366092279E+00, 9.3519685762E-01],
	[3.2020000000E+04, 2.3193624646E+01, 4.9787040782E+00, 8.2391561136E+00, 2.7371581212E+00, 9.3522813425E-01],
	[3.2025000000E+04, 2.3199705146E+01, 4.9787085122E+00, 8.2433502891E+00, 2.7377068911E+00, 9.3525939494E-01],
	[3.2030000000E+04, 2.3205786291E+01, 4.9787129456E+00, 8.2475459435E+00, 2.7382555375E+00, 9.3529063970E-01],
	[3.2035000000E+04, 2.3211868080E+01, 4.9787173782E+00, 8.2517430772E+00, 2.7388040605E+00, 9.3532186854E-01],
	[3.2040000000E+04, 2.3217950513E+01, 4.9787218102E+00, 8.2559416904E+00, 2.7393524599E+00, 9.3535308148E-01],
	[3.2045000000E+04, 2.3224033591E+01, 4.9787262415E+00, 8.2601417835E+00, 2.7399007359E+00, 9.3538427850E-01],
	[3.2050000000E+04, 2.3230117313E+01, 4.9787306720E+00, 8.2643433568E+00, 2.7404488884E+00, 9.3541545963E-01],
	[3.2055000000E+04, 2.3236201679E+01, 4.9787351020E+00, 8.2685464105E+00, 2.7409969175E+00, 9.3544662487E-01],
	[3.2060000000E+04, 2.3242286689E+01, 4.9787395312E+00, 8.2727509450E+00, 2.7415448230E+00, 9.3547777422E-01],
	[3.2065000000E+04, 2.3248372344E+01, 4.9787439597E+00, 8.2769569604E+00, 2.7420926050E+00, 9.3550890770E-01],
	[3.2070000000E+04, 2.3254458643E+01, 4.9787483875E+00, 8.2811644572E+00, 2.7426402635E+00, 9.3554002531E-01],
	[3.2075000000E+04, 2.3260545586E+01, 4.9787528147E+00, 8.2853734356E+00, 2.7431877985E+00, 9.3557112705E-01],
	[3.2080000000E+04, 2.3266633173E+01, 4.9787572412E+00, 8.2895838958E+00, 2.7437352099E+00, 9.3560221295E-01],
	[3.2085000000E+04, 2.3272721404E+01, 4.9787616669E+00, 8.2937958383E+00, 2.7442824978E+00, 9.3563328300E-01],
	[3.2090000000E+04, 2.3278810280E+01, 4.9787660920E+00, 8.2980092632E+00, 2.7448296622E+00, 9.3566433720E-01],
	[3.2095000000E+04, 2.3284899799E+01, 4.9787705165E+00, 8.3022241709E+00, 2.7453767030E+00, 9.3569537558E-01],
	[3.2100000000E+04, 2.3290989962E+01, 4.9787749402E+00, 8.3064405616E+00, 2.7459236202E+00, 9.3572639813E-01],
	[3.2105000000E+04, 2.3297080770E+01, 4.9787793632E+00, 8.3106584357E+00, 2.7464704139E+00, 9.3575740486E-01],
	[3.2110000000E+04, 2.3303172221E+01, 4.9787837856E+00, 8.3148777934E+00, 2.7470170840E+00, 9.3578839578E-01],
	[3.2115000000E+04, 2.3309264316E+01, 4.9787882073E+00, 8.3190986350E+00, 2.7475636306E+00, 9.3581937090E-01],
	[3.2120000000E+04, 2.3315357055E+01, 4.9787926282E+00, 8.3233209609E+00, 2.7481100535E+00, 9.3585033023E-01],
	[3.2125000000E+04, 2.3321450438E+01, 4.9787970486E+00, 8.3275447712E+00, 2.7486563529E+00, 9.3588127376E-01],
	[3.2130000000E+04, 2.3327544464E+01, 4.9788014682E+00, 8.3317700664E+00, 2.7492025287E+00, 9.3591220152E-01],
	[3.2135000000E+04, 2.3333639135E+01, 4.9788058871E+00, 8.3359968466E+00, 2.7497485808E+00, 9.3594311350E-01],
	[3.2140000000E+04, 2.3339734449E+01, 4.9788103054E+00, 8.3402251122E+00, 2.7502945094E+00, 9.3597400971E-01],
	[3.2145000000E+04, 2.3345830407E+01, 4.9788147229E+00, 8.3444548635E+00, 2.7508403143E+00, 9.3600489017E-01],
	[3.2150000000E+04, 2.3351927008E+01, 4.9788191398E+00, 8.3486861007E+00, 2.7513859956E+00, 9.3603575487E-01],
	[3.2155000000E+04, 2.3358024253E+01, 4.9788235560E+00, 8.3529188242E+00, 2.7519315533E+00, 9.3606660383E-01],
	[3.2160000000E+04, 2.3364122142E+01, 4.9788279715E+00, 8.3571530342E+00, 2.7524769873E+00, 9.3609743706E-01],
	[3.2165000000E+04, 2.3370220674E+01, 4.9788323864E+00, 8.3613887310E+00, 2.7530222977E+00, 9.3612825455E-01],
	[3.2170000000E+04, 2.3376319850E+01, 4.9788368005E+00, 8.3656259150E+00, 2.7535674845E+00, 9.3615905632E-01],
	[3.2175000000E+04, 2.3382419669E+01, 4.9788412140E+00, 8.3698645863E+00, 2.7541125476E+00, 9.3618984238E-01],
	[3.2180000000E+04, 2.3388520132E+01, 4.9788456268E+00, 8.3741047454E+00, 2.7546574870E+00, 9.3622061273E-01],
	[3.2185000000E+04, 2.3394621239E+01, 4.9788500389E+00, 8.3783463924E+00, 2.7552023028E+00, 9.3625136737E-01],
	[3.2190000000E+04, 2.3400722988E+01, 4.9788544503E+00, 8.3825895278E+00, 2.7557469949E+00, 9.3628210633E-01],
	[3.2195000000E+04, 2.3406825381E+01, 4.9788588611E+00, 8.3868341517E+00, 2.7562915633E+00, 9.3631282960E-01],
	[3.2200000000E+04, 2.3412928418E+01, 4.9788632712E+00, 8.3910802644E+00, 2.7568360080E+00, 9.3634353719E-01],
	[3.2205000000E+04, 2.3419032098E+01, 4.9788676805E+00, 8.3953278663E+00, 2.7573803291E+00, 9.3637422911E-01],
	[3.2210000000E+04, 2.3425136421E+01, 4.9788720892E+00, 8.3995769577E+00, 2.7579245264E+00, 9.3640490537E-01],
	[3.2215000000E+04, 2.3431241387E+01, 4.9788764973E+00, 8.4038275388E+00, 2.7584686000E+00, 9.3643556597E-01],
	[3.2220000000E+04, 2.3437346996E+01, 4.9788809046E+00, 8.4080796099E+00, 2.7590125499E+00, 9.3646621092E-01],
	[3.2225000000E+04, 2.3443453249E+01, 4.9788853113E+00, 8.4123331713E+00, 2.7595563762E+00, 9.3649684023E-01],
	[3.2230000000E+04, 2.3449560145E+01, 4.9788897173E+00, 8.4165882233E+00, 2.7601000786E+00, 9.3652745391E-01],
	[3.2235000000E+04, 2.3455667684E+01, 4.9788941226E+00, 8.4208447662E+00, 2.7606436574E+00, 9.3655805196E-01],
	[3.2240000000E+04, 2.3461775866E+01, 4.9788985272E+00, 8.4251028003E+00, 2.7611871124E+00, 9.3658863439E-01],
	[3.2245000000E+04, 2.3467884691E+01, 4.9789029311E+00, 8.4293623259E+00, 2.7617304437E+00, 9.3661920121E-01],
	[3.2250000000E+04, 2.3473994159E+01, 4.9789073344E+00, 8.4336233432E+00, 2.7622736513E+00, 9.3664975242E-01],
	[3.2255000000E+04, 2.3480104270E+01, 4.9789117370E+00, 8.4378858526E+00, 2.7628167351E+00, 9.3668028804E-01],
	[3.2260000000E+04, 2.3486215024E+01, 4.9789161389E+00, 8.4421498544E+00, 2.7633596951E+00, 9.3671080806E-01],
	[3.2265000000E+04, 2.3492326421E+01, 4.9789205401E+00, 8.4464153487E+00, 2.7639025314E+00, 9.3674131251E-01],
	[3.2270000000E+04, 2.3498438461E+01, 4.9789249407E+00, 8.4506823360E+00, 2.7644452439E+00, 9.3677180137E-01],
	[3.2275000000E+04, 2.3504551144E+01, 4.9789293406E+00, 8.4549508166E+00, 2.7649878326E+00, 9.3680227467E-01],
	[3.2280000000E+04, 2.3510664470E+01, 4.9789337398E+00, 8.4592207906E+00, 2.7655302976E+00, 9.3683273241E-01],
	[3.2285000000E+04, 2.3516778438E+01, 4.9789381383E+00, 8.4634922584E+00, 2.7660726388E+00, 9.3686317460E-01],
	[3.2290000000E+04, 2.3522893049E+01, 4.9789425361E+00, 8.4677652204E+00, 2.7666148562E+00, 9.3689360124E-01],
	[3.2295000000E+04, 2.3529008303E+01, 4.9789469333E+00, 8.4720396767E+00, 2.7671569498E+00, 9.3692401234E-01],
	[3.2300000000E+04, 2.3535124200E+01, 4.9789513298E+00, 8.4763156277E+00, 2.7676989196E+00, 9.3695440791E-01],
	[3.2305000000E+04, 2.3541240739E+01, 4.9789557256E+00, 8.4805930736E+00, 2.7682407656E+00, 9.3698478796E-01],
	[3.2310000000E+04, 2.3547357921E+01, 4.9789601207E+00, 8.4848720148E+00, 2.7687824878E+00, 9.3701515249E-01],
	[3.2315000000E+04, 2.3553475746E+01, 4.9789645152E+00, 8.4891524515E+00, 2.7693240862E+00, 9.3704550151E-01],
	[3.2320000000E+04, 2.3559594213E+01, 4.9789689090E+00, 8.4934343841E+00, 2.7698655608E+00, 9.3707583503E-01],
	[3.2325000000E+04, 2.3565713323E+01, 4.9789733021E+00, 8.4977178128E+00, 2.7704069115E+00, 9.3710615306E-01],
	[3.2330000000E+04, 2.3571833075E+01, 4.9789776945E+00, 8.5020027379E+00, 2.7709481384E+00, 9.3713645560E-01],
	[3.2335000000E+04, 2.3577953470E+01, 4.9789820863E+00, 8.5062891598E+00, 2.7714892415E+00, 9.3716674266E-01],
	[3.2340000000E+04, 2.3584074507E+01, 4.9789864774E+00, 8.5105770786E+00, 2.7720302207E+00, 9.3719701424E-01],
	[3.2345000000E+04, 2.3590196187E+01, 4.9789908678E+00, 8.5148664947E+00, 2.7725710761E+00, 9.3722727037E-01],
	[3.2350000000E+04, 2.3596318509E+01, 4.9789952575E+00, 8.5191574084E+00, 2.7731118077E+00, 9.3725751103E-01],
	[3.2355000000E+04, 2.3602441473E+01, 4.9789996466E+00, 8.5234498200E+00, 2.7736524154E+00, 9.3728773625E-01],
	[3.2360000000E+04, 2.3608565080E+01, 4.9790040349E+00, 8.5277437297E+00, 2.7741928992E+00, 9.3731794602E-01],
	[3.2365000000E+04, 2.3614689329E+01, 4.9790084227E+00, 8.5320391379E+00, 2.7747332592E+00, 9.3734814036E-01],
	[3.2370000000E+04, 2.3620814220E+01, 4.9790128097E+00, 8.5363360448E+00, 2.7752734954E+00, 9.3737831927E-01],
	[3.2375000000E+04, 2.3626939753E+01, 4.9790171961E+00, 8.5406344508E+00, 2.7758136076E+00, 9.3740848275E-01],
	[3.2380000000E+04, 2.3633065929E+01, 4.9790215817E+00, 8.5449343561E+00, 2.7763535960E+00, 9.3743863083E-01],
	[3.2385000000E+04, 2.3639192747E+01, 4.9790259668E+00, 8.5492357610E+00, 2.7768934605E+00, 9.3746876350E-01],
	[3.2390000000E+04, 2.3645320207E+01, 4.9790303511E+00, 8.5535386658E+00, 2.7774332011E+00, 9.3749888077E-01],
	[3.2395000000E+04, 2.3651452955E+01, 4.9790353727E+00, 8.5578430708E+00, 2.7779730805E+00, 9.3752898265E-01],
	[3.2400000000E+04, 2.3657601676E+01, 4.9790424971E+00, 8.5621489763E+00, 2.7785137027E+00, 9.3755906915E-01],
	[3.2405000000E+04, 2.3663751046E+01, 4.9790496205E+00, 8.5664568903E+00, 2.7790542549E+00, 9.3758914027E-01],
	[3.2410000000E+04, 2.3669901065E+01, 4.9790567427E+00, 8.5707677518E+00, 2.7795948359E+00, 9.3761919602E-01],
	[3.2415000000E+04, 2.3676051733E+01, 4.9790638639E+00, 8.5750801164E+00, 2.7801352935E+00, 9.3764923641E-01],
	[3.2420000000E+04, 2.3682203051E+01, 4.9790709840E+00, 8.5793939844E+00, 2.7806756276E+00, 9.3767926145E-01],
	[3.2425000000E+04, 2.3688355017E+01, 4.9790781030E+00, 8.5837093561E+00, 2.7812158383E+00, 9.3770927114E-01],
	[3.2430000000E+04, 2.3694507633E+01, 4.9790852209E+00, 8.5880262319E+00, 2.7817559256E+00, 9.3773926549E-01],
	[3.2435000000E+04, 2.3700660898E+01, 4.9790923378E+00, 8.5923446119E+00, 2.7822958895E+00, 9.3776924451E-01],
	[3.2440000000E+04, 2.3706814813E+01, 4.9790994535E+00, 8.5966644965E+00, 2.7828357299E+00, 9.3779920820E-01],
	[3.2445000000E+04, 2.3712969376E+01, 4.9791065682E+00, 8.6009858860E+00, 2.7833754469E+00, 9.3782915658E-01],
	[3.2450000000E+04, 2.3719124588E+01, 4.9791136817E+00, 8.6053087807E+00, 2.7839150404E+00, 9.3785908964E-01],
	[3.2455000000E+04, 2.3725280449E+01, 4.9791207942E+00, 8.6096331808E+00, 2.7844545105E+00, 9.3788900741E-01],
	[3.2460000000E+04, 2.3731436960E+01, 4.9791279056E+00, 8.6139590867E+00, 2.7849938572E+00, 9.3791890988E-01],
	[3.2465000000E+04, 2.3737594119E+01, 4.9791350159E+00, 8.6182864986E+00, 2.7855330803E+00, 9.3794879706E-01],
	[3.2470000000E+04, 2.3743751927E+01, 4.9791421252E+00, 8.6226154169E+00, 2.7860721801E+00, 9.3797866896E-01],
	[3.2475000000E+04, 2.3749910384E+01, 4.9791492333E+00, 8.6269458418E+00, 2.7866111563E+00, 9.3800852559E-01],
	[3.2480000000E+04, 2.3756069490E+01, 4.9791563404E+00, 8.6312777736E+00, 2.7871500091E+00, 9.3803836696E-01],
	[3.2485000000E+04, 2.3762229244E+01, 4.9791634463E+00, 8.6356112127E+00, 2.7876887384E+00, 9.3806819306E-01],
	[3.2490000000E+04, 2.3768389648E+01, 4.9791705512E+00, 8.6399461592E+00, 2.7882273442E+00, 9.3809800392E-01],
	[3.2495000000E+04, 2.3774550700E+01, 4.9791776550E+00, 8.6442826136E+00, 2.7887658266E+00, 9.3812779953E-01],
	[3.2500000000E+04, 2.3780712401E+01, 4.9791847578E+00, 8.6486205760E+00, 2.7893041854E+00, 9.3815757991E-01],
	[3.2505000000E+04, 2.3786874751E+01, 4.9791918594E+00, 8.6529600469E+00, 2.7898424208E+00, 9.3818734505E-01],
	[3.2510000000E+04, 2.3793037749E+01, 4.9791989600E+00, 8.6573010264E+00, 2.7903805327E+00, 9.3821709498E-01],
	[3.2515000000E+04, 2.3799201396E+01, 4.9792060595E+00, 8.6616435148E+00, 2.7909185210E+00, 9.3824682969E-01],
	[3.2520000000E+04, 2.3805365691E+01, 4.9792131579E+00, 8.6659875125E+00, 2.7914563859E+00, 9.3827654920E-01],
	[3.2525000000E+04, 2.3811530635E+01, 4.9792202552E+00, 8.6703330198E+00, 2.7919941273E+00, 9.3830625351E-01],
	[3.2530000000E+04, 2.3817696228E+01, 4.9792273514E+00, 8.6746800369E+00, 2.7925317452E+00, 9.3833594263E-01],
	[3.2535000000E+04, 2.3823862469E+01, 4.9792344466E+00, 8.6790285642E+00, 2.7930692395E+00, 9.3836561656E-01],
	[3.2540000000E+04, 2.3830029358E+01, 4.9792415407E+00, 8.6833786019E+00, 2.7936066104E+00, 9.3839527532E-01],
	[3.2545000000E+04, 2.3836196897E+01, 4.9792486337E+00, 8.6877301503E+00, 2.7941438577E+00, 9.3842491890E-01],
	[3.2550000000E+04, 2.3842365083E+01, 4.9792557256E+00, 8.6920832097E+00, 2.7946809815E+00, 9.3845454733E-01],
	[3.2555000000E+04, 2.3848533918E+01, 4.9792628164E+00, 8.6964377804E+00, 2.7952179818E+00, 9.3848416060E-01],
	[3.2560000000E+04, 2.3854703401E+01, 4.9792699062E+00, 8.7007938627E+00, 2.7957548585E+00, 9.3851375872E-01],
	[3.2565000000E+04, 2.3860873532E+01, 4.9792769948E+00, 8.7051514569E+00, 2.7962916118E+00, 9.3854334171E-01],
	[3.2570000000E+04, 2.3867044312E+01, 4.9792840824E+00, 8.7095105633E+00, 2.7968282414E+00, 9.3857290956E-01],
	[3.2575000000E+04, 2.3873215740E+01, 4.9792911690E+00, 8.7138711821E+00, 2.7973647476E+00, 9.3860246229E-01],
	[3.2580000000E+04, 2.3879387816E+01, 4.9792982544E+00, 8.7182333137E+00, 2.7979011302E+00, 9.3863199990E-01],
	[3.2585000000E+04, 2.3885560541E+01, 4.9793053388E+00, 8.7225969584E+00, 2.7984373893E+00, 9.3866152240E-01],
	[3.2590000000E+04, 2.3891733913E+01, 4.9793124221E+00, 8.7269621164E+00, 2.7989735248E+00, 9.3869102979E-01],
	[3.2595000000E+04, 2.3897907934E+01, 4.9793195043E+00, 8.7313287881E+00, 2.7995095367E+00, 9.3872052210E-01],
	[3.2600000000E+04, 2.3904082603E+01, 4.9793265854E+00, 8.7356969737E+00, 2.8000454252E+00, 9.3874999931E-01],
	[3.2605000000E+04, 2.3910257919E+01, 4.9793336655E+00, 8.7400666735E+00, 2.8005811900E+00, 9.3877946144E-01],
	[3.2610000000E+04, 2.3916433884E+01, 4.9793407445E+00, 8.7444378878E+00, 2.8011168313E+00, 9.3880890850E-01],
	[3.2615000000E+04, 2.3922610497E+01, 4.9793478224E+00, 8.7488106169E+00, 2.8016523490E+00, 9.3883834050E-01],
	[3.2620000000E+04, 2.3928787758E+01, 4.9793548992E+00, 8.7531848612E+00, 2.8021877432E+00, 9.3886775744E-01],
	[3.2625000000E+04, 2.3934965667E+01, 4.9793619750E+00, 8.7575606208E+00, 2.8027230138E+00, 9.3889715932E-01],
	[3.2630000000E+04, 2.3941144223E+01, 4.9793690497E+00, 8.7619378961E+00, 2.8032581608E+00, 9.3892654617E-01],
	[3.2635000000E+04, 2.3947323428E+01, 4.9793761233E+00, 8.7663166874E+00, 2.8037931843E+00, 9.3895591797E-01],
	[3.2640000000E+04, 2.3953503280E+01, 4.9793831959E+00, 8.7706969950E+00, 2.8043280842E+00, 9.3898527475E-01],
	[3.2645000000E+04, 2.3959683781E+01, 4.9793902673E+00, 8.7750788191E+00, 2.8048628605E+00, 9.3901461651E-01],
	[3.2650000000E+04, 2.3965864929E+01, 4.9793973377E+00, 8.7794621601E+00, 2.8053975132E+00, 9.3904394325E-01],
	[3.2655000000E+04, 2.3972046724E+01, 4.9794044070E+00, 8.7838470182E+00, 2.8059320423E+00, 9.3907325499E-01],
	[3.2660000000E+04, 2.3978229168E+01, 4.9794114753E+00, 8.7882333938E+00, 2.8064664479E+00, 9.3910255173E-01],
	[3.2665000000E+04, 2.3984412259E+01, 4.9794185425E+00, 8.7926212871E+00, 2.8070007298E+00, 9.3913183347E-01],
	[3.2670000000E+04, 2.3990595998E+01, 4.9794256086E+00, 8.7970106984E+00, 2.8075348882E+00, 9.3916110024E-01],
	[3.2675000000E+04, 2.3996780384E+01, 4.9794326736E+00, 8.8014016281E+00, 2.8080689230E+00, 9.3919035202E-01],
	[3.2680000000E+04, 2.4002965418E+01, 4.9794397376E+00, 8.8057940763E+00, 2.8086028342E+00, 9.3921958884E-01],
	[3.2685000000E+04, 2.4009151100E+01, 4.9794468005E+00, 8.8101880435E+00, 2.8091366218E+00, 9.3924881069E-01],
	[3.2690000000E+04, 2.4015337429E+01, 4.9794538623E+00, 8.8145835298E+00, 2.8096702857E+00, 9.3927801759E-01],
	[3.2695000000E+04, 2.4021524405E+01, 4.9794609231E+00, 8.8189805356E+00, 2.8102038261E+00, 9.3930720955E-01],
	[3.2700000000E+04, 2.4027712029E+01, 4.9794679827E+00, 8.8233790612E+00, 2.8107372429E+00, 9.3933638656E-01],
	[3.2705000000E+04, 2.4033900301E+01, 4.9794750414E+00, 8.8277791069E+00, 2.8112705360E+00, 9.3936554864E-01],
	[3.2710000000E+04, 2.4040089220E+01, 4.9794820989E+00, 8.8321806730E+00, 2.8118037056E+00, 9.3939469580E-01],
	[3.2715000000E+04, 2.4046278786E+01, 4.9794891554E+00, 8.8365837597E+00, 2.8123367515E+00, 9.3942382803E-01],
	[3.2720000000E+04, 2.4052469000E+01, 4.9794962108E+00, 8.8409883673E+00, 2.8128696739E+00, 9.3945294536E-01],
	[3.2725000000E+04, 2.4058659861E+01, 4.9795032651E+00, 8.8453944962E+00, 2.8134024726E+00, 9.3948204779E-01],
	[3.2730000000E+04, 2.4064851369E+01, 4.9795103184E+00, 8.8498021466E+00, 2.8139351477E+00, 9.3951113532E-01],
	[3.2735000000E+04, 2.4071043524E+01, 4.9795173706E+00, 8.8542113189E+00, 2.8144676992E+00, 9.3954020796E-01],
	[3.2740000000E+04, 2.4077236327E+01, 4.9795244217E+00, 8.8586220132E+00, 2.8150001270E+00, 9.3956926572E-01],
	[3.2745000000E+04, 2.4083429777E+01, 4.9795314718E+00, 8.8630342300E+00, 2.8155324312E+00, 9.3959830861E-01],
	[3.2750000000E+04, 2.4089623874E+01, 4.9795385208E+00, 8.8674479695E+00, 2.8160646118E+00, 9.3962733664E-01],
	[3.2755000000E+04, 2.4095818618E+01, 4.9795455688E+00, 8.8718632320E+00, 2.8165966688E+00, 9.3965634980E-01],
	[3.2760000000E+04, 2.4102014009E+01, 4.9795526156E+00, 8.8762800177E+00, 2.8171286022E+00, 9.3968534812E-01],
	[3.2765000000E+04, 2.4108210048E+01, 4.9795596614E+00, 8.8806983271E+00, 2.8176604119E+00, 9.3971433159E-01],
	[3.2770000000E+04, 2.4114406733E+01, 4.9795667062E+00, 8.8851181603E+00, 2.8181920980E+00, 9.3974330022E-01],
	[3.2775000000E+04, 2.4120604065E+01, 4.9795737499E+00, 8.8895395177E+00, 2.8187236604E+00, 9.3977225403E-01],
	[3.2780000000E+04, 2.4126802045E+01, 4.9795807925E+00, 8.8939623995E+00, 2.8192550992E+00, 9.3980119302E-01],
	[3.2785000000E+04, 2.4133000671E+01, 4.9795878340E+00, 8.8983868061E+00, 2.8197864144E+00, 9.3983011719E-01],
	[3.2790000000E+04, 2.4139199944E+01, 4.9795948745E+00, 8.9028127377E+00, 2.8203176059E+00, 9.3985902655E-01],
	[3.2795000000E+04, 2.4145399864E+01, 4.9796019139E+00, 8.9072401947E+00, 2.8208486738E+00, 9.3988792112E-01],
	[3.2800000000E+04, 2.4151600431E+01, 4.9796089523E+00, 8.9116691773E+00, 2.8213796181E+00, 9.3991680089E-01],
	[3.2805000000E+04, 2.4157801645E+01, 4.9796159896E+00, 8.9160996858E+00, 2.8219104387E+00, 9.3994566589E-01],
	[3.2810000000E+04, 2.4164003505E+01, 4.9796230258E+00, 8.9205317206E+00, 2.8224411357E+00, 9.3997451610E-01],
	[3.2815000000E+04, 2.4170206012E+01, 4.9796300610E+00, 8.9249652818E+00, 2.8229717090E+00, 9.4000335154E-01],
	[3.2820000000E+04, 2.4176409166E+01, 4.9796370951E+00, 8.9294003699E+00, 2.8235021586E+00, 9.4003217223E-01],
	[3.2825000000E+04, 2.4182612967E+01, 4.9796441281E+00, 8.9338369850E+00, 2.8240324847E+00, 9.4006097815E-01],
	[3.2830000000E+04, 2.4188817414E+01, 4.9796511601E+00, 8.9382751275E+00, 2.8245626870E+00, 9.4008976933E-01],
	[3.2835000000E+04, 2.4195022508E+01, 4.9796581910E+00, 8.9427147977E+00, 2.8250927658E+00, 9.4011854578E-01],
	[3.2840000000E+04, 2.4201228248E+01, 4.9796652209E+00, 8.9471559959E+00, 2.8256227208E+00, 9.4014730748E-01],
	[3.2845000000E+04, 2.4207434636E+01, 4.9796722497E+00, 8.9515987223E+00, 2.8261525522E+00, 9.4017605447E-01],
	[3.2850000000E+04, 2.4213641669E+01, 4.9796792775E+00, 8.9560429773E+00, 2.8266822600E+00, 9.4020478673E-01],
	[3.2855000000E+04, 2.4219849349E+01, 4.9796863041E+00, 8.9604887612E+00, 2.8272118441E+00, 9.4023350429E-01],
	[3.2860000000E+04, 2.4226057676E+01, 4.9796933298E+00, 8.9649360741E+00, 2.8277413046E+00, 9.4026220714E-01],
	[3.2865000000E+04, 2.4232266649E+01, 4.9797003543E+00, 8.9693849166E+00, 2.8282706414E+00, 9.4029089530E-01],
	[3.2870000000E+04, 2.4238476268E+01, 4.9797073778E+00, 8.9738352887E+00, 2.8287998545E+00, 9.4031956877E-01],
	[3.2875000000E+04, 2.4244686534E+01, 4.9797144003E+00, 8.9782871909E+00, 2.8293289440E+00, 9.4034822756E-01],
	[3.2880000000E+04, 2.4250897446E+01, 4.9797214217E+00, 8.9827406233E+00, 2.8298579098E+00, 9.4037687168E-01],
	[3.2885000000E+04, 2.4257109005E+01, 4.9797284420E+00, 8.9871955864E+00, 2.8303867519E+00, 9.4040550113E-01],
	[3.2890000000E+04, 2.4263321209E+01, 4.9797354613E+00, 8.9916520804E+00, 2.8309154704E+00, 9.4043411592E-01],
	[3.2895000000E+04, 2.4269534060E+01, 4.9797424795E+00, 8.9961101056E+00, 2.8314440652E+00, 9.4046271606E-01],
	[3.2900000000E+04, 2.4275747557E+01, 4.9797494967E+00, 9.0005696622E+00, 2.8319725364E+00, 9.4049130156E-01],
	[3.2905000000E+04, 2.4281961701E+01, 4.9797565128E+00, 9.0050307506E+00, 2.8325008839E+00, 9.4051987242E-01],
	[3.2910000000E+04, 2.4288176490E+01, 4.9797635278E+00, 9.0094933711E+00, 2.8330291077E+00, 9.4054842866E-01],
	[3.2915000000E+04, 2.4294391926E+01, 4.9797705418E+00, 9.0139575240E+00, 2.8335572079E+00, 9.4057697027E-01],
	[3.2920000000E+04, 2.4300626434E+01, 4.9797800616E+00, 9.0184232095E+00, 2.8340862470E+00, 9.4060549727E-01],
	[3.2925000000E+04, 2.4306862911E+01, 4.9797897590E+00, 9.0228904280E+00, 2.8346152388E+00, 9.4063400966E-01],
	[3.2930000000E+04, 2.4313100041E+01, 4.9797994550E+00, 9.0273591797E+00, 2.8351441076E+00, 9.4066250745E-01],
	[3.2935000000E+04, 2.4319337824E+01, 4.9798091495E+00, 9.0318294649E+00, 2.8356728531E+00, 9.4069099065E-01],
	[3.2940000000E+04, 2.4325576261E+01, 4.9798188426E+00, 9.0363012840E+00, 2.8362014756E+00, 9.4071945927E-01],
	[3.2945000000E+04, 2.4331815350E+01, 4.9798285342E+00, 9.0407746372E+00, 2.8367299749E+00, 9.4074791331E-01],
	[3.2950000000E+04, 2.4338055093E+01, 4.9798382243E+00, 9.0452495248E+00, 2.8372583511E+00, 9.4077635278E-01],
	[3.2955000000E+04, 2.4344295488E+01, 4.9798479130E+00, 9.0497259471E+00, 2.8377866041E+00, 9.4080477768E-01],
	[3.2960000000E+04, 2.4350536537E+01, 4.9798576003E+00, 9.0542039044E+00, 2.8383147340E+00, 9.4083318804E-01],
	[3.2965000000E+04, 2.4356778238E+01, 4.9798672861E+00, 9.0586833970E+00, 2.8388427408E+00, 9.4086158384E-01],
	[3.2970000000E+04, 2.4363020592E+01, 4.9798769704E+00, 9.0631644252E+00, 2.8393706245E+00, 9.4088996511E-01],
	[3.2975000000E+04, 2.4369263600E+01, 4.9798866533E+00, 9.0676469893E+00, 2.8398983850E+00, 9.4091833184E-01],
	[3.2980000000E+04, 2.4375507260E+01, 4.9798963348E+00, 9.0721310895E+00, 2.8404260223E+00, 9.4094668405E-01],
	[3.2985000000E+04, 2.4381751572E+01, 4.9799060148E+00, 9.0766167262E+00, 2.8409535365E+00, 9.4097502174E-01],
	[3.2990000000E+04, 2.4387996538E+01, 4.9799156933E+00, 9.0811038997E+00, 2.8414809276E+00, 9.4100334492E-01],
	[3.2995000000E+04, 2.4394242156E+01, 4.9799253705E+00, 9.0855926102E+00, 2.8420081956E+00, 9.4103165360E-01],
	[3.3000000000E+04, 2.4400488427E+01, 4.9799350461E+00, 9.0900828581E+00, 2.8425353404E+00, 9.4105994778E-01],
	[3.3005000000E+04, 2.4406735351E+01, 4.9799447203E+00, 9.0945746436E+00, 2.8430623621E+00, 9.4108822747E-01],
	[3.3010000000E+04, 2.4412982928E+01, 4.9799543931E+00, 9.0990679670E+00, 2.8435892606E+00, 9.4111649268E-01],
	[3.3015000000E+04, 2.4419231157E+01, 4.9799640644E+00, 9.1035628286E+00, 2.8441160360E+00, 9.4114474342E-01],
	[3.3020000000E+04, 2.4425480039E+01, 4.9799737343E+00, 9.1080592288E+00, 2.8446426883E+00, 9.4117297969E-01],
	[3.3025000000E+04, 2.4431729573E+01, 4.9799834027E+00, 9.1125571678E+00, 2.8451692174E+00, 9.4120120151E-01],
	[3.3030000000E+04, 2.4437979760E+01, 4.9799930697E+00, 9.1170566458E+00, 2.8456956234E+00, 9.4122940887E-01],
	[3.3035000000E+04, 2.4444230599E+01, 4.9800027352E+00, 9.1215576633E+00, 2.8462219063E+00, 9.4125760179E-01],
	[3.3040000000E+04, 2.4450482091E+01, 4.9800123993E+00, 9.1260602205E+00, 2.8467480660E+00, 9.4128578027E-01],
	[3.3045000000E+04, 2.4456734235E+01, 4.9800220620E+00, 9.1305643176E+00, 2.8472741025E+00, 9.4131394432E-01],
	[3.3050000000E+04, 2.4462987032E+01, 4.9800317232E+00, 9.1350699550E+00, 2.8478000160E+00, 9.4134209396E-01],
	[3.3055000000E+04, 2.4469240481E+01, 4.9800413830E+00, 9.1395771330E+00, 2.8483258063E+00, 9.4137022917E-01],
	[3.3060000000E+04, 2.4475494582E+01, 4.9800510413E+00, 9.1440858518E+00, 2.8488514734E+00, 9.4139834998E-01],
	[3.3065000000E+04, 2.4481749336E+01, 4.9800606982E+00, 9.1485961119E+00, 2.8493770175E+00, 9.4142645639E-01],
	[3.3070000000E+04, 2.4488004742E+01, 4.9800703536E+00, 9.1531079133E+00, 2.8499024383E+00, 9.4145454841E-01],
	[3.3075000000E+04, 2.4494260800E+01, 4.9800800076E+00, 9.1576212565E+00, 2.8504277361E+00, 9.4148262604E-01],
	[3.3080000000E+04, 2.4500517511E+01, 4.9800896602E+00, 9.1621361417E+00, 2.8509529107E+00, 9.4151068930E-01],
	[3.3085000000E+04, 2.4506774873E+01, 4.9800993113E+00, 9.1666525693E+00, 2.8514779622E+00, 9.4153873819E-01],
	[3.3090000000E+04, 2.4513032888E+01, 4.9801089610E+00, 9.1711705395E+00, 2.8520028905E+00, 9.4156677271E-01],
	[3.3095000000E+04, 2.4519291555E+01, 4.9801186092E+00, 9.1756900525E+00, 2.8525276957E+00, 9.4159479288E-01],
	[3.3100000000E+04, 2.4525550874E+01, 4.9801282560E+00, 9.1802111088E+00, 2.8530523778E+00, 9.4162279870E-01],
	[3.3105000000E+04, 2.4531810846E+01, 4.9801379014E+00, 9.1847337086E+00, 2.8535769367E+00, 9.4165079018E-01],
	[3.3110000000E+04, 2.4538071469E+01, 4.9801475453E+00, 9.1892578522E+00, 2.8541013726E+00, 9.4167876732E-01],
	[3.3115000000E+04, 2.4544332744E+01, 4.9801571878E+00, 9.1937835399E+00, 2.8546256852E+00, 9.4170673014E-01],
	[3.3120000000E+04, 2.4550594671E+01, 4.9801668288E+00, 9.1983107720E+00, 2.8551498748E+00, 9.4173467865E-01],
	[3.3125000000E+04, 2.4556857251E+01, 4.9801764684E+00, 9.2028395487E+00, 2.8556739412E+00, 9.4176261284E-01],
	[3.3130000000E+04, 2.4563120482E+01, 4.9801861066E+00, 9.2073698704E+00, 2.8561978845E+00, 9.4179053272E-01],
	[3.3135000000E+04, 2.4569384365E+01, 4.9801957434E+00, 9.2119017374E+00, 2.8567217046E+00, 9.4181843832E-01],
	[3.3140000000E+04, 2.4575648900E+01, 4.9802053787E+00, 9.2164351499E+00, 2.8572454016E+00, 9.4184632962E-01],
	[3.3145000000E+04, 2.4581914087E+01, 4.9802150125E+00, 9.2209701083E+00, 2.8577689755E+00, 9.4187420664E-01],
	[3.3150000000E+04, 2.4588179925E+01, 4.9802246450E+00, 9.2255066128E+00, 2.8582924263E+00, 9.4190206938E-01],
	[3.3155000000E+04, 2.4594446416E+01, 4.9802342760E+00, 9.2300446638E+00, 2.8588157539E+00, 9.4192991786E-01],
	[3.3160000000E+04, 2.4600713558E+01, 4.9802439055E+00, 9.2345842614E+00, 2.8593389584E+00, 9.4195775208E-01],
	[3.3165000000E+04, 2.4606981351E+01, 4.9802535337E+00, 9.2391254062E+00, 2.8598620398E+00, 9.4198557205E-01],
	[3.3170000000E+04, 2.4613249797E+01, 4.9802631604E+00, 9.2436680982E+00, 2.8603849981E+00, 9.4201337778E-01],
	[3.3175000000E+04, 2.4619518894E+01, 4.9802727856E+00, 9.2482123378E+00, 2.8609078332E+00, 9.4204116926E-01],
	[3.3180000000E+04, 2.4625788643E+01, 4.9802824095E+00, 9.2527581253E+00, 2.8614305452E+00, 9.4206894652E-01],
	[3.3185000000E+04, 2.4632059043E+01, 4.9802920319E+00, 9.2573054610E+00, 2.8619531341E+00, 9.4209670955E-01],
	[3.3190000000E+04, 2.4638330095E+01, 4.9803016529E+00, 9.2618543453E+00, 2.8624755999E+00, 9.4212445837E-01],
	[3.3195000000E+04, 2.4644601799E+01, 4.9803112724E+00, 9.2664047783E+00, 2.8629979426E+00, 9.4215219298E-01],
	[3.3200000000E+04, 2.4650874154E+01, 4.9803208905E+00, 9.2709567603E+00, 2.8635201621E+00, 9.4217991339E-01],
	[3.3205000000E+04, 2.4657147160E+01, 4.9803305072E+00, 9.2755102918E+00, 2.8640422586E+00, 9.4220761961E-01],
	[3.3210000000E+04, 2.4663420818E+01, 4.9803401225E+00, 9.2800653729E+00, 2.8645642319E+00, 9.4223531164E-01],
	[3.3215000000E+04, 2.4669695127E+01, 4.9803497363E+00, 9.2846220040E+00, 2.8650860821E+00, 9.4226298949E-01],
	[3.3220000000E+04, 2.4675970088E+01, 4.9803593487E+00, 9.2891801853E+00, 2.8656078092E+00, 9.4229065317E-01],
	[3.3225000000E+04, 2.4682245700E+01, 4.9803689596E+00, 9.2937399171E+00, 2.8661294132E+00, 9.4231830269E-01],
	[3.3230000000E+04, 2.4688521963E+01, 4.9803785692E+00, 9.2983011998E+00, 2.8666508940E+00, 9.4234593805E-01],
	[3.3235000000E+04, 2.4694798878E+01, 4.9803881773E+00, 9.3028640337E+00, 2.8671722518E+00, 9.4237355926E-01],
	[3.3240000000E+04, 2.4701076444E+01, 4.9803977840E+00, 9.3074284189E+00, 2.8676934865E+00, 9.4240116633E-01],
	[3.3245000000E+04, 2.4707354661E+01, 4.9804073892E+00, 9.3119943559E+00, 2.8682145980E+00, 9.4242875927E-01],
	[3.3250000000E+04, 2.4713633529E+01, 4.9804169931E+00, 9.3165618449E+00, 2.8687355865E+00, 9.4245633807E-01],
	[3.3255000000E+04, 2.4719913048E+01, 4.9804265955E+00, 9.3211308862E+00, 2.8692564518E+00, 9.4248390276E-01],
	[3.3260000000E+04, 2.4726193219E+01, 4.9804361965E+00, 9.3257014801E+00, 2.8697771941E+00, 9.4251145334E-01],
	[3.3265000000E+04, 2.4732474041E+01, 4.9804457960E+00, 9.3302736269E+00, 2.8702978132E+00, 9.4253898981E-01],
	[3.3270000000E+04, 2.4738755514E+01, 4.9804553942E+00, 9.3348473269E+00, 2.8708183093E+00, 9.4256651219E-01],
	[3.3275000000E+04, 2.4745037637E+01, 4.9804649909E+00, 9.3394225803E+00, 2.8713386823E+00, 9.4259402047E-01],
	[3.3280000000E+04, 2.4751320412E+01, 4.9804745862E+00, 9.3439993876E+00, 2.8718589321E+00, 9.4262151467E-01],
	[3.3285000000E+04, 2.4757603838E+01, 4.9804841800E+00, 9.3485777489E+00, 2.8723790589E+00, 9.4264899480E-01],
	[3.3290000000E+04, 2.4763887915E+01, 4.9804937725E+00, 9.3531576645E+00, 2.8728990626E+00, 9.4267646086E-01],
	[3.3295000000E+04, 2.4770172643E+01, 4.9805033635E+00, 9.3577391349E+00, 2.8734189432E+00, 9.4270391285E-01],
	[3.3300000000E+04, 2.4776458021E+01, 4.9805129531E+00, 9.3623221601E+00, 2.8739387007E+00, 9.4273135080E-01],
	[3.3305000000E+04, 2.4782744051E+01, 4.9805225413E+00, 9.3669067406E+00, 2.8744583352E+00, 9.4275877469E-01],
	[3.3310000000E+04, 2.4789030731E+01, 4.9805321280E+00, 9.3714928767E+00, 2.8749778465E+00, 9.4278618455E-01],
	[3.3315000000E+04, 2.4795318062E+01, 4.9805417134E+00, 9.3760805686E+00, 2.8754972348E+00, 9.4281358038E-01],
	[3.3320000000E+04, 2.4801606044E+01, 4.9805512973E+00, 9.3806698166E+00, 2.8760165000E+00, 9.4284096218E-01],
	[3.3325000000E+04, 2.4807894676E+01, 4.9805608798E+00, 9.3852606210E+00, 2.8765356421E+00, 9.4286832997E-01],
	[3.3330000000E+04, 2.4814183960E+01, 4.9805704609E+00, 9.3898529822E+00, 2.8770546612E+00, 9.4289568374E-01],
	[3.3335000000E+04, 2.4820473894E+01, 4.9805800405E+00, 9.3944469003E+00, 2.8775735572E+00, 9.4292302352E-01],
	[3.3340000000E+04, 2.4826764478E+01, 4.9805896187E+00, 9.3990423758E+00, 2.8780923301E+00, 9.4295034930E-01],
	[3.3345000000E+04, 2.4833055714E+01, 4.9805991956E+00, 9.4036394088E+00, 2.8786109799E+00, 9.4297766109E-01],
	[3.3350000000E+04, 2.4839347599E+01, 4.9806087710E+00, 9.4082379998E+00, 2.8791295067E+00, 9.4300495890E-01],
	[3.3355000000E+04, 2.4845640136E+01, 4.9806183450E+00, 9.4128381489E+00, 2.8796479104E+00, 9.4303224274E-01],
	[3.3360000000E+04, 2.4851933323E+01, 4.9806279175E+00, 9.4174398565E+00, 2.8801661911E+00, 9.4305951261E-01],
	[3.3365000000E+04, 2.4858227160E+01, 4.9806374887E+00, 9.4220431228E+00, 2.8806843487E+00, 9.4308676853E-01],
	[3.3370000000E+04, 2.4864521648E+01, 4.9806470584E+00, 9.4266479483E+00, 2.8812023832E+00, 9.4311401049E-01],
	[3.3375000000E+04, 2.4870816786E+01, 4.9806566267E+00, 9.4312543330E+00, 2.8817202947E+00, 9.4314123852E-01],
	[3.3380000000E+04, 2.4877112575E+01, 4.9806661937E+00, 9.4358622775E+00, 2.8822380832E+00, 9.4316845260E-01],
	[3.3385000000E+04, 2.4883409014E+01, 4.9806757592E+00, 9.4404717819E+00, 2.8827557486E+00, 9.4319565276E-01],
	[3.3390000000E+04, 2.4889706104E+01, 4.9806853232E+00, 9.4450828465E+00, 2.8832732909E+00, 9.4322283899E-01],
	[3.3395000000E+04, 2.4896003844E+01, 4.9806948859E+00, 9.4496954716E+00, 2.8837907102E+00, 9.4325001131E-01],
	[3.3400000000E+04, 2.4902302234E+01, 4.9807044471E+00, 9.4543096576E+00, 2.8843080065E+00, 9.4327716972E-01],
	[3.3405000000E+04, 2.4908601274E+01, 4.9807140070E+00, 9.4589254047E+00, 2.8848251798E+00, 9.4330431424E-01],
	[3.3410000000E+04, 2.4914900965E+01, 4.9807235654E+00, 9.4635427132E+00, 2.8853422300E+00, 9.4333144486E-01],
	[3.3415000000E+04, 2.4921201305E+01, 4.9807331224E+00, 9.4681615835E+00, 2.8858591571E+00, 9.4335856160E-01],
	[3.3420000000E+04, 2.4927502296E+01, 4.9807426780E+00, 9.4727820157E+00, 2.8863759613E+00, 9.4338566445E-01],
	[3.3425000000E+04, 2.4933803937E+01, 4.9807522322E+00, 9.4774040102E+00, 2.8868926424E+00, 9.4341275344E-01],
	[3.3430000000E+04, 2.4940106229E+01, 4.9807617850E+00, 9.4820275674E+00, 2.8874092005E+00, 9.4343982857E-01],
	[3.3435000000E+04, 2.4946409170E+01, 4.9807713364E+00, 9.4866526874E+00, 2.8879256356E+00, 9.4346688984E-01],
	[3.3440000000E+04, 2.4952712761E+01, 4.9807808863E+00, 9.4912793706E+00, 2.8884419476E+00, 9.4349393726E-01],
	[3.3445000000E+04, 2.4959017002E+01, 4.9807904349E+00, 9.4959076172E+00, 2.8889581366E+00, 9.4352097084E-01],
	[3.3450000000E+04, 2.4965340519E+01, 4.9808024949E+00, 9.5005374277E+00, 2.8894752979E+00, 9.4354799059E-01],
	[3.3455000000E+04, 2.4971665571E+01, 4.9808146718E+00, 9.5051688022E+00, 2.8899923883E+00, 9.4357499650E-01],
	[3.3460000000E+04, 2.4977991281E+01, 4.9808268468E+00, 9.5098017410E+00, 2.8905093562E+00, 9.4360198861E-01],
	[3.3465000000E+04, 2.4984317647E+01, 4.9808390201E+00, 9.5144362445E+00, 2.8910262016E+00, 9.4362896689E-01],
	[3.3470000000E+04, 2.4990644670E+01, 4.9808511916E+00, 9.5190723130E+00, 2.8915429245E+00, 9.4365593138E-01],
	[3.3475000000E+04, 2.4996972350E+01, 4.9808633613E+00, 9.5237099467E+00, 2.8920595250E+00, 9.4368288207E-01],
	[3.3480000000E+04, 2.5003300686E+01, 4.9808755292E+00, 9.5283491459E+00, 2.8925760029E+00, 9.4370981896E-01],
	[3.3485000000E+04, 2.5009629679E+01, 4.9808876953E+00, 9.5329899109E+00, 2.8930923584E+00, 9.4373674208E-01],
	[3.3490000000E+04, 2.5015959329E+01, 4.9808998597E+00, 9.5376322421E+00, 2.8936085914E+00, 9.4376365142E-01],
	[3.3495000000E+04, 2.5022289636E+01, 4.9809120222E+00, 9.5422761397E+00, 2.8941247020E+00, 9.4379054699E-01],
	[3.3500000000E+04, 2.5028620599E+01, 4.9809241830E+00, 9.5469216040E+00, 2.8946406900E+00, 9.4381742880E-01],
	[3.3505000000E+04, 2.5034952219E+01, 4.9809363420E+00, 9.5515686353E+00, 2.8951565556E+00, 9.4384429685E-01],
	[3.3510000000E+04, 2.5041284496E+01, 4.9809484992E+00, 9.5562172339E+00, 2.8956722987E+00, 9.4387115116E-01],
	[3.3515000000E+04, 2.5047617429E+01, 4.9809606546E+00, 9.5608674001E+00, 2.8961879194E+00, 9.4389799173E-01],
	[3.3520000000E+04, 2.5053951018E+01, 4.9809728082E+00, 9.5655191342E+00, 2.8967034176E+00, 9.4392481857E-01],
	[3.3525000000E+04, 2.5060285264E+01, 4.9809849601E+00, 9.5701724364E+00, 2.8972187934E+00, 9.4395163169E-01],
	[3.3530000000E+04, 2.5066620167E+01, 4.9809971101E+00, 9.5748273072E+00, 2.8977340467E+00, 9.4397843109E-01],
	[3.3535000000E+04, 2.5072955725E+01, 4.9810092584E+00, 9.5794837467E+00, 2.8982491776E+00, 9.4400521678E-01],
	[3.3540000000E+04, 2.5079291941E+01, 4.9810214049E+00, 9.5841417552E+00, 2.8987641860E+00, 9.4403198876E-01],
	[3.3545000000E+04, 2.5085628812E+01, 4.9810335497E+00, 9.5888013332E+00, 2.8992790719E+00, 9.4405874705E-01],
	[3.3550000000E+04, 2.5091966340E+01, 4.9810456926E+00, 9.5934624807E+00, 2.8997938355E+00, 9.4408549166E-01],
	[3.3555000000E+04, 2.5098304525E+01, 4.9810578338E+00, 9.5981251983E+00, 2.9003084766E+00, 9.4411222258E-01],
	[3.3560000000E+04, 2.5104643365E+01, 4.9810699731E+00, 9.6027894860E+00, 2.9008229953E+00, 9.4413893983E-01],
	[3.3565000000E+04, 2.5110982862E+01, 4.9810821107E+00, 9.6074553444E+00, 2.9013373915E+00, 9.4416564341E-01],
	[3.3570000000E+04, 2.5117323015E+01, 4.9810942466E+00, 9.6121227735E+00, 2.9018516653E+00, 9.4419233333E-01],
	[3.3575000000E+04, 2.5123663824E+01, 4.9811063806E+00, 9.6167917738E+00, 2.9023658167E+00, 9.4421900960E-01],
	[3.3580000000E+04, 2.5130005290E+01, 4.9811185129E+00, 9.6214623454E+00, 2.9028798457E+00, 9.4424567223E-01],
	[3.3585000000E+04, 2.5136347411E+01, 4.9811306434E+00, 9.6261344888E+00, 2.9033937522E+00, 9.4427232122E-01],
	[3.3590000000E+04, 2.5142690189E+01, 4.9811427721E+00, 9.6308082042E+00, 2.9039075364E+00, 9.4429895658E-01],
	[3.3595000000E+04, 2.5149033623E+01, 4.9811548990E+00, 9.6354834919E+00, 2.9044211981E+00, 9.4432557832E-01],
	[3.3600000000E+04, 2.5155377713E+01, 4.9811670242E+00, 9.6401603522E+00, 2.9049347375E+00, 9.4435218645E-01],
	[3.3605000000E+04, 2.5161722458E+01, 4.9811791476E+00, 9.6448387854E+00, 2.9054481544E+00, 9.4437878096E-01],
	[3.3610000000E+04, 2.5168067860E+01, 4.9811912692E+00, 9.6495187918E+00, 2.9059614490E+00, 9.4440536187E-01],
	[3.3615000000E+04, 2.5174413918E+01, 4.9812033890E+00, 9.6542003717E+00, 2.9064746211E+00, 9.4443192920E-01],
	[3.3620000000E+04, 2.5180760631E+01, 4.9812155071E+00, 9.6588835253E+00, 2.9069876709E+00, 9.4445848293E-01],
	[3.3625000000E+04, 2.5187108001E+01, 4.9812276234E+00, 9.6635682530E+00, 2.9075005983E+00, 9.4448502309E-01],
	[3.3630000000E+04, 2.5193456026E+01, 4.9812397379E+00, 9.6682545551E+00, 2.9080134033E+00, 9.4451154967E-01],
	[3.3635000000E+04, 2.5199804707E+01, 4.9812518507E+00, 9.6729424318E+00, 2.9085260859E+00, 9.4453806269E-01],
	[3.3640000000E+04, 2.5206154044E+01, 4.9812639617E+00, 9.6776318835E+00, 2.9090386462E+00, 9.4456456215E-01],
	[3.3645000000E+04, 2.5212504037E+01, 4.9812760709E+00, 9.6823229104E+00, 2.9095510841E+00, 9.4459104807E-01],
	[3.3650000000E+04, 2.5218854686E+01, 4.9812881783E+00, 9.6870155129E+00, 2.9100633996E+00, 9.4461752044E-01],
	[3.3655000000E+04, 2.5225205990E+01, 4.9813002840E+00, 9.6917096912E+00, 2.9105755927E+00, 9.4464397927E-01],
	[3.3660000000E+04, 2.5231557950E+01, 4.9813123879E+00, 9.6964054456E+00, 2.9110876635E+00, 9.4467042458E-01],
	[3.3665000000E+04, 2.5237910565E+01, 4.9813244900E+00, 9.7011027765E+00, 2.9115996120E+00, 9.4469685636E-01],
	[3.3670000000E+04, 2.5244263837E+01, 4.9813365904E+00, 9.7058016840E+00, 2.9121114381E+00, 9.4472327462E-01],
	[3.3675000000E+04, 2.5250617763E+01, 4.9813486890E+00, 9.7105021686E+00, 2.9126231419E+00, 9.4474967938E-01],
	[3.3680000000E+04, 2.5256972346E+01, 4.9813607858E+00, 9.7152042305E+00, 2.9131347233E+00, 9.4477607063E-01],
	[3.3685000000E+04, 2.5263327584E+01, 4.9813728809E+00, 9.7199078700E+00, 2.9136461824E+00, 9.4480244839E-01],
	[3.3690000000E+04, 2.5269683477E+01, 4.9813849742E+00, 9.7246130875E+00, 2.9141575191E+00, 9.4482881265E-01],
	[3.3695000000E+04, 2.5276040026E+01, 4.9813970657E+00, 9.7293198831E+00, 2.9146687335E+00, 9.4485516343E-01],
	[3.3700000000E+04, 2.5282397230E+01, 4.9814091555E+00, 9.7340282571E+00, 2.9151798256E+00, 9.4488150073E-01],
	[3.3705000000E+04, 2.5288755090E+01, 4.9814212435E+00, 9.7387382100E+00, 2.9156907954E+00, 9.4490782456E-01],
	[3.3710000000E+04, 2.5295113605E+01, 4.9814333297E+00, 9.7434497420E+00, 2.9162016429E+00, 9.4493413492E-01],
	[3.3715000000E+04, 2.5301472776E+01, 4.9814454142E+00, 9.7481628533E+00, 2.9167123681E+00, 9.4496043182E-01],
	[3.3720000000E+04, 2.5307832601E+01, 4.9814574969E+00, 9.7528775443E+00, 2.9172229709E+00, 9.4498671527E-01],
	[3.3725000000E+04, 2.5314193082E+01, 4.9814695779E+00, 9.7575938152E+00, 2.9177334515E+00, 9.4501298528E-01],
	[3.3730000000E+04, 2.5320554219E+01, 4.9814816571E+00, 9.7623116664E+00, 2.9182438097E+00, 9.4503924184E-01],
	[3.3735000000E+04, 2.5326916010E+01, 4.9814937345E+00, 9.7670310982E+00, 2.9187540457E+00, 9.4506548497E-01],
	[3.3740000000E+04, 2.5333278457E+01, 4.9815058102E+00, 9.7717521108E+00, 2.9192641594E+00, 9.4509171468E-01],
	[3.3745000000E+04, 2.5339641559E+01, 4.9815178841E+00, 9.7764747045E+00, 2.9197741508E+00, 9.4511793096E-01],
	[3.3750000000E+04, 2.5346005316E+01, 4.9815299562E+00, 9.7811988797E+00, 2.9202840199E+00, 9.4514413383E-01],
	[3.3755000000E+04, 2.5352369729E+01, 4.9815420266E+00, 9.7859246366E+00, 2.9207937667E+00, 9.4517032329E-01],
	[3.3760000000E+04, 2.5358734796E+01, 4.9815540953E+00, 9.7906519755E+00, 2.9213033913E+00, 9.4519649935E-01],
	[3.3765000000E+04, 2.5365100518E+01, 4.9815661621E+00, 9.7953808968E+00, 2.9218128936E+00, 9.4522266201E-01],
	[3.3770000000E+04, 2.5371466896E+01, 4.9815782272E+00, 9.8001114007E+00, 2.9223222737E+00, 9.4524881129E-01],
	[3.3775000000E+04, 2.5377833928E+01, 4.9815902906E+00, 9.8048434874E+00, 2.9228315315E+00, 9.4527494718E-01],
	[3.3780000000E+04, 2.5384201616E+01, 4.9816023522E+00, 9.8095771574E+00, 2.9233406670E+00, 9.4530106970E-01],
	[3.3785000000E+04, 2.5390569958E+01, 4.9816144121E+00, 9.8143124109E+00, 2.9238496803E+00, 9.4532717885E-01],
	[3.3790000000E+04, 2.5396938955E+01, 4.9816264701E+00, 9.8190492482E+00, 2.9243585714E+00, 9.4535327463E-01],
	[3.3795000000E+04, 2.5403308607E+01, 4.9816385265E+00, 9.8237876695E+00, 2.9248673402E+00, 9.4537935706E-01],
	[3.3800000000E+04, 2.5409678914E+01, 4.9816505811E+00, 9.8285276753E+00, 2.9253759868E+00, 9.4540542614E-01],
	[3.3805000000E+04, 2.5416049876E+01, 4.9816626339E+00, 9.8332692657E+00, 2.9258845112E+00, 9.4543148187E-01],
	[3.3810000000E+04, 2.5422421493E+01, 4.9816746850E+00, 9.8380124411E+00, 2.9263929134E+00, 9.4545752427E-01],
	[3.3815000000E+04, 2.5428793764E+01, 4.9816867343E+00, 9.8427572018E+00, 2.9269011933E+00, 9.4548355333E-01],
	[3.3820000000E+04, 2.5435166690E+01, 4.9816987819E+00, 9.8475035480E+00, 2.9274093510E+00, 9.4550956908E-01],
	[3.3825000000E+04, 2.5441540271E+01, 4.9817108277E+00, 9.8522514801E+00, 2.9279173865E+00, 9.4553557150E-01],
	[3.3830000000E+04, 2.5447914507E+01, 4.9817228717E+00, 9.8570009983E+00, 2.9284252999E+00, 9.4556156061E-01],
	[3.3835000000E+04, 2.5454289397E+01, 4.9817349141E+00, 9.8617521030E+00, 2.9289330910E+00, 9.4558753642E-01],
	[3.3840000000E+04, 2.5460664942E+01, 4.9817469546E+00, 9.8665047944E+00, 2.9294407599E+00, 9.4561349892E-01],
	[3.3845000000E+04, 2.5467041141E+01, 4.9817589934E+00, 9.8712590729E+00, 2.9299483067E+00, 9.4563944814E-01],
	[3.3850000000E+04, 2.5473417995E+01, 4.9817710305E+00, 9.8760149387E+00, 2.9304557313E+00, 9.4566538407E-01],
	[3.3855000000E+04, 2.5479795503E+01, 4.9817830658E+00, 9.8807723921E+00, 2.9309630337E+00, 9.4569130672E-01],
	[3.3860000000E+04, 2.5486173666E+01, 4.9817950994E+00, 9.8855314335E+00, 2.9314702139E+00, 9.4571721609E-01],
	[3.3865000000E+04, 2.5492552484E+01, 4.9818071312E+00, 9.8902920631E+00, 2.9319772720E+00, 9.4574311220E-01],
	[3.3870000000E+04, 2.5498931956E+01, 4.9818191613E+00, 9.8950542811E+00, 2.9324842079E+00, 9.4576899505E-01],
	[3.3875000000E+04, 2.5505312082E+01, 4.9818311896E+00, 9.8998180880E+00, 2.9329910217E+00, 9.4579486464E-01],
	[3.3880000000E+04, 2.5511692862E+01, 4.9818432162E+00, 9.9045834840E+00, 2.9334977133E+00, 9.4582072099E-01],
	[3.3885000000E+04, 2.5518074297E+01, 4.9818552410E+00, 9.9093504694E+00, 2.9340042827E+00, 9.4584656410E-01],
	[3.3890000000E+04, 2.5524456387E+01, 4.9818672641E+00, 9.9141190445E+00, 2.9345107301E+00, 9.4587239397E-01],
	[3.3895000000E+04, 2.5530839130E+01, 4.9818792855E+00, 9.9188892096E+00, 2.9350170553E+00, 9.4589821061E-01],
	[3.3900000000E+04, 2.5537222528E+01, 4.9818913051E+00, 9.9236609650E+00, 2.9355232584E+00, 9.4592401403E-01],
	[3.3905000000E+04, 2.5543606580E+01, 4.9819033229E+00, 9.9284343109E+00, 2.9360293393E+00, 9.4594980424E-01],
	[3.3910000000E+04, 2.5549991287E+01, 4.9819153391E+00, 9.9332092477E+00, 2.9365352982E+00, 9.4597558124E-01],
	[3.3915000000E+04, 2.5556376647E+01, 4.9819273534E+00, 9.9379857757E+00, 2.9370411349E+00, 9.4600134503E-01],
	[3.3920000000E+04, 2.5562762662E+01, 4.9819393661E+00, 9.9427638952E+00, 2.9375468496E+00, 9.4602709563E-01],
	[3.3925000000E+04, 2.5569149330E+01, 4.9819513769E+00, 9.9475436064E+00, 2.9380524421E+00, 9.4605283304E-01],
	[3.3930000000E+04, 2.5575536653E+01, 4.9819633861E+00, 9.9523249096E+00, 2.9385579126E+00, 9.4607855726E-01],
	[3.3935000000E+04, 2.5581924630E+01, 4.9819753935E+00, 9.9571078052E+00, 2.9390632609E+00, 9.4610426831E-01],
	[3.3940000000E+04, 2.5588313261E+01, 4.9819873992E+00, 9.9618922935E+00, 2.9395684872E+00, 9.4612996619E-01],
	[3.3945000000E+04, 2.5594702546E+01, 4.9819994031E+00, 9.9666783747E+00, 2.9400735914E+00, 9.4615565091E-01],
	[3.3950000000E+04, 2.5601092485E+01, 4.9820114053E+00, 9.9714660491E+00, 2.9405785736E+00, 9.4618132246E-01],
	[3.3955000000E+04, 2.5607483078E+01, 4.9820234057E+00, 9.9762553171E+00, 2.9410834337E+00, 9.4620698087E-01],
	[3.3960000000E+04, 2.5613874324E+01, 4.9820354044E+00, 9.9810461789E+00, 2.9415881717E+00, 9.4623262613E-01],
	[3.3965000000E+04, 2.5620266225E+01, 4.9820474014E+00, 9.9858386348E+00, 2.9420927877E+00, 9.4625825825E-01],
	[3.3970000000E+04, 2.5626658780E+01, 4.9820593966E+00, 9.9906326851E+00, 2.9425972816E+00, 9.4628387724E-01],
	[3.3975000000E+04, 2.5633051988E+01, 4.9820713901E+00, 9.9954283302E+00, 2.9431016535E+00, 9.4630948311E-01],
	[3.3980000000E+04, 2.5639445850E+01, 4.9820833819E+00, 1.0000225570E+01, 2.9436059033E+00, 9.4633507586E-01],
	[3.3985000000E+04, 2.5645845573E+01, 4.9820960691E+00, 1.0005024406E+01, 2.9441103433E+00, 9.4636065549E-01],
	[3.3990000000E+04, 2.5652260005E+01, 4.9821106356E+00, 1.0009824837E+01, 2.9446155036E+00, 9.4638622202E-01],
	[3.3995000000E+04, 2.5658675098E+01, 4.9821252000E+00, 1.0014626863E+01, 2.9451205424E+00, 9.4641177545E-01],
	[3.4000000000E+04, 2.5665090850E+01, 4.9821397622E+00, 1.0019430486E+01, 2.9456254597E+00, 9.4643731578E-01],
	[3.4005000000E+04, 2.5671507264E+01, 4.9821543224E+00, 1.0024235706E+01, 2.9461302554E+00, 9.4646284303E-01],
	[3.4010000000E+04, 2.5677924337E+01, 4.9821688804E+00, 1.0029042522E+01, 2.9466349297E+00, 9.4648835720E-01],
	[3.4015000000E+04, 2.5684342072E+01, 4.9821834364E+00, 1.0033850936E+01, 2.9471394825E+00, 9.4651385829E-01],
	[3.4020000000E+04, 2.5690760466E+01, 4.9821979903E+00, 1.0038660946E+01, 2.9476439137E+00, 9.4653934632E-01],
	[3.4025000000E+04, 2.5697179521E+01, 4.9822125420E+00, 1.0043472555E+01, 2.9481482235E+00, 9.4656482128E-01],
	[3.4030000000E+04, 2.5703599236E+01, 4.9822270917E+00, 1.0048285761E+01, 2.9486524118E+00, 9.4659028319E-01],
	[3.4035000000E+04, 2.5710019611E+01, 4.9822416393E+00, 1.0053100566E+01, 2.9491564786E+00, 9.4661573206E-01],
	[3.4040000000E+04, 2.5716440647E+01, 4.9822561848E+00, 1.0057916969E+01, 2.9496604240E+00, 9.4664116788E-01],
	[3.4045000000E+04, 2.5722862342E+01, 4.9822707281E+00, 1.0062734971E+01, 2.9501642479E+00, 9.4666659066E-01],
	[3.4050000000E+04, 2.5729284698E+01, 4.9822852694E+00, 1.0067554572E+01, 2.9506679503E+00, 9.4669200042E-01],
	[3.4055000000E+04, 2.5735707714E+01, 4.9822998086E+00, 1.0072375773E+01, 2.9511715313E+00, 9.4671739715E-01],
	[3.4060000000E+04, 2.5742131390E+01, 4.9823143458E+00, 1.0077198573E+01, 2.9516749908E+00, 9.4674278087E-01],
	[3.4065000000E+04, 2.5748555727E+01, 4.9823288808E+00, 1.0082022973E+01, 2.9521783289E+00, 9.4676815158E-01],
	[3.4070000000E+04, 2.5754980723E+01, 4.9823434137E+00, 1.0086848974E+01, 2.9526815455E+00, 9.4679350929E-01],
	[3.4075000000E+04, 2.5761406379E+01, 4.9823579445E+00, 1.0091676575E+01, 2.9531846408E+00, 9.4681885400E-01],
	[3.4080000000E+04, 2.5767832696E+01, 4.9823724733E+00, 1.0096505777E+01, 2.9536876146E+00, 9.4684418571E-01],
	[3.4085000000E+04, 2.5774259672E+01, 4.9823870000E+00, 1.0101336581E+01, 2.9541904670E+00, 9.4686950445E-01],
	[3.4090000000E+04, 2.5780687308E+01, 4.9824015245E+00, 1.0106168986E+01, 2.9546931980E+00, 9.4689481021E-01],
	[3.4095000000E+04, 2.5787115604E+01, 4.9824160470E+00, 1.0111002993E+01, 2.9551958076E+00, 9.4692010299E-01],
	[3.4100000000E+04, 2.5793544560E+01, 4.9824305674E+00, 1.0115838601E+01, 2.9556982958E+00, 9.4694538282E-01],
	[3.4105000000E+04, 2.5799974176E+01, 4.9824450857E+00, 1.0120675813E+01, 2.9562006626E+00, 9.4697064968E-01],
	[3.4110000000E+04, 2.5806404452E+01, 4.9824596019E+00, 1.0125514627E+01, 2.9567029080E+00, 9.4699590359E-01],
	[3.4115000000E+04, 2.5812835387E+01, 4.9824741161E+00, 1.0130355043E+01, 2.9572050321E+00, 9.4702114456E-01],
	[3.4120000000E+04, 2.5819266982E+01, 4.9824886281E+00, 1.0135197064E+01, 2.9577070348E+00, 9.4704637259E-01],
	[3.4125000000E+04, 2.5825699237E+01, 4.9825031381E+00, 1.0140040687E+01, 2.9582089161E+00, 9.4707158768E-01],
	[3.4130000000E+04, 2.5832132152E+01, 4.9825176460E+00, 1.0144885915E+01, 2.9587106761E+00, 9.4709678985E-01],
	[3.4135000000E+04, 2.5838565726E+01, 4.9825321518E+00, 1.0149732747E+01, 2.9592123147E+00, 9.4712197910E-01],
	[3.4140000000E+04, 2.5844999960E+01, 4.9825466555E+00, 1.0154581183E+01, 2.9597138320E+00, 9.4714715544E-01],
	[3.4145000000E+04, 2.5851434854E+01, 4.9825611572E+00, 1.0159431224E+01, 2.9602152280E+00, 9.4717231887E-01],
	[3.4150000000E+04, 2.5857870407E+01, 4.9825756567E+00, 1.0164282870E+01, 2.9607165026E+00, 9.4719746940E-01],
	[3.4155000000E+04, 2.5864306620E+01, 4.9825901542E+00, 1.0169136122E+01, 2.9612176559E+00, 9.4722260704E-01],
	[3.4160000000E+04, 2.5870743492E+01, 4.9826046496E+00, 1.0173990979E+01, 2.9617186879E+00, 9.4724773179E-01],
	[3.4165000000E+04, 2.5877181024E+01, 4.9826191429E+00, 1.0178847442E+01, 2.9622195986E+00, 9.4727284366E-01],
	[3.4170000000E+04, 2.5883619215E+01, 4.9826336341E+00, 1.0183705511E+01, 2.9627203880E+00, 9.4729794265E-01],
	[3.4175000000E+04, 2.5890058066E+01, 4.9826481233E+00, 1.0188565187E+01, 2.9632210561E+00, 9.4732302878E-01],
	[3.4180000000E+04, 2.5896497576E+01, 4.9826626104E+00, 1.0193426469E+01, 2.9637216029E+00, 9.4734810204E-01],
	[3.4185000000E+04, 2.5902937745E+01, 4.9826770954E+00, 1.0198289359E+01, 2.9642220284E+00, 9.4737316245E-01],
	[3.4190000000E+04, 2.5909378574E+01, 4.9826915783E+00, 1.0203153856E+01, 2.9647223327E+00, 9.4739821001E-01],
	[3.4195000000E+04, 2.5915820063E+01, 4.9827060592E+00, 1.0208019961E+01, 2.9652225156E+00, 9.4742324473E-01],
	[3.4200000000E+04, 2.5922262210E+01, 4.9827205380E+00, 1.0212887674E+01, 2.9657225774E+00, 9.4744826661E-01],
	[3.4205000000E+04, 2.5928705017E+01, 4.9827350147E+00, 1.0217756995E+01, 2.9662225179E+00, 9.4747327567E-01],
	[3.4210000000E+04, 2.5935148483E+01, 4.9827494893E+00, 1.0222627925E+01, 2.9667223371E+00, 9.4749827190E-01],
	[3.4215000000E+04, 2.5941592608E+01, 4.9827639619E+00, 1.0227500463E+01, 2.9672220351E+00, 9.4752325531E-01],
	[3.4220000000E+04, 2.5948037392E+01, 4.9827784323E+00, 1.0232374611E+01, 2.9677216119E+00, 9.4754822591E-01],
	[3.4225000000E+04, 2.5954482836E+01, 4.9827929008E+00, 1.0237250369E+01, 2.9682210674E+00, 9.4757318372E-01],
	[3.4230000000E+04, 2.5960928939E+01, 4.9828073671E+00, 1.0242127736E+01, 2.9687204018E+00, 9.4759812872E-01],
	[3.4235000000E+04, 2.5967375700E+01, 4.9828218314E+00, 1.0247006713E+01, 2.9692196149E+00, 9.4762306093E-01],
	[3.4240000000E+04, 2.5973823121E+01, 4.9828362936E+00, 1.0251887300E+01, 2.9697187068E+00, 9.4764798036E-01],
	[3.4245000000E+04, 2.5980271201E+01, 4.9828507537E+00, 1.0256769499E+01, 2.9702176776E+00, 9.4767288701E-01],
	[3.4250000000E+04, 2.5986719940E+01, 4.9828652118E+00, 1.0261653308E+01, 2.9707165271E+00, 9.4769778089E-01],
	[3.4255000000E+04, 2.5993169338E+01, 4.9828796677E+00, 1.0266538729E+01, 2.9712152555E+00, 9.4772266200E-01],
	[3.4260000000E+04, 2.5999619395E+01, 4.9828941217E+00, 1.0271425761E+01, 2.9717138627E+00, 9.4774753036E-01],
	[3.4265000000E+04, 2.6006070110E+01, 4.9829085735E+00, 1.0276314404E+01, 2.9722123487E+00, 9.4777238596E-01],
	[3.4270000000E+04, 2.6012521485E+01, 4.9829230233E+00, 1.0281204661E+01, 2.9727107136E+00, 9.4779722882E-01],
	[3.4275000000E+04, 2.6018973519E+01, 4.9829374710E+00, 1.0286096529E+01, 2.9732089573E+00, 9.4782205894E-01],
	[3.4280000000E+04, 2.6025426211E+01, 4.9829519167E+00, 1.0290990010E+01, 2.9737070799E+00, 9.4784687632E-01],
	[3.4285000000E+04, 2.6031879562E+01, 4.9829663603E+00, 1.0295885105E+01, 2.9742050814E+00, 9.4787168098E-01],
	[3.4290000000E+04, 2.6038333572E+01, 4.9829808018E+00, 1.0300781812E+01, 2.9747029617E+00, 9.4789647292E-01],
	[3.4295000000E+04, 2.6044788241E+01, 4.9829952413E+00, 1.0305680134E+01, 2.9752007209E+00, 9.4792125214E-01],
	[3.4300000000E+04, 2.6051243568E+01, 4.9830096787E+00, 1.0310580069E+01, 2.9756983590E+00, 9.4794601866E-01],
	[3.4305000000E+04, 2.6057699554E+01, 4.9830241140E+00, 1.0315481618E+01, 2.9761958760E+00, 9.4797077248E-01],
	[3.4310000000E+04, 2.6064156199E+01, 4.9830385473E+00, 1.0320384782E+01, 2.9766932719E+00, 9.4799551360E-01],
	[3.4315000000E+04, 2.6070613502E+01, 4.9830529785E+00, 1.0325289561E+01, 2.9771905467E+00, 9.4802024204E-01],
	[3.4320000000E+04, 2.6077071464E+01, 4.9830674077E+00, 1.0330195955E+01, 2.9776877005E+00, 9.4804495779E-01],
	[3.4325000000E+04, 2.6083530085E+01, 4.9830818348E+00, 1.0335103964E+01, 2.9781847331E+00, 9.4806966087E-01],
	[3.4330000000E+04, 2.6089989364E+01, 4.9830962598E+00, 1.0340013589E+01, 2.9786816447E+00, 9.4809435128E-01],
	[3.4335000000E+04, 2.6096449302E+01, 4.9831106828E+00, 1.0344924830E+01, 2.9791784353E+00, 9.4811902903E-01],
	[3.4340000000E+04, 2.6102909898E+01, 4.9831251037E+00, 1.0349837687E+01, 2.9796751048E+00, 9.4814369412E-01],
	[3.4345000000E+04, 2.6109371153E+01, 4.9831395226E+00, 1.0354752161E+01, 2.9801716532E+00, 9.4816834656E-01],
	[3.4350000000E+04, 2.6115833066E+01, 4.9831539394E+00, 1.0359668252E+01, 2.9806680806E+00, 9.4819298636E-01],
	[3.4355000000E+04, 2.6122295637E+01, 4.9831683541E+00, 1.0364585960E+01, 2.9811643870E+00, 9.4821761353E-01],
	[3.4360000000E+04, 2.6128758867E+01, 4.9831827668E+00, 1.0369505285E+01, 2.9816605724E+00, 9.4824222806E-01],
	[3.4365000000E+04, 2.6135222755E+01, 4.9831971774E+00, 1.0374426229E+01, 2.9821566368E+00, 9.4826682997E-01],
	[3.4370000000E+04, 2.6141687302E+01, 4.9832115860E+00, 1.0379348790E+01, 2.9826525801E+00, 9.4829141927E-01],
	[3.4375000000E+04, 2.6148152506E+01, 4.9832259925E+00, 1.0384272970E+01, 2.9831484025E+00, 9.4831599595E-01],
	[3.4380000000E+04, 2.6154618369E+01, 4.9832403970E+00, 1.0389198768E+01, 2.9836441039E+00, 9.4834056003E-01],
	[3.4385000000E+04, 2.6161084891E+01, 4.9832547994E+00, 1.0394126185E+01, 2.9841396843E+00, 9.4836511151E-01],
	[3.4390000000E+04, 2.6167552070E+01, 4.9832691998E+00, 1.0399055222E+01, 2.9846351438E+00, 9.4838965040E-01],
	[3.4395000000E+04, 2.6174019908E+01, 4.9832835981E+00, 1.0403985878E+01, 2.9851304822E+00, 9.4841417670E-01],
	[3.4400000000E+04, 2.6180488404E+01, 4.9832979944E+00, 1.0408918154E+01, 2.9856256998E+00, 9.4843869043E-01],
	[3.4405000000E+04, 2.6186957558E+01, 4.9833123886E+00, 1.0413852050E+01, 2.9861207964E+00, 9.4846319158E-01],
	[3.4410000000E+04, 2.6193427370E+01, 4.9833267807E+00, 1.0418787566E+01, 2.9866157720E+00, 9.4848768017E-01],
	[3.4415000000E+04, 2.6199897840E+01, 4.9833411708E+00, 1.0423724704E+01, 2.9871106267E+00, 9.4851215620E-01],
	[3.4420000000E+04, 2.6206368968E+01, 4.9833555589E+00, 1.0428663462E+01, 2.9876053605E+00, 9.4853661967E-01],
	[3.4425000000E+04, 2.6212840754E+01, 4.9833699449E+00, 1.0433603842E+01, 2.9880999734E+00, 9.4856107060E-01],
	[3.4430000000E+04, 2.6219313198E+01, 4.9833843289E+00, 1.0438545843E+01, 2.9885944654E+00, 9.4858550899E-01],
	[3.4435000000E+04, 2.6225786300E+01, 4.9833987108E+00, 1.0443489466E+01, 2.9890888365E+00, 9.4860993484E-01],
	[3.4440000000E+04, 2.6232260060E+01, 4.9834130907E+00, 1.0448434712E+01, 2.9895830867E+00, 9.4863434817E-01],
	[3.4445000000E+04, 2.6238734478E+01, 4.9834274685E+00, 1.0453381580E+01, 2.9900772160E+00, 9.4865874898E-01],
	[3.4450000000E+04, 2.6245209553E+01, 4.9834418443E+00, 1.0458330070E+01, 2.9905712245E+00, 9.4868313727E-01],
	[3.4455000000E+04, 2.6251685287E+01, 4.9834562180E+00, 1.0463280184E+01, 2.9910651121E+00, 9.4870751306E-01],
	[3.4460000000E+04, 2.6258161678E+01, 4.9834705897E+00, 1.0468231921E+01, 2.9915588788E+00, 9.4873187634E-01],
	[3.4465000000E+04, 2.6264638727E+01, 4.9834849594E+00, 1.0473185282E+01, 2.9920525248E+00, 9.4875622713E-01],
	[3.4470000000E+04, 2.6271116434E+01, 4.9834993270E+00, 1.0478140267E+01, 2.9925460498E+00, 9.4878056543E-01],
	[3.4475000000E+04, 2.6277594799E+01, 4.9835136925E+00, 1.0483096877E+01, 2.9930394541E+00, 9.4880489125E-01],
	[3.4480000000E+04, 2.6284073821E+01, 4.9835280561E+00, 1.0488055110E+01, 2.9935327375E+00, 9.4882920459E-01],
	[3.4485000000E+04, 2.6290553501E+01, 4.9835424175E+00, 1.0493014969E+01, 2.9940259001E+00, 9.4885350546E-01],
	[3.4490000000E+04, 2.6297033839E+01, 4.9835567770E+00, 1.0497976453E+01, 2.9945189419E+00, 9.4887779387E-01],
	[3.4495000000E+04, 2.6303514834E+01, 4.9835711344E+00, 1.0502939563E+01, 2.9950118629E+00, 9.4890206983E-01],
	[3.4500000000E+04, 2.6309996486E+01, 4.9835854897E+00, 1.0507904298E+01, 2.9955046632E+00, 9.4892633333E-01],
	[3.4505000000E+04, 2.6316478797E+01, 4.9835998431E+00, 1.0512870659E+01, 2.9959973426E+00, 9.4895058439E-01],
	[3.4510000000E+04, 2.6322961764E+01, 4.9836141943E+00, 1.0517838647E+01, 2.9964899013E+00, 9.4897482301E-01],
	[3.4515000000E+04, 2.6329445390E+01, 4.9836285436E+00, 1.0522808261E+01, 2.9969823393E+00, 9.4899904920E-01],
	[3.4520000000E+04, 2.6335929672E+01, 4.9836428908E+00, 1.0527779502E+01, 2.9974746565E+00, 9.4902326296E-01],
	[3.4525000000E+04, 2.6342414613E+01, 4.9836572360E+00, 1.0532752371E+01, 2.9979668529E+00, 9.4904746431E-01],
	[3.4530000000E+04, 2.6348900210E+01, 4.9836715791E+00, 1.0537726867E+01, 2.9984589286E+00, 9.4907165325E-01],
	[3.4535000000E+04, 2.6355402667E+01, 4.9836880733E+00, 1.0542702991E+01, 2.9989518731E+00, 9.4909582978E-01],
	[3.4540000000E+04, 2.6361908595E+01, 4.9837049383E+00, 1.0547680743E+01, 2.9994448687E+00, 9.4911999391E-01],
	[3.4545000000E+04, 2.6368415187E+01, 4.9837218008E+00, 1.0552660123E+01, 2.9999377441E+00, 9.4914414565E-01],
	[3.4550000000E+04, 2.6374922443E+01, 4.9837386610E+00, 1.0557641133E+01, 3.0004304992E+00, 9.4916828500E-01],
	[3.4555000000E+04, 2.6381430363E+01, 4.9837555188E+00, 1.0562623771E+01, 3.0009231342E+00, 9.4919241198E-01],
	[3.4560000000E+04, 2.6387938947E+01, 4.9837723743E+00, 1.0567608039E+01, 3.0014156489E+00, 9.4921652658E-01],
	[3.4565000000E+04, 2.6394448194E+01, 4.9837892273E+00, 1.0572593936E+01, 3.0019080434E+00, 9.4924062881E-01],
	[3.4570000000E+04, 2.6400958106E+01, 4.9838060780E+00, 1.0577581463E+01, 3.0024003177E+00, 9.4926471869E-01],
	[3.4575000000E+04, 2.6407468681E+01, 4.9838229263E+00, 1.0582570620E+01, 3.0028924719E+00, 9.4928879620E-01],
	[3.4580000000E+04, 2.6413979920E+01, 4.9838397722E+00, 1.0587561408E+01, 3.0033845059E+00, 9.4931286138E-01],
	[3.4585000000E+04, 2.6420491822E+01, 4.9838566157E+00, 1.0592553827E+01, 3.0038764197E+00, 9.4933691421E-01],
	[3.4590000000E+04, 2.6427004388E+01, 4.9838734568E+00, 1.0597547877E+01, 3.0043682133E+00, 9.4936095470E-01],
	[3.4595000000E+04, 2.6433517618E+01, 4.9838902956E+00, 1.0602543558E+01, 3.0048598868E+00, 9.4938498287E-01],
	[3.4600000000E+04, 2.6440031512E+01, 4.9839071320E+00, 1.0607540871E+01, 3.0053514402E+00, 9.4940899871E-01],
	[3.4605000000E+04, 2.6446546069E+01, 4.9839239660E+00, 1.0612539816E+01, 3.0058428734E+00, 9.4943300224E-01],
	[3.4610000000E+04, 2.6453061290E+01, 4.9839407977E+00, 1.0617540394E+01, 3.0063341865E+00, 9.4945699346E-01],
	[3.4615000000E+04, 2.6459577174E+01, 4.9839576269E+00, 1.0622542604E+01, 3.0068253795E+00, 9.4948097238E-01],
	[3.4620000000E+04, 2.6466093721E+01, 4.9839744538E+00, 1.0627546446E+01, 3.0073164524E+00, 9.4950493900E-01],
	[3.4625000000E+04, 2.6472610933E+01, 4.9839912783E+00, 1.0632551922E+01, 3.0078074052E+00, 9.4952889333E-01],
	[3.4630000000E+04, 2.6479128807E+01, 4.9840081005E+00, 1.0637559032E+01, 3.0082982379E+00, 9.4955283538E-01],
	[3.4635000000E+04, 2.6485647345E+01, 4.9840249203E+00, 1.0642567775E+01, 3.0087889505E+00, 9.4957676515E-01],
	[3.4640000000E+04, 2.6492166547E+01, 4.9840417377E+00, 1.0647578152E+01, 3.0092795431E+00, 9.4960068264E-01],
	[3.4645000000E+04, 2.6498686412E+01, 4.9840585527E+00, 1.0652590164E+01, 3.0097700156E+00, 9.4962458788E-01],
	[3.4650000000E+04, 2.6505206940E+01, 4.9840753654E+00, 1.0657603811E+01, 3.0102603681E+00, 9.4964848085E-01],
	[3.4655000000E+04, 2.6511728131E+01, 4.9840921757E+00, 1.0662619092E+01, 3.0107506005E+00, 9.4967236158E-01],
	[3.4660000000E+04, 2.6518249986E+01, 4.9841089836E+00, 1.0667636009E+01, 3.0112407129E+00, 9.4969623006E-01],
	[3.4665000000E+04, 2.6524772504E+01, 4.9841257892E+00, 1.0672654561E+01, 3.0117307053E+00, 9.4972008630E-01],
	[3.4670000000E+04, 2.6531295685E+01, 4.9841425923E+00, 1.0677674749E+01, 3.0122205777E+00, 9.4974393030E-01],
	[3.4675000000E+04, 2.6537819530E+01, 4.9841593932E+00, 1.0682696573E+01, 3.0127103300E+00, 9.4976776209E-01],
	[3.4680000000E+04, 2.6544344037E+01, 4.9841761916E+00, 1.0687720034E+01, 3.0131999624E+00, 9.4979158165E-01],
	[3.4685000000E+04, 2.6550869208E+01, 4.9841929877E+00, 1.0692745131E+01, 3.0136894748E+00, 9.4981538900E-01],
	[3.4690000000E+04, 2.6557395042E+01, 4.9842097815E+00, 1.0697771866E+01, 3.0141788672E+00, 9.4983918414E-01],
	[3.4695000000E+04, 2.6563921539E+01, 4.9842265728E+00, 1.0702800238E+01, 3.0146681397E+00, 9.4986296708E-01],
	[3.4700000000E+04, 2.6570448699E+01, 4.9842433618E+00, 1.0707830247E+01, 3.0151572922E+00, 9.4988673782E-01],
	[3.4705000000E+04, 2.6576976522E+01, 4.9842601485E+00, 1.0712861894E+01, 3.0156463247E+00, 9.4991049638E-01],
	[3.4710000000E+04, 2.6583505008E+01, 4.9842769327E+00, 1.0717895180E+01, 3.0161352374E+00, 9.4993424276E-01],
	[3.4715000000E+04, 2.6590034157E+01, 4.9842937147E+00, 1.0722930104E+01, 3.0166240301E+00, 9.4995797696E-01],
	[3.4720000000E+04, 2.6596563969E+01, 4.9843104942E+00, 1.0727966667E+01, 3.0171127028E+00, 9.4998169899E-01],
	[3.4725000000E+04, 2.6603094444E+01, 4.9843272714E+00, 1.0733004869E+01, 3.0176012557E+00, 9.5000540887E-01],
	[3.4730000000E+04, 2.6609625582E+01, 4.9843440463E+00, 1.0738044711E+01, 3.0180896887E+00, 9.5002910658E-01],
	[3.4735000000E+04, 2.6616157383E+01, 4.9843608187E+00, 1.0743086192E+01, 3.0185780018E+00, 9.5005279215E-01],
	[3.4740000000E+04, 2.6622689846E+01, 4.9843775889E+00, 1.0748129314E+01, 3.0190661950E+00, 9.5007646557E-01],
	[3.4745000000E+04, 2.6629222972E+01, 4.9843943566E+00, 1.0753174075E+01, 3.0195542683E+00, 9.5010012685E-01],
	[3.4750000000E+04, 2.6635756761E+01, 4.9844111220E+00, 1.0758220478E+01, 3.0200422218E+00, 9.5012377601E-01],
	[3.4755000000E+04, 2.6642291213E+01, 4.9844278851E+00, 1.0763268521E+01, 3.0205300555E+00, 9.5014741304E-01],
	[3.4760000000E+04, 2.6648826328E+01, 4.9844446458E+00, 1.0768318205E+01, 3.0210177693E+00, 9.5017103795E-01],
	[3.4765000000E+04, 2.6655362105E+01, 4.9844614041E+00, 1.0773369531E+01, 3.0215053633E+00, 9.5019465075E-01],
	[3.4770000000E+04, 2.6661898545E+01, 4.9844781601E+00, 1.0778422499E+01, 3.0219928374E+00, 9.5021825145E-01],
	[3.4775000000E+04, 2.6668435647E+01, 4.9844949138E+00, 1.0783477108E+01, 3.0224801918E+00, 9.5024184005E-01],
	[3.4780000000E+04, 2.6674973413E+01, 4.9845116650E+00, 1.0788533361E+01, 3.0229674263E+00, 9.5026541655E-01],
	[3.4785000000E+04, 2.6681511840E+01, 4.9845284140E+00, 1.0793591255E+01, 3.0234545411E+00, 9.5028898097E-01],
	[3.4790000000E+04, 2.6688050931E+01, 4.9845451606E+00, 1.0798650793E+01, 3.0239415360E+00, 9.5031253332E-01],
	[3.4795000000E+04, 2.6694590683E+01, 4.9845619048E+00, 1.0803711974E+01, 3.0244284113E+00, 9.5033607358E-01],
	[3.4800000000E+04, 2.6701131099E+01, 4.9845786467E+00, 1.0808774799E+01, 3.0249151667E+00, 9.5035960178E-01],
	[3.4805000000E+04, 2.6707672176E+01, 4.9845953862E+00, 1.0813839268E+01, 3.0254018024E+00, 9.5038311792E-01],
	[3.4810000000E+04, 2.6714213917E+01, 4.9846121234E+00, 1.0818905380E+01, 3.0258883184E+00, 9.5040662201E-01],
	[3.4815000000E+04, 2.6720756319E+01, 4.9846288582E+00, 1.0823973138E+01, 3.0263747146E+00, 9.5043011405E-01],
	[3.4820000000E+04, 2.6727299384E+01, 4.9846455907E+00, 1.0829042540E+01, 3.0268609911E+00, 9.5045359405E-01],
	[3.4825000000E+04, 2.6733843112E+01, 4.9846623209E+00, 1.0834113587E+01, 3.0273471480E+00, 9.5047706201E-01],
	[3.4830000000E+04, 2.6740387501E+01, 4.9846790487E+00, 1.0839186279E+01, 3.0278331851E+00, 9.5050051794E-01],
	[3.4835000000E+04, 2.6746932553E+01, 4.9846957741E+00, 1.0844260617E+01, 3.0283191025E+00, 9.5052396185E-01],
	[3.4840000000E+04, 2.6753478267E+01, 4.9847124972E+00, 1.0849336601E+01, 3.0288049002E+00, 9.5054739375E-01],
	[3.4845000000E+04, 2.6760024644E+01, 4.9847292180E+00, 1.0854414232E+01, 3.0292905783E+00, 9.5057081364E-01],
	[3.4850000000E+04, 2.6766571683E+01, 4.9847459364E+00, 1.0859493509E+01, 3.0297761368E+00, 9.5059422152E-01],
	[3.4855000000E+04, 2.6773119384E+01, 4.9847626525E+00, 1.0864574432E+01, 3.0302615755E+00, 9.5061761740E-01],
	[3.4860000000E+04, 2.6779667747E+01, 4.9847793662E+00, 1.0869657003E+01, 3.0307468947E+00, 9.5064100130E-01],
	[3.4865000000E+04, 2.6786216772E+01, 4.9847960776E+00, 1.0874741222E+01, 3.0312320942E+00, 9.5066437321E-01],
	[3.4870000000E+04, 2.6792766459E+01, 4.9848127867E+00, 1.0879827088E+01, 3.0317171741E+00, 9.5068773314E-01],
	[3.4875000000E+04, 2.6799316808E+01, 4.9848294934E+00, 1.0884914602E+01, 3.0322021344E+00, 9.5071108111E-01],
	[3.4880000000E+04, 2.6805867820E+01, 4.9848461978E+00, 1.0890003764E+01, 3.0326869751E+00, 9.5073441710E-01],
	[3.4885000000E+04, 2.6812419493E+01, 4.9848628998E+00, 1.0895094575E+01, 3.0331716962E+00, 9.5075774114E-01],
	[3.4890000000E+04, 2.6818971829E+01, 4.9848795995E+00, 1.0900187035E+01, 3.0336562977E+00, 9.5078105323E-01],
	[3.4895000000E+04, 2.6825524826E+01, 4.9848962969E+00, 1.0905281145E+01, 3.0341407797E+00, 9.5080435337E-01],
	[3.4900000000E+04, 2.6832078485E+01, 4.9849129919E+00, 1.0910376903E+01, 3.0346251421E+00, 9.5082764157E-01],
	[3.4905000000E+04, 2.6838632807E+01, 4.9849296846E+00, 1.0915474312E+01, 3.0351093850E+00, 9.5085091783E-01],
	[3.4910000000E+04, 2.6845187790E+01, 4.9849463749E+00, 1.0920573371E+01, 3.0355935083E+00, 9.5087418217E-01],
	[3.4915000000E+04, 2.6851743435E+01, 4.9849630630E+00, 1.0925674080E+01, 3.0360775121E+00, 9.5089743459E-01],
	[3.4920000000E+04, 2.6858299742E+01, 4.9849797487E+00, 1.0930776440E+01, 3.0365613964E+00, 9.5092067510E-01],
	[3.4925000000E+04, 2.6864856710E+01, 4.9849964320E+00, 1.0935880451E+01, 3.0370451612E+00, 9.5094390369E-01],
	[3.4930000000E+04, 2.6871414341E+01, 4.9850131130E+00, 1.0940986113E+01, 3.0375288066E+00, 9.5096712039E-01],
	[3.4935000000E+04, 2.6877972633E+01, 4.9850297917E+00, 1.0946093427E+01, 3.0380123324E+00, 9.5099032519E-01],
	[3.4940000000E+04, 2.6884531586E+01, 4.9850464681E+00, 1.0951202392E+01, 3.0384957388E+00, 9.5101351810E-01],
	[3.4945000000E+04, 2.6891091202E+01, 4.9850631421E+00, 1.0956313010E+01, 3.0389790257E+00, 9.5103669913E-01],
	[3.4950000000E+04, 2.6897651479E+01, 4.9850798138E+00, 1.0961425281E+01, 3.0394621931E+00, 9.5105986828E-01],
	[3.4955000000E+04, 2.6904212418E+01, 4.9850964832E+00, 1.0966539204E+01, 3.0399452412E+00, 9.5108302556E-01],
	[3.4960000000E+04, 2.6910774018E+01, 4.9851131502E+00, 1.0971654780E+01, 3.0404281698E+00, 9.5110617098E-01],
	[3.4965000000E+04, 2.6917336280E+01, 4.9851298149E+00, 1.0976772010E+01, 3.0409109789E+00, 9.5112930454E-01],
	[3.4970000000E+04, 2.6923899204E+01, 4.9851464773E+00, 1.0981890893E+01, 3.0413936687E+00, 9.5115242625E-01],
	[3.4975000000E+04, 2.6930462789E+01, 4.9851631374E+00, 1.0987011431E+01, 3.0418762391E+00, 9.5117553611E-01],
	[3.4980000000E+04, 2.6937027035E+01, 4.9851797951E+00, 1.0992133622E+01, 3.0423586901E+00, 9.5119863414E-01],
	[3.4985000000E+04, 2.6943591943E+01, 4.9851964505E+00, 1.0997257469E+01, 3.0428410218E+00, 9.5122172033E-01],
	[3.4990000000E+04, 2.6950157512E+01, 4.9852131036E+00, 1.1002382970E+01, 3.0433232340E+00, 9.5124479470E-01],
	[3.4995000000E+04, 2.6956723743E+01, 4.9852297544E+00, 1.1007510126E+01, 3.0438053269E+00, 9.5126785725E-01],
	[3.5000000000E+04, 2.6963290635E+01, 4.9852464028E+00, 1.1012638938E+01, 3.0442873005E+00, 9.5129090798E-01],
	[3.5005000000E+04, 2.6969858189E+01, 4.9852630489E+00, 1.1017774688E+01, 3.0447695582E+00, 9.5131394691E-01],
	[3.5010000000E+04, 2.6976426404E+01, 4.9852796927E+00, 1.1022912098E+01, 3.0452516964E+00, 9.5133697404E-01],
	[3.5015000000E+04, 2.6982995280E+01, 4.9852963342E+00, 1.1028051169E+01, 3.0457337151E+00, 9.5135998937E-01],
	[3.5020000000E+04, 2.6989564817E+01, 4.9853129733E+00, 1.1033191901E+01, 3.0462156144E+00, 9.5138299292E-01],
	[3.5025000000E+04, 2.6996135016E+01, 4.9853296102E+00, 1.1038334294E+01, 3.0466973942E+00, 9.5140598468E-01],
	[3.5030000000E+04, 2.7002705876E+01, 4.9853462447E+00, 1.1043478349E+01, 3.0471790545E+00, 9.5142896467E-01],
	[3.5035000000E+04, 2.7009277397E+01, 4.9853628769E+00, 1.1048624065E+01, 3.0476605954E+00, 9.5145193289E-01],
	[3.5040000000E+04, 2.7015849579E+01, 4.9853795068E+00, 1.1053771444E+01, 3.0481420169E+00, 9.5147488935E-01],
	[3.5045000000E+04, 2.7022422422E+01, 4.9853961343E+00, 1.1058920485E+01, 3.0486233189E+00, 9.5149783405E-01],
	[3.5050000000E+04, 2.7028995927E+01, 4.9854127596E+00, 1.1064071188E+01, 3.0491045016E+00, 9.5152076700E-01],
	[3.5055000000E+04, 2.7035570092E+01, 4.9854293825E+00, 1.1069223555E+01, 3.0495855649E+00, 9.5154368821E-01],
	[3.5060000000E+04, 2.7042144919E+01, 4.9854460031E+00, 1.1074377584E+01, 3.0500665088E+00, 9.5156659768E-01],
	[3.5065000000E+04, 2.7048720406E+01, 4.9854626214E+00, 1.1079533278E+01, 3.0505473333E+00, 9.5158949542E-01],
	[3.5070000000E+04, 2.7055296555E+01, 4.9854792374E+00, 1.1084690635E+01, 3.0510280384E+00, 9.5161238143E-01],
	[3.5075000000E+04, 2.7061873364E+01, 4.9854958510E+00, 1.1089849656E+01, 3.0515086243E+00, 9.5163525573E-01],
	[3.5080000000E+04, 2.7068450834E+01, 4.9855124624E+00, 1.1095010342E+01, 3.0519890907E+00, 9.5165811831E-01],
	[3.5085000000E+04, 2.7075028966E+01, 4.9855290714E+00, 1.1100172693E+01, 3.0524694379E+00, 9.5168096919E-01],
	[3.5090000000E+04, 2.7081620385E+01, 4.9855473428E+00, 1.1105336709E+01, 3.0529504504E+00, 9.5170380836E-01],
	[3.5095000000E+04, 2.7088218614E+01, 4.9855664214E+00, 1.1110502390E+01, 3.0534317258E+00, 9.5172663585E-01],
	[3.5100000000E+04, 2.7094817510E+01, 4.9855854973E+00, 1.1115669737E+01, 3.0539128823E+00, 9.5174945164E-01],
	[3.5105000000E+04, 2.7101417073E+01, 4.9856045706E+00, 1.1120838749E+01, 3.0543939199E+00, 9.5177225576E-01],
	[3.5110000000E+04, 2.7108017304E+01, 4.9856236412E+00, 1.1126009428E+01, 3.0548748387E+00, 9.5179504820E-01],
	[3.5115000000E+04, 2.7114618201E+01, 4.9856427092E+00, 1.1131181774E+01, 3.0553556388E+00, 9.5181782898E-01],
	[3.5120000000E+04, 2.7121219766E+01, 4.9856617746E+00, 1.1136355786E+01, 3.0558363200E+00, 9.5184059809E-01],
	[3.5125000000E+04, 2.7127821998E+01, 4.9856808373E+00, 1.1141531466E+01, 3.0563168824E+00, 9.5186335554E-01],
	[3.5130000000E+04, 2.7134424897E+01, 4.9856998974E+00, 1.1146708813E+01, 3.0567973261E+00, 9.5188610135E-01],
	[3.5135000000E+04, 2.7141028463E+01, 4.9857189548E+00, 1.1151887828E+01, 3.0572776510E+00, 9.5190883551E-01],
	[3.5140000000E+04, 2.7147632696E+01, 4.9857380096E+00, 1.1157068511E+01, 3.0577578571E+00, 9.5193155804E-01],
	[3.5145000000E+04, 2.7154237597E+01, 4.9857570617E+00, 1.1162250862E+01, 3.0582379445E+00, 9.5195426893E-01],
	[3.5150000000E+04, 2.7160843164E+01, 4.9857761113E+00, 1.1167434882E+01, 3.0587179132E+00, 9.5197696821E-01],
	[3.5155000000E+04, 2.7167449398E+01, 4.9857951581E+00, 1.1172620571E+01, 3.0591977632E+00, 9.5199965586E-01],
	[3.5160000000E+04, 2.7174056299E+01, 4.9858142024E+00, 1.1177807930E+01, 3.0596774944E+00, 9.5202233190E-01],
	[3.5165000000E+04, 2.7180663867E+01, 4.9858332440E+00, 1.1182996957E+01, 3.0601571070E+00, 9.5204499634E-01],
	[3.5170000000E+04, 2.7187272102E+01, 4.9858522830E+00, 1.1188187655E+01, 3.0606366008E+00, 9.5206764917E-01],
	[3.5175000000E+04, 2.7193881004E+01, 4.9858713193E+00, 1.1193380023E+01, 3.0611159760E+00, 9.5209029042E-01],
	[3.5180000000E+04, 2.7200490573E+01, 4.9858903530E+00, 1.1198574061E+01, 3.0615952325E+00, 9.5211292008E-01],
	[3.5185000000E+04, 2.7207100808E+01, 4.9859093841E+00, 1.1203769770E+01, 3.0620743704E+00, 9.5213553815E-01],
	[3.5190000000E+04, 2.7213711711E+01, 4.9859284125E+00, 1.1208967151E+01, 3.0625533897E+00, 9.5215814466E-01],
	[3.5195000000E+04, 2.7220323280E+01, 4.9859474384E+00, 1.1214166202E+01, 3.0630322903E+00, 9.5218073959E-01],
	[3.5200000000E+04, 2.7226935515E+01, 4.9859664615E+00, 1.1219366925E+01, 3.0635110723E+00, 9.5220332296E-01],
	[3.5205000000E+04, 2.7233548418E+01, 4.9859854821E+00, 1.1224569320E+01, 3.0639897357E+00, 9.5222589478E-01],
	[3.5210000000E+04, 2.7240161987E+01, 4.9860045000E+00, 1.1229773388E+01, 3.0644682805E+00, 9.5224845505E-01],
	[3.5215000000E+04, 2.7246776223E+01, 4.9860235153E+00, 1.1234979128E+01, 3.0649467067E+00, 9.5227100378E-01],
	[3.5220000000E+04, 2.7253391125E+01, 4.9860425280E+00, 1.1240186541E+01, 3.0654250143E+00, 9.5229354097E-01],
	[3.5225000000E+04, 2.7260006694E+01, 4.9860615380E+00, 1.1245395627E+01, 3.0659032034E+00, 9.5231606663E-01],
	[3.5230000000E+04, 2.7266622930E+01, 4.9860805455E+00, 1.1250606386E+01, 3.0663812740E+00, 9.5233858076E-01],
	[3.5235000000E+04, 2.7273239832E+01, 4.9860995503E+00, 1.1255818819E+01, 3.0668592260E+00, 9.5236108338E-01],
	[3.5240000000E+04, 2.7279857400E+01, 4.9861185524E+00, 1.1261032926E+01, 3.0673370595E+00, 9.5238357449E-01],
	[3.5245000000E+04, 2.7286475635E+01, 4.9861375520E+00, 1.1266248708E+01, 3.0678147745E+00, 9.5240605409E-01],
	[3.5250000000E+04, 2.7293094537E+01, 4.9861565489E+00, 1.1271466164E+01, 3.0682923710E+00, 9.5242852219E-01],
	[3.5255000000E+04, 2.7299714105E+01, 4.9861755432E+00, 1.1276685296E+01, 3.0687698490E+00, 9.5245097880E-01],
	[3.5260000000E+04, 2.7306334339E+01, 4.9861945349E+00, 1.1281906102E+01, 3.0692472085E+00, 9.5247342392E-01],
	[3.5265000000E+04, 2.7312955240E+01, 4.9862135239E+00, 1.1287128584E+01, 3.0697244496E+00, 9.5249585756E-01],
	[3.5270000000E+04, 2.7319576807E+01, 4.9862325104E+00, 1.1292352742E+01, 3.0702015722E+00, 9.5251827973E-01],
	[3.5275000000E+04, 2.7326199040E+01, 4.9862514942E+00, 1.1297578576E+01, 3.0706785764E+00, 9.5254069043E-01],
	[3.5280000000E+04, 2.7332821940E+01, 4.9862704754E+00, 1.1302806087E+01, 3.0711554621E+00, 9.5256308966E-01],
	[3.5285000000E+04, 2.7339445506E+01, 4.9862894540E+00, 1.1308035274E+01, 3.0716322295E+00, 9.5258547745E-01],
	[3.5290000000E+04, 2.7346069738E+01, 4.9863084300E+00, 1.1313266139E+01, 3.0721088784E+00, 9.5260785378E-01],
	[3.5295000000E+04, 2.7352694636E+01, 4.9863274033E+00, 1.1318498680E+01, 3.0725854089E+00, 9.5263021867E-01],
	[3.5300000000E+04, 2.7359320201E+01, 4.9863463740E+00, 1.1323732900E+01, 3.0730618211E+00, 9.5265257212E-01],
	[3.5305000000E+04, 2.7365946432E+01, 4.9863653422E+00, 1.1328968797E+01, 3.0735381149E+00, 9.5267491415E-01],
	[3.5310000000E+04, 2.7372573328E+01, 4.9863843077E+00, 1.1334206373E+01, 3.0740142904E+00, 9.5269724474E-01],
	[3.5315000000E+04, 2.7379200891E+01, 4.9864032706E+00, 1.1339445627E+01, 3.0744903475E+00, 9.5271956392E-01],
	[3.5320000000E+04, 2.7385829120E+01, 4.9864222308E+00, 1.1344686560E+01, 3.0749662862E+00, 9.5274187168E-01],
	[3.5325000000E+04, 2.7392458015E+01, 4.9864411885E+00, 1.1349929172E+01, 3.0754421067E+00, 9.5276416803E-01],
	[3.5330000000E+04, 2.7399087576E+01, 4.9864601436E+00, 1.1355173464E+01, 3.0759178089E+00, 9.5278645298E-01],
	[3.5335000000E+04, 2.7405717803E+01, 4.9864790960E+00, 1.1360419435E+01, 3.0763933927E+00, 9.5280872653E-01],
	[3.5340000000E+04, 2.7412348696E+01, 4.9864980459E+00, 1.1365667086E+01, 3.0768688583E+00, 9.5283098868E-01],
	[3.5345000000E+04, 2.7418980255E+01, 4.9865169931E+00, 1.1370916418E+01, 3.0773442056E+00, 9.5285323945E-01],
	[3.5350000000E+04, 2.7425612480E+01, 4.9865359377E+00, 1.1376167431E+01, 3.0778194347E+00, 9.5287547884E-01],
	[3.5355000000E+04, 2.7432245371E+01, 4.9865548797E+00, 1.1381420124E+01, 3.0782945455E+00, 9.5289770685E-01],
	[3.5360000000E+04, 2.7438878927E+01, 4.9865738191E+00, 1.1386674499E+01, 3.0787695381E+00, 9.5291992349E-01],
	[3.5365000000E+04, 2.7445513150E+01, 4.9865927559E+00, 1.1391930555E+01, 3.0792444124E+00, 9.5294212877E-01],
	[3.5370000000E+04, 2.7452148038E+01, 4.9866116901E+00, 1.1397188293E+01, 3.0797191686E+00, 9.5296432269E-01],
	[3.5375000000E+04, 2.7458783592E+01, 4.9866306217E+00, 1.1402447713E+01, 3.0801938066E+00, 9.5298650525E-01],
	[3.5380000000E+04, 2.7465419812E+01, 4.9866495507E+00, 1.1407708816E+01, 3.0806683263E+00, 9.5300867647E-01],
	[3.5385000000E+04, 2.7472056697E+01, 4.9866684771E+00, 1.1412971601E+01, 3.0811427280E+00, 9.5303083634E-01],
	[3.5390000000E+04, 2.7478694248E+01, 4.9866874009E+00, 1.1418236070E+01, 3.0816170114E+00, 9.5305298488E-01],
	[3.5395000000E+04, 2.7485332465E+01, 4.9867063221E+00, 1.1423502222E+01, 3.0820911767E+00, 9.5307512208E-01],
	[3.5400000000E+04, 2.7491971347E+01, 4.9867252406E+00, 1.1428770057E+01, 3.0825652239E+00, 9.5309724796E-01],
	[3.5405000000E+04, 2.7498610895E+01, 4.9867441566E+00, 1.1434039577E+01, 3.0830391530E+00, 9.5311936252E-01],
	[3.5410000000E+04, 2.7505251109E+01, 4.9867630700E+00, 1.1439310781E+01, 3.0835129639E+00, 9.5314146576E-01],
	[3.5415000000E+04, 2.7511891988E+01, 4.9867819808E+00, 1.1444583669E+01, 3.0839866568E+00, 9.5316355769E-01],
	[3.5420000000E+04, 2.7518533533E+01, 4.9868008890E+00, 1.1449858242E+01, 3.0844602316E+00, 9.5318563833E-01],
	[3.5425000000E+04, 2.7525175743E+01, 4.9868197946E+00, 1.1455134500E+01, 3.0849336883E+00, 9.5320770766E-01],
	[3.5430000000E+04, 2.7531818618E+01, 4.9868386975E+00, 1.1460412444E+01, 3.0854070269E+00, 9.5322976570E-01],
	[3.5435000000E+04, 2.7538462159E+01, 4.9868575979E+00, 1.1465692074E+01, 3.0858802475E+00, 9.5325181245E-01],
	[3.5440000000E+04, 2.7545106366E+01, 4.9868764957E+00, 1.1470973389E+01, 3.0863533501E+00, 9.5327384792E-01],
	[3.5445000000E+04, 2.7551751238E+01, 4.9868953909E+00, 1.1476256391E+01, 3.0868263347E+00, 9.5329587212E-01],
	[3.5450000000E+04, 2.7558396775E+01, 4.9869142836E+00, 1.1481541080E+01, 3.0872992012E+00, 9.5331788505E-01],
	[3.5455000000E+04, 2.7565042977E+01, 4.9869331736E+00, 1.1486827455E+01, 3.0877719498E+00, 9.5333988671E-01],
	[3.5460000000E+04, 2.7571689845E+01, 4.9869520610E+00, 1.1492115518E+01, 3.0882445804E+00, 9.5336187711E-01],
	[3.5465000000E+04, 2.7578337378E+01, 4.9869709458E+00, 1.1497405268E+01, 3.0887170930E+00, 9.5338385626E-01],
	[3.5470000000E+04, 2.7584985577E+01, 4.9869898281E+00, 1.1502696706E+01, 3.0891894877E+00, 9.5340582416E-01],
	[3.5475000000E+04, 2.7591634440E+01, 4.9870087077E+00, 1.1507989833E+01, 3.0896617644E+00, 9.5342778082E-01],
	[3.5480000000E+04, 2.7598283969E+01, 4.9870275848E+00, 1.1513284648E+01, 3.0901339232E+00, 9.5344972625E-01],
	[3.5485000000E+04, 2.7604934163E+01, 4.9870464593E+00, 1.1518581151E+01, 3.0906059640E+00, 9.5347166044E-01],
	[3.5490000000E+04, 2.7611585022E+01, 4.9870653312E+00, 1.1523879344E+01, 3.0910778870E+00, 9.5349358341E-01],
	[3.5495000000E+04, 2.7618236546E+01, 4.9870842005E+00, 1.1529179226E+01, 3.0915496921E+00, 9.5351549515E-01],
	[3.5500000000E+04, 2.7624888736E+01, 4.9871030672E+00, 1.1534480798E+01, 3.0920213793E+00, 9.5353739568E-01],
	[3.5505000000E+04, 2.7631541590E+01, 4.9871219313E+00, 1.1539784059E+01, 3.0924929486E+00, 9.5355928501E-01],
	[3.5510000000E+04, 2.7638195109E+01, 4.9871407928E+00, 1.1545089011E+01, 3.0929644001E+00, 9.5358116313E-01],
	[3.5515000000E+04, 2.7644849294E+01, 4.9871596518E+00, 1.1550395653E+01, 3.0934357338E+00, 9.5360303005E-01],
	[3.5520000000E+04, 2.7651504143E+01, 4.9871785082E+00, 1.1555703987E+01, 3.0939069496E+00, 9.5362488578E-01],
	[3.5525000000E+04, 2.7658159658E+01, 4.9871973620E+00, 1.1561014011E+01, 3.0943780476E+00, 9.5364673033E-01],
	[3.5530000000E+04, 2.7664815837E+01, 4.9872162132E+00, 1.1566325727E+01, 3.0948490278E+00, 9.5366856369E-01],
	[3.5535000000E+04, 2.7671472681E+01, 4.9872350618E+00, 1.1571639135E+01, 3.0953198903E+00, 9.5369038588E-01],
	[3.5540000000E+04, 2.7678130190E+01, 4.9872539079E+00, 1.1576954234E+01, 3.0957906349E+00, 9.5371219690E-01],
	[3.5545000000E+04, 2.7684788364E+01, 4.9872727513E+00, 1.1582271027E+01, 3.0962612618E+00, 9.5373399675E-01],
	[3.5550000000E+04, 2.7691447203E+01, 4.9872915922E+00, 1.1587589511E+01, 3.0967317710E+00, 9.5375578544E-01],
	[3.5555000000E+04, 2.7698106706E+01, 4.9873104305E+00, 1.1592909689E+01, 3.0972021624E+00, 9.5377756299E-01],
	[3.5560000000E+04, 2.7704766874E+01, 4.9873292663E+00, 1.1598231560E+01, 3.0976724361E+00, 9.5379932938E-01],
	[3.5565000000E+04, 2.7711427707E+01, 4.9873480994E+00, 1.1603555124E+01, 3.0981425921E+00, 9.5382108464E-01],
	[3.5570000000E+04, 2.7718089205E+01, 4.9873669300E+00, 1.1608880383E+01, 3.0986126304E+00, 9.5384282875E-01],
	[3.5575000000E+04, 2.7724751367E+01, 4.9873857580E+00, 1.1614207335E+01, 3.0990825510E+00, 9.5386456174E-01],
	[3.5580000000E+04, 2.7731414194E+01, 4.9874045834E+00, 1.1619535982E+01, 3.0995523539E+00, 9.5388628360E-01],
	[3.5585000000E+04, 2.7738077686E+01, 4.9874234063E+00, 1.1624866324E+01, 3.1000220392E+00, 9.5390799434E-01],
	[3.5590000000E+04, 2.7744741842E+01, 4.9874422266E+00, 1.1630198361E+01, 3.1004916069E+00, 9.5392969397E-01],
	[3.5595000000E+04, 2.7751406663E+01, 4.9874610443E+00, 1.1635532093E+01, 3.1009610569E+00, 9.5395138249E-01],
	[3.5600000000E+04, 2.7758072148E+01, 4.9874798594E+00, 1.1640867521E+01, 3.1014303893E+00, 9.5397305990E-01],
	[3.5605000000E+04, 2.7764738298E+01, 4.9874986720E+00, 1.1646204645E+01, 3.1018996041E+00, 9.5399472622E-01],
	[3.5610000000E+04, 2.7771405113E+01, 4.9875174820E+00, 1.1651543465E+01, 3.1023687014E+00, 9.5401638145E-01],
	[3.5615000000E+04, 2.7778072591E+01, 4.9875362894E+00, 1.1656883982E+01, 3.1028376810E+00, 9.5403802559E-01],
	[3.5620000000E+04, 2.7784740735E+01, 4.9875550942E+00, 1.1662226195E+01, 3.1033065431E+00, 9.5405965865E-01],
	[3.5625000000E+04, 2.7791409542E+01, 4.9875738965E+00, 1.1667570106E+01, 3.1037752876E+00, 9.5408128064E-01],
	[3.5630000000E+04, 2.7798079014E+01, 4.9875926962E+00, 1.1672915714E+01, 3.1042439147E+00, 9.5410289155E-01],
	[3.5635000000E+04, 2.7804749151E+01, 4.9876114934E+00, 1.1678263020E+01, 3.1047124241E+00, 9.5412449140E-01],
	[3.5640000000E+04, 2.7811419952E+01, 4.9876302880E+00, 1.1683612024E+01, 3.1051808161E+00, 9.5414608020E-01],
	[3.5645000000E+04, 2.7818091417E+01, 4.9876490800E+00, 1.1688962727E+01, 3.1056490906E+00, 9.5416765794E-01],
	[3.5650000000E+04, 2.7824763546E+01, 4.9876678694E+00, 1.1694315128E+01, 3.1061172476E+00, 9.5418922463E-01],
	[3.5655000000E+04, 2.7831449401E+01, 4.9876883594E+00, 1.1699669228E+01, 3.1065861106E+00, 9.5421078029E-01],
	[3.5660000000E+04, 2.7838141435E+01, 4.9877095650E+00, 1.1705025027E+01, 3.1070552039E+00, 9.5423232490E-01],
	[3.5665000000E+04, 2.7844834140E+01, 4.9877307678E+00, 1.1710382526E+01, 3.1075241801E+00, 9.5425385849E-01],
	[3.5670000000E+04, 2.7851527516E+01, 4.9877519676E+00, 1.1715741725E+01, 3.1079930394E+00, 9.5427538105E-01],
	[3.5675000000E+04, 2.7858221561E+01, 4.9877731645E+00, 1.1721102623E+01, 3.1084617816E+00, 9.5429689260E-01],
	[3.5680000000E+04, 2.7864916278E+01, 4.9877943586E+00, 1.1726465223E+01, 3.1089304069E+00, 9.5431839312E-01],
	[3.5685000000E+04, 2.7871611664E+01, 4.9878155498E+00, 1.1731829523E+01, 3.1093989152E+00, 9.5433988264E-01],
	[3.5690000000E+04, 2.7878307721E+01, 4.9878367381E+00, 1.1737195524E+01, 3.1098673066E+00, 9.5436136116E-01],
	[3.5695000000E+04, 2.7885004449E+01, 4.9878579235E+00, 1.1742563227E+01, 3.1103355810E+00, 9.5438282868E-01],
	[3.5700000000E+04, 2.7891701846E+01, 4.9878791061E+00, 1.1747932631E+01, 3.1108037385E+00, 9.5440428521E-01],
	[3.5705000000E+04, 2.7898399914E+01, 4.9879002858E+00, 1.1753303737E+01, 3.1112717791E+00, 9.5442573076E-01],
	[3.5710000000E+04, 2.7905098653E+01, 4.9879214626E+00, 1.1758676546E+01, 3.1117397028E+00, 9.5444716532E-01],
	[3.5715000000E+04, 2.7911798061E+01, 4.9879426365E+00, 1.1764051057E+01, 3.1122075096E+00, 9.5446858891E-01],
	[3.5720000000E+04, 2.7918498140E+01, 4.9879638076E+00, 1.1769427271E+01, 3.1126751996E+00, 9.5449000153E-01],
	[3.5725000000E+04, 2.7925198889E+01, 4.9879849757E+00, 1.1774805188E+01, 3.1131427727E+00, 9.5451140319E-01],
	[3.5730000000E+04, 2.7931900308E+01, 4.9880061411E+00, 1.1780184809E+01, 3.1136102290E+00, 9.5453279389E-01],
	[3.5735000000E+04, 2.7938602397E+01, 4.9880273035E+00, 1.1785566133E+01, 3.1140775684E+00, 9.5455417363E-01],
	[3.5740000000E+04, 2.7945305156E+01, 4.9880484631E+00, 1.1790949162E+01, 3.1145447911E+00, 9.5457554243E-01],
	[3.5745000000E+04, 2.7952008586E+01, 4.9880696198E+00, 1.1796333895E+01, 3.1150118969E+00, 9.5459690029E-01],
	[3.5750000000E+04, 2.7958712685E+01, 4.9880907736E+00, 1.1801720332E+01, 3.1154788859E+00, 9.5461824721E-01],
	[3.5755000000E+04, 2.7965417455E+01, 4.9881119245E+00, 1.1807108475E+01, 3.1159457582E+00, 9.5463958320E-01],
	[3.5760000000E+04, 2.7972122894E+01, 4.9881330726E+00, 1.1812498323E+01, 3.1164125137E+00, 9.5466090827E-01],
	[3.5765000000E+04, 2.7978829003E+01, 4.9881542178E+00, 1.1817889876E+01, 3.1168791525E+00, 9.5468222242E-01],
	[3.5770000000E+04, 2.7985535783E+01, 4.9881753602E+00, 1.1823283135E+01, 3.1173456745E+00, 9.5470352566E-01],
	[3.5775000000E+04, 2.7992243232E+01, 4.9881964997E+00, 1.1828678101E+01, 3.1178120798E+00, 9.5472481798E-01],
	[3.5780000000E+04, 2.7998951351E+01, 4.9882176363E+00, 1.1834074773E+01, 3.1182783685E+00, 9.5474609941E-01],
	[3.5785000000E+04, 2.8005660140E+01, 4.9882387701E+00, 1.1839473152E+01, 3.1187445404E+00, 9.5476736994E-01],
	[3.5790000000E+04, 2.8012369599E+01, 4.9882599010E+00, 1.1844873238E+01, 3.1192105957E+00, 9.5478862957E-01],
	[3.5795000000E+04, 2.8019079728E+01, 4.9882810290E+00, 1.1850275031E+01, 3.1196765343E+00, 9.5480987833E-01],
	[3.5800000000E+04, 2.8025790526E+01, 4.9883021542E+00, 1.1855678532E+01, 3.1201423562E+00, 9.5483111620E-01],
	[3.5805000000E+04, 2.8032501994E+01, 4.9883232765E+00, 1.1861083741E+01, 3.1206080615E+00, 9.5485234319E-01],
	[3.5810000000E+04, 2.8039214132E+01, 4.9883443960E+00, 1.1866490658E+01, 3.1210736502E+00, 9.5487355932E-01],
	[3.5815000000E+04, 2.8045926940E+01, 4.9883655126E+00, 1.1871899284E+01, 3.1215391223E+00, 9.5489476459E-01],
	[3.5820000000E+04, 2.8052640417E+01, 4.9883866263E+00, 1.1877309618E+01, 3.1220044778E+00, 9.5491595899E-01],
	[3.5825000000E+04, 2.8059354564E+01, 4.9884077372E+00, 1.1882721662E+01, 3.1224697167E+00, 9.5493714255E-01],
	[3.5830000000E+04, 2.8066069381E+01, 4.9884288452E+00, 1.1888135416E+01, 3.1229348391E+00, 9.5495831526E-01],
	[3.5835000000E+04, 2.8072784867E+01, 4.9884499504E+00, 1.1893550879E+01, 3.1233998449E+00, 9.5497947712E-01],
	[3.5840000000E+04, 2.8079501023E+01, 4.9884710527E+00, 1.1898968052E+01, 3.1238647342E+00, 9.5500062816E-01],
	[3.5845000000E+04, 2.8086217848E+01, 4.9884921521E+00, 1.1904386936E+01, 3.1243295070E+00, 9.5502176836E-01],
	[3.5850000000E+04, 2.8092935343E+01, 4.9885132487E+00, 1.1909807530E+01, 3.1247941632E+00, 9.5504289774E-01],
	[3.5855000000E+04, 2.8099653507E+01, 4.9885343425E+00, 1.1915229836E+01, 3.1252587030E+00, 9.5506401629E-01],
	[3.5860000000E+04, 2.8106372341E+01, 4.9885554334E+00, 1.1920653853E+01, 3.1257231262E+00, 9.5508512404E-01],
	[3.5865000000E+04, 2.8113091844E+01, 4.9885765214E+00, 1.1926079581E+01, 3.1261874331E+00, 9.5510622098E-01],
	[3.5870000000E+04, 2.8119812017E+01, 4.9885976066E+00, 1.1931507021E+01, 3.1266516234E+00, 9.5512730711E-01],
	[3.5875000000E+04, 2.8126532859E+01, 4.9886186890E+00, 1.1936936174E+01, 3.1271156973E+00, 9.5514838245E-01],
	[3.5880000000E+04, 2.8133254371E+01, 4.9886397685E+00, 1.1942367038E+01, 3.1275796549E+00, 9.5516944700E-01],
	[3.5885000000E+04, 2.8139976551E+01, 4.9886608451E+00, 1.1947799616E+01, 3.1280434960E+00, 9.5519050076E-01],
	[3.5890000000E+04, 2.8146699401E+01, 4.9886819189E+00, 1.1953233907E+01, 3.1285072207E+00, 9.5521154374E-01],
	[3.5895000000E+04, 2.8153422921E+01, 4.9887029899E+00, 1.1958669911E+01, 3.1289708290E+00, 9.5523257595E-01],
	[3.5900000000E+04, 2.8160147109E+01, 4.9887240580E+00, 1.1964107629E+01, 3.1294343209E+00, 9.5525359739E-01],
	[3.5905000000E+04, 2.8166871967E+01, 4.9887451232E+00, 1.1969547061E+01, 3.1298976966E+00, 9.5527460806E-01],
	[3.5910000000E+04, 2.8173597494E+01, 4.9887661856E+00, 1.1974988208E+01, 3.1303609558E+00, 9.5529560798E-01],
	[3.5915000000E+04, 2.8180323690E+01, 4.9887872452E+00, 1.1980431069E+01, 3.1308240988E+00, 9.5531659715E-01],
	[3.5920000000E+04, 2.8187050555E+01, 4.9888083020E+00, 1.1985875644E+01, 3.1312871254E+00, 9.5533757557E-01],
	[3.5925000000E+04, 2.8193778090E+01, 4.9888293558E+00, 1.1991321935E+01, 3.1317500358E+00, 9.5535854324E-01],
	[3.5930000000E+04, 2.8200506293E+01, 4.9888504069E+00, 1.1996769942E+01, 3.1322128298E+00, 9.5537950019E-01],
	[3.5935000000E+04, 2.8207235166E+01, 4.9888714551E+00, 1.2002219664E+01, 3.1326755077E+00, 9.5540044640E-01],
	[3.5940000000E+04, 2.8213964707E+01, 4.9888925005E+00, 1.2007671103E+01, 3.1331380692E+00, 9.5542138189E-01],
	[3.5945000000E+04, 2.8220694918E+01, 4.9889135430E+00, 1.2013124258E+01, 3.1336005145E+00, 9.5544230665E-01],
	[3.5950000000E+04, 2.8227425797E+01, 4.9889345827E+00, 1.2018579129E+01, 3.1340628436E+00, 9.5546322071E-01],
	[3.5955000000E+04, 2.8234157346E+01, 4.9889556195E+00, 1.2024035718E+01, 3.1345250565E+00, 9.5548412406E-01],
	[3.5960000000E+04, 2.8240889564E+01, 4.9889766536E+00, 1.2029494024E+01, 3.1349871532E+00, 9.5550501670E-01],
	[3.5965000000E+04, 2.8247622450E+01, 4.9889976847E+00, 1.2034954048E+01, 3.1354491338E+00, 9.5552589865E-01],
	[3.5970000000E+04, 2.8254356005E+01, 4.9890187131E+00, 1.2040415789E+01, 3.1359109981E+00, 9.5554676991E-01],
	[3.5975000000E+04, 2.8261090229E+01, 4.9890397386E+00, 1.2045879249E+01, 3.1363727463E+00, 9.5556763048E-01],
	[3.5980000000E+04, 2.8267825122E+01, 4.9890607613E+00, 1.2051344427E+01, 3.1368343784E+00, 9.5558848037E-01],
	[3.5985000000E+04, 2.8274560684E+01, 4.9890817811E+00, 1.2056811324E+01, 3.1372958944E+00, 9.5560931959E-01],
	[3.5990000000E+04, 2.8281296914E+01, 4.9891027981E+00, 1.2062279941E+01, 3.1377572942E+00, 9.5563014814E-01],
	[3.5995000000E+04, 2.8288033814E+01, 4.9891238123E+00, 1.2067750276E+01, 3.1382185780E+00, 9.5565096602E-01],
	[3.6000000000E+04, 2.8294771382E+01, 4.9891448237E+00, 1.2073222332E+01, 3.1386797457E+00, 9.5567177325E-01],
	[3.6005000000E+04, 2.8301509618E+01, 4.9891658322E+00, 1.2078696107E+01, 3.1391407973E+00, 9.5569256983E-01],
	[3.6010000000E+04, 2.8308248524E+01, 4.9891868379E+00, 1.2084171603E+01, 3.1396017329E+00, 9.5571335575E-01],
	[3.6015000000E+04, 2.8314988098E+01, 4.9892078408E+00, 1.2089648820E+01, 3.1400625524E+00, 9.5573413104E-01],
	[3.6020000000E+04, 2.8321728340E+01, 4.9892288408E+00, 1.2095127757E+01, 3.1405232560E+00, 9.5575489569E-01],
	[3.6025000000E+04, 2.8328469251E+01, 4.9892498380E+00, 1.2100608416E+01, 3.1409838435E+00, 9.5577564971E-01],
	[3.6030000000E+04, 2.8335210831E+01, 4.9892708324E+00, 1.2106090796E+01, 3.1414443151E+00, 9.5579639311E-01],
	[3.6035000000E+04, 2.8341953080E+01, 4.9892918240E+00, 1.2111574898E+01, 3.1419046706E+00, 9.5581712589E-01],
	[3.6040000000E+04, 2.8348695996E+01, 4.9893128127E+00, 1.2117060722E+01, 3.1423649102E+00, 9.5583784805E-01],
	[3.6045000000E+04, 2.8355439582E+01, 4.9893337986E+00, 1.2122548269E+01, 3.1428250339E+00, 9.5585855960E-01],
	[3.6050000000E+04, 2.8362183835E+01, 4.9893547817E+00, 1.2128037538E+01, 3.1432850417E+00, 9.5587926056E-01],
	[3.6055000000E+04, 2.8368928757E+01, 4.9893757620E+00, 1.2133528530E+01, 3.1437449335E+00, 9.5589995091E-01],
	[3.6060000000E+04, 2.8375674348E+01, 4.9893967394E+00, 1.2139021246E+01, 3.1442047094E+00, 9.5592063068E-01],
	[3.6065000000E+04, 2.8382420607E+01, 4.9894177141E+00, 1.2144515685E+01, 3.1446643695E+00, 9.5594129986E-01],
	[3.6070000000E+04, 2.8389167534E+01, 4.9894386859E+00, 1.2150011849E+01, 3.1451239137E+00, 9.5596195845E-01],
	[3.6075000000E+04, 2.8395915130E+01, 4.9894596549E+00, 1.2155509736E+01, 3.1455833420E+00, 9.5598260648E-01],
	[3.6080000000E+04, 2.8402663394E+01, 4.9894806210E+00, 1.2161009349E+01, 3.1460426545E+00, 9.5600324393E-01],
	[3.6085000000E+04, 2.8409412326E+01, 4.9895015844E+00, 1.2166510686E+01, 3.1465018512E+00, 9.5602387082E-01],
	[3.6090000000E+04, 2.8416161926E+01, 4.9895225449E+00, 1.2172013748E+01, 3.1469609320E+00, 9.5604448715E-01],
	[3.6095000000E+04, 2.8422912195E+01, 4.9895435027E+00, 1.2177518536E+01, 3.1474198971E+00, 9.5606509293E-01],
	[3.6100000000E+04, 2.8429663132E+01, 4.9895644576E+00, 1.2183025049E+01, 3.1478787464E+00, 9.5608568816E-01],
	[3.6105000000E+04, 2.8436414737E+01, 4.9895854097E+00, 1.2188533288E+01, 3.1483374799E+00, 9.5610627285E-01],
	[3.6110000000E+04, 2.8443167010E+01, 4.9896063589E+00, 1.2194043254E+01, 3.1487960977E+00, 9.5612684701E-01],
	[3.6115000000E+04, 2.8449919951E+01, 4.9896273054E+00, 1.2199554947E+01, 3.1492545997E+00, 9.5614741063E-01],
	[3.6120000000E+04, 2.8456673560E+01, 4.9896482491E+00, 1.2205068366E+01, 3.1497129860E+00, 9.5616796373E-01],
	[3.6125000000E+04, 2.8463427838E+01, 4.9896691899E+00, 1.2210583513E+01, 3.1501712566E+00, 9.5618850631E-01],
	[3.6130000000E+04, 2.8470182783E+01, 4.9896901280E+00, 1.2216100387E+01, 3.1506294116E+00, 9.5620903837E-01],
	[3.6135000000E+04, 2.8476938397E+01, 4.9897110632E+00, 1.2221618990E+01, 3.1510874508E+00, 9.5622955993E-01],
	[3.6140000000E+04, 2.8483694678E+01, 4.9897319956E+00, 1.2227139320E+01, 3.1515453744E+00, 9.5625007098E-01],
	[3.6145000000E+04, 2.8490451627E+01, 4.9897529252E+00, 1.2232661379E+01, 3.1520031824E+00, 9.5627057154E-01],
	[3.6150000000E+04, 2.8497209245E+01, 4.9897738520E+00, 1.2238185167E+01, 3.1524608747E+00, 9.5629106160E-01],
	[3.6155000000E+04, 2.8503967530E+01, 4.9897947760E+00, 1.2243710683E+01, 3.1529184514E+00, 9.5631154118E-01],
	[3.6160000000E+04, 2.8510726483E+01, 4.9898156972E+00, 1.2249237929E+01, 3.1533759125E+00, 9.5633201028E-01],
	[3.6165000000E+04, 2.8517486104E+01, 4.9898366156E+00, 1.2254766905E+01, 3.1538332581E+00, 9.5635246890E-01],
	[3.6170000000E+04, 2.8524246392E+01, 4.9898575312E+00, 1.2260297611E+01, 3.1542904881E+00, 9.5637291705E-01],
	[3.6175000000E+04, 2.8531007349E+01, 4.9898784439E+00, 1.2265830047E+01, 3.1547476025E+00, 9.5639335473E-01],
	[3.6180000000E+04, 2.8537768973E+01, 4.9898993539E+00, 1.2271364214E+01, 3.1552046014E+00, 9.5641378196E-01],
	[3.6185000000E+04, 2.8544531265E+01, 4.9899202611E+00, 1.2276900111E+01, 3.1556614847E+00, 9.5643419873E-01],
	[3.6190000000E+04, 2.8551294225E+01, 4.9899411654E+00, 1.2282437740E+01, 3.1561182526E+00, 9.5645460506E-01],
	[3.6195000000E+04, 2.8558057852E+01, 4.9899620670E+00, 1.2287977100E+01, 3.1565749049E+00, 9.5647500095E-01],
	[3.6200000000E+04, 2.8564822147E+01, 4.9899829658E+00, 1.2293518192E+01, 3.1570314418E+00, 9.5649538639E-01],
	[3.6205000000E+04, 2.8571587110E+01, 4.9900038618E+00, 1.2299061016E+01, 3.1574878633E+00, 9.5651576141E-01],
	[3.6210000000E+04, 2.8578352740E+01, 4.9900247549E+00, 1.2304605573E+01, 3.1579441693E+00, 9.5653612600E-01],
	[3.6215000000E+04, 2.8585119038E+01, 4.9900456453E+00, 1.2310151862E+01, 3.1584003598E+00, 9.5655648017E-01],
	[3.6220000000E+04, 2.8591886004E+01, 4.9900665329E+00, 1.2315699884E+01, 3.1588564350E+00, 9.5657682392E-01],
	[3.6225000000E+04, 2.8598653637E+01, 4.9900874177E+00, 1.2321249640E+01, 3.1593123947E+00, 9.5659715727E-01],
	[3.6230000000E+04, 2.8605438754E+01, 4.9901104683E+00, 1.2326801129E+01, 3.1597693138E+00, 9.5661748021E-01],
	[3.6235000000E+04, 2.8612226103E+01, 4.9901337167E+00, 1.2332354352E+01, 3.1602262174E+00, 9.5663779275E-01],
	[3.6240000000E+04, 2.8619014125E+01, 4.9901569619E+00, 1.2337909309E+01, 3.1606830061E+00, 9.5665809490E-01],
	[3.6245000000E+04, 2.8625802820E+01, 4.9901802041E+00, 1.2343466001E+01, 3.1611396798E+00, 9.5667838667E-01],
	[3.6250000000E+04, 2.8632592190E+01, 4.9902034432E+00, 1.2349024428E+01, 3.1615962386E+00, 9.5669866805E-01],
	[3.6255000000E+04, 2.8639382232E+01, 4.9902266792E+00, 1.2354584589E+01, 3.1620526826E+00, 9.5671893905E-01],
	[3.6260000000E+04, 2.8646172948E+01, 4.9902499120E+00, 1.2360146486E+01, 3.1625090116E+00, 9.5673919969E-01],
	[3.6265000000E+04, 2.8652964338E+01, 4.9902731418E+00, 1.2365710119E+01, 3.1629652257E+00, 9.5675944995E-01],
	[3.6270000000E+04, 2.8659756401E+01, 4.9902963685E+00, 1.2371275488E+01, 3.1634213250E+00, 9.5677968986E-01],
	[3.6275000000E+04, 2.8666549138E+01, 4.9903195921E+00, 1.2376842593E+01, 3.1638773095E+00, 9.5679991942E-01],
	[3.6280000000E+04, 2.8673342548E+01, 4.9903428126E+00, 1.2382411435E+01, 3.1643331791E+00, 9.5682013862E-01],
	[3.6285000000E+04, 2.8680136632E+01, 4.9903660300E+00, 1.2387982014E+01, 3.1647889339E+00, 9.5684034749E-01],
	[3.6290000000E+04, 2.8686931388E+01, 4.9903892443E+00, 1.2393554330E+01, 3.1652445739E+00, 9.5686054601E-01],
	[3.6295000000E+04, 2.8693726818E+01, 4.9904124556E+00, 1.2399128383E+01, 3.1657000991E+00, 9.5688073420E-01],
	[3.6300000000E+04, 2.8700522922E+01, 4.9904356637E+00, 1.2404704175E+01, 3.1661555096E+00, 9.5690091207E-01],
	[3.6305000000E+04, 2.8707319699E+01, 4.9904588688E+00, 1.2410281704E+01, 3.1666108053E+00, 9.5692107961E-01],
	[3.6310000000E+04, 2.8714117149E+01, 4.9904820707E+00, 1.2415860972E+01, 3.1670659863E+00, 9.5694123684E-01],
	[3.6315000000E+04, 2.8720915272E+01, 4.9905052696E+00, 1.2421441979E+01, 3.1675210526E+00, 9.5696138376E-01],
	[3.6320000000E+04, 2.8727714068E+01, 4.9905284654E+00, 1.2427024724E+01, 3.1679760041E+00, 9.5698152037E-01],
	[3.6325000000E+04, 2.8734513538E+01, 4.9905516581E+00, 1.2432609209E+01, 3.1684308410E+00, 9.5700164669E-01],
	[3.6330000000E+04, 2.8741313681E+01, 4.9905748477E+00, 1.2438195434E+01, 3.1688855632E+00, 9.5702176270E-01],
	[3.6335000000E+04, 2.8748114497E+01, 4.9905980343E+00, 1.2443783399E+01, 3.1693401708E+00, 9.5704186844E-01],
	[3.6340000000E+04, 2.8754915986E+01, 4.9906212177E+00, 1.2449373104E+01, 3.1697946637E+00, 9.5706196388E-01],
	[3.6345000000E+04, 2.8761718148E+01, 4.9906443981E+00, 1.2454964549E+01, 3.1702490419E+00, 9.5708204905E-01],
	[3.6350000000E+04, 2.8768520983E+01, 4.9906675754E+00, 1.2460557735E+01, 3.1707033056E+00, 9.5710212395E-01],
	[3.6355000000E+04, 2.8775324491E+01, 4.9906907496E+00, 1.2466152663E+01, 3.1711574547E+00, 9.5712218858E-01],
	[3.6360000000E+04, 2.8782128672E+01, 4.9907139207E+00, 1.2471749331E+01, 3.1716114892E+00, 9.5714224296E-01],
	[3.6365000000E+04, 2.8788933526E+01, 4.9907370888E+00, 1.2477347742E+01, 3.1720654091E+00, 9.5716228707E-01],
	[3.6370000000E+04, 2.8795739053E+01, 4.9907602537E+00, 1.2482947895E+01, 3.1725192145E+00, 9.5718232094E-01],
	[3.6375000000E+04, 2.8802545253E+01, 4.9907834156E+00, 1.2488549790E+01, 3.1729729054E+00, 9.5720234456E-01],
	[3.6380000000E+04, 2.8809352126E+01, 4.9908065745E+00, 1.2494153428E+01, 3.1734264817E+00, 9.5722235794E-01],
	[3.6385000000E+04, 2.8816159672E+01, 4.9908297302E+00, 1.2499758808E+01, 3.1738799436E+00, 9.5724236109E-01],
	[3.6390000000E+04, 2.8822967891E+01, 4.9908528829E+00, 1.2505365932E+01, 3.1743332909E+00, 9.5726235401E-01],
	[3.6395000000E+04, 2.8829776782E+01, 4.9908760325E+00, 1.2510974800E+01, 3.1747865238E+00, 9.5728233670E-01],
	[3.6400000000E+04, 2.8836586346E+01, 4.9908991790E+00, 1.2516585411E+01, 3.1752396422E+00, 9.5730230918E-01],
	[3.6405000000E+04, 2.8843396583E+01, 4.9909223225E+00, 1.2522197767E+01, 3.1756926462E+00, 9.5732227145E-01],
	[3.6410000000E+04, 2.8850207493E+01, 4.9909454628E+00, 1.2527811867E+01, 3.1761455358E+00, 9.5734222351E-01],
	[3.6415000000E+04, 2.8857019075E+01, 4.9909686002E+00, 1.2533427712E+01, 3.1765983110E+00, 9.5736216537E-01],
	[3.6420000000E+04, 2.8863831330E+01, 4.9909917344E+00, 1.2539045302E+01, 3.1770509718E+00, 9.5738209704E-01],
	[3.6425000000E+04, 2.8870644258E+01, 4.9910148656E+00, 1.2544664637E+01, 3.1775035182E+00, 9.5740201851E-01],
	[3.6430000000E+04, 2.8877457859E+01, 4.9910379937E+00, 1.2550285718E+01, 3.1779559502E+00, 9.5742192980E-01],
	[3.6435000000E+04, 2.8884272132E+01, 4.9910611187E+00, 1.2555908545E+01, 3.1784082680E+00, 9.5744183091E-01],
	[3.6440000000E+04, 2.8891087077E+01, 4.9910842407E+00, 1.2561533118E+01, 3.1788604714E+00, 9.5746172185E-01],
	[3.6445000000E+04, 2.8897902695E+01, 4.9911073596E+00, 1.2567159438E+01, 3.1793125604E+00, 9.5748160262E-01],
	[3.6450000000E+04, 2.8904718986E+01, 4.9911304754E+00, 1.2572787505E+01, 3.1797645352E+00, 9.5750147323E-01],
	[3.6455000000E+04, 2.8911535949E+01, 4.9911535882E+00, 1.2578417319E+01, 3.1802163957E+00, 9.5752133368E-01],
	[3.6460000000E+04, 2.8918353585E+01, 4.9911766979E+00, 1.2584048880E+01, 3.1806681420E+00, 9.5754118397E-01],
	[3.6465000000E+04, 2.8925171893E+01, 4.9911998046E+00, 1.2589682190E+01, 3.1811197740E+00, 9.5756102413E-01],
	[3.6470000000E+04, 2.8931990874E+01, 4.9912229082E+00, 1.2595317247E+01, 3.1815712918E+00, 9.5758085414E-01],
	[3.6475000000E+04, 2.8938810527E+01, 4.9912460087E+00, 1.2600954053E+01, 3.1820226953E+00, 9.5760067401E-01],
	[3.6480000000E+04, 2.8945630852E+01, 4.9912691062E+00, 1.2606592607E+01, 3.1824739847E+00, 9.5762048376E-01],
	[3.6485000000E+04, 2.8952451850E+01, 4.9912922006E+00, 1.2612232911E+01, 3.1829251599E+00, 9.5764028338E-01],
	[3.6490000000E+04, 2.8959273520E+01, 4.9913152920E+00, 1.2617874964E+01, 3.1833762209E+00, 9.5766007288E-01],
	[3.6495000000E+04, 2.8966095862E+01, 4.9913383803E+00, 1.2623518766E+01, 3.1838271677E+00, 9.5767985227E-01],
	[3.6500000000E+04, 2.8972918877E+01, 4.9913614655E+00, 1.2629164319E+01, 3.1842780005E+00, 9.5769962155E-01],
	[3.6505000000E+04, 2.8979742564E+01, 4.9913845477E+00, 1.2634811621E+01, 3.1847287191E+00, 9.5771938073E-01],
	[3.6510000000E+04, 2.8986566923E+01, 4.9914076269E+00, 1.2640460674E+01, 3.1851793236E+00, 9.5773912981E-01],
	[3.6515000000E+04, 2.8993391954E+01, 4.9914307029E+00, 1.2646111478E+01, 3.1856298140E+00, 9.5775886879E-01],
	[3.6520000000E+04, 2.9000217657E+01, 4.9914537760E+00, 1.2651764033E+01, 3.1860801904E+00, 9.5777859770E-01],
	[3.6525000000E+04, 2.9007044033E+01, 4.9914768459E+00, 1.2657418340E+01, 3.1865304527E+00, 9.5779831652E-01],
	[3.6530000000E+04, 2.9013871081E+01, 4.9914999129E+00, 1.2663074398E+01, 3.1869806010E+00, 9.5781802526E-01],
	[3.6535000000E+04, 2.9020698800E+01, 4.9915229767E+00, 1.2668732208E+01, 3.1874306353E+00, 9.5783772394E-01],
	[3.6540000000E+04, 2.9027527192E+01, 4.9915460376E+00, 1.2674391771E+01, 3.1878805555E+00, 9.5785741255E-01],
	[3.6545000000E+04, 2.9034356256E+01, 4.9915690953E+00, 1.2680053086E+01, 3.1883303618E+00, 9.5787709110E-01],
	[3.6550000000E+04, 2.9041185992E+01, 4.9915921501E+00, 1.2685716154E+01, 3.1887800541E+00, 9.5789675960E-01],
	[3.6555000000E+04, 2.9048016400E+01, 4.9916152017E+00, 1.2691380976E+01, 3.1892296324E+00, 9.5791641805E-01],
	[3.6560000000E+04, 2.9054847480E+01, 4.9916382504E+00, 1.2697047551E+01, 3.1896790968E+00, 9.5793606645E-01],
	[3.6565000000E+04, 2.9061679232E+01, 4.9916612960E+00, 1.2702715880E+01, 3.1901284473E+00, 9.5795570482E-01],
	[3.6570000000E+04, 2.9068511655E+01, 4.9916843385E+00, 1.2708385963E+01, 3.1905776839E+00, 9.5797533316E-01],
	[3.6575000000E+04, 2.9075344751E+01, 4.9917073780E+00, 1.2714057800E+01, 3.1910268066E+00, 9.5799495147E-01],
	[3.6580000000E+04, 2.9082178518E+01, 4.9917304145E+00, 1.2719731392E+01, 3.1914758154E+00, 9.5801455975E-01],
	[3.6585000000E+04, 2.9089012958E+01, 4.9917534479E+00, 1.2725406740E+01, 3.1919247103E+00, 9.5803415803E-01],
	[3.6590000000E+04, 2.9095848069E+01, 4.9917764783E+00, 1.2731083842E+01, 3.1923734915E+00, 9.5805374629E-01],
	[3.6595000000E+04, 2.9102683852E+01, 4.9917995056E+00, 1.2736762701E+01, 3.1928221588E+00, 9.5807332455E-01],
	[3.6600000000E+04, 2.9109520306E+01, 4.9918225299E+00, 1.2742443315E+01, 3.1932707122E+00, 9.5809289281E-01],
	[3.6605000000E+04, 2.9116357433E+01, 4.9918455511E+00, 1.2748125685E+01, 3.1937191519E+00, 9.5811245107E-01],
	[3.6610000000E+04, 2.9123195231E+01, 4.9918685694E+00, 1.2753809813E+01, 3.1941674779E+00, 9.5813199934E-01],
	[3.6615000000E+04, 2.9130033700E+01, 4.9918915845E+00, 1.2759495697E+01, 3.1946156900E+00, 9.5815153764E-01],
	[3.6620000000E+04, 2.9136872842E+01, 4.9919145967E+00, 1.2765183338E+01, 3.1950637885E+00, 9.5817106595E-01],
	[3.6625000000E+04, 2.9143712655E+01, 4.9919376058E+00, 1.2770872736E+01, 3.1955117732E+00, 9.5819058429E-01],
	[3.6630000000E+04, 2.9150553139E+01, 4.9919606119E+00, 1.2776563893E+01, 3.1959596442E+00, 9.5821009267E-01],
	[3.6635000000E+04, 2.9157394296E+01, 4.9919836149E+00, 1.2782256807E+01, 3.1964074015E+00, 9.5822959108E-01],
	[3.6640000000E+04, 2.9164236123E+01, 4.9920066149E+00, 1.2787951480E+01, 3.1968550451E+00, 9.5824907954E-01],
	[3.6645000000E+04, 2.9171078623E+01, 4.9920296119E+00, 1.2793647912E+01, 3.1973025750E+00, 9.5826855804E-01],
	[3.6650000000E+04, 2.9177921793E+01, 4.9920526058E+00, 1.2799346103E+01, 3.1977499914E+00, 9.5828802660E-01],
	[3.6655000000E+04, 2.9184765636E+01, 4.9920755967E+00, 1.2805046053E+01, 3.1981972941E+00, 9.5830748522E-01],
	[3.6660000000E+04, 2.9191610149E+01, 4.9920985846E+00, 1.2810747762E+01, 3.1986444832E+00, 9.5832693391E-01],
	[3.6665000000E+04, 2.9198455335E+01, 4.9921215694E+00, 1.2816451231E+01, 3.1990915587E+00, 9.5834637266E-01],
	[3.6670000000E+04, 2.9205301191E+01, 4.9921445513E+00, 1.2822156461E+01, 3.1995385206E+00, 9.5836580150E-01],
	[3.6675000000E+04, 2.9212147719E+01, 4.9921675301E+00, 1.2827863451E+01, 3.1999853690E+00, 9.5838522041E-01],
	[3.6680000000E+04, 2.9218994918E+01, 4.9921905058E+00, 1.2833572202E+01, 3.2004321038E+00, 9.5840462941E-01],
	[3.6685000000E+04, 2.9225842789E+01, 4.9922134786E+00, 1.2839282714E+01, 3.2008787251E+00, 9.5842402850E-01],
	[3.6690000000E+04, 2.9232691331E+01, 4.9922364483E+00, 1.2844994988E+01, 3.2013252329E+00, 9.5844341769E-01],
	[3.6695000000E+04, 2.9239540544E+01, 4.9922594150E+00, 1.2850709023E+01, 3.2017716272E+00, 9.5846279699E-01],
	[3.6700000000E+04, 2.9246390428E+01, 4.9922823786E+00, 1.2856424820E+01, 3.2022179080E+00, 9.5848216639E-01],
	[3.6705000000E+04, 2.9253240984E+01, 4.9923053393E+00, 1.2862142380E+01, 3.2026640753E+00, 9.5850152591E-01],
	[3.6710000000E+04, 2.9260092211E+01, 4.9923282969E+00, 1.2867861702E+01, 3.2031101293E+00, 9.5852087554E-01],
	[3.6715000000E+04, 2.9266944108E+01, 4.9923512515E+00, 1.2873582787E+01, 3.2035560698E+00, 9.5854021530E-01],
	[3.6720000000E+04, 2.9273796678E+01, 4.9923742031E+00, 1.2879305636E+01, 3.2040018969E+00, 9.5855954520E-01],
	[3.6725000000E+04, 2.9280649918E+01, 4.9923971517E+00, 1.2885030247E+01, 3.2044476106E+00, 9.5857886522E-01],
	[3.6730000000E+04, 2.9287503829E+01, 4.9924200972E+00, 1.2890756623E+01, 3.2048932109E+00, 9.5859817539E-01],
	[3.6735000000E+04, 2.9294358411E+01, 4.9924430397E+00, 1.2896484763E+01, 3.2053386978E+00, 9.5861747570E-01],
	[3.6740000000E+04, 2.9301213665E+01, 4.9924659792E+00, 1.2902214667E+01, 3.2057840715E+00, 9.5863676617E-01],
	[3.6745000000E+04, 2.9308069589E+01, 4.9924889157E+00, 1.2907946336E+01, 3.2062293318E+00, 9.5865604679E-01],
	[3.6750000000E+04, 2.9314926184E+01, 4.9925118492E+00, 1.2913679771E+01, 3.2066744788E+00, 9.5867531757E-01],
	[3.6755000000E+04, 2.9321783451E+01, 4.9925347797E+00, 1.2919414970E+01, 3.2071195125E+00, 9.5869457853E-01],
	[3.6760000000E+04, 2.9328641388E+01, 4.9925577071E+00, 1.2925151935E+01, 3.2075644329E+00, 9.5871382965E-01],
	[3.6765000000E+04, 2.9335499996E+01, 4.9925806315E+00, 1.2930890666E+01, 3.2080092401E+00, 9.5873307095E-01],
	[3.6770000000E+04, 2.9342359275E+01, 4.9926035530E+00, 1.2936631164E+01, 3.2084539340E+00, 9.5875230244E-01],
	[3.6775000000E+04, 2.9349219225E+01, 4.9926264714E+00, 1.2942373428E+01, 3.2088985147E+00, 9.5877152412E-01],
	[3.6780000000E+04, 2.9356079846E+01, 4.9926493868E+00, 1.2948117458E+01, 3.2093429822E+00, 9.5879073599E-01],
	[3.6785000000E+04, 2.9362941138E+01, 4.9926722992E+00, 1.2953863256E+01, 3.2097873366E+00, 9.5880993806E-01],
	[3.6790000000E+04, 2.9369803100E+01, 4.9926952086E+00, 1.2959610822E+01, 3.2102315777E+00, 9.5882913034E-01],
	[3.6795000000E+04, 2.9376665733E+01, 4.9927181149E+00, 1.2965360155E+01, 3.2106757057E+00, 9.5884831283E-01],
	[3.6800000000E+04, 2.9383529037E+01, 4.9927410183E+00, 1.2971111256E+01, 3.2111197206E+00, 9.5886748553E-01],
	[3.6805000000E+04, 2.9390393011E+01, 4.9927639187E+00, 1.2976864126E+01, 3.2115636223E+00, 9.5888664845E-01],
	[3.6810000000E+04, 2.9397262730E+01, 4.9927874635E+00, 1.2982618765E+01, 3.2120077395E+00, 9.5890580160E-01],
	[3.6815000000E+04, 2.9404146220E+01, 4.9928126763E+00, 1.2988375172E+01, 3.2124525918E+00, 9.5892494499E-01],
	[3.6820000000E+04, 2.9411030385E+01, 4.9928378858E+00, 1.2994133349E+01, 3.2128973315E+00, 9.5894407861E-01],
	[3.6825000000E+04, 2.9417915228E+01, 4.9928630921E+00, 1.2999893295E+01, 3.2133419584E+00, 9.5896320247E-01],
	[3.6830000000E+04, 2.9424800747E+01, 4.9928882950E+00, 1.3005655011E+01, 3.2137864728E+00, 9.5898231659E-01],
	[3.6835000000E+04, 2.9431686943E+01, 4.9929134947E+00, 1.3011418498E+01, 3.2142308744E+00, 9.5900142095E-01],
	[3.6840000000E+04, 2.9438573815E+01, 4.9929386910E+00, 1.3017183754E+01, 3.2146751635E+00, 9.5902051558E-01],
	[3.6845000000E+04, 2.9445461364E+01, 4.9929638841E+00, 1.3022950782E+01, 3.2151193400E+00, 9.5903960047E-01],
	[3.6850000000E+04, 2.9452349589E+01, 4.9929890739E+00, 1.3028719581E+01, 3.2155634038E+00, 9.5905867562E-01],
	[3.6855000000E+04, 2.9459238491E+01, 4.9930142603E+00, 1.3034490151E+01, 3.2160073551E+00, 9.5907774106E-01],
	[3.6860000000E+04, 2.9466128069E+01, 4.9930394435E+00, 1.3040262493E+01, 3.2164511939E+00, 9.5909679677E-01],
	[3.6865000000E+04, 2.9473018324E+01, 4.9930646234E+00, 1.3046036607E+01, 3.2168949201E+00, 9.5911584277E-01],
	[3.6870000000E+04, 2.9479909255E+01, 4.9930898000E+00, 1.3051812493E+01, 3.2173385338E+00, 9.5913487906E-01],
	[3.6875000000E+04, 2.9486800862E+01, 4.9931149734E+00, 1.3057590152E+01, 3.2177820350E+00, 9.5915390565E-01],
	[3.6880000000E+04, 2.9493693146E+01, 4.9931401434E+00, 1.3063369584E+01, 3.2182254237E+00, 9.5917292253E-01],
	[3.6885000000E+04, 2.9500586106E+01, 4.9931653102E+00, 1.3069150789E+01, 3.2186686999E+00, 9.5919192973E-01],
	[3.6890000000E+04, 2.9507479742E+01, 4.9931904736E+00, 1.3074933768E+01, 3.2191118637E+00, 9.5921092723E-01],
	[3.6895000000E+04, 2.9514374055E+01, 4.9932156338E+00, 1.3080718520E+01, 3.2195549150E+00, 9.5922991504E-01],
	[3.6900000000E+04, 2.9521269044E+01, 4.9932407907E+00, 1.3086505047E+01, 3.2199978540E+00, 9.5924889318E-01],
	[3.6905000000E+04, 2.9528164709E+01, 4.9932659444E+00, 1.3092293348E+01, 3.2204406805E+00, 9.5926786164E-01],
	[3.6910000000E+04, 2.9535061051E+01, 4.9932910947E+00, 1.3098083424E+01, 3.2208833947E+00, 9.5928682043E-01],
	[3.6915000000E+04, 2.9541958068E+01, 4.9933162418E+00, 1.3103875275E+01, 3.2213259964E+00, 9.5930576955E-01],
	[3.6920000000E+04, 2.9548855762E+01, 4.9933413855E+00, 1.3109668901E+01, 3.2217684859E+00, 9.5932470901E-01],
	[3.6925000000E+04, 2.9555754132E+01, 4.9933665260E+00, 1.3115464303E+01, 3.2222108630E+00, 9.5934363882E-01],
	[3.6930000000E+04, 2.9562653177E+01, 4.9933916633E+00, 1.3121261481E+01, 3.2226531278E+00, 9.5936255897E-01],
	[3.6935000000E+04, 2.9569552899E+01, 4.9934167972E+00, 1.3127060435E+01, 3.2230952803E+00, 9.5938146948E-01],
	[3.6940000000E+04, 2.9576453297E+01, 4.9934419279E+00, 1.3132861166E+01, 3.2235373205E+00, 9.5940037034E-01],
	[3.6945000000E+04, 2.9583354372E+01, 4.9934670553E+00, 1.3138663673E+01, 3.2239792485E+00, 9.5941926157E-01],
	[3.6950000000E+04, 2.9590256122E+01, 4.9934921794E+00, 1.3144467958E+01, 3.2244210642E+00, 9.5943814317E-01],
	[3.6955000000E+04, 2.9597158548E+01, 4.9935173003E+00, 1.3150274020E+01, 3.2248627676E+00, 9.5945701514E-01],
	[3.6960000000E+04, 2.9604061650E+01, 4.9935424178E+00, 1.3156081860E+01, 3.2253043589E+00, 9.5947587748E-01],
	[3.6965000000E+04, 2.9610965427E+01, 4.9935675322E+00, 1.3161891478E+01, 3.2257458380E+00, 9.5949473021E-01],
	[3.6970000000E+04, 2.9617869881E+01, 4.9935926432E+00, 1.3167702875E+01, 3.2261872049E+00, 9.5951357333E-01],
	[3.6975000000E+04, 2.9624775011E+01, 4.9936177510E+00, 1.3173516050E+01, 3.2266284596E+00, 9.5953240684E-01],
	[3.6980000000E+04, 2.9631680816E+01, 4.9936428555E+00, 1.3179331004E+01, 3.2270696022E+00, 9.5955123074E-01],
	[3.6985000000E+04, 2.9638587298E+01, 4.9936679567E+00, 1.3185147738E+01, 3.2275106327E+00, 9.5957004505E-01],
	[3.6990000000E+04, 2.9645494455E+01, 4.9936930547E+00, 1.3190966251E+01, 3.2279515511E+00, 9.5958884976E-01],
	[3.6995000000E+04, 2.9652402288E+01, 4.9937181494E+00, 1.3196786544E+01, 3.2283923574E+00, 9.5960764488E-01],
	[3.7000000000E+04, 2.9659310796E+01, 4.9937432408E+00, 1.3202608617E+01, 3.2288330516E+00, 9.5962643042E-01],
	[3.7005000000E+04, 2.9666219981E+01, 4.9937683290E+00, 1.3208432471E+01, 3.2292736337E+00, 9.5964520638E-01],
	[3.7010000000E+04, 2.9673129841E+01, 4.9937934139E+00, 1.3214258105E+01, 3.2297141039E+00, 9.5966397277E-01],
	[3.7015000000E+04, 2.9680040377E+01, 4.9938184955E+00, 1.3220085521E+01, 3.2301544620E+00, 9.5968272958E-01],
	[3.7020000000E+04, 2.9686951588E+01, 4.9938435739E+00, 1.3225914718E+01, 3.2305947081E+00, 9.5970147684E-01],
	[3.7025000000E+04, 2.9693863475E+01, 4.9938686490E+00, 1.3231745697E+01, 3.2310348422E+00, 9.5972021453E-01],
	[3.7030000000E+04, 2.9700776038E+01, 4.9938937209E+00, 1.3237578458E+01, 3.2314748643E+00, 9.5973894266E-01],
	[3.7035000000E+04, 2.9707689276E+01, 4.9939187895E+00, 1.3243413001E+01, 3.2319147745E+00, 9.5975766125E-01],
	[3.7040000000E+04, 2.9714603189E+01, 4.9939438548E+00, 1.3249249327E+01, 3.2323545728E+00, 9.5977637029E-01],
	[3.7045000000E+04, 2.9721517779E+01, 4.9939689169E+00, 1.3255087435E+01, 3.2327942591E+00, 9.5979506979E-01],
	[3.7050000000E+04, 2.9728433043E+01, 4.9939939757E+00, 1.3260927327E+01, 3.2332338336E+00, 9.5981375976E-01],
	[3.7055000000E+04, 2.9735348983E+01, 4.9940190313E+00, 1.3266769003E+01, 3.2336732961E+00, 9.5983244019E-01],
	[3.7060000000E+04, 2.9742265599E+01, 4.9940440836E+00, 1.3272612462E+01, 3.2341126469E+00, 9.5985111110E-01],
	[3.7065000000E+04, 2.9749182890E+01, 4.9940691327E+00, 1.3278457706E+01, 3.2345518857E+00, 9.5986977249E-01],
	[3.7070000000E+04, 2.9756100857E+01, 4.9940941785E+00, 1.3284304734E+01, 3.2349910128E+00, 9.5988842436E-01],
	[3.7075000000E+04, 2.9763019498E+01, 4.9941192210E+00, 1.3290153547E+01, 3.2354300280E+00, 9.5990706671E-01],
	[3.7080000000E+04, 2.9769938816E+01, 4.9941442603E+00, 1.3296004145E+01, 3.2358689314E+00, 9.5992569957E-01],
	[3.7085000000E+04, 2.9776858808E+01, 4.9941692964E+00, 1.3301856528E+01, 3.2363077231E+00, 9.5994432292E-01],
	[3.7090000000E+04, 2.9783779476E+01, 4.9941943292E+00, 1.3307710697E+01, 3.2367464030E+00, 9.5996293677E-01],
	[3.7095000000E+04, 2.9790700819E+01, 4.9942193588E+00, 1.3313566652E+01, 3.2371849711E+00, 9.5998154113E-01],
	[3.7100000000E+04, 2.9797622837E+01, 4.9942443851E+00, 1.3319424393E+01, 3.2376234276E+00, 9.6000013600E-01],
	[3.7105000000E+04, 2.9804545530E+01, 4.9942694081E+00, 1.3325283921E+01, 3.2380617723E+00, 9.6001872139E-01],
	[3.7110000000E+04, 2.9811468899E+01, 4.9942944279E+00, 1.3331145236E+01, 3.2385000054E+00, 9.6003729730E-01],
	[3.7115000000E+04, 2.9818392943E+01, 4.9943194445E+00, 1.3337008337E+01, 3.2389381268E+00, 9.6005586374E-01],
	[3.7120000000E+04, 2.9825317662E+01, 4.9943444578E+00, 1.3342873227E+01, 3.2393761365E+00, 9.6007442071E-01],
	[3.7125000000E+04, 2.9832243056E+01, 4.9943694679E+00, 1.3348739904E+01, 3.2398140346E+00, 9.6009296822E-01],
	[3.7130000000E+04, 2.9839169125E+01, 4.9943944747E+00, 1.3354608369E+01, 3.2402518211E+00, 9.6011150627E-01],
	[3.7135000000E+04, 2.9846095870E+01, 4.9944194783E+00, 1.3360478623E+01, 3.2406894960E+00, 9.6013003486E-01],
	[3.7140000000E+04, 2.9853023289E+01, 4.9944444787E+00, 1.3366350665E+01, 3.2411270593E+00, 9.6014855401E-01],
	[3.7145000000E+04, 2.9859951383E+01, 4.9944694758E+00, 1.3372224497E+01, 3.2415645110E+00, 9.6016706371E-01],
	[3.7150000000E+04, 2.9866880152E+01, 4.9944944697E+00, 1.3378100117E+01, 3.2420018512E+00, 9.6018556397E-01],
	[3.7155000000E+04, 2.9873809597E+01, 4.9945194603E+00, 1.3383977528E+01, 3.2424390799E+00, 9.6020405480E-01],
	[3.7160000000E+04, 2.9880739716E+01, 4.9945444477E+00, 1.3389856728E+01, 3.2428761971E+00, 9.6022253620E-01],
	[3.7165000000E+04, 2.9887670510E+01, 4.9945694319E+00, 1.3395737719E+01, 3.2433132028E+00, 9.6024100817E-01],
	[3.7170000000E+04, 2.9894601979E+01, 4.9945944128E+00, 1.3401620500E+01, 3.2437500970E+00, 9.6025947072E-01],
	[3.7175000000E+04, 2.9901534123E+01, 4.9946193905E+00, 1.3407505071E+01, 3.2441868797E+00, 9.6027792386E-01],
	[3.7180000000E+04, 2.9908466942E+01, 4.9946443649E+00, 1.3413391435E+01, 3.2446235510E+00, 9.6029636758E-01],
	[3.7185000000E+04, 2.9915400435E+01, 4.9946693362E+00, 1.3419279589E+01, 3.2450601109E+00, 9.6031480191E-01],
	[3.7190000000E+04, 2.9922334603E+01, 4.9946943042E+00, 1.3425169535E+01, 3.2454965594E+00, 9.6033322683E-01],
	[3.7195000000E+04, 2.9929269447E+01, 4.9947192689E+00, 1.3431061273E+01, 3.2459328965E+00, 9.6035164235E-01],
	[3.7200000000E+04, 2.9936204964E+01, 4.9947442304E+00, 1.3436954804E+01, 3.2463691222E+00, 9.6037004848E-01],
	[3.7205000000E+04, 2.9943141157E+01, 4.9947691887E+00, 1.3442850127E+01, 3.2468052366E+00, 9.6038844523E-01],
	[3.7210000000E+04, 2.9950078024E+01, 4.9947941438E+00, 1.3448747244E+01, 3.2472412397E+00, 9.6040683259E-01],
	[3.7215000000E+04, 2.9957015566E+01, 4.9948190956E+00, 1.3454646153E+01, 3.2476771314E+00, 9.6042521058E-01],
	[3.7220000000E+04, 2.9963953783E+01, 4.9948440443E+00, 1.3460546856E+01, 3.2481129119E+00, 9.6044357920E-01],
	[3.7225000000E+04, 2.9970892674E+01, 4.9948689896E+00, 1.3466449353E+01, 3.2485485811E+00, 9.6046193845E-01],
	[3.7230000000E+04, 2.9977832239E+01, 4.9948939318E+00, 1.3472353644E+01, 3.2489841390E+00, 9.6048028833E-01],
	[3.7235000000E+04, 2.9984772480E+01, 4.9949188707E+00, 1.3478259730E+01, 3.2494195857E+00, 9.6049862886E-01],
	[3.7240000000E+04, 2.9991713395E+01, 4.9949438064E+00, 1.3484167611E+01, 3.2498549211E+00, 9.6051696004E-01],
	[3.7245000000E+04, 2.9998654984E+01, 4.9949687389E+00, 1.3490077286E+01, 3.2502901454E+00, 9.6053528186E-01],
	[3.7250000000E+04, 3.0005597248E+01, 4.9949936682E+00, 1.3495988757E+01, 3.2507252585E+00, 9.6055359435E-01],
	[3.7255000000E+04, 3.0012540186E+01, 4.9950185942E+00, 1.3501902024E+01, 3.2511602604E+00, 9.6057189749E-01],
	[3.7260000000E+04, 3.0019483799E+01, 4.9950435171E+00, 1.3507817086E+01, 3.2515951511E+00, 9.6059019131E-01],
	[3.7265000000E+04, 3.0026428086E+01, 4.9950684367E+00, 1.3513733945E+01, 3.2520299307E+00, 9.6060847579E-01],
	[3.7270000000E+04, 3.0033373048E+01, 4.9950933530E+00, 1.3519652601E+01, 3.2524645992E+00, 9.6062675095E-01],
	[3.7275000000E+04, 3.0040318684E+01, 4.9951182662E+00, 1.3525573053E+01, 3.2528991566E+00, 9.6064501679E-01],
	[3.7280000000E+04, 3.0047264994E+01, 4.9951431761E+00, 1.3531495303E+01, 3.2533336030E+00, 9.6066327332E-01],
	[3.7285000000E+04, 3.0054211978E+01, 4.9951680829E+00, 1.3537419350E+01, 3.2537679382E+00, 9.6068152053E-01],
	[3.7290000000E+04, 3.0061159637E+01, 4.9951929864E+00, 1.3543345195E+01, 3.2542021625E+00, 9.6069975845E-01],
	[3.7295000000E+04, 3.0068107970E+01, 4.9952178867E+00, 1.3549272839E+01, 3.2546362757E+00, 9.6071798706E-01],
	[3.7300000000E+04, 3.0075056978E+01, 4.9952427838E+00, 1.3555202280E+01, 3.2550702779E+00, 9.6073620638E-01],
	[3.7305000000E+04, 3.0082006659E+01, 4.9952676777E+00, 1.3561133521E+01, 3.2555041691E+00, 9.6075441640E-01],
	[3.7310000000E+04, 3.0088957015E+01, 4.9952925683E+00, 1.3567066560E+01, 3.2559379493E+00, 9.6077261714E-01],
	[3.7315000000E+04, 3.0095908045E+01, 4.9953174558E+00, 1.3573001399E+01, 3.2563716186E+00, 9.6079080860E-01],
	[3.7320000000E+04, 3.0102859749E+01, 4.9953423400E+00, 1.3578938037E+01, 3.2568051770E+00, 9.6080899079E-01],
	[3.7325000000E+04, 3.0109812127E+01, 4.9953672210E+00, 1.3584876476E+01, 3.2572386245E+00, 9.6082716370E-01],
	[3.7330000000E+04, 3.0116765180E+01, 4.9953920988E+00, 1.3590816714E+01, 3.2576719610E+00, 9.6084532735E-01],
	[3.7335000000E+04, 3.0123718906E+01, 4.9954169735E+00, 1.3596758753E+01, 3.2581051867E+00, 9.6086348173E-01],
	[3.7340000000E+04, 3.0130673306E+01, 4.9954418449E+00, 1.3602702594E+01, 3.2585383015E+00, 9.6088162686E-01],
	[3.7345000000E+04, 3.0137628381E+01, 4.9954667131E+00, 1.3608648235E+01, 3.2589713055E+00, 9.6089976274E-01],
	[3.7350000000E+04, 3.0144584129E+01, 4.9954915781E+00, 1.3614595678E+01, 3.2594041986E+00, 9.6091788937E-01],
	[3.7355000000E+04, 3.0151540551E+01, 4.9955164398E+00, 1.3620544922E+01, 3.2598369810E+00, 9.6093600676E-01],
	[3.7360000000E+04, 3.0158497648E+01, 4.9955412984E+00, 1.3626495969E+01, 3.2602696525E+00, 9.6095411491E-01],
	[3.7365000000E+04, 3.0165455418E+01, 4.9955661538E+00, 1.3632448818E+01, 3.2607022133E+00, 9.6097221382E-01],
	[3.7370000000E+04, 3.0172413862E+01, 4.9955910060E+00, 1.3638403469E+01, 3.2611346634E+00, 9.6099030351E-01],
	[3.7375000000E+04, 3.0179372980E+01, 4.9956158550E+00, 1.3644359924E+01, 3.2615670027E+00, 9.6100838398E-01],
	[3.7380000000E+04, 3.0186332772E+01, 4.9956407007E+00, 1.3650318182E+01, 3.2619992313E+00, 9.6102645523E-01],
	[3.7385000000E+04, 3.0193293237E+01, 4.9956655433E+00, 1.3656278244E+01, 3.2624313492E+00, 9.6104451726E-01],
	[3.7390000000E+04, 3.0200254377E+01, 4.9956903827E+00, 1.3662240109E+01, 3.2628633564E+00, 9.6106257008E-01],
	[3.7395000000E+04, 3.0207216190E+01, 4.9957152189E+00, 1.3668203779E+01, 3.2632952530E+00, 9.6108061371E-01],
	[3.7400000000E+04, 3.0214178677E+01, 4.9957400519E+00, 1.3674169253E+01, 3.2637270389E+00, 9.6109864813E-01],
	[3.7405000000E+04, 3.0221155589E+01, 4.9957666186E+00, 1.3680136532E+01, 3.2641596162E+00, 9.6111667335E-01],
	[3.7410000000E+04, 3.0228137390E+01, 4.9957937138E+00, 1.3686105617E+01, 3.2645923593E+00, 9.6113468939E-01],
	[3.7415000000E+04, 3.0235119872E+01, 4.9958208055E+00, 1.3692076506E+01, 3.2650249923E+00, 9.6115269624E-01],
	[3.7420000000E+04, 3.0242103032E+01, 4.9958478937E+00, 1.3698049202E+01, 3.2654575150E+00, 9.6117069392E-01],
	[3.7425000000E+04, 3.0249086872E+01, 4.9958749785E+00, 1.3704023703E+01, 3.2658899276E+00, 9.6118868241E-01],
	[3.7430000000E+04, 3.0256071392E+01, 4.9959020597E+00, 1.3710000011E+01, 3.2663222299E+00, 9.6120666174E-01],
	[3.7435000000E+04, 3.0263056591E+01, 4.9959291376E+00, 1.3715978125E+01, 3.2667544221E+00, 9.6122463190E-01],
	[3.7440000000E+04, 3.0270042470E+01, 4.9959562119E+00, 1.3721958047E+01, 3.2671865042E+00, 9.6124259290E-01],
	[3.7445000000E+04, 3.0277029028E+01, 4.9959832828E+00, 1.3727939775E+01, 3.2676184762E+00, 9.6126054475E-01],
	[3.7450000000E+04, 3.0284016265E+01, 4.9960103502E+00, 1.3733923312E+01, 3.2680503381E+00, 9.6127848744E-01],
	[3.7455000000E+04, 3.0291004182E+01, 4.9960374141E+00, 1.3739908656E+01, 3.2684820899E+00, 9.6129642098E-01],
	[3.7460000000E+04, 3.0297992778E+01, 4.9960644746E+00, 1.3745895808E+01, 3.2689137316E+00, 9.6131434539E-01],
	[3.7465000000E+04, 3.0304982053E+01, 4.9960915316E+00, 1.3751884769E+01, 3.2693452633E+00, 9.6133226066E-01],
	[3.7470000000E+04, 3.0311972008E+01, 4.9961185852E+00, 1.3757875538E+01, 3.2697766850E+00, 9.6135016679E-01],
	[3.7475000000E+04, 3.0318962642E+01, 4.9961456352E+00, 1.3763868117E+01, 3.2702079967E+00, 9.6136806380E-01],
	[3.7480000000E+04, 3.0325953955E+01, 4.9961726819E+00, 1.3769862505E+01, 3.2706391983E+00, 9.6138595168E-01],
	[3.7485000000E+04, 3.0332945947E+01, 4.9961997250E+00, 1.3775858703E+01, 3.2710702900E+00, 9.6140383045E-01],
	[3.7490000000E+04, 3.0339938619E+01, 4.9962267647E+00, 1.3781856710E+01, 3.2715012718E+00, 9.6142170010E-01],
	[3.7495000000E+04, 3.0346931969E+01, 4.9962538010E+00, 1.3787856528E+01, 3.2719321436E+00, 9.6143956065E-01],
	[3.7500000000E+04, 3.0353925999E+01, 4.9962808337E+00, 1.3793858157E+01, 3.2723629056E+00, 9.6145741209E-01],
	[3.7505000000E+04, 3.0360920708E+01, 4.9963078631E+00, 1.3799861596E+01, 3.2727935576E+00, 9.6147525443E-01],
	[3.7510000000E+04, 3.0367916096E+01, 4.9963348889E+00, 1.3805866847E+01, 3.2732240997E+00, 9.6149308768E-01],
	[3.7515000000E+04, 3.0374912163E+01, 4.9963619113E+00, 1.3811873909E+01, 3.2736545320E+00, 9.6151091184E-01],
	[3.7520000000E+04, 3.0381908909E+01, 4.9963889303E+00, 1.3817882784E+01, 3.2740848545E+00, 9.6152872692E-01],
	[3.7525000000E+04, 3.0388906334E+01, 4.9964159458E+00, 1.3823893470E+01, 3.2745150671E+00, 9.6154653291E-01],
	[3.7530000000E+04, 3.0395904439E+01, 4.9964429578E+00, 1.3829905968E+01, 3.2749451699E+00, 9.6156432983E-01],
	[3.7535000000E+04, 3.0402903222E+01, 4.9964699664E+00, 1.3835920280E+01, 3.2753751630E+00, 9.6158211768E-01],
	[3.7540000000E+04, 3.0409902684E+01, 4.9964969716E+00, 1.3841936404E+01, 3.2758050463E+00, 9.6159989647E-01],
	[3.7545000000E+04, 3.0416902825E+01, 4.9965239733E+00, 1.3847954342E+01, 3.2762348198E+00, 9.6161766619E-01],
	[3.7550000000E+04, 3.0423903644E+01, 4.9965509715E+00, 1.3853974094E+01, 3.2766644836E+00, 9.6163542686E-01],
	[3.7555000000E+04, 3.0430905143E+01, 4.9965779663E+00, 1.3859995659E+01, 3.2770940377E+00, 9.6165317848E-01],
	[3.7560000000E+04, 3.0437907321E+01, 4.9966049576E+00, 1.3866019039E+01, 3.2775234821E+00, 9.6167092105E-01],
	[3.7565000000E+04, 3.0444910177E+01, 4.9966319455E+00, 1.3872044233E+01, 3.2779528168E+00, 9.6168865458E-01],
	[3.7570000000E+04, 3.0451913712E+01, 4.9966589300E+00, 1.3878071242E+01, 3.2783820419E+00, 9.6170637907E-01],
	[3.7575000000E+04, 3.0458917926E+01, 4.9966859110E+00, 1.3884100066E+01, 3.2788111573E+00, 9.6172409453E-01],
	[3.7580000000E+04, 3.0465922818E+01, 4.9967128886E+00, 1.3890130706E+01, 3.2792401632E+00, 9.6174180096E-01],
	[3.7585000000E+04, 3.0472928390E+01, 4.9967398627E+00, 1.3896163162E+01, 3.2796690594E+00, 9.6175949837E-01],
	[3.7590000000E+04, 3.0479934640E+01, 4.9967668334E+00, 1.3902197434E+01, 3.2800978460E+00, 9.6177718676E-01],
	[3.7595000000E+04, 3.0486941569E+01, 4.9967938006E+00, 1.3908233522E+01, 3.2805265231E+00, 9.6179486614E-01],
	[3.7600000000E+04, 3.0493949176E+01, 4.9968207644E+00, 1.3914271426E+01, 3.2809550907E+00, 9.6181253652E-01],
	[3.7605000000E+04, 3.0500957462E+01, 4.9968477247E+00, 1.3920311148E+01, 3.2813835487E+00, 9.6183019788E-01],
	[3.7610000000E+04, 3.0507966426E+01, 4.9968746816E+00, 1.3926352687E+01, 3.2818118972E+00, 9.6184785025E-01],
	[3.7615000000E+04, 3.0514976070E+01, 4.9969016351E+00, 1.3932396044E+01, 3.2822401363E+00, 9.6186549363E-01],
	[3.7620000000E+04, 3.0521986391E+01, 4.9969285852E+00, 1.3938441219E+01, 3.2826682658E+00, 9.6188312801E-01],
	[3.7625000000E+04, 3.0528997391E+01, 4.9969555318E+00, 1.3944488211E+01, 3.2830962859E+00, 9.6190075342E-01],
	[3.7630000000E+04, 3.0536009070E+01, 4.9969824749E+00, 1.3950537023E+01, 3.2835241966E+00, 9.6191836984E-01],
	[3.7635000000E+04, 3.0543021427E+01, 4.9970094147E+00, 1.3956587653E+01, 3.2839519979E+00, 9.6193597728E-01],
	[3.7640000000E+04, 3.0550034463E+01, 4.9970363510E+00, 1.3962640102E+01, 3.2843796898E+00, 9.6195357576E-01],
	[3.7645000000E+04, 3.0557048177E+01, 4.9970632838E+00, 1.3968694371E+01, 3.2848072723E+00, 9.6197116527E-01],
	[3.7650000000E+04, 3.0564062569E+01, 4.9970902133E+00, 1.3974750460E+01, 3.2852347454E+00, 9.6198874582E-01],
	[3.7655000000E+04, 3.0571077640E+01, 4.9971171393E+00, 1.3980808368E+01, 3.2856621093E+00, 9.6200631742E-01],
	[3.7660000000E+04, 3.0578093389E+01, 4.9971440618E+00, 1.3986868097E+01, 3.2860893638E+00, 9.6202388006E-01],
	[3.7665000000E+04, 3.0585109817E+01, 4.9971709810E+00, 1.3992929647E+01, 3.2865165090E+00, 9.6204143376E-01],
	[3.7670000000E+04, 3.0592126923E+01, 4.9971978967E+00, 1.3998993018E+01, 3.2869435449E+00, 9.6205897851E-01],
	[3.7675000000E+04, 3.0599144707E+01, 4.9972248090E+00, 1.4005058210E+01, 3.2873704715E+00, 9.6207651433E-01],
	[3.7680000000E+04, 3.0606163169E+01, 4.9972517179E+00, 1.4011125223E+01, 3.2877972890E+00, 9.6209404122E-01],
	[3.7685000000E+04, 3.0613182309E+01, 4.9972786233E+00, 1.4017194058E+01, 3.2882239972E+00, 9.6211155918E-01],
	[3.7690000000E+04, 3.0620202128E+01, 4.9973055253E+00, 1.4023264716E+01, 3.2886505962E+00, 9.6212906821E-01],
	[3.7695000000E+04, 3.0627222625E+01, 4.9973324239E+00, 1.4029337196E+01, 3.2890770860E+00, 9.6214656833E-01],
	[3.7700000000E+04, 3.0634243800E+01, 4.9973593191E+00, 1.4035411499E+01, 3.2895034666E+00, 9.6216405953E-01],
	[3.7705000000E+04, 3.0641265653E+01, 4.9973862108E+00, 1.4041487625E+01, 3.2899297381E+00, 9.6218154183E-01],
	[3.7710000000E+04, 3.0648288185E+01, 4.9974130991E+00, 1.4047565574E+01, 3.2903559005E+00, 9.6219901522E-01],
	[3.7715000000E+04, 3.0655311394E+01, 4.9974399840E+00, 1.4053645347E+01, 3.2907819537E+00, 9.6221647972E-01],
	[3.7720000000E+04, 3.0662335281E+01, 4.9974668655E+00, 1.4059726944E+01, 3.2912078979E+00, 9.6223393532E-01],
	[3.7725000000E+04, 3.0669359847E+01, 4.9974937436E+00, 1.4065810366E+01, 3.2916337330E+00, 9.6225138203E-01],
	[3.7730000000E+04, 3.0676385090E+01, 4.9975206182E+00, 1.4071895612E+01, 3.2920594590E+00, 9.6226881985E-01],
	[3.7735000000E+04, 3.0683411012E+01, 4.9975474894E+00, 1.4077982682E+01, 3.2924850760E+00, 9.6228624879E-01],
	[3.7740000000E+04, 3.0690437611E+01, 4.9975743573E+00, 1.4084071579E+01, 3.2929105840E+00, 9.6230366886E-01],
	[3.7745000000E+04, 3.0697464889E+01, 4.9976012217E+00, 1.4090162300E+01, 3.2933359830E+00, 9.6232108006E-01],
	[3.7750000000E+04, 3.0704492844E+01, 4.9976280826E+00, 1.4096254848E+01, 3.2937612730E+00, 9.6233848240E-01],
	[3.7755000000E+04, 3.0711521477E+01, 4.9976549402E+00, 1.4102349222E+01, 3.2941864540E+00, 9.6235587587E-01],
	[3.7760000000E+04, 3.0718550788E+01, 4.9976817944E+00, 1.4108445422E+01, 3.2946115262E+00, 9.6237326048E-01],
	[3.7765000000E+04, 3.0725580777E+01, 4.9977086451E+00, 1.4114543449E+01, 3.2950364894E+00, 9.6239063625E-01],
	[3.7770000000E+04, 3.0732611443E+01, 4.9977354925E+00, 1.4120643303E+01, 3.2954613436E+00, 9.6240800316E-01],
	[3.7775000000E+04, 3.0739642788E+01, 4.9977623364E+00, 1.4126744984E+01, 3.2958860891E+00, 9.6242536124E-01],
	[3.7780000000E+04, 3.0746674810E+01, 4.9977891769E+00, 1.4132848493E+01, 3.2963107256E+00, 9.6244271047E-01],
	[3.7785000000E+04, 3.0753707510E+01, 4.9978160140E+00, 1.4138953830E+01, 3.2967352533E+00, 9.6246005088E-01],
	[3.7790000000E+04, 3.0760740888E+01, 4.9978428477E+00, 1.4145060996E+01, 3.2971596722E+00, 9.6247738245E-01],
	[3.7795000000E+04, 3.0767774943E+01, 4.9978696780E+00, 1.4151169990E+01, 3.2975839823E+00, 9.6249470521E-01],
	[3.7800000000E+04, 3.0774809676E+01, 4.9978965049E+00, 1.4157280813E+01, 3.2980081836E+00, 9.6251201914E-01],
	[3.7805000000E+04, 3.0781845087E+01, 4.9979233284E+00, 1.4163393465E+01, 3.2984322761E+00, 9.6252932426E-01],
	[3.7810000000E+04, 3.0788881175E+01, 4.9979501485E+00, 1.4169507946E+01, 3.2988562598E+00, 9.6254662057E-01],
	[3.7815000000E+04, 3.0795917941E+01, 4.9979769652E+00, 1.4175624258E+01, 3.2992801349E+00, 9.6256390808E-01],
	[3.7820000000E+04, 3.0802955384E+01, 4.9980037784E+00, 1.4181742399E+01, 3.2997039012E+00, 9.6258118678E-01],
	[3.7825000000E+04, 3.0809993505E+01, 4.9980305883E+00, 1.4187862371E+01, 3.3001275589E+00, 9.6259845670E-01],
	[3.7830000000E+04, 3.0817032304E+01, 4.9980573948E+00, 1.4193984174E+01, 3.3005511078E+00, 9.6261571782E-01],
	[3.7835000000E+04, 3.0824071780E+01, 4.9980841979E+00, 1.4200107807E+01, 3.3009745481E+00, 9.6263297015E-01],
	[3.7840000000E+04, 3.0831111933E+01, 4.9981109976E+00, 1.4206233272E+01, 3.3013978798E+00, 9.6265021371E-01],
	[3.7845000000E+04, 3.0838152764E+01, 4.9981377939E+00, 1.4212360569E+01, 3.3018211029E+00, 9.6266744849E-01],
	[3.7850000000E+04, 3.0845194272E+01, 4.9981645867E+00, 1.4218489698E+01, 3.3022442174E+00, 9.6268467449E-01],
	[3.7855000000E+04, 3.0852236458E+01, 4.9981913762E+00, 1.4224620658E+01, 3.3026672232E+00, 9.6270189173E-01],
	[3.7860000000E+04, 3.0859279321E+01, 4.9982181623E+00, 1.4230753452E+01, 3.3030901206E+00, 9.6271910021E-01],
	[3.7865000000E+04, 3.0866322862E+01, 4.9982449450E+00, 1.4236888078E+01, 3.3035129094E+00, 9.6273629993E-01],
	[3.7870000000E+04, 3.0873367079E+01, 4.9982717244E+00, 1.4243024538E+01, 3.3039355897E+00, 9.6275349090E-01],
	[3.7875000000E+04, 3.0880411974E+01, 4.9982985003E+00, 1.4249162831E+01, 3.3043581614E+00, 9.6277067312E-01],
	[3.7880000000E+04, 3.0887457547E+01, 4.9983252728E+00, 1.4255302957E+01, 3.3047806248E+00, 9.6278784660E-01],
	[3.7885000000E+04, 3.0894503796E+01, 4.9983520419E+00, 1.4261444918E+01, 3.3052029796E+00, 9.6280501134E-01],
	[3.7890000000E+04, 3.0901550723E+01, 4.9983788077E+00, 1.4267588713E+01, 3.3056252260E+00, 9.6282216734E-01],
	[3.7895000000E+04, 3.0908598327E+01, 4.9984055701E+00, 1.4273734343E+01, 3.3060473640E+00, 9.6283931462E-01],
	[3.7900000000E+04, 3.0915646608E+01, 4.9984323290E+00, 1.4279881808E+01, 3.3064693935E+00, 9.6285645317E-01],
	[3.7905000000E+04, 3.0922695567E+01, 4.9984590846E+00, 1.4286031108E+01, 3.3068913147E+00, 9.6287358300E-01],
	[3.7910000000E+04, 3.0929745202E+01, 4.9984858368E+00, 1.4292182244E+01, 3.3073131276E+00, 9.6289070412E-01],
	[3.7915000000E+04, 3.0936795515E+01, 4.9985125856E+00, 1.4298335216E+01, 3.3077348320E+00, 9.6290781653E-01],
	[3.7920000000E+04, 3.0943846505E+01, 4.9985393311E+00, 1.4304490024E+01, 3.3081564282E+00, 9.6292492023E-01],
	[3.7925000000E+04, 3.0950898171E+01, 4.9985660731E+00, 1.4310646669E+01, 3.3085779160E+00, 9.6294201523E-01],
	[3.7930000000E+04, 3.0957950515E+01, 4.9985928118E+00, 1.4316805150E+01, 3.3089992956E+00, 9.6295910153E-01],
	[3.7935000000E+04, 3.0965003536E+01, 4.9986195471E+00, 1.4322965468E+01, 3.3094205669E+00, 9.6297617914E-01],
	[3.7940000000E+04, 3.0972057234E+01, 4.9986462790E+00, 1.4329127624E+01, 3.3098417299E+00, 9.6299324807E-01],
	[3.7945000000E+04, 3.0979111608E+01, 4.9986730075E+00, 1.4335291618E+01, 3.3102627848E+00, 9.6301030831E-01],
	[3.7950000000E+04, 3.0986166660E+01, 4.9986997326E+00, 1.4341457450E+01, 3.3106837314E+00, 9.6302735988E-01],
	[3.7955000000E+04, 3.0993222389E+01, 4.9987264544E+00, 1.4347625120E+01, 3.3111045698E+00, 9.6304440277E-01],
	[3.7960000000E+04, 3.1000278794E+01, 4.9987531728E+00, 1.4353794629E+01, 3.3115253000E+00, 9.6306143700E-01],
	[3.7965000000E+04, 3.1007335876E+01, 4.9987798878E+00, 1.4359965976E+01, 3.3119459221E+00, 9.6307846256E-01],
	[3.7970000000E+04, 3.1014393635E+01, 4.9988065994E+00, 1.4366139163E+01, 3.3123664361E+00, 9.6309547946E-01],
	[3.7975000000E+04, 3.1021452071E+01, 4.9988333077E+00, 1.4372314190E+01, 3.3127868419E+00, 9.6311248771E-01],
	[3.7980000000E+04, 3.1028511184E+01, 4.9988600126E+00, 1.4378491057E+01, 3.3132071397E+00, 9.6312948731E-01],
	[3.7985000000E+04, 3.1035570974E+01, 4.9988867141E+00, 1.4384669763E+01, 3.3136273294E+00, 9.6314647826E-01],
	[3.7990000000E+04, 3.1042631440E+01, 4.9989134123E+00, 1.4390850311E+01, 3.3140474110E+00, 9.6316346058E-01],
	[3.7995000000E+04, 3.1049692583E+01, 4.9989401070E+00, 1.4397032699E+01, 3.3144673846E+00, 9.6318043426E-01],
	[3.8000000000E+04, 3.1056754403E+01, 4.9989667984E+00, 1.4403216928E+01, 3.3148872502E+00, 9.6319739931E-01],
	[3.8005000000E+04, 3.1063823003E+01, 4.9989942502E+00, 1.4409402998E+01, 3.3153074132E+00, 9.6321435573E-01],
	[3.8010000000E+04, 3.1070903926E+01, 4.9990231549E+00, 1.4415590911E+01, 3.3157282417E+00, 9.6323130353E-01],
	[3.8015000000E+04, 3.1077985531E+01, 4.9990520560E+00, 1.4421780665E+01, 3.3161489626E+00, 9.6324824272E-01],
	[3.8020000000E+04, 3.1085067819E+01, 4.9990809534E+00, 1.4427972261E+01, 3.3165695758E+00, 9.6326517329E-01],
	[3.8025000000E+04, 3.1092150789E+01, 4.9991098472E+00, 1.4434165701E+01, 3.3169900815E+00, 9.6328209526E-01],
	[3.8030000000E+04, 3.1099234441E+01, 4.9991387374E+00, 1.4440360983E+01, 3.3174104797E+00, 9.6329900862E-01],
	[3.8035000000E+04, 3.1106318775E+01, 4.9991676239E+00, 1.4446558108E+01, 3.3178307703E+00, 9.6331591338E-01],
	[3.8040000000E+04, 3.1113403792E+01, 4.9991965068E+00, 1.4452757077E+01, 3.3182509533E+00, 9.6333280956E-01],
	[3.8045000000E+04, 3.1120489491E+01, 4.9992253861E+00, 1.4458957890E+01, 3.3186710289E+00, 9.6334969714E-01],
	[3.8050000000E+04, 3.1127575872E+01, 4.9992542618E+00, 1.4465160547E+01, 3.3190909970E+00, 9.6336657614E-01],
	[3.8055000000E+04, 3.1134662935E+01, 4.9992831338E+00, 1.4471365049E+01, 3.3195108576E+00, 9.6338344656E-01],
	[3.8060000000E+04, 3.1141750680E+01, 4.9993120022E+00, 1.4477571395E+01, 3.3199306108E+00, 9.6340030840E-01],
	[3.8065000000E+04, 3.1148839108E+01, 4.9993408670E+00, 1.4483779587E+01, 3.3203502566E+00, 9.6341716168E-01],
	[3.8070000000E+04, 3.1155928217E+01, 4.9993697281E+00, 1.4489989623E+01, 3.3207697949E+00, 9.6343400639E-01],
	[3.8075000000E+04, 3.1163018009E+01, 4.9993985857E+00, 1.4496201506E+01, 3.3211892259E+00, 9.6345084254E-01],
	[3.8080000000E+04, 3.1170108483E+01, 4.9994274396E+00, 1.4502415234E+01, 3.3216085495E+00, 9.6346767013E-01],
	[3.8085000000E+04, 3.1177199639E+01, 4.9994562899E+00, 1.4508630809E+01, 3.3220277658E+00, 9.6348448918E-01],
	[3.8090000000E+04, 3.1184291476E+01, 4.9994851365E+00, 1.4514848231E+01, 3.3224468747E+00, 9.6350129967E-01],
	[3.8095000000E+04, 3.1191383996E+01, 4.9995139796E+00, 1.4521067499E+01, 3.3228658764E+00, 9.6351810163E-01],
	[3.8100000000E+04, 3.1198477198E+01, 4.9995428190E+00, 1.4527288615E+01, 3.3232847707E+00, 9.6353489504E-01],
	[3.8105000000E+04, 3.1205571082E+01, 4.9995716548E+00, 1.4533511578E+01, 3.3237035578E+00, 9.6355167993E-01],
	[3.8110000000E+04, 3.1212665647E+01, 4.9996004870E+00, 1.4539736389E+01, 3.3241222376E+00, 9.6356845628E-01],
	[3.8115000000E+04, 3.1219760895E+01, 4.9996293156E+00, 1.4545963048E+01, 3.3245408102E+00, 9.6358522412E-01],
	[3.8120000000E+04, 3.1226856824E+01, 4.9996581405E+00, 1.4552191555E+01, 3.3249592756E+00, 9.6360198343E-01],
	[3.8125000000E+04, 3.1233953435E+01, 4.9996869619E+00, 1.4558421911E+01, 3.3253776338E+00, 9.6361873423E-01],
	[3.8130000000E+04, 3.1241050728E+01, 4.9997157796E+00, 1.4564654117E+01, 3.3257958848E+00, 9.6363547652E-01],
	[3.8135000000E+04, 3.1248148703E+01, 4.9997445937E+00, 1.4570888172E+01, 3.3262140287E+00, 9.6365221030E-01],
	[3.8140000000E+04, 3.1255247360E+01, 4.9997734042E+00, 1.4577124076E+01, 3.3266320655E+00, 9.6366893559E-01],
	[3.8145000000E+04, 3.1262346698E+01, 4.9998022111E+00, 1.4583361830E+01, 3.3270499951E+00, 9.6368565238E-01],
	[3.8150000000E+04, 3.1269446718E+01, 4.9998310144E+00, 1.4589601435E+01, 3.3274678177E+00, 9.6370236068E-01],
	[3.8155000000E+04, 3.1276547420E+01, 4.9998598141E+00, 1.4595842890E+01, 3.3278855331E+00, 9.6371906049E-01],
	[3.8160000000E+04, 3.1283648803E+01, 4.9998886101E+00, 1.4602086196E+01, 3.3283031416E+00, 9.6373575182E-01],
	[3.8165000000E+04, 3.1290750868E+01, 4.9999174026E+00, 1.4608331354E+01, 3.3287206430E+00, 9.6375243468E-01],
	[3.8170000000E+04, 3.1297853615E+01, 4.9999461914E+00, 1.4614578362E+01, 3.3291380373E+00, 9.6376910906E-01],
	[3.8175000000E+04, 3.1304957043E+01, 4.9999749767E+00, 1.4620827223E+01, 3.3295553247E+00, 9.6378577497E-01],
	[3.8180000000E+04, 3.1312061153E+01, 5.0000037583E+00, 1.4627077936E+01, 3.3299725051E+00, 9.6380243242E-01],
	[3.8185000000E+04, 3.1319165944E+01, 5.0000325364E+00, 1.4633330501E+01, 3.3303895786E+00, 9.6381908142E-01],
	[3.8190000000E+04, 3.1326271417E+01, 5.0000613108E+00, 1.4639584919E+01, 3.3308065451E+00, 9.6383572195E-01],
	[3.8195000000E+04, 3.1333377571E+01, 5.0000900817E+00, 1.4645841190E+01, 3.3312234047E+00, 9.6385235404E-01],
	[3.8200000000E+04, 3.1340484407E+01, 5.0001188489E+00, 1.4652099314E+01, 3.3316401574E+00, 9.6386897769E-01],
	[3.8205000000E+04, 3.1347591925E+01, 5.0001476125E+00, 1.4658359292E+01, 3.3320568033E+00, 9.6388559289E-01],
	[3.8210000000E+04, 3.1354700123E+01, 5.0001763726E+00, 1.4664621124E+01, 3.3324733422E+00, 9.6390219966E-01],
	[3.8215000000E+04, 3.1361809004E+01, 5.0002051290E+00, 1.4670884810E+01, 3.3328897744E+00, 9.6391879800E-01],
	[3.8220000000E+04, 3.1368918565E+01, 5.0002338819E+00, 1.4677150351E+01, 3.3333060997E+00, 9.6393538792E-01],
	[3.8225000000E+04, 3.1376028808E+01, 5.0002626311E+00, 1.4683417747E+01, 3.3337223182E+00, 9.6395196941E-01],
	[3.8230000000E+04, 3.1383139732E+01, 5.0002913768E+00, 1.4689686997E+01, 3.3341384300E+00, 9.6396854248E-01],
	[3.8235000000E+04, 3.1390251338E+01, 5.0003201188E+00, 1.4695958104E+01, 3.3345544350E+00, 9.6398510714E-01],
	[3.8240000000E+04, 3.1397363625E+01, 5.0003488573E+00, 1.4702231066E+01, 3.3349703332E+00, 9.6400166340E-01],
	[3.8245000000E+04, 3.1404476593E+01, 5.0003775922E+00, 1.4708505884E+01, 3.3353861248E+00, 9.6401821125E-01],
	[3.8250000000E+04, 3.1411590243E+01, 5.0004063234E+00, 1.4714782558E+01, 3.3358018096E+00, 9.6403475071E-01],
	[3.8255000000E+04, 3.1418704573E+01, 5.0004350511E+00, 1.4721061090E+01, 3.3362173878E+00, 9.6405128177E-01],
	[3.8260000000E+04, 3.1425819585E+01, 5.0004637752E+00, 1.4727341478E+01, 3.3366328593E+00, 9.6406780444E-01],
	[3.8265000000E+04, 3.1432935278E+01, 5.0004924958E+00, 1.4733623724E+01, 3.3370482241E+00, 9.6408431872E-01],
	[3.8270000000E+04, 3.1440051652E+01, 5.0005212127E+00, 1.4739907827E+01, 3.3374634824E+00, 9.6410082463E-01],
	[3.8275000000E+04, 3.1447168707E+01, 5.0005499260E+00, 1.4746193788E+01, 3.3378786340E+00, 9.6411732216E-01],
	[3.8280000000E+04, 3.1454286444E+01, 5.0005786358E+00, 1.4752481607E+01, 3.3382936791E+00, 9.6413381132E-01],
	[3.8285000000E+04, 3.1461404861E+01, 5.0006073419E+00, 1.4758771285E+01, 3.3387086176E+00, 9.6415029211E-01],
	[3.8290000000E+04, 3.1468523960E+01, 5.0006360445E+00, 1.4765062822E+01, 3.3391234496E+00, 9.6416676455E-01],
	[3.8295000000E+04, 3.1475643739E+01, 5.0006647435E+00, 1.4771356218E+01, 3.3395381750E+00, 9.6418322862E-01],
	[3.8300000000E+04, 3.1482764200E+01, 5.0006934390E+00, 1.4777651474E+01, 3.3399527940E+00, 9.6419968435E-01],
	[3.8305000000E+04, 3.1489885341E+01, 5.0007221308E+00, 1.4783948589E+01, 3.3403673064E+00, 9.6421613172E-01],
	[3.8310000000E+04, 3.1497007164E+01, 5.0007508190E+00, 1.4790247564E+01, 3.3407817124E+00, 9.6423257076E-01],
	[3.8315000000E+04, 3.1504129667E+01, 5.0007795037E+00, 1.4796548400E+01, 3.3411960120E+00, 9.6424900145E-01],
	[3.8320000000E+04, 3.1511252851E+01, 5.0008081848E+00, 1.4802851096E+01, 3.3416102051E+00, 9.6426542381E-01],
	[3.8325000000E+04, 3.1518376716E+01, 5.0008368624E+00, 1.4809155653E+01, 3.3420242919E+00, 9.6428183784E-01],
	[3.8330000000E+04, 3.1525501262E+01, 5.0008655363E+00, 1.4815462072E+01, 3.3424382723E+00, 9.6429824355E-01],
	[3.8335000000E+04, 3.1532626489E+01, 5.0008942067E+00, 1.4821770352E+01, 3.3428521463E+00, 9.6431464093E-01],
	[3.8340000000E+04, 3.1539752397E+01, 5.0009228735E+00, 1.4828080494E+01, 3.3432659139E+00, 9.6433103001E-01],
	[3.8345000000E+04, 3.1546878986E+01, 5.0009515367E+00, 1.4834392499E+01, 3.3436795752E+00, 9.6434741076E-01],
	[3.8350000000E+04, 3.1554006255E+01, 5.0009801963E+00, 1.4840706366E+01, 3.3440931303E+00, 9.6436378322E-01],
	[3.8355000000E+04, 3.1561134205E+01, 5.0010088524E+00, 1.4847022096E+01, 3.3445065790E+00, 9.6438014737E-01],
	[3.8360000000E+04, 3.1568262836E+01, 5.0010375049E+00, 1.4853339688E+01, 3.3449199215E+00, 9.6439650322E-01],
	[3.8365000000E+04, 3.1575392147E+01, 5.0010661538E+00, 1.4859659145E+01, 3.3453331578E+00, 9.6441285079E-01],
	[3.8370000000E+04, 3.1582522139E+01, 5.0010947992E+00, 1.4865980465E+01, 3.3457462878E+00, 9.6442919006E-01],
	[3.8375000000E+04, 3.1589652812E+01, 5.0011234410E+00, 1.4872303649E+01, 3.3461593117E+00, 9.6444552105E-01],
	[3.8380000000E+04, 3.1596784165E+01, 5.0011520792E+00, 1.4878628697E+01, 3.3465722293E+00, 9.6446184376E-01],
	[3.8385000000E+04, 3.1603916199E+01, 5.0011807139E+00, 1.4884955611E+01, 3.3469850408E+00, 9.6447815820E-01],
	[3.8390000000E+04, 3.1611048914E+01, 5.0012093450E+00, 1.4891284389E+01, 3.3473977461E+00, 9.6449446436E-01],
	[3.8395000000E+04, 3.1618182309E+01, 5.0012379725E+00, 1.4897615032E+01, 3.3478103454E+00, 9.6451076226E-01],
	[3.8400000000E+04, 3.1625316384E+01, 5.0012665965E+00, 1.4903947541E+01, 3.3482228385E+00, 9.6452705189E-01],
	[3.8405000000E+04, 3.1632451140E+01, 5.0012952169E+00, 1.4910281916E+01, 3.3486352255E+00, 9.6454333327E-01],
	[3.8410000000E+04, 3.1639586577E+01, 5.0013238337E+00, 1.4916618157E+01, 3.3490475065E+00, 9.6455960639E-01],
	[3.8415000000E+04, 3.1646722694E+01, 5.0013524470E+00, 1.4922956265E+01, 3.3494596814E+00, 9.6457587126E-01],
	[3.8420000000E+04, 3.1653859492E+01, 5.0013810567E+00, 1.4929296239E+01, 3.3498717504E+00, 9.6459212789E-01],
	[3.8425000000E+04, 3.1660996970E+01, 5.0014096629E+00, 1.4935638081E+01, 3.3502837133E+00, 9.6460837627E-01],
	[3.8430000000E+04, 3.1668135128E+01, 5.0014382655E+00, 1.4941981790E+01, 3.3506955702E+00, 9.6462461642E-01],
	[3.8435000000E+04, 3.1675273967E+01, 5.0014668646E+00, 1.4948327367E+01, 3.3511073212E+00, 9.6464084833E-01],
	[3.8440000000E+04, 3.1682413486E+01, 5.0014954600E+00, 1.4954674811E+01, 3.3515189662E+00, 9.6465707201E-01],
	[3.8445000000E+04, 3.1689553685E+01, 5.0015240520E+00, 1.4961024125E+01, 3.3519305053E+00, 9.6467328747E-01],
	[3.8450000000E+04, 3.1696694564E+01, 5.0015526404E+00, 1.4967375306E+01, 3.3523419385E+00, 9.6468949470E-01],
	[3.8455000000E+04, 3.1703836124E+01, 5.0015812252E+00, 1.4973728357E+01, 3.3527532659E+00, 9.6470569372E-01],
	[3.8460000000E+04, 3.1710978365E+01, 5.0016098065E+00, 1.4980083277E+01, 3.3531644873E+00, 9.6472188453E-01],
	[3.8465000000E+04, 3.1718121285E+01, 5.0016383842E+00, 1.4986440067E+01, 3.3535756030E+00, 9.6473806713E-01],
	[3.8470000000E+04, 3.1725264885E+01, 5.0016669583E+00, 1.4992798726E+01, 3.3539866128E+00, 9.6475424152E-01],
	[3.8475000000E+04, 3.1732409166E+01, 5.0016955290E+00, 1.4999159256E+01, 3.3543975168E+00, 9.6477040771E-01],
	[3.8480000000E+04, 3.1739554127E+01, 5.0017240960E+00, 1.5005521656E+01, 3.3548083150E+00, 9.6478656571E-01],
	[3.8485000000E+04, 3.1746699768E+01, 5.0017526595E+00, 1.5011885927E+01, 3.3552190075E+00, 9.6480271552E-01],
	[3.8490000000E+04, 3.1753846089E+01, 5.0017812195E+00, 1.5018252069E+01, 3.3556295942E+00, 9.6481885713E-01],
	[3.8495000000E+04, 3.1760993090E+01, 5.0018097759E+00, 1.5024620082E+01, 3.3560400752E+00, 9.6483499057E-01],
	[3.8500000000E+04, 3.1768140772E+01, 5.0018383288E+00, 1.5030989968E+01, 3.3564504505E+00, 9.6485111582E-01],
	[3.8505000000E+04, 3.1775289133E+01, 5.0018668782E+00, 1.5037361725E+01, 3.3568607201E+00, 9.6486723290E-01],
	[3.8510000000E+04, 3.1782438174E+01, 5.0018954239E+00, 1.5043735354E+01, 3.3572708841E+00, 9.6488334181E-01],
	[3.8515000000E+04, 3.1789587895E+01, 5.0019239662E+00, 1.5050110856E+01, 3.3576809424E+00, 9.6489944255E-01],
	[3.8520000000E+04, 3.1796738297E+01, 5.0019525049E+00, 1.5056488232E+01, 3.3580908952E+00, 9.6491553513E-01],
	[3.8525000000E+04, 3.1803889378E+01, 5.0019810401E+00, 1.5062867480E+01, 3.3585007423E+00, 9.6493161955E-01],
	[3.8530000000E+04, 3.1811041139E+01, 5.0020095717E+00, 1.5069248602E+01, 3.3589104838E+00, 9.6494769581E-01],
	[3.8535000000E+04, 3.1818193580E+01, 5.0020380998E+00, 1.5075631598E+01, 3.3593201198E+00, 9.6496376393E-01],
	[3.8540000000E+04, 3.1825346701E+01, 5.0020666243E+00, 1.5082016468E+01, 3.3597296502E+00, 9.6497982390E-01],
	[3.8545000000E+04, 3.1832500501E+01, 5.0020951453E+00, 1.5088403212E+01, 3.3601390751E+00, 9.6499587573E-01],
	[3.8550000000E+04, 3.1839654982E+01, 5.0021236628E+00, 1.5094791831E+01, 3.3605483946E+00, 9.6501191941E-01],
	[3.8555000000E+04, 3.1846810142E+01, 5.0021521767E+00, 1.5101182326E+01, 3.3609576085E+00, 9.6502795497E-01],
	[3.8560000000E+04, 3.1853965982E+01, 5.0021806871E+00, 1.5107574695E+01, 3.3613667170E+00, 9.6504398240E-01],
	[3.8565000000E+04, 3.1861122502E+01, 5.0022091940E+00, 1.5113968941E+01, 3.3617757201E+00, 9.6506000170E-01],
	[3.8570000000E+04, 3.1868279702E+01, 5.0022376973E+00, 1.5120365062E+01, 3.3621846177E+00, 9.6507601288E-01],
	[3.8575000000E+04, 3.1875437581E+01, 5.0022661971E+00, 1.5126763060E+01, 3.3625934100E+00, 9.6509201594E-01],
	[3.8580000000E+04, 3.1882596140E+01, 5.0022946934E+00, 1.5133162934E+01, 3.3630020968E+00, 9.6510801089E-01],
	[3.8585000000E+04, 3.1889755379E+01, 5.0023231861E+00, 1.5139564686E+01, 3.3634106783E+00, 9.6512399773E-01],
	[3.8590000000E+04, 3.1896915297E+01, 5.0023516753E+00, 1.5145968314E+01, 3.3638191545E+00, 9.6513997647E-01],
	[3.8595000000E+04, 3.1904075895E+01, 5.0023801610E+00, 1.5152373820E+01, 3.3642275254E+00, 9.6515594710E-01],
	[3.8600000000E+04, 3.1911237172E+01, 5.0024086431E+00, 1.5158781204E+01, 3.3646357910E+00, 9.6517190965E-01],
	[3.8605000000E+04, 3.1918399129E+01, 5.0024371218E+00, 1.5165190466E+01, 3.3650439512E+00, 9.6518786409E-01],
	[3.8610000000E+04, 3.1925561766E+01, 5.0024655969E+00, 1.5171601607E+01, 3.3654520063E+00, 9.6520381045E-01],
	[3.8615000000E+04, 3.1932725082E+01, 5.0024940684E+00, 1.5178014626E+01, 3.3658599561E+00, 9.6521974873E-01],
	[3.8620000000E+04, 3.1939906319E+01, 5.0025246738E+00, 1.5184429525E+01, 3.3662689600E+00, 9.6523567893E-01],
	[3.8625000000E+04, 3.1947088526E+01, 5.0025553106E+00, 1.5190846303E+01, 3.3666778782E+00, 9.6525160105E-01],
	[3.8630000000E+04, 3.1954271418E+01, 5.0025859436E+00, 1.5197264960E+01, 3.3670866915E+00, 9.6526751510E-01],
	[3.8635000000E+04, 3.1961454996E+01, 5.0026165729E+00, 1.5203685498E+01, 3.3674954000E+00, 9.6528342108E-01],
	[3.8640000000E+04, 3.1968639258E+01, 5.0026471983E+00, 1.5210107916E+01, 3.3679040036E+00, 9.6529931900E-01],
	[3.8645000000E+04, 3.1975824205E+01, 5.0026778201E+00, 1.5216532214E+01, 3.3683125025E+00, 9.6531520887E-01],
	[3.8650000000E+04, 3.1983009837E+01, 5.0027084380E+00, 1.5222958393E+01, 3.3687208966E+00, 9.6533109067E-01],
	[3.8655000000E+04, 3.1990196154E+01, 5.0027390522E+00, 1.5229386454E+01, 3.3691291860E+00, 9.6534696443E-01],
	[3.8660000000E+04, 3.1997383156E+01, 5.0027696625E+00, 1.5235816396E+01, 3.3695373706E+00, 9.6536283014E-01],
	[3.8665000000E+04, 3.2004570843E+01, 5.0028002692E+00, 1.5242248220E+01, 3.3699454505E+00, 9.6537868781E-01],
	[3.8670000000E+04, 3.2011759215E+01, 5.0028308720E+00, 1.5248681926E+01, 3.3703534257E+00, 9.6539453744E-01],
	[3.8675000000E+04, 3.2018948271E+01, 5.0028614711E+00, 1.5255117515E+01, 3.3707612963E+00, 9.6541037904E-01],
	[3.8680000000E+04, 3.2026138012E+01, 5.0028920664E+00, 1.5261554986E+01, 3.3711690622E+00, 9.6542621260E-01],
	[3.8685000000E+04, 3.2033328439E+01, 5.0029226579E+00, 1.5267994341E+01, 3.3715767234E+00, 9.6544203814E-01],
	[3.8690000000E+04, 3.2040519550E+01, 5.0029532457E+00, 1.5274435578E+01, 3.3719842801E+00, 9.6545785566E-01],
	[3.8695000000E+04, 3.2047711345E+01, 5.0029838297E+00, 1.5280878700E+01, 3.3723917322E+00, 9.6547366517E-01],
	[3.8700000000E+04, 3.2054903826E+01, 5.0030144100E+00, 1.5287323705E+01, 3.3727990797E+00, 9.6548946666E-01],
	[3.8705000000E+04, 3.2062096991E+01, 5.0030449864E+00, 1.5293770595E+01, 3.3732063226E+00, 9.6550526014E-01],
	[3.8710000000E+04, 3.2069290840E+01, 5.0030755592E+00, 1.5300219369E+01, 3.3736134611E+00, 9.6552104561E-01],
	[3.8715000000E+04, 3.2076485375E+01, 5.0031061281E+00, 1.5306670029E+01, 3.3740204950E+00, 9.6553682309E-01],
	[3.8720000000E+04, 3.2083680594E+01, 5.0031366933E+00, 1.5313122573E+01, 3.3744274244E+00, 9.6555259256E-01],
	[3.8725000000E+04, 3.2090876497E+01, 5.0031672548E+00, 1.5319577003E+01, 3.3748342494E+00, 9.6556835405E-01],
	[3.8730000000E+04, 3.2098073086E+01, 5.0031978124E+00, 1.5326033319E+01, 3.3752409699E+00, 9.6558410755E-01],
	[3.8735000000E+04, 3.2105270358E+01, 5.0032283663E+00, 1.5332491521E+01, 3.3756475860E+00, 9.6559985306E-01],
	[3.8740000000E+04, 3.2112468316E+01, 5.0032589165E+00, 1.5338951609E+01, 3.3760540977E+00, 9.6561559060E-01],
	[3.8745000000E+04, 3.2119666957E+01, 5.0032894629E+00, 1.5345413585E+01, 3.3764605050E+00, 9.6563132015E-01],
	[3.8750000000E+04, 3.2126866284E+01, 5.0033200056E+00, 1.5351877447E+01, 3.3768668080E+00, 9.6564704174E-01],
	[3.8755000000E+04, 3.2134066295E+01, 5.0033505445E+00, 1.5358343197E+01, 3.3772730066E+00, 9.6566275536E-01],
	[3.8760000000E+04, 3.2141266990E+01, 5.0033810796E+00, 1.5364810834E+01, 3.3776791008E+00, 9.6567846101E-01],
	[3.8765000000E+04, 3.2148468369E+01, 5.0034116110E+00, 1.5371280359E+01, 3.3780850908E+00, 9.6569415871E-01],
	[3.8770000000E+04, 3.2155670433E+01, 5.0034421386E+00, 1.5377751773E+01, 3.3784909765E+00, 9.6570984845E-01],
	[3.8775000000E+04, 3.2162873182E+01, 5.0034726625E+00, 1.5384225075E+01, 3.3788967579E+00, 9.6572553024E-01],
	[3.8780000000E+04, 3.2170076615E+01, 5.0035031826E+00, 1.5390700266E+01, 3.3793024351E+00, 9.6574120408E-01],
	[3.8785000000E+04, 3.2177280732E+01, 5.0035336990E+00, 1.5397177346E+01, 3.3797080080E+00, 9.6575686998E-01],
	[3.8790000000E+04, 3.2184485533E+01, 5.0035642117E+00, 1.5403656316E+01, 3.3801134768E+00, 9.6577252795E-01],
	[3.8795000000E+04, 3.2191691019E+01, 5.0035947206E+00, 1.5410137176E+01, 3.3805188414E+00, 9.6578817797E-01],
	[3.8800000000E+04, 3.2198897189E+01, 5.0036252257E+00, 1.5416619925E+01, 3.3809241018E+00, 9.6580382007E-01],
	[3.8805000000E+04, 3.2206104043E+01, 5.0036557271E+00, 1.5423104566E+01, 3.3813292581E+00, 9.6581945424E-01],
	[3.8810000000E+04, 3.2213311581E+01, 5.0036862248E+00, 1.5429591097E+01, 3.3817343102E+00, 9.6583508049E-01],
	[3.8815000000E+04, 3.2220519804E+01, 5.0037167187E+00, 1.5436079519E+01, 3.3821392583E+00, 9.6585069882E-01],
	[3.8820000000E+04, 3.2227728710E+01, 5.0037472089E+00, 1.5442569832E+01, 3.3825441022E+00, 9.6586630924E-01],
	[3.8825000000E+04, 3.2234938301E+01, 5.0037776953E+00, 1.5449062037E+01, 3.3829488421E+00, 9.6588191175E-01],
	[3.8830000000E+04, 3.2242148576E+01, 5.0038081780E+00, 1.5455556134E+01, 3.3833534780E+00, 9.6589750635E-01],
	[3.8835000000E+04, 3.2249359535E+01, 5.0038386570E+00, 1.5462052123E+01, 3.3837580099E+00, 9.6591309305E-01],
	[3.8840000000E+04, 3.2256571178E+01, 5.0038691322E+00, 1.5468550005E+01, 3.3841624377E+00, 9.6592867186E-01],
	[3.8845000000E+04, 3.2263783505E+01, 5.0038996037E+00, 1.5475049780E+01, 3.3845667616E+00, 9.6594424277E-01],
	[3.8850000000E+04, 3.2270996517E+01, 5.0039300714E+00, 1.5481551448E+01, 3.3849709815E+00, 9.6595980579E-01],
	[3.8855000000E+04, 3.2278210212E+01, 5.0039605354E+00, 1.5488055010E+01, 3.3853750975E+00, 9.6597536093E-01],
	[3.8860000000E+04, 3.2285424591E+01, 5.0039909957E+00, 1.5494560465E+01, 3.3857791096E+00, 9.6599090818E-01],
	[3.8865000000E+04, 3.2292639654E+01, 5.0040214522E+00, 1.5501067814E+01, 3.3861830178E+00, 9.6600644756E-01],
	[3.8870000000E+04, 3.2299855401E+01, 5.0040519050E+00, 1.5507577058E+01, 3.3865868221E+00, 9.6602197907E-01],
	[3.8875000000E+04, 3.2307071832E+01, 5.0040823541E+00, 1.5514088197E+01, 3.3869905226E+00, 9.6603750271E-01],
	[3.8880000000E+04, 3.2314288947E+01, 5.0041127994E+00, 1.5520601231E+01, 3.3873941192E+00, 9.6605301848E-01],
	[3.8885000000E+04, 3.2321506745E+01, 5.0041432411E+00, 1.5527116160E+01, 3.3877976120E+00, 9.6606852640E-01],
	[3.8890000000E+04, 3.2328725228E+01, 5.0041736789E+00, 1.5533632984E+01, 3.3882010010E+00, 9.6608402646E-01],
	[3.8895000000E+04, 3.2335944394E+01, 5.0042041131E+00, 1.5540151705E+01, 3.3886042863E+00, 9.6609951867E-01],
	[3.8900000000E+04, 3.2343164245E+01, 5.0042345435E+00, 1.5546672322E+01, 3.3890074678E+00, 9.6611500302E-01],
	[3.8905000000E+04, 3.2350384778E+01, 5.0042649702E+00, 1.5553194835E+01, 3.3894105455E+00, 9.6613047954E-01],
	[3.8910000000E+04, 3.2357605996E+01, 5.0042953932E+00, 1.5559719246E+01, 3.3898135196E+00, 9.6614594822E-01],
	[3.8915000000E+04, 3.2364827897E+01, 5.0043258125E+00, 1.5566245553E+01, 3.3902163900E+00, 9.6616140906E-01],
	[3.8920000000E+04, 3.2372050483E+01, 5.0043562280E+00, 1.5572773759E+01, 3.3906191567E+00, 9.6617686207E-01],
	[3.8925000000E+04, 3.2379273751E+01, 5.0043866398E+00, 1.5579303862E+01, 3.3910218197E+00, 9.6619230725E-01],
	[3.8930000000E+04, 3.2386497704E+01, 5.0044170479E+00, 1.5585835863E+01, 3.3914243791E+00, 9.6620774461E-01],
	[3.8935000000E+04, 3.2393722340E+01, 5.0044474523E+00, 1.5592369762E+01, 3.3918268350E+00, 9.6622317415E-01],
	[3.8940000000E+04, 3.2400947659E+01, 5.0044778529E+00, 1.5598905560E+01, 3.3922291872E+00, 9.6623859588E-01],
	[3.8945000000E+04, 3.2408173663E+01, 5.0045082498E+00, 1.5605443258E+01, 3.3926314359E+00, 9.6625400979E-01],
	[3.8950000000E+04, 3.2415400349E+01, 5.0045386430E+00, 1.5611982854E+01, 3.3930335810E+00, 9.6626941590E-01],
	[3.8955000000E+04, 3.2422627720E+01, 5.0045690325E+00, 1.5618524351E+01, 3.3934356226E+00, 9.6628481421E-01],
	[3.8960000000E+04, 3.2429855774E+01, 5.0045994183E+00, 1.5625067747E+01, 3.3938375607E+00, 9.6630020472E-01],
	[3.8965000000E+04, 3.2437084511E+01, 5.0046298004E+00, 1.5631613043E+01, 3.3942393953E+00, 9.6631558743E-01],
	[3.8970000000E+04, 3.2444313932E+01, 5.0046601787E+00, 1.5638160241E+01, 3.3946411265E+00, 9.6633096236E-01],
	[3.8975000000E+04, 3.2451544036E+01, 5.0046905534E+00, 1.5644709339E+01, 3.3950427542E+00, 9.6634632949E-01],
	[3.8980000000E+04, 3.2458774824E+01, 5.0047209243E+00, 1.5651260338E+01, 3.3954442785E+00, 9.6636168885E-01],
	[3.8985000000E+04, 3.2466006295E+01, 5.0047512915E+00, 1.5657813239E+01, 3.3958456994E+00, 9.6637704043E-01],
	[3.8990000000E+04, 3.2473238449E+01, 5.0047816550E+00, 1.5664368041E+01, 3.3962470169E+00, 9.6639238423E-01],
	[3.8995000000E+04, 3.2480471287E+01, 5.0048120148E+00, 1.5670924746E+01, 3.3966482310E+00, 9.6640772027E-01],
	[3.9000000000E+04, 3.2487704808E+01, 5.0048423709E+00, 1.5677483353E+01, 3.3970493418E+00, 9.6642304854E-01],
	[3.9005000000E+04, 3.2494939013E+01, 5.0048727233E+00, 1.5684043863E+01, 3.3974503493E+00, 9.6643836905E-01],
	[3.9010000000E+04, 3.2502173900E+01, 5.0049030719E+00, 1.5690606276E+01, 3.3978512536E+00, 9.6645368180E-01],
	[3.9015000000E+04, 3.2509409471E+01, 5.0049334169E+00, 1.5697170592E+01, 3.3982520545E+00, 9.6646898680E-01],
	[3.9020000000E+04, 3.2516645726E+01, 5.0049637581E+00, 1.5703736812E+01, 3.3986527522E+00, 9.6648428405E-01],
	[3.9025000000E+04, 3.2523882663E+01, 5.0049940957E+00, 1.5710304936E+01, 3.3990533466E+00, 9.6649957355E-01],
	[3.9030000000E+04, 3.2531120284E+01, 5.0050244296E+00, 1.5716874964E+01, 3.3994538378E+00, 9.6651485532E-01],
	[3.9035000000E+04, 3.2538358587E+01, 5.0050547597E+00, 1.5723446896E+01, 3.3998542259E+00, 9.6653012935E-01],
	[3.9040000000E+04, 3.2545597574E+01, 5.0050850862E+00, 1.5730020734E+01, 3.4002545107E+00, 9.6654539564E-01],
	[3.9045000000E+04, 3.2552837244E+01, 5.0051154089E+00, 1.5736596477E+01, 3.4006546924E+00, 9.6656065421E-01],
	[3.9050000000E+04, 3.2560077598E+01, 5.0051457280E+00, 1.5743174125E+01, 3.4010547710E+00, 9.6657590505E-01],
	[3.9055000000E+04, 3.2567318634E+01, 5.0051760433E+00, 1.5749753679E+01, 3.4014547465E+00, 9.6659114817E-01],
	[3.9060000000E+04, 3.2574560353E+01, 5.0052063550E+00, 1.5756335139E+01, 3.4018546189E+00, 9.6660638358E-01],
	[3.9065000000E+04, 3.2581802756E+01, 5.0052366629E+00, 1.5762918506E+01, 3.4022543882E+00, 9.6662161127E-01],
	[3.9070000000E+04, 3.2589045841E+01, 5.0052669672E+00, 1.5769503779E+01, 3.4026540545E+00, 9.6663683126E-01],
	[3.9075000000E+04, 3.2596289609E+01, 5.0052972678E+00, 1.5776090960E+01, 3.4030536177E+00, 9.6665204354E-01],
	[3.9080000000E+04, 3.2603534060E+01, 5.0053275646E+00, 1.5782680048E+01, 3.4034530780E+00, 9.6666724812E-01],
	[3.9085000000E+04, 3.2610779195E+01, 5.0053578578E+00, 1.5789271043E+01, 3.4038524352E+00, 9.6668244501E-01],
	[3.9090000000E+04, 3.2618025012E+01, 5.0053881473E+00, 1.5795863947E+01, 3.4042516895E+00, 9.6669763420E-01],
	[3.9095000000E+04, 3.2625271512E+01, 5.0054184331E+00, 1.5802458758E+01, 3.4046508409E+00, 9.6671281571E-01],
	[3.9100000000E+04, 3.2632518695E+01, 5.0054487152E+00, 1.5809055479E+01, 3.4050498893E+00, 9.6672798953E-01],
	[3.9105000000E+04, 3.2639766560E+01, 5.0054789937E+00, 1.5815654108E+01, 3.4054488349E+00, 9.6674315568E-01],
	[3.9110000000E+04, 3.2647015109E+01, 5.0055092684E+00, 1.5822254646E+01, 3.4058476775E+00, 9.6675831414E-01],
	[3.9115000000E+04, 3.2654264340E+01, 5.0055395394E+00, 1.5828857094E+01, 3.4062464173E+00, 9.6677346494E-01],
	[3.9120000000E+04, 3.2661514255E+01, 5.0055698068E+00, 1.5835461452E+01, 3.4066450542E+00, 9.6678860807E-01],
	[3.9125000000E+04, 3.2668764851E+01, 5.0056000705E+00, 1.5842067720E+01, 3.4070435884E+00, 9.6680374354E-01],
	[3.9130000000E+04, 3.2676016131E+01, 5.0056303305E+00, 1.5848675898E+01, 3.4074420197E+00, 9.6681887135E-01],
	[3.9135000000E+04, 3.2683268093E+01, 5.0056605868E+00, 1.5855285987E+01, 3.4078403483E+00, 9.6683399150E-01],
	[3.9140000000E+04, 3.2690520738E+01, 5.0056908394E+00, 1.5861897987E+01, 3.4082385741E+00, 9.6684910401E-01],
	[3.9145000000E+04, 3.2697774066E+01, 5.0057210883E+00, 1.5868511898E+01, 3.4086366972E+00, 9.6686420887E-01],
	[3.9150000000E+04, 3.2705028077E+01, 5.0057513336E+00, 1.5875127721E+01, 3.4090347175E+00, 9.6687930608E-01],
	[3.9155000000E+04, 3.2712282769E+01, 5.0057815752E+00, 1.5881745456E+01, 3.4094326352E+00, 9.6689439566E-01],
	[3.9160000000E+04, 3.2719538145E+01, 5.0058118131E+00, 1.5888365104E+01, 3.4098304502E+00, 9.6690947760E-01],
	[3.9165000000E+04, 3.2726794203E+01, 5.0058420473E+00, 1.5894986663E+01, 3.4102281625E+00, 9.6692455191E-01],
	[3.9170000000E+04, 3.2734050944E+01, 5.0058722779E+00, 1.5901610136E+01, 3.4106257723E+00, 9.6693961859E-01],
	[3.9175000000E+04, 3.2741308367E+01, 5.0059025047E+00, 1.5908235522E+01, 3.4110232794E+00, 9.6695467765E-01],
	[3.9180000000E+04, 3.2748566473E+01, 5.0059327279E+00, 1.5914862822E+01, 3.4114206839E+00, 9.6696972910E-01],
	[3.9185000000E+04, 3.2755825261E+01, 5.0059629475E+00, 1.5921492035E+01, 3.4118179859E+00, 9.6698477293E-01],
	[3.9190000000E+04, 3.2763084731E+01, 5.0059931633E+00, 1.5928123162E+01, 3.4122151853E+00, 9.6699980915E-01],
	[3.9195000000E+04, 3.2770344885E+01, 5.0060233755E+00, 1.5934756204E+01, 3.4126122822E+00, 9.6701483777E-01],
	[3.9200000000E+04, 3.2777605720E+01, 5.0060535840E+00, 1.5941391161E+01, 3.4130092765E+00, 9.6702985878E-01],
	[3.9205000000E+04, 3.2784867238E+01, 5.0060837888E+00, 1.5948028032E+01, 3.4134061684E+00, 9.6704487219E-01],
	[3.9210000000E+04, 3.2792129438E+01, 5.0061139900E+00, 1.5954666819E+01, 3.4138029579E+00, 9.6705987801E-01],
	[3.9215000000E+04, 3.2799392321E+01, 5.0061441875E+00, 1.5961307522E+01, 3.4141996449E+00, 9.6707487625E-01],
	[3.9220000000E+04, 3.2806655886E+01, 5.0061743813E+00, 1.5967950141E+01, 3.4145962295E+00, 9.6708986689E-01],
	[3.9225000000E+04, 3.2813920133E+01, 5.0062045715E+00, 1.5974594676E+01, 3.4149927116E+00, 9.6710484996E-01],
	[3.9230000000E+04, 3.2821185062E+01, 5.0062347580E+00, 1.5981241127E+01, 3.4153890914E+00, 9.6711982545E-01],
	[3.9235000000E+04, 3.2828450674E+01, 5.0062649408E+00, 1.5987889496E+01, 3.4157853689E+00, 9.6713479336E-01],
	[3.9240000000E+04, 3.2835728276E+01, 5.0062965098E+00, 1.5994539781E+01, 3.4161823136E+00, 9.6714975370E-01],
	[3.9245000000E+04, 3.2843012554E+01, 5.0063288111E+00, 1.6001191984E+01, 3.4165795638E+00, 9.6716470648E-01],
	[3.9250000000E+04, 3.2850297521E+01, 5.0063611086E+00, 1.6007846105E+01, 3.4169767121E+00, 9.6717965170E-01],
	[3.9255000000E+04, 3.2857583174E+01, 5.0063934021E+00, 1.6014502144E+01, 3.4173737583E+00, 9.6719458937E-01],
	[3.9260000000E+04, 3.2864869516E+01, 5.0064256917E+00, 1.6021160102E+01, 3.4177707027E+00, 9.6720951947E-01],
	[3.9265000000E+04, 3.2872156545E+01, 5.0064579775E+00, 1.6027819978E+01, 3.4181675451E+00, 9.6722444203E-01],
	[3.9270000000E+04, 3.2879444261E+01, 5.0064902593E+00, 1.6034481774E+01, 3.4185642856E+00, 9.6723935705E-01],
	[3.9275000000E+04, 3.2886732666E+01, 5.0065225372E+00, 1.6041145488E+01, 3.4189609242E+00, 9.6725426452E-01],
	[3.9280000000E+04, 3.2894021757E+01, 5.0065548112E+00, 1.6047811123E+01, 3.4193574609E+00, 9.6726916446E-01],
	[3.9285000000E+04, 3.2901311536E+01, 5.0065870813E+00, 1.6054478677E+01, 3.4197538958E+00, 9.6728405686E-01],
	[3.9290000000E+04, 3.2908602003E+01, 5.0066193475E+00, 1.6061148152E+01, 3.4201502289E+00, 9.6729894174E-01],
	[3.9295000000E+04, 3.2915893157E+01, 5.0066516099E+00, 1.6067819547E+01, 3.4205464601E+00, 9.6731381909E-01],
	[3.9300000000E+04, 3.2923184998E+01, 5.0066838683E+00, 1.6074492863E+01, 3.4209425896E+00, 9.6732868892E-01],
	[3.9305000000E+04, 3.2930477527E+01, 5.0067161228E+00, 1.6081168100E+01, 3.4213386173E+00, 9.6734355124E-01],
	[3.9310000000E+04, 3.2937770743E+01, 5.0067483734E+00, 1.6087845259E+01, 3.4217345433E+00, 9.6735840604E-01],
	[3.9315000000E+04, 3.2945064647E+01, 5.0067806202E+00, 1.6094524340E+01, 3.4221303676E+00, 9.6737325333E-01],
	[3.9320000000E+04, 3.2952359238E+01, 5.0068128630E+00, 1.6101205343E+01, 3.4225260901E+00, 9.6738809312E-01],
	[3.9325000000E+04, 3.2959654516E+01, 5.0068451020E+00, 1.6107888268E+01, 3.4229217110E+00, 9.6740292541E-01],
	[3.9330000000E+04, 3.2966950481E+01, 5.0068773370E+00, 1.6114573116E+01, 3.4233172302E+00, 9.6741775020E-01],
	[3.9335000000E+04, 3.2974247134E+01, 5.0069095682E+00, 1.6121259887E+01, 3.4237126478E+00, 9.6743256750E-01],
	[3.9340000000E+04, 3.2981544474E+01, 5.0069417955E+00, 1.6127948581E+01, 3.4241079638E+00, 9.6744737731E-01],
	[3.9345000000E+04, 3.2988842501E+01, 5.0069740189E+00, 1.6134639200E+01, 3.4245031781E+00, 9.6746217964E-01],
	[3.9350000000E+04, 3.2996141216E+01, 5.0070062384E+00, 1.6141331742E+01, 3.4248982909E+00, 9.6747697449E-01],
	[3.9355000000E+04, 3.3003440617E+01, 5.0070384540E+00, 1.6148026208E+01, 3.4252933022E+00, 9.6749176186E-01],
	[3.9360000000E+04, 3.3010740706E+01, 5.0070706657E+00, 1.6154722599E+01, 3.4256882119E+00, 9.6750654176E-01],
	[3.9365000000E+04, 3.3018041482E+01, 5.0071028736E+00, 1.6161420915E+01, 3.4260830201E+00, 9.6752131419E-01],
	[3.9370000000E+04, 3.3025342944E+01, 5.0071350775E+00, 1.6168121156E+01, 3.4264777268E+00, 9.6753607916E-01],
	[3.9375000000E+04, 3.3032645094E+01, 5.0071672776E+00, 1.6174823323E+01, 3.4268723321E+00, 9.6755083667E-01],
	[3.9380000000E+04, 3.3039947931E+01, 5.0071994738E+00, 1.6181527415E+01, 3.4272668358E+00, 9.6756558672E-01],
	[3.9385000000E+04, 3.3047251455E+01, 5.0072316661E+00, 1.6188233434E+01, 3.4276612382E+00, 9.6758032932E-01],
	[3.9390000000E+04, 3.3054555666E+01, 5.0072638546E+00, 1.6194941379E+01, 3.4280555392E+00, 9.6759506447E-01],
	[3.9395000000E+04, 3.3061860565E+01, 5.0072960391E+00, 1.6201651251E+01, 3.4284497388E+00, 9.6760979218E-01],
	[3.9400000000E+04, 3.3069166150E+01, 5.0073282198E+00, 1.6208363050E+01, 3.4288438370E+00, 9.6762451245E-01],
	[3.9405000000E+04, 3.3076472421E+01, 5.0073603966E+00, 1.6215076776E+01, 3.4292378338E+00, 9.6763922528E-01],
	[3.9410000000E+04, 3.3083779380E+01, 5.0073925695E+00, 1.6221792430E+01, 3.4296317294E+00, 9.6765393068E-01],
	[3.9415000000E+04, 3.3091087026E+01, 5.0074247386E+00, 1.6228510012E+01, 3.4300255236E+00, 9.6766862866E-01],
	[3.9420000000E+04, 3.3098395359E+01, 5.0074569038E+00, 1.6235229522E+01, 3.4304192166E+00, 9.6768331921E-01],
	[3.9425000000E+04, 3.3105704378E+01, 5.0074890651E+00, 1.6241950961E+01, 3.4308128083E+00, 9.6769800234E-01],
	[3.9430000000E+04, 3.3113014084E+01, 5.0075212225E+00, 1.6248674329E+01, 3.4312062988E+00, 9.6771267805E-01],
	[3.9435000000E+04, 3.3120324478E+01, 5.0075533761E+00, 1.6255399626E+01, 3.4315996880E+00, 9.6772734636E-01],
	[3.9440000000E+04, 3.3127635558E+01, 5.0075855258E+00, 1.6262126853E+01, 3.4319929761E+00, 9.6774200725E-01],
	[3.9445000000E+04, 3.3134947324E+01, 5.0076176716E+00, 1.6268856009E+01, 3.4323861629E+00, 9.6775666075E-01],
	[3.9450000000E+04, 3.3142259778E+01, 5.0076498136E+00, 1.6275587096E+01, 3.4327792487E+00, 9.6777130684E-01],
	[3.9455000000E+04, 3.3149572918E+01, 5.0076819517E+00, 1.6282320113E+01, 3.4331722333E+00, 9.6778594554E-01],
	[3.9460000000E+04, 3.3156886744E+01, 5.0077140859E+00, 1.6289055061E+01, 3.4335651167E+00, 9.6780057685E-01],
	[3.9465000000E+04, 3.3164201258E+01, 5.0077462162E+00, 1.6295791940E+01, 3.4339578991E+00, 9.6781520076E-01],
	[3.9470000000E+04, 3.3171516458E+01, 5.0077783427E+00, 1.6302530750E+01, 3.4343505805E+00, 9.6782981730E-01],
	[3.9475000000E+04, 3.3178832345E+01, 5.0078104654E+00, 1.6309271492E+01, 3.4347431607E+00, 9.6784442646E-01],
	[3.9480000000E+04, 3.3186148918E+01, 5.0078425841E+00, 1.6316014166E+01, 3.4351356400E+00, 9.6785902824E-01],
	[3.9485000000E+04, 3.3193466178E+01, 5.0078746990E+00, 1.6322758772E+01, 3.4355280182E+00, 9.6787362265E-01],
	[3.9490000000E+04, 3.3200784125E+01, 5.0079068101E+00, 1.6329505311E+01, 3.4359202955E+00, 9.6788820969E-01],
	[3.9495000000E+04, 3.3208102758E+01, 5.0079389173E+00, 1.6336253783E+01, 3.4363124718E+00, 9.6790278937E-01],
	[3.9500000000E+04, 3.3215422077E+01, 5.0079710206E+00, 1.6343004188E+01, 3.4367045471E+00, 9.6791736169E-01],
	[3.9505000000E+04, 3.3222742083E+01, 5.0080031201E+00, 1.6349756527E+01, 3.4370965215E+00, 9.6793192665E-01],
	[3.9510000000E+04, 3.3230062776E+01, 5.0080352157E+00, 1.6356510799E+01, 3.4374883951E+00, 9.6794648426E-01],
	[3.9515000000E+04, 3.3237384155E+01, 5.0080673074E+00, 1.6363267006E+01, 3.4378801677E+00, 9.6796103453E-01],
	[3.9520000000E+04, 3.3244706220E+01, 5.0080993954E+00, 1.6370025147E+01, 3.4382718395E+00, 9.6797557745E-01],
	[3.9525000000E+04, 3.3252028972E+01, 5.0081314794E+00, 1.6376785223E+01, 3.4386634105E+00, 9.6799011304E-01],
	[3.9530000000E+04, 3.3259352410E+01, 5.0081635596E+00, 1.6383547234E+01, 3.4390548806E+00, 9.6800464128E-01],
	[3.9535000000E+04, 3.3266676534E+01, 5.0081956359E+00, 1.6390311181E+01, 3.4394462499E+00, 9.6801916220E-01],
	[3.9540000000E+04, 3.3274001345E+01, 5.0082277084E+00, 1.6397077063E+01, 3.4398375185E+00, 9.6803367579E-01],
	[3.9545000000E+04, 3.3281326842E+01, 5.0082597771E+00, 1.6403844881E+01, 3.4402286863E+00, 9.6804818206E-01],
	[3.9550000000E+04, 3.3288653026E+01, 5.0082918419E+00, 1.6410614635E+01, 3.4406197534E+00, 9.6806268100E-01],
	[3.9555000000E+04, 3.3295979895E+01, 5.0083239028E+00, 1.6417386327E+01, 3.4410107198E+00, 9.6807717263E-01],
	[3.9560000000E+04, 3.3303307451E+01, 5.0083559599E+00, 1.6424159955E+01, 3.4414015855E+00, 9.6809165695E-01],
	[3.9565000000E+04, 3.3310635694E+01, 5.0083880132E+00, 1.6430935520E+01, 3.4417923505E+00, 9.6810613397E-01],
	[3.9570000000E+04, 3.3317964622E+01, 5.0084200626E+00, 1.6437713023E+01, 3.4421830149E+00, 9.6812060368E-01],
	[3.9575000000E+04, 3.3325294236E+01, 5.0084521081E+00, 1.6444492464E+01, 3.4425735786E+00, 9.6813506609E-01],
	[3.9580000000E+04, 3.3332624537E+01, 5.0084841499E+00, 1.6451273843E+01, 3.4429640418E+00, 9.6814952120E-01],
	[3.9585000000E+04, 3.3339955524E+01, 5.0085161877E+00, 1.6458057160E+01, 3.4433544043E+00, 9.6816396903E-01],
	[3.9590000000E+04, 3.3347287197E+01, 5.0085482218E+00, 1.6464842416E+01, 3.4437446663E+00, 9.6817840956E-01],
	[3.9595000000E+04, 3.3354619556E+01, 5.0085802520E+00, 1.6471629612E+01, 3.4441348278E+00, 9.6819284281E-01],
	[3.9600000000E+04, 3.3361952601E+01, 5.0086122783E+00, 1.6478418746E+01, 3.4445248887E+00, 9.6820726879E-01],
	[3.9605000000E+04, 3.3369286332E+01, 5.0086443008E+00, 1.6485209821E+01, 3.4449148491E+00, 9.6822168749E-01],
	[3.9610000000E+04, 3.3376620749E+01, 5.0086763195E+00, 1.6492002835E+01, 3.4453047091E+00, 9.6823609891E-01],
	[3.9615000000E+04, 3.3383955852E+01, 5.0087083344E+00, 1.6498797790E+01, 3.4456944686E+00, 9.6825050307E-01],
	[3.9620000000E+04, 3.3391291641E+01, 5.0087403454E+00, 1.6505594686E+01, 3.4460841277E+00, 9.6826489997E-01],
	[3.9625000000E+04, 3.3398628116E+01, 5.0087723525E+00, 1.6512393522E+01, 3.4464736864E+00, 9.6827928960E-01],
	[3.9630000000E+04, 3.3405965277E+01, 5.0088043559E+00, 1.6519194300E+01, 3.4468631446E+00, 9.6829367199E-01],
	[3.9635000000E+04, 3.3413303124E+01, 5.0088363554E+00, 1.6525997019E+01, 3.4472525025E+00, 9.6830804711E-01],
	[3.9640000000E+04, 3.3420641657E+01, 5.0088683510E+00, 1.6532801680E+01, 3.4476417601E+00, 9.6832241500E-01],
	[3.9645000000E+04, 3.3427980876E+01, 5.0089003429E+00, 1.6539608284E+01, 3.4480309173E+00, 9.6833677564E-01],
	[3.9650000000E+04, 3.3435320780E+01, 5.0089323309E+00, 1.6546416829E+01, 3.4484199742E+00, 9.6835112903E-01],
	[3.9655000000E+04, 3.3442661370E+01, 5.0089643151E+00, 1.6553227318E+01, 3.4488089308E+00, 9.6836547520E-01],
	[3.9660000000E+04, 3.3450002646E+01, 5.0089962954E+00, 1.6560039750E+01, 3.4491977872E+00, 9.6837981413E-01],
	[3.9665000000E+04, 3.3457344608E+01, 5.0090282720E+00, 1.6566854125E+01, 3.4495865433E+00, 9.6839414583E-01],
	[3.9670000000E+04, 3.3464687256E+01, 5.0090602447E+00, 1.6573670444E+01, 3.4499751992E+00, 9.6840847031E-01],
	[3.9675000000E+04, 3.3472030589E+01, 5.0090922135E+00, 1.6580488707E+01, 3.4503637549E+00, 9.6842278757E-01],
	[3.9680000000E+04, 3.3479374608E+01, 5.0091241786E+00, 1.6587308915E+01, 3.4507522104E+00, 9.6843709762E-01],
	[3.9685000000E+04, 3.3486719313E+01, 5.0091561398E+00, 1.6594131067E+01, 3.4511405658E+00, 9.6845140045E-01],
	[3.9690000000E+04, 3.3494064703E+01, 5.0091880972E+00, 1.6600955164E+01, 3.4515288210E+00, 9.6846569608E-01],
	[3.9695000000E+04, 3.3501410779E+01, 5.0092200508E+00, 1.6607781206E+01, 3.4519169761E+00, 9.6847998450E-01],
	[3.9700000000E+04, 3.3508757541E+01, 5.0092520005E+00, 1.6614609194E+01, 3.4523050312E+00, 9.6849426572E-01],
	[3.9705000000E+04, 3.3516104988E+01, 5.0092839465E+00, 1.6621439128E+01, 3.4526929861E+00, 9.6850853975E-01],
	[3.9710000000E+04, 3.3523453121E+01, 5.0093158886E+00, 1.6628271008E+01, 3.4530808410E+00, 9.6852280658E-01],
	[3.9715000000E+04, 3.3530801939E+01, 5.0093478269E+00, 1.6635104834E+01, 3.4534685959E+00, 9.6853706623E-01],
	[3.9720000000E+04, 3.3538151443E+01, 5.0093797614E+00, 1.6641940608E+01, 3.4538562507E+00, 9.6855131869E-01],
	[3.9725000000E+04, 3.3545501632E+01, 5.0094116921E+00, 1.6648778328E+01, 3.4542438056E+00, 9.6856556397E-01],
	[3.9730000000E+04, 3.3552852507E+01, 5.0094436189E+00, 1.6655617996E+01, 3.4546312605E+00, 9.6857980207E-01],
	[3.9735000000E+04, 3.3560204068E+01, 5.0094755420E+00, 1.6662459612E+01, 3.4550186155E+00, 9.6859403301E-01],
	[3.9740000000E+04, 3.3567556313E+01, 5.0095074612E+00, 1.6669303176E+01, 3.4554058705E+00, 9.6860825677E-01],
	[3.9745000000E+04, 3.3574909244E+01, 5.0095393766E+00, 1.6676148688E+01, 3.4557930256E+00, 9.6862247337E-01],
	[3.9750000000E+04, 3.3582262861E+01, 5.0095712882E+00, 1.6682996149E+01, 3.4561800809E+00, 9.6863668281E-01],
	[3.9755000000E+04, 3.3589617163E+01, 5.0096031960E+00, 1.6689845558E+01, 3.4565670363E+00, 9.6865088510E-01],
	[3.9760000000E+04, 3.3596972150E+01, 5.0096351000E+00, 1.6696696917E+01, 3.4569538918E+00, 9.6866508023E-01],
	[3.9765000000E+04, 3.3604327823E+01, 5.0096670002E+00, 1.6703550226E+01, 3.4573406476E+00, 9.6867926821E-01],
	[3.9770000000E+04, 3.3611684181E+01, 5.0096988965E+00, 1.6710405485E+01, 3.4577273035E+00, 9.6869344905E-01],
	[3.9775000000E+04, 3.3619041224E+01, 5.0097307891E+00, 1.6717262694E+01, 3.4581138597E+00, 9.6870762275E-01],
	[3.9780000000E+04, 3.3626398952E+01, 5.0097626778E+00, 1.6724121853E+01, 3.4585003161E+00, 9.6872178931E-01],
	[3.9785000000E+04, 3.3633757366E+01, 5.0097945628E+00, 1.6730982963E+01, 3.4588866728E+00, 9.6873594874E-01],
	[3.9790000000E+04, 3.3641116465E+01, 5.0098264439E+00, 1.6737846025E+01, 3.4592729298E+00, 9.6875010104E-01],
	[3.9795000000E+04, 3.3648476249E+01, 5.0098583213E+00, 1.6744711038E+01, 3.4596590871E+00, 9.6876424621E-01],
	[3.9800000000E+04, 3.3655836718E+01, 5.0098901948E+00, 1.6751578002E+01, 3.4600451447E+00, 9.6877838426E-01],
	[3.9805000000E+04, 3.3663197872E+01, 5.0099220645E+00, 1.6758446919E+01, 3.4604311027E+00, 9.6879251520E-01],
	[3.9810000000E+04, 3.3670559712E+01, 5.0099539305E+00, 1.6765317788E+01, 3.4608169611E+00, 9.6880663902E-01],
	[3.9815000000E+04, 3.3677922236E+01, 5.0099857926E+00, 1.6772190610E+01, 3.4612027198E+00, 9.6882075574E-01],
	[3.9820000000E+04, 3.3685285446E+01, 5.0100176510E+00, 1.6779065385E+01, 3.4615883790E+00, 9.6883486535E-01],
	[3.9825000000E+04, 3.3692649341E+01, 5.0100495055E+00, 1.6785942113E+01, 3.4619739386E+00, 9.6884896786E-01],
	[3.9830000000E+04, 3.3700013921E+01, 5.0100813562E+00, 1.6792820795E+01, 3.4623593987E+00, 9.6886306329E-01],
	[3.9835000000E+04, 3.3707379185E+01, 5.0101132032E+00, 1.6799701431E+01, 3.4627447592E+00, 9.6887715164E-01],
	[3.9840000000E+04, 3.3714745135E+01, 5.0101450464E+00, 1.6806584021E+01, 3.4631300203E+00, 9.6889123293E-01],
	[3.9845000000E+04, 3.3722111770E+01, 5.0101768857E+00, 1.6813468565E+01, 3.4635151819E+00, 9.6890530715E-01],
	[3.9850000000E+04, 3.3729479090E+01, 5.0102087213E+00, 1.6820355065E+01, 3.4639002440E+00, 9.6891937431E-01],
	[3.9855000000E+04, 3.3736847094E+01, 5.0102405531E+00, 1.6827243519E+01, 3.4642852068E+00, 9.6893343440E-01],
	[3.9860000000E+04, 3.3744215784E+01, 5.0102723810E+00, 1.6834133930E+01, 3.4646700701E+00, 9.6894748745E-01],
	[3.9865000000E+04, 3.3751585158E+01, 5.0103042052E+00, 1.6841026295E+01, 3.4650548340E+00, 9.6896153344E-01],
	[3.9870000000E+04, 3.3758960718E+01, 5.0103366958E+00, 1.6847920617E+01, 3.4654398771E+00, 9.6897557238E-01],
	[3.9875000000E+04, 3.3766348540E+01, 5.0103705928E+00, 1.6854816896E+01, 3.4658256177E+00, 9.6898960427E-01],
	[3.9880000000E+04, 3.3773737054E+01, 5.0104044858E+00, 1.6861715131E+01, 3.4662112593E+00, 9.6900362912E-01],
	[3.9885000000E+04, 3.3781126257E+01, 5.0104383748E+00, 1.6868615323E+01, 3.4665968019E+00, 9.6901764694E-01],
	[3.9890000000E+04, 3.3788516150E+01, 5.0104722597E+00, 1.6875517473E+01, 3.4669822455E+00, 9.6903165772E-01],
	[3.9895000000E+04, 3.3795906733E+01, 5.0105061406E+00, 1.6882421580E+01, 3.4673675901E+00, 9.6904566146E-01],
	[3.9900000000E+04, 3.3803298007E+01, 5.0105400175E+00, 1.6889327645E+01, 3.4677528357E+00, 9.6905965818E-01],
	[3.9905000000E+04, 3.3810689970E+01, 5.0105738904E+00, 1.6896235668E+01, 3.4681379824E+00, 9.6907364787E-01],
	[3.9910000000E+04, 3.3818082623E+01, 5.0106077593E+00, 1.6903145650E+01, 3.4685230302E+00, 9.6908763054E-01],
	[3.9915000000E+04, 3.3825475967E+01, 5.0106416241E+00, 1.6910057591E+01, 3.4689079791E+00, 9.6910160620E-01],
	[3.9920000000E+04, 3.3832870000E+01, 5.0106754850E+00, 1.6916971491E+01, 3.4692928291E+00, 9.6911557483E-01],
	[3.9925000000E+04, 3.3840264723E+01, 5.0107093418E+00, 1.6923887351E+01, 3.4696775803E+00, 9.6912953646E-01],
	[3.9930000000E+04, 3.3847660137E+01, 5.0107431946E+00, 1.6930805170E+01, 3.4700622327E+00, 9.6914349108E-01],
	[3.9935000000E+04, 3.3855056240E+01, 5.0107770434E+00, 1.6937724950E+01, 3.4704467862E+00, 9.6915743869E-01],
	[3.9940000000E+04, 3.3862453033E+01, 5.0108108882E+00, 1.6944646690E+01, 3.4708312410E+00, 9.6917137930E-01],
	[3.9945000000E+04, 3.3869850515E+01, 5.0108447290E+00, 1.6951570391E+01, 3.4712155970E+00, 9.6918531291E-01],
	[3.9950000000E+04, 3.3877248688E+01, 5.0108785658E+00, 1.6958496052E+01, 3.4715998543E+00, 9.6919923953E-01],
	[3.9955000000E+04, 3.3884647551E+01, 5.0109123986E+00, 1.6965423675E+01, 3.4719840128E+00, 9.6921315916E-01],
	[3.9960000000E+04, 3.3892047103E+01, 5.0109462273E+00, 1.6972353260E+01, 3.4723680727E+00, 9.6922707180E-01],
	[3.9965000000E+04, 3.3899447345E+01, 5.0109800521E+00, 1.6979284807E+01, 3.4727520339E+00, 9.6924097745E-01],
	[3.9970000000E+04, 3.3906848276E+01, 5.0110138729E+00, 1.6986218316E+01, 3.4731358964E+00, 9.6925487613E-01],
	[3.9975000000E+04, 3.3914249898E+01, 5.0110476896E+00, 1.6993153788E+01, 3.4735196603E+00, 9.6926876782E-01],
	[3.9980000000E+04, 3.3921652209E+01, 5.0110815024E+00, 1.7000091222E+01, 3.4739033255E+00, 9.6928265255E-01],
	[3.9985000000E+04, 3.3929055210E+01, 5.0111153112E+00, 1.7007030620E+01, 3.4742868922E+00, 9.6929653030E-01],
	[3.9990000000E+04, 3.3936458900E+01, 5.0111491159E+00, 1.7013971982E+01, 3.4746703603E+00, 9.6931040108E-01],
	[3.9995000000E+04, 3.3943863280E+01, 5.0111829167E+00, 1.7020915307E+01, 3.4750537299E+00, 9.6932426490E-01],
	[4.0000000000E+04, 3.3951268350E+01, 5.0112167134E+00, 1.7027860596E+01, 3.4754370009E+00, 9.6933812176E-01],
	[4.0005000000E+04, 3.3958674109E+01, 5.0112505062E+00, 1.7034832556E+01, 3.4758212020E+00, 9.6935197166E-01],
	[4.0010000000E+04, 3.3966080558E+01, 5.0112842950E+00, 1.7041806498E+01, 3.4762053042E+00, 9.6936581461E-01],
	[4.0015000000E+04, 3.3973487696E+01, 5.0113180798E+00, 1.7048782423E+01, 3.4765893073E+00, 9.6937965061E-01],
	[4.0020000000E+04, 3.3980895524E+01, 5.0113518606E+00, 1.7055760330E+01, 3.4769732115E+00, 9.6939347966E-01],
	[4.0025000000E+04, 3.3988304042E+01, 5.0113856373E+00, 1.7062740220E+01, 3.4773570168E+00, 9.6940730177E-01],
	[4.0030000000E+04, 3.3995713249E+01, 5.0114194101E+00, 1.7069722093E+01, 3.4777407232E+00, 9.6942111694E-01],
	[4.0035000000E+04, 3.4003123145E+01, 5.0114531790E+00, 1.7076705949E+01, 3.4781243306E+00, 9.6943492517E-01],
	[4.0040000000E+04, 3.4010533731E+01, 5.0114869438E+00, 1.7083691790E+01, 3.4785078393E+00, 9.6944872647E-01],
	[4.0045000000E+04, 3.4017945006E+01, 5.0115207046E+00, 1.7090679615E+01, 3.4788912490E+00, 9.6946252084E-01],
	[4.0050000000E+04, 3.4025356970E+01, 5.0115544615E+00, 1.7097669424E+01, 3.4792745600E+00, 9.6947630828E-01],
	[4.0055000000E+04, 3.4032769624E+01, 5.0115882143E+00, 1.7104661218E+01, 3.4796577721E+00, 9.6949008880E-01],
	[4.0060000000E+04, 3.4040182967E+01, 5.0116219632E+00, 1.7111654997E+01, 3.4800408854E+00, 9.6950386240E-01],
	[4.0065000000E+04, 3.4047597000E+01, 5.0116557081E+00, 1.7118650761E+01, 3.4804239000E+00, 9.6951762908E-01],
	[4.0070000000E+04, 3.4055011722E+01, 5.0116894490E+00, 1.7125648512E+01, 3.4808068159E+00, 9.6953138885E-01],
	[4.0075000000E+04, 3.4062427133E+01, 5.0117231859E+00, 1.7132648248E+01, 3.4811896330E+00, 9.6954514171E-01],
	[4.0080000000E+04, 3.4069843233E+01, 5.0117569188E+00, 1.7139649971E+01, 3.4815723515E+00, 9.6955888767E-01],
	[4.0085000000E+04, 3.4077260023E+01, 5.0117906478E+00, 1.7146653680E+01, 3.4819549713E+00, 9.6957262672E-01],
	[4.0090000000E+04, 3.4084677502E+01, 5.0118243728E+00, 1.7153659376E+01, 3.4823374924E+00, 9.6958635888E-01],
	[4.0095000000E+04, 3.4092095670E+01, 5.0118580938E+00, 1.7160667060E+01, 3.4827199149E+00, 9.6960008413E-01],
	[4.0100000000E+04, 3.4099514527E+01, 5.0118918108E+00, 1.7167676731E+01, 3.4831022388E+00, 9.6961380250E-01],
	[4.0105000000E+04, 3.4106934073E+01, 5.0119255238E+00, 1.7174688391E+01, 3.4834844641E+00, 9.6962751397E-01],
	[4.0110000000E+04, 3.4114354309E+01, 5.0119592329E+00, 1.7181702038E+01, 3.4838665908E+00, 9.6964121856E-01],
	[4.0115000000E+04, 3.4121775234E+01, 5.0119929380E+00, 1.7188717675E+01, 3.4842486190E+00, 9.6965491627E-01],
	[4.0120000000E+04, 3.4129196847E+01, 5.0120266391E+00, 1.7195735300E+01, 3.4846305487E+00, 9.6966860710E-01],
	[4.0125000000E+04, 3.4136619150E+01, 5.0120603363E+00, 1.7202754914E+01, 3.4850123799E+00, 9.6968229106E-01],
	[4.0130000000E+04, 3.4144042142E+01, 5.0120940294E+00, 1.7209776518E+01, 3.4853941126E+00, 9.6969596814E-01],
	[4.0135000000E+04, 3.4151465822E+01, 5.0121277186E+00, 1.7216800112E+01, 3.4857757468E+00, 9.6970963835E-01],
	[4.0140000000E+04, 3.4158890192E+01, 5.0121614039E+00, 1.7223825695E+01, 3.4861572826E+00, 9.6972330170E-01],
	[4.0145000000E+04, 3.4166315251E+01, 5.0121950851E+00, 1.7230853270E+01, 3.4865387200E+00, 9.6973695819E-01],
	[4.0150000000E+04, 3.4173740998E+01, 5.0122287624E+00, 1.7237882835E+01, 3.4869200590E+00, 9.6975060781E-01],
	[4.0155000000E+04, 3.4181167435E+01, 5.0122624358E+00, 1.7244914391E+01, 3.4873012996E+00, 9.6976425059E-01],
	[4.0160000000E+04, 3.4188594561E+01, 5.0122961051E+00, 1.7251947939E+01, 3.4876824419E+00, 9.6977788651E-01],
	[4.0165000000E+04, 3.4196022375E+01, 5.0123297705E+00, 1.7258983478E+01, 3.4880634859E+00, 9.6979151558E-01],
	[4.0170000000E+04, 3.4203450878E+01, 5.0123634319E+00, 1.7266021010E+01, 3.4884444315E+00, 9.6980513781E-01],
	[4.0175000000E+04, 3.4210880070E+01, 5.0123970894E+00, 1.7273060534E+01, 3.4888252789E+00, 9.6981875320E-01],
	[4.0180000000E+04, 3.4218309951E+01, 5.0124307429E+00, 1.7280102050E+01, 3.4892060280E+00, 9.6983236175E-01],
	[4.0185000000E+04, 3.4225740521E+01, 5.0124643925E+00, 1.7287145560E+01, 3.4895866789E+00, 9.6984596347E-01],
	[4.0190000000E+04, 3.4233171779E+01, 5.0124980380E+00, 1.7294191063E+01, 3.4899672315E+00, 9.6985955835E-01],
	[4.0195000000E+04, 3.4240603726E+01, 5.0125316797E+00, 1.7301238559E+01, 3.4903476859E+00, 9.6987314641E-01],
	[4.0200000000E+04, 3.4248036362E+01, 5.0125653173E+00, 1.7308288050E+01, 3.4907280422E+00, 9.6988672764E-01],
	[4.0205000000E+04, 3.4255469687E+01, 5.0125989510E+00, 1.7315339534E+01, 3.4911083003E+00, 9.6990030205E-01],
	[4.0210000000E+04, 3.4262903700E+01, 5.0126325808E+00, 1.7322393014E+01, 3.4914884603E+00, 9.6991386965E-01],
	[4.0215000000E+04, 3.4270338402E+01, 5.0126662066E+00, 1.7329448488E+01, 3.4918685222E+00, 9.6992743043E-01],
	[4.0220000000E+04, 3.4277773793E+01, 5.0126998284E+00, 1.7336505957E+01, 3.4922484860E+00, 9.6994098440E-01],
	[4.0225000000E+04, 3.4285209872E+01, 5.0127334463E+00, 1.7343565422E+01, 3.4926283517E+00, 9.6995453156E-01],
	[4.0230000000E+04, 3.4292646640E+01, 5.0127670602E+00, 1.7350626883E+01, 3.4930081194E+00, 9.6996807192E-01],
	[4.0235000000E+04, 3.4300084097E+01, 5.0128006702E+00, 1.7357690340E+01, 3.4933877891E+00, 9.6998160547E-01],
	[4.0240000000E+04, 3.4307522242E+01, 5.0128342762E+00, 1.7364755793E+01, 3.4937673607E+00, 9.6999513223E-01],
	[4.0245000000E+04, 3.4314961075E+01, 5.0128678783E+00, 1.7371823244E+01, 3.4941468344E+00, 9.7000865220E-01],
	[4.0250000000E+04, 3.4322400597E+01, 5.0129014764E+00, 1.7378892691E+01, 3.4945262101E+00, 9.7002216538E-01],
	[4.0255000000E+04, 3.4329840808E+01, 5.0129350706E+00, 1.7385964136E+01, 3.4949054879E+00, 9.7003567177E-01],
	[4.0260000000E+04, 3.4337281707E+01, 5.0129686608E+00, 1.7393037578E+01, 3.4952846678E+00, 9.7004917138E-01],
	[4.0265000000E+04, 3.4344723294E+01, 5.0130022471E+00, 1.7400113019E+01, 3.4956637497E+00, 9.7006266420E-01],
	[4.0270000000E+04, 3.4352165570E+01, 5.0130358295E+00, 1.7407190458E+01, 3.4960427338E+00, 9.7007615025E-01],
	[4.0275000000E+04, 3.4359608534E+01, 5.0130694079E+00, 1.7414269896E+01, 3.4964216201E+00, 9.7008962953E-01],
	[4.0280000000E+04, 3.4367052187E+01, 5.0131029823E+00, 1.7421351332E+01, 3.4968004085E+00, 9.7010310204E-01],
	[4.0285000000E+04, 3.4374496528E+01, 5.0131365528E+00, 1.7428434768E+01, 3.4971790991E+00, 9.7011656778E-01],
	[4.0290000000E+04, 3.4381941557E+01, 5.0131701194E+00, 1.7435520204E+01, 3.4975576920E+00, 9.7013002675E-01],
	[4.0295000000E+04, 3.4389387275E+01, 5.0132036820E+00, 1.7442607639E+01, 3.4979361870E+00, 9.7014347897E-01],
	[4.0300000000E+04, 3.4396833681E+01, 5.0132372407E+00, 1.7449697075E+01, 3.4983145844E+00, 9.7015692443E-01],
	[4.0305000000E+04, 3.4404280775E+01, 5.0132707955E+00, 1.7456788512E+01, 3.4986928840E+00, 9.7017036314E-01],
	[4.0310000000E+04, 3.4411728558E+01, 5.0133043463E+00, 1.7463881949E+01, 3.4990710859E+00, 9.7018379510E-01],
	[4.0315000000E+04, 3.4419177028E+01, 5.0133378931E+00, 1.7470977388E+01, 3.4994491901E+00, 9.7019722032E-01],
	[4.0320000000E+04, 3.4426626187E+01, 5.0133714361E+00, 1.7478074828E+01, 3.4998271967E+00, 9.7021063879E-01],
	[4.0325000000E+04, 3.4434076034E+01, 5.0134049751E+00, 1.7485174270E+01, 3.5002051057E+00, 9.7022405052E-01],
	[4.0330000000E+04, 3.4441526569E+01, 5.0134385102E+00, 1.7492275714E+01, 3.5005829170E+00, 9.7023745551E-01],
	[4.0335000000E+04, 3.4448977793E+01, 5.0134720413E+00, 1.7499379160E+01, 3.5009606307E+00, 9.7025085378E-01],
	[4.0340000000E+04, 3.4456429704E+01, 5.0135055685E+00, 1.7506484610E+01, 3.5013382469E+00, 9.7026424531E-01],
	[4.0345000000E+04, 3.4463882304E+01, 5.0135390918E+00, 1.7513592062E+01, 3.5017157656E+00, 9.7027763012E-01],
	[4.0350000000E+04, 3.4471335592E+01, 5.0135726111E+00, 1.7520701518E+01, 3.5020931867E+00, 9.7029100821E-01],
	[4.0355000000E+04, 3.4478789567E+01, 5.0136061265E+00, 1.7527812978E+01, 3.5024705103E+00, 9.7030437957E-01],
	[4.0360000000E+04, 3.4486244231E+01, 5.0136396380E+00, 1.7534926441E+01, 3.5028477364E+00, 9.7031774423E-01],
	[4.0365000000E+04, 3.4493699583E+01, 5.0136731456E+00, 1.7542041909E+01, 3.5032248651E+00, 9.7033110217E-01],
	[4.0370000000E+04, 3.4501155623E+01, 5.0137066492E+00, 1.7549159382E+01, 3.5036018964E+00, 9.7034445340E-01],
	[4.0375000000E+04, 3.4508612350E+01, 5.0137401489E+00, 1.7556278860E+01, 3.5039788302E+00, 9.7035779792E-01],
	[4.0380000000E+04, 3.4516069766E+01, 5.0137736447E+00, 1.7563400343E+01, 3.5043556666E+00, 9.7037113575E-01],
	[4.0385000000E+04, 3.4523527870E+01, 5.0138071366E+00, 1.7570523832E+01, 3.5047324057E+00, 9.7038446687E-01],
	[4.0390000000E+04, 3.4530986661E+01, 5.0138406245E+00, 1.7577649327E+01, 3.5051090474E+00, 9.7039779130E-01],
	[4.0395000000E+04, 3.4538446141E+01, 5.0138741085E+00, 1.7584776828E+01, 3.5054855918E+00, 9.7041110904E-01],
	[4.0400000000E+04, 3.4545906308E+01, 5.0139075886E+00, 1.7591906335E+01, 3.5058620389E+00, 9.7042442009E-01],
	[4.0405000000E+04, 3.4553367163E+01, 5.0139410648E+00, 1.7599037850E+01, 3.5062383887E+00, 9.7043772446E-01],
	[4.0410000000E+04, 3.4560828706E+01, 5.0139745370E+00, 1.7606171371E+01, 3.5066146412E+00, 9.7045102214E-01],
	[4.0415000000E+04, 3.4568290936E+01, 5.0140080054E+00, 1.7613306901E+01, 3.5069907965E+00, 9.7046431315E-01],
	[4.0420000000E+04, 3.4575753855E+01, 5.0140414698E+00, 1.7620444438E+01, 3.5073668546E+00, 9.7047759748E-01],
	[4.0425000000E+04, 3.4583217461E+01, 5.0140749303E+00, 1.7627583983E+01, 3.5077428155E+00, 9.7049087514E-01],
	[4.0430000000E+04, 3.4590681755E+01, 5.0141083869E+00, 1.7634725537E+01, 3.5081186792E+00, 9.7050414613E-01],
	[4.0435000000E+04, 3.4598146737E+01, 5.0141418395E+00, 1.7641869099E+01, 3.5084944458E+00, 9.7051741046E-01],
	[4.0440000000E+04, 3.4605612406E+01, 5.0141752883E+00, 1.7649014671E+01, 3.5088701152E+00, 9.7053066813E-01],
	[4.0445000000E+04, 3.4613078763E+01, 5.0142087332E+00, 1.7656162252E+01, 3.5092456875E+00, 9.7054391914E-01],
	[4.0450000000E+04, 3.4620545808E+01, 5.0142421741E+00, 1.7663311843E+01, 3.5096211627E+00, 9.7055716349E-01],
	[4.0455000000E+04, 3.4628013540E+01, 5.0142756111E+00, 1.7670463444E+01, 3.5099965409E+00, 9.7057040120E-01],
	[4.0460000000E+04, 3.4635481960E+01, 5.0143090442E+00, 1.7677617055E+01, 3.5103718220E+00, 9.7058363225E-01],
	[4.0465000000E+04, 3.4642951067E+01, 5.0143424734E+00, 1.7684772677E+01, 3.5107470061E+00, 9.7059685667E-01],
	[4.0470000000E+04, 3.4650420862E+01, 5.0143758987E+00, 1.7691930310E+01, 3.5111220932E+00, 9.7061007444E-01],
	[4.0475000000E+04, 3.4657891345E+01, 5.0144093201E+00, 1.7699089955E+01, 3.5114970834E+00, 9.7062328557E-01],
	[4.0480000000E+04, 3.4665362515E+01, 5.0144427376E+00, 1.7706251611E+01, 3.5118719765E+00, 9.7063649007E-01],
	[4.0485000000E+04, 3.4672834372E+01, 5.0144761512E+00, 1.7713415279E+01, 3.5122467728E+00, 9.7064968794E-01],
	[4.0490000000E+04, 3.4680306917E+01, 5.0145095609E+00, 1.7720580959E+01, 3.5126214721E+00, 9.7066287918E-01],
	[4.0495000000E+04, 3.4687780150E+01, 5.0145429667E+00, 1.7727748652E+01, 3.5129960745E+00, 9.7067606380E-01],
	[4.0500000000E+04, 3.4695254069E+01, 5.0145763686E+00, 1.7734918357E+01, 3.5133705801E+00, 9.7068924180E-01],
	[4.0505000000E+04, 3.4702728677E+01, 5.0146097665E+00, 1.7742090076E+01, 3.5137449888E+00, 9.7070241318E-01],
	[4.0510000000E+04, 3.4710203971E+01, 5.0146431606E+00, 1.7749263809E+01, 3.5141193007E+00, 9.7071557794E-01],
	[4.0515000000E+04, 3.4717696166E+01, 5.0146784985E+00, 1.7756439555E+01, 3.5144946386E+00, 9.7072873610E-01],
	[4.0520000000E+04, 3.4725189786E+01, 5.0147139203E+00, 1.7763617316E+01, 3.5148699307E+00, 9.7074188765E-01],
	[4.0525000000E+04, 3.4732684098E+01, 5.0147493380E+00, 1.7770797091E+01, 3.5152451263E+00, 9.7075503260E-01],
	[4.0530000000E+04, 3.4740179103E+01, 5.0147847515E+00, 1.7777978881E+01, 3.5156202255E+00, 9.7076817094E-01],
	[4.0535000000E+04, 3.4747674800E+01, 5.0148201610E+00, 1.7785162686E+01, 3.5159952282E+00, 9.7078130269E-01],
	[4.0540000000E+04, 3.4755171190E+01, 5.0148555663E+00, 1.7792348506E+01, 3.5163701345E+00, 9.7079442785E-01],
	[4.0545000000E+04, 3.4762668272E+01, 5.0148909675E+00, 1.7799536343E+01, 3.5167449444E+00, 9.7080754641E-01],
	[4.0550000000E+04, 3.4770166047E+01, 5.0149263646E+00, 1.7806726195E+01, 3.5171196579E+00, 9.7082065839E-01],
	[4.0555000000E+04, 3.4777664514E+01, 5.0149617576E+00, 1.7813918064E+01, 3.5174942751E+00, 9.7083376379E-01],
	[4.0560000000E+04, 3.4785163673E+01, 5.0149971464E+00, 1.7821111949E+01, 3.5178687959E+00, 9.7084686261E-01],
	[4.0565000000E+04, 3.4792663525E+01, 5.0150325312E+00, 1.7828307852E+01, 3.5182432203E+00, 9.7085995485E-01],
	[4.0570000000E+04, 3.4800164069E+01, 5.0150679118E+00, 1.7835505771E+01, 3.5186175485E+00, 9.7087304051E-01],
	[4.0575000000E+04, 3.4807665305E+01, 5.0151032883E+00, 1.7842705709E+01, 3.5189917804E+00, 9.7088611961E-01],
	[4.0580000000E+04, 3.4815167234E+01, 5.0151386607E+00, 1.7849907664E+01, 3.5193659161E+00, 9.7089919214E-01],
	[4.0585000000E+04, 3.4822669855E+01, 5.0151740291E+00, 1.7857111638E+01, 3.5197399555E+00, 9.7091225811E-01],
	[4.0590000000E+04, 3.4830173168E+01, 5.0152093933E+00, 1.7864317630E+01, 3.5201138987E+00, 9.7092531752E-01],
	[4.0595000000E+04, 3.4837677174E+01, 5.0152447534E+00, 1.7871525641E+01, 3.5204877458E+00, 9.7093837037E-01],
	[4.0600000000E+04, 3.4845181871E+01, 5.0152801093E+00, 1.7878735672E+01, 3.5208614966E+00, 9.7095141667E-01],
	[4.0605000000E+04, 3.4852687261E+01, 5.0153154612E+00, 1.7885947722E+01, 3.5212351513E+00, 9.7096445642E-01],
	[4.0610000000E+04, 3.4860193343E+01, 5.0153508090E+00, 1.7893161792E+01, 3.5216087099E+00, 9.7097748962E-01],
	[4.0615000000E+04, 3.4867700118E+01, 5.0153861527E+00, 1.7900377882E+01, 3.5219821724E+00, 9.7099051628E-01],
	[4.0620000000E+04, 3.4875207584E+01, 5.0154214923E+00, 1.7907595993E+01, 3.5223555388E+00, 9.7100353640E-01],
	[4.0625000000E+04, 3.4882715742E+01, 5.0154568277E+00, 1.7914816124E+01, 3.5227288092E+00, 9.7101654999E-01],
	[4.0630000000E+04, 3.4890224593E+01, 5.0154921591E+00, 1.7922038277E+01, 3.5231019835E+00, 9.7102955704E-01],
	[4.0635000000E+04, 3.4897734135E+01, 5.0155274864E+00, 1.7929262451E+01, 3.5234750618E+00, 9.7104255757E-01],
	[4.0640000000E+04, 3.4905244370E+01, 5.0155628096E+00, 1.7936488647E+01, 3.5238480441E+00, 9.7105555157E-01],
	[4.0645000000E+04, 3.4912755297E+01, 5.0155981286E+00, 1.7943716864E+01, 3.5242209305E+00, 9.7106853904E-01],
	[4.0650000000E+04, 3.4920266915E+01, 5.0156334436E+00, 1.7950947105E+01, 3.5245937209E+00, 9.7108152000E-01],
	[4.0655000000E+04, 3.4927779226E+01, 5.0156687545E+00, 1.7958179368E+01, 3.5249664153E+00, 9.7109449444E-01],
	[4.0660000000E+04, 3.4935292228E+01, 5.0157040613E+00, 1.7965413654E+01, 3.5253390139E+00, 9.7110746237E-01],
	[4.0665000000E+04, 3.4942805923E+01, 5.0157393640E+00, 1.7972649963E+01, 3.5257115166E+00, 9.7112042379E-01],
	[4.0670000000E+04, 3.4950320309E+01, 5.0157746626E+00, 1.7979888297E+01, 3.5260839234E+00, 9.7113337870E-01],
	[4.0675000000E+04, 3.4957835387E+01, 5.0158099571E+00, 1.7987128654E+01, 3.5264562344E+00, 9.7114632712E-01],
	[4.0680000000E+04, 3.4965351158E+01, 5.0158452476E+00, 1.7994371035E+01, 3.5268284496E+00, 9.7115926903E-01],
	[4.0685000000E+04, 3.4972867619E+01, 5.0158805339E+00, 1.8001615441E+01, 3.5272005689E+00, 9.7117220445E-01],
	[4.0690000000E+04, 3.4980384773E+01, 5.0159158162E+00, 1.8008861872E+01, 3.5275725925E+00, 9.7118513337E-01],
	[4.0695000000E+04, 3.4987902619E+01, 5.0159510943E+00, 1.8016110328E+01, 3.5279445204E+00, 9.7119805581E-01],
	[4.0700000000E+04, 3.4995421156E+01, 5.0159863684E+00, 1.8023360810E+01, 3.5283163525E+00, 9.7121097176E-01],
	[4.0705000000E+04, 3.5002940385E+01, 5.0160216384E+00, 1.8030613318E+01, 3.5286880889E+00, 9.7122388123E-01],
	[4.0710000000E+04, 3.5010460306E+01, 5.0160569043E+00, 1.8037867852E+01, 3.5290597296E+00, 9.7123678423E-01],
	[4.0715000000E+04, 3.5017980919E+01, 5.0160921662E+00, 1.8045124412E+01, 3.5294312746E+00, 9.7124968074E-01],
	[4.0720000000E+04, 3.5025502223E+01, 5.0161274239E+00, 1.8052383000E+01, 3.5298027241E+00, 9.7126257079E-01],
	[4.0725000000E+04, 3.5033024219E+01, 5.0161626776E+00, 1.8059643614E+01, 3.5301740778E+00, 9.7127545436E-01],
	[4.0730000000E+04, 3.5040546907E+01, 5.0161979271E+00, 1.8066906256E+01, 3.5305453360E+00, 9.7128833147E-01],
	[4.0735000000E+04, 3.5048070286E+01, 5.0162331726E+00, 1.8074170926E+01, 3.5309164986E+00, 9.7130120212E-01],
	[4.0740000000E+04, 3.5055594357E+01, 5.0162684141E+00, 1.8081437624E+01, 3.5312875657E+00, 9.7131406631E-01],
	[4.0745000000E+04, 3.5063119120E+01, 5.0163036514E+00, 1.8088706350E+01, 3.5316585372E+00, 9.7132692405E-01],
	[4.0750000000E+04, 3.5070644574E+01, 5.0163388847E+00, 1.8095977105E+01, 3.5320294132E+00, 9.7133977533E-01],
	[4.0755000000E+04, 3.5078170719E+01, 5.0163741139E+00, 1.8103249889E+01, 3.5324001937E+00, 9.7135262017E-01],
	[4.0760000000E+04, 3.5085697556E+01, 5.0164093390E+00, 1.8110524702E+01, 3.5327708788E+00, 9.7136545856E-01],
	[4.0765000000E+04, 3.5093225085E+01, 5.0164445601E+00, 1.8117801546E+01, 3.5331414684E+00, 9.7137829051E-01],
	[4.0770000000E+04, 3.5100753305E+01, 5.0164797770E+00, 1.8125080419E+01, 3.5335119626E+00, 9.7139111602E-01],
	[4.0775000000E+04, 3.5108282217E+01, 5.0165149899E+00, 1.8132361322E+01, 3.5338823613E+00, 9.7140393510E-01],
	[4.0780000000E+04, 3.5115811820E+01, 5.0165501988E+00, 1.8139644256E+01, 3.5342526647E+00, 9.7141674774E-01],
	[4.0785000000E+04, 3.5123342114E+01, 5.0165854035E+00, 1.8146929221E+01, 3.5346228728E+00, 9.7142955396E-01],
	[4.0790000000E+04, 3.5130873100E+01, 5.0166206042E+00, 1.8154216218E+01, 3.5349929854E+00, 9.7144235375E-01],
	[4.0795000000E+04, 3.5138404777E+01, 5.0166558009E+00, 1.8161505246E+01, 3.5353630028E+00, 9.7145514712E-01],
	[4.0800000000E+04, 3.5145937146E+01, 5.0166909934E+00, 1.8168796306E+01, 3.5357329249E+00, 9.7146793407E-01],
	[4.0805000000E+04, 3.5153470206E+01, 5.0167261819E+00, 1.8176089398E+01, 3.5361027517E+00, 9.7148071461E-01],
	[4.0810000000E+04, 3.5161003957E+01, 5.0167613664E+00, 1.8183384522E+01, 3.5364724833E+00, 9.7149348873E-01],
	[4.0815000000E+04, 3.5168538399E+01, 5.0167965467E+00, 1.8190681680E+01, 3.5368421196E+00, 9.7150625645E-01],
	[4.0820000000E+04, 3.5176073533E+01, 5.0168317230E+00, 1.8197980871E+01, 3.5372116608E+00, 9.7151901776E-01],
	[4.0825000000E+04, 3.5183609358E+01, 5.0168668953E+00, 1.8205282095E+01, 3.5375811067E+00, 9.7153177268E-01],
	[4.0830000000E+04, 3.5191145875E+01, 5.0169020635E+00, 1.8212585353E+01, 3.5379504575E+00, 9.7154452119E-01],
	[4.0835000000E+04, 3.5198683082E+01, 5.0169372276E+00, 1.8219890645E+01, 3.5383197131E+00, 9.7155726331E-01],
	[4.0840000000E+04, 3.5206220981E+01, 5.0169723876E+00, 1.8227197972E+01, 3.5386888736E+00, 9.7156999904E-01],
	[4.0845000000E+04, 3.5213759571E+01, 5.0170075437E+00, 1.8234507333E+01, 3.5390579391E+00, 9.7158272838E-01],
	[4.0850000000E+04, 3.5221298852E+01, 5.0170426956E+00, 1.8241818729E+01, 3.5394269094E+00, 9.7159545133E-01],
	[4.0855000000E+04, 3.5228838824E+01, 5.0170778435E+00, 1.8249132161E+01, 3.5397957847E+00, 9.7160816791E-01],
	[4.0860000000E+04, 3.5236379487E+01, 5.0171129873E+00, 1.8256447629E+01, 3.5401645650E+00, 9.7162087811E-01],
	[4.0865000000E+04, 3.5243920841E+01, 5.0171481271E+00, 1.8263765132E+01, 3.5405332502E+00, 9.7163358193E-01],
	[4.0870000000E+04, 3.5251462886E+01, 5.0171832628E+00, 1.8271084672E+01, 3.5409018405E+00, 9.7164627938E-01],
	[4.0875000000E+04, 3.5259005623E+01, 5.0172183945E+00, 1.8278406249E+01, 3.5412703358E+00, 9.7165897046E-01],
	[4.0880000000E+04, 3.5266549050E+01, 5.0172535221E+00, 1.8285729862E+01, 3.5416387362E+00, 9.7167165518E-01],
	[4.0885000000E+04, 3.5274093169E+01, 5.0172886457E+00, 1.8293055513E+01, 3.5420070416E+00, 9.7168433354E-01],
	[4.0890000000E+04, 3.5281637978E+01, 5.0173237652E+00, 1.8300383202E+01, 3.5423752521E+00, 9.7169700554E-01],
	[4.0895000000E+04, 3.5289183478E+01, 5.0173588807E+00, 1.8307712928E+01, 3.5427433678E+00, 9.7170967118E-01],
	[4.0900000000E+04, 3.5296729670E+01, 5.0173939922E+00, 1.8315044693E+01, 3.5431113886E+00, 9.7172233048E-01],
	[4.0905000000E+04, 3.5304276552E+01, 5.0174290995E+00, 1.8322378496E+01, 3.5434793146E+00, 9.7173498342E-01],
	[4.0910000000E+04, 3.5311824125E+01, 5.0174642029E+00, 1.8329714338E+01, 3.5438471457E+00, 9.7174763003E-01],
	[4.0915000000E+04, 3.5319372389E+01, 5.0174993022E+00, 1.8337052220E+01, 3.5442148821E+00, 9.7176027029E-01],
	[4.0920000000E+04, 3.5326921343E+01, 5.0175343974E+00, 1.8344392141E+01, 3.5445825237E+00, 9.7177290421E-01],
	[4.0925000000E+04, 3.5334470989E+01, 5.0175694886E+00, 1.8351734101E+01, 3.5449500706E+00, 9.7178553180E-01],
	[4.0930000000E+04, 3.5342021325E+01, 5.0176045758E+00, 1.8359078102E+01, 3.5453175227E+00, 9.7179815306E-01],
	[4.0935000000E+04, 3.5349572353E+01, 5.0176396589E+00, 1.8366424144E+01, 3.5456848801E+00, 9.7181076799E-01],
	[4.0940000000E+04, 3.5357124071E+01, 5.0176747380E+00, 1.8373772226E+01, 3.5460521428E+00, 9.7182337660E-01],
	[4.0945000000E+04, 3.5364676479E+01, 5.0177098131E+00, 1.8381122349E+01, 3.5464193109E+00, 9.7183597888E-01],
	[4.0950000000E+04, 3.5372229579E+01, 5.0177448841E+00, 1.8388474514E+01, 3.5467863844E+00, 9.7184857485E-01],
	[4.0955000000E+04, 3.5379783369E+01, 5.0177799510E+00, 1.8395828720E+01, 3.5471533632E+00, 9.7186116450E-01],
	[4.0960000000E+04, 3.5387337849E+01, 5.0178150140E+00, 1.8403184969E+01, 3.5475202475E+00, 9.7187374784E-01],
	[4.0965000000E+04, 3.5394893021E+01, 5.0178500729E+00, 1.8410543260E+01, 3.5478870371E+00, 9.7188632488E-01],
	[4.0970000000E+04, 3.5402448883E+01, 5.0178851278E+00, 1.8417903593E+01, 3.5482537322E+00, 9.7189889561E-01],
	[4.0975000000E+04, 3.5410005436E+01, 5.0179201786E+00, 1.8425265970E+01, 3.5486203328E+00, 9.7191146004E-01],
	[4.0980000000E+04, 3.5417562679E+01, 5.0179552254E+00, 1.8432630390E+01, 3.5489868389E+00, 9.7192401817E-01],
	[4.0985000000E+04, 3.5425120613E+01, 5.0179902682E+00, 1.8439996853E+01, 3.5493532505E+00, 9.7193657001E-01],
	[4.0990000000E+04, 3.5432679237E+01, 5.0180253069E+00, 1.8447365361E+01, 3.5497195677E+00, 9.7194911555E-01],
	[4.0995000000E+04, 3.5440238552E+01, 5.0180603416E+00, 1.8454735913E+01, 3.5500857904E+00, 9.7196165481E-01],
	[4.1000000000E+04, 3.5447798557E+01, 5.0180953723E+00, 1.8462108509E+01, 3.5504519186E+00, 9.7197418778E-01],
	[4.1005000000E+04, 3.5455359253E+01, 5.0181303990E+00, 1.8469483150E+01, 3.5508179525E+00, 9.7198671448E-01],
	[4.1010000000E+04, 3.5462920640E+01, 5.0181654216E+00, 1.8476859837E+01, 3.5511838920E+00, 9.7199923489E-01],
	[4.1015000000E+04, 3.5470482717E+01, 5.0182004402E+00, 1.8484238569E+01, 3.5515497372E+00, 9.7201174903E-01],
	[4.1020000000E+04, 3.5478045484E+01, 5.0182354548E+00, 1.8491619347E+01, 3.5519154880E+00, 9.7202425690E-01],
	[4.1025000000E+04, 3.5485608942E+01, 5.0182704653E+00, 1.8499002171E+01, 3.5522811446E+00, 9.7203675851E-01],
	[4.1030000000E+04, 3.5493173090E+01, 5.0183054719E+00, 1.8506387042E+01, 3.5526467068E+00, 9.7204925385E-01],
	[4.1035000000E+04, 3.5500737928E+01, 5.0183404744E+00, 1.8513773959E+01, 3.5530121748E+00, 9.7206174292E-01],
	[4.1040000000E+04, 3.5508303457E+01, 5.0183754729E+00, 1.8521162924E+01, 3.5533775485E+00, 9.7207422574E-01],
	[4.1045000000E+04, 3.5515869676E+01, 5.0184104674E+00, 1.8528553936E+01, 3.5537428280E+00, 9.7208670231E-01],
	[4.1050000000E+04, 3.5523436585E+01, 5.0184454578E+00, 1.8535946996E+01, 3.5541080133E+00, 9.7209917262E-01],
	[4.1055000000E+04, 3.5531004185E+01, 5.0184804443E+00, 1.8543342104E+01, 3.5544731045E+00, 9.7211163669E-01],
	[4.1060000000E+04, 3.5538572475E+01, 5.0185154267E+00, 1.8550739260E+01, 3.5548381015E+00, 9.7212409451E-01],
	[4.1065000000E+04, 3.5546141455E+01, 5.0185504051E+00, 1.8558138465E+01, 3.5552030043E+00, 9.7213654609E-01],
	[4.1070000000E+04, 3.5553711125E+01, 5.0185853795E+00, 1.8565539720E+01, 3.5555678131E+00, 9.7214899143E-01],
	[4.1075000000E+04, 3.5561281486E+01, 5.0186203498E+00, 1.8572943023E+01, 3.5559325277E+00, 9.7216143054E-01],
	[4.1080000000E+04, 3.5568852536E+01, 5.0186553162E+00, 1.8580348376E+01, 3.5562971483E+00, 9.7217386342E-01],
	[4.1085000000E+04, 3.5576424277E+01, 5.0186902786E+00, 1.8587755779E+01, 3.5566616748E+00, 9.7218629006E-01],
	[4.1090000000E+04, 3.5583996708E+01, 5.0187252369E+00, 1.8595165233E+01, 3.5570261074E+00, 9.7219871049E-01],
	[4.1095000000E+04, 3.5591569829E+01, 5.0187601912E+00, 1.8602576737E+01, 3.5573904459E+00, 9.7221112469E-01],
	[4.1100000000E+04, 3.5599143640E+01, 5.0187951415E+00, 1.8609990292E+01, 3.5577546904E+00, 9.7222353268E-01],
	[4.1105000000E+04, 3.5606718142E+01, 5.0188300879E+00, 1.8617405898E+01, 3.5581188410E+00, 9.7223593445E-01],
	[4.1110000000E+04, 3.5614293333E+01, 5.0188650302E+00, 1.8624823556E+01, 3.5584828977E+00, 9.7224833001E-01],
	[4.1115000000E+04, 3.5621869214E+01, 5.0188999685E+00, 1.8632243266E+01, 3.5588468604E+00, 9.7226071936E-01],
	[4.1120000000E+04, 3.5629445785E+01, 5.0189349028E+00, 1.8639665028E+01, 3.5592107293E+00, 9.7227310251E-01],
	[4.1125000000E+04, 3.5637023047E+01, 5.0189698330E+00, 1.8647088843E+01, 3.5595745042E+00, 9.7228547945E-01],
	[4.1130000000E+04, 3.5644600998E+01, 5.0190047593E+00, 1.8654514710E+01, 3.5599381854E+00, 9.7229785020E-01],
	[4.1135000000E+04, 3.5652179639E+01, 5.0190396816E+00, 1.8661942631E+01, 3.5603017727E+00, 9.7231021475E-01],
	[4.1140000000E+04, 3.5659758970E+01, 5.0190745999E+00, 1.8669372605E+01, 3.5606652662E+00, 9.7232257311E-01],
	[4.1145000000E+04, 3.5667338991E+01, 5.0191095142E+00, 1.8676804633E+01, 3.5610286659E+00, 9.7233492529E-01],
	[4.1150000000E+04, 3.5674919702E+01, 5.0191444245E+00, 1.8684238715E+01, 3.5613919719E+00, 9.7234727128E-01],
	[4.1155000000E+04, 3.5682501103E+01, 5.0191793307E+00, 1.8691674851E+01, 3.5617551841E+00, 9.7235961108E-01],
	[4.1160000000E+04, 3.5690083193E+01, 5.0192142330E+00, 1.8699113043E+01, 3.5621183026E+00, 9.7237194471E-01],
	[4.1165000000E+04, 3.5697674820E+01, 5.0192501769E+00, 1.8706553289E+01, 3.5624819423E+00, 9.7238427217E-01],
	[4.1170000000E+04, 3.5705275146E+01, 5.0192870630E+00, 1.8713995591E+01, 3.5628460449E+00, 9.7239659345E-01],
	[4.1175000000E+04, 3.5712876168E+01, 5.0193239449E+00, 1.8721439948E+01, 3.5632100542E+00, 9.7240890856E-01],
	[4.1180000000E+04, 3.5720477884E+01, 5.0193608226E+00, 1.8728886362E+01, 3.5635739701E+00, 9.7242121751E-01],
	[4.1185000000E+04, 3.5728080295E+01, 5.0193976960E+00, 1.8736334831E+01, 3.5639377926E+00, 9.7243352030E-01],
	[4.1190000000E+04, 3.5735683402E+01, 5.0194345653E+00, 1.8743785358E+01, 3.5643015219E+00, 9.7244581693E-01],
	[4.1195000000E+04, 3.5743287202E+01, 5.0194714304E+00, 1.8751237941E+01, 3.5646651577E+00, 9.7245810740E-01],
	[4.1200000000E+04, 3.5750891698E+01, 5.0195082912E+00, 1.8758692582E+01, 3.5650287004E+00, 9.7247039173E-01],
	[4.1205000000E+04, 3.5758496889E+01, 5.0195451479E+00, 1.8766149280E+01, 3.5653921497E+00, 9.7248266990E-01],
	[4.1210000000E+04, 3.5766102774E+01, 5.0195820003E+00, 1.8773608037E+01, 3.5657555058E+00, 9.7249494193E-01],
	[4.1215000000E+04, 3.5773709354E+01, 5.0196188486E+00, 1.8781068851E+01, 3.5661187686E+00, 9.7250720781E-01],
	[4.1220000000E+04, 3.5781316628E+01, 5.0196556927E+00, 1.8788531724E+01, 3.5664819383E+00, 9.7251946756E-01],
	[4.1225000000E+04, 3.5788924598E+01, 5.0196925325E+00, 1.8795996657E+01, 3.5668450148E+00, 9.7253172118E-01],
	[4.1230000000E+04, 3.5796533262E+01, 5.0197293682E+00, 1.8803463648E+01, 3.5672079981E+00, 9.7254396866E-01],
	[4.1235000000E+04, 3.5804142620E+01, 5.0197661996E+00, 1.8810932699E+01, 3.5675708883E+00, 9.7255621001E-01],
	[4.1240000000E+04, 3.5811752673E+01, 5.0198030269E+00, 1.8818403809E+01, 3.5679336854E+00, 9.7256844524E-01],
	[4.1245000000E+04, 3.5819363421E+01, 5.0198398500E+00, 1.8825876980E+01, 3.5682963894E+00, 9.7258067434E-01],
	[4.1250000000E+04, 3.5826974864E+01, 5.0198766689E+00, 1.8833352211E+01, 3.5686590003E+00, 9.7259289733E-01],
	[4.1255000000E+04, 3.5834587001E+01, 5.0199134836E+00, 1.8840829503E+01, 3.5690215182E+00, 9.7260511420E-01],
	[4.1260000000E+04, 3.5842199832E+01, 5.0199502941E+00, 1.8848308857E+01, 3.5693839430E+00, 9.7261732495E-01],
	[4.1265000000E+04, 3.5849813358E+01, 5.0199871004E+00, 1.8855790271E+01, 3.5697462748E+00, 9.7262952960E-01],
	[4.1270000000E+04, 3.5857427579E+01, 5.0200239025E+00, 1.8863273748E+01, 3.5701085137E+00, 9.7264172815E-01],
	[4.1275000000E+04, 3.5865042494E+01, 5.0200607004E+00, 1.8870759286E+01, 3.5704706596E+00, 9.7265392059E-01],
	[4.1280000000E+04, 3.5872658103E+01, 5.0200974941E+00, 1.8878246887E+01, 3.5708327125E+00, 9.7266610693E-01],
	[4.1285000000E+04, 3.5880274407E+01, 5.0201342837E+00, 1.8885736550E+01, 3.5711946726E+00, 9.7267828718E-01],
	[4.1290000000E+04, 3.5887891405E+01, 5.0201710691E+00, 1.8893228277E+01, 3.5715565397E+00, 9.7269046133E-01],
	[4.1295000000E+04, 3.5895509098E+01, 5.0202078502E+00, 1.8900722067E+01, 3.5719183140E+00, 9.7270262939E-01],
	[4.1300000000E+04, 3.5903127485E+01, 5.0202446272E+00, 1.8908217921E+01, 3.5722799954E+00, 9.7271479137E-01],
	[4.1305000000E+04, 3.5910746567E+01, 5.0202814001E+00, 1.8915715838E+01, 3.5726415839E+00, 9.7272694727E-01],
	[4.1310000000E+04, 3.5918366342E+01, 5.0203181687E+00, 1.8923215820E+01, 3.5730030797E+00, 9.7273909708E-01],
	[4.1315000000E+04, 3.5925986812E+01, 5.0203549332E+00, 1.8930717866E+01, 3.5733644827E+00, 9.7275124082E-01],
	[4.1320000000E+04, 3.5933607977E+01, 5.0203916934E+00, 1.8938221978E+01, 3.5737257929E+00, 9.7276337849E-01],
	[4.1325000000E+04, 3.5941229835E+01, 5.0204284495E+00, 1.8945728154E+01, 3.5740870104E+00, 9.7277551009E-01],
	[4.1330000000E+04, 3.5948852388E+01, 5.0204652014E+00, 1.8953236397E+01, 3.5744481352E+00, 9.7278763562E-01],
	[4.1335000000E+04, 3.5956475635E+01, 5.0205019492E+00, 1.8960746705E+01, 3.5748091672E+00, 9.7279975509E-01],
	[4.1340000000E+04, 3.5964099576E+01, 5.0205386927E+00, 1.8968259079E+01, 3.5751701066E+00, 9.7281186849E-01],
	[4.1345000000E+04, 3.5971724212E+01, 5.0205754321E+00, 1.8975773520E+01, 3.5755309533E+00, 9.7282397585E-01],
	[4.1350000000E+04, 3.5979349541E+01, 5.0206121673E+00, 1.8983290028E+01, 3.5758917074E+00, 9.7283607714E-01],
	[4.1355000000E+04, 3.5986975565E+01, 5.0206488984E+00, 1.8990808603E+01, 3.5762523689E+00, 9.7284817239E-01],
	[4.1360000000E+04, 3.5994602283E+01, 5.0206856253E+00, 1.8998329245E+01, 3.5766129378E+00, 9.7286026159E-01],
	[4.1365000000E+04, 3.6002229695E+01, 5.0207223480E+00, 1.9005851955E+01, 3.5769734141E+00, 9.7287234475E-01],
	[4.1370000000E+04, 3.6009857801E+01, 5.0207590665E+00, 1.9013376733E+01, 3.5773337979E+00, 9.7288442187E-01],
	[4.1375000000E+04, 3.6017486601E+01, 5.0207957809E+00, 1.9020903580E+01, 3.5776940892E+00, 9.7289649295E-01],
	[4.1380000000E+04, 3.6025116095E+01, 5.0208324910E+00, 1.9028432495E+01, 3.5780542879E+00, 9.7290855800E-01],
	[4.1385000000E+04, 3.6032746284E+01, 5.0208691971E+00, 1.9035963480E+01, 3.5784143942E+00, 9.7292061702E-01],
	[4.1390000000E+04, 3.6040377166E+01, 5.0209058989E+00, 1.9043496534E+01, 3.5787744080E+00, 9.7293267001E-01],
	[4.1395000000E+04, 3.6048008742E+01, 5.0209425966E+00, 1.9051031657E+01, 3.5791343294E+00, 9.7294471698E-01],
	[4.1400000000E+04, 3.6055641012E+01, 5.0209792902E+00, 1.9058568851E+01, 3.5794941584E+00, 9.7295675792E-01],
	[4.1405000000E+04, 3.6063273976E+01, 5.0210159795E+00, 1.9066108115E+01, 3.5798538950E+00, 9.7296879285E-01],
	[4.1410000000E+04, 3.6070907634E+01, 5.0210526647E+00, 1.9073649449E+01, 3.5802135392E+00, 9.7298082176E-01],
	[4.1415000000E+04, 3.6078541986E+01, 5.0210893458E+00, 1.9081192855E+01, 3.5805730910E+00, 9.7299284467E-01],
	[4.1420000000E+04, 3.6086177032E+01, 5.0211260227E+00, 1.9088738332E+01, 3.5809325506E+00, 9.7300486157E-01],
	[4.1425000000E+04, 3.6093812771E+01, 5.0211626954E+00, 1.9096285880E+01, 3.5812919178E+00, 9.7301687246E-01],
	[4.1430000000E+04, 3.6101449205E+01, 5.0211993639E+00, 1.9103835501E+01, 3.5816511927E+00, 9.7302887735E-01],
	[4.1435000000E+04, 3.6109086332E+01, 5.0212360283E+00, 1.9111387193E+01, 3.5820103754E+00, 9.7304087624E-01],
	[4.1440000000E+04, 3.6116724153E+01, 5.0212726886E+00, 1.9118940959E+01, 3.5823694659E+00, 9.7305286914E-01],
	[4.1445000000E+04, 3.6124362668E+01, 5.0213093447E+00, 1.9126496797E+01, 3.5827284641E+00, 9.7306485605E-01],
	[4.1450000000E+04, 3.6132001876E+01, 5.0213459966E+00, 1.9134054708E+01, 3.5830873701E+00, 9.7307683697E-01],
	[4.1455000000E+04, 3.6139641778E+01, 5.0213826444E+00, 1.9141614693E+01, 3.5834461840E+00, 9.7308881190E-01],
	[4.1460000000E+04, 3.6147282374E+01, 5.0214192881E+00, 1.9149176752E+01, 3.5838049057E+00, 9.7310078086E-01],
	[4.1465000000E+04, 3.6154923664E+01, 5.0214559275E+00, 1.9156740885E+01, 3.5841635353E+00, 9.7311274383E-01],
	[4.1470000000E+04, 3.6162565647E+01, 5.0214925629E+00, 1.9164307092E+01, 3.5845220728E+00, 9.7312470083E-01],
	[4.1475000000E+04, 3.6170208324E+01, 5.0215291941E+00, 1.9171875374E+01, 3.5848805182E+00, 9.7313665186E-01],
	[4.1480000000E+04, 3.6177851695E+01, 5.0215658211E+00, 1.9179445731E+01, 3.5852388715E+00, 9.7314859692E-01],
	[4.1485000000E+04, 3.6185495759E+01, 5.0216024440E+00, 1.9187018164E+01, 3.5855971328E+00, 9.7316053602E-01],
	[4.1490000000E+04, 3.6193140517E+01, 5.0216390627E+00, 1.9194592673E+01, 3.5859553020E+00, 9.7317246915E-01],
	[4.1495000000E+04, 3.6200785968E+01, 5.0216756773E+00, 1.9202169257E+01, 3.5863133793E+00, 9.7318439632E-01],
	[4.1500000000E+04, 3.6208432113E+01, 5.0217122878E+00, 1.9209747918E+01, 3.5866713646E+00, 9.7319631754E-01],
	[4.1505000000E+04, 3.6216078951E+01, 5.0217488941E+00, 1.9217328656E+01, 3.5870292580E+00, 9.7320823281E-01],
	[4.1510000000E+04, 3.6223726483E+01, 5.0217854962E+00, 1.9224911470E+01, 3.5873870594E+00, 9.7322014212E-01],
	[4.1515000000E+04, 3.6231374709E+01, 5.0218220943E+00, 1.9232496362E+01, 3.5877447689E+00, 9.7323204550E-01],
	[4.1520000000E+04, 3.6239023627E+01, 5.0218586881E+00, 1.9240083332E+01, 3.5881023865E+00, 9.7324394292E-01],
	[4.1525000000E+04, 3.6246673240E+01, 5.0218952779E+00, 1.9247672380E+01, 3.5884599122E+00, 9.7325583441E-01],
	[4.1530000000E+04, 3.6254323545E+01, 5.0219318635E+00, 1.9255263506E+01, 3.5888173461E+00, 9.7326771997E-01],
	[4.1535000000E+04, 3.6261974544E+01, 5.0219684450E+00, 1.9262856710E+01, 3.5891746882E+00, 9.7327959959E-01],
	[4.1540000000E+04, 3.6269626237E+01, 5.0220050223E+00, 1.9270451994E+01, 3.5895319385E+00, 9.7329147328E-01],
	[4.1545000000E+04, 3.6277278623E+01, 5.0220415955E+00, 1.9278049356E+01, 3.5898890970E+00, 9.7330334104E-01],
	[4.1550000000E+04, 3.6284931702E+01, 5.0220781645E+00, 1.9285648799E+01, 3.5902461637E+00, 9.7331520289E-01],
	[4.1555000000E+04, 3.6292585474E+01, 5.0221147295E+00, 1.9293250321E+01, 3.5906031387E+00, 9.7332705881E-01],
	[4.1560000000E+04, 3.6300239940E+01, 5.0221512902E+00, 1.9300853923E+01, 3.5909600220E+00, 9.7333890881E-01],
	[4.1565000000E+04, 3.6307895099E+01, 5.0221878469E+00, 1.9308459606E+01, 3.5913168136E+00, 9.7335075291E-01],
	[4.1570000000E+04, 3.6315550951E+01, 5.0222243994E+00, 1.9316067370E+01, 3.5916735136E+00, 9.7336259109E-01],
	[4.1575000000E+04, 3.6323207497E+01, 5.0222609478E+00, 1.9323677215E+01, 3.5920301219E+00, 9.7337442336E-01],
	[4.1580000000E+04, 3.6330864736E+01, 5.0222974921E+00, 1.9331289142E+01, 3.5923866385E+00, 9.7338624973E-01],
	[4.1585000000E+04, 3.6338522668E+01, 5.0223340322E+00, 1.9338903150E+01, 3.5927430636E+00, 9.7339807020E-01],
	[4.1590000000E+04, 3.6346181293E+01, 5.0223705682E+00, 1.9346519240E+01, 3.5930993971E+00, 9.7340988478E-01],
	[4.1595000000E+04, 3.6353840611E+01, 5.0224071001E+00, 1.9354137413E+01, 3.5934556390E+00, 9.7342169345E-01],
	[4.1600000000E+04, 3.6361500622E+01, 5.0224436279E+00, 1.9361757669E+01, 3.5938117894E+00, 9.7343349624E-01],
	[4.1605000000E+04, 3.6369161327E+01, 5.0224801515E+00, 1.9369380007E+01, 3.5941678483E+00, 9.7344529314E-01],
	[4.1610000000E+04, 3.6376822724E+01, 5.0225166710E+00, 1.9377004429E+01, 3.5945238157E+00, 9.7345708416E-01],
	[4.1615000000E+04, 3.6384484815E+01, 5.0225531864E+00, 1.9384630935E+01, 3.5948796916E+00, 9.7346886929E-01],
	[4.1620000000E+04, 3.6392147599E+01, 5.0225896977E+00, 1.9392259525E+01, 3.5952354760E+00, 9.7348064855E-01],
	[4.1625000000E+04, 3.6399811075E+01, 5.0226262048E+00, 1.9399890199E+01, 3.5955911691E+00, 9.7349242193E-01],
	[4.1630000000E+04, 3.6407475245E+01, 5.0226627079E+00, 1.9407522958E+01, 3.5959467707E+00, 9.7350418944E-01],
	[4.1635000000E+04, 3.6415140108E+01, 5.0226992068E+00, 1.9415157802E+01, 3.5963022810E+00, 9.7351595109E-01],
	[4.1640000000E+04, 3.6422805663E+01, 5.0227357016E+00, 1.9422794731E+01, 3.5966576999E+00, 9.7352770686E-01],
	[4.1645000000E+04, 3.6430471912E+01, 5.0227721922E+00, 1.9430433746E+01, 3.5970130274E+00, 9.7353945678E-01],
	[4.1650000000E+04, 3.6438138853E+01, 5.0228086788E+00, 1.9438074847E+01, 3.5973682636E+00, 9.7355120084E-01],
	[4.1655000000E+04, 3.6445806488E+01, 5.0228451612E+00, 1.9445718034E+01, 3.5977234086E+00, 9.7356293904E-01],
	[4.1660000000E+04, 3.6453474815E+01, 5.0228816396E+00, 1.9453363307E+01, 3.5980784622E+00, 9.7357467139E-01],
	[4.1665000000E+04, 3.6461143835E+01, 5.0229181138E+00, 1.9461010668E+01, 3.5984334246E+00, 9.7358639789E-01],
	[4.1670000000E+04, 3.6468813548E+01, 5.0229545839E+00, 1.9468660115E+01, 3.5987882958E+00, 9.7359811854E-01],
	[4.1675000000E+04, 3.6476483954E+01, 5.0229910499E+00, 1.9476311651E+01, 3.5991430758E+00, 9.7360983335E-01],
	[4.1680000000E+04, 3.6484155053E+01, 5.0230275117E+00, 1.9483965274E+01, 3.5994977646E+00, 9.7362154232E-01],
	[4.1685000000E+04, 3.6491826844E+01, 5.0230639695E+00, 1.9491620985E+01, 3.5998523622E+00, 9.7363324546E-01],
	[4.1690000000E+04, 3.6499499328E+01, 5.0231004232E+00, 1.9499278785E+01, 3.6002068687E+00, 9.7364494276E-01],
	[4.1695000000E+04, 3.6507172505E+01, 5.0231368727E+00, 1.9506938673E+01, 3.6005612841E+00, 9.7365663424E-01],
	[4.1700000000E+04, 3.6514846375E+01, 5.0231733182E+00, 1.9514600651E+01, 3.6009156083E+00, 9.7366831988E-01],
	[4.1705000000E+04, 3.6522520937E+01, 5.0232097595E+00, 1.9522264718E+01, 3.6012698415E+00, 9.7367999971E-01],
	[4.1710000000E+04, 3.6530196192E+01, 5.0232461968E+00, 1.9529930875E+01, 3.6016239837E+00, 9.7369167371E-01],
	[4.1715000000E+04, 3.6537872140E+01, 5.0232826299E+00, 1.9537599122E+01, 3.6019780348E+00, 9.7370334190E-01],
	[4.1720000000E+04, 3.6545548780E+01, 5.0233190590E+00, 1.9545269460E+01, 3.6023319949E+00, 9.7371500427E-01],
	[4.1725000000E+04, 3.6553226113E+01, 5.0233554839E+00, 1.9552941888E+01, 3.6026858640E+00, 9.7372666083E-01],
	[4.1730000000E+04, 3.6560904139E+01, 5.0233919047E+00, 1.9560616407E+01, 3.6030396421E+00, 9.7373831158E-01],
	[4.1735000000E+04, 3.6568582857E+01, 5.0234283215E+00, 1.9568293018E+01, 3.6033933293E+00, 9.7374995653E-01],
	[4.1740000000E+04, 3.6576262267E+01, 5.0234647341E+00, 1.9575971720E+01, 3.6037469256E+00, 9.7376159568E-01],
	[4.1745000000E+04, 3.6583942371E+01, 5.0235011426E+00, 1.9583652514E+01, 3.6041004310E+00, 9.7377322903E-01],
	[4.1750000000E+04, 3.6591623166E+01, 5.0235375471E+00, 1.9591335401E+01, 3.6044538455E+00, 9.7378485659E-01],
	[4.1755000000E+04, 3.6599304654E+01, 5.0235739474E+00, 1.9599020380E+01, 3.6048071691E+00, 9.7379647836E-01],
	[4.1760000000E+04, 3.6606986835E+01, 5.0236103437E+00, 1.9606707453E+01, 3.6051604020E+00, 9.7380809433E-01],
	[4.1765000000E+04, 3.6614669708E+01, 5.0236467358E+00, 1.9614396618E+01, 3.6055135440E+00, 9.7381970452E-01],
	[4.1770000000E+04, 3.6622353274E+01, 5.0236831239E+00, 1.9622087877E+01, 3.6058665952E+00, 9.7383130893E-01],
	[4.1775000000E+04, 3.6630037532E+01, 5.0237195079E+00, 1.9629781230E+01, 3.6062195556E+00, 9.7384290757E-01],
	[4.1780000000E+04, 3.6637722482E+01, 5.0237558877E+00, 1.9637476677E+01, 3.6065724253E+00, 9.7385450042E-01],
	[4.1785000000E+04, 3.6645408125E+01, 5.0237922635E+00, 1.9645174219E+01, 3.6069252043E+00, 9.7386608750E-01],
	[4.1790000000E+04, 3.6653094460E+01, 5.0238286352E+00, 1.9652873856E+01, 3.6072778925E+00, 9.7387766882E-01],
	[4.1795000000E+04, 3.6660781487E+01, 5.0238650029E+00, 1.9660575588E+01, 3.6076304901E+00, 9.7388924437E-01],
	[4.1800000000E+04, 3.6668469207E+01, 5.0239013664E+00, 1.9668279415E+01, 3.6079829971E+00, 9.7390081415E-01],
	[4.1805000000E+04, 3.6676157619E+01, 5.0239377258E+00, 1.9675985339E+01, 3.6083354134E+00, 9.7391237818E-01],
	[4.1810000000E+04, 3.6683846723E+01, 5.0239740812E+00, 1.9683693358E+01, 3.6086877391E+00, 9.7392393645E-01],
	[4.1815000000E+04, 3.6691536519E+01, 5.0240104324E+00, 1.9691403474E+01, 3.6090399741E+00, 9.7393548897E-01],
	[4.1820000000E+04, 3.6699227008E+01, 5.0240467796E+00, 1.9699115686E+01, 3.6093921187E+00, 9.7394703573E-01],
	[4.1825000000E+04, 3.6706918189E+01, 5.0240831227E+00, 1.9706829996E+01, 3.6097441726E+00, 9.7395857675E-01],
	[4.1830000000E+04, 3.6714626708E+01, 5.0241213977E+00, 1.9714546403E+01, 3.6100972966E+00, 9.7397011203E-01],
	[4.1835000000E+04, 3.6722336037E+01, 5.0241596815E+00, 1.9722264908E+01, 3.6104503381E+00, 9.7398164156E-01],
	[4.1840000000E+04, 3.6730046063E+01, 5.0241979610E+00, 1.9729985511E+01, 3.6108032894E+00, 9.7399316536E-01],
	[4.1845000000E+04, 3.6737756787E+01, 5.0242362362E+00, 1.9737708213E+01, 3.6111561505E+00, 9.7400468342E-01],
	[4.1850000000E+04, 3.6745468207E+01, 5.0242745072E+00, 1.9745433013E+01, 3.6115089214E+00, 9.7401619576E-01],
	[4.1855000000E+04, 3.6753180325E+01, 5.0243127738E+00, 1.9753159912E+01, 3.6118616020E+00, 9.7402770236E-01],
	[4.1860000000E+04, 3.6760893139E+01, 5.0243510362E+00, 1.9760888910E+01, 3.6122141926E+00, 9.7403920324E-01],
	[4.1865000000E+04, 3.6768606651E+01, 5.0243892944E+00, 1.9768620009E+01, 3.6125666929E+00, 9.7405069840E-01],
	[4.1870000000E+04, 3.6776320860E+01, 5.0244275482E+00, 1.9776353207E+01, 3.6129191032E+00, 9.7406218784E-01],
	[4.1875000000E+04, 3.6784035766E+01, 5.0244657977E+00, 1.9784088505E+01, 3.6132714234E+00, 9.7407367157E-01],
	[4.1880000000E+04, 3.6791751369E+01, 5.0245040430E+00, 1.9791825904E+01, 3.6136236535E+00, 9.7408514958E-01],
	[4.1885000000E+04, 3.6799467669E+01, 5.0245422840E+00, 1.9799565404E+01, 3.6139757935E+00, 9.7409662188E-01],
	[4.1890000000E+04, 3.6807184666E+01, 5.0245805208E+00, 1.9807307005E+01, 3.6143278435E+00, 9.7410808848E-01],
	[4.1895000000E+04, 3.6814902359E+01, 5.0246187532E+00, 1.9815050708E+01, 3.6146798035E+00, 9.7411954938E-01],
	[4.1900000000E+04, 3.6822620750E+01, 5.0246569814E+00, 1.9822796513E+01, 3.6150316735E+00, 9.7413100458E-01],
	[4.1905000000E+04, 3.6830339838E+01, 5.0246952053E+00, 1.9830544420E+01, 3.6153834536E+00, 9.7414245408E-01],
	[4.1910000000E+04, 3.6838059622E+01, 5.0247334250E+00, 1.9838294429E+01, 3.6157351437E+00, 9.7415389788E-01],
	[4.1915000000E+04, 3.6845780104E+01, 5.0247716404E+00, 1.9846046541E+01, 3.6160867439E+00, 9.7416533600E-01],
	[4.1920000000E+04, 3.6853501282E+01, 5.0248098515E+00, 1.9853800757E+01, 3.6164382542E+00, 9.7417676843E-01],
	[4.1925000000E+04, 3.6861223157E+01, 5.0248480583E+00, 1.9861557076E+01, 3.6167896746E+00, 9.7418819518E-01],
	[4.1930000000E+04, 3.6868945729E+01, 5.0248862609E+00, 1.9869315499E+01, 3.6171410051E+00, 9.7419961625E-01],
	[4.1935000000E+04, 3.6876668997E+01, 5.0249244592E+00, 1.9877076026E+01, 3.6174922459E+00, 9.7421103164E-01],
	[4.1940000000E+04, 3.6884392963E+01, 5.0249626533E+00, 1.9884838657E+01, 3.6178433968E+00, 9.7422244135E-01],
	[4.1945000000E+04, 3.6892117625E+01, 5.0250008431E+00, 1.9892603393E+01, 3.6181944579E+00, 9.7423384540E-01],
	[4.1950000000E+04, 3.6899842984E+01, 5.0250390286E+00, 1.9900370234E+01, 3.6185454292E+00, 9.7424524377E-01],
	[4.1955000000E+04, 3.6907569040E+01, 5.0250772099E+00, 1.9908139181E+01, 3.6188963109E+00, 9.7425663648E-01],
	[4.1960000000E+04, 3.6915295792E+01, 5.0251153869E+00, 1.9915910233E+01, 3.6192471027E+00, 9.7426802353E-01],
	[4.1965000000E+04, 3.6923023241E+01, 5.0251535596E+00, 1.9923683392E+01, 3.6195978049E+00, 9.7427940493E-01],
	[4.1970000000E+04, 3.6930751386E+01, 5.0251917281E+00, 1.9931458656E+01, 3.6199484174E+00, 9.7429078066E-01],
	[4.1975000000E+04, 3.6938480229E+01, 5.0252298923E+00, 1.9939236028E+01, 3.6202989403E+00, 9.7430215075E-01],
	[4.1980000000E+04, 3.6946209767E+01, 5.0252680523E+00, 1.9947015506E+01, 3.6206493735E+00, 9.7431351518E-01],
	[4.1985000000E+04, 3.6953940003E+01, 5.0253062080E+00, 1.9954797092E+01, 3.6209997170E+00, 9.7432487397E-01],
	[4.1990000000E+04, 3.6961670935E+01, 5.0253443595E+00, 1.9962580786E+01, 3.6213499710E+00, 9.7433622712E-01],
	[4.1995000000E+04, 3.6969402563E+01, 5.0253825067E+00, 1.9970366587E+01, 3.6217001355E+00, 9.7434757463E-01],
	[4.2000000000E+04, 3.6977134888E+01, 5.0254206497E+00, 1.9978154497E+01, 3.6220502103E+00, 9.7435891650E-01],
	[4.2005000000E+04, 3.6984867910E+01, 5.0254587884E+00, 1.9985944515E+01, 3.6224001957E+00, 9.7437025273E-01],
	[4.2010000000E+04, 3.6992601628E+01, 5.0254969228E+00, 1.9993736642E+01, 3.6227500915E+00, 9.7438158334E-01],
	[4.2015000000E+04, 3.7000336042E+01, 5.0255350531E+00, 2.0001530879E+01, 3.6230998979E+00, 9.7439290832E-01],
	[4.2020000000E+04, 3.7008071153E+01, 5.0255731790E+00, 2.0009327225E+01, 3.6234496148E+00, 9.7440422768E-01],
	[4.2025000000E+04, 3.7015806961E+01, 5.0256113007E+00, 2.0017125681E+01, 3.6237992422E+00, 9.7441554141E-01],
	[4.2030000000E+04, 3.7023543464E+01, 5.0256494182E+00, 2.0024926247E+01, 3.6241487802E+00, 9.7442684953E-01],
	[4.2035000000E+04, 3.7031280665E+01, 5.0256875314E+00, 2.0032728923E+01, 3.6244982289E+00, 9.7443815204E-01],
	[4.2040000000E+04, 3.7039018561E+01, 5.0257256404E+00, 2.0040533711E+01, 3.6248475881E+00, 9.7444944893E-01],
	[4.2045000000E+04, 3.7046757154E+01, 5.0257637451E+00, 2.0048340609E+01, 3.6251968580E+00, 9.7446074021E-01],
	[4.2050000000E+04, 3.7054496443E+01, 5.0258018456E+00, 2.0056149620E+01, 3.6255460386E+00, 9.7447202589E-01],
	[4.2055000000E+04, 3.7062236428E+01, 5.0258399419E+00, 2.0063960741E+01, 3.6258951299E+00, 9.7448330597E-01],
	[4.2060000000E+04, 3.7069977110E+01, 5.0258780339E+00, 2.0071773975E+01, 3.6262441319E+00, 9.7449458045E-01],
	[4.2065000000E+04, 3.7077718488E+01, 5.0259161217E+00, 2.0079589322E+01, 3.6265930446E+00, 9.7450584933E-01],
	[4.2070000000E+04, 3.7085460562E+01, 5.0259542052E+00, 2.0087406781E+01, 3.6269418681E+00, 9.7451711262E-01],
	[4.2075000000E+04, 3.7093203333E+01, 5.0259922845E+00, 2.0095226353E+01, 3.6272906023E+00, 9.7452837032E-01],
	[4.2080000000E+04, 3.7100946800E+01, 5.0260303596E+00, 2.0103048039E+01, 3.6276392473E+00, 9.7453962243E-01],
	[4.2085000000E+04, 3.7108690962E+01, 5.0260684304E+00, 2.0110871839E+01, 3.6279878032E+00, 9.7455086896E-01],
	[4.2090000000E+04, 3.7116435821E+01, 5.0261064970E+00, 2.0118697752E+01, 3.6283362699E+00, 9.7456210991E-01],
	[4.2095000000E+04, 3.7124181377E+01, 5.0261445593E+00, 2.0126525780E+01, 3.6286846475E+00, 9.7457334528E-01],
	[4.2100000000E+04, 3.7131927628E+01, 5.0261826175E+00, 2.0134355922E+01, 3.6290329360E+00, 9.7458457508E-01],
	[4.2105000000E+04, 3.7139674575E+01, 5.0262206714E+00, 2.0142188180E+01, 3.6293811354E+00, 9.7459579931E-01],
	[4.2110000000E+04, 3.7147422219E+01, 5.0262587210E+00, 2.0150022552E+01, 3.6297292457E+00, 9.7460701797E-01],
	[4.2115000000E+04, 3.7155170558E+01, 5.0262967665E+00, 2.0157859041E+01, 3.6300772669E+00, 9.7461823106E-01],
	[4.2120000000E+04, 3.7162919594E+01, 5.0263348077E+00, 2.0165697645E+01, 3.6304251991E+00, 9.7462943860E-01],
	[4.2125000000E+04, 3.7170669325E+01, 5.0263728446E+00, 2.0173538366E+01, 3.6307730424E+00, 9.7464064057E-01],
	[4.2130000000E+04, 3.7178419753E+01, 5.0264108774E+00, 2.0181381203E+01, 3.6311207966E+00, 9.7465183699E-01],
	[4.2135000000E+04, 3.7186170876E+01, 5.0264489059E+00, 2.0189226157E+01, 3.6314684619E+00, 9.7466302786E-01],
	[4.2140000000E+04, 3.7193922696E+01, 5.0264869302E+00, 2.0197073229E+01, 3.6318160383E+00, 9.7467421318E-01],
	[4.2145000000E+04, 3.7201675211E+01, 5.0265249503E+00, 2.0204922418E+01, 3.6321635257E+00, 9.7468539295E-01],
	[4.2150000000E+04, 3.7209428423E+01, 5.0265629661E+00, 2.0212773724E+01, 3.6325109242E+00, 9.7469656719E-01],
	[4.2155000000E+04, 3.7217182330E+01, 5.0266009778E+00, 2.0220627149E+01, 3.6328582339E+00, 9.7470773588E-01],
	[4.2160000000E+04, 3.7224936933E+01, 5.0266389852E+00, 2.0228482693E+01, 3.6332054547E+00, 9.7471889903E-01],
	[4.2165000000E+04, 3.7232692232E+01, 5.0266769884E+00, 2.0236340355E+01, 3.6335525867E+00, 9.7473005665E-01],
	[4.2170000000E+04, 3.7240448227E+01, 5.0267149874E+00, 2.0244200137E+01, 3.6338996299E+00, 9.7474120874E-01],
	[4.2175000000E+04, 3.7248204918E+01, 5.0267529821E+00, 2.0252062038E+01, 3.6342465843E+00, 9.7475235530E-01],
	[4.2180000000E+04, 3.7255962304E+01, 5.0267909726E+00, 2.0259926058E+01, 3.6345934499E+00, 9.7476349634E-01],
	[4.2185000000E+04, 3.7263720386E+01, 5.0268289590E+00, 2.0267792199E+01, 3.6349402268E+00, 9.7477463185E-01],
	[4.2190000000E+04, 3.7271479164E+01, 5.0268669411E+00, 2.0275660461E+01, 3.6352869150E+00, 9.7478576185E-01],
	[4.2195000000E+04, 3.7279238638E+01, 5.0269049190E+00, 2.0283530843E+01, 3.6356335144E+00, 9.7479688634E-01],
	[4.2200000000E+04, 3.7286998808E+01, 5.0269428926E+00, 2.0291403346E+01, 3.6359800252E+00, 9.7480800531E-01],
	[4.2205000000E+04, 3.7294759673E+01, 5.0269808621E+00, 2.0299277970E+01, 3.6363264474E+00, 9.7481911877E-01],
	[4.2210000000E+04, 3.7302521234E+01, 5.0270188274E+00, 2.0307154716E+01, 3.6366727809E+00, 9.7483022673E-01],
	[4.2215000000E+04, 3.7310283490E+01, 5.0270567884E+00, 2.0315033585E+01, 3.6370190258E+00, 9.7484132918E-01],
	[4.2220000000E+04, 3.7318046442E+01, 5.0270947452E+00, 2.0322914575E+01, 3.6373651821E+00, 9.7485242613E-01],
	[4.2225000000E+04, 3.7325810090E+01, 5.0271326979E+00, 2.0330797688E+01, 3.6377112499E+00, 9.7486351759E-01],
	[4.2230000000E+04, 3.7333574433E+01, 5.0271706463E+00, 2.0338682925E+01, 3.6380572291E+00, 9.7487460356E-01],
	[4.2235000000E+04, 3.7341339472E+01, 5.0272085905E+00, 2.0346570284E+01, 3.6384031197E+00, 9.7488568403E-01],
	[4.2240000000E+04, 3.7349105207E+01, 5.0272465305E+00, 2.0354459767E+01, 3.6387489219E+00, 9.7489675902E-01],
	[4.2245000000E+04, 3.7356871637E+01, 5.0272844663E+00, 2.0362351375E+01, 3.6390946356E+00, 9.7490782852E-01],
	[4.2250000000E+04, 3.7364638762E+01, 5.0273223979E+00, 2.0370245106E+01, 3.6394402609E+00, 9.7491889254E-01],
	[4.2255000000E+04, 3.7372406583E+01, 5.0273603253E+00, 2.0378140962E+01, 3.6397857977E+00, 9.7492995108E-01],
	[4.2260000000E+04, 3.7380175100E+01, 5.0273982485E+00, 2.0386038943E+01, 3.6401312461E+00, 9.7494100415E-01],
	[4.2265000000E+04, 3.7387944312E+01, 5.0274361675E+00, 2.0393939049E+01, 3.6404766061E+00, 9.7495205175E-01],
	[4.2270000000E+04, 3.7395714219E+01, 5.0274740823E+00, 2.0401841281E+01, 3.6408218777E+00, 9.7496309387E-01],
	[4.2275000000E+04, 3.7403484822E+01, 5.0275119929E+00, 2.0409745638E+01, 3.6411670610E+00, 9.7497413054E-01],
	[4.2280000000E+04, 3.7411256120E+01, 5.0275498993E+00, 2.0417652122E+01, 3.6415121559E+00, 9.7498516173E-01],
	[4.2285000000E+04, 3.7419028114E+01, 5.0275878015E+00, 2.0425560732E+01, 3.6418571626E+00, 9.7499618747E-01],
	[4.2290000000E+04, 3.7426800803E+01, 5.0276256995E+00, 2.0433471469E+01, 3.6422020810E+00, 9.7500720776E-01],
	[4.2295000000E+04, 3.7434574187E+01, 5.0276635933E+00, 2.0441384334E+01, 3.6425469111E+00, 9.7501822259E-01],
	[4.2300000000E+04, 3.7442348267E+01, 5.0277014829E+00, 2.0449299325E+01, 3.6428916529E+00, 9.7502923196E-01],
	[4.2305000000E+04, 3.7450123042E+01, 5.0277393684E+00, 2.0457216445E+01, 3.6432363066E+00, 9.7504023589E-01],
	[4.2310000000E+04, 3.7457898512E+01, 5.0277772496E+00, 2.0465135692E+01, 3.6435808720E+00, 9.7505123438E-01],
	[4.2315000000E+04, 3.7465674677E+01, 5.0278151266E+00, 2.0473057068E+01, 3.6439253493E+00, 9.7506222743E-01],
	[4.2320000000E+04, 3.7473451538E+01, 5.0278529995E+00, 2.0480980573E+01, 3.6442697385E+00, 9.7507321503E-01],
	[4.2325000000E+04, 3.7481229094E+01, 5.0278908681E+00, 2.0488906207E+01, 3.6446140395E+00, 9.7508419721E-01],
	[4.2330000000E+04, 3.7489007345E+01, 5.0279287326E+00, 2.0496833970E+01, 3.6449582524E+00, 9.7509517395E-01],
	[4.2335000000E+04, 3.7496786291E+01, 5.0279665929E+00, 2.0504763863E+01, 3.6453023772E+00, 9.7510614526E-01],
	[4.2340000000E+04, 3.7504565933E+01, 5.0280044490E+00, 2.0512695886E+01, 3.6456464139E+00, 9.7511711114E-01],
	[4.2345000000E+04, 3.7512346269E+01, 5.0280423009E+00, 2.0520630040E+01, 3.6459903626E+00, 9.7512807160E-01],
	[4.2350000000E+04, 3.7520127301E+01, 5.0280801487E+00, 2.0528566324E+01, 3.6463342233E+00, 9.7513902665E-01],
	[4.2355000000E+04, 3.7527909028E+01, 5.0281179922E+00, 2.0536504738E+01, 3.6466779960E+00, 9.7514997627E-01],
	[4.2360000000E+04, 3.7535691450E+01, 5.0281558316E+00, 2.0544445285E+01, 3.6470216807E+00, 9.7516092048E-01],
	[4.2365000000E+04, 3.7543474567E+01, 5.0281936668E+00, 2.0552387963E+01, 3.6473652775E+00, 9.7517185928E-01],
	[4.2370000000E+04, 3.7551258379E+01, 5.0282314978E+00, 2.0560332773E+01, 3.6477087863E+00, 9.7518279268E-01],
	[4.2375000000E+04, 3.7559042886E+01, 5.0282693246E+00, 2.0568279715E+01, 3.6480522072E+00, 9.7519372067E-01],
	[4.2380000000E+04, 3.7566828088E+01, 5.0283071472E+00, 2.0576228790E+01, 3.6483955402E+00, 9.7520464325E-01],
	[4.2385000000E+04, 3.7574613985E+01, 5.0283449657E+00, 2.0584179997E+01, 3.6487387854E+00, 9.7521556044E-01],
	[4.2390000000E+04, 3.7582400577E+01, 5.0283827800E+00, 2.0592133338E+01, 3.6490819427E+00, 9.7522647223E-01],
	[4.2395000000E+04, 3.7590187864E+01, 5.0284205901E+00, 2.0600088813E+01, 3.6494250122E+00, 9.7523737863E-01],
	[4.2400000000E+04, 3.7597975845E+01, 5.0284583960E+00, 2.0608046421E+01, 3.6497679938E+00, 9.7524827964E-01],
	[4.2405000000E+04, 3.7605764522E+01, 5.0284961978E+00, 2.0616006163E+01, 3.6501108877E+00, 9.7525917527E-01],
	[4.2410000000E+04, 3.7613553894E+01, 5.0285339954E+00, 2.0623968040E+01, 3.6504536939E+00, 9.7527006551E-01],
	[4.2415000000E+04, 3.7621343960E+01, 5.0285717888E+00, 2.0631932052E+01, 3.6507964123E+00, 9.7528095037E-01],
	[4.2420000000E+04, 3.7629134721E+01, 5.0286095781E+00, 2.0639898199E+01, 3.6511390430E+00, 9.7529182985E-01],
	[4.2425000000E+04, 3.7636926177E+01, 5.0286473632E+00, 2.0647866482E+01, 3.6514815860E+00, 9.7530270396E-01],
	[4.2430000000E+04, 3.7644718328E+01, 5.0286851441E+00, 2.0655836900E+01, 3.6518240413E+00, 9.7531357270E-01],
	[4.2435000000E+04, 3.7652511174E+01, 5.0287229208E+00, 2.0663809454E+01, 3.6521664090E+00, 9.7532443607E-01],
	[4.2440000000E+04, 3.7660304714E+01, 5.0287606934E+00, 2.0671784145E+01, 3.6525086890E+00, 9.7533529407E-01],
	[4.2445000000E+04, 3.7668098949E+01, 5.0287984618E+00, 2.0679760973E+01, 3.6528508815E+00, 9.7534614672E-01],
	[4.2450000000E+04, 3.7675893879E+01, 5.0288362261E+00, 2.0687739938E+01, 3.6531929863E+00, 9.7535699400E-01],
	[4.2455000000E+04, 3.7683689504E+01, 5.0288739861E+00, 2.0695721040E+01, 3.6535350037E+00, 9.7536783593E-01],
	[4.2460000000E+04, 3.7691485823E+01, 5.0289117421E+00, 2.0703704279E+01, 3.6538769334E+00, 9.7537867250E-01],
	[4.2465000000E+04, 3.7699282837E+01, 5.0289494938E+00, 2.0711689657E+01, 3.6542187757E+00, 9.7538950373E-01],
	[4.2470000000E+04, 3.7707080546E+01, 5.0289872414E+00, 2.0719677173E+01, 3.6545605304E+00, 9.7540032960E-01],
	[4.2475000000E+04, 3.7714878949E+01, 5.0290249848E+00, 2.0727666828E+01, 3.6549021977E+00, 9.7541115013E-01],
	[4.2480000000E+04, 3.7722678046E+01, 5.0290627241E+00, 2.0735658622E+01, 3.6552437775E+00, 9.7542196533E-01],
	[4.2485000000E+04, 3.7730477839E+01, 5.0291004592E+00, 2.0743652555E+01, 3.6555852699E+00, 9.7543277518E-01],
	[4.2490000000E+04, 3.7738278326E+01, 5.0291381902E+00, 2.0751648628E+01, 3.6559266749E+00, 9.7544357970E-01],
	[4.2495000000E+04, 3.7746079507E+01, 5.0291759170E+00, 2.0759646841E+01, 3.6562679925E+00, 9.7545437889E-01],
	[4.2500000000E+04, 3.7753886848E+01, 5.0292142653E+00, 2.0767647194E+01, 3.6566096047E+00, 9.7546517274E-01],
	[4.2505000000E+04, 3.7761706080E+01, 5.0292538908E+00, 2.0775649688E+01, 3.6569519122E+00, 9.7547596128E-01],
	[4.2510000000E+04, 3.7769526011E+01, 5.0292935121E+00, 2.0783654322E+01, 3.6572941326E+00, 9.7548674449E-01],
	[4.2515000000E+04, 3.7777346642E+01, 5.0293331289E+00, 2.0791661098E+01, 3.6576362659E+00, 9.7549752238E-01],
	[4.2520000000E+04, 3.7785167973E+01, 5.0293727414E+00, 2.0799670015E+01, 3.6579783122E+00, 9.7550829495E-01],
	[4.2525000000E+04, 3.7792990003E+01, 5.0294123496E+00, 2.0807681075E+01, 3.6583202714E+00, 9.7551906221E-01],
	[4.2530000000E+04, 3.7800812732E+01, 5.0294519534E+00, 2.0815694276E+01, 3.6586621437E+00, 9.7552982415E-01],
	[4.2535000000E+04, 3.7808636160E+01, 5.0294915529E+00, 2.0823709620E+01, 3.6590039289E+00, 9.7554058079E-01],
	[4.2540000000E+04, 3.7816460288E+01, 5.0295311481E+00, 2.0831727107E+01, 3.6593456271E+00, 9.7555133213E-01],
	[4.2545000000E+04, 3.7824285115E+01, 5.0295707389E+00, 2.0839746737E+01, 3.6596872384E+00, 9.7556207816E-01],
	[4.2550000000E+04, 3.7832110641E+01, 5.0296103253E+00, 2.0847768510E+01, 3.6600287628E+00, 9.7557281890E-01],
	[4.2555000000E+04, 3.7839936866E+01, 5.0296499074E+00, 2.0855792428E+01, 3.6603702002E+00, 9.7558355433E-01],
	[4.2560000000E+04, 3.7847763791E+01, 5.0296894852E+00, 2.0863818489E+01, 3.6607115508E+00, 9.7559428448E-01],
	[4.2565000000E+04, 3.7855591415E+01, 5.0297290587E+00, 2.0871846695E+01, 3.6610528145E+00, 9.7560500933E-01],
	[4.2570000000E+04, 3.7863419738E+01, 5.0297686278E+00, 2.0879877045E+01, 3.6613939914E+00, 9.7561572890E-01],
	[4.2575000000E+04, 3.7871248760E+01, 5.0298081925E+00, 2.0887909541E+01, 3.6617350814E+00, 9.7562644319E-01],
	[4.2580000000E+04, 3.7879078481E+01, 5.0298477530E+00, 2.0895944182E+01, 3.6620760847E+00, 9.7563715219E-01],
	[4.2585000000E+04, 3.7886908902E+01, 5.0298873091E+00, 2.0903980969E+01, 3.6624170011E+00, 9.7564785591E-01],
	[4.2590000000E+04, 3.7894740021E+01, 5.0299268608E+00, 2.0912019902E+01, 3.6627578308E+00, 9.7565855435E-01],
	[4.2595000000E+04, 3.7902571840E+01, 5.0299664083E+00, 2.0920060981E+01, 3.6630985738E+00, 9.7566924752E-01],
	[4.2600000000E+04, 3.7910404357E+01, 5.0300059514E+00, 2.0928104207E+01, 3.6634392301E+00, 9.7567993542E-01],
	[4.2605000000E+04, 3.7918237574E+01, 5.0300454902E+00, 2.0936149580E+01, 3.6637797996E+00, 9.7569061804E-01],
	[4.2610000000E+04, 3.7926071490E+01, 5.0300850246E+00, 2.0944197101E+01, 3.6641202825E+00, 9.7570129540E-01],
	[4.2615000000E+04, 3.7933906105E+01, 5.0301245547E+00, 2.0952246769E+01, 3.6644606788E+00, 9.7571196749E-01],
	[4.2620000000E+04, 3.7941741418E+01, 5.0301640805E+00, 2.0960298585E+01, 3.6648009884E+00, 9.7572263433E-01],
	[4.2625000000E+04, 3.7949577431E+01, 5.0302036020E+00, 2.0968352549E+01, 3.6651412114E+00, 9.7573329590E-01],
	[4.2630000000E+04, 3.7957414143E+01, 5.0302431191E+00, 2.0976408662E+01, 3.6654813479E+00, 9.7574395221E-01],
	[4.2635000000E+04, 3.7965251553E+01, 5.0302826319E+00, 2.0984466924E+01, 3.6658213977E+00, 9.7575460327E-01],
	[4.2640000000E+04, 3.7973089663E+01, 5.0303221404E+00, 2.0992527335E+01, 3.6661613611E+00, 9.7576524908E-01],
	[4.2645000000E+04, 3.7980928471E+01, 5.0303616446E+00, 2.1000589895E+01, 3.6665012379E+00, 9.7577588964E-01],
	[4.2650000000E+04, 3.7988767978E+01, 5.0304011444E+00, 2.1008654606E+01, 3.6668410282E+00, 9.7578652495E-01],
	[4.2655000000E+04, 3.7996608184E+01, 5.0304406399E+00, 2.1016721466E+01, 3.6671807320E+00, 9.7579715501E-01],
	[4.2660000000E+04, 3.8004449089E+01, 5.0304801312E+00, 2.1024790478E+01, 3.6675203494E+00, 9.7580777984E-01],
	[4.2665000000E+04, 3.8012290692E+01, 5.0305196180E+00, 2.1032861640E+01, 3.6678598804E+00, 9.7581839942E-01],
	[4.2670000000E+04, 3.8020132995E+01, 5.0305591006E+00, 2.1040934953E+01, 3.6681993249E+00, 9.7582901377E-01],
	[4.2675000000E+04, 3.8027975996E+01, 5.0305985789E+00, 2.1049010418E+01, 3.6685386831E+00, 9.7583962289E-01],
	[4.2680000000E+04, 3.8035819696E+01, 5.0306380528E+00, 2.1057088035E+01, 3.6688779549E+00, 9.7585022677E-01],
	[4.2685000000E+04, 3.8043664095E+01, 5.0306775224E+00, 2.1065167804E+01, 3.6692171404E+00, 9.7586082543E-01],
	[4.2690000000E+04, 3.8051509192E+01, 5.0307169877E+00, 2.1073249725E+01, 3.6695562395E+00, 9.7587141886E-01],
	[4.2695000000E+04, 3.8059354988E+01, 5.0307564487E+00, 2.1081333799E+01, 3.6698952523E+00, 9.7588200706E-01],
	[4.2700000000E+04, 3.8067201483E+01, 5.0307959054E+00, 2.1089420026E+01, 3.6702341789E+00, 9.7589259004E-01],
	[4.2705000000E+04, 3.8075048676E+01, 5.0308353578E+00, 2.1097508407E+01, 3.6705730192E+00, 9.7590316781E-01],
	[4.2710000000E+04, 3.8082896568E+01, 5.0308748059E+00, 2.1105598941E+01, 3.6709117732E+00, 9.7591374036E-01],
	[4.2715000000E+04, 3.8090745159E+01, 5.0309142496E+00, 2.1113691629E+01, 3.6712504410E+00, 9.7592430770E-01],
	[4.2720000000E+04, 3.8098594448E+01, 5.0309536891E+00, 2.1121786472E+01, 3.6715890227E+00, 9.7593486982E-01],
	[4.2725000000E+04, 3.8106444436E+01, 5.0309931242E+00, 2.1129883470E+01, 3.6719275182E+00, 9.7594542674E-01],
	[4.2730000000E+04, 3.8114295122E+01, 5.0310325551E+00, 2.1137982622E+01, 3.6722659275E+00, 9.7595597845E-01],
	[4.2735000000E+04, 3.8122146507E+01, 5.0310719816E+00, 2.1146083930E+01, 3.6726042507E+00, 9.7596652496E-01],
	[4.2740000000E+04, 3.8129998590E+01, 5.0311114038E+00, 2.1154187394E+01, 3.6729424878E+00, 9.7597706627E-01],
	[4.2745000000E+04, 3.8137851372E+01, 5.0311508218E+00, 2.1162293013E+01, 3.6732806388E+00, 9.7598760238E-01],
	[4.2750000000E+04, 3.8145704852E+01, 5.0311902354E+00, 2.1170400789E+01, 3.6736187037E+00, 9.7599813329E-01],
	[4.2755000000E+04, 3.8153559031E+01, 5.0312296447E+00, 2.1178510722E+01, 3.6739566826E+00, 9.7600865901E-01],
	[4.2760000000E+04, 3.8161413908E+01, 5.0312690497E+00, 2.1186622811E+01, 3.6742945755E+00, 9.7601917955E-01],
	[4.2765000000E+04, 3.8169269484E+01, 5.0313084505E+00, 2.1194737058E+01, 3.6746323824E+00, 9.7602969489E-01],
	[4.2770000000E+04, 3.8177125758E+01, 5.0313478469E+00, 2.1202853463E+01, 3.6749701033E+00, 9.7604020505E-01],
	[4.2775000000E+04, 3.8184982730E+01, 5.0313872390E+00, 2.1210972025E+01, 3.6753077383E+00, 9.7605071003E-01],
	[4.2780000000E+04, 3.8192840401E+01, 5.0314266269E+00, 2.1219092745E+01, 3.6756452873E+00, 9.7606120982E-01],
	[4.2785000000E+04, 3.8200698770E+01, 5.0314660104E+00, 2.1227215624E+01, 3.6759827504E+00, 9.7607170444E-01],
	[4.2790000000E+04, 3.8208557837E+01, 5.0315053896E+00, 2.1235340662E+01, 3.6763201276E+00, 9.7608219389E-01],
	[4.2795000000E+04, 3.8216417603E+01, 5.0315447646E+00, 2.1243467860E+01, 3.6766574190E+00, 9.7609267816E-01],
	[4.2800000000E+04, 3.8224278067E+01, 5.0315841353E+00, 2.1251597216E+01, 3.6769946245E+00, 9.7610315726E-01],
	[4.2805000000E+04, 3.8232139229E+01, 5.0316235016E+00, 2.1259728733E+01, 3.6773317442E+00, 9.7611363120E-01],
	[4.2810000000E+04, 3.8240001089E+01, 5.0316628637E+00, 2.1267862410E+01, 3.6776687780E+00, 9.7612409997E-01],
	[4.2815000000E+04, 3.8247863648E+01, 5.0317022215E+00, 2.1275998247E+01, 3.6780057261E+00, 9.7613456358E-01],
	[4.2820000000E+04, 3.8255726905E+01, 5.0317415750E+00, 2.1284136245E+01, 3.6783425885E+00, 9.7614502203E-01],
	[4.2825000000E+04, 3.8263590860E+01, 5.0317809242E+00, 2.1292276404E+01, 3.6786793651E+00, 9.7615547533E-01],
	[4.2830000000E+04, 3.8271455513E+01, 5.0318202691E+00, 2.1300418725E+01, 3.6790160560E+00, 9.7616592346E-01],
	[4.2835000000E+04, 3.8279320864E+01, 5.0318596098E+00, 2.1308563207E+01, 3.6793526611E+00, 9.7617636645E-01],
	[4.2840000000E+04, 3.8287186914E+01, 5.0318989461E+00, 2.1316709852E+01, 3.6796891807E+00, 9.7618680429E-01],
	[4.2845000000E+04, 3.8295053661E+01, 5.0319382782E+00, 2.1324858659E+01, 3.6800256145E+00, 9.7619723698E-01],
	[4.2850000000E+04, 3.8302921107E+01, 5.0319776060E+00, 2.1333009628E+01, 3.6803619628E+00, 9.7620766453E-01],
	[4.2855000000E+04, 3.8310789251E+01, 5.0320169295E+00, 2.1341162761E+01, 3.6806982254E+00, 9.7621808694E-01],
	[4.2860000000E+04, 3.8318658092E+01, 5.0320562488E+00, 2.1349318057E+01, 3.6810344024E+00, 9.7622850421E-01],
	[4.2865000000E+04, 3.8326527632E+01, 5.0320955637E+00, 2.1357475517E+01, 3.6813704939E+00, 9.7623891634E-01],
	[4.2870000000E+04, 3.8334397870E+01, 5.0321348744E+00, 2.1365635141E+01, 3.6817064998E+00, 9.7624932334E-01],
	[4.2875000000E+04, 3.8342268805E+01, 5.0321741808E+00, 2.1373796929E+01, 3.6820424202E+00, 9.7625972521E-01],
	[4.2880000000E+04, 3.8350140439E+01, 5.0322134829E+00, 2.1381960882E+01, 3.6823782551E+00, 9.7627012195E-01],
	[4.2885000000E+04, 3.8358012771E+01, 5.0322527808E+00, 2.1390127000E+01, 3.6827140046E+00, 9.7628051356E-01],
	[4.2890000000E+04, 3.8365885800E+01, 5.0322920743E+00, 2.1398295283E+01, 3.6830496685E+00, 9.7629090005E-01],
	[4.2895000000E+04, 3.8373759528E+01, 5.0323313636E+00, 2.1406465731E+01, 3.6833852471E+00, 9.7630128142E-01],
	[4.2900000000E+04, 3.8381633953E+01, 5.0323706486E+00, 2.1414638346E+01, 3.6837207402E+00, 9.7631165767E-01],
	[4.2905000000E+04, 3.8389509076E+01, 5.0324099294E+00, 2.1422813127E+01, 3.6840561479E+00, 9.7632202881E-01],
	[4.2910000000E+04, 3.8397384897E+01, 5.0324492059E+00, 2.1430990075E+01, 3.6843914703E+00, 9.7633239483E-01],
	[4.2915000000E+04, 3.8405261416E+01, 5.0324884781E+00, 2.1439169189E+01, 3.6847267073E+00, 9.7634275574E-01],
	[4.2920000000E+04, 3.8413138633E+01, 5.0325277460E+00, 2.1447350471E+01, 3.6850618590E+00, 9.7635311155E-01],
	[4.2925000000E+04, 3.8421016547E+01, 5.0325670097E+00, 2.1455533920E+01, 3.6853969254E+00, 9.7636346225E-01],
	[4.2930000000E+04, 3.8428895159E+01, 5.0326062691E+00, 2.1463719537E+01, 3.6857319065E+00, 9.7637380784E-01],
	[4.2935000000E+04, 3.8436774469E+01, 5.0326455242E+00, 2.1471907323E+01, 3.6860668023E+00, 9.7638414834E-01],
	[4.2940000000E+04, 3.8444654477E+01, 5.0326847751E+00, 2.1480097277E+01, 3.6864016129E+00, 9.7639448374E-01],
	[4.2945000000E+04, 3.8452535182E+01, 5.0327240217E+00, 2.1488289399E+01, 3.6867363383E+00, 9.7640481404E-01],
	[4.2950000000E+04, 3.8460416585E+01, 5.0327632641E+00, 2.1496483691E+01, 3.6870709785E+00, 9.7641513925E-01],
	[4.2955000000E+04, 3.8468298686E+01, 5.0328025022E+00, 2.1504680153E+01, 3.6874055335E+00, 9.7642545937E-01],
	[4.2960000000E+04, 3.8476181484E+01, 5.0328417360E+00, 2.1512878784E+01, 3.6877400033E+00, 9.7643577440E-01],
	[4.2965000000E+04, 3.8484064981E+01, 5.0328809656E+00, 2.1521079585E+01, 3.6880743880E+00, 9.7644608435E-01],
	[4.2970000000E+04, 3.8491949174E+01, 5.0329201909E+00, 2.1529282557E+01, 3.6884086877E+00, 9.7645638922E-01],
	[4.2975000000E+04, 3.8499834065E+01, 5.0329594119E+00, 2.1537487700E+01, 3.6887429022E+00, 9.7646668900E-01],
	[4.2980000000E+04, 3.8507719654E+01, 5.0329986287E+00, 2.1545695013E+01, 3.6890770316E+00, 9.7647698371E-01],
	[4.2985000000E+04, 3.8515605941E+01, 5.0330378412E+00, 2.1553904498E+01, 3.6894110760E+00, 9.7648727335E-01],
	[4.2990000000E+04, 3.8523492924E+01, 5.0330770495E+00, 2.1562116155E+01, 3.6897450354E+00, 9.7649755791E-01],
	[4.2995000000E+04, 3.8531380606E+01, 5.0331162535E+00, 2.1570329984E+01, 3.6900789098E+00, 9.7650783740E-01],
	[4.3000000000E+04, 3.8539268985E+01, 5.0331554533E+00, 2.1578545985E+01, 3.6904126992E+00, 9.7651811183E-01],
	[4.3005000000E+04, 3.8547158061E+01, 5.0331946488E+00, 2.1586764159E+01, 3.6907464036E+00, 9.7652838119E-01],
	[4.3010000000E+04, 3.8555047835E+01, 5.0332338401E+00, 2.1594984506E+01, 3.6910800231E+00, 9.7653864549E-01],
	[4.3015000000E+04, 3.8562938306E+01, 5.0332730271E+00, 2.1603207026E+01, 3.6914135577E+00, 9.7654890474E-01],
	[4.3020000000E+04, 3.8570829475E+01, 5.0333122099E+00, 2.1611431720E+01, 3.6917470074E+00, 9.7655915892E-01],
	[4.3025000000E+04, 3.8578721341E+01, 5.0333513884E+00, 2.1619658588E+01, 3.6920803722E+00, 9.7656940805E-01],
	[4.3030000000E+04, 3.8586613904E+01, 5.0333905627E+00, 2.1627887630E+01, 3.6924136522E+00, 9.7657965213E-01],
	[4.3035000000E+04, 3.8594507165E+01, 5.0334297327E+00, 2.1636118847E+01, 3.6927468473E+00, 9.7658989116E-01],
	[4.3040000000E+04, 3.8602401123E+01, 5.0334688985E+00, 2.1644352239E+01, 3.6930799576E+00, 9.7660012514E-01],
	[4.3045000000E+04, 3.8610295779E+01, 5.0335080600E+00, 2.1652587806E+01, 3.6934129832E+00, 9.7661035408E-01],
	[4.3050000000E+04, 3.8618191132E+01, 5.0335472173E+00, 2.1660825549E+01, 3.6937459240E+00, 9.7662057798E-01],
	[4.3055000000E+04, 3.8626087182E+01, 5.0335863703E+00, 2.1669065468E+01, 3.6940787800E+00, 9.7663079684E-01],
	[4.3060000000E+04, 3.8633983929E+01, 5.0336255191E+00, 2.1677307562E+01, 3.6944115513E+00, 9.7664101066E-01],
	[4.3065000000E+04, 3.8641881374E+01, 5.0336646637E+00, 2.1685551834E+01, 3.6947442379E+00, 9.7665121945E-01],
	[4.3070000000E+04, 3.8649779515E+01, 5.0337038040E+00, 2.1693798282E+01, 3.6950768399E+00, 9.7666142321E-01],
	[4.3075000000E+04, 3.8657678354E+01, 5.0337429401E+00, 2.1702046908E+01, 3.6954093571E+00, 9.7667162194E-01],
	[4.3080000000E+04, 3.8665577891E+01, 5.0337820719E+00, 2.1710297711E+01, 3.6957417898E+00, 9.7668181565E-01],
	[4.3085000000E+04, 3.8673478124E+01, 5.0338211995E+00, 2.1718550691E+01, 3.6960741378E+00, 9.7669200433E-01],
	[4.3090000000E+04, 3.8681379054E+01, 5.0338603229E+00, 2.1726805850E+01, 3.6964064012E+00, 9.7670218799E-01],
	[4.3095000000E+04, 3.8689280682E+01, 5.0338994420E+00, 2.1735063188E+01, 3.6967385801E+00, 9.7671236663E-01],
	[4.3100000000E+04, 3.8697183007E+01, 5.0339385569E+00, 2.1743322704E+01, 3.6970706744E+00, 9.7672254026E-01],
	[4.3105000000E+04, 3.8705086029E+01, 5.0339776676E+00, 2.1751584400E+01, 3.6974026842E+00, 9.7673270887E-01],
	[4.3110000000E+04, 3.8712989747E+01, 5.0340167740E+00, 2.1759848275E+01, 3.6977346095E+00, 9.7674287247E-01],
	[4.3115000000E+04, 3.8720894163E+01, 5.0340558762E+00, 2.1768114329E+01, 3.6980664503E+00, 9.7675303107E-01],
	[4.3120000000E+04, 3.8728799276E+01, 5.0340949742E+00, 2.1776382564E+01, 3.6983982066E+00, 9.7676318466E-01],
	[4.3125000000E+04, 3.8736705086E+01, 5.0341340679E+00, 2.1784652979E+01, 3.6987298785E+00, 9.7677333324E-01],
	[4.3130000000E+04, 3.8744611593E+01, 5.0341731575E+00, 2.1792925575E+01, 3.6990614660E+00, 9.7678347683E-01],
	[4.3135000000E+04, 3.8752518797E+01, 5.0342122427E+00, 2.1801200352E+01, 3.6993929691E+00, 9.7679361542E-01],
	[4.3140000000E+04, 3.8760426698E+01, 5.0342513238E+00, 2.1809477311E+01, 3.6997243878E+00, 9.7680374901E-01],
	[4.3145000000E+04, 3.8768335296E+01, 5.0342904006E+00, 2.1817756451E+01, 3.7000557222E+00, 9.7681387761E-01],
	[4.3150000000E+04, 3.8776244591E+01, 5.0343294732E+00, 2.1826037773E+01, 3.7003869722E+00, 9.7682400122E-01],
	[4.3155000000E+04, 3.8784154582E+01, 5.0343685416E+00, 2.1834321277E+01, 3.7007181379E+00, 9.7683411984E-01],
	[4.3160000000E+04, 3.8792065271E+01, 5.0344076058E+00, 2.1842606965E+01, 3.7010492193E+00, 9.7684423348E-01],
	[4.3165000000E+04, 3.8799976656E+01, 5.0344466657E+00, 2.1850894835E+01, 3.7013802164E+00, 9.7685434213E-01],
	[4.3170000000E+04, 3.8807888738E+01, 5.0344857214E+00, 2.1859184888E+01, 3.7017111293E+00, 9.7686444580E-01],
	[4.3175000000E+04, 3.8815801517E+01, 5.0345247729E+00, 2.1867477125E+01, 3.7020419580E+00, 9.7687454450E-01],
	[4.3180000000E+04, 3.8823714993E+01, 5.0345638202E+00, 2.1875771546E+01, 3.7023727025E+00, 9.7688463822E-01],
	[4.3185000000E+04, 3.8831637359E+01, 5.0346037868E+00, 2.1884068152E+01, 3.7027039368E+00, 9.7689472697E-01],
	[4.3190000000E+04, 3.8839568788E+01, 5.0346446917E+00, 2.1892366942E+01, 3.7030356730E+00, 9.7690481075E-01],
	[4.3195000000E+04, 3.8847500919E+01, 5.0346855921E+00, 2.1900667916E+01, 3.7033673253E+00, 9.7691488956E-01],
	[4.3200000000E+04, 3.8855433751E+01, 5.0347264882E+00, 2.1908971077E+01, 3.7036988936E+00, 9.7692496341E-01],
	[4.3205000000E+04, 3.8863367285E+01, 5.0347673799E+00, 2.1917276422E+01, 3.7040303781E+00, 9.7693503230E-01],
	[4.3210000000E+04, 3.8871301521E+01, 5.0348082671E+00, 2.1925583954E+01, 3.7043617787E+00, 9.7694509622E-01],
	[4.3215000000E+04, 3.8879236458E+01, 5.0348491500E+00, 2.1933893672E+01, 3.7046930954E+00, 9.7695515519E-01],
	[4.3220000000E+04, 3.8887172096E+01, 5.0348900285E+00, 2.1942205576E+01, 3.7050243283E+00, 9.7696520921E-01],
	[4.3225000000E+04, 3.8895108436E+01, 5.0349309025E+00, 2.1950519667E+01, 3.7053554774E+00, 9.7697525827E-01],
	[4.3230000000E+04, 3.8903045477E+01, 5.0349717722E+00, 2.1958835945E+01, 3.7056865428E+00, 9.7698530238E-01],
	[4.3235000000E+04, 3.8910983220E+01, 5.0350126375E+00, 2.1967154411E+01, 3.7060175243E+00, 9.7699534155E-01],
	[4.3240000000E+04, 3.8918921664E+01, 5.0350534984E+00, 2.1975475065E+01, 3.7063484221E+00, 9.7700537577E-01],
	[4.3245000000E+04, 3.8926860809E+01, 5.0350943549E+00, 2.1983797907E+01, 3.7066792362E+00, 9.7701540505E-01],
	[4.3250000000E+04, 3.8934800656E+01, 5.0351352070E+00, 2.1992122937E+01, 3.7070099666E+00, 9.7702542939E-01],
	[4.3255000000E+04, 3.8942741205E+01, 5.0351760547E+00, 2.2000450156E+01, 3.7073406133E+00, 9.7703544879E-01],
	[4.3260000000E+04, 3.8950682454E+01, 5.0352168980E+00, 2.2008779564E+01, 3.7076711764E+00, 9.7704546326E-01],
	[4.3265000000E+04, 3.8958624405E+01, 5.0352577369E+00, 2.2017111162E+01, 3.7080016558E+00, 9.7705547280E-01],
	[4.3270000000E+04, 3.8966567057E+01, 5.0352985715E+00, 2.2025444949E+01, 3.7083320516E+00, 9.7706547741E-01],
	[4.3275000000E+04, 3.8974510411E+01, 5.0353394016E+00, 2.2033780927E+01, 3.7086623638E+00, 9.7707547709E-01],
	[4.3280000000E+04, 3.8982454465E+01, 5.0353802274E+00, 2.2042119095E+01, 3.7089925925E+00, 9.7708547185E-01],
	[4.3285000000E+04, 3.8990399221E+01, 5.0354210488E+00, 2.2050459453E+01, 3.7093227376E+00, 9.7709546169E-01],
	[4.3290000000E+04, 3.8998344678E+01, 5.0354618658E+00, 2.2058802003E+01, 3.7096527991E+00, 9.7710544660E-01],
	[4.3295000000E+04, 3.9006290837E+01, 5.0355026784E+00, 2.2067146744E+01, 3.7099827772E+00, 9.7711542660E-01],
	[4.3300000000E+04, 3.9014237696E+01, 5.0355434866E+00, 2.2075493676E+01, 3.7103126717E+00, 9.7712540169E-01],
	[4.3305000000E+04, 3.9022185257E+01, 5.0355842905E+00, 2.2083842801E+01, 3.7106424828E+00, 9.7713537187E-01],
	[4.3310000000E+04, 3.9030133518E+01, 5.0356250899E+00, 2.2092194118E+01, 3.7109722105E+00, 9.7714533713E-01],
	[4.3315000000E+04, 3.9038082481E+01, 5.0356658850E+00, 2.2100547628E+01, 3.7113018547E+00, 9.7715529750E-01],
	[4.3320000000E+04, 3.9046032145E+01, 5.0357066757E+00, 2.2108903330E+01, 3.7116314156E+00, 9.7716525295E-01],
	[4.3325000000E+04, 3.9053982510E+01, 5.0357474621E+00, 2.2117261226E+01, 3.7119608930E+00, 9.7717520351E-01],
	[4.3330000000E+04, 3.9061933577E+01, 5.0357882440E+00, 2.2125621316E+01, 3.7122902872E+00, 9.7718514917E-01],
	[4.3335000000E+04, 3.9069885344E+01, 5.0358290216E+00, 2.2133983599E+01, 3.7126195979E+00, 9.7719508993E-01],
	[4.3340000000E+04, 3.9077837812E+01, 5.0358697948E+00, 2.2142348077E+01, 3.7129488254E+00, 9.7720502579E-01],
	[4.3345000000E+04, 3.9085790981E+01, 5.0359105637E+00, 2.2150714749E+01, 3.7132779695E+00, 9.7721495677E-01],
	[4.3350000000E+04, 3.9093744851E+01, 5.0359513281E+00, 2.2159083617E+01, 3.7136070304E+00, 9.7722488286E-01],
	[4.3355000000E+04, 3.9101699423E+01, 5.0359920882E+00, 2.2167454679E+01, 3.7139360081E+00, 9.7723480406E-01],
	[4.3360000000E+04, 3.9109654695E+01, 5.0360328439E+00, 2.2175827937E+01, 3.7142649025E+00, 9.7724472038E-01],
	[4.3365000000E+04, 3.9117610668E+01, 5.0360735953E+00, 2.2184203391E+01, 3.7145937137E+00, 9.7725463182E-01],
	[4.3370000000E+04, 3.9125567342E+01, 5.0361143423E+00, 2.2192581041E+01, 3.7149224417E+00, 9.7726453838E-01],
	[4.3375000000E+04, 3.9133524717E+01, 5.0361550849E+00, 2.2200960888E+01, 3.7152510865E+00, 9.7727444006E-01],
	[4.3380000000E+04, 3.9141482792E+01, 5.0361958231E+00, 2.2209342931E+01, 3.7155796482E+00, 9.7728433687E-01],
	[4.3385000000E+04, 3.9149441569E+01, 5.0362365570E+00, 2.2217727172E+01, 3.7159081268E+00, 9.7729422881E-01],
	[4.3390000000E+04, 3.9157401046E+01, 5.0362772865E+00, 2.2226113610E+01, 3.7162365223E+00, 9.7730411588E-01],
	[4.3395000000E+04, 3.9165361225E+01, 5.0363180117E+00, 2.2234502246E+01, 3.7165648347E+00, 9.7731399808E-01],
	[4.3400000000E+04, 3.9173322104E+01, 5.0363587325E+00, 2.2242893080E+01, 3.7168930641E+00, 9.7732387542E-01],
	[4.3405000000E+04, 3.9181283683E+01, 5.0363994489E+00, 2.2251286112E+01, 3.7172212104E+00, 9.7733374790E-01],
	[4.3410000000E+04, 3.9189245964E+01, 5.0364401610E+00, 2.2259681344E+01, 3.7175492737E+00, 9.7734361553E-01],
	[4.3415000000E+04, 3.9197208945E+01, 5.0364808687E+00, 2.2268078774E+01, 3.7178772540E+00, 9.7735347829E-01],
	[4.3420000000E+04, 3.9205172627E+01, 5.0365215720E+00, 2.2276478404E+01, 3.7182051513E+00, 9.7736333621E-01],
	[4.3425000000E+04, 3.9213137010E+01, 5.0365622710E+00, 2.2284880233E+01, 3.7185329657E+00, 9.7737318927E-01],
	[4.3430000000E+04, 3.9221102093E+01, 5.0366029657E+00, 2.2293284263E+01, 3.7188606971E+00, 9.7738303749E-01],
	[4.3435000000E+04, 3.9229067877E+01, 5.0366436559E+00, 2.2301690493E+01, 3.7191883457E+00, 9.7739288086E-01],
	[4.3440000000E+04, 3.9237034362E+01, 5.0366843419E+00, 2.2310098923E+01, 3.7195159113E+00, 9.7740271938E-01],
	[4.3445000000E+04, 3.9245001547E+01, 5.0367250234E+00, 2.2318509555E+01, 3.7198433941E+00, 9.7741255307E-01],
	[4.3450000000E+04, 3.9252969433E+01, 5.0367657007E+00, 2.2326922388E+01, 3.7201707941E+00, 9.7742238192E-01],
	[4.3455000000E+04, 3.9260938020E+01, 5.0368063735E+00, 2.2335337423E+01, 3.7204981112E+00, 9.7743220593E-01],
	[4.3460000000E+04, 3.9268907307E+01, 5.0368470420E+00, 2.2343754660E+01, 3.7208253455E+00, 9.7744202511E-01],
	[4.3465000000E+04, 3.9276877294E+01, 5.0368877062E+00, 2.2352174099E+01, 3.7211524970E+00, 9.7745183946E-01],
	[4.3470000000E+04, 3.9284847982E+01, 5.0369283660E+00, 2.2360595741E+01, 3.7214795658E+00, 9.7746164898E-01],
	[4.3475000000E+04, 3.9292819371E+01, 5.0369690215E+00, 2.2369019585E+01, 3.7218065519E+00, 9.7747145367E-01],
	[4.3480000000E+04, 3.9300791460E+01, 5.0370096726E+00, 2.2377445633E+01, 3.7221334552E+00, 9.7748125355E-01],
	[4.3485000000E+04, 3.9308764250E+01, 5.0370503194E+00, 2.2385873885E+01, 3.7224602758E+00, 9.7749104860E-01],
	[4.3490000000E+04, 3.9316737740E+01, 5.0370909618E+00, 2.2394304340E+01, 3.7227870138E+00, 9.7750083883E-01],
	[4.3495000000E+04, 3.9324711930E+01, 5.0371315999E+00, 2.2402737000E+01, 3.7231136691E+00, 9.7751062425E-01],
	[4.3500000000E+04, 3.9332686821E+01, 5.0371722336E+00, 2.2411171864E+01, 3.7234402418E+00, 9.7752040486E-01],
	[4.3505000000E+04, 3.9340662413E+01, 5.0372128630E+00, 2.2419608934E+01, 3.7237667318E+00, 9.7753018065E-01],
	[4.3510000000E+04, 3.9348638704E+01, 5.0372534880E+00, 2.2428048208E+01, 3.7240931393E+00, 9.7753995164E-01],
	[4.3515000000E+04, 3.9356615696E+01, 5.0372941088E+00, 2.2436489688E+01, 3.7244194642E+00, 9.7754971782E-01],
	[4.3520000000E+04, 3.9364593389E+01, 5.0373347251E+00, 2.2444933374E+01, 3.7247457066E+00, 9.7755947920E-01],
	[4.3525000000E+04, 3.9372571781E+01, 5.0373753372E+00, 2.2453379266E+01, 3.7250718664E+00, 9.7756923578E-01],
	[4.3530000000E+04, 3.9380550874E+01, 5.0374159449E+00, 2.2461827365E+01, 3.7253979438E+00, 9.7757898757E-01],
	[4.3535000000E+04, 3.9388530668E+01, 5.0374565482E+00, 2.2470277670E+01, 3.7257239386E+00, 9.7758873455E-01],
	[4.3540000000E+04, 3.9396511161E+01, 5.0374971472E+00, 2.2478730183E+01, 3.7260498510E+00, 9.7759847675E-01],
	[4.3545000000E+04, 3.9404492355E+01, 5.0375377419E+00, 2.2487184903E+01, 3.7263756810E+00, 9.7760821415E-01],
	[4.3550000000E+04, 3.9412474249E+01, 5.0375783323E+00, 2.2495641831E+01, 3.7267014286E+00, 9.7761794677E-01],
	[4.3555000000E+04, 3.9420456843E+01, 5.0376189183E+00, 2.2504100967E+01, 3.7270270937E+00, 9.7762767460E-01],
	[4.3560000000E+04, 3.9428440137E+01, 5.0376595000E+00, 2.2512562311E+01, 3.7273526765E+00, 9.7763739765E-01],
	[4.3565000000E+04, 3.9436424132E+01, 5.0377000774E+00, 2.2521025864E+01, 3.7276781769E+00, 9.7764711591E-01],
	[4.3570000000E+04, 3.9444408827E+01, 5.0377406504E+00, 2.2529491626E+01, 3.7280035950E+00, 9.7765682941E-01],
	[4.3575000000E+04, 3.9452394222E+01, 5.0377812191E+00, 2.2537959598E+01, 3.7283289308E+00, 9.7766653812E-01],
	[4.3580000000E+04, 3.9460380316E+01, 5.0378217835E+00, 2.2546429780E+01, 3.7286541843E+00, 9.7767624206E-01],
	[4.3585000000E+04, 3.9468367112E+01, 5.0378623435E+00, 2.2554902171E+01, 3.7289793555E+00, 9.7768594124E-01],
	[4.3590000000E+04, 3.9476354607E+01, 5.0379028992E+00, 2.2563376773E+01, 3.7293044445E+00, 9.7769563564E-01],
	[4.3595000000E+04, 3.9484342802E+01, 5.0379434506E+00, 2.2571853586E+01, 3.7296294512E+00, 9.7770532528E-01],
	[4.3600000000E+04, 3.9492331697E+01, 5.0379839977E+00, 2.2580332609E+01, 3.7299543757E+00, 9.7771501016E-01],
	[4.3605000000E+04, 3.9500321292E+01, 5.0380245404E+00, 2.2588813844E+01, 3.7302792181E+00, 9.7772469027E-01],
	[4.3610000000E+04, 3.9508311587E+01, 5.0380650789E+00, 2.2597297291E+01, 3.7306039783E+00, 9.7773436563E-01],
	[4.3615000000E+04, 3.9516302583E+01, 5.0381056130E+00, 2.2605782950E+01, 3.7309286564E+00, 9.7774403624E-01],
	[4.3620000000E+04, 3.9524294278E+01, 5.0381461427E+00, 2.2614270821E+01, 3.7312532523E+00, 9.7775370209E-01],
	[4.3625000000E+04, 3.9532286673E+01, 5.0381866682E+00, 2.2622760904E+01, 3.7315777662E+00, 9.7776336319E-01],
	[4.3630000000E+04, 3.9540279768E+01, 5.0382271893E+00, 2.2631253201E+01, 3.7319021979E+00, 9.7777301954E-01],
	[4.3635000000E+04, 3.9548273563E+01, 5.0382677062E+00, 2.2639747711E+01, 3.7322265476E+00, 9.7778267115E-01],
	[4.3640000000E+04, 3.9556268058E+01, 5.0383082187E+00, 2.2648244434E+01, 3.7325508153E+00, 9.7779231802E-01],
	[4.3645000000E+04, 3.9564263252E+01, 5.0383487269E+00, 2.2656743372E+01, 3.7328750010E+00, 9.7780196014E-01],
	[4.3650000000E+04, 3.9572259147E+01, 5.0383892308E+00, 2.2665244523E+01, 3.7331991047E+00, 9.7781159753E-01],
	[4.3655000000E+04, 3.9580255741E+01, 5.0384297303E+00, 2.2673747890E+01, 3.7335231264E+00, 9.7782123018E-01],
	[4.3660000000E+04, 3.9588253035E+01, 5.0384702256E+00, 2.2682253471E+01, 3.7338470661E+00, 9.7783085811E-01],
	[4.3665000000E+04, 3.9596251029E+01, 5.0385107165E+00, 2.2690761267E+01, 3.7341709240E+00, 9.7784048130E-01],
	[4.3670000000E+04, 3.9604249723E+01, 5.0385512031E+00, 2.2699271279E+01, 3.7344946999E+00, 9.7785009976E-01],
	[4.3675000000E+04, 3.9612249116E+01, 5.0385916855E+00, 2.2707783507E+01, 3.7348183940E+00, 9.7785971350E-01],
	[4.3680000000E+04, 3.9620249209E+01, 5.0386321635E+00, 2.2716297951E+01, 3.7351420061E+00, 9.7786932251E-01],
	[4.3685000000E+04, 3.9628250002E+01, 5.0386726372E+00, 2.2724814612E+01, 3.7354655365E+00, 9.7787892680E-01],
	[4.3690000000E+04, 3.9636251495E+01, 5.0387131066E+00, 2.2733333489E+01, 3.7357889850E+00, 9.7788852638E-01],
	[4.3695000000E+04, 3.9644253687E+01, 5.0387535717E+00, 2.2741854584E+01, 3.7361123517E+00, 9.7789812124E-01],
	[4.3700000000E+04, 3.9652256579E+01, 5.0387940324E+00, 2.2750377896E+01, 3.7364356366E+00, 9.7790771139E-01],
	[4.3705000000E+04, 3.9660260171E+01, 5.0388344889E+00, 2.2758903425E+01, 3.7367588398E+00, 9.7791729683E-01],
	[4.3710000000E+04, 3.9668264462E+01, 5.0388749411E+00, 2.2767431173E+01, 3.7370819613E+00, 9.7792687756E-01],
	[4.3715000000E+04, 3.9676269453E+01, 5.0389153890E+00, 2.2775961140E+01, 3.7374050010E+00, 9.7793645359E-01],
	[4.3720000000E+04, 3.9684275143E+01, 5.0389558325E+00, 2.2784493325E+01, 3.7377279591E+00, 9.7794602491E-01],
	[4.3725000000E+04, 3.9692281533E+01, 5.0389962718E+00, 2.2793027729E+01, 3.7380508354E+00, 9.7795559153E-01],
	[4.3730000000E+04, 3.9700288622E+01, 5.0390367068E+00, 2.2801564353E+01, 3.7383736301E+00, 9.7796515346E-01],
	[4.3735000000E+04, 3.9708296411E+01, 5.0390771375E+00, 2.2810103197E+01, 3.7386963432E+00, 9.7797471069E-01],
	[4.3740000000E+04, 3.9716304900E+01, 5.0391175638E+00, 2.2818644260E+01, 3.7390189747E+00, 9.7798426323E-01],
	[4.3745000000E+04, 3.9724314088E+01, 5.0391579859E+00, 2.2827187544E+01, 3.7393415246E+00, 9.7799381107E-01],
	[4.3750000000E+04, 3.9732323975E+01, 5.0391984037E+00, 2.2835733049E+01, 3.7396639929E+00, 9.7800335423E-01],
	[4.3755000000E+04, 3.9740334562E+01, 5.0392388172E+00, 2.2844280774E+01, 3.7399863797E+00, 9.7801289271E-01],
	[4.3760000000E+04, 3.9748345848E+01, 5.0392792264E+00, 2.2852830721E+01, 3.7403086850E+00, 9.7802242650E-01],
	[4.3765000000E+04, 3.9756357834E+01, 5.0393196313E+00, 2.2861382890E+01, 3.7406309088E+00, 9.7803195561E-01],
	[4.3770000000E+04, 3.9764370519E+01, 5.0393600319E+00, 2.2869937281E+01, 3.7409530510E+00, 9.7804148004E-01],
	[4.3775000000E+04, 3.9772383904E+01, 5.0394004282E+00, 2.2878493894E+01, 3.7412751119E+00, 9.7805099980E-01],
	[4.3780000000E+04, 3.9780397988E+01, 5.0394408202E+00, 2.2887052730E+01, 3.7415970913E+00, 9.7806051488E-01],
	[4.3785000000E+04, 3.9788412771E+01, 5.0394812080E+00, 2.2895613788E+01, 3.7419189892E+00, 9.7807002529E-01],
	[4.3790000000E+04, 3.9796428253E+01, 5.0395215914E+00, 2.2904177070E+01, 3.7422408058E+00, 9.7807953104E-01],
	[4.3795000000E+04, 3.9804444435E+01, 5.0395619706E+00, 2.2912742576E+01, 3.7425625410E+00, 9.7808903212E-01],
	[4.3800000000E+04, 3.9812461316E+01, 5.0396023455E+00, 2.2921310306E+01, 3.7428841949E+00, 9.7809852854E-01],
	[4.3805000000E+04, 3.9820478896E+01, 5.0396427161E+00, 2.2929880259E+01, 3.7432057674E+00, 9.7810802029E-01],
	[4.3810000000E+04, 3.9828497176E+01, 5.0396830824E+00, 2.2938452438E+01, 3.7435272586E+00, 9.7811750739E-01],
	[4.3815000000E+04, 3.9836516155E+01, 5.0397234444E+00, 2.2947026841E+01, 3.7438486685E+00, 9.7812698984E-01],
	[4.3820000000E+04, 3.9844535833E+01, 5.0397638021E+00, 2.2955603470E+01, 3.7441699971E+00, 9.7813646763E-01],
	[4.3825000000E+04, 3.9852556210E+01, 5.0398041556E+00, 2.2964182324E+01, 3.7444912446E+00, 9.7814594077E-01],
	[4.3830000000E+04, 3.9860577286E+01, 5.0398445048E+00, 2.2972763404E+01, 3.7448124107E+00, 9.7815540926E-01],
	[4.3835000000E+04, 3.9868599062E+01, 5.0398848497E+00, 2.2981346710E+01, 3.7451334957E+00, 9.7816487310E-01],
	[4.3840000000E+04, 3.9876621536E+01, 5.0399251903E+00, 2.2989932243E+01, 3.7454544995E+00, 9.7817433230E-01],
	[4.3845000000E+04, 3.9884644710E+01, 5.0399655267E+00, 2.2998520003E+01, 3.7457754221E+00, 9.7818378687E-01],
	[4.3850000000E+04, 3.9892668583E+01, 5.0400058587E+00, 2.3007109990E+01, 3.7460962636E+00, 9.7819323679E-01],
	[4.3855000000E+04, 3.9900693155E+01, 5.0400461865E+00, 2.3015702204E+01, 3.7464170240E+00, 9.7820268208E-01],
	[4.3860000000E+04, 3.9908718426E+01, 5.0400865100E+00, 2.3024296646E+01, 3.7467377033E+00, 9.7821212273E-01],
	[4.3865000000E+04, 3.9916744396E+01, 5.0401268293E+00, 2.3032893316E+01, 3.7470583015E+00, 9.7822155876E-01],
	[4.3870000000E+04, 3.9924771065E+01, 5.0401671442E+00, 2.3041492215E+01, 3.7473788186E+00, 9.7823099015E-01],
	[4.3875000000E+04, 3.9932798433E+01, 5.0402074549E+00, 2.3050093343E+01, 3.7476992547E+00, 9.7824041692E-01],
	[4.3880000000E+04, 3.9940834049E+01, 5.0402485994E+00, 2.3058696699E+01, 3.7480201397E+00, 9.7824983906E-01],
	[4.3885000000E+04, 3.9948879268E+01, 5.0402907274E+00, 2.3067302285E+01, 3.7483415685E+00, 9.7825925659E-01],
	[4.3890000000E+04, 3.9956925190E+01, 5.0403328511E+00, 2.3075910101E+01, 3.7486629166E+00, 9.7826866950E-01],
	[4.3895000000E+04, 3.9964971817E+01, 5.0403749702E+00, 2.3084520147E+01, 3.7489841839E+00, 9.7827807779E-01],
	[4.3900000000E+04, 3.9973019147E+01, 5.0404170850E+00, 2.3093132423E+01, 3.7493053704E+00, 9.7828748146E-01],
	[4.3905000000E+04, 3.9981067180E+01, 5.0404591953E+00, 2.3101746931E+01, 3.7496264762E+00, 9.7829688053E-01],
	[4.3910000000E+04, 3.9989115917E+01, 5.0405013011E+00, 2.3110363669E+01, 3.7499475014E+00, 9.7830627498E-01],
	[4.3915000000E+04, 3.9997165358E+01, 5.0405434025E+00, 2.3118982638E+01, 3.7502684458E+00, 9.7831566483E-01],
	[4.3920000000E+04, 4.0005215503E+01, 5.0405854995E+00, 2.3127603839E+01, 3.7505893097E+00, 9.7832505008E-01],
	[4.3925000000E+04, 4.0013266351E+01, 5.0406275920E+00, 2.3136227273E+01, 3.7509100928E+00, 9.7833443073E-01],
	[4.3930000000E+04, 4.0021317902E+01, 5.0406696801E+00, 2.3144852938E+01, 3.7512307954E+00, 9.7834380677E-01],
	[4.3935000000E+04, 4.0029370157E+01, 5.0407117637E+00, 2.3153480837E+01, 3.7515514174E+00, 9.7835317822E-01],
	[4.3940000000E+04, 4.0037423115E+01, 5.0407538429E+00, 2.3162110968E+01, 3.7518719588E+00, 9.7836254508E-01],
	[4.3945000000E+04, 4.0045476777E+01, 5.0407959177E+00, 2.3170743332E+01, 3.7521924196E+00, 9.7837190734E-01],
	[4.3950000000E+04, 4.0053531143E+01, 5.0408379880E+00, 2.3179377931E+01, 3.7525127999E+00, 9.7838126502E-01],
	[4.3955000000E+04, 4.0061586212E+01, 5.0408800539E+00, 2.3188014763E+01, 3.7528330997E+00, 9.7839061811E-01],
	[4.3960000000E+04, 4.0069641984E+01, 5.0409221153E+00, 2.3196653829E+01, 3.7531533191E+00, 9.7839996662E-01],
	[4.3965000000E+04, 4.0077698460E+01, 5.0409641724E+00, 2.3205295131E+01, 3.7534734579E+00, 9.7840931054E-01],
	[4.3970000000E+04, 4.0085755639E+01, 5.0410062250E+00, 2.3213938667E+01, 3.7537935163E+00, 9.7841864988E-01],
	[4.3975000000E+04, 4.0093813521E+01, 5.0410482731E+00, 2.3222584438E+01, 3.7541134943E+00, 9.7842798465E-01],
	[4.3980000000E+04, 4.0101872107E+01, 5.0410903169E+00, 2.3231232445E+01, 3.7544333919E+00, 9.7843731484E-01],
	[4.3985000000E+04, 4.0109931396E+01, 5.0411323562E+00, 2.3239882688E+01, 3.7547532091E+00, 9.7844664047E-01],
	[4.3990000000E+04, 4.0117991389E+01, 5.0411743911E+00, 2.3248535167E+01, 3.7550729460E+00, 9.7845596152E-01],
	[4.3995000000E+04, 4.0126052084E+01, 5.0412164215E+00, 2.3257189882E+01, 3.7553926025E+00, 9.7846527800E-01],
	[4.4000000000E+04, 4.0134113483E+01, 5.0412584475E+00, 2.3265846835E+01, 3.7557121787E+00, 9.7847458993E-01],
	[4.4005000000E+04, 4.0142175586E+01, 5.0413004691E+00, 2.3274506024E+01, 3.7560316746E+00, 9.7848389728E-01],
	[4.4010000000E+04, 4.0150238391E+01, 5.0413424863E+00, 2.3283167451E+01, 3.7563510902E+00, 9.7849320008E-01],
	[4.4015000000E+04, 4.0158301900E+01, 5.0413844991E+00, 2.3291831117E+01, 3.7566704255E+00, 9.7850249833E-01],
	[4.4020000000E+04, 4.0166366112E+01, 5.0414265074E+00, 2.3300497020E+01, 3.7569896807E+00, 9.7851179201E-01],
	[4.4025000000E+04, 4.0174431027E+01, 5.0414685113E+00, 2.3309165161E+01, 3.7573088556E+00, 9.7852108115E-01],
	[4.4030000000E+04, 4.0182496645E+01, 5.0415105108E+00, 2.3317835542E+01, 3.7576279503E+00, 9.7853036573E-01],
	[4.4035000000E+04, 4.0190562967E+01, 5.0415525059E+00, 2.3326508162E+01, 3.7579469648E+00, 9.7853964577E-01],
	[4.4040000000E+04, 4.0198629991E+01, 5.0415944965E+00, 2.3335183021E+01, 3.7582658992E+00, 9.7854892127E-01],
	[4.4045000000E+04, 4.0206697719E+01, 5.0416364827E+00, 2.3343860120E+01, 3.7585847535E+00, 9.7855819222E-01],
	[4.4050000000E+04, 4.0214766150E+01, 5.0416784646E+00, 2.3352539459E+01, 3.7589035277E+00, 9.7856745863E-01],
	[4.4055000000E+04, 4.0222835284E+01, 5.0417204420E+00, 2.3361221038E+01, 3.7592222218E+00, 9.7857672050E-01],
	[4.4060000000E+04, 4.0230905120E+01, 5.0417624150E+00, 2.3369904858E+01, 3.7595408358E+00, 9.7858597784E-01],
	[4.4065000000E+04, 4.0238975660E+01, 5.0418043835E+00, 2.3378590920E+01, 3.7598593697E+00, 9.7859523064E-01],
	[4.4070000000E+04, 4.0247046903E+01, 5.0418463477E+00, 2.3387279222E+01, 3.7601778237E+00, 9.7860447892E-01],
	[4.4075000000E+04, 4.0255118849E+01, 5.0418883074E+00, 2.3395969767E+01, 3.7604961976E+00, 9.7861372267E-01],
	[4.4080000000E+04, 4.0263191498E+01, 5.0419302628E+00, 2.3404662553E+01, 3.7608144916E+00, 9.7862296189E-01],
	[4.4085000000E+04, 4.0271264850E+01, 5.0419722137E+00, 2.3413357582E+01, 3.7611327056E+00, 9.7863219659E-01],
	[4.4090000000E+04, 4.0279338905E+01, 5.0420141602E+00, 2.3422054854E+01, 3.7614508396E+00, 9.7864142677E-01],
	[4.4095000000E+04, 4.0287413663E+01, 5.0420561023E+00, 2.3430754368E+01, 3.7617688937E+00, 9.7865065243E-01],
	[4.4100000000E+04, 4.0295489123E+01, 5.0420980400E+00, 2.3439456126E+01, 3.7620868680E+00, 9.7865987357E-01],
	[4.4105000000E+04, 4.0303565287E+01, 5.0421399733E+00, 2.3448160128E+01, 3.7624047623E+00, 9.7866909020E-01],
	[4.4110000000E+04, 4.0311642153E+01, 5.0421819022E+00, 2.3456866374E+01, 3.7627225769E+00, 9.7867830232E-01],
	[4.4115000000E+04, 4.0319719723E+01, 5.0422238267E+00, 2.3465574864E+01, 3.7630403115E+00, 9.7868750994E-01],
	[4.4120000000E+04, 4.0327797995E+01, 5.0422657468E+00, 2.3474285598E+01, 3.7633579664E+00, 9.7869671304E-01],
	[4.4125000000E+04, 4.0335876970E+01, 5.0423076625E+00, 2.3482998578E+01, 3.7636755414E+00, 9.7870591165E-01],
	[4.4130000000E+04, 4.0343956647E+01, 5.0423495738E+00, 2.3491713803E+01, 3.7639930367E+00, 9.7871510575E-01],
	[4.4135000000E+04, 4.0352037028E+01, 5.0423914807E+00, 2.3500431273E+01, 3.7643104523E+00, 9.7872429535E-01],
	[4.4140000000E+04, 4.0360118111E+01, 5.0424333832E+00, 2.3509150990E+01, 3.7646277881E+00, 9.7873348046E-01],
	[4.4145000000E+04, 4.0368199897E+01, 5.0424752813E+00, 2.3517872952E+01, 3.7649450442E+00, 9.7874266107E-01],
	[4.4150000000E+04, 4.0376282386E+01, 5.0425171749E+00, 2.3526597161E+01, 3.7652622206E+00, 9.7875183719E-01],
	[4.4155000000E+04, 4.0384365577E+01, 5.0425590642E+00, 2.3535323618E+01, 3.7655793173E+00, 9.7876100883E-01],
	[4.4160000000E+04, 4.0392449471E+01, 5.0426009491E+00, 2.3544052321E+01, 3.7658963344E+00, 9.7877017597E-01],
	[4.4165000000E+04, 4.0400534068E+01, 5.0426428297E+00, 2.3552783272E+01, 3.7662132719E+00, 9.7877933864E-01],
	[4.4170000000E+04, 4.0408619367E+01, 5.0426847058E+00, 2.3561516471E+01, 3.7665301298E+00, 9.7878849682E-01],
	[4.4175000000E+04, 4.0416705369E+01, 5.0427265775E+00, 2.3570251918E+01, 3.7668469081E+00, 9.7879765052E-01],
	[4.4180000000E+04, 4.0424792074E+01, 5.0427684448E+00, 2.3578989614E+01, 3.7671636068E+00, 9.7880679975E-01],
	[4.4185000000E+04, 4.0432879481E+01, 5.0428103077E+00, 2.3587729558E+01, 3.7674802260E+00, 9.7881594450E-01],
	[4.4190000000E+04, 4.0440967591E+01, 5.0428521663E+00, 2.3596471752E+01, 3.7677967656E+00, 9.7882508477E-01],
	[4.4195000000E+04, 4.0449056403E+01, 5.0428940205E+00, 2.3605216195E+01, 3.7681132258E+00, 9.7883422058E-01],
	[4.4200000000E+04, 4.0457145918E+01, 5.0429358702E+00, 2.3613962888E+01, 3.7684296065E+00, 9.7884335193E-01],
	[4.4205000000E+04, 4.0465236136E+01, 5.0429777156E+00, 2.3622711831E+01, 3.7687459077E+00, 9.7885247880E-01],
	[4.4210000000E+04, 4.0473327056E+01, 5.0430195566E+00, 2.3631463024E+01, 3.7690621295E+00, 9.7886160122E-01],
	[4.4215000000E+04, 4.0481418678E+01, 5.0430613932E+00, 2.3640216469E+01, 3.7693782719E+00, 9.7887071917E-01],
	[4.4220000000E+04, 4.0489511003E+01, 5.0431032255E+00, 2.3648972164E+01, 3.7696943349E+00, 9.7887983267E-01],
	[4.4225000000E+04, 4.0497604030E+01, 5.0431450533E+00, 2.3657730111E+01, 3.7700103185E+00, 9.7888894171E-01],
	[4.4230000000E+04, 4.0505697760E+01, 5.0431868768E+00, 2.3666490310E+01, 3.7703262227E+00, 9.7889804630E-01],
	[4.4235000000E+04, 4.0513792192E+01, 5.0432286959E+00, 2.3675252761E+01, 3.7706420477E+00, 9.7890714644E-01],
	[4.4240000000E+04, 4.0521887326E+01, 5.0432705106E+00, 2.3684017464E+01, 3.7709577933E+00, 9.7891624214E-01],
	[4.4245000000E+04, 4.0529983163E+01, 5.0433123209E+00, 2.3692784420E+01, 3.7712734596E+00, 9.7892533338E-01],
	[4.4250000000E+04, 4.0538079703E+01, 5.0433541269E+00, 2.3701553629E+01, 3.7715890467E+00, 9.7893442019E-01],
	[4.4255000000E+04, 4.0546176944E+01, 5.0433959284E+00, 2.3710325091E+01, 3.7719045545E+00, 9.7894350255E-01],
	[4.4260000000E+04, 4.0554274888E+01, 5.0434377256E+00, 2.3719098807E+01, 3.7722199830E+00, 9.7895258047E-01],
	[4.4265000000E+04, 4.0562373534E+01, 5.0434795184E+00, 2.3727874777E+01, 3.7725353324E+00, 9.7896165396E-01],
	[4.4270000000E+04, 4.0570472883E+01, 5.0435213069E+00, 2.3736653002E+01, 3.7728506026E+00, 9.7897072302E-01],
	[4.4275000000E+04, 4.0578572933E+01, 5.0435630910E+00, 2.3745433481E+01, 3.7731657936E+00, 9.7897978764E-01],
	[4.4280000000E+04, 4.0586673686E+01, 5.0436048707E+00, 2.3754216215E+01, 3.7734809055E+00, 9.7898884784E-01],
	[4.4285000000E+04, 4.0594775142E+01, 5.0436466460E+00, 2.3763001205E+01, 3.7737959383E+00, 9.7899790361E-01],
	[4.4290000000E+04, 4.0602877299E+01, 5.0436884169E+00, 2.3771788450E+01, 3.7741108919E+00, 9.7900695496E-01],
	[4.4295000000E+04, 4.0610980158E+01, 5.0437301835E+00, 2.3780577951E+01, 3.7744257665E+00, 9.7901600188E-01],
	[4.4300000000E+04, 4.0619083720E+01, 5.0437719458E+00, 2.3789369709E+01, 3.7747405620E+00, 9.7902504439E-01],
	[4.4305000000E+04, 4.0627187984E+01, 5.0438137036E+00, 2.3798163723E+01, 3.7750552785E+00, 9.7903408248E-01],
	[4.4310000000E+04, 4.0635292950E+01, 5.0438554571E+00, 2.3806959994E+01, 3.7753699159E+00, 9.7904311615E-01],
	[4.4315000000E+04, 4.0643398618E+01, 5.0438972062E+00, 2.3815758522E+01, 3.7756844744E+00, 9.7905214542E-01],
	[4.4320000000E+04, 4.0651504988E+01, 5.0439389510E+00, 2.3824559308E+01, 3.7759989539E+00, 9.7906117027E-01],
	[4.4325000000E+04, 4.0659612061E+01, 5.0439806914E+00, 2.3833362352E+01, 3.7763133544E+00, 9.7907019072E-01],
	[4.4330000000E+04, 4.0667719835E+01, 5.0440224274E+00, 2.3842167654E+01, 3.7766276760E+00, 9.7907920676E-01],
	[4.4335000000E+04, 4.0675828311E+01, 5.0440641591E+00, 2.3850975215E+01, 3.7769419187E+00, 9.7908821840E-01],
	[4.4340000000E+04, 4.0683937490E+01, 5.0441058864E+00, 2.3859785034E+01, 3.7772560825E+00, 9.7909722564E-01],
	[4.4345000000E+04, 4.0692047370E+01, 5.0441476093E+00, 2.3868597113E+01, 3.7775701674E+00, 9.7910622849E-01],
	[4.4350000000E+04, 4.0700157953E+01, 5.0441893279E+00, 2.3877411452E+01, 3.7778841735E+00, 9.7911522694E-01],
	[4.4355000000E+04, 4.0708269237E+01, 5.0442310421E+00, 2.3886228050E+01, 3.7781981007E+00, 9.7912422099E-01],
	[4.4360000000E+04, 4.0716381223E+01, 5.0442727520E+00, 2.3895046908E+01, 3.7785119491E+00, 9.7913321066E-01],
	[4.4365000000E+04, 4.0724493912E+01, 5.0443144575E+00, 2.3903868027E+01, 3.7788257188E+00, 9.7914219594E-01],
	[4.4370000000E+04, 4.0732607302E+01, 5.0443561587E+00, 2.3912691407E+01, 3.7791394096E+00, 9.7915117683E-01],
	[4.4375000000E+04, 4.0740721394E+01, 5.0443978555E+00, 2.3921517048E+01, 3.7794530218E+00, 9.7916015334E-01],
	[4.4380000000E+04, 4.0748836188E+01, 5.0444395480E+00, 2.3930344950E+01, 3.7797665552E+00, 9.7916912547E-01],
	[4.4385000000E+04, 4.0756951683E+01, 5.0444812361E+00, 2.3939175115E+01, 3.7800800099E+00, 9.7917809322E-01],
	[4.4390000000E+04, 4.0765067881E+01, 5.0445229198E+00, 2.3948007541E+01, 3.7803933859E+00, 9.7918705660E-01],
	[4.4395000000E+04, 4.0773184780E+01, 5.0445645992E+00, 2.3956842230E+01, 3.7807066832E+00, 9.7919601560E-01],
	[4.4400000000E+04, 4.0781302382E+01, 5.0446062743E+00, 2.3965679181E+01, 3.7810199019E+00, 9.7920497023E-01],
	[4.4405000000E+04, 4.0789420685E+01, 5.0446479450E+00, 2.3974518396E+01, 3.7813330420E+00, 9.7921392049E-01],
	[4.4410000000E+04, 4.0797539689E+01, 5.0446896113E+00, 2.3983359874E+01, 3.7816461035E+00, 9.7922286639E-01],
	[4.4415000000E+04, 4.0805659396E+01, 5.0447312733E+00, 2.3992203616E+01, 3.7819590864E+00, 9.7923180792E-01],
	[4.4420000000E+04, 4.0813779804E+01, 5.0447729310E+00, 2.4001049622E+01, 3.7822719908E+00, 9.7924074509E-01],
	[4.4425000000E+04, 4.0821900914E+01, 5.0448145843E+00, 2.4009897893E+01, 3.7825848166E+00, 9.7924967790E-01],
	[4.4430000000E+04, 4.0830022726E+01, 5.0448562333E+00, 2.4018748428E+01, 3.7828975639E+00, 9.7925860636E-01],
	[4.4435000000E+04, 4.0838145239E+01, 5.0448978779E+00, 2.4027601228E+01, 3.7832102327E+00, 9.7926753046E-01],
	[4.4440000000E+04, 4.0846268454E+01, 5.0449395182E+00, 2.4036456294E+01, 3.7835228230E+00, 9.7927645020E-01],
	[4.4445000000E+04, 4.0854392370E+01, 5.0449811541E+00, 2.4045313625E+01, 3.7838353349E+00, 9.7928536560E-01],
	[4.4450000000E+04, 4.0862516989E+01, 5.0450227857E+00, 2.4054173223E+01, 3.7841477683E+00, 9.7929427665E-01],
	[4.4455000000E+04, 4.0870642308E+01, 5.0450644130E+00, 2.4063035086E+01, 3.7844601233E+00, 9.7930318336E-01],
	[4.4460000000E+04, 4.0878768330E+01, 5.0451060359E+00, 2.4071899217E+01, 3.7847723999E+00, 9.7931208572E-01],
	[4.4465000000E+04, 4.0886895053E+01, 5.0451476545E+00, 2.4080765614E+01, 3.7850845982E+00, 9.7932098375E-01],
	[4.4470000000E+04, 4.0895022477E+01, 5.0451892688E+00, 2.4089634279E+01, 3.7853967181E+00, 9.7932987743E-01],
	[4.4475000000E+04, 4.0903150603E+01, 5.0452308787E+00, 2.4098505211E+01, 3.7857087597E+00, 9.7933876678E-01],
	[4.4480000000E+04, 4.0911279431E+01, 5.0452724843E+00, 2.4107378412E+01, 3.7860207230E+00, 9.7934765180E-01],
	[4.4485000000E+04, 4.0919408960E+01, 5.0453140855E+00, 2.4116253881E+01, 3.7863326079E+00, 9.7935653249E-01],
	[4.4490000000E+04, 4.0927539190E+01, 5.0453556825E+00, 2.4125131618E+01, 3.7866444147E+00, 9.7936540885E-01],
	[4.4495000000E+04, 4.0935670122E+01, 5.0453972750E+00, 2.4134011624E+01, 3.7869561431E+00, 9.7937428088E-01],
	[4.4500000000E+04, 4.0943801755E+01, 5.0454388633E+00, 2.4142893900E+01, 3.7872677934E+00, 9.7938314859E-01],
	[4.4505000000E+04, 4.0951934090E+01, 5.0454804472E+00, 2.4151778445E+01, 3.7875793654E+00, 9.7939201198E-01],
	[4.4510000000E+04, 4.0960067126E+01, 5.0455220268E+00, 2.4160665260E+01, 3.7878908593E+00, 9.7940087105E-01],
	[4.4515000000E+04, 4.0968200864E+01, 5.0455636021E+00, 2.4169554345E+01, 3.7882022750E+00, 9.7940972580E-01],
	[4.4520000000E+04, 4.0976335303E+01, 5.0456051730E+00, 2.4178445701E+01, 3.7885136125E+00, 9.7941857624E-01],
	[4.4525000000E+04, 4.0984470443E+01, 5.0456467397E+00, 2.4187339328E+01, 3.7888248720E+00, 9.7942742236E-01],
	[4.4530000000E+04, 4.0992606285E+01, 5.0456883019E+00, 2.4196235226E+01, 3.7891360533E+00, 9.7943626418E-01],
	[4.4535000000E+04, 4.1000742827E+01, 5.0457298599E+00, 2.4205133395E+01, 3.7894471565E+00, 9.7944510169E-01],
	[4.4540000000E+04, 4.1008880072E+01, 5.0457714136E+00, 2.4214033837E+01, 3.7897581817E+00, 9.7945393490E-01],
	[4.4545000000E+04, 4.1017018017E+01, 5.0458129629E+00, 2.4222936551E+01, 3.7900691289E+00, 9.7946276380E-01],
	[4.4550000000E+04, 4.1025156664E+01, 5.0458545079E+00, 2.4231841537E+01, 3.7903799980E+00, 9.7947158841E-01],
	[4.4555000000E+04, 4.1033296012E+01, 5.0458960486E+00, 2.4240748796E+01, 3.7906907892E+00, 9.7948040871E-01],
	[4.4560000000E+04, 4.1041436061E+01, 5.0459375849E+00, 2.4249658328E+01, 3.7910015023E+00, 9.7948922472E-01],
	[4.4565000000E+04, 4.1049576811E+01, 5.0459791170E+00, 2.4258570133E+01, 3.7913121375E+00, 9.7949803644E-01],
	[4.4570000000E+04, 4.1057718262E+01, 5.0460206447E+00, 2.4267484213E+01, 3.7916226948E+00, 9.7950684387E-01],
	[4.4575000000E+04, 4.1065860415E+01, 5.0460621681E+00, 2.4276400567E+01, 3.7919331742E+00, 9.7951564701E-01],
	[4.4580000000E+04, 4.1074003269E+01, 5.0461036872E+00, 2.4285319195E+01, 3.7922435757E+00, 9.7952444586E-01],
	[4.4585000000E+04, 4.1082149841E+01, 5.0461455319E+00, 2.4294240098E+01, 3.7925541113E+00, 9.7953324043E-01],
	[4.4590000000E+04, 4.1090310439E+01, 5.0461888291E+00, 2.4303163276E+01, 3.7928655057E+00, 9.7954203072E-01],
	[4.4595000000E+04, 4.1098471743E+01, 5.0462321217E+00, 2.4312088729E+01, 3.7931768225E+00, 9.7955081673E-01],
	[4.4600000000E+04, 4.1106633753E+01, 5.0462754100E+00, 2.4321016458E+01, 3.7934880616E+00, 9.7955959847E-01],
	[4.4605000000E+04, 4.1114796468E+01, 5.0463186937E+00, 2.4329946464E+01, 3.7937992231E+00, 9.7956837593E-01],
	[4.4610000000E+04, 4.1122959889E+01, 5.0463619729E+00, 2.4338878745E+01, 3.7941103070E+00, 9.7957714912E-01],
	[4.4615000000E+04, 4.1131124016E+01, 5.0464052477E+00, 2.4347813304E+01, 3.7944213134E+00, 9.7958591804E-01],
	[4.4620000000E+04, 4.1139288848E+01, 5.0464485180E+00, 2.4356750139E+01, 3.7947322422E+00, 9.7959468269E-01],
	[4.4625000000E+04, 4.1147454386E+01, 5.0464917838E+00, 2.4365689252E+01, 3.7950430934E+00, 9.7960344308E-01],
	[4.4630000000E+04, 4.1155620630E+01, 5.0465350451E+00, 2.4374630643E+01, 3.7953538672E+00, 9.7961219920E-01],
	[4.4635000000E+04, 4.1163787579E+01, 5.0465783020E+00, 2.4383574312E+01, 3.7956645634E+00, 9.7962095107E-01],
	[4.4640000000E+04, 4.1171955233E+01, 5.0466215544E+00, 2.4392520259E+01, 3.7959751822E+00, 9.7962969868E-01],
	[4.4645000000E+04, 4.1180123594E+01, 5.0466648023E+00, 2.4401468484E+01, 3.7962857236E+00, 9.7963844203E-01],
	[4.4650000000E+04, 4.1188292660E+01, 5.0467080457E+00, 2.4410418989E+01, 3.7965961875E+00, 9.7964718113E-01],
	[4.4655000000E+04, 4.1196462431E+01, 5.0467512847E+00, 2.4419371773E+01, 3.7969065740E+00, 9.7965591598E-01],
	[4.4660000000E+04, 4.1204632908E+01, 5.0467945192E+00, 2.4428326837E+01, 3.7972168831E+00, 9.7966464658E-01],
	[4.4665000000E+04, 4.1212804090E+01, 5.0468377492E+00, 2.4437284181E+01, 3.7975271149E+00, 9.7967337293E-01],
	[4.4670000000E+04, 4.1220975978E+01, 5.0468809747E+00, 2.4446243805E+01, 3.7978372693E+00, 9.7968209505E-01],
	[4.4675000000E+04, 4.1229148571E+01, 5.0469241958E+00, 2.4455205710E+01, 3.7981473464E+00, 9.7969081292E-01],
	[4.4680000000E+04, 4.1237321870E+01, 5.0469674124E+00, 2.4464169895E+01, 3.7984573461E+00, 9.7969952655E-01],
	[4.4685000000E+04, 4.1245495874E+01, 5.0470106246E+00, 2.4473136362E+01, 3.7987672686E+00, 9.7970823594E-01],
	[4.4690000000E+04, 4.1253670583E+01, 5.0470538323E+00, 2.4482105111E+01, 3.7990771139E+00, 9.7971694110E-01],
	[4.4695000000E+04, 4.1261845998E+01, 5.0470970355E+00, 2.4491076141E+01, 3.7993868819E+00, 9.7972564203E-01],
	[4.4700000000E+04, 4.1270022119E+01, 5.0471402343E+00, 2.4500049454E+01, 3.7996965726E+00, 9.7973433873E-01],
	[4.4705000000E+04, 4.1278198944E+01, 5.0471834286E+00, 2.4509025049E+01, 3.8000061862E+00, 9.7974303120E-01],
	[4.4710000000E+04, 4.1286376475E+01, 5.0472266184E+00, 2.4518002928E+01, 3.8003157226E+00, 9.7975171945E-01],
	[4.4715000000E+04, 4.1294554711E+01, 5.0472698038E+00, 2.4526983089E+01, 3.8006251818E+00, 9.7976040347E-01],
	[4.4720000000E+04, 4.1302733653E+01, 5.0473129847E+00, 2.4535965534E+01, 3.8009345639E+00, 9.7976908328E-01],
	[4.4725000000E+04, 4.1310913299E+01, 5.0473561612E+00, 2.4544950263E+01, 3.8012438689E+00, 9.7977775887E-01],
	[4.4730000000E+04, 4.1319093651E+01, 5.0473993332E+00, 2.4553937277E+01, 3.8015530967E+00, 9.7978643024E-01],
	[4.4735000000E+04, 4.1327274709E+01, 5.0474425007E+00, 2.4562926574E+01, 3.8018622475E+00, 9.7979509739E-01],
	[4.4740000000E+04, 4.1335456471E+01, 5.0474856638E+00, 2.4571918157E+01, 3.8021713213E+00, 9.7980376034E-01],
	[4.4745000000E+04, 4.1343638939E+01, 5.0475288224E+00, 2.4580912025E+01, 3.8024803180E+00, 9.7981241908E-01],
	[4.4750000000E+04, 4.1351822111E+01, 5.0475719766E+00, 2.4589908178E+01, 3.8027892377E+00, 9.7982107361E-01],
	[4.4755000000E+04, 4.1360005989E+01, 5.0476151263E+00, 2.4598906617E+01, 3.8030980803E+00, 9.7982972394E-01],
	[4.4760000000E+04, 4.1368190573E+01, 5.0476582716E+00, 2.4607907342E+01, 3.8034068461E+00, 9.7983837006E-01],
	[4.4765000000E+04, 4.1376375861E+01, 5.0477014125E+00, 2.4616910354E+01, 3.8037155348E+00, 9.7984701199E-01],
	[4.4770000000E+04, 4.1384561854E+01, 5.0477445488E+00, 2.4625915653E+01, 3.8040241466E+00, 9.7985564972E-01],
	[4.4775000000E+04, 4.1392748553E+01, 5.0477876808E+00, 2.4634923238E+01, 3.8043326816E+00, 9.7986428326E-01],
	[4.4780000000E+04, 4.1400935956E+01, 5.0478308082E+00, 2.4643933112E+01, 3.8046411396E+00, 9.7987291260E-01],
	[4.4785000000E+04, 4.1409124065E+01, 5.0478739313E+00, 2.4652945273E+01, 3.8049495207E+00, 9.7988153775E-01],
	[4.4790000000E+04, 4.1417312878E+01, 5.0479170499E+00, 2.4661959722E+01, 3.8052578250E+00, 9.7989015872E-01],
	[4.4795000000E+04, 4.1425502397E+01, 5.0479601640E+00, 2.4670976459E+01, 3.8055660525E+00, 9.7989877550E-01],
	[4.4800000000E+04, 4.1433692620E+01, 5.0480032737E+00, 2.4679995485E+01, 3.8058742031E+00, 9.7990738809E-01],
	[4.4805000000E+04, 4.1441883549E+01, 5.0480463790E+00, 2.4689016801E+01, 3.8061822770E+00, 9.7991599651E-01],
	[4.4810000000E+04, 4.1450075182E+01, 5.0480894798E+00, 2.4698040406E+01, 3.8064902741E+00, 9.7992460075E-01],
	[4.4815000000E+04, 4.1458267521E+01, 5.0481325762E+00, 2.4707066300E+01, 3.8067981945E+00, 9.7993320081E-01],
	[4.4820000000E+04, 4.1466460564E+01, 5.0481756681E+00, 2.4716094485E+01, 3.8071060381E+00, 9.7994179670E-01],
	[4.4825000000E+04, 4.1474654313E+01, 5.0482187556E+00, 2.4725124960E+01, 3.8074138050E+00, 9.7995038841E-01],
	[4.4830000000E+04, 4.1482848766E+01, 5.0482618387E+00, 2.4734157725E+01, 3.8077214952E+00, 9.7995897596E-01],
	[4.4835000000E+04, 4.1491043924E+01, 5.0483049173E+00, 2.4743192782E+01, 3.8080291088E+00, 9.7996755934E-01],
	[4.4840000000E+04, 4.1499239787E+01, 5.0483479915E+00, 2.4752230130E+01, 3.8083366457E+00, 9.7997613855E-01],
	[4.4845000000E+04, 4.1507436355E+01, 5.0483910612E+00, 2.4761269770E+01, 3.8086441060E+00, 9.7998471361E-01],
	[4.4850000000E+04, 4.1515633627E+01, 5.0484341265E+00, 2.4770311702E+01, 3.8089514897E+00, 9.7999328450E-01],
	[4.4855000000E+04, 4.1523831604E+01, 5.0484771874E+00, 2.4779355926E+01, 3.8092587968E+00, 9.8000185123E-01],
	[4.4860000000E+04, 4.1532030287E+01, 5.0485202438E+00, 2.4788402443E+01, 3.8095660273E+00, 9.8001041381E-01],
	[4.4865000000E+04, 4.1540229674E+01, 5.0485632959E+00, 2.4797451252E+01, 3.8098731813E+00, 9.8001897224E-01],
	[4.4870000000E+04, 4.1548429765E+01, 5.0486063434E+00, 2.4806502356E+01, 3.8101802588E+00, 9.8002752652E-01],
	[4.4875000000E+04, 4.1556630562E+01, 5.0486493866E+00, 2.4815555752E+01, 3.8104872597E+00, 9.8003607664E-01],
	[4.4880000000E+04, 4.1564832063E+01, 5.0486924253E+00, 2.4824611443E+01, 3.8107941842E+00, 9.8004462262E-01],
	[4.4885000000E+04, 4.1573034268E+01, 5.0487354596E+00, 2.4833669428E+01, 3.8111010322E+00, 9.8005316446E-01],
	[4.4890000000E+04, 4.1581237179E+01, 5.0487784895E+00, 2.4842729708E+01, 3.8114078038E+00, 9.8006170216E-01],
	[4.4895000000E+04, 4.1589440794E+01, 5.0488215150E+00, 2.4851792282E+01, 3.8117144990E+00, 9.8007023571E-01],
	[4.4900000000E+04, 4.1597645114E+01, 5.0488645360E+00, 2.4860857152E+01, 3.8120211177E+00, 9.8007876513E-01],
	[4.4905000000E+04, 4.1605850138E+01, 5.0489075526E+00, 2.4869924317E+01, 3.8123276601E+00, 9.8008729042E-01],
	[4.4910000000E+04, 4.1614055867E+01, 5.0489505647E+00, 2.4878993779E+01, 3.8126341261E+00, 9.8009581157E-01],
	[4.4915000000E+04, 4.1622262301E+01, 5.0489935725E+00, 2.4888065536E+01, 3.8129405158E+00, 9.8010432859E-01],
	[4.4920000000E+04, 4.1630469439E+01, 5.0490365758E+00, 2.4897139590E+01, 3.8132468292E+00, 9.8011284148E-01],
	[4.4925000000E+04, 4.1638677282E+01, 5.0490795747E+00, 2.4906215941E+01, 3.8135530662E+00, 9.8012135025E-01],
	[4.4930000000E+04, 4.1646885829E+01, 5.0491225692E+00, 2.4915294590E+01, 3.8138592270E+00, 9.8012985490E-01],
	[4.4935000000E+04, 4.1655095080E+01, 5.0491655593E+00, 2.4924375536E+01, 3.8141653116E+00, 9.8013835542E-01],
	[4.4940000000E+04, 4.1663305037E+01, 5.0492085450E+00, 2.4933458779E+01, 3.8144713199E+00, 9.8014685183E-01],
	[4.4945000000E+04, 4.1671515697E+01, 5.0492515262E+00, 2.4942544321E+01, 3.8147772519E+00, 9.8015534412E-01],
	[4.4950000000E+04, 4.1679727062E+01, 5.0492945030E+00, 2.4951632161E+01, 3.8150831078E+00, 9.8016383229E-01],
	[4.4955000000E+04, 4.1687939132E+01, 5.0493374754E+00, 2.4960722301E+01, 3.8153888875E+00, 9.8017231635E-01],
	[4.4960000000E+04, 4.1696151906E+01, 5.0493804434E+00, 2.4969814739E+01, 3.8156945911E+00, 9.8018079631E-01],
	[4.4965000000E+04, 4.1704365384E+01, 5.0494234070E+00, 2.4978909477E+01, 3.8160002185E+00, 9.8018927215E-01],
	[4.4970000000E+04, 4.1712579567E+01, 5.0494663662E+00, 2.4988006515E+01, 3.8163057698E+00, 9.8019774390E-01],
	[4.4975000000E+04, 4.1720794454E+01, 5.0495093210E+00, 2.4997105852E+01, 3.8166112451E+00, 9.8020621153E-01],
	[4.4980000000E+04, 4.1729010046E+01, 5.0495522713E+00, 2.5006207491E+01, 3.8169166442E+00, 9.8021467507E-01],
	[4.4985000000E+04, 4.1737226342E+01, 5.0495952173E+00, 2.5015311430E+01, 3.8172219673E+00, 9.8022313451E-01],
	[4.4990000000E+04, 4.1745443342E+01, 5.0496381588E+00, 2.5024417670E+01, 3.8175272143E+00, 9.8023158986E-01],
	[4.4995000000E+04, 4.1753661046E+01, 5.0496810959E+00, 2.5033526212E+01, 3.8178323854E+00, 9.8024004111E-01],
	[4.5000000000E+04, 4.1761879455E+01, 5.0497240286E+00, 2.5042637055E+01, 3.8181374805E+00, 9.8024848827E-01],
	[4.5005000000E+04, 4.1770098568E+01, 5.0497669570E+00, 2.5051768925E+01, 3.8184429345E+00, 9.8025693134E-01],
	[4.5010000000E+04, 4.1778318385E+01, 5.0498098809E+00, 2.5060903108E+01, 3.8187483125E+00, 9.8026537032E-01],
	[4.5015000000E+04, 4.1786538907E+01, 5.0498528004E+00, 2.5070039605E+01, 3.8190536142E+00, 9.8027380522E-01],
	[4.5020000000E+04, 4.1794760133E+01, 5.0498957155E+00, 2.5079178418E+01, 3.8193588398E+00, 9.8028223604E-01],
	[4.5025000000E+04, 4.1802982062E+01, 5.0499386262E+00, 2.5088319545E+01, 3.8196639893E+00, 9.8029066277E-01],
	[4.5030000000E+04, 4.1811204696E+01, 5.0499815325E+00, 2.5097462988E+01, 3.8199690628E+00, 9.8029908543E-01],
	[4.5035000000E+04, 4.1819428035E+01, 5.0500244344E+00, 2.5106608746E+01, 3.8202740601E+00, 9.8030750402E-01],
	[4.5040000000E+04, 4.1827652077E+01, 5.0500673319E+00, 2.5115756821E+01, 3.8205789814E+00, 9.8031591853E-01],
	[4.5045000000E+04, 4.1835876823E+01, 5.0501102250E+00, 2.5124907211E+01, 3.8208838267E+00, 9.8032432897E-01],
	[4.5050000000E+04, 4.1844102274E+01, 5.0501531137E+00, 2.5134059919E+01, 3.8211885959E+00, 9.8033273534E-01],
	[4.5055000000E+04, 4.1852328429E+01, 5.0501959981E+00, 2.5143214943E+01, 3.8214932892E+00, 9.8034113764E-01],
	[4.5060000000E+04, 4.1860555287E+01, 5.0502388780E+00, 2.5152372285E+01, 3.8217979065E+00, 9.8034953588E-01],
	[4.5065000000E+04, 4.1868782850E+01, 5.0502817535E+00, 2.5161531944E+01, 3.8221024478E+00, 9.8035793006E-01],
	[4.5070000000E+04, 4.1877011117E+01, 5.0503246246E+00, 2.5170693921E+01, 3.8224069132E+00, 9.8036632018E-01],
	[4.5075000000E+04, 4.1885240087E+01, 5.0503674914E+00, 2.5179858217E+01, 3.8227113027E+00, 9.8037470624E-01],
	[4.5080000000E+04, 4.1893469762E+01, 5.0504103537E+00, 2.5189024831E+01, 3.8230156163E+00, 9.8038308825E-01],
	[4.5085000000E+04, 4.1901700141E+01, 5.0504532117E+00, 2.5198193764E+01, 3.8233198541E+00, 9.8039146620E-01],
	[4.5090000000E+04, 4.1909931224E+01, 5.0504960653E+00, 2.5207365017E+01, 3.8236240160E+00, 9.8039984011E-01],
	[4.5095000000E+04, 4.1918163010E+01, 5.0505389145E+00, 2.5216538589E+01, 3.8239281021E+00, 9.8040820996E-01],
	[4.5100000000E+04, 4.1926395501E+01, 5.0505817593E+00, 2.5225714481E+01, 3.8242321123E+00, 9.8041657577E-01],
	[4.5105000000E+04, 4.1934628695E+01, 5.0506245997E+00, 2.5234892693E+01, 3.8245360468E+00, 9.8042493754E-01],
	[4.5110000000E+04, 4.1942862594E+01, 5.0506674357E+00, 2.5244073226E+01, 3.8248399055E+00, 9.8043329526E-01],
	[4.5115000000E+04, 4.1951097196E+01, 5.0507102673E+00, 2.5253256080E+01, 3.8251436885E+00, 9.8044164895E-01],
	[4.5120000000E+04, 4.1959332502E+01, 5.0507530946E+00, 2.5262441255E+01, 3.8254473957E+00, 9.8044999860E-01],
	[4.5125000000E+04, 4.1967568512E+01, 5.0507959175E+00, 2.5271628752E+01, 3.8257510273E+00, 9.8045834421E-01],
	[4.5130000000E+04, 4.1975805226E+01, 5.0508387360E+00, 2.5280818570E+01, 3.8260545831E+00, 9.8046668579E-01],
	[4.5135000000E+04, 4.1984042643E+01, 5.0508815501E+00, 2.5290010711E+01, 3.8263580633E+00, 9.8047502334E-01],
	[4.5140000000E+04, 4.1992280764E+01, 5.0509243598E+00, 2.5299205175E+01, 3.8266614679E+00, 9.8048335686E-01],
	[4.5145000000E+04, 4.2000519589E+01, 5.0509671652E+00, 2.5308401961E+01, 3.8269647968E+00, 9.8049168636E-01],
	[4.5150000000E+04, 4.2008759118E+01, 5.0510099662E+00, 2.5317601071E+01, 3.8272680501E+00, 9.8050001183E-01],
	[4.5155000000E+04, 4.2016999351E+01, 5.0510527628E+00, 2.5326802504E+01, 3.8275712279E+00, 9.8050833328E-01],
	[4.5160000000E+04, 4.2025240287E+01, 5.0510955550E+00, 2.5336006261E+01, 3.8278743301E+00, 9.8051665072E-01],
	[4.5165000000E+04, 4.2033481927E+01, 5.0511383428E+00, 2.5345212342E+01, 3.8281773567E+00, 9.8052496413E-01],
	[4.5170000000E+04, 4.2041724270E+01, 5.0511811263E+00, 2.5354420748E+01, 3.8284803079E+00, 9.8053327353E-01],
	[4.5175000000E+04, 4.2049967318E+01, 5.0512239054E+00, 2.5363631479E+01, 3.8287831835E+00, 9.8054157891E-01],
	[4.5180000000E+04, 4.2058211069E+01, 5.0512666801E+00, 2.5372844535E+01, 3.8290859836E+00, 9.8054988029E-01],
	[4.5185000000E+04, 4.2066455523E+01, 5.0513094505E+00, 2.5382059916E+01, 3.8293887083E+00, 9.8055817765E-01],
	[4.5190000000E+04, 4.2074700681E+01, 5.0513522165E+00, 2.5391277624E+01, 3.8296913576E+00, 9.8056647100E-01],
	[4.5195000000E+04, 4.2082946543E+01, 5.0513949781E+00, 2.5400497657E+01, 3.8299939314E+00, 9.8057476035E-01],
	[4.5200000000E+04, 4.2091193108E+01, 5.0514377354E+00, 2.5409720018E+01, 3.8302964298E+00, 9.8058304569E-01],
	[4.5205000000E+04, 4.2099440377E+01, 5.0514804882E+00, 2.5418944705E+01, 3.8305988529E+00, 9.8059132703E-01],
	[4.5210000000E+04, 4.2107688349E+01, 5.0515232368E+00, 2.5428171719E+01, 3.8309012006E+00, 9.8059960437E-01],
	[4.5215000000E+04, 4.2115937025E+01, 5.0515659809E+00, 2.5437401061E+01, 3.8312034729E+00, 9.8060787771E-01],
	[4.5220000000E+04, 4.2124186404E+01, 5.0516087207E+00, 2.5446632730E+01, 3.8315056700E+00, 9.8061614706E-01],
	[4.5225000000E+04, 4.2132436487E+01, 5.0516514561E+00, 2.5455866728E+01, 3.8318077917E+00, 9.8062441241E-01],
	[4.5230000000E+04, 4.2140687273E+01, 5.0516941872E+00, 2.5465103054E+01, 3.8321098382E+00, 9.8063267377E-01],
	[4.5235000000E+04, 4.2148938763E+01, 5.0517369139E+00, 2.5474341709E+01, 3.8324118094E+00, 9.8064093114E-01],
	[4.5240000000E+04, 4.2157190956E+01, 5.0517796362E+00, 2.5483582693E+01, 3.8327137054E+00, 9.8064918452E-01],
	[4.5245000000E+04, 4.2165443853E+01, 5.0518223542E+00, 2.5492826007E+01, 3.8330155262E+00, 9.8065743391E-01],
	[4.5250000000E+04, 4.2173697453E+01, 5.0518650678E+00, 2.5502071651E+01, 3.8333172718E+00, 9.8066567932E-01],
	[4.5255000000E+04, 4.2181951756E+01, 5.0519077770E+00, 2.5511319624E+01, 3.8336189422E+00, 9.8067392074E-01],
	[4.5260000000E+04, 4.2190206762E+01, 5.0519504819E+00, 2.5520569929E+01, 3.8339205374E+00, 9.8068215819E-01],
	[4.5265000000E+04, 4.2198462472E+01, 5.0519931825E+00, 2.5529822564E+01, 3.8342220576E+00, 9.8069039165E-01],
	[4.5270000000E+04, 4.2206718886E+01, 5.0520358787E+00, 2.5539077530E+01, 3.8345235026E+00, 9.8069862114E-01],
	[4.5275000000E+04, 4.2214976002E+01, 5.0520785705E+00, 2.5548334828E+01, 3.8348248725E+00, 9.8070684666E-01],
	[4.5280000000E+04, 4.2223233822E+01, 5.0521212580E+00, 2.5557594457E+01, 3.8351261673E+00, 9.8071506820E-01],
	[4.5285000000E+04, 4.2231492345E+01, 5.0521639411E+00, 2.5566856419E+01, 3.8354273871E+00, 9.8072328577E-01],
	[4.5290000000E+04, 4.2239751572E+01, 5.0522066199E+00, 2.5576120713E+01, 3.8357285319E+00, 9.8073149937E-01],
	[4.5295000000E+04, 4.2248011501E+01, 5.0522492943E+00, 2.5585387339E+01, 3.8360296016E+00, 9.8073970900E-01],
	[4.5300000000E+04, 4.2256272134E+01, 5.0522919644E+00, 2.5594656299E+01, 3.8363305964E+00, 9.8074791467E-01],
	[4.5305000000E+04, 4.2264543820E+01, 5.0523357422E+00, 2.5603927593E+01, 3.8366322427E+00, 9.8075611638E-01],
	[4.5310000000E+04, 4.2272822135E+01, 5.0523801518E+00, 2.5613201220E+01, 3.8369342300E+00, 9.8076431413E-01],
	[4.5315000000E+04, 4.2281101158E+01, 5.0524245569E+00, 2.5622477181E+01, 3.8372361425E+00, 9.8077250791E-01],
	[4.5320000000E+04, 4.2289380889E+01, 5.0524689574E+00, 2.5631755477E+01, 3.8375379803E+00, 9.8078069774E-01],
	[4.5325000000E+04, 4.2297661327E+01, 5.0525133535E+00, 2.5641036108E+01, 3.8378397433E+00, 9.8078888361E-01],
	[4.5330000000E+04, 4.2305942473E+01, 5.0525577451E+00, 2.5650319073E+01, 3.8381414316E+00, 9.8079706554E-01],
	[4.5335000000E+04, 4.2314224327E+01, 5.0526021321E+00, 2.5659604374E+01, 3.8384430452E+00, 9.8080524351E-01],
	[4.5340000000E+04, 4.2322506888E+01, 5.0526465147E+00, 2.5668892011E+01, 3.8387445842E+00, 9.8081341753E-01],
	[4.5345000000E+04, 4.2330790157E+01, 5.0526908928E+00, 2.5678181984E+01, 3.8390460485E+00, 9.8082158760E-01],
	[4.5350000000E+04, 4.2339074133E+01, 5.0527352663E+00, 2.5687474293E+01, 3.8393474382E+00, 9.8082975373E-01],
	[4.5355000000E+04, 4.2347358817E+01, 5.0527796353E+00, 2.5696768939E+01, 3.8396487533E+00, 9.8083791591E-01],
	[4.5360000000E+04, 4.2355644209E+01, 5.0528239999E+00, 2.5706065922E+01, 3.8399499938E+00, 9.8084607415E-01],
	[4.5365000000E+04, 4.2363930308E+01, 5.0528683599E+00, 2.5715365243E+01, 3.8402511598E+00, 9.8085422846E-01],
	[4.5370000000E+04, 4.2372217115E+01, 5.0529127155E+00, 2.5724666901E+01, 3.8405522512E+00, 9.8086237882E-01],
	[4.5375000000E+04, 4.2380504629E+01, 5.0529570665E+00, 2.5733970897E+01, 3.8408532681E+00, 9.8087052525E-01],
	[4.5380000000E+04, 4.2388792851E+01, 5.0530014131E+00, 2.5743277232E+01, 3.8411542104E+00, 9.8087866775E-01],
	[4.5385000000E+04, 4.2397081780E+01, 5.0530457551E+00, 2.5752585905E+01, 3.8414550783E+00, 9.8088680631E-01],
	[4.5390000000E+04, 4.2405371417E+01, 5.0530900927E+00, 2.5761896918E+01, 3.8417558717E+00, 9.8089494095E-01],
	[4.5395000000E+04, 4.2413661761E+01, 5.0531344257E+00, 2.5771210270E+01, 3.8420565907E+00, 9.8090307166E-01],
	[4.5400000000E+04, 4.2421952813E+01, 5.0531787543E+00, 2.5780525961E+01, 3.8423572353E+00, 9.8091119844E-01],
	[4.5405000000E+04, 4.2430244572E+01, 5.0532230784E+00, 2.5789843993E+01, 3.8426578054E+00, 9.8091932130E-01],
	[4.5410000000E+04, 4.2438537038E+01, 5.0532673979E+00, 2.5799164365E+01, 3.8429583012E+00, 9.8092744023E-01],
	[4.5415000000E+04, 4.2446830212E+01, 5.0533117130E+00, 2.5808487077E+01, 3.8432587226E+00, 9.8093555525E-01],
	[4.5420000000E+04, 4.2455124093E+01, 5.0533560236E+00, 2.5817812131E+01, 3.8435590697E+00, 9.8094366635E-01],
	[4.5425000000E+04, 4.2463418681E+01, 5.0534003297E+00, 2.5827139526E+01, 3.8438593425E+00, 9.8095177353E-01],
	[4.5430000000E+04, 4.2471713977E+01, 5.0534446314E+00, 2.5836469263E+01, 3.8441595409E+00, 9.8095987680E-01],
	[4.5435000000E+04, 4.2480009980E+01, 5.0534889285E+00, 2.5845801342E+01, 3.8444596651E+00, 9.8096797615E-01],
	[4.5440000000E+04, 4.2488306690E+01, 5.0535332211E+00, 2.5855135763E+01, 3.8447597150E+00, 9.8097607160E-01],
	[4.5445000000E+04, 4.2496604108E+01, 5.0535775093E+00, 2.5864472527E+01, 3.8450596906E+00, 9.8098416314E-01],
	[4.5450000000E+04, 4.2504902233E+01, 5.0536217930E+00, 2.5873811633E+01, 3.8453595921E+00, 9.8099225077E-01],
	[4.5455000000E+04, 4.2513201065E+01, 5.0536660722E+00, 2.5883153084E+01, 3.8456594193E+00, 9.8100033449E-01],
	[4.5460000000E+04, 4.2521500604E+01, 5.0537103469E+00, 2.5892496877E+01, 3.8459591724E+00, 9.8100841432E-01],
	[4.5465000000E+04, 4.2529800851E+01, 5.0537546171E+00, 2.5901843015E+01, 3.8462588513E+00, 9.8101649024E-01],
	[4.5470000000E+04, 4.2538101805E+01, 5.0537988829E+00, 2.5911191497E+01, 3.8465584560E+00, 9.8102456227E-01],
	[4.5475000000E+04, 4.2546403466E+01, 5.0538431441E+00, 2.5920542324E+01, 3.8468579866E+00, 9.8103263040E-01],
	[4.5480000000E+04, 4.2554705834E+01, 5.0538874009E+00, 2.5929895496E+01, 3.8471574432E+00, 9.8104069464E-01],
	[4.5485000000E+04, 4.2563008909E+01, 5.0539316532E+00, 2.5939251013E+01, 3.8474568256E+00, 9.8104875498E-01],
	[4.5490000000E+04, 4.2571312691E+01, 5.0539759011E+00, 2.5948608876E+01, 3.8477561340E+00, 9.8105681143E-01],
	[4.5495000000E+04, 4.2579617181E+01, 5.0540201444E+00, 2.5957969084E+01, 3.8480553684E+00, 9.8106486399E-01],
	[4.5500000000E+04, 4.2587922377E+01, 5.0540643833E+00, 2.5967331639E+01, 3.8483545287E+00, 9.8107291267E-01],
	[4.5505000000E+04, 4.2596228281E+01, 5.0541086177E+00, 2.5976696541E+01, 3.8486536150E+00, 9.8108095746E-01],
	[4.5510000000E+04, 4.2604534891E+01, 5.0541528477E+00, 2.5986063790E+01, 3.8489526274E+00, 9.8108899837E-01],
	[4.5515000000E+04, 4.2612842209E+01, 5.0541970731E+00, 2.5995433386E+01, 3.8492515658E+00, 9.8109703540E-01],
	[4.5520000000E+04, 4.2621150233E+01, 5.0542412941E+00, 2.6004805329E+01, 3.8495504302E+00, 9.8110506855E-01],
	[4.5525000000E+04, 4.2629458965E+01, 5.0542855107E+00, 2.6014179621E+01, 3.8498492208E+00, 9.8111309783E-01],
	[4.5530000000E+04, 4.2637768404E+01, 5.0543297227E+00, 2.6023556260E+01, 3.8501479374E+00, 9.8112112322E-01],
	[4.5535000000E+04, 4.2646078549E+01, 5.0543739303E+00, 2.6032935249E+01, 3.8504465801E+00, 9.8112914475E-01],
	[4.5540000000E+04, 4.2654389402E+01, 5.0544181334E+00, 2.6042316586E+01, 3.8507451490E+00, 9.8113716240E-01],
	[4.5545000000E+04, 4.2662700961E+01, 5.0544623321E+00, 2.6051700273E+01, 3.8510436441E+00, 9.8114517619E-01],
	[4.5550000000E+04, 4.2671013227E+01, 5.0545065263E+00, 2.6061086309E+01, 3.8513420653E+00, 9.8115318610E-01],
	[4.5555000000E+04, 4.2679326200E+01, 5.0545507160E+00, 2.6070474695E+01, 3.8516404127E+00, 9.8116119216E-01],
	[4.5560000000E+04, 4.2687639880E+01, 5.0545949013E+00, 2.6079865432E+01, 3.8519386864E+00, 9.8116919435E-01],
	[4.5565000000E+04, 4.2695954267E+01, 5.0546390821E+00, 2.6089258519E+01, 3.8522368863E+00, 9.8117719267E-01],
	[4.5570000000E+04, 4.2704269361E+01, 5.0546832584E+00, 2.6098653957E+01, 3.8525350125E+00, 9.8118518714E-01],
	[4.5575000000E+04, 4.2712585162E+01, 5.0547274303E+00, 2.6108051746E+01, 3.8528330649E+00, 9.8119317775E-01],
	[4.5580000000E+04, 4.2720901669E+01, 5.0547715977E+00, 2.6117451887E+01, 3.8531310436E+00, 9.8120116451E-01],
	[4.5585000000E+04, 4.2729218883E+01, 5.0548157606E+00, 2.6126854379E+01, 3.8534289487E+00, 9.8120914741E-01],
	[4.5590000000E+04, 4.2737536804E+01, 5.0548599191E+00, 2.6136259224E+01, 3.8537267801E+00, 9.8121712646E-01],
	[4.5595000000E+04, 4.2745855432E+01, 5.0549040732E+00, 2.6145666422E+01, 3.8540245378E+00, 9.8122510166E-01],
	[4.5600000000E+04, 4.2754174766E+01, 5.0549482228E+00, 2.6155075972E+01, 3.8543222220E+00, 9.8123307302E-01],
	[4.5605000000E+04, 4.2762494807E+01, 5.0549923679E+00, 2.6164487876E+01, 3.8546198325E+00, 9.8124104052E-01],
	[4.5610000000E+04, 4.2770815555E+01, 5.0550365086E+00, 2.6173902133E+01, 3.8549173695E+00, 9.8124900419E-01],
	[4.5615000000E+04, 4.2779137009E+01, 5.0550806448E+00, 2.6183318744E+01, 3.8552148329E+00, 9.8125696401E-01],
	[4.5620000000E+04, 4.2787459170E+01, 5.0551247766E+00, 2.6192737710E+01, 3.8555122228E+00, 9.8126491999E-01],
	[4.5625000000E+04, 4.2795782038E+01, 5.0551689039E+00, 2.6202159030E+01, 3.8558095391E+00, 9.8127287213E-01],
	[4.5630000000E+04, 4.2804105612E+01, 5.0552130268E+00, 2.6211582705E+01, 3.8561067820E+00, 9.8128082044E-01],
	[4.5635000000E+04, 4.2812429893E+01, 5.0552571452E+00, 2.6221008735E+01, 3.8564039513E+00, 9.8128876492E-01],
	[4.5640000000E+04, 4.2820754881E+01, 5.0553012591E+00, 2.6230437120E+01, 3.8567010473E+00, 9.8129670556E-01],
	[4.5645000000E+04, 4.2829080575E+01, 5.0553453687E+00, 2.6239867862E+01, 3.8569980697E+00, 9.8130464237E-01],
	[4.5650000000E+04, 4.2837406976E+01, 5.0553894737E+00, 2.6249300959E+01, 3.8572950188E+00, 9.8131257535E-01],
	[4.5655000000E+04, 4.2845734083E+01, 5.0554335744E+00, 2.6258736413E+01, 3.8575918945E+00, 9.8132050451E-01],
	[4.5660000000E+04, 4.2854061897E+01, 5.0554776706E+00, 2.6268174224E+01, 3.8578886967E+00, 9.8132842984E-01],
	[4.5665000000E+04, 4.2862390417E+01, 5.0555217623E+00, 2.6277614393E+01, 3.8581854257E+00, 9.8133635135E-01],
	[4.5670000000E+04, 4.2870719644E+01, 5.0555658496E+00, 2.6287056919E+01, 3.8584820812E+00, 9.8134426904E-01],
	[4.5675000000E+04, 4.2879049577E+01, 5.0556099325E+00, 2.6296501802E+01, 3.8587786635E+00, 9.8135218291E-01],
	[4.5680000000E+04, 4.2887380217E+01, 5.0556540109E+00, 2.6305949044E+01, 3.8590751725E+00, 9.8136009297E-01],
	[4.5685000000E+04, 4.2895711563E+01, 5.0556980849E+00, 2.6315398644E+01, 3.8593716082E+00, 9.8136799921E-01],
	[4.5690000000E+04, 4.2904043615E+01, 5.0557421544E+00, 2.6324850604E+01, 3.8596679706E+00, 9.8137590163E-01],
	[4.5695000000E+04, 4.2912376374E+01, 5.0557862195E+00, 2.6334304922E+01, 3.8599642598E+00, 9.8138380025E-01],
	[4.5700000000E+04, 4.2920709839E+01, 5.0558302801E+00, 2.6343761600E+01, 3.8602604757E+00, 9.8139169506E-01],
	[4.5705000000E+04, 4.2929044011E+01, 5.0558743364E+00, 2.6353220638E+01, 3.8605566185E+00, 9.8139958606E-01],
	[4.5710000000E+04, 4.2937378889E+01, 5.0559183882E+00, 2.6362682035E+01, 3.8608526881E+00, 9.8140747325E-01],
	[4.5715000000E+04, 4.2945714473E+01, 5.0559624355E+00, 2.6372145794E+01, 3.8611486845E+00, 9.8141535664E-01],
	[4.5720000000E+04, 4.2954050764E+01, 5.0560064784E+00, 2.6381611913E+01, 3.8614446078E+00, 9.8142323623E-01],
	[4.5725000000E+04, 4.2962387761E+01, 5.0560505169E+00, 2.6391080393E+01, 3.8617404580E+00, 9.8143111203E-01],
	[4.5730000000E+04, 4.2970725464E+01, 5.0560945510E+00, 2.6400551235E+01, 3.8620362351E+00, 9.8143898402E-01],
	[4.5735000000E+04, 4.2979063873E+01, 5.0561385806E+00, 2.6410024439E+01, 3.8623319391E+00, 9.8144685222E-01],
	[4.5740000000E+04, 4.2987402989E+01, 5.0561826058E+00, 2.6419500005E+01, 3.8626275701E+00, 9.8145471663E-01],
	[4.5745000000E+04, 4.2995742811E+01, 5.0562266266E+00, 2.6428977933E+01, 3.8629231280E+00, 9.8146257724E-01],
	[4.5750000000E+04, 4.3004083339E+01, 5.0562706429E+00, 2.6438458224E+01, 3.8632186128E+00, 9.8147043407E-01],
	[4.5755000000E+04, 4.3012424574E+01, 5.0563146548E+00, 2.6447940879E+01, 3.8635140247E+00, 9.8147828711E-01],
	[4.5760000000E+04, 4.3020766514E+01, 5.0563586623E+00, 2.6457425896E+01, 3.8638093636E+00, 9.8148613636E-01],
	[4.5765000000E+04, 4.3029109161E+01, 5.0564026654E+00, 2.6466913278E+01, 3.8641046296E+00, 9.8149398183E-01],
	[4.5770000000E+04, 4.3037452513E+01, 5.0564466640E+00, 2.6476403024E+01, 3.8643998226E+00, 9.8150182351E-01],
	[4.5775000000E+04, 4.3045796572E+01, 5.0564906582E+00, 2.6485895134E+01, 3.8646949427E+00, 9.8150966142E-01],
	[4.5780000000E+04, 4.3054141337E+01, 5.0565346480E+00, 2.6495389609E+01, 3.8649899899E+00, 9.8151749555E-01],
	[4.5785000000E+04, 4.3062486808E+01, 5.0565786334E+00, 2.6504886449E+01, 3.8652849642E+00, 9.8152532590E-01],
	[4.5790000000E+04, 4.3070832985E+01, 5.0566226143E+00, 2.6514385654E+01, 3.8655798656E+00, 9.8153315248E-01],
	[4.5795000000E+04, 4.3079179869E+01, 5.0566665908E+00, 2.6523887226E+01, 3.8658746943E+00, 9.8154097529E-01],
	[4.5800000000E+04, 4.3087527458E+01, 5.0567105629E+00, 2.6533391163E+01, 3.8661694501E+00, 9.8154879432E-01],
	[4.5805000000E+04, 4.3095875753E+01, 5.0567545306E+00, 2.6542897467E+01, 3.8664641330E+00, 9.8155660959E-01],
	[4.5810000000E+04, 4.3104224754E+01, 5.0567984939E+00, 2.6552406138E+01, 3.8667587433E+00, 9.8156442109E-01],
	[4.5815000000E+04, 4.3112574462E+01, 5.0568424528E+00, 2.6561917176E+01, 3.8670532807E+00, 9.8157222883E-01],
	[4.5820000000E+04, 4.3120924875E+01, 5.0568864072E+00, 2.6571430581E+01, 3.8673477454E+00, 9.8158003280E-01],
	[4.5825000000E+04, 4.3129275994E+01, 5.0569303572E+00, 2.6580946354E+01, 3.8676421374E+00, 9.8158783302E-01],
	[4.5830000000E+04, 4.3137627819E+01, 5.0569743028E+00, 2.6590464495E+01, 3.8679364567E+00, 9.8159562948E-01],
	[4.5835000000E+04, 4.3145980350E+01, 5.0570182440E+00, 2.6599985004E+01, 3.8682307033E+00, 9.8160342217E-01],
	[4.5840000000E+04, 4.3154333587E+01, 5.0570621808E+00, 2.6609507883E+01, 3.8685248773E+00, 9.8161121112E-01],
	[4.5845000000E+04, 4.3162687529E+01, 5.0571061132E+00, 2.6619033130E+01, 3.8688189786E+00, 9.8161899631E-01],
	[4.5850000000E+04, 4.3171042178E+01, 5.0571500412E+00, 2.6628560747E+01, 3.8691130073E+00, 9.8162677775E-01],
	[4.5855000000E+04, 4.3179397532E+01, 5.0571939647E+00, 2.6638090733E+01, 3.8694069634E+00, 9.8163455544E-01],
	[4.5860000000E+04, 4.3187753593E+01, 5.0572378839E+00, 2.6647623090E+01, 3.8697008469E+00, 9.8164232939E-01],
	[4.5865000000E+04, 4.3196110359E+01, 5.0572817987E+00, 2.6657157817E+01, 3.8699946579E+00, 9.8165009959E-01],
	[4.5870000000E+04, 4.3204467831E+01, 5.0573257090E+00, 2.6666694915E+01, 3.8702883963E+00, 9.8165786604E-01],
	[4.5875000000E+04, 4.3212826008E+01, 5.0573696149E+00, 2.6676234384E+01, 3.8705820622E+00, 9.8166562876E-01],
	[4.5880000000E+04, 4.3221184892E+01, 5.0574135165E+00, 2.6685776224E+01, 3.8708756556E+00, 9.8167338773E-01],
	[4.5885000000E+04, 4.3229544481E+01, 5.0574574136E+00, 2.6695320436E+01, 3.8711691765E+00, 9.8168114297E-01],
	[4.5890000000E+04, 4.3237904776E+01, 5.0575013063E+00, 2.6704867020E+01, 3.8714626249E+00, 9.8168889447E-01],
	[4.5895000000E+04, 4.3246265776E+01, 5.0575451946E+00, 2.6714415976E+01, 3.8717560009E+00, 9.8169664224E-01],
	[4.5900000000E+04, 4.3254627482E+01, 5.0575890786E+00, 2.6723967305E+01, 3.8720493045E+00, 9.8170438628E-01],
	[4.5905000000E+04, 4.3262989894E+01, 5.0576329581E+00, 2.6733521008E+01, 3.8723425357E+00, 9.8171212659E-01],
	[4.5910000000E+04, 4.3271353012E+01, 5.0576768332E+00, 2.6743077083E+01, 3.8726356945E+00, 9.8171986317E-01],
	[4.5915000000E+04, 4.3279716835E+01, 5.0577207040E+00, 2.6752635533E+01, 3.8729287809E+00, 9.8172759602E-01],
	[4.5920000000E+04, 4.3288081364E+01, 5.0577645703E+00, 2.6762196356E+01, 3.8732217950E+00, 9.8173532515E-01],
	[4.5925000000E+04, 4.3296446598E+01, 5.0578084322E+00, 2.6771759554E+01, 3.8735147368E+00, 9.8174305056E-01],
	[4.5930000000E+04, 4.3304812538E+01, 5.0578522898E+00, 2.6781325126E+01, 3.8738076063E+00, 9.8175077225E-01],
	[4.5935000000E+04, 4.3313179184E+01, 5.0578961429E+00, 2.6790893074E+01, 3.8741004034E+00, 9.8175849022E-01],
	[4.5940000000E+04, 4.3321546535E+01, 5.0579399917E+00, 2.6800463397E+01, 3.8743931284E+00, 9.8176620447E-01],
	[4.5945000000E+04, 4.3329914591E+01, 5.0579838360E+00, 2.6810036095E+01, 3.8746857810E+00, 9.8177391501E-01],
	[4.5950000000E+04, 4.3338283353E+01, 5.0580276760E+00, 2.6819611170E+01, 3.8749783615E+00, 9.8178162184E-01],
	[4.5955000000E+04, 4.3346652821E+01, 5.0580715116E+00, 2.6829188621E+01, 3.8752708698E+00, 9.8178932495E-01],
	[4.5960000000E+04, 4.3355022994E+01, 5.0581153428E+00, 2.6838768449E+01, 3.8755633058E+00, 9.8179702436E-01],
	[4.5965000000E+04, 4.3363393873E+01, 5.0581591696E+00, 2.6848350654E+01, 3.8758556697E+00, 9.8180472006E-01],
	[4.5970000000E+04, 4.3371765457E+01, 5.0582029920E+00, 2.6857935236E+01, 3.8761479615E+00, 9.8181241205E-01],
	[4.5975000000E+04, 4.3380137746E+01, 5.0582468101E+00, 2.6867522195E+01, 3.8764401811E+00, 9.8182010035E-01],
	[4.5980000000E+04, 4.3388510741E+01, 5.0582906237E+00, 2.6877111533E+01, 3.8767323287E+00, 9.8182778494E-01],
	[4.5985000000E+04, 4.3396884441E+01, 5.0583344330E+00, 2.6886703249E+01, 3.8770244041E+00, 9.8183546583E-01],
	[4.5990000000E+04, 4.3405258847E+01, 5.0583782378E+00, 2.6896297344E+01, 3.8773164075E+00, 9.8184314303E-01],
	[4.5995000000E+04, 4.3413633958E+01, 5.0584220383E+00, 2.6905893818E+01, 3.8776083388E+00, 9.8185081653E-01],
	[4.6000000000E+04, 4.3422009774E+01, 5.0584658344E+00, 2.6915492671E+01, 3.8779001982E+00, 9.8185848633E-01],
	[4.6005000000E+04, 4.3430386296E+01, 5.0585096262E+00, 2.6925093904E+01, 3.8781919855E+00, 9.8186615245E-01],
	[4.6010000000E+04, 4.3438763523E+01, 5.0585534135E+00, 2.6934697517E+01, 3.8784837008E+00, 9.8187381487E-01],
	[4.6015000000E+04, 4.3447141455E+01, 5.0585971965E+00, 2.6944303510E+01, 3.8787753441E+00, 9.8188147361E-01],
	[4.6020000000E+04, 4.3455520092E+01, 5.0586409751E+00, 2.6953911884E+01, 3.8790669156E+00, 9.8188912866E-01],
	[4.6025000000E+04, 4.3463899435E+01, 5.0586847493E+00, 2.6963522639E+01, 3.8793584150E+00, 9.8189678003E-01],
	[4.6030000000E+04, 4.3472279483E+01, 5.0587285192E+00, 2.6973135775E+01, 3.8796498426E+00, 9.8190442772E-01],
	[4.6035000000E+04, 4.3480672861E+01, 5.0587736131E+00, 2.6982751293E+01, 3.8799420803E+00, 9.8191207172E-01],
	[4.6040000000E+04, 4.3489070582E+01, 5.0588190848E+00, 2.6992369193E+01, 3.8802345001E+00, 9.8191971205E-01],
	[4.6045000000E+04, 4.3497469012E+01, 5.0588645520E+00, 2.7001989475E+01, 3.8805268481E+00, 9.8192734871E-01],
	[4.6050000000E+04, 4.3505868152E+01, 5.0589100146E+00, 2.7011612140E+01, 3.8808191245E+00, 9.8193498168E-01],
	[4.6055000000E+04, 4.3514268002E+01, 5.0589554727E+00, 2.7021237188E+01, 3.8811113293E+00, 9.8194261099E-01],
	[4.6060000000E+04, 4.3522668561E+01, 5.0590009263E+00, 2.7030864619E+01, 3.8814034624E+00, 9.8195023662E-01],
	[4.6065000000E+04, 4.3531069830E+01, 5.0590463754E+00, 2.7040494434E+01, 3.8816955238E+00, 9.8195785859E-01],
	[4.6070000000E+04, 4.3539471808E+01, 5.0590918200E+00, 2.7050126632E+01, 3.8819875137E+00, 9.8196547689E-01],
	[4.6075000000E+04, 4.3547874496E+01, 5.0591372600E+00, 2.7059761215E+01, 3.8822794320E+00, 9.8197309153E-01],
	[4.6080000000E+04, 4.3556277894E+01, 5.0591826955E+00, 2.7069398183E+01, 3.8825712787E+00, 9.8198070250E-01],
	[4.6085000000E+04, 4.3564682001E+01, 5.0592281265E+00, 2.7079037536E+01, 3.8828630539E+00, 9.8198830981E-01],
	[4.6090000000E+04, 4.3573086817E+01, 5.0592735529E+00, 2.7088679274E+01, 3.8831547576E+00, 9.8199591346E-01],
	[4.6095000000E+04, 4.3581492344E+01, 5.0593189748E+00, 2.7098323397E+01, 3.8834463898E+00, 9.8200351346E-01],
	[4.6100000000E+04, 4.3589898579E+01, 5.0593643923E+00, 2.7107969907E+01, 3.8837379505E+00, 9.8201110980E-01],
	[4.6105000000E+04, 4.3598305525E+01, 5.0594098052E+00, 2.7117618803E+01, 3.8840294397E+00, 9.8201870249E-01],
	[4.6110000000E+04, 4.3606713179E+01, 5.0594552135E+00, 2.7127270085E+01, 3.8843208575E+00, 9.8202629152E-01],
	[4.6115000000E+04, 4.3615121543E+01, 5.0595006174E+00, 2.7136923755E+01, 3.8846122039E+00, 9.8203387691E-01],
	[4.6120000000E+04, 4.3623530617E+01, 5.0595460168E+00, 2.7146579811E+01, 3.8849034789E+00, 9.8204145865E-01],
	[4.6125000000E+04, 4.3631940400E+01, 5.0595914116E+00, 2.7156238256E+01, 3.8851946825E+00, 9.8204903674E-01],
	[4.6130000000E+04, 4.3640350892E+01, 5.0596368019E+00, 2.7165899088E+01, 3.8854858147E+00, 9.8205661119E-01],
	[4.6135000000E+04, 4.3648762094E+01, 5.0596821877E+00, 2.7175562308E+01, 3.8857768756E+00, 9.8206418200E-01],
	[4.6140000000E+04, 4.3657174005E+01, 5.0597275690E+00, 2.7185227918E+01, 3.8860678651E+00, 9.8207174916E-01],
	[4.6145000000E+04, 4.3665586626E+01, 5.0597729458E+00, 2.7194895916E+01, 3.8863587834E+00, 9.8207931269E-01],
	[4.6150000000E+04, 4.3673999956E+01, 5.0598183181E+00, 2.7204566303E+01, 3.8866496304E+00, 9.8208687258E-01],
	[4.6155000000E+04, 4.3682413995E+01, 5.0598636859E+00, 2.7214239080E+01, 3.8869404061E+00, 9.8209442884E-01],
	[4.6160000000E+04, 4.3690828743E+01, 5.0599090491E+00, 2.7223914247E+01, 3.8872311105E+00, 9.8210198147E-01],
	[4.6165000000E+04, 4.3699244201E+01, 5.0599544079E+00, 2.7233591804E+01, 3.8875217438E+00, 9.8210953046E-01],
	[4.6170000000E+04, 4.3707660368E+01, 5.0599997621E+00, 2.7243271752E+01, 3.8878123058E+00, 9.8211707583E-01],
	[4.6175000000E+04, 4.3716077244E+01, 5.0600451119E+00, 2.7252954091E+01, 3.8881027966E+00, 9.8212461757E-01],
	[4.6180000000E+04, 4.3724494829E+01, 5.0600904571E+00, 2.7262638821E+01, 3.8883932163E+00, 9.8213215568E-01],
	[4.6185000000E+04, 4.3732913124E+01, 5.0601357979E+00, 2.7272325942E+01, 3.8886835648E+00, 9.8213969018E-01],
	[4.6190000000E+04, 4.3741332128E+01, 5.0601811341E+00, 2.7282015456E+01, 3.8889738422E+00, 9.8214722105E-01],
	[4.6195000000E+04, 4.3749751841E+01, 5.0602264658E+00, 2.7291707362E+01, 3.8892640485E+00, 9.8215474830E-01],
	[4.6200000000E+04, 4.3758172263E+01, 5.0602717931E+00, 2.7301401660E+01, 3.8895541837E+00, 9.8216227193E-01],
	[4.6205000000E+04, 4.3766593395E+01, 5.0603171158E+00, 2.7311098351E+01, 3.8898442478E+00, 9.8216979195E-01],
	[4.6210000000E+04, 4.3775015235E+01, 5.0603624340E+00, 2.7320797436E+01, 3.8901342409E+00, 9.8217730836E-01],
	[4.6215000000E+04, 4.3783437785E+01, 5.0604077478E+00, 2.7330498914E+01, 3.8904241630E+00, 9.8218482115E-01],
	[4.6220000000E+04, 4.3791861043E+01, 5.0604530570E+00, 2.7340202786E+01, 3.8907140140E+00, 9.8219233034E-01],
	[4.6225000000E+04, 4.3800285011E+01, 5.0604983618E+00, 2.7349909052E+01, 3.8910037941E+00, 9.8219983591E-01],
	[4.6230000000E+04, 4.3808709688E+01, 5.0605436620E+00, 2.7359617713E+01, 3.8912935031E+00, 9.8220733788E-01],
	[4.6235000000E+04, 4.3817135074E+01, 5.0605889578E+00, 2.7369328769E+01, 3.8915831412E+00, 9.8221483625E-01],
	[4.6240000000E+04, 4.3825561169E+01, 5.0606342490E+00, 2.7379042219E+01, 3.8918727084E+00, 9.8222233101E-01],
	[4.6245000000E+04, 4.3833987973E+01, 5.0606795358E+00, 2.7388758066E+01, 3.8921622047E+00, 9.8222982218E-01],
	[4.6250000000E+04, 4.3842415486E+01, 5.0607248181E+00, 2.7398476308E+01, 3.8924516301E+00, 9.8223730974E-01],
	[4.6255000000E+04, 4.3850843708E+01, 5.0607700959E+00, 2.7408196947E+01, 3.8927409846E+00, 9.8224479371E-01],
	[4.6260000000E+04, 4.3859272638E+01, 5.0608153692E+00, 2.7417919982E+01, 3.8930302683E+00, 9.8225227409E-01],
	[4.6265000000E+04, 4.3867702278E+01, 5.0608606380E+00, 2.7427645414E+01, 3.8933194811E+00, 9.8225975087E-01],
	[4.6270000000E+04, 4.3876132627E+01, 5.0609059023E+00, 2.7437373244E+01, 3.8936086231E+00, 9.8226722406E-01],
	[4.6275000000E+04, 4.3884563685E+01, 5.0609511622E+00, 2.7447103471E+01, 3.8938976943E+00, 9.8227469366E-01],
	[4.6280000000E+04, 4.3892995451E+01, 5.0609964175E+00, 2.7456836095E+01, 3.8941866947E+00, 9.8228215967E-01],
	[4.6285000000E+04, 4.3901427926E+01, 5.0610416684E+00, 2.7466571118E+01, 3.8944756244E+00, 9.8228962210E-01],
	[4.6290000000E+04, 4.3909861111E+01, 5.0610869148E+00, 2.7476308540E+01, 3.8947644833E+00, 9.8229708095E-01],
	[4.6295000000E+04, 4.3918295004E+01, 5.0611321567E+00, 2.7486048360E+01, 3.8950532715E+00, 9.8230453621E-01],
	[4.6300000000E+04, 4.3926729606E+01, 5.0611773941E+00, 2.7495790580E+01, 3.8953419890E+00, 9.8231198790E-01],
	[4.6305000000E+04, 4.3935164916E+01, 5.0612226271E+00, 2.7505535199E+01, 3.8956306359E+00, 9.8231943601E-01],
	[4.6310000000E+04, 4.3943600936E+01, 5.0612678555E+00, 2.7515282218E+01, 3.8959192120E+00, 9.8232688054E-01],
	[4.6315000000E+04, 4.3952037664E+01, 5.0613130795E+00, 2.7525031637E+01, 3.8962077176E+00, 9.8233432150E-01],
	[4.6320000000E+04, 4.3960475101E+01, 5.0613582990E+00, 2.7534783457E+01, 3.8964961525E+00, 9.8234175888E-01],
	[4.6325000000E+04, 4.3968913247E+01, 5.0614035141E+00, 2.7544537678E+01, 3.8967845168E+00, 9.8234919270E-01],
	[4.6330000000E+04, 4.3977352101E+01, 5.0614487246E+00, 2.7554294300E+01, 3.8970728105E+00, 9.8235662294E-01],
	[4.6335000000E+04, 4.3985791665E+01, 5.0614939307E+00, 2.7564053323E+01, 3.8973610337E+00, 9.8236404963E-01],
	[4.6340000000E+04, 4.3994231936E+01, 5.0615391323E+00, 2.7573814748E+01, 3.8976491863E+00, 9.8237147274E-01],
	[4.6345000000E+04, 4.4002672917E+01, 5.0615843294E+00, 2.7583578576E+01, 3.8979372684E+00, 9.8237889229E-01],
	[4.6350000000E+04, 4.4011114606E+01, 5.0616295221E+00, 2.7593344806E+01, 3.8982252800E+00, 9.8238630829E-01],
	[4.6355000000E+04, 4.4019557004E+01, 5.0616747103E+00, 2.7603113439E+01, 3.8985132211E+00, 9.8239372072E-01],
	[4.6360000000E+04, 4.4028000110E+01, 5.0617198940E+00, 2.7612884475E+01, 3.8988010918E+00, 9.8240112960E-01],
	[4.6365000000E+04, 4.4036443926E+01, 5.0617650733E+00, 2.7622657914E+01, 3.8990888920E+00, 9.8240853492E-01],
	[4.6370000000E+04, 4.4044888449E+01, 5.0618102480E+00, 2.7632433758E+01, 3.8993766218E+00, 9.8241593669E-01],
	[4.6375000000E+04, 4.4053333681E+01, 5.0618554183E+00, 2.7642212005E+01, 3.8996642811E+00, 9.8242333490E-01],
	[4.6380000000E+04, 4.4061779622E+01, 5.0619005842E+00, 2.7651992658E+01, 3.8999518701E+00, 9.8243072957E-01],
	[4.6385000000E+04, 4.4070226271E+01, 5.0619457456E+00, 2.7661775714E+01, 3.9002393887E+00, 9.8243812069E-01],
	[4.6390000000E+04, 4.4078673629E+01, 5.0619909025E+00, 2.7671561177E+01, 3.9005268370E+00, 9.8244550826E-01],
	[4.6395000000E+04, 4.4087121696E+01, 5.0620360549E+00, 2.7681349044E+01, 3.9008142149E+00, 9.8245289229E-01],
	[4.6400000000E+04, 4.4095570470E+01, 5.0620812029E+00, 2.7691139318E+01, 3.9011015226E+00, 9.8246027278E-01],
	[4.6405000000E+04, 4.4104019954E+01, 5.0621263464E+00, 2.7700931998E+01, 3.9013887599E+00, 9.8246764973E-01],
	[4.6410000000E+04, 4.4112470145E+01, 5.0621714855E+00, 2.7710727084E+01, 3.9016759270E+00, 9.8247502314E-01],
	[4.6415000000E+04, 4.4120921045E+01, 5.0622166201E+00, 2.7720524577E+01, 3.9019630238E+00, 9.8248239301E-01],
	[4.6420000000E+04, 4.4129372654E+01, 5.0622617502E+00, 2.7730324477E+01, 3.9022500503E+00, 9.8248975935E-01],
	[4.6425000000E+04, 4.4137824971E+01, 5.0623068759E+00, 2.7740126785E+01, 3.9025370067E+00, 9.8249712215E-01],
	[4.6430000000E+04, 4.4146277996E+01, 5.0623519972E+00, 2.7749931500E+01, 3.9028238929E+00, 9.8250448143E-01],
	[4.6435000000E+04, 4.4154731730E+01, 5.0623971139E+00, 2.7759738624E+01, 3.9031107089E+00, 9.8251183717E-01],
	[4.6440000000E+04, 4.4163186172E+01, 5.0624422262E+00, 2.7769548156E+01, 3.9033974547E+00, 9.8251918939E-01],
	[4.6445000000E+04, 4.4171641322E+01, 5.0624873341E+00, 2.7779360097E+01, 3.9036841304E+00, 9.8252653809E-01],
	[4.6450000000E+04, 4.4180097181E+01, 5.0625324375E+00, 2.7789174447E+01, 3.9039707360E+00, 9.8253388326E-01],
	[4.6455000000E+04, 4.4188553748E+01, 5.0625775365E+00, 2.7798991207E+01, 3.9042572715E+00, 9.8254122490E-01],
	[4.6460000000E+04, 4.4197011023E+01, 5.0626226310E+00, 2.7808810377E+01, 3.9045437369E+00, 9.8254856303E-01],
	[4.6465000000E+04, 4.4205469007E+01, 5.0626677210E+00, 2.7818631956E+01, 3.9048301323E+00, 9.8255589764E-01],
	[4.6470000000E+04, 4.4213927699E+01, 5.0627128066E+00, 2.7828455946E+01, 3.9051164576E+00, 9.8256322874E-01],
	[4.6475000000E+04, 4.4222387099E+01, 5.0627578878E+00, 2.7838282347E+01, 3.9054027129E+00, 9.8257055632E-01],
	[4.6480000000E+04, 4.4230847207E+01, 5.0628029645E+00, 2.7848111159E+01, 3.9056888982E+00, 9.8257788039E-01],
	[4.6485000000E+04, 4.4239308023E+01, 5.0628480367E+00, 2.7857942383E+01, 3.9059750135E+00, 9.8258520094E-01],
	[4.6490000000E+04, 4.4247769548E+01, 5.0628931045E+00, 2.7867776019E+01, 3.9062610589E+00, 9.8259251799E-01],
	[4.6495000000E+04, 4.4256231781E+01, 5.0629381679E+00, 2.7877612066E+01, 3.9065470343E+00, 9.8259983153E-01],
	[4.6500000000E+04, 4.4264694722E+01, 5.0629832268E+00, 2.7887450526E+01, 3.9068329398E+00, 9.8260714157E-01],
	[4.6505000000E+04, 4.4273158371E+01, 5.0630282813E+00, 2.7897291399E+01, 3.9071187754E+00, 9.8261444811E-01],
	[4.6510000000E+04, 4.4281622728E+01, 5.0630733313E+00, 2.7907134685E+01, 3.9074045411E+00, 9.8262175114E-01],
	[4.6515000000E+04, 4.4290087793E+01, 5.0631183769E+00, 2.7916980384E+01, 3.9076902370E+00, 9.8262905068E-01],
	[4.6520000000E+04, 4.4298553566E+01, 5.0631634180E+00, 2.7926828498E+01, 3.9079758630E+00, 9.8263634671E-01],
	[4.6525000000E+04, 4.4307020048E+01, 5.0632084548E+00, 2.7936679025E+01, 3.9082614191E+00, 9.8264363925E-01],
	[4.6530000000E+04, 4.4315487237E+01, 5.0632534870E+00, 2.7946531967E+01, 3.9085469055E+00, 9.8265092830E-01],
	[4.6535000000E+04, 4.4323955135E+01, 5.0632985149E+00, 2.7956387324E+01, 3.9088323221E+00, 9.8265821386E-01],
	[4.6540000000E+04, 4.4332423740E+01, 5.0633435382E+00, 2.7966245096E+01, 3.9091176689E+00, 9.8266549592E-01],
	[4.6545000000E+04, 4.4340893054E+01, 5.0633885572E+00, 2.7976105283E+01, 3.9094029460E+00, 9.8267277450E-01],
	[4.6550000000E+04, 4.4349363075E+01, 5.0634335717E+00, 2.7985967886E+01, 3.9096881533E+00, 9.8268004959E-01],
	[4.6555000000E+04, 4.4357833805E+01, 5.0634785818E+00, 2.7995832905E+01, 3.9099732909E+00, 9.8268732120E-01],
	[4.6560000000E+04, 4.4366305242E+01, 5.0635235875E+00, 2.8005700341E+01, 3.9102583589E+00, 9.8269458933E-01],
	[4.6565000000E+04, 4.4374777387E+01, 5.0635685887E+00, 2.8015570193E+01, 3.9105433571E+00, 9.8270185397E-01],
	[4.6570000000E+04, 4.4383250240E+01, 5.0636135855E+00, 2.8025442463E+01, 3.9108282857E+00, 9.8270911513E-01],
	[4.6575000000E+04, 4.4391723801E+01, 5.0636585778E+00, 2.8035317150E+01, 3.9111131447E+00, 9.8271637282E-01],
	[4.6580000000E+04, 4.4400198070E+01, 5.0637035657E+00, 2.8045194255E+01, 3.9113979341E+00, 9.8272362704E-01],
	[4.6585000000E+04, 4.4408673047E+01, 5.0637485492E+00, 2.8055073778E+01, 3.9116826538E+00, 9.8273087778E-01],
	[4.6590000000E+04, 4.4417148732E+01, 5.0637935283E+00, 2.8064955719E+01, 3.9119673040E+00, 9.8273812504E-01],
	[4.6595000000E+04, 4.4425625124E+01, 5.0638385029E+00, 2.8074840080E+01, 3.9122518847E+00, 9.8274536884E-01],
	[4.6600000000E+04, 4.4434102225E+01, 5.0638834732E+00, 2.8084726859E+01, 3.9125363958E+00, 9.8275260917E-01],
	[4.6605000000E+04, 4.4442580033E+01, 5.0639284389E+00, 2.8094616058E+01, 3.9128208374E+00, 9.8275984604E-01],
	[4.6610000000E+04, 4.4451058548E+01, 5.0639734003E+00, 2.8104507676E+01, 3.9131052095E+00, 9.8276707944E-01],
	[4.6615000000E+04, 4.4459537772E+01, 5.0640183573E+00, 2.8114401715E+01, 3.9133895121E+00, 9.8277430938E-01],
	[4.6620000000E+04, 4.4468017703E+01, 5.0640633098E+00, 2.8124298174E+01, 3.9136737452E+00, 9.8278153585E-01],
	[4.6625000000E+04, 4.4476498342E+01, 5.0641082579E+00, 2.8134197054E+01, 3.9139579089E+00, 9.8278875887E-01],
	[4.6630000000E+04, 4.4484979689E+01, 5.0641532015E+00, 2.8144098355E+01, 3.9142420032E+00, 9.8279597844E-01],
	[4.6635000000E+04, 4.4493461744E+01, 5.0641981408E+00, 2.8154002078E+01, 3.9145260281E+00, 9.8280319454E-01],
	[4.6640000000E+04, 4.4501944506E+01, 5.0642430756E+00, 2.8163908222E+01, 3.9148099836E+00, 9.8281040720E-01],
	[4.6645000000E+04, 4.4510427976E+01, 5.0642880060E+00, 2.8173816788E+01, 3.9150938698E+00, 9.8281761640E-01],
	[4.6650000000E+04, 4.4518912153E+01, 5.0643329320E+00, 2.8183727777E+01, 3.9153776866E+00, 9.8282482216E-01],
	[4.6655000000E+04, 4.4527397038E+01, 5.0643778536E+00, 2.8193641189E+01, 3.9156614341E+00, 9.8283202446E-01],
	[4.6660000000E+04, 4.4535882631E+01, 5.0644227708E+00, 2.8203557023E+01, 3.9159451122E+00, 9.8283922332E-01],
	[4.6665000000E+04, 4.4544368931E+01, 5.0644676835E+00, 2.8213475281E+01, 3.9162287211E+00, 9.8284641874E-01],
	[4.6670000000E+04, 4.4552855939E+01, 5.0645125919E+00, 2.8223395963E+01, 3.9165122607E+00, 9.8285361072E-01],
	[4.6675000000E+04, 4.4561343654E+01, 5.0645574958E+00, 2.8233319069E+01, 3.9167957311E+00, 9.8286079925E-01],
	[4.6680000000E+04, 4.4569832077E+01, 5.0646023953E+00, 2.8243244600E+01, 3.9170791323E+00, 9.8286798435E-01],
	[4.6685000000E+04, 4.4578321207E+01, 5.0646472904E+00, 2.8253172555E+01, 3.9173624642E+00, 9.8287516601E-01],
	[4.6690000000E+04, 4.4586811045E+01, 5.0646921811E+00, 2.8263102935E+01, 3.9176457269E+00, 9.8288234423E-01],
	[4.6695000000E+04, 4.4595301591E+01, 5.0647370674E+00, 2.8273035741E+01, 3.9179289205E+00, 9.8288951903E-01],
	[4.6700000000E+04, 4.4603792844E+01, 5.0647819493E+00, 2.8282970972E+01, 3.9182120449E+00, 9.8289669039E-01],
	[4.6705000000E+04, 4.4612284804E+01, 5.0648268267E+00, 2.8292908630E+01, 3.9184951002E+00, 9.8290385832E-01],
	[4.6710000000E+04, 4.4620777472E+01, 5.0648716998E+00, 2.8302848714E+01, 3.9187780864E+00, 9.8291102282E-01],
	[4.6715000000E+04, 4.4629270847E+01, 5.0649165685E+00, 2.8312791224E+01, 3.9190610035E+00, 9.8291818390E-01],
	[4.6720000000E+04, 4.4637764930E+01, 5.0649614327E+00, 2.8322736162E+01, 3.9193438515E+00, 9.8292534156E-01],
	[4.6725000000E+04, 4.4646259720E+01, 5.0650062926E+00, 2.8332683528E+01, 3.9196266304E+00, 9.8293249579E-01],
	[4.6730000000E+04, 4.4654755217E+01, 5.0650511480E+00, 2.8342633321E+01, 3.9199093404E+00, 9.8293964661E-01],
	[4.6735000000E+04, 4.4663251422E+01, 5.0650959991E+00, 2.8352585542E+01, 3.9201919813E+00, 9.8294679400E-01],
	[4.6740000000E+04, 4.4671748334E+01, 5.0651408457E+00, 2.8362540191E+01, 3.9204745532E+00, 9.8295393798E-01],
	[4.6745000000E+04, 4.4680245953E+01, 5.0651856879E+00, 2.8372497269E+01, 3.9207570561E+00, 9.8296107855E-01],
	[4.6750000000E+04, 4.4688744280E+01, 5.0652305258E+00, 2.8382456777E+01, 3.9210394900E+00, 9.8296821570E-01],
	[4.6755000000E+04, 4.4697243314E+01, 5.0652753592E+00, 2.8392418714E+01, 3.9213218551E+00, 9.8297534944E-01],
	[4.6760000000E+04, 4.4705743055E+01, 5.0653201883E+00, 2.8402383080E+01, 3.9216041512E+00, 9.8298247977E-01],
	[4.6765000000E+04, 4.4714243504E+01, 5.0653650129E+00, 2.8412349877E+01, 3.9218863784E+00, 9.8298960670E-01],
	[4.6770000000E+04, 4.4722744659E+01, 5.0654098332E+00, 2.8422319104E+01, 3.9221685367E+00, 9.8299673022E-01],
	[4.6775000000E+04, 4.4731255764E+01, 5.0654556013E+00, 2.8432290761E+01, 3.9224512682E+00, 9.8300385033E-01],
	[4.6780000000E+04, 4.4739774582E+01, 5.0655020867E+00, 2.8442264850E+01, 3.9227344176E+00, 9.8301096705E-01],
	[4.6785000000E+04, 4.4748294112E+01, 5.0655485675E+00, 2.8452241370E+01, 3.9230174983E+00, 9.8301808036E-01],
	[4.6790000000E+04, 4.4756814354E+01, 5.0655950437E+00, 2.8462220322E+01, 3.9233005103E+00, 9.8302519028E-01],
	[4.6795000000E+04, 4.4765335307E+01, 5.0656415154E+00, 2.8472201707E+01, 3.9235834537E+00, 9.8303229680E-01],
	[4.6800000000E+04, 4.4773856972E+01, 5.0656879826E+00, 2.8482185523E+01, 3.9238663285E+00, 9.8303939992E-01],
	[4.6805000000E+04, 4.4782379349E+01, 5.0657344452E+00, 2.8492171772E+01, 3.9241491346E+00, 9.8304649966E-01],
	[4.6810000000E+04, 4.4790902437E+01, 5.0657809033E+00, 2.8502160454E+01, 3.9244318722E+00, 9.8305359600E-01],
	[4.6815000000E+04, 4.4799426236E+01, 5.0658273569E+00, 2.8512151570E+01, 3.9247145412E+00, 9.8306068895E-01],
	[4.6820000000E+04, 4.4807950747E+01, 5.0658738059E+00, 2.8522145120E+01, 3.9249971416E+00, 9.8306777852E-01],
	[4.6825000000E+04, 4.4816475970E+01, 5.0659202504E+00, 2.8532141103E+01, 3.9252796735E+00, 9.8307486470E-01],
	[4.6830000000E+04, 4.4825001904E+01, 5.0659666904E+00, 2.8542139521E+01, 3.9255621369E+00, 9.8308194749E-01],
	[4.6835000000E+04, 4.4833528549E+01, 5.0660131258E+00, 2.8552140374E+01, 3.9258445317E+00, 9.8308902691E-01],
	[4.6840000000E+04, 4.4842055906E+01, 5.0660595567E+00, 2.8562143661E+01, 3.9261268582E+00, 9.8309610294E-01],
	[4.6845000000E+04, 4.4850583975E+01, 5.0661059831E+00, 2.8572149384E+01, 3.9264091161E+00, 9.8310317560E-01],
	[4.6850000000E+04, 4.4859112755E+01, 5.0661524049E+00, 2.8582157543E+01, 3.9266913056E+00, 9.8311024488E-01],
	[4.6855000000E+04, 4.4867642246E+01, 5.0661988222E+00, 2.8592168138E+01, 3.9269734267E+00, 9.8311731079E-01],
	[4.6860000000E+04, 4.4876172448E+01, 5.0662452350E+00, 2.8602181170E+01, 3.9272554794E+00, 9.8312437332E-01],
	[4.6865000000E+04, 4.4884703362E+01, 5.0662916433E+00, 2.8612196638E+01, 3.9275374637E+00, 9.8313143248E-01],
	[4.6870000000E+04, 4.4893234988E+01, 5.0663380470E+00, 2.8622214543E+01, 3.9278193796E+00, 9.8313848827E-01],
	[4.6875000000E+04, 4.4901767324E+01, 5.0663844462E+00, 2.8632234885E+01, 3.9281012272E+00, 9.8314554070E-01],
	[4.6880000000E+04, 4.4910300372E+01, 5.0664308409E+00, 2.8642257665E+01, 3.9283830065E+00, 9.8315258976E-01],
	[4.6885000000E+04, 4.4918834132E+01, 5.0664772310E+00, 2.8652282884E+01, 3.9286647174E+00, 9.8315963546E-01],
	[4.6890000000E+04, 4.4927368602E+01, 5.0665236167E+00, 2.8662310540E+01, 3.9289463601E+00, 9.8316667779E-01],
	[4.6895000000E+04, 4.4935903784E+01, 5.0665699978E+00, 2.8672340636E+01, 3.9292279345E+00, 9.8317371677E-01],
	[4.6900000000E+04, 4.4944439677E+01, 5.0666163744E+00, 2.8682373170E+01, 3.9295094407E+00, 9.8318075238E-01],
	[4.6905000000E+04, 4.4952976281E+01, 5.0666627464E+00, 2.8692408144E+01, 3.9297908786E+00, 9.8318778465E-01],
	[4.6910000000E+04, 4.4961513597E+01, 5.0667091140E+00, 2.8702445558E+01, 3.9300722483E+00, 9.8319481355E-01],
	[4.6915000000E+04, 4.4970051623E+01, 5.0667554770E+00, 2.8712485411E+01, 3.9303535498E+00, 9.8320183910E-01],
	[4.6920000000E+04, 4.4978590361E+01, 5.0668018355E+00, 2.8722527705E+01, 3.9306347832E+00, 9.8320886131E-01],
	[4.6925000000E+04, 4.4987129810E+01, 5.0668481896E+00, 2.8732572440E+01, 3.9309159484E+00, 9.8321588016E-01],
	[4.6930000000E+04, 4.4995669971E+01, 5.0668945390E+00, 2.8742619616E+01, 3.9311970454E+00, 9.8322289566E-01],
	[4.6935000000E+04, 4.5004210842E+01, 5.0669408840E+00, 2.8752669233E+01, 3.9314780744E+00, 9.8322990782E-01],
	[4.6940000000E+04, 4.5012752424E+01, 5.0669872245E+00, 2.8762721292E+01, 3.9317590352E+00, 9.8323691664E-01],
	[4.6945000000E+04, 4.5021294718E+01, 5.0670335604E+00, 2.8772775793E+01, 3.9320399280E+00, 9.8324392212E-01],
	[4.6950000000E+04, 4.5029837723E+01, 5.0670798919E+00, 2.8782832736E+01, 3.9323207527E+00, 9.8325092425E-01],
	[4.6955000000E+04, 4.5038381438E+01, 5.0671262188E+00, 2.8792892122E+01, 3.9326015093E+00, 9.8325792304E-01],
	[4.6960000000E+04, 4.5046925865E+01, 5.0671725412E+00, 2.8802953952E+01, 3.9328821980E+00, 9.8326491850E-01],
	[4.6965000000E+04, 4.5055471003E+01, 5.0672188591E+00, 2.8813018224E+01, 3.9331628186E+00, 9.8327191063E-01],
	[4.6970000000E+04, 4.5064016852E+01, 5.0672651725E+00, 2.8823084940E+01, 3.9334433712E+00, 9.8327889942E-01],
	[4.6975000000E+04, 4.5072563411E+01, 5.0673114814E+00, 2.8833154101E+01, 3.9337238559E+00, 9.8328588488E-01],
	[4.6980000000E+04, 4.5081110682E+01, 5.0673577858E+00, 2.8843225705E+01, 3.9340042727E+00, 9.8329286701E-01],
	[4.6985000000E+04, 4.5089658664E+01, 5.0674040857E+00, 2.8853299755E+01, 3.9342846215E+00, 9.8329984581E-01],
	[4.6990000000E+04, 4.5098207357E+01, 5.0674503811E+00, 2.8863376249E+01, 3.9345649024E+00, 9.8330682129E-01],
	[4.6995000000E+04, 4.5106756760E+01, 5.0674966720E+00, 2.8873455189E+01, 3.9348451154E+00, 9.8331379344E-01],
	[4.7000000000E+04, 4.5115306875E+01, 5.0675429583E+00, 2.8883536574E+01, 3.9351252605E+00, 9.8332076227E-01],
	[4.7005000000E+04, 4.5123857700E+01, 5.0675892402E+00, 2.8893620406E+01, 3.9354053378E+00, 9.8332772779E-01],
	[4.7010000000E+04, 4.5132409237E+01, 5.0676355176E+00, 2.8903706684E+01, 3.9356853472E+00, 9.8333468998E-01],
	[4.7015000000E+04, 4.5140961484E+01, 5.0676817905E+00, 2.8913795409E+01, 3.9359652889E+00, 9.8334164885E-01],
	[4.7020000000E+04, 4.5149514442E+01, 5.0677280588E+00, 2.8923886580E+01, 3.9362451627E+00, 9.8334860441E-01],
	[4.7025000000E+04, 4.5158068111E+01, 5.0677743227E+00, 2.8933980199E+01, 3.9365249688E+00, 9.8335555666E-01],
	[4.7030000000E+04, 4.5166622491E+01, 5.0678205821E+00, 2.8944076266E+01, 3.9368047071E+00, 9.8336250559E-01],
	[4.7035000000E+04, 4.5175177581E+01, 5.0678668370E+00, 2.8954174781E+01, 3.9370843776E+00, 9.8336945122E-01],
	[4.7040000000E+04, 4.5183733382E+01, 5.0679130874E+00, 2.8964275744E+01, 3.9373639805E+00, 9.8337639354E-01],
	[4.7045000000E+04, 4.5192289894E+01, 5.0679593333E+00, 2.8974379156E+01, 3.9376435156E+00, 9.8338333255E-01],
	[4.7050000000E+04, 4.5200847117E+01, 5.0680055747E+00, 2.8984485017E+01, 3.9379229831E+00, 9.8339026826E-01],
	[4.7055000000E+04, 4.5209405051E+01, 5.0680518116E+00, 2.8994593327E+01, 3.9382023829E+00, 9.8339720066E-01],
	[4.7060000000E+04, 4.5217963695E+01, 5.0680980440E+00, 2.9004704087E+01, 3.9384817150E+00, 9.8340412977E-01],
	[4.7065000000E+04, 4.5226523050E+01, 5.0681442720E+00, 2.9014817298E+01, 3.9387609795E+00, 9.8341105557E-01],
	[4.7070000000E+04, 4.5235083116E+01, 5.0681904954E+00, 2.9024932958E+01, 3.9390401764E+00, 9.8341797808E-01],
	[4.7075000000E+04, 4.5243643892E+01, 5.0682367144E+00, 2.9035051069E+01, 3.9393193058E+00, 9.8342489729E-01],
	[4.7080000000E+04, 4.5252205379E+01, 5.0682829288E+00, 2.9045171631E+01, 3.9395983675E+00, 9.8343181321E-01],
	[4.7085000000E+04, 4.5260767577E+01, 5.0683291388E+00, 2.9055294645E+01, 3.9398773617E+00, 9.8343872584E-01],
	[4.7090000000E+04, 4.5269330485E+01, 5.0683753443E+00, 2.9065420110E+01, 3.9401562884E+00, 9.8344563517E-01],
	[4.7095000000E+04, 4.5277894104E+01, 5.0684215453E+00, 2.9075548028E+01, 3.9404351476E+00, 9.8345254122E-01],
	[4.7100000000E+04, 4.5286458433E+01, 5.0684677419E+00, 2.9085678397E+01, 3.9407139392E+00, 9.8345944399E-01],
	[4.7105000000E+04, 4.5295023473E+01, 5.0685139339E+00, 2.9095811220E+01, 3.9409926634E+00, 9.8346634346E-01],
	[4.7110000000E+04, 4.5303589224E+01, 5.0685601215E+00, 2.9105946495E+01, 3.9412713202E+00, 9.8347323966E-01],
	[4.7115000000E+04, 4.5312155685E+01, 5.0686063045E+00, 2.9116084224E+01, 3.9415499095E+00, 9.8348013257E-01],
	[4.7120000000E+04, 4.5320722857E+01, 5.0686524831E+00, 2.9126224407E+01, 3.9418284313E+00, 9.8348702221E-01],
	[4.7125000000E+04, 4.5329290739E+01, 5.0686986573E+00, 2.9136367043E+01, 3.9421068858E+00, 9.8349390856E-01],
	[4.7130000000E+04, 4.5337859332E+01, 5.0687448269E+00, 2.9146512134E+01, 3.9423852729E+00, 9.8350079164E-01],
	[4.7135000000E+04, 4.5346428635E+01, 5.0687909921E+00, 2.9156659680E+01, 3.9426635926E+00, 9.8350767145E-01],
	[4.7140000000E+04, 4.5354998648E+01, 5.0688371528E+00, 2.9166809680E+01, 3.9429418450E+00, 9.8351454798E-01],
	[4.7145000000E+04, 4.5363569372E+01, 5.0688833090E+00, 2.9176962137E+01, 3.9432200301E+00, 9.8352142125E-01],
	[4.7150000000E+04, 4.5372140807E+01, 5.0689294607E+00, 2.9187117048E+01, 3.9434981478E+00, 9.8352829124E-01],
	[4.7155000000E+04, 4.5380712952E+01, 5.0689756080E+00, 2.9197274416E+01, 3.9437761983E+00, 9.8353515797E-01],
	[4.7160000000E+04, 4.5389285807E+01, 5.0690217508E+00, 2.9207434240E+01, 3.9440541815E+00, 9.8354202143E-01],
	[4.7165000000E+04, 4.5397859372E+01, 5.0690678891E+00, 2.9217596521E+01, 3.9443320975E+00, 9.8354888163E-01],
	[4.7170000000E+04, 4.5406433648E+01, 5.0691140230E+00, 2.9227761259E+01, 3.9446099462E+00, 9.8355573857E-01],
	[4.7175000000E+04, 4.5415008635E+01, 5.0691601523E+00, 2.9237928454E+01, 3.9448877277E+00, 9.8356259225E-01],
	[4.7180000000E+04, 4.5423584331E+01, 5.0692062773E+00, 2.9248098107E+01, 3.9451654420E+00, 9.8356944267E-01],
	[4.7185000000E+04, 4.5432160738E+01, 5.0692523977E+00, 2.9258270218E+01, 3.9454430891E+00, 9.8357628983E-01],
	[4.7190000000E+04, 4.5440737855E+01, 5.0692985137E+00, 2.9268444788E+01, 3.9457206691E+00, 9.8358313374E-01],
	[4.7195000000E+04, 4.5449315683E+01, 5.0693446252E+00, 2.9278621816E+01, 3.9459981819E+00, 9.8358997440E-01],
	[4.7200000000E+04, 4.5457894221E+01, 5.0693907322E+00, 2.9288801303E+01, 3.9462756277E+00, 9.8359681180E-01],
	[4.7205000000E+04, 4.5466473469E+01, 5.0694368348E+00, 2.9298983249E+01, 3.9465530063E+00, 9.8360364596E-01],
	[4.7210000000E+04, 4.5475053427E+01, 5.0694829329E+00, 2.9309167656E+01, 3.9468303178E+00, 9.8361047687E-01],
	[4.7215000000E+04, 4.5483634095E+01, 5.0695290266E+00, 2.9319354522E+01, 3.9471075623E+00, 9.8361730453E-01],
	[4.7220000000E+04, 4.5492215474E+01, 5.0695751158E+00, 2.9329543848E+01, 3.9473847397E+00, 9.8362412895E-01],
	[4.7225000000E+04, 4.5500797563E+01, 5.0696212005E+00, 2.9339735636E+01, 3.9476618501E+00, 9.8363095013E-01],
	[4.7230000000E+04, 4.5509380362E+01, 5.0696672808E+00, 2.9349929884E+01, 3.9479388935E+00, 9.8363776806E-01],
	[4.7235000000E+04, 4.5517963871E+01, 5.0697133566E+00, 2.9360126594E+01, 3.9482158700E+00, 9.8364458276E-01],
	[4.7240000000E+04, 4.5526548090E+01, 5.0697594279E+00, 2.9370325765E+01, 3.9484927794E+00, 9.8365139422E-01],
	[4.7245000000E+04, 4.5535133020E+01, 5.0698054948E+00, 2.9380527399E+01, 3.9487696219E+00, 9.8365820245E-01],
	[4.7250000000E+04, 4.5543718659E+01, 5.0698515573E+00, 2.9390731494E+01, 3.9490463975E+00, 9.8366500744E-01],
	[4.7255000000E+04, 4.5552305009E+01, 5.0698976153E+00, 2.9400938053E+01, 3.9493231061E+00, 9.8367180920E-01],
	[4.7260000000E+04, 4.5560892068E+01, 5.0699436688E+00, 2.9411147074E+01, 3.9495997479E+00, 9.8367860773E-01],
	[4.7265000000E+04, 4.5569479838E+01, 5.0699897179E+00, 2.9421358559E+01, 3.9498763227E+00, 9.8368540303E-01],
	[4.7270000000E+04, 4.5578068317E+01, 5.0700357625E+00, 2.9431572508E+01, 3.9501528308E+00, 9.8369219511E-01],
	[4.7275000000E+04, 4.5586657507E+01, 5.0700818026E+00, 2.9441788921E+01, 3.9504292719E+00, 9.8369898396E-01],
	[4.7280000000E+04, 4.5595247407E+01, 5.0701278384E+00, 2.9452007798E+01, 3.9507056463E+00, 9.8370576959E-01],
	[4.7285000000E+04, 4.5603838016E+01, 5.0701738696E+00, 2.9462229139E+01, 3.9509819539E+00, 9.8371255199E-01],
	[4.7290000000E+04, 4.5612429336E+01, 5.0702198964E+00, 2.9472452946E+01, 3.9512581946E+00, 9.8371933118E-01],
	[4.7295000000E+04, 4.5621021366E+01, 5.0702659188E+00, 2.9482679218E+01, 3.9515343687E+00, 9.8372610715E-01],
	[4.7300000000E+04, 4.5629614105E+01, 5.0703119367E+00, 2.9492907956E+01, 3.9518104759E+00, 9.8373287991E-01],
	[4.7305000000E+04, 4.5638207554E+01, 5.0703579502E+00, 2.9503139160E+01, 3.9520865165E+00, 9.8373964945E-01],
	[4.7310000000E+04, 4.5646801714E+01, 5.0704039592E+00, 2.9513372830E+01, 3.9523624903E+00, 9.8374641577E-01],
	[4.7315000000E+04, 4.5655396583E+01, 5.0704499638E+00, 2.9523608967E+01, 3.9526383974E+00, 9.8375317889E-01],
	[4.7320000000E+04, 4.5663992162E+01, 5.0704959640E+00, 2.9533847571E+01, 3.9529142379E+00, 9.8375993880E-01],
	[4.7325000000E+04, 4.5672588451E+01, 5.0705419597E+00, 2.9544088642E+01, 3.9531900117E+00, 9.8376669550E-01],
	[4.7330000000E+04, 4.5681185450E+01, 5.0705879509E+00, 2.9554332181E+01, 3.9534657189E+00, 9.8377344900E-01],
	[4.7335000000E+04, 4.5689783158E+01, 5.0706339377E+00, 2.9564578188E+01, 3.9537413595E+00, 9.8378019929E-01],
	[4.7340000000E+04, 4.5698381577E+01, 5.0706799201E+00, 2.9574826664E+01, 3.9540169335E+00, 9.8378694638E-01],
	[4.7345000000E+04, 4.5706980705E+01, 5.0707258981E+00, 2.9585077608E+01, 3.9542924409E+00, 9.8379369027E-01],
	[4.7350000000E+04, 4.5715580543E+01, 5.0707718716E+00, 2.9595331021E+01, 3.9545678817E+00, 9.8380043096E-01],
	[4.7355000000E+04, 4.5724181090E+01, 5.0708178406E+00, 2.9605586904E+01, 3.9548432561E+00, 9.8380716846E-01],
	[4.7360000000E+04, 4.5732782348E+01, 5.0708638052E+00, 2.9615845256E+01, 3.9551185638E+00, 9.8381390276E-01],
	[4.7365000000E+04, 4.5741384315E+01, 5.0709097654E+00, 2.9626106078E+01, 3.9553938051E+00, 9.8382063386E-01],
	[4.7370000000E+04, 4.5749986992E+01, 5.0709557212E+00, 2.9636369371E+01, 3.9556689799E+00, 9.8382736178E-01],
	[4.7375000000E+04, 4.5758590378E+01, 5.0710016725E+00, 2.9646635134E+01, 3.9559440882E+00, 9.8383408651E-01],
	[4.7380000000E+04, 4.5767194474E+01, 5.0710476194E+00, 2.9656903369E+01, 3.9562191301E+00, 9.8384080804E-01],
	[4.7385000000E+04, 4.5775799280E+01, 5.0710935618E+00, 2.9667174075E+01, 3.9564941056E+00, 9.8384752640E-01],
	[4.7390000000E+04, 4.5784404795E+01, 5.0711394998E+00, 2.9677447252E+01, 3.9567690146E+00, 9.8385424156E-01],
	[4.7395000000E+04, 4.5793011021E+01, 5.0711854334E+00, 2.9687722902E+01, 3.9570438573E+00, 9.8386095355E-01],
	[4.7400000000E+04, 4.5801617955E+01, 5.0712313626E+00, 2.9698001023E+01, 3.9573186336E+00, 9.8386766235E-01],
	[4.7405000000E+04, 4.5810225599E+01, 5.0712772873E+00, 2.9708281618E+01, 3.9575933435E+00, 9.8387436798E-01],
	[4.7410000000E+04, 4.5818833953E+01, 5.0713232076E+00, 2.9718564686E+01, 3.9578679871E+00, 9.8388107042E-01],
	[4.7415000000E+04, 4.5827443017E+01, 5.0713691235E+00, 2.9728850227E+01, 3.9581425644E+00, 9.8388776969E-01],
	[4.7420000000E+04, 4.5836052790E+01, 5.0714150350E+00, 2.9739138241E+01, 3.9584170753E+00, 9.8389446579E-01],
	[4.7425000000E+04, 4.5844663272E+01, 5.0714609420E+00, 2.9749428730E+01, 3.9586915200E+00, 9.8390115872E-01],
	[4.7430000000E+04, 4.5853274464E+01, 5.0715068446E+00, 2.9759721693E+01, 3.9589658985E+00, 9.8390784847E-01],
	[4.7435000000E+04, 4.5861886365E+01, 5.0715527428E+00, 2.9770017131E+01, 3.9592402107E+00, 9.8391453506E-01],
	[4.7440000000E+04, 4.5870498976E+01, 5.0715986365E+00, 2.9780315044E+01, 3.9595144566E+00, 9.8392121847E-01],
	[4.7445000000E+04, 4.5879112297E+01, 5.0716445259E+00, 2.9790615432E+01, 3.9597886364E+00, 9.8392789873E-01],
	[4.7450000000E+04, 4.5887726326E+01, 5.0716904108E+00, 2.9800918296E+01, 3.9600627500E+00, 9.8393457582E-01],
	[4.7455000000E+04, 4.5896341066E+01, 5.0717362913E+00, 2.9811223636E+01, 3.9603367974E+00, 9.8394124974E-01],
	[4.7460000000E+04, 4.5904956514E+01, 5.0717821673E+00, 2.9821531453E+01, 3.9606107787E+00, 9.8394792051E-01],
	[4.7465000000E+04, 4.5913572672E+01, 5.0718280390E+00, 2.9831841746E+01, 3.9608846938E+00, 9.8395458812E-01],
	[4.7470000000E+04, 4.5922189540E+01, 5.0718739062E+00, 2.9842154516E+01, 3.9611585428E+00, 9.8396125257E-01],
	[4.7475000000E+04, 4.5930807116E+01, 5.0719197691E+00, 2.9852469764E+01, 3.9614323257E+00, 9.8396791387E-01],
	[4.7480000000E+04, 4.5939425403E+01, 5.0719656275E+00, 2.9862787489E+01, 3.9617060426E+00, 9.8397457201E-01],
	[4.7485000000E+04, 4.5948044398E+01, 5.0720114815E+00, 2.9873107692E+01, 3.9619796934E+00, 9.8398122701E-01],
	[4.7490000000E+04, 4.5956664103E+01, 5.0720573310E+00, 2.9883430374E+01, 3.9622532781E+00, 9.8398787885E-01],
	[4.7495000000E+04, 4.5965284517E+01, 5.0721031762E+00, 2.9893755534E+01, 3.9625267969E+00, 9.8399452754E-01],
	[4.7500000000E+04, 4.5973905640E+01, 5.0721490170E+00, 2.9904083174E+01, 3.9628002496E+00, 9.8400117309E-01],
	[4.7505000000E+04, 4.5982527473E+01, 5.0721948533E+00, 2.9914413292E+01, 3.9630736363E+00, 9.8400781549E-01],
	[4.7510000000E+04, 4.5991150014E+01, 5.0722406853E+00, 2.9924745891E+01, 3.9633469571E+00, 9.8401445475E-01],
	[4.7515000000E+04, 4.5999773265E+01, 5.0722865128E+00, 2.9935080969E+01, 3.9636202119E+00, 9.8402109087E-01],
	[4.7520000000E+04, 4.6008397226E+01, 5.0723323359E+00, 2.9945418528E+01, 3.9638934009E+00, 9.8402772385E-01],
	[4.7525000000E+04, 4.6017021895E+01, 5.0723781546E+00, 2.9955758568E+01, 3.9641665239E+00, 9.8403435369E-01],
	[4.7530000000E+04, 4.6025663103E+01, 5.0724255664E+00, 2.9966101089E+01, 3.9644406742E+00, 9.8404098040E-01],
	[4.7535000000E+04, 4.6034305426E+01, 5.0724730141E+00, 2.9976446091E+01, 3.9647147865E+00, 9.8404760397E-01],
	[4.7540000000E+04, 4.6042948463E+01, 5.0725204573E+00, 2.9986793575E+01, 3.9649888331E+00, 9.8405422441E-01],
	[4.7545000000E+04, 4.6051592213E+01, 5.0725678959E+00, 2.9997143541E+01, 3.9652628140E+00, 9.8406084172E-01],
	[4.7550000000E+04, 4.6060236677E+01, 5.0726153300E+00, 3.0007495989E+01, 3.9655367293E+00, 9.8406745589E-01],
	[4.7555000000E+04, 4.6068881854E+01, 5.0726627595E+00, 3.0017850920E+01, 3.9658105788E+00, 9.8407406695E-01],
	[4.7560000000E+04, 4.6077527744E+01, 5.0727101845E+00, 3.0028208334E+01, 3.9660843627E+00, 9.8408067487E-01],
	[4.7565000000E+04, 4.6086174348E+01, 5.0727576050E+00, 3.0038568231E+01, 3.9663580809E+00, 9.8408727967E-01],
	[4.7570000000E+04, 4.6094821666E+01, 5.0728050209E+00, 3.0048930612E+01, 3.9666317336E+00, 9.8409388135E-01],
	[4.7575000000E+04, 4.6103469696E+01, 5.0728524323E+00, 3.0059295478E+01, 3.9669053206E+00, 9.8410047991E-01],
	[4.7580000000E+04, 4.6112118441E+01, 5.0728998391E+00, 3.0069662827E+01, 3.9671788421E+00, 9.8410707535E-01],
	[4.7585000000E+04, 4.6120767898E+01, 5.0729472414E+00, 3.0080032661E+01, 3.9674522980E+00, 9.8411366767E-01],
	[4.7590000000E+04, 4.6129418069E+01, 5.0729946392E+00, 3.0090404981E+01, 3.9677256883E+00, 9.8412025688E-01],
	[4.7595000000E+04, 4.6138068953E+01, 5.0730420324E+00, 3.0100779786E+01, 3.9679990132E+00, 9.8412684297E-01],
	[4.7600000000E+04, 4.6146720551E+01, 5.0730894211E+00, 3.0111157076E+01, 3.9682722725E+00, 9.8413342595E-01],
	[4.7605000000E+04, 4.6155372862E+01, 5.0731368052E+00, 3.0121536853E+01, 3.9685454663E+00, 9.8414000582E-01],
	[4.7610000000E+04, 4.6164025886E+01, 5.0731841849E+00, 3.0131919116E+01, 3.9688185947E+00, 9.8414658258E-01],
	[4.7615000000E+04, 4.6172679624E+01, 5.0732315599E+00, 3.0142303865E+01, 3.9690916576E+00, 9.8415315623E-01],
	[4.7620000000E+04, 4.6181334075E+01, 5.0732789305E+00, 3.0152691102E+01, 3.9693646551E+00, 9.8415972678E-01],
	[4.7625000000E+04, 4.6189989239E+01, 5.0733262965E+00, 3.0163080826E+01, 3.9696375872E+00, 9.8416629422E-01],
	[4.7630000000E+04, 4.6198645116E+01, 5.0733736580E+00, 3.0173473038E+01, 3.9699104539E+00, 9.8417285855E-01],
	[4.7635000000E+04, 4.6207301707E+01, 5.0734210150E+00, 3.0183867738E+01, 3.9701832552E+00, 9.8417941979E-01],
	[4.7640000000E+04, 4.6215959011E+01, 5.0734683674E+00, 3.0194264926E+01, 3.9704559911E+00, 9.8418597792E-01],
	[4.7645000000E+04, 4.6224617027E+01, 5.0735157153E+00, 3.0204664603E+01, 3.9707286617E+00, 9.8419253296E-01],
	[4.7650000000E+04, 4.6233275758E+01, 5.0735630587E+00, 3.0215066769E+01, 3.9710012670E+00, 9.8419908490E-01],
	[4.7655000000E+04, 4.6241935201E+01, 5.0736103975E+00, 3.0225471425E+01, 3.9712738070E+00, 9.8420563374E-01],
	[4.7660000000E+04, 4.6250595357E+01, 5.0736577319E+00, 3.0235878570E+01, 3.9715462817E+00, 9.8421217949E-01],
	[4.7665000000E+04, 4.6259256227E+01, 5.0737050617E+00, 3.0246288205E+01, 3.9718186911E+00, 9.8421872214E-01],
	[4.7670000000E+04, 4.6267917809E+01, 5.0737523870E+00, 3.0256700331E+01, 3.9720910353E+00, 9.8422526170E-01],
	[4.7675000000E+04, 4.6276580105E+01, 5.0737997077E+00, 3.0267114947E+01, 3.9723633143E+00, 9.8423179818E-01],
	[4.7680000000E+04, 4.6285243114E+01, 5.0738470240E+00, 3.0277532055E+01, 3.9726355280E+00, 9.8423833156E-01],
	[4.7685000000E+04, 4.6293906836E+01, 5.0738943357E+00, 3.0287951654E+01, 3.9729076765E+00, 9.8424486186E-01],
	[4.7690000000E+04, 4.6302571271E+01, 5.0739416429E+00, 3.0298373744E+01, 3.9731797599E+00, 9.8425138907E-01],
	[4.7695000000E+04, 4.6311236419E+01, 5.0739889455E+00, 3.0308798327E+01, 3.9734517781E+00, 9.8425791320E-01],
	[4.7700000000E+04, 4.6319902280E+01, 5.0740362437E+00, 3.0319225402E+01, 3.9737237312E+00, 9.8426443425E-01],
	[4.7705000000E+04, 4.6328568854E+01, 5.0740835374E+00, 3.0329654970E+01, 3.9739956191E+00, 9.8427095221E-01],
	[4.7710000000E+04, 4.6337236141E+01, 5.0741308265E+00, 3.0340087031E+01, 3.9742674420E+00, 9.8427746710E-01],
	[4.7715000000E+04, 4.6345904141E+01, 5.0741781111E+00, 3.0350521586E+01, 3.9745391997E+00, 9.8428397891E-01],
	[4.7720000000E+04, 4.6354572853E+01, 5.0742253912E+00, 3.0360958634E+01, 3.9748108924E+00, 9.8429048764E-01],
	[4.7725000000E+04, 4.6363242279E+01, 5.0742726668E+00, 3.0371398176E+01, 3.9750825200E+00, 9.8429699330E-01],
	[4.7730000000E+04, 4.6371912418E+01, 5.0743199379E+00, 3.0381840212E+01, 3.9753540827E+00, 9.8430349589E-01],
	[4.7735000000E+04, 4.6380583269E+01, 5.0743672044E+00, 3.0392284744E+01, 3.9756255803E+00, 9.8430999540E-01],
	[4.7740000000E+04, 4.6389254834E+01, 5.0744144665E+00, 3.0402731770E+01, 3.9758970129E+00, 9.8431649184E-01],
	[4.7745000000E+04, 4.6397927111E+01, 5.0744617240E+00, 3.0413181292E+01, 3.9761683805E+00, 9.8432298522E-01],
	[4.7750000000E+04, 4.6406600102E+01, 5.0745089770E+00, 3.0423633310E+01, 3.9764396832E+00, 9.8432947552E-01],
	[4.7755000000E+04, 4.6415273805E+01, 5.0745562256E+00, 3.0434087823E+01, 3.9767109209E+00, 9.8433596277E-01],
	[4.7760000000E+04, 4.6423948220E+01, 5.0746034696E+00, 3.0444544833E+01, 3.9769820937E+00, 9.8434244694E-01],
	[4.7765000000E+04, 4.6432623349E+01, 5.0746507091E+00, 3.0455004340E+01, 3.9772532017E+00, 9.8434892806E-01],
	[4.7770000000E+04, 4.6441299191E+01, 5.0746979441E+00, 3.0465466344E+01, 3.9775242447E+00, 9.8435540611E-01],
	[4.7775000000E+04, 4.6449975745E+01, 5.0747451746E+00, 3.0475930846E+01, 3.9777952228E+00, 9.8436188110E-01],
	[4.7780000000E+04, 4.6458653012E+01, 5.0747924006E+00, 3.0486397845E+01, 3.9780661362E+00, 9.8436835304E-01],
	[4.7785000000E+04, 4.6467330992E+01, 5.0748396221E+00, 3.0496867342E+01, 3.9783369847E+00, 9.8437482192E-01],
	[4.7790000000E+04, 4.6476009684E+01, 5.0748868391E+00, 3.0507339337E+01, 3.9786077683E+00, 9.8438128774E-01],
	[4.7795000000E+04, 4.6484689089E+01, 5.0749340516E+00, 3.0517813832E+01, 3.9788784872E+00, 9.8438775051E-01],
	[4.7800000000E+04, 4.6493369207E+01, 5.0749812596E+00, 3.0528290825E+01, 3.9791491413E+00, 9.8439421023E-01],
	[4.7805000000E+04, 4.6502050037E+01, 5.0750284631E+00, 3.0538770318E+01, 3.9794197307E+00, 9.8440066690E-01],
	[4.7810000000E+04, 4.6510731581E+01, 5.0750756621E+00, 3.0549252311E+01, 3.9796902553E+00, 9.8440712052E-01],
	[4.7815000000E+04, 4.6519413836E+01, 5.0751228566E+00, 3.0559736804E+01, 3.9799607152E+00, 9.8441357109E-01],
	[4.7820000000E+04, 4.6528096805E+01, 5.0751700466E+00, 3.0570223797E+01, 3.9802311104E+00, 9.8442001862E-01],
	[4.7825000000E+04, 4.6536780486E+01, 5.0752172321E+00, 3.0580713291E+01, 3.9805014409E+00, 9.8442646310E-01],
	[4.7830000000E+04, 4.6545464880E+01, 5.0752644131E+00, 3.0591205286E+01, 3.9807717067E+00, 9.8443290454E-01],
	[4.7835000000E+04, 4.6554149986E+01, 5.0753115897E+00, 3.0601699782E+01, 3.9810419079E+00, 9.8443934293E-01],
	[4.7840000000E+04, 4.6562835805E+01, 5.0753587617E+00, 3.0612196781E+01, 3.9813120445E+00, 9.8444577829E-01],
	[4.7845000000E+04, 4.6571522336E+01, 5.0754059292E+00, 3.0622696281E+01, 3.9815821164E+00, 9.8445221061E-01],
	[4.7850000000E+04, 4.6580209580E+01, 5.0754530923E+00, 3.0633198284E+01, 3.9818521238E+00, 9.8445863989E-01],
	[4.7855000000E+04, 4.6588897536E+01, 5.0755002509E+00, 3.0643702789E+01, 3.9821220666E+00, 9.8446506614E-01],
	[4.7860000000E+04, 4.6597586205E+01, 5.0755474049E+00, 3.0654209798E+01, 3.9823919448E+00, 9.8447148935E-01],
	[4.7865000000E+04, 4.6606275587E+01, 5.0755945545E+00, 3.0664719310E+01, 3.9826617585E+00, 9.8447790953E-01],
	[4.7870000000E+04, 4.6614965680E+01, 5.0756416996E+00, 3.0675231326E+01, 3.9829315077E+00, 9.8448432668E-01],
	[4.7875000000E+04, 4.6623656487E+01, 5.0756888402E+00, 3.0685745846E+01, 3.9832011923E+00, 9.8449074079E-01],
	[4.7880000000E+04, 4.6632348005E+01, 5.0757359763E+00, 3.0696262871E+01, 3.9834708125E+00, 9.8449715189E-01],
	[4.7885000000E+04, 4.6641040237E+01, 5.0757831080E+00, 3.0706782400E+01, 3.9837403682E+00, 9.8450355995E-01],
	[4.7890000000E+04, 4.6649733180E+01, 5.0758302351E+00, 3.0717304434E+01, 3.9840098595E+00, 9.8450996499E-01],
	[4.7895000000E+04, 4.6658426836E+01, 5.0758773578E+00, 3.0727828974E+01, 3.9842792863E+00, 9.8451636701E-01],
	[4.7900000000E+04, 4.6667121204E+01, 5.0759244760E+00, 3.0738356020E+01, 3.9845486487E+00, 9.8452276600E-01],
	[4.7905000000E+04, 4.6675816285E+01, 5.0759715897E+00, 3.0748885571E+01, 3.9848179468E+00, 9.8452916197E-01],
	[4.7910000000E+04, 4.6684512078E+01, 5.0760186989E+00, 3.0759417629E+01, 3.9850871804E+00, 9.8453555493E-01],
	[4.7915000000E+04, 4.6693208583E+01, 5.0760658037E+00, 3.0769952194E+01, 3.9853563497E+00, 9.8454194487E-01],
	[4.7920000000E+04, 4.6701905801E+01, 5.0761129040E+00, 3.0780489266E+01, 3.9856254547E+00, 9.8454833179E-01],
	[4.7925000000E+04, 4.6710603731E+01, 5.0761599998E+00, 3.0791028846E+01, 3.9858944953E+00, 9.8455471570E-01],
	[4.7930000000E+04, 4.6719302373E+01, 5.0762070911E+00, 3.0801570933E+01, 3.9861634717E+00, 9.8456109659E-01],
	[4.7935000000E+04, 4.6728001728E+01, 5.0762541779E+00, 3.0812115529E+01, 3.9864323837E+00, 9.8456747447E-01],
	[4.7940000000E+04, 4.6736701794E+01, 5.0763012603E+00, 3.0822662633E+01, 3.9867012315E+00, 9.8457384935E-01],
	[4.7945000000E+04, 4.6745402573E+01, 5.0763483382E+00, 3.0833212245E+01, 3.9869700150E+00, 9.8458022121E-01],
	[4.7950000000E+04, 4.6754104064E+01, 5.0763954116E+00, 3.0843764367E+01, 3.9872387343E+00, 9.8458659007E-01],
	[4.7955000000E+04, 4.6762806268E+01, 5.0764424806E+00, 3.0854318998E+01, 3.9875073894E+00, 9.8459295592E-01],
	[4.7960000000E+04, 4.6771509183E+01, 5.0764895451E+00, 3.0864876139E+01, 3.9877759803E+00, 9.8459931877E-01],
	[4.7965000000E+04, 4.6780212811E+01, 5.0765366051E+00, 3.0875435791E+01, 3.9880445070E+00, 9.8460567862E-01],
	[4.7970000000E+04, 4.6788917151E+01, 5.0765836606E+00, 3.0885997952E+01, 3.9883129696E+00, 9.8461203546E-01],
	[4.7975000000E+04, 4.6797622203E+01, 5.0766307117E+00, 3.0896562625E+01, 3.9885813680E+00, 9.8461838931E-01],
	[4.7980000000E+04, 4.6806327967E+01, 5.0766777583E+00, 3.0907129808E+01, 3.9888497023E+00, 9.8462474016E-01],
	[4.7985000000E+04, 4.6815034443E+01, 5.0767248004E+00, 3.0917699503E+01, 3.9891179725E+00, 9.8463108801E-01],
	[4.7990000000E+04, 4.6823741631E+01, 5.0767718381E+00, 3.0928271710E+01, 3.9893861786E+00, 9.8463743287E-01],
	[4.7995000000E+04, 4.6832449532E+01, 5.0768188713E+00, 3.0938846429E+01, 3.9896543206E+00, 9.8464377473E-01],
	[4.8000000000E+04, 4.6841158144E+01, 5.0768659001E+00, 3.0949423661E+01, 3.9899223986E+00, 9.8465011360E-01],
	[4.8005000000E+04, 4.6849867468E+01, 5.0769129243E+00, 3.0960003405E+01, 3.9901904126E+00, 9.8465644948E-01],
	[4.8010000000E+04, 4.6858577505E+01, 5.0769599442E+00, 3.0970585663E+01, 3.9904583625E+00, 9.8466278237E-01],
	[4.8015000000E+04, 4.6867288253E+01, 5.0770069595E+00, 3.0981170434E+01, 3.9907262484E+00, 9.8466911228E-01],
	[4.8020000000E+04, 4.6875999714E+01, 5.0770539704E+00, 3.0991757719E+01, 3.9909940704E+00, 9.8467543920E-01],
	[4.8025000000E+04, 4.6884711886E+01, 5.0771009769E+00, 3.1002347517E+01, 3.9912618284E+00, 9.8468176313E-01],
	[4.8030000000E+04, 4.6893424770E+01, 5.0771479788E+00, 3.1012939831E+01, 3.9915295225E+00, 9.8468808409E-01],
	[4.8035000000E+04, 4.6902138367E+01, 5.0771949764E+00, 3.1023534659E+01, 3.9917971526E+00, 9.8469440206E-01],
	[4.8040000000E+04, 4.6910852675E+01, 5.0772419694E+00, 3.1034132002E+01, 3.9920647188E+00, 9.8470071705E-01],
	[4.8045000000E+04, 4.6919567695E+01, 5.0772889580E+00, 3.1044731861E+01, 3.9923322212E+00, 9.8470702906E-01],
	[4.8050000000E+04, 4.6928283427E+01, 5.0773359422E+00, 3.1055334236E+01, 3.9925996597E+00, 9.8471333809E-01],
	[4.8055000000E+04, 4.6936999871E+01, 5.0773829219E+00, 3.1065939127E+01, 3.9928670343E+00, 9.8471964415E-01],
	[4.8060000000E+04, 4.6945717027E+01, 5.0774298972E+00, 3.1076546534E+01, 3.9931343451E+00, 9.8472594724E-01],
	[4.8065000000E+04, 4.6954434894E+01, 5.0774768680E+00, 3.1087156459E+01, 3.9934015920E+00, 9.8473224735E-01],
	[4.8070000000E+04, 4.6963153474E+01, 5.0775238343E+00, 3.1097768900E+01, 3.9936687752E+00, 9.8473854449E-01],
	[4.8075000000E+04, 4.6971872765E+01, 5.0775707962E+00, 3.1108383859E+01, 3.9939358946E+00, 9.8474483867E-01],
	[4.8080000000E+04, 4.6980592768E+01, 5.0776177536E+00, 3.1119001335E+01, 3.9942029502E+00, 9.8475112987E-01],
	[4.8085000000E+04, 4.6989313483E+01, 5.0776647066E+00, 3.1129621330E+01, 3.9944699421E+00, 9.8475741811E-01],
	[4.8090000000E+04, 4.6998034909E+01, 5.0777116552E+00, 3.1140243844E+01, 3.9947368703E+00, 9.8476370338E-01],
	[4.8095000000E+04, 4.7006757048E+01, 5.0777585993E+00, 3.1150868876E+01, 3.9950037347E+00, 9.8476998569E-01],
	[4.8100000000E+04, 4.7015479898E+01, 5.0778055389E+00, 3.1161496427E+01, 3.9952705355E+00, 9.8477626504E-01],
	[4.8105000000E+04, 4.7024203459E+01, 5.0778524741E+00, 3.1172126498E+01, 3.9955372725E+00, 9.8478254143E-01],
	[4.8110000000E+04, 4.7032927733E+01, 5.0778994049E+00, 3.1182759089E+01, 3.9958039460E+00, 9.8478881486E-01],
	[4.8115000000E+04, 4.7041652718E+01, 5.0779463312E+00, 3.1193394200E+01, 3.9960705558E+00, 9.8479508533E-01],
	[4.8120000000E+04, 4.7050378415E+01, 5.0779932531E+00, 3.1204031831E+01, 3.9963371019E+00, 9.8480135284E-01],
	[4.8125000000E+04, 4.7059104823E+01, 5.0780401705E+00, 3.1214671983E+01, 3.9966035845E+00, 9.8480761740E-01],
	[4.8130000000E+04, 4.7067831943E+01, 5.0780870835E+00, 3.1225314657E+01, 3.9968700035E+00, 9.8481387901E-01],
	[4.8135000000E+04, 4.7076559775E+01, 5.0781339921E+00, 3.1235959852E+01, 3.9971363589E+00, 9.8482013767E-01],
	[4.8140000000E+04, 4.7085288319E+01, 5.0781808962E+00, 3.1246607569E+01, 3.9974026508E+00, 9.8482639337E-01],
	[4.8145000000E+04, 4.7094017574E+01, 5.0782277959E+00, 3.1257257808E+01, 3.9976688792E+00, 9.8483264613E-01],
	[4.8150000000E+04, 4.7102747540E+01, 5.0782746911E+00, 3.1267910569E+01, 3.9979350440E+00, 9.8483889594E-01],
	[4.8155000000E+04, 4.7111478218E+01, 5.0783215819E+00, 3.1278565854E+01, 3.9982011454E+00, 9.8484514280E-01],
	[4.8160000000E+04, 4.7120209608E+01, 5.0783684683E+00, 3.1289223661E+01, 3.9984671832E+00, 9.8485138672E-01],
	[4.8165000000E+04, 4.7128941709E+01, 5.0784153502E+00, 3.1299883992E+01, 3.9987331576E+00, 9.8485762770E-01],
	[4.8170000000E+04, 4.7137674521E+01, 5.0784622277E+00, 3.1310546847E+01, 3.9989990686E+00, 9.8486386574E-01],
	[4.8175000000E+04, 4.7146408046E+01, 5.0785091008E+00, 3.1321212227E+01, 3.9992649162E+00, 9.8487010084E-01],
	[4.8180000000E+04, 4.7155142281E+01, 5.0785559694E+00, 3.1331880130E+01, 3.9995307003E+00, 9.8487633299E-01],
	[4.8185000000E+04, 4.7163877228E+01, 5.0786028336E+00, 3.1342550559E+01, 3.9997964211E+00, 9.8488256222E-01],
	[4.8190000000E+04, 4.7172612887E+01, 5.0786496934E+00, 3.1353223513E+01, 4.0000620785E+00, 9.8488878850E-01],
	[4.8195000000E+04, 4.7181349257E+01, 5.0786965488E+00, 3.1363898992E+01, 4.0003276725E+00, 9.8489501186E-01],
	[4.8200000000E+04, 4.7190086338E+01, 5.0787433997E+00, 3.1374576997E+01, 4.0005932032E+00, 9.8490123228E-01],
	[4.8205000000E+04, 4.7198824131E+01, 5.0787902462E+00, 3.1385257529E+01, 4.0008586706E+00, 9.8490744977E-01],
	[4.8210000000E+04, 4.7207562635E+01, 5.0788370882E+00, 3.1395940587E+01, 4.0011240747E+00, 9.8491366433E-01],
	[4.8215000000E+04, 4.7216301851E+01, 5.0788839259E+00, 3.1406626172E+01, 4.0013894155E+00, 9.8491987596E-01],
	[4.8220000000E+04, 4.7225041778E+01, 5.0789307591E+00, 3.1417314284E+01, 4.0016546931E+00, 9.8492608467E-01],
	[4.8225000000E+04, 4.7233782416E+01, 5.0789775879E+00, 3.1428004923E+01, 4.0019199074E+00, 9.8493229045E-01],
	[4.8230000000E+04, 4.7242523765E+01, 5.0790244122E+00, 3.1438698091E+01, 4.0021850585E+00, 9.8493849331E-01],
	[4.8235000000E+04, 4.7251265826E+01, 5.0790712322E+00, 3.1449393787E+01, 4.0024501464E+00, 9.8494469324E-01],
	[4.8240000000E+04, 4.7260008598E+01, 5.0791180477E+00, 3.1460092011E+01, 4.0027151711E+00, 9.8495089026E-01],
	[4.8245000000E+04, 4.7268752082E+01, 5.0791648588E+00, 3.1470792764E+01, 4.0029801326E+00, 9.8495708436E-01],
	[4.8250000000E+04, 4.7277496276E+01, 5.0792116655E+00, 3.1481496047E+01, 4.0032450310E+00, 9.8496327554E-01],
	[4.8255000000E+04, 4.7286241182E+01, 5.0792584677E+00, 3.1492201859E+01, 4.0035098662E+00, 9.8496946380E-01],
	[4.8260000000E+04, 4.7294986799E+01, 5.0793052656E+00, 3.1502910200E+01, 4.0037746384E+00, 9.8497564915E-01],
	[4.8265000000E+04, 4.7303733128E+01, 5.0793520590E+00, 3.1513621073E+01, 4.0040393474E+00, 9.8498183159E-01],
	[4.8270000000E+04, 4.7312480167E+01, 5.0793988480E+00, 3.1524334475E+01, 4.0043039933E+00, 9.8498801111E-01],
	[4.8275000000E+04, 4.7321227918E+01, 5.0794456326E+00, 3.1535050409E+01, 4.0045685762E+00, 9.8499418773E-01],
	[4.8280000000E+04, 4.7329976380E+01, 5.0794924128E+00, 3.1545768874E+01, 4.0048330960E+00, 9.8500036143E-01],
	[4.8285000000E+04, 4.7338725553E+01, 5.0795391885E+00, 3.1556489870E+01, 4.0050975528E+00, 9.8500653223E-01],
	[4.8290000000E+04, 4.7347475437E+01, 5.0795859599E+00, 3.1567213398E+01, 4.0053619466E+00, 9.8501270013E-01],
	[4.8295000000E+04, 4.7356241554E+01, 5.0796342612E+00, 3.1577939459E+01, 4.0056273426E+00, 9.8501886512E-01],
	[4.8300000000E+04, 4.7365009079E+01, 5.0796826263E+00, 3.1588668052E+01, 4.0058927231E+00, 9.8502502720E-01],
	[4.8305000000E+04, 4.7373777318E+01, 5.0797309869E+00, 3.1599399178E+01, 4.0061580409E+00, 9.8503118639E-01],
	[4.8310000000E+04, 4.7382546274E+01, 5.0797793429E+00, 3.1610132838E+01, 4.0064232958E+00, 9.8503734268E-01],
	[4.8315000000E+04, 4.7391315945E+01, 5.0798276944E+00, 3.1620869030E+01, 4.0066884879E+00, 9.8504349607E-01],
	[4.8320000000E+04, 4.7400086331E+01, 5.0798760414E+00, 3.1631607757E+01, 4.0069536172E+00, 9.8504964656E-01],
	[4.8325000000E+04, 4.7408857432E+01, 5.0799243838E+00, 3.1642349018E+01, 4.0072186838E+00, 9.8505579415E-01],
	[4.8330000000E+04, 4.7417629249E+01, 5.0799727217E+00, 3.1653092814E+01, 4.0074836876E+00, 9.8506193886E-01],
	[4.8335000000E+04, 4.7426401781E+01, 5.0800210550E+00, 3.1663839145E+01, 4.0077486287E+00, 9.8506808067E-01],
	[4.8340000000E+04, 4.7435175028E+01, 5.0800693838E+00, 3.1674588010E+01, 4.0080135070E+00, 9.8507421959E-01],
	[4.8345000000E+04, 4.7443948991E+01, 5.0801177081E+00, 3.1685339412E+01, 4.0082783227E+00, 9.8508035562E-01],
	[4.8350000000E+04, 4.7452723669E+01, 5.0801660278E+00, 3.1696093349E+01, 4.0085430757E+00, 9.8508648876E-01],
	[4.8355000000E+04, 4.7461499062E+01, 5.0802143430E+00, 3.1706849823E+01, 4.0088077660E+00, 9.8509261901E-01],
	[4.8360000000E+04, 4.7470275170E+01, 5.0802626536E+00, 3.1717608833E+01, 4.0090723936E+00, 9.8509874638E-01],
	[4.8365000000E+04, 4.7479051994E+01, 5.0803109598E+00, 3.1728370381E+01, 4.0093369587E+00, 9.8510487087E-01],
	[4.8370000000E+04, 4.7487829533E+01, 5.0803592613E+00, 3.1739134465E+01, 4.0096014611E+00, 9.8511099248E-01],
	[4.8375000000E+04, 4.7496607787E+01, 5.0804075584E+00, 3.1749901087E+01, 4.0098659009E+00, 9.8511711120E-01],
	[4.8380000000E+04, 4.7505386756E+01, 5.0804558509E+00, 3.1760670247E+01, 4.0101302782E+00, 9.8512322705E-01],
	[4.8385000000E+04, 4.7514166440E+01, 5.0805041389E+00, 3.1771441946E+01, 4.0103945929E+00, 9.8512934002E-01],
	[4.8390000000E+04, 4.7522946840E+01, 5.0805524223E+00, 3.1782216183E+01, 4.0106588451E+00, 9.8513545011E-01],
	[4.8395000000E+04, 4.7531727954E+01, 5.0806007012E+00, 3.1792992958E+01, 4.0109230347E+00, 9.8514155733E-01],
	[4.8400000000E+04, 4.7540509784E+01, 5.0806489756E+00, 3.1803772274E+01, 4.0111871619E+00, 9.8514766167E-01],
	[4.8405000000E+04, 4.7549292328E+01, 5.0806972455E+00, 3.1814554128E+01, 4.0114512265E+00, 9.8515376314E-01],
	[4.8410000000E+04, 4.7558075588E+01, 5.0807455108E+00, 3.1825338523E+01, 4.0117152287E+00, 9.8515986174E-01],
	[4.8415000000E+04, 4.7566859563E+01, 5.0807937716E+00, 3.1836125458E+01, 4.0119791684E+00, 9.8516595748E-01],
	[4.8420000000E+04, 4.7575644253E+01, 5.0808420279E+00, 3.1846914934E+01, 4.0122430457E+00, 9.8517205034E-01],
	[4.8425000000E+04, 4.7584429658E+01, 5.0808902797E+00, 3.1857706951E+01, 4.0125068606E+00, 9.8517814035E-01],
	[4.8430000000E+04, 4.7593215778E+01, 5.0809385269E+00, 3.1868501509E+01, 4.0127706131E+00, 9.8518422748E-01],
	[4.8435000000E+04, 4.7602002613E+01, 5.0809867696E+00, 3.1879298608E+01, 4.0130343032E+00, 9.8519031175E-01],
	[4.8440000000E+04, 4.7610790163E+01, 5.0810350078E+00, 3.1890098250E+01, 4.0132979309E+00, 9.8519639317E-01],
	[4.8445000000E+04, 4.7619578428E+01, 5.0810832415E+00, 3.1900900434E+01, 4.0135614963E+00, 9.8520247172E-01],
	[4.8450000000E+04, 4.7628367407E+01, 5.0811314706E+00, 3.1911705161E+01, 4.0138249994E+00, 9.8520854741E-01],
	[4.8455000000E+04, 4.7637157102E+01, 5.0811796952E+00, 3.1922512430E+01, 4.0140884401E+00, 9.8521462025E-01],
	[4.8460000000E+04, 4.7645947512E+01, 5.0812279153E+00, 3.1933322243E+01, 4.0143518186E+00, 9.8522069023E-01],
	[4.8465000000E+04, 4.7654738636E+01, 5.0812761309E+00, 3.1944134600E+01, 4.0146151347E+00, 9.8522675736E-01],
	[4.8470000000E+04, 4.7663530476E+01, 5.0813243420E+00, 3.1954949500E+01, 4.0148783887E+00, 9.8523282163E-01],
	[4.8475000000E+04, 4.7672323030E+01, 5.0813725486E+00, 3.1965766945E+01, 4.0151415804E+00, 9.8523888305E-01],
	[4.8480000000E+04, 4.7681116299E+01, 5.0814207506E+00, 3.1976586934E+01, 4.0154047098E+00, 9.8524494163E-01],
	[4.8485000000E+04, 4.7689910283E+01, 5.0814689482E+00, 3.1987409469E+01, 4.0156677771E+00, 9.8525099735E-01],
	[4.8490000000E+04, 4.7698704982E+01, 5.0815171412E+00, 3.1998234549E+01, 4.0159307821E+00, 9.8525705023E-01],
	[4.8495000000E+04, 4.7707500396E+01, 5.0815653297E+00, 3.2009062174E+01, 4.0161937250E+00, 9.8526310026E-01],
	[4.8500000000E+04, 4.7716296524E+01, 5.0816135137E+00, 3.2019892346E+01, 4.0164566058E+00, 9.8526914745E-01],
	[4.8505000000E+04, 4.7725093367E+01, 5.0816616932E+00, 3.2030725064E+01, 4.0167194244E+00, 9.8527519180E-01],
	[4.8510000000E+04, 4.7733890925E+01, 5.0817098681E+00, 3.2041560328E+01, 4.0169821809E+00, 9.8528123330E-01],
	[4.8515000000E+04, 4.7742689198E+01, 5.0817580386E+00, 3.2052398140E+01, 4.0172448753E+00, 9.8528727197E-01],
	[4.8520000000E+04, 4.7751488185E+01, 5.0818062046E+00, 3.2063238498E+01, 4.0175075076E+00, 9.8529330780E-01],
	[4.8525000000E+04, 4.7760287888E+01, 5.0818543660E+00, 3.2074081405E+01, 4.0177700778E+00, 9.8529934079E-01],
	[4.8530000000E+04, 4.7769088304E+01, 5.0819025230E+00, 3.2084926860E+01, 4.0180325860E+00, 9.8530537095E-01],
	[4.8535000000E+04, 4.7777889436E+01, 5.0819506754E+00, 3.2095774862E+01, 4.0182950322E+00, 9.8531139827E-01],
	[4.8540000000E+04, 4.7786691282E+01, 5.0819988233E+00, 3.2106625414E+01, 4.0185574163E+00, 9.8531742276E-01],
	[4.8545000000E+04, 4.7795493843E+01, 5.0820469668E+00, 3.2117478515E+01, 4.0188197385E+00, 9.8532344442E-01],
	[4.8550000000E+04, 4.7804297118E+01, 5.0820951057E+00, 3.2128334165E+01, 4.0190819987E+00, 9.8532946325E-01],
	[4.8555000000E+04, 4.7813101109E+01, 5.0821432401E+00, 3.2139192364E+01, 4.0193441969E+00, 9.8533547925E-01],
	[4.8560000000E+04, 4.7821905813E+01, 5.0821913701E+00, 3.2150053114E+01, 4.0196063332E+00, 9.8534149243E-01],
	[4.8565000000E+04, 4.7830711233E+01, 5.0822394955E+00, 3.2160916414E+01, 4.0198684075E+00, 9.8534750278E-01],
	[4.8570000000E+04, 4.7839517366E+01, 5.0822876164E+00, 3.2171782265E+01, 4.0201304200E+00, 9.8535351031E-01],
	[4.8575000000E+04, 4.7848324215E+01, 5.0823357329E+00, 3.2182650667E+01, 4.0203923705E+00, 9.8535951502E-01],
	[4.8580000000E+04, 4.7857131778E+01, 5.0823838448E+00, 3.2193521620E+01, 4.0206542592E+00, 9.8536551690E-01],
	[4.8585000000E+04, 4.7865940055E+01, 5.0824319522E+00, 3.2204395125E+01, 4.0209160861E+00, 9.8537151597E-01],
	[4.8590000000E+04, 4.7874749047E+01, 5.0824800552E+00, 3.2215271182E+01, 4.0211778510E+00, 9.8537751222E-01],
	[4.8595000000E+04, 4.7883558754E+01, 5.0825281536E+00, 3.2226149791E+01, 4.0214395542E+00, 9.8538350565E-01],
	[4.8600000000E+04, 4.7892369175E+01, 5.0825762476E+00, 3.2237030953E+01, 4.0217011956E+00, 9.8538949627E-01],
	[4.8605000000E+04, 4.7901180310E+01, 5.0826243371E+00, 3.2247914669E+01, 4.0219627752E+00, 9.8539548407E-01],
	[4.8610000000E+04, 4.7909992160E+01, 5.0826724220E+00, 3.2258800937E+01, 4.0222242930E+00, 9.8540146907E-01],
	[4.8615000000E+04, 4.7918804724E+01, 5.0827205025E+00, 3.2269689759E+01, 4.0224857491E+00, 9.8540745125E-01],
	[4.8620000000E+04, 4.7927618003E+01, 5.0827685785E+00, 3.2280581136E+01, 4.0227471434E+00, 9.8541343062E-01],
	[4.8625000000E+04, 4.7936431996E+01, 5.0828166500E+00, 3.2291475066E+01, 4.0230084760E+00, 9.8541940719E-01],
	[4.8630000000E+04, 4.7945246704E+01, 5.0828647170E+00, 3.2302371552E+01, 4.0232697469E+00, 9.8542538095E-01],
	[4.8635000000E+04, 4.7954062126E+01, 5.0829127795E+00, 3.2313270592E+01, 4.0235309562E+00, 9.8543135190E-01],
	[4.8640000000E+04, 4.7962878262E+01, 5.0829608376E+00, 3.2324172188E+01, 4.0237921038E+00, 9.8543732006E-01],
	[4.8645000000E+04, 4.7971695113E+01, 5.0830088911E+00, 3.2335076340E+01, 4.0240531897E+00, 9.8544328541E-01],
	[4.8650000000E+04, 4.7980512677E+01, 5.0830569402E+00, 3.2345983048E+01, 4.0243142140E+00, 9.8544924796E-01],
	[4.8655000000E+04, 4.7989330957E+01, 5.0831049848E+00, 3.2356892312E+01, 4.0245751767E+00, 9.8545520771E-01],
	[4.8660000000E+04, 4.7998149950E+01, 5.0831530249E+00, 3.2367804133E+01, 4.0248360778E+00, 9.8546116467E-01],
	[4.8665000000E+04, 4.8006969658E+01, 5.0832010605E+00, 3.2378718511E+01, 4.0250969173E+00, 9.8546711882E-01],
	[4.8670000000E+04, 4.8015790080E+01, 5.0832490917E+00, 3.2389635446E+01, 4.0253576953E+00, 9.8547307019E-01],
	[4.8675000000E+04, 4.8024611216E+01, 5.0832971183E+00, 3.2400554940E+01, 4.0256184117E+00, 9.8547901876E-01],
	[4.8680000000E+04, 4.8033433067E+01, 5.0833451405E+00, 3.2411476991E+01, 4.0258790666E+00, 9.8548496454E-01],
	[4.8685000000E+04, 4.8042255632E+01, 5.0833931582E+00, 3.2422401601E+01, 4.0261396601E+00, 9.8549090753E-01],
	[4.8690000000E+04, 4.8051078910E+01, 5.0834411714E+00, 3.2433328769E+01, 4.0264001920E+00, 9.8549684773E-01],
	[4.8695000000E+04, 4.8059902904E+01, 5.0834891802E+00, 3.2444258497E+01, 4.0266606624E+00, 9.8550278514E-01],
	[4.8700000000E+04, 4.8068727611E+01, 5.0835371844E+00, 3.2455190784E+01, 4.0269210714E+00, 9.8550871977E-01],
	[4.8705000000E+04, 4.8077553032E+01, 5.0835851842E+00, 3.2466125631E+01, 4.0271814189E+00, 9.8551465161E-01],
	[4.8710000000E+04, 4.8086379168E+01, 5.0836331796E+00, 3.2477063038E+01, 4.0274417051E+00, 9.8552058068E-01],
	[4.8715000000E+04, 4.8095206018E+01, 5.0836811704E+00, 3.2488003005E+01, 4.0277019298E+00, 9.8552650696E-01],
	[4.8720000000E+04, 4.8104033581E+01, 5.0837291568E+00, 3.2498945533E+01, 4.0279620932E+00, 9.8553243045E-01],
	[4.8725000000E+04, 4.8112861859E+01, 5.0837771387E+00, 3.2509890622E+01, 4.0282221951E+00, 9.8553835118E-01],
	[4.8730000000E+04, 4.8121690851E+01, 5.0838251161E+00, 3.2520838273E+01, 4.0284822358E+00, 9.8554426912E-01],
	[4.8735000000E+04, 4.8130520557E+01, 5.0838730891E+00, 3.2531788486E+01, 4.0287422151E+00, 9.8555018429E-01],
	[4.8740000000E+04, 4.8139350977E+01, 5.0839210576E+00, 3.2542741260E+01, 4.0290021330E+00, 9.8555609668E-01],
	[4.8745000000E+04, 4.8148182112E+01, 5.0839690216E+00, 3.2553696598E+01, 4.0292619897E+00, 9.8556200630E-01],
	[4.8750000000E+04, 4.8157013960E+01, 5.0840169812E+00, 3.2564654498E+01, 4.0295217851E+00, 9.8556791315E-01],
	[4.8755000000E+04, 4.8165846522E+01, 5.0840649363E+00, 3.2575614961E+01, 4.0297815193E+00, 9.8557381723E-01],
	[4.8760000000E+04, 4.8174679798E+01, 5.0841128869E+00, 3.2586577987E+01, 4.0300411922E+00, 9.8557971854E-01],
	[4.8765000000E+04, 4.8183513788E+01, 5.0841608331E+00, 3.2597543578E+01, 4.0303008038E+00, 9.8558561709E-01],
	[4.8770000000E+04, 4.8192348492E+01, 5.0842087748E+00, 3.2608511732E+01, 4.0305603543E+00, 9.8559151287E-01],
	[4.8775000000E+04, 4.8201183910E+01, 5.0842567120E+00, 3.2619482451E+01, 4.0308198436E+00, 9.8559740588E-01],
	[4.8780000000E+04, 4.8210020042E+01, 5.0843046448E+00, 3.2630455735E+01, 4.0310792717E+00, 9.8560329613E-01],
	[4.8785000000E+04, 4.8218856888E+01, 5.0843525731E+00, 3.2641431584E+01, 4.0313386386E+00, 9.8560918362E-01],
	[4.8790000000E+04, 4.8227694447E+01, 5.0844004969E+00, 3.2652409998E+01, 4.0315979444E+00, 9.8561506835E-01],
	[4.8795000000E+04, 4.8236532721E+01, 5.0844484163E+00, 3.2663390979E+01, 4.0318571891E+00, 9.8562095032E-01],
	[4.8800000000E+04, 4.8245371708E+01, 5.0844963313E+00, 3.2674374525E+01, 4.0321163726E+00, 9.8562682954E-01],
	[4.8805000000E+04, 4.8254211409E+01, 5.0845442417E+00, 3.2685360638E+01, 4.0323754951E+00, 9.8563270600E-01],
	[4.8810000000E+04, 4.8263051824E+01, 5.0845921478E+00, 3.2696349318E+01, 4.0326345565E+00, 9.8563857971E-01],
	[4.8815000000E+04, 4.8271892953E+01, 5.0846400493E+00, 3.2707340565E+01, 4.0328935568E+00, 9.8564445066E-01],
	[4.8820000000E+04, 4.8280734796E+01, 5.0846879464E+00, 3.2718334379E+01, 4.0331524961E+00, 9.8565031886E-01],
	[4.8825000000E+04, 4.8289577352E+01, 5.0847358391E+00, 3.2729330762E+01, 4.0334113744E+00, 9.8565618431E-01],
	[4.8830000000E+04, 4.8298420623E+01, 5.0847837273E+00, 3.2740329712E+01, 4.0336701917E+00, 9.8566204702E-01],
	[4.8835000000E+04, 4.8307264607E+01, 5.0848316110E+00, 3.2751331231E+01, 4.0339289480E+00, 9.8566790697E-01],
	[4.8840000000E+04, 4.8316109304E+01, 5.0848794903E+00, 3.2762335319E+01, 4.0341876433E+00, 9.8567376418E-01],
	[4.8845000000E+04, 4.8324954716E+01, 5.0849273652E+00, 3.2773341976E+01, 4.0344462777E+00, 9.8567961865E-01],
	[4.8850000000E+04, 4.8333800841E+01, 5.0849752356E+00, 3.2784351203E+01, 4.0347048512E+00, 9.8568547037E-01],
	[4.8855000000E+04, 4.8342647680E+01, 5.0850231015E+00, 3.2795362999E+01, 4.0349633637E+00, 9.8569131936E-01],
	[4.8860000000E+04, 4.8351495232E+01, 5.0850709630E+00, 3.2806377366E+01, 4.0352218153E+00, 9.8569716560E-01],
	[4.8865000000E+04, 4.8360343498E+01, 5.0851188201E+00, 3.2817394303E+01, 4.0354802061E+00, 9.8570300911E-01],
	[4.8870000000E+04, 4.8369192478E+01, 5.0851666727E+00, 3.2828413811E+01, 4.0357385360E+00, 9.8570884987E-01],
	[4.8875000000E+04, 4.8378042172E+01, 5.0852145209E+00, 3.2839435891E+01, 4.0359968050E+00, 9.8571468791E-01],
	[4.8880000000E+04, 4.8386892579E+01, 5.0852623646E+00, 3.2850460541E+01, 4.0362550132E+00, 9.8572052320E-01],
	[4.8885000000E+04, 4.8395743699E+01, 5.0853102039E+00, 3.2861487764E+01, 4.0365131606E+00, 9.8572635577E-01],
	[4.8890000000E+04, 4.8404595533E+01, 5.0853580387E+00, 3.2872517559E+01, 4.0367712472E+00, 9.8573218560E-01],
	[4.8895000000E+04, 4.8413448081E+01, 5.0854058691E+00, 3.2883549927E+01, 4.0370292730E+00, 9.8573801271E-01],
	[4.8900000000E+04, 4.8422301342E+01, 5.0854536950E+00, 3.2894584867E+01, 4.0372872381E+00, 9.8574383709E-01],
	[4.8905000000E+04, 4.8431155317E+01, 5.0855015165E+00, 3.2905622381E+01, 4.0375451424E+00, 9.8574965873E-01],
	[4.8910000000E+04, 4.8440010006E+01, 5.0855493336E+00, 3.2916662468E+01, 4.0378029860E+00, 9.8575547766E-01],
	[4.8915000000E+04, 4.8448865408E+01, 5.0855971462E+00, 3.2927705129E+01, 4.0380607689E+00, 9.8576129386E-01],
	[4.8920000000E+04, 4.8457721523E+01, 5.0856449544E+00, 3.2938750364E+01, 4.0383184911E+00, 9.8576710733E-01],
	[4.8925000000E+04, 4.8466578352E+01, 5.0856927582E+00, 3.2949798174E+01, 4.0385761526E+00, 9.8577291809E-01],
	[4.8930000000E+04, 4.8475435894E+01, 5.0857405575E+00, 3.2960848559E+01, 4.0388337534E+00, 9.8577872613E-01],
	[4.8935000000E+04, 4.8484294150E+01, 5.0857883524E+00, 3.2971901519E+01, 4.0390912937E+00, 9.8578453144E-01],
	[4.8940000000E+04, 4.8493153119E+01, 5.0858361429E+00, 3.2982957055E+01, 4.0393487732E+00, 9.8579033404E-01],
	[4.8945000000E+04, 4.8502012801E+01, 5.0858839289E+00, 3.2994015167E+01, 4.0396061922E+00, 9.8579613393E-01],
	[4.8950000000E+04, 4.8510873197E+01, 5.0859317105E+00, 3.3005075854E+01, 4.0398635506E+00, 9.8580193110E-01],
	[4.8955000000E+04, 4.8519734307E+01, 5.0859794876E+00, 3.3016139119E+01, 4.0401208485E+00, 9.8580772556E-01],
	[4.8960000000E+04, 4.8528596129E+01, 5.0860272603E+00, 3.3027204960E+01, 4.0403780857E+00, 9.8581351730E-01],
	[4.8965000000E+04, 4.8537458665E+01, 5.0860750286E+00, 3.3038273379E+01, 4.0406352625E+00, 9.8581930634E-01],
	[4.8970000000E+04, 4.8546321915E+01, 5.0861227925E+00, 3.3049344375E+01, 4.0408923787E+00, 9.8582509267E-01],
	[4.8975000000E+04, 4.8555185877E+01, 5.0861705519E+00, 3.3060417949E+01, 4.0411494344E+00, 9.8583087629E-01],
	[4.8980000000E+04, 4.8564050553E+01, 5.0862183069E+00, 3.3071494102E+01, 4.0414064296E+00, 9.8583665721E-01],
	[4.8985000000E+04, 4.8572915943E+01, 5.0862660575E+00, 3.3082572833E+01, 4.0416633644E+00, 9.8584243542E-01],
	[4.8990000000E+04, 4.8581782045E+01, 5.0863138037E+00, 3.3093654143E+01, 4.0419202387E+00, 9.8584821093E-01],
	[4.8995000000E+04, 4.8590648861E+01, 5.0863615454E+00, 3.3104738032E+01, 4.0421770525E+00, 9.8585398373E-01],
	[4.9000000000E+04, 4.8599516390E+01, 5.0864092827E+00, 3.3115824501E+01, 4.0424338060E+00, 9.8585975384E-01],
	[4.9005000000E+04, 4.8608384632E+01, 5.0864570156E+00, 3.3126913550E+01, 4.0426904990E+00, 9.8586552125E-01],
	[4.9010000000E+04, 4.8617253588E+01, 5.0865047441E+00, 3.3138005179E+01, 4.0429471317E+00, 9.8587128596E-01],
	[4.9015000000E+04, 4.8626123256E+01, 5.0865524681E+00, 3.3149099389E+01, 4.0432037040E+00, 9.8587704798E-01],
	[4.9020000000E+04, 4.8634993638E+01, 5.0866001877E+00, 3.3160196180E+01, 4.0434602160E+00, 9.8588280730E-01],
	[4.9025000000E+04, 4.8643864733E+01, 5.0866479029E+00, 3.3171295552E+01, 4.0437166676E+00, 9.8588856393E-01],
	[4.9030000000E+04, 4.8652736541E+01, 5.0866956137E+00, 3.3182397506E+01, 4.0439730589E+00, 9.8589431787E-01],
	[4.9035000000E+04, 4.8661609063E+01, 5.0867433201E+00, 3.3193502042E+01, 4.0442293899E+00, 9.8590006911E-01],
	[4.9040000000E+04, 4.8670482297E+01, 5.0867910220E+00, 3.3204609160E+01, 4.0444856607E+00, 9.8590581767E-01],
	[4.9045000000E+04, 4.8679356245E+01, 5.0868387196E+00, 3.3215718861E+01, 4.0447418711E+00, 9.8591156354E-01],
	[4.9050000000E+04, 4.8688230905E+01, 5.0868864127E+00, 3.3226831144E+01, 4.0449980214E+00, 9.8591730673E-01],
	[4.9055000000E+04, 4.8697106279E+01, 5.0869341014E+00, 3.3237946011E+01, 4.0452541114E+00, 9.8592304723E-01],
	[4.9060000000E+04, 4.8705982366E+01, 5.0869817857E+00, 3.3249063462E+01, 4.0455101411E+00, 9.8592878505E-01],
	[4.9065000000E+04, 4.8714859165E+01, 5.0870294656E+00, 3.3260183497E+01, 4.0457661107E+00, 9.8593452018E-01],
	[4.9070000000E+04, 4.8723744386E+01, 5.0870778875E+00, 3.3271306116E+01, 4.0460225455E+00, 9.8594025264E-01],
	[4.9075000000E+04, 4.8732638809E+01, 5.0871271268E+00, 3.3282431320E+01, 4.0462794986E+00, 9.8594598242E-01],
	[4.9080000000E+04, 4.8741533949E+01, 5.0871763615E+00, 3.3293559108E+01, 4.0465363917E+00, 9.8595170952E-01],
	[4.9085000000E+04, 4.8750429806E+01, 5.0872255917E+00, 3.3304689483E+01, 4.0467932247E+00, 9.8595743394E-01],
	[4.9090000000E+04, 4.8759326381E+01, 5.0872748173E+00, 3.3315822442E+01, 4.0470499977E+00, 9.8596315569E-01],
	[4.9095000000E+04, 4.8768223673E+01, 5.0873240384E+00, 3.3326957988E+01, 4.0473067108E+00, 9.8596887476E-01],
	[4.9100000000E+04, 4.8777121682E+01, 5.0873732550E+00, 3.3338096120E+01, 4.0475633638E+00, 9.8597459117E-01],
	[4.9105000000E+04, 4.8786020408E+01, 5.0874224670E+00, 3.3349236839E+01, 4.0478199570E+00, 9.8598030490E-01],
	[4.9110000000E+04, 4.8794919851E+01, 5.0874716745E+00, 3.3360380145E+01, 4.0480764902E+00, 9.8598601597E-01],
	[4.9115000000E+04, 4.8803820012E+01, 5.0875208775E+00, 3.3371526039E+01, 4.0483329635E+00, 9.8599172437E-01],
	[4.9120000000E+04, 4.8812720889E+01, 5.0875700759E+00, 3.3382674520E+01, 4.0485893768E+00, 9.8599743010E-01],
	[4.9125000000E+04, 4.8821622484E+01, 5.0876192698E+00, 3.3393825589E+01, 4.0488457303E+00, 9.8600313316E-01],
	[4.9130000000E+04, 4.8830524796E+01, 5.0876684592E+00, 3.3404979246E+01, 4.0491020240E+00, 9.8600883357E-01],
	[4.9135000000E+04, 4.8839427825E+01, 5.0877176441E+00, 3.3416135492E+01, 4.0493582578E+00, 9.8601453131E-01],
	[4.9140000000E+04, 4.8848331571E+01, 5.0877668244E+00, 3.3427294327E+01, 4.0496144317E+00, 9.8602022639E-01],
	[4.9145000000E+04, 4.8857236034E+01, 5.0878160002E+00, 3.3438455752E+01, 4.0498705458E+00, 9.8602591881E-01],
	[4.9150000000E+04, 4.8866141214E+01, 5.0878651714E+00, 3.3449619766E+01, 4.0501266002E+00, 9.8603160857E-01],
	[4.9155000000E+04, 4.8875047111E+01, 5.0879143381E+00, 3.3460786371E+01, 4.0503825947E+00, 9.8603729568E-01],
	[4.9160000000E+04, 4.8883953725E+01, 5.0879635004E+00, 3.3471955566E+01, 4.0506385295E+00, 9.8604298014E-01],
	[4.9165000000E+04, 4.8892861056E+01, 5.0880126580E+00, 3.3483127351E+01, 4.0508944046E+00, 9.8604866193E-01],
	[4.9170000000E+04, 4.8901769104E+01, 5.0880618112E+00, 3.3494301728E+01, 4.0511502199E+00, 9.8605434108E-01],
	[4.9175000000E+04, 4.8910677869E+01, 5.0881109598E+00, 3.3505478696E+01, 4.0514059755E+00, 9.8606001758E-01],
	[4.9180000000E+04, 4.8919587351E+01, 5.0881601039E+00, 3.3516658256E+01, 4.0516616714E+00, 9.8606569142E-01],
	[4.9185000000E+04, 4.8928497550E+01, 5.0882092435E+00, 3.3527840407E+01, 4.0519173077E+00, 9.8607136262E-01],
	[4.9190000000E+04, 4.8937408465E+01, 5.0882583786E+00, 3.3539025152E+01, 4.0521728842E+00, 9.8607703118E-01],
	[4.9195000000E+04, 4.8946320098E+01, 5.0883075091E+00, 3.3550212489E+01, 4.0524284011E+00, 9.8608269708E-01],
	[4.9200000000E+04, 4.8955232448E+01, 5.0883566352E+00, 3.3561402419E+01, 4.0526838584E+00, 9.8608836035E-01],
	[4.9205000000E+04, 4.8964145514E+01, 5.0884057567E+00, 3.3572594943E+01, 4.0529392561E+00, 9.8609402097E-01],
	[4.9210000000E+04, 4.8973059297E+01, 5.0884548737E+00, 3.3583790060E+01, 4.0531945942E+00, 9.8609967895E-01],
	[4.9215000000E+04, 4.8981973798E+01, 5.0885039861E+00, 3.3594987772E+01, 4.0534498727E+00, 9.8610533429E-01],
	[4.9220000000E+04, 4.8990889014E+01, 5.0885530941E+00, 3.3606188077E+01, 4.0537050917E+00, 9.8611098699E-01],
	[4.9225000000E+04, 4.8999804948E+01, 5.0886021975E+00, 3.3617390978E+01, 4.0539602511E+00, 9.8611663706E-01],
	[4.9230000000E+04, 4.9008721599E+01, 5.0886512965E+00, 3.3628596474E+01, 4.0542153510E+00, 9.8612228449E-01],
	[4.9235000000E+04, 4.9017638966E+01, 5.0887003909E+00, 3.3639804565E+01, 4.0544703913E+00, 9.8612792929E-01],
	[4.9240000000E+04, 4.9026557050E+01, 5.0887494808E+00, 3.3651015253E+01, 4.0547253722E+00, 9.8613357145E-01],
	[4.9245000000E+04, 4.9035475851E+01, 5.0887985662E+00, 3.3662228536E+01, 4.0549802936E+00, 9.8613921098E-01],
	[4.9250000000E+04, 4.9044395369E+01, 5.0888476471E+00, 3.3673444415E+01, 4.0552351555E+00, 9.8614484788E-01],
	[4.9255000000E+04, 4.9053315603E+01, 5.0888967235E+00, 3.3684662892E+01, 4.0554899580E+00, 9.8615048216E-01],
	[4.9260000000E+04, 4.9062236554E+01, 5.0889457953E+00, 3.3695883966E+01, 4.0557447011E+00, 9.8615611381E-01],
	[4.9265000000E+04, 4.9071158222E+01, 5.0889948627E+00, 3.3707107637E+01, 4.0559993848E+00, 9.8616174283E-01],
	[4.9270000000E+04, 4.9080080606E+01, 5.0890439256E+00, 3.3718333906E+01, 4.0562540090E+00, 9.8616736923E-01],
	[4.9275000000E+04, 4.9089003707E+01, 5.0890929839E+00, 3.3729562773E+01, 4.0565085739E+00, 9.8617299300E-01],
	[4.9280000000E+04, 4.9097927525E+01, 5.0891420378E+00, 3.3740794239E+01, 4.0567630795E+00, 9.8617861415E-01],
	[4.9285000000E+04, 4.9106852059E+01, 5.0891910871E+00, 3.3752028303E+01, 4.0570175257E+00, 9.8618423269E-01],
	[4.9290000000E+04, 4.9115777310E+01, 5.0892401319E+00, 3.3763264967E+01, 4.0572719125E+00, 9.8618984860E-01],
	[4.9295000000E+04, 4.9124703277E+01, 5.0892891723E+00, 3.3774504230E+01, 4.0575262401E+00, 9.8619546190E-01],
	[4.9300000000E+04, 4.9133629962E+01, 5.0893382081E+00, 3.3785746093E+01, 4.0577805084E+00, 9.8620107258E-01],
	[4.9305000000E+04, 4.9142557362E+01, 5.0893872394E+00, 3.3796990556E+01, 4.0580347174E+00, 9.8620668065E-01],
	[4.9310000000E+04, 4.9151485479E+01, 5.0894362663E+00, 3.3808237620E+01, 4.0582888671E+00, 9.8621228610E-01],
	[4.9315000000E+04, 4.9160414313E+01, 5.0894852886E+00, 3.3819487284E+01, 4.0585429576E+00, 9.8621788894E-01],
	[4.9320000000E+04, 4.9169343863E+01, 5.0895343064E+00, 3.3830739550E+01, 4.0587969889E+00, 9.8622348917E-01],
	[4.9325000000E+04, 4.9178274130E+01, 5.0895833198E+00, 3.3841994417E+01, 4.0590509610E+00, 9.8622908679E-01],
	[4.9330000000E+04, 4.9187205113E+01, 5.0896323286E+00, 3.3853251887E+01, 4.0593048738E+00, 9.8623468181E-01],
	[4.9335000000E+04, 4.9196136813E+01, 5.0896813330E+00, 3.3864511958E+01, 4.0595587276E+00, 9.8624027422E-01],
	[4.9340000000E+04, 4.9205069229E+01, 5.0897303328E+00, 3.3875774632E+01, 4.0598125221E+00, 9.8624586402E-01],
	[4.9345000000E+04, 4.9214002362E+01, 5.0897793282E+00, 3.3887039909E+01, 4.0600662575E+00, 9.8625145122E-01],
	[4.9350000000E+04, 4.9222936211E+01, 5.0898283191E+00, 3.3898307789E+01, 4.0603199338E+00, 9.8625703582E-01],
	[4.9355000000E+04, 4.9231870776E+01, 5.0898773054E+00, 3.3909578272E+01, 4.0605735510E+00, 9.8626261781E-01],
	[4.9360000000E+04, 4.9240806058E+01, 5.0899262873E+00, 3.3920851360E+01, 4.0608271091E+00, 9.8626819721E-01],
	[4.9365000000E+04, 4.9249742057E+01, 5.0899752647E+00, 3.3932127051E+01, 4.0610806081E+00, 9.8627377401E-01],
	[4.9370000000E+04, 4.9258678771E+01, 5.0900242376E+00, 3.3943405348E+01, 4.0613340481E+00, 9.8627934821E-01],
	[4.9375000000E+04, 4.9267616202E+01, 5.0900732060E+00, 3.3954686249E+01, 4.0615874290E+00, 9.8628491982E-01],
	[4.9380000000E+04, 4.9276554350E+01, 5.0901221700E+00, 3.3965969755E+01, 4.0618407509E+00, 9.8629048884E-01],
	[4.9385000000E+04, 4.9285493213E+01, 5.0901711294E+00, 3.3977255867E+01, 4.0620940138E+00, 9.8629605526E-01],
	[4.9390000000E+04, 4.9294432793E+01, 5.0902200844E+00, 3.3988544585E+01, 4.0623472177E+00, 9.8630161909E-01],
	[4.9395000000E+04, 4.9303373089E+01, 5.0902690348E+00, 3.3999835909E+01, 4.0626003626E+00, 9.8630718033E-01],
	[4.9400000000E+04, 4.9312314102E+01, 5.0903179808E+00, 3.4011129840E+01, 4.0628534486E+00, 9.8631273898E-01],
	[4.9405000000E+04, 4.9321255831E+01, 5.0903669223E+00, 3.4022426377E+01, 4.0631064757E+00, 9.8631829505E-01],
	[4.9410000000E+04, 4.9330198276E+01, 5.0904158594E+00, 3.4033725522E+01, 4.0633594438E+00, 9.8632384853E-01],
	[4.9415000000E+04, 4.9339141437E+01, 5.0904647919E+00, 3.4045027275E+01, 4.0636123530E+00, 9.8632939942E-01],
	[4.9420000000E+04, 4.9348085315E+01, 5.0905137200E+00, 3.4056331635E+01, 4.0638652033E+00, 9.8633494773E-01],
	[4.9425000000E+04, 4.9357029908E+01, 5.0905626435E+00, 3.4067638604E+01, 4.0641179948E+00, 9.8634049347E-01],
	[4.9430000000E+04, 4.9365975218E+01, 5.0906115626E+00, 3.4078948181E+01, 4.0643707274E+00, 9.8634603662E-01],
	[4.9435000000E+04, 4.9374921244E+01, 5.0906604773E+00, 3.4090260368E+01, 4.0646234012E+00, 9.8635157719E-01],
	[4.9440000000E+04, 4.9383867986E+01, 5.0907093874E+00, 3.4101575163E+01, 4.0648760161E+00, 9.8635711518E-01],
	[4.9445000000E+04, 4.9392815445E+01, 5.0907582931E+00, 3.4112892569E+01, 4.0651285722E+00, 9.8636265060E-01],
	[4.9450000000E+04, 4.9401763619E+01, 5.0908071943E+00, 3.4124212584E+01, 4.0653810696E+00, 9.8636818345E-01],
	[4.9455000000E+04, 4.9410712510E+01, 5.0908560910E+00, 3.4135535209E+01, 4.0656335082E+00, 9.8637371372E-01],
	[4.9460000000E+04, 4.9419662117E+01, 5.0909049832E+00, 3.4146860445E+01, 4.0658858880E+00, 9.8637924142E-01],
	[4.9465000000E+04, 4.9428612439E+01, 5.0909538710E+00, 3.4158188293E+01, 4.0661382091E+00, 9.8638476655E-01],
	[4.9470000000E+04, 4.9437563478E+01, 5.0910027543E+00, 3.4169518751E+01, 4.0663904715E+00, 9.8639028911E-01],
	[4.9475000000E+04, 4.9446515233E+01, 5.0910516331E+00, 3.4180851821E+01, 4.0666426751E+00, 9.8639580910E-01],
	[4.9480000000E+04, 4.9455467704E+01, 5.0911005075E+00, 3.4192187503E+01, 4.0668948201E+00, 9.8640132652E-01],
	[4.9485000000E+04, 4.9464420891E+01, 5.0911493774E+00, 3.4203525798E+01, 4.0671469064E+00, 9.8640684138E-01],
	[4.9490000000E+04, 4.9473374794E+01, 5.0911982428E+00, 3.4214866705E+01, 4.0673989341E+00, 9.8641235368E-01],
	[4.9495000000E+04, 4.9482329413E+01, 5.0912471038E+00, 3.4226210225E+01, 4.0676509031E+00, 9.8641786342E-01],
	[4.9500000000E+04, 4.9491284748E+01, 5.0912959603E+00, 3.4237556358E+01, 4.0679028135E+00, 9.8642337059E-01],
	[4.9505000000E+04, 4.9500240799E+01, 5.0913448123E+00, 3.4248905105E+01, 4.0681546652E+00, 9.8642887520E-01],
	[4.9510000000E+04, 4.9509197566E+01, 5.0913936598E+00, 3.4260256467E+01, 4.0684064584E+00, 9.8643437726E-01],
	[4.9515000000E+04, 4.9518155048E+01, 5.0914425029E+00, 3.4271610442E+01, 4.0686581931E+00, 9.8643987676E-01],
	[4.9520000000E+04, 4.9527113247E+01, 5.0914913416E+00, 3.4282967032E+01, 4.0689098692E+00, 9.8644537370E-01],
	[4.9525000000E+04, 4.9536072162E+01, 5.0915401757E+00, 3.4294326238E+01, 4.0691614867E+00, 9.8645086809E-01],
	[4.9530000000E+04, 4.9545031792E+01, 5.0915890054E+00, 3.4305688058E+01, 4.0694130457E+00, 9.8645635993E-01],
	[4.9535000000E+04, 4.9553992138E+01, 5.0916378307E+00, 3.4317052494E+01, 4.0696645462E+00, 9.8646184921E-01],
	[4.9540000000E+04, 4.9562953201E+01, 5.0916866515E+00, 3.4328419547E+01, 4.0699159883E+00, 9.8646733595E-01],
	[4.9545000000E+04, 4.9571914979E+01, 5.0917354678E+00, 3.4339789215E+01, 4.0701673718E+00, 9.8647282013E-01],
	[4.9550000000E+04, 4.9580877472E+01, 5.0917842796E+00, 3.4351161501E+01, 4.0704186969E+00, 9.8647830177E-01],
	[4.9555000000E+04, 4.9589840682E+01, 5.0918330871E+00, 3.4362536403E+01, 4.0706699636E+00, 9.8648378086E-01],
	[4.9560000000E+04, 4.9598804608E+01, 5.0918818900E+00, 3.4373913923E+01, 4.0709211718E+00, 9.8648925741E-01],
	[4.9565000000E+04, 4.9607769249E+01, 5.0919306885E+00, 3.4385294061E+01, 4.0711723216E+00, 9.8649473142E-01],
	[4.9570000000E+04, 4.9616734606E+01, 5.0919794825E+00, 3.4396676817E+01, 4.0714234131E+00, 9.8650020288E-01],
	[4.9575000000E+04, 4.9625700679E+01, 5.0920282721E+00, 3.4408062191E+01, 4.0716744462E+00, 9.8650567180E-01],
	[4.9580000000E+04, 4.9634667467E+01, 5.0920770573E+00, 3.4419450184E+01, 4.0719254209E+00, 9.8651113819E-01],
	[4.9585000000E+04, 4.9643634971E+01, 5.0921258379E+00, 3.4430840796E+01, 4.0721763373E+00, 9.8651660203E-01],
	[4.9590000000E+04, 4.9652603191E+01, 5.0921746142E+00, 3.4442234027E+01, 4.0724271954E+00, 9.8652206334E-01],
	[4.9595000000E+04, 4.9661572127E+01, 5.0922233860E+00, 3.4453629878E+01, 4.0726779951E+00, 9.8652752212E-01],
	[4.9600000000E+04, 4.9670541778E+01, 5.0922721533E+00, 3.4465028349E+01, 4.0729287366E+00, 9.8653297836E-01],
	[4.9605000000E+04, 4.9679512145E+01, 5.0923209162E+00, 3.4476429441E+01, 4.0731794198E+00, 9.8653843206E-01],
	[4.9610000000E+04, 4.9688483228E+01, 5.0923696746E+00, 3.4487833153E+01, 4.0734300447E+00, 9.8654388324E-01],
	[4.9615000000E+04, 4.9697455026E+01, 5.0924184286E+00, 3.4499239487E+01, 4.0736806114E+00, 9.8654933189E-01],
	[4.9620000000E+04, 4.9706427540E+01, 5.0924671781E+00, 3.4510648442E+01, 4.0739311199E+00, 9.8655477801E-01],
	[4.9625000000E+04, 4.9715400769E+01, 5.0925159232E+00, 3.4522060019E+01, 4.0741815702E+00, 9.8656022160E-01],
	[4.9630000000E+04, 4.9724374714E+01, 5.0925646639E+00, 3.4533474217E+01, 4.0744319623E+00, 9.8656566266E-01],
	[4.9635000000E+04, 4.9733349375E+01, 5.0926134001E+00, 3.4544891039E+01, 4.0746822962E+00, 9.8657110120E-01],
	[4.9640000000E+04, 4.9742324751E+01, 5.0926621318E+00, 3.4556310483E+01, 4.0749325720E+00, 9.8657653722E-01],
	[4.9645000000E+04, 4.9751300843E+01, 5.0927108592E+00, 3.4567732550E+01, 4.0751827896E+00, 9.8658197072E-01],
	[4.9650000000E+04, 4.9760277650E+01, 5.0927595820E+00, 3.4579157241E+01, 4.0754329491E+00, 9.8658740170E-01],
	[4.9655000000E+04, 4.9769255173E+01, 5.0928083005E+00, 3.4590584556E+01, 4.0756830505E+00, 9.8659283015E-01],
	[4.9660000000E+04, 4.9778233411E+01, 5.0928570145E+00, 3.4602014494E+01, 4.0759330938E+00, 9.8659825609E-01],
	[4.9665000000E+04, 4.9787212365E+01, 5.0929057241E+00, 3.4613447058E+01, 4.0761830790E+00, 9.8660367952E-01],
	[4.9670000000E+04, 4.9796192034E+01, 5.0929544292E+00, 3.4624882246E+01, 4.0764330062E+00, 9.8660910043E-01],
	[4.9675000000E+04, 4.9805172419E+01, 5.0930031299E+00, 3.4636320059E+01, 4.0766828754E+00, 9.8661451882E-01],
	[4.9680000000E+04, 4.9814153519E+01, 5.0930518261E+00, 3.4647760498E+01, 4.0769326865E+00, 9.8661993470E-01],
	[4.9685000000E+04, 4.9823135334E+01, 5.0931005179E+00, 3.4659203562E+01, 4.0771824396E+00, 9.8662534808E-01],
	[4.9690000000E+04, 4.9832117865E+01, 5.0931492053E+00, 3.4670649253E+01, 4.0774321347E+00, 9.8663075894E-01],
	[4.9695000000E+04, 4.9841101111E+01, 5.0931978883E+00, 3.4682097570E+01, 4.0776817718E+00, 9.8663616729E-01],
	[4.9700000000E+04, 4.9850085073E+01, 5.0932465668E+00, 3.4693548514E+01, 4.0779313510E+00, 9.8664157314E-01],
	[4.9705000000E+04, 4.9859069750E+01, 5.0932952409E+00, 3.4705002086E+01, 4.0781808723E+00, 9.8664697648E-01],
	[4.9710000000E+04, 4.9868055142E+01, 5.0933439105E+00, 3.4716458284E+01, 4.0784303356E+00, 9.8665237732E-01],
	[4.9715000000E+04, 4.9877041250E+01, 5.0933925757E+00, 3.4727917111E+01, 4.0786797410E+00, 9.8665777566E-01],
	[4.9720000000E+04, 4.9886028073E+01, 5.0934412365E+00, 3.4739378566E+01, 4.0789290885E+00, 9.8666317149E-01],
	[4.9725000000E+04, 4.9895015611E+01, 5.0934898929E+00, 3.4750842650E+01, 4.0791783782E+00, 9.8666856483E-01],
	[4.9730000000E+04, 4.9904003865E+01, 5.0935385448E+00, 3.4762309362E+01, 4.0794276100E+00, 9.8667395566E-01],
	[4.9735000000E+04, 4.9912992834E+01, 5.0935871923E+00, 3.4773778704E+01, 4.0796767839E+00, 9.8667934400E-01],
	[4.9740000000E+04, 4.9921982518E+01, 5.0936358354E+00, 3.4785250675E+01, 4.0799259001E+00, 9.8668472984E-01],
	[4.9745000000E+04, 4.9930972917E+01, 5.0936844741E+00, 3.4796725276E+01, 4.0801749584E+00, 9.8669011319E-01],
	[4.9750000000E+04, 4.9939964032E+01, 5.0937331083E+00, 3.4808202507E+01, 4.0804239589E+00, 9.8669549404E-01],
	[4.9755000000E+04, 4.9948955861E+01, 5.0937817381E+00, 3.4819682369E+01, 4.0806729016E+00, 9.8670087240E-01],
	[4.9760000000E+04, 4.9957948406E+01, 5.0938303635E+00, 3.4831164862E+01, 4.0809217866E+00, 9.8670624827E-01],
	[4.9765000000E+04, 4.9966941667E+01, 5.0938789845E+00, 3.4842649986E+01, 4.0811706139E+00, 9.8671162165E-01],
	[4.9770000000E+04, 4.9975935642E+01, 5.0939276010E+00, 3.4854137741E+01, 4.0814193834E+00, 9.8671699255E-01],
	[4.9775000000E+04, 4.9984930332E+01, 5.0939762132E+00, 3.4865628129E+01, 4.0816680952E+00, 9.8672236095E-01],
	[4.9780000000E+04, 4.9993925738E+01, 5.0940248209E+00, 3.4877121149E+01, 4.0819167493E+00, 9.8672772687E-01],
	[4.9785000000E+04, 5.0002921859E+01, 5.0940734242E+00, 3.4888616801E+01, 4.0821653458E+00, 9.8673309031E-01],
	[4.9790000000E+04, 5.0011918694E+01, 5.0941220230E+00, 3.4900115086E+01, 4.0824138845E+00, 9.8673845126E-01],
	[4.9795000000E+04, 5.0020916245E+01, 5.0941706175E+00, 3.4911616005E+01, 4.0826623657E+00, 9.8674380973E-01],
	[4.9800000000E+04, 5.0029914511E+01, 5.0942192075E+00, 3.4923119557E+01, 4.0829107892E+00, 9.8674916573E-01],
	[4.9805000000E+04, 5.0038913492E+01, 5.0942677932E+00, 3.4934625743E+01, 4.0831591551E+00, 9.8675451924E-01],
	[4.9810000000E+04, 5.0047913189E+01, 5.0943163744E+00, 3.4946134564E+01, 4.0834074634E+00, 9.8675987028E-01],
	[4.9815000000E+04, 5.0056913600E+01, 5.0943649512E+00, 3.4957646019E+01, 4.0836557141E+00, 9.8676521884E-01],
	[4.9820000000E+04, 5.0065914726E+01, 5.0944135236E+00, 3.4969160109E+01, 4.0839039073E+00, 9.8677056492E-01],
	[4.9825000000E+04, 5.0074916567E+01, 5.0944620915E+00, 3.4980676835E+01, 4.0841520429E+00, 9.8677590853E-01],
	[4.9830000000E+04, 5.0083919123E+01, 5.0945106551E+00, 3.4992196196E+01, 4.0844001210E+00, 9.8678124967E-01],
	[4.9835000000E+04, 5.0092922394E+01, 5.0945592143E+00, 3.5003718193E+01, 4.0846481415E+00, 9.8678658834E-01],
	[4.9840000000E+04, 5.0101926380E+01, 5.0946077690E+00, 3.5015242826E+01, 4.0848961046E+00, 9.8679192454E-01],
	[4.9845000000E+04, 5.0110931081E+01, 5.0946563193E+00, 3.5026770096E+01, 4.0851440102E+00, 9.8679725827E-01],
	[4.9850000000E+04, 5.0119936497E+01, 5.0947048653E+00, 3.5038300003E+01, 4.0853918583E+00, 9.8680258954E-01],
	[4.9855000000E+04, 5.0128942628E+01, 5.0947534068E+00, 3.5049832547E+01, 4.0856396490E+00, 9.8680791834E-01],
	[4.9860000000E+04, 5.0137957429E+01, 5.0948026985E+00, 3.5061367729E+01, 4.0858879204E+00, 9.8681324467E-01],
	[4.9865000000E+04, 5.0146981176E+01, 5.0948527660E+00, 3.5072905549E+01, 4.0861366910E+00, 9.8681856854E-01],
	[4.9870000000E+04, 5.0156005642E+01, 5.0949028290E+00, 3.5084446008E+01, 4.0863854043E+00, 9.8682388995E-01],
	[4.9875000000E+04, 5.0165030827E+01, 5.0949528874E+00, 3.5095989105E+01, 4.0866340603E+00, 9.8682920890E-01],
	[4.9880000000E+04, 5.0174056731E+01, 5.0950029414E+00, 3.5107534841E+01, 4.0868826590E+00, 9.8683452539E-01],
	[4.9885000000E+04, 5.0183083354E+01, 5.0950529908E+00, 3.5119083217E+01, 4.0871312005E+00, 9.8683983943E-01],
	[4.9890000000E+04, 5.0192110695E+01, 5.0951030357E+00, 3.5130634232E+01, 4.0873796847E+00, 9.8684515101E-01],
	[4.9895000000E+04, 5.0201138756E+01, 5.0951530761E+00, 3.5142187887E+01, 4.0876281117E+00, 9.8685046013E-01],
	[4.9900000000E+04, 5.0210167536E+01, 5.0952031119E+00, 3.5153744183E+01, 4.0878764815E+00, 9.8685576680E-01],
	[4.9905000000E+04, 5.0219197035E+01, 5.0952531432E+00, 3.5165303119E+01, 4.0881247942E+00, 9.8686107101E-01],
	[4.9910000000E+04, 5.0228227253E+01, 5.0953031700E+00, 3.5176864697E+01, 4.0883730496E+00, 9.8686637278E-01],
	[4.9915000000E+04, 5.0237258190E+01, 5.0953531923E+00, 3.5188428915E+01, 4.0886212479E+00, 9.8687167210E-01],
	[4.9920000000E+04, 5.0246289845E+01, 5.0954032101E+00, 3.5199995776E+01, 4.0888693891E+00, 9.8687696896E-01],
	[4.9925000000E+04, 5.0255322220E+01, 5.0954532233E+00, 3.5211565279E+01, 4.0891174732E+00, 9.8688226338E-01],
	[4.9930000000E+04, 5.0264355313E+01, 5.0955032320E+00, 3.5223137424E+01, 4.0893655001E+00, 9.8688755536E-01],
	[4.9935000000E+04, 5.0273389126E+01, 5.0955532362E+00, 3.5234712211E+01, 4.0896134700E+00, 9.8689284489E-01],
	[4.9940000000E+04, 5.0282423657E+01, 5.0956032359E+00, 3.5246289642E+01, 4.0898613828E+00, 9.8689813197E-01],
	[4.9945000000E+04, 5.0291458907E+01, 5.0956532311E+00, 3.5257869717E+01, 4.0901092385E+00, 9.8690341662E-01],
	[4.9950000000E+04, 5.0300494876E+01, 5.0957032218E+00, 3.5269452435E+01, 4.0903570372E+00, 9.8690869882E-01],
	[4.9955000000E+04, 5.0309531563E+01, 5.0957532079E+00, 3.5281037797E+01, 4.0906047789E+00, 9.8691397858E-01],
	[4.9960000000E+04, 5.0318568970E+01, 5.0958031896E+00, 3.5292625804E+01, 4.0908524635E+00, 9.8691925590E-01],
	[4.9965000000E+04, 5.0327607095E+01, 5.0958531667E+00, 3.5304216455E+01, 4.0911000912E+00, 9.8692453079E-01],
	[4.9970000000E+04, 5.0336645939E+01, 5.0959031393E+00, 3.5315809752E+01, 4.0913476619E+00, 9.8692980323E-01],
	[4.9975000000E+04, 5.0345685502E+01, 5.0959531074E+00, 3.5327405694E+01, 4.0915951756E+00, 9.8693507325E-01],
	[4.9980000000E+04, 5.0354725783E+01, 5.0960030710E+00, 3.5339004282E+01, 4.0918426324E+00, 9.8694034082E-01],
	[4.9985000000E+04, 5.0363766783E+01, 5.0960530301E+00, 3.5350605516E+01, 4.0920900323E+00, 9.8694560597E-01],
	[4.9990000000E+04, 5.0372808502E+01, 5.0961029847E+00, 3.5362209396E+01, 4.0923373753E+00, 9.8695086868E-01],
	[4.9995000000E+04, 5.0381850940E+01, 5.0961529347E+00, 3.5373815923E+01, 4.0925846613E+00, 9.8695612896E-01],
	[5.0000000000E+04, 5.0390894096E+01, 5.0962028803E+00, 3.5385425098E+01, 4.0928318905E+00, 9.8696138682E-01],
	[5.0005000000E+04, 5.0399937971E+01, 5.0962528214E+00, 3.5397048308E+01, 4.0930792152E+00, 9.8696664224E-01],
	[5.0010000000E+04, 5.0408982565E+01, 5.0963027579E+00, 3.5408674173E+01, 4.0933264828E+00, 9.8697189524E-01],
	[5.0015000000E+04, 5.0418027877E+01, 5.0963526900E+00, 3.5420302693E+01, 4.0935736936E+00, 9.8697714581E-01],
	[5.0020000000E+04, 5.0427073908E+01, 5.0964026175E+00, 3.5431933868E+01, 4.0938208475E+00, 9.8698239395E-01],
	[5.0025000000E+04, 5.0436120657E+0