import numpy as np

# data taken from McGPU files (Badal A, Badano A. Accelerating Monte Carlo simulations of photon transport in a voxelized geometry using a massively parallel graphics processing unit. Med Phys. 2009 Nov;36(11):4878–80. )

#[MEAN FREE PATHS (cm)]
#[Energy (eV) 	| Rayleigh 	| Compton 	| Photoelectric 	| TOTAL (+pair prod) (cm) | Rayleigh: max cumul prob F^2]

bone_ICRP110_MFP = np.array([
	[5.0000000000E+03, 6.1537537128E-01, 5.1642644729E+00, 2.8717364686E-03, 2.8568161168E-03, 2.5641953982E-01],
	[5.0050000000E+03, 6.1595490348E-01, 5.1614465339E+00, 2.8795019656E-03, 2.8645127010E-03, 2.5667277950E-01],
	[5.0100000000E+03, 6.1653440198E-01, 5.1586329439E+00, 2.8872806124E-03, 2.8722221837E-03, 2.5692590003E-01],
	[5.0150000000E+03, 6.1711386681E-01, 5.1558236920E+00, 2.8950724177E-03, 2.8799445730E-03, 2.5717890158E-01],
	[5.0200000000E+03, 6.1769329800E-01, 5.1530187670E+00, 2.9028773907E-03, 2.8876798774E-03, 2.5743178431E-01],
	[5.0250000000E+03, 6.1827269560E-01, 5.1502181581E+00, 2.9106955401E-03, 2.8954281051E-03, 2.5768454839E-01],
	[5.0300000000E+03, 6.1885205964E-01, 5.1474218544E+00, 2.9185268751E-03, 2.9031892643E-03, 2.5793719400E-01],
	[5.0350000000E+03, 6.1943139014E-01, 5.1446298448E+00, 2.9263714044E-03, 2.9109633633E-03, 2.5818972128E-01],
	[5.0400000000E+03, 6.2001068716E-01, 5.1418421187E+00, 2.9342291370E-03, 2.9187504104E-03, 2.5844213042E-01],
	[5.0450000000E+03, 6.2058995071E-01, 5.1390586651E+00, 2.9421000820E-03, 2.9265504138E-03, 2.5869442157E-01],
	[5.0500000000E+03, 6.2116918085E-01, 5.1362794733E+00, 2.9499842481E-03, 2.9343633817E-03, 2.5894659490E-01],
	[5.0550000000E+03, 6.2174837759E-01, 5.1335045326E+00, 2.9578816444E-03, 2.9421893225E-03, 2.5919865059E-01],
	[5.0600000000E+03, 6.2232754099E-01, 5.1307338323E+00, 2.9657922798E-03, 2.9500282443E-03, 2.5945058879E-01],
	[5.0650000000E+03, 6.2290667107E-01, 5.1279673616E+00, 2.9737161631E-03, 2.9578801553E-03, 2.5970240968E-01],
	[5.0700000000E+03, 6.2348576786E-01, 5.1252051101E+00, 2.9816533034E-03, 2.9657450639E-03, 2.5995411342E-01],
	[5.0750000000E+03, 6.2406483141E-01, 5.1224470670E+00, 2.9896037095E-03, 2.9736229781E-03, 2.6020570018E-01],
	[5.0800000000E+03, 6.2464386175E-01, 5.1196932219E+00, 2.9975673903E-03, 2.9815139064E-03, 2.6045717012E-01],
	[5.0850000000E+03, 6.2522636315E-01, 5.1169727950E+00, 3.0055443547E-03, 2.9894179469E-03, 2.6070852342E-01],
	[5.0900000000E+03, 6.2580917476E-01, 5.1142593195E+00, 3.0135346118E-03, 2.9973350272E-03, 2.6095976024E-01],
	[5.0950000000E+03, 6.2639195663E-01, 5.1115499451E+00, 3.0215381702E-03, 3.0052651470E-03, 2.6121088075E-01],
	[5.1000000000E+03, 6.2697470877E-01, 5.1088446614E+00, 3.0295550391E-03, 3.0132083143E-03, 2.6146188512E-01],
	[5.1050000000E+03, 6.2755743122E-01, 5.1061434583E+00, 3.0375852272E-03, 3.0211645375E-03, 2.6171277351E-01],
	[5.1100000000E+03, 6.2814012402E-01, 5.1034463257E+00, 3.0456287434E-03, 3.0291338246E-03, 2.6196354610E-01],
	[5.1150000000E+03, 6.2872278718E-01, 5.1007532534E+00, 3.0536855968E-03, 3.0371161840E-03, 2.6221420304E-01],
	[5.1200000000E+03, 6.2930542075E-01, 5.0980642315E+00, 3.0617557960E-03, 3.0451116237E-03, 2.6246474451E-01],
	[5.1250000000E+03, 6.2988802475E-01, 5.0953792497E+00, 3.0698393501E-03, 3.0531201520E-03, 2.6271517068E-01],
	[5.1300000000E+03, 6.3047059921E-01, 5.0926982982E+00, 3.0779362679E-03, 3.0611417770E-03, 2.6296548172E-01],
	[5.1350000000E+03, 6.3105314416E-01, 5.0900213670E+00, 3.0860465583E-03, 3.0691765070E-03, 2.6321567778E-01],
	[5.1400000000E+03, 6.3163565964E-01, 5.0873484461E+00, 3.0941702301E-03, 3.0772243501E-03, 2.6346575905E-01],
	[5.1450000000E+03, 6.3221814567E-01, 5.0846795257E+00, 3.1023072923E-03, 3.0852853144E-03, 2.6371572569E-01],
	[5.1500000000E+03, 6.3280060228E-01, 5.0820145958E+00, 3.1104577537E-03, 3.0933594082E-03, 2.6396557787E-01],
	[5.1550000000E+03, 6.3338302951E-01, 5.0793536467E+00, 3.1186216232E-03, 3.1014466396E-03, 2.6421531575E-01],
	[5.1600000000E+03, 6.3396542738E-01, 5.0766966685E+00, 3.1267989097E-03, 3.1095470168E-03, 2.6446493951E-01],
	[5.1650000000E+03, 6.3454989152E-01, 5.0740608821E+00, 3.1349896220E-03, 3.1176606050E-03, 2.6471444932E-01],
	[5.1700000000E+03, 6.3513601682E-01, 5.0714428768E+00, 3.1431937689E-03, 3.1257874018E-03, 2.6496384534E-01],
	[5.1750000000E+03, 6.3572211615E-01, 5.0688287511E+00, 3.1514113594E-03, 3.1339273697E-03, 2.6521312774E-01],
	[5.1800000000E+03, 6.3630818954E-01, 5.0662184954E+00, 3.1596424022E-03, 3.1420805168E-03, 2.6546229669E-01],
	[5.1850000000E+03, 6.3689423701E-01, 5.0636121003E+00, 3.1678869063E-03, 3.1502468511E-03, 2.6571135237E-01],
	[5.1900000000E+03, 6.3748025859E-01, 5.0610095563E+00, 3.1761448805E-03, 3.1584263810E-03, 2.6596029493E-01],
	[5.1950000000E+03, 6.3806625432E-01, 5.0584108541E+00, 3.1844163336E-03, 3.1666191144E-03, 2.6620912455E-01],
	[5.2000000000E+03, 6.3865222420E-01, 5.0558159843E+00, 3.1927012745E-03, 3.1748250595E-03, 2.6645784140E-01],
	[5.2050000000E+03, 6.3923816828E-01, 5.0532249376E+00, 3.2009997120E-03, 3.1830442244E-03, 2.6670644564E-01],
	[5.2100000000E+03, 6.3982408657E-01, 5.0506377046E+00, 3.2093116550E-03, 3.1912766173E-03, 2.6695493746E-01],
	[5.2150000000E+03, 6.4040997910E-01, 5.0480542761E+00, 3.2176371122E-03, 3.1995222463E-03, 2.6720331701E-01],
	[5.2200000000E+03, 6.4099584590E-01, 5.0454746430E+00, 3.2259760926E-03, 3.2077811194E-03, 2.6745158446E-01],
	[5.2250000000E+03, 6.4158168699E-01, 5.0428987958E+00, 3.2343286048E-03, 3.2160532449E-03, 2.6769973999E-01],
	[5.2300000000E+03, 6.4216750240E-01, 5.0403267256E+00, 3.2426946579E-03, 3.2243386307E-03, 2.6794778377E-01],
	[5.2350000000E+03, 6.4275329216E-01, 5.0377584232E+00, 3.2510742605E-03, 3.2326372850E-03, 2.6819571596E-01],
	[5.2400000000E+03, 6.4333905628E-01, 5.0351938794E+00, 3.2594674216E-03, 3.2409492159E-03, 2.6844353673E-01],
	[5.2450000000E+03, 6.4392479480E-01, 5.0326330851E+00, 3.2678741499E-03, 3.2492744314E-03, 2.6869124626E-01],
	[5.2500000000E+03, 6.4451398213E-01, 5.0301041658E+00, 3.2762944542E-03, 3.2576130403E-03, 2.6893884469E-01],
	[5.2550000000E+03, 6.4510339691E-01, 5.0275809442E+00, 3.2847283433E-03, 3.2659649581E-03, 2.6918633217E-01],
	[5.2600000000E+03, 6.4569278940E-01, 5.0250613862E+00, 3.2931758262E-03, 3.2743301856E-03, 2.6943370885E-01],
	[5.2650000000E+03, 6.4628215962E-01, 5.0225454830E+00, 3.3016369114E-03, 3.2827087310E-03, 2.6968097487E-01],
	[5.2700000000E+03, 6.4687150760E-01, 5.0200332257E+00, 3.3101116080E-03, 3.2911006022E-03, 2.6992813038E-01],
	[5.2750000000E+03, 6.4746083336E-01, 5.0175246057E+00, 3.3185999246E-03, 3.2995058075E-03, 2.7017517554E-01],
	[5.2800000000E+03, 6.4805013691E-01, 5.0150196143E+00, 3.3271018700E-03, 3.3079243548E-03, 2.7042211047E-01],
	[5.2850000000E+03, 6.4863941828E-01, 5.0125182427E+00, 3.3356174532E-03, 3.3163562522E-03, 2.7066893534E-01],
	[5.2900000000E+03, 6.4922867750E-01, 5.0100204823E+00, 3.3441466827E-03, 3.3248015078E-03, 2.7091565029E-01],
	[5.2950000000E+03, 6.4981791458E-01, 5.0075263245E+00, 3.3526895675E-03, 3.3332601296E-03, 2.7116225546E-01],
	[5.3000000000E+03, 6.5040712954E-01, 5.0050357607E+00, 3.3612461163E-03, 3.3417321257E-03, 2.7140875100E-01],
	[5.3050000000E+03, 6.5099632241E-01, 5.0025487824E+00, 3.3698163379E-03, 3.3502175041E-03, 2.7165513707E-01],
	[5.3100000000E+03, 6.5158549321E-01, 5.0000653810E+00, 3.3784002410E-03, 3.3587162729E-03, 2.7190141380E-01],
	[5.3150000000E+03, 6.5217464196E-01, 4.9975855480E+00, 3.3869978345E-03, 3.3672284400E-03, 2.7214758135E-01],
	[5.3200000000E+03, 6.5276376869E-01, 4.9951092749E+00, 3.3956091272E-03, 3.3757540136E-03, 2.7239363986E-01],
	[5.3250000000E+03, 6.5335287340E-01, 4.9926365533E+00, 3.4042341277E-03, 3.3842930016E-03, 2.7263958947E-01],
	[5.3300000000E+03, 6.5394211862E-01, 4.9901686732E+00, 3.4128728449E-03, 3.3928454170E-03, 2.7288543035E-01],
	[5.3350000000E+03, 6.5453484448E-01, 4.9877322738E+00, 3.4215252875E-03, 3.4014113706E-03, 2.7313116263E-01],
	[5.3400000000E+03, 6.5512755159E-01, 4.9852993446E+00, 3.4301914643E-03, 3.4099907636E-03, 2.7337678646E-01],
	[5.3450000000E+03, 6.5572023995E-01, 4.9828698775E+00, 3.4388713840E-03, 3.4185836039E-03, 2.7362230200E-01],
	[5.3500000000E+03, 6.5631290958E-01, 4.9804438642E+00, 3.4475650555E-03, 3.4271898997E-03, 2.7386770938E-01],
	[5.3550000000E+03, 6.5690556051E-01, 4.9780212967E+00, 3.4562724874E-03, 3.4358096588E-03, 2.7411300876E-01],
	[5.3600000000E+03, 6.5749819275E-01, 4.9756021668E+00, 3.4649936885E-03, 3.4444428894E-03, 2.7435820028E-01],
	[5.3650000000E+03, 6.5809080631E-01, 4.9731864665E+00, 3.4737286675E-03, 3.4530895994E-03, 2.7460328410E-01],
	[5.3700000000E+03, 6.5868340123E-01, 4.9707741877E+00, 3.4824774333E-03, 3.4617497968E-03, 2.7484826035E-01],
	[5.3750000000E+03, 6.5927597751E-01, 4.9683653224E+00, 3.4912399945E-03, 3.4704234896E-03, 2.7509312920E-01],
	[5.3800000000E+03, 6.5986853517E-01, 4.9659598626E+00, 3.5000163599E-03, 3.4791106858E-03, 2.7533789078E-01],
	[5.3850000000E+03, 6.6046107423E-01, 4.9635578003E+00, 3.5088065382E-03, 3.4878113934E-03, 2.7558254524E-01],
	[5.3900000000E+03, 6.6105359472E-01, 4.9611591275E+00, 3.5176105381E-03, 3.4965256203E-03, 2.7582709274E-01],
	[5.3950000000E+03, 6.6164609663E-01, 4.9587638364E+00, 3.5264283685E-03, 3.5052533745E-03, 2.7607153342E-01],
	[5.4000000000E+03, 6.6223858001E-01, 4.9563719190E+00, 3.5352600379E-03, 3.5139946641E-03, 2.7631586743E-01],
	[5.4050000000E+03, 6.6283104485E-01, 4.9539833676E+00, 3.5441055552E-03, 3.5227494969E-03, 2.7656009492E-01],
	[5.4100000000E+03, 6.6342349118E-01, 4.9515981741E+00, 3.5529649290E-03, 3.5315178809E-03, 2.7680421604E-01],
	[5.4150000000E+03, 6.6401591903E-01, 4.9492163309E+00, 3.5618381682E-03, 3.5402998241E-03, 2.7704823093E-01],
	[5.4200000000E+03, 6.6461151560E-01, 4.9468629071E+00, 3.5707252813E-03, 3.5490954383E-03, 2.7729213975E-01],
	[5.4250000000E+03, 6.6520751523E-01, 4.9445160611E+00, 3.5796262771E-03, 3.5579046420E-03, 2.7753594264E-01],
	[5.4300000000E+03, 6.6580349953E-01, 4.9421724890E+00, 3.5885411643E-03, 3.5667274296E-03, 2.7777963975E-01],
	[5.4350000000E+03, 6.6639946853E-01, 4.9398321831E+00, 3.5974699517E-03, 3.5755638091E-03, 2.7802323123E-01],
	[5.4400000000E+03, 6.6699542223E-01, 4.9374951359E+00, 3.6064126479E-03, 3.5844137885E-03, 2.7826671724E-01],
	[5.4450000000E+03, 6.6759136065E-01, 4.9351613399E+00, 3.6153692617E-03, 3.5932773756E-03, 2.7851009791E-01],
	[5.4500000000E+03, 6.6818728381E-01, 4.9328307875E+00, 3.6243398016E-03, 3.6021545784E-03, 2.7875337340E-01],
	[5.4550000000E+03, 6.6878319171E-01, 4.9305034714E+00, 3.6333242766E-03, 3.6110454048E-03, 2.7899654385E-01],
	[5.4600000000E+03, 6.6937908438E-01, 4.9281793840E+00, 3.6423226951E-03, 3.6199498628E-03, 2.7923960942E-01],
	[5.4650000000E+03, 6.6997496183E-01, 4.9258585179E+00, 3.6513350660E-03, 3.6288679602E-03, 2.7948257025E-01],
	[5.4700000000E+03, 6.7057082407E-01, 4.9235408657E+00, 3.6603613979E-03, 3.6377997051E-03, 2.7972542650E-01],
	[5.4750000000E+03, 6.7116667112E-01, 4.9212264200E+00, 3.6694016995E-03, 3.6467451052E-03, 2.7996817831E-01],
	[5.4800000000E+03, 6.7176250298E-01, 4.9189151735E+00, 3.6784702018E-03, 3.6557182155E-03, 2.8021082584E-01],
	[5.4850000000E+03, 6.7235831968E-01, 4.9166071188E+00, 3.6875642147E-03, 3.6647163775E-03, 2.8045336922E-01],
	[5.4900000000E+03, 6.7295412124E-01, 4.9143022487E+00, 3.6966723183E-03, 3.6737283112E-03, 2.8069580862E-01],
	[5.4950000000E+03, 6.7354990765E-01, 4.9120005557E+00, 3.7057945214E-03, 3.6827540246E-03, 2.8093814417E-01],
	[5.5000000000E+03, 6.7414567894E-01, 4.9097020328E+00, 3.7149308328E-03, 3.6917935257E-03, 2.8118037604E-01],
	[5.5050000000E+03, 6.7474302121E-01, 4.9074189843E+00, 3.7240812613E-03, 3.7008468773E-03, 2.8142250436E-01],
	[5.5100000000E+03, 6.7534231103E-01, 4.9051542725E+00, 3.7332458157E-03, 3.7099141010E-03, 2.8166452930E-01],
	[5.5150000000E+03, 6.7594158882E-01, 4.9028926586E+00, 3.7424245047E-03, 3.7189951373E-03, 2.8190645099E-01],
	[5.5200000000E+03, 6.7654085460E-01, 4.9006341355E+00, 3.7516173373E-03, 3.7280899943E-03, 2.8214826959E-01],
	[5.5250000000E+03, 6.7714010838E-01, 4.8983786962E+00, 3.7608243221E-03, 3.7371986799E-03, 2.8238998524E-01],
	[5.5300000000E+03, 6.7773935017E-01, 4.8961263337E+00, 3.7700454679E-03, 3.7463212022E-03, 2.8263159811E-01],
	[5.5350000000E+03, 6.7833857999E-01, 4.8938770411E+00, 3.7792807835E-03, 3.7554575691E-03, 2.8287310833E-01],
	[5.5400000000E+03, 6.7893779783E-01, 4.8916308114E+00, 3.7885302778E-03, 3.7646077886E-03, 2.8311451605E-01],
	[5.5450000000E+03, 6.7953700371E-01, 4.8893876376E+00, 3.7977939594E-03, 3.7737718687E-03, 2.8335582143E-01],
	[5.5500000000E+03, 6.8013619765E-01, 4.8871475129E+00, 3.8070718371E-03, 3.7829498174E-03, 2.8359702462E-01],
	[5.5550000000E+03, 6.8073537966E-01, 4.8849104304E+00, 3.8163639198E-03, 3.7921416426E-03, 2.8383812576E-01],
	[5.5600000000E+03, 6.8133454974E-01, 4.8826763832E+00, 3.8256702161E-03, 3.8013473523E-03, 2.8407912501E-01],
	[5.5650000000E+03, 6.8193370791E-01, 4.8804453644E+00, 3.8349907348E-03, 3.8105669545E-03, 2.8432002251E-01],
	[5.5700000000E+03, 6.8253285417E-01, 4.8782173673E+00, 3.8443254848E-03, 3.8198004572E-03, 2.8456081842E-01],
	[5.5750000000E+03, 6.8313198855E-01, 4.8759923850E+00, 3.8536744747E-03, 3.8290478682E-03, 2.8480151289E-01],
	[5.5800000000E+03, 6.8373111104E-01, 4.8737704109E+00, 3.8630377133E-03, 3.8383091955E-03, 2.8504210606E-01],
	[5.5850000000E+03, 6.8433022167E-01, 4.8715514380E+00, 3.8724152094E-03, 3.8475844471E-03, 2.8528259808E-01],
	[5.5900000000E+03, 6.8492932043E-01, 4.8693354597E+00, 3.8818069717E-03, 3.8568736310E-03, 2.8552298911E-01],
	[5.5950000000E+03, 6.8553095350E-01, 4.8671419536E+00, 3.8912130090E-03, 3.8661768483E-03, 2.8576327930E-01],
	[5.6000000000E+03, 6.8613351991E-01, 4.8649586003E+00, 3.9006333299E-03, 3.8754940490E-03, 2.8600346879E-01],
	[5.6050000000E+03, 6.8673607747E-01, 4.8627781737E+00, 3.9100679433E-03, 3.8848252067E-03, 2.8624355773E-01],
	[5.6100000000E+03, 6.8733862622E-01, 4.8606006672E+00, 3.9195168579E-03, 3.8941703293E-03, 2.8648354626E-01],
	[5.6150000000E+03, 6.8794116615E-01, 4.8584260744E+00, 3.9289800824E-03, 3.9035294247E-03, 2.8672343448E-01],
	[5.6200000000E+03, 6.8854369727E-01, 4.8562543887E+00, 3.9384576256E-03, 3.9129025009E-03, 2.8696322254E-01],
	[5.6250000000E+03, 6.8914621959E-01, 4.8540856037E+00, 3.9479494961E-03, 3.9222895658E-03, 2.8720291056E-01],
	[5.6300000000E+03, 6.8974873311E-01, 4.8519197129E+00, 3.9574557028E-03, 3.9316906272E-03, 2.8744249866E-01],
	[5.6350000000E+03, 6.9035123786E-01, 4.8497567100E+00, 3.9669762543E-03, 3.9411056931E-03, 2.8768198696E-01],
	[5.6400000000E+03, 6.9095373382E-01, 4.8475965884E+00, 3.9765111594E-03, 3.9505347715E-03, 2.8792137560E-01],
	[5.6450000000E+03, 6.9155622102E-01, 4.8454393418E+00, 3.9860604267E-03, 3.9599778701E-03, 2.8816066470E-01],
	[5.6500000000E+03, 6.9215869946E-01, 4.8432849639E+00, 3.9956240651E-03, 3.9694349969E-03, 2.8839985439E-01],
	[5.6550000000E+03, 6.9276116914E-01, 4.8411334483E+00, 4.0052020831E-03, 3.9789061599E-03, 2.8863894480E-01],
	[5.6600000000E+03, 6.9336363008E-01, 4.8389847886E+00, 4.0147944897E-03, 3.9883913668E-03, 2.8887793604E-01],
	[5.6650000000E+03, 6.9396608229E-01, 4.8368389786E+00, 4.0244012933E-03, 3.9978906256E-03, 2.8911682825E-01],
	[5.6700000000E+03, 6.9456852576E-01, 4.8346960120E+00, 4.0340225028E-03, 4.0074039442E-03, 2.8935562155E-01],
	[5.6750000000E+03, 6.9517096051E-01, 4.8325558825E+00, 4.0436581268E-03, 4.0169313304E-03, 2.8959431607E-01],
	[5.6800000000E+03, 6.9577338655E-01, 4.8304185838E+00, 4.0533081741E-03, 4.0264727921E-03, 2.8983291193E-01],
	[5.6850000000E+03, 6.9637829878E-01, 4.8283029432E+00, 4.0629726534E-03, 4.0360284342E-03, 2.9007140927E-01],
	[5.6900000000E+03, 6.9698414081E-01, 4.8261971470E+00, 4.0726515733E-03, 4.0455982048E-03, 2.9030980820E-01],
	[5.6950000000E+03, 6.9758997708E-01, 4.8240941177E+00, 4.0823449425E-03, 4.0551820754E-03, 2.9054810886E-01],
	[5.7000000000E+03, 6.9819580759E-01, 4.8219938491E+00, 4.0920527698E-03, 4.0647800540E-03, 2.9078631138E-01],
	[5.7050000000E+03, 6.9880163235E-01, 4.8198963353E+00, 4.1017750638E-03, 4.0743921484E-03, 2.9102441587E-01],
	[5.7100000000E+03, 6.9940745138E-01, 4.8178015702E+00, 4.1115118332E-03, 4.0840183664E-03, 2.9126242247E-01],
	[5.7150000000E+03, 7.0001326466E-01, 4.8157095477E+00, 4.1212630867E-03, 4.0936587160E-03, 2.9150033130E-01],
	[5.7200000000E+03, 7.0061907221E-01, 4.8136202620E+00, 4.1310288330E-03, 4.1033132049E-03, 2.9173814249E-01],
	[5.7250000000E+03, 7.0122487403E-01, 4.8115337070E+00, 4.1408090807E-03, 4.1129818411E-03, 2.9197585616E-01],
	[5.7300000000E+03, 7.0183067013E-01, 4.8094498769E+00, 4.1506038385E-03, 4.1226646323E-03, 2.9221347245E-01],
	[5.7350000000E+03, 7.0243646051E-01, 4.8073687656E+00, 4.1604131152E-03, 4.1323615864E-03, 2.9245099148E-01],
	[5.7400000000E+03, 7.0304224518E-01, 4.8052903672E+00, 4.1702369193E-03, 4.1420727112E-03, 2.9268841338E-01],
	[5.7450000000E+03, 7.0364802414E-01, 4.8032146759E+00, 4.1800752596E-03, 4.1517980145E-03, 2.9292573828E-01],
	[5.7500000000E+03, 7.0425379740E-01, 4.8011416858E+00, 4.1899281447E-03, 4.1615375042E-03, 2.9316296629E-01],
	[5.7550000000E+03, 7.0485956496E-01, 4.7990713910E+00, 4.1997955833E-03, 4.1712911881E-03, 2.9340009756E-01],
	[5.7600000000E+03, 7.0546532683E-01, 4.7970037856E+00, 4.2096775839E-03, 4.1810590740E-03, 2.9363713220E-01],
	[5.7650000000E+03, 7.0607108301E-01, 4.7949388640E+00, 4.2195741554E-03, 4.1908411698E-03, 2.9387407034E-01],
	[5.7700000000E+03, 7.0667683350E-01, 4.7928766201E+00, 4.2294853063E-03, 4.2006374831E-03, 2.9411091212E-01],
	[5.7750000000E+03, 7.0728404469E-01, 4.7908279744E+00, 4.2394110453E-03, 4.2104480823E-03, 2.9434765766E-01],
	[5.7800000000E+03, 7.0789315880E-01, 4.7887961696E+00, 4.2493513811E-03, 4.2202729940E-03, 2.9458430708E-01],
	[5.7850000000E+03, 7.0850227011E-01, 4.7867669823E+00, 4.2593063222E-03, 4.2301121477E-03, 2.9482086051E-01],
	[5.7900000000E+03, 7.0911137862E-01, 4.7847404068E+00, 4.2692758774E-03, 4.2399655512E-03, 2.9505731809E-01],
	[5.7950000000E+03, 7.0972048435E-01, 4.7827164375E+00, 4.2792600553E-03, 4.2498332124E-03, 2.9529367994E-01],
	[5.8000000000E+03, 7.1032958728E-01, 4.7806950687E+00, 4.2892588645E-03, 4.2597151389E-03, 2.9552994618E-01],
	[5.8050000000E+03, 7.1093868742E-01, 4.7786762950E+00, 4.2992723136E-03, 4.2696113386E-03, 2.9576611695E-01],
	[5.8100000000E+03, 7.1154778478E-01, 4.7766601108E+00, 4.3093004113E-03, 4.2795218193E-03, 2.9600219236E-01],
	[5.8150000000E+03, 7.1215687935E-01, 4.7746465104E+00, 4.3193431663E-03, 4.2894465888E-03, 2.9623817256E-01],
	[5.8200000000E+03, 7.1276597115E-01, 4.7726354884E+00, 4.3294005871E-03, 4.2993856547E-03, 2.9647405767E-01],
	[5.8250000000E+03, 7.1337506016E-01, 4.7706270393E+00, 4.3394726824E-03, 4.3093390250E-03, 2.9670984781E-01],
	[5.8300000000E+03, 7.1398414640E-01, 4.7686211576E+00, 4.3495594608E-03, 4.3193067073E-03, 2.9694554311E-01],
	[5.8350000000E+03, 7.1459322987E-01, 4.7666178378E+00, 4.3596609309E-03, 4.3292887095E-03, 2.9718114370E-01],
	[5.8400000000E+03, 7.1520231056E-01, 4.7646170744E+00, 4.3697771014E-03, 4.3392850392E-03, 2.9741664972E-01],
	[5.8450000000E+03, 7.1581138849E-01, 4.7626188619E+00, 4.3799079808E-03, 4.3492957043E-03, 2.9765206127E-01],
	[5.8500000000E+03, 7.1642046364E-01, 4.7606231951E+00, 4.3900535778E-03, 4.3593207124E-03, 2.9788737851E-01],
	[5.8550000000E+03, 7.1702953604E-01, 4.7586300683E+00, 4.4002139010E-03, 4.3693600714E-03, 2.9812260155E-01],
	[5.8600000000E+03, 7.1763860567E-01, 4.7566394763E+00, 4.4103889590E-03, 4.3794137889E-03, 2.9835773051E-01],
	[5.8650000000E+03, 7.1824767254E-01, 4.7546514137E+00, 4.4205787604E-03, 4.3894818728E-03, 2.9859276554E-01],
	[5.8700000000E+03, 7.1885954826E-01, 4.7526865398E+00, 4.4307833138E-03, 4.3995644538E-03, 2.9882770675E-01],
	[5.8750000000E+03, 7.1947192849E-01, 4.7507278558E+00, 4.4410026278E-03, 4.4096614395E-03, 2.9906255428E-01],
	[5.8800000000E+03, 7.2008430876E-01, 4.7487716443E+00, 4.4512367110E-03, 4.4197728158E-03, 2.9929730825E-01],
	[5.8850000000E+03, 7.2069668910E-01, 4.7468179001E+00, 4.4614855721E-03, 4.4298985903E-03, 2.9953196879E-01],
	[5.8900000000E+03, 7.2130906949E-01, 4.7448666178E+00, 4.4717492195E-03, 4.4400387708E-03, 2.9976653603E-01],
	[5.8950000000E+03, 7.2192144993E-01, 4.7429177924E+00, 4.4820276619E-03, 4.4501933650E-03, 3.0000101010E-01],
	[5.9000000000E+03, 7.2253383042E-01, 4.7409714187E+00, 4.4923209079E-03, 4.4603623807E-03, 3.0023539113E-01],
	[5.9050000000E+03, 7.2314621097E-01, 4.7390274914E+00, 4.5026289661E-03, 4.4705458254E-03, 3.0046967924E-01],
	[5.9100000000E+03, 7.2375859158E-01, 4.7370860055E+00, 4.5129518450E-03, 4.4807437070E-03, 3.0070387456E-01],
	[5.9150000000E+03, 7.2437097223E-01, 4.7351469559E+00, 4.5232895533E-03, 4.4909560331E-03, 3.0093797723E-01],
	[5.9200000000E+03, 7.2498335295E-01, 4.7332103373E+00, 4.5336420995E-03, 4.5011828115E-03, 3.0117198736E-01],
	[5.9250000000E+03, 7.2559573371E-01, 4.7312761448E+00, 4.5440094921E-03, 4.5114240498E-03, 3.0140590509E-01],
	[5.9300000000E+03, 7.2620811453E-01, 4.7293443732E+00, 4.5543917399E-03, 4.5216797558E-03, 3.0163973055E-01],
	[5.9350000000E+03, 7.2682049540E-01, 4.7274150174E+00, 4.5647888512E-03, 4.5319499371E-03, 3.0187346387E-01],
	[5.9400000000E+03, 7.2743287633E-01, 4.7254880725E+00, 4.5752008348E-03, 4.5422346014E-03, 3.0210710516E-01],
	[5.9450000000E+03, 7.2804525731E-01, 4.7235635334E+00, 4.5856276991E-03, 4.5525337564E-03, 3.0234065457E-01],
	[5.9500000000E+03, 7.2865763834E-01, 4.7216413950E+00, 4.5960694528E-03, 4.5628474097E-03, 3.0257411218E-01],
	[5.9550000000E+03, 7.2927001943E-01, 4.7197216524E+00, 4.6065261044E-03, 4.5731755691E-03, 3.0280747811E-01],
	[5.9600000000E+03, 7.2988240057E-01, 4.7178043005E+00, 4.6169976624E-03, 4.5835182422E-03, 3.0304075246E-01],
	[5.9650000000E+03, 7.3049791735E-01, 4.7159120728E+00, 4.6274841355E-03, 4.5938755823E-03, 3.0327393533E-01],
	[5.9700000000E+03, 7.3111356186E-01, 4.7140230941E+00, 4.6379855321E-03, 4.6042474583E-03, 3.0350702684E-01],
	[5.9750000000E+03, 7.3172920917E-01, 4.7121364525E+00, 4.6485018608E-03, 4.6146338719E-03, 3.0374002708E-01],
	[5.9800000000E+03, 7.3234485927E-01, 4.7102521431E+00, 4.6590331302E-03, 4.6250348311E-03, 3.0397293617E-01],
	[5.9850000000E+03, 7.3296051217E-01, 4.7083701612E+00, 4.6695793489E-03, 4.6354503432E-03, 3.0420575421E-01],
	[5.9900000000E+03, 7.3357616786E-01, 4.7064905019E+00, 4.6801405252E-03, 4.6458804161E-03, 3.0443848130E-01],
	[5.9950000000E+03, 7.3419182634E-01, 4.7046131603E+00, 4.6907166679E-03, 4.6563250574E-03, 3.0467111756E-01],
	[6.0000000000E+03, 7.3480748760E-01, 4.7027381318E+00, 4.7013077855E-03, 4.6667842746E-03, 3.0490366308E-01],
	[6.0050000000E+03, 7.3542315165E-01, 4.7008654115E+00, 4.7119444405E-03, 4.6772881818E-03, 3.0513611798E-01],
	[6.0100000000E+03, 7.3603881848E-01, 4.6989949946E+00, 4.7225961928E-03, 4.6878067828E-03, 3.0536848236E-01],
	[6.0150000000E+03, 7.3665448810E-01, 4.6971268765E+00, 4.7332630512E-03, 4.6983400852E-03, 3.0560075632E-01],
	[6.0200000000E+03, 7.3727016048E-01, 4.6952610524E+00, 4.7439450241E-03, 4.7088880969E-03, 3.0583293998E-01],
	[6.0250000000E+03, 7.3788583565E-01, 4.6933975176E+00, 4.7546421204E-03, 4.7194508256E-03, 3.0606503344E-01],
	[6.0300000000E+03, 7.3850151358E-01, 4.6915362674E+00, 4.7653543487E-03, 4.7300282790E-03, 3.0629703680E-01],
	[6.0350000000E+03, 7.3911719429E-01, 4.6896772970E+00, 4.7760817176E-03, 4.7406204650E-03, 3.0652895017E-01],
	[6.0400000000E+03, 7.3973287776E-01, 4.6878206018E+00, 4.7868242358E-03, 4.7512273911E-03, 3.0676077367E-01],
	[6.0450000000E+03, 7.4034856400E-01, 4.6859661772E+00, 4.7975819119E-03, 4.7618490651E-03, 3.0699250739E-01],
	[6.0500000000E+03, 7.4096425301E-01, 4.6841140184E+00, 4.8083547546E-03, 4.7724854949E-03, 3.0722415143E-01],
	[6.0550000000E+03, 7.4157994477E-01, 4.6822641209E+00, 4.8191427725E-03, 4.7831366880E-03, 3.0745570592E-01],
	[6.0600000000E+03, 7.4219812498E-01, 4.6804341603E+00, 4.8299459743E-03, 4.7938027745E-03, 3.0768717096E-01],
	[6.0650000000E+03, 7.4281704665E-01, 4.6786116563E+00, 4.8407643686E-03, 4.8044836771E-03, 3.0791854664E-01],
	[6.0700000000E+03, 7.4343597377E-01, 4.6767913630E+00, 4.8515979640E-03, 4.8151793672E-03, 3.0814983309E-01],
	[6.0750000000E+03, 7.4405490633E-01, 4.6749732758E+00, 4.8624467693E-03, 4.8258898527E-03, 3.0838103040E-01],
	[6.0800000000E+03, 7.4467384434E-01, 4.6731573902E+00, 4.8733107929E-03, 4.8366151413E-03, 3.0861213868E-01],
	[6.0850000000E+03, 7.4529278779E-01, 4.6713437019E+00, 4.8841900437E-03, 4.8473552406E-03, 3.0884315804E-01],
	[6.0900000000E+03, 7.4591173668E-01, 4.6695322062E+00, 4.8950845301E-03, 4.8581101584E-03, 3.0907408859E-01],
	[6.0950000000E+03, 7.4653069100E-01, 4.6677228989E+00, 4.9059942608E-03, 4.8688799023E-03, 3.0930493043E-01],
	[6.1000000000E+03, 7.4714965074E-01, 4.6659157753E+00, 4.9169192445E-03, 4.8796644802E-03, 3.0953568367E-01],
	[6.1050000000E+03, 7.4776861590E-01, 4.6641108312E+00, 4.9278594897E-03, 4.8904638995E-03, 3.0976634842E-01],
	[6.1100000000E+03, 7.4838758648E-01, 4.6623080621E+00, 4.9388150051E-03, 4.9012781681E-03, 3.0999692478E-01],
	[6.1150000000E+03, 7.4900656248E-01, 4.6605074636E+00, 4.9497857993E-03, 4.9121072937E-03, 3.1022741287E-01],
	[6.1200000000E+03, 7.4962554388E-01, 4.6587090314E+00, 4.9607718810E-03, 4.9229512838E-03, 3.1045781278E-01],
	[6.1250000000E+03, 7.5024453069E-01, 4.6569127609E+00, 4.9717732586E-03, 4.9338101462E-03, 3.1068812463E-01],
	[6.1300000000E+03, 7.5086352290E-01, 4.6551186480E+00, 4.9827899409E-03, 4.9446838886E-03, 3.1091834853E-01],
	[6.1350000000E+03, 7.5148252050E-01, 4.6533266882E+00, 4.9938219364E-03, 4.9555725186E-03, 3.1114848458E-01],
	[6.1400000000E+03, 7.5210152349E-01, 4.6515368772E+00, 5.0048692538E-03, 4.9664760439E-03, 3.1137853288E-01],
	[6.1450000000E+03, 7.5272053188E-01, 4.6497492107E+00, 5.0159319017E-03, 4.9773944721E-03, 3.1160849355E-01],
	[6.1500000000E+03, 7.5333954564E-01, 4.6479636844E+00, 5.0270098886E-03, 4.9883278109E-03, 3.1183836669E-01],
	[6.1550000000E+03, 7.5395943551E-01, 4.6461863393E+00, 5.0381032231E-03, 4.9992761132E-03, 3.1206815242E-01],
	[6.1600000000E+03, 7.5458165889E-01, 4.6444272559E+00, 5.0492119139E-03, 5.0102394632E-03, 3.1229785083E-01],
	[6.1650000000E+03, 7.5520389031E-01, 4.6426702648E+00, 5.0603359695E-03, 5.0212177478E-03, 3.1252746204E-01],
	[6.1700000000E+03, 7.5582612975E-01, 4.6409153621E+00, 5.0714753986E-03, 5.0322109748E-03, 3.1275698615E-01],
	[6.1750000000E+03, 7.5644837721E-01, 4.6391625434E+00, 5.0826302097E-03, 5.0432191517E-03, 3.1298642328E-01],
	[6.1800000000E+03, 7.5707063269E-01, 4.6374118047E+00, 5.0938004114E-03, 5.0542422861E-03, 3.1321577352E-01],
	[6.1850000000E+03, 7.5769289617E-01, 4.6356631417E+00, 5.1049860123E-03, 5.0652803859E-03, 3.1344503699E-01],
	[6.1900000000E+03, 7.5831516766E-01, 4.6339165504E+00, 5.1161870210E-03, 5.0763334584E-03, 3.1367421379E-01],
	[6.1950000000E+03, 7.5893744714E-01, 4.6321720266E+00, 5.1274034460E-03, 5.0874015115E-03, 3.1390330404E-01],
	[6.2000000000E+03, 7.5955973461E-01, 4.6304295662E+00, 5.1386352960E-03, 5.0984845527E-03, 3.1413230784E-01],
	[6.2050000000E+03, 7.6018203006E-01, 4.6286891651E+00, 5.1498825795E-03, 5.1095825896E-03, 3.1436122529E-01],
	[6.2100000000E+03, 7.6080433349E-01, 4.6269508192E+00, 5.1611453050E-03, 5.1206956298E-03, 3.1459005651E-01],
	[6.2150000000E+03, 7.6142664489E-01, 4.6252145244E+00, 5.1724234812E-03, 5.1318236811E-03, 3.1481880160E-01],
	[6.2200000000E+03, 7.6204896425E-01, 4.6234802767E+00, 5.1837171167E-03, 5.1429667508E-03, 3.1504746068E-01],
	[6.2250000000E+03, 7.6267129157E-01, 4.6217480721E+00, 5.1950262199E-03, 5.1541248468E-03, 3.1527603384E-01],
	[6.2300000000E+03, 7.6329362684E-01, 4.6200179064E+00, 5.2063507994E-03, 5.1652979765E-03, 3.1550452121E-01],
	[6.2350000000E+03, 7.6391597006E-01, 4.6182897756E+00, 5.2176908639E-03, 5.1764861476E-03, 3.1573292288E-01],
	[6.2400000000E+03, 7.6453832121E-01, 4.6165636757E+00, 5.2291879463E-03, 5.1878286624E-03, 3.1596123896E-01],
	[6.2450000000E+03, 7.6516068029E-01, 4.6148396028E+00, 5.2407256859E-03, 5.1992109851E-03, 3.1618946956E-01],
	[6.2500000000E+03, 7.6578304730E-01, 4.6131175527E+00, 5.2522795537E-03, 5.2106089717E-03, 3.1641761480E-01],
	[6.2550000000E+03, 7.6640688003E-01, 4.6114073913E+00, 5.2638495591E-03, 5.2220227111E-03, 3.1664567477E-01],
	[6.2600000000E+03, 7.6703243871E-01, 4.6097108393E+00, 5.2754357117E-03, 5.2334522267E-03, 3.1687364959E-01],
	[6.2650000000E+03, 7.6765800792E-01, 4.6080162652E+00, 5.2870380208E-03, 5.2448974328E-03, 3.1710153939E-01],
	[6.2700000000E+03, 7.6828358767E-01, 4.6063236653E+00, 5.2986564960E-03, 5.2563583378E-03, 3.1732934446E-01],
	[6.2750000000E+03, 7.6890917793E-01, 4.6046330355E+00, 5.3102911469E-03, 5.2678349501E-03, 3.1755706492E-01],
	[6.2800000000E+03, 7.6953477870E-01, 4.6029443721E+00, 5.3219419827E-03, 5.2793272782E-03, 3.1778470085E-01],
	[6.2850000000E+03, 7.7016038998E-01, 4.6012576712E+00, 5.3336090131E-03, 5.2908353304E-03, 3.1801225233E-01],
	[6.2900000000E+03, 7.7078601175E-01, 4.5995729289E+00, 5.3452922474E-03, 5.3023591153E-03, 3.1823971943E-01],
	[6.2950000000E+03, 7.7141164400E-01, 4.5978901415E+00, 5.3569916952E-03, 5.3138986412E-03, 3.1846710225E-01],
	[6.3000000000E+03, 7.7203728674E-01, 4.5962093050E+00, 5.3687073659E-03, 5.3254539166E-03, 3.1869440084E-01],
	[6.3050000000E+03, 7.7266293994E-01, 4.5945304157E+00, 5.3804392690E-03, 5.3370249498E-03, 3.1892161530E-01],
	[6.3100000000E+03, 7.7328860361E-01, 4.5928534699E+00, 5.3921874139E-03, 5.3486117493E-03, 3.1914874570E-01],
	[6.3150000000E+03, 7.7391427773E-01, 4.5911784636E+00, 5.4039518101E-03, 5.3602143235E-03, 3.1937579212E-01],
	[6.3200000000E+03, 7.7453996230E-01, 4.5895053932E+00, 5.4157324671E-03, 5.3718326808E-03, 3.1960275463E-01],
	[6.3250000000E+03, 7.7516565730E-01, 4.5878342549E+00, 5.4275293943E-03, 5.3834668296E-03, 3.1982963332E-01],
	[6.3300000000E+03, 7.7579136274E-01, 4.5861650448E+00, 5.4393426012E-03, 5.3951167783E-03, 3.2005642827E-01],
	[6.3350000000E+03, 7.7641707859E-01, 4.5844977594E+00, 5.4511720972E-03, 5.4067825353E-03, 3.2028313955E-01],
	[6.3400000000E+03, 7.7704280486E-01, 4.5828323947E+00, 5.4630178917E-03, 5.4184641089E-03, 3.2050976725E-01],
	[6.3450000000E+03, 7.7766854154E-01, 4.5811689472E+00, 5.4748799943E-03, 5.4301615076E-03, 3.2073631144E-01],
	[6.3500000000E+03, 7.7829428861E-01, 4.5795074131E+00, 5.4867584143E-03, 5.4418747397E-03, 3.2096277220E-01],
	[6.3550000000E+03, 7.7892107723E-01, 4.5778545989E+00, 5.4986531612E-03, 5.4536038738E-03, 3.2118914961E-01],
	[6.3600000000E+03, 7.7954999729E-01, 4.5762176668E+00, 5.5105642445E-03, 5.4653489827E-03, 3.2141544374E-01],
	[6.3650000000E+03, 7.8017893031E-01, 4.5745826057E+00, 5.5224916735E-03, 5.4771099514E-03, 3.2164165469E-01],
	[6.3700000000E+03, 7.8080787629E-01, 4.5729494121E+00, 5.5344354578E-03, 5.4888867882E-03, 3.2186778253E-01],
	[6.3750000000E+03, 7.8143683522E-01, 4.5713180823E+00, 5.5463956067E-03, 5.5006795015E-03, 3.2209382734E-01],
	[6.3800000000E+03, 7.8206580709E-01, 4.5696886128E+00, 5.5583721297E-03, 5.5124880997E-03, 3.2231978919E-01],
	[6.3850000000E+03, 7.8269479188E-01, 4.5680609999E+00, 5.5703650361E-03, 5.5243125911E-03, 3.2254566817E-01],
	[6.3900000000E+03, 7.8332378959E-01, 4.5664352401E+00, 5.5823743356E-03, 5.5361529841E-03, 3.2277146436E-01],
	[6.3950000000E+03, 7.8395280021E-01, 4.5648113298E+00, 5.5944000373E-03, 5.5480092871E-03, 3.2299717783E-01],
	[6.4000000000E+03, 7.8458182373E-01, 4.5631892656E+00, 5.6064421509E-03, 5.5598815083E-03, 3.2322280867E-01],
	[6.4050000000E+03, 7.8521086014E-01, 4.5615690437E+00, 5.6185006857E-03, 5.5717696562E-03, 3.2344835696E-01],
	[6.4100000000E+03, 7.8583990942E-01, 4.5599506609E+00, 5.6305756511E-03, 5.5836737390E-03, 3.2367382278E-01],
	[6.4150000000E+03, 7.8646897157E-01, 4.5583341134E+00, 5.6426670565E-03, 5.5955937652E-03, 3.2389920620E-01],
	[6.4200000000E+03, 7.8709804659E-01, 4.5567193978E+00, 5.6547749114E-03, 5.6075297430E-03, 3.2412450730E-01],
	[6.4250000000E+03, 7.8772713445E-01, 4.5551065106E+00, 5.6668992252E-03, 5.6194816808E-03, 3.2434972618E-01],
	[6.4300000000E+03, 7.8835623515E-01, 4.5534954483E+00, 5.6790400072E-03, 5.6314495869E-03, 3.2457486290E-01],
	[6.4350000000E+03, 7.8898534868E-01, 4.5518862075E+00, 5.6911972669E-03, 5.6434334696E-03, 3.2479991755E-01],
	[6.4400000000E+03, 7.8961447503E-01, 4.5502787846E+00, 5.7033710138E-03, 5.6554333372E-03, 3.2502489020E-01],
	[6.4450000000E+03, 7.9024361419E-01, 4.5486731762E+00, 5.7155612571E-03, 5.6674491981E-03, 3.2524978094E-01],
	[6.4500000000E+03, 7.9087276615E-01, 4.5470693788E+00, 5.7277680063E-03, 5.6794810606E-03, 3.2547458986E-01],
	[6.4550000000E+03, 7.9150193090E-01, 4.5454673890E+00, 5.7399912708E-03, 5.6915289330E-03, 3.2569931702E-01],
	[6.4600000000E+03, 7.9213383371E-01, 4.5438847473E+00, 5.7522310601E-03, 5.7035929925E-03, 3.2592396251E-01],
	[6.4650000000E+03, 7.9276615459E-01, 4.5423064723E+00, 5.7644873834E-03, 5.7156731046E-03, 3.2614852641E-01],
	[6.4700000000E+03, 7.9339849078E-01, 4.5407299651E+00, 5.7767602502E-03, 5.7277692527E-03, 3.2637300880E-01],
	[6.4750000000E+03, 7.9403084229E-01, 4.5391552222E+00, 5.7890496699E-03, 5.7398814452E-03, 3.2659740976E-01],
	[6.4800000000E+03, 7.9466320909E-01, 4.5375822403E+00, 5.8013556519E-03, 5.7520096903E-03, 3.2682172938E-01],
	[6.4850000000E+03, 7.9529559118E-01, 4.5360110162E+00, 5.8137442334E-03, 5.7642189041E-03, 3.2704596773E-01],
	[6.4900000000E+03, 7.9592798854E-01, 4.5344415465E+00, 5.8261611235E-03, 5.7764557122E-03, 3.2727012489E-01],
	[6.4950000000E+03, 7.9656040117E-01, 4.5328738279E+00, 5.8385948831E-03, 5.7887088680E-03, 3.2749420095E-01],
	[6.5000000000E+03, 7.9719282904E-01, 4.5313078570E+00, 5.8510455218E-03, 5.8009783802E-03, 3.2771819599E-01],
	[6.5050000000E+03, 7.9782527216E-01, 4.5297436307E+00, 5.8635130495E-03, 5.8132642576E-03, 3.2794211009E-01],
	[6.5100000000E+03, 7.9845773050E-01, 4.5281811456E+00, 5.8759974759E-03, 5.8255665086E-03, 3.2816594332E-01],
	[6.5150000000E+03, 7.9909020407E-01, 4.5266203984E+00, 5.8884988108E-03, 5.8378851421E-03, 3.2838969577E-01],
	[6.5200000000E+03, 7.9972269284E-01, 4.5250613859E+00, 5.9010170641E-03, 5.8502201666E-03, 3.2861336753E-01],
	[6.5250000000E+03, 8.0035519680E-01, 4.5235041049E+00, 5.9135522455E-03, 5.8625715908E-03, 3.2883695866E-01],
	[6.5300000000E+03, 8.0098771595E-01, 4.5219485520E+00, 5.9261043648E-03, 5.8749394232E-03, 3.2906046927E-01],
	[6.5350000000E+03, 8.0162025027E-01, 4.5203947240E+00, 5.9386734317E-03, 5.8873236726E-03, 3.2928389941E-01],
	[6.5400000000E+03, 8.0225279975E-01, 4.5188426178E+00, 5.9512594561E-03, 5.8997243476E-03, 3.2950724919E-01],
	[6.5450000000E+03, 8.0288536438E-01, 4.5172922300E+00, 5.9638624477E-03, 5.9121414568E-03, 3.2973051867E-01],
	[6.5500000000E+03, 8.0351794414E-01, 4.5157435576E+00, 5.9764824163E-03, 5.9245750088E-03, 3.2995370795E-01],
	[6.5550000000E+03, 8.0415053904E-01, 4.5141965971E+00, 5.9891193716E-03, 5.9370250122E-03, 3.3017681710E-01],
	[6.5600000000E+03, 8.0478341536E-01, 4.5126530192E+00, 6.0017733235E-03, 5.9494914931E-03, 3.3039984620E-01],
	[6.5650000000E+03, 8.0541914625E-01, 4.5111289669E+00, 6.0144442817E-03, 5.9619746295E-03, 3.3062279533E-01],
	[6.5700000000E+03, 8.0605489475E-01, 4.5096065891E+00, 6.0271322560E-03, 5.9744742445E-03, 3.3084566459E-01],
	[6.5750000000E+03, 8.0669066086E-01, 4.5080858826E+00, 6.0398372561E-03, 5.9869903467E-03, 3.3106845404E-01],
	[6.5800000000E+03, 8.0732644456E-01, 4.5065668443E+00, 6.0525592918E-03, 5.9995229447E-03, 3.3129116378E-01],
	[6.5850000000E+03, 8.0796224584E-01, 4.5050494712E+00, 6.0652983729E-03, 6.0120720471E-03, 3.3151379388E-01],
	[6.5900000000E+03, 8.0859806469E-01, 4.5035337600E+00, 6.0780545090E-03, 6.0246376624E-03, 3.3173634442E-01],
	[6.5950000000E+03, 8.0923390109E-01, 4.5020197078E+00, 6.0908277101E-03, 6.0372197994E-03, 3.3195881549E-01],
	[6.6000000000E+03, 8.0986975504E-01, 4.5005073115E+00, 6.1036179857E-03, 6.0498184665E-03, 3.3218120718E-01],
	[6.6050000000E+03, 8.1050562651E-01, 4.4989965680E+00, 6.1164253457E-03, 6.0624336723E-03, 3.3240351955E-01],
	[6.6100000000E+03, 8.1114151550E-01, 4.4974874743E+00, 6.1292497999E-03, 6.0750654256E-03, 3.3262575270E-01],
	[6.6150000000E+03, 8.1177742199E-01, 4.4959800272E+00, 6.1420913579E-03, 6.0877137347E-03, 3.3284790670E-01],
	[6.6200000000E+03, 8.1241334597E-01, 4.4944742239E+00, 6.1549500296E-03, 6.1003786083E-03, 3.3306998165E-01],
	[6.6250000000E+03, 8.1304928742E-01, 4.4929700611E+00, 6.1678258246E-03, 6.1130600550E-03, 3.3329197762E-01],
	[6.6300000000E+03, 8.1368524635E-01, 4.4914675360E+00, 6.1807187527E-03, 6.1257580834E-03, 3.3351389468E-01],
	[6.6350000000E+03, 8.1432122272E-01, 4.4899666455E+00, 6.1936288236E-03, 6.1384727019E-03, 3.3373573294E-01],
	[6.6400000000E+03, 8.1495721653E-01, 4.4884673866E+00, 6.2065560472E-03, 6.1512039192E-03, 3.3395749247E-01],
	[6.6450000000E+03, 8.1559322777E-01, 4.4869697563E+00, 6.2195004330E-03, 6.1639517439E-03, 3.3417917334E-01],
	[6.6500000000E+03, 8.1622925643E-01, 4.4854737516E+00, 6.2324619909E-03, 6.1767161844E-03, 3.3440077565E-01],
	[6.6550000000E+03, 8.1686530248E-01, 4.4839793695E+00, 6.2454407306E-03, 6.1894972493E-03, 3.3462229948E-01],
	[6.6600000000E+03, 8.1750136592E-01, 4.4824866070E+00, 6.2584366619E-03, 6.2022949472E-03, 3.3484374491E-01],
	[6.6650000000E+03, 8.1813744674E-01, 4.4809954612E+00, 6.2714497943E-03, 6.2151092866E-03, 3.3506511201E-01],
	[6.6700000000E+03, 8.1877652229E-01, 4.4795241598E+00, 6.2844801378E-03, 6.2279404835E-03, 3.3528640089E-01],
	[6.6750000000E+03, 8.1941572321E-01, 4.4780550895E+00, 6.2975277019E-03, 6.2407883478E-03, 3.3550761161E-01],
	[6.6800000000E+03, 8.2005494397E-01, 4.4765876005E+00, 6.3105924965E-03, 6.2536528805E-03, 3.3572874426E-01],
	[6.6850000000E+03, 8.2069418453E-01, 4.4751216898E+00, 6.3236745312E-03, 6.2665340902E-03, 3.3594979893E-01],
	[6.6900000000E+03, 8.2133344490E-01, 4.4736573546E+00, 6.3367738157E-03, 6.2794319854E-03, 3.3617077569E-01],
	[6.6950000000E+03, 8.2197272505E-01, 4.4721945921E+00, 6.3498903599E-03, 6.2923465748E-03, 3.3639167464E-01],
	[6.7000000000E+03, 8.2261202497E-01, 4.4707333993E+00, 6.3630241733E-03, 6.3052778667E-03, 3.3661249584E-01],
	[6.7050000000E+03, 8.2325134464E-01, 4.4692737735E+00, 6.3761752657E-03, 6.3182258697E-03, 3.3683323939E-01],
	[6.7100000000E+03, 8.2389068406E-01, 4.4678157117E+00, 6.3893436469E-03, 6.3311905924E-03, 3.3705390538E-01],
	[6.7150000000E+03, 8.2453004320E-01, 4.4663592111E+00, 6.4025293265E-03, 6.3441720432E-03, 3.3727449387E-01],
	[6.7200000000E+03, 8.2516942206E-01, 4.4649042689E+00, 6.4157323142E-03, 6.3571702306E-03, 3.3749500496E-01],
	[6.7250000000E+03, 8.2580882062E-01, 4.4634508824E+00, 6.4289526198E-03, 6.3701851632E-03, 3.3771543873E-01],
	[6.7300000000E+03, 8.2644823886E-01, 4.4619990485E+00, 6.4421902529E-03, 6.3832168494E-03, 3.3793579526E-01],
	[6.7350000000E+03, 8.2708767677E-01, 4.4605487646E+00, 6.4554452232E-03, 6.3962652977E-03, 3.3815607463E-01],
	[6.7400000000E+03, 8.2772713434E-01, 4.4591000279E+00, 6.4687175405E-03, 6.4093305167E-03, 3.3837627694E-01],
	[6.7450000000E+03, 8.2836661156E-01, 4.4576528354E+00, 6.4820072145E-03, 6.4224125148E-03, 3.3859640225E-01],
	[6.7500000000E+03, 8.2900610840E-01, 4.4562071846E+00, 6.4953142548E-03, 6.4355113005E-03, 3.3881645067E-01],
	[6.7550000000E+03, 8.2964562486E-01, 4.4547630725E+00, 6.5086386711E-03, 6.4486268823E-03, 3.3903642226E-01],
	[6.7600000000E+03, 8.3028516093E-01, 4.4533204964E+00, 6.5219804732E-03, 6.4617592687E-03, 3.3925631712E-01],
	[6.7650000000E+03, 8.3092471657E-01, 4.4518794535E+00, 6.5353396706E-03, 6.4749084681E-03, 3.3947613532E-01],
	[6.7700000000E+03, 8.3156429180E-01, 4.4504399411E+00, 6.5487162732E-03, 6.4880744890E-03, 3.3969587695E-01],
	[6.7750000000E+03, 8.3220543409E-01, 4.4490112026E+00, 6.5621102906E-03, 6.5012574541E-03, 3.3991554209E-01],
	[6.7800000000E+03, 8.3284811030E-01, 4.4475930073E+00, 6.5755217324E-03, 6.5144573703E-03, 3.4013513084E-01],
	[6.7850000000E+03, 8.3349080850E-01, 4.4461763090E+00, 6.5889506085E-03, 6.5276741349E-03, 3.4035464326E-01],
	[6.7900000000E+03, 8.3413352867E-01, 4.4447611051E+00, 6.6023969283E-03, 6.5409077561E-03, 3.4057407945E-01],
	[6.7950000000E+03, 8.3477627080E-01, 4.4433473929E+00, 6.6158607017E-03, 6.5541582427E-03, 3.4079343949E-01],
	[6.8000000000E+03, 8.3541903487E-01, 4.4419351698E+00, 6.6293419383E-03, 6.5674256029E-03, 3.4101272346E-01],
	[6.8050000000E+03, 8.3606182087E-01, 4.4405244330E+00, 6.6428406477E-03, 6.5807098452E-03, 3.4123193145E-01],
	[6.8100000000E+03, 8.3670462877E-01, 4.4391151799E+00, 6.6563568397E-03, 6.5940109782E-03, 3.4145106354E-01],
	[6.8150000000E+03, 8.3734745857E-01, 4.4377074079E+00, 6.6698905239E-03, 6.6073290101E-03, 3.4167011981E-01],
	[6.8200000000E+03, 8.3799031024E-01, 4.4363011143E+00, 6.6834417100E-03, 6.6206639496E-03, 3.4188910035E-01],
	[6.8250000000E+03, 8.3863318379E-01, 4.4348962965E+00, 6.6970104077E-03, 6.6340158049E-03, 3.4210800524E-01],
	[6.8300000000E+03, 8.3927607918E-01, 4.4334929518E+00, 6.7105966266E-03, 6.6473845846E-03, 3.4232683457E-01],
	[6.8350000000E+03, 8.3991899640E-01, 4.4320910777E+00, 6.7242003764E-03, 6.6607702970E-03, 3.4254558842E-01],
	[6.8400000000E+03, 8.4056193544E-01, 4.4306906715E+00, 6.7378216667E-03, 6.6741729506E-03, 3.4276426688E-01],
	[6.8450000000E+03, 8.4120489628E-01, 4.4292917307E+00, 6.7514605072E-03, 6.6875925539E-03, 3.4298287002E-01],
	[6.8500000000E+03, 8.4184787892E-01, 4.4278942525E+00, 6.7651169076E-03, 6.7010291151E-03, 3.4320139794E-01],
	[6.8550000000E+03, 8.4249088332E-01, 4.4264982345E+00, 6.7787908776E-03, 6.7144826429E-03, 3.4341985071E-01],
	[6.8600000000E+03, 8.4313390948E-01, 4.4251036740E+00, 6.7924824267E-03, 6.7279531454E-03, 3.4363822843E-01],
	[6.8650000000E+03, 8.4377695739E-01, 4.4237105684E+00, 6.8061915646E-03, 6.7414406313E-03, 3.4385653113E-01],
	[6.8700000000E+03, 8.4442002702E-01, 4.4223189152E+00, 6.8199183010E-03, 6.7549451088E-03, 3.4407475882E-01],
	[6.8750000000E+03, 8.4506311836E-01, 4.4209287118E+00, 6.8336626456E-03, 6.7684665863E-03, 3.4429291156E-01],
	[6.8800000000E+03, 8.4570623140E-01, 4.4195399557E+00, 6.8474246079E-03, 6.7820050723E-03, 3.4451098939E-01],
	[6.8850000000E+03, 8.4635149344E-01, 4.4181650380E+00, 6.8612041977E-03, 6.7955607417E-03, 3.4472899236E-01],
	[6.8900000000E+03, 8.4699769003E-01, 4.4167968485E+00, 6.8750014245E-03, 6.8091335088E-03, 3.4494692054E-01],
	[6.8950000000E+03, 8.4764391070E-01, 4.4154300749E+00, 6.8888162981E-03, 6.8227233110E-03, 3.4516477397E-01],
	[6.9000000000E+03, 8.4829015542E-01, 4.4140647145E+00, 6.9026488280E-03, 6.8363301567E-03, 3.4538255271E-01],
	[6.9050000000E+03, 8.4893642417E-01, 4.4127007648E+00, 6.9164990238E-03, 6.8499540542E-03, 3.4560025681E-01],
	[6.9100000000E+03, 8.4958271695E-01, 4.4113382235E+00, 6.9303668954E-03, 6.8635950120E-03, 3.4581788631E-01],
	[6.9150000000E+03, 8.5022903374E-01, 4.4099770880E+00, 6.9442524521E-03, 6.8772530384E-03, 3.4603544129E-01],
	[6.9200000000E+03, 8.5087537452E-01, 4.4086173559E+00, 6.9581557038E-03, 6.8909281417E-03, 3.4625292178E-01],
	[6.9250000000E+03, 8.5152173926E-01, 4.4072590247E+00, 6.9720766600E-03, 6.9046203305E-03, 3.4647032785E-01],
	[6.9300000000E+03, 8.5216812797E-01, 4.4059020919E+00, 6.9860153303E-03, 6.9183296129E-03, 3.4668765955E-01],
	[6.9350000000E+03, 8.5281454061E-01, 4.4045465551E+00, 6.9999717244E-03, 6.9320559975E-03, 3.4690491692E-01],
	[6.9400000000E+03, 8.5346097718E-01, 4.4031924119E+00, 7.0139458520E-03, 6.9457994924E-03, 3.4712210003E-01],
	[6.9450000000E+03, 8.5410743766E-01, 4.4018396598E+00, 7.0279377225E-03, 6.9595601062E-03, 3.4733920892E-01],
	[6.9500000000E+03, 8.5475392202E-01, 4.4004882964E+00, 7.0419473457E-03, 6.9733378471E-03, 3.4755624366E-01],
	[6.9550000000E+03, 8.5540043027E-01, 4.3991383193E+00, 7.0559747312E-03, 6.9871327236E-03, 3.4777320429E-01],
	[6.9600000000E+03, 8.5604696237E-01, 4.3977897260E+00, 7.0700198885E-03, 7.0009447438E-03, 3.4799009087E-01],
	[6.9650000000E+03, 8.5669351831E-01, 4.3964425142E+00, 7.0840828274E-03, 7.0147739163E-03, 3.4820690345E-01],
	[6.9700000000E+03, 8.5734009807E-01, 4.3950966815E+00, 7.0981635574E-03, 7.0286202492E-03, 3.4842364209E-01],
	[6.9750000000E+03, 8.5798670165E-01, 4.3937522253E+00, 7.1122620881E-03, 7.0424837510E-03, 3.4864030684E-01],
	[6.9800000000E+03, 8.5863332902E-01, 4.3924091435E+00, 7.1263784291E-03, 7.0563644300E-03, 3.4885689776E-01],
	[6.9850000000E+03, 8.5927998017E-01, 4.3910674335E+00, 7.1405125901E-03, 7.0702622945E-03, 3.4907341489E-01],
	[6.9900000000E+03, 8.5992665508E-01, 4.3897270929E+00, 7.1546645807E-03, 7.0841773528E-03, 3.4928985830E-01],
	[6.9950000000E+03, 8.6057499526E-01, 4.3883974346E+00, 7.1688344104E-03, 7.0981097493E-03, 3.4950622804E-01],
	[7.0000000000E+03, 8.6122473896E-01, 4.3870769428E+00, 7.1830220889E-03, 7.1120594716E-03, 3.4972252416E-01],
	[7.0050000000E+03, 8.6187450876E-01, 4.3857577908E+00, 7.1972925168E-03, 7.1260900278E-03, 3.4993874672E-01],
	[7.0100000000E+03, 8.6252430464E-01, 4.3844399763E+00, 7.2115810142E-03, 7.1401380065E-03, 3.5015489577E-01],
	[7.0150000000E+03, 8.6317412659E-01, 4.3831234969E+00, 7.2258875908E-03, 7.1542034162E-03, 3.5037097137E-01],
	[7.0200000000E+03, 8.6382397458E-01, 4.3818083505E+00, 7.2402122564E-03, 7.1682862655E-03, 3.5058697356E-01],
	[7.0250000000E+03, 8.6447384861E-01, 4.3804945345E+00, 7.2545550209E-03, 7.1823865629E-03, 3.5080290242E-01],
	[7.0300000000E+03, 8.6512374865E-01, 4.3791820469E+00, 7.2689158942E-03, 7.1965043169E-03, 3.5101875798E-01],
	[7.0350000000E+03, 8.6577367469E-01, 4.3778708853E+00, 7.2832948861E-03, 7.2106395360E-03, 3.5123454032E-01],
	[7.0400000000E+03, 8.6642362670E-01, 4.3765610473E+00, 7.2976920063E-03, 7.2247922287E-03, 3.5145024947E-01],
	[7.0450000000E+03, 8.6707360468E-01, 4.3752525308E+00, 7.3121072648E-03, 7.2389624036E-03, 3.5166588550E-01],
	[7.0500000000E+03, 8.6772360860E-01, 4.3739453334E+00, 7.3265406714E-03, 7.2531500692E-03, 3.5188144846E-01],
	[7.0550000000E+03, 8.6837363845E-01, 4.3726394530E+00, 7.3409922358E-03, 7.2673552338E-03, 3.5209693840E-01],
	[7.0600000000E+03, 8.6902369421E-01, 4.3713348872E+00, 7.3554619680E-03, 7.2815779061E-03, 3.5231235539E-01],
	[7.0650000000E+03, 8.6967377586E-01, 4.3700316337E+00, 7.3699498777E-03, 7.2958180946E-03, 3.5252769948E-01],
	[7.0700000000E+03, 8.7032388338E-01, 4.3687296905E+00, 7.3844559748E-03, 7.3100758076E-03, 3.5274297072E-01],
	[7.0750000000E+03, 8.7097401676E-01, 4.3674290551E+00, 7.3989802690E-03, 7.3243510537E-03, 3.5295816916E-01],
	[7.0800000000E+03, 8.7162417598E-01, 4.3661297253E+00, 7.4135227703E-03, 7.3386438414E-03, 3.5317329487E-01],
	[7.0850000000E+03, 8.7227436103E-01, 4.3648316990E+00, 7.4280834883E-03, 7.3529541792E-03, 3.5338834790E-01],
	[7.0900000000E+03, 8.7292457188E-01, 4.3635349739E+00, 7.4426624330E-03, 7.3672820755E-03, 3.5360332830E-01],
	[7.0950000000E+03, 8.7357480852E-01, 4.3622395478E+00, 7.4572596141E-03, 7.3816275388E-03, 3.5381823613E-01],
	[7.1000000000E+03, 8.7422507093E-01, 4.3609454185E+00, 7.4718750415E-03, 7.3959905775E-03, 3.5403307145E-01],
	[7.1050000000E+03, 8.7487545084E-01, 4.3596530874E+00, 7.4865087250E-03, 7.4103712082E-03, 3.5424783431E-01],
	[7.1100000000E+03, 8.7552878348E-01, 4.3583780985E+00, 7.5011606743E-03, 7.4247696885E-03, 3.5446252477E-01],
	[7.1150000000E+03, 8.7618214422E-01, 4.3571043785E+00, 7.5158308993E-03, 7.4391857711E-03, 3.5467714288E-01],
	[7.1200000000E+03, 8.7683553302E-01, 4.3558319251E+00, 7.5305194097E-03, 7.4536194646E-03, 3.5489168870E-01],
	[7.1250000000E+03, 8.7748894988E-01, 4.3545607361E+00, 7.5452262155E-03, 7.4680707774E-03, 3.5510616229E-01],
	[7.1300000000E+03, 8.7814239478E-01, 4.3532908095E+00, 7.5599513263E-03, 7.4825397180E-03, 3.5532056370E-01],
	[7.1350000000E+03, 8.7879586770E-01, 4.3520221431E+00, 7.5746947520E-03, 7.4970262949E-03, 3.5553489298E-01],
	[7.1400000000E+03, 8.7944936861E-01, 4.3507547348E+00, 7.5894565024E-03, 7.5115305164E-03, 3.5574915020E-01],
	[7.1450000000E+03, 8.8010289750E-01, 4.3494885824E+00, 7.6042365873E-03, 7.5260523910E-03, 3.5596333541E-01],
	[7.1500000000E+03, 8.8075645436E-01, 4.3482236839E+00, 7.6190350164E-03, 7.5405919271E-03, 3.5617744867E-01],
	[7.1550000000E+03, 8.8141003916E-01, 4.3469600370E+00, 7.6338517996E-03, 7.5551491332E-03, 3.5639149003E-01],
	[7.1600000000E+03, 8.8206365188E-01, 4.3456976397E+00, 7.6486869466E-03, 7.5697240177E-03, 3.5660545955E-01],
	[7.1650000000E+03, 8.8271729251E-01, 4.3444364899E+00, 7.6635404672E-03, 7.5843165891E-03, 3.5681935729E-01],
	[7.1700000000E+03, 8.8337096103E-01, 4.3431765855E+00, 7.6784123713E-03, 7.5989268556E-03, 3.5703318329E-01],
	[7.1750000000E+03, 8.8402465743E-01, 4.3419179244E+00, 7.6933026686E-03, 7.6135548259E-03, 3.5724693763E-01],
	[7.1800000000E+03, 8.8467838167E-01, 4.3406605044E+00, 7.7082113688E-03, 7.6282005082E-03, 3.5746062035E-01],
	[7.1850000000E+03, 8.8533213375E-01, 4.3394043236E+00, 7.7231384819E-03, 7.6428639110E-03, 3.5767423152E-01],
	[7.1900000000E+03, 8.8598591364E-01, 4.3381493798E+00, 7.7380840174E-03, 7.6575450426E-03, 3.5788777118E-01],
	[7.1950000000E+03, 8.8663972133E-01, 4.3368956709E+00, 7.7530479853E-03, 7.6722439116E-03, 3.5810123940E-01],
	[7.2000000000E+03, 8.8729355681E-01, 4.3356431950E+00, 7.7680303953E-03, 7.6869605263E-03, 3.5831463623E-01],
	[7.2050000000E+03, 8.8794742004E-01, 4.3343919498E+00, 7.7830312572E-03, 7.7016948950E-03, 3.5852796173E-01],
	[7.2100000000E+03, 8.8860131101E-01, 4.3331419333E+00, 7.7980505807E-03, 7.7164470262E-03, 3.5874121596E-01],
	[7.2150000000E+03, 8.8925522972E-01, 4.3318931436E+00, 7.8130883756E-03, 7.7312169283E-03, 3.5895439897E-01],
	[7.2200000000E+03, 8.8990964368E-01, 4.3306480539E+00, 7.8281446517E-03, 7.7460046530E-03, 3.5916751083E-01],
	[7.2250000000E+03, 8.9056664091E-01, 4.3294176984E+00, 7.8432194188E-03, 7.7608104030E-03, 3.5938055158E-01],
	[7.2300000000E+03, 8.9122366817E-01, 4.3281885433E+00, 7.8583126866E-03, 7.7756339507E-03, 3.5959352128E-01],
	[7.2350000000E+03, 8.9188072544E-01, 4.3269605865E+00, 7.8734244648E-03, 7.7904753045E-03, 3.5980642000E-01],
	[7.2400000000E+03, 8.9253781269E-01, 4.3257338261E+00, 7.8885547633E-03, 7.8053344726E-03, 3.6001924779E-01],
	[7.2450000000E+03, 8.9319492992E-01, 4.3245082600E+00, 7.9037035918E-03, 7.8202114635E-03, 3.6023200470E-01],
	[7.2500000000E+03, 8.9385207710E-01, 4.3232838863E+00, 7.9188709601E-03, 7.8351062856E-03, 3.6044469080E-01],
	[7.2550000000E+03, 8.9450925421E-01, 4.3220607030E+00, 7.9340568779E-03, 7.8500189472E-03, 3.6065730614E-01],
	[7.2600000000E+03, 8.9516646123E-01, 4.3208387081E+00, 7.9492613549E-03, 7.8649494566E-03, 3.6086985077E-01],
	[7.2650000000E+03, 8.9582369815E-01, 4.3196178997E+00, 7.9644844010E-03, 7.8798978223E-03, 3.6108232477E-01],
	[7.2700000000E+03, 8.9648096494E-01, 4.3183982758E+00, 7.9797260259E-03, 7.8948640525E-03, 3.6129472817E-01],
	[7.2750000000E+03, 8.9713826159E-01, 4.3171798343E+00, 7.9949862392E-03, 7.9098481557E-03, 3.6150706105E-01],
	[7.2800000000E+03, 8.9779558807E-01, 4.3159625735E+00, 8.0102650509E-03, 7.9248501402E-03, 3.6171932346E-01],
	[7.2850000000E+03, 8.9845294437E-01, 4.3147464912E+00, 8.0255624705E-03, 7.9398700143E-03, 3.6193151546E-01],
	[7.2900000000E+03, 8.9911033046E-01, 4.3135315856E+00, 8.0408785080E-03, 7.9549077864E-03, 3.6214363710E-01],
	[7.2950000000E+03, 8.9976774634E-01, 4.3123178547E+00, 8.0562131729E-03, 7.9699634648E-03, 3.6235568844E-01],
	[7.3000000000E+03, 9.0042519197E-01, 4.3111052966E+00, 8.0715664751E-03, 7.9850370578E-03, 3.6256766954E-01],
	[7.3050000000E+03, 9.0108266734E-01, 4.3098939093E+00, 8.0869384243E-03, 8.0001285738E-03, 3.6277958046E-01],
	[7.3100000000E+03, 9.0174017244E-01, 4.3086836909E+00, 8.1023290302E-03, 8.0152380210E-03, 3.6299142126E-01],
	[7.3150000000E+03, 9.0239770724E-01, 4.3074746395E+00, 8.1177383025E-03, 8.0303654079E-03, 3.6320319199E-01],
	[7.3200000000E+03, 9.0305527172E-01, 4.3062667532E+00, 8.1331662511E-03, 8.0455107427E-03, 3.6341489271E-01],
	[7.3250000000E+03, 9.0371286586E-01, 4.3050600300E+00, 8.1486128856E-03, 8.0606740337E-03, 3.6362652348E-01],
	[7.3300000000E+03, 9.0437048965E-01, 4.3038544680E+00, 8.1640782157E-03, 8.0758552893E-03, 3.6383808436E-01],
	[7.3350000000E+03, 9.0502814307E-01, 4.3026500654E+00, 8.1795622512E-03, 8.0910545178E-03, 3.6404957541E-01],
	[7.3400000000E+03, 9.0568858305E-01, 4.3014608874E+00, 8.1950650019E-03, 8.1062719982E-03, 3.6426099668E-01],
	[7.3450000000E+03, 9.0634932491E-01, 4.3002742247E+00, 8.2105864773E-03, 8.1215074962E-03, 3.6447234823E-01],
	[7.3500000000E+03, 9.0701009867E-01, 4.2990886965E+00, 8.2261266874E-03, 8.1367609938E-03, 3.6468363012E-01],
	[7.3550000000E+03, 9.0767090433E-01, 4.2979043010E+00, 8.2416856417E-03, 8.1520324990E-03, 3.6489484242E-01],
	[7.3600000000E+03, 9.0833174187E-01, 4.2967210364E+00, 8.2572633500E-03, 8.1673220204E-03, 3.6510598517E-01],
	[7.3650000000E+03, 9.0899261125E-01, 4.2955389008E+00, 8.2728598221E-03, 8.1826295661E-03, 3.6531705843E-01],
	[7.3700000000E+03, 9.0965351247E-01, 4.2943578923E+00, 8.2884750676E-03, 8.1979551445E-03, 3.6552806227E-01],
	[7.3750000000E+03, 9.1031444550E-01, 4.2931780092E+00, 8.3041090962E-03, 8.2132987638E-03, 3.6573899675E-01],
	[7.3800000000E+03, 9.1097541032E-01, 4.2919992496E+00, 8.3197619178E-03, 8.2286604323E-03, 3.6594986191E-01],
	[7.3850000000E+03, 9.1163640692E-01, 4.2908216116E+00, 8.3354335419E-03, 8.2440401583E-03, 3.6616065783E-01],
	[7.3900000000E+03, 9.1229743526E-01, 4.2896450935E+00, 8.3511239783E-03, 8.2594379501E-03, 3.6637138455E-01],
	[7.3950000000E+03, 9.1295849534E-01, 4.2884696934E+00, 8.3668332367E-03, 8.2748538159E-03, 3.6658204214E-01],
	[7.4000000000E+03, 9.1361958713E-01, 4.2872954095E+00, 8.3825613268E-03, 8.2902877640E-03, 3.6679263066E-01],
	[7.4050000000E+03, 9.1428071061E-01, 4.2861222400E+00, 8.3983082584E-03, 8.3057398026E-03, 3.6700315016E-01],
	[7.4100000000E+03, 9.1494186576E-01, 4.2849501831E+00, 8.4140740410E-03, 8.3212099401E-03, 3.6721360070E-01],
	[7.4150000000E+03, 9.1560305257E-01, 4.2837792369E+00, 8.4298586845E-03, 8.3366981846E-03, 3.6742398231E-01],
	[7.4200000000E+03, 9.1626427101E-01, 4.2826093998E+00, 8.4456621985E-03, 8.3522045445E-03, 3.6763429501E-01],
	[7.4250000000E+03, 9.1692552106E-01, 4.2814406698E+00, 8.4614845927E-03, 8.3677290279E-03, 3.6784453881E-01],
	[7.4300000000E+03, 9.1758680271E-01, 4.2802730451E+00, 8.4773258768E-03, 8.3832716431E-03, 3.6805471377E-01],
	[7.4350000000E+03, 9.1824811593E-01, 4.2791065241E+00, 8.4931860606E-03, 8.3988323984E-03, 3.6826481991E-01],
	[7.4400000000E+03, 9.1890946070E-01, 4.2779411049E+00, 8.5090651536E-03, 8.4144113020E-03, 3.6847485727E-01],
	[7.4450000000E+03, 9.1957083700E-01, 4.2767767857E+00, 8.5249631657E-03, 8.4300083622E-03, 3.6868482588E-01],
	[7.4500000000E+03, 9.2023224482E-01, 4.2756135648E+00, 8.5408801064E-03, 8.4456235871E-03, 3.6889472579E-01],
	[7.4550000000E+03, 9.2089457111E-01, 4.2744558074E+00, 8.5568159855E-03, 8.4612570769E-03, 3.6910455703E-01],
	[7.4600000000E+03, 9.2155907427E-01, 4.2733096885E+00, 8.5727708127E-03, 8.4769089715E-03, 3.6931431962E-01],
	[7.4650000000E+03, 9.2222361122E-01, 4.2721646446E+00, 8.5887445976E-03, 8.4925790573E-03, 3.6952401362E-01],
	[7.4700000000E+03, 9.2288818193E-01, 4.2710206739E+00, 8.6047373500E-03, 8.5082673425E-03, 3.6973363906E-01],
	[7.4750000000E+03, 9.2355278639E-01, 4.2698777746E+00, 8.6207490794E-03, 8.5239738354E-03, 3.6994319597E-01],
	[7.4800000000E+03, 9.2421742456E-01, 4.2687359451E+00, 8.6367797957E-03, 8.5396985441E-03, 3.7015268438E-01],
	[7.4850000000E+03, 9.2488209644E-01, 4.2675951836E+00, 8.6528295084E-03, 8.5554414769E-03, 3.7036210434E-01],
	[7.4900000000E+03, 9.2554680200E-01, 4.2664554884E+00, 8.6688982273E-03, 8.5712026420E-03, 3.7057145589E-01],
	[7.4950000000E+03, 9.2621154122E-01, 4.2653168579E+00, 8.6849859620E-03, 8.5869820476E-03, 3.7078073905E-01],
	[7.5000000000E+03, 9.2687631408E-01, 4.2641792902E+00, 8.7010927222E-03, 8.6027797018E-03, 3.7098995386E-01],
	[7.5050000000E+03, 9.2754112055E-01, 4.2630427838E+00, 8.7172185175E-03, 8.6185956130E-03, 3.7119910037E-01],
	[7.5100000000E+03, 9.2820596063E-01, 4.2619073369E+00, 8.7333633578E-03, 8.6344297892E-03, 3.7140817860E-01],
	[7.5150000000E+03, 9.2887083428E-01, 4.2607729478E+00, 8.7495272525E-03, 8.6502822387E-03, 3.7161718860E-01],
	[7.5200000000E+03, 9.2953574148E-01, 4.2596396149E+00, 8.7657102114E-03, 8.6661529696E-03, 3.7182613040E-01],
	[7.5250000000E+03, 9.3020068223E-01, 4.2585073364E+00, 8.7819122441E-03, 8.6820419902E-03, 3.7203500405E-01],
	[7.5300000000E+03, 9.3086565648E-01, 4.2573761107E+00, 8.7981333603E-03, 8.6979493085E-03, 3.7224380956E-01],
	[7.5350000000E+03, 9.3153066424E-01, 4.2562459361E+00, 8.8143735697E-03, 8.7138749329E-03, 3.7245254699E-01],
	[7.5400000000E+03, 9.3219570546E-01, 4.2551168109E+00, 8.8306328819E-03, 8.7298188714E-03, 3.7266121637E-01],
	[7.5450000000E+03, 9.3286078015E-01, 4.2539887335E+00, 8.8469113066E-03, 8.7457811323E-03, 3.7286981773E-01],
	[7.5500000000E+03, 9.3352588826E-01, 4.2528617021E+00, 8.8632088535E-03, 8.7617617236E-03, 3.7307835112E-01],
	[7.5550000000E+03, 9.3419102978E-01, 4.2517357152E+00, 8.8795255321E-03, 8.7777606536E-03, 3.7328681657E-01],
	[7.5600000000E+03, 9.3485620470E-01, 4.2506107710E+00, 8.8958613522E-03, 8.7937779304E-03, 3.7349521412E-01],
	[7.5650000000E+03, 9.3552141299E-01, 4.2494868680E+00, 8.9122163234E-03, 8.8098135621E-03, 3.7370354381E-01],
	[7.5700000000E+03, 9.3618665463E-01, 4.2483640044E+00, 8.9285904554E-03, 8.8258675570E-03, 3.7391180567E-01],
	[7.5750000000E+03, 9.3685282298E-01, 4.2472464196E+00, 8.9449837577E-03, 8.8419400210E-03, 3.7411999975E-01],
	[7.5800000000E+03, 9.3752116846E-01, 4.2461400299E+00, 8.9613962401E-03, 8.8580311006E-03, 3.7432812607E-01],
	[7.5850000000E+03, 9.3818954955E-01, 4.2450346578E+00, 8.9778279122E-03, 8.8741405696E-03, 3.7453618468E-01],
	[7.5900000000E+03, 9.3885796623E-01, 4.2439303015E+00, 8.9942787836E-03, 8.8902684361E-03, 3.7474417561E-01],
	[7.5950000000E+03, 9.3952641847E-01, 4.2428269595E+00, 9.0107488640E-03, 8.9064147082E-03, 3.7495209891E-01],
	[7.6000000000E+03, 9.4019490625E-01, 4.2417246302E+00, 9.0272381631E-03, 8.9225793942E-03, 3.7515995460E-01],
	[7.6050000000E+03, 9.4086342955E-01, 4.2406233120E+00, 9.0437466904E-03, 8.9387625021E-03, 3.7536774274E-01],
	[7.6100000000E+03, 9.4153198835E-01, 4.2395230033E+00, 9.0602744555E-03, 8.9549640401E-03, 3.7557546335E-01],
	[7.6150000000E+03, 9.4220058263E-01, 4.2384237025E+00, 9.0768214683E-03, 8.9711840163E-03, 3.7578311647E-01],
	[7.6200000000E+03, 9.4286921236E-01, 4.2373254080E+00, 9.0933877381E-03, 8.9874224387E-03, 3.7599070215E-01],
	[7.6250000000E+03, 9.4353787753E-01, 4.2362281183E+00, 9.1099732748E-03, 9.0036793156E-03, 3.7619822042E-01],
	[7.6300000000E+03, 9.4420657811E-01, 4.2351318317E+00, 9.1265780879E-03, 9.0199546551E-03, 3.7640567132E-01],
	[7.6350000000E+03, 9.4487531408E-01, 4.2340365467E+00, 9.1432021871E-03, 9.0362484652E-03, 3.7661305488E-01],
	[7.6400000000E+03, 9.4554408543E-01, 4.2329422618E+00, 9.1598455820E-03, 9.0525607540E-03, 3.7682037116E-01],
	[7.6450000000E+03, 9.4621289212E-01, 4.2318489754E+00, 9.1765082821E-03, 9.0688915297E-03, 3.7702762017E-01],
	[7.6500000000E+03, 9.4688173414E-01, 4.2307566858E+00, 9.1931902972E-03, 9.0852408004E-03, 3.7723480197E-01],
	[7.6550000000E+03, 9.4755061147E-01, 4.2296653916E+00, 9.2098916369E-03, 9.1016085741E-03, 3.7744191659E-01],
	[7.6600000000E+03, 9.4821952408E-01, 4.2285750911E+00, 9.2266123107E-03, 9.1179948589E-03, 3.7764896407E-01],
	[7.6650000000E+03, 9.4888847196E-01, 4.2274857829E+00, 9.2433523284E-03, 9.1343996630E-03, 3.7785594445E-01],
	[7.6700000000E+03, 9.4955745508E-01, 4.2263974653E+00, 9.2601116995E-03, 9.1508229943E-03, 3.7806285776E-01],
	[7.6750000000E+03, 9.5022647343E-01, 4.2253101369E+00, 9.2768904335E-03, 9.1672648611E-03, 3.7826970405E-01],
	[7.6800000000E+03, 9.5089552697E-01, 4.2242237961E+00, 9.2936885403E-03, 9.1837252713E-03, 3.7847648336E-01],
	[7.6850000000E+03, 9.5156461570E-01, 4.2231384414E+00, 9.3105060293E-03, 9.2002042331E-03, 3.7868319572E-01],
	[7.6900000000E+03, 9.5223373958E-01, 4.2220540711E+00, 9.3273429102E-03, 9.2167017545E-03, 3.7888984117E-01],
	[7.6950000000E+03, 9.5290289860E-01, 4.2209706839E+00, 9.3441991925E-03, 9.2332178436E-03, 3.7909641976E-01],
	[7.7000000000E+03, 9.5357485925E-01, 4.2199009313E+00, 9.3610748860E-03, 9.2497528295E-03, 3.7930293151E-01],
	[7.7050000000E+03, 9.5424713217E-01, 4.2188334010E+00, 9.3779700001E-03, 9.2663064330E-03, 3.7950937648E-01],
	[7.7100000000E+03, 9.5491944247E-01, 4.2177668330E+00, 9.3948845446E-03, 9.2828786303E-03, 3.7971575469E-01],
	[7.7150000000E+03, 9.5559179012E-01, 4.2167012259E+00, 9.4118185289E-03, 9.2994694294E-03, 3.7992206619E-01],
	[7.7200000000E+03, 9.5626417511E-01, 4.2156365781E+00, 9.4287719628E-03, 9.3160788384E-03, 3.8012831102E-01],
	[7.7250000000E+03, 9.5693659741E-01, 4.2145728881E+00, 9.4457448558E-03, 9.3327068654E-03, 3.8033448922E-01],
	[7.7300000000E+03, 9.5760905700E-01, 4.2135101546E+00, 9.4627372174E-03, 9.3493535184E-03, 3.8054060082E-01],
	[7.7350000000E+03, 9.5828155385E-01, 4.2124483759E+00, 9.4797490574E-03, 9.3660188054E-03, 3.8074664587E-01],
	[7.7400000000E+03, 9.5895408795E-01, 4.2113875507E+00, 9.4967803853E-03, 9.3827027345E-03, 3.8095262440E-01],
	[7.7450000000E+03, 9.5962665927E-01, 4.2103276774E+00, 9.5138312106E-03, 9.3994053138E-03, 3.8115853646E-01],
	[7.7500000000E+03, 9.6029926779E-01, 4.2092687546E+00, 9.5309015431E-03, 9.4161265512E-03, 3.8136438208E-01],
	[7.7550000000E+03, 9.6097191349E-01, 4.2082107808E+00, 9.5479913922E-03, 9.4328664548E-03, 3.8157016131E-01],
	[7.7600000000E+03, 9.6164459634E-01, 4.2071537546E+00, 9.5651007676E-03, 9.4496250326E-03, 3.8177587418E-01],
	[7.7650000000E+03, 9.6231731633E-01, 4.2060976745E+00, 9.5822296788E-03, 9.4664022926E-03, 3.8198152073E-01],
	[7.7700000000E+03, 9.6299007344E-01, 4.2050425391E+00, 9.5993781355E-03, 9.4831982429E-03, 3.8218710101E-01],
	[7.7750000000E+03, 9.6366286763E-01, 4.2039883468E+00, 9.6165461472E-03, 9.5000128915E-03, 3.8239261505E-01],
	[7.7800000000E+03, 9.6433569890E-01, 4.2029350963E+00, 9.6337337235E-03, 9.5168462463E-03, 3.8259806289E-01],
	[7.7850000000E+03, 9.6500856721E-01, 4.2018827861E+00, 9.6509408740E-03, 9.5336983155E-03, 3.8280344458E-01],
	[7.7900000000E+03, 9.6568147254E-01, 4.2008314148E+00, 9.6681676082E-03, 9.5505691069E-03, 3.8300876015E-01],
	[7.7950000000E+03, 9.6635441488E-01, 4.1997809809E+00, 9.6854139358E-03, 9.5674586287E-03, 3.8321400964E-01],
	[7.8000000000E+03, 9.6702739421E-01, 4.1987314829E+00, 9.7026798663E-03, 9.5843668887E-03, 3.8341919309E-01],
	[7.8050000000E+03, 9.6770041049E-01, 4.1976829195E+00, 9.7199654093E-03, 9.6012938950E-03, 3.8362431055E-01],
	[7.8100000000E+03, 9.6837346371E-01, 4.1966352892E+00, 9.7372705744E-03, 9.6182396556E-03, 3.8382936205E-01],
	[7.8150000000E+03, 9.6904655385E-01, 4.1955885907E+00, 9.7545953711E-03, 9.6352041784E-03, 3.8403434764E-01],
	[7.8200000000E+03, 9.6972008395E-01, 4.1945446006E+00, 9.7719398090E-03, 9.6521875209E-03, 3.8423926735E-01],
	[7.8250000000E+03, 9.7039629508E-01, 4.1935131905E+00, 9.7893038976E-03, 9.6691899663E-03, 3.8444412122E-01],
	[7.8300000000E+03, 9.7107254535E-01, 4.1924826926E+00, 9.8066876466E-03, 9.6862111999E-03, 3.8464890930E-01],
	[7.8350000000E+03, 9.7174883473E-01, 4.1914531055E+00, 9.8240910656E-03, 9.7032512297E-03, 3.8485363162E-01],
	[7.8400000000E+03, 9.7242516322E-01, 4.1904244279E+00, 9.8415141640E-03, 9.7203100637E-03, 3.8505828823E-01],
	[7.8450000000E+03, 9.7310153078E-01, 4.1893966584E+00, 9.8589569514E-03, 9.7373877098E-03, 3.8526287916E-01],
	[7.8500000000E+03, 9.7377793739E-01, 4.1883697955E+00, 9.8764194374E-03, 9.7544841760E-03, 3.8546740447E-01],
	[7.8550000000E+03, 9.7445438303E-01, 4.1873438379E+00, 9.8939016316E-03, 9.7715994703E-03, 3.8567186417E-01],
	[7.8600000000E+03, 9.7513086767E-01, 4.1863187842E+00, 9.9114035435E-03, 9.7887336006E-03, 3.8587625833E-01],
	[7.8650000000E+03, 9.7580739130E-01, 4.1852946331E+00, 9.9289251826E-03, 9.8058865749E-03, 3.8608058698E-01],
	[7.8700000000E+03, 9.7648395389E-01, 4.1842713832E+00, 9.9464665586E-03, 9.8230584012E-03, 3.8628485015E-01],
	[7.8750000000E+03, 9.7716055542E-01, 4.1832490331E+00, 9.9640276809E-03, 9.8402490873E-03, 3.8648904790E-01],
	[7.8800000000E+03, 9.7783719586E-01, 4.1822275814E+00, 9.9816085592E-03, 9.8574586413E-03, 3.8669318025E-01],
	[7.8850000000E+03, 9.7851387520E-01, 4.1812070269E+00, 9.9992092029E-03, 9.8746870711E-03, 3.8689724726E-01],
	[7.8900000000E+03, 9.7919059341E-01, 4.1801873681E+00, 1.0016829622E-02, 9.8919343846E-03, 3.8710124896E-01],
	[7.8950000000E+03, 9.7986735046E-01, 4.1791686037E+00, 1.0034469825E-02, 9.9092005897E-03, 3.8730518540E-01],
	[7.9000000000E+03, 9.8054414635E-01, 4.1781507323E+00, 1.0052129822E-02, 9.9264856945E-03, 3.8750905661E-01],
	[7.9050000000E+03, 9.8122098103E-01, 4.1771337526E+00, 1.0069809623E-02, 9.9437897067E-03, 3.8771286264E-01],
	[7.9100000000E+03, 9.8189785450E-01, 4.1761176633E+00, 1.0087509238E-02, 9.9611126345E-03, 3.8791660352E-01],
	[7.9150000000E+03, 9.8257476673E-01, 4.1751024630E+00, 1.0105228675E-02, 9.9784544855E-03, 3.8812027930E-01],
	[7.9200000000E+03, 9.8325171770E-01, 4.1740881503E+00, 1.0122967944E-02, 9.9958152679E-03, 3.8832389002E-01],
	[7.9250000000E+03, 9.8392870738E-01, 4.1730747240E+00, 1.0140727055E-02, 1.0013194989E-02, 3.8852743572E-01],
	[7.9300000000E+03, 9.8460573575E-01, 4.1720621827E+00, 1.0158506018E-02, 1.0030593658E-02, 3.8873091639E-01],
	[7.9350000000E+03, 9.8528280279E-01, 4.1710505251E+00, 1.0176304841E-02, 1.0048011282E-02, 3.8893433205E-01],
	[7.9400000000E+03, 9.8595990849E-01, 4.1700397498E+00, 1.0194123535E-02, 1.0065447869E-02, 3.8913768274E-01],
	[7.9450000000E+03, 9.8663705280E-01, 4.1690298555E+00, 1.0211962108E-02, 1.0082903426E-02, 3.8934096847E-01],
	[7.9500000000E+03, 9.8731715502E-01, 4.1680332409E+00, 1.0229820572E-02, 1.0100378340E-02, 3.8954418927E-01],
	[7.9550000000E+03, 9.8799743181E-01, 4.1670380588E+00, 1.0247698934E-02, 1.0117872261E-02, 3.8974734516E-01],
	[7.9600000000E+03, 9.8867774943E-01, 4.1660437394E+00, 1.0265597204E-02, 1.0135385178E-02, 3.8995043617E-01],
	[7.9650000000E+03, 9.8935810786E-01, 4.1650502814E+00, 1.0283515393E-02, 1.0152917100E-02, 3.9015346232E-01],
	[7.9700000000E+03, 9.9003850708E-01, 4.1640576835E+00, 1.0301453509E-02, 1.0170468034E-02, 3.9035642363E-01],
	[7.9750000000E+03, 9.9071894707E-01, 4.1630659445E+00, 1.0319411563E-02, 1.0188037988E-02, 3.9055932014E-01],
	[7.9800000000E+03, 9.9139942780E-01, 4.1620750631E+00, 1.0337389563E-02, 1.0205626970E-02, 3.9076215186E-01],
	[7.9850000000E+03, 9.9207994925E-01, 4.1610850379E+00, 1.0355387519E-02, 1.0223234989E-02, 3.9096491882E-01],
	[7.9900000000E+03, 9.9276051140E-01, 4.1600958677E+00, 1.0373405441E-02, 1.0240862051E-02, 3.9116762105E-01],
	[7.9950000000E+03, 9.9344111422E-01, 4.1591075513E+00, 1.0391443338E-02, 1.0258508165E-02, 3.9137025856E-01],
	[8.0000000000E+03, 9.9412175770E-01, 4.1581200873E+00, 1.0409501220E-02, 1.0276173339E-02, 3.9157283139E-01],
	[8.0050000000E+03, 9.9480244180E-01, 4.1571334745E+00, 1.0427898124E-02, 1.0294168479E-02, 3.9177533956E-01],
	[8.0100000000E+03, 9.9548316650E-01, 4.1561477117E+00, 1.0446315966E-02, 1.0312183584E-02, 3.9197778310E-01],
	[8.0150000000E+03, 9.9616393179E-01, 4.1551627975E+00, 1.0464754756E-02, 1.0330218664E-02, 3.9218016202E-01],
	[8.0200000000E+03, 9.9684473764E-01, 4.1541787308E+00, 1.0483214506E-02, 1.0348273727E-02, 3.9238247636E-01],
	[8.0250000000E+03, 9.9752558402E-01, 4.1531955102E+00, 1.0501695225E-02, 1.0366348783E-02, 3.9258472613E-01],
	[8.0300000000E+03, 9.9820647092E-01, 4.1522131345E+00, 1.0520196924E-02, 1.0384443840E-02, 3.9278691138E-01],
	[8.0350000000E+03, 9.9888739831E-01, 4.1512316024E+00, 1.0538719614E-02, 1.0402558906E-02, 3.9298903211E-01],
	[8.0400000000E+03, 9.9956836616E-01, 4.1502509128E+00, 1.0557263306E-02, 1.0420693992E-02, 3.9319108836E-01],
	[8.0450000000E+03, 1.0002493745E+00, 4.1492710643E+00, 1.0575828009E-02, 1.0438849105E-02, 3.9339308015E-01],
	[8.0500000000E+03, 1.0009304232E+00, 4.1482920557E+00, 1.0594413736E-02, 1.0457024254E-02, 3.9359500750E-01],
	[8.0550000000E+03, 1.0016115123E+00, 4.1473138858E+00, 1.0613020496E-02, 1.0475219449E-02, 3.9379687045E-01],
	[8.0600000000E+03, 1.0022926418E+00, 4.1463365533E+00, 1.0631648300E-02, 1.0493434697E-02, 3.9399866902E-01],
	[8.0650000000E+03, 1.0029738117E+00, 4.1453600570E+00, 1.0650297159E-02, 1.0511670009E-02, 3.9420040323E-01],
	[8.0700000000E+03, 1.0036550218E+00, 4.1443843957E+00, 1.0668967083E-02, 1.0529925392E-02, 3.9440207311E-01],
	[8.0750000000E+03, 1.0043374226E+00, 4.1434142609E+00, 1.0687658083E-02, 1.0548201013E-02, 3.9460367869E-01],
	[8.0800000000E+03, 1.0050217842E+00, 4.1424527791E+00, 1.0706370170E-02, 1.0566496988E-02, 3.9480521998E-01],
	[8.0850000000E+03, 1.0057061885E+00, 4.1414921150E+00, 1.0725103354E-02, 1.0584813062E-02, 3.9500669703E-01],
	[8.0900000000E+03, 1.0063906352E+00, 4.1405322674E+00, 1.0743857645E-02, 1.0603149246E-02, 3.9520810985E-01],
	[8.0950000000E+03, 1.0070751244E+00, 4.1395732351E+00, 1.0762633056E-02, 1.0621505548E-02, 3.9540945846E-01],
	[8.1000000000E+03, 1.0077596561E+00, 4.1386150169E+00, 1.0781429595E-02, 1.0639881977E-02, 3.9561074290E-01],
	[8.1050000000E+03, 1.0084442302E+00, 4.1376576116E+00, 1.0800247274E-02, 1.0658278541E-02, 3.9581196320E-01],
	[8.1100000000E+03, 1.0091288468E+00, 4.1367010180E+00, 1.0819086103E-02, 1.0676695249E-02, 3.9601311937E-01],
	[8.1150000000E+03, 1.0098135057E+00, 4.1357452350E+00, 1.0837946093E-02, 1.0695132111E-02, 3.9621421145E-01],
	[8.1200000000E+03, 1.0104982070E+00, 4.1347902613E+00, 1.0856827254E-02, 1.0713589135E-02, 3.9641523945E-01],
	[8.1250000000E+03, 1.0111829507E+00, 4.1338360958E+00, 1.0875729598E-02, 1.0732066329E-02, 3.9661620342E-01],
	[8.1300000000E+03, 1.0118677367E+00, 4.1328827372E+00, 1.0894653135E-02, 1.0750563703E-02, 3.9681710337E-01],
	[8.1350000000E+03, 1.0125525649E+00, 4.1319301845E+00, 1.0913597875E-02, 1.0769081265E-02, 3.9701793932E-01],
	[8.1400000000E+03, 1.0132374355E+00, 4.1309784364E+00, 1.0932563829E-02, 1.0787619024E-02, 3.9721871132E-01],
	[8.1450000000E+03, 1.0139223483E+00, 4.1300274917E+00, 1.0951551007E-02, 1.0806176989E-02, 3.9741941938E-01],
	[8.1500000000E+03, 1.0146073033E+00, 4.1290773494E+00, 1.0970559421E-02, 1.0824755169E-02, 3.9762006352E-01],
	[8.1550000000E+03, 1.0152923006E+00, 4.1281280081E+00, 1.0989589080E-02, 1.0843353572E-02, 3.9782064379E-01],
	[8.1600000000E+03, 1.0159773400E+00, 4.1271794668E+00, 1.1008639996E-02, 1.0861972207E-02, 3.9802116020E-01],
	[8.1650000000E+03, 1.0166624216E+00, 4.1262317243E+00, 1.1027712179E-02, 1.0880611083E-02, 3.9822161278E-01],
	[8.1700000000E+03, 1.0173475453E+00, 4.1252847794E+00, 1.1046805640E-02, 1.0899270208E-02, 3.9842200155E-01],
	[8.1750000000E+03, 1.0180327112E+00, 4.1243386310E+00, 1.1065920389E-02, 1.0917949592E-02, 3.9862232655E-01],
	[8.1800000000E+03, 1.0187179191E+00, 4.1233932779E+00, 1.1085056436E-02, 1.0936649243E-02, 3.9882258781E-01],
	[8.1850000000E+03, 1.0194031691E+00, 4.1224487189E+00, 1.1104213793E-02, 1.0955369169E-02, 3.9902278534E-01],
	[8.1900000000E+03, 1.0200884611E+00, 4.1215049530E+00, 1.1123392470E-02, 1.0974109381E-02, 3.9922291918E-01],
	[8.1950000000E+03, 1.0207737952E+00, 4.1205619789E+00, 1.1142592478E-02, 1.0992869885E-02, 3.9942298935E-01],
	[8.2000000000E+03, 1.0214591713E+00, 4.1196197955E+00, 1.1161813827E-02, 1.1011650692E-02, 3.9962299588E-01],
	[8.2050000000E+03, 1.0221457701E+00, 4.1186830124E+00, 1.1181056527E-02, 1.1030451979E-02, 3.9982293880E-01],
	[8.2100000000E+03, 1.0228343270E+00, 4.1177544848E+00, 1.1200320590E-02, 1.1049273865E-02, 4.0002281813E-01],
	[8.2150000000E+03, 1.0235229282E+00, 4.1168267316E+00, 1.1219606026E-02, 1.1068116081E-02, 4.0022263391E-01],
	[8.2200000000E+03, 1.0242115735E+00, 4.1158997518E+00, 1.1238912846E-02, 1.1086978636E-02, 4.0042238615E-01],
	[8.2250000000E+03, 1.0249002629E+00, 4.1149735442E+00, 1.1258241060E-02, 1.1105861539E-02, 4.0062207490E-01],
	[8.2300000000E+03, 1.0255889965E+00, 4.1140481077E+00, 1.1277590678E-02, 1.1124764799E-02, 4.0082170016E-01],
	[8.2350000000E+03, 1.0262777742E+00, 4.1131234412E+00, 1.1296961712E-02, 1.1143688424E-02, 4.0102126199E-01],
	[8.2400000000E+03, 1.0269665960E+00, 4.1121995436E+00, 1.1316354172E-02, 1.1162632424E-02, 4.0122076039E-01],
	[8.2450000000E+03, 1.0276554618E+00, 4.1112764137E+00, 1.1335768068E-02, 1.1181596806E-02, 4.0142019540E-01],
	[8.2500000000E+03, 1.0283443717E+00, 4.1103540506E+00, 1.1355203411E-02, 1.1200581579E-02, 4.0161956704E-01],
	[8.2550000000E+03, 1.0290333256E+00, 4.1094324530E+00, 1.1374660212E-02, 1.1219586753E-02, 4.0181887535E-01],
	[8.2600000000E+03, 1.0297223234E+00, 4.1085116199E+00, 1.1394138482E-02, 1.1238612335E-02, 4.0201812036E-01],
	[8.2650000000E+03, 1.0304113652E+00, 4.1075915502E+00, 1.1413638230E-02, 1.1257658336E-02, 4.0221730208E-01],
	[8.2700000000E+03, 1.0311004510E+00, 4.1066722428E+00, 1.1433159467E-02, 1.1276724762E-02, 4.0241642055E-01],
	[8.2750000000E+03, 1.0317895807E+00, 4.1057536966E+00, 1.1452702205E-02, 1.1295811623E-02, 4.0261547579E-01],
	[8.2800000000E+03, 1.0324787543E+00, 4.1048359105E+00, 1.1472266452E-02, 1.1314918928E-02, 4.0281446784E-01],
	[8.2850000000E+03, 1.0331679717E+00, 4.1039188835E+00, 1.1491852222E-02, 1.1334046685E-02, 4.0301339672E-01],
	[8.2900000000E+03, 1.0338572330E+00, 4.1030026143E+00, 1.1511459522E-02, 1.1353194903E-02, 4.0321226247E-01],
	[8.2950000000E+03, 1.0345465381E+00, 4.1020871021E+00, 1.1531088365E-02, 1.1372363591E-02, 4.0341106510E-01],
	[8.3000000000E+03, 1.0352358870E+00, 4.1011723456E+00, 1.1550738761E-02, 1.1391552757E-02, 4.0360980464E-01],
	[8.3050000000E+03, 1.0359252797E+00, 4.1002583438E+00, 1.1570410720E-02, 1.1410762410E-02, 4.0380848114E-01],
	[8.3100000000E+03, 1.0366147161E+00, 4.0993450956E+00, 1.1590104254E-02, 1.1429992558E-02, 4.0400709460E-01],
	[8.3150000000E+03, 1.0373041963E+00, 4.0984326000E+00, 1.1609819371E-02, 1.1449243211E-02, 4.0420564507E-01],
	[8.3200000000E+03, 1.0379937201E+00, 4.0975208558E+00, 1.1629556084E-02, 1.1468514376E-02, 4.0440413257E-01],
	[8.3250000000E+03, 1.0386832877E+00, 4.0966098621E+00, 1.1649314403E-02, 1.1487806063E-02, 4.0460255713E-01],
	[8.3300000000E+03, 1.0393728988E+00, 4.0956996177E+00, 1.1669094337E-02, 1.1507118280E-02, 4.0480091877E-01],
	[8.3350000000E+03, 1.0400625537E+00, 4.0947901215E+00, 1.1688895899E-02, 1.1526451036E-02, 4.0499921753E-01],
	[8.3400000000E+03, 1.0407552803E+00, 4.0938926809E+00, 1.1708719098E-02, 1.1545804802E-02, 4.0519745344E-01],
	[8.3450000000E+03, 1.0414481472E+00, 4.0929963272E+00, 1.1728563944E-02, 1.1565179141E-02, 4.0539562652E-01],
	[8.3500000000E+03, 1.0421410599E+00, 4.0921007065E+00, 1.1748430450E-02, 1.1584574047E-02, 4.0559373680E-01],
	[8.3550000000E+03, 1.0428340185E+00, 4.0912058177E+00, 1.1768318624E-02, 1.1603989529E-02, 4.0579178432E-01],
	[8.3600000000E+03, 1.0435270228E+00, 4.0903116598E+00, 1.1788228477E-02, 1.1623425595E-02, 4.0598976909E-01],
	[8.3650000000E+03, 1.0442200729E+00, 4.0894182318E+00, 1.1808160021E-02, 1.1642882254E-02, 4.0618769115E-01],
	[8.3700000000E+03, 1.0449131687E+00, 4.0885255327E+00, 1.1828113266E-02, 1.1662359515E-02, 4.0638555054E-01],
	[8.3750000000E+03, 1.0456063103E+00, 4.0876335613E+00, 1.1848088221E-02, 1.1681857386E-02, 4.0658334727E-01],
	[8.3800000000E+03, 1.0462994975E+00, 4.0867423168E+00, 1.1868084899E-02, 1.1701375876E-02, 4.0678108137E-01],
	[8.3850000000E+03, 1.0469927304E+00, 4.0858517980E+00, 1.1888103308E-02, 1.1720914994E-02, 4.0697875288E-01],
	[8.3900000000E+03, 1.0476860090E+00, 4.0849620039E+00, 1.1908143461E-02, 1.1740474747E-02, 4.0717636183E-01],
	[8.3950000000E+03, 1.0483793331E+00, 4.0840729335E+00, 1.1928205367E-02, 1.1760055145E-02, 4.0737390823E-01],
	[8.4000000000E+03, 1.0490727029E+00, 4.0831845859E+00, 1.1948289037E-02, 1.1779656196E-02, 4.0757139214E-01],
	[8.4050000000E+03, 1.0497661182E+00, 4.0822969599E+00, 1.1968394481E-02, 1.1799277910E-02, 4.0776881356E-01],
	[8.4100000000E+03, 1.0504595791E+00, 4.0814100546E+00, 1.1988521711E-02, 1.1818920293E-02, 4.0796617250E-01],
	[8.4150000000E+03, 1.0511530855E+00, 4.0805238689E+00, 1.2008670736E-02, 1.1838583356E-02, 4.0816346898E-01],
	[8.4200000000E+03, 1.0518466374E+00, 4.0796384019E+00, 1.2028841567E-02, 1.1858267106E-02, 4.0836070301E-01],
	[8.4250000000E+03, 1.0525402347E+00, 4.0787536525E+00, 1.2049034215E-02, 1.1877971553E-02, 4.0855787460E-01],
	[8.4300000000E+03, 1.0532338775E+00, 4.0778696197E+00, 1.2069248689E-02, 1.1897696704E-02, 4.0875498379E-01],
	[8.4350000000E+03, 1.0539275658E+00, 4.0769863025E+00, 1.2089485002E-02, 1.1917442569E-02, 4.0895203057E-01],
	[8.4400000000E+03, 1.0546212994E+00, 4.0761037000E+00, 1.2109743163E-02, 1.1937209155E-02, 4.0914901497E-01],
	[8.4450000000E+03, 1.0553150784E+00, 4.0752218110E+00, 1.2130023182E-02, 1.1956996472E-02, 4.0934593701E-01],
	[8.4500000000E+03, 1.0560089028E+00, 4.0743406347E+00, 1.2150325071E-02, 1.1976804528E-02, 4.0954279670E-01],
	[8.4550000000E+03, 1.0567027725E+00, 4.0734601700E+00, 1.2170648840E-02, 1.1996633332E-02, 4.0973959405E-01],
	[8.4600000000E+03, 1.0573966875E+00, 4.0725804159E+00, 1.2190994499E-02, 1.2016482891E-02, 4.0993632909E-01],
	[8.4650000000E+03, 1.0580906478E+00, 4.0717013715E+00, 1.2211362059E-02, 1.2036353216E-02, 4.1013300184E-01],
	[8.4700000000E+03, 1.0587850716E+00, 4.0708245311E+00, 1.2231751531E-02, 1.2056244380E-02, 4.1032961230E-01],
	[8.4750000000E+03, 1.0594822723E+00, 4.0699581539E+00, 1.2252162924E-02, 1.2076156768E-02, 4.1052616050E-01],
	[8.4800000000E+03, 1.0601795205E+00, 4.0690924719E+00, 1.2272596250E-02, 1.2096089949E-02, 4.1072264645E-01],
	[8.4850000000E+03, 1.0608768161E+00, 4.0682274841E+00, 1.2293051519E-02, 1.2116043931E-02, 4.1091907017E-01],
	[8.4900000000E+03, 1.0615741592E+00, 4.0673631897E+00, 1.2313528741E-02, 1.2136018723E-02, 4.1111543168E-01],
	[8.4950000000E+03, 1.0622715497E+00, 4.0664995875E+00, 1.2334027927E-02, 1.2156014333E-02, 4.1131173100E-01],
	[8.5000000000E+03, 1.0629689876E+00, 4.0656366767E+00, 1.2354549088E-02, 1.2176030771E-02, 4.1150796813E-01],
	[8.5050000000E+03, 1.0636664728E+00, 4.0647744563E+00, 1.2375092234E-02, 1.2196068044E-02, 4.1170414311E-01],
	[8.5100000000E+03, 1.0643640054E+00, 4.0639129253E+00, 1.2395657376E-02, 1.2216126161E-02, 4.1190025594E-01],
	[8.5150000000E+03, 1.0650615853E+00, 4.0630520828E+00, 1.2416244523E-02, 1.2236205131E-02, 4.1209630665E-01],
	[8.5200000000E+03, 1.0657592125E+00, 4.0621919279E+00, 1.2436853687E-02, 1.2256304962E-02, 4.1229229525E-01],
	[8.5250000000E+03, 1.0664568870E+00, 4.0613324595E+00, 1.2457484879E-02, 1.2276425662E-02, 4.1248822176E-01],
	[8.5300000000E+03, 1.0671546087E+00, 4.0604736767E+00, 1.2478138108E-02, 1.2296567241E-02, 4.1268408620E-01],
	[8.5350000000E+03, 1.0678523776E+00, 4.0596155786E+00, 1.2498813385E-02, 1.2316729706E-02, 4.1287988859E-01],
	[8.5400000000E+03, 1.0685501937E+00, 4.0587581643E+00, 1.2519510721E-02, 1.2336913066E-02, 4.1307562894E-01],
	[8.5450000000E+03, 1.0692480570E+00, 4.0579014327E+00, 1.2540230126E-02, 1.2357117330E-02, 4.1327130726E-01],
	[8.5500000000E+03, 1.0699459674E+00, 4.0570453830E+00, 1.2560971610E-02, 1.2377342506E-02, 4.1346692359E-01],
	[8.5550000000E+03, 1.0706439249E+00, 4.0561900141E+00, 1.2581735185E-02, 1.2397588603E-02, 4.1366247794E-01],
	[8.5600000000E+03, 1.0713419296E+00, 4.0553353252E+00, 1.2602520860E-02, 1.2417855628E-02, 4.1385797032E-01],
	[8.5650000000E+03, 1.0720399813E+00, 4.0544813154E+00, 1.2623328647E-02, 1.2438143592E-02, 4.1405340076E-01],
	[8.5700000000E+03, 1.0727380800E+00, 4.0536279836E+00, 1.2644158555E-02, 1.2458452501E-02, 4.1424876926E-01],
	[8.5750000000E+03, 1.0734362258E+00, 4.0527753290E+00, 1.2665010596E-02, 1.2478782365E-02, 4.1444407586E-01],
	[8.5800000000E+03, 1.0741344186E+00, 4.0519233506E+00, 1.2685884779E-02, 1.2499133192E-02, 4.1463932056E-01],
	[8.5850000000E+03, 1.0748326583E+00, 4.0510720475E+00, 1.2706781115E-02, 1.2519504990E-02, 4.1483450339E-01],
	[8.5900000000E+03, 1.0755309450E+00, 4.0502214188E+00, 1.2727699615E-02, 1.2539897769E-02, 4.1502962437E-01],
	[8.5950000000E+03, 1.0762292786E+00, 4.0493714635E+00, 1.2748640289E-02, 1.2560311535E-02, 4.1522468351E-01],
	[8.6000000000E+03, 1.0769276592E+00, 4.0485221808E+00, 1.2769603148E-02, 1.2580746299E-02, 4.1541968083E-01],
	[8.6050000000E+03, 1.0776260866E+00, 4.0476735696E+00, 1.2790588202E-02, 1.2601202068E-02, 4.1561461636E-01],
	[8.6100000000E+03, 1.0783273051E+00, 4.0468350090E+00, 1.2811595461E-02, 1.2621679318E-02, 4.1580949010E-01],
	[8.6150000000E+03, 1.0790290051E+00, 4.0459985860E+00, 1.2832624937E-02, 1.2642177666E-02, 4.1600430208E-01],
	[8.6200000000E+03, 1.0797307541E+00, 4.0451628210E+00, 1.2853676639E-02, 1.2662697048E-02, 4.1619905231E-01],
	[8.6250000000E+03, 1.0804325522E+00, 4.0443277132E+00, 1.2874750578E-02, 1.2683237471E-02, 4.1639374083E-01],
	[8.6300000000E+03, 1.0811343993E+00, 4.0434932616E+00, 1.2895846765E-02, 1.2703798945E-02, 4.1658836763E-01],
	[8.6350000000E+03, 1.0818362954E+00, 4.0426594653E+00, 1.2916965210E-02, 1.2724381477E-02, 4.1678293275E-01],
	[8.6400000000E+03, 1.0825382405E+00, 4.0418263235E+00, 1.2938105924E-02, 1.2744985077E-02, 4.1697743621E-01],
	[8.6450000000E+03, 1.0832402346E+00, 4.0409938353E+00, 1.2959268917E-02, 1.2765609752E-02, 4.1717187801E-01],
	[8.6500000000E+03, 1.0839422775E+00, 4.0401619997E+00, 1.2980454199E-02, 1.2786255511E-02, 4.1736625818E-01],
	[8.6550000000E+03, 1.0846443695E+00, 4.0393308159E+00, 1.3001661781E-02, 1.2806922362E-02, 4.1756057675E-01],
	[8.6600000000E+03, 1.0853465102E+00, 4.0385002830E+00, 1.3022891674E-02, 1.2827610314E-02, 4.1775483372E-01],
	[8.6650000000E+03, 1.0860486999E+00, 4.0376704000E+00, 1.3044143887E-02, 1.2848319376E-02, 4.1794902912E-01],
	[8.6700000000E+03, 1.0867509384E+00, 4.0368411662E+00, 1.3065418432E-02, 1.2869049555E-02, 4.1814316296E-01],
	[8.6750000000E+03, 1.0874532256E+00, 4.0360125807E+00, 1.3086715319E-02, 1.2889800860E-02, 4.1833723528E-01],
	[8.6800000000E+03, 1.0881555617E+00, 4.0351846425E+00, 1.3108034559E-02, 1.2910573299E-02, 4.1853124608E-01],
	[8.6850000000E+03, 1.0888579466E+00, 4.0343573508E+00, 1.3129376161E-02, 1.2931366882E-02, 4.1872519538E-01],
	[8.6900000000E+03, 1.0895603801E+00, 4.0335307046E+00, 1.3150740137E-02, 1.2952181616E-02, 4.1891908321E-01],
	[8.6950000000E+03, 1.0902628624E+00, 4.0327047032E+00, 1.3172126496E-02, 1.2973017509E-02, 4.1911290959E-01],
	[8.7000000000E+03, 1.0909653934E+00, 4.0318793457E+00, 1.3193535250E-02, 1.2993874571E-02, 4.1930667452E-01],
	[8.7050000000E+03, 1.0916679730E+00, 4.0310546312E+00, 1.3214966408E-02, 1.3014752809E-02, 4.1950037805E-01],
	[8.7100000000E+03, 1.0923706012E+00, 4.0302305587E+00, 1.3236419982E-02, 1.3035652231E-02, 4.1969402017E-01],
	[8.7150000000E+03, 1.0930732781E+00, 4.0294071275E+00, 1.3257895981E-02, 1.3056572847E-02, 4.1988760092E-01],
	[8.7200000000E+03, 1.0937760036E+00, 4.0285843367E+00, 1.3279394416E-02, 1.3077514665E-02, 4.2008112031E-01],
	[8.7250000000E+03, 1.0944787776E+00, 4.0277621854E+00, 1.3300915298E-02, 1.3098477692E-02, 4.2027457836E-01],
	[8.7300000000E+03, 1.0951816002E+00, 4.0269406728E+00, 1.3322458637E-02, 1.3119461938E-02, 4.2046797510E-01],
	[8.7350000000E+03, 1.0958844712E+00, 4.0261197979E+00, 1.3344024444E-02, 1.3140467411E-02, 4.2066131054E-01],
	[8.7400000000E+03, 1.0965873908E+00, 4.0252995600E+00, 1.3365612729E-02, 1.3161494119E-02, 4.2085458470E-01],
	[8.7450000000E+03, 1.0972908584E+00, 4.0244815921E+00, 1.3387223502E-02, 1.3182542159E-02, 4.2104779760E-01],
	[8.7500000000E+03, 1.0979970797E+00, 4.0236730982E+00, 1.3408856773E-02, 1.3203611939E-02, 4.2124094927E-01],
	[8.7550000000E+03, 1.0987033518E+00, 4.0228652284E+00, 1.3430512555E-02, 1.3224702981E-02, 4.2143403972E-01],
	[8.7600000000E+03, 1.0994096745E+00, 4.0220579820E+00, 1.3452190856E-02, 1.3245815294E-02, 4.2162706897E-01],
	[8.7650000000E+03, 1.1001160478E+00, 4.0212513580E+00, 1.3473891687E-02, 1.3266948887E-02, 4.2182003704E-01],
	[8.7700000000E+03, 1.1008224718E+00, 4.0204453556E+00, 1.3495615059E-02, 1.3288103769E-02, 4.2201294396E-01],
	[8.7750000000E+03, 1.1015289464E+00, 4.0196399741E+00, 1.3517360983E-02, 1.3309279946E-02, 4.2220578975E-01],
	[8.7800000000E+03, 1.1022354716E+00, 4.0188352125E+00, 1.3539129467E-02, 1.3330477428E-02, 4.2239857441E-01],
	[8.7850000000E+03, 1.1029420473E+00, 4.0180310701E+00, 1.3560920524E-02, 1.3351696224E-02, 4.2259129798E-01],
	[8.7900000000E+03, 1.1036486735E+00, 4.0172275459E+00, 1.3582734164E-02, 1.3372936340E-02, 4.2278396048E-01],
	[8.7950000000E+03, 1.1043553502E+00, 4.0164246393E+00, 1.3604570396E-02, 1.3394197786E-02, 4.2297656192E-01],
	[8.8000000000E+03, 1.1050620774E+00, 4.0156223494E+00, 1.3626429232E-02, 1.3415480571E-02, 4.2316910233E-01],
	[8.8050000000E+03, 1.1057688550E+00, 4.0148206752E+00, 1.3648310682E-02, 1.3436784701E-02, 4.2336158173E-01],
	[8.8100000000E+03, 1.1064756831E+00, 4.0140196161E+00, 1.3670214756E-02, 1.3458110187E-02, 4.2355400013E-01],
	[8.8150000000E+03, 1.1071825615E+00, 4.0132191712E+00, 1.3692141464E-02, 1.3479457035E-02, 4.2374635756E-01],
	[8.8200000000E+03, 1.1078894903E+00, 4.0124193397E+00, 1.3714090818E-02, 1.3500825254E-02, 4.2393865404E-01],
	[8.8250000000E+03, 1.1085964695E+00, 4.0116201207E+00, 1.3736062828E-02, 1.3522214853E-02, 4.2413088959E-01],
	[8.8300000000E+03, 1.1093034990E+00, 4.0108215135E+00, 1.3758057503E-02, 1.3543625840E-02, 4.2432306423E-01],
	[8.8350000000E+03, 1.1100105788E+00, 4.0100235172E+00, 1.3780074855E-02, 1.3565058224E-02, 4.2451517798E-01],
	[8.8400000000E+03, 1.1107177088E+00, 4.0092261310E+00, 1.3802114894E-02, 1.3586512011E-02, 4.2470723087E-01],
	[8.8450000000E+03, 1.1114248891E+00, 4.0084293542E+00, 1.3824177631E-02, 1.3607987212E-02, 4.2489922291E-01],
	[8.8500000000E+03, 1.1121321197E+00, 4.0076331858E+00, 1.3846263075E-02, 1.3629483833E-02, 4.2509115412E-01],
	[8.8550000000E+03, 1.1128394004E+00, 4.0068376251E+00, 1.3868371237E-02, 1.3651001884E-02, 4.2528302453E-01],
	[8.8600000000E+03, 1.1135467313E+00, 4.0060426713E+00, 1.3890502128E-02, 1.3672541373E-02, 4.2547483418E-01],
	[8.8650000000E+03, 1.1142541123E+00, 4.0052483236E+00, 1.3912655758E-02, 1.3694102307E-02, 4.2566658320E-01],
	[8.8700000000E+03, 1.1149615435E+00, 4.0044545812E+00, 1.3934832138E-02, 1.3715684696E-02, 4.2585827162E-01],
	[8.8750000000E+03, 1.1156690247E+00, 4.0036614432E+00, 1.3957031278E-02, 1.3737288547E-02, 4.2604989944E-01],
	[8.8800000000E+03, 1.1163765561E+00, 4.0028689089E+00, 1.3979253188E-02, 1.3758913869E-02, 4.2624146666E-01],
	[8.8850000000E+03, 1.1170841437E+00, 4.0020769969E+00, 1.4001497878E-02, 1.3780560671E-02, 4.2643297330E-01],
	[8.8900000000E+03, 1.1177950076E+00, 4.0012957712E+00, 1.4023765360E-02, 1.3802229573E-02, 4.2662441936E-01],
	[8.8950000000E+03, 1.1185059238E+00, 4.0005151371E+00, 1.4046055644E-02, 1.3823919972E-02, 4.2681580485E-01],
	[8.9000000000E+03, 1.1192168923E+00, 3.9997350939E+00, 1.4068368740E-02, 1.3845631879E-02, 4.2700712978E-01],
	[8.9050000000E+03, 1.1199279130E+00, 3.9989556407E+00, 1.4090704658E-02, 1.3867365300E-02, 4.2719839415E-01],
	[8.9100000000E+03, 1.1206389859E+00, 3.9981767769E+00, 1.4113063409E-02, 1.3889120245E-02, 4.2738959797E-01],
	[8.9150000000E+03, 1.1213501110E+00, 3.9973985015E+00, 1.4135445003E-02, 1.3910896721E-02, 4.2758074124E-01],
	[8.9200000000E+03, 1.1220612882E+00, 3.9966208139E+00, 1.4157849451E-02, 1.3932694737E-02, 4.2777182398E-01],
	[8.9250000000E+03, 1.1227725176E+00, 3.9958437133E+00, 1.4180276764E-02, 1.3954514301E-02, 4.2796284620E-01],
	[8.9300000000E+03, 1.1234837991E+00, 3.9950671989E+00, 1.4202726951E-02, 1.3976355421E-02, 4.2815380789E-01],
	[8.9350000000E+03, 1.1241951326E+00, 3.9942912699E+00, 1.4225200023E-02, 1.3998218105E-02, 4.2834470907E-01],
	[8.9400000000E+03, 1.1249065182E+00, 3.9935159256E+00, 1.4247695990E-02, 1.4020102363E-02, 4.2853554975E-01],
	[8.9450000000E+03, 1.1256179559E+00, 3.9927411651E+00, 1.4270214863E-02, 1.4042008201E-02, 4.2872632993E-01],
	[8.9500000000E+03, 1.1263294455E+00, 3.9919669878E+00, 1.4292756652E-02, 1.4063935628E-02, 4.2891704963E-01],
	[8.9550000000E+03, 1.1270409871E+00, 3.9911933929E+00, 1.4315321368E-02, 1.4085884652E-02, 4.2910770884E-01],
	[8.9600000000E+03, 1.1277525807E+00, 3.9904203795E+00, 1.4337909021E-02, 1.4107855283E-02, 4.2929830758E-01],
	[8.9650000000E+03, 1.1284642262E+00, 3.9896479470E+00, 1.4360519621E-02, 1.4129847526E-02, 4.2948884585E-01],
	[8.9700000000E+03, 1.1291759236E+00, 3.9888760946E+00, 1.4383153180E-02, 1.4151861392E-02, 4.2967932367E-01],
	[8.9750000000E+03, 1.1298876729E+00, 3.9881048215E+00, 1.4405809706E-02, 1.4173896888E-02, 4.2986974104E-01],
	[8.9800000000E+03, 1.1305994740E+00, 3.9873341270E+00, 1.4428489211E-02, 1.4195954023E-02, 4.3006009797E-01],
	[8.9850000000E+03, 1.1313113270E+00, 3.9865640103E+00, 1.4451191705E-02, 1.4218032804E-02, 4.3025039446E-01],
	[8.9900000000E+03, 1.1320232318E+00, 3.9857944706E+00, 1.4473917199E-02, 1.4240133240E-02, 4.3044063054E-01],
	[8.9950000000E+03, 1.1327351883E+00, 3.9850255072E+00, 1.4496665702E-02, 1.4262255339E-02, 4.3063080619E-01],
	[9.0000000000E+03, 1.1334471966E+00, 3.9842571194E+00, 1.4519437226E-02, 1.4284399109E-02, 4.3082092145E-01],
	[9.0050000000E+03, 1.1341592566E+00, 3.9834893064E+00, 1.4542387495E-02, 1.4306715267E-02, 4.3101097630E-01],
	[9.0100000000E+03, 1.1348713683E+00, 3.9827220674E+00, 1.4565361209E-02, 1.4329053492E-02, 4.3120097077E-01],
	[9.0150000000E+03, 1.1355835317E+00, 3.9819554018E+00, 1.4588358377E-02, 1.4351413792E-02, 4.3139090485E-01],
	[9.0200000000E+03, 1.1362957468E+00, 3.9811893087E+00, 1.4611379012E-02, 1.4373796177E-02, 4.3158077856E-01],
	[9.0250000000E+03, 1.1370080135E+00, 3.9804237874E+00, 1.4634423124E-02, 1.4396200653E-02, 4.3177059191E-01],
	[9.0300000000E+03, 1.1377216201E+00, 3.9796626853E+00, 1.4657490723E-02, 1.4418627489E-02, 4.3196034490E-01],
	[9.0350000000E+03, 1.1384372560E+00, 3.9789080493E+00, 1.4680581821E-02, 1.4441076831E-02, 4.3215003755E-01],
	[9.0400000000E+03, 1.1391529457E+00, 3.9781539738E+00, 1.4703696428E-02, 1.4463548294E-02, 4.3233966987E-01],
	[9.0450000000E+03, 1.1398686892E+00, 3.9774004580E+00, 1.4726834556E-02, 1.4486041887E-02, 4.3252924185E-01],
	[9.0500000000E+03, 1.1405844865E+00, 3.9766475013E+00, 1.4749996215E-02, 1.4508557618E-02, 4.3271875352E-01],
	[9.0550000000E+03, 1.1413003376E+00, 3.9758951028E+00, 1.4773181415E-02, 1.4531095496E-02, 4.3290820488E-01],
	[9.0600000000E+03, 1.1420162424E+00, 3.9751432620E+00, 1.4796390168E-02, 1.4553655530E-02, 4.3309759594E-01],
	[9.0650000000E+03, 1.1427322009E+00, 3.9743919780E+00, 1.4819622484E-02, 1.4576237727E-02, 4.3328692671E-01],
	[9.0700000000E+03, 1.1434482131E+00, 3.9736412501E+00, 1.4842878375E-02, 1.4598842096E-02, 4.3347619719E-01],
	[9.0750000000E+03, 1.1441642790E+00, 3.9728910777E+00, 1.4866157851E-02, 1.4621468646E-02, 4.3366540741E-01],
	[9.0800000000E+03, 1.1448803985E+00, 3.9721414600E+00, 1.4889460923E-02, 1.4644117386E-02, 4.3385455736E-01],
	[9.0850000000E+03, 1.1455965716E+00, 3.9713923963E+00, 1.4912787601E-02, 1.4666788324E-02, 4.3404364706E-01],
	[9.0900000000E+03, 1.1463127983E+00, 3.9706438859E+00, 1.4936137897E-02, 1.4689481467E-02, 4.3423267652E-01],
	[9.0950000000E+03, 1.1470290785E+00, 3.9698959280E+00, 1.4959511822E-02, 1.4712196826E-02, 4.3442164575E-01],
	[9.1000000000E+03, 1.1477454123E+00, 3.9691485220E+00, 1.4982909385E-02, 1.4734934408E-02, 4.3461055475E-01],
	[9.1050000000E+03, 1.1484617996E+00, 3.9684016671E+00, 1.5006330599E-02, 1.4757694222E-02, 4.3479940353E-01],
	[9.1100000000E+03, 1.1491782404E+00, 3.9676553627E+00, 1.5029775473E-02, 1.4780476276E-02, 4.3498819212E-01],
	[9.1150000000E+03, 1.1498947347E+00, 3.9669096080E+00, 1.5053244019E-02, 1.4803280579E-02, 4.3517692051E-01],
	[9.1200000000E+03, 1.1506112823E+00, 3.9661644024E+00, 1.5076736247E-02, 1.4826107139E-02, 4.3536558871E-01],
	[9.1250000000E+03, 1.1513278834E+00, 3.9654197450E+00, 1.5100252168E-02, 1.4848955964E-02, 4.3555419674E-01],
	[9.1300000000E+03, 1.1520445379E+00, 3.9646756353E+00, 1.5123791794E-02, 1.4871827064E-02, 4.3574274461E-01],
	[9.1350000000E+03, 1.1527612457E+00, 3.9639320725E+00, 1.5147355134E-02, 1.4894720447E-02, 4.3593123232E-01],
	[9.1400000000E+03, 1.1534780069E+00, 3.9631890559E+00, 1.5170942200E-02, 1.4917636120E-02, 4.3611965989E-01],
	[9.1450000000E+03, 1.1541948213E+00, 3.9624465848E+00, 1.5194553002E-02, 1.4940574093E-02, 4.3630802732E-01],
	[9.1500000000E+03, 1.1549116891E+00, 3.9617046585E+00, 1.5218187551E-02, 1.4963534374E-02, 4.3649633463E-01],
	[9.1550000000E+03, 1.1556286101E+00, 3.9609632764E+00, 1.5241845859E-02, 1.4986516972E-02, 4.3668458183E-01],
	[9.1600000000E+03, 1.1563455843E+00, 3.9602224376E+00, 1.5265527935E-02, 1.5009521894E-02, 4.3687276893E-01],
	[9.1650000000E+03, 1.1570626117E+00, 3.9594821416E+00, 1.5289233791E-02, 1.5032549150E-02, 4.3706089593E-01],
	[9.1700000000E+03, 1.1577796924E+00, 3.9587423876E+00, 1.5312963437E-02, 1.5055598748E-02, 4.3724896285E-01],
	[9.1750000000E+03, 1.1584979071E+00, 3.9580062515E+00, 1.5336716884E-02, 1.5078670923E-02, 4.3743696970E-01],
	[9.1800000000E+03, 1.1592184024E+00, 3.9572769853E+00, 1.5360494143E-02, 1.5101765928E-02, 4.3762491649E-01],
	[9.1850000000E+03, 1.1599389530E+00, 3.9565482504E+00, 1.5384295225E-02, 1.5124883304E-02, 4.3781280323E-01],
	[9.1900000000E+03, 1.1606595591E+00, 3.9558200462E+00, 1.5408120141E-02, 1.5148023058E-02, 4.3800062994E-01],
	[9.1950000000E+03, 1.1613802205E+00, 3.9550923721E+00, 1.5431968901E-02, 1.5171185199E-02, 4.3818839661E-01],
	[9.2000000000E+03, 1.1621009372E+00, 3.9543652272E+00, 1.5455841516E-02, 1.5194369736E-02, 4.3837610327E-01],
	[9.2050000000E+03, 1.1628217093E+00, 3.9536386110E+00, 1.5479737997E-02, 1.5217576677E-02, 4.3856374991E-01],
	[9.2100000000E+03, 1.1635425366E+00, 3.9529125228E+00, 1.5503658354E-02, 1.5240806031E-02, 4.3875133657E-01],
	[9.2150000000E+03, 1.1642634192E+00, 3.9521869619E+00, 1.5527602599E-02, 1.5264057805E-02, 4.3893886324E-01],
	[9.2200000000E+03, 1.1649843570E+00, 3.9514619277E+00, 1.5551570743E-02, 1.5287332008E-02, 4.3912632993E-01],
	[9.2250000000E+03, 1.1657053499E+00, 3.9507374194E+00, 1.5575562795E-02, 1.5310628649E-02, 4.3931373667E-01],
	[9.2300000000E+03, 1.1664263981E+00, 3.9500134365E+00, 1.5599578767E-02, 1.5333947736E-02, 4.3950108345E-01],
	[9.2350000000E+03, 1.1671475014E+00, 3.9492899782E+00, 1.5623618670E-02, 1.5357289277E-02, 4.3968837029E-01],
	[9.2400000000E+03, 1.1678686599E+00, 3.9485670439E+00, 1.5647682514E-02, 1.5380653281E-02, 4.3987559721E-01],
	[9.2450000000E+03, 1.1685898734E+00, 3.9478446329E+00, 1.5671770311E-02, 1.5404039757E-02, 4.4006276420E-01],
	[9.2500000000E+03, 1.1693111420E+00, 3.9471227445E+00, 1.5695882070E-02, 1.5427448712E-02, 4.4024987129E-01],
	[9.2550000000E+03, 1.1700324657E+00, 3.9464013782E+00, 1.5720017803E-02, 1.5450880154E-02, 4.4043691849E-01],
	[9.2600000000E+03, 1.1707538443E+00, 3.9456805332E+00, 1.5744177521E-02, 1.5474334094E-02, 4.4062390580E-01],
	[9.2650000000E+03, 1.1714752780E+00, 3.9449602089E+00, 1.5768361233E-02, 1.5497810537E-02, 4.4081083324E-01],
	[9.2700000000E+03, 1.1721967666E+00, 3.9442404046E+00, 1.5792568952E-02, 1.5521309494E-02, 4.4099770082E-01],
	[9.2750000000E+03, 1.1729183102E+00, 3.9435211197E+00, 1.5816800688E-02, 1.5544830973E-02, 4.4118450855E-01],
	[9.2800000000E+03, 1.1736399087E+00, 3.9428023535E+00, 1.5841056451E-02, 1.5568374981E-02, 4.4137125645E-01],
	[9.2850000000E+03, 1.1743615621E+00, 3.9420841053E+00, 1.5865336253E-02, 1.5591941527E-02, 4.4155794452E-01],
	[9.2900000000E+03, 1.1750832704E+00, 3.9413663746E+00, 1.5889640103E-02, 1.5615530620E-02, 4.4174457278E-01],
	[9.2950000000E+03, 1.1758050335E+00, 3.9406491606E+00, 1.5913968014E-02, 1.5639142268E-02, 4.4193114124E-01],
	[9.3000000000E+03, 1.1765268514E+00, 3.9399324627E+00, 1.5938319995E-02, 1.5662776479E-02, 4.4211764990E-01],
	[9.3050000000E+03, 1.1772487241E+00, 3.9392162803E+00, 1.5962696058E-02, 1.5686433261E-02, 4.4230409879E-01],
	[9.3100000000E+03, 1.1779706516E+00, 3.9385006128E+00, 1.5987096213E-02, 1.5710112623E-02, 4.4249048792E-01],
	[9.3150000000E+03, 1.1786926338E+00, 3.9377854593E+00, 1.6011520470E-02, 1.5733814574E-02, 4.4267681729E-01],
	[9.3200000000E+03, 1.1794146707E+00, 3.9370708194E+00, 1.6035968842E-02, 1.5757539121E-02, 4.4286308692E-01],
	[9.3250000000E+03, 1.1801394140E+00, 3.9363638776E+00, 1.6060441338E-02, 1.5781286863E-02, 4.4304929682E-01],
	[9.3300000000E+03, 1.1808649140E+00, 3.9356593375E+00, 1.6084937969E-02, 1.5805057376E-02, 4.4323544700E-01],
	[9.3350000000E+03, 1.1815904710E+00, 3.9349553009E+00, 1.6109458746E-02, 1.5828850514E-02, 4.4342153748E-01],
	[9.3400000000E+03, 1.1823160849E+00, 3.9342517671E+00, 1.6134003680E-02, 1.5852666286E-02, 4.4360756827E-01],
	[9.3450000000E+03, 1.1830417557E+00, 3.9335487355E+00, 1.6158572782E-02, 1.5876504699E-02, 4.4379353937E-01],
	[9.3500000000E+03, 1.1837674833E+00, 3.9328462054E+00, 1.6183166061E-02, 1.5900365763E-02, 4.4397945081E-01],
	[9.3550000000E+03, 1.1844932679E+00, 3.9321441764E+00, 1.6207783530E-02, 1.5924249484E-02, 4.4416530259E-01],
	[9.3600000000E+03, 1.1852191092E+00, 3.9314426477E+00, 1.6232425199E-02, 1.5948155872E-02, 4.4435109473E-01],
	[9.3650000000E+03, 1.1859450073E+00, 3.9307416186E+00, 1.6257091078E-02, 1.5972084935E-02, 4.4453682724E-01],
	[9.3700000000E+03, 1.1866709623E+00, 3.9300410887E+00, 1.6281781178E-02, 1.5996036681E-02, 4.4472250013E-01],
	[9.3750000000E+03, 1.1873969739E+00, 3.9293410572E+00, 1.6306495510E-02, 1.6020011118E-02, 4.4490811342E-01],
	[9.3800000000E+03, 1.1881230423E+00, 3.9286415236E+00, 1.6331234086E-02, 1.6044008255E-02, 4.4509366712E-01],
	[9.3850000000E+03, 1.1888491674E+00, 3.9279424872E+00, 1.6355996914E-02, 1.6068028100E-02, 4.4527916123E-01],
	[9.3900000000E+03, 1.1895753491E+00, 3.9272439474E+00, 1.6380784007E-02, 1.6092070661E-02, 4.4546459578E-01],
	[9.3950000000E+03, 1.1903015875E+00, 3.9265459036E+00, 1.6405595375E-02, 1.6116135947E-02, 4.4564997077E-01],
	[9.4000000000E+03, 1.1910278825E+00, 3.9258483552E+00, 1.6430431029E-02, 1.6140223966E-02, 4.4583528623E-01],
	[9.4050000000E+03, 1.1917542341E+00, 3.9251513015E+00, 1.6455290979E-02, 1.6164334726E-02, 4.4602054215E-01],
	[9.4100000000E+03, 1.1924806422E+00, 3.9244547419E+00, 1.6480175237E-02, 1.6188468236E-02, 4.4620573856E-01],
	[9.4150000000E+03, 1.1932071069E+00, 3.9237586759E+00, 1.6505083812E-02, 1.6212624503E-02, 4.4639087547E-01],
	[9.4200000000E+03, 1.1939336281E+00, 3.9230631028E+00, 1.6530016717E-02, 1.6236803536E-02, 4.4657595288E-01],
	[9.4250000000E+03, 1.1946602058E+00, 3.9223680221E+00, 1.6554973960E-02, 1.6261005343E-02, 4.4676097082E-01],
	[9.4300000000E+03, 1.1953868400E+00, 3.9216734330E+00, 1.6579955554E-02, 1.6285229932E-02, 4.4694592930E-01],
	[9.4350000000E+03, 1.1961135306E+00, 3.9209793350E+00, 1.6604961509E-02, 1.6309477313E-02, 4.4713082833E-01],
	[9.4400000000E+03, 1.1968402776E+00, 3.9202857275E+00, 1.6629991836E-02, 1.6333747492E-02, 4.4731566792E-01],
	[9.4450000000E+03, 1.1975670810E+00, 3.9195926099E+00, 1.6655046545E-02, 1.6358040479E-02, 4.4750044809E-01],
	[9.4500000000E+03, 1.1982939407E+00, 3.9188999816E+00, 1.6680125647E-02, 1.6382356281E-02, 4.4768516885E-01],
	[9.4550000000E+03, 1.1990208568E+00, 3.9182078419E+00, 1.6705229153E-02, 1.6406694906E-02, 4.4786983021E-01],
	[9.4600000000E+03, 1.1997478292E+00, 3.9175161903E+00, 1.6730357074E-02, 1.6431056364E-02, 4.4805443219E-01],
	[9.4650000000E+03, 1.2004748579E+00, 3.9168250261E+00, 1.6755509420E-02, 1.6455440662E-02, 4.4823897480E-01],
	[9.4700000000E+03, 1.2012019428E+00, 3.9161343489E+00, 1.6780686203E-02, 1.6479847808E-02, 4.4842345805E-01],
	[9.4750000000E+03, 1.2019317329E+00, 3.9154509937E+00, 1.6805887432E-02, 1.6504278432E-02, 4.4860788196E-01],
	[9.4800000000E+03, 1.2026623288E+00, 3.9147700462E+00, 1.6831113118E-02, 1.6528732099E-02, 4.4879224654E-01],
	[9.4850000000E+03, 1.2033929831E+00, 3.9140895762E+00, 1.6856363273E-02, 1.6553208642E-02, 4.4897655181E-01],
	[9.4900000000E+03, 1.2041236960E+00, 3.9134095829E+00, 1.6881637907E-02, 1.6577708071E-02, 4.4916079777E-01],
	[9.4950000000E+03, 1.2048544673E+00, 3.9127300659E+00, 1.6906937031E-02, 1.6602230392E-02, 4.4934498445E-01],
	[9.5000000000E+03, 1.2055852970E+00, 3.9120510245E+00, 1.6932260655E-02, 1.6626775615E-02, 4.4952911185E-01],
	[9.5050000000E+03, 1.2063161851E+00, 3.9113724581E+00, 1.6957608791E-02, 1.6651343747E-02, 4.4971317999E-01],
	[9.5100000000E+03, 1.2070471317E+00, 3.9106943662E+00, 1.6982981448E-02, 1.6675934797E-02, 4.4989718888E-01],
	[9.5150000000E+03, 1.2077781365E+00, 3.9100167482E+00, 1.7008378638E-02, 1.6700548773E-02, 4.5008113854E-01],
	[9.5200000000E+03, 1.2085091997E+00, 3.9093396035E+00, 1.7033800371E-02, 1.6725185682E-02, 4.5026502898E-01],
	[9.5250000000E+03, 1.2092403212E+00, 3.9086629315E+00, 1.7059246658E-02, 1.6749845535E-02, 4.5044886022E-01],
	[9.5300000000E+03, 1.2099715010E+00, 3.9079867317E+00, 1.7084717511E-02, 1.6774528337E-02, 4.5063263227E-01],
	[9.5350000000E+03, 1.2107027390E+00, 3.9073110034E+00, 1.7110212938E-02, 1.6799234099E-02, 4.5081634514E-01],
	[9.5400000000E+03, 1.2114340352E+00, 3.9066357462E+00, 1.7135732952E-02, 1.6823962827E-02, 4.5099999885E-01],
	[9.5450000000E+03, 1.2121653896E+00, 3.9059609593E+00, 1.7161277563E-02, 1.6848714530E-02, 4.5118359340E-01],
	[9.5500000000E+03, 1.2128968022E+00, 3.9052866423E+00, 1.7186846782E-02, 1.6873489216E-02, 4.5136712883E-01],
	[9.5550000000E+03, 1.2136282730E+00, 3.9046127946E+00, 1.7212440618E-02, 1.6898286894E-02, 4.5155060513E-01],
	[9.5600000000E+03, 1.2143598018E+00, 3.9039394156E+00, 1.7238059084E-02, 1.6923107571E-02, 4.5173402233E-01],
	[9.5650000000E+03, 1.2150913888E+00, 3.9032665047E+00, 1.7263702190E-02, 1.6947951256E-02, 4.5191738044E-01],
	[9.5700000000E+03, 1.2158230338E+00, 3.9025940614E+00, 1.7289369947E-02, 1.6972817957E-02, 4.5210067947E-01],
	[9.5750000000E+03, 1.2165547369E+00, 3.9019220851E+00, 1.7315062364E-02, 1.6997707682E-02, 4.5228391944E-01],
	[9.5800000000E+03, 1.2172864980E+00, 3.9012505752E+00, 1.7340779454E-02, 1.7022620439E-02, 4.5246710036E-01],
	[9.5850000000E+03, 1.2180183170E+00, 3.9005795311E+00, 1.7366521226E-02, 1.7047556236E-02, 4.5265022224E-01],
	[9.5900000000E+03, 1.2187501941E+00, 3.8999089524E+00, 1.7392287691E-02, 1.7072515082E-02, 4.5283328511E-01],
	[9.5950000000E+03, 1.2194821290E+00, 3.8992388384E+00, 1.7418078861E-02, 1.7097496984E-02, 4.5301628897E-01],
	[9.6000000000E+03, 1.2202141219E+00, 3.8985691885E+00, 1.7443894745E-02, 1.7122501952E-02, 4.5319923384E-01],
	[9.6050000000E+03, 1.2209461727E+00, 3.8979000022E+00, 1.7469735354E-02, 1.7147529992E-02, 4.5338211974E-01],
	[9.6100000000E+03, 1.2216782814E+00, 3.8972312790E+00, 1.7495600700E-02, 1.7172581113E-02, 4.5356494668E-01],
	[9.6150000000E+03, 1.2224104478E+00, 3.8965630183E+00, 1.7521490793E-02, 1.7197655323E-02, 4.5374771467E-01],
	[9.6200000000E+03, 1.2231426721E+00, 3.8958952194E+00, 1.7547405643E-02, 1.7222752630E-02, 4.5393042372E-01],
	[9.6250000000E+03, 1.2238759368E+00, 3.8952302976E+00, 1.7573345262E-02, 1.7247873285E-02, 4.5411307387E-01],
	[9.6300000000E+03, 1.2246117192E+00, 3.8945718754E+00, 1.7599309659E-02, 1.7273017663E-02, 4.5429566511E-01],
	[9.6350000000E+03, 1.2253475617E+00, 3.8939139062E+00, 1.7625298847E-02, 1.7298185166E-02, 4.5447819746E-01],
	[9.6400000000E+03, 1.2260834642E+00, 3.8932563895E+00, 1.7651312834E-02, 1.7323375803E-02, 4.5466067094E-01],
	[9.6450000000E+03, 1.2268194267E+00, 3.8925993246E+00, 1.7677351633E-02, 1.7348589582E-02, 4.5484308557E-01],
	[9.6500000000E+03, 1.2275554492E+00, 3.8919427111E+00, 1.7703415253E-02, 1.7373826509E-02, 4.5502544135E-01],
	[9.6550000000E+03, 1.2282915317E+00, 3.8912865484E+00, 1.7729503706E-02, 1.7399086595E-02, 4.5520773831E-01],
	[9.6600000000E+03, 1.2290276742E+00, 3.8906308359E+00, 1.7755617002E-02, 1.7424369847E-02, 4.5538997645E-01],
	[9.6650000000E+03, 1.2297638765E+00, 3.8899755732E+00, 1.7781755151E-02, 1.7449676273E-02, 4.5557215580E-01],
	[9.6700000000E+03, 1.2305001388E+00, 3.8893207596E+00, 1.7807918165E-02, 1.7475005880E-02, 4.5575427637E-01],
	[9.6750000000E+03, 1.2312364609E+00, 3.8886663946E+00, 1.7834106055E-02, 1.7500358678E-02, 4.5593633817E-01],
	[9.6800000000E+03, 1.2319728429E+00, 3.8880124778E+00, 1.7860318830E-02, 1.7525734674E-02, 4.5611834122E-01],
	[9.6850000000E+03, 1.2327092846E+00, 3.8873590085E+00, 1.7886556502E-02, 1.7551133877E-02, 4.5630028553E-01],
	[9.6900000000E+03, 1.2334457862E+00, 3.8867059862E+00, 1.7912819081E-02, 1.7576556294E-02, 4.5648217113E-01],
	[9.6950000000E+03, 1.2341823475E+00, 3.8860534105E+00, 1.7939106578E-02, 1.7602001933E-02, 4.5666399802E-01],
	[9.7000000000E+03, 1.2349189685E+00, 3.8854012806E+00, 1.7965419004E-02, 1.7627470803E-02, 4.5684576621E-01],
	[9.7050000000E+03, 1.2356556493E+00, 3.8847495962E+00, 1.7991756369E-02, 1.7652962912E-02, 4.5702747573E-01],
	[9.7100000000E+03, 1.2363923897E+00, 3.8840983567E+00, 1.8018118684E-02, 1.7678478267E-02, 4.5720912652E-01],
	[9.7150000000E+03, 1.2371291898E+00, 3.8834475615E+00, 1.8044505960E-02, 1.7704016877E-02, 4.5739071858E-01],
	[9.7200000000E+03, 1.2378660495E+00, 3.8827972101E+00, 1.8070918207E-02, 1.7729578750E-02, 4.5757225191E-01],
	[9.7250000000E+03, 1.2386029689E+00, 3.8821473020E+00, 1.8097355436E-02, 1.7755163893E-02, 4.5775372652E-01],
	[9.7300000000E+03, 1.2393399478E+00, 3.8814978367E+00, 1.8123817658E-02, 1.7780772316E-02, 4.5793514240E-01],
	[9.7350000000E+03, 1.2400769862E+00, 3.8808488135E+00, 1.8150304883E-02, 1.7806404026E-02, 4.5811649957E-01],
	[9.7400000000E+03, 1.2408140842E+00, 3.8802002321E+00, 1.8176817123E-02, 1.7832059030E-02, 4.5829779802E-01],
	[9.7450000000E+03, 1.2415512417E+00, 3.8795520919E+00, 1.8203354387E-02, 1.7857737338E-02, 4.5847903776E-01],
	[9.7500000000E+03, 1.2422884586E+00, 3.8789043923E+00, 1.8229916686E-02, 1.7883438956E-02, 4.5866021879E-01],
	[9.7550000000E+03, 1.2430257351E+00, 3.8782571328E+00, 1.8256504032E-02, 1.7909163894E-02, 4.5884134111E-01],
	[9.7600000000E+03, 1.2437630709E+00, 3.8776103130E+00, 1.8283116434E-02, 1.7934912159E-02, 4.5902240473E-01],
	[9.7650000000E+03, 1.2445004661E+00, 3.8769639321E+00, 1.8309753904E-02, 1.7960683758E-02, 4.5920340964E-01],
	[9.7700000000E+03, 1.2452379207E+00, 3.8763179899E+00, 1.8336416452E-02, 1.7986478701E-02, 4.5938435586E-01],
	[9.7750000000E+03, 1.2459754347E+00, 3.8756724857E+00, 1.8363104088E-02, 1.8012296996E-02, 4.5956524339E-01],
	[9.7800000000E+03, 1.2467140550E+00, 3.8750298696E+00, 1.8389816825E-02, 1.8038138921E-02, 4.5974607222E-01],
	[9.7850000000E+03, 1.2474551759E+00, 3.8743933966E+00, 1.8416554671E-02, 1.8064004851E-02, 4.5992684237E-01],
	[9.7900000000E+03, 1.2481963584E+00, 3.8737573533E+00, 1.8443317638E-02, 1.8089894160E-02, 4.6010755383E-01],
	[9.7950000000E+03, 1.2489376026E+00, 3.8731217391E+00, 1.8470105736E-02, 1.8115806856E-02, 4.6028820661E-01],
	[9.8000000000E+03, 1.2496789083E+00, 3.8724865534E+00, 1.8496918977E-02, 1.8141742947E-02, 4.6046880072E-01],
	[9.8050000000E+03, 1.2504202755E+00, 3.8718517959E+00, 1.8523757370E-02, 1.8167702442E-02, 4.6064933616E-01],
	[9.8100000000E+03, 1.2511617043E+00, 3.8712174659E+00, 1.8550620927E-02, 1.8193685347E-02, 4.6082981292E-01],
	[9.8150000000E+03, 1.2519031945E+00, 3.8705835629E+00, 1.8577509658E-02, 1.8219691671E-02, 4.6101023102E-01],
	[9.8200000000E+03, 1.2526447463E+00, 3.8699500866E+00, 1.8604423574E-02, 1.8245721423E-02, 4.6119059046E-01],
	[9.8250000000E+03, 1.2533863594E+00, 3.8693170363E+00, 1.8631362685E-02, 1.8271774610E-02, 4.6137089124E-01],
	[9.8300000000E+03, 1.2541280340E+00, 3.8686844115E+00, 1.8658327002E-02, 1.8297851239E-02, 4.6155113337E-01],
	[9.8350000000E+03, 1.2548697700E+00, 3.8680522119E+00, 1.8685316536E-02, 1.8323951320E-02, 4.6173131684E-01],
	[9.8400000000E+03, 1.2556115673E+00, 3.8674204367E+00, 1.8712331297E-02, 1.8350074860E-02, 4.6191144167E-01],
	[9.8450000000E+03, 1.2563534259E+00, 3.8667890856E+00, 1.8739371296E-02, 1.8376221867E-02, 4.6209150786E-01],
	[9.8500000000E+03, 1.2570953459E+00, 3.8661581581E+00, 1.8766436544E-02, 1.8402392348E-02, 4.6227151542E-01],
	[9.8550000000E+03, 1.2578373271E+00, 3.8655276536E+00, 1.8793527052E-02, 1.8428586313E-02, 4.6245146434E-01],
	[9.8600000000E+03, 1.2585793696E+00, 3.8648975717E+00, 1.8820642829E-02, 1.8454803769E-02, 4.6263135463E-01],
	[9.8650000000E+03, 1.2593214734E+00, 3.8642679119E+00, 1.8847783887E-02, 1.8481044723E-02, 4.6281118629E-01],
	[9.8700000000E+03, 1.2600636383E+00, 3.8636386736E+00, 1.8874950237E-02, 1.8507309184E-02, 4.6299095934E-01],
	[9.8750000000E+03, 1.2608058644E+00, 3.8630098563E+00, 1.8902141888E-02, 1.8533597160E-02, 4.6317067377E-01],
	[9.8800000000E+03, 1.2615481517E+00, 3.8623814597E+00, 1.8929358852E-02, 1.8559908658E-02, 4.6335032959E-01],
	[9.8850000000E+03, 1.2622905001E+00, 3.8617534831E+00, 1.8956601139E-02, 1.8586243687E-02, 4.6352992680E-01],
	[9.8900000000E+03, 1.2630329096E+00, 3.8611259261E+00, 1.8983868760E-02, 1.8612602255E-02, 4.6370946542E-01],
	[9.8950000000E+03, 1.2637753801E+00, 3.8604987882E+00, 1.9011161726E-02, 1.8638984369E-02, 4.6388894543E-01],
	[9.9000000000E+03, 1.2645179118E+00, 3.8598720689E+00, 1.9038480047E-02, 1.8665390037E-02, 4.6406836685E-01],
	[9.9050000000E+03, 1.2652605044E+00, 3.8592457677E+00, 1.9065823733E-02, 1.8691819268E-02, 4.6424772968E-01],
	[9.9100000000E+03, 1.2660031580E+00, 3.8586198841E+00, 1.9093192796E-02, 1.8718272069E-02, 4.6442703393E-01],
	[9.9150000000E+03, 1.2667458726E+00, 3.8579944177E+00, 1.9120587247E-02, 1.8744748448E-02, 4.6460627960E-01],
	[9.9200000000E+03, 1.2674886482E+00, 3.8573693679E+00, 1.9148007095E-02, 1.8771248413E-02, 4.6478546670E-01],
	[9.9250000000E+03, 1.2682314847E+00, 3.8567447343E+00, 1.9175452351E-02, 1.8797771972E-02, 4.6496459523E-01],
	[9.9300000000E+03, 1.2689743820E+00, 3.8561205163E+00, 1.9202923026E-02, 1.8824319133E-02, 4.6514366520E-01],
	[9.9350000000E+03, 1.2697173403E+00, 3.8554967135E+00, 1.9230419132E-02, 1.8850889903E-02, 4.6532267661E-01],
	[9.9400000000E+03, 1.2704632437E+00, 3.8548797513E+00, 1.9257940677E-02, 1.8877485083E-02, 4.6550162946E-01],
	[9.9450000000E+03, 1.2712098597E+00, 3.8542646448E+00, 1.9285487673E-02, 1.8904104069E-02, 4.6568052377E-01],
	[9.9500000000E+03, 1.2719565389E+00, 3.8536499455E+00, 1.9313060131E-02, 1.8930746694E-02, 4.6585935954E-01],
	[9.9550000000E+03, 1.2727032812E+00, 3.8530356529E+00, 1.9340658062E-02, 1.8957412963E-02, 4.6603813677E-01],
	[9.9600000000E+03, 1.2734500867E+00, 3.8524217667E+00, 1.9368281475E-02, 1.8984102886E-02, 4.6621685546E-01],
	[9.9650000000E+03, 1.2741969552E+00, 3.8518082863E+00, 1.9395930381E-02, 1.9010816471E-02, 4.6639551563E-01],
	[9.9700000000E+03, 1.2749438867E+00, 3.8511952113E+00, 1.9423604792E-02, 1.9037553724E-02, 4.6657411728E-01],
	[9.9750000000E+03, 1.2756908813E+00, 3.8505825412E+00, 1.9451304717E-02, 1.9064314655E-02, 4.6675266041E-01],
	[9.9800000000E+03, 1.2764379389E+00, 3.8499702754E+00, 1.9479030168E-02, 1.9091099270E-02, 4.6693114503E-01],
	[9.9850000000E+03, 1.2771850594E+00, 3.8493584137E+00, 1.9506781155E-02, 1.9117907578E-02, 4.6710957115E-01],
	[9.9900000000E+03, 1.2779322429E+00, 3.8487469554E+00, 1.9534557688E-02, 1.9144739587E-02, 4.6728793877E-01],
	[9.9950000000E+03, 1.2786794893E+00, 3.8481359001E+00, 1.9562359779E-02, 1.9171595304E-02, 4.6746624789E-01],
	[1.0000000000E+04, 1.2794267987E+00, 3.8475252474E+00, 1.9590187437E-02, 1.9198474738E-02, 4.6764449853E-01],
	[1.0005000000E+04, 1.2801741708E+00, 3.8469149967E+00, 1.9618318764E-02, 1.9225644964E-02, 4.6782269069E-01],
	[1.0010000000E+04, 1.2809216058E+00, 3.8463051477E+00, 1.9646476340E-02, 1.9252839535E-02, 4.6800082437E-01],
	[1.0015000000E+04, 1.2816691037E+00, 3.8456956998E+00, 1.9674660176E-02, 1.9280058458E-02, 4.6817889958E-01],
	[1.0020000000E+04, 1.2824166643E+00, 3.8450866526E+00, 1.9702870284E-02, 1.9307301741E-02, 4.6835691632E-01],
	[1.0025000000E+04, 1.2831642877E+00, 3.8444780057E+00, 1.9731106676E-02, 1.9334569394E-02, 4.6853487461E-01],
	[1.0030000000E+04, 1.2839119738E+00, 3.8438697585E+00, 1.9759369361E-02, 1.9361861424E-02, 4.6871277445E-01],
	[1.0035000000E+04, 1.2846597226E+00, 3.8432619105E+00, 1.9787658353E-02, 1.9389177840E-02, 4.6889061583E-01],
	[1.0040000000E+04, 1.2854075342E+00, 3.8426544615E+00, 1.9815973661E-02, 1.9416518651E-02, 4.6906839878E-01],
	[1.0045000000E+04, 1.2861554083E+00, 3.8420474108E+00, 1.9844315297E-02, 1.9443883864E-02, 4.6924612330E-01],
	[1.0050000000E+04, 1.2869033451E+00, 3.8414407580E+00, 1.9872683273E-02, 1.9471273487E-02, 4.6942378939E-01],
	[1.0055000000E+04, 1.2876513446E+00, 3.8408345027E+00, 1.9901077600E-02, 1.9498687531E-02, 4.6960139706E-01],
	[1.0060000000E+04, 1.2883994066E+00, 3.8402286444E+00, 1.9929498289E-02, 1.9526126001E-02, 4.6977894631E-01],
	[1.0065000000E+04, 1.2891475311E+00, 3.8396231826E+00, 1.9957945351E-02, 1.9553588908E-02, 4.6995643715E-01],
	[1.0070000000E+04, 1.2898957182E+00, 3.8390181169E+00, 1.9986418797E-02, 1.9581076259E-02, 4.7013386960E-01],
	[1.0075000000E+04, 1.2906439678E+00, 3.8384134469E+00, 2.0014918639E-02, 1.9608588063E-02, 4.7031124364E-01],
	[1.0080000000E+04, 1.2913922799E+00, 3.8378091720E+00, 2.0043444889E-02, 1.9636124327E-02, 4.7048855930E-01],
	[1.0085000000E+04, 1.2921406544E+00, 3.8372052919E+00, 2.0071997557E-02, 1.9663685061E-02, 4.7066581658E-01],
	[1.0090000000E+04, 1.2928890913E+00, 3.8366018060E+00, 2.0100576654E-02, 1.9691270273E-02, 4.7084301548E-01],
	[1.0095000000E+04, 1.2936375907E+00, 3.8359987140E+00, 2.0129182192E-02, 1.9718879970E-02, 4.7102015601E-01],
	[1.0100000000E+04, 1.2943891116E+00, 3.8354023104E+00, 2.0157814183E-02, 1.9746515018E-02, 4.7119723817E-01],
	[1.0105000000E+04, 1.2951413237E+00, 3.8348076275E+00, 2.0186472637E-02, 1.9774174753E-02, 4.7137426199E-01],
	[1.0110000000E+04, 1.2958936006E+00, 3.8342133309E+00, 2.0215157565E-02, 1.9801859003E-02, 4.7155122745E-01],
	[1.0115000000E+04, 1.2966459422E+00, 3.8336194201E+00, 2.0243868980E-02, 1.9829567777E-02, 4.7172813457E-01],
	[1.0120000000E+04, 1.2973983484E+00, 3.8330258948E+00, 2.0272606892E-02, 1.9857301083E-02, 4.7190498336E-01],
	[1.0125000000E+04, 1.2981508193E+00, 3.8324327545E+00, 2.0301371312E-02, 1.9885058930E-02, 4.7208177381E-01],
	[1.0130000000E+04, 1.2989033547E+00, 3.8318399988E+00, 2.0330162252E-02, 1.9912841324E-02, 4.7225850595E-01],
	[1.0135000000E+04, 1.2996559547E+00, 3.8312476271E+00, 2.0358979723E-02, 1.9940648276E-02, 4.7243517977E-01],
	[1.0140000000E+04, 1.3004086193E+00, 3.8306556391E+00, 2.0387823736E-02, 1.9968479793E-02, 4.7261179529E-01],
	[1.0145000000E+04, 1.3011613483E+00, 3.8300640344E+00, 2.0416694303E-02, 1.9996335883E-02, 4.7278835250E-01],
	[1.0150000000E+04, 1.3019141419E+00, 3.8294728125E+00, 2.0445591435E-02, 2.0024216555E-02, 4.7296485143E-01],
	[1.0155000000E+04, 1.3026670000E+00, 3.8288819729E+00, 2.0474515142E-02, 2.0052121816E-02, 4.7314129206E-01],
	[1.0160000000E+04, 1.3034199225E+00, 3.8282915153E+00, 2.0503465437E-02, 2.0080051676E-02, 4.7331767442E-01],
	[1.0165000000E+04, 1.3041729094E+00, 3.8277014392E+00, 2.0532442331E-02, 2.0108006143E-02, 4.7349399851E-01],
	[1.0170000000E+04, 1.3049259606E+00, 3.8271117441E+00, 2.0561445834E-02, 2.0135985224E-02, 4.7367026433E-01],
	[1.0175000000E+04, 1.3056790763E+00, 3.8265224297E+00, 2.0590475958E-02, 2.0163988929E-02, 4.7384647190E-01],
	[1.0180000000E+04, 1.3064322563E+00, 3.8259334954E+00, 2.0619532715E-02, 2.0192017265E-02, 4.7402262122E-01],
	[1.0185000000E+04, 1.3071855006E+00, 3.8253449409E+00, 2.0648616115E-02, 2.0220070240E-02, 4.7419871229E-01],
	[1.0190000000E+04, 1.3079388092E+00, 3.8247567658E+00, 2.0677726170E-02, 2.0248147863E-02, 4.7437474514E-01],
	[1.0195000000E+04, 1.3086921820E+00, 3.8241689695E+00, 2.0706862892E-02, 2.0276250143E-02, 4.7455071975E-01],
	[1.0200000000E+04, 1.3094456191E+00, 3.8235815518E+00, 2.0736026290E-02, 2.0304377087E-02, 4.7472663615E-01],
	[1.0205000000E+04, 1.3101991204E+00, 3.8229945120E+00, 2.0765216377E-02, 2.0332528703E-02, 4.7490249434E-01],
	[1.0210000000E+04, 1.3109526858E+00, 3.8224078499E+00, 2.0794433164E-02, 2.0360705000E-02, 4.7507829432E-01],
	[1.0215000000E+04, 1.3117063155E+00, 3.8218215650E+00, 2.0823676662E-02, 2.0388905986E-02, 4.7525403611E-01],
	[1.0220000000E+04, 1.3124600092E+00, 3.8212356568E+00, 2.0852946882E-02, 2.0417131670E-02, 4.7542971971E-01],
	[1.0225000000E+04, 1.3132137671E+00, 3.8206501250E+00, 2.0882243836E-02, 2.0445382059E-02, 4.7560534513E-01],
	[1.0230000000E+04, 1.3139675890E+00, 3.8200649691E+00, 2.0911567534E-02, 2.0473657162E-02, 4.7578091238E-01],
	[1.0235000000E+04, 1.3147214750E+00, 3.8194801887E+00, 2.0940917989E-02, 2.0501956987E-02, 4.7595642147E-01],
	[1.0240000000E+04, 1.3154754250E+00, 3.8188957833E+00, 2.0970295211E-02, 2.0530281542E-02, 4.7613187240E-01],
	[1.0245000000E+04, 1.3162294390E+00, 3.8183117526E+00, 2.0999699211E-02, 2.0558630835E-02, 4.7630726518E-01],
	[1.0250000000E+04, 1.3169835170E+00, 3.8177280960E+00, 2.1029130001E-02, 2.0587004875E-02, 4.7648259982E-01],
	[1.0255000000E+04, 1.3177376589E+00, 3.8171448133E+00, 2.1058587592E-02, 2.0615403670E-02, 4.7665787633E-01],
	[1.0260000000E+04, 1.3184930273E+00, 3.8165642719E+00, 2.1088071996E-02, 2.0643827582E-02, 4.7683309471E-01],
	[1.0265000000E+04, 1.3192509403E+00, 3.8159891489E+00, 2.1117583223E-02, 2.0672277024E-02, 4.7700825498E-01],
	[1.0270000000E+04, 1.3200089194E+00, 3.8154143926E+00, 2.1147121284E-02, 2.0700751250E-02, 4.7718335714E-01],
	[1.0275000000E+04, 1.3207669649E+00, 3.8148400025E+00, 2.1176686192E-02, 2.0729250268E-02, 4.7735840120E-01],
	[1.0280000000E+04, 1.3215250765E+00, 3.8142659783E+00, 2.1206277957E-02, 2.0757774087E-02, 4.7753338718E-01],
	[1.0285000000E+04, 1.3222832544E+00, 3.8136923195E+00, 2.1235896590E-02, 2.0786322714E-02, 4.7770831506E-01],
	[1.0290000000E+04, 1.3230414984E+00, 3.8131190257E+00, 2.1265542103E-02, 2.0814896158E-02, 4.7788318488E-01],
	[1.0295000000E+04, 1.3237998086E+00, 3.8125460965E+00, 2.1295214506E-02, 2.0843494427E-02, 4.7805799663E-01],
	[1.0300000000E+04, 1.3245581848E+00, 3.8119735316E+00, 2.1324913812E-02, 2.0872117529E-02, 4.7823275032E-01],
	[1.0305000000E+04, 1.3253166272E+00, 3.8114013305E+00, 2.1354640032E-02, 2.0900765473E-02, 4.7840744596E-01],
	[1.0310000000E+04, 1.3260751356E+00, 3.8108294927E+00, 2.1384393175E-02, 2.0929438266E-02, 4.7858208357E-01],
	[1.0315000000E+04, 1.3268337101E+00, 3.8102580179E+00, 2.1414173255E-02, 2.0958135916E-02, 4.7875666314E-01],
	[1.0320000000E+04, 1.3275923505E+00, 3.8096869058E+00, 2.1443980282E-02, 2.0986858433E-02, 4.7893118469E-01],
	[1.0325000000E+04, 1.3283510570E+00, 3.8091161558E+00, 2.1473814267E-02, 2.1015605823E-02, 4.7910564822E-01],
	[1.0330000000E+04, 1.3291098294E+00, 3.8085457675E+00, 2.1503675221E-02, 2.1044378096E-02, 4.7928005375E-01],
	[1.0335000000E+04, 1.3298686677E+00, 3.8079757407E+00, 2.1533563157E-02, 2.1073175259E-02, 4.7945440128E-01],
	[1.0340000000E+04, 1.3306275719E+00, 3.8074060748E+00, 2.1563478084E-02, 2.1101997320E-02, 4.7962869083E-01],
	[1.0345000000E+04, 1.3313865420E+00, 3.8068367694E+00, 2.1593420014E-02, 2.1130844288E-02, 4.7980292239E-01],
	[1.0350000000E+04, 1.3321455780E+00, 3.8062678242E+00, 2.1623388959E-02, 2.1159716171E-02, 4.7997709599E-01],
	[1.0355000000E+04, 1.3329046798E+00, 3.8056992388E+00, 2.1653384929E-02, 2.1188612976E-02, 4.8015121162E-01],
	[1.0360000000E+04, 1.3336638473E+00, 3.8051310127E+00, 2.1683407937E-02, 2.1217534713E-02, 4.8032526930E-01],
	[1.0365000000E+04, 1.3344230807E+00, 3.8045631456E+00, 2.1713457992E-02, 2.1246481389E-02, 4.8049926904E-01],
	[1.0370000000E+04, 1.3351823798E+00, 3.8039956370E+00, 2.1743535107E-02, 2.1275453012E-02, 4.8067321084E-01],
	[1.0375000000E+04, 1.3359417446E+00, 3.8034284866E+00, 2.1773639292E-02, 2.1304449590E-02, 4.8084709472E-01],
	[1.0380000000E+04, 1.3367011751E+00, 3.8028616939E+00, 2.1803770559E-02, 2.1333471132E-02, 4.8102092068E-01],
	[1.0385000000E+04, 1.3374606713E+00, 3.8022952586E+00, 2.1833928919E-02, 2.1362517645E-02, 4.8119468874E-01],
	[1.0390000000E+04, 1.3382202331E+00, 3.8017291803E+00, 2.1864114383E-02, 2.1391589138E-02, 4.8136839890E-01],
	[1.0395000000E+04, 1.3389798606E+00, 3.8011634585E+00, 2.1894326963E-02, 2.1420685619E-02, 4.8154205116E-01],
	[1.0400000000E+04, 1.3397395536E+00, 3.8005980929E+00, 2.1924566669E-02, 2.1449807096E-02, 4.8171564555E-01],
	[1.0405000000E+04, 1.3404993122E+00, 3.8000330831E+00, 2.1954833513E-02, 2.1478953576E-02, 4.8188918207E-01],
	[1.0410000000E+04, 1.3412591363E+00, 3.7994684287E+00, 2.1985127506E-02, 2.1508125069E-02, 4.8206266073E-01],
	[1.0415000000E+04, 1.3420190260E+00, 3.7989041292E+00, 2.2015448659E-02, 2.1537321582E-02, 4.8223608154E-01],
	[1.0420000000E+04, 1.3427789811E+00, 3.7983401843E+00, 2.2045796984E-02, 2.1566543123E-02, 4.8240944451E-01],
	[1.0425000000E+04, 1.3435400742E+00, 3.7977786848E+00, 2.2076172491E-02, 2.1595790046E-02, 4.8258274964E-01],
	[1.0430000000E+04, 1.3443038604E+00, 3.7972226556E+00, 2.2106575192E-02, 2.1625062859E-02, 4.8275599695E-01],
	[1.0435000000E+04, 1.3450677143E+00, 3.7966669742E+00, 2.2137005099E-02, 2.1654360731E-02, 4.8292918645E-01],
	[1.0440000000E+04, 1.3458316361E+00, 3.7961116402E+00, 2.2167462221E-02, 2.1683683667E-02, 4.8310231814E-01],
	[1.0445000000E+04, 1.3465956256E+00, 3.7955566533E+00, 2.2197946572E-02, 2.1713031677E-02, 4.8327539204E-01],
	[1.0450000000E+04, 1.3473596829E+00, 3.7950020131E+00, 2.2228458161E-02, 2.1742404769E-02, 4.8344840816E-01],
	[1.0455000000E+04, 1.3481238079E+00, 3.7944477193E+00, 2.2258996999E-02, 2.1771802950E-02, 4.8362136650E-01],
	[1.0460000000E+04, 1.3488880007E+00, 3.7938937713E+00, 2.2289563099E-02, 2.1801226229E-02, 4.8379426707E-01],
	[1.0465000000E+04, 1.3496522611E+00, 3.7933401689E+00, 2.2320156472E-02, 2.1830674614E-02, 4.8396710989E-01],
	[1.0470000000E+04, 1.3504165891E+00, 3.7927869116E+00, 2.2350777128E-02, 2.1860148112E-02, 4.8413989497E-01],
	[1.0475000000E+04, 1.3511809847E+00, 3.7922339991E+00, 2.2381425078E-02, 2.1889646733E-02, 4.8431262231E-01],
	[1.0480000000E+04, 1.3519454480E+00, 3.7916814311E+00, 2.2412100335E-02, 2.1919170483E-02, 4.8448529192E-01],
	[1.0485000000E+04, 1.3527099788E+00, 3.7911292070E+00, 2.2442802909E-02, 2.1948719371E-02, 4.8465790380E-01],
	[1.0490000000E+04, 1.3534745772E+00, 3.7905773266E+00, 2.2473532811E-02, 2.1978293405E-02, 4.8483045793E-01],
	[1.0495000000E+04, 1.3542392430E+00, 3.7900257895E+00, 2.2504290053E-02, 2.2007892593E-02, 4.8500295431E-01],
	[1.0500000000E+04, 1.3550039764E+00, 3.7894745952E+00, 2.2535074645E-02, 2.2037516944E-02, 4.8517539294E-01],
	[1.0505000000E+04, 1.3557687772E+00, 3.7889237435E+00, 2.2565886600E-02, 2.2067166464E-02, 4.8534777383E-01],
	[1.0510000000E+04, 1.3565336454E+00, 3.7883732339E+00, 2.2596725927E-02, 2.2096841162E-02, 4.8552009697E-01],
	[1.0515000000E+04, 1.3572985811E+00, 3.7878230661E+00, 2.2627592639E-02, 2.2126541047E-02, 4.8569236238E-01],
	[1.0520000000E+04, 1.3580635841E+00, 3.7872732397E+00, 2.2658486747E-02, 2.2156266125E-02, 4.8586457004E-01],
	[1.0525000000E+04, 1.3588286545E+00, 3.7867237542E+00, 2.2689408261E-02, 2.2186016406E-02, 4.8603671996E-01],
	[1.0530000000E+04, 1.3595937923E+00, 3.7861746095E+00, 2.2720357194E-02, 2.2215791896E-02, 4.8620881215E-01],
	[1.0535000000E+04, 1.3603589973E+00, 3.7856258050E+00, 2.2751333555E-02, 2.2245592605E-02, 4.8638084660E-01],
	[1.0540000000E+04, 1.3611242696E+00, 3.7850773404E+00, 2.2782337357E-02, 2.2275418540E-02, 4.8655282331E-01],
	[1.0545000000E+04, 1.3618896092E+00, 3.7845292153E+00, 2.2813368610E-02, 2.2305269710E-02, 4.8672474230E-01],
	[1.0550000000E+04, 1.3626550160E+00, 3.7839814294E+00, 2.2844427326E-02, 2.2335146121E-02, 4.8689660355E-01],
	[1.0555000000E+04, 1.3634204900E+00, 3.7834339822E+00, 2.2875513516E-02, 2.2365047782E-02, 4.8706840707E-01],
	[1.0560000000E+04, 1.3641860311E+00, 3.7828868735E+00, 2.2906627191E-02, 2.2394974702E-02, 4.8724015287E-01],
	[1.0565000000E+04, 1.3649516395E+00, 3.7823401028E+00, 2.2937768362E-02, 2.2424926887E-02, 4.8741184095E-01],
	[1.0570000000E+04, 1.3657173149E+00, 3.7817936698E+00, 2.2968937041E-02, 2.2454904346E-02, 4.8758347130E-01],
	[1.0575000000E+04, 1.3664830574E+00, 3.7812475741E+00, 2.3000133238E-02, 2.2484907088E-02, 4.8775504393E-01],
	[1.0580000000E+04, 1.3672488670E+00, 3.7807018154E+00, 2.3031356966E-02, 2.2514935119E-02, 4.8792655885E-01],
	[1.0585000000E+04, 1.3680147437E+00, 3.7801563932E+00, 2.3062608234E-02, 2.2544988449E-02, 4.8809801605E-01],
	[1.0590000000E+04, 1.3687806874E+00, 3.7796113072E+00, 2.3093887054E-02, 2.2575067084E-02, 4.8826941553E-01],
	[1.0595000000E+04, 1.3695494367E+00, 3.7790716671E+00, 2.3125193438E-02, 2.2605171962E-02, 4.8844075731E-01],
	[1.0600000000E+04, 1.3703192731E+00, 3.7785342576E+00, 2.3156527397E-02, 2.2635302511E-02, 4.8861204138E-01],
	[1.0605000000E+04, 1.3710891789E+00, 3.7779971779E+00, 2.3187888941E-02, 2.2665458395E-02, 4.8878326774E-01],
	[1.0610000000E+04, 1.3718591541E+00, 3.7774604276E+00, 2.3219278083E-02, 2.2695639623E-02, 4.8895443639E-01],
	[1.0615000000E+04, 1.3726291986E+00, 3.7769240065E+00, 2.3250694832E-02, 2.2725846200E-02, 4.8912554735E-01],
	[1.0620000000E+04, 1.3733993124E+00, 3.7763879140E+00, 2.3282139201E-02, 2.2756078137E-02, 4.8929660060E-01],
	[1.0625000000E+04, 1.3741694955E+00, 3.7758521500E+00, 2.3313611200E-02, 2.2786335440E-02, 4.8946759616E-01],
	[1.0630000000E+04, 1.3749397478E+00, 3.7753167139E+00, 2.3345110841E-02, 2.2816618118E-02, 4.8963853403E-01],
	[1.0635000000E+04, 1.3757100694E+00, 3.7747816055E+00, 2.3376638135E-02, 2.2846926178E-02, 4.8980941421E-01],
	[1.0640000000E+04, 1.3764804602E+00, 3.7742468245E+00, 2.3408193092E-02, 2.2877259629E-02, 4.8998023670E-01],
	[1.0645000000E+04, 1.3772509201E+00, 3.7737123704E+00, 2.3439775725E-02, 2.2907618478E-02, 4.9015100150E-01],
	[1.0650000000E+04, 1.3780214492E+00, 3.7731782429E+00, 2.3471386045E-02, 2.2938002733E-02, 4.9032170862E-01],
	[1.0655000000E+04, 1.3787920473E+00, 3.7726444416E+00, 2.3503024062E-02, 2.2968412402E-02, 4.9049235806E-01],
	[1.0660000000E+04, 1.3795627146E+00, 3.7721109663E+00, 2.3534689787E-02, 2.2998847494E-02, 4.9066294983E-01],
	[1.0665000000E+04, 1.3803334510E+00, 3.7715778165E+00, 2.3566383233E-02, 2.3029308015E-02, 4.9083348392E-01],
	[1.0670000000E+04, 1.3811042564E+00, 3.7710449919E+00, 2.3598104410E-02, 2.3059793975E-02, 4.9100396035E-01],
	[1.0675000000E+04, 1.3818751307E+00, 3.7705124921E+00, 2.3629853329E-02, 2.3090305380E-02, 4.9117437910E-01],
	[1.0680000000E+04, 1.3826460741E+00, 3.7699803168E+00, 2.3661630001E-02, 2.3120842239E-02, 4.9134474019E-01],
	[1.0685000000E+04, 1.3834170865E+00, 3.7694484657E+00, 2.3693434438E-02, 2.3151404559E-02, 4.9151504363E-01],
	[1.0690000000E+04, 1.3841881678E+00, 3.7689169384E+00, 2.3725266651E-02, 2.3181992349E-02, 4.9168528940E-01],
	[1.0695000000E+04, 1.3849593179E+00, 3.7683857345E+00, 2.3757126650E-02, 2.3212605616E-02, 4.9185547752E-01],
	[1.0700000000E+04, 1.3857305370E+00, 3.7678548538E+00, 2.3789014448E-02, 2.3243244369E-02, 4.9202560799E-01],
	[1.0705000000E+04, 1.3865018249E+00, 3.7673242957E+00, 2.3820930055E-02, 2.3273908614E-02, 4.9219568081E-01],
	[1.0710000000E+04, 1.3872731817E+00, 3.7667940601E+00, 2.3852873482E-02, 2.3304598361E-02, 4.9236569599E-01],
	[1.0715000000E+04, 1.3880446072E+00, 3.7662641466E+00, 2.3884844741E-02, 2.3335313616E-02, 4.9253565353E-01],
	[1.0720000000E+04, 1.3888161016E+00, 3.7657345548E+00, 2.3916843843E-02, 2.3366054389E-02, 4.9270555343E-01],
	[1.0725000000E+04, 1.3895876647E+00, 3.7652052843E+00, 2.3948870799E-02, 2.3396820685E-02, 4.9287539570E-01],
	[1.0730000000E+04, 1.3903592965E+00, 3.7646763349E+00, 2.3980925620E-02, 2.3427612514E-02, 4.9304518034E-01],
	[1.0735000000E+04, 1.3911309970E+00, 3.7641477061E+00, 2.4013008317E-02, 2.3458429884E-02, 4.9321490735E-01],
	[1.0740000000E+04, 1.3919027662E+00, 3.7636193977E+00, 2.4045118901E-02, 2.3489272801E-02, 4.9338457674E-01],
	[1.0745000000E+04, 1.3926746040E+00, 3.7630914093E+00, 2.4077257384E-02, 2.3520141275E-02, 4.9355418851E-01],
	[1.0750000000E+04, 1.3934465105E+00, 3.7625637405E+00, 2.4109423777E-02, 2.3551035312E-02, 4.9372374267E-01],
	[1.0755000000E+04, 1.3942184856E+00, 3.7620363910E+00, 2.4141618091E-02, 2.3581954921E-02, 4.9389323922E-01],
	[1.0760000000E+04, 1.3949905292E+00, 3.7615093605E+00, 2.4173840336E-02, 2.3612900109E-02, 4.9406267816E-01],
	[1.0765000000E+04, 1.3957650360E+00, 3.7609869267E+00, 2.4206090525E-02, 2.3643871741E-02, 4.9423205949E-01],
	[1.0770000000E+04, 1.3965410336E+00, 3.7604673444E+00, 2.4238368668E-02, 2.3674869480E-02, 4.9440138323E-01],
	[1.0775000000E+04, 1.3973171021E+00, 3.7599480749E+00, 2.4270674777E-02, 2.3705892828E-02, 4.9457064937E-01],
	[1.0780000000E+04, 1.3980932415E+00, 3.7594291180E+00, 2.4303008863E-02, 2.3736941791E-02, 4.9473985793E-01],
	[1.0785000000E+04, 1.3988694519E+00, 3.7589104733E+00, 2.4335370936E-02, 2.3768016379E-02, 4.9490900889E-01],
	[1.0790000000E+04, 1.3996457331E+00, 3.7583921405E+00, 2.4367761008E-02, 2.3799116598E-02, 4.9507810228E-01],
	[1.0795000000E+04, 1.4004220852E+00, 3.7578741193E+00, 2.4400179091E-02, 2.3830242457E-02, 4.9524713808E-01],
	[1.0800000000E+04, 1.4011985081E+00, 3.7573564093E+00, 2.4432625194E-02, 2.3861393963E-02, 4.9541611632E-01],
	[1.0805000000E+04, 1.4019750017E+00, 3.7568390102E+00, 2.4465099330E-02, 2.3892571125E-02, 4.9558503698E-01],
	[1.0810000000E+04, 1.4027515662E+00, 3.7563219217E+00, 2.4497601510E-02, 2.3923773950E-02, 4.9575390008E-01],
	[1.0815000000E+04, 1.4035282014E+00, 3.7558051434E+00, 2.4530131744E-02, 2.3955002445E-02, 4.9592270561E-01],
	[1.0820000000E+04, 1.4043049073E+00, 3.7552886750E+00, 2.4562690045E-02, 2.3986256619E-02, 4.9609145359E-01],
	[1.0825000000E+04, 1.4050816838E+00, 3.7547725162E+00, 2.4595276422E-02, 2.4017536479E-02, 4.9626014402E-01],
	[1.0830000000E+04, 1.4058585311E+00, 3.7542566666E+00, 2.4627890888E-02, 2.4048842034E-02, 4.9642877691E-01],
	[1.0835000000E+04, 1.4066354490E+00, 3.7537411260E+00, 2.4660533452E-02, 2.4080173290E-02, 4.9659735224E-01],
	[1.0840000000E+04, 1.4074124375E+00, 3.7532258940E+00, 2.4693204128E-02, 2.4111530256E-02, 4.9676587005E-01],
	[1.0845000000E+04, 1.4081894966E+00, 3.7527109702E+00, 2.4725902925E-02, 2.4142912940E-02, 4.9693433031E-01],
	[1.0850000000E+04, 1.4089666262E+00, 3.7521963544E+00, 2.4758629854E-02, 2.4174321349E-02, 4.9710273305E-01],
	[1.0855000000E+04, 1.4097438264E+00, 3.7516820462E+00, 2.4791384928E-02, 2.4205755491E-02, 4.9727107827E-01],
	[1.0860000000E+04, 1.4105210971E+00, 3.7511680453E+00, 2.4824168157E-02, 2.4237215374E-02, 4.9743936596E-01],
	[1.0865000000E+04, 1.4112984382E+00, 3.7506543513E+00, 2.4856979551E-02, 2.4268701005E-02, 4.9760759615E-01],
	[1.0870000000E+04, 1.4120758498E+00, 3.7501409640E+00, 2.4889819124E-02, 2.4300212392E-02, 4.9777576882E-01],
	[1.0875000000E+04, 1.4128533319E+00, 3.7496278831E+00, 2.4922686884E-02, 2.4331749544E-02, 4.9794388399E-01],
	[1.0880000000E+04, 1.4136308843E+00, 3.7491151081E+00, 2.4955582844E-02, 2.4363312468E-02, 4.9811194166E-01],
	[1.0885000000E+04, 1.4144085071E+00, 3.7486026387E+00, 2.4988507015E-02, 2.4394901171E-02, 4.9827994183E-01],
	[1.0890000000E+04, 1.4151862003E+00, 3.7480904748E+00, 2.5021459408E-02, 2.4426515661E-02, 4.9844788452E-01],
	[1.0895000000E+04, 1.4159639638E+00, 3.7475786158E+00, 2.5054440034E-02, 2.4458155946E-02, 4.9861576972E-01],
	[1.0900000000E+04, 1.4167417976E+00, 3.7470670616E+00, 2.5087448904E-02, 2.4489822034E-02, 4.9878359744E-01],
	[1.0905000000E+04, 1.4175197017E+00, 3.7465558117E+00, 2.5120486029E-02, 2.4521513932E-02, 4.9895136769E-01],
	[1.0910000000E+04, 1.4182976760E+00, 3.7460448660E+00, 2.5153551421E-02, 2.4553231649E-02, 4.9911908047E-01],
	[1.0915000000E+04, 1.4190757205E+00, 3.7455342239E+00, 2.5186645090E-02, 2.4584975191E-02, 4.9928673579E-01],
	[1.0920000000E+04, 1.4198538352E+00, 3.7450238853E+00, 2.5219767048E-02, 2.4616744567E-02, 4.9945433365E-01],
	[1.0925000000E+04, 1.4206320201E+00, 3.7445138498E+00, 2.5252917306E-02, 2.4648539785E-02, 4.9962187406E-01],
	[1.0930000000E+04, 1.4214102752E+00, 3.7440041170E+00, 2.5286095875E-02, 2.4680360851E-02, 4.9978935702E-01],
	[1.0935000000E+04, 1.4221886003E+00, 3.7434946868E+00, 2.5319302766E-02, 2.4712207774E-02, 4.9995678253E-01],
	[1.0940000000E+04, 1.4229707825E+00, 3.7429920346E+00, 2.5352537990E-02, 2.4744081989E-02, 5.0012415062E-01],
	[1.0945000000E+04, 1.4237531245E+00, 3.7424898288E+00, 2.5385801558E-02, 2.4775982115E-02, 5.0029146127E-01],
	[1.0950000000E+04, 1.4245355390E+00, 3.7419879198E+00, 2.5419093482E-02, 2.4807908127E-02, 5.0045871449E-01],
	[1.0955000000E+04, 1.4253180261E+00, 3.7414863072E+00, 2.5452413772E-02, 2.4839860032E-02, 5.0062591030E-01],
	[1.0960000000E+04, 1.4261005856E+00, 3.7409849906E+00, 2.5485762441E-02, 2.4871837837E-02, 5.0079304869E-01],
	[1.0965000000E+04, 1.4268832175E+00, 3.7404839698E+00, 2.5519139498E-02, 2.4903841551E-02, 5.0096012967E-01],
	[1.0970000000E+04, 1.4276659219E+00, 3.7399832445E+00, 2.5552544955E-02, 2.4935871181E-02, 5.0112715326E-01],
	[1.0975000000E+04, 1.4284486986E+00, 3.7394828143E+00, 2.5585978823E-02, 2.4967926735E-02, 5.0129411944E-01],
	[1.0980000000E+04, 1.4292315477E+00, 3.7389826790E+00, 2.5619441113E-02, 2.5000008221E-02, 5.0146102823E-01],
	[1.0985000000E+04, 1.4300144692E+00, 3.7384828383E+00, 2.5652931837E-02, 2.5032115646E-02, 5.0162787964E-01],
	[1.0990000000E+04, 1.4307974629E+00, 3.7379832917E+00, 2.5686451005E-02, 2.5064249017E-02, 5.0179467367E-01],
	[1.0995000000E+04, 1.4315805289E+00, 3.7374840391E+00, 2.5719998629E-02, 2.5096408344E-02, 5.0196141033E-01],
	[1.1000000000E+04, 1.4323636672E+00, 3.7369850801E+00, 2.5753574719E-02, 2.5128593632E-02, 5.0212808962E-01],
	[1.1005000000E+04, 1.4331468777E+00, 3.7364864145E+00, 2.5787179288E-02, 2.5160804890E-02, 5.0229471155E-01],
	[1.1010000000E+04, 1.4339301604E+00, 3.7359880418E+00, 2.5820812345E-02, 2.5193042126E-02, 5.0246127612E-01],
	[1.1015000000E+04, 1.4347135153E+00, 3.7354899618E+00, 2.5854473902E-02, 2.5225305347E-02, 5.0262778335E-01],
	[1.1020000000E+04, 1.4354969423E+00, 3.7349921743E+00, 2.5888163971E-02, 2.5257594561E-02, 5.0279423323E-01],
	[1.1025000000E+04, 1.4362804415E+00, 3.7344946788E+00, 2.5921882562E-02, 2.5289909775E-02, 5.0296062577E-01],
	[1.1030000000E+04, 1.4370640128E+00, 3.7339974751E+00, 2.5955629686E-02, 2.5322250997E-02, 5.0312696099E-01],
	[1.1035000000E+04, 1.4378476561E+00, 3.7335005629E+00, 2.5989405355E-02, 2.5354618235E-02, 5.0329323888E-01],
	[1.1040000000E+04, 1.4386313715E+00, 3.7330039419E+00, 2.6023209579E-02, 2.5387011496E-02, 5.0345945945E-01],
	[1.1045000000E+04, 1.4394151588E+00, 3.7325076118E+00, 2.6057042370E-02, 2.5419430788E-02, 5.0362562271E-01],
	[1.1050000000E+04, 1.4401990182E+00, 3.7320115723E+00, 2.6090903739E-02, 2.5451876118E-02, 5.0379172867E-01],
	[1.1055000000E+04, 1.4409829496E+00, 3.7315158230E+00, 2.6124793697E-02, 2.5484347495E-02, 5.0395777732E-01],
	[1.1060000000E+04, 1.4417669529E+00, 3.7310203637E+00, 2.6158712255E-02, 2.5516844926E-02, 5.0412376869E-01],
	[1.1065000000E+04, 1.4425510281E+00, 3.7305251941E+00, 2.6192659425E-02, 2.5549368418E-02, 5.0428970277E-01],
	[1.1070000000E+04, 1.4433351752E+00, 3.7300303139E+00, 2.6226635216E-02, 2.5581917978E-02, 5.0445557957E-01],
	[1.1075000000E+04, 1.4441193942E+00, 3.7295357228E+00, 2.6260639642E-02, 2.5614493616E-02, 5.0462139909E-01],
	[1.1080000000E+04, 1.4449036850E+00, 3.7290414204E+00, 2.6294672711E-02, 2.5647095337E-02, 5.0478716135E-01],
	[1.1085000000E+04, 1.4456880476E+00, 3.7285474065E+00, 2.6328734437E-02, 2.5679723150E-02, 5.0495286636E-01],
	[1.1090000000E+04, 1.4464724820E+00, 3.7280536808E+00, 2.6362824829E-02, 2.5712377063E-02, 5.0511851410E-01],
	[1.1095000000E+04, 1.4472569881E+00, 3.7275602429E+00, 2.6396943898E-02, 2.5745057082E-02, 5.0528410461E-01],
	[1.1100000000E+04, 1.4480415660E+00, 3.7270670927E+00, 2.6431091657E-02, 2.5777763216E-02, 5.0544963787E-01],
	[1.1105000000E+04, 1.4488262157E+00, 3.7265742297E+00, 2.6465268116E-02, 2.5810495472E-02, 5.0561511390E-01],
	[1.1110000000E+04, 1.4496109369E+00, 3.7260816538E+00, 2.6499473286E-02, 2.5843253858E-02, 5.0578053270E-01],
	[1.1115000000E+04, 1.4503987563E+00, 3.7255943207E+00, 2.6533707179E-02, 2.5876039583E-02, 5.0594589429E-01],
	[1.1120000000E+04, 1.4511875568E+00, 3.7251087557E+00, 2.6567969805E-02, 2.5908851819E-02, 5.0611119866E-01],
	[1.1125000000E+04, 1.4519764314E+00, 3.7246234722E+00, 2.6602261175E-02, 2.5941690212E-02, 5.0627644583E-01],
	[1.1130000000E+04, 1.4527653801E+00, 3.7241384699E+00, 2.6636581301E-02, 2.5974554772E-02, 5.0644163580E-01],
	[1.1135000000E+04, 1.4535544028E+00, 3.7236537486E+00, 2.6670930193E-02, 2.6007445505E-02, 5.0660676859E-01],
	[1.1140000000E+04, 1.4543434995E+00, 3.7231693079E+00, 2.6705307863E-02, 2.6040362419E-02, 5.0677184418E-01],
	[1.1145000000E+04, 1.4551326703E+00, 3.7226851476E+00, 2.6739714322E-02, 2.6073305521E-02, 5.0693686260E-01],
	[1.1150000000E+04, 1.4559219150E+00, 3.7222012674E+00, 2.6774149582E-02, 2.6106274819E-02, 5.0710182385E-01],
	[1.1155000000E+04, 1.4567112337E+00, 3.7217176669E+00, 2.6808613652E-02, 2.6139270321E-02, 5.0726672794E-01],
	[1.1160000000E+04, 1.4575006262E+00, 3.7212343460E+00, 2.6843106544E-02, 2.6172292034E-02, 5.0743157487E-01],
	[1.1165000000E+04, 1.4582900927E+00, 3.7207513043E+00, 2.6877628270E-02, 2.6205339966E-02, 5.0759636466E-01],
	[1.1170000000E+04, 1.4590796331E+00, 3.7202685415E+00, 2.6912178840E-02, 2.6238414123E-02, 5.0776109730E-01],
	[1.1175000000E+04, 1.4598692472E+00, 3.7197860574E+00, 2.6946758265E-02, 2.6271514515E-02, 5.0792577281E-01],
	[1.1180000000E+04, 1.4606589352E+00, 3.7193038516E+00, 2.6981366557E-02, 2.6304641147E-02, 5.0809039119E-01],
	[1.1185000000E+04, 1.4614486970E+00, 3.7188219239E+00, 2.7016296246E-02, 2.6338072045E-02, 5.0825495246E-01],
	[1.1190000000E+04, 1.4622385326E+00, 3.7183402740E+00, 2.7051274144E-02, 2.6371547535E-02, 5.0841945661E-01],
	[1.1195000000E+04, 1.4630284419E+00, 3.7178589016E+00, 2.7086281613E-02, 2.6405049899E-02, 5.0858390367E-01],
	[1.1200000000E+04, 1.4638184249E+00, 3.7173778064E+00, 2.7121318664E-02, 2.6438579143E-02, 5.0874829362E-01],
	[1.1205000000E+04, 1.4646084815E+00, 3.7168969881E+00, 2.7156385309E-02, 2.6472135277E-02, 5.0891262648E-01],
	[1.1210000000E+04, 1.4653986119E+00, 3.7164164466E+00, 2.7191481559E-02, 2.6505718307E-02, 5.0907690225E-01],
	[1.1215000000E+04, 1.4661888158E+00, 3.7159361813E+00, 2.7226607427E-02, 2.6539328243E-02, 5.0924112092E-01],
	[1.1220000000E+04, 1.4669790934E+00, 3.7154561922E+00, 2.7261762923E-02, 2.6572965091E-02, 5.0940528248E-01],
	[1.1225000000E+04, 1.4677694446E+00, 3.7149764789E+00, 2.7296948060E-02, 2.6606628860E-02, 5.0956938695E-01],
	[1.1230000000E+04, 1.4685598693E+00, 3.7144970411E+00, 2.7332162849E-02, 2.6640319558E-02, 5.0973343432E-01],
	[1.1235000000E+04, 1.4693503675E+00, 3.7140178786E+00, 2.7367407303E-02, 2.6674037193E-02, 5.0989742460E-01],
	[1.1240000000E+04, 1.4701409393E+00, 3.7135389910E+00, 2.7402681431E-02, 2.6707781772E-02, 5.1006135778E-01],
	[1.1245000000E+04, 1.4709315845E+00, 3.7130603782E+00, 2.7437985248E-02, 2.6741553304E-02, 5.1022523388E-01],
	[1.1250000000E+04, 1.4717223032E+00, 3.7125820397E+00, 2.7473318763E-02, 2.6775351796E-02, 5.1038905288E-01],
	[1.1255000000E+04, 1.4725130953E+00, 3.7121039753E+00, 2.7508681989E-02, 2.6809177258E-02, 5.1055281479E-01],
	[1.1260000000E+04, 1.4733039608E+00, 3.7116261849E+00, 2.7544074938E-02, 2.6843029695E-02, 5.1071651962E-01],
	[1.1265000000E+04, 1.4740948997E+00, 3.7111486679E+00, 2.7579497620E-02, 2.6876909117E-02, 5.1088016736E-01],
	[1.1270000000E+04, 1.4748859119E+00, 3.7106714243E+00, 2.7614950049E-02, 2.6910815531E-02, 5.1104375802E-01],
	[1.1275000000E+04, 1.4756769974E+00, 3.7101944537E+00, 2.7650432235E-02, 2.6944748945E-02, 5.1120729160E-01],
	[1.1280000000E+04, 1.4764681563E+00, 3.7097177558E+00, 2.7685944190E-02, 2.6978709367E-02, 5.1137076809E-01],
	[1.1285000000E+04, 1.4772593884E+00, 3.7092413304E+00, 2.7721485926E-02, 2.7012696805E-02, 5.1153418752E-01],
	[1.1290000000E+04, 1.4780506937E+00, 3.7087651772E+00, 2.7757057455E-02, 2.7046711268E-02, 5.1169754986E-01],
	[1.1295000000E+04, 1.4788460447E+00, 3.7082955240E+00, 2.7792658789E-02, 2.7080754426E-02, 5.1186085514E-01],
	[1.1300000000E+04, 1.4796414933E+00, 3.7078261726E+00, 2.7828289938E-02, 2.7114824639E-02, 5.1202410334E-01],
	[1.1305000000E+04, 1.4804370177E+00, 3.7073570882E+00, 2.7863950915E-02, 2.7148921906E-02, 5.1218729447E-01],
	[1.1310000000E+04, 1.4812326177E+00, 3.7068882705E+00, 2.7899641731E-02, 2.7183046235E-02, 5.1235042854E-01],
	[1.1315000000E+04, 1.4820282934E+00, 3.7064197193E+00, 2.7935362398E-02, 2.7217197634E-02, 5.1251350555E-01],
	[1.1320000000E+04, 1.4828240446E+00, 3.7059514343E+00, 2.7971112928E-02, 2.7251376110E-02, 5.1267652549E-01],
	[1.1325000000E+04, 1.4836198714E+00, 3.7054834152E+00, 2.8006893333E-02, 2.7285581671E-02, 5.1283948837E-01],
	[1.1330000000E+04, 1.4844157738E+00, 3.7050156618E+00, 2.8042703624E-02, 2.7319814326E-02, 5.1300239420E-01],
	[1.1335000000E+04, 1.4852117518E+00, 3.7045481737E+00, 2.8078543812E-02, 2.7354074082E-02, 5.1316524297E-01],
	[1.1340000000E+04, 1.4860078052E+00, 3.7040809507E+00, 2.8114413910E-02, 2.7388360947E-02, 5.1332803469E-01],
	[1.1345000000E+04, 1.4868039341E+00, 3.7036139926E+00, 2.8150313929E-02, 2.7422674930E-02, 5.1349076935E-01],
	[1.1350000000E+04, 1.4876001384E+00, 3.7031472991E+00, 2.8186243882E-02, 2.7457016036E-02, 5.1365344698E-01],
	[1.1355000000E+04, 1.4883964182E+00, 3.7026808699E+00, 2.8222203778E-02, 2.7491384276E-02, 5.1381606755E-01],
	[1.1360000000E+04, 1.4891927733E+00, 3.7022147048E+00, 2.8258193631E-02, 2.7525779656E-02, 5.1397863109E-01],
	[1.1365000000E+04, 1.4899892039E+00, 3.7017488034E+00, 2.8294213452E-02, 2.7560202184E-02, 5.1414113759E-01],
	[1.1370000000E+04, 1.4907857098E+00, 3.7012831656E+00, 2.8330263253E-02, 2.7594651869E-02, 5.1430358705E-01],
	[1.1375000000E+04, 1.4915822910E+00, 3.7008177910E+00, 2.8366343044E-02, 2.7629128717E-02, 5.1446597948E-01],
	[1.1380000000E+04, 1.4923789475E+00, 3.7003526794E+00, 2.8402452839E-02, 2.7663632738E-02, 5.1462831488E-01],
	[1.1385000000E+04, 1.4931756792E+00, 3.6998878305E+00, 2.8438592648E-02, 2.7698163938E-02, 5.1479059325E-01],
	[1.1390000000E+04, 1.4939724862E+00, 3.6994232441E+00, 2.8474762484E-02, 2.7732722325E-02, 5.1495281459E-01],
	[1.1395000000E+04, 1.4947693684E+00, 3.6989589199E+00, 2.8510962358E-02, 2.7767307908E-02, 5.1511497892E-01],
	[1.1400000000E+04, 1.4955663259E+00, 3.6984948576E+00, 2.8547192281E-02, 2.7801920694E-02, 5.1527708622E-01],
	[1.1405000000E+04, 1.4963633584E+00, 3.6980310570E+00, 2.8583452266E-02, 2.7836560692E-02, 5.1543913651E-01],
	[1.1410000000E+04, 1.4971604661E+00, 3.6975675178E+00, 2.8619742324E-02, 2.7871227907E-02, 5.1560112979E-01],
	[1.1415000000E+04, 1.4979576490E+00, 3.6971042398E+00, 2.8656062467E-02, 2.7905922350E-02, 5.1576306606E-01],
	[1.1420000000E+04, 1.4987549069E+00, 3.6966412226E+00, 2.8692412706E-02, 2.7940644027E-02, 5.1592494532E-01],
	[1.1425000000E+04, 1.4995522398E+00, 3.6961784661E+00, 2.8728793053E-02, 2.7975392946E-02, 5.1608676758E-01],
	[1.1430000000E+04, 1.5003496478E+00, 3.6957159699E+00, 2.8765203519E-02, 2.8010169115E-02, 5.1624853285E-01],
	[1.1435000000E+04, 1.5011471308E+00, 3.6952537339E+00, 2.8801644118E-02, 2.8044972541E-02, 5.1641024111E-01],
	[1.1440000000E+04, 1.5019446888E+00, 3.6947917576E+00, 2.8838114859E-02, 2.8079803234E-02, 5.1657189238E-01],
	[1.1445000000E+04, 1.5027423218E+00, 3.6943300410E+00, 2.8874615755E-02, 2.8114661199E-02, 5.1673348667E-01],
	[1.1450000000E+04, 1.5035400297E+00, 3.6938685837E+00, 2.8911146817E-02, 2.8149546446E-02, 5.1689502396E-01],
	[1.1455000000E+04, 1.5043378124E+00, 3.6934073855E+00, 2.8947708058E-02, 2.8184458982E-02, 5.1705650428E-01],
	[1.1460000000E+04, 1.5051356701E+00, 3.6929464461E+00, 2.8984299488E-02, 2.8219398814E-02, 5.1721792762E-01],
	[1.1465000000E+04, 1.5059336026E+00, 3.6924857652E+00, 2.9020921120E-02, 2.8254365950E-02, 5.1737929398E-01],
	[1.1470000000E+04, 1.5067316100E+00, 3.6920253426E+00, 2.9057572965E-02, 2.8289360399E-02, 5.1754060337E-01],
	[1.1475000000E+04, 1.5075323023E+00, 3.6915690978E+00, 2.9094255035E-02, 2.8324383320E-02, 5.1770185579E-01],
	[1.1480000000E+04, 1.5083345164E+00, 3.6911152772E+00, 2.9130967341E-02, 2.8359434212E-02, 5.1786305125E-01],
	[1.1485000000E+04, 1.5091368078E+00, 3.6906617100E+00, 2.9167709895E-02, 2.8394512446E-02, 5.1802418975E-01],
	[1.1490000000E+04, 1.5099391765E+00, 3.6902083959E+00, 2.9204482709E-02, 2.8429618029E-02, 5.1818527129E-01],
	[1.1495000000E+04, 1.5107416224E+00, 3.6897553347E+00, 2.9241285795E-02, 2.8464750970E-02, 5.1834629589E-01],
	[1.1500000000E+04, 1.5115441456E+00, 3.6893025261E+00, 2.9278119163E-02, 2.8499911277E-02, 5.1850726353E-01],
	[1.1505000000E+04, 1.5123467459E+00, 3.6888499699E+00, 2.9314982827E-02, 2.8535098957E-02, 5.1866817422E-01],
	[1.1510000000E+04, 1.5131494234E+00, 3.6883976658E+00, 2.9351876797E-02, 2.8570314017E-02, 5.1882902798E-01],
	[1.1515000000E+04, 1.5139521780E+00, 3.6879456135E+00, 2.9388801085E-02, 2.8605556466E-02, 5.1898982480E-01],
	[1.1520000000E+04, 1.5147550097E+00, 3.6874938129E+00, 2.9425755702E-02, 2.8640826311E-02, 5.1915056469E-01],
	[1.1525000000E+04, 1.5155579185E+00, 3.6870422636E+00, 2.9462740662E-02, 2.8676123560E-02, 5.1931124765E-01],
	[1.1530000000E+04, 1.5163609043E+00, 3.6865909654E+00, 2.9499755974E-02, 2.8711448221E-02, 5.1947187368E-01],
	[1.1535000000E+04, 1.5171639672E+00, 3.6861399181E+00, 2.9536801651E-02, 2.8746800301E-02, 5.1963244280E-01],
	[1.1540000000E+04, 1.5179671071E+00, 3.6856891214E+00, 2.9573877704E-02, 2.8782179808E-02, 5.1979295500E-01],
	[1.1545000000E+04, 1.5187703239E+00, 3.6852385751E+00, 2.9610984146E-02, 2.8817586750E-02, 5.1995341028E-01],
	[1.1550000000E+04, 1.5195736177E+00, 3.6847882790E+00, 2.9648120987E-02, 2.8853021135E-02, 5.2011380866E-01],
	[1.1555000000E+04, 1.5203769884E+00, 3.6843382326E+00, 2.9685288240E-02, 2.8888482970E-02, 5.2027415014E-01],
	[1.1560000000E+04, 1.5211804361E+00, 3.6838884360E+00, 2.9722485915E-02, 2.8923972263E-02, 5.2043443472E-01],
	[1.1565000000E+04, 1.5219839605E+00, 3.6834388887E+00, 2.9759714026E-02, 2.8959489021E-02, 5.2059466241E-01],
	[1.1570000000E+04, 1.5227875619E+00, 3.6829895905E+00, 2.9796972583E-02, 2.8995033253E-02, 5.2075483320E-01],
	[1.1575000000E+04, 1.5235912400E+00, 3.6825405413E+00, 2.9834261598E-02, 2.9030604966E-02, 5.2091494711E-01],
	[1.1580000000E+04, 1.5243949950E+00, 3.6820917406E+00, 2.9871581082E-02, 2.9066204167E-02, 5.2107500414E-01],
	[1.1585000000E+04, 1.5251988267E+00, 3.6816431884E+00, 2.9908931048E-02, 2.9101830864E-02, 5.2123500430E-01],
	[1.1590000000E+04, 1.5260027352E+00, 3.6811948844E+00, 2.9946311507E-02, 2.9137485066E-02, 5.2139494758E-01],
	[1.1595000000E+04, 1.5268067204E+00, 3.6807468282E+00, 2.9983722470E-02, 2.9173166779E-02, 5.2155483399E-01],
	[1.1600000000E+04, 1.5276107822E+00, 3.6802990198E+00, 3.0021163950E-02, 2.9208876012E-02, 5.2171466355E-01],
	[1.1605000000E+04, 1.5284149208E+00, 3.6798514587E+00, 3.0058635957E-02, 2.9244612771E-02, 5.2187443625E-01],
	[1.1610000000E+04, 1.5292191360E+00, 3.6794041448E+00, 3.0096138505E-02, 2.9280377065E-02, 5.2203415209E-01],
	[1.1615000000E+04, 1.5300234278E+00, 3.6789570779E+00, 3.0133671603E-02, 2.9316168902E-02, 5.2219381109E-01],
	[1.1620000000E+04, 1.5308277961E+00, 3.6785102577E+00, 3.0171235265E-02, 2.9351988288E-02, 5.2235341324E-01],
	[1.1625000000E+04, 1.5316322411E+00, 3.6780636839E+00, 3.0208829501E-02, 2.9387835232E-02, 5.2251295856E-01],
	[1.1630000000E+04, 1.5324367626E+00, 3.6776173563E+00, 3.0246454323E-02, 2.9423709741E-02, 5.2267244705E-01],
	[1.1635000000E+04, 1.5332413606E+00, 3.6771712748E+00, 3.0284109743E-02, 2.9459611822E-02, 5.2283187871E-01],
	[1.1640000000E+04, 1.5340460350E+00, 3.6767254389E+00, 3.0321795772E-02, 2.9495541484E-02, 5.2299125354E-01],
	[1.1645000000E+04, 1.5348507860E+00, 3.6762798485E+00, 3.0359512423E-02, 2.9531498735E-02, 5.2315057156E-01],
	[1.1650000000E+04, 1.5356556134E+00, 3.6758345034E+00, 3.0397259706E-02, 2.9567483580E-02, 5.2330983276E-01],
	[1.1655000000E+04, 1.5364605171E+00, 3.6753894033E+00, 3.0435037634E-02, 2.9603496030E-02, 5.2346903716E-01],
	[1.1660000000E+04, 1.5372684108E+00, 3.6749487376E+00, 3.0472846218E-02, 2.9639537445E-02, 5.2362818476E-01],
	[1.1665000000E+04, 1.5380775867E+00, 3.6745100439E+00, 3.0510685470E-02, 2.9675607045E-02, 5.2378727555E-01],
	[1.1670000000E+04, 1.5388868414E+00, 3.6740715906E+00, 3.0548555401E-02, 2.9711704278E-02, 5.2394630956E-01],
	[1.1675000000E+04, 1.5396961750E+00, 3.6736333774E+00, 3.0586456023E-02, 2.9747829152E-02, 5.2410528678E-01],
	[1.1680000000E+04, 1.5405055874E+00, 3.6731954040E+00, 3.0624387347E-02, 2.9783981674E-02, 5.2426420722E-01],
	[1.1685000000E+04, 1.5413150787E+00, 3.6727576702E+00, 3.0662349386E-02, 2.9820161852E-02, 5.2442307089E-01],
	[1.1690000000E+04, 1.5421246487E+00, 3.6723201759E+00, 3.0700342151E-02, 2.9856369693E-02, 5.2458187778E-01],
	[1.1695000000E+04, 1.5429342975E+00, 3.6718829207E+00, 3.0738365654E-02, 2.9892605206E-02, 5.2474062791E-01],
	[1.1700000000E+04, 1.5437440251E+00, 3.6714459045E+00, 3.0776419905E-02, 2.9928868397E-02, 5.2489932128E-01],
	[1.1705000000E+04, 1.5445538313E+00, 3.6710091269E+00, 3.0814504918E-02, 2.9965159274E-02, 5.2505795790E-01],
	[1.1710000000E+04, 1.5453637162E+00, 3.6705725878E+00, 3.0852620703E-02, 3.0001477845E-02, 5.2521653777E-01],
	[1.1715000000E+04, 1.5461736798E+00, 3.6701362870E+00, 3.0890767272E-02, 3.0037824117E-02, 5.2537506090E-01],
	[1.1720000000E+04, 1.5469837220E+00, 3.6697002241E+00, 3.0928944637E-02, 3.0074198099E-02, 5.2553352729E-01],
	[1.1725000000E+04, 1.5477938428E+00, 3.6692643990E+00, 3.0967152810E-02, 3.0110599797E-02, 5.2569193694E-01],
	[1.1730000000E+04, 1.5486040422E+00, 3.6688288115E+00, 3.1005391801E-02, 3.0147029219E-02, 5.2585028988E-01],
	[1.1735000000E+04, 1.5494143201E+00, 3.6683934613E+00, 3.1043661623E-02, 3.0183486372E-02, 5.2600858609E-01],
	[1.1740000000E+04, 1.5502246766E+00, 3.6679583481E+00, 3.1081962287E-02, 3.0219971265E-02, 5.2616682559E-01],
	[1.1745000000E+04, 1.5510351115E+00, 3.6675234718E+00, 3.1120293806E-02, 3.0256483904E-02, 5.2632500839E-01],
	[1.1750000000E+04, 1.5518456250E+00, 3.6670888321E+00, 3.1158656190E-02, 3.0293024298E-02, 5.2648313448E-01],
	[1.1755000000E+04, 1.5526562168E+00, 3.6666544288E+00, 3.1197049451E-02, 3.0329592453E-02, 5.2664120387E-01],
	[1.1760000000E+04, 1.5534668871E+00, 3.6662202617E+00, 3.1235473601E-02, 3.0366188378E-02, 5.2679921657E-01],
	[1.1765000000E+04, 1.5542776358E+00, 3.6657863305E+00, 3.1273928651E-02, 3.0402812080E-02, 5.2695717259E-01],
	[1.1770000000E+04, 1.5550884629E+00, 3.6653526350E+00, 3.1312414614E-02, 3.0439463566E-02, 5.2711507194E-01],
	[1.1775000000E+04, 1.5558993683E+00, 3.6649191750E+00, 3.1350931500E-02, 3.0476142844E-02, 5.2727291461E-01],
	[1.1780000000E+04, 1.5567103521E+00, 3.6644859502E+00, 3.1389479322E-02, 3.0512849921E-02, 5.2743070061E-01],
	[1.1785000000E+04, 1.5575214141E+00, 3.6640529605E+00, 3.1428058091E-02, 3.0549584805E-02, 5.2758842995E-01],
	[1.1790000000E+04, 1.5583325544E+00, 3.6636202055E+00, 3.1466667818E-02, 3.0586347504E-02, 5.2774610265E-01],
	[1.1795000000E+04, 1.5591437729E+00, 3.6631876851E+00, 3.1505308516E-02, 3.0623138025E-02, 5.2790371869E-01],
	[1.1800000000E+04, 1.5599550697E+00, 3.6627553991E+00, 3.1543980195E-02, 3.0659956375E-02, 5.2806127809E-01],
	[1.1805000000E+04, 1.5607664446E+00, 3.6623233471E+00, 3.1582682868E-02, 3.0696802562E-02, 5.2821878086E-01],
	[1.1810000000E+04, 1.5615778977E+00, 3.6618915291E+00, 3.1621416547E-02, 3.0733676593E-02, 5.2837622699E-01],
	[1.1815000000E+04, 1.5623894290E+00, 3.6614599447E+00, 3.1660181241E-02, 3.0770578476E-02, 5.2853361651E-01],
	[1.1820000000E+04, 1.5632010383E+00, 3.6610285937E+00, 3.1698976965E-02, 3.0807508219E-02, 5.2869094941E-01],
	[1.1825000000E+04, 1.5640127258E+00, 3.6605974760E+00, 3.1737803728E-02, 3.0844465829E-02, 5.2884822570E-01],
	[1.1830000000E+04, 1.5648244913E+00, 3.6601665913E+00, 3.1776661543E-02, 3.0881451312E-02, 5.2900544539E-01],
	[1.1835000000E+04, 1.5656363349E+00, 3.6597359393E+00, 3.1815550422E-02, 3.0918464678E-02, 5.2916260848E-01],
	[1.1840000000E+04, 1.5664482564E+00, 3.6593055198E+00, 3.1854470375E-02, 3.0955505933E-02, 5.2931971498E-01],
	[1.1845000000E+04, 1.5672609958E+00, 3.6588763518E+00, 3.1893421414E-02, 3.0992575447E-02, 5.2947676490E-01],
	[1.1850000000E+04, 1.5680772540E+00, 3.6584521519E+00, 3.1932403552E-02, 3.1029674554E-02, 5.2963375824E-01],
	[1.1855000000E+04, 1.5688935928E+00, 3.6580281800E+00, 3.1971416800E-02, 3.1066801580E-02, 5.2979069501E-01],
	[1.1860000000E+04, 1.5697100120E+00, 3.6576044359E+00, 3.2010461169E-02, 3.1103956533E-02, 5.2994757521E-01],
	[1.1865000000E+04, 1.5705265117E+00, 3.6571809196E+00, 3.2049536671E-02, 3.1141139420E-02, 5.3010439886E-01],
	[1.1870000000E+04, 1.5713430919E+00, 3.6567576307E+00, 3.2088643318E-02, 3.1178350248E-02, 5.3026116596E-01],
	[1.1875000000E+04, 1.5721597524E+00, 3.6563345690E+00, 3.2127781120E-02, 3.1215589025E-02, 5.3041787652E-01],
	[1.1880000000E+04, 1.5729764934E+00, 3.6559117343E+00, 3.2166950091E-02, 3.1252855757E-02, 5.3057453054E-01],
	[1.1885000000E+04, 1.5737933147E+00, 3.6554891265E+00, 3.2206150241E-02, 3.1290150454E-02, 5.3073112803E-01],
	[1.1890000000E+04, 1.5746102163E+00, 3.6550667452E+00, 3.2245381583E-02, 3.1327473122E-02, 5.3088766897E-01],
	[1.1895000000E+04, 1.5754271982E+00, 3.6546445902E+00, 3.2284644126E-02, 3.1364823768E-02, 5.3104415337E-01],
	[1.1900000000E+04, 1.5762442604E+00, 3.6542226614E+00, 3.2323937885E-02, 3.1402202400E-02, 5.3120058123E-01],
	[1.1905000000E+04, 1.5770614029E+00, 3.6538009585E+00, 3.2363262869E-02, 3.1439609025E-02, 5.3135695255E-01],
	[1.1910000000E+04, 1.5778786256E+00, 3.6533794813E+00, 3.2402619091E-02, 3.1477043652E-02, 5.3151326734E-01],
	[1.1915000000E+04, 1.5786959285E+00, 3.6529582297E+00, 3.2442006562E-02, 3.1514506286E-02, 5.3166952559E-01],
	[1.1920000000E+04, 1.5795133115E+00, 3.6525372033E+00, 3.2481425293E-02, 3.1551996936E-02, 5.3182572730E-01],
	[1.1925000000E+04, 1.5803307747E+00, 3.6521164019E+00, 3.2520875298E-02, 3.1589515609E-02, 5.3198187249E-01],
	[1.1930000000E+04, 1.5811483181E+00, 3.6516958254E+00, 3.2560356586E-02, 3.1627062312E-02, 5.3213796115E-01],
	[1.1935000000E+04, 1.5819659415E+00, 3.6512754736E+00, 3.2599869169E-02, 3.1664637054E-02, 5.3229399329E-01],
	[1.1940000000E+04, 1.5827836450E+00, 3.6508553461E+00, 3.2639413060E-02, 3.1702239840E-02, 5.3244996891E-01],
	[1.1945000000E+04, 1.5836014286E+00, 3.6504354429E+00, 3.2678988270E-02, 3.1739870679E-02, 5.3260588801E-01],
	[1.1950000000E+04, 1.5844192922E+00, 3.6500157637E+00, 3.2718594810E-02, 3.1777529578E-02, 5.3276175060E-01],
	[1.1955000000E+04, 1.5852372358E+00, 3.6495963082E+00, 3.2758232693E-02, 3.1815216544E-02, 5.3291755667E-01],
	[1.1960000000E+04, 1.5860552593E+00, 3.6491770763E+00, 3.2797901929E-02, 3.1852931584E-02, 5.3307330624E-01],
	[1.1965000000E+04, 1.5868733628E+00, 3.6487580678E+00, 3.2837602530E-02, 3.1890674707E-02, 5.3322899930E-01],
	[1.1970000000E+04, 1.5876915462E+00, 3.6483392824E+00, 3.2877334508E-02, 3.1928445919E-02, 5.3338463585E-01],
	[1.1975000000E+04, 1.5885098096E+00, 3.6479207200E+00, 3.2917097875E-02, 3.1966245228E-02, 5.3354021591E-01],
	[1.1980000000E+04, 1.5893281527E+00, 3.6475023802E+00, 3.2956892641E-02, 3.2004072642E-02, 5.3369573947E-01],
	[1.1985000000E+04, 1.5901465758E+00, 3.6470842630E+00, 3.2996718820E-02, 3.2041928166E-02, 5.3385120653E-01],
	[1.1990000000E+04, 1.5909650786E+00, 3.6466663680E+00, 3.3036576421E-02, 3.2079811809E-02, 5.3400661711E-01],
	[1.1995000000E+04, 1.5917836612E+00, 3.6462486952E+00, 3.3076465458E-02, 3.2117723579E-02, 5.3416197120E-01],
	[1.2000000000E+04, 1.5926023236E+00, 3.6458312442E+00, 3.3116385941E-02, 3.2155663482E-02, 5.3431726881E-01],
	[1.2005000000E+04, 1.5934210658E+00, 3.6454140149E+00, 3.3156337882E-02, 3.2193631526E-02, 5.3447250993E-01],
	[1.2010000000E+04, 1.5942398876E+00, 3.6449970071E+00, 3.3196321293E-02, 3.2231627718E-02, 5.3462769458E-01],
	[1.2015000000E+04, 1.5950587892E+00, 3.6445802204E+00, 3.3236336186E-02, 3.2269652065E-02, 5.3478282276E-01],
	[1.2020000000E+04, 1.5958777704E+00, 3.6441636549E+00, 3.3276382571E-02, 3.2307704575E-02, 5.3493789446E-01],
	[1.2025000000E+04, 1.5966968312E+00, 3.6437473101E+00, 3.3316460460E-02, 3.2345785256E-02, 5.3509290970E-01],
	[1.2030000000E+04, 1.5975159717E+00, 3.6433311860E+00, 3.3356569866E-02, 3.2383894114E-02, 5.3524786848E-01],
	[1.2035000000E+04, 1.5983353707E+00, 3.6429155185E+00, 3.3396710800E-02, 3.2422031248E-02, 5.3540277079E-01],
	[1.2040000000E+04, 1.5991589143E+00, 3.6425054308E+00, 3.3436883273E-02, 3.2460198676E-02, 5.3555761666E-01],
	[1.2045000000E+04, 1.5999825400E+00, 3.6420955596E+00, 3.3477087296E-02, 3.2498394310E-02, 5.3571240607E-01],
	[1.2050000000E+04, 1.6008062478E+00, 3.6416859045E+00, 3.3517322882E-02, 3.2536618159E-02, 5.3586713903E-01],
	[1.2055000000E+04, 1.6016300378E+00, 3.6412764655E+00, 3.3557590043E-02, 3.2574870230E-02, 5.3602181554E-01],
	[1.2060000000E+04, 1.6024539097E+00, 3.6408672422E+00, 3.3597888789E-02, 3.2613150529E-02, 5.3617643562E-01],
	[1.2065000000E+04, 1.6032778637E+00, 3.6404582346E+00, 3.3638219132E-02, 3.2651459065E-02, 5.3633099926E-01],
	[1.2070000000E+04, 1.6041018997E+00, 3.6400494423E+00, 3.3678581085E-02, 3.2689795844E-02, 5.3648550647E-01],
	[1.2075000000E+04, 1.6049260177E+00, 3.6396408652E+00, 3.3718974657E-02, 3.2728160874E-02, 5.3663995725E-01],
	[1.2080000000E+04, 1.6057502176E+00, 3.6392325031E+00, 3.3759399862E-02, 3.2766554162E-02, 5.3679435160E-01],
	[1.2085000000E+04, 1.6065744995E+00, 3.6388243557E+00, 3.3799856711E-02, 3.2804975716E-02, 5.3694868953E-01],
	[1.2090000000E+04, 1.6073988633E+00, 3.6384164230E+00, 3.3840345214E-02, 3.2843425542E-02, 5.3710297105E-01],
	[1.2095000000E+04, 1.6082233089E+00, 3.6380087046E+00, 3.3880865385E-02, 3.2881903648E-02, 5.3725719615E-01],
	[1.2100000000E+04, 1.6090478364E+00, 3.6376012004E+00, 3.3921417234E-02, 3.2920410041E-02, 5.3741136485E-01],
	[1.2105000000E+04, 1.6098724457E+00, 3.6371939101E+00, 3.3962000773E-02, 3.2958944728E-02, 5.3756547714E-01],
	[1.2110000000E+04, 1.6106971368E+00, 3.6367868336E+00, 3.4002616014E-02, 3.2997507717E-02, 5.3771953303E-01],
	[1.2115000000E+04, 1.6115219097E+00, 3.6363799707E+00, 3.4043262968E-02, 3.3036099015E-02, 5.3787353252E-01],
	[1.2120000000E+04, 1.6123467644E+00, 3.6359733212E+00, 3.4083941647E-02, 3.3074718629E-02, 5.3802747563E-01],
	[1.2125000000E+04, 1.6131717007E+00, 3.6355668849E+00, 3.4124652062E-02, 3.3113366567E-02, 5.3818136234E-01],
	[1.2130000000E+04, 1.6139967188E+00, 3.6351606615E+00, 3.4165394225E-02, 3.3152042835E-02, 5.3833519267E-01],
	[1.2135000000E+04, 1.6148218185E+00, 3.6347546509E+00, 3.4206168148E-02, 3.3190747441E-02, 5.3848896663E-01],
	[1.2140000000E+04, 1.6156469999E+00, 3.6343488528E+00, 3.4246973842E-02, 3.3229480392E-02, 5.3864268421E-01],
	[1.2145000000E+04, 1.6164722629E+00, 3.6339432672E+00, 3.4287811319E-02, 3.3268241695E-02, 5.3879634542E-01],
	[1.2150000000E+04, 1.6172976075E+00, 3.6335378937E+00, 3.4328680590E-02, 3.3307031358E-02, 5.3894995026E-01],
	[1.2155000000E+04, 1.6181230337E+00, 3.6331327322E+00, 3.4369581667E-02, 3.3345849388E-02, 5.3910349875E-01],
	[1.2160000000E+04, 1.6189485414E+00, 3.6327277825E+00, 3.4410514561E-02, 3.3384695791E-02, 5.3925699088E-01],
	[1.2165000000E+04, 1.6197741306E+00, 3.6323230443E+00, 3.4451479285E-02, 3.3423570576E-02, 5.3941042665E-01],
	[1.2170000000E+04, 1.6205998013E+00, 3.6319185176E+00, 3.4492475849E-02, 3.3462473749E-02, 5.3956380609E-01],
	[1.2175000000E+04, 1.6214255535E+00, 3.6315142020E+00, 3.4533504265E-02, 3.3501405317E-02, 5.3971712918E-01],
	[1.2180000000E+04, 1.6222513871E+00, 3.6311100974E+00, 3.4574564546E-02, 3.3540365288E-02, 5.3987039593E-01],
	[1.2185000000E+04, 1.6230773022E+00, 3.6307062036E+00, 3.4615656701E-02, 3.3579353670E-02, 5.4002360635E-01],
	[1.2190000000E+04, 1.6239032986E+00, 3.6303025205E+00, 3.4656780744E-02, 3.3618370468E-02, 5.4017676044E-01],
	[1.2195000000E+04, 1.6247293764E+00, 3.6298990477E+00, 3.4697936686E-02, 3.3657415690E-02, 5.4032985821E-01],
	[1.2200000000E+04, 1.6255555356E+00, 3.6294957851E+00, 3.4739124537E-02, 3.3696489344E-02, 5.4048289967E-01],
	[1.2205000000E+04, 1.6263817760E+00, 3.6290927325E+00, 3.4780344310E-02, 3.3735591437E-02, 5.4063588481E-01],
	[1.2210000000E+04, 1.6272080978E+00, 3.6286898898E+00, 3.4821596017E-02, 3.3774721975E-02, 5.4078881364E-01],
	[1.2215000000E+04, 1.6280345008E+00, 3.6282872566E+00, 3.4862879668E-02, 3.3813880966E-02, 5.4094168617E-01],
	[1.2220000000E+04, 1.6288609850E+00, 3.6278848329E+00, 3.4904195276E-02, 3.3853068417E-02, 5.4109450240E-01],
	[1.2225000000E+04, 1.6296875505E+00, 3.6274826185E+00, 3.4945542852E-02, 3.3892284336E-02, 5.4124726234E-01],
	[1.2230000000E+04, 1.6305154612E+00, 3.6270822100E+00, 3.4986922408E-02, 3.3931529416E-02, 5.4139996599E-01],
	[1.2235000000E+04, 1.6313464980E+00, 3.6266858531E+00, 3.5028333954E-02, 3.3970804637E-02, 5.4155261336E-01],
	[1.2240000000E+04, 1.6321776187E+00, 3.6262897015E+00, 3.5069777504E-02, 3.4010108355E-02, 5.4170520446E-01],
	[1.2245000000E+04, 1.6330088230E+00, 3.6258937550E+00, 3.5111253068E-02, 3.4049440577E-02, 5.4185773928E-01],
	[1.2250000000E+04, 1.6338401111E+00, 3.6254980132E+00, 3.5152760657E-02, 3.4088801310E-02, 5.4201021784E-01],
	[1.2255000000E+04, 1.6346714829E+00, 3.6251024762E+00, 3.5194300285E-02, 3.4128190561E-02, 5.4216264013E-01],
	[1.2260000000E+04, 1.6355029383E+00, 3.6247071436E+00, 3.5235871961E-02, 3.4167608337E-02, 5.4231500617E-01],
	[1.2265000000E+04, 1.6363344773E+00, 3.6243120153E+00, 3.5277475698E-02, 3.4207054646E-02, 5.4246731596E-01],
	[1.2270000000E+04, 1.6371661000E+00, 3.6239170911E+00, 3.5319111507E-02, 3.4246529495E-02, 5.4261956950E-01],
	[1.2275000000E+04, 1.6379978062E+00, 3.6235223708E+00, 3.5360779400E-02, 3.4286032890E-02, 5.4277176681E-01],
	[1.2280000000E+04, 1.6388295959E+00, 3.6231278542E+00, 3.5402479389E-02, 3.4325564839E-02, 5.4292390788E-01],
	[1.2285000000E+04, 1.6396614692E+00, 3.6227335411E+00, 3.5444211484E-02, 3.4365125348E-02, 5.4307599272E-01],
	[1.2290000000E+04, 1.6404934260E+00, 3.6223394314E+00, 3.5485975698E-02, 3.4404714426E-02, 5.4322802135E-01],
	[1.2295000000E+04, 1.6413254663E+00, 3.6219455249E+00, 3.5527772042E-02, 3.4444332079E-02, 5.4337999375E-01],
	[1.2300000000E+04, 1.6421575900E+00, 3.6215518213E+00, 3.5569600527E-02, 3.4483978314E-02, 5.4353190994E-01],
	[1.2305000000E+04, 1.6429897971E+00, 3.6211583204E+00, 3.5611461166E-02, 3.4523653139E-02, 5.4368376993E-01],
	[1.2310000000E+04, 1.6438220876E+00, 3.6207650222E+00, 3.5653353969E-02, 3.4563356560E-02, 5.4383557371E-01],
	[1.2315000000E+04, 1.6446544615E+00, 3.6203719264E+00, 3.5695278949E-02, 3.4603088584E-02, 5.4398732131E-01],
	[1.2320000000E+04, 1.6454869188E+00, 3.6199790328E+00, 3.5737236116E-02, 3.4642849219E-02, 5.4413901271E-01],
	[1.2325000000E+04, 1.6463194593E+00, 3.6195863412E+00, 3.5779225484E-02, 3.4682638472E-02, 5.4429064793E-01],
	[1.2330000000E+04, 1.6471520832E+00, 3.6191938515E+00, 3.5821247062E-02, 3.4722456349E-02, 5.4444222698E-01],
	[1.2335000000E+04, 1.6479847903E+00, 3.6188015634E+00, 3.5863300862E-02, 3.4762302858E-02, 5.4459374985E-01],
	[1.2340000000E+04, 1.6488175807E+00, 3.6184094769E+00, 3.5905386897E-02, 3.4802178006E-02, 5.4474521656E-01],
	[1.2345000000E+04, 1.6496504543E+00, 3.6180175916E+00, 3.5947505178E-02, 3.4842081800E-02, 5.4489662712E-01],
	[1.2350000000E+04, 1.6504834110E+00, 3.6176259074E+00, 3.5989655716E-02, 3.4882014247E-02, 5.4504798151E-01],
	[1.2355000000E+04, 1.6513164510E+00, 3.6172344241E+00, 3.6031838522E-02, 3.4921975353E-02, 5.4519927977E-01],
	[1.2360000000E+04, 1.6521495741E+00, 3.6168431416E+00, 3.6074053609E-02, 3.4961965127E-02, 5.4535052188E-01],
	[1.2365000000E+04, 1.6529827803E+00, 3.6164520596E+00, 3.6116300988E-02, 3.5001983575E-02, 5.4550170785E-01],
	[1.2370000000E+04, 1.6538160696E+00, 3.6160611780E+00, 3.6158580671E-02, 3.5042030704E-02, 5.4565283770E-01],
	[1.2375000000E+04, 1.6546494420E+00, 3.6156704966E+00, 3.6200892668E-02, 3.5082106521E-02, 5.4580391143E-01],
	[1.2380000000E+04, 1.6554828974E+00, 3.6152800152E+00, 3.6243236993E-02, 3.5122211034E-02, 5.4595492904E-01],
	[1.2385000000E+04, 1.6563164358E+00, 3.6148897336E+00, 3.6285613655E-02, 3.5162344248E-02, 5.4610589054E-01],
	[1.2390000000E+04, 1.6571500572E+00, 3.6144996516E+00, 3.6328022667E-02, 3.5202506172E-02, 5.4625679594E-01],
	[1.2395000000E+04, 1.6579837616E+00, 3.6141097691E+00, 3.6370464041E-02, 3.5242696812E-02, 5.4640764524E-01],
	[1.2400000000E+04, 1.6588175489E+00, 3.6137200859E+00, 3.6412937787E-02, 3.5282916175E-02, 5.4655843845E-01],
	[1.2405000000E+04, 1.6596514191E+00, 3.6133306018E+00, 3.6455443918E-02, 3.5323164268E-02, 5.4670917558E-01],
	[1.2410000000E+04, 1.6604853723E+00, 3.6129413165E+00, 3.6497982444E-02, 3.5363441099E-02, 5.4685985663E-01],
	[1.2415000000E+04, 1.6613194083E+00, 3.6125522300E+00, 3.6540553379E-02, 3.5403746674E-02, 5.4701048160E-01],
	[1.2420000000E+04, 1.6621535271E+00, 3.6121633421E+00, 3.6583156732E-02, 3.5444081000E-02, 5.4716105052E-01],
	[1.2425000000E+04, 1.6629877287E+00, 3.6117746525E+00, 3.6625792516E-02, 3.5484444084E-02, 5.4731156337E-01],
	[1.2430000000E+04, 1.6638260417E+00, 3.6113910347E+00, 3.6668460742E-02, 3.5524838242E-02, 5.4746202018E-01],
	[1.2435000000E+04, 1.6646647860E+00, 3.6110080303E+00, 3.6711161422E-02, 3.5565261378E-02, 5.4761242093E-01],
	[1.2440000000E+04, 1.6655036156E+00, 3.6106252205E+00, 3.6753894567E-02, 3.5605713301E-02, 5.4776276565E-01],
	[1.2445000000E+04, 1.6663425306E+00, 3.6102426051E+00, 3.6796660189E-02, 3.5646194020E-02, 5.4791305434E-01],
	[1.2450000000E+04, 1.6671815309E+00, 3.6098601840E+00, 3.6839458299E-02, 3.5686703540E-02, 5.4806328701E-01],
	[1.2455000000E+04, 1.6680206166E+00, 3.6094779568E+00, 3.6882288910E-02, 3.5727241868E-02, 5.4821346365E-01],
	[1.2460000000E+04, 1.6688597875E+00, 3.6090959235E+00, 3.6925152031E-02, 3.5767809012E-02, 5.4836358429E-01],
	[1.2465000000E+04, 1.6696990436E+00, 3.6087140839E+00, 3.6968047676E-02, 3.5808404979E-02, 5.4851364892E-01],
	[1.2470000000E+04, 1.6705383850E+00, 3.6083324378E+00, 3.7010975856E-02, 3.5849029775E-02, 5.4866365755E-01],
	[1.2475000000E+04, 1.6713778116E+00, 3.6079509851E+00, 3.7053936581E-02, 3.5889683407E-02, 5.4881361019E-01],
	[1.2480000000E+04, 1.6722173233E+00, 3.6075697255E+00, 3.7096929864E-02, 3.5930365883E-02, 5.4896350685E-01],
	[1.2485000000E+04, 1.6730569202E+00, 3.6071886588E+00, 3.7139955717E-02, 3.5971077209E-02, 5.4911334753E-01],
	[1.2490000000E+04, 1.6738966022E+00, 3.6068077850E+00, 3.7183014150E-02, 3.6011817392E-02, 5.4926313224E-01],
	[1.2495000000E+04, 1.6747363693E+00, 3.6064271038E+00, 3.7226105176E-02, 3.6052586440E-02, 5.4941286098E-01],
	[1.2500000000E+04, 1.6755762215E+00, 3.6060466151E+00, 3.7269228805E-02, 3.6093384359E-02, 5.4956253378E-01],
	[1.2505000000E+04, 1.6764161587E+00, 3.6056663187E+00, 3.7312843076E-02, 3.6134640713E-02, 5.4971215062E-01],
	[1.2510000000E+04, 1.6772561810E+00, 3.6052862143E+00, 3.7356490864E-02, 3.6175926741E-02, 5.4986171152E-01],
	[1.2515000000E+04, 1.6780962882E+00, 3.6049063019E+00, 3.7400172183E-02, 3.6217242450E-02, 5.5001121649E-01],
	[1.2520000000E+04, 1.6789364804E+00, 3.6045265813E+00, 3.7443887043E-02, 3.6258587848E-02, 5.5016066553E-01],
	[1.2525000000E+04, 1.6797767576E+00, 3.6041470523E+00, 3.7487635459E-02, 3.6299962943E-02, 5.5031005865E-01],
	[1.2530000000E+04, 1.6806171196E+00, 3.6037677146E+00, 3.7531417441E-02, 3.6341367741E-02, 5.5045939594E-01],
	[1.2535000000E+04, 1.6814575666E+00, 3.6033885682E+00, 3.7575233003E-02, 3.6382802251E-02, 5.5060867758E-01],
	[1.2540000000E+04, 1.6822980984E+00, 3.6030096129E+00, 3.7619082155E-02, 3.6424266479E-02, 5.5075790355E-01],
	[1.2545000000E+04, 1.6831387151E+00, 3.6026308485E+00, 3.7662964912E-02, 3.6465760433E-02, 5.5090707387E-01],
	[1.2550000000E+04, 1.6839794166E+00, 3.6022522748E+00, 3.7706881285E-02, 3.6507284121E-02, 5.5105618854E-01],
	[1.2555000000E+04, 1.6848202029E+00, 3.6018738917E+00, 3.7750831286E-02, 3.6548837549E-02, 5.5120524756E-01],
	[1.2560000000E+04, 1.6856610739E+00, 3.6014956989E+00, 3.7794814927E-02, 3.6590420726E-02, 5.5135425094E-01],
	[1.2565000000E+04, 1.6865020297E+00, 3.6011176964E+00, 3.7838832222E-02, 3.6632033658E-02, 5.5150319866E-01],
	[1.2570000000E+04, 1.6873430702E+00, 3.6007398839E+00, 3.7882883181E-02, 3.6673676354E-02, 5.5165209075E-01],
	[1.2575000000E+04, 1.6881841954E+00, 3.6003622612E+00, 3.7926967818E-02, 3.6715348819E-02, 5.5180092719E-01],
	[1.2580000000E+04, 1.6890254053E+00, 3.5999848283E+00, 3.7971086145E-02, 3.6757051063E-02, 5.5194970800E-01],
	[1.2585000000E+04, 1.6898666998E+00, 3.5996075849E+00, 3.8015238173E-02, 3.6798783092E-02, 5.5209843317E-01],
	[1.2590000000E+04, 1.6907080790E+00, 3.5992305308E+00, 3.8059423916E-02, 3.6840544913E-02, 5.5224710270E-01],
	[1.2595000000E+04, 1.6915495427E+00, 3.5988536660E+00, 3.8103643386E-02, 3.6882336535E-02, 5.5239571661E-01],
	[1.2600000000E+04, 1.6923910909E+00, 3.5984769901E+00, 3.8147896594E-02, 3.6924157964E-02, 5.5254427490E-01],
	[1.2605000000E+04, 1.6932327238E+00, 3.5981005031E+00, 3.8192183553E-02, 3.6966009207E-02, 5.5269277755E-01],
	[1.2610000000E+04, 1.6940744411E+00, 3.5977242048E+00, 3.8236504276E-02, 3.7007890272E-02, 5.5284122459E-01],
	[1.2615000000E+04, 1.6949162429E+00, 3.5973480949E+00, 3.8280858774E-02, 3.7049801167E-02, 5.5298961601E-01],
	[1.2620000000E+04, 1.6957581292E+00, 3.5969721735E+00, 3.8325247060E-02, 3.7091741899E-02, 5.5313795181E-01],
	[1.2625000000E+04, 1.6966001000E+00, 3.5965964401E+00, 3.8369669147E-02, 3.7133712475E-02, 5.5328623200E-01],
	[1.2630000000E+04, 1.6974462299E+00, 3.5962256299E+00, 3.8414125046E-02, 3.7175715362E-02, 5.5343445658E-01],
	[1.2635000000E+04, 1.6982928278E+00, 3.5958554472E+00, 3.8458614769E-02, 3.7217748347E-02, 5.5358262555E-01],
	[1.2640000000E+04, 1.6991395126E+00, 3.5954854490E+00, 3.8503138330E-02, 3.7259811208E-02, 5.5373073892E-01],
	[1.2645000000E+04, 1.6999862845E+00, 3.5951156351E+00, 3.8547695740E-02, 3.7301903950E-02, 5.5387879669E-01],
	[1.2650000000E+04, 1.7008331433E+00, 3.5947460055E+00, 3.8592287012E-02, 3.7344026583E-02, 5.5402679886E-01],
	[1.2655000000E+04, 1.7016800891E+00, 3.5943765600E+00, 3.8636912157E-02, 3.7386179113E-02, 5.5417474544E-01],
	[1.2660000000E+04, 1.7025271218E+00, 3.5940072983E+00, 3.8681571189E-02, 3.7428361547E-02, 5.5432263642E-01],
	[1.2665000000E+04, 1.7033742415E+00, 3.5936382204E+00, 3.8726264118E-02, 3.7470573894E-02, 5.5447047182E-01],
	[1.2670000000E+04, 1.7042214480E+00, 3.5932693260E+00, 3.8770990959E-02, 3.7512816159E-02, 5.5461825164E-01],
	[1.2675000000E+04, 1.7050687414E+00, 3.5929006150E+00, 3.8815751722E-02, 3.7555088351E-02, 5.5476597587E-01],
	[1.2680000000E+04, 1.7059161216E+00, 3.5925320872E+00, 3.8860546421E-02, 3.7597390477E-02, 5.5491364453E-01],
	[1.2685000000E+04, 1.7067635886E+00, 3.5921637425E+00, 3.8905375067E-02, 3.7639722544E-02, 5.5506125761E-01],
	[1.2690000000E+04, 1.7076111424E+00, 3.5917955807E+00, 3.8950237673E-02, 3.7682084559E-02, 5.5520881512E-01],
	[1.2695000000E+04, 1.7084587829E+00, 3.5914276017E+00, 3.8995134251E-02, 3.7724476530E-02, 5.5535631706E-01],
	[1.2700000000E+04, 1.7093065102E+00, 3.5910598052E+00, 3.9040064813E-02, 3.7766898464E-02, 5.5550376344E-01],
	[1.2705000000E+04, 1.7101543242E+00, 3.5906921911E+00, 3.9085029372E-02, 3.7809350368E-02, 5.5565115426E-01],
	[1.2710000000E+04, 1.7110022248E+00, 3.5903247593E+00, 3.9130027939E-02, 3.7851832250E-02, 5.5579848953E-01],
	[1.2715000000E+04, 1.7118502121E+00, 3.5899575096E+00, 3.9175060528E-02, 3.7894344117E-02, 5.5594576924E-01],
	[1.2720000000E+04, 1.7126982861E+00, 3.5895904419E+00, 3.9220127150E-02, 3.7936885975E-02, 5.5609299340E-01],
	[1.2725000000E+04, 1.7135464466E+00, 3.5892235559E+00, 3.9265227818E-02, 3.7979457833E-02, 5.5624016202E-01],
	[1.2730000000E+04, 1.7143946937E+00, 3.5888568515E+00, 3.9310362543E-02, 3.8022059698E-02, 5.5638727510E-01],
	[1.2735000000E+04, 1.7152430274E+00, 3.5884903285E+00, 3.9355531339E-02, 3.8064691577E-02, 5.5653433264E-01],
	[1.2740000000E+04, 1.7160914476E+00, 3.5881239868E+00, 3.9400734217E-02, 3.8107353476E-02, 5.5668133464E-01],
	[1.2745000000E+04, 1.7169399543E+00, 3.5877578263E+00, 3.9445971189E-02, 3.8150045404E-02, 5.5682828112E-01],
	[1.2750000000E+04, 1.7177885475E+00, 3.5873918467E+00, 3.9491242269E-02, 3.8192767368E-02, 5.5697517207E-01],
	[1.2755000000E+04, 1.7186372271E+00, 3.5870260480E+00, 3.9536547468E-02, 3.8235519374E-02, 5.5712200750E-01],
	[1.2760000000E+04, 1.7194859932E+00, 3.5866604298E+00, 3.9581886798E-02, 3.8278301431E-02, 5.5726878741E-01],
	[1.2765000000E+04, 1.7203348456E+00, 3.5862949922E+00, 3.9627260272E-02, 3.8321113545E-02, 5.5741551180E-01],
	[1.2770000000E+04, 1.7211837845E+00, 3.5859297349E+00, 3.9672667902E-02, 3.8363955723E-02, 5.5756218069E-01],
	[1.2775000000E+04, 1.7220328096E+00, 3.5855646577E+00, 3.9718109700E-02, 3.8406827974E-02, 5.5770879407E-01],
	[1.2780000000E+04, 1.7228819212E+00, 3.5851997606E+00, 3.9763585679E-02, 3.8449730303E-02, 5.5785535195E-01],
	[1.2785000000E+04, 1.7237311190E+00, 3.5848350433E+00, 3.9809095851E-02, 3.8492662718E-02, 5.5800185434E-01],
	[1.2790000000E+04, 1.7245804031E+00, 3.5844705056E+00, 3.9854640227E-02, 3.8535625227E-02, 5.5814830123E-01],
	[1.2795000000E+04, 1.7254297734E+00, 3.5841061475E+00, 3.9900218821E-02, 3.8578617836E-02, 5.5829469263E-01],
	[1.2800000000E+04, 1.7262792300E+00, 3.5837419688E+00, 3.9945831645E-02, 3.8621640553E-02, 5.5844102855E-01],
	[1.2805000000E+04, 1.7271287727E+00, 3.5833779693E+00, 3.9991478710E-02, 3.8664693385E-02, 5.5858730899E-01],
	[1.2810000000E+04, 1.7279784017E+00, 3.5830141489E+00, 4.0037160029E-02, 3.8707776340E-02, 5.5873353396E-01],
	[1.2815000000E+04, 1.7288281168E+00, 3.5826505073E+00, 4.0082875615E-02, 3.8750889423E-02, 5.5887970345E-01],
	[1.2820000000E+04, 1.7296779180E+00, 3.5822870445E+00, 4.0128625480E-02, 3.8794032643E-02, 5.5902581748E-01],
	[1.2825000000E+04, 1.7305278053E+00, 3.5819237603E+00, 4.0174409635E-02, 3.8837206007E-02, 5.5917187605E-01],
	[1.2830000000E+04, 1.7313789795E+00, 3.5815619981E+00, 4.0220228093E-02, 3.8880410285E-02, 5.5931787915E-01],
	[1.2835000000E+04, 1.7322335879E+00, 3.5812041570E+00, 4.0266080867E-02, 3.8923646856E-02, 5.5946382681E-01],
	[1.2840000000E+04, 1.7330882849E+00, 3.5808464909E+00, 4.0311967968E-02, 3.8966913602E-02, 5.5960971902E-01],
	[1.2845000000E+04, 1.7339430707E+00, 3.5804889998E+00, 4.0357889409E-02, 3.9010210530E-02, 5.5975555579E-01],
	[1.2850000000E+04, 1.7347979452E+00, 3.5801316835E+00, 4.0403845202E-02, 3.9053537647E-02, 5.5990133712E-01],
	[1.2855000000E+04, 1.7356529083E+00, 3.5797745418E+00, 4.0449835360E-02, 3.9096894961E-02, 5.6004706301E-01],
	[1.2860000000E+04, 1.7365079600E+00, 3.5794175746E+00, 4.0495859894E-02, 3.9140282478E-02, 5.6019273348E-01],
	[1.2865000000E+04, 1.7373631004E+00, 3.5790607818E+00, 4.0541918818E-02, 3.9183700205E-02, 5.6033834852E-01],
	[1.2870000000E+04, 1.7382183293E+00, 3.5787041631E+00, 4.0588012142E-02, 3.9227148150E-02, 5.6048390814E-01],
	[1.2875000000E+04, 1.7390736468E+00, 3.5783477185E+00, 4.0634139880E-02, 3.9270626320E-02, 5.6062941235E-01],
	[1.2880000000E+04, 1.7399290528E+00, 3.5779914478E+00, 4.0680302043E-02, 3.9314134721E-02, 5.6077486115E-01],
	[1.2885000000E+04, 1.7407845473E+00, 3.5776353508E+00, 4.0726498645E-02, 3.9357673362E-02, 5.6092025455E-01],
	[1.2890000000E+04, 1.7416401303E+00, 3.5772794273E+00, 4.0772729696E-02, 3.9401242250E-02, 5.6106559254E-01],
	[1.2895000000E+04, 1.7424958018E+00, 3.5769236773E+00, 4.0818995210E-02, 3.9444841390E-02, 5.6121087515E-01],
	[1.2900000000E+04, 1.7433515616E+00, 3.5765681006E+00, 4.0865295199E-02, 3.9488470791E-02, 5.6135610236E-01],
	[1.2905000000E+04, 1.7442074099E+00, 3.5762126969E+00, 4.0911629674E-02, 3.9532130460E-02, 5.6150127419E-01],
	[1.2910000000E+04, 1.7450633466E+00, 3.5758574663E+00, 4.0957998649E-02, 3.9575820403E-02, 5.6164639064E-01],
	[1.2915000000E+04, 1.7459193716E+00, 3.5755024084E+00, 4.1004402135E-02, 3.9619540628E-02, 5.6179145172E-01],
	[1.2920000000E+04, 1.7467754849E+00, 3.5751475233E+00, 4.1050840145E-02, 3.9663291142E-02, 5.6193645743E-01],
	[1.2925000000E+04, 1.7476316866E+00, 3.5747928106E+00, 4.1097312691E-02, 3.9707071952E-02, 5.6208140778E-01],
	[1.2930000000E+04, 1.7484879765E+00, 3.5744382703E+00, 4.1143819785E-02, 3.9750883065E-02, 5.6222630277E-01],
	[1.2935000000E+04, 1.7493443547E+00, 3.5740839023E+00, 4.1190361439E-02, 3.9794724488E-02, 5.6237114241E-01],
	[1.2940000000E+04, 1.7502008211E+00, 3.5737297063E+00, 4.1236937666E-02, 3.9838596228E-02, 5.6251592670E-01],
	[1.2945000000E+04, 1.7510573757E+00, 3.5733756822E+00, 4.1283548478E-02, 3.9882498293E-02, 5.6266065565E-01],
	[1.2950000000E+04, 1.7519140185E+00, 3.5730218299E+00, 4.1330193887E-02, 3.9926430689E-02, 5.6280532927E-01],
	[1.2955000000E+04, 1.7527707494E+00, 3.5726681491E+00, 4.1376873905E-02, 3.9970393423E-02, 5.6294994755E-01],
	[1.2960000000E+04, 1.7536275685E+00, 3.5723146399E+00, 4.1423588545E-02, 4.0014386503E-02, 5.6309451051E-01],
	[1.2965000000E+04, 1.7544844757E+00, 3.5719613020E+00, 4.1470337819E-02, 4.0058409935E-02, 5.6323901815E-01],
	[1.2970000000E+04, 1.7553414709E+00, 3.5716081352E+00, 4.1517121739E-02, 4.0102463727E-02, 5.6338347048E-01],
	[1.2975000000E+04, 1.7561985542E+00, 3.5712551395E+00, 4.1563940318E-02, 4.0146547886E-02, 5.6352786750E-01],
	[1.2980000000E+04, 1.7570557256E+00, 3.5709023146E+00, 4.1610793567E-02, 4.0190662418E-02, 5.6367220922E-01],
	[1.2985000000E+04, 1.7579129849E+00, 3.5705496605E+00, 4.1657681499E-02, 4.0234807331E-02, 5.6381649564E-01],
	[1.2990000000E+04, 1.7587703322E+00, 3.5701971769E+00, 4.1704604126E-02, 4.0278982632E-02, 5.6396072677E-01],
	[1.2995000000E+04, 1.7596277675E+00, 3.5698448638E+00, 4.1751561461E-02, 4.0323188327E-02, 5.6410490262E-01],
	[1.3000000000E+04, 1.7604852907E+00, 3.5694927209E+00, 4.1798553515E-02, 4.0367424424E-02, 5.6424902318E-01],
	[1.3005000000E+04, 1.7613429018E+00, 3.5691407482E+00, 4.1845580301E-02, 4.0411690930E-02, 5.6439308848E-01],
	[1.3010000000E+04, 1.7622006008E+00, 3.5687889454E+00, 4.1892641831E-02, 4.0455987852E-02, 5.6453709851E-01],
	[1.3015000000E+04, 1.7630583876E+00, 3.5684373125E+00, 4.1939738117E-02, 4.0500315197E-02, 5.6468105327E-01],
	[1.3020000000E+04, 1.7639162623E+00, 3.5680858493E+00, 4.1986869172E-02, 4.0544672971E-02, 5.6482495278E-01],
	[1.3025000000E+04, 1.7647742247E+00, 3.5677345556E+00, 4.2034035008E-02, 4.0589061182E-02, 5.6496879704E-01],
	[1.3030000000E+04, 1.7656322750E+00, 3.5673834313E+00, 4.2081235636E-02, 4.0633479837E-02, 5.6511258606E-01],
	[1.3035000000E+04, 1.7664904130E+00, 3.5670324762E+00, 4.2128471070E-02, 4.0677928943E-02, 5.6525631984E-01],
	[1.3040000000E+04, 1.7673530913E+00, 3.5666864855E+00, 4.2175741322E-02, 4.0722411495E-02, 5.6539999839E-01],
	[1.3045000000E+04, 1.7682160493E+00, 3.5663408648E+00, 4.2223046403E-02, 4.0766924650E-02, 5.6554362172E-01],
	[1.3050000000E+04, 1.7690790977E+00, 3.5659954100E+00, 4.2270386327E-02, 4.0811468286E-02, 5.6568718983E-01],
	[1.3055000000E+04, 1.7699422365E+00, 3.5656501210E+00, 4.2317761104E-02, 4.0856042411E-02, 5.6583070272E-01],
	[1.3060000000E+04, 1.7708054657E+00, 3.5653049976E+00, 4.2365170748E-02, 4.0900647031E-02, 5.6597416041E-01],
	[1.3065000000E+04, 1.7716687852E+00, 3.5649600398E+00, 4.2412615271E-02, 4.0945282155E-02, 5.6611756290E-01],
	[1.3070000000E+04, 1.7725321950E+00, 3.5646152472E+00, 4.2460094685E-02, 4.0989947788E-02, 5.6626091019E-01],
	[1.3075000000E+04, 1.7733956951E+00, 3.5642706199E+00, 4.2507609002E-02, 4.1034643938E-02, 5.6640420230E-01],
	[1.3080000000E+04, 1.7742592855E+00, 3.5639261576E+00, 4.2555158234E-02, 4.1079370612E-02, 5.6654743923E-01],
	[1.3085000000E+04, 1.7751229662E+00, 3.5635818603E+00, 4.2602742394E-02, 4.1124127816E-02, 5.6669062098E-01],
	[1.3090000000E+04, 1.7759867371E+00, 3.5632377277E+00, 4.2650361494E-02, 4.1168915558E-02, 5.6683374756E-01],
	[1.3095000000E+04, 1.7768505981E+00, 3.5628937597E+00, 4.2698015546E-02, 4.1213733845E-02, 5.6697681899E-01],
	[1.3100000000E+04, 1.7777145494E+00, 3.5625499563E+00, 4.2745704562E-02, 4.1258582683E-02, 5.6711983525E-01],
	[1.3105000000E+04, 1.7785785908E+00, 3.5622063172E+00, 4.2793428555E-02, 4.1303462079E-02, 5.6726279637E-01],
	[1.3110000000E+04, 1.7794427223E+00, 3.5618628423E+00, 4.2841187537E-02, 4.1348372041E-02, 5.6740570235E-01],
	[1.3115000000E+04, 1.7803069439E+00, 3.5615195315E+00, 4.2888981520E-02, 4.1393312575E-02, 5.6754855320E-01],
	[1.3120000000E+04, 1.7811712555E+00, 3.5611763847E+00, 4.2936810516E-02, 4.1438283689E-02, 5.6769134891E-01],
	[1.3125000000E+04, 1.7820356573E+00, 3.5608334016E+00, 4.2984674538E-02, 4.1483285388E-02, 5.6783408950E-01],
	[1.3130000000E+04, 1.7829001490E+00, 3.5604905822E+00, 4.3032573597E-02, 4.1528317680E-02, 5.6797677498E-01],
	[1.3135000000E+04, 1.7837647307E+00, 3.5601479262E+00, 4.3080507707E-02, 4.1573380573E-02, 5.6811940535E-01],
	[1.3140000000E+04, 1.7846294024E+00, 3.5598054337E+00, 4.3128476878E-02, 4.1618474072E-02, 5.6826198062E-01],
	[1.3145000000E+04, 1.7854941641E+00, 3.5594631044E+00, 4.3176481124E-02, 4.1663598185E-02, 5.6840450079E-01],
	[1.3150000000E+04, 1.7863590157E+00, 3.5591209381E+00, 4.3224520457E-02, 4.1708752918E-02, 5.6854696588E-01],
	[1.3155000000E+04, 1.7872239571E+00, 3.5587789348E+00, 4.3272594889E-02, 4.1753938280E-02, 5.6868937589E-01],
	[1.3160000000E+04, 1.7880889885E+00, 3.5584370944E+00, 4.3320704432E-02, 4.1799154275E-02, 5.6883173082E-01],
	[1.3165000000E+04, 1.7889541097E+00, 3.5580954166E+00, 4.3368849098E-02, 4.1844400912E-02, 5.6897403068E-01],
	[1.3170000000E+04, 1.7898193207E+00, 3.5577539013E+00, 4.3417028900E-02, 4.1889678197E-02, 5.6911627549E-01],
	[1.3175000000E+04, 1.7906846215E+00, 3.5574125484E+00, 4.3465243849E-02, 4.1934986137E-02, 5.6925846524E-01],
	[1.3180000000E+04, 1.7915500121E+00, 3.5570713578E+00, 4.3513493959E-02, 4.1980324738E-02, 5.6940059994E-01],
	[1.3185000000E+04, 1.7924154924E+00, 3.5567303293E+00, 4.3561779241E-02, 4.2025694009E-02, 5.6954267961E-01],
	[1.3190000000E+04, 1.7932810624E+00, 3.5563894628E+00, 4.3610099707E-02, 4.2071093955E-02, 5.6968470425E-01],
	[1.3195000000E+04, 1.7941467222E+00, 3.5560487581E+00, 4.3658455370E-02, 4.2116524583E-02, 5.6982667386E-01],
	[1.3200000000E+04, 1.7950124716E+00, 3.5557082151E+00, 4.3706846242E-02, 4.2161985901E-02, 5.6996858845E-01],
	[1.3205000000E+04, 1.7958783107E+00, 3.5553678336E+00, 4.3755272335E-02, 4.2207477915E-02, 5.7011044803E-01],
	[1.3210000000E+04, 1.7967442394E+00, 3.5550276136E+00, 4.3803733662E-02, 4.2253000632E-02, 5.7025225262E-01],
	[1.3215000000E+04, 1.7976102577E+00, 3.5546875549E+00, 4.3852230234E-02, 4.2298554058E-02, 5.7039400220E-01],
	[1.3220000000E+04, 1.7984763656E+00, 3.5543476573E+00, 4.3900762064E-02, 4.2344138202E-02, 5.7053569680E-01],
	[1.3225000000E+04, 1.7993425630E+00, 3.5540079208E+00, 4.3949329165E-02, 4.2389753068E-02, 5.7067733641E-01],
	[1.3230000000E+04, 1.8002088499E+00, 3.5536683451E+00, 4.3997931547E-02, 4.2435398665E-02, 5.7081892106E-01],
	[1.3235000000E+04, 1.8010752264E+00, 3.5533289302E+00, 4.4046569224E-02, 4.2481074999E-02, 5.7096045073E-01],
	[1.3240000000E+04, 1.8019416923E+00, 3.5529896758E+00, 4.4095242208E-02, 4.2526782077E-02, 5.7110192545E-01],
	[1.3245000000E+04, 1.8028082477E+00, 3.5526505820E+00, 4.4143950510E-02, 4.2572519905E-02, 5.7124334522E-01],
	[1.3250000000E+04, 1.8036795792E+00, 3.5523165091E+00, 4.4192694144E-02, 4.2618291807E-02, 5.7138471004E-01],
	[1.3255000000E+04, 1.8045510530E+00, 3.5519826457E+00, 4.4241473121E-02, 4.2664094519E-02, 5.7152601993E-01],
	[1.3260000000E+04, 1.8054226190E+00, 3.5516489396E+00, 4.4290287454E-02, 4.2709928013E-02, 5.7166727489E-01],
	[1.3265000000E+04, 1.8062942772E+00, 3.5513153906E+00, 4.4339137155E-02, 4.2755792296E-02, 5.7180847493E-01],
	[1.3270000000E+04, 1.8071660274E+00, 3.5509819987E+00, 4.4388022236E-02, 4.2801687374E-02, 5.7194962005E-01],
	[1.3275000000E+04, 1.8080378697E+00, 3.5506487636E+00, 4.4436942709E-02, 4.2847613254E-02, 5.7209071027E-01],
	[1.3280000000E+04, 1.8089098041E+00, 3.5503156852E+00, 4.4485898586E-02, 4.2893569943E-02, 5.7223174560E-01],
	[1.3285000000E+04, 1.8097818305E+00, 3.5499827635E+00, 4.4534889880E-02, 4.2939557448E-02, 5.7237272603E-01],
	[1.3290000000E+04, 1.8106539489E+00, 3.5496499982E+00, 4.4583916604E-02, 4.2985575776E-02, 5.7251365158E-01],
	[1.3295000000E+04, 1.8115261592E+00, 3.5493173893E+00, 4.4632978768E-02, 4.3031624932E-02, 5.7265452225E-01],
	[1.3300000000E+04, 1.8123984616E+00, 3.5489849366E+00, 4.4682076386E-02, 4.3077704924E-02, 5.7279533806E-01],
	[1.3305000000E+04, 1.8132708558E+00, 3.5486526400E+00, 4.4731209469E-02, 4.3123815760E-02, 5.7293609901E-01],
	[1.3310000000E+04, 1.8141433420E+00, 3.5483204993E+00, 4.4780378030E-02, 4.3169957444E-02, 5.7307680511E-01],
	[1.3315000000E+04, 1.8150159201E+00, 3.5479885145E+00, 4.4829582081E-02, 4.3216129986E-02, 5.7321745636E-01],
	[1.3320000000E+04, 1.8158885900E+00, 3.5476566853E+00, 4.4878821634E-02, 4.3262333390E-02, 5.7335805278E-01],
	[1.3325000000E+04, 1.8167613517E+00, 3.5473250117E+00, 4.4928096702E-02, 4.3308567663E-02, 5.7349859437E-01],
	[1.3330000000E+04, 1.8176342053E+00, 3.5469934935E+00, 4.4977407296E-02, 4.3354832814E-02, 5.7363908115E-01],
	[1.3335000000E+04, 1.8185071506E+00, 3.5466621306E+00, 4.5026753430E-02, 4.3401128847E-02, 5.7377951311E-01],
	[1.3340000000E+04, 1.8193801877E+00, 3.5463309229E+00, 4.5076135114E-02, 4.3447455770E-02, 5.7391989027E-01],
	[1.3345000000E+04, 1.8202533165E+00, 3.5459998702E+00, 4.5125552362E-02, 4.3493813590E-02, 5.7406021263E-01],
	[1.3350000000E+04, 1.8211265370E+00, 3.5456689724E+00, 4.5175005185E-02, 4.3540202314E-02, 5.7420048021E-01],
	[1.3355000000E+04, 1.8219998492E+00, 3.5453382293E+00, 4.5224493596E-02, 4.3586621947E-02, 5.7434069301E-01],
	[1.3360000000E+04, 1.8228732531E+00, 3.5450076409E+00, 4.5274017606E-02, 4.3633072498E-02, 5.7448085104E-01],
	[1.3365000000E+04, 1.8237467486E+00, 3.5446772070E+00, 4.5323577229E-02, 4.3679553971E-02, 5.7462095430E-01],
	[1.3370000000E+04, 1.8246203357E+00, 3.5443469275E+00, 4.5373172477E-02, 4.3726066375E-02, 5.7476100282E-01],
	[1.3375000000E+04, 1.8254940144E+00, 3.5440168023E+00, 4.5422803361E-02, 4.3772609716E-02, 5.7490099658E-01],
	[1.3380000000E+04, 1.8263677846E+00, 3.5436868311E+00, 4.5472469893E-02, 4.3819184000E-02, 5.7504093561E-01],
	[1.3385000000E+04, 1.8272416464E+00, 3.5433570140E+00, 4.5522172087E-02, 4.3865789235E-02, 5.7518081991E-01],
	[1.3390000000E+04, 1.8281155997E+00, 3.5430273507E+00, 4.5571909954E-02, 4.3912425427E-02, 5.7532064949E-01],
	[1.3395000000E+04, 1.8289896445E+00, 3.5426978411E+00, 4.5621683506E-02, 4.3959092582E-02, 5.7546042436E-01],
	[1.3400000000E+04, 1.8298637807E+00, 3.5423684851E+00, 4.5671492756E-02, 4.4005790707E-02, 5.7560014452E-01],
	[1.3405000000E+04, 1.8307380084E+00, 3.5420392827E+00, 4.5721337715E-02, 4.4052519809E-02, 5.7573980999E-01],
	[1.3410000000E+04, 1.8316123274E+00, 3.5417102335E+00, 4.5771218397E-02, 4.4099279895E-02, 5.7587942077E-01],
	[1.3415000000E+04, 1.8324867379E+00, 3.5413813376E+00, 4.5821134813E-02, 4.4146070971E-02, 5.7601897687E-01],
	[1.3420000000E+04, 1.8333612398E+00, 3.5410525948E+00, 4.5871086975E-02, 4.4192893044E-02, 5.7615847831E-01],
	[1.3425000000E+04, 1.8342358329E+00, 3.5407240049E+00, 4.5921074896E-02, 4.4239746120E-02, 5.7629792508E-01],
	[1.3430000000E+04, 1.8351105174E+00, 3.5403955678E+00, 4.5971098588E-02, 4.4286630207E-02, 5.7643731720E-01],
	[1.3435000000E+04, 1.8359852932E+00, 3.5400672835E+00, 4.6021158063E-02, 4.4333545310E-02, 5.7657665467E-01],
	[1.3440000000E+04, 1.8368601602E+00, 3.5397391517E+00, 4.6071253333E-02, 4.4380491436E-02, 5.7671593751E-01],
	[1.3445000000E+04, 1.8377351185E+00, 3.5394111724E+00, 4.6121384411E-02, 4.4427468593E-02, 5.7685516572E-01],
	[1.3450000000E+04, 1.8386101680E+00, 3.5390833454E+00, 4.6171551308E-02, 4.4474476786E-02, 5.7699433932E-01],
	[1.3455000000E+04, 1.8394853087E+00, 3.5387556706E+00, 4.6221754037E-02, 4.4521516023E-02, 5.7713345830E-01],
	[1.3460000000E+04, 1.8403622026E+00, 3.5384298088E+00, 4.6271992610E-02, 4.4568587547E-02, 5.7727252269E-01],
	[1.3465000000E+04, 1.8412423597E+00, 3.5381072652E+00, 4.6322267040E-02, 4.4615692498E-02, 5.7741153248E-01],
	[1.3470000000E+04, 1.8421226107E+00, 3.5377848707E+00, 4.6372577338E-02, 4.4662828523E-02, 5.7755048769E-01],
	[1.3475000000E+04, 1.8430029557E+00, 3.5374626252E+00, 4.6422923517E-02, 4.4709995629E-02, 5.7768938833E-01],
	[1.3480000000E+04, 1.8438833945E+00, 3.5371405287E+00, 4.6473305588E-02, 4.4757193822E-02, 5.7782823440E-01],
	[1.3485000000E+04, 1.8447639272E+00, 3.5368185809E+00, 4.6523723565E-02, 4.4804423110E-02, 5.7796702592E-01],
	[1.3490000000E+04, 1.8456445537E+00, 3.5364967817E+00, 4.6574177459E-02, 4.4851683498E-02, 5.7810576289E-01],
	[1.3495000000E+04, 1.8465252740E+00, 3.5361751310E+00, 4.6624667282E-02, 4.4898974994E-02, 5.7824444532E-01],
	[1.3500000000E+04, 1.8474060881E+00, 3.5358536287E+00, 4.6675193047E-02, 4.4946297603E-02, 5.7838307322E-01],
	[1.3505000000E+04, 1.8482869960E+00, 3.5355322747E+00, 4.6725754767E-02, 4.4993651334E-02, 5.7852164660E-01],
	[1.3510000000E+04, 1.8491679976E+00, 3.5352110689E+00, 4.6776352452E-02, 4.5041036191E-02, 5.7866016547E-01],
	[1.3515000000E+04, 1.8500490929E+00, 3.5348900110E+00, 4.6826986115E-02, 4.5088452182E-02, 5.7879862983E-01],
	[1.3520000000E+04, 1.8509302819E+00, 3.5345691011E+00, 4.6877655769E-02, 4.5135899314E-02, 5.7893703971E-01],
	[1.3525000000E+04, 1.8518115645E+00, 3.5342483389E+00, 4.6928361425E-02, 4.5183377592E-02, 5.7907539510E-01],
	[1.3530000000E+04, 1.8526929408E+00, 3.5339277244E+00, 4.6979103097E-02, 4.5230887023E-02, 5.7921369602E-01],
	[1.3535000000E+04, 1.8535744107E+00, 3.5336072574E+00, 4.7029880795E-02, 4.5278427615E-02, 5.7935194247E-01],
	[1.3540000000E+04, 1.8544559742E+00, 3.5332869379E+00, 4.7080694533E-02, 4.5325999373E-02, 5.7949013446E-01],
	[1.3545000000E+04, 1.8553376312E+00, 3.5329667656E+00, 4.7131544323E-02, 4.5373602304E-02, 5.7962827201E-01],
	[1.3550000000E+04, 1.8562193818E+00, 3.5326467404E+00, 4.7182430175E-02, 4.5421236414E-02, 5.7976635512E-01],
	[1.3555000000E+04, 1.8571012259E+00, 3.5323268624E+00, 4.7233352104E-02, 4.5468901711E-02, 5.7990438380E-01],
	[1.3560000000E+04, 1.8579831635E+00, 3.5320071312E+00, 4.7284310121E-02, 4.5516598200E-02, 5.8004235806E-01],
	[1.3565000000E+04, 1.8588651945E+00, 3.5316875468E+00, 4.7335304238E-02, 4.5564325888E-02, 5.8018027792E-01],
	[1.3570000000E+04, 1.8597473190E+00, 3.5313681091E+00, 4.7386334468E-02, 4.5612084782E-02, 5.8031814337E-01],
	[1.3575000000E+04, 1.8606295369E+00, 3.5310488180E+00, 4.7437400822E-02, 4.5659874888E-02, 5.8045595443E-01],
	[1.3580000000E+04, 1.8615118482E+00, 3.5307296733E+00, 4.7488503313E-02, 4.5707696213E-02, 5.8059371111E-01],
	[1.3585000000E+04, 1.8623942528E+00, 3.5304106749E+00, 4.7539641953E-02, 4.5755548763E-02, 5.8073141342E-01],
	[1.3590000000E+04, 1.8632767508E+00, 3.5300918227E+00, 4.7590816754E-02, 4.5803432545E-02, 5.8086906137E-01],
	[1.3595000000E+04, 1.8641593421E+00, 3.5297731166E+00, 4.7642027729E-02, 4.5851347565E-02, 5.8100665496E-01],
	[1.3600000000E+04, 1.8650420267E+00, 3.5294545564E+00, 4.7693274889E-02, 4.5899293829E-02, 5.8114419421E-01],
	[1.3605000000E+04, 1.8659248045E+00, 3.5291361421E+00, 4.7744558247E-02, 4.5947271345E-02, 5.8128167912E-01],
	[1.3610000000E+04, 1.8668076756E+00, 3.5288178734E+00, 4.7795877815E-02, 4.5995280118E-02, 5.8141910972E-01],
	[1.3615000000E+04, 1.8676906399E+00, 3.5284997504E+00, 4.7847233605E-02, 4.6043320155E-02, 5.8155648599E-01],
	[1.3620000000E+04, 1.8685736974E+00, 3.5281817728E+00, 4.7898625630E-02, 4.6091391463E-02, 5.8169380797E-01],
	[1.3625000000E+04, 1.8694568481E+00, 3.5278639406E+00, 4.7950053901E-02, 4.6139494048E-02, 5.8183107564E-01],
	[1.3630000000E+04, 1.8703400919E+00, 3.5275462536E+00, 4.8001518431E-02, 4.6187627916E-02, 5.8196828904E-01],
	[1.3635000000E+04, 1.8712234289E+00, 3.5272287117E+00, 4.8053019232E-02, 4.6235793074E-02, 5.8210544815E-01],
	[1.3640000000E+04, 1.8721068589E+00, 3.5269113148E+00, 4.8104556316E-02, 4.6283989528E-02, 5.8224255300E-01],
	[1.3645000000E+04, 1.8729903820E+00, 3.5265940628E+00, 4.8156129695E-02, 4.6332217286E-02, 5.8237960360E-01],
	[1.3650000000E+04, 1.8738739982E+00, 3.5262769555E+00, 4.8207739382E-02, 4.6380476352E-02, 5.8251659994E-01],
	[1.3655000000E+04, 1.8747577073E+00, 3.5259599929E+00, 4.8259385388E-02, 4.6428766734E-02, 5.8265354206E-01],
	[1.3660000000E+04, 1.8756415095E+00, 3.5256431747E+00, 4.8311067726E-02, 4.6477088439E-02, 5.8279042994E-01],
	[1.3665000000E+04, 1.8765254047E+00, 3.5253265010E+00, 4.8362786409E-02, 4.6525441471E-02, 5.8292726361E-01],
	[1.3670000000E+04, 1.8774093928E+00, 3.5250099716E+00, 4.8414541447E-02, 4.6573825839E-02, 5.8306404307E-01],
	[1.3675000000E+04, 1.8782935327E+00, 3.5246936430E+00, 4.8466332854E-02, 4.6622241594E-02, 5.8320076833E-01],
	[1.3680000000E+04, 1.8791826374E+00, 3.5243821469E+00, 4.8518160642E-02, 4.6670692525E-02, 5.8333743941E-01],
	[1.3685000000E+04, 1.8800718378E+00, 3.5240707922E+00, 4.8570024822E-02, 4.6719174821E-02, 5.8347405631E-01],
	[1.3690000000E+04, 1.8809611339E+00, 3.5237595787E+00, 4.8621925408E-02, 4.6767688490E-02, 5.8361061904E-01],
	[1.3695000000E+04, 1.8818505257E+00, 3.5234485064E+00, 4.8673875967E-02, 4.6816246080E-02, 5.8374712762E-01],
	[1.3700000000E+04, 1.8827400131E+00, 3.5231375750E+00, 4.8725885116E-02, 4.6864855553E-02, 5.8388358205E-01],
	[1.3705000000E+04, 1.8836295962E+00, 3.5228267845E+00, 4.8777930762E-02, 4.6913496465E-02, 5.8401998234E-01],
	[1.3710000000E+04, 1.8845192749E+00, 3.5225161348E+00, 4.8830012918E-02, 4.6962168824E-02, 5.8415632851E-01],
	[1.3715000000E+04, 1.8854090491E+00, 3.5222056257E+00, 4.8882131597E-02, 4.7010872637E-02, 5.8429262056E-01],
	[1.3720000000E+04, 1.8862989190E+00, 3.5218952572E+00, 4.8934286811E-02, 4.7059607908E-02, 5.8442885850E-01],
	[1.3725000000E+04, 1.8871888843E+00, 3.5215850290E+00, 4.8986478572E-02, 4.7108374645E-02, 5.8456504235E-01],
	[1.3730000000E+04, 1.8880789451E+00, 3.5212749412E+00, 4.9038706892E-02, 4.7157172854E-02, 5.8470117215E-01],
	[1.3735000000E+04, 1.8889691015E+00, 3.5209649936E+00, 4.9090971784E-02, 4.7206002542E-02, 5.8483724788E-01],
	[1.3740000000E+04, 1.8898593533E+00, 3.5206551861E+00, 4.9143273259E-02, 4.7254863715E-02, 5.8497326956E-01],
	[1.3745000000E+04, 1.8907497005E+00, 3.5203455185E+00, 4.9195611330E-02, 4.7303756379E-02, 5.8510923719E-01],
	[1.3750000000E+04, 1.8916401431E+00, 3.5200359908E+00, 4.9247986009E-02, 4.7352680540E-02, 5.8524515078E-01],
	[1.3755000000E+04, 1.8925306812E+00, 3.5197266028E+00, 4.9300397308E-02, 4.7401636206E-02, 5.8538101033E-01],
	[1.3760000000E+04, 1.8934213145E+00, 3.5194173544E+00, 4.9352845239E-02, 4.7450623382E-02, 5.8551681584E-01],
	[1.3765000000E+04, 1.8943120432E+00, 3.5191082455E+00, 4.9405329816E-02, 4.7499642075E-02, 5.8565256731E-01],
	[1.3770000000E+04, 1.8952028673E+00, 3.5187992761E+00, 4.9457851049E-02, 4.7548692291E-02, 5.8578826476E-01],
	[1.3775000000E+04, 1.8960937866E+00, 3.5184904459E+00, 4.9510408952E-02, 4.7597774036E-02, 5.8592390819E-01],
	[1.3780000000E+04, 1.8969848011E+00, 3.5181817549E+00, 4.9563003535E-02, 4.7646887317E-02, 5.8605949760E-01],
	[1.3785000000E+04, 1.8978759109E+00, 3.5178732029E+00, 4.9615634813E-02, 4.7696032141E-02, 5.8619503300E-01],
	[1.3790000000E+04, 1.8987671160E+00, 3.5175647899E+00, 4.9668302796E-02, 4.7745208513E-02, 5.8633051439E-01],
	[1.3795000000E+04, 1.8996584162E+00, 3.5172565157E+00, 4.9721007497E-02, 4.7794416440E-02, 5.8646594178E-01],
	[1.3800000000E+04, 1.9005498116E+00, 3.5169483802E+00, 4.9773748928E-02, 4.7843655928E-02, 5.8660131516E-01],
	[1.3805000000E+04, 1.9014413021E+00, 3.5166403833E+00, 4.9826527101E-02, 4.7892926983E-02, 5.8673663455E-01],
	[1.3810000000E+04, 1.9023328877E+00, 3.5163325250E+00, 4.9879342029E-02, 4.7942229612E-02, 5.8687189996E-01],
	[1.3815000000E+04, 1.9032245684E+00, 3.5160248050E+00, 4.9932193724E-02, 4.7991563821E-02, 5.8700711137E-01],
	[1.3820000000E+04, 1.9041163442E+00, 3.5157172232E+00, 4.9985082198E-02, 4.8040929617E-02, 5.8714226881E-01],
	[1.3825000000E+04, 1.9050082150E+00, 3.5154097796E+00, 5.0038007463E-02, 4.8090327006E-02, 5.8727737227E-01],
	[1.3830000000E+04, 1.9059001809E+00, 3.5151024741E+00, 5.0090969532E-02, 4.8139755993E-02, 5.8741242176E-01],
	[1.3835000000E+04, 1.9067922417E+00, 3.5147953065E+00, 5.0143968416E-02, 4.8189216586E-02, 5.8754741729E-01],
	[1.3840000000E+04, 1.9076843976E+00, 3.5144882767E+00, 5.0197004128E-02, 4.8238708790E-02, 5.8768235886E-01],
	[1.3845000000E+04, 1.9085766483E+00, 3.5141813846E+00, 5.0250076680E-02, 4.8288232612E-02, 5.8781724647E-01],
	[1.3850000000E+04, 1.9094689940E+00, 3.5138746301E+00, 5.0303186084E-02, 4.8337788059E-02, 5.8795208014E-01],
	[1.3855000000E+04, 1.9103614346E+00, 3.5135680131E+00, 5.0356332353E-02, 4.8387375136E-02, 5.8808685985E-01],
	[1.3860000000E+04, 1.9112539700E+00, 3.5132615334E+00, 5.0409515499E-02, 4.8436993849E-02, 5.8822158563E-01],
	[1.3865000000E+04, 1.9121466003E+00, 3.5129551911E+00, 5.0462735533E-02, 4.8486644205E-02, 5.8835625748E-01],
	[1.3870000000E+04, 1.9130393255E+00, 3.5126489858E+00, 5.0515992468E-02, 4.8536326211E-02, 5.8849087540E-01],
	[1.3875000000E+04, 1.9139321454E+00, 3.5123429177E+00, 5.0569286317E-02, 4.8586039872E-02, 5.8862543939E-01],
	[1.3880000000E+04, 1.9148250601E+00, 3.5120369864E+00, 5.0622617091E-02, 4.8635785195E-02, 5.8875994946E-01],
	[1.3885000000E+04, 1.9157180696E+00, 3.5117311920E+00, 5.0675984803E-02, 4.8685562185E-02, 5.8889440563E-01],
	[1.3890000000E+04, 1.9166111738E+00, 3.5114255342E+00, 5.0729389464E-02, 4.8735370850E-02, 5.8902880788E-01],
	[1.3895000000E+04, 1.9175043726E+00, 3.5111200131E+00, 5.0782831088E-02, 4.8785211196E-02, 5.8916315623E-01],
	[1.3900000000E+04, 1.9184026072E+00, 3.5108192102E+00, 5.0836309686E-02, 4.8835087316E-02, 5.8929745069E-01],
	[1.3905000000E+04, 1.9193010279E+00, 3.5105186235E+00, 5.0889825270E-02, 4.8884995215E-02, 5.8943169126E-01],
	[1.3910000000E+04, 1.9201995462E+00, 3.5102181706E+00, 5.0943377853E-02, 4.8934934825E-02, 5.8956587794E-01],
	[1.3915000000E+04, 1.9210981619E+00, 3.5099178514E+00, 5.0996967447E-02, 4.8984906154E-02, 5.8970001074E-01],
	[1.3920000000E+04, 1.9219968752E+00, 3.5096176657E+00, 5.1050594065E-02, 4.9034909207E-02, 5.8983408966E-01],
	[1.3925000000E+04, 1.9228956858E+00, 3.5093176135E+00, 5.1104257717E-02, 4.9084943990E-02, 5.8996811472E-01],
	[1.3930000000E+04, 1.9237945939E+00, 3.5090176947E+00, 5.1157958417E-02, 4.9135010510E-02, 5.9010208592E-01],
	[1.3935000000E+04, 1.9246935994E+00, 3.5087179091E+00, 5.1211696176E-02, 4.9185108772E-02, 5.9023600325E-01],
	[1.3940000000E+04, 1.9255927023E+00, 3.5084182567E+00, 5.1265471008E-02, 4.9235238784E-02, 5.9036986674E-01],
	[1.3945000000E+04, 1.9264919025E+00, 3.5081187373E+00, 5.1319282923E-02, 4.9285400551E-02, 5.9050367638E-01],
	[1.3950000000E+04, 1.9273912001E+00, 3.5078193508E+00, 5.1373131935E-02, 4.9335594079E-02, 5.9063743219E-01],
	[1.3955000000E+04, 1.9282905949E+00, 3.5075200971E+00, 5.1427018056E-02, 4.9385819375E-02, 5.9077113416E-01],
	[1.3960000000E+04, 1.9291900870E+00, 3.5072209762E+00, 5.1480941297E-02, 4.9436076444E-02, 5.9090478230E-01],
	[1.3965000000E+04, 1.9300896764E+00, 3.5069219879E+00, 5.1534901670E-02, 4.9486365294E-02, 5.9103837662E-01],
	[1.3970000000E+04, 1.9309893630E+00, 3.5066231321E+00, 5.1588899189E-02, 4.9536685930E-02, 5.9117191712E-01],
	[1.3975000000E+04, 1.9318891468E+00, 3.5063244086E+00, 5.1642933865E-02, 4.9587038358E-02, 5.9130540381E-01],
	[1.3980000000E+04, 1.9327890278E+00, 3.5060258175E+00, 5.1697005711E-02, 4.9637422584E-02, 5.9143883670E-01],
	[1.3985000000E+04, 1.9336890059E+00, 3.5057273586E+00, 5.1751114738E-02, 4.9687838615E-02, 5.9157221580E-01],
	[1.3990000000E+04, 1.9345890812E+00, 3.5054290317E+00, 5.1805260959E-02, 4.9738286457E-02, 5.9170554110E-01],
	[1.3995000000E+04, 1.9354892535E+00, 3.5051308368E+00, 5.1859444387E-02, 4.9788766116E-02, 5.9183881261E-01],
	[1.4000000000E+04, 1.9363895230E+00, 3.5048327738E+00, 5.1913665032E-02, 4.9839277598E-02, 5.9197203035E-01],
	[1.4005000000E+04, 1.9372898895E+00, 3.5045348426E+00, 5.1967922908E-02, 4.9889820910E-02, 5.9210519432E-01],
	[1.4010000000E+04, 1.9381903531E+00, 3.5042370430E+00, 5.2022218026E-02, 4.9940396056E-02, 5.9223830452E-01],
	[1.4015000000E+04, 1.9390909136E+00, 3.5039393749E+00, 5.2076550399E-02, 4.9991003045E-02, 5.9237136095E-01],
	[1.4020000000E+04, 1.9399915711E+00, 3.5036418384E+00, 5.2130920040E-02, 5.0041641880E-02, 5.9250436364E-01],
	[1.4025000000E+04, 1.9408923256E+00, 3.5033444331E+00, 5.2185326959E-02, 5.0092312570E-02, 5.9263731257E-01],
	[1.4030000000E+04, 1.9417931771E+00, 3.5030471591E+00, 5.2239771170E-02, 5.0143015119E-02, 5.9277020777E-01],
	[1.4035000000E+04, 1.9426941254E+00, 3.5027500163E+00, 5.2294252684E-02, 5.0193749535E-02, 5.9290304923E-01],
	[1.4040000000E+04, 1.9435951707E+00, 3.5024530044E+00, 5.2348771515E-02, 5.0244515822E-02, 5.9303583696E-01],
	[1.4045000000E+04, 1.9444963128E+00, 3.5021561235E+00, 5.2403327673E-02, 5.0295313988E-02, 5.9316857098E-01],
	[1.4050000000E+04, 1.9453975517E+00, 3.5018593734E+00, 5.2457921171E-02, 5.0346144038E-02, 5.9330125127E-01],
	[1.4055000000E+04, 1.9462988875E+00, 3.5015627541E+00, 5.2512552022E-02, 5.0397005978E-02, 5.9343387786E-01],
	[1.4060000000E+04, 1.9472003200E+00, 3.5012662653E+00, 5.2567220237E-02, 5.0447899814E-02, 5.9356645075E-01],
	[1.4065000000E+04, 1.9481018494E+00, 3.5009699070E+00, 5.2621925829E-02, 5.0498825554E-02, 5.9369896994E-01],
	[1.4070000000E+04, 1.9490034754E+00, 3.5006736792E+00, 5.2676668809E-02, 5.0549783201E-02, 5.9383143544E-01],
	[1.4075000000E+04, 1.9499051982E+00, 3.5003775817E+00, 5.2731449191E-02, 5.0600772764E-02, 5.9396384726E-01],
	[1.4080000000E+04, 1.9508070177E+00, 3.5000816143E+00, 5.2786266986E-02, 5.0651794247E-02, 5.9409620541E-01],
	[1.4085000000E+04, 1.9517089339E+00, 3.4997857771E+00, 5.2841122207E-02, 5.0702847657E-02, 5.9422850989E-01],
	[1.4090000000E+04, 1.9526109467E+00, 3.4994900698E+00, 5.2896014865E-02, 5.0753933000E-02, 5.9436076071E-01],
	[1.4095000000E+04, 1.9535130561E+00, 3.4991944925E+00, 5.2950944973E-02, 5.0805050281E-02, 5.9449295787E-01],
	[1.4100000000E+04, 1.9544152621E+00, 3.4988990449E+00, 5.3005912543E-02, 5.0856199508E-02, 5.9462510139E-01],
	[1.4105000000E+04, 1.9553175647E+00, 3.4986037270E+00, 5.3060917588E-02, 5.0907380685E-02, 5.9475719126E-01],
	[1.4110000000E+04, 1.9562199639E+00, 3.4983085387E+00, 5.3115960119E-02, 5.0958593820E-02, 5.9488922750E-01],
	[1.4115000000E+04, 1.9571224596E+00, 3.4980134798E+00, 5.3171040148E-02, 5.1009838917E-02, 5.9502121012E-01],
	[1.4120000000E+04, 1.9580263031E+00, 3.4977196690E+00, 5.3226157688E-02, 5.1061117073E-02, 5.9515313911E-01],
	[1.4125000000E+04, 1.9589341225E+00, 3.4974294526E+00, 5.3281312751E-02, 5.1112430588E-02, 5.9528501449E-01],
	[1.4130000000E+04, 1.9598420413E+00, 3.4971393630E+00, 5.3336505349E-02, 5.1163776097E-02, 5.9541683627E-01],
	[1.4135000000E+04, 1.9607500595E+00, 3.4968494001E+00, 5.3391735495E-02, 5.1215153607E-02, 5.9554860445E-01],
	[1.4140000000E+04, 1.9616581770E+00, 3.4965595638E+00, 5.3447003199E-02, 5.1266563124E-02, 5.9568031904E-01],
	[1.4145000000E+04, 1.9625663938E+00, 3.4962698539E+00, 5.3502308476E-02, 5.1318004652E-02, 5.9581198004E-01],
	[1.4150000000E+04, 1.9634747099E+00, 3.4959802704E+00, 5.3557651337E-02, 5.1369478200E-02, 5.9594358747E-01],
	[1.4155000000E+04, 1.9643831253E+00, 3.4956908132E+00, 5.3613031793E-02, 5.1420983771E-02, 5.9607514133E-01],
	[1.4160000000E+04, 1.9652916399E+00, 3.4954014822E+00, 5.3668449858E-02, 5.1472521373E-02, 5.9620664162E-01],
	[1.4165000000E+04, 1.9662002537E+00, 3.4951122773E+00, 5.3723905543E-02, 5.1524091012E-02, 5.9633808836E-01],
	[1.4170000000E+04, 1.9671089667E+00, 3.4948231984E+00, 5.3779398861E-02, 5.1575692693E-02, 5.9646948155E-01],
	[1.4175000000E+04, 1.9680177789E+00, 3.4945342453E+00, 5.3834929823E-02, 5.1627326423E-02, 5.9660082121E-01],
	[1.4180000000E+04, 1.9689266902E+00, 3.4942454180E+00, 5.3890498443E-02, 5.1678992207E-02, 5.9673210733E-01],
	[1.4185000000E+04, 1.9698357006E+00, 3.4939567164E+00, 5.3946104731E-02, 5.1730690051E-02, 5.9686333992E-01],
	[1.4190000000E+04, 1.9707448101E+00, 3.4936681404E+00, 5.4001748701E-02, 5.1782419962E-02, 5.9699451900E-01],
	[1.4195000000E+04, 1.9716540187E+00, 3.4933796899E+00, 5.4057430365E-02, 5.1834181946E-02, 5.9712564457E-01],
	[1.4200000000E+04, 1.9725633263E+00, 3.4930913647E+00, 5.4113149734E-02, 5.1885976007E-02, 5.9725671663E-01],
	[1.4205000000E+04, 1.9734727330E+00, 3.4928031649E+00, 5.4168906820E-02, 5.1937802153E-02, 5.9738773520E-01],
	[1.4210000000E+04, 1.9743822386E+00, 3.4925150902E+00, 5.4224701637E-02, 5.1989660389E-02, 5.9751870029E-01],
	[1.4215000000E+04, 1.9752918433E+00, 3.4922271407E+00, 5.4280534196E-02, 5.2041550722E-02, 5.9764961189E-01],
	[1.4220000000E+04, 1.9762015468E+00, 3.4919393161E+00, 5.4336404510E-02, 5.2093473156E-02, 5.9778047002E-01],
	[1.4225000000E+04, 1.9771113493E+00, 3.4916516164E+00, 5.4392312590E-02, 5.2145427698E-02, 5.9791127469E-01],
	[1.4230000000E+04, 1.9780212507E+00, 3.4913640415E+00, 5.4448258448E-02, 5.2197414355E-02, 5.9804202590E-01],
	[1.4235000000E+04, 1.9789312510E+00, 3.4910765913E+00, 5.4504242098E-02, 5.2249433131E-02, 5.9817272366E-01],
	[1.4240000000E+04, 1.9798413501E+00, 3.4907892658E+00, 5.4560263550E-02, 5.2301484034E-02, 5.9830336798E-01],
	[1.4245000000E+04, 1.9807515480E+00, 3.4905020647E+00, 5.4616322818E-02, 5.2353567068E-02, 5.9843395887E-01],
	[1.4250000000E+04, 1.9816618448E+00, 3.4902149880E+00, 5.4672419913E-02, 5.2405682239E-02, 5.9856449633E-01],
	[1.4255000000E+04, 1.9825722403E+00, 3.4899280357E+00, 5.4728554848E-02, 5.2457829555E-02, 5.9869498037E-01],
	[1.4260000000E+04, 1.9834827346E+00, 3.4896412075E+00, 5.4784727635E-02, 5.2510009019E-02, 5.9882541101E-01],
	[1.4265000000E+04, 1.9843933276E+00, 3.4893545035E+00, 5.4840938285E-02, 5.2562220639E-02, 5.9895578824E-01],
	[1.4270000000E+04, 1.9853040194E+00, 3.4890679235E+00, 5.4897186812E-02, 5.2614464421E-02, 5.9908611208E-01],
	[1.4275000000E+04, 1.9862148098E+00, 3.4887814674E+00, 5.4953473227E-02, 5.2666740369E-02, 5.9921638254E-01],
	[1.4280000000E+04, 1.9871256988E+00, 3.4884951351E+00, 5.5009797542E-02, 5.2719048491E-02, 5.9934659962E-01],
	[1.4285000000E+04, 1.9880366865E+00, 3.4882089266E+00, 5.5066159770E-02, 5.2771388791E-02, 5.9947676333E-01],
	[1.4290000000E+04, 1.9889477729E+00, 3.4879228417E+00, 5.5122559923E-02, 5.2823761276E-02, 5.9960687367E-01],
	[1.4295000000E+04, 1.9898589578E+00, 3.4876368803E+00, 5.5178998013E-02, 5.2876165952E-02, 5.9973693067E-01],
	[1.4300000000E+04, 1.9907702412E+00, 3.4873510424E+00, 5.5235474051E-02, 5.2928602825E-02, 5.9986693432E-01],
	[1.4305000000E+04, 1.9916816233E+00, 3.4870653278E+00, 5.5291988052E-02, 5.2981071899E-02, 5.9999688463E-01],
	[1.4310000000E+04, 1.9925931038E+00, 3.4867797364E+00, 5.5348540025E-02, 5.3033573182E-02, 6.0012678162E-01],
	[1.4315000000E+04, 1.9935046828E+00, 3.4864942682E+00, 5.5405129984E-02, 5.3086106679E-02, 6.0025662528E-01],
	[1.4320000000E+04, 1.9944163603E+00, 3.4862089230E+00, 5.5461757941E-02, 5.3138672396E-02, 6.0038641563E-01],
	[1.4325000000E+04, 1.9953281363E+00, 3.4859237008E+00, 5.5518423908E-02, 5.3191270338E-02, 6.0051615268E-01],
	[1.4330000000E+04, 1.9962400106E+00, 3.4856386015E+00, 5.5575127898E-02, 5.3243900512E-02, 6.0064583644E-01],
	[1.4335000000E+04, 1.9971519834E+00, 3.4853536249E+00, 5.5631869921E-02, 5.3296562924E-02, 6.0077546691E-01],
	[1.4340000000E+04, 1.9980640545E+00, 3.4850687710E+00, 5.5688649991E-02, 5.3349257578E-02, 6.0090504410E-01],
	[1.4345000000E+04, 1.9989762240E+00, 3.4847840396E+00, 5.5745468120E-02, 5.3401984482E-02, 6.0103456802E-01],
	[1.4350000000E+04, 1.9998926004E+00, 3.4845029700E+00, 5.5802324319E-02, 5.3454747408E-02, 6.0116403868E-01],
	[1.4355000000E+04, 2.0008102007E+00, 3.4842229881E+00, 5.5859218601E-02, 5.3507543638E-02, 6.0129345608E-01],
	[1.4360000000E+04, 2.0017279023E+00, 3.4839431262E+00, 5.5916150979E-02, 5.3560372148E-02, 6.0142282024E-01],
	[1.4365000000E+04, 2.0026457051E+00, 3.4836633842E+00, 5.5973121464E-02, 5.3613232944E-02, 6.0155213117E-01],
	[1.4370000000E+04, 2.0035636091E+00, 3.4833837620E+00, 5.6030130068E-02, 5.3666126033E-02, 6.0168138887E-01],
	[1.4375000000E+04, 2.0044816142E+00, 3.4831042595E+00, 5.6087176804E-02, 5.3719051419E-02, 6.0181059335E-01],
	[1.4380000000E+04, 2.0053997206E+00, 3.4828248767E+00, 5.6144261683E-02, 5.3772009109E-02, 6.0193974462E-01],
	[1.4385000000E+04, 2.0063179280E+00, 3.4825456133E+00, 5.6201384719E-02, 5.3824999108E-02, 6.0206884270E-01],
	[1.4390000000E+04, 2.0072362365E+00, 3.4822664694E+00, 5.6258545923E-02, 5.3878021423E-02, 6.0219788757E-01],
	[1.4395000000E+04, 2.0081546461E+00, 3.4819874448E+00, 5.6315745307E-02, 5.3931076059E-02, 6.0232687927E-01],
	[1.4400000000E+04, 2.0090731568E+00, 3.4817085395E+00, 5.6372982883E-02, 5.3984163022E-02, 6.0245581779E-01],
	[1.4405000000E+04, 2.0099917685E+00, 3.4814297533E+00, 5.6430258664E-02, 5.4037282317E-02, 6.0258470315E-01],
	[1.4410000000E+04, 2.0109104812E+00, 3.4811510862E+00, 5.6487572662E-02, 5.4090433950E-02, 6.0271353534E-01],
	[1.4415000000E+04, 2.0118292949E+00, 3.4808725381E+00, 5.6544924889E-02, 5.4143617928E-02, 6.0284231439E-01],
	[1.4420000000E+04, 2.0127482095E+00, 3.4805941088E+00, 5.6602315357E-02, 5.4196834256E-02, 6.0297104030E-01],
	[1.4425000000E+04, 2.0136672250E+00, 3.4803157983E+00, 5.6659744078E-02, 5.4250082939E-02, 6.0309971308E-01],
	[1.4430000000E+04, 2.0145863415E+00, 3.4800376065E+00, 5.6717211064E-02, 5.4303363983E-02, 6.0322833274E-01],
	[1.4435000000E+04, 2.0155055589E+00, 3.4797595333E+00, 5.6774716328E-02, 5.4356677395E-02, 6.0335689929E-01],
	[1.4440000000E+04, 2.0164248771E+00, 3.4794815786E+00, 5.6832259882E-02, 5.4410023180E-02, 6.0348541273E-01],
	[1.4445000000E+04, 2.0173442961E+00, 3.4792037424E+00, 5.6889841738E-02, 5.4463401343E-02, 6.0361387308E-01],
	[1.4450000000E+04, 2.0182638160E+00, 3.4789260244E+00, 5.6947461908E-02, 5.4516811891E-02, 6.0374228035E-01],
	[1.4455000000E+04, 2.0191834366E+00, 3.4786484247E+00, 5.7005120404E-02, 5.4570254828E-02, 6.0387063454E-01],
	[1.4460000000E+04, 2.0201031580E+00, 3.4783709432E+00, 5.7062817238E-02, 5.4623730162E-02, 6.0399893566E-01],
	[1.4465000000E+04, 2.0210229802E+00, 3.4780935797E+00, 5.7120552423E-02, 5.4677237896E-02, 6.0412718372E-01],
	[1.4470000000E+04, 2.0219429030E+00, 3.4778163342E+00, 5.7178325970E-02, 5.4730778038E-02, 6.0425537874E-01],
	[1.4475000000E+04, 2.0228629266E+00, 3.4775392065E+00, 5.7236137892E-02, 5.4784350593E-02, 6.0438352071E-01],
	[1.4480000000E+04, 2.0237830508E+00, 3.4772621966E+00, 5.7293988202E-02, 5.4837955567E-02, 6.0451160966E-01],
	[1.4485000000E+04, 2.0247032757E+00, 3.4769853044E+00, 5.7351876910E-02, 5.4891592964E-02, 6.0463964558E-01],
	[1.4490000000E+04, 2.0256236012E+00, 3.4767085298E+00, 5.7409804030E-02, 5.4945262792E-02, 6.0476762850E-01],
	[1.4495000000E+04, 2.0265440273E+00, 3.4764318728E+00, 5.7467769573E-02, 5.4998965055E-02, 6.0489555841E-01],
	[1.4500000000E+04, 2.0274645540E+00, 3.4761553331E+00, 5.7525773552E-02, 5.5052699760E-02, 6.0502343533E-01],
	[1.4505000000E+04, 2.0283851812E+00, 3.4758789108E+00, 5.7583815978E-02, 5.5106466912E-02, 6.0515125926E-01],
	[1.4510000000E+04, 2.0293059089E+00, 3.4756026057E+00, 5.7641896865E-02, 5.5160266516E-02, 6.0527903023E-01],
	[1.4515000000E+04, 2.0302267372E+00, 3.4753264177E+00, 5.7700016223E-02, 5.5214098578E-02, 6.0540674822E-01],
	[1.4520000000E+04, 2.0311476659E+00, 3.4750503468E+00, 5.7758174066E-02, 5.5267963105E-02, 6.0553441326E-01],
	[1.4525000000E+04, 2.0320686951E+00, 3.4747743929E+00, 5.7816370405E-02, 5.5321860101E-02, 6.0566202536E-01],
	[1.4530000000E+04, 2.0329898247E+00, 3.4744985559E+00, 5.7874605253E-02, 5.5375789572E-02, 6.0578958452E-01],
	[1.4535000000E+04, 2.0339110548E+00, 3.4742228356E+00, 5.7932878621E-02, 5.5429751524E-02, 6.0591709076E-01],
	[1.4540000000E+04, 2.0348323852E+00, 3.4739472320E+00, 5.7991190522E-02, 5.5483745963E-02, 6.0604454407E-01],
	[1.4545000000E+04, 2.0357538159E+00, 3.4736717451E+00, 5.8049540968E-02, 5.5537772894E-02, 6.0617194448E-01],
	[1.4550000000E+04, 2.0366753471E+00, 3.4733963747E+00, 5.8107929971E-02, 5.5591832323E-02, 6.0629929200E-01],
	[1.4555000000E+04, 2.0375969785E+00, 3.4731211207E+00, 5.8166357544E-02, 5.5645924255E-02, 6.0642658662E-01],
	[1.4560000000E+04, 2.0385187102E+00, 3.4728459830E+00, 5.8224823698E-02, 5.5700048696E-02, 6.0655382837E-01],
	[1.4565000000E+04, 2.0394405422E+00, 3.4725709616E+00, 5.8283328445E-02, 5.5754205651E-02, 6.0668101725E-01],
	[1.4570000000E+04, 2.0403624744E+00, 3.4722960564E+00, 5.8341871798E-02, 5.5808395127E-02, 6.0680815327E-01],
	[1.4575000000E+04, 2.0412845069E+00, 3.4720212672E+00, 5.8400453770E-02, 5.5862617128E-02, 6.0693523644E-01],
	[1.4580000000E+04, 2.0422098130E+00, 3.4717492297E+00, 5.8459074371E-02, 5.5916874724E-02, 6.0706226677E-01],
	[1.4585000000E+04, 2.0431373829E+00, 3.4714791010E+00, 5.8517733614E-02, 5.5971166955E-02, 6.0718924427E-01],
	[1.4590000000E+04, 2.0440650559E+00, 3.4712090860E+00, 5.8576431511E-02, 5.6025491742E-02, 6.0731616896E-01],
	[1.4595000000E+04, 2.0449928320E+00, 3.4709391845E+00, 5.8635168075E-02, 5.6079849093E-02, 6.0744304083E-01],
	[1.4600000000E+04, 2.0459207113E+00, 3.4706693964E+00, 5.8693943318E-02, 5.6134239012E-02, 6.0756985990E-01],
	[1.4605000000E+04, 2.0468486936E+00, 3.4703997216E+00, 5.8752757252E-02, 5.6188661506E-02, 6.0769662619E-01],
	[1.4610000000E+04, 2.0477767790E+00, 3.4701301601E+00, 5.8811609888E-02, 5.6243116579E-02, 6.0782333969E-01],
	[1.4615000000E+04, 2.0487049674E+00, 3.4698607117E+00, 5.8870501239E-02, 5.6297604237E-02, 6.0795000043E-01],
	[1.4620000000E+04, 2.0496332588E+00, 3.4695913764E+00, 5.8929431318E-02, 5.6352124487E-02, 6.0807660840E-01],
	[1.4625000000E+04, 2.0505616532E+00, 3.4693221541E+00, 5.8988400136E-02, 5.6406677332E-02, 6.0820316363E-01],
	[1.4630000000E+04, 2.0514901506E+00, 3.4690530448E+00, 5.9047407705E-02, 5.6461262780E-02, 6.0832966611E-01],
	[1.4635000000E+04, 2.0524187509E+00, 3.4687840482E+00, 5.9106454038E-02, 5.6515880835E-02, 6.0845611587E-01],
	[1.4640000000E+04, 2.0533474541E+00, 3.4685151644E+00, 5.9165539147E-02, 5.6570531504E-02, 6.0858251291E-01],
	[1.4645000000E+04, 2.0542762602E+00, 3.4682463932E+00, 5.9224663043E-02, 5.6625214791E-02, 6.0870885724E-01],
	[1.4650000000E+04, 2.0552051692E+00, 3.4679777346E+00, 5.9283825740E-02, 5.6679930702E-02, 6.0883514887E-01],
	[1.4655000000E+04, 2.0561341810E+00, 3.4677091885E+00, 5.9343027249E-02, 5.6734679243E-02, 6.0896138781E-01],
	[1.4660000000E+04, 2.0570632956E+00, 3.4674407547E+00, 5.9402267582E-02, 5.6789460420E-02, 6.0908757407E-01],
	[1.4665000000E+04, 2.0579925131E+00, 3.4671724333E+00, 5.9461546752E-02, 5.6844274237E-02, 6.0921370766E-01],
	[1.4670000000E+04, 2.0589218333E+00, 3.4669042240E+00, 5.9520864770E-02, 5.6899120700E-02, 6.0933978860E-01],
	[1.4675000000E+04, 2.0598512562E+00, 3.4666361270E+00, 5.9580221649E-02, 5.6953999815E-02, 6.0946581689E-01],
	[1.4680000000E+04, 2.0607807819E+00, 3.4663681419E+00, 5.9639617401E-02, 5.7008911588E-02, 6.0959179254E-01],
	[1.4685000000E+04, 2.0617104102E+00, 3.4661002689E+00, 5.9699052038E-02, 5.7063856024E-02, 6.0971771556E-01],
	[1.4690000000E+04, 2.0626401413E+00, 3.4658325077E+00, 5.9758525572E-02, 5.7118833127E-02, 6.0984358597E-01],
	[1.4695000000E+04, 2.0635699750E+00, 3.4655648583E+00, 5.9818038016E-02, 5.7173842905E-02, 6.0996940377E-01],
	[1.4700000000E+04, 2.0644999113E+00, 3.4652973206E+00, 5.9877589381E-02, 5.7228885362E-02, 6.1009516897E-01],
	[1.4705000000E+04, 2.0654299503E+00, 3.4650298946E+00, 5.9937179679E-02, 5.7283960504E-02, 6.1022088159E-01],
	[1.4710000000E+04, 2.0663600918E+00, 3.4647625800E+00, 5.9996808923E-02, 5.7339068336E-02, 6.1034654164E-01],
	[1.4715000000E+04, 2.0672903359E+00, 3.4644953770E+00, 6.0056477126E-02, 5.7394208864E-02, 6.1047214912E-01],
	[1.4720000000E+04, 2.0682206825E+00, 3.4642282853E+00, 6.0116184298E-02, 5.7449382093E-02, 6.1059770405E-01],
	[1.4725000000E+04, 2.0691511316E+00, 3.4639613049E+00, 6.0175930452E-02, 5.7504588029E-02, 6.1072320643E-01],
	[1.4730000000E+04, 2.0700816832E+00, 3.4636944357E+00, 6.0235715601E-02, 5.7559826677E-02, 6.1084865628E-01],
	[1.4735000000E+04, 2.0710123373E+00, 3.4634276777E+00, 6.0295539756E-02, 5.7615098042E-02, 6.1097405361E-01],
	[1.4740000000E+04, 2.0719430938E+00, 3.4631610307E+00, 6.0355402929E-02, 5.7670402131E-02, 6.1109939843E-01],
	[1.4745000000E+04, 2.0728739527E+00, 3.4628944946E+00, 6.0415305134E-02, 5.7725738948E-02, 6.1122469075E-01],
	[1.4750000000E+04, 2.0738049141E+00, 3.4626280694E+00, 6.0475246381E-02, 5.7781108499E-02, 6.1134993057E-01],
	[1.4755000000E+04, 2.0747359778E+00, 3.4623617550E+00, 6.0535226683E-02, 5.7836510789E-02, 6.1147511792E-01],
	[1.4760000000E+04, 2.0756671438E+00, 3.4620955512E+00, 6.0595246052E-02, 5.7891945824E-02, 6.1160025280E-01],
	[1.4765000000E+04, 2.0765984122E+00, 3.4618294582E+00, 6.0655304500E-02, 5.7947413610E-02, 6.1172533523E-01],
	[1.4770000000E+04, 2.0775297828E+00, 3.4615634756E+00, 6.0715402040E-02, 5.8002914151E-02, 6.1185036520E-01],
	[1.4775000000E+04, 2.0784612558E+00, 3.4612976035E+00, 6.0775538683E-02, 5.8058447453E-02, 6.1197534274E-01],
	[1.4780000000E+04, 2.0793928310E+00, 3.4610318417E+00, 6.0835714442E-02, 5.8114013521E-02, 6.1210026785E-01],
	[1.4785000000E+04, 2.0803245084E+00, 3.4607661903E+00, 6.0895929329E-02, 5.8169612362E-02, 6.1222514055E-01],
	[1.4790000000E+04, 2.0812562881E+00, 3.4605006490E+00, 6.0956183355E-02, 5.8225243979E-02, 6.1234996085E-01],
	[1.4795000000E+04, 2.0821881699E+00, 3.4602352179E+00, 6.1016476534E-02, 5.8280908379E-02, 6.1247472875E-01],
	[1.4800000000E+04, 2.0831201539E+00, 3.4599698968E+00, 6.1076808876E-02, 5.8336605568E-02, 6.1259944427E-01],
	[1.4805000000E+04, 2.0840522400E+00, 3.4597046857E+00, 6.1137180395E-02, 5.8392335549E-02, 6.1272410743E-01],
	[1.4810000000E+04, 2.0849844282E+00, 3.4594395844E+00, 6.1197591103E-02, 5.8448098330E-02, 6.1284871822E-01],
	[1.4815000000E+04, 2.0859203131E+00, 3.4591774711E+00, 6.1258041011E-02, 5.8503897565E-02, 6.1297327666E-01],
	[1.4820000000E+04, 2.0868581475E+00, 3.4589169430E+00, 6.1318530131E-02, 5.8559731497E-02, 6.1309778277E-01],
	[1.4825000000E+04, 2.0877960870E+00, 3.4586565224E+00, 6.1379058477E-02, 5.8615598259E-02, 6.1322223654E-01],
	[1.4830000000E+04, 2.0887341316E+00, 3.4583962091E+00, 6.1439626059E-02, 5.8671497856E-02, 6.1334663798E-01],
	[1.4835000000E+04, 2.0896722812E+00, 3.4581360033E+00, 6.1500232890E-02, 5.8727430296E-02, 6.1347098710E-01],
	[1.4840000000E+04, 2.0906105357E+00, 3.4578759046E+00, 6.1560878983E-02, 5.8783395581E-02, 6.1359528390E-01],
	[1.4845000000E+04, 2.0915488953E+00, 3.4576159132E+00, 6.1621564349E-02, 5.8839393719E-02, 6.1371952840E-01],
	[1.4850000000E+04, 2.0924873599E+00, 3.4573560288E+00, 6.1682289000E-02, 5.8895424713E-02, 6.1384372059E-01],
	[1.4855000000E+04, 2.0934259294E+00, 3.4570962514E+00, 6.1743052949E-02, 5.8951488571E-02, 6.1396786048E-01],
	[1.4860000000E+04, 2.0943646038E+00, 3.4568365810E+00, 6.1803856208E-02, 5.9007585296E-02, 6.1409194809E-01],
	[1.4865000000E+04, 2.0953033831E+00, 3.4565770174E+00, 6.1864698788E-02, 5.9063714895E-02, 6.1421598342E-01],
	[1.4870000000E+04, 2.0962422673E+00, 3.4563175606E+00, 6.1925580703E-02, 5.9119877372E-02, 6.1433996647E-01],
	[1.4875000000E+04, 2.0971812563E+00, 3.4560582105E+00, 6.1986501963E-02, 5.9176072734E-02, 6.1446389726E-01],
	[1.4880000000E+04, 2.0981203502E+00, 3.4557989670E+00, 6.2047462582E-02, 5.9232300984E-02, 6.1458777579E-01],
	[1.4885000000E+04, 2.0990595488E+00, 3.4555398301E+00, 6.2108462571E-02, 5.9288562130E-02, 6.1471160207E-01],
	[1.4890000000E+04, 2.0999988522E+00, 3.4552807996E+00, 6.2169501942E-02, 5.9344856175E-02, 6.1483537610E-01],
	[1.4895000000E+04, 2.1009382604E+00, 3.4550218754E+00, 6.2230580709E-02, 5.9401183125E-02, 6.1495909790E-01],
	[1.4900000000E+04, 2.1018777733E+00, 3.4547630576E+00, 6.2291698881E-02, 5.9457542986E-02, 6.1508276747E-01],
	[1.4905000000E+04, 2.1028173910E+00, 3.4545043460E+00, 6.2352856473E-02, 5.9513935763E-02, 6.1520638481E-01],
	[1.4910000000E+04, 2.1037571133E+00, 3.4542457405E+00, 6.2414053495E-02, 5.9570361461E-02, 6.1532994995E-01],
	[1.4915000000E+04, 2.1046969402E+00, 3.4539872410E+00, 6.2475289961E-02, 5.9626820085E-02, 6.1545346288E-01],
	[1.4920000000E+04, 2.1056368718E+00, 3.4537288476E+00, 6.2536565882E-02, 5.9683311642E-02, 6.1557692361E-01],
	[1.4925000000E+04, 2.1065769080E+00, 3.4534705600E+00, 6.2597881270E-02, 5.9739836135E-02, 6.1570033215E-01],
	[1.4930000000E+04, 2.1075170488E+00, 3.4532123783E+00, 6.2659236137E-02, 5.9796393570E-02, 6.1582368850E-01],
	[1.4935000000E+04, 2.1084572942E+00, 3.4529543023E+00, 6.2720630496E-02, 5.9852983953E-02, 6.1594699268E-01],
	[1.4940000000E+04, 2.1093976441E+00, 3.4526963320E+00, 6.2782064359E-02, 5.9909607288E-02, 6.1607024470E-01],
	[1.4945000000E+04, 2.1103380986E+00, 3.4524384672E+00, 6.2843537738E-02, 5.9966263582E-02, 6.1619344455E-01],
	[1.4950000000E+04, 2.1112786575E+00, 3.4521807080E+00, 6.2905050644E-02, 6.0022952839E-02, 6.1631659225E-01],
	[1.4955000000E+04, 2.1122193209E+00, 3.4519230542E+00, 6.2966603091E-02, 6.0079675064E-02, 6.1643968781E-01],
	[1.4960000000E+04, 2.1131600887E+00, 3.4516655057E+00, 6.3028195089E-02, 6.0136430263E-02, 6.1656273123E-01],
	[1.4965000000E+04, 2.1141009610E+00, 3.4514080625E+00, 6.3089826652E-02, 6.0193218441E-02, 6.1668572252E-01],
	[1.4970000000E+04, 2.1150419377E+00, 3.4511507245E+00, 6.3151497792E-02, 6.0250039604E-02, 6.1680866170E-01],
	[1.4975000000E+04, 2.1159830188E+00, 3.4508934916E+00, 6.3213208520E-02, 6.0306893756E-02, 6.1693154876E-01],
	[1.4980000000E+04, 2.1169242042E+00, 3.4506363638E+00, 6.3274958848E-02, 6.0363780902E-02, 6.1705438372E-01],
	[1.4985000000E+04, 2.1178654939E+00, 3.4503793409E+00, 6.3336748789E-02, 6.0420701048E-02, 6.1717716658E-01],
	[1.4990000000E+04, 2.1188068880E+00, 3.4501224229E+00, 6.3398578355E-02, 6.0477654200E-02, 6.1729989735E-01],
	[1.4995000000E+04, 2.1197483863E+00, 3.4498656097E+00, 6.3460447558E-02, 6.0534640362E-02, 6.1742257604E-01],
	[1.5000000000E+04, 2.1206899889E+00, 3.4496089012E+00, 6.3522356411E-02, 6.0591659539E-02, 6.1754520266E-01],
	[1.5005000000E+04, 2.1216316958E+00, 3.4493522974E+00, 6.3585035412E-02, 6.0649376330E-02, 6.1766777722E-01],
	[1.5010000000E+04, 2.1225735069E+00, 3.4490957981E+00, 6.3647755288E-02, 6.0707127150E-02, 6.1779029972E-01],
	[1.5015000000E+04, 2.1235154221E+00, 3.4488394033E+00, 6.3710516051E-02, 6.0764912005E-02, 6.1791277018E-01],
	[1.5020000000E+04, 2.1244574416E+00, 3.4485831130E+00, 6.3773317715E-02, 6.0822730898E-02, 6.1803518859E-01],
	[1.5025000000E+04, 2.1253995651E+00, 3.4483269270E+00, 6.3836160292E-02, 6.0880583838E-02, 6.1815755498E-01],
	[1.5030000000E+04, 2.1263417928E+00, 3.4480708452E+00, 6.3899043795E-02, 6.0938470828E-02, 6.1827986934E-01],
	[1.5035000000E+04, 2.1272841246E+00, 3.4478148676E+00, 6.3961968237E-02, 6.0996391876E-02, 6.1840213169E-01],
	[1.5040000000E+04, 2.1282265605E+00, 3.4475589942E+00, 6.4024933632E-02, 6.1054346985E-02, 6.1852434204E-01],
	[1.5045000000E+04, 2.1291691005E+00, 3.4473032247E+00, 6.4087939992E-02, 6.1112336163E-02, 6.1864650039E-01],
	[1.5050000000E+04, 2.1301117444E+00, 3.4470475593E+00, 6.4150987329E-02, 6.1170359415E-02, 6.1876860674E-01],
	[1.5055000000E+04, 2.1310598435E+00, 3.4467961573E+00, 6.4214075658E-02, 6.1228422476E-02, 6.1889066112E-01],
	[1.5060000000E+04, 2.1320082082E+00, 3.4465449804E+00, 6.4277204992E-02, 6.1286519808E-02, 6.1901266353E-01],
	[1.5065000000E+04, 2.1329566800E+00, 3.4462939051E+00, 6.4340375342E-02, 6.1344651247E-02, 6.1913461398E-01],
	[1.5070000000E+04, 2.1339052587E+00, 3.4460429315E+00, 6.4403586722E-02, 6.1402816799E-02, 6.1925651247E-01],
	[1.5075000000E+04, 2.1348539444E+00, 3.4457920594E+00, 6.4466839145E-02, 6.1461016470E-02, 6.1937835901E-01],
	[1.5080000000E+04, 2.1358027371E+00, 3.4455412888E+00, 6.4530132624E-02, 6.1519250265E-02, 6.1950015362E-01],
	[1.5085000000E+04, 2.1367516367E+00, 3.4452906195E+00, 6.4593467172E-02, 6.1577518190E-02, 6.1962189630E-01],
	[1.5090000000E+04, 2.1377006431E+00, 3.4450400515E+00, 6.4656842802E-02, 6.1635820250E-02, 6.1974358706E-01],
	[1.5095000000E+04, 2.1386497565E+00, 3.4447895848E+00, 6.4720259527E-02, 6.1694156452E-02, 6.1986522591E-01],
	[1.5100000000E+04, 2.1395989767E+00, 3.4445392191E+00, 6.4783717359E-02, 6.1752526800E-02, 6.1998681286E-01],
	[1.5105000000E+04, 2.1405483038E+00, 3.4442889546E+00, 6.4847216313E-02, 6.1810931300E-02, 6.2010834791E-01],
	[1.5110000000E+04, 2.1414977377E+00, 3.4440387911E+00, 6.4910756400E-02, 6.1869369959E-02, 6.2022983108E-01],
	[1.5115000000E+04, 2.1424472784E+00, 3.4437887285E+00, 6.4974337634E-02, 6.1927842781E-02, 6.2035126238E-01],
	[1.5120000000E+04, 2.1433969258E+00, 3.4435387667E+00, 6.5037960027E-02, 6.1986349772E-02, 6.2047264181E-01],
	[1.5125000000E+04, 2.1443466800E+00, 3.4432889058E+00, 6.5101623593E-02, 6.2044890937E-02, 6.2059396938E-01],
	[1.5130000000E+04, 2.1452965408E+00, 3.4430391455E+00, 6.5165328345E-02, 6.2103466283E-02, 6.2071524510E-01],
	[1.5135000000E+04, 2.1462465084E+00, 3.4427894859E+00, 6.5229074296E-02, 6.2162075815E-02, 6.2083646898E-01],
	[1.5140000000E+04, 2.1471965827E+00, 3.4425399268E+00, 6.5292861458E-02, 6.2220719538E-02, 6.2095764103E-01],
	[1.5145000000E+04, 2.1481467636E+00, 3.4422904682E+00, 6.5356689844E-02, 6.2279397459E-02, 6.2107876126E-01],
	[1.5150000000E+04, 2.1490970511E+00, 3.4420411101E+00, 6.5420559468E-02, 6.2338109581E-02, 6.2119982968E-01],
	[1.5155000000E+04, 2.1500474452E+00, 3.4417918522E+00, 6.5484470343E-02, 6.2396855912E-02, 6.2132084629E-01],
	[1.5160000000E+04, 2.1509979459E+00, 3.4415426947E+00, 6.5548422481E-02, 6.2455636457E-02, 6.2144181111E-01],
	[1.5165000000E+04, 2.1519485532E+00, 3.4412936373E+00, 6.5612415895E-02, 6.2514451221E-02, 6.2156272414E-01],
	[1.5170000000E+04, 2.1528992670E+00, 3.4410446800E+00, 6.5676450599E-02, 6.2573300210E-02, 6.2168358540E-01],
	[1.5175000000E+04, 2.1538500873E+00, 3.4407958228E+00, 6.5740526604E-02, 6.2632183428E-02, 6.2180439489E-01],
	[1.5180000000E+04, 2.1548010141E+00, 3.4405470655E+00, 6.5804643926E-02, 6.2691100883E-02, 6.2192515263E-01],
	[1.5185000000E+04, 2.1557520473E+00, 3.4402984082E+00, 6.5868802575E-02, 6.2750052579E-02, 6.2204585861E-01],
	[1.5190000000E+04, 2.1567031870E+00, 3.4400498507E+00, 6.5933002566E-02, 6.2809038522E-02, 6.2216651286E-01],
	[1.5195000000E+04, 2.1576544331E+00, 3.4398013929E+00, 6.5997243911E-02, 6.2868058717E-02, 6.2228711538E-01],
	[1.5200000000E+04, 2.1586057856E+00, 3.4395530348E+00, 6.6061526622E-02, 6.2927113170E-02, 6.2240766618E-01],
	[1.5205000000E+04, 2.1595572445E+00, 3.4393047763E+00, 6.6125850714E-02, 6.2986201887E-02, 6.2252816526E-01],
	[1.5210000000E+04, 2.1605088097E+00, 3.4390566173E+00, 6.6190216199E-02, 6.3045324872E-02, 6.2264861265E-01],
	[1.5215000000E+04, 2.1614604812E+00, 3.4388085578E+00, 6.6254623091E-02, 6.3104482132E-02, 6.2276900834E-01],
	[1.5220000000E+04, 2.1624122591E+00, 3.4385605977E+00, 6.6319071401E-02, 6.3163673671E-02, 6.2288935235E-01],
	[1.5225000000E+04, 2.1633641432E+00, 3.4383127369E+00, 6.6383561143E-02, 6.3222899496E-02, 6.2300964469E-01],
	[1.5230000000E+04, 2.1643161335E+00, 3.4380649754E+00, 6.6448092329E-02, 6.3282159612E-02, 6.2312988537E-01],
	[1.5235000000E+04, 2.1652682301E+00, 3.4378173130E+00, 6.6512664974E-02, 6.3341454024E-02, 6.2325007439E-01],
	[1.5240000000E+04, 2.1662204329E+00, 3.4375697497E+00, 6.6577279090E-02, 6.3400782737E-02, 6.2337021177E-01],
	[1.5245000000E+04, 2.1671727419E+00, 3.4373222855E+00, 6.6641934689E-02, 6.3460145758E-02, 6.2349029751E-01],
	[1.5250000000E+04, 2.1681251571E+00, 3.4370749202E+00, 6.6706631785E-02, 6.3519543091E-02, 6.2361033163E-01],
	[1.5255000000E+04, 2.1690776784E+00, 3.4368276538E+00, 6.6771370391E-02, 6.3578974743E-02, 6.2373031413E-01],
	[1.5260000000E+04, 2.1700303058E+00, 3.4365804862E+00, 6.6836150519E-02, 6.3638440717E-02, 6.2385024503E-01],
	[1.5265000000E+04, 2.1709830393E+00, 3.4363334173E+00, 6.6900972183E-02, 6.3697941021E-02, 6.2397012433E-01],
	[1.5270000000E+04, 2.1719358789E+00, 3.4360864471E+00, 6.6965835396E-02, 6.3757475659E-02, 6.2408995205E-01],
	[1.5275000000E+04, 2.1728888245E+00, 3.4358395755E+00, 6.7030740170E-02, 6.3817044637E-02, 6.2420972819E-01],
	[1.5280000000E+04, 2.1738418761E+00, 3.4355928024E+00, 6.7095686519E-02, 6.3876647960E-02, 6.2432945276E-01],
	[1.5285000000E+04, 2.1747950338E+00, 3.4353461278E+00, 6.7160674455E-02, 6.3936285634E-02, 6.2444912578E-01],
	[1.5290000000E+04, 2.1757482974E+00, 3.4350995516E+00, 6.7225703991E-02, 6.3995957663E-02, 6.2456874725E-01],
	[1.5295000000E+04, 2.1767044932E+00, 3.4348552397E+00, 6.7290775141E-02, 6.4055667255E-02, 6.2468831718E-01],
	[1.5300000000E+04, 2.1776634710E+00, 3.4346130738E+00, 6.7355887918E-02, 6.4115414255E-02, 6.2480783559E-01],
	[1.5305000000E+04, 2.1786225578E+00, 3.4343710042E+00, 6.7421042333E-02, 6.4175195644E-02, 6.2492730248E-01],
	[1.5310000000E+04, 2.1795817535E+00, 3.4341290306E+00, 6.7486238401E-02, 6.4235011428E-02, 6.2504671786E-01],
	[1.5315000000E+04, 2.1805410581E+00, 3.4338871532E+00, 6.7551476134E-02, 6.4294861612E-02, 6.2516608175E-01],
	[1.5320000000E+04, 2.1815004716E+00, 3.4336453717E+00, 6.7616755545E-02, 6.4354746202E-02, 6.2528539415E-01],
	[1.5325000000E+04, 2.1824599940E+00, 3.4334036861E+00, 6.7682076647E-02, 6.4414665203E-02, 6.2540465508E-01],
	[1.5330000000E+04, 2.1834196251E+00, 3.4331620963E+00, 6.7747439453E-02, 6.4474618620E-02, 6.2552386454E-01],
	[1.5335000000E+04, 2.1843793651E+00, 3.4329206024E+00, 6.7812843977E-02, 6.4534606459E-02, 6.2564302254E-01],
	[1.5340000000E+04, 2.1853392138E+00, 3.4326792041E+00, 6.7878290230E-02, 6.4594628725E-02, 6.2576212909E-01],
	[1.5345000000E+04, 2.1862991714E+00, 3.4324379015E+00, 6.7943778226E-02, 6.4654685424E-02, 6.2588118421E-01],
	[1.5350000000E+04, 2.1872592376E+00, 3.4321966944E+00, 6.8009307979E-02, 6.4714776561E-02, 6.2600018791E-01],
	[1.5355000000E+04, 2.1882194126E+00, 3.4319555829E+00, 6.8074879500E-02, 6.4774902141E-02, 6.2611914019E-01],
	[1.5360000000E+04, 2.1891796962E+00, 3.4317145667E+00, 6.8140492802E-02, 6.4835062169E-02, 6.2623804106E-01],
	[1.5365000000E+04, 2.1901400885E+00, 3.4314736460E+00, 6.8206147900E-02, 6.4895256651E-02, 6.2635689054E-01],
	[1.5370000000E+04, 2.1911005895E+00, 3.4312328205E+00, 6.8271844805E-02, 6.4955485593E-02, 6.2647568863E-01],
	[1.5375000000E+04, 2.1920611991E+00, 3.4309920902E+00, 6.8337583531E-02, 6.5015748999E-02, 6.2659443535E-01],
	[1.5380000000E+04, 2.1930219172E+00, 3.4307514551E+00, 6.8403364091E-02, 6.5076046875E-02, 6.2671313071E-01],
	[1.5385000000E+04, 2.1939827440E+00, 3.4305109151E+00, 6.8469186497E-02, 6.5136379227E-02, 6.2683177471E-01],
	[1.5390000000E+04, 2.1949436793E+00, 3.4302704701E+00, 6.8535050763E-02, 6.5196746059E-02, 6.2695036737E-01],
	[1.5395000000E+04, 2.1959047231E+00, 3.4300301201E+00, 6.8600956901E-02, 6.5257147377E-02, 6.2706890870E-01],
	[1.5400000000E+04, 2.1968658754E+00, 3.4297898649E+00, 6.8666904925E-02, 6.5317583186E-02, 6.2718739871E-01],
	[1.5405000000E+04, 2.1978271363E+00, 3.4295497046E+00, 6.8732894847E-02, 6.5378053491E-02, 6.2730583740E-01],
	[1.5410000000E+04, 2.1987885055E+00, 3.4293096389E+00, 6.8798926680E-02, 6.5438558299E-02, 6.2742422479E-01],
	[1.5415000000E+04, 2.1997499832E+00, 3.4290696680E+00, 6.8865000438E-02, 6.5499097613E-02, 6.2754256089E-01],
	[1.5420000000E+04, 2.2007115694E+00, 3.4288297917E+00, 6.8931116133E-02, 6.5559671440E-02, 6.2766084572E-01],
	[1.5425000000E+04, 2.2016732639E+00, 3.4285900099E+00, 6.8997273778E-02, 6.5620279784E-02, 6.2777907927E-01],
	[1.5430000000E+04, 2.2026350667E+00, 3.4283503226E+00, 6.9063473386E-02, 6.5680922652E-02, 6.2789726156E-01],
	[1.5435000000E+04, 2.2035969780E+00, 3.4281107297E+00, 6.9129714971E-02, 6.5741600047E-02, 6.2801539261E-01],
	[1.5440000000E+04, 2.2045589975E+00, 3.4278712311E+00, 6.9195998544E-02, 6.5802311976E-02, 6.2813347242E-01],
	[1.5445000000E+04, 2.2055211253E+00, 3.4276318268E+00, 6.9262324119E-02, 6.5863058444E-02, 6.2825150100E-01],
	[1.5450000000E+04, 2.2064833615E+00, 3.4273925167E+00, 6.9328691710E-02, 6.5923839456E-02, 6.2836947837E-01],
	[1.5455000000E+04, 2.2074457058E+00, 3.4271533008E+00, 6.9395101328E-02, 6.5984655016E-02, 6.2848740453E-01],
	[1.5460000000E+04, 2.2084081584E+00, 3.4269141789E+00, 6.9461552987E-02, 6.6045505132E-02, 6.2860527950E-01],
	[1.5465000000E+04, 2.2093707192E+00, 3.4266751510E+00, 6.9528046700E-02, 6.6106389806E-02, 6.2872310329E-01],
	[1.5470000000E+04, 2.2103333882E+00, 3.4264362170E+00, 6.9594582480E-02, 6.6167309046E-02, 6.2884087590E-01],
	[1.5475000000E+04, 2.2112961654E+00, 3.4261973769E+00, 6.9661160340E-02, 6.6228262856E-02, 6.2895859735E-01],
	[1.5480000000E+04, 2.2122590507E+00, 3.4259586306E+00, 6.9727780292E-02, 6.6289251241E-02, 6.2907626765E-01],
	[1.5485000000E+04, 2.2132220441E+00, 3.4257199780E+00, 6.9794442350E-02, 6.6350274207E-02, 6.2919388681E-01],
	[1.5490000000E+04, 2.2141851456E+00, 3.4254814191E+00, 6.9861146526E-02, 6.6411331758E-02, 6.2931145484E-01],
	[1.5495000000E+04, 2.2151483552E+00, 3.4252429538E+00, 6.9927892834E-02, 6.6472423901E-02, 6.2942897175E-01],
	[1.5500000000E+04, 2.2161116728E+00, 3.4250045820E+00, 6.9994681286E-02, 6.6533550639E-02, 6.2954643756E-01],
	[1.5505000000E+04, 2.2170750984E+00, 3.4247663037E+00, 7.0061511896E-02, 6.6594711979E-02, 6.2966385227E-01],
	[1.5510000000E+04, 2.2180386321E+00, 3.4245281188E+00, 7.0128384676E-02, 6.6655907925E-02, 6.2978121589E-01],
	[1.5515000000E+04, 2.2190022737E+00, 3.4242900272E+00, 7.0195299639E-02, 6.6717138483E-02, 6.2989852844E-01],
	[1.5520000000E+04, 2.2199660233E+00, 3.4240520288E+00, 7.0262256799E-02, 6.6778403658E-02, 6.3001578993E-01],
	[1.5525000000E+04, 2.2209298808E+00, 3.4238141237E+00, 7.0329256168E-02, 6.6839703454E-02, 6.3013300037E-01],
	[1.5530000000E+04, 2.2218938462E+00, 3.4235763117E+00, 7.0396297759E-02, 6.6901037878E-02, 6.3025015977E-01],
	[1.5535000000E+04, 2.2228579195E+00, 3.4233385927E+00, 7.0463381585E-02, 6.6962406935E-02, 6.3036726814E-01],
	[1.5540000000E+04, 2.2238236154E+00, 3.4231021135E+00, 7.0530507659E-02, 6.7023812444E-02, 6.3048432549E-01],
	[1.5545000000E+04, 2.2247933868E+00, 3.4228687284E+00, 7.0597675994E-02, 6.7085257360E-02, 6.3060133183E-01],
	[1.5550000000E+04, 2.2257632691E+00, 3.4226354343E+00, 7.0664886603E-02, 6.7146736943E-02, 6.3071828718E-01],
	[1.5555000000E+04, 2.2267332622E+00, 3.4224022311E+00, 7.0732139499E-02, 6.7208251195E-02, 6.3083519154E-01],
	[1.5560000000E+04, 2.2277033661E+00, 3.4221691187E+00, 7.0799434695E-02, 6.7269800124E-02, 6.3095204493E-01],
	[1.5565000000E+04, 2.2286735807E+00, 3.4219360970E+00, 7.0866772203E-02, 6.7331383734E-02, 6.3106884736E-01],
	[1.5570000000E+04, 2.2296439060E+00, 3.4217031661E+00, 7.0934152037E-02, 6.7393002030E-02, 6.3118559884E-01],
	[1.5575000000E+04, 2.2306143421E+00, 3.4214703258E+00, 7.1001574210E-02, 6.7454655018E-02, 6.3130229938E-01],
	[1.5580000000E+04, 2.2315848888E+00, 3.4212375761E+00, 7.1069038735E-02, 6.7516342702E-02, 6.3141894899E-01],
	[1.5585000000E+04, 2.2325555462E+00, 3.4210049168E+00, 7.1136545624E-02, 6.7578065088E-02, 6.3153554769E-01],
	[1.5590000000E+04, 2.2335263142E+00, 3.4207723481E+00, 7.1204094890E-02, 6.7639822180E-02, 6.3165209548E-01],
	[1.5595000000E+04, 2.2344971929E+00, 3.4205398697E+00, 7.1271686547E-02, 6.7701613984E-02, 6.3176859238E-01],
	[1.5600000000E+04, 2.2354681821E+00, 3.4203074816E+00, 7.1339320608E-02, 6.7763440505E-02, 6.3188503839E-01],
	[1.5605000000E+04, 2.2364392819E+00, 3.4200751838E+00, 7.1406997084E-02, 6.7825301748E-02, 6.3200143354E-01],
	[1.5610000000E+04, 2.2374104923E+00, 3.4198429761E+00, 7.1474715990E-02, 6.7887197718E-02, 6.3211777783E-01],
	[1.5615000000E+04, 2.2383818132E+00, 3.4196108586E+00, 7.1542477338E-02, 6.7949128421E-02, 6.3223407127E-01],
	[1.5620000000E+04, 2.2393532446E+00, 3.4193788312E+00, 7.1610281142E-02, 6.8011093860E-02, 6.3235031387E-01],
	[1.5625000000E+04, 2.2403247864E+00, 3.4191468937E+00, 7.1678127413E-02, 6.8073094042E-02, 6.3246650565E-01],
	[1.5630000000E+04, 2.2412964388E+00, 3.4189150462E+00, 7.1746016166E-02, 6.8135128972E-02, 6.3258264662E-01],
	[1.5635000000E+04, 2.2422682015E+00, 3.4186832885E+00, 7.1813947412E-02, 6.8197198654E-02, 6.3269873679E-01],
	[1.5640000000E+04, 2.2432400747E+00, 3.4184516207E+00, 7.1881921166E-02, 6.8259303094E-02, 6.3281477617E-01],
	[1.5645000000E+04, 2.2442120583E+00, 3.4182200426E+00, 7.1949937439E-02, 6.8321442296E-02, 6.3293076477E-01],
	[1.5650000000E+04, 2.2451841522E+00, 3.4179885542E+00, 7.2017996245E-02, 6.8383616266E-02, 6.3304670261E-01],
	[1.5655000000E+04, 2.2461563565E+00, 3.4177571553E+00, 7.2086097597E-02, 6.8445825008E-02, 6.3316258969E-01],
	[1.5660000000E+04, 2.2471286711E+00, 3.4175258461E+00, 7.2154241507E-02, 6.8508068529E-02, 6.3327842604E-01],
	[1.5665000000E+04, 2.2481010960E+00, 3.4172946263E+00, 7.2222427989E-02, 6.8570346832E-02, 6.3339421165E-01],
	[1.5670000000E+04, 2.2490736311E+00, 3.4170634960E+00, 7.2290657056E-02, 6.8632659923E-02, 6.3350994654E-01],
	[1.5675000000E+04, 2.2500462765E+00, 3.4168324550E+00, 7.2358928720E-02, 6.8695007806E-02, 6.3362563073E-01],
	[1.5680000000E+04, 2.2510190322E+00, 3.4166015033E+00, 7.2427242995E-02, 6.8757390488E-02, 6.3374126422E-01],
	[1.5685000000E+04, 2.2519918980E+00, 3.4163706409E+00, 7.2495599893E-02, 6.8819807972E-02, 6.3385684703E-01],
	[1.5690000000E+04, 2.2529648741E+00, 3.4161398676E+00, 7.2563999428E-02, 6.8882260265E-02, 6.3397237917E-01],
	[1.5695000000E+04, 2.2539379603E+00, 3.4159091834E+00, 7.2632441611E-02, 6.8944747370E-02, 6.3408786065E-01],
	[1.5700000000E+04, 2.2549111566E+00, 3.4156785883E+00, 7.2700926457E-02, 6.9007269293E-02, 6.3420329148E-01],
	[1.5705000000E+04, 2.2558844631E+00, 3.4154480822E+00, 7.2769453978E-02, 6.9069826039E-02, 6.3431867168E-01],
	[1.5710000000E+04, 2.2568578796E+00, 3.4152176650E+00, 7.2838024188E-02, 6.9132417612E-02, 6.3443400125E-01],
	[1.5715000000E+04, 2.2578314062E+00, 3.4149873366E+00, 7.2906637098E-02, 6.9195044019E-02, 6.3454928022E-01],
	[1.5720000000E+04, 2.2588050429E+00, 3.4147570971E+00, 7.2975292722E-02, 6.9257705263E-02, 6.3466450858E-01],
	[1.5725000000E+04, 2.2597787896E+00, 3.4145269463E+00, 7.3043991073E-02, 6.9320401350E-02, 6.3477968636E-01],
	[1.5730000000E+04, 2.2607526463E+00, 3.4142968841E+00, 7.3112732164E-02, 6.9383132284E-02, 6.3489481356E-01],
	[1.5735000000E+04, 2.2617266130E+00, 3.4140669106E+00, 7.3181516008E-02, 6.9445898071E-02, 6.3500989021E-01],
	[1.5740000000E+04, 2.2627006896E+00, 3.4138370256E+00, 7.3250342617E-02, 6.9508698716E-02, 6.3512491630E-01],
	[1.5745000000E+04, 2.2636748762E+00, 3.4136072291E+00, 7.3319212006E-02, 6.9571534223E-02, 6.3523989185E-01],
	[1.5750000000E+04, 2.2646491726E+00, 3.4133775211E+00, 7.3388124185E-02, 6.9634404598E-02, 6.3535481688E-01],
	[1.5755000000E+04, 2.2656235790E+00, 3.4131479014E+00, 7.3457079170E-02, 6.9697309845E-02, 6.3546969139E-01],
	[1.5760000000E+04, 2.2665980953E+00, 3.4129183700E+00, 7.3526076971E-02, 6.9760249969E-02, 6.3558451540E-01],
	[1.5765000000E+04, 2.2675727214E+00, 3.4126889268E+00, 7.3595117604E-02, 6.9823224976E-02, 6.3569928892E-01],
	[1.5770000000E+04, 2.2685474573E+00, 3.4124595718E+00, 7.3664201079E-02, 6.9886234869E-02, 6.3581401197E-01],
	[1.5775000000E+04, 2.2695223030E+00, 3.4122303049E+00, 7.3733327411E-02, 6.9949279655E-02, 6.3592868455E-01],
	[1.5780000000E+04, 2.2704972585E+00, 3.4120011261E+00, 7.3802496612E-02, 7.0012359338E-02, 6.3604330667E-01],
	[1.5785000000E+04, 2.2714723237E+00, 3.4117720352E+00, 7.3871708695E-02, 7.0075473922E-02, 6.3615787836E-01],
	[1.5790000000E+04, 2.2724488437E+00, 3.4115440381E+00, 7.3940963673E-02, 7.0138625119E-02, 6.3627239962E-01],
	[1.5795000000E+04, 2.2734295918E+00, 3.4113192059E+00, 7.4010261560E-02, 7.0201816463E-02, 6.3638687047E-01],
	[1.5800000000E+04, 2.2744104526E+00, 3.4110944596E+00, 7.4079602367E-02, 7.0265042741E-02, 6.3650129091E-01],
	[1.5805000000E+04, 2.2753914260E+00, 3.4108697993E+00, 7.4148986108E-02, 7.0328303959E-02, 6.3661566096E-01],
	[1.5810000000E+04, 2.2763725121E+00, 3.4106452248E+00, 7.4218412796E-02, 7.0391600122E-02, 6.3672998063E-01],
	[1.5815000000E+04, 2.2773537107E+00, 3.4104207361E+00, 7.4287882444E-02, 7.0454931235E-02, 6.3684424994E-01],
	[1.5820000000E+04, 2.2783350219E+00, 3.4101963332E+00, 7.4357395064E-02, 7.0518297302E-02, 6.3695846889E-01],
	[1.5825000000E+04, 2.2793164457E+00, 3.4099720159E+00, 7.4426950670E-02, 7.0581698329E-02, 6.3707263751E-01],
	[1.5830000000E+04, 2.2802979820E+00, 3.4097477842E+00, 7.4496549275E-02, 7.0645134320E-02, 6.3718675579E-01],
	[1.5835000000E+04, 2.2812796308E+00, 3.4095236381E+00, 7.4566190891E-02, 7.0708605280E-02, 6.3730082376E-01],
	[1.5840000000E+04, 2.2822613920E+00, 3.4092995775E+00, 7.4635875532E-02, 7.0772111215E-02, 6.3741484143E-01],
	[1.5845000000E+04, 2.2832432657E+00, 3.4090756023E+00, 7.4705603210E-02, 7.0835652128E-02, 6.3752880880E-01],
	[1.5850000000E+04, 2.2842252519E+00, 3.4088517125E+00, 7.4775373938E-02, 7.0899228025E-02, 6.3764272590E-01],
	[1.5855000000E+04, 2.2852073504E+00, 3.4086279080E+00, 7.4845187730E-02, 7.0962838910E-02, 6.3775659271E-01],
	[1.5860000000E+04, 2.2861895614E+00, 3.4084041887E+00, 7.4915044597E-02, 7.1026484789E-02, 6.3787040926E-01],
	[1.5865000000E+04, 2.2871718847E+00, 3.4081805547E+00, 7.4984944554E-02, 7.1090165666E-02, 6.3798417556E-01],
	[1.5870000000E+04, 2.2881543204E+00, 3.4079570057E+00, 7.5054887613E-02, 7.1153881546E-02, 6.3809789161E-01],
	[1.5875000000E+04, 2.2891368683E+00, 3.4077335419E+00, 7.5124873786E-02, 7.1217632435E-02, 6.3821155742E-01],
	[1.5880000000E+04, 2.2901195286E+00, 3.4075101631E+00, 7.5194903088E-02, 7.1281418335E-02, 6.3832517300E-01],
	[1.5885000000E+04, 2.2911023012E+00, 3.4072868692E+00, 7.5264975530E-02, 7.1345239254E-02, 6.3843873836E-01],
	[1.5890000000E+04, 2.2920851860E+00, 3.4070636602E+00, 7.5335091127E-02, 7.1409095194E-02, 6.3855225351E-01],
	[1.5895000000E+04, 2.2930681830E+00, 3.4068405361E+00, 7.5405249889E-02, 7.1472986162E-02, 6.3866571847E-01],
	[1.5900000000E+04, 2.2940512922E+00, 3.4066174967E+00, 7.5475451832E-02, 7.1536912161E-02, 6.3877913323E-01],
	[1.5905000000E+04, 2.2950345137E+00, 3.4063945421E+00, 7.5545696967E-02, 7.1600873198E-02, 6.3889249781E-01],
	[1.5910000000E+04, 2.2960178472E+00, 3.4061716721E+00, 7.5615985307E-02, 7.1664869275E-02, 6.3900581223E-01],
	[1.5915000000E+04, 2.2970012930E+00, 3.4059488868E+00, 7.5686316866E-02, 7.1728900399E-02, 6.3911907648E-01],
	[1.5920000000E+04, 2.2979848508E+00, 3.4057261860E+00, 7.5756691657E-02, 7.1792966574E-02, 6.3923229058E-01],
	[1.5925000000E+04, 2.2989685208E+00, 3.4055035696E+00, 7.5827109691E-02, 7.1857067805E-02, 6.3934545454E-01],
	[1.5930000000E+04, 2.2999523028E+00, 3.4052810377E+00, 7.5897570983E-02, 7.1921204096E-02, 6.3945856836E-01],
	[1.5935000000E+04, 2.3009361968E+00, 3.4050585902E+00, 7.5968075545E-02, 7.1985375452E-02, 6.3957163207E-01],
	[1.5940000000E+04, 2.3019202029E+00, 3.4048362270E+00, 7.6038623389E-02, 7.2049581878E-02, 6.3968464566E-01],
	[1.5945000000E+04, 2.3029043210E+00, 3.4046139480E+00, 7.6109214530E-02, 7.2113823379E-02, 6.3979760915E-01],
	[1.5950000000E+04, 2.3038885511E+00, 3.4043917533E+00, 7.6179848980E-02, 7.2178099960E-02, 6.3991052255E-01],
	[1.5955000000E+04, 2.3048728932E+00, 3.4041696426E+00, 7.6250526752E-02, 7.2242411625E-02, 6.4002338586E-01],
	[1.5960000000E+04, 2.3058573471E+00, 3.4039476161E+00, 7.6321247858E-02, 7.2306758378E-02, 6.4013619910E-01],
	[1.5965000000E+04, 2.3068419130E+00, 3.4037256735E+00, 7.6392012312E-02, 7.2371140225E-02, 6.4024896228E-01],
	[1.5970000000E+04, 2.3078265908E+00, 3.4035038150E+00, 7.6462820127E-02, 7.2435557171E-02, 6.4036167541E-01],
	[1.5975000000E+04, 2.3088113805E+00, 3.4032820403E+00, 7.6533671315E-02, 7.2500009219E-02, 6.4047433850E-01],
	[1.5980000000E+04, 2.3097962820E+00, 3.4030603495E+00, 7.6604565889E-02, 7.2564496376E-02, 6.4058695155E-01],
	[1.5985000000E+04, 2.3107812954E+00, 3.4028387425E+00, 7.6675503863E-02, 7.2629018644E-02, 6.4069951458E-01],
	[1.5990000000E+04, 2.3117664205E+00, 3.4026172192E+00, 7.6746485250E-02, 7.2693576030E-02, 6.4081202760E-01],
	[1.5995000000E+04, 2.3127516574E+00, 3.4023957795E+00, 7.6817510061E-02, 7.2758168538E-02, 6.4092449061E-01],
	[1.6000000000E+04, 2.3137370061E+00, 3.4021744235E+00, 7.6888578311E-02, 7.2822796172E-02, 6.4103690364E-01],
	[1.6005000000E+04, 2.3147224666E+00, 3.4019531511E+00, 7.6959690012E-02, 7.2887458937E-02, 6.4114926668E-01],
	[1.6010000000E+04, 2.3157080387E+00, 3.4017319621E+00, 7.7030845177E-02, 7.2952156838E-02, 6.4126157975E-01],
	[1.6015000000E+04, 2.3166937225E+00, 3.4015108566E+00, 7.7102043819E-02, 7.3016889879E-02, 6.4137384286E-01],
	[1.6020000000E+04, 2.3176795180E+00, 3.4012898345E+00, 7.7173285950E-02, 7.3081658066E-02, 6.4148605602E-01],
	[1.6025000000E+04, 2.3186654252E+00, 3.4010688957E+00, 7.7244571585E-02, 7.3146461402E-02, 6.4159821923E-01],
	[1.6030000000E+04, 2.3196514440E+00, 3.4008480401E+00, 7.7315900735E-02, 7.3211299892E-02, 6.4171033252E-01],
	[1.6035000000E+04, 2.3206375744E+00, 3.4006272678E+00, 7.7387273414E-02, 7.3276173542E-02, 6.4182239589E-01],
	[1.6040000000E+04, 2.3216238163E+00, 3.4004065787E+00, 7.7458689635E-02, 7.3341082355E-02, 6.4193440935E-01],
	[1.6045000000E+04, 2.3226124055E+00, 3.4001876236E+00, 7.7530149410E-02, 7.3406029339E-02, 6.4204637290E-01],
	[1.6050000000E+04, 2.3236043159E+00, 3.3999711192E+00, 7.7601652752E-02, 7.3471015817E-02, 6.4215828657E-01],
	[1.6055000000E+04, 2.3245963407E+00, 3.3997546960E+00, 7.7673199675E-02, 7.3536037493E-02, 6.4227015037E-01],
	[1.6060000000E+04, 2.3255884800E+00, 3.3995383540E+00, 7.7744790191E-02, 7.3601094369E-02, 6.4238196429E-01],
	[1.6065000000E+04, 2.3265807336E+00, 3.3993220930E+00, 7.7816424313E-02, 7.3666186452E-02, 6.4249372836E-01],
	[1.6070000000E+04, 2.3275731017E+00, 3.3991059132E+00, 7.7888102054E-02, 7.3731313745E-02, 6.4260544258E-01],
	[1.6075000000E+04, 2.3285655841E+00, 3.3988898143E+00, 7.7959823428E-02, 7.3796476253E-02, 6.4271710696E-01],
	[1.6080000000E+04, 2.3295581809E+00, 3.3986737963E+00, 7.8031588446E-02, 7.3861673981E-02, 6.4282872152E-01],
	[1.6085000000E+04, 2.3305508920E+00, 3.3984578592E+00, 7.8103397122E-02, 7.3926906934E-02, 6.4294028627E-01],
	[1.6090000000E+04, 2.3315437174E+00, 3.3982420030E+00, 7.8175249469E-02, 7.3992175115E-02, 6.4305180121E-01],
	[1.6095000000E+04, 2.3325366570E+00, 3.3980262275E+00, 7.8247145500E-02, 7.4057478530E-02, 6.4316326635E-01],
	[1.6100000000E+04, 2.3335297109E+00, 3.3978105327E+00, 7.8319085227E-02, 7.4122817184E-02, 6.4327468172E-01],
	[1.6105000000E+04, 2.3345228791E+00, 3.3975949186E+00, 7.8391068664E-02, 7.4188191080E-02, 6.4338604731E-01],
	[1.6110000000E+04, 2.3355161614E+00, 3.3973793852E+00, 7.8463095824E-02, 7.4253600223E-02, 6.4349736314E-01],
	[1.6115000000E+04, 2.3365095580E+00, 3.3971639322E+00, 7.8535166719E-02, 7.4319044619E-02, 6.4360862922E-01],
	[1.6120000000E+04, 2.3375030687E+00, 3.3969485598E+00, 7.8607281362E-02, 7.4384524271E-02, 6.4371984556E-01],
	[1.6125000000E+04, 2.3384966936E+00, 3.3967332678E+00, 7.8679439766E-02, 7.4450039184E-02, 6.4383101218E-01],
	[1.6130000000E+04, 2.3394904325E+00, 3.3965180561E+00, 7.8751641945E-02, 7.4515589362E-02, 6.4394212907E-01],
	[1.6135000000E+04, 2.3404842856E+00, 3.3963029248E+00, 7.8823887910E-02, 7.4581174811E-02, 6.4405319626E-01],
	[1.6140000000E+04, 2.3414782527E+00, 3.3960878738E+00, 7.8896177676E-02, 7.4646795534E-02, 6.4416421375E-01],
	[1.6145000000E+04, 2.3424723339E+00, 3.3958729030E+00, 7.8968511255E-02, 7.4712451536E-02, 6.4427518156E-01],
	[1.6150000000E+04, 2.3434665292E+00, 3.3956580124E+00, 7.9040888659E-02, 7.4778142823E-02, 6.4438609969E-01],
	[1.6155000000E+04, 2.3444608384E+00, 3.3954432019E+00, 7.9113309902E-02, 7.4843869397E-02, 6.4449696816E-01],
	[1.6160000000E+04, 2.3454552616E+00, 3.3952284714E+00, 7.9185774997E-02, 7.4909631264E-02, 6.4460778698E-01],
	[1.6165000000E+04, 2.3464497988E+00, 3.3950138209E+00, 7.9258283957E-02, 7.4975428429E-02, 6.4471855615E-01],
	[1.6170000000E+04, 2.3474444500E+00, 3.3947992504E+00, 7.9330836794E-02, 7.5041260895E-02, 6.4482927570E-01],
	[1.6175000000E+04, 2.3484392150E+00, 3.3945847598E+00, 7.9403433521E-02, 7.5107128668E-02, 6.4493994563E-01],
	[1.6180000000E+04, 2.3494340940E+00, 3.3943703490E+00, 7.9476074152E-02, 7.5173031751E-02, 6.4505056595E-01],
	[1.6185000000E+04, 2.3504290868E+00, 3.3941560180E+00, 7.9548758699E-02, 7.5238970150E-02, 6.4516113667E-01],
	[1.6190000000E+04, 2.3514241935E+00, 3.3939417668E+00, 7.9621487176E-02, 7.5304943868E-02, 6.4527165781E-01],
	[1.6195000000E+04, 2.3524194140E+00, 3.3937275952E+00, 7.9694259594E-02, 7.5370952911E-02, 6.4538212938E-01],
	[1.6200000000E+04, 2.3534147483E+00, 3.3935135032E+00, 7.9767075968E-02, 7.5436997282E-02, 6.4549255138E-01],
	[1.6205000000E+04, 2.3544101964E+00, 3.3932994908E+00, 7.9839936309E-02, 7.5503076986E-02, 6.4560292383E-01],
	[1.6210000000E+04, 2.3554057583E+00, 3.3930855579E+00, 7.9912840631E-02, 7.5569192028E-02, 6.4571324674E-01],
	[1.6215000000E+04, 2.3564014339E+00, 3.3928717045E+00, 7.9985788947E-02, 7.5635342412E-02, 6.4582352012E-01],
	[1.6220000000E+04, 2.3573972233E+00, 3.3926579304E+00, 8.0058781270E-02, 7.5701528143E-02, 6.4593374398E-01],
	[1.6225000000E+04, 2.3583931263E+00, 3.3924442358E+00, 8.0131817613E-02, 7.5767749224E-02, 6.4604391834E-01],
	[1.6230000000E+04, 2.3593891430E+00, 3.3922306204E+00, 8.0204897987E-02, 7.5834005661E-02, 6.4615404320E-01],
	[1.6235000000E+04, 2.3603852734E+00, 3.3920170843E+00, 8.0278022408E-02, 7.5900297458E-02, 6.4626411858E-01],
	[1.6240000000E+04, 2.3613815174E+00, 3.3918036273E+00, 8.0351190886E-02, 7.5966624619E-02, 6.4637414449E-01],
	[1.6245000000E+04, 2.3623778750E+00, 3.3915902495E+00, 8.0424403436E-02, 7.6032987148E-02, 6.4648412094E-01],
	[1.6250000000E+04, 2.3633743462E+00, 3.3913769508E+00, 8.0497660071E-02, 7.6099385051E-02, 6.4659404793E-01],
	[1.6255000000E+04, 2.3643709310E+00, 3.3911637311E+00, 8.0570960802E-02, 7.6165818331E-02, 6.4670392549E-01],
	[1.6260000000E+04, 2.3653676293E+00, 3.3909505904E+00, 8.0644305643E-02, 7.6232286993E-02, 6.4681375363E-01],
	[1.6265000000E+04, 2.3663644411E+00, 3.3907375286E+00, 8.0717694607E-02, 7.6298791041E-02, 6.4692353235E-01],
	[1.6270000000E+04, 2.3673613664E+00, 3.3905245456E+00, 8.0791127707E-02, 7.6365330480E-02, 6.4703326166E-01],
	[1.6275000000E+04, 2.3683584053E+00, 3.3903116415E+00, 8.0864604956E-02, 7.6431905314E-02, 6.4714294159E-01],
	[1.6280000000E+04, 2.3693555575E+00, 3.3900988161E+00, 8.0938126367E-02, 7.6498515547E-02, 6.4725257213E-01],
	[1.6285000000E+04, 2.3703528232E+00, 3.3898860695E+00, 8.1011691952E-02, 7.6565161184E-02, 6.4736215331E-01],
	[1.6290000000E+04, 2.3713502024E+00, 3.3896734015E+00, 8.1085301724E-02, 7.6631842229E-02, 6.4747168513E-01],
	[1.6295000000E+04, 2.3723476949E+00, 3.3894608121E+00, 8.1158955697E-02, 7.6698558686E-02, 6.4758116760E-01],
	[1.6300000000E+04, 2.3733453008E+00, 3.3892483013E+00, 8.1232653884E-02, 7.6765310561E-02, 6.4769060075E-01],
	[1.6305000000E+04, 2.3743471259E+00, 3.3890388634E+00, 8.1306396296E-02, 7.6832103695E-02, 6.4779998457E-01],
	[1.6310000000E+04, 2.3753503864E+00, 3.3888304648E+00, 8.1380182948E-02, 7.6898934148E-02, 6.4790931908E-01],
	[1.6315000000E+04, 2.3763537631E+00, 3.3886221429E+00, 8.1454013852E-02, 7.6965800051E-02, 6.4801860430E-01],
	[1.6320000000E+04, 2.3773572560E+00, 3.3884138976E+00, 8.1527889020E-02, 7.7032701408E-02, 6.4812784023E-01],
	[1.6325000000E+04, 2.3783608650E+00, 3.3882057288E+00, 8.1601808467E-02, 7.7099638224E-02, 6.4823702688E-01],
	[1.6330000000E+04, 2.3793645902E+00, 3.3879976366E+00, 8.1675772204E-02, 7.7166610503E-02, 6.4834616428E-01],
	[1.6335000000E+04, 2.3803684315E+00, 3.3877896209E+00, 8.1749780245E-02, 7.7233618249E-02, 6.4845525242E-01],
	[1.6340000000E+04, 2.3813723889E+00, 3.3875816817E+00, 8.1823832603E-02, 7.7300661466E-02, 6.4856429132E-01],
	[1.6345000000E+04, 2.3823764624E+00, 3.3873738188E+00, 8.1897929290E-02, 7.7367740160E-02, 6.4867328100E-01],
	[1.6350000000E+04, 2.3833806519E+00, 3.3871660322E+00, 8.1972070320E-02, 7.7434854333E-02, 6.4878222147E-01],
	[1.6355000000E+04, 2.3843849575E+00, 3.3869583219E+00, 8.2046255705E-02, 7.7502003992E-02, 6.4889111273E-01],
	[1.6360000000E+04, 2.3853893791E+00, 3.3867506878E+00, 8.2120485458E-02, 7.7569189138E-02, 6.4899995480E-01],
	[1.6365000000E+04, 2.3863939167E+00, 3.3865431299E+00, 8.2194759593E-02, 7.7636409778E-02, 6.4910874769E-01],
	[1.6370000000E+04, 2.3873985702E+00, 3.3863356481E+00, 8.2269078121E-02, 7.7703665916E-02, 6.4921749142E-01],
	[1.6375000000E+04, 2.3884033397E+00, 3.3861282423E+00, 8.2343441057E-02, 7.7770957555E-02, 6.4932618599E-01],
	[1.6380000000E+04, 2.3894082252E+00, 3.3859209126E+00, 8.2417848412E-02, 7.7838284700E-02, 6.4943483142E-01],
	[1.6385000000E+04, 2.3904132265E+00, 3.3857136589E+00, 8.2492300201E-02, 7.7905647356E-02, 6.4954342773E-01],
	[1.6390000000E+04, 2.3914183437E+00, 3.3855064811E+00, 8.2566796434E-02, 7.7973045526E-02, 6.4965197491E-01],
	[1.6395000000E+04, 2.3924235768E+00, 3.3852993791E+00, 8.2641337127E-02, 7.8040479215E-02, 6.4976047299E-01],
	[1.6400000000E+04, 2.3934289257E+00, 3.3850923530E+00, 8.2715922291E-02, 7.8107948427E-02, 6.4986892197E-01],
	[1.6405000000E+04, 2.3944343904E+00, 3.3848854026E+00, 8.2790551940E-02, 7.8175453167E-02, 6.4997732187E-01],
	[1.6410000000E+04, 2.3954399709E+00, 3.3846785279E+00, 8.2865226085E-02, 7.8242993438E-02, 6.5008567271E-01],
	[1.6415000000E+04, 2.3964456672E+00, 3.3844717289E+00, 8.2939944742E-02, 7.8310569245E-02, 6.5019397448E-01],
	[1.6420000000E+04, 2.3974514792E+00, 3.3842650055E+00, 8.3014707921E-02, 7.8378180592E-02, 6.5030222722E-01],
	[1.6425000000E+04, 2.3984574069E+00, 3.3840583577E+00, 8.3089515636E-02, 7.8445827483E-02, 6.5041043092E-01],
	[1.6430000000E+04, 2.3994634504E+00, 3.3838517853E+00, 8.3164367901E-02, 7.8513509923E-02, 6.5051858560E-01],
	[1.6435000000E+04, 2.4004696095E+00, 3.3836452885E+00, 8.3239264727E-02, 7.8581227916E-02, 6.5062669127E-01],
	[1.6440000000E+04, 2.4014758843E+00, 3.3834388670E+00, 8.3314206128E-02, 7.8648981465E-02, 6.5073474795E-01],
	[1.6445000000E+04, 2.4024822748E+00, 3.3832325209E+00, 8.3389192117E-02, 7.8716770576E-02, 6.5084275565E-01],
	[1.6450000000E+04, 2.4034887808E+00, 3.3830262501E+00, 8.3464222706E-02, 7.8784595253E-02, 6.5095071437E-01],
	[1.6455000000E+04, 2.4044954025E+00, 3.3828200546E+00, 8.3539297909E-02, 7.8852455499E-02, 6.5105862414E-01],
	[1.6460000000E+04, 2.4055021397E+00, 3.3826139342E+00, 8.3614417738E-02, 7.8920351319E-02, 6.5116648497E-01],
	[1.6465000000E+04, 2.4065089925E+00, 3.3824078890E+00, 8.3689582206E-02, 7.8988282716E-02, 6.5127429685E-01],
	[1.6470000000E+04, 2.4075159608E+00, 3.3822019190E+00, 8.3764791327E-02, 7.9056249696E-02, 6.5138205982E-01],
	[1.6475000000E+04, 2.4085230446E+00, 3.3819960240E+00, 8.3840045113E-02, 7.9124252263E-02, 6.5148977389E-01],
	[1.6480000000E+04, 2.4095302439E+00, 3.3817902040E+00, 8.3915343577E-02, 7.9192290420E-02, 6.5159743905E-01],
	[1.6485000000E+04, 2.4105375587E+00, 3.3815844589E+00, 8.3990686732E-02, 7.9260364171E-02, 6.5170505534E-01],
	[1.6490000000E+04, 2.4115449889E+00, 3.3813787888E+00, 8.4066074590E-02, 7.9328473522E-02, 6.5181262275E-01],
	[1.6495000000E+04, 2.4125525345E+00, 3.3811731935E+00, 8.4141507166E-02, 7.9396618475E-02, 6.5192014131E-01],
	[1.6500000000E+04, 2.4135601956E+00, 3.3809676730E+00, 8.4216984471E-02, 7.9464799036E-02, 6.5202761102E-01],
	[1.6505000000E+04, 2.4145679720E+00, 3.3807622272E+00, 8.4292506519E-02, 7.9533015208E-02, 6.5213503190E-01],
	[1.6510000000E+04, 2.4155758637E+00, 3.3805568562E+00, 8.4368073322E-02, 7.9601266995E-02, 6.5224240396E-01],
	[1.6515000000E+04, 2.4165838708E+00, 3.3803515599E+00, 8.4443684893E-02, 7.9669554402E-02, 6.5234972721E-01],
	[1.6520000000E+04, 2.4175919932E+00, 3.3801463381E+00, 8.4519341246E-02, 7.9737877432E-02, 6.5245700167E-01],
	[1.6525000000E+04, 2.4186002309E+00, 3.3799411909E+00, 8.4595042393E-02, 7.9806236091E-02, 6.5256422735E-01],
	[1.6530000000E+04, 2.4196085839E+00, 3.3797361182E+00, 8.4670788347E-02, 7.9874630381E-02, 6.5267140426E-01],
	[1.6535000000E+04, 2.4206170521E+00, 3.3795311200E+00, 8.4746579121E-02, 7.9943060307E-02, 6.5277853241E-01],
	[1.6540000000E+04, 2.4216256355E+00, 3.3793261961E+00, 8.4822414727E-02, 8.0011525873E-02, 6.5288561182E-01],
	[1.6545000000E+04, 2.4226343342E+00, 3.3791213467E+00, 8.4898295180E-02, 8.0080027084E-02, 6.5299264250E-01],
	[1.6550000000E+04, 2.4236431480E+00, 3.3789165715E+00, 8.4974220491E-02, 8.0148563943E-02, 6.5309962447E-01],
	[1.6555000000E+04, 2.4246520770E+00, 3.3787118706E+00, 8.5050190674E-02, 8.0217136454E-02, 6.5320655773E-01],
	[1.6560000000E+04, 2.4256611211E+00, 3.3785072439E+00, 8.5126205741E-02, 8.0285744622E-02, 6.5331344229E-01],
	[1.6565000000E+04, 2.4266717473E+00, 3.3783037484E+00, 8.5202265706E-02, 8.0354390656E-02, 6.5342027818E-01],
	[1.6570000000E+04, 2.4276864300E+00, 3.3781031645E+00, 8.5278370581E-02, 8.0423078294E-02, 6.5352706541E-01],
	[1.6575000000E+04, 2.4287012306E+00, 3.3779026530E+00, 8.5354520379E-02, 8.0491801621E-02, 6.5363380398E-01],
	[1.6580000000E+04, 2.4297161492E+00, 3.3777022140E+00, 8.5430715113E-02, 8.0560560642E-02, 6.5374049391E-01],
	[1.6585000000E+04, 2.4307311857E+00, 3.3775018472E+00, 8.5506954797E-02, 8.0629355360E-02, 6.5384713521E-01],
	[1.6590000000E+04, 2.4317463400E+00, 3.3773015527E+00, 8.5583239442E-02, 8.0698185780E-02, 6.5395372790E-01],
	[1.6595000000E+04, 2.4327616123E+00, 3.3771013305E+00, 8.5659569062E-02, 8.0767051905E-02, 6.5406027199E-01],
	[1.6600000000E+04, 2.4337770023E+00, 3.3769011804E+00, 8.5735943669E-02, 8.0835953740E-02, 6.5416676750E-01],
	[1.6605000000E+04, 2.4347925102E+00, 3.3767011025E+00, 8.5812363277E-02, 8.0904891289E-02, 6.5427321442E-01],
	[1.6610000000E+04, 2.4358081359E+00, 3.3765010966E+00, 8.5888827899E-02, 8.0973864555E-02, 6.5437961279E-01],
	[1.6615000000E+04, 2.4368238794E+00, 3.3763011628E+00, 8.5965337547E-02, 8.1042873544E-02, 6.5448596261E-01],
	[1.6620000000E+04, 2.4378397406E+00, 3.3761013010E+00, 8.6041892234E-02, 8.1111918258E-02, 6.5459226389E-01],
	[1.6625000000E+04, 2.4388557195E+00, 3.3759015111E+00, 8.6118491974E-02, 8.1180998702E-02, 6.5469851665E-01],
	[1.6630000000E+04, 2.4398718162E+00, 3.3757017931E+00, 8.6195136778E-02, 8.1250114880E-02, 6.5480472091E-01],
	[1.6635000000E+04, 2.4408880305E+00, 3.3755021470E+00, 8.6271826661E-02, 8.1319266795E-02, 6.5491087666E-01],
	[1.6640000000E+04, 2.4419043626E+00, 3.3753025727E+00, 8.6348561634E-02, 8.1388454453E-02, 6.5501698394E-01],
	[1.6645000000E+04, 2.4429208122E+00, 3.3751030701E+00, 8.6425341711E-02, 8.1457677857E-02, 6.5512304274E-01],
	[1.6650000000E+04, 2.4439373795E+00, 3.3749036392E+00, 8.6502166905E-02, 8.1526937010E-02, 6.5522905309E-01],
	[1.6655000000E+04, 2.4449540644E+00, 3.3747042800E+00, 8.6579037228E-02, 8.1596231918E-02, 6.5533501500E-01],
	[1.6660000000E+04, 2.4459708669E+00, 3.3745049924E+00, 8.6655952694E-02, 8.1665562583E-02, 6.5544092848E-01],
	[1.6665000000E+04, 2.4469877869E+00, 3.3743057764E+00, 8.6732913315E-02, 8.1734929011E-02, 6.5554679354E-01],
	[1.6670000000E+04, 2.4480048244E+00, 3.3741066319E+00, 8.6809919105E-02, 8.1804331204E-02, 6.5565261020E-01],
	[1.6675000000E+04, 2.4490219795E+00, 3.3739075588E+00, 8.6886970075E-02, 8.1873769167E-02, 6.5575837847E-01],
	[1.6680000000E+04, 2.4500392521E+00, 3.3737085572E+00, 8.6964066240E-02, 8.1943242904E-02, 6.5586409836E-01],
	[1.6685000000E+04, 2.4510566421E+00, 3.3735096270E+00, 8.7041207611E-02, 8.2012752418E-02, 6.5596976989E-01],
	[1.6690000000E+04, 2.4520741496E+00, 3.3733107680E+00, 8.7118394203E-02, 8.2082297714E-02, 6.5607539308E-01],
	[1.6695000000E+04, 2.4530917745E+00, 3.3731119804E+00, 8.7195626027E-02, 8.2151878796E-02, 6.5618096792E-01],
	[1.6700000000E+04, 2.4541095169E+00, 3.3729132640E+00, 8.7272903096E-02, 8.2221495668E-02, 6.5628649445E-01],
	[1.6705000000E+04, 2.4551273766E+00, 3.3727146188E+00, 8.7350225425E-02, 8.2291148333E-02, 6.5639197266E-01],
	[1.6710000000E+04, 2.4561453536E+00, 3.3725160447E+00, 8.7427593024E-02, 8.2360836795E-02, 6.5649740258E-01],
	[1.6715000000E+04, 2.4571634481E+00, 3.3723175418E+00, 8.7505005908E-02, 8.2430561059E-02, 6.5660278422E-01],
	[1.6720000000E+04, 2.4581816598E+00, 3.3721191098E+00, 8.7582464090E-02, 8.2500321128E-02, 6.5670811759E-01],
	[1.6725000000E+04, 2.4591999888E+00, 3.3719207489E+00, 8.7659967581E-02, 8.2570117006E-02, 6.5681340271E-01],
	[1.6730000000E+04, 2.4602184351E+00, 3.3717224589E+00, 8.7737516395E-02, 8.2639948698E-02, 6.5691863959E-01],
	[1.6735000000E+04, 2.4612369987E+00, 3.3715242399E+00, 8.7815110545E-02, 8.2709816206E-02, 6.5702382823E-01],
	[1.6740000000E+04, 2.4622556795E+00, 3.3713260917E+00, 8.7892750044E-02, 8.2779719535E-02, 6.5712896867E-01],
	[1.6745000000E+04, 2.4632744775E+00, 3.3711280143E+00, 8.7970434905E-02, 8.2849658690E-02, 6.5723406090E-01],
	[1.6750000000E+04, 2.4642933927E+00, 3.3709300077E+00, 8.8048165140E-02, 8.2919633672E-02, 6.5733910495E-01],
	[1.6755000000E+04, 2.4653124251E+00, 3.3707320718E+00, 8.8125940763E-02, 8.2989644487E-02, 6.5744410082E-01],
	[1.6760000000E+04, 2.4663315746E+00, 3.3705342066E+00, 8.8203761786E-02, 8.3059691139E-02, 6.5754904854E-01],
	[1.6765000000E+04, 2.4673508413E+00, 3.3703364120E+00, 8.8281628222E-02, 8.3129773631E-02, 6.5765394811E-01],
	[1.6770000000E+04, 2.4683702250E+00, 3.3701386880E+00, 8.8359540084E-02, 8.3199891967E-02, 6.5775879955E-01],
	[1.6775000000E+04, 2.4693897259E+00, 3.3699410345E+00, 8.8437497386E-02, 8.3270046151E-02, 6.5786360287E-01],
	[1.6780000000E+04, 2.4704093438E+00, 3.3697434515E+00, 8.8515500139E-02, 8.3340236187E-02, 6.5796835808E-01],
	[1.6785000000E+04, 2.4714290787E+00, 3.3695459390E+00, 8.8593548357E-02, 8.3410462078E-02, 6.5807306521E-01],
	[1.6790000000E+04, 2.4724489307E+00, 3.3693484969E+00, 8.8671642053E-02, 8.3480723829E-02, 6.5817772426E-01],
	[1.6795000000E+04, 2.4734688996E+00, 3.3691511251E+00, 8.8749781239E-02, 8.3551021443E-02, 6.5828233524E-01],
	[1.6800000000E+04, 2.4744889856E+00, 3.3689538236E+00, 8.8827965929E-02, 8.3621354925E-02, 6.5838689818E-01],
	[1.6805000000E+04, 2.4755091885E+00, 3.3687565924E+00, 8.8906196136E-02, 8.3691724277E-02, 6.5849141308E-01],
	[1.6810000000E+04, 2.4765295083E+00, 3.3685594314E+00, 8.8984471871E-02, 8.3762129504E-02, 6.5859587994E-01],
	[1.6815000000E+04, 2.4775499450E+00, 3.3683623406E+00, 8.9062793149E-02, 8.3832570610E-02, 6.5870029875E-01],
	[1.6820000000E+04, 2.4785704987E+00, 3.3681653199E+00, 8.9141159982E-02, 8.3903047597E-02, 6.5880466951E-01],
	[1.6825000000E+04, 2.4795911692E+00, 3.3679683693E+00, 8.9219572382E-02, 8.3973560472E-02, 6.5890899225E-01],
	[1.6830000000E+04, 2.4806119565E+00, 3.3677714887E+00, 8.9298030364E-02, 8.4044109236E-02, 6.5901326698E-01],
	[1.6835000000E+04, 2.4816379318E+00, 3.3675782861E+00, 8.9376533939E-02, 8.4114701970E-02, 6.5911749370E-01],
	[1.6840000000E+04, 2.4826643451E+00, 3.3673853784E+00, 8.9455083121E-02, 8.4185331130E-02, 6.5922167243E-01],
	[1.6845000000E+04, 2.4836908780E+00, 3.3671925391E+00, 8.9533677922E-02, 8.4255996213E-02, 6.5932580317E-01],
	[1.6850000000E+04, 2.4847175306E+00, 3.3669997681E+00, 8.9612318356E-02, 8.4326697223E-02, 6.5942988595E-01],
	[1.6855000000E+04, 2.4857443027E+00, 3.3668070653E+00, 8.9691004435E-02, 8.4397434163E-02, 6.5953392078E-01],
	[1.6860000000E+04, 2.4867711944E+00, 3.3666144307E+00, 8.9769736172E-02, 8.4468207037E-02, 6.5963790766E-01],
	[1.6865000000E+04, 2.4877982057E+00, 3.3664218642E+00, 8.9848513581E-02, 8.4539015848E-02, 6.5974184660E-01],
	[1.6870000000E+04, 2.4888253364E+00, 3.3662293658E+00, 8.9927336673E-02, 8.4609860602E-02, 6.5984573763E-01],
	[1.6875000000E+04, 2.4898525867E+00, 3.3660369354E+00, 9.0006205462E-02, 8.4680741300E-02, 6.5994958075E-01],
	[1.6880000000E+04, 2.4908799565E+00, 3.3658445731E+00, 9.0085119960E-02, 8.4751657948E-02, 6.6005337597E-01],
	[1.6885000000E+04, 2.4919074457E+00, 3.3656522787E+00, 9.0164080182E-02, 8.4822610549E-02, 6.6015712331E-01],
	[1.6890000000E+04, 2.4929350543E+00, 3.3654600522E+00, 9.0243086138E-02, 8.4893599106E-02, 6.6026082277E-01],
	[1.6895000000E+04, 2.4939627824E+00, 3.3652678936E+00, 9.0322137844E-02, 8.4964623624E-02, 6.6036447438E-01],
	[1.6900000000E+04, 2.4949906298E+00, 3.3650758029E+00, 9.0401235310E-02, 8.5035684106E-02, 6.6046807814E-01],
	[1.6905000000E+04, 2.4960185966E+00, 3.3648837799E+00, 9.0480378550E-02, 8.5106780556E-02, 6.6057163407E-01],
	[1.6910000000E+04, 2.4970466828E+00, 3.3646918246E+00, 9.0559567578E-02, 8.5177912977E-02, 6.6067514217E-01],
	[1.6915000000E+04, 2.4980748883E+00, 3.3644999371E+00, 9.0638802406E-02, 8.5249081373E-02, 6.6077860246E-01],
	[1.6920000000E+04, 2.4991032131E+00, 3.3643081171E+00, 9.0718083046E-02, 8.5320285749E-02, 6.6088201496E-01],
	[1.6925000000E+04, 2.5001316572E+00, 3.3641163648E+00, 9.0797409512E-02, 8.5391526107E-02, 6.6098537966E-01],
	[1.6930000000E+04, 2.5011602206E+00, 3.3639246801E+00, 9.0876781816E-02, 8.5462802452E-02, 6.6108869660E-01],
	[1.6935000000E+04, 2.5021889031E+00, 3.3637330629E+00, 9.0956199972E-02, 8.5534114786E-02, 6.6119196577E-01],
	[1.6940000000E+04, 2.5032177050E+00, 3.3635415132E+00, 9.1035663993E-02, 8.5605463114E-02, 6.6129518720E-01],
	[1.6945000000E+04, 2.5042466260E+00, 3.3633500309E+00, 9.1115173890E-02, 8.5676847440E-02, 6.6139836089E-01],
	[1.6950000000E+04, 2.5052756662E+00, 3.3631586159E+00, 9.1194729678E-02, 8.5748267767E-02, 6.6150148685E-01],
	[1.6955000000E+04, 2.5063048255E+00, 3.3629672684E+00, 9.1274331369E-02, 8.5819724098E-02, 6.6160456510E-01],
	[1.6960000000E+04, 2.5073341040E+00, 3.3627759881E+00, 9.1353978975E-02, 8.5891216438E-02, 6.6170759566E-01],
	[1.6965000000E+04, 2.5083635016E+00, 3.3625847751E+00, 9.1433672511E-02, 8.5962744790E-02, 6.6181057852E-01],
	[1.6970000000E+04, 2.5093930183E+00, 3.3623936293E+00, 9.1513411988E-02, 8.6034309158E-02, 6.6191351372E-01],
	[1.6975000000E+04, 2.5104226541E+00, 3.3622025506E+00, 9.1593197419E-02, 8.6105909545E-02, 6.6201640125E-01],
	[1.6980000000E+04, 2.5114524089E+00, 3.3620115392E+00, 9.1673028818E-02, 8.6177545955E-02, 6.6211924113E-01],
	[1.6985000000E+04, 2.5124822828E+00, 3.3618205947E+00, 9.1752906197E-02, 8.6249218392E-02, 6.6222203338E-01],
	[1.6990000000E+04, 2.5135122756E+00, 3.3616297174E+00, 9.1832829570E-02, 8.6320926859E-02, 6.6232477800E-01],
	[1.6995000000E+04, 2.5145423875E+00, 3.3614389070E+00, 9.1912798948E-02, 8.6392671360E-02, 6.6242747502E-01],
	[1.7000000000E+04, 2.5155726183E+00, 3.3612481636E+00, 9.1992814346E-02, 8.6464451898E-02, 6.6253012443E-01],
	[1.7005000000E+04, 2.5166029680E+00, 3.3610574871E+00, 9.2072875775E-02, 8.6536268478E-02, 6.6263272626E-01],
	[1.7010000000E+04, 2.5176334367E+00, 3.3608668774E+00, 9.2152983249E-02, 8.6608121102E-02, 6.6273528051E-01],
	[1.7015000000E+04, 2.5186640243E+00, 3.3606763346E+00, 9.2233136781E-02, 8.6680009774E-02, 6.6283778721E-01],
	[1.7020000000E+04, 2.5196947307E+00, 3.3604858586E+00, 9.2313336383E-02, 8.6751934499E-02, 6.6294024636E-01],
	[1.7025000000E+04, 2.5207255561E+00, 3.3602954493E+00, 9.2393582068E-02, 8.6823895278E-02, 6.6304265797E-01],
	[1.7030000000E+04, 2.5217565002E+00, 3.3601051067E+00, 9.2473873850E-02, 8.6895892117E-02, 6.6314502206E-01],
	[1.7035000000E+04, 2.5227875632E+00, 3.3599148307E+00, 9.2554211741E-02, 8.6967925018E-02, 6.6324733864E-01],
	[1.7040000000E+04, 2.5238187450E+00, 3.3597246214E+00, 9.2634595753E-02, 8.7039993986E-02, 6.6334960772E-01],
	[1.7045000000E+04, 2.5248500455E+00, 3.3595344786E+00, 9.2715025901E-02, 8.7112099023E-02, 6.6345182933E-01],
	[1.7050000000E+04, 2.5258814648E+00, 3.3593444024E+00, 9.2795502196E-02, 8.7184240134E-02, 6.6355400346E-01],
	[1.7055000000E+04, 2.5269130028E+00, 3.3591543926E+00, 9.2876024652E-02, 8.7256417321E-02, 6.6365613013E-01],
	[1.7060000000E+04, 2.5279446596E+00, 3.3589644493E+00, 9.2956593282E-02, 8.7328630589E-02, 6.6375820936E-01],
	[1.7065000000E+04, 2.5289764350E+00, 3.3587745724E+00, 9.3037208098E-02, 8.7400879940E-02, 6.6386024115E-01],
	[1.7070000000E+04, 2.5300083291E+00, 3.3585847618E+00, 9.3117869113E-02, 8.7473165379E-02, 6.6396222553E-01],
	[1.7075000000E+04, 2.5310403418E+00, 3.3583950176E+00, 9.3198576341E-02, 8.7545486909E-02, 6.6406416250E-01],
	[1.7080000000E+04, 2.5320724732E+00, 3.3582053396E+00, 9.3279329793E-02, 8.7617844534E-02, 6.6416605208E-01],
	[1.7085000000E+04, 2.5331047232E+00, 3.3580157278E+00, 9.3360129484E-02, 8.7690238256E-02, 6.6426789428E-01],
	[1.7090000000E+04, 2.5341370918E+00, 3.3578261822E+00, 9.3440975425E-02, 8.7762668080E-02, 6.6436968911E-01],
	[1.7095000000E+04, 2.5351695789E+00, 3.3576367028E+00, 9.3521867630E-02, 8.7835134009E-02, 6.6447143659E-01],
	[1.7100000000E+04, 2.5362021846E+00, 3.3574472895E+00, 9.3602806111E-02, 8.7907636046E-02, 6.6457313672E-01],
	[1.7105000000E+04, 2.5372389478E+00, 3.3572607811E+00, 9.3683790882E-02, 8.7980181002E-02, 6.6467478953E-01],
	[1.7110000000E+04, 2.5382771646E+00, 3.3570752739E+00, 9.3764821955E-02, 8.8052764338E-02, 6.6477639503E-01],
	[1.7115000000E+04, 2.5393155026E+00, 3.3568898311E+00, 9.3845899343E-02, 8.8125383815E-02, 6.6487795322E-01],
	[1.7120000000E+04, 2.5403539619E+00, 3.3567044528E+00, 9.3927023060E-02, 8.8198039436E-02, 6.6497946412E-01],
	[1.7125000000E+04, 2.5413925425E+00, 3.3565191388E+00, 9.4008193117E-02, 8.8270731206E-02, 6.6508092775E-01],
	[1.7130000000E+04, 2.5424312443E+00, 3.3563338892E+00, 9.4089409528E-02, 8.8343459128E-02, 6.6518234412E-01],
	[1.7135000000E+04, 2.5434700673E+00, 3.3561487038E+00, 9.4170672306E-02, 8.8416223204E-02, 6.6528371324E-01],
	[1.7140000000E+04, 2.5445090115E+00, 3.3559635827E+00, 9.4251981463E-02, 8.8489023439E-02, 6.6538503512E-01],
	[1.7145000000E+04, 2.5455480768E+00, 3.3557785258E+00, 9.4333337013E-02, 8.8561859837E-02, 6.6548630978E-01],
	[1.7150000000E+04, 2.5465872633E+00, 3.3555935330E+00, 9.4414738968E-02, 8.8634732400E-02, 6.6558753723E-01],
	[1.7155000000E+04, 2.5476265709E+00, 3.3554086044E+00, 9.4496187342E-02, 8.8707641132E-02, 6.6568871749E-01],
	[1.7160000000E+04, 2.5486659996E+00, 3.3552237398E+00, 9.4577682146E-02, 8.8780586036E-02, 6.6578985056E-01],
	[1.7165000000E+04, 2.5497055494E+00, 3.3550389393E+00, 9.4659223394E-02, 8.8853567116E-02, 6.6589093646E-01],
	[1.7170000000E+04, 2.5507452203E+00, 3.3548542027E+00, 9.4740811100E-02, 8.8926584376E-02, 6.6599197521E-01],
	[1.7175000000E+04, 2.5517850122E+00, 3.3546695302E+00, 9.4822445274E-02, 8.8999637818E-02, 6.6609296682E-01],
	[1.7180000000E+04, 2.5528249251E+00, 3.3544849215E+00, 9.4904125932E-02, 8.9072727447E-02, 6.6619391129E-01],
	[1.7185000000E+04, 2.5538649590E+00, 3.3543003767E+00, 9.4985853085E-02, 8.9145853265E-02, 6.6629480866E-01],
	[1.7190000000E+04, 2.5549051139E+00, 3.3541158958E+00, 9.5067626746E-02, 8.9219015276E-02, 6.6639565892E-01],
	[1.7195000000E+04, 2.5559453897E+00, 3.3539314786E+00, 9.5149446929E-02, 8.9292213484E-02, 6.6649646209E-01],
	[1.7200000000E+04, 2.5569857865E+00, 3.3537471252E+00, 9.5231313645E-02, 8.9365447891E-02, 6.6659721818E-01],
	[1.7205000000E+04, 2.5580263042E+00, 3.3535628355E+00, 9.5313226909E-02, 8.9438718502E-02, 6.6669792722E-01],
	[1.7210000000E+04, 2.5590669428E+00, 3.3533786095E+00, 9.5395186732E-02, 8.9512025320E-02, 6.6679858920E-01],
	[1.7215000000E+04, 2.5601077022E+00, 3.3531944471E+00, 9.5477193128E-02, 8.9585368347E-02, 6.6689920416E-01],
	[1.7220000000E+04, 2.5611485825E+00, 3.3530103483E+00, 9.5559246109E-02, 8.9658747588E-02, 6.6699977209E-01],
	[1.7225000000E+04, 2.5621895836E+00, 3.3528263131E+00, 9.5641345689E-02, 8.9732163046E-02, 6.6710029301E-01],
	[1.7230000000E+04, 2.5632307055E+00, 3.3526423413E+00, 9.5723491881E-02, 8.9805614724E-02, 6.6720076694E-01],
	[1.7235000000E+04, 2.5642719483E+00, 3.3524584331E+00, 9.5805684696E-02, 8.9879102625E-02, 6.6730119389E-01],
	[1.7240000000E+04, 2.5653133117E+00, 3.3522745882E+00, 9.5887924149E-02, 8.9952626753E-02, 6.6740157387E-01],
	[1.7245000000E+04, 2.5663547959E+00, 3.3520908068E+00, 9.5970210251E-02, 9.0026187111E-02, 6.6750190690E-01],
	[1.7250000000E+04, 2.5673964009E+00, 3.3519070887E+00, 9.6052543016E-02, 9.0099783703E-02, 6.6760219299E-01],
	[1.7255000000E+04, 2.5684381265E+00, 3.3517234339E+00, 9.6134922457E-02, 9.0173416532E-02, 6.6770243215E-01],
	[1.7260000000E+04, 2.5694799728E+00, 3.3515398424E+00, 9.6217348587E-02, 9.0247085601E-02, 6.6780262440E-01],
	[1.7265000000E+04, 2.5705219398E+00, 3.3513563141E+00, 9.6299821418E-02, 9.0320790914E-02, 6.6790276976E-01],
	[1.7270000000E+04, 2.5715640274E+00, 3.3511728490E+00, 9.6382340963E-02, 9.0394532473E-02, 6.6800286823E-01],
	[1.7275000000E+04, 2.5726062357E+00, 3.3509894470E+00, 9.6464907235E-02, 9.0468310283E-02, 6.6810291983E-01],
	[1.7280000000E+04, 2.5736485645E+00, 3.3508061082E+00, 9.6547520247E-02, 9.0542124346E-02, 6.6820292457E-01],
	[1.7285000000E+04, 2.5746910139E+00, 3.3506228324E+00, 9.6630180013E-02, 9.0615974666E-02, 6.6830288247E-01],
	[1.7290000000E+04, 2.5757335839E+00, 3.3504396196E+00, 9.6712886544E-02, 9.0689861246E-02, 6.6840279353E-01],
	[1.7295000000E+04, 2.5767762744E+00, 3.3502564699E+00, 9.6795639853E-02, 9.0763784090E-02, 6.6850265779E-01],
	[1.7300000000E+04, 2.5778190854E+00, 3.3500733831E+00, 9.6878439955E-02, 9.0837743200E-02, 6.6860247524E-01],
	[1.7305000000E+04, 2.5788620169E+00, 3.3498903591E+00, 9.6961286860E-02, 9.0911738580E-02, 6.6870224590E-01],
	[1.7310000000E+04, 2.5799050688E+00, 3.3497073981E+00, 9.7044180583E-02, 9.0985770233E-02, 6.6880196979E-01],
	[1.7315000000E+04, 2.5809482413E+00, 3.3495244999E+00, 9.7127121136E-02, 9.1059838163E-02, 6.6890164692E-01],
	[1.7320000000E+04, 2.5819915341E+00, 3.3493416645E+00, 9.7210108532E-02, 9.1133942372E-02, 6.6900127731E-01],
	[1.7325000000E+04, 2.5830349474E+00, 3.3491588918E+00, 9.7293142784E-02, 9.1208082865E-02, 6.6910086096E-01],
	[1.7330000000E+04, 2.5840784810E+00, 3.3489761818E+00, 9.7376223904E-02, 9.1282259643E-02, 6.6920039789E-01],
	[1.7335000000E+04, 2.5851221350E+00, 3.3487935346E+00, 9.7459351906E-02, 9.1356472711E-02, 6.6929988812E-01],
	[1.7340000000E+04, 2.5861659094E+00, 3.3486109499E+00, 9.7542526803E-02, 9.1430722072E-02, 6.6939933166E-01],
	[1.7345000000E+04, 2.5872098041E+00, 3.3484284278E+00, 9.7625748606E-02, 9.1505007729E-02, 6.6949872852E-01],
	[1.7350000000E+04, 2.5882538190E+00, 3.3482459683E+00, 9.7709017331E-02, 9.1579329685E-02, 6.6959807872E-01],
	[1.7355000000E+04, 2.5892979543E+00, 3.3480635713E+00, 9.7792332988E-02, 9.1653687943E-02, 6.6969738228E-01],
	[1.7360000000E+04, 2.5903422098E+00, 3.3478812368E+00, 9.7875695591E-02, 9.1728082507E-02, 6.6979663920E-01],
	[1.7365000000E+04, 2.5913865856E+00, 3.3476989647E+00, 9.7959105152E-02, 9.1802513380E-02, 6.6989584949E-01],
	[1.7370000000E+04, 2.5924310816E+00, 3.3475167550E+00, 9.8042561686E-02, 9.1876980564E-02, 6.6999501319E-01],
	[1.7375000000E+04, 2.5934756978E+00, 3.3473346076E+00, 9.8126065204E-02, 9.1951484064E-02, 6.7009413029E-01],
	[1.7380000000E+04, 2.5945241316E+00, 3.3471550897E+00, 9.8209615719E-02, 9.2026030474E-02, 6.7019320081E-01],
	[1.7385000000E+04, 2.5955743444E+00, 3.3469767830E+00, 9.8293213245E-02, 9.2100616179E-02, 6.7029222477E-01],
	[1.7390000000E+04, 2.5966246801E+00, 3.3467985370E+00, 9.8376857794E-02, 9.2175238232E-02, 6.7039120218E-01],
	[1.7395000000E+04, 2.5976751388E+00, 3.3466203517E+00, 9.8460549379E-02, 9.2249896635E-02, 6.7049013306E-01],
	[1.7400000000E+04, 2.5987257203E+00, 3.3464422272E+00, 9.8544288012E-02, 9.2324591393E-02, 6.7058901741E-01],
	[1.7405000000E+04, 2.5997764247E+00, 3.3462641633E+00, 9.8628073708E-02, 9.2399322509E-02, 6.7068785526E-01],
	[1.7410000000E+04, 2.6008272519E+00, 3.3460861600E+00, 9.8711906478E-02, 9.2474089984E-02, 6.7078664661E-01],
	[1.7415000000E+04, 2.6018782019E+00, 3.3459082172E+00, 9.8795786335E-02, 9.2548893824E-02, 6.7088539149E-01],
	[1.7420000000E+04, 2.6029292748E+00, 3.3457303351E+00, 9.8879713293E-02, 9.2623734030E-02, 6.7098408990E-01],
	[1.7425000000E+04, 2.6039804703E+00, 3.3455525134E+00, 9.8963687364E-02, 9.2698610607E-02, 6.7108274187E-01],
	[1.7430000000E+04, 2.6050317887E+00, 3.3453747522E+00, 9.9047708561E-02, 9.2773523557E-02, 6.7118134739E-01],
	[1.7435000000E+04, 2.6060832298E+00, 3.3451970514E+00, 9.9131776897E-02, 9.2848472883E-02, 6.7127990650E-01],
	[1.7440000000E+04, 2.6071347936E+00, 3.3450194110E+00, 9.9215892385E-02, 9.2923458589E-02, 6.7137841920E-01],
	[1.7445000000E+04, 2.6081864801E+00, 3.3448418310E+00, 9.9300055037E-02, 9.2998480677E-02, 6.7147688551E-01],
	[1.7450000000E+04, 2.6092382892E+00, 3.3446643112E+00, 9.9384264867E-02, 9.3073539151E-02, 6.7157530544E-01],
	[1.7455000000E+04, 2.6102902210E+00, 3.3444868518E+00, 9.9468521887E-02, 9.3148634014E-02, 6.7167367901E-01],
	[1.7460000000E+04, 2.6113422754E+00, 3.3443094526E+00, 9.9552826111E-02, 9.3223765270E-02, 6.7177200622E-01],
	[1.7465000000E+04, 2.6123944525E+00, 3.3441321135E+00, 9.9637177550E-02, 9.3298932920E-02, 6.7187028711E-01],
	[1.7470000000E+04, 2.6134467521E+00, 3.3439548347E+00, 9.9721576219E-02, 9.3374136969E-02, 6.7196852167E-01],
	[1.7475000000E+04, 2.6144991743E+00, 3.3437776160E+00, 9.9806022129E-02, 9.3449377419E-02, 6.7206670993E-01],
	[1.7480000000E+04, 2.6155517190E+00, 3.3436004573E+00, 9.9890515294E-02, 9.3524654273E-02, 6.7216485189E-01],
	[1.7485000000E+04, 2.6166043862E+00, 3.3434233587E+00, 9.9975055727E-02, 9.3599967535E-02, 6.7226294758E-01],
	[1.7490000000E+04, 2.6176571760E+00, 3.3432463201E+00, 1.0005964344E-01, 9.3675317208E-02, 6.7236099701E-01],
	[1.7495000000E+04, 2.6187100882E+00, 3.3430693415E+00, 1.0014427845E-01, 9.3750703295E-02, 6.7245900018E-01],
	[1.7500000000E+04, 2.6197631229E+00, 3.3428924229E+00, 1.0022896076E-01, 9.3826125798E-02, 6.7255695713E-01],
	[1.7505000000E+04, 2.6208162801E+00, 3.3427155641E+00, 1.0031434464E-01, 9.3902158003E-02, 6.7265486786E-01],
	[1.7510000000E+04, 2.6218695596E+00, 3.3425387652E+00, 1.0039977678E-01, 9.3978227347E-02, 6.7275273238E-01],
	[1.7515000000E+04, 2.6229229616E+00, 3.3423620261E+00, 1.0048525718E-01, 9.4054333834E-02, 6.7285055071E-01],
	[1.7520000000E+04, 2.6239764859E+00, 3.3421853468E+00, 1.0057078588E-01, 9.4130477467E-02, 6.7294832287E-01],
	[1.7525000000E+04, 2.6250301326E+00, 3.3420087273E+00, 1.0065636287E-01, 9.4206658250E-02, 6.7304604886E-01],
	[1.7530000000E+04, 2.6260839016E+00, 3.3418321674E+00, 1.0074198817E-01, 9.4282876185E-02, 6.7314372872E-01],
	[1.7535000000E+04, 2.6271377930E+00, 3.3416556673E+00, 1.0082766180E-01, 9.4359131277E-02, 6.7324136244E-01],
	[1.7540000000E+04, 2.6281918066E+00, 3.3414792268E+00, 1.0091338377E-01, 9.4435423527E-02, 6.7333895004E-01],
	[1.7545000000E+04, 2.6292459425E+00, 3.3413028459E+00, 1.0099915409E-01, 9.4511752941E-02, 6.7343649154E-01],
	[1.7550000000E+04, 2.6303002007E+00, 3.3411265245E+00, 1.0108497277E-01, 9.4588119520E-02, 6.7353398696E-01],
	[1.7555000000E+04, 2.6313545811E+00, 3.3409502627E+00, 1.0117083983E-01, 9.4664523268E-02, 6.7363143630E-01],
	[1.7560000000E+04, 2.6324090837E+00, 3.3407740603E+00, 1.0125675529E-01, 9.4740964188E-02, 6.7372883959E-01],
	[1.7565000000E+04, 2.6334637085E+00, 3.3405979175E+00, 1.0134271915E-01, 9.4817442284E-02, 6.7382619683E-01],
	[1.7570000000E+04, 2.6345184555E+00, 3.3404218340E+00, 1.0142873143E-01, 9.4893957559E-02, 6.7392350804E-01],
	[1.7575000000E+04, 2.6355733247E+00, 3.3402458099E+00, 1.0151479214E-01, 9.4970510016E-02, 6.7402077324E-01],
	[1.7580000000E+04, 2.6366283159E+00, 3.3400698452E+00, 1.0160090130E-01, 9.5047099658E-02, 6.7411799245E-01],
	[1.7585000000E+04, 2.6376834293E+00, 3.3398939397E+00, 1.0168705891E-01, 9.5123726489E-02, 6.7421516567E-01],
	[1.7590000000E+04, 2.6387386647E+00, 3.3397180936E+00, 1.0177326500E-01, 9.5200390511E-02, 6.7431229292E-01],
	[1.7595000000E+04, 2.6397940223E+00, 3.3395423066E+00, 1.0185951958E-01, 9.5277091728E-02, 6.7440937421E-01],
	[1.7600000000E+04, 2.6408495018E+00, 3.3393665789E+00, 1.0194582265E-01, 9.5353830144E-02, 6.7450640957E-01],
	[1.7605000000E+04, 2.6419051034E+00, 3.3391909103E+00, 1.0203217424E-01, 9.5430605760E-02, 6.7460339900E-01],
	[1.7610000000E+04, 2.6429608271E+00, 3.3390153009E+00, 1.0211857435E-01, 9.5507418582E-02, 6.7470034252E-01],
	[1.7615000000E+04, 2.6440166727E+00, 3.3388397505E+00, 1.0220502301E-01, 9.5584268611E-02, 6.7479724015E-01],
	[1.7620000000E+04, 2.6450726402E+00, 3.3386642592E+00, 1.0229152022E-01, 9.5661155850E-02, 6.7489409190E-01],
	[1.7625000000E+04, 2.6461287297E+00, 3.3384888268E+00, 1.0237806599E-01, 9.5738080304E-02, 6.7499089779E-01],
	[1.7630000000E+04, 2.6471849411E+00, 3.3383134535E+00, 1.0246466035E-01, 9.5815041975E-02, 6.7508765782E-01],
	[1.7635000000E+04, 2.6482412745E+00, 3.3381381391E+00, 1.0255130329E-01, 9.5892040867E-02, 6.7518437202E-01],
	[1.7640000000E+04, 2.6492977297E+00, 3.3379628836E+00, 1.0263799485E-01, 9.5969076982E-02, 6.7528104040E-01],
	[1.7645000000E+04, 2.6503543068E+00, 3.3377876870E+00, 1.0272473502E-01, 9.6046150324E-02, 6.7537766297E-01],
	[1.7650000000E+04, 2.6514110057E+00, 3.3376125492E+00, 1.0281152383E-01, 9.6123260895E-02, 6.7547423976E-01],
	[1.7655000000E+04, 2.6524678265E+00, 3.3374374702E+00, 1.0289836129E-01, 9.6200408699E-02, 6.7557077077E-01],
	[1.7660000000E+04, 2.6535287329E+00, 3.3372651689E+00, 1.0298524741E-01, 9.6277601221E-02, 6.7566725602E-01],
	[1.7665000000E+04, 2.6545911357E+00, 3.3370938664E+00, 1.0307218220E-01, 9.6354833593E-02, 6.7576369553E-01],
	[1.7670000000E+04, 2.6556536631E+00, 3.3369226211E+00, 1.0315916568E-01, 9.6432103231E-02, 6.7586008930E-01],
	[1.7675000000E+04, 2.6567163149E+00, 3.3367514331E+00, 1.0324619786E-01, 9.6509410139E-02, 6.7595643736E-01],
	[1.7680000000E+04, 2.6577790912E+00, 3.3365803022E+00, 1.0333327876E-01, 9.6586754320E-02, 6.7605273973E-01],
	[1.7685000000E+04, 2.6588419919E+00, 3.3364092285E+00, 1.0342040838E-01, 9.6664135776E-02, 6.7614899640E-01],
	[1.7690000000E+04, 2.6599050171E+00, 3.3362382120E+00, 1.0350758674E-01, 9.6741554512E-02, 6.7624520741E-01],
	[1.7695000000E+04, 2.6609681666E+00, 3.3360672525E+00, 1.0359481386E-01, 9.6819010530E-02, 6.7634137277E-01],
	[1.7700000000E+04, 2.6620314406E+00, 3.3358963501E+00, 1.0368208975E-01, 9.6896503833E-02, 6.7643749248E-01],
	[1.7705000000E+04, 2.6630948389E+00, 3.3357255048E+00, 1.0376941442E-01, 9.6974034424E-02, 6.7653356657E-01],
	[1.7710000000E+04, 2.6641583616E+00, 3.3355547164E+00, 1.0385678788E-01, 9.7051602307E-02, 6.7662959505E-01],
	[1.7715000000E+04, 2.6652220086E+00, 3.3353839849E+00, 1.0394421015E-01, 9.7129207485E-02, 6.7672557806E-01],
	[1.7720000000E+04, 2.6662857799E+00, 3.3352133104E+00, 1.0403168124E-01, 9.7206849960E-02, 6.7682152039E-01],
	[1.7725000000E+04, 2.6673496755E+00, 3.3350426928E+00, 1.0411920117E-01, 9.7284529736E-02, 6.7691742453E-01],
	[1.7730000000E+04, 2.6684136953E+00, 3.3348721320E+00, 1.0420676995E-01, 9.7362246815E-02, 6.7701329049E-01],
	[1.7735000000E+04, 2.6694778394E+00, 3.3347016280E+00, 1.0429438759E-01, 9.7440001202E-02, 6.7710911829E-01],
	[1.7740000000E+04, 2.6705421078E+00, 3.3345311808E+00, 1.0438205411E-01, 9.7517792898E-02, 6.7720490791E-01],
	[1.7745000000E+04, 2.6716065003E+00, 3.3343607903E+00, 1.0446976951E-01, 9.7595621907E-02, 6.7730065938E-01],
	[1.7750000000E+04, 2.6726710170E+00, 3.3341904566E+00, 1.0455753382E-01, 9.7673488232E-02, 6.7739637269E-01],
	[1.7755000000E+04, 2.6737356579E+00, 3.3340201795E+00, 1.0464534704E-01, 9.7751391877E-02, 6.7749204786E-01],
	[1.7760000000E+04, 2.6748004229E+00, 3.3338499591E+00, 1.0473320919E-01, 9.7829332843E-02, 6.7758768489E-01],
	[1.7765000000E+04, 2.6758653120E+00, 3.3336797952E+00, 1.0482112029E-01, 9.7907311135E-02, 6.7768328378E-01],
	[1.7770000000E+04, 2.6769303253E+00, 3.3335096879E+00, 1.0490908034E-01, 9.7985326754E-02, 6.7777884454E-01],
	[1.7775000000E+04, 2.6779954626E+00, 3.3333396372E+00, 1.0499708936E-01, 9.8063379705E-02, 6.7787436719E-01],
	[1.7780000000E+04, 2.6790607239E+00, 3.3331696430E+00, 1.0508514736E-01, 9.8141469990E-02, 6.7796985171E-01],
	[1.7785000000E+04, 2.6801261093E+00, 3.3329997052E+00, 1.0517325436E-01, 9.8219597612E-02, 6.7806529814E-01],
	[1.7790000000E+04, 2.6811916188E+00, 3.3328298238E+00, 1.0526141037E-01, 9.8297762575E-02, 6.7816070645E-01],
	[1.7795000000E+04, 2.6822572522E+00, 3.3326599989E+00, 1.0534961540E-01, 9.8375964880E-02, 6.7825607668E-01],
	[1.7800000000E+04, 2.6833230096E+00, 3.3324902303E+00, 1.0543786947E-01, 9.8454204532E-02, 6.7835140881E-01],
	[1.7805000000E+04, 2.6843888910E+00, 3.3323205180E+00, 1.0552617259E-01, 9.8532481532E-02, 6.7844670286E-01],
	[1.7810000000E+04, 2.6854548963E+00, 3.3321508620E+00, 1.0561452478E-01, 9.8610795885E-02, 6.7854195884E-01],
	[1.7815000000E+04, 2.6865210255E+00, 3.3319812623E+00, 1.0570292604E-01, 9.8689147593E-02, 6.7863717675E-01],
	[1.7820000000E+04, 2.6875872786E+00, 3.3318117188E+00, 1.0579137639E-01, 9.8767536659E-02, 6.7873235659E-01],
	[1.7825000000E+04, 2.6886536556E+00, 3.3316422315E+00, 1.0587987584E-01, 9.8845963085E-02, 6.7882749838E-01],
	[1.7830000000E+04, 2.6897201564E+00, 3.3314728004E+00, 1.0596842441E-01, 9.8924426876E-02, 6.7892260212E-01],
	[1.7835000000E+04, 2.6907867811E+00, 3.3313034253E+00, 1.0605702212E-01, 9.9002928034E-02, 6.7901766782E-01],
	[1.7840000000E+04, 2.6918535296E+00, 3.3311341064E+00, 1.0614566896E-01, 9.9081466561E-02, 6.7911269548E-01],
	[1.7845000000E+04, 2.6929204019E+00, 3.3309648435E+00, 1.0623436497E-01, 9.9160042461E-02, 6.7920768511E-01],
	[1.7850000000E+04, 2.6939873980E+00, 3.3307956366E+00, 1.0632311014E-01, 9.9238655736E-02, 6.7930263671E-01],
	[1.7855000000E+04, 2.6950545178E+00, 3.3306264857E+00, 1.0641190450E-01, 9.9317306390E-02, 6.7939755031E-01],
	[1.7860000000E+04, 2.6961217613E+00, 3.3304573907E+00, 1.0650074806E-01, 9.9395994426E-02, 6.7949242589E-01],
	[1.7865000000E+04, 2.6971891286E+00, 3.3302883517E+00, 1.0658964083E-01, 9.9474719846E-02, 6.7958726347E-01],
	[1.7870000000E+04, 2.6982566196E+00, 3.3301193685E+00, 1.0667858282E-01, 9.9553482653E-02, 6.7968206305E-01],
	[1.7875000000E+04, 2.6993242342E+00, 3.3299504412E+00, 1.0676757405E-01, 9.9632282850E-02, 6.7977682465E-01],
	[1.7880000000E+04, 2.7003919725E+00, 3.3297815697E+00, 1.0685661453E-01, 9.9711120441E-02, 6.7987154826E-01],
	[1.7885000000E+04, 2.7014598344E+00, 3.3296127540E+00, 1.0694570428E-01, 9.9789995427E-02, 6.7996623390E-01],
	[1.7890000000E+04, 2.7025278199E+00, 3.3294439940E+00, 1.0703484330E-01, 9.9868907812E-02, 6.8006088157E-01],
	[1.7895000000E+04, 2.7035959290E+00, 3.3292752897E+00, 1.0712403162E-01, 9.9947857598E-02, 6.8015549127E-01],
	[1.7900000000E+04, 2.7046641617E+00, 3.3291066411E+00, 1.0721326924E-01, 1.0002684479E-01, 6.8025006302E-01],
	[1.7905000000E+04, 2.7057325179E+00, 3.3289380481E+00, 1.0730255618E-01, 1.0010586939E-01, 6.8034459683E-01],
	[1.7910000000E+04, 2.7068009977E+00, 3.3287695108E+00, 1.0739189246E-01, 1.0018493140E-01, 6.8043909269E-01],
	[1.7915000000E+04, 2.7078696010E+00, 3.3286010290E+00, 1.0748127808E-01, 1.0026403082E-01, 6.8053355062E-01],
	[1.7920000000E+04, 2.7089383278E+00, 3.3284326028E+00, 1.0757071305E-01, 1.0034316766E-01, 6.8062797062E-01],
	[1.7925000000E+04, 2.7100071780E+00, 3.3282642320E+00, 1.0766019740E-01, 1.0042234191E-01, 6.8072235270E-01],
	[1.7930000000E+04, 2.7110761517E+00, 3.3280959168E+00, 1.0774973114E-01, 1.0050155359E-01, 6.8081669686E-01],
	[1.7935000000E+04, 2.7121452488E+00, 3.3279276570E+00, 1.0783931427E-01, 1.0058080269E-01, 6.8091100313E-01],
	[1.7940000000E+04, 2.7132144694E+00, 3.3277594525E+00, 1.0792894682E-01, 1.0066008922E-01, 6.8100527149E-01],
	[1.7945000000E+04, 2.7142885698E+00, 3.3275945273E+00, 1.0801862879E-01, 1.0073942269E-01, 6.8109950195E-01],
	[1.7950000000E+04, 2.7153633577E+00, 3.3274300366E+00, 1.0810836020E-01, 1.0081879473E-01, 6.8119369454E-01],
	[1.7955000000E+04, 2.7164382717E+00, 3.3272655999E+00, 1.0819814107E-01, 1.0089820423E-01, 6.8128784924E-01],
	[1.7960000000E+04, 2.7175133117E+00, 3.3271012171E+00, 1.0828797140E-01, 1.0097765120E-01, 6.8138196608E-01],
	[1.7965000000E+04, 2.7185884778E+00, 3.3269368882E+00, 1.0837785121E-01, 1.0105713564E-01, 6.8147604505E-01],
	[1.7970000000E+04, 2.7196637699E+00, 3.3267726131E+00, 1.0846778052E-01, 1.0113665754E-01, 6.8157008616E-01],
	[1.7975000000E+04, 2.7207391879E+00, 3.3266083918E+00, 1.0855775933E-01, 1.0121621692E-01, 6.8166408942E-01],
	[1.7980000000E+04, 2.7218147319E+00, 3.3264442243E+00, 1.0864778766E-01, 1.0129581377E-01, 6.8175805484E-01],
	[1.7985000000E+04, 2.7228904019E+00, 3.3262801106E+00, 1.0873786552E-01, 1.0137544809E-01, 6.8185198242E-01],
	[1.7990000000E+04, 2.7239661978E+00, 3.3261160505E+00, 1.0882799293E-01, 1.0145511990E-01, 6.8194587218E-01],
	[1.7995000000E+04, 2.7250421196E+00, 3.3259520442E+00, 1.0891816990E-01, 1.0153482919E-01, 6.8203972411E-01],
	[1.8000000000E+04, 2.7261181672E+00, 3.3257880914E+00, 1.0900839645E-01, 1.0161457597E-01, 6.8213353823E-01],
	[1.8005000000E+04, 2.7271943408E+00, 3.3256241923E+00, 1.0909867258E-01, 1.0169436023E-01, 6.8222731455E-01],
	[1.8010000000E+04, 2.7282706402E+00, 3.3254603468E+00, 1.0918899831E-01, 1.0177418199E-01, 6.8232105306E-01],
	[1.8015000000E+04, 2.7293470654E+00, 3.3252965549E+00, 1.0927937366E-01, 1.0185404124E-01, 6.8241475378E-01],
	[1.8020000000E+04, 2.7304236164E+00, 3.3251328164E+00, 1.0936979863E-01, 1.0193393798E-01, 6.8250841672E-01],
	[1.8025000000E+04, 2.7315002932E+00, 3.3249691314E+00, 1.0946027324E-01, 1.0201387223E-01, 6.8260204188E-01],
	[1.8030000000E+04, 2.7325770958E+00, 3.3248054999E+00, 1.0955079751E-01, 1.0209384398E-01, 6.8269562926E-01],
	[1.8035000000E+04, 2.7336540241E+00, 3.3246419218E+00, 1.0964137144E-01, 1.0217385323E-01, 6.8278917889E-01],
	[1.8040000000E+04, 2.7347310781E+00, 3.3244783971E+00, 1.0973199506E-01, 1.0225389999E-01, 6.8288269076E-01],
	[1.8045000000E+04, 2.7358082579E+00, 3.3243149258E+00, 1.0982266837E-01, 1.0233398426E-01, 6.8297616488E-01],
	[1.8050000000E+04, 2.7368855633E+00, 3.3241515078E+00, 1.0991339139E-01, 1.0241410605E-01, 6.8306960126E-01],
	[1.8055000000E+04, 2.7379629944E+00, 3.3239881430E+00, 1.1000416413E-01, 1.0249426535E-01, 6.8316299990E-01],
	[1.8060000000E+04, 2.7390405511E+00, 3.3238248315E+00, 1.1009498660E-01, 1.0257446216E-01, 6.8325636082E-01],
	[1.8065000000E+04, 2.7401182334E+00, 3.3236615733E+00, 1.1018585883E-01, 1.0265469650E-01, 6.8334968402E-01],
	[1.8070000000E+04, 2.7411960414E+00, 3.3234983683E+00, 1.1027678081E-01, 1.0273496837E-01, 6.8344296951E-01],
	[1.8075000000E+04, 2.7422739749E+00, 3.3233352164E+00, 1.1036775257E-01, 1.0281527776E-01, 6.8353621729E-01],
	[1.8080000000E+04, 2.7433520340E+00, 3.3231721176E+00, 1.1045877412E-01, 1.0289562467E-01, 6.8362942738E-01],
	[1.8085000000E+04, 2.7444302187E+00, 3.3230090720E+00, 1.1054984546E-01, 1.0297600912E-01, 6.8372259978E-01],
	[1.8090000000E+04, 2.7455085288E+00, 3.3228460794E+00, 1.1064096663E-01, 1.0305643111E-01, 6.8381573450E-01],
	[1.8095000000E+04, 2.7465869645E+00, 3.3226831398E+00, 1.1073213762E-01, 1.0313689063E-01, 6.8390883154E-01],
	[1.8100000000E+04, 2.7476655257E+00, 3.3225202533E+00, 1.1082335845E-01, 1.0321738769E-01, 6.8400189092E-01],
	[1.8105000000E+04, 2.7487442123E+00, 3.3223574197E+00, 1.1091462914E-01, 1.0329792229E-01, 6.8409491263E-01],
	[1.8110000000E+04, 2.7498230243E+00, 3.3221946391E+00, 1.1100594970E-01, 1.0337849444E-01, 6.8418789670E-01],
	[1.8115000000E+04, 2.7509019618E+00, 3.3220319113E+00, 1.1109732014E-01, 1.0345910414E-01, 6.8428084312E-01],
	[1.8120000000E+04, 2.7519810247E+00, 3.3218692365E+00, 1.1118874048E-01, 1.0353975138E-01, 6.8437375191E-01],
	[1.8125000000E+04, 2.7530602129E+00, 3.3217066145E+00, 1.1128021073E-01, 1.0362043618E-01, 6.8446662306E-01],
	[1.8130000000E+04, 2.7541395266E+00, 3.3215440453E+00, 1.1137173089E-01, 1.0370115854E-01, 6.8455945660E-01],
	[1.8135000000E+04, 2.7552189655E+00, 3.3213815289E+00, 1.1146330100E-01, 1.0378191845E-01, 6.8465225252E-01],
	[1.8140000000E+04, 2.7562985298E+00, 3.3212190652E+00, 1.1155492105E-01, 1.0386271592E-01, 6.8474501084E-01],
	[1.8145000000E+04, 2.7573782194E+00, 3.3210566543E+00, 1.1164659107E-01, 1.0394355096E-01, 6.8483773156E-01],
	[1.8150000000E+04, 2.7584580343E+00, 3.3208942960E+00, 1.1173831106E-01, 1.0402442356E-01, 6.8493041469E-01],
	[1.8155000000E+04, 2.7595379744E+00, 3.3207319904E+00, 1.1183008104E-01, 1.0410533373E-01, 6.8502306023E-01],
	[1.8160000000E+04, 2.7606180398E+00, 3.3205697374E+00, 1.1192190103E-01, 1.0418628147E-01, 6.8511566821E-01],
	[1.8165000000E+04, 2.7616982304E+00, 3.3204075370E+00, 1.1201377103E-01, 1.0426726678E-01, 6.8520823861E-01],
	[1.8170000000E+04, 2.7627785462E+00, 3.3202453892E+00, 1.1210569106E-01, 1.0434828967E-01, 6.8530077145E-01],
	[1.8175000000E+04, 2.7638589872E+00, 3.3200832939E+00, 1.1219766113E-01, 1.0442935014E-01, 6.8539326675E-01],
	[1.8180000000E+04, 2.7649395533E+00, 3.3199212511E+00, 1.1228968126E-01, 1.0451044819E-01, 6.8548572450E-01],
	[1.8185000000E+04, 2.7660202446E+00, 3.3197592608E+00, 1.1238175146E-01, 1.0459158382E-01, 6.8557814471E-01],
	[1.8190000000E+04, 2.7671010610E+00, 3.3195973229E+00, 1.1247387175E-01, 1.0467275704E-01, 6.8567052739E-01],
	[1.8195000000E+04, 2.7681820025E+00, 3.3194354374E+00, 1.1256604213E-01, 1.0475396785E-01, 6.8576287256E-01],
	[1.8200000000E+04, 2.7692630691E+00, 3.3192736042E+00, 1.1265826262E-01, 1.0483521624E-01, 6.8585518021E-01],
	[1.8205000000E+04, 2.7703442608E+00, 3.3191118234E+00, 1.1275053324E-01, 1.0491650224E-01, 6.8594745035E-01],
	[1.8210000000E+04, 2.7714255775E+00, 3.3189500950E+00, 1.1284285399E-01, 1.0499782582E-01, 6.8603968300E-01],
	[1.8215000000E+04, 2.7725070192E+00, 3.3187884188E+00, 1.1293522489E-01, 1.0507918701E-01, 6.8613187816E-01],
	[1.8220000000E+04, 2.7735885859E+00, 3.3186267948E+00, 1.1302764596E-01, 1.0516058580E-01, 6.8622403584E-01],
	[1.8225000000E+04, 2.7746702776E+00, 3.3184652231E+00, 1.1312011720E-01, 1.0524202219E-01, 6.8631615605E-01],
	[1.8230000000E+04, 2.7757527874E+00, 3.3183041679E+00, 1.1321263864E-01, 1.0532349765E-01, 6.8640823879E-01],
	[1.8235000000E+04, 2.7768400294E+00, 3.3181462498E+00, 1.1330521028E-01, 1.0540502048E-01, 6.8650028408E-01],
	[1.8240000000E+04, 2.7779273990E+00, 3.3179883826E+00, 1.1339783213E-01, 1.0548658094E-01, 6.8659229191E-01],
	[1.8245000000E+04, 2.7790148962E+00, 3.3178305661E+00, 1.1349050422E-01, 1.0556817904E-01, 6.8668426230E-01],
	[1.8250000000E+04, 2.7801025210E+00, 3.3176728004E+00, 1.1358322655E-01, 1.0564981479E-01, 6.8677619526E-01],
	[1.8255000000E+04, 2.7811902734E+00, 3.3175150854E+00, 1.1367599914E-01, 1.0573148818E-01, 6.8686809080E-01],
	[1.8260000000E+04, 2.7822781532E+00, 3.3173574211E+00, 1.1376882201E-01, 1.0581319921E-01, 6.8695994892E-01],
	[1.8265000000E+04, 2.7833661606E+00, 3.3171998075E+00, 1.1386169515E-01, 1.0589494789E-01, 6.8705176962E-01],
	[1.8270000000E+04, 2.7844542954E+00, 3.3170422444E+00, 1.1395461860E-01, 1.0597673423E-01, 6.8714355293E-01],
	[1.8275000000E+04, 2.7855425578E+00, 3.3168847320E+00, 1.1404759235E-01, 1.0605855822E-01, 6.8723529884E-01],
	[1.8280000000E+04, 2.7866309476E+00, 3.3167272701E+00, 1.1414061643E-01, 1.0614041987E-01, 6.8732700737E-01],
	[1.8285000000E+04, 2.7877194648E+00, 3.3165698588E+00, 1.1423369085E-01, 1.0622231918E-01, 6.8741867852E-01],
	[1.8290000000E+04, 2.7888081094E+00, 3.3164124980E+00, 1.1432681562E-01, 1.0630425614E-01, 6.8751031231E-01],
	[1.8295000000E+04, 2.7898968814E+00, 3.3162551876E+00, 1.1441999076E-01, 1.0638623078E-01, 6.8760190873E-01],
	[1.8300000000E+04, 2.7909857808E+00, 3.3160979277E+00, 1.1451321628E-01, 1.0646824307E-01, 6.8769346780E-01],
	[1.8305000000E+04, 2.7920748075E+00, 3.3159407182E+00, 1.1460649218E-01, 1.0655029304E-01, 6.8778498952E-01],
	[1.8310000000E+04, 2.7931639616E+00, 3.3157835591E+00, 1.1469981849E-01, 1.0663238068E-01, 6.8787647391E-01],
	[1.8315000000E+04, 2.7942532430E+00, 3.3156264504E+00, 1.1479319523E-01, 1.0671450599E-01, 6.8796792097E-01],
	[1.8320000000E+04, 2.7953426517E+00, 3.3154693920E+00, 1.1488662239E-01, 1.0679666898E-01, 6.8805933071E-01],
	[1.8325000000E+04, 2.7964321876E+00, 3.3153123838E+00, 1.1498010000E-01, 1.0687886964E-01, 6.8815070314E-01],
	[1.8330000000E+04, 2.7975218508E+00, 3.3151554260E+00, 1.1507362807E-01, 1.0696110799E-01, 6.8824203827E-01],
	[1.8335000000E+04, 2.7986116412E+00, 3.3149985184E+00, 1.1516720661E-01, 1.0704338402E-01, 6.8833333610E-01],
	[1.8340000000E+04, 2.7997015589E+00, 3.3148416609E+00, 1.1526083563E-01, 1.0712569774E-01, 6.8842459664E-01],
	[1.8345000000E+04, 2.8007916037E+00, 3.3146848537E+00, 1.1535451516E-01, 1.0720804914E-01, 6.8851581991E-01],
	[1.8350000000E+04, 2.8018817757E+00, 3.3145280966E+00, 1.1544824520E-01, 1.0729043823E-01, 6.8860700590E-01],
	[1.8355000000E+04, 2.8029720749E+00, 3.3143713896E+00, 1.1554202576E-01, 1.0737286502E-01, 6.8869815464E-01],
	[1.8360000000E+04, 2.8040625012E+00, 3.3142147328E+00, 1.1563585687E-01, 1.0745532950E-01, 6.8878926612E-01],
	[1.8365000000E+04, 2.8051530546E+00, 3.3140581259E+00, 1.1572973852E-01, 1.0753783168E-01, 6.8888034035E-01],
	[1.8370000000E+04, 2.8062437351E+00, 3.3139015691E+00, 1.1582367075E-01, 1.0762037155E-01, 6.8897137735E-01],
	[1.8375000000E+04, 2.8073345427E+00, 3.3137450623E+00, 1.1591765355E-01, 1.0770294913E-01, 6.8906237711E-01],
	[1.8380000000E+04, 2.8084254773E+00, 3.3135886055E+00, 1.1601168695E-01, 1.0778556442E-01, 6.8915333966E-01],
	[1.8385000000E+04, 2.8095165389E+00, 3.3134321986E+00, 1.1610577095E-01, 1.0786821741E-01, 6.8924426500E-01],
	[1.8390000000E+04, 2.8106077276E+00, 3.3132758416E+00, 1.1619990558E-01, 1.0795090811E-01, 6.8933515313E-01],
	[1.8395000000E+04, 2.8116990433E+00, 3.3131195345E+00, 1.1629409083E-01, 1.0803363652E-01, 6.8942600407E-01],
	[1.8400000000E+04, 2.8127904859E+00, 3.3129632773E+00, 1.1638832674E-01, 1.0811640264E-01, 6.8951681782E-01],
	[1.8405000000E+04, 2.8138820555E+00, 3.3128070699E+00, 1.1648261330E-01, 1.0819920648E-01, 6.8960759439E-01],
	[1.8410000000E+04, 2.8149737521E+00, 3.3126509122E+00, 1.1657695054E-01, 1.0828204803E-01, 6.8969833379E-01],
	[1.8415000000E+04, 2.8160655755E+00, 3.3124948044E+00, 1.1667133846E-01, 1.0836492731E-01, 6.8978903603E-01],
	[1.8420000000E+04, 2.8171575259E+00, 3.3123387462E+00, 1.1676577709E-01, 1.0844784431E-01, 6.8987970112E-01],
	[1.8425000000E+04, 2.8182496031E+00, 3.3121827378E+00, 1.1686026643E-01, 1.0853079904E-01, 6.8997032906E-01],
	[1.8430000000E+04, 2.8193418072E+00, 3.3120267790E+00, 1.1695480649E-01, 1.0861379149E-01, 6.9006091987E-01],
	[1.8435000000E+04, 2.8204341381E+00, 3.3118708699E+00, 1.1704939730E-01, 1.0869682167E-01, 6.9015147355E-01],
	[1.8440000000E+04, 2.8215265958E+00, 3.3117150104E+00, 1.1714403886E-01, 1.0877988958E-01, 6.9024199011E-01],
	[1.8445000000E+04, 2.8226191804E+00, 3.3115592005E+00, 1.1723873119E-01, 1.0886299522E-01, 6.9033246957E-01],
	[1.8450000000E+04, 2.8237118917E+00, 3.3114034402E+00, 1.1733347430E-01, 1.0894613860E-01, 6.9042291192E-01],
	[1.8455000000E+04, 2.8248047297E+00, 3.3112477294E+00, 1.1742826820E-01, 1.0902931972E-01, 6.9051331717E-01],
	[1.8460000000E+04, 2.8258976946E+00, 3.3110920680E+00, 1.1752311291E-01, 1.0911253858E-01, 6.9060368535E-01],
	[1.8465000000E+04, 2.8269907861E+00, 3.3109364562E+00, 1.1761800845E-01, 1.0919579519E-01, 6.9069401644E-01],
	[1.8470000000E+04, 2.8280840043E+00, 3.3107808938E+00, 1.1771295481E-01, 1.0927908953E-01, 6.9078431047E-01],
	[1.8475000000E+04, 2.8291773492E+00, 3.3106253808E+00, 1.1780795203E-01, 1.0936242163E-01, 6.9087456744E-01],
	[1.8480000000E+04, 2.8302708208E+00, 3.3104699172E+00, 1.1790300011E-01, 1.0944579147E-01, 6.9096478736E-01],
	[1.8485000000E+04, 2.8313644190E+00, 3.3103145029E+00, 1.1799809906E-01, 1.0952919907E-01, 6.9105497024E-01],
	[1.8490000000E+04, 2.8324581438E+00, 3.3101591380E+00, 1.1809324890E-01, 1.0961264441E-01, 6.9114511609E-01],
	[1.8495000000E+04, 2.8335519952E+00, 3.3100038224E+00, 1.1818844964E-01, 1.0969612752E-01, 6.9123522491E-01],
	[1.8500000000E+04, 2.8346459732E+00, 3.3098485560E+00, 1.1828370129E-01, 1.0977964838E-01, 6.9132529672E-01],
	[1.8505000000E+04, 2.8357400778E+00, 3.3096933389E+00, 1.1837900388E-01, 1.0986320700E-01, 6.9141533152E-01],
	[1.8510000000E+04, 2.8368343089E+00, 3.3095381709E+00, 1.1847435741E-01, 1.0994680338E-01, 6.9150532933E-01],
	[1.8515000000E+04, 2.8379286666E+00, 3.3093830522E+00, 1.1856976189E-01, 1.1003043753E-01, 6.9159529014E-01],
	[1.8520000000E+04, 2.8390231507E+00, 3.3092279826E+00, 1.1866521734E-01, 1.1011410944E-01, 6.9168521398E-01],
	[1.8525000000E+04, 2.8401200707E+00, 3.3090744909E+00, 1.1876072377E-01, 1.1019782430E-01, 6.9177510084E-01],
	[1.8530000000E+04, 2.8412200909E+00, 3.3089230148E+00, 1.1885628120E-01, 1.1028158360E-01, 6.9186495074E-01],
	[1.8535000000E+04, 2.8423202402E+00, 3.3087715865E+00, 1.1895188964E-01, 1.1036538070E-01, 6.9195476368E-01],
	[1.8540000000E+04, 2.8434205186E+00, 3.3086202059E+00, 1.1904754910E-01, 1.1044921560E-01, 6.9204453968E-01],
	[1.8545000000E+04, 2.8445209261E+00, 3.3084688731E+00, 1.1914325959E-01, 1.1053308831E-01, 6.9213427875E-01],
	[1.8550000000E+04, 2.8456214626E+00, 3.3083175880E+00, 1.1923902114E-01, 1.1061699882E-01, 6.9222398089E-01],
	[1.8555000000E+04, 2.8467221282E+00, 3.3081663506E+00, 1.1933483374E-01, 1.1070094714E-01, 6.9231364610E-01],
	[1.8560000000E+04, 2.8478229227E+00, 3.3080151609E+00, 1.1943069743E-01, 1.1078493327E-01, 6.9240327441E-01],
	[1.8565000000E+04, 2.8489238462E+00, 3.3078640187E+00, 1.1952661220E-01, 1.1086895722E-01, 6.9249286582E-01],
	[1.8570000000E+04, 2.8500248987E+00, 3.3077129242E+00, 1.1962257807E-01, 1.1095301898E-01, 6.9258242034E-01],
	[1.8575000000E+04, 2.8511260802E+00, 3.3075618773E+00, 1.1971859506E-01, 1.1103711855E-01, 6.9267193797E-01],
	[1.8580000000E+04, 2.8522273905E+00, 3.3074108779E+00, 1.1981466318E-01, 1.1112125594E-01, 6.9276141873E-01],
	[1.8585000000E+04, 2.8533288298E+00, 3.3072599260E+00, 1.1991078245E-01, 1.1120543116E-01, 6.9285086262E-01],
	[1.8590000000E+04, 2.8544303979E+00, 3.3071090216E+00, 1.2000695287E-01, 1.1128964420E-01, 6.9294026966E-01],
	[1.8595000000E+04, 2.8555320949E+00, 3.3069581647E+00, 1.2010317446E-01, 1.1137389506E-01, 6.9302963985E-01],
	[1.8600000000E+04, 2.8566339208E+00, 3.3068073553E+00, 1.2019944723E-01, 1.1145818375E-01, 6.9311897320E-01],
	[1.8605000000E+04, 2.8577358754E+00, 3.3066565932E+00, 1.2029577120E-01, 1.1154251027E-01, 6.9320826972E-01],
	[1.8610000000E+04, 2.8588379589E+00, 3.3065058785E+00, 1.2039214638E-01, 1.1162687462E-01, 6.9329752942E-01],
	[1.8615000000E+04, 2.8599401712E+00, 3.3063552112E+00, 1.2048857278E-01, 1.1171127681E-01, 6.9338675231E-01],
	[1.8620000000E+04, 2.8610425122E+00, 3.3062045912E+00, 1.2058505042E-01, 1.1179571682E-01, 6.9347593839E-01],
	[1.8625000000E+04, 2.8621449820E+00, 3.3060540185E+00, 1.2068157931E-01, 1.1188019468E-01, 6.9356508769E-01],
	[1.8630000000E+04, 2.8632475805E+00, 3.3059034930E+00, 1.2077815946E-01, 1.1196471038E-01, 6.9365420020E-01],
	[1.8635000000E+04, 2.8643503077E+00, 3.3057530148E+00, 1.2087479089E-01, 1.1204926392E-01, 6.9374327593E-01],
	[1.8640000000E+04, 2.8654531636E+00, 3.3056025839E+00, 1.2097147361E-01, 1.1213385530E-01, 6.9383231490E-01],
	[1.8645000000E+04, 2.8665561482E+00, 3.3054522001E+00, 1.2106820764E-01, 1.1221848452E-01, 6.9392131710E-01],
	[1.8650000000E+04, 2.8676592614E+00, 3.3053018634E+00, 1.2116499298E-01, 1.1230315160E-01, 6.9401028257E-01],
	[1.8655000000E+04, 2.8687625033E+00, 3.3051515740E+00, 1.2126182965E-01, 1.1238785652E-01, 6.9409921129E-01],
	[1.8660000000E+04, 2.8698658737E+00, 3.3050013316E+00, 1.2135871767E-01, 1.1247259930E-01, 6.9418810328E-01],
	[1.8665000000E+04, 2.8709693728E+00, 3.3048511363E+00, 1.2145565704E-01, 1.1255737992E-01, 6.9427695855E-01],
	[1.8670000000E+04, 2.8720730004E+00, 3.3047009880E+00, 1.2155264779E-01, 1.1264219841E-01, 6.9436577711E-01],
	[1.8675000000E+04, 2.8731767566E+00, 3.3045508868E+00, 1.2164968992E-01, 1.1272705475E-01, 6.9445455897E-01],
	[1.8680000000E+04, 2.8742806413E+00, 3.3044008326E+00, 1.2174678345E-01, 1.1281194895E-01, 6.9454330413E-01],
	[1.8685000000E+04, 2.8753846545E+00, 3.3042508253E+00, 1.2184392838E-01, 1.1289688101E-01, 6.9463201261E-01],
	[1.8690000000E+04, 2.8764887963E+00, 3.3041008650E+00, 1.2194112475E-01, 1.1298185094E-01, 6.9472068442E-01],
	[1.8695000000E+04, 2.8775930665E+00, 3.3039509516E+00, 1.2203837255E-01, 1.1306685873E-01, 6.9480931956E-01],
	[1.8700000000E+04, 2.8786974651E+00, 3.3038010851E+00, 1.2213567180E-01, 1.1315190439E-01, 6.9489791804E-01],
	[1.8705000000E+04, 2.8798019922E+00, 3.3036512654E+00, 1.2223302251E-01, 1.1323698791E-01, 6.9498647987E-01],
	[1.8710000000E+04, 2.8809066477E+00, 3.3035014926E+00, 1.2233047105E-01, 1.1332214908E-01, 6.9507500507E-01],
	[1.8715000000E+04, 2.8820114316E+00, 3.3033517666E+00, 1.2242806115E-01, 1.1340742539E-01, 6.9516349364E-01],
	[1.8720000000E+04, 2.8831163439E+00, 3.3032020874E+00, 1.2252570292E-01, 1.1349273972E-01, 6.9525194559E-01],
	[1.8725000000E+04, 2.8842213845E+00, 3.3030524549E+00, 1.2262339640E-01, 1.1357809205E-01, 6.9534036092E-01],
	[1.8730000000E+04, 2.8853265535E+00, 3.3029028691E+00, 1.2272114158E-01, 1.1366348239E-01, 6.9542873966E-01],
	[1.8735000000E+04, 2.8864318508E+00, 3.3027533301E+00, 1.2281893848E-01, 1.1374891074E-01, 6.9551708180E-01],
	[1.8740000000E+04, 2.8875372764E+00, 3.3026038377E+00, 1.2291678712E-01, 1.1383437710E-01, 6.9560538737E-01],
	[1.8745000000E+04, 2.8886428302E+00, 3.3024543919E+00, 1.2301468751E-01, 1.1391988148E-01, 6.9569365635E-01],
	[1.8750000000E+04, 2.8897485124E+00, 3.3023049928E+00, 1.2311263966E-01, 1.1400542387E-01, 6.9578188878E-01],
	[1.8755000000E+04, 2.8908543227E+00, 3.3021556403E+00, 1.2321064359E-01, 1.1409100428E-01, 6.9587008465E-01],
	[1.8760000000E+04, 2.8919602613E+00, 3.3020063343E+00, 1.2330869930E-01, 1.1417662272E-01, 6.9595824397E-01],
	[1.8765000000E+04, 2.8930663281E+00, 3.3018570749E+00, 1.2340680682E-01, 1.1426227917E-01, 6.9604636676E-01],
	[1.8770000000E+04, 2.8941725231E+00, 3.3017078620E+00, 1.2350496616E-01, 1.1434797365E-01, 6.9613445303E-01],
	[1.8775000000E+04, 2.8952788463E+00, 3.3015586955E+00, 1.2360317732E-01, 1.1443370616E-01, 6.9622250277E-01],
	[1.8780000000E+04, 2.8963852976E+00, 3.3014095755E+00, 1.2370144033E-01, 1.1451947669E-01, 6.9631051601E-01],
	[1.8785000000E+04, 2.8974918770E+00, 3.3012605020E+00, 1.2379975519E-01, 1.1460528525E-01, 6.9639849275E-01],
	[1.8790000000E+04, 2.8985985845E+00, 3.3011114748E+00, 1.2389812193E-01, 1.1469113185E-01, 6.9648643300E-01],
	[1.8795000000E+04, 2.8997054201E+00, 3.3009624941E+00, 1.2399654055E-01, 1.1477701647E-01, 6.9657433677E-01],
	[1.8800000000E+04, 2.9008123838E+00, 3.3008135596E+00, 1.2409501106E-01, 1.1486293914E-01, 6.9666220407E-01],
	[1.8805000000E+04, 2.9019194756E+00, 3.3006646715E+00, 1.2419353349E-01, 1.1494889984E-01, 6.9675003491E-01],
	[1.8810000000E+04, 2.9030266953E+00, 3.3005158297E+00, 1.2429210784E-01, 1.1503489858E-01, 6.9683782930E-01],
	[1.8815000000E+04, 2.9041340431E+00, 3.3003670342E+00, 1.2439073413E-01, 1.1512093536E-01, 6.9692558725E-01],
	[1.8820000000E+04, 2.9052415189E+00, 3.3002182849E+00, 1.2448941237E-01, 1.1520701018E-01, 6.9701330876E-01],
	[1.8825000000E+04, 2.9063533276E+00, 3.3000723324E+00, 1.2458814258E-01, 1.1529313303E-01, 6.9710099386E-01],
	[1.8830000000E+04, 2.9074663254E+00, 3.2999271176E+00, 1.2468692476E-01, 1.1537929645E-01, 6.9718864254E-01],
	[1.8835000000E+04, 2.9085794538E+00, 3.2997819477E+00, 1.2478575893E-01, 1.1546549795E-01, 6.9727625481E-01],
	[1.8840000000E+04, 2.9096927127E+00, 3.2996368227E+00, 1.2488464511E-01, 1.1555173753E-01, 6.9736383069E-01],
	[1.8845000000E+04, 2.9108061021E+00, 3.2994917427E+00, 1.2498358331E-01, 1.1563801519E-01, 6.9745137019E-01],
	[1.8850000000E+04, 2.9119196220E+00, 3.2993467074E+00, 1.2508257354E-01, 1.1572433093E-01, 6.9753887331E-01],
	[1.8855000000E+04, 2.9130332724E+00, 3.2992017171E+00, 1.2518161582E-01, 1.1581068476E-01, 6.9762634007E-01],
	[1.8860000000E+04, 2.9141470533E+00, 3.2990567715E+00, 1.2528071016E-01, 1.1589707667E-01, 6.9771377047E-01],
	[1.8865000000E+04, 2.9152609646E+00, 3.2989118707E+00, 1.2537985657E-01, 1.1598350666E-01, 6.9780116453E-01],
	[1.8870000000E+04, 2.9163750063E+00, 3.2987670147E+00, 1.2547905506E-01, 1.1606997475E-01, 6.9788852224E-01],
	[1.8875000000E+04, 2.9174891784E+00, 3.2986222035E+00, 1.2557830566E-01, 1.1615648092E-01, 6.9797584364E-01],
	[1.8880000000E+04, 2.9186034809E+00, 3.2984774369E+00, 1.2567760837E-01, 1.1624302519E-01, 6.9806312871E-01],
	[1.8885000000E+04, 2.9197179138E+00, 3.2983327150E+00, 1.2577696320E-01, 1.1632960755E-01, 6.9815037748E-01],
	[1.8890000000E+04, 2.9208324770E+00, 3.2981880378E+00, 1.2587637018E-01, 1.1641622801E-01, 6.9823758994E-01],
	[1.8895000000E+04, 2.9219471705E+00, 3.2980434052E+00, 1.2597582931E-01, 1.1650288657E-01, 6.9832476612E-01],
	[1.8900000000E+04, 2.9230619944E+00, 3.2978988172E+00, 1.2607534060E-01, 1.1658958322E-01, 6.9841190602E-01],
	[1.8905000000E+04, 2.9241769485E+00, 3.2977542738E+00, 1.2617490408E-01, 1.1667631798E-01, 6.9849900965E-01],
	[1.8910000000E+04, 2.9252920329E+00, 3.2976097750E+00, 1.2627451975E-01, 1.1676309084E-01, 6.9858607703E-01],
	[1.8915000000E+04, 2.9264072476E+00, 3.2974653207E+00, 1.2637418763E-01, 1.1684990181E-01, 6.9867310815E-01],
	[1.8920000000E+04, 2.9275225925E+00, 3.2973209109E+00, 1.2647390773E-01, 1.1693675088E-01, 6.9876010303E-01],
	[1.8925000000E+04, 2.9286380676E+00, 3.2971765455E+00, 1.2657368007E-01, 1.1702363805E-01, 6.9884706168E-01],
	[1.8930000000E+04, 2.9297536728E+00, 3.2970322247E+00, 1.2667350465E-01, 1.1711056334E-01, 6.9893398411E-01],
	[1.8935000000E+04, 2.9308694083E+00, 3.2968879482E+00, 1.2677338149E-01, 1.1719752674E-01, 6.9902087033E-01],
	[1.8940000000E+04, 2.9319852739E+00, 3.2967437162E+00, 1.2687331061E-01, 1.1728452826E-01, 6.9910772035E-01],
	[1.8945000000E+04, 2.9331012697E+00, 3.2965995285E+00, 1.2697329202E-01, 1.1737156788E-01, 6.9919453418E-01],
	[1.8950000000E+04, 2.9342173955E+00, 3.2964553852E+00, 1.2707332574E-01, 1.1745864563E-01, 6.9928131183E-01],
	[1.8955000000E+04, 2.9353336515E+00, 3.2963112863E+00, 1.2717341176E-01, 1.1754576149E-01, 6.9936805330E-01],
	[1.8960000000E+04, 2.9364500375E+00, 3.2961672316E+00, 1.2727355012E-01, 1.1763291548E-01, 6.9945475861E-01],
	[1.8965000000E+04, 2.9375665536E+00, 3.2960232212E+00, 1.2737374082E-01, 1.1772010758E-01, 6.9954142777E-01],
	[1.8970000000E+04, 2.9386831997E+00, 3.2958792550E+00, 1.2747398387E-01, 1.1780733781E-01, 6.9962806079E-01],
	[1.8975000000E+04, 2.9397999758E+00, 3.2957353331E+00, 1.2757427930E-01, 1.1789460616E-01, 6.9971465767E-01],
	[1.8980000000E+04, 2.9409168820E+00, 3.2955914554E+00, 1.2767462711E-01, 1.1798191264E-01, 6.9980121844E-01],
	[1.8985000000E+04, 2.9420339181E+00, 3.2954476218E+00, 1.2777502731E-01, 1.1806925725E-01, 6.9988774309E-01],
	[1.8990000000E+04, 2.9431510842E+00, 3.2953038325E+00, 1.2787547992E-01, 1.1815663998E-01, 6.9997423163E-01],
	[1.8995000000E+04, 2.9442683802E+00, 3.2951600872E+00, 1.2797598496E-01, 1.1824406085E-01, 7.0006068408E-01],
	[1.9000000000E+04, 2.9453858061E+00, 3.2950163860E+00, 1.2807654244E-01, 1.1833151985E-01, 7.0014710045E-01],
	[1.9005000000E+04, 2.9465033620E+00, 3.2948727289E+00, 1.2817715237E-01, 1.1841901699E-01, 7.0023348075E-01],
	[1.9010000000E+04, 2.9476210477E+00, 3.2947291159E+00, 1.2827781476E-01, 1.1850655226E-01, 7.0031982498E-01],
	[1.9015000000E+04, 2.9487388633E+00, 3.2945855469E+00, 1.2837852962E-01, 1.1859412567E-01, 7.0040613316E-01],
	[1.9020000000E+04, 2.9498568088E+00, 3.2944420219E+00, 1.2847929698E-01, 1.1868173723E-01, 7.0049240530E-01],
	[1.9025000000E+04, 2.9509748840E+00, 3.2942985408E+00, 1.2858011685E-01, 1.1876938692E-01, 7.0057864140E-01],
	[1.9030000000E+04, 2.9520930891E+00, 3.2941551037E+00, 1.2868098923E-01, 1.1885707475E-01, 7.0066484148E-01],
	[1.9035000000E+04, 2.9532114240E+00, 3.2940117106E+00, 1.2878191414E-01, 1.1894480073E-01, 7.0075100554E-01],
	[1.9040000000E+04, 2.9543298886E+00, 3.2938683613E+00, 1.2888289160E-01, 1.1903256485E-01, 7.0083713360E-01],
	[1.9045000000E+04, 2.9554484830E+00, 3.2937250559E+00, 1.2898392162E-01, 1.1912036712E-01, 7.0092322566E-01],
	[1.9050000000E+04, 2.9565672072E+00, 3.2935817944E+00, 1.2908500421E-01, 1.1920820754E-01, 7.0100928175E-01],
	[1.9055000000E+04, 2.9576860610E+00, 3.2934385767E+00, 1.2918613939E-01, 1.1929608612E-01, 7.0109530185E-01],
	[1.9060000000E+04, 2.9588050445E+00, 3.2932954027E+00, 1.2928732716E-01, 1.1938400284E-01, 7.0118128600E-01],
	[1.9065000000E+04, 2.9599241577E+00, 3.2931522726E+00, 1.2938856755E-01, 1.1947195771E-01, 7.0126723419E-01],
	[1.9070000000E+04, 2.9610434006E+00, 3.2930091862E+00, 1.2948986056E-01, 1.1955995075E-01, 7.0135314643E-01],
	[1.9075000000E+04, 2.9621627731E+00, 3.2928661436E+00, 1.2959120621E-01, 1.1964798193E-01, 7.0143902274E-01],
	[1.9080000000E+04, 2.9632822752E+00, 3.2927231446E+00, 1.2969260452E-01, 1.1973605128E-01, 7.0152486313E-01],
	[1.9085000000E+04, 2.9644019070E+00, 3.2925801893E+00, 1.2979405549E-01, 1.1982415879E-01, 7.0161066761E-01],
	[1.9090000000E+04, 2.9655216683E+00, 3.2924372777E+00, 1.2989555914E-01, 1.1991230445E-01, 7.0169643618E-01],
	[1.9095000000E+04, 2.9666415591E+00, 3.2922944097E+00, 1.2999711549E-01, 1.2000048828E-01, 7.0178216885E-01],
	[1.9100000000E+04, 2.9677615795E+00, 3.2921515853E+00, 1.3009872454E-01, 1.2008871028E-01, 7.0186786564E-01],
	[1.9105000000E+04, 2.9688817295E+00, 3.2920088044E+00, 1.3020038631E-01, 1.2017697044E-01, 7.0195352656E-01],
	[1.9110000000E+04, 2.9700020089E+00, 3.2918660672E+00, 1.3030210082E-01, 1.2026526876E-01, 7.0203915162E-01],
	[1.9115000000E+04, 2.9711224178E+00, 3.2917233734E+00, 1.3040386808E-01, 1.2035360526E-01, 7.0212474082E-01],
	[1.9120000000E+04, 2.9722429562E+00, 3.2915807232E+00, 1.3050568809E-01, 1.2044197992E-01, 7.0221029418E-01],
	[1.9125000000E+04, 2.9733646749E+00, 3.2914387959E+00, 1.3060756088E-01, 1.2053039540E-01, 7.0229581170E-01],
	[1.9130000000E+04, 2.9744907187E+00, 3.2912996236E+00, 1.3070948646E-01, 1.2061885959E-01, 7.0238129341E-01],
	[1.9135000000E+04, 2.9756168946E+00, 3.2911604936E+00, 1.3081146484E-01, 1.2070736199E-01, 7.0246673929E-01],
	[1.9140000000E+04, 2.9767432025E+00, 3.2910214058E+00, 1.3091349604E-01, 1.2079590259E-01, 7.0255214938E-01],
	[1.9145000000E+04, 2.9778696424E+00, 3.2908823602E+00, 1.3101558006E-01, 1.2088448140E-01, 7.0263752368E-01],
	[1.9150000000E+04, 2.9789962142E+00, 3.2907433568E+00, 1.3111771693E-01, 1.2097309842E-01, 7.0272286219E-01],
	[1.9155000000E+04, 2.9801229179E+00, 3.2906043956E+00, 1.3121990665E-01, 1.2106175365E-01, 7.0280816493E-01],
	[1.9160000000E+04, 2.9812497535E+00, 3.2904654764E+00, 1.3132214924E-01, 1.2115044708E-01, 7.0289343190E-01],
	[1.9165000000E+04, 2.9823767210E+00, 3.2903265994E+00, 1.3142444471E-01, 1.2123917873E-01, 7.0297866313E-01],
	[1.9170000000E+04, 2.9835038204E+00, 3.2901877645E+00, 1.3152679308E-01, 1.2132794860E-01, 7.0306385861E-01],
	[1.9175000000E+04, 2.9846310516E+00, 3.2900489717E+00, 1.3162919436E-01, 1.2141675667E-01, 7.0314901836E-01],
	[1.9180000000E+04, 2.9857584147E+00, 3.2899102208E+00, 1.3173164856E-01, 1.2150560297E-01, 7.0323414239E-01],
	[1.9185000000E+04, 2.9868859096E+00, 3.2897715120E+00, 1.3183415569E-01, 1.2159448748E-01, 7.0331923071E-01],
	[1.9190000000E+04, 2.9880135362E+00, 3.2896328452E+00, 1.3193671578E-01, 1.2168341022E-01, 7.0340428333E-01],
	[1.9195000000E+04, 2.9891412947E+00, 3.2894942204E+00, 1.3203932883E-01, 1.2177237117E-01, 7.0348930026E-01],
	[1.9200000000E+04, 2.9902691849E+00, 3.2893556375E+00, 1.3214199486E-01, 1.2186137034E-01, 7.0357428151E-01],
	[1.9205000000E+04, 2.9913972068E+00, 3.2892170965E+00, 1.3224471388E-01, 1.2195040774E-01, 7.0365922709E-01],
	[1.9210000000E+04, 2.9925253605E+00, 3.2890785974E+00, 1.3234748590E-01, 1.2203948337E-01, 7.0374413701E-01],
	[1.9215000000E+04, 2.9936536458E+00, 3.2889401402E+00, 1.3245031094E-01, 1.2212859722E-01, 7.0382901128E-01],
	[1.9220000000E+04, 2.9947820629E+00, 3.2888017249E+00, 1.3255318901E-01, 1.2221774930E-01, 7.0391384991E-01],
	[1.9225000000E+04, 2.9959106116E+00, 3.2886633513E+00, 1.3265612012E-01, 1.2230693960E-01, 7.0399865291E-01],
	[1.9230000000E+04, 2.9970392919E+00, 3.2885250196E+00, 1.3275910429E-01, 1.2239616814E-01, 7.0408342029E-01],
	[1.9235000000E+04, 2.9981681038E+00, 3.2883867296E+00, 1.3286214154E-01, 1.2248543491E-01, 7.0416815207E-01],
	[1.9240000000E+04, 2.9992970474E+00, 3.2882484815E+00, 1.3296523186E-01, 1.2257473991E-01, 7.0425284824E-01],
	[1.9245000000E+04, 3.0004261225E+00, 3.2881102750E+00, 1.3306837529E-01, 1.2266408315E-01, 7.0433750883E-01],
	[1.9250000000E+04, 3.0015553293E+00, 3.2879721102E+00, 1.3317157183E-01, 1.2275346462E-01, 7.0442213385E-01],
	[1.9255000000E+04, 3.0026846675E+00, 3.2878339872E+00, 1.3327482149E-01, 1.2284288433E-01, 7.0450672329E-01],
	[1.9260000000E+04, 3.0038141373E+00, 3.2876959058E+00, 1.3337812429E-01, 1.2293234228E-01, 7.0459127718E-01],
	[1.9265000000E+04, 3.0049437386E+00, 3.2875578660E+00, 1.3348148025E-01, 1.2302183847E-01, 7.0467579552E-01],
	[1.9270000000E+04, 3.0060734714E+00, 3.2874198678E+00, 1.3358488937E-01, 1.2311137290E-01, 7.0476027833E-01],
	[1.9275000000E+04, 3.0072033357E+00, 3.2872819113E+00, 1.3368835167E-01, 1.2320094557E-01, 7.0484472562E-01],
	[1.9280000000E+04, 3.0083333314E+00, 3.2871439963E+00, 1.3379186716E-01, 1.2329055648E-01, 7.0492913738E-01],
	[1.9285000000E+04, 3.0094634585E+00, 3.2870061229E+00, 1.3389543586E-01, 1.2338020565E-01, 7.0501351365E-01],
	[1.9290000000E+04, 3.0105937171E+00, 3.2868682909E+00, 1.3399905777E-01, 1.2346989305E-01, 7.0509785442E-01],
	[1.9295000000E+04, 3.0117241071E+00, 3.2867305005E+00, 1.3410273293E-01, 1.2355961871E-01, 7.0518215970E-01],
	[1.9300000000E+04, 3.0128546284E+00, 3.2865927516E+00, 1.3420646132E-01, 1.2364938261E-01, 7.0526642952E-01],
	[1.9305000000E+04, 3.0139852811E+00, 3.2864550441E+00, 1.3431024298E-01, 1.2373918476E-01, 7.0535066387E-01],
	[1.9310000000E+04, 3.0151160652E+00, 3.2863173780E+00, 1.3441407791E-01, 1.2382902517E-01, 7.0543486276E-01],
	[1.9315000000E+04, 3.0162469805E+00, 3.2861797534E+00, 1.3451796613E-01, 1.2391890382E-01, 7.0551902622E-01],
	[1.9320000000E+04, 3.0173780272E+00, 3.2860421701E+00, 1.3462190765E-01, 1.2400882073E-01, 7.0560315424E-01],
	[1.9325000000E+04, 3.0185092051E+00, 3.2859046282E+00, 1.3472590248E-01, 1.2409877590E-01, 7.0568724685E-01],
	[1.9330000000E+04, 3.0196405144E+00, 3.2857671276E+00, 1.3482995065E-01, 1.2418876932E-01, 7.0577130404E-01],
	[1.9335000000E+04, 3.0207719548E+00, 3.2856296683E+00, 1.3493405215E-01, 1.2427880100E-01, 7.0585532584E-01],
	[1.9340000000E+04, 3.0219035265E+00, 3.2854922503E+00, 1.3503820700E-01, 1.2436887094E-01, 7.0593931224E-01],
	[1.9345000000E+04, 3.0230352294E+00, 3.2853548736E+00, 1.3514241523E-01, 1.2445897914E-01, 7.0602326327E-01],
	[1.9350000000E+04, 3.0241670635E+00, 3.2852175382E+00, 1.3524667684E-01, 1.2454912559E-01, 7.0610717893E-01],
	[1.9355000000E+04, 3.0252990288E+00, 3.2850802439E+00, 1.3535099184E-01, 1.2463931032E-01, 7.0619105923E-01],
	[1.9360000000E+04, 3.0264311252E+00, 3.2849429909E+00, 1.3545536025E-01, 1.2472953330E-01, 7.0627490418E-01],
	[1.9365000000E+04, 3.0275633528E+00, 3.2848057790E+00, 1.3555978208E-01, 1.2481979455E-01, 7.0635871380E-01],
	[1.9370000000E+04, 3.0286957114E+00, 3.2846686083E+00, 1.3566425735E-01, 1.2491009407E-01, 7.0644248809E-01],
	[1.9375000000E+04, 3.0298282012E+00, 3.2845314787E+00, 1.3576878606E-01, 1.2500043185E-01, 7.0652622706E-01],
	[1.9380000000E+04, 3.0309608221E+00, 3.2843943902E+00, 1.3587336824E-01, 1.2509080790E-01, 7.0660993073E-01],
	[1.9385000000E+04, 3.0320935740E+00, 3.2842573428E+00, 1.3597800390E-01, 1.2518122222E-01, 7.0669359911E-01],
	[1.9390000000E+04, 3.0332264569E+00, 3.2841203365E+00, 1.3608269304E-01, 1.2527167481E-01, 7.0677723220E-01],
	[1.9395000000E+04, 3.0343594709E+00, 3.2839833712E+00, 1.3618743569E-01, 1.2536216567E-01, 7.0686083002E-01],
	[1.9400000000E+04, 3.0354926159E+00, 3.2838464469E+00, 1.3629223185E-01, 1.2545269481E-01, 7.0694439258E-01],
	[1.9405000000E+04, 3.0366258918E+00, 3.2837095636E+00, 1.3639708155E-01, 1.2554326221E-01, 7.0702791988E-01],
	[1.9410000000E+04, 3.0377592988E+00, 3.2835727213E+00, 1.3650198478E-01, 1.2563386790E-01, 7.0711141194E-01],
	[1.9415000000E+04, 3.0388928366E+00, 3.2834359199E+00, 1.3660694158E-01, 1.2572451186E-01, 7.0719486877E-01],
	[1.9420000000E+04, 3.0400265054E+00, 3.2832991595E+00, 1.3671195194E-01, 1.2581519410E-01, 7.0727829037E-01],
	[1.9425000000E+04, 3.0411603052E+00, 3.2831624399E+00, 1.3681701589E-01, 1.2590591461E-01, 7.0736167675E-01],
	[1.9430000000E+04, 3.0422942358E+00, 3.2830257613E+00, 1.3692213344E-01, 1.2599667341E-01, 7.0744502791E-01],
	[1.9435000000E+04, 3.0434315713E+00, 3.2828912156E+00, 1.3702730459E-01, 1.2608747919E-01, 7.0752834388E-01],
	[1.9440000000E+04, 3.0445709935E+00, 3.2827579583E+00, 1.3713252937E-01, 1.2617832847E-01, 7.0761162464E-01],
	[1.9445000000E+04, 3.0457105491E+00, 3.2826247408E+00, 1.3723780779E-01, 1.2626921607E-01, 7.0769487022E-01],
	[1.9450000000E+04, 3.0468502381E+00, 3.2824915628E+00, 1.3734313986E-01, 1.2636014198E-01, 7.0777808062E-01],
	[1.9455000000E+04, 3.0479900604E+00, 3.2823584245E+00, 1.3744852560E-01, 1.2645110620E-01, 7.0786125584E-01],
	[1.9460000000E+04, 3.0491300161E+00, 3.2822253259E+00, 1.3755396501E-01, 1.2654210874E-01, 7.0794439590E-01],
	[1.9465000000E+04, 3.0502701051E+00, 3.2820922668E+00, 1.3765945811E-01, 1.2663314960E-01, 7.0802750081E-01],
	[1.9470000000E+04, 3.0514103274E+00, 3.2819592472E+00, 1.3776500492E-01, 1.2672422878E-01, 7.0811057056E-01],
	[1.9475000000E+04, 3.0525506830E+00, 3.2818262673E+00, 1.3787060545E-01, 1.2681534627E-01, 7.0819360517E-01],
	[1.9480000000E+04, 3.0536911718E+00, 3.2816933268E+00, 1.3797625971E-01, 1.2690650209E-01, 7.0827660465E-01],
	[1.9485000000E+04, 3.0548317939E+00, 3.2815604258E+00, 1.3808196772E-01, 1.2699769623E-01, 7.0835956901E-01],
	[1.9490000000E+04, 3.0559725493E+00, 3.2814275644E+00, 1.3818772948E-01, 1.2708892869E-01, 7.0844249825E-01],
	[1.9495000000E+04, 3.0571134378E+00, 3.2812947423E+00, 1.3829354502E-01, 1.2718019948E-01, 7.0852539238E-01],
	[1.9500000000E+04, 3.0582544595E+00, 3.2811619598E+00, 1.3839941435E-01, 1.2727150859E-01, 7.0860825141E-01],
	[1.9505000000E+04, 3.0593956144E+00, 3.2810292166E+00, 1.3850533747E-01, 1.2736285602E-01, 7.0869107534E-01],
	[1.9510000000E+04, 3.0605369025E+00, 3.2808965128E+00, 1.3861131441E-01, 1.2745424178E-01, 7.0877386420E-01],
	[1.9515000000E+04, 3.0616783237E+00, 3.2807638484E+00, 1.3871734517E-01, 1.2754566587E-01, 7.0885661797E-01],
	[1.9520000000E+04, 3.0628198780E+00, 3.2806312233E+00, 1.3882342977E-01, 1.2763712829E-01, 7.0893933668E-01],
	[1.9525000000E+04, 3.0639615654E+00, 3.2804986376E+00, 1.3892956823E-01, 1.2772862904E-01, 7.0902202032E-01],
	[1.9530000000E+04, 3.0651033859E+00, 3.2803660912E+00, 1.3903576056E-01, 1.2782016812E-01, 7.0910466892E-01],
	[1.9535000000E+04, 3.0662453395E+00, 3.2802335840E+00, 1.3914200676E-01, 1.2791174554E-01, 7.0918728247E-01],
	[1.9540000000E+04, 3.0673874261E+00, 3.2801011161E+00, 1.3924830686E-01, 1.2800336128E-01, 7.0926986098E-01],
	[1.9545000000E+04, 3.0685296457E+00, 3.2799686875E+00, 1.3935466087E-01, 1.2809501536E-01, 7.0935240447E-01],
	[1.9550000000E+04, 3.0696719983E+00, 3.2798362981E+00, 1.3946106879E-01, 1.2818670777E-01, 7.0943491293E-01],
	[1.9555000000E+04, 3.0708144840E+00, 3.2797039478E+00, 1.3956753066E-01, 1.2827843852E-01, 7.0951738639E-01],
	[1.9560000000E+04, 3.0719571026E+00, 3.2795716368E+00, 1.3967404647E-01, 1.2837020761E-01, 7.0959982484E-01],
	[1.9565000000E+04, 3.0730998541E+00, 3.2794393649E+00, 1.3978061624E-01, 1.2846201503E-01, 7.0968222830E-01],
	[1.9570000000E+04, 3.0742427386E+00, 3.2793071321E+00, 1.3988723998E-01, 1.2855386080E-01, 7.0976459677E-01],
	[1.9575000000E+04, 3.0753857559E+00, 3.2791749384E+00, 1.3999391772E-01, 1.2864574490E-01, 7.0984693026E-01],
	[1.9580000000E+04, 3.0765289062E+00, 3.2790427839E+00, 1.4010064945E-01, 1.2873766734E-01, 7.0992922878E-01],
	[1.9585000000E+04, 3.0776721894E+00, 3.2789106683E+00, 1.4020743520E-01, 1.2882962813E-01, 7.1001149234E-01],
	[1.9590000000E+04, 3.0788156054E+00, 3.2787785919E+00, 1.4031427499E-01, 1.2892162726E-01, 7.1009372095E-01],
	[1.9595000000E+04, 3.0799591542E+00, 3.2786465544E+00, 1.4042116881E-01, 1.2901366473E-01, 7.1017591461E-01],
	[1.9600000000E+04, 3.0811028359E+00, 3.2785145560E+00, 1.4052811669E-01, 1.2910574054E-01, 7.1025807333E-01],
	[1.9605000000E+04, 3.0822466504E+00, 3.2783825966E+00, 1.4063511863E-01, 1.2919785470E-01, 7.1034019713E-01],
	[1.9610000000E+04, 3.0833905977E+00, 3.2782506761E+00, 1.4074217467E-01, 1.2929000721E-01, 7.1042228601E-01],
	[1.9615000000E+04, 3.0845346777E+00, 3.2781187945E+00, 1.4084928479E-01, 1.2938219806E-01, 7.1050433997E-01],
	[1.9620000000E+04, 3.0856788905E+00, 3.2779869519E+00, 1.4095644903E-01, 1.2947442727E-01, 7.1058635903E-01],
	[1.9625000000E+04, 3.0868232360E+00, 3.2778551481E+00, 1.4106366739E-01, 1.2956669482E-01, 7.1066834319E-01],
	[1.9630000000E+04, 3.0879677142E+00, 3.2777233833E+00, 1.4117093989E-01, 1.2965900072E-01, 7.1075029247E-01],
	[1.9635000000E+04, 3.0891123251E+00, 3.2775916572E+00, 1.4127826653E-01, 1.2975134497E-01, 7.1083220687E-01],
	[1.9640000000E+04, 3.0902570687E+00, 3.2774599700E+00, 1.4138564734E-01, 1.2984372757E-01, 7.1091408640E-01],
	[1.9645000000E+04, 3.0914019449E+00, 3.2773283217E+00, 1.4149308233E-01, 1.2993614852E-01, 7.1099593107E-01],
	[1.9650000000E+04, 3.0925469538E+00, 3.2771967121E+00, 1.4160057151E-01, 1.3002860783E-01, 7.1107774088E-01],
	[1.9655000000E+04, 3.0936920953E+00, 3.2770651413E+00, 1.4170811489E-01, 1.3012110549E-01, 7.1115951586E-01],
	[1.9660000000E+04, 3.0948373693E+00, 3.2769336092E+00, 1.4181571249E-01, 1.3021364151E-01, 7.1124125599E-01],
	[1.9665000000E+04, 3.0959827760E+00, 3.2768021158E+00, 1.4192336432E-01, 1.3030621588E-01, 7.1132296130E-01],
	[1.9670000000E+04, 3.0971283153E+00, 3.2766706612E+00, 1.4203107040E-01, 1.3039882861E-01, 7.1140463179E-01],
	[1.9675000000E+04, 3.0982739870E+00, 3.2765392452E+00, 1.4213883073E-01, 1.3049147969E-01, 7.1148626747E-01],
	[1.9680000000E+04, 3.0994197913E+00, 3.2764078679E+00, 1.4224664534E-01, 1.3058416914E-01, 7.1156786834E-01],
	[1.9685000000E+04, 3.1005657282E+00, 3.2762765293E+00, 1.4235451423E-01, 1.3067689694E-01, 7.1164943443E-01],
	[1.9690000000E+04, 3.1017117975E+00, 3.2761452292E+00, 1.4246243742E-01, 1.3076966310E-01, 7.1173096572E-01],
	[1.9695000000E+04, 3.1028579992E+00, 3.2760139678E+00, 1.4257041492E-01, 1.3086246762E-01, 7.1181246225E-01],
	[1.9700000000E+04, 3.1040043335E+00, 3.2758827449E+00, 1.4267844674E-01, 1.3095531051E-01, 7.1189392400E-01],
	[1.9705000000E+04, 3.1051508001E+00, 3.2757515606E+00, 1.4278653291E-01, 1.3104819175E-01, 7.1197535100E-01],
	[1.9710000000E+04, 3.1062973992E+00, 3.2756204148E+00, 1.4289467342E-01, 1.3114111136E-01, 7.1205674324E-01],
	[1.9715000000E+04, 3.1074441307E+00, 3.2754893075E+00, 1.4300286831E-01, 1.3123406933E-01, 7.1213810075E-01],
	[1.9720000000E+04, 3.1085909946E+00, 3.2753582388E+00, 1.4311111757E-01, 1.3132706567E-01, 7.1221942352E-01],
	[1.9725000000E+04, 3.1097379908E+00, 3.2752272084E+00, 1.4321942123E-01, 1.3142010037E-01, 7.1230071156E-01],
	[1.9730000000E+04, 3.1108851193E+00, 3.2750962166E+00, 1.4332777929E-01, 1.3151317344E-01, 7.1238196489E-01],
	[1.9735000000E+04, 3.1120323802E+00, 3.2749652632E+00, 1.4343619177E-01, 1.3160628487E-01, 7.1246318352E-01],
	[1.9740000000E+04, 3.1131797734E+00, 3.2748343481E+00, 1.4354465868E-01, 1.3169943467E-01, 7.1254436744E-01],
	[1.9745000000E+04, 3.1143276164E+00, 3.2747036721E+00, 1.4365318005E-01, 1.3179262374E-01, 7.1262551668E-01],
	[1.9750000000E+04, 3.1154804849E+00, 3.2745761243E+00, 1.4376175587E-01, 1.3188586495E-01, 7.1270663123E-01],
	[1.9755000000E+04, 3.1166334881E+00, 3.2744486137E+00, 1.4387038616E-01, 1.3197914457E-01, 7.1278771112E-01],
	[1.9760000000E+04, 3.1177866261E+00, 3.2743211404E+00, 1.4397907095E-01, 1.3207246258E-01, 7.1286875634E-01],
	[1.9765000000E+04, 3.1189398989E+00, 3.2741937043E+00, 1.4408781023E-01, 1.3216581900E-01, 7.1294976690E-01],
	[1.9770000000E+04, 3.1200933064E+00, 3.2740663054E+00, 1.4419660403E-01, 1.3225921382E-01, 7.1303074282E-01],
	[1.9775000000E+04, 3.1212468485E+00, 3.2739389437E+00, 1.4430545235E-01, 1.3235264705E-01, 7.1311168410E-01],
	[1.9780000000E+04, 3.1224005254E+00, 3.2738116191E+00, 1.4441435522E-01, 1.3244611868E-01, 7.1319259076E-01],
	[1.9785000000E+04, 3.1235543370E+00, 3.2736843316E+00, 1.4452331264E-01, 1.3253962871E-01, 7.1327346279E-01],
	[1.9790000000E+04, 3.1247082831E+00, 3.2735570813E+00, 1.4463232463E-01, 1.3263317715E-01, 7.1335430022E-01],
	[1.9795000000E+04, 3.1258623640E+00, 3.2734298680E+00, 1.4474139120E-01, 1.3272676400E-01, 7.1343510304E-01],
	[1.9800000000E+04, 3.1270165794E+00, 3.2733026918E+00, 1.4485051236E-01, 1.3282038926E-01, 7.1351587127E-01],
	[1.9805000000E+04, 3.1281709295E+00, 3.2731755527E+00, 1.4495968814E-01, 1.3291405292E-01, 7.1359660492E-01],
	[1.9810000000E+04, 3.1293254141E+00, 3.2730484506E+00, 1.4506891853E-01, 1.3300775499E-01, 7.1367730399E-01],
	[1.9815000000E+04, 3.1304800333E+00, 3.2729213855E+00, 1.4517820356E-01, 1.3310149547E-01, 7.1375796849E-01],
	[1.9820000000E+04, 3.1316347870E+00, 3.2727943573E+00, 1.4528754324E-01, 1.3319527436E-01, 7.1383859844E-01],
	[1.9825000000E+04, 3.1327896752E+00, 3.2726673662E+00, 1.4539693759E-01, 1.3328909166E-01, 7.1391919384E-01],
	[1.9830000000E+04, 3.1339446980E+00, 3.2725404120E+00, 1.4550638661E-01, 1.3338294737E-01, 7.1399975470E-01],
	[1.9835000000E+04, 3.1350998552E+00, 3.2724134948E+00, 1.4561589031E-01, 1.3347684150E-01, 7.1408028102E-01],
	[1.9840000000E+04, 3.1362551470E+00, 3.2722866144E+00, 1.4572544872E-01, 1.3357077403E-01, 7.1416077283E-01],
	[1.9845000000E+04, 3.1374105731E+00, 3.2721597709E+00, 1.4583506185E-01, 1.3366474498E-01, 7.1424123013E-01],
	[1.9850000000E+04, 3.1385661337E+00, 3.2720329643E+00, 1.4594472971E-01, 1.3375875435E-01, 7.1432165292E-01],
	[1.9855000000E+04, 3.1397218287E+00, 3.2719061946E+00, 1.4605445231E-01, 1.3385280212E-01, 7.1440204121E-01],
	[1.9860000000E+04, 3.1408776581E+00, 3.2717794617E+00, 1.4616422967E-01, 1.3394688832E-01, 7.1448239503E-01],
	[1.9865000000E+04, 3.1420336219E+00, 3.2716527656E+00, 1.4627406179E-01, 1.3404101293E-01, 7.1456271436E-01],
	[1.9870000000E+04, 3.1431897201E+00, 3.2715261063E+00, 1.4638394870E-01, 1.3413517595E-01, 7.1464299923E-01],
	[1.9875000000E+04, 3.1443459526E+00, 3.2713994837E+00, 1.4649389041E-01, 1.3422937739E-01, 7.1472324964E-01],
	[1.9880000000E+04, 3.1455023194E+00, 3.2712728979E+00, 1.4660388693E-01, 1.3432361725E-01, 7.1480346560E-01],
	[1.9885000000E+04, 3.1466588205E+00, 3.2711463489E+00, 1.4671393827E-01, 1.3441789553E-01, 7.1488364711E-01],
	[1.9890000000E+04, 3.1478154559E+00, 3.2710198365E+00, 1.4682404446E-01, 1.3451221222E-01, 7.1496379420E-01],
	[1.9895000000E+04, 3.1489722256E+00, 3.2708933608E+00, 1.4693420549E-01, 1.3460656734E-01, 7.1504390687E-01],
	[1.9900000000E+04, 3.1501291295E+00, 3.2707669218E+00, 1.4704442138E-01, 1.3470096087E-01, 7.1512398512E-01],
	[1.9905000000E+04, 3.1512861677E+00, 3.2706405195E+00, 1.4715469216E-01, 1.3479539283E-01, 7.1520402897E-01],
	[1.9910000000E+04, 3.1524433400E+00, 3.2705141538E+00, 1.4726501782E-01, 1.3488986320E-01, 7.1528403842E-01],
	[1.9915000000E+04, 3.1536006466E+00, 3.2703878247E+00, 1.4737539839E-01, 1.3498437200E-01, 7.1536401349E-01],
	[1.9920000000E+04, 3.1547580874E+00, 3.2702615322E+00, 1.4748583388E-01, 1.3507891922E-01, 7.1544395418E-01],
	[1.9925000000E+04, 3.1559156623E+00, 3.2701352762E+00, 1.4759632430E-01, 1.3517350486E-01, 7.1552386050E-01],
	[1.9930000000E+04, 3.1570733713E+00, 3.2700090568E+00, 1.4770686967E-01, 1.3526812892E-01, 7.1560373247E-01],
	[1.9935000000E+04, 3.1582312145E+00, 3.2698828740E+00, 1.4781747000E-01, 1.3536279141E-01, 7.1568357009E-01],
	[1.9940000000E+04, 3.1593891918E+00, 3.2697567276E+00, 1.4792812529E-01, 1.3545749232E-01, 7.1576337336E-01],
	[1.9945000000E+04, 3.1605473032E+00, 3.2696306178E+00, 1.4803883558E-01, 1.3555223166E-01, 7.1584314231E-01],
	[1.9950000000E+04, 3.1617055486E+00, 3.2695045444E+00, 1.4814960086E-01, 1.3564700942E-01, 7.1592287693E-01],
	[1.9955000000E+04, 3.1628639281E+00, 3.2693785075E+00, 1.4826042116E-01, 1.3574182560E-01, 7.1600257725E-01],
	[1.9960000000E+04, 3.1640224416E+00, 3.2692525070E+00, 1.4837129648E-01, 1.3583668022E-01, 7.1608224325E-01],
	[1.9965000000E+04, 3.1651810892E+00, 3.2691265429E+00, 1.4848222684E-01, 1.3593157325E-01, 7.1616187497E-01],
	[1.9970000000E+04, 3.1663398707E+00, 3.2690006152E+00, 1.4859321226E-01, 1.3602650472E-01, 7.1624147240E-01],
	[1.9975000000E+04, 3.1674987862E+00, 3.2688747239E+00, 1.4870425274E-01, 1.3612147461E-01, 7.1632103556E-01],
	[1.9980000000E+04, 3.1686578357E+00, 3.2687488689E+00, 1.4881534830E-01, 1.3621648293E-01, 7.1640056445E-01],
	[1.9985000000E+04, 3.1698170191E+00, 3.2686230503E+00, 1.4892649896E-01, 1.3631152968E-01, 7.1648005908E-01],
	[1.9990000000E+04, 3.1709763365E+00, 3.2684972680E+00, 1.4903770472E-01, 1.3640661486E-01, 7.1655951947E-01],
	[1.9995000000E+04, 3.1721357877E+00, 3.2683715220E+00, 1.4914896560E-01, 1.3650173847E-01, 7.1663894562E-01],
	[2.0000000000E+04, 3.1732953729E+00, 3.2682458122E+00, 1.4926028162E-01, 1.3659690050E-01, 7.1671833754E-01],
	[2.0005000000E+04, 3.1744550919E+00, 3.2681201388E+00, 1.4937238085E-01, 1.3669271067E-01, 7.1679769524E-01],
	[2.0010000000E+04, 3.1756149448E+00, 3.2679945015E+00, 1.4948453615E-01, 1.3678855992E-01, 7.1687701873E-01],
	[2.0015000000E+04, 3.1767749315E+00, 3.2678689005E+00, 1.4959674755E-01, 1.3688444824E-01, 7.1695630802E-01],
	[2.0020000000E+04, 3.1779350520E+00, 3.2677433357E+00, 1.4970901506E-01, 1.3698037565E-01, 7.1703556312E-01],
	[2.0025000000E+04, 3.1790953063E+00, 3.2676178070E+00, 1.4982133870E-01, 1.3707634215E-01, 7.1711478404E-01],
	[2.0030000000E+04, 3.1802556944E+00, 3.2674923145E+00, 1.4993371847E-01, 1.3717234772E-01, 7.1719397079E-01],
	[2.0035000000E+04, 3.1814162163E+00, 3.2673668582E+00, 1.5004615439E-01, 1.3726839238E-01, 7.1727312337E-01],
	[2.0040000000E+04, 3.1825768719E+00, 3.2672414379E+00, 1.5015864648E-01, 1.3736447612E-01, 7.1735224180E-01],
	[2.0045000000E+04, 3.1837376613E+00, 3.2671160538E+00, 1.5027119474E-01, 1.3746059895E-01, 7.1743132608E-01],
	[2.0050000000E+04, 3.1848985843E+00, 3.2669907058E+00, 1.5038379920E-01, 1.3755676086E-01, 7.1751037623E-01],
	[2.0055000000E+04, 3.1860596410E+00, 3.2668653938E+00, 1.5049645987E-01, 1.3765296186E-01, 7.1758939226E-01],
	[2.0060000000E+04, 3.1872208315E+00, 3.2667401178E+00, 1.5060917675E-01, 1.3774920194E-01, 7.1766837417E-01],
	[2.0065000000E+04, 3.1883847055E+00, 3.2666164602E+00, 1.5072194988E-01, 1.3784548869E-01, 7.1774732197E-01],
	[2.0070000000E+04, 3.1895513860E+00, 3.2664944951E+00, 1.5083477925E-01, 1.3794182250E-01, 7.1782623568E-01],
	[2.0075000000E+04, 3.1907182026E+00, 3.2663725649E+00, 1.5094766488E-01, 1.3803819543E-01, 7.1790511530E-01],
	[2.0080000000E+04, 3.1918851554E+00, 3.2662506697E+00, 1.5106060680E-01, 1.3813460748E-01, 7.1798396084E-01],
	[2.0085000000E+04, 3.1930522442E+00, 3.2661288093E+00, 1.5117360500E-01, 1.3823105865E-01, 7.1806277232E-01],
	[2.0090000000E+04, 3.1942194692E+00, 3.2660069838E+00, 1.5128665951E-01, 1.3832754894E-01, 7.1814154973E-01],
	[2.0095000000E+04, 3.1953868302E+00, 3.2658851932E+00, 1.5139977033E-01, 1.3842407835E-01, 7.1822029310E-01],
	[2.0100000000E+04, 3.1965543272E+00, 3.2657634375E+00, 1.5151293750E-01, 1.3852064689E-01, 7.1829900242E-01],
	[2.0105000000E+04, 3.1977219602E+00, 3.2656417165E+00, 1.5162616100E-01, 1.3861725455E-01, 7.1837767772E-01],
	[2.0110000000E+04, 3.1988897293E+00, 3.2655200304E+00, 1.5173944087E-01, 1.3871390133E-01, 7.1845631900E-01],
	[2.0115000000E+04, 3.2000576343E+00, 3.2653983790E+00, 1.5185277711E-01, 1.3881058724E-01, 7.1853492626E-01],
	[2.0120000000E+04, 3.2012256754E+00, 3.2652767624E+00, 1.5196616975E-01, 1.3890731227E-01, 7.1861349953E-01],
	[2.0125000000E+04, 3.2023938523E+00, 3.2651551805E+00, 1.5207961878E-01, 1.3900407643E-01, 7.1869203880E-01],
	[2.0130000000E+04, 3.2035621652E+00, 3.2650336334E+00, 1.5219312423E-01, 1.3910087971E-01, 7.1877054409E-01],
	[2.0135000000E+04, 3.2047306140E+00, 3.2649121210E+00, 1.5230668612E-01, 1.3919772212E-01, 7.1884901541E-01],
	[2.0140000000E+04, 3.2058991987E+00, 3.2647906433E+00, 1.5242030445E-01, 1.3929460365E-01, 7.1892745277E-01],
	[2.0145000000E+04, 3.2070679193E+00, 3.2646692002E+00, 1.5253397923E-01, 1.3939152432E-01, 7.1900585617E-01],
	[2.0150000000E+04, 3.2082367758E+00, 3.2645477918E+00, 1.5264771049E-01, 1.3948848411E-01, 7.1908422563E-01],
	[2.0155000000E+04, 3.2094057681E+00, 3.2644264181E+00, 1.5276149824E-01, 1.3958548302E-01, 7.1916256116E-01],
	[2.0160000000E+04, 3.2105748962E+00, 3.2643050789E+00, 1.5287534249E-01, 1.3968252107E-01, 7.1924086276E-01],
	[2.0165000000E+04, 3.2117441601E+00, 3.2641837744E+00, 1.5298924325E-01, 1.3977959824E-01, 7.1931913045E-01],
	[2.0170000000E+04, 3.2129135598E+00, 3.2640625044E+00, 1.5310320054E-01, 1.3987671454E-01, 7.1939736423E-01],
	[2.0175000000E+04, 3.2140830953E+00, 3.2639412690E+00, 1.5321721438E-01, 1.3997386998E-01, 7.1947556412E-01],
	[2.0180000000E+04, 3.2152527665E+00, 3.2638200681E+00, 1.5333128477E-01, 1.4007106454E-01, 7.1955373012E-01],
	[2.0185000000E+04, 3.2164225735E+00, 3.2636989018E+00, 1.5344541173E-01, 1.4016829823E-01, 7.1963186225E-01],
	[2.0190000000E+04, 3.2175925162E+00, 3.2635777700E+00, 1.5355959528E-01, 1.4026557105E-01, 7.1970996051E-01],
	[2.0195000000E+04, 3.2187625946E+00, 3.2634566726E+00, 1.5367383542E-01, 1.4036288300E-01, 7.1978802492E-01],
	[2.0200000000E+04, 3.2199328087E+00, 3.2633356098E+00, 1.5378813218E-01, 1.4046023409E-01, 7.1986605548E-01],
	[2.0205000000E+04, 3.2211031584E+00, 3.2632145813E+00, 1.5390248557E-01, 1.4055762430E-01, 7.1994405220E-01],
	[2.0210000000E+04, 3.2222736438E+00, 3.2630935873E+00, 1.5401689559E-01, 1.4065505365E-01, 7.2002201510E-01],
	[2.0215000000E+04, 3.2234442648E+00, 3.2629726278E+00, 1.5413136227E-01, 1.4075252213E-01, 7.2009994418E-01],
	[2.0220000000E+04, 3.2246150214E+00, 3.2628517026E+00, 1.5424588562E-01, 1.4085002974E-01, 7.2017783945E-01],
	[2.0225000000E+04, 3.2257859136E+00, 3.2627308118E+00, 1.5436046565E-01, 1.4094757649E-01, 7.2025570093E-01],
	[2.0230000000E+04, 3.2269569414E+00, 3.2626099554E+00, 1.5447510238E-01, 1.4104516237E-01, 7.2033352862E-01],
	[2.0235000000E+04, 3.2281281048E+00, 3.2624891333E+00, 1.5458979582E-01, 1.4114278738E-01, 7.2041132253E-01],
	[2.0240000000E+04, 3.2292994037E+00, 3.2623683455E+00, 1.5470454599E-01, 1.4124045152E-01, 7.2048908268E-01],
	[2.0245000000E+04, 3.2304708381E+00, 3.2622475921E+00, 1.5481935289E-01, 1.4133815480E-01, 7.2056680906E-01],
	[2.0250000000E+04, 3.2316424080E+00, 3.2621268729E+00, 1.5493421655E-01, 1.4143589722E-01, 7.2064450170E-01],
	[2.0255000000E+04, 3.2328141134E+00, 3.2620061880E+00, 1.5504913697E-01, 1.4153367876E-01, 7.2072216060E-01],
	[2.0260000000E+04, 3.2339859542E+00, 3.2618855373E+00, 1.5516411417E-01, 1.4163149945E-01, 7.2079978577E-01],
	[2.0265000000E+04, 3.2351579306E+00, 3.2617649209E+00, 1.5527914817E-01, 1.4172935927E-01, 7.2087737722E-01],
	[2.0270000000E+04, 3.2363300423E+00, 3.2616443387E+00, 1.5539423898E-01, 1.4182725822E-01, 7.2095493497E-01],
	[2.0275000000E+04, 3.2375022895E+00, 3.2615237907E+00, 1.5550938660E-01, 1.4192519631E-01, 7.2103245902E-01],
	[2.0280000000E+04, 3.2386746720E+00, 3.2614032768E+00, 1.5562459107E-01, 1.4202317354E-01, 7.2110994937E-01],
	[2.0285000000E+04, 3.2398471900E+00, 3.2612827972E+00, 1.5573985239E-01, 1.4212118990E-01, 7.2118740605E-01],
	[2.0290000000E+04, 3.2410198433E+00, 3.2611623516E+00, 1.5585517057E-01, 1.4221924540E-01, 7.2126482906E-01],
	[2.0295000000E+04, 3.2421926319E+00, 3.2610419402E+00, 1.5597054563E-01, 1.4231734003E-01, 7.2134221842E-01],
	[2.0300000000E+04, 3.2433655559E+00, 3.2609215629E+00, 1.5608597758E-01, 1.4241547380E-01, 7.2141957412E-01],
	[2.0305000000E+04, 3.2445386152E+00, 3.2608012197E+00, 1.5620146643E-01, 1.4251364671E-01, 7.2149689619E-01],
	[2.0310000000E+04, 3.2457118098E+00, 3.2606809106E+00, 1.5631701221E-01, 1.4261185876E-01, 7.2157418462E-01],
	[2.0315000000E+04, 3.2468851396E+00, 3.2605606355E+00, 1.5643261493E-01, 1.4271010994E-01, 7.2165143944E-01],
	[2.0320000000E+04, 3.2480586047E+00, 3.2604403944E+00, 1.5654827459E-01, 1.4280840026E-01, 7.2172866065E-01],
	[2.0325000000E+04, 3.2492322051E+00, 3.2603201874E+00, 1.5666399121E-01, 1.4290672972E-01, 7.2180584826E-01],
	[2.0330000000E+04, 3.2504059406E+00, 3.2602000143E+00, 1.5677976481E-01, 1.4300509832E-01, 7.2188300228E-01],
	[2.0335000000E+04, 3.2515798114E+00, 3.2600798752E+00, 1.5689559540E-01, 1.4310350606E-01, 7.2196012272E-01],
	[2.0340000000E+04, 3.2527538173E+00, 3.2599597701E+00, 1.5701148300E-01, 1.4320195293E-01, 7.2203720959E-01],
	[2.0345000000E+04, 3.2539279584E+00, 3.2598396990E+00, 1.5712742761E-01, 1.4330043895E-01, 7.2211426291E-01],
	[2.0350000000E+04, 3.2551022347E+00, 3.2597196618E+00, 1.5724342926E-01, 1.4339896410E-01, 7.2219128267E-01],
	[2.0355000000E+04, 3.2562766461E+00, 3.2595996584E+00, 1.5735948795E-01, 1.4349752839E-01, 7.2226826890E-01],
	[2.0360000000E+04, 3.2574511926E+00, 3.2594796890E+00, 1.5747560370E-01, 1.4359613182E-01, 7.2234522160E-01],
	[2.0365000000E+04, 3.2586258742E+00, 3.2593597534E+00, 1.5759177653E-01, 1.4369477439E-01, 7.2242214078E-01],
	[2.0370000000E+04, 3.2598006909E+00, 3.2592398517E+00, 1.5770800645E-01, 1.4379345609E-01, 7.2249902645E-01],
	[2.0375000000E+04, 3.2609756426E+00, 3.2591199838E+00, 1.5782429346E-01, 1.4389217694E-01, 7.2257587863E-01],
	[2.0380000000E+04, 3.2621507294E+00, 3.2590001498E+00, 1.5794063760E-01, 1.4399093693E-01, 7.2265269731E-01],
	[2.0385000000E+04, 3.2633259512E+00, 3.2588803495E+00, 1.5805703886E-01, 1.4408973606E-01, 7.2272948252E-01],
	[2.0390000000E+04, 3.2645060364E+00, 3.2587634248E+00, 1.5817349727E-01, 1.4418858911E-01, 7.2280623426E-01],
	[2.0395000000E+04, 3.2656868289E+00, 3.2586468755E+00, 1.5829001284E-01, 1.4428748312E-01, 7.2288295255E-01],
	[2.0400000000E+04, 3.2668677589E+00, 3.2585303588E+00, 1.5840658558E-01, 1.4438641630E-01, 7.2295963738E-01],
	[2.0405000000E+04, 3.2680488263E+00, 3.2584138749E+00, 1.5852321550E-01, 1.4448538866E-01, 7.2303628878E-01],
	[2.0410000000E+04, 3.2692300312E+00, 3.2582974237E+00, 1.5863990263E-01, 1.4458440019E-01, 7.2311290675E-01],
	[2.0415000000E+04, 3.2704113736E+00, 3.2581810052E+00, 1.5875664697E-01, 1.4468345090E-01, 7.2318949130E-01],
	[2.0420000000E+04, 3.2715928533E+00, 3.2580646193E+00, 1.5887344853E-01, 1.4478254078E-01, 7.2326604245E-01],
	[2.0425000000E+04, 3.2727744705E+00, 3.2579482661E+00, 1.5899030735E-01, 1.4488166984E-01, 7.2334256020E-01],
	[2.0430000000E+04, 3.2739562251E+00, 3.2578319455E+00, 1.5910722341E-01, 1.4498083807E-01, 7.2341904456E-01],
	[2.0435000000E+04, 3.2751381171E+00, 3.2577156576E+00, 1.5922419675E-01, 1.4508004548E-01, 7.2349549555E-01],
	[2.0440000000E+04, 3.2763201464E+00, 3.2575994022E+00, 1.5934122737E-01, 1.4517929206E-01, 7.2357191317E-01],
	[2.0445000000E+04, 3.2775023130E+00, 3.2574831794E+00, 1.5945831529E-01, 1.4527857782E-01, 7.2364829744E-01],
	[2.0450000000E+04, 3.2786846170E+00, 3.2573669892E+00, 1.5957546052E-01, 1.4537790275E-01, 7.2372464836E-01],
	[2.0455000000E+04, 3.2798670583E+00, 3.2572508315E+00, 1.5969266308E-01, 1.4547726686E-01, 7.2380096594E-01],
	[2.0460000000E+04, 3.2810496368E+00, 3.2571347064E+00, 1.5980992297E-01, 1.4557667014E-01, 7.2387725020E-01],
	[2.0465000000E+04, 3.2822323526E+00, 3.2570186138E+00, 1.5992724022E-01, 1.4567611260E-01, 7.2395350115E-01],
	[2.0470000000E+04, 3.2834152057E+00, 3.2569025536E+00, 1.6004461484E-01, 1.4577559423E-01, 7.2402971879E-01],
	[2.0475000000E+04, 3.2845981960E+00, 3.2567865260E+00, 1.6016204684E-01, 1.4587511504E-01, 7.2410590314E-01],
	[2.0480000000E+04, 3.2857813236E+00, 3.2566705308E+00, 1.6027953624E-01, 1.4597467503E-01, 7.2418205420E-01],
	[2.0485000000E+04, 3.2869645883E+00, 3.2565545681E+00, 1.6039708305E-01, 1.4607427419E-01, 7.2425817199E-01],
	[2.0490000000E+04, 3.2881479902E+00, 3.2564386378E+00, 1.6051468728E-01, 1.4617391253E-01, 7.2433425651E-01],
	[2.0495000000E+04, 3.2893315293E+00, 3.2563227399E+00, 1.6063234895E-01, 1.4627359004E-01, 7.2441030779E-01],
	[2.0500000000E+04, 3.2905152055E+00, 3.2562068744E+00, 1.6075006807E-01, 1.4637330672E-01, 7.2448632582E-01],
	[2.0505000000E+04, 3.2916990188E+00, 3.2560910412E+00, 1.6086784466E-01, 1.4647306259E-01, 7.2456231061E-01],
	[2.0510000000E+04, 3.2928829693E+00, 3.2559752405E+00, 1.6098567872E-01, 1.4657285763E-01, 7.2463826219E-01],
	[2.0515000000E+04, 3.2940670568E+00, 3.2558594720E+00, 1.6110357028E-01, 1.4667269184E-01, 7.2471418055E-01],
	[2.0520000000E+04, 3.2952512814E+00, 3.2557437359E+00, 1.6122151935E-01, 1.4677256523E-01, 7.2479006572E-01],
	[2.0525000000E+04, 3.2964356431E+00, 3.2556280322E+00, 1.6133952594E-01, 1.4687247779E-01, 7.2486591769E-01],
	[2.0530000000E+04, 3.2976201418E+00, 3.2555123607E+00, 1.6145759007E-01, 1.4697242953E-01, 7.2494173648E-01],
	[2.0535000000E+04, 3.2988047775E+00, 3.2553967214E+00, 1.6157571175E-01, 1.4707242045E-01, 7.2501752210E-01],
	[2.0540000000E+04, 3.2999895503E+00, 3.2552811145E+00, 1.6169389099E-01, 1.4717245054E-01, 7.2509327456E-01],
	[2.0545000000E+04, 3.3011744600E+00, 3.2551655398E+00, 1.6181212781E-01, 1.4727251980E-01, 7.2516899387E-01],
	[2.0550000000E+04, 3.3023595067E+00, 3.2550499973E+00, 1.6193042222E-01, 1.4737262824E-01, 7.2524468005E-01],
	[2.0555000000E+04, 3.3035446903E+00, 3.2549344870E+00, 1.6204877423E-01, 1.4747277586E-01, 7.2532033309E-01],
	[2.0560000000E+04, 3.3047300109E+00, 3.2548190089E+00, 1.6216718387E-01, 1.4757296265E-01, 7.2539595302E-01],
	[2.0565000000E+04, 3.3059154684E+00, 3.2547035630E+00, 1.6228565114E-01, 1.4767318861E-01, 7.2547153983E-01],
	[2.0570000000E+04, 3.3071010628E+00, 3.2545881492E+00, 1.6240417605E-01, 1.4777345375E-01, 7.2554709355E-01],
	[2.0575000000E+04, 3.3082867941E+00, 3.2544727676E+00, 1.6252275863E-01, 1.4787375807E-01, 7.2562261419E-01],
	[2.0580000000E+04, 3.3094726623E+00, 3.2543574181E+00, 1.6264139889E-01, 1.4797410156E-01, 7.2569810175E-01],
	[2.0585000000E+04, 3.3106586673E+00, 3.2542421008E+00, 1.6276009683E-01, 1.4807448422E-01, 7.2577355624E-01],
	[2.0590000000E+04, 3.3118448091E+00, 3.2541268155E+00, 1.6287885248E-01, 1.4817490606E-01, 7.2584897767E-01],
	[2.0595000000E+04, 3.3130310877E+00, 3.2540115623E+00, 1.6299766584E-01, 1.4827536707E-01, 7.2592436607E-01],
	[2.0600000000E+04, 3.3142175031E+00, 3.2538963411E+00, 1.6311653694E-01, 1.4837586725E-01, 7.2599972142E-01],
	[2.0605000000E+04, 3.3154040554E+00, 3.2537811520E+00, 1.6323546578E-01, 1.4847640661E-01, 7.2607504376E-01],
	[2.0610000000E+04, 3.3165907443E+00, 3.2536659949E+00, 1.6335445239E-01, 1.4857698515E-01, 7.2615033308E-01],
	[2.0615000000E+04, 3.3177775700E+00, 3.2535508698E+00, 1.6347349676E-01, 1.4867760285E-01, 7.2622558939E-01],
	[2.0620000000E+04, 3.3189645325E+00, 3.2534357767E+00, 1.6359259893E-01, 1.4877825973E-01, 7.2630081272E-01],
	[2.0625000000E+04, 3.3201516316E+00, 3.2533207156E+00, 1.6371175889E-01, 1.4887895578E-01, 7.2637600306E-01],
	[2.0630000000E+04, 3.3213388675E+00, 3.2532056864E+00, 1.6383097667E-01, 1.4897969101E-01, 7.2645116043E-01],
	[2.0635000000E+04, 3.3225262400E+00, 3.2530906892E+00, 1.6395025228E-01, 1.4908046541E-01, 7.2652628484E-01],
	[2.0640000000E+04, 3.3237137491E+00, 3.2529757239E+00, 1.6406958574E-01, 1.4918127898E-01, 7.2660137630E-01],
	[2.0645000000E+04, 3.3249013949E+00, 3.2528607906E+00, 1.6418897705E-01, 1.4928213172E-01, 7.2667643482E-01],
	[2.0650000000E+04, 3.3260891774E+00, 3.2527458891E+00, 1.6430842623E-01, 1.4938302364E-01, 7.2675146041E-01],
	[2.0655000000E+04, 3.3272770964E+00, 3.2526310194E+00, 1.6442793330E-01, 1.4948395473E-01, 7.2682645308E-01],
	[2.0660000000E+04, 3.3284651520E+00, 3.2525161817E+00, 1.6454749827E-01, 1.4958492499E-01, 7.2690141285E-01],
	[2.0665000000E+04, 3.3296533442E+00, 3.2524013758E+00, 1.6466712115E-01, 1.4968593442E-01, 7.2697633971E-01],
	[2.0670000000E+04, 3.3308416729E+00, 3.2522866017E+00, 1.6478680196E-01, 1.4978698302E-01, 7.2705123369E-01],
	[2.0675000000E+04, 3.3320301382E+00, 3.2521718594E+00, 1.6490654071E-01, 1.4988807079E-01, 7.2712609480E-01],
	[2.0680000000E+04, 3.3332187400E+00, 3.2520571489E+00, 1.6502633742E-01, 1.4998919774E-01, 7.2720092303E-01],
	[2.0685000000E+04, 3.3344074782E+00, 3.2519424702E+00, 1.6514619209E-01, 1.5009036385E-01, 7.2727571842E-01],
	[2.0690000000E+04, 3.3355963530E+00, 3.2518278232E+00, 1.6526610475E-01, 1.5019156914E-01, 7.2735048096E-01],
	[2.0695000000E+04, 3.3367853642E+00, 3.2517132080E+00, 1.6538607541E-01, 1.5029281359E-01, 7.2742521066E-01],
	[2.0700000000E+04, 3.3379745119E+00, 3.2515986245E+00, 1.6550610407E-01, 1.5039409722E-01, 7.2749990754E-01],
	[2.0705000000E+04, 3.3391637960E+00, 3.2514840728E+00, 1.6562619077E-01, 1.5049542001E-01, 7.2757457161E-01],
	[2.0710000000E+04, 3.3403532166E+00, 3.2513695527E+00, 1.6574633550E-01, 1.5059678197E-01, 7.2764920288E-01],
	[2.0715000000E+04, 3.3415441549E+00, 3.2512558673E+00, 1.6586653828E-01, 1.5069818764E-01, 7.2772380136E-01],
	[2.0720000000E+04, 3.3427392346E+00, 3.2511445399E+00, 1.6598679914E-01, 1.5079964564E-01, 7.2779836705E-01],
	[2.0725000000E+04, 3.3439344531E+00, 3.2510332432E+00, 1.6610711807E-01, 1.5090114284E-01, 7.2787289998E-01],
	[2.0730000000E+04, 3.3451298105E+00, 3.2509219771E+00, 1.6622749510E-01, 1.5100267925E-01, 7.2794740014E-01],
	[2.0735000000E+04, 3.3463253068E+00, 3.2508107417E+00, 1.6634793024E-01, 1.5110425486E-01, 7.2802186756E-01],
	[2.0740000000E+04, 3.3475209420E+00, 3.2506995369E+00, 1.6646842350E-01, 1.5120586968E-01, 7.2809630224E-01],
	[2.0745000000E+04, 3.3487167160E+00, 3.2505883628E+00, 1.6658897490E-01, 1.5130752370E-01, 7.2817070420E-01],
	[2.0750000000E+04, 3.3499126288E+00, 3.2504772192E+00, 1.6670958445E-01, 1.5140921692E-01, 7.2824507344E-01],
	[2.0755000000E+04, 3.3511086804E+00, 3.2503661062E+00, 1.6683025216E-01, 1.5151094934E-01, 7.2831940997E-01],
	[2.0760000000E+04, 3.3523048708E+00, 3.2502550237E+00, 1.6695097806E-01, 1.5161272097E-01, 7.2839371381E-01],
	[2.0765000000E+04, 3.3535011999E+00, 3.2501439718E+00, 1.6707176215E-01, 1.5171453179E-01, 7.2846798496E-01],
	[2.0770000000E+04, 3.3546976678E+00, 3.2500329505E+00, 1.6719260444E-01, 1.5181638182E-01, 7.2854222344E-01],
	[2.0775000000E+04, 3.3558942744E+00, 3.2499219596E+00, 1.6731350496E-01, 1.5191827105E-01, 7.2861642926E-01],
	[2.0780000000E+04, 3.3570910198E+00, 3.2498109992E+00, 1.6743446371E-01, 1.5202019948E-01, 7.2869060242E-01],
	[2.0785000000E+04, 3.3582879038E+00, 3.2497000694E+00, 1.6755548071E-01, 1.5212216711E-01, 7.2876474295E-01],
	[2.0790000000E+04, 3.3594849265E+00, 3.2495891700E+00, 1.6767655597E-01, 1.5222417395E-01, 7.2883885084E-01],
	[2.0795000000E+04, 3.3606820879E+00, 3.2494783010E+00, 1.6779768951E-01, 1.5232621998E-01, 7.2891292611E-01],
	[2.0800000000E+04, 3.3618793879E+00, 3.2493674625E+00, 1.6791888134E-01, 1.5242830521E-01, 7.2898696878E-01],
	[2.0805000000E+04, 3.3630768266E+00, 3.2492566544E+00, 1.6804013148E-01, 1.5253042964E-01, 7.2906097885E-01],
	[2.0810000000E+04, 3.3642744038E+00, 3.2491458767E+00, 1.6816143993E-01, 1.5263259327E-01, 7.2913495633E-01],
	[2.0815000000E+04, 3.3654721197E+00, 3.2490351294E+00, 1.6828280672E-01, 1.5273479609E-01, 7.2920890123E-01],
	[2.0820000000E+04, 3.3666699741E+00, 3.2489244124E+00, 1.6840423186E-01, 1.5283703812E-01, 7.2928281357E-01],
	[2.0825000000E+04, 3.3678679671E+00, 3.2488137259E+00, 1.6852571535E-01, 1.5293931934E-01, 7.2935669336E-01],
	[2.0830000000E+04, 3.3690660986E+00, 3.2487030696E+00, 1.6864725722E-01, 1.5304163976E-01, 7.2943054060E-01],
	[2.0835000000E+04, 3.3702643686E+00, 3.2485924437E+00, 1.6876885748E-01, 1.5314399937E-01, 7.2950435530E-01],
	[2.0840000000E+04, 3.3714627772E+00, 3.2484818481E+00, 1.6889051615E-01, 1.5324639819E-01, 7.2957813749E-01],
	[2.0845000000E+04, 3.3726613242E+00, 3.2483712828E+00, 1.6901223323E-01, 1.5334883619E-01, 7.2965188716E-01],
	[2.0850000000E+04, 3.3738600097E+00, 3.2482607478E+00, 1.6913400874E-01, 1.5345131340E-01, 7.2972560433E-01],
	[2.0855000000E+04, 3.3750588337E+00, 3.2481502430E+00, 1.6925584269E-01, 1.5355382980E-01, 7.2979928902E-01],
	[2.0860000000E+04, 3.3762577961E+00, 3.2480397685E+00, 1.6937773511E-01, 1.5365638539E-01, 7.2987294122E-01],
	[2.0865000000E+04, 3.3774568969E+00, 3.2479293242E+00, 1.6949968599E-01, 1.5375898017E-01, 7.2994656096E-01],
	[2.0870000000E+04, 3.3786561362E+00, 3.2478189102E+00, 1.6962169537E-01, 1.5386161415E-01, 7.3002014824E-01],
	[2.0875000000E+04, 3.3798555138E+00, 3.2477085263E+00, 1.6974376324E-01, 1.5396428733E-01, 7.3009370307E-01],
	[2.0880000000E+04, 3.3810550298E+00, 3.2475981726E+00, 1.6986588963E-01, 1.5406699969E-01, 7.3016722547E-01],
	[2.0885000000E+04, 3.3822546841E+00, 3.2474878491E+00, 1.6998807455E-01, 1.5416975125E-01, 7.3024071544E-01],
	[2.0890000000E+04, 3.3834544767E+00, 3.2473775558E+00, 1.7011031801E-01, 1.5427254200E-01, 7.3031417300E-01],
	[2.0895000000E+04, 3.3846544077E+00, 3.2472672926E+00, 1.7023262003E-01, 1.5437537194E-01, 7.3038759816E-01],
	[2.0900000000E+04, 3.3858544770E+00, 3.2471570595E+00, 1.7035498062E-01, 1.5447824107E-01, 7.3046099093E-01],
	[2.0905000000E+04, 3.3870546846E+00, 3.2470468565E+00, 1.7047739979E-01, 1.5458114939E-01, 7.3053435131E-01],
	[2.0910000000E+04, 3.3882550304E+00, 3.2469366837E+00, 1.7059987756E-01, 1.5468409690E-01, 7.3060767933E-01],
	[2.0915000000E+04, 3.3894555145E+00, 3.2468265408E+00, 1.7072241395E-01, 1.5478708360E-01, 7.3068097498E-01],
	[2.0920000000E+04, 3.3906561368E+00, 3.2467164281E+00, 1.7084500896E-01, 1.5489010949E-01, 7.3075423829E-01],
	[2.0925000000E+04, 3.3918568973E+00, 3.2466063454E+00, 1.7096766261E-01, 1.5499317457E-01, 7.3082746927E-01],
	[2.0930000000E+04, 3.3930577960E+00, 3.2464962928E+00, 1.7109037492E-01, 1.5509627883E-01, 7.3090066791E-01],
	[2.0935000000E+04, 3.3942588329E+00, 3.2463862701E+00, 1.7121314589E-01, 1.5519942228E-01, 7.3097383424E-01],
	[2.0940000000E+04, 3.3954600080E+00, 3.2462762775E+00, 1.7133597555E-01, 1.5530260492E-01, 7.3104696827E-01],
	[2.0945000000E+04, 3.3966613212E+00, 3.2461663148E+00, 1.7145886390E-01, 1.5540582674E-01, 7.3112007000E-01],
	[2.0950000000E+04, 3.3978627725E+00, 3.2460563821E+00, 1.7158181097E-01, 1.5550908775E-01, 7.3119313945E-01],
	[2.0955000000E+04, 3.3990643620E+00, 3.2459464794E+00, 1.7170481676E-01, 1.5561238795E-01, 7.3126617663E-01],
	[2.0960000000E+04, 3.4002660895E+00, 3.2458366066E+00, 1.7182788129E-01, 1.5571572732E-01, 7.3133918155E-01],
	[2.0965000000E+04, 3.4014679551E+00, 3.2457267638E+00, 1.7195100457E-01, 1.5581910588E-01, 7.3141215422E-01],
	[2.0970000000E+04, 3.4026699588E+00, 3.2456169508E+00, 1.7207418661E-01, 1.5592252363E-01, 7.3148509464E-01],
	[2.0975000000E+04, 3.4038721005E+00, 3.2455071677E+00, 1.7219742744E-01, 1.5602598055E-01, 7.3155800283E-01],
	[2.0980000000E+04, 3.4050743803E+00, 3.2453974146E+00, 1.7232072706E-01, 1.5612947666E-01, 7.3163087879E-01],
	[2.0985000000E+04, 3.4062767980E+00, 3.2452876912E+00, 1.7244408549E-01, 1.5623301195E-01, 7.3170372253E-01],
	[2.0990000000E+04, 3.4074793538E+00, 3.2451779978E+00, 1.7256750274E-01, 1.5633658642E-01, 7.3177653407E-01],
	[2.0995000000E+04, 3.4086820475E+00, 3.2450683341E+00, 1.7269097883E-01, 1.5644020006E-01, 7.3184931340E-01],
	[2.1000000000E+04, 3.4098848792E+00, 3.2449587003E+00, 1.7281451377E-01, 1.5654385289E-01, 7.3192206055E-01],
	[2.1005000000E+04, 3.4110878488E+00, 3.2448490963E+00, 1.7293810757E-01, 1.5664754490E-01, 7.3199477552E-01],
	[2.1010000000E+04, 3.4122909563E+00, 3.2447395221E+00, 1.7306176026E-01, 1.5675127608E-01, 7.3206745832E-01],
	[2.1015000000E+04, 3.4134942018E+00, 3.2446299776E+00, 1.7318547183E-01, 1.5685504644E-01, 7.3214010896E-01],
	[2.1020000000E+04, 3.4146975851E+00, 3.2445204629E+00, 1.7330924231E-01, 1.5695885598E-01, 7.3221272745E-01],
	[2.1025000000E+04, 3.4159011064E+00, 3.2444109780E+00, 1.7343307171E-01, 1.5706270469E-01, 7.3228531380E-01],
	[2.1030000000E+04, 3.4171047654E+00, 3.2443015227E+00, 1.7355696005E-01, 1.5716659258E-01, 7.3235786801E-01],
	[2.1035000000E+04, 3.4183085623E+00, 3.2441920972E+00, 1.7368090733E-01, 1.5727051964E-01, 7.3243039011E-01],
	[2.1040000000E+04, 3.4195124971E+00, 3.2440827014E+00, 1.7380491358E-01, 1.5737448588E-01, 7.3250288009E-01],
	[2.1045000000E+04, 3.4207165696E+00, 3.2439733353E+00, 1.7392897880E-01, 1.5747849129E-01, 7.3257533797E-01],
	[2.1050000000E+04, 3.4219238674E+00, 3.2438657339E+00, 1.7405310301E-01, 1.5758254651E-01, 7.3264776376E-01],
	[2.1055000000E+04, 3.4231336915E+00, 3.2437595027E+00, 1.7417728623E-01, 1.5768664917E-01, 7.3272015746E-01],
	[2.1060000000E+04, 3.4243436560E+00, 3.2436533001E+00, 1.7430152846E-01, 1.5779079103E-01, 7.3279251910E-01],
	[2.1065000000E+04, 3.4255537607E+00, 3.2435471263E+00, 1.7442582973E-01, 1.5789497209E-01, 7.3286484866E-01],
	[2.1070000000E+04, 3.4267640057E+00, 3.2434409811E+00, 1.7455019004E-01, 1.5799919237E-01, 7.3293714618E-01],
	[2.1075000000E+04, 3.4279743910E+00, 3.2433348646E+00, 1.7467460941E-01, 1.5810345185E-01, 7.3300941164E-01],
	[2.1080000000E+04, 3.4291849165E+00, 3.2432287768E+00, 1.7479908786E-01, 1.5820775054E-01, 7.3308164508E-01],
	[2.1085000000E+04, 3.4303955823E+00, 3.2431227175E+00, 1.7492362539E-01, 1.5831208843E-01, 7.3315384649E-01],
	[2.1090000000E+04, 3.4316063882E+00, 3.2430166869E+00, 1.7504822203E-01, 1.5841646553E-01, 7.3322601588E-01],
	[2.1095000000E+04, 3.4328173344E+00, 3.2429106849E+00, 1.7517287778E-01, 1.5852088183E-01, 7.3329815327E-01],
	[2.1100000000E+04, 3.4340284208E+00, 3.2428047115E+00, 1.7529759266E-01, 1.5862533734E-01, 7.3337025866E-01],
	[2.1105000000E+04, 3.4352396473E+00, 3.2426987666E+00, 1.7542236669E-01, 1.5872983204E-01, 7.3344233206E-01],
	[2.1110000000E+04, 3.4364510139E+00, 3.2425928503E+00, 1.7554719988E-01, 1.5883436595E-01, 7.3351437349E-01],
	[2.1115000000E+04, 3.4376625207E+00, 3.2424869625E+00, 1.7567209223E-01, 1.5893893906E-01, 7.3358638295E-01],
	[2.1120000000E+04, 3.4388741676E+00, 3.2423811033E+00, 1.7579704378E-01, 1.5904355137E-01, 7.3365836045E-01],
	[2.1125000000E+04, 3.4400859546E+00, 3.2422752726E+00, 1.7592205452E-01, 1.5914820288E-01, 7.3373030601E-01],
	[2.1130000000E+04, 3.4412978817E+00, 3.2421694704E+00, 1.7604712447E-01, 1.5925289358E-01, 7.3380221963E-01],
	[2.1135000000E+04, 3.4425099488E+00, 3.2420636966E+00, 1.7617225366E-01, 1.5935762349E-01, 7.3387410132E-01],
	[2.1140000000E+04, 3.4437221559E+00, 3.2419579513E+00, 1.7629744209E-01, 1.5946239259E-01, 7.3394595109E-01],
	[2.1145000000E+04, 3.4449345031E+00, 3.2418522345E+00, 1.7642268977E-01, 1.5956720089E-01, 7.3401776895E-01],
	[2.1150000000E+04, 3.4461469903E+00, 3.2417465462E+00, 1.7654799672E-01, 1.5967204838E-01, 7.3408955492E-01],
	[2.1155000000E+04, 3.4473596175E+00, 3.2416408862E+00, 1.7667336296E-01, 1.5977693507E-01, 7.3416130900E-01],
	[2.1160000000E+04, 3.4485723847E+00, 3.2415352547E+00, 1.7679878849E-01, 1.5988186095E-01, 7.3423303119E-01],
	[2.1165000000E+04, 3.4497852918E+00, 3.2414296515E+00, 1.7692427333E-01, 1.5998682602E-01, 7.3430472152E-01],
	[2.1170000000E+04, 3.4509983389E+00, 3.2413240768E+00, 1.7704981751E-01, 1.6009183029E-01, 7.3437637999E-01],
	[2.1175000000E+04, 3.4522115259E+00, 3.2412185304E+00, 1.7717542102E-01, 1.6019687374E-01, 7.3444800661E-01],
	[2.1180000000E+04, 3.4534248528E+00, 3.2411130124E+00, 1.7730108388E-01, 1.6030195639E-01, 7.3451960140E-01],
	[2.1185000000E+04, 3.4546383196E+00, 3.2410075227E+00, 1.7742680611E-01, 1.6040707823E-01, 7.3459116435E-01],
	[2.1190000000E+04, 3.4558519263E+00, 3.2409020613E+00, 1.7755258773E-01, 1.6051223925E-01, 7.3466269548E-01],
	[2.1195000000E+04, 3.4570656728E+00, 3.2407966283E+00, 1.7767842874E-01, 1.6061743947E-01, 7.3473419480E-01],
	[2.1200000000E+04, 3.4582795592E+00, 3.2406912235E+00, 1.7780432916E-01, 1.6072267887E-01, 7.3480566232E-01],
	[2.1205000000E+04, 3.4594935854E+00, 3.2405858471E+00, 1.7793028900E-01, 1.6082795745E-01, 7.3487709805E-01],
	[2.1210000000E+04, 3.4607077514E+00, 3.2404804989E+00, 1.7805630828E-01, 1.6093327523E-01, 7.3494850201E-01],
	[2.1215000000E+04, 3.4619220571E+00, 3.2403751789E+00, 1.7818238701E-01, 1.6103863218E-01, 7.3501987419E-01],
	[2.1220000000E+04, 3.4631365027E+00, 3.2402698872E+00, 1.7830852521E-01, 1.6114402832E-01, 7.3509121461E-01],
	[2.1225000000E+04, 3.4643510880E+00, 3.2401646238E+00, 1.7843472289E-01, 1.6124946364E-01, 7.3516252328E-01],
	[2.1230000000E+04, 3.4655658131E+00, 3.2400593885E+00, 1.7856098006E-01, 1.6135493815E-01, 7.3523380021E-01],
	[2.1235000000E+04, 3.4667806778E+00, 3.2399541814E+00, 1.7868729674E-01, 1.6146045183E-01, 7.3530504541E-01],
	[2.1240000000E+04, 3.4679956823E+00, 3.2398490025E+00, 1.7881367294E-01, 1.6156600470E-01, 7.3537625889E-01],
	[2.1245000000E+04, 3.4692108265E+00, 3.2397438518E+00, 1.7894010867E-01, 1.6167159674E-01, 7.3544744066E-01],
	[2.1250000000E+04, 3.4704261103E+00, 3.2396387293E+00, 1.7906660396E-01, 1.6177722796E-01, 7.3551859073E-01],
	[2.1255000000E+04, 3.4716415338E+00, 3.2395336349E+00, 1.7919315881E-01, 1.6188289836E-01, 7.3558970911E-01],
	[2.1260000000E+04, 3.4728570970E+00, 3.2394285686E+00, 1.7931977323E-01, 1.6198860793E-01, 7.3566079581E-01],
	[2.1265000000E+04, 3.4740727997E+00, 3.2393235304E+00, 1.7944644725E-01, 1.6209435668E-01, 7.3573185084E-01],
	[2.1270000000E+04, 3.4752886421E+00, 3.2392185203E+00, 1.7957318087E-01, 1.6220014461E-01, 7.3580287420E-01],
	[2.1275000000E+04, 3.4765046240E+00, 3.2391135384E+00, 1.7969997411E-01, 1.6230597170E-01, 7.3587386592E-01],
	[2.1280000000E+04, 3.4777207455E+00, 3.2390085844E+00, 1.7982682699E-01, 1.6241183797E-01, 7.3594482600E-01],
	[2.1285000000E+04, 3.4789370066E+00, 3.2389036586E+00, 1.7995373951E-01, 1.6251774341E-01, 7.3601575444E-01],
	[2.1290000000E+04, 3.4801534072E+00, 3.2387987608E+00, 1.8008071170E-01, 1.6262368802E-01, 7.3608665127E-01],
	[2.1295000000E+04, 3.4813699474E+00, 3.2386938910E+00, 1.8020774355E-01, 1.6272967180E-01, 7.3615751648E-01],
	[2.1300000000E+04, 3.4825866270E+00, 3.2385890492E+00, 1.8033483510E-01, 1.6283569475E-01, 7.3622835010E-01],
	[2.1305000000E+04, 3.4838034461E+00, 3.2384842354E+00, 1.8046198636E-01, 1.6294175686E-01, 7.3629915212E-01],
	[2.1310000000E+04, 3.4850204047E+00, 3.2383794496E+00, 1.8058919732E-01, 1.6304785815E-01, 7.3636992257E-01],
	[2.1315000000E+04, 3.4862375028E+00, 3.2382746918E+00, 1.8071646802E-01, 1.6315399859E-01, 7.3644066144E-01],
	[2.1320000000E+04, 3.4874547402E+00, 3.2381699620E+00, 1.8084379847E-01, 1.6326017820E-01, 7.3651136876E-01],
	[2.1325000000E+04, 3.4886721171E+00, 3.2380652601E+00, 1.8097118867E-01, 1.6336639698E-01, 7.3658204452E-01],
	[2.1330000000E+04, 3.4898896334E+00, 3.2379605861E+00, 1.8109863865E-01, 1.6347265491E-01, 7.3665268875E-01],
	[2.1335000000E+04, 3.4911072891E+00, 3.2378559400E+00, 1.8122614842E-01, 1.6357895201E-01, 7.3672330145E-01],
	[2.1340000000E+04, 3.4923250842E+00, 3.2377513219E+00, 1.8135371798E-01, 1.6368528827E-01, 7.3679388262E-01],
	[2.1345000000E+04, 3.4935430186E+00, 3.2376467316E+00, 1.8148134737E-01, 1.6379166368E-01, 7.3686443229E-01],
	[2.1350000000E+04, 3.4947610924E+00, 3.2375421692E+00, 1.8160903658E-01, 1.6389807826E-01, 7.3693495046E-01],
	[2.1355000000E+04, 3.4959793054E+00, 3.2374376347E+00, 1.8173678563E-01, 1.6400453199E-01, 7.3700543714E-01],
	[2.1360000000E+04, 3.4971976578E+00, 3.2373331280E+00, 1.8186459454E-01, 1.6411102488E-01, 7.3707589234E-01],
	[2.1365000000E+04, 3.4984161495E+00, 3.2372286491E+00, 1.8199246332E-01, 1.6421755692E-01, 7.3714631608E-01],
	[2.1370000000E+04, 3.4996347804E+00, 3.2371241981E+00, 1.8212039199E-01, 1.6432412811E-01, 7.3721670835E-01],
	[2.1375000000E+04, 3.5008535506E+00, 3.2370197748E+00, 1.8224838055E-01, 1.6443073846E-01, 7.3728706918E-01],
	[2.1380000000E+04, 3.5020724600E+00, 3.2369153794E+00, 1.8237642903E-01, 1.6453738796E-01, 7.3735739856E-01],
	[2.1385000000E+04, 3.5032915087E+00, 3.2368110117E+00, 1.8250453744E-01, 1.6464407661E-01, 7.3742769652E-01],
	[2.1390000000E+04, 3.5045151364E+00, 3.2367090843E+00, 1.8263270578E-01, 1.6475082047E-01, 7.3749796307E-01],
	[2.1395000000E+04, 3.5057400306E+00, 3.2366077952E+00, 1.8276093408E-01, 1.6485760758E-01, 7.3756819820E-01],
	[2.1400000000E+04, 3.5069650665E+00, 3.2365065329E+00, 1.8288922235E-01, 1.6496443388E-01, 7.3763840194E-01],
	[2.1405000000E+04, 3.5081902443E+00, 3.2364052974E+00, 1.8301757061E-01, 1.6507129937E-01, 7.3770857429E-01],
	[2.1410000000E+04, 3.5094155637E+00, 3.2363040887E+00, 1.8314597886E-01, 1.6517820404E-01, 7.3777871527E-01],
	[2.1415000000E+04, 3.5106410248E+00, 3.2362029069E+00, 1.8327444712E-01, 1.6528514789E-01, 7.3784882488E-01],
	[2.1420000000E+04, 3.5118666276E+00, 3.2361017518E+00, 1.8340297540E-01, 1.6539213093E-01, 7.3791890313E-01],
	[2.1425000000E+04, 3.5130923721E+00, 3.2360006235E+00, 1.8353156373E-01, 1.6549915315E-01, 7.3798895004E-01],
	[2.1430000000E+04, 3.5143182582E+00, 3.2358995219E+00, 1.8366021211E-01, 1.6560621454E-01, 7.3805896561E-01],
	[2.1435000000E+04, 3.5155442859E+00, 3.2357984471E+00, 1.8378892055E-01, 1.6571331512E-01, 7.3812894985E-01],
	[2.1440000000E+04, 3.5167704553E+00, 3.2356973990E+00, 1.8391768907E-01, 1.6582045487E-01, 7.3819890278E-01],
	[2.1445000000E+04, 3.5179967663E+00, 3.2355963777E+00, 1.8404651769E-01, 1.6592763380E-01, 7.3826882441E-01],
	[2.1450000000E+04, 3.5192232188E+00, 3.2354953830E+00, 1.8417540642E-01, 1.6603485190E-01, 7.3833871474E-01],
	[2.1455000000E+04, 3.5204498129E+00, 3.2353944150E+00, 1.8430435527E-01, 1.6614210918E-01, 7.3840857379E-01],
	[2.1460000000E+04, 3.5216765486E+00, 3.2352934737E+00, 1.8443336426E-01, 1.6624940563E-01, 7.3847840156E-01],
	[2.1465000000E+04, 3.5229034258E+00, 3.2351925591E+00, 1.8456243340E-01, 1.6635674125E-01, 7.3854819807E-01],
	[2.1470000000E+04, 3.5241304445E+00, 3.2350916711E+00, 1.8469156270E-01, 1.6646411604E-01, 7.3861796333E-01],
	[2.1475000000E+04, 3.5253576047E+00, 3.2349908098E+00, 1.8482075218E-01, 1.6657153000E-01, 7.3868769734E-01],
	[2.1480000000E+04, 3.5265849064E+00, 3.2348899750E+00, 1.8495000186E-01, 1.6667898313E-01, 7.3875740013E-01],
	[2.1485000000E+04, 3.5278123496E+00, 3.2347891669E+00, 1.8507931174E-01, 1.6678647542E-01, 7.3882707169E-01],
	[2.1490000000E+04, 3.5290399342E+00, 3.2346883854E+00, 1.8520868184E-01, 1.6689400688E-01, 7.3889671204E-01],
	[2.1495000000E+04, 3.5302676603E+00, 3.2345876305E+00, 1.8533811217E-01, 1.6700157751E-01, 7.3896632118E-01],
	[2.1500000000E+04, 3.5314955277E+00, 3.2344869021E+00, 1.8546760276E-01, 1.6710918730E-01, 7.3903589914E-01],
	[2.1505000000E+04, 3.5327235366E+00, 3.2343862003E+00, 1.8559715360E-01, 1.6721683625E-01, 7.3910544591E-01],
	[2.1510000000E+04, 3.5339516868E+00, 3.2342855251E+00, 1.8572676473E-01, 1.6732452436E-01, 7.3917496152E-01],
	[2.1515000000E+04, 3.5351799784E+00, 3.2341848764E+00, 1.8585643614E-01, 1.6743225163E-01, 7.3924444596E-01],
	[2.1520000000E+04, 3.5364084114E+00, 3.2340842542E+00, 1.8598616786E-01, 1.6754001806E-01, 7.3931389926E-01],
	[2.1525000000E+04, 3.5376369857E+00, 3.2339836585E+00, 1.8611595989E-01, 1.6764782364E-01, 7.3938332142E-01],
	[2.1530000000E+04, 3.5388657013E+00, 3.2338830893E+00, 1.8624581226E-01, 1.6775566838E-01, 7.3945271245E-01],
	[2.1535000000E+04, 3.5400945582E+00, 3.2337825465E+00, 1.8637572498E-01, 1.6786355228E-01, 7.3952207236E-01],
	[2.1540000000E+04, 3.5413235564E+00, 3.2336820303E+00, 1.8650569805E-01, 1.6797147533E-01, 7.3959140116E-01],
	[2.1545000000E+04, 3.5425526959E+00, 3.2335815405E+00, 1.8663573150E-01, 1.6807943753E-01, 7.3966069887E-01],
	[2.1550000000E+04, 3.5437819766E+00, 3.2334810771E+00, 1.8676582534E-01, 1.6818743888E-01, 7.3972996549E-01],
	[2.1555000000E+04, 3.5450113986E+00, 3.2333806402E+00, 1.8689597958E-01, 1.6829547938E-01, 7.3979920103E-01],
	[2.1560000000E+04, 3.5462409618E+00, 3.2332802297E+00, 1.8702619424E-01, 1.6840355903E-01, 7.3986840551E-01],
	[2.1565000000E+04, 3.5474706661E+00, 3.2331798455E+00, 1.8715646932E-01, 1.6851167782E-01, 7.3993757893E-01],
	[2.1570000000E+04, 3.5487005117E+00, 3.2330794878E+00, 1.8728680486E-01, 1.6861983576E-01, 7.4000672131E-01],
	[2.1575000000E+04, 3.5499304984E+00, 3.2329791564E+00, 1.8741720084E-01, 1.6872803285E-01, 7.4007583265E-01],
	[2.1580000000E+04, 3.5511606263E+00, 3.2328788514E+00, 1.8754765731E-01, 1.6883626907E-01, 7.4014491297E-01],
	[2.1585000000E+04, 3.5523908953E+00, 3.2327785728E+00, 1.8767817425E-01, 1.6894454444E-01, 7.4021396227E-01],
	[2.1590000000E+04, 3.5536213054E+00, 3.2326783205E+00, 1.8780875170E-01, 1.6905285895E-01, 7.4028298057E-01],
	[2.1595000000E+04, 3.5548518567E+00, 3.2325780945E+00, 1.8793938966E-01, 1.6916121260E-01, 7.4035196788E-01],
	[2.1600000000E+04, 3.5560825490E+00, 3.2324778948E+00, 1.8807008815E-01, 1.6926960538E-01, 7.4042092421E-01],
	[2.1605000000E+04, 3.5573133824E+00, 3.2323777214E+00, 1.8820084718E-01, 1.6937803730E-01, 7.4048984957E-01],
	[2.1610000000E+04, 3.5585443568E+00, 3.2322775743E+00, 1.8833166677E-01, 1.6948650835E-01, 7.4055874397E-01],
	[2.1615000000E+04, 3.5597754723E+00, 3.2321774535E+00, 1.8846254693E-01, 1.6959501854E-01, 7.4062760741E-01],
	[2.1620000000E+04, 3.5610067288E+00, 3.2320773589E+00, 1.8859348767E-01, 1.6970356786E-01, 7.4069643992E-01],
	[2.1625000000E+04, 3.5622381263E+00, 3.2319772906E+00, 1.8872448901E-01, 1.6981215631E-01, 7.4076524150E-01],
	[2.1630000000E+04, 3.5634696648E+00, 3.2318772485E+00, 1.8885555097E-01, 1.6992078389E-01, 7.4083401215E-01],
	[2.1635000000E+04, 3.5647013442E+00, 3.2317772326E+00, 1.8898667354E-01, 1.7002945060E-01, 7.4090275190E-01],
	[2.1640000000E+04, 3.5659331646E+00, 3.2316772429E+00, 1.8911785676E-01, 1.7013815643E-01, 7.4097146076E-01],
	[2.1645000000E+04, 3.5671651260E+00, 3.2315772794E+00, 1.8924910063E-01, 1.7024690138E-01, 7.4104013872E-01],
	[2.1650000000E+04, 3.5683972282E+00, 3.2314773421E+00, 1.8938040517E-01, 1.7035568546E-01, 7.4110878581E-01],
	[2.1655000000E+04, 3.5696294714E+00, 3.2313774310E+00, 1.8951177039E-01, 1.7046450867E-01, 7.4117740204E-01],
	[2.1660000000E+04, 3.5708618555E+00, 3.2312775460E+00, 1.8964319631E-01, 1.7057337099E-01, 7.4124598741E-01],
	[2.1665000000E+04, 3.5720943804E+00, 3.2311776872E+00, 1.8977468294E-01, 1.7068227243E-01, 7.4131454193E-01],
	[2.1670000000E+04, 3.5733270462E+00, 3.2310778544E+00, 1.8990623029E-01, 1.7079121299E-01, 7.4138306562E-01],
	[2.1675000000E+04, 3.5745598528E+00, 3.2309780478E+00, 1.9003783838E-01, 1.7090019266E-01, 7.4145155849E-01],
	[2.1680000000E+04, 3.5757928003E+00, 3.2308782674E+00, 1.9016950722E-01, 1.7100921145E-01, 7.4152002054E-01],
	[2.1685000000E+04, 3.5770258885E+00, 3.2307785129E+00, 1.9030123683E-01, 1.7111826936E-01, 7.4158845180E-01],
	[2.1690000000E+04, 3.5782591176E+00, 3.2306787846E+00, 1.9043302721E-01, 1.7122736637E-01, 7.4165685226E-01],
	[2.1695000000E+04, 3.5794924874E+00, 3.2305790824E+00, 1.9056487839E-01, 1.7133650250E-01, 7.4172522194E-01],
	[2.1700000000E+04, 3.5807259980E+00, 3.2304794061E+00, 1.9069679038E-01, 1.7144567773E-01, 7.4179356085E-01],
	[2.1705000000E+04, 3.5819596493E+00, 3.2303797560E+00, 1.9082876319E-01, 1.7155489207E-01, 7.4186186900E-01],
	[2.1710000000E+04, 3.5831934413E+00, 3.2302801318E+00, 1.9096079683E-01, 1.7166414552E-01, 7.4193014640E-01],
	[2.1715000000E+04, 3.5844273741E+00, 3.2301805337E+00, 1.9109289133E-01, 1.7177343807E-01, 7.4199839307E-01],
	[2.1720000000E+04, 3.5856614475E+00, 3.2300809616E+00, 1.9122504669E-01, 1.7188276972E-01, 7.4206660900E-01],
	[2.1725000000E+04, 3.5868956616E+00, 3.2299814154E+00, 1.9135726292E-01, 1.7199214048E-01, 7.4213479423E-01],
	[2.1730000000E+04, 3.5881300164E+00, 3.2298818952E+00, 1.9148954005E-01, 1.7210155033E-01, 7.4220294874E-01],
	[2.1735000000E+04, 3.5893698336E+00, 3.2297851972E+00, 1.9162187808E-01, 1.7221101948E-01, 7.4227107256E-01],
	[2.1740000000E+04, 3.5906101295E+00, 3.2296887006E+00, 1.9175427703E-01, 1.7232052904E-01, 7.4233916569E-01],
	[2.1745000000E+04, 3.5918505686E+00, 3.2295922290E+00, 1.9188673692E-01, 1.7243007774E-01, 7.4240722815E-01],
	[2.1750000000E+04, 3.5930911508E+00, 3.2294957825E+00, 1.9201925775E-01, 1.7253966558E-01, 7.4247525995E-01],
	[2.1755000000E+04, 3.5943318763E+00, 3.2293993610E+00, 1.9215183955E-01, 1.7264929254E-01, 7.4254326110E-01],
	[2.1760000000E+04, 3.5955727449E+00, 3.2293029646E+00, 1.9228448232E-01, 1.7275895864E-01, 7.4261123160E-01],
	[2.1765000000E+04, 3.5968137566E+00, 3.2292065932E+00, 1.9241718608E-01, 1.7286866387E-01, 7.4267917147E-01],
	[2.1770000000E+04, 3.5980549115E+00, 3.2291102468E+00, 1.9254995084E-01, 1.7297840822E-01, 7.4274708072E-01],
	[2.1775000000E+04, 3.5992962094E+00, 3.2290139254E+00, 1.9268277662E-01, 1.7308819171E-01, 7.4281495936E-01],
	[2.1780000000E+04, 3.6005376505E+00, 3.2289176290E+00, 1.9281566343E-01, 1.7319801432E-01, 7.4288280741E-01],
	[2.1785000000E+04, 3.6017792346E+00, 3.2288213576E+00, 1.9294861129E-01, 1.7330787605E-01, 7.4295062486E-01],
	[2.1790000000E+04, 3.6030209618E+00, 3.2287251111E+00, 1.9308162020E-01, 1.7341777691E-01, 7.4301841174E-01],
	[2.1795000000E+04, 3.6042628321E+00, 3.2286288896E+00, 1.9321469019E-01, 1.7352771688E-01, 7.4308616805E-01],
	[2.1800000000E+04, 3.6055048454E+00, 3.2285326930E+00, 1.9334782127E-01, 1.7363769598E-01, 7.4315389381E-01],
	[2.1805000000E+04, 3.6067470017E+00, 3.2284365213E+00, 1.9348101345E-01, 1.7374771419E-01, 7.4322158902E-01],
	[2.1810000000E+04, 3.6079893010E+00, 3.2283403746E+00, 1.9361426674E-01, 1.7385777152E-01, 7.4328925370E-01],
	[2.1815000000E+04, 3.6092317432E+00, 3.2282442527E+00, 1.9374758116E-01, 1.7396786796E-01, 7.4335688785E-01],
	[2.1820000000E+04, 3.6104743285E+00, 3.2281481558E+00, 1.9388095673E-01, 1.7407800352E-01, 7.4342449149E-01],
	[2.1825000000E+04, 3.6117170567E+00, 3.2280520837E+00, 1.9401439345E-01, 1.7418817819E-01, 7.4349206463E-01],
	[2.1830000000E+04, 3.6129599278E+00, 3.2279560365E+00, 1.9414789135E-01, 1.7429839197E-01, 7.4355960728E-01],
	[2.1835000000E+04, 3.6142029418E+00, 3.2278600141E+00, 1.9428145043E-01, 1.7440864485E-01, 7.4362711944E-01],
	[2.1840000000E+04, 3.6154460987E+00, 3.2277640166E+00, 1.9441507070E-01, 1.7451893684E-01, 7.4369460114E-01],
	[2.1845000000E+04, 3.6166893985E+00, 3.2276680439E+00, 1.9454875219E-01, 1.7462926794E-01, 7.4376205238E-01],
	[2.1850000000E+04, 3.6179328412E+00, 3.2275720961E+00, 1.9468249491E-01, 1.7473963814E-01, 7.4382947317E-01],
	[2.1855000000E+04, 3.6191764267E+00, 3.2274761730E+00, 1.9481629887E-01, 1.7485004744E-01, 7.4389686353E-01],
	[2.1860000000E+04, 3.6204201551E+00, 3.2273802747E+00, 1.9495016409E-01, 1.7496049584E-01, 7.4396422346E-01],
	[2.1865000000E+04, 3.6216640262E+00, 3.2272844013E+00, 1.9508409057E-01, 1.7507098334E-01, 7.4403155297E-01],
	[2.1870000000E+04, 3.6229080402E+00, 3.2271885525E+00, 1.9521807833E-01, 1.7518150993E-01, 7.4409885208E-01],
	[2.1875000000E+04, 3.6241521970E+00, 3.2270927286E+00, 1.9535212740E-01, 1.7529207562E-01, 7.4416612080E-01],
	[2.1880000000E+04, 3.6253964965E+00, 3.2269969293E+00, 1.9548623777E-01, 1.7540268041E-01, 7.4423335913E-01],
	[2.1885000000E+04, 3.6266409388E+00, 3.2269011549E+00, 1.9562040947E-01, 1.7551332428E-01, 7.4430056709E-01],
	[2.1890000000E+04, 3.6278855238E+00, 3.2268054051E+00, 1.9575464251E-01, 1.7562400725E-01, 7.4436774469E-01],
	[2.1895000000E+04, 3.6291302515E+00, 3.2267096800E+00, 1.9588893690E-01, 1.7573472930E-01, 7.4443489194E-01],
	[2.1900000000E+04, 3.6303751219E+00, 3.2266139797E+00, 1.9602329266E-01, 1.7584549044E-01, 7.4450200885E-01],
	[2.1905000000E+04, 3.6316201350E+00, 3.2265183040E+00, 1.9615770979E-01, 1.7595629066E-01, 7.4456909544E-01],
	[2.1910000000E+04, 3.6328652908E+00, 3.2264226530E+00, 1.9629218833E-01, 1.7606712996E-01, 7.4463615170E-01],
	[2.1915000000E+04, 3.6341105893E+00, 3.2263270266E+00, 1.9642672827E-01, 1.7617800835E-01, 7.4470317766E-01],
	[2.1920000000E+04, 3.6353560304E+00, 3.2262314249E+00, 1.9656132963E-01, 1.7628892582E-01, 7.4477017332E-01],
	[2.1925000000E+04, 3.6366016141E+00, 3.2261358479E+00, 1.9669599243E-01, 1.7639988236E-01, 7.4483713870E-01],
	[2.1930000000E+04, 3.6378473404E+00, 3.2260402954E+00, 1.9683071669E-01, 1.7651087798E-01, 7.4490407381E-01],
	[2.1935000000E+04, 3.6390932093E+00, 3.2259447676E+00, 1.9696550240E-01, 1.7662191267E-01, 7.4497097865E-01],
	[2.1940000000E+04, 3.6403392207E+00, 3.2258492644E+00, 1.9710034960E-01, 1.7673298644E-01, 7.4503785324E-01],
	[2.1945000000E+04, 3.6415853748E+00, 3.2257537857E+00, 1.9723525828E-01, 1.7684409927E-01, 7.4510469759E-01],
	[2.1950000000E+04, 3.6428316713E+00, 3.2256583317E+00, 1.9737022848E-01, 1.7695525118E-01, 7.4517151171E-01],
	[2.1955000000E+04, 3.6440781104E+00, 3.2255629022E+00, 1.9750526019E-01, 1.7706644215E-01, 7.4523829561E-01],
	[2.1960000000E+04, 3.6453246920E+00, 3.2254674973E+00, 1.9764035344E-01, 1.7717767219E-01, 7.4530504931E-01],
	[2.1965000000E+04, 3.6465714161E+00, 3.2253721168E+00, 1.9777550824E-01, 1.7728894129E-01, 7.4537177280E-01],
	[2.1970000000E+04, 3.6478182827E+00, 3.2252767610E+00, 1.9791072460E-01, 1.7740024945E-01, 7.4543846611E-01],
	[2.1975000000E+04, 3.6490652917E+00, 3.2251814296E+00, 1.9804600254E-01, 1.7751159667E-01, 7.4550512924E-01],
	[2.1980000000E+04, 3.6503124432E+00, 3.2250861228E+00, 1.9818134207E-01, 1.7762298295E-01, 7.4557176221E-01],
	[2.1985000000E+04, 3.6515597371E+00, 3.2249908404E+00, 1.9831674320E-01, 1.7773440828E-01, 7.4563836503E-01],
	[2.1990000000E+04, 3.6528071735E+00, 3.2248955825E+00, 1.9845220595E-01, 1.7784587267E-01, 7.4570493770E-01],
	[2.1995000000E+04, 3.6540547522E+00, 3.2248003491E+00, 1.9858773033E-01, 1.7795737612E-01, 7.4577148025E-01],
	[2.2000000000E+04, 3.6553024733E+00, 3.2247051402E+00, 1.9872331636E-01, 1.7806891861E-01, 7.4583799267E-01],
	[2.2005000000E+04, 3.6565503367E+00, 3.2246099557E+00, 1.9885896405E-01, 1.7818050015E-01, 7.4590447498E-01],
	[2.2010000000E+04, 3.6577983425E+00, 3.2245147956E+00, 1.9899467341E-01, 1.7829212074E-01, 7.4597092720E-01],
	[2.2015000000E+04, 3.6590464907E+00, 3.2244196600E+00, 1.9913044446E-01, 1.7840378037E-01, 7.4603734932E-01],
	[2.2020000000E+04, 3.6602947811E+00, 3.2243245487E+00, 1.9926627722E-01, 1.7851547905E-01, 7.4610374137E-01],
	[2.2025000000E+04, 3.6615432138E+00, 3.2242294619E+00, 1.9940217169E-01, 1.7862721677E-01, 7.4617010336E-01],
	[2.2030000000E+04, 3.6627917889E+00, 3.2241343994E+00, 1.9953812789E-01, 1.7873899352E-01, 7.4623643529E-01],
	[2.2035000000E+04, 3.6640405062E+00, 3.2240393614E+00, 1.9967414584E-01, 1.7885080932E-01, 7.4630273718E-01],
	[2.2040000000E+04, 3.6652893657E+00, 3.2239443477E+00, 1.9981022554E-01, 1.7896266415E-01, 7.4636900903E-01],
	[2.2045000000E+04, 3.6665383675E+00, 3.2238493583E+00, 1.9994636701E-01, 1.7907455801E-01, 7.4643525087E-01],
	[2.2050000000E+04, 3.6677875115E+00, 3.2237543933E+00, 2.0008257028E-01, 1.7918649091E-01, 7.4650146269E-01],
	[2.2055000000E+04, 3.6690367977E+00, 3.2236594526E+00, 2.0021883534E-01, 1.7929846283E-01, 7.4656764452E-01],
	[2.2060000000E+04, 3.6702862261E+00, 3.2235645362E+00, 2.0035516221E-01, 1.7941047379E-01, 7.4663379635E-01],
	[2.2065000000E+04, 3.6715357967E+00, 3.2234696441E+00, 2.0049155092E-01, 1.7952252377E-01, 7.4669991821E-01],
	[2.2070000000E+04, 3.6727855094E+00, 3.2233747764E+00, 2.0062800146E-01, 1.7963461277E-01, 7.4676601011E-01],
	[2.2075000000E+04, 3.6740353642E+00, 3.2232799329E+00, 2.0076451386E-01, 1.7974674080E-01, 7.4683207204E-01],
	[2.2080000000E+04, 3.6752853612E+00, 3.2231851136E+00, 2.0090108814E-01, 1.7985890784E-01, 7.4689810404E-01],
	[2.2085000000E+04, 3.6765411082E+00, 3.2230931680E+00, 2.0103772429E-01, 1.7997113623E-01, 7.4696410610E-01],
	[2.2090000000E+04, 3.6777971433E+00, 3.2230013186E+00, 2.0117442235E-01, 1.8008340424E-01, 7.4703007824E-01],
	[2.2095000000E+04, 3.6790533231E+00, 3.2229094927E+00, 2.0131118231E-01, 1.8019571131E-01, 7.4709602047E-01],
	[2.2100000000E+04, 3.6803096475E+00, 3.2228176901E+00, 2.0144800420E-01, 1.8030805744E-01, 7.4716193280E-01],
	[2.2105000000E+04, 3.6815661166E+00, 3.2227259109E+00, 2.0158488804E-01, 1.8042044262E-01, 7.4722781524E-01],
	[2.2110000000E+04, 3.6828227304E+00, 3.2226341551E+00, 2.0172183382E-01, 1.8053286686E-01, 7.4729366780E-01],
	[2.2115000000E+04, 3.6840794888E+00, 3.2225424226E+00, 2.0185884157E-01, 1.8064533014E-01, 7.4735949050E-01],
	[2.2120000000E+04, 3.6853363918E+00, 3.2224507135E+00, 2.0199591131E-01, 1.8075783247E-01, 7.4742528334E-01],
	[2.2125000000E+04, 3.6865934394E+00, 3.2223590278E+00, 2.0213304304E-01, 1.8087037384E-01, 7.4749104634E-01],
	[2.2130000000E+04, 3.6878506315E+00, 3.2222673653E+00, 2.0227023678E-01, 1.8098295426E-01, 7.4755677950E-01],
	[2.2135000000E+04, 3.6891079683E+00, 3.2221757262E+00, 2.0240749254E-01, 1.8109557373E-01, 7.4762248285E-01],
	[2.2140000000E+04, 3.6903654495E+00, 3.2220841103E+00, 2.0254481035E-01, 1.8120823223E-01, 7.4768815638E-01],
	[2.2145000000E+04, 3.6916230754E+00, 3.2219925178E+00, 2.0268219020E-01, 1.8132092977E-01, 7.4775380011E-01],
	[2.2150000000E+04, 3.6928808457E+00, 3.2219009486E+00, 2.0281963212E-01, 1.8143366634E-01, 7.4781941405E-01],
	[2.2155000000E+04, 3.6941387605E+00, 3.2218094026E+00, 2.0295713612E-01, 1.8154644195E-01, 7.4788499822E-01],
	[2.2160000000E+04, 3.6953968198E+00, 3.2217178798E+00, 2.0309470221E-01, 1.8165925659E-01, 7.4795055262E-01],
	[2.2165000000E+04, 3.6966550236E+00, 3.2216263804E+00, 2.0323233041E-01, 1.8177211026E-01, 7.4801607726E-01],
	[2.2170000000E+04, 3.6979133719E+00, 3.2215349041E+00, 2.0337002074E-01, 1.8188500295E-01, 7.4808157216E-01],
	[2.2175000000E+04, 3.6991718645E+00, 3.2214434511E+00, 2.0350777319E-01, 1.8199793468E-01, 7.4814703733E-01],
	[2.2180000000E+04, 3.7004305016E+00, 3.2213520213E+00, 2.0364558780E-01, 1.8211090542E-01, 7.4821247278E-01],
	[2.2185000000E+04, 3.7016892831E+00, 3.2212606147E+00, 2.0378346457E-01, 1.8222391519E-01, 7.4827787851E-01],
	[2.2190000000E+04, 3.7029482090E+00, 3.2211692313E+00, 2.0392140352E-01, 1.8233696398E-01, 7.4834325455E-01],
	[2.2195000000E+04, 3.7042072793E+00, 3.2210778710E+00, 2.0405940466E-01, 1.8245005178E-01, 7.4840860089E-01],
	[2.2200000000E+04, 3.7054664939E+00, 3.2209865340E+00, 2.0419746800E-01, 1.8256317860E-01, 7.4847391756E-01],
	[2.2205000000E+04, 3.7067258528E+00, 3.2208952201E+00, 2.0433559357E-01, 1.8267634444E-01, 7.4853920457E-01],
	[2.2210000000E+04, 3.7079853561E+00, 3.2208039293E+00, 2.0447378137E-01, 1.8278954928E-01, 7.4860446192E-01],
	[2.2215000000E+04, 3.7092450037E+00, 3.2207126617E+00, 2.0461203141E-01, 1.8290279314E-01, 7.4866968962E-01],
	[2.2220000000E+04, 3.7105047955E+00, 3.2206214172E+00, 2.0475034372E-01, 1.8301607600E-01, 7.4873488770E-01],
	[2.2225000000E+04, 3.7117647317E+00, 3.2205301958E+00, 2.0488871830E-01, 1.8312939786E-01, 7.4880005615E-01],
	[2.2230000000E+04, 3.7130248121E+00, 3.2204389975E+00, 2.0502715517E-01, 1.8324275873E-01, 7.4886519499E-01],
	[2.2235000000E+04, 3.7142850368E+00, 3.2203478223E+00, 2.0516565435E-01, 1.8335615860E-01, 7.4893030424E-01],
	[2.2240000000E+04, 3.7155454057E+00, 3.2202566702E+00, 2.0530421584E-01, 1.8346959747E-01, 7.4899538389E-01],
	[2.2245000000E+04, 3.7168059187E+00, 3.2201655412E+00, 2.0544283966E-01, 1.8358307533E-01, 7.4906043397E-01],
	[2.2250000000E+04, 3.7180665760E+00, 3.2200744352E+00, 2.0558152583E-01, 1.8369659219E-01, 7.4912545448E-01],
	[2.2255000000E+04, 3.7193273775E+00, 3.2199833523E+00, 2.0572027436E-01, 1.8381014804E-01, 7.4919044544E-01],
	[2.2260000000E+04, 3.7205883232E+00, 3.2198922924E+00, 2.0585908526E-01, 1.8392374289E-01, 7.4925540686E-01],
	[2.2265000000E+04, 3.7218494129E+00, 3.2198012555E+00, 2.0599795854E-01, 1.8403737671E-01, 7.4932033875E-01],
	[2.2270000000E+04, 3.7231106469E+00, 3.2197102416E+00, 2.0613689423E-01, 1.8415104953E-01, 7.4938524111E-01],
	[2.2275000000E+04, 3.7243720249E+00, 3.2196192508E+00, 2.0627589234E-01, 1.8426476133E-01, 7.4945011397E-01],
	[2.2280000000E+04, 3.7256335470E+00, 3.2195282829E+00, 2.0641495287E-01, 1.8437851211E-01, 7.4951495733E-01],
	[2.2285000000E+04, 3.7268952133E+00, 3.2194373380E+00, 2.0655407585E-01, 1.8449230187E-01, 7.4957977120E-01],
	[2.2290000000E+04, 3.7281570236E+00, 3.2193464161E+00, 2.0669326128E-01, 1.8460613060E-01, 7.4964455559E-01],
	[2.2295000000E+04, 3.7294189779E+00, 3.2192555172E+00, 2.0683250918E-01, 1.8471999831E-01, 7.4970931053E-01],
	[2.2300000000E+04, 3.7306810763E+00, 3.2191646412E+00, 2.0697181957E-01, 1.8483390500E-01, 7.4977403600E-01],
	[2.2305000000E+04, 3.7319433187E+00, 3.2190737881E+00, 2.0711119246E-01, 1.8494785065E-01, 7.4983873204E-01],
	[2.2310000000E+04, 3.7332057051E+00, 3.2189829580E+00, 2.0725062786E-01, 1.8506183527E-01, 7.4990339865E-01],
	[2.2315000000E+04, 3.7344682355E+00, 3.2188921508E+00, 2.0739012579E-01, 1.8517585886E-01, 7.4996803584E-01],
	[2.2320000000E+04, 3.7357309099E+00, 3.2188013665E+00, 2.0752968626E-01, 1.8528992141E-01, 7.5003264361E-01],
	[2.2325000000E+04, 3.7369937282E+00, 3.2187106051E+00, 2.0766930928E-01, 1.8540402293E-01, 7.5009722200E-01],
	[2.2330000000E+04, 3.7382566905E+00, 3.2186198665E+00, 2.0780899487E-01, 1.8551816340E-01, 7.5016177099E-01],
	[2.2335000000E+04, 3.7395197967E+00, 3.2185291509E+00, 2.0794874305E-01, 1.8563234283E-01, 7.5022629062E-01],
	[2.2340000000E+04, 3.7407830468E+00, 3.2184384581E+00, 2.0808855382E-01, 1.8574656122E-01, 7.5029078088E-01],
	[2.2345000000E+04, 3.7420464408E+00, 3.2183477881E+00, 2.0822842720E-01, 1.8586081855E-01, 7.5035524179E-01],
	[2.2350000000E+04, 3.7433099787E+00, 3.2182571410E+00, 2.0836836321E-01, 1.8597511484E-01, 7.5041967335E-01],
	[2.2355000000E+04, 3.7445736605E+00, 3.2181665167E+00, 2.0850836186E-01, 1.8608945008E-01, 7.5048407559E-01],
	[2.2360000000E+04, 3.7458374861E+00, 3.2180759153E+00, 2.0864842315E-01, 1.8620382426E-01, 7.5054844852E-01],
	[2.2365000000E+04, 3.7471014555E+00, 3.2179853366E+00, 2.0878951728E-01, 1.8631900996E-01, 7.5061279213E-01],
	[2.2370000000E+04, 3.7483655688E+00, 3.2178947807E+00, 2.0893083321E-01, 1.8643436112E-01, 7.5067710645E-01],
	[2.2375000000E+04, 3.7496298258E+00, 3.2178042477E+00, 2.0907221310E-01, 1.8654975203E-01, 7.5074139149E-01],
	[2.2380000000E+04, 3.7508942266E+00, 3.2177137374E+00, 2.0921365697E-01, 1.8666518268E-01, 7.5080564725E-01],
	[2.2385000000E+04, 3.7521587712E+00, 3.2176232498E+00, 2.0935516484E-01, 1.8678065307E-01, 7.5086987375E-01],
	[2.2390000000E+04, 3.7534234596E+00, 3.2175327851E+00, 2.0949673671E-01, 1.8689616319E-01, 7.5093407100E-01],
	[2.2395000000E+04, 3.7546882917E+00, 3.2174423430E+00, 2.0963837262E-01, 1.8701171306E-01, 7.5099823902E-01],
	[2.2400000000E+04, 3.7559532675E+00, 3.2173519237E+00, 2.0978007256E-01, 1.8712730266E-01, 7.5106237780E-01],
	[2.2405000000E+04, 3.7572183870E+00, 3.2172615271E+00, 2.0992183655E-01, 1.8724293199E-01, 7.5112648737E-01],
	[2.2410000000E+04, 3.7584836502E+00, 3.2171711533E+00, 2.1006366462E-01, 1.8735860104E-01, 7.5119056774E-01],
	[2.2415000000E+04, 3.7597490571E+00, 3.2170808021E+00, 2.1020555677E-01, 1.8747430983E-01, 7.5125461890E-01],
	[2.2420000000E+04, 3.7610146077E+00, 3.2169904736E+00, 2.1034751302E-01, 1.8759005834E-01, 7.5131864088E-01],
	[2.2425000000E+04, 3.7622803018E+00, 3.2169001678E+00, 2.1048953337E-01, 1.8770584658E-01, 7.5138263369E-01],
	[2.2430000000E+04, 3.7635461397E+00, 3.2168098846E+00, 2.1063161786E-01, 1.8782167453E-01, 7.5144659732E-01],
	[2.2435000000E+04, 3.7648121211E+00, 3.2167196242E+00, 2.1077376649E-01, 1.8793754220E-01, 7.5151053180E-01],
	[2.2440000000E+04, 3.7660834094E+00, 3.2166319234E+00, 2.1091597927E-01, 1.8805347113E-01, 7.5157443713E-01],
	[2.2445000000E+04, 3.7673555275E+00, 3.2165445804E+00, 2.1105825623E-01, 1.8816944268E-01, 7.5163831332E-01],
	[2.2450000000E+04, 3.7686277917E+00, 3.2164572593E+00, 2.1120059737E-01, 1.8828545398E-01, 7.5170216039E-01],
	[2.2455000000E+04, 3.7699002022E+00, 3.2163699599E+00, 2.1134300271E-01, 1.8840150503E-01, 7.5176597834E-01],
	[2.2460000000E+04, 3.7711727588E+00, 3.2162826824E+00, 2.1148547227E-01, 1.8851759583E-01, 7.5182976718E-01],
	[2.2465000000E+04, 3.7724454616E+00, 3.2161954267E+00, 2.1162800605E-01, 1.8863372639E-01, 7.5189352693E-01],
	[2.2470000000E+04, 3.7737183105E+00, 3.2161081928E+00, 2.1177060408E-01, 1.8874989669E-01, 7.5195725759E-01],
	[2.2475000000E+04, 3.7749913055E+00, 3.2160209806E+00, 2.1191326637E-01, 1.8886610674E-01, 7.5202095918E-01],
	[2.2480000000E+04, 3.7762644466E+00, 3.2159337902E+00, 2.1205599293E-01, 1.8898235653E-01, 7.5208463170E-01],
	[2.2485000000E+04, 3.7775377339E+00, 3.2158466215E+00, 2.1219878378E-01, 1.8909864606E-01, 7.5214827517E-01],
	[2.2490000000E+04, 3.7788111672E+00, 3.2157594746E+00, 2.1234163893E-01, 1.8921497533E-01, 7.5221188959E-01],
	[2.2495000000E+04, 3.7800847466E+00, 3.2156723495E+00, 2.1248455840E-01, 1.8933134434E-01, 7.5227547498E-01],
	[2.2500000000E+04, 3.7813584720E+00, 3.2155852460E+00, 2.1262754220E-01, 1.8944775308E-01, 7.5233903134E-01],
	[2.2505000000E+04, 3.7826323434E+00, 3.2154981643E+00, 2.1277059035E-01, 1.8956420155E-01, 7.5240255869E-01],
	[2.2510000000E+04, 3.7839063609E+00, 3.2154111043E+00, 2.1291370286E-01, 1.8968068975E-01, 7.5246605703E-01],
	[2.2515000000E+04, 3.7851805243E+00, 3.2153240659E+00, 2.1305687974E-01, 1.8979721767E-01, 7.5252952638E-01],
	[2.2520000000E+04, 3.7864548337E+00, 3.2152370493E+00, 2.1320012102E-01, 1.8991378532E-01, 7.5259296675E-01],
	[2.2525000000E+04, 3.7877292891E+00, 3.2151500543E+00, 2.1334342670E-01, 1.9003039270E-01, 7.5265637814E-01],
	[2.2530000000E+04, 3.7890038905E+00, 3.2150630809E+00, 2.1348679679E-01, 1.9014703979E-01, 7.5271976057E-01],
	[2.2535000000E+04, 3.7902786378E+00, 3.2149761293E+00, 2.1363023133E-01, 1.9026372660E-01, 7.5278311405E-01],
	[2.2540000000E+04, 3.7915535310E+00, 3.2148891992E+00, 2.1377373031E-01, 1.9038045312E-01, 7.5284643858E-01],
	[2.2545000000E+04, 3.7928285701E+00, 3.2148022908E+00, 2.1391729375E-01, 1.9049721936E-01, 7.5290973418E-01],
	[2.2550000000E+04, 3.7941037551E+00, 3.2147154041E+00, 2.1406092167E-01, 1.9061402531E-01, 7.5297300086E-01],
	[2.2555000000E+04, 3.7953790859E+00, 3.2146285389E+00, 2.1420461409E-01, 1.9073087096E-01, 7.5303623863E-01],
	[2.2560000000E+04, 3.7966545627E+00, 3.2145416953E+00, 2.1434837101E-01, 1.9084775632E-01, 7.5309944750E-01],
	[2.2565000000E+04, 3.7979301852E+00, 3.2144548733E+00, 2.1449219245E-01, 1.9096468138E-01, 7.5316262748E-01],
	[2.2570000000E+04, 3.7992059536E+00, 3.2143680729E+00, 2.1463607843E-01, 1.9108164615E-01, 7.5322577858E-01],
	[2.2575000000E+04, 3.8004818678E+00, 3.2142812941E+00, 2.1478002896E-01, 1.9119865061E-01, 7.5328890080E-01],
	[2.2580000000E+04, 3.8017579278E+00, 3.2141945368E+00, 2.1492404405E-01, 1.9131569476E-01, 7.5335199417E-01],
	[2.2585000000E+04, 3.8030341336E+00, 3.2141078011E+00, 2.1506812373E-01, 1.9143277861E-01, 7.5341505869E-01],
	[2.2590000000E+04, 3.8043104851E+00, 3.2140210869E+00, 2.1521226800E-01, 1.9154990215E-01, 7.5347809436E-01],
	[2.2595000000E+04, 3.8055869824E+00, 3.2139343943E+00, 2.1535647688E-01, 1.9166706538E-01, 7.5354110121E-01],
	[2.2600000000E+04, 3.8068636254E+00, 3.2138477232E+00, 2.1550075038E-01, 1.9178426829E-01, 7.5360407924E-01],
	[2.2605000000E+04, 3.8081404141E+00, 3.2137610735E+00, 2.1564508852E-01, 1.9190151089E-01, 7.5366702846E-01],
	[2.2610000000E+04, 3.8094173485E+00, 3.2136744454E+00, 2.1578949132E-01, 1.9201879317E-01, 7.5372994889E-01],
	[2.2615000000E+04, 3.8106944286E+00, 3.2135878388E+00, 2.1593395878E-01, 1.9213611512E-01, 7.5379284052E-01],
	[2.2620000000E+04, 3.8119716544E+00, 3.2135012536E+00, 2.1607849093E-01, 1.9225347675E-01, 7.5385570338E-01],
	[2.2625000000E+04, 3.8132490259E+00, 3.2134146900E+00, 2.1622308777E-01, 1.9237087806E-01, 7.5391853748E-01],
	[2.2630000000E+04, 3.8145265429E+00, 3.2133281477E+00, 2.1636774932E-01, 1.9248831903E-01, 7.5398134281E-01],
	[2.2635000000E+04, 3.8158042056E+00, 3.2132416270E+00, 2.1651247560E-01, 1.9260579968E-01, 7.5404411940E-01],
	[2.2640000000E+04, 3.8170820139E+00, 3.2131551276E+00, 2.1665726662E-01, 1.9272331999E-01, 7.5410686726E-01],
	[2.2645000000E+04, 3.8183599678E+00, 3.2130686497E+00, 2.1680212240E-01, 1.9284087996E-01, 7.5416958639E-01],
	[2.2650000000E+04, 3.8196380673E+00, 3.2129821932E+00, 2.1694704294E-01, 1.9295847959E-01, 7.5423227680E-01],
	[2.2655000000E+04, 3.8209163123E+00, 3.2128957581E+00, 2.1709202827E-01, 1.9307611888E-01, 7.5429493851E-01],
	[2.2660000000E+04, 3.8221947029E+00, 3.2128093445E+00, 2.1723707840E-01, 1.9319379783E-01, 7.5435757153E-01],
	[2.2665000000E+04, 3.8234732390E+00, 3.2127229522E+00, 2.1738219335E-01, 1.9331151643E-01, 7.5442017587E-01],
	[2.2670000000E+04, 3.8247519206E+00, 3.2126365813E+00, 2.1752737312E-01, 1.9342927468E-01, 7.5448275153E-01],
	[2.2675000000E+04, 3.8260307477E+00, 3.2125502317E+00, 2.1767261774E-01, 1.9354707258E-01, 7.5454529852E-01],
	[2.2680000000E+04, 3.8273097203E+00, 3.2124639035E+00, 2.1781792721E-01, 1.9366491012E-01, 7.5460781687E-01],
	[2.2685000000E+04, 3.8285888383E+00, 3.2123775967E+00, 2.1796330155E-01, 1.9378278731E-01, 7.5467030657E-01],
	[2.2690000000E+04, 3.8298681018E+00, 3.2122913112E+00, 2.1810874079E-01, 1.9390070414E-01, 7.5473276765E-01],
	[2.2695000000E+04, 3.8311475108E+00, 3.2122050470E+00, 2.1825424492E-01, 1.9401866060E-01, 7.5479520010E-01],
	[2.2700000000E+04, 3.8324270651E+00, 3.2121188042E+00, 2.1839981397E-01, 1.9413665670E-01, 7.5485760394E-01],
	[2.2705000000E+04, 3.8337067649E+00, 3.2120325826E+00, 2.1854544795E-01, 1.9425469243E-01, 7.5491997918E-01],
	[2.2710000000E+04, 3.8349866101E+00, 3.2119463824E+00, 2.1869114688E-01, 1.9437276779E-01, 7.5498232584E-01],
	[2.2715000000E+04, 3.8362666006E+00, 3.2118602034E+00, 2.1883691076E-01, 1.9449088278E-01, 7.5504464391E-01],
	[2.2720000000E+04, 3.8375467365E+00, 3.2117740457E+00, 2.1898273962E-01, 1.9460903739E-01, 7.5510693341E-01],
	[2.2725000000E+04, 3.8388270177E+00, 3.2116879093E+00, 2.1912863347E-01, 1.9472723163E-01, 7.5516919436E-01],
	[2.2730000000E+04, 3.8401074443E+00, 3.2116017942E+00, 2.1927459233E-01, 1.9484546548E-01, 7.5523142676E-01],
	[2.2735000000E+04, 3.8413880161E+00, 3.2115157003E+00, 2.1942061620E-01, 1.9496373895E-01, 7.5529363062E-01],
	[2.2740000000E+04, 3.8426687333E+00, 3.2114296276E+00, 2.1956670510E-01, 1.9508205204E-01, 7.5535580596E-01],
	[2.2745000000E+04, 3.8439495957E+00, 3.2113435762E+00, 2.1971285906E-01, 1.9520040473E-01, 7.5541795278E-01],
	[2.2750000000E+04, 3.8452306035E+00, 3.2112575460E+00, 2.1985907807E-01, 1.9531879704E-01, 7.5548007110E-01],
	[2.2755000000E+04, 3.8465117564E+00, 3.2111715370E+00, 2.2000536216E-01, 1.9543722895E-01, 7.5554216091E-01],
	[2.2760000000E+04, 3.8477930546E+00, 3.2110855492E+00, 2.2015171134E-01, 1.9555570046E-01, 7.5560422225E-01],
	[2.2765000000E+04, 3.8490744980E+00, 3.2109995826E+00, 2.2029812563E-01, 1.9567421157E-01, 7.5566625511E-01],
	[2.2770000000E+04, 3.8503560866E+00, 3.2109136372E+00, 2.2044460504E-01, 1.9579276229E-01, 7.5572825951E-01],
	[2.2775000000E+04, 3.8516378204E+00, 3.2108277129E+00, 2.2059114959E-01, 1.9591135259E-01, 7.5579023546E-01],
	[2.2780000000E+04, 3.8529196994E+00, 3.2107418098E+00, 2.2073775928E-01, 1.9602998249E-01, 7.5585218296E-01],
	[2.2785000000E+04, 3.8542017236E+00, 3.2106559278E+00, 2.2088443414E-01, 1.9614865198E-01, 7.5591410203E-01],
	[2.2790000000E+04, 3.8554838928E+00, 3.2105700670E+00, 2.2103117418E-01, 1.9626736106E-01, 7.5597599268E-01],
	[2.2795000000E+04, 3.8567662072E+00, 3.2104842274E+00, 2.2117797942E-01, 1.9638610972E-01, 7.5603785492E-01],
	[2.2800000000E+04, 3.8580525103E+00, 3.2104002354E+00, 2.2132484986E-01, 1.9650491477E-01, 7.5609968876E-01],
	[2.2805000000E+04, 3.8593410614E+00, 3.2103172621E+00, 2.2147178552E-01, 1.9662376864E-01, 7.5616149421E-01],
	[2.2810000000E+04, 3.8606297602E+00, 3.2102343093E+00, 2.2161878642E-01, 1.9674266212E-01, 7.5622327128E-01],
	[2.2815000000E+04, 3.8619186067E+00, 3.2101513767E+00, 2.2176585258E-01, 1.9686159523E-01, 7.5628501998E-01],
	[2.2820000000E+04, 3.8632076010E+00, 3.2100684645E+00, 2.2191298400E-01, 1.9698056796E-01, 7.5634674033E-01],
	[2.2825000000E+04, 3.8644967429E+00, 3.2099855725E+00, 2.2206018070E-01, 1.9709958030E-01, 7.5640843233E-01],
	[2.2830000000E+04, 3.8657860325E+00, 3.2099027009E+00, 2.2220744270E-01, 1.9721863225E-01, 7.5647009599E-01],
	[2.2835000000E+04, 3.8670754698E+00, 3.2098198495E+00, 2.2235477001E-01, 1.9733772382E-01, 7.5653173132E-01],
	[2.2840000000E+04, 3.8683650547E+00, 3.2097370184E+00, 2.2250216264E-01, 1.9745685499E-01, 7.5659333834E-01],
	[2.2845000000E+04, 3.8696547872E+00, 3.2096542076E+00, 2.2264962062E-01, 1.9757602577E-01, 7.5665491706E-01],
	[2.2850000000E+04, 3.8709446674E+00, 3.2095714171E+00, 2.2279714394E-01, 1.9769523614E-01, 7.5671646748E-01],
	[2.2855000000E+04, 3.8722346951E+00, 3.2094886468E+00, 2.2294473264E-01, 1.9781448612E-01, 7.5677798962E-01],
	[2.2860000000E+04, 3.8735248705E+00, 3.2094058967E+00, 2.2309238672E-01, 1.9793377569E-01, 7.5683948348E-01],
	[2.2865000000E+04, 3.8748151934E+00, 3.2093231669E+00, 2.2324010620E-01, 1.9805310486E-01, 7.5690094908E-01],
	[2.2870000000E+04, 3.8761056638E+00, 3.2092404573E+00, 2.2338789110E-01, 1.9817247361E-01, 7.5696238643E-01],
	[2.2875000000E+04, 3.8773962818E+00, 3.2091577679E+00, 2.2353574142E-01, 1.9829188196E-01, 7.5702379554E-01],
	[2.2880000000E+04, 3.8786870474E+00, 3.2090750987E+00, 2.2368365718E-01, 1.9841132989E-01, 7.5708517642E-01],
	[2.2885000000E+04, 3.8799779604E+00, 3.2089924497E+00, 2.2383163840E-01, 1.9853081740E-01, 7.5714652908E-01],
	[2.2890000000E+04, 3.8812690209E+00, 3.2089098208E+00, 2.2397968509E-01, 1.9865034449E-01, 7.5720785353E-01],
	[2.2895000000E+04, 3.8825602289E+00, 3.2088272122E+00, 2.2412779726E-01, 1.9876991116E-01, 7.5726914978E-01],
	[2.2900000000E+04, 3.8838515843E+00, 3.2087446237E+00, 2.2427597494E-01, 1.9888951740E-01, 7.5733041784E-01],
	[2.2905000000E+04, 3.8851430872E+00, 3.2086620554E+00, 2.2442421813E-01, 1.9900916321E-01, 7.5739165773E-01],
	[2.2910000000E+04, 3.8864347376E+00, 3.2085795072E+00, 2.2457252686E-01, 1.9912884859E-01, 7.5745286945E-01],
	[2.2915000000E+04, 3.8877265353E+00, 3.2084969791E+00, 2.2472090112E-01, 1.9924857354E-01, 7.5751405301E-01],
	[2.2920000000E+04, 3.8890184804E+00, 3.2084144712E+00, 2.2486934095E-01, 1.9936833805E-01, 7.5757520843E-01],
	[2.2925000000E+04, 3.8903105730E+00, 3.2083319834E+00, 2.2501784635E-01, 1.9948814211E-01, 7.5763633571E-01],
	[2.2930000000E+04, 3.8916028128E+00, 3.2082495157E+00, 2.2516641734E-01, 1.9960798574E-01, 7.5769743487E-01],
	[2.2935000000E+04, 3.8928952001E+00, 3.2081670681E+00, 2.2531505393E-01, 1.9972786891E-01, 7.5775850591E-01],
	[2.2940000000E+04, 3.8941877347E+00, 3.2080846406E+00, 2.2546375614E-01, 1.9984779164E-01, 7.5781954886E-01],
	[2.2945000000E+04, 3.8954804166E+00, 3.2080022332E+00, 2.2561252398E-01, 1.9996775392E-01, 7.5788056371E-01],
	[2.2950000000E+04, 3.8967732458E+00, 3.2079198459E+00, 2.2576135746E-01, 2.0008775574E-01, 7.5794155048E-01],
	[2.2955000000E+04, 3.8980662223E+00, 3.2078374786E+00, 2.2591025661E-01, 2.0020779711E-01, 7.5800250918E-01],
	[2.2960000000E+04, 3.8993593461E+00, 3.2077551313E+00, 2.2605922144E-01, 2.0032787801E-01, 7.5806343982E-01],
	[2.2965000000E+04, 3.9006526171E+00, 3.2076728042E+00, 2.2620825195E-01, 2.0044799845E-01, 7.5812434241E-01],
	[2.2970000000E+04, 3.9019460354E+00, 3.2075904970E+00, 2.2635734817E-01, 2.0056815842E-01, 7.5818521696E-01],
	[2.2975000000E+04, 3.9032396009E+00, 3.2075082099E+00, 2.2650651012E-01, 2.0068835792E-01, 7.5824606349E-01],
	[2.2980000000E+04, 3.9045333136E+00, 3.2074259428E+00, 2.2665573779E-01, 2.0080859696E-01, 7.5830688200E-01],
	[2.2985000000E+04, 3.9058271735E+00, 3.2073436957E+00, 2.2680503121E-01, 2.0092887551E-01, 7.5836767250E-01],
	[2.2990000000E+04, 3.9071211807E+00, 3.2072614686E+00, 2.2695439040E-01, 2.0104919359E-01, 7.5842843501E-01],
	[2.2995000000E+04, 3.9084153349E+00, 3.2071792614E+00, 2.2710381537E-01, 2.0116955119E-01, 7.5848916953E-01],
	[2.3000000000E+04, 3.9097096364E+00, 3.2070970743E+00, 2.2725330613E-01, 2.0128994830E-01, 7.5854987607E-01],
	[2.3005000000E+04, 3.9110040849E+00, 3.2070149071E+00, 2.2740286269E-01, 2.0141038492E-01, 7.5861055466E-01],
	[2.3010000000E+04, 3.9122986806E+00, 3.2069327599E+00, 2.2755248508E-01, 2.0153086106E-01, 7.5867120529E-01],
	[2.3015000000E+04, 3.9135934235E+00, 3.2068506327E+00, 2.2770217331E-01, 2.0165137670E-01, 7.5873182798E-01],
	[2.3020000000E+04, 3.9148883134E+00, 3.2067685253E+00, 2.2785192738E-01, 2.0177193184E-01, 7.5879242274E-01],
	[2.3025000000E+04, 3.9161833503E+00, 3.2066864380E+00, 2.2800174733E-01, 2.0189252649E-01, 7.5885298958E-01],
	[2.3030000000E+04, 3.9174785344E+00, 3.2066043705E+00, 2.2815163315E-01, 2.0201316064E-01, 7.5891352851E-01],
	[2.3035000000E+04, 3.9187738655E+00, 3.2065223230E+00, 2.2830158487E-01, 2.0213383427E-01, 7.5897403954E-01],
	[2.3040000000E+04, 3.9200693436E+00, 3.2064402953E+00, 2.2845160250E-01, 2.0225454741E-01, 7.5903452268E-01],
	[2.3045000000E+04, 3.9213649687E+00, 3.2063582876E+00, 2.2860168605E-01, 2.0237530003E-01, 7.5909497794E-01],
	[2.3050000000E+04, 3.9226607408E+00, 3.2062762998E+00, 2.2875183554E-01, 2.0249609213E-01, 7.5915540534E-01],
	[2.3055000000E+04, 3.9239566600E+00, 3.2061943318E+00, 2.2890205099E-01, 2.0261692372E-01, 7.5921580488E-01],
	[2.3060000000E+04, 3.9252527261E+00, 3.2061123837E+00, 2.2905233240E-01, 2.0273779479E-01, 7.5927617658E-01],
	[2.3065000000E+04, 3.9265489391E+00, 3.2060304554E+00, 2.2920267980E-01, 2.0285870533E-01, 7.5933652045E-01],
	[2.3070000000E+04, 3.9278452991E+00, 3.2059485470E+00, 2.2935309319E-01, 2.0297965535E-01, 7.5939683649E-01],
	[2.3075000000E+04, 3.9291418060E+00, 3.2058666585E+00, 2.2950357260E-01, 2.0310064484E-01, 7.5945712471E-01],
	[2.3080000000E+04, 3.9304384598E+00, 3.2057847898E+00, 2.2965411803E-01, 2.0322167380E-01, 7.5951738514E-01],
	[2.3085000000E+04, 3.9317352606E+00, 3.2057029409E+00, 2.2980472951E-01, 2.0334274222E-01, 7.5957761777E-01],
	[2.3090000000E+04, 3.9330322082E+00, 3.2056211118E+00, 2.2995540704E-01, 2.0346385010E-01, 7.5963782263E-01],
	[2.3095000000E+04, 3.9343293026E+00, 3.2055393025E+00, 2.3010615064E-01, 2.0358499744E-01, 7.5969799971E-01],
	[2.3100000000E+04, 3.9356265440E+00, 3.2054575131E+00, 2.3025696033E-01, 2.0370618424E-01, 7.5975814904E-01],
	[2.3105000000E+04, 3.9369239321E+00, 3.2053757434E+00, 2.3040783611E-01, 2.0382741049E-01, 7.5981827062E-01],
	[2.3110000000E+04, 3.9382214671E+00, 3.2052939935E+00, 2.3055877801E-01, 2.0394867618E-01, 7.5987836446E-01],
	[2.3115000000E+04, 3.9395191488E+00, 3.2052122633E+00, 2.3070978604E-01, 2.0406998133E-01, 7.5993843057E-01],
	[2.3120000000E+04, 3.9408169774E+00, 3.2051305530E+00, 2.3086086022E-01, 2.0419132591E-01, 7.5999846897E-01],
	[2.3125000000E+04, 3.9421149528E+00, 3.2050488623E+00, 2.3101200055E-01, 2.0431270994E-01, 7.6005847967E-01],
	[2.3130000000E+04, 3.9434130748E+00, 3.2049671915E+00, 2.3116320705E-01, 2.0443413340E-01, 7.6011846267E-01],
	[2.3135000000E+04, 3.9447113437E+00, 3.2048855403E+00, 2.3131447975E-01, 2.0455559630E-01, 7.6017841799E-01],
	[2.3140000000E+04, 3.9460097593E+00, 3.2048039089E+00, 2.3146581864E-01, 2.0467709862E-01, 7.6023834564E-01],
	[2.3145000000E+04, 3.9473083215E+00, 3.2047222972E+00, 2.3161722375E-01, 2.0479864037E-01, 7.6029824562E-01],
	[2.3150000000E+04, 3.9486070305E+00, 3.2046407052E+00, 2.3176869510E-01, 2.0492022155E-01, 7.6035811796E-01],
	[2.3155000000E+04, 3.9499058862E+00, 3.2045591329E+00, 2.3192023268E-01, 2.0504184215E-01, 7.6041796265E-01],
	[2.3160000000E+04, 3.9512048885E+00, 3.2044775802E+00, 2.3207183653E-01, 2.0516350216E-01, 7.6047777972E-01],
	[2.3165000000E+04, 3.9525055315E+00, 3.2043967340E+00, 2.3222350666E-01, 2.0528520844E-01, 7.6053756917E-01],
	[2.3170000000E+04, 3.9538108720E+00, 3.2043179981E+00, 2.3237524307E-01, 2.0540697501E-01, 7.6059733101E-01],
	[2.3175000000E+04, 3.9551163619E+00, 3.2042392810E+00, 2.3252704579E-01, 2.0552878104E-01, 7.6065706526E-01],
	[2.3180000000E+04, 3.9564220010E+00, 3.2041605829E+00, 2.3267891483E-01, 2.0565062653E-01, 7.6071677192E-01],
	[2.3185000000E+04, 3.9577277894E+00, 3.2040819037E+00, 2.3283085020E-01, 2.0577251146E-01, 7.6077645100E-01],
	[2.3190000000E+04, 3.9590337270E+00, 3.2040032434E+00, 2.3298285192E-01, 2.0589443585E-01, 7.6083610253E-01],
	[2.3195000000E+04, 3.9603398139E+00, 3.2039246020E+00, 2.3313492000E-01, 2.0601639968E-01, 7.6089572650E-01],
	[2.3200000000E+04, 3.9616460500E+00, 3.2038459794E+00, 2.3328705446E-01, 2.0613840295E-01, 7.6095532292E-01],
	[2.3205000000E+04, 3.9629524354E+00, 3.2037673757E+00, 2.3343925532E-01, 2.0626044566E-01, 7.6101489182E-01],
	[2.3210000000E+04, 3.9642589699E+00, 3.2036887909E+00, 2.3359152258E-01, 2.0638252780E-01, 7.6107443320E-01],
	[2.3215000000E+04, 3.9655656536E+00, 3.2036102250E+00, 2.3374385626E-01, 2.0650464938E-01, 7.6113394707E-01],
	[2.3220000000E+04, 3.9668724864E+00, 3.2035316778E+00, 2.3389625637E-01, 2.0662681038E-01, 7.6119343344E-01],
	[2.3225000000E+04, 3.9681794685E+00, 3.2034531496E+00, 2.3404872294E-01, 2.0674901082E-01, 7.6125289232E-01],
	[2.3230000000E+04, 3.9694865996E+00, 3.2033746401E+00, 2.3420125597E-01, 2.0687125067E-01, 7.6131232373E-01],
	[2.3235000000E+04, 3.9707938799E+00, 3.2032961495E+00, 2.3435385549E-01, 2.0699352994E-01, 7.6137172767E-01],
	[2.3240000000E+04, 3.9721013092E+00, 3.2032176777E+00, 2.3450652149E-01, 2.0711584863E-01, 7.6143110415E-01],
	[2.3245000000E+04, 3.9734088877E+00, 3.2031392246E+00, 2.3465925401E-01, 2.0723820673E-01, 7.6149045319E-01],
	[2.3250000000E+04, 3.9747166152E+00, 3.2030607904E+00, 2.3481205305E-01, 2.0736060425E-01, 7.6154977480E-01],
	[2.3255000000E+04, 3.9760244918E+00, 3.2029823750E+00, 2.3496491863E-01, 2.0748304116E-01, 7.6160906899E-01],
	[2.3260000000E+04, 3.9773325174E+00, 3.2029039783E+00, 2.3511785076E-01, 2.0760551749E-01, 7.6166833577E-01],
	[2.3265000000E+04, 3.9786406921E+00, 3.2028256004E+00, 2.3527084946E-01, 2.0772803321E-01, 7.6172757514E-01],
	[2.3270000000E+04, 3.9799490158E+00, 3.2027472413E+00, 2.3542391474E-01, 2.0785058832E-01, 7.6178678713E-01],
	[2.3275000000E+04, 3.9812574885E+00, 3.2026689009E+00, 2.3557704661E-01, 2.0797318283E-01, 7.6184597174E-01],
	[2.3280000000E+04, 3.9825661101E+00, 3.2025905793E+00, 2.3573024510E-01, 2.0809581673E-01, 7.6190512898E-01],
	[2.3285000000E+04, 3.9838748807E+00, 3.2025122764E+00, 2.3588351022E-01, 2.0821849002E-01, 7.6196425886E-01],
	[2.3290000000E+04, 3.9851838003E+00, 3.2024339922E+00, 2.3603684197E-01, 2.0834120269E-01, 7.6202336140E-01],
	[2.3295000000E+04, 3.9864928688E+00, 3.2023557268E+00, 2.3619024038E-01, 2.0846395474E-01, 7.6208243660E-01],
	[2.3300000000E+04, 3.9878020863E+00, 3.2022774800E+00, 2.3634370547E-01, 2.0858674617E-01, 7.6214148448E-01],
	[2.3305000000E+04, 3.9891114526E+00, 3.2021992520E+00, 2.3649723723E-01, 2.0870957697E-01, 7.6220050505E-01],
	[2.3310000000E+04, 3.9904209679E+00, 3.2021210426E+00, 2.3665083570E-01, 2.0883244714E-01, 7.6225949832E-01],
	[2.3315000000E+04, 3.9917306320E+00, 3.2020428520E+00, 2.3680450087E-01, 2.0895535667E-01, 7.6231846429E-01],
	[2.3320000000E+04, 3.9930404450E+00, 3.2019646800E+00, 2.3695823278E-01, 2.0907830557E-01, 7.6237740298E-01],
	[2.3325000000E+04, 3.9943504068E+00, 3.2018865266E+00, 2.3711203143E-01, 2.0920129383E-01, 7.6243631441E-01],
	[2.3330000000E+04, 3.9956605175E+00, 3.2018083920E+00, 2.3726589684E-01, 2.0932432145E-01, 7.6249519858E-01],
	[2.3335000000E+04, 3.9969707769E+00, 3.2017302759E+00, 2.3741982902E-01, 2.0944738842E-01, 7.6255405550E-01],
	[2.3340000000E+04, 3.9982811852E+00, 3.2016521786E+00, 2.3757382798E-01, 2.0957049474E-01, 7.6261288518E-01],
	[2.3345000000E+04, 3.9995917423E+00, 3.2015740998E+00, 2.3772789375E-01, 2.0969364040E-01, 7.6267168764E-01],
	[2.3350000000E+04, 4.0009024481E+00, 3.2014960397E+00, 2.3788202633E-01, 2.0981682541E-01, 7.6273046289E-01],
	[2.3355000000E+04, 4.0022133028E+00, 3.2014179982E+00, 2.3803622575E-01, 2.0994004976E-01, 7.6278921093E-01],
	[2.3360000000E+04, 4.0035243061E+00, 3.2013399753E+00, 2.3819049201E-01, 2.1006331345E-01, 7.6284793178E-01],
	[2.3365000000E+04, 4.0048354582E+00, 3.2012619710E+00, 2.3834482513E-01, 2.1018661647E-01, 7.6290662544E-01],
	[2.3370000000E+04, 4.0061467590E+00, 3.2011839853E+00, 2.3849922512E-01, 2.1030995881E-01, 7.6296529194E-01],
	[2.3375000000E+04, 4.0074582085E+00, 3.2011060182E+00, 2.3865369201E-01, 2.1043334049E-01, 7.6302393128E-01],
	[2.3380000000E+04, 4.0087698066E+00, 3.2010280696E+00, 2.3880822579E-01, 2.1055676149E-01, 7.6308254347E-01],
	[2.3385000000E+04, 4.0100815535E+00, 3.2009501396E+00, 2.3896282650E-01, 2.1068022180E-01, 7.6314112852E-01],
	[2.3390000000E+04, 4.0113934490E+00, 3.2008722282E+00, 2.3911749414E-01, 2.1080372143E-01, 7.6319968644E-01],
	[2.3395000000E+04, 4.0127054931E+00, 3.2007943353E+00, 2.3927222872E-01, 2.1092726038E-01, 7.6325821725E-01],
	[2.3400000000E+04, 4.0140176859E+00, 3.2007164610E+00, 2.3942703027E-01, 2.1105083863E-01, 7.6331672096E-01],
	[2.3405000000E+04, 4.0153300272E+00, 3.2006386052E+00, 2.3958189880E-01, 2.1117445619E-01, 7.6337519757E-01],
	[2.3410000000E+04, 4.0166425172E+00, 3.2005607679E+00, 2.3973683431E-01, 2.1129811305E-01, 7.6343364710E-01],
	[2.3415000000E+04, 4.0179551557E+00, 3.2004829491E+00, 2.3989183684E-01, 2.1142180921E-01, 7.6349206956E-01],
	[2.3420000000E+04, 4.0192679428E+00, 3.2004051489E+00, 2.4004690638E-01, 2.1154554466E-01, 7.6355046495E-01],
	[2.3425000000E+04, 4.0205808785E+00, 3.2003273671E+00, 2.4020204296E-01, 2.1166931941E-01, 7.6360883330E-01],
	[2.3430000000E+04, 4.0218939627E+00, 3.2002496038E+00, 2.4035724659E-01, 2.1179313344E-01, 7.6366717461E-01],
	[2.3435000000E+04, 4.0232071954E+00, 3.2001718590E+00, 2.4051251728E-01, 2.1191698676E-01, 7.6372548889E-01],
	[2.3440000000E+04, 4.0245205766E+00, 3.2000941327E+00, 2.4066785505E-01, 2.1204087936E-01, 7.6378377615E-01],
	[2.3445000000E+04, 4.0258341063E+00, 3.2000164249E+00, 2.4082325992E-01, 2.1216481124E-01, 7.6384203641E-01],
	[2.3450000000E+04, 4.0271477845E+00, 3.1999387355E+00, 2.4097873190E-01, 2.1228878239E-01, 7.6390026968E-01],
	[2.3455000000E+04, 4.0284616111E+00, 3.1998610645E+00, 2.4113427099E-01, 2.1241279281E-01, 7.6395847596E-01],
	[2.3460000000E+04, 4.0297755862E+00, 3.1997834120E+00, 2.4128987723E-01, 2.1253684250E-01, 7.6401665527E-01],
	[2.3465000000E+04, 4.0310897097E+00, 3.1997057780E+00, 2.4144555062E-01, 2.1266093145E-01, 7.6407480761E-01],
	[2.3470000000E+04, 4.0324039816E+00, 3.1996281623E+00, 2.4160129117E-01, 2.1278505967E-01, 7.6413293301E-01],
	[2.3475000000E+04, 4.0337184019E+00, 3.1995505651E+00, 2.4175709891E-01, 2.1290922713E-01, 7.6419103146E-01],
	[2.3480000000E+04, 4.0350329706E+00, 3.1994729863E+00, 2.4191297384E-01, 2.1303343386E-01, 7.6424910299E-01],
	[2.3485000000E+04, 4.0363476877E+00, 3.1993954258E+00, 2.4206891598E-01, 2.1315767983E-01, 7.6430714760E-01],
	[2.3490000000E+04, 4.0376625532E+00, 3.1993178838E+00, 2.4222492535E-01, 2.1328196504E-01, 7.6436516531E-01],
	[2.3495000000E+04, 4.0389775669E+00, 3.1992403601E+00, 2.4238100196E-01, 2.1340628950E-01, 7.6442315611E-01],
	[2.3500000000E+04, 4.0402927291E+00, 3.1991628549E+00, 2.4253714583E-01, 2.1353065320E-01, 7.6448112004E-01],
	[2.3505000000E+04, 4.0416080395E+00, 3.1990853679E+00, 2.4269335696E-01, 2.1365505613E-01, 7.6453905709E-01],
	[2.3510000000E+04, 4.0429234982E+00, 3.1990078994E+00, 2.4284963538E-01, 2.1377949829E-01, 7.6459696728E-01],
	[2.3515000000E+04, 4.0442391052E+00, 3.1989304492E+00, 2.4300598109E-01, 2.1390397969E-01, 7.6465485061E-01],
	[2.3520000000E+04, 4.0455548604E+00, 3.1988530173E+00, 2.4316239412E-01, 2.1402850030E-01, 7.6471270711E-01],
	[2.3525000000E+04, 4.0468707639E+00, 3.1987756038E+00, 2.4331887447E-01, 2.1415306014E-01, 7.6477053678E-01],
	[2.3530000000E+04, 4.0481868157E+00, 3.1986982086E+00, 2.4347542217E-01, 2.1427765919E-01, 7.6482833963E-01],
	[2.3535000000E+04, 4.0495030157E+00, 3.1986208317E+00, 2.4363203723E-01, 2.1440229746E-01, 7.6488611567E-01],
	[2.3540000000E+04, 4.0508234579E+00, 3.1985452927E+00, 2.4378871966E-01, 2.1452699460E-01, 7.6494386491E-01],
	[2.3545000000E+04, 4.0521461017E+00, 3.1984706832E+00, 2.4394546947E-01, 2.1465174085E-01, 7.6500158737E-01],
	[2.3550000000E+04, 4.0534688965E+00, 3.1983960912E+00, 2.4410228668E-01, 2.1477652635E-01, 7.6505928306E-01],
	[2.3555000000E+04, 4.0547918421E+00, 3.1983215169E+00, 2.4425917131E-01, 2.1490135110E-01, 7.6511695198E-01],
	[2.3560000000E+04, 4.0561149386E+00, 3.1982469600E+00, 2.4441612337E-01, 2.1502621510E-01, 7.6517459415E-01],
	[2.3565000000E+04, 4.0574381859E+00, 3.1981724208E+00, 2.4457314288E-01, 2.1515111834E-01, 7.6523220959E-01],
	[2.3570000000E+04, 4.0587615840E+00, 3.1980978991E+00, 2.4473022984E-01, 2.1527606082E-01, 7.6528979829E-01],
	[2.3575000000E+04, 4.0600851329E+00, 3.1980233949E+00, 2.4488738428E-01, 2.1540104254E-01, 7.6534736027E-01],
	[2.3580000000E+04, 4.0614088326E+00, 3.1979489083E+00, 2.4504460620E-01, 2.1552606349E-01, 7.6540489554E-01],
	[2.3585000000E+04, 4.0627326831E+00, 3.1978744392E+00, 2.4520189563E-01, 2.1565112367E-01, 7.6546240412E-01],
	[2.3590000000E+04, 4.0640566843E+00, 3.1977999876E+00, 2.4535925258E-01, 2.1577622307E-01, 7.6551988601E-01],
	[2.3595000000E+04, 4.0653808363E+00, 3.1977255536E+00, 2.4551667706E-01, 2.1590136170E-01, 7.6557734123E-01],
	[2.3600000000E+04, 4.0667051390E+00, 3.1976511370E+00, 2.4567416908E-01, 2.1602653954E-01, 7.6563476978E-01],
	[2.3605000000E+04, 4.0680295924E+00, 3.1975767379E+00, 2.4583172867E-01, 2.1615175660E-01, 7.6569217169E-01],
	[2.3610000000E+04, 4.0693541965E+00, 3.1975023563E+00, 2.4598935584E-01, 2.1627701287E-01, 7.6574954695E-01],
	[2.3615000000E+04, 4.0706789513E+00, 3.1974279922E+00, 2.4614705059E-01, 2.1640230834E-01, 7.6580689558E-01],
	[2.3620000000E+04, 4.0720038568E+00, 3.1973536456E+00, 2.4630481295E-01, 2.1652764302E-01, 7.6586421759E-01],
	[2.3625000000E+04, 4.0733289129E+00, 3.1972793165E+00, 2.4646264293E-01, 2.1665301689E-01, 7.6592151299E-01],
	[2.3630000000E+04, 4.0746541197E+00, 3.1972050047E+00, 2.4662054055E-01, 2.1677842997E-01, 7.6597878179E-01],
	[2.3635000000E+04, 4.0759794771E+00, 3.1971307105E+00, 2.4677850582E-01, 2.1690388223E-01, 7.6603602401E-01],
	[2.3640000000E+04, 4.0773049851E+00, 3.1970564337E+00, 2.4693653874E-01, 2.1702937368E-01, 7.6609323966E-01],
	[2.3645000000E+04, 4.0786306437E+00, 3.1969821743E+00, 2.4709463935E-01, 2.1715490432E-01, 7.6615042874E-01],
	[2.3650000000E+04, 4.0799564528E+00, 3.1969079323E+00, 2.4725280765E-01, 2.1728047414E-01, 7.6620759127E-01],
	[2.3655000000E+04, 4.0812824126E+00, 3.1968337078E+00, 2.4741104366E-01, 2.1740608313E-01, 7.6626472725E-01],
	[2.3660000000E+04, 4.0826085228E+00, 3.1967595007E+00, 2.4756934739E-01, 2.1753173130E-01, 7.6632183671E-01],
	[2.3665000000E+04, 4.0839347837E+00, 3.1966853109E+00, 2.4772771886E-01, 2.1765741864E-01, 7.6637891965E-01],
	[2.3670000000E+04, 4.0852611950E+00, 3.1966111386E+00, 2.4788615808E-01, 2.1778314514E-01, 7.6643597607E-01],
	[2.3675000000E+04, 4.0865877569E+00, 3.1965369837E+00, 2.4804466507E-01, 2.1790891081E-01, 7.6649300601E-01],
	[2.3680000000E+04, 4.0879144692E+00, 3.1964628461E+00, 2.4820323984E-01, 2.1803471563E-01, 7.6655000945E-01],
	[2.3685000000E+04, 4.0892413320E+00, 3.1963887259E+00, 2.4836188240E-01, 2.1816055961E-01, 7.6660698642E-01],
	[2.3690000000E+04, 4.0905683453E+00, 3.1963146231E+00, 2.4852059277E-01, 2.1828644273E-01, 7.6666393693E-01],
	[2.3695000000E+04, 4.0918955091E+00, 3.1962405376E+00, 2.4867937097E-01, 2.1841236501E-01, 7.6672086098E-01],
	[2.3700000000E+04, 4.0932228232E+00, 3.1961664695E+00, 2.4883821701E-01, 2.1853832643E-01, 7.6677775859E-01],
	[2.3705000000E+04, 4.0945502878E+00, 3.1960924187E+00, 2.4899713090E-01, 2.1866432699E-01, 7.6683462977E-01],
	[2.3710000000E+04, 4.0958779028E+00, 3.1960183852E+00, 2.4915611266E-01, 2.1879036668E-01, 7.6689147453E-01],
	[2.3715000000E+04, 4.0972056682E+00, 3.1959443691E+00, 2.4931516231E-01, 2.1891644550E-01, 7.6694829288E-01],
	[2.3720000000E+04, 4.0985335839E+00, 3.1958703703E+00, 2.4947427985E-01, 2.1904256346E-01, 7.6700508484E-01],
	[2.3725000000E+04, 4.0998616500E+00, 3.1957963888E+00, 2.4963346530E-01, 2.1916872053E-01, 7.6706185040E-01],
	[2.3730000000E+04, 4.1011898665E+00, 3.1957224246E+00, 2.4979271868E-01, 2.1929491673E-01, 7.6711858960E-01],
	[2.3735000000E+04, 4.1025182333E+00, 3.1956484777E+00, 2.4995204001E-01, 2.1942115204E-01, 7.6717530242E-01],
	[2.3740000000E+04, 4.1038467504E+00, 3.1955745480E+00, 2.5011142929E-01, 2.1954742647E-01, 7.6723198890E-01],
	[2.3745000000E+04, 4.1051754178E+00, 3.1955006357E+00, 2.5027088654E-01, 2.1967374000E-01, 7.6728864903E-01],
	[2.3750000000E+04, 4.1065042355E+00, 3.1954267406E+00, 2.5043041177E-01, 2.1980009264E-01, 7.6734528284E-01],
	[2.3755000000E+04, 4.1078332034E+00, 3.1953528628E+00, 2.5059000501E-01, 2.1992648438E-01, 7.6740189032E-01],
	[2.3760000000E+04, 4.1091623216E+00, 3.1952790023E+00, 2.5074966626E-01, 2.2005291521E-01, 7.6745847150E-01],
	[2.3765000000E+04, 4.1104915901E+00, 3.1952051590E+00, 2.5090939554E-01, 2.2017938514E-01, 7.6751502637E-01],
	[2.3770000000E+04, 4.1118210088E+00, 3.1951313329E+00, 2.5106919287E-01, 2.2030589416E-01, 7.6757155496E-01],
	[2.3775000000E+04, 4.1131505777E+00, 3.1950575241E+00, 2.5122905825E-01, 2.2043244226E-01, 7.6762805728E-01],
	[2.3780000000E+04, 4.1144802968E+00, 3.1949837325E+00, 2.5138899171E-01, 2.2055902945E-01, 7.6768453332E-01],
	[2.3785000000E+04, 4.1158101661E+00, 3.1949099581E+00, 2.5154899326E-01, 2.2068565571E-01, 7.6774098311E-01],
	[2.3790000000E+04, 4.1171401855E+00, 3.1948362009E+00, 2.5170906291E-01, 2.2081232105E-01, 7.6779740664E-01],
	[2.3795000000E+04, 4.1184703552E+00, 3.1947624609E+00, 2.5186920067E-01, 2.2093902545E-01, 7.6785380394E-01],
	[2.3800000000E+04, 4.1198006749E+00, 3.1946887382E+00, 2.5202940657E-01, 2.2106576892E-01, 7.6791017502E-01],
	[2.3805000000E+04, 4.1211311448E+00, 3.1946150326E+00, 2.5218968061E-01, 2.2119255146E-01, 7.6796651987E-01],
	[2.3810000000E+04, 4.1224617648E+00, 3.1945413442E+00, 2.5235002282E-01, 2.2131937305E-01, 7.6802283852E-01],
	[2.3815000000E+04, 4.1237925349E+00, 3.1944676729E+00, 2.5251043320E-01, 2.2144623369E-01, 7.6807913098E-01],
	[2.3820000000E+04, 4.1251234550E+00, 3.1943940188E+00, 2.5267091177E-01, 2.2157313339E-01, 7.6813539724E-01],
	[2.3825000000E+04, 4.1264545253E+00, 3.1943203819E+00, 2.5283145855E-01, 2.2170007213E-01, 7.6819163733E-01],
	[2.3830000000E+04, 4.1277857455E+00, 3.1942467622E+00, 2.5299207355E-01, 2.2182704991E-01, 7.6824785126E-01],
	[2.3835000000E+04, 4.1291171159E+00, 3.1941731595E+00, 2.5315275678E-01, 2.2195406673E-01, 7.6830403902E-01],
	[2.3840000000E+04, 4.1304486362E+00, 3.1940995740E+00, 2.5331350825E-01, 2.2208112258E-01, 7.6836020065E-01],
	[2.3845000000E+04, 4.1317803066E+00, 3.1940260057E+00, 2.5347432800E-01, 2.2220821747E-01, 7.6841633613E-01],
	[2.3850000000E+04, 4.1331121269E+00, 3.1939524544E+00, 2.5363521602E-01, 2.2233535138E-01, 7.6847244549E-01],
	[2.3855000000E+04, 4.1344440973E+00, 3.1938789203E+00, 2.5379617233E-01, 2.2246252431E-01, 7.6852852874E-01],
	[2.3860000000E+04, 4.1357762176E+00, 3.1938054032E+00, 2.5395719695E-01, 2.2258973626E-01, 7.6858458588E-01],
	[2.3865000000E+04, 4.1371084878E+00, 3.1937319033E+00, 2.5411828990E-01, 2.2271698723E-01, 7.6864061693E-01],
	[2.3870000000E+04, 4.1384409080E+00, 3.1936584204E+00, 2.5427945118E-01, 2.2284427720E-01, 7.6869662190E-01],
	[2.3875000000E+04, 4.1397734781E+00, 3.1935849547E+00, 2.5444068081E-01, 2.2297160618E-01, 7.6875260079E-01],
	[2.3880000000E+04, 4.1411061981E+00, 3.1935115060E+00, 2.5460197881E-01, 2.2309897416E-01, 7.6880855361E-01],
	[2.3885000000E+04, 4.1424390680E+00, 3.1934380743E+00, 2.5476334518E-01, 2.2322638114E-01, 7.6886448039E-01],
	[2.3890000000E+04, 4.1437720878E+00, 3.1933646598E+00, 2.5492477996E-01, 2.2335382712E-01, 7.6892038112E-01],
	[2.3895000000E+04, 4.1451052574E+00, 3.1932912622E+00, 2.5508628314E-01, 2.2348131208E-01, 7.6897625581E-01],
	[2.3900000000E+04, 4.1464385769E+00, 3.1932178818E+00, 2.5524785474E-01, 2.2360883603E-01, 7.6903210449E-01],
	[2.3905000000E+04, 4.1477720463E+00, 3.1931445183E+00, 2.5540949479E-01, 2.2373639896E-01, 7.6908792715E-01],
	[2.3910000000E+04, 4.1491056654E+00, 3.1930711719E+00, 2.5557120329E-01, 2.2386400087E-01, 7.6914372381E-01],
	[2.3915000000E+04, 4.1504394344E+00, 3.1929978425E+00, 2.5573298026E-01, 2.2399164175E-01, 7.6919949448E-01],
	[2.3920000000E+04, 4.1517788806E+00, 3.1929269059E+00, 2.5589482571E-01, 2.2411934941E-01, 7.6925523917E-01],
	[2.3925000000E+04, 4.1531192007E+00, 3.1928562959E+00, 2.5605673966E-01, 2.2424709972E-01, 7.6931095788E-01],
	[2.3930000000E+04, 4.1544596733E+00, 3.1927857021E+00, 2.5621872212E-01, 2.2437488905E-01, 7.6936665064E-01],
	[2.3935000000E+04, 4.1558002984E+00, 3.1927151246E+00, 2.5638077310E-01, 2.2450271739E-01, 7.6942231745E-01],
	[2.3940000000E+04, 4.1571410758E+00, 3.1926445635E+00, 2.5654289263E-01, 2.2463058473E-01, 7.6947795831E-01],
	[2.3945000000E+04, 4.1584820058E+00, 3.1925740186E+00, 2.5670508071E-01, 2.2475849108E-01, 7.6953357324E-01],
	[2.3950000000E+04, 4.1598230881E+00, 3.1925034900E+00, 2.5686733737E-01, 2.2488643642E-01, 7.6958916226E-01],
	[2.3955000000E+04, 4.1611643229E+00, 3.1924329777E+00, 2.5702966261E-01, 2.2501442076E-01, 7.6964472537E-01],
	[2.3960000000E+04, 4.1625057101E+00, 3.1923624817E+00, 2.5719205645E-01, 2.2514244409E-01, 7.6970026257E-01],
	[2.3965000000E+04, 4.1638472496E+00, 3.1922920019E+00, 2.5735451890E-01, 2.2527050641E-01, 7.6975577389E-01],
	[2.3970000000E+04, 4.1651889415E+00, 3.1922215384E+00, 2.5751704999E-01, 2.2539860771E-01, 7.6981125933E-01],
	[2.3975000000E+04, 4.1665307858E+00, 3.1921510912E+00, 2.5767964971E-01, 2.2552674799E-01, 7.6986671890E-01],
	[2.3980000000E+04, 4.1678727823E+00, 3.1920806602E+00, 2.5784231810E-01, 2.2565492725E-01, 7.6992215262E-01],
	[2.3985000000E+04, 4.1692149312E+00, 3.1920102454E+00, 2.5800505516E-01, 2.2578314547E-01, 7.6997756048E-01],
	[2.3990000000E+04, 4.1705572325E+00, 3.1919398469E+00, 2.5816786090E-01, 2.2591140266E-01, 7.7003294251E-01],
	[2.3995000000E+04, 4.1718996860E+00, 3.1918694646E+00, 2.5833073535E-01, 2.2603969881E-01, 7.7008829872E-01],
	[2.4000000000E+04, 4.1732422918E+00, 3.1917990985E+00, 2.5849367852E-01, 2.2616803392E-01, 7.7014362910E-01],
	[2.4005000000E+04, 4.1745850498E+00, 3.1917287486E+00, 2.5865669042E-01, 2.2629640798E-01, 7.7019893369E-01],
	[2.4010000000E+04, 4.1759279601E+00, 3.1916584149E+00, 2.5881977106E-01, 2.2642482099E-01, 7.7025421247E-01],
	[2.4015000000E+04, 4.1772710226E+00, 3.1915880974E+00, 2.5898292046E-01, 2.2655327295E-01, 7.7030946547E-01],
	[2.4020000000E+04, 4.1786142374E+00, 3.1915177961E+00, 2.5914613864E-01, 2.2668176385E-01, 7.7036469269E-01],
	[2.4025000000E+04, 4.1799576044E+00, 3.1914475109E+00, 2.5930942561E-01, 2.2681029369E-01, 7.7041989415E-01],
	[2.4030000000E+04, 4.1813011235E+00, 3.1913772420E+00, 2.5947278138E-01, 2.2693886246E-01, 7.7047506986E-01],
	[2.4035000000E+04, 4.1826447948E+00, 3.1913069892E+00, 2.5963620598E-01, 2.2706747015E-01, 7.7053021982E-01],
	[2.4040000000E+04, 4.1839886183E+00, 3.1912367526E+00, 2.5979969940E-01, 2.2719611677E-01, 7.7058534405E-01],
	[2.4045000000E+04, 4.1853325940E+00, 3.1911665321E+00, 2.5996326168E-01, 2.2732480232E-01, 7.7064044255E-01],
	[2.4050000000E+04, 4.1866767218E+00, 3.1910963278E+00, 2.6012689282E-01, 2.2745352677E-01, 7.7069551535E-01],
	[2.4055000000E+04, 4.1880210016E+00, 3.1910261396E+00, 2.6029059283E-01, 2.2758229014E-01, 7.7075056243E-01],
	[2.4060000000E+04, 4.1893654336E+00, 3.1909559675E+00, 2.6045436174E-01, 2.2771109242E-01, 7.7080558383E-01],
	[2.4065000000E+04, 4.1907100177E+00, 3.1908858116E+00, 2.6061819956E-01, 2.2783993360E-01, 7.7086057955E-01],
	[2.4070000000E+04, 4.1920547539E+00, 3.1908156718E+00, 2.6078210629E-01, 2.2796881368E-01, 7.7091554959E-01],
	[2.4075000000E+04, 4.1933996421E+00, 3.1907455481E+00, 2.6094608197E-01, 2.2809773265E-01, 7.7097049397E-01],
	[2.4080000000E+04, 4.1947446824E+00, 3.1906754405E+00, 2.6111012659E-01, 2.2822669052E-01, 7.7102541271E-01],
	[2.4085000000E+04, 4.1960898747E+00, 3.1906053489E+00, 2.6127424018E-01, 2.2835568727E-01, 7.7108030580E-01],
	[2.4090000000E+04, 4.1974352190E+00, 3.1905352735E+00, 2.6143842275E-01, 2.2848472290E-01, 7.7113517326E-01],
	[2.4095000000E+04, 4.1987807154E+00, 3.1904652142E+00, 2.6160267431E-01, 2.2861379741E-01, 7.7119001510E-01],
	[2.4100000000E+04, 4.2001263637E+00, 3.1903951709E+00, 2.6176699489E-01, 2.2874291080E-01, 7.7124483134E-01],
	[2.4105000000E+04, 4.2014721640E+00, 3.1903251437E+00, 2.6193138448E-01, 2.2887206305E-01, 7.7129962197E-01],
	[2.4110000000E+04, 4.2028181162E+00, 3.1902551326E+00, 2.6209584312E-01, 2.2900125417E-01, 7.7135438702E-01],
	[2.4115000000E+04, 4.2041642204E+00, 3.1901851375E+00, 2.6226037081E-01, 2.2913048415E-01, 7.7140912649E-01],
	[2.4120000000E+04, 4.2055104766E+00, 3.1901151584E+00, 2.6242496757E-01, 2.2925975299E-01, 7.7146384039E-01],
	[2.4125000000E+04, 4.2068568846E+00, 3.1900451954E+00, 2.6258963341E-01, 2.2938906067E-01, 7.7151852873E-01],
	[2.4130000000E+04, 4.2082034446E+00, 3.1899752485E+00, 2.6275436834E-01, 2.2951840721E-01, 7.7157319153E-01],
	[2.4135000000E+04, 4.2095501564E+00, 3.1899053175E+00, 2.6291917239E-01, 2.2964779259E-01, 7.7162782879E-01],
	[2.4140000000E+04, 4.2108970201E+00, 3.1898354026E+00, 2.6308404557E-01, 2.2977721681E-01, 7.7168244053E-01],
	[2.4145000000E+04, 4.2122440357E+00, 3.1897655037E+00, 2.6324898788E-01, 2.2990667986E-01, 7.7173702675E-01],
	[2.4150000000E+04, 4.2135912031E+00, 3.1896956208E+00, 2.6341399936E-01, 2.3003618174E-01, 7.7179158746E-01],
	[2.4155000000E+04, 4.2149385224E+00, 3.1896257539E+00, 2.6357908000E-01, 2.3016572245E-01, 7.7184612268E-01],
	[2.4160000000E+04, 4.2162859935E+00, 3.1895559030E+00, 2.6374422982E-01, 2.3029530198E-01, 7.7190063242E-01],
	[2.4165000000E+04, 4.2176336164E+00, 3.1894860680E+00, 2.6390944885E-01, 2.3042492033E-01, 7.7195511668E-01],
	[2.4170000000E+04, 4.2189813910E+00, 3.1894162491E+00, 2.6407473709E-01, 2.3055457749E-01, 7.7200957548E-01],
	[2.4175000000E+04, 4.2203293175E+00, 3.1893464461E+00, 2.6424009456E-01, 2.3068427346E-01, 7.7206400882E-01],
	[2.4180000000E+04, 4.2216773957E+00, 3.1892766591E+00, 2.6440552127E-01, 2.3081400824E-01, 7.7211841673E-01],
	[2.4185000000E+04, 4.2230256256E+00, 3.1892068880E+00, 2.6457101724E-01, 2.3094378181E-01, 7.7217279920E-01],
	[2.4190000000E+04, 4.2243740073E+00, 3.1891371329E+00, 2.6473658249E-01, 2.3107359418E-01, 7.7222715625E-01],
	[2.4195000000E+04, 4.2257225407E+00, 3.1890673937E+00, 2.6490221702E-01, 2.3120344534E-01, 7.7228148789E-01],
	[2.4200000000E+04, 4.2270712258E+00, 3.1889976704E+00, 2.6506792085E-01, 2.3133333529E-01, 7.7233579412E-01],
	[2.4205000000E+04, 4.2284200626E+00, 3.1889279631E+00, 2.6523369400E-01, 2.3146326402E-01, 7.7239007497E-01],
	[2.4210000000E+04, 4.2297690511E+00, 3.1888582717E+00, 2.6539953648E-01, 2.3159323153E-01, 7.7244433044E-01],
	[2.4215000000E+04, 4.2311181912E+00, 3.1887885962E+00, 2.6556544830E-01, 2.3172323781E-01, 7.7249856054E-01],
	[2.4220000000E+04, 4.2324674829E+00, 3.1887189367E+00, 2.6573142949E-01, 2.3185328286E-01, 7.7255276528E-01],
	[2.4225000000E+04, 4.2338169264E+00, 3.1886492930E+00, 2.6589748005E-01, 2.3198336667E-01, 7.7260694467E-01],
	[2.4230000000E+04, 4.2351665214E+00, 3.1885796652E+00, 2.6606360000E-01, 2.3211348925E-01, 7.7266109872E-01],
	[2.4235000000E+04, 4.2365162680E+00, 3.1885100533E+00, 2.6622978936E-01, 2.3224365058E-01, 7.7271522744E-01],
	[2.4240000000E+04, 4.2378661662E+00, 3.1884404573E+00, 2.6639604813E-01, 2.3237385066E-01, 7.7276933085E-01],
	[2.4245000000E+04, 4.2392162160E+00, 3.1883708772E+00, 2.6656237634E-01, 2.3250408949E-01, 7.7282340895E-01],
	[2.4250000000E+04, 4.2405664173E+00, 3.1883013129E+00, 2.6672877399E-01, 2.3263436706E-01, 7.7287746176E-01],
	[2.4255000000E+04, 4.2419167702E+00, 3.1882317645E+00, 2.6689524111E-01, 2.3276468337E-01, 7.7293148927E-01],
	[2.4260000000E+04, 4.2432672747E+00, 3.1881622319E+00, 2.6706177771E-01, 2.3289503841E-01, 7.7298549152E-01],
	[2.4265000000E+04, 4.2446179306E+00, 3.1880927152E+00, 2.6722838380E-01, 2.3302543218E-01, 7.7303946850E-01],
	[2.4270000000E+04, 4.2459687381E+00, 3.1880232143E+00, 2.6739505939E-01, 2.3315586468E-01, 7.7309342022E-01],
	[2.4275000000E+04, 4.2473196970E+00, 3.1879537293E+00, 2.6756180451E-01, 2.3328633589E-01, 7.7314734670E-01],
	[2.4280000000E+04, 4.2486708074E+00, 3.1878842600E+00, 2.6772861916E-01, 2.3341684582E-01, 7.7320124795E-01],
	[2.4285000000E+04, 4.2500220693E+00, 3.1878148066E+00, 2.6789550336E-01, 2.3354739446E-01, 7.7325512397E-01],
	[2.4290000000E+04, 4.2513734826E+00, 3.1877453690E+00, 2.6806245713E-01, 2.3367798181E-01, 7.7330897478E-01],
	[2.4295000000E+04, 4.2527250474E+00, 3.1876759472E+00, 2.6822948048E-01, 2.3380860786E-01, 7.7336280039E-01],
	[2.4300000000E+04, 4.2540767635E+00, 3.1876065412E+00, 2.6839657342E-01, 2.3393927261E-01, 7.7341660081E-01],
	[2.4305000000E+04, 4.2554342415E+00, 3.1875394832E+00, 2.6856373597E-01, 2.3407000560E-01, 7.7347037605E-01],
	[2.4310000000E+04, 4.2567926175E+00, 3.1874727497E+00, 2.6873096814E-01, 2.3420078125E-01, 7.7352412611E-01],
	[2.4315000000E+04, 4.2581511477E+00, 3.1874060313E+00, 2.6889826995E-01, 2.3433159564E-01, 7.7357785102E-01],
	[2.4320000000E+04, 4.2595098320E+00, 3.1873393280E+00, 2.6906564142E-01, 2.3446244876E-01, 7.7363155078E-01],
	[2.4325000000E+04, 4.2608686704E+00, 3.1872726398E+00, 2.6923308255E-01, 2.3459334062E-01, 7.7368522539E-01],
	[2.4330000000E+04, 4.2622276628E+00, 3.1872059668E+00, 2.6940059337E-01, 2.3472427120E-01, 7.7373887488E-01],
	[2.4335000000E+04, 4.2635868093E+00, 3.1871393088E+00, 2.6956817388E-01, 2.3485524051E-01, 7.7379249925E-01],
	[2.4340000000E+04, 4.2649461099E+00, 3.1870726659E+00, 2.6973582411E-01, 2.3498624853E-01, 7.7384609851E-01],
	[2.4345000000E+04, 4.2663055644E+00, 3.1870060381E+00, 2.6990354405E-01, 2.3511729526E-01, 7.7389967268E-01],
	[2.4350000000E+04, 4.2676651730E+00, 3.1869394253E+00, 2.7007133375E-01, 2.3524838071E-01, 7.7395322176E-01],
	[2.4355000000E+04, 4.2690249356E+00, 3.1868728277E+00, 2.7023919319E-01, 2.3537950485E-01, 7.7400674576E-01],
	[2.4360000000E+04, 4.2703848522E+00, 3.1868062451E+00, 2.7040712241E-01, 2.3551066770E-01, 7.7406024470E-01],
	[2.4365000000E+04, 4.2717449228E+00, 3.1867396775E+00, 2.7057512141E-01, 2.3564186924E-01, 7.7411371858E-01],
	[2.4370000000E+04, 4.2731051473E+00, 3.1866731250E+00, 2.7074319021E-01, 2.3577310947E-01, 7.7416716742E-01],
	[2.4375000000E+04, 4.2744655257E+00, 3.1866065876E+00, 2.7091132882E-01, 2.3590438839E-01, 7.7422059122E-01],
	[2.4380000000E+04, 4.2758260581E+00, 3.1865400651E+00, 2.7107953726E-01, 2.3603570598E-01, 7.7427399000E-01],
	[2.4385000000E+04, 4.2771867444E+00, 3.1864735578E+00, 2.7124781555E-01, 2.3616706226E-01, 7.7432736377E-01],
	[2.4390000000E+04, 4.2785475847E+00, 3.1864070654E+00, 2.7141616369E-01, 2.3629845720E-01, 7.7438071253E-01],
	[2.4395000000E+04, 4.2799085788E+00, 3.1863405880E+00, 2.7158458170E-01, 2.3642989081E-01, 7.7443403631E-01],
	[2.4400000000E+04, 4.2812697267E+00, 3.1862741257E+00, 2.7175306961E-01, 2.3656136309E-01, 7.7448733510E-01],
	[2.4405000000E+04, 4.2826310286E+00, 3.1862076784E+00, 2.7192162741E-01, 2.3669287402E-01, 7.7454060892E-01],
	[2.4410000000E+04, 4.2839924842E+00, 3.1861412460E+00, 2.7209025513E-01, 2.3682442360E-01, 7.7459385778E-01],
	[2.4415000000E+04, 4.2853540938E+00, 3.1860748287E+00, 2.7225895278E-01, 2.3695601184E-01, 7.7464708168E-01],
	[2.4420000000E+04, 4.2867158571E+00, 3.1860084263E+00, 2.7242772038E-01, 2.3708763871E-01, 7.7470028065E-01],
	[2.4425000000E+04, 4.2880777742E+00, 3.1859420389E+00, 2.7259655793E-01, 2.3721930423E-01, 7.7475345469E-01],
	[2.4430000000E+04, 4.2894398451E+00, 3.1858756665E+00, 2.7276546546E-01, 2.3735100838E-01, 7.7480660382E-01],
	[2.4435000000E+04, 4.2908020698E+00, 3.1858093090E+00, 2.7293444299E-01, 2.3748275116E-01, 7.7485972803E-01],
	[2.4440000000E+04, 4.2921644483E+00, 3.1857429666E+00, 2.7310349051E-01, 2.3761453257E-01, 7.7491282735E-01],
	[2.4445000000E+04, 4.2935269805E+00, 3.1856766390E+00, 2.7327260805E-01, 2.3774635260E-01, 7.7496590178E-01],
	[2.4450000000E+04, 4.2948896665E+00, 3.1856103264E+00, 2.7344179563E-01, 2.3787821124E-01, 7.7501895133E-01],
	[2.4455000000E+04, 4.2962525061E+00, 3.1855440288E+00, 2.7361105325E-01, 2.3801010849E-01, 7.7507197602E-01],
	[2.4460000000E+04, 4.2976154995E+00, 3.1854777460E+00, 2.7378038094E-01, 2.3814204435E-01, 7.7512497585E-01],
	[2.4465000000E+04, 4.2989786465E+00, 3.1854114783E+00, 2.7394977870E-01, 2.3827401882E-01, 7.7517795084E-01],
	[2.4470000000E+04, 4.3003419473E+00, 3.1853452254E+00, 2.7411924656E-01, 2.3840603188E-01, 7.7523090099E-01],
	[2.4475000000E+04, 4.3017054017E+00, 3.1852789874E+00, 2.7428878452E-01, 2.3853808353E-01, 7.7528382632E-01],
	[2.4480000000E+04, 4.3030690097E+00, 3.1852127644E+00, 2.7445839261E-01, 2.3867017377E-01, 7.7533672684E-01],
	[2.4485000000E+04, 4.3044327714E+00, 3.1851465562E+00, 2.7462807083E-01, 2.3880230259E-01, 7.7538960256E-01],
	[2.4490000000E+04, 4.3057966867E+00, 3.1850803630E+00, 2.7479781919E-01, 2.3893446999E-01, 7.7544245348E-01],
	[2.4495000000E+04, 4.3071607556E+00, 3.1850141846E+00, 2.7496763773E-01, 2.3906667597E-01, 7.7549527962E-01],
	[2.4500000000E+04, 4.3085249781E+00, 3.1849480211E+00, 2.7513752644E-01, 2.3919892051E-01, 7.7554808099E-01],
	[2.4505000000E+04, 4.3098893542E+00, 3.1848818725E+00, 2.7530748535E-01, 2.3933120362E-01, 7.7560085760E-01],
	[2.4510000000E+04, 4.3112538838E+00, 3.1848157387E+00, 2.7547751447E-01, 2.3946352529E-01, 7.7565360946E-01],
	[2.4515000000E+04, 4.3126185670E+00, 3.1847496199E+00, 2.7564761381E-01, 2.3959588551E-01, 7.7570633658E-01],
	[2.4520000000E+04, 4.3139834038E+00, 3.1846835158E+00, 2.7581778339E-01, 2.3972828428E-01, 7.7575903897E-01],
	[2.4525000000E+04, 4.3153483940E+00, 3.1846174267E+00, 2.7598802322E-01, 2.3986072160E-01, 7.7581171665E-01],
	[2.4530000000E+04, 4.3167135378E+00, 3.1845513523E+00, 2.7615833332E-01, 2.3999319745E-01, 7.7586436961E-01],
	[2.4535000000E+04, 4.3180788350E+00, 3.1844852928E+00, 2.7632871370E-01, 2.4012571185E-01, 7.7591699788E-01],
	[2.4540000000E+04, 4.3194442858E+00, 3.1844192482E+00, 2.7649916437E-01, 2.4025826477E-01, 7.7596960146E-01],
	[2.4545000000E+04, 4.3208098900E+00, 3.1843532183E+00, 2.7666968536E-01, 2.4039085622E-01, 7.7602218037E-01],
	[2.4550000000E+04, 4.3221756476E+00, 3.1842872033E+00, 2.7684027668E-01, 2.4052348619E-01, 7.7607473461E-01],
	[2.4555000000E+04, 4.3235415587E+00, 3.1842212031E+00, 2.7701093833E-01, 2.4065615467E-01, 7.7612726420E-01],
	[2.4560000000E+04, 4.3249076232E+00, 3.1841552177E+00, 2.7718167034E-01, 2.4078886167E-01, 7.7617976914E-01],
	[2.4565000000E+04, 4.3262738412E+00, 3.1840892471E+00, 2.7735247272E-01, 2.4092160718E-01, 7.7623224945E-01],
	[2.4570000000E+04, 4.3276402125E+00, 3.1840232913E+00, 2.7752334548E-01, 2.4105439118E-01, 7.7628470513E-01],
	[2.4575000000E+04, 4.3290067372E+00, 3.1839573503E+00, 2.7769428865E-01, 2.4118721368E-01, 7.7633713620E-01],
	[2.4580000000E+04, 4.3303734153E+00, 3.1838914240E+00, 2.7786530222E-01, 2.4132007468E-01, 7.7638954267E-01],
	[2.4585000000E+04, 4.3317402467E+00, 3.1838255125E+00, 2.7803638623E-01, 2.4145297416E-01, 7.7644192455E-01],
	[2.4590000000E+04, 4.3331072315E+00, 3.1837596158E+00, 2.7820754068E-01, 2.4158591213E-01, 7.7649428185E-01],
	[2.4595000000E+04, 4.3344743696E+00, 3.1836937339E+00, 2.7837876558E-01, 2.4171888857E-01, 7.7654661458E-01],
	[2.4600000000E+04, 4.3358416610E+00, 3.1836278667E+00, 2.7855006096E-01, 2.4185190348E-01, 7.7659892275E-01],
	[2.4605000000E+04, 4.3372091057E+00, 3.1835620143E+00, 2.7872142682E-01, 2.4198495687E-01, 7.7665120636E-01],
	[2.4610000000E+04, 4.3385767037E+00, 3.1834961766E+00, 2.7889286319E-01, 2.4211804871E-01, 7.7670346544E-01],
	[2.4615000000E+04, 4.3399444549E+00, 3.1834303536E+00, 2.7906437007E-01, 2.4225117902E-01, 7.7675570000E-01],
	[2.4620000000E+04, 4.3413123594E+00, 3.1833645454E+00, 2.7923594748E-01, 2.4238434777E-01, 7.7680791003E-01],
	[2.4625000000E+04, 4.3426804172E+00, 3.1832987519E+00, 2.7940759544E-01, 2.4251755498E-01, 7.7686009556E-01],
	[2.4630000000E+04, 4.3440486282E+00, 3.1832329731E+00, 2.7957931396E-01, 2.4265080063E-01, 7.7691225659E-01],
	[2.4635000000E+04, 4.3454169924E+00, 3.1831672090E+00, 2.7975110305E-01, 2.4278408471E-01, 7.7696439313E-01],
	[2.4640000000E+04, 4.3467855098E+00, 3.1831014596E+00, 2.7992296273E-01, 2.4291740723E-01, 7.7701650520E-01],
	[2.4645000000E+04, 4.3481541804E+00, 3.1830357250E+00, 2.8009489302E-01, 2.4305076818E-01, 7.7706859281E-01],
	[2.4650000000E+04, 4.3495230041E+00, 3.1829700050E+00, 2.8026689392E-01, 2.4318416756E-01, 7.7712065596E-01],
	[2.4655000000E+04, 4.3508919810E+00, 3.1829042997E+00, 2.8043896546E-01, 2.4331760535E-01, 7.7717269467E-01],
	[2.4660000000E+04, 4.3522611111E+00, 3.1828386091E+00, 2.8061110764E-01, 2.4345108155E-01, 7.7722470894E-01],
	[2.4665000000E+04, 4.3536303943E+00, 3.1827729331E+00, 2.8078332049E-01, 2.4358459617E-01, 7.7727669880E-01],
	[2.4670000000E+04, 4.3549998306E+00, 3.1827072718E+00, 2.8095560401E-01, 2.4371814918E-01, 7.7732866424E-01],
	[2.4675000000E+04, 4.3563694200E+00, 3.1826416252E+00, 2.8112795823E-01, 2.4385174060E-01, 7.7738060528E-01],
	[2.4680000000E+04, 4.3577391625E+00, 3.1825759932E+00, 2.8130038315E-01, 2.4398537041E-01, 7.7743252193E-01],
	[2.4685000000E+04, 4.3591090581E+00, 3.1825103759E+00, 2.8147287879E-01, 2.4411903861E-01, 7.7748441420E-01],
	[2.4690000000E+04, 4.3604791067E+00, 3.1824447733E+00, 2.8164544517E-01, 2.4425274520E-01, 7.7753628209E-01],
	[2.4695000000E+04, 4.3618534538E+00, 3.1823808522E+00, 2.8181808230E-01, 2.4438651300E-01, 7.7758812564E-01],
	[2.4700000000E+04, 4.3632302715E+00, 3.1823178764E+00, 2.8199079019E-01, 2.4452033199E-01, 7.7763994483E-01],
	[2.4705000000E+04, 4.3646072449E+00, 3.1822549145E+00, 2.8216356886E-01, 2.4465418940E-01, 7.7769173968E-01],
	[2.4710000000E+04, 4.3659843742E+00, 3.1821919666E+00, 2.8233641833E-01, 2.4478808524E-01, 7.7774351021E-01],
	[2.4715000000E+04, 4.3673616591E+00, 3.1821290327E+00, 2.8250933861E-01, 2.4492201950E-01, 7.7779525642E-01],
	[2.4720000000E+04, 4.3687390998E+00, 3.1820661128E+00, 2.8268232971E-01, 2.4505599217E-01, 7.7784697833E-01],
	[2.4725000000E+04, 4.3701166963E+00, 3.1820032068E+00, 2.8285539164E-01, 2.4519000324E-01, 7.7789867594E-01],
	[2.4730000000E+04, 4.3714944484E+00, 3.1819403149E+00, 2.8302852443E-01, 2.4532405272E-01, 7.7795034926E-01],
	[2.4735000000E+04, 4.3728723563E+00, 3.1818774368E+00, 2.8320172809E-01, 2.4545814060E-01, 7.7800199832E-01],
	[2.4740000000E+04, 4.3742504198E+00, 3.1818145727E+00, 2.8337500263E-01, 2.4559226687E-01, 7.7805362310E-01],
	[2.4745000000E+04, 4.3756286390E+00, 3.1817517226E+00, 2.8354834806E-01, 2.4572643153E-01, 7.7810522364E-01],
	[2.4750000000E+04, 4.3770070139E+00, 3.1816888864E+00, 2.8372176441E-01, 2.4586063457E-01, 7.7815679993E-01],
	[2.4755000000E+04, 4.3783855444E+00, 3.1816260641E+00, 2.8389525168E-01, 2.4599487598E-01, 7.7820835199E-01],
	[2.4760000000E+04, 4.3797642305E+00, 3.1815632558E+00, 2.8406880989E-01, 2.4612915577E-01, 7.7825987983E-01],
	[2.4765000000E+04, 4.3811430722E+00, 3.1815004614E+00, 2.8424243906E-01, 2.4626347393E-01, 7.7831138346E-01],
	[2.4770000000E+04, 4.3825220696E+00, 3.1814376809E+00, 2.8441613919E-01, 2.4639783045E-01, 7.7836286289E-01],
	[2.4775000000E+04, 4.3839012225E+00, 3.1813749143E+00, 2.8458991031E-01, 2.4653222533E-01, 7.7841431813E-01],
	[2.4780000000E+04, 4.3852805310E+00, 3.1813121616E+00, 2.8476375243E-01, 2.4666665857E-01, 7.7846574919E-01],
	[2.4785000000E+04, 4.3866599951E+00, 3.1812494228E+00, 2.8493766557E-01, 2.4680113014E-01, 7.7851715608E-01],
	[2.4790000000E+04, 4.3880396147E+00, 3.1811866979E+00, 2.8511164973E-01, 2.4693564007E-01, 7.7856853882E-01],
	[2.4795000000E+04, 4.3894193898E+00, 3.1811239869E+00, 2.8528570493E-01, 2.4707018833E-01, 7.7861989741E-01],
	[2.4800000000E+04, 4.3907993204E+00, 3.1810612898E+00, 2.8545983119E-01, 2.4720477492E-01, 7.7867123186E-01],
	[2.4805000000E+04, 4.3921794066E+00, 3.1809986066E+00, 2.8563402853E-01, 2.4733939984E-01, 7.7872254219E-01],
	[2.4810000000E+04, 4.3935596482E+00, 3.1809359372E+00, 2.8580829695E-01, 2.4747406308E-01, 7.7877382840E-01],
	[2.4815000000E+04, 4.3949400453E+00, 3.1808732817E+00, 2.8598263647E-01, 2.4760876464E-01, 7.7882509050E-01],
	[2.4820000000E+04, 4.3963205979E+00, 3.1808106400E+00, 2.8615704711E-01, 2.4774350451E-01, 7.7887632852E-01],
	[2.4825000000E+04, 4.3977013059E+00, 3.1807480122E+00, 2.8633152887E-01, 2.4787828268E-01, 7.7892754244E-01],
	[2.4830000000E+04, 4.3990821694E+00, 3.1806853982E+00, 2.8650608179E-01, 2.4801309916E-01, 7.7897873230E-01],
	[2.4835000000E+04, 4.4004631883E+00, 3.1806227981E+00, 2.8668070586E-01, 2.4814795394E-01, 7.7902989809E-01],
	[2.4840000000E+04, 4.4018443626E+00, 3.1805602118E+00, 2.8685540111E-01, 2.4828284701E-01, 7.7908103984E-01],
	[2.4845000000E+04, 4.4032256922E+00, 3.1804976393E+00, 2.8703016755E-01, 2.4841777836E-01, 7.7913215754E-01],
	[2.4850000000E+04, 4.4046071773E+00, 3.1804350807E+00, 2.8720500519E-01, 2.4855274800E-01, 7.7918325121E-01],
	[2.4855000000E+04, 4.4059888177E+00, 3.1803725358E+00, 2.8737991405E-01, 2.4868775591E-01, 7.7923432086E-01],
	[2.4860000000E+04, 4.4073706135E+00, 3.1803100048E+00, 2.8755489414E-01, 2.4882280209E-01, 7.7928536650E-01],
	[2.4865000000E+04, 4.4087525646E+00, 3.1802474876E+00, 2.8772994548E-01, 2.4895788654E-01, 7.7933638814E-01],
	[2.4870000000E+04, 4.4101346710E+00, 3.1801849842E+00, 2.8790506808E-01, 2.4909300925E-01, 7.7938738580E-01],
	[2.4875000000E+04, 4.4115169327E+00, 3.1801224946E+00, 2.8808026196E-01, 2.4922817021E-01, 7.7943835948E-01],
	[2.4880000000E+04, 4.4128993498E+00, 3.1800600187E+00, 2.8825552713E-01, 2.4936336943E-01, 7.7948930919E-01],
	[2.4885000000E+04, 4.4142819221E+00, 3.1799975567E+00, 2.8843086360E-01, 2.4949860689E-01, 7.7954023494E-01],
	[2.4890000000E+04, 4.4156646497E+00, 3.1799351084E+00, 2.8860627140E-01, 2.4963388259E-01, 7.7959113675E-01],
	[2.4895000000E+04, 4.4170475325E+00, 3.1798726739E+00, 2.8878175053E-01, 2.4976919653E-01, 7.7964201463E-01],
	[2.4900000000E+04, 4.4184305706E+00, 3.1798102532E+00, 2.8895730102E-01, 2.4990454869E-01, 7.7969286858E-01],
	[2.4905000000E+04, 4.4198137639E+00, 3.1797478462E+00, 2.8913292286E-01, 2.5003993908E-01, 7.7974369861E-01],
	[2.4910000000E+04, 4.4211971124E+00, 3.1796854529E+00, 2.8930861609E-01, 2.5017536769E-01, 7.7979450475E-01],
	[2.4915000000E+04, 4.4225806162E+00, 3.1796230734E+00, 2.8948438071E-01, 2.5031083452E-01, 7.7984528699E-01],
	[2.4920000000E+04, 4.4239642751E+00, 3.1795607077E+00, 2.8966021674E-01, 2.5044633955E-01, 7.7989604534E-01],
	[2.4925000000E+04, 4.4253480892E+00, 3.1794983557E+00, 2.8983612419E-01, 2.5058188278E-01, 7.7994677983E-01],
	[2.4930000000E+04, 4.4267320584E+00, 3.1794360174E+00, 2.9001210308E-01, 2.5071746422E-01, 7.7999749046E-01],
	[2.4935000000E+04, 4.4281161828E+00, 3.1793736928E+00, 2.9018815343E-01, 2.5085308385E-01, 7.8004817723E-01],
	[2.4940000000E+04, 4.4295004623E+00, 3.1793113820E+00, 2.9036427524E-01, 2.5098874166E-01, 7.8009884017E-01],
	[2.4945000000E+04, 4.4308848969E+00, 3.1792490849E+00, 2.9054046853E-01, 2.5112443766E-01, 7.8014947928E-01],
	[2.4950000000E+04, 4.4322694867E+00, 3.1791868014E+00, 2.9071673332E-01, 2.5126017183E-01, 7.8020009457E-01],
	[2.4955000000E+04, 4.4336542315E+00, 3.1791245317E+00, 2.9089306962E-01, 2.5139594418E-01, 7.8025068605E-01],
	[2.4960000000E+04, 4.4350391314E+00, 3.1790622757E+00, 2.9106947744E-01, 2.5153175469E-01, 7.8030125373E-01],
	[2.4965000000E+04, 4.4364241864E+00, 3.1790000333E+00, 2.9124595681E-01, 2.5166760337E-01, 7.8035179763E-01],
	[2.4970000000E+04, 4.4378093964E+00, 3.1789378047E+00, 2.9142250773E-01, 2.5180349020E-01, 7.8040231775E-01],
	[2.4975000000E+04, 4.4391947614E+00, 3.1788755897E+00, 2.9159913022E-01, 2.5193941519E-01, 7.8045281411E-01],
	[2.4980000000E+04, 4.4405802815E+00, 3.1788133884E+00, 2.9177582429E-01, 2.5207537831E-01, 7.8050328671E-01],
	[2.4985000000E+04, 4.4419659566E+00, 3.1787512007E+00, 2.9195258997E-01, 2.5221137958E-01, 7.8055373557E-01],
	[2.4990000000E+04, 4.4433517866E+00, 3.1786890268E+00, 2.9212942725E-01, 2.5234741899E-01, 7.8060416069E-01],
	[2.4995000000E+04, 4.4447377717E+00, 3.1786268664E+00, 2.9230633617E-01, 2.5248349652E-01, 7.8065456210E-01],
	[2.5000000000E+04, 4.4461239117E+00, 3.1785647197E+00, 2.9248331673E-01, 2.5261961218E-01, 7.8070493979E-01],
	[2.5005000000E+04, 4.4475102067E+00, 3.1785025867E+00, 2.9266149752E-01, 2.5275660775E-01, 7.8075529377E-01],
	[2.5010000000E+04, 4.4488966566E+00, 3.1784404673E+00, 2.9283975114E-01, 2.5289364207E-01, 7.8080562407E-01],
	[2.5015000000E+04, 4.4502832614E+00, 3.1783783615E+00, 2.9301807760E-01, 2.5303071514E-01, 7.8085593069E-01],
	[2.5020000000E+04, 4.4516700212E+00, 3.1783162694E+00, 2.9319647691E-01, 2.5316782694E-01, 7.8090621363E-01],
	[2.5025000000E+04, 4.4530569358E+00, 3.1782541909E+00, 2.9337494909E-01, 2.5330497748E-01, 7.8095647292E-01],
	[2.5030000000E+04, 4.4544440053E+00, 3.1781921259E+00, 2.9355349416E-01, 2.5344216674E-01, 7.8100670856E-01],
	[2.5035000000E+04, 4.4558312297E+00, 3.1781300746E+00, 2.9373211213E-01, 2.5357939473E-01, 7.8105692056E-01],
	[2.5040000000E+04, 4.4572186090E+00, 3.1780680369E+00, 2.9391080302E-01, 2.5371666144E-01, 7.8110710893E-01],
	[2.5045000000E+04, 4.4586061431E+00, 3.1780060128E+00, 2.9408956683E-01, 2.5385396685E-01, 7.8115727369E-01],
	[2.5050000000E+04, 4.4599938320E+00, 3.1779440023E+00, 2.9426840360E-01, 2.5399131097E-01, 7.8120741484E-01],
	[2.5055000000E+04, 4.4613816758E+00, 3.1778820054E+00, 2.9444731332E-01, 2.5412869379E-01, 7.8125753239E-01],
	[2.5060000000E+04, 4.4627696743E+00, 3.1778200220E+00, 2.9462629602E-01, 2.5426611531E-01, 7.8130762636E-01],
	[2.5065000000E+04, 4.4641578277E+00, 3.1777580523E+00, 2.9480535171E-01, 2.5440357552E-01, 7.8135769675E-01],
	[2.5070000000E+04, 4.4655461358E+00, 3.1776960961E+00, 2.9498448041E-01, 2.5454107441E-01, 7.8140774357E-01],
	[2.5075000000E+04, 4.4669345987E+00, 3.1776341534E+00, 2.9516368212E-01, 2.5467861198E-01, 7.8145776683E-01],
	[2.5080000000E+04, 4.4683232163E+00, 3.1775722244E+00, 2.9534295688E-01, 2.5481618823E-01, 7.8150776655E-01],
	[2.5085000000E+04, 4.4697119887E+00, 3.1775103088E+00, 2.9552230469E-01, 2.5495380314E-01, 7.8155774273E-01],
	[2.5090000000E+04, 4.4711018149E+00, 3.1774487663E+00, 2.9570172556E-01, 2.5509146196E-01, 7.8160769538E-01],
	[2.5095000000E+04, 4.4724972852E+00, 3.1773894311E+00, 2.9588121952E-01, 2.5522919148E-01, 7.8165762451E-01],
	[2.5100000000E+04, 4.4738929129E+00, 3.1773301088E+00, 2.9606078657E-01, 2.5536695971E-01, 7.8170753014E-01],
	[2.5105000000E+04, 4.4752886979E+00, 3.1772707994E+00, 2.9624042674E-01, 2.5550476665E-01, 7.8175741227E-01],
	[2.5110000000E+04, 4.4766846404E+00, 3.1772115029E+00, 2.9642014004E-01, 2.5564261229E-01, 7.8180727090E-01],
	[2.5115000000E+04, 4.4780807402E+00, 3.1771522193E+00, 2.9659992647E-01, 2.5578049662E-01, 7.8185710606E-01],
	[2.5120000000E+04, 4.4794769973E+00, 3.1770929487E+00, 2.9677978607E-01, 2.5591841965E-01, 7.8190691776E-01],
	[2.5125000000E+04, 4.4808734118E+00, 3.1770336909E+00, 2.9695971884E-01, 2.5605638136E-01, 7.8195670599E-01],
	[2.5130000000E+04, 4.4822699835E+00, 3.1769744460E+00, 2.9713972480E-01, 2.5619438175E-01, 7.8200647077E-01],
	[2.5135000000E+04, 4.4836667126E+00, 3.1769152141E+00, 2.9731980396E-01, 2.5633242082E-01, 7.8205621212E-01],
	[2.5140000000E+04, 4.4850635990E+00, 3.1768559950E+00, 2.9749995634E-01, 2.5647049856E-01, 7.8210593003E-01],
	[2.5145000000E+04, 4.4864606427E+00, 3.1767967888E+00, 2.9768018195E-01, 2.5660861496E-01, 7.8215562453E-01],
	[2.5150000000E+04, 4.4878578436E+00, 3.1767375954E+00, 2.9786048082E-01, 2.5674677001E-01, 7.8220529562E-01],
	[2.5155000000E+04, 4.4892552017E+00, 3.1766784150E+00, 2.9804085295E-01, 2.5688496373E-01, 7.8225494331E-01],
	[2.5160000000E+04, 4.4906527171E+00, 3.1766192474E+00, 2.9822129835E-01, 2.5702319609E-01, 7.8230456760E-01],
	[2.5165000000E+04, 4.4920503898E+00, 3.1765600926E+00, 2.9840181706E-01, 2.5716146709E-01, 7.8235416852E-01],
	[2.5170000000E+04, 4.4934482196E+00, 3.1765009508E+00, 2.9858240907E-01, 2.5729977672E-01, 7.8240374607E-01],
	[2.5175000000E+04, 4.4948462066E+00, 3.1764418217E+00, 2.9876307440E-01, 2.5743812499E-01, 7.8245330026E-01],
	[2.5180000000E+04, 4.4962443508E+00, 3.1763827055E+00, 2.9894381308E-01, 2.5757651189E-01, 7.8250283110E-01],
	[2.5185000000E+04, 4.4976426522E+00, 3.1763236022E+00, 2.9912462511E-01, 2.5771493740E-01, 7.8255233860E-01],
	[2.5190000000E+04, 4.4990411107E+00, 3.1762645116E+00, 2.9930551051E-01, 2.5785340153E-01, 7.8260182277E-01],
	[2.5195000000E+04, 4.5004397264E+00, 3.1762054340E+00, 2.9948646930E-01, 2.5799190427E-01, 7.8265128362E-01],
	[2.5200000000E+04, 4.5018384992E+00, 3.1761463691E+00, 2.9966750149E-01, 2.5813044561E-01, 7.8270072116E-01],
	[2.5205000000E+04, 4.5032374291E+00, 3.1760873170E+00, 2.9984860710E-01, 2.5826902555E-01, 7.8275013540E-01],
	[2.5210000000E+04, 4.5046365161E+00, 3.1760282778E+00, 3.0002978613E-01, 2.5840764408E-01, 7.8279952635E-01],
	[2.5215000000E+04, 4.5060357602E+00, 3.1759692513E+00, 3.0021103861E-01, 2.5854630119E-01, 7.8284889402E-01],
	[2.5220000000E+04, 4.5074351614E+00, 3.1759102377E+00, 3.0039236456E-01, 2.5868499689E-01, 7.8289823842E-01],
	[2.5225000000E+04, 4.5088347196E+00, 3.1758512368E+00, 3.0057376398E-01, 2.5882373117E-01, 7.8294755956E-01],
	[2.5230000000E+04, 4.5102344349E+00, 3.1757922488E+00, 3.0075523689E-01, 2.5896250401E-01, 7.8299685745E-01],
	[2.5235000000E+04, 4.5116343072E+00, 3.1757332735E+00, 3.0093678331E-01, 2.5910131542E-01, 7.8304613209E-01],
	[2.5240000000E+04, 4.5130343365E+00, 3.1756743110E+00, 3.0111840325E-01, 2.5924016539E-01, 7.8309538351E-01],
	[2.5245000000E+04, 4.5144345229E+00, 3.1756153613E+00, 3.0130009672E-01, 2.5937905391E-01, 7.8314461170E-01],
	[2.5250000000E+04, 4.5158348662E+00, 3.1755564243E+00, 3.0148186375E-01, 2.5951798098E-01, 7.8319381669E-01],
	[2.5255000000E+04, 4.5172353665E+00, 3.1754975001E+00, 3.0166370435E-01, 2.5965694659E-01, 7.8324299847E-01],
	[2.5260000000E+04, 4.5186360238E+00, 3.1754385887E+00, 3.0184561853E-01, 2.5979595074E-01, 7.8329215706E-01],
	[2.5265000000E+04, 4.5200368380E+00, 3.1753796900E+00, 3.0202760631E-01, 2.5993499342E-01, 7.8334129247E-01],
	[2.5270000000E+04, 4.5214378092E+00, 3.1753208041E+00, 3.0220966770E-01, 2.6007407463E-01, 7.8339040471E-01],
	[2.5275000000E+04, 4.5228389372E+00, 3.1752619309E+00, 3.0239180272E-01, 2.6021319435E-01, 7.8343949379E-01],
	[2.5280000000E+04, 4.5242402222E+00, 3.1752030704E+00, 3.0257401138E-01, 2.6035235259E-01, 7.8348855972E-01],
	[2.5285000000E+04, 4.5256416641E+00, 3.1751442227E+00, 3.0275629370E-01, 2.6049154934E-01, 7.8353760250E-01],
	[2.5290000000E+04, 4.5270432629E+00, 3.1750853877E+00, 3.0293864970E-01, 2.6063078459E-01, 7.8358662216E-01],
	[2.5295000000E+04, 4.5284450186E+00, 3.1750265654E+00, 3.0312107938E-01, 2.6077005834E-01, 7.8363561869E-01],
	[2.5300000000E+04, 4.5298469311E+00, 3.1749677559E+00, 3.0330358277E-01, 2.6090937058E-01, 7.8368459211E-01],
	[2.5305000000E+04, 4.5312490004E+00, 3.1749089590E+00, 3.0348615988E-01, 2.6104872130E-01, 7.8373354243E-01],
	[2.5310000000E+04, 4.5326512266E+00, 3.1748501749E+00, 3.0366881072E-01, 2.6118811051E-01, 7.8378246965E-01],
	[2.5315000000E+04, 4.5340536096E+00, 3.1747914034E+00, 3.0385153531E-01, 2.6132753819E-01, 7.8383137380E-01],
	[2.5320000000E+04, 4.5354561494E+00, 3.1747326447E+00, 3.0403433366E-01, 2.6146700434E-01, 7.8388025487E-01],
	[2.5325000000E+04, 4.5368588460E+00, 3.1746738986E+00, 3.0421720580E-01, 2.6160650895E-01, 7.8392911289E-01],
	[2.5330000000E+04, 4.5382616993E+00, 3.1746151652E+00, 3.0440015173E-01, 2.6174605202E-01, 7.8397794785E-01],
	[2.5335000000E+04, 4.5396647095E+00, 3.1745564445E+00, 3.0458317147E-01, 2.6188563354E-01, 7.8402675976E-01],
	[2.5340000000E+04, 4.5410678764E+00, 3.1744977365E+00, 3.0476626504E-01, 2.6202525351E-01, 7.8407554865E-01],
	[2.5345000000E+04, 4.5424712000E+00, 3.1744390412E+00, 3.0494943244E-01, 2.6216491191E-01, 7.8412431451E-01],
	[2.5350000000E+04, 4.5438746803E+00, 3.1743803585E+00, 3.0513267371E-01, 2.6230460876E-01, 7.8417305737E-01],
	[2.5355000000E+04, 4.5452783174E+00, 3.1743216884E+00, 3.0531598884E-01, 2.6244434403E-01, 7.8422177721E-01],
	[2.5360000000E+04, 4.5466821111E+00, 3.1742630310E+00, 3.0549937786E-01, 2.6258411772E-01, 7.8427047407E-01],
	[2.5365000000E+04, 4.5480860615E+00, 3.1742043863E+00, 3.0568284078E-01, 2.6272392983E-01, 7.8431914795E-01],
	[2.5370000000E+04, 4.5494901686E+00, 3.1741457542E+00, 3.0586637761E-01, 2.6286378036E-01, 7.8436779885E-01],
	[2.5375000000E+04, 4.5508944324E+00, 3.1740871348E+00, 3.0604998838E-01, 2.6300366929E-01, 7.8441642679E-01],
	[2.5380000000E+04, 4.5522988528E+00, 3.1740285279E+00, 3.0623367310E-01, 2.6314359662E-01, 7.8446503178E-01],
	[2.5385000000E+04, 4.5537034298E+00, 3.1739699337E+00, 3.0641743177E-01, 2.6328356234E-01, 7.8451361382E-01],
	[2.5390000000E+04, 4.5551081635E+00, 3.1739113522E+00, 3.0660126443E-01, 2.6342356646E-01, 7.8456217294E-01],
	[2.5395000000E+04, 4.5565130537E+00, 3.1738527832E+00, 3.0678517107E-01, 2.6356360895E-01, 7.8461070913E-01],
	[2.5400000000E+04, 4.5579181005E+00, 3.1737942268E+00, 3.0696915173E-01, 2.6370368983E-01, 7.8465922240E-01],
	[2.5405000000E+04, 4.5593233039E+00, 3.1737356831E+00, 3.0715320640E-01, 2.6384380907E-01, 7.8470771278E-01],
	[2.5410000000E+04, 4.5607286639E+00, 3.1736771520E+00, 3.0733733511E-01, 2.6398396668E-01, 7.8475618026E-01],
	[2.5415000000E+04, 4.5621341804E+00, 3.1736186334E+00, 3.0752153788E-01, 2.6412416265E-01, 7.8480462486E-01],
	[2.5420000000E+04, 4.5635398535E+00, 3.1735601274E+00, 3.0770581471E-01, 2.6426439698E-01, 7.8485304659E-01],
	[2.5425000000E+04, 4.5649456831E+00, 3.1735016341E+00, 3.0789016563E-01, 2.6440466965E-01, 7.8490144545E-01],
	[2.5430000000E+04, 4.5663516692E+00, 3.1734431533E+00, 3.0807459065E-01, 2.6454498066E-01, 7.8494982146E-01],
	[2.5435000000E+04, 4.5677578117E+00, 3.1733846851E+00, 3.0825908978E-01, 2.6468533002E-01, 7.8499817463E-01],
	[2.5440000000E+04, 4.5691641108E+00, 3.1733262294E+00, 3.0844366303E-01, 2.6482571770E-01, 7.8504650497E-01],
	[2.5445000000E+04, 4.5705705663E+00, 3.1732677863E+00, 3.0862831044E-01, 2.6496614371E-01, 7.8509481248E-01],
	[2.5450000000E+04, 4.5719771783E+00, 3.1732093558E+00, 3.0881303200E-01, 2.6510660803E-01, 7.8514309718E-01],
	[2.5455000000E+04, 4.5733839468E+00, 3.1731509378E+00, 3.0899782773E-01, 2.6524711067E-01, 7.8519135908E-01],
	[2.5460000000E+04, 4.5747908716E+00, 3.1730925324E+00, 3.0918269766E-01, 2.6538765162E-01, 7.8523959818E-01],
	[2.5465000000E+04, 4.5761979529E+00, 3.1730341395E+00, 3.0936764178E-01, 2.6552823086E-01, 7.8528781450E-01],
	[2.5470000000E+04, 4.5776051906E+00, 3.1729757592E+00, 3.0955266013E-01, 2.6566884841E-01, 7.8533600805E-01],
	[2.5475000000E+04, 4.5790125846E+00, 3.1729173914E+00, 3.0973775272E-01, 2.6580950424E-01, 7.8538417884E-01],
	[2.5480000000E+04, 4.5804201351E+00, 3.1728590361E+00, 3.0992291955E-01, 2.6595019836E-01, 7.8543232687E-01],
	[2.5485000000E+04, 4.5818278419E+00, 3.1728006933E+00, 3.1010816065E-01, 2.6609093075E-01, 7.8548045216E-01],
	[2.5490000000E+04, 4.5832357050E+00, 3.1727423631E+00, 3.1029347603E-01, 2.6623170142E-01, 7.8552855471E-01],
	[2.5495000000E+04, 4.5846458597E+00, 3.1726849475E+00, 3.1047886570E-01, 2.6637252392E-01, 7.8557663455E-01],
	[2.5500000000E+04, 4.5860599668E+00, 3.1726291475E+00, 3.1066432969E-01, 2.6651340883E-01, 7.8562469167E-01],
	[2.5505000000E+04, 4.5874742328E+00, 3.1725733593E+00, 3.1084986800E-01, 2.6665433206E-01, 7.8567272608E-01],
	[2.5510000000E+04, 4.5888886575E+00, 3.1725175831E+00, 3.1103548065E-01, 2.6679529360E-01, 7.8572073780E-01],
	[2.5515000000E+04, 4.5903032410E+00, 3.1724618188E+00, 3.1122116766E-01, 2.6693629344E-01, 7.8576872684E-01],
	[2.5520000000E+04, 4.5917179833E+00, 3.1724060664E+00, 3.1140692904E-01, 2.6707733158E-01, 7.8581669321E-01],
	[2.5525000000E+04, 4.5931328843E+00, 3.1723503259E+00, 3.1159276480E-01, 2.6721840801E-01, 7.8586463691E-01],
	[2.5530000000E+04, 4.5945479440E+00, 3.1722945973E+00, 3.1177867497E-01, 2.6735952272E-01, 7.8591255796E-01],
	[2.5535000000E+04, 4.5959631625E+00, 3.1722388806E+00, 3.1196465956E-01, 2.6750067572E-01, 7.8596045637E-01],
	[2.5540000000E+04, 4.5973785397E+00, 3.1721831757E+00, 3.1215071857E-01, 2.6764186699E-01, 7.8600833214E-01],
	[2.5545000000E+04, 4.5987940755E+00, 3.1721274828E+00, 3.1233685204E-01, 2.6778309652E-01, 7.8605618529E-01],
	[2.5550000000E+04, 4.6002097700E+00, 3.1720718017E+00, 3.1252305997E-01, 2.6792436432E-01, 7.8610401583E-01],
	[2.5555000000E+04, 4.6016256232E+00, 3.1720161325E+00, 3.1270934237E-01, 2.6806567038E-01, 7.8615182376E-01],
	[2.5560000000E+04, 4.6030416351E+00, 3.1719604752E+00, 3.1289569927E-01, 2.6820701468E-01, 7.8619960910E-01],
	[2.5565000000E+04, 4.6044578055E+00, 3.1719048297E+00, 3.1308213067E-01, 2.6834839723E-01, 7.8624737186E-01],
	[2.5570000000E+04, 4.6058741346E+00, 3.1718491961E+00, 3.1326863660E-01, 2.6848981802E-01, 7.8629511204E-01],
	[2.5575000000E+04, 4.6072906223E+00, 3.1717935744E+00, 3.1345521707E-01, 2.6863127703E-01, 7.8634282966E-01],
	[2.5580000000E+04, 4.6087072686E+00, 3.1717379645E+00, 3.1364187209E-01, 2.6877277428E-01, 7.8639052472E-01],
	[2.5585000000E+04, 4.6101240735E+00, 3.1716823664E+00, 3.1382860167E-01, 2.6891430975E-01, 7.8643819724E-01],
	[2.5590000000E+04, 4.6115410370E+00, 3.1716267802E+00, 3.1401540585E-01, 2.6905588343E-01, 7.8648584723E-01],
	[2.5595000000E+04, 4.6129581590E+00, 3.1715712058E+00, 3.1420228462E-01, 2.6919749532E-01, 7.8653347470E-01],
	[2.5600000000E+04, 4.6143754396E+00, 3.1715156432E+00, 3.1438923800E-01, 2.6933914541E-01, 7.8658107965E-01],
	[2.5605000000E+04, 4.6157928787E+00, 3.1714600925E+00, 3.1457626602E-01, 2.6948083369E-01, 7.8662866209E-01],
	[2.5610000000E+04, 4.6172104763E+00, 3.1714045535E+00, 3.1476336867E-01, 2.6962256017E-01, 7.8667622205E-01],
	[2.5615000000E+04, 4.6186282324E+00, 3.1713490264E+00, 3.1495054599E-01, 2.6976432483E-01, 7.8672375952E-01],
	[2.5620000000E+04, 4.6200461470E+00, 3.1712935111E+00, 3.1513779799E-01, 2.6990612768E-01, 7.8677127452E-01],
	[2.5625000000E+04, 4.6214642201E+00, 3.1712380077E+00, 3.1532512467E-01, 2.7004796869E-01, 7.8681876705E-01],
	[2.5630000000E+04, 4.6228824516E+00, 3.1711825160E+00, 3.1551252606E-01, 2.7018984787E-01, 7.8686623713E-01],
	[2.5635000000E+04, 4.6243008416E+00, 3.1711270361E+00, 3.1570000217E-01, 2.7033176521E-01, 7.8691368476E-01],
	[2.5640000000E+04, 4.6257193900E+00, 3.1710715680E+00, 3.1588755301E-01, 2.7047372070E-01, 7.8696110997E-01],
	[2.5645000000E+04, 4.6271380969E+00, 3.1710161116E+00, 3.1607517861E-01, 2.7061571435E-01, 7.8700851274E-01],
	[2.5650000000E+04, 4.6285569622E+00, 3.1709606671E+00, 3.1626287897E-01, 2.7075774613E-01, 7.8705589311E-01],
	[2.5655000000E+04, 4.6299759859E+00, 3.1709052343E+00, 3.1645065411E-01, 2.7089981605E-01, 7.8710325107E-01],
	[2.5660000000E+04, 4.6313951679E+00, 3.1708498134E+00, 3.1663850405E-01, 2.7104192410E-01, 7.8715058664E-01],
	[2.5665000000E+04, 4.6328145083E+00, 3.1707944041E+00, 3.1682642880E-01, 2.7118407028E-01, 7.8719789982E-01],
	[2.5670000000E+04, 4.6342340071E+00, 3.1707390067E+00, 3.1701442837E-01, 2.7132625457E-01, 7.8724519063E-01],
	[2.5675000000E+04, 4.6356536643E+00, 3.1706836210E+00, 3.1720250279E-01, 2.7146847698E-01, 7.8729245908E-01],
	[2.5680000000E+04, 4.6370734797E+00, 3.1706282470E+00, 3.1739065206E-01, 2.7161073749E-01, 7.8733970517E-01],
	[2.5685000000E+04, 4.6384934535E+00, 3.1705728848E+00, 3.1757887621E-01, 2.7175303610E-01, 7.8738692892E-01],
	[2.5690000000E+04, 4.6399135856E+00, 3.1705175343E+00, 3.1776717524E-01, 2.7189537281E-01, 7.8743413033E-01],
	[2.5695000000E+04, 4.6413338760E+00, 3.1704621956E+00, 3.1795554918E-01, 2.7203774760E-01, 7.8748130942E-01],
	[2.5700000000E+04, 4.6427543246E+00, 3.1704068686E+00, 3.1814399803E-01, 2.7218016047E-01, 7.8752846620E-01],
	[2.5705000000E+04, 4.6441749316E+00, 3.1703515533E+00, 3.1833252182E-01, 2.7232261142E-01, 7.8757560068E-01],
	[2.5710000000E+04, 4.6455956968E+00, 3.1702962498E+00, 3.1852112055E-01, 2.7246510044E-01, 7.8762271286E-01],
	[2.5715000000E+04, 4.6470166202E+00, 3.1702409580E+00, 3.1870979425E-01, 2.7260762753E-01, 7.8766980275E-01],
	[2.5720000000E+04, 4.6484377018E+00, 3.1701856779E+00, 3.1889854293E-01, 2.7275019266E-01, 7.8771687037E-01],
	[2.5725000000E+04, 4.6498589417E+00, 3.1701304095E+00, 3.1908736660E-01, 2.7289279585E-01, 7.8776391573E-01],
	[2.5730000000E+04, 4.6512803398E+00, 3.1700751528E+00, 3.1927626528E-01, 2.7303543709E-01, 7.8781093884E-01],
	[2.5735000000E+04, 4.6527018960E+00, 3.1700199078E+00, 3.1946523898E-01, 2.7317811636E-01, 7.8785793970E-01],
	[2.5740000000E+04, 4.6541236105E+00, 3.1699646745E+00, 3.1965428772E-01, 2.7332083367E-01, 7.8790491832E-01],
	[2.5745000000E+04, 4.6555454831E+00, 3.1699094529E+00, 3.1984341151E-01, 2.7346358900E-01, 7.8795187473E-01],
	[2.5750000000E+04, 4.6569675138E+00, 3.1698542429E+00, 3.2003261038E-01, 2.7360638235E-01, 7.8799880892E-01],
	[2.5755000000E+04, 4.6583897027E+00, 3.1697990447E+00, 3.2022188432E-01, 2.7374921372E-01, 7.8804572090E-01],
	[2.5760000000E+04, 4.6598120497E+00, 3.1697438581E+00, 3.2041123337E-01, 2.7389208309E-01, 7.8809261069E-01],
	[2.5765000000E+04, 4.6612345548E+00, 3.1696886832E+00, 3.2060065754E-01, 2.7403499047E-01, 7.8813947830E-01],
	[2.5770000000E+04, 4.6626572180E+00, 3.1696335200E+00, 3.2079015683E-01, 2.7417793584E-01, 7.8818632373E-01],
	[2.5775000000E+04, 4.6640800393E+00, 3.1695783684E+00, 3.2097973127E-01, 2.7432091920E-01, 7.8823314700E-01],
	[2.5780000000E+04, 4.6655030186E+00, 3.1695232285E+00, 3.2116938087E-01, 2.7446394054E-01, 7.8827994812E-01],
	[2.5785000000E+04, 4.6669261560E+00, 3.1694681002E+00, 3.2135910564E-01, 2.7460699986E-01, 7.8832672709E-01],
	[2.5790000000E+04, 4.6683494515E+00, 3.1694129836E+00, 3.2154890560E-01, 2.7475009715E-01, 7.8837348393E-01],
	[2.5795000000E+04, 4.6697729050E+00, 3.1693578787E+00, 3.2173878077E-01, 2.7489323241E-01, 7.8842021864E-01],
	[2.5800000000E+04, 4.6711965165E+00, 3.1693027853E+00, 3.2192873117E-01, 2.7503640562E-01, 7.8846693124E-01],
	[2.5805000000E+04, 4.6726202860E+00, 3.1692477036E+00, 3.2211875679E-01, 2.7517961679E-01, 7.8851362174E-01],
	[2.5810000000E+04, 4.6740442135E+00, 3.1691926336E+00, 3.2230885767E-01, 2.7532286590E-01, 7.8856029014E-01],
	[2.5815000000E+04, 4.6754682990E+00, 3.1691375751E+00, 3.2249903382E-01, 2.7546615295E-01, 7.8860693646E-01],
	[2.5820000000E+04, 4.6768925424E+00, 3.1690825283E+00, 3.2268928525E-01, 2.7560947793E-01, 7.8865356070E-01],
	[2.5825000000E+04, 4.6783169438E+00, 3.1690274931E+00, 3.2287961197E-01, 2.7575284084E-01, 7.8870016288E-01],
	[2.5830000000E+04, 4.6797415032E+00, 3.1689724695E+00, 3.2307001401E-01, 2.7589624167E-01, 7.8874674301E-01],
	[2.5835000000E+04, 4.6811662204E+00, 3.1689174575E+00, 3.2326049137E-01, 2.7603968041E-01, 7.8879330109E-01],
	[2.5840000000E+04, 4.6825910956E+00, 3.1688624571E+00, 3.2345104408E-01, 2.7618315707E-01, 7.8883983714E-01],
	[2.5845000000E+04, 4.6840161287E+00, 3.1688074683E+00, 3.2364167214E-01, 2.7632667162E-01, 7.8888635116E-01],
	[2.5850000000E+04, 4.6854413196E+00, 3.1687524911E+00, 3.2383237558E-01, 2.7647022407E-01, 7.8893284317E-01],
	[2.5855000000E+04, 4.6868666685E+00, 3.1686975254E+00, 3.2402315441E-01, 2.7661381441E-01, 7.8897931318E-01],
	[2.5860000000E+04, 4.6882921752E+00, 3.1686425714E+00, 3.2421400864E-01, 2.7675744263E-01, 7.8902576119E-01],
	[2.5865000000E+04, 4.6897178397E+00, 3.1685876289E+00, 3.2440493828E-01, 2.7690110873E-01, 7.8907218722E-01],
	[2.5870000000E+04, 4.6911436621E+00, 3.1685326980E+00, 3.2459594336E-01, 2.7704481270E-01, 7.8911859127E-01],
	[2.5875000000E+04, 4.6925696423E+00, 3.1684777787E+00, 3.2478702389E-01, 2.7718855453E-01, 7.8916497336E-01],
	[2.5880000000E+04, 4.6939957803E+00, 3.1684228709E+00, 3.2497817988E-01, 2.7733233422E-01, 7.8921133349E-01],
	[2.5885000000E+04, 4.6954220761E+00, 3.1683679747E+00, 3.2516941136E-01, 2.7747615176E-01, 7.8925767168E-01],
	[2.5890000000E+04, 4.6968485297E+00, 3.1683130901E+00, 3.2536071832E-01, 2.7762000715E-01, 7.8930398794E-01],
	[2.5895000000E+04, 4.6982751410E+00, 3.1682582170E+00, 3.2555210080E-01, 2.7776390037E-01, 7.8935028227E-01],
	[2.5900000000E+04, 4.6997019101E+00, 3.1682033554E+00, 3.2574355880E-01, 2.7790783143E-01, 7.8939655469E-01],
	[2.5905000000E+04, 4.7011303474E+00, 3.1681491910E+00, 3.2593509234E-01, 2.7805181088E-01, 7.8944280521E-01],
	[2.5910000000E+04, 4.7025628486E+00, 3.1680968104E+00, 3.2612670143E-01, 2.7819585550E-01, 7.8948903383E-01],
	[2.5915000000E+04, 4.7039955097E+00, 3.1680444407E+00, 3.2631838610E-01, 2.7833993799E-01, 7.8953524056E-01],
	[2.5920000000E+04, 4.7054283308E+00, 3.1679920820E+00, 3.2651014635E-01, 2.7848405835E-01, 7.8958142543E-01],
	[2.5925000000E+04, 4.7068613119E+00, 3.1679397343E+00, 3.2670198220E-01, 2.7862821657E-01, 7.8962758842E-01],
	[2.5930000000E+04, 4.7082944529E+00, 3.1678873975E+00, 3.2689389367E-01, 2.7877241265E-01, 7.8967372957E-01],
	[2.5935000000E+04, 4.7097277537E+00, 3.1678350717E+00, 3.2708588076E-01, 2.7891664657E-01, 7.8971984887E-01],
	[2.5940000000E+04, 4.7111612145E+00, 3.1677827568E+00, 3.2727794351E-01, 2.7906091833E-01, 7.8976594633E-01],
	[2.5945000000E+04, 4.7125948352E+00, 3.1677304528E+00, 3.2747008191E-01, 2.7920522793E-01, 7.8981202197E-01],
	[2.5950000000E+04, 4.7140286158E+00, 3.1676781599E+00, 3.2766229599E-01, 2.7934957536E-01, 7.8985807580E-01],
	[2.5955000000E+04, 4.7154625562E+00, 3.1676258778E+00, 3.2785458577E-01, 2.7949396062E-01, 7.8990410782E-01],
	[2.5960000000E+04, 4.7168966565E+00, 3.1675736067E+00, 3.2804695124E-01, 2.7963838368E-01, 7.8995011805E-01],
	[2.5965000000E+04, 4.7183309166E+00, 3.1675213465E+00, 3.2823939245E-01, 2.7978284456E-01, 7.8999610649E-01],
	[2.5970000000E+04, 4.7197653365E+00, 3.1674690972E+00, 3.2843190938E-01, 2.7992734324E-01, 7.9004207316E-01],
	[2.5975000000E+04, 4.7211999162E+00, 3.1674168589E+00, 3.2862450208E-01, 2.8007187972E-01, 7.9008801807E-01],
	[2.5980000000E+04, 4.7226346557E+00, 3.1673646315E+00, 3.2881717053E-01, 2.8021645399E-01, 7.9013394122E-01],
	[2.5985000000E+04, 4.7240695551E+00, 3.1673124150E+00, 3.2900991477E-01, 2.8036106605E-01, 7.9017984262E-01],
	[2.5990000000E+04, 4.7255046141E+00, 3.1672602093E+00, 3.2920273481E-01, 2.8050571588E-01, 7.9022572229E-01],
	[2.5995000000E+04, 4.7269398330E+00, 3.1672080146E+00, 3.2939563066E-01, 2.8065040348E-01, 7.9027158024E-01],
	[2.6000000000E+04, 4.7283752116E+00, 3.1671558308E+00, 3.2958860234E-01, 2.8079512885E-01, 7.9031741647E-01],
	[2.6005000000E+04, 4.7298107499E+00, 3.1671036579E+00, 3.2978164987E-01, 2.8093989198E-01, 7.9036323100E-01],
	[2.6010000000E+04, 4.7312464479E+00, 3.1670514959E+00, 3.2997477325E-01, 2.8108469286E-01, 7.9040902383E-01],
	[2.6015000000E+04, 4.7326823057E+00, 3.1669993448E+00, 3.3016797251E-01, 2.8122953148E-01, 7.9045479498E-01],
	[2.6020000000E+04, 4.7341183231E+00, 3.1669472045E+00, 3.3036124765E-01, 2.8137440785E-01, 7.9050054446E-01],
	[2.6025000000E+04, 4.7355545003E+00, 3.1668950751E+00, 3.3055459870E-01, 2.8151932194E-01, 7.9054627227E-01],
	[2.6030000000E+04, 4.7369908370E+00, 3.1668429566E+00, 3.3074802567E-01, 2.8166427377E-01, 7.9059197842E-01],
	[2.6035000000E+04, 4.7384273335E+00, 3.1667908490E+00, 3.3094152857E-01, 2.8180926331E-01, 7.9063766293E-01],
	[2.6040000000E+04, 4.7398639896E+00, 3.1667387522E+00, 3.3113510742E-01, 2.8195429057E-01, 7.9068332581E-01],
	[2.6045000000E+04, 4.7413008053E+00, 3.1666866663E+00, 3.3132876224E-01, 2.8209935553E-01, 7.9072896706E-01],
	[2.6050000000E+04, 4.7427377806E+00, 3.1666345912E+00, 3.3152249303E-01, 2.8224445820E-01, 7.9077458669E-01],
	[2.6055000000E+04, 4.7441749156E+00, 3.1665825270E+00, 3.3171629982E-01, 2.8238959855E-01, 7.9082018472E-01],
	[2.6060000000E+04, 4.7456122101E+00, 3.1665304736E+00, 3.3191018263E-01, 2.8253477660E-01, 7.9086576116E-01],
	[2.6065000000E+04, 4.7470496642E+00, 3.1664784311E+00, 3.3210414145E-01, 2.8267999233E-01, 7.9091131601E-01],
	[2.6070000000E+04, 4.7484872779E+00, 3.1664263994E+00, 3.3229817632E-01, 2.8282524573E-01, 7.9095684929E-01],
	[2.6075000000E+04, 4.7499250511E+00, 3.1663743785E+00, 3.3249228725E-01, 2.8297053680E-01, 7.9100236100E-01],
	[2.6080000000E+04, 4.7513629838E+00, 3.1663223685E+00, 3.3268647424E-01, 2.8311586553E-01, 7.9104785116E-01],
	[2.6085000000E+04, 4.7528010761E+00, 3.1662703693E+00, 3.3288073732E-01, 2.8326123191E-01, 7.9109331977E-01],
	[2.6090000000E+04, 4.7542393279E+00, 3.1662183809E+00, 3.3307507651E-01, 2.8340663595E-01, 7.9113876685E-01],
	[2.6095000000E+04, 4.7556777392E+00, 3.1661664034E+00, 3.3326949181E-01, 2.8355207762E-01, 7.9118419240E-01],
	[2.6100000000E+04, 4.7571163100E+00, 3.1661144366E+00, 3.3346398324E-01, 2.8369755693E-01, 7.9122959644E-01],
	[2.6105000000E+04, 4.7585550402E+00, 3.1660624807E+00, 3.3365855082E-01, 2.8384307387E-01, 7.9127497897E-01],
	[2.6110000000E+04, 4.7599939300E+00, 3.1660105355E+00, 3.3385319456E-01, 2.8398862844E-01, 7.9132034001E-01],
	[2.6115000000E+04, 4.7614329791E+00, 3.1659586012E+00, 3.3404791448E-01, 2.8413422061E-01, 7.9136567956E-01],
	[2.6120000000E+04, 4.7628721877E+00, 3.1659066776E+00, 3.3424271059E-01, 2.8427985040E-01, 7.9141099763E-01],
	[2.6125000000E+04, 4.7643115557E+00, 3.1658547648E+00, 3.3443758291E-01, 2.8442551779E-01, 7.9145629424E-01],
	[2.6130000000E+04, 4.7657510832E+00, 3.1658028629E+00, 3.3463253145E-01, 2.8457122278E-01, 7.9150156940E-01],
	[2.6135000000E+04, 4.7671907700E+00, 3.1657509717E+00, 3.3482755623E-01, 2.8471696535E-01, 7.9154682311E-01],
	[2.6140000000E+04, 4.7686306162E+00, 3.1656990912E+00, 3.3502265726E-01, 2.8486274551E-01, 7.9159205539E-01],
	[2.6145000000E+04, 4.7700706218E+00, 3.1656472216E+00, 3.3521783456E-01, 2.8500856324E-01, 7.9163726624E-01],
	[2.6150000000E+04, 4.7715107868E+00, 3.1655953627E+00, 3.3541308814E-01, 2.8515441854E-01, 7.9168245567E-01],
	[2.6155000000E+04, 4.7729511110E+00, 3.1655435146E+00, 3.3560841803E-01, 2.8530031141E-01, 7.9172762370E-01],
	[2.6160000000E+04, 4.7743915947E+00, 3.1654916772E+00, 3.3580382423E-01, 2.8544624183E-01, 7.9177277033E-01],
	[2.6165000000E+04, 4.7758322376E+00, 3.1654398506E+00, 3.3599930675E-01, 2.8559220980E-01, 7.9181789558E-01],
	[2.6170000000E+04, 4.7772730399E+00, 3.1653880348E+00, 3.3619486562E-01, 2.8573821532E-01, 7.9186299945E-01],
	[2.6175000000E+04, 4.7787140014E+00, 3.1653362297E+00, 3.3639050085E-01, 2.8588425837E-01, 7.9190808196E-01],
	[2.6180000000E+04, 4.7801551222E+00, 3.1652844353E+00, 3.3658621246E-01, 2.8603033895E-01, 7.9195314311E-01],
	[2.6185000000E+04, 4.7815964023E+00, 3.1652326517E+00, 3.3678200045E-01, 2.8617645705E-01, 7.9199818292E-01],
	[2.6190000000E+04, 4.7830378417E+00, 3.1651808788E+00, 3.3697786485E-01, 2.8632261267E-01, 7.9204320139E-01],
	[2.6195000000E+04, 4.7844794403E+00, 3.1651291167E+00, 3.3717380568E-01, 2.8646880580E-01, 7.9208819853E-01],
	[2.6200000000E+04, 4.7859211981E+00, 3.1650773652E+00, 3.3736982293E-01, 2.8661503644E-01, 7.9213317436E-01],
	[2.6205000000E+04, 4.7873631151E+00, 3.1650256245E+00, 3.3756591664E-01, 2.8676130456E-01, 7.9217812888E-01],
	[2.6210000000E+04, 4.7888051914E+00, 3.1649738945E+00, 3.3776208681E-01, 2.8690761018E-01, 7.9222306210E-01],
	[2.6215000000E+04, 4.7902474268E+00, 3.1649221752E+00, 3.3795833346E-01, 2.8705395329E-01, 7.9226797404E-01],
	[2.6220000000E+04, 4.7916898214E+00, 3.1648704667E+00, 3.3815465661E-01, 2.8720033386E-01, 7.9231286471E-01],
	[2.6225000000E+04, 4.7931323752E+00, 3.1648187688E+00, 3.3835105628E-01, 2.8734675191E-01, 7.9235773410E-01],
	[2.6230000000E+04, 4.7945750882E+00, 3.1647670816E+00, 3.3854753246E-01, 2.8749320742E-01, 7.9240258225E-01],
	[2.6235000000E+04, 4.7960179602E+00, 3.1647154052E+00, 3.3874408519E-01, 2.8763970039E-01, 7.9244740914E-01],
	[2.6240000000E+04, 4.7974609914E+00, 3.1646637394E+00, 3.3894071448E-01, 2.8778623081E-01, 7.9249221480E-01],
	[2.6245000000E+04, 4.7989041818E+00, 3.1646120843E+00, 3.3913742034E-01, 2.8793279867E-01, 7.9253699923E-01],
	[2.6250000000E+04, 4.8003475312E+00, 3.1645604399E+00, 3.3933420278E-01, 2.8807940396E-01, 7.9258176245E-01],
	[2.6255000000E+04, 4.8017910397E+00, 3.1645088061E+00, 3.3953106183E-01, 2.8822604669E-01, 7.9262650446E-01],
	[2.6260000000E+04, 4.8032347073E+00, 3.1644571831E+00, 3.3972799750E-01, 2.8837272684E-01, 7.9267122527E-01],
	[2.6265000000E+04, 4.8046785339E+00, 3.1644055707E+00, 3.3992500980E-01, 2.8851944440E-01, 7.9271592490E-01],
	[2.6270000000E+04, 4.8061225196E+00, 3.1643539690E+00, 3.4012209875E-01, 2.8866619937E-01, 7.9276060334E-01],
	[2.6275000000E+04, 4.8075666644E+00, 3.1643023779E+00, 3.4031926436E-01, 2.8881299175E-01, 7.9280526063E-01],
	[2.6280000000E+04, 4.8090109681E+00, 3.1642507975E+00, 3.4051650664E-01, 2.8895982152E-01, 7.9284989675E-01],
	[2.6285000000E+04, 4.8104554309E+00, 3.1641992277E+00, 3.4071382563E-01, 2.8910668868E-01, 7.9289451171E-01],
	[2.6290000000E+04, 4.8119000527E+00, 3.1641476686E+00, 3.4091122132E-01, 2.8925359322E-01, 7.9293910552E-01],
	[2.6295000000E+04, 4.8133448335E+00, 3.1640961202E+00, 3.4110869373E-01, 2.8940053514E-01, 7.9298367820E-01],
	[2.6300000000E+04, 4.8147897732E+00, 3.1640445824E+00, 3.4130624289E-01, 2.8954751442E-01, 7.9302822975E-01],
	[2.6305000000E+04, 4.8162348719E+00, 3.1639930552E+00, 3.4150386880E-01, 2.8969453107E-01, 7.9307276018E-01],
	[2.6310000000E+04, 4.8176801296E+00, 3.1639415386E+00, 3.4170157148E-01, 2.8984158507E-01, 7.9311726950E-01],
	[2.6315000000E+04, 4.8191255462E+00, 3.1638900327E+00, 3.4189935094E-01, 2.8998867642E-01, 7.9316175772E-01],
	[2.6320000000E+04, 4.8205711217E+00, 3.1638385374E+00, 3.4209720720E-01, 2.9013580512E-01, 7.9320622485E-01],
	[2.6325000000E+04, 4.8220211432E+00, 3.1637891663E+00, 3.4229514028E-01, 2.9028300447E-01, 7.9325067090E-01],
	[2.6330000000E+04, 4.8234719303E+00, 3.1637401034E+00, 3.4249315019E-01, 2.9043024591E-01, 7.9329509588E-01],
	[2.6335000000E+04, 4.8249228783E+00, 3.1636910506E+00, 3.4269123694E-01, 2.9057752473E-01, 7.9333949979E-01],
	[2.6340000000E+04, 4.8263739872E+00, 3.1636420079E+00, 3.4288940056E-01, 2.9072484093E-01, 7.9338388266E-01],
	[2.6345000000E+04, 4.8278252569E+00, 3.1635929752E+00, 3.4308764105E-01, 2.9087219449E-01, 7.9342824448E-01],
	[2.6350000000E+04, 4.8292766875E+00, 3.1635439526E+00, 3.4328595843E-01, 2.9101958541E-01, 7.9347258527E-01],
	[2.6355000000E+04, 4.8307282790E+00, 3.1634949401E+00, 3.4348435272E-01, 2.9116701369E-01, 7.9351690503E-01],
	[2.6360000000E+04, 4.8321800312E+00, 3.1634459376E+00, 3.4368282393E-01, 2.9131447931E-01, 7.9356120378E-01],
	[2.6365000000E+04, 4.8336319443E+00, 3.1633969452E+00, 3.4388137207E-01, 2.9146198228E-01, 7.9360548153E-01],
	[2.6370000000E+04, 4.8350840182E+00, 3.1633479628E+00, 3.4407999717E-01, 2.9160952257E-01, 7.9364973828E-01],
	[2.6375000000E+04, 4.8365362529E+00, 3.1632989905E+00, 3.4427869923E-01, 2.9175710020E-01, 7.9369397404E-01],
	[2.6380000000E+04, 4.8379886484E+00, 3.1632500282E+00, 3.4447747828E-01, 2.9190471514E-01, 7.9373818883E-01],
	[2.6385000000E+04, 4.8394412047E+00, 3.1632010760E+00, 3.4467633432E-01, 2.9205236739E-01, 7.9378238265E-01],
	[2.6390000000E+04, 4.8408939217E+00, 3.1631521337E+00, 3.4487526738E-01, 2.9220005695E-01, 7.9382655551E-01],
	[2.6395000000E+04, 4.8423467994E+00, 3.1631032016E+00, 3.4507427747E-01, 2.9234778381E-01, 7.9387070742E-01],
	[2.6400000000E+04, 4.8437998379E+00, 3.1630542794E+00, 3.4527336459E-01, 2.9249554797E-01, 7.9391483840E-01],
	[2.6405000000E+04, 4.8452530371E+00, 3.1630053672E+00, 3.4547252878E-01, 2.9264334940E-01, 7.9395894845E-01],
	[2.6410000000E+04, 4.8467063970E+00, 3.1629564651E+00, 3.4567177004E-01, 2.9279118812E-01, 7.9400303758E-01],
	[2.6415000000E+04, 4.8481599176E+00, 3.1629075730E+00, 3.4587108838E-01, 2.9293906411E-01, 7.9404710580E-01],
	[2.6420000000E+04, 4.8496135988E+00, 3.1628586909E+00, 3.4607048384E-01, 2.9308697736E-01, 7.9409115312E-01],
	[2.6425000000E+04, 4.8510674408E+00, 3.1628098188E+00, 3.4626995641E-01, 2.9323492787E-01, 7.9413517955E-01],
	[2.6430000000E+04, 4.8525214434E+00, 3.1627609567E+00, 3.4646950611E-01, 2.9338291563E-01, 7.9417918509E-01],
	[2.6435000000E+04, 4.8539756066E+00, 3.1627121046E+00, 3.4666913296E-01, 2.9353094063E-01, 7.9422316977E-01],
	[2.6440000000E+04, 4.8554299305E+00, 3.1626632625E+00, 3.4686883698E-01, 2.9367900287E-01, 7.9426713358E-01],
	[2.6445000000E+04, 4.8568844149E+00, 3.1626144304E+00, 3.4706861818E-01, 2.9382710234E-01, 7.9431107654E-01],
	[2.6450000000E+04, 4.8583390600E+00, 3.1625656083E+00, 3.4726847657E-01, 2.9397523904E-01, 7.9435499866E-01],
	[2.6455000000E+04, 4.8597938657E+00, 3.1625167961E+00, 3.4746841217E-01, 2.9412341295E-01, 7.9439889994E-01],
	[2.6460000000E+04, 4.8612488320E+00, 3.1624679940E+00, 3.4766842500E-01, 2.9427162407E-01, 7.9444278040E-01],
	[2.6465000000E+04, 4.8627039588E+00, 3.1624192018E+00, 3.4786851507E-01, 2.9441987239E-01, 7.9448664004E-01],
	[2.6470000000E+04, 4.8641592461E+00, 3.1623704195E+00, 3.4806868239E-01, 2.9456815791E-01, 7.9453047888E-01],
	[2.6475000000E+04, 4.8656146940E+00, 3.1623216473E+00, 3.4826892698E-01, 2.9471648062E-01, 7.9457429693E-01],
	[2.6480000000E+04, 4.8670703025E+00, 3.1622728850E+00, 3.4846924886E-01, 2.9486484050E-01, 7.9461809418E-01],
	[2.6485000000E+04, 4.8685260714E+00, 3.1622241326E+00, 3.4866964804E-01, 2.9501323757E-01, 7.9466187066E-01],
	[2.6490000000E+04, 4.8699820009E+00, 3.1621753903E+00, 3.4887012454E-01, 2.9516167180E-01, 7.9470562638E-01],
	[2.6495000000E+04, 4.8714380908E+00, 3.1621266578E+00, 3.4907067837E-01, 2.9531014319E-01, 7.9474936133E-01],
	[2.6500000000E+04, 4.8728943413E+00, 3.1620779353E+00, 3.4927130955E-01, 2.9545865173E-01, 7.9479307554E-01],
	[2.6505000000E+04, 4.8743507521E+00, 3.1620292228E+00, 3.4947201808E-01, 2.9560719743E-01, 7.9483676901E-01],
	[2.6510000000E+04, 4.8758073235E+00, 3.1619805202E+00, 3.4967280400E-01, 2.9575578026E-01, 7.9488044174E-01],
	[2.6515000000E+04, 4.8772640553E+00, 3.1619318275E+00, 3.4987366731E-01, 2.9590440022E-01, 7.9492409376E-01],
	[2.6520000000E+04, 4.8787209475E+00, 3.1618831448E+00, 3.5007460802E-01, 2.9605305731E-01, 7.9496772507E-01],
	[2.6525000000E+04, 4.8801780001E+00, 3.1618344720E+00, 3.5027562616E-01, 2.9620175152E-01, 7.9501133568E-01],
	[2.6530000000E+04, 4.8816352131E+00, 3.1617858091E+00, 3.5047672173E-01, 2.9635048284E-01, 7.9505492560E-01],
	[2.6535000000E+04, 4.8830925865E+00, 3.1617371561E+00, 3.5067789476E-01, 2.9649925127E-01, 7.9509849483E-01],
	[2.6540000000E+04, 4.8845501203E+00, 3.1616885130E+00, 3.5087914526E-01, 2.9664805679E-01, 7.9514204339E-01],
	[2.6545000000E+04, 4.8860078145E+00, 3.1616398799E+00, 3.5108047324E-01, 2.9679689940E-01, 7.9518557129E-01],
	[2.6550000000E+04, 4.8874656690E+00, 3.1615912567E+00, 3.5128187871E-01, 2.9694577910E-01, 7.9522907854E-01],
	[2.6555000000E+04, 4.8889236838E+00, 3.1615426433E+00, 3.5148336171E-01, 2.9709469587E-01, 7.9527256514E-01],
	[2.6560000000E+04, 4.8903818590E+00, 3.1614940399E+00, 3.5168492223E-01, 2.9724364972E-01, 7.9531603111E-01],
	[2.6565000000E+04, 4.8918401945E+00, 3.1614454464E+00, 3.5188656029E-01, 2.9739264062E-01, 7.9535947646E-01],
	[2.6570000000E+04, 4.8932986903E+00, 3.1613968627E+00, 3.5208827592E-01, 2.9754166858E-01, 7.9540290119E-01],
	[2.6575000000E+04, 4.8947573463E+00, 3.1613482889E+00, 3.5229006912E-01, 2.9769073359E-01, 7.9544630531E-01],
	[2.6580000000E+04, 4.8962161627E+00, 3.1612997251E+00, 3.5249193991E-01, 2.9783983565E-01, 7.9548968883E-01],
	[2.6585000000E+04, 4.8976751393E+00, 3.1612511711E+00, 3.5269388830E-01, 2.9798897473E-01, 7.9553305177E-01],
	[2.6590000000E+04, 4.8991342762E+00, 3.1612026270E+00, 3.5289591431E-01, 2.9813815084E-01, 7.9557639414E-01],
	[2.6595000000E+04, 4.9005935733E+00, 3.1611540927E+00, 3.5309801796E-01, 2.9828736398E-01, 7.9561971593E-01],
	[2.6600000000E+04, 4.9020530306E+00, 3.1611055683E+00, 3.5330019926E-01, 2.9843661412E-01, 7.9566301717E-01],
	[2.6605000000E+04, 4.9035126481E+00, 3.1610570538E+00, 3.5350245823E-01, 2.9858590127E-01, 7.9570629785E-01],
	[2.6610000000E+04, 4.9049724259E+00, 3.1610085492E+00, 3.5370479488E-01, 2.9873522542E-01, 7.9574955800E-01],
	[2.6615000000E+04, 4.9064323638E+00, 3.1609600544E+00, 3.5390720922E-01, 2.9888458657E-01, 7.9579279762E-01],
	[2.6620000000E+04, 4.9078924619E+00, 3.1609115695E+00, 3.5410970127E-01, 2.9903398469E-01, 7.9583601672E-01],
	[2.6625000000E+04, 4.9093527202E+00, 3.1608630944E+00, 3.5431227106E-01, 2.9918341980E-01, 7.9587921530E-01],
	[2.6630000000E+04, 4.9108131386E+00, 3.1608146291E+00, 3.5451491858E-01, 2.9933289187E-01, 7.9592239339E-01],
	[2.6635000000E+04, 4.9122737172E+00, 3.1607661737E+00, 3.5471764386E-01, 2.9948240091E-01, 7.9596555098E-01],
	[2.6640000000E+04, 4.9137344559E+00, 3.1607177282E+00, 3.5492044691E-01, 2.9963194690E-01, 7.9600868809E-01],
	[2.6645000000E+04, 4.9151953547E+00, 3.1606692924E+00, 3.5512332775E-01, 2.9978152984E-01, 7.9605180473E-01],
	[2.6650000000E+04, 4.9166564136E+00, 3.1606208665E+00, 3.5532628639E-01, 2.9993114973E-01, 7.9609490091E-01],
	[2.6655000000E+04, 4.9181176326E+00, 3.1605724505E+00, 3.5552932285E-01, 3.0008080654E-01, 7.9613797663E-01],
	[2.6660000000E+04, 4.9195790116E+00, 3.1605240442E+00, 3.5573243714E-01, 3.0023050029E-01, 7.9618103190E-01],
	[2.6665000000E+04, 4.9210405508E+00, 3.1604756478E+00, 3.5593562928E-01, 3.0038023096E-01, 7.9622406674E-01],
	[2.6670000000E+04, 4.9225022500E+00, 3.1604272612E+00, 3.5613889928E-01, 3.0052999854E-01, 7.9626708116E-01],
	[2.6675000000E+04, 4.9239641092E+00, 3.1603788843E+00, 3.5634224716E-01, 3.0067980302E-01, 7.9631007516E-01],
	[2.6680000000E+04, 4.9254261284E+00, 3.1603305173E+00, 3.5654567294E-01, 3.0082964440E-01, 7.9635304875E-01],
	[2.6685000000E+04, 4.9268883077E+00, 3.1602821602E+00, 3.5674917662E-01, 3.0097952268E-01, 7.9639600195E-01],
	[2.6690000000E+04, 4.9283506469E+00, 3.1602338128E+00, 3.5695275823E-01, 3.0112943784E-01, 7.9643893476E-01],
	[2.6695000000E+04, 4.9298131462E+00, 3.1601854752E+00, 3.5715641778E-01, 3.0127938988E-01, 7.9648184719E-01],
	[2.6700000000E+04, 4.9312758054E+00, 3.1601371473E+00, 3.5736015528E-01, 3.0142937878E-01, 7.9652473925E-01],
	[2.6705000000E+04, 4.9327386246E+00, 3.1600888293E+00, 3.5756397075E-01, 3.0157940455E-01, 7.9656761095E-01],
	[2.6710000000E+04, 4.9342016037E+00, 3.1600405211E+00, 3.5776786421E-01, 3.0172946718E-01, 7.9661046230E-01],
	[2.6715000000E+04, 4.9356647428E+00, 3.1599922226E+00, 3.5797183566E-01, 3.0187956665E-01, 7.9665329331E-01],
	[2.6720000000E+04, 4.9371280418E+00, 3.1599439340E+00, 3.5817588514E-01, 3.0202970296E-01, 7.9669610400E-01],
	[2.6725000000E+04, 4.9385915008E+00, 3.1598956551E+00, 3.5838001264E-01, 3.0217987611E-01, 7.9673889436E-01],
	[2.6730000000E+04, 4.9400551196E+00, 3.1598473859E+00, 3.5858421819E-01, 3.0233008609E-01, 7.9678166440E-01],
	[2.6735000000E+04, 4.9415188983E+00, 3.1597991265E+00, 3.5878850179E-01, 3.0248033288E-01, 7.9682441415E-01],
	[2.6740000000E+04, 4.9429828369E+00, 3.1597508769E+00, 3.5899286348E-01, 3.0263061648E-01, 7.9686714360E-01],
	[2.6745000000E+04, 4.9444475067E+00, 3.1597029474E+00, 3.5919730325E-01, 3.0278094189E-01, 7.9690985277E-01],
	[2.6750000000E+04, 4.9459161235E+00, 3.1596570836E+00, 3.5940182113E-01, 3.0293133720E-01, 7.9695254167E-01],
	[2.6755000000E+04, 4.9473849019E+00, 3.1596112290E+00, 3.5960641714E-01, 3.0308176936E-01, 7.9699521030E-01],
	[2.6760000000E+04, 4.9488538419E+00, 3.1595653837E+00, 3.5981109128E-01, 3.0323223837E-01, 7.9703785868E-01],
	[2.6765000000E+04, 4.9503229434E+00, 3.1595195475E+00, 3.6001584357E-01, 3.0338274421E-01, 7.9708048681E-01],
	[2.6770000000E+04, 4.9517922065E+00, 3.1594737206E+00, 3.6022067403E-01, 3.0353328688E-01, 7.9712309470E-01],
	[2.6775000000E+04, 4.9532616312E+00, 3.1594279030E+00, 3.6042558267E-01, 3.0368386636E-01, 7.9716568237E-01],
	[2.6780000000E+04, 4.9547312174E+00, 3.1593820945E+00, 3.6063056951E-01, 3.0383448267E-01, 7.9720824982E-01],
	[2.6785000000E+04, 4.9562009652E+00, 3.1593362953E+00, 3.6083563456E-01, 3.0398513578E-01, 7.9725079707E-01],
	[2.6790000000E+04, 4.9576708745E+00, 3.1592905053E+00, 3.6104077784E-01, 3.0413582568E-01, 7.9729332411E-01],
	[2.6795000000E+04, 4.9591409453E+00, 3.1592447244E+00, 3.6124599936E-01, 3.0428655238E-01, 7.9733583097E-01],
	[2.6800000000E+04, 4.9606111776E+00, 3.1591989528E+00, 3.6145129915E-01, 3.0443731587E-01, 7.9737831764E-01],
	[2.6805000000E+04, 4.9620815714E+00, 3.1591531904E+00, 3.6165667720E-01, 3.0458811613E-01, 7.9742078415E-01],
	[2.6810000000E+04, 4.9635521266E+00, 3.1591074372E+00, 3.6186213354E-01, 3.0473895316E-01, 7.9746323050E-01],
	[2.6815000000E+04, 4.9650228433E+00, 3.1590616932E+00, 3.6206766819E-01, 3.0488982695E-01, 7.9750565670E-01],
	[2.6820000000E+04, 4.9664937215E+00, 3.1590159584E+00, 3.6227328116E-01, 3.0504073750E-01, 7.9754806275E-01],
	[2.6825000000E+04, 4.9679647611E+00, 3.1589702327E+00, 3.6247897246E-01, 3.0519168480E-01, 7.9759044867E-01],
	[2.6830000000E+04, 4.9694359621E+00, 3.1589245163E+00, 3.6268474211E-01, 3.0534266883E-01, 7.9763281447E-01],
	[2.6835000000E+04, 4.9709073246E+00, 3.1588788090E+00, 3.6289059012E-01, 3.0549368960E-01, 7.9767516016E-01],
	[2.6840000000E+04, 4.9723788484E+00, 3.1588331109E+00, 3.6309651652E-01, 3.0564474710E-01, 7.9771748574E-01],
	[2.6845000000E+04, 4.9738505336E+00, 3.1587874220E+00, 3.6330252131E-01, 3.0579584132E-01, 7.9775979123E-01],
	[2.6850000000E+04, 4.9753223802E+00, 3.1587417422E+00, 3.6350860451E-01, 3.0594697224E-01, 7.9780207664E-01],
	[2.6855000000E+04, 4.9767943881E+00, 3.1586960716E+00, 3.6371476614E-01, 3.0609813987E-01, 7.9784434197E-01],
	[2.6860000000E+04, 4.9782665574E+00, 3.1586504102E+00, 3.6392100620E-01, 3.0624934420E-01, 7.9788658723E-01],
	[2.6865000000E+04, 4.9797388881E+00, 3.1586047579E+00, 3.6412732473E-01, 3.0640058522E-01, 7.9792881244E-01],
	[2.6870000000E+04, 4.9812113800E+00, 3.1585591148E+00, 3.6433372172E-01, 3.0655186291E-01, 7.9797101760E-01],
	[2.6875000000E+04, 4.9826840333E+00, 3.1585134809E+00, 3.6454019720E-01, 3.0670317729E-01, 7.9801320272E-01],
	[2.6880000000E+04, 4.9841568479E+00, 3.1584678560E+00, 3.6474675118E-01, 3.0685452833E-01, 7.9805536781E-01],
	[2.6885000000E+04, 4.9856298237E+00, 3.1584222404E+00, 3.6495338368E-01, 3.0700591603E-01, 7.9809751288E-01],
	[2.6890000000E+04, 4.9871029609E+00, 3.1583766339E+00, 3.6516009471E-01, 3.0715734038E-01, 7.9813963793E-01],
	[2.6895000000E+04, 4.9885762593E+00, 3.1583310365E+00, 3.6536688429E-01, 3.0730880138E-01, 7.9818174298E-01],
	[2.6900000000E+04, 4.9900497189E+00, 3.1582854482E+00, 3.6557375242E-01, 3.0746029901E-01, 7.9822382804E-01],
	[2.6905000000E+04, 4.9915233398E+00, 3.1582398691E+00, 3.6578069914E-01, 3.0761183328E-01, 7.9826589312E-01],
	[2.6910000000E+04, 4.9929971219E+00, 3.1581942991E+00, 3.6598772445E-01, 3.0776340417E-01, 7.9830793822E-01],
	[2.6915000000E+04, 4.9944710652E+00, 3.1581487382E+00, 3.6619482837E-01, 3.0791501167E-01, 7.9834996336E-01],
	[2.6920000000E+04, 4.9959451698E+00, 3.1581031865E+00, 3.6640201091E-01, 3.0806665578E-01, 7.9839196854E-01],
	[2.6925000000E+04, 4.9974194355E+00, 3.1580576438E+00, 3.6660927209E-01, 3.0821833649E-01, 7.9843395377E-01],
	[2.6930000000E+04, 4.9988938624E+00, 3.1580121103E+00, 3.6681661192E-01, 3.0837005380E-01, 7.9847591906E-01],
	[2.6935000000E+04, 5.0003684504E+00, 3.1579665859E+00, 3.6702403042E-01, 3.0852180769E-01, 7.9851786443E-01],
	[2.6940000000E+04, 5.0018431996E+00, 3.1579210706E+00, 3.6723152761E-01, 3.0867359816E-01, 7.9855978987E-01],
	[2.6945000000E+04, 5.0033181100E+00, 3.1578755644E+00, 3.6743910349E-01, 3.0882542520E-01, 7.9860169541E-01],
	[2.6950000000E+04, 5.0047931814E+00, 3.1578300673E+00, 3.6764675809E-01, 3.0897728881E-01, 7.9864358104E-01],
	[2.6955000000E+04, 5.0062684140E+00, 3.1577845793E+00, 3.6785449142E-01, 3.0912918897E-01, 7.9868544678E-01],
	[2.6960000000E+04, 5.0077438077E+00, 3.1577391004E+00, 3.6806230349E-01, 3.0928112568E-01, 7.9872729264E-01],
	[2.6965000000E+04, 5.0092193625E+00, 3.1576936305E+00, 3.6827019432E-01, 3.0943309893E-01, 7.9876911863E-01],
	[2.6970000000E+04, 5.0106950784E+00, 3.1576481698E+00, 3.6847816393E-01, 3.0958510871E-01, 7.9881092476E-01],
	[2.6975000000E+04, 5.0121709553E+00, 3.1576027181E+00, 3.6868621233E-01, 3.0973715502E-01, 7.9885271102E-01],
	[2.6980000000E+04, 5.0136469933E+00, 3.1575572755E+00, 3.6889433953E-01, 3.0988923785E-01, 7.9889447745E-01],
	[2.6985000000E+04, 5.0151231923E+00, 3.1575118420E+00, 3.6910254555E-01, 3.1004135719E-01, 7.9893622403E-01],
	[2.6990000000E+04, 5.0165995523E+00, 3.1574664176E+00, 3.6931083041E-01, 3.1019351303E-01, 7.9897795079E-01],
	[2.6995000000E+04, 5.0180760734E+00, 3.1574210022E+00, 3.6951919412E-01, 3.1034570537E-01, 7.9901965773E-01],
	[2.7000000000E+04, 5.0195527554E+00, 3.1573755959E+00, 3.6972763670E-01, 3.1049793420E-01, 7.9906134487E-01],
	[2.7005000000E+04, 5.0210295985E+00, 3.1573301987E+00, 3.6993615816E-01, 3.1065019950E-01, 7.9910301220E-01],
	[2.7010000000E+04, 5.0225066025E+00, 3.1572848105E+00, 3.7014475851E-01, 3.1080250129E-01, 7.9914465974E-01],
	[2.7015000000E+04, 5.0239837676E+00, 3.1572394313E+00, 3.7035343778E-01, 3.1095483954E-01, 7.9918628751E-01],
	[2.7020000000E+04, 5.0254610935E+00, 3.1571940612E+00, 3.7056219598E-01, 3.1110721424E-01, 7.9922789550E-01],
	[2.7025000000E+04, 5.0269385804E+00, 3.1571487002E+00, 3.7077103311E-01, 3.1125962540E-01, 7.9926948373E-01],
	[2.7030000000E+04, 5.0284162283E+00, 3.1571033482E+00, 3.7097994921E-01, 3.1141207300E-01, 7.9931105220E-01],
	[2.7035000000E+04, 5.0298940370E+00, 3.1570580053E+00, 3.7118894427E-01, 3.1156455704E-01, 7.9935260093E-01],
	[2.7040000000E+04, 5.0313720067E+00, 3.1570126713E+00, 3.7139801833E-01, 3.1171707751E-01, 7.9939412993E-01],
	[2.7045000000E+04, 5.0328501372E+00, 3.1569673465E+00, 3.7160717139E-01, 3.1186963439E-01, 7.9943563920E-01],
	[2.7050000000E+04, 5.0343284287E+00, 3.1569220306E+00, 3.7181640346E-01, 3.1202222769E-01, 7.9947712876E-01],
	[2.7055000000E+04, 5.0358068810E+00, 3.1568767238E+00, 3.7202571457E-01, 3.1217485740E-01, 7.9951859861E-01],
	[2.7060000000E+04, 5.0372854941E+00, 3.1568314260E+00, 3.7223510473E-01, 3.1232752350E-01, 7.9956004876E-01],
	[2.7065000000E+04, 5.0387642681E+00, 3.1567861372E+00, 3.7244457395E-01, 3.1248022600E-01, 7.9960147922E-01],
	[2.7070000000E+04, 5.0402432030E+00, 3.1567408574E+00, 3.7265412225E-01, 3.1263296487E-01, 7.9964289000E-01],
	[2.7075000000E+04, 5.0417222986E+00, 3.1566955866E+00, 3.7286374965E-01, 3.1278574013E-01, 7.9968428111E-01],
	[2.7080000000E+04, 5.0432015551E+00, 3.1566503249E+00, 3.7307345615E-01, 3.1293855175E-01, 7.9972565257E-01],
	[2.7085000000E+04, 5.0446809724E+00, 3.1566050721E+00, 3.7328324178E-01, 3.1309139973E-01, 7.9976700437E-01],
	[2.7090000000E+04, 5.0461605504E+00, 3.1565598284E+00, 3.7349310655E-01, 3.1324428406E-01, 7.9980833652E-01],
	[2.7095000000E+04, 5.0476402892E+00, 3.1565145936E+00, 3.7370305048E-01, 3.1339720474E-01, 7.9984964905E-01],
	[2.7100000000E+04, 5.0491201888E+00, 3.1564693679E+00, 3.7391307357E-01, 3.1355016175E-01, 7.9989094195E-01],
	[2.7105000000E+04, 5.0506002491E+00, 3.1564241511E+00, 3.7412317585E-01, 3.1370315510E-01, 7.9993221523E-01],
	[2.7110000000E+04, 5.0520804702E+00, 3.1563789433E+00, 3.7433335734E-01, 3.1385618477E-01, 7.9997346891E-01],
	[2.7115000000E+04, 5.0535608520E+00, 3.1563337445E+00, 3.7454361803E-01, 3.1400925075E-01, 8.0001470300E-01],
	[2.7120000000E+04, 5.0550413945E+00, 3.1562885547E+00, 3.7475395796E-01, 3.1416235304E-01, 8.0005591749E-01],
	[2.7125000000E+04, 5.0565220977E+00, 3.1562433739E+00, 3.7496437714E-01, 3.1431549163E-01, 8.0009711241E-01],
	[2.7130000000E+04, 5.0580029616E+00, 3.1561982020E+00, 3.7517487557E-01, 3.1446866650E-01, 8.0013828776E-01],
	[2.7135000000E+04, 5.0594839861E+00, 3.1561530391E+00, 3.7538545329E-01, 3.1462187767E-01, 8.0017944355E-01],
	[2.7140000000E+04, 5.0609651713E+00, 3.1561078852E+00, 3.7559611029E-01, 3.1477512511E-01, 8.0022057979E-01],
	[2.7145000000E+04, 5.0624465172E+00, 3.1560627403E+00, 3.7580684660E-01, 3.1492840881E-01, 8.0026169649E-01],
	[2.7150000000E+04, 5.0639280237E+00, 3.1560176043E+00, 3.7601766224E-01, 3.1508172878E-01, 8.0030279366E-01],
	[2.7155000000E+04, 5.0654096908E+00, 3.1559724772E+00, 3.7622855721E-01, 3.1523508501E-01, 8.0034387130E-01],
	[2.7160000000E+04, 5.0668915186E+00, 3.1559273591E+00, 3.7643953153E-01, 3.1538847747E-01, 8.0038492831E-01],
	[2.7165000000E+04, 5.0683735069E+00, 3.1558822500E+00, 3.7665058523E-01, 3.1554190618E-01, 8.0042596357E-01],
	[2.7170000000E+04, 5.0698556559E+00, 3.1558371498E+00, 3.7686171830E-01, 3.1569537111E-01, 8.0046697738E-01],
	[2.7175000000E+04, 5.0713380479E+00, 3.1557921088E+00, 3.7707293078E-01, 3.1584887309E-01, 8.0050797004E-01],
	[2.7180000000E+04, 5.0728243323E+00, 3.1557493485E+00, 3.7728422266E-01, 3.1600244855E-01, 8.0054894185E-01],
	[2.7185000000E+04, 5.0743107788E+00, 3.1557065966E+00, 3.7749559398E-01, 3.1615606027E-01, 8.0058989311E-01],
	[2.7190000000E+04, 5.0757973873E+00, 3.1556638532E+00, 3.7770704474E-01, 3.1630970825E-01, 8.0063082411E-01],
	[2.7195000000E+04, 5.0772841580E+00, 3.1556211183E+00, 3.7791857496E-01, 3.1646339249E-01, 8.0067173516E-01],
	[2.7200000000E+04, 5.0787710906E+00, 3.1555783917E+00, 3.7813018466E-01, 3.1661711296E-01, 8.0071262655E-01],
	[2.7205000000E+04, 5.0802581853E+00, 3.1555356736E+00, 3.7834187384E-01, 3.1677086967E-01, 8.0075349857E-01],
	[2.7210000000E+04, 5.0817454421E+00, 3.1554929639E+00, 3.7855364253E-01, 3.1692466261E-01, 8.0079435153E-01],
	[2.7215000000E+04, 5.0832328608E+00, 3.1554502627E+00, 3.7876549074E-01, 3.1707849177E-01, 8.0083518572E-01],
	[2.7220000000E+04, 5.0847204415E+00, 3.1554075698E+00, 3.7897741848E-01, 3.1723235714E-01, 8.0087600142E-01],
	[2.7225000000E+04, 5.0862081842E+00, 3.1553648854E+00, 3.7918942578E-01, 3.1738625871E-01, 8.0091679894E-01],
	[2.7230000000E+04, 5.0876960889E+00, 3.1553222094E+00, 3.7940151264E-01, 3.1754019648E-01, 8.0095757856E-01],
	[2.7235000000E+04, 5.0891841556E+00, 3.1552795418E+00, 3.7961367908E-01, 3.1769417044E-01, 8.0099834058E-01],
	[2.7240000000E+04, 5.0906723842E+00, 3.1552368827E+00, 3.7982592511E-01, 3.1784818058E-01, 8.0103908529E-01],
	[2.7245000000E+04, 5.0921607748E+00, 3.1551942319E+00, 3.8003825076E-01, 3.1800222690E-01, 8.0107981297E-01],
	[2.7250000000E+04, 5.0936493272E+00, 3.1551515895E+00, 3.8025065604E-01, 3.1815630938E-01, 8.0112052392E-01],
	[2.7255000000E+04, 5.0951380416E+00, 3.1551089556E+00, 3.8046314095E-01, 3.1831042802E-01, 8.0116121842E-01],
	[2.7260000000E+04, 5.0966269179E+00, 3.1550663300E+00, 3.8067570553E-01, 3.1846458281E-01, 8.0120189677E-01],
	[2.7265000000E+04, 5.0981159561E+00, 3.1550237128E+00, 3.8088834977E-01, 3.1861877374E-01, 8.0124255924E-01],
	[2.7270000000E+04, 5.0996051561E+00, 3.1549811040E+00, 3.8110107370E-01, 3.1877300081E-01, 8.0128320613E-01],
	[2.7275000000E+04, 5.1010945180E+00, 3.1549385036E+00, 3.8131387734E-01, 3.1892726400E-01, 8.0132383772E-01],
	[2.7280000000E+04, 5.1025840418E+00, 3.1548959116E+00, 3.8152676069E-01, 3.1908156331E-01, 8.0136445429E-01],
	[2.7285000000E+04, 5.1040737274E+00, 3.1548533280E+00, 3.8173972378E-01, 3.1923589874E-01, 8.0140505614E-01],
	[2.7290000000E+04, 5.1055635749E+00, 3.1548107527E+00, 3.8195276661E-01, 3.1939027026E-01, 8.0144564355E-01],
	[2.7295000000E+04, 5.1070535841E+00, 3.1547681858E+00, 3.8216588921E-01, 3.1954467789E-01, 8.0148621679E-01],
	[2.7300000000E+04, 5.1085437552E+00, 3.1547256273E+00, 3.8237909158E-01, 3.1969912160E-01, 8.0152677621E-01],
	[2.7305000000E+04, 5.1100340881E+00, 3.1546830772E+00, 3.8259237375E-01, 3.1985360139E-01, 8.0156732524E-01],
	[2.7310000000E+04, 5.1115245827E+00, 3.1546405354E+00, 3.8280573573E-01, 3.2000811726E-01, 8.0160786576E-01],
	[2.7315000000E+04, 5.1130152391E+00, 3.1545980020E+00, 3.8301917753E-01, 3.2016266918E-01, 8.0164839779E-01],
	[2.7320000000E+04, 5.1145060573E+00, 3.1545554769E+00, 3.8323269917E-01, 3.2031725717E-01, 8.0168892132E-01],
	[2.7325000000E+04, 5.1159970372E+00, 3.1545129602E+00, 3.8344630067E-01, 3.2047188121E-01, 8.0172943637E-01],
	[2.7330000000E+04, 5.1174881788E+00, 3.1544704519E+00, 3.8365998203E-01, 3.2062654128E-01, 8.0176994292E-01],
	[2.7335000000E+04, 5.1189794822E+00, 3.1544279519E+00, 3.8387374329E-01, 3.2078123739E-01, 8.0181044099E-01],
	[2.7340000000E+04, 5.1204709472E+00, 3.1543854602E+00, 3.8408758444E-01, 3.2093596953E-01, 8.0185093057E-01],
	[2.7345000000E+04, 5.1219625740E+00, 3.1543429769E+00, 3.8430150550E-01, 3.2109073768E-01, 8.0189141166E-01],
	[2.7350000000E+04, 5.1234543624E+00, 3.1543005019E+00, 3.8451550650E-01, 3.2124554184E-01, 8.0193188428E-01],
	[2.7355000000E+04, 5.1249463126E+00, 3.1542580353E+00, 3.8472958744E-01, 3.2140038201E-01, 8.0197234841E-01],
	[2.7360000000E+04, 5.1264384243E+00, 3.1542155769E+00, 3.8494374835E-01, 3.2155525817E-01, 8.0201280406E-01],
	[2.7365000000E+04, 5.1279306978E+00, 3.1541731270E+00, 3.8515798923E-01, 3.2171017031E-01, 8.0205325124E-01],
	[2.7370000000E+04, 5.1294231328E+00, 3.1541306853E+00, 3.8537231010E-01, 3.2186511844E-01, 8.0209368994E-01],
	[2.7375000000E+04, 5.1309157295E+00, 3.1540882520E+00, 3.8558671098E-01, 3.2202010253E-01, 8.0213412017E-01],
	[2.7380000000E+04, 5.1324084878E+00, 3.1540458270E+00, 3.8580119188E-01, 3.2217512259E-01, 8.0217454193E-01],
	[2.7385000000E+04, 5.1339014077E+00, 3.1540034103E+00, 3.8601575281E-01, 3.2233017860E-01, 8.0221495522E-01],
	[2.7390000000E+04, 5.1353944892E+00, 3.1539610019E+00, 3.8623040123E-01, 3.2248527574E-01, 8.0225536004E-01],
	[2.7395000000E+04, 5.1368877323E+00, 3.1539186018E+00, 3.8644513182E-01, 3.2264041027E-01, 8.0229575640E-01],
	[2.7400000000E+04, 5.1383811369E+00, 3.1538762101E+00, 3.8665994249E-01, 3.2279558075E-01, 8.0233614429E-01],
	[2.7405000000E+04, 5.1398747031E+00, 3.1538338266E+00, 3.8687483328E-01, 3.2295078715E-01, 8.0237652372E-01],
	[2.7410000000E+04, 5.1413684308E+00, 3.1537914515E+00, 3.8708980419E-01, 3.2310602947E-01, 8.0241689469E-01],
	[2.7415000000E+04, 5.1428623201E+00, 3.1537490846E+00, 3.8730485523E-01, 3.2326130771E-01, 8.0245725721E-01],
	[2.7420000000E+04, 5.1443563708E+00, 3.1537067261E+00, 3.8751998643E-01, 3.2341662184E-01, 8.0249761127E-01],
	[2.7425000000E+04, 5.1458505831E+00, 3.1536643758E+00, 3.8773519779E-01, 3.2357197187E-01, 8.0253795687E-01],
	[2.7430000000E+04, 5.1473449569E+00, 3.1536220338E+00, 3.8795048934E-01, 3.2372735779E-01, 8.0257829402E-01],
	[2.7435000000E+04, 5.1488394921E+00, 3.1535797001E+00, 3.8816586108E-01, 3.2388277959E-01, 8.0261862272E-01],
	[2.7440000000E+04, 5.1503341888E+00, 3.1535373747E+00, 3.8838131304E-01, 3.2403823726E-01, 8.0265894297E-01],
	[2.7445000000E+04, 5.1518290470E+00, 3.1534950576E+00, 3.8859684522E-01, 3.2419373080E-01, 8.0269925478E-01],
	[2.7450000000E+04, 5.1533240666E+00, 3.1534527488E+00, 3.8881245765E-01, 3.2434926019E-01, 8.0273955813E-01],
	[2.7455000000E+04, 5.1548192476E+00, 3.1534104482E+00, 3.8902815034E-01, 3.2450482543E-01, 8.0277985302E-01],
	[2.7460000000E+04, 5.1563145901E+00, 3.1533681559E+00, 3.8924392330E-01, 3.2466042650E-01, 8.0282013947E-01],
	[2.7465000000E+04, 5.1578100940E+00, 3.1533258718E+00, 3.8945977655E-01, 3.2481606341E-01, 8.0286041747E-01],
	[2.7470000000E+04, 5.1593057592E+00, 3.1532835960E+00, 3.8967571011E-01, 3.2497173615E-01, 8.0290068702E-01],
	[2.7475000000E+04, 5.1608015859E+00, 3.1532413285E+00, 3.8989172398E-01, 3.2512744470E-01, 8.0294094812E-01],
	[2.7480000000E+04, 5.1622975739E+00, 3.1531990693E+00, 3.9010781819E-01, 3.2528318905E-01, 8.0298120078E-01],
	[2.7485000000E+04, 5.1637937233E+00, 3.1531568183E+00, 3.9032399275E-01, 3.2543896921E-01, 8.0302144500E-01],
	[2.7490000000E+04, 5.1652900340E+00, 3.1531145755E+00, 3.9054024768E-01, 3.2559478516E-01, 8.0306168078E-01],
	[2.7495000000E+04, 5.1667865061E+00, 3.1530723410E+00, 3.9075658298E-01, 3.2575063689E-01, 8.0310190812E-01],
	[2.7500000000E+04, 5.1682831395E+00, 3.1530301147E+00, 3.9097299868E-01, 3.2590652440E-01, 8.0314212702E-01],
	[2.7505000000E+04, 5.1697799342E+00, 3.1529878967E+00, 3.9118949479E-01, 3.2606244768E-01, 8.0318233749E-01],
	[2.7510000000E+04, 5.1712768902E+00, 3.1529456869E+00, 3.9140607133E-01, 3.2621840671E-01, 8.0322253953E-01],
	[2.7515000000E+04, 5.1727740075E+00, 3.1529034854E+00, 3.9162272831E-01, 3.2637440150E-01, 8.0326273315E-01],
	[2.7520000000E+04, 5.1742712861E+00, 3.1528612921E+00, 3.9183946575E-01, 3.2653043203E-01, 8.0330291833E-01],
	[2.7525000000E+04, 5.1757687259E+00, 3.1528191070E+00, 3.9205628365E-01, 3.2668649830E-01, 8.0334309509E-01],
	[2.7530000000E+04, 5.1772663270E+00, 3.1527769302E+00, 3.9227318205E-01, 3.2684260030E-01, 8.0338326342E-01],
	[2.7535000000E+04, 5.1787640893E+00, 3.1527347615E+00, 3.9249016094E-01, 3.2699873801E-01, 8.0342342333E-01],
	[2.7540000000E+04, 5.1802620129E+00, 3.1526926011E+00, 3.9270722036E-01, 3.2715491144E-01, 8.0346357483E-01],
	[2.7545000000E+04, 5.1817600977E+00, 3.1526504489E+00, 3.9292436030E-01, 3.2731112057E-01, 8.0350371790E-01],
	[2.7550000000E+04, 5.1832583437E+00, 3.1526083050E+00, 3.9314158080E-01, 3.2746736539E-01, 8.0354385256E-01],
	[2.7555000000E+04, 5.1847567508E+00, 3.1525661692E+00, 3.9335888186E-01, 3.2762364591E-01, 8.0358397881E-01],
	[2.7560000000E+04, 5.1862553192E+00, 3.1525240416E+00, 3.9357626349E-01, 3.2777996210E-01, 8.0362409664E-01],
	[2.7565000000E+04, 5.1877540487E+00, 3.1524819223E+00, 3.9379372572E-01, 3.2793631396E-01, 8.0366420606E-01],
	[2.7570000000E+04, 5.1892529394E+00, 3.1524398111E+00, 3.9401126856E-01, 3.2809270149E-01, 8.0370430708E-01],
	[2.7575000000E+04, 5.1907519912E+00, 3.1523977082E+00, 3.9422889202E-01, 3.2824912467E-01, 8.0374439969E-01],
	[2.7580000000E+04, 5.1922512042E+00, 3.1523556134E+00, 3.9444659612E-01, 3.2840558350E-01, 8.0378448390E-01],
	[2.7585000000E+04, 5.1937505783E+00, 3.1523135268E+00, 3.9466438087E-01, 3.2856207796E-01, 8.0382455970E-01],
	[2.7590000000E+04, 5.1952501135E+00, 3.1522714485E+00, 3.9488224630E-01, 3.2871860806E-01, 8.0386462710E-01],
	[2.7595000000E+04, 5.1967498098E+00, 3.1522293783E+00, 3.9510019241E-01, 3.2887517378E-01, 8.0390468611E-01],
	[2.7600000000E+04, 5.1982496671E+00, 3.1521873163E+00, 3.9531821922E-01, 3.2903177512E-01, 8.0394473672E-01],
	[2.7605000000E+04, 5.1997496856E+00, 3.1521452625E+00, 3.9553632674E-01, 3.2918841206E-01, 8.0398477894E-01],
	[2.7610000000E+04, 5.2012498651E+00, 3.1521032168E+00, 3.9575451500E-01, 3.2934508460E-01, 8.0402481276E-01],
	[2.7615000000E+04, 5.2027519198E+00, 3.1520623777E+00, 3.9597278400E-01, 3.2950181270E-01, 8.0406483819E-01],
	[2.7620000000E+04, 5.2042556820E+00, 3.1520226268E+00, 3.9619113376E-01, 3.2965859443E-01, 8.0410485524E-01],
	[2.7625000000E+04, 5.2057596066E+00, 3.1519828836E+00, 3.9640956429E-01, 3.2981541179E-01, 8.0414486390E-01],
	[2.7630000000E+04, 5.2072636934E+00, 3.1519431481E+00, 3.9662807562E-01, 3.2997226478E-01, 8.0418486418E-01],
	[2.7635000000E+04, 5.2087679425E+00, 3.1519034203E+00, 3.9684666776E-01, 3.3012915338E-01, 8.0422485607E-01],
	[2.7640000000E+04, 5.2102723539E+00, 3.1518637002E+00, 3.9706534071E-01, 3.3028607759E-01, 8.0426483958E-01],
	[2.7645000000E+04, 5.2117769276E+00, 3.1518239878E+00, 3.9728409451E-01, 3.3044303740E-01, 8.0430481472E-01],
	[2.7650000000E+04, 5.2132816636E+00, 3.1517842830E+00, 3.9750292915E-01, 3.3060003281E-01, 8.0434478148E-01],
	[2.7655000000E+04, 5.2147865618E+00, 3.1517445860E+00, 3.9772184467E-01, 3.3075706379E-01, 8.0438473986E-01],
	[2.7660000000E+04, 5.2162916222E+00, 3.1517048966E+00, 3.9794084106E-01, 3.3091413036E-01, 8.0442468987E-01],
	[2.7665000000E+04, 5.2177968448E+00, 3.1516652148E+00, 3.9815991835E-01, 3.3107123249E-01, 8.0446463151E-01],
	[2.7670000000E+04, 5.2193022297E+00, 3.1516255408E+00, 3.9837907656E-01, 3.3122837017E-01, 8.0450456479E-01],
	[2.7675000000E+04, 5.2208077767E+00, 3.1515858744E+00, 3.9859831570E-01, 3.3138554341E-01, 8.0454448969E-01],
	[2.7680000000E+04, 5.2223134860E+00, 3.1515462157E+00, 3.9881763577E-01, 3.3154275220E-01, 8.0458440623E-01],
	[2.7685000000E+04, 5.2238193574E+00, 3.1515065646E+00, 3.9903703681E-01, 3.3169999651E-01, 8.0462431441E-01],
	[2.7690000000E+04, 5.2253253910E+00, 3.1514669212E+00, 3.9925651882E-01, 3.3185727636E-01, 8.0466421423E-01],
	[2.7695000000E+04, 5.2268315868E+00, 3.1514272855E+00, 3.9947608182E-01, 3.3201459172E-01, 8.0470410569E-01],
	[2.7700000000E+04, 5.2283379446E+00, 3.1513876574E+00, 3.9969572582E-01, 3.3217194259E-01, 8.0474398880E-01],
	[2.7705000000E+04, 5.2298444646E+00, 3.1513480370E+00, 3.9991545085E-01, 3.3232932896E-01, 8.0478386355E-01],
	[2.7710000000E+04, 5.2313511468E+00, 3.1513084242E+00, 4.0013525690E-01, 3.3248675083E-01, 8.0482372994E-01],
	[2.7715000000E+04, 5.2328579910E+00, 3.1512688191E+00, 4.0035514401E-01, 3.3264420818E-01, 8.0486358799E-01],
	[2.7720000000E+04, 5.2343649973E+00, 3.1512292216E+00, 4.0057511219E-01, 3.3280170101E-01, 8.0490343769E-01],
	[2.7725000000E+04, 5.2358721658E+00, 3.1511896317E+00, 4.0079516144E-01, 3.3295922931E-01, 8.0494327904E-01],
	[2.7730000000E+04, 5.2373794962E+00, 3.1511500495E+00, 4.0101529179E-01, 3.3311679307E-01, 8.0498311204E-01],
	[2.7735000000E+04, 5.2388869888E+00, 3.1511104749E+00, 4.0123550325E-01, 3.3327439228E-01, 8.0502293670E-01],
	[2.7740000000E+04, 5.2403946434E+00, 3.1510709079E+00, 4.0145579583E-01, 3.3343202694E-01, 8.0506275302E-01],
	[2.7745000000E+04, 5.2419024600E+00, 3.1510313486E+00, 4.0167616956E-01, 3.3358969703E-01, 8.0510256101E-01],
	[2.7750000000E+04, 5.2434104386E+00, 3.1509917969E+00, 4.0189662445E-01, 3.3374740255E-01, 8.0514236065E-01],
	[2.7755000000E+04, 5.2449185793E+00, 3.1509522528E+00, 4.0211716050E-01, 3.3390514349E-01, 8.0518215196E-01],
	[2.7760000000E+04, 5.2464268819E+00, 3.1509127163E+00, 4.0233777774E-01, 3.3406291984E-01, 8.0522193494E-01],
	[2.7765000000E+04, 5.2479353466E+00, 3.1508731875E+00, 4.0255847619E-01, 3.3422073160E-01, 8.0526170959E-01],
	[2.7770000000E+04, 5.2494439732E+00, 3.1508336662E+00, 4.0277925585E-01, 3.3437857875E-01, 8.0530147590E-01],
	[2.7775000000E+04, 5.2509527618E+00, 3.1507941526E+00, 4.0300011674E-01, 3.3453646128E-01, 8.0534123389E-01],
	[2.7780000000E+04, 5.2524617123E+00, 3.1507546466E+00, 4.0322105889E-01, 3.3469437920E-01, 8.0538098356E-01],
	[2.7785000000E+04, 5.2539708248E+00, 3.1507151482E+00, 4.0344208229E-01, 3.3485233248E-01, 8.0542072490E-01],
	[2.7790000000E+04, 5.2554800992E+00, 3.1506756574E+00, 4.0366318698E-01, 3.3501032113E-01, 8.0546045792E-01],
	[2.7795000000E+04, 5.2569895355E+00, 3.1506361742E+00, 4.0388437295E-01, 3.3516834513E-01, 8.0550018262E-01],
	[2.7800000000E+04, 5.2584991338E+00, 3.1505966986E+00, 4.0410564024E-01, 3.3532640447E-01, 8.0553989900E-01],
	[2.7805000000E+04, 5.2600088939E+00, 3.1505572305E+00, 4.0432698885E-01, 3.3548449916E-01, 8.0557960707E-01],
	[2.7810000000E+04, 5.2615188159E+00, 3.1505177701E+00, 4.0454841880E-01, 3.3564262917E-01, 8.0561930682E-01],
	[2.7815000000E+04, 5.2630288998E+00, 3.1504783173E+00, 4.0476993010E-01, 3.3580079450E-01, 8.0565899827E-01],
	[2.7820000000E+04, 5.2645391455E+00, 3.1504388720E+00, 4.0499152277E-01, 3.3595899514E-01, 8.0569868140E-01],
	[2.7825000000E+04, 5.2660495531E+00, 3.1503994343E+00, 4.0521319683E-01, 3.3611723109E-01, 8.0573835622E-01],
	[2.7830000000E+04, 5.2675601225E+00, 3.1503600042E+00, 4.0543495229E-01, 3.3627550233E-01, 8.0577802274E-01],
	[2.7835000000E+04, 5.2690708537E+00, 3.1503205817E+00, 4.0565678916E-01, 3.3643380886E-01, 8.0581768096E-01],
	[2.7840000000E+04, 5.2705817468E+00, 3.1502811668E+00, 4.0587870747E-01, 3.3659215067E-01, 8.0585733087E-01],
	[2.7845000000E+04, 5.2720928016E+00, 3.1502417594E+00, 4.0610070721E-01, 3.3675052775E-01, 8.0589697249E-01],
	[2.7850000000E+04, 5.2736040183E+00, 3.1502023596E+00, 4.0632278842E-01, 3.3690894009E-01, 8.0593660581E-01],
	[2.7855000000E+04, 5.2751153967E+00, 3.1501629674E+00, 4.0654495111E-01, 3.3706738768E-01, 8.0597623083E-01],
	[2.7860000000E+04, 5.2766269368E+00, 3.1501235827E+00, 4.0676719529E-01, 3.3722587052E-01, 8.0601584755E-01],
	[2.7865000000E+04, 5.2781386388E+00, 3.1500842056E+00, 4.0698952097E-01, 3.3738438860E-01, 8.0605545599E-01],
	[2.7870000000E+04, 5.2796505024E+00, 3.1500448360E+00, 4.0721192818E-01, 3.3754294191E-01, 8.0609505613E-01],
	[2.7875000000E+04, 5.2811625278E+00, 3.1500054740E+00, 4.0743441692E-01, 3.3770153043E-01, 8.0613464799E-01],
	[2.7880000000E+04, 5.2826747149E+00, 3.1499661196E+00, 4.0765698721E-01, 3.3786015417E-01, 8.0617423156E-01],
	[2.7885000000E+04, 5.2841870638E+00, 3.1499267727E+00, 4.0787963908E-01, 3.3801881311E-01, 8.0621380685E-01],
	[2.7890000000E+04, 5.2856995743E+00, 3.1498874333E+00, 4.0810237252E-01, 3.3817750725E-01, 8.0625337385E-01],
	[2.7895000000E+04, 5.2872122465E+00, 3.1498481015E+00, 4.0832518757E-01, 3.3833623657E-01, 8.0629293257E-01],
	[2.7900000000E+04, 5.2887250804E+00, 3.1498087772E+00, 4.0854808422E-01, 3.3849500107E-01, 8.0633248302E-01],
	[2.7905000000E+04, 5.2902380759E+00, 3.1497694605E+00, 4.0877106251E-01, 3.3865380074E-01, 8.0637202519E-01],
	[2.7910000000E+04, 5.2917512331E+00, 3.1497301513E+00, 4.0899412243E-01, 3.3881263558E-01, 8.0641155908E-01],
	[2.7915000000E+04, 5.2932645519E+00, 3.1496908496E+00, 4.0921726402E-01, 3.3897150556E-01, 8.0645108470E-01],
	[2.7920000000E+04, 5.2947780323E+00, 3.1496515555E+00, 4.0944048728E-01, 3.3913041069E-01, 8.0649060206E-01],
	[2.7925000000E+04, 5.2962916743E+00, 3.1496122689E+00, 4.0966379223E-01, 3.3928935096E-01, 8.0653011114E-01],
	[2.7930000000E+04, 5.2978054780E+00, 3.1495729898E+00, 4.0988717889E-01, 3.3944832635E-01, 8.0656961196E-01],
	[2.7935000000E+04, 5.2993194432E+00, 3.1495337182E+00, 4.1011064726E-01, 3.3960733687E-01, 8.0660910451E-01],
	[2.7940000000E+04, 5.3008335700E+00, 3.1494944541E+00, 4.1033419737E-01, 3.3976638249E-01, 8.0664858880E-01],
	[2.7945000000E+04, 5.3023478584E+00, 3.1494551976E+00, 4.1055782923E-01, 3.3992546322E-01, 8.0668806482E-01],
	[2.7950000000E+04, 5.3038623084E+00, 3.1494159486E+00, 4.1078154285E-01, 3.4008457904E-01, 8.0672753259E-01],
	[2.7955000000E+04, 5.3053769198E+00, 3.1493767071E+00, 4.1100533826E-01, 3.4024372995E-01, 8.0676699211E-01],
	[2.7960000000E+04, 5.3068916928E+00, 3.1493374731E+00, 4.1122921546E-01, 3.4040291593E-01, 8.0680644336E-01],
	[2.7965000000E+04, 5.3084066274E+00, 3.1492982466E+00, 4.1145317447E-01, 3.4056213698E-01, 8.0684588637E-01],
	[2.7970000000E+04, 5.3099217234E+00, 3.1492590276E+00, 4.1167721531E-01, 3.4072139310E-01, 8.0688532112E-01],
	[2.7975000000E+04, 5.3114369809E+00, 3.1492198161E+00, 4.1190133799E-01, 3.4088068426E-01, 8.0692474762E-01],
	[2.7980000000E+04, 5.3129523999E+00, 3.1491806120E+00, 4.1212554252E-01, 3.4104001047E-01, 8.0696416588E-01],
	[2.7985000000E+04, 5.3144679804E+00, 3.1491414155E+00, 4.1234982893E-01, 3.4119937171E-01, 8.0700357589E-01],
	[2.7990000000E+04, 5.3159837224E+00, 3.1491022265E+00, 4.1257419723E-01, 3.4135876798E-01, 8.0704297766E-01],
	[2.7995000000E+04, 5.3174996258E+00, 3.1490630450E+00, 4.1279864742E-01, 3.4151819927E-01, 8.0708237119E-01],
	[2.8000000000E+04, 5.3190156906E+00, 3.1490238709E+00, 4.1302317954E-01, 3.4167766557E-01, 8.0712175647E-01],
	[2.8005000000E+04, 5.3205319168E+00, 3.1489847043E+00, 4.1324779359E-01, 3.4183716686E-01, 8.0716113352E-01],
	[2.8010000000E+04, 5.3220483045E+00, 3.1489455453E+00, 4.1347248958E-01, 3.4199670315E-01, 8.0720050234E-01],
	[2.8015000000E+04, 5.3235648536E+00, 3.1489063936E+00, 4.1369726754E-01, 3.4215627443E-01, 8.0723986292E-01],
	[2.8020000000E+04, 5.3250815640E+00, 3.1488672495E+00, 4.1392212748E-01, 3.4231588068E-01, 8.0727921527E-01],
	[2.8025000000E+04, 5.3265984359E+00, 3.1488281128E+00, 4.1414706941E-01, 3.4247552189E-01, 8.0731855939E-01],
	[2.8030000000E+04, 5.3281154691E+00, 3.1487889836E+00, 4.1437209335E-01, 3.4263519806E-01, 8.0735789528E-01],
	[2.8035000000E+04, 5.3296326637E+00, 3.1487498619E+00, 4.1459719932E-01, 3.4279490919E-01, 8.0739722295E-01],
	[2.8040000000E+04, 5.3311500196E+00, 3.1487107476E+00, 4.1482238732E-01, 3.4295465525E-01, 8.0743654239E-01],
	[2.8045000000E+04, 5.3326675368E+00, 3.1486716408E+00, 4.1504765738E-01, 3.4311443625E-01, 8.0747585361E-01],
	[2.8050000000E+04, 5.3341852154E+00, 3.1486325414E+00, 4.1527300951E-01, 3.4327425217E-01, 8.0751515661E-01],
	[2.8055000000E+04, 5.3357030552E+00, 3.1485934495E+00, 4.1549844372E-01, 3.4343410300E-01, 8.0755445139E-01],
	[2.8060000000E+04, 5.3372227313E+00, 3.1485557551E+00, 4.1572396003E-01, 3.4359401224E-01, 8.0759373796E-01],
	[2.8065000000E+04, 5.3387435892E+00, 3.1485189141E+00, 4.1594955846E-01, 3.4375397073E-01, 8.0763301631E-01],
	[2.8070000000E+04, 5.3402646094E+00, 3.1484820801E+00, 4.1617523902E-01, 3.4391396417E-01, 8.0767228645E-01],
	[2.8075000000E+04, 5.3417857920E+00, 3.1484452530E+00, 4.1640100173E-01, 3.4407399254E-01, 8.0771154838E-01],
	[2.8080000000E+04, 5.3433071369E+00, 3.1484084330E+00, 4.1662684660E-01, 3.4423405585E-01, 8.0775080210E-01],
	[2.8085000000E+04, 5.3448286440E+00, 3.1483716199E+00, 4.1685277364E-01, 3.4439415408E-01, 8.0779004761E-01],
	[2.8090000000E+04, 5.3463503135E+00, 3.1483348138E+00, 4.1707878287E-01, 3.4455428722E-01, 8.0782928492E-01],
	[2.8095000000E+04, 5.3478721452E+00, 3.1482980147E+00, 4.1730487432E-01, 3.4471445526E-01, 8.0786851403E-01],
	[2.8100000000E+04, 5.3493941392E+00, 3.1482612226E+00, 4.1753104798E-01, 3.4487465821E-01, 8.0790773493E-01],
	[2.8105000000E+04, 5.3509162954E+00, 3.1482244375E+00, 4.1775730388E-01, 3.4503489604E-01, 8.0794694764E-01],
	[2.8110000000E+04, 5.3524386138E+00, 3.1481876593E+00, 4.1798364203E-01, 3.4519516875E-01, 8.0798615215E-01],
	[2.8115000000E+04, 5.3539610945E+00, 3.1481508881E+00, 4.1821006246E-01, 3.4535547633E-01, 8.0802534847E-01],
	[2.8120000000E+04, 5.3554837374E+00, 3.1481141238E+00, 4.1843656516E-01, 3.4551581877E-01, 8.0806453659E-01],
	[2.8125000000E+04, 5.3570065425E+00, 3.1480773666E+00, 4.1866315016E-01, 3.4567619607E-01, 8.0810371652E-01],
	[2.8130000000E+04, 5.3585295098E+00, 3.1480406163E+00, 4.1888981748E-01, 3.4583660821E-01, 8.0814288827E-01],
	[2.8135000000E+04, 5.3600526393E+00, 3.1480038729E+00, 4.1911656712E-01, 3.4599705519E-01, 8.0818205182E-01],
	[2.8140000000E+04, 5.3615759309E+00, 3.1479671365E+00, 4.1934339911E-01, 3.4615753699E-01, 8.0822120719E-01],
	[2.8145000000E+04, 5.3630993847E+00, 3.1479304071E+00, 4.1957031346E-01, 3.4631805362E-01, 8.0826035438E-01],
	[2.8150000000E+04, 5.3646230006E+00, 3.1478936846E+00, 4.1979731018E-01, 3.4647860505E-01, 8.0829949338E-01],
	[2.8155000000E+04, 5.3661467787E+00, 3.1478569691E+00, 4.2002438930E-01, 3.4663919129E-01, 8.0833862421E-01],
	[2.8160000000E+04, 5.3676707188E+00, 3.1478202605E+00, 4.2025155081E-01, 3.4679981232E-01, 8.0837774686E-01],
	[2.8165000000E+04, 5.3691948211E+00, 3.1477835589E+00, 4.2047879475E-01, 3.4696046813E-01, 8.0841686133E-01],
	[2.8170000000E+04, 5.3707190855E+00, 3.1477468642E+00, 4.2070612112E-01, 3.4712115873E-01, 8.0845596763E-01],
	[2.8175000000E+04, 5.3722435120E+00, 3.1477101764E+00, 4.2093352994E-01, 3.4728188409E-01, 8.0849506576E-01],
	[2.8180000000E+04, 5.3737681005E+00, 3.1476734956E+00, 4.2116102123E-01, 3.4744264420E-01, 8.0853415572E-01],
	[2.8185000000E+04, 5.3752928511E+00, 3.1476368217E+00, 4.2138859500E-01, 3.4760343907E-01, 8.0857323751E-01],
	[2.8190000000E+04, 5.3768177638E+00, 3.1476001548E+00, 4.2161625127E-01, 3.4776426868E-01, 8.0861231114E-01],
	[2.8195000000E+04, 5.3783428385E+00, 3.1475634948E+00, 4.2184399004E-01, 3.4792513302E-01, 8.0865137660E-01],
	[2.8200000000E+04, 5.3798680752E+00, 3.1475268417E+00, 4.2207181135E-01, 3.4808603209E-01, 8.0869043390E-01],
	[2.8205000000E+04, 5.3813934740E+00, 3.1474901955E+00, 4.2229971519E-01, 3.4824696587E-01, 8.0872948303E-01],
	[2.8210000000E+04, 5.3829190347E+00, 3.1474535563E+00, 4.2252770159E-01, 3.4840793436E-01, 8.0876852401E-01],
	[2.8215000000E+04, 5.3844447575E+00, 3.1474169240E+00, 4.2275577057E-01, 3.4856893755E-01, 8.0880755684E-01],
	[2.8220000000E+04, 5.3859706422E+00, 3.1473802986E+00, 4.2298392213E-01, 3.4872997542E-01, 8.0884658151E-01],
	[2.8225000000E+04, 5.3874966889E+00, 3.1473436801E+00, 4.2321215629E-01, 3.4889104798E-01, 8.0888559803E-01],
	[2.8230000000E+04, 5.3890228975E+00, 3.1473070685E+00, 4.2344047308E-01, 3.4905215521E-01, 8.0892460639E-01],
	[2.8235000000E+04, 5.3905492682E+00, 3.1472704638E+00, 4.2366887249E-01, 3.4921329711E-01, 8.0896360661E-01],
	[2.8240000000E+04, 5.3920758007E+00, 3.1472338661E+00, 4.2389735456E-01, 3.4937447365E-01, 8.0900259868E-01],
	[2.8245000000E+04, 5.3936024952E+00, 3.1471972752E+00, 4.2412591929E-01, 3.4953568485E-01, 8.0904158261E-01],
	[2.8250000000E+04, 5.3951293515E+00, 3.1471606912E+00, 4.2435456669E-01, 3.4969693068E-01, 8.0908055839E-01],
	[2.8255000000E+04, 5.3966563698E+00, 3.1471241142E+00, 4.2458329679E-01, 3.4985821114E-01, 8.0911952604E-01],
	[2.8260000000E+04, 5.3981835500E+00, 3.1470875440E+00, 4.2481210960E-01, 3.5001952622E-01, 8.0915848554E-01],
	[2.8265000000E+04, 5.3997108920E+00, 3.1470509808E+00, 4.2504100514E-01, 3.5018087591E-01, 8.0919743691E-01],
	[2.8270000000E+04, 5.4012383959E+00, 3.1470144244E+00, 4.2526998342E-01, 3.5034226020E-01, 8.0923638014E-01],
	[2.8275000000E+04, 5.4027660617E+00, 3.1469778749E+00, 4.2549904445E-01, 3.5050367909E-01, 8.0927531524E-01],
	[2.8280000000E+04, 5.4042938893E+00, 3.1469413323E+00, 4.2572818825E-01, 3.5066513256E-01, 8.0931424221E-01],
	[2.8285000000E+04, 5.4058218788E+00, 3.1469047966E+00, 4.2595741483E-01, 3.5082662061E-01, 8.0935316104E-01],
	[2.8290000000E+04, 5.4073500300E+00, 3.1468682678E+00, 4.2618672422E-01, 3.5098814322E-01, 8.0939207175E-01],
	[2.8295000000E+04, 5.4088783431E+00, 3.1468317458E+00, 4.2641611642E-01, 3.5114970040E-01, 8.0943097434E-01],
	[2.8300000000E+04, 5.4104068180E+00, 3.1467952308E+00, 4.2664559145E-01, 3.5131129212E-01, 8.0946986880E-01],
	[2.8305000000E+04, 5.4119354547E+00, 3.1467587226E+00, 4.2687514933E-01, 3.5147291839E-01, 8.0950875514E-01],
	[2.8310000000E+04, 5.4134642531E+00, 3.1467222212E+00, 4.2710479008E-01, 3.5163457919E-01, 8.0954763336E-01],
	[2.8315000000E+04, 5.4149932133E+00, 3.1466857268E+00, 4.2733451370E-01, 3.5179627451E-01, 8.0958650346E-01],
	[2.8320000000E+04, 5.4165223353E+00, 3.1466492392E+00, 4.2756432021E-01, 3.5195800434E-01, 8.0962536545E-01],
	[2.8325000000E+04, 5.4180516190E+00, 3.1466127585E+00, 4.2779420962E-01, 3.5211976868E-01, 8.0966421932E-01],
	[2.8330000000E+04, 5.4195810644E+00, 3.1465762846E+00, 4.2802418197E-01, 3.5228156752E-01, 8.0970306508E-01],
	[2.8335000000E+04, 5.4211106715E+00, 3.1465398176E+00, 4.2825423724E-01, 3.5244340085E-01, 8.0974190273E-01],
	[2.8340000000E+04, 5.4226404404E+00, 3.1465033574E+00, 4.2848437548E-01, 3.5260526866E-01, 8.0978073228E-01],
	[2.8345000000E+04, 5.4241703709E+00, 3.1464669042E+00, 4.2871459668E-01, 3.5276717094E-01, 8.0981955371E-01],
	[2.8350000000E+04, 5.4257004632E+00, 3.1464304577E+00, 4.2894490086E-01, 3.5292910768E-01, 8.0985836704E-01],
	[2.8355000000E+04, 5.4272307171E+00, 3.1463940181E+00, 4.2917528804E-01, 3.5309107887E-01, 8.0989717227E-01],
	[2.8360000000E+04, 5.4287611326E+00, 3.1463575854E+00, 4.2940575824E-01, 3.5325308451E-01, 8.0993596940E-01],
	[2.8365000000E+04, 5.4302917098E+00, 3.1463211595E+00, 4.2963631146E-01, 3.5341512458E-01, 8.0997475843E-01],
	[2.8370000000E+04, 5.4318224487E+00, 3.1462847404E+00, 4.2986694773E-01, 3.5357719908E-01, 8.1001353936E-01],
	[2.8375000000E+04, 5.4333533492E+00, 3.1462483282E+00, 4.3009766706E-01, 3.5373930800E-01, 8.1005231220E-01],
	[2.8380000000E+04, 5.4348844113E+00, 3.1462119228E+00, 4.3032846947E-01, 3.5390145133E-01, 8.1009107694E-01],
	[2.8385000000E+04, 5.4364156350E+00, 3.1461755243E+00, 4.3055935496E-01, 3.5406362906E-01, 8.1012983360E-01],
	[2.8390000000E+04, 5.4379470202E+00, 3.1461391326E+00, 4.3079032356E-01, 3.5422584118E-01, 8.1016858216E-01],
	[2.8395000000E+04, 5.4394785671E+00, 3.1461027477E+00, 4.3102137528E-01, 3.5438808768E-01, 8.1020732264E-01],
	[2.8400000000E+04, 5.4410102756E+00, 3.1460663696E+00, 4.3125251014E-01, 3.5455036855E-01, 8.1024605503E-01],
	[2.8405000000E+04, 5.4425421456E+00, 3.1460299984E+00, 4.3148372815E-01, 3.5471268379E-01, 8.1028477934E-01],
	[2.8410000000E+04, 5.4440741771E+00, 3.1459936340E+00, 4.3171502932E-01, 3.5487503339E-01, 8.1032349556E-01],
	[2.8415000000E+04, 5.4456063702E+00, 3.1459572764E+00, 4.3194641368E-01, 3.5503741733E-01, 8.1036220371E-01],
	[2.8420000000E+04, 5.4471387248E+00, 3.1459209256E+00, 4.3217788123E-01, 3.5519983561E-01, 8.1040090378E-01],
	[2.8425000000E+04, 5.4486712409E+00, 3.1458845817E+00, 4.3240943199E-01, 3.5536228822E-01, 8.1043959578E-01],
	[2.8430000000E+04, 5.4502039185E+00, 3.1458482445E+00, 4.3264106598E-01, 3.5552477515E-01, 8.1047827970E-01],
	[2.8435000000E+04, 5.4517367576E+00, 3.1458119142E+00, 4.3287278322E-01, 3.5568729639E-01, 8.1051695554E-01],
	[2.8440000000E+04, 5.4532697582E+00, 3.1457755906E+00, 4.3310458371E-01, 3.5584985194E-01, 8.1055562332E-01],
	[2.8445000000E+04, 5.4548029203E+00, 3.1457392739E+00, 4.3333646747E-01, 3.5601244177E-01, 8.1059428303E-01],
	[2.8450000000E+04, 5.4563362438E+00, 3.1457029640E+00, 4.3356843453E-01, 3.5617506590E-01, 8.1063293468E-01],
	[2.8455000000E+04, 5.4578697287E+00, 3.1456666609E+00, 4.3380048488E-01, 3.5633772429E-01, 8.1067157826E-01],
	[2.8460000000E+04, 5.4594033751E+00, 3.1456303645E+00, 4.3403261856E-01, 3.5650041696E-01, 8.1071021377E-01],
	[2.8465000000E+04, 5.4609371829E+00, 3.1455940750E+00, 4.3426483556E-01, 3.5666314388E-01, 8.1074884123E-01],
	[2.8470000000E+04, 5.4624711521E+00, 3.1455577923E+00, 4.3449713592E-01, 3.5682590506E-01, 8.1078746063E-01],
	[2.8475000000E+04, 5.4640052828E+00, 3.1455215163E+00, 4.3472951964E-01, 3.5698870047E-01, 8.1082607197E-01],
	[2.8480000000E+04, 5.4655395748E+00, 3.1454852472E+00, 4.3496198674E-01, 3.5715153011E-01, 8.1086467526E-01],
	[2.8485000000E+04, 5.4670740282E+00, 3.1454489848E+00, 4.3519453724E-01, 3.5731439398E-01, 8.1090327049E-01],
	[2.8490000000E+04, 5.4686086429E+00, 3.1454127292E+00, 4.3542717115E-01, 3.5747729206E-01, 8.1094185767E-01],
	[2.8495000000E+04, 5.4701434190E+00, 3.1453764804E+00, 4.3565988848E-01, 3.5764022434E-01, 8.1098043681E-01],
	[2.8500000000E+04, 5.4716783564E+00, 3.1453402383E+00, 4.3589268925E-01, 3.5780319082E-01, 8.1101900789E-01],
	[2.8505000000E+04, 5.4732134552E+00, 3.1453040031E+00, 4.3612557348E-01, 3.5796619148E-01, 8.1105757093E-01],
	[2.8510000000E+04, 5.4747493212E+00, 3.1452684024E+00, 4.3635854118E-01, 3.5812923706E-01, 8.1109612593E-01],
	[2.8515000000E+04, 5.4762868615E+00, 3.1452343753E+00, 4.3659159236E-01, 3.5829234363E-01, 8.1113467289E-01],
	[2.8520000000E+04, 5.4778245639E+00, 3.1452003545E+00, 4.3682472705E-01, 3.5845548441E-01, 8.1117321181E-01],
	[2.8525000000E+04, 5.4793624284E+00, 3.1451663401E+00, 4.3705794525E-01, 3.5861865941E-01, 8.1121174268E-01],
	[2.8530000000E+04, 5.4809004550E+00, 3.1451323321E+00, 4.3729124698E-01, 3.5878186860E-01, 8.1125026553E-01],
	[2.8535000000E+04, 5.4824386437E+00, 3.1450983303E+00, 4.3752463227E-01, 3.5894511198E-01, 8.1128878034E-01],
	[2.8540000000E+04, 5.4839769945E+00, 3.1450643349E+00, 4.3775810111E-01, 3.5910838955E-01, 8.1132728711E-01],
	[2.8545000000E+04, 5.4855155073E+00, 3.1450303458E+00, 4.3799165353E-01, 3.5927170128E-01, 8.1136578586E-01],
	[2.8550000000E+04, 5.4870541822E+00, 3.1449963630E+00, 4.3822528955E-01, 3.5943504718E-01, 8.1140427658E-01],
	[2.8555000000E+04, 5.4885930191E+00, 3.1449623866E+00, 4.3845900917E-01, 3.5959842723E-01, 8.1144275927E-01],
	[2.8560000000E+04, 5.4901320180E+00, 3.1449284164E+00, 4.3869281242E-01, 3.5976184143E-01, 8.1148123394E-01],
	[2.8565000000E+04, 5.4916711790E+00, 3.1448944526E+00, 4.3892669930E-01, 3.5992528977E-01, 8.1151970059E-01],
	[2.8570000000E+04, 5.4932105019E+00, 3.1448604950E+00, 4.3916066984E-01, 3.6008877223E-01, 8.1155815922E-01],
	[2.8575000000E+04, 5.4947499868E+00, 3.1448265438E+00, 4.3939472405E-01, 3.6025228881E-01, 8.1159660982E-01],
	[2.8580000000E+04, 5.4962896337E+00, 3.1447925989E+00, 4.3962886194E-01, 3.6041583949E-01, 8.1163505241E-01],
	[2.8585000000E+04, 5.4978294426E+00, 3.1447586603E+00, 4.3986308353E-01, 3.6057942428E-01, 8.1167348699E-01],
	[2.8590000000E+04, 5.4993694134E+00, 3.1447247280E+00, 4.4009738883E-01, 3.6074304316E-01, 8.1171191355E-01],
	[2.8595000000E+04, 5.5009095462E+00, 3.1446908020E+00, 4.4033177787E-01, 3.6090669613E-01, 8.1175033210E-01],
	[2.8600000000E+04, 5.5024498409E+00, 3.1446568823E+00, 4.4056625065E-01, 3.6107038316E-01, 8.1178874264E-01],
	[2.8605000000E+04, 5.5039902975E+00, 3.1446229689E+00, 4.4080080719E-01, 3.6123410426E-01, 8.1182714518E-01],
	[2.8610000000E+04, 5.5055309161E+00, 3.1445890618E+00, 4.4103544751E-01, 3.6139785942E-01, 8.1186553971E-01],
	[2.8615000000E+04, 5.5070716965E+00, 3.1445551610E+00, 4.4127017162E-01, 3.6156164862E-01, 8.1190392623E-01],
	[2.8620000000E+04, 5.5086126389E+00, 3.1445212664E+00, 4.4150497953E-01, 3.6172547185E-01, 8.1194230476E-01],
	[2.8625000000E+04, 5.5101537431E+00, 3.1444873782E+00, 4.4173987126E-01, 3.6188932912E-01, 8.1198067528E-01],
	[2.8630000000E+04, 5.5116950091E+00, 3.1444534962E+00, 4.4197484684E-01, 3.6205322040E-01, 8.1201903781E-01],
	[2.8635000000E+04, 5.5132364370E+00, 3.1444196205E+00, 4.4220990626E-01, 3.6221714570E-01, 8.1205739234E-01],
	[2.8640000000E+04, 5.5147780268E+00, 3.1443857511E+00, 4.4244504955E-01, 3.6238110499E-01, 8.1209573888E-01],
	[2.8645000000E+04, 5.5163197784E+00, 3.1443518880E+00, 4.4268027672E-01, 3.6254509828E-01, 8.1213407742E-01],
	[2.8650000000E+04, 5.5178616918E+00, 3.1443180312E+00, 4.4291558780E-01, 3.6270912555E-01, 8.1217240798E-01],
	[2.8655000000E+04, 5.5194037671E+00, 3.1442841806E+00, 4.4315098278E-01, 3.6287318679E-01, 8.1221073054E-01],
	[2.8660000000E+04, 5.5209460041E+00, 3.1442503363E+00, 4.4338646169E-01, 3.6303728200E-01, 8.1224904512E-01],
	[2.8665000000E+04, 5.5224884029E+00, 3.1442164982E+00, 4.4362202454E-01, 3.6320141117E-01, 8.1228735172E-01],
	[2.8670000000E+04, 5.5240309635E+00, 3.1441826665E+00, 4.4385767136E-01, 3.6336557428E-01, 8.1232565033E-01],
	[2.8675000000E+04, 5.5255736858E+00, 3.1441488410E+00, 4.4409340214E-01, 3.6352977132E-01, 8.1236394096E-01],
	[2.8680000000E+04, 5.5271165699E+00, 3.1441150217E+00, 4.4432921692E-01, 3.6369400230E-01, 8.1240222361E-01],
	[2.8685000000E+04, 5.5286596158E+00, 3.1440812087E+00, 4.4456511570E-01, 3.6385826719E-01, 8.1244049829E-01],
	[2.8690000000E+04, 5.5302028234E+00, 3.1440474020E+00, 4.4480109850E-01, 3.6402256600E-01, 8.1247876499E-01],
	[2.8695000000E+04, 5.5317461927E+00, 3.1440136015E+00, 4.4503716533E-01, 3.6418689870E-01, 8.1251702372E-01],
	[2.8700000000E+04, 5.5332897237E+00, 3.1439798073E+00, 4.4527331622E-01, 3.6435126530E-01, 8.1255527447E-01],
	[2.8705000000E+04, 5.5348334164E+00, 3.1439460193E+00, 4.4550955117E-01, 3.6451566578E-01, 8.1259351726E-01],
	[2.8710000000E+04, 5.5363772707E+00, 3.1439122376E+00, 4.4574587020E-01, 3.6468010014E-01, 8.1263175208E-01],
	[2.8715000000E+04, 5.5379212868E+00, 3.1438784621E+00, 4.4598227332E-01, 3.6484456835E-01, 8.1266997893E-01],
	[2.8720000000E+04, 5.5394654645E+00, 3.1438446928E+00, 4.4621876056E-01, 3.6500907043E-01, 8.1270819782E-01],
	[2.8725000000E+04, 5.5410098039E+00, 3.1438109298E+00, 4.4645533192E-01, 3.6517360635E-01, 8.1274640875E-01],
	[2.8730000000E+04, 5.5425543049E+00, 3.1437771731E+00, 4.4669198743E-01, 3.6533817611E-01, 8.1278461171E-01],
	[2.8735000000E+04, 5.5440989676E+00, 3.1437434226E+00, 4.4692872709E-01, 3.6550277969E-01, 8.1282280672E-01],
	[2.8740000000E+04, 5.5456437918E+00, 3.1437096783E+00, 4.4716555092E-01, 3.6566741709E-01, 8.1286099378E-01],
	[2.8745000000E+04, 5.5471887777E+00, 3.1436759402E+00, 4.4740245894E-01, 3.6583208831E-01, 8.1289917287E-01],
	[2.8750000000E+04, 5.5487339252E+00, 3.1436422084E+00, 4.4763945116E-01, 3.6599679332E-01, 8.1293734402E-01],
	[2.8755000000E+04, 5.5502792342E+00, 3.1436084828E+00, 4.4787652760E-01, 3.6616153213E-01, 8.1297550721E-01],
	[2.8760000000E+04, 5.5518247048E+00, 3.1435747634E+00, 4.4811368827E-01, 3.6632630471E-01, 8.1301366246E-01],
	[2.8765000000E+04, 5.5533703370E+00, 3.1435410503E+00, 4.4835093319E-01, 3.6649111107E-01, 8.1305180976E-01],
	[2.8770000000E+04, 5.5549161308E+00, 3.1435073433E+00, 4.4858826237E-01, 3.6665595120E-01, 8.1308994912E-01],
	[2.8775000000E+04, 5.5564620860E+00, 3.1434736426E+00, 4.4882567583E-01, 3.6682082507E-01, 8.1312808053E-01],
	[2.8780000000E+04, 5.5580082028E+00, 3.1434399481E+00, 4.4906317359E-01, 3.6698573270E-01, 8.1316620400E-01],
	[2.8785000000E+04, 5.5595544812E+00, 3.1434062599E+00, 4.4930075565E-01, 3.6715067406E-01, 8.1320431953E-01],
	[2.8790000000E+04, 5.5611009210E+00, 3.1433725778E+00, 4.4953842204E-01, 3.6731564914E-01, 8.1324242712E-01],
	[2.8795000000E+04, 5.5626475223E+00, 3.1433389019E+00, 4.4977617277E-01, 3.6748065795E-01, 8.1328052678E-01],
	[2.8800000000E+04, 5.5641942851E+00, 3.1433052323E+00, 4.5001400785E-01, 3.6764570046E-01, 8.1331861850E-01],
	[2.8805000000E+04, 5.5657412094E+00, 3.1432715688E+00, 4.5025192730E-01, 3.6781077667E-01, 8.1335670230E-01],
	[2.8810000000E+04, 5.5672882951E+00, 3.1432379116E+00, 4.5048993114E-01, 3.6797588658E-01, 8.1339477816E-01],
	[2.8815000000E+04, 5.5688355423E+00, 3.1432042606E+00, 4.5072801938E-01, 3.6814103016E-01, 8.1343284609E-01],
	[2.8820000000E+04, 5.5703829510E+00, 3.1431706157E+00, 4.5096619203E-01, 3.6830620742E-01, 8.1347090610E-01],
	[2.8825000000E+04, 5.5719305210E+00, 3.1431369771E+00, 4.5120444912E-01, 3.6847141833E-01, 8.1350895818E-01],
	[2.8830000000E+04, 5.5734782525E+00, 3.1431033446E+00, 4.5144279065E-01, 3.6863666291E-01, 8.1354700235E-01],
	[2.8835000000E+04, 5.5750261454E+00, 3.1430697184E+00, 4.5168121664E-01, 3.6880194112E-01, 8.1358503859E-01],
	[2.8840000000E+04, 5.5765741996E+00, 3.1430360983E+00, 4.5191972711E-01, 3.6896725297E-01, 8.1362306691E-01],
	[2.8845000000E+04, 5.5781224153E+00, 3.1430024844E+00, 4.5215832207E-01, 3.6913259844E-01, 8.1366108731E-01],
	[2.8850000000E+04, 5.5796707923E+00, 3.1429688767E+00, 4.5239700154E-01, 3.6929797754E-01, 8.1369909980E-01],
	[2.8855000000E+04, 5.5812193307E+00, 3.1429352752E+00, 4.5263576553E-01, 3.6946339023E-01, 8.1373710438E-01],
	[2.8860000000E+04, 5.5827680305E+00, 3.1429016799E+00, 4.5287461406E-01, 3.6962883653E-01, 8.1377510105E-01],
	[2.8865000000E+04, 5.5843168915E+00, 3.1428680907E+00, 4.5311354714E-01, 3.6979431642E-01, 8.1381308980E-01],
	[2.8870000000E+04, 5.5858659140E+00, 3.1428345078E+00, 4.5335256479E-01, 3.6995982988E-01, 8.1385107065E-01],
	[2.8875000000E+04, 5.5874150977E+00, 3.1428009310E+00, 4.5359166702E-01, 3.7012537691E-01, 8.1388904360E-01],
	[2.8880000000E+04, 5.5889644427E+00, 3.1427673603E+00, 4.5383085385E-01, 3.7029095751E-01, 8.1392700864E-01],
	[2.8885000000E+04, 5.5905139490E+00, 3.1427337959E+00, 4.5407012529E-01, 3.7045657165E-01, 8.1396496578E-01],
	[2.8890000000E+04, 5.5920636166E+00, 3.1427002376E+00, 4.5430948136E-01, 3.7062221934E-01, 8.1400291501E-01],
	[2.8895000000E+04, 5.5936134455E+00, 3.1426666855E+00, 4.5454892208E-01, 3.7078790056E-01, 8.1404085636E-01],
	[2.8900000000E+04, 5.5951634357E+00, 3.1426331395E+00, 4.5478844746E-01, 3.7095361530E-01, 8.1407878980E-01],
	[2.8905000000E+04, 5.5967135870E+00, 3.1425995997E+00, 4.5502805751E-01, 3.7111936356E-01, 8.1411671535E-01],
	[2.8910000000E+04, 5.5982638997E+00, 3.1425660661E+00, 4.5526775225E-01, 3.7128514532E-01, 8.1415463301E-01],
	[2.8915000000E+04, 5.5998143735E+00, 3.1425325386E+00, 4.5550753170E-01, 3.7145096058E-01, 8.1419254277E-01],
	[2.8920000000E+04, 5.6013650086E+00, 3.1424990173E+00, 4.5574739587E-01, 3.7161680933E-01, 8.1423044465E-01],
	[2.8925000000E+04, 5.6029158049E+00, 3.1424655021E+00, 4.5598734477E-01, 3.7178269155E-01, 8.1426833864E-01],
	[2.8930000000E+04, 5.6044667623E+00, 3.1424319931E+00, 4.5622737842E-01, 3.7194860723E-01, 8.1430622475E-01],
	[2.8935000000E+04, 5.6060178810E+00, 3.1423984902E+00, 4.5646749684E-01, 3.7211455638E-01, 8.1434410297E-01],
	[2.8940000000E+04, 5.6075691608E+00, 3.1423649935E+00, 4.5670770005E-01, 3.7228053898E-01, 8.1438197331E-01],
	[2.8945000000E+04, 5.6091206018E+00, 3.1423315029E+00, 4.5694798804E-01, 3.7244655501E-01, 8.1441983578E-01],
	[2.8950000000E+04, 5.6106722039E+00, 3.1422980184E+00, 4.5718836085E-01, 3.7261260448E-01, 8.1445769036E-01],
	[2.8955000000E+04, 5.6122239672E+00, 3.1422645401E+00, 4.5742881849E-01, 3.7277868736E-01, 8.1449553707E-01],
	[2.8960000000E+04, 5.6137758916E+00, 3.1422310679E+00, 4.5766936097E-01, 3.7294480366E-01, 8.1453337591E-01],
	[2.8965000000E+04, 5.6153279771E+00, 3.1421976019E+00, 4.5790998831E-01, 3.7311095336E-01, 8.1457120687E-01],
	[2.8970000000E+04, 5.6168809834E+00, 3.1421652109E+00, 4.5815070052E-01, 3.7327715489E-01, 8.1460902996E-01],
	[2.8975000000E+04, 5.6184349227E+00, 3.1421339111E+00, 4.5839149762E-01, 3.7344340857E-01, 8.1464684519E-01],
	[2.8980000000E+04, 5.6199890237E+00, 3.1421026171E+00, 4.5863237962E-01, 3.7360969569E-01, 8.1468465255E-01],
	[2.8985000000E+04, 5.6215432863E+00, 3.1420713287E+00, 4.5887334654E-01, 3.7377601622E-01, 8.1472245204E-01],
	[2.8990000000E+04, 5.6230977105E+00, 3.1420400460E+00, 4.5911439839E-01, 3.7394237017E-01, 8.1476024368E-01],
	[2.8995000000E+04, 5.6246522964E+00, 3.1420087691E+00, 4.5935553520E-01, 3.7410875752E-01, 8.1479802745E-01],
	[2.9000000000E+04, 5.6262070439E+00, 3.1419774978E+00, 4.5959675697E-01, 3.7427517826E-01, 8.1483580336E-01],
	[2.9005000000E+04, 5.6277619530E+00, 3.1419462323E+00, 4.5983806371E-01, 3.7444163238E-01, 8.1487357141E-01],
	[2.9010000000E+04, 5.6293170237E+00, 3.1419149724E+00, 4.6007945546E-01, 3.7460811988E-01, 8.1491133162E-01],
	[2.9015000000E+04, 5.6308722560E+00, 3.1418837183E+00, 4.6032093221E-01, 3.7477464075E-01, 8.1494908396E-01],
	[2.9020000000E+04, 5.6324276498E+00, 3.1418524698E+00, 4.6056249399E-01, 3.7494119497E-01, 8.1498682846E-01],
	[2.9025000000E+04, 5.6339832053E+00, 3.1418212271E+00, 4.6080414080E-01, 3.7510778254E-01, 8.1502456510E-01],
	[2.9030000000E+04, 5.6355389222E+00, 3.1417899900E+00, 4.6104587268E-01, 3.7527440344E-01, 8.1506229390E-01],
	[2.9035000000E+04, 5.6370948008E+00, 3.1417587586E+00, 4.6128768962E-01, 3.7544105768E-01, 8.1510001486E-01],
	[2.9040000000E+04, 5.6386508408E+00, 3.1417275330E+00, 4.6152959165E-01, 3.7560774523E-01, 8.1513772796E-01],
	[2.9045000000E+04, 5.6402070424E+00, 3.1416963130E+00, 4.6177157879E-01, 3.7577446609E-01, 8.1517543323E-01],
	[2.9050000000E+04, 5.6417634055E+00, 3.1416650986E+00, 4.6201365104E-01, 3.7594122025E-01, 8.1521313066E-01],
	[2.9055000000E+04, 5.6433199301E+00, 3.1416338900E+00, 4.6225580842E-01, 3.7610800769E-01, 8.1525082025E-01],
	[2.9060000000E+04, 5.6448766162E+00, 3.1416026870E+00, 4.6249805095E-01, 3.7627482842E-01, 8.1528850200E-01],
	[2.9065000000E+04, 5.6464334638E+00, 3.1415714898E+00, 4.6274037864E-01, 3.7644168243E-01, 8.1532617591E-01],
	[2.9070000000E+04, 5.6479904728E+00, 3.1415402982E+00, 4.6298279151E-01, 3.7660856969E-01, 8.1536384200E-01],
	[2.9075000000E+04, 5.6495476433E+00, 3.1415091122E+00, 4.6322528957E-01, 3.7677549020E-01, 8.1540150025E-01],
	[2.9080000000E+04, 5.6511049752E+00, 3.1414779320E+00, 4.6346787284E-01, 3.7694244396E-01, 8.1543915068E-01],
	[2.9085000000E+04, 5.6526624686E+00, 3.1414467574E+00, 4.6371054134E-01, 3.7710943095E-01, 8.1547679327E-01],
	[2.9090000000E+04, 5.6542201234E+00, 3.1414155885E+00, 4.6395329507E-01, 3.7727645117E-01, 8.1551442804E-01],
	[2.9095000000E+04, 5.6557779395E+00, 3.1413844252E+00, 4.6419613406E-01, 3.7744350460E-01, 8.1555205499E-01],
	[2.9100000000E+04, 5.6573359171E+00, 3.1413532677E+00, 4.6443905831E-01, 3.7761059124E-01, 8.1558967412E-01],
	[2.9105000000E+04, 5.6588940561E+00, 3.1413221157E+00, 4.6468206785E-01, 3.7777771107E-01, 8.1562728543E-01],
	[2.9110000000E+04, 5.6604523565E+00, 3.1412909695E+00, 4.6492516269E-01, 3.7794486409E-01, 8.1566488891E-01],
	[2.9115000000E+04, 5.6620108182E+00, 3.1412598289E+00, 4.6516834285E-01, 3.7811205028E-01, 8.1570248459E-01],
	[2.9120000000E+04, 5.6635694413E+00, 3.1412286939E+00, 4.6541160833E-01, 3.7827926964E-01, 8.1574007244E-01],
	[2.9125000000E+04, 5.6651282257E+00, 3.1411975646E+00, 4.6565495917E-01, 3.7844652216E-01, 8.1577765249E-01],
	[2.9130000000E+04, 5.6666871715E+00, 3.1411664410E+00, 4.6589839536E-01, 3.7861380783E-01, 8.1581522473E-01],
	[2.9135000000E+04, 5.6682462786E+00, 3.1411353230E+00, 4.6614191692E-01, 3.7878112664E-01, 8.1585278915E-01],
	[2.9140000000E+04, 5.6698055470E+00, 3.1411042106E+00, 4.6638552388E-01, 3.7894847858E-01, 8.1589034577E-01],
	[2.9145000000E+04, 5.6713649767E+00, 3.1410731039E+00, 4.6662921625E-01, 3.7911586364E-01, 8.1592789459E-01],
	[2.9150000000E+04, 5.6729245677E+00, 3.1410420029E+00, 4.6687299404E-01, 3.7928328180E-01, 8.1596543560E-01],
	[2.9155000000E+04, 5.6744843200E+00, 3.1410109075E+00, 4.6711685726E-01, 3.7945073307E-01, 8.1600296881E-01],
	[2.9160000000E+04, 5.6760442335E+00, 3.1409798177E+00, 4.6736080594E-01, 3.7961821743E-01, 8.1604049422E-01],
	[2.9165000000E+04, 5.6776043083E+00, 3.1409487336E+00, 4.6760484008E-01, 3.7978573487E-01, 8.1607801183E-01],
	[2.9170000000E+04, 5.6791645444E+00, 3.1409176551E+00, 4.6784895971E-01, 3.7995328539E-01, 8.1611552165E-01],
	[2.9175000000E+04, 5.6807249416E+00, 3.1408865822E+00, 4.6809316483E-01, 3.8012086897E-01, 8.1615302367E-01],
	[2.9180000000E+04, 5.6822855002E+00, 3.1408555150E+00, 4.6833745547E-01, 3.8028848560E-01, 8.1619051791E-01],
	[2.9185000000E+04, 5.6838462199E+00, 3.1408244534E+00, 4.6858183163E-01, 3.8045613527E-01, 8.1622800435E-01],
	[2.9190000000E+04, 5.6854071008E+00, 3.1407933974E+00, 4.6882629334E-01, 3.8062381798E-01, 8.1626548300E-01],
	[2.9195000000E+04, 5.6869681429E+00, 3.1407623470E+00, 4.6907084061E-01, 3.8079153372E-01, 8.1630295387E-01],
	[2.9200000000E+04, 5.6885293462E+00, 3.1407313023E+00, 4.6931547345E-01, 3.8095928247E-01, 8.1634041695E-01],
	[2.9205000000E+04, 5.6900907107E+00, 3.1407002632E+00, 4.6956019189E-01, 3.8112706422E-01, 8.1637787225E-01],
	[2.9210000000E+04, 5.6916522363E+00, 3.1406692297E+00, 4.6980499592E-01, 3.8129487897E-01, 8.1641531977E-01],
	[2.9215000000E+04, 5.6932139231E+00, 3.1406382019E+00, 4.7004988558E-01, 3.8146272671E-01, 8.1645275951E-01],
	[2.9220000000E+04, 5.6947757710E+00, 3.1406071796E+00, 4.7029486087E-01, 3.8163060743E-01, 8.1649019147E-01],
	[2.9225000000E+04, 5.6963377800E+00, 3.1405761630E+00, 4.7053992181E-01, 3.8179852111E-01, 8.1652761565E-01],
	[2.9230000000E+04, 5.6978999501E+00, 3.1405451520E+00, 4.7078506842E-01, 3.8196646775E-01, 8.1656503207E-01],
	[2.9235000000E+04, 5.6994622814E+00, 3.1405141466E+00, 4.7103030071E-01, 3.8213444734E-01, 8.1660244071E-01],
	[2.9240000000E+04, 5.7010247737E+00, 3.1404831468E+00, 4.7127561870E-01, 3.8230245987E-01, 8.1663984158E-01],
	[2.9245000000E+04, 5.7025874272E+00, 3.1404521526E+00, 4.7152102239E-01, 3.8247050533E-01, 8.1667723468E-01],
	[2.9250000000E+04, 5.7041502417E+00, 3.1404211640E+00, 4.7176651181E-01, 3.8263858371E-01, 8.1671462002E-01],
	[2.9255000000E+04, 5.7057132172E+00, 3.1403901810E+00, 4.7201208698E-01, 3.8280669500E-01, 8.1675199759E-01],
	[2.9260000000E+04, 5.7072763538E+00, 3.1403592036E+00, 4.7225774790E-01, 3.8297483918E-01, 8.1678936740E-01],
	[2.9265000000E+04, 5.7088396515E+00, 3.1403282318E+00, 4.7250349460E-01, 3.8314301626E-01, 8.1682672945E-01],
	[2.9270000000E+04, 5.7104031101E+00, 3.1402972656E+00, 4.7274932708E-01, 3.8331122623E-01, 8.1686408374E-01],
	[2.9275000000E+04, 5.7119667298E+00, 3.1402663050E+00, 4.7299524536E-01, 3.8347946906E-01, 8.1690143028E-01],
	[2.9280000000E+04, 5.7135305105E+00, 3.1402353500E+00, 4.7324124947E-01, 3.8364774475E-01, 8.1693876906E-01],
	[2.9285000000E+04, 5.7150944522E+00, 3.1402044006E+00, 4.7348733940E-01, 3.8381605330E-01, 8.1697610008E-01],
	[2.9290000000E+04, 5.7166585549E+00, 3.1401734568E+00, 4.7373351519E-01, 3.8398439469E-01, 8.1701342336E-01],
	[2.9295000000E+04, 5.7182228185E+00, 3.1401425185E+00, 4.7397977684E-01, 3.8415276891E-01, 8.1705073888E-01],
	[2.9300000000E+04, 5.7197872431E+00, 3.1401115859E+00, 4.7422612436E-01, 3.8432117596E-01, 8.1708804666E-01],
	[2.9305000000E+04, 5.7213518287E+00, 3.1400806588E+00, 4.7447255779E-01, 3.8448961582E-01, 8.1712534669E-01],
	[2.9310000000E+04, 5.7229165752E+00, 3.1400497373E+00, 4.7471907712E-01, 3.8465808849E-01, 8.1716263898E-01],
	[2.9315000000E+04, 5.7244814826E+00, 3.1400188214E+00, 4.7496568237E-01, 3.8482659395E-01, 8.1719992352E-01],
	[2.9320000000E+04, 5.7260465510E+00, 3.1399879110E+00, 4.7521237357E-01, 3.8499513219E-01, 8.1723720032E-01],
	[2.9325000000E+04, 5.7276117802E+00, 3.1399570063E+00, 4.7545915072E-01, 3.8516370321E-01, 8.1727446939E-01],
	[2.9330000000E+04, 5.7291771704E+00, 3.1399261071E+00, 4.7570601385E-01, 3.8533230700E-01, 8.1731173072E-01],
	[2.9335000000E+04, 5.7307427214E+00, 3.1398952135E+00, 4.7595296296E-01, 3.8550094354E-01, 8.1734898431E-01],
	[2.9340000000E+04, 5.7323084333E+00, 3.1398643254E+00, 4.7619999807E-01, 3.8566961283E-01, 8.1738623017E-01],
	[2.9345000000E+04, 5.7338743061E+00, 3.1398334430E+00, 4.7644711919E-01, 3.8583831486E-01, 8.1742346830E-01],
	[2.9350000000E+04, 5.7354403397E+00, 3.1398025660E+00, 4.7669432635E-01, 3.8600704961E-01, 8.1746069870E-01],
	[2.9355000000E+04, 5.7370065342E+00, 3.1397716947E+00, 4.7694161956E-01, 3.8617581708E-01, 8.1749792137E-01],
	[2.9360000000E+04, 5.7385728895E+00, 3.1397408289E+00, 4.7718899882E-01, 3.8634461726E-01, 8.1753513632E-01],
	[2.9365000000E+04, 5.7401394056E+00, 3.1397099687E+00, 4.7743646417E-01, 3.8651345014E-01, 8.1757234354E-01],
	[2.9370000000E+04, 5.7417060825E+00, 3.1396791140E+00, 4.7768401560E-01, 3.8668231570E-01, 8.1760954305E-01],
	[2.9375000000E+04, 5.7432729203E+00, 3.1396482649E+00, 4.7793165315E-01, 3.8685121394E-01, 8.1764673483E-01],
	[2.9380000000E+04, 5.7448399188E+00, 3.1396174213E+00, 4.7817937682E-01, 3.8702014486E-01, 8.1768391889E-01],
	[2.9385000000E+04, 5.7464070781E+00, 3.1395865833E+00, 4.7842718662E-01, 3.8718910843E-01, 8.1772109523E-01],
	[2.9390000000E+04, 5.7479743981E+00, 3.1395557508E+00, 4.7867508258E-01, 3.8735810465E-01, 8.1775826386E-01],
	[2.9395000000E+04, 5.7495418789E+00, 3.1395249239E+00, 4.7892306471E-01, 3.8752713351E-01, 8.1779542478E-01],
	[2.9400000000E+04, 5.7511095205E+00, 3.1394941025E+00, 4.7917113302E-01, 3.8769619500E-01, 8.1783257799E-01],
	[2.9405000000E+04, 5.7526773228E+00, 3.1394632867E+00, 4.7941928754E-01, 3.8786528911E-01, 8.1786972349E-01],
	[2.9410000000E+04, 5.7542452858E+00, 3.1394324764E+00, 4.7966752826E-01, 3.8803441584E-01, 8.1790686128E-01],
	[2.9415000000E+04, 5.7558134095E+00, 3.1394016717E+00, 4.7991585522E-01, 3.8820357516E-01, 8.1794399136E-01],
	[2.9420000000E+04, 5.7573816939E+00, 3.1393708725E+00, 4.8016426842E-01, 3.8837276708E-01, 8.1798111374E-01],
	[2.9425000000E+04, 5.7589501391E+00, 3.1393400788E+00, 4.8041276788E-01, 3.8854199157E-01, 8.1801822842E-01],
	[2.9430000000E+04, 5.7605187448E+00, 3.1393092907E+00, 4.8066135362E-01, 3.8871124864E-01, 8.1805533540E-01],
	[2.9435000000E+04, 5.7620877245E+00, 3.1392789916E+00, 4.8091002565E-01, 3.8888054666E-01, 8.1809243468E-01],
	[2.9440000000E+04, 5.7636575840E+00, 3.1392503289E+00, 4.8115878399E-01, 3.8904990557E-01, 8.1812952627E-01],
	[2.9445000000E+04, 5.7652276046E+00, 3.1392216713E+00, 4.8140762864E-01, 3.8921929708E-01, 8.1816661016E-01],
	[2.9450000000E+04, 5.7667977861E+00, 3.1391930189E+00, 4.8165655964E-01, 3.8938872118E-01, 8.1820368635E-01],
	[2.9455000000E+04, 5.7683681287E+00, 3.1391643716E+00, 4.8190557698E-01, 3.8955817786E-01, 8.1824075486E-01],
	[2.9460000000E+04, 5.7699386321E+00, 3.1391357294E+00, 4.8215468069E-01, 3.8972766711E-01, 8.1827781568E-01],
	[2.9465000000E+04, 5.7715092966E+00, 3.1391070924E+00, 4.8240387079E-01, 3.8989718892E-01, 8.1831486881E-01],
	[2.9470000000E+04, 5.7730801220E+00, 3.1390784604E+00, 4.8265314728E-01, 3.9006674328E-01, 8.1835191425E-01],
	[2.9475000000E+04, 5.7746511083E+00, 3.1390498336E+00, 4.8290251018E-01, 3.9023633017E-01, 8.1838895201E-01],
	[2.9480000000E+04, 5.7762222555E+00, 3.1390212119E+00, 4.8315195952E-01, 3.9040594960E-01, 8.1842598209E-01],
	[2.9485000000E+04, 5.7777935636E+00, 3.1389925953E+00, 4.8340149529E-01, 3.9057560155E-01, 8.1846300449E-01],
	[2.9490000000E+04, 5.7793650327E+00, 3.1389639839E+00, 4.8365111753E-01, 3.9074528601E-01, 8.1850001921E-01],
	[2.9495000000E+04, 5.7809366626E+00, 3.1389353775E+00, 4.8390082624E-01, 3.9091500297E-01, 8.1853702625E-01],
	[2.9500000000E+04, 5.7825084534E+00, 3.1389067762E+00, 4.8415062144E-01, 3.9108475242E-01, 8.1857402562E-01],
	[2.9505000000E+04, 5.7840804051E+00, 3.1388781801E+00, 4.8440050314E-01, 3.9125453436E-01, 8.1861101732E-01],
	[2.9510000000E+04, 5.7856525176E+00, 3.1388495891E+00, 4.8465047136E-01, 3.9142434876E-01, 8.1864800135E-01],
	[2.9515000000E+04, 5.7872247909E+00, 3.1388210031E+00, 4.8490052612E-01, 3.9159419563E-01, 8.1868497770E-01],
	[2.9520000000E+04, 5.7887972251E+00, 3.1387924223E+00, 4.8515066743E-01, 3.9176407495E-01, 8.1872194639E-01],
	[2.9525000000E+04, 5.7903698202E+00, 3.1387638466E+00, 4.8540089530E-01, 3.9193398671E-01, 8.1875890742E-01],
	[2.9530000000E+04, 5.7919425760E+00, 3.1387352759E+00, 4.8565120975E-01, 3.9210393091E-01, 8.1879586078E-01],
	[2.9535000000E+04, 5.7935154926E+00, 3.1387067104E+00, 4.8590161080E-01, 3.9227390753E-01, 8.1883280648E-01],
	[2.9540000000E+04, 5.7950885701E+00, 3.1386781499E+00, 4.8615209846E-01, 3.9244391656E-01, 8.1886974452E-01],
	[2.9545000000E+04, 5.7966618083E+00, 3.1386495946E+00, 4.8640267275E-01, 3.9261395799E-01, 8.1890667490E-01],
	[2.9550000000E+04, 5.7982352073E+00, 3.1386210443E+00, 4.8665333368E-01, 3.9278403182E-01, 8.1894359762E-01],
	[2.9555000000E+04, 5.7998087670E+00, 3.1385924992E+00, 4.8690408127E-01, 3.9295413804E-01, 8.1898051269E-01],
	[2.9560000000E+04, 5.8013824875E+00, 3.1385639591E+00, 4.8715491552E-01, 3.9312427662E-01, 8.1901742011E-01],
	[2.9565000000E+04, 5.8029563687E+00, 3.1385354241E+00, 4.8740583647E-01, 3.9329444757E-01, 8.1905431988E-01],
	[2.9570000000E+04, 5.8045304106E+00, 3.1385068942E+00, 4.8765684412E-01, 3.9346465088E-01, 8.1909121200E-01],
	[2.9575000000E+04, 5.8061046133E+00, 3.1384783694E+00, 4.8790793848E-01, 3.9363488652E-01, 8.1912809647E-01],
	[2.9580000000E+04, 5.8076789767E+00, 3.1384498496E+00, 4.8815911958E-01, 3.9380515451E-01, 8.1916497329E-01],
	[2.9585000000E+04, 5.8092535007E+00, 3.1384213350E+00, 4.8841038743E-01, 3.9397545482E-01, 8.1920184247E-01],
	[2.9590000000E+04, 5.8108281855E+00, 3.1383928254E+00, 4.8866174204E-01, 3.9414578744E-01, 8.1923870401E-01],
	[2.9595000000E+04, 5.8124030309E+00, 3.1383643209E+00, 4.8891318343E-01, 3.9431615237E-01, 8.1927555791E-01],
	[2.9600000000E+04, 5.8139780370E+00, 3.1383358215E+00, 4.8916471162E-01, 3.9448654959E-01, 8.1931240418E-01],
	[2.9605000000E+04, 5.8155532037E+00, 3.1383073271E+00, 4.8941632661E-01, 3.9465697910E-01, 8.1934924280E-01],
	[2.9610000000E+04, 5.8171285310E+00, 3.1382788378E+00, 4.8966802843E-01, 3.9482744088E-01, 8.1938607379E-01],
	[2.9615000000E+04, 5.8187040190E+00, 3.1382503536E+00, 4.8991981709E-01, 3.9499793493E-01, 8.1942289715E-01],
	[2.9620000000E+04, 5.8202796677E+00, 3.1382218744E+00, 4.9017169260E-01, 3.9516846124E-01, 8.1945971288E-01],
	[2.9625000000E+04, 5.8218554769E+00, 3.1381934003E+00, 4.9042365499E-01, 3.9533901979E-01, 8.1949652098E-01],
	[2.9630000000E+04, 5.8234314467E+00, 3.1381649313E+00, 4.9067570426E-01, 3.9550961058E-01, 8.1953332145E-01],
	[2.9635000000E+04, 5.8250075771E+00, 3.1381364674E+00, 4.9092784043E-01, 3.9568023359E-01, 8.1957011429E-01],
	[2.9640000000E+04, 5.8265838681E+00, 3.1381080085E+00, 4.9118006352E-01, 3.9585088882E-01, 8.1960689952E-01],
	[2.9645000000E+04, 5.8281603196E+00, 3.1380795546E+00, 4.9143237354E-01, 3.9602157626E-01, 8.1964367712E-01],
	[2.9650000000E+04, 5.8297369317E+00, 3.1380511058E+00, 4.9168477050E-01, 3.9619229589E-01, 8.1968044710E-01],
	[2.9655000000E+04, 5.8313137044E+00, 3.1380226621E+00, 4.9193725443E-01, 3.9636304771E-01, 8.1971720946E-01],
	[2.9660000000E+04, 5.8328906375E+00, 3.1379942234E+00, 4.9218982534E-01, 3.9653383171E-01, 8.1975396420E-01],
	[2.9665000000E+04, 5.8344677312E+00, 3.1379657898E+00, 4.9244248324E-01, 3.9670464787E-01, 8.1979071133E-01],
	[2.9670000000E+04, 5.8360449854E+00, 3.1379373612E+00, 4.9269522814E-01, 3.9687549619E-01, 8.1982745085E-01],
	[2.9675000000E+04, 5.8376224001E+00, 3.1379089377E+00, 4.9294806007E-01, 3.9704637666E-01, 8.1986418276E-01],
	[2.9680000000E+04, 5.8391999753E+00, 3.1378805192E+00, 4.9320097904E-01, 3.9721728926E-01, 8.1990090706E-01],
	[2.9685000000E+04, 5.8407777110E+00, 3.1378521057E+00, 4.9345398506E-01, 3.9738823399E-01, 8.1993762375E-01],
	[2.9690000000E+04, 5.8423556072E+00, 3.1378236973E+00, 4.9370707815E-01, 3.9755921084E-01, 8.1997433284E-01],
	[2.9695000000E+04, 5.8439336638E+00, 3.1377952940E+00, 4.9396025832E-01, 3.9773021980E-01, 8.2001103432E-01],
	[2.9700000000E+04, 5.8455118808E+00, 3.1377668957E+00, 4.9421352560E-01, 3.9790126085E-01, 8.2004772820E-01],
	[2.9705000000E+04, 5.8470902583E+00, 3.1377385024E+00, 4.9446687998E-01, 3.9807233399E-01, 8.2008441448E-01],
	[2.9710000000E+04, 5.8486687962E+00, 3.1377101141E+00, 4.9472032150E-01, 3.9824343921E-01, 8.2012109316E-01],
	[2.9715000000E+04, 5.8502474945E+00, 3.1376817309E+00, 4.9497385016E-01, 3.9841457649E-01, 8.2015776424E-01],
	[2.9720000000E+04, 5.8518263533E+00, 3.1376533528E+00, 4.9522746599E-01, 3.9858574584E-01, 8.2019442773E-01],
	[2.9725000000E+04, 5.8534053724E+00, 3.1376249796E+00, 4.9548116899E-01, 3.9875694723E-01, 8.2023108363E-01],
	[2.9730000000E+04, 5.8549845519E+00, 3.1375966115E+00, 4.9573495918E-01, 3.9892818065E-01, 8.2026773194E-01],
	[2.9735000000E+04, 5.8565638918E+00, 3.1375682484E+00, 4.9598883657E-01, 3.9909944611E-01, 8.2030437265E-01],
	[2.9740000000E+04, 5.8581433920E+00, 3.1375398903E+00, 4.9624280119E-01, 3.9927074358E-01, 8.2034100578E-01],
	[2.9745000000E+04, 5.8597230526E+00, 3.1375115373E+00, 4.9649685304E-01, 3.9944207306E-01, 8.2037763133E-01],
	[2.9750000000E+04, 5.8613028735E+00, 3.1374831893E+00, 4.9675099215E-01, 3.9961343454E-01, 8.2041424929E-01],
	[2.9755000000E+04, 5.8628828548E+00, 3.1374548463E+00, 4.9700521852E-01, 3.9978482801E-01, 8.2045085967E-01],
	[2.9760000000E+04, 5.8644629963E+00, 3.1374265083E+00, 4.9725953218E-01, 3.9995625345E-01, 8.2048746246E-01],
	[2.9765000000E+04, 5.8660432982E+00, 3.1373981753E+00, 4.9751393313E-01, 4.0012771087E-01, 8.2052405768E-01],
	[2.9770000000E+04, 5.8676237604E+00, 3.1373698473E+00, 4.9776842140E-01, 4.0029920024E-01, 8.2056064533E-01],
	[2.9775000000E+04, 5.8692043829E+00, 3.1373415244E+00, 4.9802299699E-01, 4.0047072155E-01, 8.2059722540E-01],
	[2.9780000000E+04, 5.8707851656E+00, 3.1373132065E+00, 4.9827765993E-01, 4.0064227481E-01, 8.2063379789E-01],
	[2.9785000000E+04, 5.8723661086E+00, 3.1372848936E+00, 4.9853241022E-01, 4.0081385999E-01, 8.2067036281E-01],
	[2.9790000000E+04, 5.8739472119E+00, 3.1372565857E+00, 4.9878724789E-01, 4.0098547710E-01, 8.2070692017E-01],
	[2.9795000000E+04, 5.8755284754E+00, 3.1372282827E+00, 4.9904217295E-01, 4.0115712610E-01, 8.2074346995E-01],
	[2.9800000000E+04, 5.8771098991E+00, 3.1371999848E+00, 4.9929718542E-01, 4.0132880701E-01, 8.2078001218E-01],
	[2.9805000000E+04, 5.8786914831E+00, 3.1371716920E+00, 4.9955228530E-01, 4.0150051981E-01, 8.2081654683E-01],
	[2.9810000000E+04, 5.8802732273E+00, 3.1371434041E+00, 4.9980747262E-01, 4.0167226448E-01, 8.2085307393E-01],
	[2.9815000000E+04, 5.8818551316E+00, 3.1371151212E+00, 5.0006274739E-01, 4.0184404102E-01, 8.2088959346E-01],
	[2.9820000000E+04, 5.8834371962E+00, 3.1370868433E+00, 5.0031810962E-01, 4.0201584941E-01, 8.2092610544E-01],
	[2.9825000000E+04, 5.8850194210E+00, 3.1370585704E+00, 5.0057355934E-01, 4.0218768966E-01, 8.2096260986E-01],
	[2.9830000000E+04, 5.8866018059E+00, 3.1370303024E+00, 5.0082909655E-01, 4.0235956174E-01, 8.2099910672E-01],
	[2.9835000000E+04, 5.8881843509E+00, 3.1370020395E+00, 5.0108472127E-01, 4.0253146565E-01, 8.2103559603E-01],
	[2.9840000000E+04, 5.8897670562E+00, 3.1369737816E+00, 5.0134043352E-01, 4.0270340138E-01, 8.2107207779E-01],
	[2.9845000000E+04, 5.8913499215E+00, 3.1369455287E+00, 5.0159623331E-01, 4.0287536891E-01, 8.2110855200E-01],
	[2.9850000000E+04, 5.8929329470E+00, 3.1369172807E+00, 5.0185212066E-01, 4.0304736825E-01, 8.2114501866E-01],
	[2.9855000000E+04, 5.8945161326E+00, 3.1368890378E+00, 5.0210809558E-01, 4.0321939937E-01, 8.2118147777E-01],
	[2.9860000000E+04, 5.8960994783E+00, 3.1368607998E+00, 5.0236415809E-01, 4.0339146226E-01, 8.2121792934E-01],
	[2.9865000000E+04, 5.8976829841E+00, 3.1368325668E+00, 5.0262030820E-01, 4.0356355693E-01, 8.2125437337E-01],
	[2.9870000000E+04, 5.8992666500E+00, 3.1368043388E+00, 5.0287654593E-01, 4.0373568335E-01, 8.2129080986E-01],
	[2.9875000000E+04, 5.9008504760E+00, 3.1367761157E+00, 5.0313287129E-01, 4.0390784152E-01, 8.2132723881E-01],
	[2.9880000000E+04, 5.9024344620E+00, 3.1367478977E+00, 5.0338928430E-01, 4.0408003142E-01, 8.2136366022E-01],
	[2.9885000000E+04, 5.9040186081E+00, 3.1367196846E+00, 5.0364578498E-01, 4.0425225305E-01, 8.2140007410E-01],
	[2.9890000000E+04, 5.9056029142E+00, 3.1366914765E+00, 5.0390237333E-01, 4.0442450640E-01, 8.2143648044E-01],
	[2.9895000000E+04, 5.9071873803E+00, 3.1366632733E+00, 5.0415904938E-01, 4.0459679145E-01, 8.2147287925E-01],
	[2.9900000000E+04, 5.9087720065E+00, 3.1366350751E+00, 5.0441581314E-01, 4.0476910820E-01, 8.2150927053E-01],
	[2.9905000000E+04, 5.9103567927E+00, 3.1366068819E+00, 5.0467266462E-01, 4.0494145664E-01, 8.2154565429E-01],
	[2.9910000000E+04, 5.9119419280E+00, 3.1365796476E+00, 5.0492960385E-01, 4.0511385356E-01, 8.2158203051E-01],
	[2.9915000000E+04, 5.9135274458E+00, 3.1365535395E+00, 5.0518663083E-01, 4.0528630193E-01, 8.2161839922E-01],
	[2.9920000000E+04, 5.9151131237E+00, 3.1365274359E+00, 5.0544374558E-01, 4.0545878201E-01, 8.2165476040E-01],
	[2.9925000000E+04, 5.9166989617E+00, 3.1365013368E+00, 5.0570094811E-01, 4.0563129380E-01, 8.2169111405E-01],
	[2.9930000000E+04, 5.9182849598E+00, 3.1364752424E+00, 5.0595823845E-01, 4.0580383728E-01, 8.2172746019E-01],
	[2.9935000000E+04, 5.9198711180E+00, 3.1364491525E+00, 5.0621561660E-01, 4.0597641244E-01, 8.2176379882E-01],
	[2.9940000000E+04, 5.9214574363E+00, 3.1364230672E+00, 5.0647308259E-01, 4.0614901927E-01, 8.2180012992E-01],
	[2.9945000000E+04, 5.9230439147E+00, 3.1363969865E+00, 5.0673063642E-01, 4.0632165776E-01, 8.2183645351E-01],
	[2.9950000000E+04, 5.9246305532E+00, 3.1363709104E+00, 5.0698827811E-01, 4.0649432791E-01, 8.2187276960E-01],
	[2.9955000000E+04, 5.9262173517E+00, 3.1363448388E+00, 5.0724600769E-01, 4.0666702969E-01, 8.2190907817E-01],
	[2.9960000000E+04, 5.9278043102E+00, 3.1363187718E+00, 5.0750382515E-01, 4.0683976311E-01, 8.2194537923E-01],
	[2.9965000000E+04, 5.9293914288E+00, 3.1362927093E+00, 5.0776173052E-01, 4.0701252814E-01, 8.2198167278E-01],
	[2.9970000000E+04, 5.9309787074E+00, 3.1362666514E+00, 5.0801972382E-01, 4.0718532479E-01, 8.2201795883E-01],
	[2.9975000000E+04, 5.9325661461E+00, 3.1362405981E+00, 5.0827780505E-01, 4.0735815304E-01, 8.2205423738E-01],
	[2.9980000000E+04, 5.9341537447E+00, 3.1362145494E+00, 5.0853597424E-01, 4.0753101288E-01, 8.2209050843E-01],
	[2.9985000000E+04, 5.9357415033E+00, 3.1361885052E+00, 5.0879423140E-01, 4.0770390429E-01, 8.2212677197E-01],
	[2.9990000000E+04, 5.9373294219E+00, 3.1361624655E+00, 5.0905257654E-01, 4.0787682728E-01, 8.2216302802E-01],
	[2.9995000000E+04, 5.9389175005E+00, 3.1361364305E+00, 5.0931100968E-01, 4.0804978183E-01, 8.2219927657E-01],
	[3.0000000000E+04, 5.9405057390E+00, 3.1361103999E+00, 5.0956953084E-01, 4.0822276793E-01, 8.2223551763E-01],
	[3.0005000000E+04, 5.9420941375E+00, 3.1360843740E+00, 5.0983024607E-01, 4.0839713696E-01, 8.2227175120E-01],
	[3.0010000000E+04, 5.9436826959E+00, 3.1360583525E+00, 5.1009105114E-01, 4.0857153822E-01, 8.2230797727E-01],
	[3.0015000000E+04, 5.9452714143E+00, 3.1360323357E+00, 5.1035194607E-01, 4.0874597170E-01, 8.2234419586E-01],
	[3.0020000000E+04, 5.9468602926E+00, 3.1360063234E+00, 5.1061293088E-01, 4.0892043738E-01, 8.2238040696E-01],
	[3.0025000000E+04, 5.9484493307E+00, 3.1359803156E+00, 5.1087400557E-01, 4.0909493527E-01, 8.2241661057E-01],
	[3.0030000000E+04, 5.9500385288E+00, 3.1359543124E+00, 5.1113517017E-01, 4.0926946534E-01, 8.2245280670E-01],
	[3.0035000000E+04, 5.9516278868E+00, 3.1359283137E+00, 5.1139642470E-01, 4.0944402758E-01, 8.2248899535E-01],
	[3.0040000000E+04, 5.9532174046E+00, 3.1359023196E+00, 5.1165776916E-01, 4.0961862200E-01, 8.2252517652E-01],
	[3.0045000000E+04, 5.9548070824E+00, 3.1358763300E+00, 5.1191920358E-01, 4.0979324856E-01, 8.2256135021E-01],
	[3.0050000000E+04, 5.9563969199E+00, 3.1358503449E+00, 5.1218072797E-01, 4.0996790728E-01, 8.2259751643E-01],
	[3.0055000000E+04, 5.9579869173E+00, 3.1358243644E+00, 5.1244234234E-01, 4.1014259813E-01, 8.2263367517E-01],
	[3.0060000000E+04, 5.9595770746E+00, 3.1357983884E+00, 5.1270404672E-01, 4.1031732110E-01, 8.2266982643E-01],
	[3.0065000000E+04, 5.9611673916E+00, 3.1357724170E+00, 5.1296584111E-01, 4.1049207619E-01, 8.2270597023E-01],
	[3.0070000000E+04, 5.9627578685E+00, 3.1357464501E+00, 5.1322772554E-01, 4.1066686339E-01, 8.2274210656E-01],
	[3.0075000000E+04, 5.9643485052E+00, 3.1357204877E+00, 5.1348970002E-01, 4.1084168267E-01, 8.2277823542E-01],
	[3.0080000000E+04, 5.9659393017E+00, 3.1356945298E+00, 5.1375176457E-01, 4.1101653405E-01, 8.2281435681E-01],
	[3.0085000000E+04, 5.9675302580E+00, 3.1356685765E+00, 5.1401391920E-01, 4.1119141749E-01, 8.2285047074E-01],
	[3.0090000000E+04, 5.9691213740E+00, 3.1356426277E+00, 5.1427616392E-01, 4.1136633300E-01, 8.2288657721E-01],
	[3.0095000000E+04, 5.9707126498E+00, 3.1356166835E+00, 5.1453849876E-01, 4.1154128056E-01, 8.2292267621E-01],
	[3.0100000000E+04, 5.9723040853E+00, 3.1355907437E+00, 5.1480092373E-01, 4.1171626016E-01, 8.2295876776E-01],
	[3.0105000000E+04, 5.9738956806E+00, 3.1355648085E+00, 5.1506343885E-01, 4.1189127179E-01, 8.2299485185E-01],
	[3.0110000000E+04, 5.9754874356E+00, 3.1355388778E+00, 5.1532604413E-01, 4.1206631544E-01, 8.2303092849E-01],
	[3.0115000000E+04, 5.9770793504E+00, 3.1355129517E+00, 5.1558873958E-01, 4.1224139111E-01, 8.2306699767E-01],
	[3.0120000000E+04, 5.9786714248E+00, 3.1354870300E+00, 5.1585152523E-01, 4.1241649877E-01, 8.2310305941E-01],
	[3.0125000000E+04, 5.9802636589E+00, 3.1354611129E+00, 5.1611440109E-01, 4.1259163842E-01, 8.2313911369E-01],
	[3.0130000000E+04, 5.9818560528E+00, 3.1354352002E+00, 5.1637736717E-01, 4.1276681006E-01, 8.2317516052E-01],
	[3.0135000000E+04, 5.9834486063E+00, 3.1354092921E+00, 5.1664042350E-01, 4.1294201366E-01, 8.2321119991E-01],
	[3.0140000000E+04, 5.9850413194E+00, 3.1353833885E+00, 5.1690357008E-01, 4.1311724922E-01, 8.2324723185E-01],
	[3.0145000000E+04, 5.9866341923E+00, 3.1353574895E+00, 5.1716680694E-01, 4.1329251673E-01, 8.2328325635E-01],
	[3.0150000000E+04, 5.9882272247E+00, 3.1353315949E+00, 5.1743013409E-01, 4.1346781618E-01, 8.2331927341E-01],
	[3.0155000000E+04, 5.9898204168E+00, 3.1353057048E+00, 5.1769355154E-01, 4.1364314755E-01, 8.2335528304E-01],
	[3.0160000000E+04, 5.9914137686E+00, 3.1352798193E+00, 5.1795705931E-01, 4.1381851084E-01, 8.2339128522E-01],
	[3.0165000000E+04, 5.9930072799E+00, 3.1352539382E+00, 5.1822065742E-01, 4.1399390604E-01, 8.2342727997E-01],
	[3.0170000000E+04, 5.9946009509E+00, 3.1352280616E+00, 5.1848434589E-01, 4.1416933313E-01, 8.2346326728E-01],
	[3.0175000000E+04, 5.9961947814E+00, 3.1352021896E+00, 5.1874812472E-01, 4.1434479211E-01, 8.2349924716E-01],
	[3.0180000000E+04, 5.9977887715E+00, 3.1351763220E+00, 5.1901199394E-01, 4.1452028296E-01, 8.2353521962E-01],
	[3.0185000000E+04, 5.9993829212E+00, 3.1351504590E+00, 5.1927595356E-01, 4.1469580568E-01, 8.2357118464E-01],
	[3.0190000000E+04, 6.0009772305E+00, 3.1351246004E+00, 5.1954000359E-01, 4.1487136025E-01, 8.2360714224E-01],
	[3.0195000000E+04, 6.0025716993E+00, 3.1350987464E+00, 5.1980414406E-01, 4.1504694666E-01, 8.2364309241E-01],
	[3.0200000000E+04, 6.0041663276E+00, 3.1350728968E+00, 5.2006837498E-01, 4.1522256491E-01, 8.2367903516E-01],
	[3.0205000000E+04, 6.0057611155E+00, 3.1350470517E+00, 5.2033269636E-01, 4.1539821498E-01, 8.2371497048E-01],
	[3.0210000000E+04, 6.0073560629E+00, 3.1350212111E+00, 5.2059710823E-01, 4.1557389686E-01, 8.2375089839E-01],
	[3.0215000000E+04, 6.0089511698E+00, 3.1349953750E+00, 5.2086161059E-01, 4.1574961055E-01, 8.2378681888E-01],
	[3.0220000000E+04, 6.0105464362E+00, 3.1349695434E+00, 5.2112620346E-01, 4.1592535602E-01, 8.2382273196E-01],
	[3.0225000000E+04, 6.0121418621E+00, 3.1349437163E+00, 5.2139088687E-01, 4.1610113328E-01, 8.2385863761E-01],
	[3.0230000000E+04, 6.0137374475E+00, 3.1349178937E+00, 5.2165566081E-01, 4.1627694230E-01, 8.2389453586E-01],
	[3.0235000000E+04, 6.0153331923E+00, 3.1348920755E+00, 5.2192052532E-01, 4.1645278309E-01, 8.2393042670E-01],
	[3.0240000000E+04, 6.0169290966E+00, 3.1348662619E+00, 5.2218548040E-01, 4.1662865562E-01, 8.2396631012E-01],
	[3.0245000000E+04, 6.0185251604E+00, 3.1348404527E+00, 5.2245052608E-01, 4.1680455989E-01, 8.2400218614E-01],
	[3.0250000000E+04, 6.0201213836E+00, 3.1348146480E+00, 5.2271566237E-01, 4.1698049589E-01, 8.2403805476E-01],
	[3.0255000000E+04, 6.0217177662E+00, 3.1347888477E+00, 5.2298088928E-01, 4.1715646361E-01, 8.2407391597E-01],
	[3.0260000000E+04, 6.0233143082E+00, 3.1347630520E+00, 5.2324620683E-01, 4.1733246303E-01, 8.2410976978E-01],
	[3.0265000000E+04, 6.0249110096E+00, 3.1347372607E+00, 5.2351161503E-01, 4.1750849415E-01, 8.2414561618E-01],
	[3.0270000000E+04, 6.0265078705E+00, 3.1347114739E+00, 5.2377711391E-01, 4.1768455696E-01, 8.2418145519E-01],
	[3.0275000000E+04, 6.0281048907E+00, 3.1346856915E+00, 5.2404270348E-01, 4.1786065144E-01, 8.2421728681E-01],
	[3.0280000000E+04, 6.0297020703E+00, 3.1346599137E+00, 5.2430838375E-01, 4.1803677759E-01, 8.2425311102E-01],
	[3.0285000000E+04, 6.0312994092E+00, 3.1346341403E+00, 5.2457415474E-01, 4.1821293539E-01, 8.2428892785E-01],
	[3.0290000000E+04, 6.0328969075E+00, 3.1346083713E+00, 5.2484001647E-01, 4.1838912483E-01, 8.2432473728E-01],
	[3.0295000000E+04, 6.0344945651E+00, 3.1345826069E+00, 5.2510596895E-01, 4.1856534590E-01, 8.2436053933E-01],
	[3.0300000000E+04, 6.0360923821E+00, 3.1345568469E+00, 5.2537201220E-01, 4.1874159860E-01, 8.2439633398E-01],
	[3.0305000000E+04, 6.0376903584E+00, 3.1345310913E+00, 5.2563814623E-01, 4.1891788291E-01, 8.2443212125E-01],
	[3.0310000000E+04, 6.0392884940E+00, 3.1345053402E+00, 5.2590437107E-01, 4.1909419883E-01, 8.2446790114E-01],
	[3.0315000000E+04, 6.0408867889E+00, 3.1344795936E+00, 5.2617068671E-01, 4.1927054633E-01, 8.2450367364E-01],
	[3.0320000000E+04, 6.0424852431E+00, 3.1344538514E+00, 5.2643709319E-01, 4.1944692541E-01, 8.2453943876E-01],
	[3.0325000000E+04, 6.0440838566E+00, 3.1344281137E+00, 5.2670359052E-01, 4.1962333606E-01, 8.2457519650E-01],
	[3.0330000000E+04, 6.0456826294E+00, 3.1344023805E+00, 5.2697017871E-01, 4.1979977827E-01, 8.2461094687E-01],
	[3.0335000000E+04, 6.0472815614E+00, 3.1343766517E+00, 5.2723685779E-01, 4.1997625203E-01, 8.2464668986E-01],
	[3.0340000000E+04, 6.0488806526E+00, 3.1343509273E+00, 5.2750362775E-01, 4.2015275733E-01, 8.2468242547E-01],
	[3.0345000000E+04, 6.0504799031E+00, 3.1343252074E+00, 5.2777048863E-01, 4.2032929415E-01, 8.2471815372E-01],
	[3.0350000000E+04, 6.0520793128E+00, 3.1342994920E+00, 5.2803744044E-01, 4.2050586249E-01, 8.2475387459E-01],
	[3.0355000000E+04, 6.0536788818E+00, 3.1342737809E+00, 5.2830448319E-01, 4.2068246234E-01, 8.2478958809E-01],
	[3.0360000000E+04, 6.0552786099E+00, 3.1342480744E+00, 5.2857161690E-01, 4.2085909368E-01, 8.2482529423E-01],
	[3.0365000000E+04, 6.0568784973E+00, 3.1342223723E+00, 5.2883884158E-01, 4.2103575651E-01, 8.2486099301E-01],
	[3.0370000000E+04, 6.0584785438E+00, 3.1341966746E+00, 5.2910615726E-01, 4.2121245081E-01, 8.2489668441E-01],
	[3.0375000000E+04, 6.0600787495E+00, 3.1341709814E+00, 5.2937356395E-01, 4.2138917657E-01, 8.2493236846E-01],
	[3.0380000000E+04, 6.0616791144E+00, 3.1341452926E+00, 5.2964106165E-01, 4.2156593379E-01, 8.2496804515E-01],
	[3.0385000000E+04, 6.0632796384E+00, 3.1341196082E+00, 5.2990865040E-01, 4.2174272244E-01, 8.2500371448E-01],
	[3.0390000000E+04, 6.0648804099E+00, 3.1340942640E+00, 5.3017633020E-01, 4.2191954905E-01, 8.2503937645E-01],
	[3.0395000000E+04, 6.0664817878E+00, 3.1340706227E+00, 5.3044410108E-01, 4.2209644005E-01, 8.2507503107E-01],
	[3.0400000000E+04, 6.0680833250E+00, 3.1340469855E+00, 5.3071196304E-01, 4.2227336253E-01, 8.2511067834E-01],
	[3.0405000000E+04, 6.0696850216E+00, 3.1340233524E+00, 5.3097991610E-01, 4.2245031646E-01, 8.2514631825E-01],
	[3.0410000000E+04, 6.0712868774E+00, 3.1339997234E+00, 5.3124796029E-01, 4.2262730185E-01, 8.2518195082E-01],
	[3.0415000000E+04, 6.0728888925E+00, 3.1339760984E+00, 5.3151609560E-01, 4.2280431867E-01, 8.2521757604E-01],
	[3.0420000000E+04, 6.0744910669E+00, 3.1339524775E+00, 5.3178432207E-01, 4.2298136691E-01, 8.2525319391E-01],
	[3.0425000000E+04, 6.0760934005E+00, 3.1339288606E+00, 5.3205263971E-01, 4.2315844657E-01, 8.2528880444E-01],
	[3.0430000000E+04, 6.0776958934E+00, 3.1339052478E+00, 5.3232104853E-01, 4.2333555764E-01, 8.2532440762E-01],
	[3.0435000000E+04, 6.0792985456E+00, 3.1338816391E+00, 5.3258954855E-01, 4.2351270010E-01, 8.2536000347E-01],
	[3.0440000000E+04, 6.0809013570E+00, 3.1338580344E+00, 5.3285813978E-01, 4.2368987395E-01, 8.2539559198E-01],
	[3.0445000000E+04, 6.0825043276E+00, 3.1338344337E+00, 5.3312682225E-01, 4.2386707917E-01, 8.2543117315E-01],
	[3.0450000000E+04, 6.0841074574E+00, 3.1338108371E+00, 5.3339559596E-01, 4.2404431575E-01, 8.2546674698E-01],
	[3.0455000000E+04, 6.0857107465E+00, 3.1337872446E+00, 5.3366446093E-01, 4.2422158369E-01, 8.2550231348E-01],
	[3.0460000000E+04, 6.0873141947E+00, 3.1337636561E+00, 5.3393341718E-01, 4.2439888297E-01, 8.2553787265E-01],
	[3.0465000000E+04, 6.0889178021E+00, 3.1337400717E+00, 5.3420246473E-01, 4.2457621357E-01, 8.2557342449E-01],
	[3.0470000000E+04, 6.0905215687E+00, 3.1337164913E+00, 5.3447160359E-01, 4.2475357550E-01, 8.2560896900E-01],
	[3.0475000000E+04, 6.0921254945E+00, 3.1336929150E+00, 5.3474083378E-01, 4.2493096874E-01, 8.2564450618E-01],
	[3.0480000000E+04, 6.0937295794E+00, 3.1336693427E+00, 5.3501015530E-01, 4.2510839327E-01, 8.2568003604E-01],
	[3.0485000000E+04, 6.0953338234E+00, 3.1336457744E+00, 5.3527956819E-01, 4.2528584910E-01, 8.2571555858E-01],
	[3.0490000000E+04, 6.0969382266E+00, 3.1336222102E+00, 5.3554907245E-01, 4.2546333620E-01, 8.2575107379E-01],
	[3.0495000000E+04, 6.0985427889E+00, 3.1335986501E+00, 5.3581866810E-01, 4.2564085457E-01, 8.2578658169E-01],
	[3.0500000000E+04, 6.1001475103E+00, 3.1335750939E+00, 5.3608835516E-01, 4.2581840419E-01, 8.2582208226E-01],
	[3.0505000000E+04, 6.1017523909E+00, 3.1335515419E+00, 5.3635813364E-01, 4.2599598506E-01, 8.2585757553E-01],
	[3.0510000000E+04, 6.1033574305E+00, 3.1335279938E+00, 5.3662800356E-01, 4.2617359716E-01, 8.2589306147E-01],
	[3.0515000000E+04, 6.1049626292E+00, 3.1335044498E+00, 5.3689796493E-01, 4.2635124049E-01, 8.2592854011E-01],
	[3.0520000000E+04, 6.1065679869E+00, 3.1334809098E+00, 5.3716801777E-01, 4.2652891503E-01, 8.2596401143E-01],
	[3.0525000000E+04, 6.1081735038E+00, 3.1334573739E+00, 5.3743816210E-01, 4.2670662078E-01, 8.2599947544E-01],
	[3.0530000000E+04, 6.1097791796E+00, 3.1334338419E+00, 5.3770839793E-01, 4.2688435771E-01, 8.2603493215E-01],
	[3.0535000000E+04, 6.1113850146E+00, 3.1334103141E+00, 5.3797872528E-01, 4.2706212583E-01, 8.2607038155E-01],
	[3.0540000000E+04, 6.1129910085E+00, 3.1333867902E+00, 5.3824914417E-01, 4.2723992512E-01, 8.2610582365E-01],
	[3.0545000000E+04, 6.1145971615E+00, 3.1333632704E+00, 5.3851965460E-01, 4.2741775557E-01, 8.2614125844E-01],
	[3.0550000000E+04, 6.1162034735E+00, 3.1333397546E+00, 5.3879025660E-01, 4.2759561716E-01, 8.2617668594E-01],
	[3.0555000000E+04, 6.1178099444E+00, 3.1333162428E+00, 5.3906095019E-01, 4.2777350990E-01, 8.2621210613E-01],
	[3.0560000000E+04, 6.1194165744E+00, 3.1332927350E+00, 5.3933173537E-01, 4.2795143376E-01, 8.2624751903E-01],
	[3.0565000000E+04, 6.1210233633E+00, 3.1332692313E+00, 5.3960261216E-01, 4.2812938874E-01, 8.2628292463E-01],
	[3.0570000000E+04, 6.1226303113E+00, 3.1332457316E+00, 5.3987358059E-01, 4.2830737482E-01, 8.2631832294E-01],
	[3.0575000000E+04, 6.1242374181E+00, 3.1332222359E+00, 5.4014464066E-01, 4.2848539200E-01, 8.2635371396E-01],
	[3.0580000000E+04, 6.1258446839E+00, 3.1331987442E+00, 5.4041579239E-01, 4.2866344027E-01, 8.2638909769E-01],
	[3.0585000000E+04, 6.1274521087E+00, 3.1331752566E+00, 5.4068703580E-01, 4.2884151961E-01, 8.2642447413E-01],
	[3.0590000000E+04, 6.1290596924E+00, 3.1331517729E+00, 5.4095837090E-01, 4.2901963001E-01, 8.2645984328E-01],
	[3.0595000000E+04, 6.1306674350E+00, 3.1331282933E+00, 5.4122979772E-01, 4.2919777146E-01, 8.2649520515E-01],
	[3.0600000000E+04, 6.1322753365E+00, 3.1331048177E+00, 5.4150131626E-01, 4.2937594396E-01, 8.2653055973E-01],
	[3.0605000000E+04, 6.1338833969E+00, 3.1330813461E+00, 5.4177292654E-01, 4.2955414749E-01, 8.2656590704E-01],
	[3.0610000000E+04, 6.1354916162E+00, 3.1330578785E+00, 5.4204462858E-01, 4.2973238203E-01, 8.2660124706E-01],
	[3.0615000000E+04, 6.1370999944E+00, 3.1330344149E+00, 5.4231642239E-01, 4.2991064759E-01, 8.2663657981E-01],
	[3.0620000000E+04, 6.1387085314E+00, 3.1330109553E+00, 5.4258830799E-01, 4.3008894414E-01, 8.2667190528E-01],
	[3.0625000000E+04, 6.1403172273E+00, 3.1329874998E+00, 5.4286028540E-01, 4.3026727168E-01, 8.2670722347E-01],
	[3.0630000000E+04, 6.1419260820E+00, 3.1329640482E+00, 5.4313235463E-01, 4.3044563020E-01, 8.2674253440E-01],
	[3.0635000000E+04, 6.1435350956E+00, 3.1329406006E+00, 5.4340451570E-01, 4.3062401969E-01, 8.2677783805E-01],
	[3.0640000000E+04, 6.1451442680E+00, 3.1329171571E+00, 5.4367676862E-01, 4.3080244013E-01, 8.2681313443E-01],
	[3.0645000000E+04, 6.1467535992E+00, 3.1328937175E+00, 5.4394911341E-01, 4.3098089151E-01, 8.2684842355E-01],
	[3.0650000000E+04, 6.1483630892E+00, 3.1328702820E+00, 5.4422155008E-01, 4.3115937383E-01, 8.2688370540E-01],
	[3.0655000000E+04, 6.1499727380E+00, 3.1328468504E+00, 5.4449407866E-01, 4.3133788707E-01, 8.2691897998E-01],
	[3.0660000000E+04, 6.1515825456E+00, 3.1328234228E+00, 5.4476669915E-01, 4.3151643122E-01, 8.2695424731E-01],
	[3.0665000000E+04, 6.1531925119E+00, 3.1327999993E+00, 5.4503941158E-01, 4.3169500627E-01, 8.2698950737E-01],
	[3.0670000000E+04, 6.1548026371E+00, 3.1327765797E+00, 5.4531221596E-01, 4.3187361222E-01, 8.2702476017E-01],
	[3.0675000000E+04, 6.1564129209E+00, 3.1327531641E+00, 5.4558511230E-01, 4.3205224904E-01, 8.2706000572E-01],
	[3.0680000000E+04, 6.1580233636E+00, 3.1327297525E+00, 5.4585810063E-01, 4.3223091673E-01, 8.2709524401E-01],
	[3.0685000000E+04, 6.1596339649E+00, 3.1327063449E+00, 5.4613118095E-01, 4.3240961528E-01, 8.2713047505E-01],
	[3.0690000000E+04, 6.1612447250E+00, 3.1326829413E+00, 5.4640435328E-01, 4.3258834468E-01, 8.2716569883E-01],
	[3.0695000000E+04, 6.1628556438E+00, 3.1326595417E+00, 5.4667761764E-01, 4.3276710491E-01, 8.2720091537E-01],
	[3.0700000000E+04, 6.1644667213E+00, 3.1326361460E+00, 5.4695097405E-01, 4.3294589597E-01, 8.2723612466E-01],
	[3.0705000000E+04, 6.1660779574E+00, 3.1326127544E+00, 5.4722442252E-01, 4.3312471785E-01, 8.2727132670E-01],
	[3.0710000000E+04, 6.1676893523E+00, 3.1325893667E+00, 5.4749796307E-01, 4.3330357052E-01, 8.2730652149E-01],
	[3.0715000000E+04, 6.1693009058E+00, 3.1325659830E+00, 5.4777159571E-01, 4.3348245399E-01, 8.2734170904E-01],
	[3.0720000000E+04, 6.1709126180E+00, 3.1325426033E+00, 5.4804532046E-01, 4.3366136824E-01, 8.2737688935E-01],
	[3.0725000000E+04, 6.1725244889E+00, 3.1325192276E+00, 5.4831913733E-01, 4.3384031327E-01, 8.2741206242E-01],
	[3.0730000000E+04, 6.1741365184E+00, 3.1324958558E+00, 5.4859304634E-01, 4.3401928905E-01, 8.2744722826E-01],
	[3.0735000000E+04, 6.1757487065E+00, 3.1324724880E+00, 5.4886704751E-01, 4.3419829558E-01, 8.2748238685E-01],
	[3.0740000000E+04, 6.1773610532E+00, 3.1324491242E+00, 5.4914114086E-01, 4.3437733285E-01, 8.2751753821E-01],
	[3.0745000000E+04, 6.1789735586E+00, 3.1324257644E+00, 5.4941532639E-01, 4.3455640085E-01, 8.2755268234E-01],
	[3.0750000000E+04, 6.1805862225E+00, 3.1324024086E+00, 5.4968960413E-01, 4.3473549956E-01, 8.2758781924E-01],
	[3.0755000000E+04, 6.1821990450E+00, 3.1323790567E+00, 5.4996397409E-01, 4.3491462899E-01, 8.2762294891E-01],
	[3.0760000000E+04, 6.1838120262E+00, 3.1323557088E+00, 5.5023843628E-01, 4.3509378910E-01, 8.2765807135E-01],
	[3.0765000000E+04, 6.1854251658E+00, 3.1323323648E+00, 5.5051299073E-01, 4.3527297990E-01, 8.2769318656E-01],
	[3.0770000000E+04, 6.1870384641E+00, 3.1323090249E+00, 5.5078763745E-01, 4.3545220137E-01, 8.2772829455E-01],
	[3.0775000000E+04, 6.1886519209E+00, 3.1322856889E+00, 5.5106237645E-01, 4.3563145351E-01, 8.2776339532E-01],
	[3.0780000000E+04, 6.1902655362E+00, 3.1322623568E+00, 5.5133720775E-01, 4.3581073629E-01, 8.2779848886E-01],
	[3.0785000000E+04, 6.1918793101E+00, 3.1322390287E+00, 5.5161213137E-01, 4.3599004972E-01, 8.2783357519E-01],
	[3.0790000000E+04, 6.1934932424E+00, 3.1322157046E+00, 5.5188714732E-01, 4.3616939378E-01, 8.2786865430E-01],
	[3.0795000000E+04, 6.1951073333E+00, 3.1321923845E+00, 5.5216225562E-01, 4.3634876845E-01, 8.2790372619E-01],
	[3.0800000000E+04, 6.1967215827E+00, 3.1321690683E+00, 5.5243745629E-01, 4.3652817373E-01, 8.2793879087E-01],
	[3.0805000000E+04, 6.1983359906E+00, 3.1321457560E+00, 5.5271274933E-01, 4.3670760961E-01, 8.2797384834E-01],
	[3.0810000000E+04, 6.1999505569E+00, 3.1321224477E+00, 5.5298813478E-01, 4.3688707607E-01, 8.2800889860E-01],
	[3.0815000000E+04, 6.2015652817E+00, 3.1320991434E+00, 5.5326361263E-01, 4.3706657311E-01, 8.2804394165E-01],
	[3.0820000000E+04, 6.2031801650E+00, 3.1320758430E+00, 5.5353918291E-01, 4.3724610072E-01, 8.2807897749E-01],
	[3.0825000000E+04, 6.2047952067E+00, 3.1320525466E+00, 5.5381484564E-01, 4.3742565887E-01, 8.2811400612E-01],
	[3.0830000000E+04, 6.2064104069E+00, 3.1320292542E+00, 5.5409060083E-01, 4.3760524757E-01, 8.2814902756E-01],
	[3.0835000000E+04, 6.2080257655E+00, 3.1320059656E+00, 5.5436644849E-01, 4.3778486680E-01, 8.2818404179E-01],
	[3.0840000000E+04, 6.2096412825E+00, 3.1319826811E+00, 5.5464238865E-01, 4.3796451655E-01, 8.2821904881E-01],
	[3.0845000000E+04, 6.2112569579E+00, 3.1319594005E+00, 5.5491842131E-01, 4.3814419681E-01, 8.2825404865E-01],
	[3.0850000000E+04, 6.2128727917E+00, 3.1319361238E+00, 5.5519454650E-01, 4.3832390756E-01, 8.2828904128E-01],
	[3.0855000000E+04, 6.2144887839E+00, 3.1319128511E+00, 5.5547076423E-01, 4.3850364881E-01, 8.2832402672E-01],
	[3.0860000000E+04, 6.2161049345E+00, 3.1318895823E+00, 5.5574707451E-01, 4.3868342053E-01, 8.2835900496E-01],
	[3.0865000000E+04, 6.2177212434E+00, 3.1318663174E+00, 5.5602347737E-01, 4.3886322271E-01, 8.2839397602E-01],
	[3.0870000000E+04, 6.2193377107E+00, 3.1318430565E+00, 5.5629997282E-01, 4.3904305535E-01, 8.2842893988E-01],
	[3.0875000000E+04, 6.2209543363E+00, 3.1318197996E+00, 5.5657656087E-01, 4.3922291843E-01, 8.2846389656E-01],
	[3.0880000000E+04, 6.2225714252E+00, 3.1317971846E+00, 5.5685324154E-01, 4.3940282603E-01, 8.2849884605E-01],
	[3.0885000000E+04, 6.2241893202E+00, 3.1317759286E+00, 5.5713001484E-01, 4.3958279400E-01, 8.2853378835E-01],
	[3.0890000000E+04, 6.2258073738E+00, 3.1317546761E+00, 5.5740688080E-01, 4.3976279243E-01, 8.2856872347E-01],
	[3.0895000000E+04, 6.2274255861E+00, 3.1317334272E+00, 5.5768383943E-01, 4.3994282133E-01, 8.2860365141E-01],
	[3.0900000000E+04, 6.2290439570E+00, 3.1317121819E+00, 5.5796089074E-01, 4.4012288069E-01, 8.2863857217E-01],
	[3.0905000000E+04, 6.2306624865E+00, 3.1316909401E+00, 5.5823803475E-01, 4.4030297048E-01, 8.2867348575E-01],
	[3.0910000000E+04, 6.2322811747E+00, 3.1316697020E+00, 5.5851527147E-01, 4.4048309070E-01, 8.2870839216E-01],
	[3.0915000000E+04, 6.2339000214E+00, 3.1316484674E+00, 5.5879260093E-01, 4.4066324134E-01, 8.2874329139E-01],
	[3.0920000000E+04, 6.2355190268E+00, 3.1316272364E+00, 5.5907002314E-01, 4.4084342239E-01, 8.2877818345E-01],
	[3.0925000000E+04, 6.2371381907E+00, 3.1316060090E+00, 5.5934753811E-01, 4.4102363384E-01, 8.2881306834E-01],
	[3.0930000000E+04, 6.2387575132E+00, 3.1315847851E+00, 5.5962514586E-01, 4.4120387567E-01, 8.2884794605E-01],
	[3.0935000000E+04, 6.2403769943E+00, 3.1315635648E+00, 5.5990284640E-01, 4.4138414787E-01, 8.2888281660E-01],
	[3.0940000000E+04, 6.2419966339E+00, 3.1315423481E+00, 5.6018063976E-01, 4.4156445044E-01, 8.2891767999E-01],
	[3.0945000000E+04, 6.2436164321E+00, 3.1315211350E+00, 5.6045852595E-01, 4.4174478336E-01, 8.2895253621E-01],
	[3.0950000000E+04, 6.2452363888E+00, 3.1314999254E+00, 5.6073650498E-01, 4.4192514663E-01, 8.2898738526E-01],
	[3.0955000000E+04, 6.2468565041E+00, 3.1314787195E+00, 5.6101457687E-01, 4.4210554022E-01, 8.2902222716E-01],
	[3.0960000000E+04, 6.2484767778E+00, 3.1314575170E+00, 5.6129274163E-01, 4.4228596414E-01, 8.2905706190E-01],
	[3.0965000000E+04, 6.2500972101E+00, 3.1314363182E+00, 5.6157099929E-01, 4.4246641836E-01, 8.2909188948E-01],
	[3.0970000000E+04, 6.2517178008E+00, 3.1314151229E+00, 5.6184934985E-01, 4.4264690288E-01, 8.2912670990E-01],
	[3.0975000000E+04, 6.2533385501E+00, 3.1313939312E+00, 5.6212779334E-01, 4.4282741769E-01, 8.2916152317E-01],
	[3.0980000000E+04, 6.2549594578E+00, 3.1313727430E+00, 5.6240632977E-01, 4.4300796277E-01, 8.2919632929E-01],
	[3.0985000000E+04, 6.2565805240E+00, 3.1313515584E+00, 5.6268495915E-01, 4.4318853812E-01, 8.2923112825E-01],
	[3.0990000000E+04, 6.2582017486E+00, 3.1313303774E+00, 5.6296368150E-01, 4.4336914372E-01, 8.2926592007E-01],
	[3.0995000000E+04, 6.2598231317E+00, 3.1313091999E+00, 5.6324249685E-01, 4.4354977957E-01, 8.2930070474E-01],
	[3.1000000000E+04, 6.2614446732E+00, 3.1312880260E+00, 5.6352140519E-01, 4.4373044564E-01, 8.2933548227E-01],
	[3.1005000000E+04, 6.2630663731E+00, 3.1312668556E+00, 5.6380040656E-01, 4.4391114194E-01, 8.2937025265E-01],
	[3.1010000000E+04, 6.2646882314E+00, 3.1312456888E+00, 5.6407950096E-01, 4.4409186845E-01, 8.2940501589E-01],
	[3.1015000000E+04, 6.2663102482E+00, 3.1312245256E+00, 5.6435868841E-01, 4.4427262515E-01, 8.2943977198E-01],
	[3.1020000000E+04, 6.2679324233E+00, 3.1312033659E+00, 5.6463796893E-01, 4.4445341204E-01, 8.2947452094E-01],
	[3.1025000000E+04, 6.2695547569E+00, 3.1311822098E+00, 5.6491734254E-01, 4.4463422911E-01, 8.2950926277E-01],
	[3.1030000000E+04, 6.2711772488E+00, 3.1311610572E+00, 5.6519680924E-01, 4.4481507635E-01, 8.2954399745E-01],
	[3.1035000000E+04, 6.2727998990E+00, 3.1311399082E+00, 5.6547636906E-01, 4.4499595373E-01, 8.2957872501E-01],
	[3.1040000000E+04, 6.2744227076E+00, 3.1311187627E+00, 5.6575602201E-01, 4.4517686127E-01, 8.2961344543E-01],
	[3.1045000000E+04, 6.2760456746E+00, 3.1310976208E+00, 5.6603576811E-01, 4.4535779893E-01, 8.2964815872E-01],
	[3.1050000000E+04, 6.2776687999E+00, 3.1310764824E+00, 5.6631560737E-01, 4.4553876672E-01, 8.2968286488E-01],
	[3.1055000000E+04, 6.2792920835E+00, 3.1310553475E+00, 5.6659553981E-01, 4.4571976461E-01, 8.2971756392E-01],
	[3.1060000000E+04, 6.2809155254E+00, 3.1310342162E+00, 5.6687556544E-01, 4.4590079261E-01, 8.2975225583E-01],
	[3.1065000000E+04, 6.2825391257E+00, 3.1310130885E+00, 5.6715568429E-01, 4.4608185069E-01, 8.2978694061E-01],
	[3.1070000000E+04, 6.2841628842E+00, 3.1309919643E+00, 5.6743589636E-01, 4.4626293885E-01, 8.2982161828E-01],
	[3.1075000000E+04, 6.2857868010E+00, 3.1309708436E+00, 5.6771620168E-01, 4.4644405707E-01, 8.2985628882E-01],
	[3.1080000000E+04, 6.2874108761E+00, 3.1309497265E+00, 5.6799660026E-01, 4.4662520535E-01, 8.2989095225E-01],
	[3.1085000000E+04, 6.2890351094E+00, 3.1309286129E+00, 5.6827709211E-01, 4.4680638367E-01, 8.2992560856E-01],
	[3.1090000000E+04, 6.2906595010E+00, 3.1309075028E+00, 5.6855767725E-01, 4.4698759203E-01, 8.2996025776E-01],
	[3.1095000000E+04, 6.2922840509E+00, 3.1308863963E+00, 5.6883835570E-01, 4.4716883041E-01, 8.2999489984E-01],
	[3.1100000000E+04, 6.2939087589E+00, 3.1308652934E+00, 5.6911912748E-01, 4.4735009879E-01, 8.3002953481E-01],
	[3.1105000000E+04, 6.2955336252E+00, 3.1308441939E+00, 5.6939999259E-01, 4.4753139718E-01, 8.3006416267E-01],
	[3.1110000000E+04, 6.2971586497E+00, 3.1308230980E+00, 5.6968095106E-01, 4.4771272555E-01, 8.3009878342E-01],
	[3.1115000000E+04, 6.2987838324E+00, 3.1308020056E+00, 5.6996200290E-01, 4.4789408391E-01, 8.3013339707E-01],
	[3.1120000000E+04, 6.3004091734E+00, 3.1307809168E+00, 5.7024314812E-01, 4.4807547222E-01, 8.3016800361E-01],
	[3.1125000000E+04, 6.3020346724E+00, 3.1307598315E+00, 5.7052438675E-01, 4.4825689050E-01, 8.3020260305E-01],
	[3.1130000000E+04, 6.3036603297E+00, 3.1307387497E+00, 5.7080571880E-01, 4.4843833871E-01, 8.3023719538E-01],
	[3.1135000000E+04, 6.3052861451E+00, 3.1307176714E+00, 5.7108714428E-01, 4.4861981686E-01, 8.3027178062E-01],
	[3.1140000000E+04, 6.3069121187E+00, 3.1306965967E+00, 5.7136866322E-01, 4.4880132493E-01, 8.3030635876E-01],
	[3.1145000000E+04, 6.3085382504E+00, 3.1306755255E+00, 5.7165027562E-01, 4.4898286291E-01, 8.3034092980E-01],
	[3.1150000000E+04, 6.3101645403E+00, 3.1306544578E+00, 5.7193198150E-01, 4.4916443079E-01, 8.3037549375E-01],
	[3.1155000000E+04, 6.3117909882E+00, 3.1306333937E+00, 5.7221378089E-01, 4.4934602855E-01, 8.3041005060E-01],
	[3.1160000000E+04, 6.3134175943E+00, 3.1306123330E+00, 5.7249567379E-01, 4.4952765620E-01, 8.3044460037E-01],
	[3.1165000000E+04, 6.3150443585E+00, 3.1305912759E+00, 5.7277766022E-01, 4.4970931371E-01, 8.3047914304E-01],
	[3.1170000000E+04, 6.3166712808E+00, 3.1305702223E+00, 5.7305974019E-01, 4.4989100107E-01, 8.3051367863E-01],
	[3.1175000000E+04, 6.3182983611E+00, 3.1305491723E+00, 5.7334191373E-01, 4.5007271828E-01, 8.3054820713E-01],
	[3.1180000000E+04, 6.3199255996E+00, 3.1305281257E+00, 5.7362418085E-01, 4.5025446532E-01, 8.3058272854E-01],
	[3.1185000000E+04, 6.3215529961E+00, 3.1305070827E+00, 5.7390654156E-01, 4.5043624218E-01, 8.3061724287E-01],
	[3.1190000000E+04, 6.3231805506E+00, 3.1304860431E+00, 5.7418899589E-01, 4.5061804885E-01, 8.3065175013E-01],
	[3.1195000000E+04, 6.3248082632E+00, 3.1304650071E+00, 5.7447154384E-01, 4.5079988531E-01, 8.3068625030E-01],
	[3.1200000000E+04, 6.3264361338E+00, 3.1304439746E+00, 5.7475418543E-01, 4.5098175157E-01, 8.3072074339E-01],
	[3.1205000000E+04, 6.3280641625E+00, 3.1304229456E+00, 5.7503692069E-01, 4.5116364760E-01, 8.3075522941E-01],
	[3.1210000000E+04, 6.3296923491E+00, 3.1304019201E+00, 5.7531974961E-01, 4.5134557340E-01, 8.3078970835E-01],
	[3.1215000000E+04, 6.3313206938E+00, 3.1303808982E+00, 5.7560267223E-01, 4.5152752895E-01, 8.3082418022E-01],
	[3.1220000000E+04, 6.3329491965E+00, 3.1303598797E+00, 5.7588568856E-01, 4.5170951424E-01, 8.3085864502E-01],
	[3.1225000000E+04, 6.3345778571E+00, 3.1303388648E+00, 5.7616879861E-01, 4.5189152927E-01, 8.3089310275E-01],
	[3.1230000000E+04, 6.3362066757E+00, 3.1303178533E+00, 5.7645200239E-01, 4.5207357402E-01, 8.3092755342E-01],
	[3.1235000000E+04, 6.3378356523E+00, 3.1302968454E+00, 5.7673529993E-01, 4.5225564847E-01, 8.3096199701E-01],
	[3.1240000000E+04, 6.3394647868E+00, 3.1302758409E+00, 5.7701869125E-01, 4.5243775262E-01, 8.3099643355E-01],
	[3.1245000000E+04, 6.3410940793E+00, 3.1302548400E+00, 5.7730217635E-01, 4.5261988646E-01, 8.3103086302E-01],
	[3.1250000000E+04, 6.3427235297E+00, 3.1302338425E+00, 5.7758575525E-01, 4.5280204998E-01, 8.3106528543E-01],
	[3.1255000000E+04, 6.3443531380E+00, 3.1302128486E+00, 5.7786942797E-01, 4.5298424316E-01, 8.3109970078E-01],
	[3.1260000000E+04, 6.3459829043E+00, 3.1301918582E+00, 5.7815319452E-01, 4.5316646599E-01, 8.3113410907E-01],
	[3.1265000000E+04, 6.3476128284E+00, 3.1301708712E+00, 5.7843705493E-01, 4.5334871847E-01, 8.3116851031E-01],
	[3.1270000000E+04, 6.3492429104E+00, 3.1301498878E+00, 5.7872100920E-01, 4.5353100057E-01, 8.3120290449E-01],
	[3.1275000000E+04, 6.3508731503E+00, 3.1301289078E+00, 5.7900505736E-01, 4.5371331230E-01, 8.3123729162E-01],
	[3.1280000000E+04, 6.3525035481E+00, 3.1301079314E+00, 5.7928919941E-01, 4.5389565363E-01, 8.3127167170E-01],
	[3.1285000000E+04, 6.3541341038E+00, 3.1300869584E+00, 5.7957343538E-01, 4.5407802456E-01, 8.3130604473E-01],
	[3.1290000000E+04, 6.3557648173E+00, 3.1300659890E+00, 5.7985776528E-01, 4.5426042508E-01, 8.3134041071E-01],
	[3.1295000000E+04, 6.3573956886E+00, 3.1300450230E+00, 5.8014218912E-01, 4.5444285517E-01, 8.3137476965E-01],
	[3.1300000000E+04, 6.3590267178E+00, 3.1300240605E+00, 5.8042670693E-01, 4.5462531482E-01, 8.3140912154E-01],
	[3.1305000000E+04, 6.3606579048E+00, 3.1300031015E+00, 5.8071131872E-01, 4.5480780403E-01, 8.3144346639E-01],
	[3.1310000000E+04, 6.3622892497E+00, 3.1299821460E+00, 5.8099602450E-01, 4.5499032277E-01, 8.3147780420E-01],
	[3.1315000000E+04, 6.3639207523E+00, 3.1299611940E+00, 5.8128082429E-01, 4.5517287105E-01, 8.3151213497E-01],
	[3.1320000000E+04, 6.3655524127E+00, 3.1299402454E+00, 5.8156571811E-01, 4.5535544884E-01, 8.3154645870E-01],
	[3.1325000000E+04, 6.3671842309E+00, 3.1299193004E+00, 5.8185070597E-01, 4.5553805614E-01, 8.3158077540E-01],
	[3.1330000000E+04, 6.3688162069E+00, 3.1298983588E+00, 5.8213578789E-01, 4.5572069294E-01, 8.3161508506E-01],
	[3.1335000000E+04, 6.3704483406E+00, 3.1298774207E+00, 5.8242096389E-01, 4.5590335922E-01, 8.3164938769E-01],
	[3.1340000000E+04, 6.3720806321E+00, 3.1298564861E+00, 5.8270623397E-01, 4.5608605497E-01, 8.3168368329E-01],
	[3.1345000000E+04, 6.3737130813E+00, 3.1298355550E+00, 5.8299159816E-01, 4.5626878019E-01, 8.3171797186E-01],
	[3.1350000000E+04, 6.3753456883E+00, 3.1298146273E+00, 5.8327705648E-01, 4.5645153486E-01, 8.3175225341E-01],
	[3.1355000000E+04, 6.3769784530E+00, 3.1297937032E+00, 5.8356260893E-01, 4.5663431896E-01, 8.3178652793E-01],
	[3.1360000000E+04, 6.3786113754E+00, 3.1297727825E+00, 5.8384825554E-01, 4.5681713250E-01, 8.3182079542E-01],
	[3.1365000000E+04, 6.3802444555E+00, 3.1297518652E+00, 5.8413399631E-01, 4.5699997545E-01, 8.3185505589E-01],
	[3.1370000000E+04, 6.3818776933E+00, 3.1297309515E+00, 5.8441983128E-01, 4.5718284780E-01, 8.3188930934E-01],
	[3.1375000000E+04, 6.3835110888E+00, 3.1297100412E+00, 5.8470576044E-01, 4.5736574955E-01, 8.3192355578E-01],
	[3.1380000000E+04, 6.3851458831E+00, 3.1296908922E+00, 5.8499178383E-01, 4.5754872463E-01, 8.3195779519E-01],
	[3.1385000000E+04, 6.3867809733E+00, 3.1296719414E+00, 5.8527790145E-01, 4.5773173402E-01, 8.3199202759E-01],
	[3.1390000000E+04, 6.3884162216E+00, 3.1296529938E+00, 5.8556411332E-01, 4.5791477284E-01, 8.3202625298E-01],
	[3.1395000000E+04, 6.3900516281E+00, 3.1296340493E+00, 5.8585041945E-01, 4.5809784107E-01, 8.3206047135E-01],
	[3.1400000000E+04, 6.3916871927E+00, 3.1296151079E+00, 5.8613681987E-01, 4.5828093871E-01, 8.3209468271E-01],
	[3.1405000000E+04, 6.3933229153E+00, 3.1295961697E+00, 5.8642331459E-01, 4.5846406574E-01, 8.3212888707E-01],
	[3.1410000000E+04, 6.3949587961E+00, 3.1295772346E+00, 5.8670990362E-01, 4.5864722215E-01, 8.3216308441E-01],
	[3.1415000000E+04, 6.3965948350E+00, 3.1295583026E+00, 5.8699658698E-01, 4.5883040793E-01, 8.3219727475E-01],
	[3.1420000000E+04, 6.3982310320E+00, 3.1295393738E+00, 5.8728336469E-01, 4.5901362308E-01, 8.3223145809E-01],
	[3.1425000000E+04, 6.3998673870E+00, 3.1295204480E+00, 5.8757023676E-01, 4.5919686757E-01, 8.3226563443E-01],
	[3.1430000000E+04, 6.4015039001E+00, 3.1295015254E+00, 5.8785720321E-01, 4.5938014140E-01, 8.3229980376E-01],
	[3.1435000000E+04, 6.4031405712E+00, 3.1294826060E+00, 5.8814426405E-01, 4.5956344456E-01, 8.3233396610E-01],
	[3.1440000000E+04, 6.4047774004E+00, 3.1294636896E+00, 5.8843141930E-01, 4.5974677703E-01, 8.3236812143E-01],
	[3.1445000000E+04, 6.4064143877E+00, 3.1294447764E+00, 5.8871866898E-01, 4.5993013880E-01, 8.3240226978E-01],
	[3.1450000000E+04, 6.4080515329E+00, 3.1294258663E+00, 5.8900601311E-01, 4.6011352987E-01, 8.3243641112E-01],
	[3.1455000000E+04, 6.4096888362E+00, 3.1294069593E+00, 5.8929345169E-01, 4.6029695022E-01, 8.3247054548E-01],
	[3.1460000000E+04, 6.4113262974E+00, 3.1293880554E+00, 5.8958098474E-01, 4.6048039984E-01, 8.3250467285E-01],
	[3.1465000000E+04, 6.4129639167E+00, 3.1293691547E+00, 5.8986861228E-01, 4.6066387871E-01, 8.3253879322E-01],
	[3.1470000000E+04, 6.4146016939E+00, 3.1293502570E+00, 5.9015633434E-01, 4.6084738683E-01, 8.3257290661E-01],
	[3.1475000000E+04, 6.4162396291E+00, 3.1293313625E+00, 5.9044415091E-01, 4.6103092419E-01, 8.3260701302E-01],
	[3.1480000000E+04, 6.4178777223E+00, 3.1293124711E+00, 5.9073206202E-01, 4.6121449077E-01, 8.3264111244E-01],
	[3.1485000000E+04, 6.4195159734E+00, 3.1292935828E+00, 5.9102006769E-01, 4.6139808657E-01, 8.3267520488E-01],
	[3.1490000000E+04, 6.4211543825E+00, 3.1292746977E+00, 5.9130816792E-01, 4.6158171156E-01, 8.3270929033E-01],
	[3.1495000000E+04, 6.4227929495E+00, 3.1292558156E+00, 5.9159636275E-01, 4.6176536575E-01, 8.3274336881E-01],
	[3.1500000000E+04, 6.4244316744E+00, 3.1292369367E+00, 5.9188465217E-01, 4.6194904911E-01, 8.3277744031E-01],
	[3.1505000000E+04, 6.4260705572E+00, 3.1292180608E+00, 5.9217303621E-01, 4.6213276164E-01, 8.3281150484E-01],
	[3.1510000000E+04, 6.4277095980E+00, 3.1291991881E+00, 5.9246151489E-01, 4.6231650333E-01, 8.3284556239E-01],
	[3.1515000000E+04, 6.4293487966E+00, 3.1291803185E+00, 5.9275008822E-01, 4.6250027417E-01, 8.3287961297E-01],
	[3.1520000000E+04, 6.4309881531E+00, 3.1291614520E+00, 5.9303875621E-01, 4.6268407413E-01, 8.3291365658E-01],
	[3.1525000000E+04, 6.4326276675E+00, 3.1291425886E+00, 5.9332751889E-01, 4.6286790322E-01, 8.3294769322E-01],
	[3.1530000000E+04, 6.4342673398E+00, 3.1291237283E+00, 5.9361637626E-01, 4.6305176142E-01, 8.3298172289E-01],
	[3.1535000000E+04, 6.4359071699E+00, 3.1291048711E+00, 5.9390532835E-01, 4.6323564872E-01, 8.3301574560E-01],
	[3.1540000000E+04, 6.4375471578E+00, 3.1290860170E+00, 5.9419437517E-01, 4.6341956511E-01, 8.3304976134E-01],
	[3.1545000000E+04, 6.4391873036E+00, 3.1290671660E+00, 5.9448351673E-01, 4.6360351057E-01, 8.3308377012E-01],
	[3.1550000000E+04, 6.4408276072E+00, 3.1290483181E+00, 5.9477275306E-01, 4.6378748510E-01, 8.3311777194E-01],
	[3.1555000000E+04, 6.4424680687E+00, 3.1290294733E+00, 5.9506208417E-01, 4.6397148868E-01, 8.3315176680E-01],
	[3.1560000000E+04, 6.4441086879E+00, 3.1290106316E+00, 5.9535151006E-01, 4.6415552131E-01, 8.3318575471E-01],
	[3.1565000000E+04, 6.4457494649E+00, 3.1289917930E+00, 5.9564103077E-01, 4.6433958296E-01, 8.3321973566E-01],
	[3.1570000000E+04, 6.4473903998E+00, 3.1289729575E+00, 5.9593064631E-01, 4.6452367364E-01, 8.3325370965E-01],
	[3.1575000000E+04, 6.4490314924E+00, 3.1289541251E+00, 5.9622035669E-01, 4.6470779332E-01, 8.3328767669E-01],
	[3.1580000000E+04, 6.4506727427E+00, 3.1289352958E+00, 5.9651016192E-01, 4.6489194201E-01, 8.3332163678E-01],
	[3.1585000000E+04, 6.4523141508E+00, 3.1289164696E+00, 5.9680006203E-01, 4.6507611967E-01, 8.3335558993E-01],
	[3.1590000000E+04, 6.4539557167E+00, 3.1288976465E+00, 5.9709005704E-01, 4.6526032631E-01, 8.3338953612E-01],
	[3.1595000000E+04, 6.4555974403E+00, 3.1288788265E+00, 5.9738014694E-01, 4.6544456192E-01, 8.3342347537E-01],
	[3.1600000000E+04, 6.4572393216E+00, 3.1288600095E+00, 5.9767033177E-01, 4.6562882647E-01, 8.3345740767E-01],
	[3.1605000000E+04, 6.4588813607E+00, 3.1288411957E+00, 5.9796061154E-01, 4.6581311997E-01, 8.3349133304E-01],
	[3.1610000000E+04, 6.4605235574E+00, 3.1288223849E+00, 5.9825098626E-01, 4.6599744239E-01, 8.3352525146E-01],
	[3.1615000000E+04, 6.4621659119E+00, 3.1288035773E+00, 5.9854145595E-01, 4.6618179373E-01, 8.3355916294E-01],
	[3.1620000000E+04, 6.4638084240E+00, 3.1287847727E+00, 5.9883202063E-01, 4.6636617398E-01, 8.3359306749E-01],
	[3.1625000000E+04, 6.4654510938E+00, 3.1287659712E+00, 5.9912268031E-01, 4.6655058312E-01, 8.3362696510E-01],
	[3.1630000000E+04, 6.4670939213E+00, 3.1287471728E+00, 5.9941343501E-01, 4.6673502114E-01, 8.3366085577E-01],
	[3.1635000000E+04, 6.4687369065E+00, 3.1287283775E+00, 5.9970428474E-01, 4.6691948804E-01, 8.3369473952E-01],
	[3.1640000000E+04, 6.4703800493E+00, 3.1287095852E+00, 5.9999522952E-01, 4.6710398379E-01, 8.3372861633E-01],
	[3.1645000000E+04, 6.4720233497E+00, 3.1286907961E+00, 6.0028626937E-01, 4.6728850840E-01, 8.3376248621E-01],
	[3.1650000000E+04, 6.4736668078E+00, 3.1286720100E+00, 6.0057740430E-01, 4.6747306184E-01, 8.3379634917E-01],
	[3.1655000000E+04, 6.4753104234E+00, 3.1286532270E+00, 6.0086863433E-01, 4.6765764411E-01, 8.3383020520E-01],
	[3.1660000000E+04, 6.4769541967E+00, 3.1286344471E+00, 6.0115995947E-01, 4.6784225519E-01, 8.3386405430E-01],
	[3.1665000000E+04, 6.4785981276E+00, 3.1286156703E+00, 6.0145137975E-01, 4.6802689507E-01, 8.3389789648E-01],
	[3.1670000000E+04, 6.4802422161E+00, 3.1285968965E+00, 6.0174289516E-01, 4.6821156374E-01, 8.3393173175E-01],
	[3.1675000000E+04, 6.4818864622E+00, 3.1285781258E+00, 6.0203450575E-01, 4.6839626120E-01, 8.3396556009E-01],
	[3.1680000000E+04, 6.4835308658E+00, 3.1285593582E+00, 6.0232621151E-01, 4.6858098742E-01, 8.3399938151E-01],
	[3.1685000000E+04, 6.4851754270E+00, 3.1285405937E+00, 6.0261801246E-01, 4.6876574240E-01, 8.3403319602E-01],
	[3.1690000000E+04, 6.4868201457E+00, 3.1285218322E+00, 6.0290990862E-01, 4.6895052613E-01, 8.3406700360E-01],
	[3.1695000000E+04, 6.4884650220E+00, 3.1285030738E+00, 6.0320190001E-01, 4.6913533859E-01, 8.3410080429E-01],
	[3.1700000000E+04, 6.4901100558E+00, 3.1284843185E+00, 6.0349398665E-01, 4.6932017977E-01, 8.3413459808E-01],
	[3.1705000000E+04, 6.4917552471E+00, 3.1284655663E+00, 6.0378616854E-01, 4.6950504966E-01, 8.3416838497E-01],
	[3.1710000000E+04, 6.4934005960E+00, 3.1284468171E+00, 6.0407844570E-01, 4.6968994826E-01, 8.3420216496E-01],
	[3.1715000000E+04, 6.4950461023E+00, 3.1284280710E+00, 6.0437081816E-01, 4.6987487554E-01, 8.3423593805E-01],
	[3.1720000000E+04, 6.4966917662E+00, 3.1284093280E+00, 6.0466328592E-01, 4.7005983149E-01, 8.3426970426E-01],
	[3.1725000000E+04, 6.4983375875E+00, 3.1283905880E+00, 6.0495584900E-01, 4.7024481612E-01, 8.3430346356E-01],
	[3.1730000000E+04, 6.4999835663E+00, 3.1283718511E+00, 6.0524850742E-01, 4.7042982939E-01, 8.3433721598E-01],
	[3.1735000000E+04, 6.5016297026E+00, 3.1283531172E+00, 6.0554126120E-01, 4.7061487131E-01, 8.3437096150E-01],
	[3.1740000000E+04, 6.5032759963E+00, 3.1283343864E+00, 6.0583411034E-01, 4.7079994186E-01, 8.3440470014E-01],
	[3.1745000000E+04, 6.5049224474E+00, 3.1283156587E+00, 6.0612705487E-01, 4.7098504103E-01, 8.3443843189E-01],
	[3.1750000000E+04, 6.5065690560E+00, 3.1282969341E+00, 6.0642009481E-01, 4.7117016881E-01, 8.3447215676E-01],
	[3.1755000000E+04, 6.5082158220E+00, 3.1282782125E+00, 6.0671323016E-01, 4.7135532518E-01, 8.3450587474E-01],
	[3.1760000000E+04, 6.5098627455E+00, 3.1282594939E+00, 6.0700646095E-01, 4.7154051013E-01, 8.3453958584E-01],
	[3.1765000000E+04, 6.5115098263E+00, 3.1282407785E+00, 6.0729978718E-01, 4.7172572366E-01, 8.3457329006E-01],
	[3.1770000000E+04, 6.5131570645E+00, 3.1282220660E+00, 6.0759320889E-01, 4.7191096576E-01, 8.3460698740E-01],
	[3.1775000000E+04, 6.5148044601E+00, 3.1282033567E+00, 6.0788672607E-01, 4.7209623640E-01, 8.3464067787E-01],
	[3.1780000000E+04, 6.5164520131E+00, 3.1281846504E+00, 6.0818033875E-01, 4.7228153558E-01, 8.3467436145E-01],
	[3.1785000000E+04, 6.5180997235E+00, 3.1281659471E+00, 6.0847404695E-01, 4.7246686328E-01, 8.3470803817E-01],
	[3.1790000000E+04, 6.5197475912E+00, 3.1281472469E+00, 6.0876785068E-01, 4.7265221951E-01, 8.3474170801E-01],
	[3.1795000000E+04, 6.5213956162E+00, 3.1281285498E+00, 6.0906174995E-01, 4.7283760423E-01, 8.3477537099E-01],
	[3.1800000000E+04, 6.5230437986E+00, 3.1281098557E+00, 6.0935574479E-01, 4.7302301745E-01, 8.3480902709E-01],
	[3.1805000000E+04, 6.5246921383E+00, 3.1280911646E+00, 6.0964983520E-01, 4.7320845915E-01, 8.3484267633E-01],
	[3.1810000000E+04, 6.5263406354E+00, 3.1280724766E+00, 6.0994402121E-01, 4.7339392932E-01, 8.3487631870E-01],
	[3.1815000000E+04, 6.5279892897E+00, 3.1280537917E+00, 6.1023830283E-01, 4.7357942795E-01, 8.3490995420E-01],
	[3.1820000000E+04, 6.5296381014E+00, 3.1280351098E+00, 6.1053268007E-01, 4.7376495502E-01, 8.3494358285E-01],
	[3.1825000000E+04, 6.5312870703E+00, 3.1280164310E+00, 6.1082715296E-01, 4.7395051053E-01, 8.3497720463E-01],
	[3.1830000000E+04, 6.5329361965E+00, 3.1279977551E+00, 6.1112172151E-01, 4.7413609446E-01, 8.3501081955E-01],
	[3.1835000000E+04, 6.5345854800E+00, 3.1279790824E+00, 6.1141638573E-01, 4.7432170680E-01, 8.3504442762E-01],
	[3.1840000000E+04, 6.5362349207E+00, 3.1279604127E+00, 6.1171114564E-01, 4.7450734755E-01, 8.3507802883E-01],
	[3.1845000000E+04, 6.5378845187E+00, 3.1279417460E+00, 6.1200600125E-01, 4.7469301668E-01, 8.3511162319E-01],
	[3.1850000000E+04, 6.5395342739E+00, 3.1279230824E+00, 6.1230095259E-01, 4.7487871419E-01, 8.3514521069E-01],
	[3.1855000000E+04, 6.5411841864E+00, 3.1279044218E+00, 6.1259599967E-01, 4.7506444006E-01, 8.3517879134E-01],
	[3.1860000000E+04, 6.5428342560E+00, 3.1278857642E+00, 6.1289114250E-01, 4.7525019429E-01, 8.3521236514E-01],
	[3.1865000000E+04, 6.5444844829E+00, 3.1278671097E+00, 6.1318638110E-01, 4.7543597686E-01, 8.3524593210E-01],
	[3.1870000000E+04, 6.5461348670E+00, 3.1278484582E+00, 6.1348171549E-01, 4.7562178776E-01, 8.3527949220E-01],
	[3.1875000000E+04, 6.5477854083E+00, 3.1278298098E+00, 6.1377714568E-01, 4.7580762698E-01, 8.3531304547E-01],
	[3.1880000000E+04, 6.5494361067E+00, 3.1278111644E+00, 6.1407267168E-01, 4.7599349450E-01, 8.3534659189E-01],
	[3.1885000000E+04, 6.5510885573E+00, 3.1277942051E+00, 6.1436829353E-01, 4.7617943776E-01, 8.3538013147E-01],
	[3.1890000000E+04, 6.5527413842E+00, 3.1277774790E+00, 6.1466401122E-01, 4.7636541586E-01, 8.3541366420E-01],
	[3.1895000000E+04, 6.5543943688E+00, 3.1277607556E+00, 6.1495982478E-01, 4.7655142231E-01, 8.3544719010E-01],
	[3.1900000000E+04, 6.5560475112E+00, 3.1277440349E+00, 6.1525573422E-01, 4.7673745710E-01, 8.3548070917E-01],
	[3.1905000000E+04, 6.5577008113E+00, 3.1277273170E+00, 6.1555173956E-01, 4.7692352020E-01, 8.3551422139E-01],
	[3.1910000000E+04, 6.5593542692E+00, 3.1277106017E+00, 6.1584784081E-01, 4.7710961161E-01, 8.3554772679E-01],
	[3.1915000000E+04, 6.5610078849E+00, 3.1276938892E+00, 6.1614403799E-01, 4.7729573133E-01, 8.3558122535E-01],
	[3.1920000000E+04, 6.5626616583E+00, 3.1276771794E+00, 6.1644033112E-01, 4.7748187932E-01, 8.3561471708E-01],
	[3.1925000000E+04, 6.5643155894E+00, 3.1276604722E+00, 6.1673672022E-01, 4.7766805559E-01, 8.3564820199E-01],
	[3.1930000000E+04, 6.5659696782E+00, 3.1276437678E+00, 6.1703320529E-01, 4.7785426013E-01, 8.3568168007E-01],
	[3.1935000000E+04, 6.5676239247E+00, 3.1276270661E+00, 6.1732978635E-01, 4.7804049292E-01, 8.3571515132E-01],
	[3.1940000000E+04, 6.5692783290E+00, 3.1276103671E+00, 6.1762646343E-01, 4.7822675394E-01, 8.3574861574E-01],
	[3.1945000000E+04, 6.5709328909E+00, 3.1275936708E+00, 6.1792323653E-01, 4.7841304320E-01, 8.3578207335E-01],
	[3.1950000000E+04, 6.5725876105E+00, 3.1275769772E+00, 6.1822010568E-01, 4.7859936067E-01, 8.3581552413E-01],
	[3.1955000000E+04, 6.5742424877E+00, 3.1275602863E+00, 6.1851707088E-01, 4.7878570635E-01, 8.3584896810E-01],
	[3.1960000000E+04, 6.5758975226E+00, 3.1275435981E+00, 6.1881413216E-01, 4.7897208022E-01, 8.3588240525E-01],
	[3.1965000000E+04, 6.5775527152E+00, 3.1275269126E+00, 6.1911128952E-01, 4.7915848227E-01, 8.3591583558E-01],
	[3.1970000000E+04, 6.5792080654E+00, 3.1275102298E+00, 6.1940854300E-01, 4.7934491250E-01, 8.3594925910E-01],
	[3.1975000000E+04, 6.5808635732E+00, 3.1274935497E+00, 6.1970589260E-01, 4.7953137088E-01, 8.3598267580E-01],
	[3.1980000000E+04, 6.5825192386E+00, 3.1274768723E+00, 6.2000333833E-01, 4.7971785741E-01, 8.3601608569E-01],
	[3.1985000000E+04, 6.5841750617E+00, 3.1274601976E+00, 6.2030088022E-01, 4.7990437208E-01, 8.3604948878E-01],
	[3.1990000000E+04, 6.5858310423E+00, 3.1274435255E+00, 6.2059851828E-01, 4.8009091487E-01, 8.3608288506E-01],
	[3.1995000000E+04, 6.5874871806E+00, 3.1274268562E+00, 6.2089625253E-01, 4.8027748577E-01, 8.3611627453E-01],
	[3.2000000000E+04, 6.5891434764E+00, 3.1274101896E+00, 6.2119408298E-01, 4.8046408477E-01, 8.3614965719E-01],
	[3.2005000000E+04, 6.5907999298E+00, 3.1273935256E+00, 6.2149200964E-01, 4.8065071186E-01, 8.3618303305E-01],
	[3.2010000000E+04, 6.5924565407E+00, 3.1273768644E+00, 6.2179003254E-01, 4.8083736703E-01, 8.3621640212E-01],
	[3.2015000000E+04, 6.5941133092E+00, 3.1273602058E+00, 6.2208815170E-01, 4.8102405027E-01, 8.3624976438E-01],
	[3.2020000000E+04, 6.5957702352E+00, 3.1273435500E+00, 6.2238636712E-01, 4.8121076156E-01, 8.3628311984E-01],
	[3.2025000000E+04, 6.5974273188E+00, 3.1273268968E+00, 6.2268467882E-01, 4.8139750089E-01, 8.3631646851E-01],
	[3.2030000000E+04, 6.5990845599E+00, 3.1273102463E+00, 6.2298308682E-01, 4.8158426826E-01, 8.3634981038E-01],
	[3.2035000000E+04, 6.6007419585E+00, 3.1272935985E+00, 6.2328159113E-01, 4.8177106364E-01, 8.3638314546E-01],
	[3.2040000000E+04, 6.6023995146E+00, 3.1272769534E+00, 6.2358019178E-01, 4.8195788703E-01, 8.3641647374E-01],
	[3.2045000000E+04, 6.6040572282E+00, 3.1272603110E+00, 6.2387888877E-01, 4.8214473842E-01, 8.3644979524E-01],
	[3.2050000000E+04, 6.6057150993E+00, 3.1272436713E+00, 6.2417768212E-01, 4.8233161779E-01, 8.3648310994E-01],
	[3.2055000000E+04, 6.6073731278E+00, 3.1272270342E+00, 6.2447657186E-01, 4.8251852514E-01, 8.3651641786E-01],
	[3.2060000000E+04, 6.6090313138E+00, 3.1272103998E+00, 6.2477555798E-01, 4.8270546044E-01, 8.3654971900E-01],
	[3.2065000000E+04, 6.6106896573E+00, 3.1271937681E+00, 6.2507464052E-01, 4.8289242370E-01, 8.3658301335E-01],
	[3.2070000000E+04, 6.6123481582E+00, 3.1271771391E+00, 6.2537381949E-01, 4.8307941489E-01, 8.3661630092E-01],
	[3.2075000000E+04, 6.6140068166E+00, 3.1271605128E+00, 6.2567309489E-01, 4.8326643401E-01, 8.3664958170E-01],
	[3.2080000000E+04, 6.6156656324E+00, 3.1271438892E+00, 6.2597246676E-01, 4.8345348104E-01, 8.3668285571E-01],
	[3.2085000000E+04, 6.6173246056E+00, 3.1271272682E+00, 6.2627193510E-01, 4.8364055598E-01, 8.3671612294E-01],
	[3.2090000000E+04, 6.6189837362E+00, 3.1271106499E+00, 6.2657149993E-01, 4.8382765881E-01, 8.3674938340E-01],
	[3.2095000000E+04, 6.6206430242E+00, 3.1270940343E+00, 6.2687116127E-01, 4.8401478952E-01, 8.3678263708E-01],
	[3.2100000000E+04, 6.6223024695E+00, 3.1270774213E+00, 6.2717091913E-01, 4.8420194809E-01, 8.3681588399E-01],
	[3.2105000000E+04, 6.6239620723E+00, 3.1270608111E+00, 6.2747077353E-01, 4.8438913452E-01, 8.3684912412E-01],
	[3.2110000000E+04, 6.6256218324E+00, 3.1270442035E+00, 6.2777072448E-01, 4.8457634880E-01, 8.3688235749E-01],
	[3.2115000000E+04, 6.6272817499E+00, 3.1270275986E+00, 6.2807077201E-01, 4.8476359091E-01, 8.3691558409E-01],
	[3.2120000000E+04, 6.6289418248E+00, 3.1270109963E+00, 6.2837091612E-01, 4.8495086084E-01, 8.3694880392E-01],
	[3.2125000000E+04, 6.6306020569E+00, 3.1269943968E+00, 6.2867115684E-01, 4.8513815858E-01, 8.3698201699E-01],
	[3.2130000000E+04, 6.6322624464E+00, 3.1269777999E+00, 6.2897149417E-01, 4.8532548412E-01, 8.3701522329E-01],
	[3.2135000000E+04, 6.6339229933E+00, 3.1269612057E+00, 6.2927192814E-01, 4.8551283744E-01, 8.3704842284E-01],
	[3.2140000000E+04, 6.6355836974E+00, 3.1269446141E+00, 6.2957245876E-01, 4.8570021854E-01, 8.3708161562E-01],
	[3.2145000000E+04, 6.6372445588E+00, 3.1269280252E+00, 6.2987308604E-01, 4.8588762740E-01, 8.3711480164E-01],
	[3.2150000000E+04, 6.6389055776E+00, 3.1269114390E+00, 6.3017381001E-01, 4.8607506401E-01, 8.3714798091E-01],
	[3.2155000000E+04, 6.6405667536E+00, 3.1268948555E+00, 6.3047463068E-01, 4.8626252836E-01, 8.3718115342E-01],
	[3.2160000000E+04, 6.6422280869E+00, 3.1268782746E+00, 6.3077554806E-01, 4.8645002044E-01, 8.3721431918E-01],
	[3.2165000000E+04, 6.6438895774E+00, 3.1268616964E+00, 6.3107656217E-01, 4.8663754023E-01, 8.3724747819E-01],
	[3.2170000000E+04, 6.6455512252E+00, 3.1268451208E+00, 6.3137767303E-01, 4.8682508773E-01, 8.3728063044E-01],
	[3.2175000000E+04, 6.6472130303E+00, 3.1268285479E+00, 6.3167888065E-01, 4.8701266292E-01, 8.3731377595E-01],
	[3.2180000000E+04, 6.6488749925E+00, 3.1268119777E+00, 6.3198018506E-01, 4.8720026579E-01, 8.3734691471E-01],
	[3.2185000000E+04, 6.6505371120E+00, 3.1267954101E+00, 6.3228158625E-01, 4.8738789633E-01, 8.3738004672E-01],
	[3.2190000000E+04, 6.6521993887E+00, 3.1267788452E+00, 6.3258308426E-01, 4.8757555453E-01, 8.3741317199E-01],
	[3.2195000000E+04, 6.6538618227E+00, 3.1267622830E+00, 6.3288467910E-01, 4.8776324037E-01, 8.3744629052E-01],
	[3.2200000000E+04, 6.6555244138E+00, 3.1267457234E+00, 6.3318637077E-01, 4.8795095385E-01, 8.3747940231E-01],
	[3.2205000000E+04, 6.6571871621E+00, 3.1267291665E+00, 6.3348815931E-01, 4.8813869494E-01, 8.3751250735E-01],
	[3.2210000000E+04, 6.6588500676E+00, 3.1267126122E+00, 6.3379004472E-01, 4.8832646365E-01, 8.3754560566E-01],
	[3.2215000000E+04, 6.6605131302E+00, 3.1266960606E+00, 6.3409202703E-01, 4.8851425996E-01, 8.3757869724E-01],
	[3.2220000000E+04, 6.6621763500E+00, 3.1266795116E+00, 6.3439410623E-01, 4.8870208385E-01, 8.3761178207E-01],
	[3.2225000000E+04, 6.6638397270E+00, 3.1266629654E+00, 6.3469628237E-01, 4.8888993532E-01, 8.3764486018E-01],
	[3.2230000000E+04, 6.6655032611E+00, 3.1266464217E+00, 6.3499855544E-01, 4.8907781435E-01, 8.3767793155E-01],
	[3.2235000000E+04, 6.6671669523E+00, 3.1266298807E+00, 6.3530092547E-01, 4.8926572093E-01, 8.3771099620E-01],
	[3.2240000000E+04, 6.6688308006E+00, 3.1266133424E+00, 6.3560339247E-01, 4.8945365506E-01, 8.3774405411E-01],
	[3.2245000000E+04, 6.6704948061E+00, 3.1265968067E+00, 6.3590595645E-01, 4.8964161671E-01, 8.3777710530E-01],
	[3.2250000000E+04, 6.6721589686E+00, 3.1265802737E+00, 6.3620861744E-01, 4.8982960587E-01, 8.3781014976E-01],
	[3.2255000000E+04, 6.6738232883E+00, 3.1265637433E+00, 6.3651137545E-01, 4.9001762254E-01, 8.3784318750E-01],
	[3.2260000000E+04, 6.6754877650E+00, 3.1265472156E+00, 6.3681423049E-01, 4.9020566671E-01, 8.3787621852E-01],
	[3.2265000000E+04, 6.6771523988E+00, 3.1265306905E+00, 6.3711718258E-01, 4.9039373835E-01, 8.3790924282E-01],
	[3.2270000000E+04, 6.6788171897E+00, 3.1265141680E+00, 6.3742023174E-01, 4.9058183747E-01, 8.3794226040E-01],
	[3.2275000000E+04, 6.6804821376E+00, 3.1264976483E+00, 6.3772337799E-01, 4.9076996404E-01, 8.3797527126E-01],
	[3.2280000000E+04, 6.6821472425E+00, 3.1264811311E+00, 6.3802662133E-01, 4.9095811805E-01, 8.3800827540E-01],
	[3.2285000000E+04, 6.6838125045E+00, 3.1264646166E+00, 6.3832996179E-01, 4.9114629950E-01, 8.3804127283E-01],
	[3.2290000000E+04, 6.6854779235E+00, 3.1264481048E+00, 6.3863339938E-01, 4.9133450837E-01, 8.3807426355E-01],
	[3.2295000000E+04, 6.6871434995E+00, 3.1264315956E+00, 6.3893693412E-01, 4.9152274466E-01, 8.3810724756E-01],
	[3.2300000000E+04, 6.6888092326E+00, 3.1264150890E+00, 6.3924056602E-01, 4.9171100834E-01, 8.3814022486E-01],
	[3.2305000000E+04, 6.6904751226E+00, 3.1263985851E+00, 6.3954429510E-01, 4.9189929940E-01, 8.3817319545E-01],
	[3.2310000000E+04, 6.6921411696E+00, 3.1263820838E+00, 6.3984812138E-01, 4.9208761784E-01, 8.3820615934E-01],
	[3.2315000000E+04, 6.6938073736E+00, 3.1263655852E+00, 6.4015204487E-01, 4.9227596365E-01, 8.3823911651E-01],
	[3.2320000000E+04, 6.6954737346E+00, 3.1263490892E+00, 6.4045606558E-01, 4.9246433680E-01, 8.3827206699E-01],
	[3.2325000000E+04, 6.6971402525E+00, 3.1263325958E+00, 6.4076018354E-01, 4.9265273730E-01, 8.3830501077E-01],
	[3.2330000000E+04, 6.6988069273E+00, 3.1263161051E+00, 6.4106439876E-01, 4.9284116512E-01, 8.3833794784E-01],
	[3.2335000000E+04, 6.7004737591E+00, 3.1262996170E+00, 6.4136871125E-01, 4.9302962026E-01, 8.3837087822E-01],
	[3.2340000000E+04, 6.7021407479E+00, 3.1262831315E+00, 6.4167312103E-01, 4.9321810270E-01, 8.3840380190E-01],
	[3.2345000000E+04, 6.7038078935E+00, 3.1262666487E+00, 6.4197762812E-01, 4.9340661243E-01, 8.3843671888E-01],
	[3.2350000000E+04, 6.7054751961E+00, 3.1262501685E+00, 6.4228223254E-01, 4.9359514945E-01, 8.3846962918E-01],
	[3.2355000000E+04, 6.7071426556E+00, 3.1262336910E+00, 6.4258693430E-01, 4.9378371373E-01, 8.3850253277E-01],
	[3.2360000000E+04, 6.7088102719E+00, 3.1262172161E+00, 6.4289173341E-01, 4.9397230527E-01, 8.3853542968E-01],
	[3.2365000000E+04, 6.7104780451E+00, 3.1262007438E+00, 6.4319662989E-01, 4.9416092405E-01, 8.3856831990E-01],
	[3.2370000000E+04, 6.7121459752E+00, 3.1261842741E+00, 6.4350162376E-01, 4.9434957007E-01, 8.3860120344E-01],
	[3.2375000000E+04, 6.7138140622E+00, 3.1261678071E+00, 6.4380671503E-01, 4.9453824331E-01, 8.3863408028E-01],
	[3.2380000000E+04, 6.7154823060E+00, 3.1261513427E+00, 6.4411190372E-01, 4.9472694375E-01, 8.3866695044E-01],
	[3.2385000000E+04, 6.7171507067E+00, 3.1261348810E+00, 6.4441718985E-01, 4.9491567140E-01, 8.3869981392E-01],
	[3.2390000000E+04, 6.7188192642E+00, 3.1261184218E+00, 6.4472257343E-01, 4.9510442623E-01, 8.3873267072E-01],
	[3.2395000000E+04, 6.7204885035E+00, 3.1261024016E+00, 6.4502805448E-01, 4.9529322203E-01, 8.3876552084E-01],
	[3.2400000000E+04, 6.7221596313E+00, 3.1260878227E+00, 6.4533363301E-01, 4.9548209057E-01, 8.3879836428E-01],
	[3.2405000000E+04, 6.7238309166E+00, 3.1260732462E+00, 6.4563930905E-01, 4.9567098634E-01, 8.3883120105E-01],
	[3.2410000000E+04, 6.7255023596E+00, 3.1260586719E+00, 6.4594508259E-01, 4.9585990931E-01, 8.3886403114E-01],
	[3.2415000000E+04, 6.7271739601E+00, 3.1260441000E+00, 6.4625095367E-01, 4.9604885949E-01, 8.3889685456E-01],
	[3.2420000000E+04, 6.7288457182E+00, 3.1260295303E+00, 6.4655692230E-01, 4.9623783686E-01, 8.3892967130E-01],
	[3.2425000000E+04, 6.7305176338E+00, 3.1260149630E+00, 6.4686298849E-01, 4.9642684141E-01, 8.3896248138E-01],
	[3.2430000000E+04, 6.7321897069E+00, 3.1260003980E+00, 6.4716915226E-01, 4.9661587313E-01, 8.3899528478E-01],
	[3.2435000000E+04, 6.7338619375E+00, 3.1259858353E+00, 6.4747541363E-01, 4.9680493200E-01, 8.3902808152E-01],
	[3.2440000000E+04, 6.7355343257E+00, 3.1259712750E+00, 6.4778177261E-01, 4.9699401801E-01, 8.3906087160E-01],
	[3.2445000000E+04, 6.7372068714E+00, 3.1259567169E+00, 6.4808822921E-01, 4.9718313115E-01, 8.3909365501E-01],
	[3.2450000000E+04, 6.7388795746E+00, 3.1259421612E+00, 6.4839478346E-01, 4.9737227142E-01, 8.3912643176E-01],
	[3.2455000000E+04, 6.7405524352E+00, 3.1259276077E+00, 6.4870143538E-01, 4.9756143879E-01, 8.3915920184E-01],
	[3.2460000000E+04, 6.7422254533E+00, 3.1259130566E+00, 6.4900818496E-01, 4.9775063325E-01, 8.3919196527E-01],
	[3.2465000000E+04, 6.7438986289E+00, 3.1258985078E+00, 6.4931503224E-01, 4.9793985480E-01, 8.3922472204E-01],
	[3.2470000000E+04, 6.7455719620E+00, 3.1258839613E+00, 6.4962197723E-01, 4.9812910343E-01, 8.3925747216E-01],
	[3.2475000000E+04, 6.7472454525E+00, 3.1258694171E+00, 6.4992901994E-01, 4.9831837911E-01, 8.3929021562E-01],
	[3.2480000000E+04, 6.7489191004E+00, 3.1258548752E+00, 6.5023616039E-01, 4.9850768184E-01, 8.3932295243E-01],
	[3.2485000000E+04, 6.7505929057E+00, 3.1258403356E+00, 6.5054339860E-01, 4.9869701161E-01, 8.3935568258E-01],
	[3.2490000000E+04, 6.7522668685E+00, 3.1258257983E+00, 6.5085073458E-01, 4.9888636840E-01, 8.3938840609E-01],
	[3.2495000000E+04, 6.7539409887E+00, 3.1258112633E+00, 6.5115816834E-01, 4.9907575220E-01, 8.3942112295E-01],
	[3.2500000000E+04, 6.7556152663E+00, 3.1257967307E+00, 6.5146569991E-01, 4.9926516300E-01, 8.3945383316E-01],
	[3.2505000000E+04, 6.7572897013E+00, 3.1257822003E+00, 6.5177332931E-01, 4.9945460080E-01, 8.3948653673E-01],
	[3.2510000000E+04, 6.7589642936E+00, 3.1257676722E+00, 6.5208105653E-01, 4.9964406557E-01, 8.3951923365E-01],
	[3.2515000000E+04, 6.7606390433E+00, 3.1257531465E+00, 6.5238888162E-01, 4.9983355730E-01, 8.3955192393E-01],
	[3.2520000000E+04, 6.7623139504E+00, 3.1257386230E+00, 6.5269680456E-01, 5.0002307599E-01, 8.3958460757E-01],
	[3.2525000000E+04, 6.7639890149E+00, 3.1257241018E+00, 6.5300482540E-01, 5.0021262162E-01, 8.3961728458E-01],
	[3.2530000000E+04, 6.7656642367E+00, 3.1257095830E+00, 6.5331294413E-01, 5.0040219418E-01, 8.3964995494E-01],
	[3.2535000000E+04, 6.7673396158E+00, 3.1256950664E+00, 6.5362116078E-01, 5.0059179366E-01, 8.3968261867E-01],
	[3.2540000000E+04, 6.7690151522E+00, 3.1256805521E+00, 6.5392947536E-01, 5.0078142004E-01, 8.3971527576E-01],
	[3.2545000000E+04, 6.7706908460E+00, 3.1256660402E+00, 6.5423788789E-01, 5.0097107332E-01, 8.3974792623E-01],
	[3.2550000000E+04, 6.7723666970E+00, 3.1256515305E+00, 6.5454639839E-01, 5.0116075348E-01, 8.3978057006E-01],
	[3.2555000000E+04, 6.7740427054E+00, 3.1256370231E+00, 6.5485500686E-01, 5.0135046051E-01, 8.3981320726E-01],
	[3.2560000000E+04, 6.7757188711E+00, 3.1256225180E+00, 6.5516371334E-01, 5.0154019439E-01, 8.3984583784E-01],
	[3.2565000000E+04, 6.7773951940E+00, 3.1256080152E+00, 6.5547251782E-01, 5.0172995513E-01, 8.3987846178E-01],
	[3.2570000000E+04, 6.7790716742E+00, 3.1255935147E+00, 6.5578142033E-01, 5.0191974270E-01, 8.3991107911E-01],
	[3.2575000000E+04, 6.7807483116E+00, 3.1255790165E+00, 6.5609042089E-01, 5.0210955709E-01, 8.3994368981E-01],
	[3.2580000000E+04, 6.7824251063E+00, 3.1255645206E+00, 6.5639951951E-01, 5.0229939829E-01, 8.3997629388E-01],
	[3.2585000000E+04, 6.7841020583E+00, 3.1255500270E+00, 6.5670871621E-01, 5.0248926629E-01, 8.4000889134E-01],
	[3.2590000000E+04, 6.7857791674E+00, 3.1255355357E+00, 6.5701801099E-01, 5.0267916107E-01, 8.4004148218E-01],
	[3.2595000000E+04, 6.7874564338E+00, 3.1255210466E+00, 6.5732740389E-01, 5.0286908263E-01, 8.4007406640E-01],
	[3.2600000000E+04, 6.7891338574E+00, 3.1255065599E+00, 6.5763689491E-01, 5.0305903096E-01, 8.4010664401E-01],
	[3.2605000000E+04, 6.7908114382E+00, 3.1254920754E+00, 6.5794648407E-01, 5.0324900603E-01, 8.4013921500E-01],
	[3.2610000000E+04, 6.7924891762E+00, 3.1254775933E+00, 6.5825617139E-01, 5.0343900785E-01, 8.4017177939E-01],
	[3.2615000000E+04, 6.7941670714E+00, 3.1254631134E+00, 6.5856595689E-01, 5.0362903639E-01, 8.4020433716E-01],
	[3.2620000000E+04, 6.7958451238E+00, 3.1254486358E+00, 6.5887584057E-01, 5.0381909165E-01, 8.4023688832E-01],
	[3.2625000000E+04, 6.7975233333E+00, 3.1254341605E+00, 6.5918582245E-01, 5.0400917361E-01, 8.4026943287E-01],
	[3.2630000000E+04, 6.7992017000E+00, 3.1254196874E+00, 6.5949590256E-01, 5.0419928226E-01, 8.4030197082E-01],
	[3.2635000000E+04, 6.8008802238E+00, 3.1254052167E+00, 6.5980608090E-01, 5.0438941759E-01, 8.4033450216E-01],
	[3.2640000000E+04, 6.8025589047E+00, 3.1253907482E+00, 6.6011635750E-01, 5.0457957959E-01, 8.4036702690E-01],
	[3.2645000000E+04, 6.8042377428E+00, 3.1253762821E+00, 6.6042673236E-01, 5.0476976824E-01, 8.4039954504E-01],
	[3.2650000000E+04, 6.8059167380E+00, 3.1253618182E+00, 6.6073720551E-01, 5.0495998354E-01, 8.4043205657E-01],
	[3.2655000000E+04, 6.8075958903E+00, 3.1253473566E+00, 6.6104777696E-01, 5.0515022547E-01, 8.4046456151E-01],
	[3.2660000000E+04, 6.8092751998E+00, 3.1253328972E+00, 6.6135844673E-01, 5.0534049401E-01, 8.4049705986E-01],
	[3.2665000000E+04, 6.8109546663E+00, 3.1253184402E+00, 6.6166921483E-01, 5.0553078917E-01, 8.4052955160E-01],
	[3.2670000000E+04, 6.8126342898E+00, 3.1253039854E+00, 6.6198008128E-01, 5.0572111092E-01, 8.4056203676E-01],
	[3.2675000000E+04, 6.8143140705E+00, 3.1252895329E+00, 6.6229104610E-01, 5.0591145926E-01, 8.4059451532E-01],
	[3.2680000000E+04, 6.8159940082E+00, 3.1252750827E+00, 6.6260210930E-01, 5.0610183417E-01, 8.4062698729E-01],
	[3.2685000000E+04, 6.8176741030E+00, 3.1252606348E+00, 6.6291327089E-01, 5.0629223563E-01, 8.4065945267E-01],
	[3.2690000000E+04, 6.8193543548E+00, 3.1252461891E+00, 6.6322453090E-01, 5.0648266365E-01, 8.4069191147E-01],
	[3.2695000000E+04, 6.8210347636E+00, 3.1252317458E+00, 6.6353588934E-01, 5.0667311820E-01, 8.4072436368E-01],
	[3.2700000000E+04, 6.8227153295E+00, 3.1252173047E+00, 6.6384734622E-01, 5.0686359928E-01, 8.4075680930E-01],
	[3.2705000000E+04, 6.8243960524E+00, 3.1252028658E+00, 6.6415890156E-01, 5.0705410687E-01, 8.4078924834E-01],
	[3.2710000000E+04, 6.8260769323E+00, 3.1251884293E+00, 6.6447055538E-01, 5.0724464095E-01, 8.4082168080E-01],
	[3.2715000000E+04, 6.8277579692E+00, 3.1251739950E+00, 6.6478230770E-01, 5.0743520153E-01, 8.4085410668E-01],
	[3.2720000000E+04, 6.8294391630E+00, 3.1251595630E+00, 6.6509415852E-01, 5.0762578858E-01, 8.4088652598E-01],
	[3.2725000000E+04, 6.8311205139E+00, 3.1251451332E+00, 6.6540610787E-01, 5.0781640210E-01, 8.4091893871E-01],
	[3.2730000000E+04, 6.8328020217E+00, 3.1251307058E+00, 6.6571815576E-01, 5.0800704207E-01, 8.4095134486E-01],
	[3.2735000000E+04, 6.8344836865E+00, 3.1251162806E+00, 6.6603030221E-01, 5.0819770847E-01, 8.4098374443E-01],
	[3.2740000000E+04, 6.8361655082E+00, 3.1251018576E+00, 6.6634254723E-01, 5.0838840131E-01, 8.4101613744E-01],
	[3.2745000000E+04, 6.8378474869E+00, 3.1250874370E+00, 6.6665489084E-01, 5.0857912056E-01, 8.4104852387E-01],
	[3.2750000000E+04, 6.8395296225E+00, 3.1250730186E+00, 6.6696733306E-01, 5.0876986622E-01, 8.4108090374E-01],
	[3.2755000000E+04, 6.8412119150E+00, 3.1250586025E+00, 6.6727987390E-01, 5.0896063827E-01, 8.4111327703E-01],
	[3.2760000000E+04, 6.8428943644E+00, 3.1250441886E+00, 6.6759251338E-01, 5.0915143670E-01, 8.4114564377E-01],
	[3.2765000000E+04, 6.8445769708E+00, 3.1250297770E+00, 6.6790525151E-01, 5.0934226150E-01, 8.4117800393E-01],
	[3.2770000000E+04, 6.8462597340E+00, 3.1250153677E+00, 6.6821808831E-01, 5.0953311265E-01, 8.4121035754E-01],
	[3.2775000000E+04, 6.8479426541E+00, 3.1250009606E+00, 6.6853102379E-01, 5.0972399015E-01, 8.4124270458E-01],
	[3.2780000000E+04, 6.8496257311E+00, 3.1249865558E+00, 6.6884405798E-01, 5.0991489398E-01, 8.4127504506E-01],
	[3.2785000000E+04, 6.8513089650E+00, 3.1249721533E+00, 6.6915719088E-01, 5.1010582413E-01, 8.4130737899E-01],
	[3.2790000000E+04, 6.8529923557E+00, 3.1249577530E+00, 6.6947042252E-01, 5.1029678058E-01, 8.4133970636E-01],
	[3.2795000000E+04, 6.8546759032E+00, 3.1249433550E+00, 6.6978375291E-01, 5.1048776334E-01, 8.4137202717E-01],
	[3.2800000000E+04, 6.8563596076E+00, 3.1249289593E+00, 6.7009718207E-01, 5.1067877238E-01, 8.4140434143E-01],
	[3.2805000000E+04, 6.8580434689E+00, 3.1249145658E+00, 6.7041071001E-01, 5.1086980769E-01, 8.4143664914E-01],
	[3.2810000000E+04, 6.8597274869E+00, 3.1249001746E+00, 6.7072433674E-01, 5.1106086926E-01, 8.4146895030E-01],
	[3.2815000000E+04, 6.8614116618E+00, 3.1248857856E+00, 6.7103806229E-01, 5.1125195707E-01, 8.4150124490E-01],
	[3.2820000000E+04, 6.8630959934E+00, 3.1248713989E+00, 6.7135188667E-01, 5.1144307113E-01, 8.4153353297E-01],
	[3.2825000000E+04, 6.8647804819E+00, 3.1248570145E+00, 6.7166580990E-01, 5.1163421141E-01, 8.4156581448E-01],
	[3.2830000000E+04, 6.8664651271E+00, 3.1248426323E+00, 6.7197983198E-01, 5.1182537790E-01, 8.4159808945E-01],
	[3.2835000000E+04, 6.8681499291E+00, 3.1248282523E+00, 6.7229395295E-01, 5.1201657059E-01, 8.4163035788E-01],
	[3.2840000000E+04, 6.8698348879E+00, 3.1248138746E+00, 6.7260817281E-01, 5.1220778946E-01, 8.4166261977E-01],
	[3.2845000000E+04, 6.8715200034E+00, 3.1247994992E+00, 6.7292249158E-01, 5.1239903452E-01, 8.4169487511E-01],
	[3.2850000000E+04, 6.8732052757E+00, 3.1247851261E+00, 6.7323690928E-01, 5.1259030573E-01, 8.4172712392E-01],
	[3.2855000000E+04, 6.8748907047E+00, 3.1247707551E+00, 6.7355142592E-01, 5.1278160310E-01, 8.4175936619E-01],
	[3.2860000000E+04, 6.8765762904E+00, 3.1247563865E+00, 6.7386604152E-01, 5.1297292661E-01, 8.4179160193E-01],
	[3.2865000000E+04, 6.8782620328E+00, 3.1247420201E+00, 6.7418075609E-01, 5.1316427624E-01, 8.4182383113E-01],
	[3.2870000000E+04, 6.8799479320E+00, 3.1247276559E+00, 6.7449556965E-01, 5.1335565199E-01, 8.4185605381E-01],
	[3.2875000000E+04, 6.8816339878E+00, 3.1247132940E+00, 6.7481048222E-01, 5.1354705385E-01, 8.4188826995E-01],
	[3.2880000000E+04, 6.8833202004E+00, 3.1246989343E+00, 6.7512549381E-01, 5.1373848179E-01, 8.4192047956E-01],
	[3.2885000000E+04, 6.8850065696E+00, 3.1246845769E+00, 6.7544060444E-01, 5.1392993582E-01, 8.4195268264E-01],
	[3.2890000000E+04, 6.8866930955E+00, 3.1246702218E+00, 6.7575581413E-01, 5.1412141591E-01, 8.4198487920E-01],
	[3.2895000000E+04, 6.8883797780E+00, 3.1246558688E+00, 6.7607112288E-01, 5.1431292206E-01, 8.4201706924E-01],
	[3.2900000000E+04, 6.8900666173E+00, 3.1246415182E+00, 6.7638653072E-01, 5.1450445425E-01, 8.4204925275E-01],
	[3.2905000000E+04, 6.8917536131E+00, 3.1246271698E+00, 6.7670203767E-01, 5.1469601247E-01, 8.4208142974E-01],
	[3.2910000000E+04, 6.8934407656E+00, 3.1246128236E+00, 6.7701764373E-01, 5.1488759671E-01, 8.4211360021E-01],
	[3.2915000000E+04, 6.8951280747E+00, 3.1245984797E+00, 6.7733334893E-01, 5.1507920695E-01, 8.4214576416E-01],
	[3.2920000000E+04, 6.8968180679E+00, 3.1245858529E+00, 6.7764915328E-01, 5.1527090394E-01, 8.4217792159E-01],
	[3.2925000000E+04, 6.8985083991E+00, 3.1245733507E+00, 6.7796505680E-01, 5.1546263133E-01, 8.4221007251E-01],
	[3.2930000000E+04, 6.9001988878E+00, 3.1245608504E+00, 6.7828105949E-01, 5.1565438476E-01, 8.4224221692E-01],
	[3.2935000000E+04, 6.9018895341E+00, 3.1245483520E+00, 6.7859716139E-01, 5.1584616424E-01, 8.4227435482E-01],
	[3.2940000000E+04, 6.9035803378E+00, 3.1245358556E+00, 6.7891336251E-01, 5.1603796974E-01, 8.4230648620E-01],
	[3.2945000000E+04, 6.9052712990E+00, 3.1245233611E+00, 6.7922966285E-01, 5.1622980126E-01, 8.4233861107E-01],
	[3.2950000000E+04, 6.9069624177E+00, 3.1245108686E+00, 6.7954606244E-01, 5.1642165878E-01, 8.4237072944E-01],
	[3.2955000000E+04, 6.9086536938E+00, 3.1244983780E+00, 6.7986256129E-01, 5.1661354229E-01, 8.4240284130E-01],
	[3.2960000000E+04, 6.9103451274E+00, 3.1244858894E+00, 6.8017915943E-01, 5.1680545178E-01, 8.4243494666E-01],
	[3.2965000000E+04, 6.9120367185E+00, 3.1244734027E+00, 6.8049585686E-01, 5.1699738723E-01, 8.4246704551E-01],
	[3.2970000000E+04, 6.9137284670E+00, 3.1244609180E+00, 6.8081265359E-01, 5.1718934864E-01, 8.4249913786E-01],
	[3.2975000000E+04, 6.9154203729E+00, 3.1244484352E+00, 6.8112954966E-01, 5.1738133599E-01, 8.4253122372E-01],
	[3.2980000000E+04, 6.9171124362E+00, 3.1244359543E+00, 6.8144654507E-01, 5.1757334927E-01, 8.4256330307E-01],
	[3.2985000000E+04, 6.9188046570E+00, 3.1244234754E+00, 6.8176363984E-01, 5.1776538847E-01, 8.4259537593E-01],
	[3.2990000000E+04, 6.9204970351E+00, 3.1244109984E+00, 6.8208083399E-01, 5.1795745357E-01, 8.4262744229E-01],
	[3.2995000000E+04, 6.9221895707E+00, 3.1243985234E+00, 6.8239812752E-01, 5.1814954457E-01, 8.4265950216E-01],
	[3.3000000000E+04, 6.9238822636E+00, 3.1243860503E+00, 6.8271552047E-01, 5.1834166145E-01, 8.4269155553E-01],
	[3.3005000000E+04, 6.9255751139E+00, 3.1243735792E+00, 6.8303301283E-01, 5.1853380420E-01, 8.4272360242E-01],
	[3.3010000000E+04, 6.9272681216E+00, 3.1243611099E+00, 6.8335060464E-01, 5.1872597280E-01, 8.4275564282E-01],
	[3.3015000000E+04, 6.9289612866E+00, 3.1243486427E+00, 6.8366829590E-01, 5.1891816725E-01, 8.4278767672E-01],
	[3.3020000000E+04, 6.9306546089E+00, 3.1243361773E+00, 6.8398608663E-01, 5.1911038754E-01, 8.4281970415E-01],
	[3.3025000000E+04, 6.9323480886E+00, 3.1243237139E+00, 6.8430397686E-01, 5.1930263365E-01, 8.4285172508E-01],
	[3.3030000000E+04, 6.9340417257E+00, 3.1243112525E+00, 6.8462196658E-01, 5.1949490556E-01, 8.4288373954E-01],
	[3.3035000000E+04, 6.9357355200E+00, 3.1242987929E+00, 6.8494005583E-01, 5.1968720328E-01, 8.4291574751E-01],
	[3.3040000000E+04, 6.9374294717E+00, 3.1242863353E+00, 6.8525824461E-01, 5.1987952677E-01, 8.4294774900E-01],
	[3.3045000000E+04, 6.9391235806E+00, 3.1242738797E+00, 6.8557653294E-01, 5.2007187604E-01, 8.4297974402E-01],
	[3.3050000000E+04, 6.9408178469E+00, 3.1242614260E+00, 6.8589492084E-01, 5.2026425108E-01, 8.4301173255E-01],
	[3.3055000000E+04, 6.9425122704E+00, 3.1242489742E+00, 6.8621340832E-01, 5.2045665186E-01, 8.4304371461E-01],
	[3.3060000000E+04, 6.9442068512E+00, 3.1242365243E+00, 6.8653199541E-01, 5.2064907837E-01, 8.4307569020E-01],
	[3.3065000000E+04, 6.9459015892E+00, 3.1242240764E+00, 6.8685068211E-01, 5.2084153062E-01, 8.4310765932E-01],
	[3.3070000000E+04, 6.9475964845E+00, 3.1242116304E+00, 6.8716946844E-01, 5.2103400857E-01, 8.4313962196E-01],
	[3.3075000000E+04, 6.9492915371E+00, 3.1241991863E+00, 6.8748835442E-01, 5.2122651222E-01, 8.4317157814E-01],
	[3.3080000000E+04, 6.9509867469E+00, 3.1241867442E+00, 6.8780734006E-01, 5.2141904157E-01, 8.4320352784E-01],
	[3.3085000000E+04, 6.9526821139E+00, 3.1241743040E+00, 6.8812642539E-01, 5.2161159659E-01, 8.4323547108E-01],
	[3.3090000000E+04, 6.9543776382E+00, 3.1241618657E+00, 6.8844561041E-01, 5.2180417727E-01, 8.4326740786E-01],
	[3.3095000000E+04, 6.9560733196E+00, 3.1241494294E+00, 6.8876489514E-01, 5.2199678360E-01, 8.4329933817E-01],
	[3.3100000000E+04, 6.9577691582E+00, 3.1241369950E+00, 6.8908427960E-01, 5.2218941558E-01, 8.4333126202E-01],
	[3.3105000000E+04, 6.9594651541E+00, 3.1241245625E+00, 6.8940376381E-01, 5.2238207318E-01, 8.4336317941E-01],
	[3.3110000000E+04, 6.9611613071E+00, 3.1241121319E+00, 6.8972334777E-01, 5.2257475639E-01, 8.4339509034E-01],
	[3.3115000000E+04, 6.9628576173E+00, 3.1240997033E+00, 6.9004303151E-01, 5.2276746521E-01, 8.4342699482E-01],
	[3.3120000000E+04, 6.9645540846E+00, 3.1240872766E+00, 6.9036281505E-01, 5.2296019962E-01, 8.4345889283E-01],
	[3.3125000000E+04, 6.9662507091E+00, 3.1240748518E+00, 6.9068269839E-01, 5.2315295961E-01, 8.4349078440E-01],
	[3.3130000000E+04, 6.9679474908E+00, 3.1240624289E+00, 6.9100268156E-01, 5.2334574517E-01, 8.4352266951E-01],
	[3.3135000000E+04, 6.9696444295E+00, 3.1240500080E+00, 6.9132276457E-01, 5.2353855628E-01, 8.4355454817E-01],
	[3.3140000000E+04, 6.9713415254E+00, 3.1240375890E+00, 6.9164294743E-01, 5.2373139294E-01, 8.4358642038E-01],
	[3.3145000000E+04, 6.9730387785E+00, 3.1240251719E+00, 6.9196323017E-01, 5.2392425512E-01, 8.4361828614E-01],
	[3.3150000000E+04, 6.9747361886E+00, 3.1240127567E+00, 6.9228361279E-01, 5.2411714282E-01, 8.4365014546E-01],
	[3.3155000000E+04, 6.9764337558E+00, 3.1240003435E+00, 6.9260409532E-01, 5.2431005603E-01, 8.4368199833E-01],
	[3.3160000000E+04, 6.9781314801E+00, 3.1239879322E+00, 6.9292467778E-01, 5.2450299474E-01, 8.4371384475E-01],
	[3.3165000000E+04, 6.9798293615E+00, 3.1239755228E+00, 6.9324536016E-01, 5.2469595892E-01, 8.4374568474E-01],
	[3.3170000000E+04, 6.9815274000E+00, 3.1239631153E+00, 6.9356614251E-01, 5.2488894857E-01, 8.4377751828E-01],
	[3.3175000000E+04, 6.9832255955E+00, 3.1239507097E+00, 6.9388702482E-01, 5.2508196369E-01, 8.4380934539E-01],
	[3.3180000000E+04, 6.9849239481E+00, 3.1239383061E+00, 6.9420800711E-01, 5.2527500424E-01, 8.4384116605E-01],
	[3.3185000000E+04, 6.9866224577E+00, 3.1239259044E+00, 6.9452908941E-01, 5.2546807023E-01, 8.4387298028E-01],
	[3.3190000000E+04, 6.9883211243E+00, 3.1239135045E+00, 6.9485027172E-01, 5.2566116164E-01, 8.4390478808E-01],
	[3.3195000000E+04, 6.9900199480E+00, 3.1239011067E+00, 6.9517155407E-01, 5.2585427846E-01, 8.4393658944E-01],
	[3.3200000000E+04, 6.9917189287E+00, 3.1238887107E+00, 6.9549293646E-01, 5.2604742068E-01, 8.4396838437E-01],
	[3.3205000000E+04, 6.9934180664E+00, 3.1238763166E+00, 6.9581441892E-01, 5.2624058828E-01, 8.4400017288E-01],
	[3.3210000000E+04, 6.9951173611E+00, 3.1238639245E+00, 6.9613600146E-01, 5.2643378126E-01, 8.4403195495E-01],
	[3.3215000000E+04, 6.9968168128E+00, 3.1238515343E+00, 6.9645768410E-01, 5.2662699959E-01, 8.4406373060E-01],
	[3.3220000000E+04, 6.9985164214E+00, 3.1238391459E+00, 6.9677946685E-01, 5.2682024327E-01, 8.4409549982E-01],
	[3.3225000000E+04, 7.0002161871E+00, 3.1238267595E+00, 6.9710134974E-01, 5.2701351229E-01, 8.4412726261E-01],
	[3.3230000000E+04, 7.0019161097E+00, 3.1238143751E+00, 6.9742333276E-01, 5.2720680663E-01, 8.4415901899E-01],
	[3.3235000000E+04, 7.0036161892E+00, 3.1238019925E+00, 6.9774541595E-01, 5.2740012628E-01, 8.4419076894E-01],
	[3.3240000000E+04, 7.0053164257E+00, 3.1237896118E+00, 6.9806759932E-01, 5.2759347123E-01, 8.4422251247E-01],
	[3.3245000000E+04, 7.0070168191E+00, 3.1237772331E+00, 6.9838988288E-01, 5.2778684147E-01, 8.4425424959E-01],
	[3.3250000000E+04, 7.0087173695E+00, 3.1237648562E+00, 6.9871226665E-01, 5.2798023698E-01, 8.4428598029E-01],
	[3.3255000000E+04, 7.0104180767E+00, 3.1237524813E+00, 6.9903475064E-01, 5.2817365776E-01, 8.4431770457E-01],
	[3.3260000000E+04, 7.0121189409E+00, 3.1237401083E+00, 6.9935733488E-01, 5.2836710378E-01, 8.4434942244E-01],
	[3.3265000000E+04, 7.0138199619E+00, 3.1237277372E+00, 6.9968001937E-01, 5.2856057505E-01, 8.4438113390E-01],
	[3.3270000000E+04, 7.0155211399E+00, 3.1237153679E+00, 7.0000280414E-01, 5.2875407154E-01, 8.4441283895E-01],
	[3.3275000000E+04, 7.0172224747E+00, 3.1237030007E+00, 7.0032568920E-01, 5.2894759324E-01, 8.4444453759E-01],
	[3.3280000000E+04, 7.0189239664E+00, 3.1236906353E+00, 7.0064867456E-01, 5.2914114014E-01, 8.4447622982E-01],
	[3.3285000000E+04, 7.0206256150E+00, 3.1236782718E+00, 7.0097176025E-01, 5.2933471224E-01, 8.4450791565E-01],
	[3.3290000000E+04, 7.0223274204E+00, 3.1236659102E+00, 7.0129494627E-01, 5.2952830951E-01, 8.4453959507E-01],
	[3.3295000000E+04, 7.0240293826E+00, 3.1236535505E+00, 7.0161823265E-01, 5.2972193195E-01, 8.4457126809E-01],
	[3.3300000000E+04, 7.0257315017E+00, 3.1236411928E+00, 7.0194161940E-01, 5.2991557954E-01, 8.4460293471E-01],
	[3.3305000000E+04, 7.0274337776E+00, 3.1236288369E+00, 7.0226510653E-01, 5.3010925227E-01, 8.4463459492E-01],
	[3.3310000000E+04, 7.0291362104E+00, 3.1236164829E+00, 7.0258869407E-01, 5.3030295012E-01, 8.4466624874E-01],
	[3.3315000000E+04, 7.0308387999E+00, 3.1236041309E+00, 7.0291238202E-01, 5.3049667310E-01, 8.4469789616E-01],
	[3.3320000000E+04, 7.0325415462E+00, 3.1235917807E+00, 7.0323617041E-01, 5.3069042117E-01, 8.4472953719E-01],
	[3.3325000000E+04, 7.0342444493E+00, 3.1235794325E+00, 7.0356005925E-01, 5.3088419434E-01, 8.4476117182E-01],
	[3.3330000000E+04, 7.0359475092E+00, 3.1235670861E+00, 7.0388404856E-01, 5.3107799259E-01, 8.4479280006E-01],
	[3.3335000000E+04, 7.0376507259E+00, 3.1235547417E+00, 7.0420813835E-01, 5.3127181591E-01, 8.4482442191E-01],
	[3.3340000000E+04, 7.0393540993E+00, 3.1235423991E+00, 7.0453232863E-01, 5.3146566428E-01, 8.4485603737E-01],
	[3.3345000000E+04, 7.0410576295E+00, 3.1235300585E+00, 7.0485661943E-01, 5.3165953769E-01, 8.4488764645E-01],
	[3.3350000000E+04, 7.0427613164E+00, 3.1235177197E+00, 7.0518101077E-01, 5.3185343613E-01, 8.4491924913E-01],
	[3.3355000000E+04, 7.0444651600E+00, 3.1235053829E+00, 7.0550550264E-01, 5.3204735960E-01, 8.4495084543E-01],
	[3.3360000000E+04, 7.0461691604E+00, 3.1234930479E+00, 7.0583009508E-01, 5.3224130806E-01, 8.4498243535E-01],
	[3.3365000000E+04, 7.0478733175E+00, 3.1234807149E+00, 7.0615478810E-01, 5.3243528152E-01, 8.4501401889E-01],
	[3.3370000000E+04, 7.0495776313E+00, 3.1234683837E+00, 7.0647958172E-01, 5.3262927997E-01, 8.4504559604E-01],
	[3.3375000000E+04, 7.0512821018E+00, 3.1234560544E+00, 7.0680447594E-01, 5.3282330338E-01, 8.4507716682E-01],
	[3.3380000000E+04, 7.0529867290E+00, 3.1234437271E+00, 7.0712947080E-01, 5.3301735175E-01, 8.4510873122E-01],
	[3.3385000000E+04, 7.0546915128E+00, 3.1234314016E+00, 7.0745456629E-01, 5.3321142506E-01, 8.4514028924E-01],
	[3.3390000000E+04, 7.0563964534E+00, 3.1234190780E+00, 7.0777976244E-01, 5.3340552330E-01, 8.4517184089E-01],
	[3.3395000000E+04, 7.0581015505E+00, 3.1234067563E+00, 7.0810505927E-01, 5.3359964647E-01, 8.4520338616E-01],
	[3.3400000000E+04, 7.0598068044E+00, 3.1233944366E+00, 7.0843045679E-01, 5.3379379454E-01, 8.4523492507E-01],
	[3.3405000000E+04, 7.0615122149E+00, 3.1233821187E+00, 7.0875595502E-01, 5.3398796751E-01, 8.4526645760E-01],
	[3.3410000000E+04, 7.0632177820E+00, 3.1233698026E+00, 7.0908155397E-01, 5.3418216536E-01, 8.4529798377E-01],
	[3.3415000000E+04, 7.0649235057E+00, 3.1233574885E+00, 7.0940725366E-01, 5.3437638809E-01, 8.4532950357E-01],
	[3.3420000000E+04, 7.0666293861E+00, 3.1233451763E+00, 7.0973305411E-01, 5.3457063567E-01, 8.4536101700E-01],
	[3.3425000000E+04, 7.0683354230E+00, 3.1233328660E+00, 7.1005895532E-01, 5.3476490810E-01, 8.4539252407E-01],
	[3.3430000000E+04, 7.0700416166E+00, 3.1233205575E+00, 7.1038495733E-01, 5.3495920536E-01, 8.4542402478E-01],
	[3.3435000000E+04, 7.0717479667E+00, 3.1233082510E+00, 7.1071106013E-01, 5.3515352744E-01, 8.4545551912E-01],
	[3.3440000000E+04, 7.0734544735E+00, 3.1232959463E+00, 7.1103726376E-01, 5.3534787434E-01, 8.4548700711E-01],
	[3.3445000000E+04, 7.0751611367E+00, 3.1232836435E+00, 7.1136356822E-01, 5.3554224603E-01, 8.4551848874E-01],
	[3.3450000000E+04, 7.0768709821E+00, 3.1232730622E+00, 7.1168997354E-01, 5.3573671044E-01, 8.4554996401E-01],
	[3.3455000000E+04, 7.0785811279E+00, 3.1232625636E+00, 7.1201647972E-01, 5.3593120291E-01, 8.4558143293E-01],
	[3.3460000000E+04, 7.0802914312E+00, 3.1232520666E+00, 7.1234308678E-01, 5.3612572022E-01, 8.4561289549E-01],
	[3.3465000000E+04, 7.0820018922E+00, 3.1232415712E+00, 7.1266979475E-01, 5.3632026237E-01, 8.4564435170E-01],
	[3.3470000000E+04, 7.0837125107E+00, 3.1232310775E+00, 7.1299660363E-01, 5.3651482934E-01, 8.4567580156E-01],
	[3.3475000000E+04, 7.0854232869E+00, 3.1232205853E+00, 7.1332351344E-01, 5.3670942111E-01, 8.4570724508E-01],
	[3.3480000000E+04, 7.0871342205E+00, 3.1232100948E+00, 7.1365052420E-01, 5.3690403769E-01, 8.4573868224E-01],
	[3.3485000000E+04, 7.0888453118E+00, 3.1231996058E+00, 7.1397763593E-01, 5.3709867904E-01, 8.4577011306E-01],
	[3.3490000000E+04, 7.0905565605E+00, 3.1231891184E+00, 7.1430484863E-01, 5.3729334517E-01, 8.4580153753E-01],
	[3.3495000000E+04, 7.0922679668E+00, 3.1231786327E+00, 7.1463216233E-01, 5.3748803605E-01, 8.4583295566E-01],
	[3.3500000000E+04, 7.0939795307E+00, 3.1231681485E+00, 7.1495957704E-01, 5.3768275169E-01, 8.4586436745E-01],
	[3.3505000000E+04, 7.0956912520E+00, 3.1231576660E+00, 7.1528709279E-01, 5.3787749205E-01, 8.4589577290E-01],
	[3.3510000000E+04, 7.0974031309E+00, 3.1231471850E+00, 7.1561470957E-01, 5.3807225714E-01, 8.4592717201E-01],
	[3.3515000000E+04, 7.0991151673E+00, 3.1231367056E+00, 7.1594242742E-01, 5.3826704694E-01, 8.4595856479E-01],
	[3.3520000000E+04, 7.1008273611E+00, 3.1231262279E+00, 7.1627024634E-01, 5.3846186144E-01, 8.4598995122E-01],
	[3.3525000000E+04, 7.1025397125E+00, 3.1231157517E+00, 7.1659816635E-01, 5.3865670062E-01, 8.4602133133E-01],
	[3.3530000000E+04, 7.1042522213E+00, 3.1231052772E+00, 7.1692618748E-01, 5.3885156448E-01, 8.4605270510E-01],
	[3.3535000000E+04, 7.1059648875E+00, 3.1230948042E+00, 7.1725430972E-01, 5.3904645300E-01, 8.4608407254E-01],
	[3.3540000000E+04, 7.1076777113E+00, 3.1230843328E+00, 7.1758253311E-01, 5.3924136616E-01, 8.4611543365E-01],
	[3.3545000000E+04, 7.1093906924E+00, 3.1230738630E+00, 7.1791085765E-01, 5.3943630396E-01, 8.4614678843E-01],
	[3.3550000000E+04, 7.1111038311E+00, 3.1230633949E+00, 7.1823928337E-01, 5.3963126639E-01, 8.4617813689E-01],
	[3.3555000000E+04, 7.1128171271E+00, 3.1230529283E+00, 7.1856781028E-01, 5.3982625343E-01, 8.4620947902E-01],
	[3.3560000000E+04, 7.1145305806E+00, 3.1230424633E+00, 7.1889643839E-01, 5.4002126506E-01, 8.4624081482E-01],
	[3.3565000000E+04, 7.1162441914E+00, 3.1230319999E+00, 7.1922516772E-01, 5.4021630129E-01, 8.4627214431E-01],
	[3.3570000000E+04, 7.1179579597E+00, 3.1230215381E+00, 7.1955399829E-01, 5.4041136208E-01, 8.4630346747E-01],
	[3.3575000000E+04, 7.1196718853E+00, 3.1230110779E+00, 7.1988293011E-01, 5.4060644745E-01, 8.4633478431E-01],
	[3.3580000000E+04, 7.1213859684E+00, 3.1230006192E+00, 7.2021196320E-01, 5.4080155736E-01, 8.4636609484E-01],
	[3.3585000000E+04, 7.1231002088E+00, 3.1229901622E+00, 7.2054109758E-01, 5.4099669181E-01, 8.4639739905E-01],
	[3.3590000000E+04, 7.1248146066E+00, 3.1229797068E+00, 7.2087033325E-01, 5.4119185078E-01, 8.4642869695E-01],
	[3.3595000000E+04, 7.1265291617E+00, 3.1229692529E+00, 7.2119967025E-01, 5.4138703427E-01, 8.4645998853E-01],
	[3.3600000000E+04, 7.1282438742E+00, 3.1229588007E+00, 7.2152910857E-01, 5.4158224226E-01, 8.4649127380E-01],
	[3.3605000000E+04, 7.1299587440E+00, 3.1229483500E+00, 7.2185864825E-01, 5.4177747474E-01, 8.4652255276E-01],
	[3.3610000000E+04, 7.1316737712E+00, 3.1229379010E+00, 7.2218828929E-01, 5.4197273170E-01, 8.4655382541E-01],
	[3.3615000000E+04, 7.1333889557E+00, 3.1229274535E+00, 7.2251803172E-01, 5.4216801312E-01, 8.4658509175E-01],
	[3.3620000000E+04, 7.1351042974E+00, 3.1229170076E+00, 7.2284787554E-01, 5.4236331899E-01, 8.4661635179E-01],
	[3.3625000000E+04, 7.1368197965E+00, 3.1229065633E+00, 7.2317782077E-01, 5.4255864930E-01, 8.4664760552E-01],
	[3.3630000000E+04, 7.1385354529E+00, 3.1228961206E+00, 7.2350786744E-01, 5.4275400404E-01, 8.4667885295E-01],
	[3.3635000000E+04, 7.1402512666E+00, 3.1228856794E+00, 7.2383801554E-01, 5.4294938319E-01, 8.4671009408E-01],
	[3.3640000000E+04, 7.1419672375E+00, 3.1228752399E+00, 7.2416826512E-01, 5.4314478674E-01, 8.4674132891E-01],
	[3.3645000000E+04, 7.1436833657E+00, 3.1228648019E+00, 7.2449861617E-01, 5.4334021469E-01, 8.4677255744E-01],
	[3.3650000000E+04, 7.1453996512E+00, 3.1228543656E+00, 7.2482906871E-01, 5.4353566701E-01, 8.4680377967E-01],
	[3.3655000000E+04, 7.1471160939E+00, 3.1228439308E+00, 7.2515962276E-01, 5.4373114370E-01, 8.4683499561E-01],
	[3.3660000000E+04, 7.1488326938E+00, 3.1228334976E+00, 7.2549027834E-01, 5.4392664475E-01, 8.4686620525E-01],
	[3.3665000000E+04, 7.1505494510E+00, 3.1228230660E+00, 7.2582103546E-01, 5.4412217013E-01, 8.4689740860E-01],
	[3.3670000000E+04, 7.1522663654E+00, 3.1228126359E+00, 7.2615189414E-01, 5.4431771984E-01, 8.4692860566E-01],
	[3.3675000000E+04, 7.1539834370E+00, 3.1228022075E+00, 7.2648285439E-01, 5.4451329387E-01, 8.4695979643E-01],
	[3.3680000000E+04, 7.1557006658E+00, 3.1227917806E+00, 7.2681391624E-01, 5.4470889220E-01, 8.4699098091E-01],
	[3.3685000000E+04, 7.1574180518E+00, 3.1227813553E+00, 7.2714507969E-01, 5.4490451483E-01, 8.4702215910E-01],
	[3.3690000000E+04, 7.1591355950E+00, 3.1227709316E+00, 7.2747634476E-01, 5.4510016173E-01, 8.4705333101E-01],
	[3.3695000000E+04, 7.1608532954E+00, 3.1227605095E+00, 7.2780771147E-01, 5.4529583290E-01, 8.4708449664E-01],
	[3.3700000000E+04, 7.1625711529E+00, 3.1227500890E+00, 7.2813917983E-01, 5.4549152832E-01, 8.4711565598E-01],
	[3.3705000000E+04, 7.1642891676E+00, 3.1227396700E+00, 7.2847074987E-01, 5.4568724799E-01, 8.4714680905E-01],
	[3.3710000000E+04, 7.1660073395E+00, 3.1227292526E+00, 7.2880242159E-01, 5.4588299189E-01, 8.4717795583E-01],
	[3.3715000000E+04, 7.1677256685E+00, 3.1227188368E+00, 7.2913419501E-01, 5.4607876000E-01, 8.4720909633E-01],
	[3.3720000000E+04, 7.1694441546E+00, 3.1227084226E+00, 7.2946607016E-01, 5.4627455232E-01, 8.4724023056E-01],
	[3.3725000000E+04, 7.1711627978E+00, 3.1226980100E+00, 7.2979804703E-01, 5.4647036884E-01, 8.4727135852E-01],
	[3.3730000000E+04, 7.1728815982E+00, 3.1226875989E+00, 7.3013012566E-01, 5.4666620953E-01, 8.4730248020E-01],
	[3.3735000000E+04, 7.1746005556E+00, 3.1226771894E+00, 7.3046230606E-01, 5.4686207439E-01, 8.4733359560E-01],
	[3.3740000000E+04, 7.1763196702E+00, 3.1226667815E+00, 7.3079458823E-01, 5.4705796341E-01, 8.4736470474E-01],
	[3.3745000000E+04, 7.1780389418E+00, 3.1226563752E+00, 7.3112697221E-01, 5.4725387657E-01, 8.4739580761E-01],
	[3.3750000000E+04, 7.1797583706E+00, 3.1226459705E+00, 7.3145945800E-01, 5.4744981386E-01, 8.4742690421E-01],
	[3.3755000000E+04, 7.1814779564E+00, 3.1226355673E+00, 7.3179204563E-01, 5.4764577527E-01, 8.4745799455E-01],
	[3.3760000000E+04, 7.1831976992E+00, 3.1226251657E+00, 7.3212473510E-01, 5.4784176078E-01, 8.4748907862E-01],
	[3.3765000000E+04, 7.1849175991E+00, 3.1226147657E+00, 7.3245752643E-01, 5.4803777039E-01, 8.4752015642E-01],
	[3.3770000000E+04, 7.1866376561E+00, 3.1226043672E+00, 7.3279041964E-01, 5.4823380409E-01, 8.4755122797E-01],
	[3.3775000000E+04, 7.1883578700E+00, 3.1225939703E+00, 7.3312341475E-01, 5.4842986185E-01, 8.4758229325E-01],
	[3.3780000000E+04, 7.1900782411E+00, 3.1225835750E+00, 7.3345651177E-01, 5.4862594367E-01, 8.4761335228E-01],
	[3.3785000000E+04, 7.1917987691E+00, 3.1225731813E+00, 7.3378971072E-01, 5.4882204953E-01, 8.4764440505E-01],
	[3.3790000000E+04, 7.1935194541E+00, 3.1225627891E+00, 7.3412301161E-01, 5.4901817942E-01, 8.4767545156E-01],
	[3.3795000000E+04, 7.1952402961E+00, 3.1225523986E+00, 7.3445641446E-01, 5.4921433334E-01, 8.4770649182E-01],
	[3.3800000000E+04, 7.1969612952E+00, 3.1225420096E+00, 7.3478991929E-01, 5.4941051126E-01, 8.4773752583E-01],
	[3.3805000000E+04, 7.1986824511E+00, 3.1225316221E+00, 7.3512352610E-01, 5.4960671317E-01, 8.4776855358E-01],
	[3.3810000000E+04, 7.2004037641E+00, 3.1225212362E+00, 7.3545723493E-01, 5.4980293907E-01, 8.4779957509E-01],
	[3.3815000000E+04, 7.2021252340E+00, 3.1225108519E+00, 7.3579104578E-01, 5.4999918894E-01, 8.4783059034E-01],
	[3.3820000000E+04, 7.2038468609E+00, 3.1225004692E+00, 7.3612495867E-01, 5.5019546277E-01, 8.4786159935E-01],
	[3.3825000000E+04, 7.2055686448E+00, 3.1224900880E+00, 7.3645897361E-01, 5.5039176054E-01, 8.4789260212E-01],
	[3.3830000000E+04, 7.2072905855E+00, 3.1224797085E+00, 7.3679309063E-01, 5.5058808224E-01, 8.4792359864E-01],
	[3.3835000000E+04, 7.2090126832E+00, 3.1224693304E+00, 7.3712730974E-01, 5.5078442787E-01, 8.4795458891E-01],
	[3.3840000000E+04, 7.2107349378E+00, 3.1224589540E+00, 7.3746163094E-01, 5.5098079740E-01, 8.4798557295E-01],
	[3.3845000000E+04, 7.2124573494E+00, 3.1224485791E+00, 7.3779605427E-01, 5.5117719083E-01, 8.4801655074E-01],
	[3.3850000000E+04, 7.2141799178E+00, 3.1224382058E+00, 7.3813057974E-01, 5.5137360814E-01, 8.4804752230E-01],
	[3.3855000000E+04, 7.2159026431E+00, 3.1224278340E+00, 7.3846520736E-01, 5.5157004932E-01, 8.4807848762E-01],
	[3.3860000000E+04, 7.2176255253E+00, 3.1224174638E+00, 7.3879993715E-01, 5.5176651437E-01, 8.4810944671E-01],
	[3.3865000000E+04, 7.2193485643E+00, 3.1224070952E+00, 7.3913476912E-01, 5.5196300325E-01, 8.4814039956E-01],
	[3.3870000000E+04, 7.2210717603E+00, 3.1223967281E+00, 7.3946970329E-01, 5.5215951598E-01, 8.4817134618E-01],
	[3.3875000000E+04, 7.2227951131E+00, 3.1223863627E+00, 7.3980473968E-01, 5.5235605252E-01, 8.4820228657E-01],
	[3.3880000000E+04, 7.2245186227E+00, 3.1223759987E+00, 7.4013987830E-01, 5.5255261287E-01, 8.4823322073E-01],
	[3.3885000000E+04, 7.2262422892E+00, 3.1223656364E+00, 7.4047511917E-01, 5.5274919702E-01, 8.4826414866E-01],
	[3.3890000000E+04, 7.2279661125E+00, 3.1223552756E+00, 7.4081046230E-01, 5.5294580495E-01, 8.4829507036E-01],
	[3.3895000000E+04, 7.2296900926E+00, 3.1223449163E+00, 7.4114590772E-01, 5.5314243665E-01, 8.4832598584E-01],
	[3.3900000000E+04, 7.2314142295E+00, 3.1223345586E+00, 7.4148145543E-01, 5.5333909212E-01, 8.4835689510E-01],
	[3.3905000000E+04, 7.2331385233E+00, 3.1223242025E+00, 7.4181710546E-01, 5.5353577133E-01, 8.4838779813E-01],
	[3.3910000000E+04, 7.2348629738E+00, 3.1223138480E+00, 7.4215285781E-01, 5.5373247427E-01, 8.4841869494E-01],
	[3.3915000000E+04, 7.2365875811E+00, 3.1223034950E+00, 7.4248871251E-01, 5.5392920094E-01, 8.4844958554E-01],
	[3.3920000000E+04, 7.2383123452E+00, 3.1222931436E+00, 7.4282466957E-01, 5.5412595131E-01, 8.4848046991E-01],
	[3.3925000000E+04, 7.2400372661E+00, 3.1222827937E+00, 7.4316072901E-01, 5.5432272538E-01, 8.4851134807E-01],
	[3.3930000000E+04, 7.2417623437E+00, 3.1222724454E+00, 7.4349689084E-01, 5.5451952314E-01, 8.4854222002E-01],
	[3.3935000000E+04, 7.2434875780E+00, 3.1222620986E+00, 7.4383315508E-01, 5.5471634457E-01, 8.4857308575E-01],
	[3.3940000000E+04, 7.2452129691E+00, 3.1222517534E+00, 7.4416952175E-01, 5.5491318966E-01, 8.4860394527E-01],
	[3.3945000000E+04, 7.2469385170E+00, 3.1222414098E+00, 7.4450599086E-01, 5.5511005840E-01, 8.4863479858E-01],
	[3.3950000000E+04, 7.2486642215E+00, 3.1222310677E+00, 7.4484256242E-01, 5.5530695077E-01, 8.4866564568E-01],
	[3.3955000000E+04, 7.2503900828E+00, 3.1222207272E+00, 7.4517923646E-01, 5.5550386676E-01, 8.4869648657E-01],
	[3.3960000000E+04, 7.2521161008E+00, 3.1222103882E+00, 7.4551601299E-01, 5.5570080636E-01, 8.4872732126E-01],
	[3.3965000000E+04, 7.2538422755E+00, 3.1222000508E+00, 7.4585289203E-01, 5.5589776957E-01, 8.4875814974E-01],
	[3.3970000000E+04, 7.2555686068E+00, 3.1221897150E+00, 7.4618987358E-01, 5.5609475635E-01, 8.4878897202E-01],
	[3.3975000000E+04, 7.2572950949E+00, 3.1221793807E+00, 7.4652695768E-01, 5.5629176671E-01, 8.4881978809E-01],
	[3.3980000000E+04, 7.2590217396E+00, 3.1221690479E+00, 7.4686414433E-01, 5.5648880063E-01, 8.4885059797E-01],
	[3.3985000000E+04, 7.2607495245E+00, 3.1221591940E+00, 7.4720143354E-01, 5.5668587905E-01, 8.4888140165E-01],
	[3.3990000000E+04, 7.2624801205E+00, 3.1221506290E+00, 7.4753882535E-01, 5.5688303759E-01, 8.4891219913E-01],
	[3.3995000000E+04, 7.2642108743E+00, 3.1221420653E+00, 7.4787631976E-01, 5.5708021975E-01, 8.4894299041E-01],
	[3.4000000000E+04, 7.2659417860E+00, 3.1221335029E+00, 7.4821391678E-01, 5.5727742551E-01, 8.4897377550E-01],
	[3.4005000000E+04, 7.2676728555E+00, 3.1221249418E+00, 7.4855161644E-01, 5.5747465485E-01, 8.4900455440E-01],
	[3.4010000000E+04, 7.2694040828E+00, 3.1221163820E+00, 7.4888941875E-01, 5.5767190777E-01, 8.4903532710E-01],
	[3.4015000000E+04, 7.2711354679E+00, 3.1221078235E+00, 7.4922732373E-01, 5.5786918425E-01, 8.4906609362E-01],
	[3.4020000000E+04, 7.2728670108E+00, 3.1220992662E+00, 7.4956533139E-01, 5.5806648428E-01, 8.4909685394E-01],
	[3.4025000000E+04, 7.2745987115E+00, 3.1220907102E+00, 7.4990344175E-01, 5.5826380784E-01, 8.4912760808E-01],
	[3.4030000000E+04, 7.2763305700E+00, 3.1220821555E+00, 7.5024165482E-01, 5.5846115493E-01, 8.4915835603E-01],
	[3.4035000000E+04, 7.2780625863E+00, 3.1220736021E+00, 7.5057997062E-01, 5.5865852553E-01, 8.4918909780E-01],
	[3.4040000000E+04, 7.2797947603E+00, 3.1220650499E+00, 7.5091838917E-01, 5.5885591963E-01, 8.4921983339E-01],
	[3.4045000000E+04, 7.2815270920E+00, 3.1220564991E+00, 7.5125691049E-01, 5.5905333722E-01, 8.4925056279E-01],
	[3.4050000000E+04, 7.2832595815E+00, 3.1220479495E+00, 7.5159553458E-01, 5.5925077828E-01, 8.4928128602E-01],
	[3.4055000000E+04, 7.2849922288E+00, 3.1220394012E+00, 7.5193426146E-01, 5.5944824281E-01, 8.4931200306E-01],
	[3.4060000000E+04, 7.2867250337E+00, 3.1220308542E+00, 7.5227309116E-01, 5.5964573078E-01, 8.4934271393E-01],
	[3.4065000000E+04, 7.2884579964E+00, 3.1220223084E+00, 7.5261202369E-01, 5.5984324219E-01, 8.4937341863E-01],
	[3.4070000000E+04, 7.2901911168E+00, 3.1220137640E+00, 7.5295105906E-01, 5.6004077703E-01, 8.4940411714E-01],
	[3.4075000000E+04, 7.2919243949E+00, 3.1220052208E+00, 7.5329019729E-01, 5.6023833528E-01, 8.4943480949E-01],
	[3.4080000000E+04, 7.2936578307E+00, 3.1219966788E+00, 7.5362943839E-01, 5.6043591693E-01, 8.4946549567E-01],
	[3.4085000000E+04, 7.2953914241E+00, 3.1219881382E+00, 7.5396878238E-01, 5.6063352197E-01, 8.4949617567E-01],
	[3.4090000000E+04, 7.2971251753E+00, 3.1219795988E+00, 7.5430822929E-01, 5.6083115038E-01, 8.4952684951E-01],
	[3.4095000000E+04, 7.2988590840E+00, 3.1219710608E+00, 7.5464777911E-01, 5.6102880216E-01, 8.4955751718E-01],
	[3.4100000000E+04, 7.3005931505E+00, 3.1219625239E+00, 7.5498743188E-01, 5.6122647728E-01, 8.4958817868E-01],
	[3.4105000000E+04, 7.3023273746E+00, 3.1219539884E+00, 7.5532718760E-01, 5.6142417574E-01, 8.4961883402E-01],
	[3.4110000000E+04, 7.3040617563E+00, 3.1219454541E+00, 7.5566704629E-01, 5.6162189753E-01, 8.4964948320E-01],
	[3.4115000000E+04, 7.3057962957E+00, 3.1219369212E+00, 7.5600700798E-01, 5.6181964263E-01, 8.4968012622E-01],
	[3.4120000000E+04, 7.3075309927E+00, 3.1219283894E+00, 7.5634707266E-01, 5.6201741104E-01, 8.4971076307E-01],
	[3.4125000000E+04, 7.3092658473E+00, 3.1219198590E+00, 7.5668724037E-01, 5.6221520273E-01, 8.4974139377E-01],
	[3.4130000000E+04, 7.3110008595E+00, 3.1219113298E+00, 7.5702751111E-01, 5.6241301769E-01, 8.4977201831E-01],
	[3.4135000000E+04, 7.3127360293E+00, 3.1219028019E+00, 7.5736788490E-01, 5.6261085592E-01, 8.4980263670E-01],
	[3.4140000000E+04, 7.3144713566E+00, 3.1218942753E+00, 7.5770836176E-01, 5.6280871740E-01, 8.4983324893E-01],
	[3.4145000000E+04, 7.3162068416E+00, 3.1218857500E+00, 7.5804894171E-01, 5.6300660212E-01, 8.4986385501E-01],
	[3.4150000000E+04, 7.3179424841E+00, 3.1218772259E+00, 7.5838962476E-01, 5.6320451006E-01, 8.4989445494E-01],
	[3.4155000000E+04, 7.3196782842E+00, 3.1218687031E+00, 7.5873041092E-01, 5.6340244122E-01, 8.4992504872E-01],
	[3.4160000000E+04, 7.3214142418E+00, 3.1218601815E+00, 7.5907130022E-01, 5.6360039557E-01, 8.4995563635E-01],
	[3.4165000000E+04, 7.3231503570E+00, 3.1218516613E+00, 7.5941229266E-01, 5.6379837312E-01, 8.4998621784E-01],
	[3.4170000000E+04, 7.3248866297E+00, 3.1218431423E+00, 7.5975338827E-01, 5.6399637384E-01, 8.5001679318E-01],
	[3.4175000000E+04, 7.3266230599E+00, 3.1218346245E+00, 7.6009458706E-01, 5.6419439772E-01, 8.5004736237E-01],
	[3.4180000000E+04, 7.3283596477E+00, 3.1218261081E+00, 7.6043588905E-01, 5.6439244476E-01, 8.5007792542E-01],
	[3.4185000000E+04, 7.3300963929E+00, 3.1218175929E+00, 7.6077729425E-01, 5.6459051493E-01, 8.5010848234E-01],
	[3.4190000000E+04, 7.3318332957E+00, 3.1218090790E+00, 7.6111880267E-01, 5.6478860823E-01, 8.5013903311E-01],
	[3.4195000000E+04, 7.3335703559E+00, 3.1218005663E+00, 7.6146041435E-01, 5.6498672464E-01, 8.5016957774E-01],
	[3.4200000000E+04, 7.3353075736E+00, 3.1217920549E+00, 7.6180212928E-01, 5.6518486415E-01, 8.5020011624E-01],
	[3.4205000000E+04, 7.3370449488E+00, 3.1217835448E+00, 7.6214394749E-01, 5.6538302676E-01, 8.5023064860E-01],
	[3.4210000000E+04, 7.3387824814E+00, 3.1217750360E+00, 7.6248586900E-01, 5.6558121243E-01, 8.5026117483E-01],
	[3.4215000000E+04, 7.3405201715E+00, 3.1217665284E+00, 7.6282789382E-01, 5.6577942117E-01, 8.5029169493E-01],
	[3.4220000000E+04, 7.3422580191E+00, 3.1217580221E+00, 7.6317002196E-01, 5.6597765297E-01, 8.5032220889E-01],
	[3.4225000000E+04, 7.3439960241E+00, 3.1217495170E+00, 7.6351225344E-01, 5.6617590780E-01, 8.5035271673E-01],
	[3.4230000000E+04, 7.3457341865E+00, 3.1217410132E+00, 7.6385458828E-01, 5.6637418565E-01, 8.5038321844E-01],
	[3.4235000000E+04, 7.3474725063E+00, 3.1217325107E+00, 7.6419702649E-01, 5.6657248652E-01, 8.5041371402E-01],
	[3.4240000000E+04, 7.3492109835E+00, 3.1217240095E+00, 7.6453956809E-01, 5.6677081039E-01, 8.5044420348E-01],
	[3.4245000000E+04, 7.3509496182E+00, 3.1217155095E+00, 7.6488221310E-01, 5.6696915725E-01, 8.5047468681E-01],
	[3.4250000000E+04, 7.3526884102E+00, 3.1217070108E+00, 7.6522496153E-01, 5.6716752709E-01, 8.5050516402E-01],
	[3.4255000000E+04, 7.3544273596E+00, 3.1216985133E+00, 7.6556781340E-01, 5.6736591989E-01, 8.5053563511E-01],
	[3.4260000000E+04, 7.3561664664E+00, 3.1216900171E+00, 7.6591076872E-01, 5.6756433563E-01, 8.5056610008E-01],
	[3.4265000000E+04, 7.3579057306E+00, 3.1216815222E+00, 7.6625382752E-01, 5.6776277432E-01, 8.5059655893E-01],
	[3.4270000000E+04, 7.3596451521E+00, 3.1216730285E+00, 7.6659698979E-01, 5.6796123594E-01, 8.5062701167E-01],
	[3.4275000000E+04, 7.3613847309E+00, 3.1216645361E+00, 7.6694025558E-01, 5.6815972046E-01, 8.5065745829E-01],
	[3.4280000000E+04, 7.3631244671E+00, 3.1216560449E+00, 7.6728362488E-01, 5.6835822789E-01, 8.5068789879E-01],
	[3.4285000000E+04, 7.3648643607E+00, 3.1216475550E+00, 7.6762709771E-01, 5.6855675821E-01, 8.5071833319E-01],
	[3.4290000000E+04, 7.3666044115E+00, 3.1216390664E+00, 7.6797067409E-01, 5.6875531140E-01, 8.5074876147E-01],
	[3.4295000000E+04, 7.3683446197E+00, 3.1216305790E+00, 7.6831435405E-01, 5.6895388746E-01, 8.5077918365E-01],
	[3.4300000000E+04, 7.3700849852E+00, 3.1216220929E+00, 7.6865813758E-01, 5.6915248636E-01, 8.5080959971E-01],
	[3.4305000000E+04, 7.3718255080E+00, 3.1216136081E+00, 7.6900202471E-01, 5.6935110811E-01, 8.5084000967E-01],
	[3.4310000000E+04, 7.3735661880E+00, 3.1216051245E+00, 7.6934601546E-01, 5.6954975268E-01, 8.5087041353E-01],
	[3.4315000000E+04, 7.3753070254E+00, 3.1215966422E+00, 7.6969010984E-01, 5.6974842006E-01, 8.5090081128E-01],
	[3.4320000000E+04, 7.3770480200E+00, 3.1215881611E+00, 7.7003430786E-01, 5.6994711024E-01, 8.5093120293E-01],
	[3.4325000000E+04, 7.3787891718E+00, 3.1215796813E+00, 7.7037860955E-01, 5.7014582322E-01, 8.5096158848E-01],
	[3.4330000000E+04, 7.3805304810E+00, 3.1215712027E+00, 7.7072301492E-01, 5.7034455897E-01, 8.5099196792E-01],
	[3.4335000000E+04, 7.3822719473E+00, 3.1215627255E+00, 7.7106752398E-01, 5.7054331748E-01, 8.5102234127E-01],
	[3.4340000000E+04, 7.3840135709E+00, 3.1215542494E+00, 7.7141213675E-01, 5.7074209874E-01, 8.5105270853E-01],
	[3.4345000000E+04, 7.3857553518E+00, 3.1215457746E+00, 7.7175685326E-01, 5.7094090274E-01, 8.5108306969E-01],
	[3.4350000000E+04, 7.3874972898E+00, 3.1215373011E+00, 7.7210167350E-01, 5.7113972946E-01, 8.5111342475E-01],
	[3.4355000000E+04, 7.3892393851E+00, 3.1215288289E+00, 7.7244659751E-01, 5.7133857890E-01, 8.5114377373E-01],
	[3.4360000000E+04, 7.3909816375E+00, 3.1215203578E+00, 7.7279162528E-01, 5.7153745104E-01, 8.5117411661E-01],
	[3.4365000000E+04, 7.3927240472E+00, 3.1215118881E+00, 7.7313675686E-01, 5.7173634587E-01, 8.5120445340E-01],
	[3.4370000000E+04, 7.3944666140E+00, 3.1215034196E+00, 7.7348199224E-01, 5.7193526337E-01, 8.5123478411E-01],
	[3.4375000000E+04, 7.3962093380E+00, 3.1214949523E+00, 7.7382733144E-01, 5.7213420354E-01, 8.5126510873E-01],
	[3.4380000000E+04, 7.3979522192E+00, 3.1214864864E+00, 7.7417277448E-01, 5.7233316635E-01, 8.5129542726E-01],
	[3.4385000000E+04, 7.3996952575E+00, 3.1214780216E+00, 7.7451832138E-01, 5.7253215181E-01, 8.5132573971E-01],
	[3.4390000000E+04, 7.4014384530E+00, 3.1214695581E+00, 7.7486397215E-01, 5.7273115988E-01, 8.5135604608E-01],
	[3.4395000000E+04, 7.4031818056E+00, 3.1214610959E+00, 7.7520972681E-01, 5.7293019057E-01, 8.5138634637E-01],
	[3.4400000000E+04, 7.4049253154E+00, 3.1214526349E+00, 7.7555558538E-01, 5.7312924387E-01, 8.5141664058E-01],
	[3.4405000000E+04, 7.4066689822E+00, 3.1214441752E+00, 7.7590154786E-01, 5.7332831974E-01, 8.5144692871E-01],
	[3.4410000000E+04, 7.4084128062E+00, 3.1214357167E+00, 7.7624761428E-01, 5.7352741820E-01, 8.5147721076E-01],
	[3.4415000000E+04, 7.4101567873E+00, 3.1214272595E+00, 7.7659378465E-01, 5.7372653921E-01, 8.5150748674E-01],
	[3.4420000000E+04, 7.4119009255E+00, 3.1214188036E+00, 7.7694005899E-01, 5.7392568278E-01, 8.5153775664E-01],
	[3.4425000000E+04, 7.4136452208E+00, 3.1214103488E+00, 7.7728643732E-01, 5.7412484888E-01, 8.5156802048E-01],
	[3.4430000000E+04, 7.4153896732E+00, 3.1214018954E+00, 7.7763291965E-01, 5.7432403751E-01, 8.5159827824E-01],
	[3.4435000000E+04, 7.4171342826E+00, 3.1213934432E+00, 7.7797950599E-01, 5.7452324865E-01, 8.5162852993E-01],
	[3.4440000000E+04, 7.4188790491E+00, 3.1213849922E+00, 7.7832619637E-01, 5.7472248229E-01, 8.5165877555E-01],
	[3.4445000000E+04, 7.4206239726E+00, 3.1213765425E+00, 7.7867299079E-01, 5.7492173842E-01, 8.5168901511E-01],
	[3.4450000000E+04, 7.4223690532E+00, 3.1213680940E+00, 7.7901988928E-01, 5.7512101702E-01, 8.5171924860E-01],
	[3.4455000000E+04, 7.4241142908E+00, 3.1213596468E+00, 7.7936689185E-01, 5.7532031808E-01, 8.5174947603E-01],
	[3.4460000000E+04, 7.4258596855E+00, 3.1213512008E+00, 7.7971399852E-01, 5.7551964160E-01, 8.5177969740E-01],
	[3.4465000000E+04, 7.4276052371E+00, 3.1213427561E+00, 7.8006120930E-01, 5.7571898755E-01, 8.5180991270E-01],
	[3.4470000000E+04, 7.4293509458E+00, 3.1213343126E+00, 7.8040852421E-01, 5.7591835592E-01, 8.5184012195E-01],
	[3.4475000000E+04, 7.4310968115E+00, 3.1213258704E+00, 7.8075594327E-01, 5.7611774671E-01, 8.5187032514E-01],
	[3.4480000000E+04, 7.4328428342E+00, 3.1213174294E+00, 7.8110346649E-01, 5.7631715989E-01, 8.5190052227E-01],
	[3.4485000000E+04, 7.4345890138E+00, 3.1213089897E+00, 7.8145109389E-01, 5.7651659546E-01, 8.5193071335E-01],
	[3.4490000000E+04, 7.4363353505E+00, 3.1213005512E+00, 7.8179882548E-01, 5.7671605341E-01, 8.5196089837E-01],
	[3.4495000000E+04, 7.4380818441E+00, 3.1212921140E+00, 7.8214666128E-01, 5.7691553371E-01, 8.5199107734E-01],
	[3.4500000000E+04, 7.4398284946E+00, 3.1212836780E+00, 7.8249460130E-01, 5.7711503637E-01, 8.5202125026E-01],
	[3.4505000000E+04, 7.4415753021E+00, 3.1212752432E+00, 7.8284264557E-01, 5.7731456136E-01, 8.5205141713E-01],
	[3.4510000000E+04, 7.4433222666E+00, 3.1212668097E+00, 7.8319079409E-01, 5.7751410868E-01, 8.5208157795E-01],
	[3.4515000000E+04, 7.4450693879E+00, 3.1212583775E+00, 7.8353904689E-01, 5.7771367830E-01, 8.5211173272E-01],
	[3.4520000000E+04, 7.4468166662E+00, 3.1212499465E+00, 7.8388740398E-01, 5.7791327023E-01, 8.5214188145E-01],
	[3.4525000000E+04, 7.4485641015E+00, 3.1212415167E+00, 7.8423586538E-01, 5.7811288444E-01, 8.5217202414E-01],
	[3.4530000000E+04, 7.4503116936E+00, 3.1212330882E+00, 7.8458443110E-01, 5.7831252092E-01, 8.5220216078E-01],
	[3.4535000000E+04, 7.4520629505E+00, 3.1212261351E+00, 7.8493310115E-01, 5.7851225145E-01, 8.5223229139E-01],
	[3.4540000000E+04, 7.4538149734E+00, 3.1212194384E+00, 7.8528187556E-01, 5.7871201675E-01, 8.5226241595E-01],
	[3.4545000000E+04, 7.4555671546E+00, 3.1212127427E+00, 7.8563075435E-01, 5.7891180438E-01, 8.5229253447E-01],
	[3.4550000000E+04, 7.4573194939E+00, 3.1212060480E+00, 7.8597973752E-01, 5.7911161432E-01, 8.5232264696E-01],
	[3.4555000000E+04, 7.4590719915E+00, 3.1211993543E+00, 7.8632882509E-01, 5.7931144657E-01, 8.5235275341E-01],
	[3.4560000000E+04, 7.4608246472E+00, 3.1211926616E+00, 7.8667801708E-01, 5.7951130111E-01, 8.5238285383E-01],
	[3.4565000000E+04, 7.4625774611E+00, 3.1211859698E+00, 7.8702731350E-01, 5.7971117793E-01, 8.5241294822E-01],
	[3.4570000000E+04, 7.4643304332E+00, 3.1211792791E+00, 7.8737671438E-01, 5.7991107701E-01, 8.5244303657E-01],
	[3.4575000000E+04, 7.4660835635E+00, 3.1211725893E+00, 7.8772621972E-01, 5.8011099834E-01, 8.5247311890E-01],
	[3.4580000000E+04, 7.4678368519E+00, 3.1211659005E+00, 7.8807582955E-01, 5.8031094192E-01, 8.5250319520E-01],
	[3.4585000000E+04, 7.4695902985E+00, 3.1211592127E+00, 7.8842554387E-01, 5.8051090772E-01, 8.5253326547E-01],
	[3.4590000000E+04, 7.4713439032E+00, 3.1211525258E+00, 7.8877536272E-01, 5.8071089574E-01, 8.5256332971E-01],
	[3.4595000000E+04, 7.4730976660E+00, 3.1211458400E+00, 7.8912528609E-01, 5.8091090596E-01, 8.5259338793E-01],
	[3.4600000000E+04, 7.4748515870E+00, 3.1211391551E+00, 7.8947531401E-01, 5.8111093837E-01, 8.5262344013E-01],
	[3.4605000000E+04, 7.4766056660E+00, 3.1211324712E+00, 7.8982544649E-01, 5.8131099296E-01, 8.5265348630E-01],
	[3.4610000000E+04, 7.4783599032E+00, 3.1211257883E+00, 7.9017568356E-01, 5.8151106972E-01, 8.5268352646E-01],
	[3.4615000000E+04, 7.4801142985E+00, 3.1211191064E+00, 7.9052602522E-01, 5.8171116862E-01, 8.5271356060E-01],
	[3.4620000000E+04, 7.4818688519E+00, 3.1211124254E+00, 7.9087647149E-01, 5.8191128967E-01, 8.5274358872E-01],
	[3.4625000000E+04, 7.4836235633E+00, 3.1211057454E+00, 7.9122702239E-01, 5.8211143284E-01, 8.5277361083E-01],
	[3.4630000000E+04, 7.4853784328E+00, 3.1210990664E+00, 7.9157767793E-01, 5.8231159813E-01, 8.5280362692E-01],
	[3.4635000000E+04, 7.4871334604E+00, 3.1210923884E+00, 7.9192843813E-01, 5.8251178552E-01, 8.5283363700E-01],
	[3.4640000000E+04, 7.4888886460E+00, 3.1210857114E+00, 7.9227930301E-01, 5.8271199500E-01, 8.5286364106E-01],
	[3.4645000000E+04, 7.4906439897E+00, 3.1210790353E+00, 7.9263027259E-01, 5.8291222656E-01, 8.5289363912E-01],
	[3.4650000000E+04, 7.4923994914E+00, 3.1210723602E+00, 7.9298134687E-01, 5.8311248018E-01, 8.5292363117E-01],
	[3.4655000000E+04, 7.4941551512E+00, 3.1210656861E+00, 7.9333252587E-01, 5.8331275585E-01, 8.5295361721E-01],
	[3.4660000000E+04, 7.4959109689E+00, 3.1210590130E+00, 7.9368380962E-01, 5.8351305356E-01, 8.5298359725E-01],
	[3.4665000000E+04, 7.4976669447E+00, 3.1210523408E+00, 7.9403519812E-01, 5.8371337330E-01, 8.5301357128E-01],
	[3.4670000000E+04, 7.4994230785E+00, 3.1210456697E+00, 7.9438669139E-01, 5.8391371505E-01, 8.5304353931E-01],
	[3.4675000000E+04, 7.5011793703E+00, 3.1210389995E+00, 7.9473828946E-01, 5.8411407881E-01, 8.5307350134E-01],
	[3.4680000000E+04, 7.5029358200E+00, 3.1210323302E+00, 7.9508999233E-01, 5.8431446455E-01, 8.5310345736E-01],
	[3.4685000000E+04, 7.5046924277E+00, 3.1210256620E+00, 7.9544180002E-01, 5.8451487227E-01, 8.5313340739E-01],
	[3.4690000000E+04, 7.5064491934E+00, 3.1210189947E+00, 7.9579371254E-01, 5.8471530195E-01, 8.5316335142E-01],
	[3.4695000000E+04, 7.5082061171E+00, 3.1210123284E+00, 7.9614572992E-01, 5.8491575358E-01, 8.5319328946E-01],
	[3.4700000000E+04, 7.5099631987E+00, 3.1210056631E+00, 7.9649785217E-01, 5.8511622715E-01, 8.5322322150E-01],
	[3.4705000000E+04, 7.5117204383E+00, 3.1209989988E+00, 7.9685007931E-01, 5.8531672265E-01, 8.5325314754E-01],
	[3.4710000000E+04, 7.5134778358E+00, 3.1209923354E+00, 7.9720241135E-01, 5.8551724006E-01, 8.5328306760E-01],
	[3.4715000000E+04, 7.5152353912E+00, 3.1209856730E+00, 7.9755484830E-01, 5.8571777937E-01, 8.5331298167E-01],
	[3.4720000000E+04, 7.5169931045E+00, 3.1209790115E+00, 7.9790739019E-01, 5.8591834057E-01, 8.5334288974E-01],
	[3.4725000000E+04, 7.5187509757E+00, 3.1209723511E+00, 7.9826003702E-01, 5.8611892365E-01, 8.5337279183E-01],
	[3.4730000000E+04, 7.5205090049E+00, 3.1209656916E+00, 7.9861278883E-01, 5.8631952859E-01, 8.5340268794E-01],
	[3.4735000000E+04, 7.5222671919E+00, 3.1209590331E+00, 7.9896564561E-01, 5.8652015537E-01, 8.5343257805E-01],
	[3.4740000000E+04, 7.5240255368E+00, 3.1209523756E+00, 7.9931860740E-01, 5.8672080400E-01, 8.5346246219E-01],
	[3.4745000000E+04, 7.5257840396E+00, 3.1209457190E+00, 7.9967167419E-01, 5.8692147445E-01, 8.5349234034E-01],
	[3.4750000000E+04, 7.5275427002E+00, 3.1209390634E+00, 8.0002484602E-01, 5.8712216671E-01, 8.5352221251E-01],
	[3.4755000000E+04, 7.5293015187E+00, 3.1209324088E+00, 8.0037812289E-01, 5.8732288078E-01, 8.5355207871E-01],
	[3.4760000000E+04, 7.5310604951E+00, 3.1209257552E+00, 8.0073150483E-01, 5.8752361663E-01, 8.5358193892E-01],
	[3.4765000000E+04, 7.5328196293E+00, 3.1209191025E+00, 8.0108499184E-01, 5.8772437425E-01, 8.5361179316E-01],
	[3.4770000000E+04, 7.5345789213E+00, 3.1209124508E+00, 8.0143858395E-01, 5.8792515364E-01, 8.5364164143E-01],
	[3.4775000000E+04, 7.5363383712E+00, 3.1209058000E+00, 8.0179228117E-01, 5.8812595477E-01, 8.5367148372E-01],
	[3.4780000000E+04, 7.5380979788E+00, 3.1208991503E+00, 8.0214608352E-01, 5.8832677764E-01, 8.5370132004E-01],
	[3.4785000000E+04, 7.5398577443E+00, 3.1208925015E+00, 8.0249999101E-01, 5.8852762224E-01, 8.5373115039E-01],
	[3.4790000000E+04, 7.5416176676E+00, 3.1208858537E+00, 8.0285400366E-01, 5.8872848855E-01, 8.5376097477E-01],
	[3.4795000000E+04, 7.5433777486E+00, 3.1208792068E+00, 8.0320812148E-01, 5.8892937656E-01, 8.5379079318E-01],
	[3.4800000000E+04, 7.5451379875E+00, 3.1208725609E+00, 8.0356234449E-01, 5.8913028625E-01, 8.5382060562E-01],
	[3.4805000000E+04, 7.5468983841E+00, 3.1208659160E+00, 8.0391667272E-01, 5.8933121762E-01, 8.5385041210E-01],
	[3.4810000000E+04, 7.5486589384E+00, 3.1208592721E+00, 8.0427110616E-01, 5.8953217064E-01, 8.5388021262E-01],
	[3.4815000000E+04, 7.5504196506E+00, 3.1208526291E+00, 8.0462564484E-01, 5.8973314532E-01, 8.5391000717E-01],
	[3.4820000000E+04, 7.5521805204E+00, 3.1208459871E+00, 8.0498028878E-01, 5.8993414163E-01, 8.5393979577E-01],
	[3.4825000000E+04, 7.5539415480E+00, 3.1208393460E+00, 8.0533503799E-01, 5.9013515957E-01, 8.5396957840E-01],
	[3.4830000000E+04, 7.5557027334E+00, 3.1208327059E+00, 8.0568989249E-01, 5.9033619911E-01, 8.5399935508E-01],
	[3.4835000000E+04, 7.5574640764E+00, 3.1208260668E+00, 8.0604485230E-01, 5.9053726025E-01, 8.5402912580E-01],
	[3.4840000000E+04, 7.5592255772E+00, 3.1208194287E+00, 8.0639991742E-01, 5.9073834298E-01, 8.5405889056E-01],
	[3.4845000000E+04, 7.5609872357E+00, 3.1208127915E+00, 8.0675508788E-01, 5.9093944728E-01, 8.5408864937E-01],
	[3.4850000000E+04, 7.5627490518E+00, 3.1208061553E+00, 8.0711036369E-01, 5.9114057314E-01, 8.5411840223E-01],
	[3.4855000000E+04, 7.5645110257E+00, 3.1207995201E+00, 8.0746574486E-01, 5.9134172055E-01, 8.5414814913E-01],
	[3.4860000000E+04, 7.5662731572E+00, 3.1207928858E+00, 8.0782123143E-01, 5.9154288949E-01, 8.5417789009E-01],
	[3.4865000000E+04, 7.5680354464E+00, 3.1207862525E+00, 8.0817682339E-01, 5.9174407996E-01, 8.5420762509E-01],
	[3.4870000000E+04, 7.5697978933E+00, 3.1207796201E+00, 8.0853252077E-01, 5.9194529193E-01, 8.5423735416E-01],
	[3.4875000000E+04, 7.5715604978E+00, 3.1207729888E+00, 8.0888832358E-01, 5.9214652540E-01, 8.5426707727E-01],
	[3.4880000000E+04, 7.5733232599E+00, 3.1207663583E+00, 8.0924423184E-01, 5.9234778036E-01, 8.5429679444E-01],
	[3.4885000000E+04, 7.5750861797E+00, 3.1207597289E+00, 8.0960024557E-01, 5.9254905678E-01, 8.5432650567E-01],
	[3.4890000000E+04, 7.5768492572E+00, 3.1207531004E+00, 8.0995636477E-01, 5.9275035467E-01, 8.5435621096E-01],
	[3.4895000000E+04, 7.5786124922E+00, 3.1207464729E+00, 8.1031258947E-01, 5.9295167400E-01, 8.5438591030E-01],
	[3.4900000000E+04, 7.5803758848E+00, 3.1207398463E+00, 8.1066891969E-01, 5.9315301476E-01, 8.5441560371E-01],
	[3.4905000000E+04, 7.5821394351E+00, 3.1207332207E+00, 8.1102535543E-01, 5.9335437695E-01, 8.5444529118E-01],
	[3.4910000000E+04, 7.5839031429E+00, 3.1207265961E+00, 8.1138189672E-01, 5.9355576054E-01, 8.5447497272E-01],
	[3.4915000000E+04, 7.5856670084E+00, 3.1207199724E+00, 8.1173854357E-01, 5.9375716553E-01, 8.5450464832E-01],
	[3.4920000000E+04, 7.5874310314E+00, 3.1207133497E+00, 8.1209529600E-01, 5.9395859190E-01, 8.5453431799E-01],
	[3.4925000000E+04, 7.5891952119E+00, 3.1207067280E+00, 8.1245215402E-01, 5.9416003964E-01, 8.5456398172E-01],
	[3.4930000000E+04, 7.5909595501E+00, 3.1207001072E+00, 8.1280911765E-01, 5.9436150874E-01, 8.5459363953E-01],
	[3.4935000000E+04, 7.5927240457E+00, 3.1206934874E+00, 8.1316618691E-01, 5.9456299919E-01, 8.5462329141E-01],
	[3.4940000000E+04, 7.5944886990E+00, 3.1206868685E+00, 8.1352336181E-01, 5.9476451096E-01, 8.5465293736E-01],
	[3.4945000000E+04, 7.5962535097E+00, 3.1206802506E+00, 8.1388064237E-01, 5.9496604406E-01, 8.5468257738E-01],
	[3.4950000000E+04, 7.5980184780E+00, 3.1206736337E+00, 8.1423802860E-01, 5.9516759846E-01, 8.5471221148E-01],
	[3.4955000000E+04, 7.5997836038E+00, 3.1206670177E+00, 8.1459552052E-01, 5.9536917416E-01, 8.5474183965E-01],
	[3.4960000000E+04, 7.6015488871E+00, 3.1206604027E+00, 8.1495311814E-01, 5.9557077114E-01, 8.5477146191E-01],
	[3.4965000000E+04, 7.6033143279E+00, 3.1206537886E+00, 8.1531082149E-01, 5.9577238939E-01, 8.5480107824E-01],
	[3.4970000000E+04, 7.6050799262E+00, 3.1206471755E+00, 8.1566863058E-01, 5.9597402889E-01, 8.5483068865E-01],
	[3.4975000000E+04, 7.6068456820E+00, 3.1206405634E+00, 8.1602654542E-01, 5.9617568964E-01, 8.5486029315E-01],
	[3.4980000000E+04, 7.6086115952E+00, 3.1206339522E+00, 8.1638456603E-01, 5.9637737162E-01, 8.5488989173E-01],
	[3.4985000000E+04, 7.6103776659E+00, 3.1206273420E+00, 8.1674269243E-01, 5.9657907481E-01, 8.5491948439E-01],
	[3.4990000000E+04, 7.6121438941E+00, 3.1206207327E+00, 8.1710092463E-01, 5.9678079921E-01, 8.5494907114E-01],
	[3.4995000000E+04, 7.6139102797E+00, 3.1206141244E+00, 8.1745926265E-01, 5.9698254481E-01, 8.5497865198E-01],
	[3.5000000000E+04, 7.6156768228E+00, 3.1206075171E+00, 8.1781770650E-01, 5.9718431159E-01, 8.5500822691E-01],
	[3.5005000000E+04, 7.6174435233E+00, 3.1206009107E+00, 8.1817918839E-01, 5.9738766270E-01, 8.5503779593E-01],
	[3.5010000000E+04, 7.6192103812E+00, 3.1205943052E+00, 8.1854077833E-01, 5.9759103551E-01, 8.5506735904E-01],
	[3.5015000000E+04, 7.6209773965E+00, 3.1205877008E+00, 8.1890247634E-01, 5.9779442998E-01, 8.5509691624E-01],
	[3.5020000000E+04, 7.6227445693E+00, 3.1205810973E+00, 8.1926428242E-01, 5.9799784612E-01, 8.5512646754E-01],
	[3.5025000000E+04, 7.6245118994E+00, 3.1205744947E+00, 8.1962619660E-01, 5.9820128390E-01, 8.5515601293E-01],
	[3.5030000000E+04, 7.6262793869E+00, 3.1205678931E+00, 8.1998821890E-01, 5.9840474332E-01, 8.5518555242E-01],
	[3.5035000000E+04, 7.6280470318E+00, 3.1205612924E+00, 8.2035034933E-01, 5.9860822436E-01, 8.5521508601E-01],
	[3.5040000000E+04, 7.6298148341E+00, 3.1205546928E+00, 8.2071258791E-01, 5.9881172700E-01, 8.5524461370E-01],
	[3.5045000000E+04, 7.6315827938E+00, 3.1205480940E+00, 8.2107493465E-01, 5.9901525124E-01, 8.5527413549E-01],
	[3.5050000000E+04, 7.6333509108E+00, 3.1205414962E+00, 8.2143738958E-01, 5.9921879707E-01, 8.5530365139E-01],
	[3.5055000000E+04, 7.6351191851E+00, 3.1205348994E+00, 8.2179995270E-01, 5.9942236446E-01, 8.5533316139E-01],
	[3.5060000000E+04, 7.6368876168E+00, 3.1205283036E+00, 8.2216262404E-01, 5.9962595341E-01, 8.5536266549E-01],
	[3.5065000000E+04, 7.6386562058E+00, 3.1205217086E+00, 8.2252540362E-01, 5.9982956390E-01, 8.5539216371E-01],
	[3.5070000000E+04, 7.6404249521E+00, 3.1205151147E+00, 8.2288829144E-01, 6.0003319592E-01, 8.5542165603E-01],
	[3.5075000000E+04, 7.6421938558E+00, 3.1205085217E+00, 8.2325128753E-01, 6.0023684946E-01, 8.5545114246E-01],
	[3.5080000000E+04, 7.6439629167E+00, 3.1205019296E+00, 8.2361439190E-01, 6.0044052450E-01, 8.5548062300E-01],
	[3.5085000000E+04, 7.6457321350E+00, 3.1204953385E+00, 8.2397760457E-01, 6.0064422104E-01, 8.5551009765E-01],
	[3.5090000000E+04, 7.6475045287E+00, 3.1204898887E+00, 8.2434092556E-01, 6.0084799996E-01, 8.5553956642E-01],
	[3.5095000000E+04, 7.6492785492E+00, 3.1204849945E+00, 8.2470435489E-01, 6.0105183006E-01, 8.5556902930E-01],
	[3.5100000000E+04, 7.6510527283E+00, 3.1204801009E+00, 8.2506789256E-01, 6.0125568171E-01, 8.5559848630E-01],
	[3.5105000000E+04, 7.6528270662E+00, 3.1204752080E+00, 8.2543153860E-01, 6.0145955490E-01, 8.5562793742E-01],
	[3.5110000000E+04, 7.6546015628E+00, 3.1204703159E+00, 8.2579529303E-01, 6.0166344961E-01, 8.5565738266E-01],
	[3.5115000000E+04, 7.6563762180E+00, 3.1204654244E+00, 8.2615915585E-01, 6.0186736583E-01, 8.5568682202E-01],
	[3.5120000000E+04, 7.6581510319E+00, 3.1204605336E+00, 8.2652312710E-01, 6.0207130355E-01, 8.5571625550E-01],
	[3.5125000000E+04, 7.6599260045E+00, 3.1204556436E+00, 8.2688720678E-01, 6.0227526276E-01, 8.5574568310E-01],
	[3.5130000000E+04, 7.6617011358E+00, 3.1204507542E+00, 8.2725139491E-01, 6.0247924344E-01, 8.5577510483E-01],
	[3.5135000000E+04, 7.6634764257E+00, 3.1204458656E+00, 8.2761569151E-01, 6.0268324557E-01, 8.5580452069E-01],
	[3.5140000000E+04, 7.6652518742E+00, 3.1204409777E+00, 8.2798009659E-01, 6.0288726916E-01, 8.5583393067E-01],
	[3.5145000000E+04, 7.6670274814E+00, 3.1204360904E+00, 8.2834461018E-01, 6.0309131417E-01, 8.5586333479E-01],
	[3.5150000000E+04, 7.6688032472E+00, 3.1204312039E+00, 8.2870923228E-01, 6.0329538061E-01, 8.5589273303E-01],
	[3.5155000000E+04, 7.6705791716E+00, 3.1204263180E+00, 8.2907396292E-01, 6.0349946846E-01, 8.5592212540E-01],
	[3.5160000000E+04, 7.6723552547E+00, 3.1204214329E+00, 8.2943880211E-01, 6.0370357769E-01, 8.5595151191E-01],
	[3.5165000000E+04, 7.6741314963E+00, 3.1204165485E+00, 8.2980374988E-01, 6.0390770831E-01, 8.5598089256E-01],
	[3.5170000000E+04, 7.6759078966E+00, 3.1204116648E+00, 8.3016880623E-01, 6.0411186030E-01, 8.5601026733E-01],
	[3.5175000000E+04, 7.6776844554E+00, 3.1204067817E+00, 8.3053397118E-01, 6.0431603365E-01, 8.5603963625E-01],
	[3.5180000000E+04, 7.6794611728E+00, 3.1204018994E+00, 8.3089924475E-01, 6.0452022834E-01, 8.5606899931E-01],
	[3.5185000000E+04, 7.6812380487E+00, 3.1203970178E+00, 8.3126462696E-01, 6.0472444435E-01, 8.5609835650E-01],
	[3.5190000000E+04, 7.6830150833E+00, 3.1203921369E+00, 8.3163011782E-01, 6.0492868169E-01, 8.5612770784E-01],
	[3.5195000000E+04, 7.6847922763E+00, 3.1203872567E+00, 8.3199571735E-01, 6.0513294032E-01, 8.5615705332E-01],
	[3.5200000000E+04, 7.6865696279E+00, 3.1203823771E+00, 8.3236142557E-01, 6.0533722025E-01, 8.5618639294E-01],
	[3.5205000000E+04, 7.6883471381E+00, 3.1203774983E+00, 8.3272724250E-01, 6.0554152146E-01, 8.5621572671E-01],
	[3.5210000000E+04, 7.6901248068E+00, 3.1203726202E+00, 8.3309316814E-01, 6.0574584393E-01, 8.5624505462E-01],
	[3.5215000000E+04, 7.6919026340E+00, 3.1203677428E+00, 8.3345920253E-01, 6.0595018765E-01, 8.5627437669E-01],
	[3.5220000000E+04, 7.6936806197E+00, 3.1203628661E+00, 8.3382534566E-01, 6.0615455262E-01, 8.5630369290E-01],
	[3.5225000000E+04, 7.6954587639E+00, 3.1203579901E+00, 8.3419159757E-01, 6.0635893881E-01, 8.5633300327E-01],
	[3.5230000000E+04, 7.6972370666E+00, 3.1203531148E+00, 8.3455795827E-01, 6.0656334621E-01, 8.5636230778E-01],
	[3.5235000000E+04, 7.6990155278E+00, 3.1203482401E+00, 8.3492442777E-01, 6.0676777481E-01, 8.5639160646E-01],
	[3.5240000000E+04, 7.7007941474E+00, 3.1203433662E+00, 8.3529100610E-01, 6.0697222460E-01, 8.5642089928E-01],
	[3.5245000000E+04, 7.7025729255E+00, 3.1203384930E+00, 8.3565769326E-01, 6.0717669556E-01, 8.5645018626E-01],
	[3.5250000000E+04, 7.7043518621E+00, 3.1203336205E+00, 8.3602448928E-01, 6.0738118769E-01, 8.5647946741E-01],
	[3.5255000000E+04, 7.7061309572E+00, 3.1203287487E+00, 8.3639139417E-01, 6.0758570096E-01, 8.5650874271E-01],
	[3.5260000000E+04, 7.7079102106E+00, 3.1203238775E+00, 8.3675840795E-01, 6.0779023537E-01, 8.5653801217E-01],
	[3.5265000000E+04, 7.7096896226E+00, 3.1203190071E+00, 8.3712553064E-01, 6.0799479090E-01, 8.5656727579E-01],
	[3.5270000000E+04, 7.7114691929E+00, 3.1203141374E+00, 8.3749276225E-01, 6.0819936754E-01, 8.5659653357E-01],
	[3.5275000000E+04, 7.7132489216E+00, 3.1203092684E+00, 8.3786010280E-01, 6.0840396527E-01, 8.5662578552E-01],
	[3.5280000000E+04, 7.7150288088E+00, 3.1203044000E+00, 8.3822755230E-01, 6.0860858409E-01, 8.5665503164E-01],
	[3.5285000000E+04, 7.7168088544E+00, 3.1202995324E+00, 8.3859511078E-01, 6.0881322398E-01, 8.5668427193E-01],
	[3.5290000000E+04, 7.7185890583E+00, 3.1202946655E+00, 8.3896277825E-01, 6.0901788493E-01, 8.5671350638E-01],
	[3.5295000000E+04, 7.7203694207E+00, 3.1202897992E+00, 8.3933055473E-01, 6.0922256692E-01, 8.5674273500E-01],
	[3.5300000000E+04, 7.7221499414E+00, 3.1202849337E+00, 8.3969844023E-01, 6.0942726994E-01, 8.5677195780E-01],
	[3.5305000000E+04, 7.7239306205E+00, 3.1202800688E+00, 8.4006643477E-01, 6.0963199399E-01, 8.5680117476E-01],
	[3.5310000000E+04, 7.7257114579E+00, 3.1202752047E+00, 8.4043453837E-01, 6.0983673903E-01, 8.5683038591E-01],
	[3.5315000000E+04, 7.7274924537E+00, 3.1202703412E+00, 8.4080275105E-01, 6.1004150507E-01, 8.5685959122E-01],
	[3.5320000000E+04, 7.7292736078E+00, 3.1202654785E+00, 8.4117107281E-01, 6.1024629209E-01, 8.5688879072E-01],
	[3.5325000000E+04, 7.7310549203E+00, 3.1202606164E+00, 8.4153950369E-01, 6.1045110008E-01, 8.5691798439E-01],
	[3.5330000000E+04, 7.7328363911E+00, 3.1202557551E+00, 8.4190804369E-01, 6.1065592902E-01, 8.5694717224E-01],
	[3.5335000000E+04, 7.7346180202E+00, 3.1202508944E+00, 8.4227669283E-01, 6.1086077890E-01, 8.5697635428E-01],
	[3.5340000000E+04, 7.7363998076E+00, 3.1202460344E+00, 8.4264545113E-01, 6.1106564971E-01, 8.5700553049E-01],
	[3.5345000000E+04, 7.7381817534E+00, 3.1202411752E+00, 8.4301431860E-01, 6.1127054143E-01, 8.5703470089E-01],
	[3.5350000000E+04, 7.7399638574E+00, 3.1202363166E+00, 8.4338329527E-01, 6.1147545406E-01, 8.5706386548E-01],
	[3.5355000000E+04, 7.7417461197E+00, 3.1202314587E+00, 8.4375238115E-01, 6.1168038757E-01, 8.5709302425E-01],
	[3.5360000000E+04, 7.7435285402E+00, 3.1202266015E+00, 8.4412157625E-01, 6.1188534196E-01, 8.5712217721E-01],
	[3.5365000000E+04, 7.7453111191E+00, 3.1202217450E+00, 8.4449088060E-01, 6.1209031721E-01, 8.5715132435E-01],
	[3.5370000000E+04, 7.7470938562E+00, 3.1202168892E+00, 8.4486029421E-01, 6.1229531331E-01, 8.5718046569E-01],
	[3.5375000000E+04, 7.7488767515E+00, 3.1202120341E+00, 8.4522981709E-01, 6.1250033025E-01, 8.5720960122E-01],
	[3.5380000000E+04, 7.7506598051E+00, 3.1202071797E+00, 8.4559944927E-01, 6.1270536801E-01, 8.5723873095E-01],
	[3.5385000000E+04, 7.7524430170E+00, 3.1202023259E+00, 8.4596919075E-01, 6.1291042658E-01, 8.5726785487E-01],
	[3.5390000000E+04, 7.7542263870E+00, 3.1201974729E+00, 8.4633904157E-01, 6.1311550595E-01, 8.5729697298E-01],
	[3.5395000000E+04, 7.7560099153E+00, 3.1201926206E+00, 8.4670900173E-01, 6.1332060611E-01, 8.5732608529E-01],
	[3.5400000000E+04, 7.7577936017E+00, 3.1201877689E+00, 8.4707907125E-01, 6.1352572703E-01, 8.5735519180E-01],
	[3.5405000000E+04, 7.7595774464E+00, 3.1201829180E+00, 8.4744925014E-01, 6.1373086872E-01, 8.5738429252E-01],
	[3.5410000000E+04, 7.7613614493E+00, 3.1201780677E+00, 8.4781953844E-01, 6.1393603115E-01, 8.5741338743E-01],
	[3.5415000000E+04, 7.7631456103E+00, 3.1201732181E+00, 8.4818993614E-01, 6.1414121431E-01, 8.5744247654E-01],
	[3.5420000000E+04, 7.7649299296E+00, 3.1201683693E+00, 8.4856044327E-01, 6.1434641819E-01, 8.5747155986E-01],
	[3.5425000000E+04, 7.7667144070E+00, 3.1201635211E+00, 8.4893105985E-01, 6.1455164278E-01, 8.5750063739E-01],
	[3.5430000000E+04, 7.7684990425E+00, 3.1201586736E+00, 8.4930178589E-01, 6.1475688807E-01, 8.5752970911E-01],
	[3.5435000000E+04, 7.7702838362E+00, 3.1201538268E+00, 8.4967262140E-01, 6.1496215403E-01, 8.5755877506E-01],
	[3.5440000000E+04, 7.7720687881E+00, 3.1201489807E+00, 8.5004356642E-01, 6.1516744066E-01, 8.5758783521E-01],
	[3.5445000000E+04, 7.7738538981E+00, 3.1201441353E+00, 8.5041462094E-01, 6.1537274795E-01, 8.5761688957E-01],
	[3.5450000000E+04, 7.7756391662E+00, 3.1201392905E+00, 8.5078578500E-01, 6.1557807587E-01, 8.5764593815E-01],
	[3.5455000000E+04, 7.7774245924E+00, 3.1201344465E+00, 8.5115705860E-01, 6.1578342443E-01, 8.5767498095E-01],
	[3.5460000000E+04, 7.7792101767E+00, 3.1201296032E+00, 8.5152844176E-01, 6.1598879360E-01, 8.5770401796E-01],
	[3.5465000000E+04, 7.7809959192E+00, 3.1201247605E+00, 8.5189993451E-01, 6.1619418338E-01, 8.5773304919E-01],
	[3.5470000000E+04, 7.7827818197E+00, 3.1201199185E+00, 8.5227153685E-01, 6.1639959374E-01, 8.5776207464E-01],
	[3.5475000000E+04, 7.7845678783E+00, 3.1201150773E+00, 8.5264324880E-01, 6.1660502468E-01, 8.5779109431E-01],
	[3.5480000000E+04, 7.7863540950E+00, 3.1201102367E+00, 8.5301507039E-01, 6.1681047619E-01, 8.5782010819E-01],
	[3.5485000000E+04, 7.7881404698E+00, 3.1201053968E+00, 8.5338700162E-01, 6.1701594824E-01, 8.5784911631E-01],
	[3.5490000000E+04, 7.7899270026E+00, 3.1201005576E+00, 8.5375904252E-01, 6.1722144083E-01, 8.5787811864E-01],
	[3.5495000000E+04, 7.7917136935E+00, 3.1200957191E+00, 8.5413119310E-01, 6.1742695395E-01, 8.5790711520E-01],
	[3.5500000000E+04, 7.7935005424E+00, 3.1200908812E+00, 8.5450345337E-01, 6.1763248758E-01, 8.5793610599E-01],
	[3.5505000000E+04, 7.7952875493E+00, 3.1200860441E+00, 8.5487582336E-01, 6.1783804170E-01, 8.5796509101E-01],
	[3.5510000000E+04, 7.7970747143E+00, 3.1200812077E+00, 8.5524830309E-01, 6.1804361631E-01, 8.5799407025E-01],
	[3.5515000000E+04, 7.7988620373E+00, 3.1200763719E+00, 8.5562089256E-01, 6.1824921140E-01, 8.5802304372E-01],
	[3.5520000000E+04, 7.8006495183E+00, 3.1200715368E+00, 8.5599359179E-01, 6.1845482694E-01, 8.5805201143E-01],
	[3.5525000000E+04, 7.8024371573E+00, 3.1200667024E+00, 8.5636640081E-01, 6.1866046293E-01, 8.5808097336E-01],
	[3.5530000000E+04, 7.8042249543E+00, 3.1200618687E+00, 8.5673931963E-01, 6.1886611935E-01, 8.5810992953E-01],
	[3.5535000000E+04, 7.8060129093E+00, 3.1200570357E+00, 8.5711234826E-01, 6.1907179619E-01, 8.5813887994E-01],
	[3.5540000000E+04, 7.8078010222E+00, 3.1200522034E+00, 8.5748548673E-01, 6.1927749344E-01, 8.5816782458E-01],
	[3.5545000000E+04, 7.8095892932E+00, 3.1200473718E+00, 8.5785873504E-01, 6.1948321109E-01, 8.5819676346E-01],
	[3.5550000000E+04, 7.8113777220E+00, 3.1200425408E+00, 8.5823209322E-01, 6.1968894911E-01, 8.5822569658E-01],
	[3.5555000000E+04, 7.8131663089E+00, 3.1200377106E+00, 8.5860556129E-01, 6.1989470751E-01, 8.5825462394E-01],
	[3.5560000000E+04, 7.8149550537E+00, 3.1200328810E+00, 8.5897913925E-01, 6.2010048626E-01, 8.5828354554E-01],
	[3.5565000000E+04, 7.8167439564E+00, 3.1200280521E+00, 8.5935282713E-01, 6.2030628535E-01, 8.5831246138E-01],
	[3.5570000000E+04, 7.8185330170E+00, 3.1200232239E+00, 8.5972662495E-01, 6.2051210477E-01, 8.5834137146E-01],
	[3.5575000000E+04, 7.8203222356E+00, 3.1200183964E+00, 8.6010053271E-01, 6.2071794450E-01, 8.5837027579E-01],
	[3.5580000000E+04, 7.8221116121E+00, 3.1200135696E+00, 8.6047455045E-01, 6.2092380454E-01, 8.5839917437E-01],
	[3.5585000000E+04, 7.8239011464E+00, 3.1200087434E+00, 8.6084867817E-01, 6.2112968487E-01, 8.5842806719E-01],
	[3.5590000000E+04, 7.8256908387E+00, 3.1200039180E+00, 8.6122291588E-01, 6.2133558547E-01, 8.5845695426E-01],
	[3.5595000000E+04, 7.8274806889E+00, 3.1199990932E+00, 8.6159726362E-01, 6.2154150634E-01, 8.5848583558E-01],
	[3.5600000000E+04, 7.8292706969E+00, 3.1199942691E+00, 8.6197172139E-01, 6.2174744746E-01, 8.5851471115E-01],
	[3.5605000000E+04, 7.8310608628E+00, 3.1199894457E+00, 8.6234628922E-01, 6.2195340882E-01, 8.5854358098E-01],
	[3.5610000000E+04, 7.8328511866E+00, 3.1199846230E+00, 8.6272096711E-01, 6.2215939040E-01, 8.5857244505E-01],
	[3.5615000000E+04, 7.8346416682E+00, 3.1199798010E+00, 8.6309575509E-01, 6.2236539219E-01, 8.5860130339E-01],
	[3.5620000000E+04, 7.8364323076E+00, 3.1199749796E+00, 8.6347065317E-01, 6.2257141419E-01, 8.5863015597E-01],
	[3.5625000000E+04, 7.8382231049E+00, 3.1199701589E+00, 8.6384566137E-01, 6.2277745636E-01, 8.5865900282E-01],
	[3.5630000000E+04, 7.8400140601E+00, 3.1199653390E+00, 8.6422077970E-01, 6.2298351871E-01, 8.5868784392E-01],
	[3.5635000000E+04, 7.8418051730E+00, 3.1199605197E+00, 8.6459600819E-01, 6.2318960122E-01, 8.5871667929E-01],
	[3.5640000000E+04, 7.8435964438E+00, 3.1199557011E+00, 8.6497134685E-01, 6.2339570388E-01, 8.5874550891E-01],
	[3.5645000000E+04, 7.8453878723E+00, 3.1199508831E+00, 8.6534679570E-01, 6.2360182667E-01, 8.5877433279E-01],
	[3.5650000000E+04, 7.8471794587E+00, 3.1199460659E+00, 8.6572235474E-01, 6.2380796958E-01, 8.5880315094E-01],
	[3.5655000000E+04, 7.8489744137E+00, 3.1199424175E+00, 8.6609802401E-01, 6.2401419962E-01, 8.5883196336E-01],
	[3.5660000000E+04, 7.8507708821E+00, 3.1199392624E+00, 8.6647380352E-01, 6.2422047812E-01, 8.5886077003E-01],
	[3.5665000000E+04, 7.8525675097E+00, 3.1199361078E+00, 8.6684969328E-01, 6.2442677679E-01, 8.5888957098E-01],
	[3.5670000000E+04, 7.8543642965E+00, 3.1199329536E+00, 8.6722569331E-01, 6.2463309564E-01, 8.5891836619E-01],
	[3.5675000000E+04, 7.8561612426E+00, 3.1199297998E+00, 8.6760180363E-01, 6.2483943464E-01, 8.5894715568E-01],
	[3.5680000000E+04, 7.8579583478E+00, 3.1199266465E+00, 8.6797802425E-01, 6.2504579378E-01, 8.5897593943E-01],
	[3.5685000000E+04, 7.8597556122E+00, 3.1199234937E+00, 8.6835435520E-01, 6.2525217305E-01, 8.5900471746E-01],
	[3.5690000000E+04, 7.8615530358E+00, 3.1199203413E+00, 8.6873079648E-01, 6.2545857243E-01, 8.5903348975E-01],
	[3.5695000000E+04, 7.8633506186E+00, 3.1199171893E+00, 8.6910734812E-01, 6.2566499192E-01, 8.5906225633E-01],
	[3.5700000000E+04, 7.8651483605E+00, 3.1199140377E+00, 8.6948401013E-01, 6.2587143150E-01, 8.5909101718E-01],
	[3.5705000000E+04, 7.8669462616E+00, 3.1199108867E+00, 8.6986078253E-01, 6.2607789115E-01, 8.5911977230E-01],
	[3.5710000000E+04, 7.8687443218E+00, 3.1199077360E+00, 8.7023766533E-01, 6.2628437087E-01, 8.5914852170E-01],
	[3.5715000000E+04, 7.8705425412E+00, 3.1199045858E+00, 8.7061465856E-01, 6.2649087064E-01, 8.5917726539E-01],
	[3.5720000000E+04, 7.8723409197E+00, 3.1199014361E+00, 8.7099176223E-01, 6.2669739045E-01, 8.5920600335E-01],
	[3.5725000000E+04, 7.8741394573E+00, 3.1198982868E+00, 8.7136897635E-01, 6.2690393028E-01, 8.5923473559E-01],
	[3.5730000000E+04, 7.8759381540E+00, 3.1198951379E+00, 8.7174630095E-01, 6.2711049012E-01, 8.5926346212E-01],
	[3.5735000000E+04, 7.8777370098E+00, 3.1198919895E+00, 8.7212373603E-01, 6.2731706996E-01, 8.5929218293E-01],
	[3.5740000000E+04, 7.8795360247E+00, 3.1198888415E+00, 8.7250128163E-01, 6.2752366978E-01, 8.5932089803E-01],
	[3.5745000000E+04, 7.8813351987E+00, 3.1198856940E+00, 8.7287893774E-01, 6.2773028958E-01, 8.5934960741E-01],
	[3.5750000000E+04, 7.8831345318E+00, 3.1198825469E+00, 8.7325670440E-01, 6.2793692934E-01, 8.5937831108E-01],
	[3.5755000000E+04, 7.8849340239E+00, 3.1198794002E+00, 8.7363458162E-01, 6.2814358905E-01, 8.5940700904E-01],
	[3.5760000000E+04, 7.8867336751E+00, 3.1198762540E+00, 8.7401256941E-01, 6.2835026868E-01, 8.5943570129E-01],
	[3.5765000000E+04, 7.8885334854E+00, 3.1198731083E+00, 8.7439066779E-01, 6.2855696824E-01, 8.5946438783E-01],
	[3.5770000000E+04, 7.8903334547E+00, 3.1198699630E+00, 8.7476887678E-01, 6.2876368770E-01, 8.5949306866E-01],
	[3.5775000000E+04, 7.8921335830E+00, 3.1198668181E+00, 8.7514719639E-01, 6.2897042706E-01, 8.5952174379E-01],
	[3.5780000000E+04, 7.8939338704E+00, 3.1198636737E+00, 8.7552562664E-01, 6.2917718630E-01, 8.5955041321E-01],
	[3.5785000000E+04, 7.8957343168E+00, 3.1198605297E+00, 8.7590416756E-01, 6.2938396541E-01, 8.5957907693E-01],
	[3.5790000000E+04, 7.8975349222E+00, 3.1198573861E+00, 8.7628281915E-01, 6.2959076438E-01, 8.5960773495E-01],
	[3.5795000000E+04, 7.8993356866E+00, 3.1198542430E+00, 8.7666158143E-01, 6.2979758318E-01, 8.5963638726E-01],
	[3.5800000000E+04, 7.9011366100E+00, 3.1198511004E+00, 8.7704045442E-01, 6.3000442182E-01, 8.5966503388E-01],
	[3.5805000000E+04, 7.9029376924E+00, 3.1198479581E+00, 8.7741943814E-01, 6.3021128027E-01, 8.5969367479E-01],
	[3.5810000000E+04, 7.9047389337E+00, 3.1198448164E+00, 8.7779853260E-01, 6.3041815852E-01, 8.5972231001E-01],
	[3.5815000000E+04, 7.9065403341E+00, 3.1198416750E+00, 8.7817773782E-01, 6.3062505656E-01, 8.5975093953E-01],
	[3.5820000000E+04, 7.9083418934E+00, 3.1198385341E+00, 8.7855705382E-01, 6.3083197439E-01, 8.5977956336E-01],
	[3.5825000000E+04, 7.9101436116E+00, 3.1198353937E+00, 8.7893648061E-01, 6.3103891197E-01, 8.5980818149E-01],
	[3.5830000000E+04, 7.9119454888E+00, 3.1198322537E+00, 8.7931601821E-01, 6.3124586930E-01, 8.5983679393E-01],
	[3.5835000000E+04, 7.9137475250E+00, 3.1198291141E+00, 8.7969566664E-01, 6.3145284638E-01, 8.5986540068E-01],
	[3.5840000000E+04, 7.9155497201E+00, 3.1198259750E+00, 8.8007542591E-01, 6.3165984318E-01, 8.5989400174E-01],
	[3.5845000000E+04, 7.9173520741E+00, 3.1198228363E+00, 8.8045529605E-01, 6.3186685968E-01, 8.5992259711E-01],
	[3.5850000000E+04, 7.9191545870E+00, 3.1198196980E+00, 8.8083527706E-01, 6.3207389589E-01, 8.5995118679E-01],
	[3.5855000000E+04, 7.9209572588E+00, 3.1198165602E+00, 8.8121536896E-01, 6.3228095179E-01, 8.5997977078E-01],
	[3.5860000000E+04, 7.9227600895E+00, 3.1198134229E+00, 8.8159557178E-01, 6.3248802735E-01, 8.6000834909E-01],
	[3.5865000000E+04, 7.9245630791E+00, 3.1198102859E+00, 8.8197588553E-01, 6.3269512258E-01, 8.6003692172E-01],
	[3.5870000000E+04, 7.9263662276E+00, 3.1198071495E+00, 8.8235631022E-01, 6.3290223745E-01, 8.6006548866E-01],
	[3.5875000000E+04, 7.9281695350E+00, 3.1198040134E+00, 8.8273684587E-01, 6.3310937196E-01, 8.6009404992E-01],
	[3.5880000000E+04, 7.9299730012E+00, 3.1198008778E+00, 8.8311749251E-01, 6.3331652608E-01, 8.6012260550E-01],
	[3.5885000000E+04, 7.9317766263E+00, 3.1197977427E+00, 8.8349825013E-01, 6.3352369981E-01, 8.6015115540E-01],
	[3.5890000000E+04, 7.9335804102E+00, 3.1197946079E+00, 8.8387911878E-01, 6.3373089314E-01, 8.6017969962E-01],
	[3.5895000000E+04, 7.9353843530E+00, 3.1197914736E+00, 8.8426009845E-01, 6.3393810605E-01, 8.6020823817E-01],
	[3.5900000000E+04, 7.9371884546E+00, 3.1197883398E+00, 8.8464118916E-01, 6.3414533853E-01, 8.6023677104E-01],
	[3.5905000000E+04, 7.9389927150E+00, 3.1197852064E+00, 8.8502239095E-01, 6.3435259056E-01, 8.6026529823E-01],
	[3.5910000000E+04, 7.9407971343E+00, 3.1197820734E+00, 8.8540370381E-01, 6.3455986213E-01, 8.6029381976E-01],
	[3.5915000000E+04, 7.9426017123E+00, 3.1197789409E+00, 8.8578512777E-01, 6.3476715323E-01, 8.6032233561E-01],
	[3.5920000000E+04, 7.9444064492E+00, 3.1197758088E+00, 8.8616666284E-01, 6.3497446385E-01, 8.6035084579E-01],
	[3.5925000000E+04, 7.9462113449E+00, 3.1197726772E+00, 8.8654830904E-01, 6.3518179397E-01, 8.6037935030E-01],
	[3.5930000000E+04, 7.9480163993E+00, 3.1197695460E+00, 8.8693006639E-01, 6.3538914359E-01, 8.6040784914E-01],
	[3.5935000000E+04, 7.9498216125E+00, 3.1197664152E+00, 8.8731193491E-01, 6.3559651267E-01, 8.6043634231E-01],
	[3.5940000000E+04, 7.9516269845E+00, 3.1197632849E+00, 8.8769391461E-01, 6.3580390122E-01, 8.6046482982E-01],
	[3.5945000000E+04, 7.9534325152E+00, 3.1197601550E+00, 8.8807600550E-01, 6.3601130923E-01, 8.6049331166E-01],
	[3.5950000000E+04, 7.9552382047E+00, 3.1197570255E+00, 8.8845820761E-01, 6.3621873667E-01, 8.6052178784E-01],
	[3.5955000000E+04, 7.9570440530E+00, 3.1197538965E+00, 8.8884052096E-01, 6.3642618353E-01, 8.6055025836E-01],
	[3.5960000000E+04, 7.9588500599E+00, 3.1197507679E+00, 8.8922294555E-01, 6.3663364981E-01, 8.6057872322E-01],
	[3.5965000000E+04, 7.9606562256E+00, 3.1197476398E+00, 8.8960548141E-01, 6.3684113548E-01, 8.6060718242E-01],
	[3.5970000000E+04, 7.9624625500E+00, 3.1197445121E+00, 8.8998812855E-01, 6.3704864054E-01, 8.6063563595E-01],
	[3.5975000000E+04, 7.9642690332E+00, 3.1197413848E+00, 8.9037088699E-01, 6.3725616497E-01, 8.6066408383E-01],
	[3.5980000000E+04, 7.9660756750E+00, 3.1197382580E+00, 8.9075375674E-01, 6.3746370876E-01, 8.6069252606E-01],
	[3.5985000000E+04, 7.9678824755E+00, 3.1197351316E+00, 8.9113673783E-01, 6.3767127190E-01, 8.6072096263E-01],
	[3.5990000000E+04, 7.9696894347E+00, 3.1197320057E+00, 8.9151983027E-01, 6.3787885437E-01, 8.6074939354E-01],
	[3.5995000000E+04, 7.9714965526E+00, 3.1197288802E+00, 8.9190303408E-01, 6.3808645616E-01, 8.6077781881E-01],
	[3.6000000000E+04, 7.9733038292E+00, 3.1197257551E+00, 8.9228634927E-01, 6.3829407726E-01, 8.6080623842E-01],
	[3.6005000000E+04, 7.9751112644E+00, 3.1197226304E+00, 8.9266977586E-01, 6.3850171765E-01, 8.6083465238E-01],
	[3.6010000000E+04, 7.9769188583E+00, 3.1197195062E+00, 8.9305331387E-01, 6.3870937732E-01, 8.6086306069E-01],
	[3.6015000000E+04, 7.9787266108E+00, 3.1197163825E+00, 8.9343696331E-01, 6.3891705626E-01, 8.6089146336E-01],
	[3.6020000000E+04, 7.9805345220E+00, 3.1197132591E+00, 8.9382072421E-01, 6.3912475445E-01, 8.6091986038E-01],
	[3.6025000000E+04, 7.9823425918E+00, 3.1197101363E+00, 8.9420459657E-01, 6.3933247189E-01, 8.6094825175E-01],
	[3.6030000000E+04, 7.9841508202E+00, 3.1197070138E+00, 8.9458858042E-01, 6.3954020855E-01, 8.6097663748E-01],
	[3.6035000000E+04, 7.9859592072E+00, 3.1197038918E+00, 8.9497267577E-01, 6.3974796443E-01, 8.6100501757E-01],
	[3.6040000000E+04, 7.9877677529E+00, 3.1197007702E+00, 8.9535688264E-01, 6.3995573951E-01, 8.6103339201E-01],
	[3.6045000000E+04, 7.9895764571E+00, 3.1196976491E+00, 8.9574120104E-01, 6.4016353378E-01, 8.6106176081E-01],
	[3.6050000000E+04, 7.9913853199E+00, 3.1196945283E+00, 8.9612563100E-01, 6.4037134723E-01, 8.6109012398E-01],
	[3.6055000000E+04, 7.9931943413E+00, 3.1196914081E+00, 8.9651017253E-01, 6.4057917984E-01, 8.6111848151E-01],
	[3.6060000000E+04, 7.9950035213E+00, 3.1196882882E+00, 8.9689482564E-01, 6.4078703160E-01, 8.6114683340E-01],
	[3.6065000000E+04, 7.9968128598E+00, 3.1196851688E+00, 8.9727959036E-01, 6.4099490249E-01, 8.6117517965E-01],
	[3.6070000000E+04, 7.9986223569E+00, 3.1196820499E+00, 8.9766446670E-01, 6.4120279252E-01, 8.6120352027E-01],
	[3.6075000000E+04, 8.0004320126E+00, 3.1196789313E+00, 8.9804945467E-01, 6.4141070165E-01, 8.6123185526E-01],
	[3.6080000000E+04, 8.0022418268E+00, 3.1196758132E+00, 8.9843455430E-01, 6.4161862988E-01, 8.6126018461E-01],
	[3.6085000000E+04, 8.0040517995E+00, 3.1196726956E+00, 8.9881976560E-01, 6.4182657719E-01, 8.6128850834E-01],
	[3.6090000000E+04, 8.0058619307E+00, 3.1196695784E+00, 8.9920508858E-01, 6.4203454358E-01, 8.6131682643E-01],
	[3.6095000000E+04, 8.0076722205E+00, 3.1196664616E+00, 8.9959052327E-01, 6.4224252902E-01, 8.6134513890E-01],
	[3.6100000000E+04, 8.0094826688E+00, 3.1196633452E+00, 8.9997606968E-01, 6.4245053351E-01, 8.6137344574E-01],
	[3.6105000000E+04, 8.0112932755E+00, 3.1196602293E+00, 9.0036172783E-01, 6.4265855703E-01, 8.6140174695E-01],
	[3.6110000000E+04, 8.0131040408E+00, 3.1196571138E+00, 9.0074749774E-01, 6.4286659957E-01, 8.6143004254E-01],
	[3.6115000000E+04, 8.0149149646E+00, 3.1196539987E+00, 9.0113337942E-01, 6.4307466112E-01, 8.6145833250E-01],
	[3.6120000000E+04, 8.0167260468E+00, 3.1196508841E+00, 9.0151937288E-01, 6.4328274166E-01, 8.6148661685E-01],
	[3.6125000000E+04, 8.0185372875E+00, 3.1196477699E+00, 9.0190547815E-01, 6.4349084118E-01, 8.6151489557E-01],
	[3.6130000000E+04, 8.0203486866E+00, 3.1196446562E+00, 9.0229169525E-01, 6.4369895966E-01, 8.6154316867E-01],
	[3.6135000000E+04, 8.0221602442E+00, 3.1196415429E+00, 9.0267802418E-01, 6.4390709711E-01, 8.6157143615E-01],
	[3.6140000000E+04, 8.0239719603E+00, 3.1196384300E+00, 9.0306446497E-01, 6.4411525349E-01, 8.6159969802E-01],
	[3.6145000000E+04, 8.0257838348E+00, 3.1196353176E+00, 9.0345101764E-01, 6.4432342880E-01, 8.6162795427E-01],
	[3.6150000000E+04, 8.0275958677E+00, 3.1196322055E+00, 9.0383768219E-01, 6.4453162302E-01, 8.6165620490E-01],
	[3.6155000000E+04, 8.0294080590E+00, 3.1196290940E+00, 9.0422445865E-01, 6.4473983614E-01, 8.6168444992E-01],
	[3.6160000000E+04, 8.0312204088E+00, 3.1196259828E+00, 9.0461134703E-01, 6.4494806816E-01, 8.6171268933E-01],
	[3.6165000000E+04, 8.0330329169E+00, 3.1196228721E+00, 9.0499834736E-01, 6.4515631905E-01, 8.6174092312E-01],
	[3.6170000000E+04, 8.0348455835E+00, 3.1196197618E+00, 9.0538545964E-01, 6.4536458880E-01, 8.6176915131E-01],
	[3.6175000000E+04, 8.0366584084E+00, 3.1196166520E+00, 9.0577268390E-01, 6.4557287740E-01, 8.6179737389E-01],
	[3.6180000000E+04, 8.0384713917E+00, 3.1196135426E+00, 9.0616002015E-01, 6.4578118483E-01, 8.6182559086E-01],
	[3.6185000000E+04, 8.0402845334E+00, 3.1196104336E+00, 9.0654746840E-01, 6.4598951109E-01, 8.6185380222E-01],
	[3.6190000000E+04, 8.0420978334E+00, 3.1196073250E+00, 9.0693502869E-01, 6.4619785616E-01, 8.6188200798E-01],
	[3.6195000000E+04, 8.0439112918E+00, 3.1196042169E+00, 9.0732270101E-01, 6.4640622002E-01, 8.6191020813E-01],
	[3.6200000000E+04, 8.0457249086E+00, 3.1196011092E+00, 9.0771048539E-01, 6.4661460267E-01, 8.6193840268E-01],
	[3.6205000000E+04, 8.0475386837E+00, 3.1195980020E+00, 9.0809838185E-01, 6.4682300409E-01, 8.6196659163E-01],
	[3.6210000000E+04, 8.0493526171E+00, 3.1195948952E+00, 9.0848639040E-01, 6.4703142427E-01, 8.6199477497E-01],
	[3.6215000000E+04, 8.0511667088E+00, 3.1195917888E+00, 9.0887451106E-01, 6.4723986319E-01, 8.6202295272E-01],
	[3.6220000000E+04, 8.0529809589E+00, 3.1195886828E+00, 9.0926274385E-01, 6.4744832084E-01, 8.6205112487E-01],
	[3.6225000000E+04, 8.0547953673E+00, 3.1195855773E+00, 9.0965108878E-01, 6.4765679721E-01, 8.6207929143E-01],
	[3.6230000000E+04, 8.0566141427E+00, 3.1195839618E+00, 9.1003954587E-01, 6.4786538375E-01, 8.6210745238E-01],
	[3.6235000000E+04, 8.0584334674E+00, 3.1195824845E+00, 9.1042811514E-01, 6.4807399754E-01, 8.6213560775E-01],
	[3.6240000000E+04, 8.0602529520E+00, 3.1195810073E+00, 9.1081679660E-01, 6.4828263012E-01, 8.6216375751E-01],
	[3.6245000000E+04, 8.0620725962E+00, 3.1195795304E+00, 9.1120559027E-01, 6.4849128146E-01, 8.6219190169E-01],
	[3.6250000000E+04, 8.0638924001E+00, 3.1195780537E+00, 9.1159449617E-01, 6.4869995156E-01, 8.6222004028E-01],
	[3.6255000000E+04, 8.0657123638E+00, 3.1195765772E+00, 9.1198351432E-01, 6.4890864040E-01, 8.6224817327E-01],
	[3.6260000000E+04, 8.0675324871E+00, 3.1195751008E+00, 9.1237264472E-01, 6.4911734796E-01, 8.6227630068E-01],
	[3.6265000000E+04, 8.0693527701E+00, 3.1195736247E+00, 9.1276188741E-01, 6.4932607425E-01, 8.6230442250E-01],
	[3.6270000000E+04, 8.0711732128E+00, 3.1195721488E+00, 9.1315124239E-01, 6.4953481923E-01, 8.6233253874E-01],
	[3.6275000000E+04, 8.0729938152E+00, 3.1195706731E+00, 9.1354070968E-01, 6.4974358290E-01, 8.6236064939E-01],
	[3.6280000000E+04, 8.0748145772E+00, 3.1195691976E+00, 9.1393028930E-01, 6.4995236525E-01, 8.6238875445E-01],
	[3.6285000000E+04, 8.0766354988E+00, 3.1195677223E+00, 9.1431998126E-01, 6.5016116626E-01, 8.6241685394E-01],
	[3.6290000000E+04, 8.0784565801E+00, 3.1195662473E+00, 9.1470978559E-01, 6.5036998593E-01, 8.6244494784E-01],
	[3.6295000000E+04, 8.0802778211E+00, 3.1195647724E+00, 9.1509970230E-01, 6.5057882423E-01, 8.6247303616E-01],
	[3.6300000000E+04, 8.0820992217E+00, 3.1195632977E+00, 9.1548973141E-01, 6.5078768115E-01, 8.6250111890E-01],
	[3.6305000000E+04, 8.0839207818E+00, 3.1195618232E+00, 9.1587987293E-01, 6.5099655668E-01, 8.6252919607E-01],
	[3.6310000000E+04, 8.0857425016E+00, 3.1195603489E+00, 9.1627012688E-01, 6.5120545081E-01, 8.6255726765E-01],
	[3.6315000000E+04, 8.0875643810E+00, 3.1195588749E+00, 9.1666049327E-01, 6.5141436353E-01, 8.6258533367E-01],
	[3.6320000000E+04, 8.0893864200E+00, 3.1195574010E+00, 9.1705097213E-01, 6.5162329481E-01, 8.6261339411E-01],
	[3.6325000000E+04, 8.0912086186E+00, 3.1195559273E+00, 9.1744156347E-01, 6.5183224466E-01, 8.6264144897E-01],
	[3.6330000000E+04, 8.0930309768E+00, 3.1195544539E+00, 9.1783226731E-01, 6.5204121305E-01, 8.6266949827E-01],
	[3.6335000000E+04, 8.0948534945E+00, 3.1195529806E+00, 9.1822308366E-01, 6.5225019997E-01, 8.6269754199E-01],
	[3.6340000000E+04, 8.0966761718E+00, 3.1195515076E+00, 9.1861401255E-01, 6.5245920541E-01, 8.6272558015E-01],
	[3.6345000000E+04, 8.0984990086E+00, 3.1195500347E+00, 9.1900505398E-01, 6.5266822936E-01, 8.6275361273E-01],
	[3.6350000000E+04, 8.1003220050E+00, 3.1195485621E+00, 9.1939620798E-01, 6.5287727180E-01, 8.6278163975E-01],
	[3.6355000000E+04, 8.1021451609E+00, 3.1195470896E+00, 9.1978747456E-01, 6.5308633272E-01, 8.6280966120E-01],
	[3.6360000000E+04, 8.1039684764E+00, 3.1195456174E+00, 9.2017885374E-01, 6.5329541211E-01, 8.6283767709E-01],
	[3.6365000000E+04, 8.1057919514E+00, 3.1195441454E+00, 9.2057034554E-01, 6.5350450995E-01, 8.6286568742E-01],
	[3.6370000000E+04, 8.1076155859E+00, 3.1195426735E+00, 9.2096194997E-01, 6.5371362623E-01, 8.6289369218E-01],
	[3.6375000000E+04, 8.1094393799E+00, 3.1195412019E+00, 9.2135366705E-01, 6.5392276094E-01, 8.6292169139E-01],
	[3.6380000000E+04, 8.1112633334E+00, 3.1195397305E+00, 9.2174549679E-01, 6.5413191406E-01, 8.6294968503E-01],
	[3.6385000000E+04, 8.1130874464E+00, 3.1195382592E+00, 9.2213743922E-01, 6.5434108559E-01, 8.6297767311E-01],
	[3.6390000000E+04, 8.1149117188E+00, 3.1195367882E+00, 9.2252949435E-01, 6.5455027550E-01, 8.6300565564E-01],
	[3.6395000000E+04, 8.1167361508E+00, 3.1195353174E+00, 9.2292166220E-01, 6.5475948379E-01, 8.6303363261E-01],
	[3.6400000000E+04, 8.1185607422E+00, 3.1195338468E+00, 9.2331394278E-01, 6.5496871044E-01, 8.6306160403E-01],
	[3.6405000000E+04, 8.1203854931E+00, 3.1195323764E+00, 9.2370633611E-01, 6.5517795544E-01, 8.6308956989E-01],
	[3.6410000000E+04, 8.1222104034E+00, 3.1195309062E+00, 9.2409884221E-01, 6.5538721878E-01, 8.6311753020E-01],
	[3.6415000000E+04, 8.1240354732E+00, 3.1195294362E+00, 9.2449146109E-01, 6.5559650044E-01, 8.6314548496E-01],
	[3.6420000000E+04, 8.1258607024E+00, 3.1195279664E+00, 9.2488419278E-01, 6.5580580041E-01, 8.6317343416E-01],
	[3.6425000000E+04, 8.1276860910E+00, 3.1195264968E+00, 9.2527703728E-01, 6.5601511867E-01, 8.6320137782E-01],
	[3.6430000000E+04, 8.1295116391E+00, 3.1195250274E+00, 9.2566999462E-01, 6.5622445522E-01, 8.6322931593E-01],
	[3.6435000000E+04, 8.1313373465E+00, 3.1195235582E+00, 9.2606306482E-01, 6.5643381004E-01, 8.6325724850E-01],
	[3.6440000000E+04, 8.1331632134E+00, 3.1195220892E+00, 9.2645624788E-01, 6.5664318312E-01, 8.6328517552E-01],
	[3.6445000000E+04, 8.1349892396E+00, 3.1195206204E+00, 9.2684954383E-01, 6.5685257445E-01, 8.6331309699E-01],
	[3.6450000000E+04, 8.1368154253E+00, 3.1195191518E+00, 9.2724295268E-01, 6.5706198400E-01, 8.6334101292E-01],
	[3.6455000000E+04, 8.1386417703E+00, 3.1195176834E+00, 9.2763647445E-01, 6.5727141177E-01, 8.6336892331E-01],
	[3.6460000000E+04, 8.1404682747E+00, 3.1195162152E+00, 9.2803010916E-01, 6.5748085775E-01, 8.6339682816E-01],
	[3.6465000000E+04, 8.1422949385E+00, 3.1195147472E+00, 9.2842385682E-01, 6.5769032192E-01, 8.6342472747E-01],
	[3.6470000000E+04, 8.1441217616E+00, 3.1195132794E+00, 9.2881771745E-01, 6.5789980427E-01, 8.6345262125E-01],
	[3.6475000000E+04, 8.1459487440E+00, 3.1195118118E+00, 9.2921169107E-01, 6.5810930479E-01, 8.6348050948E-01],
	[3.6480000000E+04, 8.1477758858E+00, 3.1195103445E+00, 9.2960577770E-01, 6.5831882345E-01, 8.6350839218E-01],
	[3.6485000000E+04, 8.1496031870E+00, 3.1195088773E+00, 9.2999997734E-01, 6.5852836026E-01, 8.6353626934E-01],
	[3.6490000000E+04, 8.1514306474E+00, 3.1195074103E+00, 9.3039429003E-01, 6.5873791520E-01, 8.6356414097E-01],
	[3.6495000000E+04, 8.1532582672E+00, 3.1195059435E+00, 9.3078871577E-01, 6.5894748825E-01, 8.6359200707E-01],
	[3.6500000000E+04, 8.1550860463E+00, 3.1195044770E+00, 9.3118325458E-01, 6.5915707940E-01, 8.6361986764E-01],
	[3.6505000000E+04, 8.1569139846E+00, 3.1195030106E+00, 9.3157790648E-01, 6.5936668863E-01, 8.6364772268E-01],
	[3.6510000000E+04, 8.1587420823E+00, 3.1195015444E+00, 9.3197267148E-01, 6.5957631595E-01, 8.6367557219E-01],
	[3.6515000000E+04, 8.1605703393E+00, 3.1195000785E+00, 9.3236754961E-01, 6.5978596132E-01, 8.6370341617E-01],
	[3.6520000000E+04, 8.1623987555E+00, 3.1194986127E+00, 9.3276254088E-01, 6.5999562474E-01, 8.6373125462E-01],
	[3.6525000000E+04, 8.1642273310E+00, 3.1194971471E+00, 9.3315764530E-01, 6.6020530620E-01, 8.6375908755E-01],
	[3.6530000000E+04, 8.1660560658E+00, 3.1194956818E+00, 9.3355286290E-01, 6.6041500567E-01, 8.6378691496E-01],
	[3.6535000000E+04, 8.1678849598E+00, 3.1194942166E+00, 9.3394819369E-01, 6.6062472316E-01, 8.6381473684E-01],
	[3.6540000000E+04, 8.1697140130E+00, 3.1194927516E+00, 9.3434363768E-01, 6.6083445865E-01, 8.6384255321E-01],
	[3.6545000000E+04, 8.1715432255E+00, 3.1194912869E+00, 9.3473919490E-01, 6.6104421211E-01, 8.6387036405E-01],
	[3.6550000000E+04, 8.1733725972E+00, 3.1194898223E+00, 9.3513486536E-01, 6.6125398355E-01, 8.6389816937E-01],
	[3.6555000000E+04, 8.1752021282E+00, 3.1194883580E+00, 9.3553064908E-01, 6.6146377294E-01, 8.6392596917E-01],
	[3.6560000000E+04, 8.1770318183E+00, 3.1194868938E+00, 9.3592654607E-01, 6.6167358028E-01, 8.6395376346E-01],
	[3.6565000000E+04, 8.1788616677E+00, 3.1194854299E+00, 9.3632255636E-01, 6.6188340554E-01, 8.6398155223E-01],
	[3.6570000000E+04, 8.1806916762E+00, 3.1194839661E+00, 9.3671867995E-01, 6.6209324873E-01, 8.6400933549E-01],
	[3.6575000000E+04, 8.1825218440E+00, 3.1194825025E+00, 9.3711491687E-01, 6.6230310982E-01, 8.6403711324E-01],
	[3.6580000000E+04, 8.1843521709E+00, 3.1194810392E+00, 9.3751126713E-01, 6.6251298880E-01, 8.6406488547E-01],
	[3.6585000000E+04, 8.1861826570E+00, 3.1194795760E+00, 9.3790773075E-01, 6.6272288565E-01, 8.6409265219E-01],
	[3.6590000000E+04, 8.1880133022E+00, 3.1194781131E+00, 9.3830430774E-01, 6.6293280038E-01, 8.6412041340E-01],
	[3.6595000000E+04, 8.1898441066E+00, 3.1194766503E+00, 9.3870099813E-01, 6.6314273295E-01, 8.6414816910E-01],
	[3.6600000000E+04, 8.1916750702E+00, 3.1194751878E+00, 9.3909780193E-01, 6.6335268336E-01, 8.6417591930E-01],
	[3.6605000000E+04, 8.1935061929E+00, 3.1194737254E+00, 9.3949471915E-01, 6.6356265160E-01, 8.6420366399E-01],
	[3.6610000000E+04, 8.1953374748E+00, 3.1194722633E+00, 9.3989174982E-01, 6.6377263765E-01, 8.6423140318E-01],
	[3.6615000000E+04, 8.1971689157E+00, 3.1194708013E+00, 9.4028889395E-01, 6.6398264151E-01, 8.6425913686E-01],
	[3.6620000000E+04, 8.1990005158E+00, 3.1194693396E+00, 9.4068615155E-01, 6.6419266314E-01, 8.6428686504E-01],
	[3.6625000000E+04, 8.2008322750E+00, 3.1194678780E+00, 9.4108352265E-01, 6.6440270255E-01, 8.6431458771E-01],
	[3.6630000000E+04, 8.2026641933E+00, 3.1194664167E+00, 9.4148100726E-01, 6.6461275973E-01, 8.6434230489E-01],
	[3.6635000000E+04, 8.2044962707E+00, 3.1194649555E+00, 9.4187860540E-01, 6.6482283464E-01, 8.6437001657E-01],
	[3.6640000000E+04, 8.2063285072E+00, 3.1194634946E+00, 9.4227631709E-01, 6.6503292730E-01, 8.6439772275E-01],
	[3.6645000000E+04, 8.2081609027E+00, 3.1194620338E+00, 9.4267414233E-01, 6.6524303767E-01, 8.6442542344E-01],
	[3.6650000000E+04, 8.2099934573E+00, 3.1194605733E+00, 9.4307208116E-01, 6.6545316575E-01, 8.6445311863E-01],
	[3.6655000000E+04, 8.2118261710E+00, 3.1194591129E+00, 9.4347013358E-01, 6.6566331153E-01, 8.6448080832E-01],
	[3.6660000000E+04, 8.2136590437E+00, 3.1194576528E+00, 9.4386829961E-01, 6.6587347499E-01, 8.6450849252E-01],
	[3.6665000000E+04, 8.2154920755E+00, 3.1194561928E+00, 9.4426657928E-01, 6.6608365611E-01, 8.6453617123E-01],
	[3.6670000000E+04, 8.2173252664E+00, 3.1194547331E+00, 9.4466497259E-01, 6.6629385489E-01, 8.6456384445E-01],
	[3.6675000000E+04, 8.2191586162E+00, 3.1194532735E+00, 9.4506347956E-01, 6.6650407132E-01, 8.6459151218E-01],
	[3.6680000000E+04, 8.2209921251E+00, 3.1194518142E+00, 9.4546210021E-01, 6.6671430537E-01, 8.6461917442E-01],
	[3.6685000000E+04, 8.2228257930E+00, 3.1194503550E+00, 9.4586083456E-01, 6.6692455704E-01, 8.6464683118E-01],
	[3.6690000000E+04, 8.2246596199E+00, 3.1194488961E+00, 9.4625968262E-01, 6.6713482631E-01, 8.6467448245E-01],
	[3.6695000000E+04, 8.2264936058E+00, 3.1194474373E+00, 9.4665864442E-01, 6.6734511318E-01, 8.6470212823E-01],
	[3.6700000000E+04, 8.2283277507E+00, 3.1194459788E+00, 9.4705771996E-01, 6.6755541762E-01, 8.6472976853E-01],
	[3.6705000000E+04, 8.2301620545E+00, 3.1194445204E+00, 9.4745690927E-01, 6.6776573962E-01, 8.6475740335E-01],
	[3.6710000000E+04, 8.2319965174E+00, 3.1194430623E+00, 9.4785621236E-01, 6.6797607917E-01, 8.6478503268E-01],
	[3.6715000000E+04, 8.2338311392E+00, 3.1194416043E+00, 9.4825562924E-01, 6.6818643626E-01, 8.6481265654E-01],
	[3.6720000000E+04, 8.2356659200E+00, 3.1194401466E+00, 9.4865515994E-01, 6.6839681088E-01, 8.6484027492E-01],
	[3.6725000000E+04, 8.2375008597E+00, 3.1194386890E+00, 9.4905480448E-01, 6.6860720301E-01, 8.6486788782E-01],
	[3.6730000000E+04, 8.2393359584E+00, 3.1194372316E+00, 9.4945456286E-01, 6.6881761263E-01, 8.6489549524E-01],
	[3.6735000000E+04, 8.2411712160E+00, 3.1194357745E+00, 9.4985443511E-01, 6.6902803974E-01, 8.6492309719E-01],
	[3.6740000000E+04, 8.2430066325E+00, 3.1194343175E+00, 9.5025442125E-01, 6.6923848433E-01, 8.6495069367E-01],
	[3.6745000000E+04, 8.2448422079E+00, 3.1194328608E+00, 9.5065452128E-01, 6.6944894637E-01, 8.6497828467E-01],
	[3.6750000000E+04, 8.2466779423E+00, 3.1194314042E+00, 9.5105473523E-01, 6.6965942586E-01, 8.6500587020E-01],
	[3.6755000000E+04, 8.2485138356E+00, 3.1194299478E+00, 9.5145506311E-01, 6.6986992278E-01, 8.6503345026E-01],
	[3.6760000000E+04, 8.2503498877E+00, 3.1194284917E+00, 9.5185550494E-01, 6.7008043712E-01, 8.6506102485E-01],
	[3.6765000000E+04, 8.2521860988E+00, 3.1194270357E+00, 9.5225606074E-01, 6.7029096886E-01, 8.6508859397E-01],
	[3.6770000000E+04, 8.2540224687E+00, 3.1194255800E+00, 9.5265673053E-01, 6.7050151800E-01, 8.6511615762E-01],
	[3.6775000000E+04, 8.2558589976E+00, 3.1194241244E+00, 9.5305751432E-01, 6.7071208452E-01, 8.6514371581E-01],
	[3.6780000000E+04, 8.2576956852E+00, 3.1194226690E+00, 9.5345841212E-01, 6.7092266841E-01, 8.6517126854E-01],
	[3.6785000000E+04, 8.2595325318E+00, 3.1194212138E+00, 9.5385942396E-01, 6.7113326965E-01, 8.6519881580E-01],
	[3.6790000000E+04, 8.2613695371E+00, 3.1194197589E+00, 9.5426054985E-01, 6.7134388824E-01, 8.6522635760E-01],
	[3.6795000000E+04, 8.2632067014E+00, 3.1194183041E+00, 9.5466178981E-01, 6.7155452415E-01, 8.6525389394E-01],
	[3.6800000000E+04, 8.2650440244E+00, 3.1194168495E+00, 9.5506314386E-01, 6.7176517737E-01, 8.6528142481E-01],
	[3.6805000000E+04, 8.2668815063E+00, 3.1194153952E+00, 9.5546461201E-01, 6.7197584790E-01, 8.6530895023E-01],
	[3.6810000000E+04, 8.2687204404E+00, 3.1194143863E+00, 9.5586619428E-01, 6.7218656494E-01, 8.6533647019E-01],
	[3.6815000000E+04, 8.2705628724E+00, 3.1194145272E+00, 9.5626789068E-01, 6.7239737476E-01, 8.6536398470E-01],
	[3.6820000000E+04, 8.2724054646E+00, 3.1194146679E+00, 9.5666970124E-01, 6.7260820195E-01, 8.6539149375E-01],
	[3.6825000000E+04, 8.2742482170E+00, 3.1194148087E+00, 9.5707162597E-01, 6.7281904649E-01, 8.6541899735E-01],
	[3.6830000000E+04, 8.2760911297E+00, 3.1194149495E+00, 9.5747366488E-01, 6.7302990838E-01, 8.6544649549E-01],
	[3.6835000000E+04, 8.2779342026E+00, 3.1194150902E+00, 9.5787581800E-01, 6.7324078758E-01, 8.6547398818E-01],
	[3.6840000000E+04, 8.2797774357E+00, 3.1194152309E+00, 9.5827808535E-01, 6.7345168411E-01, 8.6550147542E-01],
	[3.6845000000E+04, 8.2816208290E+00, 3.1194153716E+00, 9.5868046692E-01, 6.7366259793E-01, 8.6552895721E-01],
	[3.6850000000E+04, 8.2834643824E+00, 3.1194155123E+00, 9.5908296276E-01, 6.7387352904E-01, 8.6555643356E-01],
	[3.6855000000E+04, 8.2853080961E+00, 3.1194156529E+00, 9.5948557286E-01, 6.7408447742E-01, 8.6558390445E-01],
	[3.6860000000E+04, 8.2871519699E+00, 3.1194157936E+00, 9.5988829726E-01, 6.7429544307E-01, 8.6561136991E-01],
	[3.6865000000E+04, 8.2889960039E+00, 3.1194159342E+00, 9.6029113596E-01, 6.7450642596E-01, 8.6563882991E-01],
	[3.6870000000E+04, 8.2908401980E+00, 3.1194160748E+00, 9.6069408898E-01, 6.7471742609E-01, 8.6566628448E-01],
	[3.6875000000E+04, 8.2926845523E+00, 3.1194162154E+00, 9.6109715634E-01, 6.7492844344E-01, 8.6569373360E-01],
	[3.6880000000E+04, 8.2945290668E+00, 3.1194163559E+00, 9.6150033806E-01, 6.7513947800E-01, 8.6572117728E-01],
	[3.6885000000E+04, 8.2963737413E+00, 3.1194164965E+00, 9.6190363415E-01, 6.7535052976E-01, 8.6574861552E-01],
	[3.6890000000E+04, 8.2982185760E+00, 3.1194166370E+00, 9.6230704463E-01, 6.7556159870E-01, 8.6577604832E-01],
	[3.6895000000E+04, 8.3000635708E+00, 3.1194167775E+00, 9.6271056952E-01, 6.7577268480E-01, 8.6580347568E-01],
	[3.6900000000E+04, 8.3019087258E+00, 3.1194169180E+00, 9.6311420883E-01, 6.7598378807E-01, 8.6583089761E-01],
	[3.6905000000E+04, 8.3037540408E+00, 3.1194170584E+00, 9.6351796258E-01, 6.7619490848E-01, 8.6585831410E-01],
	[3.6910000000E+04, 8.3055995159E+00, 3.1194171989E+00, 9.6392183079E-01, 6.7640604602E-01, 8.6588572516E-01],
	[3.6915000000E+04, 8.3074451511E+00, 3.1194173393E+00, 9.6432581348E-01, 6.7661720067E-01, 8.6591313079E-01],
	[3.6920000000E+04, 8.3092909464E+00, 3.1194174797E+00, 9.6472991065E-01, 6.7682837244E-01, 8.6594053098E-01],
	[3.6925000000E+04, 8.3111369017E+00, 3.1194176201E+00, 9.6513412234E-01, 6.7703956129E-01, 8.6596792574E-01],
	[3.6930000000E+04, 8.3129830171E+00, 3.1194177605E+00, 9.6553844855E-01, 6.7725076722E-01, 8.6599531508E-01],
	[3.6935000000E+04, 8.3148292926E+00, 3.1194179008E+00, 9.6594288930E-01, 6.7746199022E-01, 8.6602269898E-01],
	[3.6940000000E+04, 8.3166757281E+00, 3.1194180411E+00, 9.6634744461E-01, 6.7767323026E-01, 8.6605007746E-01],
	[3.6945000000E+04, 8.3185223237E+00, 3.1194181814E+00, 9.6675211450E-01, 6.7788448735E-01, 8.6607745052E-01],
	[3.6950000000E+04, 8.3203690793E+00, 3.1194183217E+00, 9.6715689898E-01, 6.7809576147E-01, 8.6610481814E-01],
	[3.6955000000E+04, 8.3222159949E+00, 3.1194184620E+00, 9.6756179807E-01, 6.7830705259E-01, 8.6613218035E-01],
	[3.6960000000E+04, 8.3240630705E+00, 3.1194186023E+00, 9.6796681179E-01, 6.7851836072E-01, 8.6615953713E-01],
	[3.6965000000E+04, 8.3259103061E+00, 3.1194187425E+00, 9.6837194015E-01, 6.7872968583E-01, 8.6618688849E-01],
	[3.6970000000E+04, 8.3277577018E+00, 3.1194188827E+00, 9.6877718317E-01, 6.7894102792E-01, 8.6621423444E-01],
	[3.6975000000E+04, 8.3296052574E+00, 3.1194190229E+00, 9.6918254087E-01, 6.7915238697E-01, 8.6624157496E-01],
	[3.6980000000E+04, 8.3314529730E+00, 3.1194191631E+00, 9.6958801326E-01, 6.7936376296E-01, 8.6626891007E-01],
	[3.6985000000E+04, 8.3333008486E+00, 3.1194193033E+00, 9.6999360036E-01, 6.7957515589E-01, 8.6629623976E-01],
	[3.6990000000E+04, 8.3351488841E+00, 3.1194194434E+00, 9.7039930220E-01, 6.7978656574E-01, 8.6632356403E-01],
	[3.6995000000E+04, 8.3369970797E+00, 3.1194195835E+00, 9.7080511877E-01, 6.7999799250E-01, 8.6635088289E-01],
	[3.7000000000E+04, 8.3388454351E+00, 3.1194197236E+00, 9.7121105011E-01, 6.8020943615E-01, 8.6637819634E-01],
	[3.7005000000E+04, 8.3406939506E+00, 3.1194198637E+00, 9.7161709623E-01, 6.8042089669E-01, 8.6640550437E-01],
	[3.7010000000E+04, 8.3425426259E+00, 3.1194200038E+00, 9.7202325715E-01, 6.8063237410E-01, 8.6643280700E-01],
	[3.7015000000E+04, 8.3443914612E+00, 3.1194201438E+00, 9.7242953287E-01, 6.8084386836E-01, 8.6646010421E-01],
	[3.7020000000E+04, 8.3462404564E+00, 3.1194202838E+00, 9.7283592343E-01, 6.8105537946E-01, 8.6648739602E-01],
	[3.7025000000E+04, 8.3480896115E+00, 3.1194204239E+00, 9.7324242883E-01, 6.8126690740E-01, 8.6651468242E-01],
	[3.7030000000E+04, 8.3499389266E+00, 3.1194205638E+00, 9.7364904910E-01, 6.8147845215E-01, 8.6654196342E-01],
	[3.7035000000E+04, 8.3517884015E+00, 3.1194207038E+00, 9.7405578425E-01, 6.8169001370E-01, 8.6656923901E-01],
	[3.7040000000E+04, 8.3536380363E+00, 3.1194208438E+00, 9.7446263429E-01, 6.8190159205E-01, 8.6659650919E-01],
	[3.7045000000E+04, 8.3554878311E+00, 3.1194209837E+00, 9.7486959925E-01, 6.8211318717E-01, 8.6662377398E-01],
	[3.7050000000E+04, 8.3573377856E+00, 3.1194211236E+00, 9.7527667914E-01, 6.8232479906E-01, 8.6665103336E-01],
	[3.7055000000E+04, 8.3591879001E+00, 3.1194212635E+00, 9.7568387398E-01, 6.8253642770E-01, 8.6667828734E-01],
	[3.7060000000E+04, 8.3610381744E+00, 3.1194214034E+00, 9.7609118378E-01, 6.8274807308E-01, 8.6670553593E-01],
	[3.7065000000E+04, 8.3628886086E+00, 3.1194215432E+00, 9.7649860857E-01, 6.8295973518E-01, 8.6673277911E-01],
	[3.7070000000E+04, 8.3647392026E+00, 3.1194216831E+00, 9.7690614835E-01, 6.8317141399E-01, 8.6676001691E-01],
	[3.7075000000E+04, 8.3665899564E+00, 3.1194218229E+00, 9.7731380315E-01, 6.8338310951E-01, 8.6678724930E-01],
	[3.7080000000E+04, 8.3684408701E+00, 3.1194219627E+00, 9.7772157298E-01, 6.8359482171E-01, 8.6681447630E-01],
	[3.7085000000E+04, 8.3702919436E+00, 3.1194221025E+00, 9.7812945787E-01, 6.8380655058E-01, 8.6684169791E-01],
	[3.7090000000E+04, 8.3721431769E+00, 3.1194222423E+00, 9.7853745782E-01, 6.8401829611E-01, 8.6686891412E-01],
	[3.7095000000E+04, 8.3739945700E+00, 3.1194223820E+00, 9.7894557285E-01, 6.8423005829E-01, 8.6689612495E-01],
	[3.7100000000E+04, 8.3758461230E+00, 3.1194225217E+00, 9.7935380298E-01, 6.8444183711E-01, 8.6692333039E-01],
	[3.7105000000E+04, 8.3776978357E+00, 3.1194226614E+00, 9.7976214823E-01, 6.8465363254E-01, 8.6695053043E-01],
	[3.7110000000E+04, 8.3795497082E+00, 3.1194228011E+00, 9.8017060861E-01, 6.8486544458E-01, 8.6697772509E-01],
	[3.7115000000E+04, 8.3814017404E+00, 3.1194229408E+00, 9.8057918415E-01, 6.8507727322E-01, 8.6700491437E-01],
	[3.7120000000E+04, 8.3832539325E+00, 3.1194230804E+00, 9.8098787485E-01, 6.8528911843E-01, 8.6703209826E-01],
	[3.7125000000E+04, 8.3851062843E+00, 3.1194232201E+00, 9.8139668074E-01, 6.8550098022E-01, 8.6705927676E-01],
	[3.7130000000E+04, 8.3869587958E+00, 3.1194233597E+00, 9.8180560182E-01, 6.8571285856E-01, 8.6708644989E-01],
	[3.7135000000E+04, 8.3888114671E+00, 3.1194234993E+00, 9.8221463813E-01, 6.8592475344E-01, 8.6711361763E-01],
	[3.7140000000E+04, 8.3906642981E+00, 3.1194236389E+00, 9.8262378968E-01, 6.8613666486E-01, 8.6714077999E-01],
	[3.7145000000E+04, 8.3925172889E+00, 3.1194237784E+00, 9.8303305647E-01, 6.8634859278E-01, 8.6716793697E-01],
	[3.7150000000E+04, 8.3943704394E+00, 3.1194239179E+00, 9.8344243854E-01, 6.8656053721E-01, 8.6719508858E-01],
	[3.7155000000E+04, 8.3962237496E+00, 3.1194240575E+00, 9.8385193589E-01, 6.8677249814E-01, 8.6722223481E-01],
	[3.7160000000E+04, 8.3980772195E+00, 3.1194241970E+00, 9.8426154854E-01, 6.8698447553E-01, 8.6724937566E-01],
	[3.7165000000E+04, 8.3999308491E+00, 3.1194243364E+00, 9.8467127652E-01, 6.8719646939E-01, 8.6727651114E-01],
	[3.7170000000E+04, 8.4017846384E+00, 3.1194244759E+00, 9.8508111983E-01, 6.8740847971E-01, 8.6730364124E-01],
	[3.7175000000E+04, 8.4036385873E+00, 3.1194246154E+00, 9.8549107850E-01, 6.8762050646E-01, 8.6733076598E-01],
	[3.7180000000E+04, 8.4054926960E+00, 3.1194247548E+00, 9.8590115254E-01, 6.8783254963E-01, 8.6735788534E-01],
	[3.7185000000E+04, 8.4073469643E+00, 3.1194248942E+00, 9.8631134196E-01, 6.8804460921E-01, 8.6738499933E-01],
	[3.7190000000E+04, 8.4092013923E+00, 3.1194250336E+00, 9.8672164679E-01, 6.8825668520E-01, 8.6741210796E-01],
	[3.7195000000E+04, 8.4110559799E+00, 3.1194251729E+00, 9.8713206704E-01, 6.8846877757E-01, 8.6743921122E-01],
	[3.7200000000E+04, 8.4129107271E+00, 3.1194253123E+00, 9.8754260273E-01, 6.8868088631E-01, 8.6746630911E-01],
	[3.7205000000E+04, 8.4147656340E+00, 3.1194254516E+00, 9.8795325388E-01, 6.8889301141E-01, 8.6749340163E-01],
	[3.7210000000E+04, 8.4166207006E+00, 3.1194255909E+00, 9.8836402050E-01, 6.8910515285E-01, 8.6752048880E-01],
	[3.7215000000E+04, 8.4184759267E+00, 3.1194257302E+00, 9.8877490261E-01, 6.8931731063E-01, 8.6754757060E-01],
	[3.7220000000E+04, 8.4203313125E+00, 3.1194258695E+00, 9.8918590022E-01, 6.8952948473E-01, 8.6757464703E-01],
	[3.7225000000E+04, 8.4221868579E+00, 3.1194260088E+00, 9.8959701336E-01, 6.8974167514E-01, 8.6760171811E-01],
	[3.7230000000E+04, 8.4240425628E+00, 3.1194261480E+00, 9.9000824203E-01, 6.8995388183E-01, 8.6762878383E-01],
	[3.7235000000E+04, 8.4258984274E+00, 3.1194262872E+00, 9.9041958627E-01, 6.9016610481E-01, 8.6765584419E-01],
	[3.7240000000E+04, 8.4277544515E+00, 3.1194264264E+00, 9.9083104608E-01, 6.9037834406E-01, 8.6768289919E-01],
	[3.7245000000E+04, 8.4296106352E+00, 3.1194265656E+00, 9.9124262148E-01, 6.9059059956E-01, 8.6770994884E-01],
	[3.7250000000E+04, 8.4314669785E+00, 3.1194267048E+00, 9.9165431248E-01, 6.9080287130E-01, 8.6773699313E-01],
	[3.7255000000E+04, 8.4333234814E+00, 3.1194268439E+00, 9.9206611912E-01, 6.9101515927E-01, 8.6776403207E-01],
	[3.7260000000E+04, 8.4351801438E+00, 3.1194269830E+00, 9.9247804139E-01, 6.9122746346E-01, 8.6779106566E-01],
	[3.7265000000E+04, 8.4370369657E+00, 3.1194271221E+00, 9.9289007932E-01, 6.9143978385E-01, 8.6781809390E-01],
	[3.7270000000E+04, 8.4388939472E+00, 3.1194272612E+00, 9.9330223293E-01, 6.9165212043E-01, 8.6784511679E-01],
	[3.7275000000E+04, 8.4407510882E+00, 3.1194274003E+00, 9.9371450223E-01, 6.9186447318E-01, 8.6787213432E-01],
	[3.7280000000E+04, 8.4426083887E+00, 3.1194275394E+00, 9.9412688724E-01, 6.9207684210E-01, 8.6789914651E-01],
	[3.7285000000E+04, 8.4444658487E+00, 3.1194276784E+00, 9.9453938798E-01, 6.9228922716E-01, 8.6792615336E-01],
	[3.7290000000E+04, 8.4463234683E+00, 3.1194278174E+00, 9.9495200445E-01, 6.9250162836E-01, 8.6795315486E-01],
	[3.7295000000E+04, 8.4481812473E+00, 3.1194279564E+00, 9.9536473669E-01, 6.9271404569E-01, 8.6798015101E-01],
	[3.7300000000E+04, 8.4500391858E+00, 3.1194280954E+00, 9.9577758471E-01, 6.9292647913E-01, 8.6800714182E-01],
	[3.7305000000E+04, 8.4518972838E+00, 3.1194282343E+00, 9.9619054852E-01, 6.9313892866E-01, 8.6803412729E-01],
	[3.7310000000E+04, 8.4537555413E+00, 3.1194283733E+00, 9.9660362814E-01, 6.9335139428E-01, 8.6806110742E-01],
	[3.7315000000E+04, 8.4556139583E+00, 3.1194285122E+00, 9.9701682359E-01, 6.9356387597E-01, 8.6808808221E-01],
	[3.7320000000E+04, 8.4574725347E+00, 3.1194286511E+00, 9.9743013488E-01, 6.9377637371E-01, 8.6811505166E-01],
	[3.7325000000E+04, 8.4593312705E+00, 3.1194287900E+00, 9.9784356204E-01, 6.9398888751E-01, 8.6814201578E-01],
	[3.7330000000E+04, 8.4611901658E+00, 3.1194289288E+00, 9.9825710507E-01, 6.9420141733E-01, 8.6816897456E-01],
	[3.7335000000E+04, 8.4630492206E+00, 3.1194290677E+00, 9.9867076400E-01, 6.9441396318E-01, 8.6819592800E-01],
	[3.7340000000E+04, 8.4649084347E+00, 3.1194292065E+00, 9.9908453884E-01, 6.9462652503E-01, 8.6822287611E-01],
	[3.7345000000E+04, 8.4667678083E+00, 3.1194293453E+00, 9.9949842962E-01, 6.9483910287E-01, 8.6824981889E-01],
	[3.7350000000E+04, 8.4686273413E+00, 3.1194294841E+00, 9.9991243633E-01, 6.9505169669E-01, 8.6827675633E-01],
	[3.7355000000E+04, 8.4704870337E+00, 3.1194296229E+00, 1.0003265590E+00, 6.9526430648E-01, 8.6830368845E-01],
	[3.7360000000E+04, 8.4723468856E+00, 3.1194297616E+00, 1.0007407977E+00, 6.9547693222E-01, 8.6833061523E-01],
	[3.7365000000E+04, 8.4742068967E+00, 3.1194299004E+00, 1.0011551523E+00, 6.9568957391E-01, 8.6835753669E-01],
	[3.7370000000E+04, 8.4760670673E+00, 3.1194300391E+00, 1.0015696230E+00, 6.9590223152E-01, 8.6838445282E-01],
	[3.7375000000E+04, 8.4779273973E+00, 3.1194301778E+00, 1.0019842097E+00, 6.9611490504E-01, 8.6841136363E-01],
	[3.7380000000E+04, 8.4797878866E+00, 3.1194303165E+00, 1.0023989125E+00, 6.9632759447E-01, 8.6843826911E-01],
	[3.7385000000E+04, 8.4816485353E+00, 3.1194304551E+00, 1.0028137313E+00, 6.9654029978E-01, 8.6846516927E-01],
	[3.7390000000E+04, 8.4835093433E+00, 3.1194305938E+00, 1.0032286662E+00, 6.9675302097E-01, 8.6849206411E-01],
	[3.7395000000E+04, 8.4853703107E+00, 3.1194307324E+00, 1.0036437172E+00, 6.9696575802E-01, 8.6851895362E-01],
	[3.7400000000E+04, 8.4872314374E+00, 3.1194308710E+00, 1.0040588843E+00, 6.9717851092E-01, 8.6854583782E-01],
	[3.7405000000E+04, 8.4890962955E+00, 3.1194322061E+00, 1.0044741675E+00, 6.9739136357E-01, 8.6857271670E-01],
	[3.7410000000E+04, 8.4909624081E+00, 3.1194339074E+00, 1.0048895669E+00, 6.9760425782E-01, 8.6859959025E-01],
	[3.7415000000E+04, 8.4928286815E+00, 3.1194356085E+00, 1.0053050825E+00, 6.9781716800E-01, 8.6862645850E-01],
	[3.7420000000E+04, 8.4946951155E+00, 3.1194373093E+00, 1.0057207142E+00, 6.9803009407E-01, 8.6865332143E-01],
	[3.7425000000E+04, 8.4965617103E+00, 3.1194390099E+00, 1.0061364622E+00, 6.9824303603E-01, 8.6868017904E-01],
	[3.7430000000E+04, 8.4984284658E+00, 3.1194407103E+00, 1.0065523263E+00, 6.9845599387E-01, 8.6870703134E-01],
	[3.7435000000E+04, 8.5002953821E+00, 3.1194424105E+00, 1.0069683067E+00, 6.9866896757E-01, 8.6873387833E-01],
	[3.7440000000E+04, 8.5021624590E+00, 3.1194441104E+00, 1.0073844034E+00, 6.9888195713E-01, 8.6876072001E-01],
	[3.7445000000E+04, 8.5040296966E+00, 3.1194458101E+00, 1.0078006163E+00, 6.9909496251E-01, 8.6878755638E-01],
	[3.7450000000E+04, 8.5058970949E+00, 3.1194475096E+00, 1.0082169455E+00, 6.9930798373E-01, 8.6881438744E-01],
	[3.7455000000E+04, 8.5077646538E+00, 3.1194492089E+00, 1.0086333910E+00, 6.9952102075E-01, 8.6884121319E-01],
	[3.7460000000E+04, 8.5096323735E+00, 3.1194509079E+00, 1.0090499528E+00, 6.9973407357E-01, 8.6886803364E-01],
	[3.7465000000E+04, 8.5115002538E+00, 3.1194526067E+00, 1.0094666309E+00, 6.9994714217E-01, 8.6889484878E-01],
	[3.7470000000E+04, 8.5133682947E+00, 3.1194543053E+00, 1.0098834254E+00, 7.0016022655E-01, 8.6892165862E-01],
	[3.7475000000E+04, 8.5152364963E+00, 3.1194560036E+00, 1.0103003363E+00, 7.0037332669E-01, 8.6894846316E-01],
	[3.7480000000E+04, 8.5171048586E+00, 3.1194577018E+00, 1.0107173636E+00, 7.0058644257E-01, 8.6897526239E-01],
	[3.7485000000E+04, 8.5189733815E+00, 3.1194593997E+00, 1.0111345072E+00, 7.0079957418E-01, 8.6900205633E-01],
	[3.7490000000E+04, 8.5208420650E+00, 3.1194610973E+00, 1.0115517673E+00, 7.0101272151E-01, 8.6902884497E-01],
	[3.7495000000E+04, 8.5227109091E+00, 3.1194627948E+00, 1.0119691439E+00, 7.0122588455E-01, 8.6905562830E-01],
	[3.7500000000E+04, 8.5245799138E+00, 3.1194644920E+00, 1.0123866368E+00, 7.0143906328E-01, 8.6908240635E-01],
	[3.7505000000E+04, 8.5264490791E+00, 3.1194661890E+00, 1.0128042463E+00, 7.0165225770E-01, 8.6910917909E-01],
	[3.7510000000E+04, 8.5283184050E+00, 3.1194678858E+00, 1.0132219722E+00, 7.0186546778E-01, 8.6913594654E-01],
	[3.7515000000E+04, 8.5301878915E+00, 3.1194695823E+00, 1.0136398147E+00, 7.0207869351E-01, 8.6916270870E-01],
	[3.7520000000E+04, 8.5320575386E+00, 3.1194712787E+00, 1.0140577736E+00, 7.0229193489E-01, 8.6918946557E-01],
	[3.7525000000E+04, 8.5339273463E+00, 3.1194729748E+00, 1.0144758491E+00, 7.0250519189E-01, 8.6921621714E-01],
	[3.7530000000E+04, 8.5357973145E+00, 3.1194746707E+00, 1.0148940412E+00, 7.0271846451E-01, 8.6924296343E-01],
	[3.7535000000E+04, 8.5376674433E+00, 3.1194763663E+00, 1.0153123498E+00, 7.0293175273E-01, 8.6926970442E-01],
	[3.7540000000E+04, 8.5395377326E+00, 3.1194780617E+00, 1.0157307750E+00, 7.0314505654E-01, 8.6929644013E-01],
	[3.7545000000E+04, 8.5414081824E+00, 3.1194797569E+00, 1.0161493169E+00, 7.0335837592E-01, 8.6932317055E-01],
	[3.7550000000E+04, 8.5432787928E+00, 3.1194814519E+00, 1.0165679753E+00, 7.0357171087E-01, 8.6934989569E-01],
	[3.7555000000E+04, 8.5451495637E+00, 3.1194831467E+00, 1.0169867504E+00, 7.0378506137E-01, 8.6937661554E-01],
	[3.7560000000E+04, 8.5470204952E+00, 3.1194848412E+00, 1.0174056421E+00, 7.0399842741E-01, 8.6940333011E-01],
	[3.7565000000E+04, 8.5488915871E+00, 3.1194865355E+00, 1.0178246506E+00, 7.0421180896E-01, 8.6943003940E-01],
	[3.7570000000E+04, 8.5507628396E+00, 3.1194882296E+00, 1.0182437757E+00, 7.0442520603E-01, 8.6945674341E-01],
	[3.7575000000E+04, 8.5526342525E+00, 3.1194899234E+00, 1.0186630175E+00, 7.0463861860E-01, 8.6948344214E-01],
	[3.7580000000E+04, 8.5545058259E+00, 3.1194916170E+00, 1.0190823760E+00, 7.0485204665E-01, 8.6951013559E-01],
	[3.7585000000E+04, 8.5563775598E+00, 3.1194933105E+00, 1.0195018513E+00, 7.0506549018E-01, 8.6953682376E-01],
	[3.7590000000E+04, 8.5582494542E+00, 3.1194950036E+00, 1.0199214434E+00, 7.0527894916E-01, 8.6956350665E-01],
	[3.7595000000E+04, 8.5601215091E+00, 3.1194966966E+00, 1.0203411522E+00, 7.0549242359E-01, 8.6959018428E-01],
	[3.7600000000E+04, 8.5619937244E+00, 3.1194983893E+00, 1.0207609778E+00, 7.0570591345E-01, 8.6961685662E-01],
	[3.7605000000E+04, 8.5638661001E+00, 3.1195000818E+00, 1.0211809202E+00, 7.0591941873E-01, 8.6964352370E-01],
	[3.7610000000E+04, 8.5657386363E+00, 3.1195017741E+00, 1.0216009795E+00, 7.0613293942E-01, 8.6967018550E-01],
	[3.7615000000E+04, 8.5676113329E+00, 3.1195034662E+00, 1.0220211556E+00, 7.0634647550E-01, 8.6969684203E-01],
	[3.7620000000E+04, 8.5694841900E+00, 3.1195051580E+00, 1.0224414485E+00, 7.0656002696E-01, 8.6972349330E-01],
	[3.7625000000E+04, 8.5713572075E+00, 3.1195068496E+00, 1.0228618584E+00, 7.0677359379E-01, 8.6975013929E-01],
	[3.7630000000E+04, 8.5732303853E+00, 3.1195085410E+00, 1.0232823851E+00, 7.0698717597E-01, 8.6977678002E-01],
	[3.7635000000E+04, 8.5751037236E+00, 3.1195102322E+00, 1.0237030287E+00, 7.0720077349E-01, 8.6980341548E-01],
	[3.7640000000E+04, 8.5769772223E+00, 3.1195119231E+00, 1.0241237893E+00, 7.0741438635E-01, 8.6983004568E-01],
	[3.7645000000E+04, 8.5788508814E+00, 3.1195136138E+00, 1.0245446668E+00, 7.0762801451E-01, 8.6985667062E-01],
	[3.7650000000E+04, 8.5807247008E+00, 3.1195153043E+00, 1.0249656613E+00, 7.0784165798E-01, 8.6988329029E-01],
	[3.7655000000E+04, 8.5825986806E+00, 3.1195169946E+00, 1.0253867727E+00, 7.0805531674E-01, 8.6990990470E-01],
	[3.7660000000E+04, 8.5844728208E+00, 3.1195186846E+00, 1.0258080012E+00, 7.0826899078E-01, 8.6993651385E-01],
	[3.7665000000E+04, 8.5863471214E+00, 3.1195203744E+00, 1.0262293466E+00, 7.0848268007E-01, 8.6996311774E-01],
	[3.7670000000E+04, 8.5882215823E+00, 3.1195220640E+00, 1.0266508091E+00, 7.0869638462E-01, 8.6998971638E-01],
	[3.7675000000E+04, 8.5900962035E+00, 3.1195237534E+00, 1.0270723887E+00, 7.0891010441E-01, 8.7001630975E-01],
	[3.7680000000E+04, 8.5919709851E+00, 3.1195254426E+00, 1.0274940853E+00, 7.0912383942E-01, 8.7004289788E-01],
	[3.7685000000E+04, 8.5938459270E+00, 3.1195271315E+00, 1.0279158990E+00, 7.0933758964E-01, 8.7006948074E-01],
	[3.7690000000E+04, 8.5957210292E+00, 3.1195288202E+00, 1.0283378297E+00, 7.0955135506E-01, 8.7009605836E-01],
	[3.7695000000E+04, 8.5975962918E+00, 3.1195305087E+00, 1.0287598776E+00, 7.0976513566E-01, 8.7012263072E-01],
	[3.7700000000E+04, 8.5994717146E+00, 3.1195321970E+00, 1.0291820427E+00, 7.0997893143E-01, 8.7014919783E-01],
	[3.7705000000E+04, 8.6013472977E+00, 3.1195338850E+00, 1.0296043248E+00, 7.1019274237E-01, 8.7017575969E-01],
	[3.7710000000E+04, 8.6032230412E+00, 3.1195355728E+00, 1.0300267242E+00, 7.1040656845E-01, 8.7020231631E-01],
	[3.7715000000E+04, 8.6050989449E+00, 3.1195372604E+00, 1.0304492407E+00, 7.1062040966E-01, 8.7022886767E-01],
	[3.7720000000E+04, 8.6069750089E+00, 3.1195389478E+00, 1.0308718744E+00, 7.1083426599E-01, 8.7025541379E-01],
	[3.7725000000E+04, 8.6088512331E+00, 3.1195406349E+00, 1.0312946254E+00, 7.1104813743E-01, 8.7028195467E-01],
	[3.7730000000E+04, 8.6107276176E+00, 3.1195423218E+00, 1.0317174935E+00, 7.1126202396E-01, 8.7030849030E-01],
	[3.7735000000E+04, 8.6126041624E+00, 3.1195440085E+00, 1.0321404790E+00, 7.1147592558E-01, 8.7033502068E-01],
	[3.7740000000E+04, 8.6144808674E+00, 3.1195456950E+00, 1.0325635816E+00, 7.1168984226E-01, 8.7036154583E-01],
	[3.7745000000E+04, 8.6163577327E+00, 3.1195473813E+00, 1.0329868016E+00, 7.1190377399E-01, 8.7038806573E-01],
	[3.7750000000E+04, 8.6182347581E+00, 3.1195490673E+00, 1.0334101389E+00, 7.1211772077E-01, 8.7041458040E-01],
	[3.7755000000E+04, 8.6201119438E+00, 3.1195507531E+00, 1.0338335935E+00, 7.1233168258E-01, 8.7044108983E-01],
	[3.7760000000E+04, 8.6219892898E+00, 3.1195524387E+00, 1.0342571654E+00, 7.1254565940E-01, 8.7046759401E-01],
	[3.7765000000E+04, 8.6238667959E+00, 3.1195541241E+00, 1.0346808547E+00, 7.1275965122E-01, 8.7049409297E-01],
	[3.7770000000E+04, 8.6257444622E+00, 3.1195558092E+00, 1.0351046613E+00, 7.1297365803E-01, 8.7052058669E-01],
	[3.7775000000E+04, 8.6276222887E+00, 3.1195574941E+00, 1.0355285854E+00, 7.1318767982E-01, 8.7054707517E-01],
	[3.7780000000E+04, 8.6295002754E+00, 3.1195591788E+00, 1.0359526268E+00, 7.1340171658E-01, 8.7057355842E-01],
	[3.7785000000E+04, 8.6313784223E+00, 3.1195608633E+00, 1.0363767856E+00, 7.1361576828E-01, 8.7060003644E-01],
	[3.7790000000E+04, 8.6332567293E+00, 3.1195625476E+00, 1.0368010619E+00, 7.1382983492E-01, 8.7062650923E-01],
	[3.7795000000E+04, 8.6351351965E+00, 3.1195642316E+00, 1.0372254557E+00, 7.1404391649E-01, 8.7065297679E-01],
	[3.7800000000E+04, 8.6370138239E+00, 3.1195659154E+00, 1.0376499669E+00, 7.1425801296E-01, 8.7067943913E-01],
	[3.7805000000E+04, 8.6388926114E+00, 3.1195675990E+00, 1.0380745956E+00, 7.1447212434E-01, 8.7070589623E-01],
	[3.7810000000E+04, 8.6407715591E+00, 3.1195692824E+00, 1.0384993418E+00, 7.1468625060E-01, 8.7073234811E-01],
	[3.7815000000E+04, 8.6426506668E+00, 3.1195709655E+00, 1.0389242055E+00, 7.1490039173E-01, 8.7075879477E-01],
	[3.7820000000E+04, 8.6445299347E+00, 3.1195726484E+00, 1.0393491868E+00, 7.1511454772E-01, 8.7078523620E-01],
	[3.7825000000E+04, 8.6464093628E+00, 3.1195743311E+00, 1.0397742856E+00, 7.1532871856E-01, 8.7081167241E-01],
	[3.7830000000E+04, 8.6482889509E+00, 3.1195760136E+00, 1.0401995020E+00, 7.1554290423E-01, 8.7083810339E-01],
	[3.7835000000E+04, 8.6501686991E+00, 3.1195776959E+00, 1.0406248360E+00, 7.1575710472E-01, 8.7086452916E-01],
	[3.7840000000E+04, 8.6520486074E+00, 3.1195793779E+00, 1.0410502876E+00, 7.1597132002E-01, 8.7089094971E-01],
	[3.7845000000E+04, 8.6539286758E+00, 3.1195810597E+00, 1.0414758568E+00, 7.1618555011E-01, 8.7091736504E-01],
	[3.7850000000E+04, 8.6558089043E+00, 3.1195827413E+00, 1.0419015436E+00, 7.1639979498E-01, 8.7094377515E-01],
	[3.7855000000E+04, 8.6576892929E+00, 3.1195844227E+00, 1.0423273481E+00, 7.1661405462E-01, 8.7097018005E-01],
	[3.7860000000E+04, 8.6595698415E+00, 3.1195861038E+00, 1.0427532703E+00, 7.1682832902E-01, 8.7099657974E-01],
	[3.7865000000E+04, 8.6614505502E+00, 3.1195877848E+00, 1.0431793102E+00, 7.1704261815E-01, 8.7102297421E-01],
	[3.7870000000E+04, 8.6633314189E+00, 3.1195894655E+00, 1.0436054677E+00, 7.1725692202E-01, 8.7104936346E-01],
	[3.7875000000E+04, 8.6652124477E+00, 3.1195911460E+00, 1.0440317431E+00, 7.1747124060E-01, 8.7107574751E-01],
	[3.7880000000E+04, 8.6670936365E+00, 3.1195928262E+00, 1.0444581361E+00, 7.1768557389E-01, 8.7110212635E-01],
	[3.7885000000E+04, 8.6689749853E+00, 3.1195945063E+00, 1.0448846469E+00, 7.1789992186E-01, 8.7112849998E-01],
	[3.7890000000E+04, 8.6708564942E+00, 3.1195961861E+00, 1.0453112755E+00, 7.1811428451E-01, 8.7115486840E-01],
	[3.7895000000E+04, 8.6727381630E+00, 3.1195978657E+00, 1.0457380218E+00, 7.1832866183E-01, 8.7118123161E-01],
	[3.7900000000E+04, 8.6746199919E+00, 3.1195995451E+00, 1.0461648860E+00, 7.1854305380E-01, 8.7120758962E-01],
	[3.7905000000E+04, 8.6765019808E+00, 3.1196012243E+00, 1.0465918680E+00, 7.1875746040E-01, 8.7123394242E-01],
	[3.7910000000E+04, 8.6783841296E+00, 3.1196029032E+00, 1.0470189679E+00, 7.1897188163E-01, 8.7126029002E-01],
	[3.7915000000E+04, 8.6802664385E+00, 3.1196045820E+00, 1.0474461856E+00, 7.1918631747E-01, 8.7128663242E-01],
	[3.7920000000E+04, 8.6821489073E+00, 3.1196062605E+00, 1.0478735212E+00, 7.1940076791E-01, 8.7131296962E-01],
	[3.7925000000E+04, 8.6840315360E+00, 3.1196079387E+00, 1.0483009746E+00, 7.1961523294E-01, 8.7133930162E-01],
	[3.7930000000E+04, 8.6859143248E+00, 3.1196096168E+00, 1.0487285460E+00, 7.1982971253E-01, 8.7136562842E-01],
	[3.7935000000E+04, 8.6877972735E+00, 3.1196112946E+00, 1.0491562353E+00, 7.2004420669E-01, 8.7139195002E-01],
	[3.7940000000E+04, 8.6896803821E+00, 3.1196129723E+00, 1.0495840426E+00, 7.2025871540E-01, 8.7141826643E-01],
	[3.7945000000E+04, 8.6915636506E+00, 3.1196146497E+00, 1.0500119678E+00, 7.2047323863E-01, 8.7144457764E-01],
	[3.7950000000E+04, 8.6934470791E+00, 3.1196163269E+00, 1.0504400110E+00, 7.2068777639E-01, 8.7147088365E-01],
	[3.7955000000E+04, 8.6953306675E+00, 3.1196180038E+00, 1.0508681722E+00, 7.2090232866E-01, 8.7149718448E-01],
	[3.7960000000E+04, 8.6972144159E+00, 3.1196196806E+00, 1.0512964514E+00, 7.2111689542E-01, 8.7152348011E-01],
	[3.7965000000E+04, 8.6990983241E+00, 3.1196213571E+00, 1.0517248487E+00, 7.2133147666E-01, 8.7154977055E-01],
	[3.7970000000E+04, 8.7009823922E+00, 3.1196230334E+00, 1.0521533640E+00, 7.2154607237E-01, 8.7157605580E-01],
	[3.7975000000E+04, 8.7028666203E+00, 3.1196247095E+00, 1.0525819973E+00, 7.2176068254E-01, 8.7160233586E-01],
	[3.7980000000E+04, 8.7047510082E+00, 3.1196263853E+00, 1.0530107487E+00, 7.2197530715E-01, 8.7162861074E-01],
	[3.7985000000E+04, 8.7066355560E+00, 3.1196280610E+00, 1.0534396183E+00, 7.2218994619E-01, 8.7165488043E-01],
	[3.7990000000E+04, 8.7085202636E+00, 3.1196297364E+00, 1.0538686059E+00, 7.2240459964E-01, 8.7168114493E-01],
	[3.7995000000E+04, 8.7104051311E+00, 3.1196314116E+00, 1.0542977117E+00, 7.2261926750E-01, 8.7170740425E-01],
	[3.8000000000E+04, 8.7122901585E+00, 3.1196330866E+00, 1.0547269356E+00, 7.2283394975E-01, 8.7173365839E-01],
	[3.8005000000E+04, 8.7141769625E+00, 3.1196352882E+00, 1.0551562777E+00, 7.2304868581E-01, 8.7175990735E-01],
	[3.8010000000E+04, 8.7160670108E+00, 3.1196384943E+00, 1.0555857379E+00, 7.2326351151E-01, 8.7178615112E-01],
	[3.8015000000E+04, 8.7179572203E+00, 3.1196417000E+00, 1.0560153164E+00, 7.2347835167E-01, 8.7181238972E-01],
	[3.8020000000E+04, 8.7198475911E+00, 3.1196449053E+00, 1.0564450131E+00, 7.2369320628E-01, 8.7183862314E-01],
	[3.8025000000E+04, 8.7217381231E+00, 3.1196481101E+00, 1.0568748280E+00, 7.2390807532E-01, 8.7186485138E-01],
	[3.8030000000E+04, 8.7236288163E+00, 3.1196513145E+00, 1.0573047612E+00, 7.2412295878E-01, 8.7189107444E-01],
	[3.8035000000E+04, 8.7255196707E+00, 3.1196545186E+00, 1.0577348126E+00, 7.2433785664E-01, 8.7191729233E-01],
	[3.8040000000E+04, 8.7274106864E+00, 3.1196577221E+00, 1.0581649823E+00, 7.2455276890E-01, 8.7194350505E-01],
	[3.8045000000E+04, 8.7293018633E+00, 3.1196609253E+00, 1.0585952703E+00, 7.2476769554E-01, 8.7196971259E-01],
	[3.8050000000E+04, 8.7311932013E+00, 3.1196641281E+00, 1.0590256767E+00, 7.2498263655E-01, 8.7199591496E-01],
	[3.8055000000E+04, 8.7330847006E+00, 3.1196673304E+00, 1.0594562013E+00, 7.2519759191E-01, 8.7202211216E-01],
	[3.8060000000E+04, 8.7349763610E+00, 3.1196705323E+00, 1.0598868444E+00, 7.2541256161E-01, 8.7204830420E-01],
	[3.8065000000E+04, 8.7368681827E+00, 3.1196737339E+00, 1.0603176058E+00, 7.2562754564E-01, 8.7207449106E-01],
	[3.8070000000E+04, 8.7387601654E+00, 3.1196769349E+00, 1.0607484855E+00, 7.2584254399E-01, 8.7210067276E-01],
	[3.8075000000E+04, 8.7406523094E+00, 3.1196801356E+00, 1.0611794837E+00, 7.2605755664E-01, 8.7212684929E-01],
	[3.8080000000E+04, 8.7425446145E+00, 3.1196833359E+00, 1.0616106003E+00, 7.2627258358E-01, 8.7215302065E-01],
	[3.8085000000E+04, 8.7444370807E+00, 3.1196865357E+00, 1.0620418353E+00, 7.2648762480E-01, 8.7217918686E-01],
	[3.8090000000E+04, 8.7463297081E+00, 3.1196897351E+00, 1.0624731888E+00, 7.2670268028E-01, 8.7220534790E-01],
	[3.8095000000E+04, 8.7482224966E+00, 3.1196929341E+00, 1.0629046608E+00, 7.2691775001E-01, 8.7223150377E-01],
	[3.8100000000E+04, 8.7501154462E+00, 3.1196961327E+00, 1.0633362512E+00, 7.2713283398E-01, 8.7225765449E-01],
	[3.8105000000E+04, 8.7520085570E+00, 3.1196993309E+00, 1.0637679602E+00, 7.2734793217E-01, 8.7228380005E-01],
	[3.8110000000E+04, 8.7539018288E+00, 3.1197025286E+00, 1.0641997876E+00, 7.2756304458E-01, 8.7230994045E-01],
	[3.8115000000E+04, 8.7557952618E+00, 3.1197057260E+00, 1.0646317336E+00, 7.2777817119E-01, 8.7233607570E-01],
	[3.8120000000E+04, 8.7576888558E+00, 3.1197089229E+00, 1.0650637982E+00, 7.2799331198E-01, 8.7236220579E-01],
	[3.8125000000E+04, 8.7595826110E+00, 3.1197121194E+00, 1.0654959813E+00, 7.2820846694E-01, 8.7238833072E-01],
	[3.8130000000E+04, 8.7614765272E+00, 3.1197153155E+00, 1.0659282831E+00, 7.2842363606E-01, 8.7241445050E-01],
	[3.8135000000E+04, 8.7633706045E+00, 3.1197185112E+00, 1.0663607034E+00, 7.2863881934E-01, 8.7244056513E-01],
	[3.8140000000E+04, 8.7652648428E+00, 3.1197217064E+00, 1.0667932423E+00, 7.2885401674E-01, 8.7246667460E-01],
	[3.8145000000E+04, 8.7671592422E+00, 3.1197249013E+00, 1.0672258999E+00, 7.2906922827E-01, 8.7249277893E-01],
	[3.8150000000E+04, 8.7690538027E+00, 3.1197280957E+00, 1.0676586762E+00, 7.2928445390E-01, 8.7251887811E-01],
	[3.8155000000E+04, 8.7709485242E+00, 3.1197312897E+00, 1.0680915711E+00, 7.2949969363E-01, 8.7254497214E-01],
	[3.8160000000E+04, 8.7728434067E+00, 3.1197344833E+00, 1.0685245847E+00, 7.2971494745E-01, 8.7257106102E-01],
	[3.8165000000E+04, 8.7747384502E+00, 3.1197376765E+00, 1.0689577170E+00, 7.2993021533E-01, 8.7259714476E-01],
	[3.8170000000E+04, 8.7766336548E+00, 3.1197408693E+00, 1.0693909681E+00, 7.3014549727E-01, 8.7262322335E-01],
	[3.8175000000E+04, 8.7785290204E+00, 3.1197440616E+00, 1.0698243378E+00, 7.3036079325E-01, 8.7264929680E-01],
	[3.8180000000E+04, 8.7804245470E+00, 3.1197472536E+00, 1.0702578264E+00, 7.3057610326E-01, 8.7267536511E-01],
	[3.8185000000E+04, 8.7823202346E+00, 3.1197504451E+00, 1.0706914337E+00, 7.3079142729E-01, 8.7270142827E-01],
	[3.8190000000E+04, 8.7842160832E+00, 3.1197536362E+00, 1.0711251598E+00, 7.3100676532E-01, 8.7272748630E-01],
	[3.8195000000E+04, 8.7861120927E+00, 3.1197568269E+00, 1.0715590047E+00, 7.3122211735E-01, 8.7275353918E-01],
	[3.8200000000E+04, 8.7880082632E+00, 3.1197600172E+00, 1.0719929685E+00, 7.3143748335E-01, 8.7277958693E-01],
	[3.8205000000E+04, 8.7899045947E+00, 3.1197632070E+00, 1.0724270511E+00, 7.3165286332E-01, 8.7280562955E-01],
	[3.8210000000E+04, 8.7918010872E+00, 3.1197663965E+00, 1.0728612525E+00, 7.3186825724E-01, 8.7283166702E-01],
	[3.8215000000E+04, 8.7936977406E+00, 3.1197695855E+00, 1.0732955729E+00, 7.3208366510E-01, 8.7285769936E-01],
	[3.8220000000E+04, 8.7955945550E+00, 3.1197727742E+00, 1.0737300121E+00, 7.3229908689E-01, 8.7288372657E-01],
	[3.8225000000E+04, 8.7974915303E+00, 3.1197759624E+00, 1.0741645702E+00, 7.3251452260E-01, 8.7290974865E-01],
	[3.8230000000E+04, 8.7993886665E+00, 3.1197791502E+00, 1.0745992473E+00, 7.3272997220E-01, 8.7293576560E-01],
	[3.8235000000E+04, 8.8012859636E+00, 3.1197823375E+00, 1.0750340433E+00, 7.3294543569E-01, 8.7296177741E-01],
	[3.8240000000E+04, 8.8031834217E+00, 3.1197855245E+00, 1.0754689583E+00, 7.3316091306E-01, 8.7298778410E-01],
	[3.8245000000E+04, 8.8050810407E+00, 3.1197887111E+00, 1.0759039922E+00, 7.3337640428E-01, 8.7301378566E-01],
	[3.8250000000E+04, 8.8069788205E+00, 3.1197918972E+00, 1.0763391451E+00, 7.3359190936E-01, 8.7303978209E-01],
	[3.8255000000E+04, 8.8088767613E+00, 3.1197950829E+00, 1.0767744171E+00, 7.3380742827E-01, 8.7306577340E-01],
	[3.8260000000E+04, 8.8107748629E+00, 3.1197982682E+00, 1.0772098081E+00, 7.3402296101E-01, 8.7309175958E-01],
	[3.8265000000E+04, 8.8126731255E+00, 3.1198014532E+00, 1.0776453181E+00, 7.3423850755E-01, 8.7311774064E-01],
	[3.8270000000E+04, 8.8145715489E+00, 3.1198046376E+00, 1.0780809472E+00, 7.3445406790E-01, 8.7314371657E-01],
	[3.8275000000E+04, 8.8164701331E+00, 3.1198078217E+00, 1.0785166954E+00, 7.3466964203E-01, 8.7316968739E-01],
	[3.8280000000E+04, 8.8183688782E+00, 3.1198110054E+00, 1.0789525627E+00, 7.3488522992E-01, 8.7319565309E-01],
	[3.8285000000E+04, 8.8202677842E+00, 3.1198141886E+00, 1.0793885490E+00, 7.3510083158E-01, 8.7322161366E-01],
	[3.8290000000E+04, 8.8221668510E+00, 3.1198173715E+00, 1.0798246546E+00, 7.3531644698E-01, 8.7324756912E-01],
	[3.8295000000E+04, 8.8240660787E+00, 3.1198205539E+00, 1.0802608792E+00, 7.3553207612E-01, 8.7327351947E-01],
	[3.8300000000E+04, 8.8259654671E+00, 3.1198237359E+00, 1.0806972231E+00, 7.3574771897E-01, 8.7329946469E-01],
	[3.8305000000E+04, 8.8278650164E+00, 3.1198269175E+00, 1.0811336861E+00, 7.3596337553E-01, 8.7332540481E-01],
	[3.8310000000E+04, 8.8297647265E+00, 3.1198300987E+00, 1.0815702683E+00, 7.3617904579E-01, 8.7335133981E-01],
	[3.8315000000E+04, 8.8316645974E+00, 3.1198332795E+00, 1.0820069697E+00, 7.3639472972E-01, 8.7337726969E-01],
	[3.8320000000E+04, 8.8335646291E+00, 3.1198364599E+00, 1.0824437904E+00, 7.3661042733E-01, 8.7340319447E-01],
	[3.8325000000E+04, 8.8354648216E+00, 3.1198396398E+00, 1.0828807303E+00, 7.3682613858E-01, 8.7342911414E-01],
	[3.8330000000E+04, 8.8373651749E+00, 3.1198428193E+00, 1.0833177895E+00, 7.3704186348E-01, 8.7345502870E-01],
	[3.8335000000E+04, 8.8392656889E+00, 3.1198459985E+00, 1.0837549680E+00, 7.3725760201E-01, 8.7348093815E-01],
	[3.8340000000E+04, 8.8411663638E+00, 3.1198491772E+00, 1.0841922657E+00, 7.3747335415E-01, 8.7350684249E-01],
	[3.8345000000E+04, 8.8430671993E+00, 3.1198523555E+00, 1.0846296828E+00, 7.3768911990E-01, 8.7353274173E-01],
	[3.8350000000E+04, 8.8449681957E+00, 3.1198555334E+00, 1.0850672193E+00, 7.3790489924E-01, 8.7355863586E-01],
	[3.8355000000E+04, 8.8468693528E+00, 3.1198587109E+00, 1.0855048750E+00, 7.3812069215E-01, 8.7358452490E-01],
	[3.8360000000E+04, 8.8487706706E+00, 3.1198618880E+00, 1.0859426502E+00, 7.3833649863E-01, 8.7361040882E-01],
	[3.8365000000E+04, 8.8506721491E+00, 3.1198650646E+00, 1.0863805447E+00, 7.3855231866E-01, 8.7363628765E-01],
	[3.8370000000E+04, 8.8525737884E+00, 3.1198682409E+00, 1.0868185586E+00, 7.3876815222E-01, 8.7366216138E-01],
	[3.8375000000E+04, 8.8544755884E+00, 3.1198714167E+00, 1.0872566920E+00, 7.3898399932E-01, 8.7368803001E-01],
	[3.8380000000E+04, 8.8563775491E+00, 3.1198745922E+00, 1.0876949448E+00, 7.3919985992E-01, 8.7371389354E-01],
	[3.8385000000E+04, 8.8582796705E+00, 3.1198777672E+00, 1.0881333170E+00, 7.3941573403E-01, 8.7373975198E-01],
	[3.8390000000E+04, 8.8601819525E+00, 3.1198809418E+00, 1.0885718087E+00, 7.3963162162E-01, 8.7376560532E-01],
	[3.8395000000E+04, 8.8620843953E+00, 3.1198841160E+00, 1.0890104199E+00, 7.3984752268E-01, 8.7379145356E-01],
	[3.8400000000E+04, 8.8639869988E+00, 3.1198872898E+00, 1.0894491506E+00, 7.4006343721E-01, 8.7381729672E-01],
	[3.8405000000E+04, 8.8658897629E+00, 3.1198904632E+00, 1.0898880009E+00, 7.4027936518E-01, 8.7384313478E-01],
	[3.8410000000E+04, 8.8677926877E+00, 3.1198936362E+00, 1.0903269706E+00, 7.4049530659E-01, 8.7386896775E-01],
	[3.8415000000E+04, 8.8696957731E+00, 3.1198968087E+00, 1.0907660600E+00, 7.4071126141E-01, 8.7389479563E-01],
	[3.8420000000E+04, 8.8715990192E+00, 3.1198999809E+00, 1.0912052689E+00, 7.4092722965E-01, 8.7392061842E-01],
	[3.8425000000E+04, 8.8735024260E+00, 3.1199031526E+00, 1.0916445973E+00, 7.4114321129E-01, 8.7394643612E-01],
	[3.8430000000E+04, 8.8754059934E+00, 3.1199063239E+00, 1.0920840454E+00, 7.4135920630E-01, 8.7397224874E-01],
	[3.8435000000E+04, 8.8773097214E+00, 3.1199094949E+00, 1.0925236131E+00, 7.4157521469E-01, 8.7399805627E-01],
	[3.8440000000E+04, 8.8792136100E+00, 3.1199126654E+00, 1.0929633005E+00, 7.4179123643E-01, 8.7402385872E-01],
	[3.8445000000E+04, 8.8811176592E+00, 3.1199158355E+00, 1.0934031075E+00, 7.4200727152E-01, 8.7404965608E-01],
	[3.8450000000E+04, 8.8830218691E+00, 3.1199190052E+00, 1.0938430342E+00, 7.4222331994E-01, 8.7407544836E-01],
	[3.8455000000E+04, 8.8849262395E+00, 3.1199221745E+00, 1.0942830806E+00, 7.4243938167E-01, 8.7410123556E-01],
	[3.8460000000E+04, 8.8868307706E+00, 3.1199253434E+00, 1.0947232467E+00, 7.4265545672E-01, 8.7412701768E-01],
	[3.8465000000E+04, 8.8887354622E+00, 3.1199285118E+00, 1.0951635325E+00, 7.4287154505E-01, 8.7415279473E-01],
	[3.8470000000E+04, 8.8906403144E+00, 3.1199316799E+00, 1.0956039380E+00, 7.4308764667E-01, 8.7417856669E-01],
	[3.8475000000E+04, 8.8925453271E+00, 3.1199348475E+00, 1.0960444634E+00, 7.4330376155E-01, 8.7420433358E-01],
	[3.8480000000E+04, 8.8944505005E+00, 3.1199380148E+00, 1.0964851084E+00, 7.4351988968E-01, 8.7423009539E-01],
	[3.8485000000E+04, 8.8963558343E+00, 3.1199411816E+00, 1.0969258733E+00, 7.4373603106E-01, 8.7425585213E-01],
	[3.8490000000E+04, 8.8982613288E+00, 3.1199443480E+00, 1.0973667580E+00, 7.4395218566E-01, 8.7428160380E-01],
	[3.8495000000E+04, 8.9001669837E+00, 3.1199475141E+00, 1.0978077625E+00, 7.4416835348E-01, 8.7430735039E-01],
	[3.8500000000E+04, 8.9020727992E+00, 3.1199506797E+00, 1.0982488869E+00, 7.4438453450E-01, 8.7433309191E-01],
	[3.8505000000E+04, 8.9039787753E+00, 3.1199538449E+00, 1.0986901311E+00, 7.4460072871E-01, 8.7435882836E-01],
	[3.8510000000E+04, 8.9058849118E+00, 3.1199570097E+00, 1.0991314952E+00, 7.4481693609E-01, 8.7438455975E-01],
	[3.8515000000E+04, 8.9077912089E+00, 3.1199601741E+00, 1.0995729792E+00, 7.4503315664E-01, 8.7441028606E-01],
	[3.8520000000E+04, 8.9096976664E+00, 3.1199633381E+00, 1.1000145831E+00, 7.4524939034E-01, 8.7443600731E-01],
	[3.8525000000E+04, 8.9116042845E+00, 3.1199665016E+00, 1.1004563070E+00, 7.4546563717E-01, 8.7446172350E-01],
	[3.8530000000E+04, 8.9135110630E+00, 3.1199696648E+00, 1.1008981508E+00, 7.4568189713E-01, 8.7448743462E-01],
	[3.8535000000E+04, 8.9154180020E+00, 3.1199728276E+00, 1.1013401145E+00, 7.4589817020E-01, 8.7451314067E-01],
	[3.8540000000E+04, 8.9173251015E+00, 3.1199759899E+00, 1.1017821982E+00, 7.4611445637E-01, 8.7453884167E-01],
	[3.8545000000E+04, 8.9192323615E+00, 3.1199791518E+00, 1.1022244020E+00, 7.4633075563E-01, 8.7456453760E-01],
	[3.8550000000E+04, 8.9211397819E+00, 3.1199823134E+00, 1.1026667257E+00, 7.4654706795E-01, 8.7459022848E-01],
	[3.8555000000E+04, 8.9230473628E+00, 3.1199854745E+00, 1.1031091695E+00, 7.4676339334E-01, 8.7461591429E-01],
	[3.8560000000E+04, 8.9249551041E+00, 3.1199886352E+00, 1.1035517333E+00, 7.4697973178E-01, 8.7464159505E-01],
	[3.8565000000E+04, 8.9268630059E+00, 3.1199917956E+00, 1.1039944172E+00, 7.4719608324E-01, 8.7466727075E-01],
	[3.8570000000E+04, 8.9287710681E+00, 3.1199949555E+00, 1.1044372212E+00, 7.4741244773E-01, 8.7469294139E-01],
	[3.8575000000E+04, 8.9306792907E+00, 3.1199981150E+00, 1.1048801452E+00, 7.4762882523E-01, 8.7471860698E-01],
	[3.8580000000E+04, 8.9325876737E+00, 3.1200012741E+00, 1.1053231894E+00, 7.4784521572E-01, 8.7474426752E-01],
	[3.8585000000E+04, 8.9344962171E+00, 3.1200044328E+00, 1.1057663537E+00, 7.4806161920E-01, 8.7476992300E-01],
	[3.8590000000E+04, 8.9364049210E+00, 3.1200075911E+00, 1.1062096382E+00, 7.4827803564E-01, 8.7479557344E-01],
	[3.8595000000E+04, 8.9383137852E+00, 3.1200107489E+00, 1.1066530428E+00, 7.4849446504E-01, 8.7482121882E-01],
	[3.8600000000E+04, 8.9402228098E+00, 3.1200139064E+00, 1.1070965676E+00, 7.4871090739E-01, 8.7484685916E-01],
	[3.8605000000E+04, 8.9421319948E+00, 3.1200170635E+00, 1.1075402126E+00, 7.4892736266E-01, 8.7487249444E-01],
	[3.8610000000E+04, 8.9440413402E+00, 3.1200202201E+00, 1.1079839778E+00, 7.4914383085E-01, 8.7489812469E-01],
	[3.8615000000E+04, 8.9459508459E+00, 3.1200233764E+00, 1.1084278633E+00, 7.4936031195E-01, 8.7492374988E-01],
	[3.8620000000E+04, 8.9478651709E+00, 3.1200280089E+00, 1.1088718690E+00, 7.4957692387E-01, 8.7494937003E-01],
	[3.8625000000E+04, 8.9497797346E+00, 3.1200326652E+00, 1.1093159950E+00, 7.4979355071E-01, 8.7497498514E-01],
	[3.8630000000E+04, 8.9516944600E+00, 3.1200373210E+00, 1.1097602413E+00, 7.5001019054E-01, 8.7500059520E-01],
	[3.8635000000E+04, 8.9536093472E+00, 3.1200419761E+00, 1.1102046078E+00, 7.5022684332E-01, 8.7502620023E-01],
	[3.8640000000E+04, 8.9555243961E+00, 3.1200466306E+00, 1.1106490947E+00, 7.5044350906E-01, 8.7505180021E-01],
	[3.8645000000E+04, 8.9574396068E+00, 3.1200512845E+00, 1.1110937020E+00, 7.5066018773E-01, 8.7507739516E-01],
	[3.8650000000E+04, 8.9593549791E+00, 3.1200559379E+00, 1.1115384295E+00, 7.5087687932E-01, 8.7510298506E-01],
	[3.8655000000E+04, 8.9612705132E+00, 3.1200605906E+00, 1.1119832775E+00, 7.5109358383E-01, 8.7512856993E-01],
	[3.8660000000E+04, 8.9631862090E+00, 3.1200652428E+00, 1.1124282458E+00, 7.5131030123E-01, 8.7515414977E-01],
	[3.8665000000E+04, 8.9651020665E+00, 3.1200698943E+00, 1.1128733346E+00, 7.5152703151E-01, 8.7517972457E-01],
	[3.8670000000E+04, 8.9670180857E+00, 3.1200745453E+00, 1.1133185437E+00, 7.5174377467E-01, 8.7520529433E-01],
	[3.8675000000E+04, 8.9689342666E+00, 3.1200791956E+00, 1.1137638733E+00, 7.5196053069E-01, 8.7523085907E-01],
	[3.8680000000E+04, 8.9708506092E+00, 3.1200838454E+00, 1.1142093234E+00, 7.5217729955E-01, 8.7525641877E-01],
	[3.8685000000E+04, 8.9727671134E+00, 3.1200884946E+00, 1.1146548939E+00, 7.5239408124E-01, 8.7528197344E-01],
	[3.8690000000E+04, 8.9746837793E+00, 3.1200931432E+00, 1.1151005849E+00, 7.5261087576E-01, 8.7530752309E-01],
	[3.8695000000E+04, 8.9766006069E+00, 3.1200977911E+00, 1.1155463965E+00, 7.5282768308E-01, 8.7533306770E-01],
	[3.8700000000E+04, 8.9785175961E+00, 3.1201024385E+00, 1.1159923285E+00, 7.5304450320E-01, 8.7535860729E-01],
	[3.8705000000E+04, 8.9804347469E+00, 3.1201070853E+00, 1.1164383811E+00, 7.5326133610E-01, 8.7538414186E-01],
	[3.8710000000E+04, 8.9823520594E+00, 3.1201117315E+00, 1.1168845542E+00, 7.5347818176E-01, 8.7540967139E-01],
	[3.8715000000E+04, 8.9842695336E+00, 3.1201163772E+00, 1.1173308480E+00, 7.5369504019E-01, 8.7543519591E-01],
	[3.8720000000E+04, 8.9861871693E+00, 3.1201210222E+00, 1.1177772623E+00, 7.5391191135E-01, 8.7546071540E-01],
	[3.8725000000E+04, 8.9881049667E+00, 3.1201256666E+00, 1.1182237972E+00, 7.5412879525E-01, 8.7548622987E-01],
	[3.8730000000E+04, 8.9900229256E+00, 3.1201303104E+00, 1.1186704527E+00, 7.5434569187E-01, 8.7551173932E-01],
	[3.8735000000E+04, 8.9919410462E+00, 3.1201349537E+00, 1.1191172289E+00, 7.5456260118E-01, 8.7553724376E-01],
	[3.8740000000E+04, 8.9938593284E+00, 3.1201395963E+00, 1.1195641258E+00, 7.5477952319E-01, 8.7556274317E-01],
	[3.8745000000E+04, 8.9957777721E+00, 3.1201442384E+00, 1.1200111433E+00, 7.5499645788E-01, 8.7558823757E-01],
	[3.8750000000E+04, 8.9976963775E+00, 3.1201488798E+00, 1.1204582815E+00, 7.5521340524E-01, 8.7561372695E-01],
	[3.8755000000E+04, 8.9996151444E+00, 3.1201535207E+00, 1.1209055404E+00, 7.5543036524E-01, 8.7563921131E-01],
	[3.8760000000E+04, 9.0015340728E+00, 3.1201581610E+00, 1.1213529200E+00, 7.5564733789E-01, 8.7566469067E-01],
	[3.8765000000E+04, 9.0034531629E+00, 3.1201628007E+00, 1.1218004204E+00, 7.5586432317E-01, 8.7569016500E-01],
	[3.8770000000E+04, 9.0053724144E+00, 3.1201674398E+00, 1.1222480416E+00, 7.5608132106E-01, 8.7571563433E-01],
	[3.8775000000E+04, 9.0072918276E+00, 3.1201720783E+00, 1.1226957835E+00, 7.5629833155E-01, 8.7574109865E-01],
	[3.8780000000E+04, 9.0092114022E+00, 3.1201767162E+00, 1.1231436462E+00, 7.5651535463E-01, 8.7576655796E-01],
	[3.8785000000E+04, 9.0111311384E+00, 3.1201813535E+00, 1.1235916298E+00, 7.5673239028E-01, 8.7579201226E-01],
	[3.8790000000E+04, 9.0130510361E+00, 3.1201859903E+00, 1.1240397341E+00, 7.5694943850E-01, 8.7581746155E-01],
	[3.8795000000E+04, 9.0149710953E+00, 3.1201906264E+00, 1.1244879594E+00, 7.5716649927E-01, 8.7584290584E-01],
	[3.8800000000E+04, 9.0168913160E+00, 3.1201952620E+00, 1.1249363054E+00, 7.5738357258E-01, 8.7586834512E-01],
	[3.8805000000E+04, 9.0188116983E+00, 3.1201998969E+00, 1.1253847724E+00, 7.5760065841E-01, 8.7589377940E-01],
	[3.8810000000E+04, 9.0207322420E+00, 3.1202045313E+00, 1.1258333602E+00, 7.5781775675E-01, 8.7591920868E-01],
	[3.8815000000E+04, 9.0226529472E+00, 3.1202091651E+00, 1.1262820690E+00, 7.5803486759E-01, 8.7594463295E-01],
	[3.8820000000E+04, 9.0245738139E+00, 3.1202137983E+00, 1.1267308987E+00, 7.5825199092E-01, 8.7597005222E-01],
	[3.8825000000E+04, 9.0264948420E+00, 3.1202184309E+00, 1.1271798493E+00, 7.5846912672E-01, 8.7599546650E-01],
	[3.8830000000E+04, 9.0284160316E+00, 3.1202230629E+00, 1.1276289209E+00, 7.5868627498E-01, 8.7602087577E-01],
	[3.8835000000E+04, 9.0303373827E+00, 3.1202276943E+00, 1.1280781135E+00, 7.5890343569E-01, 8.7604628005E-01],
	[3.8840000000E+04, 9.0322588952E+00, 3.1202323251E+00, 1.1285274271E+00, 7.5912060883E-01, 8.7607167933E-01],
	[3.8845000000E+04, 9.0341805692E+00, 3.1202369554E+00, 1.1289768617E+00, 7.5933779439E-01, 8.7609707362E-01],
	[3.8850000000E+04, 9.0361024046E+00, 3.1202415850E+00, 1.1294264173E+00, 7.5955499237E-01, 8.7612246291E-01],
	[3.8855000000E+04, 9.0380244014E+00, 3.1202462141E+00, 1.1298760940E+00, 7.5977220274E-01, 8.7614784720E-01],
	[3.8860000000E+04, 9.0399465597E+00, 3.1202508426E+00, 1.1303258918E+00, 7.5998942549E-01, 8.7617322651E-01],
	[3.8865000000E+04, 9.0418688793E+00, 3.1202554705E+00, 1.1307758106E+00, 7.6020666061E-01, 8.7619860082E-01],
	[3.8870000000E+04, 9.0437913604E+00, 3.1202600978E+00, 1.1312258505E+00, 7.6042390809E-01, 8.7622397014E-01],
	[3.8875000000E+04, 9.0457140028E+00, 3.1202647245E+00, 1.1316760116E+00, 7.6064116792E-01, 8.7624933447E-01],
	[3.8880000000E+04, 9.0476368067E+00, 3.1202693506E+00, 1.1321262938E+00, 7.6085844007E-01, 8.7627469381E-01],
	[3.8885000000E+04, 9.0495597719E+00, 3.1202739761E+00, 1.1325766971E+00, 7.6107572455E-01, 8.7630004816E-01],
	[3.8890000000E+04, 9.0514828985E+00, 3.1202786011E+00, 1.1330272216E+00, 7.6129302133E-01, 8.7632539753E-01],
	[3.8895000000E+04, 9.0534061865E+00, 3.1202832254E+00, 1.1334778673E+00, 7.6151033040E-01, 8.7635074191E-01],
	[3.8900000000E+04, 9.0553296359E+00, 3.1202878492E+00, 1.1339286342E+00, 7.6172765176E-01, 8.7637608130E-01],
	[3.8905000000E+04, 9.0572532466E+00, 3.1202924724E+00, 1.1343795223E+00, 7.6194498538E-01, 8.7640141572E-01],
	[3.8910000000E+04, 9.0591770186E+00, 3.1202970950E+00, 1.1348305316E+00, 7.6216233126E-01, 8.7642674514E-01],
	[3.8915000000E+04, 9.0611009520E+00, 3.1203017170E+00, 1.1352816622E+00, 7.6237968938E-01, 8.7645206959E-01],
	[3.8920000000E+04, 9.0630250467E+00, 3.1203063384E+00, 1.1357329141E+00, 7.6259705973E-01, 8.7647738905E-01],
	[3.8925000000E+04, 9.0649493028E+00, 3.1203109593E+00, 1.1361842873E+00, 7.6281444230E-01, 8.7650270354E-01],
	[3.8930000000E+04, 9.0668737201E+00, 3.1203155795E+00, 1.1366357817E+00, 7.6303183707E-01, 8.7652801304E-01],
	[3.8935000000E+04, 9.0687982988E+00, 3.1203201992E+00, 1.1370873975E+00, 7.6324924402E-01, 8.7655331757E-01],
	[3.8940000000E+04, 9.0707230388E+00, 3.1203248182E+00, 1.1375391346E+00, 7.6346666316E-01, 8.7657861711E-01],
	[3.8945000000E+04, 9.0726479401E+00, 3.1203294367E+00, 1.1379909931E+00, 7.6368409446E-01, 8.7660391169E-01],
	[3.8950000000E+04, 9.0745730027E+00, 3.1203340546E+00, 1.1384429730E+00, 7.6390153792E-01, 8.7662920128E-01],
	[3.8955000000E+04, 9.0764982265E+00, 3.1203386720E+00, 1.1388950742E+00, 7.6411899351E-01, 8.7665448590E-01],
	[3.8960000000E+04, 9.0784236116E+00, 3.1203432887E+00, 1.1393472968E+00, 7.6433646123E-01, 8.7667976555E-01],
	[3.8965000000E+04, 9.0803491580E+00, 3.1203479048E+00, 1.1397996409E+00, 7.6455394107E-01, 8.7670504023E-01],
	[3.8970000000E+04, 9.0822748657E+00, 3.1203525204E+00, 1.1402521064E+00, 7.6477143300E-01, 8.7673030993E-01],
	[3.8975000000E+04, 9.0842007346E+00, 3.1203571354E+00, 1.1407046934E+00, 7.6498893703E-01, 8.7675557466E-01],
	[3.8980000000E+04, 9.0861267648E+00, 3.1203617498E+00, 1.1411574018E+00, 7.6520645313E-01, 8.7678083443E-01],
	[3.8985000000E+04, 9.0880529562E+00, 3.1203663636E+00, 1.1416102318E+00, 7.6542398129E-01, 8.7680608922E-01],
	[3.8990000000E+04, 9.0899793088E+00, 3.1203709768E+00, 1.1420631832E+00, 7.6564152150E-01, 8.7683133905E-01],
	[3.8995000000E+04, 9.0919058227E+00, 3.1203755894E+00, 1.1425162562E+00, 7.6585907374E-01, 8.7685658391E-01],
	[3.9000000000E+04, 9.0938324978E+00, 3.1203802015E+00, 1.1429694507E+00, 7.6607663802E-01, 8.7688182380E-01],
	[3.9005000000E+04, 9.0957593341E+00, 3.1203848130E+00, 1.1434227667E+00, 7.6629421430E-01, 8.7690705873E-01],
	[3.9010000000E+04, 9.0976863316E+00, 3.1203894238E+00, 1.1438762044E+00, 7.6651180258E-01, 8.7693228870E-01],
	[3.9015000000E+04, 9.0996134903E+00, 3.1203940341E+00, 1.1443297636E+00, 7.6672940285E-01, 8.7695751370E-01],
	[3.9020000000E+04, 9.1015408102E+00, 3.1203986438E+00, 1.1447834444E+00, 7.6694701509E-01, 8.7698273374E-01],
	[3.9025000000E+04, 9.1034682912E+00, 3.1204032530E+00, 1.1452372469E+00, 7.6716463928E-01, 8.7700794882E-01],
	[3.9030000000E+04, 9.1053959335E+00, 3.1204078615E+00, 1.1456911710E+00, 7.6738227543E-01, 8.7703315894E-01],
	[3.9035000000E+04, 9.1073237369E+00, 3.1204124695E+00, 1.1461452168E+00, 7.6759992351E-01, 8.7705836410E-01],
	[3.9040000000E+04, 9.1092517014E+00, 3.1204170769E+00, 1.1465993842E+00, 7.6781758351E-01, 8.7708356430E-01],
	[3.9045000000E+04, 9.1111798272E+00, 3.1204216837E+00, 1.1470536734E+00, 7.6803525542E-01, 8.7710875955E-01],
	[3.9050000000E+04, 9.1131081140E+00, 3.1204262899E+00, 1.1475080842E+00, 7.6825293923E-01, 8.7713394984E-01],
	[3.9055000000E+04, 9.1150365621E+00, 3.1204308955E+00, 1.1479626168E+00, 7.6847063492E-01, 8.7715913517E-01],
	[3.9060000000E+04, 9.1169651712E+00, 3.1204355006E+00, 1.1484172712E+00, 7.6868834248E-01, 8.7718431555E-01],
	[3.9065000000E+04, 9.1188939415E+00, 3.1204401050E+00, 1.1488720473E+00, 7.6890606190E-01, 8.7720949098E-01],
	[3.9070000000E+04, 9.1208228729E+00, 3.1204447089E+00, 1.1493269451E+00, 7.6912379316E-01, 8.7723466145E-01],
	[3.9075000000E+04, 9.1227519654E+00, 3.1204493122E+00, 1.1497819648E+00, 7.6934153625E-01, 8.7725982697E-01],
	[3.9080000000E+04, 9.1246812190E+00, 3.1204539149E+00, 1.1502371063E+00, 7.6955929116E-01, 8.7728498754E-01],
	[3.9085000000E+04, 9.1266106337E+00, 3.1204585171E+00, 1.1506923696E+00, 7.6977705788E-01, 8.7731014316E-01],
	[3.9090000000E+04, 9.1285402095E+00, 3.1204631186E+00, 1.1511477548E+00, 7.6999483640E-01, 8.7733529384E-01],
	[3.9095000000E+04, 9.1304699463E+00, 3.1204677196E+00, 1.1516032618E+00, 7.7021262669E-01, 8.7736043956E-01],
	[3.9100000000E+04, 9.1323998443E+00, 3.1204723200E+00, 1.1520588907E+00, 7.7043042875E-01, 8.7738558034E-01],
	[3.9105000000E+04, 9.1343299033E+00, 3.1204769198E+00, 1.1525146415E+00, 7.7064824256E-01, 8.7741071618E-01],
	[3.9110000000E+04, 9.1362601234E+00, 3.1204815190E+00, 1.1529705143E+00, 7.7086606812E-01, 8.7743584707E-01],
	[3.9115000000E+04, 9.1381905045E+00, 3.1204861177E+00, 1.1534265089E+00, 7.7108390541E-01, 8.7746097301E-01],
	[3.9120000000E+04, 9.1401210467E+00, 3.1204907157E+00, 1.1538826255E+00, 7.7130175441E-01, 8.7748609401E-01],
	[3.9125000000E+04, 9.1420517499E+00, 3.1204953132E+00, 1.1543388641E+00, 7.7151961512E-01, 8.7751121008E-01],
	[3.9130000000E+04, 9.1439826141E+00, 3.1204999101E+00, 1.1547952247E+00, 7.7173748752E-01, 8.7753632120E-01],
	[3.9135000000E+04, 9.1459136394E+00, 3.1205045065E+00, 1.1552517072E+00, 7.7195537160E-01, 8.7756142738E-01],
	[3.9140000000E+04, 9.1478448257E+00, 3.1205091022E+00, 1.1557083118E+00, 7.7217326734E-01, 8.7758652862E-01],
	[3.9145000000E+04, 9.1497761730E+00, 3.1205136974E+00, 1.1561650384E+00, 7.7239117474E-01, 8.7761162492E-01],
	[3.9150000000E+04, 9.1517076813E+00, 3.1205182919E+00, 1.1566218871E+00, 7.7260909377E-01, 8.7763671629E-01],
	[3.9155000000E+04, 9.1536393506E+00, 3.1205228859E+00, 1.1570788578E+00, 7.7282702443E-01, 8.7766180272E-01],
	[3.9160000000E+04, 9.1555711809E+00, 3.1205274794E+00, 1.1575359506E+00, 7.7304496671E-01, 8.7768688421E-01],
	[3.9165000000E+04, 9.1575031722E+00, 3.1205320722E+00, 1.1579931656E+00, 7.7326292059E-01, 8.7771196078E-01],
	[3.9170000000E+04, 9.1594353244E+00, 3.1205366645E+00, 1.1584505026E+00, 7.7348088605E-01, 8.7773703240E-01],
	[3.9175000000E+04, 9.1613676376E+00, 3.1205412562E+00, 1.1589079618E+00, 7.7369886310E-01, 8.7776209910E-01],
	[3.9180000000E+04, 9.1633001118E+00, 3.1205458473E+00, 1.1593655431E+00, 7.7391685170E-01, 8.7778716087E-01],
	[3.9185000000E+04, 9.1652327470E+00, 3.1205504378E+00, 1.1598232466E+00, 7.7413485186E-01, 8.7781221770E-01],
	[3.9190000000E+04, 9.1671655430E+00, 3.1205550277E+00, 1.1602810723E+00, 7.7435286355E-01, 8.7783726961E-01],
	[3.9195000000E+04, 9.1690985000E+00, 3.1205596171E+00, 1.1607390202E+00, 7.7457088677E-01, 8.7786231658E-01],
	[3.9200000000E+04, 9.1710316180E+00, 3.1205642059E+00, 1.1611970903E+00, 7.7478892150E-01, 8.7788735863E-01],
	[3.9205000000E+04, 9.1729648969E+00, 3.1205687941E+00, 1.1616552827E+00, 7.7500696773E-01, 8.7791239576E-01],
	[3.9210000000E+04, 9.1748983367E+00, 3.1205733817E+00, 1.1621135973E+00, 7.7522502545E-01, 8.7793742796E-01],
	[3.9215000000E+04, 9.1768319374E+00, 3.1205779688E+00, 1.1625720342E+00, 7.7544309464E-01, 8.7796245523E-01],
	[3.9220000000E+04, 9.1787656990E+00, 3.1205825553E+00, 1.1630305933E+00, 7.7566117529E-01, 8.7798747758E-01],
	[3.9225000000E+04, 9.1806996215E+00, 3.1205871412E+00, 1.1634892748E+00, 7.7587926739E-01, 8.7801249501E-01],
	[3.9230000000E+04, 9.1826337049E+00, 3.1205917265E+00, 1.1639480786E+00, 7.7609737092E-01, 8.7803750751E-01],
	[3.9235000000E+04, 9.1845679492E+00, 3.1205963112E+00, 1.1644070048E+00, 7.7631548588E-01, 8.7806251510E-01],
	[3.9240000000E+04, 9.1865054733E+00, 3.1206018571E+00, 1.1648660533E+00, 7.7653369408E-01, 8.7808751776E-01],
	[3.9245000000E+04, 9.1884448118E+00, 3.1206079118E+00, 1.1653252241E+00, 7.7675195713E-01, 8.7811251551E-01],
	[3.9250000000E+04, 9.1903843125E+00, 3.1206139656E+00, 1.1657845174E+00, 7.7697023167E-01, 8.7813750834E-01],
	[3.9255000000E+04, 9.1923239754E+00, 3.1206200187E+00, 1.1662439331E+00, 7.7718851769E-01, 8.7816249625E-01],
	[3.9260000000E+04, 9.1942638007E+00, 3.1206260711E+00, 1.1667034712E+00, 7.7740681518E-01, 8.7818747925E-01],
	[3.9265000000E+04, 9.1962037881E+00, 3.1206321226E+00, 1.1671631317E+00, 7.7762512413E-01, 8.7821245733E-01],
	[3.9270000000E+04, 9.1981439378E+00, 3.1206381735E+00, 1.1676229147E+00, 7.7784344452E-01, 8.7823743050E-01],
	[3.9275000000E+04, 9.2000842497E+00, 3.1206442235E+00, 1.1680828202E+00, 7.7806177634E-01, 8.7826239876E-01],
	[3.9280000000E+04, 9.2020247239E+00, 3.1206502728E+00, 1.1685428482E+00, 7.7828011958E-01, 8.7828736210E-01],
	[3.9285000000E+04, 9.2039653602E+00, 3.1206563214E+00, 1.1690029987E+00, 7.7849847422E-01, 8.7831232053E-01],
	[3.9290000000E+04, 9.2059061588E+00, 3.1206623692E+00, 1.1694632717E+00, 7.7871684026E-01, 8.7833727405E-01],
	[3.9295000000E+04, 9.2078471196E+00, 3.1206684162E+00, 1.1699236673E+00, 7.7893521767E-01, 8.7836222267E-01],
	[3.9300000000E+04, 9.2097882425E+00, 3.1206744625E+00, 1.1703841854E+00, 7.7915360646E-01, 8.7838716637E-01],
	[3.9305000000E+04, 9.2117295277E+00, 3.1206805080E+00, 1.1708448261E+00, 7.7937200659E-01, 8.7841210517E-01],
	[3.9310000000E+04, 9.2136709750E+00, 3.1206865528E+00, 1.1713055894E+00, 7.7959041807E-01, 8.7843703906E-01],
	[3.9315000000E+04, 9.2156125845E+00, 3.1206925968E+00, 1.1717664753E+00, 7.7980884088E-01, 8.7846196805E-01],
	[3.9320000000E+04, 9.2175543562E+00, 3.1206986400E+00, 1.1722274838E+00, 7.8002727500E-01, 8.7848689213E-01],
	[3.9325000000E+04, 9.2194962900E+00, 3.1207046825E+00, 1.1726886150E+00, 7.8024572043E-01, 8.7851181131E-01],
	[3.9330000000E+04, 9.2214383860E+00, 3.1207107243E+00, 1.1731498688E+00, 7.8046417715E-01, 8.7853672559E-01],
	[3.9335000000E+04, 9.2233806441E+00, 3.1207167652E+00, 1.1736112454E+00, 7.8068264515E-01, 8.7856163496E-01],
	[3.9340000000E+04, 9.2253230644E+00, 3.1207228055E+00, 1.1740727446E+00, 7.8090112441E-01, 8.7858653944E-01],
	[3.9345000000E+04, 9.2272656468E+00, 3.1207288449E+00, 1.1745343665E+00, 7.8111961492E-01, 8.7861143901E-01],
	[3.9350000000E+04, 9.2292083913E+00, 3.1207348836E+00, 1.1749961112E+00, 7.8133811668E-01, 8.7863633369E-01],
	[3.9355000000E+04, 9.2311512980E+00, 3.1207409216E+00, 1.1754579786E+00, 7.8155662966E-01, 8.7866122347E-01],
	[3.9360000000E+04, 9.2330943667E+00, 3.1207469588E+00, 1.1759199688E+00, 7.8177515385E-01, 8.7868610835E-01],
	[3.9365000000E+04, 9.2350375975E+00, 3.1207529952E+00, 1.1763820818E+00, 7.8199368925E-01, 8.7871098834E-01],
	[3.9370000000E+04, 9.2369809905E+00, 3.1207590309E+00, 1.1768443176E+00, 7.8221223583E-01, 8.7873586343E-01],
	[3.9375000000E+04, 9.2389245455E+00, 3.1207650658E+00, 1.1773066761E+00, 7.8243079360E-01, 8.7876073363E-01],
	[3.9380000000E+04, 9.2408682626E+00, 3.1207711000E+00, 1.1777691576E+00, 7.8264936252E-01, 8.7878559893E-01],
	[3.9385000000E+04, 9.2428121418E+00, 3.1207771334E+00, 1.1782317618E+00, 7.8286794260E-01, 8.7881045935E-01],
	[3.9390000000E+04, 9.2447561830E+00, 3.1207831661E+00, 1.1786944890E+00, 7.8308653381E-01, 8.7883531487E-01],
	[3.9395000000E+04, 9.2467003864E+00, 3.1207891980E+00, 1.1791573390E+00, 7.8330513615E-01, 8.7886016551E-01],
	[3.9400000000E+04, 9.2486447517E+00, 3.1207952292E+00, 1.1796203119E+00, 7.8352374961E-01, 8.7888501125E-01],
	[3.9405000000E+04, 9.2505892791E+00, 3.1208012596E+00, 1.1800834078E+00, 7.8374237416E-01, 8.7890985211E-01],
	[3.9410000000E+04, 9.2525339686E+00, 3.1208072893E+00, 1.1805466265E+00, 7.8396100980E-01, 8.7893468808E-01],
	[3.9415000000E+04, 9.2544788201E+00, 3.1208133182E+00, 1.1810099683E+00, 7.8417965652E-01, 8.7895951916E-01],
	[3.9420000000E+04, 9.2564238336E+00, 3.1208193463E+00, 1.1814734330E+00, 7.8439831429E-01, 8.7898434536E-01],
	[3.9425000000E+04, 9.2583690091E+00, 3.1208253737E+00, 1.1819370206E+00, 7.8461698312E-01, 8.7900916667E-01],
	[3.9430000000E+04, 9.2603143466E+00, 3.1208314004E+00, 1.1824007313E+00, 7.8483566298E-01, 8.7903398310E-01],
	[3.9435000000E+04, 9.2622598461E+00, 3.1208374262E+00, 1.1828645650E+00, 7.8505435387E-01, 8.7905879465E-01],
	[3.9440000000E+04, 9.2642055077E+00, 3.1208434514E+00, 1.1833285218E+00, 7.8527305576E-01, 8.7908360132E-01],
	[3.9445000000E+04, 9.2661513312E+00, 3.1208494758E+00, 1.1837926016E+00, 7.8549176866E-01, 8.7910840310E-01],
	[3.9450000000E+04, 9.2680973167E+00, 3.1208554994E+00, 1.1842568045E+00, 7.8571049254E-01, 8.7913320001E-01],
	[3.9455000000E+04, 9.2700434642E+00, 3.1208615223E+00, 1.1847211304E+00, 7.8592922740E-01, 8.7915799204E-01],
	[3.9460000000E+04, 9.2719897736E+00, 3.1208675444E+00, 1.1851855795E+00, 7.8614797321E-01, 8.7918277919E-01],
	[3.9465000000E+04, 9.2739362450E+00, 3.1208735658E+00, 1.1856501517E+00, 7.8636672997E-01, 8.7920756147E-01],
	[3.9470000000E+04, 9.2758828784E+00, 3.1208795864E+00, 1.1861148470E+00, 7.8658549767E-01, 8.7923233887E-01],
	[3.9475000000E+04, 9.2778296737E+00, 3.1208856063E+00, 1.1865796655E+00, 7.8680427629E-01, 8.7925711139E-01],
	[3.9480000000E+04, 9.2797766309E+00, 3.1208916254E+00, 1.1870446072E+00, 7.8702306582E-01, 8.7928187905E-01],
	[3.9485000000E+04, 9.2817237501E+00, 3.1208976438E+00, 1.1875096720E+00, 7.8724186624E-01, 8.7930664183E-01],
	[3.9490000000E+04, 9.2836710312E+00, 3.1209036614E+00, 1.1879748601E+00, 7.8746067755E-01, 8.7933139973E-01],
	[3.9495000000E+04, 9.2856184742E+00, 3.1209096783E+00, 1.1884401714E+00, 7.8767949974E-01, 8.7935615277E-01],
	[3.9500000000E+04, 9.2875660792E+00, 3.1209156944E+00, 1.1889056059E+00, 7.8789833278E-01, 8.7938090094E-01],
	[3.9505000000E+04, 9.2895138460E+00, 3.1209217098E+00, 1.1893711637E+00, 7.8811717666E-01, 8.7940564424E-01],
	[3.9510000000E+04, 9.2914617747E+00, 3.1209277244E+00, 1.1898368448E+00, 7.8833603138E-01, 8.7943038267E-01],
	[3.9515000000E+04, 9.2934098654E+00, 3.1209337383E+00, 1.1903026491E+00, 7.8855489692E-01, 8.7945511623E-01],
	[3.9520000000E+04, 9.2953581179E+00, 3.1209397514E+00, 1.1907685768E+00, 7.8877377327E-01, 8.7947984493E-01],
	[3.9525000000E+04, 9.2973065323E+00, 3.1209457638E+00, 1.1912346278E+00, 7.8899266042E-01, 8.7950456876E-01],
	[3.9530000000E+04, 9.2992551085E+00, 3.1209517754E+00, 1.1917008021E+00, 7.8921155834E-01, 8.7952928773E-01],
	[3.9535000000E+04, 9.3012038466E+00, 3.1209577863E+00, 1.1921670998E+00, 7.8943046704E-01, 8.7955400183E-01],
	[3.9540000000E+04, 9.3031527466E+00, 3.1209637964E+00, 1.1926335209E+00, 7.8964938649E-01, 8.7957871108E-01],
	[3.9545000000E+04, 9.3051018084E+00, 3.1209698058E+00, 1.1931000654E+00, 7.8986831669E-01, 8.7960341546E-01],
	[3.9550000000E+04, 9.3070510321E+00, 3.1209758145E+00, 1.1935667332E+00, 7.9008725762E-01, 8.7962811498E-01],
	[3.9555000000E+04, 9.3090004176E+00, 3.1209818223E+00, 1.1940335245E+00, 7.9030620927E-01, 8.7965280964E-01],
	[3.9560000000E+04, 9.3109499649E+00, 3.1209878295E+00, 1.1945004393E+00, 7.9052517163E-01, 8.7967749945E-01],
	[3.9565000000E+04, 9.3128996741E+00, 3.1209938359E+00, 1.1949674775E+00, 7.9074414468E-01, 8.7970218439E-01],
	[3.9570000000E+04, 9.3148495450E+00, 3.1209998415E+00, 1.1954346392E+00, 7.9096312841E-01, 8.7972686448E-01],
	[3.9575000000E+04, 9.3167995778E+00, 3.1210058464E+00, 1.1959019244E+00, 7.9118212281E-01, 8.7975153972E-01],
	[3.9580000000E+04, 9.3187497724E+00, 3.1210118506E+00, 1.1963693331E+00, 7.9140112787E-01, 8.7977621010E-01],
	[3.9585000000E+04, 9.3207001287E+00, 3.1210178540E+00, 1.1968368654E+00, 7.9162014357E-01, 8.7980087563E-01],
	[3.9590000000E+04, 9.3226506469E+00, 3.1210238566E+00, 1.1973045211E+00, 7.9183916990E-01, 8.7982553630E-01],
	[3.9595000000E+04, 9.3246013268E+00, 3.1210298585E+00, 1.1977723005E+00, 7.9205820685E-01, 8.7985019213E-01],
	[3.9600000000E+04, 9.3265521685E+00, 3.1210358597E+00, 1.1982402034E+00, 7.9227725440E-01, 8.7987484310E-01],
	[3.9605000000E+04, 9.3285031719E+00, 3.1210418601E+00, 1.1987082300E+00, 7.9249631255E-01, 8.7989948922E-01],
	[3.9610000000E+04, 9.3304543372E+00, 3.1210478598E+00, 1.1991763801E+00, 7.9271538127E-01, 8.7992413050E-01],
	[3.9615000000E+04, 9.3324056641E+00, 3.1210538587E+00, 1.1996446539E+00, 7.9293446057E-01, 8.7994876692E-01],
	[3.9620000000E+04, 9.3343571528E+00, 3.1210598569E+00, 1.2001130513E+00, 7.9315355041E-01, 8.7997339850E-01],
	[3.9625000000E+04, 9.3363088033E+00, 3.1210658543E+00, 1.2005815724E+00, 7.9337265080E-01, 8.7999802523E-01],
	[3.9630000000E+04, 9.3382606154E+00, 3.1210718510E+00, 1.2010502172E+00, 7.9359176172E-01, 8.8002264712E-01],
	[3.9635000000E+04, 9.3402125893E+00, 3.1210778470E+00, 1.2015189857E+00, 7.9381088316E-01, 8.8004726417E-01],
	[3.9640000000E+04, 9.3421647250E+00, 3.1210838422E+00, 1.2019878779E+00, 7.9403001510E-01, 8.8007187637E-01],
	[3.9645000000E+04, 9.3441170223E+00, 3.1210898366E+00, 1.2024568939E+00, 7.9424915753E-01, 8.8009648373E-01],
	[3.9650000000E+04, 9.3460694813E+00, 3.1210958303E+00, 1.2029260335E+00, 7.9446831044E-01, 8.8012108625E-01],
	[3.9655000000E+04, 9.3480221020E+00, 3.1211018233E+00, 1.2033952970E+00, 7.9468747382E-01, 8.8014568393E-01],
	[3.9660000000E+04, 9.3499748844E+00, 3.1211078155E+00, 1.2038646842E+00, 7.9490664765E-01, 8.8017027676E-01],
	[3.9665000000E+04, 9.3519278285E+00, 3.1211138070E+00, 1.2043341953E+00, 7.9512583192E-01, 8.8019486477E-01],
	[3.9670000000E+04, 9.3538809342E+00, 3.1211197977E+00, 1.2048038302E+00, 7.9534502662E-01, 8.8021944793E-01],
	[3.9675000000E+04, 9.3558342017E+00, 3.1211257877E+00, 1.2052735889E+00, 7.9556423173E-01, 8.8024402626E-01],
	[3.9680000000E+04, 9.3577876307E+00, 3.1211317770E+00, 1.2057434714E+00, 7.9578344725E-01, 8.8026859975E-01],
	[3.9685000000E+04, 9.3597412215E+00, 3.1211377655E+00, 1.2062134779E+00, 7.9600267316E-01, 8.8029316841E-01],
	[3.9690000000E+04, 9.3616949738E+00, 3.1211437532E+00, 1.2066836082E+00, 7.9622190944E-01, 8.8031773223E-01],
	[3.9695000000E+04, 9.3636488879E+00, 3.1211497402E+00, 1.2071538624E+00, 7.9644115609E-01, 8.8034229122E-01],
	[3.9700000000E+04, 9.3656029635E+00, 3.1211557265E+00, 1.2076242406E+00, 7.9666041309E-01, 8.8036684538E-01],
	[3.9705000000E+04, 9.3675572008E+00, 3.1211617120E+00, 1.2080947426E+00, 7.9687968044E-01, 8.8039139471E-01],
	[3.9710000000E+04, 9.3695115997E+00, 3.1211676968E+00, 1.2085653687E+00, 7.9709895810E-01, 8.8041593921E-01],
	[3.9715000000E+04, 9.3714661602E+00, 3.1211736809E+00, 1.2090361187E+00, 7.9731824609E-01, 8.8044047888E-01],
	[3.9720000000E+04, 9.3734208823E+00, 3.1211796642E+00, 1.2095069927E+00, 7.9753754437E-01, 8.8046501372E-01],
	[3.9725000000E+04, 9.3753757660E+00, 3.1211856468E+00, 1.2099779907E+00, 7.9775685295E-01, 8.8048954374E-01],
	[3.9730000000E+04, 9.3773308113E+00, 3.1211916286E+00, 1.2104491128E+00, 7.9797617180E-01, 8.8051406893E-01],
	[3.9735000000E+04, 9.3792860181E+00, 3.1211976097E+00, 1.2109203588E+00, 7.9819550091E-01, 8.8053858930E-01],
	[3.9740000000E+04, 9.3812413866E+00, 3.1212035900E+00, 1.2113917290E+00, 7.9841484028E-01, 8.8056310484E-01],
	[3.9745000000E+04, 9.3831969166E+00, 3.1212095696E+00, 1.2118632232E+00, 7.9863418988E-01, 8.8058761556E-01],
	[3.9750000000E+04, 9.3851526082E+00, 3.1212155485E+00, 1.2123348415E+00, 7.9885354971E-01, 8.8061212146E-01],
	[3.9755000000E+04, 9.3871084613E+00, 3.1212215266E+00, 1.2128065839E+00, 7.9907291975E-01, 8.8063662253E-01],
	[3.9760000000E+04, 9.3890644760E+00, 3.1212275040E+00, 1.2132784504E+00, 7.9929230000E-01, 8.8066111879E-01],
	[3.9765000000E+04, 9.3910206522E+00, 3.1212334806E+00, 1.2137504411E+00, 7.9951169043E-01, 8.8068561022E-01],
	[3.9770000000E+04, 9.3929769899E+00, 3.1212394565E+00, 1.2142225560E+00, 7.9973109104E-01, 8.8071009684E-01],
	[3.9775000000E+04, 9.3949334892E+00, 3.1212454317E+00, 1.2146947950E+00, 7.9995050181E-01, 8.8073457864E-01],
	[3.9780000000E+04, 9.3968901500E+00, 3.1212514061E+00, 1.2151671582E+00, 8.0016992273E-01, 8.8075905563E-01],
	[3.9785000000E+04, 9.3988469723E+00, 3.1212573798E+00, 1.2156396456E+00, 8.0038935378E-01, 8.8078352780E-01],
	[3.9790000000E+04, 9.4008039561E+00, 3.1212633527E+00, 1.2161122573E+00, 8.0060879497E-01, 8.8080799515E-01],
	[3.9795000000E+04, 9.4027611014E+00, 3.1212693249E+00, 1.2165849932E+00, 8.0082824626E-01, 8.8083245769E-01],
	[3.9800000000E+04, 9.4047184082E+00, 3.1212752964E+00, 1.2170578534E+00, 8.0104770766E-01, 8.8085691542E-01],
	[3.9805000000E+04, 9.4066758765E+00, 3.1212812671E+00, 1.2175308378E+00, 8.0126717914E-01, 8.8088136834E-01],
	[3.9810000000E+04, 9.4086335063E+00, 3.1212872371E+00, 1.2180039466E+00, 8.0148666070E-01, 8.8090581645E-01],
	[3.9815000000E+04, 9.4105912975E+00, 3.1212932063E+00, 1.2184771796E+00, 8.0170615231E-01, 8.8093025974E-01],
	[3.9820000000E+04, 9.4125492502E+00, 3.1212991748E+00, 1.2189505370E+00, 8.0192565398E-01, 8.8095469823E-01],
	[3.9825000000E+04, 9.4145073644E+00, 3.1213051426E+00, 1.2194240187E+00, 8.0214516569E-01, 8.8097913191E-01],
	[3.9830000000E+04, 9.4164656400E+00, 3.1213111096E+00, 1.2198976248E+00, 8.0236468741E-01, 8.8100356079E-01],
	[3.9835000000E+04, 9.4184240770E+00, 3.1213170759E+00, 1.2203713553E+00, 8.0258421915E-01, 8.8102798485E-01],
	[3.9840000000E+04, 9.4203826755E+00, 3.1213230415E+00, 1.2208452102E+00, 8.0280376089E-01, 8.8105240412E-01],
	[3.9845000000E+04, 9.4223414354E+00, 3.1213290063E+00, 1.2213191895E+00, 8.0302331262E-01, 8.8107681858E-01],
	[3.9850000000E+04, 9.4243003568E+00, 3.1213349704E+00, 1.2217932932E+00, 8.0324287432E-01, 8.8110122823E-01],
	[3.9855000000E+04, 9.4262594395E+00, 3.1213409337E+00, 1.2222675214E+00, 8.0346244598E-01, 8.8112563309E-01],
	[3.9860000000E+04, 9.4282186837E+00, 3.1213468963E+00, 1.2227418740E+00, 8.0368202758E-01, 8.8115003314E-01],
	[3.9865000000E+04, 9.4301780893E+00, 3.1213528582E+00, 1.2232163512E+00, 8.0390161913E-01, 8.8117442839E-01],
	[3.9870000000E+04, 9.4321392064E+00, 3.1213592838E+00, 1.2236909528E+00, 8.0412126269E-01, 8.8119881885E-01],
	[3.9875000000E+04, 9.4341037481E+00, 3.1213666860E+00, 1.2241656789E+00, 8.0434100481E-01, 8.8122320450E-01],
	[3.9880000000E+04, 9.4360684525E+00, 3.1213740872E+00, 1.2246405296E+00, 8.0456075694E-01, 8.8124758536E-01],
	[3.9885000000E+04, 9.4380333197E+00, 3.1213814875E+00, 1.2251155048E+00, 8.0478051907E-01, 8.8127196142E-01],
	[3.9890000000E+04, 9.4399983497E+00, 3.1213888869E+00, 1.2255906046E+00, 8.0500029118E-01, 8.8129633269E-01],
	[3.9895000000E+04, 9.4419635424E+00, 3.1213962854E+00, 1.2260658290E+00, 8.0522007326E-01, 8.8132069916E-01],
	[3.9900000000E+04, 9.4439288979E+00, 3.1214036830E+00, 1.2265411780E+00, 8.0543986530E-01, 8.8134506084E-01],
	[3.9905000000E+04, 9.4458944161E+00, 3.1214110797E+00, 1.2270166516E+00, 8.0565966729E-01, 8.8136941773E-01],
	[3.9910000000E+04, 9.4478600971E+00, 3.1214184755E+00, 1.2274922499E+00, 8.0587947922E-01, 8.8139376982E-01],
	[3.9915000000E+04, 9.4498259408E+00, 3.1214258704E+00, 1.2279679728E+00, 8.0609930106E-01, 8.8141811713E-01],
	[3.9920000000E+04, 9.4517919472E+00, 3.1214332643E+00, 1.2284438203E+00, 8.0631913282E-01, 8.8144245964E-01],
	[3.9925000000E+04, 9.4537581164E+00, 3.1214406574E+00, 1.2289197926E+00, 8.0653897447E-01, 8.8146679737E-01],
	[3.9930000000E+04, 9.4557244482E+00, 3.1214480495E+00, 1.2293958896E+00, 8.0675882600E-01, 8.8149113030E-01],
	[3.9935000000E+04, 9.4576909428E+00, 3.1214554407E+00, 1.2298721113E+00, 8.0697868741E-01, 8.8151545845E-01],
	[3.9940000000E+04, 9.4596576000E+00, 3.1214628311E+00, 1.2303484577E+00, 8.0719855867E-01, 8.8153978182E-01],
	[3.9945000000E+04, 9.4616244200E+00, 3.1214702205E+00, 1.2308249289E+00, 8.0741843979E-01, 8.8156410040E-01],
	[3.9950000000E+04, 9.4635914026E+00, 3.1214776090E+00, 1.2313015248E+00, 8.0763833073E-01, 8.8158841419E-01],
	[3.9955000000E+04, 9.4655585479E+00, 3.1214849966E+00, 1.2317782456E+00, 8.0785823150E-01, 8.8161272321E-01],
	[3.9960000000E+04, 9.4675258559E+00, 3.1214923833E+00, 1.2322550911E+00, 8.0807814207E-01, 8.8163702744E-01],
	[3.9965000000E+04, 9.4694933265E+00, 3.1214997691E+00, 1.2327320615E+00, 8.0829806244E-01, 8.8166132689E-01],
	[3.9970000000E+04, 9.4714609598E+00, 3.1215071540E+00, 1.2332091567E+00, 8.0851799260E-01, 8.8168562156E-01],
	[3.9975000000E+04, 9.4734287557E+00, 3.1215145379E+00, 1.2336863768E+00, 8.0873793252E-01, 8.8170991145E-01],
	[3.9980000000E+04, 9.4753967143E+00, 3.1215219210E+00, 1.2341637218E+00, 8.0895788221E-01, 8.8173419656E-01],
	[3.9985000000E+04, 9.4773648355E+00, 3.1215293032E+00, 1.2346411916E+00, 8.0917784164E-01, 8.8175847690E-01],
	[3.9990000000E+04, 9.4793331193E+00, 3.1215366844E+00, 1.2351187864E+00, 8.0939781080E-01, 8.8178275245E-01],
	[3.9995000000E+04, 9.4813015658E+00, 3.1215440648E+00, 1.2355965060E+00, 8.0961778968E-01, 8.8180702324E-01],
	[4.0000000000E+04, 9.4832701748E+00, 3.1215514442E+00, 1.2360743507E+00, 8.0983777828E-01, 8.8183128925E-01],
	[4.0005000000E+04, 9.4852389465E+00, 3.1215588228E+00, 1.2365533747E+00, 8.1005822907E-01, 8.8185555048E-01],
	[4.0010000000E+04, 9.4872078808E+00, 3.1215662004E+00, 1.2370325243E+00, 8.1027868962E-01, 8.8187980694E-01],
	[4.0015000000E+04, 9.4891769776E+00, 3.1215735772E+00, 1.2375117997E+00, 8.1049915993E-01, 8.8190405863E-01],
	[4.0020000000E+04, 9.4911462371E+00, 3.1215809530E+00, 1.2379912007E+00, 8.1071963998E-01, 8.8192830555E-01],
	[4.0025000000E+04, 9.4931156591E+00, 3.1215883279E+00, 1.2384707274E+00, 8.1094012976E-01, 8.8195254770E-01],
	[4.0030000000E+04, 9.4950852437E+00, 3.1215957019E+00, 1.2389503799E+00, 8.1116062925E-01, 8.8197678508E-01],
	[4.0035000000E+04, 9.4970549909E+00, 3.1216030751E+00, 1.2394301581E+00, 8.1138113845E-01, 8.8200101770E-01],
	[4.0040000000E+04, 9.4990249006E+00, 3.1216104473E+00, 1.2399100620E+00, 8.1160165734E-01, 8.8202524554E-01],
	[4.0045000000E+04, 9.5009949728E+00, 3.1216178186E+00, 1.2403900918E+00, 8.1182218590E-01, 8.8204946863E-01],
	[4.0050000000E+04, 9.5029652077E+00, 3.1216251890E+00, 1.2408702473E+00, 8.1204272413E-01, 8.8207368694E-01],
	[4.0055000000E+04, 9.5049356050E+00, 3.1216325585E+00, 1.2413505286E+00, 8.1226327202E-01, 8.8209790049E-01],
	[4.0060000000E+04, 9.5069061649E+00, 3.1216399271E+00, 1.2418309358E+00, 8.1248382954E-01, 8.8212210928E-01],
	[4.0065000000E+04, 9.5088768873E+00, 3.1216472948E+00, 1.2423114688E+00, 8.1270439669E-01, 8.8214631331E-01],
	[4.0070000000E+04, 9.5108477722E+00, 3.1216546616E+00, 1.2427921277E+00, 8.1292497346E-01, 8.8217051257E-01],
	[4.0075000000E+04, 9.5128188197E+00, 3.1216620275E+00, 1.2432729125E+00, 8.1314555982E-01, 8.8219470708E-01],
	[4.0080000000E+04, 9.5147900296E+00, 3.1216693925E+00, 1.2437538231E+00, 8.1336615578E-01, 8.8221889682E-01],
	[4.0085000000E+04, 9.5167614020E+00, 3.1216767566E+00, 1.2442348597E+00, 8.1358676132E-01, 8.8224308181E-01],
	[4.0090000000E+04, 9.5187329370E+00, 3.1216841198E+00, 1.2447160222E+00, 8.1380737642E-01, 8.8226726204E-01],
	[4.0095000000E+04, 9.5207046344E+00, 3.1216914821E+00, 1.2451973106E+00, 8.1402800107E-01, 8.8229143751E-01],
	[4.0100000000E+04, 9.5226764942E+00, 3.1216988435E+00, 1.2456787251E+00, 8.1424863526E-01, 8.8231560823E-01],
	[4.0105000000E+04, 9.5246485166E+00, 3.1217062040E+00, 1.2461602655E+00, 8.1446927898E-01, 8.8233977419E-01],
	[4.0110000000E+04, 9.5266207014E+00, 3.1217135636E+00, 1.2466419319E+00, 8.1468993221E-01, 8.8236393540E-01],
	[4.0115000000E+04, 9.5285930487E+00, 3.1217209223E+00, 1.2471237243E+00, 8.1491059494E-01, 8.8238809186E-01],
	[4.0120000000E+04, 9.5305655584E+00, 3.1217282801E+00, 1.2476056427E+00, 8.1513126716E-01, 8.8241224356E-01],
	[4.0125000000E+04, 9.5325382305E+00, 3.1217356370E+00, 1.2480876873E+00, 8.1535194886E-01, 8.8243639052E-01],
	[4.0130000000E+04, 9.5345110651E+00, 3.1217429929E+00, 1.2485698578E+00, 8.1557264002E-01, 8.8246053272E-01],
	[4.0135000000E+04, 9.5364840621E+00, 3.1217503480E+00, 1.2490521545E+00, 8.1579334064E-01, 8.8248467018E-01],
	[4.0140000000E+04, 9.5384572216E+00, 3.1217577022E+00, 1.2495345773E+00, 8.1601405069E-01, 8.8250880288E-01],
	[4.0145000000E+04, 9.5404305434E+00, 3.1217650555E+00, 1.2500171262E+00, 8.1623477017E-01, 8.8253293084E-01],
	[4.0150000000E+04, 9.5424040277E+00, 3.1217724079E+00, 1.2504998012E+00, 8.1645549906E-01, 8.8255705406E-01],
	[4.0155000000E+04, 9.5443776743E+00, 3.1217797594E+00, 1.2509826024E+00, 8.1667623735E-01, 8.8258117253E-01],
	[4.0160000000E+04, 9.5463514834E+00, 3.1217871100E+00, 1.2514655297E+00, 8.1689698504E-01, 8.8260528625E-01],
	[4.0165000000E+04, 9.5483254548E+00, 3.1217944597E+00, 1.2519485833E+00, 8.1711774209E-01, 8.8262939523E-01],
	[4.0170000000E+04, 9.5502995886E+00, 3.1218018085E+00, 1.2524317630E+00, 8.1733850851E-01, 8.8265349947E-01],
	[4.0175000000E+04, 9.5522738848E+00, 3.1218091565E+00, 1.2529150690E+00, 8.1755928428E-01, 8.8267759897E-01],
	[4.0180000000E+04, 9.5542483434E+00, 3.1218165035E+00, 1.2533985013E+00, 8.1778006939E-01, 8.8270169373E-01],
	[4.0185000000E+04, 9.5562229643E+00, 3.1218238496E+00, 1.2538820597E+00, 8.1800086383E-01, 8.8272578374E-01],
	[4.0190000000E+04, 9.5581977475E+00, 3.1218311948E+00, 1.2543657445E+00, 8.1822166758E-01, 8.8274986902E-01],
	[4.0195000000E+04, 9.5601726931E+00, 3.1218385391E+00, 1.2548495556E+00, 8.1844248062E-01, 8.8277394956E-01],
	[4.0200000000E+04, 9.5621478011E+00, 3.1218458825E+00, 1.2553334929E+00, 8.1866330296E-01, 8.8279802537E-01],
	[4.0205000000E+04, 9.5641230714E+00, 3.1218532251E+00, 1.2558175566E+00, 8.1888413457E-01, 8.8282209644E-01],
	[4.0210000000E+04, 9.5660985040E+00, 3.1218605667E+00, 1.2563017466E+00, 8.1910497544E-01, 8.8284616277E-01],
	[4.0215000000E+04, 9.5680740989E+00, 3.1218679075E+00, 1.2567860631E+00, 8.1932582557E-01, 8.8287022437E-01],
	[4.0220000000E+04, 9.5700498561E+00, 3.1218752473E+00, 1.2572705058E+00, 8.1954668493E-01, 8.8289428124E-01],
	[4.0225000000E+04, 9.5720257757E+00, 3.1218825862E+00, 1.2577550750E+00, 8.1976755352E-01, 8.8291833338E-01],
	[4.0230000000E+04, 9.5740018575E+00, 3.1218899243E+00, 1.2582397706E+00, 8.1998843132E-01, 8.8294238078E-01],
	[4.0235000000E+04, 9.5759781016E+00, 3.1218972615E+00, 1.2587245926E+00, 8.2020931831E-01, 8.8296642346E-01],
	[4.0240000000E+04, 9.5779545080E+00, 3.1219045977E+00, 1.2592095411E+00, 8.2043021450E-01, 8.8299046140E-01],
	[4.0245000000E+04, 9.5799310767E+00, 3.1219119331E+00, 1.2596946160E+00, 8.2065111986E-01, 8.8301449462E-01],
	[4.0250000000E+04, 9.5819078077E+00, 3.1219192676E+00, 1.2601798175E+00, 8.2087203439E-01, 8.8303852311E-01],
	[4.0255000000E+04, 9.5838847009E+00, 3.1219266011E+00, 1.2606651454E+00, 8.2109295806E-01, 8.8306254688E-01],
	[4.0260000000E+04, 9.5858617563E+00, 3.1219339338E+00, 1.2611505998E+00, 8.2131389087E-01, 8.8308656592E-01],
	[4.0265000000E+04, 9.5878389741E+00, 3.1219412656E+00, 1.2616361808E+00, 8.2153483281E-01, 8.8311058023E-01],
	[4.0270000000E+04, 9.5898163540E+00, 3.1219485965E+00, 1.2621218883E+00, 8.2175578385E-01, 8.8313458982E-01],
	[4.0275000000E+04, 9.5917938962E+00, 3.1219559265E+00, 1.2626077224E+00, 8.2197674400E-01, 8.8315859469E-01],
	[4.0280000000E+04, 9.5937716007E+00, 3.1219632557E+00, 1.2630936831E+00, 8.2219771323E-01, 8.8318259484E-01],
	[4.0285000000E+04, 9.5957494673E+00, 3.1219705839E+00, 1.2635797704E+00, 8.2241869154E-01, 8.8320659026E-01],
	[4.0290000000E+04, 9.5977274962E+00, 3.1219779112E+00, 1.2640659843E+00, 8.2263967891E-01, 8.8323058097E-01],
	[4.0295000000E+04, 9.5997056872E+00, 3.1219852376E+00, 1.2645523249E+00, 8.2286067533E-01, 8.8325456696E-01],
	[4.0300000000E+04, 9.6016840405E+00, 3.1219925632E+00, 1.2650387921E+00, 8.2308168079E-01, 8.8327854823E-01],
	[4.0305000000E+04, 9.6036625560E+00, 3.1219998878E+00, 1.2655253859E+00, 8.2330269527E-01, 8.8330252478E-01],
	[4.0310000000E+04, 9.6056412336E+00, 3.1220072116E+00, 1.2660121065E+00, 8.2352371876E-01, 8.8332649662E-01],
	[4.0315000000E+04, 9.6076200735E+00, 3.1220145345E+00, 1.2664989538E+00, 8.2374475126E-01, 8.8335046374E-01],
	[4.0320000000E+04, 9.6095990755E+00, 3.1220218565E+00, 1.2669859278E+00, 8.2396579273E-01, 8.8337442615E-01],
	[4.0325000000E+04, 9.6115782397E+00, 3.1220291776E+00, 1.2674730285E+00, 8.2418684319E-01, 8.8339838385E-01],
	[4.0330000000E+04, 9.6135575660E+00, 3.1220364978E+00, 1.2679602560E+00, 8.2440790260E-01, 8.8342233683E-01],
	[4.0335000000E+04, 9.6155370545E+00, 3.1220438171E+00, 1.2684476103E+00, 8.2462897097E-01, 8.8344628510E-01],
	[4.0340000000E+04, 9.6175167051E+00, 3.1220511355E+00, 1.2689350914E+00, 8.2485004827E-01, 8.8347022867E-01],
	[4.0345000000E+04, 9.6194965179E+00, 3.1220584530E+00, 1.2694226992E+00, 8.2507113449E-01, 8.8349416752E-01],
	[4.0350000000E+04, 9.6214764928E+00, 3.1220657697E+00, 1.2699104340E+00, 8.2529222963E-01, 8.8351810166E-01],
	[4.0355000000E+04, 9.6234566299E+00, 3.1220730854E+00, 1.2703982955E+00, 8.2551333367E-01, 8.8354203110E-01],
	[4.0360000000E+04, 9.6254369290E+00, 3.1220804003E+00, 1.2708862839E+00, 8.2573444659E-01, 8.8356595583E-01],
	[4.0365000000E+04, 9.6274173903E+00, 3.1220877142E+00, 1.2713743992E+00, 8.2595556838E-01, 8.8358987586E-01],
	[4.0370000000E+04, 9.6293980137E+00, 3.1220950273E+00, 1.2718626414E+00, 8.2617669904E-01, 8.8361379118E-01],
	[4.0375000000E+04, 9.6313787992E+00, 3.1221023395E+00, 1.2723510105E+00, 8.2639783855E-01, 8.8363770179E-01],
	[4.0380000000E+04, 9.6333597467E+00, 3.1221096508E+00, 1.2728395066E+00, 8.2661898689E-01, 8.8366160771E-01],
	[4.0385000000E+04, 9.6353408564E+00, 3.1221169613E+00, 1.2733281295E+00, 8.2684014406E-01, 8.8368550892E-01],
	[4.0390000000E+04, 9.6373221281E+00, 3.1221242708E+00, 1.2738168795E+00, 8.2706131004E-01, 8.8370940543E-01],
	[4.0395000000E+04, 9.6393035619E+00, 3.1221315794E+00, 1.2743057564E+00, 8.2728248482E-01, 8.8373329724E-01],
	[4.0400000000E+04, 9.6412851578E+00, 3.1221388872E+00, 1.2747947604E+00, 8.2750366838E-01, 8.8375718436E-01],
	[4.0405000000E+04, 9.6432669157E+00, 3.1221461940E+00, 1.2752838913E+00, 8.2772486072E-01, 8.8378106677E-01],
	[4.0410000000E+04, 9.6452488357E+00, 3.1221535000E+00, 1.2757731493E+00, 8.2794606182E-01, 8.8380494449E-01],
	[4.0415000000E+04, 9.6472309177E+00, 3.1221608051E+00, 1.2762625343E+00, 8.2816727167E-01, 8.8382881751E-01],
	[4.0420000000E+04, 9.6492131618E+00, 3.1221681093E+00, 1.2767520465E+00, 8.2838849026E-01, 8.8385268584E-01],
	[4.0425000000E+04, 9.6511955679E+00, 3.1221754127E+00, 1.2772416857E+00, 8.2860971757E-01, 8.8387654947E-01],
	[4.0430000000E+04, 9.6531781360E+00, 3.1221827151E+00, 1.2777314520E+00, 8.2883095359E-01, 8.8390040841E-01],
	[4.0435000000E+04, 9.6551608661E+00, 3.1221900166E+00, 1.2782213454E+00, 8.2905219831E-01, 8.8392426265E-01],
	[4.0440000000E+04, 9.6571437583E+00, 3.1221973173E+00, 1.2787113659E+00, 8.2927345172E-01, 8.8394811221E-01],
	[4.0445000000E+04, 9.6591268124E+00, 3.1222046171E+00, 1.2792015137E+00, 8.2949471380E-01, 8.8397195707E-01],
	[4.0450000000E+04, 9.6611100286E+00, 3.1222119160E+00, 1.2796917885E+00, 8.2971598454E-01, 8.8399579725E-01],
	[4.0455000000E+04, 9.6630934067E+00, 3.1222192140E+00, 1.2801821906E+00, 8.2993726393E-01, 8.8401963274E-01],
	[4.0460000000E+04, 9.6650769468E+00, 3.1222265111E+00, 1.2806727199E+00, 8.3015855196E-01, 8.8404346354E-01],
	[4.0465000000E+04, 9.6670606489E+00, 3.1222338073E+00, 1.2811633764E+00, 8.3037984861E-01, 8.8406728965E-01],
	[4.0470000000E+04, 9.6690445130E+00, 3.1222411027E+00, 1.2816541602E+00, 8.3060115388E-01, 8.8409111107E-01],
	[4.0475000000E+04, 9.6710285390E+00, 3.1222483972E+00, 1.2821450712E+00, 8.3082246774E-01, 8.8411492782E-01],
	[4.0480000000E+04, 9.6730127270E+00, 3.1222556908E+00, 1.2826361095E+00, 8.3104379019E-01, 8.8413873987E-01],
	[4.0485000000E+04, 9.6749970770E+00, 3.1222629835E+00, 1.2831272750E+00, 8.3126512122E-01, 8.8416254725E-01],
	[4.0490000000E+04, 9.6769815888E+00, 3.1222702753E+00, 1.2836185679E+00, 8.3148646080E-01, 8.8418634994E-01],
	[4.0495000000E+04, 9.6789662627E+00, 3.1222775662E+00, 1.2841099881E+00, 8.3170780894E-01, 8.8421014795E-01],
	[4.0500000000E+04, 9.6809510984E+00, 3.1222848563E+00, 1.2846015357E+00, 8.3192916561E-01, 8.8423394128E-01],
	[4.0505000000E+04, 9.6829360961E+00, 3.1222921454E+00, 1.2850932106E+00, 8.3215053080E-01, 8.8425772994E-01],
	[4.0510000000E+04, 9.6849212556E+00, 3.1222994337E+00, 1.2855850129E+00, 8.3237190451E-01, 8.8428151391E-01],
	[4.0515000000E+04, 9.6869112599E+00, 3.1223080724E+00, 1.2860769426E+00, 8.3259341740E-01, 8.8430529321E-01],
	[4.0520000000E+04, 9.6889016390E+00, 3.1223167711E+00, 1.2865689998E+00, 8.3281494479E-01, 8.8432906783E-01],
	[4.0525000000E+04, 9.6908921814E+00, 3.1223254687E+00, 1.2870611843E+00, 8.3303648076E-01, 8.8435283777E-01],
	[4.0530000000E+04, 9.6928828871E+00, 3.1223341653E+00, 1.2875534963E+00, 8.3325802532E-01, 8.8437660304E-01],
	[4.0535000000E+04, 9.6948737561E+00, 3.1223428609E+00, 1.2880459358E+00, 8.3347957843E-01, 8.8440036364E-01],
	[4.0540000000E+04, 9.6968647884E+00, 3.1223515554E+00, 1.2885385027E+00, 8.3370114009E-01, 8.8442411956E-01],
	[4.0545000000E+04, 9.6988559839E+00, 3.1223602488E+00, 1.2890311972E+00, 8.3392271030E-01, 8.8444787081E-01],
	[4.0550000000E+04, 9.7008473428E+00, 3.1223689412E+00, 1.2895240191E+00, 8.3414428902E-01, 8.8447161740E-01],
	[4.0555000000E+04, 9.7028388648E+00, 3.1223776326E+00, 1.2900169686E+00, 8.3436587627E-01, 8.8449535931E-01],
	[4.0560000000E+04, 9.7048305502E+00, 3.1223863229E+00, 1.2905100457E+00, 8.3458747201E-01, 8.8451909655E-01],
	[4.0565000000E+04, 9.7068223987E+00, 3.1223950122E+00, 1.2910032503E+00, 8.3480907624E-01, 8.8454282913E-01],
	[4.0570000000E+04, 9.7088144105E+00, 3.1224037004E+00, 1.2914965825E+00, 8.3503068894E-01, 8.8456655703E-01],
	[4.0575000000E+04, 9.7108065856E+00, 3.1224123875E+00, 1.2919900423E+00, 8.3525231011E-01, 8.8459028027E-01],
	[4.0580000000E+04, 9.7127989239E+00, 3.1224210737E+00, 1.2924836297E+00, 8.3547393973E-01, 8.8461399885E-01],
	[4.0585000000E+04, 9.7147914254E+00, 3.1224297587E+00, 1.2929773448E+00, 8.3569557779E-01, 8.8463771276E-01],
	[4.0590000000E+04, 9.7167840901E+00, 3.1224384428E+00, 1.2934711875E+00, 8.3591722427E-01, 8.8466142201E-01],
	[4.0595000000E+04, 9.7187769180E+00, 3.1224471258E+00, 1.2939651579E+00, 8.3613887917E-01, 8.8468512660E-01],
	[4.0600000000E+04, 9.7207699091E+00, 3.1224558077E+00, 1.2944592560E+00, 8.3636054247E-01, 8.8470882653E-01],
	[4.0605000000E+04, 9.7227630634E+00, 3.1224644886E+00, 1.2949534818E+00, 8.3658221415E-01, 8.8473252179E-01],
	[4.0610000000E+04, 9.7247563809E+00, 3.1224731685E+00, 1.2954478353E+00, 8.3680389422E-01, 8.8475621240E-01],
	[4.0615000000E+04, 9.7267498615E+00, 3.1224818473E+00, 1.2959423166E+00, 8.3702558264E-01, 8.8477989834E-01],
	[4.0620000000E+04, 9.7287435054E+00, 3.1224905250E+00, 1.2964369256E+00, 8.3724727942E-01, 8.8480357963E-01],
	[4.0625000000E+04, 9.7307373124E+00, 3.1224992017E+00, 1.2969316624E+00, 8.3746898454E-01, 8.8482725626E-01],
	[4.0630000000E+04, 9.7327312825E+00, 3.1225078774E+00, 1.2974265270E+00, 8.3769069799E-01, 8.8485092824E-01],
	[4.0635000000E+04, 9.7347254158E+00, 3.1225165520E+00, 1.2979215194E+00, 8.3791241974E-01, 8.8487459556E-01],
	[4.0640000000E+04, 9.7367197123E+00, 3.1225252256E+00, 1.2984166396E+00, 8.3813414981E-01, 8.8489825823E-01],
	[4.0645000000E+04, 9.7387141719E+00, 3.1225338982E+00, 1.2989118877E+00, 8.3835588816E-01, 8.8492191625E-01],
	[4.0650000000E+04, 9.7407087946E+00, 3.1225425697E+00, 1.2994072636E+00, 8.3857763478E-01, 8.8494556961E-01],
	[4.0655000000E+04, 9.7427035805E+00, 3.1225512401E+00, 1.2999027674E+00, 8.3879938968E-01, 8.8496921832E-01],
	[4.0660000000E+04, 9.7446985294E+00, 3.1225599096E+00, 1.3003983992E+00, 8.3902115282E-01, 8.8499286238E-01],
	[4.0665000000E+04, 9.7466936415E+00, 3.1225685779E+00, 1.3008941588E+00, 8.3924292421E-01, 8.8501650180E-01],
	[4.0670000000E+04, 9.7486889167E+00, 3.1225772453E+00, 1.3013900463E+00, 8.3946470382E-01, 8.8504013656E-01],
	[4.0675000000E+04, 9.7506843550E+00, 3.1225859116E+00, 1.3018860618E+00, 8.3968649164E-01, 8.8506376668E-01],
	[4.0680000000E+04, 9.7526799564E+00, 3.1225945768E+00, 1.3023822053E+00, 8.3990828767E-01, 8.8508739215E-01],
	[4.0685000000E+04, 9.7546757208E+00, 3.1226032410E+00, 1.3028784768E+00, 8.4013009189E-01, 8.8511101297E-01],
	[4.0690000000E+04, 9.7566716484E+00, 3.1226119042E+00, 1.3033748762E+00, 8.4035190429E-01, 8.8513462915E-01],
	[4.0695000000E+04, 9.7586677390E+00, 3.1226205663E+00, 1.3038714037E+00, 8.4057372486E-01, 8.8515824069E-01],
	[4.0700000000E+04, 9.7606639926E+00, 3.1226292274E+00, 1.3043680592E+00, 8.4079555357E-01, 8.8518184758E-01],
	[4.0705000000E+04, 9.7626604094E+00, 3.1226378874E+00, 1.3048648428E+00, 8.4101739043E-01, 8.8520544984E-01],
	[4.0710000000E+04, 9.7646569891E+00, 3.1226465465E+00, 1.3053617544E+00, 8.4123923542E-01, 8.8522904745E-01],
	[4.0715000000E+04, 9.7666537320E+00, 3.1226552044E+00, 1.3058587941E+00, 8.4146108852E-01, 8.8525264042E-01],
	[4.0720000000E+04, 9.7686506378E+00, 3.1226638614E+00, 1.3063559619E+00, 8.4168294973E-01, 8.8527622875E-01],
	[4.0725000000E+04, 9.7706477067E+00, 3.1226725172E+00, 1.3068532579E+00, 8.4190481902E-01, 8.8529981245E-01],
	[4.0730000000E+04, 9.7726449386E+00, 3.1226811721E+00, 1.3073506820E+00, 8.4212669640E-01, 8.8532339150E-01],
	[4.0735000000E+04, 9.7746423336E+00, 3.1226898259E+00, 1.3078482342E+00, 8.4234858184E-01, 8.8534696593E-01],
	[4.0740000000E+04, 9.7766398915E+00, 3.1226984787E+00, 1.3083459146E+00, 8.4257047534E-01, 8.8537053571E-01],
	[4.0745000000E+04, 9.7786376125E+00, 3.1227071304E+00, 1.3088437232E+00, 8.4279237688E-01, 8.8539410086E-01],
	[4.0750000000E+04, 9.7806354964E+00, 3.1227157811E+00, 1.3093416600E+00, 8.4301428645E-01, 8.8541766138E-01],
	[4.0755000000E+04, 9.7826335434E+00, 3.1227244308E+00, 1.3098397251E+00, 8.4323620403E-01, 8.8544121727E-01],
	[4.0760000000E+04, 9.7846317533E+00, 3.1227330794E+00, 1.3103379183E+00, 8.4345812962E-01, 8.8546476852E-01],
	[4.0765000000E+04, 9.7866301262E+00, 3.1227417270E+00, 1.3108362399E+00, 8.4368006321E-01, 8.8548831515E-01],
	[4.0770000000E+04, 9.7886286621E+00, 3.1227503736E+00, 1.3113346897E+00, 8.4390200477E-01, 8.8551185714E-01],
	[4.0775000000E+04, 9.7906273609E+00, 3.1227590191E+00, 1.3118332678E+00, 8.4412395430E-01, 8.8553539451E-01],
	[4.0780000000E+04, 9.7926262227E+00, 3.1227676636E+00, 1.3123319742E+00, 8.4434591178E-01, 8.8555892725E-01],
	[4.0785000000E+04, 9.7946252474E+00, 3.1227763070E+00, 1.3128308089E+00, 8.4456787721E-01, 8.8558245536E-01],
	[4.0790000000E+04, 9.7966244351E+00, 3.1227849494E+00, 1.3133297720E+00, 8.4478985057E-01, 8.8560597884E-01],
	[4.0795000000E+04, 9.7986237857E+00, 3.1227935908E+00, 1.3138288635E+00, 8.4501183185E-01, 8.8562949770E-01],
	[4.0800000000E+04, 9.8006232993E+00, 3.1228022311E+00, 1.3143280833E+00, 8.4523382103E-01, 8.8565301194E-01],
	[4.0805000000E+04, 9.8026229758E+00, 3.1228108704E+00, 1.3148274316E+00, 8.4545581811E-01, 8.8567652155E-01],
	[4.0810000000E+04, 9.8046228151E+00, 3.1228195087E+00, 1.3153269082E+00, 8.4567782307E-01, 8.8570002655E-01],
	[4.0815000000E+04, 9.8066228174E+00, 3.1228281459E+00, 1.3158265133E+00, 8.4589983589E-01, 8.8572352692E-01],
	[4.0820000000E+04, 9.8086229827E+00, 3.1228367821E+00, 1.3163262468E+00, 8.4612185658E-01, 8.8574702267E-01],
	[4.0825000000E+04, 9.8106233108E+00, 3.1228454173E+00, 1.3168261088E+00, 8.4634388510E-01, 8.8577051380E-01],
	[4.0830000000E+04, 9.8126238018E+00, 3.1228540514E+00, 1.3173260993E+00, 8.4656592146E-01, 8.8579400031E-01],
	[4.0835000000E+04, 9.8146244556E+00, 3.1228626845E+00, 1.3178262182E+00, 8.4678796564E-01, 8.8581748220E-01],
	[4.0840000000E+04, 9.8166252724E+00, 3.1228713166E+00, 1.3183264657E+00, 8.4701001763E-01, 8.8584095948E-01],
	[4.0845000000E+04, 9.8186262520E+00, 3.1228799476E+00, 1.3188268418E+00, 8.4723207741E-01, 8.8586443214E-01],
	[4.0850000000E+04, 9.8206273945E+00, 3.1228885776E+00, 1.3193273463E+00, 8.4745414497E-01, 8.8588790019E-01],
	[4.0855000000E+04, 9.8226286998E+00, 3.1228972066E+00, 1.3198279795E+00, 8.4767622030E-01, 8.8591136362E-01],
	[4.0860000000E+04, 9.8246301680E+00, 3.1229058345E+00, 1.3203287412E+00, 8.4789830339E-01, 8.8593482245E-01],
	[4.0865000000E+04, 9.8266317991E+00, 3.1229144614E+00, 1.3208296316E+00, 8.4812039423E-01, 8.8595827665E-01],
	[4.0870000000E+04, 9.8286335929E+00, 3.1229230873E+00, 1.3213306505E+00, 8.4834249280E-01, 8.8598172625E-01],
	[4.0875000000E+04, 9.8306355496E+00, 3.1229317121E+00, 1.3218317981E+00, 8.4856459909E-01, 8.8600517124E-01],
	[4.0880000000E+04, 9.8326376692E+00, 3.1229403359E+00, 1.3223330744E+00, 8.4878671309E-01, 8.8602861162E-01],
	[4.0885000000E+04, 9.8346399515E+00, 3.1229489587E+00, 1.3228344793E+00, 8.4900883478E-01, 8.8605204739E-01],
	[4.0890000000E+04, 9.8366423967E+00, 3.1229575805E+00, 1.3233360130E+00, 8.4923096416E-01, 8.8607547855E-01],
	[4.0895000000E+04, 9.8386450046E+00, 3.1229662012E+00, 1.3238376753E+00, 8.4945310121E-01, 8.8609890511E-01],
	[4.0900000000E+04, 9.8406477754E+00, 3.1229748209E+00, 1.3243394663E+00, 8.4967524592E-01, 8.8612232706E-01],
	[4.0905000000E+04, 9.8426507089E+00, 3.1229834395E+00, 1.3248413861E+00, 8.4989739828E-01, 8.8614574441E-01],
	[4.0910000000E+04, 9.8446538053E+00, 3.1229920572E+00, 1.3253434347E+00, 8.5011955827E-01, 8.8616915716E-01],
	[4.0915000000E+04, 9.8466570644E+00, 3.1230006738E+00, 1.3258456120E+00, 8.5034172588E-01, 8.8619256530E-01],
	[4.0920000000E+04, 9.8486604862E+00, 3.1230092893E+00, 1.3263479182E+00, 8.5056390110E-01, 8.8621596884E-01],
	[4.0925000000E+04, 9.8506640709E+00, 3.1230179039E+00, 1.3268503531E+00, 8.5078608392E-01, 8.8623936778E-01],
	[4.0930000000E+04, 9.8526678183E+00, 3.1230265174E+00, 1.3273529169E+00, 8.5100827433E-01, 8.8626276211E-01],
	[4.0935000000E+04, 9.8546717284E+00, 3.1230351299E+00, 1.3278556095E+00, 8.5123047231E-01, 8.8628615186E-01],
	[4.0940000000E+04, 9.8566758013E+00, 3.1230437413E+00, 1.3283584310E+00, 8.5145267785E-01, 8.8630953700E-01],
	[4.0945000000E+04, 9.8586800369E+00, 3.1230523517E+00, 1.3288613813E+00, 8.5167489094E-01, 8.8633291754E-01],
	[4.0950000000E+04, 9.8606844353E+00, 3.1230609611E+00, 1.3293644606E+00, 8.5189711156E-01, 8.8635629349E-01],
	[4.0955000000E+04, 9.8626889964E+00, 3.1230695695E+00, 1.3298676688E+00, 8.5211933971E-01, 8.8637966485E-01],
	[4.0960000000E+04, 9.8646937202E+00, 3.1230781769E+00, 1.3303710059E+00, 8.5234157537E-01, 8.8640303161E-01],
	[4.0965000000E+04, 9.8666986067E+00, 3.1230867832E+00, 1.3308744719E+00, 8.5256381853E-01, 8.8642639377E-01],
	[4.0970000000E+04, 9.8687036559E+00, 3.1230953885E+00, 1.3313780669E+00, 8.5278606917E-01, 8.8644975135E-01],
	[4.0975000000E+04, 9.8707088678E+00, 3.1231039927E+00, 1.3318817909E+00, 8.5300832729E-01, 8.8647310433E-01],
	[4.0980000000E+04, 9.8727142424E+00, 3.1231125960E+00, 1.3323856439E+00, 8.5323059288E-01, 8.8649645272E-01],
	[4.0985000000E+04, 9.8747197796E+00, 3.1231211982E+00, 1.3328896260E+00, 8.5345286591E-01, 8.8651979652E-01],
	[4.0990000000E+04, 9.8767254796E+00, 3.1231297994E+00, 1.3333937370E+00, 8.5367514638E-01, 8.8654313574E-01],
	[4.0995000000E+04, 9.8787313422E+00, 3.1231383995E+00, 1.3338979771E+00, 8.5389743428E-01, 8.8656647036E-01],
	[4.1000000000E+04, 9.8807373675E+00, 3.1231469987E+00, 1.3344023463E+00, 8.5411972959E-01, 8.8658980040E-01],
	[4.1005000000E+04, 9.8827435555E+00, 3.1231555968E+00, 1.3349068446E+00, 8.5434203230E-01, 8.8661312586E-01],
	[4.1010000000E+04, 9.8847499061E+00, 3.1231641939E+00, 1.3354114720E+00, 8.5456434239E-01, 8.8663644673E-01],
	[4.1015000000E+04, 9.8867564193E+00, 3.1231727899E+00, 1.3359162285E+00, 8.5478665987E-01, 8.8665976301E-01],
	[4.1020000000E+04, 9.8887630952E+00, 3.1231813850E+00, 1.3364211141E+00, 8.5500898471E-01, 8.8668307471E-01],
	[4.1025000000E+04, 9.8907699337E+00, 3.1231899790E+00, 1.3369261289E+00, 8.5523131690E-01, 8.8670638183E-01],
	[4.1030000000E+04, 9.8927769348E+00, 3.1231985720E+00, 1.3374312729E+00, 8.5545365643E-01, 8.8672968437E-01],
	[4.1035000000E+04, 9.8947840986E+00, 3.1232071639E+00, 1.3379365460E+00, 8.5567600329E-01, 8.8675298233E-01],
	[4.1040000000E+04, 9.8967914249E+00, 3.1232157549E+00, 1.3384419484E+00, 8.5589835746E-01, 8.8677627571E-01],
	[4.1045000000E+04, 9.8987989139E+00, 3.1232243448E+00, 1.3389474800E+00, 8.5612071894E-01, 8.8679956451E-01],
	[4.1050000000E+04, 9.9008065654E+00, 3.1232329337E+00, 1.3394531408E+00, 8.5634308770E-01, 8.8682284873E-01],
	[4.1055000000E+04, 9.9028143796E+00, 3.1232415216E+00, 1.3399589309E+00, 8.5656546374E-01, 8.8684612837E-01],
	[4.1060000000E+04, 9.9048223563E+00, 3.1232501084E+00, 1.3404648503E+00, 8.5678784705E-01, 8.8686940344E-01],
	[4.1065000000E+04, 9.9068304956E+00, 3.1232586943E+00, 1.3409708990E+00, 8.5701023762E-01, 8.8689267394E-01],
	[4.1070000000E+04, 9.9088387975E+00, 3.1232672791E+00, 1.3414770770E+00, 8.5723263542E-01, 8.8691593986E-01],
	[4.1075000000E+04, 9.9108472620E+00, 3.1232758629E+00, 1.3419833843E+00, 8.5745504046E-01, 8.8693920121E-01],
	[4.1080000000E+04, 9.9128558890E+00, 3.1232844456E+00, 1.3424898209E+00, 8.5767745271E-01, 8.8696245799E-01],
	[4.1085000000E+04, 9.9148646785E+00, 3.1232930274E+00, 1.3429963869E+00, 8.5789987216E-01, 8.8698571019E-01],
	[4.1090000000E+04, 9.9168736306E+00, 3.1233016081E+00, 1.3435030823E+00, 8.5812229881E-01, 8.8700895783E-01],
	[4.1095000000E+04, 9.9188827452E+00, 3.1233101878E+00, 1.3440099071E+00, 8.5834473264E-01, 8.8703220089E-01],
	[4.1100000000E+04, 9.9208920224E+00, 3.1233187665E+00, 1.3445168614E+00, 8.5856717364E-01, 8.8705543939E-01],
	[4.1105000000E+04, 9.9229014621E+00, 3.1233273442E+00, 1.3450239450E+00, 8.5878962179E-01, 8.8707867332E-01],
	[4.1110000000E+04, 9.9249110643E+00, 3.1233359208E+00, 1.3455311581E+00, 8.5901207708E-01, 8.8710190269E-01],
	[4.1115000000E+04, 9.9269208290E+00, 3.1233444964E+00, 1.3460385007E+00, 8.5923453951E-01, 8.8712512749E-01],
	[4.1120000000E+04, 9.9289307562E+00, 3.1233530710E+00, 1.3465459727E+00, 8.5945700905E-01, 8.8714834772E-01],
	[4.1125000000E+04, 9.9309408460E+00, 3.1233616446E+00, 1.3470535743E+00, 8.5967948570E-01, 8.8717156339E-01],
	[4.1130000000E+04, 9.9329510982E+00, 3.1233702172E+00, 1.3475613053E+00, 8.5990196945E-01, 8.8719477450E-01],
	[4.1135000000E+04, 9.9349615129E+00, 3.1233787887E+00, 1.3480691660E+00, 8.6012446028E-01, 8.8721798104E-01],
	[4.1140000000E+04, 9.9369720900E+00, 3.1233873593E+00, 1.3485771561E+00, 8.6034695818E-01, 8.8724118303E-01],
	[4.1145000000E+04, 9.9389828297E+00, 3.1233959288E+00, 1.3490852758E+00, 8.6056946313E-01, 8.8726438046E-01],
	[4.1150000000E+04, 9.9409937318E+00, 3.1234044973E+00, 1.3495935252E+00, 8.6079197513E-01, 8.8728757332E-01],
	[4.1155000000E+04, 9.9430047963E+00, 3.1234130648E+00, 1.3501019041E+00, 8.6101449417E-01, 8.8731076163E-01],
	[4.1160000000E+04, 9.9450160234E+00, 3.1234216312E+00, 1.3506104126E+00, 8.6123702022E-01, 8.8733394538E-01],
	[4.1165000000E+04, 9.9470300348E+00, 3.1234309227E+00, 1.3511190508E+00, 8.6145962818E-01, 8.8735712458E-01],
	[4.1170000000E+04, 9.9490465831E+00, 3.1234408702E+00, 1.3516278187E+00, 8.6168231102E-01, 8.8738029922E-01],
	[4.1175000000E+04, 9.9510632952E+00, 3.1234508166E+00, 1.3521367162E+00, 8.6190500095E-01, 8.8740346930E-01],
	[4.1180000000E+04, 9.9530801711E+00, 3.1234607617E+00, 1.3526457434E+00, 8.6212769797E-01, 8.8742663483E-01],
	[4.1185000000E+04, 9.9550972109E+00, 3.1234707057E+00, 1.3531549003E+00, 8.6235040206E-01, 8.8744979581E-01],
	[4.1190000000E+04, 9.9571144145E+00, 3.1234806485E+00, 1.3536641870E+00, 8.6257311322E-01, 8.8747295224E-01],
	[4.1195000000E+04, 9.9591317819E+00, 3.1234905902E+00, 1.3541736034E+00, 8.6279583142E-01, 8.8749610412E-01],
	[4.1200000000E+04, 9.9611493131E+00, 3.1235005306E+00, 1.3546831495E+00, 8.6301855667E-01, 8.8751925144E-01],
	[4.1205000000E+04, 9.9631670082E+00, 3.1235104699E+00, 1.3551928255E+00, 8.6324128893E-01, 8.8754239422E-01],
	[4.1210000000E+04, 9.9651848670E+00, 3.1235204080E+00, 1.3557026312E+00, 8.6346402822E-01, 8.8756553245E-01],
	[4.1215000000E+04, 9.9672028897E+00, 3.1235303450E+00, 1.3562125667E+00, 8.6368677450E-01, 8.8758866614E-01],
	[4.1220000000E+04, 9.9692210761E+00, 3.1235402807E+00, 1.3567226321E+00, 8.6390952777E-01, 8.8761179527E-01],
	[4.1225000000E+04, 9.9712394263E+00, 3.1235502153E+00, 1.3572328273E+00, 8.6413228802E-01, 8.8763491987E-01],
	[4.1230000000E+04, 9.9732579403E+00, 3.1235601488E+00, 1.3577431524E+00, 8.6435505523E-01, 8.8765803991E-01],
	[4.1235000000E+04, 9.9752766180E+00, 3.1235700810E+00, 1.3582536074E+00, 8.6457782940E-01, 8.8768115542E-01],
	[4.1240000000E+04, 9.9772954596E+00, 3.1235800121E+00, 1.3587641922E+00, 8.6480061051E-01, 8.8770426638E-01],
	[4.1245000000E+04, 9.9793144648E+00, 3.1235899420E+00, 1.3592749070E+00, 8.6502339854E-01, 8.8772737280E-01],
	[4.1250000000E+04, 9.9813336339E+00, 3.1235998707E+00, 1.3597857517E+00, 8.6524619349E-01, 8.8775047468E-01],
	[4.1255000000E+04, 9.9833529666E+00, 3.1236097983E+00, 1.3602967264E+00, 8.6546899535E-01, 8.8777357202E-01],
	[4.1260000000E+04, 9.9853724631E+00, 3.1236197247E+00, 1.3608078310E+00, 8.6569180409E-01, 8.8779666482E-01],
	[4.1265000000E+04, 9.9873921233E+00, 3.1236296499E+00, 1.3613190656E+00, 8.6591461972E-01, 8.8781975309E-01],
	[4.1270000000E+04, 9.9894119473E+00, 3.1236395739E+00, 1.3618304303E+00, 8.6613744221E-01, 8.8784283682E-01],
	[4.1275000000E+04, 9.9914319350E+00, 3.1236494968E+00, 1.3623419249E+00, 8.6636027156E-01, 8.8786591601E-01],
	[4.1280000000E+04, 9.9934520863E+00, 3.1236594185E+00, 1.3628535496E+00, 8.6658310775E-01, 8.8788899066E-01],
	[4.1285000000E+04, 9.9954724014E+00, 3.1236693390E+00, 1.3633653043E+00, 8.6680595078E-01, 8.8791206079E-01],
	[4.1290000000E+04, 9.9974928802E+00, 3.1236792584E+00, 1.3638771891E+00, 8.6702880062E-01, 8.8793512638E-01],
	[4.1295000000E+04, 9.9995135227E+00, 3.1236891766E+00, 1.3643892040E+00, 8.6725165726E-01, 8.8795818743E-01],
	[4.1300000000E+04, 1.0001534329E+01, 3.1236990936E+00, 1.3649013490E+00, 8.6747452071E-01, 8.8798124396E-01],
	[4.1305000000E+04, 1.0003555299E+01, 3.1237090095E+00, 1.3654136241E+00, 8.6769739093E-01, 8.8800429595E-01],
	[4.1310000000E+04, 1.0005576432E+01, 3.1237189241E+00, 1.3659260294E+00, 8.6792026792E-01, 8.8802734342E-01],
	[4.1315000000E+04, 1.0007597729E+01, 3.1237288377E+00, 1.3664385648E+00, 8.6814315168E-01, 8.8805038636E-01],
	[4.1320000000E+04, 1.0009619190E+01, 3.1237387500E+00, 1.3669512304E+00, 8.6836604217E-01, 8.8807342477E-01],
	[4.1325000000E+04, 1.0011640815E+01, 3.1237486612E+00, 1.3674640262E+00, 8.6858893941E-01, 8.8809645865E-01],
	[4.1330000000E+04, 1.0013662603E+01, 3.1237585712E+00, 1.3679769522E+00, 8.6881184336E-01, 8.8811948801E-01],
	[4.1335000000E+04, 1.0015684554E+01, 3.1237684800E+00, 1.3684900084E+00, 8.6903475402E-01, 8.8814251284E-01],
	[4.1340000000E+04, 1.0017706670E+01, 3.1237783877E+00, 1.3690031949E+00, 8.6925767138E-01, 8.8816553315E-01],
	[4.1345000000E+04, 1.0019728949E+01, 3.1237882942E+00, 1.3695165116E+00, 8.6948059543E-01, 8.8818854893E-01],
	[4.1350000000E+04, 1.0021751391E+01, 3.1237981996E+00, 1.3700299587E+00, 8.6970352615E-01, 8.8821156020E-01],
	[4.1355000000E+04, 1.0023773998E+01, 3.1238081038E+00, 1.3705435360E+00, 8.6992646352E-01, 8.8823456694E-01],
	[4.1360000000E+04, 1.0025796767E+01, 3.1238180068E+00, 1.3710572436E+00, 8.7014940755E-01, 8.8825756916E-01],
	[4.1365000000E+04, 1.0027819701E+01, 3.1238279086E+00, 1.3715710815E+00, 8.7037235822E-01, 8.8828056686E-01],
	[4.1370000000E+04, 1.0029842798E+01, 3.1238378093E+00, 1.3720850499E+00, 8.7059531550E-01, 8.8830356005E-01],
	[4.1375000000E+04, 1.0031866059E+01, 3.1238477088E+00, 1.3725991485E+00, 8.7081827941E-01, 8.8832654871E-01],
	[4.1380000000E+04, 1.0033889483E+01, 3.1238576072E+00, 1.3731133776E+00, 8.7104124991E-01, 8.8834953286E-01],
	[4.1385000000E+04, 1.0035913070E+01, 3.1238675044E+00, 1.3736277370E+00, 8.7126422700E-01, 8.8837251250E-01],
	[4.1390000000E+04, 1.0037936822E+01, 3.1238774004E+00, 1.3741422269E+00, 8.7148721066E-01, 8.8839548762E-01],
	[4.1395000000E+04, 1.0039960737E+01, 3.1238872952E+00, 1.3746568472E+00, 8.7171020089E-01, 8.8841845822E-01],
	[4.1400000000E+04, 1.0041984815E+01, 3.1238971889E+00, 1.3751715980E+00, 8.7193319767E-01, 8.8844142431E-01],
	[4.1405000000E+04, 1.0044009057E+01, 3.1239070815E+00, 1.3756864792E+00, 8.7215620099E-01, 8.8846438590E-01],
	[4.1410000000E+04, 1.0046033463E+01, 3.1239169728E+00, 1.3762014909E+00, 8.7237921084E-01, 8.8848734296E-01],
	[4.1415000000E+04, 1.0048058032E+01, 3.1239268630E+00, 1.3767166331E+00, 8.7260222720E-01, 8.8851029552E-01],
	[4.1420000000E+04, 1.0050082764E+01, 3.1239367521E+00, 1.3772319058E+00, 8.7282525007E-01, 8.8853324357E-01],
	[4.1425000000E+04, 1.0052107660E+01, 3.1239466400E+00, 1.3777473091E+00, 8.7304827943E-01, 8.8855618712E-01],
	[4.1430000000E+04, 1.0054132720E+01, 3.1239565267E+00, 1.3782628429E+00, 8.7327131527E-01, 8.8857912615E-01],
	[4.1435000000E+04, 1.0056157943E+01, 3.1239664122E+00, 1.3787785073E+00, 8.7349435757E-01, 8.8860206068E-01],
	[4.1440000000E+04, 1.0058183330E+01, 3.1239762966E+00, 1.3792943023E+00, 8.7371740633E-01, 8.8862499070E-01],
	[4.1445000000E+04, 1.0060208880E+01, 3.1239861799E+00, 1.3798102279E+00, 8.7394046153E-01, 8.8864791622E-01],
	[4.1450000000E+04, 1.0062234593E+01, 3.1239960619E+00, 1.3803262842E+00, 8.7416352316E-01, 8.8867083723E-01],
	[4.1455000000E+04, 1.0064260470E+01, 3.1240059429E+00, 1.3808424710E+00, 8.7438659121E-01, 8.8869375375E-01],
	[4.1460000000E+04, 1.0066286511E+01, 3.1240158226E+00, 1.3813587886E+00, 8.7460966567E-01, 8.8871666576E-01],
	[4.1465000000E+04, 1.0068312715E+01, 3.1240257012E+00, 1.3818752368E+00, 8.7483274652E-01, 8.8873957326E-01],
	[4.1470000000E+04, 1.0070339083E+01, 3.1240355786E+00, 1.3823918156E+00, 8.7505583376E-01, 8.8876247627E-01],
	[4.1475000000E+04, 1.0072365613E+01, 3.1240454549E+00, 1.3829085253E+00, 8.7527892736E-01, 8.8878537478E-01],
	[4.1480000000E+04, 1.0074392308E+01, 3.1240553300E+00, 1.3834253656E+00, 8.7550202733E-01, 8.8880826879E-01],
	[4.1485000000E+04, 1.0076419166E+01, 3.1240652040E+00, 1.3839423367E+00, 8.7572513364E-01, 8.8883115831E-01],
	[4.1490000000E+04, 1.0078446187E+01, 3.1240750768E+00, 1.3844594385E+00, 8.7594824628E-01, 8.8885404332E-01],
	[4.1495000000E+04, 1.0080473372E+01, 3.1240849484E+00, 1.3849766711E+00, 8.7617136524E-01, 8.8887692385E-01],
	[4.1500000000E+04, 1.0082500720E+01, 3.1240948189E+00, 1.3854940346E+00, 8.7639449052E-01, 8.8889979987E-01],
	[4.1505000000E+04, 1.0084528231E+01, 3.1241046882E+00, 1.3860115288E+00, 8.7661762209E-01, 8.8892267141E-01],
	[4.1510000000E+04, 1.0086555906E+01, 3.1241145564E+00, 1.3865291539E+00, 8.7684075995E-01, 8.8894553845E-01],
	[4.1515000000E+04, 1.0088583744E+01, 3.1241244234E+00, 1.3870469098E+00, 8.7706390408E-01, 8.8896840100E-01],
	[4.1520000000E+04, 1.0090611746E+01, 3.1241342892E+00, 1.3875647966E+00, 8.7728705447E-01, 8.8899125906E-01],
	[4.1525000000E+04, 1.0092639911E+01, 3.1241441539E+00, 1.3880828142E+00, 8.7751021112E-01, 8.8901411263E-01],
	[4.1530000000E+04, 1.0094668240E+01, 3.1241540174E+00, 1.3886009628E+00, 8.7773337400E-01, 8.8903696170E-01],
	[4.1535000000E+04, 1.0096696732E+01, 3.1241638798E+00, 1.3891192423E+00, 8.7795654310E-01, 8.8905980630E-01],
	[4.1540000000E+04, 1.0098725387E+01, 3.1241737410E+00, 1.3896376527E+00, 8.7817971842E-01, 8.8908264640E-01],
	[4.1545000000E+04, 1.0100754206E+01, 3.1241836011E+00, 1.3901561941E+00, 8.7840289994E-01, 8.8910548202E-01],
	[4.1550000000E+04, 1.0102783188E+01, 3.1241934600E+00, 1.3906748664E+00, 8.7862608765E-01, 8.8912831315E-01],
	[4.1555000000E+04, 1.0104812333E+01, 3.1242033178E+00, 1.3911936698E+00, 8.7884928154E-01, 8.8915113980E-01],
	[4.1560000000E+04, 1.0106841642E+01, 3.1242131744E+00, 1.3917126041E+00, 8.7907248159E-01, 8.8917396196E-01],
	[4.1565000000E+04, 1.0108871113E+01, 3.1242230298E+00, 1.3922316695E+00, 8.7929568779E-01, 8.8919677964E-01],
	[4.1570000000E+04, 1.0110900749E+01, 3.1242328841E+00, 1.3927508659E+00, 8.7951890014E-01, 8.8921959284E-01],
	[4.1575000000E+04, 1.0112930547E+01, 3.1242427373E+00, 1.3932701933E+00, 8.7974211862E-01, 8.8924240156E-01],
	[4.1580000000E+04, 1.0114960509E+01, 3.1242525892E+00, 1.3937896519E+00, 8.7996534321E-01, 8.8926520580E-01],
	[4.1585000000E+04, 1.0116990635E+01, 3.1242624401E+00, 1.3943092415E+00, 8.8018857390E-01, 8.8928800556E-01],
	[4.1590000000E+04, 1.0119020923E+01, 3.1242722897E+00, 1.3948289622E+00, 8.8041181069E-01, 8.8931080085E-01],
	[4.1595000000E+04, 1.0121051375E+01, 3.1242821383E+00, 1.3953488141E+00, 8.8063505356E-01, 8.8933359165E-01],
	[4.1600000000E+04, 1.0123081990E+01, 3.1242919856E+00, 1.3958687971E+00, 8.8085830250E-01, 8.8935637798E-01],
	[4.1605000000E+04, 1.0125112769E+01, 3.1243018319E+00, 1.3963889112E+00, 8.8108155749E-01, 8.8937915983E-01],
	[4.1610000000E+04, 1.0127143711E+01, 3.1243116769E+00, 1.3969091566E+00, 8.8130481853E-01, 8.8940193721E-01],
	[4.1615000000E+04, 1.0129174816E+01, 3.1243215208E+00, 1.3974295331E+00, 8.8152808561E-01, 8.8942471012E-01],
	[4.1620000000E+04, 1.0131206084E+01, 3.1243313636E+00, 1.3979500409E+00, 8.8175135870E-01, 8.8944747855E-01],
	[4.1625000000E+04, 1.0133237515E+01, 3.1243412052E+00, 1.3984706798E+00, 8.8197463780E-01, 8.8947024251E-01],
	[4.1630000000E+04, 1.0135269110E+01, 3.1243510457E+00, 1.3989914501E+00, 8.8219792290E-01, 8.8949300200E-01],
	[4.1635000000E+04, 1.0137300868E+01, 3.1243608850E+00, 1.3995123515E+00, 8.8242121398E-01, 8.8951575703E-01],
	[4.1640000000E+04, 1.0139332789E+01, 3.1243707231E+00, 1.4000333843E+00, 8.8264451104E-01, 8.8953850758E-01],
	[4.1645000000E+04, 1.0141364874E+01, 3.1243805602E+00, 1.4005545484E+00, 8.8286781405E-01, 8.8956125366E-01],
	[4.1650000000E+04, 1.0143397122E+01, 3.1243903960E+00, 1.4010758438E+00, 8.8309112302E-01, 8.8958399528E-01],
	[4.1655000000E+04, 1.0145429533E+01, 3.1244002307E+00, 1.4015972705E+00, 8.8331443792E-01, 8.8960673243E-01],
	[4.1660000000E+04, 1.0147462107E+01, 3.1244100643E+00, 1.4021188285E+00, 8.8353775874E-01, 8.8962946512E-01],
	[4.1665000000E+04, 1.0149494844E+01, 3.1244198967E+00, 1.4026405180E+00, 8.8376108548E-01, 8.8965219334E-01],
	[4.1670000000E+04, 1.0151527745E+01, 3.1244297280E+00, 1.4031623388E+00, 8.8398441811E-01, 8.8967491709E-01],
	[4.1675000000E+04, 1.0153560808E+01, 3.1244395581E+00, 1.4036842910E+00, 8.8420775664E-01, 8.8969763639E-01],
	[4.1680000000E+04, 1.0155594035E+01, 3.1244493870E+00, 1.4042063747E+00, 8.8443110104E-01, 8.8972035122E-01],
	[4.1685000000E+04, 1.0157627426E+01, 3.1244592148E+00, 1.4047285897E+00, 8.8465445131E-01, 8.8974306160E-01],
	[4.1690000000E+04, 1.0159660979E+01, 3.1244690415E+00, 1.4052509363E+00, 8.8487780743E-01, 8.8976576751E-01],
	[4.1695000000E+04, 1.0161694695E+01, 3.1244788670E+00, 1.4057734143E+00, 8.8510116938E-01, 8.8978846896E-01],
	[4.1700000000E+04, 1.0163728575E+01, 3.1244886914E+00, 1.4062960238E+00, 8.8532453717E-01, 8.8981116596E-01],
	[4.1705000000E+04, 1.0165762618E+01, 3.1244985146E+00, 1.4068187648E+00, 8.8554791078E-01, 8.8983385850E-01],
	[4.1710000000E+04, 1.0167796824E+01, 3.1245083367E+00, 1.4073416373E+00, 8.8577129018E-01, 8.8985654658E-01],
	[4.1715000000E+04, 1.0169831193E+01, 3.1245181576E+00, 1.4078646414E+00, 8.8599467538E-01, 8.8987923021E-01],
	[4.1720000000E+04, 1.0171865725E+01, 3.1245279774E+00, 1.4083877770E+00, 8.8621806636E-01, 8.8990190938E-01],
	[4.1725000000E+04, 1.0173900420E+01, 3.1245377961E+00, 1.4089110442E+00, 8.8644146311E-01, 8.8992458410E-01],
	[4.1730000000E+04, 1.0175935279E+01, 3.1245476136E+00, 1.4094344430E+00, 8.8666486562E-01, 8.8994725437E-01],
	[4.1735000000E+04, 1.0177970300E+01, 3.1245574299E+00, 1.4099579734E+00, 8.8688827387E-01, 8.8996992019E-01],
	[4.1740000000E+04, 1.0180005485E+01, 3.1245672451E+00, 1.4104816354E+00, 8.8711168785E-01, 8.8999258155E-01],
	[4.1745000000E+04, 1.0182040833E+01, 3.1245770592E+00, 1.4110054291E+00, 8.8733510755E-01, 8.9001523847E-01],
	[4.1750000000E+04, 1.0184076344E+01, 3.1245868721E+00, 1.4115293544E+00, 8.8755853296E-01, 8.9003789093E-01],
	[4.1755000000E+04, 1.0186112018E+01, 3.1245966839E+00, 1.4120534114E+00, 8.8778196407E-01, 8.9006053895E-01],
	[4.1760000000E+04, 1.0188147855E+01, 3.1246064945E+00, 1.4125776001E+00, 8.8800540086E-01, 8.9008318253E-01],
	[4.1765000000E+04, 1.0190183855E+01, 3.1246163040E+00, 1.4131019206E+00, 8.8822884332E-01, 8.9010582165E-01],
	[4.1770000000E+04, 1.0192220018E+01, 3.1246261123E+00, 1.4136263727E+00, 8.8845229145E-01, 8.9012845633E-01],
	[4.1775000000E+04, 1.0194256345E+01, 3.1246359195E+00, 1.4141509566E+00, 8.8867574522E-01, 8.9015108657E-01],
	[4.1780000000E+04, 1.0196292834E+01, 3.1246457256E+00, 1.4146756723E+00, 8.8889920463E-01, 8.9017371236E-01],
	[4.1785000000E+04, 1.0198329486E+01, 3.1246555305E+00, 1.4152005197E+00, 8.8912266967E-01, 8.9019633371E-01],
	[4.1790000000E+04, 1.0200366302E+01, 3.1246653343E+00, 1.4157254990E+00, 8.8934614031E-01, 8.9021895062E-01],
	[4.1795000000E+04, 1.0202403280E+01, 3.1246751369E+00, 1.4162506100E+00, 8.8956961656E-01, 8.9024156309E-01],
	[4.1800000000E+04, 1.0204440422E+01, 3.1246849384E+00, 1.4167758529E+00, 8.8979309840E-01, 8.9026417112E-01],
	[4.1805000000E+04, 1.0206477726E+01, 3.1246947387E+00, 1.4173012277E+00, 8.9001658581E-01, 8.9028677471E-01],
	[4.1810000000E+04, 1.0208515194E+01, 3.1247045379E+00, 1.4178267343E+00, 8.9024007879E-01, 8.9030937386E-01],
	[4.1815000000E+04, 1.0210552824E+01, 3.1247143360E+00, 1.4183523728E+00, 8.9046357732E-01, 8.9033196857E-01],
	[4.1820000000E+04, 1.0212590618E+01, 3.1247241329E+00, 1.4188781432E+00, 8.9068708139E-01, 8.9035455885E-01],
	[4.1825000000E+04, 1.0214628575E+01, 3.1247339287E+00, 1.4194040456E+00, 8.9091059099E-01, 8.9037714469E-01],
	[4.1830000000E+04, 1.0216671759E+01, 3.1247450688E+00, 1.4199300799E+00, 8.9113425407E-01, 8.9039972610E-01],
	[4.1835000000E+04, 1.0218715141E+01, 3.1247562168E+00, 1.4204562461E+00, 8.9135792378E-01, 8.9042230308E-01],
	[4.1840000000E+04, 1.0220758689E+01, 3.1247673635E+00, 1.4209825443E+00, 8.9158159909E-01, 8.9044487562E-01],
	[4.1845000000E+04, 1.0222802400E+01, 3.1247785090E+00, 1.4215089745E+00, 8.9180528000E-01, 8.9046744373E-01],
	[4.1850000000E+04, 1.0224846276E+01, 3.1247896531E+00, 1.4220355367E+00, 8.9202896650E-01, 8.9049000741E-01],
	[4.1855000000E+04, 1.0226890317E+01, 3.1248007959E+00, 1.4225622309E+00, 8.9225265856E-01, 8.9051256667E-01],
	[4.1860000000E+04, 1.0228934522E+01, 3.1248119375E+00, 1.4230890572E+00, 8.9247635619E-01, 8.9053512149E-01],
	[4.1865000000E+04, 1.0230978891E+01, 3.1248230777E+00, 1.4236160155E+00, 8.9270005937E-01, 8.9055767188E-01],
	[4.1870000000E+04, 1.0233023424E+01, 3.1248342167E+00, 1.4241431059E+00, 8.9292376809E-01, 8.9058021785E-01],
	[4.1875000000E+04, 1.0235068122E+01, 3.1248453544E+00, 1.4246703284E+00, 8.9314748233E-01, 8.9060275939E-01],
	[4.1880000000E+04, 1.0237112985E+01, 3.1248564907E+00, 1.4251976830E+00, 8.9337120208E-01, 8.9062529651E-01],
	[4.1885000000E+04, 1.0239158011E+01, 3.1248676258E+00, 1.4257251698E+00, 8.9359492734E-01, 8.9064782920E-01],
	[4.1890000000E+04, 1.0241203202E+01, 3.1248787596E+00, 1.4262527886E+00, 8.9381865808E-01, 8.9067035747E-01],
	[4.1895000000E+04, 1.0243248558E+01, 3.1248898922E+00, 1.4267805397E+00, 8.9404239430E-01, 8.9069288131E-01],
	[4.1900000000E+04, 1.0245294077E+01, 3.1249010234E+00, 1.4273084229E+00, 8.9426613599E-01, 8.9071540074E-01],
	[4.1905000000E+04, 1.0247339761E+01, 3.1249121533E+00, 1.4278364383E+00, 8.9448988313E-01, 8.9073791574E-01],
	[4.1910000000E+04, 1.0249385610E+01, 3.1249232820E+00, 1.4283645860E+00, 8.9471363572E-01, 8.9076042633E-01],
	[4.1915000000E+04, 1.0251431622E+01, 3.1249344093E+00, 1.4288928659E+00, 8.9493739373E-01, 8.9078293249E-01],
	[4.1920000000E+04, 1.0253477799E+01, 3.1249455354E+00, 1.4294212780E+00, 8.9516115716E-01, 8.9080543424E-01],
	[4.1925000000E+04, 1.0255524140E+01, 3.1249566602E+00, 1.4299498224E+00, 8.9538492600E-01, 8.9082793157E-01],
	[4.1930000000E+04, 1.0257570646E+01, 3.1249677837E+00, 1.4304784990E+00, 8.9560870023E-01, 8.9085042448E-01],
	[4.1935000000E+04, 1.0259617316E+01, 3.1249789059E+00, 1.4310073080E+00, 8.9583247985E-01, 8.9087291298E-01],
	[4.1940000000E+04, 1.0261664150E+01, 3.1249900268E+00, 1.4315362493E+00, 8.9605626484E-01, 8.9089539706E-01],
	[4.1945000000E+04, 1.0263711148E+01, 3.1250011465E+00, 1.4320653229E+00, 8.9628005518E-01, 8.9091787673E-01],
	[4.1950000000E+04, 1.0265758311E+01, 3.1250122648E+00, 1.4325945289E+00, 8.9650385087E-01, 8.9094035198E-01],
	[4.1955000000E+04, 1.0267805638E+01, 3.1250233819E+00, 1.4331238673E+00, 8.9672765190E-01, 8.9096282283E-01],
	[4.1960000000E+04, 1.0269853129E+01, 3.1250344977E+00, 1.4336533380E+00, 8.9695145825E-01, 8.9098528926E-01],
	[4.1965000000E+04, 1.0271900784E+01, 3.1250456122E+00, 1.4341829412E+00, 8.9717526991E-01, 8.9100775128E-01],
	[4.1970000000E+04, 1.0273948604E+01, 3.1250567254E+00, 1.4347126768E+00, 8.9739908687E-01, 8.9103020889E-01],
	[4.1975000000E+04, 1.0275996588E+01, 3.1250678373E+00, 1.4352425448E+00, 8.9762290912E-01, 8.9105266209E-01],
	[4.1980000000E+04, 1.0278044736E+01, 3.1250789479E+00, 1.4357725452E+00, 8.9784673664E-01, 8.9107511088E-01],
	[4.1985000000E+04, 1.0280093048E+01, 3.1250900573E+00, 1.4363026782E+00, 8.9807056943E-01, 8.9109755526E-01],
	[4.1990000000E+04, 1.0282141524E+01, 3.1251011654E+00, 1.4368329436E+00, 8.9829440747E-01, 8.9111999523E-01],
	[4.1995000000E+04, 1.0284190165E+01, 3.1251122722E+00, 1.4373633416E+00, 8.9851825074E-01, 8.9114243080E-01],
	[4.2000000000E+04, 1.0286238970E+01, 3.1251233777E+00, 1.4378938720E+00, 8.9874209925E-01, 8.9116486197E-01],
	[4.2005000000E+04, 1.0288287939E+01, 3.1251344819E+00, 1.4384245351E+00, 8.9896595298E-01, 8.9118728873E-01],
	[4.2010000000E+04, 1.0290337073E+01, 3.1251455849E+00, 1.4389553306E+00, 8.9918981190E-01, 8.9120971108E-01],
	[4.2015000000E+04, 1.0292386370E+01, 3.1251566865E+00, 1.4394862588E+00, 8.9941367602E-01, 8.9123212904E-01],
	[4.2020000000E+04, 1.0294435832E+01, 3.1251677869E+00, 1.4400173195E+00, 8.9963754533E-01, 8.9125454259E-01],
	[4.2025000000E+04, 1.0296485458E+01, 3.1251788860E+00, 1.4405485129E+00, 8.9986141980E-01, 8.9127695173E-01],
	[4.2030000000E+04, 1.0298535248E+01, 3.1251899838E+00, 1.4410798389E+00, 9.0008529943E-01, 8.9129935648E-01],
	[4.2035000000E+04, 1.0300585202E+01, 3.1252010804E+00, 1.4416112975E+00, 9.0030918420E-01, 8.9132175683E-01],
	[4.2040000000E+04, 1.0302635320E+01, 3.1252121756E+00, 1.4421428888E+00, 9.0053307410E-01, 8.9134415278E-01],
	[4.2045000000E+04, 1.0304685603E+01, 3.1252232696E+00, 1.4426746128E+00, 9.0075696913E-01, 8.9136654433E-01],
	[4.2050000000E+04, 1.0306736049E+01, 3.1252343623E+00, 1.4432064695E+00, 9.0098086927E-01, 8.9138893148E-01],
	[4.2055000000E+04, 1.0308786660E+01, 3.1252454537E+00, 1.4437384589E+00, 9.0120477451E-01, 8.9141131424E-01],
	[4.2060000000E+04, 1.0310837435E+01, 3.1252565439E+00, 1.4442705811E+00, 9.0142868483E-01, 8.9143369260E-01],
	[4.2065000000E+04, 1.0312888374E+01, 3.1252676327E+00, 1.4448028360E+00, 9.0165260022E-01, 8.9145606656E-01],
	[4.2070000000E+04, 1.0314939477E+01, 3.1252787203E+00, 1.4453352236E+00, 9.0187652068E-01, 8.9147843613E-01],
	[4.2075000000E+04, 1.0316990744E+01, 3.1252898066E+00, 1.4458677441E+00, 9.0210044619E-01, 8.9150080131E-01],
	[4.2080000000E+04, 1.0319042176E+01, 3.1253008916E+00, 1.4464003973E+00, 9.0232437674E-01, 8.9152316209E-01],
	[4.2085000000E+04, 1.0321093771E+01, 3.1253119754E+00, 1.4469331834E+00, 9.0254831232E-01, 8.9154551849E-01],
	[4.2090000000E+04, 1.0323145531E+01, 3.1253230578E+00, 1.4474661023E+00, 9.0277225291E-01, 8.9156787049E-01],
	[4.2095000000E+04, 1.0325197454E+01, 3.1253341390E+00, 1.4479991541E+00, 9.0299619850E-01, 8.9159021810E-01],
	[4.2100000000E+04, 1.0327249542E+01, 3.1253452190E+00, 1.4485323387E+00, 9.0322014908E-01, 8.9161256132E-01],
	[4.2105000000E+04, 1.0329301794E+01, 3.1253562976E+00, 1.4490656562E+00, 9.0344410465E-01, 8.9163490015E-01],
	[4.2110000000E+04, 1.0331354209E+01, 3.1253673750E+00, 1.4495991067E+00, 9.0366806518E-01, 8.9165723459E-01],
	[4.2115000000E+04, 1.0333406789E+01, 3.1253784510E+00, 1.4501326900E+00, 9.0389203067E-01, 8.9167956465E-01],
	[4.2120000000E+04, 1.0335459533E+01, 3.1253895259E+00, 1.4506664063E+00, 9.0411600110E-01, 8.9170189032E-01],
	[4.2125000000E+04, 1.0337512441E+01, 3.1254005994E+00, 1.4512002556E+00, 9.0433997647E-01, 8.9172421161E-01],
	[4.2130000000E+04, 1.0339565513E+01, 3.1254116717E+00, 1.4517342378E+00, 9.0456395676E-01, 8.9174652850E-01],
	[4.2135000000E+04, 1.0341618749E+01, 3.1254227426E+00, 1.4522683531E+00, 9.0478794195E-01, 8.9176884102E-01],
	[4.2140000000E+04, 1.0343672149E+01, 3.1254338124E+00, 1.4528026013E+00, 9.0501193204E-01, 8.9179114915E-01],
	[4.2145000000E+04, 1.0345725713E+01, 3.1254448808E+00, 1.4533369826E+00, 9.0523592702E-01, 8.9181345290E-01],
	[4.2150000000E+04, 1.0347779441E+01, 3.1254559480E+00, 1.4538714969E+00, 9.0545992687E-01, 8.9183575227E-01],
	[4.2155000000E+04, 1.0349833333E+01, 3.1254670139E+00, 1.4544061443E+00, 9.0568393159E-01, 8.9185804726E-01],
	[4.2160000000E+04, 1.0351887389E+01, 3.1254780785E+00, 1.4549409247E+00, 9.0590794115E-01, 8.9188033787E-01],
	[4.2165000000E+04, 1.0353941609E+01, 3.1254891418E+00, 1.4554758383E+00, 9.0613195555E-01, 8.9190262409E-01],
	[4.2170000000E+04, 1.0355995993E+01, 3.1255002039E+00, 1.4560108849E+00, 9.0635597478E-01, 8.9192490594E-01],
	[4.2175000000E+04, 1.0358050542E+01, 3.1255112647E+00, 1.4565460647E+00, 9.0657999882E-01, 8.9194718342E-01],
	[4.2180000000E+04, 1.0360105254E+01, 3.1255223242E+00, 1.4570813777E+00, 9.0680402766E-01, 8.9196945651E-01],
	[4.2185000000E+04, 1.0362160129E+01, 3.1255333825E+00, 1.4576168238E+00, 9.0702806130E-01, 8.9199172523E-01],
	[4.2190000000E+04, 1.0364215169E+01, 3.1255444395E+00, 1.4581524031E+00, 9.0725209971E-01, 8.9201398957E-01],
	[4.2195000000E+04, 1.0366270373E+01, 3.1255554952E+00, 1.4586881156E+00, 9.0747614290E-01, 8.9203624954E-01],
	[4.2200000000E+04, 1.0368325741E+01, 3.1255665496E+00, 1.4592239614E+00, 9.0770019083E-01, 8.9205850514E-01],
	[4.2205000000E+04, 1.0370381273E+01, 3.1255776028E+00, 1.4597599403E+00, 9.0792424352E-01, 8.9208075636E-01],
	[4.2210000000E+04, 1.0372436969E+01, 3.1255886547E+00, 1.4602960525E+00, 9.0814830093E-01, 8.9210300321E-01],
	[4.2215000000E+04, 1.0374492828E+01, 3.1255997053E+00, 1.4608322980E+00, 9.0837236307E-01, 8.9212524569E-01],
	[4.2220000000E+04, 1.0376548852E+01, 3.1256107547E+00, 1.4613686768E+00, 9.0859642991E-01, 8.9214748380E-01],
	[4.2225000000E+04, 1.0378605039E+01, 3.1256218028E+00, 1.4619051889E+00, 9.0882050145E-01, 8.9216971753E-01],
	[4.2230000000E+04, 1.0380661391E+01, 3.1256328496E+00, 1.4624418343E+00, 9.0904457767E-01, 8.9219194690E-01],
	[4.2235000000E+04, 1.0382717906E+01, 3.1256438952E+00, 1.4629786130E+00, 9.0926865857E-01, 8.9221417190E-01],
	[4.2240000000E+04, 1.0384774585E+01, 3.1256549394E+00, 1.4635155251E+00, 9.0949274413E-01, 8.9223639254E-01],
	[4.2245000000E+04, 1.0386831428E+01, 3.1256659825E+00, 1.4640525706E+00, 9.0971683434E-01, 8.9225860881E-01],
	[4.2250000000E+04, 1.0388888435E+01, 3.1256770242E+00, 1.4645897494E+00, 9.0994092919E-01, 8.9228082071E-01],
	[4.2255000000E+04, 1.0390945606E+01, 3.1256880647E+00, 1.4651270617E+00, 9.1016502866E-01, 8.9230302824E-01],
	[4.2260000000E+04, 1.0393002941E+01, 3.1256991039E+00, 1.4656645074E+00, 9.1038913275E-01, 8.9232523142E-01],
	[4.2265000000E+04, 1.0395060440E+01, 3.1257101418E+00, 1.4662020865E+00, 9.1061324145E-01, 8.9234743023E-01],
	[4.2270000000E+04, 1.0397118102E+01, 3.1257211785E+00, 1.4667397991E+00, 9.1083735473E-01, 8.9236962467E-01],
	[4.2275000000E+04, 1.0399175928E+01, 3.1257322139E+00, 1.4672776452E+00, 9.1106147259E-01, 8.9239181476E-01],
	[4.2280000000E+04, 1.0401233918E+01, 3.1257432481E+00, 1.4678156248E+00, 9.1128559502E-01, 8.9241400048E-01],
	[4.2285000000E+04, 1.0403292072E+01, 3.1257542810E+00, 1.4683537379E+00, 9.1150972201E-01, 8.9243618184E-01],
	[4.2290000000E+04, 1.0405350390E+01, 3.1257653126E+00, 1.4688919845E+00, 9.1173385354E-01, 8.9245835885E-01],
	[4.2295000000E+04, 1.0407408872E+01, 3.1257763429E+00, 1.4694303647E+00, 9.1195798960E-01, 8.9248053149E-01],
	[4.2300000000E+04, 1.0409467517E+01, 3.1257873720E+00, 1.4699688784E+00, 9.1218213018E-01, 8.9250269978E-01],
	[4.2305000000E+04, 1.0411526327E+01, 3.1257983999E+00, 1.4705075257E+00, 9.1240627527E-01, 8.9252486371E-01],
	[4.2310000000E+04, 1.0413585300E+01, 3.1258094264E+00, 1.4710463066E+00, 9.1263042486E-01, 8.9254702328E-01],
	[4.2315000000E+04, 1.0415644437E+01, 3.1258204517E+00, 1.4715852212E+00, 9.1285457894E-01, 8.9256917850E-01],
	[4.2320000000E+04, 1.0417703737E+01, 3.1258314757E+00, 1.4721242693E+00, 9.1307873749E-01, 8.9259132937E-01],
	[4.2325000000E+04, 1.0419763202E+01, 3.1258424985E+00, 1.4726634512E+00, 9.1330290050E-01, 8.9261347588E-01],
	[4.2330000000E+04, 1.0421822830E+01, 3.1258535200E+00, 1.4732027666E+00, 9.1352706796E-01, 8.9263561803E-01],
	[4.2335000000E+04, 1.0423882622E+01, 3.1258645402E+00, 1.4737422158E+00, 9.1375123986E-01, 8.9265775584E-01],
	[4.2340000000E+04, 1.0425942578E+01, 3.1258755592E+00, 1.4742817987E+00, 9.1397541618E-01, 8.9267988929E-01],
	[4.2345000000E+04, 1.0428002698E+01, 3.1258865769E+00, 1.4748215153E+00, 9.1419959692E-01, 8.9270201839E-01],
	[4.2350000000E+04, 1.0430062981E+01, 3.1258975934E+00, 1.4753613656E+00, 9.1442378207E-01, 8.9272414315E-01],
	[4.2355000000E+04, 1.0432123428E+01, 3.1259086086E+00, 1.4759013497E+00, 9.1464797161E-01, 8.9274626355E-01],
	[4.2360000000E+04, 1.0434184039E+01, 3.1259196225E+00, 1.4764414676E+00, 9.1487216552E-01, 8.9276837960E-01],
	[4.2365000000E+04, 1.0436244814E+01, 3.1259306352E+00, 1.4769817192E+00, 9.1509636381E-01, 8.9279049131E-01],
	[4.2370000000E+04, 1.0438305752E+01, 3.1259416466E+00, 1.4775221047E+00, 9.1532056645E-01, 8.9281259867E-01],
	[4.2375000000E+04, 1.0440366854E+01, 3.1259526567E+00, 1.4780626240E+00, 9.1554477344E-01, 8.9283470169E-01],
	[4.2380000000E+04, 1.0442428120E+01, 3.1259636656E+00, 1.4786032771E+00, 9.1576898476E-01, 8.9285680036E-01],
	[4.2385000000E+04, 1.0444489549E+01, 3.1259746732E+00, 1.4791440641E+00, 9.1599320040E-01, 8.9287889468E-01],
	[4.2390000000E+04, 1.0446551142E+01, 3.1259856796E+00, 1.4796849850E+00, 9.1621742035E-01, 8.9290098466E-01],
	[4.2395000000E+04, 1.0448612899E+01, 3.1259966847E+00, 1.4802260397E+00, 9.1644164460E-01, 8.9292307030E-01],
	[4.2400000000E+04, 1.0450674820E+01, 3.1260076886E+00, 1.4807672284E+00, 9.1666587314E-01, 8.9294515160E-01],
	[4.2405000000E+04, 1.0452736904E+01, 3.1260186912E+00, 1.4813085510E+00, 9.1689010595E-01, 8.9296722856E-01],
	[4.2410000000E+04, 1.0454799152E+01, 3.1260296925E+00, 1.4818500075E+00, 9.1711434303E-01, 8.9298930117E-01],
	[4.2415000000E+04, 1.0456861564E+01, 3.1260406926E+00, 1.4823915980E+00, 9.1733858435E-01, 8.9301136945E-01],
	[4.2420000000E+04, 1.0458924139E+01, 3.1260516914E+00, 1.4829333225E+00, 9.1756282992E-01, 8.9303343338E-01],
	[4.2425000000E+04, 1.0460986878E+01, 3.1260626889E+00, 1.4834751810E+00, 9.1778707971E-01, 8.9305549298E-01],
	[4.2430000000E+04, 1.0463049781E+01, 3.1260736852E+00, 1.4840171735E+00, 9.1801133373E-01, 8.9307754825E-01],
	[4.2435000000E+04, 1.0465112847E+01, 3.1260846803E+00, 1.4845593000E+00, 9.1823559194E-01, 8.9309959917E-01],
	[4.2440000000E+04, 1.0467176077E+01, 3.1260956741E+00, 1.4851015606E+00, 9.1845985435E-01, 8.9312164576E-01],
	[4.2445000000E+04, 1.0469239470E+01, 3.1261066666E+00, 1.4856439553E+00, 9.1868412094E-01, 8.9314368802E-01],
	[4.2450000000E+04, 1.0471303028E+01, 3.1261176579E+00, 1.4861864840E+00, 9.1890839170E-01, 8.9316572594E-01],
	[4.2455000000E+04, 1.0473366748E+01, 3.1261286479E+00, 1.4867291468E+00, 9.1913266662E-01, 8.9318775953E-01],
	[4.2460000000E+04, 1.0475430633E+01, 3.1261396366E+00, 1.4872719438E+00, 9.1935694568E-01, 8.9320978878E-01],
	[4.2465000000E+04, 1.0477494681E+01, 3.1261506242E+00, 1.4878148749E+00, 9.1958122888E-01, 8.9323181371E-01],
	[4.2470000000E+04, 1.0479558893E+01, 3.1261616104E+00, 1.4883579401E+00, 9.1980551620E-01, 8.9325383430E-01],
	[4.2475000000E+04, 1.0481623268E+01, 3.1261725954E+00, 1.4889011395E+00, 9.2002980764E-01, 8.9327585056E-01],
	[4.2480000000E+04, 1.0483687807E+01, 3.1261835791E+00, 1.4894444731E+00, 9.2025410317E-01, 8.9329786250E-01],
	[4.2485000000E+04, 1.0485752509E+01, 3.1261945616E+00, 1.4899879409E+00, 9.2047840280E-01, 8.9331987010E-01],
	[4.2490000000E+04, 1.0487817375E+01, 3.1262055429E+00, 1.4905315430E+00, 9.2070270649E-01, 8.9334187338E-01],
	[4.2495000000E+04, 1.0489882405E+01, 3.1262165229E+00, 1.4910752792E+00, 9.2092701426E-01, 8.9336387233E-01],
	[4.2500000000E+04, 1.0491949305E+01, 3.1262279368E+00, 1.4916191498E+00, 9.2115137702E-01, 8.9338586695E-01],
	[4.2505000000E+04, 1.0494019866E+01, 3.1262402410E+00, 1.4921631546E+00, 9.2137584826E-01, 8.9340785725E-01],
	[4.2510000000E+04, 1.0496090593E+01, 3.1262525438E+00, 1.4927072937E+00, 9.2160032365E-01, 8.9342984323E-01],
	[4.2515000000E+04, 1.0498161484E+01, 3.1262648452E+00, 1.4932515671E+00, 9.2182480317E-01, 8.9345182488E-01],
	[4.2520000000E+04, 1.0500232540E+01, 3.1262771452E+00, 1.4937959748E+00, 9.2204928682E-01, 8.9347380221E-01],
	[4.2525000000E+04, 1.0502303762E+01, 3.1262894438E+00, 1.4943405169E+00, 9.2227377457E-01, 8.9349577521E-01],
	[4.2530000000E+04, 1.0504375148E+01, 3.1263017410E+00, 1.4948851933E+00, 9.2249826643E-01, 8.9351774390E-01],
	[4.2535000000E+04, 1.0506446699E+01, 3.1263140368E+00, 1.4954300041E+00, 9.2272276237E-01, 8.9353970826E-01],
	[4.2540000000E+04, 1.0508518415E+01, 3.1263263312E+00, 1.4959749493E+00, 9.2294726240E-01, 8.9356166831E-01],
	[4.2545000000E+04, 1.0510590296E+01, 3.1263386242E+00, 1.4965200290E+00, 9.2317176648E-01, 8.9358362403E-01],
	[4.2550000000E+04, 1.0512662342E+01, 3.1263509159E+00, 1.4970652430E+00, 9.2339627462E-01, 8.9360557544E-01],
	[4.2555000000E+04, 1.0514734553E+01, 3.1263632061E+00, 1.4976105915E+00, 9.2362078681E-01, 8.9362752253E-01],
	[4.2560000000E+04, 1.0516806929E+01, 3.1263754949E+00, 1.4981560745E+00, 9.2384530302E-01, 8.9364946530E-01],
	[4.2565000000E+04, 1.0518879470E+01, 3.1263877823E+00, 1.4987016920E+00, 9.2406982325E-01, 8.9367140376E-01],
	[4.2570000000E+04, 1.0520952176E+01, 3.1264000684E+00, 1.4992474439E+00, 9.2429434749E-01, 8.9369333791E-01],
	[4.2575000000E+04, 1.0523025047E+01, 3.1264123530E+00, 1.4997933304E+00, 9.2451887572E-01, 8.9371526773E-01],
	[4.2580000000E+04, 1.0525098082E+01, 3.1264246362E+00, 1.5003393514E+00, 9.2474340794E-01, 8.9373719325E-01],
	[4.2585000000E+04, 1.0527171283E+01, 3.1264369181E+00, 1.5008855069E+00, 9.2496794413E-01, 8.9375911445E-01],
	[4.2590000000E+04, 1.0529244648E+01, 3.1264491986E+00, 1.5014317971E+00, 9.2519248428E-01, 8.9378103134E-01],
	[4.2595000000E+04, 1.0531318178E+01, 3.1264614776E+00, 1.5019782218E+00, 9.2541702839E-01, 8.9380294392E-01],
	[4.2600000000E+04, 1.0533391874E+01, 3.1264737553E+00, 1.5025247811E+00, 9.2564157642E-01, 8.9382485219E-01],
	[4.2605000000E+04, 1.0535465734E+01, 3.1264860316E+00, 1.5030714750E+00, 9.2586612839E-01, 8.9384675615E-01],
	[4.2610000000E+04, 1.0537539759E+01, 3.1264983065E+00, 1.5036183036E+00, 9.2609068427E-01, 8.9386865581E-01],
	[4.2615000000E+04, 1.0539613948E+01, 3.1265105799E+00, 1.5041652668E+00, 9.2631524405E-01, 8.9389055115E-01],
	[4.2620000000E+04, 1.0541688303E+01, 3.1265228521E+00, 1.5047123648E+00, 9.2653980773E-01, 8.9391244219E-01],
	[4.2625000000E+04, 1.0543762823E+01, 3.1265351228E+00, 1.5052595974E+00, 9.2676437528E-01, 8.9393432892E-01],
	[4.2630000000E+04, 1.0545837507E+01, 3.1265473921E+00, 1.5058069647E+00, 9.2698894670E-01, 8.9395621134E-01],
	[4.2635000000E+04, 1.0547912356E+01, 3.1265596600E+00, 1.5063544667E+00, 9.2721352198E-01, 8.9397808946E-01],
	[4.2640000000E+04, 1.0549987370E+01, 3.1265719265E+00, 1.5069021035E+00, 9.2743810110E-01, 8.9399996328E-01],
	[4.2645000000E+04, 1.0552062549E+01, 3.1265841917E+00, 1.5074498750E+00, 9.2766268406E-01, 8.9402183279E-01],
	[4.2650000000E+04, 1.0554137893E+01, 3.1265964555E+00, 1.5079977813E+00, 9.2788727084E-01, 8.9404369801E-01],
	[4.2655000000E+04, 1.0556213401E+01, 3.1266087178E+00, 1.5085458224E+00, 9.2811186143E-01, 8.9406555892E-01],
	[4.2660000000E+04, 1.0558289074E+01, 3.1266209788E+00, 1.5090939983E+00, 9.2833645582E-01, 8.9408741553E-01],
	[4.2665000000E+04, 1.0560364913E+01, 3.1266332384E+00, 1.5096423091E+00, 9.2856105400E-01, 8.9410926784E-01],
	[4.2670000000E+04, 1.0562440915E+01, 3.1266454966E+00, 1.5101907547E+00, 9.2878565595E-01, 8.9413111585E-01],
	[4.2675000000E+04, 1.0564517083E+01, 3.1266577534E+00, 1.5107393351E+00, 9.2901026167E-01, 8.9415295956E-01],
	[4.2680000000E+04, 1.0566593416E+01, 3.1266700088E+00, 1.5112880505E+00, 9.2923487114E-01, 8.9417479897E-01],
	[4.2685000000E+04, 1.0568669913E+01, 3.1266822629E+00, 1.5118369007E+00, 9.2945948435E-01, 8.9419663409E-01],
	[4.2690000000E+04, 1.0570746575E+01, 3.1266945155E+00, 1.5123858858E+00, 9.2968410129E-01, 8.9421846491E-01],
	[4.2695000000E+04, 1.0572823402E+01, 3.1267067668E+00, 1.5129350059E+00, 9.2990872195E-01, 8.9424029144E-01],
	[4.2700000000E+04, 1.0574900393E+01, 3.1267190167E+00, 1.5134842610E+00, 9.3013334631E-01, 8.9426211367E-01],
	[4.2705000000E+04, 1.0576977549E+01, 3.1267312652E+00, 1.5140336510E+00, 9.3035797438E-01, 8.9428393161E-01],
	[4.2710000000E+04, 1.0579054870E+01, 3.1267435123E+00, 1.5145831760E+00, 9.3058260612E-01, 8.9430574526E-01],
	[4.2715000000E+04, 1.0581132356E+01, 3.1267557580E+00, 1.5151328359E+00, 9.3080724154E-01, 8.9432755461E-01],
	[4.2720000000E+04, 1.0583210007E+01, 3.1267680023E+00, 1.5156826310E+00, 9.3103188061E-01, 8.9434935968E-01],
	[4.2725000000E+04, 1.0585287822E+01, 3.1267802453E+00, 1.5162325610E+00, 9.3125652334E-01, 8.9437116045E-01],
	[4.2730000000E+04, 1.0587365802E+01, 3.1267924868E+00, 1.5167826261E+00, 9.3148116970E-01, 8.9439295693E-01],
	[4.2735000000E+04, 1.0589443947E+01, 3.1268047270E+00, 1.5173328263E+00, 9.3170581969E-01, 8.9441474913E-01],
	[4.2740000000E+04, 1.0591522256E+01, 3.1268169658E+00, 1.5178831615E+00, 9.3193047330E-01, 8.9443653704E-01],
	[4.2745000000E+04, 1.0593600730E+01, 3.1268292032E+00, 1.5184336319E+00, 9.3215513050E-01, 8.9445832065E-01],
	[4.2750000000E+04, 1.0595679369E+01, 3.1268414392E+00, 1.5189842374E+00, 9.3237979130E-01, 8.9448009999E-01],
	[4.2755000000E+04, 1.0597758172E+01, 3.1268536739E+00, 1.5195349780E+00, 9.3260445568E-01, 8.9450187504E-01],
	[4.2760000000E+04, 1.0599837140E+01, 3.1268659071E+00, 1.5200858538E+00, 9.3282912363E-01, 8.9452364580E-01],
	[4.2765000000E+04, 1.0601916273E+01, 3.1268781390E+00, 1.5206368648E+00, 9.3305379513E-01, 8.9454541228E-01],
	[4.2770000000E+04, 1.0603995571E+01, 3.1268903695E+00, 1.5211880110E+00, 9.3327847018E-01, 8.9456717447E-01],
	[4.2775000000E+04, 1.0606075033E+01, 3.1269025986E+00, 1.5217392923E+00, 9.3350314877E-01, 8.9458893239E-01],
	[4.2780000000E+04, 1.0608154660E+01, 3.1269148264E+00, 1.5222907089E+00, 9.3372783087E-01, 8.9461068602E-01],
	[4.2785000000E+04, 1.0610234451E+01, 3.1269270527E+00, 1.5228422608E+00, 9.3395251649E-01, 8.9463243537E-01],
	[4.2790000000E+04, 1.0612314407E+01, 3.1269392777E+00, 1.5233939479E+00, 9.3417720561E-01, 8.9465418044E-01],
	[4.2795000000E+04, 1.0614394528E+01, 3.1269515013E+00, 1.5239457703E+00, 9.3440189821E-01, 8.9467592123E-01],
	[4.2800000000E+04, 1.0616474814E+01, 3.1269637235E+00, 1.5244977280E+00, 9.3462659429E-01, 8.9469765775E-01],
	[4.2805000000E+04, 1.0618555264E+01, 3.1269759443E+00, 1.5250498210E+00, 9.3485129384E-01, 8.9471938998E-01],
	[4.2810000000E+04, 1.0620635878E+01, 3.1269881638E+00, 1.5256020493E+00, 9.3507599684E-01, 8.9474111794E-01],
	[4.2815000000E+04, 1.0622716658E+01, 3.1270003818E+00, 1.5261544130E+00, 9.3530070328E-01, 8.9476284162E-01],
	[4.2820000000E+04, 1.0624797601E+01, 3.1270125985E+00, 1.5267069120E+00, 9.3552541315E-01, 8.9478456103E-01],
	[4.2825000000E+04, 1.0626878710E+01, 3.1270248138E+00, 1.5272595464E+00, 9.3575012644E-01, 8.9480627616E-01],
	[4.2830000000E+04, 1.0628959983E+01, 3.1270370278E+00, 1.5278123163E+00, 9.3597484314E-01, 8.9482798702E-01],
	[4.2835000000E+04, 1.0631041421E+01, 3.1270492403E+00, 1.5283652215E+00, 9.3619956324E-01, 8.9484969361E-01],
	[4.2840000000E+04, 1.0633123023E+01, 3.1270614515E+00, 1.5289182622E+00, 9.3642428672E-01, 8.9487139592E-01],
	[4.2845000000E+04, 1.0635204790E+01, 3.1270736613E+00, 1.5294714384E+00, 9.3664901357E-01, 8.9489309396E-01],
	[4.2850000000E+04, 1.0637286721E+01, 3.1270858697E+00, 1.5300247500E+00, 9.3687374379E-01, 8.9491478774E-01],
	[4.2855000000E+04, 1.0639368817E+01, 3.1270980768E+00, 1.5305781971E+00, 9.3709847735E-01, 8.9493647724E-01],
	[4.2860000000E+04, 1.0641451078E+01, 3.1271102825E+00, 1.5311317797E+00, 9.3732321426E-01, 8.9495816247E-01],
	[4.2865000000E+04, 1.0643533503E+01, 3.1271224868E+00, 1.5316854978E+00, 9.3754795449E-01, 8.9497984344E-01],
	[4.2870000000E+04, 1.0645616092E+01, 3.1271346897E+00, 1.5322393514E+00, 9.3777269804E-01, 8.9500152014E-01],
	[4.2875000000E+04, 1.0647698847E+01, 3.1271468912E+00, 1.5327933407E+00, 9.3799744489E-01, 8.9502319257E-01],
	[4.2880000000E+04, 1.0649781765E+01, 3.1271590914E+00, 1.5333474655E+00, 9.3822219504E-01, 8.9504486074E-01],
	[4.2885000000E+04, 1.0651864848E+01, 3.1271712902E+00, 1.5339017258E+00, 9.3844694846E-01, 8.9506652464E-01],
	[4.2890000000E+04, 1.0653948096E+01, 3.1271834876E+00, 1.5344561218E+00, 9.3867170516E-01, 8.9508818427E-01],
	[4.2895000000E+04, 1.0656031508E+01, 3.1271956837E+00, 1.5350106535E+00, 9.3889646512E-01, 8.9510983965E-01],
	[4.2900000000E+04, 1.0658115085E+01, 3.1272078783E+00, 1.5355653207E+00, 9.3912122832E-01, 8.9513149076E-01],
	[4.2905000000E+04, 1.0660198827E+01, 3.1272200716E+00, 1.5361201237E+00, 9.3934599476E-01, 8.9515313761E-01],
	[4.2910000000E+04, 1.0662282732E+01, 3.1272322635E+00, 1.5366750623E+00, 9.3957076443E-01, 8.9517478020E-01],
	[4.2915000000E+04, 1.0664366803E+01, 3.1272444541E+00, 1.5372301366E+00, 9.3979553730E-01, 8.9519641852E-01],
	[4.2920000000E+04, 1.0666451037E+01, 3.1272566433E+00, 1.5377853466E+00, 9.4002031338E-01, 8.9521805259E-01],
	[4.2925000000E+04, 1.0668535437E+01, 3.1272688311E+00, 1.5383406923E+00, 9.4024509265E-01, 8.9523968240E-01],
	[4.2930000000E+04, 1.0670620000E+01, 3.1272810175E+00, 1.5388961738E+00, 9.4046987510E-01, 8.9526130796E-01],
	[4.2935000000E+04, 1.0672704729E+01, 3.1272932026E+00, 1.5394517911E+00, 9.4069466071E-01, 8.9528292925E-01],
	[4.2940000000E+04, 1.0674789621E+01, 3.1273053863E+00, 1.5400075441E+00, 9.4091944948E-01, 8.9530454629E-01],
	[4.2945000000E+04, 1.0676874678E+01, 3.1273175686E+00, 1.5405634329E+00, 9.4114424140E-01, 8.9532615907E-01],
	[4.2950000000E+04, 1.0678959900E+01, 3.1273297495E+00, 1.5411194576E+00, 9.4136903645E-01, 8.9534776760E-01],
	[4.2955000000E+04, 1.0681045286E+01, 3.1273419291E+00, 1.5416756181E+00, 9.4159383461E-01, 8.9536937188E-01],
	[4.2960000000E+04, 1.0683130836E+01, 3.1273541073E+00, 1.5422319144E+00, 9.4181863589E-01, 8.9539097190E-01],
	[4.2965000000E+04, 1.0685216551E+01, 3.1273662842E+00, 1.5427883466E+00, 9.4204344027E-01, 8.9541256767E-01],
	[4.2970000000E+04, 1.0687302430E+01, 3.1273784596E+00, 1.5433449147E+00, 9.4226824774E-01, 8.9543415919E-01],
	[4.2975000000E+04, 1.0689388474E+01, 3.1273906337E+00, 1.5439016187E+00, 9.4249305828E-01, 8.9545574646E-01],
	[4.2980000000E+04, 1.0691474682E+01, 3.1274028065E+00, 1.5444584587E+00, 9.4271787189E-01, 8.9547732947E-01],
	[4.2985000000E+04, 1.0693561055E+01, 3.1274149778E+00, 1.5450154345E+00, 9.4294268855E-01, 8.9549890824E-01],
	[4.2990000000E+04, 1.0695647592E+01, 3.1274271478E+00, 1.5455725464E+00, 9.4316750825E-01, 8.9552048276E-01],
	[4.2995000000E+04, 1.0697734293E+01, 3.1274393164E+00, 1.5461297941E+00, 9.4339233098E-01, 8.9554205304E-01],
	[4.3000000000E+04, 1.0699821159E+01, 3.1274514837E+00, 1.5466871779E+00, 9.4361715673E-01, 8.9556361906E-01],
	[4.3005000000E+04, 1.0701908189E+01, 3.1274636496E+00, 1.5472446977E+00, 9.4384198549E-01, 8.9558518084E-01],
	[4.3010000000E+04, 1.0703995383E+01, 3.1274758141E+00, 1.5478023535E+00, 9.4406681725E-01, 8.9560673838E-01],
	[4.3015000000E+04, 1.0706082742E+01, 3.1274879773E+00, 1.5483601454E+00, 9.4429165199E-01, 8.9562829167E-01],
	[4.3020000000E+04, 1.0708170265E+01, 3.1275001391E+00, 1.5489180733E+00, 9.4451648970E-01, 8.9564984072E-01],
	[4.3025000000E+04, 1.0710257953E+01, 3.1275122995E+00, 1.5494761373E+00, 9.4474133038E-01, 8.9567138552E-01],
	[4.3030000000E+04, 1.0712345805E+01, 3.1275244585E+00, 1.5500343374E+00, 9.4496617400E-01, 8.9569292608E-01],
	[4.3035000000E+04, 1.0714433821E+01, 3.1275366162E+00, 1.5505926736E+00, 9.4519102057E-01, 8.9571446240E-01],
	[4.3040000000E+04, 1.0716522001E+01, 3.1275487726E+00, 1.5511511459E+00, 9.4541587006E-01, 8.9573599449E-01],
	[4.3045000000E+04, 1.0718610346E+01, 3.1275609275E+00, 1.5517097544E+00, 9.4564072247E-01, 8.9575752233E-01],
	[4.3050000000E+04, 1.0720698855E+01, 3.1275730811E+00, 1.5522684990E+00, 9.4586557779E-01, 8.9577904593E-01],
	[4.3055000000E+04, 1.0722787529E+01, 3.1275852333E+00, 1.5528273798E+00, 9.4609043600E-01, 8.9580056529E-01],
	[4.3060000000E+04, 1.0724876367E+01, 3.1275973842E+00, 1.5533863969E+00, 9.4631529709E-01, 8.9582208042E-01],
	[4.3065000000E+04, 1.0726965369E+01, 3.1276095337E+00, 1.5539455501E+00, 9.4654016105E-01, 8.9584359131E-01],
	[4.3070000000E+04, 1.0729054536E+01, 3.1276216819E+00, 1.5545048396E+00, 9.4676502787E-01, 8.9586509797E-01],
	[4.3075000000E+04, 1.0731143866E+01, 3.1276338286E+00, 1.5550642653E+00, 9.4698989754E-01, 8.9588660039E-01],
	[4.3080000000E+04, 1.0733233361E+01, 3.1276459741E+00, 1.5556238273E+00, 9.4721477005E-01, 8.9590809858E-01],
	[4.3085000000E+04, 1.0735323021E+01, 3.1276581181E+00, 1.5561835255E+00, 9.4743964538E-01, 8.9592959253E-01],
	[4.3090000000E+04, 1.0737412844E+01, 3.1276702608E+00, 1.5567433601E+00, 9.4766452353E-01, 8.9595108225E-01],
	[4.3095000000E+04, 1.0739502832E+01, 3.1276824021E+00, 1.5573033310E+00, 9.4788940448E-01, 8.9597256774E-01],
	[4.3100000000E+04, 1.0741592984E+01, 3.1276945421E+00, 1.5578634382E+00, 9.4811428823E-01, 8.9599404900E-01],
	[4.3105000000E+04, 1.0743683301E+01, 3.1277066807E+00, 1.5584236818E+00, 9.4833917475E-01, 8.9601552603E-01],
	[4.3110000000E+04, 1.0745773781E+01, 3.1277188180E+00, 1.5589840618E+00, 9.4856406404E-01, 8.9603699883E-01],
	[4.3115000000E+04, 1.0747864426E+01, 3.1277309538E+00, 1.5595445781E+00, 9.4878895609E-01, 8.9605846740E-01],
	[4.3120000000E+04, 1.0749955235E+01, 3.1277430884E+00, 1.5601052309E+00, 9.4901385089E-01, 8.9607993174E-01],
	[4.3125000000E+04, 1.0752046209E+01, 3.1277552215E+00, 1.5606660201E+00, 9.4923874842E-01, 8.9610139186E-01],
	[4.3130000000E+04, 1.0754137346E+01, 3.1277673533E+00, 1.5612269457E+00, 9.4946364867E-01, 8.9612284775E-01],
	[4.3135000000E+04, 1.0756228648E+01, 3.1277794838E+00, 1.5617880078E+00, 9.4968855164E-01, 8.9614429941E-01],
	[4.3140000000E+04, 1.0758320114E+01, 3.1277916129E+00, 1.5623492063E+00, 9.4991345731E-01, 8.9616574685E-01],
	[4.3145000000E+04, 1.0760411744E+01, 3.1278037406E+00, 1.5629105414E+00, 9.5013836566E-01, 8.9618719007E-01],
	[4.3150000000E+04, 1.0762503539E+01, 3.1278158670E+00, 1.5634720129E+00, 9.5036327670E-01, 8.9620862906E-01],
	[4.3155000000E+04, 1.0764595497E+01, 3.1278279920E+00, 1.5640336210E+00, 9.5058819040E-01, 8.9623006383E-01],
	[4.3160000000E+04, 1.0766687620E+01, 3.1278401157E+00, 1.5645953656E+00, 9.5081310676E-01, 8.9625149438E-01],
	[4.3165000000E+04, 1.0768779907E+01, 3.1278522379E+00, 1.5651572468E+00, 9.5103802576E-01, 8.9627292071E-01],
	[4.3170000000E+04, 1.0770872358E+01, 3.1278643589E+00, 1.5657192646E+00, 9.5126294740E-01, 8.9629434282E-01],
	[4.3175000000E+04, 1.0772964974E+01, 3.1278764785E+00, 1.5662814190E+00, 9.5148787166E-01, 8.9631576071E-01],
	[4.3180000000E+04, 1.0775057753E+01, 3.1278885967E+00, 1.5668437100E+00, 9.5171279852E-01, 8.9633717439E-01],
	[4.3185000000E+04, 1.0777153325E+01, 3.1279013567E+00, 1.5674061376E+00, 9.5193780806E-01, 8.9635858384E-01],
	[4.3190000000E+04, 1.0779251745E+01, 3.1279147716E+00, 1.5679687018E+00, 9.5216290201E-01, 8.9637998908E-01],
	[4.3195000000E+04, 1.0781350331E+01, 3.1279281851E+00, 1.5685314028E+00, 9.5238799864E-01, 8.9640139010E-01],
	[4.3200000000E+04, 1.0783449082E+01, 3.1279415970E+00, 1.5690942404E+00, 9.5261309796E-01, 8.9642278691E-01],
	[4.3205000000E+04, 1.0785547999E+01, 3.1279550075E+00, 1.5696572147E+00, 9.5283819996E-01, 8.9644417951E-01],
	[4.3210000000E+04, 1.0787647081E+01, 3.1279684164E+00, 1.5702203258E+00, 9.5306330461E-01, 8.9646556789E-01],
	[4.3215000000E+04, 1.0789746329E+01, 3.1279818239E+00, 1.5707835735E+00, 9.5328841190E-01, 8.9648695205E-01],
	[4.3220000000E+04, 1.0791845742E+01, 3.1279952299E+00, 1.5713469581E+00, 9.5351352184E-01, 8.9650833201E-01],
	[4.3225000000E+04, 1.0793945321E+01, 3.1280086343E+00, 1.5719104794E+00, 9.5373863440E-01, 8.9652970776E-01],
	[4.3230000000E+04, 1.0796045066E+01, 3.1280220373E+00, 1.5724741375E+00, 9.5396374958E-01, 8.9655107929E-01],
	[4.3235000000E+04, 1.0798144976E+01, 3.1280354388E+00, 1.5730379323E+00, 9.5418886736E-01, 8.9657244662E-01],
	[4.3240000000E+04, 1.0800245052E+01, 3.1280488388E+00, 1.5736018641E+00, 9.5441398774E-01, 8.9659380973E-01],
	[4.3245000000E+04, 1.0802345293E+01, 3.1280622373E+00, 1.5741659326E+00, 9.5463911069E-01, 8.9661516864E-01],
	[4.3250000000E+04, 1.0804445700E+01, 3.1280756343E+00, 1.5747301380E+00, 9.5486423621E-01, 8.9663652334E-01],
	[4.3255000000E+04, 1.0806546272E+01, 3.1280890298E+00, 1.5752944803E+00, 9.5508936430E-01, 8.9665787384E-01],
	[4.3260000000E+04, 1.0808647010E+01, 3.1281024239E+00, 1.5758589595E+00, 9.5531449493E-01, 8.9667922013E-01],
	[4.3265000000E+04, 1.0810747913E+01, 3.1281158164E+00, 1.5764235756E+00, 9.5553962809E-01, 8.9670056221E-01],
	[4.3270000000E+04, 1.0812848982E+01, 3.1281292075E+00, 1.5769883286E+00, 9.5576476378E-01, 8.9672190009E-01],
	[4.3275000000E+04, 1.0814950216E+01, 3.1281425970E+00, 1.5775532186E+00, 9.5598990199E-01, 8.9674323377E-01],
	[4.3280000000E+04, 1.0817051616E+01, 3.1281559851E+00, 1.5781182455E+00, 9.5621504270E-01, 8.9676456325E-01],
	[4.3285000000E+04, 1.0819153181E+01, 3.1281693717E+00, 1.5786834094E+00, 9.5644018589E-01, 8.9678588852E-01],
	[4.3290000000E+04, 1.0821254912E+01, 3.1281827568E+00, 1.5792487103E+00, 9.5666533157E-01, 8.9680720959E-01],
	[4.3295000000E+04, 1.0823356808E+01, 3.1281961404E+00, 1.5798141482E+00, 9.5689047972E-01, 8.9682852647E-01],
	[4.3300000000E+04, 1.0825458870E+01, 3.1282095225E+00, 1.5803797232E+00, 9.5711563032E-01, 8.9684983914E-01],
	[4.3305000000E+04, 1.0827561097E+01, 3.1282229031E+00, 1.5809454352E+00, 9.5734078337E-01, 8.9687114762E-01],
	[4.3310000000E+04, 1.0829663490E+01, 3.1282362823E+00, 1.5815112842E+00, 9.5756593886E-01, 8.9689245190E-01],
	[4.3315000000E+04, 1.0831766048E+01, 3.1282496599E+00, 1.5820772704E+00, 9.5779109677E-01, 8.9691375198E-01],
	[4.3320000000E+04, 1.0833868771E+01, 3.1282630361E+00, 1.5826433936E+00, 9.5801625709E-01, 8.9693504786E-01],
	[4.3325000000E+04, 1.0835971660E+01, 3.1282764108E+00, 1.5832096540E+00, 9.5824141981E-01, 8.9695633955E-01],
	[4.3330000000E+04, 1.0838074715E+01, 3.1282897840E+00, 1.5837760515E+00, 9.5846658492E-01, 8.9697762705E-01],
	[4.3335000000E+04, 1.0840177934E+01, 3.1283031557E+00, 1.5843425861E+00, 9.5869175241E-01, 8.9699891035E-01],
	[4.3340000000E+04, 1.0842281320E+01, 3.1283165259E+00, 1.5849092579E+00, 9.5891692227E-01, 8.9702018946E-01],
	[4.3345000000E+04, 1.0844384870E+01, 3.1283298946E+00, 1.5854760669E+00, 9.5914209449E-01, 8.9704146438E-01],
	[4.3350000000E+04, 1.0846488586E+01, 3.1283432619E+00, 1.5860430131E+00, 9.5936726905E-01, 8.9706273510E-01],
	[4.3355000000E+04, 1.0848592468E+01, 3.1283566276E+00, 1.5866100966E+00, 9.5959244594E-01, 8.9708400164E-01],
	[4.3360000000E+04, 1.0850696515E+01, 3.1283699919E+00, 1.5871773172E+00, 9.5981762516E-01, 8.9710526399E-01],
	[4.3365000000E+04, 1.0852800727E+01, 3.1283833547E+00, 1.5877446752E+00, 9.6004280669E-01, 8.9712652214E-01],
	[4.3370000000E+04, 1.0854905105E+01, 3.1283967160E+00, 1.5883121704E+00, 9.6026799052E-01, 8.9714777611E-01],
	[4.3375000000E+04, 1.0857009648E+01, 3.1284100759E+00, 1.5888798029E+00, 9.6049317664E-01, 8.9716902589E-01],
	[4.3380000000E+04, 1.0859114356E+01, 3.1284234342E+00, 1.5894475727E+00, 9.6071836504E-01, 8.9719027149E-01],
	[4.3385000000E+04, 1.0861219230E+01, 3.1284367911E+00, 1.5900154798E+00, 9.6094355570E-01, 8.9721151290E-01],
	[4.3390000000E+04, 1.0863324269E+01, 3.1284501465E+00, 1.5905835243E+00, 9.6116874862E-01, 8.9723275012E-01],
	[4.3395000000E+04, 1.0865429473E+01, 3.1284635004E+00, 1.5911517061E+00, 9.6139394379E-01, 8.9725398316E-01],
	[4.3400000000E+04, 1.0867534843E+01, 3.1284768528E+00, 1.5917200253E+00, 9.6161914118E-01, 8.9727521202E-01],
	[4.3405000000E+04, 1.0869640378E+01, 3.1284902037E+00, 1.5922884819E+00, 9.6184434080E-01, 8.9729643669E-01],
	[4.3410000000E+04, 1.0871746079E+01, 3.1285035532E+00, 1.5928570759E+00, 9.6206954263E-01, 8.9731765719E-01],
	[4.3415000000E+04, 1.0873851945E+01, 3.1285169012E+00, 1.5934258074E+00, 9.6229474666E-01, 8.9733887350E-01],
	[4.3420000000E+04, 1.0875957976E+01, 3.1285302477E+00, 1.5939946763E+00, 9.6251995288E-01, 8.9736008563E-01],
	[4.3425000000E+04, 1.0878064172E+01, 3.1285435927E+00, 1.5945636826E+00, 9.6274516128E-01, 8.9738129358E-01],
	[4.3430000000E+04, 1.0880170534E+01, 3.1285569362E+00, 1.5951328265E+00, 9.6297037184E-01, 8.9740249736E-01],
	[4.3435000000E+04, 1.0882277061E+01, 3.1285702783E+00, 1.5957021078E+00, 9.6319558456E-01, 8.9742369695E-01],
	[4.3440000000E+04, 1.0884383754E+01, 3.1285836189E+00, 1.5962715267E+00, 9.6342079942E-01, 8.9744489237E-01],
	[4.3445000000E+04, 1.0886490611E+01, 3.1285969580E+00, 1.5968410831E+00, 9.6364601642E-01, 8.9746608361E-01],
	[4.3450000000E+04, 1.0888597634E+01, 3.1286102956E+00, 1.5974107770E+00, 9.6387123553E-01, 8.9748727068E-01],
	[4.3455000000E+04, 1.0890704822E+01, 3.1286236317E+00, 1.5979806085E+00, 9.6409645676E-01, 8.9750845357E-01],
	[4.3460000000E+04, 1.0892812176E+01, 3.1286369664E+00, 1.5985505776E+00, 9.6432168009E-01, 8.9752963229E-01],
	[4.3465000000E+04, 1.0894919695E+01, 3.1286502996E+00, 1.5991206844E+00, 9.6454690550E-01, 8.9755080684E-01],
	[4.3470000000E+04, 1.0897027379E+01, 3.1286636313E+00, 1.5996909287E+00, 9.6477213299E-01, 8.9757197721E-01],
	[4.3475000000E+04, 1.0899135228E+01, 3.1286769615E+00, 1.6002613106E+00, 9.6499736255E-01, 8.9759314341E-01],
	[4.3480000000E+04, 1.0901243243E+01, 3.1286902903E+00, 1.6008318303E+00, 9.6522259416E-01, 8.9761430544E-01],
	[4.3485000000E+04, 1.0903351423E+01, 3.1287036176E+00, 1.6014024876E+00, 9.6544782782E-01, 8.9763546330E-01],
	[4.3490000000E+04, 1.0905459768E+01, 3.1287169434E+00, 1.6019732825E+00, 9.6567306351E-01, 8.9765661700E-01],
	[4.3495000000E+04, 1.0907568278E+01, 3.1287302677E+00, 1.6025442152E+00, 9.6589830122E-01, 8.9767776652E-01],
	[4.3500000000E+04, 1.0909676953E+01, 3.1287435906E+00, 1.6031152857E+00, 9.6612354094E-01, 8.9769891188E-01],
	[4.3505000000E+04, 1.0911785794E+01, 3.1287569120E+00, 1.6036864938E+00, 9.6634878266E-01, 8.9772005307E-01],
	[4.3510000000E+04, 1.0913894800E+01, 3.1287702319E+00, 1.6042578397E+00, 9.6657402636E-01, 8.9774119009E-01],
	[4.3515000000E+04, 1.0916003971E+01, 3.1287835503E+00, 1.6048293234E+00, 9.6679927205E-01, 8.9776232295E-01],
	[4.3520000000E+04, 1.0918113308E+01, 3.1287968673E+00, 1.6054009449E+00, 9.6702451970E-01, 8.9778345164E-01],
	[4.3525000000E+04, 1.0920222809E+01, 3.1288101828E+00, 1.6059727042E+00, 9.6724976930E-01, 8.9780457617E-01],
	[4.3530000000E+04, 1.0922332476E+01, 3.1288234968E+00, 1.6065446014E+00, 9.6747502085E-01, 8.9782569654E-01],
	[4.3535000000E+04, 1.0924442308E+01, 3.1288368093E+00, 1.6071166363E+00, 9.6770027433E-01, 8.9784681275E-01],
	[4.3540000000E+04, 1.0926552305E+01, 3.1288501204E+00, 1.6076888092E+00, 9.6792552973E-01, 8.9786792479E-01],
	[4.3545000000E+04, 1.0928662467E+01, 3.1288634300E+00, 1.6082611199E+00, 9.6815078704E-01, 8.9788903268E-01],
	[4.3550000000E+04, 1.0930772795E+01, 3.1288767381E+00, 1.6088335685E+00, 9.6837604625E-01, 8.9791013640E-01],
	[4.3555000000E+04, 1.0932883287E+01, 3.1288900448E+00, 1.6094061551E+00, 9.6860130735E-01, 8.9793123597E-01],
	[4.3560000000E+04, 1.0934993945E+01, 3.1289033500E+00, 1.6099788795E+00, 9.6882657033E-01, 8.9795233137E-01],
	[4.3565000000E+04, 1.0937104768E+01, 3.1289166537E+00, 1.6105517420E+00, 9.6905183517E-01, 8.9797342262E-01],
	[4.3570000000E+04, 1.0939215756E+01, 3.1289299560E+00, 1.6111247424E+00, 9.6927710187E-01, 8.9799450972E-01],
	[4.3575000000E+04, 1.0941326909E+01, 3.1289432567E+00, 1.6116978807E+00, 9.6950237041E-01, 8.9801559266E-01],
	[4.3580000000E+04, 1.0943438228E+01, 3.1289565560E+00, 1.6122711571E+00, 9.6972764078E-01, 8.9803667144E-01],
	[4.3585000000E+04, 1.0945549711E+01, 3.1289698539E+00, 1.6128445715E+00, 9.6995291297E-01, 8.9805774607E-01],
	[4.3590000000E+04, 1.0947661360E+01, 3.1289831502E+00, 1.6134181240E+00, 9.7017818697E-01, 8.9807881654E-01],
	[4.3595000000E+04, 1.0949773173E+01, 3.1289964451E+00, 1.6139918145E+00, 9.7040346278E-01, 8.9809988287E-01],
	[4.3600000000E+04, 1.0951885152E+01, 3.1290097386E+00, 1.6145656430E+00, 9.7062874037E-01, 8.9812094504E-01],
	[4.3605000000E+04, 1.0953997296E+01, 3.1290230305E+00, 1.6151396097E+00, 9.7085401974E-01, 8.9814200306E-01],
	[4.3610000000E+04, 1.0956109605E+01, 3.1290363210E+00, 1.6157137145E+00, 9.7107930087E-01, 8.9816305693E-01],
	[4.3615000000E+04, 1.0958222079E+01, 3.1290496101E+00, 1.6162879573E+00, 9.7130458376E-01, 8.9818410665E-01],
	[4.3620000000E+04, 1.0960334718E+01, 3.1290628976E+00, 1.6168623384E+00, 9.7152986839E-01, 8.9820515222E-01],
	[4.3625000000E+04, 1.0962447522E+01, 3.1290761837E+00, 1.6174368576E+00, 9.7175515476E-01, 8.9822619365E-01],
	[4.3630000000E+04, 1.0964560492E+01, 3.1290894684E+00, 1.6180115149E+00, 9.7198044284E-01, 8.9824723093E-01],
	[4.3635000000E+04, 1.0966673626E+01, 3.1291027515E+00, 1.6185863105E+00, 9.7220573264E-01, 8.9826826406E-01],
	[4.3640000000E+04, 1.0968786925E+01, 3.1291160332E+00, 1.6191612443E+00, 9.7243102414E-01, 8.9828929304E-01],
	[4.3645000000E+04, 1.0970900390E+01, 3.1291293134E+00, 1.6197363163E+00, 9.7265631733E-01, 8.9831031789E-01],
	[4.3650000000E+04, 1.0973014019E+01, 3.1291425922E+00, 1.6203115265E+00, 9.7288161219E-01, 8.9833133858E-01],
	[4.3655000000E+04, 1.0975127814E+01, 3.1291558695E+00, 1.6208868750E+00, 9.7310690872E-01, 8.9835235514E-01],
	[4.3660000000E+04, 1.0977241774E+01, 3.1291691454E+00, 1.6214623618E+00, 9.7333220690E-01, 8.9837336755E-01],
	[4.3665000000E+04, 1.0979355898E+01, 3.1291824197E+00, 1.6220379869E+00, 9.7355750673E-01, 8.9839437582E-01],
	[4.3670000000E+04, 1.0981470188E+01, 3.1291956926E+00, 1.6226137503E+00, 9.7378280820E-01, 8.9841537995E-01],
	[4.3675000000E+04, 1.0983584642E+01, 3.1292089641E+00, 1.6231896520E+00, 9.7400811128E-01, 8.9843637994E-01],
	[4.3680000000E+04, 1.0985699262E+01, 3.1292222341E+00, 1.6237656921E+00, 9.7423341598E-01, 8.9845737579E-01],
	[4.3685000000E+04, 1.0987814047E+01, 3.1292355026E+00, 1.6243418706E+00, 9.7445872227E-01, 8.9847836751E-01],
	[4.3690000000E+04, 1.0989928996E+01, 3.1292487697E+00, 1.6249181874E+00, 9.7468403016E-01, 8.9849935508E-01],
	[4.3695000000E+04, 1.0992044111E+01, 3.1292620352E+00, 1.6254946427E+00, 9.7490933962E-01, 8.9852033852E-01],
	[4.3700000000E+04, 1.0994159391E+01, 3.1292752994E+00, 1.6260712363E+00, 9.7513465065E-01, 8.9854131782E-01],
	[4.3705000000E+04, 1.0996274835E+01, 3.1292885621E+00, 1.6266479684E+00, 9.7535996324E-01, 8.9856229299E-01],
	[4.3710000000E+04, 1.0998390445E+01, 3.1293018233E+00, 1.6272248390E+00, 9.7558527737E-01, 8.9858326403E-01],
	[4.3715000000E+04, 1.1000506220E+01, 3.1293150830E+00, 1.6278018480E+00, 9.7581059303E-01, 8.9860423093E-01],
	[4.3720000000E+04, 1.1002622159E+01, 3.1293283413E+00, 1.6283789955E+00, 9.7603591022E-01, 8.9862519369E-01],
	[4.3725000000E+04, 1.1004738264E+01, 3.1293415982E+00, 1.6289562815E+00, 9.7626122892E-01, 8.9864615233E-01],
	[4.3730000000E+04, 1.1006854533E+01, 3.1293548535E+00, 1.6295337061E+00, 9.7648654912E-01, 8.9866710683E-01],
	[4.3735000000E+04, 1.1008970967E+01, 3.1293681074E+00, 1.6301112692E+00, 9.7671187081E-01, 8.9868805720E-01],
	[4.3740000000E+04, 1.1011087567E+01, 3.1293813599E+00, 1.6306889708E+00, 9.7693719398E-01, 8.9870900345E-01],
	[4.3745000000E+04, 1.1013204331E+01, 3.1293946109E+00, 1.6312668110E+00, 9.7716251862E-01, 8.9872994556E-01],
	[4.3750000000E+04, 1.1015321260E+01, 3.1294078604E+00, 1.6318447898E+00, 9.7738784471E-01, 8.9875088355E-01],
	[4.3755000000E+04, 1.1017438354E+01, 3.1294211085E+00, 1.6324229073E+00, 9.7761317225E-01, 8.9877181741E-01],
	[4.3760000000E+04, 1.1019555613E+01, 3.1294343551E+00, 1.6330011633E+00, 9.7783850123E-01, 8.9879274714E-01],
	[4.3765000000E+04, 1.1021673037E+01, 3.1294476003E+00, 1.6335795580E+00, 9.7806383163E-01, 8.9881367275E-01],
	[4.3770000000E+04, 1.1023790626E+01, 3.1294608440E+00, 1.6341580914E+00, 9.7828916344E-01, 8.9883459423E-01],
	[4.3775000000E+04, 1.1025908380E+01, 3.1294740862E+00, 1.6347367634E+00, 9.7851449665E-01, 8.9885551159E-01],
	[4.3780000000E+04, 1.1028026298E+01, 3.1294873270E+00, 1.6353155741E+00, 9.7873983125E-01, 8.9887642483E-01],
	[4.3785000000E+04, 1.1030144382E+01, 3.1295005664E+00, 1.6358945236E+00, 9.7896516724E-01, 8.9889733394E-01],
	[4.3790000000E+04, 1.1032262630E+01, 3.1295138043E+00, 1.6364736118E+00, 9.7919050459E-01, 8.9891823893E-01],
	[4.3795000000E+04, 1.1034381043E+01, 3.1295270407E+00, 1.6370528387E+00, 9.7941584330E-01, 8.9893913980E-01],
	[4.3800000000E+04, 1.1036499621E+01, 3.1295402757E+00, 1.6376322044E+00, 9.7964118336E-01, 8.9896003655E-01],
	[4.3805000000E+04, 1.1038618364E+01, 3.1295535092E+00, 1.6382117089E+00, 9.7986652475E-01, 8.9898092918E-01],
	[4.3810000000E+04, 1.1040737272E+01, 3.1295667412E+00, 1.6387913522E+00, 9.8009186747E-01, 8.9900181769E-01],
	[4.3815000000E+04, 1.1042856345E+01, 3.1295799718E+00, 1.6393711343E+00, 9.8031721150E-01, 8.9902270209E-01],
	[4.3820000000E+04, 1.1044975582E+01, 3.1295932010E+00, 1.6399510552E+00, 9.8054255684E-01, 8.9904358236E-01],
	[4.3825000000E+04, 1.1047094985E+01, 3.1296064287E+00, 1.6405311150E+00, 9.8076790347E-01, 8.9906445852E-01],
	[4.3830000000E+04, 1.1049214552E+01, 3.1296196549E+00, 1.6411113137E+00, 9.8099325138E-01, 8.9908533057E-01],
	[4.3835000000E+04, 1.1051334284E+01, 3.1296328797E+00, 1.6416916513E+00, 9.8121860055E-01, 8.9910619850E-01],
	[4.3840000000E+04, 1.1053454181E+01, 3.1296461031E+00, 1.6422721277E+00, 9.8144395099E-01, 8.9912706232E-01],
	[4.3845000000E+04, 1.1055574242E+01, 3.1296593250E+00, 1.6428527431E+00, 9.8166930268E-01, 8.9914792202E-01],
	[4.3850000000E+04, 1.1057694469E+01, 3.1296725454E+00, 1.6434334974E+00, 9.8189465560E-01, 8.9916877761E-01],
	[4.3855000000E+04, 1.1059814860E+01, 3.1296857644E+00, 1.6440143907E+00, 9.8212000975E-01, 8.9918962909E-01],
	[4.3860000000E+04, 1.1061935416E+01, 3.1296989819E+00, 1.6445954230E+00, 9.8234536512E-01, 8.9921047646E-01],
	[4.3865000000E+04, 1.1064056137E+01, 3.1297121980E+00, 1.6451765942E+00, 9.8257072168E-01, 8.9923131972E-01],
	[4.3870000000E+04, 1.1066177022E+01, 3.1297254127E+00, 1.6457579045E+00, 9.8279607945E-01, 8.9925215887E-01],
	[4.3875000000E+04, 1.1068298073E+01, 3.1297386258E+00, 1.6463393538E+00, 9.8302143839E-01, 8.9927299391E-01],
	[4.3880000000E+04, 1.1070421775E+01, 3.1297524217E+00, 1.6469209421E+00, 9.8324687578E-01, 8.9929382484E-01],
	[4.3885000000E+04, 1.1072548577E+01, 3.1297669047E+00, 1.6475026695E+00, 9.8347240553E-01, 8.9931465167E-01],
	[4.3890000000E+04, 1.1074675544E+01, 3.1297813862E+00, 1.6480845360E+00, 9.8369793655E-01, 8.9933547439E-01],
	[4.3895000000E+04, 1.1076802678E+01, 3.1297958660E+00, 1.6486665416E+00, 9.8392346882E-01, 8.9935629301E-01],
	[4.3900000000E+04, 1.1078929978E+01, 3.1298103443E+00, 1.6492486863E+00, 9.8414900234E-01, 8.9937710752E-01],
	[4.3905000000E+04, 1.1081057444E+01, 3.1298248210E+00, 1.6498309701E+00, 9.8437453709E-01, 8.9939791793E-01],
	[4.3910000000E+04, 1.1083185077E+01, 3.1298392962E+00, 1.6504133931E+00, 9.8460007307E-01, 8.9941872424E-01],
	[4.3915000000E+04, 1.1085312875E+01, 3.1298537697E+00, 1.6509959552E+00, 9.8482561026E-01, 8.9943952644E-01],
	[4.3920000000E+04, 1.1087440840E+01, 3.1298682417E+00, 1.6515786565E+00, 9.8505114865E-01, 8.9946032454E-01],
	[4.3925000000E+04, 1.1089568971E+01, 3.1298827120E+00, 1.6521614970E+00, 9.8527668823E-01, 8.9948111854E-01],
	[4.3930000000E+04, 1.1091697268E+01, 3.1298971808E+00, 1.6527444768E+00, 9.8550222900E-01, 8.9950190844E-01],
	[4.3935000000E+04, 1.1093825732E+01, 3.1299116481E+00, 1.6533275958E+00, 9.8572777093E-01, 8.9952269425E-01],
	[4.3940000000E+04, 1.1095954361E+01, 3.1299261137E+00, 1.6539108540E+00, 9.8595331402E-01, 8.9954347595E-01],
	[4.3945000000E+04, 1.1098083157E+01, 3.1299405777E+00, 1.6544942515E+00, 9.8617885826E-01, 8.9956425356E-01],
	[4.3950000000E+04, 1.1100212119E+01, 3.1299550402E+00, 1.6550777883E+00, 9.8640440363E-01, 8.9958502707E-01],
	[4.3955000000E+04, 1.1102341246E+01, 3.1299695011E+00, 1.6556614644E+00, 9.8662995013E-01, 8.9960579649E-01],
	[4.3960000000E+04, 1.1104470541E+01, 3.1299839605E+00, 1.6562452798E+00, 9.8685549775E-01, 8.9962656181E-01],
	[4.3965000000E+04, 1.1106600001E+01, 3.1299984182E+00, 1.6568292345E+00, 9.8708104646E-01, 8.9964732303E-01],
	[4.3970000000E+04, 1.1108729627E+01, 3.1300128744E+00, 1.6574133287E+00, 9.8730659628E-01, 8.9966808016E-01],
	[4.3975000000E+04, 1.1110859419E+01, 3.1300273290E+00, 1.6579975621E+00, 9.8753214717E-01, 8.9968883320E-01],
	[4.3980000000E+04, 1.1112989378E+01, 3.1300417820E+00, 1.6585819350E+00, 9.8775769914E-01, 8.9970958215E-01],
	[4.3985000000E+04, 1.1115119503E+01, 3.1300562334E+00, 1.6591664473E+00, 9.8798325216E-01, 8.9973032701E-01],
	[4.3990000000E+04, 1.1117249793E+01, 3.1300706833E+00, 1.6597510990E+00, 9.8820880624E-01, 8.9975106778E-01],
	[4.3995000000E+04, 1.1119380250E+01, 3.1300851316E+00, 1.6603358902E+00, 9.8843436135E-01, 8.9977180445E-01],
	[4.4000000000E+04, 1.1121510873E+01, 3.1300995783E+00, 1.6609208208E+00, 9.8865991750E-01, 8.9979253704E-01],
	[4.4005000000E+04, 1.1123641662E+01, 3.1301140234E+00, 1.6615058909E+00, 9.8888547466E-01, 8.9981326554E-01],
	[4.4010000000E+04, 1.1125772617E+01, 3.1301284670E+00, 1.6620911005E+00, 9.8911103282E-01, 8.9983398996E-01],
	[4.4015000000E+04, 1.1127903738E+01, 3.1301429090E+00, 1.6626764496E+00, 9.8933659198E-01, 8.9985471029E-01],
	[4.4020000000E+04, 1.1130035026E+01, 3.1301573494E+00, 1.6632619383E+00, 9.8956215213E-01, 8.9987542653E-01],
	[4.4025000000E+04, 1.1132166479E+01, 3.1301717882E+00, 1.6638475665E+00, 9.8978771325E-01, 8.9989613868E-01],
	[4.4030000000E+04, 1.1134298098E+01, 3.1301862255E+00, 1.6644333342E+00, 9.9001327533E-01, 8.9991684676E-01],
	[4.4035000000E+04, 1.1136429884E+01, 3.1302006612E+00, 1.6650192416E+00, 9.9023883837E-01, 8.9993755075E-01],
	[4.4040000000E+04, 1.1138561835E+01, 3.1302150953E+00, 1.6656052885E+00, 9.9046440234E-01, 8.9995825066E-01],
	[4.4045000000E+04, 1.1140693953E+01, 3.1302295279E+00, 1.6661914751E+00, 9.9068996725E-01, 8.9997894648E-01],
	[4.4050000000E+04, 1.1142826236E+01, 3.1302439588E+00, 1.6667778013E+00, 9.9091553307E-01, 8.9999963823E-01],
	[4.4055000000E+04, 1.1144958686E+01, 3.1302583883E+00, 1.6673642672E+00, 9.9114109981E-01, 9.0002032589E-01],
	[4.4060000000E+04, 1.1147091301E+01, 3.1302728161E+00, 1.6679508727E+00, 9.9136666744E-01, 9.0004100948E-01],
	[4.4065000000E+04, 1.1149224083E+01, 3.1302872424E+00, 1.6685376179E+00, 9.9159223596E-01, 9.0006168899E-01],
	[4.4070000000E+04, 1.1151357030E+01, 3.1303016671E+00, 1.6691245028E+00, 9.9181780535E-01, 9.0008236442E-01],
	[4.4075000000E+04, 1.1153490144E+01, 3.1303160902E+00, 1.6697115274E+00, 9.9204337561E-01, 9.0010303577E-01],
	[4.4080000000E+04, 1.1155623424E+01, 3.1303305117E+00, 1.6702986918E+00, 9.9226894672E-01, 9.0012370305E-01],
	[4.4085000000E+04, 1.1157756869E+01, 3.1303449317E+00, 1.6708859960E+00, 9.9249451868E-01, 9.0014436625E-01],
	[4.4090000000E+04, 1.1159890481E+01, 3.1303593501E+00, 1.6714734399E+00, 9.9272009147E-01, 9.0016502538E-01],
	[4.4095000000E+04, 1.1162024258E+01, 3.1303737670E+00, 1.6720610236E+00, 9.9294566509E-01, 9.0018568043E-01],
	[4.4100000000E+04, 1.1164158202E+01, 3.1303881823E+00, 1.6726487471E+00, 9.9317123951E-01, 9.0020633141E-01],
	[4.4105000000E+04, 1.1166292311E+01, 3.1304025960E+00, 1.6732366104E+00, 9.9339681474E-01, 9.0022697832E-01],
	[4.4110000000E+04, 1.1168426587E+01, 3.1304170081E+00, 1.6738246136E+00, 9.9362239075E-01, 9.0024762116E-01],
	[4.4115000000E+04, 1.1170561028E+01, 3.1304314187E+00, 1.6744127566E+00, 9.9384796754E-01, 9.0026825992E-01],
	[4.4120000000E+04, 1.1172695635E+01, 3.1304458277E+00, 1.6750010396E+00, 9.9407354510E-01, 9.0028889462E-01],
	[4.4125000000E+04, 1.1174830408E+01, 3.1304602352E+00, 1.6755894624E+00, 9.9429912342E-01, 9.0030952525E-01],
	[4.4130000000E+04, 1.1176965348E+01, 3.1304746410E+00, 1.6761780251E+00, 9.9452470249E-01, 9.0033015180E-01],
	[4.4135000000E+04, 1.1179100453E+01, 3.1304890454E+00, 1.6767667278E+00, 9.9475028229E-01, 9.0035077430E-01],
	[4.4140000000E+04, 1.1181235724E+01, 3.1305034481E+00, 1.6773555704E+00, 9.9497586281E-01, 9.0037139272E-01],
	[4.4145000000E+04, 1.1183371161E+01, 3.1305178493E+00, 1.6779445530E+00, 9.9520144405E-01, 9.0039200708E-01],
	[4.4150000000E+04, 1.1185506764E+01, 3.1305322489E+00, 1.6785336755E+00, 9.9542702600E-01, 9.0041261738E-01],
	[4.4155000000E+04, 1.1187642533E+01, 3.1305466469E+00, 1.6791229381E+00, 9.9565260863E-01, 9.0043322361E-01],
	[4.4160000000E+04, 1.1189778467E+01, 3.1305610434E+00, 1.6797123407E+00, 9.9587819195E-01, 9.0045382577E-01],
	[4.4165000000E+04, 1.1191914568E+01, 3.1305754384E+00, 1.6803018833E+00, 9.9610377594E-01, 9.0047442388E-01],
	[4.4170000000E+04, 1.1194050834E+01, 3.1305898317E+00, 1.6808915660E+00, 9.9632936058E-01, 9.0049501792E-01],
	[4.4175000000E+04, 1.1196187267E+01, 3.1306042235E+00, 1.6814813887E+00, 9.9655494588E-01, 9.0051560790E-01],
	[4.4180000000E+04, 1.1198323865E+01, 3.1306186138E+00, 1.6820713515E+00, 9.9678053182E-01, 9.0053619382E-01],
	[4.4185000000E+04, 1.1200460629E+01, 3.1306330024E+00, 1.6826614544E+00, 9.9700611838E-01, 9.0055677568E-01],
	[4.4190000000E+04, 1.1202597559E+01, 3.1306473895E+00, 1.6832516975E+00, 9.9723170556E-01, 9.0057735348E-01],
	[4.4195000000E+04, 1.1204734655E+01, 3.1306617751E+00, 1.6838420807E+00, 9.9745729335E-01, 9.0059792722E-01],
	[4.4200000000E+04, 1.1206871916E+01, 3.1306761591E+00, 1.6844326040E+00, 9.9768288174E-01, 9.0061849691E-01],
	[4.4205000000E+04, 1.1209009344E+01, 3.1306905415E+00, 1.6850232676E+00, 9.9790847070E-01, 9.0063906254E-01],
	[4.4210000000E+04, 1.1211146937E+01, 3.1307049224E+00, 1.6856140713E+00, 9.9813406025E-01, 9.0065962411E-01],
	[4.4215000000E+04, 1.1213284697E+01, 3.1307193017E+00, 1.6862050152E+00, 9.9835965035E-01, 9.0068018163E-01],
	[4.4220000000E+04, 1.1215422622E+01, 3.1307336794E+00, 1.6867960994E+00, 9.9858524101E-01, 9.0070073510E-01],
	[4.4225000000E+04, 1.1217560712E+01, 3.1307480556E+00, 1.6873873237E+00, 9.9881083221E-01, 9.0072128451E-01],
	[4.4230000000E+04, 1.1219698969E+01, 3.1307624302E+00, 1.6879786884E+00, 9.9903642394E-01, 9.0074182987E-01],
	[4.4235000000E+04, 1.1221837392E+01, 3.1307768033E+00, 1.6885701933E+00, 9.9926201619E-01, 9.0076237118E-01],
	[4.4240000000E+04, 1.1223975980E+01, 3.1307911748E+00, 1.6891618386E+00, 9.9948760895E-01, 9.0078290843E-01],
	[4.4245000000E+04, 1.1226114734E+01, 3.1308055448E+00, 1.6897536241E+00, 9.9971320222E-01, 9.0080344164E-01],
	[4.4250000000E+04, 1.1228253654E+01, 3.1308199132E+00, 1.6903455500E+00, 9.9993879596E-01, 9.0082397080E-01],
	[4.4255000000E+04, 1.1230392740E+01, 3.1308342800E+00, 1.6909376162E+00, 1.0001643902E+00, 9.0084449591E-01],
	[4.4260000000E+04, 1.1232531991E+01, 3.1308486453E+00, 1.6915298228E+00, 1.0003899849E+00, 9.0086501697E-01],
	[4.4265000000E+04, 1.1234671408E+01, 3.1308630090E+00, 1.6921221698E+00, 1.0006155800E+00, 9.0088553398E-01],
	[4.4270000000E+04, 1.1236810991E+01, 3.1308773712E+00, 1.6927146571E+00, 1.0008411756E+00, 9.0090604695E-01],
	[4.4275000000E+04, 1.1238950740E+01, 3.1308917318E+00, 1.6933072849E+00, 1.0010667717E+00, 9.0092655587E-01],
	[4.4280000000E+04, 1.1241090655E+01, 3.1309060908E+00, 1.6939000532E+00, 1.0012923681E+00, 9.0094706075E-01],
	[4.4285000000E+04, 1.1243230735E+01, 3.1309204483E+00, 1.6944929618E+00, 1.0015179650E+00, 9.0096756158E-01],
	[4.4290000000E+04, 1.1245370981E+01, 3.1309348043E+00, 1.6950860110E+00, 1.0017435622E+00, 9.0098805837E-01],
	[4.4295000000E+04, 1.1247511393E+01, 3.1309491587E+00, 1.6956792006E+00, 1.0019691599E+00, 9.0100855112E-01],
	[4.4300000000E+04, 1.1249651970E+01, 3.1309635115E+00, 1.6962725308E+00, 1.0021947579E+00, 9.0102903982E-01],
	[4.4305000000E+04, 1.1251792713E+01, 3.1309778628E+00, 1.6968660014E+00, 1.0024203564E+00, 9.0104952449E-01],
	[4.4310000000E+04, 1.1253933622E+01, 3.1309922125E+00, 1.6974596126E+00, 1.0026459551E+00, 9.0107000512E-01],
	[4.4315000000E+04, 1.1256074697E+01, 3.1310065607E+00, 1.6980533644E+00, 1.0028715542E+00, 9.0109048170E-01],
	[4.4320000000E+04, 1.1258215938E+01, 3.1310209073E+00, 1.6986472567E+00, 1.0030971537E+00, 9.0111095425E-01],
	[4.4325000000E+04, 1.1260357344E+01, 3.1310352524E+00, 1.6992412896E+00, 1.0033227535E+00, 9.0113142276E-01],
	[4.4330000000E+04, 1.1262498915E+01, 3.1310495959E+00, 1.6998354632E+00, 1.0035483536E+00, 9.0115188723E-01],
	[4.4335000000E+04, 1.1264640653E+01, 3.1310639378E+00, 1.7004297773E+00, 1.0037739540E+00, 9.0117234767E-01],
	[4.4340000000E+04, 1.1266782556E+01, 3.1310782783E+00, 1.7010242321E+00, 1.0039995547E+00, 9.0119280407E-01],
	[4.4345000000E+04, 1.1268924625E+01, 3.1310926171E+00, 1.7016188276E+00, 1.0042251557E+00, 9.0121325644E-01],
	[4.4350000000E+04, 1.1271066860E+01, 3.1311069544E+00, 1.7022135638E+00, 1.0044507570E+00, 9.0123370477E-01],
	[4.4355000000E+04, 1.1273209260E+01, 3.1311212902E+00, 1.7028084406E+00, 1.0046763585E+00, 9.0125414907E-01],
	[4.4360000000E+04, 1.1275351826E+01, 3.1311356244E+00, 1.7034034581E+00, 1.0049019603E+00, 9.0127458934E-01],
	[4.4365000000E+04, 1.1277494557E+01, 3.1311499571E+00, 1.7039986164E+00, 1.0051275623E+00, 9.0129502558E-01],
	[4.4370000000E+04, 1.1279637454E+01, 3.1311642882E+00, 1.7045939155E+00, 1.0053531645E+00, 9.0131545779E-01],
	[4.4375000000E+04, 1.1281780517E+01, 3.1311786177E+00, 1.7051893553E+00, 1.0055787670E+00, 9.0133588596E-01],
	[4.4380000000E+04, 1.1283923746E+01, 3.1311929457E+00, 1.7057849358E+00, 1.0058043697E+00, 9.0135631011E-01],
	[4.4385000000E+04, 1.1286067140E+01, 3.1312072722E+00, 1.7063806572E+00, 1.0060299726E+00, 9.0137673023E-01],
	[4.4390000000E+04, 1.1288210700E+01, 3.1312215971E+00, 1.7069765194E+00, 1.0062555757E+00, 9.0139714632E-01],
	[4.4395000000E+04, 1.1290354425E+01, 3.1312359205E+00, 1.7075725225E+00, 1.0064811789E+00, 9.0141755839E-01],
	[4.4400000000E+04, 1.1292498316E+01, 3.1312502423E+00, 1.7081686663E+00, 1.0067067823E+00, 9.0143796643E-01],
	[4.4405000000E+04, 1.1294642373E+01, 3.1312645626E+00, 1.7087649511E+00, 1.0069323859E+00, 9.0145837044E-01],
	[4.4410000000E+04, 1.1296786595E+01, 3.1312788813E+00, 1.7093613767E+00, 1.0071579896E+00, 9.0147877043E-01],
	[4.4415000000E+04, 1.1298930983E+01, 3.1312931985E+00, 1.7099579433E+00, 1.0073835935E+00, 9.0149916640E-01],
	[4.4420000000E+04, 1.1301075536E+01, 3.1313075141E+00, 1.7105546508E+00, 1.0076091975E+00, 9.0151955834E-01],
	[4.4425000000E+04, 1.1303220255E+01, 3.1313218282E+00, 1.7111514992E+00, 1.0078348016E+00, 9.0153994626E-01],
	[4.4430000000E+04, 1.1305365140E+01, 3.1313361407E+00, 1.7117484885E+00, 1.0080604058E+00, 9.0156033016E-01],
	[4.4435000000E+04, 1.1307510190E+01, 3.1313504517E+00, 1.7123456189E+00, 1.0082860100E+00, 9.0158071004E-01],
	[4.4440000000E+04, 1.1309655406E+01, 3.1313647612E+00, 1.7129428902E+00, 1.0085116144E+00, 9.0160108591E-01],
	[4.4445000000E+04, 1.1311800787E+01, 3.1313790691E+00, 1.7135403025E+00, 1.0087372189E+00, 9.0162145775E-01],
	[4.4450000000E+04, 1.1313946334E+01, 3.1313933754E+00, 1.7141378559E+00, 1.0089628234E+00, 9.0164182557E-01],
	[4.4455000000E+04, 1.1316092046E+01, 3.1314076802E+00, 1.7147355503E+00, 1.0091884279E+00, 9.0166218938E-01],
	[4.4460000000E+04, 1.1318237924E+01, 3.1314219835E+00, 1.7153333858E+00, 1.0094140325E+00, 9.0168254917E-01],
	[4.4465000000E+04, 1.1320383968E+01, 3.1314362852E+00, 1.7159313623E+00, 1.0096396372E+00, 9.0170290494E-01],
	[4.4470000000E+04, 1.1322530177E+01, 3.1314505854E+00, 1.7165294800E+00, 1.0098652418E+00, 9.0172325670E-01],
	[4.4475000000E+04, 1.1324676551E+01, 3.1314648841E+00, 1.7171277388E+00, 1.0100908465E+00, 9.0174360444E-01],
	[4.4480000000E+04, 1.1326823091E+01, 3.1314791812E+00, 1.7177261386E+00, 1.0103164511E+00, 9.0176394818E-01],
	[4.4485000000E+04, 1.1328969797E+01, 3.1314934767E+00, 1.7183246797E+00, 1.0105420558E+00, 9.0178428789E-01],
	[4.4490000000E+04, 1.1331116668E+01, 3.1315077708E+00, 1.7189233619E+00, 1.0107676604E+00, 9.0180462360E-01],
	[4.4495000000E+04, 1.1333263705E+01, 3.1315220632E+00, 1.7195221853E+00, 1.0109932650E+00, 9.0182495530E-01],
	[4.4500000000E+04, 1.1335410907E+01, 3.1315363542E+00, 1.7201211499E+00, 1.0112188695E+00, 9.0184528298E-01],
	[4.4505000000E+04, 1.1337558274E+01, 3.1315506436E+00, 1.7207202557E+00, 1.0114444740E+00, 9.0186560666E-01],
	[4.4510000000E+04, 1.1339705808E+01, 3.1315649314E+00, 1.7213195027E+00, 1.0116700784E+00, 9.0188592633E-01],
	[4.4515000000E+04, 1.1341853506E+01, 3.1315792178E+00, 1.7219188910E+00, 1.0118956827E+00, 9.0190624199E-01],
	[4.4520000000E+04, 1.1344001370E+01, 3.1315935025E+00, 1.7225184206E+00, 1.0121212870E+00, 9.0192655364E-01],
	[4.4525000000E+04, 1.1346149400E+01, 3.1316077858E+00, 1.7231180914E+00, 1.0123468911E+00, 9.0194686129E-01],
	[4.4530000000E+04, 1.1348297595E+01, 3.1316220675E+00, 1.7237179036E+00, 1.0125724952E+00, 9.0196716493E-01],
	[4.4535000000E+04, 1.1350445955E+01, 3.1316363476E+00, 1.7243178570E+00, 1.0127980991E+00, 9.0198746456E-01],
	[4.4540000000E+04, 1.1352594481E+01, 3.1316506263E+00, 1.7249179519E+00, 1.0130237029E+00, 9.0200776020E-01],
	[4.4545000000E+04, 1.1354743173E+01, 3.1316649033E+00, 1.7255181880E+00, 1.0132493065E+00, 9.0202805182E-01],
	[4.4550000000E+04, 1.1356892029E+01, 3.1316791789E+00, 1.7261185656E+00, 1.0134749101E+00, 9.0204833945E-01],
	[4.4555000000E+04, 1.1359041052E+01, 3.1316934529E+00, 1.7267190845E+00, 1.0137005134E+00, 9.0206862307E-01],
	[4.4560000000E+04, 1.1361190239E+01, 3.1317077254E+00, 1.7273197449E+00, 1.0139261166E+00, 9.0208890270E-01],
	[4.4565000000E+04, 1.1363339593E+01, 3.1317219963E+00, 1.7279205466E+00, 1.0141517196E+00, 9.0210917832E-01],
	[4.4570000000E+04, 1.1365489111E+01, 3.1317362657E+00, 1.7285214899E+00, 1.0143773224E+00, 9.0212944995E-01],
	[4.4575000000E+04, 1.1367638795E+01, 3.1317505336E+00, 1.7291225745E+00, 1.0146029249E+00, 9.0214971757E-01],
	[4.4580000000E+04, 1.1369788644E+01, 3.1317647999E+00, 1.7297238007E+00, 1.0148285273E+00, 9.0216998120E-01],
	[4.4585000000E+04, 1.1371939681E+01, 3.1317792949E+00, 1.7303251684E+00, 1.0150541618E+00, 9.0219024083E-01],
	[4.4590000000E+04, 1.1374095393E+01, 3.1317948049E+00, 1.7309266775E+00, 1.0152799388E+00, 9.0221049647E-01],
	[4.4595000000E+04, 1.1376251271E+01, 3.1318103132E+00, 1.7315283282E+00, 1.0155057157E+00, 9.0223074811E-01],
	[4.4600000000E+04, 1.1378407317E+01, 3.1318258198E+00, 1.7321301205E+00, 1.0157314925E+00, 9.0225099575E-01],
	[4.4605000000E+04, 1.1380563530E+01, 3.1318413248E+00, 1.7327320543E+00, 1.0159572691E+00, 9.0227123940E-01],
	[4.4610000000E+04, 1.1382719909E+01, 3.1318568281E+00, 1.7333341297E+00, 1.0161830456E+00, 9.0229147906E-01],
	[4.4615000000E+04, 1.1384876456E+01, 3.1318723297E+00, 1.7339363467E+00, 1.0164088218E+00, 9.0231171472E-01],
	[4.4620000000E+04, 1.1387033169E+01, 3.1318878297E+00, 1.7345387053E+00, 1.0166345979E+00, 9.0233194640E-01],
	[4.4625000000E+04, 1.1389190049E+01, 3.1319033280E+00, 1.7351412055E+00, 1.0168603739E+00, 9.0235217408E-01],
	[4.4630000000E+04, 1.1391347095E+01, 3.1319188247E+00, 1.7357438474E+00, 1.0170861496E+00, 9.0237239778E-01],
	[4.4635000000E+04, 1.1393504309E+01, 3.1319343197E+00, 1.7363466310E+00, 1.0173119251E+00, 9.0239261748E-01],
	[4.4640000000E+04, 1.1395661689E+01, 3.1319498131E+00, 1.7369495563E+00, 1.0175377004E+00, 9.0241283320E-01],
	[4.4645000000E+04, 1.1397819237E+01, 3.1319653048E+00, 1.7375526232E+00, 1.0177634754E+00, 9.0243304492E-01],
	[4.4650000000E+04, 1.1399976951E+01, 3.1319807948E+00, 1.7381558319E+00, 1.0179892502E+00, 9.0245325267E-01],
	[4.4655000000E+04, 1.1402134831E+01, 3.1319962832E+00, 1.7387591824E+00, 1.0182150248E+00, 9.0247345642E-01],
	[4.4660000000E+04, 1.1404292879E+01, 3.1320117699E+00, 1.7393626745E+00, 1.0184407990E+00, 9.0249365619E-01],
	[4.4665000000E+04, 1.1406451093E+01, 3.1320272549E+00, 1.7399663085E+00, 1.0186665730E+00, 9.0251385198E-01],
	[4.4670000000E+04, 1.1408609475E+01, 3.1320427383E+00, 1.7405700842E+00, 1.0188923468E+00, 9.0253404378E-01],
	[4.4675000000E+04, 1.1410768023E+01, 3.1320582201E+00, 1.7411740018E+00, 1.0191181202E+00, 9.0255423160E-01],
	[4.4680000000E+04, 1.1412926737E+01, 3.1320737002E+00, 1.7417780612E+00, 1.0193438933E+00, 9.0257441543E-01],
	[4.4685000000E+04, 1.1415085619E+01, 3.1320891786E+00, 1.7423822624E+00, 1.0195696661E+00, 9.0259459529E-01],
	[4.4690000000E+04, 1.1417244667E+01, 3.1321046554E+00, 1.7429866055E+00, 1.0197954386E+00, 9.0261477116E-01],
	[4.4695000000E+04, 1.1419403882E+01, 3.1321201305E+00, 1.7435910905E+00, 1.0200212107E+00, 9.0263494306E-01],
	[4.4700000000E+04, 1.1421563264E+01, 3.1321356040E+00, 1.7441957173E+00, 1.0202469825E+00, 9.0265511098E-01],
	[4.4705000000E+04, 1.1423722812E+01, 3.1321510758E+00, 1.7448004861E+00, 1.0204727540E+00, 9.0267527491E-01],
	[4.4710000000E+04, 1.1425882527E+01, 3.1321665460E+00, 1.7454053968E+00, 1.0206985250E+00, 9.0269543487E-01],
	[4.4715000000E+04, 1.1428042409E+01, 3.1321820145E+00, 1.7460104495E+00, 1.0209242957E+00, 9.0271559086E-01],
	[4.4720000000E+04, 1.1430202458E+01, 3.1321974813E+00, 1.7466156441E+00, 1.0211500660E+00, 9.0273574286E-01],
	[4.4725000000E+04, 1.1432362673E+01, 3.1322129465E+00, 1.7472209807E+00, 1.0213758359E+00, 9.0275589090E-01],
	[4.4730000000E+04, 1.1434523055E+01, 3.1322284101E+00, 1.7478264593E+00, 1.0216016054E+00, 9.0277603496E-01],
	[4.4735000000E+04, 1.1436683604E+01, 3.1322438720E+00, 1.7484320800E+00, 1.0218273745E+00, 9.0279617504E-01],
	[4.4740000000E+04, 1.1438844319E+01, 3.1322593322E+00, 1.7490378426E+00, 1.0220531431E+00, 9.0281631115E-01],
	[4.4745000000E+04, 1.1441005201E+01, 3.1322747908E+00, 1.7496437473E+00, 1.0222789113E+00, 9.0283644329E-01],
	[4.4750000000E+04, 1.1443166250E+01, 3.1322902477E+00, 1.7502497941E+00, 1.0225046790E+00, 9.0285657146E-01],
	[4.4755000000E+04, 1.1445327466E+01, 3.1323057030E+00, 1.7508559830E+00, 1.0227304463E+00, 9.0287669566E-01],
	[4.4760000000E+04, 1.1447488848E+01, 3.1323211567E+00, 1.7514623140E+00, 1.0229562131E+00, 9.0289681589E-01],
	[4.4765000000E+04, 1.1449650397E+01, 3.1323366087E+00, 1.7520687871E+00, 1.0231819794E+00, 9.0291693215E-01],
	[4.4770000000E+04, 1.1451812112E+01, 3.1323520590E+00, 1.7526754023E+00, 1.0234077452E+00, 9.0293704444E-01],
	[4.4775000000E+04, 1.1453973994E+01, 3.1323675077E+00, 1.7532821597E+00, 1.0236335105E+00, 9.0295715276E-01],
	[4.4780000000E+04, 1.1456136043E+01, 3.1323829547E+00, 1.7538890593E+00, 1.0238592753E+00, 9.0297725712E-01],
	[4.4785000000E+04, 1.1458298259E+01, 3.1323984001E+00, 1.7544961010E+00, 1.0240850396E+00, 9.0299735751E-01],
	[4.4790000000E+04, 1.1460460641E+01, 3.1324138439E+00, 1.7551032850E+00, 1.0243108034E+00, 9.0301745394E-01],
	[4.4795000000E+04, 1.1462623190E+01, 3.1324292860E+00, 1.7557106112E+00, 1.0245365666E+00, 9.0303754640E-01],
	[4.4800000000E+04, 1.1464785905E+01, 3.1324447264E+00, 1.7563180796E+00, 1.0247623292E+00, 9.0305763490E-01],
	[4.4805000000E+04, 1.1466948787E+01, 3.1324601652E+00, 1.7569256904E+00, 1.0249880913E+00, 9.0307771944E-01],
	[4.4810000000E+04, 1.1469111835E+01, 3.1324756024E+00, 1.7575334433E+00, 1.0252138527E+00, 9.0309780001E-01],
	[4.4815000000E+04, 1.1471275051E+01, 3.1324910379E+00, 1.7581413386E+00, 1.0254396136E+00, 9.0311787662E-01],
	[4.4820000000E+04, 1.1473438432E+01, 3.1325064718E+00, 1.7587493762E+00, 1.0256653740E+00, 9.0313794927E-01],
	[4.4825000000E+04, 1.1475601981E+01, 3.1325219040E+00, 1.7593575561E+00, 1.0258911336E+00, 9.0315801797E-01],
	[4.4830000000E+04, 1.1477765696E+01, 3.1325373346E+00, 1.7599658784E+00, 1.0261168927E+00, 9.0317808270E-01],
	[4.4835000000E+04, 1.1479929577E+01, 3.1325527635E+00, 1.7605743431E+00, 1.0263426512E+00, 9.0319814348E-01],
	[4.4840000000E+04, 1.1482093626E+01, 3.1325681908E+00, 1.7611829501E+00, 1.0265684090E+00, 9.0321820029E-01],
	[4.4845000000E+04, 1.1484257840E+01, 3.1325836164E+00, 1.7617916995E+00, 1.0267941661E+00, 9.0323825315E-01],
	[4.4850000000E+04, 1.1486422222E+01, 3.1325990404E+00, 1.7624005914E+00, 1.0270199226E+00, 9.0325830205E-01],
	[4.4855000000E+04, 1.1488586770E+01, 3.1326144628E+00, 1.7630096256E+00, 1.0272456784E+00, 9.0327834700E-01],
	[4.4860000000E+04, 1.1490751484E+01, 3.1326298835E+00, 1.7636188024E+00, 1.0274714336E+00, 9.0329838799E-01],
	[4.4865000000E+04, 1.1492916365E+01, 3.1326453026E+00, 1.7642281216E+00, 1.0276971880E+00, 9.0331842503E-01],
	[4.4870000000E+04, 1.1495081413E+01, 3.1326607200E+00, 1.7648375833E+00, 1.0279229418E+00, 9.0333845811E-01],
	[4.4875000000E+04, 1.1497246627E+01, 3.1326761358E+00, 1.7654471875E+00, 1.0281486948E+00, 9.0335848724E-01],
	[4.4880000000E+04, 1.1499412007E+01, 3.1326915499E+00, 1.7660569342E+00, 1.0283744471E+00, 9.0337851242E-01],
	[4.4885000000E+04, 1.1501577554E+01, 3.1327069624E+00, 1.7666668234E+00, 1.0286001987E+00, 9.0339853364E-01],
	[4.4890000000E+04, 1.1503743268E+01, 3.1327223733E+00, 1.7672768553E+00, 1.0288259495E+00, 9.0341855092E-01],
	[4.4895000000E+04, 1.1505909148E+01, 3.1327377825E+00, 1.7678870296E+00, 1.0290516996E+00, 9.0343856424E-01],
	[4.4900000000E+04, 1.1508075195E+01, 3.1327531901E+00, 1.7684973466E+00, 1.0292774489E+00, 9.0345857361E-01],
	[4.4905000000E+04, 1.1510241408E+01, 3.1327685960E+00, 1.7691078062E+00, 1.0295031974E+00, 9.0347857904E-01],
	[4.4910000000E+04, 1.1512407788E+01, 3.1327840003E+00, 1.7697184084E+00, 1.0297289452E+00, 9.0349858052E-01],
	[4.4915000000E+04, 1.1514574334E+01, 3.1327994030E+00, 1.7703291533E+00, 1.0299546921E+00, 9.0351857804E-01],
	[4.4920000000E+04, 1.1516741047E+01, 3.1328148040E+00, 1.7709400408E+00, 1.0301804383E+00, 9.0353857163E-01],
	[4.4925000000E+04, 1.1518907926E+01, 3.1328302034E+00, 1.7715510710E+00, 1.0304061836E+00, 9.0355856126E-01],
	[4.4930000000E+04, 1.1521074972E+01, 3.1328456011E+00, 1.7721622440E+00, 1.0306319281E+00, 9.0357854695E-01],
	[4.4935000000E+04, 1.1523242184E+01, 3.1328609972E+00, 1.7727735596E+00, 1.0308576718E+00, 9.0359852869E-01],
	[4.4940000000E+04, 1.1525409562E+01, 3.1328763917E+00, 1.7733850179E+00, 1.0310834146E+00, 9.0361850649E-01],
	[4.4945000000E+04, 1.1527577107E+01, 3.1328917845E+00, 1.7739966190E+00, 1.0313091566E+00, 9.0363848035E-01],
	[4.4950000000E+04, 1.1529744819E+01, 3.1329071757E+00, 1.7746083629E+00, 1.0315348977E+00, 9.0365845026E-01],
	[4.4955000000E+04, 1.1531912697E+01, 3.1329225653E+00, 1.7752202495E+00, 1.0317606379E+00, 9.0367841624E-01],
	[4.4960000000E+04, 1.1534080741E+01, 3.1329379532E+00, 1.7758322790E+00, 1.0319863772E+00, 9.0369837826E-01],
	[4.4965000000E+04, 1.1536248952E+01, 3.1329533395E+00, 1.7764444513E+00, 1.0322121156E+00, 9.0371833635E-01],
	[4.4970000000E+04, 1.1538417329E+01, 3.1329687241E+00, 1.7770567664E+00, 1.0324378532E+00, 9.0373829050E-01],
	[4.4975000000E+04, 1.1540585873E+01, 3.1329841072E+00, 1.7776692243E+00, 1.0326635898E+00, 9.0375824071E-01],
	[4.4980000000E+04, 1.1542754583E+01, 3.1329994885E+00, 1.7782818252E+00, 1.0328893254E+00, 9.0377818698E-01],
	[4.4985000000E+04, 1.1544923460E+01, 3.1330148683E+00, 1.7788945689E+00, 1.0331150602E+00, 9.0379812931E-01],
	[4.4990000000E+04, 1.1547092503E+01, 3.1330302464E+00, 1.7795074555E+00, 1.0333407939E+00, 9.0381806771E-01],
	[4.4995000000E+04, 1.1549261712E+01, 3.1330456229E+00, 1.7801204850E+00, 1.0335665268E+00, 9.0383800216E-01],
	[4.5000000000E+04, 1.1551431088E+01, 3.1330609977E+00, 1.7807336575E+00, 1.0337922586E+00, 9.0385793268E-01],
	[4.5005000000E+04, 1.1553600630E+01, 3.1330763709E+00, 1.7813517900E+00, 1.0340196125E+00, 9.0387785927E-01],
	[4.5010000000E+04, 1.1555770339E+01, 3.1330917425E+00, 1.7819700683E+00, 1.0342469656E+00, 9.0389778192E-01],
	[4.5015000000E+04, 1.1557940213E+01, 3.1331071125E+00, 1.7825884924E+00, 1.0344743178E+00, 9.0391770064E-01],
	[4.5020000000E+04, 1.1560110255E+01, 3.1331224808E+00, 1.7832070624E+00, 1.0347016691E+00, 9.0393761542E-01],
	[4.5025000000E+04, 1.1562280462E+01, 3.1331378475E+00, 1.7838257781E+00, 1.0349290195E+00, 9.0395752627E-01],
	[4.5030000000E+04, 1.1564450836E+01, 3.1331532125E+00, 1.7844446398E+00, 1.0351563691E+00, 9.0397743319E-01],
	[4.5035000000E+04, 1.1566621377E+01, 3.1331685760E+00, 1.7850636473E+00, 1.0353837176E+00, 9.0399733618E-01],
	[4.5040000000E+04, 1.1568792084E+01, 3.1331839378E+00, 1.7856828007E+00, 1.0356110653E+00, 9.0401723523E-01],
	[4.5045000000E+04, 1.1570962957E+01, 3.1331992979E+00, 1.7863021000E+00, 1.0358384120E+00, 9.0403713036E-01],
	[4.5050000000E+04, 1.1573133996E+01, 3.1332146565E+00, 1.7869215453E+00, 1.0360657578E+00, 9.0405702156E-01],
	[4.5055000000E+04, 1.1575305202E+01, 3.1332300134E+00, 1.7875411365E+00, 1.0362931026E+00, 9.0407690883E-01],
	[4.5060000000E+04, 1.1577476574E+01, 3.1332453687E+00, 1.7881608737E+00, 1.0365204465E+00, 9.0409679217E-01],
	[4.5065000000E+04, 1.1579648112E+01, 3.1332607223E+00, 1.7887807569E+00, 1.0367477893E+00, 9.0411667158E-01],
	[4.5070000000E+04, 1.1581819817E+01, 3.1332760743E+00, 1.7894007861E+00, 1.0369751312E+00, 9.0413654707E-01],
	[4.5075000000E+04, 1.1583991688E+01, 3.1332914247E+00, 1.7900209614E+00, 1.0372024721E+00, 9.0415641863E-01],
	[4.5080000000E+04, 1.1586163725E+01, 3.1333067735E+00, 1.7906412826E+00, 1.0374298119E+00, 9.0417628627E-01],
	[4.5085000000E+04, 1.1588335929E+01, 3.1333221206E+00, 1.7912617500E+00, 1.0376571507E+00, 9.0419614998E-01],
	[4.5090000000E+04, 1.1590508299E+01, 3.1333374661E+00, 1.7918823634E+00, 1.0378844885E+00, 9.0421600976E-01],
	[4.5095000000E+04, 1.1592680835E+01, 3.1333528100E+00, 1.7925031229E+00, 1.0381118253E+00, 9.0423586563E-01],
	[4.5100000000E+04, 1.1594853538E+01, 3.1333681523E+00, 1.7931240286E+00, 1.0383391610E+00, 9.0425571757E-01],
	[4.5105000000E+04, 1.1597026406E+01, 3.1333834929E+00, 1.7937450803E+00, 1.0385664956E+00, 9.0427556559E-01],
	[4.5110000000E+04, 1.1599199442E+01, 3.1333988319E+00, 1.7943662783E+00, 1.0387938292E+00, 9.0429540969E-01],
	[4.5115000000E+04, 1.1601372643E+01, 3.1334141693E+00, 1.7949876224E+00, 1.0390211616E+00, 9.0431524987E-01],
	[4.5120000000E+04, 1.1603546010E+01, 3.1334295051E+00, 1.7956091127E+00, 1.0392484930E+00, 9.0433508613E-01],
	[4.5125000000E+04, 1.1605719544E+01, 3.1334448392E+00, 1.7962307492E+00, 1.0394758233E+00, 9.0435491847E-01],
	[4.5130000000E+04, 1.1607893244E+01, 3.1334601717E+00, 1.7968525319E+00, 1.0397031524E+00, 9.0437474689E-01],
	[4.5135000000E+04, 1.1610067111E+01, 3.1334755026E+00, 1.7974744609E+00, 1.0399304804E+00, 9.0439457139E-01],
	[4.5140000000E+04, 1.1612241143E+01, 3.1334908319E+00, 1.7980965361E+00, 1.0401578073E+00, 9.0441439198E-01],
	[4.5145000000E+04, 1.1614415342E+01, 3.1335061595E+00, 1.7987187576E+00, 1.0403851330E+00, 9.0443420865E-01],
	[4.5150000000E+04, 1.1616589707E+01, 3.1335214855E+00, 1.7993411254E+00, 1.0406124576E+00, 9.0445402141E-01],
	[4.5155000000E+04, 1.1618764238E+01, 3.1335368099E+00, 1.7999636396E+00, 1.0408397810E+00, 9.0447383025E-01],
	[4.5160000000E+04, 1.1620938936E+01, 3.1335521327E+00, 1.8005863000E+00, 1.0410671032E+00, 9.0449363517E-01],
	[4.5165000000E+04, 1.1623113799E+01, 3.1335674538E+00, 1.8012091069E+00, 1.0412944242E+00, 9.0451343618E-01],
	[4.5170000000E+04, 1.1625288829E+01, 3.1335827734E+00, 1.8018320601E+00, 1.0415217441E+00, 9.0453323328E-01],
	[4.5175000000E+04, 1.1627464025E+01, 3.1335980913E+00, 1.8024551597E+00, 1.0417490627E+00, 9.0455302647E-01],
	[4.5180000000E+04, 1.1629639388E+01, 3.1336134076E+00, 1.8030784057E+00, 1.0419763801E+00, 9.0457281575E-01],
	[4.5185000000E+04, 1.1631814916E+01, 3.1336287222E+00, 1.8037017981E+00, 1.0422036962E+00, 9.0459260111E-01],
	[4.5190000000E+04, 1.1633990611E+01, 3.1336440353E+00, 1.8043253370E+00, 1.0424310111E+00, 9.0461238257E-01],
	[4.5195000000E+04, 1.1636166472E+01, 3.1336593467E+00, 1.8049490223E+00, 1.0426583248E+00, 9.0463216011E-01],
	[4.5200000000E+04, 1.1638342499E+01, 3.1336746565E+00, 1.8055728541E+00, 1.0428856372E+00, 9.0465193375E-01],
	[4.5205000000E+04, 1.1640518692E+01, 3.1336899647E+00, 1.8061968324E+00, 1.0431129483E+00, 9.0467170348E-01],
	[4.5210000000E+04, 1.1642695051E+01, 3.1337052713E+00, 1.8068209573E+00, 1.0433402581E+00, 9.0469146930E-01],
	[4.5215000000E+04, 1.1644871576E+01, 3.1337205763E+00, 1.8074452286E+00, 1.0435675667E+00, 9.0471123121E-01],
	[4.5220000000E+04, 1.1647048268E+01, 3.1337358796E+00, 1.8080696466E+00, 1.0437948739E+00, 9.0473098922E-01],
	[4.5225000000E+04, 1.1649225126E+01, 3.1337511813E+00, 1.8086942111E+00, 1.0440221798E+00, 9.0475074332E-01],
	[4.5230000000E+04, 1.1651402150E+01, 3.1337664814E+00, 1.8093189221E+00, 1.0442494844E+00, 9.0477049352E-01],
	[4.5235000000E+04, 1.1653579340E+01, 3.1337817799E+00, 1.8099437798E+00, 1.0444767876E+00, 9.0479023982E-01],
	[4.5240000000E+04, 1.1655756696E+01, 3.1337970768E+00, 1.8105687842E+00, 1.0447040895E+00, 9.0480998221E-01],
	[4.5245000000E+04, 1.1657934218E+01, 3.1338123720E+00, 1.8111939351E+00, 1.0449313901E+00, 9.0482972070E-01],
	[4.5250000000E+04, 1.1660111906E+01, 3.1338276657E+00, 1.8118192328E+00, 1.0451586893E+00, 9.0484945528E-01],
	[4.5255000000E+04, 1.1662289761E+01, 3.1338429577E+00, 1.8124446771E+00, 1.0453859870E+00, 9.0486918597E-01],
	[4.5260000000E+04, 1.1664467782E+01, 3.1338582481E+00, 1.8130702681E+00, 1.0456132835E+00, 9.0488891276E-01],
	[4.5265000000E+04, 1.1666645968E+01, 3.1338735369E+00, 1.8136960058E+00, 1.0458405785E+00, 9.0490863564E-01],
	[4.5270000000E+04, 1.1668824321E+01, 3.1338888241E+00, 1.8143218903E+00, 1.0460678720E+00, 9.0492835463E-01],
	[4.5275000000E+04, 1.1671002840E+01, 3.1339041097E+00, 1.8149479215E+00, 1.0462951642E+00, 9.0494806971E-01],
	[4.5280000000E+04, 1.1673181525E+01, 3.1339193936E+00, 1.8155740995E+00, 1.0465224550E+00, 9.0496778090E-01],
	[4.5285000000E+04, 1.1675360376E+01, 3.1339346760E+00, 1.8162004243E+00, 1.0467497443E+00, 9.0498748820E-01],
	[4.5290000000E+04, 1.1677539393E+01, 3.1339499567E+00, 1.8168268959E+00, 1.0469770321E+00, 9.0500719159E-01],
	[4.5295000000E+04, 1.1679718576E+01, 3.1339652358E+00, 1.8174535143E+00, 1.0472043185E+00, 9.0502689109E-01],
	[4.5300000000E+04, 1.1681897925E+01, 3.1339805133E+00, 1.8180802795E+00, 1.0474316034E+00, 9.0504658670E-01],
	[4.5305000000E+04, 1.1684081014E+01, 3.1339965661E+00, 1.8187071917E+00, 1.0476590024E+00, 9.0506627841E-01],
	[4.5310000000E+04, 1.1686266316E+01, 3.1340130616E+00, 1.8193342507E+00, 1.0478864661E+00, 9.0508596623E-01],
	[4.5315000000E+04, 1.1688451785E+01, 3.1340295555E+00, 1.8199614566E+00, 1.0481139284E+00, 9.0510565015E-01],
	[4.5320000000E+04, 1.1690637421E+01, 3.1340460475E+00, 1.8205888094E+00, 1.0483413893E+00, 9.0512533018E-01],
	[4.5325000000E+04, 1.1692823225E+01, 3.1340625379E+00, 1.8212163092E+00, 1.0485688488E+00, 9.0514500632E-01],
	[4.5330000000E+04, 1.1695009197E+01, 3.1340790265E+00, 1.8218439559E+00, 1.0487963069E+00, 9.0516467857E-01],
	[4.5335000000E+04, 1.1697195336E+01, 3.1340955134E+00, 1.8224717496E+00, 1.0490237635E+00, 9.0518434693E-01],
	[4.5340000000E+04, 1.1699381642E+01, 3.1341119985E+00, 1.8230996902E+00, 1.0492512188E+00, 9.0520401140E-01],
	[4.5345000000E+04, 1.1701568116E+01, 3.1341284820E+00, 1.8237277779E+00, 1.0494786725E+00, 9.0522367198E-01],
	[4.5350000000E+04, 1.1703754758E+01, 3.1341449637E+00, 1.8243560126E+00, 1.0497061249E+00, 9.0524332868E-01],
	[4.5355000000E+04, 1.1705941566E+01, 3.1341614436E+00, 1.8249843944E+00, 1.0499335757E+00, 9.0526298148E-01],
	[4.5360000000E+04, 1.1708128543E+01, 3.1341779219E+00, 1.8256129232E+00, 1.0501610251E+00, 9.0528263040E-01],
	[4.5365000000E+04, 1.1710315687E+01, 3.1341943984E+00, 1.8262415991E+00, 1.0503884730E+00, 9.0530227543E-01],
	[4.5370000000E+04, 1.1712502998E+01, 3.1342108731E+00, 1.8268704221E+00, 1.0506159194E+00, 9.0532191658E-01],
	[4.5375000000E+04, 1.1714690477E+01, 3.1342273462E+00, 1.8274993922E+00, 1.0508433642E+00, 9.0534155384E-01],
	[4.5380000000E+04, 1.1716878123E+01, 3.1342438175E+00, 1.8281285095E+00, 1.0510708076E+00, 9.0536118722E-01],
	[4.5385000000E+04, 1.1719065937E+01, 3.1342602871E+00, 1.8287577739E+00, 1.0512982494E+00, 9.0538081671E-01],
	[4.5390000000E+04, 1.1721253918E+01, 3.1342767549E+00, 1.8293871855E+00, 1.0515256897E+00, 9.0540044233E-01],
	[4.5395000000E+04, 1.1723442066E+01, 3.1342932211E+00, 1.8300167443E+00, 1.0517531285E+00, 9.0542006406E-01],
	[4.5400000000E+04, 1.1725630382E+01, 3.1343096855E+00, 1.8306464502E+00, 1.0519805657E+00, 9.0543968191E-01],
	[4.5405000000E+04, 1.1727818865E+01, 3.1343261481E+00, 1.8312763034E+00, 1.0522080013E+00, 9.0545929587E-01],
	[4.5410000000E+04, 1.1730007516E+01, 3.1343426091E+00, 1.8319063039E+00, 1.0524354353E+00, 9.0547890596E-01],
	[4.5415000000E+04, 1.1732196334E+01, 3.1343590683E+00, 1.8325364516E+00, 1.0526628677E+00, 9.0549851217E-01],
	[4.5420000000E+04, 1.1734385320E+01, 3.1343755258E+00, 1.8331667466E+00, 1.0528902986E+00, 9.0551811450E-01],
	[4.5425000000E+04, 1.1736574473E+01, 3.1343919816E+00, 1.8337971889E+00, 1.0531177278E+00, 9.0553771295E-01],
	[4.5430000000E+04, 1.1738763793E+01, 3.1344084357E+00, 1.8344277785E+00, 1.0533451554E+00, 9.0555730753E-01],
	[4.5435000000E+04, 1.1740953281E+01, 3.1344248880E+00, 1.8350585155E+00, 1.0535725813E+00, 9.0557689823E-01],
	[4.5440000000E+04, 1.1743142936E+01, 3.1344413386E+00, 1.8356893998E+00, 1.0538000057E+00, 9.0559648505E-01],
	[4.5445000000E+04, 1.1745332758E+01, 3.1344577875E+00, 1.8363204314E+00, 1.0540274283E+00, 9.0561606800E-01],
	[4.5450000000E+04, 1.1747522748E+01, 3.1344742346E+00, 1.8369516105E+00, 1.0542548493E+00, 9.0563564707E-01],
	[4.5455000000E+04, 1.1749712905E+01, 3.1344906800E+00, 1.8375829370E+00, 1.0544822687E+00, 9.0565522227E-01],
	[4.5460000000E+04, 1.1751903230E+01, 3.1345071238E+00, 1.8382144109E+00, 1.0547096863E+00, 9.0567479360E-01],
	[4.5465000000E+04, 1.1754093722E+01, 3.1345235657E+00, 1.8388460322E+00, 1.0549371023E+00, 9.0569436105E-01],
	[4.5470000000E+04, 1.1756284381E+01, 3.1345400060E+00, 1.8394778010E+00, 1.0551645165E+00, 9.0571392464E-01],
	[4.5475000000E+04, 1.1758475208E+01, 3.1345564446E+00, 1.8401097173E+00, 1.0553919290E+00, 9.0573348435E-01],
	[4.5480000000E+04, 1.1760666201E+01, 3.1345728814E+00, 1.8407417811E+00, 1.0556193399E+00, 9.0575304019E-01],
	[4.5485000000E+04, 1.1762857363E+01, 3.1345893165E+00, 1.8413739924E+00, 1.0558467489E+00, 9.0577259216E-01],
	[4.5490000000E+04, 1.1765048691E+01, 3.1346057499E+00, 1.8420063512E+00, 1.0560741563E+00, 9.0579214026E-01],
	[4.5495000000E+04, 1.1767240187E+01, 3.1346221815E+00, 1.8426388576E+00, 1.0563015618E+00, 9.0581168450E-01],
	[4.5500000000E+04, 1.1769431850E+01, 3.1346386115E+00, 1.8432715116E+00, 1.0565289656E+00, 9.0583122486E-01],
	[4.5505000000E+04, 1.1771623681E+01, 3.1346550397E+00, 1.8439043132E+00, 1.0567563676E+00, 9.0585076136E-01],
	[4.5510000000E+04, 1.1773815678E+01, 3.1346714662E+00, 1.8445372623E+00, 1.0569837679E+00, 9.0587029400E-01],
	[4.5515000000E+04, 1.1776007844E+01, 3.1346878910E+00, 1.8451703591E+00, 1.0572111663E+00, 9.0588982277E-01],
	[4.5520000000E+04, 1.1778200176E+01, 3.1347043140E+00, 1.8458036036E+00, 1.0574385630E+00, 9.0590934767E-01],
	[4.5525000000E+04, 1.1780392675E+01, 3.1347207354E+00, 1.8464369957E+00, 1.0576659578E+00, 9.0592886871E-01],
	[4.5530000000E+04, 1.1782585342E+01, 3.1347371550E+00, 1.8470705354E+00, 1.0578933508E+00, 9.0594838588E-01],
	[4.5535000000E+04, 1.1784778177E+01, 3.1347535729E+00, 1.8477042229E+00, 1.0581207419E+00, 9.0596789920E-01],
	[4.5540000000E+04, 1.1786971178E+01, 3.1347699891E+00, 1.8483380581E+00, 1.0583481312E+00, 9.0598740865E-01],
	[4.5545000000E+04, 1.1789164347E+01, 3.1347864036E+00, 1.8489720411E+00, 1.0585755186E+00, 9.0600691424E-01],
	[4.5550000000E+04, 1.1791357683E+01, 3.1348028164E+00, 1.8496061718E+00, 1.0588029042E+00, 9.0602641597E-01],
	[4.5555000000E+04, 1.1793551186E+01, 3.1348192274E+00, 1.8502404502E+00, 1.0590302879E+00, 9.0604591384E-01],
	[4.5560000000E+04, 1.1795744856E+01, 3.1348356368E+00, 1.8508748765E+00, 1.0592576697E+00, 9.0606540785E-01],
	[4.5565000000E+04, 1.1797938694E+01, 3.1348520444E+00, 1.8515094505E+00, 1.0594850496E+00, 9.0608489800E-01],
	[4.5570000000E+04, 1.1800132699E+01, 3.1348684503E+00, 1.8521441724E+00, 1.0597124276E+00, 9.0610438429E-01],
	[4.5575000000E+04, 1.1802326871E+01, 3.1348848545E+00, 1.8527790422E+00, 1.0599398037E+00, 9.0612386673E-01],
	[4.5580000000E+04, 1.1804521210E+01, 3.1349012570E+00, 1.8534140597E+00, 1.0601671778E+00, 9.0614334530E-01],
	[4.5585000000E+04, 1.1806715717E+01, 3.1349176577E+00, 1.8540492252E+00, 1.0603945500E+00, 9.0616282003E-01],
	[4.5590000000E+04, 1.1808910391E+01, 3.1349340568E+00, 1.8546845386E+00, 1.0606219203E+00, 9.0618229090E-01],
	[4.5595000000E+04, 1.1811105232E+01, 3.1349504541E+00, 1.8553199999E+00, 1.0608492886E+00, 9.0620175791E-01],
	[4.5600000000E+04, 1.1813300240E+01, 3.1349668497E+00, 1.8559556091E+00, 1.0610766549E+00, 9.0622122107E-01],
	[4.5605000000E+04, 1.1815495415E+01, 3.1349832437E+00, 1.8565913663E+00, 1.0613040192E+00, 9.0624068038E-01],
	[4.5610000000E+04, 1.1817690758E+01, 3.1349996359E+00, 1.8572272715E+00, 1.0615313816E+00, 9.0626013583E-01],
	[4.5615000000E+04, 1.1819886268E+01, 3.1350160263E+00, 1.8578633246E+00, 1.0617587419E+00, 9.0627958743E-01],
	[4.5620000000E+04, 1.1822081945E+01, 3.1350324151E+00, 1.8584995258E+00, 1.0619861002E+00, 9.0629903519E-01],
	[4.5625000000E+04, 1.1824277789E+01, 3.1350488022E+00, 1.8591358750E+00, 1.0622134565E+00, 9.0631847909E-01],
	[4.5630000000E+04, 1.1826473800E+01, 3.1350651876E+00, 1.8597723722E+00, 1.0624408108E+00, 9.0633791914E-01],
	[4.5635000000E+04, 1.1828669978E+01, 3.1350815712E+00, 1.8604090175E+00, 1.0626681631E+00, 9.0635735534E-01],
	[4.5640000000E+04, 1.1830866324E+01, 3.1350979531E+00, 1.8610458108E+00, 1.0628955132E+00, 9.0637678769E-01],
	[4.5645000000E+04, 1.1833062837E+01, 3.1351143334E+00, 1.8616827523E+00, 1.0631228614E+00, 9.0639621620E-01],
	[4.5650000000E+04, 1.1835259516E+01, 3.1351307119E+00, 1.8623198419E+00, 1.0633502074E+00, 9.0641564086E-01],
	[4.5655000000E+04, 1.1837456363E+01, 3.1351470887E+00, 1.8629570796E+00, 1.0635775514E+00, 9.0643506167E-01],
	[4.5660000000E+04, 1.1839653377E+01, 3.1351634638E+00, 1.8635944655E+00, 1.0638048932E+00, 9.0645447864E-01],
	[4.5665000000E+04, 1.1841850559E+01, 3.1351798372E+00, 1.8642319996E+00, 1.0640322330E+00, 9.0647389177E-01],
	[4.5670000000E+04, 1.1844047907E+01, 3.1351962089E+00, 1.8648696818E+00, 1.0642595706E+00, 9.0649330104E-01],
	[4.5675000000E+04, 1.1846245423E+01, 3.1352125789E+00, 1.8655075123E+00, 1.0644869062E+00, 9.0651270648E-01],
	[4.5680000000E+04, 1.1848443105E+01, 3.1352289472E+00, 1.8661454909E+00, 1.0647142396E+00, 9.0653210807E-01],
	[4.5685000000E+04, 1.1850640955E+01, 3.1352453138E+00, 1.8667836179E+00, 1.0649415708E+00, 9.0655150582E-01],
	[4.5690000000E+04, 1.1852838972E+01, 3.1352616786E+00, 1.8674218930E+00, 1.0651688999E+00, 9.0657089973E-01],
	[4.5695000000E+04, 1.1855037155E+01, 3.1352780418E+00, 1.8680603165E+00, 1.0653962268E+00, 9.0659028980E-01],
	[4.5700000000E+04, 1.1857235506E+01, 3.1352944032E+00, 1.8686988883E+00, 1.0656235516E+00, 9.0660967603E-01],
	[4.5705000000E+04, 1.1859434024E+01, 3.1353107630E+00, 1.8693376084E+00, 1.0658508741E+00, 9.0662905842E-01],
	[4.5710000000E+04, 1.1861632709E+01, 3.1353271210E+00, 1.8699764768E+00, 1.0660781945E+00, 9.0664843697E-01],
	[4.5715000000E+04, 1.1863831562E+01, 3.1353434774E+00, 1.8706154936E+00, 1.0663055127E+00, 9.0666781168E-01],
	[4.5720000000E+04, 1.1866030581E+01, 3.1353598320E+00, 1.8712546587E+00, 1.0665328286E+00, 9.0668718255E-01],
	[4.5725000000E+04, 1.1868229767E+01, 3.1353761850E+00, 1.8718939723E+00, 1.0667601424E+00, 9.0670654959E-01],
	[4.5730000000E+04, 1.1870429121E+01, 3.1353925362E+00, 1.8725334342E+00, 1.0669874539E+00, 9.0672591279E-01],
	[4.5735000000E+04, 1.1872628641E+01, 3.1354088857E+00, 1.8731730446E+00, 1.0672147631E+00, 9.0674527216E-01],
	[4.5740000000E+04, 1.1874828328E+01, 3.1354252336E+00, 1.8738128034E+00, 1.0674420701E+00, 9.0676462769E-01],
	[4.5745000000E+04, 1.1877028183E+01, 3.1354415797E+00, 1.8744527107E+00, 1.0676693748E+00, 9.0678397939E-01],
	[4.5750000000E+04, 1.1879228204E+01, 3.1354579241E+00, 1.8750927665E+00, 1.0678966773E+00, 9.0680332726E-01],
	[4.5755000000E+04, 1.1881428393E+01, 3.1354742668E+00, 1.8757329707E+00, 1.0681239774E+00, 9.0682267129E-01],
	[4.5760000000E+04, 1.1883628748E+01, 3.1354906079E+00, 1.8763733235E+00, 1.0683512753E+00, 9.0684201149E-01],
	[4.5765000000E+04, 1.1885829271E+01, 3.1355069472E+00, 1.8770138248E+00, 1.0685785708E+00, 9.0686134786E-01],
	[4.5770000000E+04, 1.1888029961E+01, 3.1355232848E+00, 1.8776544747E+00, 1.0688058641E+00, 9.0688068040E-01],
	[4.5775000000E+04, 1.1890230817E+01, 3.1355396207E+00, 1.8782952731E+00, 1.0690331550E+00, 9.0690000911E-01],
	[4.5780000000E+04, 1.1892431841E+01, 3.1355559550E+00, 1.8789362202E+00, 1.0692604436E+00, 9.0691933400E-01],
	[4.5785000000E+04, 1.1894633031E+01, 3.1355722875E+00, 1.8795773158E+00, 1.0694877298E+00, 9.0693865505E-01],
	[4.5790000000E+04, 1.1896834389E+01, 3.1355886183E+00, 1.8802185601E+00, 1.0697150137E+00, 9.0695797227E-01],
	[4.5795000000E+04, 1.1899035913E+01, 3.1356049475E+00, 1.8808599530E+00, 1.0699422952E+00, 9.0697728567E-01],
	[4.5800000000E+04, 1.1901237605E+01, 3.1356212749E+00, 1.8815014946E+00, 1.0701695743E+00, 9.0699659524E-01],
	[4.5805000000E+04, 1.1903439463E+01, 3.1356376006E+00, 1.8821431849E+00, 1.0703968511E+00, 9.0701590099E-01],
	[4.5810000000E+04, 1.1905641489E+01, 3.1356539247E+00, 1.8827850238E+00, 1.0706241254E+00, 9.0703520291E-01],
	[4.5815000000E+04, 1.1907843681E+01, 3.1356702470E+00, 1.8834270115E+00, 1.0708513973E+00, 9.0705450101E-01],
	[4.5820000000E+04, 1.1910046040E+01, 3.1356865676E+00, 1.8840691479E+00, 1.0710786669E+00, 9.0707379528E-01],
	[4.5825000000E+04, 1.1912248567E+01, 3.1357028866E+00, 1.8847114331E+00, 1.0713059340E+00, 9.0709308573E-01],
	[4.5830000000E+04, 1.1914451260E+01, 3.1357192039E+00, 1.8853538671E+00, 1.0715331986E+00, 9.0711237236E-01],
	[4.5835000000E+04, 1.1916654120E+01, 3.1357355194E+00, 1.8859964498E+00, 1.0717604608E+00, 9.0713165517E-01],
	[4.5840000000E+04, 1.1918857147E+01, 3.1357518333E+00, 1.8866391814E+00, 1.0719877206E+00, 9.0715093416E-01],
	[4.5845000000E+04, 1.1921060341E+01, 3.1357681454E+00, 1.8872820617E+00, 1.0722149778E+00, 9.0717020932E-01],
	[4.5850000000E+04, 1.1923263702E+01, 3.1357844559E+00, 1.8879250910E+00, 1.0724422326E+00, 9.0718948067E-01],
	[4.5855000000E+04, 1.1925467230E+01, 3.1358007647E+00, 1.8885682690E+00, 1.0726694850E+00, 9.0720874820E-01],
	[4.5860000000E+04, 1.1927670925E+01, 3.1358170718E+00, 1.8892115960E+00, 1.0728967348E+00, 9.0722801191E-01],
	[4.5865000000E+04, 1.1929874786E+01, 3.1358333772E+00, 1.8898550719E+00, 1.0731239821E+00, 9.0724727180E-01],
	[4.5870000000E+04, 1.1932078815E+01, 3.1358496809E+00, 1.8904986967E+00, 1.0733512269E+00, 9.0726652788E-01],
	[4.5875000000E+04, 1.1934283010E+01, 3.1358659829E+00, 1.8911424704E+00, 1.0735784691E+00, 9.0728578014E-01],
	[4.5880000000E+04, 1.1936487373E+01, 3.1358822832E+00, 1.8917863931E+00, 1.0738057089E+00, 9.0730502859E-01],
	[4.5885000000E+04, 1.1938691902E+01, 3.1358985818E+00, 1.8924304647E+00, 1.0740329460E+00, 9.0732427322E-01],
	[4.5890000000E+04, 1.1940896598E+01, 3.1359148788E+00, 1.8930746854E+00, 1.0742601807E+00, 9.0734351403E-01],
	[4.5895000000E+04, 1.1943101461E+01, 3.1359311740E+00, 1.8937190550E+00, 1.0744874127E+00, 9.0736275104E-01],
	[4.5900000000E+04, 1.1945306491E+01, 3.1359474676E+00, 1.8943635737E+00, 1.0747146422E+00, 9.0738198423E-01],
	[4.5905000000E+04, 1.1947511687E+01, 3.1359637594E+00, 1.8950082414E+00, 1.0749418691E+00, 9.0740121361E-01],
	[4.5910000000E+04, 1.1949717051E+01, 3.1359800496E+00, 1.8956530582E+00, 1.0751690933E+00, 9.0742043918E-01],
	[4.5915000000E+04, 1.1951922581E+01, 3.1359963381E+00, 1.8962980241E+00, 1.0753963150E+00, 9.0743966094E-01],
	[4.5920000000E+04, 1.1954128278E+01, 3.1360126249E+00, 1.8969431390E+00, 1.0756235341E+00, 9.0745887888E-01],
	[4.5925000000E+04, 1.1956334142E+01, 3.1360289100E+00, 1.8975884031E+00, 1.0758507505E+00, 9.0747809302E-01],
	[4.5930000000E+04, 1.1958540173E+01, 3.1360451934E+00, 1.8982338164E+00, 1.0760779643E+00, 9.0749730335E-01],
	[4.5935000000E+04, 1.1960746371E+01, 3.1360614752E+00, 1.8988793787E+00, 1.0763051754E+00, 9.0751650988E-01],
	[4.5940000000E+04, 1.1962952735E+01, 3.1360777552E+00, 1.8995250903E+00, 1.0765323839E+00, 9.0753571259E-01],
	[4.5945000000E+04, 1.1965159267E+01, 3.1360940336E+00, 1.9001709510E+00, 1.0767595897E+00, 9.0755491150E-01],
	[4.5950000000E+04, 1.1967365965E+01, 3.1361103102E+00, 1.9008169610E+00, 1.0769867929E+00, 9.0757410661E-01],
	[4.5955000000E+04, 1.1969572830E+01, 3.1361265852E+00, 1.9014631202E+00, 1.0772139933E+00, 9.0759329791E-01],
	[4.5960000000E+04, 1.1971779861E+01, 3.1361428585E+00, 1.9021094286E+00, 1.0774411911E+00, 9.0761248540E-01],
	[4.5965000000E+04, 1.1973987060E+01, 3.1361591301E+00, 1.9027558863E+00, 1.0776683861E+00, 9.0763166909E-01],
	[4.5970000000E+04, 1.1976194425E+01, 3.1361754000E+00, 1.9034024933E+00, 1.0778955784E+00, 9.0765084898E-01],
	[4.5975000000E+04, 1.1978401957E+01, 3.1361916683E+00, 1.9040492496E+00, 1.0781227680E+00, 9.0767002507E-01],
	[4.5980000000E+04, 1.1980609656E+01, 3.1362079348E+00, 1.9046961552E+00, 1.0783499549E+00, 9.0768919736E-01],
	[4.5985000000E+04, 1.1982817522E+01, 3.1362241997E+00, 1.9053432101E+00, 1.0785771390E+00, 9.0770836584E-01],
	[4.5990000000E+04, 1.1985025554E+01, 3.1362404629E+00, 1.9059904144E+00, 1.0788043203E+00, 9.0772753053E-01],
	[4.5995000000E+04, 1.1987233753E+01, 3.1362567244E+00, 1.9066377681E+00, 1.0790314989E+00, 9.0774669141E-01],
	[4.6000000000E+04, 1.1989442119E+01, 3.1362729842E+00, 1.9072852711E+00, 1.0792586747E+00, 9.0776584850E-01],
	[4.6005000000E+04, 1.1991650652E+01, 3.1362892424E+00, 1.9079329236E+00, 1.0794858477E+00, 9.0778500179E-01],
	[4.6010000000E+04, 1.1993859351E+01, 3.1363054988E+00, 1.9085807255E+00, 1.0797130179E+00, 9.0780415128E-01],
	[4.6015000000E+04, 1.1996068217E+01, 3.1363217536E+00, 1.9092286768E+00, 1.0799401853E+00, 9.0782329697E-01],
	[4.6020000000E+04, 1.1998277250E+01, 3.1363380067E+00, 1.9098767776E+00, 1.0801673499E+00, 9.0784243887E-01],
	[4.6025000000E+04, 1.2000486450E+01, 3.1363542581E+00, 1.9105250279E+00, 1.0803945117E+00, 9.0786157697E-01],
	[4.6030000000E+04, 1.2002695816E+01, 3.1363705078E+00, 1.9111734277E+00, 1.0806216706E+00, 9.0788071128E-01],
	[4.6035000000E+04, 1.2004909757E+01, 3.1363876852E+00, 1.9118219770E+00, 1.0808489728E+00, 9.0789984180E-01],
	[4.6040000000E+04, 1.2007125135E+01, 3.1364051281E+00, 1.9124706759E+00, 1.0810763142E+00, 9.0791896852E-01],
	[4.6045000000E+04, 1.2009340681E+01, 3.1364225693E+00, 1.9131195243E+00, 1.0813036530E+00, 9.0793809145E-01],
	[4.6050000000E+04, 1.2011556395E+01, 3.1364400087E+00, 1.9137685222E+00, 1.0815309889E+00, 9.0795721059E-01],
	[4.6055000000E+04, 1.2013772277E+01, 3.1364574463E+00, 1.9144176698E+00, 1.0817583221E+00, 9.0797632593E-01],
	[4.6060000000E+04, 1.2015988328E+01, 3.1364748821E+00, 1.9150669670E+00, 1.0819856525E+00, 9.0799543749E-01],
	[4.6065000000E+04, 1.2018204546E+01, 3.1364923161E+00, 1.9157164138E+00, 1.0822129801E+00, 9.0801454526E-01],
	[4.6070000000E+04, 1.2020420933E+01, 3.1365097483E+00, 1.9163660102E+00, 1.0824403049E+00, 9.0803364923E-01],
	[4.6075000000E+04, 1.2022637488E+01, 3.1365271787E+00, 1.9170157564E+00, 1.0826676269E+00, 9.0805274942E-01],
	[4.6080000000E+04, 1.2024854211E+01, 3.1365446074E+00, 1.9176656522E+00, 1.0828949461E+00, 9.0807184582E-01],
	[4.6085000000E+04, 1.2027071102E+01, 3.1365620342E+00, 1.9183156977E+00, 1.0831222625E+00, 9.0809093844E-01],
	[4.6090000000E+04, 1.2029288161E+01, 3.1365794592E+00, 1.9189658929E+00, 1.0833495760E+00, 9.0811002727E-01],
	[4.6095000000E+04, 1.2031505389E+01, 3.1365968824E+00, 1.9196162378E+00, 1.0835768867E+00, 9.0812911231E-01],
	[4.6100000000E+04, 1.2033722784E+01, 3.1366143039E+00, 1.9202667326E+00, 1.0838041945E+00, 9.0814819357E-01],
	[4.6105000000E+04, 1.2035940348E+01, 3.1366317235E+00, 1.9209173771E+00, 1.0840314995E+00, 9.0816727104E-01],
	[4.6110000000E+04, 1.2038158080E+01, 3.1366491414E+00, 1.9215681713E+00, 1.0842588016E+00, 9.0818634473E-01],
	[4.6115000000E+04, 1.2040375980E+01, 3.1366665575E+00, 1.9222191154E+00, 1.0844861008E+00, 9.0820541464E-01],
	[4.6120000000E+04, 1.2042594047E+01, 3.1366839717E+00, 1.9228702094E+00, 1.0847133970E+00, 9.0822448076E-01],
	[4.6125000000E+04, 1.2044812283E+01, 3.1367013842E+00, 1.9235214531E+00, 1.0849406904E+00, 9.0824354311E-01],
	[4.6130000000E+04, 1.2047030688E+01, 3.1367187949E+00, 1.9241728468E+00, 1.0851679809E+00, 9.0826260167E-01],
	[4.6135000000E+04, 1.2049249260E+01, 3.1367362038E+00, 1.9248243903E+00, 1.0853952684E+00, 9.0828165645E-01],
	[4.6140000000E+04, 1.2051468000E+01, 3.1367536109E+00, 1.9254760837E+00, 1.0856225530E+00, 9.0830070745E-01],
	[4.6145000000E+04, 1.2053686908E+01, 3.1367710163E+00, 1.9261279270E+00, 1.0858498347E+00, 9.0831975468E-01],
	[4.6150000000E+04, 1.2055905985E+01, 3.1367884198E+00, 1.9267799203E+00, 1.0860771134E+00, 9.0833879813E-01],
	[4.6155000000E+04, 1.2058125229E+01, 3.1368058215E+00, 1.9274320635E+00, 1.0863043891E+00, 9.0835783779E-01],
	[4.6160000000E+04, 1.2060344642E+01, 3.1368232215E+00, 1.9280843568E+00, 1.0865316619E+00, 9.0837687369E-01],
	[4.6165000000E+04, 1.2062564222E+01, 3.1368406197E+00, 1.9287368000E+00, 1.0867589317E+00, 9.0839590580E-01],
	[4.6170000000E+04, 1.2064783971E+01, 3.1368580160E+00, 1.9293893932E+00, 1.0869861984E+00, 9.0841493415E-01],
	[4.6175000000E+04, 1.2067003888E+01, 3.1368754106E+00, 1.9300421364E+00, 1.0872134622E+00, 9.0843395871E-01],
	[4.6180000000E+04, 1.2069223972E+01, 3.1368928034E+00, 1.9306950297E+00, 1.0874407229E+00, 9.0845297951E-01],
	[4.6185000000E+04, 1.2071444225E+01, 3.1369101945E+00, 1.9313480731E+00, 1.0876679807E+00, 9.0847199653E-01],
	[4.6190000000E+04, 1.2073664646E+01, 3.1369275837E+00, 1.9320012665E+00, 1.0878952354E+00, 9.0849100977E-01],
	[4.6195000000E+04, 1.2075885234E+01, 3.1369449711E+00, 1.9326546100E+00, 1.0881224870E+00, 9.0851001925E-01],
	[4.6200000000E+04, 1.2078105991E+01, 3.1369623568E+00, 1.9333081037E+00, 1.0883497356E+00, 9.0852902495E-01],
	[4.6205000000E+04, 1.2080326916E+01, 3.1369797407E+00, 1.9339617475E+00, 1.0885769811E+00, 9.0854802689E-01],
	[4.6210000000E+04, 1.2082548008E+01, 3.1369971228E+00, 1.9346155415E+00, 1.0888042236E+00, 9.0856702505E-01],
	[4.6215000000E+04, 1.2084769269E+01, 3.1370145031E+00, 1.9352694856E+00, 1.0890314630E+00, 9.0858601945E-01],
	[4.6220000000E+04, 1.2086990698E+01, 3.1370318816E+00, 1.9359235799E+00, 1.0892586992E+00, 9.0860501008E-01],
	[4.6225000000E+04, 1.2089212295E+01, 3.1370492583E+00, 1.9365778244E+00, 1.0894859324E+00, 9.0862399694E-01],
	[4.6230000000E+04, 1.2091434059E+01, 3.1370666333E+00, 1.9372322192E+00, 1.0897131625E+00, 9.0864298003E-01],
	[4.6235000000E+04, 1.2093655992E+01, 3.1370840065E+00, 1.9378867642E+00, 1.0899403894E+00, 9.0866195935E-01],
	[4.6240000000E+04, 1.2095878092E+01, 3.1371013779E+00, 1.9385414595E+00, 1.0901676132E+00, 9.0868093492E-01],
	[4.6245000000E+04, 1.2098100361E+01, 3.1371187475E+00, 1.9391963051E+00, 1.0903948338E+00, 9.0869990671E-01],
	[4.6250000000E+04, 1.2100322797E+01, 3.1371361153E+00, 1.9398513009E+00, 1.0906220513E+00, 9.0871887474E-01],
	[4.6255000000E+04, 1.2102545402E+01, 3.1371534813E+00, 1.9405064471E+00, 1.0908492657E+00, 9.0873783901E-01],
	[4.6260000000E+04, 1.2104768174E+01, 3.1371708456E+00, 1.9411617437E+00, 1.0910764768E+00, 9.0875679952E-01],
	[4.6265000000E+04, 1.2106991115E+01, 3.1371882081E+00, 1.9418171905E+00, 1.0913036848E+00, 9.0877575626E-01],
	[4.6270000000E+04, 1.2109214223E+01, 3.1372055688E+00, 1.9424727878E+00, 1.0915308896E+00, 9.0879470924E-01],
	[4.6275000000E+04, 1.2111437499E+01, 3.1372229277E+00, 1.9431285354E+00, 1.0917580912E+00, 9.0881365846E-01],
	[4.6280000000E+04, 1.2113660943E+01, 3.1372402849E+00, 1.9437844335E+00, 1.0919852896E+00, 9.0883260392E-01],
	[4.6285000000E+04, 1.2115884555E+01, 3.1372576402E+00, 1.9444404820E+00, 1.0922124847E+00, 9.0885154563E-01],
	[4.6290000000E+04, 1.2118108335E+01, 3.1372749938E+00, 1.9450966809E+00, 1.0924396766E+00, 9.0887048357E-01],
	[4.6295000000E+04, 1.2120332283E+01, 3.1372923456E+00, 1.9457530304E+00, 1.0926668653E+00, 9.0888941776E-01],
	[4.6300000000E+04, 1.2122556399E+01, 3.1373096957E+00, 1.9464095302E+00, 1.0928940507E+00, 9.0890834818E-01],
	[4.6305000000E+04, 1.2124780682E+01, 3.1373270439E+00, 1.9470661806E+00, 1.0931212329E+00, 9.0892727485E-01],
	[4.6310000000E+04, 1.2127005134E+01, 3.1373443904E+00, 1.9477229816E+00, 1.0933484118E+00, 9.0894619777E-01],
	[4.6315000000E+04, 1.2129229753E+01, 3.1373617351E+00, 1.9483799330E+00, 1.0935755874E+00, 9.0896511693E-01],
	[4.6320000000E+04, 1.2131454540E+01, 3.1373790780E+00, 1.9490370350E+00, 1.0938027597E+00, 9.0898403234E-01],
	[4.6325000000E+04, 1.2133679496E+01, 3.1373964192E+00, 1.9496942876E+00, 1.0940299288E+00, 9.0900294399E-01],
	[4.6330000000E+04, 1.2135904619E+01, 3.1374137585E+00, 1.9503516908E+00, 1.0942570945E+00, 9.0902185189E-01],
	[4.6335000000E+04, 1.2138129909E+01, 3.1374310961E+00, 1.9510092446E+00, 1.0944842569E+00, 9.0904075603E-01],
	[4.6340000000E+04, 1.2140355368E+01, 3.1374484319E+00, 1.9516669490E+00, 1.0947114159E+00, 9.0905965643E-01],
	[4.6345000000E+04, 1.2142580995E+01, 3.1374657660E+00, 1.9523248041E+00, 1.0949385717E+00, 9.0907855307E-01],
	[4.6350000000E+04, 1.2144806789E+01, 3.1374830983E+00, 1.9529828099E+00, 1.0951657240E+00, 9.0909744596E-01],
	[4.6355000000E+04, 1.2147032751E+01, 3.1375004288E+00, 1.9536409663E+00, 1.0953928731E+00, 9.0911633511E-01],
	[4.6360000000E+04, 1.2149258882E+01, 3.1375177575E+00, 1.9542992734E+00, 1.0956200187E+00, 9.0913522050E-01],
	[4.6365000000E+04, 1.2151485179E+01, 3.1375350844E+00, 1.9549577313E+00, 1.0958471610E+00, 9.0915410215E-01],
	[4.6370000000E+04, 1.2153711645E+01, 3.1375524096E+00, 1.9556163399E+00, 1.0960742999E+00, 9.0917298005E-01],
	[4.6375000000E+04, 1.2155938279E+01, 3.1375697330E+00, 1.9562750992E+00, 1.0963014354E+00, 9.0919185420E-01],
	[4.6380000000E+04, 1.2158165080E+01, 3.1375870546E+00, 1.9569340093E+00, 1.0965285674E+00, 9.0921072460E-01],
	[4.6385000000E+04, 1.2160392049E+01, 3.1376043745E+00, 1.9575930703E+00, 1.0967556961E+00, 9.0922959126E-01],
	[4.6390000000E+04, 1.2162619186E+01, 3.1376216926E+00, 1.9582522820E+00, 1.0969828213E+00, 9.0924845418E-01],
	[4.6395000000E+04, 1.2164846491E+01, 3.1376390089E+00, 1.9589116446E+00, 1.0972099431E+00, 9.0926731335E-01],
	[4.6400000000E+04, 1.2167073964E+01, 3.1376563235E+00, 1.9595711580E+00, 1.0974370615E+00, 9.0928616877E-01],
	[4.6405000000E+04, 1.2169301604E+01, 3.1376736362E+00, 1.9602308223E+00, 1.0976641764E+00, 9.0930502046E-01],
	[4.6410000000E+04, 1.2171529412E+01, 3.1376909473E+00, 1.9608906374E+00, 1.0978912878E+00, 9.0932386840E-01],
	[4.6415000000E+04, 1.2173757388E+01, 3.1377082565E+00, 1.9615506035E+00, 1.0981183958E+00, 9.0934271260E-01],
	[4.6420000000E+04, 1.2175985532E+01, 3.1377255640E+00, 1.9622107205E+00, 1.0983455002E+00, 9.0936155306E-01],
	[4.6425000000E+04, 1.2178213843E+01, 3.1377428697E+00, 1.9628709884E+00, 1.0985726012E+00, 9.0938038978E-01],
	[4.6430000000E+04, 1.2180442322E+01, 3.1377601736E+00, 1.9635314073E+00, 1.0987996987E+00, 9.0939922276E-01],
	[4.6435000000E+04, 1.2182670969E+01, 3.1377774758E+00, 1.9641919772E+00, 1.0990267926E+00, 9.0941805201E-01],
	[4.6440000000E+04, 1.2184899784E+01, 3.1377947762E+00, 1.9648526981E+00, 1.0992538831E+00, 9.0943687751E-01],
	[4.6445000000E+04, 1.2187128766E+01, 3.1378120748E+00, 1.9655135699E+00, 1.0994809700E+00, 9.0945569928E-01],
	[4.6450000000E+04, 1.2189357916E+01, 3.1378293717E+00, 1.9661745928E+00, 1.0997080533E+00, 9.0947451731E-01],
	[4.6455000000E+04, 1.2191587234E+01, 3.1378466668E+00, 1.9668357668E+00, 1.0999351331E+00, 9.0949333160E-01],
	[4.6460000000E+04, 1.2193816720E+01, 3.1378639601E+00, 1.9674970918E+00, 1.1001622094E+00, 9.0951214216E-01],
	[4.6465000000E+04, 1.2196046373E+01, 3.1378812517E+00, 1.9681585679E+00, 1.1003892820E+00, 9.0953094899E-01],
	[4.6470000000E+04, 1.2198276194E+01, 3.1378985415E+00, 1.9688201952E+00, 1.1006163511E+00, 9.0954975208E-01],
	[4.6475000000E+04, 1.2200506183E+01, 3.1379158295E+00, 1.9694819735E+00, 1.1008434166E+00, 9.0956855144E-01],
	[4.6480000000E+04, 1.2202736340E+01, 3.1379331158E+00, 1.9701439030E+00, 1.1010704785E+00, 9.0958734706E-01],
	[4.6485000000E+04, 1.2204966664E+01, 3.1379504003E+00, 1.9708059836E+00, 1.1012975368E+00, 9.0960613896E-01],
	[4.6490000000E+04, 1.2207197155E+01, 3.1379676830E+00, 1.9714682154E+00, 1.1015245915E+00, 9.0962492712E-01],
	[4.6495000000E+04, 1.2209427815E+01, 3.1379849640E+00, 1.9721305985E+00, 1.1017516425E+00, 9.0964371155E-01],
	[4.6500000000E+04, 1.2211658642E+01, 3.1380022432E+00, 1.9727931327E+00, 1.1019786899E+00, 9.0966249225E-01],
	[4.6505000000E+04, 1.2213889637E+01, 3.1380195207E+00, 1.9734558181E+00, 1.1022057336E+00, 9.0968126923E-01],
	[4.6510000000E+04, 1.2216120800E+01, 3.1380367964E+00, 1.9741186548E+00, 1.1024327737E+00, 9.0970004247E-01],
	[4.6515000000E+04, 1.2218352130E+01, 3.1380540703E+00, 1.9747816428E+00, 1.1026598101E+00, 9.0971881199E-01],
	[4.6520000000E+04, 1.2220583628E+01, 3.1380713425E+00, 1.9754447821E+00, 1.1028868428E+00, 9.0973757778E-01],
	[4.6525000000E+04, 1.2222815293E+01, 3.1380886129E+00, 1.9761080727E+00, 1.1031138719E+00, 9.0975633985E-01],
	[4.6530000000E+04, 1.2225047126E+01, 3.1381058815E+00, 1.9767715146E+00, 1.1033408972E+00, 9.0977509819E-01],
	[4.6535000000E+04, 1.2227279127E+01, 3.1381231484E+00, 1.9774351078E+00, 1.1035679189E+00, 9.0979385280E-01],
	[4.6540000000E+04, 1.2229511296E+01, 3.1381404135E+00, 1.9780988524E+00, 1.1037949368E+00, 9.0981260369E-01],
	[4.6545000000E+04, 1.2231743632E+01, 3.1381576769E+00, 1.9787627484E+00, 1.1040219510E+00, 9.0983135086E-01],
	[4.6550000000E+04, 1.2233976136E+01, 3.1381749385E+00, 1.9794267957E+00, 1.1042489615E+00, 9.0985009430E-01],
	[4.6555000000E+04, 1.2236208807E+01, 3.1381921983E+00, 1.9800909945E+00, 1.1044759682E+00, 9.0986883402E-01],
	[4.6560000000E+04, 1.2238441646E+01, 3.1382094564E+00, 1.9807553447E+00, 1.1047029711E+00, 9.0988757002E-01],
	[4.6565000000E+04, 1.2240674652E+01, 3.1382267128E+00, 1.9814198464E+00, 1.1049299703E+00, 9.0990630230E-01],
	[4.6570000000E+04, 1.2242907827E+01, 3.1382439673E+00, 1.9820844995E+00, 1.1051569657E+00, 9.0992503086E-01],
	[4.6575000000E+04, 1.2245141168E+01, 3.1382612201E+00, 1.9827493041E+00, 1.1053839574E+00, 9.0994375570E-01],
	[4.6580000000E+04, 1.2247374678E+01, 3.1382784712E+00, 1.9834142603E+00, 1.1056109452E+00, 9.0996247683E-01],
	[4.6585000000E+04, 1.2249608355E+01, 3.1382957205E+00, 1.9840793679E+00, 1.1058379292E+00, 9.0998119423E-01],
	[4.6590000000E+04, 1.2251842199E+01, 3.1383129680E+00, 1.9847446271E+00, 1.1060649095E+00, 9.0999990792E-01],
	[4.6595000000E+04, 1.2254076211E+01, 3.1383302138E+00, 1.9854100379E+00, 1.1062918859E+00, 9.1001861789E-01],
	[4.6600000000E+04, 1.2256310391E+01, 3.1383474579E+00, 1.9860756002E+00, 1.1065188584E+00, 9.1003732414E-01],
	[4.6605000000E+04, 1.2258544738E+01, 3.1383647001E+00, 1.9867413141E+00, 1.1067458271E+00, 9.1005602668E-01],
	[4.6610000000E+04, 1.2260779253E+01, 3.1383819407E+00, 1.9874071797E+00, 1.1069727920E+00, 9.1007472551E-01],
	[4.6615000000E+04, 1.2263013936E+01, 3.1383991794E+00, 1.9880731968E+00, 1.1071997530E+00, 9.1009342062E-01],
	[4.6620000000E+04, 1.2265248785E+01, 3.1384164164E+00, 1.9887393657E+00, 1.1074267102E+00, 9.1011211201E-01],
	[4.6625000000E+04, 1.2267483803E+01, 3.1384336517E+00, 1.9894056862E+00, 1.1076536634E+00, 9.1013079970E-01],
	[4.6630000000E+04, 1.2269718988E+01, 3.1384508852E+00, 1.9900721584E+00, 1.1078806128E+00, 9.1014948367E-01],
	[4.6635000000E+04, 1.2271954340E+01, 3.1384681169E+00, 1.9907387822E+00, 1.1081075583E+00, 9.1016816394E-01],
	[4.6640000000E+04, 1.2274189861E+01, 3.1384853469E+00, 1.9914055579E+00, 1.1083344998E+00, 9.1018684049E-01],
	[4.6645000000E+04, 1.2276425548E+01, 3.1385025752E+00, 1.9920724852E+00, 1.1085614375E+00, 9.1020551333E-01],
	[4.6650000000E+04, 1.2278661403E+01, 3.1385198017E+00, 1.9927395643E+00, 1.1087883712E+00, 9.1022418247E-01],
	[4.6655000000E+04, 1.2280897426E+01, 3.1385370264E+00, 1.9934067952E+00, 1.1090153010E+00, 9.1024284789E-01],
	[4.6660000000E+04, 1.2283133616E+01, 3.1385542494E+00, 1.9940741779E+00, 1.1092422268E+00, 9.1026150961E-01],
	[4.6665000000E+04, 1.2285369974E+01, 3.1385714707E+00, 1.9947417124E+00, 1.1094691487E+00, 9.1028016762E-01],
	[4.6670000000E+04, 1.2287606499E+01, 3.1385886902E+00, 1.9954093988E+00, 1.1096960666E+00, 9.1029882193E-01],
	[4.6675000000E+04, 1.2289843191E+01, 3.1386059079E+00, 1.9960772370E+00, 1.1099229805E+00, 9.1031747253E-01],
	[4.6680000000E+04, 1.2292080052E+01, 3.1386231239E+00, 1.9967452271E+00, 1.1101498904E+00, 9.1033611942E-01],
	[4.6685000000E+04, 1.2294317079E+01, 3.1386403381E+00, 1.9974133690E+00, 1.1103767964E+00, 9.1035476261E-01],
	[4.6690000000E+04, 1.2296554274E+01, 3.1386575506E+00, 1.9980816629E+00, 1.1106036983E+00, 9.1037340210E-01],
	[4.6695000000E+04, 1.2298791637E+01, 3.1386747614E+00, 1.9987501087E+00, 1.1108305962E+00, 9.1039203788E-01],
	[4.6700000000E+04, 1.2301029167E+01, 3.1386919703E+00, 1.9994187064E+00, 1.1110574901E+00, 9.1041066996E-01],
	[4.6705000000E+04, 1.2303266864E+01, 3.1387091776E+00, 2.0000874561E+00, 1.1112843800E+00, 9.1042929835E-01],
	[4.6710000000E+04, 1.2305504729E+01, 3.1387263831E+00, 2.0007563578E+00, 1.1115112658E+00, 9.1044792303E-01],
	[4.6715000000E+04, 1.2307742762E+01, 3.1387435868E+00, 2.0014254114E+00, 1.1117381476E+00, 9.1046654401E-01],
	[4.6720000000E+04, 1.2309980961E+01, 3.1387607888E+00, 2.0020946171E+00, 1.1119650253E+00, 9.1048516129E-01],
	[4.6725000000E+04, 1.2312219329E+01, 3.1387779891E+00, 2.0027639748E+00, 1.1121918990E+00, 9.1050377487E-01],
	[4.6730000000E+04, 1.2314457863E+01, 3.1387951876E+00, 2.0034334846E+00, 1.1124187685E+00, 9.1052238475E-01],
	[4.6735000000E+04, 1.2316696565E+01, 3.1388123844E+00, 2.0041031465E+00, 1.1126456340E+00, 9.1054099094E-01],
	[4.6740000000E+04, 1.2318935435E+01, 3.1388295794E+00, 2.0047729604E+00, 1.1128724954E+00, 9.1055959343E-01],
	[4.6745000000E+04, 1.2321174472E+01, 3.1388467727E+00, 2.0054429264E+00, 1.1130993526E+00, 9.1057819223E-01],
	[4.6750000000E+04, 1.2323413676E+01, 3.1388639642E+00, 2.0061130446E+00, 1.1133262058E+00, 9.1059678733E-01],
	[4.6755000000E+04, 1.2325653048E+01, 3.1388811540E+00, 2.0067833149E+00, 1.1135530548E+00, 9.1061537873E-01],
	[4.6760000000E+04, 1.2327892587E+01, 3.1388983420E+00, 2.0074537374E+00, 1.1137798997E+00, 9.1063396644E-01],
	[4.6765000000E+04, 1.2330132294E+01, 3.1389155283E+00, 2.0081243120E+00, 1.1140067404E+00, 9.1065255046E-01],
	[4.6770000000E+04, 1.2332372168E+01, 3.1389327129E+00, 2.0087950389E+00, 1.1142335769E+00, 9.1067113079E-01],
	[4.6775000000E+04, 1.2334615470E+01, 3.1389505628E+00, 2.0094659180E+00, 1.1144605201E+00, 9.1068970742E-01],
	[4.6780000000E+04, 1.2336861413E+01, 3.1389689164E+00, 2.0101369493E+00, 1.1146875430E+00, 9.1070828037E-01],
	[4.6785000000E+04, 1.2339107525E+01, 3.1389872682E+00, 2.0108081328E+00, 1.1149145619E+00, 9.1072684962E-01],
	[4.6790000000E+04, 1.2341353806E+01, 3.1390056181E+00, 2.0114794686E+00, 1.1151415767E+00, 9.1074541518E-01],
	[4.6795000000E+04, 1.2343600256E+01, 3.1390239661E+00, 2.0121509568E+00, 1.1153685874E+00, 9.1076397706E-01],
	[4.6800000000E+04, 1.2345846874E+01, 3.1390423124E+00, 2.0128225972E+00, 1.1155955940E+00, 9.1078253525E-01],
	[4.6805000000E+04, 1.2348093661E+01, 3.1390606567E+00, 2.0134943899E+00, 1.1158225965E+00, 9.1080108974E-01],
	[4.6810000000E+04, 1.2350340617E+01, 3.1390789992E+00, 2.0141663350E+00, 1.1160495949E+00, 9.1081964056E-01],
	[4.6815000000E+04, 1.2352587742E+01, 3.1390973399E+00, 2.0148384325E+00, 1.1162765892E+00, 9.1083818768E-01],
	[4.6820000000E+04, 1.2354835036E+01, 3.1391156787E+00, 2.0155106823E+00, 1.1165035793E+00, 9.1085673112E-01],
	[4.6825000000E+04, 1.2357082499E+01, 3.1391340156E+00, 2.0161830846E+00, 1.1167305653E+00, 9.1087527088E-01],
	[4.6830000000E+04, 1.2359330130E+01, 3.1391523507E+00, 2.0168556392E+00, 1.1169575472E+00, 9.1089380695E-01],
	[4.6835000000E+04, 1.2361577930E+01, 3.1391706840E+00, 2.0175283463E+00, 1.1171845249E+00, 9.1091233934E-01],
	[4.6840000000E+04, 1.2363825899E+01, 3.1391890154E+00, 2.0182012059E+00, 1.1174114984E+00, 9.1093086804E-01],
	[4.6845000000E+04, 1.2366074036E+01, 3.1392073449E+00, 2.0188742179E+00, 1.1176384677E+00, 9.1094939307E-01],
	[4.6850000000E+04, 1.2368322343E+01, 3.1392256726E+00, 2.0195473824E+00, 1.1178654329E+00, 9.1096791441E-01],
	[4.6855000000E+04, 1.2370570818E+01, 3.1392439984E+00, 2.0202206994E+00, 1.1180923938E+00, 9.1098643207E-01],
	[4.6860000000E+04, 1.2372819462E+01, 3.1392623224E+00, 2.0208941690E+00, 1.1183193506E+00, 9.1100494605E-01],
	[4.6865000000E+04, 1.2375068275E+01, 3.1392806446E+00, 2.0215677911E+00, 1.1185463031E+00, 9.1102345635E-01],
	[4.6870000000E+04, 1.2377317256E+01, 3.1392989649E+00, 2.0222415657E+00, 1.1187732514E+00, 9.1104196298E-01],
	[4.6875000000E+04, 1.2379566406E+01, 3.1393172834E+00, 2.0229154930E+00, 1.1190001954E+00, 9.1106046592E-01],
	[4.6880000000E+04, 1.2381815725E+01, 3.1393356000E+00, 2.0235895728E+00, 1.1192271352E+00, 9.1107896519E-01],
	[4.6885000000E+04, 1.2384065213E+01, 3.1393539147E+00, 2.0242638053E+00, 1.1194540708E+00, 9.1109746078E-01],
	[4.6890000000E+04, 1.2386314869E+01, 3.1393722277E+00, 2.0249381904E+00, 1.1196810021E+00, 9.1111595270E-01],
	[4.6895000000E+04, 1.2388564695E+01, 3.1393905387E+00, 2.0256127281E+00, 1.1199079291E+00, 9.1113444094E-01],
	[4.6900000000E+04, 1.2390814689E+01, 3.1394088479E+00, 2.0262874185E+00, 1.1201348518E+00, 9.1115292551E-01],
	[4.6905000000E+04, 1.2393064851E+01, 3.1394271553E+00, 2.0269622616E+00, 1.1203617703E+00, 9.1117140640E-01],
	[4.6910000000E+04, 1.2395315182E+01, 3.1394454609E+00, 2.0276372575E+00, 1.1205886844E+00, 9.1118988362E-01],
	[4.6915000000E+04, 1.2397565682E+01, 3.1394637646E+00, 2.0283124060E+00, 1.1208155943E+00, 9.1120835717E-01],
	[4.6920000000E+04, 1.2399816351E+01, 3.1394820664E+00, 2.0289877073E+00, 1.1210424998E+00, 9.1122682704E-01],
	[4.6925000000E+04, 1.2402067189E+01, 3.1395003664E+00, 2.0296631614E+00, 1.1212694009E+00, 9.1124529325E-01],
	[4.6930000000E+04, 1.2404318195E+01, 3.1395186646E+00, 2.0303387682E+00, 1.1214962978E+00, 9.1126375578E-01],
	[4.6935000000E+04, 1.2406569369E+01, 3.1395369609E+00, 2.0310145278E+00, 1.1217231903E+00, 9.1128221465E-01],
	[4.6940000000E+04, 1.2408820713E+01, 3.1395552554E+00, 2.0316904403E+00, 1.1219500784E+00, 9.1130066984E-01],
	[4.6945000000E+04, 1.2411072225E+01, 3.1395735480E+00, 2.0323665056E+00, 1.1221769621E+00, 9.1131912137E-01],
	[4.6950000000E+04, 1.2413323906E+01, 3.1395918388E+00, 2.0330427238E+00, 1.1224038415E+00, 9.1133756923E-01],
	[4.6955000000E+04, 1.2415575755E+01, 3.1396101277E+00, 2.0337190948E+00, 1.1226307165E+00, 9.1135601343E-01],
	[4.6960000000E+04, 1.2417827773E+01, 3.1396284149E+00, 2.0343956187E+00, 1.1228575871E+00, 9.1137445395E-01],
	[4.6965000000E+04, 1.2420079960E+01, 3.1396467001E+00, 2.0350722955E+00, 1.1230844533E+00, 9.1139289081E-01],
	[4.6970000000E+04, 1.2422332316E+01, 3.1396649836E+00, 2.0357491253E+00, 1.1233113151E+00, 9.1141132401E-01],
	[4.6975000000E+04, 1.2424584840E+01, 3.1396832651E+00, 2.0364261080E+00, 1.1235381724E+00, 9.1142975354E-01],
	[4.6980000000E+04, 1.2426837532E+01, 3.1397015449E+00, 2.0371032437E+00, 1.1237650254E+00, 9.1144817941E-01],
	[4.6985000000E+04, 1.2429090394E+01, 3.1397198228E+00, 2.0377805323E+00, 1.1239918738E+00, 9.1146660162E-01],
	[4.6990000000E+04, 1.2431343424E+01, 3.1397380989E+00, 2.0384579740E+00, 1.1242187179E+00, 9.1148502017E-01],
	[4.6995000000E+04, 1.2433596622E+01, 3.1397563731E+00, 2.0391355687E+00, 1.1244455574E+00, 9.1150343505E-01],
	[4.7000000000E+04, 1.2435849990E+01, 3.1397746455E+00, 2.0398133164E+00, 1.1246723925E+00, 9.1152184627E-01],
	[4.7005000000E+04, 1.2438103525E+01, 3.1397929161E+00, 2.0404912171E+00, 1.1248992231E+00, 9.1154025384E-01],
	[4.7010000000E+04, 1.2440357230E+01, 3.1398111848E+00, 2.0411692710E+00, 1.1251260492E+00, 9.1155865774E-01],
	[4.7015000000E+04, 1.2442611103E+01, 3.1398294517E+00, 2.0418474779E+00, 1.1253528709E+00, 9.1157705798E-01],
	[4.7020000000E+04, 1.2444865144E+01, 3.1398477167E+00, 2.0425258380E+00, 1.1255796880E+00, 9.1159545457E-01],
	[4.7025000000E+04, 1.2447119355E+01, 3.1398659799E+00, 2.0432043512E+00, 1.1258065006E+00, 9.1161384750E-01],
	[4.7030000000E+04, 1.2449373733E+01, 3.1398842413E+00, 2.0438830175E+00, 1.1260333086E+00, 9.1163223678E-01],
	[4.7035000000E+04, 1.2451628281E+01, 3.1399025009E+00, 2.0445618370E+00, 1.1262601122E+00, 9.1165062239E-01],
	[4.7040000000E+04, 1.2453882997E+01, 3.1399207586E+00, 2.0452408097E+00, 1.1264869112E+00, 9.1166900436E-01],
	[4.7045000000E+04, 1.2456137881E+01, 3.1399390145E+00, 2.0459199355E+00, 1.1267137056E+00, 9.1168738266E-01],
	[4.7050000000E+04, 1.2458392934E+01, 3.1399572685E+00, 2.0465992146E+00, 1.1269404954E+00, 9.1170575732E-01],
	[4.7055000000E+04, 1.2460648156E+01, 3.1399755207E+00, 2.0472786470E+00, 1.1271672807E+00, 9.1172412832E-01],
	[4.7060000000E+04, 1.2462903546E+01, 3.1399937711E+00, 2.0479582326E+00, 1.1273940615E+00, 9.1174249567E-01],
	[4.7065000000E+04, 1.2465159105E+01, 3.1400120196E+00, 2.0486379714E+00, 1.1276208376E+00, 9.1176085937E-01],
	[4.7070000000E+04, 1.2467414832E+01, 3.1400302663E+00, 2.0493178636E+00, 1.1278476091E+00, 9.1177921941E-01],
	[4.7075000000E+04, 1.2469670728E+01, 3.1400485112E+00, 2.0499979091E+00, 1.1280743760E+00, 9.1179757581E-01],
	[4.7080000000E+04, 1.2471926792E+01, 3.1400667542E+00, 2.0506781079E+00, 1.1283011383E+00, 9.1181592856E-01],
	[4.7085000000E+04, 1.2474183025E+01, 3.1400849955E+00, 2.0513584600E+00, 1.1285278959E+00, 9.1183427765E-01],
	[4.7090000000E+04, 1.2476439426E+01, 3.1401032348E+00, 2.0520389656E+00, 1.1287546489E+00, 9.1185262310E-01],
	[4.7095000000E+04, 1.2478695996E+01, 3.1401214724E+00, 2.0527196245E+00, 1.1289813973E+00, 9.1187096490E-01],
	[4.7100000000E+04, 1.2480952735E+01, 3.1401397081E+00, 2.0534004368E+00, 1.1292081410E+00, 9.1188930306E-01],
	[4.7105000000E+04, 1.2483209642E+01, 3.1401579420E+00, 2.0540814025E+00, 1.1294348801E+00, 9.1190763757E-01],
	[4.7110000000E+04, 1.2485466717E+01, 3.1401761741E+00, 2.0547625217E+00, 1.1296616144E+00, 9.1192596843E-01],
	[4.7115000000E+04, 1.2487723961E+01, 3.1401944043E+00, 2.0554437943E+00, 1.1298883441E+00, 9.1194429565E-01],
	[4.7120000000E+04, 1.2489981373E+01, 3.1402126327E+00, 2.0561252204E+00, 1.1301150691E+00, 9.1196261923E-01],
	[4.7125000000E+04, 1.2492238954E+01, 3.1402308593E+00, 2.0568068000E+00, 1.1303417894E+00, 9.1198093916E-01],
	[4.7130000000E+04, 1.2494496703E+01, 3.1402490840E+00, 2.0574885331E+00, 1.1305685050E+00, 9.1199925544E-01],
	[4.7135000000E+04, 1.2496754621E+01, 3.1402673069E+00, 2.0581704198E+00, 1.1307952158E+00, 9.1201756809E-01],
	[4.7140000000E+04, 1.2499012708E+01, 3.1402855280E+00, 2.0588524600E+00, 1.1310219219E+00, 9.1203587710E-01],
	[4.7145000000E+04, 1.2501270962E+01, 3.1403037473E+00, 2.0595346537E+00, 1.1312486233E+00, 9.1205418246E-01],
	[4.7150000000E+04, 1.2503529386E+01, 3.1403219647E+00, 2.0602170011E+00, 1.1314753199E+00, 9.1207248419E-01],
	[4.7155000000E+04, 1.2505787977E+01, 3.1403401803E+00, 2.0608995020E+00, 1.1317020118E+00, 9.1209078227E-01],
	[4.7160000000E+04, 1.2508046737E+01, 3.1403583941E+00, 2.0615821566E+00, 1.1319286989E+00, 9.1210907672E-01],
	[4.7165000000E+04, 1.2510305666E+01, 3.1403766061E+00, 2.0622649648E+00, 1.1321553812E+00, 9.1212736753E-01],
	[4.7170000000E+04, 1.2512564763E+01, 3.1403948162E+00, 2.0629479267E+00, 1.1323820588E+00, 9.1214565470E-01],
	[4.7175000000E+04, 1.2514824028E+01, 3.1404130245E+00, 2.0636310422E+00, 1.1326087315E+00, 9.1216393823E-01],
	[4.7180000000E+04, 1.2517083462E+01, 3.1404312310E+00, 2.0643143115E+00, 1.1328353994E+00, 9.1218221813E-01],
	[4.7185000000E+04, 1.2519343064E+01, 3.1404494357E+00, 2.0649977344E+00, 1.1330620626E+00, 9.1220049440E-01],
	[4.7190000000E+04, 1.2521602835E+01, 3.1404676385E+00, 2.0656813111E+00, 1.1332887209E+00, 9.1221876703E-01],
	[4.7195000000E+04, 1.2523862774E+01, 3.1404858395E+00, 2.0663650416E+00, 1.1335153743E+00, 9.1223703602E-01],
	[4.7200000000E+04, 1.2526122881E+01, 3.1405040387E+00, 2.0670489258E+00, 1.1337420229E+00, 9.1225530139E-01],
	[4.7205000000E+04, 1.2528383157E+01, 3.1405222361E+00, 2.0677329638E+00, 1.1339686667E+00, 9.1227356312E-01],
	[4.7210000000E+04, 1.2530643602E+01, 3.1405404317E+00, 2.0684171556E+00, 1.1341953056E+00, 9.1229182122E-01],
	[4.7215000000E+04, 1.2532904214E+01, 3.1405586254E+00, 2.0691015012E+00, 1.1344219397E+00, 9.1231007568E-01],
	[4.7220000000E+04, 1.2535164995E+01, 3.1405768173E+00, 2.0697860007E+00, 1.1346485688E+00, 9.1232832652E-01],
	[4.7225000000E+04, 1.2537425945E+01, 3.1405950074E+00, 2.0704706540E+00, 1.1348751931E+00, 9.1234657373E-01],
	[4.7230000000E+04, 1.2539687062E+01, 3.1406131957E+00, 2.0711554612E+00, 1.1351018125E+00, 9.1236481731E-01],
	[4.7235000000E+04, 1.2541948349E+01, 3.1406313821E+00, 2.0718404223E+00, 1.1353284269E+00, 9.1238305726E-01],
	[4.7240000000E+04, 1.2544209803E+01, 3.1406495667E+00, 2.0725255373E+00, 1.1355550365E+00, 9.1240129358E-01],
	[4.7245000000E+04, 1.2546471426E+01, 3.1406677495E+00, 2.0732108063E+00, 1.1357816411E+00, 9.1241952628E-01],
	[4.7250000000E+04, 1.2548733217E+01, 3.1406859305E+00, 2.0738962292E+00, 1.1360082408E+00, 9.1243775535E-01],
	[4.7255000000E+04, 1.2550995177E+01, 3.1407041097E+00, 2.0745818060E+00, 1.1362348355E+00, 9.1245598080E-01],
	[4.7260000000E+04, 1.2553257305E+01, 3.1407222870E+00, 2.0752675369E+00, 1.1364614253E+00, 9.1247420262E-01],
	[4.7265000000E+04, 1.2555519601E+01, 3.1407404626E+00, 2.0759534218E+00, 1.1366880102E+00, 9.1249242081E-01],
	[4.7270000000E+04, 1.2557782065E+01, 3.1407586363E+00, 2.0766394606E+00, 1.1369145900E+00, 9.1251063539E-01],
	[4.7275000000E+04, 1.2560044698E+01, 3.1407768082E+00, 2.0773256536E+00, 1.1371411649E+00, 9.1252884634E-01],
	[4.7280000000E+04, 1.2562307499E+01, 3.1407949783E+00, 2.0780120006E+00, 1.1373677348E+00, 9.1254705366E-01],
	[4.7285000000E+04, 1.2564570469E+01, 3.1408131465E+00, 2.0786985016E+00, 1.1375942997E+00, 9.1256525737E-01],
	[4.7290000000E+04, 1.2566833607E+01, 3.1408313130E+00, 2.0793851568E+00, 1.1378208596E+00, 9.1258345746E-01],
	[4.7295000000E+04, 1.2569096913E+01, 3.1408494776E+00, 2.0800719661E+00, 1.1380474144E+00, 9.1260165392E-01],
	[4.7300000000E+04, 1.2571360387E+01, 3.1408676404E+00, 2.0807589295E+00, 1.1382739643E+00, 9.1261984677E-01],
	[4.7305000000E+04, 1.2573624030E+01, 3.1408858015E+00, 2.0814460471E+00, 1.1385005091E+00, 9.1263803600E-01],
	[4.7310000000E+04, 1.2575887841E+01, 3.1409039606E+00, 2.0821333188E+00, 1.1387270489E+00, 9.1265622161E-01],
	[4.7315000000E+04, 1.2578151820E+01, 3.1409221180E+00, 2.0828207447E+00, 1.1389535836E+00, 9.1267440360E-01],
	[4.7320000000E+04, 1.2580415968E+01, 3.1409402736E+00, 2.0835083249E+00, 1.1391801132E+00, 9.1269258198E-01],
	[4.7325000000E+04, 1.2582680284E+01, 3.1409584273E+00, 2.0841960592E+00, 1.1394066378E+00, 9.1271075674E-01],
	[4.7330000000E+04, 1.2584944768E+01, 3.1409765793E+00, 2.0848839478E+00, 1.1396331573E+00, 9.1272892789E-01],
	[4.7335000000E+04, 1.2587209420E+01, 3.1409947294E+00, 2.0855719907E+00, 1.1398596717E+00, 9.1274709542E-01],
	[4.7340000000E+04, 1.2589474241E+01, 3.1410128777E+00, 2.0862601878E+00, 1.1400861810E+00, 9.1276525933E-01],
	[4.7345000000E+04, 1.2591739230E+01, 3.1410310242E+00, 2.0869485393E+00, 1.1403126852E+00, 9.1278341964E-01],
	[4.7350000000E+04, 1.2594004387E+01, 3.1410491689E+00, 2.0876370450E+00, 1.1405391843E+00, 9.1280157633E-01],
	[4.7355000000E+04, 1.2596269712E+01, 3.1410673118E+00, 2.0883257051E+00, 1.1407656782E+00, 9.1281972941E-01],
	[4.7360000000E+04, 1.2598535206E+01, 3.1410854528E+00, 2.0890145196E+00, 1.1409921670E+00, 9.1283787888E-01],
	[4.7365000000E+04, 1.2600800868E+01, 3.1411035921E+00, 2.0897034884E+00, 1.1412186507E+00, 9.1285602474E-01],
	[4.7370000000E+04, 1.2603066698E+01, 3.1411217295E+00, 2.0903926116E+00, 1.1414451292E+00, 9.1287416699E-01],
	[4.7375000000E+04, 1.2605332696E+01, 3.1411398652E+00, 2.0910818892E+00, 1.1416716026E+00, 9.1289230563E-01],
	[4.7380000000E+04, 1.2607598862E+01, 3.1411579990E+00, 2.0917713212E+00, 1.1418980707E+00, 9.1291044066E-01],
	[4.7385000000E+04, 1.2609865197E+01, 3.1411761310E+00, 2.0924609077E+00, 1.1421245337E+00, 9.1292857209E-01],
	[4.7390000000E+04, 1.2612131700E+01, 3.1411942612E+00, 2.0931506487E+00, 1.1423509916E+00, 9.1294669990E-01],
	[4.7395000000E+04, 1.2614398371E+01, 3.1412123896E+00, 2.0938405441E+00, 1.1425774442E+00, 9.1296482412E-01],
	[4.7400000000E+04, 1.2616665210E+01, 3.1412305162E+00, 2.0945305940E+00, 1.1428038916E+00, 9.1298294472E-01],
	[4.7405000000E+04, 1.2618932218E+01, 3.1412486410E+00, 2.0952207985E+00, 1.1430303338E+00, 9.1300106172E-01],
	[4.7410000000E+04, 1.2621199393E+01, 3.1412667640E+00, 2.0959111575E+00, 1.1432567707E+00, 9.1301917512E-01],
	[4.7415000000E+04, 1.2623466737E+01, 3.1412848852E+00, 2.0966016710E+00, 1.1434832024E+00, 9.1303728492E-01],
	[4.7420000000E+04, 1.2625734249E+01, 3.1413030045E+00, 2.0972923391E+00, 1.1437096289E+00, 9.1305539111E-01],
	[4.7425000000E+04, 1.2628001929E+01, 3.1413211221E+00, 2.0979831618E+00, 1.1439360501E+00, 9.1307349370E-01],
	[4.7430000000E+04, 1.2630269778E+01, 3.1413392378E+00, 2.0986741391E+00, 1.1441624661E+00, 9.1309159268E-01],
	[4.7435000000E+04, 1.2632537794E+01, 3.1413573518E+00, 2.0993652710E+00, 1.1443888768E+00, 9.1310968807E-01],
	[4.7440000000E+04, 1.2634805979E+01, 3.1413754639E+00, 2.1000565576E+00, 1.1446152822E+00, 9.1312777986E-01],
	[4.7445000000E+04, 1.2637074331E+01, 3.1413935743E+00, 2.1007479989E+00, 1.1448416823E+00, 9.1314586804E-01],
	[4.7450000000E+04, 1.2639342852E+01, 3.1414116828E+00, 2.1014395948E+00, 1.1450680771E+00, 9.1316395263E-01],
	[4.7455000000E+04, 1.2641611541E+01, 3.1414297895E+00, 2.1021313454E+00, 1.1452944666E+00, 9.1318203363E-01],
	[4.7460000000E+04, 1.2643880398E+01, 3.1414478945E+00, 2.1028232507E+00, 1.1455208508E+00, 9.1320011102E-01],
	[4.7465000000E+04, 1.2646149424E+01, 3.1414659976E+00, 2.1035153108E+00, 1.1457472297E+00, 9.1321818482E-01],
	[4.7470000000E+04, 1.2648418617E+01, 3.1414840989E+00, 2.1042075257E+00, 1.1459736032E+00, 9.1323625502E-01],
	[4.7475000000E+04, 1.2650687979E+01, 3.1415021984E+00, 2.1048998953E+00, 1.1461999714E+00, 9.1325432162E-01],
	[4.7480000000E+04, 1.2652957508E+01, 3.1415202962E+00, 2.1055924197E+00, 1.1464263342E+00, 9.1327238464E-01],
	[4.7485000000E+04, 1.2655227206E+01, 3.1415383921E+00, 2.1062850989E+00, 1.1466526917E+00, 9.1329044405E-01],
	[4.7490000000E+04, 1.2657497072E+01, 3.1415564862E+00, 2.1069779329E+00, 1.1468790438E+00, 9.1330849988E-01],
	[4.7495000000E+04, 1.2659767106E+01, 3.1415745785E+00, 2.1076709218E+00, 1.1471053905E+00, 9.1332655211E-01],
	[4.7500000000E+04, 1.2662037308E+01, 3.1415926690E+00, 2.1083640656E+00, 1.1473317318E+00, 9.1334460075E-01],
	[4.7505000000E+04, 1.2664307678E+01, 3.1416107577E+00, 2.1090573642E+00, 1.1475580677E+00, 9.1336264580E-01],
	[4.7510000000E+04, 1.2666578216E+01, 3.1416288447E+00, 2.1097508177E+00, 1.1477843983E+00, 9.1338068726E-01],
	[4.7515000000E+04, 1.2668848922E+01, 3.1416469298E+00, 2.1104444262E+00, 1.1480107234E+00, 9.1339872513E-01],
	[4.7520000000E+04, 1.2671119797E+01, 3.1416650131E+00, 2.1111381896E+00, 1.1482370430E+00, 9.1341675941E-01],
	[4.7525000000E+04, 1.2673390839E+01, 3.1416830946E+00, 2.1118321079E+00, 1.1484633573E+00, 9.1343479011E-01],
	[4.7530000000E+04, 1.2675667697E+01, 3.1417022950E+00, 2.1125261812E+00, 1.1486898623E+00, 9.1345281721E-01],
	[4.7535000000E+04, 1.2677944868E+01, 3.1417215218E+00, 2.1132204096E+00, 1.1489163669E+00, 9.1347084073E-01],
	[4.7540000000E+04, 1.2680222209E+01, 3.1417407468E+00, 2.1139147929E+00, 1.1491428662E+00, 9.1348886066E-01],
	[4.7545000000E+04, 1.2682499719E+01, 3.1417599698E+00, 2.1146093312E+00, 1.1493693601E+00, 9.1350687701E-01],
	[4.7550000000E+04, 1.2684777398E+01, 3.1417791910E+00, 2.1153040246E+00, 1.1495958487E+00, 9.1352488977E-01],
	[4.7555000000E+04, 1.2687055248E+01, 3.1417984102E+00, 2.1159988731E+00, 1.1498223319E+00, 9.1354289894E-01],
	[4.7560000000E+04, 1.2689333266E+01, 3.1418176276E+00, 2.1166938767E+00, 1.1500488097E+00, 9.1356090453E-01],
	[4.7565000000E+04, 1.2691611454E+01, 3.1418368430E+00, 2.1173890353E+00, 1.1502752821E+00, 9.1357890654E-01],
	[4.7570000000E+04, 1.2693889812E+01, 3.1418560566E+00, 2.1180843491E+00, 1.1505017492E+00, 9.1359690497E-01],
	[4.7575000000E+04, 1.2696168339E+01, 3.1418752682E+00, 2.1187798180E+00, 1.1507282108E+00, 9.1361489981E-01],
	[4.7580000000E+04, 1.2698447035E+01, 3.1418944779E+00, 2.1194754421E+00, 1.1509546670E+00, 9.1363289107E-01],
	[4.7585000000E+04, 1.2700725901E+01, 3.1419136858E+00, 2.1201712213E+00, 1.1511811178E+00, 9.1365087875E-01],
	[4.7590000000E+04, 1.2703004936E+01, 3.1419328917E+00, 2.1208671558E+00, 1.1514075631E+00, 9.1366886285E-01],
	[4.7595000000E+04, 1.2705284141E+01, 3.1419520957E+00, 2.1215632454E+00, 1.1516340030E+00, 9.1368684337E-01],
	[4.7600000000E+04, 1.2707563516E+01, 3.1419712979E+00, 2.1222594903E+00, 1.1518604375E+00, 9.1370482031E-01],
	[4.7605000000E+04, 1.2709843059E+01, 3.1419904981E+00, 2.1229558904E+00, 1.1520868665E+00, 9.1372279367E-01],
	[4.7610000000E+04, 1.2712122773E+01, 3.1420096964E+00, 2.1236524458E+00, 1.1523132900E+00, 9.1374076345E-01],
	[4.7615000000E+04, 1.2714402655E+01, 3.1420288929E+00, 2.1243491565E+00, 1.1525397081E+00, 9.1375872966E-01],
	[4.7620000000E+04, 1.2716682707E+01, 3.1420480874E+00, 2.1250460225E+00, 1.1527661206E+00, 9.1377669229E-01],
	[4.7625000000E+04, 1.2718962929E+01, 3.1420672800E+00, 2.1257430438E+00, 1.1529925277E+00, 9.1379465134E-01],
	[4.7630000000E+04, 1.2721243320E+01, 3.1420864708E+00, 2.1264402204E+00, 1.1532189293E+00, 9.1381260682E-01],
	[4.7635000000E+04, 1.2723523880E+01, 3.1421056596E+00, 2.1271375524E+00, 1.1534453253E+00, 9.1383055872E-01],
	[4.7640000000E+04, 1.2725804610E+01, 3.1421248466E+00, 2.1278350398E+00, 1.1536717159E+00, 9.1384850705E-01],
	[4.7645000000E+04, 1.2728085509E+01, 3.1421440316E+00, 2.1285326826E+00, 1.1538981009E+00, 9.1386645181E-01],
	[4.7650000000E+04, 1.2730366577E+01, 3.1421632148E+00, 2.1292304808E+00, 1.1541244803E+00, 9.1388439299E-01],
	[4.7655000000E+04, 1.2732647815E+01, 3.1421823960E+00, 2.1299284344E+00, 1.1543508542E+00, 9.1390233060E-01],
	[4.7660000000E+04, 1.2734929223E+01, 3.1422015754E+00, 2.1306265435E+00, 1.1545772226E+00, 9.1392026463E-01],
	[4.7665000000E+04, 1.2737210799E+01, 3.1422207529E+00, 2.1313248080E+00, 1.1548035853E+00, 9.1393819510E-01],
	[4.7670000000E+04, 1.2739492546E+01, 3.1422399285E+00, 2.1320232281E+00, 1.1550299425E+00, 9.1395612199E-01],
	[4.7675000000E+04, 1.2741774461E+01, 3.1422591021E+00, 2.1327218036E+00, 1.1552562942E+00, 9.1397404532E-01],
	[4.7680000000E+04, 1.2744056546E+01, 3.1422782739E+00, 2.1334205346E+00, 1.1554826402E+00, 9.1399196507E-01],
	[4.7685000000E+04, 1.2746338800E+01, 3.1422974438E+00, 2.1341194212E+00, 1.1557089806E+00, 9.1400988126E-01],
	[4.7690000000E+04, 1.2748621224E+01, 3.1423166118E+00, 2.1348184634E+00, 1.1559353154E+00, 9.1402779388E-01],
	[4.7695000000E+04, 1.2750903816E+01, 3.1423357779E+00, 2.1355176611E+00, 1.1561616446E+00, 9.1404570293E-01],
	[4.7700000000E+04, 1.2753186579E+01, 3.1423549421E+00, 2.1362170145E+00, 1.1563879682E+00, 9.1406360841E-01],
	[4.7705000000E+04, 1.2755469510E+01, 3.1423741045E+00, 2.1369165234E+00, 1.1566142861E+00, 9.1408151033E-01],
	[4.7710000000E+04, 1.2757752611E+01, 3.1423932649E+00, 2.1376161880E+00, 1.1568405984E+00, 9.1409940868E-01],
	[4.7715000000E+04, 1.2760035881E+01, 3.1424124234E+00, 2.1383160082E+00, 1.1570669050E+00, 9.1411730346E-01],
	[4.7720000000E+04, 1.2762319321E+01, 3.1424315801E+00, 2.1390159841E+00, 1.1572932059E+00, 9.1413519468E-01],
	[4.7725000000E+04, 1.2764602930E+01, 3.1424507348E+00, 2.1397161157E+00, 1.1575195012E+00, 9.1415308234E-01],
	[4.7730000000E+04, 1.2766886708E+01, 3.1424698877E+00, 2.1404164030E+00, 1.1577457908E+00, 9.1417096643E-01],
	[4.7735000000E+04, 1.2769170656E+01, 3.1424890387E+00, 2.1411168460E+00, 1.1579720747E+00, 9.1418884696E-01],
	[4.7740000000E+04, 1.2771454773E+01, 3.1425081878E+00, 2.1418174447E+00, 1.1581983529E+00, 9.1420672393E-01],
	[4.7745000000E+04, 1.2773739059E+01, 3.1425273350E+00, 2.1425181993E+00, 1.1584246254E+00, 9.1422459734E-01],
	[4.7750000000E+04, 1.2776023514E+01, 3.1425464803E+00, 2.1432191095E+00, 1.1586508922E+00, 9.1424246718E-01],
	[4.7755000000E+04, 1.2778308139E+01, 3.1425656237E+00, 2.1439201756E+00, 1.1588771532E+00, 9.1426033347E-01],
	[4.7760000000E+04, 1.2780592933E+01, 3.1425847653E+00, 2.1446213975E+00, 1.1591034085E+00, 9.1427819620E-01],
	[4.7765000000E+04, 1.2782877896E+01, 3.1426039049E+00, 2.1453227753E+00, 1.1593296581E+00, 9.1429605536E-01],
	[4.7770000000E+04, 1.2785163029E+01, 3.1426230427E+00, 2.1460243089E+00, 1.1595559019E+00, 9.1431391097E-01],
	[4.7775000000E+04, 1.2787448331E+01, 3.1426421786E+00, 2.1467259983E+00, 1.1597821399E+00, 9.1433176302E-01],
	[4.7780000000E+04, 1.2789733802E+01, 3.1426613125E+00, 2.1474278437E+00, 1.1600083722E+00, 9.1434961151E-01],
	[4.7785000000E+04, 1.2792019442E+01, 3.1426804447E+00, 2.1481298450E+00, 1.1602345987E+00, 9.1436745645E-01],
	[4.7790000000E+04, 1.2794305252E+01, 3.1426995749E+00, 2.1488320021E+00, 1.1604608194E+00, 9.1438529783E-01],
	[4.7795000000E+04, 1.2796591231E+01, 3.1427187032E+00, 2.1495343153E+00, 1.1606870343E+00, 9.1440313565E-01],
	[4.7800000000E+04, 1.2798877379E+01, 3.1427378297E+00, 2.1502367844E+00, 1.1609132434E+00, 9.1442096992E-01],
	[4.7805000000E+04, 1.2801163696E+01, 3.1427569542E+00, 2.1509394094E+00, 1.1611394467E+00, 9.1443880063E-01],
	[4.7810000000E+04, 1.2803450183E+01, 3.1427760769E+00, 2.1516421905E+00, 1.1613656441E+00, 9.1445662780E-01],
	[4.7815000000E+04, 1.2805736838E+01, 3.1427951977E+00, 2.1523451276E+00, 1.1615918357E+00, 9.1447445140E-01],
	[4.7820000000E+04, 1.2808023663E+01, 3.1428143166E+00, 2.1530482207E+00, 1.1618180215E+00, 9.1449227146E-01],
	[4.7825000000E+04, 1.2810310658E+01, 3.1428334337E+00, 2.1537514699E+00, 1.1620442015E+00, 9.1451008796E-01],
	[4.7830000000E+04, 1.2812597821E+01, 3.1428525488E+00, 2.1544548751E+00, 1.1622703755E+00, 9.1452790092E-01],
	[4.7835000000E+04, 1.2814885154E+01, 3.1428716621E+00, 2.1551584364E+00, 1.1624965437E+00, 9.1454571032E-01],
	[4.7840000000E+04, 1.2817172656E+01, 3.1428907735E+00, 2.1558621539E+00, 1.1627227060E+00, 9.1456351617E-01],
	[4.7845000000E+04, 1.2819460327E+01, 3.1429098830E+00, 2.1565660275E+00, 1.1629488625E+00, 9.1458131847E-01],
	[4.7850000000E+04, 1.2821748167E+01, 3.1429289906E+00, 2.1572700572E+00, 1.1631750130E+00, 9.1459911723E-01],
	[4.7855000000E+04, 1.2824036176E+01, 3.1429480964E+00, 2.1579742430E+00, 1.1634011577E+00, 9.1461691243E-01],
	[4.7860000000E+04, 1.2826324355E+01, 3.1429672002E+00, 2.1586785851E+00, 1.1636272964E+00, 9.1463470409E-01],
	[4.7865000000E+04, 1.2828612703E+01, 3.1429863022E+00, 2.1593830834E+00, 1.1638534292E+00, 9.1465249220E-01],
	[4.7870000000E+04, 1.2830901220E+01, 3.1430054023E+00, 2.1600877378E+00, 1.1640795560E+00, 9.1467027677E-01],
	[4.7875000000E+04, 1.2833189906E+01, 3.1430245005E+00, 2.1607925485E+00, 1.1643056770E+00, 9.1468805778E-01],
	[4.7880000000E+04, 1.2835478761E+01, 3.1430435969E+00, 2.1614975155E+00, 1.1645317920E+00, 9.1470583526E-01],
	[4.7885000000E+04, 1.2837767786E+01, 3.1430626914E+00, 2.1622026387E+00, 1.1647579010E+00, 9.1472360919E-01],
	[4.7890000000E+04, 1.2840056979E+01, 3.1430817840E+00, 2.1629079183E+00, 1.1649840040E+00, 9.1474137957E-01],
	[4.7895000000E+04, 1.2842346342E+01, 3.1431008747E+00, 2.1636133541E+00, 1.1652101011E+00, 9.1475914641E-01],
	[4.7900000000E+04, 1.2844635874E+01, 3.1431199635E+00, 2.1643189463E+00, 1.1654361922E+00, 9.1477690971E-01],
	[4.7905000000E+04, 1.2846925575E+01, 3.1431390505E+00, 2.1650246948E+00, 1.1656622773E+00, 9.1479466947E-01],
	[4.7910000000E+04, 1.2849215445E+01, 3.1431581356E+00, 2.1657305997E+00, 1.1658883565E+00, 9.1481242569E-01],
	[4.7915000000E+04, 1.2851505484E+01, 3.1431772188E+00, 2.1664366609E+00, 1.1661144296E+00, 9.1483017836E-01],
	[4.7920000000E+04, 1.2853795693E+01, 3.1431963001E+00, 2.1671428786E+00, 1.1663404966E+00, 9.1484792750E-01],
	[4.7925000000E+04, 1.2856086070E+01, 3.1432153796E+00, 2.1678492527E+00, 1.1665665577E+00, 9.1486567309E-01],
	[4.7930000000E+04, 1.2858376617E+01, 3.1432344572E+00, 2.1685557832E+00, 1.1667926127E+00, 9.1488341515E-01],
	[4.7935000000E+04, 1.2860667333E+01, 3.1432535329E+00, 2.1692624702E+00, 1.1670186617E+00, 9.1490115367E-01],
	[4.7940000000E+04, 1.2862958218E+01, 3.1432726067E+00, 2.1699693136E+00, 1.1672447046E+00, 9.1491888865E-01],
	[4.7945000000E+04, 1.2865249272E+01, 3.1432916787E+00, 2.1706763135E+00, 1.1674707415E+00, 9.1493662009E-01],
	[4.7950000000E+04, 1.2867540495E+01, 3.1433107488E+00, 2.1713834700E+00, 1.1676967722E+00, 9.1495434800E-01],
	[4.7955000000E+04, 1.2869831887E+01, 3.1433298170E+00, 2.1720907830E+00, 1.1679227970E+00, 9.1497207237E-01],
	[4.7960000000E+04, 1.2872123448E+01, 3.1433488833E+00, 2.1727982525E+00, 1.1681488156E+00, 9.1498979320E-01],
	[4.7965000000E+04, 1.2874415178E+01, 3.1433679478E+00, 2.1735058786E+00, 1.1683748281E+00, 9.1500751050E-01],
	[4.7970000000E+04, 1.2876707077E+01, 3.1433870104E+00, 2.1742136613E+00, 1.1686008345E+00, 9.1502522427E-01],
	[4.7975000000E+04, 1.2878999146E+01, 3.1434060711E+00, 2.1749216005E+00, 1.1688268348E+00, 9.1504293450E-01],
	[4.7980000000E+04, 1.2881291383E+01, 3.1434251300E+00, 2.1756296964E+00, 1.1690528290E+00, 9.1506064120E-01],
	[4.7985000000E+04, 1.2883583790E+01, 3.1434441870E+00, 2.1763379490E+00, 1.1692788170E+00, 9.1507834437E-01],
	[4.7990000000E+04, 1.2885876365E+01, 3.1434632421E+00, 2.1770463582E+00, 1.1695047989E+00, 9.1509604400E-01],
	[4.7995000000E+04, 1.2888169110E+01, 3.1434822954E+00, 2.1777549240E+00, 1.1697307747E+00, 9.1511374011E-01],
	[4.8000000000E+04, 1.2890462023E+01, 3.1435013467E+00, 2.1784636466E+00, 1.1699567443E+00, 9.1513143268E-01],
	[4.8005000000E+04, 1.2892755106E+01, 3.1435203962E+00, 2.1791725259E+00, 1.1701827077E+00, 9.1514912173E-01],
	[4.8010000000E+04, 1.2895048358E+01, 3.1435394439E+00, 2.1798815619E+00, 1.1704086650E+00, 9.1516680724E-01],
	[4.8015000000E+04, 1.2897341779E+01, 3.1435584897E+00, 2.1805907546E+00, 1.1706346161E+00, 9.1518448923E-01],
	[4.8020000000E+04, 1.2899635368E+01, 3.1435775336E+00, 2.1813001041E+00, 1.1708605609E+00, 9.1520216769E-01],
	[4.8025000000E+04, 1.2901929127E+01, 3.1435965756E+00, 2.1820096104E+00, 1.1710864996E+00, 9.1521984262E-01],
	[4.8030000000E+04, 1.2904223055E+01, 3.1436156158E+00, 2.1827192735E+00, 1.1713124321E+00, 9.1523751402E-01],
	[4.8035000000E+04, 1.2906517151E+01, 3.1436346541E+00, 2.1834290935E+00, 1.1715383583E+00, 9.1525518190E-01],
	[4.8040000000E+04, 1.2908811417E+01, 3.1436536905E+00, 2.1841390702E+00, 1.1717642783E+00, 9.1527284625E-01],
	[4.8045000000E+04, 1.2911105852E+01, 3.1436727251E+00, 2.1848492039E+00, 1.1719901921E+00, 9.1529050708E-01],
	[4.8050000000E+04, 1.2913400456E+01, 3.1436917578E+00, 2.1855594944E+00, 1.1722160997E+00, 9.1530816438E-01],
	[4.8055000000E+04, 1.2915695228E+01, 3.1437107887E+00, 2.1862699418E+00, 1.1724420010E+00, 9.1532581816E-01],
	[4.8060000000E+04, 1.2917990170E+01, 3.1437298176E+00, 2.1869805461E+00, 1.1726678960E+00, 9.1534346842E-01],
	[4.8065000000E+04, 1.2920285281E+01, 3.1437488447E+00, 2.1876913073E+00, 1.1728937847E+00, 9.1536111515E-01],
	[4.8070000000E+04, 1.2922580560E+01, 3.1437678700E+00, 2.1884022255E+00, 1.1731196672E+00, 9.1537875837E-01],
	[4.8075000000E+04, 1.2924876009E+01, 3.1437868934E+00, 2.1891133007E+00, 1.1733455434E+00, 9.1539639806E-01],
	[4.8080000000E+04, 1.2927171626E+01, 3.1438059149E+00, 2.1898245328E+00, 1.1735714133E+00, 9.1541403423E-01],
	[4.8085000000E+04, 1.2929467413E+01, 3.1438249346E+00, 2.1905359220E+00, 1.1737972768E+00, 9.1543166688E-01],
	[4.8090000000E+04, 1.2931763368E+01, 3.1438439524E+00, 2.1912474682E+00, 1.1740231341E+00, 9.1544929601E-01],
	[4.8095000000E+04, 1.2934059493E+01, 3.1438629683E+00, 2.1919591714E+00, 1.1742489851E+00, 9.1546692162E-01],
	[4.8100000000E+04, 1.2936355786E+01, 3.1438819824E+00, 2.1926710317E+00, 1.1744748297E+00, 9.1548454371E-01],
	[4.8105000000E+04, 1.2938652248E+01, 3.1439009946E+00, 2.1933830490E+00, 1.1747006679E+00, 9.1550216229E-01],
	[4.8110000000E+04, 1.2940948879E+01, 3.1439200049E+00, 2.1940952235E+00, 1.1749264999E+00, 9.1551977735E-01],
	[4.8115000000E+04, 1.2943245679E+01, 3.1439390134E+00, 2.1948075550E+00, 1.1751523254E+00, 9.1553738889E-01],
	[4.8120000000E+04, 1.2945542648E+01, 3.1439580201E+00, 2.1955200437E+00, 1.1753781446E+00, 9.1555499692E-01],
	[4.8125000000E+04, 1.2947839786E+01, 3.1439770248E+00, 2.1962326896E+00, 1.1756039574E+00, 9.1557260143E-01],
	[4.8130000000E+04, 1.2950137093E+01, 3.1439960277E+00, 2.1969454926E+00, 1.1758297639E+00, 9.1559020243E-01],
	[4.8135000000E+04, 1.2952434569E+01, 3.1440150288E+00, 2.1976584528E+00, 1.1760555639E+00, 9.1560779991E-01],
	[4.8140000000E+04, 1.2954732213E+01, 3.1440340280E+00, 2.1983715702E+00, 1.1762813576E+00, 9.1562539389E-01],
	[4.8145000000E+04, 1.2957030027E+01, 3.1440530253E+00, 2.1990848449E+00, 1.1765071448E+00, 9.1564298434E-01],
	[4.8150000000E+04, 1.2959328009E+01, 3.1440720208E+00, 2.1997982767E+00, 1.1767329256E+00, 9.1566057129E-01],
	[4.8155000000E+04, 1.2961626160E+01, 3.1440910144E+00, 2.2005118659E+00, 1.1769587000E+00, 9.1567815472E-01],
	[4.8160000000E+04, 1.2963924480E+01, 3.1441100062E+00, 2.2012256123E+00, 1.1771844680E+00, 9.1569573465E-01],
	[4.8165000000E+04, 1.2966222969E+01, 3.1441289961E+00, 2.2019395160E+00, 1.1774102295E+00, 9.1571331106E-01],
	[4.8170000000E+04, 1.2968521627E+01, 3.1441479841E+00, 2.2026535771E+00, 1.1776359845E+00, 9.1573088396E-01],
	[4.8175000000E+04, 1.2970820454E+01, 3.1441669703E+00, 2.2033677954E+00, 1.1778617331E+00, 9.1574845336E-01],
	[4.8180000000E+04, 1.2973119449E+01, 3.1441859546E+00, 2.2040821712E+00, 1.1780874753E+00, 9.1576601925E-01],
	[4.8185000000E+04, 1.2975418614E+01, 3.1442049371E+00, 2.2047967042E+00, 1.1783132109E+00, 9.1578358162E-01],
	[4.8190000000E+04, 1.2977717947E+01, 3.1442239177E+00, 2.2055113947E+00, 1.1785389401E+00, 9.1580114050E-01],
	[4.8195000000E+04, 1.2980017449E+01, 3.1442428965E+00, 2.2062262426E+00, 1.1787646628E+00, 9.1581869586E-01],
	[4.8200000000E+04, 1.2982317120E+01, 3.1442618734E+00, 2.2069412479E+00, 1.1789903789E+00, 9.1583624772E-01],
	[4.8205000000E+04, 1.2984616960E+01, 3.1442808485E+00, 2.2076564107E+00, 1.1792160886E+00, 9.1585379607E-01],
	[4.8210000000E+04, 1.2986916968E+01, 3.1442998217E+00, 2.2083717309E+00, 1.1794417917E+00, 9.1587134092E-01],
	[4.8215000000E+04, 1.2989217146E+01, 3.1443187931E+00, 2.2090872086E+00, 1.1796674883E+00, 9.1588888227E-01],
	[4.8220000000E+04, 1.2991517492E+01, 3.1443377626E+00, 2.2098028438E+00, 1.1798931784E+00, 9.1590642011E-01],
	[4.8225000000E+04, 1.2993818007E+01, 3.1443567302E+00, 2.2105186365E+00, 1.1801188619E+00, 9.1592395445E-01],
	[4.8230000000E+04, 1.2996118690E+01, 3.1443756960E+00, 2.2112345868E+00, 1.1803445388E+00, 9.1594148529E-01],
	[4.8235000000E+04, 1.2998419543E+01, 3.1443946600E+00, 2.2119506946E+00, 1.1805702092E+00, 9.1595901262E-01],
	[4.8240000000E+04, 1.3000720564E+01, 3.1444136220E+00, 2.2126669600E+00, 1.1807958731E+00, 9.1597653646E-01],
	[4.8245000000E+04, 1.3003021755E+01, 3.1444325823E+00, 2.2133833830E+00, 1.1810215303E+00, 9.1599405679E-01],
	[4.8250000000E+04, 1.3005323114E+01, 3.1444515407E+00, 2.2140999635E+00, 1.1812471810E+00, 9.1601157362E-01],
	[4.8255000000E+04, 1.3007624641E+01, 3.1444704972E+00, 2.2148167017E+00, 1.1814728250E+00, 9.1602908696E-01],
	[4.8260000000E+04, 1.3009926338E+01, 3.1444894519E+00, 2.2155335976E+00, 1.1816984625E+00, 9.1604659679E-01],
	[4.8265000000E+04, 1.3012228203E+01, 3.1445084048E+00, 2.2162506511E+00, 1.1819240933E+00, 9.1606410313E-01],
	[4.8270000000E+04, 1.3014530237E+01, 3.1445273558E+00, 2.2169678623E+00, 1.1821497175E+00, 9.1608160597E-01],
	[4.8275000000E+04, 1.3016832440E+01, 3.1445463049E+00, 2.2176852312E+00, 1.1823753351E+00, 9.1609910532E-01],
	[4.8280000000E+04, 1.3019134811E+01, 3.1445652522E+00, 2.2184027578E+00, 1.1826009460E+00, 9.1611660117E-01],
	[4.8285000000E+04, 1.3021437352E+01, 3.1445841977E+00, 2.2191204422E+00, 1.1828265503E+00, 9.1613409352E-01],
	[4.8290000000E+04, 1.3023740061E+01, 3.1446031413E+00, 2.2198382843E+00, 1.1830521479E+00, 9.1615158238E-01],
	[4.8295000000E+04, 1.3026048538E+01, 3.1446231609E+00, 2.2205562842E+00, 1.1832779377E+00, 9.1616906774E-01],
	[4.8300000000E+04, 1.3028357436E+01, 3.1446432267E+00, 2.2212744419E+00, 1.1835037298E+00, 9.1618654961E-01],
	[4.8305000000E+04, 1.3030666504E+01, 3.1446632905E+00, 2.2219927573E+00, 1.1837295153E+00, 9.1620402799E-01],
	[4.8310000000E+04, 1.3032975742E+01, 3.1446833524E+00, 2.2227112307E+00, 1.1839552943E+00, 9.1622150287E-01],
	[4.8315000000E+04, 1.3035285150E+01, 3.1447034124E+00, 2.2234298618E+00, 1.1841810667E+00, 9.1623897427E-01],
	[4.8320000000E+04, 1.3037594728E+01, 3.1447234704E+00, 2.2241486508E+00, 1.1844068325E+00, 9.1625644217E-01],
	[4.8325000000E+04, 1.3039904477E+01, 3.1447435264E+00, 2.2248675978E+00, 1.1846325917E+00, 9.1627390658E-01],
	[4.8330000000E+04, 1.3042214395E+01, 3.1447635805E+00, 2.2255867026E+00, 1.1848583442E+00, 9.1629136750E-01],
	[4.8335000000E+04, 1.3044524484E+01, 3.1447836327E+00, 2.2263059653E+00, 1.1850840902E+00, 9.1630882493E-01],
	[4.8340000000E+04, 1.3046834743E+01, 3.1448036829E+00, 2.2270253860E+00, 1.1853098295E+00, 9.1632627888E-01],
	[4.8345000000E+04, 1.3049145172E+01, 3.1448237311E+00, 2.2277449646E+00, 1.1855355622E+00, 9.1634372933E-01],
	[4.8350000000E+04, 1.3051455771E+01, 3.1448437774E+00, 2.2284647012E+00, 1.1857612883E+00, 9.1636117630E-01],
	[4.8355000000E+04, 1.3053766541E+01, 3.1448638218E+00, 2.2291845958E+00, 1.1859870077E+00, 9.1637861978E-01],
	[4.8360000000E+04, 1.3056077480E+01, 3.1448838642E+00, 2.2299046484E+00, 1.1862127204E+00, 9.1639605978E-01],
	[4.8365000000E+04, 1.3058388590E+01, 3.1449039047E+00, 2.2306248591E+00, 1.1864384265E+00, 9.1641349629E-01],
	[4.8370000000E+04, 1.3060699870E+01, 3.1449239432E+00, 2.2313452277E+00, 1.1866641259E+00, 9.1643092931E-01],
	[4.8375000000E+04, 1.3063011320E+01, 3.1449439798E+00, 2.2320657545E+00, 1.1868898186E+00, 9.1644835885E-01],
	[4.8380000000E+04, 1.3065322940E+01, 3.1449640145E+00, 2.2327864393E+00, 1.1871155047E+00, 9.1646578491E-01],
	[4.8385000000E+04, 1.3067634730E+01, 3.1449840472E+00, 2.2335072823E+00, 1.1873411840E+00, 9.1648320748E-01],
	[4.8390000000E+04, 1.3069946690E+01, 3.1450040779E+00, 2.2342282833E+00, 1.1875668566E+00, 9.1650062657E-01],
	[4.8395000000E+04, 1.3072258820E+01, 3.1450241068E+00, 2.2349494426E+00, 1.1877925225E+00, 9.1651804218E-01],
	[4.8400000000E+04, 1.3074571121E+01, 3.1450441336E+00, 2.2356707599E+00, 1.1880181817E+00, 9.1653545431E-01],
	[4.8405000000E+04, 1.3076883591E+01, 3.1450641586E+00, 2.2363922355E+00, 1.1882438341E+00, 9.1655286296E-01],
	[4.8410000000E+04, 1.3079196232E+01, 3.1450841816E+00, 2.2371138692E+00, 1.1884694798E+00, 9.1657026812E-01],
	[4.8415000000E+04, 1.3081509043E+01, 3.1451042026E+00, 2.2378356611E+00, 1.1886951188E+00, 9.1658766981E-01],
	[4.8420000000E+04, 1.3083822023E+01, 3.1451242217E+00, 2.2385576113E+00, 1.1889207509E+00, 9.1660506802E-01],
	[4.8425000000E+04, 1.3086135174E+01, 3.1451442389E+00, 2.2392797198E+00, 1.1891463763E+00, 9.1662246275E-01],
	[4.8430000000E+04, 1.3088448495E+01, 3.1451642542E+00, 2.2400019864E+00, 1.1893719950E+00, 9.1663985400E-01],
	[4.8435000000E+04, 1.3090761986E+01, 3.1451842675E+00, 2.2407244114E+00, 1.1895976068E+00, 9.1665724178E-01],
	[4.8440000000E+04, 1.3093075647E+01, 3.1452042788E+00, 2.2414469947E+00, 1.1898232119E+00, 9.1667462608E-01],
	[4.8445000000E+04, 1.3095389478E+01, 3.1452242882E+00, 2.2421697363E+00, 1.1900488101E+00, 9.1669200690E-01],
	[4.8450000000E+04, 1.3097703479E+01, 3.1452442957E+00, 2.2428926363E+00, 1.1902744016E+00, 9.1670938425E-01],
	[4.8455000000E+04, 1.3100017650E+01, 3.1452643013E+00, 2.2436156946E+00, 1.1904999862E+00, 9.1672675812E-01],
	[4.8460000000E+04, 1.3102331991E+01, 3.1452843049E+00, 2.2443389113E+00, 1.1907255640E+00, 9.1674412852E-01],
	[4.8465000000E+04, 1.3104646503E+01, 3.1453043066E+00, 2.2450622864E+00, 1.1909511349E+00, 9.1676149545E-01],
	[4.8470000000E+04, 1.3106961184E+01, 3.1453243063E+00, 2.2457858199E+00, 1.1911766990E+00, 9.1677885891E-01],
	[4.8475000000E+04, 1.3109276035E+01, 3.1453443041E+00, 2.2465095118E+00, 1.1914022563E+00, 9.1679621889E-01],
	[4.8480000000E+04, 1.3111591056E+01, 3.1453643000E+00, 2.2472333622E+00, 1.1916278067E+00, 9.1681357540E-01],
	[4.8485000000E+04, 1.3113906247E+01, 3.1453842939E+00, 2.2479573711E+00, 1.1918533502E+00, 9.1683092844E-01],
	[4.8490000000E+04, 1.3116221609E+01, 3.1454042859E+00, 2.2486815384E+00, 1.1920788868E+00, 9.1684827801E-01],
	[4.8495000000E+04, 1.3118537140E+01, 3.1454242759E+00, 2.2494058643E+00, 1.1923044166E+00, 9.1686562411E-01],
	[4.8500000000E+04, 1.3120852841E+01, 3.1454442641E+00, 2.2501303487E+00, 1.1925299394E+00, 9.1688296674E-01],
	[4.8505000000E+04, 1.3123168712E+01, 3.1454642503E+00, 2.2508549916E+00, 1.1927554554E+00, 9.1690030590E-01],
	[4.8510000000E+04, 1.3125484754E+01, 3.1454842345E+00, 2.2515797931E+00, 1.1929809645E+00, 9.1691764160E-01],
	[4.8515000000E+04, 1.3127800965E+01, 3.1455042168E+00, 2.2523047531E+00, 1.1932064666E+00, 9.1693497383E-01],
	[4.8520000000E+04, 1.3130117346E+01, 3.1455241972E+00, 2.2530298718E+00, 1.1934319618E+00, 9.1695230259E-01],
	[4.8525000000E+04, 1.3132433897E+01, 3.1455441757E+00, 2.2537551491E+00, 1.1936574500E+00, 9.1696962788E-01],
	[4.8530000000E+04, 1.3134750618E+01, 3.1455641522E+00, 2.2544805850E+00, 1.1938829313E+00, 9.1698694971E-01],
	[4.8535000000E+04, 1.3137067509E+01, 3.1455841268E+00, 2.2552061795E+00, 1.1941084057E+00, 9.1700426808E-01],
	[4.8540000000E+04, 1.3139384570E+01, 3.1456040995E+00, 2.2559319328E+00, 1.1943338731E+00, 9.1702158298E-01],
	[4.8545000000E+04, 1.3141701801E+01, 3.1456240702E+00, 2.2566578447E+00, 1.1945593335E+00, 9.1703889442E-01],
	[4.8550000000E+04, 1.3144019202E+01, 3.1456440391E+00, 2.2573839153E+00, 1.1947847870E+00, 9.1705620240E-01],
	[4.8555000000E+04, 1.3146336773E+01, 3.1456640059E+00, 2.2581101447E+00, 1.1950102334E+00, 9.1707350691E-01],
	[4.8560000000E+04, 1.3148654514E+01, 3.1456839709E+00, 2.2588365328E+00, 1.1952356729E+00, 9.1709080796E-01],
	[4.8565000000E+04, 1.3150972424E+01, 3.1457039339E+00, 2.2595630797E+00, 1.1954611054E+00, 9.1710810555E-01],
	[4.8570000000E+04, 1.3153290505E+01, 3.1457238950E+00, 2.2602897853E+00, 1.1956865308E+00, 9.1712539968E-01],
	[4.8575000000E+04, 1.3155608756E+01, 3.1457438542E+00, 2.2610166498E+00, 1.1959119492E+00, 9.1714269036E-01],
	[4.8580000000E+04, 1.3157927176E+01, 3.1457638114E+00, 2.2617436730E+00, 1.1961373606E+00, 9.1715997757E-01],
	[4.8585000000E+04, 1.3160245766E+01, 3.1457837667E+00, 2.2624708551E+00, 1.1963627650E+00, 9.1717726132E-01],
	[4.8590000000E+04, 1.3162564527E+01, 3.1458037201E+00, 2.2631981961E+00, 1.1965881623E+00, 9.1719454162E-01],
	[4.8595000000E+04, 1.3164883457E+01, 3.1458236715E+00, 2.2639256959E+00, 1.1968135526E+00, 9.1721181846E-01],
	[4.8600000000E+04, 1.3167202557E+01, 3.1458436211E+00, 2.2646533546E+00, 1.1970389358E+00, 9.1722909184E-01],
	[4.8605000000E+04, 1.3169521827E+01, 3.1458635687E+00, 2.2653811723E+00, 1.1972643119E+00, 9.1724636176E-01],
	[4.8610000000E+04, 1.3171841266E+01, 3.1458835144E+00, 2.2661091488E+00, 1.1974896809E+00, 9.1726362824E-01],
	[4.8615000000E+04, 1.3174160876E+01, 3.1459034581E+00, 2.2668372843E+00, 1.1977150429E+00, 9.1728089125E-01],
	[4.8620000000E+04, 1.3176480656E+01, 3.1459233999E+00, 2.2675655788E+00, 1.1979403978E+00, 9.1729815081E-01],
	[4.8625000000E+04, 1.3178800605E+01, 3.1459433398E+00, 2.2682940323E+00, 1.1981657455E+00, 9.1731540692E-01],
	[4.8630000000E+04, 1.3181120724E+01, 3.1459632778E+00, 2.2690226447E+00, 1.1983910862E+00, 9.1733265958E-01],
	[4.8635000000E+04, 1.3183441013E+01, 3.1459832139E+00, 2.2697514162E+00, 1.1986164197E+00, 9.1734990878E-01],
	[4.8640000000E+04, 1.3185761472E+01, 3.1460031480E+00, 2.2704803467E+00, 1.1988417461E+00, 9.1736715453E-01],
	[4.8645000000E+04, 1.3188082101E+01, 3.1460230802E+00, 2.2712094363E+00, 1.1990670654E+00, 9.1738439683E-01],
	[4.8650000000E+04, 1.3190402900E+01, 3.1460430105E+00, 2.2719386849E+00, 1.1992923775E+00, 9.1740163568E-01],
	[4.8655000000E+04, 1.3192723869E+01, 3.1460629389E+00, 2.2726680926E+00, 1.1995176824E+00, 9.1741887108E-01],
	[4.8660000000E+04, 1.3195045007E+01, 3.1460828653E+00, 2.2733976595E+00, 1.1997429802E+00, 9.1743610303E-01],
	[4.8665000000E+04, 1.3197366315E+01, 3.1461027898E+00, 2.2741273855E+00, 1.1999682709E+00, 9.1745333154E-01],
	[4.8670000000E+04, 1.3199687793E+01, 3.1461227125E+00, 2.2748572706E+00, 1.2001935543E+00, 9.1747055659E-01],
	[4.8675000000E+04, 1.3202009441E+01, 3.1461426331E+00, 2.2755873149E+00, 1.2004188306E+00, 9.1748777820E-01],
	[4.8680000000E+04, 1.3204331258E+01, 3.1461625519E+00, 2.2763175183E+00, 1.2006440996E+00, 9.1750499636E-01],
	[4.8685000000E+04, 1.3206653246E+01, 3.1461824687E+00, 2.2770478810E+00, 1.2008693615E+00, 9.1752221107E-01],
	[4.8690000000E+04, 1.3208975403E+01, 3.1462023837E+00, 2.2777784029E+00, 1.2010946162E+00, 9.1753942234E-01],
	[4.8695000000E+04, 1.3211297730E+01, 3.1462222967E+00, 2.2785090841E+00, 1.2013198636E+00, 9.1755663017E-01],
	[4.8700000000E+04, 1.3213620227E+01, 3.1462422078E+00, 2.2792399245E+00, 1.2015451038E+00, 9.1757383455E-01],
	[4.8705000000E+04, 1.3215942894E+01, 3.1462621169E+00, 2.2799709241E+00, 1.2017703368E+00, 9.1759103548E-01],
	[4.8710000000E+04, 1.3218265730E+01, 3.1462820242E+00, 2.2807020831E+00, 1.2019955625E+00, 9.1760823298E-01],
	[4.8715000000E+04, 1.3220588736E+01, 3.1463019295E+00, 2.2814334014E+00, 1.2022207809E+00, 9.1762542703E-01],
	[4.8720000000E+04, 1.3222911912E+01, 3.1463218329E+00, 2.2821648790E+00, 1.2024459921E+00, 9.1764261764E-01],
	[4.8725000000E+04, 1.3225235258E+01, 3.1463417344E+00, 2.2828965159E+00, 1.2026711961E+00, 9.1765980480E-01],
	[4.8730000000E+04, 1.3227558773E+01, 3.1463616340E+00, 2.2836283123E+00, 1.2028963927E+00, 9.1767698853E-01],
	[4.8735000000E+04, 1.3229882458E+01, 3.1463815317E+00, 2.2843602680E+00, 1.2031215821E+00, 9.1769416882E-01],
	[4.8740000000E+04, 1.3232206313E+01, 3.1464014274E+00, 2.2850923831E+00, 1.2033467642E+00, 9.1771134567E-01],
	[4.8745000000E+04, 1.3234530338E+01, 3.1464213213E+00, 2.2858246576E+00, 1.2035719390E+00, 9.1772851908E-01],
	[4.8750000000E+04, 1.3236854532E+01, 3.1464412132E+00, 2.2865570916E+00, 1.2037971064E+00, 9.1774568905E-01],
	[4.8755000000E+04, 1.3239178897E+01, 3.1464611032E+00, 2.2872896851E+00, 1.2040222666E+00, 9.1776285558E-01],
	[4.8760000000E+04, 1.3241503431E+01, 3.1464809913E+00, 2.2880224380E+00, 1.2042474194E+00, 9.1778001868E-01],
	[4.8765000000E+04, 1.3243828134E+01, 3.1465008775E+00, 2.2887553504E+00, 1.2044725649E+00, 9.1779717834E-01],
	[4.8770000000E+04, 1.3246153008E+01, 3.1465207617E+00, 2.2894884223E+00, 1.2046977030E+00, 9.1781433457E-01],
	[4.8775000000E+04, 1.3248478051E+01, 3.1465406441E+00, 2.2902216538E+00, 1.2049228338E+00, 9.1783148736E-01],
	[4.8780000000E+04, 1.3250803263E+01, 3.1465605245E+00, 2.2909550448E+00, 1.2051479572E+00, 9.1784863671E-01],
	[4.8785000000E+04, 1.3253128646E+01, 3.1465804030E+00, 2.2916885954E+00, 1.2053730733E+00, 9.1786578264E-01],
	[4.8790000000E+04, 1.3255454198E+01, 3.1466002797E+00, 2.2924223056E+00, 1.2055981820E+00, 9.1788292513E-01],
	[4.8795000000E+04, 1.3257779920E+01, 3.1466201544E+00, 2.2931561754E+00, 1.2058232833E+00, 9.1790006418E-01],
	[4.8800000000E+04, 1.3260105812E+01, 3.1466400272E+00, 2.2938902048E+00, 1.2060483772E+00, 9.1791719981E-01],
	[4.8805000000E+04, 1.3262431873E+01, 3.1466598981E+00, 2.2946243938E+00, 1.2062734637E+00, 9.1793433200E-01],
	[4.8810000000E+04, 1.3264758104E+01, 3.1466797670E+00, 2.2953587425E+00, 1.2064985428E+00, 9.1795146077E-01],
	[4.8815000000E+04, 1.3267084505E+01, 3.1466996341E+00, 2.2960932509E+00, 1.2067236145E+00, 9.1796858610E-01],
	[4.8820000000E+04, 1.3269411075E+01, 3.1467194992E+00, 2.2968279190E+00, 1.2069486787E+00, 9.1798570800E-01],
	[4.8825000000E+04, 1.3271737815E+01, 3.1467393625E+00, 2.2975627468E+00, 1.2071737355E+00, 9.1800282648E-01],
	[4.8830000000E+04, 1.3274064724E+01, 3.1467592238E+00, 2.2982977343E+00, 1.2073987849E+00, 9.1801994153E-01],
	[4.8835000000E+04, 1.3276391804E+01, 3.1467790833E+00, 2.2990328816E+00, 1.2076238268E+00, 9.1803705314E-01],
	[4.8840000000E+04, 1.3278719053E+01, 3.1467989408E+00, 2.2997681887E+00, 1.2078488613E+00, 9.1805416134E-01],
	[4.8845000000E+04, 1.3281046471E+01, 3.1468187964E+00, 2.3005036555E+00, 1.2080738883E+00, 9.1807126610E-01],
	[4.8850000000E+04, 1.3283374059E+01, 3.1468386501E+00, 2.3012392822E+00, 1.2082989078E+00, 9.1808836744E-01],
	[4.8855000000E+04, 1.3285701817E+01, 3.1468585019E+00, 2.3019750687E+00, 1.2085239199E+00, 9.1810546536E-01],
	[4.8860000000E+04, 1.3288029745E+01, 3.1468783518E+00, 2.3027110150E+00, 1.2087489244E+00, 9.1812255985E-01],
	[4.8865000000E+04, 1.3290357842E+01, 3.1468981998E+00, 2.3034471212E+00, 1.2089739215E+00, 9.1813965092E-01],
	[4.8870000000E+04, 1.3292686109E+01, 3.1469180459E+00, 2.3041833872E+00, 1.2091989110E+00, 9.1815673856E-01],
	[4.8875000000E+04, 1.3295014545E+01, 3.1469378900E+00, 2.3049198132E+00, 1.2094238930E+00, 9.1817382278E-01],
	[4.8880000000E+04, 1.3297343151E+01, 3.1469577323E+00, 2.3056563991E+00, 1.2096488675E+00, 9.1819090358E-01],
	[4.8885000000E+04, 1.3299671927E+01, 3.1469775727E+00, 2.3063931449E+00, 1.2098738345E+00, 9.1820798096E-01],
	[4.8890000000E+04, 1.3302000872E+01, 3.1469974111E+00, 2.3071300507E+00, 1.2100987939E+00, 9.1822505492E-01],
	[4.8895000000E+04, 1.3304329986E+01, 3.1470172477E+00, 2.3078671165E+00, 1.2103237458E+00, 9.1824212546E-01],
	[4.8900000000E+04, 1.3306659271E+01, 3.1470370824E+00, 2.3086043422E+00, 1.2105486901E+00, 9.1825919258E-01],
	[4.8905000000E+04, 1.3308988725E+01, 3.1470569151E+00, 2.3093417280E+00, 1.2107736269E+00, 9.1827625628E-01],
	[4.8910000000E+04, 1.3311318348E+01, 3.1470767460E+00, 2.3100792738E+00, 1.2109985561E+00, 9.1829331656E-01],
	[4.8915000000E+04, 1.3313648141E+01, 3.1470965749E+00, 2.3108169796E+00, 1.2112234777E+00, 9.1831037342E-01],
	[4.8920000000E+04, 1.3315978104E+01, 3.1471164020E+00, 2.3115548455E+00, 1.2114483917E+00, 9.1832742687E-01],
	[4.8925000000E+04, 1.3318308236E+01, 3.1471362271E+00, 2.3122928715E+00, 1.2116732982E+00, 9.1834447690E-01],
	[4.8930000000E+04, 1.3320638538E+01, 3.1471560503E+00, 2.3130310575E+00, 1.2118981970E+00, 9.1836152351E-01],
	[4.8935000000E+04, 1.3322969009E+01, 3.1471758717E+00, 2.3137694037E+00, 1.2121230882E+00, 9.1837856671E-01],
	[4.8940000000E+04, 1.3325299650E+01, 3.1471956911E+00, 2.3145079101E+00, 1.2123479718E+00, 9.1839560650E-01],
	[4.8945000000E+04, 1.3327630461E+01, 3.1472155087E+00, 2.3152465766E+00, 1.2125728477E+00, 9.1841264287E-01],
	[4.8950000000E+04, 1.3329961441E+01, 3.1472353243E+00, 2.3159854032E+00, 1.2127977160E+00, 9.1842967582E-01],
	[4.8955000000E+04, 1.3332292590E+01, 3.1472551381E+00, 2.3167243901E+00, 1.2130225767E+00, 9.1844670537E-01],
	[4.8960000000E+04, 1.3334623909E+01, 3.1472749499E+00, 2.3174635372E+00, 1.2132474297E+00, 9.1846373150E-01],
	[4.8965000000E+04, 1.3336955398E+01, 3.1472947598E+00, 2.3182028445E+00, 1.2134722751E+00, 9.1848075422E-01],
	[4.8970000000E+04, 1.3339287056E+01, 3.1473145679E+00, 2.3189423120E+00, 1.2136971128E+00, 9.1849777353E-01],
	[4.8975000000E+04, 1.3341618884E+01, 3.1473343740E+00, 2.3196819398E+00, 1.2139219428E+00, 9.1851478944E-01],
	[4.8980000000E+04, 1.3343950881E+01, 3.1473541783E+00, 2.3204217279E+00, 1.2141467651E+00, 9.1853180193E-01],
	[4.8985000000E+04, 1.3346283047E+01, 3.1473739807E+00, 2.3211616763E+00, 1.2143715797E+00, 9.1854881101E-01],
	[4.8990000000E+04, 1.3348615384E+01, 3.1473937811E+00, 2.3219017850E+00, 1.2145963866E+00, 9.1856581668E-01],
	[4.8995000000E+04, 1.3350947889E+01, 3.1474135797E+00, 2.3226420541E+00, 1.2148211858E+00, 9.1858281895E-01],
	[4.9000000000E+04, 1.3353280564E+01, 3.1474333763E+00, 2.3233824835E+00, 1.2150459773E+00, 9.1859981781E-01],
	[4.9005000000E+04, 1.3355613409E+01, 3.1474531711E+00, 2.3241230733E+00, 1.2152707611E+00, 9.1861681326E-01],
	[4.9010000000E+04, 1.3357946423E+01, 3.1474729640E+00, 2.3248638235E+00, 1.2154955371E+00, 9.1863380531E-01],
	[4.9015000000E+04, 1.3360279607E+01, 3.1474927550E+00, 2.3256047341E+00, 1.2157203054E+00, 9.1865079395E-01],
	[4.9020000000E+04, 1.3362612960E+01, 3.1475125441E+00, 2.3263458052E+00, 1.2159450660E+00, 9.1866777919E-01],
	[4.9025000000E+04, 1.3364946482E+01, 3.1475323313E+00, 2.3270870367E+00, 1.2161698188E+00, 9.1868476102E-01],
	[4.9030000000E+04, 1.3367280174E+01, 3.1475521166E+00, 2.3278284286E+00, 1.2163945638E+00, 9.1870173945E-01],
	[4.9035000000E+04, 1.3369614036E+01, 3.1475719000E+00, 2.3285699811E+00, 1.2166193010E+00, 9.1871871448E-01],
	[4.9040000000E+04, 1.3371948066E+01, 3.1475916815E+00, 2.3293116940E+00, 1.2168440305E+00, 9.1873568610E-01],
	[4.9045000000E+04, 1.3374282267E+01, 3.1476114611E+00, 2.3300535675E+00, 1.2170687521E+00, 9.1875265432E-01],
	[4.9050000000E+04, 1.3376616637E+01, 3.1476312388E+00, 2.3307956015E+00, 1.2172934660E+00, 9.1876961915E-01],
	[4.9055000000E+04, 1.3378951176E+01, 3.1476510147E+00, 2.3315377961E+00, 1.2175181721E+00, 9.1878658057E-01],
	[4.9060000000E+04, 1.3381285884E+01, 3.1476707886E+00, 2.3322801512E+00, 1.2177428703E+00, 9.1880353859E-01],
	[4.9065000000E+04, 1.3383620762E+01, 3.1476905607E+00, 2.3330226670E+00, 1.2179675607E+00, 9.1882049321E-01],
	[4.9070000000E+04, 1.3385958622E+01, 3.1477108560E+00, 2.3337653433E+00, 1.2181923453E+00, 9.1883744444E-01],
	[4.9075000000E+04, 1.3388299749E+01, 3.1477317277E+00, 2.3345081803E+00, 1.2184172343E+00, 9.1885439227E-01],
	[4.9080000000E+04, 1.3390641047E+01, 3.1477525973E+00, 2.3352511780E+00, 1.2186421156E+00, 9.1887133670E-01],
	[4.9085000000E+04, 1.3392982516E+01, 3.1477734650E+00, 2.3359943363E+00, 1.2188669892E+00, 9.1888827773E-01],
	[4.9090000000E+04, 1.3395324155E+01, 3.1477943306E+00, 2.3367376553E+00, 1.2190918550E+00, 9.1890521537E-01],
	[4.9095000000E+04, 1.3397665966E+01, 3.1478151943E+00, 2.3374811350E+00, 1.2193167131E+00, 9.1892214961E-01],
	[4.9100000000E+04, 1.3400007947E+01, 3.1478360560E+00, 2.3382247755E+00, 1.2195415634E+00, 9.1893908046E-01],
	[4.9105000000E+04, 1.3402350099E+01, 3.1478569157E+00, 2.3389685766E+00, 1.2197664060E+00, 9.1895600791E-01],
	[4.9110000000E+04, 1.3404692422E+01, 3.1478777734E+00, 2.3397125386E+00, 1.2199912407E+00, 9.1897293198E-01],
	[4.9115000000E+04, 1.3407034915E+01, 3.1478986292E+00, 2.3404566613E+00, 1.2202160677E+00, 9.1898985264E-01],
	[4.9120000000E+04, 1.3409377580E+01, 3.1479194829E+00, 2.3412009448E+00, 1.2204408869E+00, 9.1900676992E-01],
	[4.9125000000E+04, 1.3411720415E+01, 3.1479403347E+00, 2.3419453892E+00, 1.2206656983E+00, 9.1902368380E-01],
	[4.9130000000E+04, 1.3414063422E+01, 3.1479611845E+00, 2.3426899944E+00, 1.2208905018E+00, 9.1904059430E-01],
	[4.9135000000E+04, 1.3416406599E+01, 3.1479820323E+00, 2.3434347604E+00, 1.2211152976E+00, 9.1905750140E-01],
	[4.9140000000E+04, 1.3418749947E+01, 3.1480028781E+00, 2.3441796873E+00, 1.2213400855E+00, 9.1907440511E-01],
	[4.9145000000E+04, 1.3421093465E+01, 3.1480237219E+00, 2.3449247751E+00, 1.2215648656E+00, 9.1909130544E-01],
	[4.9150000000E+04, 1.3423437155E+01, 3.1480445638E+00, 2.3456700238E+00, 1.2217896378E+00, 9.1910820237E-01],
	[4.9155000000E+04, 1.3425781015E+01, 3.1480654037E+00, 2.3464154334E+00, 1.2220144022E+00, 9.1912509592E-01],
	[4.9160000000E+04, 1.3428125046E+01, 3.1480862415E+00, 2.3471610040E+00, 1.2222391588E+00, 9.1914198608E-01],
	[4.9165000000E+04, 1.3430469248E+01, 3.1481070774E+00, 2.3479067355E+00, 1.2224639075E+00, 9.1915887285E-01],
	[4.9170000000E+04, 1.3432813621E+01, 3.1481279114E+00, 2.3486526280E+00, 1.2226886483E+00, 9.1917575624E-01],
	[4.9175000000E+04, 1.3435158164E+01, 3.1481487433E+00, 2.3493986815E+00, 1.2229133812E+00, 9.1919263625E-01],
	[4.9180000000E+04, 1.3437502878E+01, 3.1481695733E+00, 2.3501448961E+00, 1.2231381062E+00, 9.1920951286E-01],
	[4.9185000000E+04, 1.3439847763E+01, 3.1481904013E+00, 2.3508912717E+00, 1.2233628233E+00, 9.1922638610E-01],
	[4.9190000000E+04, 1.3442192819E+01, 3.1482112273E+00, 2.3516378083E+00, 1.2235875326E+00, 9.1924325595E-01],
	[4.9195000000E+04, 1.3444538045E+01, 3.1482320513E+00, 2.3523845060E+00, 1.2238122339E+00, 9.1926012242E-01],
	[4.9200000000E+04, 1.3446883443E+01, 3.1482528733E+00, 2.3531313648E+00, 1.2240369273E+00, 9.1927698550E-01],
	[4.9205000000E+04, 1.3449229011E+01, 3.1482736934E+00, 2.3538783847E+00, 1.2242616127E+00, 9.1929384520E-01],
	[4.9210000000E+04, 1.3451574750E+01, 3.1482945115E+00, 2.3546255657E+00, 1.2244862902E+00, 9.1931070153E-01],
	[4.9215000000E+04, 1.3453920659E+01, 3.1483153276E+00, 2.3553729079E+00, 1.2247109598E+00, 9.1932755447E-01],
	[4.9220000000E+04, 1.3456266739E+01, 3.1483361418E+00, 2.3561204113E+00, 1.2249356214E+00, 9.1934440403E-01],
	[4.9225000000E+04, 1.3458612990E+01, 3.1483569539E+00, 2.3568680758E+00, 1.2251602751E+00, 9.1936125022E-01],
	[4.9230000000E+04, 1.3460959412E+01, 3.1483777641E+00, 2.3576159015E+00, 1.2253849208E+00, 9.1937809302E-01],
	[4.9235000000E+04, 1.3463306004E+01, 3.1483985723E+00, 2.3583638885E+00, 1.2256095585E+00, 9.1939493245E-01],
	[4.9240000000E+04, 1.3465652767E+01, 3.1484193785E+00, 2.3591120367E+00, 1.2258341882E+00, 9.1941176850E-01],
	[4.9245000000E+04, 1.3467999701E+01, 3.1484401828E+00, 2.3598603461E+00, 1.2260588100E+00, 9.1942860117E-01],
	[4.9250000000E+04, 1.3470346806E+01, 3.1484609851E+00, 2.3606088168E+00, 1.2262834237E+00, 9.1944543047E-01],
	[4.9255000000E+04, 1.3472694081E+01, 3.1484817854E+00, 2.3613574489E+00, 1.2265080294E+00, 9.1946225639E-01],
	[4.9260000000E+04, 1.3475041527E+01, 3.1485025837E+00, 2.3621062422E+00, 1.2267326272E+00, 9.1947907894E-01],
	[4.9265000000E+04, 1.3477389144E+01, 3.1485233801E+00, 2.3628551969E+00, 1.2269572168E+00, 9.1949589811E-01],
	[4.9270000000E+04, 1.3479736931E+01, 3.1485441745E+00, 2.3636043129E+00, 1.2271817985E+00, 9.1951271391E-01],
	[4.9275000000E+04, 1.3482084889E+01, 3.1485649669E+00, 2.3643535903E+00, 1.2274063721E+00, 9.1952952633E-01],
	[4.9280000000E+04, 1.3484433018E+01, 3.1485857573E+00, 2.3651030290E+00, 1.2276309377E+00, 9.1954633539E-01],
	[4.9285000000E+04, 1.3486781317E+01, 3.1486065458E+00, 2.3658526292E+00, 1.2278554952E+00, 9.1956314107E-01],
	[4.9290000000E+04, 1.3489129787E+01, 3.1486273323E+00, 2.3666023908E+00, 1.2280800446E+00, 9.1957994338E-01],
	[4.9295000000E+04, 1.3491478428E+01, 3.1486481168E+00, 2.3673523138E+00, 1.2283045860E+00, 9.1959674232E-01],
	[4.9300000000E+04, 1.3493827239E+01, 3.1486688994E+00, 2.3681023983E+00, 1.2285291193E+00, 9.1961353789E-01],
	[4.9305000000E+04, 1.3496176221E+01, 3.1486896799E+00, 2.3688526443E+00, 1.2287536445E+00, 9.1963033010E-01],
	[4.9310000000E+04, 1.3498525374E+01, 3.1487104586E+00, 2.3696030517E+00, 1.2289781616E+00, 9.1964711893E-01],
	[4.9315000000E+04, 1.3500874697E+01, 3.1487312352E+00, 2.3703536207E+00, 1.2292026706E+00, 9.1966390439E-01],
	[4.9320000000E+04, 1.3503224191E+01, 3.1487520099E+00, 2.3711043512E+00, 1.2294271715E+00, 9.1968068649E-01],
	[4.9325000000E+04, 1.3505573855E+01, 3.1487727826E+00, 2.3718552433E+00, 1.2296516643E+00, 9.1969746522E-01],
	[4.9330000000E+04, 1.3507923690E+01, 3.1487935533E+00, 2.3726062969E+00, 1.2298761489E+00, 9.1971424059E-01],
	[4.9335000000E+04, 1.3510273696E+01, 3.1488143221E+00, 2.3733575122E+00, 1.2301006254E+00, 9.1973101259E-01],
	[4.9340000000E+04, 1.3512623873E+01, 3.1488350889E+00, 2.3741088890E+00, 1.2303250938E+00, 9.1974778122E-01],
	[4.9345000000E+04, 1.3514974220E+01, 3.1488558537E+00, 2.3748604274E+00, 1.2305495540E+00, 9.1976454649E-01],
	[4.9350000000E+04, 1.3517324737E+01, 3.1488766166E+00, 2.3756121275E+00, 1.2307740061E+00, 9.1978130840E-01],
	[4.9355000000E+04, 1.3519675426E+01, 3.1488973775E+00, 2.3763639893E+00, 1.2309984500E+00, 9.1979806694E-01],
	[4.9360000000E+04, 1.3522026284E+01, 3.1489181364E+00, 2.3771160127E+00, 1.2312228857E+00, 9.1981482213E-01],
	[4.9365000000E+04, 1.3524377314E+01, 3.1489388934E+00, 2.3778681979E+00, 1.2314473132E+00, 9.1983157395E-01],
	[4.9370000000E+04, 1.3526728514E+01, 3.1489596484E+00, 2.3786205447E+00, 1.2316717326E+00, 9.1984832241E-01],
	[4.9375000000E+04, 1.3529079884E+01, 3.1489804015E+00, 2.3793730533E+00, 1.2318961437E+00, 9.1986506750E-01],
	[4.9380000000E+04, 1.3531431426E+01, 3.1490011525E+00, 2.3801257236E+00, 1.2321205467E+00, 9.1988180924E-01],
	[4.9385000000E+04, 1.3533783137E+01, 3.1490219016E+00, 2.3808785557E+00, 1.2323449414E+00, 9.1989854762E-01],
	[4.9390000000E+04, 1.3536135020E+01, 3.1490426488E+00, 2.3816315496E+00, 1.2325693279E+00, 9.1991528264E-01],
	[4.9395000000E+04, 1.3538487073E+01, 3.1490633940E+00, 2.3823847053E+00, 1.2327937062E+00, 9.1993201430E-01],
	[4.9400000000E+04, 1.3540839296E+01, 3.1490841372E+00, 2.3831380229E+00, 1.2330180763E+00, 9.1994874261E-01],
	[4.9405000000E+04, 1.3543191690E+01, 3.1491048784E+00, 2.3838915023E+00, 1.2332424381E+00, 9.1996546756E-01],
	[4.9410000000E+04, 1.3545544255E+01, 3.1491256177E+00, 2.3846451435E+00, 1.2334667916E+00, 9.1998218915E-01],
	[4.9415000000E+04, 1.3547896990E+01, 3.1491463551E+00, 2.3853989466E+00, 1.2336911369E+00, 9.1999890739E-01],
	[4.9420000000E+04, 1.3550249895E+01, 3.1491670904E+00, 2.3861529116E+00, 1.2339154739E+00, 9.2001562227E-01],
	[4.9425000000E+04, 1.3552602971E+01, 3.1491878238E+00, 2.3869070386E+00, 1.2341398027E+00, 9.2003233380E-01],
	[4.9430000000E+04, 1.3554956218E+01, 3.1492085553E+00, 2.3876613275E+00, 1.2343641231E+00, 9.2004904197E-01],
	[4.9435000000E+04, 1.3557309635E+01, 3.1492292848E+00, 2.3884157783E+00, 1.2345884353E+00, 9.2006574679E-01],
	[4.9440000000E+04, 1.3559663223E+01, 3.1492500123E+00, 2.3891703911E+00, 1.2348127392E+00, 9.2008244826E-01],
	[4.9445000000E+04, 1.3562016981E+01, 3.1492707379E+00, 2.3899251659E+00, 1.2350370347E+00, 9.2009914638E-01],
	[4.9450000000E+04, 1.3564370910E+01, 3.1492914615E+00, 2.3906801027E+00, 1.2352613220E+00, 9.2011584114E-01],
	[4.9455000000E+04, 1.3566725009E+01, 3.1493121831E+00, 2.3914352016E+00, 1.2354856009E+00, 9.2013253256E-01],
	[4.9460000000E+04, 1.3569079279E+01, 3.1493329028E+00, 2.3921904624E+00, 1.2357098715E+00, 9.2014922062E-01],
	[4.9465000000E+04, 1.3571433719E+01, 3.1493536206E+00, 2.3929458854E+00, 1.2359341337E+00, 9.2016590534E-01],
	[4.9470000000E+04, 1.3573788330E+01, 3.1493743363E+00, 2.3937014704E+00, 1.2361583877E+00, 9.2018258671E-01],
	[4.9475000000E+04, 1.3576143111E+01, 3.1493950501E+00, 2.3944572176E+00, 1.2363826332E+00, 9.2019926473E-01],
	[4.9480000000E+04, 1.3578498063E+01, 3.1494157620E+00, 2.3952131268E+00, 1.2366068704E+00, 9.2021593940E-01],
	[4.9485000000E+04, 1.3580853185E+01, 3.1494364719E+00, 2.3959691982E+00, 1.2368310992E+00, 9.2023261072E-01],
	[4.9490000000E+04, 1.3583208478E+01, 3.1494571799E+00, 2.3967254318E+00, 1.2370553197E+00, 9.2024927870E-01],
	[4.9495000000E+04, 1.3585563941E+01, 3.1494778858E+00, 2.3974818275E+00, 1.2372795317E+00, 9.2026594333E-01],
	[4.9500000000E+04, 1.3587919575E+01, 3.1494985899E+00, 2.3982383854E+00, 1.2375037354E+00, 9.2028260462E-01],
	[4.9505000000E+04, 1.3590275379E+01, 3.1495192920E+00, 2.3989951055E+00, 1.2377279307E+00, 9.2029926257E-01],
	[4.9510000000E+04, 1.3592631353E+01, 3.1495399921E+00, 2.3997519879E+00, 1.2379521176E+00, 9.2031591717E-01],
	[4.9515000000E+04, 1.3594987498E+01, 3.1495606903E+00, 2.4005090325E+00, 1.2381762960E+00, 9.2033256842E-01],
	[4.9520000000E+04, 1.3597343814E+01, 3.1495813865E+00, 2.4012662394E+00, 1.2384004660E+00, 9.2034921634E-01],
	[4.9525000000E+04, 1.3599700299E+01, 3.1496020807E+00, 2.4020236085E+00, 1.2386246276E+00, 9.2036586091E-01],
	[4.9530000000E+04, 1.3602056956E+01, 3.1496227731E+00, 2.4027811400E+00, 1.2388487808E+00, 9.2038250214E-01],
	[4.9535000000E+04, 1.3604413782E+01, 3.1496434634E+00, 2.4035388338E+00, 1.2390729255E+00, 9.2039914003E-01],
	[4.9540000000E+04, 1.3606770779E+01, 3.1496641518E+00, 2.4042966899E+00, 1.2392970617E+00, 9.2041577458E-01],
	[4.9545000000E+04, 1.3609127947E+01, 3.1496848383E+00, 2.4050547084E+00, 1.2395211895E+00, 9.2043240580E-01],
	[4.9550000000E+04, 1.3611485285E+01, 3.1497055228E+00, 2.4058128893E+00, 1.2397453088E+00, 9.2044903367E-01],
	[4.9555000000E+04, 1.3613842793E+01, 3.1497262053E+00, 2.4065712326E+00, 1.2399694197E+00, 9.2046565820E-01],
	[4.9560000000E+04, 1.3616200472E+01, 3.1497468859E+00, 2.4073297382E+00, 1.2401935220E+00, 9.2048227940E-01],
	[4.9565000000E+04, 1.3618558321E+01, 3.1497675646E+00, 2.4080884063E+00, 1.2404176159E+00, 9.2049889726E-01],
	[4.9570000000E+04, 1.3620916341E+01, 3.1497882413E+00, 2.4088472369E+00, 1.2406417013E+00, 9.2051551179E-01],
	[4.9575000000E+04, 1.3623274531E+01, 3.1498089160E+00, 2.4096062299E+00, 1.2408657781E+00, 9.2053212297E-01],
	[4.9580000000E+04, 1.3625632891E+01, 3.1498295888E+00, 2.4103653855E+00, 1.2410898465E+00, 9.2054873083E-01],
	[4.9585000000E+04, 1.3627991422E+01, 3.1498502597E+00, 2.4111247035E+00, 1.2413139063E+00, 9.2056533535E-01],
	[4.9590000000E+04, 1.3630350123E+01, 3.1498709286E+00, 2.4118841840E+00, 1.2415379576E+00, 9.2058193653E-01],
	[4.9595000000E+04, 1.3632708994E+01, 3.1498915955E+00, 2.4126438271E+00, 1.2417620003E+00, 9.2059853438E-01],
	[4.9600000000E+04, 1.3635068036E+01, 3.1499122605E+00, 2.4134036328E+00, 1.2419860345E+00, 9.2061512890E-01],
	[4.9605000000E+04, 1.3637427248E+01, 3.1499329236E+00, 2.4141636010E+00, 1.2422100602E+00, 9.2063172009E-01],
	[4.9610000000E+04, 1.3639786631E+01, 3.1499535847E+00, 2.4149237318E+00, 1.2424340772E+00, 9.2064830795E-01],
	[4.9615000000E+04, 1.3642146183E+01, 3.1499742439E+00, 2.4156840253E+00, 1.2426580858E+00, 9.2066489247E-01],
	[4.9620000000E+04, 1.3644505907E+01, 3.1499949011E+00, 2.4164444814E+00, 1.2428820857E+00, 9.2068147367E-01],
	[4.9625000000E+04, 1.3646865800E+01, 3.1500155564E+00, 2.4172051001E+00, 1.2431060770E+00, 9.2069805154E-01],
	[4.9630000000E+04, 1.3649225864E+01, 3.1500362097E+00, 2.4179658815E+00, 1.2433300598E+00, 9.2071462607E-01],
	[4.9635000000E+04, 1.3651586098E+01, 3.1500568611E+00, 2.4187268256E+00, 1.2435540340E+00, 9.2073119728E-01],
	[4.9640000000E+04, 1.3653946503E+01, 3.1500775105E+00, 2.4194879324E+00, 1.2437779995E+00, 9.2074776517E-01],
	[4.9645000000E+04, 1.3656307078E+01, 3.1500981580E+00, 2.4202492019E+00, 1.2440019564E+00, 9.2076432972E-01],
	[4.9650000000E+04, 1.3658667823E+01, 3.1501188035E+00, 2.4210106342E+00, 1.2442259047E+00, 9.2078089095E-01],
	[4.9655000000E+04, 1.3661028738E+01, 3.1501394471E+00, 2.4217722293E+00, 1.2444498444E+00, 9.2079744885E-01],
	[4.9660000000E+04, 1.3663389824E+01, 3.1501600888E+00, 2.4225339871E+00, 1.2446737755E+00, 9.2081400343E-01],
	[4.9665000000E+04, 1.3665751080E+01, 3.1501807285E+00, 2.4232959077E+00, 1.2448976978E+00, 9.2083055469E-01],
	[4.9670000000E+04, 1.3668112507E+01, 3.1502013663E+00, 2.4240579911E+00, 1.2451216116E+00, 9.2084710262E-01],
	[4.9675000000E+04, 1.3670474103E+01, 3.1502220021E+00, 2.4248202374E+00, 1.2453455167E+00, 9.2086364722E-01],
	[4.9680000000E+04, 1.3672835870E+01, 3.1502426360E+00, 2.4255826465E+00, 1.2455694131E+00, 9.2088018851E-01],
	[4.9685000000E+04, 1.3675197807E+01, 3.1502632680E+00, 2.4263452185E+00, 1.2457933008E+00, 9.2089672647E-01],
	[4.9690000000E+04, 1.3677559915E+01, 3.1502838980E+00, 2.4271079534E+00, 1.2460171798E+00, 9.2091326111E-01],
	[4.9695000000E+04, 1.3679922193E+01, 3.1503045260E+00, 2.4278708512E+00, 1.2462410502E+00, 9.2092979243E-01],
	[4.9700000000E+04, 1.3682284641E+01, 3.1503251522E+00, 2.4286339120E+00, 1.2464649118E+00, 9.2094632043E-01],
	[4.9705000000E+04, 1.3684647259E+01, 3.1503457764E+00, 2.4293971357E+00, 1.2466887648E+00, 9.2096284511E-01],
	[4.9710000000E+04, 1.3687010048E+01, 3.1503663986E+00, 2.4301605223E+00, 1.2469126090E+00, 9.2097936647E-01],
	[4.9715000000E+04, 1.3689373006E+01, 3.1503870189E+00, 2.4309240719E+00, 1.2471364445E+00, 9.2099588452E-01],
	[4.9720000000E+04, 1.3691736135E+01, 3.1504076373E+00, 2.4316877846E+00, 1.2473602713E+00, 9.2101239924E-01],
	[4.9725000000E+04, 1.3694099435E+01, 3.1504282537E+00, 2.4324516602E+00, 1.2475840893E+00, 9.2102891065E-01],
	[4.9730000000E+04, 1.3696462904E+01, 3.1504488682E+00, 2.4332156989E+00, 1.2478078986E+00, 9.2104541875E-01],
	[4.9735000000E+04, 1.3698826544E+01, 3.1504694808E+00, 2.4339799007E+00, 1.2480316992E+00, 9.2106192352E-01],
	[4.9740000000E+04, 1.3701190354E+01, 3.1504900914E+00, 2.4347442655E+00, 1.2482554909E+00, 9.2107842498E-01],
	[4.9745000000E+04, 1.3703554334E+01, 3.1505107001E+00, 2.4355087934E+00, 1.2484792739E+00, 9.2109492313E-01],
	[4.9750000000E+04, 1.3705918485E+01, 3.1505313068E+00, 2.4362734844E+00, 1.2487030482E+00, 9.2111141797E-01],
	[4.9755000000E+04, 1.3708282805E+01, 3.1505519116E+00, 2.4370383386E+00, 1.2489268136E+00, 9.2112790949E-01],
	[4.9760000000E+04, 1.3710647296E+01, 3.1505725145E+00, 2.4378033559E+00, 1.2491505703E+00, 9.2114439769E-01],
	[4.9765000000E+04, 1.3713011957E+01, 3.1505931154E+00, 2.4385685364E+00, 1.2493743181E+00, 9.2116088259E-01],
	[4.9770000000E+04, 1.3715376789E+01, 3.1506137144E+00, 2.4393338801E+00, 1.2495980572E+00, 9.2117736418E-01],
	[4.9775000000E+04, 1.3717741790E+01, 3.1506343115E+00, 2.4400993869E+00, 1.2498217874E+00, 9.2119384245E-01],
	[4.9780000000E+04, 1.3720106962E+01, 3.1506549066E+00, 2.4408650570E+00, 1.2500455088E+00, 9.2121031741E-01],
	[4.9785000000E+04, 1.3722472304E+01, 3.1506754998E+00, 2.4416308904E+00, 1.2502692214E+00, 9.2122678907E-01],
	[4.9790000000E+04, 1.3724837816E+01, 3.1506960911E+00, 2.4423968870E+00, 1.2504929252E+00, 9.2124325741E-01],
	[4.9795000000E+04, 1.3727203498E+01, 3.1507166804E+00, 2.4431630468E+00, 1.2507166201E+00, 9.2125972245E-01],
	[4.9800000000E+04, 1.3729569350E+01, 3.1507372678E+00, 2.4439293700E+00, 1.2509403061E+00, 9.2127618418E-01],
	[4.9805000000E+04, 1.3731935373E+01, 3.1507578533E+00, 2.4446958565E+00, 1.2511639833E+00, 9.2129264260E-01],
	[4.9810000000E+04, 1.3734301565E+01, 3.1507784368E+00, 2.4454625063E+00, 1.2513876517E+00, 9.2130909772E-01],
	[4.9815000000E+04, 1.3736667928E+01, 3.1507990184E+00, 2.4462293195E+00, 1.2516113111E+00, 9.2132554953E-01],
	[4.9820000000E+04, 1.3739034461E+01, 3.1508195981E+00, 2.4469962960E+00, 1.2518349617E+00, 9.2134199803E-01],
	[4.9825000000E+04, 1.3741401164E+01, 3.1508401759E+00, 2.4477634359E+00, 1.2520586034E+00, 9.2135844323E-01],
	[4.9830000000E+04, 1.3743768037E+01, 3.1508607517E+00, 2.4485307392E+00, 1.2522822362E+00, 9.2137488513E-01],
	[4.9835000000E+04, 1.3746135081E+01, 3.1508813256E+00, 2.4492982060E+00, 1.2525058600E+00, 9.2139132372E-01],
	[4.9840000000E+04, 1.3748502294E+01, 3.1509018975E+00, 2.4500658362E+00, 1.2527294750E+00, 9.2140775902E-01],
	[4.9845000000E+04, 1.3750869678E+01, 3.1509224675E+00, 2.4508336299E+00, 1.2529530810E+00, 9.2142419100E-01],
	[4.9850000000E+04, 1.3753237232E+01, 3.1509430356E+00, 2.4516015870E+00, 1.2531766782E+00, 9.2144061969E-01],
	[4.9855000000E+04, 1.3755604956E+01, 3.1509636018E+00, 2.4523697076E+00, 1.2534002664E+00, 9.2145704508E-01],
	[4.9860000000E+04, 1.3757975783E+01, 3.1509846977E+00, 2.4531379918E+00, 1.2536239541E+00, 9.2147346717E-01],
	[4.9865000000E+04, 1.3760349815E+01, 3.1510063413E+00, 2.4539064395E+00, 1.2538477452E+00, 9.2148988595E-01],
	[4.9870000000E+04, 1.3762724019E+01, 3.1510279830E+00, 2.4546750507E+00, 1.2540715275E+00, 9.2150630144E-01],
	[4.9875000000E+04, 1.3765098395E+01, 3.1510496226E+00, 2.4554438255E+00, 1.2542953009E+00, 9.2152271363E-01],
	[4.9880000000E+04, 1.3767472941E+01, 3.1510712603E+00, 2.4562127639E+00, 1.2545190654E+00, 9.2153912252E-01],
	[4.9885000000E+04, 1.3769847660E+01, 3.1510928959E+00, 2.4569818660E+00, 1.2547428211E+00, 9.2155552812E-01],
	[4.9890000000E+04, 1.3772222550E+01, 3.1511145294E+00, 2.4577511316E+00, 1.2549665679E+00, 9.2157193042E-01],
	[4.9895000000E+04, 1.3774597612E+01, 3.1511361610E+00, 2.4585205609E+00, 1.2551903059E+00, 9.2158832942E-01],
	[4.9900000000E+04, 1.3776972845E+01, 3.1511577905E+00, 2.4592901538E+00, 1.2554140349E+00, 9.2160472513E-01],
	[4.9905000000E+04, 1.3779348249E+01, 3.1511794180E+00, 2.4600599105E+00, 1.2556377551E+00, 9.2162111754E-01],
	[4.9910000000E+04, 1.3781723825E+01, 3.1512010435E+00, 2.4608298308E+00, 1.2558614663E+00, 9.2163750666E-01],
	[4.9915000000E+04, 1.3784099573E+01, 3.1512226670E+00, 2.4615999149E+00, 1.2560851687E+00, 9.2165389248E-01],
	[4.9920000000E+04, 1.3786475492E+01, 3.1512442885E+00, 2.4623701626E+00, 1.2563088621E+00, 9.2167027502E-01],
	[4.9925000000E+04, 1.3788851583E+01, 3.1512659079E+00, 2.4631405742E+00, 1.2565325466E+00, 9.2168665426E-01],
	[4.9930000000E+04, 1.3791227845E+01, 3.1512875254E+00, 2.4639111495E+00, 1.2567562222E+00, 9.2170303021E-01],
	[4.9935000000E+04, 1.3793604279E+01, 3.1513091408E+00, 2.4646818886E+00, 1.2569798888E+00, 9.2171940287E-01],
	[4.9940000000E+04, 1.3795980884E+01, 3.1513307542E+00, 2.4654527916E+00, 1.2572035465E+00, 9.2173577224E-01],
	[4.9945000000E+04, 1.3798357660E+01, 3.1513523656E+00, 2.4662238583E+00, 1.2574271953E+00, 9.2175213832E-01],
	[4.9950000000E+04, 1.3800734608E+01, 3.1513739749E+00, 2.4669950889E+00, 1.2576508350E+00, 9.2176850111E-01],
	[4.9955000000E+04, 1.3803111728E+01, 3.1513955823E+00, 2.4677664834E+00, 1.2578744658E+00, 9.2178486061E-01],
	[4.9960000000E+04, 1.3805489019E+01, 3.1514171876E+00, 2.4685380417E+00, 1.2580980877E+00, 9.2180121682E-01],
	[4.9965000000E+04, 1.3807866482E+01, 3.1514387910E+00, 2.4693097640E+00, 1.2583217005E+00, 9.2181756975E-01],
	[4.9970000000E+04, 1.3810244116E+01, 3.1514603923E+00, 2.4700816502E+00, 1.2585453044E+00, 9.2183391939E-01],
	[4.9975000000E+04, 1.3812621921E+01, 3.1514819916E+00, 2.4708537003E+00, 1.2587688992E+00, 9.2185026574E-01],
	[4.9980000000E+04, 1.3814999898E+01, 3.1515035888E+00, 2.4716259143E+00, 1.2589924851E+00, 9.2186660881E-01],
	[4.9985000000E+04, 1.3817378046E+01, 3.1515251841E+00, 2.4723982924E+00, 1.2592160619E+00, 9.2188294860E-01],
	[4.9990000000E+04, 1.3819756366E+01, 3.1515467774E+00, 2.4731708344E+00, 1.2594396297E+00, 9.2189928510E-01],
	[4.9995000000E+04, 1.3822134857E+01, 3.1515683686E+00, 2.4739435405E+00, 1.2596631885E+00, 9.2191561832E-01],
	[5.0000000000E+04, 1.3824513520E+01, 3.1515899579E+00, 2.4747164106E+00, 1.2598867383E+00, 9.2193194825E-01],
	[5.0005000000E+04, 1.3826892354E+01, 3.1516115451E+00, 2.4754909060E+00, 1.2601106576E+00, 9.2194827490E-01],
	[5.0010000000E+04, 1.3829271360E+01, 3.1516331303E+00, 2.4762655663E+00, 1.2603345679E+00, 9.2196459827E-01],
	[5.0015000000E+04, 1.3831650537E+01, 3.1516547135E+00, 2.4770403914E+00, 1.2605584692E+00, 9.2198091836E-01],
	[5.0020000000E+04, 1.3834029885E+01, 3.1516762947E+00, 2.4778153814E+00, 1.2607823613E+00, 9.2199723517E-01],
	[5.0025000000E+04, 1.3836409405E+0