# coding: utf-8

"""
    Xero Finance API

    The Finance API is a collection of endpoints which customers can use in the course of a loan application, which may assist lenders to gain the confidence they need to provide capital.  # noqa: E501

    Contact: api@xero.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401

from xero_python.models import BaseModel


class CashflowResponse(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "start_date": "date",
        "end_date": "date",
        "cash_balance": "CashBalance",
        "cashflow_activities": "list[CashflowActivity]",
    }

    attribute_map = {
        "start_date": "startDate",
        "end_date": "endDate",
        "cash_balance": "cashBalance",
        "cashflow_activities": "cashflowActivities",
    }

    def __init__(
        self,
        start_date=None,
        end_date=None,
        cash_balance=None,
        cashflow_activities=None,
    ):  # noqa: E501
        """CashflowResponse - a model defined in OpenAPI"""  # noqa: E501

        self._start_date = None
        self._end_date = None
        self._cash_balance = None
        self._cashflow_activities = None
        self.discriminator = None

        if start_date is not None:
            self.start_date = start_date
        if end_date is not None:
            self.end_date = end_date
        if cash_balance is not None:
            self.cash_balance = cash_balance
        if cashflow_activities is not None:
            self.cashflow_activities = cashflow_activities

    @property
    def start_date(self):
        """Gets the start_date of this CashflowResponse.  # noqa: E501

        Start date of the report  # noqa: E501

        :return: The start_date of this CashflowResponse.  # noqa: E501
        :rtype: date
        """
        return self._start_date

    @start_date.setter
    def start_date(self, start_date):
        """Sets the start_date of this CashflowResponse.

        Start date of the report  # noqa: E501

        :param start_date: The start_date of this CashflowResponse.  # noqa: E501
        :type: date
        """

        self._start_date = start_date

    @property
    def end_date(self):
        """Gets the end_date of this CashflowResponse.  # noqa: E501

        End date of the report  # noqa: E501

        :return: The end_date of this CashflowResponse.  # noqa: E501
        :rtype: date
        """
        return self._end_date

    @end_date.setter
    def end_date(self, end_date):
        """Sets the end_date of this CashflowResponse.

        End date of the report  # noqa: E501

        :param end_date: The end_date of this CashflowResponse.  # noqa: E501
        :type: date
        """

        self._end_date = end_date

    @property
    def cash_balance(self):
        """Gets the cash_balance of this CashflowResponse.  # noqa: E501


        :return: The cash_balance of this CashflowResponse.  # noqa: E501
        :rtype: CashBalance
        """
        return self._cash_balance

    @cash_balance.setter
    def cash_balance(self, cash_balance):
        """Sets the cash_balance of this CashflowResponse.


        :param cash_balance: The cash_balance of this CashflowResponse.  # noqa: E501
        :type: CashBalance
        """

        self._cash_balance = cash_balance

    @property
    def cashflow_activities(self):
        """Gets the cashflow_activities of this CashflowResponse.  # noqa: E501

        Break down of cash and cash equivalents for the period  # noqa: E501

        :return: The cashflow_activities of this CashflowResponse.  # noqa: E501
        :rtype: list[CashflowActivity]
        """
        return self._cashflow_activities

    @cashflow_activities.setter
    def cashflow_activities(self, cashflow_activities):
        """Sets the cashflow_activities of this CashflowResponse.

        Break down of cash and cash equivalents for the period  # noqa: E501

        :param cashflow_activities: The cashflow_activities of this CashflowResponse.  # noqa: E501
        :type: list[CashflowActivity]
        """

        self._cashflow_activities = cashflow_activities
