# coding: utf-8

"""
    Xero Finance API

    The Finance API is a collection of endpoints which customers can use in the course of a loan application, which may assist lenders to gain the confidence they need to provide capital.  # noqa: E501

    Contact: api@xero.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401

from xero_python.models import BaseModel


class CashflowActivity(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "name": "str",
        "total": "float",
        "cashflow_types": "list[CashflowType]",
    }

    attribute_map = {
        "name": "name",
        "total": "total",
        "cashflow_types": "cashflowTypes",
    }

    def __init__(self, name=None, total=None, cashflow_types=None):  # noqa: E501
        """CashflowActivity - a model defined in OpenAPI"""  # noqa: E501

        self._name = None
        self._total = None
        self._cashflow_types = None
        self.discriminator = None

        if name is not None:
            self.name = name
        if total is not None:
            self.total = total
        if cashflow_types is not None:
            self.cashflow_types = cashflow_types

    @property
    def name(self):
        """Gets the name of this CashflowActivity.  # noqa: E501

        Name of the cashflow activity type. It will be either Operating Activities, Investing Activities or Financing Activities  # noqa: E501

        :return: The name of this CashflowActivity.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this CashflowActivity.

        Name of the cashflow activity type. It will be either Operating Activities, Investing Activities or Financing Activities  # noqa: E501

        :param name: The name of this CashflowActivity.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def total(self):
        """Gets the total of this CashflowActivity.  # noqa: E501

        Total value of the activity type  # noqa: E501

        :return: The total of this CashflowActivity.  # noqa: E501
        :rtype: float
        """
        return self._total

    @total.setter
    def total(self, total):
        """Sets the total of this CashflowActivity.

        Total value of the activity type  # noqa: E501

        :param total: The total of this CashflowActivity.  # noqa: E501
        :type: float
        """

        self._total = total

    @property
    def cashflow_types(self):
        """Gets the cashflow_types of this CashflowActivity.  # noqa: E501


        :return: The cashflow_types of this CashflowActivity.  # noqa: E501
        :rtype: list[CashflowType]
        """
        return self._cashflow_types

    @cashflow_types.setter
    def cashflow_types(self, cashflow_types):
        """Sets the cashflow_types of this CashflowActivity.


        :param cashflow_types: The cashflow_types of this CashflowActivity.  # noqa: E501
        :type: list[CashflowType]
        """

        self._cashflow_types = cashflow_types
