######################################################################################
# Copyright (c) 2023 Orange - All Rights Reserved                             #
# * This software is the confidential and proprietary information of Orange.         #
# * You shall not disclose such Restricted Information and shall use it only in      #
#   accordance with the terms of the license agreement you entered into with Orange  #
#   named the "kuplift - Python Library Evaluation License".                          #
# * Unauthorized copying of this file, via any medium is strictly prohibited.        #
# * See the "LICENSE.md" file for more details.                                      #
######################################################################################
import pandas as pd
from sklearn.model_selection import train_test_split
from kuplift.UnivariateEncoding import UnivariateEncoding


def test_fit_transform_a(test_dataframe):
    ue = UnivariateEncoding()
    encoded_data = ue.fit_transform(test_dataframe, "segment", "visit")
    list_encoded_data = encoded_data.values.tolist()
    assert list_encoded_data == [
        [0, 1, 3, 1, 2, 0, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 2, 3, 0, 1, 1, 0, 0, 0, 3, 0, 0],
        [1, 1, 3, 3, 1, 1, 2, 0, 0, 0, 2, 0, 0],
        [1, 1, 1, 2, 0, 0, 1, 0, 0, 1, 2, 1, 0],
        [0, 1, 2, 3, 3, 1, 1, 0, 1, 1, 1, 1, 0],
        [1, 1, 2, 3, 0, 1, 1, 0, 0, 0, 0, 0, 0],
        [0, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 1, 0],
        [0, 1, 1, 3, 1, 1, 1, 0, 0, 1, 0, 1, 1],
        [1, 1, 3, 2, 3, 1, 1, 0, 0, 1, 0, 1, 1],
        [1, 1, 2, 4, 3, 0, 1, 0, 1, 1, 0, 1, 1],
        [1, 1, 2, 4, 2, 1, 1, 0, 0, 1, 1, 0, 1],
        [1, 1, 2, 4, 3, 1, 0, 0, 0, 0, 0, 1, 1],
        [0, 1, 0, 2, 2, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 2, 3, 1, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 0, 1, 4, 1, 1, 1, 0, 0, 1, 2, 0, 1],
        [0, 1, 0, 4, 0, 1, 1, 0, 1, 1, 1, 0, 0],
        [0, 1, 0, 2, 1, 0, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 0, 4, 1, 1, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 2, 4, 1, 1, 1, 0, 1, 0, 1, 0, 0],
        [0, 2, 2, 3, 1, 1, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 0, 1, 1, 0, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 3, 4, 3, 1, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 2, 4, 0, 0, 1, 0, 1, 1, 2, 1, 1],
        [0, 1, 2, 3, 1, 0, 1, 0, 0, 1, 2, 1, 0],
        [1, 0, 1, 0, 3, 0, 1, 0, 0, 1, 2, 1, 0],
        [0, 1, 1, 3, 1, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 2, 3, 0, 1, 1, 0, 0, 0, 3, 0, 1],
        [0, 1, 0, 0, 2, 1, 0, 0, 0, 0, 1, 1, 1],
        [1, 1, 2, 4, 3, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 2, 3, 1, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 0, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 0, 4, 1, 1, 1, 0, 1, 0, 1, 1, 1],
        [0, 1, 2, 0, 1, 1, 1, 1, 0, 0, 1, 0, 0],
        [1, 1, 3, 4, 1, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 0, 3, 1, 1, 1, 0, 0, 1, 2, 0, 0],
        [0, 1, 1, 1, 0, 0, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 2, 4, 1, 1, 1, 0, 1, 0, 1, 0, 1],
        [1, 1, 2, 1, 1, 1, 1, 0, 0, 0, 3, 0, 1],
        [1, 1, 2, 1, 2, 1, 1, 0, 1, 1, 1, 1, 1],
        [1, 1, 2, 3, 0, 0, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 2, 4, 0, 1, 1, 0, 0, 0, 1, 1, 1],
        [0, 0, 1, 2, 2, 0, 1, 0, 0, 1, 1, 1, 1],
        [0, 1, 2, 3, 1, 1, 1, 0, 1, 1, 1, 0, 0],
        [1, 1, 0, 1, 1, 0, 1, 0, 1, 0, 1, 1, 0],
        [1, 1, 3, 4, 2, 1, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 1, 5, 0, 1, 1, 0, 0, 1, 1, 0, 1],
        [0, 1, 0, 3, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 2, 4, 1, 0, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 2, 1, 0, 1, 1, 0, 1, 1, 1, 0, 0],
        [0, 1, 0, 3, 3, 1, 1, 1, 1, 0, 0, 1, 0],
        [1, 1, 1, 4, 1, 0, 1, 0, 0, 1, 0, 1, 1],
        [1, 1, 2, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0],
        [0, 1, 1, 4, 2, 0, 2, 0, 1, 1, 1, 0, 0],
        [1, 1, 2, 1, 1, 0, 1, 0, 1, 1, 0, 0, 0],
        [1, 1, 2, 3, 2, 0, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 3, 3, 3, 0, 2, 0, 0, 1, 0, 1, 0],
        [1, 1, 1, 5, 0, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 3, 0, 1, 1, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 0, 0],
        [1, 1, 1, 4, 2, 1, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 1, 3, 0, 0, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 1, 3, 1, 0, 1, 0, 0, 1, 0, 1, 0],
        [0, 1, 0, 3, 3, 1, 1, 0, 0, 1, 3, 1, 0],
        [0, 1, 3, 2, 1, 0, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 3, 3, 3, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 2, 5, 0, 1, 1, 0, 0, 1, 2, 0, 1],
        [1, 1, 1, 1, 0, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 2, 3, 1, 0, 1, 0, 0, 0, 2, 0, 0],
        [1, 1, 0, 4, 1, 0, 1, 0, 1, 1, 1, 0, 0],
        [0, 0, 2, 0, 3, 1, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 1, 1, 1, 0, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 3, 5, 3, 1, 1, 1, 1, 1, 3, 1, 0],
        [0, 1, 2, 4, 2, 0, 1, 1, 1, 0, 3, 1, 1],
        [0, 0, 1, 3, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 1, 1, 2, 1, 1, 0, 0, 0, 0, 1, 1],
        [1, 1, 1, 1, 1, 0, 1, 0, 0, 0, 2, 0, 0],
        [1, 1, 0, 3, 2, 1, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 0, 1, 1, 1, 2, 0, 0, 1, 1, 0, 0],
        [0, 1, 0, 2, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 0, 3, 2, 0, 1, 0, 0, 0, 0, 0, 0],
        [1, 2, 2, 4, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 3, 3, 1, 1, 2, 0, 0, 1, 0, 0, 0],
        [1, 1, 0, 3, 1, 0, 1, 0, 0, 1, 0, 1, 0],
        [1, 2, 3, 1, 3, 0, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 3, 3, 1, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 0, 4, 0, 1, 1, 0, 0, 1, 0, 1, 1],
        [1, 1, 0, 3, 1, 1, 1, 0, 1, 0, 3, 1, 1],
        [1, 1, 2, 4, 1, 0, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 3, 4, 2, 0, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 2, 4, 1, 0, 1, 0, 0, 0, 2, 0, 1],
        [0, 1, 3, 3, 2, 1, 1, 0, 0, 0, 1, 0, 1],
        [0, 2, 0, 1, 2, 1, 1, 0, 1, 1, 0, 1, 1],
        [1, 1, 3, 3, 1, 0, 1, 1, 1, 0, 0, 0, 0],
        [1, 1, 0, 0, 1, 1, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 3, 3, 2, 0, 1, 0, 0, 0, 2, 0, 0],
        [0, 1, 0, 3, 1, 0, 1, 0, 1, 0, 1, 0, 1],
        [1, 1, 2, 1, 2, 0, 1, 1, 1, 1, 2, 1, 1],
        [1, 1, 3, 3, 1, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 0, 3, 3, 1, 1, 0, 1, 0, 0, 0, 0],
        [1, 1, 0, 4, 1, 1, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 0, 4, 3, 1, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 1, 0, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 3, 4, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 2, 4, 1, 0, 1, 1, 0, 1, 2, 0, 0],
        [1, 1, 2, 4, 1, 0, 1, 0, 1, 0, 1, 1, 1],
        [1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 1, 1],
        [0, 1, 1, 4, 2, 0, 1, 0, 1, 1, 1, 1, 1],
        [1, 1, 1, 4, 1, 0, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 2, 3, 3, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 0, 4, 1, 0, 1, 0, 0, 0, 0, 0, 1],
        [0, 1, 3, 3, 3, 1, 1, 0, 0, 0, 3, 1, 0],
        [0, 2, 3, 4, 2, 1, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 1, 4, 2, 1, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 2, 3, 3, 1, 1, 0, 1, 1, 1, 0, 0],
        [1, 1, 1, 4, 3, 1, 1, 1, 1, 0, 1, 1, 1],
        [1, 1, 2, 4, 1, 1, 1, 0, 0, 1, 1, 1, 1],
        [0, 1, 1, 2, 2, 1, 1, 0, 0, 1, 2, 1, 0],
        [1, 1, 1, 3, 2, 0, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 2, 3, 3, 0, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 0, 4, 1, 0, 1, 0, 1, 0, 1, 1, 1],
        [0, 1, 3, 4, 3, 1, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 2, 3, 2, 0, 1, 0, 0, 1, 0, 1, 0],
        [0, 1, 1, 5, 2, 0, 1, 0, 0, 1, 1, 1, 0],
        [0, 0, 2, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 0, 3, 1, 0, 2, 1, 0, 0, 0, 0, 0],
        [0, 1, 0, 4, 1, 0, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 1, 2, 0, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 1, 2, 2, 1, 1, 0, 0, 0, 0, 1, 1],
        [1, 1, 1, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 1, 1, 3, 1, 1, 0, 1, 0, 0, 1, 1],
        [1, 1, 2, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0],
        [0, 1, 1, 4, 1, 0, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 1, 1, 2, 1, 1, 0, 0, 0, 2, 0, 0],
        [0, 1, 3, 1, 3, 1, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 2, 5, 3, 1, 1, 0, 1, 0, 3, 1, 0],
        [1, 1, 3, 3, 3, 1, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 0, 3, 1, 1, 1, 0, 1, 0, 2, 0, 0],
        [0, 1, 2, 3, 0, 1, 1, 1, 1, 0, 3, 0, 0],
        [0, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 1],
        [0, 1, 0, 3, 3, 0, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 3, 4, 2, 1, 1, 0, 0, 0, 3, 1, 1],
        [0, 1, 3, 3, 1, 1, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 2, 4, 1, 0, 1, 0, 0, 0, 0, 0, 1],
        [0, 1, 3, 3, 3, 1, 1, 0, 1, 0, 1, 1, 0],
        [1, 1, 2, 2, 0, 0, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 0, 3, 1, 0, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 3, 4, 2, 0, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 1, 1, 2, 1, 1, 0, 0, 1, 0, 1, 1],
        [0, 1, 2, 2, 1, 0, 1, 0, 0, 0, 0, 1, 0],
        [1, 0, 2, 3, 1, 1, 1, 0, 0, 0, 0, 1, 1],
        [0, 1, 0, 2, 0, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 2, 3, 3, 0, 1, 0, 1, 1, 3, 1, 0],
        [0, 1, 1, 3, 1, 1, 1, 0, 0, 1, 1, 1, 1],
        [0, 2, 3, 3, 0, 1, 1, 0, 1, 0, 1, 0, 0],
        [1, 1, 2, 0, 1, 1, 1, 0, 1, 1, 0, 0, 0],
        [1, 1, 0, 4, 1, 0, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 1, 4, 2, 1, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 1, 3, 1, 0, 1, 0, 0, 0, 0, 1, 0],
        [1, 2, 2, 4, 1, 1, 1, 1, 1, 0, 1, 1, 1],
        [0, 1, 2, 2, 0, 1, 1, 0, 0, 1, 3, 0, 0],
        [0, 1, 0, 0, 0, 1, 1, 0, 1, 1, 1, 0, 0],
        [1, 1, 2, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1],
        [0, 1, 1, 4, 1, 0, 1, 0, 1, 1, 2, 0, 0],
        [1, 1, 2, 4, 1, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 2, 3, 3, 0, 1, 0, 0, 0, 1, 0, 1],
        [1, 2, 1, 3, 3, 1, 1, 0, 1, 1, 1, 1, 0],
        [1, 1, 2, 1, 0, 1, 1, 0, 0, 1, 2, 0, 1],
        [0, 1, 0, 5, 2, 1, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 2, 3, 3, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 2, 1, 2, 0, 1, 0, 0, 1, 2, 1, 1],
        [1, 1, 3, 3, 1, 1, 1, 0, 1, 0, 0, 1, 0],
        [1, 1, 0, 5, 3, 1, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 2, 4, 2, 1, 1, 0, 1, 0, 1, 1, 1],
        [0, 1, 0, 4, 3, 0, 1, 0, 1, 1, 0, 1, 1],
        [1, 0, 3, 3, 0, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 2, 3, 1, 0, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 1, 5, 2, 0, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 0, 4, 0, 0, 1, 0, 1, 0, 3, 1, 0],
        [1, 1, 2, 3, 3, 1, 1, 0, 1, 0, 2, 0, 0],
        [0, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1],
        [0, 1, 1, 5, 3, 0, 1, 0, 0, 0, 0, 0, 0],
        [0, 1, 1, 4, 1, 1, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 1, 4, 3, 1, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 3, 4, 3, 1, 1, 0, 1, 1, 3, 0, 1],
        [1, 1, 2, 4, 0, 1, 1, 0, 0, 0, 0, 1, 1],
        [0, 1, 2, 1, 1, 1, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 0, 1, 3, 0, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 2, 5, 3, 0, 1, 0, 0, 1, 2, 0, 1],
        [0, 1, 0, 4, 1, 1, 1, 0, 0, 1, 0, 1, 0],
        [0, 1, 3, 3, 3, 0, 1, 0, 1, 1, 0, 0, 0],
        [1, 1, 2, 4, 0, 1, 1, 0, 1, 1, 3, 0, 0],
        [0, 1, 3, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 3, 1, 3, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 2, 3, 2, 1, 1, 0, 0, 0, 2, 0, 0],
        [0, 1, 0, 2, 1, 1, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 2, 3, 2, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 1, 5, 3, 0, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 2, 4, 2, 1, 1, -1, 0, 1, 2, 0, 1],
        [0, 1, 2, 1, 0, 0, 1, 0, 0, 1, 3, 1, 1],
        [1, 1, 3, 2, 2, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 0, 2, 0, 1, 1, 0, 0, 1, 1, 1, 1],
        [0, 1, 0, 1, 0, 0, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 2, 4, 2, 0, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 2, 4, 2, 1, 1, 0, 0, 1, 0, 1, 0],
        [0, 1, 1, 3, 3, 0, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 2, 1, 2, 0, 1, 0, 1, 0, 0, 0, 1],
        [1, 1, 3, 3, 3, 1, 1, 0, 0, 0, 2, 0, 0],
        [1, 2, 3, 3, 1, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 1, 3, 1, 0, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 3, 1, 3, 0, 1, 0, 1, 1, 2, 1, 1],
        [0, 1, 1, 4, 1, 0, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 2, 4, 1, 0, 1, 0, 0, 0, 1, 1, 1],
        [0, 1, 0, 4, 1, 1, 1, 0, 1, 0, 1, 0, 0],
        [1, 1, 3, 1, 2, 0, 1, 0, 0, 0, 2, 0, 1],
        [1, 1, 1, 1, 2, 1, 1, 0, 1, 0, 0, 1, 0],
        [0, 1, 2, 3, 1, 0, 1, 0, 0, 1, 3, 1, 0],
        [0, 1, 2, 3, 0, 1, 1, 0, 0, 1, 0, 1, 1],
        [0, 1, 2, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1],
        [0, 1, 0, 1, 3, 1, 1, 0, 1, 0, 0, 0, 1],
        [1, 1, 0, 4, 1, 1, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 2, 4, 2, 1, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 1, 1, 3, 1, 1, 0, 1, 1, 2, 1, 1],
        [0, 1, 2, 4, 0, 0, 1, 0, 1, 0, 0, 0, 0],
        [0, 1, 1, 3, 0, 1, 1, 0, 1, 0, 1, 1, 0],
        [1, 1, 3, 1, 2, 1, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 1, 3, 2, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 2, 1, 4, 3, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 2, 3, 2, 1, 1, 0, 0, 0, 0, 0, 0],
        [0, 1, 1, 3, 1, 1, 1, 0, 0, 0, 0, 0, 0],
        [0, 0, 1, 1, 3, 0, 1, 1, 1, 1, 1, 1, 1],
        [0, 1, 1, 4, 3, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 2, 1, 5, 1, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 0, 0, 2, 3, 1, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 1, 4, 1, 1, 1, 0, 1, 0, 1, 0, 0],
        [0, 1, 2, 1, 2, 1, 1, 1, 0, 0, 0, 1, 1],
        [0, 1, 1, 4, 0, 0, 2, 0, 0, 0, 2, 0, 1],
        [0, 1, 1, 1, 0, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 2, 3, 2, 1, 1, 0, 0, 1, 0, 1, 0],
        [0, 1, 0, 3, 1, 0, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 2, 3, 1, 1, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 0, 3, 2, 0, 1, 0, 1, 1, 0, 1, 0],
        [1, 1, 1, 2, 1, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 3, 2, 1, 0, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 1, 3, 1, 0, 1, 0, 1, 0, 1, 0, 0],
        [0, 1, 2, 3, 3, 1, 1, 0, 0, 1, 3, 1, 1],
        [1, 2, 2, 3, 2, 0, 1, 0, 1, 1, 2, 0, 0],
        [1, 1, 2, 5, 0, 1, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 2, 1, 0, 1, 1, 0, 0, 0, 0, 0, 1],
        [1, 1, 3, 1, 0, 0, 1, 0, 0, 0, 0, 0, 1],
        [0, 1, 2, 1, 0, 1, 1, 0, 1, 1, 1, 0, 1],
        [1, 2, 1, 4, 2, 0, 1, 0, 1, 1, 0, 0, 0],
        [0, 1, 3, 5, 1, 0, 1, 0, 1, 1, 1, 0, 1],
        [1, 1, 2, 4, 2, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 3, 2, 3, 1, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 0, 1, 1, 0, 1, 0, 0, 0, 0, 0, 1],
        [0, 1, 0, 4, 2, 1, 1, 0, 1, 1, 1, 0, 0],
        [1, 1, 2, 4, 2, 1, 1, 1, 0, 1, 0, 0, 1],
        [0, 1, 0, 3, 2, 1, 1, 0, 1, 1, 0, 0, 0],
        [0, 1, 2, 1, 3, 1, 1, 0, 0, 0, 1, 0, 1],
        [1, 2, 1, 5, 2, 0, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 1, 3, 1, 0, 1, 0, 1, 0, 2, 1, 0],
        [1, 1, 0, 3, 3, 1, 1, 0, 0, 1, 2, 0, 0],
        [0, 1, 0, 1, 1, 0, 1, 0, 1, 0, 1, 1, 1],
        [1, 1, 0, 5, 3, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 0, 2, 1, 1, 1, 0, 1, 1, 1, 1, 0],
        [0, 1, 0, 4, 3, 1, 1, 0, 1, 0, 1, 1, 0],
        [0, 1, 2, 1, 2, 0, 1, 0, 0, 0, 0, 0, 1],
        [1, 1, 0, 1, 2, 1, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 3, 1, 1, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 2, 1, 4, 2, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 2, 4, 2, 1, 1, 0, 0, 0, 0, 0, 1],
        [0, 1, 1, 0, 2, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 3, 5, 1, 1, 1, 0, 0, 1, 0, 1, 0],
        [1, 2, 0, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 1, 5, 1, 1, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 0, 3, 1, 1, 1, 1, 0, 0, 2, 0, 0],
        [1, 1, 2, 4, 0, 1, 1, 1, 0, 1, 1, 1, 1],
        [0, 1, 2, 4, 3, 0, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 3, 3, 3, 0, 1, 0, 0, 0, 3, 1, 0],
        [1, 2, 2, 3, 0, 1, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 0, 2, 3, 1, 1, 0, 0, 1, 1, 1, 1],
        [0, 1, 2, 3, 0, 1, 1, 0, 0, 0, 0, 1, 1],
        [1, 1, 0, 2, 1, 1, 1, 0, 0, 1, 3, 1, 0],
        [1, 1, 1, 3, 1, 0, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 2, 3, 1, 1, 1, 0, 1, 1, 1, 1, 0],
        [0, 1, 0, 3, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 2, 3, 1, 2, 0, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 2, 5, 2, 1, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 2, 4, 1, 0, 1, 0, 0, 0, 3, 0, 0],
        [1, 1, 0, 1, 2, 1, 1, 0, 0, 1, 0, 0, 1],
        [1, 1, 1, 2, 1, 0, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 2, 3, 1, 1, 1, 0, 1, 0, 1, 1, 0],
        [1, 0, 0, 1, 0, 1, 1, 0, 0, 1, 1, 0, 1],
        [0, 1, 1, 4, 2, 1, 1, 0, 0, 1, 3, 0, 0],
        [1, 1, 0, 5, 1, 1, 1, 0, 0, 0, 1, 1, 1],
        [0, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 0],
        [1, 1, 0, 3, 1, 0, 1, 0, 0, 0, 2, 0, 0],
        [0, 2, 1, 0, 1, 1, 1, 0, 1, 0, 0, 1, 0],
        [1, 1, 2, 1, 3, 1, 1, 0, 1, 0, 0, 0, 0],
        [1, 1, 0, 3, 0, 1, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 3, 5, 2, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 0, 4, 3, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 3, 1, 3, 1, 1, 0, 1, 1, 2, 1, 1],
        [1, 1, 1, 3, 3, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 2, 4, 3, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 2, 4, 0, 1, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 2, 3, 2, 1, 1, 0, 1, 0, 0, 0, 0],
        [0, 2, 1, 4, 3, 0, 2, 0, 0, 0, 3, 0, 0],
        [1, 1, 0, 3, 0, 1, 2, 0, 0, 0, 0, 0, 1],
        [1, 1, 2, 4, 1, 0, 1, 0, 1, 0, 1, 0, 1],
        [1, 1, 3, 0, 3, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 0, 3, 1, 1, 1, 0, 0, 1, 2, 0, 0],
        [0, 1, 3, 1, 3, 0, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 2, 4, 3, 1, 1, 0, 0, 0, 1, 1, 1],
        [1, 1, 2, 3, 2, 0, 1, 0, 0, 0, 3, 1, 1],
        [1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 0, 3, 0, 1, 1, 0, 1, 0, 2, 0, 1],
        [0, 1, 2, 1, 3, 0, 1, 0, 1, 0, 3, 0, 1],
        [1, 1, 1, 1, 0, 1, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 3, 5, 2, 1, 1, 0, 1, 0, 1, 1, 0],
        [1, 1, 2, 3, 1, 1, 2, 0, 0, 0, 2, 1, 1],
        [1, 1, 3, 1, 1, 1, 2, 0, 0, 0, 3, 0, 1],
        [1, 1, 1, 4, 0, 0, 1, 0, 0, 0, 0, 0, 1],
        [1, 1, 0, 2, 0, 1, 1, 0, 1, 0, 2, 0, 1],
        [0, 1, 2, 4, 2, 0, 1, 1, 0, 0, 1, 1, 1],
        [0, 1, 1, 3, 3, 1, 1, 0, 1, 0, 1, 0, 0],
        [0, 1, 2, 4, 1, 1, 2, 0, 0, 1, 1, 1, 1],
        [0, 1, 0, 1, 1, 0, 1, 0, 0, 0, 1, 1, 1],
        [0, 1, 3, 4, 1, 1, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 3, 2, 3, 1, 1, 0, 0, 1, 2, 1, 0],
        [1, 1, 3, 1, 3, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 0, 4, 0, 1, 1, 0, 1, 1, 1, 0, 0],
        [1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 0],
        [1, 1, 0, 4, 3, 0, 1, 0, 0, 1, 3, 1, 0],
        [1, 1, 1, 0, 1, 1, 1, 0, 0, 1, 3, 1, 0],
        [1, 1, 1, 4, 2, 1, 1, 0, 1, 1, 1, 1, 1],
        [1, 1, 0, 5, 3, 1, 0, 0, 1, 0, 2, 1, 0],
        [0, 1, 3, 5, 1, 1, 1, 0, 0, 0, 2, 1, 0],
        [0, 0, 1, 4, 3, 1, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 1, 4, 3, 0, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 3, 4, 3, 1, 1, 0, 1, 0, 2, 1, 0],
        [1, 1, 1, 1, 0, 0, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 0, 2, 3, 0, 1, 0, 0, 0, 1, 1, 1],
        [1, 1, 2, 3, 3, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 3, 1, 2, 1, 2, 0, 0, 0, 1, 0, 0],
        [1, 1, 3, 3, 2, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 2, 1, 3, 1, 1, 0, 0, 1, 0, 1, 1],
        [0, 1, 0, 3, 1, 1, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 0, 1, 3, 1, 1, 0, 0, 0, 2, 0, 1],
        [0, 1, 3, 3, 2, 1, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 1, 0, 1, 0, 1, 0, 1, 0, 3, 1, 0],
        [0, 1, 2, 1, 0, 0, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 2, 3, 1, 0, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 2, 4, 1, 0, 1, 0, 1, 0, 1, 1, 0],
        [0, 1, 1, 3, 0, 0, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 0, 3, 1, 0, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 0, 0, 3, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 3, 3, 1, 1, 1, 0, 0, 1, 2, 1, 1],
        [0, 1, 3, 3, 1, 1, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 0, 0, 1, 0, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 2, 3, 1, 0, 1, 0, 1, 1, 1, 0, 0],
        [1, 1, 2, 2, 2, 1, 1, 0, 1, 0, 1, 1, 1],
        [1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0],
        [1, 0, 2, 4, 3, 1, 1, 0, 1, 1, 3, 0, 1],
        [1, 1, 1, 3, 0, 0, 1, 0, 1, 1, 2, 1, 0],
        [1, 1, 1, 3, 3, 0, 1, 0, 0, 0, 2, 1, 0],
        [1, 2, 1, 3, 1, 1, 1, 0, 0, 0, 3, 1, 0],
        [1, 1, 1, 1, 2, 1, 1, 0, 1, 1, 2, 1, 1],
        [0, 1, 2, 2, 2, 0, 1, 0, 0, 1, 0, 1, 0],
        [0, 1, 3, 3, 1, 1, 1, 0, 0, 1, 1, 0, 1],
        [1, 1, 0, 4, 1, 1, 1, 0, 0, 0, 3, 1, 0],
        [1, 1, 2, 3, 1, 0, 1, 0, 1, 0, 0, 0, 0],
        [0, 1, 0, 4, 1, 1, 1, 0, 1, 0, 2, 1, 0],
        [0, 1, 0, 3, 1, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 1, 4, 0, 1, 1, 0, 1, 0, 1, 0, 0],
        [1, 1, 2, 4, 1, 0, 1, 0, 1, 0, 2, 1, 1],
        [1, 1, 2, 1, 1, 0, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 2, 2, 0, 1, 2, 0, 0, 1, 1, 1, 1],
        [1, 1, 1, 2, 1, 1, 2, 0, 0, 1, 1, 1, 1],
        [1, 1, 0, 3, 2, 0, 1, 0, 1, 1, 0, 1, 0],
        [1, 1, 0, 3, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 0, 4, 2, 1, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 3, 3, 1, 0, 1, 0, 1, 0, 1, 1, 0],
        [0, 1, 1, 1, 0, 0, 1, 0, 1, 1, 0, 0, 1],
        [0, 1, 0, 1, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 0, 2, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 2, 3, 0, 1, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 0, 2, 1, 1, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 1, 3, 3, 1, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 1, 3, 1, 1, 1, 0, 1, 1, 1, 0, 0],
        [1, 1, 3, 4, 1, 0, 1, 0, 1, 1, 3, 0, 1],
        [1, 1, 1, 4, 2, 1, 1, 1, 0, 1, 2, 0, 0],
        [1, 0, 0, 3, 1, 1, 1, 0, 0, 0, 0, 0, 0],
        [0, 2, 3, 5, 1, 1, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 0, 4, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 2, 5, 1, 0, 1, 0, 1, 0, 1, 1, 0],
        [0, 1, 2, 4, 1, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 3, 3, 1, 0, 2, 0, 0, 0, 1, 0, 0],
        [0, 1, 0, 3, 1, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 0, 3, 1, 1, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 1, 5, 3, 0, 1, 0, 1, 1, 1, 0, 0],
        [1, 1, 0, 2, 3, 1, 1, 0, 1, 1, 0, 0, 1],
        [0, 0, 0, 3, 3, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 2, 3, 3, 0, 1, 0, 1, 0, 2, 1, 0],
        [1, 1, 2, 4, 1, 0, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 2, 3, 3, 0, 1, 0, 0, 0, 0, 0, 0],
        [0, 1, 3, 3, 3, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 2, 4, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 1, 4, 1, 1, 1, 0, 1, 0, 0, 0, 0],
        [0, 1, 2, 4, 1, 1, 1, 0, 0, 1, 1, 1, 1],
        [0, 1, 1, 3, 1, 0, 1, 0, 0, 0, 2, 0, 0],
        [0, 1, 1, 2, 0, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 2, 3, 2, 0, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 0, 1, 2, 1, 1, 0, 1, 0, 1, 1, 1],
        [0, 1, 0, 2, 3, 0, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 2, 3, 2, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 2, 0, 3, 1, 1, 1, 0, 0, 1, 2, 0, 0],
        [0, 1, 1, 3, 3, 0, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 2, 1, 0, 1, 1, 0, 1, 1, 1, 1, 1],
        [1, 1, 3, 0, 0, 1, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 3, 3, 3, 1, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 0, 3, 3, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 0, 4, 1, 1, 1, 0, 0, 1, 1, 1, 1],
        [0, 1, 0, 3, 3, 0, 1, 0, 1, 0, 1, 0, 0],
        [1, 1, 0, 3, 1, 1, 1, 0, 0, 0, 1, 0, 1],
        [0, 1, 1, 3, 1, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 0, 1, 1, 0, 1, 0, 0, 0, 3, 0, 0],
        [1, 1, 2, 3, 0, 1, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 3, 4, 1, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 1, 4, 1, 0, 1, 0, 1, 1, 2, 0, 0],
        [0, 1, 3, 0, 1, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 3, 2, 1, 1, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 3, 4, 2, 1, 2, 0, 0, 1, 2, 0, 0],
        [0, 1, 1, 5, 3, 0, 1, 0, 0, 1, 0, 1, 0],
        [0, 1, 1, 4, 0, 1, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 3, 0, 2, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 2, 2, 2, 0, 1, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 2, 3, 3, 1, 1, 0, 1, 0, 0, 0, 0],
        [0, 1, 1, 3, 0, 0, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 1, 3, 1, 1, 1, 0, 1, 0, 1, 0, 0],
        [0, 1, 2, 0, 1, 1, 1, 0, 0, 0, 3, 1, 0],
        [1, 1, 2, 0, 1, 0, 1, 1, 0, 1, 1, 0, 1],
        [0, 1, 2, 0, 1, 1, 1, 1, 0, 0, 1, 0, 0],
        [0, 1, 3, 4, 2, 0, 1, 1, 1, 0, 1, 0, 0],
        [1, 0, 1, 2, 1, 1, 2, 0, 0, 0, 0, 0, 0],
        [0, 1, 3, 4, 0, 0, 1, 0, 1, 0, 1, 0, 0],
        [0, 1, 3, 3, 2, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 0, 1, 1, 1, 1, 0, 1, 1, 2, 0, 1],
        [0, 1, 2, 0, 1, 0, 1, 0, 1, 1, 0, 1, 0],
        [1, 1, 1, 4, 0, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 2, 0, 3, 1, 1, 1, 0, 1, 0, 1, 1, 0],
        [0, 1, 2, 3, 1, 1, 1, 0, 0, 1, 1, 0, 1],
        [0, 2, 3, 1, 1, 1, 1, 0, 0, 1, 3, 1, 0],
        [0, 2, 3, 1, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 0, 2, 4, 2, 0, 1, 0, 0, 1, 1, 0, 1],
        [1, 1, 1, 2, 1, 0, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 0, 1, 1, 1, 2, 0, 0, 1, 0, 1, 1],
        [1, 1, 2, 4, 3, 1, 1, 0, 0, 0, 2, 0, 1],
        [1, 1, 2, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 2, 2, 0, 1, 1, 0, 0, 1, 3, 1, 1],
        [0, 1, 2, 4, 1, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 2, 2, 3, 1, 1, 0, 1, 1, 1, 0, 0],
        [0, 1, 0, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1],
        [1, 0, 1, 5, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 2, 4, 3, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 2, 3, 0, 1, 1, 1, 0, 0, 1, 1, 1],
        [1, 1, 2, 0, 1, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 0, 2, 3, 0, 1, 1, 0, 1, 0, 1, 0, 0],
        [1, 1, 1, 3, 0, 0, 1, 0, 1, 0, 1, 1, 0],
        [1, 1, 0, 0, 2, 1, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 2, 3, 3, 1, 1, 0, 1, 0, 1, 0, 0],
        [1, 1, 2, 3, 1, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 2, 0, 1, 0, 1, 0, 1, 0, 1, 1, 0],
        [1, 1, 0, 4, 1, 0, 1, 0, 0, 1, 2, 1, 0],
        [1, 1, 1, 3, 3, 0, 1, 0, 0, 0, 0, 1, 0],
        [1, 0, 1, 4, 1, 0, 1, 0, 0, 0, 3, 1, 1],
        [1, 1, 2, 1, 2, 1, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 0, 4, 2, 1, 1, 0, 1, 0, 1, 1, 0],
        [0, 1, 2, 4, 2, 0, 1, 0, 0, 0, 3, 1, 1],
        [1, 1, 0, 4, 1, 0, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 1, 3, 3, 1, 1, 0, 0, 0, 0, 0, 1],
        [0, 0, 2, 3, 1, 0, 1, 0, 1, 0, 2, 1, 0],
        [0, 1, 2, 3, 0, 1, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 0, 2, 2, 0, 1, 0, 0, 0, 3, 0, 0],
        [1, 1, 0, 3, 0, 0, 1, 0, 0, 0, 1, 1, 1],
        [1, 1, 1, 2, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 0, 3, 0, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 2, 3, 0, 2, 0, 1, 0, 1, 0, 1, 1, 0],
        [1, 1, 1, 3, 1, 1, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 1, 3, 2, 0, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 1, 5, 1, 0, 1, 0, 0, 0, 0, 0, 0],
        [0, 2, 2, 1, 3, 0, 1, 0, 0, 0, 2, 0, 0],
        [1, 1, 2, 1, 2, 1, 1, 0, 0, 0, 1, 1, 1],
        [0, 1, 0, 3, 1, 1, 1, 1, 1, 1, 0, 1, 0],
        [0, 1, 0, 4, 1, 0, 1, 0, 0, 1, 3, 0, 1],
        [1, 1, 0, 0, 1, 0, 1, 0, 0, 0, 3, 1, 0],
        [0, 1, 3, 0, 3, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 2, 2, 1, 2, 0, 1, 0, 0, 0, 2, 0, 0],
        [1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1],
        [1, 1, 2, 4, 2, 1, 2, 0, 0, 0, 2, 0, 1],
        [1, 1, 0, 5, 0, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 0, 2, 4, 3, 1, 1, 0, 0, 0, 3, 1, 1],
        [1, 1, 2, 3, 0, 0, 1, 0, 0, 1, 2, 0, 0],
        [0, 1, 2, 4, 1, 0, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 2, 4, 0, 0, 1, 0, 0, 1, 3, 1, 1],
        [0, 1, 3, 4, 3, 0, 1, 0, 0, 0, 2, 1, 1],
        [0, 2, 1, 4, 0, 1, 1, 0, 1, 1, 1, 0, 0],
        [1, 1, 1, 3, 2, 1, 1, 0, 1, 0, 1, 1, 1],
        [0, 1, 2, 1, 2, 1, 1, 0, 0, 1, 1, 0, 1],
        [1, 1, 2, 4, 2, 1, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 2, 3, 0, 1, 1, 0, 0, 1, 2, 1, 0],
        [0, 2, 3, 0, 1, 1, 1, 0, 0, 0, 2, 0, 0],
        [0, 1, 2, 5, 3, 1, 1, 0, 0, 1, 1, 1, 1],
        [0, 2, 2, 0, 1, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 2, 3, 4, 0, 0, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 1, 3, 2, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 0, 4, 2, 0, 1, 0, 1, 1, 1, 1, 1],
        [0, 1, 0, 3, 0, 1, 1, 0, 1, 1, 0, 1, 0],
        [0, 1, 0, 4, 1, 1, 1, 0, 0, 1, 1, 1, 1],
        [0, 1, 1, 4, 0, 0, 1, 0, 0, 1, 2, 1, 0],
        [0, 1, 1, 3, 0, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 2, 3, 2, 0, 1, 0, 0, 1, 1, 0, 0],
        [1, 0, 1, 4, 0, 1, 2, 0, 1, 1, 1, 0, 1],
        [0, 1, 2, 3, 3, 0, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 2, 3, 2, 1, 1, 1, 0, 0, 0, 1, 1],
        [0, 1, 2, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1],
        [1, 1, 0, 4, 1, 1, 1, 0, 1, 1, 1, 1, 1],
        [1, 1, 3, 5, 2, 1, 1, 1, 0, 0, 0, 1, 0],
        [1, 1, 2, 4, 3, 1, 1, 0, 1, 0, 3, 1, 1],
        [1, 1, 2, 1, 0, 0, 1, 0, 0, 1, 1, 0, 1],
        [1, 2, 0, 0, 2, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 2, 3, 1, 1, 1, 0, 1, 0, 3, 0, 0],
        [1, 2, 1, 1, 0, 0, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 0, 3, 1, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 2, 0, 1, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 0, 4, 3, 1, 1, 0, 0, 1, 2, 0, 1],
        [1, 1, 2, 2, 1, 1, 1, 0, 1, 1, 1, 1, 1],
        [0, 1, 1, 1, 3, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 2, 2, 3, 3, 0, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 0, 3, 3, 1, 1, 0, 1, 0, 1, 0, 0],
        [1, 1, 2, 0, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 0, 2, 5, 1, 1, 1, 0, 1, 1, 2, 0, 0],
        [1, 1, 2, 0, 2, 1, 1, 0, 1, 1, 1, 1, 1],
        [0, 1, 2, 1, 1, 0, 1, 0, 1, 0, 0, 0, 0],
        [0, 1, 0, 4, 3, 0, 1, 0, 0, 1, 2, 1, 0],
        [0, 1, 2, 1, 0, 1, 1, 0, 1, 1, 0, 0, 1],
        [0, 1, 2, 1, 1, 1, 1, 0, 0, 1, 1, 0, 1],
        [1, 1, 3, 3, 0, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 2, 4, 0, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 0, 3, 3, 1, 1, 0, 0, 0, 0, 0, 0],
        [0, 1, 2, 5, 1, 1, 1, 0, 0, 0, 1, 1, 1],
        [1, 1, 2, 1, 0, 1, 1, 0, 1, 0, 1, 1, 1],
        [1, 1, 0, 1, 2, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 2, 3, 1, 1, 1, 0, 0, 0, 1, 0, 1],
        [0, 1, 3, 3, 1, 0, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 2, 4, 1, 0, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 0, 2, 1, 0, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 0, 3, 1, 0, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 2, 3, 1, 0, 1, 0, 1, 0, 1, 0, 0],
        [0, 1, 0, 4, 0, 0, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 0, 1, 0, 1, 1, 0, 0, 1, 3, 1, 0],
        [1, 1, 0, 3, 1, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 0, 4, 1, 1, 1, 0, 0, 1, 2, 1, 0],
        [0, 1, 1, 1, 3, 1, 1, 1, 0, 0, 0, 0, 0],
        [0, 1, 1, 4, 3, 1, 1, 0, 0, 0, 0, 1, 1],
        [1, 1, 1, 2, 1, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 2, 5, 1, 0, 1, 0, 1, 1, 0, 1, 0],
        [0, 1, 0, 3, 1, 1, 1, 0, 1, 1, 1, 1, 1],
        [0, 1, 3, 4, 1, 1, 1, 0, 0, 1, 2, 1, 0],
        [1, 1, 2, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 1, 5, 1, 1, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 3, 3, 1, 0, 1, 0, 0, 1, 1, 1, 1],
        [0, 1, 2, 3, 1, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 0, 4, 0, 1, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 2, 5, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 3, 4, 2, 0, 1, 1, 1, 1, 2, 1, 1],
        [0, 1, 1, 3, 0, 0, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 2, 1, 0, 1, 1, 0, 1, 0, 1, 1, 1],
        [0, 1, 2, 2, 2, 1, 1, 0, 1, 1, 3, 1, 1],
        [0, 1, 1, 3, 2, 1, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 3, 4, 2, 0, 1, 0, 1, 0, 3, 0, 0],
        [0, 1, 0, 0, 1, 0, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 2, 3, 0, 1, 1, 0, 0, 0, 0, 1, 1],
        [0, 1, 2, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 2, 3, 0, 0, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0],
        [0, 2, 0, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1],
        [0, 1, 1, 3, 0, 0, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 2, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 1, 4, 2, 1, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 2, 1, 1, 0, 1, 0, 0, 0, 1, 0, 0],
        [1, 0, 0, 1, 3, 1, 1, 0, 0, 1, 0, 0, 1],
        [0, 1, 2, 1, 2, 0, 1, 0, 1, 1, 1, 0, 1],
        [0, 1, 0, 4, 1, 1, 1, 0, 1, 1, 1, 0, 0],
        [1, 1, 0, 3, 1, 1, 1, 0, 0, 0, 0, 0, 0],
        [0, 1, 1, 1, 2, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 2, 1, 0, 1, 1, 0, 0, 1, 3, 0, 1],
        [1, 1, 0, 1, 1, 0, 1, 0, 0, 0, 0, 0, 1],
        [0, 1, 1, 2, 3, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 2, 2, 1, 1, 1, 0, 1, 0, 1, 1, 1],
        [0, 1, 3, 3, 1, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 1, 2, 1, 0, 1, 0, 1, 1, 1, 1, 0],
        [1, 1, 2, 3, 1, 0, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 1, 4, 3, 0, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 0, 3, 1, 0, 1, 0, 0, 1, 1, 0, 1],
        [1, 1, 2, 3, 1, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 2, 1, 2, 1, 1, 0, 0, 1, 1, 0, 1],
        [0, 1, 0, 4, 3, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 2, 1, 1, 0, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 2, 5, 3, 1, 1, 0, 1, 0, 1, 0, 0],
        [0, 1, 0, 3, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 1, 3, 1, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 3, 1, 1, 0, 1, 0, 0, 0, 1, 1, 1],
        [1, 1, 0, 4, 0, 1, 1, 0, 0, 1, 0, 0, 1],
        [0, 1, 1, 0, 2, 1, 1, 0, 0, 1, 2, 1, 1],
        [1, 1, 3, 3, 0, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 2, 3, 1, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 2, 5, 1, 1, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 2, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 1, 1, 2, 1, 2, 0, 0, 0, 1, 0, 0],
        [1, 1, 1, 3, 0, 0, 1, 0, 0, 1, 2, 0, 0],
        [0, 1, 2, 5, 3, 0, 1, 0, 0, 0, 1, 1, 1],
        [0, 1, 2, 4, 3, 1, 1, 0, 0, 1, 0, 1, 0],
        [0, 1, 1, 4, 2, 1, 1, 0, 1, 1, 3, 1, 1],
        [1, 1, 0, 1, 3, 1, 2, 0, 0, 0, 1, 1, 1],
        [1, 1, 1, 5, 1, 0, 1, 0, 1, 0, 1, 0, 0],
        [0, 1, 2, 5, 3, 0, 1, 0, 0, 1, 1, 1, 1],
        [0, 1, 2, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1],
        [0, 1, 3, 0, 2, 1, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 2, 4, 1, 1, 1, 0, 1, 1, 1, 1, 1],
        [0, 1, 3, 3, 1, 1, 0, 0, 0, 1, 1, 1, 0],
        [0, 1, 0, 3, 0, 0, 2, 0, 1, 1, 0, 0, 1],
        [1, 1, 1, 0, 1, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 0, 3, 2, 1, 1, 1, 0, 0, 0, 1, 1],
        [1, 0, 0, 4, 0, 1, 1, 0, 0, 0, 3, 1, 1],
        [1, 1, 2, 4, 2, 1, 1, 0, 0, 1, 2, 0, 0],
        [0, 1, 3, 4, 2, 0, 1, 0, 0, 0, 1, 1, 1],
        [1, 1, 3, 3, 0, 1, 1, 0, 1, 0, 0, 1, 0],
        [0, 1, 1, 3, 1, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 1, 3, 2, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 3, 1, 3, 1, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 1, 1, 3, 0, 1, 0, 1, 1, 0, 1, 1],
        [0, 1, 0, 4, 1, 1, 1, 0, 0, 0, 1, 1, 1],
        [1, 2, 0, 4, 3, 1, 2, 0, 0, 1, 0, 1, 1],
        [1, 1, 2, 3, 1, 0, 1, 0, 0, 0, 1, 0, 0],
        [1, 2, 0, 2, 1, 0, 2, 0, 1, 0, 0, 1, 0],
        [0, 1, 0, 5, 0, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 2, 3, 2, 1, 1, 0, 0, 0, 3, 1, 0],
        [1, 1, 1, 3, 3, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 1, 3, 1, 1, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 0, 1, 1, 1, 1, 0, 0, 0, 2, 0, 0],
        [1, 1, 0, 4, 1, 1, 1, 0, 1, 1, 1, 1, 1],
        [1, 1, 0, 3, 0, 1, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 2, 1, 3, 0, 2, 0, 0, 0, 2, 1, 1],
        [0, 1, 3, 3, 0, 1, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 3, 3, 2, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 0, 1, 1, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 2, 1, 1, 1, 1, 0, 0, 1, 0, 0, 1],
        [1, 1, 3, 3, 1, 1, 1, 1, 0, 1, 1, 1, 1],
        [0, 1, 2, 3, 3, 1, 1, 0, 0, 0, 2, 0, 0],
        [1, 1, 0, 2, 3, 0, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 0, 5, 0, 0, 1, 0, 1, 0, 0, 1, 1],
        [1, 1, 2, 2, 0, 1, 1, 0, 0, 1, 2, 1, 1],
        [1, 1, 0, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 2, 5, 2, 1, 1, 0, 1, 0, 2, 0, 1],
        [1, 2, 2, 2, 1, 1, 1, 0, 1, 1, 2, 0, 0],
        [1, 1, 3, 3, 0, 0, 1, 0, 0, 0, 2, 1, 0],
        [1, 2, 2, 2, 1, 1, 1, 0, 0, 0, 2, 0, 0],
        [0, 1, 1, 0, 3, 1, 1, 0, 0, 1, 3, 1, 0],
        [1, 1, 3, 4, 3, 1, 1, 0, 0, 0, 3, 1, 1],
        [0, 1, 1, 1, 1, 0, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 0, 0],
        [1, 1, 2, 4, 0, 1, 1, 1, 1, 1, 2, 0, 0],
        [0, 1, 1, 3, 0, 0, 1, 0, 1, 0, 2, 0, 0],
        [1, 1, 0, 3, 2, 1, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 0, 4, 0, 1, 1, 0, 0, 0, 1, 0, 1],
        [0, 1, 3, 3, 3, 0, 1, 0, 1, 1, 2, 1, 0],
        [1, 1, 2, 1, 2, 1, 1, 0, 0, 1, 1, 0, 1],
        [1, 1, 3, 4, 0, 1, 1, 0, 0, 1, 0, 1, 0],
        [0, 0, 0, 4, 1, 0, 1, 0, 1, 1, 2, 0, 1],
        [1, 1, 0, 4, 3, 0, 1, 0, 0, 1, 0, 1, 0],
        [0, 1, 2, 1, 3, 1, 1, 1, 1, 1, 3, 0, 1],
        [1, 1, 3, 1, 3, 1, 1, 0, 0, 0, 1, 1, 1],
        [0, 1, 2, 3, 0, 0, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 0, 3, 1, 0, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 1, 3, 1, 1, 1, 0, 0, 1, 3, 1, 0],
        [0, 1, 3, 4, 0, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 0, 3, 3, 1, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 0, 0, 3, 1, 1, 0, 0, 1, 2, 0, 0],
        [1, 2, 3, 3, 0, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 2, 2, 2, 1, 1, 0, 1, 1, 0, 0, 0],
        [0, 0, 3, 1, 2, 1, 1, 0, 1, 0, 1, 1, 1],
        [0, 0, 0, 0, 1, 0, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 2, 5, 1, 0, 1, 0, 1, 0, 1, 0, 1],
        [1, 1, 1, 4, 2, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 0, 3, 2, 0, 1, 0, 0, 1, 0, 1, 1],
        [0, 1, 1, 3, 2, 1, 1, 0, 0, 1, 2, 1, 0],
        [0, 1, 2, 3, 0, 1, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 3, 4, 1, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 3, 5, 2, 0, 1, 0, 0, 1, 2, 1, 0],
        [1, 1, 1, 0, 2, 0, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 0, 3, 3, 1, 1, 0, 1, 1, 0, 1, 1],
        [0, 1, 1, 4, 0, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 0, 4, 3, 0, 1, 0, 1, 1, 1, 0, 0],
        [1, 1, 1, 3, 1, 0, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 2, 3, 3, 0, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 0, 2, 0, 0, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 0, 0, 1, 0, 1, 0, 1, 1, 3, 0, 0],
        [1, 1, 2, 3, 2, 1, 1, 1, 0, 0, 2, 0, 1],
        [1, 1, 0, 3, 1, 1, 1, 0, 0, 1, 2, 0, 0],
        [1, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 3, 3, 3, 1, 1, 0, 1, 1, 1, 0, 0],
        [1, 1, 1, 4, 2, 0, 1, 0, 0, 1, 0, 1, 0],
        [0, 1, 2, 0, 2, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 2, 4, 2, 0, 1, 0, 0, 0, 1, 1, 1],
        [1, 1, 0, 1, 2, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 2, 3, 3, 0, 1, 0, 0, 0, 0, 0, 1],
        [1, 1, 2, 3, 3, 1, 1, 0, 0, 0, 3, 0, 0],
        [1, 1, 0, 3, 2, 1, 1, 0, 0, 1, 1, 1, 1],
        [0, 1, 2, 3, 1, 0, 2, 0, 1, 1, 0, 1, 1],
        [1, 1, 2, 2, 1, 0, 1, 1, 0, 0, 1, 0, 0],
        [0, 1, 2, 4, 1, 1, 1, 0, 0, 1, 1, 0, 1],
        [1, 1, 3, 5, 0, 1, 1, 0, 0, 1, 2, 1, 0],
        [1, 1, 1, 3, 2, 0, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 0, 1, 3, 1, 1, 0, 0, 1, 1, 0, 1],
        [0, 1, 3, 4, 0, 1, 1, 0, 0, 0, 0, 0, 0],
        [0, 1, 2, 3, 3, 0, 1, 0, 0, 1, 2, 0, 0],
        [0, 1, 2, 0, 2, 0, 1, 0, 0, 1, 3, 0, 1],
        [0, 1, 1, 4, 3, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 0, 3, 2, 1, 2, 0, 0, 1, 1, 1, 0],
        [0, 1, 2, 4, 0, 1, 1, 0, 1, 0, 1, 1, 0],
        [1, 1, 2, 4, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 2, 4, 0, 0, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 2, 4, 1, 1, 1, 0, 0, 0, 0, 0, 1],
        [0, 1, 2, 4, 2, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 0, 1, 0, 1, 1, 0, 1, 1, 1, 0, 1],
        [1, 1, 2, 2, 2, 0, 1, 0, 0, 1, 2, 1, 0],
        [1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1],
        [1, 1, 2, 0, 2, 1, 1, 0, 0, 0, 0, 1, 0],
        [0, 2, 1, 0, 1, 0, 1, 0, 0, 0, 3, 1, 0],
        [1, 1, 1, 4, 0, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 2, 3, 3, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 0, 3, 2, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 2, 3, 3, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 2, 4, 2, 1, 1, 0, 1, 1, 1, 0, 1],
        [1, 1, 1, 4, 1, 0, 1, 0, 1, 1, 1, 0, 0],
        [0, 0, 2, 3, 1, 1, 1, 0, 0, 1, 0, 1, 0],
        [0, 1, 2, 4, 1, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 1, 3, 0, 1, 1, 0, 1, 0, 1, 1, 0],
        [1, 1, 3, 4, 1, 1, 1, 0, 1, 1, 0, 0, 0],
        [1, 1, 1, 4, 0, 1, 1, 0, 0, 1, 0, 0, 1],
        [0, 1, 2, 2, 3, 0, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 2, 3, 1, 1, 1, 0, 0, 1, 2, 1, 0],
        [1, 1, 3, 3, 0, 1, 1, 0, 0, 0, 3, 0, 0],
        [0, 1, 2, 3, 2, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 3, 4, 2, 0, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 0, 5, 2, 1, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 2, 1, 2, 0, 2, 0, 1, 0, 1, 0, 0],
        [1, 1, 1, 3, 1, 0, 1, 1, 0, 1, 0, 0, 0],
        [0, 1, 3, 0, 1, 1, 1, 0, 0, 1, 0, 0, 1],
        [0, 1, 2, 3, 1, 1, 1, 0, 0, 1, 1, 1, 1],
        [0, 1, 0, 0, 2, 1, 1, 0, 1, 1, 0, 1, 1],
        [0, 1, 0, 1, 1, 1, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 1, 3, 0, 1, 1, 0, 0, 1, 3, 0, 0],
        [0, 1, 0, 4, 2, 1, 1, 0, 0, 1, 3, 1, 0],
        [1, 1, 1, 5, 1, 1, 1, 0, 1, 0, 0, 1, 0],
        [0, 1, 2, 4, 1, 0, 1, 0, 0, 0, 0, 0, 1],
        [0, 1, 1, 5, 3, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 2, 3, 3, 1, 1, 0, 1, 1, 1, 1, 0],
        [1, 1, 1, 5, 2, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 0, 3, 3, 1, 1, 1, 0, 0, 3, 0, 0],
        [1, 1, 2, 3, 3, 1, 1, 0, 0, 1, 0, 1, 0],
        [0, 1, 2, 5, 2, 1, 1, 0, 1, 0, 0, 1, 0],
        [1, 1, 2, 3, 2, 1, 1, 0, 0, 0, 1, 0, 1],
        [0, 1, 2, 4, 2, 1, 1, 0, 1, 1, 1, 0, 0],
        [1, 1, 3, 3, 0, 0, 1, 0, 0, 1, 3, 0, 0],
        [1, 0, 1, 2, 0, 1, 1, 0, 0, 0, 2, 0, 0],
        [1, 1, 2, 1, 1, 0, 1, 0, 0, 1, 2, 1, 1],
        [1, 1, 3, 4, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 3, 1, 3, 0, 1, 0, 1, 1, 1, 1, 0],
        [0, 1, 3, 3, 1, 0, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 2, 4, 0, 1, 1, 0, 0, 1, 1, 1, 1],
        [0, 1, 1, 3, 1, 0, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 2, 0, 3, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 2, 1, 2, 0, 1, 0, 0, 0, 0, 1, 1],
        [1, 1, 3, 3, 2, 1, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 1, 3, 3, 1, 1, 0, 1, 1, 2, 1, 1],
        [0, 1, 2, 2, 1, 1, 1, 1, 0, 1, 1, 0, 0],
        [0, 1, 0, 3, 2, 0, 1, 0, 0, 0, 2, 0, 0],
        [0, 1, 0, 1, 2, 1, 1, 0, 1, 0, 3, 0, 1],
        [0, 1, 1, 3, 3, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 0, 0, 1, 1, 1, 0, 0, 1, 2, 0, 0],
        [0, 1, 0, 3, 2, 0, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 0, 2, 3, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 1, 3, 0, 0, 1, 0, 1, 0, 0, 1, 1],
        [1, 1, 1, 4, 3, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 3, 3, 1, 0, 0, 0, 1, 0, 2, 0, 0],
        [1, 1, 2, 4, 3, 0, 1, 0, 1, 1, 2, 0, 0],
        [1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 2, 0, 0],
        [1, 1, 2, 3, 1, 1, 1, 0, 0, 1, 0, 1, 1],
        [1, 1, 1, 1, 3, 1, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 1, 4, 0, 0, 1, 0, 1, 0, 1, 1, 1],
        [0, 1, 0, 3, 1, 0, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 3, 4, 1, 0, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 2, 3, 1, 0, 1, 0, 1, 1, 1, 0, 0],
        [0, 1, 3, 4, 1, 0, 1, 0, 1, 1, 2, 1, 0],
        [0, 1, 0, 4, 0, 1, 1, 0, 1, 1, 2, 1, 0],
        [1, 1, 3, 4, 0, 1, 1, 0, 1, 0, 1, 0, 1],
        [0, 0, 2, 1, 2, 1, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 1, 1, 1, 0, 1, 0, 0, 1, 1, 0, 1],
        [0, 0, 2, 4, 1, 1, 0, 1, 0, 1, 1, 1, 1],
        [1, 1, 3, 0, 0, 1, 1, 0, 0, 1, 1, 1, 1],
        [1, 2, 1, 3, 3, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 1, 4, 0, 0, 1, 0, 1, 1, 2, 1, 1],
        [0, 1, 0, 3, 0, 1, 1, 0, 0, 1, 1, 1, 1],
        [1, 2, 2, 4, 2, 0, 1, 0, 1, 1, 1, 1, 0],
        [1, 1, 2, 3, 1, 0, 1, 0, 1, 0, 0, 0, 0],
        [0, 1, 3, 0, 3, 0, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 1, 1, 1, 0, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 1, 1, 2, 0, 1, 0, 0, 1, 1, 1, 1],
        [0, 1, 0, 4, 0, 1, 1, 0, 0, 0, 0, 1, 1],
        [1, 1, 2, 4, 3, 0, 1, 0, 0, 1, 0, 1, 0],
        [0, 1, 2, 3, 1, 1, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 2, 1, 2, 1, 1, 0, 0, 0, 0, 0, 1],
        [0, 1, 1, 1, 1, 0, 1, 0, 0, 1, 1, 1, 0],
        [0, 2, 3, 3, 3, 1, 2, 0, 0, 0, 0, 1, 0],
        [1, 1, 2, 3, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 3, 1, 3, 0, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 2, 4, 1, 1, 1, 0, 1, 0, 1, 0, 0],
        [1, 1, 0, 0, 3, 0, 1, 0, 0, 0, 1, 1, 1],
        [0, 1, 1, 3, 3, 1, 1, 0, 1, 0, 1, 1, 0],
        [1, 1, 3, 4, 2, 1, 1, 0, 1, 0, 1, 1, 1],
        [1, 1, 0, 2, 3, 0, 1, 0, 0, -1, 3, 0, 0],
        [0, 1, 1, 3, 3, 1, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 0, 4, 3, 1, 1, 0, 1, 1, 2, 0, 0],
        [0, 1, 0, 5, 0, 1, 1, 0, 1, 1, 2, 1, 1],
        [0, 1, 3, 3, 3, 1, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 3, 1, 3, 1, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 1, 0, 1, 0, 1, 0, 0, 0, 3, 0, 0],
        [1, 1, 2, 1, 1, 0, 2, 0, 0, 0, 2, 0, 1],
        [1, 1, 1, 3, 1, 1, 1, 0, 1, 1, 1, 0, 0],
        [1, 1, 2, 3, 3, 0, 1, 1, 0, 1, 0, 0, 0],
        [0, 1, 0, 3, 0, 1, 1, 1, 0, 0, 1, 1, 1],
        [0, 1, 3, 3, 0, 0, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 2, 0, 3, 1, 1, 0, 0, 0, 0, 0, 0],
        [0, 1, 3, 4, 0, 0, 1, 0, 0, 0, 1, 1, 1],
        [0, 1, 3, 3, 1, 1, 1, 0, 1, 0, 1, 1, 1],
        [1, 1, 2, 3, 2, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 0, 4, 3, 0, 1, 0, 0, 0, 3, 1, 0],
        [0, 1, 2, 5, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 0, 4, 3, 0, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 0, 3, 3, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 0, 1, 0, 1, 0, 0, 0, 1, 1, 1, 1],
        [1, 1, 3, 4, 1, 1, 1, 0, 1, 1, 1, 0, 0],
        [1, 1, 2, 3, 3, 1, 1, 0, 0, 1, 1, 1, 1],
        [0, 1, 2, 5, 1, 0, 1, 0, 0, 1, 3, 0, 0],
        [0, 2, 0, 3, 3, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 0, 4, 2, 1, 1, 0, 0, 0, 0, 0, 0],
        [0, 1, 2, 0, 0, 0, 1, 0, 1, 0, 1, 1, 0],
        [1, 1, 2, 4, 2, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 3, 3, 2, 0, 1, 1, 0, 1, 1, 0, 0],
        [1, 1, 3, 3, 1, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 1, 3, 1, 1, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 0, 3, 3, 1, 1, 0, 0, 0, 0, 0, 0],
        [0, 1, 0, 4, 1, 1, 1, 0, 1, 0, 0, 1, 0],
        [0, 1, 3, 0, 0, 1, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 2, 2, 2, 1, 1, 0, 1, 0, 0, 0, 1],
        [1, 1, 1, 3, 3, 1, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 2, 1, 1, 0, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 3, 3, 1, 1, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 3, 3, 0, 1, 1, 1, 0, 1, 1, 0, 0],
        [1, 1, 0, 0, 2, 1, 1, 0, 1, 0, 0, 0, 0],
        [0, 1, 3, 5, 1, 0, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 2, 5, 2, 1, 1, 0, 1, 0, 1, 0, 1],
        [1, 1, 2, 3, 0, 0, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1],
        [1, 1, 0, 1, 2, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 0, 4, 2, 0, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 3, 4, 2, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 1, 2, 3, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 1, 3, 1, 1, 1, 0, 1, 1, 2, 0, 0],
        [1, 1, 0, 4, 0, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 1, 3, 0, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 1, 0, 1, 0, 2, 0, 0, 1, 1, 1, 1],
        [1, 1, 0, 3, 1, 1, 1, 0, 0, 1, 3, 1, 0],
        [1, 2, 0, 4, 2, 0, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 0, 4, 2, 1, 1, 1, 0, 1, 1, 1, 1],
        [1, 1, 2, 0, 0, 0, 1, 1, 0, 0, 1, 0, 1],
        [0, 1, 1, 1, 1, 0, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 0, 3, 2, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 0, 2, 1, 3, 1, 1, 1, 0, 0, 0, 0, 1],
        [1, 1, 2, 4, 1, 1, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 2, 3, 1, 1, 1, 0, 0, 1, 2, 0, 0],
        [1, 2, 2, 4, 0, 1, 1, 0, 1, 1, 0, 0, 1],
        [1, 1, 0, 1, 2, 1, 1, 0, 1, 0, 1, 1, 1],
        [1, 1, 1, 2, 1, 1, 1, 0, 1, 1, 2, 1, 0],
        [1, 1, 1, 3, 3, 0, 1, 0, 0, 0, 2, 0, 0],
        [1, 1, 0, 3, 3, 0, 1, 0, 0, 0, 1, 0, 0],
        [1, 2, 1, 5, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 0, 4, 2, 1, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 0, 4, 0, 0, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 0, 4, 0, 0, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 1, 4, 2, 1, 1, 0, 0, 1, 2, 1, 0],
        [0, 1, 2, 3, 2, 1, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 2, 4, 0, 1, 1, 0, 1, 0, 3, 1, 1],
        [1, 1, 2, 1, 1, 0, 1, 0, 0, 0, 2, 0, 0],
        [1, 1, 2, 4, 2, 0, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 2, 3, 3, 1, 1, 0, 1, 0, 2, 0, 0],
        [0, 1, 2, 5, 3, 1, 1, 0, 1, 0, 0, 1, 0],
        [0, 1, 0, 0, 1, 1, 1, 0, 1, 1, 1, 0, 0],
        [1, 1, 1, 0, 1, 0, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 0, 3, 1, 1, 1, 0, 1, 1, 1, 1, 1],
        [1, 1, 0, 1, 2, 0, 2, 0, 1, 0, 2, 0, 0],
        [0, 1, 3, 4, 0, 1, 1, 1, 0, 1, 2, 0, 0],
        [1, 1, 0, 4, 1, 1, 1, 0, 0, 0, 1, 1, 1],
        [1, 1, 3, 4, 0, 1, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 2, 4, 2, 0, 2, 0, 1, 1, 2, 0, 1],
        [0, 1, 0, 1, 2, 0, 1, 0, 0, 1, 0, 0, 1],
        [1, 1, 3, 2, 1, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 2, 4, 0, 1, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 0, 4, 1, 1, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 3, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 2, 4, 2, 1, 1, 0, 1, 0, 1, 0, 1],
        [0, 1, 3, 4, 2, 1, 1, 0, 0, 0, 0, 0, 0],
        [0, 1, 0, 3, 0, 1, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 0, 3, 3, 0, 1, 0, 0, 1, 2, 0, 0],
        [0, 1, 1, 4, 1, 1, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 2, 2, 2, 1, 2, 0, 1, 1, 0, 1, 1],
        [1, 1, 1, 1, 2, 0, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 2, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 2, 1, 4, 0, 1, 1, 0, 1, 0, 0, 0, 0],
        [0, 1, 0, 4, 2, 0, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 1, 1, 0, 1, 1, 0, 0, 0, 2, 0, 0],
        [1, 1, 0, 4, 0, 1, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 0, 4, 1, 0, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 0, 4, 1, 0, 1, 1, 0, 0, 2, 1, 1],
        [0, 2, 1, 3, 3, 0, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 2, 1, 2, 0, 1, 0, 0, 1, 1, 0, 1],
        [0, 1, 2, 0, 1, 0, 1, 0, 0, 1, 0, 0, 0],
        [1, 2, 2, 1, 2, 0, 1, 0, 0, 1, 1, 1, 1],
        [0, 1, 0, 3, 1, 1, 1, 0, 0, 1, 0, 1, 0],
        [0, 1, 2, 4, 2, 0, 1, 0, 1, 1, 1, 0, 0],
        [1, 1, 3, 1, 2, 1, 1, 0, 0, 1, 1, 1, 1],
        [0, 1, 2, 4, 0, 1, 1, 0, 0, 1, 0, 0, 1],
        [1, 1, 2, 1, 2, 1, 1, 0, 0, 1, 3, 1, 1],
        [0, 1, 3, 0, 2, 1, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 2, 1, 2, 0, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 2, 1, 1, 0, 1, 0, 0, 0, 1, 1, 1],
        [1, 1, 1, 5, 3, 1, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 2, 2, 3, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 3, 2, 2, 0, 1, 0, 1, 0, 1, 1, 1],
        [0, 1, 2, 3, 1, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 2, 4, 1, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 3, 4, 2, 1, 1, 0, 0, 1, 2, 1, 0],
        [1, 1, 2, 3, 2, 1, 1, 0, 0, 0, 2, 0, 0],
        [0, 1, 0, 3, 1, 0, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 2, 3, 3, 0, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 2, 3, 2, 0, 1, 0, 1, 0, 2, 0, 1],
        [0, 1, 0, 5, 3, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 2, 3, 1, 0, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 0, 3, 1, 1, 1, 0, 0, 1, 2, 1, 0],
        [0, 1, 1, 4, 3, 1, 1, 0, 1, 1, 1, 1, 0],
        [1, 1, 2, 4, 1, 1, 1, 0, 1, 1, 1, 0, 1],
        [0, 1, 0, 3, 0, 0, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 2, 4, 0, 0, 1, 0, 1, 1, 1, 1, 0],
        [1, 1, 2, 5, 1, 1, 1, 0, 0, 0, 3, 1, 0],
        [1, 1, 2, 3, 3, 1, 1, 0, 1, 0, 1, 0, 0],
        [1, 1, 3, 3, 2, 1, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 2, 4, 3, 1, 1, 0, 0, 0, 3, 0, 0],
        [1, 2, 0, 2, 3, 1, 1, 0, 0, 1, 2, 0, 0],
        [1, 2, 3, 4, 2, 1, 1, 0, 1, 0, 1, 1, 0],
        [1, 1, 0, 4, 2, 0, 0, 0, 1, 1, 3, 0, 0],
        [1, 1, 2, 4, 0, 0, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 2, 3, 1, 0, 2, 0, 1, 1, 0, 1, 1],
        [0, 1, 0, 0, 0, 1, 1, 0, 0, 1, 2, 0, 0],
        [1, 2, 0, 4, 2, 0, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 2, 3, 3, 1, 1, 0, 0, 1, 2, 1, 0],
        [0, 1, 2, 3, 1, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 0, 0, 3, 0, 1, 0, 0, 1, 1, 0, 1],
        [1, 1, 3, 1, 2, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 0, 3, 3, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 2, 1, 0, 1, 1, 0, 0, 0, 0, 0, 1],
        [0, 1, 3, 3, 0, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 3, 5, 3, 0, 2, 0, 0, 0, 2, 1, 1],
        [1, 1, 2, 1, 3, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 1, 4, 3, 1, 1, 0, 0, 1, 1, 0, 1],
        [1, 1, 1, 4, 1, 0, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 3, 3, 2, 0, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 3, 3, 1, 0, 1, 0, 0, 1, 2, 0, 0],
        [0, 1, 1, 3, 1, 1, 1, 0, 1, 1, 0, 1, 0],
        [0, 1, 3, 0, 3, 0, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 0, 3, 3, 0, 1, 0, 1, 0, 1, 1, 0],
        [0, 1, 0, 3, 2, 1, 1, 0, 1, 1, 1, 0, 0],
        [0, 2, 1, 3, 3, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 0, 4, 1, 1, 1, 0, 0, 1, 0, 1, 1],
        [0, 0, 2, 4, 0, 1, 1, 0, 0, 1, 1, 1, 1],
        [0, 1, 2, 4, 3, 0, 1, 0, 0, 1, 0, 1, 0],
        [0, 1, 0, 3, 3, 0, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 1, 4, 3, 1, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 2, 4, 1, 1, 1, 0, 0, 0, 3, 1, 0],
        [1, 1, 1, 2, 3, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 1, 0, 3, 0, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 2, 3, 1, 0, 1, 0, 1, 0, 2, 0, 0],
        [1, 1, 0, 3, 2, 1, 1, 1, 0, 1, 3, 1, 1],
        [1, 1, 2, 2, 1, 1, 1, 0, 1, 1, 1, 0, 0],
        [0, 1, 0, 5, 1, 0, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 2, 1, 0, 0, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 1, 0, 3, 0, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 0, 3, 2, 0, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 2, 5, 2, 1, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 3, 2, 1, 0, 1, 0, 0, 0, 0, 0, 0],
        [1, 0, 2, 1, 3, 0, 1, 0, 0, 1, 3, 1, 1],
        [0, 1, 0, 2, 0, 0, 1, 0, 0, 0, 0, 0, 0],
        [0, 1, 1, 2, 1, 0, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 2, 1, 0, 1, 1, 0, 0, 0, 2, 0, 0],
        [1, 1, 0, 4, 1, 0, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 1, 1, 2, 0, 1, 0, 0, 1, 0, 0, 1],
        [0, 1, 0, 3, 3, 0, 1, 1, 1, 0, 1, 0, 0],
        [1, 1, 2, 1, 1, 0, 1, 0, 1, 0, 0, 0, 0],
        [0, 1, 2, 2, 1, 1, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 1, 3, 3, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 3, 3, 2, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 3, 4, 3, 1, 1, 0, 0, 1, 0, 1, 1],
        [0, 1, 2, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1],
        [1, 1, 2, 1, 1, 1, 1, 0, 0, 1, 2, 0, 1],
        [0, 1, 3, 1, 0, 1, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 2, 3, 3, 0, 1, 0, 0, 0, 0, 0, 1],
        [0, 1, 3, 4, 3, 1, 1, 0, 1, 0, 2, 1, 0],
        [1, 2, 2, 0, 3, 0, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 1, 4, 3, 0, 1, 0, 1, 1, 0, 1, 0],
        [0, 1, 1, 3, 2, 1, 1, 0, 0, 0, 0, 0, 0],
        [0, 1, 3, 4, 1, 0, 2, 0, 1, 1, 2, 0, 0],
        [0, 1, 2, 3, 3, 0, 1, 0, 0, 0, 3, 1, 0],
        [1, 1, 2, 2, 1, 0, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 3, 4, 1, 1, 1, 0, 1, 1, 1, 0, 1],
        [1, 1, 3, 4, 3, 0, 1, 0, 0, 0, 2, 0, 1],
        [1, 1, 0, 3, 3, 0, 1, 0, 0, 0, 0, 0, 0],
        [0, 1, 2, 5, 3, 1, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 0, 4, 1, 0, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 2, 3, 1, 1, 1, 1, 0, 1, 1, 0, 0],
        [0, 1, 1, 4, 1, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 2, 4, 1, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 1, 4, 3, 1, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 0, 3, 2, 1, 1, 0, 0, 1, 0, 1, 1],
        [0, 1, 2, 3, 1, 0, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 1, 4, 1, 1, 1, 0, 1, 1, 2, 0, 0],
        [1, 1, 0, 3, 0, 0, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 1, 1, 3, 0, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 1, 3, 2, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 0, 3, 2, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 2, 3, 2, 0, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 2, 4, 1, 1, 1, 0, 0, 1, 1, 0, 1],
        [1, 0, 2, 5, 1, 1, 2, 1, 0, 1, 1, 1, 1],
        [0, 1, 1, 2, 3, 0, 1, 0, 0, 1, 2, 1, 0],
        [1, 2, 1, 3, 1, 1, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 0, 4, 3, 1, 1, 0, 1, 1, 0, 1, 1],
        [0, 2, 0, 1, 3, 1, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 2, 4, 0, 1, 1, 0, 1, 1, 0, 1, 1],
        [1, 1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 1, 3, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 1, 3, 1, 1, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 0, 4, 2, 1, 1, 0, 0, 0, 1, 1, 1],
        [1, 1, 1, 0, 3, 1, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 3, 4, 2, 0, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 0, 3, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 2, 2, 0, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 3, 4, 0, 1, 1, 0, 1, 0, 1, 0, 0],
        [1, 1, 3, 5, 2, 1, 1, 0, 0, 1, 2, 1, 0],
        [0, 1, 3, 3, 2, 1, 1, 0, 1, 1, 0, 0, 0],
        [1, 1, 3, 3, 1, 1, 0, 0, 0, 1, 0, 1, 1],
        [0, 1, 2, 4, 3, 1, 1, 0, 0, 1, 0, 0, 1],
        [0, 1, 1, 4, 3, 0, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 2, 3, 1, 1, 1, 0, 0, 0, 2, 0, 0],
        [1, 1, 3, 4, 2, 1, 1, 0, 0, 1, 0, 1, 1],
        [1, 1, 2, 3, 2, 1, 1, 1, 1, 1, 0, 1, 1],
        [1, 1, 0, 3, 0, 1, 1, 0, 0, 1, 0, 0, 1],
        [0, 1, 2, 4, 2, 1, 1, 0, 1, 1, 1, 0, 0],
        [1, 1, 2, 0, 1, 0, 1, 0, 0, 1, 0, 0, 1],
        [1, 1, 3, 1, 2, 0, 1, 0, 1, 0, 1, 0, 1],
        [0, 1, 1, 1, 1, 0, 1, 0, 0, 1, 2, 0, 0],
        [0, 1, 0, 1, 3, 1, 1, 0, 1, 0, 0, 1, 1],
        [1, 2, 3, 4, 3, 0, 1, 0, 1, 0, 0, 1, 0],
        [0, 1, 2, 4, 2, 1, 1, 0, 1, 0, 3, 0, 1],
        [1, 1, 1, 3, 1, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 2, 3, 0, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 3, 4, 0, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 1, 1, 1, 1, 1, 0, 1, 0, 2, 0, 0],
        [0, 1, 2, 3, 2, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 0, 2, 0, 0, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 2, 1, 1, 1, 1, 0, 1, 0, 2, 0, 1],
        [1, 2, 0, 3, 1, 0, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 3, 0, 0, 0, 1, 0, 1, 1, 2, 1, 0],
        [1, 1, 2, 1, 1, 1, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 2, 4, 0, 0, 1, 0, 0, 1, 1, 1, 0],
        [0, 2, 0, 5, 1, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 1, 3, 3, 1, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 3, 0, 3, 0, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 2, 2, 0, 0, 1, 0, 0, 1, 3, 1, 0],
        [0, 1, 2, 3, 0, 0, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 1, 3, 2, 0, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 2, 2, 0, 1, 1, 1, 1, 1, 1, 1, 1],
        [1, 1, 0, 1, 2, 0, 1, 0, 0, 1, 1, 1, 1],
        [0, 1, 1, 2, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 0, 1, 3, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 1, 3, 1, 0, 1, 0, 1, 1, 2, 1, 0],
        [1, 1, 0, 5, 1, 1, 1, 0, 1, 0, 1, 1, 1],
        [0, 1, 2, 1, 2, 0, 1, 0, 0, 1, 2, 1, 0],
        [0, 1, 0, 3, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 3, 4, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 0, 4, 1, 1, 1, 0, 0, 0, 0, 1, 1],
        [0, 1, 0, 3, 1, 0, 1, 0, 1, 0, 1, 0, 0],
        [0, 1, 2, 3, 3, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 0, 0, 1, 0, 1, 0, 0, 0, 0, 1, 1],
        [0, 1, 1, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 2, 3, 2, 1, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 1, 4, 1, 1, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 2, 3, 3, 1, 1, 0, 1, 1, 1, 1, 0],
        [1, 1, 1, 3, 1, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 2, 4, 0, 1, 1, 0, 0, 1, 0, 1, 0],
        [0, 0, 0, 4, 0, 1, 1, 0, 0, 1, 1, 0, 1],
        [0, 1, 3, 2, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 0, 0, 3, 0, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 3, 0, 2, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 2, 1, 2, 0, 1, 0, 0, 1, 1, 0, 1],
        [1, 1, 2, 2, 3, 1, 1, 0, 0, 0, 0, 0, 1],
        [1, 0, 3, 4, 3, 0, 1, 0, 1, 1, 1, 0, 0],
        [0, 1, 0, 4, 1, 0, 1, 0, 0, 0, 3, 1, 1],
        [1, 2, 2, 4, 0, 1, 1, 0, 0, 0, 0, 0, 1],
        [1, 1, 3, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 0, 3, 0, 0, 1, 1, 0, 1, 0, 1, 0],
        [1, 2, 2, 4, 0, 0, 1, 0, 1, 0, 2, 0, 1],
        [1, 1, 3, 1, 1, 0, 1, 0, 0, 1, 1, 0, 1],
        [1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 1, 1, 1],
        [1, 1, 2, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1],
        [0, 1, 0, 0, 2, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 2, 3, 2, 1, 2, 0, 1, 1, 2, 0, 0],
        [1, 1, 3, 1, 0, 0, 1, 0, 0, 0, 2, 1, 1],
        [0, 1, 3, 4, 1, 1, 1, 0, 0, 1, 2, 1, 0],
        [1, 1, 3, 3, 1, 1, 1, 0, 0, 0, 1, 1, 1],
        [1, 1, 0, 3, 0, 0, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 2, 3, 0, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 2, 0, 3, 1, 1, 0, 0, 1, 0, 0, 0],
        [0, 2, 3, 1, 0, 1, 1, 0, 1, 0, 2, 1, 0],
        [0, 2, 0, 5, 3, 0, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 2, 4, 3, 0, 1, 0, 0, 0, 1, 1, 1],
        [0, 1, 3, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0],
        [0, 1, 0, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 0, 5, 3, 1, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 2, 1, 3, 0, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 1, 3, 2, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 3, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 2, 3, 0, 0, 1, 0, 0, 1, 3, 0, 0],
        [0, 1, 0, 4, 1, 1, 1, 0, 0, 1, 1, 1, 1],
        [0, 1, 3, 2, 0, 1, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 1, 3, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 0, 4, 2, 0, 1, 0, 1, 0, 1, 0, 0],
        [1, 1, 0, 3, 3, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 2, 0, 1, 0, 1, 0, 1, 0, 2, 0, 0],
        [1, 1, 2, 4, 1, 1, 1, 0, 0, 1, 3, 0, 1],
        [0, 1, 3, 3, 0, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 3, 4, 1, 1, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 1, 3, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 3, 2, 3, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 0, 3, 3, 0, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 3, 4, 1, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 0, 2, 4, 2, 1, 1, 0, 0, 0, 2, 0, 1],
        [0, 1, 0, 0, 1, 0, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 2, 4, 1, 0, 1, 0, 0, 0, 0, 0, 0],
        [0, 1, 3, 5, 2, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 1, 4, 1, 1, 1, 0, 0, 0, 3, 1, 0],
        [0, 1, 2, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 0, 3, 3, 1, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 2, 4, 3, 1, 1, 0, 0, 0, 2, 0, 0],
        [1, 1, 1, 1, 3, 0, 1, 0, 1, 0, 1, 0, 0],
        [0, 1, 2, 0, 1, 1, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 1, 4, 3, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 0, 4, 3, 0, 1, 0, 1, 1, 1, 0, 0],
        [1, 1, 1, 4, 1, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 2, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0],
        [0, 0, 3, 4, 1, 0, 1, 0, 0, 0, 0, 0, 1],
        [1, 1, 0, 4, 3, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 2, 2, 2, 1, 1, 0, 0, 1, 2, 1, 1],
        [1, 1, 3, 4, 3, 0, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 2, 5, 2, 0, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 2, 4, 3, 0, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 1, 3, 2, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 2, 0, 2, 1, 1, 0, 1, 1, 1, 0, 0],
        [1, 2, 1, 1, 1, 1, 1, 0, 0, 0, 2, 1, 0],
        [0, 2, 0, 3, 0, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 0, 1, 1, 1, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 1, 4, 0, 1, 1, 0, 1, 0, 0, 0, 0],
        [1, 1, 2, 4, 0, 1, 1, 0, 0, 1, 1, 1, 1],
        [1, 0, 3, 1, 0, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 0, 1, 3, 1, 1, 0, 0, 0, 0, 0, 0],
        [0, 1, 2, 3, 1, 1, 0, 0, 0, 0, 2, 0, 0],
        [1, 1, 3, 2, 2, 1, 1, 0, 1, 1, 0, 1, 0],
        [1, 2, 2, 1, 1, 0, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 1, 3, 1, 0, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 3, 1, 1, 1, 1, 0, 0, 1, 2, 1, 1],
        [0, 1, 0, 4, 1, 0, 1, 1, 1, 1, 1, 0, 0],
        [0, 1, 1, 4, 2, 0, 1, 1, 0, 0, 0, 0, 1],
        [1, 1, 1, 3, 3, 1, 1, 0, 1, 1, 1, 1, 0],
        [0, 1, 3, 3, 2, 1, 1, 0, 0, 0, 2, 0, 1],
        [1, 1, 0, 4, 3, 1, 1, 0, 0, 1, 1, 0, 1],
        [0, 1, 1, 3, 3, 0, 1, 0, 1, 0, 1, 0, 0],
        [1, 1, 0, 3, 1, 0, 1, 0, 0, 0, 0, 0, 1],
        [1, 1, 0, 3, 0, 1, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 1, 3, 2, 0, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 2, 0, 1, 0, 1, 0, 0, 0, 1, 1, 1],
        [1, 1, 3, 3, 0, 1, 1, 0, 1, 0, 1, 0, 0],
        [0, 0, 0, 3, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 0, 0, 3, 1, 1, 0, 1, 0, 0, 0, 0],
        [1, 1, 1, 2, 1, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 0, 4, 0, 1, 1, 0, 0, 0, 0, 0, 1],
        [1, 1, 3, 1, 2, 0, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 3, 1, 2, 1, 1, 0, 0, 0, 0, 0, 1],
        [1, 1, 0, 3, 1, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 2, 2, 0, 1, 1, 0, 0, 0, 2, 0, 0],
        [0, 1, 0, 1, 0, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 2, 2, 1, 2, 1, 1, 0, 0, 0, 2, 0, 0],
        [1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 1, 0],
        [0, 1, 0, 4, 0, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 0, 1, 1, 0, 1, 0, 0, 1, 2, 0, 0],
        [0, 1, 2, 1, 3, 1, 1, 0, 0, 0, 3, 0, 0],
        [1, 1, 0, 1, 1, 0, 1, 0, 1, 1, 0, 0, 1],
        [1, 1, 2, 3, 1, 1, 1, 0, 1, 1, 0, 0, 0],
        [0, 2, 2, 4, 3, 1, 2, 0, 0, 0, 0, 0, 1],
        [1, 1, 3, 4, 3, 0, 1, 0, 0, 1, 0, 1, 0],
        [0, 1, 0, 4, 2, 1, 1, 0, 1, 1, 0, 0, 1],
        [0, 1, 2, 3, 0, 1, 1, 0, 1, 1, 0, 0, 0],
        [1, 1, 3, 1, 2, 0, 1, 0, 0, 1, 0, 1, 1],
        [1, 1, 1, 3, 1, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 2, 2, 1, 1, 1, 0, 0, 0, 0, 0, 0],
        [0, 1, 0, 1, 0, 1, 1, 0, 1, 1, 1, 0, 1],
        [0, 1, 0, 4, 1, 0, 1, 0, 1, 0, 0, 1, 0],
        [0, 1, 2, 4, 0, 1, 1, 0, 1, 1, 1, 1, 1],
        [1, 1, 3, 1, 1, 0, 1, 0, 1, 1, 2, 1, 0],
        [0, 1, 0, 1, 0, 1, 1, 0, 0, 0, 2, 0, 1],
        [0, 1, 2, 4, 2, 1, 1, 0, 0, 1, 1, 1, 1],
        [0, 1, 1, 3, 0, 0, 1, 0, 1, 0, 3, 0, 0],
        [0, 1, 2, 3, 3, 0, 1, 0, 0, 0, 3, 1, 0],
        [0, 1, 2, 0, 2, 1, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 1, 3, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 0, 1, 3, 1, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 0, 3, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 3, 3, 1, 0, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 3, 3, 1, 0, 1, 0, 1, 1, 3, 1, 1],
        [1, 1, 2, 3, 2, 1, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 1, 0, 1, 1, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 2, 3, 1, 0, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 2, 4, 2, 0, 1, 0, 0, 1, 1, 0, 1],
        [1, 1, 3, 1, 0, 1, 1, 0, 0, 1, 1, 1, 1],
        [0, 1, 2, 1, 0, 0, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 2, 1, 1, 1, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 1, 3, 2, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 1, 4, 0, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 0, 4, 1, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 2, 3, 3, 0, 1, 1, 0, 0, 0, 1, 0],
        [0, 1, 2, 4, 0, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 1, 5, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 1, 3, 1, 0, 1, 0, 1, 1, 0, 1, 0],
        [1, 1, 3, 4, 0, 1, 1, 0, 1, 1, 2, 0, 1],
        [1, 1, 0, 1, 2, 1, 1, 0, 1, 0, 2, 0, 0],
        [0, 1, 0, 1, 0, 1, 1, 0, 0, 1, 0, 1, 1],
        [0, 1, 1, 4, 2, 1, 1, 0, 0, 0, 1, 1, 1],
        [0, 1, 2, 3, 2, 1, 1, 0, 0, 0, 2, 0, 0],
        [0, 1, 1, 0, 3, 0, 1, 0, 1, 1, 1, 1, 0],
        [1, 1, 0, 4, 3, 1, 1, 0, 1, 0, 1, 1, 0],
        [1, 1, 1, 3, 1, 1, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 0, 3, 3, 0, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 3, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 1, 2, 1, 0, 1, 0, 0, 1, 3, 0, 0],
        [1, 1, 2, 3, 1, 0, 2, 0, 0, 0, 0, 0, 0],
        [1, 1, 2, 4, 0, 0, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 1, 3, 2, 0, 1, 0, 0, 1, 2, 0, 0],
        [0, 1, 3, 0, 3, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 2, 4, 0, 1, 1, 0, 1, 1, 1, 0, 1],
        [1, 0, 0, 1, 1, 0, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 3, 3, 1, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 2, 4, 1, 0, 1, 0, 1, 1, 0, 0, 1],
        [1, 1, 2, 3, 0, 0, 1, 0, 1, 0, 0, 1, 0],
        [0, 1, 0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0],
        [0, 2, 1, 4, 1, 0, 1, 0, 0, 0, 3, 0, 0],
        [0, 1, 0, 0, 0, 0, 1, 0, 1, 1, 2, 0, 0],
        [1, 2, 1, 4, 3, 1, 1, 0, 0, 1, 0, 0, 1],
        [1, 1, 2, 3, 1, 1, 1, 0, 1, 1, 0, 0, 0],
        [1, 1, 0, 2, 3, 0, 1, 0, 1, 0, 1, 0, 0],
        [1, 1, 3, 3, 2, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 0, 1, 1, 0, 1, 0, 1, 0, 1, 0, 0],
        [0, 1, 1, 4, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 2, 5, 2, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 2, 0, 1, 0, 1, 1, 0, 0, 1, 2, 1, 0],
        [0, 1, 0, 3, 2, 1, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 2, 3, 1, 1, 1, 0, 1, 0, 1, 1, 1],
        [1, 1, 1, 3, 1, 1, 1, 0, 0, 0, 0, 1, 1],
        [1, 1, 2, 1, 3, 1, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 2, 4, 3, 1, 1, 0, 1, 1, 1, 1, 1],
        [0, 1, 3, 0, 1, 1, 1, 0, 1, 0, 0, 0, 0],
        [1, 1, 0, 4, 2, 0, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 1, 4, 3, 0, 1, 0, 0, 1, 3, 1, 1],
        [1, 1, 1, 5, 3, 1, 1, 0, 1, 0, 1, 0, 0],
        [0, 1, 3, 3, 1, 1, 1, 0, 0, 1, 1, 1, 1],
        [0, 0, 0, 4, 0, 1, 1, 0, 1, 1, 2, 1, 1],
        [0, 1, 3, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0],
        [1, 0, 2, 4, 1, 1, 1, 0, 1, 0, 1, 1, 1],
        [1, 1, 2, 3, 0, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 2, 4, 2, 0, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 2, 3, 2, 1, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 2, 1, 3, 1, 1, 0, 1, 0, 1, 0, 1],
        [1, 1, 1, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 0, 1, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 1, 4, 2, 1, 1, 0, 1, 0, 2, 0, 0],
        [0, 1, 0, 2, 2, 1, 1, 0, 1, 1, 3, 0, 0],
        [1, 1, 1, 1, 2, 1, 1, 0, 1, 0, 2, 1, 1],
        [1, 2, 1, 3, 2, 1, 1, 0, 1, 0, 1, 1, 0],
        [1, 1, 1, 2, 0, 1, 0, 0, 0, 1, 1, 1, 1],
        [1, 1, 0, 1, 0, 0, 1, 0, 1, 1, 2, 0, 0],
        [1, 1, 3, 3, 0, 0, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 3, 3, 0, 1, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 2, 3, 2, 0, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 2, 3, 2, 0, 1, 0, 1, 1, 1, 1, 1],
        [0, 1, 1, 3, 1, 1, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 1, 2, 0, 1, 1, 0, 1, 1, 1, 1, 1],
        [1, 1, 3, 5, 0, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 2, 3, 3, 1, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 3, 1, 3, 0, 1, 0, 0, 0, 0, 0, 1],
        [1, 1, 2, 3, 2, 1, 1, 0, 1, 0, 0, 0, 0],
        [0, 1, 2, 3, 1, 0, 1, 0, 1, 0, 3, 1, 0],
        [1, 1, 3, 4, 2, 0, 1, 0, 0, 0, 1, 0, 1],
        [0, 1, 0, 4, 0, 1, 1, 0, 0, 0, 0, 1, 1],
        [0, 1, 1, 3, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 1, 4, 1, 0, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 0, 4, 3, 1, 1, 0, 1, 0, 1, 0, 1],
        [0, 1, 3, 1, 1, 1, 1, 0, 1, 1, 0, 0, 0],
        [1, 1, 3, 2, 1, 1, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 0, 4, 0, 1, 1, 0, 0, 1, 0, 1, 1],
        [0, 2, 0, 3, 2, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 2, 2, 3, 0, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 1, 1, 3, 1, 1, 0, 1, 1, 0, 0, 0],
        [1, 1, 1, 0, 0, 0, 1, 0, 0, 1, 1, 1, 1],
        [0, 1, 2, 4, 3, 0, 1, 0, 0, 0, 2, 1, 1],
        [1, 2, 2, 0, 2, 0, 1, 0, 1, 0, 1, 0, 0],
        [1, 1, 1, 3, 3, 1, 1, 0, 1, 1, 1, 0, 0],
        [0, 2, 2, 4, 3, 0, 1, 0, 1, 0, 0, 0, 0],
        [0, 1, 2, 3, 2, 0, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 2, 4, 3, 1, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 1, 3, 2, 0, 1, 0, 1, 1, 1, 1, 0],
        [0, 2, 3, 3, 0, 1, 1, 0, 0, 1, 0, 1, 0],
        [0, 1, 2, 1, 1, 0, 1, 0, 0, 0, 0, 0, 1],
        [1, 1, 2, 1, 1, 0, 1, 0, 0, 0, 3, 0, 1],
        [0, 1, 2, 3, 0, 0, 1, 0, 1, 0, 3, 1, 1],
        [0, 1, 0, 0, 3, 1, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 2, 1, 3, 1, 1, 0, 0, 1, 0, 0, 1],
        [1, 1, 2, 4, 0, 1, 1, 0, 1, 0, 2, 1, 1],
        [1, 1, 2, 1, 3, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 0, 3, 2, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 0, 4, 1, 0, 1, 0, 0, 0, 1, 1, 0],
        [0, 0, 2, 0, 1, 0, 2, 0, 0, 1, 0, 1, 1],
        [0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 3, 0, 0],
        [1, 1, 2, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1],
        [0, 1, 0, 4, 0, 1, 1, 0, 1, 1, 1, 0, 1],
        [1, 1, 2, 3, 1, 1, 1, 0, 1, 0, 0, 0, 0],
        [1, 1, 0, 1, 1, 0, 1, 0, 1, 1, 2, 0, 0],
        [0, 1, 3, 2, 3, 1, 1, 1, 0, 0, 1, 1, 0],
        [0, 1, 0, 4, 3, 0, 1, 1, 1, 0, 0, 0, 0],
        [0, 1, 2, 4, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 3, 3, 2, 1, 1, 0, 0, 0, 2, 0, 0],
        [0, 1, 3, 1, 2, 1, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 2, 4, 1, 0, 1, 0, 0, 1, 3, 1, 1],
        [0, 1, 0, 3, 0, 0, 1, 0, 0, 1, 2, 1, 0],
        [0, 1, 0, 3, 0, 0, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 3, 0, 3, 1, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 2, 3, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 2, 3, 1, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 3, 5, 0, 1, 1, 0, 0, 0, 3, 1, 1],
        [1, 1, 2, 1, 3, 1, 1, 0, 0, 0, 2, 0, 0],
        [0, 0, 3, 3, 0, 1, 1, 0, 0, 0, 2, 0, 0],
        [1, 1, 0, 3, 3, 0, 1, 0, 1, 1, 1, 0, 0],
        [0, 1, 3, 3, 1, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 1, 1, 3, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 3, 3, 1, 1, 2, 0, 0, 0, 0, 1, 0],
        [0, 2, 3, 4, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 3, 0, 2, 1, 1, 0, 1, 0, 0, 0, 1],
        [1, 1, 1, 4, 1, 1, 1, 0, 0, 0, 0, 0, 0],
        [0, 1, 2, 4, 0, 1, 1, 0, 0, 0, 2, 1, 1],
        [1, 2, 2, 3, 2, 1, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 2, 1, 2, 1, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 0, 4, 3, 1, 1, 0, 0, 1, 2, 1, 0],
        [1, 1, 3, 4, 3, 0, 1, 0, 0, 1, 3, 1, 1],
        [0, 1, 3, 5, 2, 0, 1, 1, 0, 0, 1, 1, 1],
        [0, 1, 0, 1, 2, 1, 1, 0, 0, 1, 3, 1, 1],
        [1, 1, 2, 4, 2, 0, 1, 0, 1, 1, 1, 1, 1],
        [1, 1, 2, 3, 2, 1, 1, 0, 0, 1, 0, 0, 1],
        [0, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 0, 2, 1, 1, 1, 0, 1, 0, 1, 1, 0],
        [0, 1, 0, 5, 1, 1, 1, 0, 1, 1, 1, 0, 0],
        [1, 1, 3, 2, 1, 0, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 3, 4, 3, 1, 1, 0, 1, 0, 2, 0, 1],
        [1, 1, 0, 4, 1, 1, 1, 0, 0, 0, 2, 0, 1],
        [0, 1, 3, 3, 2, 0, 1, 0, 1, 0, 0, 1, 0],
        [1, 1, 0, 4, 1, 1, 1, 0, 1, 1, 0, 1, 1],
        [0, 1, 2, 2, 3, 1, 1, 0, 0, 1, 2, 0, 0],
        [0, 1, 2, 0, 2, 0, 1, 0, 1, 0, 1, 0, 1],
        [1, 1, 0, 3, 1, 1, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 1, 0, 2, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 3, 3, 1, 1, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 0],
        [1, 1, 3, 5, 1, 0, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 2, 3, 0, 1, 1, 1, 0, 0, 1, 0, 0],
        [0, 1, 3, 3, 3, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 0, 3, 1, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 0, 3, 3, 1, 0, 0, 0, 0, 1, 0, 0],
        [0, 1, 1, 1, 1, 0, 1, 0, 0, 0, 2, 0, 0],
        [1, 1, 2, 4, 1, 0, 1, 0, 0, 1, 0, 1, 1],
        [0, 1, 0, 1, 0, 1, 1, 0, 0, 1, 1, 1, 0],
        [0, 0, 2, 4, 2, 1, 1, 0, 0, 1, 0, 1, 1],
        [1, 1, 3, 2, 2, 0, 1, 0, 0, 1, 2, 1, 0],
        [1, 1, 1, 3, 1, 0, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 2, 4, 1, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 2, 4, 2, 1, 1, 0, 0, 1, 1, 0, 1],
        [0, 1, 0, 1, 1, 1, 2, 0, 0, 1, 2, 1, 1],
        [1, 1, 3, 3, 2, 1, 1, 0, 0, 1, 1, 1, 1],
        [0, 1, 3, 4, 1, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 2, 3, 2, 0, 1, 0, 0, 1, 2, 1, 0],
        [1, 1, 1, 3, 1, 1, 1, 0, 0, 1, 3, 0, 0],
        [1, 1, 1, 3, 2, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 2, 3, 3, 1, 1, 0, 1, 0, 2, 0, 0],
        [1, 1, 3, 0, 0, 1, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 0, 3, 2, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 2, 3, 2, 1, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 2, 4, 0, 1, 1, 0, 0, 1, 0, 0, 1],
        [0, 1, 2, 4, 3, 1, 1, 0, 0, 0, 0, 1, 1],
        [0, 1, 1, 4, 1, 1, 1, 0, 1, 0, 1, 1, 1],
        [1, 1, 2, 3, 1, 1, 1, 0, 0, 0, 0, 1, 1],
        [0, 1, 2, 4, 3, 1, 1, 0, 1, 1, 1, 1, 1],
        [1, 1, 2, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 1, 5, 1, 1, 1, 0, 0, 1, 2, 1, 0],
        [1, 1, 2, 2, 2, 0, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 1, 3, 0, 1, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 2, 3, 3, 0, 1, 0, 1, 0, 0, 0, 0],
        [0, 1, 2, 4, 1, 1, 1, 0, 1, 1, 1, 0, 0],
        [1, 1, 1, 4, 1, 1, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 0, 0, 2, 1, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 3, 0, 2, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 3, 3, 0, 1, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 1, 1, 3, 1, 1, 0, 0, 1, 2, 1, 1],
        [1, 1, 2, 5, 1, 1, 1, 0, 1, 1, 3, 0, 1],
        [0, 1, 0, 3, 2, 0, 2, 0, 0, 1, 2, 0, 0],
        [0, 1, 2, 3, 3, 1, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 2, 3, 1, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 2, 3, 4, 0, 0, 1, 1, 0, 1, 2, 0, 0],
        [1, 1, 0, 3, 3, 1, 1, 0, 1, 1, 3, 1, 0],
        [1, 1, 0, 2, 3, 1, 1, 0, 0, 0, 1, 1, 1],
        [0, 1, 0, 2, 1, 0, 1, 0, 0, 1, 1, 0, 1],
        [1, 1, 1, 4, 3, 1, 1, 0, 0, 1, 2, 1, 0],
        [1, 1, 1, 3, 1, 1, 1, 0, 1, 1, 3, 1, 1],
        [1, 1, 1, 4, 2, 0, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 2, 3, 1, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 1, 1, 0, 0, 1, 0, 0, 0, 3, 1, 0],
        [1, 2, 1, 0, 0, 0, 1, 0, 1, 0, 0, 1, 0],
        [0, 1, 0, 3, 0, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 2, 3, 1, 1, 1, 0, 0, 1, 2, 1, 0],
        [1, 1, 1, 0, 1, 1, 2, 0, 0, 0, 0, 0, 0],
        [1, 1, 1, 4, 2, 0, 1, 0, 0, 0, 2, 0, 1],
        [1, 1, 0, 4, 0, 1, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 2, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1],
        [1, 1, 0, 3, 3, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 1, 3, 1, 1, 1, 0, 1, 0, 0, 1, 0],
        [1, 1, 0, 4, 3, 0, 1, 0, 0, 0, 2, 0, 0],
        [1, 1, 2, 4, 0, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 2, 1, 1, 1, 1, 1, 0, 1, 0, 0, 1],
        [1, 1, 3, 2, 1, 1, 1, 0, 1, 1, 0, 0, 0],
        [0, 1, 0, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0],
        [0, 1, 2, 4, 3, 1, 1, 0, 0, 1, 2, 1, 0],
        [1, 1, 2, 4, 2, 0, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 1, 3, 1, 0, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 3, 0, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 2, 0, 2, 0, 1, 0, 0, 0, 0, 0, 0],
        [0, 1, 3, 3, 2, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 2, 4, 2, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 1, 4, 1, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 0, 2, 5, 2, 0, 0, 0, 0, 1, 1, 1, 1],
        [1, 1, 0, 4, 3, 1, 1, 0, 1, 0, 1, 1, 1],
        [0, 1, 1, 3, 1, 0, 2, 0, 0, 1, 1, 0, 0],
        [1, 1, 1, 0, 2, 1, 1, 0, 0, 0, 1, 1, 1],
        [1, 1, 0, 4, 1, 0, 1, 0, 1, 1, 1, 1, 0],
        [1, 1, 3, 1, 1, 0, 1, 0, 1, 0, 1, 1, 1],
        [1, 1, 1, 3, 3, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 3, 3, 0, 1, 1, 0, 0, 0, 2, 0, 1],
        [0, 1, 2, 4, 2, 1, 1, 0, 1, 0, 0, 1, 1],
        [1, 0, 1, 3, 0, 0, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 1, 3, 1, 1, 1, 0, 0, 1, 3, 0, 0],
        [0, 1, 2, 2, 1, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 0, 3, 1, 1, 2, 0, 0, 0, 1, 1, 0],
        [0, 1, 0, 3, 0, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 2, 1, 1, 1, 1, 0, 0, 0, 2, 1, 1],
        [0, 1, 0, 3, 1, 1, 1, 0, 0, 1, 2, 0, 0],
        [0, 1, 2, 4, 0, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 2, 1, 3, 0, 1, 0, 0, 1, 0, 1, 0],
        [0, 1, 1, 3, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 2, 0, 3, 1, 1, 0, 0, 1, 2, 0, 0],
        [0, 1, 2, 5, 0, 0, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 2, 3, 1, 1, 1, 1, 1, 0, 2, 0, 0],
        [1, 1, 3, 1, 1, 0, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 2, 1, 3, 1, 2, 0, 0, 0, 0, 0, 0],
        [1, 1, 0, 3, 2, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 2, 0, 3, 0, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 3, 4, 1, 1, 1, 0, 1, 1, 0, 0, 1],
        [0, 1, 0, 4, 1, 0, 2, 0, 1, 0, 2, 1, 0],
        [1, 1, 2, 0, 2, 1, 1, 0, 1, 1, 1, 0, 1],
        [1, 1, 1, 3, 0, 1, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 0, 2, 3, 1, 1, 0, 1, 1, 2, 0, 1],
        [0, 1, 2, 1, 2, 0, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 2, 3, 3, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 2, 3, 2, 1, 1, 0, 1, 1, 0, 0, 0],
        [1, 1, 2, 3, 2, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 3, 0, 2, 0, 1, 0, 0, 1, 1, 0, 0],
        [-1, 1, 0, 5, 1, 0, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 1, 4, 0, 0, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 3, 1, 1, 1, 1, 0, 1, 1, 1, 0, 1],
        [0, 1, 2, 0, 0, 1, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 2, 3, 0, 1, 1, 1, 0, 0, 2, 1, 0],
        [1, 1, 2, 3, 1, 1, 1, 0, 1, 1, 2, 1, 1],
        [0, 1, 1, 3, 1, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 1, 0, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 0, 3, 2, 1, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 0, 4, 0, 1, 1, 0, 0, 0, 3, 0, 0],
        [0, 1, 0, 3, 2, 0, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 1, 1, 0, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 2, 3, 0, 1, 0, 1, 1, 0, 1, 1, 0, 0],
        [1, 1, 3, 3, 2, 1, 1, 0, 1, 0, 0, 1, 0],
        [0, 1, 1, 1, 1, 0, 1, 0, 0, 0, 1, 1, 1],
        [0, 1, 2, 3, 1, 0, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 2, 0, 1, 1, 1, 0, 1, 0, 0, 0, 0],
        [0, 1, 0, 4, 0, 1, 1, 0, 0, 0, 2, 0, 0],
        [1, 1, 1, 3, 2, 1, 1, 0, 0, 1, 0, 1, 0],
        [0, 1, 1, 1, 2, 0, 2, 0, 1, 1, 0, 1, 0],
        [0, 1, 0, 1, 0, 0, 1, 0, 0, 1, 2, 0, 0],
        [0, 1, 1, 1, 0, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 1, 3, 1, 0, 2, 0, 0, 1, 1, 0, 0],
        [0, 1, 3, 3, 3, 0, 1, 0, 1, 1, 0, 0, 0],
        [0, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0],
        [1, 0, 2, 3, 1, 1, 1, 0, 1, 0, 2, 0, 1],
        [1, 1, 1, 0, 1, 1, 1, 0, 0, 1, 3, 0, 1],
        [1, 1, 0, 3, 2, 0, 1, 0, 1, 1, 2, 1, 0],
        [1, 1, 0, 2, 0, 0, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 1, 4, 1, 0, 1, 0, 0, 1, 1, 1, 1],
        [0, 1, 1, 4, 0, 1, 1, 0, 1, 0, 1, 1, 0],
        [1, 1, 0, 2, 2, 0, 1, 0, 0, 1, 2, 0, 0],
        [0, 1, 3, 1, 0, 0, 1, 0, 0, 1, 0, 1, 0],
        [0, 1, 2, 5, 1, 0, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 0, 4, 2, 1, 1, 0, 0, 1, 2, 0, 0],
        [0, 1, 1, 3, 1, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 1, 3, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 2, 4, 3, 1, 1, 0, 1, 1, 2, 0, 1],
        [1, 1, 2, 5, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 3, 5, 3, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 1, 4, 3, 0, 1, 0, 1, 1, 2, 0, 0],
        [1, 1, 2, 4, 1, 1, 1, 0, 1, 1, 0, 0, 0],
        [1, 1, 3, 3, 1, 0, 1, 0, 0, 0, 0, 0, 0],
        [0, 1, 0, 1, 2, 0, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 0, 1, 1, 0, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 0, 3, 3, 1, 1, 0, 1, 0, 0, 1, 0],
        [1, 1, 1, 4, 1, 0, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 1, 3, 1, 1, 1, 0, 1, 0, 1, 1, 0],
        [0, 1, 1, 5, 2, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 3, 4, 0, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 1, 2, 1, 0, 1, 0, 0, 0, 1, 1, 1],
        [1, 1, 2, 3, 2, 1, 1, 0, 1, 1, 1, 1, 1],
        [1, 1, 1, 4, 3, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 0, 1, 1, 0, 1, 1, 1, 1, 1, 0, 0],
        [1, 1, 1, 4, 3, 1, 2, 0, 1, 0, 1, 1, 1],
        [0, 1, 2, 1, 1, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 1, 1, 0, 1, 1, 0, 1, 1, 0, 1, 0],
        [0, 1, 1, 4, 0, 1, 1, 0, 0, 1, 2, 1, 0],
        [0, 1, 2, 4, 1, 1, 1, 0, 0, 1, 1, 1, 1],
        [0, 1, 1, 3, 1, 1, 1, 0, 1, 0, 1, 1, 0],
        [1, 1, 2, 1, 3, 0, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 1, 0, 1, 0, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 2, 3, 1, 1, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 1, 1, 2, 0, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 2, 3, 2, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 2, 4, 0, 0, 1, 0, 1, 1, 1, 0, 0],
        [1, 1, 0, 4, 0, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 0, 5, 1, 1, 1, 0, 0, 0, 2, 0, 0],
        [1, 1, 0, 1, 1, 1, 2, 0, 1, 1, 1, 1, 1],
        [1, 1, 2, 3, 1, 0, 1, 0, 1, 1, 3, 0, 0],
        [0, 1, 2, 3, 2, 0, 1, 0, 0, 0, 0, 0, 0],
        [0, 1, 3, 3, 2, 1, 1, 0, 0, 1, 2, 1, 0],
        [1, 1, 0, 3, 1, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 1, 4, 1, 0, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 3, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1],
        [0, 0, 2, 2, 0, 1, 1, 0, 0, 0, 0, 1, 1],
        [0, 1, 0, 4, 3, 0, 2, 0, 1, 0, 2, 1, 0],
        [0, 1, 3, 0, 1, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 2, 5, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 0, 4, 1, 1, 1, 0, 0, 0, 3, 1, 0],
        [0, 1, 1, 3, 2, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 1, 5, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 3, 0, 1, 0, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 1, 3, 3, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 2, 0, 1, 1, 1, 0, 1, 0, 1, 1, 0],
        [1, 1, 3, 3, 0, 1, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 2, 1, 1, 1, 1, 0, 1, 0, 0, 0, 1],
        [1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1],
        [0, 1, 1, 1, 0, 1, 1, 0, 1, 1, 3, 0, 0],
        [0, 1, 0, 5, 2, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 1, 4, 1, 1, 1, 0, 0, 0, 1, 1, 1],
        [1, 1, 1, 0, 2, 0, 1, 0, 0, 0, 0, 0, 0],
        [0, 1, 1, 4, 2, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 0, 4, 3, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 0, 0, 2, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 2, 2, 2, 1, 1, 1, 0, 1, 1, 1, 1],
        [0, 1, 2, 1, 1, 1, 1, 0, 0, 0, 3, 1, 0],
        [1, 1, 0, 1, 3, 1, 1, 0, 1, 0, 2, 0, 0],
        [0, 1, 1, 3, 0, 0, 1, 0, 1, 0, 1, 1, 0],
        [1, 0, 0, 0, 3, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 0, 1, 1, 1, 1, 0, 1, 0, 1, 1, 0],
        [1, 2, 1, 1, 0, 1, 1, 0, 1, 1, 0, 0, 0],
        [0, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1],
        [0, 1, 0, 5, 2, 1, 1, 0, 1, 1, 1, 1, 1],
        [1, 1, 2, 4, 0, 0, 1, 0, 0, 1, 3, 1, 1],
        [1, 1, 2, 1, 2, 0, 1, 1, 0, 0, 0, 0, 1],
        [0, 1, 1, 0, 2, 1, 1, 0, 0, 0, 1, 1, 1],
        [0, 1, 0, 4, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 3, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1],
        [1, 1, 3, 4, 2, 1, 2, 0, 0, 0, 0, 0, 1],
        [1, 1, 1, 3, 2, 1, 1, 0, 1, 0, 1, 1, 1],
        [0, 1, 0, 0, 2, 0, 1, 0, 0, 1, 0, 1, 0],
        [0, 1, 0, 3, 3, 1, 1, 0, 1, 1, 1, 1, 1],
        [1, 1, 2, 3, 2, 1, 1, 0, 1, 1, 3, 1, 1],
        [1, 1, 2, 5, 1, 0, 1, 0, 0, 1, 1, 0, 1],
        [1, 1, 0, 4, 1, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 1, 4, 2, 1, 1, 0, 0, 0, 2, 0, 0],
        [1, 1, 0, 3, 3, 0, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 2, 4, 0, 1, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 1, 3, 1, 0, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 2, 3, 3, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 1, 3, 3, 0, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 3, 4, 1, 1, 1, 0, 1, 1, 3, 0, 1],
        [1, 1, 0, 1, 3, 1, 1, 0, 1, 1, 1, 0, 1],
        [0, 1, 2, 3, 0, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 2, 0, 1, 1, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 3, 4, 1, 1, 1, 0, 0, 0, 0, 1, 1],
        [0, 1, 3, 0, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 1, 1, 2, 1, 2, 0, 1, 1, 1, 1, 1],
        [1, 1, 2, 3, 3, 0, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 2, 3, 1, 1, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 3, 1, 3, 0, 1, 1, 0, 0, 3, 0, 0],
        [0, 1, 1, 2, 0, 1, 1, 0, 1, 1, 2, 1, 0],
        [0, 1, 2, 3, 3, 1, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 1, 3, 1, 0, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 2, 3, 1, 1, 1, 0, 0, 0, 0, 0, 1],
        [1, 2, 2, 5, 3, 1, 2, 0, 0, 0, 1, 1, 0],
        [1, 0, 2, 3, 1, 1, 1, 0, 0, 0, 1, 1, 1],
        [0, 1, 3, 3, 0, 1, 1, 0, 0, 0, 2, 0, 0],
        [0, 1, 0, 4, 2, 0, 1, 0, 0, 1, 0, 1, 1],
        [1, 1, 0, 3, 3, 0, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 2, 3, 2, 1, 1, 0, 0, 0, 2, 0, 0],
        [0, 1, 2, 2, 1, 1, 1, 0, 0, 1, 2, 1, 0],
        [1, 1, 3, 4, 1, 1, 1, 0, 1, 0, 1, 1, 1],
        [0, 1, 0, 3, 1, 1, 1, 0, 1, 0, 2, 0, 0],
        [1, 1, 3, 2, 2, 1, 1, 0, 1, 1, 1, 1, 1],
        [1, 1, 0, 2, 3, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 2, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1],
        [1, 1, 2, 5, 3, 0, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 1, 3, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 2, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 0, 5, 0, 0, 2, 0, 0, 1, 3, 1, 0],
        [0, 1, 1, 4, 2, 1, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 1, 4, 1, 0, 1, 0, 0, 0, 2, 1, 0],
        [1, 2, 2, 3, 2, 0, 1, 0, 0, 1, 0, 1, 0],
        [0, 1, 2, 1, 3, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 0, 2, 3, 0, 1, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 1, 1, 3, 1, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 2, 4, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 2, 1, 3, 1, 1, 0, 1, 0, 2, 0, 1],
        [0, 1, 2, 0, 1, 0, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 0, 4, 1, 0, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 1, 3, 2, 0, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 0, 3, 3, 1, 1, 0, 1, 1, 0, 1, 1],
        [0, 0, 1, 4, 2, 1, 1, 0, 0, 0, 1, 1, 1],
        [0, 1, 3, 2, 3, 0, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 1, 3, 3, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 1, 4, 1, 1, 1, 0, 0, 1, 1, 1, 1],
        [0, 1, 0, 0, 3, 1, 1, 0, 1, 0, 0, 1, 1],
        [1, 1, 0, 2, 3, 0, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 2, 0, 2, 1, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 2, 1, 2, 1, 2, 0, 0, 0, 1, 0, 1],
        [1, 1, 1, 3, 0, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 1, 4, 1, 1, 1, 0, 0, 0, 1, 0, 1],
        [0, 1, 0, 4, 3, 0, 1, 0, 0, 1, 2, 1, 0],
        [1, 1, 0, 3, 1, 0, 2, 0, 1, 1, 0, 1, 0],
        [1, 1, 3, 1, 2, 0, 1, 0, 0, 1, 0, 0, 1],
        [0, 1, 3, 5, 1, 1, 1, 0, 1, 0, 1, 1, 0],
        [0, 1, 0, 2, 1, 1, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 0, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1],
        [0, 1, 3, 3, 1, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 3, 3, 3, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 3, 2, 0, 1, 1, 0, 1, 0, 2, 0, 0],
        [0, 1, 0, 4, 1, 1, 2, 0, 1, 0, 1, 0, 0],
        [0, 1, 0, 3, 1, 0, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 1, 3, 1, 1, 1, 0, 1, 0, 2, 0, 0],
        [1, 1, 1, 5, 1, 1, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 2, 3, 3, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 1, 3, 0, 1, 2, 0, 1, 0, 1, 0, 0],
        [0, 1, 2, 3, 1, 0, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 0, 1, 0, 0, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 3, 3, 3, 1, 2, 0, 0, 1, 0, 0, 0],
        [0, 1, 2, 3, 0, 1, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 2, 2, 1, 1, 1, 0, 0, 1, 0, 1, 0],
        [0, 1, 0, 1, 1, 1, 1, 0, 0, 0, 2, 1, 0],
        [1, 2, 1, 4, 1, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 2, 4, 3, 0, 1, 0, 0, 1, 0, 1, 0],
        [0, 1, 2, 3, 1, 1, 1, 0, 1, 0, 0, 0, 0],
        [0, 1, 0, 3, 3, 1, 1, 0, 1, 1, 0, 0, 0],
        [0, 1, 3, 3, 2, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1],
        [1, 1, 2, 4, 3, 0, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 0, 4, 2, 1, 1, 0, 1, 0, 2, 1, 0],
        [0, 1, 2, 1, 3, 0, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 3, 1, 1, 0, 1, 0, 1, 0, 2, 0, 1],
        [1, 1, 2, 4, 1, 1, 1, 0, 0, 1, 2, 1, 0],
        [1, 1, 1, 3, 2, 1, 1, 0, 0, 1, 2, 1, 0],
        [1, 1, 1, 0, 0, 0, 1, 0, 1, 0, 2, 1, 0],
        [1, 1, 2, 1, 0, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 3, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 0, 3, 1, 0, 1, 1, 0, 1, 2, 1, 0],
        [1, 1, 3, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1],
        [1, 1, 2, 1, 3, 1, 1, 0, 0, 1, 3, 1, 0],
        [0, 1, 2, 4, 3, 1, 2, 0, 1, 0, 2, 1, 1],
        [0, 1, 1, 3, 1, 0, 1, 0, 0, 1, 1, 1, 0],
        [0, 2, 0, 1, 0, 0, 1, 0, 0, 0, 2, 0, 0],
        [1, 1, 3, 3, 1, 0, 1, 0, 1, 0, 1, 0, 0],
        [0, 1, 2, 3, 1, 1, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 1, 5, 2, 1, 1, 0, 1, 1, 0, 0, 1],
        [0, 1, 3, 4, 1, 0, 1, 0, 1, 0, 3, 0, 0],
        [1, 1, 0, 2, 2, 1, 2, 0, 0, 0, 1, 1, 1],
        [0, 1, 1, 1, 0, 1, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 3, 1, 3, 0, 1, 0, 1, 1, 0, 0, 1],
        [0, 1, 2, 3, 0, 1, 1, 0, 0, 1, 0, 1, 1],
        [0, 1, 2, 2, 3, 1, 1, 0, 1, 0, 1, 0, 0],
        [0, 1, 2, 4, 3, 0, 1, 0, 1, 0, 1, 1, 0],
        [0, 1, 2, 3, 3, 0, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 2, 2, 1, 1, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 2, 4, 0, 0, 1, 0, 0, 1, 0, 1, 1],
        [0, 1, 2, 3, 2, 1, 1, 0, 1, 0, 1, 1, 1],
        [0, 1, 3, 3, 1, 1, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 2, 4, 3, 1, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 2, 3, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 0, 3, 1, 1, 1, 0, 1, 1, 1, 0, 0],
        [0, 1, 2, 4, 0, 1, 1, 0, 1, 0, 0, 0, 0],
        [1, 1, 1, 3, 1, 1, 1, 0, 0, 0, 0, 1, 0],
        [0, 2, 0, 1, 0, 1, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 1, 3, 2, 1, 1, 0, 0, 0, 0, 1, 0],
        [0, 2, 1, 4, 0, 1, 1, 0, 0, 0, 2, 0, 0],
        [0, 1, 0, 1, 3, 0, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 1, 1, 2, 1, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 3, 4, 2, 1, 1, 0, 0, 1, 1, 0, 1],
        [0, 2, 2, 4, 3, 0, 1, 0, 1, 0, 2, 1, 0],
        [0, 1, 2, 3, 3, 0, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 0, 1, 2, 0, 1, 1, 0, 1, 1, 0, 0],
        [0, 1, 2, 3, 1, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 0, 3, 2, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 3, 4, 2, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 1, 3, 1, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 0, 2, 4, 0, 1, 1, 0, 1, 0, 1, 0, 1],
        [0, 1, 2, 4, 1, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 0, 1, 0, 1, 1, 0, 1, 0, 1, 1, 1],
        [1, 1, 2, 1, 2, 1, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 1, 4, 1, 1, 2, 0, 0, 0, 1, 1, 0],
        [1, 1, 1, 1, 0, 1, 1, 0, 1, 1, 2, 1, 1],
        [1, 1, 2, 3, 2, 0, 1, 0, 0, 1, 1, 1, 0],
        [0, 2, 1, 4, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 0, 2, 5, 3, 1, 1, 0, 0, 1, 2, 0, 1],
        [1, 1, 0, 4, 2, 0, 1, 0, 0, 1, 2, 0, 1],
        [0, 1, 3, 4, 1, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 1, 2, 3, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 3, 3, 1, 1, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 1, 5, 1, 0, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 3, 5, 1, 0, 1, 0, 1, 0, 2, 0, 0],
        [0, 0, 2, 2, 3, 1, 1, 0, 0, 0, 2, 0, 1],
        [0, 1, 2, 3, 1, 0, 1, 0, 0, 1, 3, 0, 0],
        [0, 1, 0, 0, 2, 1, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 0, 1, 1, 0, 1, 0, 1, 1, 3, 1, 1],
        [1, 1, 2, 4, 1, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 0, 3, 0, 0, 1, 0, 1, 1, 1, 0, 1],
        [1, 1, 3, 3, 3, 1, 0, 0, 0, 1, 1, 0, 0],
        [0, 2, 3, 4, 2, 1, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 1, 4, 1, 0, 1, 0, 0, 1, 3, 1, 0],
        [1, 1, 3, 3, 0, 1, 1, 0, 0, 0, 2, 0, 0],
        [0, 1, 3, 4, 0, 1, 1, 0, 1, 1, 1, 1, 1],
        [1, 1, 2, 3, 1, 0, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 2, 0, 2, 0, 2, 0, 0, 1, 0, 0, 0],
        [0, 1, 1, 3, 1, 1, 1, 0, 1, 0, 1, 0, 0],
        [0, 1, 3, 3, 1, 0, 1, 0, 0, 1, 1, 0, 0],
        [0, 2, 0, 4, 1, 1, 1, 0, 1, 1, 1, 1, 0],
        [0, 1, 0, 4, 3, 1, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 2, 4, 0, 1, 1, 0, 1, 0, 0, 1, 0],
        [1, 1, 2, 1, 2, 0, 1, 0, 1, 0, 3, 0, 0],
        [1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 3, 5, 0, 1, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 2, 4, 1, 0, 1, 0, 1, 1, 1, 0, 0],
        [1, 1, 3, 3, 2, 1, 1, 0, 0, 1, 1, 1, 1],
        [1, 0, 3, 4, 0, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 0, 3, 0, 2, 1, 1, 0, 0, 0, 1, 0, 1],
        [1, 2, 1, 4, 1, 0, 1, 1, 1, 0, 1, 0, 0],
        [1, 1, 3, 3, 1, 1, 1, 0, 1, 1, 1, 1, 1],
        [0, 1, 0, 3, 1, 1, 1, 0, 1, 1, 1, 0, 0],
        [1, 1, 2, 3, 1, 0, 1, 0, 0, 0, 1, 0, 1],
        [1, 0, 2, 4, 2, 1, 1, 0, 1, 0, 0, 0, 1],
        [1, 1, 1, 4, 1, 1, 1, 0, 1, 1, 0, 1, 0],
        [0, 1, 0, 4, 2, 1, 0, 0, 0, 0, 2, 0, 1],
        [0, 1, 0, 4, 2, 1, 1, 0, 1, 1, 3, 1, 1],
        [1, 1, 3, 4, 0, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 3, 3, 0, 1, 1, 0, 0, 1, 2, 1, 0],
        [1, 1, 1, 3, 1, 0, 1, 0, 0, 1, 2, 1, 0],
        [1, 1, 3, 1, 2, 0, 1, 0, 1, 1, 0, 1, 0],
        [0, 1, 2, 4, 2, 1, 2, 0, 1, 0, 1, 1, 1],
        [0, 1, 2, 3, 1, 1, 1, 0, 0, 1, 2, 1, 0],
        [1, 1, 2, 5, 3, 1, 1, 0, 1, 1, 1, 1, 1],
        [1, 1, 1, 5, 1, 1, 1, 0, 1, 0, 1, 0, 0],
        [0, 1, 2, 0, 2, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 2, 0, 4, 3, 0, 1, 0, 0, 0, 3, 0, 0],
        [1, 1, 0, 3, 1, 1, 1, 0, 0, 0, 2, 1, 1],
        [0, 1, 0, 3, 0, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 2, 0, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 2, 1, 3, 3, 1, 1, 0, 1, 1, 1, 1, 0],
        [1, 1, 0, 3, 3, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 0, 2, 4, 1, 0, 1, 0, 1, 0, 0, 0, 1],
        [1, 1, 3, 1, 2, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 3, 3, 1, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 0, 3, 1, 1, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 0, 1, 3, 1, 1, 0, 1, 0, 2, 0, 0],
        [0, 1, 1, 5, 0, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 1, 5, 1, 1, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 2, 5, 0, 0, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 3, 0, 2, 0, 1, 0, 1, 0, 3, 0, 0],
        [1, 1, 3, 1, 1, 0, 1, 0, 0, 0, 3, 1, 0],
        [0, 1, 2, 4, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 0, 4, 1, 1, 1, 0, 1, 0, 2, 1, 0],
        [1, 0, 2, 3, 0, 0, 1, 0, 0, 0, 1, 0, 1],
        [0, 1, 1, 4, 1, 0, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 3, 3, 1, 1, 1, 0, 0, 1, 1, 1, 1],
        [1, 2, 0, 3, 3, 0, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 2, 2, 1, 0, 1, 0, 1, 0, 0, 0, 0],
        [0, 1, 2, 0, 2, 1, 1, 0, 1, 0, 0, 1, 0],
        [0, 1, 2, 1, 2, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 3, 5, 2, 0, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 1, 1, 2, 1, 1, 0, 0, 0, 2, 0, 1],
        [1, 1, 2, 1, 1, 1, 2, 0, 1, 0, 2, 1, 1],
        [0, 1, 0, 4, 2, 1, 1, 0, 0, 0, 3, 1, 1],
        [1, 0, 1, 2, 0, 1, 1, 0, 0, 1, 1, 0, 1],
        [1, 1, 3, 1, 3, 0, 1, 0, 1, 1, 0, 0, 0],
        [1, 1, 3, 4, 1, 1, 1, 0, 0, 1, 0, 1, 0],
        [0, 1, 1, 3, 2, 1, 1, 0, 1, 0, 1, 0, 0],
        [1, 1, 0, 3, 0, 1, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 0, 3, 2, 1, 1, 0, 0, 1, 2, 1, 0],
        [0, 1, 3, 3, 2, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 2, 1, 1, 1, 1, 0, 0, 1, 2, 1, 1],
        [0, 1, 0, 3, 1, 1, 1, 0, 0, 1, 0, 1, 0],
        [0, 1, 3, 4, 0, 1, 1, 1, 0, 0, 0, 1, 1],
        [1, 1, 1, 3, 1, 0, 1, 0, 1, 0, 1, 0, 0],
        [1, 2, 2, 3, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 0, 3, 3, 0, 1, 1, 0, 1, 1, 0, 0],
        [0, 1, 2, 4, 1, 1, 1, 0, 1, 0, 1, 1, 1],
        [1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 3, 0, 2, 1, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 0, 0, 3, 1, 1, 0, 0, 1, 2, 0, 0],
        [0, 1, 0, 3, 2, 1, 1, 0, 0, 1, 2, 1, 0],
        [1, 1, 2, 3, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 0, 3, 2, 0, 1, 0, 0, 1, 3, 1, 0],
        [0, 1, 1, 2, 2, 1, 1, 0, 1, 0, 0, 0, 0],
        [1, 1, 3, 0, 1, 1, 1, 0, 0, 0, 1, 1, 1],
        [1, 1, 2, 3, 2, 1, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 2, 1, 2, 0, 1, 0, 0, 1, 2, 0, 1],
        [1, 1, 0, 3, 1, 1, 1, 0, 0, 0, 0, 0, 0],
        [0, 1, 2, 4, 2, 0, 1, 0, 0, 1, 1, 0, 1],
        [0, 1, 0, 3, 2, 0, 0, 0, 1, 0, 1, 1, 1],
        [0, 1, 2, 4, 3, 1, 1, 1, 0, 0, 1, 0, 0],
        [1, 1, 3, 2, 2, 0, 1, 0, 1, 1, 2, 0, 1],
        [1, 1, 2, 4, 0, 1, 2, 0, 0, 0, 1, 1, 1],
        [1, 1, 2, 4, 3, 1, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 3, 0, 1],
        [1, 1, 2, 3, 1, 1, 1, 0, 1, 0, 1, 1, 0],
        [1, 1, 1, 3, 3, 0, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 0, 3, 1, 1, 1, 1, 0, 0, 1, 1, 1],
        [0, 1, 2, 3, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 2, 0, 3, 1, 1, 0, 1, 0, 2, 0, 0],
        [1, 1, 2, 5, 1, 0, 1, 0, 0, 1, 0, 1, 0],
        [1, 2, 3, 4, 3, 1, 1, 0, 0, 0, 3, 0, 0],
        [0, 1, 2, 1, 3, 1, 1, 0, 0, 1, 1, 1, 1],
        [0, 1, 3, 2, 1, 1, 2, 0, 0, 1, 2, 1, 0],
        [1, 1, 2, 3, 3, 0, 1, 0, 1, 0, 0, 1, 0],
        [0, 1, 1, 3, 2, 0, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 2, 2, 3, 0, 1, 0, 0, 1, 3, 1, 0],
        [1, 1, 2, 4, 1, 1, 1, 0, 0, 1, 1, 0, 1],
        [0, 1, 3, 4, 0, 0, 1, 0, 1, 0, 1, 1, 0],
        [1, 1, 3, 4, 0, 1, 1, 0, 1, 1, 1, 1, 1],
        [1, 1, 2, 4, 2, 1, 1, 0, 1, 0, 1, 0, 1],
        [1, 1, 2, 3, 1, 1, 1, 0, 1, 0, 0, 1, 0],
        [1, 1, 2, 4, 3, 1, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 0, 3, 1, 1, 1, 0, 1, 1, 1, 1, 0],
        [1, 1, 2, 2, 1, 1, 1, 0, 1, 1, 3, 1, 1],
        [0, 1, 0, 4, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 2, 3, 1, 0, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 3, 1, 2, 0, 1, 0, 0, 1, 1, 0, 1],
        [1, 1, 0, 3, 1, 1, 1, 0, 0, 1, 0, 0, 1],
        [0, 1, 1, 1, 0, 0, 1, 0, 1, 1, 0, 1, 1],
        [0, 1, 1, 4, 1, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 0, 3, 1, 0, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 0, 4, 1, 0, 1, 0, 0, 1, 0, 0, 1],
        [0, 1, 0, 1, 2, 1, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 1, 4, 3, 1, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 2, 3, 1, 0, 1, 0, 1, 0, 0, 0, 0],
        [1, 1, 2, 3, 2, 0, 1, 0, 0, 0, 2, 0, 1],
        [0, 1, 3, 0, 3, 1, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 2, 4, 2, 0, 1, 1, 0, 0, 3, 0, 0],
        [1, 1, 2, 4, 1, 1, 1, 0, 0, 0, 0, 1, 0],
        [0, 0, 3, 0, 3, 1, 1, 0, -1, 0, 1, 1, 0],
        [1, 1, 1, 3, 0, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 0, 4, 1, 1, 1, 0, 1, 1, 2, 0, 0],
        [1, 1, 0, 3, 1, 1, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 3, 3, 1, 0, 1, 0, 1, 0, 2, 0, 0],
        [1, 1, 2, 0, 2, 0, 1, 0, 1, 1, 1, 1, 1],
        [1, 2, 1, 3, 2, 1, 1, 0, 1, 0, 2, 1, 0],
        [1, 1, 1, 3, 1, 0, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 1, 4, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 2, 3, 0, 1, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 1, 4, 2, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 2, 3, 1, 1, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 1, 4, 1, 0, 1, 0, 1, 0, 1, 1, 1],
        [1, 1, 2, 3, 3, 1, 1, 0, 1, 0, 0, 1, 1],
        [1, 1, 1, 0, 1, 1, 1, 0, 0, 1, 1, 1, 1],
        [0, 1, 3, 1, 2, 1, 2, 0, 0, 0, 0, 0, 1],
        [0, 1, 3, 5, 2, 1, 1, 0, 1, 1, 1, 1, 1],
        [0, 1, 3, 4, 1, 1, 1, 0, 0, 0, 1, 1, 1],
        [1, 1, 3, 0, 3, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 2, 4, 1, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 0, 1, 1, 1, 1, 0, 0, 0, 2, 0, 0],
        [1, 1, 2, 1, 0, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 1, 3, 1, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 0, 3, 3, 2, 0, 1, 0, 0, 1, 2, 1, 0],
        [1, 1, 0, 5, 1, 1, 1, 0, 0, 0, 1, 1, 1],
        [1, 1, 2, 5, 0, 1, 1, 0, 0, 1, 3, 1, 1],
        [0, 1, 0, 1, 2, 1, 1, 0, 0, 0, 1, 1, 1],
        [0, 0, 2, 1, 3, 0, 1, 0, 0, 1, 2, 1, 1],
        [1, 1, 0, 3, 1, 1, 1, 0, 0, 0, 3, 0, 0],
        [1, 1, 2, 3, 1, 0, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 3, 4, 3, 1, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 2, 4, 0, 1, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 3, 5, 1, 0, 2, 0, 0, 1, 1, 0, 0],
        [1, 1, 0, 1, 2, 1, 1, 0, 0, 0, 3, 0, 1],
        [1, 2, 0, 0, 1, 0, 1, 0, 0, 1, 2, 1, 0],
        [1, 1, 1, 1, 2, 1, 1, 0, 0, 0, 1, 1, 1],
        [0, 1, 3, 3, 0, 1, 0, 0, 0, 0, 1, 0, 0],
        [1, 1, 2, 3, 0, 1, 1, 0, 0, 0, 1, 1, 1],
        [1, 1, 0, 4, 3, 1, 1, 0, 0, 1, 2, 1, 1],
        [1, 1, 2, 4, 1, 1, 1, 0, 1, 1, 2, 0, 1],
        [0, 1, 2, 1, 2, 1, 1, 0, 0, 0, 2, 1, 1],
        [1, 1, 3, 2, 1, 0, 1, 0, 0, 0, 1, 1, 1],
        [1, 1, 3, 0, 2, 1, 1, 0, 0, 1, 0, 1, 1],
        [1, 1, 0, 1, 2, 1, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 3, 3, 1, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 2, 1, 3, 1, 0, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 0, 4, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 3, 2, 0, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 0, 4, 1, 0, 1, 0, 0, 1, 2, 1, 0],
        [0, 1, 3, 1, 2, 1, 1, 0, 0, 0, 1, 1, 1],
        [1, 1, 0, 4, 2, 0, 1, 0, 1, 0, 1, 1, 1],
        [1, 0, 3, 3, 1, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 2, 4, 1, 1, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 3, 4, 2, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 1, 3, 3, 0, 1, 0, 1, 0, 2, 0, 0],
        [1, 1, 0, 4, 2, 0, 1, 0, 0, 1, 2, 1, 0],
        [1, 1, 1, 1, 0, 1, 1, 0, 0, 1, 3, 1, 1],
        [1, 1, 2, 3, 0, 1, 1, 0, 0, 1, 1, 1, 1],
        [0, 1, 0, 4, 2, 0, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 1, 3, 2, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 2, 3, 3, 1, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 1, 3, 2, 1, 1, 0, 1, 1, 1, 1, 0],
        [1, 1, 0, 1, 3, 0, 1, 0, 0, 0, 1, 0, 1],
        [0, 1, 0, 3, 1, 0, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 0, 2, 1, 1, 1, 1, 1, 0, 1, 0, 0],
        [1, 1, 3, 4, 2, 1, 1, 0, 0, 1, 3, 1, 1],
        [1, 1, 0, 4, 3, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 3, 3, 1, 0, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 0, 3, 1, 0, 1, 0, 0, 0, 2, 0, 0],
        [0, 2, 0, 3, 1, 1, 1, 0, 0, 1, 2, 1, 0],
        [1, 1, 2, 5, 2, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 1, 4, 3, 1, 1, 0, 1, 1, 1, 1, 0],
        [1, 1, 0, 2, 2, 1, 1, 0, 0, 0, 0, 0, 1],
        [0, 1, 3, 3, 3, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 2, 4, 1, 1, 1, 0, 0, 1, 0, 0, 1],
        [1, 1, 3, 1, 1, 1, 1, 0, 0, 0, 2, 0, 1],
        [1, 1, 0, 4, 1, 0, 1, 0, 0, 0, 0, 0, 1],
        [0, 1, 2, 4, 3, 0, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 0, 1, 2, 0, 1, 0, 1, 1, 2, 1, 1],
        [1, 1, 2, 3, 1, 1, 1, 0, 1, 0, 1, 1, 1],
        [0, 1, 2, 3, 0, 1, 1, 0, 1, 0, 2, 1, 1],
        [1, 1, 1, 3, 2, 1, 1, 0, 0, 0, 3, 1, 0],
        [0, 1, 2, 4, 0, 1, 1, 0, 1, 0, 1, 1, 0],
        [1, 1, 0, 3, 3, 0, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 1, 4, 1, 1, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 0, 3, 2, 0, 1, 0, 1, 1, 0, 1, 0],
        [1, 1, 1, 5, 3, 0, 2, 0, 0, 0, 0, 1, 0],
        [0, 1, 2, 3, 2, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 3, 3, 1, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 3, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1],
        [1, 1, 2, 4, 3, 0, 1, 0, 0, 0, 0, 1, 1],
        [1, 1, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0],
        [1, 1, 2, 4, 0, 1, 1, 0, 1, 0, 1, 0, 0],
        [0, 1, 2, 4, 0, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 2, 3, 3, 1, 1, 0, 1, 0, 1, 0, 0],
        [0, 1, 0, 4, 1, 1, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 3, 3, 3, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 0, 5, 2, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 1, 3, 3, 0, 1, 0, 1, 0, 0, 0, 0],
        [0, 1, 0, 2, 1, 1, 1, 0, 0, 0, 1, 1, 1],
        [0, 1, 2, 1, 0, 1, 1, 0, 0, 1, 1, 1, 1],
        [0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 2, 4, 1, 0, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 0, 1, 0, 0, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 2, 0, 0, 1, 1, 0, 0, 1, 2, 0, 1],
        [1, 2, 3, 0, 2, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 0, 4, 1, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 0, 3, 3, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 1, 2, 1, 0, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 1, 3, 2, 0, 1, 1, 0, 0, 0, 0, 0],
        [1, 1, 2, 4, 0, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 0, 4, 3, 1, 1, 0, 0, 1, 0, 0, 1],
        [0, 1, 3, 5, 3, 0, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 2, 4, 1, 1, 0, 0, 1, 0, 1, 1, 1],
        [0, 1, 1, 4, 1, 1, 1, 0, 1, 1, 1, 0, 0],
        [1, 1, 2, 4, 2, 0, 1, 0, 0, 0, 0, 0, 1],
        [0, 1, 1, 3, 3, 0, 1, 0, 1, 0, 0, 1, 1],
        [0, 1, 2, 4, 1, 0, 1, 0, 0, 0, 2, 0, 0],
        [0, 1, 2, 0, 1, 1, 1, 0, 0, 1, 3, 0, 1],
        [0, 1, 2, 3, 3, 0, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 1, 3, 2, 1, 1, 0, 0, 0, 0, 0, 0],
        [0, 1, 0, 3, 1, 0, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 0, 3, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 0, 2, 1, 3, 1, 1, 0, 0, 0, 2, 1, 1],
        [0, 1, 2, 3, 2, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 3, 3, 2, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 2, 4, 3, 0, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 3, 4, 2, 1, 1, 0, 0, 1, 3, 1, 0],
        [1, 1, 2, 4, 3, 1, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 2, 3, 1, 1, 1, 0, 1, 0, 1, 0, 0],
        [0, 1, 2, 3, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 3, 3, 2, 1, 1, 0, 0, 1, 1, 0, 1],
        [1, 1, 1, 2, 1, 0, 1, 0, 1, 0, 0, 0, 1],
        [0, 1, 3, 4, 3, 1, 1, 0, 0, 1, 2, 1, 0],
        [1, 1, 3, 3, 2, 1, 1, 0, 0, 0, 3, 1, 0],
        [1, 1, 0, 3, 1, 1, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 3, 1, 2, 1, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 0, 5, 1, 1, 1, 1, 0, 0, 1, 1, 0],
        [0, 1, 2, 3, 2, 0, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 1, 1, 2, 1, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 1, 5, 1, 0, 1, 0, 0, 1, 3, 1, 0],
        [1, 1, 1, 3, 1, 1, 1, 0, 0, 0, 2, 0, 0],
        [0, 1, 2, 4, 1, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 0, 4, 1, 1, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 2, 1, 0, 0, 1, 0, 0, 1, 0, 1, 1],
        [0, 1, 3, 4, 1, 1, 2, 0, 1, 1, 0, 0, 0],
        [1, 1, 2, 3, 3, 1, 1, 0, 1, 0, 0, 1, 0],
        [0, 1, 1, 2, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 2, 3, 2, 1, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 0, 1, 3, 1, 2, 0, 0, 0, 1, 0, 0],
        [0, 1, 0, 3, 1, 1, 1, 0, 0, 1, 0, 1, 0],
        [0, 1, 1, 3, 3, 0, 1, 0, 1, 0, 1, 1, 0],
        [1, 1, 0, 2, 1, 1, 1, 0, 0, 1, 2, 0, 0],
        [0, 1, 0, 3, 1, 0, 1, 0, 1, 0, 0, 0, 0],
        [0, 1, 2, 4, 0, 1, 1, 0, 1, 0, 1, 1, 1],
        [0, 2, 2, 3, 3, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 0, 0, 2, 1, 1, 0, 0, 0, 1, 1, 1],
        [0, 1, 2, 0, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 2, 4, 0, 1, 1, 0, 1, 0, 1, 1, 1],
        [1, 1, 2, 1, 1, 0, 1, 0, 0, 0, 2, 0, 0],
        [0, 2, 1, 1, 3, 1, 1, 0, 0, 1, 2, 0, 0],
        [0, 1, 0, 3, 1, 0, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 3, 1, 2, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 3, 1, 2, 1, 1, 0, 0, 0, 1, 1, 1],
        [1, 1, 0, 3, 2, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 2, 4, 0, 1, 2, 1, 0, 0, 1, 1, 1],
        [0, 1, 1, 0, 2, -1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 0, 4, 3, 0, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 2, 2, 2, 1, 1, 1, 1, 1, 1, 0, 1],
        [1, 1, 0, 0, 0, 1, 1, 0, 0, 1, 0, 1, 1],
        [0, 2, 2, 4, 1, 1, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 2, 3, 1, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 2, 4, 0, 0, 1, 0, 0, 0, 0, 0, 1],
        [0, 1, 1, 3, 1, 1, 1, 0, 0, 0, 3, 0, 0],
        [0, 1, 0, 2, 1, 1, 1, 0, 1, 0, 0, 1, 0],
        [1, 1, 2, 3, 0, 0, 1, 1, 0, 0, 0, 1, 0],
        [0, 1, 3, 3, 1, 0, 1, 0, 0, 0, 3, 0, 0],
        [1, 1, 1, 2, 3, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 3, 1, 1, 0, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 0, 3, 0, 0, 1, 0, 1, 1, 0, 1, 0],
        [0, 1, 3, 0, 2, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 0, 4, 1, 1, 1, 0, 1, 0, 0, 1, 0],
        [0, 1, 1, 3, 0, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 2, 5, 2, 1, 1, 0, 1, 1, 2, 0, 1],
        [1, 1, 2, 1, 1, 1, 1, 0, 0, 1, 2, 0, 0],
        [0, 1, 2, 4, 1, 0, 1, 0, 0, 0, 1, 0, 0],
        [0, 2, 0, 4, 3, 1, 1, 0, 1, 0, 0, 0, 1],
        [0, 1, 1, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 1, 4, 2, 1, 1, 0, 0, 1, 0, 0, 1],
        [0, 1, 0, 3, 0, 1, 1, 0, 1, 1, 1, 0, 1],
        [0, 1, 3, 1, 2, 0, 2, 0, 0, 1, 0, 0, 0],
        [1, 1, 0, 3, 2, 0, 1, 1, 1, 0, 0, 1, 1],
        [0, 1, 0, 4, 1, 1, 1, 0, 0, 1, 0, 1, 0],
        [0, 1, 3, 4, 3, 0, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 2, 3, 2, 1, 1, 0, 1, 1, 1, 0, 0],
        [1, 1, 2, 3, 1, 1, 1, 0, 0, 0, 2, 0, 0],
        [1, 1, 1, 3, 2, 1, 1, 0, 1, 1, 2, 1, 0],
        [0, 2, 1, 4, 3, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 1, 4, 1, 1, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 1, 0, 1, 1, 1, 0, 0, 0, 3, 0, 0],
        [1, 1, 1, 5, 2, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 0, 0, 4, 0, 1, 1, 0, 1, 1, 1, 0, 1],
        [1, 1, 1, 3, 1, 0, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 0, 4, 3, 1, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 0, 2, 2, 0, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 0, 4, 3, 1, 1, 0, 0, 0, 2, 1, 1],
        [0, 1, 0, 3, 0, 0, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 2, 3, 0, 0, 1, 0, 0, 0, 2, 0, 0],
        [0, 1, 0, 0, 0, 1, 1, 0, 1, 1, 1, 0, 0],
        [1, 1, 1, 1, 2, 0, 1, 0, 1, 0, 3, 0, 0],
        [1, 1, 0, 2, 0, 1, 1, 0, 1, 0, 1, 0, 0],
        [1, 1, 2, 0, 2, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 3, 0, 1, 0, 1, 0, 1, 1, 1, 0, 0],
        [0, 1, 1, 4, 2, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 1, 4, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 2, 2, 5, 1, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 1, 3, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 2, 5, 2, 1, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 3, 3, 1, 0, 1, 0, 1, 1, 1, 0, 0],
        [0, 1, 2, 3, 0, 1, 0, 0, 0, 1, 0, 1, 1],
        [1, 1, 3, 2, 3, 1, 1, 0, 1, 1, 2, 1, 0],
        [0, 1, 0, 3, 2, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 1, 4, 2, 1, 1, 0, 1, 0, 1, 1, 1],
        [0, 1, 2, 3, 1, 1, 1, 0, 0, 1, 2, 0, 0],
        [0, 1, 1, 4, 1, 0, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 1, 1, 2, 1, 1, 0, 1, 0, 0, 1, 1],
        [1, 1, 2, 3, 0, 1, 1, 0, 1, 1, 3, 0, 0],
        [0, 1, 1, 1, 1, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 2, 1, 1, 1, 1, 0, 1, 1, 0, 0, 1],
        [1, 1, 0, 4, 0, 1, 1, 0, 0, 0, 3, 0, 0],
        [0, 1, 0, 1, 0, 0, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 1, 4, 3, 1, 1, 0, 1, 1, 0, 0, 0],
        [0, 1, 2, 2, 0, 1, 1, 1, 1, 1, 1, 0, 1],
        [0, 1, 0, 0, 1, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 2, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 1, 5, 1, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 0, 3, 3, 1, 1, 0, 0, 1, 1, 0, 1],
        [1, 1, 1, 2, 3, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 1, 3, 3, 1, 1, 0, 1, 0, 2, 0, 0],
        [1, 2, 2, 2, 1, 0, 1, 0, 1, 1, 0, 0, 0],
        [1, 1, 0, 1, 0, 1, 1, 0, 0, 0, 1, 1, 1],
        [1, 1, 0, 0, 3, 1, 1, 0, 0, 1, 3, 1, 1],
        [1, 1, 0, 3, 0, 0, 1, 0, 1, 1, 2, 0, 0],
        [1, 1, 0, 3, 0, 0, 2, 0, 0, 1, 1, 0, 0],
        [1, 1, 2, 3, 3, 1, 1, 0, 1, 0, 2, 1, 0],
        [1, 1, 2, 1, 1, 0, 1, 0, 0, 1, 3, 0, 0],
        [0, 1, 3, 4, 0, 0, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 2, 4, 2, 1, 1, 0, 1, 0, 0, 1, 1],
        [0, 1, 3, 3, 2, 1, 1, 0, 0, 1, 2, 1, 1],
        [0, 1, 0, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 0, 4, 2, 0, 1, 0, 0, 0, 2, 0, 1],
        [1, 1, 0, 3, 3, 0, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 1, 4, 3, 1, 1, 0, 1, 0, 2, 1, 0],
        [1, 1, 1, 4, 2, 0, 1, 0, 0, 0, 1, 0, 1],
        [0, 1, 1, 2, 1, 0, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 0, 3, 1, 0, 1, 0, 1, 0, 2, 1, 0],
        [0, 1, 2, 1, 0, 1, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 3, 3, 0, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 0, 1, 3, 3, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1],
        [1, 1, 1, 0, 3, 1, 1, 0, 1, 0, 1, 0, 0],
        [1, 1, 2, 1, 3, 1, 1, 0, 0, 0, 0, 0, 0],
        [0, 1, 2, 1, 1, 1, 1, 0, 0, 0, 2, 0, 0],
        [0, 1, 2, 4, 0, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 2, 4, 1, 1, 1, 0, 1, 0, 1, 1, 1],
        [0, 1, 2, 2, 2, 0, 1, 0, 0, 0, 2, 0, 1],
        [0, 1, 1, 1, 2, 1, 1, 0, 1, 0, 1, 0, 1],
        [1, 1, 0, 5, 1, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 1, 4, 1, 1, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 0, 3, 0, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 2, 3, 1, 1, 1, 0, 1, 1, 1, 0, 1],
        [0, 2, 3, 3, 2, 1, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 3, 3, 2, 1, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 1, 4, 3, 1, 1, 1, 1, 0, 1, 1, 1],
        [0, 1, 1, 3, 3, 1, 1, 0, 0, 1, 3, 0, 0],
        [0, 1, 0, 3, 1, 1, 1, 1, 0, 0, 3, 1, 1],
        [0, 1, 2, 3, 3, 0, 1, 0, 0, 1, 1, 1, 1],
        [1, 2, 2, 3, 2, 1, 1, 0, 0, 0, 2, 0, 0],
        [0, 1, 1, 5, 1, 0, 1, 0, 1, 0, 0, 1, 0],
        [0, 1, 2, 0, 1, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 1, 1, 3, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 3, 5, 1, 1, 1, 0, 0, 0, 0, 0, 0],
        [0, 1, 2, 3, 1, 0, 1, 0, 1, 0, 1, 1, 1],
        [0, 1, 3, 3, 2, 1, 1, 0, 0, 1, 3, 0, 0],
        [1, 1, 2, 1, 3, 1, 1, 0, 1, 0, 0, 1, 1],
        [0, 1, 2, 3, 1, 1, 1, 0, 1, 0, 0, 1, 0],
        [1, 1, 2, 0, 1, 0, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 1, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 2, 3, 0, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 2, 0, 3, 1, 1, 0, 1, 1, 1, 1, 1],
        [0, 1, 2, 5, 3, 0, 1, 0, 1, 0, 1, 0, 0],
        [1, 1, 0, 3, 3, 1, 1, 0, 0, 0, 2, 0, 0],
        [0, 1, 3, 4, 2, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 3, 3, 2, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 2, 3, 1, 1, 1, 0, 1, 0, 1, 1, 0],
        [0, 1, 2, 3, 0, 0, 1, 0, 1, 1, 1, 0, 0],
        [1, 1, 2, 4, 0, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 0, 2, 0, 0, 1, 0, 0, 1, 0, 0, 1],
        [1, 1, 2, 3, 1, 1, 1, 0, 0, 1, 2, 1, 0],
        [1, 1, 3, 1, 2, 0, 1, 0, 0, 1, 1, 0, 1],
        [0, 1, 0, 4, 3, 0, 1, 0, 0, 1, 2, 1, 0],
        [0, 1, 1, 3, 3, 1, 1, 0, 0, 1, 2, 1, 1],
        [0, 1, 2, 4, 0, 0, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 1, 3, 3, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 1, 3, 1, 0, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 3, 3, 3, 0, 1, 0, 0, 0, 3, 0, 0],
        [1, 1, 0, 4, 2, 0, 1, 0, 0, 0, 1, 1, 1],
        [1, 1, 2, 4, 2, 1, 1, 0, 0, 1, 1, 0, 1],
        [0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 2, 1, 0],
        [1, 1, 2, 2, 2, 1, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 1, 1, 2, 1, 1, 0, 0, 0, 1, 0, 1],
        [1, 2, 0, 3, 2, 1, 1, 0, 0, 0, 2, 0, 0],
        [0, 1, 2, 3, 1, 1, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 2, 4, 0, 0, 0, 0, 0, 0, 2, 1, 1],
        [1, 1, 0, 2, 2, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 1, 3, 0, 1, 1, 0, 1, 0, 1, 1, 0],
        [1, 1, 1, 5, 1, 1, 1, 0, 1, 1, 2, 1, 1],
        [0, 1, 0, 4, 3, 0, 2, 0, 0, 1, 1, 1, 1],
        [1, 1, 3, 0, 0, 1, 1, 1, 1, 0, 2, 0, 0],
        [1, 0, 1, 4, 2, 1, 1, 0, 0, 1, 0, 0, 1],
        [1, 1, 2, 3, 2, 1, 1, 0, 0, 1, 2, 1, 0],
        [0, 1, 3, 2, 0, 0, 1, 0, 1, 0, 1, 0, 1],
        [0, 1, 2, 5, 0, 1, 1, 0, 1, 0, 1, 0, 1],
        [0, 1, 2, 4, 0, 0, 1, 0, 0, 1, 0, 0, 1],
        [1, 1, 0, 5, 1, 0, 1, 0, 1, 0, 3, 0, 0],
        [1, 1, 1, 3, 3, 1, 1, 0, 1, 1, 1, 0, 0],
        [1, 1, 2, 4, 0, 1, 1, 0, 1, 1, 0, 0, 0],
        [0, 1, 3, 3, 0, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 2, 4, 0, 1, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 3, 3, 1, 1, 1, 0, 1, 0, 2, 1, 1],
        [0, 1, 2, 4, 2, 0, 1, 1, 0, 0, 0, 0, 1],
        [0, 1, 2, 2, 2, 1, 1, 1, 0, 1, 0, 1, 1],
        [0, 1, 1, 4, 3, 0, 1, 0, 0, 1, 2, 1, 0],
        [1, 1, 1, 4, 3, 1, 1, 0, 1, 1, 1, 1, 1],
        [0, 1, 3, 1, 2, 0, 1, 0, 1, 0, 1, 0, 1],
        [0, 1, 2, 3, 0, 1, 1, 0, 1, 1, 1, 0, 0],
        [0, 1, 2, 3, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 1, 3, 2, 1, 1, 0, 1, 0, 1, 1, 0],
        [1, 1, 2, 5, 2, 1, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 3, 3, 2, 1, 1, 0, 1, 0, 1, 0, 0],
        [1, 1, 0, 5, 1, 0, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 1, 4, 1, 0, 1, 0, 0, 1, 2, 0, 0],
        [0, 1, 3, 3, 3, 0, -1, 0, 1, 1, 0, 1, 1],
        [0, 1, 2, 3, 3, 0, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 2, 3, 0, 1, 1, 0, 0, 1, 2, 1, 1],
        [1, 1, 1, 3, 2, 1, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 1, 3, 3, 1, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 2, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1],
        [1, 0, 0, 4, 3, 1, 1, 0, 1, 0, 1, 0, 1],
        [0, 1, 3, 5, 1, 0, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 2, 1, 1, 0, 1, 0, 1, 0, 0, 1, 0],
        [1, 1, 3, 4, 3, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 2, 3, 0, 0, 0, 1, 0, 0, 1, 2, 1, 0],
        [1, 1, 0, 5, 1, 0, 2, 0, 0, 1, 0, 1, 1],
        [0, 1, 2, 4, 0, 0, 1, 0, 0, 1, 1, 0, 1],
        [1, 1, 3, 3, 1, 1, 1, 0, 1, 1, 1, 0, 0],
        [0, 1, 1, 3, 0, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 1, 1, 3, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 2, 0, 1, 0, 1, 0, 0, 1, 2, 1, 0],
        [0, 1, 2, 3, 1, 0, 1, 0, 0, 0, 2, 0, 0],
        [0, 1, 0, 2, 1, 1, 1, 0, 1, 1, 2, 1, 0],
        [1, 1, 2, 4, 1, 1, 1, 0, 0, 0, 2, 0, 1],
        [0, 1, 1, 0, 3, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 0, 2, 5, 1, 0, 1, 0, 0, 1, 2, 1, 0],
        [1, 1, 0, 0, 1, 1, 1, 0, 0, 1, 2, 1, 0],
        [0, 1, 3, 3, 3, 0, 1, 0, 1, 0, 0, 1, 0],
        [1, 1, 1, 4, 1, 1, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 2, 5, 1, 1, 0, 0, 1, 1, 1, 1, 0],
        [1, 1, 3, 0, 3, 1, 1, 0, 1, 0, 2, 0, 0],
        [0, 1, 0, 1, 2, 1, 1, 0, 0, 1, 0, 0, 1],
        [1, 1, 1, 4, 1, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 2, 4, 3, 1, 1, 0, 0, 0, 1, 1, 1],
        [0, 1, 2, 4, 1, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 0, 2, 0, 0, 1, 0, 0, 1, 1, 0, 1],
        [0, 1, 0, 3, 2, 1, 1, 0, 0, 0, 1, 1, 1],
        [1, 1, 2, 3, 0, 0, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 2, 3, 0, 1, 1, 0, 0, 0, 3, 1, 0],
        [0, 1, 2, 2, 3, 1, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 1, 4, 2, 0, 0, 0, 0, 1, 0, 0, 0],
        [1, 2, 3, 3, 2, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 0, 1, 3, 1, 1, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 3, 3, 1, 0, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 0, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1],
        [1, 1, 2, 3, 0, 1, 1, 1, 0, 1, 1, 0, 0],
        [0, 1, 0, 3, 0, 1, 1, 0, 1, 1, 1, 0, 0],
        [0, 1, 2, 1, 1, 0, 1, 1, 0, 0, 0, 1, 1],
        [0, 1, 2, 3, 1, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 3, 3, 2, 1, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 1, 4, 1, 0, 1, 0, 0, 1, 2, 0, 1],
        [1, 1, 0, 3, 1, 0, 1, 0, 0, 0, 0, 0, 1],
        [1, 1, 2, 1, 1, 1, 1, 0, 0, 1, 0, 0, 1],
        [1, 1, 0, 4, 3, 0, 1, 0, 1, 0, 0, 1, 1],
        [0, 1, 1, 4, 0, 0, 1, 1, 1, 0, 1, 0, 0],
        [1, 1, 2, 3, 1, 1, 1, 0, 0, 0, 3, 1, 0],
        [1, 1, 0, 3, 1, 1, 1, 0, 0, 0, 2, 0, 0],
        [1, 1, 2, 3, 1, 0, 1, 0, 0, 0, 3, 1, 1],
        [1, 1, 2, 4, 0, 0, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 2, 3, 1, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 2, 4, 0, 1, 2, 0, 1, 0, 1, 1, 1],
        [0, 1, 0, 1, 3, 1, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 2, 3, 1, 1, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 2, 0, 0, 1, 1, 0, 0, 1, 1, 0, 1],
        [1, 1, 3, 1, 2, 0, 1, 0, 0, 1, 1, 1, 1],
        [0, 0, 3, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1],
        [1, 1, 3, 3, 0, 1, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 0, 3, 3, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 0, 3, 2, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 2, 2, 2, 1, 1, 0, 1, 1, 1, 1, 1],
        [1, 1, 2, 4, 1, 0, 1, 0, 1, 0, 0, 0, 0],
        [0, 1, 2, 0, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 3, 3, 3, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 0, 3, 3, 0, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 2, 5, 3, 1, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 2, 5, 1, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 2, 1, 0, 0, 1, 0, 1, 0, 1, 0, 1],
        [0, 1, 1, 3, 3, 0, 1, 0, 0, 1, 1, 1, 1],
        [0, 1, 0, 3, 1, 1, 2, 0, 0, 1, 2, 0, 0],
        [1, 1, 0, 2, 1, 1, 1, 0, 0, 0, 2, 1, 1],
        [1, 1, 0, 2, 1, 1, 1, 1, 1, 0, 0, 0, 0],
        [0, 1, 3, 4, 1, 1, 1, 0, 0, 0, 0, 0, 0],
        [0, 1, 0, 4, 0, 0, 1, 0, 0, 1, 2, 0, 0],
        [0, 0, 0, 3, 1, 0, 1, 1, 0, 1, 1, 1, 0],
        [0, 1, 0, 4, 0, 1, 1, 0, 0, 0, 3, 0, 1],
        [1, 1, 0, 4, 2, 0, 1, 0, 0, 0, 0, 0, 0],
        [0, 1, 2, 4, 1, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 1, 4, 1, 1, 1, 0, 0, 0, 3, 1, 0],
        [1, 1, 3, 1, 3, 0, 1, 0, 1, 1, 3, 0, 0],
        [0, 1, 2, 4, 0, 0, 1, 0, 1, 0, 1, 1, 0],
        [1, 1, 1, 1, 1, 1, 2, 0, 0, 1, 1, 0, 0],
        [0, 1, 1, 3, 0, 0, 1, 0, 1, 1, 1, 0, 1],
        [1, 2, 2, 4, 1, 0, 1, 0, 0, 0, 2, 0, 0],
        [1, 1, 0, 4, 2, 1, 1, 0, 1, 0, 1, 0, 1],
        [1, 1, 3, 4, 1, 0, 1, 0, 0, 0, 0, 0, 1],
        [0, 1, 0, 1, 0, 1, 1, 0, 0, 1, 0, 1, 0],
        [0, 1, 2, 4, 1, 1, 1, 0, 1, 1, 0, 0, 1],
        [0, 1, 3, 3, 0, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 2, 1, 1, 0, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 2, 4, 3, 1, 1, 0, 0, 1, 0, 1, 0],
        [0, 1, 1, 3, 1, 1, 1, 0, 1, 0, 2, 0, 0],
        [0, 2, 2, 3, 2, 0, 1, 0, 1, 1, 0, 1, 0],
        [1, 1, 2, 0, 2, 0, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 0, 1, 0, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 1, 3, 3, 1, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 1, 3, 0, 0, 1, 0, 0, 1, 0, 0, 1],
        [0, 1, 3, 5, 1, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 0, 3, 1, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 1, 4, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 3, 4, 0, 1, 1, 0, 1, 0, 1, 1, 1],
        [1, 1, 0, 1, 1, 1, 0, 0, 0, 0, 1, 0, 0],
        [0, 1, 0, 0, 0, 1, 1, 0, 1, 1, 2, 0, 1],
        [1, 1, 3, 3, 1, 0, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 1, 3, 2, 1, 1, 0, 0, 1, 3, 0, 0],
        [1, 1, 2, 3, 3, 1, 1, 0, 1, 1, 2, 1, 0],
        [0, 1, 2, 3, 3, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 2, 2, 1, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 3, 1, 0, 0, 1, 0, 0, 1, 1, 0, 0],
        [1, 2, 3, 4, 3, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 0, 0, 3, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 2, 4, 2, 0, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 0, 4, 3, 1, 2, 0, 0, 1, 2, 1, 1],
        [1, 1, 0, 1, 2, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 0, 4, 1, 1, 1, 0, 0, 0, 2, 0, 0],
        [1, 2, 2, 3, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 0, 5, 2, 0, 1, 0, 0, 0, 2, 0, 1],
        [0, 1, 2, 4, 0, 0, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 2, 2, 0, 1, 1, 0, 0, 0, 0, 0, 1],
        [0, 1, 1, 4, 2, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 3, 4, 1, 1, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 3, 4, 2, 0, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 0, 3, 3, 1, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 1, 1, 0, 0, 1, 0, 1, 1, 1, 1, 1],
        [1, 1, 2, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 3, 1, 2, 1, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 2, 4, 1, 0, 1, 0, 0, 1, 2, 0, 0],
        [0, 1, 2, 4, 2, 0, 1, 0, 0, 1, 0, 1, 0],
        [1, 0, 1, 4, 2, 1, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 0, 3, 3, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 2, 1, 1, 0, 1, 0, 0, 1, 0, 1, 1],
        [0, 1, 1, 4, 1, 1, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 1, 3, 1, 0, 1, 0, 0, 0, 2, 0, 0],
        [1, 1, 2, 4, 3, 1, 1, 0, 1, 0, 1, 1, 1],
        [0, 1, 2, 1, 2, 1, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 3, 4, 2, 1, 1, 0, 0, 1, 0, 0, 1],
        [1, 1, 0, 4, 1, 1, 1, 0, 0, 1, 2, 0, 1],
        [0, 1, 2, 2, 1, 0, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 2, 3, 2, 1, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 0, 5, 1, 1, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 2, 3, 3, 1, 1, 0, 1, 0, 3, 0, 0],
        [0, 1, 1, 4, 3, 1, 1, 0, 1, 0, 1, 0, 0],
        [0, 2, 0, 3, 0, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 2, 1, 2, 1, 1, 0, 0, 1, 1, 1, 1],
        [0, 1, 3, 3, 1, 0, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 2, 4, 2, 0, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 2, 2, 2, 0, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 1, 3, 1, 1, 1, 0, 1, 0, 1, 0, 0],
        [0, 1, 1, 5, 3, 1, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 2, 3, 0, 0, 1, 0, 1, 1, 2, 1, 0],
        [1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 0],
        [1, 1, 2, 4, 1, 0, 1, 0, 0, 0, 1, 0, 1],
        [0, 1, 2, 3, 2, 1, 0, 0, 0, 1, 0, 1, 1],
        [1, 1, 3, 2, 2, 1, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 1, 3, 3, 1, 1, 0, 1, 1, 1, 1, 0],
        [0, 2, 3, 4, 2, 0, 2, 0, 0, 1, 1, 0, 0],
        [0, 1, 3, 3, 3, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 2, 4, 0, 1, 1, 0, 0, 0, 2, 1, 1],
        [1, 1, 1, 2, 1, 1, 2, 0, 0, 1, 2, 1, 1],
        [1, 1, 3, 5, 0, 0, 1, 0, 0, 1, 3, 1, 0],
        [0, 1, 3, 0, 3, 0, 1, 0, 0, 1, 2, 1, 0],
        [1, 2, 0, 1, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 0, 4, 2, 1, 1, 0, 1, 0, 1, 0, 0],
        [0, 1, 1, 2, 2, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 2, 3, 3, 1, 1, 0, 0, 0, 0, 0, 0],
        [0, 1, 3, 3, 1, 0, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 3, 3, 3, 1, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 0, 3, 1, 0, 1, 0, 0, 1, 3, 0, 0],
        [1, 1, 2, 4, 0, 1, 1, 0, 0, 1, 1, 1, 1],
        [0, 1, 2, 1, 1, 0, 1, 0, 0, 0, 2, 0, 1],
        [0, 1, 3, 5, 1, 1, 1, 0, 0, 0, 2, 0, 0],
        [1, 1, 1, 3, 1, 0, 1, 0, 0, 1, 3, 1, 0],
        [0, 1, 2, 3, 3, 0, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 3, 4, 1, 1, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 2, 1, 1, 0, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 2, 4, 1, 1, 1, 0, 1, 1, 0, 1, 1],
        [0, 1, 2, 3, 1, 1, 1, 0, 0, 1, 0, 1, 0],
        [1, 2, 0, 5, 2, 0, 1, 0, 0, 1, 0, 1, 0],
        [0, 1, 2, 3, 3, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 1, 3, 1, 0, 1, 0, 0, 1, 1, 0, 0],
        [1, 0, 2, 2, 0, 1, 1, 0, 0, 0, 1, 0, 1],
        [0, 1, 1, 0, 2, 1, 1, 0, 0, 1, 2, 0, 1],
        [1, 1, 3, 4, 1, 1, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 0, 2, 2, 1, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 2, 4, 0, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 2, 3, 1, 0, 1, 0, 1, 0, 1, 1, 1],
        [0, 1, 3, 5, 1, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 1, 4, 3, 1, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 2, 4, 3, 0, 1, 1, 0, 0, 1, 0, 1],
        [0, 1, 1, 3, 0, 0, 1, 0, 0, 1, 2, 0, 0],
        [1, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1],
        [0, 1, 2, 2, 2, 1, 1, 1, 1, 1, 1, 0, 0],
        [0, 1, 3, 0, 3, 1, 1, 0, 0, 1, 0, 1, 0],
        [0, 1, 2, 4, 3, 1, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 0, 4, 2, 0, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 0, 3, 1, 0, 2, 0, 0, 0, 3, 1, 0],
        [0, 1, 0, 5, 2, 1, 1, 0, 1, 1, 3, 1, 1],
        [0, 1, 3, 4, 0, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 1, 3, 3, 0, 1, 0, 0, 1, 0, 1, 1],
        [1, 1, 2, 5, 3, 1, 1, 0, 0, 0, 0, 0, 0],
        [0, 1, 2, 3, 3, 0, 1, 0, 1, 0, 1, 0, 0],
        [0, 1, 3, 4, 2, 0, 1, 0, 0, 0, 2, 0, 0],
        [1, 1, 2, 3, 3, 0, 1, 0, 0, 1, 0, 1, 1],
        [1, 1, 1, 1, 2, 1, 1, 0, 0, 1, 2, 0, 0],
        [0, 1, 2, 3, 1, 0, 1, 0, 1, 1, 2, 1, 0],
        [0, 1, 3, 3, 2, 1, 1, 0, 1, 0, 2, 0, 1],
        [0, 1, 2, 3, 1, 0, 1, 0, 1, 0, 0, 1, 0],
        [1, 1, 2, 4, 0, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 2, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0],
        [0, 0, 2, 2, 0, 1, 1, 0, 1, 0, 1, 1, 1],
        [1, 1, 2, 1, 1, 0, 1, 0, 1, 0, 1, 1, 1],
        [1, 1, 0, 3, 0, 1, 1, 0, 1, 1, 2, 1, 0],
        [0, 1, 2, 3, 1, 0, 1, 0, 1, 1, 2, 1, 0],
        [1, 1, 2, 1, 3, 0, 1, 0, 0, 1, 1, 1, 1],
        [0, 1, 2, 4, 3, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 2, 4, 1, 1, 1, 0, 0, 1, 2, 0, 0],
        [0, 1, 2, 0, 3, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 2, 2, 0, 1, 1, 0, 0, 1, 1, 0, 1],
        [1, 1, 2, 0, 0, 1, 1, 0, 0, 0, 3, 1, 1],
        [1, 1, 3, 4, 3, 1, 1, 0, 0, 0, 2, 0, 0],
        [1, 1, 2, 0, 1, 0, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 1, 2, 1, 1, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 1, 3, 3, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 2, 4, 3, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 1, 4, 1, 0, 1, 0, 0, 1, 3, 0, 0],
        [0, 1, 2, 2, 0, 1, 1, 0, 0, 0, 1, 0, 1],
        [0, 1, 3, 1, 2, 1, 1, 0, 1, 0, 1, 1, 1],
        [0, 1, 2, 3, 0, 0, 1, 0, 0, 1, 2, 0, 0],
        [0, 1, 3, 0, 3, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 0, 4, 2, 1, 1, 1, 1, 1, 0, 0, 0],
        [0, 1, 3, 4, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 2, 3, 3, 1, 1, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 1, 4, 3, 1, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 2, 1, 1, 1, 2, 0, 1, 0, 1, 1, 1],
        [1, 1, 2, 4, 3, 1, 1, 0, 0, 0, 0, 1, 1],
        [0, 1, 2, 0, 1, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 0, 5, 2, 1, 1, 0, 0, 1, 2, 1, 0],
        [1, 1, 2, 1, 0, 0, 1, 0, 0, 1, 0, 1, 0],
        [0, 1, 3, 3, 1, 1, 1, 0, 0, 0, 1, 1, 1],
        [0, 1, 3, 3, 3, 1, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 0, 5, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 0, 1, 1, 1, 1, 1, 0, 0, 2, 0, 0],
        [1, 1, 0, 3, 1, 1, 1, 0, 1, 1, 3, 1, 0],
        [1, 1, 2, 0, 0, 1, 1, 0, 1, 0, 1, 1, 0],
        [0, 1, 1, 1, 2, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 1, 3, 0, 1, 1, 0, 1, 0, 1, 1, 1],
        [1, 1, 2, 4, 1, 0, 1, 1, 0, 0, 1, 1, 0],
        [1, 1, 0, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1],
        [1, 1, 3, 2, 1, 0, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 0, 1, 1, 1, 1, 0, 1, 0, 0, 1, 1],
        [0, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 0],
        [0, 1, 3, 3, 3, 1, 2, 0, 0, 0, 2, 1, 0],
        [1, 1, 1, 3, 1, 0, 1, 0, 0, 0, 3, 1, 0],
        [0, 1, 0, 0, 1, 1, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 3, 1, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 3, 3, 0, 1, 2, 0, 0, 0, 0, 1, 0],
        [1, 1, 2, 4, 0, 0, 1, 0, 1, 0, 2, 1, 0],
        [1, 1, 3, 0, 2, 1, 1, 0, 1, 0, 1, 0, 1],
        [0, 1, 2, 3, 2, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 0, 4, 0, 0, 1, 0, 0, 0, 0, 0, 1],
        [1, 1, 2, 1, 2, 0, 1, 0, 0, 1, 2, 0, 1],
        [0, 1, 0, 3, 1, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 3, 4, 1, 1, 1, 0, 1, 1, 0, 1, 1],
        [0, 1, 1, 4, 0, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 0, 3, 2, 1, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 0, 1, 1, 0, 1, 0, 0, 1, 2, 1, 0],
        [1, 1, 1, 4, 1, 1, 1, 0, 0, 1, 1, 1, 1],
        [0, 1, 1, 4, 1, 0, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 2, 3, 1, 0, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 1, 4, 2, 1, 1, 1, 0, 0, 1, 0, 0],
        [1, 1, 1, 1, 2, 1, 1, 0, 0, 0, 0, 0, 1],
        [1, 1, 2, 4, 2, 1, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 0, 3, 0, 1, 1, 0, 1, 0, 3, 1, 0],
        [1, 1, 2, 0, 1, 0, 1, 0, 1, 1, 0, 0, 1],
        [1, 1, 0, 0, 1, 1, 1, 0, 1, 0, 1, 1, 1],
        [0, 1, 0, 3, 3, 0, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 0, 4, 3, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 1, 4, 1, 0, 1, 0, 0, 0, 3, 1, 0],
        [1, 1, 0, 3, 1, 1, 1, 0, 0, 0, 3, 0, 0],
        [1, 1, 1, 4, 0, 1, 1, 0, 0, 0, 2, 0, 0],
        [0, 1, 1, 3, 1, 0, 1, 0, 0, 0, 0, 0, 0],
        [0, 1, 3, 2, 0, 1, 1, 0, 0, 1, 0, 1, 0],
        [0, 1, 0, 4, 0, 1, 1, 0, 0, 0, 0, 0, 1],
        [1, 1, 2, 1, 0, 1, 1, 0, 0, 0, 1, 0, 1],
        [0, 1, 1, 0, 1, 1, 1, 0, 0, 0, 3, 0, 0],
        [1, 1, 2, 4, 2, 1, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 3, 2, 0, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 2, 4, 2, 0, 1, 0, 1, 0, 1, 0, 1],
        [0, 1, 2, 1, 3, 1, 1, 0, 0, 0, 0, 0, 1],
        [1, 1, 2, 1, 3, 1, 1, 0, 1, 1, 1, 0, 1],
        [0, 2, 3, 2, 1, 1, 1, 0, 1, 1, 1, 1, 0],
        [1, 1, 2, 3, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 2, 3, 1, 1, 1, 0, 1, 0, 1, 1, 0],
        [0, 1, 1, 1, 0, 0, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 2, 4, 3, 1, 1, 0, 1, 0, 1, 0, 0],
        [0, 1, 2, 0, 1, 1, 1, 0, 1, 1, 2, 0, 0],
        [1, 1, 0, 4, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 2, 4, 3, 1, 1, 0, 1, 1, 2, 1, 1],
        [1, 1, 0, 0, 3, 1, 1, 0, 0, 1, 1, 0, 1],
        [1, 1, 2, 3, 1, 1, 1, 0, 0, 1, 1, 1, 1],
        [0, 1, 3, 4, 2, 0, 1, 0, 1, 1, 2, 0, 0],
        [1, 1, 1, 1, 3, 1, 1, 0, 1, 1, 1, 0, 0],
        [1, 1, 2, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 3, 2, 1, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 2, 4, 0, 1, 1, 0, 1, 0, 1, 1, 1],
        [0, 1, 3, 5, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 2, 1, 2, 0, 1, 0, 1, 0, 2, 1, 0],
        [0, 1, 0, 0, 1, 1, 1, 0, 1, 0, 2, 1, 0],
        [0, 1, 2, 3, 0, 1, 0, 0, 1, 0, 1, 1, 1],
        [1, 1, 0, 4, 3, 0, 1, 0, 1, 0, 1, 0, 1],
        [1, 1, 2, 0, 0, 1, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 2, 3, 2, 0, 1, 0, 1, 1, 1, 0, 1],
        [1, 1, 3, 1, 2, 0, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 1, 0, 0, 1, 0, 0, 0, 1, 2, 1, 1],
        [1, 1, 2, 4, 2, 1, 1, 0, 0, 0, 0, 1, 1],
        [1, 1, 0, 3, 1, 0, 2, 0, 0, 0, 0, 1, 0],
        [1, 1, 1, 4, 1, 1, 1, 0, 1, 1, 1, 1, 0],
        [0, 1, 3, 4, 3, 0, 1, 0, 1, 0, 2, 1, 1],
        [0, 1, 1, 2, 0, 1, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 3, 2, 0, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 1, 3, 3, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 0, 5, 1, 0, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 2, 3, 0, 0, 1, 0, 1, 1, 1, 1, 1],
        [0, 1, 0, 3, 2, 1, 1, 0, 1, 1, 2, 0, 0],
        [0, 1, 2, 1, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 1, 3, 1, 0, 1, 1, 0, 0, 2, 1, 0],
        [1, 1, 0, 4, 0, 1, 1, 0, 0, 1, 3, 0, 1],
        [1, 1, 0, 3, 0, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 0, 2, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 0, 4, 1, 0, 1, 0, 0, 0, 3, 0, 1],
        [0, 1, 1, 3, 1, 0, 1, 1, 1, 0, 2, 1, 0],
        [1, 1, 2, 0, 2, 0, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 2, 0, 3, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 3, 2, 0, 1, 2, 0, 1, 1, 0, 0, 0],
        [1, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 2, 3, 1, 0, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 2, 4, 3, 0, 1, 0, 1, 1, 0, 0, 0],
        [1, 1, 2, 0, 0, 1, 1, 0, 1, 0, 1, 0, 0],
        [1, 2, 2, 3, 3, 1, 1, 0, 0, 1, 2, 1, 0],
        [0, 1, 2, 0, 0, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 1, 0, 2, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 2, 4, 3, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 2, 3, 0, 1, 1, 0, 1, 0, 1, 0, 0],
        [0, 1, 2, 5, 3, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 0, 4, 3, 1, 1, 0, 0, 0, 0, 0, 0],
        [0, 0, 2, 5, 3, 1, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 2, 0, 3, 1, 1, 0, 1, 1, 1, 1, 0],
        [0, 1, 2, 5, 1, 0, 1, 0, 1, 0, 0, 1, 0],
        [1, 1, 0, 2, 2, 1, 2, 0, 0, 0, 1, 0, 1],
        [1, 1, 3, 3, 3, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 2, 3, 4, 0, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 2, 3, 2, 0, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 1, 3, 1, 1, 1, 0, 1, 0, 1, 1, 0],
        [0, 1, 1, 3, 3, 1, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 3, 1, 2, 1, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 2, 3, 3, 0, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 0, 4, 1, 1, 1, 0, 0, 1, 2, 0, 0],
        [0, 1, 3, 4, 1, 1, 1, 0, 0, 0, 3, 1, 0],
        [0, 1, 1, 3, 0, 0, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 3, 0, 2, 1, 1, 0, 1, 1, 1, 1, 1],
        [1, 1, 1, 4, 2, 1, 1, 1, 0, 0, 1, 1, 0],
        [1, 1, 0, 1, 1, 0, 1, 0, 0, 1, 0, 0, 1],
        [1, 1, 1, 0, 2, 1, 1, 0, 1, 1, 1, 0, 1],
        [1, 1, 0, 1, 3, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 1, 3, 1, 0, 1, 0, 0, 0, 2, 0, 0],
        [0, 1, 3, 1, 2, 1, 1, 0, 1, 1, 1, 1, 1],
        [1, 1, 1, 0, 0, 1, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 2, 3, 2, 1, 1, 0, 0, 1, 2, 0, 0],
        [0, 1, 0, 1, 3, 1, 1, 0, 0, 0, 2, 0, 0],
        [1, 0, 1, 1, 0, 1, 1, 0, 0, 1, 2, 1, 1],
        [1, 1, 1, 4, 3, 0, 1, 0, 1, 0, 3, 0, 1],
        [0, 1, 1, 2, 1, 0, 1, 0, 0, 1, 2, 1, 0],
        [0, 1, 3, 4, 0, 1, 1, 1, 0, 1, 2, 0, 0],
        [1, 1, 2, 0, 1, 0, 1, 0, 1, 1, 2, 0, 0],
        [1, 1, 0, 4, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 3, 3, 0, 1, 1, 0, 1, 1, 1, 1, 0],
        [0, 1, 1, 3, 2, 0, 0, 0, 0, 0, 1, 1, 0],
        [0, 1, 2, 4, 1, 1, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 0, 3, 3, 1, 1, 0, 1, 1, 0, 1, 0],
        [1, 1, 2, 3, 3, 0, 1, 0, 1, 1, 3, 1, 0],
        [0, 1, 3, 4, 1, 1, 1, 0, 0, 0, 3, 0, 0],
        [0, 1, 3, 0, 0, 0, 1, 0, 1, 0, 1, 1, 0],
        [1, 1, 2, 3, 0, 0, 1, 0, 1, 1, 0, 1, 0],
        [0, 2, 3, 2, 1, 1, 1, 0, 0, 1, 2, 1, 1],
        [0, 1, 1, 3, 2, 1, 1, 0, 0, 1, 2, 1, 0],
        [1, 1, 0, 2, 1, 1, 1, 0, 1, 1, 1, 0, 0],
        [1, 1, 1, 4, 2, 0, 1, 0, 0, 0, 1, 1, 1],
        [0, 1, 2, 3, 1, 0, 1, 0, 1, 0, 0, 1, 1],
        [1, 1, 2, 1, 3, 1, 1, 0, 0, 0, 0, 0, 1],
        [0, 1, 1, 4, 1, 0, 1, 0, 0, 0, 2, 0, 0],
        [1, 1, 0, 4, 2, 0, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 1, 1],
        [1, 1, 0, 4, 1, 0, 1, 0, 0, 0, 0, 0, 0],
        [0, 1, 2, 4, 3, 1, 1, 0, 1, 0, 1, 0, 0],
        [1, 1, 1, 5, 2, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 0, 3, 1, 1, 2, 0, 0, 1, 1, 0, 0],
        [0, 1, 0, 3, 1, 1, 1, 0, 0, 1, 2, 0, 0],
        [0, 1, 2, 0, 3, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 0, 4, 1, 1, 1, 0, 0, 0, 0, 0, 0],
        [1, 2, 0, 1, 1, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 2, 1, 3, 0, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 3, 4, 3, 0, 1, 0, 0, 0, 0, 1, 1],
        [1, 1, 1, 4, 0, 1, 1, 0, 1, 0, 2, 1, 1],
        [0, 1, 0, 3, 2, 1, 1, 0, 1, 1, 1, 1, 1],
        [1, 0, 3, 5, 3, 0, 1, 0, 0, 1, 1, 0, 0],
        [0, 0, 0, 4, 3, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 0, 3, 3, 1, 1, 0, 1, 1, 1, 1, 1],
        [1, 1, 2, 2, 0, 1, 1, 0, 1, 0, 2, 1, 0],
        [0, 1, 2, 1, 0, 1, 1, 0, 0, 0, 2, 1, 1],
        [1, 1, 2, 1, 1, 0, 1, 0, 0, 1, 2, 0, 0],
        [0, 1, 0, 4, 1, 1, 1, 0, 1, 0, 1, 1, 1],
        [1, 1, 1, 3, 1, 1, 1, 0, 1, 0, 0, 1, 0],
        [0, 1, 1, 3, 1, 1, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 2, 4, 3, 1, 1, 0, 0, 0, 1, 1, 1],
        [0, 2, 2, 3, 1, 1, 0, 0, 0, 1, 3, 1, 1],
        [1, 1, 0, 0, 1, 1, 1, 1, 0, 0, 1, 1, 1],
        [1, 1, 1, 5, 1, 1, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 1, 4, 1, 1, 1, 0, 0, 0, 2, 0, 0],
        [1, 1, 2, 4, 2, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 0, 4, 3, 0, 1, 0, 0, 0, 2, 0, 0],
        [1, 1, 0, 3, 1, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 0, 3, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1],
        [1, 2, 0, 1, 1, 1, 1, 0, 1, 0, 0, 1, 0],
        [1, 1, 2, 1, 3, 1, 2, 0, 1, 0, 1, 0, 1],
        [1, 1, 0, 1, 1, 1, 1, 0, 1, 0, 0, 1, 1],
        [1, 1, 2, 1, 0, 1, 1, 0, 1, 1, 1, 1, 1],
        [1, 1, 2, 4, 3, 1, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 0, 3, 2, 0, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 1, 3, 3, 1, 2, 0, 0, 1, 0, 0, 0],
        [1, 1, 2, 3, 0, 1, 1, 0, 0, 1, 0, 0, 1],
        [0, 1, 3, 0, 1, 0, 1, 0, 0, 0, 3, 1, 0],
        [1, 1, 3, 4, 2, 1, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 2, 4, 2, 1, 1, 0, 1, 0, 3, 0, 1],
        [1, 1, 0, 1, 1, 1, 1, 0, 1, 0, 3, 1, 1],
        [0, 1, 2, 0, 0, 1, 1, 0, 0, 0, 2, 0, 0],
        [1, 1, 2, 4, 0, 0, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 2, 4, 1, 0, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 0, 3, 3, 1, 1, 1, 1, 0, 0, 1, 1],
        [1, 1, 1, 4, 3, 1, 1, 0, 0, 1, 0, 1, 0],
        [0, 0, 0, 3, 1, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 2, 1, 3, 1, 1, 0, 0, 0, 1, 0, 1],
        [0, 1, 3, 2, 3, 1, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 0, 5, 3, 1, 1, 0, 0, 0, 1, 1, 1],
        [0, 1, 2, 1, 2, 1, 0, 0, 1, 0, 1, 0, 1],
        [0, 1, 0, 5, 1, 0, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 1, 2, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 2, 5, 1, 1, 1, 0, 1, 0, 2, 1, 1],
        [1, 1, 0, 4, 2, 1, 1, 0, 1, 0, 1, 1, 1],
        [1, 1, 2, 3, 3, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 2, 0, 3, 1, 1, 0, 1, 0, 2, 0, 0],
        [1, 1, 2, 4, 1, 1, 1, 0, 1, 1, 1, 1, 0],
        [1, 1, 2, 3, 2, 1, 2, 0, 0, 1, 0, 1, 1],
        [0, 1, 1, 1, 1, 0, 1, 0, 0, 0, 1, 0, 0],
        [0, 2, 1, 3, 2, 0, 1, 0, 0, 1, 0, 1, 0],
        [0, 1, 2, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 1, 4, 2, 1, 1, 0, 0, 0, 1, 1, 1],
        [0, 1, 2, 1, 1, 1, 1, 0, 1, 0, 2, 1, 0],
        [1, 1, 0, 4, 3, 1, 1, 0, 0, 1, 0, 0, 1],
        [0, 1, 2, 4, 3, 1, 1, 0, 0, 1, 2, 1, 1],
        [0, 1, 2, 4, 1, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 1, 4, 1, 1, 1, 0, 1, 1, 1, 1, 1],
        [1, 1, 2, 3, 0, 0, 1, 0, 1, 0, 1, 1, 1],
        [1, 1, 1, 1, 0, 0, 1, 0, 0, 1, 2, 0, 1],
        [1, 2, 2, 1, 1, 0, 1, 0, 0, 1, 2, 1, 0],
        [0, 1, 3, 3, 1, 1, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 2, 3, 3, 0, 1, 0, 1, 0, 1, 0, 0],
        [1, 1, 2, 3, 3, 1, 1, 0, 0, 0, 1, 1, 1],
        [1, 1, 3, 3, 1, 1, 1, 0, 0, 0, 2, 0, 0],
        [0, 2, 1, 1, 0, 1, 1, 0, 1, 0, 0, 0, 0],
        [1, 1, 2, 4, 2, 0, 1, 1, 0, 1, 1, 1, 0],
        [0, 1, 2, 3, 0, 1, 1, 0, 0, 1, 1, 1, 1],
        [0, 1, 1, 2, 1, 0, 1, 0, 1, 0, 1, 1, 0],
        [1, 1, 0, 4, 0, 1, 1, 0, 0, 0, 1, 1, 1],
        [0, 1, 2, 3, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 0, 5, 1, 1, 2, 0, 0, 1, 2, 0, 0],
        [0, 1, 1, 0, 3, 1, 1, 0, 1, 0, 3, 1, 0],
        [1, 1, 2, 3, 3, 0, 1, 0, 0, 0, 3, 0, 1],
        [0, 1, 2, 4, 1, 1, 2, 0, 0, 1, 0, 1, 1],
        [0, 1, 1, 3, 1, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1],
        [1, 1, 3, 3, 2, 1, 1, 0, 1, 1, 1, 1, 0],
        [1, 1, 2, 5, 3, 1, 1, 0, 1, 1, 1, 0, 0],
        [1, 1, 3, 4, 3, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 2, 3, 0, 1, 2, 1, 0, 0, 2, 1, 0],
        [0, 1, 1, 4, 0, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 3, 4, 1, 1, 1, 0, 0, 0, 1, 1, 1],
        [1, 1, 2, 3, 1, 1, 1, 0, 1, 0, 1, 0, 1],
        [1, 1, 0, 3, 1, 0, 1, 1, 0, 1, 1, 0, 0],
        [0, 1, 3, 0, 3, 1, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 2, 1, 1, 0, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 0, 1, 2, 1, 1, 0, 0, 0, 2, 1, 1],
        [1, 1, 1, 0, 1, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 2, 0, 2, 1, 1, 0, 0, 0, 1, 1, 1],
        [1, 1, 2, 3, 0, 0, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 1, 3, 1, 0, 1, 0, 1, 1, 2, 0, 0],
        [1, 1, 0, 3, 0, 1, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 2, 2, 1, 0, 1, 0, 1, 0, 1, 0, 0],
        [0, 1, 2, 1, 0, 1, 1, 0, 0, 0, 1, 0, 1],
        [1, 2, 3, 4, 3, 1, 1, 0, 1, 0, 1, 1, 0],
        [1, 1, 2, 4, 0, 0, 1, 0, 0, 0, 1, 1, 1],
        [1, 1, 1, 1, 3, 1, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 2, 3, 2, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 0, 1, 1, 1, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 3, 3, 3, 1, 1, 0, 1, 1, 2, 1, 0],
        [0, 1, 1, 4, 1, 0, 0, 0, 1, 0, 0, 0, 0],
        [1, 1, 2, 0, 1, 0, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 2, 4, 3, 0, 1, 0, 0, 0, 0, 0, 0],
        [0, 2, 2, 2, 3, 0, 1, 0, 1, 1, 1, 0, 0],
        [1, 2, 1, 3, 3, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 1, 4, 3, 0, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 2, 4, 2, 1, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 1, 3, 2, 0, 1, 0, 0, 0, 2, 0, 0],
        [1, 1, 1, 4, 2, 1, 1, 0, 0, 0, 1, 1, 1],
        [0, 1, 0, 5, 1, 1, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 3, 3, 0, 0, 1, 0, 1, 1, 1, 1, 0],
        [1, 1, 0, 3, 2, 0, 1, 0, 1, 0, 2, 1, 1],
        [1, 1, 3, 3, 3, 1, 1, 0, 0, 1, 1, 1, 1],
        [0, 1, 3, 3, 2, 0, 1, 0, 1, 1, 2, 0, 0],
        [0, 1, 0, 3, 2, 1, 2, 0, 0, 1, 0, 0, 0],
        [1, 1, 2, 3, 1, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 2, 3, 0, 1, 1, 0, 1, 1, 1, 1, 1],
        [0, 1, 0, 3, 1, 1, 1, 0, 0, 0, 3, 0, 0],
        [0, 1, 1, 4, 1, 0, 1, 0, 0, 1, 2, 0, 0],
        [0, 1, 1, 0, 1, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 3, 1, 2, 0, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 1, 3, 0, 1, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 1, 4, 0, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 2, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 0, 0, 1, 1, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 2, 4, 2, 0, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 2, 5, 1, 1, 1, 0, 1, 1, 1, 0, 0],
        [1, 1, 0, 4, 3, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1],
        [0, 1, 1, 4, 1, 1, 1, 0, 1, 0, 1, 1, 0],
        [1, 1, 1, 4, 1, 0, 1, 0, 1, 0, 1, 0, 0],
        [1, 1, 3, 4, 3, 1, 1, 0, 1, 0, 0, 1, 0],
        [0, 1, 2, 3, 1, 1, 1, 0, 1, 1, 0, 0, 0],
        [1, 1, 2, 4, 1, 0, 1, 0, 0, 0, 0, 1, 1],
        [0, 1, 0, 1, 0, 1, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 0, 3, 2, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 2, 3, 2, 1, 1, 0, 1, 1, 1, 1, 1],
        [1, 1, 3, 4, 1, 0, 1, 0, 0, 0, 1, 1, 1],
        [0, 1, 3, 3, 0, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 0, 3, 2, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 0, 1, 3, 1, 1, 1, 0, 0, 1, 3, 1, 0],
        [1, 1, 3, 4, 0, 0, 1, 0, 0, 0, 0, 0, 1],
        [0, 1, 0, 3, 3, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 0, 2, 3, 2, 1, 1, 0, 1, 0, 0, 1, 1],
        [1, 1, 2, 3, 3, 0, 1, 0, 1, 1, 2, 0, 0],
        [0, 1, 3, 4, 0, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 3, 3, 1, 1, 1, 0, 0, 1, 2, 0, 0],
        [0, 1, 0, 2, 0, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 2, 3, 1, 3, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 2, 0, 2, 1, 2, 0, 1, 0, 1, 0, 0],
        [0, 1, 0, 2, 2, 1, 2, 0, 0, 0, 1, 0, 0],
        [0, 1, 1, 4, 3, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 0, 2, 3, 1, 1, 0, 1, 0, 2, 1, 0],
        [0, 1, 3, 4, 2, 1, 2, 0, 1, 1, 0, 1, 1],
        [1, 1, 3, 5, 2, 1, 1, 0, 0, 0, 3, 0, 0],
        [0, 2, 3, 3, 2, 0, 1, 0, 0, 1, 0, 0, 0],
        [1, 2, 1, 5, 3, 0, 1, 0, 0, 0, 3, 1, 0],
        [1, 0, 0, 1, 2, 0, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 1, 3, 0, 1, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 1, 4, 1, 1, 1, 0, 1, 0, 1, 0, 0],
        [1, 1, 3, 0, 3, 1, 1, 0, 0, 1, 2, 1, 0],
        [1, 1, 2, 4, 3, 1, 1, 0, 0, 1, 2, 0, 0],
        [1, 0, 0, 4, 0, 0, 1, 0, 1, 0, 3, 1, 0],
        [1, 1, 0, 1, 0, 1, 1, 0, 1, 0, 1, 1, 1],
        [0, 1, 0, 3, 2, 1, 2, 0, 0, 1, 2, 1, 0],
        [0, 1, 1, 3, 3, 0, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 2, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1],
        [1, 1, 3, 4, 1, 1, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 2, 2, 3, 1, 1, 0, 0, 0, 1, 0, 1],
        [0, 1, 2, 0, 2, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 2, 3, 3, 0, 2, 0, 1, 1, 1, 1, 0],
        [0, 1, 0, 1, 1, 1, 1, 0, 1, 1, 0, 1, 1],
        [0, 1, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 1, 3, 1, 1, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 2, 3, 1, 1, 1, 0, 1, 0, 1, 0, 0],
        [1, 0, 0, 1, 1, 1, 1, 0, 0, 1, 1, 0, 1],
        [1, 1, 1, 3, 1, 0, 1, 0, 0, 0, 1, 1, 1],
        [0, 1, 3, 1, 1, 0, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 3, 3, 2, 1, 1, 0, 1, 1, 3, 1, 0],
        [1, 1, 2, 1, 1, 0, 1, 0, 0, 0, 2, 1, 0],
        [0, 2, 2, 3, 0, 0, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 0, 3, 1, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 3, 2, 3, 1, 1, 1, 0, 0, 1, 1, 0],
        [0, 1, 2, 3, 1, 1, 1, 0, 1, 0, 0, 1, 0],
        [1, 1, 2, 3, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 3, 4, 3, 1, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 2, 5, 3, 1, 1, 0, 1, 0, 2, 0, 1],
        [1, 1, 3, 4, 1, 1, 1, 0, 0, 1, 2, 0, 0],
        [1, 0, 0, 1, 3, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 0, 4, 3, 1, 1, 0, 1, 1, 1, 0, 0],
        [1, 2, 1, 1, 0, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 0, 4, 2, 1, 1, 0, 0, 1, 2, 1, 1],
        [0, 1, 0, 5, 3, 1, 1, 0, 1, 1, 1, 1, 0],
        [1, 1, 0, 4, 2, 1, 1, 0, 1, 1, 0, 1, 1],
        [1, 1, 1, 4, 2, 1, 1, 0, 1, 1, 1, 0, 1],
        [1, 1, 1, 3, 1, 0, 2, 0, 0, 0, 0, 0, 0],
        [0, 1, 0, 3, 0, 0, 1, 0, 1, 0, 1, 1, 1],
        [0, 1, 3, 1, 1, 1, 1, 0, 1, 0, 0, 1, 1],
        [0, 1, 2, 4, 1, 1, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1],
        [1, 0, 2, 4, 1, 1, 1, 0, 0, 1, 0, 0, 1],
        [1, 1, 3, 4, 1, 1, 1, 0, 0, 1, 1, 0, 1],
        [0, 1, 3, 1, 1, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 1, 1, 0, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 3, 3, 1, 0, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 1, 3, 2, 1, 1, 0, 1, 0, 1, 0, 0],
        [1, 1, 1, 3, 3, 1, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 0, 3, 0, 0, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 3, 2, 2, 1, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 1, 2, 3, 0, 1, 0, 0, 1, 2, 1, 0],
        [0, 1, 1, 3, 1, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 2, 3, 3, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 2, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 1, 5, 2, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 3, 1, 2, 0, 1, 0, 0, 0, 1, 0, 1],
        [0, 1, 1, 1, 2, 1, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 0, 2, 2, 1, 1, 0, 1, 0, 1, 1, 1],
        [1, 1, 2, 3, 1, 1, 1, 0, 0, 1, 0, 1, 1],
        [0, 1, 2, 0, 1, 1, 1, 1, 0, 0, 3, 0, 0],
        [1, 1, 2, 4, 2, 0, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 3, 3, 1, 1, 1, 0, 1, 0, 1, 1, 1],
        [1, 1, 2, 4, 1, 1, 1, 0, 0, 1, 0, 1, 1],
        [0, 1, 2, 3, 0, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 2, 1, 3, 1, 1, 0, 0, 0, 1, 1, 1],
        [0, 1, 2, 3, 2, 1, 1, 0, 1, 1, 1, 1, 0],
        [0, 1, 2, 4, 2, 1, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 3, 4, 1, 1, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 1, 1, 3, 1, 1, 0, 0, 1, 0, 1, 0],
        [0, 1, 0, 1, 3, 1, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 1, 5, 0, 1, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 3, 0, 1],
        [1, 1, 1, 4, 1, 1, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 2, 3, 1, 1, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 2, 4, 1, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 2, 4, 0, 1, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 2, 4, 2, 0, 1, 0, 0, 1, 1, 1, 1],
        [1, 0, 1, 0, 1, 1, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 0, 4, 3, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 0, 4, 2, 0, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 1, 4, 2, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 0, 4, 0, 0, 2, 0, 0, 0, 0, 1, 0],
        [1, 1, 3, 3, 2, 1, 1, 0, 1, 1, 1, 1, 0],
        [1, 1, 1, 3, 3, 0, 1, 0, 0, 1, 2, 1, 0],
        [0, 2, 2, 3, 1, 0, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 0, 2, 3, 1, 1, 0, 0, 1, 0, 1, 0],
        [0, 1, 1, 4, 1, 1, 1, 0, 1, 1, 0, 0, 0],
        [1, 1, 0, 1, 1, 0, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 2, 3, 0, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 0, 3, 2, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 1, 4, 1, 1, 2, 0, 0, 1, 2, 0, 0],
        [1, 1, 2, 3, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 2, 4, 3, 0, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 0, 5, 0, 1, 1, 0, 1, 0, 3, 1, 0],
        [1, 1, 2, 2, 3, 0, 1, 0, 0, 1, 3, 1, 1],
        [0, 1, 3, 3, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 2, 2, 3, 2, 0, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 2, 0, 1, 0, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 2, 3, 1, 1, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 1, 5, 1, 1, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 0, 3, 2, 1, 1, 0, 1, 1, 1, 1, 0],
        [1, 0, 2, 1, 0, 0, 1, 0, 0, 0, 2, 0, 1],
        [1, 1, 2, 3, 3, 1, 1, 0, 1, 1, 1, 1, 1],
        [0, 1, 3, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 3, 2, 1, 0, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 0, 1, 2, 0, 1, 0, 0, 1, 1, 1, 0],
        [0, 2, 3, 4, 1, 1, 1, 0, 1, 0, 3, 1, 0],
        [0, 1, 1, 1, 0, 0, 1, 0, 0, 1, 1, 1, 1],
        [0, 1, 3, 3, 3, 1, 1, 0, 0, 0, 2, 0, 0],
        [1, 1, 3, 3, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 2, 3, 3, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 3, 5, 1, 1, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 3, 3, 2, 0, 1, 0, 0, 1, 2, 1, 0],
        [0, 1, 1, 3, 0, 1, 1, 1, 0, 1, 1, 1, 1],
        [1, 1, 2, 3, 3, 1, 1, 0, 1, 1, 1, 0, 0],
        [1, 1, 2, 4, 1, 1, 1, 0, 0, 0, 0, 0, 1],
        [0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 2, 1, 2, 0, 1, 0, 1, 1, 2, 1, 1],
        [1, 1, 2, 3, 3, 1, 1, 0, 0, 0, 0, 0, 1],
        [0, 1, 2, 5, 2, 0, 1, 0, 1, 1, 1, 1, 1],
        [1, 1, 3, 4, 3, 1, 1, 0, 0, 1, 2, 1, 1],
        [0, 1, 0, 3, 1, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 3, 1, 1, 1, 1, 1, 0, 0, 1, 0, 0],
        [1, 1, 2, 1, 3, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 1, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 2, 0, 1, 1, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 0, 3, 2, 0, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 2, 3, 2, 0, 1, 0, 0, 0, 2, 1, 0],
        [1, 0, 0, 3, 0, 1, 1, 0, 0, 1, 1, 0, 1],
        [1, 2, 0, 3, 1, 1, 2, 0, 1, 1, 0, 0, 0],
        [1, 1, 3, 3, 0, 0, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 0, 5, 3, 0, 1, 1, 1, 1, 1, 1, 1],
        [1, 1, 1, 4, 0, 0, 1, 0, 1, 1, 2, 1, 1],
        [0, 1, 1, 4, 1, 0, 1, 0, 1, 1, 1, 0, 1],
        [0, 1, 3, 1, 0, 1, 1, 0, 1, 0, 1, 0, 0],
        [1, 1, 2, 1, 0, 1, 1, 0, 1, 1, 0, 1, 1],
        [1, 0, 3, 1, 2, 1, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 2, 1, 0, 0, 2, 0, 0, 1, 1, 1, 1],
        [1, 1, 2, 5, 3, 0, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 2, 4, 1, 0, 1, 0, 0, 1, 1, 0, 1],
        [0, 1, 2, 3, 1, 1, 1, 0, 1, 0, 1, 1, 0],
        [1, 1, 1, 3, 3, 0, 1, 0, 0, 1, 2, 0, 0],
        [0, 1, 1, 0, 2, 1, 1, 0, 0, 1, 2, 1, 1],
        [0, 1, 1, 4, 3, 0, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 1, 3, 1, 1, 1, 0, 1, 1, 3, 1, 1],
        [1, 1, 2, 2, 2, 1, 1, 0, 1, 0, 1, 0, 0],
        [0, 1, 3, 0, 2, 0, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 1, 5, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 2, 4, 2, 0, 1, 0, 1, 1, 1, 0, 1],
        [1, 1, 0, 4, 1, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 2, 4, 1, 1, 1, 0, 1, 1, 2, 0, 0],
        [1, 1, 2, 3, 2, 1, 1, 0, 1, 1, 0, 0, 0],
        [1, 1, 1, 4, 2, 0, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 1, 4, 1, 1, 1, 0, 0, 1, 0, 1, 1],
        [1, 2, 0, 3, 1, 0, 1, 0, 0, 0, 0, 1, 1],
        [1, 1, 1, 2, 2, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 3, 1, 2, 1, 1, 0, 0, 0, 2, 1, 1],
        [1, 1, 2, 4, 1, 1, 1, 0, 1, 0, 0, 1, 1],
        [0, 1, 0, 3, 1, 1, 1, 0, 1, 1, 1, 1, 0],
        [0, 1, 1, 4, 0, 1, 1, 0, 0, 0, 1, 0, 1],
        [0, 1, 0, 4, 2, 1, 1, 0, 1, 1, 0, 0, 1],
        [1, 1, 1, 3, 2, 0, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 2, 2, 2, 0, 1, 0, 0, 0, 1, 1, 1],
        [0, 1, 2, 1, 1, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 2, 4, 3, 1, 1, 0, 1, 0, 1, 1, 1],
        [0, 1, 1, 3, 1, 1, 1, 0, 1, 1, 1, 0, 0],
        [0, 1, 0, 3, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 1, 0, 3, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 2, 3, 3, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 3, 3, 2, 0, 1, 0, 0, 1, 2, 1, 0],
        [1, 1, 0, 2, 0, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 2, 3, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 3, 5, 1, 1, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 3, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0],
        [1, 1, 0, 2, 0, 0, 1, 0, 0, 0, 1, 0, 1],
        [0, 1, 0, 3, 2, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 0, 3, 1, 0, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 0, 4, 1, 1, 1, 0, 0, 0, 1, 0, 1],
        [0, 1, 2, 1, 3, 1, 0, 0, 1, 1, 1, 1, 1],
        [1, 2, 3, 2, 1, 1, 1, 0, 1, 0, 0, 1, 0],
        [1, 1, 2, 4, 2, 0, 1, 1, 0, 0, 0, 0, 1],
        [0, 1, 0, 1, 2, 1, 1, 0, 1, 0, 3, 0, 0],
        [1, 1, 1, 1, 3, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 1, 4, 1, 1, 1, 0, 1, 1, 1, 1, 0],
        [1, 1, 1, 0, 2, 0, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 2, 4, 3, 1, 1, 0, 1, 1, 2, 1, 1],
        [1, 1, 2, 3, 3, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 2, 1, 2, 1, 1, 0, 1, 0, 2, 0, 1],
        [0, 1, 0, 3, 0, 0, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 0, 4, 0, 1, 1, 0, 0, 1, 2, 1, 0],
        [1, 1, 1, 1, 1, 1, 0, 1, 0, 0, 1, 0, 0],
        [1, 1, 0, 1, 0, 1, 1, 0, 0, 0, 2, 0, 1],
        [1, 1, 1, 2, 3, 0, 1, 0, 0, 1, 1, 1, 1],
        [0, 1, 2, 2, 0, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 3, 5, 0, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 1, 3, 3, 1, 1, 0, 1, 0, 3, 0, 0],
        [1, 1, 3, 3, 1, 0, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 2, 1, 1, 1, 2, 0, 0, 1, 1, 1, 1],
        [1, 2, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 1, 1, 3, 0, 2, 0, 0, 1, 2, 1, 0],
        [0, 1, 1, 1, 3, 0, 1, 0, 0, 0, 2, 1, 0],
        [1, 2, 3, 1, 2, 0, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 0, 1, 3, 0, 1, 0, 1, 0, 2, 0, 0],
        [1, 1, 2, 1, 1, 1, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 2, 4, 1, 0, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 3, 2, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 2, 0, 1, 1, 1, 0, 1, 1, 1, 0, 1],
        [0, 0, 0, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1],
        [0, 1, 2, 2, 1, 1, 2, 0, 1, 0, 1, 1, 0],
        [0, 1, 2, 3, 0, 1, 1, 0, 1, 0, 1, 0, 1],
        [1, 1, 3, 0, 2, 1, 1, 0, 0, 0, 1, 0, 1],
        [0, 1, 3, 3, 1, 0, 2, 0, 0, 1, 1, 1, 1],
        [1, 1, 0, 3, 2, 0, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 0, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1],
        [0, 1, 2, 0, 3, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 2, 1, 3, 2, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 2, 3, 0, 1, 1, 0, 0, 1, 3, 1, 0],
        [1, 0, 1, 5, 0, 0, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 1, 2, 1, 0, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 0, 3, 0, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 3, 4, 0, 1, 1, 0, 1, 1, 1, 1, 1],
        [1, 1, 0, 3, 2, 0, 1, 1, 0, 0, 0, 0, 0],
        [1, 1, 1, 4, 2, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 3, 4, 1, 1, 1, 1, 1, 1, 1, 0, 0],
        [0, 1, 3, 1, 3, 0, 1, 0, 0, 1, 0, 1, 1],
        [1, 0, 0, 1, 2, 1, 1, 0, 0, 0, 3, 1, 1],
        [0, 1, 3, 4, 1, 1, 1, 0, 1, 1, 2, 0, 0],
        [1, 0, 1, 3, 1, 0, 1, 0, 0, 1, 2, 1, 0],
        [0, 1, 0, 1, 0, 1, 1, 0, 1, 0, 1, 0, 1],
        [0, 1, 1, 5, 2, 0, 1, 0, 1, 0, 2, 0, 0],
        [1, 1, 2, 3, 0, 1, 1, 1, 0, 1, 1, 0, 0],
        [0, 1, 1, 4, 1, 1, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 0, 4, 0, 1, 1, 0, 0, 0, 1, 1, 1],
        [1, 1, 0, 2, 2, 0, 1, 0, 0, 1, 0, 0, 0],
        [0, 2, 2, 4, 0, 1, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 0, 3, 0, 0, 1, 0, 0, 0, 3, 0, 1],
        [1, 1, 3, 1, 1, 1, 1, 0, 1, 0, 2, 1, 0],
        [1, 1, 0, 1, 3, 1, 1, 0, 1, 0, 1, 0, 1],
        [0, 1, 2, 2, 2, 1, 1, 0, 0, 1, 2, 0, 1],
        [1, 1, 2, 0, 2, 0, 1, 0, 1, 0, 1, 0, 0],
        [1, 0, 3, 4, 2, 0, 1, 0, 0, 0, 0, 0, 1],
        [0, 1, 0, 4, 1, 0, 1, 0, 1, 1, 2, 0, 0],
        [0, 1, 1, 4, 1, 1, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 1, 4, 3, 0, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 3, 4, 3, 0, 1, 0, 1, 1, 1, 0, 0],
        [1, 1, 0, 4, 1, 0, 1, 0, 1, 1, 1, 1, 1],
        [0, 1, 0, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 1, 1, 0, 1, 1, 0, 0, 1, 3, 0, 1],
        [1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 3, 0, 1, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 1, 4, 2, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 2, 3, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 2, 1, 3, 1, 1, 0, 0, 0, 1, 1, 1],
        [0, 1, 1, 4, 1, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 1, 4, 3, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 2, 4, 0, 0, 1, 0, 0, 0, 0, 1, 1],
        [0, 2, 2, 5, 2, 0, 1, 0, 0, 0, 0, 0, 1],
        [1, 1, 1, 1, 2, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 2, 3, 1, 1, 2, 0, 0, 1, 1, 0, 0],
        [0, 1, 2, 3, 3, 1, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 2, 4, 2, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 2, 1, 2, 2, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 3, 1, 3, 0, 1, 0, 1, 1, 2, 0, 0],
        [1, 1, 3, 0, 3, 1, 1, 0, 1, 0, 0, 1, 0],
        [0, 1, 0, 3, 0, 0, 1, 0, 0, 1, 0, 1, 0],
        [0, 1, 2, 1, 2, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 3, 3, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 3, 2, 0, 1, 1, 0, 1, 0, 1, 0, 0],
        [1, 1, 2, 3, 1, 1, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 2, 4, 0, 1, 1, 1, 0, 0, 0, 0, 1],
        [0, 2, 1, 1, 3, 0, 1, 0, 1, 0, 1, 0, 0],
        [0, 1, 1, 2, 2, 0, 1, 0, 0, 1, 0, 0, 1],
        [0, 1, 2, 3, 1, 0, 2, 0, 1, 1, 3, 1, 0],
        [1, 1, 1, 3, 2, 1, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 2, 4, 0, 1, 1, 0, 1, 1, 0, 1, 1],
        [0, 1, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 1],
        [0, 1, 0, 4, 0, 0, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 0, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1],
        [0, 1, 2, 2, 1, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 2, 5, 0, 0, 1, 0, 0, 1, 3, 1, 1],
        [0, 1, 2, 3, 3, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 0, 2, 0, 1, 1, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 2, 3, 1, 1, 1, 0, 0, 0, 2, 0, 0],
        [0, 1, 3, 3, 0, 1, 1, 0, 0, 0, 2, 0, 0],
        [1, 1, 2, 4, 3, 0, 1, 0, 0, 1, 3, 0, 0],
        [1, 1, 2, 3, 3, 1, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 0, 4, 1, 1, 1, 0, 0, 0, 1, 1, 1],
        [1, 1, 1, 3, 1, 0, 1, 0, 0, 1, 2, 1, 0],
        [0, 1, 1, 3, 1, 1, 1, 0, 0, 0, 3, 0, 0],
        [0, 1, 2, 3, 0, 0, 1, 0, 1, 1, 1, 0, 0],
        [1, 1, 0, 4, 2, 1, 1, 0, 0, 1, 2, 0, 0],
        [0, 1, 2, 3, 1, 1, 1, 0, 0, 1, 1, 1, 1],
        [0, 1, 2, 3, 0, 0, 1, 0, 1, 1, 0, 0, 0],
        [1, 1, 1, 3, 3, 1, 1, 0, 0, 0, 2, 0, 0],
        [1, 1, 0, 4, 1, 1, 1, 0, 0, 0, 3, 1, 1],
        [1, 1, 1, 4, 3, 1, 1, 0, 0, 1, 0, 1, 0],
        [0, 1, 2, 3, 2, 1, 1, 0, 1, 1, 1, 0, 0],
        [1, 1, 2, 3, 1, 0, 1, 0, 1, 1, 0, 0, 0],
        [1, 1, 0, 4, 1, 1, 1, 0, 1, 1, 2, 0, 0],
        [1, 1, 2, 0, 0, 1, 1, 0, 0, 1, 1, 0, 1],
        [0, 1, 2, 3, 2, 1, 2, 0, 0, 1, 0, 0, 0],
        [0, 1, 2, 3, 0, 0, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 2, 4, 1, 0, 1, 0, 1, 1, 1, 0, 1],
        [1, 1, 0, 1, 0, 1, 1, 0, 0, 0, 0, 0, 1],
        [0, 1, 1, 4, 0, 1, 1, 0, 0, 1, 2, 1, 0],
        [0, 1, 0, 4, 0, 0, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 3, 4, 0, 0, 1, 0, 0, 1, 1, 0, 1],
        [1, 1, 1, 4, 1, 0, 1, 0, 1, 1, 0, 0, 0],
        [0, 1, 0, 4, 3, 1, 1, 0, 1, 1, 3, 0, 0],
        [1, 1, 1, 4, 0, 0, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 3, 1, 0, 1, 1, 0, 0, 1, 3, 1, 1],
        [0, 2, 1, 3, 1, 0, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 0, 0, 3, 0, 1, 0, 1, 0, 2, 0, 1],
        [1, 1, 0, 3, 3, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 0, 3, 1, 0, 1, 0, 1, 0, 1, 1, 0],
        [1, 1, 1, 2, 1, 0, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 1, 4, 1, 1, 1, 0, 0, 1, 3, 0, 0],
        [1, 2, 2, 1, 1, 1, 1, 0, 0, 1, 0, 1, 0],
        [0, 2, 0, 5, 2, 1, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 0, 3, 2, 1, 1, 0, 1, 1, 1, 1, 1],
        [1, 1, 3, 3, 1, 1, 0, 0, 0, 1, 0, 0, 0],
        [1, 1, 2, 3, 1, 1, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 2, 3, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 2, 4, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 1, 2, 3, 1, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 0, 2, 0, 0, 1, 0, 0, 0, 2, 0, 0],
        [0, 1, 2, 0, 1, 1, 1, 0, 0, 1, 2, 0, 1],
        [0, 1, 2, 0, 0, 1, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 0, 4, 3, 0, 1, 0, 0, 0, 0, 0, 1],
        [1, 1, 1, 3, 2, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 1, 3, 1, 1, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 2, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 2, 3, 1, 1, 1, 0, 0, 1, 1, 0, 1],
        [1, 1, 1, 3, 3, 1, 1, 1, 0, 0, 1, 0, 0],
        [0, 2, 0, 3, 3, 0, 1, 0, 1, 1, 1, 0, 0],
        [0, 2, 1, 5, 0, 1, 1, 0, 0, 1, 0, 1, 0],
        [0, 1, 1, 3, 0, 1, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 1, 2, 2, 1, 1, 0, 0, 0, 2, 0, 1],
        [0, 1, 3, 3, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 1, 3, 1, 1, 1, 0, 1, 1, 0, 0, 0],
        [1, 1, 0, 1, 0, 1, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 1, 3, 0, 0, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 3, 3, 0, 1, 1, 0, 0, 1, 1, 0, 1],
        [1, 1, 1, 3, 2, 1, 1, 0, 0, 1, 3, 0, 0],
        [0, 1, 2, 4, 1, 1, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 2, 0, 3, 1, 1, 0, 0, 0, 3, 1, 1],
        [1, 1, 0, 1, 1, 0, 1, 0, 0, 1, 0, 1, 0],
        [0, 1, 0, 5, 0, 0, 1, 0, 1, 1, 3, 0, 0],
        [0, 1, 0, 4, 2, 0, 1, 0, 1, 0, 3, 1, 1],
        [1, 1, 0, 5, 1, 1, 1, 0, 0, 0, 2, 0, 0],
        [0, 1, 0, 5, 2, 1, 1, 0, 1, 0, 1, 0, 0],
        [1, 1, 3, 3, 3, 1, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 0, 3, 3, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 1, 4, 2, 1, 1, 0, 0, 1, 1, 1, 1],
        [0, 1, 3, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 1, 3, 2, 0, 1, 0, 0, 1, 0, 1, 0],
        [0, 1, 0, 3, 1, 1, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 2, 3, 3, 1, 1, 0, 1, 0, 1, 1, 1],
        [1, 1, 2, 3, 0, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 3, 3, 1, 1, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 3, 1, 2, 1, 1, 0, 0, 0, 2, 1, 1],
        [0, 1, 0, 3, 0, 0, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 0, 3, 1, 1, 1, 0, 0, 1, 3, 1, 0],
        [0, 1, 3, 3, 3, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 2, 2, 0, 1, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 1, 4, 2, 1, 1, 1, 0, 1, 0, 0, 1],
        [0, 1, 0, 3, 0, 1, 1, 0, 0, 1, 1, 1, 1],
        [0, 1, 2, 1, 2, 1, 2, 0, 0, 1, 2, 1, 1],
        [0, 1, 2, 4, 2, 0, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 2, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 0, 4, 2, 1, 1, 0, 0, 1, 0, 0, 1],
        [1, 1, 2, 3, 2, 0, 1, 0, 1, 1, 1, 1, 1],
        [0, 1, 3, 0, 2, 1, 1, 0, 0, 0, 1, 1, 1],
        [1, 1, 1, 1, 1, 0, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 3, 1, 3, 1, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 1, 3, 3, 0, 1, 0, 0, 0, 2, 0, 0],
        [1, 1, 2, 4, 2, 1, 1, 1, 0, 0, 1, 0, 1],
        [0, 0, 2, 0, 2, 1, 1, 0, 0, 1, 0, 1, 1],
        [0, 1, 2, 4, 0, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 2, 4, 1, 1, 1, 1, 0, 1, 2, 0, 1],
        [1, 1, 1, 3, 0, 1, 1, 0, 0, 1, 1, 1, 1],
        [0, 1, 2, 3, 2, 0, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 0, 3, 3, 0, 1, 1, 0, 1, 1, 0, 0],
        [0, 1, 2, 3, 0, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 0, 2, 1, 2, 0, 1, 0, 0, 0, 1, 0, 1],
        [1, 0, 2, 4, 0, 1, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 0, 2, 3, 0, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 3, 3, 1, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 2, 1, 2, 0, 1, 0, 1, 0, 1, 1, 1],
        [0, 0, 2, 4, 1, 1, 1, 0, 0, 1, 0, 0, 1],
        [1, 1, 1, 1, 0, 1, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 2, 3, 2, 1, 0, 0, 0, 1, 1, 0, 0],
        [1, 1, 2, 3, 2, 1, 1, 0, 1, 0, 1, 1, 1],
        [1, 1, 3, 0, 1, 0, 1, 0, 0, 1, 3, 0, 0],
        [0, 1, 2, 1, 2, 1, 1, 0, 0, 1, 2, 1, 0],
        [0, 1, 3, 3, 3, 1, 1, 0, 1, 1, 2, 0, 0],
        [0, 1, 2, 4, 1, 0, 1, 0, 0, 1, 0, 0, 1],
        [1, 1, 0, 2, 1, 1, 1, 0, 0, 1, 2, 1, 1],
        [0, 1, 0, 0, 3, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 0, 4, 0, 1, 1, 0, 1, 1, 2, 0, 1],
        [1, 2, 2, 3, 1, 0, 1, 0, 1, 1, 1, 0, 0],
        [1, 1, 3, 1, 0, 0, 1, 0, 1, 1, 1, 0, 1],
        [1, 1, 1, 3, 0, 0, 1, 1, 0, 0, 1, 0, 0],
        [1, 1, 0, 2, 1, 1, 1, 0, 1, 0, 1, 0, 0],
        [0, 1, 1, 4, 0, 0, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 2, 3, 2, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 2, 1, 2, 0, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 2, 0, 2, 1, 2, 0, 0, 0, 1, 1, 0],
        [1, 1, 2, 3, 1, 1, 1, 0, 1, 1, 0, 1, 1],
        [1, 1, 0, 1, 2, 0, 1, 0, 0, 1, 0, 0, 1],
        [1, 1, 2, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1],
        [1, 1, 2, 3, 0, 0, 1, 0, 1, 0, 1, 0, 1],
        [0, 1, 2, 1, 2, 0, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 2, 4, 2, 1, 1, 0, 1, 1, 2, 1, 0],
        [0, 1, 3, 4, 3, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 2, 3, 0, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 1, 3, 2, 1, 1, 0, 1, 0, 0, 1, 0],
        [0, 1, 3, 5, 3, 1, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 0, 4, 3, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 0, 0, 3, 1, 1, 1, 0, 0, 1, 0, 1],
        [1, 1, 0, 1, 2, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 2, 4, 1, 1, 1, 0, 1, 1, 1, 1, 1],
        [1, 1, 1, 4, 2, 1, 1, 0, 1, 1, 2, 0, 0],
        [0, 1, 2, 3, 3, 1, 1, 0, 1, 0, 2, 0, 0],
        [1, 2, 1, 3, 1, 1, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 0, 3, 2, 0, 1, 0, 1, 0, 0, 1, 0],
        [0, 1, 2, 3, 2, 0, 1, 0, 1, 1, 0, 0, 0],
        [1, 1, 1, 3, 1, 0, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 2, 3, 1, 1, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 2, 3, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 2, 3, 3, 0, 1, 1, 0, 1, 1, 1, 0],
        [1, 2, 2, 4, 1, 0, 1, 0, 1, 0, 1, 0, 0],
        [1, 1, 0, 4, 1, 1, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 3, 3, 2, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 1, 4, 2, 0, 1, 0, 0, 0, 0, 0, 1],
        [1, 1, 2, 3, 1, 0, 1, 0, 0, 0, 3, 1, 0],
        [1, 1, 0, 1, 0, 0, 1, 0, 0, 0, 1, 1, 1],
        [0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1],
        [0, 1, 1, 3, 1, 1, 1, 0, 1, 1, 1, 0, 0],
        [1, 1, 0, 0, 2, 0, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 2, 4, 1, 0, 1, 0, 0, 0, 0, 0, 1],
        [1, 1, 0, 0, 1, 0, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 2, 0, 2, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 3, 1, 1, 1, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 3, 4, 2, 1, 1, 0, 1, 0, 2, 1, 1],
        [1, 1, 2, 3, 2, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 3, 5, 2, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 1, 5, 1, 0, 1, 0, 0, 0, 2, 0, 0],
        [0, 1, 3, 3, 2, 0, 1, 0, 1, 1, 1, 0, 1],
        [0, 1, 2, 1, 3, 1, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 2, 3, 2, 1, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 0, 5, 0, 0, 1, 0, 1, 1, 1, 1, 1],
        [1, 1, 0, 3, 1, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 2, 4, 2, 0, 1, 0, 1, 1, 2, 0, 1],
        [1, 2, 1, 1, 3, 0, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 2, 3, 2, 1, 1, 0, 1, 1, 1, 0, 0],
        [1, 1, 3, 4, 2, 0, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 0, 4, 2, 1, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 0, 4, 2, 0, 1, 0, 1, 1, 2, 0, 1],
        [1, 1, 3, 3, 1, 0, 1, 0, 1, 1, 0, 1, 0],
        [0, 1, 2, 4, 0, 1, 1, 0, 1, 0, 0, 0, 0],
        [1, 0, 1, 3, 1, 1, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 2, 4, 0, 1, 1, 0, 0, 1, 2, 1, 1],
        [1, 1, 2, 3, 1, 0, 1, 0, 0, 1, 0, 0, 1],
        [1, 1, 2, 4, 1, 0, 1, 0, 0, 0, 0, 1, 1],
        [1, 1, 2, 3, 0, 0, 1, 0, 0, 1, 2, 0, 1],
        [0, 1, 2, 3, 1, 1, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 1, 2, 3, 0, 1, 0, 1, 0, 1, 0, 0],
        [0, 1, 1, 0, 1, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 2, 3, 0, 1, 1, 0, 1, 1, 1, 1, 1],
        [1, 1, 3, 3, 3, 0, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 0, 3, 1, 1, 1, 0, 1, 1, 2, 1, 0],
        [0, 1, 3, 4, 1, 1, 1, 0, 1, 0, 0, 1, 0],
        [1, 1, 0, 3, 2, 1, 1, 0, 0, 1, 2, 0, 0],
        [0, 1, 3, 5, 3, 0, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 2, 1, 2, 1, 1, 0, 0, 1, 1, 0, 1],
        [1, 1, 0, 3, 2, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 1, 1, 2, 1, 1, 0, 1, 0, 1, 1, 1],
        [0, 1, 1, 4, 2, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 1, 1, 3, 1, 1, 1, 0, 0, 1, 1, 1],
        [0, 2, 0, 3, 0, 1, 1, 0, 1, 0, 0, 0, 0],
        [0, 0, 2, 0, 2, 0, 1, 0, 0, 1, 1, 0, 0],
        [1, 0, 2, 4, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 0, 5, 1, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 2, 3, 2, 0, 1, 1, 1, 0, 0, 0, 0],
        [1, 1, 2, 3, 2, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 0, 0, 2, 1, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 2, 4, 1, 1, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 2, 3, 3, 1, 1, 0, 1, 1, 1, 0, 0],
        [0, 1, 1, 3, 1, 0, 1, 1, 1, 0, 0, 1, 0],
        [0, 1, 2, 3, 2, 1, 1, 1, 0, 0, 1, 1, 1],
        [0, 1, 1, 1, 2, 1, 1, 0, 0, 1, 0, 1, 0],
        [1, 0, 2, 4, 0, 1, 1, 0, 1, 0, 1, 1, 0],
        [0, 1, 2, 2, 0, 0, 1, 0, 0, 1, 3, 0, 1],
        [1, 1, 0, 2, 1, 1, 1, 0, 1, 0, 0, 0, 0],
        [1, 2, 2, 3, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 2, 4, 0, 0, 1, 0, 1, 0, 1, 0, 1],
        [0, 1, 2, 2, 2, 0, 0, 0, 0, 0, 1, 1, 1],
        [0, 1, 2, 3, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 3, 1, 2, 1, 1, 0, 0, 0, 1, 1, 1],
        [0, 1, 0, 3, 1, 1, 1, 0, 1, 0, 1, 1, 1],
        [1, 1, 3, 3, 3, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 0, 1, 3, 1, 1, 0, 0, 1, 1, 1, 1],
        [0, 1, 2, 2, 2, 1, 1, 0, 0, 1, 2, 1, 0],
        [0, 1, 1, 3, 3, 0, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 2, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 0, 4, 1, 1, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 0, 4, 2, 1, 1, 0, 0, 1, 2, 0, 1],
        [1, 1, 1, 2, 2, 1, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 2, 4, 0, 1, 1, 0, 0, 0, 1, 1, 1],
        [1, 1, 3, 1, 2, 1, 1, 0, 0, 0, 1, 0, 1],
        [0, 1, 1, 4, 2, 1, 1, 0, 0, 1, 1, 1, 1],
        [0, 1, 1, 4, 0, 0, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 2, 3, 3, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 1, 3, 1, 0, 1, 0, 1, 0, 1, 1, 0],
        [0, 1, 2, 5, 3, 0, 1, 0, 0, 0, 1, 0, 1],
        [0, 2, 2, 3, 2, 1, 1, 1, 1, 0, 2, 0, 0],
        [0, 1, 0, 1, 0, 1, 1, 0, 0, 1, 0, 0, 1],
        [0, 1, 2, 4, 1, 0, 0, 0, 0, 0, 1, 1, 1],
        [0, 1, 1, 5, 3, 0, 1, 0, 1, 0, 1, 1, 0],
        [0, 1, 3, 1, 1, 0, 1, 0, 0, 0, 0, 1, 1],
        [1, 1, 2, 1, 3, 1, 1, 0, 0, 1, 2, 1, 1],
        [1, 1, 0, 1, 1, 0, 1, 0, 0, 0, 2, 0, 0],
        [1, 1, 0, 4, 2, 1, 1, 0, 1, 1, 1, 0, 1],
        [1, 1, 0, 4, 3, 0, 1, 0, 1, 0, 2, 0, 1],
        [0, 1, 2, 4, 2, 0, 1, 0, 1, 1, 1, 1, 0],
        [0, 1, 0, 2, 2, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 0],
        [1, 1, 2, 3, 0, 0, 1, 0, 0, 0, 2, 1, 1],
        [1, 1, 0, 3, 1, 1, 1, 0, 1, 0, 0, 1, 0],
        [1, 1, 2, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1],
        [0, 1, 1, 3, 2, 0, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 2, 1, 2, 0, 1, 0, 0, 0, 2, 1, 1],
        [1, 1, 0, 0, 3, 0, 1, 0, 1, 1, 0, 1, 0],
        [1, 1, 1, 3, 0, 1, 1, 0, 1, 0, 1, 0, 0],
        [0, 1, 0, 1, 0, 1, 1, 0, 0, 0, 0, 0, 1],
        [1, 2, 2, 4, 2, 1, 1, 0, 1, 0, 1, 0, 0],
        [1, 1, 3, 4, 2, 1, 1, 1, 1, 0, 2, 0, 0],
        [1, 1, 2, 4, 2, 0, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 0, 5, 0, 1, 1, 0, 1, 0, 2, 1, 0],
        [0, 1, 3, 2, 1, 1, 1, 0, 1, 1, 1, 0, 0],
        [0, 1, 2, 2, 1, 0, 1, 0, 0, 1, 1, 0, 0],
        [0, 2, 2, 1, 2, 1, 1, 0, 0, 0, 0, 0, 0],
        [0, 1, 3, 0, 3, 0, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 0, 3, 2, 1, 1, 0, 1, 1, 1, 1, 1],
        [1, 0, 3, 4, 1, 0, 1, 1, 0, 0, 1, 0, 1],
        [0, 1, 2, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1],
        [1, 1, 2, 3, 1, 0, 1, 0, 0, 1, 1, 0, 1],
        [0, 1, 2, 3, 1, 0, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 1, 4, 2, 1, 1, 1, 0, 1, 3, 1, 1],
        [0, 2, 1, 4, 3, 1, 1, 0, 1, 0, 1, 1, 0],
        [1, 1, 2, 3, 1, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 0, 4, 2, 1, 1, 0, 1, 0, 1, 0, 1],
        [1, 1, 2, 3, 2, 1, 1, 0, 1, 0, 0, 1, 1],
        [0, 0, 2, 3, 0, 1, 1, 0, 0, 0, 2, 0, 0],
        [0, 1, 0, 3, 0, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 3, 3, 3, 0, 0, 0, 1, 1, 2, 0, 0],
        [0, 1, 0, 2, 0, 1, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 0, 1, 2, 0, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 3, 3, 2, 0, 1, 0, 0, 1, 2, 1, 0],
        [1, 1, 0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 1, 3, 0, 0, 1, 0, 1, 0, 0, 0, 0],
        [0, 1, 2, 0, 3, 1, 1, 0, 0, 0, 2, 0, 0],
        [0, 1, 2, 0, 2, 1, 0, 0, 0, 1, 3, 1, 1],
        [0, 1, 1, 5, 0, 1, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 2, 0, 3, 1, 1, 0, 1, 0, 2, 0, 0],
        [1, 1, 2, 2, 0, 0, 1, 0, 1, 0, 1, 1, 1],
        [0, 1, 2, 3, 0, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 2, 4, 3, 0, 1, 0, 0, 0, 3, 0, 0],
        [1, 1, 0, 3, 2, 0, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 2, 4, 0, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 0, 0, 1, 2, 0, 1, 0, 0, 0, 0, 1, 1],
        [0, 1, 1, 4, 0, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 3, 2, 2, 1, 1, 0, 0, 0, 2, 1, 1],
        [0, 1, 0, 1, 1, 1, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 0, 3, 2, 1, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 2, 5, 3, 0, 1, 0, 1, 1, 1, 1, 0],
        [0, 1, 1, 4, 1, 0, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 2, 1, 0, 0, 1, 0, 0, 1, 3, 1, 1],
        [0, 1, 2, 5, 1, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 2, 1, 3, 1, 1, 0, 0, 0, 0, 1, 1],
        [1, 1, 3, 5, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 0, 4, 2, 1, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 3, 3, 3, 1, 1, 0, 1, 0, 1, 0, 0],
        [0, 1, 0, 0, 3, 0, 1, 0, 0, 1, 0, 1, 0],
        [0, 1, 3, 1, 3, 0, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 2, 3, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 3, 3, 1, 0, 1, 0, 1, 1, 1, 1, 1],
        [1, 1, 2, 0, 2, 0, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 3, 0, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 3, 3, 3, 1, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 2, 3, 2, 1, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 2, 3, 0, 1, 1, 0, 1, 1, 1, 1, 1],
        [0, 1, 1, 2, 0, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 1, 1, 2, 0, 1, 0, 0, 1, 2, 1, 0],
        [0, 1, 1, 1, 2, 0, 1, 0, 0, 0, 0, 0, 0],
        [0, 1, 3, 3, 0, 0, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 2, 3, 2, 1, 1, 0, 0, 0, 1, 1, 1],
        [1, 2, 1, 3, 1, 1, 1, 0, 0, 1, 2, 1, 0],
        [1, 1, 3, 4, 1, 0, 1, 1, 0, 0, 1, 1, 0],
        [1, 2, 1, 3, 1, 0, 1, 0, 0, 0, 3, 1, 0],
        [1, 1, 2, 5, 0, 1, 0, 0, 1, 0, 0, 0, 0],
        [1, 1, 0, 4, 3, 1, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 2, 4, 3, 1, 1, 0, 1, 0, 0, 1, 0],
        [1, 1, 3, 0, 1, 0, 1, 1, 0, 0, 1, 1, 1],
        [1, 1, 1, 1, 0, 1, 1, 0, 0, 1, 0, 1, 0],
        [0, 1, 0, 3, 3, 1, 1, 0, 0, 0, 0, 0, 1],
        [0, 1, 2, 1, 3, 0, 1, 0, 0, 0, 2, 0, 0],
        [1, 1, 0, 3, 3, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 1, 4, 3, 1, 1, 0, 0, 0, 1, 1, 1],
        [1, -1, 1, 1, 0, 1, 1, 0, 0, 1, 0, 1, 1],
        [0, 1, 0, 0, 1, 0, 1, 0, 1, 1, 1, 1, 0],
        [0, 1, 2, 4, 3, 1, 1, 0, 0, 0, 3, 0, 0],
        [1, 1, 2, 5, 1, 1, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 3, 2, 1, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 0, 2, 2, 1, 1, 0, 0, 1, 2, 0, 1],
        [1, 1, 2, 3, 2, 1, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 2, 4, 2, 1, 1, 0, 0, 1, 1, 0, 1],
        [1, 1, 1, 3, 1, 1, 2, 0, 0, 1, 1, 0, 0],
        [1, 1, 2, 4, 3, 1, 1, 0, 0, 1, 0, 1, 1],
        [1, 1, 2, 3, 0, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 2, 1, 2, 0, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 1, 5, 1, 1, 1, 0, 1, 1, 1, 0, 0],
        [0, 1, 1, 4, 0, 0, 2, 0, 0, 0, 1, 1, 1],
        [1, 1, 0, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0],
        [0, 1, 1, 5, 3, 1, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 1, 3, 1, 1, 1, 0, 1, 0, 1, 0, 0],
        [1, 1, 1, 2, 1, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 2, 0, 2, 0, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 2, 5, 0, 1, 1, 0, 1, 0, 0, 0, 1],
        [0, 1, 3, 3, 1, 1, 1, 0, 1, 0, 3, 0, 0],
        [0, 1, 1, 3, 2, 1, 1, 0, 1, 1, 1, 0, 0],
        [0, 1, 0, 0, 2, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 2, 0, 2, 0, 1, 1, 0, 1, 1, 0, 0, 0],
        [0, 1, 1, 3, 0, 0, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 3, 3, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 3, 1, 3, 1, 1, 0, 0, 0, 1, 1, 1],
        [0, 1, 2, 3, 2, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 2, 1, 3, 1, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 3, 4, 1, 1, 1, 1, 1, 0, 0, 1, 1],
        [1, 1, 0, 1, 3, 1, 1, 0, 0, 0, 0, 1, 1],
        [1, 1, 0, 1, 1, 1, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 3, 3, 1, 1, 1, 0, 0, 0, 0, 1, 0],
        [0, 0, 1, 3, 2, 1, 2, 0, 0, 1, 3, 0, 0],
        [0, 1, 2, 3, 2, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 0, 3, 3, 0, 1, 0, 1, 0, 2, 1, 0],
        [1, 1, 2, 5, 3, 1, 1, 0, 1, 0, 0, 0, 0],
        [1, 1, 3, 4, 2, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 2, 4, 3, 0, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 3, 4, 0, 1, 1, 0, 1, 1, 1, 1, 1],
        [1, 0, 2, 3, 0, 1, 1, 0, 0, 0, 2, 0, 1],
        [0, 1, 0, 4, 3, 1, 1, 0, 0, 0, 2, 0, 1],
        [0, 1, 1, 0, 3, 1, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 0, 5, 0, 1, 1, 0, 0, 0, 2, 1, 1],
        [0, 1, 2, 4, 1, 1, 1, 0, 1, 0, 1, 0, 0],
        [1, 1, 0, 4, 1, 0, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 0, 3, 1, 0, 1, 0, 0, 1, 2, 1, 0],
        [1, 1, 0, 5, 1, 1, 1, 0, 0, 0, 3, 1, 0],
        [1, 1, 1, 1, 0, 1, 1, 0, 1, 0, 1, 1, 0],
        [0, 0, 1, 3, 0, 0, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 0, 1, 0, 1, 1, 0, 0, 1, 1, 1, 1],
        [0, 1, 2, 3, 2, 0, 1, 0, 0, 1, 1, 0, 0],
        [0, 2, 2, 3, 2, 1, 1, 0, 0, 1, 0, 1, 0],
        [0, 1, 0, 1, 1, 0, 2, 0, 0, 1, 1, 1, 0],
        [0, 1, 1, 1, 1, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 3, 0, 1, 0, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 2, 0, 1, 1, 1, 0, 1, 1, 2, 0, 0],
        [0, 1, 2, 3, 0, 0, 1, 0, 0, 0, 1, 1, 1],
        [0, 1, 2, 3, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 3, 2, 0, 1, 1, 0, 0, 0, 2, 0, 0],
        [0, 1, 3, 3, 0, 1, 1, 1, 0, 1, 0, 1, 1],
        [1, 2, 0, 3, 1, 0, 1, 0, 1, 1, 0, 1, 0],
        [1, 1, 0, 3, 2, 1, 1, 0, 0, 0, 2, 0, 1],
        [0, 1, 2, 3, 1, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 1, 3, 1, 0, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 3, 1, 2, 1, 1, 0, 1, 1, 2, 0, 1],
        [1, 1, 1, 0, 1, 0, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 2, 3, 2, 1, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 1, 3, 2, 1, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 0, 3, 1, 1, 1, 0, 1, 1, 0, 0, 0],
        [1, 1, 0, 4, 0, 0, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 2, 5, 2, 0, 1, 0, 0, 0, 0, 0, 0],
        [0, 1, 0, 3, 1, 0, 1, 0, 1, 0, 2, 1, 0],
        [0, 1, 0, 4, 2, 1, 1, 0, 0, 1, 2, 1, 1],
        [1, 1, 2, 3, 0, 1, 1, 0, 0, 1, 3, 1, 0],
        [0, 1, 3, 3, 1, 1, 1, 0, 1, 0, 0, 0, 0],
        [1, 1, 1, 2, 1, 1, 1, 0, 0, 0, 3, 0, 1],
        [0, 1, 3, 3, 2, 0, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 2, 2, 1, 1, 1, 0, 1, 0, 1, 1, 0],
        [1, 1, 2, 4, 1, 1, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 0, 3, 1, 1, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 0, 5, 1, 1, 1, 0, 0, 1, 3, 0, 0],
        [0, 1, 2, 2, 3, 1, 1, 0, 1, 0, 1, 0, 0],
        [0, 1, 2, 3, 0, 0, 1, 0, 0, 0, 1, 1, 1],
        [1, 1, 2, 4, 0, 1, 1, 0, 1, 1, 1, 1, 1],
        [0, 1, 1, 3, 0, 1, 1, 0, 1, 0, 2, 1, 0],
        [1, 1, 2, 4, 2, 1, 1, 0, 0, 1, 1, 0, 1],
        [0, 1, 1, 5, 3, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1],
        [1, 2, 2, 3, 1, 0, 1, 0, 1, 0, 0, 1, 0],
        [1, 1, 2, 1, 2, 1, 1, 0, 1, 0, 0, 0, 0],
        [0, 1, 1, 3, 3, 1, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 0, 2, 2, 0, 1, 0, 0, 0, 0, 0, 1],
        [1, 1, 2, 2, 1, 0, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 0, 3, 2, 1, 1, 0, 0, 0, 1, 1, 1],
        [0, 1, 3, 1, 1, 1, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 1, 4, 2, 0, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 0, 3, 0, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 0, 4, 2, 1, 1, 0, 0, 0, 1, 1, 1],
        [1, 1, 0, 1, 1, 1, 1, 1, 0, 0, 1, 0, 0],
        [0, 1, 0, 3, 3, 1, 1, 0, 1, 0, 1, 0, 0],
        [1, 1, 3, 1, 1, 1, 1, 0, 0, 1, 3, 0, 0],
        [1, 1, 0, 4, 3, 1, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 1, 3, 2, 0, 1, 0, 0, 1, 0, 0, 1],
        [1, 1, 2, 4, 1, 1, 1, 0, 1, 1, 1, 0, 1],
        [1, 1, 2, 3, 3, 0, 1, 0, 0, 1, 1, 1, 1],
        [0, 2, 3, 3, 1, 0, 1, 0, 1, 0, 1, 0, 0],
        [1, 0, 0, 3, 1, 0, 1, 0, 0, 1, 3, 1, 1],
        [0, 1, 2, 3, 3, 0, 1, 0, 1, 0, 1, 0, 0],
        [1, 1, 1, 3, 0, 1, 1, 0, 0, 0, 2, 0, 0],
        [0, 1, 3, 4, 1, 1, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 2, 0, 3, 0, 1, 0, 1, 0, 1, 0, 0],
        [0, 1, 0, 3, 2, 0, 1, 0, 1, 0, 3, 1, 1],
        [1, 1, 2, 4, 0, 1, 1, 0, 0, 0, 2, 1, 0],
        [0, 2, 0, 4, 1, 1, 1, 0, 0, 0, 2, 0, 0],
        [1, 1, 1, 0, 2, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 2, 3, 0, 1, 1, 0, 0, 0, 1, 1, 1],
        [1, 1, 0, 1, 1, 1, 1, 0, 0, 0, 2, 0, 1],
        [1, 1, 2, 0, 2, 1, 1, 0, 1, 0, 3, 0, 0],
        [1, 1, 0, 4, 1, 1, 1, 0, 0, 1, 3, 0, 0],
        [0, 1, 1, 0, 3, 1, 1, 0, 1, 1, 1, 1, 1],
        [1, 1, 1, 2, 1, 0, 2, 0, 0, 0, 2, 0, 0],
        [1, 1, 2, 4, 1, 1, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 2, 2, 0, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 2, 1, 3, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 1, 5, 1, 1, 1, 0, 1, 1, 1, 0, 0],
        [1, 1, 2, 3, 3, 1, 1, 0, 1, 1, 2, 0, 0],
        [1, 1, 0, 5, 1, 1, 1, 0, 1, 1, 1, 1, 0],
        [1, 1, 2, 4, 2, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 0, 3, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 0, 1, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 2, 3, 1, 0, 1, 0, 0, 1, 3, 0, 0],
        [0, 1, 1, 3, 0, 0, 1, 0, 0, 0, 2, 0, 0],
        [1, 1, 2, 3, 0, 1, 1, 0, 0, 0, 0, 0, 0],
        [0, 1, 2, 4, 3, 0, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 2, 4, 1, 1, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 0, 4, 0, 1, 1, 0, 0, 0, 0, 0, 1],
        [1, 1, 0, 3, 1, 0, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 2, 3, 2, 0, 1, 0, 1, 0, 1, 1, 1],
        [0, 1, 0, 3, 3, 1, 1, 0, 1, 1, 1, 0, 0],
        [0, 1, 2, 4, 2, 1, 1, 0, 1, 0, 2, 0, 1],
        [0, 1, 1, 4, 1, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 3, 4, 1, 0, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 2, 0, 3, 0, 1, 0, 0, 1, 2, 1, 0],
        [0, 1, 1, 1, 1, 0, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 3, 4, 3, 0, 1, 1, 0, 0, 2, 1, 1],
        [0, 1, 2, 2, 0, 1, 1, 0, 1, 1, 1, 1, 0],
        [0, 1, 2, 5, 1, 1, 1, 1, 0, 1, 1, 0, 0],
        [0, 1, 3, 3, 2, 1, 1, 0, 1, 1, 0, 1, 0],
        [0, 1, 3, 4, 2, 1, 1, 0, 0, 1, 0, 1, 1],
        [0, 1, 2, 3, 2, 0, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 2, 2, 3, 1, 1, 0, 0, 1, 0, 0, 1],
        [1, 1, 2, 1, 1, 1, 1, 0, 1, 1, 1, 0, 1],
        [0, 1, 0, 3, 3, 0, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 3, 3, 2, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 0, 3, 1, 0, 1, 0, 0, 0, 1, 1, 1],
        [0, 1, 0, 3, 2, 0, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 0, 0, 1, 1, 2, 0, 0, 1, 2, 1, 0],
        [0, 1, 1, 3, 3, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 0, 1, 2, 0, 1, 0, 0, 0, 2, 1, 0],
        [1, 0, 0, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1],
        [1, 1, 2, 4, 2, 0, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 3, 4, 2, 1, 1, 0, 1, 0, 2, 0, 0],
        [0, 1, 2, 0, 1, 1, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 3, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1],
        [1, 2, 1, 1, 2, 1, 1, 0, 0, 1, 0, 0, 1],
        [0, 1, 2, 4, 1, 1, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 2, 1, 0, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 3, 4, 1, 0, 1, 0, 1, 1, 2, 0, 0],
        [1, 1, 1, 0, 1, 0, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 2, 4, 2, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 1, 4, 1, 1, 1, 0, 0, 0, 0, 0, 1],
        [0, 1, 2, 0, 0, 1, 1, 0, 1, 1, 1, 1, 0],
        [1, 1, 2, 3, 0, 1, 1, 0, 0, 1, 1, 0, 1],
        [1, 1, 2, 3, 1, 0, 1, 0, 1, 0, 1, 0, 0],
        [0, 1, 1, 3, 2, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 2, 3, 4, 0, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 2, 4, 2, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 3, 0, 1, 0, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 1, 5, 1, 1, 1, 0, 1, 1, 1, 0, 0],
        [0, 1, 1, 3, 1, 1, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 3, 4, 1, 1, 1, 0, 0, 0, 1, 1, 1],
        [1, 1, 2, 0, 2, 0, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 2, 4, 1, 1, 1, 0, 0, 1, 3, 1, 0],
        [0, 1, 1, 1, 3, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 0, 3, 2, 1, 1, 0, 0, 0, 0, 1, 1],
        [1, 2, 0, 4, 1, 0, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 0, 1, 3, 1, 1, 0, 1, 0, 1, 0, 0],
        [0, 1, 0, 3, 2, 0, 0, 0, 0, 0, 0, 0, 0],
        [0, 1, 2, 4, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 3, 4, 2, 1, 1, 0, 0, 0, 0, 0, 0],
        [0, 1, 3, 1, 3, 1, 1, 1, 1, 0, 2, 0, 0],
        [0, 1, 1, 3, 0, 0, 1, 0, 1, 0, 2, 1, 0],
        [0, 1, 2, 5, 1, 1, 1, 0, 1, 1, 1, 1, 1],
        [1, 1, 1, 2, 0, 0, 1, 0, 0, 1, 1, 0, 1],
        [1, 1, 3, 5, 1, 0, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 2, 3, 2, 1, 2, 1, 1, 0, 1, 1, 1],
        [0, 1, 2, 3, 0, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 0, 4, 2, 0, 1, 0, 0, 1, 1, 0, 1],
        [0, 1, 1, 1, 3, 1, 2, 0, 1, 1, 2, 1, 1],
        [1, 1, 0, 4, 2, 1, 1, 0, 1, 0, 1, 1, 0],
        [1, 1, 2, 3, 0, 0, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 2, 3, 1, 0, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 1, 4, 1, 0, 1, 0, 0, 0, 3, 0, 0],
        [1, 1, 2, 4, 0, 0, 1, 0, 0, 1, 1, 0, 1],
        [0, 1, 2, 3, 2, 0, 1, 0, 0, 1, 2, 0, 0],
        [0, 1, 0, 2, 0, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 2, 0, 2, 1, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 2, 4, 0, 0, 1, 0, 0, 1, 3, 0, 0],
        [0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 2, 4, 3, 0, 1, 0, 0, 0, 0, 1, 1],
        [1, 1, 1, 5, 3, 1, 1, 0, 1, 1, 1, 0, 0],
        [1, 1, 2, 2, 2, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 1, 1, 0, 1, 1, 1, 0, 0, 1, 0, 0],
        [1, 1, 0, 4, 0, 0, 1, 1, 0, 1, 2, 1, 1],
        [1, 1, 0, 4, 2, 0, 1, 0, 0, 0, 0, 1, 1],
        [0, 1, 2, 3, 1, 0, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 1, 2, 0, 1, 1, 0, 0, 1, 2, 0, 0],
        [0, 1, 2, 0, 3, 0, 1, 0, 1, 1, 2, 1, 1],
        [0, 1, 1, 3, 3, 1, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 2, 1, 2, 1, 1, 0, 0, 0, 0, 0, 1],
        [1, 1, 1, 4, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 2, 3, 2, 0, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 0, 4, 1, 1, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 3, 3, 2, 1, 1, 0, 1, 0, 0, 1, 0],
        [1, 1, 0, 1, 1, 1, 1, 0, 0, 1, 2, 0, 0],
        [0, 1, 1, 1, 0, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 2, 3, 3, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 3, 5, 2, 0, 1, 0, 0, 1, 3, 0, 0],
        [0, 1, 2, 3, 1, 1, 1, 0, 1, 1, 2, 0, 0],
        [0, 1, 1, 3, 1, 1, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 0, 1, 1, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 2, 3, 2, 0, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 1, 3, 2, 0, 1, 0, 0, 1, 1, 0, 1],
        [0, 1, 3, 4, 1, 0, 1, 0, 0, 0, 1, 0, 1],
        [0, 1, 2, 5, 2, 1, 1, 0, 1, 0, 1, 0, 1],
        [1, 0, 2, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 1, 2, 1, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 0, 3, 3, 1, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 0, 2, 1, 0, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 1, 0, 3, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 3, 2, 1, 1, 1, 0, 0, 0, 1, 1, 1],
        [0, 2, 2, 2, 0, 0, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 2, 2, 2, 0, 1, 0, 1, 0, 0, 1, 0],
        [0, 1, 3, 5, 2, 0, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 2, 4, 1, 1, 1, 1, 0, 1, 1, 0, 0],
        [1, 1, 1, 3, 0, 1, 1, 0, 1, 1, 2, 1, 0],
        [0, 1, 1, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 2, 4, 0, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 2, 4, 1, 0, 1, 0, 0, 0, 0, 0, 1],
        [1, 1, 3, 2, 1, 1, 1, 0, 0, 1, 1, 1, 1],
        [0, 1, 2, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 0, 3, 0, 0, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 3, 3, 1, 1, 1, 0, 0, 0, 3, 0, 0],
        [1, 1, 3, 3, 2, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 1, 4, 2, 1, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 2, 4, 3, 1, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 2, 3, 2, 0, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 0, 5, 3, 0, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 3, 4, 1, 1, 1, 0, 1, 0, 0, 0, 0],
        [1, 0, 2, 5, 3, 0, 1, 0, 0, 1, 2, 1, 1],
        [0, 1, 2, 4, 0, 1, 1, 0, 0, 0, 3, 1, 1],
        [0, 1, 0, 1, 1, 0, 1, 0, 1, 1, 0, 1, 0],
        [0, 1, 3, 4, 1, 1, 1, 0, 1, 1, 2, 0, 0],
        [0, 1, 3, 0, 3, 0, 1, 0, 1, 1, 1, 1, 0],
        [0, 1, 0, 3, 1, 1, 1, 0, 1, 0, 0, 0, 0],
        [0, 1, 2, 1, 1, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 3, 3, 1, 0, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 2, 4, 3, 1, 1, 0, 1, 1, 0, 0, 1],
        [0, 1, 2, 4, 3, 0, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 0, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1],
        [0, 1, 0, 0, 1, 0, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 3, 3, 2, 1, 1, 0, 0, 1, 2, 1, 0],
        [1, 1, 0, 1, 1, 1, 1, 0, 0, 0, 2, 1, 0],
        [0, 0, 2, 3, 2, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 3, 3, 2, 1, 1, 0, 0, 1, 2, 0, 1],
        [0, 1, 2, 5, 2, 1, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1],
        [0, 1, 2, 1, 2, 1, 1, 0, 0, 1, 1, 0, 1],
        [1, 1, 2, 1, 2, 0, 1, 0, 0, 0, 0, 0, 1],
        [1, 1, 3, 4, 2, 1, 1, 0, 0, 1, 2, 0, 0],
        [0, 1, 2, 3, 3, 1, 1, 0, 1, 1, 1, 1, 1],
        [0, 1, 2, 3, 1, 1, 1, 0, 0, 1, 3, 1, 1],
        [0, 1, 2, 3, 1, 1, 1, 0, 0, 0, 3, 1, 0],
        [0, 1, 2, 4, 3, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 3, 5, 1, 0, 1, 0, 1, 0, 2, 1, 0],
        [1, 1, 0, 5, 3, 1, 2, 0, 1, 0, 2, 0, 1],
        [1, 1, 2, 4, 0, 1, 1, 0, 0, 0, 2, 1, 1],
        [1, 1, 1, 4, 1, 1, 1, 0, 1, 0, 1, 1, 1],
        [1, 1, 3, 3, 3, 1, 2, 0, 0, 0, 2, 0, 0],
        [1, 1, 2, 5, 1, 1, 1, 0, 0, 0, 3, 1, 0],
        [1, 1, 3, 5, 1, 1, 1, 1, 0, 1, 1, 0, 0],
        [0, 1, 0, 4, 0, 0, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 0, 4, 1, 1, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 1, 3, 0, 0, 1, 0, 0, 0, 3, 1, 0],
        [1, 1, 2, 4, 2, 1, 1, 0, 1, 0, 1, 0, 1],
        [0, 1, 2, 0, 0, 1, 1, 0, 0, 1, 2, 1, 0],
        [1, 1, 3, 1, 3, 1, 1, 0, 1, 1, 1, 1, 1],
        [1, 0, 0, 1, 2, 1, 1, 0, 1, 0, 1, 0, 1],
        [0, 1, 1, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 3, 0, 2, 1, 1, 1, 0, 1, 1, 0, 0],
        [0, 1, 2, 4, 2, 1, 2, 0, 0, 1, 1, 1, 1],
        [0, 2, 2, 4, 0, 1, 1, 0, 0, 0, 2, 0, 0],
        [0, 1, 2, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1],
        [1, 1, 1, 1, 3, 0, 2, 0, 0, 0, 3, 0, 0],
        [1, 1, 1, 3, 1, 1, 1, 0, 1, 1, 2, 0, 0],
        [0, 1, 1, 0, 3, 0, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 2, 4, 2, 1, 1, 0, 0, 0, 1, 0, 1],
        [0, 1, 2, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 2, 3, 2, 0, 1, 0, 0, 1, 0, 1, 0],
        [0, 1, 1, 3, 0, 0, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 2, 3, 1, 1, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 1, 4, 1, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 0, 3, 5, 0, 1, 1, 0, 0, 0, 1, 1, 1],
        [0, 2, 0, 4, 2, 0, 1, 0, 1, 1, 1, 0, 0],
        [1, 1, 2, 3, 1, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 1, 3, 1, 0, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 1, 3, 1, 0, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 0, 3, 1, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 2, 2, 4, 0, 1, 1, 0, 1, 0, 2, 1, 0],
        [1, 1, 1, 4, 1, 1, 1, 0, 1, 0, 1, 1, 0],
        [1, 1, 0, 4, 3, 1, 1, 0, 1, 1, 0, 1, 0],
        [0, 1, 0, 3, 3, 0, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 1, 3, 2, 1, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 3, 2, 3, 1, 1, 0, 1, 1, 2, 1, 1],
        [1, 1, 1, 3, 2, 1, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 2, 4, 3, 1, 1, 0, 1, 1, 1, 0, 0],
        [1, 1, 2, 4, 2, 0, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 1, 4, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 2, 3, 0, 1, 1, 0, 0, 1, 1, 0, 1],
        [1, 1, 3, 3, 1, 0, 1, 0, 1, 1, 1, 0, 0],
        [0, 1, 1, 3, 3, 0, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 1, 1, 1, 0, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 2, 4, 2, 1, 1, 0, 0, 0, 0, 1, 1],
        [1, 1, 0, 3, 3, 0, 1, 0, 0, 0, 3, 0, 0],
        [0, 1, 2, 3, 3, 0, 1, 0, 0, 1, -1, 0, 0],
        [0, 1, 2, 5, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 0, 4, 2, 0, 2, 0, 0, 0, 2, 1, 0],
        [1, 0, 3, 4, 0, 0, 1, 0, 0, 1, 2, 1, 0],
        [0, 1, 1, 1, 3, 1, 1, 0, 1, 1, 1, 1, 1],
        [0, 1, 0, 5, 0, 1, 1, 0, 0, 1, 2, 0, 0],
        [0, 1, 3, 4, 2, 1, 1, 0, 1, 1, 0, 1, 1],
        [1, 1, 3, 3, 0, 1, 1, 0, 0, 1, 2, 1, 0],
        [0, 1, 2, 3, 3, 0, 1, 0, 0, 1, 3, 0, 0],
        [0, 1, 3, 3, 3, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 1, 2, 0, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 1, 3, 1, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 2, 5, 3, 0, 1, 0, 0, 0, 1, 0, 1],
        [0, 1, 3, 5, 1, 0, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 0, 4, 2, 0, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 1, 3, 1, 1, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 1, 3, 3, 1, 0, 0, 0, 0, 0, 0, 0],
        [1, 1, 2, 2, 1, 1, 2, 0, 0, 1, 3, 0, 0],
        [1, 1, 0, 3, 3, 1, 1, 1, 0, 0, 1, 1, 0],
        [1, 1, 2, 4, 1, 1, 1, 0, 0, 0, 2, 0, 1],
        [1, 1, 2, 2, 3, 1, 1, 0, 0, 1, 2, 1, 0],
        [1, 0, 1, 3, 1, 1, 1, 0, 1, 0, 0, 0, 0],
        [0, 1, 2, 3, 1, 1, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 2, 3, 2, 1, 1, 0, 0, 1, 2, 1, 1],
        [0, 1, 1, 0, 2, 1, 1, 0, 1, 1, 1, 0, 0],
        [1, 1, 0, 4, 2, 0, 1, 0, 0, 1, 1, 1, 1],
        [0, 1, 1, 3, 1, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 3, 1, 3, 1, 1, 0, 0, 1, 1, 0, 1],
        [1, 1, 1, 3, 3, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 1, 5, 1, 1, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 0, 3, 1, 0, 1, 0, 0, 1, 0, 1, 0],
        [0, 1, 3, 3, 1, 1, 2, 0, 1, 1, 1, 1, 1],
        [1, 1, 3, 1, 1, 1, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 2, 1, 2, 0, 1, 0, 0, 0, 1, 1, 1],
        [1, 1, 3, 3, 3, 1, 1, 0, 1, 0, 3, 1, 1],
        [1, 1, 3, 1, 2, 1, 1, 0, 0, 0, 0, 0, 1],
        [0, 1, 2, 4, 3, 1, 1, 1, 0, 1, 0, 0, 1],
        [1, 1, 1, 3, 1, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 0, 3, 1, 0, 2, 0, 0, 0, 1, 0, 0],
        [0, 1, 2, 4, 0, 1, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 1, 3, 2, 1, 1, 0, 1, 0, 1, 0, 0],
        [1, 2, 1, 5, 3, 1, 1, 0, 0, 0, 2, 0, 0],
        [1, 1, 2, 3, 0, 1, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 2, 0, 2, 0, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 3, 1, 2, 1, 1, 1, 0, 1, 1, 1, 1],
        [0, 2, 0, 0, 0, 1, 1, 0, 0, 0, 3, 0, 0],
        [0, 1, 1, 0, 2, 1, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 0, 3, 2, 1, 1, 0, 0, 0, 0, 0, 0],
        [0, 1, 0, 0, 0, 1, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 0, 1, 0, 0, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 2, 1, 2, 0, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 0, 1, 2, 1, 1, 0, 0, 1, 1, 1, 1],
        [0, 1, 2, 5, 3, 0, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 2, 4, 0, 0, 1, 0, 1, 1, 0, 1, 1],
        [1, 1, 3, 0, 1, 0, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 2, 4, 2, 0, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 1, 0, 2, 0, 1, 0, 0, 0, 1, 1, 1],
        [0, 1, 1, 3, 1, 1, 1, 1, 0, 0, 1, 1, 0],
        [1, 2, 1, 3, 2, 0, 1, 0, 1, 0, 2, 1, 0],
        [0, 1, 0, 3, 1, 0, 2, 0, 1, 0, 3, 0, 0],
        [1, 1, 0, 1, 1, 0, 1, 0, 1, 1, 0, 1, 0],
        [0, 1, 1, 3, 1, 0, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 0, 3, 3, 1, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 1, 1, 1, 1, 2, 0, 0, 0, 3, 1, 1],
        [1, 1, 3, 3, 2, 0, 1, 0, 1, 1, 1, 0, 1],
        [0, 1, 3, 4, 2, 1, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 0, 4, 0, 1, 1, 0, 0, 1, 1, 1, 1],
        [0, 1, 2, 4, 2, 0, 1, 0, 1, 1, 1, 0, 0],
        [0, 1, 0, 4, 1, 1, 1, 0, 0, 0, 2, 0, 0],
        [1, 1, 2, 2, 0, 1, 1, 0, 0, 1, 2, 0, 1],
        [0, 2, 0, 2, 1, 1, 1, 0, 1, 0, 0, 0, 1],
        [1, 1, 1, 1, 0, 0, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 2, 1, 1, 0, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 1, 3, 2, 1, 1, 0, 1, 1, 1, 1, 1],
        [1, 2, 0, 4, 3, 1, 1, 0, 1, 0, 1, 0, 0],
        [1, 0, 1, 5, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 0, 3, 0, 1, 1, 0, 0, 0, 0, 0, 0],
        [0, 1, 0, 5, 3, 1, 0, 0, 0, 0, 0, 1, 1],
        [1, 1, 2, 4, 2, 1, 1, 0, 0, 0, 0, 1, 1],
        [0, 1, 0, 3, 1, 0, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 0, 4, 1, 0, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 1, 3, 0, 1, 1, 0, 0, 0, 0, 0, 0],
        [0, 1, 0, 3, 3, 0, 1, 0, 0, 0, 0, 0, 0],
        [0, 2, 1, 3, 3, 1, 1, 0, 0, 0, 3, 0, 0],
        [0, 1, 2, 5, 0, 0, 1, 0, 1, 0, 0, 1, 0],
        [0, 1, 2, 3, 0, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 0, 1, 1, 1, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 2, 1, 2, 1, 1, 0, 1, 1, 0, 0, 0],
        [1, 0, 2, 3, 3, 0, 1, 0, 0, 0, 0, 1, 1],
        [1, 1, 2, 4, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 3, 2, 0, 1, 1, 0, 0, 0, 3, 0, 1],
        [1, 1, 1, 3, 0, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 2, 3, 1, 0, 1, 1, 0, 0, 0, 0, 0],
        [1, 1, 0, 3, 3, 1, 2, 0, 0, 0, 3, 0, 0],
        [1, 1, 1, 1, 2, 0, 1, 0, 1, 1, 0, 0, 1],
        [0, 1, 3, 2, 1, 1, 1, 0, 1, 0, 1, 1, 0],
        [1, 1, 3, 4, 0, 0, 1, 0, 0, 1, 0, 0, 0],
        [1, 0, 2, 4, 0, 0, 1, 0, 0, 1, 1, 0, 1],
        [0, 1, 3, 3, 0, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 2, 0, 4, 1, 1, 1, 0, 0, 0, 1, 0, 1],
        [0, 1, 0, 3, 1, 0, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 3, 2, 1, 1, 1, 1, 0, 0, 0, 0, 1],
        [0, 1, 3, 3, 1, 1, 1, 0, 0, 0, 2, 0, 0],
        [1, 1, 3, 4, 3, 1, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 2, 3, 0, 0, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 0, 3, 1, 1, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 2, 2, 2, 0, 1, 0, 0, 1, 2, 0, 1],
        [1, 1, 3, 3, 0, 0, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 3, 2, 2, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 1, 5, 3, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 3, 1, 0],
        [0, 1, 0, 4, 2, 0, 2, 0, 0, 0, 0, 1, 1],
        [0, 0, 1, 3, 0, 0, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 1, 2, 1, 1, 1, 0, 0, 1, 2, 1, 0],
        [0, 1, 2, 3, 0, 0, 1, 0, 0, 1, 2, 0, 1],
        [0, 1, 0, 3, 3, 0, 1, 0, 1, 1, 1, 1, 1],
        [1, 1, 2, 3, 2, 0, 1, 0, 1, 0, 1, 0, 1],
        [1, 1, 3, 3, 1, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 3, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 2, 3, 1, 0, 1, 0, 1, 1, 1, 0, 0],
        [0, 1, 2, 3, 0, 0, 1, 0, 0, 1, 3, 1, 0],
        [1, 1, 2, 4, 1, 0, 1, 0, 1, 0, 2, 0, 1],
        [1, 1, 3, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 2, 1, 3, 1, 1, 0, 1, 0, 1, 0, 1],
        [1, 1, 1, 5, 1, 0, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 1, 4, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 1, 0, 1, 1, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 0, 4, 3, 1, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 1, 4, 1, 1, 1, 1, 0, 0, 1, 1, 1],
        [0, 1, 3, 1, 0, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 0, 3, 1, 0, 1, 0, 0, 0, 1, 0, 1],
        [0, 1, 1, 3, 3, 0, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 1, 4, 1, 0, 1, 0, 0, 1, 2, 1, 0],
        [1, 1, 1, 1, 3, 1, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 0, 1, 1, 0, 1, 0, 0, 0, 1, 1, 1],
        [1, 1, 2, 4, 2, 0, 1, 0, 0, 0, 0, 0, 1],
        [0, 1, 3, 2, 3, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 1, 3, 1, 0, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 2, 0, 1, 1, 2, 0, 0, 1, 2, 0, 1],
        [0, 1, 2, 5, 0, 1, 2, 0, 1, 0, 0, 0, 0],
        [1, 1, 0, 3, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 0, 3, 1, 0, 1, 0, 1, 1, 1, 1, 1],
        [0, 2, 1, 3, 1, 1, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 2, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1],
        [0, 1, 0, 4, 1, 0, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 2, 4, 3, 1, 1, 0, 0, 1, 3, 1, 1],
        [0, 0, 2, 1, 2, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 1, 3, 3, 1, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 2, 3, 1, 1, 1, 0, 0, 1, 3, 1, 1],
        [1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 0],
        [1, 1, 2, 1, 0, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 1, 3, 3, 1, 1, 0, 1, 1, 3, 1, 0],
        [0, 1, 2, 2, 2, 1, 1, 0, 1, 1, 2, 0, 1],
        [0, 1, 2, 3, 0, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 3, 5, 1, 1, 1, 0, 1, 0, 2, 0, 0],
        [0, 1, 0, 2, 1, 1, 1, 0, 0, 0, 2, 0, 0],
        [1, 1, 2, 3, 1, 0, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 0, 4, 0, 1, 1, 0, 0, 1, 2, 1, 0],
        [1, 1, 1, 3, 1, 1, 1, 0, 1, 1, 1, 1, 1],
        [1, 1, 1, 3, 0, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 0, 5, 2, 1, 1, 0, 1, 0, 0, 0, 0],
        [0, 1, 2, 4, 3, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 2, 4, 0, 1, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 3, 2, 0, 1, 1, 0, 0, 1, 2, 0, 0],
        [0, 1, 2, 3, 2, 0, 1, 0, 1, 0, 2, 0, 1],
        [1, 1, 2, 3, 2, 1, 1, 0, 0, 0, 3, 1, 1],
        [1, 1, 0, 5, 1, 0, 1, 1, 1, 0, 2, 0, 0],
        [0, 1, 3, 1, 0, 0, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 0, 0, 3, 1, 1, 0, 0, 0, 0, 0, 1],
        [0, 1, 0, 1, 0, 0, 1, 0, 0, 1, 2, 1, 0],
        [0, 1, 2, 4, 1, 1, 1, 0, 1, 0, 1, 0, 0],
        [0, 1, 3, 1, 3, 1, 2, 0, 1, 0, 3, 0, 0],
        [0, 1, 2, 4, 3, 1, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 1, 5, 3, 1, 1, 0, 0, 0, 0, 0, 0],
        [0, 1, 0, 4, 1, 1, 1, 0, 0, 0, 3, 1, 0],
        [1, 1, 2, 4, 0, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 1, 3, 0, 1, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 2, 4, 1, 0, 1, 0, 1, 0, 2, 1, 0],
        [1, 1, 1, 3, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 3, 5, 2, 1, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 2, 1, 1, 1, 1, 0, 0, 1, 0, 1, 1],
        [1, 1, 2, 0, 3, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, -1, 3, 0, 1, 1, 0, 1, 1, 1, 1, 1],
        [1, 1, 0, 1, 1, 0, 1, 0, 0, 0, 2, 0, 1],
        [1, 1, 0, 3, 2, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 1, 4, 0, 1, 1, 0, 1, 1, 0, 0, 1],
        [0, 1, 2, 4, 1, 0, 1, 0, 1, 0, 1, 1, 1],
        [1, 1, 2, 4, 3, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 2, 3, 1, 1, 1, 0, 0, 1, 3, 1, 1],
        [1, 1, 3, 3, 1, 0, 1, 0, 0, 0, 1, 1, 1],
        [1, 0, 3, 3, 2, 1, 1, 0, 0, 1, 0, 1, 1],
        [1, 1, 0, 4, 1, 0, 1, 0, 0, 1, 0, 0, 1],
        [0, 1, 0, 0, 2, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 1, 5, 3, 1, 2, 0, 0, 1, 1, 0, 1],
        [1, 1, 0, 3, 1, 1, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 0, 4, 1, 0, 1, 0, 0, 0, 2, 0, 0],
        [0, 1, 1, 5, 1, 0, 1, 0, 0, 1, 3, 0, 0],
        [0, 1, 0, 3, 1, 0, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 0, 4, 1, 1, 1, 0, 0, 1, 3, 1, 0],
        [1, 2, 1, 3, 1, 1, 1, 0, 0, 1, 2, 0, 0],
        [1, 2, 1, 5, 1, 1, 1, 0, 0, 0, 0, 0, 0],
        [0, 1, 2, 4, 2, 1, 1, 0, 1, 0, 1, 1, 1],
        [0, 1, 1, 4, 1, 0, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 2, 0, 1, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 2, 3, 2, 1, 1, 0, 1, 1, 2, 1, 0],
        [1, 1, 0, 4, 3, 0, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 2, 1, 0, 1, 1, 0, 1, 1, 0, 0, 0],
        [0, 1, 2, 1, 2, 1, 1, 0, 0, 0, 0, 1, 1],
        [1, 1, 2, 4, 2, 0, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 0, 1, 2, 0, 1, 0, 1, 0, 0, 0, 1],
        [1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 2, 1, 1],
        [1, 1, 3, 4, 3, 1, 1, 0, 1, 1, 1, 0, 0],
        [0, 1, 2, 1, 2, 0, 1, 0, 0, 0, 1, 1, 1],
        [1, 1, 0, 3, 2, 0, 2, 0, 0, 0, 0, 1, 0],
        [1, 1, 2, 1, 2, 1, 0, 0, 1, 0, 0, 0, 1],
        [1, 2, 2, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0],
        [1, 1, 1, 4, 1, 1, 1, 0, 1, 1, 1, 1, 1],
        [0, 1, 3, 2, 3, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 1, 4, 0, 0, 1, 0, 0, 1, 1, 1, 1],
        [0, 1, 1, 1, 3, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 0, 4, 2, 0, 1, 0, 0, 0, 2, 0, 0],
        [0, 1, 2, 1, 0, 1, 1, 0, 0, 0, 0, 1, 1],
        [1, 1, 0, 1, 3, 0, 1, 0, 1, 1, 0, 0, 1],
        [0, 1, 3, 3, 0, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 2, 0, 3, 1, 1, 0, 0, 1, 3, 0, 0],
        [1, 0, 2, 3, 0, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 1, 3, 3, 1, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 1, 4, 2, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 3, 5, 1, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 2, 3, 1, 0, 1, 0, 0, 1, 2, 1, 1],
        [1, 1, 3, 4, 0, 0, 1, 0, 1, 1, 2, 0, 1],
        [0, 1, 1, 3, 0, 0, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 3, 4, 3, 1, 1, 0, 0, 0, 2, 0, 0],
        [0, 1, 0, 3, 0, 0, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 0, 3, 1, 0, 2, 0, 0, 1, 1, 0, 0],
        [1, 1, 2, 1, 0, 1, 1, 0, 1, 0, 0, 1, 1],
        [0, 1, 0, 1, 1, 1, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 0, 0, 2, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 2, 4, 1, 0, 1, 0, 0, 0, 0, 0, 1],
        [1, 1, 3, 1, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 0, 1, 0, 1, 1, 0, 0, 0, 2, 1, 1],
        [0, 1, 2, 5, 1, 0, 1, 0, 0, 0, 0, 0, 0],
        [1, 0, 3, 3, 1, 1, 1, 0, 0, 1, 2, 1, 0],
        [1, 1, 2, 3, 3, 1, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 3, 3, 1, 1, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 3, 3, 3, 1, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 0, 5, 3, 1, 1, 0, 0, 0, 1, 1, 1],
        [1, 1, 2, 3, 2, 1, 1, 0, 1, 1, 1, 1, 1],
        [0, 1, 3, 1, 2, 0, 1, 0, 0, 1, 1, 1, 1],
        [0, 1, 2, 3, 3, 1, 1, 0, 0, 1, 3, 1, 1],
        [1, 1, 2, 0, 1, 1, 2, 0, 0, 0, 2, 1, 0],
        [1, 1, 0, 3, 0, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 3, 1, 3, 0, 1, 0, 1, 0, 2, 1, 1],
        [1, 1, 1, 1, 2, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 3, 3, 1, 1, 1, 1, 1, 1, 2, 0, 1],
        [0, 1, 3, 3, 1, 1, 1, 0, 1, 0, 0, 1, 0],
        [0, 1, 0, 3, 1, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 2, 3, 0, 0, 1, 0, 0, 1, 0, 1, 0],
        [0, 1, 0, 4, 1, 1, 1, 0, 0, 1, 2, 1, 0],
        [1, 1, 2, 4, 1, 0, 2, 0, 0, 0, 1, 0, 1],
        [1, 1, 3, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 2, 3, 1, 1, 1, 0, 1, 0, 3, 1, 1],
        [1, 0, 2, 4, 2, 1, 1, 0, 1, 1, 1, 1, 1],
        [0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1],
        [0, 0, 3, 3, 2, 1, 1, 0, 1, 1, 1, 0, 1],
        [0, 1, 0, 1, 2, 0, 1, 0, 0, 0, 2, 0, 1],
        [0, 1, 3, 4, 1, 0, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 0, 3, 0, 0, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 1, 3, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 0, 1, 3, 0, 1, 0, 0, 0, 2, 0, 0],
        [1, 1, 3, 1, 0, 0, 1, 0, 1, 0, 1, 0, 0],
        [0, 1, 1, 4, 0, 1, 1, 0, 1, 0, 1, 0, 0],
        [1, 1, 3, 3, 2, 1, 1, 0, 1, 1, 1, 1, 0],
        [0, 1, 3, 3, 2, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 2, 1, 1, 2, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 2, 3, 2, 0, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 3, 4, 2, 0, 1, 0, 1, 0, 0, 1, 1],
        [1, 1, 1, 1, 3, 1, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 0, 3, 2, 0, 2, 0, 0, 0, 1, 0, 0],
        [1, 1, 2, 4, 0, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 2, 0, 2, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 2, 1, 1, 1, 1, 0, 1, 0, 3, 0, 1],
        [0, 0, 0, 0, 3, 0, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 1, 5, 2, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 0, 3, 0, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 2, 3, 2, 0, 1, 0, 0, 0, 2, 0, 1],
        [0, 1, 1, 3, 2, 0, 1, 0, 1, 1, 1, 0, 0],
        [1, 1, 1, 4, 0, 0, 1, 0, 0, 0, 0, 0, 1],
        [0, 1, 3, 1, 2, 0, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 2, 1, 3, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 0, 1, 1, 1, 1, 0, 1, 0, 0, 1, 1],
        [0, 1, 1, 4, 0, 1, 1, 1, 1, 1, 1, 0, 0],
        [0, 1, 0, 3, 2, 1, 1, 0, 0, 0, 3, 0, 0],
        [0, 1, 0, 3, 2, 0, 2, 0, 0, 1, 1, 0, 0],
        [0, 1, 1, 4, 1, 0, 1, 0, 1, 0, 1, 1, 0],
        [1, 1, 1, 4, 1, 1, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 3, 1, 2, 0, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 0, 3, 1, 0, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 1, 2, 3, 1, 1, 0, 0, 0, 0, 0, 0],
        [0, 1, 0, 4, 1, 0, 2, 0, 0, 0, 1, 0, 1],
        [1, 1, 2, 1, 2, 1, 1, 0, 0, 1, 1, 0, 1],
        [0, 1, 1, 3, 2, 1, 2, 0, 0, 0, 1, 1, 1],
        [0, 1, 0, 3, 0, 1, 1, 0, 0, 0, 0, 1, 1],
        [1, 1, 3, 5, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 2, 4, 1, 0, 1, 0, 1, 0, 0, 0, 0],
        [0, 1, 2, 5, 1, 1, 1, 0, 0, 1, 2, 1, 1],
        [0, 1, 0, 5, 1, 1, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 0, 3, 1, 0, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 2, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1],
        [0, 1, 2, 3, 0, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 2, 0, 3, 0, 2, 0, 0, 0, 1, 1, 0],
        [1, 1, 2, 3, 3, 0, 1, 0, 1, 0, 2, 0, 0],
        [1, 1, 3, 3, 1, 1, 1, 0, 1, 1, 1, 1, 1],
        [1, 1, 1, 3, 3, 0, 1, 0, 0, 1, 1, 1, 1],
        [0, 1, 0, 2, 0, 1, 1, 0, 0, 1, 2, 0, 0],
        [0, 1, 2, 4, 1, 1, 1, 0, 0, 0, 3, 0, 1],
        [0, 1, 1, 3, 1, 1, 1, 0, 1, 1, 1, 1, 0],
        [0, 1, 3, 4, 1, 0, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 1, 5, 2, 1, 2, 0, 0, 0, 1, 1, 0],
        [1, 1, 2, 4, 1, 1, 1, 0, 0, 0, 0, 0, 0],
        [0, 1, 2, 3, 1, 1, 1, 0, 0, 0, 2, 0, 0],
        [0, 2, 1, 3, 2, 0, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 1, 4, 3, 1, 0, 0, 1, 1, 1, 0, 0],
        [0, 0, 0, 3, 1, 0, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 2, 3, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 2, 4, 0, 1, 1, 0, 0, 1, 2, 0, 1],
        [0, 1, 0, 2, 1, 1, 1, 0, 0, 0, 1, 1, 1],
        [0, 1, 0, 2, 2, 0, 1, 0, 0, 0, 1, 0, 1],
        [0, 1, 0, 3, 1, 1, 1, 0, 1, 0, 1, 1, 0],
        [1, 1, 0, 3, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 0, 1, 2, 1, 0, 0, 0, 1, 2, 0, 1],
        [0, 1, 1, 4, 2, 0, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 0, 2, 1, 1, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 0, 4, 1, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 3, 0, 2, 0, 1, 0, 1, 1, 2, 0, 1],
        [0, 1, 3, 5, 1, 1, 1, 0, 0, 1, 0, 0, 1],
        [0, 1, 3, 4, 2, 1, 1, 0, 0, 1, 1, 1, 1],
        [0, 1, 1, 4, 0, 0, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 3, 1, 2, 0, 1, 0, 0, 0, 1, 0, 1],
        [0, 0, 2, 3, 2, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 0, 4, 2, 0, 1, 0, 0, 0, 1, 1, 1],
        [0, 1, 0, 1, 1, 1, 1, 0, 1, 0, 2, 1, 0],
        [1, 2, 2, 5, 1, 1, 1, 0, 1, 0, 2, 0, 0],
        [0, 1, 3, 3, 3, 1, 1, 0, 1, 0, 2, 1, 0],
        [0, 1, 2, 1, 0, 0, 1, 0, 0, 0, 3, 0, 1],
        [0, 1, 1, 0, 0, 0, 1, 0, 0, 0, 3, 0, 0],
        [1, 1, 2, 1, 3, 1, 1, 0, 1, 0, 1, 0, 1],
        [0, 1, 2, 4, 3, 1, 1, 0, 0, 1, 0, 1, 1],
        [1, 1, 0, 5, 0, 0, 2, 0, 0, 0, 2, 1, 0],
        [1, 1, 1, 3, 3, 1, 1, 0, 0, 1, 2, 1, 1],
        [1, 1, 1, 3, 1, 0, 1, 0, 1, 1, 1, 0, 0],
        [1, 1, 1, 3, 2, 0, 1, 0, 0, 1, 0, 1, 0],
        [0, 1, 2, 5, 0, 0, 1, 0, 0, 1, 2, 1, 0],
        [1, 1, 3, 1, 2, 1, 1, 0, 0, 1, 0, 1, 1],
        [0, 1, 3, 5, 0, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 2, 3, 0, 0, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 0, 1, 3, 1, 1, 0, 0, 0, 3, 0, 0],
        [0, 1, 2, 1, 0, 0, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 0, 2, 1, 0, 1, 0, 1, 0, 0, 0, 0],
        [0, 1, 2, 3, 2, 0, 1, 0, 1, 0, 1, 1, 1],
        [1, 1, 2, 1, 2, 1, 1, 0, 0, 1, 1, 0, 1],
        [1, 1, 2, 0, 2, 1, 1, 0, 0, 1, 2, 0, 1],
        [0, 1, 2, 4, 3, 1, 1, 0, 1, 1, 1, 1, 1],
        [1, 1, 2, 4, 2, 0, 1, 0, 1, 0, 3, 1, 1],
        [1, 1, 2, 4, 3, 0, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 2, 5, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 2, 1, 0, 1, 1, 0, 1, 0, 1, 1, 1],
        [1, 1, 1, 2, 3, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 2, 5, 0, 1, 1, 0, 1, 1, 1, 1, 1],
        [1, 1, 3, 1, 2, 1, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 3, 3, 1, 0, 2, 0, 1, 0, 1, 1, 0],
        [1, 1, 0, 4, 3, 1, 2, 0, 0, 0, 0, 0, 1],
        [1, 1, 2, 3, 0, 1, 1, 0, 1, 1, 1, 0, 0],
        [1, 1, 0, 4, 0, 1, 1, 0, 1, 0, 2, 0, 0],
        [1, 1, 1, 0, 1, 0, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 0, 1, 1, 0, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 3, 1, 2, 0, 1, 0, 0, 0, 1, 1, 1],
        [1, 1, 1, 3, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 0, 3, 0, 1, 1, 0, 1, 0, 1, 1, 0],
        [0, 1, 0, 3, 2, 1, 1, 0, 1, 1, 1, 0, 0],
        [0, 1, 2, 5, 1, 0, 2, 0, 0, 0, 1, 1, 0],
        [1, 1, 2, 2, 2, 1, 1, 0, 1, 0, 0, 0, 0],
        [1, 2, 0, 2, 2, 1, 2, 0, 0, 0, 2, 0, 0],
        [1, 1, 0, 4, 1, 1, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 2, 1, 1, 0, 1, 0, 0, 1, 0, 0, 1],
        [0, 1, 2, 4, 2, 0, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 0, 1, 3, 1, 1, 0, 0, 1, 2, 1, 0],
        [0, 1, 1, 2, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 2, 4, 0, 1, 1, 0, 0, 1, 0, 0, 1],
        [1, 1, 2, 4, 1, 1, 1, 0, 1, 0, 0, 1, 0],
        [1, 1, 0, 4, 2, 1, 1, 0, 1, 0, 2, 0, 1],
        [1, 2, 0, 4, 1, 0, 1, 0, 1, 1, 1, 0, 0],
        [1, 1, 2, 3, 3, 1, 1, 0, 0, 0, 3, 0, 0],
        [0, 1, 3, 1, 1, 1, 1, 0, 1, 1, 2, 0, 0],
        [0, 1, 1, 4, 3, 1, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 2, 3, 3, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 3, 0, 3, 0, 1, 0, 1, 1, 2, 1, 1],
        [1, 1, 1, 5, 3, 1, 1, 0, 1, 1, 1, 0, 0],
        [1, 1, 2, 5, 3, 1, 1, 0, 0, 1, 0, 1, 1],
        [1, 1, 3, 3, 3, 0, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 1, 1, 3, 1, 1, 0, 1, 1, 1, 1, 1],
        [1, 1, 1, 4, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 2, 3, 0, 1, 1, 0, 1, 1, 1, 1, 1],
        [0, 1, 2, 4, 1, 1, 1, 0, 1, 0, 0, 0, 0],
        [0, 1, 1, 1, 0, 1, 1, 0, 0, 1, 1, 1, 1],
        [0, 1, 0, 5, 2, 0, 1, 0, 0, 0, 2, 0, 1],
        [1, 1, 2, 5, 1, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 3, 0, 2, 1, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 2, 3, 3, 1, 1, 1, 0, 1, 2, 0, 0],
        [0, 1, 2, 3, 1, 1, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 2, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1],
        [0, 1, 1, 2, 3, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 0, 5, 2, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 0, 3, 1, 1, 0, 0, 0, 1, 0, 0, 0],
        [0, 1, 0, 2, 0, 0, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 2, 4, 0, 0, 1, 0, 1, 0, 0, 0, 0],
        [0, 1, 1, 4, 1, 1, 1, 0, 0, 1, 0, 1, 0],
        [1, 0, 2, 4, 1, 0, 1, 0, 1, 1, 0, 0, 1],
        [0, 1, 0, 3, 3, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 0, 4, 0, 1, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 0, 2, 0, 1, 1, 0, 1, 1, 0, 1, 0],
        [0, 1, 2, 2, 1, 0, 1, 0, 0, 1, 1, 0, 1],
        [1, 1, 0, 4, 1, 0, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 3, 4, 0, 0, 1, 0, 1, 1, 0, 0, 0],
        [1, 1, 0, 4, 1, 1, 0, 0, 1, 0, 1, 1, 1],
        [1, 1, 2, 2, 2, 1, 1, 0, 1, 0, 1, 0, 1],
        [1, 1, 3, 2, 1, 1, 1, 1, 0, 0, 0, 1, 1],
        [1, 1, 0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 1],
        [1, 1, 2, 2, 0, 0, 1, 0, 0, 0, 2, 0, 1],
        [1, 1, 3, 0, 1, 1, 1, 0, 0, 1, 1, 0, 1],
        [0, 2, 3, 3, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 2, 5, 2, 0, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 1, 3, 2, 1, 2, 0, 0, 1, 0, 0, 0],
        [1, 1, 2, 3, 1, 1, 2, 0, 0, 0, 1, 0, 0],
        [0, 1, 2, 3, 1, 0, 1, 0, 1, 1, 1, 1, 0],
        [1, 1, 3, 3, 0, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 2, 5, 2, 1, 1, 0, 0, 1, 0, 1, 1],
        [0, 1, 0, 4, 3, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 1, 0, 0],
        [1, 1, 0, 3, 0, 0, 1, 0, 1, 0, 1, 0, 0],
        [1, 1, 3, 4, 3, 0, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 1, 1, 0, 0, 1, 0, 0, 1, 1, 1, 1],
        [0, 1, 1, 1, 2, 0, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 0, 4, 1, 0, 1, 0, 0, 1, 1, 0, 1],
        [0, 2, 2, 2, 2, 1, 1, 0, 1, 1, 1, 1, 1],
        [0, 1, 0, 0, 1, 0, 2, 0, 0, 0, 0, 0, 0],
        [1, 1, 0, 4, 1, 1, 1, 0, 0, 0, 2, 0, 0],
        [0, 1, 3, 1, 1, 0, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 0, 1],
        [1, 1, 1, 0, 1, 1, 2, 0, 0, 0, 1, 0, 0],
        [1, 1, 3, 3, 1, 0, 1, 0, 1, 0, 1, 1, 0],
        [1, 1, 2, 1, 3, 1, 1, 0, 0, 0, 2, 1, 1],
        [1, 1, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 0, 2, 0, 0, 1, 0, 0, 0, 1, 0, 1],
        [0, 1, 1, 3, 0, 0, 2, 0, 0, 0, 0, 0, 0],
        [1, 1, 3, 3, 2, 1, 1, 0, 0, 1, 3, 0, 0],
        [0, 1, 1, 3, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 0, 1, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 1, 4, 1, 0, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 3, 5, 3, 1, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 0, 5, 1, 1, 1, 0, 0, 0, 3, 0, 0],
        [0, 1, 0, 1, 1, 1, 1, 0, 1, 0, 2, 1, 0],
        [0, 1, 1, 0, 1, 0, 1, 1, 1, 0, 1, 0, 0],
        [0, 1, 2, 4, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 2, 0, 1, 1, 1, 0, 1, 1, 0, 0, 0],
        [0, 1, 0, 3, 2, 0, 1, 0, 0, 0, 0, 0, 1],
        [0, 1, 0, 2, 3, 1, 1, 0, 0, 1, 0, 1, 0],
        [0, 1, 0, 5, 2, 1, 2, 0, 1, 0, 1, 1, 1],
        [0, 2, 0, 0, 2, 1, 1, 0, 1, 1, 2, 1, 0],
        [0, 1, 2, 4, 3, 0, 1, 0, 1, 1, 0, 0, 0],
        [1, 1, 3, 3, 2, 1, 1, 0, 1, 1, 1, 1, 0],
        [0, 1, 3, 3, 3, 0, 1, 0, 1, 1, 1, 1, 0],
        [0, 1, 3, 2, 0, 0, 1, 0, 1, 1, 1, 0, 1],
        [1, 1, 3, 3, 1, 1, 1, 0, 0, 1, 2, 1, 0],
        [0, 1, 1, 4, 1, 0, 1, 0, 1, 1, 1, 0, 0],
        [1, 1, 3, 3, 0, 0, 1, 0, 1, 0, 3, 0, 0],
        [1, 1, 0, 3, 2, 1, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 2, 3, 3, 1, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 0, 1, 1, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 1, 1, 2, 1, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 1, 5, 2, 1, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 0, 4, 0, 0, 1, 0, 1, 0, 2, 0, 0],
        [0, 1, 2, 3, 1, 1, 1, 0, 0, 0, 3, 1, 0],
        [1, 1, 1, 3, 1, 0, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 0, 1, 2, 0, 1, 0, 0, 1, 2, 0, 1],
        [1, 1, 0, 3, 2, 1, 1, 0, 1, 0, 1, 1, 1],
        [0, 2, 2, 4, 0, 0, 1, 0, 1, 0, 1, 0, 1],
        [0, 1, 2, 3, 2, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 0],
        [0, 1, 0, 3, 0, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 2, 5, 3, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 3, 2, 0, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 2, 1, 1, 0, 1, 0, 1, 0, 2, 1, 1],
        [1, 1, 1, 1, 0, 1, 1, 0, 0, 1, 0, 1, 1],
        [1, 1, 3, 3, 0, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 3, 0, 0],
        [1, 1, 3, 3, 3, 0, 1, 0, 1, 0, 2, 0, 0],
        [1, 1, 1, 5, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 2, 4, 1, 0, 1, 0, 1, 1, 2, 0, 0],
        [1, 1, 2, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1],
        [0, 1, 0, 3, 3, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 0, 1, 4, 0, 1, 1, 0, 0, 1, 1, 0, 1],
        [1, 1, 2, 0, 3, 1, 1, 0, 0, 1, 0, 1, 1],
        [0, 2, 0, 3, 1, 0, 1, 0, 1, 1, 2, 0, 0],
        [0, 1, 3, 4, 2, 1, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 3, 2, 1, 1, 1, 0, 1, 0, 0, 1, 1],
        [0, 0, 0, 5, 1, 1, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 2, 0, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 0, 0, 2, 0, 1, 0, 1, 0, 0, 1, 0],
        [1, 1, 0, 4, -1, 1, 1, 0, 0, 0, 1, 1, 1],
        [1, 1, 3, 4, 3, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 2, 0, 3, 1, 1, 1, 1, 1, 1, 0, 0],
        [0, 1, 0, 4, 2, 1, 1, 0, 0, 0, 0, 1, 0],
        [0, 0, 1, 4, 3, 0, 1, 0, 0, 0, 2, 0, 0],
        [0, 1, 1, 4, 2, 0, 1, 0, 0, 0, 0, 1, 1],
        [0, 1, 1, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 2, 3, 3, 0, 0, 0, 0, 1, 1, 1, 0],
        [1, 1, 1, 3, 0, 1, 1, 0, 0, 0, 2, 0, 0],
        [0, 1, 0, 4, 1, 1, 1, 0, 1, 0, 1, 1, 1],
        [1, 1, 0, 5, 2, 1, 2, 0, 1, 0, 2, 1, 1],
        [1, 1, 2, 1, 3, 0, 1, 0, 0, 1, 1, 0, 1],
        [1, 2, 2, 4, 1, 1, 1, 0, 1, 1, 1, 1, 1],
        [1, 2, 1, 3, 0, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 0, 3, 2, 1, 1, 1, 1, 0, 0, 1, 1],
        [1, 1, 2, 3, 1, 1, 1, 1, 0, 0, 1, 1, 1],
        [1, 1, 3, 3, 2, 1, 1, 0, 1, 1, 1, 1, 1],
        [1, 1, 3, 2, 3, 0, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 2, 4, 1, 1, 1, 0, 0, 0, 2, 0, 1],
        [1, 2, 2, 3, 0, 1, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 2, 3, 1, 1, 1, 0, 1, 0, 1, 1, 0],
        [1, 1, 2, 4, 0, 0, 1, 0, 0, 0, 1, 0, 1],
        [0, 1, 2, 4, 1, 0, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 0, 3, 2, 1, 1, 0, 1, 0, 1, 1, 0],
        [1, 1, 1, 3, 1, 1, 1, 0, 0, 1, 3, 0, 0],
        [1, 1, 2, 5, 2, 1, 2, 0, 0, 0, 1, 1, 1],
        [0, 1, 2, 4, 1, 1, 1, 0, 0, 1, 1, 0, 1],
        [0, 1, 1, 1, 3, 1, 1, 0, 0, 0, 0, 0, 0],
        [0, 1, 0, 1, 0, 1, 1, 0, 1, 0, 0, 0, 0],
        [1, 1, 1, 4, 2, 1, 1, 0, 1, 1, 1, 0, 0],
        [1, 1, 1, 3, 3, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 2, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0],
        [0, 0, 2, 5, 1, 0, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 2, 3, 3, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 0, 5, 1, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 3, 4, 1, 0, 2, 0, 0, 1, 1, 0, 0],
        [1, 2, 2, 5, 0, 0, 2, 0, 0, 0, 1, 0, 0],
        [1, 1, 3, 3, 0, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 3, 2, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 1, 0, 1, 1, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 1, 2, 0, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 2, 3, 1, 0, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 3, 4, 3, 1, 1, 0, 0, 0, 3, 0, 0],
        [0, 2, 3, 0, 3, 1, 1, 0, 1, 0, 3, 1, 0],
        [0, 1, 3, 3, 1, 1, 1, 0, 0, 1, 0, 1, 0],
        [0, 1, 3, 3, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 2, 1, 3, 0, 1, 0, 1, 0, 2, 1, 1],
        [0, 1, 2, 4, 1, 1, 1, 0, 0, 0, 1, 1, 1],
        [0, 1, 1, 1, 1, 1, 1, 0, 1, 0, 0, 1, 0],
        [1, 1, 1, 4, 0, 1, 1, 0, 0, 0, 1, 0, 1],
        [0, 1, 3, 4, 1, 1, 1, 0, 0, 1, 3, 0, 0],
        [1, 1, 1, 1, 1, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 3, 0, 3, 1, 1, 0, 0, 0, 0, 0, 0],
        [0, 1, 3, 3, 2, 1, 1, 0, 0, 0, 0, 0, 0],
        [0, 1, 1, 2, 0, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 1, 2, 0, 0, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 1, 3, 1, 1, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 0, 4, 0, 0, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 2, 4, 1, 0, 1, 0, 0, 0, 3, 0, 1],
        [1, 1, 0, 2, 2, 1, 1, 0, 0, 1, 2, 1, 0],
        [0, 1, 2, 3, 2, 1, 1, 0, 1, 1, 1, 1, 0],
        [0, 1, 2, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 3, 3, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 2, 4, 1, 1, 1, 0, 0, 0, 1, 0, 1],
        [0, 1, 2, 1, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 3, 4, 0, 1, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 0, 4, 3, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 1, 4, 0, 0, 1, 0, 0, 0, 3, 0, 0],
        [1, 2, 1, 4, 0, 0, 1, 0, 0, 1, 2, 0, 0],
        [0, 1, 1, 4, 1, 0, 1, 0, 0, 0, 0, 0, 0],
        [0, 1, 1, 4, 2, 1, 1, 0, 0, 0, 2, 0, 1],
        [1, 1, 2, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1],
        [0, 1, 0, 3, 1, 0, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 2, 1, 2, 0, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 0, 1, 1, 1, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 0, 3, 0, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 0, 2, 4, 1, 0, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 0, 0, 3, 1, 1, 0, 0, 0, 0, 0, 0],
        [0, 1, 0, 4, 2, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 0, 1, 0, 1, 1, 0, 0, 0, 0, 1, 1],
        [0, 1, 0, 1, 2, 0, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 0, 3, 2, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 0, 3, 0, 0, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 2, 3, 3, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 2, 4, 1, 0, 2, 0, 0, 0, 0, 0, 0],
        [1, 1, 1, 3, 3, 1, 1, 0, 1, 1, 2, 0, 0],
        [0, 1, 3, 3, 3, 1, 1, 0, 1, 1, 1, 0, 0],
        [1, 1, 0, 3, 1, 0, 1, 1, 0, 1, 1, 0, 0],
        [0, 1, 3, 3, 0, 1, 1, 1, 0, 0, 0, 0, 0],
        [1, 1, 1, 5, 2, 1, 1, 0, 0, 0, 1, 1, 1],
        [0, 1, 1, 5, 3, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 2, 2, 3, 0, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 0, 3, 2, 1, 1, 0, 0, 0, 0, 1, 1],
        [0, 1, 0, 3, 2, 0, 2, 0, 0, 0, 0, 0, 0],
        [1, 1, 3, 3, 1, 0, 1, 1, 1, 1, 1, 0, 0],
        [1, 0, 2, 2, 2, 1, 1, 0, 0, 1, 1, 0, 1],
        [1, 1, 0, 2, 0, 0, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 2, 0, 1, 1, 1, 0, 0, 0, 1, 1, 1],
        [1, 1, 1, 3, 2, 1, 1, 0, 1, 1, 0, 0, 0],
        [1, 1, 2, 3, 3, 1, 1, 0, 0, 1, 1, 0, 1],
        [0, 1, 2, 2, 2, 1, 1, 0, 0, 1, 0, 0, 1],
        [0, 1, 3, 5, 1, 1, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 3, 2, 3, 1, 1, 0, 0, 0, 0, 0, 0],
        [1, 0, 0, 4, 1, 1, 0, 0, 0, 0, 1, 0, 1],
        [1, 1, 0, 4, 2, 1, 1, 0, 0, 0, 1, 1, 1],
        [1, 1, 1, 0, 2, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 1, 1, 3, 1, 1, 0, 0, 1, 1, 0, 1],
        [0, 1, 1, 2, 1, 1, 1, 0, 0, 0, 2, 0, 0],
        [1, 1, 3, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0],
        [0, 1, 2, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1],
        [0, 1, 2, 1, 1, 0, 1, 0, 0, 1, 0, 0, 1],
        [1, 1, 0, 3, 2, 0, 1, 0, 1, 1, 3, 1, 1],
        [0, 1, 2, 4, 1, 1, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 0, 1, 0, 1, 2, 0, 0, 1, 1, 0, 1],
        [0, 1, 2, 1, 3, 1, 1, 0, 1, 0, 1, 1, 1],
        [1, 1, 2, 3, 3, 0, 1, 0, 0, 1, 1, 1, 0],
        [0, 0, 2, 3, 2, 1, 1, 1, 0, 1, 1, 0, 0],
        [1, 1, 1, 3, 0, 1, 1, 0, 1, 0, 1, 1, 0],
        [0, 1, 2, 3, 1, 1, 1, 0, 0, 0, 0, 0, 0],
        [0, 1, 3, 4, 1, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 1, 0, 1, 1, 1, 0, 1, 0, 1, 0, 0],
        [0, 1, 2, 5, 2, 1, 1, 0, 0, 1, 2, 1, 0],
        [0, 1, 1, 4, 2, 0, 1, 0, 1, 1, 1, 1, 1],
        [1, 1, 0, 3, 3, 1, 1, 0, 0, 1, 2, 0, 1],
        [1, 1, 2, 3, 2, 0, 1, 0, 0, 1, 1, 0, 0],
        [0, 2, 0, 4, 1, 1, 1, 1, 0, 0, 0, 1, 1],
        [0, 1, 1, 2, 1, 0, 1, 0, 0, 0, 0, 0, 0],
        [0, 1, 1, 3, 1, 1, 1, 0, 0, 0, 2, 0, 0],
        [0, 1, 0, 2, 1, 1, 1, 0, 1, 0, 1, 1, 1],
        [1, 1, 1, 4, 1, 1, 1, 0, 1, 1, 1, 0, 0],
        [1, 1, 1, 2, 1, 0, 1, 0, 0, 0, 0, 0, 0],
        [0, 1, 1, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 2, 0, 0, 3, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 2, 4, 1, 1, 1, 0, 0, 0, 1, 1, 1],
        [1, 1, 2, 3, 3, 0, 1, 0, 1, 1, 0, 0, 0],
        [0, 1, 2, 1, 3, 1, 1, 0, 1, 0, 2, 1, 0],
        [1, 1, 0, 3, 1, 0, 1, 0, 0, 0, 3, 0, 0],
        [1, 1, 2, 4, 0, 0, 1, 0, 0, 1, 1, 1, 1],
        [0, 1, 0, 3, 0, 0, 1, 1, 1, 1, 1, 0, 0],
        [1, 1, 0, 4, 1, 0, 1, 0, 0, 1, 1, 0, 0],
        [1, 2, 1, 3, 1, 1, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 2, 2, 1, 1, 1, 0, 1, 0, 2, 0, 0],
        [0, 1, 1, 4, 1, 1, 1, 0, 1, 0, 3, 0, 0],
        [1, 1, 0, 4, 2, 1, 1, 1, 0, 0, 0, 1, 1],
        [0, 2, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 2, 5, 2, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 0, 0, 2, 1, 1, 1, 0, 0, 0, 1, 1],
        [1, 1, 3, 2, 1, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 1, 3, 0, 0, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 1, 2, 0, 1, 1, 0, 1, 0, 1, 0, 0],
        [1, 1, 1, 5, 1, 0, 1, 0, 1, 1, 0, 0, 0],
        [1, 2, 0, 2, 2, 0, 1, 0, 0, 1, 2, 0, 1],
        [0, 1, 2, 3, 3, 1, 1, 0, 0, 0, 1, 1, 1],
        [0, 1, 1, 3, 3, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 1, 3, 1, 0, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 1, 4, 2, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 0, 5, 3, 0, 1, 0, 0, 1, 3, 1, 1],
        [0, 1, 0, 1, 2, 1, 1, 0, 0, 0, 1, 0, 1],
        [0, 1, 1, 4, 1, 0, 1, 0, 0, 0, 0, 0, 1],
        [1, 1, 2, 4, 1, 0, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 3, 2, 1, 0, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 1, 5, 3, 1, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 3, 0, 3, 1, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 1, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 1, 4, 0, 0, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 3, 4, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 0, 2, 2, 1, 1, 0, 1, 0, 0, 0, 1],
        [1, 1, 0, 3, 1, 1, 1, 0, 0, 0, 0, 0, 0],
        [0, 1, 3, 4, 1, 1, 1, 0, 1, 0, 1, 1, 1],
        [1, 1, 3, 2, 1, 1, 1, 1, 0, 0, 0, 0, 0],
        [0, 1, 2, 5, 2, 0, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 0, 3, 1, 1, 1, 1, 0, 1, 1, 1, 1],
        [0, 1, 1, 4, 1, 1, 1, 0, 1, 1, 1, 0, 0],
        [1, 1, 0, 3, 0, 1, 1, 0, 0, 1, 0, 1, 0],
        [0, 1, 3, 4, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 0, 1, 1, 2, 0, 1, 0, 0, 0, 0, 0, 1],
        [1, 1, 2, 4, 2, 0, 1, 0, 0, 1, 1, 1, 1],
        [1, 0, 2, 2, 0, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 2, 3, 1, 1, 1, 0, 0, 1, 2, 1, 0],
        [0, 1, 3, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 0, 1, 2, 1, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 1, 3, 1, 0, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 2, 4, 2, 1, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 2, 3, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 2, 4, 1, 1, 1, 0, 0, 1, 3, 0, 0],
        [0, 1, 2, 3, 2, 0, 1, 0, 0, 0, 3, 0, 1],
        [0, 1, 1, 3, 1, 0, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 2, 3, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 2, 1, 5, 1, 1, 1, 0, 0, 0, 2, 0, 0],
        [1, 2, 1, 4, 0, 1, 2, 0, 1, 0, 1, 1, 1],
        [0, 1, 1, 1, 3, 0, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 1, 3, 3, 0, 2, 0, 0, 1, 1, 0, 0],
        [0, 1, 2, 3, 0, 0, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 3, 3, 3, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 0, 3, 1, 0, 1, 0, 1, 1, 1, 0, 0],
        [0, 1, 2, 4, 0, 1, 1, 0, 0, 0, 1, 1, 1],
        [0, 2, 2, 1, 2, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 2, 1, 0, 1, 1, 0, 1, 1, 2, 0, 1],
        [0, 1, 0, 3, 0, 1, 1, 0, 1, 1, 0, 0, 0],
        [1, 1, 0, 3, 3, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 1, 3, 0, 1, 1, 1, 0, 0, 0, 0, 0],
        [0, 1, 3, 3, 3, 0, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 0, 2, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 2, 4, 0, 1, 1, 1, 1, 1, 2, 1, 1],
        [0, 1, 3, 0, 3, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 2, 4, 1, 1, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 3, 2, 3, 1, 2, 0, 0, 0, 1, 1, 1],
        [0, 1, 1, 3, 2, 0, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 3, 5, 0, 1, 2, 0, 1, 0, 0, 1, 0],
        [0, 1, 2, 2, 3, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 2, 5, 1, 0, 1, 0, 1, 0, 2, 0, 0],
        [0, 1, 0, 0, 1, 0, 1, 0, 1, 1, 0, 1, 0],
        [0, 1, 2, 5, 1, 1, 1, 0, 1, 0, 1, 0, 1],
        [1, 1, 2, 1, 0, 1, 1, 0, 0, 0, 1, 1, 1],
        [0, 1, 2, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 2, 1, 0, 1, 1, 0, 0, 0, 1, 1, 1],
        [0, 1, 3, 2, 1, 0, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 3, 4, 1, 0, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 0, 3, 1, 0, 2, 0, 1, 1, 3, 1, 1],
        [0, 1, 2, 3, 2, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 2, 1, 0, 1, 1, 0, 0, 0, 1, 0, 1],
        [1, 2, 0, 1, 2, 1, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 2, 3, 3, 0, 1, 1, 0, 1, 1, 1, 0],
        [0, 1, 3, 5, 1, 1, 1, 0, 0, 0, 2, 0, 0],
        [1, 1, 0, 4, 1, 1, 1, 1, 0, 1, 1, 1, 0],
        [1, 1, 0, 5, 1, 1, 1, 0, 1, 0, 0, 0, 0],
        [1, 1, 1, 4, 3, 0, 1, 0, 1, 1, 1, 0, 1],
        [1, 0, 1, 3, 1, 1, 1, 0, 1, 0, 2, 0, 1],
        [1, 1, 2, 1, 3, 0, 1, 0, 1, 0, 1, 0, 1],
        [1, 1, 3, 4, 2, 0, 1, 0, 0, 1, 3, 1, 1],
        [1, 1, 0, 4, 2, 1, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 2, 3, 3, 0, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 0, 0, 2, 1, 1, 0, 0, 0, 0, 0, 1],
        [0, 1, 3, 0, 0, 0, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 1, 3, 1, 1, 1, 0, 1, 0, 0, 0, 0],
        [0, 1, 2, 3, 1, 1, 1, 0, 1, 0, 3, 0, 1],
        [0, 1, 3, 3, 2, 1, 1, 0, 1, 1, 0, 1, 0],
        [1, 1, 2, 2, 1, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 2, 3, 2, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 3, 1, 1, 1, 1, 0, 0, 1, 0, 0, 1],
        [1, 1, 1, 1, 0, 0, 1, 0, 1, 1, 0, 0, 1],
        [0, 1, 3, 2, 0, 0, 1, 0, 0, 1, 0, 0, 1],
        [1, 1, 2, 4, 0, 1, 1, 0, 0, 1, 0, 1, 0],
        [0, 1, 0, 3, 0, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 3, 3, 2, 1, 1, 0, 1, 1, 0, 0, 0],
        [1, 1, 1, 3, 0, 0, 1, 0, 1, 0, 1, 0, 0],
        [0, 1, 1, 4, 2, 0, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 0, 3, 3, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 0, 4, 2, 0, 1, 0, 0, 1, 2, 1, 1],
        [1, 1, 0, 1, 3, 1, 1, 0, 0, 1, 1, 0, 1],
        [0, 1, 2, 3, 3, 1, 1, 0, 0, 0, 2, 0, 0],
        [1, 1, 1, 3, 0, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 0, 4, 0, 1, 1, 1, 0, 1, 2, 1, 1],
        [0, 1, 2, 3, 1, 1, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 0, 3, 2, 0, 1, 0, 1, 0, 1, 0, 0],
        [0, 1, 2, 3, 2, 0, 1, 0, 0, 1, 1, 0, 1],
        [0, 2, 2, 3, 2, 0, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 2, 3, 1, 1, 1, 0, 0, 1, 3, 1, 0],
        [0, 2, 2, 3, 1, 0, 1, 0, 1, 0, 1, 1, 0],
        [0, 1, 3, 4, 2, 1, 1, 0, 1, 0, 0, 0, 0],
        [0, 1, 0, 4, 3, 1, 1, 0, 1, 0, 2, 0, 0],
        [1, 1, 1, -1, 0, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 0, 1, 2, 0, 1, 0, 1, 0, 1, 1, 1],
        [1, 1, 2, 4, 2, 1, 1, 0, 0, 0, 2, 1, 1],
        [0, 1, 3, 3, 2, 1, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 2, 4, 1, 1, 1, 0, 1, 0, 2, 0, 1],
        [1, 1, 2, 3, 1, 1, 1, 1, 1, 1, 1, 0, 0],
        [0, 2, 2, 4, 1, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 0, 2, 3, 0, 1, 1, 0, 0, 0, 0, 1, 1],
        [0, 1, 1, 1, 2, 1, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 2, 1, 0, 0, 1, 0, 0, 0, 2, 0, 1],
        [0, 1, 1, 3, 2, 0, 2, 0, 1, 0, 1, 0, 0],
        [1, 2, 0, 5, 1, 1, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 2, 4, 2, 1, 1, 1, 0, 1, 1, 1, 0],
        [1, 1, 0, 1, 3, 1, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 2, 4, 2, 0, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 2, 3, 1, 0, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 2, 2, 2, 1, 1, 0, 1, 0, 1, 0, 0],
        [1, 2, 0, 4, 1, 0, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 0, 5, 2, 0, 1, 0, 1, 0, 1, 0, 1],
        [0, 1, 3, 0, 2, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 3, 3, 3, 1, 1, 0, 1, 0, 1, 0, 0],
        [0, 1, 2, 0, 2, 1, 1, 0, 1, 1, 3, 0, 1],
        [1, 1, 0, 3, 3, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 1, 4, 1, 1, 1, 0, 1, 1, 1, 1, 1],
        [1, 1, 1, 3, 1, 0, 1, 0, 1, 0, 0, 1, 0],
        [1, 1, 3, 2, 3, 0, 1, 0, 0, 0, 0, 0, 0],
        [0, 1, 1, 1, 2, 1, 1, 0, 1, 1, 1, 0, 0],
        [1, 1, 0, 0, 2, 1, 1, 0, 1, 1, 3, 1, 1],
        [0, 1, 2, 4, 0, 1, 1, 0, 1, 1, 1, 1, 1],
        [1, 1, 3, 5, 0, 0, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 0, 5, 0, 0, 1, 0, 1, 1, 1, 0, 0],
        [1, 1, 0, 2, 1, 1, 1, 0, 0, 0, 2, 0, 0],
        [0, 1, 0, 4, 2, 0, 1, 0, 1, 1, 0, 0, 1],
        [1, 1, 1, 5, 3, 1, 1, 0, 1, 1, 2, 0, 1],
        [1, 1, 2, 1, 3, 1, 1, 0, 0, 1, 0, 0, 1],
        [1, 0, 3, 3, 0, 1, 1, 0, 0, 1, 2, 1, 1],
        [1, 1, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 0, 4, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 2, 3, 0, 1, 1, 0, 0, 0, 0, 0, 1],
        [0, 1, 1, 0, 0, 1, 1, 1, 0, 1, 2, 1, 0],
        [1, 1, 2, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 0, 3, 2, 1, 1, 0, 1, 1, 2, 0, 1],
        [1, 1, 0, 3, 1, 0, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 2, 0, 2, 0, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 3, 1, 2, 1, 1, 0, 1, 0, 0, 0, 1],
        [1, 1, 0, 4, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 0, 3, 0, 0, 1, 0, 1, 0, 1, 1, 0],
        [0, 1, 0, 1, 3, 1, 1, 0, 1, 1, 2, 1, 0],
        [1, 1, 2, 1, 2, 0, 1, 0, 1, 1, 2, 1, 0],
        [0, 1, 2, 3, 0, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 1, 5, 1, 1, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 2, 1, 2, 1, 1, 0, 0, 0, 1, 1, 1],
        [0, 1, 1, 4, 3, 0, 1, 0, 1, 0, 1, 0, 1],
        [1, 1, 1, 3, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 3, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 0, 0, 5, 2, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 2, 0, 1, 1, 1, 0, 0, 1, 2, 1, 0],
        [1, 1, 1, 1, 2, 0, 1, 0, 0, 1, 0, 1, 1],
        [0, 1, 2, 2, 3, 1, 1, 0, 1, 0, 1, 0, 0],
        [1, 1, 3, 1, 3, 1, 1, 0, 0, 0, 1, 1, 1],
        [0, 1, 2, 1, 1, 0, 1, 0, 1, 1, 0, 1, 1],
        [0, 1, 1, 3, 2, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 1, 3, 2, 0, 1, 0, 1, 1, 2, 1, 0],
        [0, 1, 2, 2, 1, 0, 1, 0, 0, 0, 0, 0, 0],
        [0, 0, 3, 1, 0, 0, 1, 0, 0, 1, 2, 0, 1],
        [1, 1, 0, 3, 0, 0, 1, 0, 1, 0, 2, 1, 0],
        [1, 2, 2, 0, 0, 1, 1, 0, 1, 1, 0, 0, 0],
        [0, 1, 3, 3, 1, 0, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 1, 0, 1, 1, 1, 0, 0, 1, 1, 0, 1],
        [0, 1, 3, 4, 1, 1, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 2, 4, 2, 0, 1, 0, 0, 1, 1, 0, 1],
        [1, 1, 2, 4, 3, 0, 1, 0, 1, 0, 1, 1, 1],
        [1, 2, 1, 5, 3, 1, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 2, 0, 2, 1, 1, 0, 1, 0, 1, 1, 1],
        [1, 1, 0, 3, 3, 1, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 0, 3, 2, 0, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 2, 4, 3, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 3, 4, 3, 0, 2, 0, 1, 1, 1, 1, 1],
        [1, 1, 0, 4, 0, 1, 1, 0, 0, 0, 2, 0, 1],
        [1, 2, 2, 1, 2, 1, 1, 0, 0, 1, 0, 1, 1],
        [0, 1, 0, 0, 1, 1, 1, 0, 1, 0, 2, 1, 0],
        [0, 0, 2, 4, 0, 1, 1, 0, 0, 1, 2, 0, 1],
        [0, 1, 2, 3, 1, 0, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 1, 4, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 3, 1, 3, 1, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 0, 1, 1, 0, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 3, 3, 3, 0, 1, 1, 0, 1, 1, 1, 0],
        [1, 1, 1, 2, 1, 1, 1, 0, 0, 1, 1, 1, 0],
        [0, 2, 0, 3, 3, 1, 2, 0, 0, 1, 1, 1, 1],
        [1, 1, 2, 0, 1, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 1, 1, 3, 0, 1, 0, 0, 0, 0, 0, 0],
        [0, 1, 3, 3, 1, 1, 2, 1, 1, 0, 0, 1, 1],
        [0, 1, 1, 1, 0, 0, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 2, 2, 3, 1, 1, 0, 0, 1, 2, 1, 0],
        [1, 1, 0, 3, 0, 0, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 2, 0, 1, 1, 1, 0, 0, 0, 2, 0, 0],
        [1, 2, 2, 4, 3, 1, 1, 0, 0, 1, 1, 1, 1],
        [0, 1, 1, 3, 2, 0, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 0, 0, 3, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 2, 4, 3, 1, 1, 0, 0, 0, 2, 1, 1],
        [1, 1, 2, 1, 3, 0, 1, 0, 0, 1, 0, 1, 0],
        [0, 1, 2, 4, 0, 1, 1, 0, 0, 0, 1, 1, 1],
        [1, 1, 2, 5, 0, 1, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 0, 2, 1, 1, 1, 0, 1, 0, 0, 1, 1],
        [1, 1, 0, 4, 1, 1, 1, 1, 0, 1, 0, 0, 0],
        [1, 2, 2, 3, 2, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 0, 3, 1, 0, 1, 0, 1, 0, 2, 0, 1],
        [1, 1, 3, 5, 1, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 0, 3, 1, 1, 1, 1, 0, 0, 0, 3, 1, 1],
        [1, 1, 2, 3, 2, 1, 1, 0, 1, 0, 1, 0, 0],
        [0, 1, 2, 4, 3, 0, 0, 0, 1, 0, 0, 1, 1],
        [0, 1, 2, 3, 0, 1, 1, 0, 0, 0, 2, 0, 0],
        [1, 1, 0, 5, 0, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 0, 4, 2, 1, 1, 0, 0, 1, 3, 0, 0],
        [1, 1, 0, 1, 1, 0, 1, 0, 1, 0, 0, 0, 1],
        [1, 1, 0, 3, 3, 0, 1, 0, 1, 1, 1, 0, 0],
        [1, 1, 2, 3, 0, 1, 1, 0, 1, 1, 2, 1, 0],
        [1, 1, 2, 3, 1, 1, 1, 0, 1, 0, 0, 1, 0],
        [1, 1, 1, 4, 1, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 2, 5, 3, 1, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 1, 3, 1, 0, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 3, 3, 0, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 3, 3, 0, 1, 1, 0, 0, 0, 2, 0, 0],
        [0, 1, 3, 3, 2, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 2, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1],
        [1, 1, 2, 3, 1, 0, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 2, 3, 2, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 2, 4, 2, 1, 1, 0, 1, 1, 1, 1, 1],
        [1, 1, 0, 2, 2, 1, 2, 0, 0, 1, 1, 0, 1],
        [0, 1, 1, 4, 1, 0, 1, 0, 1, 0, 1, 1, 0],
        [0, 1, 2, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0],
        [0, 1, 0, 0, 1, 1, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 2, 4, 3, 1, 1, 0, 1, 0, 0, 1, 1],
        [1, 1, 1, 1, 3, 0, 1, 0, 0, 1, 2, 0, 0],
        [0, 1, 0, 5, 1, 0, 1, 0, 0, 0, 2, 0, 0],
        [0, 1, 1, 3, 1, 1, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 2, 4, 1, 1, 1, 0, 1, 1, 1, 1, 1],
        [0, 1, 3, 4, 1, 1, 2, 0, 0, 0, 2, 0, 0],
        [0, 1, 2, 0, 2, 1, 1, 0, 0, 1, 2, 0, 0],
        [0, 1, 2, 3, 1, 1, 1, 0, 0, 1, 2, 1, 0],
        [0, 1, 0, 5, 1, 1, 1, 0, 0, 0, 2, 1, 1],
        [0, 1, 3, 2, 1, 1, 1, 0, 0, 1, 2, 0, 0],
        [1, 0, 2, 4, 1, 1, 1, 0, 0, 1, 0, 0, 1],
        [0, 1, 3, 1, 2, 1, 1, 0, 0, 1, 1, 0, 1],
        [0, 1, 2, 3, 1, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 1, 3, 3, 1, 1, 0, 1, 0, 3, 0, 0],
        [1, 1, 3, 3, 1, 1, 1, 0, 0, 1, 0, 1, 0],
        [0, 0, 1, 1, 2, 0, 1, 0, 0, 1, 1, 0, 1],
        [1, 1, 0, 1, 3, 1, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 2, 4, 1, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 0, 4, 0, 0, 1, 0, 0, 1, 0, 0, 1],
        [0, 1, 3, 4, 0, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 0, 3, 2, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 2, 4, 3, 1, 1, 0, 0, 0, 1, 0, 1],
        [0, 2, 1, 0, 1, 0, 1, 0, 1, 1, 0, 0, 0],
        [0, 1, 2, 5, 0, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 0, 5, 1, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 2, 3, 2, 1, 1, 1, 0, 1, 0, 0, 1, 1],
        [0, 1, 1, 4, 3, 0, 2, 0, 0, 1, 0, 1, 0],
        [0, 0, 1, 4, 1, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 2, 4, 1, 1, 1, 0, 0, 1, 2, 1, 1],
        [1, 1, 0, 5, 0, 0, 1, 0, 1, 0, 0, 1, 1],
        [0, 1, 0, 1, 2, 1, 1, 0, 1, 1, 1, 0, 1],
        [0, 1, 2, 3, 3, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 3, 4, 3, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 3, 3, 3, 0, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 3, 3, 3, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 3, 1, 1, 1, 1, 0, 0, 0, 1, 0, 1],
        [0, 1, 3, 0, 0, 0, 1, 0, 0, 1, 2, 0, 0],
        [0, 1, 2, 4, 3, 1, 1, 0, 1, 1, 1, 1, 1],
        [0, 1, 1, 0, 1, 0, 1, 1, 0, 0, 1, 1, 0],
        [1, 1, 3, 3, 3, 0, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 3, 3, 2, 1, 1, 0, 1, 0, 1, 0, 0],
        [1, 1, 2, 4, 2, 0, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 2, 4, 2, 0, 1, 0, 0, 1, 1, 1, 1],
        [1, 2, 0, 3, 0, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 2, 4, 3, 0, 1, 0, 1, 1, 2, 1, 0],
        [0, 1, 2, 4, 0, 0, 1, 0, 1, 0, 0, 0, 0],
        [0, 1, 0, 2, 3, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 1, 4, 2, 1, 1, 0, 1, 1, 2, 0, 1],
        [1, 1, 0, 5, 0, 1, 1, 0, 0, 0, 0, 0, 0],
        [1, 0, 2, 4, 1, 1, 1, 0, 1, 1, 2, 1, 0],
        [1, 1, 3, 3, 1, 0, 1, 0, 0, 1, 0, 1, 1],
        [0, 1, 2, 1, 1, 1, 1, 0, 1, 1, 0, 1, 1],
        [0, 1, 2, 3, 1, 0, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 2, 4, 1, 1, 1, 0, 0, 0, 2, 1, 1],
        [0, 1, 2, 3, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 0, 3, 0, 0, 1, 0, 0, 1, 2, 0, 0],
        [0, 1, 1, 5, 2, 1, 1, 0, 0, 1, 0, 1, 1],
        [1, 2, 0, 1, 2, 1, 1, 0, 0, 0, 2, 1, 0],
        [1, 0, 3, 3, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 0, 4, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 2, 3, 1, 0, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 2, 3, 2, 1, 1, 0, 0, 0, 0, 0, 0],
        [0, 1, 1, 5, 3, 1, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 1, 3, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 0, 2, 1, 0, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 1, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 3, 2, 2, 1, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 2, 4, 1, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 1, 5, 3, 0, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 0, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1],
        [1, 1, 2, 3, 3, 0, 2, 0, 0, 0, 0, 1, 0],
        [0, 1, 3, 4, 1, 1, 1, 0, 0, 1, 1, 1, 0],
        [0, 0, 0, 3, 0, 1, 1, 0, 1, 1, 1, 1, 1],
        [1, 2, 0, 2, 1, 1, 1, 0, 0, 0, 0, 0, 1],
        [1, 1, 1, 3, 2, 1, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 2, 5, 1, 1, 1, 0, 0, 1, 2, 0, 1],
        [1, 1, 1, 1, 3, 1, 1, 0, 0, 0, 0, 1, 0],
        [0, 0, 3, 4, 2, 0, 1, 0, 1, 0, 3, 0, 1],
        [1, 1, 1, 3, 0, 1, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 2, 3, 2, 1, 1, 0, 0, 0, 3, 0, 0],
        [0, 1, 2, 4, 1, 0, 1, 0, 0, 0, 1, 1, 1],
        [1, 1, 0, 3, 3, 1, 1, 0, 1, 1, 1, 1, 1],
        [0, 2, 1, 2, 1, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 2, 2, 4, 0, 1, 1, 0, 0, 1, 0, 1, 1],
        [0, 1, 2, 3, 2, 1, 1, 0, 0, 1, 1, 0, 1],
        [1, 1, 0, 4, 0, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 1, 4, 1, 1, 1, 0, 0, 1, 0, 1, 1],
        [1, 1, 2, 1, 1, 0, 1, 0, 0, 0, 2, 0, 1],
        [0, 1, 0, 4, 3, 1, 1, 0, 0, 0, 0, 0, 1],
        [0, 1, 2, 1, 2, 1, 1, 0, 1, 0, 3, 0, 0],
        [1, 2, 2, 4, 2, 1, 1, 0, 1, 0, 2, 0, 1],
        [1, 1, 0, 2, 1, 0, 0, 0, 0, 0, 3, 1, 1],
        [1, 1, 0, 3, 3, 1, 1, 0, 0, 0, 3, 0, 0],
        [0, 1, 1, 3, 1, 1, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 2, 3, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 3, 0, 0, 1, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 3, 4, 1, 0, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 3, 4, 1, 0, 1, 0, 1, 0, 2, 1, 0],
        [0, 1, 1, 3, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 2, 1, 2, 1, 1, 0, 0, 1, 3, 1, 1],
        [0, 1, 1, 5, 0, 1, 1, 0, 1, 1, 0, 1, 0],
        [1, 1, 0, 3, 1, 1, 1, 0, 0, 0, 2, 1, 1],
        [1, 1, 2, 3, 0, 1, 2, 0, 0, 0, 2, 1, 0],
        [0, 1, 3, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 1, 1, 2, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 1, 2, 0, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 0, 1, 0, 0, 1, 0, 0, 0, 2, 0, 0],
        [0, 1, 1, 4, 1, 0, 1, 0, 0, 0, 0, 1, 0],
        [1, 0, 2, 3, 1, 0, 1, 0, 0, 0, 1, 1, 1],
        [0, 1, 0, 5, 1, 0, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 3, 4, 2, 1, 1, 0, 1, 1, 2, 1, 0],
        [1, 1, 1, 3, 1, 1, 1, 0, 1, 0, 3, 1, 1],
        [1, 1, 2, 5, 1, 0, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 0, 1, 1, 0, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 0, 1, 3, 1, 1, 0, 1, 0, 3, 1, 1],
        [1, 1, 0, 4, 0, 1, 1, 0, 0, 0, 0, 1, 1],
        [1, 1, 2, 3, 3, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 0, 4, 1, 0, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 3, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0],
        [1, 1, 0, 2, 1, 1, 1, 0, 1, 1, 1, 1, 0],
        [1, 2, 1, 4, 1, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 1, 3, 1, 1, 1, 1, 0, 0, 1, 1, 0],
        [1, 1, 0, 1, 3, 1, 1, 0, 0, 0, 1, 1, 1],
        [1, 1, 3, 1, 0, 1, 1, 0, 1, 1, 1, 1, 1],
        [1, 0, 0, 4, 3, 0, 1, 0, 1, 1, 1, 1, 1],
        [0, 1, 0, 1, 2, 0, 1, 0, 0, 0, 1, 0, 1],
        [0, 2, 0, 4, 0, 1, 1, 1, 0, 1, 0, 1, 0],
        [0, 1, 2, 1, 2, 1, 1, 0, 0, 0, 1, 1, 1],
        [0, 1, 2, 4, 3, 1, 1, 0, 1, 0, 1, 0, 0],
        [0, 1, 0, 3, 0, 1, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 0, 4, 0, 0, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 0, 3, 3, 1, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 0, 5, 1, 0, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 0, 2, 2, 0, 2, 0, 1, 0, 1, 1, 1],
        [0, 0, 1, 3, 1, 0, 2, 0, 0, 0, 1, 1, 1],
        [0, 0, 2, 3, 2, 1, 1, 0, 0, 1, 2, 0, 1],
        [0, 1, 1, 1, 2, 1, 1, 0, 0, 1, 3, 0, 1],
        [0, 1, 2, 1, 1, 1, 1, 0, 0, 1, 0, 0, 1],
        [0, 1, 2, 2, 3, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 2, 1, 0, 0, 1, 0, 1, 0, 2, 1, 1],
        [1, 1, 2, 4, 0, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 0, 3, 1, 0, 0, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 2, 2, 0, 1, 1, 0, 1, 1, 1, 0, 1],
        [1, 1, 1, 3, 2, 1, 1, 0, 0, 0, 2, 0, 0],
        [0, 1, 0, 1, 1, 1, 2, 0, 1, 0, 1, 0, 0],
        [1, 1, 2, 5, 1, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 0, 0, 1, 1, 1, 0, 0, 1, 2, 1, 0],
        [0, 1, 1, 3, 0, 1, 1, 0, 0, 1, 0, 1, 0],
        [1, 1, 2, 0, 1, 1, 1, 0, 0, 1, 1, 0, 1],
        [1, 1, 2, 4, 1, 0, 1, 0, 0, 1, 2, 1, 0],
        [0, 1, 3, 4, 0, 1, 1, 0, 1, 1, 1, 1, 1],
        [0, 1, 1, 3, 2, 1, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 2, 3, 2, 1, 1, 0, 1, 1, 2, 1, 1],
        [1, 1, 2, 1, 2, 1, 1, 0, 0, 1, 3, 0, 1],
        [0, 1, 0, 3, 2, 1, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 2, 4, 3, 1, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 2, 4, 1, 0, 1, 0, 0, 0, 2, 0, 0],
        [0, 1, 2, 1, 2, 0, 1, 1, 1, 1, 2, 0, 1],
        [1, 0, 1, 4, 3, 1, 2, 0, 0, 1, 1, 1, 1],
        [0, 1, 2, 3, 1, 1, 1, 0, 1, 0, 1, 1, 0],
        [1, 1, 2, 4, 0, 1, 1, 0, 1, 1, 1, 0, 0],
        [0, 1, 2, 3, 1, 0, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 0, 3, 3, 1, 1, 0, 0, 0, 0, 1, 1],
        [0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1],
        [0, 1, 0, 2, 2, 0, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 1, 3, 3, 0, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 0, 2, 1, 0, 1, 0, 0, 0, 3, 0, 0],
        [1, 1, 2, 3, 2, 1, 1, 0, 1, 0, 1, 1, 1],
        [0, 1, 0, 3, 1, 1, 1, 0, 0, 1, 1, 1, 0],
        [0, 1, 2, 3, 0, 0, 1, 0, 0, 1, 1, 1, 1],
        [0, 2, 1, 3, 3, 0, 1, 0, 0, 0, 1, 1, 1],
        [0, 2, 3, 4, 0, 1, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 2, 3, 2, 0, 2, 0, 0, 1, 1, 1, 1],
        [0, 0, 1, 2, 0, 1, 1, 0, 0, 0, 1, 1, 1],
        [0, 2, 0, 3, 0, 1, 1, 0, 0, 1, 0, 0, 1],
        [1, 0, 1, 0, 3, 1, 1, 0, 1, 1, 0, 0, 1],
        [1, 1, 3, 3, 3, 1, 1, 0, 0, 0, 2, 0, 0],
        [0, 1, 3, 3, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 3, 3, 0, 0, 1, 0, 1, 0, 1, 0, 0],
        [1, 1, 2, 3, 1, 0, 1, 0, 1, 0, 2, 1, 0],
        [1, 1, 2, 0, 1, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 2, 1, 0, 0, 1, 0, 1, 1, 2, 0, 1],
        [0, 1, 2, 3, 1, 1, 1, 0, 1, 0, 3, 1, 1],
        [1, 1, 3, 4, 2, 1, 1, 0, 0, 1, 2, 1, 0],
        [0, 1, 0, 2, 2, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 0, 1, 2, 0, 1, 0, 0, 1, 1, 0, 1],
        [0, 1, 3, 4, 2, 1, 1, 1, 0, 1, 0, 1, 1],
        [0, 2, 2, 3, 2, 0, 1, 0, 0, 0, 2, 0, 0],
        [0, 1, 0, 0, 3, 1, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 2, 2, 0, 1, 1, 0, 0, 1, 0, 1, 1],
        [0, 1, 0, 3, 1, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 3, 4, 1, 1, 1, 0, 1, 1, 0, 0, 0],
        [0, 1, 2, 4, 2, 1, 1, 0, 0, 0, 3, 0, 1],
        [1, 1, 2, 1, 3, 0, 1, 0, 0, 1, 1, 0, 1],
        [1, 1, 3, 3, 3, 1, 1, 1, 0, 0, 2, 0, 0],
        [1, 1, 2, 3, 2, 1, 1, 0, 0, 0, 0, 1, 1],
        [1, 2, 3, 3, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 2, 4, 3, 1, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 2, 3, 1, 0, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 2, 4, 2, 1, 1, 0, 0, 1, 2, 1, 1],
        [0, 1, 0, 3, 2, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 0, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1],
        [1, 1, 1, 1, 2, 1, 1, 0, 0, 0, 0, 1, 1],
        [1, 1, 0, 1, 2, 0, 1, 0, 0, 0, 0, 0, 1],
        [1, 1, 0, 1, 2, 1, 1, 0, 0, 1, 0, 1, 0],
        [0, 1, 2, 3, 2, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 2, 5, 1, 1, 1, 0, 0, 0, 2, 0, 0],
        [0, 1, 3, 1, 3, 1, 2, 0, 1, 1, 1, 1, 1],
        [0, 2, 1, 4, 1, 1, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 0, 0, 2, 1, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 3, 1, 1, 1, 2, 0, 0, 1, 1, 1, 1],
        [1, 0, 0, 1, 1, 1, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 1, 2, 0, 1, 1, 0, 0, 1, 0, 0, 0],
        [0, 1, 2, 3, 0, 1, 1, 0, 0, 1, 2, 1, 1],
        [1, 1, 2, 1, 1, 0, 1, 0, 1, 1, 1, 0, 1],
        [0, 1, 2, 4, 3, 1, 1, 0, 0, 1, 1, 1, 1],
        [0, 1, 3, 3, 1, 0, 1, 0, 1, 0, 1, 0, 0],
        [0, 1, 2, 4, 1, 0, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 1, 3, 1, 0, 1, 0, 1, 0, 0, 0, 1],
        [1, 1, 1, 3, 0, 1, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 2, 3, 1, 0, 1, 0, 1, 1, 3, 1, 0],
        [0, 1, 1, 3, 1, 0, 1, 1, 1, 1, 2, 0, 0],
        [0, 1, 0, 3, 1, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 0, 2, 1, 1, 1, 0, 0, 0, 2, 0, 0],
        [1, 1, 3, 0, 1, 1, 1, 0, 0, 0, 3, 0, 0],
        [0, 1, 0, 1, 3, 1, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 0, 5, 0, 1, 1, 0, 0, 0, 0, 0, 1],
        [0, 1, 3, 4, 3, 0, 1, 0, 1, 0, 1, 0, 0],
        [1, 1, 1, 5, 2, 1, 1, 0, 1, 0, 1, 0, 1],
        [1, 1, 3, 3, 1, 1, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 3, 3, 2, 1, 1, 0, 1, 1, 2, 0, 0],
        [1, 1, 0, 3, 2, 1, 1, 0, 0, 0, 1, 1, 1],
        [1, 1, 1, 1, 2, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 3, 2, 0, 0, 1, 0, 0, 0, 3, 0, 1],
        [0, 1, 1, 2, 3, 0, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 1, 3, 2, 0, 1, 0, 1, 0, 1, 1, 0],
        [1, 1, 1, 3, 3, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 3, 4, 3, 0, 1, 1, 0, 1, 0, 0, 0],
        [1, 1, 0, 3, 0, 1, 1, 0, 1, 1, 1, 1, 1],
        [1, 1, 3, 0, 2, 1, 1, 0, 0, 0, 3, 1, 0],
        [1, 1, 3, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 2, 4, 2, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 1, 4, 2, 1, 1, 0, 1, 1, 1, 0, 1],
        [1, 1, 1, 4, 1, 0, 1, 0, 0, 0, 1, 1, 0],
        [1, 2, 2, 1, 1, 1, 2, 0, 1, 0, 0, 1, 1],
        [0, 1, 1, 1, 2, 1, 1, 0, 0, 0, 2, 0, 0],
        [0, 1, 2, 3, 3, 0, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 3, 5, 2, 0, 1, 0, 0, 1, 3, 0, 0],
        [0, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1],
        [1, 1, 3, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 1, 3, 0, 0, 1, 0, 0, 0, 2, 1, 0],
        [1, 1, 3, 4, 1, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 0, 4, 2, 0, 1, 0, 0, 1, 1, 0, 1],
        [0, 1, 1, 4, 3, 0, 1, 0, 0, 1, 3, 1, 0],
        [0, 1, 2, 1, 0, 1, 1, 0, 1, 0, 1, 0, 0],
        [0, 1, 2, 3, 0, 0, 1, 0, 0, 0, 3, 1, 0],
        [0, 1, 1, 3, 0, 1, 1, 0, 1, 1, 3, 1, 0],
        [0, 1, 0, 1, 0, 0, 1, 0, 0, 1, 1, 0, 0],
        [0, 1, 0, 2, 0, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 0, 0, 0, 0, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 3, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1],
        [1, 1, 2, 3, 1, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 3, 4, 1, 0, 1, 0, 0, 0, 0, 0, 0],
        [1, 2, 1, 1, 1, 1, 1, 0, 1, 1, 0, 0, 0],
        [0, 1, 2, 1, 0, 1, 1, 0, 0, 0, 1, 1, 1],
        [1, 1, 0, 0, 1, 0, 1, 0, 1, 0, 2, 1, 0],
        [1, 1, 1, 3, 3, 0, 1, 0, 1, 1, 1, 0, 0],
        [1, 1, 2, 3, 1, 0, 1, 0, 1, 0, 1, 0, 0],
        [1, 1, 0, 3, 2, 0, 1, 0, 0, 0, 3, 1, 0],
        [1, 1, 0, 4, 0, 1, 1, 0, 0, 1, 3, 1, 1],
        [1, 1, 2, 3, 1, 0, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 0, 4, 0, 1, 1, 0, 0, 0, 0, 1, 0],
        [1, 1, 2, 0, 2, 1, 1, 0, 0, 1, 1, 0, 1],
        [0, 1, 2, 5, 2, 0, 1, 0, 0, 1, 1, 0, 1],
        [1, 2, 0, 3, 1, 1, 1, 0, 0, 0, 1, 0, 1],
        [0, 1, 0, 3, 2, 1, 1, 0, 0, 1, 2, 0, 0],
        [1, 1, 0, 3, 2, 1, 1, 0, 1, 1, 0, 0, 0],
        [0, 0, 0, 3, 1, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 3, 3, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [0, 1, 2, 4, 1, 1, 1, 0, 0, 0, 1, 0, 0],
        [1, 0, 1, 1, 0, 1, 2, 0, 0, 0, 1, 0, 1],
        [0, 1, 1, 3, 2, 1, 1, 0, 0, 0, 1, 1, 0],
        [0, 1, 3, 1, 1, 1, 1, 0, 1, 0, 0, 0, 0],
        [1, 1, 2, 4, 3, 0, 1, 0, 0, 1, 0, 1, 1],
        [0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 2, 3, 5, 1, 1, 1, 0, 0, 0, 2, 0, 0],
        [1, 1, 2, 4, 2, 1, 1, 0, 0, 1, 1, 0, 1],
        [1, 1, 2, 1, 1, 1, 1, 0, 0, 0, 1, 0, 1],
        [1, 1, 2, 5, 0, 0, 1, 0, 0, 0, 0, 1, 0],
        [0, 1, 0, 3, 1, 1, 1, 0, 0, 0, 0, 0, 0],
        [1, 1, 2, 3, 1, 0, 1, 0, 1, 0, 1, 0, 0],
        [1, 1, 2, 3, 0, 0, 1, 0, 0, 1, 2, 1, 0],
        [1, 1, 3, 4, 2, 1, 1, 0, 0, 0, 1, 1, 0],
        [1, 1, 0, 3, 1, 1, 1, 0, 1, 0, 1, 0, 0],
        [1, 1, 0, 3, 3, 1, 1, 0, 0, 1, 0, 0, 0],
        [1, 1, 2, 3, 2, 1, 1, 0, 0, 1, 1, 1, 1],
        [0, 1, 0, 4, 0, 0, 1, 0, 0, 1, 2, 0, 0],
        [0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 0, 3, 1, 0, 1, 0, 0, 1, 0, 0, 0],
        [1, 0, 2, 1, 2, 0, 1, 0, 0, 1, 0, 0, 1],
        [0, 1, 0, 4, 3, 1, 1, 0, 0, 0, 0, 1, 1],
        [0, 1, 3, 4, 1, 0, 1, 0, 0, 1, 3, 0, 0],
        [1, 1, 2, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0],
        [1, 1, 1, 0, 1, 1, 1, 0, 0, 0, 3, 1, 0],
        [1, 0, 0, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1],
        [1, 1, 0, 4, 0, 1, 1, 1, 1, 1, 2, 0, 0],
        [1, 1, 1, 3, 0, 0, 1, 0, 0, 1, 2, 1, 0],
        [0, 1, 3, 4, 2, 0, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 0, 3, 1, 1, 2, 0, 0, 1, 1, 1, 1],
        [1, 1, 2, 5, 0, 0, 1, 0, 0, 0, 2, 1, 0],
        [0, 1, 2, 1, 2, 1, 1, 0, 0, 1, 1, 0, 0],
        [1, 1, 2, 3, 0, 0, 1, 0, 0, 0, 1, 0, 0],
        [1, 1, 1, 3, 1, 1, 1, 0, 1, 0, 1, 1, 0],
    ]
