######################################################################################
# Copyright (c) 2023 Orange - All Rights Reserved                             #
# * This software is the confidential and proprietary information of Orange.         #
# * You shall not disclose such Restricted Information and shall use it only in      #
#   accordance with the terms of the license agreement you entered into with Orange  #
#   named the "kuplift - Python Library Evaluation License".                          #
# * Unauthorized copying of this file, via any medium is strictly prohibited.        #
# * See the "LICENSE.md" file for more details.                                      #
######################################################################################
from kuplift.BayesianRandomForest import BayesianRandomForest


def test_predict(test_dataframe):
    features = list(test_dataframe.columns[:-2])
    forest = BayesianRandomForest(test_dataframe, "segment", "visit", 4)
    forest.fit()
    preds = forest.predict(test_dataframe[features])
    list_preds = list(preds)
    assert list_preds == [
        -0.013219746751645639,
        0.14904929250191346,
        0.14904929250191346,
        -0.06334279001654182,
        0.1875774942569135,
        0.14904929250191346,
        0.03400466867671448,
        0.17278405005245606,
        0.10041892976911723,
        0.1133196884877159,
        0.13818562874703627,
        0.14793144821410487,
        0.11310456670476791,
        0.06359867877630405,
        0.08201085458528434,
        0.1362449261988209,
        0.03253755595674977,
        0.1376600470208036,
        0.10940324645910479,
        0.14904929250191346,
        -0.06334279001654182,
        0.14793144821410487,
        0.07479148673271584,
        0.04601768871925116,
        -0.06840878963589908,
        0.17278405005245606,
        0.14904929250191346,
        0.13831446283864487,
        0.14793144821410487,
        0.14904929250191346,
        0.11310456670476791,
        0.1376600470208036,
        0.07879822736035008,
        0.03019716125383405,
        0.17278405005245606,
        -0.035978472783555884,
        0.13818562874703627,
        0.05358833122647312,
        0.18218724567821637,
        0.06359867877630405,
        0.07389199310552778,
        -0.0662543685367901,
        0.14904929250191346,
        0.06352729285333147,
        0.10940324645910479,
        0.1331380040096474,
        0.17278405005245606,
        0.0354855353801658,
        0.18218724567821637,
        0.25612686579667193,
        -0.022939904672374417,
        0.0765453693554251,
        0.05989623314823175,
        0.03918240465157183,
        0.07480007100718264,
        0.10212688053130412,
        -0.022939904672374417,
        0.0765453693554251,
        0.22772925965723773,
        0.1331380040096474,
        0.005173238723763837,
        0.03253755595674977,
        0.17730609306361222,
        0.06359867877630405,
        0.10212688053130412,
        0.10940324645910479,
        -0.06334279001654182,
        0.04541856801053594,
        -0.022939904672374417,
        0.12562882590299418,
        -0.06334279001654182,
        0.24110758303971253,
        0.06426791766809728,
        0.12165690062809299,
        0.08562548556465976,
        -0.06334279001654182,
        0.17278405005245606,
        0.11310456670476791,
        0.11310456670476791,
        0.005173238723763837,
        0.10940324645910479,
        0.14904929250191346,
        0.005173238723763837,
        0.033610851790998465,
        0.14904929250191346,
        0.10214879366722657,
        0.17730609306361222,
        0.017904545323112905,
        0.0354855353801658,
        0.0354855353801658,
        0.14904929250191346,
        0.2187464430275592,
        0.10290463012885409,
        0.1153574247096929,
        0.06359867877630405,
        0.0894244973663527,
        0.05676339470862472,
        0.06359867877630405,
        0.17730609306361222,
        0.1376600470208036,
        0.1362449261988209,
        0.13379241982748868,
        0.1079881256371221,
        0.06426791766809728,
        0.0354855353801658,
        0.10858252369361174,
        0.06131135397021445,
        -0.022939904672374417,
        0.1875774942569135,
        0.022694883000443075,
        0.1875774942569135,
        0.1079881256371221,
        0.1331380040096474,
        0.1875774942569135,
        0.22772925965723773,
        0.10940324645910479,
        0.10858252369361174,
        0.005173238723763837,
        0.06359867877630405,
        -0.022939904672374417,
        0.1079881256371221,
        0.06359867877630405,
        0.003009291738628822,
        -0.013219746751645639,
        0.24922072480927973,
        0.003009291738628822,
        0.08562548556465976,
        0.17278405005245606,
        -0.06334279001654182,
        0.21422440001640303,
        0.05358833122647312,
        0.004424412560611518,
        0.10858252369361174,
        0.1233759678980692,
        0.14793144821410487,
        0.1875774942569135,
        0.17730609306361222,
        0.22787006523497316,
        -0.06334279001654182,
        0.005173238723763837,
        0.10940324645910479,
        0.14904929250191346,
        0.06285279684611458,
        0.14904929250191346,
        0.06359867877630405,
        0.03253755595674977,
        0.06426791766809728,
        0.08562548556465976,
        0.05529628198866002,
        0.14904929250191346,
        0.09014752857581594,
        0.10290463012885409,
        0.17278405005245606,
        0.14904929250191346,
        0.1014405943058651,
        -0.022939904672374417,
        0.1331380040096474,
        -0.013006872042004278,
        0.20399450210669512,
        0.14904929250191346,
        0.13799979165520793,
        0.23762466613936592,
        -0.022939904672374417,
        0.0354855353801658,
        0.10212688053130412,
        0.17278405005245606,
        0.05358833122647312,
        0.1376600470208036,
        0.14904929250191346,
        -0.013219746751645639,
        0.14904929250191346,
        0.1376600470208036,
        0.10940324645910479,
        0.05989623314823175,
        0.14904929250191346,
        0.06359867877630405,
        -0.022939904672374417,
        0.06131135397021445,
        0.1875774942569135,
        0.21422440001640303,
        0.003009291738628822,
        0.1317228831876647,
        0.1331380040096474,
        0.1079881256371221,
        0.10940324645910479,
        0.0765453693554251,
        -0.035978472783555884,
        0.07401373713516587,
        0.1362449261988209,
        0.10212688053130412,
        0.10940324645910479,
        0.10175526548930205,
        0.033610851790998465,
        0.14904929250191346,
        0.17278405005245606,
        0.14904929250191346,
        -0.022939904672374417,
        -0.3440379786063058,
        -0.013219746751645639,
        0.14904929250191346,
        0.09014752857581594,
        -0.035978472783555884,
        0.0354855353801658,
        0.10940324645910479,
        0.005173238723763837,
        0.05676339470862472,
        0.1875774942569135,
        0.14904929250191346,
        0.005173238723763837,
        0.10359399325126883,
        -0.022939904672374417,
        0.034070414558183104,
        0.1376600470208036,
        -0.013219746751645639,
        0.21422440001640303,
        0.06359867877630405,
        0.14904929250191346,
        0.18218724567821637,
        0.2187464430275592,
        0.1376600470208036,
        0.10940324645910479,
        0.21422440001640303,
        0.07337636591073314,
        0.17278405005245606,
        0.0765453693554251,
        0.17278405005245606,
        0.1331380040096474,
        0.14904929250191346,
        0.17278405005245606,
        0.021999243363311813,
        0.1317228831876647,
        0.1331380040096474,
        0.09014752857581594,
        0.1331380040096474,
        0.05358833122647312,
        0.003009291738628822,
        0.10858252369361174,
        0.14904929250191346,
        0.005173238723763837,
        0.14904929250191346,
        0.185496999897559,
        0.17278405005245606,
        0.06359867877630405,
        0.014357445190981658,
        0.1875774942569135,
        0.06359867877630405,
        0.10940324645910479,
        0.0765453693554251,
        -0.013219746751645639,
        0.18218724567821637,
        0.1479950455269074,
        0.07337636591073314,
        0.13818562874703627,
        0.1407468957142694,
        -0.017708002343724327,
        0.1317228831876647,
        0.20399450210669512,
        0.17730609306361222,
        0.1233759678980692,
        -0.050508826412655874,
        0.03253755595674977,
        0.17730609306361222,
        0.09089161008631741,
        0.1376600470208036,
        0.17730609306361222,
        0.1362449261988209,
        -0.013219746751645639,
        0.11310456670476791,
        0.0765453693554251,
        0.1331380040096474,
        0.13818562874703627,
        0.11083538169853671,
        0.10940324645910479,
        0.11310456670476791,
        0.1317228831876647,
        0.17730609306361222,
        0.20399450210669512,
        0.0354855353801658,
        0.09238106106423553,
        0.14904929250191346,
        0.17730609306361222,
        0.1778316747898449,
        0.09014752857581594,
        0.005173238723763837,
        0.14904929250191346,
        0.17278405005245606,
        -0.013219746751645639,
        0.10940324645910479,
        0.06426791766809728,
        0.10858252369361174,
        -0.06334279001654182,
        0.14904929250191346,
        0.09014752857581594,
        0.1317228831876647,
        0.1376600470208036,
        0.006640351443728543,
        -0.013006872042004278,
        0.13347774864405176,
        0.22901784422086047,
        0.17278405005245606,
        0.10940324645910479,
        0.1331380040096474,
        0.22901784422086047,
        0.005173238723763837,
        0.14793144821410487,
        0.10940324645910479,
        0.14904929250191346,
        -0.024559630001652635,
        0.17730609306361222,
        0.0354855353801658,
        0.12562882590299418,
        0.17278405005245606,
        0.033610851790998465,
        0.14651632739212217,
        0.06359867877630405,
        0.10858252369361174,
        0.17278405005245606,
        0.05676339470862472,
        0.08562548556465976,
        0.10940324645910479,
        0.14904929250191346,
        0.05358833122647312,
        -0.022939904672374417,
        0.17278405005245606,
        0.01648942450113021,
        0.17278405005245606,
        0.07389199310552778,
        -0.06334279001654182,
        0.1079881256371221,
        0.10041892976911723,
        0.1233759678980692,
        0.1376600470208036,
        0.1331380040096474,
        -0.022939904672374417,
        0.13379241982748868,
        0.1331380040096474,
        0.1331380040096474,
        0.13818562874703627,
        0.08059573376330165,
        0.003009291738628822,
        0.14651632739212217,
        -0.06334279001654182,
        -0.06334279001654182,
        0.1875774942569135,
        0.0765453693554251,
        0.14904929250191346,
        0.1704020712293876,
        0.17730609306361222,
        0.09014752857581594,
        0.14904929250191346,
        0.01558472616076479,
        -0.013219746751645639,
        0.06359867877630405,
        0.0354855353801658,
        0.03253755595674977,
        -0.013006872042004278,
        0.13831446283864487,
        0.14904929250191346,
        0.14904929250191346,
        -0.01076857664967893,
        0.10290463012885409,
        0.1778316747898449,
        0.18070469606897407,
        0.14793144821410487,
        0.06206018013336677,
        -0.013006872042004278,
        0.17278405005245606,
        0.21422440001640303,
        -0.013219746751645639,
        0.14904929250191346,
        0.1376600470208036,
        0.06359867877630405,
        0.1376600470208036,
        0.17278405005245606,
        0.1331380040096474,
        0.0354855353801658,
        -0.013219746751645639,
        0.1407468957142694,
        0.08562548556465976,
        0.06206018013336677,
        0.17730609306361222,
        0.1362449261988209,
        0.10290463012885409,
        -0.19028438469297776,
        0.11310456670476791,
        0.17278405005245606,
        0.14904929250191346,
        0.17730609306361222,
        0.17278405005245606,
        0.17278405005245606,
        0.10357386902064732,
        0.22772925965723773,
        0.17730609306361222,
        0.10940324645910479,
        0.1331380040096474,
        0.07479148673271584,
        0.1079881256371221,
        0.04541856801053594,
        0.17278405005245606,
        0.17278405005245606,
        0.022694883000443075,
        0.2187464430275592,
        0.17730609306361222,
        0.10212688053130412,
        0.017904545323112905,
        0.10212688053130412,
        0.1875774942569135,
        0.1079881256371221,
        0.1331380040096474,
        0.1079881256371221,
        0.05080802639658133,
        0.10858252369361174,
        0.06359867877630405,
        0.2187464430275592,
        0.03253755595674977,
        0.14904929250191346,
        0.17278405005245606,
        0.005173238723763837,
        0.18218724567821637,
        0.10175526548930205,
        0.1875774942569135,
        0.17730609306361222,
        0.1376600470208036,
        0.0894244973663527,
        0.17730609306361222,
        0.17278405005245606,
        -0.035978472783555884,
        0.14904929250191346,
        0.0354855353801658,
        0.033947036737228514,
        0.07879822736035008,
        0.05358833122647312,
        0.07389199310552778,
        -0.022939904672374417,
        0.1317228831876647,
        0.07879822736035008,
        0.0765453693554251,
        0.1875774942569135,
        0.03253755595674977,
        0.17278405005245606,
        0.0765453693554251,
        -0.013219746751645639,
        0.10175526548930205,
        0.034070414558183104,
        0.17278405005245606,
        0.07479148673271584,
        0.14904929250191346,
        0.2187464430275592,
        0.00882082801605804,
        0.1331380040096474,
        0.17730609306361222,
        0.14904929250191346,
        0.0765453693554251,
        0.0765453693554251,
        -0.012371350430121317,
        0.005173238723763837,
        0.09014752857581594,
        0.14793144821410487,
        0.0765453693554251,
        0.14904929250191346,
        0.034070414558183104,
        0.1875774942569135,
        0.09014752857581594,
        0.08201085458528434,
        -0.30550977685130576,
        0.14904929250191346,
        0.10175526548930205,
        0.14904929250191346,
        0.005173238723763837,
        0.13831446283864487,
        0.1875774942569135,
        0.14904929250191346,
        0.048126779368608076,
        -0.022939904672374417,
        0.005173238723763837,
        -0.05321580042560864,
        0.0765453693554251,
        0.1376600470208036,
        0.04527180678906169,
        -0.022939904672374417,
        0.17278405005245606,
        0.04452417525394842,
        0.14904929250191346,
        0.03253755595674977,
        0.05080802639658133,
        0.17278405005245606,
        0.17730609306361222,
        0.00882082801605804,
        0.17278405005245606,
        0.05080802639658133,
        0.004424412560611518,
        0.033610851790998465,
        0.05358833122647312,
        0.25612686579667193,
        -0.22127976163106342,
        -0.038132893882664866,
        0.12562882590299418,
        -0.013219746751645639,
        0.21422440001640303,
        0.07389199310552778,
        0.1376600470208036,
        0.10940324645910479,
        0.07480007100718264,
        0.0354855353801658,
        0.0354855353801658,
        0.07259861631318318,
        0.1317228831876647,
        0.17278405005245606,
        0.05358833122647312,
        0.10940324645910479,
        0.14904929250191346,
        0.10175526548930205,
        0.20475507403854515,
        -0.013219746751645639,
        0.007916613639884343,
        0.17278405005245606,
        0.033947036737228514,
        0.17730609306361222,
        0.1362449261988209,
        0.003009291738628822,
        0.17278405005245606,
        0.06359867877630405,
        0.14024960123170732,
        0.10212688053130412,
        0.22787006523497316,
        0.0765453693554251,
        0.1376600470208036,
        0.20399450210669512,
        0.14793144821410487,
        -0.013219746751645639,
        -0.038132893882664866,
        0.1778316747898449,
        -0.06334279001654182,
        0.17730609306361222,
        0.10175526548930205,
        0.1376600470208036,
        0.18218724567821637,
        0.10858252369361174,
        0.10212688053130412,
        0.17730609306361222,
        0.10175526548930205,
        0.10940324645910479,
        0.1014405943058651,
        0.03918240465157183,
        -0.022939904672374417,
        0.18218724567821637,
        0.05358833122647312,
        0.14904929250191346,
        0.10940324645910479,
        0.17730609306361222,
        0.13677050792505357,
        0.18218724567821637,
        0.11310456670476791,
        0.14904929250191346,
        0.06359867877630405,
        0.0354855353801658,
        0.005173238723763837,
        0.005173238723763837,
        0.06359867877630405,
        -0.22127976163106342,
        0.10858252369361174,
        0.17730609306361222,
        0.1376600470208036,
        0.08562548556465976,
        0.1317228831876647,
        0.08562548556465976,
        0.017904545323112905,
        0.17730609306361222,
        0.1079881256371221,
        0.0765453693554251,
        0.1331380040096474,
        0.04541856801053594,
        0.06359867877630405,
        0.1376600470208036,
        0.10940324645910479,
        0.07479148673271584,
        0.03253755595674977,
        0.18218724567821637,
        0.18218724567821637,
        0.17278405005245606,
        0.07337636591073314,
        -0.01076857664967893,
        0.14904929250191346,
        -0.013219746751645639,
        0.06359867877630405,
        -0.038132893882664866,
        0.11310456670476791,
        0.03253755595674977,
        0.0765453693554251,
        0.1331380040096474,
        -0.013219746751645639,
        0.09014752857581594,
        0.05676339470862472,
        0.1362449261988209,
        0.17730609306361222,
        0.10858252369361174,
        0.05358833122647312,
        -0.06334279001654182,
        0.10858252369361174,
        0.14904929250191346,
        0.14904929250191346,
        0.005173238723763837,
        0.06359867877630405,
        -0.022939904672374417,
        0.005173238723763837,
        0.1778316747898449,
        0.05358833122647312,
        0.1317228831876647,
        -0.013219746751645639,
        0.14793144821410487,
        0.17730609306361222,
        0.03253755595674977,
        -0.013219746751645639,
        0.1376600470208036,
        0.13379241982748868,
        0.14904929250191346,
        0.06359867877630405,
        0.13831446283864487,
        0.10940324645910479,
        0.10175526548930205,
        0.08562548556465976,
        0.005173238723763837,
        0.07259861631318318,
        0.1079881256371221,
        0.1331380040096474,
        0.09014752857581594,
        0.033947036737228514,
        0.07259861631318318,
        0.18218724567821637,
        0.07879822736035008,
        0.1079881256371221,
        0.1778316747898449,
        0.005173238723763837,
        -0.038132893882664866,
        0.25612686579667193,
        0.1331380040096474,
        0.10940324645910479,
        0.0354855353801658,
        0.14904929250191346,
        0.14307103664001752,
        0.17278405005245606,
        0.1233759678980692,
        0.20514422338329186,
        0.1376600470208036,
        0.09762675065607039,
        0.06359867877630405,
        0.005173238723763837,
        0.003009291738628822,
        0.14904929250191346,
        0.17278405005245606,
        0.17278405005245606,
        0.10858252369361174,
        0.1331380040096474,
        0.17730609306361222,
        0.033610851790998465,
        0.14904929250191346,
        0.14904929250191346,
        0.10858252369361174,
        0.0765453693554251,
        0.2566524475229046,
        0.14904929250191346,
        0.005173238723763837,
        0.17556396726718887,
        0.05358833122647312,
        0.11310456670476791,
        0.10940324645910479,
        0.18218724567821637,
        0.06359867877630405,
        0.0765453693554251,
        0.11083538169853671,
        0.14793144821410487,
        -0.035978472783555884,
        0.302430071624779,
        0.20399450210669512,
        0.03253755595674977,
        0.17730609306361222,
        0.1362449261988209,
        0.14143283188385417,
        0.0765453693554251,
        0.10940324645910479,
        -0.05321580042560864,
        -0.022939904672374417,
        0.22901784422086047,
        0.1233759678980692,
        0.06359867877630405,
        0.005173238723763837,
        0.17278405005245606,
        0.10940324645910479,
        0.17278405005245606,
        0.1153574247096929,
        0.14904929250191346,
        0.1407468957142694,
        0.18218724567821637,
        -0.035978472783555884,
        0.07479148673271584,
        0.1331380040096474,
        0.005173238723763837,
        0.17278405005245606,
        0.14904929250191346,
        0.0354855353801658,
        0.0354855353801658,
        0.007501893790152626,
        0.17278405005245606,
        0.003009291738628822,
        0.17556396726718887,
        0.005173238723763837,
        0.10212688053130412,
        -0.035978472783555884,
        0.042949043393750726,
        0.22787006523497316,
        0.17730609306361222,
        0.08562548556465976,
        0.14904929250191346,
        -0.022939904672374417,
        0.07879822736035008,
        0.0354855353801658,
        0.11310456670476791,
        0.083946769765536,
        0.1875774942569135,
        0.17730609306361222,
        0.10290463012885409,
        -0.013219746751645639,
        0.10940324645910479,
        0.13818562874703627,
        -0.013006872042004278,
        0.09014752857581594,
        0.10940324645910479,
        0.10212688053130412,
        0.011990149382231315,
        0.1317228831876647,
        0.17278405005245606,
        0.1079881256371221,
        0.10940324645910479,
        0.034070414558183104,
        0.13818562874703627,
        0.0354855353801658,
        0.2187464430275592,
        0.05529628198866002,
        0.13347774864405176,
        0.10175526548930205,
        -0.01076857664967893,
        0.1331380040096474,
        0.04601768871925116,
        0.17730609306361222,
        0.1875774942569135,
        -0.3440379786063058,
        0.17556396726718887,
        0.1778316747898449,
        0.1079881256371221,
        0.17278405005245606,
        0.10940324645910479,
        0.1331380040096474,
        0.06359867877630405,
        0.14904929250191346,
        0.14904929250191346,
        0.14904929250191346,
        0.0354855353801658,
        0.1376600470208036,
        0.09606934606117476,
        0.24922072480927973,
        0.05358833122647312,
        0.14904929250191346,
        0.13799979165520793,
        0.09014752857581594,
        0.17278405005245606,
        0.1362449261988209,
        0.1331380040096474,
        0.0354855353801658,
        0.1331380040096474,
        0.1875774942569135,
        0.1331380040096474,
        0.25612686579667193,
        0.1875774942569135,
        0.13677050792505357,
        0.14904929250191346,
        -0.1587232932916205,
        0.06359867877630405,
        0.12165690062809299,
        -0.013219746751645639,
        0.10940324645910479,
        0.10359399325126883,
        0.06359867877630405,
        0.10940324645910479,
        0.005173238723763837,
        0.05882074792487542,
        -0.013219746751645639,
        0.14904929250191346,
        0.17278405005245606,
        0.0765453693554251,
        0.03253755595674977,
        0.2187464430275592,
        0.17278405005245606,
        0.1153574247096929,
        0.03253755595674977,
        0.005173238723763837,
        0.05080802639658133,
        0.1331380040096474,
        0.3432254739552471,
        0.07401373713516587,
        0.20514422338329186,
        0.14904929250191346,
        0.10858252369361174,
        0.17556396726718887,
        0.005173238723763837,
        0.0354855353801658,
        0.06359867877630405,
        0.06285279684611458,
        0.1362449261988209,
        0.10940324645910479,
        0.05358833122647312,
        -0.06334279001654182,
        0.23136176357264393,
        0.07879822736035008,
        0.17278405005245606,
        0.17556396726718887,
        0.17730609306361222,
        0.04722256499243438,
        0.06359867877630405,
        0.05882074792487542,
        -0.06334279001654182,
        -0.06334279001654182,
        0.1376600470208036,
        0.07401373713516587,
        0.14904929250191346,
        0.0765453693554251,
        -0.035978472783555884,
        0.1875774942569135,
        0.14904929250191346,
        0.033610851790998465,
        0.13677050792505357,
        -0.038132893882664866,
        0.17278405005245606,
        0.10940324645910479,
        0.005173238723763837,
        0.17278405005245606,
        0.1362449261988209,
        0.1376600470208036,
        0.14904929250191346,
        0.1233759678980692,
        0.20591459220285102,
        -0.013219746751645639,
        0.17278405005245606,
        0.10212688053130412,
        0.25612686579667193,
        0.09238106106423553,
        0.12562882590299418,
        0.06426791766809728,
        0.1778316747898449,
        0.14904929250191346,
        -0.022939904672374417,
        0.1079881256371221,
        -0.024559630001652635,
        0.17730609306361222,
        0.11310456670476791,
        0.10940324645910479,
        0.1875774942569135,
        0.034070414558183104,
        0.17278405005245606,
        0.1376600470208036,
        -0.008760162040994855,
        0.10940324645910479,
        0.04541856801053594,
        0.14904929250191346,
        0.17278405005245606,
        0.17278405005245606,
        0.1317228831876647,
        0.0765453693554251,
        0.18218724567821637,
        0.17278405005245606,
        -0.013219746751645639,
        0.14904929250191346,
        0.22787006523497316,
        0.13799979165520793,
        0.0354855353801658,
        0.10940324645910479,
        0.09238106106423553,
        0.10858252369361174,
        -0.06334279001654182,
        -0.022939904672374417,
        0.1079881256371221,
        0.17278405005245606,
        0.17278405005245606,
        0.1376600470208036,
        0.005173238723763837,
        -0.038132893882664866,
        0.17730609306361222,
        -0.004874038739838382,
        0.23225130266839394,
        0.011990149382231315,
        0.016715779968542253,
        0.17278405005245606,
        0.10041892976911723,
        0.10940324645910479,
        0.14904929250191346,
        0.10940324645910479,
        0.2187464430275592,
        0.21422440001640303,
        0.005173238723763837,
        0.005173238723763837,
        0.1331380040096474,
        0.1376600470208036,
        0.2211075814131415,
        -0.022939904672374417,
        0.1331380040096474,
        0.14904929250191346,
        0.10940324645910479,
        -0.013219746751645639,
        0.0354855353801658,
        0.14904929250191346,
        0.14793144821410487,
        0.17080387633499253,
        -0.038132893882664866,
        0.17730609306361222,
        0.006640351443728543,
        0.20257938128471242,
        0.1331380040096474,
        0.07389199310552778,
        0.034070414558183104,
        -0.06334279001654182,
        -0.013219746751645639,
        0.10940324645910479,
        0.1376600470208036,
        -0.013219746751645639,
        0.10940324645910479,
        0.1079881256371221,
        0.17730609306361222,
        0.005173238723763837,
        0.1331380040096474,
        0.18218724567821637,
        -0.06334279001654182,
        0.07879822736035008,
        0.1331380040096474,
        -0.022939904672374417,
        0.08562548556465976,
        0.1376600470208036,
        -0.022939904672374417,
        0.2211075814131415,
        0.03253755595674977,
        -0.013219746751645639,
        0.011990149382231315,
        -0.013219746751645639,
        0.17730609306361222,
        0.034070414558183104,
        0.05358833122647312,
        0.10940324645910479,
        0.05358833122647312,
        0.10175526548930205,
        -0.013219746751645639,
        -0.013219746751645639,
        0.1331380040096474,
        0.1875774942569135,
        0.05676339470862472,
        0.14904929250191346,
        0.0354855353801658,
        0.10940324645910479,
        0.14904929250191346,
        0.005173238723763837,
        0.10212688053130412,
        0.06359867877630405,
        0.1331380040096474,
        0.04601768871925116,
        0.17730609306361222,
        0.1317228831876647,
        0.13818562874703627,
        0.03253755595674977,
        0.0354855353801658,
        0.13818562874703627,
        0.1875774942569135,
        0.1778316747898449,
        0.14793144821410487,
        0.11310456670476791,
        0.10940324645910479,
        0.21791657653540858,
        0.0354855353801658,
        0.06359867877630405,
        0.13379241982748868,
        -0.050508826412655874,
        0.1875774942569135,
        0.14904929250191346,
        -0.038132893882664866,
        -0.013219746751645639,
        0.17278405005245606,
        0.0765453693554251,
        0.14904929250191346,
        0.07401373713516587,
        0.10041892976911723,
        0.1331380040096474,
        -0.022939904672374417,
        0.06359867877630405,
        0.06359867877630405,
        0.17278405005245606,
        0.05882074792487542,
        0.043880069367598654,
        0.17730609306361222,
        0.17278405005245606,
        0.1376600470208036,
        0.1079881256371221,
        0.056432747078112966,
        0.03253755595674977,
        0.1331380040096474,
        0.13818562874703627,
        0.17278405005245606,
        -0.038132893882664866,
        0.08472451936308598,
        0.25160482278551577,
        0.14904929250191346,
        0.004424412560611518,
        -0.013219746751645639,
        -0.017708002343724327,
        0.03253755595674977,
        0.1079881256371221,
        0.06359867877630405,
        -0.061076632561932756,
        0.03253755595674977,
        0.03253755595674977,
        0.0765453693554251,
        -0.022939904672374417,
        -0.2602675261532481,
        0.03253755595674977,
        0.09606934606117476,
        0.14904929250191346,
        0.17278405005245606,
        0.14904929250191346,
        0.14793144821410487,
        0.0765453693554251,
        0.05358833122647312,
        0.05358833122647312,
        0.10212688053130412,
        0.10940324645910479,
        0.05882074792487542,
        0.05989623314823175,
        0.17278405005245606,
        0.0354855353801658,
        0.10212688053130412,
        -0.013219746751645639,
        0.10940324645910479,
        0.0354855353801658,
        0.005173238723763837,
        0.1079881256371221,
        -0.050508826412655874,
        0.22787006523497316,
        0.1331380040096474,
        0.10940324645910479,
        0.1331380040096474,
        0.17730609306361222,
        0.06359867877630405,
        0.1317228831876647,
        0.05080802639658133,
        -0.035978472783555884,
        0.17278405005245606,
        0.17730609306361222,
        0.04601768871925116,
        0.10940324645910479,
        0.16848324875311813,
        -0.035978472783555884,
        0.17278405005245606,
        0.1376600470208036,
        0.10858252369361174,
        0.10940324645910479,
        0.11310456670476791,
        0.17278405005245606,
        0.17278405005245606,
        0.1376600470208036,
        0.13379241982748868,
        0.0354855353801658,
        0.17730609306361222,
        0.14904929250191346,
        0.10940324645910479,
        0.13818562874703627,
        0.1778316747898449,
        0.1778316747898449,
        -0.12019509153662045,
        0.003009291738628822,
        0.1778316747898449,
        0.10940324645910479,
        0.22787006523497316,
        0.17730609306361222,
        0.1079881256371221,
        0.011990149382231315,
        0.05676339470862472,
        -0.035978472783555884,
        0.21422440001640303,
        0.08575076674743444,
        0.10940324645910479,
        0.17278405005245606,
        0.14904929250191346,
        0.10940324645910479,
        0.21422440001640303,
        0.14904929250191346,
        0.005173238723763837,
        0.18218724567821637,
        0.005173238723763837,
        0.048126779368608076,
        0.0765453693554251,
        0.034070414558183104,
        0.1331380040096474,
        0.17278405005245606,
        0.05882074792487542,
        0.06359867877630405,
        0.06359867877630405,
        0.03253755595674977,
        0.2195676684473291,
        -0.06334279001654182,
        0.17278405005245606,
        0.10858252369361174,
        0.08562548556465976,
        -0.19175149741294248,
        0.1331380040096474,
        -0.013219746751645639,
        0.17278405005245606,
        0.1079881256371221,
        0.1376600470208036,
        0.03253755595674977,
        0.1875774942569135,
        -0.06334279001654182,
        0.13379241982748868,
        0.14904929250191346,
        0.1331380040096474,
        0.1875774942569135,
        0.005173238723763837,
        0.10940324645910479,
        0.1376600470208036,
        0.14904929250191346,
        -0.06334279001654182,
        0.10175526548930205,
        -0.030800736808698534,
        0.1875774942569135,
        0.07401373713516587,
        0.003009291738628822,
        0.10940324645910479,
        0.011990149382231315,
        0.032627915630813215,
        0.07600494728036586,
        -0.013219746751645639,
        0.13831446283864487,
        0.0765453693554251,
        0.1153574247096929,
        0.14904929250191346,
        -0.013219746751645639,
        0.1079881256371221,
        0.1778316747898449,
        -0.013006872042004278,
        0.14904929250191346,
        0.07879822736035008,
        0.18218724567821637,
        -0.024559630001652635,
        0.07259861631318318,
        0.07879822736035008,
        0.13831446283864487,
        0.1362449261988209,
        0.033610851790998465,
        0.17278405005245606,
        0.10175526548930205,
        0.027837577953483045,
        0.1376600470208036,
        0.05358833122647312,
        0.17278405005245606,
        0.032327311407950296,
        0.005173238723763837,
        0.048126779368608076,
        0.10940324645910479,
        0.14904929250191346,
        0.10940324645910479,
        0.17278405005245606,
        0.10212688053130412,
        0.005173238723763837,
        0.10940324645910479,
        -0.3440379786063058,
        -0.01076857664967893,
        0.0354855353801658,
        0.1079881256371221,
        0.1331380040096474,
        0.05358833122647312,
        0.17278405005245606,
        0.14793144821410487,
        0.20514422338329186,
        0.07879822736035008,
        0.1331380040096474,
        -0.022939904672374417,
        -0.022939904672374417,
        0.09858594412312877,
        -0.012371350430121317,
        0.05393191880437666,
        0.0765453693554251,
        0.07401373713516587,
        0.034070414558183104,
        0.07401373713516587,
        0.17278405005245606,
        0.1014405943058651,
        0.10858252369361174,
        0.17730609306361222,
        0.10858252369361174,
        0.1331380040096474,
        0.10940324645910479,
        0.05358833122647312,
        0.10858252369361174,
        0.1778316747898449,
        0.14904929250191346,
        -0.013219746751645639,
        0.03253755595674977,
        0.0765453693554251,
        0.003009291738628822,
        0.003009291738628822,
        0.17278405005245606,
        0.14904929250191346,
        0.1376600470208036,
        0.005173238723763837,
        0.005173238723763837,
        0.17730609306361222,
        0.03253755595674977,
        0.011990149382231315,
        0.14904929250191346,
        0.17730609306361222,
        0.13799979165520793,
        0.005173238723763837,
        0.10214879366722657,
        -0.013219746751645639,
        0.0765453693554251,
        0.17730609306361222,
        0.1407468957142694,
        0.09014752857581594,
        0.0765453693554251,
        0.10858252369361174,
        0.1362449261988209,
        -0.06334279001654182,
        0.19335910935833955,
        0.006640351443728543,
        0.14904929250191346,
        -0.07650025968492671,
        0.07401373713516587,
        0.1362449261988209,
        0.14904929250191346,
        -0.013219746751645639,
        0.17278405005245606,
        0.0765453693554251,
        0.21422440001640303,
        0.003009291738628822,
        0.10940324645910479,
        0.05676339470862472,
        0.11310456670476791,
        0.10940324645910479,
        0.03253755595674977,
        0.06359867877630405,
        0.07879822736035008,
        0.17278405005245606,
        0.11310456670476791,
        0.17730609306361222,
        0.09238106106423553,
        0.13168701241678557,
        0.14904929250191346,
        0.11083538169853671,
        0.06359867877630405,
        0.0354855353801658,
        0.0765453693554251,
        -0.013219746751645639,
        0.05358833122647312,
        0.17278405005245606,
        0.1331380040096474,
        0.1331380040096474,
        0.10212688053130412,
        0.1079881256371221,
        0.1331380040096474,
        0.06206018013336677,
        0.10940324645910479,
        0.2187464430275592,
        0.11310456670476791,
        0.1317228831876647,
        0.14904929250191346,
        -0.013937898015852206,
        0.1376600470208036,
        0.17278405005245606,
        0.005173238723763837,
        0.011990149382231315,
        0.05080802639658133,
        0.06359867877630405,
        0.0354855353801658,
        -0.013006872042004278,
        0.12562882590299418,
        0.10940324645910479,
        -0.06334279001654182,
        0.14904929250191346,
        0.07479148673271584,
        0.06359867877630405,
        -0.06334279001654182,
        -0.024559630001652635,
        -0.04130221524883814,
        0.1331380040096474,
        0.14904929250191346,
        0.06206018013336677,
        0.06359867877630405,
        0.006640351443728543,
        0.1317228831876647,
        -0.15511752406085128,
        0.11310456670476791,
        0.17730609306361222,
        0.14904929250191346,
        0.17278405005245606,
        0.10041892976911723,
        0.14793144821410487,
        0.1014405943058651,
        -0.022939904672374417,
        -0.022939904672374417,
        0.1331380040096474,
        0.14904929250191346,
        0.1376600470208036,
        0.1014405943058651,
        0.10940324645910479,
        0.14904929250191346,
        0.0354855353801658,
        0.14904929250191346,
        0.22901784422086047,
        0.10858252369361174,
        0.10858252369361174,
        0.1331380040096474,
        0.17730609306361222,
        0.21422440001640303,
        0.17278405005245606,
        0.10858252369361174,
        0.006640351443728543,
        0.04541856801053594,
        0.14904929250191346,
        0.04601768871925116,
        0.06359867877630405,
        0.17278405005245606,
        0.17278405005245606,
        0.10940324645910479,
        0.1875774942569135,
        -0.013219746751645639,
        0.14904929250191346,
        0.06359867877630405,
        0.0354855353801658,
        0.1376600470208036,
        0.17278405005245606,
        -0.022939904672374417,
        0.1376600470208036,
        0.18218724567821637,
        0.0765453693554251,
        0.1376600470208036,
        0.17730609306361222,
        0.14904929250191346,
        0.21422440001640303,
        0.20591459220285102,
        0.07401373713516587,
        0.048126779368608076,
        0.17278405005245606,
        0.04644481539488442,
        0.06359867877630405,
        0.11242019486052784,
        0.005173238723763837,
        0.14904929250191346,
        -0.013219746751645639,
        -0.013219746751645639,
        0.10290463012885409,
        0.13831446283864487,
        0.1233759678980692,
        0.13818562874703627,
        0.10041892976911723,
        0.17278405005245606,
        0.003009291738628822,
        -0.006129521804909631,
        0.13831446283864487,
        0.07879822736035008,
        0.1376600470208036,
        0.1778316747898449,
        0.006640351443728543,
        0.2663982669899732,
        0.2211075814131415,
        0.1079881256371221,
        0.14904929250191346,
        0.0765453693554251,
        0.0354855353801658,
        0.03253755595674977,
        0.03253755595674977,
        0.14858586403194615,
        0.14904929250191346,
        0.06359867877630405,
        0.13818562874703627,
        0.10041892976911723,
        0.14904929250191346,
        0.2036771106633271,
        0.14904929250191346,
        -0.06334279001654182,
        0.14904929250191346,
        0.1079881256371221,
        0.1014405943058651,
        0.1331380040096474,
        0.10940324645910479,
        0.14904929250191346,
        0.05358833122647312,
        0.1376600470208036,
        0.07401373713516587,
        0.034070414558183104,
        0.11310456670476791,
        0.06426791766809728,
        0.14904929250191346,
        -0.035978472783555884,
        0.17730609306361222,
        0.1376600470208036,
        0.05529628198866002,
        0.14793144821410487,
        0.1376600470208036,
        0.09238106106423553,
        0.1376600470208036,
        0.1875774942569135,
        0.048126779368608076,
        0.17730609306361222,
        0.13379241982748868,
        0.14904929250191346,
        0.13347774864405176,
        0.0354855353801658,
        0.22787006523497316,
        0.1875774942569135,
        0.17730609306361222,
        0.17730609306361222,
        -0.035978472783555884,
        0.0354855353801658,
        0.09014752857581594,
        0.1079881256371221,
        -0.013219746751645639,
        -0.013006872042004278,
        0.10940324645910479,
        0.10940324645910479,
        0.09014752857581594,
        0.1778316747898449,
        0.1079881256371221,
        0.06359867877630405,
        0.17278405005245606,
        0.17278405005245606,
        0.1875774942569135,
        0.10175526548930205,
        0.17730609306361222,
        0.14904929250191346,
        0.10940324645910479,
        0.10940324645910479,
        0.1317228831876647,
        0.14904929250191346,
        0.14651632739212217,
        0.05358833122647312,
        0.1317228831876647,
        0.06359867877630405,
        0.17278405005245606,
        0.08454589047425123,
        0.1079881256371221,
        0.1331380040096474,
        0.13831446283864487,
        0.10175526548930205,
        0.14904929250191346,
        0.10858252369361174,
        0.10940324645910479,
        0.03253755595674977,
        0.1875774942569135,
        0.1778316747898449,
        0.007916613639884343,
        0.17278405005245606,
        0.11310456670476791,
        -0.2602675261532481,
        0.1331380040096474,
        0.17278405005245606,
        -0.022939904672374417,
        0.1778316747898449,
        -0.06334279001654182,
        -0.04130221524883814,
        0.17278405005245606,
        0.14904929250191346,
        0.10858252369361174,
        -0.022939904672374417,
        0.1376600470208036,
        0.05676339470862472,
        0.005173238723763837,
        0.17278405005245606,
        -0.022939904672374417,
        0.0354855353801658,
        0.0765453693554251,
        0.18218724567821637,
        -0.035978472783555884,
        0.14651632739212217,
        0.0354855353801658,
        0.03253755595674977,
        0.09858594412312877,
        -0.00559084067482158,
        0.14904929250191346,
        0.10940324645910479,
        -0.022939904672374417,
        0.3151123305591088,
        0.1376600470208036,
        0.03253755595674977,
        0.11083538169853671,
        -0.25194942183875346,
        0.05676339470862472,
        0.005173238723763837,
        0.14904929250191346,
        0.1079881256371221,
        0.005173238723763837,
        0.17278405005245606,
        0.03771529193160712,
        0.17730609306361222,
        0.005173238723763837,
        0.0765453693554251,
        0.17730609306361222,
        0.10940324645910479,
        -0.013219746751645639,
        0.17278405005245606,
        0.12562882590299418,
        0.034070414558183104,
        0.22787006523497316,
        -0.013219746751645639,
        0.1233759678980692,
        0.17730609306361222,
        0.17730609306361222,
        0.10940324645910479,
        0.004424412560611518,
        0.1014405943058651,
        0.17278405005245606,
        0.21422440001640303,
        -0.013219746751645639,
        0.1875774942569135,
        0.14904929250191346,
        0.14904929250191346,
        0.011990149382231315,
        0.003009291738628822,
        -0.024559630001652635,
        0.18218724567821637,
        0.07879822736035008,
        0.22787006523497316,
        0.14904929250191346,
        0.17278405005245606,
        0.13379241982748868,
        0.17730609306361222,
        0.1376600470208036,
        0.03253755595674977,
        -0.035978472783555884,
        0.011990149382231315,
        0.14904929250191346,
        -0.035978472783555884,
        0.06359867877630405,
        0.1014405943058651,
        0.1376600470208036,
        0.17278405005245606,
        0.006640351443728543,
        -0.06334279001654182,
        0.10858252369361174,
        0.005173238723763837,
        0.083946769765536,
        0.11083538169853671,
        0.14904929250191346,
        0.13379241982748868,
        0.005173238723763837,
        0.005173238723763837,
        -0.022939904672374417,
        0.1317228831876647,
        0.005173238723763837,
        -0.013219746751645639,
        0.0354855353801658,
        0.1376600470208036,
        0.17278405005245606,
        0.17278405005245606,
        0.11242019486052784,
        0.10940324645910479,
        0.14651632739212217,
        -0.022939904672374417,
        0.10940324645910479,
        0.06359867877630405,
        -0.2602675261532481,
        -0.035978472783555884,
        0.17730609306361222,
        0.022694883000443075,
        0.17278405005245606,
        0.1317228831876647,
        0.034070414558183104,
        0.005173238723763837,
        0.1778316747898449,
        0.1331380040096474,
        0.09089161008631741,
        0.09762675065607039,
        -0.013219746751645639,
        0.21422440001640303,
        0.1317228831876647,
        0.13818562874703627,
        0.17278405005245606,
        0.01602986173394557,
        -0.01076857664967893,
        0.14904929250191346,
        -0.06334279001654182,
        0.14904929250191346,
        0.017904545323112905,
        -0.13046649272992172,
        0.1376600470208036,
        0.2187464430275592,
        0.06359867877630405,
        0.04601768871925116,
        0.14904929250191346,
        0.17278405005245606,
        -0.022939904672374417,
        0.05358833122647312,
        0.14904929250191346,
        0.033947036737228514,
        0.07879822736035008,
        0.10940324645910479,
        0.1317228831876647,
        0.17278405005245606,
        0.1317228831876647,
        0.011990149382231315,
        0.17278405005245606,
        0.1014405943058651,
        0.14904929250191346,
        0.18218724567821637,
        0.1778316747898449,
        0.21422440001640303,
        0.004424412560611518,
        0.1331380040096474,
        -0.038132893882664866,
        0.1331380040096474,
        0.1376600470208036,
        0.13831446283864487,
        0.22787006523497316,
        0.0765453693554251,
        0.2187464430275592,
        0.03253755595674977,
        0.05970823227417366,
        0.21422440001640303,
        0.21422440001640303,
        0.21422440001640303,
        -0.08677166087822799,
        0.0354855353801658,
        -0.013219746751645639,
        0.08562548556465976,
        0.1317228831876647,
        0.05358833122647312,
        0.07389199310552778,
        0.17278405005245606,
        0.015799316607293966,
        0.17730609306361222,
        0.14904929250191346,
        0.0354855353801658,
        0.1376600470208036,
        0.1331380040096474,
        0.005173238723763837,
        0.10940324645910479,
        0.005173238723763837,
        0.1875774942569135,
        0.005173238723763837,
        0.10940324645910479,
        0.2187464430275592,
        0.14904929250191346,
        0.10175526548930205,
        0.13818562874703627,
        0.07879822736035008,
        0.21422440001640303,
        0.08454589047425123,
        0.14904929250191346,
        0.033610851790998465,
        0.21422440001640303,
        0.1875774942569135,
        0.03253755595674977,
        0.14904929250191346,
        0.11242019486052784,
        0.14904929250191346,
        0.14904929250191346,
        -0.022939904672374417,
        0.005173238723763837,
        0.14904929250191346,
        0.14904929250191346,
        0.13818562874703627,
        0.17730609306361222,
        0.18218724567821637,
        0.17730609306361222,
        0.18218724567821637,
        0.07401373713516587,
        0.17278405005245606,
        0.011990149382231315,
        -0.25194942183875346,
        0.1331380040096474,
        -0.022939904672374417,
        0.017849646270254482,
        0.033610851790998465,
        0.14904929250191346,
        0.10858252369361174,
        0.13818562874703627,
        0.22901784422086047,
        0.011990149382231315,
        -0.022939904672374417,
        0.03253755595674977,
        0.17730609306361222,
        0.08059573376330165,
        0.10212688053130412,
        0.17278405005245606,
        0.1331380040096474,
        0.2187464430275592,
        -0.06334279001654182,
        0.07879822736035008,
        0.0765453693554251,
        0.17278405005245606,
        0.1331380040096474,
        0.003009291738628822,
        0.005173238723763837,
        -0.013219746751645639,
        0.1079881256371221,
        0.09014752857581594,
        0.11310456670476791,
        0.14904929250191346,
        0.14904929250191346,
        0.18218724567821637,
        0.19589879366722657,
        0.014357445190981658,
        0.17278405005245606,
        0.1331380040096474,
        0.1875774942569135,
        0.17278405005245606,
        0.06359867877630405,
        -0.035978472783555884,
        0.1875774942569135,
        0.14904929250191346,
        0.1407468957142694,
        0.08562548556465976,
        0.1331380040096474,
        0.07401373713516587,
        0.14904929250191346,
        0.17730609306361222,
        0.14904929250191346,
        0.09014752857581594,
        0.0354855353801658,
        0.1317228831876647,
        0.033610851790998465,
        0.09606934606117476,
        0.10940324645910479,
        0.17278405005245606,
        0.01558472616076479,
        0.05358833122647312,
        0.0765453693554251,
        0.05080802639658133,
        -0.013219746751645639,
        0.10041892976911723,
        0.11100507403854515,
        0.03253755595674977,
        -0.035978472783555884,
        0.06359867877630405,
        0.14904929250191346,
        0.1331380040096474,
        0.0354855353801658,
        0.17730609306361222,
        0.08562548556465976,
        0.14289994460381888,
        0.14904929250191346,
        0.18218724567821637,
        0.1119045676657332,
        0.10212688053130412,
        0.0765453693554251,
        0.06426791766809728,
        0.14904929250191346,
        0.14904929250191346,
        -0.1165893223058512,
        0.14904929250191346,
        0.17278405005245606,
        0.10940324645910479,
        0.17278405005245606,
        0.10858252369361174,
        0.17278405005245606,
        0.1317228831876647,
        -0.035978472783555884,
        0.21422440001640303,
        0.10940324645910479,
        0.04502969457290172,
        0.06359867877630405,
        0.18070469606897407,
        0.14904929250191346,
        0.17730609306361222,
        0.10940324645910479,
        0.17278405005245606,
        0.10940324645910479,
        0.01648942450113021,
        0.2187464430275592,
        0.0765453693554251,
        -0.32030322105576325,
        0.21422440001640303,
        0.04601768871925116,
        0.1331380040096474,
        0.14793144821410487,
        -0.022939904672374417,
        0.10940324645910479,
        0.17278405005245606,
        0.1778316747898449,
        0.003009291738628822,
        0.06426791766809728,
        0.05358833122647312,
        0.09238106106423553,
        0.11310456670476791,
        0.3075747789388474,
        0.10940324645910479,
        0.2036771106633271,
        0.1875774942569135,
        0.1079881256371221,
        -0.022939904672374417,
        0.14904929250191346,
        0.1079881256371221,
        0.06359867877630405,
        0.011990149382231315,
        0.17278405005245606,
        0.04541856801053594,
        0.1317228831876647,
        0.058453961815532834,
        0.10940324645910479,
        0.09606934606117476,
        -0.038132893882664866,
        0.10940324645910479,
        0.0354855353801658,
        0.1778316747898449,
        0.10940324645910479,
        0.07879822736035008,
        0.1479950455269074,
        0.14904929250191346,
        0.17730609306361222,
        0.06359867877630405,
        0.10940324645910479,
        0.1331380040096474,
        0.1376600470208036,
        0.1362449261988209,
        0.10940324645910479,
        0.14904929250191346,
        0.005173238723763837,
        0.09606934606117476,
        0.07389199310552778,
        0.14904929250191346,
        0.13818562874703627,
        0.1331380040096474,
        0.011990149382231315,
        -0.050508826412655874,
        0.17730609306361222,
        0.17278405005245606,
        0.10175526548930205,
        0.17278405005245606,
        0.005173238723763837,
        0.07479148673271584,
        -0.013219746751645639,
        0.06359867877630405,
        0.17278405005245606,
        0.2187464430275592,
        0.003009291738628822,
        0.1331380040096474,
        0.0354855353801658,
        0.00882082801605804,
        -0.013219746751645639,
        0.1079881256371221,
        0.1331380040096474,
        0.09238106106423553,
        0.003009291738628822,
        0.14904929250191346,
        0.005173238723763837,
        0.09606934606117476,
        0.1014405943058651,
        0.0765453693554251,
        0.0354855353801658,
        0.10858252369361174,
        0.18218724567821637,
        0.1376600470208036,
        0.12165690062809299,
        0.10359399325126883,
        0.10940324645910479,
        0.17278405005245606,
        0.17730609306361222,
        0.17730609306361222,
        0.1778316747898449,
        0.05358833122647312,
        0.17730609306361222,
        0.20399450210669512,
        0.2036771106633271,
        0.14904929250191346,
        0.24922072480927973,
        0.13818562874703627,
        0.08562548556465976,
        -0.038132893882664866,
        0.10175526548930205,
        0.13831446283864487,
        0.17730609306361222,
        0.14904929250191346,
        0.03253755595674977,
        0.17278405005245606,
        0.07879822736035008,
        0.14904929250191346,
        -0.013219746751645639,
        0.17730609306361222,
        0.034070414558183104,
        0.3009629589048142,
        0.14793144821410487,
        0.09460223334121005,
        0.07389199310552778,
        0.14793144821410487,
        -0.035978472783555884,
        0.14904929250191346,
        0.005173238723763837,
        0.25612686579667193,
        0.14904929250191346,
        0.14827119284850923,
        0.0354855353801658,
        0.14793144821410487,
        0.1233759678980692,
        0.14904929250191346,
        0.10212688053130412,
        0.03253755595674977,
        0.11310456670476791,
        0.033610851790998465,
        0.10940324645910479,
        0.07337636591073314,
        0.13818562874703627,
        0.10940324645910479,
        0.14904929250191346,
        0.14793144821410487,
        0.17278405005245606,
        0.18218724567821637,
        0.1362449261988209,
        0.06359867877630405,
        -0.013219746751645639,
        0.17730609306361222,
        0.03400466867671448,
        0.1331380040096474,
        0.005173238723763837,
        -0.022939904672374417,
        0.10858252369361174,
        0.1331380040096474,
        0.13168701241678557,
        0.09238106106423553,
        0.12562882590299418,
        0.0354855353801658,
        0.10940324645910479,
        0.12562882590299418,
        0.17278405005245606,
        0.1376600470208036,
        0.17730609306361222,
        0.08472451936308598,
        0.048126779368608076,
        0.17278405005245606,
        0.05080802639658133,
        0.1331380040096474,
        0.14904929250191346,
        0.1331380040096474,
        0.1778316747898449,
        0.17556396726718887,
        0.1875774942569135,
        0.11083538169853671,
        0.0765453693554251,
        0.1079881256371221,
        0.10940324645910479,
        0.14858586403194615,
        -0.11502846143992677,
        0.11310456670476791,
        0.0765453693554251,
        0.17278405005245606,
        0.015741792966016938,
        0.1331380040096474,
        0.10940324645910479,
        0.11310456670476791,
        -0.014246034019288652,
        0.17730609306361222,
        0.09238106106423553,
        0.14793144821410487,
        0.10940324645910479,
        0.007916613639884343,
        0.10858252369361174,
        -0.038132893882664866,
        0.08562548556465976,
        0.1778316747898449,
        0.14904929250191346,
        0.1376600470208036,
        0.10940324645910479,
        0.05358833122647312,
        0.05676339470862472,
        0.05358833122647312,
        0.11310456670476791,
        0.14904929250191346,
        0.005173238723763837,
        0.1376600470208036,
        0.14904929250191346,
        0.003009291738628822,
        0.0765453693554251,
        -0.022939904672374417,
        0.14904929250191346,
        0.10940324645910479,
        -0.1587232932916205,
        0.005173238723763837,
        -0.022939904672374417,
        0.10858252369361174,
        0.14904929250191346,
        0.003009291738628822,
        0.17278405005245606,
        0.1875774942569135,
        0.17278405005245606,
        -0.06334279001654182,
        0.03253755595674977,
        0.17730609306361222,
        0.10940324645910479,
        0.1376600470208036,
        0.06359867877630405,
        0.005173238723763837,
        0.17730609306361222,
        0.10940324645910479,
        0.1317228831876647,
        0.17730609306361222,
        0.1875774942569135,
        0.13677050792505357,
        0.0765453693554251,
        -0.022939904672374417,
        0.07401373713516587,
        0.20514422338329186,
        0.14904929250191346,
        0.14904929250191346,
        0.17278405005245606,
        0.10940324645910479,
        0.005173238723763837,
        0.1331380040096474,
        0.0894244973663527,
        -0.022939904672374417,
        0.14904929250191346,
        0.14904929250191346,
        0.07879822736035008,
        0.0354855353801658,
        0.13831446283864487,
        0.10940324645910479,
        0.0354855353801658,
        0.14904929250191346,
        0.1376600470208036,
        0.1875774942569135,
        0.1376600470208036,
        0.005173238723763837,
        0.17730609306361222,
        0.0765453693554251,
        0.08562548556465976,
        0.0354855353801658,
        -0.06334279001654182,
        0.10175526548930205,
        0.10175526548930205,
        0.13379241982748868,
        0.1331380040096474,
        0.17730609306361222,
        0.005173238723763837,
        0.05080802639658133,
        0.10940324645910479,
        0.1331380040096474,
        0.07259861631318318,
        0.13818562874703627,
        0.1317228831876647,
        0.0354855353801658,
        0.03253755595674977,
        0.0354855353801658,
        0.05358833122647312,
        0.04601768871925116,
        0.13831446283864487,
        0.17278405005245606,
        0.03253755595674977,
        0.17730609306361222,
        0.10041892976911723,
        0.14904929250191346,
        0.1778316747898449,
        0.056432747078112966,
        0.13677050792505357,
        0.14793144821410487,
        0.14904929250191346,
        0.1778316747898449,
        0.1778316747898449,
        0.2036771106633271,
        0.10940324645910479,
        0.14904929250191346,
        0.17730609306361222,
        0.05358833122647312,
        0.1331380040096474,
        0.06359867877630405,
        0.08562548556465976,
        -0.050508826412655874,
        0.17278405005245606,
        0.1079881256371221,
        0.1362449261988209,
        -0.013219746751645639,
        0.1662268722835451,
        0.1875774942569135,
        0.16283127324947677,
        0.14904929250191346,
        0.10858252369361174,
        0.14759307965117371,
        0.005173238723763837,
        0.17730609306361222,
        0.0894244973663527,
        0.10940324645910479,
        0.1875774942569135,
        0.1153574247096929,
        0.10175526548930205,
        0.10940324645910479,
        -0.013219746751645639,
        0.10858252369361174,
        0.03253755595674977,
        0.05358833122647312,
        0.05358833122647312,
        0.17278405005245606,
        0.16848324875311813,
        -0.01076857664967893,
        -0.022939904672374417,
        0.2195676684473291,
        0.13831446283864487,
        0.10940324645910479,
        0.04601768871925116,
        0.0354855353801658,
        0.17278405005245606,
        0.2187464430275592,
        0.06359867877630405,
        0.06359867877630405,
        0.17278405005245606,
        -0.013219746751645639,
        0.06206018013336677,
        0.011990149382231315,
        0.1331380040096474,
        0.17278405005245606,
        0.10940324645910479,
        0.0765453693554251,
        0.06285279684611458,
        0.1331380040096474,
        -0.01076857664967893,
        0.1331380040096474,
        0.17730609306361222,
        -0.013219746751645639,
        0.30610766621888263,
        0.1362449261988209,
        0.07401373713516587,
        0.14904929250191346,
        0.14904929250191346,
        0.17278405005245606,
        0.1331380040096474,
        0.1331380040096474,
        0.13379241982748868,
        0.1331380040096474,
        0.08059573376330165,
        0.005173238723763837,
        0.1317228831876647,
        -0.06334279001654182,
        0.1376600470208036,
        0.03253755595674977,
        0.06359867877630405,
        0.13347774864405176,
        0.006640351443728543,
        0.17278405005245606,
        0.10175526548930205,
        0.00882082801605804,
        0.1317228831876647,
        0.1331380040096474,
        0.007916613639884343,
        0.17278405005245606,
        0.10940324645910479,
        0.04541856801053594,
        0.1778316747898449,
        0.1875774942569135,
        0.17730609306361222,
        0.1331380040096474,
        0.14904929250191346,
        0.003009291738628822,
        0.21422440001640303,
        0.1778316747898449,
        -0.035978472783555884,
        0.18218724567821637,
        0.1376600470208036,
        -0.06334279001654182,
        0.1331380040096474,
        0.2195676684473291,
        -0.01076857664967893,
        0.05358833122647312,
        0.1331380040096474,
        0.17730609306361222,
        -0.06334279001654182,
        0.17278405005245606,
        0.05676339470862472,
        0.09014752857581594,
        0.13831446283864487,
        0.2036771106633271,
        0.005173238723763837,
        0.1875774942569135,
        -0.013219746751645639,
        0.034070414558183104,
        0.13818562874703627,
        0.14904929250191346,
        0.08562548556465976,
        -0.022939904672374417,
        0.005173238723763837,
        0.1331380040096474,
        -0.022939904672374417,
        0.03253755595674977,
        0.0894244973663527,
        0.0765453693554251,
        0.1778316747898449,
        0.12165690062809299,
        0.11310456670476791,
        0.13347774864405176,
        0.1233759678980692,
        0.05358833122647312,
        0.1079881256371221,
        0.10940324645910479,
        -0.013219746751645639,
        0.21422440001640303,
        -0.1268607234991525,
        0.1331380040096474,
        0.17730609306361222,
        0.14904929250191346,
        0.14904929250191346,
        0.14904929250191346,
        0.22772925965723773,
        0.17278405005245606,
        0.25612686579667193,
        0.06359867877630405,
        0.14904929250191346,
        0.003009291738628822,
        0.0765453693554251,
        -0.06334279001654182,
        -0.12994091100368904,
        0.09238106106423553,
        0.14904929250191346,
        0.18218724567821637,
        0.14904929250191346,
        0.011990149382231315,
        0.13379241982748868,
        0.14904929250191346,
        0.14827119284850923,
        0.0354855353801658,
        0.17730609306361222,
        0.1079881256371221,
        0.06359867877630405,
        0.14904929250191346,
        0.06359867877630405,
        0.10940324645910479,
        0.005173238723763837,
        0.14904929250191346,
        -0.013219746751645639,
        -0.022939904672374417,
        0.17278405005245606,
        -0.21110497184326615,
        0.17278405005245606,
        0.005173238723763837,
        0.10212688053130412,
        0.2211075814131415,
        0.10940324645910479,
        0.11083538169853671,
        0.1407468957142694,
        0.08562548556465976,
        0.17730609306361222,
        0.14904929250191346,
        0.3136972097371261,
        -0.06334279001654182,
        0.17278405005245606,
        0.1331380040096474,
        -0.022939904672374417,
        0.1014405943058651,
        0.08201085458528434,
        0.14904929250191346,
        0.09460223334121005,
        0.10940324645910479,
        0.0354855353801658,
        -0.022939904672374417,
        0.17278405005245606,
        0.10940324645910479,
        0.14904929250191346,
        0.10940324645910479,
        0.1778316747898449,
        0.0354855353801658,
        0.22787006523497316,
        -0.22127976163106342,
        0.1331380040096474,
        0.09606934606117476,
        0.14904929250191346,
        0.14904929250191346,
        0.17278405005245606,
        0.13818562874703627,
        0.14904929250191346,
        -0.022939904672374417,
        -0.022939904672374417,
        0.3529712934223157,
        0.10212688053130412,
        0.14904929250191346,
        0.17278405005245606,
        0.17278405005245606,
        0.22901784422086047,
        0.1376600470208036,
        0.034070414558183104,
        0.09606934606117476,
        0.14793144821410487,
        0.011990149382231315,
        -0.022939904672374417,
        0.06426791766809728,
        0.14904929250191346,
        0.17278405005245606,
        0.10858252369361174,
        0.011990149382231315,
        0.09238106106423553,
        0.17730609306361222,
        0.10940324645910479,
        -0.035978472783555884,
        -0.012371350430121317,
        0.13831446283864487,
        0.06359867877630405,
        0.09762675065607039,
        -0.12994091100368904,
        0.14827119284850923,
        0.09014752857581594,
        0.1331380040096474,
        0.1079881256371221,
        0.0354855353801658,
        -0.06334279001654182,
        0.17730609306361222,
        0.09238106106423553,
        0.14904929250191346,
        0.1875774942569135,
        -0.022939904672374417,
        0.14904929250191346,
        0.12165690062809299,
        0.06359867877630405,
        -0.04130221524883814,
        0.22787006523497316,
        0.17730609306361222,
        -0.013219746751645639,
        0.14904929250191346,
        0.14904929250191346,
        -0.022939904672374417,
        0.005173238723763837,
        0.05358833122647312,
        0.17556396726718887,
        0.05989623314823175,
        0.14904929250191346,
        0.17730609306361222,
        0.04541856801053594,
        0.0354855353801658,
        0.14904929250191346,
        0.07389199310552778,
        0.11310456670476791,
        0.14904929250191346,
        0.07879822736035008,
        -0.013219746751645639,
        0.05358833122647312,
        0.14904929250191346,
        0.17278405005245606,
        0.17278405005245606,
        0.18218724567821637,
        0.007916613639884343,
        0.07879822736035008,
        0.1875774942569135,
        0.005173238723763837,
        0.14793144821410487,
        0.10940324645910479,
        0.09606934606117476,
        0.03253755595674977,
        0.17278405005245606,
        0.17730609306361222,
        0.2187464430275592,
        0.1079881256371221,
        0.003009291738628822,
        0.03253755595674977,
        0.1362449261988209,
        -0.022939904672374417,
        0.006501492817901647,
        0.1331380040096474,
        0.05676339470862472,
        0.07479148673271584,
        0.10858252369361174,
        0.005173238723763837,
        0.007916613639884343,
        0.1376600470208036,
        0.0354855353801658,
        0.11310456670476791,
        0.13818562874703627,
        0.14904929250191346,
        -0.013219746751645639,
        0.13677050792505357,
        0.17278405005245606,
        0.06359867877630405,
        0.011990149382231315,
        0.10858252369361174,
        0.17278405005245606,
        -0.19175149741294248,
        0.1079881256371221,
        0.17730609306361222,
        0.1317228831876647,
        0.07389199310552778,
        0.09014752857581594,
        0.13799979165520793,
        0.06359867877630405,
        0.17278405005245606,
        0.1875774942569135,
        0.1875774942569135,
        0.05529628198866002,
        -0.013219746751645639,
        0.14793144821410487,
        0.13831446283864487,
        0.06426791766809728,
        0.10214879366722657,
        0.10858252369361174,
        0.1376600470208036,
        0.14904929250191346,
        -0.022939904672374417,
        0.0354855353801658,
        0.14904929250191346,
        -0.024559630001652635,
        0.13818562874703627,
        0.0354855353801658,
        0.17730609306361222,
        0.10916208052614897,
        0.10175526548930205,
        0.0765453693554251,
        0.0354855353801658,
        0.034070414558183104,
        0.08201085458528434,
        0.17278405005245606,
        -0.013219746751645639,
        0.1317228831876647,
        0.03253755595674977,
        0.14793144821410487,
        0.05358833122647312,
        0.10940324645910479,
        0.1376600470208036,
        0.06359867877630405,
        0.1778316747898449,
        0.1331380040096474,
        0.1875774942569135,
        0.1317228831876647,
        0.17730609306361222,
        0.0765453693554251,
        0.06359867877630405,
        0.0354855353801658,
        -0.013219746751645639,
        0.17278405005245606,
        0.1317228831876647,
        0.10290463012885409,
        0.21422440001640303,
        0.06426791766809728,
        0.1778316747898449,
        0.1407468957142694,
        0.17278405005245606,
        0.007916613639884343,
        0.1875774942569135,
        0.13818562874703627,
        0.17278405005245606,
        0.0354855353801658,
        0.05882074792487542,
        0.11310456670476791,
        0.1376600470208036,
        -0.06334279001654182,
        0.1875774942569135,
        0.06359867877630405,
        0.1778316747898449,
        0.03253755595674977,
        0.13818562874703627,
        -0.013219746751645639,
        0.1079881256371221,
        0.005173238723763837,
        0.07420095029846742,
        0.10940324645910479,
        -0.013219746751645639,
        0.10940324645910479,
        0.14904929250191346,
        -0.050508826412655874,
        0.1875774942569135,
        0.005173238723763837,
        0.14904929250191346,
        0.13379241982748868,
        0.10940324645910479,
        0.11310456670476791,
        0.10940324645910479,
        0.10290463012885409,
        0.1079881256371221,
        0.1331380040096474,
        0.07259861631318318,
        0.03253755595674977,
        0.09014752857581594,
        0.14904929250191346,
        0.14858586403194615,
        0.14651632739212217,
        -0.25194942183875346,
        0.03253755595674977,
        0.1331380040096474,
        0.034070414558183104,
        0.05080802639658133,
        0.14793144821410487,
        0.083946769765536,
        0.034070414558183104,
        0.10212688053130412,
        0.08562548556465976,
        0.06359867877630405,
        0.14904929250191346,
        0.06359867877630405,
        0.10940324645910479,
        0.14652851081569546,
        0.14904929250191346,
        0.09606934606117476,
        0.17730609306361222,
        0.06359867877630405,
        0.033610851790998465,
        0.14793144821410487,
        0.10940324645910479,
        0.14858586403194615,
        0.0765453693554251,
        0.10175526548930205,
        0.14793144821410487,
        0.011990149382231315,
        0.08562548556465976,
        0.17278405005245606,
        0.14651632739212217,
        -0.022939904672374417,
        0.1307941189112901,
        0.18218724567821637,
        0.06359867877630405,
        0.1233759678980692,
        0.1362449261988209,
        0.1079881256371221,
        0.14904929250191346,
        0.1331380040096474,
        0.18218724567821637,
        0.10940324645910479,
        0.10175526548930205,
        -0.13046649272992172,
        -0.013219746751645639,
        0.14904929250191346,
        0.1875774942569135,
        0.1362449261988209,
        0.09014752857581594,
        0.17730609306361222,
        0.1014405943058651,
        0.08562548556465976,
        0.17278405005245606,
        0.0354855353801658,
        0.2187464430275592,
        0.05529628198866002,
        0.2187464430275592,
        0.21422440001640303,
        0.1875774942569135,
        0.005173238723763837,
        0.10858252369361174,
        0.05358833122647312,
        0.14904929250191346,
        0.0354855353801658,
        0.1014405943058651,
        0.14904929250191346,
        -0.022939904672374417,
        -0.013219746751645639,
        0.17730609306361222,
        0.10940324645910479,
        0.1317228831876647,
        0.17730609306361222,
        -0.06334279001654182,
        0.1331380040096474,
        0.003009291738628822,
        0.06359867877630405,
        0.22772925965723773,
        0.10858252369361174,
        0.10940324645910479,
        0.17730609306361222,
        0.00882082801605804,
        0.17080387633499253,
        0.03253755595674977,
        0.1376600470208036,
        -0.022939904672374417,
        0.17730609306361222,
        0.1331380040096474,
        0.03253755595674977,
        0.1407468957142694,
        0.1317228831876647,
        0.0765453693554251,
        0.13379241982748868,
        0.10940324645910479,
        0.14904929250191346,
        0.0354855353801658,
        0.1233759678980692,
        0.18218724567821637,
        0.14904929250191346,
        0.14904929250191346,
        0.14904929250191346,
        -0.06334279001654182,
        0.14793144821410487,
        0.1014405943058651,
        0.1376600470208036,
        0.14793144821410487,
        0.13831446283864487,
        0.14904929250191346,
        0.07479148673271584,
        0.21422440001640303,
        0.10175526548930205,
        0.1778316747898449,
        0.10940324645910479,
        0.1079881256371221,
        0.09606934606117476,
        0.13799979165520793,
        0.1778316747898449,
        -0.022939904672374417,
        0.07879822736035008,
        0.09238106106423553,
        -0.013219746751645639,
        0.13379241982748868,
        0.10940324645910479,
        0.005173238723763837,
        0.1331380040096474,
        0.07401373713516587,
        0.08562548556465976,
        0.05358833122647312,
        0.17278405005245606,
        -0.022939904672374417,
        0.04541856801053594,
        0.17730609306361222,
        0.0765453693554251,
        0.03253755595674977,
        0.1331380040096474,
        0.005173238723763837,
        0.05358833122647312,
        0.004424412560611518,
        0.03253755595674977,
        0.011990149382231315,
        0.12562882590299418,
        0.14904929250191346,
        0.08562548556465976,
        0.06359867877630405,
        0.07259861631318318,
        0.1014405943058651,
        0.1875774942569135,
        0.07879822736035008,
        0.08562548556465976,
        0.10940324645910479,
        0.1778316747898449,
        0.14793144821410487,
        0.1331380040096474,
        0.10940324645910479,
        0.14827119284850923,
        0.10357386902064732,
        0.17730609306361222,
        0.1875774942569135,
        0.10940324645910479,
        0.06359867877630405,
        0.17278405005245606,
        0.17278405005245606,
        0.05358833122647312,
        0.08454589047425123,
        0.1331380040096474,
        0.10940324645910479,
        0.03253755595674977,
        0.1014405943058651,
        0.22772925965723773,
        -0.017708002343724327,
        0.13347774864405176,
        -0.06334279001654182,
        0.005173238723763837,
        0.18218724567821637,
        0.13379241982748868,
        0.14904929250191346,
        0.09014752857581594,
        0.03449833614029671,
        -0.022939904672374417,
        -0.035978472783555884,
        0.20257938128471242,
        0.00882082801605804,
        0.1376600470208036,
        0.1778316747898449,
        0.03253755595674977,
        0.10940324645910479,
        0.17730609306361222,
        0.10212688053130412,
        0.1079881256371221,
        0.00882082801605804,
        0.04601768871925116,
        0.0765453693554251,
        0.17278405005245606,
        0.2187464430275592,
        -0.022939904672374417,
        0.06359867877630405,
        0.05358833122647312,
        0.004424412560611518,
        -0.022939904672374417,
        0.25068783752924445,
        -0.022939904672374417,
        0.14651632739212217,
        -0.022939904672374417,
        0.17730609306361222,
        0.17730609306361222,
        0.10175526548930205,
        0.1376600470208036,
        -0.06334279001654182,
        -0.013219746751645639,
        0.0354855353801658,
        0.1331380040096474,
        0.17730609306361222,
        0.07401373713516587,
        0.08201085458528434,
        0.17730609306361222,
        0.1407468957142694,
        0.0765453693554251,
        -0.013219746751645639,
        0.1362449261988209,
        0.17278405005245606,
        0.17278405005245606,
        0.14793144821410487,
        0.1778316747898449,
        0.1153574247096929,
        0.1331380040096474,
        0.1317228831876647,
        0.10940324645910479,
        0.003009291738628822,
        0.17730609306361222,
        0.18218724567821637,
        0.21422440001640303,
        0.22901784422086047,
        0.2187464430275592,
        0.18218724567821637,
        0.10940324645910479,
        0.005173238723763837,
        0.17278405005245606,
        0.14904929250191346,
        0.011990149382231315,
        0.10940324645910479,
        0.10940324645910479,
        0.2187464430275592,
        0.07879822736035008,
        0.0354855353801658,
        0.0354855353801658,
        0.25612686579667193,
        -0.1349885357410779,
        0.17730609306361222,
        0.1233759678980692,
        0.1875774942569135,
        0.1376600470208036,
        0.18218724567821637,
        0.003009291738628822,
        0.08562548556465976,
        0.10940324645910479,
        0.1331380040096474,
        0.1875774942569135,
        0.14827119284850923,
        -0.1587232932916205,
        0.14904929250191346,
        0.03400466867671448,
        0.03253755595674977,
        0.0765453693554251,
        0.1331380040096474,
        0.18218724567821637,
        0.1376600470208036,
        0.14793144821410487,
        0.034070414558183104,
        0.1331380040096474,
        0.06359867877630405,
        -0.06334279001654182,
        -0.030800736808698534,
        0.14904929250191346,
        0.10212688053130412,
        0.1875774942569135,
        0.14904929250191346,
        0.21422440001640303,
        0.0354855353801658,
        0.14904929250191346,
        0.03253755595674977,
        0.1376600470208036,
        0.14904929250191346,
        0.1913767506560704,
        0.13347774864405176,
        0.06636577970848312,
        0.07247687228354509,
        0.17278405005245606,
        0.2187464430275592,
        0.14904929250191346,
        0.14793144821410487,
        0.14793144821410487,
        0.14904929250191346,
        0.1331380040096474,
        0.13818562874703627,
        0.14904929250191346,
        0.05080802639658133,
        0.14858586403194615,
        -0.013219746751645639,
        0.11310456670476791,
        0.13379241982748868,
        0.07879822736035008,
        0.06359867877630405,
        0.06206018013336677,
        0.17730609306361222,
        0.09606934606117476,
        0.0765453693554251,
        0.14793144821410487,
        0.0354855353801658,
        0.08562548556465976,
        0.14904929250191346,
        0.09014752857581594,
        0.14904929250191346,
        0.27284981550867593,
        -0.030800736808698534,
        0.04644481539488442,
        0.14143283188385417,
        0.17278405005245606,
        -0.022939904672374417,
        0.10940324645910479,
        0.005173238723763837,
        0.1331380040096474,
        0.1362449261988209,
        0.06359867877630405,
        0.2036771106633271,
        0.14904929250191346,
        0.06359867877630405,
        0.17730609306361222,
        0.14904929250191346,
        0.14904929250191346,
        0.17730609306361222,
        0.003009291738628822,
        0.11083538169853671,
        -0.013219746751645639,
        0.17278405005245606,
        0.1331380040096474,
        0.0765453693554251,
        0.13831446283864487,
        0.0354855353801658,
        0.10940324645910479,
        0.1331380040096474,
        0.1153574247096929,
        0.1317228831876647,
        -0.022939904672374417,
        0.14793144821410487,
        0.14904929250191346,
        0.0354855353801658,
        0.11310456670476791,
        0.005173238723763837,
        0.14904929250191346,
        0.0354855353801658,
        0.14904929250191346,
        0.17730609306361222,
        0.12165690062809299,
        0.0354855353801658,
        0.17730609306361222,
        0.14904929250191346,
        0.06359867877630405,
        0.10940324645910479,
        0.14904929250191346,
        0.03253755595674977,
        0.1233759678980692,
        0.1014405943058651,
        0.17730609306361222,
        0.1317228831876647,
        0.2187464430275592,
        0.07389199310552778,
        0.10940324645910479,
        0.06359867877630405,
        -0.050508826412655874,
        -0.09361868576977604,
        0.17278405005245606,
        0.1331380040096474,
        0.14858586403194615,
        0.14793144821410487,
        -0.022939904672374417,
        0.2187464430275592,
        0.17278405005245606,
        0.03253755595674977,
        0.18218724567821637,
        0.10940324645910479,
        0.05358833122647312,
        0.07879822736035008,
        0.06359867877630405,
        0.2187464430275592,
        -0.01076857664967893,
        0.17278405005245606,
        0.1778316747898449,
        0.09014752857581594,
        0.005173238723763837,
        -0.013219746751645639,
        0.14904929250191346,
        -0.013219746751645639,
        0.06359867877630405,
        0.03253755595674977,
        0.14904929250191346,
        0.14904929250191346,
        0.14904929250191346,
        0.10940324645910479,
        0.14651632739212217,
        0.10940324645910479,
        -0.04798389809695855,
        0.1376600470208036,
        0.10858252369361174,
        0.1331380040096474,
        0.1376600470208036,
        0.1376600470208036,
        0.1331380040096474,
        0.05080802639658133,
        0.10769496780618426,
        0.18218724567821637,
        0.1079881256371221,
        0.20514422338329186,
        0.10940324645910479,
        0.10940324645910479,
        -0.013219746751645639,
        0.10858252369361174,
        0.06359867877630405,
        0.17278405005245606,
        0.17278405005245606,
        0.005173238723763837,
        0.14904929250191346,
        0.005173238723763837,
        0.17278405005245606,
        0.1875774942569135,
        0.0765453693554251,
        0.1331380040096474,
        -0.013219746751645639,
        0.08562548556465976,
        0.17730609306361222,
        0.14904929250191346,
        0.07879822736035008,
        0.0354855353801658,
        0.14904929250191346,
        0.10940324645910479,
        0.14904929250191346,
        0.14652851081569546,
        0.14904929250191346,
        0.1079881256371221,
        0.10940324645910479,
        0.10858252369361174,
        0.11310456670476791,
        0.1331380040096474,
        0.2187464430275592,
        0.1331380040096474,
        0.14904929250191346,
        0.10940324645910479,
        0.1079881256371221,
        0.0354855353801658,
        0.05970823227417366,
        0.1376600470208036,
        0.022694883000443075,
        0.1331380040096474,
        0.003009291738628822,
        0.14904929250191346,
        0.005173238723763837,
        0.06359867877630405,
        0.16283127324947677,
        0.1317228831876647,
        -0.06334279001654182,
        0.14904929250191346,
        0.09014752857581594,
        0.17730609306361222,
        0.1913767506560704,
        0.14904929250191346,
        0.0354855353801658,
        0.1376600470208036,
        0.10212688053130412,
        0.14904929250191346,
        0.09238106106423553,
        -0.008760162040994855,
        0.14904929250191346,
        0.1331380040096474,
        0.17278405005245606,
        -0.013219746751645639,
        0.1875774942569135,
        0.0765453693554251,
        0.05529628198866002,
        -0.035978472783555884,
        0.1079881256371221,
        -0.06334279001654182,
        0.14904929250191346,
        0.14904929250191346,
        0.14904929250191346,
        0.10940324645910479,
        0.06359867877630405,
        0.25160482278551577,
        0.1875774942569135,
        0.13818562874703627,
        -0.01076857664967893,
        0.1451163823232438,
        0.1875774942569135,
        0.034070414558183104,
        0.14793144821410487,
        0.17278405005245606,
        0.0765453693554251,
        0.033610851790998465,
        -0.06334279001654182,
        0.05358833122647312,
        0.005173238723763837,
        0.04541856801053594,
        0.17730609306361222,
        0.17730609306361222,
        0.04541856801053594,
        0.022694883000443075,
        0.17556396726718887,
        -0.22127976163106342,
        0.18218724567821637,
        0.18218724567821637,
        0.05358833122647312,
        -0.030800736808698534,
        -0.1549957800312132,
        0.06426791766809728,
        0.14904929250191346,
        0.24922072480927973,
        0.13379241982748868,
        0.004424412560611518,
        0.17278405005245606,
        0.18218724567821637,
        0.011990149382231315,
        0.05393191880437666,
        0.07479148673271584,
        -0.050508826412655874,
        0.13818562874703627,
        0.14904929250191346,
        -0.022939904672374417,
        0.1331380040096474,
        0.05080802639658133,
        -0.06334279001654182,
        0.12357147268674348,
        0.10940324645910479,
        0.17730609306361222,
        0.1317228831876647,
        0.1362449261988209,
        0.005173238723763837,
        -0.013219746751645639,
        -0.030800736808698534,
        0.14793144821410487,
        0.17278405005245606,
        0.17730609306361222,
        0.13379241982748868,
        0.1875774942569135,
        0.06359867877630405,
        0.11310456670476791,
        0.1778316747898449,
        0.1079881256371221,
        0.18218724567821637,
        0.005173238723763837,
        0.17730609306361222,
        0.005173238723763837,
        0.1376600470208036,
        0.18218724567821637,
        0.14904929250191346,
        0.06426791766809728,
        0.2187464430275592,
        0.10858252369361174,
        0.1317228831876647,
        -0.06334279001654182,
        0.14793144821410487,
        0.1778316747898449,
        0.18218724567821637,
        0.03253755595674977,
        0.1362449261988209,
        0.08562548556465976,
        0.09014752857581594,
        0.005173238723763837,
        0.14904929250191346,
        0.10940324645910479,
        0.17278405005245606,
        0.07420095029846742,
        0.0765453693554251,
        0.10858252369361174,
        -0.06334279001654182,
        -0.035978472783555884,
        -0.013219746751645639,
        0.06352729285333147,
        0.05358833122647312,
        0.0354855353801658,
        0.05358833122647312,
        0.1342446789856497,
        0.20514422338329186,
        0.18218724567821637,
        0.14904929250191346,
        0.10175526548930205,
        0.06359867877630405,
        0.005173238723763837,
        0.2187464430275592,
        0.10175526548930205,
        0.005173238723763837,
        0.14904929250191346,
        -0.05321580042560864,
        0.005173238723763837,
        0.17278405005245606,
        0.10940324645910479,
        0.05080802639658133,
        0.1331380040096474,
        0.20399450210669512,
        -0.013219746751645639,
        0.09014752857581594,
        0.10940324645910479,
        0.005173238723763837,
        0.2187464430275592,
        0.06131135397021445,
        0.22787006523497316,
        0.1317228831876647,
        0.1376600470208036,
        -0.06334279001654182,
        -0.1263351417729198,
        -0.013006872042004278,
        0.18218724567821637,
        0.2187464430275592,
        0.05358833122647312,
        -0.008760162040994855,
        -0.012371350430121317,
        0.05989623314823175,
        0.1317228831876647,
        0.003009291738628822,
        0.07337636591073314,
        0.022694883000443075,
        0.09014752857581594,
        0.10858252369361174,
        0.13831446283864487,
        0.07879822736035008,
        0.1331380040096474,
        0.14904929250191346,
        0.10041892976911723,
        0.1317228831876647,
        0.1331380040096474,
        0.0354855353801658,
        0.006501492817901647,
        0.08562548556465976,
        0.13379241982748868,
        0.14904929250191346,
        0.14904929250191346,
        0.10940324645910479,
        0.17278405005245606,
        0.14289994460381888,
        0.14827119284850923,
        -0.2099316081787106,
        0.0765453693554251,
        0.14904929250191346,
        0.1778316747898449,
        0.14904929250191346,
        0.10940324645910479,
        0.03400466867671448,
        -0.06334279001654182,
        0.10290463012885409,
        0.17278405005245606,
        0.10940324645910479,
        -0.035978472783555884,
        0.003009291738628822,
        0.11310456670476791,
        0.05529628198866002,
        0.0354855353801658,
        0.1875774942569135,
        0.07879822736035008,
        0.14904929250191346,
        0.14904929250191346,
        0.07401373713516587,
        0.14904929250191346,
        0.1331380040096474,
        0.005173238723763837,
        0.17278405005245606,
        0.06359867877630405,
        0.1376600470208036,
        0.14904929250191346,
        0.06359867877630405,
        0.17278405005245606,
        0.1376600470208036,
        0.1331380040096474,
        0.14904929250191346,
        0.10290463012885409,
        0.1376600470208036,
        0.10175526548930205,
        0.14904929250191346,
        0.06359867877630405,
        0.034070414558183104,
        0.09014752857581594,
        0.1331380040096474,
        -0.039270419291082215,
        0.0354855353801658,
        -0.022939904672374417,
        0.1376600470208036,
        -0.022939904672374417,
        0.0765453693554251,
        -0.0132114765492998,
        -0.04130221524883814,
        0.17278405005245606,
        0.005173238723763837,
        -0.06334279001654182,
        0.1317228831876647,
        0.0765453693554251,
        0.1331380040096474,
        0.17730609306361222,
        0.1778316747898449,
        0.14904929250191346,
        0.14904929250191346,
        0.10940324645910479,
        0.10858252369361174,
        0.005173238723763837,
        0.05358833122647312,
        0.10175526548930205,
        -0.022939904672374417,
        0.17278405005245606,
        0.17278405005245606,
        0.011990149382231315,
        0.14904929250191346,
        0.25160482278551577,
        0.2036771106633271,
        0.1331380040096474,
        0.17278405005245606,
        0.17278405005245606,
        0.14904929250191346,
        0.17278405005245606,
        0.18308770816503828,
        0.005173238723763837,
        0.14904929250191346,
        0.17278405005245606,
        0.13818562874703627,
        0.10175526548930205,
        -0.06334279001654182,
        0.05989623314823175,
        0.033947036737228514,
        0.1376600470208036,
        0.1376600470208036,
        0.14904929250191346,
        0.17730609306361222,
        0.1331380040096474,
        0.0765453693554251,
        -0.013006872042004278,
        0.17730609306361222,
        0.1875774942569135,
        0.14904929250191346,
        0.14904929250191346,
        0.05358833122647312,
        0.03253755595674977,
        0.17730609306361222,
        0.10212688053130412,
        0.1407468957142694,
        0.22772925965723773,
        0.17730609306361222,
        0.0765453693554251,
        -0.008209296471527933,
        0.10175526548930205,
        0.1376600470208036,
        0.08472451936308598,
        0.10175526548930205,
        -0.06334279001654182,
        0.1233759678980692,
        0.005173238723763837,
        0.13818562874703627,
        0.07879822736035008,
        0.1079881256371221,
        0.20399450210669512,
        0.17278405005245606,
        0.06359867877630405,
        0.05080802639658133,
        0.14904929250191346,
        -0.061076632561932756,
        0.10940324645910479,
        -0.06334279001654182,
        0.06359867877630405,
        0.09606934606117476,
        0.13677050792505357,
        0.1785656651538821,
        0.1778316747898449,
        0.14904929250191346,
        0.011990149382231315,
        0.0765453693554251,
        0.14904929250191346,
        0.034070414558183104,
        0.17730609306361222,
        0.1153574247096929,
        0.1376600470208036,
        0.06359867877630405,
        0.05676339470862472,
        0.05080802639658133,
        0.17730609306361222,
        -0.022939904672374417,
        0.14904929250191346,
        -0.013219746751645639,
        0.10175526548930205,
        0.14904929250191346,
        -0.06334279001654182,
        0.18218724567821637,
        0.06359867877630405,
        -0.013219746751645639,
        0.10940324645910479,
        0.14651632739212217,
        0.09238106106423553,
        0.17278405005245606,
        0.14651632739212217,
        0.1331380040096474,
        0.1153574247096929,
        0.09014752857581594,
        0.13818562874703627,
        0.1331380040096474,
        0.1875774942569135,
        0.17278405005245606,
        0.005173238723763837,
        0.10290463012885409,
        -0.040575793782285735,
        0.14904929250191346,
        0.14904929250191346,
        0.10212688053130412,
        0.007916613639884343,
        0.1376600470208036,
        0.06359867877630405,
        -0.022939904672374417,
        0.06359867877630405,
        -0.06334279001654182,
        0.21422440001640303,
        0.17278405005245606,
        -0.06334279001654182,
        0.0354855353801658,
        -0.038132893882664866,
        0.07879822736035008,
        0.12357147268674348,
        0.10940324645910479,
        0.14904929250191346,
        0.10940324645910479,
        0.003009291738628822,
        0.10290463012885409,
        0.05358833122647312,
        0.1778316747898449,
        -0.22127976163106342,
        0.17730609306361222,
        -0.12543564814573174,
        -0.06334279001654182,
        0.14904929250191346,
        0.0354855353801658,
        0.1376600470208036,
        0.17556396726718887,
        0.09238106106423553,
        0.1079881256371221,
        0.12165690062809299,
        0.07389199310552778,
        0.06359867877630405,
        0.06426791766809728,
        0.04601768871925116,
        0.1778316747898449,
        0.05080802639658133,
        0.13379241982748868,
        0.14904929250191346,
        0.10212688053130412,
        0.17278405005245606,
        0.13677050792505357,
        0.17730609306361222,
        0.030318905283472135,
        0.0765453693554251,
        0.17730609306361222,
        0.21422440001640303,
        0.003009291738628822,
        0.10858252369361174,
        0.17730609306361222,
        -0.0358667364280558,
        0.10940324645910479,
        0.003009291738628822,
        0.06359867877630405,
        0.14904929250191346,
        0.13831446283864487,
        0.10940324645910479,
        0.14904929250191346,
        0.03253755595674977,
        0.2566524475229046,
        0.10858252369361174,
        0.10940324645910479,
        -0.013219746751645639,
        0.17730609306361222,
        0.14904929250191346,
        0.019118005870762927,
        0.23762466613936592,
        0.14904929250191346,
        0.05358833122647312,
        0.17730609306361222,
        0.1875774942569135,
        0.11310456670476791,
        0.0765453693554251,
        0.03253755595674977,
        -0.030800736808698534,
        0.1376600470208036,
        0.1376600470208036,
        0.17278405005245606,
        0.10940324645910479,
        0.05358833122647312,
        0.1331380040096474,
        0.022694883000443075,
        0.1875774942569135,
        0.005173238723763837,
        0.07259861631318318,
        0.22787006523497316,
        0.11310456670476791,
        0.3136972097371261,
        0.003009291738628822,
        -0.013219746751645639,
        0.10041892976911723,
        -0.06334279001654182,
        0.1376600470208036,
        -0.022939904672374417,
        0.07337636591073314,
        0.08562548556465976,
        0.21422440001640303,
        0.06359867877630405,
        0.17730609306361222,
        0.048126779368608076,
        0.03253755595674977,
        -0.013219746751645639,
        -0.04130221524883814,
        0.17278405005245606,
        0.09014752857581594,
        0.10940324645910479,
        0.20399450210669512,
        0.0354855353801658,
        0.1362449261988209,
        0.1778316747898449,
        -0.013219746751645639,
        0.0765453693554251,
        0.05882074792487542,
        0.17730609306361222,
        -0.012371350430121317,
        0.18218724567821637,
        0.06359867877630405,
        0.09238106106423553,
        0.22772925965723773,
        0.1317228831876647,
        0.1778316747898449,
        0.1362449261988209,
        0.1778316747898449,
        0.1778316747898449,
        0.17730609306361222,
        0.3529712934223157,
        0.16735331626063293,
        -0.06334279001654182,
        0.06359867877630405,
        -0.06334279001654182,
        0.03253755595674977,
        0.10175526548930205,
        0.10175526548930205,
        0.1317228831876647,
        0.1153574247096929,
        0.14827119284850923,
        0.09606934606117476,
        0.06359867877630405,
        0.07401373713516587,
        0.005173238723763837,
        0.10940324645910479,
        0.15042880031573985,
        0.1331380040096474,
        0.1407468957142694,
        0.09014752857581594,
        0.17278405005245606,
        0.06962485663602216,
        0.003009291738628822,
        0.03918240465157183,
        0.0354855353801658,
        0.10041892976911723,
        0.10940324645910479,
        0.1376600470208036,
        0.1875774942569135,
        -0.01076857664967893,
        0.033610851790998465,
        0.14904929250191346,
        0.09238106106423553,
        0.011990149382231315,
        0.10175526548930205,
        0.1875774942569135,
        -0.038132893882664866,
        0.14904929250191346,
        0.1778316747898449,
        0.10858252369361174,
        -0.06334279001654182,
        -0.06334279001654182,
        0.06359867877630405,
        0.14904929250191346,
        0.17278405005245606,
        0.0354855353801658,
        0.005173238723763837,
        0.13818562874703627,
        0.1376600470208036,
        0.14793144821410487,
        0.011990149382231315,
        0.10858252369361174,
        0.17730609306361222,
        0.033610851790998465,
        0.17730609306361222,
        0.1331380040096474,
        0.03449833614029671,
        -0.18134000997594152,
        0.14651632739212217,
        0.10940324645910479,
        0.06359867877630405,
        0.09014752857581594,
        0.14904929250191346,
        0.13677050792505357,
        0.17278405005245606,
        0.14793144821410487,
        0.14904929250191346,
        -0.030800736808698534,
        0.1331380040096474,
        0.004424412560611518,
        0.11310456670476791,
        0.1317228831876647,
        0.17278405005245606,
        0.005173238723763837,
        0.005173238723763837,
        0.10940324645910479,
        0.14904929250191346,
        0.17278405005245606,
        0.1153574247096929,
        0.2187464430275592,
        0.005173238723763837,
        0.1778316747898449,
        0.10041892976911723,
        0.14904929250191346,
        0.1233759678980692,
        0.20399450210669512,
        0.09014752857581594,
        0.09014752857581594,
        0.14904929250191346,
        0.12165690062809299,
        0.1778316747898449,
        0.005173238723763837,
        0.14793144821410487,
        0.10940324645910479,
        0.034070414558183104,
        0.10940324645910479,
        0.14904929250191346,
        0.1317228831876647,
        0.13062309846131542,
        0.1376600470208036,
        0.10940324645910479,
        -0.022939904672374417,
        0.03253755595674977,
        0.1376600470208036,
        0.21422440001640303,
        0.0022616602035155503,
        0.1601306700360863,
        0.09238106106423553,
        0.1778316747898449,
        -0.035978472783555884,
        -0.035978472783555884,
        0.011990149382231315,
        0.1014405943058651,
        0.04541856801053594,
        0.14904929250191346,
        0.1407468957142694,
        0.22787006523497316,
        0.005173238723763837,
        0.17278405005245606,
        0.14904929250191346,
        0.005173238723763837,
        0.18218724567821637,
        -0.038132893882664866,
        0.14904929250191346,
        0.17278405005245606,
        0.17730609306361222,
        -0.022939904672374417,
        0.034070414558183104,
        0.005173238723763837,
        0.1362449261988209,
        0.14904929250191346,
        0.14904929250191346,
        0.08562548556465976,
        0.06359867877630405,
        0.14904929250191346,
        0.13818562874703627,
        0.17730609306361222,
        0.1376600470208036,
        0.1875774942569135,
        0.06359867877630405,
        0.10940324645910479,
        0.17278405005245606,
        0.10940324645910479,
        0.1331380040096474,
        0.21422440001640303,
        0.06359867877630405,
        0.18218724567821637,
        0.17278405005245606,
        0.005173238723763837,
        0.06359867877630405,
        0.17730609306361222,
        0.0765453693554251,
        -0.022939904672374417,
        0.17730609306361222,
        0.1376600470208036,
        0.08562548556465976,
        0.17278405005245606,
        0.0765453693554251,
        0.1376600470208036,
        0.005173238723763837,
        0.13818562874703627,
        0.06359867877630405,
        0.06359867877630405,
        -0.0432827677952385,
        0.14143283188385417,
        0.17278405005245606,
        0.1079881256371221,
        0.0949573779112522,
        0.06206018013336677,
        0.10940324645910479,
        0.1376600470208036,
        0.10858252369361174,
        0.1778316747898449,
        0.11310456670476791,
        0.1014405943058651,
        0.1376600470208036,
        0.16628183332383634,
        0.05080802639658133,
        0.10940324645910479,
        0.14904929250191346,
        0.17278405005245606,
        0.1331380040096474,
        0.1875774942569135,
        0.1376600470208036,
        0.10940324645910479,
        0.17278405005245606,
        0.08562548556465976,
        0.06359867877630405,
        0.03253755595674977,
        0.14904929250191346,
        0.0354855353801658,
        0.10940324645910479,
        0.1376600470208036,
        0.005173238723763837,
        0.06359867877630405,
        0.17730609306361222,
        0.1079881256371221,
        0.1331380040096474,
        0.034070414558183104,
        0.041239757867822524,
        -0.035978472783555884,
        0.07401373713516587,
        0.1407468957142694,
        0.1079881256371221,
        0.14904929250191346,
        0.10940324645910479,
        0.06359867877630405,
        0.0765453693554251,
        0.18218724567821637,
        0.03253755595674977,
        0.14904929250191346,
        0.005173238723763837,
        0.03253755595674977,
        0.13831446283864487,
        0.03253755595674977,
        -0.06334279001654182,
        0.09014752857581594,
        0.0354855353801658,
        0.10940324645910479,
        0.10175526548930205,
        0.0765453693554251,
        0.10858252369361174,
        0.10940324645910479,
        -0.013219746751645639,
        0.0354855353801658,
        -0.038132893882664866,
        0.0354855353801658,
        0.1331380040096474,
        0.1014405943058651,
        0.14904929250191346,
        0.06359867877630405,
        0.17278405005245606,
        0.10940324645910479,
        0.10940324645910479,
        -0.013219746751645639,
        0.1331380040096474,
        0.17278405005245606,
        0.10940324645910479,
        -0.00559084067482158,
        0.1079881256371221,
        0.08562548556465976,
        0.17730609306361222,
        -0.050508826412655874,
        0.2187464430275592,
        0.3009629589048142,
        0.10940324645910479,
        0.1079881256371221,
        0.22901784422086047,
        0.0894244973663527,
        0.10940324645910479,
        -0.06334279001654182,
        -0.19352398178621327,
        0.22787006523497316,
        0.1778316747898449,
        -0.022939904672374417,
        0.21422440001640303,
        0.1376600470208036,
        0.09238106106423553,
        0.06359867877630405,
        -0.022939904672374417,
        0.0354855353801658,
        0.04663202855818596,
        0.1601306700360863,
        0.10175526548930205,
        0.06426791766809728,
        0.13379241982748868,
        0.07401373713516587,
        0.1331380040096474,
        0.14904929250191346,
        0.08562548556465976,
        0.2211075814131415,
        -0.022939904672374417,
        0.06359867877630405,
        0.17278405005245606,
        0.055651426558702144,
        0.17278405005245606,
        0.05358833122647312,
        0.1331380040096474,
        0.06359867877630405,
        0.1317228831876647,
        0.14904929250191346,
        0.11310456670476791,
        0.10858252369361174,
        0.1875774942569135,
        0.0354855353801658,
        0.14904929250191346,
        0.17278405005245606,
        -0.035978472783555884,
        0.04601768871925116,
        0.005173238723763837,
        0.0354855353801658,
        0.1079881256371221,
        0.011990149382231315,
        0.03253755595674977,
        0.17730609306361222,
        -0.06334279001654182,
        0.13379241982748868,
        0.0765453693554251,
        0.09238106106423553,
        0.09606934606117476,
        0.0354855353801658,
        0.20257938128471242,
        0.17278405005245606,
        0.13379241982748868,
        0.10940324645910479,
        0.0354855353801658,
        0.14904929250191346,
        0.05358833122647312,
        0.005173238723763837,
        0.14904929250191346,
        0.14904929250191346,
        0.1331380040096474,
        -0.1165893223058512,
        0.06359867877630405,
        -0.022939904672374417,
        0.10940324645910479,
        0.07401373713516587,
        0.10940324645910479,
        0.006640351443728543,
        0.1079881256371221,
        0.055651426558702144,
        0.17730609306361222,
        0.05358833122647312,
        0.06359867877630405,
        0.14793144821410487,
        0.07259861631318318,
        0.11310456670476791,
        -0.035978472783555884,
        0.14904929250191346,
        0.11310456670476791,
        0.14904929250191346,
        0.1778316747898449,
        0.10940324645910479,
        0.06352729285333147,
        0.0765453693554251,
        -0.013219746751645639,
        0.10940324645910479,
        0.1875774942569135,
        0.14904929250191346,
        0.14904929250191346,
        0.14651632739212217,
        0.034070414558183104,
        -0.31578117804460704,
        0.10940324645910479,
        0.1331380040096474,
        0.1875774942569135,
        0.10940324645910479,
        0.10940324645910479,
        -0.022939904672374417,
        0.1376600470208036,
        0.005173238723763837,
        0.13818562874703627,
        0.10175526548930205,
        0.18218724567821637,
        0.2187464430275592,
        0.13379241982748868,
        0.10175526548930205,
        0.07389199310552778,
        0.1079881256371221,
        0.05358833122647312,
        -0.06334279001654182,
        0.17278405005245606,
        -0.01076857664967893,
        0.10940324645910479,
        -0.013219746751645639,
        0.06359867877630405,
        0.03253755595674977,
        0.14904929250191346,
        -0.022939904672374417,
        0.10940324645910479,
        0.032327311407950296,
        0.14904929250191346,
        0.005173238723763837,
        0.03253755595674977,
        0.05080802639658133,
        0.07389199310552778,
        0.1331380040096474,
        0.1376600470208036,
        0.005173238723763837,
        0.17278405005245606,
        0.22901784422086047,
        0.17278405005245606,
        0.20475507403854515,
        0.0354855353801658,
        0.1331380040096474,
        0.14904929250191346,
        0.06359867877630405,
        0.03253755595674977,
        -0.06334279001654182,
        0.1079881256371221,
        0.005173238723763837,
        0.10212688053130412,
        0.10940324645910479,
        -0.022939904672374417,
        -0.012371350430121317,
        0.21422440001640303,
        0.1376600470208036,
        0.10940324645910479,
        0.14904929250191346,
        0.083946769765536,
        0.1875774942569135,
        0.17278405005245606,
        0.014357445190981658,
        0.07401373713516587,
        0.0354855353801658,
        -0.022939904672374417,
        0.17278405005245606,
        0.17278405005245606,
        0.0765453693554251,
        0.25160482278551577,
        0.10940324645910479,
        0.1875774942569135,
        0.17278405005245606,
        0.14904929250191346,
        0.14904929250191346,
        0.13347774864405176,
        -0.022939904672374417,
        0.17278405005245606,
        0.10041892976911723,
        0.17278405005245606,
        0.1331380040096474,
        0.03253755595674977,
        0.14904929250191346,
        0.05358833122647312,
        -0.013219746751645639,
        0.1875774942569135,
        0.05358833122647312,
        0.20257938128471242,
        0.005173238723763837,
        0.005173238723763837,
        0.1079881256371221,
        0.17278405005245606,
        0.1331380040096474,
        0.1778316747898449,
        0.011990149382231315,
        0.0765453693554251,
        0.13379241982748868,
        0.11083538169853671,
        0.17730609306361222,
        0.1153574247096929,
        -0.035978472783555884,
        -0.013219746751645639,
        0.11310456670476791,
        0.07401373713516587,
        0.034070414558183104,
        0.011990149382231315,
        -0.06334279001654182,
        0.0354855353801658,
        -0.01076857664967893,
        0.17278405005245606,
        0.005173238723763837,
        0.005173238723763837,
        0.20514422338329186,
        0.03253755595674977,
        0.17730609306361222,
        0.08562548556465976,
        0.10290463012885409,
        0.1079881256371221,
        0.1362449261988209,
        0.034070414558183104,
        0.1376600470208036,
        0.14904929250191346,
        0.17730609306361222,
        -0.06334279001654182,
        -0.013219746751645639,
        0.17278405005245606,
        0.1376600470208036,
        0.08201085458528434,
        0.17730609306361222,
        0.1362449261988209,
        0.10940324645910479,
        -0.013006872042004278,
        -0.022939904672374417,
        0.17278405005245606,
        -0.013006872042004278,
        0.17278405005245606,
        0.10215874819866462,
        0.1778316747898449,
        0.11310456670476791,
        0.18218724567821637,
        0.03608988395524889,
        0.10940324645910479,
        0.1407468957142694,
        0.17278405005245606,
        0.06359867877630405,
        0.17730609306361222,
        0.052275139116546035,
        0.1407468957142694,
        0.0354855353801658,
        -0.012371350430121317,
        0.06359867877630405,
        0.1376600470208036,
        0.03253755595674977,
        0.22787006523497316,
        0.14904929250191346,
        0.14793144821410487,
        0.09238106106423553,
        0.17730609306361222,
        0.05529628198866002,
        0.07420095029846742,
        0.14904929250191346,
        0.1331380040096474,
        0.08562548556465976,
        0.003009291738628822,
        0.03253755595674977,
        0.10858252369361174,
        0.04541856801053594,
        0.0894244973663527,
        0.06359867877630405,
        0.1778316747898449,
        -0.013219746751645639,
        0.10290463012885409,
        0.04541856801053594,
        0.10357386902064732,
        -0.013219746751645639,
        0.18218724567821637,
        0.022694883000443075,
        0.1317228831876647,
        0.11083538169853671,
        0.10214879366722657,
        0.22772925965723773,
        -0.013219746751645639,
        -0.013006872042004278,
        0.03253755595674977,
        -0.022939904672374417,
        0.10858252369361174,
        -0.06334279001654182,
        0.017904545323112905,
        0.1875774942569135,
        0.005173238723763837,
        0.07879822736035008,
        0.1662268722835451,
        0.17730609306361222,
        0.2036771106633271,
        0.17278405005245606,
        0.0765453693554251,
        -0.024559630001652635,
        0.14651632739212217,
        0.05358833122647312,
        0.17278405005245606,
        0.14904929250191346,
        0.006640351443728543,
        0.0765453693554251,
        0.17278405005245606,
        0.18218724567821637,
        0.1778316747898449,
        0.10940324645910479,
        0.17730609306361222,
        0.04601768871925116,
        0.1362449261988209,
        0.17278405005245606,
        0.17278405005245606,
        0.1362449261988209,
        0.14651632739212217,
        0.10940324645910479,
        0.14904929250191346,
        0.04541856801053594,
        0.1778316747898449,
        0.022694883000443075,
        -0.013219746751645639,
        0.11083538169853671,
        -0.035978472783555884,
        0.1079881256371221,
        0.22901784422086047,
        0.14793144821410487,
        0.1331380040096474,
        -0.13046649272992172,
        0.0354855353801658,
        0.17278405005245606,
        0.10357386902064732,
        0.17278405005245606,
        0.10940324645910479,
        0.0765453693554251,
        0.14858586403194615,
        0.17730609306361222,
        -0.06334279001654182,
        0.17730609306361222,
        0.1331380040096474,
        0.0354855353801658,
        0.14793144821410487,
        0.14904929250191346,
        0.07420095029846742,
        0.1778316747898449,
        -0.022939904672374417,
        0.09014752857581594,
        0.09762675065607039,
        0.17730609306361222,
        -0.022939904672374417,
        -0.024559630001652635,
        0.03253755595674977,
        -0.08818678170021069,
        0.17278405005245606,
        0.1331380040096474,
        0.10940324645910479,
        -0.024559630001652635,
        0.07879822736035008,
        0.14904929250191346,
        -0.022939904672374417,
        0.18218724567821637,
        0.0765453693554251,
        0.017904545323112905,
        0.20514422338329186,
        0.08562548556465976,
        0.14793144821410487,
        -0.013219746751645639,
        -0.040575793782285735,
        0.18218724567821637,
        0.0765453693554251,
        0.1331380040096474,
        0.06359867877630405,
        -0.022939904672374417,
        -0.06334279001654182,
        -0.022939904672374417,
        0.05358833122647312,
        0.006640351443728543,
        0.14904929250191346,
        0.14858586403194615,
        0.14904929250191346,
        0.17278405005245606,
        0.1317228831876647,
        -0.1587232932916205,
        0.06359867877630405,
        0.0354855353801658,
        0.03253755595674977,
        0.14793144821410487,
        0.03253755595674977,
        -0.013006872042004278,
        0.18218724567821637,
        0.10858252369361174,
        0.11310456670476791,
        0.06426791766809728,
        0.05358833122647312,
        0.09014752857581594,
        0.0354855353801658,
        0.14904929250191346,
        0.1875774942569135,
        0.14904929250191346,
        0.1875774942569135,
        0.1362449261988209,
        0.14904929250191346,
        0.05676339470862472,
        0.1875774942569135,
        0.10175526548930205,
        0.17730609306361222,
        0.09606934606117476,
        -0.06334279001654182,
        0.22787006523497316,
        0.14904929250191346,
        0.03253755595674977,
        0.06359867877630405,
        0.1362449261988209,
        0.0354855353801658,
        0.10175526548930205,
        0.14904929250191346,
        0.10940324645910479,
        0.21422440001640303,
        0.14904929250191346,
        -0.035978472783555884,
        0.034070414558183104,
        0.005173238723763837,
        0.17278405005245606,
        -0.035978472783555884,
        0.09606934606117476,
        0.1331380040096474,
        0.14904929250191346,
        0.14904929250191346,
        0.10858252369361174,
        0.06359867877630405,
        0.07337636591073314,
        0.10858252369361174,
        0.005173238723763837,
        0.10940324645910479,
        0.0765453693554251,
        0.18218724567821637,
        -0.038132893882664866,
        0.1331380040096474,
        0.17730609306361222,
        0.04601768871925116,
        0.0894244973663527,
        -0.022939904672374417,
        -0.013219746751645639,
        0.0765453693554251,
        0.2187464430275592,
        0.22772925965723773,
        0.17730609306361222,
        0.03253755595674977,
        0.033947036737228514,
        0.1331380040096474,
        -0.013219746751645639,
        0.005173238723763837,
        0.08562548556465976,
        -0.022939904672374417,
        0.05358833122647312,
        0.17278405005245606,
        0.17730609306361222,
        0.10940324645910479,
        0.07337636591073314,
        0.13677050792505357,
        0.1362449261988209,
        0.03253755595674977,
        0.09606934606117476,
        0.14904929250191346,
        0.05882074792487542,
        0.14143283188385417,
        0.14904929250191346,
        0.005173238723763837,
        0.17730609306361222,
        0.1079881256371221,
        0.17278405005245606,
        0.0354855353801658,
        0.1913767506560704,
        0.10940324645910479,
        0.1778316747898449,
        0.005173238723763837,
        0.1331380040096474,
        -0.025102657029470385,
        0.14904929250191346,
        0.1079881256371221,
        0.17730609306361222,
        0.005173238723763837,
        0.17730609306361222,
        0.17730609306361222,
        0.09014752857581594,
        0.004424412560611518,
        0.09014752857581594,
        0.003009291738628822,
        0.00882082801605804,
        0.13677050792505357,
        0.1079881256371221,
        0.004424412560611518,
        -0.013219746751645639,
        0.04541856801053594,
        -0.022939904672374417,
        0.2187464430275592,
        0.10940324645910479,
        0.14904929250191346,
        -0.013219746751645639,
        -0.01076857664967893,
        0.18218724567821637,
        0.14793144821410487,
        -0.022939904672374417,
        0.17278405005245606,
        0.2036771106633271,
        -0.013006872042004278,
        0.034070414558183104,
        0.0765453693554251,
        0.10940324645910479,
        0.06359867877630405,
        0.11310456670476791,
        -0.013219746751645639,
        0.2036771106633271,
        0.10290463012885409,
        0.05358833122647312,
        0.05358833122647312,
        0.14651632739212217,
        0.07479148673271584,
        0.0354855353801658,
        0.10940324645910479,
        0.18218724567821637,
        0.10858252369361174,
        0.10940324645910479,
        0.05358833122647312,
        0.10290463012885409,
        0.10214879366722657,
        0.14904929250191346,
        0.1376600470208036,
        -0.038132893882664866,
        -0.035978472783555884,
        -0.013219746751645639,
        0.17278405005245606,
        0.17278405005245606,
        0.17730609306361222,
        0.0354855353801658,
        0.14904929250191346,
        0.10858252369361174,
        0.1376600470208036,
        0.0394745060004525,
        0.034070414558183104,
        0.08562548556465976,
        0.17278405005245606,
        0.1079881256371221,
        0.10940324645910479,
        -0.31578117804460704,
        0.1479950455269074,
        0.1875774942569135,
        0.18218724567821637,
        0.1331380040096474,
        0.1875774942569135,
        0.0949573779112522,
        0.1331380040096474,
        0.14793144821410487,
        0.06359867877630405,
        0.21422440001640303,
        0.1331380040096474,
        0.14904929250191346,
        0.10940324645910479,
        0.08562548556465976,
        -0.022939904672374417,
        0.10940324645910479,
        0.10175526548930205,
        0.14904929250191346,
        0.14904929250191346,
        0.18218724567821637,
        0.17278405005245606,
        0.1376600470208036,
        0.17730609306361222,
        0.24922072480927973,
        0.0354855353801658,
        0.1331380040096474,
        0.0354855353801658,
        0.17730609306361222,
        0.1376600470208036,
        0.2187464430275592,
        -0.013219746751645639,
        -0.09420365826434961,
        0.07479148673271584,
        0.1376600470208036,
        0.18218724567821637,
        0.2566524475229046,
        -0.06334279001654182,
        0.06359867877630405,
        0.10175526548930205,
        0.14904929250191346,
        0.034070414558183104,
        0.17278405005245606,
        0.14904929250191346,
        0.06359867877630405,
        0.14904929250191346,
        0.10940324645910479,
        0.1362449261988209,
        0.2187464430275592,
        0.005173238723763837,
        0.030318905283472135,
        -0.06334279001654182,
        -0.035978472783555884,
        -0.022939904672374417,
        0.1407468957142694,
        -0.01076857664967893,
        0.1376600470208036,
        -0.013219746751645639,
        0.2187464430275592,
        0.08562548556465976,
        0.06359867877630405,
        0.10041892976911723,
        -0.06334279001654182,
        0.005173238723763837,
        0.03253755595674977,
        0.14904929250191346,
        0.17278405005245606,
        0.08562548556465976,
        -0.022939904672374417,
        0.14793144821410487,
        0.1376600470208036,
        0.2187464430275592,
        0.0043325724239793514,
        0.1079881256371221,
        0.1014405943058651,
        0.03253755595674977,
        0.11310456670476791,
        0.10214879366722657,
        0.13799979165520793,
        0.07401373713516587,
        0.14904929250191346,
        0.10212688053130412,
        0.10290463012885409,
        0.14904929250191346,
        -0.022939904672374417,
        0.06359867877630405,
        0.17730609306361222,
        0.1778316747898449,
        0.10858252369361174,
        0.08562548556465976,
        -0.09129370388938417,
        0.06131135397021445,
        0.14904929250191346,
        0.005173238723763837,
        -0.035978472783555884,
        0.17730609306361222,
        0.04722256499243438,
        0.14904929250191346,
        0.006640351443728543,
        0.17730609306361222,
        0.14793144821410487,
        0.1407468957142694,
        0.09606934606117476,
        0.08562548556465976,
        0.14904929250191346,
        0.2187464430275592,
        0.06359867877630405,
        0.1331380040096474,
        0.07479148673271584,
        0.0765453693554251,
        0.17730609306361222,
        0.08059573376330165,
        0.14858586403194615,
        0.03253755595674977,
        0.1079881256371221,
        0.1407468957142694,
        0.1362449261988209,
        0.10175526548930205,
        -0.04130221524883814,
        0.1376600470208036,
        0.14793144821410487,
        0.14827119284850923,
        0.1362449261988209,
        0.003009291738628822,
        0.003009291738628822,
        -0.035978472783555884,
        0.083946769765536,
        0.17278405005245606,
        0.1331380040096474,
        0.10214879366722657,
        -0.013219746751645639,
        0.10940324645910479,
        0.17278405005245606,
        0.25612686579667193,
        0.22787006523497316,
        0.14904929250191346,
        0.10212688053130412,
        -0.3440379786063058,
        0.14904929250191346,
        0.14904929250191346,
        0.0354855353801658,
        0.06426791766809728,
        0.17278405005245606,
        0.17278405005245606,
        0.07389199310552778,
        0.10940324645910479,
        0.10858252369361174,
        0.2187464430275592,
        0.1331380040096474,
        0.005173238723763837,
        0.05358833122647312,
        0.034070414558183104,
        0.1875774942569135,
        0.1376600470208036,
        0.034070414558183104,
        0.007916613639884343,
        0.14904929250191346,
        0.05358833122647312,
        0.10858252369361174,
        0.08562548556465976,
        0.06359867877630405,
        0.14793144821410487,
        0.14827119284850923,
        0.14904929250191346,
        0.14904929250191346,
        0.09606934606117476,
        0.1079881256371221,
        0.21422440001640303,
        -0.32030322105576325,
        0.1079881256371221,
        -0.06334279001654182,
        0.12562882590299418,
        0.1778316747898449,
        0.17278405005245606,
        0.03253755595674977,
        0.17278405005245606,
        -0.022939904672374417,
        0.0354855353801658,
        0.11310456670476791,
        0.14904929250191346,
        0.0765453693554251,
        0.14904929250191346,
        0.10940324645910479,
        0.0765453693554251,
        0.03019716125383405,
        0.1362449261988209,
        -0.022939904672374417,
        -0.050508826412655874,
        0.003009291738628822,
        0.1317228831876647,
        0.011990149382231315,
        0.03253755595674977,
        -0.013219746751645639,
        0.11310456670476791,
        0.17730609306361222,
        0.016411031857810163,
        0.13062309846131542,
        0.1376600470208036,
        0.11310456670476791,
        -0.06334279001654182,
        0.17278405005245606,
        0.005173238723763837,
        0.10212688053130412,
        0.0354855353801658,
        0.17278405005245606,
        0.1875774942569135,
        0.05080802639658133,
        0.2566524475229046,
        0.1331380040096474,
        -0.022939904672374417,
        0.033610851790998465,
        0.17730609306361222,
        0.03253755595674977,
        0.06359867877630405,
        0.05358833122647312,
        0.005173238723763837,
        0.10175526548930205,
        0.17278405005245606,
        0.11933627908947493,
        0.1407468957142694,
        0.1079881256371221,
        0.1233759678980692,
        0.08201085458528434,
        0.1376600470208036,
        0.13379241982748868,
        0.08562548556465976,
        0.10858252369361174,
        0.0765453693554251,
        -0.013219746751645639,
        -0.013219746751645639,
        0.005173238723763837,
        0.1079881256371221,
        0.09014752857581594,
        0.18218724567821637,
        0.10212688053130412,
        0.22787006523497316,
        0.17278405005245606,
        0.14904929250191346,
        0.06426791766809728,
        0.16628183332383634,
        0.1079881256371221,
        -0.022939904672374417,
        0.17730609306361222,
        0.06359867877630405,
        0.23083618184641125,
        -0.035978472783555884,
        0.17278405005245606,
        0.17278405005245606,
        0.1331380040096474,
        -0.06334279001654182,
        0.13379241982748868,
        0.13831446283864487,
        0.10940324645910479,
        0.10212688053130412,
        0.22901784422086047,
        0.005173238723763837,
        0.0354855353801658,
        0.0894244973663527,
        -0.022939904672374417,
        0.14307103664001752,
        0.14904929250191346,
        0.1317228831876647,
        0.23225130266839394,
        0.10858252369361174,
        0.1079881256371221,
        0.13379241982748868,
        -0.013219746751645639,
        0.005173238723763837,
        0.17278405005245606,
        -0.022939904672374417,
        -0.017708002343724327,
        0.14904929250191346,
        0.17278405005245606,
        0.005173238723763837,
        0.1317228831876647,
        -0.022939904672374417,
        0.09014752857581594,
        0.003009291738628822,
        0.0354855353801658,
        0.05529628198866002,
        0.1331380040096474,
        0.10041892976911723,
        0.11083538169853671,
        -0.022939904672374417,
        0.1079881256371221,
        0.2187464430275592,
        0.17730609306361222,
        0.1079881256371221,
        0.0765453693554251,
        0.034070414558183104,
        0.17730609306361222,
        0.1317228831876647,
        0.17730609306361222,
        0.1079881256371221,
        -0.06334279001654182,
        0.0354855353801658,
        0.05358833122647312,
        0.14904929250191346,
        -0.013219746751645639,
        0.11310456670476791,
        0.005173238723763837,
        0.13818562874703627,
        0.14904929250191346,
        0.10940324645910479,
        0.06359867877630405,
        0.005173238723763837,
        0.14904929250191346,
        0.1317228831876647,
        0.09762675065607039,
        -0.06334279001654182,
        0.005173238723763837,
        0.06359867877630405,
        0.14904929250191346,
        0.005173238723763837,
        0.13677050792505357,
        0.0765453693554251,
        0.18218724567821637,
        0.17730609306361222,
        0.005173238723763837,
        0.25160482278551577,
        0.10212688053130412,
        0.17730609306361222,
        0.20399450210669512,
        0.10175526548930205,
        -0.12994091100368904,
        0.1875774942569135,
        0.03253755595674977,
        0.07389199310552778,
        0.10212688053130412,
        0.10357386902064732,
        0.042949043393750726,
        0.10940324645910479,
        0.0765453693554251,
        0.011990149382231315,
        0.05358833122647312,
        0.06359867877630405,
        -0.1647415994982818,
        0.0894244973663527,
        0.1778316747898449,
        0.12357147268674348,
        0.11310456670476791,
        0.08454589047425123,
        0.10940324645910479,
        0.22772925965723773,
        0.1331380040096474,
        -0.022939904672374417,
        0.12165690062809299,
        0.03918240465157183,
        0.0354855353801658,
        0.1376600470208036,
        0.06359867877630405,
        0.1153574247096929,
        -0.013219746751645639,
        0.17278405005245606,
        0.1778316747898449,
        0.14904929250191346,
        0.1407468957142694,
        0.14904929250191346,
        0.05358833122647312,
        0.20514422338329186,
        0.05529628198866002,
        0.10940324645910479,
        0.17730609306361222,
        0.14904929250191346,
        0.005173238723763837,
        -0.022939904672374417,
        -0.013006872042004278,
        -0.022939904672374417,
        0.11310456670476791,
        0.1875774942569135,
        0.17278405005245606,
        0.23225130266839394,
        0.1778316747898449,
        0.03253755595674977,
        0.04541856801053594,
        0.06359867877630405,
        0.14904929250191346,
        0.10290463012885409,
        0.1079881256371221,
        0.1376600470208036,
        0.13379241982748868,
        0.20514422338329186,
        0.10940324645910479,
        0.14904929250191346,
        0.10940324645910479,
        0.22787006523497316,
        0.10940324645910479,
        0.1778316747898449,
        0.10858252369361174,
        -0.013219746751645639,
        0.03253755595674977,
        0.1376600470208036,
        0.20399450210669512,
        0.11310456670476791,
        0.0354855353801658,
        0.06359867877630405,
        0.18218724567821637,
        -0.050508826412655874,
        0.05989623314823175,
        0.10175526548930205,
        0.1875774942569135,
        0.1014405943058651,
        0.17730609306361222,
        0.1331380040096474,
        0.005173238723763837,
        0.033610851790998465,
        0.21422440001640303,
        0.13347774864405176,
        0.10940324645910479,
        0.007916613639884343,
        -0.022939904672374417,
        0.09014752857581594,
        0.003009291738628822,
        0.1331380040096474,
        0.0765453693554251,
        0.1778316747898449,
        0.13379241982748868,
        0.1376600470208036,
        0.14904929250191346,
        0.11083538169853671,
        0.011990149382231315,
        0.17730609306361222,
        0.005173238723763837,
        0.011990149382231315,
        0.18218724567821637,
        0.1376600470208036,
        0.03253755595674977,
        0.2187464430275592,
        0.09606934606117476,
        0.14904929250191346,
        0.09762675065607039,
        0.05358833122647312,
        0.06131135397021445,
        0.17278405005245606,
        0.0765453693554251,
        0.1362449261988209,
        0.0765453693554251,
        0.006640351443728543,
        0.22901784422086047,
        0.10041892976911723,
        0.09606934606117476,
        0.17278405005245606,
        0.005173238723763837,
        -0.013219746751645639,
        -0.061076632561932756,
        0.2036771106633271,
        0.1342446789856497,
        0.06359867877630405,
        0.08562548556465976,
        0.1079881256371221,
        0.0354855353801658,
        0.07401373713516587,
        0.1331380040096474,
        0.1014405943058651,
        0.17730609306361222,
        0.03253755595674977,
        0.14793144821410487,
        0.07479148673271584,
        0.1376600470208036,
        0.0765453693554251,
        0.13799979165520793,
        0.10940324645910479,
        0.06359867877630405,
        0.1317228831876647,
        0.0765453693554251,
        -0.06334279001654182,
        0.10212688053130412,
        0.10858252369361174,
        0.17730609306361222,
        0.011990149382231315,
        -0.06334279001654182,
        0.22787006523497316,
        -0.035978472783555884,
        0.1233759678980692,
        0.005173238723763837,
        0.10175526548930205,
        0.14793144821410487,
        0.005173238723763837,
        0.1153574247096929,
        0.14793144821410487,
        0.033610851790998465,
        0.1079881256371221,
        0.10940324645910479,
        0.21422440001640303,
        0.23225130266839394,
        0.06359867877630405,
        0.2036771106633271,
        0.0354855353801658,
        0.05358833122647312,
        0.1778316747898449,
        0.32344302920419477,
        0.14904929250191346,
        0.1376600470208036,
        0.1376600470208036,
        0.06352729285333147,
        0.005173238723763837,
        0.1778316747898449,
        0.14904929250191346,
        0.1331380040096474,
        0.14793144821410487,
        0.005173238723763837,
        0.14904929250191346,
        0.14904929250191346,
        0.14904929250191346,
        0.18218724567821637,
        0.06359867877630405,
        0.027837577953483045,
        0.10940324645910479,
        0.11310456670476791,
        0.06131135397021445,
        0.10175526548930205,
        0.11083538169853671,
        0.14793144821410487,
        -0.06334279001654182,
        0.003009291738628822,
        0.17278405005245606,
        0.10940324645910479,
        0.1662268722835451,
        0.10175526548930205,
        0.14904929250191346,
        0.1376600470208036,
        0.14904929250191346,
        0.10940324645910479,
        0.0765453693554251,
        0.14904929250191346,
        0.17278405005245606,
        0.14904929250191346,
        -0.0662543685367901,
        0.11310456670476791,
        0.13818562874703627,
        0.022694883000443075,
        0.034070414558183104,
        0.17278405005245606,
        0.14793144821410487,
        0.15720165669072517,
        0.03019716125383405,
        -0.022939904672374417,
        0.18218724567821637,
        -0.22127976163106342,
        -0.0272666040146054,
        0.10940324645910479,
        -0.022939904672374417,
        0.2187464430275592,
        0.14904929250191346,
        0.034070414558183104,
        0.06359867877630405,
        0.1875774942569135,
        0.05358833122647312,
        0.011990149382231315,
        0.14651632739212217,
        -0.01076857664967893,
        0.10212688053130412,
        0.14904929250191346,
        0.017904545323112905,
        0.0354855353801658,
        0.17730609306361222,
        0.07401373713516587,
        0.0354855353801658,
        0.17730609306361222,
        0.1331380040096474,
        0.1376600470208036,
        -0.3440379786063058,
        0.06359867877630405,
        0.18218724567821637,
        0.06359867877630405,
        0.1079881256371221,
        0.14904929250191346,
        0.03253755595674977,
        0.1317228831876647,
        0.11310456670476791,
        0.14904929250191346,
        0.1376600470208036,
        0.06359867877630405,
        0.14904929250191346,
        0.1331380040096474,
        0.17278405005245606,
        0.03253755595674977,
        -0.06334279001654182,
        0.14904929250191346,
        0.10940324645910479,
        -0.022939904672374417,
        0.11310456670476791,
        0.10212688053130412,
        0.1079881256371221,
        0.12165690062809299,
        0.17730609306361222,
        0.17278405005245606,
        0.10940324645910479,
        0.10858252369361174,
        -0.15421803043366322,
        0.17278405005245606,
        0.14904929250191346,
        0.06426791766809728,
        0.17730609306361222,
        0.17278405005245606,
        0.10940324645910479,
        0.1778316747898449,
        0.1376600470208036,
        0.1331380040096474,
        -0.013219746751645639,
        0.1376600470208036,
        0.18218724567821637,
        0.10940324645910479,
        0.5176461277573442,
        0.17730609306361222,
        0.17278405005245606,
        0.14904929250191346,
        0.10175526548930205,
        0.0354855353801658,
        0.07479148673271584,
        0.17278405005245606,
        0.0765453693554251,
        0.1317228831876647,
        0.17730609306361222,
        0.14904929250191346,
        0.0765453693554251,
        0.08562548556465976,
        0.17278405005245606,
        0.006640351443728543,
        0.003009291738628822,
        0.015741792966016938,
        0.004424412560611518,
        0.10940324645910479,
        0.17278405005245606,
        0.0354855353801658,
        -0.06334279001654182,
        0.2187464430275592,
        0.1376600470208036,
        0.14904929250191346,
        0.003009291738628822,
        0.05358833122647312,
        0.17730609306361222,
        -0.004874038739838382,
        0.25160482278551577,
        0.09014752857581594,
        0.18218724567821637,
        -0.05321580042560864,
        -0.06334279001654182,
        0.23225130266839394,
        0.05358833122647312,
        0.14651632739212217,
        0.17730609306361222,
        0.003009291738628822,
        0.17730609306361222,
        0.003009291738628822,
        0.2036771106633271,
        -0.015918450562252565,
        0.1778316747898449,
        0.10858252369361174,
        0.0765453693554251,
        0.1875774942569135,
        0.09606934606117476,
        0.10940324645910479,
        -0.061076632561932756,
        0.14904929250191346,
        0.17278405005245606,
        0.2187464430275592,
        0.10940324645910479,
        0.1153574247096929,
        0.17278405005245606,
        0.05358833122647312,
        0.0354855353801658,
        0.1079881256371221,
        0.17278405005245606,
        0.1778316747898449,
        0.0765453693554251,
        0.17730609306361222,
        0.14793144821410487,
        0.0354855353801658,
        0.09606934606117476,
        0.046499601231707335,
        0.14904929250191346,
        0.13818562874703627,
        0.06359867877630405,
        0.17730609306361222,
        0.21422440001640303,
        -0.035978472783555884,
        0.03253755595674977,
        -0.010648537264443682,
        0.14904929250191346,
        0.17730609306361222,
        0.06359867877630405,
        0.03253755595674977,
        0.1079881256371221,
        0.06359867877630405,
        0.03449833614029671,
        0.17278405005245606,
        0.08235059921968871,
        0.1875774942569135,
        0.14904929250191346,
        0.10290463012885409,
        0.04541856801053594,
        0.07879822736035008,
        0.03918240465157183,
        0.14904929250191346,
        0.10940324645910479,
        0.17730609306361222,
        -0.06334279001654182,
        0.1079881256371221,
        0.09238106106423553,
        0.13831446283864487,
        0.05358833122647312,
        0.005173238723763837,
        0.10940324645910479,
        0.10940324645910479,
        0.033610851790998465,
        0.2663982669899732,
        0.14904929250191346,
        0.14904929250191346,
        0.14651632739212217,
        0.06359867877630405,
        0.13677050792505357,
        0.03253755595674977,
        0.11310456670476791,
        0.1785656651538821,
        -0.06334279001654182,
        0.11310456670476791,
        0.04541856801053594,
        0.10940324645910479,
        0.22901784422086047,
        0.1317228831876647,
        0.13831446283864487,
        0.0765453693554251,
        0.1601306700360863,
        0.17278405005245606,
        0.14904929250191346,
        0.09606934606117476,
        0.14793144821410487,
        0.06359867877630405,
        0.06285279684611458,
        -0.013006872042004278,
        0.17278405005245606,
        0.06359867877630405,
        0.0894244973663527,
        0.03253755595674977,
        0.17730609306361222,
        0.0765453693554251,
        0.09014752857581594,
        0.1331380040096474,
        0.07337636591073314,
        0.1331380040096474,
        0.14904929250191346,
        0.14904929250191346,
        0.17730609306361222,
        0.08562548556465976,
        -0.013219746751645639,
        0.005173238723763837,
        0.06206018013336677,
        0.17278405005245606,
        0.07401373713516587,
        0.17730609306361222,
        0.10175526548930205,
        -0.013219746751645639,
        0.10940324645910479,
        0.1331380040096474,
        -0.022939904672374417,
        0.18218724567821637,
        0.10858252369361174,
        0.10212688053130412,
        0.034070414558183104,
        0.2187464430275592,
        0.0765453693554251,
        0.03253755595674977,
        0.0354855353801658,
        -0.022939904672374417,
        0.003009291738628822,
        0.18218724567821637,
        0.06359867877630405,
        0.17278405005245606,
        -0.035978472783555884,
        0.17730609306361222,
        -0.038132893882664866,
        0.1014405943058651,
        0.14904929250191346,
        0.0354855353801658,
        0.21422440001640303,
        0.05358833122647312,
        -0.04130221524883814,
        0.06206018013336677,
        0.04601768871925116,
        0.05080802639658133,
        0.1376600470208036,
        0.06359867877630405,
        0.1376600470208036,
        0.10175526548930205,
        0.0354855353801658,
        0.17730609306361222,
        0.17730609306361222,
        0.17730609306361222,
        0.17730609306361222,
        0.14904929250191346,
        0.1079881256371221,
        0.03449833614029671,
        0.17278405005245606,
        0.18218724567821637,
        0.06426791766809728,
        0.10858252369361174,
        0.10940324645910479,
        0.10940324645910479,
        0.0765453693554251,
        0.017904545323112905,
        0.17730609306361222,
        0.10290463012885409,
        0.06359867877630405,
        0.13818562874703627,
        0.17730609306361222,
        0.17730609306361222,
        0.14904929250191346,
        0.003009291738628822,
        0.13379241982748868,
        0.005173238723763837,
        -0.061076632561932756,
        0.1376600470208036,
        0.034070414558183104,
        0.10175526548930205,
        0.13379241982748868,
        0.25068783752924445,
        0.23225130266839394,
        0.005173238723763837,
        0.0354855353801658,
        0.17730609306361222,
        0.0354855353801658,
        0.0765453693554251,
        0.09238106106423553,
        0.17278405005245606,
    ]
