# coding: utf-8

"""
    Cythereal MAGIC API

     The API for accessing Cythereal MAGIC products and services.  # API Clients  We provide clients in several languages for accessing the MAGIC API. https://bitbucket.org/cythereal/magic-clients  These clients are provided to make integration of the MAGIC API into your existing applications as easy as possible.  If you want to use a language that is not currently supported, please contact us at support@cythereal.com and we will be glad to help.  # Example Inputs  Here are some example inputs that can be used for testing the service:  * Binary SHA1: `ff9790d7902fea4c910b182f6e0b00221a40d616`   * Can be used for `file_hash` parameters. * Procedure RVA: `0x1000`   * Use with the above SHA1 for `proc_rva` parameters.   # API Conventions  Properties MUST be named using `snake_case`.  This API is inspired by the [google json style guide](https://google.github.io/styleguide/jsoncstyleguide.xml). Any questions about conventions not documented here should be addressed by this style guide.  **All responses** MUST be of type `APIResponse` and contain the following fields:  * `api_version` |  The current api version * `success` | Boolean value indicating if the operation succeeded. * `code` | Status code. Typically corresponds to the HTTP status code.  * `message` | A human readable message providing more details about the operation. Can be null or empty.  **Successful operations** MUST return a `SuccessResponse`, which extends `APIResponse` by adding:  * `data` | Properties containing the response object. * `success` | MUST equal True  When returning objects from a successful response, the `data` object SHOULD contain a property named after the requested object type. For example, the `/matches` endpoint should return a response object with `data.matches`. This property SHOULD  contain a list of the returned objects. For the `/matches` endpoint, the `data.matches` property contains a list of MagicMatch objects. See the `/matches` endpoint documentation for an example.  **Failed Operations** MUST return an `ErrorResponse`, which extends `APIResponse` by adding:  * `errors` | Array of error objects. An error object contains the following properties:     * `ErrorObject.reason` | Unique identifier for this error. Example: \"FileNotFoundError\".     * `ErrorObject.message`| Human readable error message. * `success` | MUST equal False.   # noqa: E501

    OpenAPI spec version: 1
    Contact: support@cythereal.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class MagicMatchesMatches(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'sha1': 'str',
        'is_public': 'bool',
        'tags': 'list[str]',
        'match_type': 'str',
        'match_subtypes': 'list[MagicMatchesMatchSubtypes]',
        'max_similarity': 'float'
    }

    attribute_map = {
        'sha1': 'sha1',
        'is_public': 'is_public',
        'tags': 'tags',
        'match_type': 'match_type',
        'match_subtypes': 'match_subtypes',
        'max_similarity': 'max_similarity'
    }

    def __init__(self, sha1=None, is_public=None, tags=None, match_type=None, match_subtypes=None, max_similarity=None):  # noqa: E501
        """MagicMatchesMatches - a model defined in Swagger"""  # noqa: E501

        self._sha1 = None
        self._is_public = None
        self._tags = None
        self._match_type = None
        self._match_subtypes = None
        self._max_similarity = None
        self.discriminator = None

        if sha1 is not None:
            self.sha1 = sha1
        if is_public is not None:
            self.is_public = is_public
        if tags is not None:
            self.tags = tags
        if match_type is not None:
            self.match_type = match_type
        if match_subtypes is not None:
            self.match_subtypes = match_subtypes
        if max_similarity is not None:
            self.max_similarity = max_similarity

    @property
    def sha1(self):
        """Gets the sha1 of this MagicMatchesMatches.  # noqa: E501

        The SHA1 of the matched binary.  # noqa: E501

        :return: The sha1 of this MagicMatchesMatches.  # noqa: E501
        :rtype: str
        """
        return self._sha1

    @sha1.setter
    def sha1(self, sha1):
        """Sets the sha1 of this MagicMatchesMatches.

        The SHA1 of the matched binary.  # noqa: E501

        :param sha1: The sha1 of this MagicMatchesMatches.  # noqa: E501
        :type: str
        """

        self._sha1 = sha1

    @property
    def is_public(self):
        """Gets the is_public of this MagicMatchesMatches.  # noqa: E501

        States whether this matched binary is public  # noqa: E501

        :return: The is_public of this MagicMatchesMatches.  # noqa: E501
        :rtype: bool
        """
        return self._is_public

    @is_public.setter
    def is_public(self, is_public):
        """Sets the is_public of this MagicMatchesMatches.

        States whether this matched binary is public  # noqa: E501

        :param is_public: The is_public of this MagicMatchesMatches.  # noqa: E501
        :type: bool
        """

        self._is_public = is_public

    @property
    def tags(self):
        """Gets the tags of this MagicMatchesMatches.  # noqa: E501


        :return: The tags of this MagicMatchesMatches.  # noqa: E501
        :rtype: list[str]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """Sets the tags of this MagicMatchesMatches.


        :param tags: The tags of this MagicMatchesMatches.  # noqa: E501
        :type: list[str]
        """

        self._tags = tags

    @property
    def match_type(self):
        """Gets the match_type of this MagicMatchesMatches.  # noqa: E501

        The MAGIC classification for the match.  # noqa: E501

        :return: The match_type of this MagicMatchesMatches.  # noqa: E501
        :rtype: str
        """
        return self._match_type

    @match_type.setter
    def match_type(self, match_type):
        """Sets the match_type of this MagicMatchesMatches.

        The MAGIC classification for the match.  # noqa: E501

        :param match_type: The match_type of this MagicMatchesMatches.  # noqa: E501
        :type: str
        """
        allowed_values = ["similar_packer_similar_payload", "similar_packer_different_payload", "different_packer_similar_payload", "weak_similar"]  # noqa: E501
        if match_type not in allowed_values:
            raise ValueError(
                "Invalid value for `match_type` ({0}), must be one of {1}"  # noqa: E501
                .format(match_type, allowed_values)
            )

        self._match_type = match_type

    @property
    def match_subtypes(self):
        """Gets the match_subtypes of this MagicMatchesMatches.  # noqa: E501

        Finer grained identification of match types.  # noqa: E501

        :return: The match_subtypes of this MagicMatchesMatches.  # noqa: E501
        :rtype: list[MagicMatchesMatchSubtypes]
        """
        return self._match_subtypes

    @match_subtypes.setter
    def match_subtypes(self, match_subtypes):
        """Sets the match_subtypes of this MagicMatchesMatches.

        Finer grained identification of match types.  # noqa: E501

        :param match_subtypes: The match_subtypes of this MagicMatchesMatches.  # noqa: E501
        :type: list[MagicMatchesMatchSubtypes]
        """

        self._match_subtypes = match_subtypes

    @property
    def max_similarity(self):
        """Gets the max_similarity of this MagicMatchesMatches.  # noqa: E501

        The maximum similarity value from `match_subtypes`.  # noqa: E501

        :return: The max_similarity of this MagicMatchesMatches.  # noqa: E501
        :rtype: float
        """
        return self._max_similarity

    @max_similarity.setter
    def max_similarity(self, max_similarity):
        """Sets the max_similarity of this MagicMatchesMatches.

        The maximum similarity value from `match_subtypes`.  # noqa: E501

        :param max_similarity: The max_similarity of this MagicMatchesMatches.  # noqa: E501
        :type: float
        """

        self._max_similarity = max_similarity

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(MagicMatchesMatches, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MagicMatchesMatches):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
