# PyAutoConf Code of Conduct

**Table of Contents**

- [The Short Version](#the-short-version)
- [The Longer Version](#the-longer-version)
  - [PyAutoConf Diversity Statement](#project-diversity-statement)
  - [PyAutoConf Code of Conduct: Introduction & Scope](#project-code-of-conduct-introduction--scope)
  - [Standards for Behavior](#standards-for-behavior)
    - [Unacceptable Behavior](#unacceptable-behavior)
  - [Reporting Guidelines](#reporting-guidelines)
    - [How to Submit a Report](#how-to-submit-a-report)
    - [Person(s) Responsible for Resolving Complaints](#persons-responsible-for-resolving-complaints)
    - [Conflicts of Interest](#conflicts-of-interest)
    - [What to Include in a Report](#what-to-include-in-a-report)
  - [Enforcement: What Happens After a Report is Filed?](#enforcement-what-happens-after-a-report-is-filed)
    - [Acknowledgment and Responding to Immediate Needs](#acknowledgment-and-responding-to-immediate-needs)
    - [Reviewing the Report](#reviewing-the-report)
    - [Contacting the Person Reported](#contacting-the-person-reported)
    - [Response and Potential Consequences](#response-and-potential-consequences)
    - [Appealing a Decision](#appealing-a-decision)
  - [Timeline Summary:](#timeline-summary)
    - [Confirming Receipt](#confirming-receipt)
    - [Reviewing the Report](#reviewing-the-report-1)
    - [Consequences & Resolution](#consequences--resolution)
- [License](#license)

## The Short Version

Be kind to others. Do not insult or put down others. Behave professionally. Remember that harassment and sexist, 
racist, or exclusionary jokes are not appropriate for PyAutoConf.

All communication should be appropriate for a professional audience including people of many different backgrounds. 
Sexual language and imagery is not appropriate.

PyAutoConf is dedicated to providing a harassment-free community for everyone, regardless of gender, sexual orientation, 
gender identity and expression, disability, physical appearance, body size, race, or religion. We do not tolerate 
harassment of community members in any form.

Thank you for helping make this a welcoming, friendly community for all.

## The Longer Version

### PyAutoConf Diversity Statement

PyAutoConf welcomes and encourages participation in our community by people of all backgrounds and identities. We 
are committed to promoting and sustaining a culture that values mutual respect, tolerance, and learning, and we work 
together as a community to help each other live out these values.

We have created this diversity statement because we believe that a diverse community is stronger, more vibrant, 
and produces better software and better science. A diverse community where people treat each other with respect has 
more potential contributors, more sources for ideas, and fewer shared assumptions that might hinder development 
or research.

Although we have phrased the formal diversity statement generically to make it all-inclusive, we recognize that there 
are specific identities that are impacted by systemic discrimination and marginalization. We welcome all people to 
participate in the PyAutoConf community regardless of their identity or background.

### PyAutoConf Code of Conduct: Introduction & Scope

This code of conduct should be honored by everyone who participates in the PyAutoConf community. It should be 
honored in any PyAutoConf-related activities, by anyone claiming affiliation with PyAutoConf, and especially when 
someone is representing PyAutoConf in any role (including as an event volunteer or speaker).

This code of conduct applies to all spaces managed by PyAutoConf, including all public and private mailing lists, 
issue trackers, wikis, forums, and any other communication channel used by our community. The code of conduct equally 
applies at PyAutoConf events and governs standards of behavior for attendees, speakers, volunteers, booth staff, 
and event sponsors.

This code is not exhaustive or complete. It serves to distill our understanding of a collaborative, inclusive 
community culture. Please try to follow this code in spirit as much as in letter, to create a friendly and 
productive environment that enriches the PyAutoConf community.

The PyAutoConf Code of Conduct follows below.

### Standards for Behavior

PyAutoConf is a worldwide community. All communication should be appropriate for a professional audience including 
people of many different backgrounds.

**Please always be kind and courteous. There's never a need to be mean or rude or disrespectful.** Thank you for 
helping make this a welcoming, friendly community for all.

We strive to:

**Be empathetic, welcoming, friendly, and patient.** We remember that PyAutoConf is crafted by human beings who 
deserve to be treated with kindness and empathy. We work together to resolve conflict and assume good intentions. 
We may all experience some frustration from time to time, but we do not allow frustration to turn into a personal 
attack. A community where people feel uncomfortable or threatened is not a productive one.

**Be collaborative.** Our work depends on the participation of many people, and in turn others depend on our work. 
Open source communities depend on effective and friendly collaboration to achieve their goals.

**Be inquisitive.** Nobody knows everything! Asking questions early avoids many problems later, so we encourage 
questions, although we may direct them to the appropriate forum. We will try hard to be responsive and helpful.

**Be careful in the words that we choose.** We are careful and respectful in our communication and we take 
responsibility for our own speech. Be kind to others. Do not insult or put down other members of the community.

#### Unacceptable Behavior

We are committed to making participation in this community a harassment-free experience.

We will not accept harassment or other exclusionary behaviours, such as:

- The use of sexualized language or imagery
- Excessive profanity (please avoid curse words; people differ greatly in their sensitivity to swearing)
- Posting sexually explicit or violent material
- Violent or intimidating threats or language directed against another person
- Inappropriate physical contact and/or unwelcome sexual attention or sexual comments
- Sexist, racist, or otherwise discriminatory jokes and language
- Trolling or insulting and derogatory comments
- Written or verbal comments which have the effect of excluding people on the basis of membership in a specific group, 
including level of experience, gender, gender identity and expression, sexual orientation, disability, neurotype, 
personal appearance, body size, race, ethnicity, age, religion, or nationality
- Public or private harassment
- Sharing private content, such as emails sent privately or non-publicly, or direct message history, without the 
sender's consent
- Continuing to initiate interaction (such as photography, recording, messaging, or conversation) with someone after 
being asked to stop
- Sustained disruption of talks, events, or communications, such as heckling of a speaker
- Publishing (or threatening to post) other people's personally identifying information ("doxing"), such as 
physical or electronic addresses, without explicit permission
- Other unethical or unprofessional conduct
- Advocating for, or encouraging, any of the above behaviors

### Reporting Guidelines

If you believe someone is violating the code of conduct, please report this in a timely manner. Code of conduct 
violations reduce the value of the community for everyone. The PyAutoConf leadership team takes reports of misconduct 
very seriously and is committed to preserving and maintaining the welcoming nature of our community.

**All reports will be kept confidential.**

In some cases we may determine that a public statement will need to be made. If that's the case, the identities of 
all involved parties and reporters will remain confidential unless those individuals instruct us otherwise.

All complaints will be reviewed and investigated and will result in a response that is deemed necessary and 
appropriate to the circumstances.  The PyAutoConf team commits to maintaining confidentiality with regard to the 
reporter of an incident.

For possibly unintentional breaches of the code of conduct, you may want to respond to the person and point out 
this code of conduct (either in public or in private, whatever is most appropriate). If you would prefer not to do 
that, please report the issue to PyAutoConf directly, or ask James Nightingale for advice in confidence. Complete contact 
information is below, under "How to Submit a Report."

Take care of each other. Alert PyAutoConf if you notice a dangerous situation, someone in distress, or violations of 
this code of conduct, even if they seem inconsequential.

#### How to Submit a Report

**If you feel your safety is in jeopardy or the situation is an emergency, we urge you to contact local law enforcement before making a report to PyAutoConf.** (In the U.K., dial 999.)

PyAutoConf is committed to promptly addressing any reported issues. If you have experienced or witnessed behavior that 
violates the PyAutoConf Code of Conduct, please report it by sending an email to one of the members of the PyAutoConf 
CoC Enforcement Team.

#### Person(s) Responsible for Resolving Complaints

All reports of breaches of the code of conduct will be investigated and handled by the **PyAutoConf Code of Conduct Enforcement Team**.

The current PyAutoConf Code of Conduct Enforcement Team consists of:

-   James Nightingale

    -   [*james.w.nightingale@durham.ac.uk*](mailto:james.w.nightingale@durham.ac.uk)
    
#### Conflicts of Interest

In the event of any conflict of interest, the team member will immediately notify the PyAutoConf Code of Conduct 
Enforcement Team and recuse themselves if necessary.

#### What to Include in a Report

Our ability to address any code of conduct breaches in a timely and effective manner is impacted by the amount of 
information you can provide, so, **our reporting form asks you to include as much of the following information as you can**:

- **Your contact info** (so we can get in touch with you if we need to follow up). This will be kept confidential. 
If you wish to remain anonymous, your information will not be shared beyond the person receiving the initial report.
- The **approximate time and location of the incident** (please be as specific as possible)
- **Identifying information** (e.g. name, nickname, screen name, physical description) of the individual whose 
behavior is being reported
- **Description of the behavior** (if reporting harassing language, please be specific about the words 
used), **your account of what happened**, and any available **supporting records** (e.g. email, GitHub issue, screenshots, etc.)
- **Description of the circumstances/context** surrounding the incident
- Let us know **if the incident is ongoing**, and/or if this is part of an ongoing pattern of behavior
- Names and contact info, if possible, of **anyone else who witnessed** or was involved in this incident. (Did 
anyone else observe the incident?)
- **Any other relevant information** you believe we should have

At PyAutoConf Events: Event staff will attempt to gather and write down the above information from anyone making a 
verbal report in-person at an event. Recording the details in writing is exceedingly important in order for us to 
effectively respond to reports. If event staff write down a report taken verbally, then the person making the 
report will be asked to review the written report for accuracy.

**If urgent action is needed regarding an incident at an in-person event, we strongly encourage you to reach out to the local event staff for immediate assistance.**

### Enforcement: What Happens After a Report is Filed?

What happens after a report is filed?

#### Acknowledgment and Responding to Immediate Needs

PyAutoConf and/or our event staff will attempt to ensure your safety and help with any immediate needs, particularly 
at an in-person event.  PyAutoConf will make every effort to **acknowledge receipt within 24 hours** (and we'll aim 
for much more quickly than that).

<!-- PROJECT SHOULD REVIEW THE RESPONSE SCHEDULE LISTED ABOVE AND BELOW, AND DETERMINE WHETHER IT IS REALISTIC FOR THE PROJECT. -->

#### Reviewing the Report

PyAutoConf will make all efforts to **review the incident within three days** and determine:

- Whether this is an ongoing situation, or if there is a threat to anyone's physical safety
- What happened
- Whether this event constitutes a code of conduct violation
- Who the bad actor was, if any

#### Contacting the Person Reported

After PyAutoConf has had time to review and discuss the report, someone will attempt to contact the person who is the 
subject of the report to inform them of what has been reported about them. We will then ask that person for their 
account of what happened.

#### Response and Potential Consequences

Once PyAutoConf has completed our investigation of the report, we will make a decision as to how to respond. The 
person making a report will not normally be consulted as to the proposed resolution of the issue, except insofar as 
we need to understand how to help them feel safe.

Potential consequences for violating the PyAutoConf code of conduct include:

- Nothing (if we determine that no violation occurred)
- Private feedback or reprimand from PyAutoConf to the individual(s) involved
- Warning the person to cease their behavior and that any further reports will result in sanctions
- A public announcement that an incident occurred
- Mediation (only if both reporter and reportee agree)
- An imposed vacation (e.g. asking someone to "take a week off" from a mailing list)
- A permanent or temporary ban from some or all PyAutoConf spaces (mailing lists, GitHub repos, in-person events, etc.)
- Assistance to the complainant with a report to other bodies, for example, institutional offices or appropriate law enforcement agencies
- Removing a person from PyAutoConf membership or other formal affiliation
- Publishing an account of the harassment and calling for the resignation of the alleged harasser from their 
responsibilities (usually pursued by people without formal authority: may be called for if the person is the 
event leader, or refuses to stand aside from the conflict of interest, or similar)
- Any other response that PyAutoConf deems necessary and appropriate to the situation

At PyAutoConf events, if a participant engages in behavior that violates this code of conduct, the conference 
organizers and staff may take any action they deem appropriate.

Potential consequences for violating the PyAutoConf Code of Conduct at an in-person event include:

- Warning the person to cease their behavior and that any further reports will result in sanctions
- Requiring that the person avoid any interaction with, and physical proximity to, the person they are harassing 
for the remainder of the event
- Ending a talk that violates the policy early
- Not publishing the video or slides of a talk that violated the policy
- Not allowing a speaker who violated the policy to give (further) talks at the event now or in the future
- Immediately ending any event volunteer responsibilities and privileges the reported person holds
- Requiring that the person not volunteer for future events PyAutoConf runs (either indefinitely or for a certain time period)
- Expelling the person from the event without a refund
- Requiring that the person immediately leave the event and not return
- Banning the person from future events (either indefinitely or for a certain time period)
- Any other response that PyAutoConf deems necessary and appropriate to the situation

No one espousing views or values contrary to the standards of our code of conduct will be permitted to hold any 
position representing PyAutoConf, including volunteer positions. PyAutoConf has the right and responsibility to 
remove, edit, or reject comments, commits, code, wiki edits, issues, and other contributions that are not 
aligned with this code of conduct.

We aim to **respond within one week** to the original reporter with either a resolution or an explanation of why the 
situation is not yet resolved.

We will contact the person who is the subject of the report to let them know what actions will be taken as a result of 
the report, if any.

Our policy is to make sure that everyone aware of the initial incident is also made aware that official action has 
been taken, while still respecting the privacy of individuals. PyAutoConf may choose to make a public report of the 
incident, while maintaining the anonymity of those involved.

#### Appealing a Decision

To appeal a decision of PyAutoConf, contact James Nightingale via email at
[*james.w.nightingale@durham.ac.uk*](mailto:james.w.nightingale@durham.ac.uk) with your appeal and
the Leadership Team will review the case.

### Timeline Summary:

#### Confirming Receipt

PyAutoConf will make every effort to acknowledge receipt of a report **within 24 hours** (and we'll aim for much more 
quickly than that).

#### Reviewing the Report

PyAutoConf will make all efforts to review the incident **within three days**.

#### Consequences & Resolution

We aim to respond **within one week** to the original reporter with either a resolution or an explanation of why 
the situation is not yet resolved.

## License

This code of conduct has been adapted from [*NUMFOCUS code of conduct*](https://github.com/numfocus/numfocus/blob/main/manual/numfocus-coc.md#the-short-version),
which is adapted from numerous sources, including the [*Geek Feminism wiki, created by the Ada Initiative and other volunteers, which is under a Creative Commons Zero license*](http://geekfeminism.wikia.com/wiki/Conference_anti-harassment/Policy), the [*Contributor Covenant version 1.2.0*](http://contributor-covenant.org/version/1/2/0/), the [*Bokeh Code of Conduct*](https://github.com/bokeh/bokeh/blob/main/CODE_OF_CONDUCT.md), the [*SciPy Code of Conduct*](https://github.com/jupyter/governance/blob/main/conduct/enforcement.md), the [*Carpentries Code of Conduct*](https://docs.carpentries.org/topic_folders/policies/code-of-conduct.html#enforcement-manual), and the [*NeurIPS Code of Conduct*](https://neurips.cc/public/CodeOfConduct).

**PyAutoConf Code of Conduct is licensed under the [Creative Commons Attribution 3.0 Unported License](https://creativecommons.org/licenses/by/3.0/).**