# coding: utf-8

"""
    3Di API

    3Di simulation API (latest stable version: v3)   Framework release: 3.0.8   3Di core release: 2.3.1  deployed on:  01:12PM (UTC) on November 15, 2022  # noqa: E501

    The version of the OpenAPI document: v3
    Contact: info@nelen-schuurmans.nl
    Generated by: https://openapi-generator.tech
"""


import logging
import pprint
import re  # noqa: F401

import six

from threedi_api_client.openapi.configuration import Configuration

logger = logging.getLogger(__name__)

class Action(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'name': 'str',
        'duration': 'int',
        'timeout': 'int',
        'max_rate': 'float',
        'compute_cluster': 'str'
    }

    attribute_map = {
        'name': 'name',
        'duration': 'duration',
        'timeout': 'timeout',
        'max_rate': 'max_rate',
        'compute_cluster': 'compute_cluster'
    }

    def __init__(self, name=None, duration=None, timeout=None, max_rate=None, compute_cluster=None, local_vars_configuration=None, fetched_from_api=False):  # noqa: E501
        """Action - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        # True if data is coming from API
        self._fetched_from_api = fetched_from_api

        self._name = None
        self._duration = None
        self._timeout = None
        self._max_rate = None
        self._compute_cluster = None
        self.discriminator = None

        self.name = name
        if duration is not None:
            self.duration = duration
        if timeout is not None:
            self.timeout = timeout
        if max_rate is not None:
            self.max_rate = max_rate
        if compute_cluster is not None:
            self.compute_cluster = compute_cluster

    @property
    def name(self):
        """Gets the name of this Action.  # noqa: E501


        :return: The name of this Action.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Action.


        :param name: The name of this Action.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            self.__handle_validation_error("Invalid value for `name`, must not be `None`")  # noqa: E501
        allowed_values = ["initialize", "start", "pause", "shutdown", "queue"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and name not in allowed_values:  # noqa: E501
            self.__handle_validation_error(
                "Invalid value for `name` ({0}), must be one of {1}"  # noqa: E501
                .format(name, allowed_values)
            )

        self._name = name

    @property
    def duration(self):
        """Gets the duration of this Action.  # noqa: E501

        Only valid for name='start'. Run simulation for given duration (in seconds) and pause  # noqa: E501

        :return: The duration of this Action.  # noqa: E501
        :rtype: int
        """
        return self._duration

    @duration.setter
    def duration(self, duration):
        """Sets the duration of this Action.

        Only valid for name='start'. Run simulation for given duration (in seconds) and pause  # noqa: E501

        :param duration: The duration of this Action.  # noqa: E501
        :type: int
        """
        if (self.local_vars_configuration.client_side_validation and
                duration is not None and duration < 1):  # noqa: E501
            self.__handle_validation_error("Invalid value for `duration`, must be a value greater than or equal to `1`")  # noqa: E501

        self._duration = duration

    @property
    def timeout(self):
        """Gets the timeout of this Action.  # noqa: E501

        Only valid for name='pause'. Remove simulation after given timeout (in seconds). Defaults to 300 seconds  # noqa: E501

        :return: The timeout of this Action.  # noqa: E501
        :rtype: int
        """
        return self._timeout

    @timeout.setter
    def timeout(self, timeout):
        """Sets the timeout of this Action.

        Only valid for name='pause'. Remove simulation after given timeout (in seconds). Defaults to 300 seconds  # noqa: E501

        :param timeout: The timeout of this Action.  # noqa: E501
        :type: int
        """
        if (self.local_vars_configuration.client_side_validation and
                timeout is not None and timeout < 30):  # noqa: E501
            self.__handle_validation_error("Invalid value for `timeout`, must be a value greater than or equal to `30`")  # noqa: E501

        self._timeout = timeout

    @property
    def max_rate(self):
        """Gets the max_rate of this Action.  # noqa: E501

        Only valid for name='start'. Limit maximum speed of the simulation. The max_rate is a multiplier relative to real time For example max_rate '60' means max 60 simulation seconds in 1 real second   # noqa: E501

        :return: The max_rate of this Action.  # noqa: E501
        :rtype: float
        """
        return self._max_rate

    @max_rate.setter
    def max_rate(self, max_rate):
        """Sets the max_rate of this Action.

        Only valid for name='start'. Limit maximum speed of the simulation. The max_rate is a multiplier relative to real time For example max_rate '60' means max 60 simulation seconds in 1 real second   # noqa: E501

        :param max_rate: The max_rate of this Action.  # noqa: E501
        :type: float
        """
        if (self.local_vars_configuration.client_side_validation and
                max_rate is not None and max_rate < 1):  # noqa: E501
            self.__handle_validation_error("Invalid value for `max_rate`, must be a value greater than or equal to `1`")  # noqa: E501

        self._max_rate = max_rate

    @property
    def compute_cluster(self):
        """Gets the compute_cluster of this Action.  # noqa: E501

        The name of the compute cluster that runs/has run the simulation.  # noqa: E501

        :return: The compute_cluster of this Action.  # noqa: E501
        :rtype: str
        """
        return self._compute_cluster

    @compute_cluster.setter
    def compute_cluster(self, compute_cluster):
        """Sets the compute_cluster of this Action.

        The name of the compute cluster that runs/has run the simulation.  # noqa: E501

        :param compute_cluster: The compute_cluster of this Action.  # noqa: E501
        :type: str
        """

        self._compute_cluster = compute_cluster

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def __handle_validation_error(self, message):
        # Only raise ValueError when not fetched from API
        from threedi_api_client import __version__ as VERSION

        if not self._fetched_from_api:
            raise ValueError(message + f" It is possible that the current threedi-api-client version ({VERSION}) is out of date: consult https://pypi.org/project/threedi-api-client/ and consider upgrading.")  # noqa: E501
        logger.warning(message + " Please update to the latest threedi-api-client version.")  # noqa: E501

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Action):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Action):
            return True

        return self.to_dict() != other.to_dict()
