"""Dockerignore Generator"""

import os

FILE_PATH = "{path}/.dockerignore"
DOCKERIGNORE = """
# This dockerignore was generated by Skelebot
# Editing this file manually is not advised as all changes will be overwritten by Skelebot

"""


def buildDockerignore(config):
    """Builds the .dockerignore file based on values from the Config object"""

    docker = DOCKERIGNORE

    # Add the base level ignores for the project defined in the yaml
    for ignore in config.ignores:
        docker += "{ignore}\n".format(ignore=ignore)

    # Pull in any additional dockerignore updates from the components
    for component in config.components:
        docker += component.appendDockerignore()

    dockerignore = open(FILE_PATH.format(path=os.getcwd()), "w")
    dockerignore.write(docker)
    dockerignore.close()
