import __builtin__ as builtins

class Object:
    def clone(self): ...
    def equals(self, obj) -> None: ...
    def getClass(self) -> None: ...
    def hashCode(self) -> None: ...
    def notify(self) -> None: ...
    def notifyAll(self) -> None: ...
    def toString(self): ...
    def wait(self, timeoutMillis: long = ..., nanos: int = ...) -> None: ...

class Class(Object):
    def asSubClass(self, clazz) -> None: ...
    def cast(self, obj) -> None: ...

class Enum(Object):
    def compareTo(self, o) -> None: ...
    def getDeclaringClass(self) -> None: ...
    def name(self) -> None: ...
    def ordinal(self) -> None: ...
    def valueOf(self, enumType, name) -> None: ...

class Iterable:
    def __iter__(self): ...
    def forEach(self, action) -> None: ...
    def iterator(self) -> None: ...
    def spliterator(self) -> None: ...

class StackTraceElement(Object):
    def __init__(self, *args) -> None: ...
    def getClassLoaderName(self) -> str: ...
    def getClassName(self) -> str: ...
    def getFileName(self) -> str: ...
    def getLineNumber(self) -> int: ...
    def getMethodName(self) -> str: ...
    def getModuleName(self) -> str: ...
    def getModuleVersion(self) -> str: ...
    def isNativeMethod(self) -> bool: ...

class Throwable(Object, builtins.Exception):
    def __init__(self, message: str = ..., cause: Throwable = ...) -> None: ...
    @property
    def cause(self) -> Throwable: ...
    def addSuppressed(self, exception: Throwable) -> None: ...
    def fillInStackTrace(self) -> Throwable: ...
    def getCause(self) -> Throwable: ...
    def getLocalizedMessage(self) -> str: ...
    def getMessage(self) -> str: ...
    def getStackTrace(self) -> None: ...
    def getSuppressed(self) -> None: ...
    def initCause(self, cause: Throwable = ...) -> None: ...
    @property
    def message(self) -> str: ...
    def printStackTrace(self, *args) -> None: ...
    def setStackTrace(self, stackTrace) -> None: ...
    def toString(self): ...

class Exception(Throwable):
    def __init__(self, message: str = ..., cause: Throwable = ...) -> None: ...

class RuntimeException(Exception):
    def __init__(self, message: str = ..., cause: Throwable = ...) -> None: ...

class IllegalArgumentException(RuntimeException):
    def __init__(self, message: str = ..., cause: Throwable = ...) -> None: ...

class NullPointerException(RuntimeException):
    def __init__(self, message: str = ..., cause: Throwable = ...) -> None: ...

class Thread(Object):
    @staticmethod
    def sleep(millis) -> None: ...
