import * as cdk from '@aws-cdk/core';
/**
 * @stability stable
 */
export interface SSMParameterProps {
    /**
     * @stability stable
     */
    readonly parameterName: string;
    /**
     * if the parameter couldn't be found that will be the default value.
     *
     * @stability stable
     */
    readonly defaultValue?: string;
    /**
     * The SSM Parameter type.
     *
     * SecureString is atm not supported
     *
     * @stability stable
     */
    readonly type?: SSMParameterType;
    /**
     * Optional parameter for deleting the SSM Parameter if the stack gets deleted.
     *
     * @default false
     * @stability stable
     */
    readonly delete?: boolean;
}
/**
 * The SSM Parameter type.
 *
 * SecureString is atm not supported
 *
 * @stability stable
 */
export declare enum SSMParameterType {
    /**
     * @stability stable
     */
    STRING = "String",
    /**
     * @stability stable
     */
    STRING_LIST = "StringList"
}
/**
 * @stability stable
 */
export declare class SSMParameter extends cdk.Construct {
    /**
     * the returned parameter for the SSM Parameter.
     *
     * @stability stable
     */
    readonly parameterValue: string;
    /**
     * @stability stable
     */
    readonly parameterName: string;
    /**
     * @stability stable
     */
    constructor(parent: cdk.Stack, name: string, props: SSMParameterProps);
}
