/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.support.management;

import ibis.io.Conversion;
import ibis.ipl.IbisIdentifier;
import ibis.ipl.server.ManagementServiceInterface;
import ibis.ipl.server.Service;
import ibis.ipl.support.Connection;
import ibis.ipl.support.management.AttributeDescription;
import ibis.smartsockets.virtual.VirtualSocketFactory;
import ibis.util.TypedProperties;
import java.io.IOException;

public class ManagementService
implements Service,
ManagementServiceInterface {
    private static final int CONNECT_TIMEOUT = 10000;
    private final VirtualSocketFactory factory;

    public ManagementService(TypedProperties properties, VirtualSocketFactory factory) {
        this.factory = factory;
    }

    @Override
    public void end(long deadline) {
    }

    @Override
    public String getServiceName() {
        return "management";
    }

    @Override
    public Object[] getAttributes(IbisIdentifier ibis, AttributeDescription ... descriptions) throws IOException {
        Object[] reply;
        ibis.ipl.impl.IbisIdentifier identifier;
        try {
            identifier = (ibis.ipl.impl.IbisIdentifier)ibis;
        }
        catch (ClassCastException e) {
            throw new IOException("cannot cast given identifier to implementation identifier: " + e);
        }
        Connection connection = new Connection(identifier, 10000, false, this.factory, 304);
        connection.out().writeByte(55);
        connection.out().writeByte(0);
        connection.out().writeInt(descriptions.length);
        for (int i = 0; i < descriptions.length; ++i) {
            connection.out().writeUTF(descriptions[i].getBeanName());
            connection.out().writeUTF(descriptions[i].getAttribute());
        }
        connection.getAndCheckReply();
        int length = connection.in().readInt();
        if (length < 0) {
            connection.close();
            throw new IOException("End of Stream on reading from connection");
        }
        byte[] resultBytes = new byte[length];
        connection.in().readFully(resultBytes);
        try {
            reply = (Object[])Conversion.byte2object((byte[])resultBytes);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Cannot cast result " + e);
        }
        connection.close();
        return reply;
    }

    public String toString() {
        return "Management service on virtual port 304";
    }
}

