/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.support.management;

import ibis.ipl.IbisIdentifier;
import ibis.ipl.server.Server;
import ibis.ipl.support.management.AttributeDescription;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;

public class Example {
    public static void main(String[] arguments) {
        Server server = null;
        try {
            server = new Server(new Properties());
        }
        catch (Throwable t) {
            System.err.println("Could not start Server: " + t);
            System.exit(1);
        }
        System.err.println(server.toString());
        try {
            Runtime.getRuntime().addShutdownHook(new Shutdown(server));
        }
        catch (Exception e) {
            System.err.println("warning: could not registry shutdown hook");
        }
        AttributeDescription load = new AttributeDescription("java.lang:type=OperatingSystem", "SystemLoadAverage");
        AttributeDescription cpu = new AttributeDescription("java.lang:type=OperatingSystem", "ProcessCpuTime");
        AttributeDescription vivaldi = new AttributeDescription("ibis", "vivaldi");
        AttributeDescription connections = new AttributeDescription("ibis", "connections");
        AttributeDescription sentBytesPerIbis = new AttributeDescription("ibis", "sentBytesPerIbis");
        AttributeDescription receivedBytesPerIbis = new AttributeDescription("ibis", "receivedBytesPerIbis");
        AttributeDescription wonElections = new AttributeDescription("ibis", "wonElections");
        AttributeDescription senderConnectionTypes = new AttributeDescription("ibis", "senderConnectionTypes");
        AttributeDescription receiverConnectionTypes = new AttributeDescription("ibis", "receiverConnectionTypes");
        while (true) {
            ibis.ipl.impl.IbisIdentifier[] ibises;
            if ((ibises = server.getRegistryService().getMembers("test")) != null) {
                for (ibis.ipl.impl.IbisIdentifier ibis : ibises) {
                    try {
                        Map receiverConnections;
                        Map senderConnections;
                        String[] won;
                        Map received;
                        System.err.println(ibis + " [load, total cpu time, vivaldi coordinates] = " + Arrays.toString(server.getManagementService().getAttributes((IbisIdentifier)ibis, load, cpu, vivaldi)));
                        System.err.println(ibis + " connected to = " + Arrays.toString((IbisIdentifier[])server.getManagementService().getAttributes((IbisIdentifier)ibis, connections)[0]));
                        Map sent = (Map)server.getManagementService().getAttributes((IbisIdentifier)ibis, sentBytesPerIbis)[0];
                        if (sent != null) {
                            for (Map.Entry e : sent.entrySet()) {
                                System.err.println(ibis + " wrote " + e.getValue() + " bytes to " + e.getKey());
                            }
                        }
                        if ((received = (Map)server.getManagementService().getAttributes((IbisIdentifier)ibis, receivedBytesPerIbis)[0]) != null) {
                            for (Map.Entry e : received.entrySet()) {
                                System.err.println(ibis + " read " + e.getValue() + " bytes from " + e.getKey());
                            }
                        }
                        if ((won = (String[])server.getManagementService().getAttributes((IbisIdentifier)ibis, wonElections)[0]) != null) {
                            for (String s : won) {
                                System.err.println(ibis + " won election " + s);
                            }
                        }
                        if ((senderConnections = (Map)server.getManagementService().getAttributes((IbisIdentifier)ibis, senderConnectionTypes)[0]) != null) {
                            System.err.println("senderConnections: " + senderConnections.toString());
                        }
                        if ((receiverConnections = (Map)server.getManagementService().getAttributes((IbisIdentifier)ibis, receiverConnectionTypes)[0]) == null) continue;
                        System.err.println("receiverConnections: " + receiverConnections.toString());
                    }
                    catch (Exception e) {
                        System.err.println("Could not get management info: ");
                        e.printStackTrace();
                    }
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    private static class Shutdown
    extends Thread {
        private final Server server;

        Shutdown(Server server) {
            this.server = server;
        }

        @Override
        public void run() {
            this.server.end(-1L);
        }
    }
}

