/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.support;

import ibis.io.Conversion;
import ibis.io.IOProperties;
import ibis.ipl.impl.IbisIdentifier;
import ibis.ipl.support.CountInputStream;
import ibis.ipl.support.RemoteException;
import ibis.smartsockets.virtual.VirtualServerSocket;
import ibis.smartsockets.virtual.VirtualSocket;
import ibis.smartsockets.virtual.VirtualSocketAddress;
import ibis.smartsockets.virtual.VirtualSocketFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Connection {
    private static final Logger logger = LoggerFactory.getLogger(Connection.class);
    private final VirtualSocket socket;
    private final DataOutputStream out;
    private final DataInputStream in;
    private final CountInputStream counter;
    static final byte REPLY_ERROR = 2;
    static final byte REPLY_OK = 1;

    private static VirtualSocketAddress addressFromIdentifier(IbisIdentifier ibis, int virtualPort) throws IOException {
        VirtualSocketAddress registryAddress = VirtualSocketAddress.fromBytes((byte[])ibis.getRegistryData(), (int)0);
        if (registryAddress.port() == virtualPort) {
            return registryAddress;
        }
        return new VirtualSocketAddress(registryAddress.machine(), virtualPort, registryAddress.hub(), registryAddress.cluster());
    }

    public Connection(IbisIdentifier ibis, int timeout, boolean fillTimeout, VirtualSocketFactory factory, int virtualPort) throws IOException {
        this(Connection.addressFromIdentifier(ibis, virtualPort), timeout, fillTimeout, factory);
    }

    public Connection(VirtualSocketAddress address, int timeout, boolean fillTimeout, VirtualSocketFactory factory) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("connecting to " + address + ", timeout = " + timeout + " , filltimeout = " + fillTimeout);
        }
        HashMap lightConnection = new HashMap();
        this.socket = factory.createClientSocket(address, timeout, fillTimeout, lightConnection);
        this.socket.setTcpNoDelay(true);
        this.out = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream(), IOProperties.BUFFER_SIZE));
        this.counter = new CountInputStream(new BufferedInputStream(this.socket.getInputStream(), IOProperties.BUFFER_SIZE));
        this.in = new DataInputStream(this.counter);
        if (logger.isDebugEnabled()) {
            logger.debug("connection to " + address + " established");
        }
    }

    public Connection(VirtualServerSocket serverSocket) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("waiting for incoming connection...");
        }
        this.socket = serverSocket.accept();
        this.socket.setTcpNoDelay(true);
        this.counter = new CountInputStream(new BufferedInputStream(this.socket.getInputStream(), IOProperties.BUFFER_SIZE));
        this.in = new DataInputStream(this.counter);
        this.out = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream(), IOProperties.BUFFER_SIZE));
        if (logger.isDebugEnabled()) {
            logger.debug("new connection from " + this.socket.getRemoteSocketAddress() + " accepted");
        }
    }

    public DataOutputStream out() {
        return this.out;
    }

    public DataInputStream in() {
        return this.in;
    }

    public Object readObject() throws IOException, ClassNotFoundException {
        int size = this.in.readInt();
        if (size < 0) {
            throw new IOException("negative object size");
        }
        byte[] bytes = new byte[size];
        this.in.readFully(bytes);
        return Conversion.byte2object((byte[])bytes);
    }

    public void writeObject(Object object) throws IOException {
        byte[] bytes = Conversion.object2byte((Object)object);
        this.out.writeInt(bytes.length);
        this.out.write(bytes);
    }

    public int written() {
        return this.out.size();
    }

    public int read() {
        return this.counter.getCount();
    }

    public void getAndCheckReply() throws IOException {
        this.out.flush();
        byte reply = this.in.readByte();
        if (reply == 2) {
            String message = this.in.readUTF();
            this.close();
            throw new RemoteException(message);
        }
        if (reply != 1) {
            this.close();
            throw new IOException("Unknown reply (" + reply + ")");
        }
    }

    public void sendOKReply() throws IOException {
        this.out.writeByte(1);
        this.out.flush();
    }

    public void closeWithError(String message) {
        if (message == null) {
            message = "";
        }
        try {
            this.out.writeByte(2);
            this.out.writeUTF(message);
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void close() {
        try {
            this.out.flush();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.out.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.in.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

