/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.server;

import ibis.ipl.IbisConfigurationException;
import ibis.ipl.server.ManagementServiceConnection;
import ibis.ipl.server.ManagementServiceInterface;
import ibis.ipl.server.RegistryServiceConnection;
import ibis.ipl.server.RegistryServiceInterface;
import ibis.ipl.server.ServerInterface;
import ibis.ipl.server.ServerPipe;
import ibis.ipl.support.Connection;
import ibis.smartsockets.direct.DirectSocketAddress;
import ibis.smartsockets.hub.servicelink.ServiceLink;
import ibis.smartsockets.virtual.InitializationException;
import ibis.smartsockets.virtual.VirtualSocketAddress;
import ibis.smartsockets.virtual.VirtualSocketFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Properties;

public class ServerConnection
implements ServerInterface {
    public static final int TIMEOUT = 10000;
    private final ServerPipe pipe;
    private final VirtualSocketAddress address;
    private final ManagementServiceConnection managementConnection;
    private final RegistryServiceConnection registryConnection;
    private final VirtualSocketFactory socketFactory;

    private static VirtualSocketAddress createServerAddress(String serverString, int defaultPort) throws IOException {
        if (serverString == null) {
            throw new IbisConfigurationException("serverString undefined");
        }
        DirectSocketAddress address = null;
        try {
            address = DirectSocketAddress.getByAddress((String)serverString);
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (address == null) {
            try {
                address = DirectSocketAddress.getByAddress((String)serverString, (int)defaultPort);
            }
            catch (Throwable e) {
                throw new IOException("could not create server address from given string: " + serverString);
            }
        }
        return new VirtualSocketAddress(address, 300, address, null);
    }

    private static VirtualSocketFactory createSocketFactory(String hubs) throws IOException {
        VirtualSocketFactory result;
        Properties properties = new Properties();
        if (hubs != null) {
            properties.setProperty("smartsockets.hub.addresses", hubs);
        }
        try {
            result = VirtualSocketFactory.createSocketFactory((Properties)properties, (boolean)true);
        }
        catch (InitializationException e) {
            throw new IOException(e.getMessage());
        }
        try {
            ServiceLink sl = result.getServiceLink();
            if (sl != null) {
                sl.registerProperty("smartsockets.viz", "invisible");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }

    public ServerConnection(InputStream stdout, OutputStream stdin, PrintStream output, String outputPrefix, long timeout, VirtualSocketFactory socketFactory) throws IOException {
        this.pipe = new ServerPipe(stdout, stdin, output, outputPrefix);
        this.address = ServerConnection.createServerAddress(this.pipe.getAddress(timeout), 8888);
        this.socketFactory = socketFactory == null ? ServerConnection.createSocketFactory(null) : socketFactory;
        this.managementConnection = new ManagementServiceConnection(this.address, this.socketFactory);
        this.registryConnection = new RegistryServiceConnection(this.address, this.socketFactory);
    }

    public ServerConnection(String address, VirtualSocketFactory socketFactory) throws IOException {
        this.pipe = null;
        this.address = ServerConnection.createServerAddress(address, 8888);
        this.socketFactory = socketFactory == null ? ServerConnection.createSocketFactory(null) : socketFactory;
        this.managementConnection = new ManagementServiceConnection(this.address, this.socketFactory);
        this.registryConnection = new RegistryServiceConnection(this.address, this.socketFactory);
    }

    public ServerConnection(String address, String hubs) throws IOException {
        this.pipe = null;
        Properties properties = new Properties();
        properties.put("smartsockets.hub.addresses", hubs);
        this.socketFactory = ServerConnection.createSocketFactory(hubs);
        this.address = ServerConnection.createServerAddress(this.getAddress(), 8888);
        this.managementConnection = new ManagementServiceConnection(this.address, this.socketFactory);
        this.registryConnection = new RegistryServiceConnection(this.address, this.socketFactory);
    }

    @Override
    public String getAddress() throws IOException {
        return this.address.machine().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getServiceNames() throws IOException {
        Connection connection = new Connection(this.address, 10000, true, this.socketFactory);
        try {
            connection.out().writeByte(74);
            connection.out().writeByte(1);
            connection.getAndCheckReply();
            int nrOfServices = connection.in().readInt();
            if (nrOfServices < 0) {
                throw new IOException("Negative number of services");
            }
            String[] result = new String[nrOfServices];
            for (int i = 0; i < nrOfServices; ++i) {
                result[i] = connection.in().readUTF();
            }
            String[] stringArray = result;
            return stringArray;
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getHubs() throws IOException {
        Connection connection = new Connection(this.address, 10000, true, this.socketFactory);
        try {
            connection.out().writeByte(74);
            connection.out().writeByte(2);
            connection.getAndCheckReply();
            int nrOfHubs = connection.in().readInt();
            if (nrOfHubs < 0) {
                throw new IOException("Negative number of hubs");
            }
            String[] result = new String[nrOfHubs];
            for (int i = 0; i < nrOfHubs; ++i) {
                result[i] = connection.in().readUTF();
            }
            String[] stringArray = result;
            return stringArray;
        }
        finally {
            connection.close();
        }
    }

    @Override
    public void addHubs(DirectSocketAddress ... hubAddresses) throws IOException {
        String[] strings = new String[hubAddresses.length];
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = hubAddresses[i].toString();
        }
        this.addHubs(strings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addHubs(String ... hubAddresses) throws IOException {
        Connection connection = new Connection(this.address, 10000, true, this.socketFactory);
        try {
            connection.out().writeByte(74);
            connection.out().writeByte(3);
            connection.out().writeInt(hubAddresses.length);
            for (String hub : hubAddresses) {
                connection.out().writeUTF(hub);
            }
            connection.getAndCheckReply();
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end(long timeout) throws IOException {
        if (this.pipe != null) {
            this.pipe.end();
        } else {
            Connection connection = new Connection(this.address, 10000, true, this.socketFactory);
            try {
                connection.out().writeByte(74);
                connection.out().writeByte(4);
                connection.out().writeLong(timeout);
                connection.getAndCheckReply();
            }
            finally {
                connection.close();
            }
        }
    }

    @Override
    public RegistryServiceInterface getRegistryService() {
        return this.registryConnection;
    }

    @Override
    public ManagementServiceInterface getManagementService() {
        return this.managementConnection;
    }

    public void closeConnection() {
        if (this.pipe != null) {
            this.pipe.end();
        }
    }
}

