/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.registry.statistics;

import ibis.ipl.registry.statistics.Experiment;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticsProcessor {
    private static final Logger logger = LoggerFactory.getLogger(StatisticsProcessor.class);
    private final Experiment[] experiments;
    private final long interval;
    private final long duration;

    StatisticsProcessor(File[] directories, long interval) throws IOException {
        this.experiments = new Experiment[directories.length];
        long duration = 0L;
        for (int i = 0; i < this.experiments.length; ++i) {
            this.experiments[i] = new Experiment(directories[i]);
            if (this.experiments[i].duration() <= duration) continue;
            duration = this.experiments[i].duration();
        }
        this.duration = duration;
        this.interval = interval == 0L ? this.calculateInterval() : interval;
    }

    private long calculateInterval() {
        long result = this.duration / 100L;
        if (result < 1L) {
            result = 1L;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("interval = " + result);
        }
        return result;
    }

    private void writePoolHistory(Formatter out) {
        out.format("//experiments:\n", new Object[0]);
        out.format("//%6s |", "");
        for (Experiment experiment : this.experiments) {
            out.format("%-16s  |", experiment.getName());
        }
        out.format("\n", new Object[0]);
        for (long time = 0L; time <= this.duration + 2L * this.interval; time += this.interval) {
            out.format("%8.2f  ", (double)time / 1000.0);
            for (Experiment experiment : this.experiments) {
                out.format("%8.2f ", experiment.averagePoolSize(time));
                out.format("%8.2f  ", experiment.serverPoolSize(time));
            }
            out.format("\n", new Object[0]);
        }
        out.flush();
    }

    private void writeDataTransferSize(Formatter out) {
        out.format("experiments:\n", new Object[0]);
        for (Experiment experiment : this.experiments) {
            out.format("%s %.2f %.2f\n", experiment.getName(), experiment.serverTraffic(), experiment.averageClientTraffic());
        }
        out.flush();
    }

    private void writeServerStats(Formatter out) {
        for (Experiment experiment : this.experiments) {
            out.format("####### %s #######\n", experiment.getName());
            experiment.serverCommStats(out);
        }
    }

    public static void main(String[] args) throws IOException {
        ArrayList<File> directories = new ArrayList<File>();
        long interval = 0L;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("--interval")) {
                interval = Long.parseLong(args[++i]);
                continue;
            }
            if (args[i].startsWith("-")) {
                System.err.println("unknown option: " + args[i]);
                System.exit(1);
                continue;
            }
            directories.add(new File(args[i]));
        }
        if (directories.size() == 0) {
            System.err.println("usage: StatisticsProcessor [OPTIONS] DIRECTORY [DIRECTORY]...");
            System.err.println("options:");
            System.err.println("--interval INTERVAL Interval of datapoints in graphs (milliseconds)");
            System.exit(1);
        }
        StatisticsProcessor processor = new StatisticsProcessor(directories.toArray(new File[0]), interval);
        Formatter out = new Formatter("poolsize.statistics");
        processor.writePoolHistory(out);
        out.close();
        out = new Formatter("traffic.statistics");
        processor.writeDataTransferSize(out);
        out.close();
        out = new Formatter("server.statistics");
        processor.writeServerStats(out);
        out.close();
    }
}

