/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl.multi;

import ibis.ipl.Manageable;
import ibis.ipl.NoSuchPropertyException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;

public class ManageableMapper
implements Manageable {
    private final Map<String, Manageable> subMap;

    public ManageableMapper(Map<String, Manageable> subMap) {
        this.subMap = subMap;
    }

    public synchronized Map<String, String> managementProperties() {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        for (String ibisName : this.subMap.keySet()) {
            Manageable Manageable2 = this.subMap.get(ibisName);
            Map props = Manageable2.managementProperties();
            for (String key : props.keySet()) {
                String value = (String)props.get(key);
                if (propertyMap.containsKey(key)) {
                    value = propertyMap.get(key) + ", " + ibisName + ": " + value;
                }
                propertyMap.put(key, value);
            }
        }
        return propertyMap;
    }

    public synchronized String getManagementProperty(String key) throws NoSuchPropertyException {
        StringBuffer value = new StringBuffer();
        for (String ibisName : this.subMap.keySet()) {
            Manageable Manageable2 = this.subMap.get(ibisName);
            String ibisValue = Manageable2.getManagementProperty(key);
            if (null == ibisValue) continue;
            if (value.length() > 0) {
                value.append(", ");
            }
            value.append(ibisName);
            value.append(": ");
            value.append(ibisValue);
        }
        return value.toString();
    }

    public synchronized void setManagementProperties(Map<String, String> properties) throws NoSuchPropertyException {
        for (Manageable Manageable2 : this.subMap.values()) {
            Manageable2.setManagementProperties(properties);
        }
    }

    public synchronized void setManagementProperty(String key, String val) throws NoSuchPropertyException {
        for (Manageable Manageable2 : this.subMap.values()) {
            Manageable2.setManagementProperty(key, val);
        }
    }

    public synchronized void printManagementProperties(PrintStream stream) {
        for (String ibisName : this.subMap.keySet()) {
            Manageable Manageable2 = this.subMap.get(ibisName);
            stream.print(ibisName);
            stream.println(": ");
            Manageable2.printManagementProperties(stream);
        }
    }
}

