/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl;

import ibis.ipl.CapabilitySet;
import ibis.ipl.Credentials;
import ibis.ipl.Ibis;
import ibis.ipl.IbisCapabilities;
import ibis.ipl.IbisConfigurationException;
import ibis.ipl.IbisCreationFailedException;
import ibis.ipl.IbisProperties;
import ibis.ipl.IbisStarter;
import ibis.ipl.PortType;
import ibis.ipl.RegistryEventHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public final class IbisFactory {
    private static final String IPL_VERSION_STRING = "Ibis-IPL-Version";
    private static final String STARTER_CLASS_STRING = "Ibis-Starter-Class";
    private static final String IMPLEMENTATION_VERSION_STRING = "Ibis-Implementation-Version";
    private static final String NICKNAME_STRING = "Ibis-NickName";
    public static final String IPL_MANIFEST_FILE = "ibis/ipl/IPL_MANIFEST";
    public static final String DEFAULT_IMPLEMENTATION = "smartsockets";
    private static final Map<String, IbisFactory> factories = new HashMap<String, IbisFactory>();
    private static IbisFactory defaultFactory;
    private static final String VERSION = "2.3";
    private static Properties manifestProperties;
    private Map<String, IbisStarter> implementations;

    public static String getManifestProperty(String p) {
        return manifestProperties.getProperty(p, null);
    }

    private static synchronized IbisFactory getFactory(String implPath, Properties properties) {
        if (implPath == null) {
            if (defaultFactory == null) {
                defaultFactory = new IbisFactory(null, properties);
            }
            return defaultFactory;
        }
        IbisFactory factory = factories.get(implPath);
        if (factory == null) {
            factory = new IbisFactory(implPath, properties);
            factories.put(implPath, factory);
        }
        return factory;
    }

    private IbisFactory() {
    }

    private IbisFactory(String implementationPath, Properties properties) {
        this.implementations = new HashMap<String, IbisStarter>();
        this.loadIbisesFromJars(implementationPath);
        this.loadIbisesFromManifestFile();
        if (this.implementations.size() == 0) {
            throw new IbisConfigurationException("Cannot find any Ibis implementations");
        }
    }

    private static boolean isVerbose(Properties properties) {
        String verboseValue = properties.getProperty("ibis.verbose");
        return verboseValue != null && (verboseValue.equals("1") || verboseValue.equals("on") || verboseValue.equals("") || verboseValue.equals("true") || verboseValue.equals("yes"));
    }

    public static Ibis createIbis(IbisCapabilities requiredCapabilities, RegistryEventHandler registryEventHandler, PortType ... portTypes) throws IbisCreationFailedException {
        return IbisFactory.createIbis(requiredCapabilities, null, true, registryEventHandler, portTypes);
    }

    public static Ibis createIbis(IbisCapabilities requiredCapabilities, Properties properties, boolean addDefaultConfigProperties, RegistryEventHandler registryEventHandler, PortType ... portTypes) throws IbisCreationFailedException {
        return IbisFactory.createIbis(requiredCapabilities, properties, addDefaultConfigProperties, registryEventHandler, null, (byte[])null, portTypes);
    }

    public static Ibis createIbis(IbisCapabilities requiredCapabilities, Properties properties, boolean addDefaultConfigProperties, RegistryEventHandler registryEventHandler, Credentials credentials, PortType ... portTypes) throws IbisCreationFailedException {
        return IbisFactory.createIbis(requiredCapabilities, properties, addDefaultConfigProperties, registryEventHandler, credentials, (byte[])null, portTypes);
    }

    public static Ibis createIbis(IbisCapabilities requiredCapabilities, Properties properties, boolean addDefaultConfigProperties, RegistryEventHandler registryEventHandler, Credentials credentials, String tag, PortType ... portTypes) throws IbisCreationFailedException {
        byte[] tagBytes = null;
        if (tag != null) {
            try {
                tagBytes = tag.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new IbisCreationFailedException("could not create tag from string", e);
            }
        }
        return IbisFactory.createIbis(requiredCapabilities, properties, addDefaultConfigProperties, registryEventHandler, credentials, tagBytes, portTypes);
    }

    public static Ibis createIbis(IbisCapabilities requiredCapabilities, Properties properties, boolean addDefaultConfigProperties, RegistryEventHandler registryEventHandler, Credentials credentials, byte[] tag, PortType ... portTypes) throws IbisCreationFailedException {
        Properties combinedProperties = new Properties();
        if (addDefaultConfigProperties) {
            Properties defaults = IbisProperties.getDefaultProperties();
            Enumeration<?> e = defaults.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = defaults.getProperty(key);
                combinedProperties.setProperty(key, value);
            }
        }
        if (properties != null) {
            Enumeration<?> e = properties.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = properties.getProperty(key);
                combinedProperties.setProperty(key, value);
            }
        }
        String implPath = combinedProperties.getProperty("ibis.implementation.path");
        IbisFactory factory = IbisFactory.getFactory(implPath, combinedProperties);
        String specifiedImplementation = combinedProperties.getProperty("ibis.implementation");
        return factory.createIbis(registryEventHandler, requiredCapabilities, combinedProperties, credentials, tag, portTypes, specifiedImplementation);
    }

    private void checkSanity(RegistryEventHandler registryEventHandler, IbisCapabilities capabilities, PortType[] portTypes) throws IbisConfigurationException {
        for (PortType portType : portTypes) {
            int count = 0;
            if (portType.hasCapability("connection.manytomany")) {
                ++count;
            }
            if (portType.hasCapability("connection.onetoone")) {
                ++count;
            }
            if (portType.hasCapability("connection.onetomany")) {
                ++count;
            }
            if (portType.hasCapability("connection.manytoone")) {
                ++count;
            }
            if (count != 1) {
                throw new IbisConfigurationException("PortType " + portType + " should specify exactly one connection type");
            }
            String[] strings = portType.getCapabilities();
            boolean serializationSpecified = false;
            for (String s : strings) {
                if (!s.startsWith("serialization")) continue;
                serializationSpecified = true;
                break;
            }
            if (serializationSpecified) continue;
            throw new IbisConfigurationException("Port type " + portType + " should specify serialization");
        }
        if (registryEventHandler != null && !capabilities.hasCapability("membership.unreliable") && !capabilities.hasCapability("membership.totally.ordered")) {
            throw new IbisConfigurationException("RegistryEventHandler specified but no  membership capability requested");
        }
    }

    public Ibis createIbis(RegistryEventHandler registryEventHandler, IbisCapabilities requiredCapabilities, Properties properties, Credentials credentials, byte[] applicationTag, PortType[] portTypes, String specifiedImplementation) throws IbisCreationFailedException {
        if (requiredCapabilities == null) {
            throw new IbisConfigurationException("capabilities not specified");
        }
        if (portTypes == null) {
            throw new IbisConfigurationException("port types not specified");
        }
        if (IbisFactory.isVerbose(properties)) {
            System.err.println("IbisFactory: Looking for an IPL Implementation with capabilities: " + requiredCapabilities);
            System.err.println("(ibis) Properties:");
            Enumeration<?> e = properties.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (!key.startsWith("ibis")) continue;
                String value = properties.getProperty(key);
                System.err.println(key + " = " + value);
            }
            StringBuffer str = new StringBuffer();
            str.append("IPL implementations:");
            for (IbisStarter starter : this.implementations.values()) {
                str.append(" ");
                str.append(starter.getNickName());
            }
            System.err.println(str.toString());
        }
        this.checkSanity(registryEventHandler, requiredCapabilities, portTypes);
        String specifiedSubImplementation = null;
        if (specifiedImplementation != null) {
            String[] parts = specifiedImplementation.split(",|;", 2);
            specifiedImplementation = parts[0];
            if (parts.length == 2) {
                specifiedSubImplementation = parts[1];
            }
        }
        IbisStarter starter = this.selectImplementation(requiredCapabilities, portTypes, specifiedImplementation);
        if (IbisFactory.isVerbose(properties)) {
            System.err.println("IbisFactory: Selected ipl implementation: " + starter.getNickName());
        }
        return starter.startIbis(this, registryEventHandler, properties, requiredCapabilities, credentials, applicationTag, portTypes, specifiedSubImplementation);
    }

    private IbisStarter selectImplementation(IbisCapabilities requiredCapabilities, PortType[] portTypes, String specifiedImplementation) throws IbisCreationFailedException {
        if (specifiedImplementation != null) {
            IbisStarter starter = this.implementations.get(specifiedImplementation);
            if (starter == null) {
                throw new IbisCreationFailedException("User specified implementation \"" + specifiedImplementation + "\" cannot be found");
            }
            if (!starter.matches(requiredCapabilities, portTypes)) {
                CapabilitySet unmatchedCapabilities = starter.unmatchedIbisCapabilities(requiredCapabilities, portTypes);
                PortType[] remainingPortTypes = starter.unmatchedPortTypes(requiredCapabilities, portTypes);
                String portTypeString = "";
                for (PortType portType : remainingPortTypes) {
                    portTypeString = portTypeString + " " + portType;
                }
                throw new IbisCreationFailedException("User specified implementation \"" + specifiedImplementation + "\" does not fulfill specified requirements. Unmatched capabilities = " + unmatchedCapabilities + ", Unmatched port-types = " + portTypeString);
            }
            return starter;
        }
        ArrayList<IbisStarter> matchingIbises = new ArrayList<IbisStarter>();
        for (IbisStarter starter : this.implementations.values()) {
            if (!starter.matches(requiredCapabilities, portTypes)) continue;
            matchingIbises.add(starter);
        }
        if (matchingIbises.size() == 0) {
            throw new IbisCreationFailedException("Cannot find Ibis Implementation matching requirements");
        }
        if (matchingIbises.size() == 1) {
            return (IbisStarter)matchingIbises.get(0);
        }
        for (IbisStarter starter : matchingIbises) {
            if (!starter.getNickName().equals(DEFAULT_IMPLEMENTATION)) continue;
            return starter;
        }
        String possibilities = "";
        for (IbisStarter starter : matchingIbises) {
            possibilities = possibilities + " " + starter.getNickName();
        }
        throw new IbisCreationFailedException("Multiple ibis implementations matchs requirements, but the default implementation (\"smartsockets\") is not in list of possibilities: \"" + possibilities + "\", please select an ibis manually with the \"" + "ibis.implementation" + "\" property");
    }

    private static JarFile getJarFile(File file) {
        try {
            if (!file.isFile() || !file.getName().endsWith(".jar")) {
                return null;
            }
            JarFile result = new JarFile(file, true);
            Manifest manifest = result.getManifest();
            if (manifest != null) {
                manifest.getMainAttributes();
                return result;
            }
        }
        catch (IOException e) {
            System.err.println("IbisFactory: Could not create jar file from file: " + file);
        }
        return null;
    }

    private static JarFile[] readJarFiles(String path) {
        ArrayList<JarFile> result = new ArrayList<JarFile>();
        StringTokenizer st = new StringTokenizer(path, File.pathSeparator);
        while (st.hasMoreTokens()) {
            String dir = st.nextToken();
            File file = new File(dir);
            if (file.isFile()) {
                JarFile jarFile = IbisFactory.getJarFile(file);
                if (jarFile == null) continue;
                result.add(jarFile);
                continue;
            }
            if (file.isDirectory()) {
                File[] children;
                for (File child : children = file.listFiles()) {
                    JarFile jarFile = IbisFactory.getJarFile(child);
                    if (jarFile == null) continue;
                    result.add(jarFile);
                }
                continue;
            }
            System.err.println("IbisFactory: Not a file/directory: " + file);
        }
        return result.toArray(new JarFile[0]);
    }

    private static IbisStarter loadIbisFromJar(JarFile jar, ClassLoader classLoader) {
        try {
            Manifest manifest = jar.getManifest();
            Attributes attributes = manifest.getMainAttributes();
            String iplVersion = attributes.getValue(IPL_VERSION_STRING);
            String implementationVersion = attributes.getValue(IMPLEMENTATION_VERSION_STRING);
            String nickName = attributes.getValue(NICKNAME_STRING);
            String starterClass = attributes.getValue(STARTER_CLASS_STRING);
            if (iplVersion == null || !iplVersion.startsWith(VERSION) || implementationVersion == null || nickName == null || starterClass == null) {
                return null;
            }
            return IbisStarter.createInstance(starterClass, classLoader, nickName, iplVersion, implementationVersion);
        }
        catch (Exception e) {
            System.err.println("IbisFactory: Could not load ibis from jar: " + jar.getName() + ": " + e);
            return null;
        }
    }

    private void loadIbisesFromJars(String implementationPath) {
        if (implementationPath == null) {
            implementationPath = System.getProperty("java.class.path");
        }
        JarFile[] jarFiles = IbisFactory.readJarFiles(implementationPath);
        URL[] urls = new URL[jarFiles.length];
        for (int i = 0; i < jarFiles.length; ++i) {
            try {
                File f = new File(jarFiles[i].getName());
                urls[i] = f.toURI().toURL();
                continue;
            }
            catch (Exception e) {
                throw new Error(e);
            }
        }
        URLClassLoader classLoader = new URLClassLoader(urls, this.getClass().getClassLoader());
        for (int i = 0; i < jarFiles.length; ++i) {
            IbisStarter starter = IbisFactory.loadIbisFromJar(jarFiles[i], classLoader);
            if (starter == null) continue;
            this.implementations.put(starter.getNickName(), starter);
        }
    }

    private void loadIbisesFromManifestFile() {
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            String nickNames = manifestProperties.getProperty("implementations");
            if (nickNames == null) {
                System.err.println("IbisFactory Warning: no implementations found in manifest property file");
            }
            for (String nickName : nickNames.split(",")) {
                IbisStarter starter;
                if (this.implementations.containsKey(nickName)) continue;
                String iplVersion = manifestProperties.getProperty(nickName + ".ipl.version", null);
                String implementationVersion = manifestProperties.getProperty(nickName + ".version", null);
                String starterClass = manifestProperties.getProperty(nickName + ".starter.class", null);
                if (iplVersion == null || !iplVersion.startsWith(VERSION) || implementationVersion == null || nickName == null || starterClass == null || (starter = IbisStarter.createInstance(starterClass, classLoader, nickName, iplVersion, implementationVersion)) == null) continue;
                this.implementations.put(nickName, starter);
            }
        }
        catch (Throwable t) {
            System.err.println("IbisFactory Warning: could not load implementation from manifest property file: " + t);
            t.printStackTrace(System.err);
        }
    }

    static {
        manifestProperties = new Properties();
        ClassLoader classLoader = IbisFactory.class.getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(IPL_MANIFEST_FILE);
        if (inputStream == null) {
            System.err.println("IbisFactory Warning: could not load properties from manifest property file");
        } else {
            try {
                manifestProperties.load(inputStream);
            }
            catch (IOException e) {
                System.err.println("Warning: could not load properties from manifest property file");
            }
        }
    }
}

