/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl.stacking.lrmc.util;

import ibis.ipl.impl.stacking.lrmc.util.Message;

public class MessageCache {
    private final int MESSAGE_SIZE;
    private final int MAX_SIZE;
    private Message cache;
    private int size;
    private long hits = 0L;
    private long miss = 0L;
    private long store = 0L;
    private long discard = 0L;

    public MessageCache(int cacheSize, int messageSize) {
        this.MAX_SIZE = cacheSize;
        this.MESSAGE_SIZE = messageSize;
    }

    public synchronized void setDestinationSize(int count) {
        Message tmp = this.cache;
        while (tmp != null) {
            if (tmp.destinations == null || tmp.destinations.length < count) {
                tmp.destinations = new int[count];
            }
            tmp = tmp.next;
        }
    }

    public synchronized void put(Message m) {
        m.refcount = (short)(m.refcount - 1);
        if (m.refcount == 0) {
            if (this.size < this.MAX_SIZE && m.buffer != null && m.buffer.length == this.MESSAGE_SIZE) {
                m.next = this.cache;
                this.cache = m;
                ++this.size;
                ++this.store;
            } else {
                m.next = null;
                ++this.discard;
            }
        }
    }

    public Message get(int len) {
        if (len > this.MESSAGE_SIZE) {
            ++this.miss;
            return new Message(len);
        }
        return this.get();
    }

    public synchronized Message get() {
        Message tmp = null;
        if (this.size == 0) {
            ++this.miss;
            tmp = new Message(this.MESSAGE_SIZE);
        } else {
            ++this.hits;
            tmp = this.cache;
            this.cache = this.cache.next;
            --this.size;
        }
        tmp.next = null;
        tmp.local = false;
        tmp.refcount = 1;
        return tmp;
    }

    public int getPrefferedMessageSize() {
        return this.MESSAGE_SIZE;
    }
}

