/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl.stacking.lrmc.util;

public class BoundedObjectQueue {
    private final Object[] objects;
    private final int maxSize;
    private int head = 0;
    private int tail = 0;
    private int size = 0;

    public BoundedObjectQueue(int size) {
        this.maxSize = size;
        this.objects = new Object[this.maxSize];
    }

    public synchronized void enqueue(Object o) {
        while (this.size == this.maxSize) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.objects[this.head] = o;
        this.head = (this.head + 1) % this.maxSize;
        ++this.size;
        if (this.size == 1) {
            this.notifyAll();
        }
    }

    public synchronized Object dequeue() {
        while (this.size == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {}
        }
        Object tmp = this.objects[this.tail];
        this.objects[this.tail] = null;
        this.tail = (this.tail + 1) % this.maxSize;
        --this.size;
        if (this.size == this.maxSize - 1) {
            this.notifyAll();
        }
        return tmp;
    }
}

