/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl.stacking.lrmc;

import ibis.ipl.AlreadyConnectedException;
import ibis.ipl.ConnectionFailedException;
import ibis.ipl.ConnectionsFailedException;
import ibis.ipl.IbisIdentifier;
import ibis.ipl.NoSuchPropertyException;
import ibis.ipl.PortType;
import ibis.ipl.ReceivePortIdentifier;
import ibis.ipl.SendPort;
import ibis.ipl.SendPortIdentifier;
import ibis.ipl.WriteMessage;
import ibis.ipl.impl.stacking.lrmc.LrmcIbis;
import ibis.ipl.impl.stacking.lrmc.LrmcReceivePortIdentifier;
import ibis.ipl.impl.stacking.lrmc.LrmcSendPortIdentifier;
import ibis.ipl.impl.stacking.lrmc.LrmcWriteMessage;
import ibis.ipl.impl.stacking.lrmc.Multicaster;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;

public class LrmcSendPort
implements SendPort {
    private final LrmcSendPortIdentifier identifier;
    private final Multicaster om;
    IbisIdentifier[] connectedTo = new IbisIdentifier[0];
    HashSet<IbisIdentifier> connections = new HashSet();
    boolean connectionsChanged = false;
    boolean closed = false;
    LrmcWriteMessage message = null;

    public LrmcSendPort(Multicaster om, LrmcIbis ibis, Properties props) {
        this.om = om;
        this.identifier = new LrmcSendPortIdentifier(ibis.identifier(), om.name);
    }

    public synchronized void close() throws IOException {
        this.closed = true;
        this.om.sendPort = null;
        this.connections.clear();
        if (this.message != null) {
            throw new IOException("Close called while a message is alive");
        }
        this.om.removeSendPort();
    }

    public void connect(ReceivePortIdentifier receiver) throws ConnectionFailedException {
        this.connect(receiver, 0L, true);
    }

    public synchronized void connect(ReceivePortIdentifier receiver, long timeoutMillis, boolean fillTimeout) throws ConnectionFailedException {
        if (this.closed) {
            throw new ConnectionFailedException("Sendport is closed", receiver);
        }
        if (!this.identifier.name.equals(receiver.name())) {
            throw new ConnectionFailedException("LRMCIbis sendport connect requires that the receiveport has the same name", receiver);
        }
        if (this.connections.contains(receiver.ibisIdentifier())) {
            throw new AlreadyConnectedException("This connection already exists", receiver);
        }
        this.connections.add(receiver.ibisIdentifier());
        this.connectionsChanged = true;
    }

    public ReceivePortIdentifier connect(IbisIdentifier ibisIdentifier, String receivePortName) throws ConnectionFailedException {
        LrmcReceivePortIdentifier id = new LrmcReceivePortIdentifier(ibisIdentifier, receivePortName);
        this.connect(id, 0L, true);
        return id;
    }

    public ReceivePortIdentifier connect(IbisIdentifier ibisIdentifier, String receivePortName, long timeoutMillis, boolean fillTimeout) throws ConnectionFailedException {
        LrmcReceivePortIdentifier id = new LrmcReceivePortIdentifier(ibisIdentifier, receivePortName);
        this.connect(id, timeoutMillis, fillTimeout);
        return id;
    }

    public void connect(ReceivePortIdentifier[] receivePortIdentifiers) throws ConnectionsFailedException {
        this.connect(receivePortIdentifiers, 0L, true);
    }

    public void connect(ReceivePortIdentifier[] receivePortIdentifiers, long timeoutMillis, boolean fillTimeout) throws ConnectionsFailedException {
        ArrayList<ReceivePortIdentifier> succes = new ArrayList<ReceivePortIdentifier>();
        HashMap<ReceivePortIdentifier, Throwable> results = new HashMap<ReceivePortIdentifier, Throwable>();
        for (ReceivePortIdentifier id : receivePortIdentifiers) {
            try {
                this.connect(id, 0L, true);
                succes.add(id);
            }
            catch (Throwable e) {
                results.put(id, e);
            }
        }
        if (succes.size() != receivePortIdentifiers.length) {
            ConnectionsFailedException ex = new ConnectionsFailedException();
            for (ReceivePortIdentifier rp : results.keySet()) {
                Throwable tmp = (Throwable)results.get(rp);
                if (tmp instanceof ConnectionFailedException) {
                    ex.add((ConnectionFailedException)tmp);
                    continue;
                }
                ex.add(new ConnectionFailedException("Connection failed", rp, tmp));
            }
            ex.setObtainedConnections(succes.toArray(new ReceivePortIdentifier[succes.size()]));
            throw ex;
        }
    }

    public ReceivePortIdentifier[] connect(Map<IbisIdentifier, String> ports) throws ConnectionsFailedException {
        return this.connect(ports, 0L, true);
    }

    public ReceivePortIdentifier[] connect(Map<IbisIdentifier, String> ports, long timeoutMillis, boolean fillTimeout) throws ConnectionsFailedException {
        ReceivePortIdentifier[] ids = new ReceivePortIdentifier[ports.size()];
        int index = 0;
        for (Map.Entry<IbisIdentifier, String> entry : ports.entrySet()) {
            ids[index++] = new LrmcReceivePortIdentifier(entry.getKey(), entry.getValue());
        }
        this.connect(ids, timeoutMillis, fillTimeout);
        return ids;
    }

    public ReceivePortIdentifier[] connectedTo() {
        return null;
    }

    public void disconnect(ReceivePortIdentifier receiver) throws IOException {
        if (this.closed) {
            throw new IOException("Sendport is closed");
        }
        if (!this.identifier.name.equals(receiver.name())) {
            throw new IOException("LRMCIbis sendport disconnect requires that the receiveport has the same name");
        }
        if (!this.connections.contains(receiver.ibisIdentifier())) {
            throw new IOException("This connection does not exists");
        }
        this.connections.remove(receiver.ibisIdentifier());
        this.connectionsChanged = true;
    }

    public void disconnect(IbisIdentifier ibisIdentifier, String receivePortName) throws IOException {
        this.disconnect(new LrmcReceivePortIdentifier(ibisIdentifier, receivePortName));
    }

    public PortType getPortType() {
        return this.om.portType;
    }

    public SendPortIdentifier identifier() {
        return this.identifier;
    }

    public ReceivePortIdentifier[] lostConnections() {
        return null;
    }

    public String name() {
        return this.identifier.name;
    }

    public synchronized WriteMessage newMessage() throws IOException {
        if (this.closed) {
            throw new IOException("Sendport is closed");
        }
        while (this.message != null) {
            try {
                this.wait();
            }
            catch (Throwable throwable) {}
        }
        if (this.connectionsChanged) {
            this.connectionsChanged = false;
            this.connectedTo = this.connections.toArray(new IbisIdentifier[this.connections.size()]);
        }
        this.message = new LrmcWriteMessage(this, this.om, this.connectedTo);
        return this.message;
    }

    public String getManagementProperty(String key) throws NoSuchPropertyException {
        throw new NoSuchPropertyException("No properties in LRMCRSendPort");
    }

    public Map<String, String> managementProperties() {
        return new HashMap<String, String>();
    }

    public void printManagementProperties(PrintStream stream) {
    }

    public void setManagementProperties(Map<String, String> properties) throws NoSuchPropertyException {
        throw new NoSuchPropertyException("No properties in LRMCSendPort");
    }

    public void setManagementProperty(String key, String value) throws NoSuchPropertyException {
        throw new NoSuchPropertyException("No properties in LRMCSendPort");
    }
}

