/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl.stacking.lrmc;

import ibis.ipl.impl.stacking.lrmc.io.LrmcInputStream;
import ibis.ipl.impl.stacking.lrmc.util.Message;
import ibis.ipl.impl.stacking.lrmc.util.MessageCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputStreams {
    private static final int DEFAULT_SIZE = 64;
    private static final Logger logger = LoggerFactory.getLogger(InputStreams.class);
    private LrmcInputStream[] inputStreams = new LrmcInputStream[64];
    private boolean[] hasData = new boolean[64];
    private boolean[] busy = new boolean[64];
    private int streamsWithData = 0;
    private int index = 0;
    private int last = -1;
    private boolean finish = false;

    private void add(LrmcInputStream is, int sender) {
        if (sender >= this.inputStreams.length) {
            this.resize(sender);
        }
        this.inputStreams[sender] = is;
        if (sender > this.last) {
            this.last = sender;
        }
    }

    public synchronized void terminate() {
        this.finish = true;
        for (int i = 0; i <= this.last; ++i) {
            if (this.inputStreams[i] == null) continue;
            this.inputStreams[i].terminate();
        }
        this.notifyAll();
    }

    private void resize(int minimumSize) {
        int newSize;
        for (newSize = this.hasData.length; newSize <= minimumSize; newSize *= 2) {
        }
        LrmcInputStream[] tmp1 = new LrmcInputStream[newSize];
        System.arraycopy(this.inputStreams, 0, tmp1, 0, this.inputStreams.length);
        this.inputStreams = tmp1;
        boolean[] tmp2 = new boolean[newSize];
        System.arraycopy(this.hasData, 0, tmp2, 0, this.hasData.length);
        this.hasData = tmp2;
        boolean[] tmp3 = new boolean[newSize];
        System.arraycopy(this.busy, 0, tmp3, 0, this.busy.length);
        this.busy = tmp3;
    }

    public synchronized LrmcInputStream get(int sender, MessageCache cache) {
        LrmcInputStream tmp = this.find(sender);
        if (tmp == null) {
            tmp = new LrmcInputStream(sender, cache);
            this.add(tmp, sender);
        }
        return tmp;
    }

    private LrmcInputStream find(int sender) {
        if (sender < 0 || sender > this.last) {
            return null;
        }
        return this.inputStreams[sender];
    }

    public synchronized void returnStream(LrmcInputStream is) {
        this.busy[is.getSource()] = false;
        if (is.haveData()) {
            if (logger.isDebugEnabled()) {
                logger.debug("return stream " + is.getSource() + ", still has data");
            }
            this.hasData(is);
        } else if (logger.isDebugEnabled()) {
            logger.debug("return stream " + is.getSource() + ", no data left");
        }
    }

    public synchronized boolean hasData(LrmcInputStream is, Message m) {
        if (is.addMessage(m)) {
            this.hasData(is);
            return true;
        }
        return false;
    }

    public synchronized void hasData(LrmcInputStream is) {
        int src = is.getSource();
        if (!this.hasData[src] && !this.busy[src]) {
            this.hasData[src] = true;
            if (logger.isDebugEnabled()) {
                logger.debug("Setting hasData for stream " + src);
                if (!is.haveData()) {
                    logger.debug("Set hasData but no data?", new Throwable());
                }
            }
            ++this.streamsWithData;
            if (this.streamsWithData == 1) {
                this.notifyAll();
            }
        }
    }

    public synchronized LrmcInputStream getNextFilledStream() {
        while (!this.finish && this.streamsWithData == 0) {
            try {
                this.wait();
            }
            catch (Exception e) {}
        }
        if (this.finish) {
            return null;
        }
        int size = this.inputStreams.length;
        for (int i = 1; i <= size; ++i) {
            if (!this.hasData[(this.index + i) % size]) continue;
            this.index = (this.index + i) % size;
            break;
        }
        if (logger.isDebugEnabled() && !this.hasData[this.index]) {
            logger.debug("GetNextFilledStream returns !hasData stream, streamsWithData = " + this.streamsWithData + ", index = " + this.index, new Throwable());
        }
        this.hasData[this.index] = false;
        if (logger.isDebugEnabled()) {
            logger.debug("start read from stream " + this.index);
        }
        this.busy[this.index] = true;
        if (logger.isDebugEnabled() && !this.inputStreams[this.index].haveData()) {
            logger.debug("GetNextFilledStream returns empty stream, streamsWithData = " + this.streamsWithData + ", index = " + this.index, new Throwable());
        }
        --this.streamsWithData;
        return this.inputStreams[this.index];
    }
}

