/*
 * Decompiled with CFR 0.152.
 */
package ibis.compile;

import ibis.compile.IbiscEntry;
import ibis.compile.JarEntryInfo;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JarInfo {
    private boolean modified;
    private ArrayList<JarEntryInfo> entries = new ArrayList();
    private JarFile jarFile;

    public JarInfo(JarFile jf) throws IOException {
        this.jarFile = jf;
        this.modified = false;
        Enumeration<JarEntry> iitems = jf.entries();
        while (iitems.hasMoreElements()) {
            JarEntry ient = iitems.nextElement();
            this.entries.add(new JarEntryInfo(ient, this));
        }
    }

    public Enumeration<JarEntryInfo> entries() {
        return new Enum();
    }

    public void addEntry(IbiscEntry e) {
        JarEntry je = new JarEntry(e.fileName);
        JarEntryInfo jei = new JarEntryInfo(je, this, null, e);
        this.entries.add(jei);
    }

    public void setModified(boolean val) {
        this.modified = val;
    }

    public boolean getModified() {
        return this.modified;
    }

    public String getName() {
        return this.jarFile.getName();
    }

    public InputStream getInputStream(JarEntry j) throws IOException {
        return this.jarFile.getInputStream(j);
    }

    private class Enum
    implements Enumeration<JarEntryInfo> {
        int count = 0;

        private Enum() {
        }

        @Override
        public boolean hasMoreElements() {
            return this.count < JarInfo.this.entries.size();
        }

        @Override
        public JarEntryInfo nextElement() {
            if (this.count >= JarInfo.this.entries.size()) {
                throw new NoSuchElementException();
            }
            return (JarEntryInfo)JarInfo.this.entries.get(this.count++);
        }
    }
}

