/*
 * Decompiled with CFR 0.152.
 */
package ibis.ipl.impl;

import ibis.io.IbisIOException;
import ibis.ipl.Credentials;
import ibis.ipl.IbisCapabilities;
import ibis.ipl.IbisConfigurationException;
import ibis.ipl.IbisCreationFailedException;
import ibis.ipl.IbisFactory;
import ibis.ipl.IbisProperties;
import ibis.ipl.IbisStarter;
import ibis.ipl.MessageUpcall;
import ibis.ipl.NoSuchPropertyException;
import ibis.ipl.PortType;
import ibis.ipl.ReceivePortConnectUpcall;
import ibis.ipl.ReceivePortIdentifier;
import ibis.ipl.Registry;
import ibis.ipl.RegistryEventHandler;
import ibis.ipl.SendPort;
import ibis.ipl.SendPortDisconnectUpcall;
import ibis.ipl.SendPortIdentifier;
import ibis.ipl.impl.IbisIdentifier;
import ibis.ipl.impl.Manageable;
import ibis.ipl.impl.ReceivePort;
import ibis.ipl.impl.RegistryEventHandlerWrapper;
import ibis.ipl.support.management.ManagementClient;
import ibis.ipl.support.vivaldi.Coordinates;
import ibis.ipl.support.vivaldi.VivaldiClient;
import ibis.util.TypedProperties;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Ibis
implements ibis.ipl.Ibis {
    public static final String ID_PROPERTY = "ibis.local.id";
    private static final Logger logger = LoggerFactory.getLogger((String)"ibis.ipl.impl.Ibis");
    private final IbisCapabilities capabilities;
    private final PortType[] portTypes;
    private final IbisStarter starter;
    protected TypedProperties properties;
    private final ibis.ipl.registry.Registry registry;
    private final ManagementClient managementClient;
    private final VivaldiClient vivaldiClient;
    public final IbisIdentifier ident;
    private boolean ended = false;
    private HashMap<String, ReceivePort> receivePorts;
    private HashMap<String, ibis.ipl.impl.SendPort> sendPorts;
    private HashMap<ibis.ipl.IbisIdentifier, Long> sentBytesPerIbis = null;
    private HashMap<ibis.ipl.IbisIdentifier, Long> receivedBytesPerIbis = null;
    private static int send_counter = 0;
    private static int receive_counter = 0;
    private long outgoingMessageCount = 0L;
    private long incomingMessageCount = 0L;
    private long bytesWritten = 0L;
    private long bytesSent = 0L;
    private long bytesReceived = 0L;
    private long bytesRead = 0L;

    private String getImplementationVersion() throws Exception {
        String genericVersion = Ibis.class.getPackage().getImplementationVersion();
        if (genericVersion == null || genericVersion.equals("0.0")) {
            genericVersion = IbisFactory.getManifestProperty((String)"implementation.version");
        }
        logger.debug("Version of Generic Ibis = " + genericVersion);
        if (genericVersion == null || this.starter.getImplementationVersion() == null) {
            throw new Exception("cannot get version for ibis");
        }
        return genericVersion + this.starter.getImplementationVersion();
    }

    protected Ibis(RegistryEventHandler registryHandler, IbisCapabilities capabilities, Credentials credentials, byte[] applicationTag, PortType[] portTypes, Properties userProperties, IbisStarter starter) throws IbisCreationFailedException {
        if (capabilities == null) {
            throw new IbisConfigurationException("capabilities not specified");
        }
        this.capabilities = capabilities;
        this.portTypes = portTypes;
        this.starter = starter;
        this.properties = new TypedProperties();
        this.properties.addProperties(IbisProperties.getHardcodedProperties());
        this.properties.addProperties(userProperties);
        this.properties.setProperty(ID_PROPERTY, UUID.randomUUID().toString());
        if (logger.isDebugEnabled()) {
            logger.debug("Ibis constructor: properties = " + this.properties);
        }
        this.receivePorts = new HashMap();
        this.sendPorts = new HashMap();
        if (registryHandler != null) {
            registryHandler = new RegistryEventHandlerWrapper(registryHandler, this);
        }
        try {
            this.registry = ibis.ipl.registry.Registry.createRegistry((IbisCapabilities)this.capabilities, (RegistryEventHandler)registryHandler, (Properties)this.properties, (byte[])this.getData(), (String)this.getImplementationVersion(), (byte[])applicationTag, (Credentials)credentials);
        }
        catch (IbisConfigurationException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IbisCreationFailedException("Could not create registry", e);
        }
        this.ident = this.registry.getIbisIdentifier();
        if (this.properties.getBooleanProperty("ibis.vivaldi")) {
            try {
                this.vivaldiClient = new VivaldiClient((Properties)this.properties, this.registry);
            }
            catch (Exception e) {
                throw new IbisCreationFailedException("Could not create vivaldi client", (Throwable)e);
            }
        } else {
            this.vivaldiClient = null;
        }
        if (this.properties.getBooleanProperty("ibis.bytescount")) {
            this.sentBytesPerIbis = new HashMap();
            this.receivedBytesPerIbis = new HashMap();
        }
        if (this.properties.getBooleanProperty("ibis.managementclient")) {
            try {
                this.managementClient = new ManagementClient((Properties)this.properties, this);
            }
            catch (Throwable e) {
                throw new IbisCreationFailedException("Could not create management client", e);
            }
        } else {
            this.managementClient = null;
        }
    }

    void died(ibis.ipl.IbisIdentifier corpse) {
        this.killConnections(corpse);
    }

    void left(ibis.ipl.IbisIdentifier leftIbis) {
        this.killConnections(leftIbis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void killConnections(ibis.ipl.IbisIdentifier corpse) {
        ReceivePort[] rps;
        ibis.ipl.impl.SendPort[] sps;
        Ibis ibis = this;
        synchronized (ibis) {
            sps = this.sendPorts.values().toArray(new ibis.ipl.impl.SendPort[this.sendPorts.size()]);
            rps = this.receivePorts.values().toArray(new ReceivePort[this.receivePorts.size()]);
        }
        for (ibis.ipl.impl.SendPort sendPort : sps) {
            try {
                sendPort.killConnectionsWith(corpse);
            }
            catch (Throwable e) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Got exception from killConnectionsWith", e);
            }
        }
        for (Manageable manageable : rps) {
            try {
                ((ReceivePort)manageable).killConnectionsWith(corpse);
            }
            catch (Throwable e) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Got exception from killConnectionsWith", e);
            }
        }
    }

    public String getVersion() {
        return this.starter.getNickName() + "-" + this.starter.getIplVersion();
    }

    public Registry registry() {
        return this.registry;
    }

    public ibis.ipl.IbisIdentifier identifier() {
        return this.ident;
    }

    public Properties properties() {
        return new Properties((Properties)this.properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end() throws IOException {
        Ibis ibis = this;
        synchronized (ibis) {
            if (this.ended) {
                return;
            }
            this.ended = true;
        }
        if (this.managementClient != null) {
            this.managementClient.end();
        }
        if (this.vivaldiClient != null) {
            this.vivaldiClient.end();
        }
        try {
            this.registry.leave();
        }
        catch (Throwable e) {
            throw new IbisIOException("Registry: leave failed ", e);
        }
        finally {
            this.quit();
        }
    }

    public void poll() throws IOException {
    }

    synchronized void register(ReceivePort p) throws IOException {
        if (this.receivePorts.get(p.name) != null) {
            throw new IOException("Multiple instances of receiveport named " + p.name);
        }
        this.receivePorts.put(p.name, p);
    }

    synchronized void deRegister(ReceivePort p) {
        if (this.receivePorts.remove(p.name) != null) {
            this.incomingMessageCount += p.getMessageCount();
            this.bytesReceived += p.getBytesReceived();
            this.bytesRead += p.getBytesRead();
        }
    }

    synchronized void register(ibis.ipl.impl.SendPort p) throws IOException {
        if (this.sendPorts.get(p.name) != null) {
            throw new IOException("Multiple instances of sendport named " + p.name);
        }
        this.sendPorts.put(p.name, p);
    }

    synchronized void deRegister(ibis.ipl.impl.SendPort p) {
        if (this.sendPorts.remove(p.name) != null) {
            this.outgoingMessageCount += p.getMessageCount();
            this.bytesSent += p.getBytesSent();
            this.bytesWritten += p.getBytesWritten();
        }
    }

    synchronized void addSentPerIbis(long cnt, ReceivePortIdentifier[] idents) {
        if (this.sentBytesPerIbis == null) {
            return;
        }
        for (ReceivePortIdentifier rp : idents) {
            ibis.ipl.IbisIdentifier i = rp.ibisIdentifier();
            Long oldval = this.sentBytesPerIbis.get(i);
            if (oldval != null) {
                cnt += oldval.longValue();
            }
            this.sentBytesPerIbis.put(i, new Long(cnt));
        }
    }

    synchronized void addReceivedPerIbis(long cnt, SendPortIdentifier[] idents) {
        if (this.receivedBytesPerIbis == null) {
            return;
        }
        for (SendPortIdentifier sp : idents) {
            ibis.ipl.IbisIdentifier i = sp.ibisIdentifier();
            Long oldval = this.receivedBytesPerIbis.get(i);
            if (oldval != null) {
                cnt += oldval.longValue();
            }
            this.receivedBytesPerIbis.put(i, new Long(cnt));
        }
    }

    public synchronized ReceivePort findReceivePort(String name) {
        return this.receivePorts.get(name);
    }

    public synchronized ibis.ipl.impl.SendPort findSendPort(String name) {
        return this.sendPorts.get(name);
    }

    public ibis.ipl.impl.ReceivePortIdentifier createReceivePortIdentifier(String name, IbisIdentifier id) {
        return new ibis.ipl.impl.ReceivePortIdentifier(name, id);
    }

    public ibis.ipl.impl.SendPortIdentifier createSendPortIdentifier(String name, IbisIdentifier id) {
        return new ibis.ipl.impl.SendPortIdentifier(name, id);
    }

    protected abstract void quit();

    protected abstract byte[] getData() throws IOException;

    public SendPort createSendPort(PortType tp) throws IOException {
        return this.createSendPort(tp, null, null, null);
    }

    public SendPort createSendPort(PortType tp, String name) throws IOException {
        return this.createSendPort(tp, name, null, null);
    }

    private void matchPortType(PortType tp) {
        boolean matched = false;
        for (PortType p : this.portTypes) {
            if (!tp.equals((Object)p)) continue;
            matched = true;
        }
        if (!matched) {
            throw new IbisConfigurationException("PortType \"" + tp + "\" not specified when creating this Ibis instance");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SendPort createSendPort(PortType tp, String name, SendPortDisconnectUpcall cU, Properties properties) throws IOException {
        if (tp.hasCapability("connection.ultralight")) {
            if (tp.hasCapability("connection.upcalls")) {
                throw new IbisConfigurationException("Ultralight connections to not support connection upcalls");
            }
            if (tp.hasCapability("communication.reliable")) {
                throw new IbisConfigurationException("Ultralight connections do not support reliability");
            }
            if (tp.hasCapability("communication.fifo")) {
                throw new IbisConfigurationException("Ultralight connections do not support FIFO message ordering");
            }
        }
        if (cU != null && !tp.hasCapability("connection.upcalls")) {
            throw new IbisConfigurationException("no connection upcalls requested for this port type");
        }
        if (name == null) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                name = "anonymous send port " + send_counter++;
            }
        }
        this.matchPortType(tp);
        return this.doCreateSendPort(tp, name, cU, properties);
    }

    protected abstract SendPort doCreateSendPort(PortType var1, String var2, SendPortDisconnectUpcall var3, Properties var4) throws IOException;

    public ibis.ipl.ReceivePort createReceivePort(PortType tp, String name) throws IOException {
        return this.createReceivePort(tp, name, null, null, null);
    }

    public ibis.ipl.ReceivePort createReceivePort(PortType tp, String name, MessageUpcall u) throws IOException {
        return this.createReceivePort(tp, name, u, null, null);
    }

    public ibis.ipl.ReceivePort createReceivePort(PortType tp, String name, ReceivePortConnectUpcall cU) throws IOException {
        return this.createReceivePort(tp, name, null, cU, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ibis.ipl.ReceivePort createReceivePort(PortType tp, String name, MessageUpcall u, ReceivePortConnectUpcall cU, Properties properties) throws IOException {
        if (tp.hasCapability("connection.ultralight")) {
            if (tp.hasCapability("connection.upcalls")) {
                throw new IbisConfigurationException("Ultralight connections to not support connection upcalls");
            }
            if (tp.hasCapability("communication.reliable")) {
                throw new IbisConfigurationException("Ultralight connections do not support reliability");
            }
            if (tp.hasCapability("communication.fifo")) {
                throw new IbisConfigurationException("Ultralight connections do not support FIFO message ordering");
            }
        }
        if (cU != null && !tp.hasCapability("connection.upcalls")) {
            throw new IbisConfigurationException("no connection upcalls requested for this port type");
        }
        if (u != null) {
            if (!tp.hasCapability("receive.autoupcalls") && !tp.hasCapability("receive.pollupcalls")) {
                throw new IbisConfigurationException("no message upcalls requested for this port type");
            }
        } else if (!tp.hasCapability("receive.explicit")) {
            throw new IbisConfigurationException("no explicit receive requested for this port type");
        }
        if (name == null) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                name = "anonymous receive port " + receive_counter++;
            }
        }
        this.matchPortType(tp);
        return this.doCreateReceivePort(tp, name, u, cU, properties);
    }

    protected abstract ibis.ipl.ReceivePort doCreateReceivePort(PortType var1, String var2, MessageUpcall var3, ReceivePortConnectUpcall var4, Properties var5) throws IOException;

    public String getManagementProperty(String key) throws NoSuchPropertyException {
        String result = this.managementProperties().get(key);
        if (result == null) {
            throw new NoSuchPropertyException("property \"" + key + "\" not found");
        }
        return result;
    }

    public synchronized long getOutgoingMessageCount() {
        long outgoingMessageCount = this.outgoingMessageCount;
        for (ibis.ipl.impl.SendPort sendPort : this.sendPorts.values()) {
            outgoingMessageCount += sendPort.getMessageCount();
        }
        return outgoingMessageCount;
    }

    public synchronized long getBytesSent() {
        long bytesSend = this.bytesSent;
        for (ibis.ipl.impl.SendPort sendPort : this.sendPorts.values()) {
            bytesSend += sendPort.getBytesSent();
        }
        return bytesSend;
    }

    public synchronized long getBytesWritten() {
        long bytesWritten = this.bytesWritten;
        for (ibis.ipl.impl.SendPort sendPort : this.sendPorts.values()) {
            bytesWritten += sendPort.getBytesWritten();
        }
        return bytesWritten;
    }

    public synchronized long getIncomingMessageCount() {
        long incomingMessageCount = this.incomingMessageCount;
        for (ReceivePort receivePort : this.receivePorts.values()) {
            incomingMessageCount += receivePort.getMessageCount();
        }
        return incomingMessageCount;
    }

    public synchronized long getBytesReceived() {
        long bytesReceived = this.bytesReceived;
        for (ReceivePort receivePort : this.receivePorts.values()) {
            bytesReceived += receivePort.getBytesReceived();
        }
        return bytesReceived;
    }

    public synchronized long getBytesRead() {
        long bytesRead = this.bytesRead;
        for (ReceivePort receivePort : this.receivePorts.values()) {
            bytesRead += receivePort.getBytesRead();
        }
        return bytesRead;
    }

    public synchronized ibis.ipl.IbisIdentifier[] connectedTo() {
        HashSet<ibis.ipl.IbisIdentifier> result = new HashSet<ibis.ipl.IbisIdentifier>();
        Collection<ibis.ipl.impl.SendPort> ports = this.sendPorts.values();
        for (ibis.ipl.impl.SendPort sendPort : ports) {
            ReceivePortIdentifier[] receivePorts;
            for (ReceivePortIdentifier receivePort : receivePorts = sendPort.connectedTo()) {
                result.add(receivePort.ibisIdentifier());
            }
        }
        return result.toArray(new ibis.ipl.IbisIdentifier[0]);
    }

    public Coordinates getVivaldiCoordinates() {
        if (this.vivaldiClient == null) {
            return null;
        }
        return this.vivaldiClient.getCoordinates();
    }

    public synchronized Map<ibis.ipl.IbisIdentifier, Long> getSentBytesPerIbis() {
        if (this.sentBytesPerIbis == null) {
            return null;
        }
        return new HashMap<ibis.ipl.IbisIdentifier, Long>(this.sentBytesPerIbis);
    }

    public synchronized Map<ibis.ipl.IbisIdentifier, Long> getReceivedBytesPerIbis() {
        if (this.receivedBytesPerIbis == null) {
            return null;
        }
        return new HashMap<ibis.ipl.IbisIdentifier, Long>(this.receivedBytesPerIbis);
    }

    public String[] wonElections() {
        return this.registry.wonElections();
    }

    public synchronized Map<ibis.ipl.IbisIdentifier, Set<String>> getReceiverConnectionTypes() {
        HashMap<ibis.ipl.IbisIdentifier, Set<String>> result = new HashMap<ibis.ipl.IbisIdentifier, Set<String>>();
        for (ReceivePort port : this.receivePorts.values()) {
            Map<IbisIdentifier, Set<String>> p = port.getConnectionTypes();
            for (Map.Entry<IbisIdentifier, Set<String>> entry : p.entrySet()) {
                HashSet r = (HashSet)result.get(entry.getKey());
                if (r == null) {
                    r = new HashSet();
                }
                r.addAll(entry.getValue());
                result.put(entry.getKey(), r);
            }
        }
        return result;
    }

    public synchronized Map<ibis.ipl.IbisIdentifier, Set<String>> getSenderConnectionTypes() {
        HashMap<ibis.ipl.IbisIdentifier, Set<String>> result = new HashMap<ibis.ipl.IbisIdentifier, Set<String>>();
        for (ibis.ipl.impl.SendPort port : this.sendPorts.values()) {
            Map<IbisIdentifier, Set<String>> p = port.getConnectionTypes();
            for (Map.Entry<IbisIdentifier, Set<String>> entry : p.entrySet()) {
                HashSet r = (HashSet)result.get(entry.getKey());
                if (r == null) {
                    r = new HashSet();
                }
                r.addAll(entry.getValue());
                result.put(entry.getKey(), r);
            }
        }
        return result;
    }

    public synchronized Map<String, String> managementProperties() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("outgoingMessageCount", "" + this.getOutgoingMessageCount());
        result.put("bytesWritten", "" + this.getBytesWritten());
        result.put("bytesSent", "" + this.getBytesSent());
        result.put("incomingMessageCount", "" + this.getIncomingMessageCount());
        result.put("bytesReceived", "" + this.getBytesReceived());
        result.put("bytesRead", "" + this.getBytesRead());
        return result;
    }

    public void printManagementProperties(PrintStream stream) {
        stream.format("Messages Sent: %d\n", this.getOutgoingMessageCount());
        double mbWritten = (double)this.getBytesWritten() / 1024.0 / 1024.0;
        stream.format("Data written to messages: %.2f Mb\n", mbWritten);
        double mbSent = (double)this.getBytesSent() / 1024.0 / 1024.0;
        stream.format("Data sent out on network: %.2f Mb\n", mbSent);
        stream.format("Messages Received: %d\n", this.getIncomingMessageCount());
        double mbReceived = (double)this.getBytesReceived() / 1024.0 / 1024.0;
        stream.format("Data received from network: %.2f Mb\n", mbReceived);
        double mbRead = (double)this.getBytesRead() / 1024.0 / 1024.0;
        stream.format("Data read from messages: %.2f Mb\n", mbRead);
        stream.flush();
    }

    public void setManagementProperties(Map<String, String> properties) throws NoSuchPropertyException {
        throw new NoSuchPropertyException("cannot set any properties");
    }

    public void setManagementProperty(String key, String value) throws NoSuchPropertyException {
        throw new NoSuchPropertyException("cannot set any properties");
    }

    public String getIdentifier() {
        return this.ident.toString();
    }
}

