/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.extensions.mux;

import java.net.InetSocketAddress;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.SuspendToken;
import org.eclipse.jetty.websocket.api.WebSocketException;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.api.extensions.IncomingFrames;
import org.eclipse.jetty.websocket.common.CloseInfo;
import org.eclipse.jetty.websocket.common.ConnectionState;
import org.eclipse.jetty.websocket.common.LogicalConnection;
import org.eclipse.jetty.websocket.common.WebSocketFrame;
import org.eclipse.jetty.websocket.common.WebSocketSession;
import org.eclipse.jetty.websocket.common.extensions.mux.Muxer;
import org.eclipse.jetty.websocket.common.io.FutureWriteCallback;
import org.eclipse.jetty.websocket.common.io.IOState;

public class MuxChannel
implements LogicalConnection,
IncomingFrames,
SuspendToken,
IOState.ConnectionStateListener {
    private static final Logger LOG = Log.getLogger(MuxChannel.class);
    private final long channelId;
    private final Muxer muxer;
    private final AtomicBoolean inputClosed;
    private final AtomicBoolean outputClosed;
    private final AtomicBoolean suspendToken;
    private IOState ioState;
    private WebSocketPolicy policy;
    private WebSocketSession session;
    private IncomingFrames incoming;
    private String subProtocol;

    public MuxChannel(long channelId, Muxer muxer) {
        this.channelId = channelId;
        this.muxer = muxer;
        this.policy = muxer.getPolicy().clonePolicy();
        this.suspendToken = new AtomicBoolean(false);
        this.ioState = new IOState();
        this.ioState.addListener(this);
        this.inputClosed = new AtomicBoolean(false);
        this.outputClosed = new AtomicBoolean(false);
    }

    @Override
    public void close() {
        this.close(1000, null);
    }

    @Override
    public void close(int statusCode, String reason) {
        CloseInfo close = new CloseInfo(statusCode, reason);
        this.outgoingFrame(close.asFrame(), null);
    }

    @Override
    public void disconnect() {
    }

    public long getChannelId() {
        return this.channelId;
    }

    @Override
    public IOState getIOState() {
        return null;
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return null;
    }

    @Override
    public long getMaxIdleTimeout() {
        return 0L;
    }

    @Override
    public WebSocketPolicy getPolicy() {
        return this.policy;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.muxer.getRemoteAddress();
    }

    @Override
    public WebSocketSession getSession() {
        return this.session;
    }

    @Override
    public void incomingError(WebSocketException e) {
        this.incoming.incomingError(e);
    }

    @Override
    public void incomingFrame(Frame frame) {
        this.incoming.incomingFrame(frame);
    }

    public boolean isActive() {
        return this.ioState.isOpen();
    }

    @Override
    public boolean isOpen() {
        return this.isActive() && this.muxer.isOpen();
    }

    @Override
    public boolean isReading() {
        return true;
    }

    public void onClose() {
    }

    @Override
    public void onConnectionStateChange(ConnectionState state) {
    }

    public void onOpen() {
        this.ioState.onOpened();
    }

    private Future<Void> outgoingAsyncFrame(WebSocketFrame frame) {
        FutureWriteCallback future = new FutureWriteCallback();
        this.outgoingFrame(frame, future);
        return future;
    }

    @Override
    public void outgoingFrame(Frame frame, WriteCallback callback) {
        this.muxer.output(this.channelId, frame, callback);
    }

    @Override
    public void resume() {
        if (this.suspendToken.getAndSet(false)) {
            // empty if block
        }
    }

    @Override
    public void setMaxIdleTimeout(long ms) {
    }

    @Override
    public void setNextIncomingFrames(IncomingFrames incoming) {
        this.incoming = incoming;
    }

    @Override
    public void setSession(WebSocketSession session) {
        this.session = session;
    }

    public void setSubProtocol(String subProtocol) {
        this.subProtocol = subProtocol;
    }

    @Override
    public SuspendToken suspend() {
        this.suspendToken.set(true);
        return this;
    }
}

