/*
 * Decompiled with CFR 0.152.
 */
package de.pleumann.antenna;

import de.pleumann.antenna.misc.Conditional;
import de.pleumann.antenna.misc.Utility;
import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.types.Path;

public class WtkBuild
extends Javac {
    private Conditional condition;
    private Utility utility;
    private boolean preverify = true;
    private boolean cldc = true;
    private int flags = 0;

    public void setPreverify(boolean preverify) {
        this.preverify = preverify;
    }

    public void setCldc(boolean on) {
        this.cldc = on;
    }

    public void setNonative(boolean b) {
        this.flags = b ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
    }

    public void setNofloat(boolean b) {
        this.flags = b ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
    }

    public void setNofinalize(boolean b) {
        this.flags = b ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    public void init() throws BuildException {
        super.init();
        this.utility = Utility.getInstance(this.getProject(), (Task)this);
        this.condition = new Conditional(this.getProject());
        this.setTarget("1.1");
        this.setSource("1.2");
        this.setDebug(true);
    }

    public void setIf(String s) {
        this.condition.setIf(s);
    }

    public void setUnless(String s) {
        this.condition.setUnless(s);
    }

    public boolean isActive() {
        return this.condition.isActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        if (!this.isActive()) {
            return;
        }
        File tmpDir = this.utility.getTempDir();
        try {
            String bcp;
            if (this.utility.getToolkitType() == 30) {
                bcp = this.utility.getMidpApi();
                if (this.getClasspath() == null) {
                    this.setClasspath(new Path(this.getProject(), bcp));
                } else {
                    this.getClasspath().add(new Path(this.getProject(), bcp));
                }
            } else if (this.getBootclasspath() == null) {
                bcp = this.utility.getMidpApi();
                this.setBootclasspath(new Path(this.getProject(), bcp));
            }
            File origDest = this.getDestdir();
            File tempDest = new File(tmpDir + "/tmpclasses");
            if (this.preverify) {
                this.setDestdir(tempDest);
                tempDest.mkdir();
            }
            try {
                super.execute();
            }
            finally {
                this.setDestdir(origDest);
            }
            if (this.preverify) {
                String cp = this.getBootclasspath() + File.pathSeparator + this.getClasspath() + File.pathSeparator;
                this.utility.preverify(tempDest, origDest, cp, this.cldc, this.flags);
            }
        }
        finally {
            this.utility.delete(tmpDir);
        }
    }
}

