/*
 * Decompiled with CFR 0.152.
 */
package ibis.io;

import ibis.io.DataOutputStream;
import ibis.io.Replacer;
import ibis.io.SerializationOutput;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ByteSerializationOutputStream
implements SerializationOutput {
    DataOutputStream out;

    public ByteSerializationOutputStream(DataOutputStream s) throws IOException {
        this.out = s;
    }

    protected ByteSerializationOutputStream() throws IOException {
        this.out = null;
    }

    @Override
    public String serializationImplName() {
        return "byte";
    }

    @Override
    public boolean reInitOnNewConnection() {
        return false;
    }

    @Override
    public void writeBoolean(boolean value) throws IOException {
        throw new IOException("Illegal data type written");
    }

    @Override
    public void writeByte(byte value) throws IOException {
        this.out.write(value);
    }

    @Override
    public void writeChar(char value) throws IOException {
        throw new IOException("Illegal data type written");
    }

    @Override
    public void writeShort(short value) throws IOException {
        throw new IOException("Illegal data type written");
    }

    @Override
    public void writeInt(int value) throws IOException {
        throw new IOException("Illegal data type written");
    }

    @Override
    public void writeLong(long value) throws IOException {
        throw new IOException("Illegal data type written");
    }

    @Override
    public void writeFloat(float value) throws IOException {
        throw new IOException("Illegal data type written");
    }

    @Override
    public void writeDouble(double value) throws IOException {
        throw new IOException("Illegal data type written");
    }

    @Override
    public void writeArray(boolean[] ref, int off, int len) throws IOException {
        throw new IOException("Illegal data type written");
    }

    @Override
    public void writeArray(byte[] ref, int off, int len) throws IOException {
        if (off != 0 || len != ref.length) {
            throw new IOException("Illegal data type written");
        }
        this.out.write(ref);
    }

    @Override
    public void writeArray(short[] ref, int off, int len) throws IOException {
        throw new IOException("Illegal data type written");
    }

    @Override
    public void writeArray(char[] ref, int off, int len) throws IOException {
        throw new IOException("Illegal data type written");
    }

    @Override
    public void writeArray(int[] ref, int off, int len) throws IOException {
        throw new IOException("Illegal data type written");
    }

    @Override
    public void writeArray(long[] ref, int off, int len) throws IOException {
        throw new IOException("Illegal data type written");
    }

    @Override
    public void writeArray(float[] ref, int off, int len) throws IOException {
        throw new IOException("Illegal data type written");
    }

    @Override
    public void writeArray(double[] ref, int off, int len) throws IOException {
        throw new IOException("Illegal data type written");
    }

    @Override
    public void writeArray(Object[] ref, int off, int len) throws IOException {
        throw new IOException("Illegal data type written");
    }

    @Override
    public void writeArray(boolean[] ref) throws IOException {
        this.writeArray(ref, 0, ref.length);
    }

    @Override
    public void writeArray(byte[] ref) throws IOException {
        this.writeArray(ref, 0, ref.length);
    }

    @Override
    public void writeArray(short[] ref) throws IOException {
        this.writeArray(ref, 0, ref.length);
    }

    @Override
    public void writeArray(char[] ref) throws IOException {
        this.writeArray(ref, 0, ref.length);
    }

    @Override
    public void writeArray(int[] ref) throws IOException {
        this.writeArray(ref, 0, ref.length);
    }

    @Override
    public void writeArray(long[] ref) throws IOException {
        this.writeArray(ref, 0, ref.length);
    }

    @Override
    public void writeArray(float[] ref) throws IOException {
        this.writeArray(ref, 0, ref.length);
    }

    @Override
    public void writeArray(double[] ref) throws IOException {
        this.writeArray(ref, 0, ref.length);
    }

    @Override
    public void writeArray(Object[] ref) throws IOException {
        this.writeArray(ref, 0, ref.length);
    }

    @Override
    public void statistics() {
    }

    @Override
    public void reset() throws IOException {
    }

    @Override
    public void reset(boolean cleartypes) throws IOException {
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
    }

    @Override
    public void realClose() throws IOException {
        this.close();
        this.out.close();
    }

    @Override
    public void setReplacer(Replacer replacer) throws IOException {
        throw new IOException("no replacer allowed in byte serialization");
    }

    @Override
    public void writeObject(Object obj) throws IOException {
        throw new IOException("Illegal data type written");
    }

    @Override
    public void writeString(String obj) throws IOException {
        throw new IOException("Illegal data type written");
    }

    @Override
    public void writeByteBuffer(ByteBuffer value) throws IOException {
        this.out.writeByteBuffer(value);
    }
}

