/*
 * Decompiled with CFR 0.152.
 */
package ibis.io;

import ibis.io.DataInputStream;
import ibis.io.SerializationInput;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ByteSerializationInputStream
implements SerializationInput {
    DataInputStream in;

    protected ByteSerializationInputStream() throws IOException {
        this.in = null;
    }

    public ByteSerializationInputStream(DataInputStream s) throws IOException {
        this.in = s;
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public String serializationImplName() {
        return "byte";
    }

    @Override
    public boolean reInitOnNewConnection() {
        return false;
    }

    @Override
    public void clear() {
    }

    @Override
    public void statistics() {
    }

    @Override
    public byte readByte() throws IOException {
        int b = this.in.read();
        if (b == -1) {
            throw new EOFException("end of file reached");
        }
        return (byte)b;
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.readByte() & 0xFF;
    }

    @Override
    public boolean readBoolean() throws IOException {
        throw new IOException("Illegal data type read");
    }

    @Override
    public char readChar() throws IOException {
        throw new IOException("Illegal data type read");
    }

    @Override
    public short readShort() throws IOException {
        throw new IOException("Illegal data type read");
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public int readInt() throws IOException {
        throw new IOException("Illegal data type read");
    }

    @Override
    public long readLong() throws IOException {
        throw new IOException("Illegal data type read");
    }

    @Override
    public float readFloat() throws IOException {
        throw new IOException("Illegal data type read");
    }

    @Override
    public double readDouble() throws IOException {
        throw new IOException("Illegal data type read");
    }

    @Override
    public String readString() throws IOException {
        throw new IOException("Illegal data type read");
    }

    @Override
    public Object readObject() throws IOException, ClassNotFoundException {
        throw new IOException("Illegal data type read");
    }

    @Override
    public void readArray(byte[] ref, int off, int len) throws IOException {
        if (off == 0 && ref.length == len) {
            int rd = 0;
            while ((rd += this.in.read(ref, rd, len - rd)) < len) {
            }
            return;
        }
        throw new IOException("Illegal data type read");
    }

    @Override
    public void readByteBuffer(ByteBuffer b) throws IOException {
        this.in.readByteBuffer(b);
    }

    @Override
    public void readArray(boolean[] ref, int off, int len) throws IOException {
        throw new IOException("Illegal data type read");
    }

    @Override
    public void readArray(char[] ref, int off, int len) throws IOException {
        throw new IOException("Illegal data type read");
    }

    @Override
    public void readArray(short[] ref, int off, int len) throws IOException {
        throw new IOException("Illegal data type read");
    }

    @Override
    public void readArray(int[] ref, int off, int len) throws IOException {
        throw new IOException("Illegal data type read");
    }

    @Override
    public void readArray(long[] ref, int off, int len) throws IOException {
        throw new IOException("Illegal data type read");
    }

    @Override
    public void readArray(float[] ref, int off, int len) throws IOException {
        throw new IOException("Illegal data type read");
    }

    @Override
    public void readArray(double[] ref, int off, int len) throws IOException {
        throw new IOException("Illegal data type read");
    }

    @Override
    public void readArray(Object[] ref, int off, int len) throws IOException, ClassNotFoundException {
        throw new IOException("Illegal data type read");
    }

    @Override
    public void readArray(boolean[] ref) throws IOException {
        this.readArray(ref, 0, ref.length);
    }

    @Override
    public void readArray(byte[] ref) throws IOException {
        this.readArray(ref, 0, ref.length);
    }

    @Override
    public void readArray(short[] ref) throws IOException {
        this.readArray(ref, 0, ref.length);
    }

    @Override
    public void readArray(char[] ref) throws IOException {
        this.readArray(ref, 0, ref.length);
    }

    @Override
    public void readArray(int[] ref) throws IOException {
        this.readArray(ref, 0, ref.length);
    }

    @Override
    public void readArray(long[] ref) throws IOException {
        this.readArray(ref, 0, ref.length);
    }

    @Override
    public void readArray(float[] ref) throws IOException {
        this.readArray(ref, 0, ref.length);
    }

    @Override
    public void readArray(double[] ref) throws IOException {
        this.readArray(ref, 0, ref.length);
    }

    @Override
    public void readArray(Object[] ref) throws IOException, ClassNotFoundException {
        this.readArray(ref, 0, ref.length);
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void realClose() throws IOException {
        this.close();
        this.in.close();
    }
}

