/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.virtual;

import ibis.smartsockets.direct.DirectSocketAddress;
import ibis.smartsockets.util.MalformedAddressException;
import ibis.smartsockets.util.TransferUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;

public class VirtualSocketAddress
extends SocketAddress
implements Serializable {
    private static final long serialVersionUID = 3340517955293464166L;
    private final DirectSocketAddress machine;
    private final int port;
    private final DirectSocketAddress hub;
    private final String cluster;
    private transient byte[] codedForm;

    public VirtualSocketAddress(DataInput in) throws IOException, MalformedAddressException {
        short mlen = in.readShort();
        short hlen = in.readShort();
        short clen = in.readShort();
        byte[] m = new byte[mlen];
        in.readFully(m);
        this.machine = DirectSocketAddress.fromBytes(m);
        this.port = in.readInt();
        if (hlen > 0) {
            byte[] h = new byte[hlen];
            in.readFully(h);
            this.hub = DirectSocketAddress.fromBytes(h);
        } else {
            this.hub = null;
        }
        if (clen > 0) {
            byte[] c = new byte[clen];
            in.readFully(c);
            this.cluster = new String(c);
        } else {
            this.cluster = null;
        }
    }

    public VirtualSocketAddress(DirectSocketAddress machine, int port) {
        this(machine, port, null, null);
    }

    public VirtualSocketAddress(DirectSocketAddress machine, int port, DirectSocketAddress hub, String cluster) {
        this.hub = hub;
        this.machine = machine;
        this.port = port;
        this.cluster = cluster;
    }

    public VirtualSocketAddress(String address) throws UnknownHostException, MalformedAddressException {
        int index1 = address.lastIndexOf(64);
        int index2 = address.lastIndexOf(35);
        if (index2 < index1) {
            this.hub = DirectSocketAddress.getByAddress(address.substring(index1 + 1));
            if (index2 != -1) {
                this.cluster = address.substring(index2 + 1, index1);
                address = address.substring(0, index2);
            } else {
                this.cluster = null;
                address = address.substring(0, index1);
            }
        } else if (index2 > index1) {
            this.cluster = address.substring(index2 + 1);
            if (index1 != -1) {
                this.hub = DirectSocketAddress.getByAddress(address.substring(index1 + 1, index2));
                address = address.substring(0, index1);
            } else {
                address = address.substring(0, index2);
                this.hub = null;
            }
        } else {
            this.cluster = null;
            this.hub = null;
        }
        int index = address.lastIndexOf(58);
        if (index == -1) {
            throw new MalformedAddressException("String \"" + address + "\" does not contain VirtualSocketAddress!");
        }
        try {
            this.machine = DirectSocketAddress.getByAddress(address.substring(0, index));
            this.port = Integer.parseInt(address.substring(index + 1));
        }
        catch (NumberFormatException e) {
            throw new MalformedAddressException("String \"" + address + "\" does not contain VirtualSocketAddress!", e);
        }
    }

    public VirtualSocketAddress(String machine, int port) throws UnknownHostException, MalformedAddressException {
        this(DirectSocketAddress.getByAddress(machine), port, null, null);
    }

    public VirtualSocketAddress(String hub, String machine, int port) throws UnknownHostException, MalformedAddressException {
        this(DirectSocketAddress.getByAddress(machine), port, DirectSocketAddress.getByAddress(hub), null);
    }

    public void write(DataOutput out) throws IOException {
        byte[] m = this.machine.getAddress();
        byte[] h = null;
        if (this.hub != null) {
            h = this.hub.getAddress();
        }
        byte[] c = null;
        if (this.cluster != null) {
            c = this.cluster.getBytes();
        }
        out.writeShort(m.length);
        out.writeShort(h == null ? 0 : h.length);
        out.writeShort(c == null ? 0 : c.length);
        out.write(m);
        out.writeInt(this.port);
        if (h != null) {
            out.write(h);
        }
        if (c != null) {
            out.write(c);
        }
    }

    public DirectSocketAddress hub() {
        return this.hub;
    }

    public DirectSocketAddress machine() {
        return this.machine;
    }

    public String cluster() {
        return this.cluster;
    }

    public int port() {
        return this.port;
    }

    public byte[] toBytes() {
        if (this.codedForm == null) {
            byte[] m = this.machine.getAddress();
            byte[] h = this.hub == null ? new byte[]{} : this.hub.getAddress();
            byte[] c = this.cluster == null ? new byte[]{} : this.cluster.getBytes();
            int len = 10 + m.length;
            if (h != null) {
                len += h.length;
            }
            if (c != null) {
                len += c.length;
            }
            this.codedForm = new byte[len];
            TransferUtils.storeShort((short)m.length, this.codedForm, 0);
            TransferUtils.storeShort((short)h.length, this.codedForm, 2);
            TransferUtils.storeShort((short)c.length, this.codedForm, 4);
            System.arraycopy(m, 0, this.codedForm, 6, m.length);
            int off = 6 + m.length;
            TransferUtils.storeInt(this.port, this.codedForm, off);
            System.arraycopy(h, 0, this.codedForm, off += 4, h.length);
            System.arraycopy(c, 0, this.codedForm, off += h.length, c.length);
        }
        return (byte[])this.codedForm.clone();
    }

    public String toString() {
        return this.machine.toString() + ":" + this.port + (this.hub == null ? "" : "@" + this.hub.toString()) + (this.cluster == null ? "" : "#" + this.cluster);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof VirtualSocketAddress)) {
            return false;
        }
        VirtualSocketAddress tmp = (VirtualSocketAddress)other;
        if (this.port != tmp.port) {
            return false;
        }
        return this.machine.equals(tmp.machine);
    }

    public int hashCode() {
        return this.machine.hashCode() ^ this.port;
    }

    public static VirtualSocketAddress fromBytes(byte[] source, int offset) throws UnknownHostException, MalformedAddressException {
        short mlen = TransferUtils.readShort(source, offset);
        short hlen = TransferUtils.readShort(source, offset + 2);
        short clen = TransferUtils.readShort(source, offset + 4);
        int off = offset + 6;
        DirectSocketAddress machine = DirectSocketAddress.fromBytes(source, off);
        int port = TransferUtils.readInt(source, off += mlen);
        off += 4;
        DirectSocketAddress hub = null;
        if (hlen > 0) {
            hub = DirectSocketAddress.fromBytes(source, off);
            off += hlen;
        }
        String cluster = null;
        if (clen > 0) {
            cluster = new String(source, off, (int)clen);
        }
        return new VirtualSocketAddress(machine, port, hub, cluster);
    }

    public static VirtualSocketAddress partialAddress(InetAddress host, int realport, int virtualport) throws UnknownHostException {
        return new VirtualSocketAddress(DirectSocketAddress.getByAddress(new InetSocketAddress(host, realport)), virtualport);
    }

    public static VirtualSocketAddress partialAddress(String hostname, int realport, int virtualport) throws UnknownHostException {
        return new VirtualSocketAddress(DirectSocketAddress.getByAddress(hostname, realport), virtualport);
    }

    public static VirtualSocketAddress partialAddress(String hostname, int port) throws UnknownHostException {
        return VirtualSocketAddress.partialAddress(hostname, port, port);
    }

    public static VirtualSocketAddress partialAddress(InetAddress host, int port) throws UnknownHostException {
        return VirtualSocketAddress.partialAddress(host, port, port);
    }
}

