/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.util.net;

import ibis.smartsockets.util.InetAddressCache;
import ibis.smartsockets.util.net.NetworkInfo;
import java.util.List;
import java.util.regex.Pattern;

public abstract class NetworkInfoParser {
    protected static final Pattern macPattern = Pattern.compile("([0-9a-fA-F]{2}[\\-:]){5}[0-9a-fA-F]{2}");
    protected static final Pattern ipv4Pattern = Pattern.compile("\\A(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3}\\z");
    protected static final Pattern ipv6Pattern = Pattern.compile("\\A(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}\\z");
    protected static final Pattern ipv6PatternHexCompressed = Pattern.compile("\\A((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)\\z");
    protected static final Pattern ipv6Pattern6Hex4Dec = Pattern.compile("\\A((?:[0-9A-Fa-f]{1,4}:){6,6})(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3}\\z");
    protected static final Pattern ipv6Pattern6Hex4DecCompressed = Pattern.compile("\\A((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}:)*)(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3}\\z");
    public final String osName;

    protected static final boolean isMacAddress(String mac) {
        return macPattern.matcher(mac).matches();
    }

    public static boolean isIPv4Address(String ip) {
        return ipv4Pattern.matcher(ip).matches();
    }

    public static boolean isIPv6Address(String ip) {
        return ipv6Pattern.matcher(ip).matches() || ipv6Pattern6Hex4Dec.matcher(ip).matches() || ipv6Pattern6Hex4DecCompressed.matcher(ip).matches() || ipv6PatternHexCompressed.matcher(ip).matches();
    }

    protected static final String getIPv4Field(String line, String header) {
        int index = line.indexOf(header);
        if (index >= 0) {
            String tmp = line.substring(index + header.length()).trim();
            if ((index = tmp.indexOf(32)) >= 0) {
                tmp = tmp.substring(0, index).trim();
            }
            if (NetworkInfoParser.isIPv4Address(tmp)) {
                return tmp;
            }
        }
        return null;
    }

    protected static final String getIPv6Field(String line, String header) {
        int index = line.indexOf(header);
        if (index >= 0) {
            String tmp = line.substring(index + header.length()).trim();
            if ((index = tmp.indexOf(32)) > 0) {
                tmp = tmp.substring(0, index).trim();
            }
            if ((index = tmp.indexOf(47)) > 0) {
                String tmp1 = tmp.substring(0, index).trim();
                if (NetworkInfoParser.isIPv6Address(tmp1)) {
                    return tmp1;
                }
            } else if (NetworkInfoParser.isIPv6Address(tmp)) {
                return tmp;
            }
        }
        return null;
    }

    protected static final byte[] ipStringToBytes(String ip) {
        try {
            return InetAddressCache.getByName(ip).getAddress();
        }
        catch (Exception e) {
            return null;
        }
    }

    protected NetworkInfoParser(String osName) {
        this.osName = osName;
    }

    abstract int numberOfCommands();

    abstract String[] getCommand(int var1);

    abstract boolean parse(byte[] var1, List<NetworkInfo> var2);
}

