/*
 * Decompiled with CFR 0.152.
 */
package ibis.smartsockets.util;

import java.util.LinkedHashMap;
import java.util.Map;

public class FixedSizeHashMap<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = 5652104148565673432L;
    private static final int DEFAULT_MAX_ENTRIES = 25;
    private final int MAX_ENTRIES;

    public FixedSizeHashMap() {
        this(25);
    }

    public FixedSizeHashMap(int size) {
        this.MAX_ENTRIES = size;
    }

    public FixedSizeHashMap(int size, int initialCapacity) {
        super(initialCapacity);
        this.MAX_ENTRIES = size;
    }

    public FixedSizeHashMap(int size, int initialCapacity, float loadfact) {
        super(initialCapacity, loadfact);
        this.MAX_ENTRIES = size;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return this.size() > this.MAX_ENTRIES;
    }
}

