/*
 * Decompiled with CFR 0.152.
 */
package nl.esciencecenter.xenon.schedulers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class JobDescription {
    public static final int DEFAULT_MAX_RUN_TIME_IN_MINUTES = 15;
    private String queueName = null;
    private String executable = null;
    private final List<String> arguments = new ArrayList<String>(10);
    private String stdin = null;
    private String stdout = null;
    private String stderr = null;
    private String workingDirectory = null;
    private final Map<String, String> environment = new HashMap<String, String>(5);
    private final Map<String, String> jobOptions = new HashMap<String, String>(5);
    private int nodeCount = 1;
    private int processesPerNode = 1;
    private boolean startSingleProcess = false;
    private int maxRuntime = 15;

    public JobDescription() {
    }

    public JobDescription(JobDescription original) {
        this.queueName = original.getQueueName();
        this.executable = original.getExecutable();
        this.arguments.addAll(original.getArguments());
        this.stdin = original.getStdin();
        this.stdout = original.getStdout();
        this.stderr = original.getStderr();
        this.workingDirectory = original.getWorkingDirectory();
        this.environment.putAll(original.getEnvironment());
        this.jobOptions.putAll(original.getJobOptions());
        this.nodeCount = original.getNodeCount();
        this.processesPerNode = original.getProcessesPerNode();
        this.startSingleProcess = original.isStartSingleProcess();
        this.maxRuntime = original.getMaxRuntime();
    }

    public int getNodeCount() {
        return this.nodeCount;
    }

    public void setNodeCount(int nodeCount) {
        this.nodeCount = nodeCount;
    }

    public int getProcessesPerNode() {
        return this.processesPerNode;
    }

    public void setProcessesPerNode(int processesPerNode) {
        this.processesPerNode = processesPerNode;
    }

    public boolean isStartSingleProcess() {
        return this.startSingleProcess;
    }

    public void setStartSingleProcess(boolean startSingleProcess) {
        this.startSingleProcess = startSingleProcess;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public int getMaxRuntime() {
        return this.maxRuntime;
    }

    public void setMaxRuntime(int minutes) {
        this.maxRuntime = minutes;
    }

    public String getExecutable() {
        return this.executable;
    }

    public void setExecutable(String executable) {
        this.executable = executable;
    }

    public List<String> getArguments() {
        return Collections.unmodifiableList(this.arguments);
    }

    public void setArguments(String ... arguments) {
        this.arguments.clear();
        for (String argument : arguments) {
            this.addArgument(argument);
        }
    }

    public void addArgument(String argument) {
        if (argument == null || argument.length() == 0) {
            throw new IllegalArgumentException("Argument may not be null or empty!");
        }
        this.arguments.add(argument);
    }

    public Map<String, String> getEnvironment() {
        return Collections.unmodifiableMap(this.environment);
    }

    public void setEnvironment(Map<String, String> environment) {
        this.environment.clear();
        if (environment != null) {
            for (Map.Entry<String, String> entry : environment.entrySet()) {
                this.addEnvironment(entry.getKey(), entry.getValue());
            }
        }
    }

    public void addEnvironment(String key, String value) {
        if (key == null || key.length() == 0) {
            throw new IllegalArgumentException("Envrionment variable name may not be null or empty!");
        }
        this.environment.put(key, value);
    }

    public Map<String, String> getJobOptions() {
        return Collections.unmodifiableMap(this.jobOptions);
    }

    public void setJobOptions(Map<String, String> options) {
        this.jobOptions.clear();
        if (options != null) {
            for (Map.Entry<String, String> entry : options.entrySet()) {
                this.addJobOption(entry.getKey(), entry.getValue());
            }
        }
    }

    public void addJobOption(String key, String value) {
        if (key == null || key.length() == 0) {
            throw new IllegalArgumentException("Job option key may not be null or empty!");
        }
        if (value == null || value.length() == 0) {
            throw new IllegalArgumentException("Job option value may not be null or empty!");
        }
        this.jobOptions.put(key, value);
    }

    public void setStdin(String stdin) {
        this.stdin = stdin;
    }

    public void setStdout(String stdout) {
        this.stdout = stdout;
    }

    public void setStderr(String stderr) {
        this.stderr = stderr;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public String getStdin() {
        return this.stdin;
    }

    public String getStdout() {
        return this.stdout;
    }

    public String getStderr() {
        return this.stderr;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public String toString() {
        return "JobDescription [queueName=" + this.queueName + ", executable=" + this.executable + ", arguments=" + this.arguments + ", stdin=" + this.stdin + ", stdout=" + this.stdout + ", stderr=" + this.stderr + ", workingDirectory=" + this.workingDirectory + ", environment=" + this.environment + ", jobOptions=" + this.jobOptions + ", nodeCount=" + this.nodeCount + ", processesPerNode=" + this.processesPerNode + ", startSingleProcess=" + this.startSingleProcess + ", maxTime=" + this.maxRuntime + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.arguments.hashCode();
        result = 31 * result + this.environment.hashCode();
        result = 31 * result + (this.executable == null ? 0 : this.executable.hashCode());
        result = 31 * result + this.jobOptions.hashCode();
        result = 31 * result + this.maxRuntime;
        result = 31 * result + this.nodeCount;
        result = 31 * result + this.processesPerNode;
        result = 31 * result + (this.queueName == null ? 0 : this.queueName.hashCode());
        result = 31 * result + (this.startSingleProcess ? 1231 : 1237);
        result = 31 * result + (this.stderr == null ? 0 : this.stderr.hashCode());
        result = 31 * result + (this.stdin == null ? 0 : this.stdin.hashCode());
        result = 31 * result + (this.stdout == null ? 0 : this.stdout.hashCode());
        result = 31 * result + (this.workingDirectory == null ? 0 : this.workingDirectory.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        JobDescription other = (JobDescription)obj;
        return this.maxRuntime == other.maxRuntime && this.nodeCount == other.nodeCount && this.startSingleProcess == other.startSingleProcess && this.processesPerNode == other.processesPerNode && Objects.equals(this.executable, other.executable) && Objects.equals(this.workingDirectory, other.workingDirectory) && Objects.equals(this.queueName, other.queueName) && Objects.equals(this.stdin, other.stdin) && Objects.equals(this.stdout, other.stdout) && Objects.equals(this.stderr, other.stderr) && Objects.equals(this.arguments, other.arguments) && Objects.equals(this.environment, other.environment) && Objects.equals(this.jobOptions, other.jobOptions);
    }
}

