/*
 * Decompiled with CFR 0.152.
 */
package nl.esciencecenter.xenon.adaptors.schedulers.local;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import nl.esciencecenter.xenon.XenonException;
import nl.esciencecenter.xenon.adaptors.schedulers.InteractiveProcess;
import nl.esciencecenter.xenon.adaptors.schedulers.StreamsImplementation;
import nl.esciencecenter.xenon.adaptors.schedulers.local.CommandRunner;
import nl.esciencecenter.xenon.schedulers.JobDescription;
import nl.esciencecenter.xenon.schedulers.Streams;
import nl.esciencecenter.xenon.utils.LocalFileSystemUtils;

class LocalInteractiveProcess
implements InteractiveProcess {
    private final Process process;
    private int exitCode;
    private boolean done;
    private final Streams streams;

    LocalInteractiveProcess(JobDescription description, String jobIdentifier) throws XenonException {
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.command().add(description.getExecutable());
        builder.command().addAll(description.getArguments());
        builder.environment().putAll(description.getEnvironment());
        String workingDirectory = description.getWorkingDirectory();
        if (workingDirectory == null) {
            workingDirectory = System.getProperty("user.dir");
        }
        builder.directory(new File(workingDirectory));
        try {
            this.process = builder.start();
        }
        catch (IOException e) {
            throw new XenonException("local", "Failed to start local process!", e);
        }
        this.streams = new StreamsImplementation(jobIdentifier, this.process.getInputStream(), this.process.getOutputStream(), this.process.getErrorStream());
    }

    @Override
    public Streams getStreams() {
        return this.streams;
    }

    @Override
    public boolean isDone() {
        if (this.done) {
            return true;
        }
        try {
            this.exitCode = this.process.exitValue();
            this.done = true;
            return true;
        }
        catch (IllegalThreadStateException e) {
            return false;
        }
    }

    @Override
    public int getExitStatus() {
        return this.exitCode;
    }

    @Override
    public void destroy() {
        if (this.done) {
            return;
        }
        boolean success = false;
        if (!LocalFileSystemUtils.isWindows()) {
            try {
                final Field pidField = this.process.getClass().getDeclaredField("pid");
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        pidField.setAccessible(true);
                        return null;
                    }
                });
                int pid = pidField.getInt(this.process);
                if (pid > 0) {
                    CommandRunner killRunner = new CommandRunner("kill", "-9", "" + pid);
                    success = killRunner.getExitCode() == 0;
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException | XenonException exception) {
                // empty catch block
            }
        }
        if (!success) {
            this.process.destroy();
        }
    }
}

