/*
 * Decompiled with CFR 0.152.
 */
package nl.esciencecenter.xenon.adaptors.schedulers.gridengine;

import java.util.HashMap;
import java.util.Map;
import nl.esciencecenter.xenon.XenonException;
import nl.esciencecenter.xenon.adaptors.schedulers.CommandLineUtils;
import nl.esciencecenter.xenon.adaptors.schedulers.RemoteCommandRunner;
import nl.esciencecenter.xenon.adaptors.schedulers.ScriptingParser;
import nl.esciencecenter.xenon.adaptors.schedulers.gridengine.GridEngineScheduler;
import nl.esciencecenter.xenon.adaptors.schedulers.gridengine.ParallelEnvironmentInfo;
import nl.esciencecenter.xenon.adaptors.schedulers.gridengine.QueueInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GridEngineSetup {
    private static final Logger LOGGER = LoggerFactory.getLogger(GridEngineSetup.class);
    private final String[] queueNames;
    private final Map<String, QueueInfo> queues;
    private final Map<String, ParallelEnvironmentInfo> parallelEnvironments;

    protected static String[] qconfPeDetailsArguments(String[] parallelEnvironmentNames) {
        String[] result = new String[parallelEnvironmentNames.length * 2];
        for (int i = 0; i < parallelEnvironmentNames.length; ++i) {
            result[2 * i] = "-sp";
            result[2 * i + 1] = parallelEnvironmentNames[i];
        }
        return result;
    }

    private static String[] getQueueNames(GridEngineScheduler scheduler) throws XenonException {
        String queueListOutput = scheduler.runCheckedCommand(null, "qconf", "-sql");
        return ScriptingParser.parseList(queueListOutput);
    }

    private static Map<String, QueueInfo> getQueues(String[] queueNames, GridEngineScheduler scheduler) throws XenonException {
        String output = scheduler.runCheckedCommand(null, "qconf", "-sq", CommandLineUtils.asCSList(queueNames));
        Map<String, Map<String, String>> maps = ScriptingParser.parseKeyValueRecords(output, "qname", ScriptingParser.WHITESPACE_REGEX, "gridengine", new String[0]);
        HashMap<String, QueueInfo> result = new HashMap<String, QueueInfo>();
        for (Map.Entry<String, Map<String, String>> entry : maps.entrySet()) {
            result.put(entry.getKey(), new QueueInfo(entry.getValue()));
        }
        return result;
    }

    public GridEngineSetup(GridEngineScheduler scheduler) throws XenonException {
        this.queueNames = GridEngineSetup.getQueueNames(scheduler);
        this.queues = GridEngineSetup.getQueues(this.queueNames, scheduler);
        this.parallelEnvironments = GridEngineSetup.getParallelEnvironments(scheduler);
        LOGGER.debug("Created setup info, queues = {}, parallel environments = {}", this.queues, this.parallelEnvironments);
    }

    private static Map<String, ParallelEnvironmentInfo> getParallelEnvironments(GridEngineScheduler scheduler) throws XenonException {
        RemoteCommandRunner runner = scheduler.runCommand(null, "qconf", "-spl");
        if (runner.getExitCode() == 1 && runner.getStderr().contains("no parallel environment defined")) {
            return new HashMap<String, ParallelEnvironmentInfo>();
        }
        if (!runner.success()) {
            throw new XenonException("gridengine", "Could not get parallel environment info from scheduler: " + runner);
        }
        String[] parallelEnvironmentNames = ScriptingParser.parseList(runner.getStdout());
        String peDetailsOutput = scheduler.runCheckedCommand(null, "qconf", GridEngineSetup.qconfPeDetailsArguments(parallelEnvironmentNames));
        Map<String, Map<String, String>> maps = ScriptingParser.parseKeyValueRecords(peDetailsOutput, "pe_name", ScriptingParser.WHITESPACE_REGEX, "gridengine", new String[0]);
        HashMap<String, ParallelEnvironmentInfo> result = new HashMap<String, ParallelEnvironmentInfo>();
        for (Map.Entry<String, Map<String, String>> entry : maps.entrySet()) {
            result.put(entry.getKey(), new ParallelEnvironmentInfo(entry.getValue()));
        }
        return result;
    }

    GridEngineSetup(String[] queueNames, Map<String, QueueInfo> queues, Map<String, ParallelEnvironmentInfo> parallelEnvironments) {
        this.queueNames = (String[])queueNames.clone();
        this.queues = queues;
        this.parallelEnvironments = parallelEnvironments;
    }

    public String[] getQueueNames() {
        return (String[])this.queueNames.clone();
    }

    protected int calculateSlots(String parallelEnvironmentName, String queueName, int nodeCount) throws XenonException {
        ParallelEnvironmentInfo pe = this.parallelEnvironments.get(parallelEnvironmentName);
        QueueInfo queue = this.queues.get(queueName);
        if (pe == null) {
            throw new XenonException("gridengine", "requested parallel environment \"" + parallelEnvironmentName + "\" cannot be found at server");
        }
        if (queue == null) {
            throw new XenonException("gridengine", "requested queue \"" + queueName + "\" cannot be found at server");
        }
        LOGGER.debug("Calculating slots to get {} nodes in queue \"{}\" with parallel environment \"{}\" and allocation rule \"{}\" with ppn {}", new Object[]{nodeCount, queueName, parallelEnvironmentName, pe.getAllocationRule(), pe.getPpn()});
        ParallelEnvironmentInfo.AllocationRule allocationRule = pe.getAllocationRule();
        if (allocationRule == ParallelEnvironmentInfo.AllocationRule.PE_SLOTS) {
            if (nodeCount > 1) {
                throw new XenonException("gridengine", "Parallel environment " + parallelEnvironmentName + " only supports single node parallel jobs");
            }
            return 1;
        }
        if (allocationRule == ParallelEnvironmentInfo.AllocationRule.FILL_UP) {
            return nodeCount * queue.getSlots();
        }
        if (allocationRule == ParallelEnvironmentInfo.AllocationRule.ROUND_ROBIN) {
            if (nodeCount > 1) {
                throw new XenonException("gridengine", "Parallel environment " + parallelEnvironmentName + " only supports single node parallel jobs, as the round robin allocation rule places jobs on a undeterministic number of nodes");
            }
            return 1;
        }
        if (allocationRule == ParallelEnvironmentInfo.AllocationRule.INTEGER) {
            return nodeCount * pe.getPpn();
        }
        throw new XenonException("gridengine", "unknown pe allocation rule: " + (Object)((Object)pe.getAllocationRule()));
    }
}

