/*
 * Decompiled with CFR 0.152.
 */
package nl.esciencecenter.xenon.adaptors.schedulers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import nl.esciencecenter.xenon.InvalidPropertyException;
import nl.esciencecenter.xenon.UnknownPropertyException;
import nl.esciencecenter.xenon.XenonException;
import nl.esciencecenter.xenon.XenonPropertyDescription;
import nl.esciencecenter.xenon.adaptors.XenonProperties;
import nl.esciencecenter.xenon.adaptors.schedulers.local.LocalSchedulerAdaptor;
import nl.esciencecenter.xenon.adaptors.schedulers.ssh.SshSchedulerAdaptor;
import nl.esciencecenter.xenon.schedulers.IncompleteJobDescriptionException;
import nl.esciencecenter.xenon.schedulers.InvalidJobDescriptionException;
import nl.esciencecenter.xenon.schedulers.JobDescription;

public class ScriptingUtils {
    private ScriptingUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static boolean isLocal(String location) {
        return location == null || location.length() == 0 || location.startsWith("local://");
    }

    public static boolean isSSH(String location) {
        return location != null && location.startsWith("ssh://");
    }

    public static XenonPropertyDescription[] mergeValidProperties(XenonPropertyDescription[] ... prop) {
        if (prop == null || prop.length == 0) {
            return new XenonPropertyDescription[0];
        }
        ArrayList<XenonPropertyDescription> tmp = new ArrayList<XenonPropertyDescription>();
        for (XenonPropertyDescription[] pa : prop) {
            if (pa == null) continue;
            tmp.addAll(Arrays.asList(pa));
        }
        return tmp.toArray(new XenonPropertyDescription[tmp.size()]);
    }

    public static XenonProperties getProperties(XenonPropertyDescription[] validProperties, String location, Map<String, String> properties) throws UnknownPropertyException, InvalidPropertyException {
        if (ScriptingUtils.isLocal(location)) {
            return new XenonProperties(ScriptingUtils.mergeValidProperties(validProperties, LocalSchedulerAdaptor.VALID_PROPERTIES), properties);
        }
        return new XenonProperties(ScriptingUtils.mergeValidProperties(validProperties, SshSchedulerAdaptor.VALID_PROPERTIES), properties);
    }

    public static void verifyJobDescription(JobDescription description, String adaptorName) throws XenonException {
        String executable = description.getExecutable();
        if (executable == null) {
            throw new IncompleteJobDescriptionException(adaptorName, "Executable missing in JobDescription!");
        }
        int nodeCount = description.getNodeCount();
        if (nodeCount < 1) {
            throw new InvalidJobDescriptionException(adaptorName, "Illegal node count: " + nodeCount);
        }
        int processesPerNode = description.getProcessesPerNode();
        if (processesPerNode < 1) {
            throw new InvalidJobDescriptionException(adaptorName, "Illegal processes per node count: " + processesPerNode);
        }
        int maxTime = description.getMaxRuntime();
        if (maxTime <= 0) {
            throw new InvalidJobDescriptionException(adaptorName, "Illegal maximum runtime: " + maxTime);
        }
    }

    public static void verifyJobOptions(Map<String, String> options, String[] validOptions, String adaptorName) throws InvalidJobDescriptionException {
        for (String option : options.keySet()) {
            boolean found = false;
            for (String validOption : validOptions) {
                if (!validOption.equals(option)) continue;
                found = true;
            }
            if (found) continue;
            throw new InvalidJobDescriptionException(adaptorName, "Given Job option \"" + option + "\" not supported");
        }
    }

    public static void verifyJobInfo(Map<String, String> jobInfo, String jobIdentifier, String adaptorName, String jobIDField, String ... additionalFields) throws XenonException {
        if (jobInfo == null) {
            throw new XenonException(adaptorName, "Job " + jobIdentifier + " not found in job info");
        }
        String jobID = jobInfo.get(jobIDField);
        if (jobID == null) {
            throw new XenonException(adaptorName, "Invalid job info. Info does not contain job id");
        }
        if (!jobID.equals(jobIdentifier)) {
            throw new XenonException(adaptorName, "Invalid job info. Found job id \"" + jobID + "\" does not match " + jobIdentifier);
        }
        for (String field : additionalFields) {
            if (jobInfo.containsKey(field)) continue;
            throw new XenonException(adaptorName, "Invalid job info. Info does not contain mandatory field \"" + field + "\"");
        }
    }
}

