$(document).ready(function () {
  $("li:eq(4)").addClass("active");
});

function GetGraphData() {
  var e = document.getElementById("graph-state");
  var state_name = e.options[e.selectedIndex].text;
  var p = document.getElementById("daily");
  var daily = p.options[p.selectedIndex].text;
  var q = document.getElementById("cond-id");
  var condition = q.options[q.selectedIndex].text;
  if (daily === "Yes") {
    var q = "Daily";
  } else {
    var q = "Cumulative";
  }
  $.post(
    "/Graph",
    {
      state_data: JSON.stringify(state_name),
      daily_data: JSON.stringify(daily),
      condition_data: JSON.stringify(condition),
    },
    function (data, status, xhr) {
      // var df = JSON.parse(data);
      // console.log(data[1]);
      // console.log(Object.keys(df[1]).slice(1));
      // console.log(Object.values(df[df.length - 1]).slice(1));
      var ctx = document.getElementById("graph").getContext("2d");
      if (condition != "Together") {
        var myChart = new Chart(ctx, {
          type: "line",

          data: {
            labels: Object.keys(data[0]).slice(1),
            datasets: [
              {
                label: state_name + " " + q + " Count cases " + condition,
                data: Object.values(data[data.length - 1]).slice(1),
                backgroundColor: [
                  "rgba(255, 99, 132, 0.2)",
                  // "rgba(54, 162, 235, 0.2)",
                  // "rgba(255, 206, 86, 0.2)",
                  // "rgba(75, 192, 192, 0.2)",
                  // "rgba(153, 102, 255, 0.2)",
                  // "rgba(255, 159, 64, 0.2)",
                ],
                borderColor: [
                  "rgba(255, 99, 132, 1)",
                  // "rgba(54, 162, 235, 1)",
                  // "rgba(255, 206, 86, 1)",
                  // "rgba(75, 192, 192, 1)",
                  // "rgba(153, 102, 255, 1)",
                  // "rgba(255, 159, 64, 1)",
                ],
                fill: false,
                borderWidth: 1,
              },
            ],
          },
          options: {
            scales: {
              yAxes: [
                {
                  ticks: {
                    beginAtZero: true,
                  },
                },
              ],
            },
          },
        });
      } else {
        var df_1 = JSON.parse(data[0]);
        var df_2 = JSON.parse(data[1]);
        var df_3 = JSON.parse(data[2]);
        var myChart = new Chart(ctx, {
          type: "line",

          data: {
            labels: Object.keys(df_1[0]).slice(1),
            datasets: [
              {
                label: state_name + " " + q + " Count cases for Confirmed",
                data: Object.values(df_1[df_1.length - 1]).slice(1),
                backgroundColor: [
                  "rgba(255, 99, 132, 0.2)",
                  // "rgba(54, 162, 235, 0.2)",
                  // "rgba(255, 206, 86, 0.2)",
                  // "rgba(75, 192, 192, 0.2)",
                  // "rgba(153, 102, 255, 0.2)",
                  // "rgba(255, 159, 64, 0.2)",
                ],
                borderColor: [
                  "rgba(255, 99, 132, 1)",
                  // "rgba(54, 162, 235, 1)",
                  // "rgba(255, 206, 86, 1)",
                  // "rgba(75, 192, 192, 1)",
                  // "rgba(153, 102, 255, 1)",
                  // "rgba(255, 159, 64, 1)",
                ],
                fill: false,
                borderWidth: 1,
              },
              {
                label: state_name + " " + q + " Count cases for Recovered",
                data: Object.values(df_2[df_2.length - 1]).slice(1),
                backgroundColor: [
                  // "rgba(255, 99, 132, 0.2)",
                  "rgba(54, 162, 235, 0.2)",
                  // "rgba(255, 206, 86, 0.2)",
                  // "rgba(75, 192, 192, 0.2)",
                  // "rgba(153, 102, 255, 0.2)",
                  // "rgba(255, 159, 64, 0.2)",
                ],
                borderColor: [
                  // "rgba(255, 99, 132, 1)",
                  "rgba(54, 162, 235, 1)",
                  // "rgba(255, 206, 86, 1)",
                  // "rgba(75, 192, 192, 1)",
                  // "rgba(153, 102, 255, 1)",
                  // "rgba(255, 159, 64, 1)",
                ],
                fill: false,
                borderWidth: 1,
              },
              {
                label: state_name + " " + q + " Count cases for Deceased",
                data: Object.values(df_3[df_3.length - 1]).slice(1),
                backgroundColor: [
                  // "rgba(255, 99, 132, 0.2)",
                  // "rgba(54, 162, 235, 0.2)",
                  // "rgba(255, 206, 86, 0.2)",
                  // "rgba(75, 192, 192, 0.2)",
                  // "rgba(153, 102, 255, 0.2)",
                  "rgba(255, 159, 64, 0.2)",
                ],
                borderColor: [
                  // "rgba(255, 99, 132, 1)",
                  // "rgba(54, 162, 235, 1)",
                  // "rgba(255, 206, 86, 1)",
                  // "rgba(75, 192, 192, 1)",
                  // "rgba(153, 102, 255, 1)",
                  "rgba(255, 159, 64, 1)",
                ],
                fill: false,
                borderWidth: 1,
              },
            ],
          },
          options: {
            scales: {
              yAxes: [
                {
                  ticks: {
                    beginAtZero: true,
                  },
                },
              ],
            },
          },
        });
      }
    }
  );
}
