import inspect
import typing

from vkbottle_types.objects import PrettyCardsPrettyCard

from .base_response import BaseResponse


class CreateResponse(BaseResponse):
    response: "CreateResponseModel"


class DeleteResponse(BaseResponse):
    response: "DeleteResponseModel"


class EditResponse(BaseResponse):
    response: "EditResponseModel"


class GetByIdResponse(BaseResponse):
    response: typing.List["PrettyCardsPrettyCard"]


class GetUploadURLResponse(BaseResponse):
    response: str


class GetResponse(BaseResponse):
    response: "GetResponseModel"


class CreateResponseModel(BaseResponse):
    owner_id: typing.Optional[int] = None
    card_id: typing.Optional[str] = None


class DeleteResponseModel(BaseResponse):
    owner_id: typing.Optional[int] = None
    card_id: typing.Optional[str] = None
    error: typing.Optional[str] = None


class EditResponseModel(BaseResponse):
    owner_id: typing.Optional[int] = None
    card_id: typing.Optional[str] = None


class GetResponseModel(BaseResponse):
    count: typing.Optional[int] = None
    items: typing.Optional[typing.List["PrettyCardsPrettyCard"]] = None


for item in locals().copy().values():
    if inspect.isclass(item) and issubclass(item, BaseResponse):
        item.update_forward_refs()
