/*
 * Decompiled with CFR 0.152.
 */
package com.github.viclovsky.swagger.coverage.core.writer;

import com.github.viclovsky.swagger.coverage.core.model.OperationKey;
import com.github.viclovsky.swagger.coverage.core.results.Results;
import com.github.viclovsky.swagger.coverage.core.results.data.OperationResult;
import com.github.viclovsky.swagger.coverage.core.writer.CoverageResultsWriter;
import io.swagger.v3.oas.models.Operation;
import java.text.DecimalFormat;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class LogResultsWriter
implements CoverageResultsWriter {
    private static final Logger LOGGER = Logger.getLogger(LogResultsWriter.class);

    @Override
    public void write(Results results) {
        LOGGER.info((Object)"Deprecated coverage: ");
        this.logOperationCoverage(results.getOperations(), results.getCoverageOperationMap().getDeprecated());
        LOGGER.info((Object)"Empty coverage: ");
        this.logOperationCoverage(results.getOperations(), results.getCoverageOperationMap().getEmpty());
        LOGGER.info((Object)"Partial coverage: ");
        this.logOperationCoverage(results.getOperations(), results.getCoverageOperationMap().getParty());
        LOGGER.info((Object)"Full coverage: ");
        this.logOperationCoverage(results.getOperations(), results.getCoverageOperationMap().getFull());
        this.logMissedCoverage(results.getMissed());
        DecimalFormat df = new DecimalFormat("###.###");
        float deprecatedPercentage = (float)(results.getCoverageOperationMap().getDeprecated().size() * 100) / (float)results.getOperations().size();
        float emptyPercentage = (float)(results.getCoverageOperationMap().getEmpty().size() * 100) / (float)results.getOperations().size();
        float partialPercentage = (float)(results.getCoverageOperationMap().getParty().size() * 100) / (float)results.getOperations().size();
        float fullPercentage = (float)(results.getCoverageOperationMap().getFull().size() * 100) / (float)results.getOperations().size();
        LOGGER.info((Object)String.format("Conditions: %s/%s", results.getConditionCounter().getCovered(), results.getConditionCounter().getAll()));
        LOGGER.info((Object)("Deprecated coverage " + df.format(deprecatedPercentage) + " %"));
        LOGGER.info((Object)("Empty coverage " + df.format(emptyPercentage) + " %"));
        LOGGER.info((Object)("Partial coverage " + df.format(partialPercentage) + " %"));
        LOGGER.info((Object)("Full coverage " + df.format(fullPercentage) + " %"));
    }

    private void logMissedCoverage(Map<OperationKey, Operation> missed) {
        if (!missed.isEmpty()) {
            LOGGER.info((Object)"Missed coverage: ");
            missed.keySet().forEach(m -> LOGGER.info((Object)(m.getHttpMethod() + " " + m.getPath())));
        }
    }

    private void logOperationCoverage(Map<OperationKey, OperationResult> operationResults, Set<OperationKey> keys) {
        keys.forEach(operationKey -> {
            if (operationResults.containsKey(operationKey)) {
                this.printOperationCoverage((OperationResult)operationResults.get(operationKey));
            }
        });
    }

    private void printOperationCoverage(OperationResult result) {
        LOGGER.info((Object)String.format("%s %s (%s/%s)", result.getOperationKey().getHttpMethod(), result.getOperationKey().getPath(), result.getCoveredConditionCount(), result.getAllConditionCount()));
        result.getConditions().forEach(c -> {
            if (c.isCovered()) {
                LOGGER.info((Object)String.format("\u2705 %s", c.getName()));
            } else {
                LOGGER.info((Object)String.format("\u274c %s", c.getName()));
            }
        });
    }
}

