/*
 * Decompiled with CFR 0.152.
 */
package com.github.viclovsky.swagger.coverage.core.rule.body;

import com.github.viclovsky.swagger.coverage.core.model.Condition;
import com.github.viclovsky.swagger.coverage.core.rule.core.ConditionRule;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class PropertyConditionRule
extends ConditionRule {
    @Override
    public List<Condition> createCondition(Operation operation) {
        if (operation.getRequestBody() != null && operation.getRequestBody().getContent() != null) {
            return operation.getRequestBody().getContent().entrySet().stream().flatMap(m -> this.processMediaType((String)m.getKey(), (MediaType)m.getValue())).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return null;
    }

    private Stream<Condition> processMediaType(String mediaTypeName, MediaType mediaType) {
        if (mediaType.getSchema() != null && mediaType.getSchema().getProperties() != null) {
            return mediaType.getSchema().getProperties().entrySet().stream().map(s -> this.processProperty(mediaTypeName, (String)s.getKey(), (Schema)s.getValue())).filter(Objects::nonNull);
        }
        return null;
    }

    protected abstract Condition processProperty(String var1, String var2, Schema var3);
}

