/*
 * Decompiled with CFR 0.152.
 */
package com.github.viclovsky.swagger.coverage.core.results.builder.prebuilder;

import com.github.viclovsky.swagger.coverage.configuration.Configuration;
import com.github.viclovsky.swagger.coverage.core.generator.OperationConditionGenerator;
import com.github.viclovsky.swagger.coverage.core.generator.SwaggerSpecificationProcessor;
import com.github.viclovsky.swagger.coverage.core.model.Condition;
import com.github.viclovsky.swagger.coverage.core.model.ConditionOperationCoverage;
import com.github.viclovsky.swagger.coverage.core.model.OperationKey;
import com.github.viclovsky.swagger.coverage.core.model.OperationsHolder;
import com.github.viclovsky.swagger.coverage.core.results.Results;
import com.github.viclovsky.swagger.coverage.core.results.builder.core.StatisticsPreBuilder;
import com.github.viclovsky.swagger.coverage.core.results.data.ConditionStatistics;
import com.github.viclovsky.swagger.coverage.core.results.data.OperationResult;
import com.github.viclovsky.swagger.coverage.core.rule.core.ConditionRule;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;

public class CoverageStatisticsBuilder
extends StatisticsPreBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(CoverageStatisticsBuilder.class);
    private Map<OperationKey, ConditionOperationCoverage> mainCoverageData;
    private Map<OperationKey, Operation> missed = new TreeMap<OperationKey, Operation>();
    private Map<OperationKey, Operation> deprecated = new TreeMap<OperationKey, Operation>();

    @Override
    public CoverageStatisticsBuilder configure(OpenAPI swagger, List<ConditionRule> rules) {
        this.mainCoverageData = OperationConditionGenerator.getOperationMap(swagger, rules);
        return this;
    }

    @Override
    public CoverageStatisticsBuilder add(OpenAPI swagger) {
        OperationsHolder operations = SwaggerSpecificationProcessor.extractOperation(swagger);
        operations.getOperations().forEach((key, value) -> {
            LOGGER.info(String.format("==  process result [%s]", key));
            Optional<OperationKey> keyOptional = this.mainCoverageData.keySet().stream().filter(CoverageStatisticsBuilder.equalsOperationKeys(key)).findFirst();
            if (keyOptional.isPresent()) {
                this.mainCoverageData.get(keyOptional.get()).increaseProcessCount().getConditions().stream().filter(Condition::isNeedCheck).forEach(condition -> condition.check((Operation)value));
            } else {
                LOGGER.info(String.format("Missed request [%s]", key));
                this.missed.put((OperationKey)key, (Operation)value);
            }
        });
        return this;
    }

    private static Predicate<OperationKey> equalsOperationKeys(OperationKey operationKey) {
        return p -> p.getHttpMethod() == operationKey.getHttpMethod() && new AntPathMatcher().match(p.getPath(), operationKey.getPath());
    }

    @Override
    public void build(Results results, Configuration configuration) {
        TreeMap<OperationKey, OperationResult> operations = new TreeMap<OperationKey, OperationResult>();
        HashMap<String, ConditionStatistics> conditionStatisticsMap = new HashMap<String, ConditionStatistics>();
        this.mainCoverageData.forEach((key, value) -> {
            value.getConditions().stream().filter(Condition::isHasPostCheck).forEach(Condition::postCheck);
            operations.put((OperationKey)key, new OperationResult(configuration, value.getConditions(), value.getOperation().getDeprecated()).setProcessCount(value.getProcessCount()).setDescription(value.getOperation().getDescription()).setOperationKey((OperationKey)key));
            if (value.getOperation().getDeprecated() != null && value.getOperation().getDeprecated().booleanValue()) {
                this.deprecated.put((OperationKey)key, value.getOperation());
            }
            value.getConditions().forEach(condition -> {
                if (!conditionStatisticsMap.containsKey(condition.getType())) {
                    conditionStatisticsMap.put(condition.getType(), new ConditionStatistics());
                }
                ((ConditionStatistics)conditionStatisticsMap.get(condition.getType())).processCondition((OperationKey)key, (Condition)condition);
            });
        });
        results.setOperations(operations).setMissed(this.missed).setDeprecated(this.deprecated).setConditionStatisticsMap(conditionStatisticsMap);
    }
}

