"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LustreMaintenanceTime = exports.Weekday = void 0;
/**
 * Enum for representing all the days of the week
 */
var Weekday;
(function (Weekday) {
    /**
     * Sunday
     */
    Weekday["SUNDAY"] = "0";
    /**
     * Monday
     */
    Weekday["MONDAY"] = "1";
    /**
     * Tuesday
     */
    Weekday["TUESDAY"] = "2";
    /**
     * Wednesday
     */
    Weekday["WEDNESDAY"] = "3";
    /**
     * Thursday
     */
    Weekday["THURSDAY"] = "4";
    /**
     * Friday
     */
    Weekday["FRIDAY"] = "5";
    /**
     * Saturday
     */
    Weekday["SATURDAY"] = "6";
})(Weekday = exports.Weekday || (exports.Weekday = {}));
/**
 * Class for scheduling a weekly manitenance time.
 */
class LustreMaintenanceTime {
    constructor(props) {
        this.validate(props.hour, props.minute);
        this.day = props.day;
        this.hour = this.getTwoDigitString(props.hour);
        this.minute = this.getTwoDigitString(props.minute);
    }
    /**
     * Converts a day, hour, and minute into a timestamp as used by FSx for Lustre's weeklyMaintenanceStartTime field.
     */
    toTimestamp() {
        return `${this.day.valueOf()}:${this.hour}:${this.minute}`;
    }
    /**
     * Pad an integer so that it always contains at least 2 digits. Assumes the number is a positive integer.
     */
    getTwoDigitString(n) {
        const numberString = n.toString();
        if (numberString.length === 1) {
            return `0${n}`;
        }
        return numberString;
    }
    /**
     * Validation needed for the values of the maintenance time.
     */
    validate(hour, minute) {
        if (!Number.isInteger(hour) || hour < 0 || hour > 24) {
            throw new Error('Maintenance time hour must be an integer between 0 and 24');
        }
        if (!Number.isInteger(minute) || minute < 0 || minute > 59) {
            throw new Error('Maintenance time minute must be an integer between 0 and 59');
        }
    }
}
exports.LustreMaintenanceTime = LustreMaintenanceTime;
//# sourceMappingURL=data:application/json;base64,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