import pandas as pd
from salure_helpers.salure_functions import SalureFunctions


class DatevMapping:
    @staticmethod
    def map_iso2_codes_to_datev(data: pd.Series, default=None):
        """
        This function is meant to map ISO2 codes to the corresponding DATEV country code.
        :param data: input with ISO2 codes
        :param default: optional default value in case a key does not exist in the mapping. If left to None, will return original value
        :return: mapped values
        """
        mapping = {
            "AF": "423",
            "AL": "121",
            "DZ": "221",
            "AD": "123",
            "AO": "223",
            "AG": "320",
            "AR": "323",
            "AM": "422",
            "AU": "523",
            "AT": "151",
            "AZ": "425",
            "BS": "324",
            "BH": "424",
            "BD": "460",
            "BB": "322",
            "BY": "169",
            "BE": "124",
            "BZ": "330",
            "BJ": "229",
            "BT": "426",
            "BO": "326",
            "BA": "122",
            "BW": "227",
            "BR": "327",
            "IO": "595",
            "BN": "429",
            "BG": "125",
            "BF": "258",
            "BI": "291",
            "CV": "242",
            "KH": "446",
            "CM": "262",
            "CA": "348",
            "CF": "289",
            "TD": "284",
            "CL": "332",
            "CN": "479",
            "CO": "349",
            "KM": "244",
            "CD": "246",
            "CG": "245",
            "CR": "334",
            "CI": "231",
            "HR": "130",
            "CU": "351",
            "CY": "181",
            "CZ": "164",
            "DK": "126",
            "DJ": "230",
            "DM": "333",
            "DO": "335",
            "EC": "336",
            "EG": "287",
            "SV": "337",
            "GQ": "274",
            "ER": "224",
            "EE": "127",
            "SZ": "281",
            "ET": "225",
            "FJ": "526",
            "FI": "128",
            "FR": "129",
            "GA": "236",
            "GM": "237",
            "GE": "430",
            "DE": "000",
            "GH": "238",
            "GI": "195",
            "GR": "134",
            "GD": "340",
            "GT": "345",
            "GN": "261",
            "GW": "259",
            "GY": "328",
            "HT": "346",
            "VA": "167",
            "HN": "347",
            "HK": "411",
            "HU": "165",
            "IS": "136",
            "IN": "436",
            "ID": "437",
            "IR": "439",
            "IQ": "438",
            "IE": "135",
            "IL": "441",
            "IT": "137",
            "JM": "355",
            "JP": "442",
            "JO": "445",
            "KZ": "444",
            "KE": "243",
            "KI": "530",
            "KP": "434",
            "KR": "467",
            "KW": "448",
            "KG": "450",
            "LA": "449",
            "LV": "139",
            "LB": "450",
            "LS": "226",
            "LR": "247",
            "LY": "248",
            "LI": "141",
            "LT": "142",
            "LU": "143",
            "MO": "412",
            "MG": "249",
            "MW": "256",
            "MY": "482",
            "MV": "454",
            "ML": "251",
            "MT": "145",
            "MH": "544",
            "MR": "239",
            "MU": "253",
            "MX": "353",
            "FM": "545",
            "MD": "146",
            "MC": "147",
            "MN": "457",
            "ME": "140",
            "MA": "252",
            "MZ": "254",
            "MM": "427",
            "NA": "267",
            "NR": "531",
            "NP": "458",
            "NL": "148",
            "NZ": "536",
            "NI": "354",
            "NE": "255",
            "NG": "232",
            "MP": "525",
            "NO": "149",
            "OM": "456",
            "PK": "461",
            "PW": "537",
            "PS": "459",
            "PA": "357",
            "PG": "538",
            "PY": "359",
            "PE": "361",
            "PH": "462",
            "PL": "152",
            "PT": "153",
            "QA": "447",
            "MK": "144",
            "RO": "154",
            "RU": "160",
            "RW": "265",
            "KN": "370",
            "LC": "366",
            "VC": "369",
            "WS": "543",
            "SM": "156",
            "ST": "268",
            "SA": "472",
            "SN": "269",
            "RS": "170",
            "SC": "271",
            "SL": "272",
            "SG": "474",
            "SK": "155",
            "SI": "131",
            "SB": "524",
            "SO": "273",
            "ZA": "263",
            "SS": "278",
            "ES": "161",
            "LK": "431",
            "SD": "277",
            "SR": "364",
            "SE": "157",
            "CH": "158",
            "SY": "475",
            "TW": "465",
            "TJ": "470",
            "TZ": "282",
            "TH": "476",
            "TG": "283",
            "TO": "541",
            "TT": "371",
            "TN": "285",
            "TR": "163",
            "TM": "471",
            "TV": "540",
            "UG": "286",
            "UA": "166",
            "AE": "469",
            "GB": "168",
            "US": "368",
            "UY": "365",
            "UZ": "477",
            "VU": "532",
            "VE": "367",
            "VN": "432",
            "YE": "421",
            "ZM": "257",
            "ZW": "233"
        }
        return SalureFunctions.applymap(key=data, mapping=mapping, default=default)
