# Generated by Django 3.0.6 on 2020-05-10 12:49

import django.db.models.deletion
import jsonfield.fields
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="TorrentClient",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=100, unique=True)),
                ("display_name", models.CharField(max_length=100)),
                (
                    "client_type",
                    models.CharField(
                        choices=[
                            ("deluge", "Deluge"),
                            ("rtorrent", "rtorrent"),
                            ("transmission", "Transmission"),
                        ],
                        max_length=30,
                    ),
                ),
                ("config", jsonfield.fields.JSONField()),
                ("enabled", models.BooleanField(default=True)),
            ],
        ),
        migrations.CreateModel(
            name="Torrent",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("infohash", models.CharField(max_length=40)),
                ("name", models.CharField(max_length=1000)),
                ("size", models.BigIntegerField()),
                ("state", models.CharField(max_length=20)),
                ("progress", models.DecimalField(decimal_places=2, max_digits=5)),
                ("uploaded", models.BigIntegerField()),
                ("tracker", models.CharField(max_length=200)),
                ("added", models.DateTimeField()),
                ("upload_rate", models.BigIntegerField()),
                ("download_rate", models.BigIntegerField()),
                ("label", models.CharField(blank=True, default="", max_length=1000)),
                (
                    "ratio",
                    models.DecimalField(decimal_places=3, default=0.0, max_digits=8),
                ),
                (
                    "torrent_client",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="spreadsheetui.TorrentClient",
                    ),
                ),
            ],
            options={
                "unique_together": {("torrent_client", "infohash")},
            },
        ),
    ]
