# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['memrise', 'memrise.data', 'memrise.extract', 'memrise.translator']

package_data = \
{'': ['*']}

setup_kwargs = {
    'name': 'memrise',
    'version': '1.3.1rc1',
    'description': 'Scraping the vocabulary from the Memrise course',
    'long_description': '<p align="center">\n    <img src="https://raw.githubusercontent.com/tquangsdh20/memrise/main/.github/memrise.svg">\n</p>\n\n<p align="center"> \n   <a href="https://github.com/tquangsdh20/memrise/runs/4333596041"><img src="https://github.com/tquangsdh20/text2ipa/actions/workflows/test.yml/badge.svg"></a> <a href="https://app.codecov.io/gh/tquangsdh20/memrise"><img src = "https://codecov.io/gh/tquangsdh20/memrise/branch/main/graphs/badge.svg?branch=main"></a> <img src = "https://img.shields.io/pypi/pyversions/memrise"> <img src="https://img.shields.io/github/last-commit/tquangsdh20/memrise"> <img src="https://img.shields.io/github/license/tquangsdh20/memrise">\n</p>\n\n## Features:\n- Support scraping the courses in MEM to take the vocabulary\n- Translate the words to your own language\n- Get the IPA for the English course\n\n## Installation\n\n**Window**\n```msDoc\npython -m pip install memrise\n```\n**Linux**\n```\npip install memrise\n```\n**macOS**\n```\nsudo pip3 install memrise\n```\n## Appplication Requires\n\n### Install DB Browser : [SQLite](https://sqlitebrowser.org/dl/)\n\n### Install Library: \n```\npip install googletrans==4.0.0rc1\n```\n\n## Guidelines\n\n### How to take Course ID?\n\nAccess the [Memrise Website](https://app.memrise.com/course/) and copy the Course ID as the following picture\n\n<p align="center">\n  <img src="https://raw.githubusercontent.com/tquangsdh20/memrise/main/.github/courseid.svg">\n</p>\n\n### Import library and initialize database\n\n```python\nfrom memrise import Course, Data\n#Create file database output\ndb = Data(\'English.db\') # Or *.sqlite easy to open\n#Connect to file database and init\ndb.init_database()\n```\n\n### Scraping course with ID\n\nThe following example is scraping [the English course](https://app.memrise.com/course/2157577/anglais-britannique-2/) for the French \n\n```python\n# Connect the course to scraping info this maybe take a few momment.\ncourse = Course(2157577)\n# Update information about the course\ndb.update_course(course)\n```\n\n### Update the IPA in database\n\nUse the method `update_ipa()` if the **Language Course** is **English** for update the IPA information auto.  \nThe parameter `language` default is `br`  \n- `br` : English UK\n- `am` : English US\n\n```python\n# Update IPA for database with default `br`\ndb.update_ipa()\n# Use the follow if English US\n# db.update_ipa(\'am\')\n```\n\n### Translate the vocaburaly to your own language\n\nUse the method `update_trans(language)`  \n\nThe parameter `language` follow the [ISO 639-1 codes](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) as the bottom\n\n```python\n# Translate to Vietnamese\ndb.update_trans(\'vi\')\n```\n\n### Show the output with SQLite Browser Application\n\nOpen the SQLite Browser Application and follow the steps below\n\n<p align="center">\n  <img src="https://raw.githubusercontent.com/tquangsdh20/memrise/main/.github/output1.svg">\n</p>\n\n<p align="center">\n   <img src="https://raw.githubusercontent.com/tquangsdh20/memrise/main/.github/output2.svg"> \n</p>\n\nFeel free to make your own course with the SQL query\n\nSteps : **Execute SQL > Typing SQL Statements > Run**\n\n```SQL\nSELECT word, sub, IPA FROM words ; \n```\n\n<p align="center">\n  <img src="https://raw.githubusercontent.com/tquangsdh20/memrise/main/.github/sql.svg">\n</p>\n\n## Languages ISO369-1 Code\n\n\n```\naf : afrikaans                 fy : frisian                   ky : kyrgyz                sr : serbian\nsq : albanian                  gl : galician                  lo : lao                   st : sesotho\nam : amharic                   ka : georgian                  la : latin                 sn : shona\nar : arabic                    de : german                    lv : latvian               sd : sindhi\nhy : armenian                  el : greek                     lt : lithuanian            si : sinhala\naz : azerbaijani               gu : gujarati                  lb : luxembourgish         sk : slovak\neu : basque                    ht : haitian creole            mk : macedonian            sl : slovenian\nbe : belarusian                ha : hausa                     mg : malagasy              so : somali\nbn : bengali                   haw : hawaiian                 ms : malay                 es : spanish\nbs : bosnian                   iw : hebrew                    ml : malayalam             su : sundanese\nbg : bulgarian                 he : hebrew                    mt : maltese               sw : swahili\nca : catalan                   hi : hindi                     mi : maori                 sv : swedish\nceb : cebuano                  hmn : hmong                    mr : marathi               tg : tajik\nny : chichewa                  hu : hungarian                 mn : mongolian             ta : tamil\nzh-cn : chinese (simplified)   is : icelandic                 my : myanmar (burmese)     te : telugu\nzh-tw : chinese (traditional)  ig : igbo                      ne : nepali                th : thai\nco : corsican                  id : indonesian                no : norwegian             tr : turkish\nhr : croatian                  ga : irish                     or : odia                  uk : ukrainian\ncs : czech                     it : italian                   ps : pashto                ur : urdu\nda : danish                    ja : japanese                  fa : persian               ug : uyghur\nnl : dutch                     jw : javanese                  pl : polish                uz : uzbek\nen : english                   kn : kannada                   pt : portuguese            vi : vietnamese\neo : esperanto                 kk : kazakh                    pa : punjabi               cy : welsh\net : estonian                  km : khmer                     ro : romanian              xh : xhosa\ntl : filipino                  ko : korean                    ru : russian               yi : yiddish\nfi : finnish                   ku : kurdish (kurmanji)        sm : samoan                yo : yoruba\nfr : french                    gd : scots gaelic              zu : zulu       \n```\n\n### Log changes:\n\n**v1.0.0**: Implementation Scrapping Vocabulary  \n**v1.1.0**: Update IPA Function   \n**v1.2.1** : Release check for fixing ERROR IPA and update new TRANSLATE FUNCTION  \n\n<a href="https://github.com/tquangsdh20/memrise"><p align="center"><img src="https://img.shields.io/badge/Github-tquangsdh20-orange?style=social&logo=github"></p></a>\n',
    'author': 'Joseph Quang',
    'author_email': 'tquangsdh20@hcmut.edu.vn',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/tquangsdh20/memrise',
    'packages': packages,
    'package_data': package_data,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
